// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  aa0  {
  int a;
   aa0(); // _ZN3aa0C1Ev
  virtual void  foo(); // _ZN3aa03fooEv
  ~aa0(); // tgen
};
//SIG(-1 aa0) C1{ v1 Fi}


 aa0 ::aa0(){ note_ctor("aa0", this);}
void  aa0 ::foo(){vfunc_called(this, "_ZN3aa03fooEv");}
aa0 ::~aa0(){ note_dtor("aa0", this);} // tgen

static void Test_aa0()
{
  extern Class_Descriptor cd_aa0;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa0, buf);
    aa0 *dp, &lv = *(dp=new (buf) aa0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa0)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa0)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa0.a");
    test_class_info(&lv, &cd_aa0);
    dp->~aa0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa0(Test_aa0, "aa0", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aa0C1Ev();
extern void _ZN3aa0D1Ev();
Name_Map name_map_aa0[] = {
  NSPAIR(_ZN3aa0C1Ev),
  NSPAIR(_ZN3aa0D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3aa0[];
extern void _ZN3aa03fooEv();
static  VTBL_ENTRY vtc_aa0[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3aa0[0]),
  (VTBL_ENTRY)&_ZN3aa03fooEv,
};
extern VTBL_ENTRY _ZTI3aa0[];
extern  VTBL_ENTRY _ZTV3aa0[];
Class_Descriptor cd_aa0 = {  "aa0", // class name
  0,0,//no base classes
  &(vtc_aa0[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3aa0),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3aa0),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb0  {
  int b;
   bb0(); // _ZN3bb0C1Ev
  virtual void  foo(); // _ZN3bb03fooEv
  ~bb0(); // tgen
};
//SIG(-1 bb0) C1{ v1 Fi}


 bb0 ::bb0(){ note_ctor("bb0", this);}
void  bb0 ::foo(){vfunc_called(this, "_ZN3bb03fooEv");}
bb0 ::~bb0(){ note_dtor("bb0", this);} // tgen

static void Test_bb0()
{
  extern Class_Descriptor cd_bb0;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb0, buf);
    bb0 *dp, &lv = *(dp=new (buf) bb0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb0)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb0)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb0.b");
    test_class_info(&lv, &cd_bb0);
    dp->~bb0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb0(Test_bb0, "bb0", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3bb0C1Ev();
extern void _ZN3bb0D1Ev();
Name_Map name_map_bb0[] = {
  NSPAIR(_ZN3bb0C1Ev),
  NSPAIR(_ZN3bb0D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3bb0[];
extern void _ZN3bb03fooEv();
static  VTBL_ENTRY vtc_bb0[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3bb0[0]),
  (VTBL_ENTRY)&_ZN3bb03fooEv,
};
extern VTBL_ENTRY _ZTI3bb0[];
extern  VTBL_ENTRY _ZTV3bb0[];
Class_Descriptor cd_bb0 = {  "bb0", // class name
  0,0,//no base classes
  &(vtc_bb0[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3bb0),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3bb0),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc0  {
  int c;
   cc0(); // _ZN3cc0C1Ev
  virtual void  foo(); // _ZN3cc03fooEv
  ~cc0(); // tgen
};
//SIG(-1 cc0) C1{ v1 Fi}


 cc0 ::cc0(){ note_ctor("cc0", this);}
void  cc0 ::foo(){vfunc_called(this, "_ZN3cc03fooEv");}
cc0 ::~cc0(){ note_dtor("cc0", this);} // tgen

static void Test_cc0()
{
  extern Class_Descriptor cd_cc0;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc0, buf);
    cc0 *dp, &lv = *(dp=new (buf) cc0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc0)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc0)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc0.c");
    test_class_info(&lv, &cd_cc0);
    dp->~cc0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc0(Test_cc0, "cc0", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3cc0C1Ev();
extern void _ZN3cc0D1Ev();
Name_Map name_map_cc0[] = {
  NSPAIR(_ZN3cc0C1Ev),
  NSPAIR(_ZN3cc0D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3cc0[];
extern void _ZN3cc03fooEv();
static  VTBL_ENTRY vtc_cc0[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3cc0[0]),
  (VTBL_ENTRY)&_ZN3cc03fooEv,
};
extern VTBL_ENTRY _ZTI3cc0[];
extern  VTBL_ENTRY _ZTV3cc0[];
Class_Descriptor cd_cc0 = {  "cc0", // class name
  0,0,//no base classes
  &(vtc_cc0[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3cc0),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3cc0),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd0  {
  int d;
   dd0(); // _ZN3dd0C1Ev
  virtual void  foo(); // _ZN3dd03fooEv
  ~dd0(); // tgen
};
//SIG(-1 dd0) C1{ v1 Fi}


 dd0 ::dd0(){ note_ctor("dd0", this);}
void  dd0 ::foo(){vfunc_called(this, "_ZN3dd03fooEv");}
dd0 ::~dd0(){ note_dtor("dd0", this);} // tgen

static void Test_dd0()
{
  extern Class_Descriptor cd_dd0;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd0, buf);
    dd0 *dp, &lv = *(dp=new (buf) dd0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd0)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd0)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd0.d");
    test_class_info(&lv, &cd_dd0);
    dp->~dd0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd0(Test_dd0, "dd0", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3dd0C1Ev();
extern void _ZN3dd0D1Ev();
Name_Map name_map_dd0[] = {
  NSPAIR(_ZN3dd0C1Ev),
  NSPAIR(_ZN3dd0D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3dd0[];
extern void _ZN3dd03fooEv();
static  VTBL_ENTRY vtc_dd0[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3dd0[0]),
  (VTBL_ENTRY)&_ZN3dd03fooEv,
};
extern VTBL_ENTRY _ZTI3dd0[];
extern  VTBL_ENTRY _ZTV3dd0[];
Class_Descriptor cd_dd0 = {  "dd0", // class name
  0,0,//no base classes
  &(vtc_dd0[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3dd0),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3dd0),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee0  : aa0 , bb0 {
  int e;
   ee0(); // _ZN3ee0C1Ev
  virtual void  foo(); // _ZN3ee03fooEv
  ~ee0(); // tgen
};
//SIG(-1 ee0) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ee0 ::ee0(){ note_ctor("ee0", this);}
void  ee0 ::foo(){vfunc_called(this, "_ZN3ee03fooEv");}
ee0 ::~ee0(){ note_dtor("ee0", this);} // tgen

static void Test_ee0()
{
  extern Class_Descriptor cd_ee0;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee0, buf);
    ee0 *dp, &lv = *(dp=new (buf) ee0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee0)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee0)");
    check_base_class_offset(lv, (aa0*), 0, "ee0");
    check_base_class_offset(lv, (bb0*), ABISELECT(16,8), "ee0");
    check_field_offset(lv, e, ABISELECT(28,16), "ee0.e");
    test_class_info(&lv, &cd_ee0);
    dp->~ee0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee0(Test_ee0, "ee0", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3ee0C1Ev();
extern void _ZN3ee0D1Ev();
Name_Map name_map_ee0[] = {
  NSPAIR(_ZN3ee0C1Ev),
  NSPAIR(_ZN3ee0D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern  VTBL_ENTRY _ZTV3aa0[];
extern Class_Descriptor cd_bb0;
extern VTBL_ENTRY _ZTI3bb0[];
extern  VTBL_ENTRY _ZTV3bb0[];
static Base_Class bases_ee0[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_bb0,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3ee0[];
extern void _ZN3ee03fooEv();
extern void ABISELECT(_ZThn16_N3ee03fooEv,_ZThn8_N3ee03fooEv)();
static  VTBL_ENTRY vtc_ee0[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3ee0[0]),
  (VTBL_ENTRY)&_ZN3ee03fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3ee0[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3ee03fooEv,_ZThn8_N3ee03fooEv),
};
extern VTBL_ENTRY _ZTI3ee0[];
extern  VTBL_ENTRY _ZTV3ee0[];
Class_Descriptor cd_ee0 = {  "ee0", // class name
  bases_ee0, 2,
  &(vtc_ee0[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3ee0),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3ee0),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff0  : cc0 , dd0 {
  int f;
   ff0(); // _ZN3ff0C1Ev
  virtual void  foo(); // _ZN3ff03fooEv
  ~ff0(); // tgen
};
//SIG(-1 ff0) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ff0 ::ff0(){ note_ctor("ff0", this);}
void  ff0 ::foo(){vfunc_called(this, "_ZN3ff03fooEv");}
ff0 ::~ff0(){ note_dtor("ff0", this);} // tgen

static void Test_ff0()
{
  extern Class_Descriptor cd_ff0;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff0, buf);
    ff0 *dp, &lv = *(dp=new (buf) ff0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff0)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff0)");
    check_base_class_offset(lv, (cc0*), 0, "ff0");
    check_base_class_offset(lv, (dd0*), ABISELECT(16,8), "ff0");
    check_field_offset(lv, f, ABISELECT(28,16), "ff0.f");
    test_class_info(&lv, &cd_ff0);
    dp->~ff0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff0(Test_ff0, "ff0", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3ff0C1Ev();
extern void _ZN3ff0D1Ev();
Name_Map name_map_ff0[] = {
  NSPAIR(_ZN3ff0C1Ev),
  NSPAIR(_ZN3ff0D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc0;
extern VTBL_ENTRY _ZTI3cc0[];
extern  VTBL_ENTRY _ZTV3cc0[];
extern Class_Descriptor cd_dd0;
extern VTBL_ENTRY _ZTI3dd0[];
extern  VTBL_ENTRY _ZTV3dd0[];
static Base_Class bases_ff0[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc0,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_dd0,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3ff0[];
extern void _ZN3ff03fooEv();
extern void ABISELECT(_ZThn16_N3ff03fooEv,_ZThn8_N3ff03fooEv)();
static  VTBL_ENTRY vtc_ff0[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3ff0[0]),
  (VTBL_ENTRY)&_ZN3ff03fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3ff0[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3ff03fooEv,_ZThn8_N3ff03fooEv),
};
extern VTBL_ENTRY _ZTI3ff0[];
extern  VTBL_ENTRY _ZTV3ff0[];
Class_Descriptor cd_ff0 = {  "ff0", // class name
  bases_ff0, 2,
  &(vtc_ff0[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3ff0),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3ff0),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg0  : ee0 , ff0 {
  int g;
   gg0(); // _ZN3gg0C1Ev
  virtual void  foo(); // _ZN3gg03fooEv
  ~gg0(); // tgen
};
//SIG(1 gg0) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 Fi} BC7{ v1 Fi} v1 Fi} v1 Fi}


 gg0 ::gg0(){ note_ctor("gg0", this);}
void  gg0 ::foo(){vfunc_called(this, "_ZN3gg03fooEv");}
gg0 ::~gg0(){ note_dtor("gg0", this);} // tgen

static void Test_gg0()
{
  extern Class_Descriptor cd_gg0;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg0, buf);
    gg0 *dp, &lv = *(dp=new (buf) gg0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg0)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg0)");
    check_base_class_offset(lv, (aa0*)(ee0*), 0, "gg0");
    check_base_class_offset(lv, (bb0*)(ee0*), ABISELECT(16,8), "gg0");
    check_base_class_offset(lv, (ee0*), 0, "gg0");
    check_base_class_offset(lv, (cc0*)(ff0*), ABISELECT(32,20), "gg0");
    check_base_class_offset(lv, (dd0*)(ff0*), ABISELECT(48,28), "gg0");
    check_base_class_offset(lv, (ff0*), ABISELECT(32,20), "gg0");
    check_field_offset(lv, g, ABISELECT(64,40), "gg0.g");
    test_class_info(&lv, &cd_gg0);
    dp->~gg0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg0(Test_gg0, "gg0", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3gg0C1Ev();
extern void _ZN3gg0D1Ev();
Name_Map name_map_gg0[] = {
  NSPAIR(_ZN3gg0C1Ev),
  NSPAIR(_ZN3gg0D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa0;
extern VTBL_ENTRY _ZTI3aa0[];
extern  VTBL_ENTRY _ZTV3aa0[];
extern Class_Descriptor cd_bb0;
extern VTBL_ENTRY _ZTI3bb0[];
extern  VTBL_ENTRY _ZTV3bb0[];
extern Class_Descriptor cd_ee0;
extern VTBL_ENTRY _ZTI3ee0[];
extern  VTBL_ENTRY _ZTV3ee0[];
extern Class_Descriptor cd_cc0;
extern VTBL_ENTRY _ZTI3cc0[];
extern  VTBL_ENTRY _ZTV3cc0[];
extern Class_Descriptor cd_dd0;
extern VTBL_ENTRY _ZTI3dd0[];
extern  VTBL_ENTRY _ZTV3dd0[];
extern Class_Descriptor cd_ff0;
extern VTBL_ENTRY _ZTI3ff0[];
extern  VTBL_ENTRY _ZTV3ff0[];
static Base_Class bases_gg0[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa0,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_bb0,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_ee0,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc0,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_dd0,    ABISELECT(48,28), //bcp->offset
    9, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_ff0,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3gg0[];
extern void _ZN3gg03fooEv();
extern void ABISELECT(_ZThn16_N3gg03fooEv,_ZThn8_N3gg03fooEv)();
extern void ABISELECT(_ZThn32_N3gg03fooEv,_ZThn20_N3gg03fooEv)();
extern void ABISELECT(_ZThn48_N3gg03fooEv,_ZThn28_N3gg03fooEv)();
static  VTBL_ENTRY vtc_gg0[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3gg0[0]),
  (VTBL_ENTRY)&_ZN3gg03fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3gg0[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3gg03fooEv,_ZThn8_N3gg03fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI3gg0[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3gg03fooEv,_ZThn20_N3gg03fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI3gg0[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3gg03fooEv,_ZThn28_N3gg03fooEv),
};
extern VTBL_ENTRY _ZTI3gg0[];
extern  VTBL_ENTRY _ZTV3gg0[];
Class_Descriptor cd_gg0 = {  "gg0", // class name
  bases_gg0, 6,
  &(vtc_gg0[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI3gg0),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3gg0),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa1  {
  int a;
   aa1(); // _ZN3aa1C1Ev
  virtual void  foo(); // _ZN3aa13fooEv
  ~aa1(); // tgen
};
//SIG(-1 aa1) C1{ v1 Fi}


 aa1 ::aa1(){ note_ctor("aa1", this);}
void  aa1 ::foo(){vfunc_called(this, "_ZN3aa13fooEv");}
aa1 ::~aa1(){ note_dtor("aa1", this);} // tgen

static void Test_aa1()
{
  extern Class_Descriptor cd_aa1;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa1, buf);
    aa1 *dp, &lv = *(dp=new (buf) aa1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa1)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa1.a");
    test_class_info(&lv, &cd_aa1);
    dp->~aa1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa1(Test_aa1, "aa1", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aa1C1Ev();
extern void _ZN3aa1D1Ev();
Name_Map name_map_aa1[] = {
  NSPAIR(_ZN3aa1C1Ev),
  NSPAIR(_ZN3aa1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3aa1[];
extern void _ZN3aa13fooEv();
static  VTBL_ENTRY vtc_aa1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3aa1[0]),
  (VTBL_ENTRY)&_ZN3aa13fooEv,
};
extern VTBL_ENTRY _ZTI3aa1[];
extern  VTBL_ENTRY _ZTV3aa1[];
Class_Descriptor cd_aa1 = {  "aa1", // class name
  0,0,//no base classes
  &(vtc_aa1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3aa1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3aa1),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb1  {
  int b;
   bb1(); // _ZN3bb1C1Ev
  virtual void  foo(); // _ZN3bb13fooEv
  ~bb1(); // tgen
};
//SIG(-1 bb1) C1{ v1 Fi}


 bb1 ::bb1(){ note_ctor("bb1", this);}
void  bb1 ::foo(){vfunc_called(this, "_ZN3bb13fooEv");}
bb1 ::~bb1(){ note_dtor("bb1", this);} // tgen

static void Test_bb1()
{
  extern Class_Descriptor cd_bb1;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb1, buf);
    bb1 *dp, &lv = *(dp=new (buf) bb1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb1)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb1.b");
    test_class_info(&lv, &cd_bb1);
    dp->~bb1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb1(Test_bb1, "bb1", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3bb1C1Ev();
extern void _ZN3bb1D1Ev();
Name_Map name_map_bb1[] = {
  NSPAIR(_ZN3bb1C1Ev),
  NSPAIR(_ZN3bb1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3bb1[];
extern void _ZN3bb13fooEv();
static  VTBL_ENTRY vtc_bb1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3bb1[0]),
  (VTBL_ENTRY)&_ZN3bb13fooEv,
};
extern VTBL_ENTRY _ZTI3bb1[];
extern  VTBL_ENTRY _ZTV3bb1[];
Class_Descriptor cd_bb1 = {  "bb1", // class name
  0,0,//no base classes
  &(vtc_bb1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3bb1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3bb1),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc1  {
  int c;
   cc1(); // _ZN3cc1C1Ev
  virtual void  foo(); // _ZN3cc13fooEv
  ~cc1(); // tgen
};
//SIG(-1 cc1) C1{ v1 Fi}


 cc1 ::cc1(){ note_ctor("cc1", this);}
void  cc1 ::foo(){vfunc_called(this, "_ZN3cc13fooEv");}
cc1 ::~cc1(){ note_dtor("cc1", this);} // tgen

static void Test_cc1()
{
  extern Class_Descriptor cd_cc1;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc1, buf);
    cc1 *dp, &lv = *(dp=new (buf) cc1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc1)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc1.c");
    test_class_info(&lv, &cd_cc1);
    dp->~cc1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc1(Test_cc1, "cc1", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3cc1C1Ev();
extern void _ZN3cc1D1Ev();
Name_Map name_map_cc1[] = {
  NSPAIR(_ZN3cc1C1Ev),
  NSPAIR(_ZN3cc1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3cc1[];
extern void _ZN3cc13fooEv();
static  VTBL_ENTRY vtc_cc1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3cc1[0]),
  (VTBL_ENTRY)&_ZN3cc13fooEv,
};
extern VTBL_ENTRY _ZTI3cc1[];
extern  VTBL_ENTRY _ZTV3cc1[];
Class_Descriptor cd_cc1 = {  "cc1", // class name
  0,0,//no base classes
  &(vtc_cc1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3cc1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3cc1),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd1  {
  int d;
   dd1(); // _ZN3dd1C1Ev
  virtual void  foo(); // _ZN3dd13fooEv
  ~dd1(); // tgen
};
//SIG(-1 dd1) C1{ v1 Fi}


 dd1 ::dd1(){ note_ctor("dd1", this);}
void  dd1 ::foo(){vfunc_called(this, "_ZN3dd13fooEv");}
dd1 ::~dd1(){ note_dtor("dd1", this);} // tgen

static void Test_dd1()
{
  extern Class_Descriptor cd_dd1;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd1, buf);
    dd1 *dp, &lv = *(dp=new (buf) dd1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd1)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd1.d");
    test_class_info(&lv, &cd_dd1);
    dp->~dd1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd1(Test_dd1, "dd1", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3dd1C1Ev();
extern void _ZN3dd1D1Ev();
Name_Map name_map_dd1[] = {
  NSPAIR(_ZN3dd1C1Ev),
  NSPAIR(_ZN3dd1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3dd1[];
extern void _ZN3dd13fooEv();
static  VTBL_ENTRY vtc_dd1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3dd1[0]),
  (VTBL_ENTRY)&_ZN3dd13fooEv,
};
extern VTBL_ENTRY _ZTI3dd1[];
extern  VTBL_ENTRY _ZTV3dd1[];
Class_Descriptor cd_dd1 = {  "dd1", // class name
  0,0,//no base classes
  &(vtc_dd1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3dd1),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3dd1),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee1  : virtual aa1 , bb1 {
  int e;
   ee1(const ABISELECT(__tsi64,int) *const *); // _ZN3ee1C2Ev
  virtual void  foo(); // _ZN3ee13fooEv
  ~ee1(); // tgen
  ee1(); // tgen
};
//SIG(-1 ee1) C1{ VBC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ee1 ::ee1(const ABISELECT(__tsi64,int) *const *){}
void  ee1 ::foo(){vfunc_called(this, "_ZN3ee13fooEv");}
ee1 ::~ee1(){ note_dtor("ee1", this);} // tgen
ee1 ::ee1(){ note_ctor("ee1", this);} // tgen

static void Test_ee1()
{
  extern Class_Descriptor cd_ee1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee1, buf);
    ee1 *dp, &lv = *(dp=new (buf) ee1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee1)");
    check_base_class_offset(lv, (aa1*), ABISELECT(16,12), "ee1");
    check_base_class_offset(lv, (bb1*), 0, "ee1");
    check_field_offset(lv, e, ABISELECT(12,8), "ee1.e");
    test_class_info(&lv, &cd_ee1);
    dp->~ee1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee1(Test_ee1, "ee1", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3ee1C1Ev();
extern void _ZN3ee1D1Ev();
Name_Map name_map_ee1[] = {
  NSPAIR(_ZN3ee1C1Ev),
  NSPAIR(_ZN3ee1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa1;
extern VTBL_ENTRY _ZTI3aa1[];
extern  VTBL_ENTRY _ZTV3aa1[];
extern Class_Descriptor cd_bb1;
extern VTBL_ENTRY _ZTI3bb1[];
extern  VTBL_ENTRY _ZTV3bb1[];
static Base_Class bases_ee1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa1,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_bb1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3ee1[];
extern void _ZN3ee13fooEv();
extern void ABISELECT(_ZTv0_n24_N3ee13fooEv,_ZTv0_n12_N3ee13fooEv)();
extern void ABISELECT(_ZThn16_N3ee13fooEv,_ZThn12_N3ee13fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee1[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI3ee1[0]),
  (VTBL_ENTRY)&_ZN3ee13fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI3ee1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ee13fooEv,_ZTv0_n12_N3ee13fooEv),
};
extern VTBL_ENTRY _ZTV3ee1[];
static  VTT_ENTRY vtt_ee1[] = {
  {&(_ZTV3ee1[3]),  3,8},
  {&(_ZTV3ee1[7]),  7,8},
};
extern VTBL_ENTRY _ZTI3ee1[];
extern  VTBL_ENTRY _ZTV3ee1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3ee1[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ee13fooEv,_ZTv0_n12_N3ee13fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3ee13fooEv,_ZThn12_N3ee13fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee1 = {  "ee1", // class name
  bases_ee1, 2,
  &(vtc_ee1[0]), // expected_vtbl_contents
  &(vtt_ee1[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3ee1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3ee1),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3ee1),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff1  : cc1 , dd1 {
  int f;
   ff1(); // _ZN3ff1C1Ev
  virtual void  foo(); // _ZN3ff13fooEv
  ~ff1(); // tgen
};
//SIG(-1 ff1) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ff1 ::ff1(){ note_ctor("ff1", this);}
void  ff1 ::foo(){vfunc_called(this, "_ZN3ff13fooEv");}
ff1 ::~ff1(){ note_dtor("ff1", this);} // tgen

static void Test_ff1()
{
  extern Class_Descriptor cd_ff1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff1, buf);
    ff1 *dp, &lv = *(dp=new (buf) ff1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff1)");
    check_base_class_offset(lv, (cc1*), 0, "ff1");
    check_base_class_offset(lv, (dd1*), ABISELECT(16,8), "ff1");
    check_field_offset(lv, f, ABISELECT(28,16), "ff1.f");
    test_class_info(&lv, &cd_ff1);
    dp->~ff1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff1(Test_ff1, "ff1", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3ff1C1Ev();
extern void _ZN3ff1D1Ev();
Name_Map name_map_ff1[] = {
  NSPAIR(_ZN3ff1C1Ev),
  NSPAIR(_ZN3ff1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc1;
extern VTBL_ENTRY _ZTI3cc1[];
extern  VTBL_ENTRY _ZTV3cc1[];
extern Class_Descriptor cd_dd1;
extern VTBL_ENTRY _ZTI3dd1[];
extern  VTBL_ENTRY _ZTV3dd1[];
static Base_Class bases_ff1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_dd1,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3ff1[];
extern void _ZN3ff13fooEv();
extern void ABISELECT(_ZThn16_N3ff13fooEv,_ZThn8_N3ff13fooEv)();
static  VTBL_ENTRY vtc_ff1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3ff1[0]),
  (VTBL_ENTRY)&_ZN3ff13fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3ff1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3ff13fooEv,_ZThn8_N3ff13fooEv),
};
extern VTBL_ENTRY _ZTI3ff1[];
extern  VTBL_ENTRY _ZTV3ff1[];
Class_Descriptor cd_ff1 = {  "ff1", // class name
  bases_ff1, 2,
  &(vtc_ff1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3ff1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3ff1),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg1  : ee1 , ff1 {
  int g;
   gg1(const ABISELECT(__tsi64,int) *const *); // _ZN3gg1C2Ev
  virtual void  foo(); // _ZN3gg13fooEv
  ~gg1(); // tgen
  gg1(); // tgen
};
//SIG(1 gg1) C1{ BC2{ VBC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 Fi} BC7{ v1 Fi} v1 Fi} v1 Fi}


 gg1 ::gg1(const ABISELECT(__tsi64,int) *const *){}
void  gg1 ::foo(){vfunc_called(this, "_ZN3gg13fooEv");}
gg1 ::~gg1(){ note_dtor("gg1", this);} // tgen
gg1 ::gg1(){ note_ctor("gg1", this);} // tgen

static void Test_gg1()
{
  extern Class_Descriptor cd_gg1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg1, buf);
    gg1 *dp, &lv = *(dp=new (buf) gg1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg1)");
    check_base_class_offset(lv, (aa1*)(ee1*), ABISELECT(56,36), "gg1");
    check_base_class_offset(lv, (bb1*)(ee1*), 0, "gg1");
    check_base_class_offset(lv, (ee1*), 0, "gg1");
    check_base_class_offset(lv, (cc1*)(ff1*), ABISELECT(16,12), "gg1");
    check_base_class_offset(lv, (dd1*)(ff1*), ABISELECT(32,20), "gg1");
    check_base_class_offset(lv, (ff1*), ABISELECT(16,12), "gg1");
    check_field_offset(lv, g, ABISELECT(48,32), "gg1.g");
    test_class_info(&lv, &cd_gg1);
    dp->~gg1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg1(Test_gg1, "gg1", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3gg1C1Ev();
extern void _ZN3gg1D1Ev();
Name_Map name_map_gg1[] = {
  NSPAIR(_ZN3gg1C1Ev),
  NSPAIR(_ZN3gg1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa1;
extern VTBL_ENTRY _ZTI3aa1[];
extern  VTBL_ENTRY _ZTV3aa1[];
extern Class_Descriptor cd_bb1;
extern VTBL_ENTRY _ZTI3bb1[];
extern  VTBL_ENTRY _ZTV3bb1[];
extern Class_Descriptor cd_ee1;
extern VTBL_ENTRY _ZTI3ee1[];
extern  VTBL_ENTRY _ZTV3ee1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3ee1[];
extern Class_Descriptor cd_cc1;
extern VTBL_ENTRY _ZTI3cc1[];
extern  VTBL_ENTRY _ZTV3cc1[];
extern Class_Descriptor cd_dd1;
extern VTBL_ENTRY _ZTI3dd1[];
extern  VTBL_ENTRY _ZTV3dd1[];
extern Class_Descriptor cd_ff1;
extern VTBL_ENTRY _ZTI3ff1[];
extern  VTBL_ENTRY _ZTV3ff1[];
static Base_Class bases_gg1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa1,    ABISELECT(56,36), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_bb1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_ee1,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc1,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_dd1,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_ff1,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3gg1[];
extern void _ZN3gg13fooEv();
extern void ABISELECT(_ZThn16_N3gg13fooEv,_ZThn12_N3gg13fooEv)();
extern void ABISELECT(_ZThn32_N3gg13fooEv,_ZThn20_N3gg13fooEv)();
extern void ABISELECT(_ZTv0_n24_N3gg13fooEv,_ZTv0_n12_N3gg13fooEv)();
extern void ABISELECT(_ZThn56_N3gg13fooEv,_ZThn36_N3gg13fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg1[] = {
  ABISELECT(56,36),
  0,
  (VTBL_ENTRY)&(_ZTI3gg1[0]),
  (VTBL_ENTRY)&_ZN3gg13fooEv,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI3gg1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3gg13fooEv,_ZThn12_N3gg13fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI3gg1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3gg13fooEv,_ZThn20_N3gg13fooEv),
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI3gg1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3gg13fooEv,_ZTv0_n12_N3gg13fooEv),
};
extern VTBL_ENTRY _ZTV3gg1[];
extern void _ZN3ee13fooEv();
static  VTBL_ENTRY _tg__ZTV3ee1__3gg1[] = {
  ABISELECT(56,36),
  0,
  (VTBL_ENTRY)&(_ZTI3ee1[0]),
  (VTBL_ENTRY)&_ZN3ee13fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3ee13fooEv,_ZTv0_n12_N3ee13fooEv)();
extern void ABISELECT(_ZThn56_N3ee13fooEv,_ZThn36_N3ee13fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3aa1__3ee1__3gg1[] = {
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI3ee1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ee13fooEv,_ZTv0_n12_N3ee13fooEv),
};
static  VTT_ENTRY vtt_gg1[] = {
  {&(_ZTV3gg1[3]),  3,14},
  {&(_tg__ZTV3ee1__3gg1[3]),  3,4},
  {&(_tg__ZTV3aa1__3ee1__3gg1[3]),  3,4},
  {&(_ZTV3gg1[13]),  13,14},
};
extern VTBL_ENTRY _ZTI3gg1[];
extern  VTBL_ENTRY _ZTV3gg1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3gg1[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ee13fooEv,_ZTv0_n12_N3ee13fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N3ee13fooEv,_ZThn36_N3ee13fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3gg13fooEv,_ZTv0_n12_N3gg13fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N3gg13fooEv,_ZThn36_N3gg13fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg1 = {  "gg1", // class name
  bases_gg1, 6,
  &(vtc_gg1[0]), // expected_vtbl_contents
  &(vtt_gg1[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI3gg1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3gg1),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3gg1),4, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa2  {
  int a;
   aa2(); // _ZN3aa2C1Ev
  virtual void  foo(); // _ZN3aa23fooEv
  ~aa2(); // tgen
};
//SIG(-1 aa2) C1{ v1 Fi}


 aa2 ::aa2(){ note_ctor("aa2", this);}
void  aa2 ::foo(){vfunc_called(this, "_ZN3aa23fooEv");}
aa2 ::~aa2(){ note_dtor("aa2", this);} // tgen

static void Test_aa2()
{
  extern Class_Descriptor cd_aa2;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa2, buf);
    aa2 *dp, &lv = *(dp=new (buf) aa2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa2)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa2.a");
    test_class_info(&lv, &cd_aa2);
    dp->~aa2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa2(Test_aa2, "aa2", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aa2C1Ev();
extern void _ZN3aa2D1Ev();
Name_Map name_map_aa2[] = {
  NSPAIR(_ZN3aa2C1Ev),
  NSPAIR(_ZN3aa2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3aa2[];
extern void _ZN3aa23fooEv();
static  VTBL_ENTRY vtc_aa2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3aa2[0]),
  (VTBL_ENTRY)&_ZN3aa23fooEv,
};
extern VTBL_ENTRY _ZTI3aa2[];
extern  VTBL_ENTRY _ZTV3aa2[];
Class_Descriptor cd_aa2 = {  "aa2", // class name
  0,0,//no base classes
  &(vtc_aa2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3aa2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3aa2),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb2  {
  int b;
   bb2(); // _ZN3bb2C1Ev
  virtual void  foo(); // _ZN3bb23fooEv
  ~bb2(); // tgen
};
//SIG(-1 bb2) C1{ v1 Fi}


 bb2 ::bb2(){ note_ctor("bb2", this);}
void  bb2 ::foo(){vfunc_called(this, "_ZN3bb23fooEv");}
bb2 ::~bb2(){ note_dtor("bb2", this);} // tgen

static void Test_bb2()
{
  extern Class_Descriptor cd_bb2;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb2, buf);
    bb2 *dp, &lv = *(dp=new (buf) bb2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb2)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb2.b");
    test_class_info(&lv, &cd_bb2);
    dp->~bb2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb2(Test_bb2, "bb2", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3bb2C1Ev();
extern void _ZN3bb2D1Ev();
Name_Map name_map_bb2[] = {
  NSPAIR(_ZN3bb2C1Ev),
  NSPAIR(_ZN3bb2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3bb2[];
extern void _ZN3bb23fooEv();
static  VTBL_ENTRY vtc_bb2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3bb2[0]),
  (VTBL_ENTRY)&_ZN3bb23fooEv,
};
extern VTBL_ENTRY _ZTI3bb2[];
extern  VTBL_ENTRY _ZTV3bb2[];
Class_Descriptor cd_bb2 = {  "bb2", // class name
  0,0,//no base classes
  &(vtc_bb2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3bb2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3bb2),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc2  {
  int c;
   cc2(); // _ZN3cc2C1Ev
  virtual void  foo(); // _ZN3cc23fooEv
  ~cc2(); // tgen
};
//SIG(-1 cc2) C1{ v1 Fi}


 cc2 ::cc2(){ note_ctor("cc2", this);}
void  cc2 ::foo(){vfunc_called(this, "_ZN3cc23fooEv");}
cc2 ::~cc2(){ note_dtor("cc2", this);} // tgen

static void Test_cc2()
{
  extern Class_Descriptor cd_cc2;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc2, buf);
    cc2 *dp, &lv = *(dp=new (buf) cc2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc2)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc2.c");
    test_class_info(&lv, &cd_cc2);
    dp->~cc2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc2(Test_cc2, "cc2", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3cc2C1Ev();
extern void _ZN3cc2D1Ev();
Name_Map name_map_cc2[] = {
  NSPAIR(_ZN3cc2C1Ev),
  NSPAIR(_ZN3cc2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3cc2[];
extern void _ZN3cc23fooEv();
static  VTBL_ENTRY vtc_cc2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3cc2[0]),
  (VTBL_ENTRY)&_ZN3cc23fooEv,
};
extern VTBL_ENTRY _ZTI3cc2[];
extern  VTBL_ENTRY _ZTV3cc2[];
Class_Descriptor cd_cc2 = {  "cc2", // class name
  0,0,//no base classes
  &(vtc_cc2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3cc2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3cc2),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd2  {
  int d;
   dd2(); // _ZN3dd2C1Ev
  virtual void  foo(); // _ZN3dd23fooEv
  ~dd2(); // tgen
};
//SIG(-1 dd2) C1{ v1 Fi}


 dd2 ::dd2(){ note_ctor("dd2", this);}
void  dd2 ::foo(){vfunc_called(this, "_ZN3dd23fooEv");}
dd2 ::~dd2(){ note_dtor("dd2", this);} // tgen

static void Test_dd2()
{
  extern Class_Descriptor cd_dd2;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd2, buf);
    dd2 *dp, &lv = *(dp=new (buf) dd2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd2)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd2.d");
    test_class_info(&lv, &cd_dd2);
    dp->~dd2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd2(Test_dd2, "dd2", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3dd2C1Ev();
extern void _ZN3dd2D1Ev();
Name_Map name_map_dd2[] = {
  NSPAIR(_ZN3dd2C1Ev),
  NSPAIR(_ZN3dd2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3dd2[];
extern void _ZN3dd23fooEv();
static  VTBL_ENTRY vtc_dd2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3dd2[0]),
  (VTBL_ENTRY)&_ZN3dd23fooEv,
};
extern VTBL_ENTRY _ZTI3dd2[];
extern  VTBL_ENTRY _ZTV3dd2[];
Class_Descriptor cd_dd2 = {  "dd2", // class name
  0,0,//no base classes
  &(vtc_dd2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3dd2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3dd2),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee2  : aa2 , virtual bb2 {
  int e;
   ee2(const ABISELECT(__tsi64,int) *const *); // _ZN3ee2C2Ev
  virtual void  foo(); // _ZN3ee23fooEv
  ~ee2(); // tgen
  ee2(); // tgen
};
//SIG(-1 ee2) C1{ BC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ee2 ::ee2(const ABISELECT(__tsi64,int) *const *){}
void  ee2 ::foo(){vfunc_called(this, "_ZN3ee23fooEv");}
ee2 ::~ee2(){ note_dtor("ee2", this);} // tgen
ee2 ::ee2(){ note_ctor("ee2", this);} // tgen

static void Test_ee2()
{
  extern Class_Descriptor cd_ee2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee2, buf);
    ee2 *dp, &lv = *(dp=new (buf) ee2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee2)");
    check_base_class_offset(lv, (aa2*), 0, "ee2");
    check_base_class_offset(lv, (bb2*), ABISELECT(16,12), "ee2");
    check_field_offset(lv, e, ABISELECT(12,8), "ee2.e");
    test_class_info(&lv, &cd_ee2);
    dp->~ee2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee2(Test_ee2, "ee2", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3ee2C1Ev();
extern void _ZN3ee2D1Ev();
Name_Map name_map_ee2[] = {
  NSPAIR(_ZN3ee2C1Ev),
  NSPAIR(_ZN3ee2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa2;
extern VTBL_ENTRY _ZTI3aa2[];
extern  VTBL_ENTRY _ZTV3aa2[];
extern Class_Descriptor cd_bb2;
extern VTBL_ENTRY _ZTI3bb2[];
extern  VTBL_ENTRY _ZTV3bb2[];
static Base_Class bases_ee2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_bb2,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3ee2[];
extern void _ZN3ee23fooEv();
extern void ABISELECT(_ZTv0_n24_N3ee23fooEv,_ZTv0_n12_N3ee23fooEv)();
extern void ABISELECT(_ZThn16_N3ee23fooEv,_ZThn12_N3ee23fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee2[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI3ee2[0]),
  (VTBL_ENTRY)&_ZN3ee23fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI3ee2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ee23fooEv,_ZTv0_n12_N3ee23fooEv),
};
extern VTBL_ENTRY _ZTV3ee2[];
static  VTT_ENTRY vtt_ee2[] = {
  {&(_ZTV3ee2[3]),  3,8},
  {&(_ZTV3ee2[7]),  7,8},
};
extern VTBL_ENTRY _ZTI3ee2[];
extern  VTBL_ENTRY _ZTV3ee2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3ee2[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ee23fooEv,_ZTv0_n12_N3ee23fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3ee23fooEv,_ZThn12_N3ee23fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee2 = {  "ee2", // class name
  bases_ee2, 2,
  &(vtc_ee2[0]), // expected_vtbl_contents
  &(vtt_ee2[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3ee2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3ee2),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3ee2),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff2  : cc2 , dd2 {
  int f;
   ff2(); // _ZN3ff2C1Ev
  virtual void  foo(); // _ZN3ff23fooEv
  ~ff2(); // tgen
};
//SIG(-1 ff2) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ff2 ::ff2(){ note_ctor("ff2", this);}
void  ff2 ::foo(){vfunc_called(this, "_ZN3ff23fooEv");}
ff2 ::~ff2(){ note_dtor("ff2", this);} // tgen

static void Test_ff2()
{
  extern Class_Descriptor cd_ff2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff2, buf);
    ff2 *dp, &lv = *(dp=new (buf) ff2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff2)");
    check_base_class_offset(lv, (cc2*), 0, "ff2");
    check_base_class_offset(lv, (dd2*), ABISELECT(16,8), "ff2");
    check_field_offset(lv, f, ABISELECT(28,16), "ff2.f");
    test_class_info(&lv, &cd_ff2);
    dp->~ff2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff2(Test_ff2, "ff2", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3ff2C1Ev();
extern void _ZN3ff2D1Ev();
Name_Map name_map_ff2[] = {
  NSPAIR(_ZN3ff2C1Ev),
  NSPAIR(_ZN3ff2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc2;
extern VTBL_ENTRY _ZTI3cc2[];
extern  VTBL_ENTRY _ZTV3cc2[];
extern Class_Descriptor cd_dd2;
extern VTBL_ENTRY _ZTI3dd2[];
extern  VTBL_ENTRY _ZTV3dd2[];
static Base_Class bases_ff2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_dd2,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3ff2[];
extern void _ZN3ff23fooEv();
extern void ABISELECT(_ZThn16_N3ff23fooEv,_ZThn8_N3ff23fooEv)();
static  VTBL_ENTRY vtc_ff2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3ff2[0]),
  (VTBL_ENTRY)&_ZN3ff23fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3ff2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3ff23fooEv,_ZThn8_N3ff23fooEv),
};
extern VTBL_ENTRY _ZTI3ff2[];
extern  VTBL_ENTRY _ZTV3ff2[];
Class_Descriptor cd_ff2 = {  "ff2", // class name
  bases_ff2, 2,
  &(vtc_ff2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3ff2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3ff2),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg2  : ee2 , ff2 {
  int g;
   gg2(const ABISELECT(__tsi64,int) *const *); // _ZN3gg2C2Ev
  virtual void  foo(); // _ZN3gg23fooEv
  ~gg2(); // tgen
  gg2(); // tgen
};
//SIG(1 gg2) C1{ BC2{ BC3{ v1 Fi} VBC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 Fi} BC7{ v1 Fi} v1 Fi} v1 Fi}


 gg2 ::gg2(const ABISELECT(__tsi64,int) *const *){}
void  gg2 ::foo(){vfunc_called(this, "_ZN3gg23fooEv");}
gg2 ::~gg2(){ note_dtor("gg2", this);} // tgen
gg2 ::gg2(){ note_ctor("gg2", this);} // tgen

static void Test_gg2()
{
  extern Class_Descriptor cd_gg2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg2, buf);
    gg2 *dp, &lv = *(dp=new (buf) gg2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg2)");
    check_base_class_offset(lv, (aa2*)(ee2*), 0, "gg2");
    check_base_class_offset(lv, (bb2*)(ee2*), ABISELECT(56,36), "gg2");
    check_base_class_offset(lv, (ee2*), 0, "gg2");
    check_base_class_offset(lv, (cc2*)(ff2*), ABISELECT(16,12), "gg2");
    check_base_class_offset(lv, (dd2*)(ff2*), ABISELECT(32,20), "gg2");
    check_base_class_offset(lv, (ff2*), ABISELECT(16,12), "gg2");
    check_field_offset(lv, g, ABISELECT(48,32), "gg2.g");
    test_class_info(&lv, &cd_gg2);
    dp->~gg2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg2(Test_gg2, "gg2", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3gg2C1Ev();
extern void _ZN3gg2D1Ev();
Name_Map name_map_gg2[] = {
  NSPAIR(_ZN3gg2C1Ev),
  NSPAIR(_ZN3gg2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa2;
extern VTBL_ENTRY _ZTI3aa2[];
extern  VTBL_ENTRY _ZTV3aa2[];
extern Class_Descriptor cd_bb2;
extern VTBL_ENTRY _ZTI3bb2[];
extern  VTBL_ENTRY _ZTV3bb2[];
extern Class_Descriptor cd_ee2;
extern VTBL_ENTRY _ZTI3ee2[];
extern  VTBL_ENTRY _ZTV3ee2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3ee2[];
extern Class_Descriptor cd_cc2;
extern VTBL_ENTRY _ZTI3cc2[];
extern  VTBL_ENTRY _ZTV3cc2[];
extern Class_Descriptor cd_dd2;
extern VTBL_ENTRY _ZTI3dd2[];
extern  VTBL_ENTRY _ZTV3dd2[];
extern Class_Descriptor cd_ff2;
extern VTBL_ENTRY _ZTI3ff2[];
extern  VTBL_ENTRY _ZTV3ff2[];
static Base_Class bases_gg2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_bb2,    ABISELECT(56,36), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_ee2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc2,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_dd2,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_ff2,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3gg2[];
extern void _ZN3gg23fooEv();
extern void ABISELECT(_ZThn16_N3gg23fooEv,_ZThn12_N3gg23fooEv)();
extern void ABISELECT(_ZThn32_N3gg23fooEv,_ZThn20_N3gg23fooEv)();
extern void ABISELECT(_ZTv0_n24_N3gg23fooEv,_ZTv0_n12_N3gg23fooEv)();
extern void ABISELECT(_ZThn56_N3gg23fooEv,_ZThn36_N3gg23fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg2[] = {
  ABISELECT(56,36),
  0,
  (VTBL_ENTRY)&(_ZTI3gg2[0]),
  (VTBL_ENTRY)&_ZN3gg23fooEv,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI3gg2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3gg23fooEv,_ZThn12_N3gg23fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI3gg2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3gg23fooEv,_ZThn20_N3gg23fooEv),
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI3gg2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3gg23fooEv,_ZTv0_n12_N3gg23fooEv),
};
extern VTBL_ENTRY _ZTV3gg2[];
extern void _ZN3ee23fooEv();
static  VTBL_ENTRY _tg__ZTV3ee2__3gg2[] = {
  ABISELECT(56,36),
  0,
  (VTBL_ENTRY)&(_ZTI3ee2[0]),
  (VTBL_ENTRY)&_ZN3ee23fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3ee23fooEv,_ZTv0_n12_N3ee23fooEv)();
extern void ABISELECT(_ZThn56_N3ee23fooEv,_ZThn36_N3ee23fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3bb2__3ee2__3gg2[] = {
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI3ee2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ee23fooEv,_ZTv0_n12_N3ee23fooEv),
};
static  VTT_ENTRY vtt_gg2[] = {
  {&(_ZTV3gg2[3]),  3,14},
  {&(_tg__ZTV3ee2__3gg2[3]),  3,4},
  {&(_tg__ZTV3bb2__3ee2__3gg2[3]),  3,4},
  {&(_ZTV3gg2[13]),  13,14},
};
extern VTBL_ENTRY _ZTI3gg2[];
extern  VTBL_ENTRY _ZTV3gg2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3gg2[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ee23fooEv,_ZTv0_n12_N3ee23fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N3ee23fooEv,_ZThn36_N3ee23fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3gg23fooEv,_ZTv0_n12_N3gg23fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N3gg23fooEv,_ZThn36_N3gg23fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg2 = {  "gg2", // class name
  bases_gg2, 6,
  &(vtc_gg2[0]), // expected_vtbl_contents
  &(vtt_gg2[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI3gg2),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3gg2),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3gg2),4, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa3  {
  int a;
   aa3(); // _ZN3aa3C1Ev
  virtual void  foo(); // _ZN3aa33fooEv
  ~aa3(); // tgen
};
//SIG(-1 aa3) C1{ v1 Fi}


 aa3 ::aa3(){ note_ctor("aa3", this);}
void  aa3 ::foo(){vfunc_called(this, "_ZN3aa33fooEv");}
aa3 ::~aa3(){ note_dtor("aa3", this);} // tgen

static void Test_aa3()
{
  extern Class_Descriptor cd_aa3;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa3, buf);
    aa3 *dp, &lv = *(dp=new (buf) aa3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa3)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa3.a");
    test_class_info(&lv, &cd_aa3);
    dp->~aa3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa3(Test_aa3, "aa3", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aa3C1Ev();
extern void _ZN3aa3D1Ev();
Name_Map name_map_aa3[] = {
  NSPAIR(_ZN3aa3C1Ev),
  NSPAIR(_ZN3aa3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3aa3[];
extern void _ZN3aa33fooEv();
static  VTBL_ENTRY vtc_aa3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3aa3[0]),
  (VTBL_ENTRY)&_ZN3aa33fooEv,
};
extern VTBL_ENTRY _ZTI3aa3[];
extern  VTBL_ENTRY _ZTV3aa3[];
Class_Descriptor cd_aa3 = {  "aa3", // class name
  0,0,//no base classes
  &(vtc_aa3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3aa3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3aa3),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb3  {
  int b;
   bb3(); // _ZN3bb3C1Ev
  virtual void  foo(); // _ZN3bb33fooEv
  ~bb3(); // tgen
};
//SIG(-1 bb3) C1{ v1 Fi}


 bb3 ::bb3(){ note_ctor("bb3", this);}
void  bb3 ::foo(){vfunc_called(this, "_ZN3bb33fooEv");}
bb3 ::~bb3(){ note_dtor("bb3", this);} // tgen

static void Test_bb3()
{
  extern Class_Descriptor cd_bb3;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb3, buf);
    bb3 *dp, &lv = *(dp=new (buf) bb3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb3)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb3.b");
    test_class_info(&lv, &cd_bb3);
    dp->~bb3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb3(Test_bb3, "bb3", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3bb3C1Ev();
extern void _ZN3bb3D1Ev();
Name_Map name_map_bb3[] = {
  NSPAIR(_ZN3bb3C1Ev),
  NSPAIR(_ZN3bb3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3bb3[];
extern void _ZN3bb33fooEv();
static  VTBL_ENTRY vtc_bb3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3bb3[0]),
  (VTBL_ENTRY)&_ZN3bb33fooEv,
};
extern VTBL_ENTRY _ZTI3bb3[];
extern  VTBL_ENTRY _ZTV3bb3[];
Class_Descriptor cd_bb3 = {  "bb3", // class name
  0,0,//no base classes
  &(vtc_bb3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3bb3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3bb3),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc3  {
  int c;
   cc3(); // _ZN3cc3C1Ev
  virtual void  foo(); // _ZN3cc33fooEv
  ~cc3(); // tgen
};
//SIG(-1 cc3) C1{ v1 Fi}


 cc3 ::cc3(){ note_ctor("cc3", this);}
void  cc3 ::foo(){vfunc_called(this, "_ZN3cc33fooEv");}
cc3 ::~cc3(){ note_dtor("cc3", this);} // tgen

static void Test_cc3()
{
  extern Class_Descriptor cd_cc3;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc3, buf);
    cc3 *dp, &lv = *(dp=new (buf) cc3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc3)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc3.c");
    test_class_info(&lv, &cd_cc3);
    dp->~cc3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc3(Test_cc3, "cc3", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3cc3C1Ev();
extern void _ZN3cc3D1Ev();
Name_Map name_map_cc3[] = {
  NSPAIR(_ZN3cc3C1Ev),
  NSPAIR(_ZN3cc3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3cc3[];
extern void _ZN3cc33fooEv();
static  VTBL_ENTRY vtc_cc3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3cc3[0]),
  (VTBL_ENTRY)&_ZN3cc33fooEv,
};
extern VTBL_ENTRY _ZTI3cc3[];
extern  VTBL_ENTRY _ZTV3cc3[];
Class_Descriptor cd_cc3 = {  "cc3", // class name
  0,0,//no base classes
  &(vtc_cc3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3cc3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3cc3),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd3  {
  int d;
   dd3(); // _ZN3dd3C1Ev
  virtual void  foo(); // _ZN3dd33fooEv
  ~dd3(); // tgen
};
//SIG(-1 dd3) C1{ v1 Fi}


 dd3 ::dd3(){ note_ctor("dd3", this);}
void  dd3 ::foo(){vfunc_called(this, "_ZN3dd33fooEv");}
dd3 ::~dd3(){ note_dtor("dd3", this);} // tgen

static void Test_dd3()
{
  extern Class_Descriptor cd_dd3;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd3, buf);
    dd3 *dp, &lv = *(dp=new (buf) dd3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd3)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd3.d");
    test_class_info(&lv, &cd_dd3);
    dp->~dd3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd3(Test_dd3, "dd3", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3dd3C1Ev();
extern void _ZN3dd3D1Ev();
Name_Map name_map_dd3[] = {
  NSPAIR(_ZN3dd3C1Ev),
  NSPAIR(_ZN3dd3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3dd3[];
extern void _ZN3dd33fooEv();
static  VTBL_ENTRY vtc_dd3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3dd3[0]),
  (VTBL_ENTRY)&_ZN3dd33fooEv,
};
extern VTBL_ENTRY _ZTI3dd3[];
extern  VTBL_ENTRY _ZTV3dd3[];
Class_Descriptor cd_dd3 = {  "dd3", // class name
  0,0,//no base classes
  &(vtc_dd3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3dd3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3dd3),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee3  : virtual aa3 , virtual bb3 {
  int e;
   ee3(const ABISELECT(__tsi64,int) *const *); // _ZN3ee3C2Ev
  virtual void  foo(); // _ZN3ee33fooEv
  ~ee3(); // tgen
  ee3(); // tgen
};
//SIG(-1 ee3) C1{ VBC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ee3 ::ee3(const ABISELECT(__tsi64,int) *const *){}
void  ee3 ::foo(){vfunc_called(this, "_ZN3ee33fooEv");}
ee3 ::~ee3(){ note_dtor("ee3", this);} // tgen
ee3 ::ee3(){ note_ctor("ee3", this);} // tgen

static void Test_ee3()
{
  extern Class_Descriptor cd_ee3;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_ee3, buf);
    ee3 *dp, &lv = *(dp=new (buf) ee3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(ee3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee3)");
    check_base_class_offset(lv, (aa3*), ABISELECT(16,8), "ee3");
    check_base_class_offset(lv, (bb3*), ABISELECT(32,16), "ee3");
    check_field_offset(lv, e, ABISELECT(8,4), "ee3.e");
    test_class_info(&lv, &cd_ee3);
    dp->~ee3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee3(Test_ee3, "ee3", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN3ee3C1Ev();
extern void _ZN3ee3D1Ev();
Name_Map name_map_ee3[] = {
  NSPAIR(_ZN3ee3C1Ev),
  NSPAIR(_ZN3ee3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa3;
extern VTBL_ENTRY _ZTI3aa3[];
extern  VTBL_ENTRY _ZTV3aa3[];
extern Class_Descriptor cd_bb3;
extern VTBL_ENTRY _ZTI3bb3[];
extern  VTBL_ENTRY _ZTV3bb3[];
static Base_Class bases_ee3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa3,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_bb3,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3ee3[];
extern void _ZN3ee33fooEv();
extern void ABISELECT(_ZTv0_n24_N3ee33fooEv,_ZTv0_n12_N3ee33fooEv)();
extern void ABISELECT(_ZThn16_N3ee33fooEv,_ZThn8_N3ee33fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N3ee33fooEv,_ZTv0_n12_N3ee33fooEv)();
extern void ABISELECT(_ZThn32_N3ee33fooEv,_ZThn16_N3ee33fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee3[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3ee3[0]),
  (VTBL_ENTRY)&_ZN3ee33fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3ee3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ee33fooEv,_ZTv0_n12_N3ee33fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI3ee3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ee33fooEv,_ZTv0_n12_N3ee33fooEv),
};
extern VTBL_ENTRY _ZTV3ee3[];
static  VTT_ENTRY vtt_ee3[] = {
  {&(_ZTV3ee3[4]),  4,13},
  {&(_ZTV3ee3[8]),  8,13},
  {&(_ZTV3ee3[12]),  12,13},
};
extern VTBL_ENTRY _ZTI3ee3[];
extern  VTBL_ENTRY _ZTV3ee3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3ee3[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ee33fooEv,_ZTv0_n12_N3ee33fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N3ee33fooEv,_ZThn16_N3ee33fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3ee33fooEv,_ZThn8_N3ee33fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee3 = {  "ee3", // class name
  bases_ee3, 2,
  &(vtc_ee3[0]), // expected_vtbl_contents
  &(vtt_ee3[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI3ee3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3ee3),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3ee3),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff3  : cc3 , dd3 {
  int f;
   ff3(); // _ZN3ff3C1Ev
  virtual void  foo(); // _ZN3ff33fooEv
  ~ff3(); // tgen
};
//SIG(-1 ff3) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ff3 ::ff3(){ note_ctor("ff3", this);}
void  ff3 ::foo(){vfunc_called(this, "_ZN3ff33fooEv");}
ff3 ::~ff3(){ note_dtor("ff3", this);} // tgen

static void Test_ff3()
{
  extern Class_Descriptor cd_ff3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff3, buf);
    ff3 *dp, &lv = *(dp=new (buf) ff3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff3)");
    check_base_class_offset(lv, (cc3*), 0, "ff3");
    check_base_class_offset(lv, (dd3*), ABISELECT(16,8), "ff3");
    check_field_offset(lv, f, ABISELECT(28,16), "ff3.f");
    test_class_info(&lv, &cd_ff3);
    dp->~ff3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff3(Test_ff3, "ff3", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3ff3C1Ev();
extern void _ZN3ff3D1Ev();
Name_Map name_map_ff3[] = {
  NSPAIR(_ZN3ff3C1Ev),
  NSPAIR(_ZN3ff3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc3;
extern VTBL_ENTRY _ZTI3cc3[];
extern  VTBL_ENTRY _ZTV3cc3[];
extern Class_Descriptor cd_dd3;
extern VTBL_ENTRY _ZTI3dd3[];
extern  VTBL_ENTRY _ZTV3dd3[];
static Base_Class bases_ff3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_dd3,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3ff3[];
extern void _ZN3ff33fooEv();
extern void ABISELECT(_ZThn16_N3ff33fooEv,_ZThn8_N3ff33fooEv)();
static  VTBL_ENTRY vtc_ff3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3ff3[0]),
  (VTBL_ENTRY)&_ZN3ff33fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3ff3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3ff33fooEv,_ZThn8_N3ff33fooEv),
};
extern VTBL_ENTRY _ZTI3ff3[];
extern  VTBL_ENTRY _ZTV3ff3[];
Class_Descriptor cd_ff3 = {  "ff3", // class name
  bases_ff3, 2,
  &(vtc_ff3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3ff3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3ff3),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg3  : ee3 , ff3 {
  int g;
   gg3(const ABISELECT(__tsi64,int) *const *); // _ZN3gg3C2Ev
  virtual void  foo(); // _ZN3gg33fooEv
  ~gg3(); // tgen
  gg3(); // tgen
};
//SIG(1 gg3) C1{ BC2{ VBC3{ v1 Fi} VBC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 Fi} BC7{ v1 Fi} v1 Fi} v1 Fi}


 gg3 ::gg3(const ABISELECT(__tsi64,int) *const *){}
void  gg3 ::foo(){vfunc_called(this, "_ZN3gg33fooEv");}
gg3 ::~gg3(){ note_dtor("gg3", this);} // tgen
gg3 ::gg3(){ note_ctor("gg3", this);} // tgen

static void Test_gg3()
{
  extern Class_Descriptor cd_gg3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(12,13)];
    init_test(&cd_gg3, buf);
    gg3 *dp, &lv = *(dp=new (buf) gg3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(88,48), "sizeof(gg3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg3)");
    check_base_class_offset(lv, (aa3*)(ee3*), ABISELECT(56,32), "gg3");
    check_base_class_offset(lv, (bb3*)(ee3*), ABISELECT(72,40), "gg3");
    check_base_class_offset(lv, (ee3*), 0, "gg3");
    check_base_class_offset(lv, (cc3*)(ff3*), ABISELECT(16,8), "gg3");
    check_base_class_offset(lv, (dd3*)(ff3*), ABISELECT(32,16), "gg3");
    check_base_class_offset(lv, (ff3*), ABISELECT(16,8), "gg3");
    check_field_offset(lv, g, ABISELECT(48,28), "gg3.g");
    test_class_info(&lv, &cd_gg3);
    dp->~gg3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg3(Test_gg3, "gg3", ABISELECT(88,48));

#else // __cplusplus

extern void _ZN3gg3C1Ev();
extern void _ZN3gg3D1Ev();
Name_Map name_map_gg3[] = {
  NSPAIR(_ZN3gg3C1Ev),
  NSPAIR(_ZN3gg3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa3;
extern VTBL_ENTRY _ZTI3aa3[];
extern  VTBL_ENTRY _ZTV3aa3[];
extern Class_Descriptor cd_bb3;
extern VTBL_ENTRY _ZTI3bb3[];
extern  VTBL_ENTRY _ZTV3bb3[];
extern Class_Descriptor cd_ee3;
extern VTBL_ENTRY _ZTI3ee3[];
extern  VTBL_ENTRY _ZTV3ee3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3ee3[];
extern Class_Descriptor cd_cc3;
extern VTBL_ENTRY _ZTI3cc3[];
extern  VTBL_ENTRY _ZTV3cc3[];
extern Class_Descriptor cd_dd3;
extern VTBL_ENTRY _ZTI3dd3[];
extern  VTBL_ENTRY _ZTV3dd3[];
extern Class_Descriptor cd_ff3;
extern VTBL_ENTRY _ZTI3ff3[];
extern  VTBL_ENTRY _ZTV3ff3[];
static Base_Class bases_gg3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa3,    ABISELECT(56,32), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_bb3,    ABISELECT(72,40), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_ee3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc3,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_dd3,    ABISELECT(32,16), //bcp->offset
    8, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_ff3,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3gg3[];
extern void _ZN3gg33fooEv();
extern void ABISELECT(_ZThn16_N3gg33fooEv,_ZThn8_N3gg33fooEv)();
extern void ABISELECT(_ZThn32_N3gg33fooEv,_ZThn16_N3gg33fooEv)();
extern void ABISELECT(_ZTv0_n24_N3gg33fooEv,_ZTv0_n12_N3gg33fooEv)();
extern void ABISELECT(_ZThn56_N3gg33fooEv,_ZThn32_N3gg33fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N3gg33fooEv,_ZTv0_n12_N3gg33fooEv)();
extern void ABISELECT(_ZThn72_N3gg33fooEv,_ZThn40_N3gg33fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg3[] = {
  ABISELECT(72,40),
  ABISELECT(56,32),
  0,
  (VTBL_ENTRY)&(_ZTI3gg3[0]),
  (VTBL_ENTRY)&_ZN3gg33fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3gg3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3gg33fooEv,_ZThn8_N3gg33fooEv),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI3gg3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3gg33fooEv,_ZThn16_N3gg33fooEv),
  ABISELECT(-56,-32),
  ABISELECT(-56,-32),
  (VTBL_ENTRY)&(_ZTI3gg3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3gg33fooEv,_ZTv0_n12_N3gg33fooEv),
  ABISELECT(-72,-40),
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI3gg3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3gg33fooEv,_ZTv0_n12_N3gg33fooEv),
};
extern VTBL_ENTRY _ZTV3gg3[];
extern void _ZN3ee33fooEv();
static  VTBL_ENTRY _tg__ZTV3ee3__3gg3[] = {
  ABISELECT(72,40),
  ABISELECT(56,32),
  0,
  (VTBL_ENTRY)&(_ZTI3ee3[0]),
  (VTBL_ENTRY)&_ZN3ee33fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3ee33fooEv,_ZTv0_n12_N3ee33fooEv)();
extern void ABISELECT(_ZThn56_N3ee33fooEv,_ZThn32_N3ee33fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3aa3__3ee3__3gg3[] = {
  ABISELECT(-56,-32),
  ABISELECT(-56,-32),
  (VTBL_ENTRY)&(_ZTI3ee3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ee33fooEv,_ZTv0_n12_N3ee33fooEv),
};
extern void ABISELECT(_ZTv0_n24_N3ee33fooEv,_ZTv0_n12_N3ee33fooEv)();
extern void ABISELECT(_ZThn72_N3ee33fooEv,_ZThn40_N3ee33fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3bb3__3ee3__3gg3[] = {
  ABISELECT(-72,-40),
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI3ee3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ee33fooEv,_ZTv0_n12_N3ee33fooEv),
};
static  VTT_ENTRY vtt_gg3[] = {
  {&(_ZTV3gg3[4]),  4,19},
  {&(_tg__ZTV3ee3__3gg3[4]),  4,5},
  {&(_tg__ZTV3aa3__3ee3__3gg3[3]),  3,4},
  {&(_tg__ZTV3bb3__3ee3__3gg3[3]),  3,4},
  {&(_ZTV3gg3[14]),  14,19},
  {&(_ZTV3gg3[18]),  18,19},
};
extern VTBL_ENTRY _ZTI3gg3[];
extern  VTBL_ENTRY _ZTV3gg3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3gg3[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ee33fooEv,_ZTv0_n12_N3ee33fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N3ee33fooEv,_ZThn40_N3ee33fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn56_N3ee33fooEv,_ZThn32_N3ee33fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3gg33fooEv,_ZTv0_n12_N3gg33fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N3gg33fooEv,_ZThn40_N3gg33fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn56_N3gg33fooEv,_ZThn32_N3gg33fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg3 = {  "gg3", // class name
  bases_gg3, 6,
  &(vtc_gg3[0]), // expected_vtbl_contents
  &(vtt_gg3[0]), // expected_vtt_contents
  ABISELECT(88,48), // object size
  NSPAIRA(_ZTI3gg3),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3gg3),19, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3gg3),6, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa4  {
  int a;
   aa4(); // _ZN3aa4C1Ev
  virtual void  foo(); // _ZN3aa43fooEv
  ~aa4(); // tgen
};
//SIG(-1 aa4) C1{ v1 Fi}


 aa4 ::aa4(){ note_ctor("aa4", this);}
void  aa4 ::foo(){vfunc_called(this, "_ZN3aa43fooEv");}
aa4 ::~aa4(){ note_dtor("aa4", this);} // tgen

static void Test_aa4()
{
  extern Class_Descriptor cd_aa4;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa4, buf);
    aa4 *dp, &lv = *(dp=new (buf) aa4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa4)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa4.a");
    test_class_info(&lv, &cd_aa4);
    dp->~aa4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa4(Test_aa4, "aa4", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aa4C1Ev();
extern void _ZN3aa4D1Ev();
Name_Map name_map_aa4[] = {
  NSPAIR(_ZN3aa4C1Ev),
  NSPAIR(_ZN3aa4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3aa4[];
extern void _ZN3aa43fooEv();
static  VTBL_ENTRY vtc_aa4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3aa4[0]),
  (VTBL_ENTRY)&_ZN3aa43fooEv,
};
extern VTBL_ENTRY _ZTI3aa4[];
extern  VTBL_ENTRY _ZTV3aa4[];
Class_Descriptor cd_aa4 = {  "aa4", // class name
  0,0,//no base classes
  &(vtc_aa4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3aa4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3aa4),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb4  {
  int b;
   bb4(); // _ZN3bb4C1Ev
  virtual void  foo(); // _ZN3bb43fooEv
  ~bb4(); // tgen
};
//SIG(-1 bb4) C1{ v1 Fi}


 bb4 ::bb4(){ note_ctor("bb4", this);}
void  bb4 ::foo(){vfunc_called(this, "_ZN3bb43fooEv");}
bb4 ::~bb4(){ note_dtor("bb4", this);} // tgen

static void Test_bb4()
{
  extern Class_Descriptor cd_bb4;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb4, buf);
    bb4 *dp, &lv = *(dp=new (buf) bb4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb4)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb4.b");
    test_class_info(&lv, &cd_bb4);
    dp->~bb4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb4(Test_bb4, "bb4", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3bb4C1Ev();
extern void _ZN3bb4D1Ev();
Name_Map name_map_bb4[] = {
  NSPAIR(_ZN3bb4C1Ev),
  NSPAIR(_ZN3bb4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3bb4[];
extern void _ZN3bb43fooEv();
static  VTBL_ENTRY vtc_bb4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3bb4[0]),
  (VTBL_ENTRY)&_ZN3bb43fooEv,
};
extern VTBL_ENTRY _ZTI3bb4[];
extern  VTBL_ENTRY _ZTV3bb4[];
Class_Descriptor cd_bb4 = {  "bb4", // class name
  0,0,//no base classes
  &(vtc_bb4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3bb4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3bb4),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc4  {
  int c;
   cc4(); // _ZN3cc4C1Ev
  virtual void  foo(); // _ZN3cc43fooEv
  ~cc4(); // tgen
};
//SIG(-1 cc4) C1{ v1 Fi}


 cc4 ::cc4(){ note_ctor("cc4", this);}
void  cc4 ::foo(){vfunc_called(this, "_ZN3cc43fooEv");}
cc4 ::~cc4(){ note_dtor("cc4", this);} // tgen

static void Test_cc4()
{
  extern Class_Descriptor cd_cc4;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc4, buf);
    cc4 *dp, &lv = *(dp=new (buf) cc4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc4)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc4.c");
    test_class_info(&lv, &cd_cc4);
    dp->~cc4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc4(Test_cc4, "cc4", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3cc4C1Ev();
extern void _ZN3cc4D1Ev();
Name_Map name_map_cc4[] = {
  NSPAIR(_ZN3cc4C1Ev),
  NSPAIR(_ZN3cc4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3cc4[];
extern void _ZN3cc43fooEv();
static  VTBL_ENTRY vtc_cc4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3cc4[0]),
  (VTBL_ENTRY)&_ZN3cc43fooEv,
};
extern VTBL_ENTRY _ZTI3cc4[];
extern  VTBL_ENTRY _ZTV3cc4[];
Class_Descriptor cd_cc4 = {  "cc4", // class name
  0,0,//no base classes
  &(vtc_cc4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3cc4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3cc4),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd4  {
  int d;
   dd4(); // _ZN3dd4C1Ev
  virtual void  foo(); // _ZN3dd43fooEv
  ~dd4(); // tgen
};
//SIG(-1 dd4) C1{ v1 Fi}


 dd4 ::dd4(){ note_ctor("dd4", this);}
void  dd4 ::foo(){vfunc_called(this, "_ZN3dd43fooEv");}
dd4 ::~dd4(){ note_dtor("dd4", this);} // tgen

static void Test_dd4()
{
  extern Class_Descriptor cd_dd4;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd4, buf);
    dd4 *dp, &lv = *(dp=new (buf) dd4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd4)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd4.d");
    test_class_info(&lv, &cd_dd4);
    dp->~dd4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd4(Test_dd4, "dd4", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3dd4C1Ev();
extern void _ZN3dd4D1Ev();
Name_Map name_map_dd4[] = {
  NSPAIR(_ZN3dd4C1Ev),
  NSPAIR(_ZN3dd4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3dd4[];
extern void _ZN3dd43fooEv();
static  VTBL_ENTRY vtc_dd4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3dd4[0]),
  (VTBL_ENTRY)&_ZN3dd43fooEv,
};
extern VTBL_ENTRY _ZTI3dd4[];
extern  VTBL_ENTRY _ZTV3dd4[];
Class_Descriptor cd_dd4 = {  "dd4", // class name
  0,0,//no base classes
  &(vtc_dd4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3dd4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3dd4),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee4  : aa4 , bb4 {
  int e;
   ee4(); // _ZN3ee4C1Ev
  virtual void  foo(); // _ZN3ee43fooEv
  ~ee4(); // tgen
};
//SIG(-1 ee4) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ee4 ::ee4(){ note_ctor("ee4", this);}
void  ee4 ::foo(){vfunc_called(this, "_ZN3ee43fooEv");}
ee4 ::~ee4(){ note_dtor("ee4", this);} // tgen

static void Test_ee4()
{
  extern Class_Descriptor cd_ee4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee4, buf);
    ee4 *dp, &lv = *(dp=new (buf) ee4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee4)");
    check_base_class_offset(lv, (aa4*), 0, "ee4");
    check_base_class_offset(lv, (bb4*), ABISELECT(16,8), "ee4");
    check_field_offset(lv, e, ABISELECT(28,16), "ee4.e");
    test_class_info(&lv, &cd_ee4);
    dp->~ee4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee4(Test_ee4, "ee4", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3ee4C1Ev();
extern void _ZN3ee4D1Ev();
Name_Map name_map_ee4[] = {
  NSPAIR(_ZN3ee4C1Ev),
  NSPAIR(_ZN3ee4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa4;
extern VTBL_ENTRY _ZTI3aa4[];
extern  VTBL_ENTRY _ZTV3aa4[];
extern Class_Descriptor cd_bb4;
extern VTBL_ENTRY _ZTI3bb4[];
extern  VTBL_ENTRY _ZTV3bb4[];
static Base_Class bases_ee4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_bb4,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3ee4[];
extern void _ZN3ee43fooEv();
extern void ABISELECT(_ZThn16_N3ee43fooEv,_ZThn8_N3ee43fooEv)();
static  VTBL_ENTRY vtc_ee4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3ee4[0]),
  (VTBL_ENTRY)&_ZN3ee43fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3ee4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3ee43fooEv,_ZThn8_N3ee43fooEv),
};
extern VTBL_ENTRY _ZTI3ee4[];
extern  VTBL_ENTRY _ZTV3ee4[];
Class_Descriptor cd_ee4 = {  "ee4", // class name
  bases_ee4, 2,
  &(vtc_ee4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3ee4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3ee4),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff4  : virtual cc4 , dd4 {
  int f;
   ff4(const ABISELECT(__tsi64,int) *const *); // _ZN3ff4C2Ev
  virtual void  foo(); // _ZN3ff43fooEv
  ~ff4(); // tgen
  ff4(); // tgen
};
//SIG(-1 ff4) C1{ VBC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ff4 ::ff4(const ABISELECT(__tsi64,int) *const *){}
void  ff4 ::foo(){vfunc_called(this, "_ZN3ff43fooEv");}
ff4 ::~ff4(){ note_dtor("ff4", this);} // tgen
ff4 ::ff4(){ note_ctor("ff4", this);} // tgen

static void Test_ff4()
{
  extern Class_Descriptor cd_ff4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff4, buf);
    ff4 *dp, &lv = *(dp=new (buf) ff4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff4)");
    check_base_class_offset(lv, (cc4*), ABISELECT(16,12), "ff4");
    check_base_class_offset(lv, (dd4*), 0, "ff4");
    check_field_offset(lv, f, ABISELECT(12,8), "ff4.f");
    test_class_info(&lv, &cd_ff4);
    dp->~ff4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff4(Test_ff4, "ff4", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3ff4C1Ev();
extern void _ZN3ff4D1Ev();
Name_Map name_map_ff4[] = {
  NSPAIR(_ZN3ff4C1Ev),
  NSPAIR(_ZN3ff4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc4;
extern VTBL_ENTRY _ZTI3cc4[];
extern  VTBL_ENTRY _ZTV3cc4[];
extern Class_Descriptor cd_dd4;
extern VTBL_ENTRY _ZTI3dd4[];
extern  VTBL_ENTRY _ZTV3dd4[];
static Base_Class bases_ff4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc4,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_dd4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3ff4[];
extern void _ZN3ff43fooEv();
extern void ABISELECT(_ZTv0_n24_N3ff43fooEv,_ZTv0_n12_N3ff43fooEv)();
extern void ABISELECT(_ZThn16_N3ff43fooEv,_ZThn12_N3ff43fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff4[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI3ff4[0]),
  (VTBL_ENTRY)&_ZN3ff43fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI3ff4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ff43fooEv,_ZTv0_n12_N3ff43fooEv),
};
extern VTBL_ENTRY _ZTV3ff4[];
static  VTT_ENTRY vtt_ff4[] = {
  {&(_ZTV3ff4[3]),  3,8},
  {&(_ZTV3ff4[7]),  7,8},
};
extern VTBL_ENTRY _ZTI3ff4[];
extern  VTBL_ENTRY _ZTV3ff4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3ff4[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ff43fooEv,_ZTv0_n12_N3ff43fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3ff43fooEv,_ZThn12_N3ff43fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff4 = {  "ff4", // class name
  bases_ff4, 2,
  &(vtc_ff4[0]), // expected_vtbl_contents
  &(vtt_ff4[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3ff4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3ff4),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3ff4),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg4  : ee4 , ff4 {
  int g;
   gg4(const ABISELECT(__tsi64,int) *const *); // _ZN3gg4C2Ev
  virtual void  foo(); // _ZN3gg43fooEv
  ~gg4(); // tgen
  gg4(); // tgen
};
//SIG(1 gg4) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ VBC6{ v1 Fi} BC7{ v1 Fi} v1 Fi} v1 Fi}


 gg4 ::gg4(const ABISELECT(__tsi64,int) *const *){}
void  gg4 ::foo(){vfunc_called(this, "_ZN3gg43fooEv");}
gg4 ::~gg4(){ note_dtor("gg4", this);} // tgen
gg4 ::gg4(){ note_ctor("gg4", this);} // tgen

static void Test_gg4()
{
  extern Class_Descriptor cd_gg4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg4, buf);
    gg4 *dp, &lv = *(dp=new (buf) gg4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg4)");
    check_base_class_offset(lv, (aa4*)(ee4*), 0, "gg4");
    check_base_class_offset(lv, (bb4*)(ee4*), ABISELECT(16,8), "gg4");
    check_base_class_offset(lv, (ee4*), 0, "gg4");
    check_base_class_offset(lv, (cc4*)(ff4*), ABISELECT(56,36), "gg4");
    check_base_class_offset(lv, (dd4*)(ff4*), ABISELECT(32,20), "gg4");
    check_base_class_offset(lv, (ff4*), ABISELECT(32,20), "gg4");
    check_field_offset(lv, g, ABISELECT(48,32), "gg4.g");
    test_class_info(&lv, &cd_gg4);
    dp->~gg4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg4(Test_gg4, "gg4", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3gg4C1Ev();
extern void _ZN3gg4D1Ev();
Name_Map name_map_gg4[] = {
  NSPAIR(_ZN3gg4C1Ev),
  NSPAIR(_ZN3gg4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa4;
extern VTBL_ENTRY _ZTI3aa4[];
extern  VTBL_ENTRY _ZTV3aa4[];
extern Class_Descriptor cd_bb4;
extern VTBL_ENTRY _ZTI3bb4[];
extern  VTBL_ENTRY _ZTV3bb4[];
extern Class_Descriptor cd_ee4;
extern VTBL_ENTRY _ZTI3ee4[];
extern  VTBL_ENTRY _ZTV3ee4[];
extern Class_Descriptor cd_cc4;
extern VTBL_ENTRY _ZTI3cc4[];
extern  VTBL_ENTRY _ZTV3cc4[];
extern Class_Descriptor cd_dd4;
extern VTBL_ENTRY _ZTI3dd4[];
extern  VTBL_ENTRY _ZTV3dd4[];
extern Class_Descriptor cd_ff4;
extern VTBL_ENTRY _ZTI3ff4[];
extern  VTBL_ENTRY _ZTV3ff4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3ff4[];
static Base_Class bases_gg4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_bb4,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_ee4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc4,    ABISELECT(56,36), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_dd4,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_ff4,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3gg4[];
extern void _ZN3gg43fooEv();
extern void ABISELECT(_ZThn16_N3gg43fooEv,_ZThn8_N3gg43fooEv)();
extern void ABISELECT(_ZThn32_N3gg43fooEv,_ZThn20_N3gg43fooEv)();
extern void ABISELECT(_ZTv0_n24_N3gg43fooEv,_ZTv0_n12_N3gg43fooEv)();
extern void ABISELECT(_ZThn56_N3gg43fooEv,_ZThn36_N3gg43fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg4[] = {
  ABISELECT(56,36),
  0,
  (VTBL_ENTRY)&(_ZTI3gg4[0]),
  (VTBL_ENTRY)&_ZN3gg43fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3gg4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3gg43fooEv,_ZThn8_N3gg43fooEv),
  ABISELECT(24,16),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI3gg4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3gg43fooEv,_ZThn20_N3gg43fooEv),
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI3gg4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3gg43fooEv,_ZTv0_n12_N3gg43fooEv),
};
extern VTBL_ENTRY _ZTV3gg4[];
extern void _ZN3ff43fooEv();
static  VTBL_ENTRY _tg__ZTV3ff4__3gg4[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI3ff4[0]),
  (VTBL_ENTRY)&_ZN3ff43fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3ff43fooEv,_ZTv0_n12_N3ff43fooEv)();
extern void ABISELECT(_ZThn24_N3ff43fooEv,_ZThn16_N3ff43fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3cc4__3ff4__3gg4[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI3ff4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ff43fooEv,_ZTv0_n12_N3ff43fooEv),
};
static  VTT_ENTRY vtt_gg4[] = {
  {&(_ZTV3gg4[3]),  3,15},
  {&(_tg__ZTV3ff4__3gg4[3]),  3,4},
  {&(_tg__ZTV3cc4__3ff4__3gg4[3]),  3,4},
  {&(_ZTV3gg4[10]),  10,15},
  {&(_ZTV3gg4[14]),  14,15},
};
extern VTBL_ENTRY _ZTI3gg4[];
extern  VTBL_ENTRY _ZTV3gg4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3gg4[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ff43fooEv,_ZTv0_n12_N3ff43fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N3ff43fooEv,_ZThn16_N3ff43fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3gg43fooEv,_ZTv0_n12_N3gg43fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N3gg43fooEv,_ZThn36_N3gg43fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg4 = {  "gg4", // class name
  bases_gg4, 6,
  &(vtc_gg4[0]), // expected_vtbl_contents
  &(vtt_gg4[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI3gg4),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3gg4),15, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3gg4),5, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa5  {
  int a;
   aa5(); // _ZN3aa5C1Ev
  virtual void  foo(); // _ZN3aa53fooEv
  ~aa5(); // tgen
};
//SIG(-1 aa5) C1{ v1 Fi}


 aa5 ::aa5(){ note_ctor("aa5", this);}
void  aa5 ::foo(){vfunc_called(this, "_ZN3aa53fooEv");}
aa5 ::~aa5(){ note_dtor("aa5", this);} // tgen

static void Test_aa5()
{
  extern Class_Descriptor cd_aa5;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa5, buf);
    aa5 *dp, &lv = *(dp=new (buf) aa5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa5)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa5.a");
    test_class_info(&lv, &cd_aa5);
    dp->~aa5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa5(Test_aa5, "aa5", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aa5C1Ev();
extern void _ZN3aa5D1Ev();
Name_Map name_map_aa5[] = {
  NSPAIR(_ZN3aa5C1Ev),
  NSPAIR(_ZN3aa5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3aa5[];
extern void _ZN3aa53fooEv();
static  VTBL_ENTRY vtc_aa5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3aa5[0]),
  (VTBL_ENTRY)&_ZN3aa53fooEv,
};
extern VTBL_ENTRY _ZTI3aa5[];
extern  VTBL_ENTRY _ZTV3aa5[];
Class_Descriptor cd_aa5 = {  "aa5", // class name
  0,0,//no base classes
  &(vtc_aa5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3aa5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3aa5),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb5  {
  int b;
   bb5(); // _ZN3bb5C1Ev
  virtual void  foo(); // _ZN3bb53fooEv
  ~bb5(); // tgen
};
//SIG(-1 bb5) C1{ v1 Fi}


 bb5 ::bb5(){ note_ctor("bb5", this);}
void  bb5 ::foo(){vfunc_called(this, "_ZN3bb53fooEv");}
bb5 ::~bb5(){ note_dtor("bb5", this);} // tgen

static void Test_bb5()
{
  extern Class_Descriptor cd_bb5;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb5, buf);
    bb5 *dp, &lv = *(dp=new (buf) bb5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb5)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb5.b");
    test_class_info(&lv, &cd_bb5);
    dp->~bb5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb5(Test_bb5, "bb5", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3bb5C1Ev();
extern void _ZN3bb5D1Ev();
Name_Map name_map_bb5[] = {
  NSPAIR(_ZN3bb5C1Ev),
  NSPAIR(_ZN3bb5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3bb5[];
extern void _ZN3bb53fooEv();
static  VTBL_ENTRY vtc_bb5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3bb5[0]),
  (VTBL_ENTRY)&_ZN3bb53fooEv,
};
extern VTBL_ENTRY _ZTI3bb5[];
extern  VTBL_ENTRY _ZTV3bb5[];
Class_Descriptor cd_bb5 = {  "bb5", // class name
  0,0,//no base classes
  &(vtc_bb5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3bb5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3bb5),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc5  {
  int c;
   cc5(); // _ZN3cc5C1Ev
  virtual void  foo(); // _ZN3cc53fooEv
  ~cc5(); // tgen
};
//SIG(-1 cc5) C1{ v1 Fi}


 cc5 ::cc5(){ note_ctor("cc5", this);}
void  cc5 ::foo(){vfunc_called(this, "_ZN3cc53fooEv");}
cc5 ::~cc5(){ note_dtor("cc5", this);} // tgen

static void Test_cc5()
{
  extern Class_Descriptor cd_cc5;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc5, buf);
    cc5 *dp, &lv = *(dp=new (buf) cc5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc5)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc5.c");
    test_class_info(&lv, &cd_cc5);
    dp->~cc5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc5(Test_cc5, "cc5", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3cc5C1Ev();
extern void _ZN3cc5D1Ev();
Name_Map name_map_cc5[] = {
  NSPAIR(_ZN3cc5C1Ev),
  NSPAIR(_ZN3cc5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3cc5[];
extern void _ZN3cc53fooEv();
static  VTBL_ENTRY vtc_cc5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3cc5[0]),
  (VTBL_ENTRY)&_ZN3cc53fooEv,
};
extern VTBL_ENTRY _ZTI3cc5[];
extern  VTBL_ENTRY _ZTV3cc5[];
Class_Descriptor cd_cc5 = {  "cc5", // class name
  0,0,//no base classes
  &(vtc_cc5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3cc5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3cc5),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd5  {
  int d;
   dd5(); // _ZN3dd5C1Ev
  virtual void  foo(); // _ZN3dd53fooEv
  ~dd5(); // tgen
};
//SIG(-1 dd5) C1{ v1 Fi}


 dd5 ::dd5(){ note_ctor("dd5", this);}
void  dd5 ::foo(){vfunc_called(this, "_ZN3dd53fooEv");}
dd5 ::~dd5(){ note_dtor("dd5", this);} // tgen

static void Test_dd5()
{
  extern Class_Descriptor cd_dd5;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd5, buf);
    dd5 *dp, &lv = *(dp=new (buf) dd5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd5)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd5.d");
    test_class_info(&lv, &cd_dd5);
    dp->~dd5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd5(Test_dd5, "dd5", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3dd5C1Ev();
extern void _ZN3dd5D1Ev();
Name_Map name_map_dd5[] = {
  NSPAIR(_ZN3dd5C1Ev),
  NSPAIR(_ZN3dd5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3dd5[];
extern void _ZN3dd53fooEv();
static  VTBL_ENTRY vtc_dd5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3dd5[0]),
  (VTBL_ENTRY)&_ZN3dd53fooEv,
};
extern VTBL_ENTRY _ZTI3dd5[];
extern  VTBL_ENTRY _ZTV3dd5[];
Class_Descriptor cd_dd5 = {  "dd5", // class name
  0,0,//no base classes
  &(vtc_dd5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3dd5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3dd5),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee5  : virtual aa5 , bb5 {
  int e;
   ee5(const ABISELECT(__tsi64,int) *const *); // _ZN3ee5C2Ev
  virtual void  foo(); // _ZN3ee53fooEv
  ~ee5(); // tgen
  ee5(); // tgen
};
//SIG(-1 ee5) C1{ VBC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ee5 ::ee5(const ABISELECT(__tsi64,int) *const *){}
void  ee5 ::foo(){vfunc_called(this, "_ZN3ee53fooEv");}
ee5 ::~ee5(){ note_dtor("ee5", this);} // tgen
ee5 ::ee5(){ note_ctor("ee5", this);} // tgen

static void Test_ee5()
{
  extern Class_Descriptor cd_ee5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee5, buf);
    ee5 *dp, &lv = *(dp=new (buf) ee5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee5)");
    check_base_class_offset(lv, (aa5*), ABISELECT(16,12), "ee5");
    check_base_class_offset(lv, (bb5*), 0, "ee5");
    check_field_offset(lv, e, ABISELECT(12,8), "ee5.e");
    test_class_info(&lv, &cd_ee5);
    dp->~ee5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee5(Test_ee5, "ee5", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3ee5C1Ev();
extern void _ZN3ee5D1Ev();
Name_Map name_map_ee5[] = {
  NSPAIR(_ZN3ee5C1Ev),
  NSPAIR(_ZN3ee5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa5;
extern VTBL_ENTRY _ZTI3aa5[];
extern  VTBL_ENTRY _ZTV3aa5[];
extern Class_Descriptor cd_bb5;
extern VTBL_ENTRY _ZTI3bb5[];
extern  VTBL_ENTRY _ZTV3bb5[];
static Base_Class bases_ee5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa5,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_bb5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3ee5[];
extern void _ZN3ee53fooEv();
extern void ABISELECT(_ZTv0_n24_N3ee53fooEv,_ZTv0_n12_N3ee53fooEv)();
extern void ABISELECT(_ZThn16_N3ee53fooEv,_ZThn12_N3ee53fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee5[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI3ee5[0]),
  (VTBL_ENTRY)&_ZN3ee53fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI3ee5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ee53fooEv,_ZTv0_n12_N3ee53fooEv),
};
extern VTBL_ENTRY _ZTV3ee5[];
static  VTT_ENTRY vtt_ee5[] = {
  {&(_ZTV3ee5[3]),  3,8},
  {&(_ZTV3ee5[7]),  7,8},
};
extern VTBL_ENTRY _ZTI3ee5[];
extern  VTBL_ENTRY _ZTV3ee5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3ee5[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ee53fooEv,_ZTv0_n12_N3ee53fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3ee53fooEv,_ZThn12_N3ee53fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee5 = {  "ee5", // class name
  bases_ee5, 2,
  &(vtc_ee5[0]), // expected_vtbl_contents
  &(vtt_ee5[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3ee5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3ee5),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3ee5),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff5  : virtual cc5 , dd5 {
  int f;
   ff5(const ABISELECT(__tsi64,int) *const *); // _ZN3ff5C2Ev
  virtual void  foo(); // _ZN3ff53fooEv
  ~ff5(); // tgen
  ff5(); // tgen
};
//SIG(-1 ff5) C1{ VBC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ff5 ::ff5(const ABISELECT(__tsi64,int) *const *){}
void  ff5 ::foo(){vfunc_called(this, "_ZN3ff53fooEv");}
ff5 ::~ff5(){ note_dtor("ff5", this);} // tgen
ff5 ::ff5(){ note_ctor("ff5", this);} // tgen

static void Test_ff5()
{
  extern Class_Descriptor cd_ff5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff5, buf);
    ff5 *dp, &lv = *(dp=new (buf) ff5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff5)");
    check_base_class_offset(lv, (cc5*), ABISELECT(16,12), "ff5");
    check_base_class_offset(lv, (dd5*), 0, "ff5");
    check_field_offset(lv, f, ABISELECT(12,8), "ff5.f");
    test_class_info(&lv, &cd_ff5);
    dp->~ff5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff5(Test_ff5, "ff5", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3ff5C1Ev();
extern void _ZN3ff5D1Ev();
Name_Map name_map_ff5[] = {
  NSPAIR(_ZN3ff5C1Ev),
  NSPAIR(_ZN3ff5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc5;
extern VTBL_ENTRY _ZTI3cc5[];
extern  VTBL_ENTRY _ZTV3cc5[];
extern Class_Descriptor cd_dd5;
extern VTBL_ENTRY _ZTI3dd5[];
extern  VTBL_ENTRY _ZTV3dd5[];
static Base_Class bases_ff5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc5,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_dd5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3ff5[];
extern void _ZN3ff53fooEv();
extern void ABISELECT(_ZTv0_n24_N3ff53fooEv,_ZTv0_n12_N3ff53fooEv)();
extern void ABISELECT(_ZThn16_N3ff53fooEv,_ZThn12_N3ff53fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff5[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI3ff5[0]),
  (VTBL_ENTRY)&_ZN3ff53fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI3ff5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ff53fooEv,_ZTv0_n12_N3ff53fooEv),
};
extern VTBL_ENTRY _ZTV3ff5[];
static  VTT_ENTRY vtt_ff5[] = {
  {&(_ZTV3ff5[3]),  3,8},
  {&(_ZTV3ff5[7]),  7,8},
};
extern VTBL_ENTRY _ZTI3ff5[];
extern  VTBL_ENTRY _ZTV3ff5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3ff5[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ff53fooEv,_ZTv0_n12_N3ff53fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3ff53fooEv,_ZThn12_N3ff53fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff5 = {  "ff5", // class name
  bases_ff5, 2,
  &(vtc_ff5[0]), // expected_vtbl_contents
  &(vtt_ff5[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3ff5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3ff5),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3ff5),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg5  : ee5 , ff5 {
  int g;
   gg5(const ABISELECT(__tsi64,int) *const *); // _ZN3gg5C2Ev
  virtual void  foo(); // _ZN3gg53fooEv
  ~gg5(); // tgen
  gg5(); // tgen
};
//SIG(1 gg5) C1{ BC2{ VBC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ VBC6{ v1 Fi} BC7{ v1 Fi} v1 Fi} v1 Fi}


 gg5 ::gg5(const ABISELECT(__tsi64,int) *const *){}
void  gg5 ::foo(){vfunc_called(this, "_ZN3gg53fooEv");}
gg5 ::~gg5(){ note_dtor("gg5", this);} // tgen
gg5 ::gg5(){ note_ctor("gg5", this);} // tgen

static void Test_gg5()
{
  extern Class_Descriptor cd_gg5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg5, buf);
    gg5 *dp, &lv = *(dp=new (buf) gg5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg5)");
    check_base_class_offset(lv, (aa5*)(ee5*), ABISELECT(40,28), "gg5");
    check_base_class_offset(lv, (bb5*)(ee5*), 0, "gg5");
    check_base_class_offset(lv, (ee5*), 0, "gg5");
    check_base_class_offset(lv, (cc5*)(ff5*), ABISELECT(56,36), "gg5");
    check_base_class_offset(lv, (dd5*)(ff5*), ABISELECT(16,12), "gg5");
    check_base_class_offset(lv, (ff5*), ABISELECT(16,12), "gg5");
    check_field_offset(lv, g, ABISELECT(32,24), "gg5.g");
    test_class_info(&lv, &cd_gg5);
    dp->~gg5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg5(Test_gg5, "gg5", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3gg5C1Ev();
extern void _ZN3gg5D1Ev();
Name_Map name_map_gg5[] = {
  NSPAIR(_ZN3gg5C1Ev),
  NSPAIR(_ZN3gg5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa5;
extern VTBL_ENTRY _ZTI3aa5[];
extern  VTBL_ENTRY _ZTV3aa5[];
extern Class_Descriptor cd_bb5;
extern VTBL_ENTRY _ZTI3bb5[];
extern  VTBL_ENTRY _ZTV3bb5[];
extern Class_Descriptor cd_ee5;
extern VTBL_ENTRY _ZTI3ee5[];
extern  VTBL_ENTRY _ZTV3ee5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3ee5[];
extern Class_Descriptor cd_cc5;
extern VTBL_ENTRY _ZTI3cc5[];
extern  VTBL_ENTRY _ZTV3cc5[];
extern Class_Descriptor cd_dd5;
extern VTBL_ENTRY _ZTI3dd5[];
extern  VTBL_ENTRY _ZTV3dd5[];
extern Class_Descriptor cd_ff5;
extern VTBL_ENTRY _ZTI3ff5[];
extern  VTBL_ENTRY _ZTV3ff5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3ff5[];
static Base_Class bases_gg5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa5,    ABISELECT(40,28), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_bb5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_ee5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc5,    ABISELECT(56,36), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_dd5,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_ff5,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3gg5[];
extern void _ZN3gg53fooEv();
extern void ABISELECT(_ZThn16_N3gg53fooEv,_ZThn12_N3gg53fooEv)();
extern void ABISELECT(_ZTv0_n24_N3gg53fooEv,_ZTv0_n12_N3gg53fooEv)();
extern void ABISELECT(_ZThn40_N3gg53fooEv,_ZThn28_N3gg53fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N3gg53fooEv,_ZTv0_n12_N3gg53fooEv)();
extern void ABISELECT(_ZThn56_N3gg53fooEv,_ZThn36_N3gg53fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg5[] = {
  ABISELECT(56,36),
  ABISELECT(40,28),
  0,
  (VTBL_ENTRY)&(_ZTI3gg5[0]),
  (VTBL_ENTRY)&_ZN3gg53fooEv,
  ABISELECT(40,24),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI3gg5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3gg53fooEv,_ZThn12_N3gg53fooEv),
  ABISELECT(-40,-28),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI3gg5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3gg53fooEv,_ZTv0_n12_N3gg53fooEv),
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI3gg5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3gg53fooEv,_ZTv0_n12_N3gg53fooEv),
};
extern VTBL_ENTRY _ZTV3gg5[];
extern void _ZN3ee53fooEv();
static  VTBL_ENTRY _tg__ZTV3ee5__3gg5[] = {
  ABISELECT(40,28),
  0,
  (VTBL_ENTRY)&(_ZTI3ee5[0]),
  (VTBL_ENTRY)&_ZN3ee53fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3ee53fooEv,_ZTv0_n12_N3ee53fooEv)();
extern void ABISELECT(_ZThn40_N3ee53fooEv,_ZThn28_N3ee53fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3aa5__3ee5__3gg5[] = {
  ABISELECT(-40,-28),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI3ee5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ee53fooEv,_ZTv0_n12_N3ee53fooEv),
};
extern void _ZN3ff53fooEv();
static  VTBL_ENTRY _tg__ZTV3ff5__3gg5[] = {
  ABISELECT(40,24),
  0,
  (VTBL_ENTRY)&(_ZTI3ff5[0]),
  (VTBL_ENTRY)&_ZN3ff53fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3ff53fooEv,_ZTv0_n12_N3ff53fooEv)();
extern void ABISELECT(_ZThn40_N3ff53fooEv,_ZThn24_N3ff53fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3cc5__3ff5__3gg5[] = {
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI3ff5[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ff53fooEv,_ZTv0_n12_N3ff53fooEv),
};
static  VTT_ENTRY vtt_gg5[] = {
  {&(_ZTV3gg5[4]),  4,17},
  {&(_tg__ZTV3ee5__3gg5[3]),  3,4},
  {&(_tg__ZTV3aa5__3ee5__3gg5[3]),  3,4},
  {&(_tg__ZTV3ff5__3gg5[3]),  3,4},
  {&(_tg__ZTV3cc5__3ff5__3gg5[3]),  3,4},
  {&(_ZTV3gg5[12]),  12,17},
  {&(_ZTV3gg5[8]),  8,17},
  {&(_ZTV3gg5[16]),  16,17},
};
extern VTBL_ENTRY _ZTI3gg5[];
extern  VTBL_ENTRY _ZTV3gg5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3gg5[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ff53fooEv,_ZTv0_n12_N3ff53fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N3ff53fooEv,_ZThn24_N3ff53fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ee53fooEv,_ZTv0_n12_N3ee53fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N3ee53fooEv,_ZThn28_N3ee53fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3gg53fooEv,_ZTv0_n12_N3gg53fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N3gg53fooEv,_ZThn36_N3gg53fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N3gg53fooEv,_ZThn28_N3gg53fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg5 = {  "gg5", // class name
  bases_gg5, 6,
  &(vtc_gg5[0]), // expected_vtbl_contents
  &(vtt_gg5[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI3gg5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3gg5),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3gg5),8, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa6  {
  int a;
   aa6(); // _ZN3aa6C1Ev
  virtual void  foo(); // _ZN3aa63fooEv
  ~aa6(); // tgen
};
//SIG(-1 aa6) C1{ v1 Fi}


 aa6 ::aa6(){ note_ctor("aa6", this);}
void  aa6 ::foo(){vfunc_called(this, "_ZN3aa63fooEv");}
aa6 ::~aa6(){ note_dtor("aa6", this);} // tgen

static void Test_aa6()
{
  extern Class_Descriptor cd_aa6;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa6, buf);
    aa6 *dp, &lv = *(dp=new (buf) aa6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa6)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa6.a");
    test_class_info(&lv, &cd_aa6);
    dp->~aa6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa6(Test_aa6, "aa6", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aa6C1Ev();
extern void _ZN3aa6D1Ev();
Name_Map name_map_aa6[] = {
  NSPAIR(_ZN3aa6C1Ev),
  NSPAIR(_ZN3aa6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3aa6[];
extern void _ZN3aa63fooEv();
static  VTBL_ENTRY vtc_aa6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3aa6[0]),
  (VTBL_ENTRY)&_ZN3aa63fooEv,
};
extern VTBL_ENTRY _ZTI3aa6[];
extern  VTBL_ENTRY _ZTV3aa6[];
Class_Descriptor cd_aa6 = {  "aa6", // class name
  0,0,//no base classes
  &(vtc_aa6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3aa6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3aa6),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb6  {
  int b;
   bb6(); // _ZN3bb6C1Ev
  virtual void  foo(); // _ZN3bb63fooEv
  ~bb6(); // tgen
};
//SIG(-1 bb6) C1{ v1 Fi}


 bb6 ::bb6(){ note_ctor("bb6", this);}
void  bb6 ::foo(){vfunc_called(this, "_ZN3bb63fooEv");}
bb6 ::~bb6(){ note_dtor("bb6", this);} // tgen

static void Test_bb6()
{
  extern Class_Descriptor cd_bb6;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb6, buf);
    bb6 *dp, &lv = *(dp=new (buf) bb6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb6)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb6.b");
    test_class_info(&lv, &cd_bb6);
    dp->~bb6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb6(Test_bb6, "bb6", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3bb6C1Ev();
extern void _ZN3bb6D1Ev();
Name_Map name_map_bb6[] = {
  NSPAIR(_ZN3bb6C1Ev),
  NSPAIR(_ZN3bb6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3bb6[];
extern void _ZN3bb63fooEv();
static  VTBL_ENTRY vtc_bb6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3bb6[0]),
  (VTBL_ENTRY)&_ZN3bb63fooEv,
};
extern VTBL_ENTRY _ZTI3bb6[];
extern  VTBL_ENTRY _ZTV3bb6[];
Class_Descriptor cd_bb6 = {  "bb6", // class name
  0,0,//no base classes
  &(vtc_bb6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3bb6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3bb6),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc6  {
  int c;
   cc6(); // _ZN3cc6C1Ev
  virtual void  foo(); // _ZN3cc63fooEv
  ~cc6(); // tgen
};
//SIG(-1 cc6) C1{ v1 Fi}


 cc6 ::cc6(){ note_ctor("cc6", this);}
void  cc6 ::foo(){vfunc_called(this, "_ZN3cc63fooEv");}
cc6 ::~cc6(){ note_dtor("cc6", this);} // tgen

static void Test_cc6()
{
  extern Class_Descriptor cd_cc6;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc6, buf);
    cc6 *dp, &lv = *(dp=new (buf) cc6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc6)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc6.c");
    test_class_info(&lv, &cd_cc6);
    dp->~cc6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc6(Test_cc6, "cc6", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3cc6C1Ev();
extern void _ZN3cc6D1Ev();
Name_Map name_map_cc6[] = {
  NSPAIR(_ZN3cc6C1Ev),
  NSPAIR(_ZN3cc6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3cc6[];
extern void _ZN3cc63fooEv();
static  VTBL_ENTRY vtc_cc6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3cc6[0]),
  (VTBL_ENTRY)&_ZN3cc63fooEv,
};
extern VTBL_ENTRY _ZTI3cc6[];
extern  VTBL_ENTRY _ZTV3cc6[];
Class_Descriptor cd_cc6 = {  "cc6", // class name
  0,0,//no base classes
  &(vtc_cc6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3cc6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3cc6),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd6  {
  int d;
   dd6(); // _ZN3dd6C1Ev
  virtual void  foo(); // _ZN3dd63fooEv
  ~dd6(); // tgen
};
//SIG(-1 dd6) C1{ v1 Fi}


 dd6 ::dd6(){ note_ctor("dd6", this);}
void  dd6 ::foo(){vfunc_called(this, "_ZN3dd63fooEv");}
dd6 ::~dd6(){ note_dtor("dd6", this);} // tgen

static void Test_dd6()
{
  extern Class_Descriptor cd_dd6;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd6, buf);
    dd6 *dp, &lv = *(dp=new (buf) dd6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd6)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd6.d");
    test_class_info(&lv, &cd_dd6);
    dp->~dd6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd6(Test_dd6, "dd6", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3dd6C1Ev();
extern void _ZN3dd6D1Ev();
Name_Map name_map_dd6[] = {
  NSPAIR(_ZN3dd6C1Ev),
  NSPAIR(_ZN3dd6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3dd6[];
extern void _ZN3dd63fooEv();
static  VTBL_ENTRY vtc_dd6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3dd6[0]),
  (VTBL_ENTRY)&_ZN3dd63fooEv,
};
extern VTBL_ENTRY _ZTI3dd6[];
extern  VTBL_ENTRY _ZTV3dd6[];
Class_Descriptor cd_dd6 = {  "dd6", // class name
  0,0,//no base classes
  &(vtc_dd6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3dd6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3dd6),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee6  : aa6 , virtual bb6 {
  int e;
   ee6(const ABISELECT(__tsi64,int) *const *); // _ZN3ee6C2Ev
  virtual void  foo(); // _ZN3ee63fooEv
  ~ee6(); // tgen
  ee6(); // tgen
};
//SIG(-1 ee6) C1{ BC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ee6 ::ee6(const ABISELECT(__tsi64,int) *const *){}
void  ee6 ::foo(){vfunc_called(this, "_ZN3ee63fooEv");}
ee6 ::~ee6(){ note_dtor("ee6", this);} // tgen
ee6 ::ee6(){ note_ctor("ee6", this);} // tgen

static void Test_ee6()
{
  extern Class_Descriptor cd_ee6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee6, buf);
    ee6 *dp, &lv = *(dp=new (buf) ee6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee6)");
    check_base_class_offset(lv, (aa6*), 0, "ee6");
    check_base_class_offset(lv, (bb6*), ABISELECT(16,12), "ee6");
    check_field_offset(lv, e, ABISELECT(12,8), "ee6.e");
    test_class_info(&lv, &cd_ee6);
    dp->~ee6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee6(Test_ee6, "ee6", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3ee6C1Ev();
extern void _ZN3ee6D1Ev();
Name_Map name_map_ee6[] = {
  NSPAIR(_ZN3ee6C1Ev),
  NSPAIR(_ZN3ee6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa6;
extern VTBL_ENTRY _ZTI3aa6[];
extern  VTBL_ENTRY _ZTV3aa6[];
extern Class_Descriptor cd_bb6;
extern VTBL_ENTRY _ZTI3bb6[];
extern  VTBL_ENTRY _ZTV3bb6[];
static Base_Class bases_ee6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_bb6,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3ee6[];
extern void _ZN3ee63fooEv();
extern void ABISELECT(_ZTv0_n24_N3ee63fooEv,_ZTv0_n12_N3ee63fooEv)();
extern void ABISELECT(_ZThn16_N3ee63fooEv,_ZThn12_N3ee63fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee6[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI3ee6[0]),
  (VTBL_ENTRY)&_ZN3ee63fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI3ee6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ee63fooEv,_ZTv0_n12_N3ee63fooEv),
};
extern VTBL_ENTRY _ZTV3ee6[];
static  VTT_ENTRY vtt_ee6[] = {
  {&(_ZTV3ee6[3]),  3,8},
  {&(_ZTV3ee6[7]),  7,8},
};
extern VTBL_ENTRY _ZTI3ee6[];
extern  VTBL_ENTRY _ZTV3ee6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3ee6[];
static VTBL_ENTRY alt_thunk_names12[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ee63fooEv,_ZTv0_n12_N3ee63fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3ee63fooEv,_ZThn12_N3ee63fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee6 = {  "ee6", // class name
  bases_ee6, 2,
  &(vtc_ee6[0]), // expected_vtbl_contents
  &(vtt_ee6[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3ee6),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3ee6),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3ee6),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names12,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff6  : virtual cc6 , dd6 {
  int f;
   ff6(const ABISELECT(__tsi64,int) *const *); // _ZN3ff6C2Ev
  virtual void  foo(); // _ZN3ff63fooEv
  ~ff6(); // tgen
  ff6(); // tgen
};
//SIG(-1 ff6) C1{ VBC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ff6 ::ff6(const ABISELECT(__tsi64,int) *const *){}
void  ff6 ::foo(){vfunc_called(this, "_ZN3ff63fooEv");}
ff6 ::~ff6(){ note_dtor("ff6", this);} // tgen
ff6 ::ff6(){ note_ctor("ff6", this);} // tgen

static void Test_ff6()
{
  extern Class_Descriptor cd_ff6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff6, buf);
    ff6 *dp, &lv = *(dp=new (buf) ff6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff6)");
    check_base_class_offset(lv, (cc6*), ABISELECT(16,12), "ff6");
    check_base_class_offset(lv, (dd6*), 0, "ff6");
    check_field_offset(lv, f, ABISELECT(12,8), "ff6.f");
    test_class_info(&lv, &cd_ff6);
    dp->~ff6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff6(Test_ff6, "ff6", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3ff6C1Ev();
extern void _ZN3ff6D1Ev();
Name_Map name_map_ff6[] = {
  NSPAIR(_ZN3ff6C1Ev),
  NSPAIR(_ZN3ff6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc6;
extern VTBL_ENTRY _ZTI3cc6[];
extern  VTBL_ENTRY _ZTV3cc6[];
extern Class_Descriptor cd_dd6;
extern VTBL_ENTRY _ZTI3dd6[];
extern  VTBL_ENTRY _ZTV3dd6[];
static Base_Class bases_ff6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc6,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_dd6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3ff6[];
extern void _ZN3ff63fooEv();
extern void ABISELECT(_ZTv0_n24_N3ff63fooEv,_ZTv0_n12_N3ff63fooEv)();
extern void ABISELECT(_ZThn16_N3ff63fooEv,_ZThn12_N3ff63fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff6[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI3ff6[0]),
  (VTBL_ENTRY)&_ZN3ff63fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI3ff6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ff63fooEv,_ZTv0_n12_N3ff63fooEv),
};
extern VTBL_ENTRY _ZTV3ff6[];
static  VTT_ENTRY vtt_ff6[] = {
  {&(_ZTV3ff6[3]),  3,8},
  {&(_ZTV3ff6[7]),  7,8},
};
extern VTBL_ENTRY _ZTI3ff6[];
extern  VTBL_ENTRY _ZTV3ff6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3ff6[];
static VTBL_ENTRY alt_thunk_names13[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ff63fooEv,_ZTv0_n12_N3ff63fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3ff63fooEv,_ZThn12_N3ff63fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff6 = {  "ff6", // class name
  bases_ff6, 2,
  &(vtc_ff6[0]), // expected_vtbl_contents
  &(vtt_ff6[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3ff6),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3ff6),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3ff6),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names13,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg6  : ee6 , ff6 {
  int g;
   gg6(const ABISELECT(__tsi64,int) *const *); // _ZN3gg6C2Ev
  virtual void  foo(); // _ZN3gg63fooEv
  ~gg6(); // tgen
  gg6(); // tgen
};
//SIG(1 gg6) C1{ BC2{ BC3{ v1 Fi} VBC4{ v1 Fi} v1 Fi} BC5{ VBC6{ v1 Fi} BC7{ v1 Fi} v1 Fi} v1 Fi}


 gg6 ::gg6(const ABISELECT(__tsi64,int) *const *){}
void  gg6 ::foo(){vfunc_called(this, "_ZN3gg63fooEv");}
gg6 ::~gg6(){ note_dtor("gg6", this);} // tgen
gg6 ::gg6(){ note_ctor("gg6", this);} // tgen

static void Test_gg6()
{
  extern Class_Descriptor cd_gg6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg6, buf);
    gg6 *dp, &lv = *(dp=new (buf) gg6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg6)");
    check_base_class_offset(lv, (aa6*)(ee6*), 0, "gg6");
    check_base_class_offset(lv, (bb6*)(ee6*), ABISELECT(40,28), "gg6");
    check_base_class_offset(lv, (ee6*), 0, "gg6");
    check_base_class_offset(lv, (cc6*)(ff6*), ABISELECT(56,36), "gg6");
    check_base_class_offset(lv, (dd6*)(ff6*), ABISELECT(16,12), "gg6");
    check_base_class_offset(lv, (ff6*), ABISELECT(16,12), "gg6");
    check_field_offset(lv, g, ABISELECT(32,24), "gg6.g");
    test_class_info(&lv, &cd_gg6);
    dp->~gg6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg6(Test_gg6, "gg6", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3gg6C1Ev();
extern void _ZN3gg6D1Ev();
Name_Map name_map_gg6[] = {
  NSPAIR(_ZN3gg6C1Ev),
  NSPAIR(_ZN3gg6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa6;
extern VTBL_ENTRY _ZTI3aa6[];
extern  VTBL_ENTRY _ZTV3aa6[];
extern Class_Descriptor cd_bb6;
extern VTBL_ENTRY _ZTI3bb6[];
extern  VTBL_ENTRY _ZTV3bb6[];
extern Class_Descriptor cd_ee6;
extern VTBL_ENTRY _ZTI3ee6[];
extern  VTBL_ENTRY _ZTV3ee6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3ee6[];
extern Class_Descriptor cd_cc6;
extern VTBL_ENTRY _ZTI3cc6[];
extern  VTBL_ENTRY _ZTV3cc6[];
extern Class_Descriptor cd_dd6;
extern VTBL_ENTRY _ZTI3dd6[];
extern  VTBL_ENTRY _ZTV3dd6[];
extern Class_Descriptor cd_ff6;
extern VTBL_ENTRY _ZTI3ff6[];
extern  VTBL_ENTRY _ZTV3ff6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3ff6[];
static Base_Class bases_gg6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_bb6,    ABISELECT(40,28), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_ee6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc6,    ABISELECT(56,36), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_dd6,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_ff6,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3gg6[];
extern void _ZN3gg63fooEv();
extern void ABISELECT(_ZThn16_N3gg63fooEv,_ZThn12_N3gg63fooEv)();
extern void ABISELECT(_ZTv0_n24_N3gg63fooEv,_ZTv0_n12_N3gg63fooEv)();
extern void ABISELECT(_ZThn40_N3gg63fooEv,_ZThn28_N3gg63fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N3gg63fooEv,_ZTv0_n12_N3gg63fooEv)();
extern void ABISELECT(_ZThn56_N3gg63fooEv,_ZThn36_N3gg63fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg6[] = {
  ABISELECT(56,36),
  ABISELECT(40,28),
  0,
  (VTBL_ENTRY)&(_ZTI3gg6[0]),
  (VTBL_ENTRY)&_ZN3gg63fooEv,
  ABISELECT(40,24),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI3gg6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3gg63fooEv,_ZThn12_N3gg63fooEv),
  ABISELECT(-40,-28),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI3gg6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3gg63fooEv,_ZTv0_n12_N3gg63fooEv),
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI3gg6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3gg63fooEv,_ZTv0_n12_N3gg63fooEv),
};
extern VTBL_ENTRY _ZTV3gg6[];
extern void _ZN3ee63fooEv();
static  VTBL_ENTRY _tg__ZTV3ee6__3gg6[] = {
  ABISELECT(40,28),
  0,
  (VTBL_ENTRY)&(_ZTI3ee6[0]),
  (VTBL_ENTRY)&_ZN3ee63fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3ee63fooEv,_ZTv0_n12_N3ee63fooEv)();
extern void ABISELECT(_ZThn40_N3ee63fooEv,_ZThn28_N3ee63fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3bb6__3ee6__3gg6[] = {
  ABISELECT(-40,-28),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI3ee6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ee63fooEv,_ZTv0_n12_N3ee63fooEv),
};
extern void _ZN3ff63fooEv();
static  VTBL_ENTRY _tg__ZTV3ff6__3gg6[] = {
  ABISELECT(40,24),
  0,
  (VTBL_ENTRY)&(_ZTI3ff6[0]),
  (VTBL_ENTRY)&_ZN3ff63fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3ff63fooEv,_ZTv0_n12_N3ff63fooEv)();
extern void ABISELECT(_ZThn40_N3ff63fooEv,_ZThn24_N3ff63fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3cc6__3ff6__3gg6[] = {
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI3ff6[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ff63fooEv,_ZTv0_n12_N3ff63fooEv),
};
static  VTT_ENTRY vtt_gg6[] = {
  {&(_ZTV3gg6[4]),  4,17},
  {&(_tg__ZTV3ee6__3gg6[3]),  3,4},
  {&(_tg__ZTV3bb6__3ee6__3gg6[3]),  3,4},
  {&(_tg__ZTV3ff6__3gg6[3]),  3,4},
  {&(_tg__ZTV3cc6__3ff6__3gg6[3]),  3,4},
  {&(_ZTV3gg6[12]),  12,17},
  {&(_ZTV3gg6[8]),  8,17},
  {&(_ZTV3gg6[16]),  16,17},
};
extern VTBL_ENTRY _ZTI3gg6[];
extern  VTBL_ENTRY _ZTV3gg6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3gg6[];
static VTBL_ENTRY alt_thunk_names14[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ff63fooEv,_ZTv0_n12_N3ff63fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N3ff63fooEv,_ZThn24_N3ff63fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ee63fooEv,_ZTv0_n12_N3ee63fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N3ee63fooEv,_ZThn28_N3ee63fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3gg63fooEv,_ZTv0_n12_N3gg63fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N3gg63fooEv,_ZThn36_N3gg63fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N3gg63fooEv,_ZThn28_N3gg63fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg6 = {  "gg6", // class name
  bases_gg6, 6,
  &(vtc_gg6[0]), // expected_vtbl_contents
  &(vtt_gg6[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI3gg6),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3gg6),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3gg6),8, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names14,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa7  {
  int a;
   aa7(); // _ZN3aa7C1Ev
  virtual void  foo(); // _ZN3aa73fooEv
  ~aa7(); // tgen
};
//SIG(-1 aa7) C1{ v1 Fi}


 aa7 ::aa7(){ note_ctor("aa7", this);}
void  aa7 ::foo(){vfunc_called(this, "_ZN3aa73fooEv");}
aa7 ::~aa7(){ note_dtor("aa7", this);} // tgen

static void Test_aa7()
{
  extern Class_Descriptor cd_aa7;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa7, buf);
    aa7 *dp, &lv = *(dp=new (buf) aa7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa7)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa7.a");
    test_class_info(&lv, &cd_aa7);
    dp->~aa7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa7(Test_aa7, "aa7", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aa7C1Ev();
extern void _ZN3aa7D1Ev();
Name_Map name_map_aa7[] = {
  NSPAIR(_ZN3aa7C1Ev),
  NSPAIR(_ZN3aa7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3aa7[];
extern void _ZN3aa73fooEv();
static  VTBL_ENTRY vtc_aa7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3aa7[0]),
  (VTBL_ENTRY)&_ZN3aa73fooEv,
};
extern VTBL_ENTRY _ZTI3aa7[];
extern  VTBL_ENTRY _ZTV3aa7[];
Class_Descriptor cd_aa7 = {  "aa7", // class name
  0,0,//no base classes
  &(vtc_aa7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3aa7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3aa7),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb7  {
  int b;
   bb7(); // _ZN3bb7C1Ev
  virtual void  foo(); // _ZN3bb73fooEv
  ~bb7(); // tgen
};
//SIG(-1 bb7) C1{ v1 Fi}


 bb7 ::bb7(){ note_ctor("bb7", this);}
void  bb7 ::foo(){vfunc_called(this, "_ZN3bb73fooEv");}
bb7 ::~bb7(){ note_dtor("bb7", this);} // tgen

static void Test_bb7()
{
  extern Class_Descriptor cd_bb7;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb7, buf);
    bb7 *dp, &lv = *(dp=new (buf) bb7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb7)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb7.b");
    test_class_info(&lv, &cd_bb7);
    dp->~bb7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb7(Test_bb7, "bb7", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3bb7C1Ev();
extern void _ZN3bb7D1Ev();
Name_Map name_map_bb7[] = {
  NSPAIR(_ZN3bb7C1Ev),
  NSPAIR(_ZN3bb7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3bb7[];
extern void _ZN3bb73fooEv();
static  VTBL_ENTRY vtc_bb7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3bb7[0]),
  (VTBL_ENTRY)&_ZN3bb73fooEv,
};
extern VTBL_ENTRY _ZTI3bb7[];
extern  VTBL_ENTRY _ZTV3bb7[];
Class_Descriptor cd_bb7 = {  "bb7", // class name
  0,0,//no base classes
  &(vtc_bb7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3bb7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3bb7),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc7  {
  int c;
   cc7(); // _ZN3cc7C1Ev
  virtual void  foo(); // _ZN3cc73fooEv
  ~cc7(); // tgen
};
//SIG(-1 cc7) C1{ v1 Fi}


 cc7 ::cc7(){ note_ctor("cc7", this);}
void  cc7 ::foo(){vfunc_called(this, "_ZN3cc73fooEv");}
cc7 ::~cc7(){ note_dtor("cc7", this);} // tgen

static void Test_cc7()
{
  extern Class_Descriptor cd_cc7;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc7, buf);
    cc7 *dp, &lv = *(dp=new (buf) cc7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc7)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc7.c");
    test_class_info(&lv, &cd_cc7);
    dp->~cc7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc7(Test_cc7, "cc7", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3cc7C1Ev();
extern void _ZN3cc7D1Ev();
Name_Map name_map_cc7[] = {
  NSPAIR(_ZN3cc7C1Ev),
  NSPAIR(_ZN3cc7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3cc7[];
extern void _ZN3cc73fooEv();
static  VTBL_ENTRY vtc_cc7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3cc7[0]),
  (VTBL_ENTRY)&_ZN3cc73fooEv,
};
extern VTBL_ENTRY _ZTI3cc7[];
extern  VTBL_ENTRY _ZTV3cc7[];
Class_Descriptor cd_cc7 = {  "cc7", // class name
  0,0,//no base classes
  &(vtc_cc7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3cc7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3cc7),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd7  {
  int d;
   dd7(); // _ZN3dd7C1Ev
  virtual void  foo(); // _ZN3dd73fooEv
  ~dd7(); // tgen
};
//SIG(-1 dd7) C1{ v1 Fi}


 dd7 ::dd7(){ note_ctor("dd7", this);}
void  dd7 ::foo(){vfunc_called(this, "_ZN3dd73fooEv");}
dd7 ::~dd7(){ note_dtor("dd7", this);} // tgen

static void Test_dd7()
{
  extern Class_Descriptor cd_dd7;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd7, buf);
    dd7 *dp, &lv = *(dp=new (buf) dd7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd7)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd7.d");
    test_class_info(&lv, &cd_dd7);
    dp->~dd7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd7(Test_dd7, "dd7", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3dd7C1Ev();
extern void _ZN3dd7D1Ev();
Name_Map name_map_dd7[] = {
  NSPAIR(_ZN3dd7C1Ev),
  NSPAIR(_ZN3dd7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3dd7[];
extern void _ZN3dd73fooEv();
static  VTBL_ENTRY vtc_dd7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3dd7[0]),
  (VTBL_ENTRY)&_ZN3dd73fooEv,
};
extern VTBL_ENTRY _ZTI3dd7[];
extern  VTBL_ENTRY _ZTV3dd7[];
Class_Descriptor cd_dd7 = {  "dd7", // class name
  0,0,//no base classes
  &(vtc_dd7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3dd7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3dd7),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee7  : virtual aa7 , virtual bb7 {
  int e;
   ee7(const ABISELECT(__tsi64,int) *const *); // _ZN3ee7C2Ev
  virtual void  foo(); // _ZN3ee73fooEv
  ~ee7(); // tgen
  ee7(); // tgen
};
//SIG(-1 ee7) C1{ VBC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ee7 ::ee7(const ABISELECT(__tsi64,int) *const *){}
void  ee7 ::foo(){vfunc_called(this, "_ZN3ee73fooEv");}
ee7 ::~ee7(){ note_dtor("ee7", this);} // tgen
ee7 ::ee7(){ note_ctor("ee7", this);} // tgen

static void Test_ee7()
{
  extern Class_Descriptor cd_ee7;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_ee7, buf);
    ee7 *dp, &lv = *(dp=new (buf) ee7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(ee7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee7)");
    check_base_class_offset(lv, (aa7*), ABISELECT(16,8), "ee7");
    check_base_class_offset(lv, (bb7*), ABISELECT(32,16), "ee7");
    check_field_offset(lv, e, ABISELECT(8,4), "ee7.e");
    test_class_info(&lv, &cd_ee7);
    dp->~ee7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee7(Test_ee7, "ee7", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN3ee7C1Ev();
extern void _ZN3ee7D1Ev();
Name_Map name_map_ee7[] = {
  NSPAIR(_ZN3ee7C1Ev),
  NSPAIR(_ZN3ee7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa7;
extern VTBL_ENTRY _ZTI3aa7[];
extern  VTBL_ENTRY _ZTV3aa7[];
extern Class_Descriptor cd_bb7;
extern VTBL_ENTRY _ZTI3bb7[];
extern  VTBL_ENTRY _ZTV3bb7[];
static Base_Class bases_ee7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa7,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_bb7,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3ee7[];
extern void _ZN3ee73fooEv();
extern void ABISELECT(_ZTv0_n24_N3ee73fooEv,_ZTv0_n12_N3ee73fooEv)();
extern void ABISELECT(_ZThn16_N3ee73fooEv,_ZThn8_N3ee73fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N3ee73fooEv,_ZTv0_n12_N3ee73fooEv)();
extern void ABISELECT(_ZThn32_N3ee73fooEv,_ZThn16_N3ee73fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee7[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI3ee7[0]),
  (VTBL_ENTRY)&_ZN3ee73fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3ee7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ee73fooEv,_ZTv0_n12_N3ee73fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI3ee7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ee73fooEv,_ZTv0_n12_N3ee73fooEv),
};
extern VTBL_ENTRY _ZTV3ee7[];
static  VTT_ENTRY vtt_ee7[] = {
  {&(_ZTV3ee7[4]),  4,13},
  {&(_ZTV3ee7[8]),  8,13},
  {&(_ZTV3ee7[12]),  12,13},
};
extern VTBL_ENTRY _ZTI3ee7[];
extern  VTBL_ENTRY _ZTV3ee7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3ee7[];
static VTBL_ENTRY alt_thunk_names15[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ee73fooEv,_ZTv0_n12_N3ee73fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N3ee73fooEv,_ZThn16_N3ee73fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3ee73fooEv,_ZThn8_N3ee73fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee7 = {  "ee7", // class name
  bases_ee7, 2,
  &(vtc_ee7[0]), // expected_vtbl_contents
  &(vtt_ee7[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI3ee7),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3ee7),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3ee7),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names15,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff7  : virtual cc7 , dd7 {
  int f;
   ff7(const ABISELECT(__tsi64,int) *const *); // _ZN3ff7C2Ev
  virtual void  foo(); // _ZN3ff73fooEv
  ~ff7(); // tgen
  ff7(); // tgen
};
//SIG(-1 ff7) C1{ VBC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ff7 ::ff7(const ABISELECT(__tsi64,int) *const *){}
void  ff7 ::foo(){vfunc_called(this, "_ZN3ff73fooEv");}
ff7 ::~ff7(){ note_dtor("ff7", this);} // tgen
ff7 ::ff7(){ note_ctor("ff7", this);} // tgen

static void Test_ff7()
{
  extern Class_Descriptor cd_ff7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff7, buf);
    ff7 *dp, &lv = *(dp=new (buf) ff7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff7)");
    check_base_class_offset(lv, (cc7*), ABISELECT(16,12), "ff7");
    check_base_class_offset(lv, (dd7*), 0, "ff7");
    check_field_offset(lv, f, ABISELECT(12,8), "ff7.f");
    test_class_info(&lv, &cd_ff7);
    dp->~ff7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff7(Test_ff7, "ff7", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3ff7C1Ev();
extern void _ZN3ff7D1Ev();
Name_Map name_map_ff7[] = {
  NSPAIR(_ZN3ff7C1Ev),
  NSPAIR(_ZN3ff7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc7;
extern VTBL_ENTRY _ZTI3cc7[];
extern  VTBL_ENTRY _ZTV3cc7[];
extern Class_Descriptor cd_dd7;
extern VTBL_ENTRY _ZTI3dd7[];
extern  VTBL_ENTRY _ZTV3dd7[];
static Base_Class bases_ff7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc7,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_dd7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3ff7[];
extern void _ZN3ff73fooEv();
extern void ABISELECT(_ZTv0_n24_N3ff73fooEv,_ZTv0_n12_N3ff73fooEv)();
extern void ABISELECT(_ZThn16_N3ff73fooEv,_ZThn12_N3ff73fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff7[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI3ff7[0]),
  (VTBL_ENTRY)&_ZN3ff73fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI3ff7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ff73fooEv,_ZTv0_n12_N3ff73fooEv),
};
extern VTBL_ENTRY _ZTV3ff7[];
static  VTT_ENTRY vtt_ff7[] = {
  {&(_ZTV3ff7[3]),  3,8},
  {&(_ZTV3ff7[7]),  7,8},
};
extern VTBL_ENTRY _ZTI3ff7[];
extern  VTBL_ENTRY _ZTV3ff7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3ff7[];
static VTBL_ENTRY alt_thunk_names16[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ff73fooEv,_ZTv0_n12_N3ff73fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3ff73fooEv,_ZThn12_N3ff73fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff7 = {  "ff7", // class name
  bases_ff7, 2,
  &(vtc_ff7[0]), // expected_vtbl_contents
  &(vtt_ff7[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3ff7),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3ff7),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3ff7),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names16,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg7  : ee7 , ff7 {
  int g;
   gg7(const ABISELECT(__tsi64,int) *const *); // _ZN3gg7C2Ev
  virtual void  foo(); // _ZN3gg73fooEv
  ~gg7(); // tgen
  gg7(); // tgen
};
//SIG(1 gg7) C1{ BC2{ VBC3{ v1 Fi} VBC4{ v1 Fi} v1 Fi} BC5{ VBC6{ v1 Fi} BC7{ v1 Fi} v1 Fi} v1 Fi}


 gg7 ::gg7(const ABISELECT(__tsi64,int) *const *){}
void  gg7 ::foo(){vfunc_called(this, "_ZN3gg73fooEv");}
gg7 ::~gg7(){ note_dtor("gg7", this);} // tgen
gg7 ::gg7(){ note_ctor("gg7", this);} // tgen

static void Test_gg7()
{
  extern Class_Descriptor cd_gg7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(12,13)];
    init_test(&cd_gg7, buf);
    gg7 *dp, &lv = *(dp=new (buf) gg7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(88,48), "sizeof(gg7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg7)");
    check_base_class_offset(lv, (aa7*)(ee7*), ABISELECT(40,24), "gg7");
    check_base_class_offset(lv, (bb7*)(ee7*), ABISELECT(56,32), "gg7");
    check_base_class_offset(lv, (ee7*), 0, "gg7");
    check_base_class_offset(lv, (cc7*)(ff7*), ABISELECT(72,40), "gg7");
    check_base_class_offset(lv, (dd7*)(ff7*), ABISELECT(16,8), "gg7");
    check_base_class_offset(lv, (ff7*), ABISELECT(16,8), "gg7");
    check_field_offset(lv, g, ABISELECT(32,20), "gg7.g");
    test_class_info(&lv, &cd_gg7);
    dp->~gg7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg7(Test_gg7, "gg7", ABISELECT(88,48));

#else // __cplusplus

extern void _ZN3gg7C1Ev();
extern void _ZN3gg7D1Ev();
Name_Map name_map_gg7[] = {
  NSPAIR(_ZN3gg7C1Ev),
  NSPAIR(_ZN3gg7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa7;
extern VTBL_ENTRY _ZTI3aa7[];
extern  VTBL_ENTRY _ZTV3aa7[];
extern Class_Descriptor cd_bb7;
extern VTBL_ENTRY _ZTI3bb7[];
extern  VTBL_ENTRY _ZTV3bb7[];
extern Class_Descriptor cd_ee7;
extern VTBL_ENTRY _ZTI3ee7[];
extern  VTBL_ENTRY _ZTV3ee7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3ee7[];
extern Class_Descriptor cd_cc7;
extern VTBL_ENTRY _ZTI3cc7[];
extern  VTBL_ENTRY _ZTV3cc7[];
extern Class_Descriptor cd_dd7;
extern VTBL_ENTRY _ZTI3dd7[];
extern  VTBL_ENTRY _ZTV3dd7[];
extern Class_Descriptor cd_ff7;
extern VTBL_ENTRY _ZTI3ff7[];
extern  VTBL_ENTRY _ZTV3ff7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3ff7[];
static Base_Class bases_gg7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa7,    ABISELECT(40,24), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_bb7,    ABISELECT(56,32), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_ee7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc7,    ABISELECT(72,40), //bcp->offset
    18, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_dd7,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_ff7,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3gg7[];
extern void _ZN3gg73fooEv();
extern void ABISELECT(_ZThn16_N3gg73fooEv,_ZThn8_N3gg73fooEv)();
extern void ABISELECT(_ZTv0_n24_N3gg73fooEv,_ZTv0_n12_N3gg73fooEv)();
extern void ABISELECT(_ZThn40_N3gg73fooEv,_ZThn24_N3gg73fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N3gg73fooEv,_ZTv0_n12_N3gg73fooEv)();
extern void ABISELECT(_ZThn56_N3gg73fooEv,_ZThn32_N3gg73fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N3gg73fooEv,_ZTv0_n12_N3gg73fooEv)();
extern void ABISELECT(_ZThn72_N3gg73fooEv,_ZThn40_N3gg73fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg7[] = {
  ABISELECT(72,40),
  ABISELECT(56,32),
  ABISELECT(40,24),
  0,
  (VTBL_ENTRY)&(_ZTI3gg7[0]),
  (VTBL_ENTRY)&_ZN3gg73fooEv,
  ABISELECT(56,32),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3gg7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3gg73fooEv,_ZThn8_N3gg73fooEv),
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI3gg7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3gg73fooEv,_ZTv0_n12_N3gg73fooEv),
  ABISELECT(-56,-32),
  ABISELECT(-56,-32),
  (VTBL_ENTRY)&(_ZTI3gg7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3gg73fooEv,_ZTv0_n12_N3gg73fooEv),
  ABISELECT(-72,-40),
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI3gg7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3gg73fooEv,_ZTv0_n12_N3gg73fooEv),
};
extern VTBL_ENTRY _ZTV3gg7[];
extern void _ZN3ee73fooEv();
static  VTBL_ENTRY _tg__ZTV3ee7__3gg7[] = {
  ABISELECT(56,32),
  ABISELECT(40,24),
  0,
  (VTBL_ENTRY)&(_ZTI3ee7[0]),
  (VTBL_ENTRY)&_ZN3ee73fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3ee73fooEv,_ZTv0_n12_N3ee73fooEv)();
extern void ABISELECT(_ZThn40_N3ee73fooEv,_ZThn24_N3ee73fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3aa7__3ee7__3gg7[] = {
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI3ee7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ee73fooEv,_ZTv0_n12_N3ee73fooEv),
};
extern void ABISELECT(_ZTv0_n24_N3ee73fooEv,_ZTv0_n12_N3ee73fooEv)();
extern void ABISELECT(_ZThn56_N3ee73fooEv,_ZThn32_N3ee73fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3bb7__3ee7__3gg7[] = {
  ABISELECT(-56,-32),
  ABISELECT(-56,-32),
  (VTBL_ENTRY)&(_ZTI3ee7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ee73fooEv,_ZTv0_n12_N3ee73fooEv),
};
extern void _ZN3ff73fooEv();
static  VTBL_ENTRY _tg__ZTV3ff7__3gg7[] = {
  ABISELECT(56,32),
  0,
  (VTBL_ENTRY)&(_ZTI3ff7[0]),
  (VTBL_ENTRY)&_ZN3ff73fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3ff73fooEv,_ZTv0_n12_N3ff73fooEv)();
extern void ABISELECT(_ZThn56_N3ff73fooEv,_ZThn32_N3ff73fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3cc7__3ff7__3gg7[] = {
  ABISELECT(-56,-32),
  ABISELECT(-56,-32),
  (VTBL_ENTRY)&(_ZTI3ff7[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ff73fooEv,_ZTv0_n12_N3ff73fooEv),
};
static  VTT_ENTRY vtt_gg7[] = {
  {&(_ZTV3gg7[5]),  5,22},
  {&(_tg__ZTV3ee7__3gg7[4]),  4,5},
  {&(_tg__ZTV3aa7__3ee7__3gg7[3]),  3,4},
  {&(_tg__ZTV3bb7__3ee7__3gg7[3]),  3,4},
  {&(_tg__ZTV3ff7__3gg7[3]),  3,4},
  {&(_tg__ZTV3cc7__3ff7__3gg7[3]),  3,4},
  {&(_ZTV3gg7[13]),  13,22},
  {&(_ZTV3gg7[17]),  17,22},
  {&(_ZTV3gg7[9]),  9,22},
  {&(_ZTV3gg7[21]),  21,22},
};
extern VTBL_ENTRY _ZTI3gg7[];
extern  VTBL_ENTRY _ZTV3gg7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3gg7[];
static VTBL_ENTRY alt_thunk_names17[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ff73fooEv,_ZTv0_n12_N3ff73fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N3ff73fooEv,_ZThn32_N3ff73fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ee73fooEv,_ZTv0_n12_N3ee73fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N3ee73fooEv,_ZThn32_N3ee73fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N3ee73fooEv,_ZThn24_N3ee73fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3gg73fooEv,_ZTv0_n12_N3gg73fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N3gg73fooEv,_ZThn40_N3gg73fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn56_N3gg73fooEv,_ZThn32_N3gg73fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N3gg73fooEv,_ZThn24_N3gg73fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg7 = {  "gg7", // class name
  bases_gg7, 6,
  &(vtc_gg7[0]), // expected_vtbl_contents
  &(vtt_gg7[0]), // expected_vtt_contents
  ABISELECT(88,48), // object size
  NSPAIRA(_ZTI3gg7),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3gg7),22, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3gg7),10, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names17,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa8  {
  int a;
   aa8(); // _ZN3aa8C1Ev
  virtual void  foo(); // _ZN3aa83fooEv
  ~aa8(); // tgen
};
//SIG(-1 aa8) C1{ v1 Fi}


 aa8 ::aa8(){ note_ctor("aa8", this);}
void  aa8 ::foo(){vfunc_called(this, "_ZN3aa83fooEv");}
aa8 ::~aa8(){ note_dtor("aa8", this);} // tgen

static void Test_aa8()
{
  extern Class_Descriptor cd_aa8;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa8, buf);
    aa8 *dp, &lv = *(dp=new (buf) aa8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa8)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa8.a");
    test_class_info(&lv, &cd_aa8);
    dp->~aa8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa8(Test_aa8, "aa8", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aa8C1Ev();
extern void _ZN3aa8D1Ev();
Name_Map name_map_aa8[] = {
  NSPAIR(_ZN3aa8C1Ev),
  NSPAIR(_ZN3aa8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3aa8[];
extern void _ZN3aa83fooEv();
static  VTBL_ENTRY vtc_aa8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3aa8[0]),
  (VTBL_ENTRY)&_ZN3aa83fooEv,
};
extern VTBL_ENTRY _ZTI3aa8[];
extern  VTBL_ENTRY _ZTV3aa8[];
Class_Descriptor cd_aa8 = {  "aa8", // class name
  0,0,//no base classes
  &(vtc_aa8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3aa8),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3aa8),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb8  {
  int b;
   bb8(); // _ZN3bb8C1Ev
  virtual void  foo(); // _ZN3bb83fooEv
  ~bb8(); // tgen
};
//SIG(-1 bb8) C1{ v1 Fi}


 bb8 ::bb8(){ note_ctor("bb8", this);}
void  bb8 ::foo(){vfunc_called(this, "_ZN3bb83fooEv");}
bb8 ::~bb8(){ note_dtor("bb8", this);} // tgen

static void Test_bb8()
{
  extern Class_Descriptor cd_bb8;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb8, buf);
    bb8 *dp, &lv = *(dp=new (buf) bb8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb8)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb8.b");
    test_class_info(&lv, &cd_bb8);
    dp->~bb8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb8(Test_bb8, "bb8", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3bb8C1Ev();
extern void _ZN3bb8D1Ev();
Name_Map name_map_bb8[] = {
  NSPAIR(_ZN3bb8C1Ev),
  NSPAIR(_ZN3bb8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3bb8[];
extern void _ZN3bb83fooEv();
static  VTBL_ENTRY vtc_bb8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3bb8[0]),
  (VTBL_ENTRY)&_ZN3bb83fooEv,
};
extern VTBL_ENTRY _ZTI3bb8[];
extern  VTBL_ENTRY _ZTV3bb8[];
Class_Descriptor cd_bb8 = {  "bb8", // class name
  0,0,//no base classes
  &(vtc_bb8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3bb8),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3bb8),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc8  {
  int c;
   cc8(); // _ZN3cc8C1Ev
  virtual void  foo(); // _ZN3cc83fooEv
  ~cc8(); // tgen
};
//SIG(-1 cc8) C1{ v1 Fi}


 cc8 ::cc8(){ note_ctor("cc8", this);}
void  cc8 ::foo(){vfunc_called(this, "_ZN3cc83fooEv");}
cc8 ::~cc8(){ note_dtor("cc8", this);} // tgen

static void Test_cc8()
{
  extern Class_Descriptor cd_cc8;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc8, buf);
    cc8 *dp, &lv = *(dp=new (buf) cc8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc8)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc8.c");
    test_class_info(&lv, &cd_cc8);
    dp->~cc8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc8(Test_cc8, "cc8", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3cc8C1Ev();
extern void _ZN3cc8D1Ev();
Name_Map name_map_cc8[] = {
  NSPAIR(_ZN3cc8C1Ev),
  NSPAIR(_ZN3cc8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3cc8[];
extern void _ZN3cc83fooEv();
static  VTBL_ENTRY vtc_cc8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3cc8[0]),
  (VTBL_ENTRY)&_ZN3cc83fooEv,
};
extern VTBL_ENTRY _ZTI3cc8[];
extern  VTBL_ENTRY _ZTV3cc8[];
Class_Descriptor cd_cc8 = {  "cc8", // class name
  0,0,//no base classes
  &(vtc_cc8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3cc8),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3cc8),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd8  {
  int d;
   dd8(); // _ZN3dd8C1Ev
  virtual void  foo(); // _ZN3dd83fooEv
  ~dd8(); // tgen
};
//SIG(-1 dd8) C1{ v1 Fi}


 dd8 ::dd8(){ note_ctor("dd8", this);}
void  dd8 ::foo(){vfunc_called(this, "_ZN3dd83fooEv");}
dd8 ::~dd8(){ note_dtor("dd8", this);} // tgen

static void Test_dd8()
{
  extern Class_Descriptor cd_dd8;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd8, buf);
    dd8 *dp, &lv = *(dp=new (buf) dd8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd8)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd8.d");
    test_class_info(&lv, &cd_dd8);
    dp->~dd8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd8(Test_dd8, "dd8", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3dd8C1Ev();
extern void _ZN3dd8D1Ev();
Name_Map name_map_dd8[] = {
  NSPAIR(_ZN3dd8C1Ev),
  NSPAIR(_ZN3dd8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3dd8[];
extern void _ZN3dd83fooEv();
static  VTBL_ENTRY vtc_dd8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3dd8[0]),
  (VTBL_ENTRY)&_ZN3dd83fooEv,
};
extern VTBL_ENTRY _ZTI3dd8[];
extern  VTBL_ENTRY _ZTV3dd8[];
Class_Descriptor cd_dd8 = {  "dd8", // class name
  0,0,//no base classes
  &(vtc_dd8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3dd8),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3dd8),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee8  : aa8 , bb8 {
  int e;
   ee8(); // _ZN3ee8C1Ev
  virtual void  foo(); // _ZN3ee83fooEv
  ~ee8(); // tgen
};
//SIG(-1 ee8) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ee8 ::ee8(){ note_ctor("ee8", this);}
void  ee8 ::foo(){vfunc_called(this, "_ZN3ee83fooEv");}
ee8 ::~ee8(){ note_dtor("ee8", this);} // tgen

static void Test_ee8()
{
  extern Class_Descriptor cd_ee8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee8, buf);
    ee8 *dp, &lv = *(dp=new (buf) ee8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee8)");
    check_base_class_offset(lv, (aa8*), 0, "ee8");
    check_base_class_offset(lv, (bb8*), ABISELECT(16,8), "ee8");
    check_field_offset(lv, e, ABISELECT(28,16), "ee8.e");
    test_class_info(&lv, &cd_ee8);
    dp->~ee8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee8(Test_ee8, "ee8", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3ee8C1Ev();
extern void _ZN3ee8D1Ev();
Name_Map name_map_ee8[] = {
  NSPAIR(_ZN3ee8C1Ev),
  NSPAIR(_ZN3ee8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa8;
extern VTBL_ENTRY _ZTI3aa8[];
extern  VTBL_ENTRY _ZTV3aa8[];
extern Class_Descriptor cd_bb8;
extern VTBL_ENTRY _ZTI3bb8[];
extern  VTBL_ENTRY _ZTV3bb8[];
static Base_Class bases_ee8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_bb8,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3ee8[];
extern void _ZN3ee83fooEv();
extern void ABISELECT(_ZThn16_N3ee83fooEv,_ZThn8_N3ee83fooEv)();
static  VTBL_ENTRY vtc_ee8[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3ee8[0]),
  (VTBL_ENTRY)&_ZN3ee83fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3ee8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3ee83fooEv,_ZThn8_N3ee83fooEv),
};
extern VTBL_ENTRY _ZTI3ee8[];
extern  VTBL_ENTRY _ZTV3ee8[];
Class_Descriptor cd_ee8 = {  "ee8", // class name
  bases_ee8, 2,
  &(vtc_ee8[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3ee8),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3ee8),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff8  : cc8 , virtual dd8 {
  int f;
   ff8(const ABISELECT(__tsi64,int) *const *); // _ZN3ff8C2Ev
  virtual void  foo(); // _ZN3ff83fooEv
  ~ff8(); // tgen
  ff8(); // tgen
};
//SIG(-1 ff8) C1{ BC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ff8 ::ff8(const ABISELECT(__tsi64,int) *const *){}
void  ff8 ::foo(){vfunc_called(this, "_ZN3ff83fooEv");}
ff8 ::~ff8(){ note_dtor("ff8", this);} // tgen
ff8 ::ff8(){ note_ctor("ff8", this);} // tgen

static void Test_ff8()
{
  extern Class_Descriptor cd_ff8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff8, buf);
    ff8 *dp, &lv = *(dp=new (buf) ff8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff8)");
    check_base_class_offset(lv, (cc8*), 0, "ff8");
    check_base_class_offset(lv, (dd8*), ABISELECT(16,12), "ff8");
    check_field_offset(lv, f, ABISELECT(12,8), "ff8.f");
    test_class_info(&lv, &cd_ff8);
    dp->~ff8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff8(Test_ff8, "ff8", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3ff8C1Ev();
extern void _ZN3ff8D1Ev();
Name_Map name_map_ff8[] = {
  NSPAIR(_ZN3ff8C1Ev),
  NSPAIR(_ZN3ff8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc8;
extern VTBL_ENTRY _ZTI3cc8[];
extern  VTBL_ENTRY _ZTV3cc8[];
extern Class_Descriptor cd_dd8;
extern VTBL_ENTRY _ZTI3dd8[];
extern  VTBL_ENTRY _ZTV3dd8[];
static Base_Class bases_ff8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_dd8,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3ff8[];
extern void _ZN3ff83fooEv();
extern void ABISELECT(_ZTv0_n24_N3ff83fooEv,_ZTv0_n12_N3ff83fooEv)();
extern void ABISELECT(_ZThn16_N3ff83fooEv,_ZThn12_N3ff83fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff8[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI3ff8[0]),
  (VTBL_ENTRY)&_ZN3ff83fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI3ff8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ff83fooEv,_ZTv0_n12_N3ff83fooEv),
};
extern VTBL_ENTRY _ZTV3ff8[];
static  VTT_ENTRY vtt_ff8[] = {
  {&(_ZTV3ff8[3]),  3,8},
  {&(_ZTV3ff8[7]),  7,8},
};
extern VTBL_ENTRY _ZTI3ff8[];
extern  VTBL_ENTRY _ZTV3ff8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3ff8[];
static VTBL_ENTRY alt_thunk_names18[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ff83fooEv,_ZTv0_n12_N3ff83fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3ff83fooEv,_ZThn12_N3ff83fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff8 = {  "ff8", // class name
  bases_ff8, 2,
  &(vtc_ff8[0]), // expected_vtbl_contents
  &(vtt_ff8[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3ff8),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3ff8),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3ff8),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names18,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg8  : ee8 , ff8 {
  int g;
   gg8(const ABISELECT(__tsi64,int) *const *); // _ZN3gg8C2Ev
  virtual void  foo(); // _ZN3gg83fooEv
  ~gg8(); // tgen
  gg8(); // tgen
};
//SIG(1 gg8) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 Fi} VBC7{ v1 Fi} v1 Fi} v1 Fi}


 gg8 ::gg8(const ABISELECT(__tsi64,int) *const *){}
void  gg8 ::foo(){vfunc_called(this, "_ZN3gg83fooEv");}
gg8 ::~gg8(){ note_dtor("gg8", this);} // tgen
gg8 ::gg8(){ note_ctor("gg8", this);} // tgen

static void Test_gg8()
{
  extern Class_Descriptor cd_gg8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg8, buf);
    gg8 *dp, &lv = *(dp=new (buf) gg8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg8)");
    check_base_class_offset(lv, (aa8*)(ee8*), 0, "gg8");
    check_base_class_offset(lv, (bb8*)(ee8*), ABISELECT(16,8), "gg8");
    check_base_class_offset(lv, (ee8*), 0, "gg8");
    check_base_class_offset(lv, (cc8*)(ff8*), ABISELECT(32,20), "gg8");
    check_base_class_offset(lv, (dd8*)(ff8*), ABISELECT(56,36), "gg8");
    check_base_class_offset(lv, (ff8*), ABISELECT(32,20), "gg8");
    check_field_offset(lv, g, ABISELECT(48,32), "gg8.g");
    test_class_info(&lv, &cd_gg8);
    dp->~gg8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg8(Test_gg8, "gg8", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3gg8C1Ev();
extern void _ZN3gg8D1Ev();
Name_Map name_map_gg8[] = {
  NSPAIR(_ZN3gg8C1Ev),
  NSPAIR(_ZN3gg8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa8;
extern VTBL_ENTRY _ZTI3aa8[];
extern  VTBL_ENTRY _ZTV3aa8[];
extern Class_Descriptor cd_bb8;
extern VTBL_ENTRY _ZTI3bb8[];
extern  VTBL_ENTRY _ZTV3bb8[];
extern Class_Descriptor cd_ee8;
extern VTBL_ENTRY _ZTI3ee8[];
extern  VTBL_ENTRY _ZTV3ee8[];
extern Class_Descriptor cd_cc8;
extern VTBL_ENTRY _ZTI3cc8[];
extern  VTBL_ENTRY _ZTV3cc8[];
extern Class_Descriptor cd_dd8;
extern VTBL_ENTRY _ZTI3dd8[];
extern  VTBL_ENTRY _ZTV3dd8[];
extern Class_Descriptor cd_ff8;
extern VTBL_ENTRY _ZTI3ff8[];
extern  VTBL_ENTRY _ZTV3ff8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3ff8[];
static Base_Class bases_gg8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_bb8,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_ee8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc8,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_dd8,    ABISELECT(56,36), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_ff8,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3gg8[];
extern void _ZN3gg83fooEv();
extern void ABISELECT(_ZThn16_N3gg83fooEv,_ZThn8_N3gg83fooEv)();
extern void ABISELECT(_ZThn32_N3gg83fooEv,_ZThn20_N3gg83fooEv)();
extern void ABISELECT(_ZTv0_n24_N3gg83fooEv,_ZTv0_n12_N3gg83fooEv)();
extern void ABISELECT(_ZThn56_N3gg83fooEv,_ZThn36_N3gg83fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg8[] = {
  ABISELECT(56,36),
  0,
  (VTBL_ENTRY)&(_ZTI3gg8[0]),
  (VTBL_ENTRY)&_ZN3gg83fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI3gg8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3gg83fooEv,_ZThn8_N3gg83fooEv),
  ABISELECT(24,16),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI3gg8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3gg83fooEv,_ZThn20_N3gg83fooEv),
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI3gg8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3gg83fooEv,_ZTv0_n12_N3gg83fooEv),
};
extern VTBL_ENTRY _ZTV3gg8[];
extern void _ZN3ff83fooEv();
static  VTBL_ENTRY _tg__ZTV3ff8__3gg8[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI3ff8[0]),
  (VTBL_ENTRY)&_ZN3ff83fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3ff83fooEv,_ZTv0_n12_N3ff83fooEv)();
extern void ABISELECT(_ZThn24_N3ff83fooEv,_ZThn16_N3ff83fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3dd8__3ff8__3gg8[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI3ff8[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ff83fooEv,_ZTv0_n12_N3ff83fooEv),
};
static  VTT_ENTRY vtt_gg8[] = {
  {&(_ZTV3gg8[3]),  3,15},
  {&(_tg__ZTV3ff8__3gg8[3]),  3,4},
  {&(_tg__ZTV3dd8__3ff8__3gg8[3]),  3,4},
  {&(_ZTV3gg8[10]),  10,15},
  {&(_ZTV3gg8[14]),  14,15},
};
extern VTBL_ENTRY _ZTI3gg8[];
extern  VTBL_ENTRY _ZTV3gg8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3gg8[];
static VTBL_ENTRY alt_thunk_names19[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ff83fooEv,_ZTv0_n12_N3ff83fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N3ff83fooEv,_ZThn16_N3ff83fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3gg83fooEv,_ZTv0_n12_N3gg83fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N3gg83fooEv,_ZThn36_N3gg83fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg8 = {  "gg8", // class name
  bases_gg8, 6,
  &(vtc_gg8[0]), // expected_vtbl_contents
  &(vtt_gg8[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI3gg8),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3gg8),15, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3gg8),5, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names19,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa9  {
  int a;
   aa9(); // _ZN3aa9C1Ev
  virtual void  foo(); // _ZN3aa93fooEv
  ~aa9(); // tgen
};
//SIG(-1 aa9) C1{ v1 Fi}


 aa9 ::aa9(){ note_ctor("aa9", this);}
void  aa9 ::foo(){vfunc_called(this, "_ZN3aa93fooEv");}
aa9 ::~aa9(){ note_dtor("aa9", this);} // tgen

static void Test_aa9()
{
  extern Class_Descriptor cd_aa9;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa9, buf);
    aa9 *dp, &lv = *(dp=new (buf) aa9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa9)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa9.a");
    test_class_info(&lv, &cd_aa9);
    dp->~aa9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa9(Test_aa9, "aa9", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aa9C1Ev();
extern void _ZN3aa9D1Ev();
Name_Map name_map_aa9[] = {
  NSPAIR(_ZN3aa9C1Ev),
  NSPAIR(_ZN3aa9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3aa9[];
extern void _ZN3aa93fooEv();
static  VTBL_ENTRY vtc_aa9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3aa9[0]),
  (VTBL_ENTRY)&_ZN3aa93fooEv,
};
extern VTBL_ENTRY _ZTI3aa9[];
extern  VTBL_ENTRY _ZTV3aa9[];
Class_Descriptor cd_aa9 = {  "aa9", // class name
  0,0,//no base classes
  &(vtc_aa9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3aa9),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3aa9),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb9  {
  int b;
   bb9(); // _ZN3bb9C1Ev
  virtual void  foo(); // _ZN3bb93fooEv
  ~bb9(); // tgen
};
//SIG(-1 bb9) C1{ v1 Fi}


 bb9 ::bb9(){ note_ctor("bb9", this);}
void  bb9 ::foo(){vfunc_called(this, "_ZN3bb93fooEv");}
bb9 ::~bb9(){ note_dtor("bb9", this);} // tgen

static void Test_bb9()
{
  extern Class_Descriptor cd_bb9;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb9, buf);
    bb9 *dp, &lv = *(dp=new (buf) bb9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb9)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb9.b");
    test_class_info(&lv, &cd_bb9);
    dp->~bb9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb9(Test_bb9, "bb9", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3bb9C1Ev();
extern void _ZN3bb9D1Ev();
Name_Map name_map_bb9[] = {
  NSPAIR(_ZN3bb9C1Ev),
  NSPAIR(_ZN3bb9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3bb9[];
extern void _ZN3bb93fooEv();
static  VTBL_ENTRY vtc_bb9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3bb9[0]),
  (VTBL_ENTRY)&_ZN3bb93fooEv,
};
extern VTBL_ENTRY _ZTI3bb9[];
extern  VTBL_ENTRY _ZTV3bb9[];
Class_Descriptor cd_bb9 = {  "bb9", // class name
  0,0,//no base classes
  &(vtc_bb9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3bb9),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3bb9),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc9  {
  int c;
   cc9(); // _ZN3cc9C1Ev
  virtual void  foo(); // _ZN3cc93fooEv
  ~cc9(); // tgen
};
//SIG(-1 cc9) C1{ v1 Fi}


 cc9 ::cc9(){ note_ctor("cc9", this);}
void  cc9 ::foo(){vfunc_called(this, "_ZN3cc93fooEv");}
cc9 ::~cc9(){ note_dtor("cc9", this);} // tgen

static void Test_cc9()
{
  extern Class_Descriptor cd_cc9;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc9, buf);
    cc9 *dp, &lv = *(dp=new (buf) cc9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc9)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc9.c");
    test_class_info(&lv, &cd_cc9);
    dp->~cc9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc9(Test_cc9, "cc9", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3cc9C1Ev();
extern void _ZN3cc9D1Ev();
Name_Map name_map_cc9[] = {
  NSPAIR(_ZN3cc9C1Ev),
  NSPAIR(_ZN3cc9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3cc9[];
extern void _ZN3cc93fooEv();
static  VTBL_ENTRY vtc_cc9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3cc9[0]),
  (VTBL_ENTRY)&_ZN3cc93fooEv,
};
extern VTBL_ENTRY _ZTI3cc9[];
extern  VTBL_ENTRY _ZTV3cc9[];
Class_Descriptor cd_cc9 = {  "cc9", // class name
  0,0,//no base classes
  &(vtc_cc9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3cc9),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3cc9),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd9  {
  int d;
   dd9(); // _ZN3dd9C1Ev
  virtual void  foo(); // _ZN3dd93fooEv
  ~dd9(); // tgen
};
//SIG(-1 dd9) C1{ v1 Fi}


 dd9 ::dd9(){ note_ctor("dd9", this);}
void  dd9 ::foo(){vfunc_called(this, "_ZN3dd93fooEv");}
dd9 ::~dd9(){ note_dtor("dd9", this);} // tgen

static void Test_dd9()
{
  extern Class_Descriptor cd_dd9;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd9, buf);
    dd9 *dp, &lv = *(dp=new (buf) dd9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd9)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd9.d");
    test_class_info(&lv, &cd_dd9);
    dp->~dd9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd9(Test_dd9, "dd9", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3dd9C1Ev();
extern void _ZN3dd9D1Ev();
Name_Map name_map_dd9[] = {
  NSPAIR(_ZN3dd9C1Ev),
  NSPAIR(_ZN3dd9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI3dd9[];
extern void _ZN3dd93fooEv();
static  VTBL_ENTRY vtc_dd9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI3dd9[0]),
  (VTBL_ENTRY)&_ZN3dd93fooEv,
};
extern VTBL_ENTRY _ZTI3dd9[];
extern  VTBL_ENTRY _ZTV3dd9[];
Class_Descriptor cd_dd9 = {  "dd9", // class name
  0,0,//no base classes
  &(vtc_dd9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI3dd9),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV3dd9),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee9  : virtual aa9 , bb9 {
  int e;
   ee9(const ABISELECT(__tsi64,int) *const *); // _ZN3ee9C2Ev
  virtual void  foo(); // _ZN3ee93fooEv
  ~ee9(); // tgen
  ee9(); // tgen
};
//SIG(-1 ee9) C1{ VBC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ee9 ::ee9(const ABISELECT(__tsi64,int) *const *){}
void  ee9 ::foo(){vfunc_called(this, "_ZN3ee93fooEv");}
ee9 ::~ee9(){ note_dtor("ee9", this);} // tgen
ee9 ::ee9(){ note_ctor("ee9", this);} // tgen

static void Test_ee9()
{
  extern Class_Descriptor cd_ee9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee9, buf);
    ee9 *dp, &lv = *(dp=new (buf) ee9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee9)");
    check_base_class_offset(lv, (aa9*), ABISELECT(16,12), "ee9");
    check_base_class_offset(lv, (bb9*), 0, "ee9");
    check_field_offset(lv, e, ABISELECT(12,8), "ee9.e");
    test_class_info(&lv, &cd_ee9);
    dp->~ee9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee9(Test_ee9, "ee9", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3ee9C1Ev();
extern void _ZN3ee9D1Ev();
Name_Map name_map_ee9[] = {
  NSPAIR(_ZN3ee9C1Ev),
  NSPAIR(_ZN3ee9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa9;
extern VTBL_ENTRY _ZTI3aa9[];
extern  VTBL_ENTRY _ZTV3aa9[];
extern Class_Descriptor cd_bb9;
extern VTBL_ENTRY _ZTI3bb9[];
extern  VTBL_ENTRY _ZTV3bb9[];
static Base_Class bases_ee9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa9,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_bb9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3ee9[];
extern void _ZN3ee93fooEv();
extern void ABISELECT(_ZTv0_n24_N3ee93fooEv,_ZTv0_n12_N3ee93fooEv)();
extern void ABISELECT(_ZThn16_N3ee93fooEv,_ZThn12_N3ee93fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee9[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI3ee9[0]),
  (VTBL_ENTRY)&_ZN3ee93fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI3ee9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ee93fooEv,_ZTv0_n12_N3ee93fooEv),
};
extern VTBL_ENTRY _ZTV3ee9[];
static  VTT_ENTRY vtt_ee9[] = {
  {&(_ZTV3ee9[3]),  3,8},
  {&(_ZTV3ee9[7]),  7,8},
};
extern VTBL_ENTRY _ZTI3ee9[];
extern  VTBL_ENTRY _ZTV3ee9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3ee9[];
static VTBL_ENTRY alt_thunk_names20[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ee93fooEv,_ZTv0_n12_N3ee93fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3ee93fooEv,_ZThn12_N3ee93fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee9 = {  "ee9", // class name
  bases_ee9, 2,
  &(vtc_ee9[0]), // expected_vtbl_contents
  &(vtt_ee9[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3ee9),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3ee9),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3ee9),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names20,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff9  : cc9 , virtual dd9 {
  int f;
   ff9(const ABISELECT(__tsi64,int) *const *); // _ZN3ff9C2Ev
  virtual void  foo(); // _ZN3ff93fooEv
  ~ff9(); // tgen
  ff9(); // tgen
};
//SIG(-1 ff9) C1{ BC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ff9 ::ff9(const ABISELECT(__tsi64,int) *const *){}
void  ff9 ::foo(){vfunc_called(this, "_ZN3ff93fooEv");}
ff9 ::~ff9(){ note_dtor("ff9", this);} // tgen
ff9 ::ff9(){ note_ctor("ff9", this);} // tgen

static void Test_ff9()
{
  extern Class_Descriptor cd_ff9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff9, buf);
    ff9 *dp, &lv = *(dp=new (buf) ff9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff9)");
    check_base_class_offset(lv, (cc9*), 0, "ff9");
    check_base_class_offset(lv, (dd9*), ABISELECT(16,12), "ff9");
    check_field_offset(lv, f, ABISELECT(12,8), "ff9.f");
    test_class_info(&lv, &cd_ff9);
    dp->~ff9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff9(Test_ff9, "ff9", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3ff9C1Ev();
extern void _ZN3ff9D1Ev();
Name_Map name_map_ff9[] = {
  NSPAIR(_ZN3ff9C1Ev),
  NSPAIR(_ZN3ff9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc9;
extern VTBL_ENTRY _ZTI3cc9[];
extern  VTBL_ENTRY _ZTV3cc9[];
extern Class_Descriptor cd_dd9;
extern VTBL_ENTRY _ZTI3dd9[];
extern  VTBL_ENTRY _ZTV3dd9[];
static Base_Class bases_ff9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_dd9,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3ff9[];
extern void _ZN3ff93fooEv();
extern void ABISELECT(_ZTv0_n24_N3ff93fooEv,_ZTv0_n12_N3ff93fooEv)();
extern void ABISELECT(_ZThn16_N3ff93fooEv,_ZThn12_N3ff93fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff9[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI3ff9[0]),
  (VTBL_ENTRY)&_ZN3ff93fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI3ff9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ff93fooEv,_ZTv0_n12_N3ff93fooEv),
};
extern VTBL_ENTRY _ZTV3ff9[];
static  VTT_ENTRY vtt_ff9[] = {
  {&(_ZTV3ff9[3]),  3,8},
  {&(_ZTV3ff9[7]),  7,8},
};
extern VTBL_ENTRY _ZTI3ff9[];
extern  VTBL_ENTRY _ZTV3ff9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3ff9[];
static VTBL_ENTRY alt_thunk_names21[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ff93fooEv,_ZTv0_n12_N3ff93fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N3ff93fooEv,_ZThn12_N3ff93fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff9 = {  "ff9", // class name
  bases_ff9, 2,
  &(vtc_ff9[0]), // expected_vtbl_contents
  &(vtt_ff9[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI3ff9),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3ff9),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3ff9),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names21,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg9  : ee9 , ff9 {
  int g;
   gg9(const ABISELECT(__tsi64,int) *const *); // _ZN3gg9C2Ev
  virtual void  foo(); // _ZN3gg93fooEv
  ~gg9(); // tgen
  gg9(); // tgen
};
//SIG(1 gg9) C1{ BC2{ VBC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 Fi} VBC7{ v1 Fi} v1 Fi} v1 Fi}


 gg9 ::gg9(const ABISELECT(__tsi64,int) *const *){}
void  gg9 ::foo(){vfunc_called(this, "_ZN3gg93fooEv");}
gg9 ::~gg9(){ note_dtor("gg9", this);} // tgen
gg9 ::gg9(){ note_ctor("gg9", this);} // tgen

static void Test_gg9()
{
  extern Class_Descriptor cd_gg9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg9, buf);
    gg9 *dp, &lv = *(dp=new (buf) gg9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg9)");
    check_base_class_offset(lv, (aa9*)(ee9*), ABISELECT(40,28), "gg9");
    check_base_class_offset(lv, (bb9*)(ee9*), 0, "gg9");
    check_base_class_offset(lv, (ee9*), 0, "gg9");
    check_base_class_offset(lv, (cc9*)(ff9*), ABISELECT(16,12), "gg9");
    check_base_class_offset(lv, (dd9*)(ff9*), ABISELECT(56,36), "gg9");
    check_base_class_offset(lv, (ff9*), ABISELECT(16,12), "gg9");
    check_field_offset(lv, g, ABISELECT(32,24), "gg9.g");
    test_class_info(&lv, &cd_gg9);
    dp->~gg9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg9(Test_gg9, "gg9", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3gg9C1Ev();
extern void _ZN3gg9D1Ev();
Name_Map name_map_gg9[] = {
  NSPAIR(_ZN3gg9C1Ev),
  NSPAIR(_ZN3gg9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa9;
extern VTBL_ENTRY _ZTI3aa9[];
extern  VTBL_ENTRY _ZTV3aa9[];
extern Class_Descriptor cd_bb9;
extern VTBL_ENTRY _ZTI3bb9[];
extern  VTBL_ENTRY _ZTV3bb9[];
extern Class_Descriptor cd_ee9;
extern VTBL_ENTRY _ZTI3ee9[];
extern  VTBL_ENTRY _ZTV3ee9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3ee9[];
extern Class_Descriptor cd_cc9;
extern VTBL_ENTRY _ZTI3cc9[];
extern  VTBL_ENTRY _ZTV3cc9[];
extern Class_Descriptor cd_dd9;
extern VTBL_ENTRY _ZTI3dd9[];
extern  VTBL_ENTRY _ZTV3dd9[];
extern Class_Descriptor cd_ff9;
extern VTBL_ENTRY _ZTI3ff9[];
extern  VTBL_ENTRY _ZTV3ff9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3ff9[];
static Base_Class bases_gg9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa9,    ABISELECT(40,28), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_bb9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_ee9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc9,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_dd9,    ABISELECT(56,36), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_ff9,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3gg9[];
extern void _ZN3gg93fooEv();
extern void ABISELECT(_ZThn16_N3gg93fooEv,_ZThn12_N3gg93fooEv)();
extern void ABISELECT(_ZTv0_n24_N3gg93fooEv,_ZTv0_n12_N3gg93fooEv)();
extern void ABISELECT(_ZThn40_N3gg93fooEv,_ZThn28_N3gg93fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N3gg93fooEv,_ZTv0_n12_N3gg93fooEv)();
extern void ABISELECT(_ZThn56_N3gg93fooEv,_ZThn36_N3gg93fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg9[] = {
  ABISELECT(56,36),
  ABISELECT(40,28),
  0,
  (VTBL_ENTRY)&(_ZTI3gg9[0]),
  (VTBL_ENTRY)&_ZN3gg93fooEv,
  ABISELECT(40,24),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI3gg9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3gg93fooEv,_ZThn12_N3gg93fooEv),
  ABISELECT(-40,-28),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI3gg9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3gg93fooEv,_ZTv0_n12_N3gg93fooEv),
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI3gg9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3gg93fooEv,_ZTv0_n12_N3gg93fooEv),
};
extern VTBL_ENTRY _ZTV3gg9[];
extern void _ZN3ee93fooEv();
static  VTBL_ENTRY _tg__ZTV3ee9__3gg9[] = {
  ABISELECT(40,28),
  0,
  (VTBL_ENTRY)&(_ZTI3ee9[0]),
  (VTBL_ENTRY)&_ZN3ee93fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3ee93fooEv,_ZTv0_n12_N3ee93fooEv)();
extern void ABISELECT(_ZThn40_N3ee93fooEv,_ZThn28_N3ee93fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3aa9__3ee9__3gg9[] = {
  ABISELECT(-40,-28),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI3ee9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ee93fooEv,_ZTv0_n12_N3ee93fooEv),
};
extern void _ZN3ff93fooEv();
static  VTBL_ENTRY _tg__ZTV3ff9__3gg9[] = {
  ABISELECT(40,24),
  0,
  (VTBL_ENTRY)&(_ZTI3ff9[0]),
  (VTBL_ENTRY)&_ZN3ff93fooEv,
};
extern void ABISELECT(_ZTv0_n24_N3ff93fooEv,_ZTv0_n12_N3ff93fooEv)();
extern void ABISELECT(_ZThn40_N3ff93fooEv,_ZThn24_N3ff93fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV3dd9__3ff9__3gg9[] = {
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI3ff9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N3ff93fooEv,_ZTv0_n12_N3ff93fooEv),
};
static  VTT_ENTRY vtt_gg9[] = {
  {&(_ZTV3gg9[4]),  4,17},
  {&(_tg__ZTV3ee9__3gg9[3]),  3,4},
  {&(_tg__ZTV3aa9__3ee9__3gg9[3]),  3,4},
  {&(_tg__ZTV3ff9__3gg9[3]),  3,4},
  {&(_tg__ZTV3dd9__3ff9__3gg9[3]),  3,4},
  {&(_ZTV3gg9[12]),  12,17},
  {&(_ZTV3gg9[8]),  8,17},
  {&(_ZTV3gg9[16]),  16,17},
};
extern VTBL_ENTRY _ZTI3gg9[];
extern  VTBL_ENTRY _ZTV3gg9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3gg9[];
static VTBL_ENTRY alt_thunk_names22[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ff93fooEv,_ZTv0_n12_N3ff93fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N3ff93fooEv,_ZThn24_N3ff93fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3ee93fooEv,_ZTv0_n12_N3ee93fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N3ee93fooEv,_ZThn28_N3ee93fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N3gg93fooEv,_ZTv0_n12_N3gg93fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N3gg93fooEv,_ZThn36_N3gg93fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N3gg93fooEv,_ZThn28_N3gg93fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg9 = {  "gg9", // class name
  bases_gg9, 6,
  &(vtc_gg9[0]), // expected_vtbl_contents
  &(vtt_gg9[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI3gg9),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV3gg9),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3gg9),8, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names22,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa10  {
  int a;
   aa10(); // _ZN4aa10C1Ev
  virtual void  foo(); // _ZN4aa103fooEv
  ~aa10(); // tgen
};
//SIG(-1 aa10) C1{ v1 Fi}


 aa10 ::aa10(){ note_ctor("aa10", this);}
void  aa10 ::foo(){vfunc_called(this, "_ZN4aa103fooEv");}
aa10 ::~aa10(){ note_dtor("aa10", this);} // tgen

static void Test_aa10()
{
  extern Class_Descriptor cd_aa10;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa10, buf);
    aa10 *dp, &lv = *(dp=new (buf) aa10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa10)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa10.a");
    test_class_info(&lv, &cd_aa10);
    dp->~aa10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa10(Test_aa10, "aa10", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa10C1Ev();
extern void _ZN4aa10D1Ev();
Name_Map name_map_aa10[] = {
  NSPAIR(_ZN4aa10C1Ev),
  NSPAIR(_ZN4aa10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa10[];
extern void _ZN4aa103fooEv();
static  VTBL_ENTRY vtc_aa10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa10[0]),
  (VTBL_ENTRY)&_ZN4aa103fooEv,
};
extern VTBL_ENTRY _ZTI4aa10[];
extern  VTBL_ENTRY _ZTV4aa10[];
Class_Descriptor cd_aa10 = {  "aa10", // class name
  0,0,//no base classes
  &(vtc_aa10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa10),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb10  {
  int b;
   bb10(); // _ZN4bb10C1Ev
  virtual void  foo(); // _ZN4bb103fooEv
  ~bb10(); // tgen
};
//SIG(-1 bb10) C1{ v1 Fi}


 bb10 ::bb10(){ note_ctor("bb10", this);}
void  bb10 ::foo(){vfunc_called(this, "_ZN4bb103fooEv");}
bb10 ::~bb10(){ note_dtor("bb10", this);} // tgen

static void Test_bb10()
{
  extern Class_Descriptor cd_bb10;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb10, buf);
    bb10 *dp, &lv = *(dp=new (buf) bb10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb10)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb10.b");
    test_class_info(&lv, &cd_bb10);
    dp->~bb10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb10(Test_bb10, "bb10", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb10C1Ev();
extern void _ZN4bb10D1Ev();
Name_Map name_map_bb10[] = {
  NSPAIR(_ZN4bb10C1Ev),
  NSPAIR(_ZN4bb10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb10[];
extern void _ZN4bb103fooEv();
static  VTBL_ENTRY vtc_bb10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb10[0]),
  (VTBL_ENTRY)&_ZN4bb103fooEv,
};
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
Class_Descriptor cd_bb10 = {  "bb10", // class name
  0,0,//no base classes
  &(vtc_bb10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb10),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc10  {
  int c;
   cc10(); // _ZN4cc10C1Ev
  virtual void  foo(); // _ZN4cc103fooEv
  ~cc10(); // tgen
};
//SIG(-1 cc10) C1{ v1 Fi}


 cc10 ::cc10(){ note_ctor("cc10", this);}
void  cc10 ::foo(){vfunc_called(this, "_ZN4cc103fooEv");}
cc10 ::~cc10(){ note_dtor("cc10", this);} // tgen

static void Test_cc10()
{
  extern Class_Descriptor cd_cc10;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc10, buf);
    cc10 *dp, &lv = *(dp=new (buf) cc10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc10)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc10.c");
    test_class_info(&lv, &cd_cc10);
    dp->~cc10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc10(Test_cc10, "cc10", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc10C1Ev();
extern void _ZN4cc10D1Ev();
Name_Map name_map_cc10[] = {
  NSPAIR(_ZN4cc10C1Ev),
  NSPAIR(_ZN4cc10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc10[];
extern void _ZN4cc103fooEv();
static  VTBL_ENTRY vtc_cc10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc10[0]),
  (VTBL_ENTRY)&_ZN4cc103fooEv,
};
extern VTBL_ENTRY _ZTI4cc10[];
extern  VTBL_ENTRY _ZTV4cc10[];
Class_Descriptor cd_cc10 = {  "cc10", // class name
  0,0,//no base classes
  &(vtc_cc10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc10),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd10  {
  int d;
   dd10(); // _ZN4dd10C1Ev
  virtual void  foo(); // _ZN4dd103fooEv
  ~dd10(); // tgen
};
//SIG(-1 dd10) C1{ v1 Fi}


 dd10 ::dd10(){ note_ctor("dd10", this);}
void  dd10 ::foo(){vfunc_called(this, "_ZN4dd103fooEv");}
dd10 ::~dd10(){ note_dtor("dd10", this);} // tgen

static void Test_dd10()
{
  extern Class_Descriptor cd_dd10;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd10, buf);
    dd10 *dp, &lv = *(dp=new (buf) dd10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd10)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd10.d");
    test_class_info(&lv, &cd_dd10);
    dp->~dd10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd10(Test_dd10, "dd10", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd10C1Ev();
extern void _ZN4dd10D1Ev();
Name_Map name_map_dd10[] = {
  NSPAIR(_ZN4dd10C1Ev),
  NSPAIR(_ZN4dd10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd10[];
extern void _ZN4dd103fooEv();
static  VTBL_ENTRY vtc_dd10[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd10[0]),
  (VTBL_ENTRY)&_ZN4dd103fooEv,
};
extern VTBL_ENTRY _ZTI4dd10[];
extern  VTBL_ENTRY _ZTV4dd10[];
Class_Descriptor cd_dd10 = {  "dd10", // class name
  0,0,//no base classes
  &(vtc_dd10[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd10),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd10),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee10  : aa10 , virtual bb10 {
  int e;
   ee10(const ABISELECT(__tsi64,int) *const *); // _ZN4ee10C2Ev
  virtual void  foo(); // _ZN4ee103fooEv
  ~ee10(); // tgen
  ee10(); // tgen
};
//SIG(-1 ee10) C1{ BC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ee10 ::ee10(const ABISELECT(__tsi64,int) *const *){}
void  ee10 ::foo(){vfunc_called(this, "_ZN4ee103fooEv");}
ee10 ::~ee10(){ note_dtor("ee10", this);} // tgen
ee10 ::ee10(){ note_ctor("ee10", this);} // tgen

static void Test_ee10()
{
  extern Class_Descriptor cd_ee10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee10, buf);
    ee10 *dp, &lv = *(dp=new (buf) ee10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee10)");
    check_base_class_offset(lv, (aa10*), 0, "ee10");
    check_base_class_offset(lv, (bb10*), ABISELECT(16,12), "ee10");
    check_field_offset(lv, e, ABISELECT(12,8), "ee10.e");
    test_class_info(&lv, &cd_ee10);
    dp->~ee10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee10(Test_ee10, "ee10", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ee10C1Ev();
extern void _ZN4ee10D1Ev();
Name_Map name_map_ee10[] = {
  NSPAIR(_ZN4ee10C1Ev),
  NSPAIR(_ZN4ee10D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa10;
extern VTBL_ENTRY _ZTI4aa10[];
extern  VTBL_ENTRY _ZTV4aa10[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
static Base_Class bases_ee10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_bb10,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ee10[];
extern void _ZN4ee103fooEv();
extern void ABISELECT(_ZTv0_n24_N4ee103fooEv,_ZTv0_n12_N4ee103fooEv)();
extern void ABISELECT(_ZThn16_N4ee103fooEv,_ZThn12_N4ee103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee10[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee10[0]),
  (VTBL_ENTRY)&_ZN4ee103fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee103fooEv,_ZTv0_n12_N4ee103fooEv),
};
extern VTBL_ENTRY _ZTV4ee10[];
static  VTT_ENTRY vtt_ee10[] = {
  {&(_ZTV4ee10[3]),  3,8},
  {&(_ZTV4ee10[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ee10[];
extern  VTBL_ENTRY _ZTV4ee10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee10[];
static VTBL_ENTRY alt_thunk_names23[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee103fooEv,_ZTv0_n12_N4ee103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee103fooEv,_ZThn12_N4ee103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee10 = {  "ee10", // class name
  bases_ee10, 2,
  &(vtc_ee10[0]), // expected_vtbl_contents
  &(vtt_ee10[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ee10),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee10),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ee10),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names23,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff10  : cc10 , virtual dd10 {
  int f;
   ff10(const ABISELECT(__tsi64,int) *const *); // _ZN4ff10C2Ev
  virtual void  foo(); // _ZN4ff103fooEv
  ~ff10(); // tgen
  ff10(); // tgen
};
//SIG(-1 ff10) C1{ BC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ff10 ::ff10(const ABISELECT(__tsi64,int) *const *){}
void  ff10 ::foo(){vfunc_called(this, "_ZN4ff103fooEv");}
ff10 ::~ff10(){ note_dtor("ff10", this);} // tgen
ff10 ::ff10(){ note_ctor("ff10", this);} // tgen

static void Test_ff10()
{
  extern Class_Descriptor cd_ff10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff10, buf);
    ff10 *dp, &lv = *(dp=new (buf) ff10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff10)");
    check_base_class_offset(lv, (cc10*), 0, "ff10");
    check_base_class_offset(lv, (dd10*), ABISELECT(16,12), "ff10");
    check_field_offset(lv, f, ABISELECT(12,8), "ff10.f");
    test_class_info(&lv, &cd_ff10);
    dp->~ff10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff10(Test_ff10, "ff10", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ff10C1Ev();
extern void _ZN4ff10D1Ev();
Name_Map name_map_ff10[] = {
  NSPAIR(_ZN4ff10C1Ev),
  NSPAIR(_ZN4ff10D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc10;
extern VTBL_ENTRY _ZTI4cc10[];
extern  VTBL_ENTRY _ZTV4cc10[];
extern Class_Descriptor cd_dd10;
extern VTBL_ENTRY _ZTI4dd10[];
extern  VTBL_ENTRY _ZTV4dd10[];
static Base_Class bases_ff10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_dd10,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ff10[];
extern void _ZN4ff103fooEv();
extern void ABISELECT(_ZTv0_n24_N4ff103fooEv,_ZTv0_n12_N4ff103fooEv)();
extern void ABISELECT(_ZThn16_N4ff103fooEv,_ZThn12_N4ff103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff10[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff10[0]),
  (VTBL_ENTRY)&_ZN4ff103fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff103fooEv,_ZTv0_n12_N4ff103fooEv),
};
extern VTBL_ENTRY _ZTV4ff10[];
static  VTT_ENTRY vtt_ff10[] = {
  {&(_ZTV4ff10[3]),  3,8},
  {&(_ZTV4ff10[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ff10[];
extern  VTBL_ENTRY _ZTV4ff10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff10[];
static VTBL_ENTRY alt_thunk_names24[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff103fooEv,_ZTv0_n12_N4ff103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff103fooEv,_ZThn12_N4ff103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff10 = {  "ff10", // class name
  bases_ff10, 2,
  &(vtc_ff10[0]), // expected_vtbl_contents
  &(vtt_ff10[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ff10),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff10),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ff10),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names24,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg10  : ee10 , ff10 {
  int g;
   gg10(const ABISELECT(__tsi64,int) *const *); // _ZN4gg10C2Ev
  virtual void  foo(); // _ZN4gg103fooEv
  ~gg10(); // tgen
  gg10(); // tgen
};
//SIG(1 gg10) C1{ BC2{ BC3{ v1 Fi} VBC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 Fi} VBC7{ v1 Fi} v1 Fi} v1 Fi}


 gg10 ::gg10(const ABISELECT(__tsi64,int) *const *){}
void  gg10 ::foo(){vfunc_called(this, "_ZN4gg103fooEv");}
gg10 ::~gg10(){ note_dtor("gg10", this);} // tgen
gg10 ::gg10(){ note_ctor("gg10", this);} // tgen

static void Test_gg10()
{
  extern Class_Descriptor cd_gg10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg10, buf);
    gg10 *dp, &lv = *(dp=new (buf) gg10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg10)");
    check_base_class_offset(lv, (aa10*)(ee10*), 0, "gg10");
    check_base_class_offset(lv, (bb10*)(ee10*), ABISELECT(40,28), "gg10");
    check_base_class_offset(lv, (ee10*), 0, "gg10");
    check_base_class_offset(lv, (cc10*)(ff10*), ABISELECT(16,12), "gg10");
    check_base_class_offset(lv, (dd10*)(ff10*), ABISELECT(56,36), "gg10");
    check_base_class_offset(lv, (ff10*), ABISELECT(16,12), "gg10");
    check_field_offset(lv, g, ABISELECT(32,24), "gg10.g");
    test_class_info(&lv, &cd_gg10);
    dp->~gg10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg10(Test_gg10, "gg10", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN4gg10C1Ev();
extern void _ZN4gg10D1Ev();
Name_Map name_map_gg10[] = {
  NSPAIR(_ZN4gg10C1Ev),
  NSPAIR(_ZN4gg10D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa10;
extern VTBL_ENTRY _ZTI4aa10[];
extern  VTBL_ENTRY _ZTV4aa10[];
extern Class_Descriptor cd_bb10;
extern VTBL_ENTRY _ZTI4bb10[];
extern  VTBL_ENTRY _ZTV4bb10[];
extern Class_Descriptor cd_ee10;
extern VTBL_ENTRY _ZTI4ee10[];
extern  VTBL_ENTRY _ZTV4ee10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee10[];
extern Class_Descriptor cd_cc10;
extern VTBL_ENTRY _ZTI4cc10[];
extern  VTBL_ENTRY _ZTV4cc10[];
extern Class_Descriptor cd_dd10;
extern VTBL_ENTRY _ZTI4dd10[];
extern  VTBL_ENTRY _ZTV4dd10[];
extern Class_Descriptor cd_ff10;
extern VTBL_ENTRY _ZTI4ff10[];
extern  VTBL_ENTRY _ZTV4ff10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff10[];
static Base_Class bases_gg10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_bb10,    ABISELECT(40,28), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_ee10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc10,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_dd10,    ABISELECT(56,36), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_ff10,    ABISELECT(16,12), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4gg10[];
extern void _ZN4gg103fooEv();
extern void ABISELECT(_ZThn16_N4gg103fooEv,_ZThn12_N4gg103fooEv)();
extern void ABISELECT(_ZTv0_n24_N4gg103fooEv,_ZTv0_n12_N4gg103fooEv)();
extern void ABISELECT(_ZThn40_N4gg103fooEv,_ZThn28_N4gg103fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg103fooEv,_ZTv0_n12_N4gg103fooEv)();
extern void ABISELECT(_ZThn56_N4gg103fooEv,_ZThn36_N4gg103fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg10[] = {
  ABISELECT(56,36),
  ABISELECT(40,28),
  0,
  (VTBL_ENTRY)&(_ZTI4gg10[0]),
  (VTBL_ENTRY)&_ZN4gg103fooEv,
  ABISELECT(40,24),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4gg10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4gg103fooEv,_ZThn12_N4gg103fooEv),
  ABISELECT(-40,-28),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI4gg10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg103fooEv,_ZTv0_n12_N4gg103fooEv),
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI4gg10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg103fooEv,_ZTv0_n12_N4gg103fooEv),
};
extern VTBL_ENTRY _ZTV4gg10[];
extern void _ZN4ee103fooEv();
static  VTBL_ENTRY _tg__ZTV4ee10__4gg10[] = {
  ABISELECT(40,28),
  0,
  (VTBL_ENTRY)&(_ZTI4ee10[0]),
  (VTBL_ENTRY)&_ZN4ee103fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ee103fooEv,_ZTv0_n12_N4ee103fooEv)();
extern void ABISELECT(_ZThn40_N4ee103fooEv,_ZThn28_N4ee103fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb10__4ee10__4gg10[] = {
  ABISELECT(-40,-28),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI4ee10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee103fooEv,_ZTv0_n12_N4ee103fooEv),
};
extern void _ZN4ff103fooEv();
static  VTBL_ENTRY _tg__ZTV4ff10__4gg10[] = {
  ABISELECT(40,24),
  0,
  (VTBL_ENTRY)&(_ZTI4ff10[0]),
  (VTBL_ENTRY)&_ZN4ff103fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ff103fooEv,_ZTv0_n12_N4ff103fooEv)();
extern void ABISELECT(_ZThn40_N4ff103fooEv,_ZThn24_N4ff103fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4dd10__4ff10__4gg10[] = {
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI4ff10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff103fooEv,_ZTv0_n12_N4ff103fooEv),
};
static  VTT_ENTRY vtt_gg10[] = {
  {&(_ZTV4gg10[4]),  4,17},
  {&(_tg__ZTV4ee10__4gg10[3]),  3,4},
  {&(_tg__ZTV4bb10__4ee10__4gg10[3]),  3,4},
  {&(_tg__ZTV4ff10__4gg10[3]),  3,4},
  {&(_tg__ZTV4dd10__4ff10__4gg10[3]),  3,4},
  {&(_ZTV4gg10[12]),  12,17},
  {&(_ZTV4gg10[8]),  8,17},
  {&(_ZTV4gg10[16]),  16,17},
};
extern VTBL_ENTRY _ZTI4gg10[];
extern  VTBL_ENTRY _ZTV4gg10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg10[];
static VTBL_ENTRY alt_thunk_names25[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff103fooEv,_ZTv0_n12_N4ff103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N4ff103fooEv,_ZThn24_N4ff103fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee103fooEv,_ZTv0_n12_N4ee103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N4ee103fooEv,_ZThn28_N4ee103fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg103fooEv,_ZTv0_n12_N4gg103fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4gg103fooEv,_ZThn36_N4gg103fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N4gg103fooEv,_ZThn28_N4gg103fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg10 = {  "gg10", // class name
  bases_gg10, 6,
  &(vtc_gg10[0]), // expected_vtbl_contents
  &(vtt_gg10[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI4gg10),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg10),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg10),8, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names25,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa11  {
  int a;
   aa11(); // _ZN4aa11C1Ev
  virtual void  foo(); // _ZN4aa113fooEv
  ~aa11(); // tgen
};
//SIG(-1 aa11) C1{ v1 Fi}


 aa11 ::aa11(){ note_ctor("aa11", this);}
void  aa11 ::foo(){vfunc_called(this, "_ZN4aa113fooEv");}
aa11 ::~aa11(){ note_dtor("aa11", this);} // tgen

static void Test_aa11()
{
  extern Class_Descriptor cd_aa11;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa11, buf);
    aa11 *dp, &lv = *(dp=new (buf) aa11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa11)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa11.a");
    test_class_info(&lv, &cd_aa11);
    dp->~aa11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa11(Test_aa11, "aa11", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa11C1Ev();
extern void _ZN4aa11D1Ev();
Name_Map name_map_aa11[] = {
  NSPAIR(_ZN4aa11C1Ev),
  NSPAIR(_ZN4aa11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa11[];
extern void _ZN4aa113fooEv();
static  VTBL_ENTRY vtc_aa11[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa11[0]),
  (VTBL_ENTRY)&_ZN4aa113fooEv,
};
extern VTBL_ENTRY _ZTI4aa11[];
extern  VTBL_ENTRY _ZTV4aa11[];
Class_Descriptor cd_aa11 = {  "aa11", // class name
  0,0,//no base classes
  &(vtc_aa11[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa11),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa11),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb11  {
  int b;
   bb11(); // _ZN4bb11C1Ev
  virtual void  foo(); // _ZN4bb113fooEv
  ~bb11(); // tgen
};
//SIG(-1 bb11) C1{ v1 Fi}


 bb11 ::bb11(){ note_ctor("bb11", this);}
void  bb11 ::foo(){vfunc_called(this, "_ZN4bb113fooEv");}
bb11 ::~bb11(){ note_dtor("bb11", this);} // tgen

static void Test_bb11()
{
  extern Class_Descriptor cd_bb11;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb11, buf);
    bb11 *dp, &lv = *(dp=new (buf) bb11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb11)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb11.b");
    test_class_info(&lv, &cd_bb11);
    dp->~bb11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb11(Test_bb11, "bb11", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb11C1Ev();
extern void _ZN4bb11D1Ev();
Name_Map name_map_bb11[] = {
  NSPAIR(_ZN4bb11C1Ev),
  NSPAIR(_ZN4bb11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb11[];
extern void _ZN4bb113fooEv();
static  VTBL_ENTRY vtc_bb11[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb11[0]),
  (VTBL_ENTRY)&_ZN4bb113fooEv,
};
extern VTBL_ENTRY _ZTI4bb11[];
extern  VTBL_ENTRY _ZTV4bb11[];
Class_Descriptor cd_bb11 = {  "bb11", // class name
  0,0,//no base classes
  &(vtc_bb11[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb11),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb11),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc11  {
  int c;
   cc11(); // _ZN4cc11C1Ev
  virtual void  foo(); // _ZN4cc113fooEv
  ~cc11(); // tgen
};
//SIG(-1 cc11) C1{ v1 Fi}


 cc11 ::cc11(){ note_ctor("cc11", this);}
void  cc11 ::foo(){vfunc_called(this, "_ZN4cc113fooEv");}
cc11 ::~cc11(){ note_dtor("cc11", this);} // tgen

static void Test_cc11()
{
  extern Class_Descriptor cd_cc11;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc11, buf);
    cc11 *dp, &lv = *(dp=new (buf) cc11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc11)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc11.c");
    test_class_info(&lv, &cd_cc11);
    dp->~cc11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc11(Test_cc11, "cc11", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc11C1Ev();
extern void _ZN4cc11D1Ev();
Name_Map name_map_cc11[] = {
  NSPAIR(_ZN4cc11C1Ev),
  NSPAIR(_ZN4cc11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc11[];
extern void _ZN4cc113fooEv();
static  VTBL_ENTRY vtc_cc11[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc11[0]),
  (VTBL_ENTRY)&_ZN4cc113fooEv,
};
extern VTBL_ENTRY _ZTI4cc11[];
extern  VTBL_ENTRY _ZTV4cc11[];
Class_Descriptor cd_cc11 = {  "cc11", // class name
  0,0,//no base classes
  &(vtc_cc11[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc11),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc11),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd11  {
  int d;
   dd11(); // _ZN4dd11C1Ev
  virtual void  foo(); // _ZN4dd113fooEv
  ~dd11(); // tgen
};
//SIG(-1 dd11) C1{ v1 Fi}


 dd11 ::dd11(){ note_ctor("dd11", this);}
void  dd11 ::foo(){vfunc_called(this, "_ZN4dd113fooEv");}
dd11 ::~dd11(){ note_dtor("dd11", this);} // tgen

static void Test_dd11()
{
  extern Class_Descriptor cd_dd11;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd11, buf);
    dd11 *dp, &lv = *(dp=new (buf) dd11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd11)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd11.d");
    test_class_info(&lv, &cd_dd11);
    dp->~dd11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd11(Test_dd11, "dd11", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd11C1Ev();
extern void _ZN4dd11D1Ev();
Name_Map name_map_dd11[] = {
  NSPAIR(_ZN4dd11C1Ev),
  NSPAIR(_ZN4dd11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd11[];
extern void _ZN4dd113fooEv();
static  VTBL_ENTRY vtc_dd11[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd11[0]),
  (VTBL_ENTRY)&_ZN4dd113fooEv,
};
extern VTBL_ENTRY _ZTI4dd11[];
extern  VTBL_ENTRY _ZTV4dd11[];
Class_Descriptor cd_dd11 = {  "dd11", // class name
  0,0,//no base classes
  &(vtc_dd11[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd11),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd11),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee11  : virtual aa11 , virtual bb11 {
  int e;
   ee11(const ABISELECT(__tsi64,int) *const *); // _ZN4ee11C2Ev
  virtual void  foo(); // _ZN4ee113fooEv
  ~ee11(); // tgen
  ee11(); // tgen
};
//SIG(-1 ee11) C1{ VBC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ee11 ::ee11(const ABISELECT(__tsi64,int) *const *){}
void  ee11 ::foo(){vfunc_called(this, "_ZN4ee113fooEv");}
ee11 ::~ee11(){ note_dtor("ee11", this);} // tgen
ee11 ::ee11(){ note_ctor("ee11", this);} // tgen

static void Test_ee11()
{
  extern Class_Descriptor cd_ee11;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_ee11, buf);
    ee11 *dp, &lv = *(dp=new (buf) ee11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(ee11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee11)");
    check_base_class_offset(lv, (aa11*), ABISELECT(16,8), "ee11");
    check_base_class_offset(lv, (bb11*), ABISELECT(32,16), "ee11");
    check_field_offset(lv, e, ABISELECT(8,4), "ee11.e");
    test_class_info(&lv, &cd_ee11);
    dp->~ee11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee11(Test_ee11, "ee11", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN4ee11C1Ev();
extern void _ZN4ee11D1Ev();
Name_Map name_map_ee11[] = {
  NSPAIR(_ZN4ee11C1Ev),
  NSPAIR(_ZN4ee11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa11;
extern VTBL_ENTRY _ZTI4aa11[];
extern  VTBL_ENTRY _ZTV4aa11[];
extern Class_Descriptor cd_bb11;
extern VTBL_ENTRY _ZTI4bb11[];
extern  VTBL_ENTRY _ZTV4bb11[];
static Base_Class bases_ee11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa11,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_bb11,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ee11[];
extern void _ZN4ee113fooEv();
extern void ABISELECT(_ZTv0_n24_N4ee113fooEv,_ZTv0_n12_N4ee113fooEv)();
extern void ABISELECT(_ZThn16_N4ee113fooEv,_ZThn8_N4ee113fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4ee113fooEv,_ZTv0_n12_N4ee113fooEv)();
extern void ABISELECT(_ZThn32_N4ee113fooEv,_ZThn16_N4ee113fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee11[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI4ee11[0]),
  (VTBL_ENTRY)&_ZN4ee113fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ee11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee113fooEv,_ZTv0_n12_N4ee113fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI4ee11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee113fooEv,_ZTv0_n12_N4ee113fooEv),
};
extern VTBL_ENTRY _ZTV4ee11[];
static  VTT_ENTRY vtt_ee11[] = {
  {&(_ZTV4ee11[4]),  4,13},
  {&(_ZTV4ee11[8]),  8,13},
  {&(_ZTV4ee11[12]),  12,13},
};
extern VTBL_ENTRY _ZTI4ee11[];
extern  VTBL_ENTRY _ZTV4ee11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee11[];
static VTBL_ENTRY alt_thunk_names26[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee113fooEv,_ZTv0_n12_N4ee113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ee113fooEv,_ZThn16_N4ee113fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee113fooEv,_ZThn8_N4ee113fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee11 = {  "ee11", // class name
  bases_ee11, 2,
  &(vtc_ee11[0]), // expected_vtbl_contents
  &(vtt_ee11[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI4ee11),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee11),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ee11),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names26,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff11  : cc11 , virtual dd11 {
  int f;
   ff11(const ABISELECT(__tsi64,int) *const *); // _ZN4ff11C2Ev
  virtual void  foo(); // _ZN4ff113fooEv
  ~ff11(); // tgen
  ff11(); // tgen
};
//SIG(-1 ff11) C1{ BC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ff11 ::ff11(const ABISELECT(__tsi64,int) *const *){}
void  ff11 ::foo(){vfunc_called(this, "_ZN4ff113fooEv");}
ff11 ::~ff11(){ note_dtor("ff11", this);} // tgen
ff11 ::ff11(){ note_ctor("ff11", this);} // tgen

static void Test_ff11()
{
  extern Class_Descriptor cd_ff11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff11, buf);
    ff11 *dp, &lv = *(dp=new (buf) ff11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff11)");
    check_base_class_offset(lv, (cc11*), 0, "ff11");
    check_base_class_offset(lv, (dd11*), ABISELECT(16,12), "ff11");
    check_field_offset(lv, f, ABISELECT(12,8), "ff11.f");
    test_class_info(&lv, &cd_ff11);
    dp->~ff11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff11(Test_ff11, "ff11", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ff11C1Ev();
extern void _ZN4ff11D1Ev();
Name_Map name_map_ff11[] = {
  NSPAIR(_ZN4ff11C1Ev),
  NSPAIR(_ZN4ff11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc11;
extern VTBL_ENTRY _ZTI4cc11[];
extern  VTBL_ENTRY _ZTV4cc11[];
extern Class_Descriptor cd_dd11;
extern VTBL_ENTRY _ZTI4dd11[];
extern  VTBL_ENTRY _ZTV4dd11[];
static Base_Class bases_ff11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_dd11,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ff11[];
extern void _ZN4ff113fooEv();
extern void ABISELECT(_ZTv0_n24_N4ff113fooEv,_ZTv0_n12_N4ff113fooEv)();
extern void ABISELECT(_ZThn16_N4ff113fooEv,_ZThn12_N4ff113fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff11[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff11[0]),
  (VTBL_ENTRY)&_ZN4ff113fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff113fooEv,_ZTv0_n12_N4ff113fooEv),
};
extern VTBL_ENTRY _ZTV4ff11[];
static  VTT_ENTRY vtt_ff11[] = {
  {&(_ZTV4ff11[3]),  3,8},
  {&(_ZTV4ff11[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ff11[];
extern  VTBL_ENTRY _ZTV4ff11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff11[];
static VTBL_ENTRY alt_thunk_names27[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff113fooEv,_ZTv0_n12_N4ff113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff113fooEv,_ZThn12_N4ff113fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff11 = {  "ff11", // class name
  bases_ff11, 2,
  &(vtc_ff11[0]), // expected_vtbl_contents
  &(vtt_ff11[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ff11),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff11),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ff11),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names27,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg11  : ee11 , ff11 {
  int g;
   gg11(const ABISELECT(__tsi64,int) *const *); // _ZN4gg11C2Ev
  virtual void  foo(); // _ZN4gg113fooEv
  ~gg11(); // tgen
  gg11(); // tgen
};
//SIG(1 gg11) C1{ BC2{ VBC3{ v1 Fi} VBC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 Fi} VBC7{ v1 Fi} v1 Fi} v1 Fi}


 gg11 ::gg11(const ABISELECT(__tsi64,int) *const *){}
void  gg11 ::foo(){vfunc_called(this, "_ZN4gg113fooEv");}
gg11 ::~gg11(){ note_dtor("gg11", this);} // tgen
gg11 ::gg11(){ note_ctor("gg11", this);} // tgen

static void Test_gg11()
{
  extern Class_Descriptor cd_gg11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(12,13)];
    init_test(&cd_gg11, buf);
    gg11 *dp, &lv = *(dp=new (buf) gg11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(88,48), "sizeof(gg11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg11)");
    check_base_class_offset(lv, (aa11*)(ee11*), ABISELECT(40,24), "gg11");
    check_base_class_offset(lv, (bb11*)(ee11*), ABISELECT(56,32), "gg11");
    check_base_class_offset(lv, (ee11*), 0, "gg11");
    check_base_class_offset(lv, (cc11*)(ff11*), ABISELECT(16,8), "gg11");
    check_base_class_offset(lv, (dd11*)(ff11*), ABISELECT(72,40), "gg11");
    check_base_class_offset(lv, (ff11*), ABISELECT(16,8), "gg11");
    check_field_offset(lv, g, ABISELECT(32,20), "gg11.g");
    test_class_info(&lv, &cd_gg11);
    dp->~gg11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg11(Test_gg11, "gg11", ABISELECT(88,48));

#else // __cplusplus

extern void _ZN4gg11C1Ev();
extern void _ZN4gg11D1Ev();
Name_Map name_map_gg11[] = {
  NSPAIR(_ZN4gg11C1Ev),
  NSPAIR(_ZN4gg11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa11;
extern VTBL_ENTRY _ZTI4aa11[];
extern  VTBL_ENTRY _ZTV4aa11[];
extern Class_Descriptor cd_bb11;
extern VTBL_ENTRY _ZTI4bb11[];
extern  VTBL_ENTRY _ZTV4bb11[];
extern Class_Descriptor cd_ee11;
extern VTBL_ENTRY _ZTI4ee11[];
extern  VTBL_ENTRY _ZTV4ee11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee11[];
extern Class_Descriptor cd_cc11;
extern VTBL_ENTRY _ZTI4cc11[];
extern  VTBL_ENTRY _ZTV4cc11[];
extern Class_Descriptor cd_dd11;
extern VTBL_ENTRY _ZTI4dd11[];
extern  VTBL_ENTRY _ZTV4dd11[];
extern Class_Descriptor cd_ff11;
extern VTBL_ENTRY _ZTI4ff11[];
extern  VTBL_ENTRY _ZTV4ff11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff11[];
static Base_Class bases_gg11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa11,    ABISELECT(40,24), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_bb11,    ABISELECT(56,32), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_ee11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc11,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_dd11,    ABISELECT(72,40), //bcp->offset
    18, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_ff11,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4gg11[];
extern void _ZN4gg113fooEv();
extern void ABISELECT(_ZThn16_N4gg113fooEv,_ZThn8_N4gg113fooEv)();
extern void ABISELECT(_ZTv0_n24_N4gg113fooEv,_ZTv0_n12_N4gg113fooEv)();
extern void ABISELECT(_ZThn40_N4gg113fooEv,_ZThn24_N4gg113fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg113fooEv,_ZTv0_n12_N4gg113fooEv)();
extern void ABISELECT(_ZThn56_N4gg113fooEv,_ZThn32_N4gg113fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg113fooEv,_ZTv0_n12_N4gg113fooEv)();
extern void ABISELECT(_ZThn72_N4gg113fooEv,_ZThn40_N4gg113fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg11[] = {
  ABISELECT(72,40),
  ABISELECT(56,32),
  ABISELECT(40,24),
  0,
  (VTBL_ENTRY)&(_ZTI4gg11[0]),
  (VTBL_ENTRY)&_ZN4gg113fooEv,
  ABISELECT(56,32),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4gg11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4gg113fooEv,_ZThn8_N4gg113fooEv),
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI4gg11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg113fooEv,_ZTv0_n12_N4gg113fooEv),
  ABISELECT(-56,-32),
  ABISELECT(-56,-32),
  (VTBL_ENTRY)&(_ZTI4gg11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg113fooEv,_ZTv0_n12_N4gg113fooEv),
  ABISELECT(-72,-40),
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI4gg11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg113fooEv,_ZTv0_n12_N4gg113fooEv),
};
extern VTBL_ENTRY _ZTV4gg11[];
extern void _ZN4ee113fooEv();
static  VTBL_ENTRY _tg__ZTV4ee11__4gg11[] = {
  ABISELECT(56,32),
  ABISELECT(40,24),
  0,
  (VTBL_ENTRY)&(_ZTI4ee11[0]),
  (VTBL_ENTRY)&_ZN4ee113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ee113fooEv,_ZTv0_n12_N4ee113fooEv)();
extern void ABISELECT(_ZThn40_N4ee113fooEv,_ZThn24_N4ee113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4aa11__4ee11__4gg11[] = {
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI4ee11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee113fooEv,_ZTv0_n12_N4ee113fooEv),
};
extern void ABISELECT(_ZTv0_n24_N4ee113fooEv,_ZTv0_n12_N4ee113fooEv)();
extern void ABISELECT(_ZThn56_N4ee113fooEv,_ZThn32_N4ee113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb11__4ee11__4gg11[] = {
  ABISELECT(-56,-32),
  ABISELECT(-56,-32),
  (VTBL_ENTRY)&(_ZTI4ee11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee113fooEv,_ZTv0_n12_N4ee113fooEv),
};
extern void _ZN4ff113fooEv();
static  VTBL_ENTRY _tg__ZTV4ff11__4gg11[] = {
  ABISELECT(56,32),
  0,
  (VTBL_ENTRY)&(_ZTI4ff11[0]),
  (VTBL_ENTRY)&_ZN4ff113fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ff113fooEv,_ZTv0_n12_N4ff113fooEv)();
extern void ABISELECT(_ZThn56_N4ff113fooEv,_ZThn32_N4ff113fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4dd11__4ff11__4gg11[] = {
  ABISELECT(-56,-32),
  ABISELECT(-56,-32),
  (VTBL_ENTRY)&(_ZTI4ff11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff113fooEv,_ZTv0_n12_N4ff113fooEv),
};
static  VTT_ENTRY vtt_gg11[] = {
  {&(_ZTV4gg11[5]),  5,22},
  {&(_tg__ZTV4ee11__4gg11[4]),  4,5},
  {&(_tg__ZTV4aa11__4ee11__4gg11[3]),  3,4},
  {&(_tg__ZTV4bb11__4ee11__4gg11[3]),  3,4},
  {&(_tg__ZTV4ff11__4gg11[3]),  3,4},
  {&(_tg__ZTV4dd11__4ff11__4gg11[3]),  3,4},
  {&(_ZTV4gg11[13]),  13,22},
  {&(_ZTV4gg11[17]),  17,22},
  {&(_ZTV4gg11[9]),  9,22},
  {&(_ZTV4gg11[21]),  21,22},
};
extern VTBL_ENTRY _ZTI4gg11[];
extern  VTBL_ENTRY _ZTV4gg11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg11[];
static VTBL_ENTRY alt_thunk_names28[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff113fooEv,_ZTv0_n12_N4ff113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4ff113fooEv,_ZThn32_N4ff113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee113fooEv,_ZTv0_n12_N4ee113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4ee113fooEv,_ZThn32_N4ee113fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N4ee113fooEv,_ZThn24_N4ee113fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg113fooEv,_ZTv0_n12_N4gg113fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N4gg113fooEv,_ZThn40_N4gg113fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4gg113fooEv,_ZThn32_N4gg113fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N4gg113fooEv,_ZThn24_N4gg113fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg11 = {  "gg11", // class name
  bases_gg11, 6,
  &(vtc_gg11[0]), // expected_vtbl_contents
  &(vtt_gg11[0]), // expected_vtt_contents
  ABISELECT(88,48), // object size
  NSPAIRA(_ZTI4gg11),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg11),22, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg11),10, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names28,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa12  {
  int a;
   aa12(); // _ZN4aa12C1Ev
  virtual void  foo(); // _ZN4aa123fooEv
  ~aa12(); // tgen
};
//SIG(-1 aa12) C1{ v1 Fi}


 aa12 ::aa12(){ note_ctor("aa12", this);}
void  aa12 ::foo(){vfunc_called(this, "_ZN4aa123fooEv");}
aa12 ::~aa12(){ note_dtor("aa12", this);} // tgen

static void Test_aa12()
{
  extern Class_Descriptor cd_aa12;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa12, buf);
    aa12 *dp, &lv = *(dp=new (buf) aa12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa12)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa12.a");
    test_class_info(&lv, &cd_aa12);
    dp->~aa12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa12(Test_aa12, "aa12", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa12C1Ev();
extern void _ZN4aa12D1Ev();
Name_Map name_map_aa12[] = {
  NSPAIR(_ZN4aa12C1Ev),
  NSPAIR(_ZN4aa12D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa12[];
extern void _ZN4aa123fooEv();
static  VTBL_ENTRY vtc_aa12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa12[0]),
  (VTBL_ENTRY)&_ZN4aa123fooEv,
};
extern VTBL_ENTRY _ZTI4aa12[];
extern  VTBL_ENTRY _ZTV4aa12[];
Class_Descriptor cd_aa12 = {  "aa12", // class name
  0,0,//no base classes
  &(vtc_aa12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa12),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa12),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb12  {
  int b;
   bb12(); // _ZN4bb12C1Ev
  virtual void  foo(); // _ZN4bb123fooEv
  ~bb12(); // tgen
};
//SIG(-1 bb12) C1{ v1 Fi}


 bb12 ::bb12(){ note_ctor("bb12", this);}
void  bb12 ::foo(){vfunc_called(this, "_ZN4bb123fooEv");}
bb12 ::~bb12(){ note_dtor("bb12", this);} // tgen

static void Test_bb12()
{
  extern Class_Descriptor cd_bb12;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb12, buf);
    bb12 *dp, &lv = *(dp=new (buf) bb12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb12)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb12.b");
    test_class_info(&lv, &cd_bb12);
    dp->~bb12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb12(Test_bb12, "bb12", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb12C1Ev();
extern void _ZN4bb12D1Ev();
Name_Map name_map_bb12[] = {
  NSPAIR(_ZN4bb12C1Ev),
  NSPAIR(_ZN4bb12D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb12[];
extern void _ZN4bb123fooEv();
static  VTBL_ENTRY vtc_bb12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb12[0]),
  (VTBL_ENTRY)&_ZN4bb123fooEv,
};
extern VTBL_ENTRY _ZTI4bb12[];
extern  VTBL_ENTRY _ZTV4bb12[];
Class_Descriptor cd_bb12 = {  "bb12", // class name
  0,0,//no base classes
  &(vtc_bb12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb12),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb12),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc12  {
  int c;
   cc12(); // _ZN4cc12C1Ev
  virtual void  foo(); // _ZN4cc123fooEv
  ~cc12(); // tgen
};
//SIG(-1 cc12) C1{ v1 Fi}


 cc12 ::cc12(){ note_ctor("cc12", this);}
void  cc12 ::foo(){vfunc_called(this, "_ZN4cc123fooEv");}
cc12 ::~cc12(){ note_dtor("cc12", this);} // tgen

static void Test_cc12()
{
  extern Class_Descriptor cd_cc12;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc12, buf);
    cc12 *dp, &lv = *(dp=new (buf) cc12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc12)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc12.c");
    test_class_info(&lv, &cd_cc12);
    dp->~cc12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc12(Test_cc12, "cc12", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc12C1Ev();
extern void _ZN4cc12D1Ev();
Name_Map name_map_cc12[] = {
  NSPAIR(_ZN4cc12C1Ev),
  NSPAIR(_ZN4cc12D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc12[];
extern void _ZN4cc123fooEv();
static  VTBL_ENTRY vtc_cc12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc12[0]),
  (VTBL_ENTRY)&_ZN4cc123fooEv,
};
extern VTBL_ENTRY _ZTI4cc12[];
extern  VTBL_ENTRY _ZTV4cc12[];
Class_Descriptor cd_cc12 = {  "cc12", // class name
  0,0,//no base classes
  &(vtc_cc12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc12),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc12),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd12  {
  int d;
   dd12(); // _ZN4dd12C1Ev
  virtual void  foo(); // _ZN4dd123fooEv
  ~dd12(); // tgen
};
//SIG(-1 dd12) C1{ v1 Fi}


 dd12 ::dd12(){ note_ctor("dd12", this);}
void  dd12 ::foo(){vfunc_called(this, "_ZN4dd123fooEv");}
dd12 ::~dd12(){ note_dtor("dd12", this);} // tgen

static void Test_dd12()
{
  extern Class_Descriptor cd_dd12;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd12, buf);
    dd12 *dp, &lv = *(dp=new (buf) dd12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd12)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd12.d");
    test_class_info(&lv, &cd_dd12);
    dp->~dd12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd12(Test_dd12, "dd12", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd12C1Ev();
extern void _ZN4dd12D1Ev();
Name_Map name_map_dd12[] = {
  NSPAIR(_ZN4dd12C1Ev),
  NSPAIR(_ZN4dd12D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd12[];
extern void _ZN4dd123fooEv();
static  VTBL_ENTRY vtc_dd12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd12[0]),
  (VTBL_ENTRY)&_ZN4dd123fooEv,
};
extern VTBL_ENTRY _ZTI4dd12[];
extern  VTBL_ENTRY _ZTV4dd12[];
Class_Descriptor cd_dd12 = {  "dd12", // class name
  0,0,//no base classes
  &(vtc_dd12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd12),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd12),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee12  : aa12 , bb12 {
  int e;
   ee12(); // _ZN4ee12C1Ev
  virtual void  foo(); // _ZN4ee123fooEv
  ~ee12(); // tgen
};
//SIG(-1 ee12) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ee12 ::ee12(){ note_ctor("ee12", this);}
void  ee12 ::foo(){vfunc_called(this, "_ZN4ee123fooEv");}
ee12 ::~ee12(){ note_dtor("ee12", this);} // tgen

static void Test_ee12()
{
  extern Class_Descriptor cd_ee12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee12, buf);
    ee12 *dp, &lv = *(dp=new (buf) ee12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee12)");
    check_base_class_offset(lv, (aa12*), 0, "ee12");
    check_base_class_offset(lv, (bb12*), ABISELECT(16,8), "ee12");
    check_field_offset(lv, e, ABISELECT(28,16), "ee12.e");
    test_class_info(&lv, &cd_ee12);
    dp->~ee12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee12(Test_ee12, "ee12", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ee12C1Ev();
extern void _ZN4ee12D1Ev();
Name_Map name_map_ee12[] = {
  NSPAIR(_ZN4ee12C1Ev),
  NSPAIR(_ZN4ee12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa12;
extern VTBL_ENTRY _ZTI4aa12[];
extern  VTBL_ENTRY _ZTV4aa12[];
extern Class_Descriptor cd_bb12;
extern VTBL_ENTRY _ZTI4bb12[];
extern  VTBL_ENTRY _ZTV4bb12[];
static Base_Class bases_ee12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_bb12,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ee12[];
extern void _ZN4ee123fooEv();
extern void ABISELECT(_ZThn16_N4ee123fooEv,_ZThn8_N4ee123fooEv)();
static  VTBL_ENTRY vtc_ee12[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4ee12[0]),
  (VTBL_ENTRY)&_ZN4ee123fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ee12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4ee123fooEv,_ZThn8_N4ee123fooEv),
};
extern VTBL_ENTRY _ZTI4ee12[];
extern  VTBL_ENTRY _ZTV4ee12[];
Class_Descriptor cd_ee12 = {  "ee12", // class name
  bases_ee12, 2,
  &(vtc_ee12[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ee12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee12),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff12  : virtual cc12 , virtual dd12 {
  int f;
   ff12(const ABISELECT(__tsi64,int) *const *); // _ZN4ff12C2Ev
  virtual void  foo(); // _ZN4ff123fooEv
  ~ff12(); // tgen
  ff12(); // tgen
};
//SIG(-1 ff12) C1{ VBC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ff12 ::ff12(const ABISELECT(__tsi64,int) *const *){}
void  ff12 ::foo(){vfunc_called(this, "_ZN4ff123fooEv");}
ff12 ::~ff12(){ note_dtor("ff12", this);} // tgen
ff12 ::ff12(){ note_ctor("ff12", this);} // tgen

static void Test_ff12()
{
  extern Class_Descriptor cd_ff12;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_ff12, buf);
    ff12 *dp, &lv = *(dp=new (buf) ff12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(ff12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff12)");
    check_base_class_offset(lv, (cc12*), ABISELECT(16,8), "ff12");
    check_base_class_offset(lv, (dd12*), ABISELECT(32,16), "ff12");
    check_field_offset(lv, f, ABISELECT(8,4), "ff12.f");
    test_class_info(&lv, &cd_ff12);
    dp->~ff12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff12(Test_ff12, "ff12", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN4ff12C1Ev();
extern void _ZN4ff12D1Ev();
Name_Map name_map_ff12[] = {
  NSPAIR(_ZN4ff12C1Ev),
  NSPAIR(_ZN4ff12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc12;
extern VTBL_ENTRY _ZTI4cc12[];
extern  VTBL_ENTRY _ZTV4cc12[];
extern Class_Descriptor cd_dd12;
extern VTBL_ENTRY _ZTI4dd12[];
extern  VTBL_ENTRY _ZTV4dd12[];
static Base_Class bases_ff12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc12,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_dd12,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ff12[];
extern void _ZN4ff123fooEv();
extern void ABISELECT(_ZTv0_n24_N4ff123fooEv,_ZTv0_n12_N4ff123fooEv)();
extern void ABISELECT(_ZThn16_N4ff123fooEv,_ZThn8_N4ff123fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4ff123fooEv,_ZTv0_n12_N4ff123fooEv)();
extern void ABISELECT(_ZThn32_N4ff123fooEv,_ZThn16_N4ff123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff12[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI4ff12[0]),
  (VTBL_ENTRY)&_ZN4ff123fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ff12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff123fooEv,_ZTv0_n12_N4ff123fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI4ff12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff123fooEv,_ZTv0_n12_N4ff123fooEv),
};
extern VTBL_ENTRY _ZTV4ff12[];
static  VTT_ENTRY vtt_ff12[] = {
  {&(_ZTV4ff12[4]),  4,13},
  {&(_ZTV4ff12[8]),  8,13},
  {&(_ZTV4ff12[12]),  12,13},
};
extern VTBL_ENTRY _ZTI4ff12[];
extern  VTBL_ENTRY _ZTV4ff12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff12[];
static VTBL_ENTRY alt_thunk_names29[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff123fooEv,_ZTv0_n12_N4ff123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ff123fooEv,_ZThn16_N4ff123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff123fooEv,_ZThn8_N4ff123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff12 = {  "ff12", // class name
  bases_ff12, 2,
  &(vtc_ff12[0]), // expected_vtbl_contents
  &(vtt_ff12[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI4ff12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff12),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ff12),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names29,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg12  : ee12 , ff12 {
  int g;
   gg12(const ABISELECT(__tsi64,int) *const *); // _ZN4gg12C2Ev
  virtual void  foo(); // _ZN4gg123fooEv
  ~gg12(); // tgen
  gg12(); // tgen
};
//SIG(1 gg12) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ VBC6{ v1 Fi} VBC7{ v1 Fi} v1 Fi} v1 Fi}


 gg12 ::gg12(const ABISELECT(__tsi64,int) *const *){}
void  gg12 ::foo(){vfunc_called(this, "_ZN4gg123fooEv");}
gg12 ::~gg12(){ note_dtor("gg12", this);} // tgen
gg12 ::gg12(){ note_ctor("gg12", this);} // tgen

static void Test_gg12()
{
  extern Class_Descriptor cd_gg12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,13)];
    init_test(&cd_gg12, buf);
    gg12 *dp, &lv = *(dp=new (buf) gg12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,48), "sizeof(gg12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg12)");
    check_base_class_offset(lv, (aa12*)(ee12*), 0, "gg12");
    check_base_class_offset(lv, (bb12*)(ee12*), ABISELECT(16,8), "gg12");
    check_base_class_offset(lv, (ee12*), 0, "gg12");
    check_base_class_offset(lv, (cc12*)(ff12*), ABISELECT(48,32), "gg12");
    check_base_class_offset(lv, (dd12*)(ff12*), ABISELECT(64,40), "gg12");
    check_base_class_offset(lv, (ff12*), ABISELECT(32,20), "gg12");
    check_field_offset(lv, g, ABISELECT(44,28), "gg12.g");
    test_class_info(&lv, &cd_gg12);
    dp->~gg12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg12(Test_gg12, "gg12", ABISELECT(80,48));

#else // __cplusplus

extern void _ZN4gg12C1Ev();
extern void _ZN4gg12D1Ev();
Name_Map name_map_gg12[] = {
  NSPAIR(_ZN4gg12C1Ev),
  NSPAIR(_ZN4gg12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa12;
extern VTBL_ENTRY _ZTI4aa12[];
extern  VTBL_ENTRY _ZTV4aa12[];
extern Class_Descriptor cd_bb12;
extern VTBL_ENTRY _ZTI4bb12[];
extern  VTBL_ENTRY _ZTV4bb12[];
extern Class_Descriptor cd_ee12;
extern VTBL_ENTRY _ZTI4ee12[];
extern  VTBL_ENTRY _ZTV4ee12[];
extern Class_Descriptor cd_cc12;
extern VTBL_ENTRY _ZTI4cc12[];
extern  VTBL_ENTRY _ZTV4cc12[];
extern Class_Descriptor cd_dd12;
extern VTBL_ENTRY _ZTI4dd12[];
extern  VTBL_ENTRY _ZTV4dd12[];
extern Class_Descriptor cd_ff12;
extern VTBL_ENTRY _ZTI4ff12[];
extern  VTBL_ENTRY _ZTV4ff12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff12[];
static Base_Class bases_gg12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_bb12,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_ee12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc12,    ABISELECT(48,32), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_dd12,    ABISELECT(64,40), //bcp->offset
    17, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_ff12,    ABISELECT(32,20), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4gg12[];
extern void _ZN4gg123fooEv();
extern void ABISELECT(_ZThn16_N4gg123fooEv,_ZThn8_N4gg123fooEv)();
extern void ABISELECT(_ZThn32_N4gg123fooEv,_ZThn20_N4gg123fooEv)();
extern void ABISELECT(_ZTv0_n24_N4gg123fooEv,_ZTv0_n12_N4gg123fooEv)();
extern void ABISELECT(_ZThn48_N4gg123fooEv,_ZThn32_N4gg123fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg123fooEv,_ZTv0_n12_N4gg123fooEv)();
extern void ABISELECT(_ZThn64_N4gg123fooEv,_ZThn40_N4gg123fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg12[] = {
  ABISELECT(64,40),
  ABISELECT(48,32),
  0,
  (VTBL_ENTRY)&(_ZTI4gg12[0]),
  (VTBL_ENTRY)&_ZN4gg123fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4gg12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4gg123fooEv,_ZThn8_N4gg123fooEv),
  ABISELECT(32,20),
  ABISELECT(16,12),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI4gg12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N4gg123fooEv,_ZThn20_N4gg123fooEv),
  ABISELECT(-48,-32),
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI4gg12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg123fooEv,_ZTv0_n12_N4gg123fooEv),
  ABISELECT(-64,-40),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI4gg12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg123fooEv,_ZTv0_n12_N4gg123fooEv),
};
extern VTBL_ENTRY _ZTV4gg12[];
extern void _ZN4ff123fooEv();
static  VTBL_ENTRY _tg__ZTV4ff12__4gg12[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff12[0]),
  (VTBL_ENTRY)&_ZN4ff123fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ff123fooEv,_ZTv0_n12_N4ff123fooEv)();
extern void ABISELECT(_ZThn16_N4ff123fooEv,_ZThn12_N4ff123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4cc12__4ff12__4gg12[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff123fooEv,_ZTv0_n12_N4ff123fooEv),
};
extern void ABISELECT(_ZTv0_n24_N4ff123fooEv,_ZTv0_n12_N4ff123fooEv)();
extern void ABISELECT(_ZThn32_N4ff123fooEv,_ZThn20_N4ff123fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4dd12__4ff12__4gg12[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI4ff12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff123fooEv,_ZTv0_n12_N4ff123fooEv),
};
static  VTT_ENTRY vtt_gg12[] = {
  {&(_ZTV4gg12[4]),  4,21},
  {&(_tg__ZTV4ff12__4gg12[4]),  4,5},
  {&(_tg__ZTV4cc12__4ff12__4gg12[3]),  3,4},
  {&(_tg__ZTV4dd12__4ff12__4gg12[3]),  3,4},
  {&(_ZTV4gg12[12]),  12,21},
  {&(_ZTV4gg12[16]),  16,21},
  {&(_ZTV4gg12[20]),  20,21},
};
extern VTBL_ENTRY _ZTI4gg12[];
extern  VTBL_ENTRY _ZTV4gg12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg12[];
static VTBL_ENTRY alt_thunk_names30[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff123fooEv,_ZTv0_n12_N4ff123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ff123fooEv,_ZThn20_N4ff123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff123fooEv,_ZThn12_N4ff123fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg123fooEv,_ZTv0_n12_N4gg123fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N4gg123fooEv,_ZThn40_N4gg123fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N4gg123fooEv,_ZThn32_N4gg123fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg12 = {  "gg12", // class name
  bases_gg12, 6,
  &(vtc_gg12[0]), // expected_vtbl_contents
  &(vtt_gg12[0]), // expected_vtt_contents
  ABISELECT(80,48), // object size
  NSPAIRA(_ZTI4gg12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg12),21, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg12),7, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names30,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa13  {
  int a;
   aa13(); // _ZN4aa13C1Ev
  virtual void  foo(); // _ZN4aa133fooEv
  ~aa13(); // tgen
};
//SIG(-1 aa13) C1{ v1 Fi}


 aa13 ::aa13(){ note_ctor("aa13", this);}
void  aa13 ::foo(){vfunc_called(this, "_ZN4aa133fooEv");}
aa13 ::~aa13(){ note_dtor("aa13", this);} // tgen

static void Test_aa13()
{
  extern Class_Descriptor cd_aa13;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa13, buf);
    aa13 *dp, &lv = *(dp=new (buf) aa13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa13)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa13.a");
    test_class_info(&lv, &cd_aa13);
    dp->~aa13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa13(Test_aa13, "aa13", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa13C1Ev();
extern void _ZN4aa13D1Ev();
Name_Map name_map_aa13[] = {
  NSPAIR(_ZN4aa13C1Ev),
  NSPAIR(_ZN4aa13D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa13[];
extern void _ZN4aa133fooEv();
static  VTBL_ENTRY vtc_aa13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa13[0]),
  (VTBL_ENTRY)&_ZN4aa133fooEv,
};
extern VTBL_ENTRY _ZTI4aa13[];
extern  VTBL_ENTRY _ZTV4aa13[];
Class_Descriptor cd_aa13 = {  "aa13", // class name
  0,0,//no base classes
  &(vtc_aa13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa13),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa13),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb13  {
  int b;
   bb13(); // _ZN4bb13C1Ev
  virtual void  foo(); // _ZN4bb133fooEv
  ~bb13(); // tgen
};
//SIG(-1 bb13) C1{ v1 Fi}


 bb13 ::bb13(){ note_ctor("bb13", this);}
void  bb13 ::foo(){vfunc_called(this, "_ZN4bb133fooEv");}
bb13 ::~bb13(){ note_dtor("bb13", this);} // tgen

static void Test_bb13()
{
  extern Class_Descriptor cd_bb13;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb13, buf);
    bb13 *dp, &lv = *(dp=new (buf) bb13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb13)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb13.b");
    test_class_info(&lv, &cd_bb13);
    dp->~bb13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb13(Test_bb13, "bb13", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb13C1Ev();
extern void _ZN4bb13D1Ev();
Name_Map name_map_bb13[] = {
  NSPAIR(_ZN4bb13C1Ev),
  NSPAIR(_ZN4bb13D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb13[];
extern void _ZN4bb133fooEv();
static  VTBL_ENTRY vtc_bb13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb13[0]),
  (VTBL_ENTRY)&_ZN4bb133fooEv,
};
extern VTBL_ENTRY _ZTI4bb13[];
extern  VTBL_ENTRY _ZTV4bb13[];
Class_Descriptor cd_bb13 = {  "bb13", // class name
  0,0,//no base classes
  &(vtc_bb13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb13),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb13),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc13  {
  int c;
   cc13(); // _ZN4cc13C1Ev
  virtual void  foo(); // _ZN4cc133fooEv
  ~cc13(); // tgen
};
//SIG(-1 cc13) C1{ v1 Fi}


 cc13 ::cc13(){ note_ctor("cc13", this);}
void  cc13 ::foo(){vfunc_called(this, "_ZN4cc133fooEv");}
cc13 ::~cc13(){ note_dtor("cc13", this);} // tgen

static void Test_cc13()
{
  extern Class_Descriptor cd_cc13;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc13, buf);
    cc13 *dp, &lv = *(dp=new (buf) cc13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc13)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc13.c");
    test_class_info(&lv, &cd_cc13);
    dp->~cc13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc13(Test_cc13, "cc13", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc13C1Ev();
extern void _ZN4cc13D1Ev();
Name_Map name_map_cc13[] = {
  NSPAIR(_ZN4cc13C1Ev),
  NSPAIR(_ZN4cc13D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc13[];
extern void _ZN4cc133fooEv();
static  VTBL_ENTRY vtc_cc13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc13[0]),
  (VTBL_ENTRY)&_ZN4cc133fooEv,
};
extern VTBL_ENTRY _ZTI4cc13[];
extern  VTBL_ENTRY _ZTV4cc13[];
Class_Descriptor cd_cc13 = {  "cc13", // class name
  0,0,//no base classes
  &(vtc_cc13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc13),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc13),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd13  {
  int d;
   dd13(); // _ZN4dd13C1Ev
  virtual void  foo(); // _ZN4dd133fooEv
  ~dd13(); // tgen
};
//SIG(-1 dd13) C1{ v1 Fi}


 dd13 ::dd13(){ note_ctor("dd13", this);}
void  dd13 ::foo(){vfunc_called(this, "_ZN4dd133fooEv");}
dd13 ::~dd13(){ note_dtor("dd13", this);} // tgen

static void Test_dd13()
{
  extern Class_Descriptor cd_dd13;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd13, buf);
    dd13 *dp, &lv = *(dp=new (buf) dd13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd13)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd13.d");
    test_class_info(&lv, &cd_dd13);
    dp->~dd13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd13(Test_dd13, "dd13", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd13C1Ev();
extern void _ZN4dd13D1Ev();
Name_Map name_map_dd13[] = {
  NSPAIR(_ZN4dd13C1Ev),
  NSPAIR(_ZN4dd13D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd13[];
extern void _ZN4dd133fooEv();
static  VTBL_ENTRY vtc_dd13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd13[0]),
  (VTBL_ENTRY)&_ZN4dd133fooEv,
};
extern VTBL_ENTRY _ZTI4dd13[];
extern  VTBL_ENTRY _ZTV4dd13[];
Class_Descriptor cd_dd13 = {  "dd13", // class name
  0,0,//no base classes
  &(vtc_dd13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd13),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd13),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee13  : virtual aa13 , bb13 {
  int e;
   ee13(const ABISELECT(__tsi64,int) *const *); // _ZN4ee13C2Ev
  virtual void  foo(); // _ZN4ee133fooEv
  ~ee13(); // tgen
  ee13(); // tgen
};
//SIG(-1 ee13) C1{ VBC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ee13 ::ee13(const ABISELECT(__tsi64,int) *const *){}
void  ee13 ::foo(){vfunc_called(this, "_ZN4ee133fooEv");}
ee13 ::~ee13(){ note_dtor("ee13", this);} // tgen
ee13 ::ee13(){ note_ctor("ee13", this);} // tgen

static void Test_ee13()
{
  extern Class_Descriptor cd_ee13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee13, buf);
    ee13 *dp, &lv = *(dp=new (buf) ee13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee13)");
    check_base_class_offset(lv, (aa13*), ABISELECT(16,12), "ee13");
    check_base_class_offset(lv, (bb13*), 0, "ee13");
    check_field_offset(lv, e, ABISELECT(12,8), "ee13.e");
    test_class_info(&lv, &cd_ee13);
    dp->~ee13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee13(Test_ee13, "ee13", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ee13C1Ev();
extern void _ZN4ee13D1Ev();
Name_Map name_map_ee13[] = {
  NSPAIR(_ZN4ee13C1Ev),
  NSPAIR(_ZN4ee13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa13;
extern VTBL_ENTRY _ZTI4aa13[];
extern  VTBL_ENTRY _ZTV4aa13[];
extern Class_Descriptor cd_bb13;
extern VTBL_ENTRY _ZTI4bb13[];
extern  VTBL_ENTRY _ZTV4bb13[];
static Base_Class bases_ee13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa13,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_bb13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ee13[];
extern void _ZN4ee133fooEv();
extern void ABISELECT(_ZTv0_n24_N4ee133fooEv,_ZTv0_n12_N4ee133fooEv)();
extern void ABISELECT(_ZThn16_N4ee133fooEv,_ZThn12_N4ee133fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee13[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee13[0]),
  (VTBL_ENTRY)&_ZN4ee133fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee133fooEv,_ZTv0_n12_N4ee133fooEv),
};
extern VTBL_ENTRY _ZTV4ee13[];
static  VTT_ENTRY vtt_ee13[] = {
  {&(_ZTV4ee13[3]),  3,8},
  {&(_ZTV4ee13[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ee13[];
extern  VTBL_ENTRY _ZTV4ee13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee13[];
static VTBL_ENTRY alt_thunk_names31[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee133fooEv,_ZTv0_n12_N4ee133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee133fooEv,_ZThn12_N4ee133fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee13 = {  "ee13", // class name
  bases_ee13, 2,
  &(vtc_ee13[0]), // expected_vtbl_contents
  &(vtt_ee13[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ee13),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee13),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ee13),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names31,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff13  : virtual cc13 , virtual dd13 {
  int f;
   ff13(const ABISELECT(__tsi64,int) *const *); // _ZN4ff13C2Ev
  virtual void  foo(); // _ZN4ff133fooEv
  ~ff13(); // tgen
  ff13(); // tgen
};
//SIG(-1 ff13) C1{ VBC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ff13 ::ff13(const ABISELECT(__tsi64,int) *const *){}
void  ff13 ::foo(){vfunc_called(this, "_ZN4ff133fooEv");}
ff13 ::~ff13(){ note_dtor("ff13", this);} // tgen
ff13 ::ff13(){ note_ctor("ff13", this);} // tgen

static void Test_ff13()
{
  extern Class_Descriptor cd_ff13;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_ff13, buf);
    ff13 *dp, &lv = *(dp=new (buf) ff13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(ff13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff13)");
    check_base_class_offset(lv, (cc13*), ABISELECT(16,8), "ff13");
    check_base_class_offset(lv, (dd13*), ABISELECT(32,16), "ff13");
    check_field_offset(lv, f, ABISELECT(8,4), "ff13.f");
    test_class_info(&lv, &cd_ff13);
    dp->~ff13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff13(Test_ff13, "ff13", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN4ff13C1Ev();
extern void _ZN4ff13D1Ev();
Name_Map name_map_ff13[] = {
  NSPAIR(_ZN4ff13C1Ev),
  NSPAIR(_ZN4ff13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc13;
extern VTBL_ENTRY _ZTI4cc13[];
extern  VTBL_ENTRY _ZTV4cc13[];
extern Class_Descriptor cd_dd13;
extern VTBL_ENTRY _ZTI4dd13[];
extern  VTBL_ENTRY _ZTV4dd13[];
static Base_Class bases_ff13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc13,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_dd13,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ff13[];
extern void _ZN4ff133fooEv();
extern void ABISELECT(_ZTv0_n24_N4ff133fooEv,_ZTv0_n12_N4ff133fooEv)();
extern void ABISELECT(_ZThn16_N4ff133fooEv,_ZThn8_N4ff133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4ff133fooEv,_ZTv0_n12_N4ff133fooEv)();
extern void ABISELECT(_ZThn32_N4ff133fooEv,_ZThn16_N4ff133fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff13[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI4ff13[0]),
  (VTBL_ENTRY)&_ZN4ff133fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ff13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff133fooEv,_ZTv0_n12_N4ff133fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI4ff13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff133fooEv,_ZTv0_n12_N4ff133fooEv),
};
extern VTBL_ENTRY _ZTV4ff13[];
static  VTT_ENTRY vtt_ff13[] = {
  {&(_ZTV4ff13[4]),  4,13},
  {&(_ZTV4ff13[8]),  8,13},
  {&(_ZTV4ff13[12]),  12,13},
};
extern VTBL_ENTRY _ZTI4ff13[];
extern  VTBL_ENTRY _ZTV4ff13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff13[];
static VTBL_ENTRY alt_thunk_names32[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff133fooEv,_ZTv0_n12_N4ff133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ff133fooEv,_ZThn16_N4ff133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff133fooEv,_ZThn8_N4ff133fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff13 = {  "ff13", // class name
  bases_ff13, 2,
  &(vtc_ff13[0]), // expected_vtbl_contents
  &(vtt_ff13[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI4ff13),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff13),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ff13),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names32,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg13  : ee13 , ff13 {
  int g;
   gg13(const ABISELECT(__tsi64,int) *const *); // _ZN4gg13C2Ev
  virtual void  foo(); // _ZN4gg133fooEv
  ~gg13(); // tgen
  gg13(); // tgen
};
//SIG(1 gg13) C1{ BC2{ VBC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ VBC6{ v1 Fi} VBC7{ v1 Fi} v1 Fi} v1 Fi}


 gg13 ::gg13(const ABISELECT(__tsi64,int) *const *){}
void  gg13 ::foo(){vfunc_called(this, "_ZN4gg133fooEv");}
gg13 ::~gg13(){ note_dtor("gg13", this);} // tgen
gg13 ::gg13(){ note_ctor("gg13", this);} // tgen

static void Test_gg13()
{
  extern Class_Descriptor cd_gg13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,13)];
    init_test(&cd_gg13, buf);
    gg13 *dp, &lv = *(dp=new (buf) gg13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,48), "sizeof(gg13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg13)");
    check_base_class_offset(lv, (aa13*)(ee13*), ABISELECT(32,24), "gg13");
    check_base_class_offset(lv, (bb13*)(ee13*), 0, "gg13");
    check_base_class_offset(lv, (ee13*), 0, "gg13");
    check_base_class_offset(lv, (cc13*)(ff13*), ABISELECT(48,32), "gg13");
    check_base_class_offset(lv, (dd13*)(ff13*), ABISELECT(64,40), "gg13");
    check_base_class_offset(lv, (ff13*), ABISELECT(16,12), "gg13");
    check_field_offset(lv, g, ABISELECT(28,20), "gg13.g");
    test_class_info(&lv, &cd_gg13);
    dp->~gg13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg13(Test_gg13, "gg13", ABISELECT(80,48));

#else // __cplusplus

extern void _ZN4gg13C1Ev();
extern void _ZN4gg13D1Ev();
Name_Map name_map_gg13[] = {
  NSPAIR(_ZN4gg13C1Ev),
  NSPAIR(_ZN4gg13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa13;
extern VTBL_ENTRY _ZTI4aa13[];
extern  VTBL_ENTRY _ZTV4aa13[];
extern Class_Descriptor cd_bb13;
extern VTBL_ENTRY _ZTI4bb13[];
extern  VTBL_ENTRY _ZTV4bb13[];
extern Class_Descriptor cd_ee13;
extern VTBL_ENTRY _ZTI4ee13[];
extern  VTBL_ENTRY _ZTV4ee13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee13[];
extern Class_Descriptor cd_cc13;
extern VTBL_ENTRY _ZTI4cc13[];
extern  VTBL_ENTRY _ZTV4cc13[];
extern Class_Descriptor cd_dd13;
extern VTBL_ENTRY _ZTI4dd13[];
extern  VTBL_ENTRY _ZTV4dd13[];
extern Class_Descriptor cd_ff13;
extern VTBL_ENTRY _ZTI4ff13[];
extern  VTBL_ENTRY _ZTV4ff13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff13[];
static Base_Class bases_gg13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa13,    ABISELECT(32,24), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_bb13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_ee13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc13,    ABISELECT(48,32), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_dd13,    ABISELECT(64,40), //bcp->offset
    19, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_ff13,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4gg13[];
extern void _ZN4gg133fooEv();
extern void ABISELECT(_ZThn16_N4gg133fooEv,_ZThn12_N4gg133fooEv)();
extern void ABISELECT(_ZTv0_n24_N4gg133fooEv,_ZTv0_n12_N4gg133fooEv)();
extern void ABISELECT(_ZThn32_N4gg133fooEv,_ZThn24_N4gg133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg133fooEv,_ZTv0_n12_N4gg133fooEv)();
extern void ABISELECT(_ZThn48_N4gg133fooEv,_ZThn32_N4gg133fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg133fooEv,_ZTv0_n12_N4gg133fooEv)();
extern void ABISELECT(_ZThn64_N4gg133fooEv,_ZThn40_N4gg133fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg13[] = {
  ABISELECT(64,40),
  ABISELECT(48,32),
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI4gg13[0]),
  (VTBL_ENTRY)&_ZN4gg133fooEv,
  ABISELECT(48,28),
  ABISELECT(32,20),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4gg13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4gg133fooEv,_ZThn12_N4gg133fooEv),
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI4gg13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg133fooEv,_ZTv0_n12_N4gg133fooEv),
  ABISELECT(-48,-32),
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI4gg13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg133fooEv,_ZTv0_n12_N4gg133fooEv),
  ABISELECT(-64,-40),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI4gg13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg133fooEv,_ZTv0_n12_N4gg133fooEv),
};
extern VTBL_ENTRY _ZTV4gg13[];
extern void _ZN4ee133fooEv();
static  VTBL_ENTRY _tg__ZTV4ee13__4gg13[] = {
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI4ee13[0]),
  (VTBL_ENTRY)&_ZN4ee133fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ee133fooEv,_ZTv0_n12_N4ee133fooEv)();
extern void ABISELECT(_ZThn32_N4ee133fooEv,_ZThn24_N4ee133fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4aa13__4ee13__4gg13[] = {
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI4ee13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee133fooEv,_ZTv0_n12_N4ee133fooEv),
};
extern void _ZN4ff133fooEv();
static  VTBL_ENTRY _tg__ZTV4ff13__4gg13[] = {
  ABISELECT(48,28),
  ABISELECT(32,20),
  0,
  (VTBL_ENTRY)&(_ZTI4ff13[0]),
  (VTBL_ENTRY)&_ZN4ff133fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ff133fooEv,_ZTv0_n12_N4ff133fooEv)();
extern void ABISELECT(_ZThn32_N4ff133fooEv,_ZThn20_N4ff133fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4cc13__4ff13__4gg13[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI4ff13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff133fooEv,_ZTv0_n12_N4ff133fooEv),
};
extern void ABISELECT(_ZTv0_n24_N4ff133fooEv,_ZTv0_n12_N4ff133fooEv)();
extern void ABISELECT(_ZThn48_N4ff133fooEv,_ZThn28_N4ff133fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4dd13__4ff13__4gg13[] = {
  ABISELECT(-48,-28),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI4ff13[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff133fooEv,_ZTv0_n12_N4ff133fooEv),
};
static  VTT_ENTRY vtt_gg13[] = {
  {&(_ZTV4gg13[5]),  5,23},
  {&(_tg__ZTV4ee13__4gg13[3]),  3,4},
  {&(_tg__ZTV4aa13__4ee13__4gg13[3]),  3,4},
  {&(_tg__ZTV4ff13__4gg13[4]),  4,5},
  {&(_tg__ZTV4cc13__4ff13__4gg13[3]),  3,4},
  {&(_tg__ZTV4dd13__4ff13__4gg13[3]),  3,4},
  {&(_ZTV4gg13[14]),  14,23},
  {&(_ZTV4gg13[10]),  10,23},
  {&(_ZTV4gg13[18]),  18,23},
  {&(_ZTV4gg13[22]),  22,23},
};
extern VTBL_ENTRY _ZTI4gg13[];
extern  VTBL_ENTRY _ZTV4gg13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg13[];
static VTBL_ENTRY alt_thunk_names33[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff133fooEv,_ZTv0_n12_N4ff133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N4ff133fooEv,_ZThn28_N4ff133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ff133fooEv,_ZThn20_N4ff133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee133fooEv,_ZTv0_n12_N4ee133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ee133fooEv,_ZThn24_N4ee133fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg133fooEv,_ZTv0_n12_N4gg133fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N4gg133fooEv,_ZThn40_N4gg133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N4gg133fooEv,_ZThn32_N4gg133fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4gg133fooEv,_ZThn24_N4gg133fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg13 = {  "gg13", // class name
  bases_gg13, 6,
  &(vtc_gg13[0]), // expected_vtbl_contents
  &(vtt_gg13[0]), // expected_vtt_contents
  ABISELECT(80,48), // object size
  NSPAIRA(_ZTI4gg13),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg13),23, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg13),10, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names33,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa14  {
  int a;
   aa14(); // _ZN4aa14C1Ev
  virtual void  foo(); // _ZN4aa143fooEv
  ~aa14(); // tgen
};
//SIG(-1 aa14) C1{ v1 Fi}


 aa14 ::aa14(){ note_ctor("aa14", this);}
void  aa14 ::foo(){vfunc_called(this, "_ZN4aa143fooEv");}
aa14 ::~aa14(){ note_dtor("aa14", this);} // tgen

static void Test_aa14()
{
  extern Class_Descriptor cd_aa14;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa14, buf);
    aa14 *dp, &lv = *(dp=new (buf) aa14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa14)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa14.a");
    test_class_info(&lv, &cd_aa14);
    dp->~aa14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa14(Test_aa14, "aa14", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa14C1Ev();
extern void _ZN4aa14D1Ev();
Name_Map name_map_aa14[] = {
  NSPAIR(_ZN4aa14C1Ev),
  NSPAIR(_ZN4aa14D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa14[];
extern void _ZN4aa143fooEv();
static  VTBL_ENTRY vtc_aa14[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa14[0]),
  (VTBL_ENTRY)&_ZN4aa143fooEv,
};
extern VTBL_ENTRY _ZTI4aa14[];
extern  VTBL_ENTRY _ZTV4aa14[];
Class_Descriptor cd_aa14 = {  "aa14", // class name
  0,0,//no base classes
  &(vtc_aa14[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa14),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa14),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb14  {
  int b;
   bb14(); // _ZN4bb14C1Ev
  virtual void  foo(); // _ZN4bb143fooEv
  ~bb14(); // tgen
};
//SIG(-1 bb14) C1{ v1 Fi}


 bb14 ::bb14(){ note_ctor("bb14", this);}
void  bb14 ::foo(){vfunc_called(this, "_ZN4bb143fooEv");}
bb14 ::~bb14(){ note_dtor("bb14", this);} // tgen

static void Test_bb14()
{
  extern Class_Descriptor cd_bb14;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb14, buf);
    bb14 *dp, &lv = *(dp=new (buf) bb14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb14)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb14.b");
    test_class_info(&lv, &cd_bb14);
    dp->~bb14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb14(Test_bb14, "bb14", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb14C1Ev();
extern void _ZN4bb14D1Ev();
Name_Map name_map_bb14[] = {
  NSPAIR(_ZN4bb14C1Ev),
  NSPAIR(_ZN4bb14D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb14[];
extern void _ZN4bb143fooEv();
static  VTBL_ENTRY vtc_bb14[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb14[0]),
  (VTBL_ENTRY)&_ZN4bb143fooEv,
};
extern VTBL_ENTRY _ZTI4bb14[];
extern  VTBL_ENTRY _ZTV4bb14[];
Class_Descriptor cd_bb14 = {  "bb14", // class name
  0,0,//no base classes
  &(vtc_bb14[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb14),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb14),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc14  {
  int c;
   cc14(); // _ZN4cc14C1Ev
  virtual void  foo(); // _ZN4cc143fooEv
  ~cc14(); // tgen
};
//SIG(-1 cc14) C1{ v1 Fi}


 cc14 ::cc14(){ note_ctor("cc14", this);}
void  cc14 ::foo(){vfunc_called(this, "_ZN4cc143fooEv");}
cc14 ::~cc14(){ note_dtor("cc14", this);} // tgen

static void Test_cc14()
{
  extern Class_Descriptor cd_cc14;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc14, buf);
    cc14 *dp, &lv = *(dp=new (buf) cc14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc14)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc14.c");
    test_class_info(&lv, &cd_cc14);
    dp->~cc14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc14(Test_cc14, "cc14", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc14C1Ev();
extern void _ZN4cc14D1Ev();
Name_Map name_map_cc14[] = {
  NSPAIR(_ZN4cc14C1Ev),
  NSPAIR(_ZN4cc14D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc14[];
extern void _ZN4cc143fooEv();
static  VTBL_ENTRY vtc_cc14[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc14[0]),
  (VTBL_ENTRY)&_ZN4cc143fooEv,
};
extern VTBL_ENTRY _ZTI4cc14[];
extern  VTBL_ENTRY _ZTV4cc14[];
Class_Descriptor cd_cc14 = {  "cc14", // class name
  0,0,//no base classes
  &(vtc_cc14[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc14),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc14),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd14  {
  int d;
   dd14(); // _ZN4dd14C1Ev
  virtual void  foo(); // _ZN4dd143fooEv
  ~dd14(); // tgen
};
//SIG(-1 dd14) C1{ v1 Fi}


 dd14 ::dd14(){ note_ctor("dd14", this);}
void  dd14 ::foo(){vfunc_called(this, "_ZN4dd143fooEv");}
dd14 ::~dd14(){ note_dtor("dd14", this);} // tgen

static void Test_dd14()
{
  extern Class_Descriptor cd_dd14;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd14, buf);
    dd14 *dp, &lv = *(dp=new (buf) dd14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd14)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd14.d");
    test_class_info(&lv, &cd_dd14);
    dp->~dd14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd14(Test_dd14, "dd14", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd14C1Ev();
extern void _ZN4dd14D1Ev();
Name_Map name_map_dd14[] = {
  NSPAIR(_ZN4dd14C1Ev),
  NSPAIR(_ZN4dd14D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd14[];
extern void _ZN4dd143fooEv();
static  VTBL_ENTRY vtc_dd14[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd14[0]),
  (VTBL_ENTRY)&_ZN4dd143fooEv,
};
extern VTBL_ENTRY _ZTI4dd14[];
extern  VTBL_ENTRY _ZTV4dd14[];
Class_Descriptor cd_dd14 = {  "dd14", // class name
  0,0,//no base classes
  &(vtc_dd14[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd14),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd14),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee14  : aa14 , virtual bb14 {
  int e;
   ee14(const ABISELECT(__tsi64,int) *const *); // _ZN4ee14C2Ev
  virtual void  foo(); // _ZN4ee143fooEv
  ~ee14(); // tgen
  ee14(); // tgen
};
//SIG(-1 ee14) C1{ BC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ee14 ::ee14(const ABISELECT(__tsi64,int) *const *){}
void  ee14 ::foo(){vfunc_called(this, "_ZN4ee143fooEv");}
ee14 ::~ee14(){ note_dtor("ee14", this);} // tgen
ee14 ::ee14(){ note_ctor("ee14", this);} // tgen

static void Test_ee14()
{
  extern Class_Descriptor cd_ee14;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee14, buf);
    ee14 *dp, &lv = *(dp=new (buf) ee14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee14)");
    check_base_class_offset(lv, (aa14*), 0, "ee14");
    check_base_class_offset(lv, (bb14*), ABISELECT(16,12), "ee14");
    check_field_offset(lv, e, ABISELECT(12,8), "ee14.e");
    test_class_info(&lv, &cd_ee14);
    dp->~ee14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee14(Test_ee14, "ee14", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ee14C1Ev();
extern void _ZN4ee14D1Ev();
Name_Map name_map_ee14[] = {
  NSPAIR(_ZN4ee14C1Ev),
  NSPAIR(_ZN4ee14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa14;
extern VTBL_ENTRY _ZTI4aa14[];
extern  VTBL_ENTRY _ZTV4aa14[];
extern Class_Descriptor cd_bb14;
extern VTBL_ENTRY _ZTI4bb14[];
extern  VTBL_ENTRY _ZTV4bb14[];
static Base_Class bases_ee14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_bb14,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ee14[];
extern void _ZN4ee143fooEv();
extern void ABISELECT(_ZTv0_n24_N4ee143fooEv,_ZTv0_n12_N4ee143fooEv)();
extern void ABISELECT(_ZThn16_N4ee143fooEv,_ZThn12_N4ee143fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee14[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee14[0]),
  (VTBL_ENTRY)&_ZN4ee143fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee143fooEv,_ZTv0_n12_N4ee143fooEv),
};
extern VTBL_ENTRY _ZTV4ee14[];
static  VTT_ENTRY vtt_ee14[] = {
  {&(_ZTV4ee14[3]),  3,8},
  {&(_ZTV4ee14[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ee14[];
extern  VTBL_ENTRY _ZTV4ee14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee14[];
static VTBL_ENTRY alt_thunk_names34[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee143fooEv,_ZTv0_n12_N4ee143fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee143fooEv,_ZThn12_N4ee143fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee14 = {  "ee14", // class name
  bases_ee14, 2,
  &(vtc_ee14[0]), // expected_vtbl_contents
  &(vtt_ee14[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ee14),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee14),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ee14),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names34,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff14  : virtual cc14 , virtual dd14 {
  int f;
   ff14(const ABISELECT(__tsi64,int) *const *); // _ZN4ff14C2Ev
  virtual void  foo(); // _ZN4ff143fooEv
  ~ff14(); // tgen
  ff14(); // tgen
};
//SIG(-1 ff14) C1{ VBC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ff14 ::ff14(const ABISELECT(__tsi64,int) *const *){}
void  ff14 ::foo(){vfunc_called(this, "_ZN4ff143fooEv");}
ff14 ::~ff14(){ note_dtor("ff14", this);} // tgen
ff14 ::ff14(){ note_ctor("ff14", this);} // tgen

static void Test_ff14()
{
  extern Class_Descriptor cd_ff14;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_ff14, buf);
    ff14 *dp, &lv = *(dp=new (buf) ff14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(ff14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff14)");
    check_base_class_offset(lv, (cc14*), ABISELECT(16,8), "ff14");
    check_base_class_offset(lv, (dd14*), ABISELECT(32,16), "ff14");
    check_field_offset(lv, f, ABISELECT(8,4), "ff14.f");
    test_class_info(&lv, &cd_ff14);
    dp->~ff14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff14(Test_ff14, "ff14", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN4ff14C1Ev();
extern void _ZN4ff14D1Ev();
Name_Map name_map_ff14[] = {
  NSPAIR(_ZN4ff14C1Ev),
  NSPAIR(_ZN4ff14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc14;
extern VTBL_ENTRY _ZTI4cc14[];
extern  VTBL_ENTRY _ZTV4cc14[];
extern Class_Descriptor cd_dd14;
extern VTBL_ENTRY _ZTI4dd14[];
extern  VTBL_ENTRY _ZTV4dd14[];
static Base_Class bases_ff14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc14,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_dd14,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ff14[];
extern void _ZN4ff143fooEv();
extern void ABISELECT(_ZTv0_n24_N4ff143fooEv,_ZTv0_n12_N4ff143fooEv)();
extern void ABISELECT(_ZThn16_N4ff143fooEv,_ZThn8_N4ff143fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4ff143fooEv,_ZTv0_n12_N4ff143fooEv)();
extern void ABISELECT(_ZThn32_N4ff143fooEv,_ZThn16_N4ff143fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff14[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI4ff14[0]),
  (VTBL_ENTRY)&_ZN4ff143fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ff14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff143fooEv,_ZTv0_n12_N4ff143fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI4ff14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff143fooEv,_ZTv0_n12_N4ff143fooEv),
};
extern VTBL_ENTRY _ZTV4ff14[];
static  VTT_ENTRY vtt_ff14[] = {
  {&(_ZTV4ff14[4]),  4,13},
  {&(_ZTV4ff14[8]),  8,13},
  {&(_ZTV4ff14[12]),  12,13},
};
extern VTBL_ENTRY _ZTI4ff14[];
extern  VTBL_ENTRY _ZTV4ff14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff14[];
static VTBL_ENTRY alt_thunk_names35[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff143fooEv,_ZTv0_n12_N4ff143fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ff143fooEv,_ZThn16_N4ff143fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff143fooEv,_ZThn8_N4ff143fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff14 = {  "ff14", // class name
  bases_ff14, 2,
  &(vtc_ff14[0]), // expected_vtbl_contents
  &(vtt_ff14[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI4ff14),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff14),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ff14),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names35,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg14  : ee14 , ff14 {
  int g;
   gg14(const ABISELECT(__tsi64,int) *const *); // _ZN4gg14C2Ev
  virtual void  foo(); // _ZN4gg143fooEv
  ~gg14(); // tgen
  gg14(); // tgen
};
//SIG(1 gg14) C1{ BC2{ BC3{ v1 Fi} VBC4{ v1 Fi} v1 Fi} BC5{ VBC6{ v1 Fi} VBC7{ v1 Fi} v1 Fi} v1 Fi}


 gg14 ::gg14(const ABISELECT(__tsi64,int) *const *){}
void  gg14 ::foo(){vfunc_called(this, "_ZN4gg143fooEv");}
gg14 ::~gg14(){ note_dtor("gg14", this);} // tgen
gg14 ::gg14(){ note_ctor("gg14", this);} // tgen

static void Test_gg14()
{
  extern Class_Descriptor cd_gg14;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,13)];
    init_test(&cd_gg14, buf);
    gg14 *dp, &lv = *(dp=new (buf) gg14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,48), "sizeof(gg14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg14)");
    check_base_class_offset(lv, (aa14*)(ee14*), 0, "gg14");
    check_base_class_offset(lv, (bb14*)(ee14*), ABISELECT(32,24), "gg14");
    check_base_class_offset(lv, (ee14*), 0, "gg14");
    check_base_class_offset(lv, (cc14*)(ff14*), ABISELECT(48,32), "gg14");
    check_base_class_offset(lv, (dd14*)(ff14*), ABISELECT(64,40), "gg14");
    check_base_class_offset(lv, (ff14*), ABISELECT(16,12), "gg14");
    check_field_offset(lv, g, ABISELECT(28,20), "gg14.g");
    test_class_info(&lv, &cd_gg14);
    dp->~gg14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg14(Test_gg14, "gg14", ABISELECT(80,48));

#else // __cplusplus

extern void _ZN4gg14C1Ev();
extern void _ZN4gg14D1Ev();
Name_Map name_map_gg14[] = {
  NSPAIR(_ZN4gg14C1Ev),
  NSPAIR(_ZN4gg14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa14;
extern VTBL_ENTRY _ZTI4aa14[];
extern  VTBL_ENTRY _ZTV4aa14[];
extern Class_Descriptor cd_bb14;
extern VTBL_ENTRY _ZTI4bb14[];
extern  VTBL_ENTRY _ZTV4bb14[];
extern Class_Descriptor cd_ee14;
extern VTBL_ENTRY _ZTI4ee14[];
extern  VTBL_ENTRY _ZTV4ee14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee14[];
extern Class_Descriptor cd_cc14;
extern VTBL_ENTRY _ZTI4cc14[];
extern  VTBL_ENTRY _ZTV4cc14[];
extern Class_Descriptor cd_dd14;
extern VTBL_ENTRY _ZTI4dd14[];
extern  VTBL_ENTRY _ZTV4dd14[];
extern Class_Descriptor cd_ff14;
extern VTBL_ENTRY _ZTI4ff14[];
extern  VTBL_ENTRY _ZTV4ff14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff14[];
static Base_Class bases_gg14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_bb14,    ABISELECT(32,24), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_ee14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc14,    ABISELECT(48,32), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_dd14,    ABISELECT(64,40), //bcp->offset
    19, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_ff14,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4gg14[];
extern void _ZN4gg143fooEv();
extern void ABISELECT(_ZThn16_N4gg143fooEv,_ZThn12_N4gg143fooEv)();
extern void ABISELECT(_ZTv0_n24_N4gg143fooEv,_ZTv0_n12_N4gg143fooEv)();
extern void ABISELECT(_ZThn32_N4gg143fooEv,_ZThn24_N4gg143fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg143fooEv,_ZTv0_n12_N4gg143fooEv)();
extern void ABISELECT(_ZThn48_N4gg143fooEv,_ZThn32_N4gg143fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg143fooEv,_ZTv0_n12_N4gg143fooEv)();
extern void ABISELECT(_ZThn64_N4gg143fooEv,_ZThn40_N4gg143fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg14[] = {
  ABISELECT(64,40),
  ABISELECT(48,32),
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI4gg14[0]),
  (VTBL_ENTRY)&_ZN4gg143fooEv,
  ABISELECT(48,28),
  ABISELECT(32,20),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4gg14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4gg143fooEv,_ZThn12_N4gg143fooEv),
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI4gg14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg143fooEv,_ZTv0_n12_N4gg143fooEv),
  ABISELECT(-48,-32),
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI4gg14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg143fooEv,_ZTv0_n12_N4gg143fooEv),
  ABISELECT(-64,-40),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI4gg14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg143fooEv,_ZTv0_n12_N4gg143fooEv),
};
extern VTBL_ENTRY _ZTV4gg14[];
extern void _ZN4ee143fooEv();
static  VTBL_ENTRY _tg__ZTV4ee14__4gg14[] = {
  ABISELECT(32,24),
  0,
  (VTBL_ENTRY)&(_ZTI4ee14[0]),
  (VTBL_ENTRY)&_ZN4ee143fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ee143fooEv,_ZTv0_n12_N4ee143fooEv)();
extern void ABISELECT(_ZThn32_N4ee143fooEv,_ZThn24_N4ee143fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb14__4ee14__4gg14[] = {
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI4ee14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee143fooEv,_ZTv0_n12_N4ee143fooEv),
};
extern void _ZN4ff143fooEv();
static  VTBL_ENTRY _tg__ZTV4ff14__4gg14[] = {
  ABISELECT(48,28),
  ABISELECT(32,20),
  0,
  (VTBL_ENTRY)&(_ZTI4ff14[0]),
  (VTBL_ENTRY)&_ZN4ff143fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ff143fooEv,_ZTv0_n12_N4ff143fooEv)();
extern void ABISELECT(_ZThn32_N4ff143fooEv,_ZThn20_N4ff143fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4cc14__4ff14__4gg14[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI4ff14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff143fooEv,_ZTv0_n12_N4ff143fooEv),
};
extern void ABISELECT(_ZTv0_n24_N4ff143fooEv,_ZTv0_n12_N4ff143fooEv)();
extern void ABISELECT(_ZThn48_N4ff143fooEv,_ZThn28_N4ff143fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4dd14__4ff14__4gg14[] = {
  ABISELECT(-48,-28),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI4ff14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff143fooEv,_ZTv0_n12_N4ff143fooEv),
};
static  VTT_ENTRY vtt_gg14[] = {
  {&(_ZTV4gg14[5]),  5,23},
  {&(_tg__ZTV4ee14__4gg14[3]),  3,4},
  {&(_tg__ZTV4bb14__4ee14__4gg14[3]),  3,4},
  {&(_tg__ZTV4ff14__4gg14[4]),  4,5},
  {&(_tg__ZTV4cc14__4ff14__4gg14[3]),  3,4},
  {&(_tg__ZTV4dd14__4ff14__4gg14[3]),  3,4},
  {&(_ZTV4gg14[14]),  14,23},
  {&(_ZTV4gg14[10]),  10,23},
  {&(_ZTV4gg14[18]),  18,23},
  {&(_ZTV4gg14[22]),  22,23},
};
extern VTBL_ENTRY _ZTI4gg14[];
extern  VTBL_ENTRY _ZTV4gg14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg14[];
static VTBL_ENTRY alt_thunk_names36[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff143fooEv,_ZTv0_n12_N4ff143fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N4ff143fooEv,_ZThn28_N4ff143fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ff143fooEv,_ZThn20_N4ff143fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee143fooEv,_ZTv0_n12_N4ee143fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ee143fooEv,_ZThn24_N4ee143fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg143fooEv,_ZTv0_n12_N4gg143fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N4gg143fooEv,_ZThn40_N4gg143fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N4gg143fooEv,_ZThn32_N4gg143fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4gg143fooEv,_ZThn24_N4gg143fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg14 = {  "gg14", // class name
  bases_gg14, 6,
  &(vtc_gg14[0]), // expected_vtbl_contents
  &(vtt_gg14[0]), // expected_vtt_contents
  ABISELECT(80,48), // object size
  NSPAIRA(_ZTI4gg14),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg14),23, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg14),10, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names36,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa15  {
  int a;
   aa15(); // _ZN4aa15C1Ev
  virtual void  foo(); // _ZN4aa153fooEv
  ~aa15(); // tgen
};
//SIG(-1 aa15) C1{ v1 Fi}


 aa15 ::aa15(){ note_ctor("aa15", this);}
void  aa15 ::foo(){vfunc_called(this, "_ZN4aa153fooEv");}
aa15 ::~aa15(){ note_dtor("aa15", this);} // tgen

static void Test_aa15()
{
  extern Class_Descriptor cd_aa15;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa15, buf);
    aa15 *dp, &lv = *(dp=new (buf) aa15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa15)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa15.a");
    test_class_info(&lv, &cd_aa15);
    dp->~aa15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa15(Test_aa15, "aa15", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa15C1Ev();
extern void _ZN4aa15D1Ev();
Name_Map name_map_aa15[] = {
  NSPAIR(_ZN4aa15C1Ev),
  NSPAIR(_ZN4aa15D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa15[];
extern void _ZN4aa153fooEv();
static  VTBL_ENTRY vtc_aa15[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa15[0]),
  (VTBL_ENTRY)&_ZN4aa153fooEv,
};
extern VTBL_ENTRY _ZTI4aa15[];
extern  VTBL_ENTRY _ZTV4aa15[];
Class_Descriptor cd_aa15 = {  "aa15", // class name
  0,0,//no base classes
  &(vtc_aa15[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa15),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa15),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb15  {
  int b;
   bb15(); // _ZN4bb15C1Ev
  virtual void  foo(); // _ZN4bb153fooEv
  ~bb15(); // tgen
};
//SIG(-1 bb15) C1{ v1 Fi}


 bb15 ::bb15(){ note_ctor("bb15", this);}
void  bb15 ::foo(){vfunc_called(this, "_ZN4bb153fooEv");}
bb15 ::~bb15(){ note_dtor("bb15", this);} // tgen

static void Test_bb15()
{
  extern Class_Descriptor cd_bb15;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb15, buf);
    bb15 *dp, &lv = *(dp=new (buf) bb15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb15)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb15.b");
    test_class_info(&lv, &cd_bb15);
    dp->~bb15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb15(Test_bb15, "bb15", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb15C1Ev();
extern void _ZN4bb15D1Ev();
Name_Map name_map_bb15[] = {
  NSPAIR(_ZN4bb15C1Ev),
  NSPAIR(_ZN4bb15D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb15[];
extern void _ZN4bb153fooEv();
static  VTBL_ENTRY vtc_bb15[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb15[0]),
  (VTBL_ENTRY)&_ZN4bb153fooEv,
};
extern VTBL_ENTRY _ZTI4bb15[];
extern  VTBL_ENTRY _ZTV4bb15[];
Class_Descriptor cd_bb15 = {  "bb15", // class name
  0,0,//no base classes
  &(vtc_bb15[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb15),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb15),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc15  {
  int c;
   cc15(); // _ZN4cc15C1Ev
  virtual void  foo(); // _ZN4cc153fooEv
  ~cc15(); // tgen
};
//SIG(-1 cc15) C1{ v1 Fi}


 cc15 ::cc15(){ note_ctor("cc15", this);}
void  cc15 ::foo(){vfunc_called(this, "_ZN4cc153fooEv");}
cc15 ::~cc15(){ note_dtor("cc15", this);} // tgen

static void Test_cc15()
{
  extern Class_Descriptor cd_cc15;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc15, buf);
    cc15 *dp, &lv = *(dp=new (buf) cc15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc15)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc15.c");
    test_class_info(&lv, &cd_cc15);
    dp->~cc15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc15(Test_cc15, "cc15", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc15C1Ev();
extern void _ZN4cc15D1Ev();
Name_Map name_map_cc15[] = {
  NSPAIR(_ZN4cc15C1Ev),
  NSPAIR(_ZN4cc15D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc15[];
extern void _ZN4cc153fooEv();
static  VTBL_ENTRY vtc_cc15[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc15[0]),
  (VTBL_ENTRY)&_ZN4cc153fooEv,
};
extern VTBL_ENTRY _ZTI4cc15[];
extern  VTBL_ENTRY _ZTV4cc15[];
Class_Descriptor cd_cc15 = {  "cc15", // class name
  0,0,//no base classes
  &(vtc_cc15[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc15),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc15),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd15  {
  int d;
   dd15(); // _ZN4dd15C1Ev
  virtual void  foo(); // _ZN4dd153fooEv
  ~dd15(); // tgen
};
//SIG(-1 dd15) C1{ v1 Fi}


 dd15 ::dd15(){ note_ctor("dd15", this);}
void  dd15 ::foo(){vfunc_called(this, "_ZN4dd153fooEv");}
dd15 ::~dd15(){ note_dtor("dd15", this);} // tgen

static void Test_dd15()
{
  extern Class_Descriptor cd_dd15;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd15, buf);
    dd15 *dp, &lv = *(dp=new (buf) dd15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd15)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd15.d");
    test_class_info(&lv, &cd_dd15);
    dp->~dd15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd15(Test_dd15, "dd15", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd15C1Ev();
extern void _ZN4dd15D1Ev();
Name_Map name_map_dd15[] = {
  NSPAIR(_ZN4dd15C1Ev),
  NSPAIR(_ZN4dd15D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd15[];
extern void _ZN4dd153fooEv();
static  VTBL_ENTRY vtc_dd15[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd15[0]),
  (VTBL_ENTRY)&_ZN4dd153fooEv,
};
extern VTBL_ENTRY _ZTI4dd15[];
extern  VTBL_ENTRY _ZTV4dd15[];
Class_Descriptor cd_dd15 = {  "dd15", // class name
  0,0,//no base classes
  &(vtc_dd15[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd15),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd15),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee15  : virtual aa15 , virtual bb15 {
  int e;
   ee15(const ABISELECT(__tsi64,int) *const *); // _ZN4ee15C2Ev
  virtual void  foo(); // _ZN4ee153fooEv
  ~ee15(); // tgen
  ee15(); // tgen
};
//SIG(-1 ee15) C1{ VBC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ee15 ::ee15(const ABISELECT(__tsi64,int) *const *){}
void  ee15 ::foo(){vfunc_called(this, "_ZN4ee153fooEv");}
ee15 ::~ee15(){ note_dtor("ee15", this);} // tgen
ee15 ::ee15(){ note_ctor("ee15", this);} // tgen

static void Test_ee15()
{
  extern Class_Descriptor cd_ee15;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_ee15, buf);
    ee15 *dp, &lv = *(dp=new (buf) ee15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(ee15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee15)");
    check_base_class_offset(lv, (aa15*), ABISELECT(16,8), "ee15");
    check_base_class_offset(lv, (bb15*), ABISELECT(32,16), "ee15");
    check_field_offset(lv, e, ABISELECT(8,4), "ee15.e");
    test_class_info(&lv, &cd_ee15);
    dp->~ee15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee15(Test_ee15, "ee15", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN4ee15C1Ev();
extern void _ZN4ee15D1Ev();
Name_Map name_map_ee15[] = {
  NSPAIR(_ZN4ee15C1Ev),
  NSPAIR(_ZN4ee15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa15;
extern VTBL_ENTRY _ZTI4aa15[];
extern  VTBL_ENTRY _ZTV4aa15[];
extern Class_Descriptor cd_bb15;
extern VTBL_ENTRY _ZTI4bb15[];
extern  VTBL_ENTRY _ZTV4bb15[];
static Base_Class bases_ee15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa15,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_bb15,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ee15[];
extern void _ZN4ee153fooEv();
extern void ABISELECT(_ZTv0_n24_N4ee153fooEv,_ZTv0_n12_N4ee153fooEv)();
extern void ABISELECT(_ZThn16_N4ee153fooEv,_ZThn8_N4ee153fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4ee153fooEv,_ZTv0_n12_N4ee153fooEv)();
extern void ABISELECT(_ZThn32_N4ee153fooEv,_ZThn16_N4ee153fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee15[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI4ee15[0]),
  (VTBL_ENTRY)&_ZN4ee153fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ee15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee153fooEv,_ZTv0_n12_N4ee153fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI4ee15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee153fooEv,_ZTv0_n12_N4ee153fooEv),
};
extern VTBL_ENTRY _ZTV4ee15[];
static  VTT_ENTRY vtt_ee15[] = {
  {&(_ZTV4ee15[4]),  4,13},
  {&(_ZTV4ee15[8]),  8,13},
  {&(_ZTV4ee15[12]),  12,13},
};
extern VTBL_ENTRY _ZTI4ee15[];
extern  VTBL_ENTRY _ZTV4ee15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee15[];
static VTBL_ENTRY alt_thunk_names37[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee153fooEv,_ZTv0_n12_N4ee153fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ee153fooEv,_ZThn16_N4ee153fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee153fooEv,_ZThn8_N4ee153fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee15 = {  "ee15", // class name
  bases_ee15, 2,
  &(vtc_ee15[0]), // expected_vtbl_contents
  &(vtt_ee15[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI4ee15),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee15),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ee15),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names37,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff15  : virtual cc15 , virtual dd15 {
  int f;
   ff15(const ABISELECT(__tsi64,int) *const *); // _ZN4ff15C2Ev
  virtual void  foo(); // _ZN4ff153fooEv
  ~ff15(); // tgen
  ff15(); // tgen
};
//SIG(-1 ff15) C1{ VBC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ff15 ::ff15(const ABISELECT(__tsi64,int) *const *){}
void  ff15 ::foo(){vfunc_called(this, "_ZN4ff153fooEv");}
ff15 ::~ff15(){ note_dtor("ff15", this);} // tgen
ff15 ::ff15(){ note_ctor("ff15", this);} // tgen

static void Test_ff15()
{
  extern Class_Descriptor cd_ff15;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_ff15, buf);
    ff15 *dp, &lv = *(dp=new (buf) ff15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(ff15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff15)");
    check_base_class_offset(lv, (cc15*), ABISELECT(16,8), "ff15");
    check_base_class_offset(lv, (dd15*), ABISELECT(32,16), "ff15");
    check_field_offset(lv, f, ABISELECT(8,4), "ff15.f");
    test_class_info(&lv, &cd_ff15);
    dp->~ff15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff15(Test_ff15, "ff15", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN4ff15C1Ev();
extern void _ZN4ff15D1Ev();
Name_Map name_map_ff15[] = {
  NSPAIR(_ZN4ff15C1Ev),
  NSPAIR(_ZN4ff15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc15;
extern VTBL_ENTRY _ZTI4cc15[];
extern  VTBL_ENTRY _ZTV4cc15[];
extern Class_Descriptor cd_dd15;
extern VTBL_ENTRY _ZTI4dd15[];
extern  VTBL_ENTRY _ZTV4dd15[];
static Base_Class bases_ff15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc15,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_dd15,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ff15[];
extern void _ZN4ff153fooEv();
extern void ABISELECT(_ZTv0_n24_N4ff153fooEv,_ZTv0_n12_N4ff153fooEv)();
extern void ABISELECT(_ZThn16_N4ff153fooEv,_ZThn8_N4ff153fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4ff153fooEv,_ZTv0_n12_N4ff153fooEv)();
extern void ABISELECT(_ZThn32_N4ff153fooEv,_ZThn16_N4ff153fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff15[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI4ff15[0]),
  (VTBL_ENTRY)&_ZN4ff153fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ff15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff153fooEv,_ZTv0_n12_N4ff153fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI4ff15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff153fooEv,_ZTv0_n12_N4ff153fooEv),
};
extern VTBL_ENTRY _ZTV4ff15[];
static  VTT_ENTRY vtt_ff15[] = {
  {&(_ZTV4ff15[4]),  4,13},
  {&(_ZTV4ff15[8]),  8,13},
  {&(_ZTV4ff15[12]),  12,13},
};
extern VTBL_ENTRY _ZTI4ff15[];
extern  VTBL_ENTRY _ZTV4ff15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff15[];
static VTBL_ENTRY alt_thunk_names38[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff153fooEv,_ZTv0_n12_N4ff153fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ff153fooEv,_ZThn16_N4ff153fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff153fooEv,_ZThn8_N4ff153fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff15 = {  "ff15", // class name
  bases_ff15, 2,
  &(vtc_ff15[0]), // expected_vtbl_contents
  &(vtt_ff15[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI4ff15),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff15),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ff15),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names38,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg15  : ee15 , ff15 {
  int g;
   gg15(const ABISELECT(__tsi64,int) *const *); // _ZN4gg15C2Ev
  virtual void  foo(); // _ZN4gg153fooEv
  ~gg15(); // tgen
  gg15(); // tgen
};
//SIG(1 gg15) C1{ BC2{ VBC3{ v1 Fi} VBC4{ v1 Fi} v1 Fi} BC5{ VBC6{ v1 Fi} VBC7{ v1 Fi} v1 Fi} v1 Fi}


 gg15 ::gg15(const ABISELECT(__tsi64,int) *const *){}
void  gg15 ::foo(){vfunc_called(this, "_ZN4gg153fooEv");}
gg15 ::~gg15(){ note_dtor("gg15", this);} // tgen
gg15 ::gg15(){ note_ctor("gg15", this);} // tgen

static void Test_gg15()
{
  extern Class_Descriptor cd_gg15;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,14)];
    init_test(&cd_gg15, buf);
    gg15 *dp, &lv = *(dp=new (buf) gg15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,52), "sizeof(gg15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg15)");
    check_base_class_offset(lv, (aa15*)(ee15*), ABISELECT(32,20), "gg15");
    check_base_class_offset(lv, (bb15*)(ee15*), ABISELECT(48,28), "gg15");
    check_base_class_offset(lv, (ee15*), 0, "gg15");
    check_base_class_offset(lv, (cc15*)(ff15*), ABISELECT(64,36), "gg15");
    check_base_class_offset(lv, (dd15*)(ff15*), ABISELECT(80,44), "gg15");
    check_base_class_offset(lv, (ff15*), ABISELECT(16,8), "gg15");
    check_field_offset(lv, g, ABISELECT(28,16), "gg15.g");
    test_class_info(&lv, &cd_gg15);
    dp->~gg15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg15(Test_gg15, "gg15", ABISELECT(96,52));

#else // __cplusplus

extern void _ZN4gg15C1Ev();
extern void _ZN4gg15D1Ev();
Name_Map name_map_gg15[] = {
  NSPAIR(_ZN4gg15C1Ev),
  NSPAIR(_ZN4gg15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa15;
extern VTBL_ENTRY _ZTI4aa15[];
extern  VTBL_ENTRY _ZTV4aa15[];
extern Class_Descriptor cd_bb15;
extern VTBL_ENTRY _ZTI4bb15[];
extern  VTBL_ENTRY _ZTV4bb15[];
extern Class_Descriptor cd_ee15;
extern VTBL_ENTRY _ZTI4ee15[];
extern  VTBL_ENTRY _ZTV4ee15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee15[];
extern Class_Descriptor cd_cc15;
extern VTBL_ENTRY _ZTI4cc15[];
extern  VTBL_ENTRY _ZTV4cc15[];
extern Class_Descriptor cd_dd15;
extern VTBL_ENTRY _ZTI4dd15[];
extern  VTBL_ENTRY _ZTV4dd15[];
extern Class_Descriptor cd_ff15;
extern VTBL_ENTRY _ZTI4ff15[];
extern  VTBL_ENTRY _ZTV4ff15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff15[];
static Base_Class bases_gg15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa15,    ABISELECT(32,20), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_bb15,    ABISELECT(48,28), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_ee15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc15,    ABISELECT(64,36), //bcp->offset
    20, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_dd15,    ABISELECT(80,44), //bcp->offset
    24, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_ff15,    ABISELECT(16,8), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4gg15[];
extern void _ZN4gg153fooEv();
extern void ABISELECT(_ZThn16_N4gg153fooEv,_ZThn8_N4gg153fooEv)();
extern void ABISELECT(_ZTv0_n24_N4gg153fooEv,_ZTv0_n12_N4gg153fooEv)();
extern void ABISELECT(_ZThn32_N4gg153fooEv,_ZThn20_N4gg153fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg153fooEv,_ZTv0_n12_N4gg153fooEv)();
extern void ABISELECT(_ZThn48_N4gg153fooEv,_ZThn28_N4gg153fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg153fooEv,_ZTv0_n12_N4gg153fooEv)();
extern void ABISELECT(_ZThn64_N4gg153fooEv,_ZThn36_N4gg153fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg153fooEv,_ZTv0_n12_N4gg153fooEv)();
extern void ABISELECT(_ZThn80_N4gg153fooEv,_ZThn44_N4gg153fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg15[] = {
  ABISELECT(80,44),
  ABISELECT(64,36),
  ABISELECT(48,28),
  ABISELECT(32,20),
  0,
  (VTBL_ENTRY)&(_ZTI4gg15[0]),
  (VTBL_ENTRY)&_ZN4gg153fooEv,
  ABISELECT(64,36),
  ABISELECT(48,28),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4gg15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4gg153fooEv,_ZThn8_N4gg153fooEv),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI4gg15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg153fooEv,_ZTv0_n12_N4gg153fooEv),
  ABISELECT(-48,-28),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI4gg15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg153fooEv,_ZTv0_n12_N4gg153fooEv),
  ABISELECT(-64,-36),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI4gg15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg153fooEv,_ZTv0_n12_N4gg153fooEv),
  ABISELECT(-80,-44),
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI4gg15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg153fooEv,_ZTv0_n12_N4gg153fooEv),
};
extern VTBL_ENTRY _ZTV4gg15[];
extern void _ZN4ee153fooEv();
static  VTBL_ENTRY _tg__ZTV4ee15__4gg15[] = {
  ABISELECT(48,28),
  ABISELECT(32,20),
  0,
  (VTBL_ENTRY)&(_ZTI4ee15[0]),
  (VTBL_ENTRY)&_ZN4ee153fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ee153fooEv,_ZTv0_n12_N4ee153fooEv)();
extern void ABISELECT(_ZThn32_N4ee153fooEv,_ZThn20_N4ee153fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4aa15__4ee15__4gg15[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI4ee15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee153fooEv,_ZTv0_n12_N4ee153fooEv),
};
extern void ABISELECT(_ZTv0_n24_N4ee153fooEv,_ZTv0_n12_N4ee153fooEv)();
extern void ABISELECT(_ZThn48_N4ee153fooEv,_ZThn28_N4ee153fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb15__4ee15__4gg15[] = {
  ABISELECT(-48,-28),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI4ee15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee153fooEv,_ZTv0_n12_N4ee153fooEv),
};
extern void _ZN4ff153fooEv();
static  VTBL_ENTRY _tg__ZTV4ff15__4gg15[] = {
  ABISELECT(64,36),
  ABISELECT(48,28),
  0,
  (VTBL_ENTRY)&(_ZTI4ff15[0]),
  (VTBL_ENTRY)&_ZN4ff153fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ff153fooEv,_ZTv0_n12_N4ff153fooEv)();
extern void ABISELECT(_ZThn48_N4ff153fooEv,_ZThn28_N4ff153fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4cc15__4ff15__4gg15[] = {
  ABISELECT(-48,-28),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI4ff15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff153fooEv,_ZTv0_n12_N4ff153fooEv),
};
extern void ABISELECT(_ZTv0_n24_N4ff153fooEv,_ZTv0_n12_N4ff153fooEv)();
extern void ABISELECT(_ZThn64_N4ff153fooEv,_ZThn36_N4ff153fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4dd15__4ff15__4gg15[] = {
  ABISELECT(-64,-36),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI4ff15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff153fooEv,_ZTv0_n12_N4ff153fooEv),
};
static  VTT_ENTRY vtt_gg15[] = {
  {&(_ZTV4gg15[6]),  6,28},
  {&(_tg__ZTV4ee15__4gg15[4]),  4,5},
  {&(_tg__ZTV4aa15__4ee15__4gg15[3]),  3,4},
  {&(_tg__ZTV4bb15__4ee15__4gg15[3]),  3,4},
  {&(_tg__ZTV4ff15__4gg15[4]),  4,5},
  {&(_tg__ZTV4cc15__4ff15__4gg15[3]),  3,4},
  {&(_tg__ZTV4dd15__4ff15__4gg15[3]),  3,4},
  {&(_ZTV4gg15[15]),  15,28},
  {&(_ZTV4gg15[19]),  19,28},
  {&(_ZTV4gg15[11]),  11,28},
  {&(_ZTV4gg15[23]),  23,28},
  {&(_ZTV4gg15[27]),  27,28},
};
extern VTBL_ENTRY _ZTI4gg15[];
extern  VTBL_ENTRY _ZTV4gg15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg15[];
static VTBL_ENTRY alt_thunk_names39[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff153fooEv,_ZTv0_n12_N4ff153fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N4ff153fooEv,_ZThn36_N4ff153fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N4ff153fooEv,_ZThn28_N4ff153fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee153fooEv,_ZTv0_n12_N4ee153fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N4ee153fooEv,_ZThn28_N4ee153fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ee153fooEv,_ZThn20_N4ee153fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg153fooEv,_ZTv0_n12_N4gg153fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N4gg153fooEv,_ZThn44_N4gg153fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn64_N4gg153fooEv,_ZThn36_N4gg153fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N4gg153fooEv,_ZThn28_N4gg153fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4gg153fooEv,_ZThn20_N4gg153fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg15 = {  "gg15", // class name
  bases_gg15, 6,
  &(vtc_gg15[0]), // expected_vtbl_contents
  &(vtt_gg15[0]), // expected_vtt_contents
  ABISELECT(96,52), // object size
  NSPAIRA(_ZTI4gg15),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg15),28, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg15),12, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names39,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa16  {
  int a;
   aa16(); // _ZN4aa16C1Ev
  virtual void  foo(); // _ZN4aa163fooEv
  ~aa16(); // tgen
};
//SIG(-1 aa16) C1{ v1 Fi}


 aa16 ::aa16(){ note_ctor("aa16", this);}
void  aa16 ::foo(){vfunc_called(this, "_ZN4aa163fooEv");}
aa16 ::~aa16(){ note_dtor("aa16", this);} // tgen

static void Test_aa16()
{
  extern Class_Descriptor cd_aa16;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa16, buf);
    aa16 *dp, &lv = *(dp=new (buf) aa16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa16)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa16.a");
    test_class_info(&lv, &cd_aa16);
    dp->~aa16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa16(Test_aa16, "aa16", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa16C1Ev();
extern void _ZN4aa16D1Ev();
Name_Map name_map_aa16[] = {
  NSPAIR(_ZN4aa16C1Ev),
  NSPAIR(_ZN4aa16D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa16[];
extern void _ZN4aa163fooEv();
static  VTBL_ENTRY vtc_aa16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa16[0]),
  (VTBL_ENTRY)&_ZN4aa163fooEv,
};
extern VTBL_ENTRY _ZTI4aa16[];
extern  VTBL_ENTRY _ZTV4aa16[];
Class_Descriptor cd_aa16 = {  "aa16", // class name
  0,0,//no base classes
  &(vtc_aa16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa16),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa16),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb16  {
  int b;
   bb16(); // _ZN4bb16C1Ev
  virtual void  foo(); // _ZN4bb163fooEv
  ~bb16(); // tgen
};
//SIG(-1 bb16) C1{ v1 Fi}


 bb16 ::bb16(){ note_ctor("bb16", this);}
void  bb16 ::foo(){vfunc_called(this, "_ZN4bb163fooEv");}
bb16 ::~bb16(){ note_dtor("bb16", this);} // tgen

static void Test_bb16()
{
  extern Class_Descriptor cd_bb16;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb16, buf);
    bb16 *dp, &lv = *(dp=new (buf) bb16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb16)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb16.b");
    test_class_info(&lv, &cd_bb16);
    dp->~bb16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb16(Test_bb16, "bb16", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb16C1Ev();
extern void _ZN4bb16D1Ev();
Name_Map name_map_bb16[] = {
  NSPAIR(_ZN4bb16C1Ev),
  NSPAIR(_ZN4bb16D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb16[];
extern void _ZN4bb163fooEv();
static  VTBL_ENTRY vtc_bb16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb16[0]),
  (VTBL_ENTRY)&_ZN4bb163fooEv,
};
extern VTBL_ENTRY _ZTI4bb16[];
extern  VTBL_ENTRY _ZTV4bb16[];
Class_Descriptor cd_bb16 = {  "bb16", // class name
  0,0,//no base classes
  &(vtc_bb16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb16),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb16),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc16  {
  int c;
   cc16(); // _ZN4cc16C1Ev
  virtual void  foo(); // _ZN4cc163fooEv
  ~cc16(); // tgen
};
//SIG(-1 cc16) C1{ v1 Fi}


 cc16 ::cc16(){ note_ctor("cc16", this);}
void  cc16 ::foo(){vfunc_called(this, "_ZN4cc163fooEv");}
cc16 ::~cc16(){ note_dtor("cc16", this);} // tgen

static void Test_cc16()
{
  extern Class_Descriptor cd_cc16;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc16, buf);
    cc16 *dp, &lv = *(dp=new (buf) cc16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc16)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc16.c");
    test_class_info(&lv, &cd_cc16);
    dp->~cc16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc16(Test_cc16, "cc16", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc16C1Ev();
extern void _ZN4cc16D1Ev();
Name_Map name_map_cc16[] = {
  NSPAIR(_ZN4cc16C1Ev),
  NSPAIR(_ZN4cc16D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc16[];
extern void _ZN4cc163fooEv();
static  VTBL_ENTRY vtc_cc16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc16[0]),
  (VTBL_ENTRY)&_ZN4cc163fooEv,
};
extern VTBL_ENTRY _ZTI4cc16[];
extern  VTBL_ENTRY _ZTV4cc16[];
Class_Descriptor cd_cc16 = {  "cc16", // class name
  0,0,//no base classes
  &(vtc_cc16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc16),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc16),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd16  {
  int d;
   dd16(); // _ZN4dd16C1Ev
  virtual void  foo(); // _ZN4dd163fooEv
  ~dd16(); // tgen
};
//SIG(-1 dd16) C1{ v1 Fi}


 dd16 ::dd16(){ note_ctor("dd16", this);}
void  dd16 ::foo(){vfunc_called(this, "_ZN4dd163fooEv");}
dd16 ::~dd16(){ note_dtor("dd16", this);} // tgen

static void Test_dd16()
{
  extern Class_Descriptor cd_dd16;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd16, buf);
    dd16 *dp, &lv = *(dp=new (buf) dd16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd16)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd16.d");
    test_class_info(&lv, &cd_dd16);
    dp->~dd16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd16(Test_dd16, "dd16", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd16C1Ev();
extern void _ZN4dd16D1Ev();
Name_Map name_map_dd16[] = {
  NSPAIR(_ZN4dd16C1Ev),
  NSPAIR(_ZN4dd16D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd16[];
extern void _ZN4dd163fooEv();
static  VTBL_ENTRY vtc_dd16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd16[0]),
  (VTBL_ENTRY)&_ZN4dd163fooEv,
};
extern VTBL_ENTRY _ZTI4dd16[];
extern  VTBL_ENTRY _ZTV4dd16[];
Class_Descriptor cd_dd16 = {  "dd16", // class name
  0,0,//no base classes
  &(vtc_dd16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd16),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd16),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee16  : aa16 , bb16 {
  int e;
   ee16(); // _ZN4ee16C1Ev
  virtual void  foo(); // _ZN4ee163fooEv
  ~ee16(); // tgen
};
//SIG(-1 ee16) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ee16 ::ee16(){ note_ctor("ee16", this);}
void  ee16 ::foo(){vfunc_called(this, "_ZN4ee163fooEv");}
ee16 ::~ee16(){ note_dtor("ee16", this);} // tgen

static void Test_ee16()
{
  extern Class_Descriptor cd_ee16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee16, buf);
    ee16 *dp, &lv = *(dp=new (buf) ee16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee16)");
    check_base_class_offset(lv, (aa16*), 0, "ee16");
    check_base_class_offset(lv, (bb16*), ABISELECT(16,8), "ee16");
    check_field_offset(lv, e, ABISELECT(28,16), "ee16.e");
    test_class_info(&lv, &cd_ee16);
    dp->~ee16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee16(Test_ee16, "ee16", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ee16C1Ev();
extern void _ZN4ee16D1Ev();
Name_Map name_map_ee16[] = {
  NSPAIR(_ZN4ee16C1Ev),
  NSPAIR(_ZN4ee16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa16;
extern VTBL_ENTRY _ZTI4aa16[];
extern  VTBL_ENTRY _ZTV4aa16[];
extern Class_Descriptor cd_bb16;
extern VTBL_ENTRY _ZTI4bb16[];
extern  VTBL_ENTRY _ZTV4bb16[];
static Base_Class bases_ee16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_bb16,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ee16[];
extern void _ZN4ee163fooEv();
extern void ABISELECT(_ZThn16_N4ee163fooEv,_ZThn8_N4ee163fooEv)();
static  VTBL_ENTRY vtc_ee16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4ee16[0]),
  (VTBL_ENTRY)&_ZN4ee163fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ee16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4ee163fooEv,_ZThn8_N4ee163fooEv),
};
extern VTBL_ENTRY _ZTI4ee16[];
extern  VTBL_ENTRY _ZTV4ee16[];
Class_Descriptor cd_ee16 = {  "ee16", // class name
  bases_ee16, 2,
  &(vtc_ee16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ee16),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee16),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff16  : cc16 , dd16 {
  int f;
   ff16(); // _ZN4ff16C1Ev
  virtual void  foo(); // _ZN4ff163fooEv
  ~ff16(); // tgen
};
//SIG(-1 ff16) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ff16 ::ff16(){ note_ctor("ff16", this);}
void  ff16 ::foo(){vfunc_called(this, "_ZN4ff163fooEv");}
ff16 ::~ff16(){ note_dtor("ff16", this);} // tgen

static void Test_ff16()
{
  extern Class_Descriptor cd_ff16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff16, buf);
    ff16 *dp, &lv = *(dp=new (buf) ff16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff16)");
    check_base_class_offset(lv, (cc16*), 0, "ff16");
    check_base_class_offset(lv, (dd16*), ABISELECT(16,8), "ff16");
    check_field_offset(lv, f, ABISELECT(28,16), "ff16.f");
    test_class_info(&lv, &cd_ff16);
    dp->~ff16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff16(Test_ff16, "ff16", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ff16C1Ev();
extern void _ZN4ff16D1Ev();
Name_Map name_map_ff16[] = {
  NSPAIR(_ZN4ff16C1Ev),
  NSPAIR(_ZN4ff16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc16;
extern VTBL_ENTRY _ZTI4cc16[];
extern  VTBL_ENTRY _ZTV4cc16[];
extern Class_Descriptor cd_dd16;
extern VTBL_ENTRY _ZTI4dd16[];
extern  VTBL_ENTRY _ZTV4dd16[];
static Base_Class bases_ff16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_dd16,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ff16[];
extern void _ZN4ff163fooEv();
extern void ABISELECT(_ZThn16_N4ff163fooEv,_ZThn8_N4ff163fooEv)();
static  VTBL_ENTRY vtc_ff16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4ff16[0]),
  (VTBL_ENTRY)&_ZN4ff163fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ff16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4ff163fooEv,_ZThn8_N4ff163fooEv),
};
extern VTBL_ENTRY _ZTI4ff16[];
extern  VTBL_ENTRY _ZTV4ff16[];
Class_Descriptor cd_ff16 = {  "ff16", // class name
  bases_ff16, 2,
  &(vtc_ff16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ff16),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff16),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg16  : virtual ee16 , ff16 {
  int g;
   gg16(const ABISELECT(__tsi64,int) *const *); // _ZN4gg16C2Ev
  virtual void  foo(); // _ZN4gg163fooEv
  ~gg16(); // tgen
  gg16(); // tgen
};
//SIG(1 gg16) C1{ VBC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 Fi} BC7{ v1 Fi} v1 Fi} v1 Fi}


 gg16 ::gg16(const ABISELECT(__tsi64,int) *const *){}
void  gg16 ::foo(){vfunc_called(this, "_ZN4gg163fooEv");}
gg16 ::~gg16(){ note_dtor("gg16", this);} // tgen
gg16 ::gg16(){ note_ctor("gg16", this);} // tgen

static void Test_gg16()
{
  extern Class_Descriptor cd_gg16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg16, buf);
    gg16 *dp, &lv = *(dp=new (buf) gg16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg16)");
    check_base_class_offset(lv, (aa16*)(ee16*), ABISELECT(40,24), "gg16");
    check_base_class_offset(lv, (bb16*)(ee16*), ABISELECT(56,32), "gg16");
    check_base_class_offset(lv, (ee16*), ABISELECT(40,24), "gg16");
    check_base_class_offset(lv, (cc16*)(ff16*), 0, "gg16");
    check_base_class_offset(lv, (dd16*)(ff16*), ABISELECT(16,8), "gg16");
    check_base_class_offset(lv, (ff16*), 0, "gg16");
    check_field_offset(lv, g, ABISELECT(32,20), "gg16.g");
    test_class_info(&lv, &cd_gg16);
    dp->~gg16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg16(Test_gg16, "gg16", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN4gg16C1Ev();
extern void _ZN4gg16D1Ev();
Name_Map name_map_gg16[] = {
  NSPAIR(_ZN4gg16C1Ev),
  NSPAIR(_ZN4gg16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa16;
extern VTBL_ENTRY _ZTI4aa16[];
extern  VTBL_ENTRY _ZTV4aa16[];
extern Class_Descriptor cd_bb16;
extern VTBL_ENTRY _ZTI4bb16[];
extern  VTBL_ENTRY _ZTV4bb16[];
extern Class_Descriptor cd_ee16;
extern VTBL_ENTRY _ZTI4ee16[];
extern  VTBL_ENTRY _ZTV4ee16[];
extern Class_Descriptor cd_cc16;
extern VTBL_ENTRY _ZTI4cc16[];
extern  VTBL_ENTRY _ZTV4cc16[];
extern Class_Descriptor cd_dd16;
extern VTBL_ENTRY _ZTI4dd16[];
extern  VTBL_ENTRY _ZTV4dd16[];
extern Class_Descriptor cd_ff16;
extern VTBL_ENTRY _ZTI4ff16[];
extern  VTBL_ENTRY _ZTV4ff16[];
static Base_Class bases_gg16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa16,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_bb16,    ABISELECT(56,32), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_ee16,    ABISELECT(40,24), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_cc16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_dd16,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_ff16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4gg16[];
extern void _ZN4gg163fooEv();
extern void ABISELECT(_ZThn16_N4gg163fooEv,_ZThn8_N4gg163fooEv)();
extern void ABISELECT(_ZTv0_n24_N4gg163fooEv,_ZTv0_n12_N4gg163fooEv)();
extern void ABISELECT(_ZThn40_N4gg163fooEv,_ZThn24_N4gg163fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n24_N4gg163fooEv,_ZTvn8_n12_N4gg163fooEv)();
static  VTBL_ENTRY vtc_gg16[] = {
  ABISELECT(40,24),
  0,
  (VTBL_ENTRY)&(_ZTI4gg16[0]),
  (VTBL_ENTRY)&_ZN4gg163fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4gg16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4gg163fooEv,_ZThn8_N4gg163fooEv),
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI4gg16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg163fooEv,_ZTv0_n12_N4gg163fooEv),
  ABISELECT(-56,-32),
  (VTBL_ENTRY)&(_ZTI4gg16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N4gg163fooEv,_ZTvn8_n12_N4gg163fooEv),
};
extern VTBL_ENTRY _ZTV4gg16[];
static  VTT_ENTRY vtt_gg16[] = {
  {&(_ZTV4gg16[3]),  3,14},
  {&(_ZTV4gg16[10]),  10,14},
  {&(_ZTV4gg16[13]),  13,14},
};
extern VTBL_ENTRY _ZTI4gg16[];
extern  VTBL_ENTRY _ZTV4gg16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg16[];
static VTBL_ENTRY alt_thunk_names40[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg163fooEv,_ZTv0_n12_N4gg163fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N4gg163fooEv,_ZThn24_N4gg163fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg16 = {  "gg16", // class name
  bases_gg16, 6,
  &(vtc_gg16[0]), // expected_vtbl_contents
  &(vtt_gg16[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI4gg16),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg16),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg16),3, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names40,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa17  {
  int a;
   aa17(); // _ZN4aa17C1Ev
  virtual void  foo(); // _ZN4aa173fooEv
  ~aa17(); // tgen
};
//SIG(-1 aa17) C1{ v1 Fi}


 aa17 ::aa17(){ note_ctor("aa17", this);}
void  aa17 ::foo(){vfunc_called(this, "_ZN4aa173fooEv");}
aa17 ::~aa17(){ note_dtor("aa17", this);} // tgen

static void Test_aa17()
{
  extern Class_Descriptor cd_aa17;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa17, buf);
    aa17 *dp, &lv = *(dp=new (buf) aa17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa17)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa17.a");
    test_class_info(&lv, &cd_aa17);
    dp->~aa17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa17(Test_aa17, "aa17", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa17C1Ev();
extern void _ZN4aa17D1Ev();
Name_Map name_map_aa17[] = {
  NSPAIR(_ZN4aa17C1Ev),
  NSPAIR(_ZN4aa17D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa17[];
extern void _ZN4aa173fooEv();
static  VTBL_ENTRY vtc_aa17[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa17[0]),
  (VTBL_ENTRY)&_ZN4aa173fooEv,
};
extern VTBL_ENTRY _ZTI4aa17[];
extern  VTBL_ENTRY _ZTV4aa17[];
Class_Descriptor cd_aa17 = {  "aa17", // class name
  0,0,//no base classes
  &(vtc_aa17[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa17),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa17),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb17  {
  int b;
   bb17(); // _ZN4bb17C1Ev
  virtual void  foo(); // _ZN4bb173fooEv
  ~bb17(); // tgen
};
//SIG(-1 bb17) C1{ v1 Fi}


 bb17 ::bb17(){ note_ctor("bb17", this);}
void  bb17 ::foo(){vfunc_called(this, "_ZN4bb173fooEv");}
bb17 ::~bb17(){ note_dtor("bb17", this);} // tgen

static void Test_bb17()
{
  extern Class_Descriptor cd_bb17;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb17, buf);
    bb17 *dp, &lv = *(dp=new (buf) bb17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb17)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb17.b");
    test_class_info(&lv, &cd_bb17);
    dp->~bb17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb17(Test_bb17, "bb17", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb17C1Ev();
extern void _ZN4bb17D1Ev();
Name_Map name_map_bb17[] = {
  NSPAIR(_ZN4bb17C1Ev),
  NSPAIR(_ZN4bb17D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb17[];
extern void _ZN4bb173fooEv();
static  VTBL_ENTRY vtc_bb17[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb17[0]),
  (VTBL_ENTRY)&_ZN4bb173fooEv,
};
extern VTBL_ENTRY _ZTI4bb17[];
extern  VTBL_ENTRY _ZTV4bb17[];
Class_Descriptor cd_bb17 = {  "bb17", // class name
  0,0,//no base classes
  &(vtc_bb17[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb17),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb17),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc17  {
  int c;
   cc17(); // _ZN4cc17C1Ev
  virtual void  foo(); // _ZN4cc173fooEv
  ~cc17(); // tgen
};
//SIG(-1 cc17) C1{ v1 Fi}


 cc17 ::cc17(){ note_ctor("cc17", this);}
void  cc17 ::foo(){vfunc_called(this, "_ZN4cc173fooEv");}
cc17 ::~cc17(){ note_dtor("cc17", this);} // tgen

static void Test_cc17()
{
  extern Class_Descriptor cd_cc17;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc17, buf);
    cc17 *dp, &lv = *(dp=new (buf) cc17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc17)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc17.c");
    test_class_info(&lv, &cd_cc17);
    dp->~cc17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc17(Test_cc17, "cc17", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc17C1Ev();
extern void _ZN4cc17D1Ev();
Name_Map name_map_cc17[] = {
  NSPAIR(_ZN4cc17C1Ev),
  NSPAIR(_ZN4cc17D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc17[];
extern void _ZN4cc173fooEv();
static  VTBL_ENTRY vtc_cc17[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc17[0]),
  (VTBL_ENTRY)&_ZN4cc173fooEv,
};
extern VTBL_ENTRY _ZTI4cc17[];
extern  VTBL_ENTRY _ZTV4cc17[];
Class_Descriptor cd_cc17 = {  "cc17", // class name
  0,0,//no base classes
  &(vtc_cc17[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc17),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc17),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd17  {
  int d;
   dd17(); // _ZN4dd17C1Ev
  virtual void  foo(); // _ZN4dd173fooEv
  ~dd17(); // tgen
};
//SIG(-1 dd17) C1{ v1 Fi}


 dd17 ::dd17(){ note_ctor("dd17", this);}
void  dd17 ::foo(){vfunc_called(this, "_ZN4dd173fooEv");}
dd17 ::~dd17(){ note_dtor("dd17", this);} // tgen

static void Test_dd17()
{
  extern Class_Descriptor cd_dd17;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd17, buf);
    dd17 *dp, &lv = *(dp=new (buf) dd17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd17)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd17.d");
    test_class_info(&lv, &cd_dd17);
    dp->~dd17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd17(Test_dd17, "dd17", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd17C1Ev();
extern void _ZN4dd17D1Ev();
Name_Map name_map_dd17[] = {
  NSPAIR(_ZN4dd17C1Ev),
  NSPAIR(_ZN4dd17D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd17[];
extern void _ZN4dd173fooEv();
static  VTBL_ENTRY vtc_dd17[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd17[0]),
  (VTBL_ENTRY)&_ZN4dd173fooEv,
};
extern VTBL_ENTRY _ZTI4dd17[];
extern  VTBL_ENTRY _ZTV4dd17[];
Class_Descriptor cd_dd17 = {  "dd17", // class name
  0,0,//no base classes
  &(vtc_dd17[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd17),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd17),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee17  : virtual aa17 , bb17 {
  int e;
   ee17(const ABISELECT(__tsi64,int) *const *); // _ZN4ee17C2Ev
  virtual void  foo(); // _ZN4ee173fooEv
  ~ee17(); // tgen
  ee17(); // tgen
};
//SIG(-1 ee17) C1{ VBC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ee17 ::ee17(const ABISELECT(__tsi64,int) *const *){}
void  ee17 ::foo(){vfunc_called(this, "_ZN4ee173fooEv");}
ee17 ::~ee17(){ note_dtor("ee17", this);} // tgen
ee17 ::ee17(){ note_ctor("ee17", this);} // tgen

static void Test_ee17()
{
  extern Class_Descriptor cd_ee17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee17, buf);
    ee17 *dp, &lv = *(dp=new (buf) ee17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee17)");
    check_base_class_offset(lv, (aa17*), ABISELECT(16,12), "ee17");
    check_base_class_offset(lv, (bb17*), 0, "ee17");
    check_field_offset(lv, e, ABISELECT(12,8), "ee17.e");
    test_class_info(&lv, &cd_ee17);
    dp->~ee17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee17(Test_ee17, "ee17", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ee17C1Ev();
extern void _ZN4ee17D1Ev();
Name_Map name_map_ee17[] = {
  NSPAIR(_ZN4ee17C1Ev),
  NSPAIR(_ZN4ee17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa17;
extern VTBL_ENTRY _ZTI4aa17[];
extern  VTBL_ENTRY _ZTV4aa17[];
extern Class_Descriptor cd_bb17;
extern VTBL_ENTRY _ZTI4bb17[];
extern  VTBL_ENTRY _ZTV4bb17[];
static Base_Class bases_ee17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa17,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_bb17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ee17[];
extern void _ZN4ee173fooEv();
extern void ABISELECT(_ZTv0_n24_N4ee173fooEv,_ZTv0_n12_N4ee173fooEv)();
extern void ABISELECT(_ZThn16_N4ee173fooEv,_ZThn12_N4ee173fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee17[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee17[0]),
  (VTBL_ENTRY)&_ZN4ee173fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee173fooEv,_ZTv0_n12_N4ee173fooEv),
};
extern VTBL_ENTRY _ZTV4ee17[];
static  VTT_ENTRY vtt_ee17[] = {
  {&(_ZTV4ee17[3]),  3,8},
  {&(_ZTV4ee17[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ee17[];
extern  VTBL_ENTRY _ZTV4ee17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee17[];
static VTBL_ENTRY alt_thunk_names41[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee173fooEv,_ZTv0_n12_N4ee173fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee173fooEv,_ZThn12_N4ee173fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee17 = {  "ee17", // class name
  bases_ee17, 2,
  &(vtc_ee17[0]), // expected_vtbl_contents
  &(vtt_ee17[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ee17),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee17),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ee17),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names41,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff17  : cc17 , dd17 {
  int f;
   ff17(); // _ZN4ff17C1Ev
  virtual void  foo(); // _ZN4ff173fooEv
  ~ff17(); // tgen
};
//SIG(-1 ff17) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ff17 ::ff17(){ note_ctor("ff17", this);}
void  ff17 ::foo(){vfunc_called(this, "_ZN4ff173fooEv");}
ff17 ::~ff17(){ note_dtor("ff17", this);} // tgen

static void Test_ff17()
{
  extern Class_Descriptor cd_ff17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff17, buf);
    ff17 *dp, &lv = *(dp=new (buf) ff17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff17)");
    check_base_class_offset(lv, (cc17*), 0, "ff17");
    check_base_class_offset(lv, (dd17*), ABISELECT(16,8), "ff17");
    check_field_offset(lv, f, ABISELECT(28,16), "ff17.f");
    test_class_info(&lv, &cd_ff17);
    dp->~ff17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff17(Test_ff17, "ff17", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ff17C1Ev();
extern void _ZN4ff17D1Ev();
Name_Map name_map_ff17[] = {
  NSPAIR(_ZN4ff17C1Ev),
  NSPAIR(_ZN4ff17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc17;
extern VTBL_ENTRY _ZTI4cc17[];
extern  VTBL_ENTRY _ZTV4cc17[];
extern Class_Descriptor cd_dd17;
extern VTBL_ENTRY _ZTI4dd17[];
extern  VTBL_ENTRY _ZTV4dd17[];
static Base_Class bases_ff17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_dd17,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ff17[];
extern void _ZN4ff173fooEv();
extern void ABISELECT(_ZThn16_N4ff173fooEv,_ZThn8_N4ff173fooEv)();
static  VTBL_ENTRY vtc_ff17[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4ff17[0]),
  (VTBL_ENTRY)&_ZN4ff173fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ff17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4ff173fooEv,_ZThn8_N4ff173fooEv),
};
extern VTBL_ENTRY _ZTI4ff17[];
extern  VTBL_ENTRY _ZTV4ff17[];
Class_Descriptor cd_ff17 = {  "ff17", // class name
  bases_ff17, 2,
  &(vtc_ff17[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ff17),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff17),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg17  : virtual ee17 , ff17 {
  int g;
   gg17(const ABISELECT(__tsi64,int) *const *); // _ZN4gg17C2Ev
  virtual void  foo(); // _ZN4gg173fooEv
  ~gg17(); // tgen
  gg17(); // tgen
};
//SIG(1 gg17) C1{ VBC2{ VBC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 Fi} BC7{ v1 Fi} v1 Fi} v1 Fi}


 gg17 ::gg17(const ABISELECT(__tsi64,int) *const *){}
void  gg17 ::foo(){vfunc_called(this, "_ZN4gg173fooEv");}
gg17 ::~gg17(){ note_dtor("gg17", this);} // tgen
gg17 ::gg17(){ note_ctor("gg17", this);} // tgen

static void Test_gg17()
{
  extern Class_Descriptor cd_gg17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg17, buf);
    gg17 *dp, &lv = *(dp=new (buf) gg17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg17)");
    check_base_class_offset(lv, (aa17*)(ee17*), ABISELECT(56,36), "gg17");
    check_base_class_offset(lv, (bb17*)(ee17*), ABISELECT(40,24), "gg17");
    check_base_class_offset(lv, (ee17*), ABISELECT(40,24), "gg17");
    check_base_class_offset(lv, (cc17*)(ff17*), 0, "gg17");
    check_base_class_offset(lv, (dd17*)(ff17*), ABISELECT(16,8), "gg17");
    check_base_class_offset(lv, (ff17*), 0, "gg17");
    check_field_offset(lv, g, ABISELECT(32,20), "gg17.g");
    test_class_info(&lv, &cd_gg17);
    dp->~gg17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg17(Test_gg17, "gg17", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN4gg17C1Ev();
extern void _ZN4gg17D1Ev();
Name_Map name_map_gg17[] = {
  NSPAIR(_ZN4gg17C1Ev),
  NSPAIR(_ZN4gg17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa17;
extern VTBL_ENTRY _ZTI4aa17[];
extern  VTBL_ENTRY _ZTV4aa17[];
extern Class_Descriptor cd_bb17;
extern VTBL_ENTRY _ZTI4bb17[];
extern  VTBL_ENTRY _ZTV4bb17[];
extern Class_Descriptor cd_ee17;
extern VTBL_ENTRY _ZTI4ee17[];
extern  VTBL_ENTRY _ZTV4ee17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee17[];
extern Class_Descriptor cd_cc17;
extern VTBL_ENTRY _ZTI4cc17[];
extern  VTBL_ENTRY _ZTV4cc17[];
extern Class_Descriptor cd_dd17;
extern VTBL_ENTRY _ZTI4dd17[];
extern  VTBL_ENTRY _ZTV4dd17[];
extern Class_Descriptor cd_ff17;
extern VTBL_ENTRY _ZTI4ff17[];
extern  VTBL_ENTRY _ZTV4ff17[];
static Base_Class bases_gg17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa17,    ABISELECT(56,36), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_bb17,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_ee17,    ABISELECT(40,24), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_cc17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_dd17,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_ff17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4gg17[];
extern void _ZN4gg173fooEv();
extern void ABISELECT(_ZThn16_N4gg173fooEv,_ZThn8_N4gg173fooEv)();
extern void ABISELECT(_ZTv0_n32_N4gg173fooEv,_ZTv0_n16_N4gg173fooEv)();
extern void ABISELECT(_ZThn40_N4gg173fooEv,_ZThn24_N4gg173fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg173fooEv,_ZTv0_n12_N4gg173fooEv)();
extern void ABISELECT(_ZThn56_N4gg173fooEv,_ZThn36_N4gg173fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg17[] = {
  ABISELECT(56,36),
  ABISELECT(40,24),
  0,
  (VTBL_ENTRY)&(_ZTI4gg17[0]),
  (VTBL_ENTRY)&_ZN4gg173fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4gg17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4gg173fooEv,_ZThn8_N4gg173fooEv),
  ABISELECT(-40,-24),
  ABISELECT(16,12),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI4gg17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N4gg173fooEv,_ZTv0_n16_N4gg173fooEv),
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI4gg17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg173fooEv,_ZTv0_n12_N4gg173fooEv),
};
extern VTBL_ENTRY _ZTV4gg17[];
extern void _ZN4ee173fooEv();
static  VTBL_ENTRY _tg__ZTV4ee17__4gg17[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee17[0]),
  (VTBL_ENTRY)&_ZN4ee173fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ee173fooEv,_ZTv0_n12_N4ee173fooEv)();
extern void ABISELECT(_ZThn16_N4ee173fooEv,_ZThn12_N4ee173fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4aa17__4ee17__4gg17[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee173fooEv,_ZTv0_n12_N4ee173fooEv),
};
static  VTT_ENTRY vtt_gg17[] = {
  {&(_ZTV4gg17[4]),  4,17},
  {&(_ZTV4gg17[12]),  12,17},
  {&(_ZTV4gg17[16]),  16,17},
  {&(_tg__ZTV4ee17__4gg17[3]),  3,4},
  {&(_tg__ZTV4aa17__4ee17__4gg17[3]),  3,4},
};
extern VTBL_ENTRY _ZTI4gg17[];
extern  VTBL_ENTRY _ZTV4gg17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg17[];
static VTBL_ENTRY alt_thunk_names42[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee173fooEv,_ZTv0_n12_N4ee173fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee173fooEv,_ZThn12_N4ee173fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg173fooEv,_ZTv0_n12_N4gg173fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4gg173fooEv,_ZThn36_N4gg173fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N4gg173fooEv,_ZTv0_n16_N4gg173fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N4gg173fooEv,_ZThn24_N4gg173fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg17 = {  "gg17", // class name
  bases_gg17, 6,
  &(vtc_gg17[0]), // expected_vtbl_contents
  &(vtt_gg17[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI4gg17),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg17),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg17),5, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names42,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa18  {
  int a;
   aa18(); // _ZN4aa18C1Ev
  virtual void  foo(); // _ZN4aa183fooEv
  ~aa18(); // tgen
};
//SIG(-1 aa18) C1{ v1 Fi}


 aa18 ::aa18(){ note_ctor("aa18", this);}
void  aa18 ::foo(){vfunc_called(this, "_ZN4aa183fooEv");}
aa18 ::~aa18(){ note_dtor("aa18", this);} // tgen

static void Test_aa18()
{
  extern Class_Descriptor cd_aa18;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa18, buf);
    aa18 *dp, &lv = *(dp=new (buf) aa18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa18)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa18.a");
    test_class_info(&lv, &cd_aa18);
    dp->~aa18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa18(Test_aa18, "aa18", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa18C1Ev();
extern void _ZN4aa18D1Ev();
Name_Map name_map_aa18[] = {
  NSPAIR(_ZN4aa18C1Ev),
  NSPAIR(_ZN4aa18D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa18[];
extern void _ZN4aa183fooEv();
static  VTBL_ENTRY vtc_aa18[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa18[0]),
  (VTBL_ENTRY)&_ZN4aa183fooEv,
};
extern VTBL_ENTRY _ZTI4aa18[];
extern  VTBL_ENTRY _ZTV4aa18[];
Class_Descriptor cd_aa18 = {  "aa18", // class name
  0,0,//no base classes
  &(vtc_aa18[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa18),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa18),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb18  {
  int b;
   bb18(); // _ZN4bb18C1Ev
  virtual void  foo(); // _ZN4bb183fooEv
  ~bb18(); // tgen
};
//SIG(-1 bb18) C1{ v1 Fi}


 bb18 ::bb18(){ note_ctor("bb18", this);}
void  bb18 ::foo(){vfunc_called(this, "_ZN4bb183fooEv");}
bb18 ::~bb18(){ note_dtor("bb18", this);} // tgen

static void Test_bb18()
{
  extern Class_Descriptor cd_bb18;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb18, buf);
    bb18 *dp, &lv = *(dp=new (buf) bb18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb18)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb18.b");
    test_class_info(&lv, &cd_bb18);
    dp->~bb18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb18(Test_bb18, "bb18", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb18C1Ev();
extern void _ZN4bb18D1Ev();
Name_Map name_map_bb18[] = {
  NSPAIR(_ZN4bb18C1Ev),
  NSPAIR(_ZN4bb18D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb18[];
extern void _ZN4bb183fooEv();
static  VTBL_ENTRY vtc_bb18[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb18[0]),
  (VTBL_ENTRY)&_ZN4bb183fooEv,
};
extern VTBL_ENTRY _ZTI4bb18[];
extern  VTBL_ENTRY _ZTV4bb18[];
Class_Descriptor cd_bb18 = {  "bb18", // class name
  0,0,//no base classes
  &(vtc_bb18[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb18),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb18),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc18  {
  int c;
   cc18(); // _ZN4cc18C1Ev
  virtual void  foo(); // _ZN4cc183fooEv
  ~cc18(); // tgen
};
//SIG(-1 cc18) C1{ v1 Fi}


 cc18 ::cc18(){ note_ctor("cc18", this);}
void  cc18 ::foo(){vfunc_called(this, "_ZN4cc183fooEv");}
cc18 ::~cc18(){ note_dtor("cc18", this);} // tgen

static void Test_cc18()
{
  extern Class_Descriptor cd_cc18;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc18, buf);
    cc18 *dp, &lv = *(dp=new (buf) cc18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc18)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc18.c");
    test_class_info(&lv, &cd_cc18);
    dp->~cc18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc18(Test_cc18, "cc18", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc18C1Ev();
extern void _ZN4cc18D1Ev();
Name_Map name_map_cc18[] = {
  NSPAIR(_ZN4cc18C1Ev),
  NSPAIR(_ZN4cc18D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc18[];
extern void _ZN4cc183fooEv();
static  VTBL_ENTRY vtc_cc18[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc18[0]),
  (VTBL_ENTRY)&_ZN4cc183fooEv,
};
extern VTBL_ENTRY _ZTI4cc18[];
extern  VTBL_ENTRY _ZTV4cc18[];
Class_Descriptor cd_cc18 = {  "cc18", // class name
  0,0,//no base classes
  &(vtc_cc18[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc18),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc18),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd18  {
  int d;
   dd18(); // _ZN4dd18C1Ev
  virtual void  foo(); // _ZN4dd183fooEv
  ~dd18(); // tgen
};
//SIG(-1 dd18) C1{ v1 Fi}


 dd18 ::dd18(){ note_ctor("dd18", this);}
void  dd18 ::foo(){vfunc_called(this, "_ZN4dd183fooEv");}
dd18 ::~dd18(){ note_dtor("dd18", this);} // tgen

static void Test_dd18()
{
  extern Class_Descriptor cd_dd18;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd18, buf);
    dd18 *dp, &lv = *(dp=new (buf) dd18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd18)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd18.d");
    test_class_info(&lv, &cd_dd18);
    dp->~dd18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd18(Test_dd18, "dd18", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd18C1Ev();
extern void _ZN4dd18D1Ev();
Name_Map name_map_dd18[] = {
  NSPAIR(_ZN4dd18C1Ev),
  NSPAIR(_ZN4dd18D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd18[];
extern void _ZN4dd183fooEv();
static  VTBL_ENTRY vtc_dd18[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd18[0]),
  (VTBL_ENTRY)&_ZN4dd183fooEv,
};
extern VTBL_ENTRY _ZTI4dd18[];
extern  VTBL_ENTRY _ZTV4dd18[];
Class_Descriptor cd_dd18 = {  "dd18", // class name
  0,0,//no base classes
  &(vtc_dd18[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd18),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd18),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee18  : aa18 , virtual bb18 {
  int e;
   ee18(const ABISELECT(__tsi64,int) *const *); // _ZN4ee18C2Ev
  virtual void  foo(); // _ZN4ee183fooEv
  ~ee18(); // tgen
  ee18(); // tgen
};
//SIG(-1 ee18) C1{ BC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ee18 ::ee18(const ABISELECT(__tsi64,int) *const *){}
void  ee18 ::foo(){vfunc_called(this, "_ZN4ee183fooEv");}
ee18 ::~ee18(){ note_dtor("ee18", this);} // tgen
ee18 ::ee18(){ note_ctor("ee18", this);} // tgen

static void Test_ee18()
{
  extern Class_Descriptor cd_ee18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee18, buf);
    ee18 *dp, &lv = *(dp=new (buf) ee18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee18)");
    check_base_class_offset(lv, (aa18*), 0, "ee18");
    check_base_class_offset(lv, (bb18*), ABISELECT(16,12), "ee18");
    check_field_offset(lv, e, ABISELECT(12,8), "ee18.e");
    test_class_info(&lv, &cd_ee18);
    dp->~ee18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee18(Test_ee18, "ee18", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ee18C1Ev();
extern void _ZN4ee18D1Ev();
Name_Map name_map_ee18[] = {
  NSPAIR(_ZN4ee18C1Ev),
  NSPAIR(_ZN4ee18D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa18;
extern VTBL_ENTRY _ZTI4aa18[];
extern  VTBL_ENTRY _ZTV4aa18[];
extern Class_Descriptor cd_bb18;
extern VTBL_ENTRY _ZTI4bb18[];
extern  VTBL_ENTRY _ZTV4bb18[];
static Base_Class bases_ee18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_bb18,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ee18[];
extern void _ZN4ee183fooEv();
extern void ABISELECT(_ZTv0_n24_N4ee183fooEv,_ZTv0_n12_N4ee183fooEv)();
extern void ABISELECT(_ZThn16_N4ee183fooEv,_ZThn12_N4ee183fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee18[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee18[0]),
  (VTBL_ENTRY)&_ZN4ee183fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee183fooEv,_ZTv0_n12_N4ee183fooEv),
};
extern VTBL_ENTRY _ZTV4ee18[];
static  VTT_ENTRY vtt_ee18[] = {
  {&(_ZTV4ee18[3]),  3,8},
  {&(_ZTV4ee18[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ee18[];
extern  VTBL_ENTRY _ZTV4ee18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee18[];
static VTBL_ENTRY alt_thunk_names43[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee183fooEv,_ZTv0_n12_N4ee183fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee183fooEv,_ZThn12_N4ee183fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee18 = {  "ee18", // class name
  bases_ee18, 2,
  &(vtc_ee18[0]), // expected_vtbl_contents
  &(vtt_ee18[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ee18),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee18),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ee18),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names43,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff18  : cc18 , dd18 {
  int f;
   ff18(); // _ZN4ff18C1Ev
  virtual void  foo(); // _ZN4ff183fooEv
  ~ff18(); // tgen
};
//SIG(-1 ff18) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ff18 ::ff18(){ note_ctor("ff18", this);}
void  ff18 ::foo(){vfunc_called(this, "_ZN4ff183fooEv");}
ff18 ::~ff18(){ note_dtor("ff18", this);} // tgen

static void Test_ff18()
{
  extern Class_Descriptor cd_ff18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff18, buf);
    ff18 *dp, &lv = *(dp=new (buf) ff18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff18)");
    check_base_class_offset(lv, (cc18*), 0, "ff18");
    check_base_class_offset(lv, (dd18*), ABISELECT(16,8), "ff18");
    check_field_offset(lv, f, ABISELECT(28,16), "ff18.f");
    test_class_info(&lv, &cd_ff18);
    dp->~ff18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff18(Test_ff18, "ff18", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ff18C1Ev();
extern void _ZN4ff18D1Ev();
Name_Map name_map_ff18[] = {
  NSPAIR(_ZN4ff18C1Ev),
  NSPAIR(_ZN4ff18D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc18;
extern VTBL_ENTRY _ZTI4cc18[];
extern  VTBL_ENTRY _ZTV4cc18[];
extern Class_Descriptor cd_dd18;
extern VTBL_ENTRY _ZTI4dd18[];
extern  VTBL_ENTRY _ZTV4dd18[];
static Base_Class bases_ff18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_dd18,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ff18[];
extern void _ZN4ff183fooEv();
extern void ABISELECT(_ZThn16_N4ff183fooEv,_ZThn8_N4ff183fooEv)();
static  VTBL_ENTRY vtc_ff18[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4ff18[0]),
  (VTBL_ENTRY)&_ZN4ff183fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ff18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4ff183fooEv,_ZThn8_N4ff183fooEv),
};
extern VTBL_ENTRY _ZTI4ff18[];
extern  VTBL_ENTRY _ZTV4ff18[];
Class_Descriptor cd_ff18 = {  "ff18", // class name
  bases_ff18, 2,
  &(vtc_ff18[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ff18),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff18),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg18  : virtual ee18 , ff18 {
  int g;
   gg18(const ABISELECT(__tsi64,int) *const *); // _ZN4gg18C2Ev
  virtual void  foo(); // _ZN4gg183fooEv
  ~gg18(); // tgen
  gg18(); // tgen
};
//SIG(1 gg18) C1{ VBC2{ BC3{ v1 Fi} VBC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 Fi} BC7{ v1 Fi} v1 Fi} v1 Fi}


 gg18 ::gg18(const ABISELECT(__tsi64,int) *const *){}
void  gg18 ::foo(){vfunc_called(this, "_ZN4gg183fooEv");}
gg18 ::~gg18(){ note_dtor("gg18", this);} // tgen
gg18 ::gg18(){ note_ctor("gg18", this);} // tgen

static void Test_gg18()
{
  extern Class_Descriptor cd_gg18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg18, buf);
    gg18 *dp, &lv = *(dp=new (buf) gg18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg18)");
    check_base_class_offset(lv, (aa18*)(ee18*), ABISELECT(40,24), "gg18");
    check_base_class_offset(lv, (bb18*)(ee18*), ABISELECT(56,36), "gg18");
    check_base_class_offset(lv, (ee18*), ABISELECT(40,24), "gg18");
    check_base_class_offset(lv, (cc18*)(ff18*), 0, "gg18");
    check_base_class_offset(lv, (dd18*)(ff18*), ABISELECT(16,8), "gg18");
    check_base_class_offset(lv, (ff18*), 0, "gg18");
    check_field_offset(lv, g, ABISELECT(32,20), "gg18.g");
    test_class_info(&lv, &cd_gg18);
    dp->~gg18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg18(Test_gg18, "gg18", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN4gg18C1Ev();
extern void _ZN4gg18D1Ev();
Name_Map name_map_gg18[] = {
  NSPAIR(_ZN4gg18C1Ev),
  NSPAIR(_ZN4gg18D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa18;
extern VTBL_ENTRY _ZTI4aa18[];
extern  VTBL_ENTRY _ZTV4aa18[];
extern Class_Descriptor cd_bb18;
extern VTBL_ENTRY _ZTI4bb18[];
extern  VTBL_ENTRY _ZTV4bb18[];
extern Class_Descriptor cd_ee18;
extern VTBL_ENTRY _ZTI4ee18[];
extern  VTBL_ENTRY _ZTV4ee18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee18[];
extern Class_Descriptor cd_cc18;
extern VTBL_ENTRY _ZTI4cc18[];
extern  VTBL_ENTRY _ZTV4cc18[];
extern Class_Descriptor cd_dd18;
extern VTBL_ENTRY _ZTI4dd18[];
extern  VTBL_ENTRY _ZTV4dd18[];
extern Class_Descriptor cd_ff18;
extern VTBL_ENTRY _ZTI4ff18[];
extern  VTBL_ENTRY _ZTV4ff18[];
static Base_Class bases_gg18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa18,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_bb18,    ABISELECT(56,36), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_ee18,    ABISELECT(40,24), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_cc18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_dd18,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_ff18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4gg18[];
extern void _ZN4gg183fooEv();
extern void ABISELECT(_ZThn16_N4gg183fooEv,_ZThn8_N4gg183fooEv)();
extern void ABISELECT(_ZTv0_n32_N4gg183fooEv,_ZTv0_n16_N4gg183fooEv)();
extern void ABISELECT(_ZThn40_N4gg183fooEv,_ZThn24_N4gg183fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg183fooEv,_ZTv0_n12_N4gg183fooEv)();
extern void ABISELECT(_ZThn56_N4gg183fooEv,_ZThn36_N4gg183fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg18[] = {
  ABISELECT(56,36),
  ABISELECT(40,24),
  0,
  (VTBL_ENTRY)&(_ZTI4gg18[0]),
  (VTBL_ENTRY)&_ZN4gg183fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4gg18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4gg183fooEv,_ZThn8_N4gg183fooEv),
  ABISELECT(-40,-24),
  ABISELECT(16,12),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI4gg18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N4gg183fooEv,_ZTv0_n16_N4gg183fooEv),
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI4gg18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg183fooEv,_ZTv0_n12_N4gg183fooEv),
};
extern VTBL_ENTRY _ZTV4gg18[];
extern void _ZN4ee183fooEv();
static  VTBL_ENTRY _tg__ZTV4ee18__4gg18[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee18[0]),
  (VTBL_ENTRY)&_ZN4ee183fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ee183fooEv,_ZTv0_n12_N4ee183fooEv)();
extern void ABISELECT(_ZThn16_N4ee183fooEv,_ZThn12_N4ee183fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb18__4ee18__4gg18[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee18[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee183fooEv,_ZTv0_n12_N4ee183fooEv),
};
static  VTT_ENTRY vtt_gg18[] = {
  {&(_ZTV4gg18[4]),  4,17},
  {&(_ZTV4gg18[12]),  12,17},
  {&(_ZTV4gg18[16]),  16,17},
  {&(_tg__ZTV4ee18__4gg18[3]),  3,4},
  {&(_tg__ZTV4bb18__4ee18__4gg18[3]),  3,4},
};
extern VTBL_ENTRY _ZTI4gg18[];
extern  VTBL_ENTRY _ZTV4gg18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg18[];
static VTBL_ENTRY alt_thunk_names44[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee183fooEv,_ZTv0_n12_N4ee183fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee183fooEv,_ZThn12_N4ee183fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg183fooEv,_ZTv0_n12_N4gg183fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4gg183fooEv,_ZThn36_N4gg183fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N4gg183fooEv,_ZTv0_n16_N4gg183fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N4gg183fooEv,_ZThn24_N4gg183fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg18 = {  "gg18", // class name
  bases_gg18, 6,
  &(vtc_gg18[0]), // expected_vtbl_contents
  &(vtt_gg18[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI4gg18),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg18),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg18),5, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names44,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa19  {
  int a;
   aa19(); // _ZN4aa19C1Ev
  virtual void  foo(); // _ZN4aa193fooEv
  ~aa19(); // tgen
};
//SIG(-1 aa19) C1{ v1 Fi}


 aa19 ::aa19(){ note_ctor("aa19", this);}
void  aa19 ::foo(){vfunc_called(this, "_ZN4aa193fooEv");}
aa19 ::~aa19(){ note_dtor("aa19", this);} // tgen

static void Test_aa19()
{
  extern Class_Descriptor cd_aa19;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa19, buf);
    aa19 *dp, &lv = *(dp=new (buf) aa19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa19)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa19.a");
    test_class_info(&lv, &cd_aa19);
    dp->~aa19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa19(Test_aa19, "aa19", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa19C1Ev();
extern void _ZN4aa19D1Ev();
Name_Map name_map_aa19[] = {
  NSPAIR(_ZN4aa19C1Ev),
  NSPAIR(_ZN4aa19D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa19[];
extern void _ZN4aa193fooEv();
static  VTBL_ENTRY vtc_aa19[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa19[0]),
  (VTBL_ENTRY)&_ZN4aa193fooEv,
};
extern VTBL_ENTRY _ZTI4aa19[];
extern  VTBL_ENTRY _ZTV4aa19[];
Class_Descriptor cd_aa19 = {  "aa19", // class name
  0,0,//no base classes
  &(vtc_aa19[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa19),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa19),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb19  {
  int b;
   bb19(); // _ZN4bb19C1Ev
  virtual void  foo(); // _ZN4bb193fooEv
  ~bb19(); // tgen
};
//SIG(-1 bb19) C1{ v1 Fi}


 bb19 ::bb19(){ note_ctor("bb19", this);}
void  bb19 ::foo(){vfunc_called(this, "_ZN4bb193fooEv");}
bb19 ::~bb19(){ note_dtor("bb19", this);} // tgen

static void Test_bb19()
{
  extern Class_Descriptor cd_bb19;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb19, buf);
    bb19 *dp, &lv = *(dp=new (buf) bb19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb19)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb19.b");
    test_class_info(&lv, &cd_bb19);
    dp->~bb19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb19(Test_bb19, "bb19", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb19C1Ev();
extern void _ZN4bb19D1Ev();
Name_Map name_map_bb19[] = {
  NSPAIR(_ZN4bb19C1Ev),
  NSPAIR(_ZN4bb19D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb19[];
extern void _ZN4bb193fooEv();
static  VTBL_ENTRY vtc_bb19[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb19[0]),
  (VTBL_ENTRY)&_ZN4bb193fooEv,
};
extern VTBL_ENTRY _ZTI4bb19[];
extern  VTBL_ENTRY _ZTV4bb19[];
Class_Descriptor cd_bb19 = {  "bb19", // class name
  0,0,//no base classes
  &(vtc_bb19[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb19),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb19),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc19  {
  int c;
   cc19(); // _ZN4cc19C1Ev
  virtual void  foo(); // _ZN4cc193fooEv
  ~cc19(); // tgen
};
//SIG(-1 cc19) C1{ v1 Fi}


 cc19 ::cc19(){ note_ctor("cc19", this);}
void  cc19 ::foo(){vfunc_called(this, "_ZN4cc193fooEv");}
cc19 ::~cc19(){ note_dtor("cc19", this);} // tgen

static void Test_cc19()
{
  extern Class_Descriptor cd_cc19;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc19, buf);
    cc19 *dp, &lv = *(dp=new (buf) cc19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc19)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc19.c");
    test_class_info(&lv, &cd_cc19);
    dp->~cc19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc19(Test_cc19, "cc19", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc19C1Ev();
extern void _ZN4cc19D1Ev();
Name_Map name_map_cc19[] = {
  NSPAIR(_ZN4cc19C1Ev),
  NSPAIR(_ZN4cc19D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc19[];
extern void _ZN4cc193fooEv();
static  VTBL_ENTRY vtc_cc19[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc19[0]),
  (VTBL_ENTRY)&_ZN4cc193fooEv,
};
extern VTBL_ENTRY _ZTI4cc19[];
extern  VTBL_ENTRY _ZTV4cc19[];
Class_Descriptor cd_cc19 = {  "cc19", // class name
  0,0,//no base classes
  &(vtc_cc19[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc19),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc19),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd19  {
  int d;
   dd19(); // _ZN4dd19C1Ev
  virtual void  foo(); // _ZN4dd193fooEv
  ~dd19(); // tgen
};
//SIG(-1 dd19) C1{ v1 Fi}


 dd19 ::dd19(){ note_ctor("dd19", this);}
void  dd19 ::foo(){vfunc_called(this, "_ZN4dd193fooEv");}
dd19 ::~dd19(){ note_dtor("dd19", this);} // tgen

static void Test_dd19()
{
  extern Class_Descriptor cd_dd19;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd19, buf);
    dd19 *dp, &lv = *(dp=new (buf) dd19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd19)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd19.d");
    test_class_info(&lv, &cd_dd19);
    dp->~dd19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd19(Test_dd19, "dd19", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd19C1Ev();
extern void _ZN4dd19D1Ev();
Name_Map name_map_dd19[] = {
  NSPAIR(_ZN4dd19C1Ev),
  NSPAIR(_ZN4dd19D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd19[];
extern void _ZN4dd193fooEv();
static  VTBL_ENTRY vtc_dd19[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd19[0]),
  (VTBL_ENTRY)&_ZN4dd193fooEv,
};
extern VTBL_ENTRY _ZTI4dd19[];
extern  VTBL_ENTRY _ZTV4dd19[];
Class_Descriptor cd_dd19 = {  "dd19", // class name
  0,0,//no base classes
  &(vtc_dd19[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd19),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd19),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee19  : virtual aa19 , virtual bb19 {
  int e;
   ee19(const ABISELECT(__tsi64,int) *const *); // _ZN4ee19C2Ev
  virtual void  foo(); // _ZN4ee193fooEv
  ~ee19(); // tgen
  ee19(); // tgen
};
//SIG(-1 ee19) C1{ VBC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ee19 ::ee19(const ABISELECT(__tsi64,int) *const *){}
void  ee19 ::foo(){vfunc_called(this, "_ZN4ee193fooEv");}
ee19 ::~ee19(){ note_dtor("ee19", this);} // tgen
ee19 ::ee19(){ note_ctor("ee19", this);} // tgen

static void Test_ee19()
{
  extern Class_Descriptor cd_ee19;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_ee19, buf);
    ee19 *dp, &lv = *(dp=new (buf) ee19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(ee19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee19)");
    check_base_class_offset(lv, (aa19*), ABISELECT(16,8), "ee19");
    check_base_class_offset(lv, (bb19*), ABISELECT(32,16), "ee19");
    check_field_offset(lv, e, ABISELECT(8,4), "ee19.e");
    test_class_info(&lv, &cd_ee19);
    dp->~ee19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee19(Test_ee19, "ee19", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN4ee19C1Ev();
extern void _ZN4ee19D1Ev();
Name_Map name_map_ee19[] = {
  NSPAIR(_ZN4ee19C1Ev),
  NSPAIR(_ZN4ee19D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa19;
extern VTBL_ENTRY _ZTI4aa19[];
extern  VTBL_ENTRY _ZTV4aa19[];
extern Class_Descriptor cd_bb19;
extern VTBL_ENTRY _ZTI4bb19[];
extern  VTBL_ENTRY _ZTV4bb19[];
static Base_Class bases_ee19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa19,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_bb19,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ee19[];
extern void _ZN4ee193fooEv();
extern void ABISELECT(_ZTv0_n24_N4ee193fooEv,_ZTv0_n12_N4ee193fooEv)();
extern void ABISELECT(_ZThn16_N4ee193fooEv,_ZThn8_N4ee193fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4ee193fooEv,_ZTv0_n12_N4ee193fooEv)();
extern void ABISELECT(_ZThn32_N4ee193fooEv,_ZThn16_N4ee193fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee19[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI4ee19[0]),
  (VTBL_ENTRY)&_ZN4ee193fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ee19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee193fooEv,_ZTv0_n12_N4ee193fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI4ee19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee193fooEv,_ZTv0_n12_N4ee193fooEv),
};
extern VTBL_ENTRY _ZTV4ee19[];
static  VTT_ENTRY vtt_ee19[] = {
  {&(_ZTV4ee19[4]),  4,13},
  {&(_ZTV4ee19[8]),  8,13},
  {&(_ZTV4ee19[12]),  12,13},
};
extern VTBL_ENTRY _ZTI4ee19[];
extern  VTBL_ENTRY _ZTV4ee19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee19[];
static VTBL_ENTRY alt_thunk_names45[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee193fooEv,_ZTv0_n12_N4ee193fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ee193fooEv,_ZThn16_N4ee193fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee193fooEv,_ZThn8_N4ee193fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee19 = {  "ee19", // class name
  bases_ee19, 2,
  &(vtc_ee19[0]), // expected_vtbl_contents
  &(vtt_ee19[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI4ee19),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee19),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ee19),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names45,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff19  : cc19 , dd19 {
  int f;
   ff19(); // _ZN4ff19C1Ev
  virtual void  foo(); // _ZN4ff193fooEv
  ~ff19(); // tgen
};
//SIG(-1 ff19) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ff19 ::ff19(){ note_ctor("ff19", this);}
void  ff19 ::foo(){vfunc_called(this, "_ZN4ff193fooEv");}
ff19 ::~ff19(){ note_dtor("ff19", this);} // tgen

static void Test_ff19()
{
  extern Class_Descriptor cd_ff19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff19, buf);
    ff19 *dp, &lv = *(dp=new (buf) ff19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff19)");
    check_base_class_offset(lv, (cc19*), 0, "ff19");
    check_base_class_offset(lv, (dd19*), ABISELECT(16,8), "ff19");
    check_field_offset(lv, f, ABISELECT(28,16), "ff19.f");
    test_class_info(&lv, &cd_ff19);
    dp->~ff19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff19(Test_ff19, "ff19", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ff19C1Ev();
extern void _ZN4ff19D1Ev();
Name_Map name_map_ff19[] = {
  NSPAIR(_ZN4ff19C1Ev),
  NSPAIR(_ZN4ff19D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc19;
extern VTBL_ENTRY _ZTI4cc19[];
extern  VTBL_ENTRY _ZTV4cc19[];
extern Class_Descriptor cd_dd19;
extern VTBL_ENTRY _ZTI4dd19[];
extern  VTBL_ENTRY _ZTV4dd19[];
static Base_Class bases_ff19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_dd19,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ff19[];
extern void _ZN4ff193fooEv();
extern void ABISELECT(_ZThn16_N4ff193fooEv,_ZThn8_N4ff193fooEv)();
static  VTBL_ENTRY vtc_ff19[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4ff19[0]),
  (VTBL_ENTRY)&_ZN4ff193fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ff19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4ff193fooEv,_ZThn8_N4ff193fooEv),
};
extern VTBL_ENTRY _ZTI4ff19[];
extern  VTBL_ENTRY _ZTV4ff19[];
Class_Descriptor cd_ff19 = {  "ff19", // class name
  bases_ff19, 2,
  &(vtc_ff19[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ff19),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff19),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg19  : virtual ee19 , ff19 {
  int g;
   gg19(const ABISELECT(__tsi64,int) *const *); // _ZN4gg19C2Ev
  virtual void  foo(); // _ZN4gg193fooEv
  ~gg19(); // tgen
  gg19(); // tgen
};
//SIG(1 gg19) C1{ VBC2{ VBC3{ v1 Fi} VBC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 Fi} BC7{ v1 Fi} v1 Fi} v1 Fi}


 gg19 ::gg19(const ABISELECT(__tsi64,int) *const *){}
void  gg19 ::foo(){vfunc_called(this, "_ZN4gg193fooEv");}
gg19 ::~gg19(){ note_dtor("gg19", this);} // tgen
gg19 ::gg19(){ note_ctor("gg19", this);} // tgen

static void Test_gg19()
{
  extern Class_Descriptor cd_gg19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(12,13)];
    init_test(&cd_gg19, buf);
    gg19 *dp, &lv = *(dp=new (buf) gg19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(88,48), "sizeof(gg19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg19)");
    check_base_class_offset(lv, (aa19*)(ee19*), ABISELECT(56,32), "gg19");
    check_base_class_offset(lv, (bb19*)(ee19*), ABISELECT(72,40), "gg19");
    check_base_class_offset(lv, (ee19*), ABISELECT(40,24), "gg19");
    check_base_class_offset(lv, (cc19*)(ff19*), 0, "gg19");
    check_base_class_offset(lv, (dd19*)(ff19*), ABISELECT(16,8), "gg19");
    check_base_class_offset(lv, (ff19*), 0, "gg19");
    check_field_offset(lv, g, ABISELECT(32,20), "gg19.g");
    test_class_info(&lv, &cd_gg19);
    dp->~gg19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg19(Test_gg19, "gg19", ABISELECT(88,48));

#else // __cplusplus

extern void _ZN4gg19C1Ev();
extern void _ZN4gg19D1Ev();
Name_Map name_map_gg19[] = {
  NSPAIR(_ZN4gg19C1Ev),
  NSPAIR(_ZN4gg19D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa19;
extern VTBL_ENTRY _ZTI4aa19[];
extern  VTBL_ENTRY _ZTV4aa19[];
extern Class_Descriptor cd_bb19;
extern VTBL_ENTRY _ZTI4bb19[];
extern  VTBL_ENTRY _ZTV4bb19[];
extern Class_Descriptor cd_ee19;
extern VTBL_ENTRY _ZTI4ee19[];
extern  VTBL_ENTRY _ZTV4ee19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee19[];
extern Class_Descriptor cd_cc19;
extern VTBL_ENTRY _ZTI4cc19[];
extern  VTBL_ENTRY _ZTV4cc19[];
extern Class_Descriptor cd_dd19;
extern VTBL_ENTRY _ZTI4dd19[];
extern  VTBL_ENTRY _ZTV4dd19[];
extern Class_Descriptor cd_ff19;
extern VTBL_ENTRY _ZTI4ff19[];
extern  VTBL_ENTRY _ZTV4ff19[];
static Base_Class bases_gg19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa19,    ABISELECT(56,32), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_bb19,    ABISELECT(72,40), //bcp->offset
    19, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_ee19,    ABISELECT(40,24), //bcp->offset
    9, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_cc19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_dd19,    ABISELECT(16,8), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_ff19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4gg19[];
extern void _ZN4gg193fooEv();
extern void ABISELECT(_ZThn16_N4gg193fooEv,_ZThn8_N4gg193fooEv)();
extern void ABISELECT(_ZTv0_n40_N4gg193fooEv,_ZTv0_n20_N4gg193fooEv)();
extern void ABISELECT(_ZThn40_N4gg193fooEv,_ZThn24_N4gg193fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg193fooEv,_ZTv0_n12_N4gg193fooEv)();
extern void ABISELECT(_ZThn56_N4gg193fooEv,_ZThn32_N4gg193fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg193fooEv,_ZTv0_n12_N4gg193fooEv)();
extern void ABISELECT(_ZThn72_N4gg193fooEv,_ZThn40_N4gg193fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg19[] = {
  ABISELECT(72,40),
  ABISELECT(56,32),
  ABISELECT(40,24),
  0,
  (VTBL_ENTRY)&(_ZTI4gg19[0]),
  (VTBL_ENTRY)&_ZN4gg193fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4gg19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4gg193fooEv,_ZThn8_N4gg193fooEv),
  ABISELECT(-40,-24),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI4gg19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N4gg193fooEv,_ZTv0_n20_N4gg193fooEv),
  ABISELECT(-56,-32),
  ABISELECT(-56,-32),
  (VTBL_ENTRY)&(_ZTI4gg19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg193fooEv,_ZTv0_n12_N4gg193fooEv),
  ABISELECT(-72,-40),
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI4gg19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg193fooEv,_ZTv0_n12_N4gg193fooEv),
};
extern VTBL_ENTRY _ZTV4gg19[];
extern void _ZN4ee193fooEv();
static  VTBL_ENTRY _tg__ZTV4ee19__4gg19[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI4ee19[0]),
  (VTBL_ENTRY)&_ZN4ee193fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ee193fooEv,_ZTv0_n12_N4ee193fooEv)();
extern void ABISELECT(_ZThn16_N4ee193fooEv,_ZThn8_N4ee193fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4aa19__4ee19__4gg19[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ee19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee193fooEv,_ZTv0_n12_N4ee193fooEv),
};
extern void ABISELECT(_ZTv0_n24_N4ee193fooEv,_ZTv0_n12_N4ee193fooEv)();
extern void ABISELECT(_ZThn32_N4ee193fooEv,_ZThn16_N4ee193fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb19__4ee19__4gg19[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI4ee19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee193fooEv,_ZTv0_n12_N4ee193fooEv),
};
static  VTT_ENTRY vtt_gg19[] = {
  {&(_ZTV4gg19[5]),  5,23},
  {&(_ZTV4gg19[14]),  14,23},
  {&(_ZTV4gg19[18]),  18,23},
  {&(_ZTV4gg19[22]),  22,23},
  {&(_tg__ZTV4ee19__4gg19[4]),  4,5},
  {&(_tg__ZTV4aa19__4ee19__4gg19[3]),  3,4},
  {&(_tg__ZTV4bb19__4ee19__4gg19[3]),  3,4},
};
extern VTBL_ENTRY _ZTI4gg19[];
extern  VTBL_ENTRY _ZTV4gg19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg19[];
static VTBL_ENTRY alt_thunk_names46[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee193fooEv,_ZTv0_n12_N4ee193fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ee193fooEv,_ZThn16_N4ee193fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee193fooEv,_ZThn8_N4ee193fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg193fooEv,_ZTv0_n12_N4gg193fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N4gg193fooEv,_ZThn40_N4gg193fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4gg193fooEv,_ZThn32_N4gg193fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N4gg193fooEv,_ZTv0_n20_N4gg193fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N4gg193fooEv,_ZThn24_N4gg193fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg19 = {  "gg19", // class name
  bases_gg19, 6,
  &(vtc_gg19[0]), // expected_vtbl_contents
  &(vtt_gg19[0]), // expected_vtt_contents
  ABISELECT(88,48), // object size
  NSPAIRA(_ZTI4gg19),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg19),23, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg19),7, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names46,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa20  {
  int a;
   aa20(); // _ZN4aa20C1Ev
  virtual void  foo(); // _ZN4aa203fooEv
  ~aa20(); // tgen
};
//SIG(-1 aa20) C1{ v1 Fi}


 aa20 ::aa20(){ note_ctor("aa20", this);}
void  aa20 ::foo(){vfunc_called(this, "_ZN4aa203fooEv");}
aa20 ::~aa20(){ note_dtor("aa20", this);} // tgen

static void Test_aa20()
{
  extern Class_Descriptor cd_aa20;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa20, buf);
    aa20 *dp, &lv = *(dp=new (buf) aa20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa20)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa20.a");
    test_class_info(&lv, &cd_aa20);
    dp->~aa20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa20(Test_aa20, "aa20", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa20C1Ev();
extern void _ZN4aa20D1Ev();
Name_Map name_map_aa20[] = {
  NSPAIR(_ZN4aa20C1Ev),
  NSPAIR(_ZN4aa20D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa20[];
extern void _ZN4aa203fooEv();
static  VTBL_ENTRY vtc_aa20[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa20[0]),
  (VTBL_ENTRY)&_ZN4aa203fooEv,
};
extern VTBL_ENTRY _ZTI4aa20[];
extern  VTBL_ENTRY _ZTV4aa20[];
Class_Descriptor cd_aa20 = {  "aa20", // class name
  0,0,//no base classes
  &(vtc_aa20[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa20),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa20),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb20  {
  int b;
   bb20(); // _ZN4bb20C1Ev
  virtual void  foo(); // _ZN4bb203fooEv
  ~bb20(); // tgen
};
//SIG(-1 bb20) C1{ v1 Fi}


 bb20 ::bb20(){ note_ctor("bb20", this);}
void  bb20 ::foo(){vfunc_called(this, "_ZN4bb203fooEv");}
bb20 ::~bb20(){ note_dtor("bb20", this);} // tgen

static void Test_bb20()
{
  extern Class_Descriptor cd_bb20;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb20, buf);
    bb20 *dp, &lv = *(dp=new (buf) bb20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb20)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb20.b");
    test_class_info(&lv, &cd_bb20);
    dp->~bb20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb20(Test_bb20, "bb20", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb20C1Ev();
extern void _ZN4bb20D1Ev();
Name_Map name_map_bb20[] = {
  NSPAIR(_ZN4bb20C1Ev),
  NSPAIR(_ZN4bb20D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb20[];
extern void _ZN4bb203fooEv();
static  VTBL_ENTRY vtc_bb20[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb20[0]),
  (VTBL_ENTRY)&_ZN4bb203fooEv,
};
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
Class_Descriptor cd_bb20 = {  "bb20", // class name
  0,0,//no base classes
  &(vtc_bb20[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb20),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb20),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc20  {
  int c;
   cc20(); // _ZN4cc20C1Ev
  virtual void  foo(); // _ZN4cc203fooEv
  ~cc20(); // tgen
};
//SIG(-1 cc20) C1{ v1 Fi}


 cc20 ::cc20(){ note_ctor("cc20", this);}
void  cc20 ::foo(){vfunc_called(this, "_ZN4cc203fooEv");}
cc20 ::~cc20(){ note_dtor("cc20", this);} // tgen

static void Test_cc20()
{
  extern Class_Descriptor cd_cc20;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc20, buf);
    cc20 *dp, &lv = *(dp=new (buf) cc20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc20)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc20.c");
    test_class_info(&lv, &cd_cc20);
    dp->~cc20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc20(Test_cc20, "cc20", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc20C1Ev();
extern void _ZN4cc20D1Ev();
Name_Map name_map_cc20[] = {
  NSPAIR(_ZN4cc20C1Ev),
  NSPAIR(_ZN4cc20D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc20[];
extern void _ZN4cc203fooEv();
static  VTBL_ENTRY vtc_cc20[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc20[0]),
  (VTBL_ENTRY)&_ZN4cc203fooEv,
};
extern VTBL_ENTRY _ZTI4cc20[];
extern  VTBL_ENTRY _ZTV4cc20[];
Class_Descriptor cd_cc20 = {  "cc20", // class name
  0,0,//no base classes
  &(vtc_cc20[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc20),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc20),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd20  {
  int d;
   dd20(); // _ZN4dd20C1Ev
  virtual void  foo(); // _ZN4dd203fooEv
  ~dd20(); // tgen
};
//SIG(-1 dd20) C1{ v1 Fi}


 dd20 ::dd20(){ note_ctor("dd20", this);}
void  dd20 ::foo(){vfunc_called(this, "_ZN4dd203fooEv");}
dd20 ::~dd20(){ note_dtor("dd20", this);} // tgen

static void Test_dd20()
{
  extern Class_Descriptor cd_dd20;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd20, buf);
    dd20 *dp, &lv = *(dp=new (buf) dd20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd20)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd20.d");
    test_class_info(&lv, &cd_dd20);
    dp->~dd20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd20(Test_dd20, "dd20", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd20C1Ev();
extern void _ZN4dd20D1Ev();
Name_Map name_map_dd20[] = {
  NSPAIR(_ZN4dd20C1Ev),
  NSPAIR(_ZN4dd20D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd20[];
extern void _ZN4dd203fooEv();
static  VTBL_ENTRY vtc_dd20[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd20[0]),
  (VTBL_ENTRY)&_ZN4dd203fooEv,
};
extern VTBL_ENTRY _ZTI4dd20[];
extern  VTBL_ENTRY _ZTV4dd20[];
Class_Descriptor cd_dd20 = {  "dd20", // class name
  0,0,//no base classes
  &(vtc_dd20[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd20),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd20),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee20  : aa20 , bb20 {
  int e;
   ee20(); // _ZN4ee20C1Ev
  virtual void  foo(); // _ZN4ee203fooEv
  ~ee20(); // tgen
};
//SIG(-1 ee20) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ee20 ::ee20(){ note_ctor("ee20", this);}
void  ee20 ::foo(){vfunc_called(this, "_ZN4ee203fooEv");}
ee20 ::~ee20(){ note_dtor("ee20", this);} // tgen

static void Test_ee20()
{
  extern Class_Descriptor cd_ee20;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee20, buf);
    ee20 *dp, &lv = *(dp=new (buf) ee20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee20)");
    check_base_class_offset(lv, (aa20*), 0, "ee20");
    check_base_class_offset(lv, (bb20*), ABISELECT(16,8), "ee20");
    check_field_offset(lv, e, ABISELECT(28,16), "ee20.e");
    test_class_info(&lv, &cd_ee20);
    dp->~ee20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee20(Test_ee20, "ee20", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ee20C1Ev();
extern void _ZN4ee20D1Ev();
Name_Map name_map_ee20[] = {
  NSPAIR(_ZN4ee20C1Ev),
  NSPAIR(_ZN4ee20D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa20;
extern VTBL_ENTRY _ZTI4aa20[];
extern  VTBL_ENTRY _ZTV4aa20[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
static Base_Class bases_ee20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_bb20,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ee20[];
extern void _ZN4ee203fooEv();
extern void ABISELECT(_ZThn16_N4ee203fooEv,_ZThn8_N4ee203fooEv)();
static  VTBL_ENTRY vtc_ee20[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4ee20[0]),
  (VTBL_ENTRY)&_ZN4ee203fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ee20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4ee203fooEv,_ZThn8_N4ee203fooEv),
};
extern VTBL_ENTRY _ZTI4ee20[];
extern  VTBL_ENTRY _ZTV4ee20[];
Class_Descriptor cd_ee20 = {  "ee20", // class name
  bases_ee20, 2,
  &(vtc_ee20[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ee20),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee20),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff20  : virtual cc20 , dd20 {
  int f;
   ff20(const ABISELECT(__tsi64,int) *const *); // _ZN4ff20C2Ev
  virtual void  foo(); // _ZN4ff203fooEv
  ~ff20(); // tgen
  ff20(); // tgen
};
//SIG(-1 ff20) C1{ VBC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ff20 ::ff20(const ABISELECT(__tsi64,int) *const *){}
void  ff20 ::foo(){vfunc_called(this, "_ZN4ff203fooEv");}
ff20 ::~ff20(){ note_dtor("ff20", this);} // tgen
ff20 ::ff20(){ note_ctor("ff20", this);} // tgen

static void Test_ff20()
{
  extern Class_Descriptor cd_ff20;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff20, buf);
    ff20 *dp, &lv = *(dp=new (buf) ff20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff20)");
    check_base_class_offset(lv, (cc20*), ABISELECT(16,12), "ff20");
    check_base_class_offset(lv, (dd20*), 0, "ff20");
    check_field_offset(lv, f, ABISELECT(12,8), "ff20.f");
    test_class_info(&lv, &cd_ff20);
    dp->~ff20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff20(Test_ff20, "ff20", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ff20C1Ev();
extern void _ZN4ff20D1Ev();
Name_Map name_map_ff20[] = {
  NSPAIR(_ZN4ff20C1Ev),
  NSPAIR(_ZN4ff20D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc20;
extern VTBL_ENTRY _ZTI4cc20[];
extern  VTBL_ENTRY _ZTV4cc20[];
extern Class_Descriptor cd_dd20;
extern VTBL_ENTRY _ZTI4dd20[];
extern  VTBL_ENTRY _ZTV4dd20[];
static Base_Class bases_ff20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc20,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_dd20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ff20[];
extern void _ZN4ff203fooEv();
extern void ABISELECT(_ZTv0_n24_N4ff203fooEv,_ZTv0_n12_N4ff203fooEv)();
extern void ABISELECT(_ZThn16_N4ff203fooEv,_ZThn12_N4ff203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff20[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff20[0]),
  (VTBL_ENTRY)&_ZN4ff203fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff203fooEv,_ZTv0_n12_N4ff203fooEv),
};
extern VTBL_ENTRY _ZTV4ff20[];
static  VTT_ENTRY vtt_ff20[] = {
  {&(_ZTV4ff20[3]),  3,8},
  {&(_ZTV4ff20[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ff20[];
extern  VTBL_ENTRY _ZTV4ff20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff20[];
static VTBL_ENTRY alt_thunk_names47[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff203fooEv,_ZTv0_n12_N4ff203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff203fooEv,_ZThn12_N4ff203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff20 = {  "ff20", // class name
  bases_ff20, 2,
  &(vtc_ff20[0]), // expected_vtbl_contents
  &(vtt_ff20[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ff20),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff20),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ff20),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names47,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg20  : virtual ee20 , ff20 {
  int g;
   gg20(const ABISELECT(__tsi64,int) *const *); // _ZN4gg20C2Ev
  virtual void  foo(); // _ZN4gg203fooEv
  ~gg20(); // tgen
  gg20(); // tgen
};
//SIG(1 gg20) C1{ VBC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ VBC6{ v1 Fi} BC7{ v1 Fi} v1 Fi} v1 Fi}


 gg20 ::gg20(const ABISELECT(__tsi64,int) *const *){}
void  gg20 ::foo(){vfunc_called(this, "_ZN4gg203fooEv");}
gg20 ::~gg20(){ note_dtor("gg20", this);} // tgen
gg20 ::gg20(){ note_ctor("gg20", this);} // tgen

static void Test_gg20()
{
  extern Class_Descriptor cd_gg20;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg20, buf);
    gg20 *dp, &lv = *(dp=new (buf) gg20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg20)");
    check_base_class_offset(lv, (aa20*)(ee20*), ABISELECT(24,16), "gg20");
    check_base_class_offset(lv, (bb20*)(ee20*), ABISELECT(40,24), "gg20");
    check_base_class_offset(lv, (ee20*), ABISELECT(24,16), "gg20");
    check_base_class_offset(lv, (cc20*)(ff20*), ABISELECT(56,36), "gg20");
    check_base_class_offset(lv, (dd20*)(ff20*), 0, "gg20");
    check_base_class_offset(lv, (ff20*), 0, "gg20");
    check_field_offset(lv, g, ABISELECT(16,12), "gg20.g");
    test_class_info(&lv, &cd_gg20);
    dp->~gg20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg20(Test_gg20, "gg20", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN4gg20C1Ev();
extern void _ZN4gg20D1Ev();
Name_Map name_map_gg20[] = {
  NSPAIR(_ZN4gg20C1Ev),
  NSPAIR(_ZN4gg20D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa20;
extern VTBL_ENTRY _ZTI4aa20[];
extern  VTBL_ENTRY _ZTV4aa20[];
extern Class_Descriptor cd_bb20;
extern VTBL_ENTRY _ZTI4bb20[];
extern  VTBL_ENTRY _ZTV4bb20[];
extern Class_Descriptor cd_ee20;
extern VTBL_ENTRY _ZTI4ee20[];
extern  VTBL_ENTRY _ZTV4ee20[];
extern Class_Descriptor cd_cc20;
extern VTBL_ENTRY _ZTI4cc20[];
extern  VTBL_ENTRY _ZTV4cc20[];
extern Class_Descriptor cd_dd20;
extern VTBL_ENTRY _ZTI4dd20[];
extern  VTBL_ENTRY _ZTV4dd20[];
extern Class_Descriptor cd_ff20;
extern VTBL_ENTRY _ZTI4ff20[];
extern  VTBL_ENTRY _ZTV4ff20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff20[];
static Base_Class bases_gg20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa20,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_bb20,    ABISELECT(40,24), //bcp->offset
    9, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_ee20,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_cc20,    ABISELECT(56,36), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_dd20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_ff20,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4gg20[];
extern void _ZN4gg203fooEv();
extern void ABISELECT(_ZTv0_n24_N4gg203fooEv,_ZTv0_n12_N4gg203fooEv)();
extern void ABISELECT(_ZThn24_N4gg203fooEv,_ZThn16_N4gg203fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n24_N4gg203fooEv,_ZTvn8_n12_N4gg203fooEv)();
extern void ABISELECT(_ZTv0_n24_N4gg203fooEv,_ZTv0_n12_N4gg203fooEv)();
extern void ABISELECT(_ZThn56_N4gg203fooEv,_ZThn36_N4gg203fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg20[] = {
  ABISELECT(24,16),
  ABISELECT(56,36),
  0,
  (VTBL_ENTRY)&(_ZTI4gg20[0]),
  (VTBL_ENTRY)&_ZN4gg203fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI4gg20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg203fooEv,_ZTv0_n12_N4gg203fooEv),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI4gg20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N4gg203fooEv,_ZTvn8_n12_N4gg203fooEv),
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI4gg20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg203fooEv,_ZTv0_n12_N4gg203fooEv),
};
extern VTBL_ENTRY _ZTV4gg20[];
extern void _ZN4ff203fooEv();
static  VTBL_ENTRY _tg__ZTV4ff20__4gg20[] = {
  ABISELECT(56,36),
  0,
  (VTBL_ENTRY)&(_ZTI4ff20[0]),
  (VTBL_ENTRY)&_ZN4ff203fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ff203fooEv,_ZTv0_n12_N4ff203fooEv)();
extern void ABISELECT(_ZThn56_N4ff203fooEv,_ZThn36_N4ff203fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4cc20__4ff20__4gg20[] = {
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI4ff20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff203fooEv,_ZTv0_n12_N4ff203fooEv),
};
static  VTT_ENTRY vtt_gg20[] = {
  {&(_ZTV4gg20[4]),  4,16},
  {&(_tg__ZTV4ff20__4gg20[3]),  3,4},
  {&(_tg__ZTV4cc20__4ff20__4gg20[3]),  3,4},
  {&(_ZTV4gg20[8]),  8,16},
  {&(_ZTV4gg20[11]),  11,16},
  {&(_ZTV4gg20[15]),  15,16},
};
extern VTBL_ENTRY _ZTI4gg20[];
extern  VTBL_ENTRY _ZTV4gg20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg20[];
static VTBL_ENTRY alt_thunk_names48[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff203fooEv,_ZTv0_n12_N4ff203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4ff203fooEv,_ZThn36_N4ff203fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg203fooEv,_ZTv0_n12_N4gg203fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4gg203fooEv,_ZThn36_N4gg203fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N4gg203fooEv,_ZThn16_N4gg203fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg20 = {  "gg20", // class name
  bases_gg20, 6,
  &(vtc_gg20[0]), // expected_vtbl_contents
  &(vtt_gg20[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI4gg20),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg20),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg20),6, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names48,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa21  {
  int a;
   aa21(); // _ZN4aa21C1Ev
  virtual void  foo(); // _ZN4aa213fooEv
  ~aa21(); // tgen
};
//SIG(-1 aa21) C1{ v1 Fi}


 aa21 ::aa21(){ note_ctor("aa21", this);}
void  aa21 ::foo(){vfunc_called(this, "_ZN4aa213fooEv");}
aa21 ::~aa21(){ note_dtor("aa21", this);} // tgen

static void Test_aa21()
{
  extern Class_Descriptor cd_aa21;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa21, buf);
    aa21 *dp, &lv = *(dp=new (buf) aa21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa21)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa21.a");
    test_class_info(&lv, &cd_aa21);
    dp->~aa21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa21(Test_aa21, "aa21", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa21C1Ev();
extern void _ZN4aa21D1Ev();
Name_Map name_map_aa21[] = {
  NSPAIR(_ZN4aa21C1Ev),
  NSPAIR(_ZN4aa21D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa21[];
extern void _ZN4aa213fooEv();
static  VTBL_ENTRY vtc_aa21[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa21[0]),
  (VTBL_ENTRY)&_ZN4aa213fooEv,
};
extern VTBL_ENTRY _ZTI4aa21[];
extern  VTBL_ENTRY _ZTV4aa21[];
Class_Descriptor cd_aa21 = {  "aa21", // class name
  0,0,//no base classes
  &(vtc_aa21[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa21),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa21),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb21  {
  int b;
   bb21(); // _ZN4bb21C1Ev
  virtual void  foo(); // _ZN4bb213fooEv
  ~bb21(); // tgen
};
//SIG(-1 bb21) C1{ v1 Fi}


 bb21 ::bb21(){ note_ctor("bb21", this);}
void  bb21 ::foo(){vfunc_called(this, "_ZN4bb213fooEv");}
bb21 ::~bb21(){ note_dtor("bb21", this);} // tgen

static void Test_bb21()
{
  extern Class_Descriptor cd_bb21;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb21, buf);
    bb21 *dp, &lv = *(dp=new (buf) bb21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb21)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb21.b");
    test_class_info(&lv, &cd_bb21);
    dp->~bb21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb21(Test_bb21, "bb21", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb21C1Ev();
extern void _ZN4bb21D1Ev();
Name_Map name_map_bb21[] = {
  NSPAIR(_ZN4bb21C1Ev),
  NSPAIR(_ZN4bb21D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb21[];
extern void _ZN4bb213fooEv();
static  VTBL_ENTRY vtc_bb21[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb21[0]),
  (VTBL_ENTRY)&_ZN4bb213fooEv,
};
extern VTBL_ENTRY _ZTI4bb21[];
extern  VTBL_ENTRY _ZTV4bb21[];
Class_Descriptor cd_bb21 = {  "bb21", // class name
  0,0,//no base classes
  &(vtc_bb21[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb21),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb21),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc21  {
  int c;
   cc21(); // _ZN4cc21C1Ev
  virtual void  foo(); // _ZN4cc213fooEv
  ~cc21(); // tgen
};
//SIG(-1 cc21) C1{ v1 Fi}


 cc21 ::cc21(){ note_ctor("cc21", this);}
void  cc21 ::foo(){vfunc_called(this, "_ZN4cc213fooEv");}
cc21 ::~cc21(){ note_dtor("cc21", this);} // tgen

static void Test_cc21()
{
  extern Class_Descriptor cd_cc21;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc21, buf);
    cc21 *dp, &lv = *(dp=new (buf) cc21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc21)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc21.c");
    test_class_info(&lv, &cd_cc21);
    dp->~cc21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc21(Test_cc21, "cc21", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc21C1Ev();
extern void _ZN4cc21D1Ev();
Name_Map name_map_cc21[] = {
  NSPAIR(_ZN4cc21C1Ev),
  NSPAIR(_ZN4cc21D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc21[];
extern void _ZN4cc213fooEv();
static  VTBL_ENTRY vtc_cc21[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc21[0]),
  (VTBL_ENTRY)&_ZN4cc213fooEv,
};
extern VTBL_ENTRY _ZTI4cc21[];
extern  VTBL_ENTRY _ZTV4cc21[];
Class_Descriptor cd_cc21 = {  "cc21", // class name
  0,0,//no base classes
  &(vtc_cc21[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc21),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc21),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd21  {
  int d;
   dd21(); // _ZN4dd21C1Ev
  virtual void  foo(); // _ZN4dd213fooEv
  ~dd21(); // tgen
};
//SIG(-1 dd21) C1{ v1 Fi}


 dd21 ::dd21(){ note_ctor("dd21", this);}
void  dd21 ::foo(){vfunc_called(this, "_ZN4dd213fooEv");}
dd21 ::~dd21(){ note_dtor("dd21", this);} // tgen

static void Test_dd21()
{
  extern Class_Descriptor cd_dd21;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd21, buf);
    dd21 *dp, &lv = *(dp=new (buf) dd21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd21)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd21.d");
    test_class_info(&lv, &cd_dd21);
    dp->~dd21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd21(Test_dd21, "dd21", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd21C1Ev();
extern void _ZN4dd21D1Ev();
Name_Map name_map_dd21[] = {
  NSPAIR(_ZN4dd21C1Ev),
  NSPAIR(_ZN4dd21D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd21[];
extern void _ZN4dd213fooEv();
static  VTBL_ENTRY vtc_dd21[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd21[0]),
  (VTBL_ENTRY)&_ZN4dd213fooEv,
};
extern VTBL_ENTRY _ZTI4dd21[];
extern  VTBL_ENTRY _ZTV4dd21[];
Class_Descriptor cd_dd21 = {  "dd21", // class name
  0,0,//no base classes
  &(vtc_dd21[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd21),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd21),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee21  : virtual aa21 , bb21 {
  int e;
   ee21(const ABISELECT(__tsi64,int) *const *); // _ZN4ee21C2Ev
  virtual void  foo(); // _ZN4ee213fooEv
  ~ee21(); // tgen
  ee21(); // tgen
};
//SIG(-1 ee21) C1{ VBC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ee21 ::ee21(const ABISELECT(__tsi64,int) *const *){}
void  ee21 ::foo(){vfunc_called(this, "_ZN4ee213fooEv");}
ee21 ::~ee21(){ note_dtor("ee21", this);} // tgen
ee21 ::ee21(){ note_ctor("ee21", this);} // tgen

static void Test_ee21()
{
  extern Class_Descriptor cd_ee21;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee21, buf);
    ee21 *dp, &lv = *(dp=new (buf) ee21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee21)");
    check_base_class_offset(lv, (aa21*), ABISELECT(16,12), "ee21");
    check_base_class_offset(lv, (bb21*), 0, "ee21");
    check_field_offset(lv, e, ABISELECT(12,8), "ee21.e");
    test_class_info(&lv, &cd_ee21);
    dp->~ee21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee21(Test_ee21, "ee21", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ee21C1Ev();
extern void _ZN4ee21D1Ev();
Name_Map name_map_ee21[] = {
  NSPAIR(_ZN4ee21C1Ev),
  NSPAIR(_ZN4ee21D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa21;
extern VTBL_ENTRY _ZTI4aa21[];
extern  VTBL_ENTRY _ZTV4aa21[];
extern Class_Descriptor cd_bb21;
extern VTBL_ENTRY _ZTI4bb21[];
extern  VTBL_ENTRY _ZTV4bb21[];
static Base_Class bases_ee21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa21,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_bb21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ee21[];
extern void _ZN4ee213fooEv();
extern void ABISELECT(_ZTv0_n24_N4ee213fooEv,_ZTv0_n12_N4ee213fooEv)();
extern void ABISELECT(_ZThn16_N4ee213fooEv,_ZThn12_N4ee213fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee21[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee21[0]),
  (VTBL_ENTRY)&_ZN4ee213fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee213fooEv,_ZTv0_n12_N4ee213fooEv),
};
extern VTBL_ENTRY _ZTV4ee21[];
static  VTT_ENTRY vtt_ee21[] = {
  {&(_ZTV4ee21[3]),  3,8},
  {&(_ZTV4ee21[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ee21[];
extern  VTBL_ENTRY _ZTV4ee21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee21[];
static VTBL_ENTRY alt_thunk_names49[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee213fooEv,_ZTv0_n12_N4ee213fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee213fooEv,_ZThn12_N4ee213fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee21 = {  "ee21", // class name
  bases_ee21, 2,
  &(vtc_ee21[0]), // expected_vtbl_contents
  &(vtt_ee21[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ee21),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee21),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ee21),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names49,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff21  : virtual cc21 , dd21 {
  int f;
   ff21(const ABISELECT(__tsi64,int) *const *); // _ZN4ff21C2Ev
  virtual void  foo(); // _ZN4ff213fooEv
  ~ff21(); // tgen
  ff21(); // tgen
};
//SIG(-1 ff21) C1{ VBC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ff21 ::ff21(const ABISELECT(__tsi64,int) *const *){}
void  ff21 ::foo(){vfunc_called(this, "_ZN4ff213fooEv");}
ff21 ::~ff21(){ note_dtor("ff21", this);} // tgen
ff21 ::ff21(){ note_ctor("ff21", this);} // tgen

static void Test_ff21()
{
  extern Class_Descriptor cd_ff21;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff21, buf);
    ff21 *dp, &lv = *(dp=new (buf) ff21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff21)");
    check_base_class_offset(lv, (cc21*), ABISELECT(16,12), "ff21");
    check_base_class_offset(lv, (dd21*), 0, "ff21");
    check_field_offset(lv, f, ABISELECT(12,8), "ff21.f");
    test_class_info(&lv, &cd_ff21);
    dp->~ff21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff21(Test_ff21, "ff21", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ff21C1Ev();
extern void _ZN4ff21D1Ev();
Name_Map name_map_ff21[] = {
  NSPAIR(_ZN4ff21C1Ev),
  NSPAIR(_ZN4ff21D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc21;
extern VTBL_ENTRY _ZTI4cc21[];
extern  VTBL_ENTRY _ZTV4cc21[];
extern Class_Descriptor cd_dd21;
extern VTBL_ENTRY _ZTI4dd21[];
extern  VTBL_ENTRY _ZTV4dd21[];
static Base_Class bases_ff21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc21,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_dd21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ff21[];
extern void _ZN4ff213fooEv();
extern void ABISELECT(_ZTv0_n24_N4ff213fooEv,_ZTv0_n12_N4ff213fooEv)();
extern void ABISELECT(_ZThn16_N4ff213fooEv,_ZThn12_N4ff213fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff21[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff21[0]),
  (VTBL_ENTRY)&_ZN4ff213fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff213fooEv,_ZTv0_n12_N4ff213fooEv),
};
extern VTBL_ENTRY _ZTV4ff21[];
static  VTT_ENTRY vtt_ff21[] = {
  {&(_ZTV4ff21[3]),  3,8},
  {&(_ZTV4ff21[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ff21[];
extern  VTBL_ENTRY _ZTV4ff21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff21[];
static VTBL_ENTRY alt_thunk_names50[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff213fooEv,_ZTv0_n12_N4ff213fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff213fooEv,_ZThn12_N4ff213fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff21 = {  "ff21", // class name
  bases_ff21, 2,
  &(vtc_ff21[0]), // expected_vtbl_contents
  &(vtt_ff21[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ff21),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff21),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ff21),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names50,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg21  : virtual ee21 , ff21 {
  int g;
   gg21(const ABISELECT(__tsi64,int) *const *); // _ZN4gg21C2Ev
  virtual void  foo(); // _ZN4gg213fooEv
  ~gg21(); // tgen
  gg21(); // tgen
};
//SIG(1 gg21) C1{ VBC2{ VBC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ VBC6{ v1 Fi} BC7{ v1 Fi} v1 Fi} v1 Fi}


 gg21 ::gg21(const ABISELECT(__tsi64,int) *const *){}
void  gg21 ::foo(){vfunc_called(this, "_ZN4gg213fooEv");}
gg21 ::~gg21(){ note_dtor("gg21", this);} // tgen
gg21 ::gg21(){ note_ctor("gg21", this);} // tgen

static void Test_gg21()
{
  extern Class_Descriptor cd_gg21;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg21, buf);
    gg21 *dp, &lv = *(dp=new (buf) gg21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg21)");
    check_base_class_offset(lv, (aa21*)(ee21*), ABISELECT(40,28), "gg21");
    check_base_class_offset(lv, (bb21*)(ee21*), ABISELECT(24,16), "gg21");
    check_base_class_offset(lv, (ee21*), ABISELECT(24,16), "gg21");
    check_base_class_offset(lv, (cc21*)(ff21*), ABISELECT(56,36), "gg21");
    check_base_class_offset(lv, (dd21*)(ff21*), 0, "gg21");
    check_base_class_offset(lv, (ff21*), 0, "gg21");
    check_field_offset(lv, g, ABISELECT(16,12), "gg21.g");
    test_class_info(&lv, &cd_gg21);
    dp->~gg21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg21(Test_gg21, "gg21", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN4gg21C1Ev();
extern void _ZN4gg21D1Ev();
Name_Map name_map_gg21[] = {
  NSPAIR(_ZN4gg21C1Ev),
  NSPAIR(_ZN4gg21D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa21;
extern VTBL_ENTRY _ZTI4aa21[];
extern  VTBL_ENTRY _ZTV4aa21[];
extern Class_Descriptor cd_bb21;
extern VTBL_ENTRY _ZTI4bb21[];
extern  VTBL_ENTRY _ZTV4bb21[];
extern Class_Descriptor cd_ee21;
extern VTBL_ENTRY _ZTI4ee21[];
extern  VTBL_ENTRY _ZTV4ee21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee21[];
extern Class_Descriptor cd_cc21;
extern VTBL_ENTRY _ZTI4cc21[];
extern  VTBL_ENTRY _ZTV4cc21[];
extern Class_Descriptor cd_dd21;
extern VTBL_ENTRY _ZTI4dd21[];
extern  VTBL_ENTRY _ZTV4dd21[];
extern Class_Descriptor cd_ff21;
extern VTBL_ENTRY _ZTI4ff21[];
extern  VTBL_ENTRY _ZTV4ff21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff21[];
static Base_Class bases_gg21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa21,    ABISELECT(40,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_bb21,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_ee21,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_cc21,    ABISELECT(56,36), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_dd21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_ff21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4gg21[];
extern void _ZN4gg213fooEv();
extern void ABISELECT(_ZTv0_n32_N4gg213fooEv,_ZTv0_n16_N4gg213fooEv)();
extern void ABISELECT(_ZThn24_N4gg213fooEv,_ZThn16_N4gg213fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg213fooEv,_ZTv0_n12_N4gg213fooEv)();
extern void ABISELECT(_ZThn40_N4gg213fooEv,_ZThn28_N4gg213fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg213fooEv,_ZTv0_n12_N4gg213fooEv)();
extern void ABISELECT(_ZThn56_N4gg213fooEv,_ZThn36_N4gg213fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg21[] = {
  ABISELECT(40,28),
  ABISELECT(24,16),
  ABISELECT(56,36),
  0,
  (VTBL_ENTRY)&(_ZTI4gg21[0]),
  (VTBL_ENTRY)&_ZN4gg213fooEv,
  ABISELECT(-24,-16),
  ABISELECT(16,12),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI4gg21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N4gg213fooEv,_ZTv0_n16_N4gg213fooEv),
  ABISELECT(-40,-28),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI4gg21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg213fooEv,_ZTv0_n12_N4gg213fooEv),
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI4gg21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg213fooEv,_ZTv0_n12_N4gg213fooEv),
};
extern VTBL_ENTRY _ZTV4gg21[];
extern void _ZN4ff213fooEv();
static  VTBL_ENTRY _tg__ZTV4ff21__4gg21[] = {
  ABISELECT(56,36),
  0,
  (VTBL_ENTRY)&(_ZTI4ff21[0]),
  (VTBL_ENTRY)&_ZN4ff213fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ff213fooEv,_ZTv0_n12_N4ff213fooEv)();
extern void ABISELECT(_ZThn56_N4ff213fooEv,_ZThn36_N4ff213fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4cc21__4ff21__4gg21[] = {
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI4ff21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff213fooEv,_ZTv0_n12_N4ff213fooEv),
};
extern void _ZN4ee213fooEv();
static  VTBL_ENTRY _tg__ZTV4ee21__4gg21[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee21[0]),
  (VTBL_ENTRY)&_ZN4ee213fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ee213fooEv,_ZTv0_n12_N4ee213fooEv)();
extern void ABISELECT(_ZThn16_N4ee213fooEv,_ZThn12_N4ee213fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4aa21__4ee21__4gg21[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee213fooEv,_ZTv0_n12_N4ee213fooEv),
};
static  VTT_ENTRY vtt_gg21[] = {
  {&(_ZTV4gg21[5]),  5,19},
  {&(_tg__ZTV4ff21__4gg21[3]),  3,4},
  {&(_tg__ZTV4cc21__4ff21__4gg21[3]),  3,4},
  {&(_ZTV4gg21[10]),  10,19},
  {&(_ZTV4gg21[14]),  14,19},
  {&(_ZTV4gg21[18]),  18,19},
  {&(_tg__ZTV4ee21__4gg21[3]),  3,4},
  {&(_tg__ZTV4aa21__4ee21__4gg21[3]),  3,4},
};
extern VTBL_ENTRY _ZTI4gg21[];
extern  VTBL_ENTRY _ZTV4gg21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg21[];
static VTBL_ENTRY alt_thunk_names51[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee213fooEv,_ZTv0_n12_N4ee213fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee213fooEv,_ZThn12_N4ee213fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff213fooEv,_ZTv0_n12_N4ff213fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4ff213fooEv,_ZThn36_N4ff213fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg213fooEv,_ZTv0_n12_N4gg213fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4gg213fooEv,_ZThn36_N4gg213fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N4gg213fooEv,_ZThn28_N4gg213fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N4gg213fooEv,_ZTv0_n16_N4gg213fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N4gg213fooEv,_ZThn16_N4gg213fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg21 = {  "gg21", // class name
  bases_gg21, 6,
  &(vtc_gg21[0]), // expected_vtbl_contents
  &(vtt_gg21[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI4gg21),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg21),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg21),8, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names51,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa22  {
  int a;
   aa22(); // _ZN4aa22C1Ev
  virtual void  foo(); // _ZN4aa223fooEv
  ~aa22(); // tgen
};
//SIG(-1 aa22) C1{ v1 Fi}


 aa22 ::aa22(){ note_ctor("aa22", this);}
void  aa22 ::foo(){vfunc_called(this, "_ZN4aa223fooEv");}
aa22 ::~aa22(){ note_dtor("aa22", this);} // tgen

static void Test_aa22()
{
  extern Class_Descriptor cd_aa22;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa22, buf);
    aa22 *dp, &lv = *(dp=new (buf) aa22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa22)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa22.a");
    test_class_info(&lv, &cd_aa22);
    dp->~aa22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa22(Test_aa22, "aa22", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa22C1Ev();
extern void _ZN4aa22D1Ev();
Name_Map name_map_aa22[] = {
  NSPAIR(_ZN4aa22C1Ev),
  NSPAIR(_ZN4aa22D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa22[];
extern void _ZN4aa223fooEv();
static  VTBL_ENTRY vtc_aa22[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa22[0]),
  (VTBL_ENTRY)&_ZN4aa223fooEv,
};
extern VTBL_ENTRY _ZTI4aa22[];
extern  VTBL_ENTRY _ZTV4aa22[];
Class_Descriptor cd_aa22 = {  "aa22", // class name
  0,0,//no base classes
  &(vtc_aa22[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa22),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa22),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb22  {
  int b;
   bb22(); // _ZN4bb22C1Ev
  virtual void  foo(); // _ZN4bb223fooEv
  ~bb22(); // tgen
};
//SIG(-1 bb22) C1{ v1 Fi}


 bb22 ::bb22(){ note_ctor("bb22", this);}
void  bb22 ::foo(){vfunc_called(this, "_ZN4bb223fooEv");}
bb22 ::~bb22(){ note_dtor("bb22", this);} // tgen

static void Test_bb22()
{
  extern Class_Descriptor cd_bb22;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb22, buf);
    bb22 *dp, &lv = *(dp=new (buf) bb22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb22)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb22.b");
    test_class_info(&lv, &cd_bb22);
    dp->~bb22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb22(Test_bb22, "bb22", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb22C1Ev();
extern void _ZN4bb22D1Ev();
Name_Map name_map_bb22[] = {
  NSPAIR(_ZN4bb22C1Ev),
  NSPAIR(_ZN4bb22D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb22[];
extern void _ZN4bb223fooEv();
static  VTBL_ENTRY vtc_bb22[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb22[0]),
  (VTBL_ENTRY)&_ZN4bb223fooEv,
};
extern VTBL_ENTRY _ZTI4bb22[];
extern  VTBL_ENTRY _ZTV4bb22[];
Class_Descriptor cd_bb22 = {  "bb22", // class name
  0,0,//no base classes
  &(vtc_bb22[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb22),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb22),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc22  {
  int c;
   cc22(); // _ZN4cc22C1Ev
  virtual void  foo(); // _ZN4cc223fooEv
  ~cc22(); // tgen
};
//SIG(-1 cc22) C1{ v1 Fi}


 cc22 ::cc22(){ note_ctor("cc22", this);}
void  cc22 ::foo(){vfunc_called(this, "_ZN4cc223fooEv");}
cc22 ::~cc22(){ note_dtor("cc22", this);} // tgen

static void Test_cc22()
{
  extern Class_Descriptor cd_cc22;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc22, buf);
    cc22 *dp, &lv = *(dp=new (buf) cc22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc22)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc22.c");
    test_class_info(&lv, &cd_cc22);
    dp->~cc22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc22(Test_cc22, "cc22", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc22C1Ev();
extern void _ZN4cc22D1Ev();
Name_Map name_map_cc22[] = {
  NSPAIR(_ZN4cc22C1Ev),
  NSPAIR(_ZN4cc22D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc22[];
extern void _ZN4cc223fooEv();
static  VTBL_ENTRY vtc_cc22[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc22[0]),
  (VTBL_ENTRY)&_ZN4cc223fooEv,
};
extern VTBL_ENTRY _ZTI4cc22[];
extern  VTBL_ENTRY _ZTV4cc22[];
Class_Descriptor cd_cc22 = {  "cc22", // class name
  0,0,//no base classes
  &(vtc_cc22[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc22),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc22),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd22  {
  int d;
   dd22(); // _ZN4dd22C1Ev
  virtual void  foo(); // _ZN4dd223fooEv
  ~dd22(); // tgen
};
//SIG(-1 dd22) C1{ v1 Fi}


 dd22 ::dd22(){ note_ctor("dd22", this);}
void  dd22 ::foo(){vfunc_called(this, "_ZN4dd223fooEv");}
dd22 ::~dd22(){ note_dtor("dd22", this);} // tgen

static void Test_dd22()
{
  extern Class_Descriptor cd_dd22;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd22, buf);
    dd22 *dp, &lv = *(dp=new (buf) dd22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd22)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd22.d");
    test_class_info(&lv, &cd_dd22);
    dp->~dd22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd22(Test_dd22, "dd22", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd22C1Ev();
extern void _ZN4dd22D1Ev();
Name_Map name_map_dd22[] = {
  NSPAIR(_ZN4dd22C1Ev),
  NSPAIR(_ZN4dd22D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd22[];
extern void _ZN4dd223fooEv();
static  VTBL_ENTRY vtc_dd22[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd22[0]),
  (VTBL_ENTRY)&_ZN4dd223fooEv,
};
extern VTBL_ENTRY _ZTI4dd22[];
extern  VTBL_ENTRY _ZTV4dd22[];
Class_Descriptor cd_dd22 = {  "dd22", // class name
  0,0,//no base classes
  &(vtc_dd22[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd22),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd22),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee22  : aa22 , virtual bb22 {
  int e;
   ee22(const ABISELECT(__tsi64,int) *const *); // _ZN4ee22C2Ev
  virtual void  foo(); // _ZN4ee223fooEv
  ~ee22(); // tgen
  ee22(); // tgen
};
//SIG(-1 ee22) C1{ BC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ee22 ::ee22(const ABISELECT(__tsi64,int) *const *){}
void  ee22 ::foo(){vfunc_called(this, "_ZN4ee223fooEv");}
ee22 ::~ee22(){ note_dtor("ee22", this);} // tgen
ee22 ::ee22(){ note_ctor("ee22", this);} // tgen

static void Test_ee22()
{
  extern Class_Descriptor cd_ee22;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee22, buf);
    ee22 *dp, &lv = *(dp=new (buf) ee22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee22)");
    check_base_class_offset(lv, (aa22*), 0, "ee22");
    check_base_class_offset(lv, (bb22*), ABISELECT(16,12), "ee22");
    check_field_offset(lv, e, ABISELECT(12,8), "ee22.e");
    test_class_info(&lv, &cd_ee22);
    dp->~ee22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee22(Test_ee22, "ee22", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ee22C1Ev();
extern void _ZN4ee22D1Ev();
Name_Map name_map_ee22[] = {
  NSPAIR(_ZN4ee22C1Ev),
  NSPAIR(_ZN4ee22D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa22;
extern VTBL_ENTRY _ZTI4aa22[];
extern  VTBL_ENTRY _ZTV4aa22[];
extern Class_Descriptor cd_bb22;
extern VTBL_ENTRY _ZTI4bb22[];
extern  VTBL_ENTRY _ZTV4bb22[];
static Base_Class bases_ee22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_bb22,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ee22[];
extern void _ZN4ee223fooEv();
extern void ABISELECT(_ZTv0_n24_N4ee223fooEv,_ZTv0_n12_N4ee223fooEv)();
extern void ABISELECT(_ZThn16_N4ee223fooEv,_ZThn12_N4ee223fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee22[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee22[0]),
  (VTBL_ENTRY)&_ZN4ee223fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee223fooEv,_ZTv0_n12_N4ee223fooEv),
};
extern VTBL_ENTRY _ZTV4ee22[];
static  VTT_ENTRY vtt_ee22[] = {
  {&(_ZTV4ee22[3]),  3,8},
  {&(_ZTV4ee22[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ee22[];
extern  VTBL_ENTRY _ZTV4ee22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee22[];
static VTBL_ENTRY alt_thunk_names52[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee223fooEv,_ZTv0_n12_N4ee223fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee223fooEv,_ZThn12_N4ee223fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee22 = {  "ee22", // class name
  bases_ee22, 2,
  &(vtc_ee22[0]), // expected_vtbl_contents
  &(vtt_ee22[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ee22),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee22),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ee22),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names52,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff22  : virtual cc22 , dd22 {
  int f;
   ff22(const ABISELECT(__tsi64,int) *const *); // _ZN4ff22C2Ev
  virtual void  foo(); // _ZN4ff223fooEv
  ~ff22(); // tgen
  ff22(); // tgen
};
//SIG(-1 ff22) C1{ VBC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ff22 ::ff22(const ABISELECT(__tsi64,int) *const *){}
void  ff22 ::foo(){vfunc_called(this, "_ZN4ff223fooEv");}
ff22 ::~ff22(){ note_dtor("ff22", this);} // tgen
ff22 ::ff22(){ note_ctor("ff22", this);} // tgen

static void Test_ff22()
{
  extern Class_Descriptor cd_ff22;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff22, buf);
    ff22 *dp, &lv = *(dp=new (buf) ff22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff22)");
    check_base_class_offset(lv, (cc22*), ABISELECT(16,12), "ff22");
    check_base_class_offset(lv, (dd22*), 0, "ff22");
    check_field_offset(lv, f, ABISELECT(12,8), "ff22.f");
    test_class_info(&lv, &cd_ff22);
    dp->~ff22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff22(Test_ff22, "ff22", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ff22C1Ev();
extern void _ZN4ff22D1Ev();
Name_Map name_map_ff22[] = {
  NSPAIR(_ZN4ff22C1Ev),
  NSPAIR(_ZN4ff22D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc22;
extern VTBL_ENTRY _ZTI4cc22[];
extern  VTBL_ENTRY _ZTV4cc22[];
extern Class_Descriptor cd_dd22;
extern VTBL_ENTRY _ZTI4dd22[];
extern  VTBL_ENTRY _ZTV4dd22[];
static Base_Class bases_ff22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc22,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_dd22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ff22[];
extern void _ZN4ff223fooEv();
extern void ABISELECT(_ZTv0_n24_N4ff223fooEv,_ZTv0_n12_N4ff223fooEv)();
extern void ABISELECT(_ZThn16_N4ff223fooEv,_ZThn12_N4ff223fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff22[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff22[0]),
  (VTBL_ENTRY)&_ZN4ff223fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff223fooEv,_ZTv0_n12_N4ff223fooEv),
};
extern VTBL_ENTRY _ZTV4ff22[];
static  VTT_ENTRY vtt_ff22[] = {
  {&(_ZTV4ff22[3]),  3,8},
  {&(_ZTV4ff22[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ff22[];
extern  VTBL_ENTRY _ZTV4ff22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff22[];
static VTBL_ENTRY alt_thunk_names53[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff223fooEv,_ZTv0_n12_N4ff223fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff223fooEv,_ZThn12_N4ff223fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff22 = {  "ff22", // class name
  bases_ff22, 2,
  &(vtc_ff22[0]), // expected_vtbl_contents
  &(vtt_ff22[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ff22),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff22),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ff22),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names53,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg22  : virtual ee22 , ff22 {
  int g;
   gg22(const ABISELECT(__tsi64,int) *const *); // _ZN4gg22C2Ev
  virtual void  foo(); // _ZN4gg223fooEv
  ~gg22(); // tgen
  gg22(); // tgen
};
//SIG(1 gg22) C1{ VBC2{ BC3{ v1 Fi} VBC4{ v1 Fi} v1 Fi} BC5{ VBC6{ v1 Fi} BC7{ v1 Fi} v1 Fi} v1 Fi}


 gg22 ::gg22(const ABISELECT(__tsi64,int) *const *){}
void  gg22 ::foo(){vfunc_called(this, "_ZN4gg223fooEv");}
gg22 ::~gg22(){ note_dtor("gg22", this);} // tgen
gg22 ::gg22(){ note_ctor("gg22", this);} // tgen

static void Test_gg22()
{
  extern Class_Descriptor cd_gg22;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg22, buf);
    gg22 *dp, &lv = *(dp=new (buf) gg22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg22)");
    check_base_class_offset(lv, (aa22*)(ee22*), ABISELECT(24,16), "gg22");
    check_base_class_offset(lv, (bb22*)(ee22*), ABISELECT(40,28), "gg22");
    check_base_class_offset(lv, (ee22*), ABISELECT(24,16), "gg22");
    check_base_class_offset(lv, (cc22*)(ff22*), ABISELECT(56,36), "gg22");
    check_base_class_offset(lv, (dd22*)(ff22*), 0, "gg22");
    check_base_class_offset(lv, (ff22*), 0, "gg22");
    check_field_offset(lv, g, ABISELECT(16,12), "gg22.g");
    test_class_info(&lv, &cd_gg22);
    dp->~gg22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg22(Test_gg22, "gg22", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN4gg22C1Ev();
extern void _ZN4gg22D1Ev();
Name_Map name_map_gg22[] = {
  NSPAIR(_ZN4gg22C1Ev),
  NSPAIR(_ZN4gg22D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa22;
extern VTBL_ENTRY _ZTI4aa22[];
extern  VTBL_ENTRY _ZTV4aa22[];
extern Class_Descriptor cd_bb22;
extern VTBL_ENTRY _ZTI4bb22[];
extern  VTBL_ENTRY _ZTV4bb22[];
extern Class_Descriptor cd_ee22;
extern VTBL_ENTRY _ZTI4ee22[];
extern  VTBL_ENTRY _ZTV4ee22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee22[];
extern Class_Descriptor cd_cc22;
extern VTBL_ENTRY _ZTI4cc22[];
extern  VTBL_ENTRY _ZTV4cc22[];
extern Class_Descriptor cd_dd22;
extern VTBL_ENTRY _ZTI4dd22[];
extern  VTBL_ENTRY _ZTV4dd22[];
extern Class_Descriptor cd_ff22;
extern VTBL_ENTRY _ZTI4ff22[];
extern  VTBL_ENTRY _ZTV4ff22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff22[];
static Base_Class bases_gg22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa22,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_bb22,    ABISELECT(40,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_ee22,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_cc22,    ABISELECT(56,36), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_dd22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_ff22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4gg22[];
extern void _ZN4gg223fooEv();
extern void ABISELECT(_ZTv0_n32_N4gg223fooEv,_ZTv0_n16_N4gg223fooEv)();
extern void ABISELECT(_ZThn24_N4gg223fooEv,_ZThn16_N4gg223fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg223fooEv,_ZTv0_n12_N4gg223fooEv)();
extern void ABISELECT(_ZThn40_N4gg223fooEv,_ZThn28_N4gg223fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg223fooEv,_ZTv0_n12_N4gg223fooEv)();
extern void ABISELECT(_ZThn56_N4gg223fooEv,_ZThn36_N4gg223fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg22[] = {
  ABISELECT(40,28),
  ABISELECT(24,16),
  ABISELECT(56,36),
  0,
  (VTBL_ENTRY)&(_ZTI4gg22[0]),
  (VTBL_ENTRY)&_ZN4gg223fooEv,
  ABISELECT(-24,-16),
  ABISELECT(16,12),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI4gg22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N4gg223fooEv,_ZTv0_n16_N4gg223fooEv),
  ABISELECT(-40,-28),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI4gg22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg223fooEv,_ZTv0_n12_N4gg223fooEv),
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI4gg22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg223fooEv,_ZTv0_n12_N4gg223fooEv),
};
extern VTBL_ENTRY _ZTV4gg22[];
extern void _ZN4ff223fooEv();
static  VTBL_ENTRY _tg__ZTV4ff22__4gg22[] = {
  ABISELECT(56,36),
  0,
  (VTBL_ENTRY)&(_ZTI4ff22[0]),
  (VTBL_ENTRY)&_ZN4ff223fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ff223fooEv,_ZTv0_n12_N4ff223fooEv)();
extern void ABISELECT(_ZThn56_N4ff223fooEv,_ZThn36_N4ff223fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4cc22__4ff22__4gg22[] = {
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI4ff22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff223fooEv,_ZTv0_n12_N4ff223fooEv),
};
extern void _ZN4ee223fooEv();
static  VTBL_ENTRY _tg__ZTV4ee22__4gg22[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee22[0]),
  (VTBL_ENTRY)&_ZN4ee223fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ee223fooEv,_ZTv0_n12_N4ee223fooEv)();
extern void ABISELECT(_ZThn16_N4ee223fooEv,_ZThn12_N4ee223fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb22__4ee22__4gg22[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee223fooEv,_ZTv0_n12_N4ee223fooEv),
};
static  VTT_ENTRY vtt_gg22[] = {
  {&(_ZTV4gg22[5]),  5,19},
  {&(_tg__ZTV4ff22__4gg22[3]),  3,4},
  {&(_tg__ZTV4cc22__4ff22__4gg22[3]),  3,4},
  {&(_ZTV4gg22[10]),  10,19},
  {&(_ZTV4gg22[14]),  14,19},
  {&(_ZTV4gg22[18]),  18,19},
  {&(_tg__ZTV4ee22__4gg22[3]),  3,4},
  {&(_tg__ZTV4bb22__4ee22__4gg22[3]),  3,4},
};
extern VTBL_ENTRY _ZTI4gg22[];
extern  VTBL_ENTRY _ZTV4gg22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg22[];
static VTBL_ENTRY alt_thunk_names54[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee223fooEv,_ZTv0_n12_N4ee223fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee223fooEv,_ZThn12_N4ee223fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff223fooEv,_ZTv0_n12_N4ff223fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4ff223fooEv,_ZThn36_N4ff223fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg223fooEv,_ZTv0_n12_N4gg223fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4gg223fooEv,_ZThn36_N4gg223fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N4gg223fooEv,_ZThn28_N4gg223fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N4gg223fooEv,_ZTv0_n16_N4gg223fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N4gg223fooEv,_ZThn16_N4gg223fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg22 = {  "gg22", // class name
  bases_gg22, 6,
  &(vtc_gg22[0]), // expected_vtbl_contents
  &(vtt_gg22[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI4gg22),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg22),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg22),8, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names54,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa23  {
  int a;
   aa23(); // _ZN4aa23C1Ev
  virtual void  foo(); // _ZN4aa233fooEv
  ~aa23(); // tgen
};
//SIG(-1 aa23) C1{ v1 Fi}


 aa23 ::aa23(){ note_ctor("aa23", this);}
void  aa23 ::foo(){vfunc_called(this, "_ZN4aa233fooEv");}
aa23 ::~aa23(){ note_dtor("aa23", this);} // tgen

static void Test_aa23()
{
  extern Class_Descriptor cd_aa23;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa23, buf);
    aa23 *dp, &lv = *(dp=new (buf) aa23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa23)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa23.a");
    test_class_info(&lv, &cd_aa23);
    dp->~aa23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa23(Test_aa23, "aa23", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa23C1Ev();
extern void _ZN4aa23D1Ev();
Name_Map name_map_aa23[] = {
  NSPAIR(_ZN4aa23C1Ev),
  NSPAIR(_ZN4aa23D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa23[];
extern void _ZN4aa233fooEv();
static  VTBL_ENTRY vtc_aa23[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa23[0]),
  (VTBL_ENTRY)&_ZN4aa233fooEv,
};
extern VTBL_ENTRY _ZTI4aa23[];
extern  VTBL_ENTRY _ZTV4aa23[];
Class_Descriptor cd_aa23 = {  "aa23", // class name
  0,0,//no base classes
  &(vtc_aa23[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa23),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa23),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb23  {
  int b;
   bb23(); // _ZN4bb23C1Ev
  virtual void  foo(); // _ZN4bb233fooEv
  ~bb23(); // tgen
};
//SIG(-1 bb23) C1{ v1 Fi}


 bb23 ::bb23(){ note_ctor("bb23", this);}
void  bb23 ::foo(){vfunc_called(this, "_ZN4bb233fooEv");}
bb23 ::~bb23(){ note_dtor("bb23", this);} // tgen

static void Test_bb23()
{
  extern Class_Descriptor cd_bb23;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb23, buf);
    bb23 *dp, &lv = *(dp=new (buf) bb23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb23)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb23.b");
    test_class_info(&lv, &cd_bb23);
    dp->~bb23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb23(Test_bb23, "bb23", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb23C1Ev();
extern void _ZN4bb23D1Ev();
Name_Map name_map_bb23[] = {
  NSPAIR(_ZN4bb23C1Ev),
  NSPAIR(_ZN4bb23D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb23[];
extern void _ZN4bb233fooEv();
static  VTBL_ENTRY vtc_bb23[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb23[0]),
  (VTBL_ENTRY)&_ZN4bb233fooEv,
};
extern VTBL_ENTRY _ZTI4bb23[];
extern  VTBL_ENTRY _ZTV4bb23[];
Class_Descriptor cd_bb23 = {  "bb23", // class name
  0,0,//no base classes
  &(vtc_bb23[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb23),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb23),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc23  {
  int c;
   cc23(); // _ZN4cc23C1Ev
  virtual void  foo(); // _ZN4cc233fooEv
  ~cc23(); // tgen
};
//SIG(-1 cc23) C1{ v1 Fi}


 cc23 ::cc23(){ note_ctor("cc23", this);}
void  cc23 ::foo(){vfunc_called(this, "_ZN4cc233fooEv");}
cc23 ::~cc23(){ note_dtor("cc23", this);} // tgen

static void Test_cc23()
{
  extern Class_Descriptor cd_cc23;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc23, buf);
    cc23 *dp, &lv = *(dp=new (buf) cc23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc23)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc23.c");
    test_class_info(&lv, &cd_cc23);
    dp->~cc23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc23(Test_cc23, "cc23", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc23C1Ev();
extern void _ZN4cc23D1Ev();
Name_Map name_map_cc23[] = {
  NSPAIR(_ZN4cc23C1Ev),
  NSPAIR(_ZN4cc23D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc23[];
extern void _ZN4cc233fooEv();
static  VTBL_ENTRY vtc_cc23[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc23[0]),
  (VTBL_ENTRY)&_ZN4cc233fooEv,
};
extern VTBL_ENTRY _ZTI4cc23[];
extern  VTBL_ENTRY _ZTV4cc23[];
Class_Descriptor cd_cc23 = {  "cc23", // class name
  0,0,//no base classes
  &(vtc_cc23[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc23),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc23),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd23  {
  int d;
   dd23(); // _ZN4dd23C1Ev
  virtual void  foo(); // _ZN4dd233fooEv
  ~dd23(); // tgen
};
//SIG(-1 dd23) C1{ v1 Fi}


 dd23 ::dd23(){ note_ctor("dd23", this);}
void  dd23 ::foo(){vfunc_called(this, "_ZN4dd233fooEv");}
dd23 ::~dd23(){ note_dtor("dd23", this);} // tgen

static void Test_dd23()
{
  extern Class_Descriptor cd_dd23;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd23, buf);
    dd23 *dp, &lv = *(dp=new (buf) dd23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd23)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd23.d");
    test_class_info(&lv, &cd_dd23);
    dp->~dd23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd23(Test_dd23, "dd23", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd23C1Ev();
extern void _ZN4dd23D1Ev();
Name_Map name_map_dd23[] = {
  NSPAIR(_ZN4dd23C1Ev),
  NSPAIR(_ZN4dd23D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd23[];
extern void _ZN4dd233fooEv();
static  VTBL_ENTRY vtc_dd23[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd23[0]),
  (VTBL_ENTRY)&_ZN4dd233fooEv,
};
extern VTBL_ENTRY _ZTI4dd23[];
extern  VTBL_ENTRY _ZTV4dd23[];
Class_Descriptor cd_dd23 = {  "dd23", // class name
  0,0,//no base classes
  &(vtc_dd23[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd23),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd23),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee23  : virtual aa23 , virtual bb23 {
  int e;
   ee23(const ABISELECT(__tsi64,int) *const *); // _ZN4ee23C2Ev
  virtual void  foo(); // _ZN4ee233fooEv
  ~ee23(); // tgen
  ee23(); // tgen
};
//SIG(-1 ee23) C1{ VBC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ee23 ::ee23(const ABISELECT(__tsi64,int) *const *){}
void  ee23 ::foo(){vfunc_called(this, "_ZN4ee233fooEv");}
ee23 ::~ee23(){ note_dtor("ee23", this);} // tgen
ee23 ::ee23(){ note_ctor("ee23", this);} // tgen

static void Test_ee23()
{
  extern Class_Descriptor cd_ee23;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_ee23, buf);
    ee23 *dp, &lv = *(dp=new (buf) ee23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(ee23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee23)");
    check_base_class_offset(lv, (aa23*), ABISELECT(16,8), "ee23");
    check_base_class_offset(lv, (bb23*), ABISELECT(32,16), "ee23");
    check_field_offset(lv, e, ABISELECT(8,4), "ee23.e");
    test_class_info(&lv, &cd_ee23);
    dp->~ee23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee23(Test_ee23, "ee23", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN4ee23C1Ev();
extern void _ZN4ee23D1Ev();
Name_Map name_map_ee23[] = {
  NSPAIR(_ZN4ee23C1Ev),
  NSPAIR(_ZN4ee23D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa23;
extern VTBL_ENTRY _ZTI4aa23[];
extern  VTBL_ENTRY _ZTV4aa23[];
extern Class_Descriptor cd_bb23;
extern VTBL_ENTRY _ZTI4bb23[];
extern  VTBL_ENTRY _ZTV4bb23[];
static Base_Class bases_ee23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa23,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_bb23,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ee23[];
extern void _ZN4ee233fooEv();
extern void ABISELECT(_ZTv0_n24_N4ee233fooEv,_ZTv0_n12_N4ee233fooEv)();
extern void ABISELECT(_ZThn16_N4ee233fooEv,_ZThn8_N4ee233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4ee233fooEv,_ZTv0_n12_N4ee233fooEv)();
extern void ABISELECT(_ZThn32_N4ee233fooEv,_ZThn16_N4ee233fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee23[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI4ee23[0]),
  (VTBL_ENTRY)&_ZN4ee233fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ee23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee233fooEv,_ZTv0_n12_N4ee233fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI4ee23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee233fooEv,_ZTv0_n12_N4ee233fooEv),
};
extern VTBL_ENTRY _ZTV4ee23[];
static  VTT_ENTRY vtt_ee23[] = {
  {&(_ZTV4ee23[4]),  4,13},
  {&(_ZTV4ee23[8]),  8,13},
  {&(_ZTV4ee23[12]),  12,13},
};
extern VTBL_ENTRY _ZTI4ee23[];
extern  VTBL_ENTRY _ZTV4ee23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee23[];
static VTBL_ENTRY alt_thunk_names55[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee233fooEv,_ZTv0_n12_N4ee233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ee233fooEv,_ZThn16_N4ee233fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee233fooEv,_ZThn8_N4ee233fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee23 = {  "ee23", // class name
  bases_ee23, 2,
  &(vtc_ee23[0]), // expected_vtbl_contents
  &(vtt_ee23[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI4ee23),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee23),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ee23),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names55,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff23  : virtual cc23 , dd23 {
  int f;
   ff23(const ABISELECT(__tsi64,int) *const *); // _ZN4ff23C2Ev
  virtual void  foo(); // _ZN4ff233fooEv
  ~ff23(); // tgen
  ff23(); // tgen
};
//SIG(-1 ff23) C1{ VBC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ff23 ::ff23(const ABISELECT(__tsi64,int) *const *){}
void  ff23 ::foo(){vfunc_called(this, "_ZN4ff233fooEv");}
ff23 ::~ff23(){ note_dtor("ff23", this);} // tgen
ff23 ::ff23(){ note_ctor("ff23", this);} // tgen

static void Test_ff23()
{
  extern Class_Descriptor cd_ff23;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff23, buf);
    ff23 *dp, &lv = *(dp=new (buf) ff23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff23)");
    check_base_class_offset(lv, (cc23*), ABISELECT(16,12), "ff23");
    check_base_class_offset(lv, (dd23*), 0, "ff23");
    check_field_offset(lv, f, ABISELECT(12,8), "ff23.f");
    test_class_info(&lv, &cd_ff23);
    dp->~ff23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff23(Test_ff23, "ff23", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ff23C1Ev();
extern void _ZN4ff23D1Ev();
Name_Map name_map_ff23[] = {
  NSPAIR(_ZN4ff23C1Ev),
  NSPAIR(_ZN4ff23D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc23;
extern VTBL_ENTRY _ZTI4cc23[];
extern  VTBL_ENTRY _ZTV4cc23[];
extern Class_Descriptor cd_dd23;
extern VTBL_ENTRY _ZTI4dd23[];
extern  VTBL_ENTRY _ZTV4dd23[];
static Base_Class bases_ff23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc23,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_dd23,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ff23[];
extern void _ZN4ff233fooEv();
extern void ABISELECT(_ZTv0_n24_N4ff233fooEv,_ZTv0_n12_N4ff233fooEv)();
extern void ABISELECT(_ZThn16_N4ff233fooEv,_ZThn12_N4ff233fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff23[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff23[0]),
  (VTBL_ENTRY)&_ZN4ff233fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff233fooEv,_ZTv0_n12_N4ff233fooEv),
};
extern VTBL_ENTRY _ZTV4ff23[];
static  VTT_ENTRY vtt_ff23[] = {
  {&(_ZTV4ff23[3]),  3,8},
  {&(_ZTV4ff23[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ff23[];
extern  VTBL_ENTRY _ZTV4ff23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff23[];
static VTBL_ENTRY alt_thunk_names56[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff233fooEv,_ZTv0_n12_N4ff233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff233fooEv,_ZThn12_N4ff233fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff23 = {  "ff23", // class name
  bases_ff23, 2,
  &(vtc_ff23[0]), // expected_vtbl_contents
  &(vtt_ff23[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ff23),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff23),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ff23),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names56,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg23  : virtual ee23 , ff23 {
  int g;
   gg23(const ABISELECT(__tsi64,int) *const *); // _ZN4gg23C2Ev
  virtual void  foo(); // _ZN4gg233fooEv
  ~gg23(); // tgen
  gg23(); // tgen
};
//SIG(1 gg23) C1{ VBC2{ VBC3{ v1 Fi} VBC4{ v1 Fi} v1 Fi} BC5{ VBC6{ v1 Fi} BC7{ v1 Fi} v1 Fi} v1 Fi}


 gg23 ::gg23(const ABISELECT(__tsi64,int) *const *){}
void  gg23 ::foo(){vfunc_called(this, "_ZN4gg233fooEv");}
gg23 ::~gg23(){ note_dtor("gg23", this);} // tgen
gg23 ::gg23(){ note_ctor("gg23", this);} // tgen

static void Test_gg23()
{
  extern Class_Descriptor cd_gg23;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(12,13)];
    init_test(&cd_gg23, buf);
    gg23 *dp, &lv = *(dp=new (buf) gg23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(88,48), "sizeof(gg23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg23)");
    check_base_class_offset(lv, (aa23*)(ee23*), ABISELECT(40,24), "gg23");
    check_base_class_offset(lv, (bb23*)(ee23*), ABISELECT(56,32), "gg23");
    check_base_class_offset(lv, (ee23*), ABISELECT(24,16), "gg23");
    check_base_class_offset(lv, (cc23*)(ff23*), ABISELECT(72,40), "gg23");
    check_base_class_offset(lv, (dd23*)(ff23*), 0, "gg23");
    check_base_class_offset(lv, (ff23*), 0, "gg23");
    check_field_offset(lv, g, ABISELECT(16,12), "gg23.g");
    test_class_info(&lv, &cd_gg23);
    dp->~gg23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg23(Test_gg23, "gg23", ABISELECT(88,48));

#else // __cplusplus

extern void _ZN4gg23C1Ev();
extern void _ZN4gg23D1Ev();
Name_Map name_map_gg23[] = {
  NSPAIR(_ZN4gg23C1Ev),
  NSPAIR(_ZN4gg23D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa23;
extern VTBL_ENTRY _ZTI4aa23[];
extern  VTBL_ENTRY _ZTV4aa23[];
extern Class_Descriptor cd_bb23;
extern VTBL_ENTRY _ZTI4bb23[];
extern  VTBL_ENTRY _ZTV4bb23[];
extern Class_Descriptor cd_ee23;
extern VTBL_ENTRY _ZTI4ee23[];
extern  VTBL_ENTRY _ZTV4ee23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee23[];
extern Class_Descriptor cd_cc23;
extern VTBL_ENTRY _ZTI4cc23[];
extern  VTBL_ENTRY _ZTV4cc23[];
extern Class_Descriptor cd_dd23;
extern VTBL_ENTRY _ZTI4dd23[];
extern  VTBL_ENTRY _ZTV4dd23[];
extern Class_Descriptor cd_ff23;
extern VTBL_ENTRY _ZTI4ff23[];
extern  VTBL_ENTRY _ZTV4ff23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff23[];
static Base_Class bases_gg23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa23,    ABISELECT(40,24), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_bb23,    ABISELECT(56,32), //bcp->offset
    17, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_ee23,    ABISELECT(24,16), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_cc23,    ABISELECT(72,40), //bcp->offset
    21, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_dd23,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_ff23,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4gg23[];
extern void _ZN4gg233fooEv();
extern void ABISELECT(_ZTv0_n40_N4gg233fooEv,_ZTv0_n20_N4gg233fooEv)();
extern void ABISELECT(_ZThn24_N4gg233fooEv,_ZThn16_N4gg233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg233fooEv,_ZTv0_n12_N4gg233fooEv)();
extern void ABISELECT(_ZThn40_N4gg233fooEv,_ZThn24_N4gg233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg233fooEv,_ZTv0_n12_N4gg233fooEv)();
extern void ABISELECT(_ZThn56_N4gg233fooEv,_ZThn32_N4gg233fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg233fooEv,_ZTv0_n12_N4gg233fooEv)();
extern void ABISELECT(_ZThn72_N4gg233fooEv,_ZThn40_N4gg233fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg23[] = {
  ABISELECT(56,32),
  ABISELECT(40,24),
  ABISELECT(24,16),
  ABISELECT(72,40),
  0,
  (VTBL_ENTRY)&(_ZTI4gg23[0]),
  (VTBL_ENTRY)&_ZN4gg233fooEv,
  ABISELECT(-24,-16),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI4gg23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N4gg233fooEv,_ZTv0_n20_N4gg233fooEv),
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI4gg23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg233fooEv,_ZTv0_n12_N4gg233fooEv),
  ABISELECT(-56,-32),
  ABISELECT(-56,-32),
  (VTBL_ENTRY)&(_ZTI4gg23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg233fooEv,_ZTv0_n12_N4gg233fooEv),
  ABISELECT(-72,-40),
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI4gg23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg233fooEv,_ZTv0_n12_N4gg233fooEv),
};
extern VTBL_ENTRY _ZTV4gg23[];
extern void _ZN4ff233fooEv();
static  VTBL_ENTRY _tg__ZTV4ff23__4gg23[] = {
  ABISELECT(72,40),
  0,
  (VTBL_ENTRY)&(_ZTI4ff23[0]),
  (VTBL_ENTRY)&_ZN4ff233fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ff233fooEv,_ZTv0_n12_N4ff233fooEv)();
extern void ABISELECT(_ZThn72_N4ff233fooEv,_ZThn40_N4ff233fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4cc23__4ff23__4gg23[] = {
  ABISELECT(-72,-40),
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI4ff23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff233fooEv,_ZTv0_n12_N4ff233fooEv),
};
extern void _ZN4ee233fooEv();
static  VTBL_ENTRY _tg__ZTV4ee23__4gg23[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI4ee23[0]),
  (VTBL_ENTRY)&_ZN4ee233fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ee233fooEv,_ZTv0_n12_N4ee233fooEv)();
extern void ABISELECT(_ZThn16_N4ee233fooEv,_ZThn8_N4ee233fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4aa23__4ee23__4gg23[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ee23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee233fooEv,_ZTv0_n12_N4ee233fooEv),
};
extern void ABISELECT(_ZTv0_n24_N4ee233fooEv,_ZTv0_n12_N4ee233fooEv)();
extern void ABISELECT(_ZThn32_N4ee233fooEv,_ZThn16_N4ee233fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb23__4ee23__4gg23[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI4ee23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee233fooEv,_ZTv0_n12_N4ee233fooEv),
};
static  VTT_ENTRY vtt_gg23[] = {
  {&(_ZTV4gg23[6]),  6,25},
  {&(_tg__ZTV4ff23__4gg23[3]),  3,4},
  {&(_tg__ZTV4cc23__4ff23__4gg23[3]),  3,4},
  {&(_ZTV4gg23[12]),  12,25},
  {&(_ZTV4gg23[16]),  16,25},
  {&(_ZTV4gg23[20]),  20,25},
  {&(_ZTV4gg23[24]),  24,25},
  {&(_tg__ZTV4ee23__4gg23[4]),  4,5},
  {&(_tg__ZTV4aa23__4ee23__4gg23[3]),  3,4},
  {&(_tg__ZTV4bb23__4ee23__4gg23[3]),  3,4},
};
extern VTBL_ENTRY _ZTI4gg23[];
extern  VTBL_ENTRY _ZTV4gg23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg23[];
static VTBL_ENTRY alt_thunk_names57[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee233fooEv,_ZTv0_n12_N4ee233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ee233fooEv,_ZThn16_N4ee233fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee233fooEv,_ZThn8_N4ee233fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff233fooEv,_ZTv0_n12_N4ff233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N4ff233fooEv,_ZThn40_N4ff233fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg233fooEv,_ZTv0_n12_N4gg233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N4gg233fooEv,_ZThn40_N4gg233fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4gg233fooEv,_ZThn32_N4gg233fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N4gg233fooEv,_ZThn24_N4gg233fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N4gg233fooEv,_ZTv0_n20_N4gg233fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N4gg233fooEv,_ZThn16_N4gg233fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg23 = {  "gg23", // class name
  bases_gg23, 6,
  &(vtc_gg23[0]), // expected_vtbl_contents
  &(vtt_gg23[0]), // expected_vtt_contents
  ABISELECT(88,48), // object size
  NSPAIRA(_ZTI4gg23),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg23),25, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg23),10, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names57,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa24  {
  int a;
   aa24(); // _ZN4aa24C1Ev
  virtual void  foo(); // _ZN4aa243fooEv
  ~aa24(); // tgen
};
//SIG(-1 aa24) C1{ v1 Fi}


 aa24 ::aa24(){ note_ctor("aa24", this);}
void  aa24 ::foo(){vfunc_called(this, "_ZN4aa243fooEv");}
aa24 ::~aa24(){ note_dtor("aa24", this);} // tgen

static void Test_aa24()
{
  extern Class_Descriptor cd_aa24;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa24, buf);
    aa24 *dp, &lv = *(dp=new (buf) aa24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa24)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa24.a");
    test_class_info(&lv, &cd_aa24);
    dp->~aa24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa24(Test_aa24, "aa24", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa24C1Ev();
extern void _ZN4aa24D1Ev();
Name_Map name_map_aa24[] = {
  NSPAIR(_ZN4aa24C1Ev),
  NSPAIR(_ZN4aa24D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa24[];
extern void _ZN4aa243fooEv();
static  VTBL_ENTRY vtc_aa24[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa24[0]),
  (VTBL_ENTRY)&_ZN4aa243fooEv,
};
extern VTBL_ENTRY _ZTI4aa24[];
extern  VTBL_ENTRY _ZTV4aa24[];
Class_Descriptor cd_aa24 = {  "aa24", // class name
  0,0,//no base classes
  &(vtc_aa24[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa24),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa24),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb24  {
  int b;
   bb24(); // _ZN4bb24C1Ev
  virtual void  foo(); // _ZN4bb243fooEv
  ~bb24(); // tgen
};
//SIG(-1 bb24) C1{ v1 Fi}


 bb24 ::bb24(){ note_ctor("bb24", this);}
void  bb24 ::foo(){vfunc_called(this, "_ZN4bb243fooEv");}
bb24 ::~bb24(){ note_dtor("bb24", this);} // tgen

static void Test_bb24()
{
  extern Class_Descriptor cd_bb24;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb24, buf);
    bb24 *dp, &lv = *(dp=new (buf) bb24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb24)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb24.b");
    test_class_info(&lv, &cd_bb24);
    dp->~bb24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb24(Test_bb24, "bb24", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb24C1Ev();
extern void _ZN4bb24D1Ev();
Name_Map name_map_bb24[] = {
  NSPAIR(_ZN4bb24C1Ev),
  NSPAIR(_ZN4bb24D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb24[];
extern void _ZN4bb243fooEv();
static  VTBL_ENTRY vtc_bb24[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb24[0]),
  (VTBL_ENTRY)&_ZN4bb243fooEv,
};
extern VTBL_ENTRY _ZTI4bb24[];
extern  VTBL_ENTRY _ZTV4bb24[];
Class_Descriptor cd_bb24 = {  "bb24", // class name
  0,0,//no base classes
  &(vtc_bb24[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb24),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb24),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc24  {
  int c;
   cc24(); // _ZN4cc24C1Ev
  virtual void  foo(); // _ZN4cc243fooEv
  ~cc24(); // tgen
};
//SIG(-1 cc24) C1{ v1 Fi}


 cc24 ::cc24(){ note_ctor("cc24", this);}
void  cc24 ::foo(){vfunc_called(this, "_ZN4cc243fooEv");}
cc24 ::~cc24(){ note_dtor("cc24", this);} // tgen

static void Test_cc24()
{
  extern Class_Descriptor cd_cc24;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc24, buf);
    cc24 *dp, &lv = *(dp=new (buf) cc24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc24)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc24.c");
    test_class_info(&lv, &cd_cc24);
    dp->~cc24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc24(Test_cc24, "cc24", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc24C1Ev();
extern void _ZN4cc24D1Ev();
Name_Map name_map_cc24[] = {
  NSPAIR(_ZN4cc24C1Ev),
  NSPAIR(_ZN4cc24D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc24[];
extern void _ZN4cc243fooEv();
static  VTBL_ENTRY vtc_cc24[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc24[0]),
  (VTBL_ENTRY)&_ZN4cc243fooEv,
};
extern VTBL_ENTRY _ZTI4cc24[];
extern  VTBL_ENTRY _ZTV4cc24[];
Class_Descriptor cd_cc24 = {  "cc24", // class name
  0,0,//no base classes
  &(vtc_cc24[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc24),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc24),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd24  {
  int d;
   dd24(); // _ZN4dd24C1Ev
  virtual void  foo(); // _ZN4dd243fooEv
  ~dd24(); // tgen
};
//SIG(-1 dd24) C1{ v1 Fi}


 dd24 ::dd24(){ note_ctor("dd24", this);}
void  dd24 ::foo(){vfunc_called(this, "_ZN4dd243fooEv");}
dd24 ::~dd24(){ note_dtor("dd24", this);} // tgen

static void Test_dd24()
{
  extern Class_Descriptor cd_dd24;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd24, buf);
    dd24 *dp, &lv = *(dp=new (buf) dd24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd24)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd24.d");
    test_class_info(&lv, &cd_dd24);
    dp->~dd24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd24(Test_dd24, "dd24", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd24C1Ev();
extern void _ZN4dd24D1Ev();
Name_Map name_map_dd24[] = {
  NSPAIR(_ZN4dd24C1Ev),
  NSPAIR(_ZN4dd24D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd24[];
extern void _ZN4dd243fooEv();
static  VTBL_ENTRY vtc_dd24[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd24[0]),
  (VTBL_ENTRY)&_ZN4dd243fooEv,
};
extern VTBL_ENTRY _ZTI4dd24[];
extern  VTBL_ENTRY _ZTV4dd24[];
Class_Descriptor cd_dd24 = {  "dd24", // class name
  0,0,//no base classes
  &(vtc_dd24[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd24),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd24),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee24  : aa24 , bb24 {
  int e;
   ee24(); // _ZN4ee24C1Ev
  virtual void  foo(); // _ZN4ee243fooEv
  ~ee24(); // tgen
};
//SIG(-1 ee24) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ee24 ::ee24(){ note_ctor("ee24", this);}
void  ee24 ::foo(){vfunc_called(this, "_ZN4ee243fooEv");}
ee24 ::~ee24(){ note_dtor("ee24", this);} // tgen

static void Test_ee24()
{
  extern Class_Descriptor cd_ee24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee24, buf);
    ee24 *dp, &lv = *(dp=new (buf) ee24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee24)");
    check_base_class_offset(lv, (aa24*), 0, "ee24");
    check_base_class_offset(lv, (bb24*), ABISELECT(16,8), "ee24");
    check_field_offset(lv, e, ABISELECT(28,16), "ee24.e");
    test_class_info(&lv, &cd_ee24);
    dp->~ee24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee24(Test_ee24, "ee24", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ee24C1Ev();
extern void _ZN4ee24D1Ev();
Name_Map name_map_ee24[] = {
  NSPAIR(_ZN4ee24C1Ev),
  NSPAIR(_ZN4ee24D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa24;
extern VTBL_ENTRY _ZTI4aa24[];
extern  VTBL_ENTRY _ZTV4aa24[];
extern Class_Descriptor cd_bb24;
extern VTBL_ENTRY _ZTI4bb24[];
extern  VTBL_ENTRY _ZTV4bb24[];
static Base_Class bases_ee24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa24,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_bb24,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ee24[];
extern void _ZN4ee243fooEv();
extern void ABISELECT(_ZThn16_N4ee243fooEv,_ZThn8_N4ee243fooEv)();
static  VTBL_ENTRY vtc_ee24[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4ee24[0]),
  (VTBL_ENTRY)&_ZN4ee243fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ee24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4ee243fooEv,_ZThn8_N4ee243fooEv),
};
extern VTBL_ENTRY _ZTI4ee24[];
extern  VTBL_ENTRY _ZTV4ee24[];
Class_Descriptor cd_ee24 = {  "ee24", // class name
  bases_ee24, 2,
  &(vtc_ee24[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ee24),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee24),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff24  : cc24 , virtual dd24 {
  int f;
   ff24(const ABISELECT(__tsi64,int) *const *); // _ZN4ff24C2Ev
  virtual void  foo(); // _ZN4ff243fooEv
  ~ff24(); // tgen
  ff24(); // tgen
};
//SIG(-1 ff24) C1{ BC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ff24 ::ff24(const ABISELECT(__tsi64,int) *const *){}
void  ff24 ::foo(){vfunc_called(this, "_ZN4ff243fooEv");}
ff24 ::~ff24(){ note_dtor("ff24", this);} // tgen
ff24 ::ff24(){ note_ctor("ff24", this);} // tgen

static void Test_ff24()
{
  extern Class_Descriptor cd_ff24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff24, buf);
    ff24 *dp, &lv = *(dp=new (buf) ff24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff24)");
    check_base_class_offset(lv, (cc24*), 0, "ff24");
    check_base_class_offset(lv, (dd24*), ABISELECT(16,12), "ff24");
    check_field_offset(lv, f, ABISELECT(12,8), "ff24.f");
    test_class_info(&lv, &cd_ff24);
    dp->~ff24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff24(Test_ff24, "ff24", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ff24C1Ev();
extern void _ZN4ff24D1Ev();
Name_Map name_map_ff24[] = {
  NSPAIR(_ZN4ff24C1Ev),
  NSPAIR(_ZN4ff24D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc24;
extern VTBL_ENTRY _ZTI4cc24[];
extern  VTBL_ENTRY _ZTV4cc24[];
extern Class_Descriptor cd_dd24;
extern VTBL_ENTRY _ZTI4dd24[];
extern  VTBL_ENTRY _ZTV4dd24[];
static Base_Class bases_ff24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc24,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_dd24,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ff24[];
extern void _ZN4ff243fooEv();
extern void ABISELECT(_ZTv0_n24_N4ff243fooEv,_ZTv0_n12_N4ff243fooEv)();
extern void ABISELECT(_ZThn16_N4ff243fooEv,_ZThn12_N4ff243fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff24[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff24[0]),
  (VTBL_ENTRY)&_ZN4ff243fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff243fooEv,_ZTv0_n12_N4ff243fooEv),
};
extern VTBL_ENTRY _ZTV4ff24[];
static  VTT_ENTRY vtt_ff24[] = {
  {&(_ZTV4ff24[3]),  3,8},
  {&(_ZTV4ff24[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ff24[];
extern  VTBL_ENTRY _ZTV4ff24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff24[];
static VTBL_ENTRY alt_thunk_names58[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff243fooEv,_ZTv0_n12_N4ff243fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff243fooEv,_ZThn12_N4ff243fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff24 = {  "ff24", // class name
  bases_ff24, 2,
  &(vtc_ff24[0]), // expected_vtbl_contents
  &(vtt_ff24[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ff24),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff24),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ff24),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names58,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg24  : virtual ee24 , ff24 {
  int g;
   gg24(const ABISELECT(__tsi64,int) *const *); // _ZN4gg24C2Ev
  virtual void  foo(); // _ZN4gg243fooEv
  ~gg24(); // tgen
  gg24(); // tgen
};
//SIG(1 gg24) C1{ VBC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 Fi} VBC7{ v1 Fi} v1 Fi} v1 Fi}


 gg24 ::gg24(const ABISELECT(__tsi64,int) *const *){}
void  gg24 ::foo(){vfunc_called(this, "_ZN4gg243fooEv");}
gg24 ::~gg24(){ note_dtor("gg24", this);} // tgen
gg24 ::gg24(){ note_ctor("gg24", this);} // tgen

static void Test_gg24()
{
  extern Class_Descriptor cd_gg24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg24, buf);
    gg24 *dp, &lv = *(dp=new (buf) gg24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg24)");
    check_base_class_offset(lv, (aa24*)(ee24*), ABISELECT(24,16), "gg24");
    check_base_class_offset(lv, (bb24*)(ee24*), ABISELECT(40,24), "gg24");
    check_base_class_offset(lv, (ee24*), ABISELECT(24,16), "gg24");
    check_base_class_offset(lv, (cc24*)(ff24*), 0, "gg24");
    check_base_class_offset(lv, (dd24*)(ff24*), ABISELECT(56,36), "gg24");
    check_base_class_offset(lv, (ff24*), 0, "gg24");
    check_field_offset(lv, g, ABISELECT(16,12), "gg24.g");
    test_class_info(&lv, &cd_gg24);
    dp->~gg24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg24(Test_gg24, "gg24", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN4gg24C1Ev();
extern void _ZN4gg24D1Ev();
Name_Map name_map_gg24[] = {
  NSPAIR(_ZN4gg24C1Ev),
  NSPAIR(_ZN4gg24D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa24;
extern VTBL_ENTRY _ZTI4aa24[];
extern  VTBL_ENTRY _ZTV4aa24[];
extern Class_Descriptor cd_bb24;
extern VTBL_ENTRY _ZTI4bb24[];
extern  VTBL_ENTRY _ZTV4bb24[];
extern Class_Descriptor cd_ee24;
extern VTBL_ENTRY _ZTI4ee24[];
extern  VTBL_ENTRY _ZTV4ee24[];
extern Class_Descriptor cd_cc24;
extern VTBL_ENTRY _ZTI4cc24[];
extern  VTBL_ENTRY _ZTV4cc24[];
extern Class_Descriptor cd_dd24;
extern VTBL_ENTRY _ZTI4dd24[];
extern  VTBL_ENTRY _ZTV4dd24[];
extern Class_Descriptor cd_ff24;
extern VTBL_ENTRY _ZTI4ff24[];
extern  VTBL_ENTRY _ZTV4ff24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff24[];
static Base_Class bases_gg24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa24,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_bb24,    ABISELECT(40,24), //bcp->offset
    9, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_ee24,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_cc24,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_dd24,    ABISELECT(56,36), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_ff24,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4gg24[];
extern void _ZN4gg243fooEv();
extern void ABISELECT(_ZTv0_n24_N4gg243fooEv,_ZTv0_n12_N4gg243fooEv)();
extern void ABISELECT(_ZThn24_N4gg243fooEv,_ZThn16_N4gg243fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n24_N4gg243fooEv,_ZTvn8_n12_N4gg243fooEv)();
extern void ABISELECT(_ZTv0_n24_N4gg243fooEv,_ZTv0_n12_N4gg243fooEv)();
extern void ABISELECT(_ZThn56_N4gg243fooEv,_ZThn36_N4gg243fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg24[] = {
  ABISELECT(24,16),
  ABISELECT(56,36),
  0,
  (VTBL_ENTRY)&(_ZTI4gg24[0]),
  (VTBL_ENTRY)&_ZN4gg243fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI4gg24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg243fooEv,_ZTv0_n12_N4gg243fooEv),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI4gg24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N4gg243fooEv,_ZTvn8_n12_N4gg243fooEv),
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI4gg24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg243fooEv,_ZTv0_n12_N4gg243fooEv),
};
extern VTBL_ENTRY _ZTV4gg24[];
extern void _ZN4ff243fooEv();
static  VTBL_ENTRY _tg__ZTV4ff24__4gg24[] = {
  ABISELECT(56,36),
  0,
  (VTBL_ENTRY)&(_ZTI4ff24[0]),
  (VTBL_ENTRY)&_ZN4ff243fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ff243fooEv,_ZTv0_n12_N4ff243fooEv)();
extern void ABISELECT(_ZThn56_N4ff243fooEv,_ZThn36_N4ff243fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4dd24__4ff24__4gg24[] = {
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI4ff24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff243fooEv,_ZTv0_n12_N4ff243fooEv),
};
static  VTT_ENTRY vtt_gg24[] = {
  {&(_ZTV4gg24[4]),  4,16},
  {&(_tg__ZTV4ff24__4gg24[3]),  3,4},
  {&(_tg__ZTV4dd24__4ff24__4gg24[3]),  3,4},
  {&(_ZTV4gg24[8]),  8,16},
  {&(_ZTV4gg24[11]),  11,16},
  {&(_ZTV4gg24[15]),  15,16},
};
extern VTBL_ENTRY _ZTI4gg24[];
extern  VTBL_ENTRY _ZTV4gg24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg24[];
static VTBL_ENTRY alt_thunk_names59[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff243fooEv,_ZTv0_n12_N4ff243fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4ff243fooEv,_ZThn36_N4ff243fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg243fooEv,_ZTv0_n12_N4gg243fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4gg243fooEv,_ZThn36_N4gg243fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N4gg243fooEv,_ZThn16_N4gg243fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg24 = {  "gg24", // class name
  bases_gg24, 6,
  &(vtc_gg24[0]), // expected_vtbl_contents
  &(vtt_gg24[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI4gg24),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg24),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg24),6, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names59,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa25  {
  int a;
   aa25(); // _ZN4aa25C1Ev
  virtual void  foo(); // _ZN4aa253fooEv
  ~aa25(); // tgen
};
//SIG(-1 aa25) C1{ v1 Fi}


 aa25 ::aa25(){ note_ctor("aa25", this);}
void  aa25 ::foo(){vfunc_called(this, "_ZN4aa253fooEv");}
aa25 ::~aa25(){ note_dtor("aa25", this);} // tgen

static void Test_aa25()
{
  extern Class_Descriptor cd_aa25;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa25, buf);
    aa25 *dp, &lv = *(dp=new (buf) aa25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa25)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa25.a");
    test_class_info(&lv, &cd_aa25);
    dp->~aa25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa25(Test_aa25, "aa25", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa25C1Ev();
extern void _ZN4aa25D1Ev();
Name_Map name_map_aa25[] = {
  NSPAIR(_ZN4aa25C1Ev),
  NSPAIR(_ZN4aa25D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa25[];
extern void _ZN4aa253fooEv();
static  VTBL_ENTRY vtc_aa25[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa25[0]),
  (VTBL_ENTRY)&_ZN4aa253fooEv,
};
extern VTBL_ENTRY _ZTI4aa25[];
extern  VTBL_ENTRY _ZTV4aa25[];
Class_Descriptor cd_aa25 = {  "aa25", // class name
  0,0,//no base classes
  &(vtc_aa25[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa25),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa25),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb25  {
  int b;
   bb25(); // _ZN4bb25C1Ev
  virtual void  foo(); // _ZN4bb253fooEv
  ~bb25(); // tgen
};
//SIG(-1 bb25) C1{ v1 Fi}


 bb25 ::bb25(){ note_ctor("bb25", this);}
void  bb25 ::foo(){vfunc_called(this, "_ZN4bb253fooEv");}
bb25 ::~bb25(){ note_dtor("bb25", this);} // tgen

static void Test_bb25()
{
  extern Class_Descriptor cd_bb25;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb25, buf);
    bb25 *dp, &lv = *(dp=new (buf) bb25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb25)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb25.b");
    test_class_info(&lv, &cd_bb25);
    dp->~bb25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb25(Test_bb25, "bb25", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb25C1Ev();
extern void _ZN4bb25D1Ev();
Name_Map name_map_bb25[] = {
  NSPAIR(_ZN4bb25C1Ev),
  NSPAIR(_ZN4bb25D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb25[];
extern void _ZN4bb253fooEv();
static  VTBL_ENTRY vtc_bb25[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb25[0]),
  (VTBL_ENTRY)&_ZN4bb253fooEv,
};
extern VTBL_ENTRY _ZTI4bb25[];
extern  VTBL_ENTRY _ZTV4bb25[];
Class_Descriptor cd_bb25 = {  "bb25", // class name
  0,0,//no base classes
  &(vtc_bb25[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb25),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb25),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc25  {
  int c;
   cc25(); // _ZN4cc25C1Ev
  virtual void  foo(); // _ZN4cc253fooEv
  ~cc25(); // tgen
};
//SIG(-1 cc25) C1{ v1 Fi}


 cc25 ::cc25(){ note_ctor("cc25", this);}
void  cc25 ::foo(){vfunc_called(this, "_ZN4cc253fooEv");}
cc25 ::~cc25(){ note_dtor("cc25", this);} // tgen

static void Test_cc25()
{
  extern Class_Descriptor cd_cc25;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc25, buf);
    cc25 *dp, &lv = *(dp=new (buf) cc25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc25)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc25.c");
    test_class_info(&lv, &cd_cc25);
    dp->~cc25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc25(Test_cc25, "cc25", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc25C1Ev();
extern void _ZN4cc25D1Ev();
Name_Map name_map_cc25[] = {
  NSPAIR(_ZN4cc25C1Ev),
  NSPAIR(_ZN4cc25D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc25[];
extern void _ZN4cc253fooEv();
static  VTBL_ENTRY vtc_cc25[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc25[0]),
  (VTBL_ENTRY)&_ZN4cc253fooEv,
};
extern VTBL_ENTRY _ZTI4cc25[];
extern  VTBL_ENTRY _ZTV4cc25[];
Class_Descriptor cd_cc25 = {  "cc25", // class name
  0,0,//no base classes
  &(vtc_cc25[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc25),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc25),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd25  {
  int d;
   dd25(); // _ZN4dd25C1Ev
  virtual void  foo(); // _ZN4dd253fooEv
  ~dd25(); // tgen
};
//SIG(-1 dd25) C1{ v1 Fi}


 dd25 ::dd25(){ note_ctor("dd25", this);}
void  dd25 ::foo(){vfunc_called(this, "_ZN4dd253fooEv");}
dd25 ::~dd25(){ note_dtor("dd25", this);} // tgen

static void Test_dd25()
{
  extern Class_Descriptor cd_dd25;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd25, buf);
    dd25 *dp, &lv = *(dp=new (buf) dd25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd25)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd25.d");
    test_class_info(&lv, &cd_dd25);
    dp->~dd25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd25(Test_dd25, "dd25", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd25C1Ev();
extern void _ZN4dd25D1Ev();
Name_Map name_map_dd25[] = {
  NSPAIR(_ZN4dd25C1Ev),
  NSPAIR(_ZN4dd25D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd25[];
extern void _ZN4dd253fooEv();
static  VTBL_ENTRY vtc_dd25[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd25[0]),
  (VTBL_ENTRY)&_ZN4dd253fooEv,
};
extern VTBL_ENTRY _ZTI4dd25[];
extern  VTBL_ENTRY _ZTV4dd25[];
Class_Descriptor cd_dd25 = {  "dd25", // class name
  0,0,//no base classes
  &(vtc_dd25[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd25),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd25),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee25  : virtual aa25 , bb25 {
  int e;
   ee25(const ABISELECT(__tsi64,int) *const *); // _ZN4ee25C2Ev
  virtual void  foo(); // _ZN4ee253fooEv
  ~ee25(); // tgen
  ee25(); // tgen
};
//SIG(-1 ee25) C1{ VBC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ee25 ::ee25(const ABISELECT(__tsi64,int) *const *){}
void  ee25 ::foo(){vfunc_called(this, "_ZN4ee253fooEv");}
ee25 ::~ee25(){ note_dtor("ee25", this);} // tgen
ee25 ::ee25(){ note_ctor("ee25", this);} // tgen

static void Test_ee25()
{
  extern Class_Descriptor cd_ee25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee25, buf);
    ee25 *dp, &lv = *(dp=new (buf) ee25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee25)");
    check_base_class_offset(lv, (aa25*), ABISELECT(16,12), "ee25");
    check_base_class_offset(lv, (bb25*), 0, "ee25");
    check_field_offset(lv, e, ABISELECT(12,8), "ee25.e");
    test_class_info(&lv, &cd_ee25);
    dp->~ee25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee25(Test_ee25, "ee25", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ee25C1Ev();
extern void _ZN4ee25D1Ev();
Name_Map name_map_ee25[] = {
  NSPAIR(_ZN4ee25C1Ev),
  NSPAIR(_ZN4ee25D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa25;
extern VTBL_ENTRY _ZTI4aa25[];
extern  VTBL_ENTRY _ZTV4aa25[];
extern Class_Descriptor cd_bb25;
extern VTBL_ENTRY _ZTI4bb25[];
extern  VTBL_ENTRY _ZTV4bb25[];
static Base_Class bases_ee25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa25,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_bb25,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ee25[];
extern void _ZN4ee253fooEv();
extern void ABISELECT(_ZTv0_n24_N4ee253fooEv,_ZTv0_n12_N4ee253fooEv)();
extern void ABISELECT(_ZThn16_N4ee253fooEv,_ZThn12_N4ee253fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee25[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee25[0]),
  (VTBL_ENTRY)&_ZN4ee253fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee253fooEv,_ZTv0_n12_N4ee253fooEv),
};
extern VTBL_ENTRY _ZTV4ee25[];
static  VTT_ENTRY vtt_ee25[] = {
  {&(_ZTV4ee25[3]),  3,8},
  {&(_ZTV4ee25[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ee25[];
extern  VTBL_ENTRY _ZTV4ee25[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee25[];
static VTBL_ENTRY alt_thunk_names60[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee253fooEv,_ZTv0_n12_N4ee253fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee253fooEv,_ZThn12_N4ee253fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee25 = {  "ee25", // class name
  bases_ee25, 2,
  &(vtc_ee25[0]), // expected_vtbl_contents
  &(vtt_ee25[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ee25),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee25),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ee25),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names60,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff25  : cc25 , virtual dd25 {
  int f;
   ff25(const ABISELECT(__tsi64,int) *const *); // _ZN4ff25C2Ev
  virtual void  foo(); // _ZN4ff253fooEv
  ~ff25(); // tgen
  ff25(); // tgen
};
//SIG(-1 ff25) C1{ BC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ff25 ::ff25(const ABISELECT(__tsi64,int) *const *){}
void  ff25 ::foo(){vfunc_called(this, "_ZN4ff253fooEv");}
ff25 ::~ff25(){ note_dtor("ff25", this);} // tgen
ff25 ::ff25(){ note_ctor("ff25", this);} // tgen

static void Test_ff25()
{
  extern Class_Descriptor cd_ff25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff25, buf);
    ff25 *dp, &lv = *(dp=new (buf) ff25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff25)");
    check_base_class_offset(lv, (cc25*), 0, "ff25");
    check_base_class_offset(lv, (dd25*), ABISELECT(16,12), "ff25");
    check_field_offset(lv, f, ABISELECT(12,8), "ff25.f");
    test_class_info(&lv, &cd_ff25);
    dp->~ff25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff25(Test_ff25, "ff25", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ff25C1Ev();
extern void _ZN4ff25D1Ev();
Name_Map name_map_ff25[] = {
  NSPAIR(_ZN4ff25C1Ev),
  NSPAIR(_ZN4ff25D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc25;
extern VTBL_ENTRY _ZTI4cc25[];
extern  VTBL_ENTRY _ZTV4cc25[];
extern Class_Descriptor cd_dd25;
extern VTBL_ENTRY _ZTI4dd25[];
extern  VTBL_ENTRY _ZTV4dd25[];
static Base_Class bases_ff25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc25,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_dd25,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ff25[];
extern void _ZN4ff253fooEv();
extern void ABISELECT(_ZTv0_n24_N4ff253fooEv,_ZTv0_n12_N4ff253fooEv)();
extern void ABISELECT(_ZThn16_N4ff253fooEv,_ZThn12_N4ff253fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff25[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff25[0]),
  (VTBL_ENTRY)&_ZN4ff253fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff253fooEv,_ZTv0_n12_N4ff253fooEv),
};
extern VTBL_ENTRY _ZTV4ff25[];
static  VTT_ENTRY vtt_ff25[] = {
  {&(_ZTV4ff25[3]),  3,8},
  {&(_ZTV4ff25[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ff25[];
extern  VTBL_ENTRY _ZTV4ff25[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff25[];
static VTBL_ENTRY alt_thunk_names61[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff253fooEv,_ZTv0_n12_N4ff253fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff253fooEv,_ZThn12_N4ff253fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff25 = {  "ff25", // class name
  bases_ff25, 2,
  &(vtc_ff25[0]), // expected_vtbl_contents
  &(vtt_ff25[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ff25),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff25),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ff25),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names61,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg25  : virtual ee25 , ff25 {
  int g;
   gg25(const ABISELECT(__tsi64,int) *const *); // _ZN4gg25C2Ev
  virtual void  foo(); // _ZN4gg253fooEv
  ~gg25(); // tgen
  gg25(); // tgen
};
//SIG(1 gg25) C1{ VBC2{ VBC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 Fi} VBC7{ v1 Fi} v1 Fi} v1 Fi}


 gg25 ::gg25(const ABISELECT(__tsi64,int) *const *){}
void  gg25 ::foo(){vfunc_called(this, "_ZN4gg253fooEv");}
gg25 ::~gg25(){ note_dtor("gg25", this);} // tgen
gg25 ::gg25(){ note_ctor("gg25", this);} // tgen

static void Test_gg25()
{
  extern Class_Descriptor cd_gg25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg25, buf);
    gg25 *dp, &lv = *(dp=new (buf) gg25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg25)");
    check_base_class_offset(lv, (aa25*)(ee25*), ABISELECT(40,28), "gg25");
    check_base_class_offset(lv, (bb25*)(ee25*), ABISELECT(24,16), "gg25");
    check_base_class_offset(lv, (ee25*), ABISELECT(24,16), "gg25");
    check_base_class_offset(lv, (cc25*)(ff25*), 0, "gg25");
    check_base_class_offset(lv, (dd25*)(ff25*), ABISELECT(56,36), "gg25");
    check_base_class_offset(lv, (ff25*), 0, "gg25");
    check_field_offset(lv, g, ABISELECT(16,12), "gg25.g");
    test_class_info(&lv, &cd_gg25);
    dp->~gg25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg25(Test_gg25, "gg25", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN4gg25C1Ev();
extern void _ZN4gg25D1Ev();
Name_Map name_map_gg25[] = {
  NSPAIR(_ZN4gg25C1Ev),
  NSPAIR(_ZN4gg25D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa25;
extern VTBL_ENTRY _ZTI4aa25[];
extern  VTBL_ENTRY _ZTV4aa25[];
extern Class_Descriptor cd_bb25;
extern VTBL_ENTRY _ZTI4bb25[];
extern  VTBL_ENTRY _ZTV4bb25[];
extern Class_Descriptor cd_ee25;
extern VTBL_ENTRY _ZTI4ee25[];
extern  VTBL_ENTRY _ZTV4ee25[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee25[];
extern Class_Descriptor cd_cc25;
extern VTBL_ENTRY _ZTI4cc25[];
extern  VTBL_ENTRY _ZTV4cc25[];
extern Class_Descriptor cd_dd25;
extern VTBL_ENTRY _ZTI4dd25[];
extern  VTBL_ENTRY _ZTV4dd25[];
extern Class_Descriptor cd_ff25;
extern VTBL_ENTRY _ZTI4ff25[];
extern  VTBL_ENTRY _ZTV4ff25[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff25[];
static Base_Class bases_gg25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa25,    ABISELECT(40,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_bb25,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_ee25,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_cc25,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_dd25,    ABISELECT(56,36), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_ff25,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4gg25[];
extern void _ZN4gg253fooEv();
extern void ABISELECT(_ZTv0_n32_N4gg253fooEv,_ZTv0_n16_N4gg253fooEv)();
extern void ABISELECT(_ZThn24_N4gg253fooEv,_ZThn16_N4gg253fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg253fooEv,_ZTv0_n12_N4gg253fooEv)();
extern void ABISELECT(_ZThn40_N4gg253fooEv,_ZThn28_N4gg253fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg253fooEv,_ZTv0_n12_N4gg253fooEv)();
extern void ABISELECT(_ZThn56_N4gg253fooEv,_ZThn36_N4gg253fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg25[] = {
  ABISELECT(40,28),
  ABISELECT(24,16),
  ABISELECT(56,36),
  0,
  (VTBL_ENTRY)&(_ZTI4gg25[0]),
  (VTBL_ENTRY)&_ZN4gg253fooEv,
  ABISELECT(-24,-16),
  ABISELECT(16,12),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI4gg25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N4gg253fooEv,_ZTv0_n16_N4gg253fooEv),
  ABISELECT(-40,-28),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI4gg25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg253fooEv,_ZTv0_n12_N4gg253fooEv),
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI4gg25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg253fooEv,_ZTv0_n12_N4gg253fooEv),
};
extern VTBL_ENTRY _ZTV4gg25[];
extern void _ZN4ff253fooEv();
static  VTBL_ENTRY _tg__ZTV4ff25__4gg25[] = {
  ABISELECT(56,36),
  0,
  (VTBL_ENTRY)&(_ZTI4ff25[0]),
  (VTBL_ENTRY)&_ZN4ff253fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ff253fooEv,_ZTv0_n12_N4ff253fooEv)();
extern void ABISELECT(_ZThn56_N4ff253fooEv,_ZThn36_N4ff253fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4dd25__4ff25__4gg25[] = {
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI4ff25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff253fooEv,_ZTv0_n12_N4ff253fooEv),
};
extern void _ZN4ee253fooEv();
static  VTBL_ENTRY _tg__ZTV4ee25__4gg25[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee25[0]),
  (VTBL_ENTRY)&_ZN4ee253fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ee253fooEv,_ZTv0_n12_N4ee253fooEv)();
extern void ABISELECT(_ZThn16_N4ee253fooEv,_ZThn12_N4ee253fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4aa25__4ee25__4gg25[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee25[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee253fooEv,_ZTv0_n12_N4ee253fooEv),
};
static  VTT_ENTRY vtt_gg25[] = {
  {&(_ZTV4gg25[5]),  5,19},
  {&(_tg__ZTV4ff25__4gg25[3]),  3,4},
  {&(_tg__ZTV4dd25__4ff25__4gg25[3]),  3,4},
  {&(_ZTV4gg25[10]),  10,19},
  {&(_ZTV4gg25[14]),  14,19},
  {&(_ZTV4gg25[18]),  18,19},
  {&(_tg__ZTV4ee25__4gg25[3]),  3,4},
  {&(_tg__ZTV4aa25__4ee25__4gg25[3]),  3,4},
};
extern VTBL_ENTRY _ZTI4gg25[];
extern  VTBL_ENTRY _ZTV4gg25[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg25[];
static VTBL_ENTRY alt_thunk_names62[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee253fooEv,_ZTv0_n12_N4ee253fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee253fooEv,_ZThn12_N4ee253fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff253fooEv,_ZTv0_n12_N4ff253fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4ff253fooEv,_ZThn36_N4ff253fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg253fooEv,_ZTv0_n12_N4gg253fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4gg253fooEv,_ZThn36_N4gg253fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N4gg253fooEv,_ZThn28_N4gg253fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N4gg253fooEv,_ZTv0_n16_N4gg253fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N4gg253fooEv,_ZThn16_N4gg253fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg25 = {  "gg25", // class name
  bases_gg25, 6,
  &(vtc_gg25[0]), // expected_vtbl_contents
  &(vtt_gg25[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI4gg25),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg25),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg25),8, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names62,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa26  {
  int a;
   aa26(); // _ZN4aa26C1Ev
  virtual void  foo(); // _ZN4aa263fooEv
  ~aa26(); // tgen
};
//SIG(-1 aa26) C1{ v1 Fi}


 aa26 ::aa26(){ note_ctor("aa26", this);}
void  aa26 ::foo(){vfunc_called(this, "_ZN4aa263fooEv");}
aa26 ::~aa26(){ note_dtor("aa26", this);} // tgen

static void Test_aa26()
{
  extern Class_Descriptor cd_aa26;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa26, buf);
    aa26 *dp, &lv = *(dp=new (buf) aa26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa26)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa26.a");
    test_class_info(&lv, &cd_aa26);
    dp->~aa26();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa26(Test_aa26, "aa26", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa26C1Ev();
extern void _ZN4aa26D1Ev();
Name_Map name_map_aa26[] = {
  NSPAIR(_ZN4aa26C1Ev),
  NSPAIR(_ZN4aa26D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa26[];
extern void _ZN4aa263fooEv();
static  VTBL_ENTRY vtc_aa26[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa26[0]),
  (VTBL_ENTRY)&_ZN4aa263fooEv,
};
extern VTBL_ENTRY _ZTI4aa26[];
extern  VTBL_ENTRY _ZTV4aa26[];
Class_Descriptor cd_aa26 = {  "aa26", // class name
  0,0,//no base classes
  &(vtc_aa26[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa26),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa26),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb26  {
  int b;
   bb26(); // _ZN4bb26C1Ev
  virtual void  foo(); // _ZN4bb263fooEv
  ~bb26(); // tgen
};
//SIG(-1 bb26) C1{ v1 Fi}


 bb26 ::bb26(){ note_ctor("bb26", this);}
void  bb26 ::foo(){vfunc_called(this, "_ZN4bb263fooEv");}
bb26 ::~bb26(){ note_dtor("bb26", this);} // tgen

static void Test_bb26()
{
  extern Class_Descriptor cd_bb26;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb26, buf);
    bb26 *dp, &lv = *(dp=new (buf) bb26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb26)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb26.b");
    test_class_info(&lv, &cd_bb26);
    dp->~bb26();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb26(Test_bb26, "bb26", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb26C1Ev();
extern void _ZN4bb26D1Ev();
Name_Map name_map_bb26[] = {
  NSPAIR(_ZN4bb26C1Ev),
  NSPAIR(_ZN4bb26D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb26[];
extern void _ZN4bb263fooEv();
static  VTBL_ENTRY vtc_bb26[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb26[0]),
  (VTBL_ENTRY)&_ZN4bb263fooEv,
};
extern VTBL_ENTRY _ZTI4bb26[];
extern  VTBL_ENTRY _ZTV4bb26[];
Class_Descriptor cd_bb26 = {  "bb26", // class name
  0,0,//no base classes
  &(vtc_bb26[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb26),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb26),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc26  {
  int c;
   cc26(); // _ZN4cc26C1Ev
  virtual void  foo(); // _ZN4cc263fooEv
  ~cc26(); // tgen
};
//SIG(-1 cc26) C1{ v1 Fi}


 cc26 ::cc26(){ note_ctor("cc26", this);}
void  cc26 ::foo(){vfunc_called(this, "_ZN4cc263fooEv");}
cc26 ::~cc26(){ note_dtor("cc26", this);} // tgen

static void Test_cc26()
{
  extern Class_Descriptor cd_cc26;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc26, buf);
    cc26 *dp, &lv = *(dp=new (buf) cc26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc26)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc26.c");
    test_class_info(&lv, &cd_cc26);
    dp->~cc26();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc26(Test_cc26, "cc26", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc26C1Ev();
extern void _ZN4cc26D1Ev();
Name_Map name_map_cc26[] = {
  NSPAIR(_ZN4cc26C1Ev),
  NSPAIR(_ZN4cc26D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc26[];
extern void _ZN4cc263fooEv();
static  VTBL_ENTRY vtc_cc26[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc26[0]),
  (VTBL_ENTRY)&_ZN4cc263fooEv,
};
extern VTBL_ENTRY _ZTI4cc26[];
extern  VTBL_ENTRY _ZTV4cc26[];
Class_Descriptor cd_cc26 = {  "cc26", // class name
  0,0,//no base classes
  &(vtc_cc26[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc26),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc26),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd26  {
  int d;
   dd26(); // _ZN4dd26C1Ev
  virtual void  foo(); // _ZN4dd263fooEv
  ~dd26(); // tgen
};
//SIG(-1 dd26) C1{ v1 Fi}


 dd26 ::dd26(){ note_ctor("dd26", this);}
void  dd26 ::foo(){vfunc_called(this, "_ZN4dd263fooEv");}
dd26 ::~dd26(){ note_dtor("dd26", this);} // tgen

static void Test_dd26()
{
  extern Class_Descriptor cd_dd26;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd26, buf);
    dd26 *dp, &lv = *(dp=new (buf) dd26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd26)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd26.d");
    test_class_info(&lv, &cd_dd26);
    dp->~dd26();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd26(Test_dd26, "dd26", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd26C1Ev();
extern void _ZN4dd26D1Ev();
Name_Map name_map_dd26[] = {
  NSPAIR(_ZN4dd26C1Ev),
  NSPAIR(_ZN4dd26D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd26[];
extern void _ZN4dd263fooEv();
static  VTBL_ENTRY vtc_dd26[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd26[0]),
  (VTBL_ENTRY)&_ZN4dd263fooEv,
};
extern VTBL_ENTRY _ZTI4dd26[];
extern  VTBL_ENTRY _ZTV4dd26[];
Class_Descriptor cd_dd26 = {  "dd26", // class name
  0,0,//no base classes
  &(vtc_dd26[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd26),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd26),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee26  : aa26 , virtual bb26 {
  int e;
   ee26(const ABISELECT(__tsi64,int) *const *); // _ZN4ee26C2Ev
  virtual void  foo(); // _ZN4ee263fooEv
  ~ee26(); // tgen
  ee26(); // tgen
};
//SIG(-1 ee26) C1{ BC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ee26 ::ee26(const ABISELECT(__tsi64,int) *const *){}
void  ee26 ::foo(){vfunc_called(this, "_ZN4ee263fooEv");}
ee26 ::~ee26(){ note_dtor("ee26", this);} // tgen
ee26 ::ee26(){ note_ctor("ee26", this);} // tgen

static void Test_ee26()
{
  extern Class_Descriptor cd_ee26;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee26, buf);
    ee26 *dp, &lv = *(dp=new (buf) ee26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee26)");
    check_base_class_offset(lv, (aa26*), 0, "ee26");
    check_base_class_offset(lv, (bb26*), ABISELECT(16,12), "ee26");
    check_field_offset(lv, e, ABISELECT(12,8), "ee26.e");
    test_class_info(&lv, &cd_ee26);
    dp->~ee26();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee26(Test_ee26, "ee26", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ee26C1Ev();
extern void _ZN4ee26D1Ev();
Name_Map name_map_ee26[] = {
  NSPAIR(_ZN4ee26C1Ev),
  NSPAIR(_ZN4ee26D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa26;
extern VTBL_ENTRY _ZTI4aa26[];
extern  VTBL_ENTRY _ZTV4aa26[];
extern Class_Descriptor cd_bb26;
extern VTBL_ENTRY _ZTI4bb26[];
extern  VTBL_ENTRY _ZTV4bb26[];
static Base_Class bases_ee26[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa26,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_bb26,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ee26[];
extern void _ZN4ee263fooEv();
extern void ABISELECT(_ZTv0_n24_N4ee263fooEv,_ZTv0_n12_N4ee263fooEv)();
extern void ABISELECT(_ZThn16_N4ee263fooEv,_ZThn12_N4ee263fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee26[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee26[0]),
  (VTBL_ENTRY)&_ZN4ee263fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee26[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee263fooEv,_ZTv0_n12_N4ee263fooEv),
};
extern VTBL_ENTRY _ZTV4ee26[];
static  VTT_ENTRY vtt_ee26[] = {
  {&(_ZTV4ee26[3]),  3,8},
  {&(_ZTV4ee26[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ee26[];
extern  VTBL_ENTRY _ZTV4ee26[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee26[];
static VTBL_ENTRY alt_thunk_names63[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee263fooEv,_ZTv0_n12_N4ee263fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee263fooEv,_ZThn12_N4ee263fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee26 = {  "ee26", // class name
  bases_ee26, 2,
  &(vtc_ee26[0]), // expected_vtbl_contents
  &(vtt_ee26[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ee26),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee26),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ee26),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names63,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff26  : cc26 , virtual dd26 {
  int f;
   ff26(const ABISELECT(__tsi64,int) *const *); // _ZN4ff26C2Ev
  virtual void  foo(); // _ZN4ff263fooEv
  ~ff26(); // tgen
  ff26(); // tgen
};
//SIG(-1 ff26) C1{ BC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ff26 ::ff26(const ABISELECT(__tsi64,int) *const *){}
void  ff26 ::foo(){vfunc_called(this, "_ZN4ff263fooEv");}
ff26 ::~ff26(){ note_dtor("ff26", this);} // tgen
ff26 ::ff26(){ note_ctor("ff26", this);} // tgen

static void Test_ff26()
{
  extern Class_Descriptor cd_ff26;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff26, buf);
    ff26 *dp, &lv = *(dp=new (buf) ff26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff26)");
    check_base_class_offset(lv, (cc26*), 0, "ff26");
    check_base_class_offset(lv, (dd26*), ABISELECT(16,12), "ff26");
    check_field_offset(lv, f, ABISELECT(12,8), "ff26.f");
    test_class_info(&lv, &cd_ff26);
    dp->~ff26();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff26(Test_ff26, "ff26", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ff26C1Ev();
extern void _ZN4ff26D1Ev();
Name_Map name_map_ff26[] = {
  NSPAIR(_ZN4ff26C1Ev),
  NSPAIR(_ZN4ff26D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc26;
extern VTBL_ENTRY _ZTI4cc26[];
extern  VTBL_ENTRY _ZTV4cc26[];
extern Class_Descriptor cd_dd26;
extern VTBL_ENTRY _ZTI4dd26[];
extern  VTBL_ENTRY _ZTV4dd26[];
static Base_Class bases_ff26[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc26,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_dd26,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ff26[];
extern void _ZN4ff263fooEv();
extern void ABISELECT(_ZTv0_n24_N4ff263fooEv,_ZTv0_n12_N4ff263fooEv)();
extern void ABISELECT(_ZThn16_N4ff263fooEv,_ZThn12_N4ff263fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff26[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff26[0]),
  (VTBL_ENTRY)&_ZN4ff263fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff26[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff263fooEv,_ZTv0_n12_N4ff263fooEv),
};
extern VTBL_ENTRY _ZTV4ff26[];
static  VTT_ENTRY vtt_ff26[] = {
  {&(_ZTV4ff26[3]),  3,8},
  {&(_ZTV4ff26[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ff26[];
extern  VTBL_ENTRY _ZTV4ff26[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff26[];
static VTBL_ENTRY alt_thunk_names64[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff263fooEv,_ZTv0_n12_N4ff263fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff263fooEv,_ZThn12_N4ff263fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff26 = {  "ff26", // class name
  bases_ff26, 2,
  &(vtc_ff26[0]), // expected_vtbl_contents
  &(vtt_ff26[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ff26),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff26),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ff26),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names64,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg26  : virtual ee26 , ff26 {
  int g;
   gg26(const ABISELECT(__tsi64,int) *const *); // _ZN4gg26C2Ev
  virtual void  foo(); // _ZN4gg263fooEv
  ~gg26(); // tgen
  gg26(); // tgen
};
//SIG(1 gg26) C1{ VBC2{ BC3{ v1 Fi} VBC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 Fi} VBC7{ v1 Fi} v1 Fi} v1 Fi}


 gg26 ::gg26(const ABISELECT(__tsi64,int) *const *){}
void  gg26 ::foo(){vfunc_called(this, "_ZN4gg263fooEv");}
gg26 ::~gg26(){ note_dtor("gg26", this);} // tgen
gg26 ::gg26(){ note_ctor("gg26", this);} // tgen

static void Test_gg26()
{
  extern Class_Descriptor cd_gg26;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg26, buf);
    gg26 *dp, &lv = *(dp=new (buf) gg26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg26)");
    check_base_class_offset(lv, (aa26*)(ee26*), ABISELECT(24,16), "gg26");
    check_base_class_offset(lv, (bb26*)(ee26*), ABISELECT(40,28), "gg26");
    check_base_class_offset(lv, (ee26*), ABISELECT(24,16), "gg26");
    check_base_class_offset(lv, (cc26*)(ff26*), 0, "gg26");
    check_base_class_offset(lv, (dd26*)(ff26*), ABISELECT(56,36), "gg26");
    check_base_class_offset(lv, (ff26*), 0, "gg26");
    check_field_offset(lv, g, ABISELECT(16,12), "gg26.g");
    test_class_info(&lv, &cd_gg26);
    dp->~gg26();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg26(Test_gg26, "gg26", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN4gg26C1Ev();
extern void _ZN4gg26D1Ev();
Name_Map name_map_gg26[] = {
  NSPAIR(_ZN4gg26C1Ev),
  NSPAIR(_ZN4gg26D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa26;
extern VTBL_ENTRY _ZTI4aa26[];
extern  VTBL_ENTRY _ZTV4aa26[];
extern Class_Descriptor cd_bb26;
extern VTBL_ENTRY _ZTI4bb26[];
extern  VTBL_ENTRY _ZTV4bb26[];
extern Class_Descriptor cd_ee26;
extern VTBL_ENTRY _ZTI4ee26[];
extern  VTBL_ENTRY _ZTV4ee26[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee26[];
extern Class_Descriptor cd_cc26;
extern VTBL_ENTRY _ZTI4cc26[];
extern  VTBL_ENTRY _ZTV4cc26[];
extern Class_Descriptor cd_dd26;
extern VTBL_ENTRY _ZTI4dd26[];
extern  VTBL_ENTRY _ZTV4dd26[];
extern Class_Descriptor cd_ff26;
extern VTBL_ENTRY _ZTI4ff26[];
extern  VTBL_ENTRY _ZTV4ff26[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff26[];
static Base_Class bases_gg26[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa26,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_bb26,    ABISELECT(40,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_ee26,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_cc26,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_dd26,    ABISELECT(56,36), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_ff26,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4gg26[];
extern void _ZN4gg263fooEv();
extern void ABISELECT(_ZTv0_n32_N4gg263fooEv,_ZTv0_n16_N4gg263fooEv)();
extern void ABISELECT(_ZThn24_N4gg263fooEv,_ZThn16_N4gg263fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg263fooEv,_ZTv0_n12_N4gg263fooEv)();
extern void ABISELECT(_ZThn40_N4gg263fooEv,_ZThn28_N4gg263fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg263fooEv,_ZTv0_n12_N4gg263fooEv)();
extern void ABISELECT(_ZThn56_N4gg263fooEv,_ZThn36_N4gg263fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg26[] = {
  ABISELECT(40,28),
  ABISELECT(24,16),
  ABISELECT(56,36),
  0,
  (VTBL_ENTRY)&(_ZTI4gg26[0]),
  (VTBL_ENTRY)&_ZN4gg263fooEv,
  ABISELECT(-24,-16),
  ABISELECT(16,12),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI4gg26[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N4gg263fooEv,_ZTv0_n16_N4gg263fooEv),
  ABISELECT(-40,-28),
  ABISELECT(-40,-28),
  (VTBL_ENTRY)&(_ZTI4gg26[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg263fooEv,_ZTv0_n12_N4gg263fooEv),
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI4gg26[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg263fooEv,_ZTv0_n12_N4gg263fooEv),
};
extern VTBL_ENTRY _ZTV4gg26[];
extern void _ZN4ff263fooEv();
static  VTBL_ENTRY _tg__ZTV4ff26__4gg26[] = {
  ABISELECT(56,36),
  0,
  (VTBL_ENTRY)&(_ZTI4ff26[0]),
  (VTBL_ENTRY)&_ZN4ff263fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ff263fooEv,_ZTv0_n12_N4ff263fooEv)();
extern void ABISELECT(_ZThn56_N4ff263fooEv,_ZThn36_N4ff263fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4dd26__4ff26__4gg26[] = {
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI4ff26[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff263fooEv,_ZTv0_n12_N4ff263fooEv),
};
extern void _ZN4ee263fooEv();
static  VTBL_ENTRY _tg__ZTV4ee26__4gg26[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee26[0]),
  (VTBL_ENTRY)&_ZN4ee263fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ee263fooEv,_ZTv0_n12_N4ee263fooEv)();
extern void ABISELECT(_ZThn16_N4ee263fooEv,_ZThn12_N4ee263fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb26__4ee26__4gg26[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee26[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee263fooEv,_ZTv0_n12_N4ee263fooEv),
};
static  VTT_ENTRY vtt_gg26[] = {
  {&(_ZTV4gg26[5]),  5,19},
  {&(_tg__ZTV4ff26__4gg26[3]),  3,4},
  {&(_tg__ZTV4dd26__4ff26__4gg26[3]),  3,4},
  {&(_ZTV4gg26[10]),  10,19},
  {&(_ZTV4gg26[14]),  14,19},
  {&(_ZTV4gg26[18]),  18,19},
  {&(_tg__ZTV4ee26__4gg26[3]),  3,4},
  {&(_tg__ZTV4bb26__4ee26__4gg26[3]),  3,4},
};
extern VTBL_ENTRY _ZTI4gg26[];
extern  VTBL_ENTRY _ZTV4gg26[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg26[];
static VTBL_ENTRY alt_thunk_names65[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee263fooEv,_ZTv0_n12_N4ee263fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee263fooEv,_ZThn12_N4ee263fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff263fooEv,_ZTv0_n12_N4ff263fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4ff263fooEv,_ZThn36_N4ff263fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg263fooEv,_ZTv0_n12_N4gg263fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4gg263fooEv,_ZThn36_N4gg263fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N4gg263fooEv,_ZThn28_N4gg263fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N4gg263fooEv,_ZTv0_n16_N4gg263fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N4gg263fooEv,_ZThn16_N4gg263fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg26 = {  "gg26", // class name
  bases_gg26, 6,
  &(vtc_gg26[0]), // expected_vtbl_contents
  &(vtt_gg26[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI4gg26),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg26),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg26),8, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names65,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa27  {
  int a;
   aa27(); // _ZN4aa27C1Ev
  virtual void  foo(); // _ZN4aa273fooEv
  ~aa27(); // tgen
};
//SIG(-1 aa27) C1{ v1 Fi}


 aa27 ::aa27(){ note_ctor("aa27", this);}
void  aa27 ::foo(){vfunc_called(this, "_ZN4aa273fooEv");}
aa27 ::~aa27(){ note_dtor("aa27", this);} // tgen

static void Test_aa27()
{
  extern Class_Descriptor cd_aa27;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa27, buf);
    aa27 *dp, &lv = *(dp=new (buf) aa27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa27)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa27.a");
    test_class_info(&lv, &cd_aa27);
    dp->~aa27();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa27(Test_aa27, "aa27", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa27C1Ev();
extern void _ZN4aa27D1Ev();
Name_Map name_map_aa27[] = {
  NSPAIR(_ZN4aa27C1Ev),
  NSPAIR(_ZN4aa27D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa27[];
extern void _ZN4aa273fooEv();
static  VTBL_ENTRY vtc_aa27[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa27[0]),
  (VTBL_ENTRY)&_ZN4aa273fooEv,
};
extern VTBL_ENTRY _ZTI4aa27[];
extern  VTBL_ENTRY _ZTV4aa27[];
Class_Descriptor cd_aa27 = {  "aa27", // class name
  0,0,//no base classes
  &(vtc_aa27[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa27),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa27),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb27  {
  int b;
   bb27(); // _ZN4bb27C1Ev
  virtual void  foo(); // _ZN4bb273fooEv
  ~bb27(); // tgen
};
//SIG(-1 bb27) C1{ v1 Fi}


 bb27 ::bb27(){ note_ctor("bb27", this);}
void  bb27 ::foo(){vfunc_called(this, "_ZN4bb273fooEv");}
bb27 ::~bb27(){ note_dtor("bb27", this);} // tgen

static void Test_bb27()
{
  extern Class_Descriptor cd_bb27;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb27, buf);
    bb27 *dp, &lv = *(dp=new (buf) bb27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb27)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb27.b");
    test_class_info(&lv, &cd_bb27);
    dp->~bb27();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb27(Test_bb27, "bb27", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb27C1Ev();
extern void _ZN4bb27D1Ev();
Name_Map name_map_bb27[] = {
  NSPAIR(_ZN4bb27C1Ev),
  NSPAIR(_ZN4bb27D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb27[];
extern void _ZN4bb273fooEv();
static  VTBL_ENTRY vtc_bb27[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb27[0]),
  (VTBL_ENTRY)&_ZN4bb273fooEv,
};
extern VTBL_ENTRY _ZTI4bb27[];
extern  VTBL_ENTRY _ZTV4bb27[];
Class_Descriptor cd_bb27 = {  "bb27", // class name
  0,0,//no base classes
  &(vtc_bb27[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb27),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb27),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc27  {
  int c;
   cc27(); // _ZN4cc27C1Ev
  virtual void  foo(); // _ZN4cc273fooEv
  ~cc27(); // tgen
};
//SIG(-1 cc27) C1{ v1 Fi}


 cc27 ::cc27(){ note_ctor("cc27", this);}
void  cc27 ::foo(){vfunc_called(this, "_ZN4cc273fooEv");}
cc27 ::~cc27(){ note_dtor("cc27", this);} // tgen

static void Test_cc27()
{
  extern Class_Descriptor cd_cc27;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc27, buf);
    cc27 *dp, &lv = *(dp=new (buf) cc27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc27)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc27.c");
    test_class_info(&lv, &cd_cc27);
    dp->~cc27();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc27(Test_cc27, "cc27", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc27C1Ev();
extern void _ZN4cc27D1Ev();
Name_Map name_map_cc27[] = {
  NSPAIR(_ZN4cc27C1Ev),
  NSPAIR(_ZN4cc27D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc27[];
extern void _ZN4cc273fooEv();
static  VTBL_ENTRY vtc_cc27[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc27[0]),
  (VTBL_ENTRY)&_ZN4cc273fooEv,
};
extern VTBL_ENTRY _ZTI4cc27[];
extern  VTBL_ENTRY _ZTV4cc27[];
Class_Descriptor cd_cc27 = {  "cc27", // class name
  0,0,//no base classes
  &(vtc_cc27[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc27),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc27),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd27  {
  int d;
   dd27(); // _ZN4dd27C1Ev
  virtual void  foo(); // _ZN4dd273fooEv
  ~dd27(); // tgen
};
//SIG(-1 dd27) C1{ v1 Fi}


 dd27 ::dd27(){ note_ctor("dd27", this);}
void  dd27 ::foo(){vfunc_called(this, "_ZN4dd273fooEv");}
dd27 ::~dd27(){ note_dtor("dd27", this);} // tgen

static void Test_dd27()
{
  extern Class_Descriptor cd_dd27;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd27, buf);
    dd27 *dp, &lv = *(dp=new (buf) dd27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd27)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd27.d");
    test_class_info(&lv, &cd_dd27);
    dp->~dd27();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd27(Test_dd27, "dd27", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd27C1Ev();
extern void _ZN4dd27D1Ev();
Name_Map name_map_dd27[] = {
  NSPAIR(_ZN4dd27C1Ev),
  NSPAIR(_ZN4dd27D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd27[];
extern void _ZN4dd273fooEv();
static  VTBL_ENTRY vtc_dd27[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd27[0]),
  (VTBL_ENTRY)&_ZN4dd273fooEv,
};
extern VTBL_ENTRY _ZTI4dd27[];
extern  VTBL_ENTRY _ZTV4dd27[];
Class_Descriptor cd_dd27 = {  "dd27", // class name
  0,0,//no base classes
  &(vtc_dd27[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd27),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd27),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee27  : virtual aa27 , virtual bb27 {
  int e;
   ee27(const ABISELECT(__tsi64,int) *const *); // _ZN4ee27C2Ev
  virtual void  foo(); // _ZN4ee273fooEv
  ~ee27(); // tgen
  ee27(); // tgen
};
//SIG(-1 ee27) C1{ VBC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ee27 ::ee27(const ABISELECT(__tsi64,int) *const *){}
void  ee27 ::foo(){vfunc_called(this, "_ZN4ee273fooEv");}
ee27 ::~ee27(){ note_dtor("ee27", this);} // tgen
ee27 ::ee27(){ note_ctor("ee27", this);} // tgen

static void Test_ee27()
{
  extern Class_Descriptor cd_ee27;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_ee27, buf);
    ee27 *dp, &lv = *(dp=new (buf) ee27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(ee27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee27)");
    check_base_class_offset(lv, (aa27*), ABISELECT(16,8), "ee27");
    check_base_class_offset(lv, (bb27*), ABISELECT(32,16), "ee27");
    check_field_offset(lv, e, ABISELECT(8,4), "ee27.e");
    test_class_info(&lv, &cd_ee27);
    dp->~ee27();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee27(Test_ee27, "ee27", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN4ee27C1Ev();
extern void _ZN4ee27D1Ev();
Name_Map name_map_ee27[] = {
  NSPAIR(_ZN4ee27C1Ev),
  NSPAIR(_ZN4ee27D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa27;
extern VTBL_ENTRY _ZTI4aa27[];
extern  VTBL_ENTRY _ZTV4aa27[];
extern Class_Descriptor cd_bb27;
extern VTBL_ENTRY _ZTI4bb27[];
extern  VTBL_ENTRY _ZTV4bb27[];
static Base_Class bases_ee27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa27,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_bb27,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ee27[];
extern void _ZN4ee273fooEv();
extern void ABISELECT(_ZTv0_n24_N4ee273fooEv,_ZTv0_n12_N4ee273fooEv)();
extern void ABISELECT(_ZThn16_N4ee273fooEv,_ZThn8_N4ee273fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4ee273fooEv,_ZTv0_n12_N4ee273fooEv)();
extern void ABISELECT(_ZThn32_N4ee273fooEv,_ZThn16_N4ee273fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee27[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI4ee27[0]),
  (VTBL_ENTRY)&_ZN4ee273fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ee27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee273fooEv,_ZTv0_n12_N4ee273fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI4ee27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee273fooEv,_ZTv0_n12_N4ee273fooEv),
};
extern VTBL_ENTRY _ZTV4ee27[];
static  VTT_ENTRY vtt_ee27[] = {
  {&(_ZTV4ee27[4]),  4,13},
  {&(_ZTV4ee27[8]),  8,13},
  {&(_ZTV4ee27[12]),  12,13},
};
extern VTBL_ENTRY _ZTI4ee27[];
extern  VTBL_ENTRY _ZTV4ee27[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee27[];
static VTBL_ENTRY alt_thunk_names66[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee273fooEv,_ZTv0_n12_N4ee273fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ee273fooEv,_ZThn16_N4ee273fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee273fooEv,_ZThn8_N4ee273fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee27 = {  "ee27", // class name
  bases_ee27, 2,
  &(vtc_ee27[0]), // expected_vtbl_contents
  &(vtt_ee27[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI4ee27),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee27),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ee27),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names66,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff27  : cc27 , virtual dd27 {
  int f;
   ff27(const ABISELECT(__tsi64,int) *const *); // _ZN4ff27C2Ev
  virtual void  foo(); // _ZN4ff273fooEv
  ~ff27(); // tgen
  ff27(); // tgen
};
//SIG(-1 ff27) C1{ BC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ff27 ::ff27(const ABISELECT(__tsi64,int) *const *){}
void  ff27 ::foo(){vfunc_called(this, "_ZN4ff273fooEv");}
ff27 ::~ff27(){ note_dtor("ff27", this);} // tgen
ff27 ::ff27(){ note_ctor("ff27", this);} // tgen

static void Test_ff27()
{
  extern Class_Descriptor cd_ff27;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff27, buf);
    ff27 *dp, &lv = *(dp=new (buf) ff27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff27)");
    check_base_class_offset(lv, (cc27*), 0, "ff27");
    check_base_class_offset(lv, (dd27*), ABISELECT(16,12), "ff27");
    check_field_offset(lv, f, ABISELECT(12,8), "ff27.f");
    test_class_info(&lv, &cd_ff27);
    dp->~ff27();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff27(Test_ff27, "ff27", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ff27C1Ev();
extern void _ZN4ff27D1Ev();
Name_Map name_map_ff27[] = {
  NSPAIR(_ZN4ff27C1Ev),
  NSPAIR(_ZN4ff27D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc27;
extern VTBL_ENTRY _ZTI4cc27[];
extern  VTBL_ENTRY _ZTV4cc27[];
extern Class_Descriptor cd_dd27;
extern VTBL_ENTRY _ZTI4dd27[];
extern  VTBL_ENTRY _ZTV4dd27[];
static Base_Class bases_ff27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_dd27,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ff27[];
extern void _ZN4ff273fooEv();
extern void ABISELECT(_ZTv0_n24_N4ff273fooEv,_ZTv0_n12_N4ff273fooEv)();
extern void ABISELECT(_ZThn16_N4ff273fooEv,_ZThn12_N4ff273fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff27[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff27[0]),
  (VTBL_ENTRY)&_ZN4ff273fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff273fooEv,_ZTv0_n12_N4ff273fooEv),
};
extern VTBL_ENTRY _ZTV4ff27[];
static  VTT_ENTRY vtt_ff27[] = {
  {&(_ZTV4ff27[3]),  3,8},
  {&(_ZTV4ff27[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ff27[];
extern  VTBL_ENTRY _ZTV4ff27[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff27[];
static VTBL_ENTRY alt_thunk_names67[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff273fooEv,_ZTv0_n12_N4ff273fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff273fooEv,_ZThn12_N4ff273fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff27 = {  "ff27", // class name
  bases_ff27, 2,
  &(vtc_ff27[0]), // expected_vtbl_contents
  &(vtt_ff27[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ff27),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff27),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ff27),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names67,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg27  : virtual ee27 , ff27 {
  int g;
   gg27(const ABISELECT(__tsi64,int) *const *); // _ZN4gg27C2Ev
  virtual void  foo(); // _ZN4gg273fooEv
  ~gg27(); // tgen
  gg27(); // tgen
};
//SIG(1 gg27) C1{ VBC2{ VBC3{ v1 Fi} VBC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 Fi} VBC7{ v1 Fi} v1 Fi} v1 Fi}


 gg27 ::gg27(const ABISELECT(__tsi64,int) *const *){}
void  gg27 ::foo(){vfunc_called(this, "_ZN4gg273fooEv");}
gg27 ::~gg27(){ note_dtor("gg27", this);} // tgen
gg27 ::gg27(){ note_ctor("gg27", this);} // tgen

static void Test_gg27()
{
  extern Class_Descriptor cd_gg27;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(12,13)];
    init_test(&cd_gg27, buf);
    gg27 *dp, &lv = *(dp=new (buf) gg27());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(88,48), "sizeof(gg27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg27)");
    check_base_class_offset(lv, (aa27*)(ee27*), ABISELECT(40,24), "gg27");
    check_base_class_offset(lv, (bb27*)(ee27*), ABISELECT(56,32), "gg27");
    check_base_class_offset(lv, (ee27*), ABISELECT(24,16), "gg27");
    check_base_class_offset(lv, (cc27*)(ff27*), 0, "gg27");
    check_base_class_offset(lv, (dd27*)(ff27*), ABISELECT(72,40), "gg27");
    check_base_class_offset(lv, (ff27*), 0, "gg27");
    check_field_offset(lv, g, ABISELECT(16,12), "gg27.g");
    test_class_info(&lv, &cd_gg27);
    dp->~gg27();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg27(Test_gg27, "gg27", ABISELECT(88,48));

#else // __cplusplus

extern void _ZN4gg27C1Ev();
extern void _ZN4gg27D1Ev();
Name_Map name_map_gg27[] = {
  NSPAIR(_ZN4gg27C1Ev),
  NSPAIR(_ZN4gg27D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa27;
extern VTBL_ENTRY _ZTI4aa27[];
extern  VTBL_ENTRY _ZTV4aa27[];
extern Class_Descriptor cd_bb27;
extern VTBL_ENTRY _ZTI4bb27[];
extern  VTBL_ENTRY _ZTV4bb27[];
extern Class_Descriptor cd_ee27;
extern VTBL_ENTRY _ZTI4ee27[];
extern  VTBL_ENTRY _ZTV4ee27[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee27[];
extern Class_Descriptor cd_cc27;
extern VTBL_ENTRY _ZTI4cc27[];
extern  VTBL_ENTRY _ZTV4cc27[];
extern Class_Descriptor cd_dd27;
extern VTBL_ENTRY _ZTI4dd27[];
extern  VTBL_ENTRY _ZTV4dd27[];
extern Class_Descriptor cd_ff27;
extern VTBL_ENTRY _ZTI4ff27[];
extern  VTBL_ENTRY _ZTV4ff27[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff27[];
static Base_Class bases_gg27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa27,    ABISELECT(40,24), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_bb27,    ABISELECT(56,32), //bcp->offset
    17, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_ee27,    ABISELECT(24,16), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_cc27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_dd27,    ABISELECT(72,40), //bcp->offset
    21, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_ff27,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4gg27[];
extern void _ZN4gg273fooEv();
extern void ABISELECT(_ZTv0_n40_N4gg273fooEv,_ZTv0_n20_N4gg273fooEv)();
extern void ABISELECT(_ZThn24_N4gg273fooEv,_ZThn16_N4gg273fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg273fooEv,_ZTv0_n12_N4gg273fooEv)();
extern void ABISELECT(_ZThn40_N4gg273fooEv,_ZThn24_N4gg273fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg273fooEv,_ZTv0_n12_N4gg273fooEv)();
extern void ABISELECT(_ZThn56_N4gg273fooEv,_ZThn32_N4gg273fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg273fooEv,_ZTv0_n12_N4gg273fooEv)();
extern void ABISELECT(_ZThn72_N4gg273fooEv,_ZThn40_N4gg273fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg27[] = {
  ABISELECT(56,32),
  ABISELECT(40,24),
  ABISELECT(24,16),
  ABISELECT(72,40),
  0,
  (VTBL_ENTRY)&(_ZTI4gg27[0]),
  (VTBL_ENTRY)&_ZN4gg273fooEv,
  ABISELECT(-24,-16),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI4gg27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N4gg273fooEv,_ZTv0_n20_N4gg273fooEv),
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI4gg27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg273fooEv,_ZTv0_n12_N4gg273fooEv),
  ABISELECT(-56,-32),
  ABISELECT(-56,-32),
  (VTBL_ENTRY)&(_ZTI4gg27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg273fooEv,_ZTv0_n12_N4gg273fooEv),
  ABISELECT(-72,-40),
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI4gg27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg273fooEv,_ZTv0_n12_N4gg273fooEv),
};
extern VTBL_ENTRY _ZTV4gg27[];
extern void _ZN4ff273fooEv();
static  VTBL_ENTRY _tg__ZTV4ff27__4gg27[] = {
  ABISELECT(72,40),
  0,
  (VTBL_ENTRY)&(_ZTI4ff27[0]),
  (VTBL_ENTRY)&_ZN4ff273fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ff273fooEv,_ZTv0_n12_N4ff273fooEv)();
extern void ABISELECT(_ZThn72_N4ff273fooEv,_ZThn40_N4ff273fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4dd27__4ff27__4gg27[] = {
  ABISELECT(-72,-40),
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI4ff27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff273fooEv,_ZTv0_n12_N4ff273fooEv),
};
extern void _ZN4ee273fooEv();
static  VTBL_ENTRY _tg__ZTV4ee27__4gg27[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI4ee27[0]),
  (VTBL_ENTRY)&_ZN4ee273fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ee273fooEv,_ZTv0_n12_N4ee273fooEv)();
extern void ABISELECT(_ZThn16_N4ee273fooEv,_ZThn8_N4ee273fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4aa27__4ee27__4gg27[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ee27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee273fooEv,_ZTv0_n12_N4ee273fooEv),
};
extern void ABISELECT(_ZTv0_n24_N4ee273fooEv,_ZTv0_n12_N4ee273fooEv)();
extern void ABISELECT(_ZThn32_N4ee273fooEv,_ZThn16_N4ee273fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb27__4ee27__4gg27[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI4ee27[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee273fooEv,_ZTv0_n12_N4ee273fooEv),
};
static  VTT_ENTRY vtt_gg27[] = {
  {&(_ZTV4gg27[6]),  6,25},
  {&(_tg__ZTV4ff27__4gg27[3]),  3,4},
  {&(_tg__ZTV4dd27__4ff27__4gg27[3]),  3,4},
  {&(_ZTV4gg27[12]),  12,25},
  {&(_ZTV4gg27[16]),  16,25},
  {&(_ZTV4gg27[20]),  20,25},
  {&(_ZTV4gg27[24]),  24,25},
  {&(_tg__ZTV4ee27__4gg27[4]),  4,5},
  {&(_tg__ZTV4aa27__4ee27__4gg27[3]),  3,4},
  {&(_tg__ZTV4bb27__4ee27__4gg27[3]),  3,4},
};
extern VTBL_ENTRY _ZTI4gg27[];
extern  VTBL_ENTRY _ZTV4gg27[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg27[];
static VTBL_ENTRY alt_thunk_names68[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee273fooEv,_ZTv0_n12_N4ee273fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ee273fooEv,_ZThn16_N4ee273fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee273fooEv,_ZThn8_N4ee273fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff273fooEv,_ZTv0_n12_N4ff273fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N4ff273fooEv,_ZThn40_N4ff273fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg273fooEv,_ZTv0_n12_N4gg273fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72_N4gg273fooEv,_ZThn40_N4gg273fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4gg273fooEv,_ZThn32_N4gg273fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N4gg273fooEv,_ZThn24_N4gg273fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N4gg273fooEv,_ZTv0_n20_N4gg273fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N4gg273fooEv,_ZThn16_N4gg273fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg27 = {  "gg27", // class name
  bases_gg27, 6,
  &(vtc_gg27[0]), // expected_vtbl_contents
  &(vtt_gg27[0]), // expected_vtt_contents
  ABISELECT(88,48), // object size
  NSPAIRA(_ZTI4gg27),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg27),25, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg27),10, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names68,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa28  {
  int a;
   aa28(); // _ZN4aa28C1Ev
  virtual void  foo(); // _ZN4aa283fooEv
  ~aa28(); // tgen
};
//SIG(-1 aa28) C1{ v1 Fi}


 aa28 ::aa28(){ note_ctor("aa28", this);}
void  aa28 ::foo(){vfunc_called(this, "_ZN4aa283fooEv");}
aa28 ::~aa28(){ note_dtor("aa28", this);} // tgen

static void Test_aa28()
{
  extern Class_Descriptor cd_aa28;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa28, buf);
    aa28 *dp, &lv = *(dp=new (buf) aa28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa28)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa28.a");
    test_class_info(&lv, &cd_aa28);
    dp->~aa28();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa28(Test_aa28, "aa28", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa28C1Ev();
extern void _ZN4aa28D1Ev();
Name_Map name_map_aa28[] = {
  NSPAIR(_ZN4aa28C1Ev),
  NSPAIR(_ZN4aa28D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa28[];
extern void _ZN4aa283fooEv();
static  VTBL_ENTRY vtc_aa28[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa28[0]),
  (VTBL_ENTRY)&_ZN4aa283fooEv,
};
extern VTBL_ENTRY _ZTI4aa28[];
extern  VTBL_ENTRY _ZTV4aa28[];
Class_Descriptor cd_aa28 = {  "aa28", // class name
  0,0,//no base classes
  &(vtc_aa28[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa28),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa28),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb28  {
  int b;
   bb28(); // _ZN4bb28C1Ev
  virtual void  foo(); // _ZN4bb283fooEv
  ~bb28(); // tgen
};
//SIG(-1 bb28) C1{ v1 Fi}


 bb28 ::bb28(){ note_ctor("bb28", this);}
void  bb28 ::foo(){vfunc_called(this, "_ZN4bb283fooEv");}
bb28 ::~bb28(){ note_dtor("bb28", this);} // tgen

static void Test_bb28()
{
  extern Class_Descriptor cd_bb28;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb28, buf);
    bb28 *dp, &lv = *(dp=new (buf) bb28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb28)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb28.b");
    test_class_info(&lv, &cd_bb28);
    dp->~bb28();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb28(Test_bb28, "bb28", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb28C1Ev();
extern void _ZN4bb28D1Ev();
Name_Map name_map_bb28[] = {
  NSPAIR(_ZN4bb28C1Ev),
  NSPAIR(_ZN4bb28D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb28[];
extern void _ZN4bb283fooEv();
static  VTBL_ENTRY vtc_bb28[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb28[0]),
  (VTBL_ENTRY)&_ZN4bb283fooEv,
};
extern VTBL_ENTRY _ZTI4bb28[];
extern  VTBL_ENTRY _ZTV4bb28[];
Class_Descriptor cd_bb28 = {  "bb28", // class name
  0,0,//no base classes
  &(vtc_bb28[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb28),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb28),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc28  {
  int c;
   cc28(); // _ZN4cc28C1Ev
  virtual void  foo(); // _ZN4cc283fooEv
  ~cc28(); // tgen
};
//SIG(-1 cc28) C1{ v1 Fi}


 cc28 ::cc28(){ note_ctor("cc28", this);}
void  cc28 ::foo(){vfunc_called(this, "_ZN4cc283fooEv");}
cc28 ::~cc28(){ note_dtor("cc28", this);} // tgen

static void Test_cc28()
{
  extern Class_Descriptor cd_cc28;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc28, buf);
    cc28 *dp, &lv = *(dp=new (buf) cc28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc28)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc28.c");
    test_class_info(&lv, &cd_cc28);
    dp->~cc28();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc28(Test_cc28, "cc28", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc28C1Ev();
extern void _ZN4cc28D1Ev();
Name_Map name_map_cc28[] = {
  NSPAIR(_ZN4cc28C1Ev),
  NSPAIR(_ZN4cc28D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc28[];
extern void _ZN4cc283fooEv();
static  VTBL_ENTRY vtc_cc28[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc28[0]),
  (VTBL_ENTRY)&_ZN4cc283fooEv,
};
extern VTBL_ENTRY _ZTI4cc28[];
extern  VTBL_ENTRY _ZTV4cc28[];
Class_Descriptor cd_cc28 = {  "cc28", // class name
  0,0,//no base classes
  &(vtc_cc28[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc28),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc28),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd28  {
  int d;
   dd28(); // _ZN4dd28C1Ev
  virtual void  foo(); // _ZN4dd283fooEv
  ~dd28(); // tgen
};
//SIG(-1 dd28) C1{ v1 Fi}


 dd28 ::dd28(){ note_ctor("dd28", this);}
void  dd28 ::foo(){vfunc_called(this, "_ZN4dd283fooEv");}
dd28 ::~dd28(){ note_dtor("dd28", this);} // tgen

static void Test_dd28()
{
  extern Class_Descriptor cd_dd28;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd28, buf);
    dd28 *dp, &lv = *(dp=new (buf) dd28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd28)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd28.d");
    test_class_info(&lv, &cd_dd28);
    dp->~dd28();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd28(Test_dd28, "dd28", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd28C1Ev();
extern void _ZN4dd28D1Ev();
Name_Map name_map_dd28[] = {
  NSPAIR(_ZN4dd28C1Ev),
  NSPAIR(_ZN4dd28D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd28[];
extern void _ZN4dd283fooEv();
static  VTBL_ENTRY vtc_dd28[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd28[0]),
  (VTBL_ENTRY)&_ZN4dd283fooEv,
};
extern VTBL_ENTRY _ZTI4dd28[];
extern  VTBL_ENTRY _ZTV4dd28[];
Class_Descriptor cd_dd28 = {  "dd28", // class name
  0,0,//no base classes
  &(vtc_dd28[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd28),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd28),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee28  : aa28 , bb28 {
  int e;
   ee28(); // _ZN4ee28C1Ev
  virtual void  foo(); // _ZN4ee283fooEv
  ~ee28(); // tgen
};
//SIG(-1 ee28) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ee28 ::ee28(){ note_ctor("ee28", this);}
void  ee28 ::foo(){vfunc_called(this, "_ZN4ee283fooEv");}
ee28 ::~ee28(){ note_dtor("ee28", this);} // tgen

static void Test_ee28()
{
  extern Class_Descriptor cd_ee28;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee28, buf);
    ee28 *dp, &lv = *(dp=new (buf) ee28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee28)");
    check_base_class_offset(lv, (aa28*), 0, "ee28");
    check_base_class_offset(lv, (bb28*), ABISELECT(16,8), "ee28");
    check_field_offset(lv, e, ABISELECT(28,16), "ee28.e");
    test_class_info(&lv, &cd_ee28);
    dp->~ee28();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee28(Test_ee28, "ee28", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ee28C1Ev();
extern void _ZN4ee28D1Ev();
Name_Map name_map_ee28[] = {
  NSPAIR(_ZN4ee28C1Ev),
  NSPAIR(_ZN4ee28D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa28;
extern VTBL_ENTRY _ZTI4aa28[];
extern  VTBL_ENTRY _ZTV4aa28[];
extern Class_Descriptor cd_bb28;
extern VTBL_ENTRY _ZTI4bb28[];
extern  VTBL_ENTRY _ZTV4bb28[];
static Base_Class bases_ee28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa28,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_bb28,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ee28[];
extern void _ZN4ee283fooEv();
extern void ABISELECT(_ZThn16_N4ee283fooEv,_ZThn8_N4ee283fooEv)();
static  VTBL_ENTRY vtc_ee28[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4ee28[0]),
  (VTBL_ENTRY)&_ZN4ee283fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ee28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4ee283fooEv,_ZThn8_N4ee283fooEv),
};
extern VTBL_ENTRY _ZTI4ee28[];
extern  VTBL_ENTRY _ZTV4ee28[];
Class_Descriptor cd_ee28 = {  "ee28", // class name
  bases_ee28, 2,
  &(vtc_ee28[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ee28),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee28),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff28  : virtual cc28 , virtual dd28 {
  int f;
   ff28(const ABISELECT(__tsi64,int) *const *); // _ZN4ff28C2Ev
  virtual void  foo(); // _ZN4ff283fooEv
  ~ff28(); // tgen
  ff28(); // tgen
};
//SIG(-1 ff28) C1{ VBC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ff28 ::ff28(const ABISELECT(__tsi64,int) *const *){}
void  ff28 ::foo(){vfunc_called(this, "_ZN4ff283fooEv");}
ff28 ::~ff28(){ note_dtor("ff28", this);} // tgen
ff28 ::ff28(){ note_ctor("ff28", this);} // tgen

static void Test_ff28()
{
  extern Class_Descriptor cd_ff28;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_ff28, buf);
    ff28 *dp, &lv = *(dp=new (buf) ff28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(ff28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff28)");
    check_base_class_offset(lv, (cc28*), ABISELECT(16,8), "ff28");
    check_base_class_offset(lv, (dd28*), ABISELECT(32,16), "ff28");
    check_field_offset(lv, f, ABISELECT(8,4), "ff28.f");
    test_class_info(&lv, &cd_ff28);
    dp->~ff28();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff28(Test_ff28, "ff28", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN4ff28C1Ev();
extern void _ZN4ff28D1Ev();
Name_Map name_map_ff28[] = {
  NSPAIR(_ZN4ff28C1Ev),
  NSPAIR(_ZN4ff28D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc28;
extern VTBL_ENTRY _ZTI4cc28[];
extern  VTBL_ENTRY _ZTV4cc28[];
extern Class_Descriptor cd_dd28;
extern VTBL_ENTRY _ZTI4dd28[];
extern  VTBL_ENTRY _ZTV4dd28[];
static Base_Class bases_ff28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc28,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_dd28,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ff28[];
extern void _ZN4ff283fooEv();
extern void ABISELECT(_ZTv0_n24_N4ff283fooEv,_ZTv0_n12_N4ff283fooEv)();
extern void ABISELECT(_ZThn16_N4ff283fooEv,_ZThn8_N4ff283fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4ff283fooEv,_ZTv0_n12_N4ff283fooEv)();
extern void ABISELECT(_ZThn32_N4ff283fooEv,_ZThn16_N4ff283fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff28[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI4ff28[0]),
  (VTBL_ENTRY)&_ZN4ff283fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ff28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff283fooEv,_ZTv0_n12_N4ff283fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI4ff28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff283fooEv,_ZTv0_n12_N4ff283fooEv),
};
extern VTBL_ENTRY _ZTV4ff28[];
static  VTT_ENTRY vtt_ff28[] = {
  {&(_ZTV4ff28[4]),  4,13},
  {&(_ZTV4ff28[8]),  8,13},
  {&(_ZTV4ff28[12]),  12,13},
};
extern VTBL_ENTRY _ZTI4ff28[];
extern  VTBL_ENTRY _ZTV4ff28[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff28[];
static VTBL_ENTRY alt_thunk_names69[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff283fooEv,_ZTv0_n12_N4ff283fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ff283fooEv,_ZThn16_N4ff283fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff283fooEv,_ZThn8_N4ff283fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff28 = {  "ff28", // class name
  bases_ff28, 2,
  &(vtc_ff28[0]), // expected_vtbl_contents
  &(vtt_ff28[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI4ff28),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff28),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ff28),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names69,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg28  : virtual ee28 , ff28 {
  int g;
   gg28(const ABISELECT(__tsi64,int) *const *); // _ZN4gg28C2Ev
  virtual void  foo(); // _ZN4gg283fooEv
  ~gg28(); // tgen
  gg28(); // tgen
};
//SIG(1 gg28) C1{ VBC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ VBC6{ v1 Fi} VBC7{ v1 Fi} v1 Fi} v1 Fi}


 gg28 ::gg28(const ABISELECT(__tsi64,int) *const *){}
void  gg28 ::foo(){vfunc_called(this, "_ZN4gg283fooEv");}
gg28 ::~gg28(){ note_dtor("gg28", this);} // tgen
gg28 ::gg28(){ note_ctor("gg28", this);} // tgen

static void Test_gg28()
{
  extern Class_Descriptor cd_gg28;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,13)];
    init_test(&cd_gg28, buf);
    gg28 *dp, &lv = *(dp=new (buf) gg28());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,48), "sizeof(gg28)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg28)");
    check_base_class_offset(lv, (aa28*)(ee28*), ABISELECT(16,12), "gg28");
    check_base_class_offset(lv, (bb28*)(ee28*), ABISELECT(32,20), "gg28");
    check_base_class_offset(lv, (ee28*), ABISELECT(16,12), "gg28");
    check_base_class_offset(lv, (cc28*)(ff28*), ABISELECT(48,32), "gg28");
    check_base_class_offset(lv, (dd28*)(ff28*), ABISELECT(64,40), "gg28");
    check_base_class_offset(lv, (ff28*), 0, "gg28");
    check_field_offset(lv, g, ABISELECT(12,8), "gg28.g");
    test_class_info(&lv, &cd_gg28);
    dp->~gg28();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg28(Test_gg28, "gg28", ABISELECT(80,48));

#else // __cplusplus

extern void _ZN4gg28C1Ev();
extern void _ZN4gg28D1Ev();
Name_Map name_map_gg28[] = {
  NSPAIR(_ZN4gg28C1Ev),
  NSPAIR(_ZN4gg28D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa28;
extern VTBL_ENTRY _ZTI4aa28[];
extern  VTBL_ENTRY _ZTV4aa28[];
extern Class_Descriptor cd_bb28;
extern VTBL_ENTRY _ZTI4bb28[];
extern  VTBL_ENTRY _ZTV4bb28[];
extern Class_Descriptor cd_ee28;
extern VTBL_ENTRY _ZTI4ee28[];
extern  VTBL_ENTRY _ZTV4ee28[];
extern Class_Descriptor cd_cc28;
extern VTBL_ENTRY _ZTI4cc28[];
extern  VTBL_ENTRY _ZTV4cc28[];
extern Class_Descriptor cd_dd28;
extern VTBL_ENTRY _ZTI4dd28[];
extern  VTBL_ENTRY _ZTV4dd28[];
extern Class_Descriptor cd_ff28;
extern VTBL_ENTRY _ZTI4ff28[];
extern  VTBL_ENTRY _ZTV4ff28[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff28[];
static Base_Class bases_gg28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa28,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_bb28,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_ee28,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_cc28,    ABISELECT(48,32), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_dd28,    ABISELECT(64,40), //bcp->offset
    17, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_ff28,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4gg28[];
extern void _ZN4gg283fooEv();
extern void ABISELECT(_ZTv0_n24_N4gg283fooEv,_ZTv0_n12_N4gg283fooEv)();
extern void ABISELECT(_ZThn16_N4gg283fooEv,_ZThn12_N4gg283fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n24_N4gg283fooEv,_ZTvn8_n12_N4gg283fooEv)();
extern void ABISELECT(_ZTv0_n24_N4gg283fooEv,_ZTv0_n12_N4gg283fooEv)();
extern void ABISELECT(_ZThn48_N4gg283fooEv,_ZThn32_N4gg283fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg283fooEv,_ZTv0_n12_N4gg283fooEv)();
extern void ABISELECT(_ZThn64_N4gg283fooEv,_ZThn40_N4gg283fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg28[] = {
  ABISELECT(16,12),
  ABISELECT(64,40),
  ABISELECT(48,32),
  0,
  (VTBL_ENTRY)&(_ZTI4gg28[0]),
  (VTBL_ENTRY)&_ZN4gg283fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4gg28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg283fooEv,_ZTv0_n12_N4gg283fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI4gg28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N4gg283fooEv,_ZTvn8_n12_N4gg283fooEv),
  ABISELECT(-48,-32),
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI4gg28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg283fooEv,_ZTv0_n12_N4gg283fooEv),
  ABISELECT(-64,-40),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI4gg28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg283fooEv,_ZTv0_n12_N4gg283fooEv),
};
extern VTBL_ENTRY _ZTV4gg28[];
extern void _ZN4ff283fooEv();
static  VTBL_ENTRY _tg__ZTV4ff28__4gg28[] = {
  ABISELECT(64,40),
  ABISELECT(48,32),
  0,
  (VTBL_ENTRY)&(_ZTI4ff28[0]),
  (VTBL_ENTRY)&_ZN4ff283fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ff283fooEv,_ZTv0_n12_N4ff283fooEv)();
extern void ABISELECT(_ZThn48_N4ff283fooEv,_ZThn32_N4ff283fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4cc28__4ff28__4gg28[] = {
  ABISELECT(-48,-32),
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI4ff28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff283fooEv,_ZTv0_n12_N4ff283fooEv),
};
extern void ABISELECT(_ZTv0_n24_N4ff283fooEv,_ZTv0_n12_N4ff283fooEv)();
extern void ABISELECT(_ZThn64_N4ff283fooEv,_ZThn40_N4ff283fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4dd28__4ff28__4gg28[] = {
  ABISELECT(-64,-40),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI4ff28[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff283fooEv,_ZTv0_n12_N4ff283fooEv),
};
static  VTT_ENTRY vtt_gg28[] = {
  {&(_ZTV4gg28[5]),  5,21},
  {&(_tg__ZTV4ff28__4gg28[4]),  4,5},
  {&(_tg__ZTV4cc28__4ff28__4gg28[3]),  3,4},
  {&(_tg__ZTV4dd28__4ff28__4gg28[3]),  3,4},
  {&(_ZTV4gg28[9]),  9,21},
  {&(_ZTV4gg28[12]),  12,21},
  {&(_ZTV4gg28[16]),  16,21},
  {&(_ZTV4gg28[20]),  20,21},
};
extern VTBL_ENTRY _ZTI4gg28[];
extern  VTBL_ENTRY _ZTV4gg28[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg28[];
static VTBL_ENTRY alt_thunk_names70[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff283fooEv,_ZTv0_n12_N4ff283fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N4ff283fooEv,_ZThn40_N4ff283fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N4ff283fooEv,_ZThn32_N4ff283fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg283fooEv,_ZTv0_n12_N4gg283fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N4gg283fooEv,_ZThn40_N4gg283fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N4gg283fooEv,_ZThn32_N4gg283fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4gg283fooEv,_ZThn12_N4gg283fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg28 = {  "gg28", // class name
  bases_gg28, 6,
  &(vtc_gg28[0]), // expected_vtbl_contents
  &(vtt_gg28[0]), // expected_vtt_contents
  ABISELECT(80,48), // object size
  NSPAIRA(_ZTI4gg28),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg28),21, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg28),8, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names70,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa29  {
  int a;
   aa29(); // _ZN4aa29C1Ev
  virtual void  foo(); // _ZN4aa293fooEv
  ~aa29(); // tgen
};
//SIG(-1 aa29) C1{ v1 Fi}


 aa29 ::aa29(){ note_ctor("aa29", this);}
void  aa29 ::foo(){vfunc_called(this, "_ZN4aa293fooEv");}
aa29 ::~aa29(){ note_dtor("aa29", this);} // tgen

static void Test_aa29()
{
  extern Class_Descriptor cd_aa29;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa29, buf);
    aa29 *dp, &lv = *(dp=new (buf) aa29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa29)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa29.a");
    test_class_info(&lv, &cd_aa29);
    dp->~aa29();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa29(Test_aa29, "aa29", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa29C1Ev();
extern void _ZN4aa29D1Ev();
Name_Map name_map_aa29[] = {
  NSPAIR(_ZN4aa29C1Ev),
  NSPAIR(_ZN4aa29D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa29[];
extern void _ZN4aa293fooEv();
static  VTBL_ENTRY vtc_aa29[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa29[0]),
  (VTBL_ENTRY)&_ZN4aa293fooEv,
};
extern VTBL_ENTRY _ZTI4aa29[];
extern  VTBL_ENTRY _ZTV4aa29[];
Class_Descriptor cd_aa29 = {  "aa29", // class name
  0,0,//no base classes
  &(vtc_aa29[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa29),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa29),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb29  {
  int b;
   bb29(); // _ZN4bb29C1Ev
  virtual void  foo(); // _ZN4bb293fooEv
  ~bb29(); // tgen
};
//SIG(-1 bb29) C1{ v1 Fi}


 bb29 ::bb29(){ note_ctor("bb29", this);}
void  bb29 ::foo(){vfunc_called(this, "_ZN4bb293fooEv");}
bb29 ::~bb29(){ note_dtor("bb29", this);} // tgen

static void Test_bb29()
{
  extern Class_Descriptor cd_bb29;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb29, buf);
    bb29 *dp, &lv = *(dp=new (buf) bb29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb29)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb29.b");
    test_class_info(&lv, &cd_bb29);
    dp->~bb29();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb29(Test_bb29, "bb29", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb29C1Ev();
extern void _ZN4bb29D1Ev();
Name_Map name_map_bb29[] = {
  NSPAIR(_ZN4bb29C1Ev),
  NSPAIR(_ZN4bb29D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb29[];
extern void _ZN4bb293fooEv();
static  VTBL_ENTRY vtc_bb29[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb29[0]),
  (VTBL_ENTRY)&_ZN4bb293fooEv,
};
extern VTBL_ENTRY _ZTI4bb29[];
extern  VTBL_ENTRY _ZTV4bb29[];
Class_Descriptor cd_bb29 = {  "bb29", // class name
  0,0,//no base classes
  &(vtc_bb29[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb29),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb29),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc29  {
  int c;
   cc29(); // _ZN4cc29C1Ev
  virtual void  foo(); // _ZN4cc293fooEv
  ~cc29(); // tgen
};
//SIG(-1 cc29) C1{ v1 Fi}


 cc29 ::cc29(){ note_ctor("cc29", this);}
void  cc29 ::foo(){vfunc_called(this, "_ZN4cc293fooEv");}
cc29 ::~cc29(){ note_dtor("cc29", this);} // tgen

static void Test_cc29()
{
  extern Class_Descriptor cd_cc29;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc29, buf);
    cc29 *dp, &lv = *(dp=new (buf) cc29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc29)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc29.c");
    test_class_info(&lv, &cd_cc29);
    dp->~cc29();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc29(Test_cc29, "cc29", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc29C1Ev();
extern void _ZN4cc29D1Ev();
Name_Map name_map_cc29[] = {
  NSPAIR(_ZN4cc29C1Ev),
  NSPAIR(_ZN4cc29D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc29[];
extern void _ZN4cc293fooEv();
static  VTBL_ENTRY vtc_cc29[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc29[0]),
  (VTBL_ENTRY)&_ZN4cc293fooEv,
};
extern VTBL_ENTRY _ZTI4cc29[];
extern  VTBL_ENTRY _ZTV4cc29[];
Class_Descriptor cd_cc29 = {  "cc29", // class name
  0,0,//no base classes
  &(vtc_cc29[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc29),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc29),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd29  {
  int d;
   dd29(); // _ZN4dd29C1Ev
  virtual void  foo(); // _ZN4dd293fooEv
  ~dd29(); // tgen
};
//SIG(-1 dd29) C1{ v1 Fi}


 dd29 ::dd29(){ note_ctor("dd29", this);}
void  dd29 ::foo(){vfunc_called(this, "_ZN4dd293fooEv");}
dd29 ::~dd29(){ note_dtor("dd29", this);} // tgen

static void Test_dd29()
{
  extern Class_Descriptor cd_dd29;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd29, buf);
    dd29 *dp, &lv = *(dp=new (buf) dd29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd29)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd29.d");
    test_class_info(&lv, &cd_dd29);
    dp->~dd29();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd29(Test_dd29, "dd29", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd29C1Ev();
extern void _ZN4dd29D1Ev();
Name_Map name_map_dd29[] = {
  NSPAIR(_ZN4dd29C1Ev),
  NSPAIR(_ZN4dd29D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd29[];
extern void _ZN4dd293fooEv();
static  VTBL_ENTRY vtc_dd29[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd29[0]),
  (VTBL_ENTRY)&_ZN4dd293fooEv,
};
extern VTBL_ENTRY _ZTI4dd29[];
extern  VTBL_ENTRY _ZTV4dd29[];
Class_Descriptor cd_dd29 = {  "dd29", // class name
  0,0,//no base classes
  &(vtc_dd29[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd29),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd29),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee29  : virtual aa29 , bb29 {
  int e;
   ee29(const ABISELECT(__tsi64,int) *const *); // _ZN4ee29C2Ev
  virtual void  foo(); // _ZN4ee293fooEv
  ~ee29(); // tgen
  ee29(); // tgen
};
//SIG(-1 ee29) C1{ VBC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ee29 ::ee29(const ABISELECT(__tsi64,int) *const *){}
void  ee29 ::foo(){vfunc_called(this, "_ZN4ee293fooEv");}
ee29 ::~ee29(){ note_dtor("ee29", this);} // tgen
ee29 ::ee29(){ note_ctor("ee29", this);} // tgen

static void Test_ee29()
{
  extern Class_Descriptor cd_ee29;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee29, buf);
    ee29 *dp, &lv = *(dp=new (buf) ee29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee29)");
    check_base_class_offset(lv, (aa29*), ABISELECT(16,12), "ee29");
    check_base_class_offset(lv, (bb29*), 0, "ee29");
    check_field_offset(lv, e, ABISELECT(12,8), "ee29.e");
    test_class_info(&lv, &cd_ee29);
    dp->~ee29();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee29(Test_ee29, "ee29", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ee29C1Ev();
extern void _ZN4ee29D1Ev();
Name_Map name_map_ee29[] = {
  NSPAIR(_ZN4ee29C1Ev),
  NSPAIR(_ZN4ee29D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa29;
extern VTBL_ENTRY _ZTI4aa29[];
extern  VTBL_ENTRY _ZTV4aa29[];
extern Class_Descriptor cd_bb29;
extern VTBL_ENTRY _ZTI4bb29[];
extern  VTBL_ENTRY _ZTV4bb29[];
static Base_Class bases_ee29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa29,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_bb29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ee29[];
extern void _ZN4ee293fooEv();
extern void ABISELECT(_ZTv0_n24_N4ee293fooEv,_ZTv0_n12_N4ee293fooEv)();
extern void ABISELECT(_ZThn16_N4ee293fooEv,_ZThn12_N4ee293fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee29[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee29[0]),
  (VTBL_ENTRY)&_ZN4ee293fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee293fooEv,_ZTv0_n12_N4ee293fooEv),
};
extern VTBL_ENTRY _ZTV4ee29[];
static  VTT_ENTRY vtt_ee29[] = {
  {&(_ZTV4ee29[3]),  3,8},
  {&(_ZTV4ee29[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ee29[];
extern  VTBL_ENTRY _ZTV4ee29[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee29[];
static VTBL_ENTRY alt_thunk_names71[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee293fooEv,_ZTv0_n12_N4ee293fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee293fooEv,_ZThn12_N4ee293fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee29 = {  "ee29", // class name
  bases_ee29, 2,
  &(vtc_ee29[0]), // expected_vtbl_contents
  &(vtt_ee29[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ee29),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee29),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ee29),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names71,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff29  : virtual cc29 , virtual dd29 {
  int f;
   ff29(const ABISELECT(__tsi64,int) *const *); // _ZN4ff29C2Ev
  virtual void  foo(); // _ZN4ff293fooEv
  ~ff29(); // tgen
  ff29(); // tgen
};
//SIG(-1 ff29) C1{ VBC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ff29 ::ff29(const ABISELECT(__tsi64,int) *const *){}
void  ff29 ::foo(){vfunc_called(this, "_ZN4ff293fooEv");}
ff29 ::~ff29(){ note_dtor("ff29", this);} // tgen
ff29 ::ff29(){ note_ctor("ff29", this);} // tgen

static void Test_ff29()
{
  extern Class_Descriptor cd_ff29;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_ff29, buf);
    ff29 *dp, &lv = *(dp=new (buf) ff29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(ff29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff29)");
    check_base_class_offset(lv, (cc29*), ABISELECT(16,8), "ff29");
    check_base_class_offset(lv, (dd29*), ABISELECT(32,16), "ff29");
    check_field_offset(lv, f, ABISELECT(8,4), "ff29.f");
    test_class_info(&lv, &cd_ff29);
    dp->~ff29();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff29(Test_ff29, "ff29", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN4ff29C1Ev();
extern void _ZN4ff29D1Ev();
Name_Map name_map_ff29[] = {
  NSPAIR(_ZN4ff29C1Ev),
  NSPAIR(_ZN4ff29D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc29;
extern VTBL_ENTRY _ZTI4cc29[];
extern  VTBL_ENTRY _ZTV4cc29[];
extern Class_Descriptor cd_dd29;
extern VTBL_ENTRY _ZTI4dd29[];
extern  VTBL_ENTRY _ZTV4dd29[];
static Base_Class bases_ff29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc29,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_dd29,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ff29[];
extern void _ZN4ff293fooEv();
extern void ABISELECT(_ZTv0_n24_N4ff293fooEv,_ZTv0_n12_N4ff293fooEv)();
extern void ABISELECT(_ZThn16_N4ff293fooEv,_ZThn8_N4ff293fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4ff293fooEv,_ZTv0_n12_N4ff293fooEv)();
extern void ABISELECT(_ZThn32_N4ff293fooEv,_ZThn16_N4ff293fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff29[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI4ff29[0]),
  (VTBL_ENTRY)&_ZN4ff293fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ff29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff293fooEv,_ZTv0_n12_N4ff293fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI4ff29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff293fooEv,_ZTv0_n12_N4ff293fooEv),
};
extern VTBL_ENTRY _ZTV4ff29[];
static  VTT_ENTRY vtt_ff29[] = {
  {&(_ZTV4ff29[4]),  4,13},
  {&(_ZTV4ff29[8]),  8,13},
  {&(_ZTV4ff29[12]),  12,13},
};
extern VTBL_ENTRY _ZTI4ff29[];
extern  VTBL_ENTRY _ZTV4ff29[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff29[];
static VTBL_ENTRY alt_thunk_names72[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff293fooEv,_ZTv0_n12_N4ff293fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ff293fooEv,_ZThn16_N4ff293fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff293fooEv,_ZThn8_N4ff293fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff29 = {  "ff29", // class name
  bases_ff29, 2,
  &(vtc_ff29[0]), // expected_vtbl_contents
  &(vtt_ff29[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI4ff29),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff29),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ff29),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names72,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg29  : virtual ee29 , ff29 {
  int g;
   gg29(const ABISELECT(__tsi64,int) *const *); // _ZN4gg29C2Ev
  virtual void  foo(); // _ZN4gg293fooEv
  ~gg29(); // tgen
  gg29(); // tgen
};
//SIG(1 gg29) C1{ VBC2{ VBC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ VBC6{ v1 Fi} VBC7{ v1 Fi} v1 Fi} v1 Fi}


 gg29 ::gg29(const ABISELECT(__tsi64,int) *const *){}
void  gg29 ::foo(){vfunc_called(this, "_ZN4gg293fooEv");}
gg29 ::~gg29(){ note_dtor("gg29", this);} // tgen
gg29 ::gg29(){ note_ctor("gg29", this);} // tgen

static void Test_gg29()
{
  extern Class_Descriptor cd_gg29;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,13)];
    init_test(&cd_gg29, buf);
    gg29 *dp, &lv = *(dp=new (buf) gg29());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,48), "sizeof(gg29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg29)");
    check_base_class_offset(lv, (aa29*)(ee29*), ABISELECT(32,24), "gg29");
    check_base_class_offset(lv, (bb29*)(ee29*), ABISELECT(16,12), "gg29");
    check_base_class_offset(lv, (ee29*), ABISELECT(16,12), "gg29");
    check_base_class_offset(lv, (cc29*)(ff29*), ABISELECT(48,32), "gg29");
    check_base_class_offset(lv, (dd29*)(ff29*), ABISELECT(64,40), "gg29");
    check_base_class_offset(lv, (ff29*), 0, "gg29");
    check_field_offset(lv, g, ABISELECT(12,8), "gg29.g");
    test_class_info(&lv, &cd_gg29);
    dp->~gg29();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg29(Test_gg29, "gg29", ABISELECT(80,48));

#else // __cplusplus

extern void _ZN4gg29C1Ev();
extern void _ZN4gg29D1Ev();
Name_Map name_map_gg29[] = {
  NSPAIR(_ZN4gg29C1Ev),
  NSPAIR(_ZN4gg29D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa29;
extern VTBL_ENTRY _ZTI4aa29[];
extern  VTBL_ENTRY _ZTV4aa29[];
extern Class_Descriptor cd_bb29;
extern VTBL_ENTRY _ZTI4bb29[];
extern  VTBL_ENTRY _ZTV4bb29[];
extern Class_Descriptor cd_ee29;
extern VTBL_ENTRY _ZTI4ee29[];
extern  VTBL_ENTRY _ZTV4ee29[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee29[];
extern Class_Descriptor cd_cc29;
extern VTBL_ENTRY _ZTI4cc29[];
extern  VTBL_ENTRY _ZTV4cc29[];
extern Class_Descriptor cd_dd29;
extern VTBL_ENTRY _ZTI4dd29[];
extern  VTBL_ENTRY _ZTV4dd29[];
extern Class_Descriptor cd_ff29;
extern VTBL_ENTRY _ZTI4ff29[];
extern  VTBL_ENTRY _ZTV4ff29[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff29[];
static Base_Class bases_gg29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa29,    ABISELECT(32,24), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_bb29,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_ee29,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_cc29,    ABISELECT(48,32), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_dd29,    ABISELECT(64,40), //bcp->offset
    20, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_ff29,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4gg29[];
extern void _ZN4gg293fooEv();
extern void ABISELECT(_ZTv0_n32_N4gg293fooEv,_ZTv0_n16_N4gg293fooEv)();
extern void ABISELECT(_ZThn16_N4gg293fooEv,_ZThn12_N4gg293fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg293fooEv,_ZTv0_n12_N4gg293fooEv)();
extern void ABISELECT(_ZThn32_N4gg293fooEv,_ZThn24_N4gg293fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg293fooEv,_ZTv0_n12_N4gg293fooEv)();
extern void ABISELECT(_ZThn48_N4gg293fooEv,_ZThn32_N4gg293fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg293fooEv,_ZTv0_n12_N4gg293fooEv)();
extern void ABISELECT(_ZThn64_N4gg293fooEv,_ZThn40_N4gg293fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg29[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  ABISELECT(64,40),
  ABISELECT(48,32),
  0,
  (VTBL_ENTRY)&(_ZTI4gg29[0]),
  (VTBL_ENTRY)&_ZN4gg293fooEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4gg29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N4gg293fooEv,_ZTv0_n16_N4gg293fooEv),
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI4gg29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg293fooEv,_ZTv0_n12_N4gg293fooEv),
  ABISELECT(-48,-32),
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI4gg29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg293fooEv,_ZTv0_n12_N4gg293fooEv),
  ABISELECT(-64,-40),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI4gg29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg293fooEv,_ZTv0_n12_N4gg293fooEv),
};
extern VTBL_ENTRY _ZTV4gg29[];
extern void _ZN4ff293fooEv();
static  VTBL_ENTRY _tg__ZTV4ff29__4gg29[] = {
  ABISELECT(64,40),
  ABISELECT(48,32),
  0,
  (VTBL_ENTRY)&(_ZTI4ff29[0]),
  (VTBL_ENTRY)&_ZN4ff293fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ff293fooEv,_ZTv0_n12_N4ff293fooEv)();
extern void ABISELECT(_ZThn48_N4ff293fooEv,_ZThn32_N4ff293fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4cc29__4ff29__4gg29[] = {
  ABISELECT(-48,-32),
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI4ff29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff293fooEv,_ZTv0_n12_N4ff293fooEv),
};
extern void ABISELECT(_ZTv0_n24_N4ff293fooEv,_ZTv0_n12_N4ff293fooEv)();
extern void ABISELECT(_ZThn64_N4ff293fooEv,_ZThn40_N4ff293fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4dd29__4ff29__4gg29[] = {
  ABISELECT(-64,-40),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI4ff29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff293fooEv,_ZTv0_n12_N4ff293fooEv),
};
extern void _ZN4ee293fooEv();
static  VTBL_ENTRY _tg__ZTV4ee29__4gg29[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee29[0]),
  (VTBL_ENTRY)&_ZN4ee293fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ee293fooEv,_ZTv0_n12_N4ee293fooEv)();
extern void ABISELECT(_ZThn16_N4ee293fooEv,_ZThn12_N4ee293fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4aa29__4ee29__4gg29[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee29[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee293fooEv,_ZTv0_n12_N4ee293fooEv),
};
static  VTT_ENTRY vtt_gg29[] = {
  {&(_ZTV4gg29[6]),  6,24},
  {&(_tg__ZTV4ff29__4gg29[4]),  4,5},
  {&(_tg__ZTV4cc29__4ff29__4gg29[3]),  3,4},
  {&(_tg__ZTV4dd29__4ff29__4gg29[3]),  3,4},
  {&(_ZTV4gg29[11]),  11,24},
  {&(_ZTV4gg29[15]),  15,24},
  {&(_ZTV4gg29[19]),  19,24},
  {&(_ZTV4gg29[23]),  23,24},
  {&(_tg__ZTV4ee29__4gg29[3]),  3,4},
  {&(_tg__ZTV4aa29__4ee29__4gg29[3]),  3,4},
};
extern VTBL_ENTRY _ZTI4gg29[];
extern  VTBL_ENTRY _ZTV4gg29[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg29[];
static VTBL_ENTRY alt_thunk_names73[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee293fooEv,_ZTv0_n12_N4ee293fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee293fooEv,_ZThn12_N4ee293fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff293fooEv,_ZTv0_n12_N4ff293fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N4ff293fooEv,_ZThn40_N4ff293fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N4ff293fooEv,_ZThn32_N4ff293fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg293fooEv,_ZTv0_n12_N4gg293fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N4gg293fooEv,_ZThn40_N4gg293fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N4gg293fooEv,_ZThn32_N4gg293fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4gg293fooEv,_ZThn24_N4gg293fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N4gg293fooEv,_ZTv0_n16_N4gg293fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4gg293fooEv,_ZThn12_N4gg293fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg29 = {  "gg29", // class name
  bases_gg29, 6,
  &(vtc_gg29[0]), // expected_vtbl_contents
  &(vtt_gg29[0]), // expected_vtt_contents
  ABISELECT(80,48), // object size
  NSPAIRA(_ZTI4gg29),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg29),24, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg29),10, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names73,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa30  {
  int a;
   aa30(); // _ZN4aa30C1Ev
  virtual void  foo(); // _ZN4aa303fooEv
  ~aa30(); // tgen
};
//SIG(-1 aa30) C1{ v1 Fi}


 aa30 ::aa30(){ note_ctor("aa30", this);}
void  aa30 ::foo(){vfunc_called(this, "_ZN4aa303fooEv");}
aa30 ::~aa30(){ note_dtor("aa30", this);} // tgen

static void Test_aa30()
{
  extern Class_Descriptor cd_aa30;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa30, buf);
    aa30 *dp, &lv = *(dp=new (buf) aa30());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa30)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa30.a");
    test_class_info(&lv, &cd_aa30);
    dp->~aa30();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa30(Test_aa30, "aa30", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa30C1Ev();
extern void _ZN4aa30D1Ev();
Name_Map name_map_aa30[] = {
  NSPAIR(_ZN4aa30C1Ev),
  NSPAIR(_ZN4aa30D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa30[];
extern void _ZN4aa303fooEv();
static  VTBL_ENTRY vtc_aa30[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa30[0]),
  (VTBL_ENTRY)&_ZN4aa303fooEv,
};
extern VTBL_ENTRY _ZTI4aa30[];
extern  VTBL_ENTRY _ZTV4aa30[];
Class_Descriptor cd_aa30 = {  "aa30", // class name
  0,0,//no base classes
  &(vtc_aa30[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa30),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa30),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb30  {
  int b;
   bb30(); // _ZN4bb30C1Ev
  virtual void  foo(); // _ZN4bb303fooEv
  ~bb30(); // tgen
};
//SIG(-1 bb30) C1{ v1 Fi}


 bb30 ::bb30(){ note_ctor("bb30", this);}
void  bb30 ::foo(){vfunc_called(this, "_ZN4bb303fooEv");}
bb30 ::~bb30(){ note_dtor("bb30", this);} // tgen

static void Test_bb30()
{
  extern Class_Descriptor cd_bb30;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb30, buf);
    bb30 *dp, &lv = *(dp=new (buf) bb30());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb30)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb30.b");
    test_class_info(&lv, &cd_bb30);
    dp->~bb30();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb30(Test_bb30, "bb30", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb30C1Ev();
extern void _ZN4bb30D1Ev();
Name_Map name_map_bb30[] = {
  NSPAIR(_ZN4bb30C1Ev),
  NSPAIR(_ZN4bb30D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb30[];
extern void _ZN4bb303fooEv();
static  VTBL_ENTRY vtc_bb30[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb30[0]),
  (VTBL_ENTRY)&_ZN4bb303fooEv,
};
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
Class_Descriptor cd_bb30 = {  "bb30", // class name
  0,0,//no base classes
  &(vtc_bb30[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb30),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb30),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc30  {
  int c;
   cc30(); // _ZN4cc30C1Ev
  virtual void  foo(); // _ZN4cc303fooEv
  ~cc30(); // tgen
};
//SIG(-1 cc30) C1{ v1 Fi}


 cc30 ::cc30(){ note_ctor("cc30", this);}
void  cc30 ::foo(){vfunc_called(this, "_ZN4cc303fooEv");}
cc30 ::~cc30(){ note_dtor("cc30", this);} // tgen

static void Test_cc30()
{
  extern Class_Descriptor cd_cc30;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc30, buf);
    cc30 *dp, &lv = *(dp=new (buf) cc30());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc30)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc30.c");
    test_class_info(&lv, &cd_cc30);
    dp->~cc30();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc30(Test_cc30, "cc30", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc30C1Ev();
extern void _ZN4cc30D1Ev();
Name_Map name_map_cc30[] = {
  NSPAIR(_ZN4cc30C1Ev),
  NSPAIR(_ZN4cc30D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc30[];
extern void _ZN4cc303fooEv();
static  VTBL_ENTRY vtc_cc30[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc30[0]),
  (VTBL_ENTRY)&_ZN4cc303fooEv,
};
extern VTBL_ENTRY _ZTI4cc30[];
extern  VTBL_ENTRY _ZTV4cc30[];
Class_Descriptor cd_cc30 = {  "cc30", // class name
  0,0,//no base classes
  &(vtc_cc30[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc30),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc30),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd30  {
  int d;
   dd30(); // _ZN4dd30C1Ev
  virtual void  foo(); // _ZN4dd303fooEv
  ~dd30(); // tgen
};
//SIG(-1 dd30) C1{ v1 Fi}


 dd30 ::dd30(){ note_ctor("dd30", this);}
void  dd30 ::foo(){vfunc_called(this, "_ZN4dd303fooEv");}
dd30 ::~dd30(){ note_dtor("dd30", this);} // tgen

static void Test_dd30()
{
  extern Class_Descriptor cd_dd30;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd30, buf);
    dd30 *dp, &lv = *(dp=new (buf) dd30());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd30)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd30.d");
    test_class_info(&lv, &cd_dd30);
    dp->~dd30();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd30(Test_dd30, "dd30", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd30C1Ev();
extern void _ZN4dd30D1Ev();
Name_Map name_map_dd30[] = {
  NSPAIR(_ZN4dd30C1Ev),
  NSPAIR(_ZN4dd30D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd30[];
extern void _ZN4dd303fooEv();
static  VTBL_ENTRY vtc_dd30[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd30[0]),
  (VTBL_ENTRY)&_ZN4dd303fooEv,
};
extern VTBL_ENTRY _ZTI4dd30[];
extern  VTBL_ENTRY _ZTV4dd30[];
Class_Descriptor cd_dd30 = {  "dd30", // class name
  0,0,//no base classes
  &(vtc_dd30[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd30),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd30),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee30  : aa30 , virtual bb30 {
  int e;
   ee30(const ABISELECT(__tsi64,int) *const *); // _ZN4ee30C2Ev
  virtual void  foo(); // _ZN4ee303fooEv
  ~ee30(); // tgen
  ee30(); // tgen
};
//SIG(-1 ee30) C1{ BC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ee30 ::ee30(const ABISELECT(__tsi64,int) *const *){}
void  ee30 ::foo(){vfunc_called(this, "_ZN4ee303fooEv");}
ee30 ::~ee30(){ note_dtor("ee30", this);} // tgen
ee30 ::ee30(){ note_ctor("ee30", this);} // tgen

static void Test_ee30()
{
  extern Class_Descriptor cd_ee30;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee30, buf);
    ee30 *dp, &lv = *(dp=new (buf) ee30());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee30)");
    check_base_class_offset(lv, (aa30*), 0, "ee30");
    check_base_class_offset(lv, (bb30*), ABISELECT(16,12), "ee30");
    check_field_offset(lv, e, ABISELECT(12,8), "ee30.e");
    test_class_info(&lv, &cd_ee30);
    dp->~ee30();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee30(Test_ee30, "ee30", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ee30C1Ev();
extern void _ZN4ee30D1Ev();
Name_Map name_map_ee30[] = {
  NSPAIR(_ZN4ee30C1Ev),
  NSPAIR(_ZN4ee30D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa30;
extern VTBL_ENTRY _ZTI4aa30[];
extern  VTBL_ENTRY _ZTV4aa30[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
static Base_Class bases_ee30[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_bb30,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ee30[];
extern void _ZN4ee303fooEv();
extern void ABISELECT(_ZTv0_n24_N4ee303fooEv,_ZTv0_n12_N4ee303fooEv)();
extern void ABISELECT(_ZThn16_N4ee303fooEv,_ZThn12_N4ee303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee30[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee30[0]),
  (VTBL_ENTRY)&_ZN4ee303fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee30[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee303fooEv,_ZTv0_n12_N4ee303fooEv),
};
extern VTBL_ENTRY _ZTV4ee30[];
static  VTT_ENTRY vtt_ee30[] = {
  {&(_ZTV4ee30[3]),  3,8},
  {&(_ZTV4ee30[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ee30[];
extern  VTBL_ENTRY _ZTV4ee30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee30[];
static VTBL_ENTRY alt_thunk_names74[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee303fooEv,_ZTv0_n12_N4ee303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee303fooEv,_ZThn12_N4ee303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee30 = {  "ee30", // class name
  bases_ee30, 2,
  &(vtc_ee30[0]), // expected_vtbl_contents
  &(vtt_ee30[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ee30),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee30),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ee30),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names74,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff30  : virtual cc30 , virtual dd30 {
  int f;
   ff30(const ABISELECT(__tsi64,int) *const *); // _ZN4ff30C2Ev
  virtual void  foo(); // _ZN4ff303fooEv
  ~ff30(); // tgen
  ff30(); // tgen
};
//SIG(-1 ff30) C1{ VBC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ff30 ::ff30(const ABISELECT(__tsi64,int) *const *){}
void  ff30 ::foo(){vfunc_called(this, "_ZN4ff303fooEv");}
ff30 ::~ff30(){ note_dtor("ff30", this);} // tgen
ff30 ::ff30(){ note_ctor("ff30", this);} // tgen

static void Test_ff30()
{
  extern Class_Descriptor cd_ff30;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_ff30, buf);
    ff30 *dp, &lv = *(dp=new (buf) ff30());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(ff30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff30)");
    check_base_class_offset(lv, (cc30*), ABISELECT(16,8), "ff30");
    check_base_class_offset(lv, (dd30*), ABISELECT(32,16), "ff30");
    check_field_offset(lv, f, ABISELECT(8,4), "ff30.f");
    test_class_info(&lv, &cd_ff30);
    dp->~ff30();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff30(Test_ff30, "ff30", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN4ff30C1Ev();
extern void _ZN4ff30D1Ev();
Name_Map name_map_ff30[] = {
  NSPAIR(_ZN4ff30C1Ev),
  NSPAIR(_ZN4ff30D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc30;
extern VTBL_ENTRY _ZTI4cc30[];
extern  VTBL_ENTRY _ZTV4cc30[];
extern Class_Descriptor cd_dd30;
extern VTBL_ENTRY _ZTI4dd30[];
extern  VTBL_ENTRY _ZTV4dd30[];
static Base_Class bases_ff30[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc30,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_dd30,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ff30[];
extern void _ZN4ff303fooEv();
extern void ABISELECT(_ZTv0_n24_N4ff303fooEv,_ZTv0_n12_N4ff303fooEv)();
extern void ABISELECT(_ZThn16_N4ff303fooEv,_ZThn8_N4ff303fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4ff303fooEv,_ZTv0_n12_N4ff303fooEv)();
extern void ABISELECT(_ZThn32_N4ff303fooEv,_ZThn16_N4ff303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff30[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI4ff30[0]),
  (VTBL_ENTRY)&_ZN4ff303fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ff30[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff303fooEv,_ZTv0_n12_N4ff303fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI4ff30[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff303fooEv,_ZTv0_n12_N4ff303fooEv),
};
extern VTBL_ENTRY _ZTV4ff30[];
static  VTT_ENTRY vtt_ff30[] = {
  {&(_ZTV4ff30[4]),  4,13},
  {&(_ZTV4ff30[8]),  8,13},
  {&(_ZTV4ff30[12]),  12,13},
};
extern VTBL_ENTRY _ZTI4ff30[];
extern  VTBL_ENTRY _ZTV4ff30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff30[];
static VTBL_ENTRY alt_thunk_names75[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff303fooEv,_ZTv0_n12_N4ff303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ff303fooEv,_ZThn16_N4ff303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff303fooEv,_ZThn8_N4ff303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff30 = {  "ff30", // class name
  bases_ff30, 2,
  &(vtc_ff30[0]), // expected_vtbl_contents
  &(vtt_ff30[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI4ff30),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff30),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ff30),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names75,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg30  : virtual ee30 , ff30 {
  int g;
   gg30(const ABISELECT(__tsi64,int) *const *); // _ZN4gg30C2Ev
  virtual void  foo(); // _ZN4gg303fooEv
  ~gg30(); // tgen
  gg30(); // tgen
};
//SIG(1 gg30) C1{ VBC2{ BC3{ v1 Fi} VBC4{ v1 Fi} v1 Fi} BC5{ VBC6{ v1 Fi} VBC7{ v1 Fi} v1 Fi} v1 Fi}


 gg30 ::gg30(const ABISELECT(__tsi64,int) *const *){}
void  gg30 ::foo(){vfunc_called(this, "_ZN4gg303fooEv");}
gg30 ::~gg30(){ note_dtor("gg30", this);} // tgen
gg30 ::gg30(){ note_ctor("gg30", this);} // tgen

static void Test_gg30()
{
  extern Class_Descriptor cd_gg30;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,13)];
    init_test(&cd_gg30, buf);
    gg30 *dp, &lv = *(dp=new (buf) gg30());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,48), "sizeof(gg30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg30)");
    check_base_class_offset(lv, (aa30*)(ee30*), ABISELECT(16,12), "gg30");
    check_base_class_offset(lv, (bb30*)(ee30*), ABISELECT(32,24), "gg30");
    check_base_class_offset(lv, (ee30*), ABISELECT(16,12), "gg30");
    check_base_class_offset(lv, (cc30*)(ff30*), ABISELECT(48,32), "gg30");
    check_base_class_offset(lv, (dd30*)(ff30*), ABISELECT(64,40), "gg30");
    check_base_class_offset(lv, (ff30*), 0, "gg30");
    check_field_offset(lv, g, ABISELECT(12,8), "gg30.g");
    test_class_info(&lv, &cd_gg30);
    dp->~gg30();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg30(Test_gg30, "gg30", ABISELECT(80,48));

#else // __cplusplus

extern void _ZN4gg30C1Ev();
extern void _ZN4gg30D1Ev();
Name_Map name_map_gg30[] = {
  NSPAIR(_ZN4gg30C1Ev),
  NSPAIR(_ZN4gg30D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa30;
extern VTBL_ENTRY _ZTI4aa30[];
extern  VTBL_ENTRY _ZTV4aa30[];
extern Class_Descriptor cd_bb30;
extern VTBL_ENTRY _ZTI4bb30[];
extern  VTBL_ENTRY _ZTV4bb30[];
extern Class_Descriptor cd_ee30;
extern VTBL_ENTRY _ZTI4ee30[];
extern  VTBL_ENTRY _ZTV4ee30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee30[];
extern Class_Descriptor cd_cc30;
extern VTBL_ENTRY _ZTI4cc30[];
extern  VTBL_ENTRY _ZTV4cc30[];
extern Class_Descriptor cd_dd30;
extern VTBL_ENTRY _ZTI4dd30[];
extern  VTBL_ENTRY _ZTV4dd30[];
extern Class_Descriptor cd_ff30;
extern VTBL_ENTRY _ZTI4ff30[];
extern  VTBL_ENTRY _ZTV4ff30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff30[];
static Base_Class bases_gg30[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa30,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_bb30,    ABISELECT(32,24), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_ee30,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_cc30,    ABISELECT(48,32), //bcp->offset
    16, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_dd30,    ABISELECT(64,40), //bcp->offset
    20, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_ff30,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4gg30[];
extern void _ZN4gg303fooEv();
extern void ABISELECT(_ZTv0_n32_N4gg303fooEv,_ZTv0_n16_N4gg303fooEv)();
extern void ABISELECT(_ZThn16_N4gg303fooEv,_ZThn12_N4gg303fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg303fooEv,_ZTv0_n12_N4gg303fooEv)();
extern void ABISELECT(_ZThn32_N4gg303fooEv,_ZThn24_N4gg303fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg303fooEv,_ZTv0_n12_N4gg303fooEv)();
extern void ABISELECT(_ZThn48_N4gg303fooEv,_ZThn32_N4gg303fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg303fooEv,_ZTv0_n12_N4gg303fooEv)();
extern void ABISELECT(_ZThn64_N4gg303fooEv,_ZThn40_N4gg303fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg30[] = {
  ABISELECT(32,24),
  ABISELECT(16,12),
  ABISELECT(64,40),
  ABISELECT(48,32),
  0,
  (VTBL_ENTRY)&(_ZTI4gg30[0]),
  (VTBL_ENTRY)&_ZN4gg303fooEv,
  ABISELECT(-16,-12),
  ABISELECT(16,12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4gg30[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N4gg303fooEv,_ZTv0_n16_N4gg303fooEv),
  ABISELECT(-32,-24),
  ABISELECT(-32,-24),
  (VTBL_ENTRY)&(_ZTI4gg30[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg303fooEv,_ZTv0_n12_N4gg303fooEv),
  ABISELECT(-48,-32),
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI4gg30[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg303fooEv,_ZTv0_n12_N4gg303fooEv),
  ABISELECT(-64,-40),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI4gg30[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg303fooEv,_ZTv0_n12_N4gg303fooEv),
};
extern VTBL_ENTRY _ZTV4gg30[];
extern void _ZN4ff303fooEv();
static  VTBL_ENTRY _tg__ZTV4ff30__4gg30[] = {
  ABISELECT(64,40),
  ABISELECT(48,32),
  0,
  (VTBL_ENTRY)&(_ZTI4ff30[0]),
  (VTBL_ENTRY)&_ZN4ff303fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ff303fooEv,_ZTv0_n12_N4ff303fooEv)();
extern void ABISELECT(_ZThn48_N4ff303fooEv,_ZThn32_N4ff303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4cc30__4ff30__4gg30[] = {
  ABISELECT(-48,-32),
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI4ff30[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff303fooEv,_ZTv0_n12_N4ff303fooEv),
};
extern void ABISELECT(_ZTv0_n24_N4ff303fooEv,_ZTv0_n12_N4ff303fooEv)();
extern void ABISELECT(_ZThn64_N4ff303fooEv,_ZThn40_N4ff303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4dd30__4ff30__4gg30[] = {
  ABISELECT(-64,-40),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI4ff30[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff303fooEv,_ZTv0_n12_N4ff303fooEv),
};
extern void _ZN4ee303fooEv();
static  VTBL_ENTRY _tg__ZTV4ee30__4gg30[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee30[0]),
  (VTBL_ENTRY)&_ZN4ee303fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ee303fooEv,_ZTv0_n12_N4ee303fooEv)();
extern void ABISELECT(_ZThn16_N4ee303fooEv,_ZThn12_N4ee303fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb30__4ee30__4gg30[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee30[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee303fooEv,_ZTv0_n12_N4ee303fooEv),
};
static  VTT_ENTRY vtt_gg30[] = {
  {&(_ZTV4gg30[6]),  6,24},
  {&(_tg__ZTV4ff30__4gg30[4]),  4,5},
  {&(_tg__ZTV4cc30__4ff30__4gg30[3]),  3,4},
  {&(_tg__ZTV4dd30__4ff30__4gg30[3]),  3,4},
  {&(_ZTV4gg30[11]),  11,24},
  {&(_ZTV4gg30[15]),  15,24},
  {&(_ZTV4gg30[19]),  19,24},
  {&(_ZTV4gg30[23]),  23,24},
  {&(_tg__ZTV4ee30__4gg30[3]),  3,4},
  {&(_tg__ZTV4bb30__4ee30__4gg30[3]),  3,4},
};
extern VTBL_ENTRY _ZTI4gg30[];
extern  VTBL_ENTRY _ZTV4gg30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg30[];
static VTBL_ENTRY alt_thunk_names76[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee303fooEv,_ZTv0_n12_N4ee303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee303fooEv,_ZThn12_N4ee303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff303fooEv,_ZTv0_n12_N4ff303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N4ff303fooEv,_ZThn40_N4ff303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N4ff303fooEv,_ZThn32_N4ff303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg303fooEv,_ZTv0_n12_N4gg303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N4gg303fooEv,_ZThn40_N4gg303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N4gg303fooEv,_ZThn32_N4gg303fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4gg303fooEv,_ZThn24_N4gg303fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N4gg303fooEv,_ZTv0_n16_N4gg303fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4gg303fooEv,_ZThn12_N4gg303fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg30 = {  "gg30", // class name
  bases_gg30, 6,
  &(vtc_gg30[0]), // expected_vtbl_contents
  &(vtt_gg30[0]), // expected_vtt_contents
  ABISELECT(80,48), // object size
  NSPAIRA(_ZTI4gg30),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg30),24, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg30),10, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names76,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa31  {
  int a;
   aa31(); // _ZN4aa31C1Ev
  virtual void  foo(); // _ZN4aa313fooEv
  ~aa31(); // tgen
};
//SIG(-1 aa31) C1{ v1 Fi}


 aa31 ::aa31(){ note_ctor("aa31", this);}
void  aa31 ::foo(){vfunc_called(this, "_ZN4aa313fooEv");}
aa31 ::~aa31(){ note_dtor("aa31", this);} // tgen

static void Test_aa31()
{
  extern Class_Descriptor cd_aa31;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa31, buf);
    aa31 *dp, &lv = *(dp=new (buf) aa31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa31)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa31.a");
    test_class_info(&lv, &cd_aa31);
    dp->~aa31();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa31(Test_aa31, "aa31", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa31C1Ev();
extern void _ZN4aa31D1Ev();
Name_Map name_map_aa31[] = {
  NSPAIR(_ZN4aa31C1Ev),
  NSPAIR(_ZN4aa31D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa31[];
extern void _ZN4aa313fooEv();
static  VTBL_ENTRY vtc_aa31[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa31[0]),
  (VTBL_ENTRY)&_ZN4aa313fooEv,
};
extern VTBL_ENTRY _ZTI4aa31[];
extern  VTBL_ENTRY _ZTV4aa31[];
Class_Descriptor cd_aa31 = {  "aa31", // class name
  0,0,//no base classes
  &(vtc_aa31[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa31),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa31),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb31  {
  int b;
   bb31(); // _ZN4bb31C1Ev
  virtual void  foo(); // _ZN4bb313fooEv
  ~bb31(); // tgen
};
//SIG(-1 bb31) C1{ v1 Fi}


 bb31 ::bb31(){ note_ctor("bb31", this);}
void  bb31 ::foo(){vfunc_called(this, "_ZN4bb313fooEv");}
bb31 ::~bb31(){ note_dtor("bb31", this);} // tgen

static void Test_bb31()
{
  extern Class_Descriptor cd_bb31;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb31, buf);
    bb31 *dp, &lv = *(dp=new (buf) bb31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb31)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb31.b");
    test_class_info(&lv, &cd_bb31);
    dp->~bb31();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb31(Test_bb31, "bb31", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb31C1Ev();
extern void _ZN4bb31D1Ev();
Name_Map name_map_bb31[] = {
  NSPAIR(_ZN4bb31C1Ev),
  NSPAIR(_ZN4bb31D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb31[];
extern void _ZN4bb313fooEv();
static  VTBL_ENTRY vtc_bb31[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb31[0]),
  (VTBL_ENTRY)&_ZN4bb313fooEv,
};
extern VTBL_ENTRY _ZTI4bb31[];
extern  VTBL_ENTRY _ZTV4bb31[];
Class_Descriptor cd_bb31 = {  "bb31", // class name
  0,0,//no base classes
  &(vtc_bb31[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb31),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb31),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc31  {
  int c;
   cc31(); // _ZN4cc31C1Ev
  virtual void  foo(); // _ZN4cc313fooEv
  ~cc31(); // tgen
};
//SIG(-1 cc31) C1{ v1 Fi}


 cc31 ::cc31(){ note_ctor("cc31", this);}
void  cc31 ::foo(){vfunc_called(this, "_ZN4cc313fooEv");}
cc31 ::~cc31(){ note_dtor("cc31", this);} // tgen

static void Test_cc31()
{
  extern Class_Descriptor cd_cc31;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc31, buf);
    cc31 *dp, &lv = *(dp=new (buf) cc31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc31)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc31.c");
    test_class_info(&lv, &cd_cc31);
    dp->~cc31();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc31(Test_cc31, "cc31", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc31C1Ev();
extern void _ZN4cc31D1Ev();
Name_Map name_map_cc31[] = {
  NSPAIR(_ZN4cc31C1Ev),
  NSPAIR(_ZN4cc31D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc31[];
extern void _ZN4cc313fooEv();
static  VTBL_ENTRY vtc_cc31[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc31[0]),
  (VTBL_ENTRY)&_ZN4cc313fooEv,
};
extern VTBL_ENTRY _ZTI4cc31[];
extern  VTBL_ENTRY _ZTV4cc31[];
Class_Descriptor cd_cc31 = {  "cc31", // class name
  0,0,//no base classes
  &(vtc_cc31[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc31),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc31),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd31  {
  int d;
   dd31(); // _ZN4dd31C1Ev
  virtual void  foo(); // _ZN4dd313fooEv
  ~dd31(); // tgen
};
//SIG(-1 dd31) C1{ v1 Fi}


 dd31 ::dd31(){ note_ctor("dd31", this);}
void  dd31 ::foo(){vfunc_called(this, "_ZN4dd313fooEv");}
dd31 ::~dd31(){ note_dtor("dd31", this);} // tgen

static void Test_dd31()
{
  extern Class_Descriptor cd_dd31;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd31, buf);
    dd31 *dp, &lv = *(dp=new (buf) dd31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd31)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd31.d");
    test_class_info(&lv, &cd_dd31);
    dp->~dd31();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd31(Test_dd31, "dd31", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd31C1Ev();
extern void _ZN4dd31D1Ev();
Name_Map name_map_dd31[] = {
  NSPAIR(_ZN4dd31C1Ev),
  NSPAIR(_ZN4dd31D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd31[];
extern void _ZN4dd313fooEv();
static  VTBL_ENTRY vtc_dd31[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd31[0]),
  (VTBL_ENTRY)&_ZN4dd313fooEv,
};
extern VTBL_ENTRY _ZTI4dd31[];
extern  VTBL_ENTRY _ZTV4dd31[];
Class_Descriptor cd_dd31 = {  "dd31", // class name
  0,0,//no base classes
  &(vtc_dd31[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd31),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd31),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee31  : virtual aa31 , virtual bb31 {
  int e;
   ee31(const ABISELECT(__tsi64,int) *const *); // _ZN4ee31C2Ev
  virtual void  foo(); // _ZN4ee313fooEv
  ~ee31(); // tgen
  ee31(); // tgen
};
//SIG(-1 ee31) C1{ VBC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ee31 ::ee31(const ABISELECT(__tsi64,int) *const *){}
void  ee31 ::foo(){vfunc_called(this, "_ZN4ee313fooEv");}
ee31 ::~ee31(){ note_dtor("ee31", this);} // tgen
ee31 ::ee31(){ note_ctor("ee31", this);} // tgen

static void Test_ee31()
{
  extern Class_Descriptor cd_ee31;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_ee31, buf);
    ee31 *dp, &lv = *(dp=new (buf) ee31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(ee31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee31)");
    check_base_class_offset(lv, (aa31*), ABISELECT(16,8), "ee31");
    check_base_class_offset(lv, (bb31*), ABISELECT(32,16), "ee31");
    check_field_offset(lv, e, ABISELECT(8,4), "ee31.e");
    test_class_info(&lv, &cd_ee31);
    dp->~ee31();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee31(Test_ee31, "ee31", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN4ee31C1Ev();
extern void _ZN4ee31D1Ev();
Name_Map name_map_ee31[] = {
  NSPAIR(_ZN4ee31C1Ev),
  NSPAIR(_ZN4ee31D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa31;
extern VTBL_ENTRY _ZTI4aa31[];
extern  VTBL_ENTRY _ZTV4aa31[];
extern Class_Descriptor cd_bb31;
extern VTBL_ENTRY _ZTI4bb31[];
extern  VTBL_ENTRY _ZTV4bb31[];
static Base_Class bases_ee31[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa31,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_bb31,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ee31[];
extern void _ZN4ee313fooEv();
extern void ABISELECT(_ZTv0_n24_N4ee313fooEv,_ZTv0_n12_N4ee313fooEv)();
extern void ABISELECT(_ZThn16_N4ee313fooEv,_ZThn8_N4ee313fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4ee313fooEv,_ZTv0_n12_N4ee313fooEv)();
extern void ABISELECT(_ZThn32_N4ee313fooEv,_ZThn16_N4ee313fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee31[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI4ee31[0]),
  (VTBL_ENTRY)&_ZN4ee313fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ee31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee313fooEv,_ZTv0_n12_N4ee313fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI4ee31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee313fooEv,_ZTv0_n12_N4ee313fooEv),
};
extern VTBL_ENTRY _ZTV4ee31[];
static  VTT_ENTRY vtt_ee31[] = {
  {&(_ZTV4ee31[4]),  4,13},
  {&(_ZTV4ee31[8]),  8,13},
  {&(_ZTV4ee31[12]),  12,13},
};
extern VTBL_ENTRY _ZTI4ee31[];
extern  VTBL_ENTRY _ZTV4ee31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee31[];
static VTBL_ENTRY alt_thunk_names77[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee313fooEv,_ZTv0_n12_N4ee313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ee313fooEv,_ZThn16_N4ee313fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee313fooEv,_ZThn8_N4ee313fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee31 = {  "ee31", // class name
  bases_ee31, 2,
  &(vtc_ee31[0]), // expected_vtbl_contents
  &(vtt_ee31[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI4ee31),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee31),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ee31),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names77,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff31  : virtual cc31 , virtual dd31 {
  int f;
   ff31(const ABISELECT(__tsi64,int) *const *); // _ZN4ff31C2Ev
  virtual void  foo(); // _ZN4ff313fooEv
  ~ff31(); // tgen
  ff31(); // tgen
};
//SIG(-1 ff31) C1{ VBC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ff31 ::ff31(const ABISELECT(__tsi64,int) *const *){}
void  ff31 ::foo(){vfunc_called(this, "_ZN4ff313fooEv");}
ff31 ::~ff31(){ note_dtor("ff31", this);} // tgen
ff31 ::ff31(){ note_ctor("ff31", this);} // tgen

static void Test_ff31()
{
  extern Class_Descriptor cd_ff31;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_ff31, buf);
    ff31 *dp, &lv = *(dp=new (buf) ff31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(ff31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff31)");
    check_base_class_offset(lv, (cc31*), ABISELECT(16,8), "ff31");
    check_base_class_offset(lv, (dd31*), ABISELECT(32,16), "ff31");
    check_field_offset(lv, f, ABISELECT(8,4), "ff31.f");
    test_class_info(&lv, &cd_ff31);
    dp->~ff31();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff31(Test_ff31, "ff31", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN4ff31C1Ev();
extern void _ZN4ff31D1Ev();
Name_Map name_map_ff31[] = {
  NSPAIR(_ZN4ff31C1Ev),
  NSPAIR(_ZN4ff31D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc31;
extern VTBL_ENTRY _ZTI4cc31[];
extern  VTBL_ENTRY _ZTV4cc31[];
extern Class_Descriptor cd_dd31;
extern VTBL_ENTRY _ZTI4dd31[];
extern  VTBL_ENTRY _ZTV4dd31[];
static Base_Class bases_ff31[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc31,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_dd31,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ff31[];
extern void _ZN4ff313fooEv();
extern void ABISELECT(_ZTv0_n24_N4ff313fooEv,_ZTv0_n12_N4ff313fooEv)();
extern void ABISELECT(_ZThn16_N4ff313fooEv,_ZThn8_N4ff313fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4ff313fooEv,_ZTv0_n12_N4ff313fooEv)();
extern void ABISELECT(_ZThn32_N4ff313fooEv,_ZThn16_N4ff313fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff31[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI4ff31[0]),
  (VTBL_ENTRY)&_ZN4ff313fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ff31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff313fooEv,_ZTv0_n12_N4ff313fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI4ff31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff313fooEv,_ZTv0_n12_N4ff313fooEv),
};
extern VTBL_ENTRY _ZTV4ff31[];
static  VTT_ENTRY vtt_ff31[] = {
  {&(_ZTV4ff31[4]),  4,13},
  {&(_ZTV4ff31[8]),  8,13},
  {&(_ZTV4ff31[12]),  12,13},
};
extern VTBL_ENTRY _ZTI4ff31[];
extern  VTBL_ENTRY _ZTV4ff31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff31[];
static VTBL_ENTRY alt_thunk_names78[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff313fooEv,_ZTv0_n12_N4ff313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ff313fooEv,_ZThn16_N4ff313fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff313fooEv,_ZThn8_N4ff313fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff31 = {  "ff31", // class name
  bases_ff31, 2,
  &(vtc_ff31[0]), // expected_vtbl_contents
  &(vtt_ff31[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI4ff31),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff31),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ff31),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names78,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg31  : virtual ee31 , ff31 {
  int g;
   gg31(const ABISELECT(__tsi64,int) *const *); // _ZN4gg31C2Ev
  virtual void  foo(); // _ZN4gg313fooEv
  ~gg31(); // tgen
  gg31(); // tgen
};
//SIG(1 gg31) C1{ VBC2{ VBC3{ v1 Fi} VBC4{ v1 Fi} v1 Fi} BC5{ VBC6{ v1 Fi} VBC7{ v1 Fi} v1 Fi} v1 Fi}


 gg31 ::gg31(const ABISELECT(__tsi64,int) *const *){}
void  gg31 ::foo(){vfunc_called(this, "_ZN4gg313fooEv");}
gg31 ::~gg31(){ note_dtor("gg31", this);} // tgen
gg31 ::gg31(){ note_ctor("gg31", this);} // tgen

static void Test_gg31()
{
  extern Class_Descriptor cd_gg31;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,14)];
    init_test(&cd_gg31, buf);
    gg31 *dp, &lv = *(dp=new (buf) gg31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,52), "sizeof(gg31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg31)");
    check_base_class_offset(lv, (aa31*)(ee31*), ABISELECT(32,20), "gg31");
    check_base_class_offset(lv, (bb31*)(ee31*), ABISELECT(48,28), "gg31");
    check_base_class_offset(lv, (ee31*), ABISELECT(16,12), "gg31");
    check_base_class_offset(lv, (cc31*)(ff31*), ABISELECT(64,36), "gg31");
    check_base_class_offset(lv, (dd31*)(ff31*), ABISELECT(80,44), "gg31");
    check_base_class_offset(lv, (ff31*), 0, "gg31");
    check_field_offset(lv, g, ABISELECT(12,8), "gg31.g");
    test_class_info(&lv, &cd_gg31);
    dp->~gg31();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg31(Test_gg31, "gg31", ABISELECT(96,52));

#else // __cplusplus

extern void _ZN4gg31C1Ev();
extern void _ZN4gg31D1Ev();
Name_Map name_map_gg31[] = {
  NSPAIR(_ZN4gg31C1Ev),
  NSPAIR(_ZN4gg31D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa31;
extern VTBL_ENTRY _ZTI4aa31[];
extern  VTBL_ENTRY _ZTV4aa31[];
extern Class_Descriptor cd_bb31;
extern VTBL_ENTRY _ZTI4bb31[];
extern  VTBL_ENTRY _ZTV4bb31[];
extern Class_Descriptor cd_ee31;
extern VTBL_ENTRY _ZTI4ee31[];
extern  VTBL_ENTRY _ZTV4ee31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee31[];
extern Class_Descriptor cd_cc31;
extern VTBL_ENTRY _ZTI4cc31[];
extern  VTBL_ENTRY _ZTV4cc31[];
extern Class_Descriptor cd_dd31;
extern VTBL_ENTRY _ZTI4dd31[];
extern  VTBL_ENTRY _ZTV4dd31[];
extern Class_Descriptor cd_ff31;
extern VTBL_ENTRY _ZTI4ff31[];
extern  VTBL_ENTRY _ZTV4ff31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff31[];
static Base_Class bases_gg31[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa31,    ABISELECT(32,20), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_bb31,    ABISELECT(48,28), //bcp->offset
    18, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_ee31,    ABISELECT(16,12), //bcp->offset
    8, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_cc31,    ABISELECT(64,36), //bcp->offset
    22, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_dd31,    ABISELECT(80,44), //bcp->offset
    26, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_ff31,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4gg31[];
extern void _ZN4gg313fooEv();
extern void ABISELECT(_ZTv0_n40_N4gg313fooEv,_ZTv0_n20_N4gg313fooEv)();
extern void ABISELECT(_ZThn16_N4gg313fooEv,_ZThn12_N4gg313fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg313fooEv,_ZTv0_n12_N4gg313fooEv)();
extern void ABISELECT(_ZThn32_N4gg313fooEv,_ZThn20_N4gg313fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg313fooEv,_ZTv0_n12_N4gg313fooEv)();
extern void ABISELECT(_ZThn48_N4gg313fooEv,_ZThn28_N4gg313fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg313fooEv,_ZTv0_n12_N4gg313fooEv)();
extern void ABISELECT(_ZThn64_N4gg313fooEv,_ZThn36_N4gg313fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg313fooEv,_ZTv0_n12_N4gg313fooEv)();
extern void ABISELECT(_ZThn80_N4gg313fooEv,_ZThn44_N4gg313fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg31[] = {
  ABISELECT(48,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  ABISELECT(80,44),
  ABISELECT(64,36),
  0,
  (VTBL_ENTRY)&(_ZTI4gg31[0]),
  (VTBL_ENTRY)&_ZN4gg313fooEv,
  ABISELECT(-16,-12),
  ABISELECT(32,16),
  ABISELECT(16,8),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4gg31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N4gg313fooEv,_ZTv0_n20_N4gg313fooEv),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI4gg31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg313fooEv,_ZTv0_n12_N4gg313fooEv),
  ABISELECT(-48,-28),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI4gg31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg313fooEv,_ZTv0_n12_N4gg313fooEv),
  ABISELECT(-64,-36),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI4gg31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg313fooEv,_ZTv0_n12_N4gg313fooEv),
  ABISELECT(-80,-44),
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI4gg31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg313fooEv,_ZTv0_n12_N4gg313fooEv),
};
extern VTBL_ENTRY _ZTV4gg31[];
extern void _ZN4ff313fooEv();
static  VTBL_ENTRY _tg__ZTV4ff31__4gg31[] = {
  ABISELECT(80,44),
  ABISELECT(64,36),
  0,
  (VTBL_ENTRY)&(_ZTI4ff31[0]),
  (VTBL_ENTRY)&_ZN4ff313fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ff313fooEv,_ZTv0_n12_N4ff313fooEv)();
extern void ABISELECT(_ZThn64_N4ff313fooEv,_ZThn36_N4ff313fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4cc31__4ff31__4gg31[] = {
  ABISELECT(-64,-36),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI4ff31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff313fooEv,_ZTv0_n12_N4ff313fooEv),
};
extern void ABISELECT(_ZTv0_n24_N4ff313fooEv,_ZTv0_n12_N4ff313fooEv)();
extern void ABISELECT(_ZThn80_N4ff313fooEv,_ZThn44_N4ff313fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4dd31__4ff31__4gg31[] = {
  ABISELECT(-80,-44),
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI4ff31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff313fooEv,_ZTv0_n12_N4ff313fooEv),
};
extern void _ZN4ee313fooEv();
static  VTBL_ENTRY _tg__ZTV4ee31__4gg31[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI4ee31[0]),
  (VTBL_ENTRY)&_ZN4ee313fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ee313fooEv,_ZTv0_n12_N4ee313fooEv)();
extern void ABISELECT(_ZThn16_N4ee313fooEv,_ZThn8_N4ee313fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4aa31__4ee31__4gg31[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ee31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee313fooEv,_ZTv0_n12_N4ee313fooEv),
};
extern void ABISELECT(_ZTv0_n24_N4ee313fooEv,_ZTv0_n12_N4ee313fooEv)();
extern void ABISELECT(_ZThn32_N4ee313fooEv,_ZThn16_N4ee313fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb31__4ee31__4gg31[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI4ee31[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee313fooEv,_ZTv0_n12_N4ee313fooEv),
};
static  VTT_ENTRY vtt_gg31[] = {
  {&(_ZTV4gg31[7]),  7,30},
  {&(_tg__ZTV4ff31__4gg31[4]),  4,5},
  {&(_tg__ZTV4cc31__4ff31__4gg31[3]),  3,4},
  {&(_tg__ZTV4dd31__4ff31__4gg31[3]),  3,4},
  {&(_ZTV4gg31[13]),  13,30},
  {&(_ZTV4gg31[17]),  17,30},
  {&(_ZTV4gg31[21]),  21,30},
  {&(_ZTV4gg31[25]),  25,30},
  {&(_ZTV4gg31[29]),  29,30},
  {&(_tg__ZTV4ee31__4gg31[4]),  4,5},
  {&(_tg__ZTV4aa31__4ee31__4gg31[3]),  3,4},
  {&(_tg__ZTV4bb31__4ee31__4gg31[3]),  3,4},
};
extern VTBL_ENTRY _ZTI4gg31[];
extern  VTBL_ENTRY _ZTV4gg31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg31[];
static VTBL_ENTRY alt_thunk_names79[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee313fooEv,_ZTv0_n12_N4ee313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ee313fooEv,_ZThn16_N4ee313fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee313fooEv,_ZThn8_N4ee313fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff313fooEv,_ZTv0_n12_N4ff313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N4ff313fooEv,_ZThn44_N4ff313fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn64_N4ff313fooEv,_ZThn36_N4ff313fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg313fooEv,_ZTv0_n12_N4gg313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N4gg313fooEv,_ZThn44_N4gg313fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn64_N4gg313fooEv,_ZThn36_N4gg313fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N4gg313fooEv,_ZThn28_N4gg313fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4gg313fooEv,_ZThn20_N4gg313fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N4gg313fooEv,_ZTv0_n20_N4gg313fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4gg313fooEv,_ZThn12_N4gg313fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg31 = {  "gg31", // class name
  bases_gg31, 6,
  &(vtc_gg31[0]), // expected_vtbl_contents
  &(vtt_gg31[0]), // expected_vtt_contents
  ABISELECT(96,52), // object size
  NSPAIRA(_ZTI4gg31),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg31),30, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg31),12, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names79,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa32  {
  int a;
   aa32(); // _ZN4aa32C1Ev
  virtual void  foo(); // _ZN4aa323fooEv
  ~aa32(); // tgen
};
//SIG(-1 aa32) C1{ v1 Fi}


 aa32 ::aa32(){ note_ctor("aa32", this);}
void  aa32 ::foo(){vfunc_called(this, "_ZN4aa323fooEv");}
aa32 ::~aa32(){ note_dtor("aa32", this);} // tgen

static void Test_aa32()
{
  extern Class_Descriptor cd_aa32;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa32, buf);
    aa32 *dp, &lv = *(dp=new (buf) aa32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa32)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa32.a");
    test_class_info(&lv, &cd_aa32);
    dp->~aa32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa32(Test_aa32, "aa32", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa32C1Ev();
extern void _ZN4aa32D1Ev();
Name_Map name_map_aa32[] = {
  NSPAIR(_ZN4aa32C1Ev),
  NSPAIR(_ZN4aa32D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa32[];
extern void _ZN4aa323fooEv();
static  VTBL_ENTRY vtc_aa32[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa32[0]),
  (VTBL_ENTRY)&_ZN4aa323fooEv,
};
extern VTBL_ENTRY _ZTI4aa32[];
extern  VTBL_ENTRY _ZTV4aa32[];
Class_Descriptor cd_aa32 = {  "aa32", // class name
  0,0,//no base classes
  &(vtc_aa32[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa32),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa32),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb32  {
  int b;
   bb32(); // _ZN4bb32C1Ev
  virtual void  foo(); // _ZN4bb323fooEv
  ~bb32(); // tgen
};
//SIG(-1 bb32) C1{ v1 Fi}


 bb32 ::bb32(){ note_ctor("bb32", this);}
void  bb32 ::foo(){vfunc_called(this, "_ZN4bb323fooEv");}
bb32 ::~bb32(){ note_dtor("bb32", this);} // tgen

static void Test_bb32()
{
  extern Class_Descriptor cd_bb32;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb32, buf);
    bb32 *dp, &lv = *(dp=new (buf) bb32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb32)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb32.b");
    test_class_info(&lv, &cd_bb32);
    dp->~bb32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb32(Test_bb32, "bb32", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb32C1Ev();
extern void _ZN4bb32D1Ev();
Name_Map name_map_bb32[] = {
  NSPAIR(_ZN4bb32C1Ev),
  NSPAIR(_ZN4bb32D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb32[];
extern void _ZN4bb323fooEv();
static  VTBL_ENTRY vtc_bb32[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb32[0]),
  (VTBL_ENTRY)&_ZN4bb323fooEv,
};
extern VTBL_ENTRY _ZTI4bb32[];
extern  VTBL_ENTRY _ZTV4bb32[];
Class_Descriptor cd_bb32 = {  "bb32", // class name
  0,0,//no base classes
  &(vtc_bb32[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb32),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb32),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc32  {
  int c;
   cc32(); // _ZN4cc32C1Ev
  virtual void  foo(); // _ZN4cc323fooEv
  ~cc32(); // tgen
};
//SIG(-1 cc32) C1{ v1 Fi}


 cc32 ::cc32(){ note_ctor("cc32", this);}
void  cc32 ::foo(){vfunc_called(this, "_ZN4cc323fooEv");}
cc32 ::~cc32(){ note_dtor("cc32", this);} // tgen

static void Test_cc32()
{
  extern Class_Descriptor cd_cc32;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc32, buf);
    cc32 *dp, &lv = *(dp=new (buf) cc32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc32)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc32.c");
    test_class_info(&lv, &cd_cc32);
    dp->~cc32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc32(Test_cc32, "cc32", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc32C1Ev();
extern void _ZN4cc32D1Ev();
Name_Map name_map_cc32[] = {
  NSPAIR(_ZN4cc32C1Ev),
  NSPAIR(_ZN4cc32D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc32[];
extern void _ZN4cc323fooEv();
static  VTBL_ENTRY vtc_cc32[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc32[0]),
  (VTBL_ENTRY)&_ZN4cc323fooEv,
};
extern VTBL_ENTRY _ZTI4cc32[];
extern  VTBL_ENTRY _ZTV4cc32[];
Class_Descriptor cd_cc32 = {  "cc32", // class name
  0,0,//no base classes
  &(vtc_cc32[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc32),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc32),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd32  {
  int d;
   dd32(); // _ZN4dd32C1Ev
  virtual void  foo(); // _ZN4dd323fooEv
  ~dd32(); // tgen
};
//SIG(-1 dd32) C1{ v1 Fi}


 dd32 ::dd32(){ note_ctor("dd32", this);}
void  dd32 ::foo(){vfunc_called(this, "_ZN4dd323fooEv");}
dd32 ::~dd32(){ note_dtor("dd32", this);} // tgen

static void Test_dd32()
{
  extern Class_Descriptor cd_dd32;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd32, buf);
    dd32 *dp, &lv = *(dp=new (buf) dd32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd32)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd32.d");
    test_class_info(&lv, &cd_dd32);
    dp->~dd32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd32(Test_dd32, "dd32", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd32C1Ev();
extern void _ZN4dd32D1Ev();
Name_Map name_map_dd32[] = {
  NSPAIR(_ZN4dd32C1Ev),
  NSPAIR(_ZN4dd32D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd32[];
extern void _ZN4dd323fooEv();
static  VTBL_ENTRY vtc_dd32[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd32[0]),
  (VTBL_ENTRY)&_ZN4dd323fooEv,
};
extern VTBL_ENTRY _ZTI4dd32[];
extern  VTBL_ENTRY _ZTV4dd32[];
Class_Descriptor cd_dd32 = {  "dd32", // class name
  0,0,//no base classes
  &(vtc_dd32[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd32),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd32),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee32  : aa32 , bb32 {
  int e;
   ee32(); // _ZN4ee32C1Ev
  virtual void  foo(); // _ZN4ee323fooEv
  ~ee32(); // tgen
};
//SIG(-1 ee32) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ee32 ::ee32(){ note_ctor("ee32", this);}
void  ee32 ::foo(){vfunc_called(this, "_ZN4ee323fooEv");}
ee32 ::~ee32(){ note_dtor("ee32", this);} // tgen

static void Test_ee32()
{
  extern Class_Descriptor cd_ee32;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee32, buf);
    ee32 *dp, &lv = *(dp=new (buf) ee32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee32)");
    check_base_class_offset(lv, (aa32*), 0, "ee32");
    check_base_class_offset(lv, (bb32*), ABISELECT(16,8), "ee32");
    check_field_offset(lv, e, ABISELECT(28,16), "ee32.e");
    test_class_info(&lv, &cd_ee32);
    dp->~ee32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee32(Test_ee32, "ee32", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ee32C1Ev();
extern void _ZN4ee32D1Ev();
Name_Map name_map_ee32[] = {
  NSPAIR(_ZN4ee32C1Ev),
  NSPAIR(_ZN4ee32D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa32;
extern VTBL_ENTRY _ZTI4aa32[];
extern  VTBL_ENTRY _ZTV4aa32[];
extern Class_Descriptor cd_bb32;
extern VTBL_ENTRY _ZTI4bb32[];
extern  VTBL_ENTRY _ZTV4bb32[];
static Base_Class bases_ee32[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa32,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_bb32,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ee32[];
extern void _ZN4ee323fooEv();
extern void ABISELECT(_ZThn16_N4ee323fooEv,_ZThn8_N4ee323fooEv)();
static  VTBL_ENTRY vtc_ee32[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4ee32[0]),
  (VTBL_ENTRY)&_ZN4ee323fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ee32[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4ee323fooEv,_ZThn8_N4ee323fooEv),
};
extern VTBL_ENTRY _ZTI4ee32[];
extern  VTBL_ENTRY _ZTV4ee32[];
Class_Descriptor cd_ee32 = {  "ee32", // class name
  bases_ee32, 2,
  &(vtc_ee32[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ee32),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee32),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff32  : cc32 , dd32 {
  int f;
   ff32(); // _ZN4ff32C1Ev
  virtual void  foo(); // _ZN4ff323fooEv
  ~ff32(); // tgen
};
//SIG(-1 ff32) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ff32 ::ff32(){ note_ctor("ff32", this);}
void  ff32 ::foo(){vfunc_called(this, "_ZN4ff323fooEv");}
ff32 ::~ff32(){ note_dtor("ff32", this);} // tgen

static void Test_ff32()
{
  extern Class_Descriptor cd_ff32;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff32, buf);
    ff32 *dp, &lv = *(dp=new (buf) ff32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff32)");
    check_base_class_offset(lv, (cc32*), 0, "ff32");
    check_base_class_offset(lv, (dd32*), ABISELECT(16,8), "ff32");
    check_field_offset(lv, f, ABISELECT(28,16), "ff32.f");
    test_class_info(&lv, &cd_ff32);
    dp->~ff32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff32(Test_ff32, "ff32", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ff32C1Ev();
extern void _ZN4ff32D1Ev();
Name_Map name_map_ff32[] = {
  NSPAIR(_ZN4ff32C1Ev),
  NSPAIR(_ZN4ff32D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc32;
extern VTBL_ENTRY _ZTI4cc32[];
extern  VTBL_ENTRY _ZTV4cc32[];
extern Class_Descriptor cd_dd32;
extern VTBL_ENTRY _ZTI4dd32[];
extern  VTBL_ENTRY _ZTV4dd32[];
static Base_Class bases_ff32[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc32,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_dd32,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ff32[];
extern void _ZN4ff323fooEv();
extern void ABISELECT(_ZThn16_N4ff323fooEv,_ZThn8_N4ff323fooEv)();
static  VTBL_ENTRY vtc_ff32[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4ff32[0]),
  (VTBL_ENTRY)&_ZN4ff323fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ff32[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4ff323fooEv,_ZThn8_N4ff323fooEv),
};
extern VTBL_ENTRY _ZTI4ff32[];
extern  VTBL_ENTRY _ZTV4ff32[];
Class_Descriptor cd_ff32 = {  "ff32", // class name
  bases_ff32, 2,
  &(vtc_ff32[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ff32),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff32),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg32  : ee32 , virtual ff32 {
  int g;
   gg32(const ABISELECT(__tsi64,int) *const *); // _ZN4gg32C2Ev
  virtual void  foo(); // _ZN4gg323fooEv
  ~gg32(); // tgen
  gg32(); // tgen
};
//SIG(1 gg32) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} VBC5{ BC6{ v1 Fi} BC7{ v1 Fi} v1 Fi} v1 Fi}


 gg32 ::gg32(const ABISELECT(__tsi64,int) *const *){}
void  gg32 ::foo(){vfunc_called(this, "_ZN4gg323fooEv");}
gg32 ::~gg32(){ note_dtor("gg32", this);} // tgen
gg32 ::gg32(){ note_ctor("gg32", this);} // tgen

static void Test_gg32()
{
  extern Class_Descriptor cd_gg32;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg32, buf);
    gg32 *dp, &lv = *(dp=new (buf) gg32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg32)");
    check_base_class_offset(lv, (aa32*)(ee32*), 0, "gg32");
    check_base_class_offset(lv, (bb32*)(ee32*), ABISELECT(16,8), "gg32");
    check_base_class_offset(lv, (ee32*), 0, "gg32");
    check_base_class_offset(lv, (cc32*)(ff32*), ABISELECT(40,24), "gg32");
    check_base_class_offset(lv, (dd32*)(ff32*), ABISELECT(56,32), "gg32");
    check_base_class_offset(lv, (ff32*), ABISELECT(40,24), "gg32");
    check_field_offset(lv, g, ABISELECT(32,20), "gg32.g");
    test_class_info(&lv, &cd_gg32);
    dp->~gg32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg32(Test_gg32, "gg32", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN4gg32C1Ev();
extern void _ZN4gg32D1Ev();
Name_Map name_map_gg32[] = {
  NSPAIR(_ZN4gg32C1Ev),
  NSPAIR(_ZN4gg32D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa32;
extern VTBL_ENTRY _ZTI4aa32[];
extern  VTBL_ENTRY _ZTV4aa32[];
extern Class_Descriptor cd_bb32;
extern VTBL_ENTRY _ZTI4bb32[];
extern  VTBL_ENTRY _ZTV4bb32[];
extern Class_Descriptor cd_ee32;
extern VTBL_ENTRY _ZTI4ee32[];
extern  VTBL_ENTRY _ZTV4ee32[];
extern Class_Descriptor cd_cc32;
extern VTBL_ENTRY _ZTI4cc32[];
extern  VTBL_ENTRY _ZTV4cc32[];
extern Class_Descriptor cd_dd32;
extern VTBL_ENTRY _ZTI4dd32[];
extern  VTBL_ENTRY _ZTV4dd32[];
extern Class_Descriptor cd_ff32;
extern VTBL_ENTRY _ZTI4ff32[];
extern  VTBL_ENTRY _ZTV4ff32[];
static Base_Class bases_gg32[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa32,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_bb32,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_ee32,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc32,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_dd32,    ABISELECT(56,32), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_ff32,    ABISELECT(40,24), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4gg32[];
extern void _ZN4gg323fooEv();
extern void ABISELECT(_ZThn16_N4gg323fooEv,_ZThn8_N4gg323fooEv)();
extern void ABISELECT(_ZTv0_n24_N4gg323fooEv,_ZTv0_n12_N4gg323fooEv)();
extern void ABISELECT(_ZThn40_N4gg323fooEv,_ZThn24_N4gg323fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n24_N4gg323fooEv,_ZTvn8_n12_N4gg323fooEv)();
static  VTBL_ENTRY vtc_gg32[] = {
  ABISELECT(40,24),
  0,
  (VTBL_ENTRY)&(_ZTI4gg32[0]),
  (VTBL_ENTRY)&_ZN4gg323fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4gg32[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4gg323fooEv,_ZThn8_N4gg323fooEv),
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI4gg32[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg323fooEv,_ZTv0_n12_N4gg323fooEv),
  ABISELECT(-56,-32),
  (VTBL_ENTRY)&(_ZTI4gg32[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N4gg323fooEv,_ZTvn8_n12_N4gg323fooEv),
};
extern VTBL_ENTRY _ZTV4gg32[];
static  VTT_ENTRY vtt_gg32[] = {
  {&(_ZTV4gg32[3]),  3,14},
  {&(_ZTV4gg32[10]),  10,14},
  {&(_ZTV4gg32[13]),  13,14},
};
extern VTBL_ENTRY _ZTI4gg32[];
extern  VTBL_ENTRY _ZTV4gg32[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg32[];
static VTBL_ENTRY alt_thunk_names80[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg323fooEv,_ZTv0_n12_N4gg323fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N4gg323fooEv,_ZThn24_N4gg323fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg32 = {  "gg32", // class name
  bases_gg32, 6,
  &(vtc_gg32[0]), // expected_vtbl_contents
  &(vtt_gg32[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI4gg32),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg32),14, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg32),3, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names80,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa33  {
  int a;
   aa33(); // _ZN4aa33C1Ev
  virtual void  foo(); // _ZN4aa333fooEv
  ~aa33(); // tgen
};
//SIG(-1 aa33) C1{ v1 Fi}


 aa33 ::aa33(){ note_ctor("aa33", this);}
void  aa33 ::foo(){vfunc_called(this, "_ZN4aa333fooEv");}
aa33 ::~aa33(){ note_dtor("aa33", this);} // tgen

static void Test_aa33()
{
  extern Class_Descriptor cd_aa33;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa33, buf);
    aa33 *dp, &lv = *(dp=new (buf) aa33());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa33)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa33.a");
    test_class_info(&lv, &cd_aa33);
    dp->~aa33();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa33(Test_aa33, "aa33", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa33C1Ev();
extern void _ZN4aa33D1Ev();
Name_Map name_map_aa33[] = {
  NSPAIR(_ZN4aa33C1Ev),
  NSPAIR(_ZN4aa33D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa33[];
extern void _ZN4aa333fooEv();
static  VTBL_ENTRY vtc_aa33[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa33[0]),
  (VTBL_ENTRY)&_ZN4aa333fooEv,
};
extern VTBL_ENTRY _ZTI4aa33[];
extern  VTBL_ENTRY _ZTV4aa33[];
Class_Descriptor cd_aa33 = {  "aa33", // class name
  0,0,//no base classes
  &(vtc_aa33[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa33),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa33),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb33  {
  int b;
   bb33(); // _ZN4bb33C1Ev
  virtual void  foo(); // _ZN4bb333fooEv
  ~bb33(); // tgen
};
//SIG(-1 bb33) C1{ v1 Fi}


 bb33 ::bb33(){ note_ctor("bb33", this);}
void  bb33 ::foo(){vfunc_called(this, "_ZN4bb333fooEv");}
bb33 ::~bb33(){ note_dtor("bb33", this);} // tgen

static void Test_bb33()
{
  extern Class_Descriptor cd_bb33;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb33, buf);
    bb33 *dp, &lv = *(dp=new (buf) bb33());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb33)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb33.b");
    test_class_info(&lv, &cd_bb33);
    dp->~bb33();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb33(Test_bb33, "bb33", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb33C1Ev();
extern void _ZN4bb33D1Ev();
Name_Map name_map_bb33[] = {
  NSPAIR(_ZN4bb33C1Ev),
  NSPAIR(_ZN4bb33D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb33[];
extern void _ZN4bb333fooEv();
static  VTBL_ENTRY vtc_bb33[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb33[0]),
  (VTBL_ENTRY)&_ZN4bb333fooEv,
};
extern VTBL_ENTRY _ZTI4bb33[];
extern  VTBL_ENTRY _ZTV4bb33[];
Class_Descriptor cd_bb33 = {  "bb33", // class name
  0,0,//no base classes
  &(vtc_bb33[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb33),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb33),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc33  {
  int c;
   cc33(); // _ZN4cc33C1Ev
  virtual void  foo(); // _ZN4cc333fooEv
  ~cc33(); // tgen
};
//SIG(-1 cc33) C1{ v1 Fi}


 cc33 ::cc33(){ note_ctor("cc33", this);}
void  cc33 ::foo(){vfunc_called(this, "_ZN4cc333fooEv");}
cc33 ::~cc33(){ note_dtor("cc33", this);} // tgen

static void Test_cc33()
{
  extern Class_Descriptor cd_cc33;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc33, buf);
    cc33 *dp, &lv = *(dp=new (buf) cc33());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc33)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc33.c");
    test_class_info(&lv, &cd_cc33);
    dp->~cc33();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc33(Test_cc33, "cc33", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc33C1Ev();
extern void _ZN4cc33D1Ev();
Name_Map name_map_cc33[] = {
  NSPAIR(_ZN4cc33C1Ev),
  NSPAIR(_ZN4cc33D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc33[];
extern void _ZN4cc333fooEv();
static  VTBL_ENTRY vtc_cc33[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc33[0]),
  (VTBL_ENTRY)&_ZN4cc333fooEv,
};
extern VTBL_ENTRY _ZTI4cc33[];
extern  VTBL_ENTRY _ZTV4cc33[];
Class_Descriptor cd_cc33 = {  "cc33", // class name
  0,0,//no base classes
  &(vtc_cc33[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc33),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc33),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd33  {
  int d;
   dd33(); // _ZN4dd33C1Ev
  virtual void  foo(); // _ZN4dd333fooEv
  ~dd33(); // tgen
};
//SIG(-1 dd33) C1{ v1 Fi}


 dd33 ::dd33(){ note_ctor("dd33", this);}
void  dd33 ::foo(){vfunc_called(this, "_ZN4dd333fooEv");}
dd33 ::~dd33(){ note_dtor("dd33", this);} // tgen

static void Test_dd33()
{
  extern Class_Descriptor cd_dd33;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd33, buf);
    dd33 *dp, &lv = *(dp=new (buf) dd33());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd33)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd33.d");
    test_class_info(&lv, &cd_dd33);
    dp->~dd33();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd33(Test_dd33, "dd33", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd33C1Ev();
extern void _ZN4dd33D1Ev();
Name_Map name_map_dd33[] = {
  NSPAIR(_ZN4dd33C1Ev),
  NSPAIR(_ZN4dd33D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd33[];
extern void _ZN4dd333fooEv();
static  VTBL_ENTRY vtc_dd33[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd33[0]),
  (VTBL_ENTRY)&_ZN4dd333fooEv,
};
extern VTBL_ENTRY _ZTI4dd33[];
extern  VTBL_ENTRY _ZTV4dd33[];
Class_Descriptor cd_dd33 = {  "dd33", // class name
  0,0,//no base classes
  &(vtc_dd33[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd33),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd33),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee33  : virtual aa33 , bb33 {
  int e;
   ee33(const ABISELECT(__tsi64,int) *const *); // _ZN4ee33C2Ev
  virtual void  foo(); // _ZN4ee333fooEv
  ~ee33(); // tgen
  ee33(); // tgen
};
//SIG(-1 ee33) C1{ VBC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ee33 ::ee33(const ABISELECT(__tsi64,int) *const *){}
void  ee33 ::foo(){vfunc_called(this, "_ZN4ee333fooEv");}
ee33 ::~ee33(){ note_dtor("ee33", this);} // tgen
ee33 ::ee33(){ note_ctor("ee33", this);} // tgen

static void Test_ee33()
{
  extern Class_Descriptor cd_ee33;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee33, buf);
    ee33 *dp, &lv = *(dp=new (buf) ee33());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee33)");
    check_base_class_offset(lv, (aa33*), ABISELECT(16,12), "ee33");
    check_base_class_offset(lv, (bb33*), 0, "ee33");
    check_field_offset(lv, e, ABISELECT(12,8), "ee33.e");
    test_class_info(&lv, &cd_ee33);
    dp->~ee33();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee33(Test_ee33, "ee33", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ee33C1Ev();
extern void _ZN4ee33D1Ev();
Name_Map name_map_ee33[] = {
  NSPAIR(_ZN4ee33C1Ev),
  NSPAIR(_ZN4ee33D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa33;
extern VTBL_ENTRY _ZTI4aa33[];
extern  VTBL_ENTRY _ZTV4aa33[];
extern Class_Descriptor cd_bb33;
extern VTBL_ENTRY _ZTI4bb33[];
extern  VTBL_ENTRY _ZTV4bb33[];
static Base_Class bases_ee33[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa33,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_bb33,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ee33[];
extern void _ZN4ee333fooEv();
extern void ABISELECT(_ZTv0_n24_N4ee333fooEv,_ZTv0_n12_N4ee333fooEv)();
extern void ABISELECT(_ZThn16_N4ee333fooEv,_ZThn12_N4ee333fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee33[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee33[0]),
  (VTBL_ENTRY)&_ZN4ee333fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee33[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee333fooEv,_ZTv0_n12_N4ee333fooEv),
};
extern VTBL_ENTRY _ZTV4ee33[];
static  VTT_ENTRY vtt_ee33[] = {
  {&(_ZTV4ee33[3]),  3,8},
  {&(_ZTV4ee33[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ee33[];
extern  VTBL_ENTRY _ZTV4ee33[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee33[];
static VTBL_ENTRY alt_thunk_names81[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee333fooEv,_ZTv0_n12_N4ee333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee333fooEv,_ZThn12_N4ee333fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee33 = {  "ee33", // class name
  bases_ee33, 2,
  &(vtc_ee33[0]), // expected_vtbl_contents
  &(vtt_ee33[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ee33),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee33),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ee33),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names81,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff33  : cc33 , dd33 {
  int f;
   ff33(); // _ZN4ff33C1Ev
  virtual void  foo(); // _ZN4ff333fooEv
  ~ff33(); // tgen
};
//SIG(-1 ff33) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ff33 ::ff33(){ note_ctor("ff33", this);}
void  ff33 ::foo(){vfunc_called(this, "_ZN4ff333fooEv");}
ff33 ::~ff33(){ note_dtor("ff33", this);} // tgen

static void Test_ff33()
{
  extern Class_Descriptor cd_ff33;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff33, buf);
    ff33 *dp, &lv = *(dp=new (buf) ff33());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff33)");
    check_base_class_offset(lv, (cc33*), 0, "ff33");
    check_base_class_offset(lv, (dd33*), ABISELECT(16,8), "ff33");
    check_field_offset(lv, f, ABISELECT(28,16), "ff33.f");
    test_class_info(&lv, &cd_ff33);
    dp->~ff33();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff33(Test_ff33, "ff33", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ff33C1Ev();
extern void _ZN4ff33D1Ev();
Name_Map name_map_ff33[] = {
  NSPAIR(_ZN4ff33C1Ev),
  NSPAIR(_ZN4ff33D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc33;
extern VTBL_ENTRY _ZTI4cc33[];
extern  VTBL_ENTRY _ZTV4cc33[];
extern Class_Descriptor cd_dd33;
extern VTBL_ENTRY _ZTI4dd33[];
extern  VTBL_ENTRY _ZTV4dd33[];
static Base_Class bases_ff33[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc33,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_dd33,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ff33[];
extern void _ZN4ff333fooEv();
extern void ABISELECT(_ZThn16_N4ff333fooEv,_ZThn8_N4ff333fooEv)();
static  VTBL_ENTRY vtc_ff33[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4ff33[0]),
  (VTBL_ENTRY)&_ZN4ff333fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ff33[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4ff333fooEv,_ZThn8_N4ff333fooEv),
};
extern VTBL_ENTRY _ZTI4ff33[];
extern  VTBL_ENTRY _ZTV4ff33[];
Class_Descriptor cd_ff33 = {  "ff33", // class name
  bases_ff33, 2,
  &(vtc_ff33[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ff33),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff33),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg33  : ee33 , virtual ff33 {
  int g;
   gg33(const ABISELECT(__tsi64,int) *const *); // _ZN4gg33C2Ev
  virtual void  foo(); // _ZN4gg333fooEv
  ~gg33(); // tgen
  gg33(); // tgen
};
//SIG(1 gg33) C1{ BC2{ VBC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} VBC5{ BC6{ v1 Fi} BC7{ v1 Fi} v1 Fi} v1 Fi}


 gg33 ::gg33(const ABISELECT(__tsi64,int) *const *){}
void  gg33 ::foo(){vfunc_called(this, "_ZN4gg333fooEv");}
gg33 ::~gg33(){ note_dtor("gg33", this);} // tgen
gg33 ::gg33(){ note_ctor("gg33", this);} // tgen

static void Test_gg33()
{
  extern Class_Descriptor cd_gg33;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg33, buf);
    gg33 *dp, &lv = *(dp=new (buf) gg33());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg33)");
    check_base_class_offset(lv, (aa33*)(ee33*), ABISELECT(24,16), "gg33");
    check_base_class_offset(lv, (bb33*)(ee33*), 0, "gg33");
    check_base_class_offset(lv, (ee33*), 0, "gg33");
    check_base_class_offset(lv, (cc33*)(ff33*), ABISELECT(40,24), "gg33");
    check_base_class_offset(lv, (dd33*)(ff33*), ABISELECT(56,32), "gg33");
    check_base_class_offset(lv, (ff33*), ABISELECT(40,24), "gg33");
    check_field_offset(lv, g, ABISELECT(16,12), "gg33.g");
    test_class_info(&lv, &cd_gg33);
    dp->~gg33();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg33(Test_gg33, "gg33", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN4gg33C1Ev();
extern void _ZN4gg33D1Ev();
Name_Map name_map_gg33[] = {
  NSPAIR(_ZN4gg33C1Ev),
  NSPAIR(_ZN4gg33D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa33;
extern VTBL_ENTRY _ZTI4aa33[];
extern  VTBL_ENTRY _ZTV4aa33[];
extern Class_Descriptor cd_bb33;
extern VTBL_ENTRY _ZTI4bb33[];
extern  VTBL_ENTRY _ZTV4bb33[];
extern Class_Descriptor cd_ee33;
extern VTBL_ENTRY _ZTI4ee33[];
extern  VTBL_ENTRY _ZTV4ee33[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee33[];
extern Class_Descriptor cd_cc33;
extern VTBL_ENTRY _ZTI4cc33[];
extern  VTBL_ENTRY _ZTV4cc33[];
extern Class_Descriptor cd_dd33;
extern VTBL_ENTRY _ZTI4dd33[];
extern  VTBL_ENTRY _ZTV4dd33[];
extern Class_Descriptor cd_ff33;
extern VTBL_ENTRY _ZTI4ff33[];
extern  VTBL_ENTRY _ZTV4ff33[];
static Base_Class bases_gg33[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa33,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_bb33,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_ee33,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc33,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_dd33,    ABISELECT(56,32), //bcp->offset
    13, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_ff33,    ABISELECT(40,24), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4gg33[];
extern void _ZN4gg333fooEv();
extern void ABISELECT(_ZTv0_n24_N4gg333fooEv,_ZTv0_n12_N4gg333fooEv)();
extern void ABISELECT(_ZThn24_N4gg333fooEv,_ZThn16_N4gg333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg333fooEv,_ZTv0_n12_N4gg333fooEv)();
extern void ABISELECT(_ZThn40_N4gg333fooEv,_ZThn24_N4gg333fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n24_N4gg333fooEv,_ZTvn8_n12_N4gg333fooEv)();
static  VTBL_ENTRY vtc_gg33[] = {
  ABISELECT(40,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI4gg33[0]),
  (VTBL_ENTRY)&_ZN4gg333fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI4gg33[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg333fooEv,_ZTv0_n12_N4gg333fooEv),
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI4gg33[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg333fooEv,_ZTv0_n12_N4gg333fooEv),
  ABISELECT(-56,-32),
  (VTBL_ENTRY)&(_ZTI4gg33[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N4gg333fooEv,_ZTvn8_n12_N4gg333fooEv),
};
extern VTBL_ENTRY _ZTV4gg33[];
extern void _ZN4ee333fooEv();
static  VTBL_ENTRY _tg__ZTV4ee33__4gg33[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI4ee33[0]),
  (VTBL_ENTRY)&_ZN4ee333fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ee333fooEv,_ZTv0_n12_N4ee333fooEv)();
extern void ABISELECT(_ZThn24_N4ee333fooEv,_ZThn16_N4ee333fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4aa33__4ee33__4gg33[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI4ee33[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee333fooEv,_ZTv0_n12_N4ee333fooEv),
};
static  VTT_ENTRY vtt_gg33[] = {
  {&(_ZTV4gg33[4]),  4,16},
  {&(_tg__ZTV4ee33__4gg33[3]),  3,4},
  {&(_tg__ZTV4aa33__4ee33__4gg33[3]),  3,4},
  {&(_ZTV4gg33[8]),  8,16},
  {&(_ZTV4gg33[12]),  12,16},
  {&(_ZTV4gg33[15]),  15,16},
};
extern VTBL_ENTRY _ZTI4gg33[];
extern  VTBL_ENTRY _ZTV4gg33[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg33[];
static VTBL_ENTRY alt_thunk_names82[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee333fooEv,_ZTv0_n12_N4ee333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N4ee333fooEv,_ZThn16_N4ee333fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg333fooEv,_ZTv0_n12_N4gg333fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N4gg333fooEv,_ZThn24_N4gg333fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N4gg333fooEv,_ZThn16_N4gg333fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg33 = {  "gg33", // class name
  bases_gg33, 6,
  &(vtc_gg33[0]), // expected_vtbl_contents
  &(vtt_gg33[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI4gg33),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg33),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg33),6, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names82,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa34  {
  int a;
   aa34(); // _ZN4aa34C1Ev
  virtual void  foo(); // _ZN4aa343fooEv
  ~aa34(); // tgen
};
//SIG(-1 aa34) C1{ v1 Fi}


 aa34 ::aa34(){ note_ctor("aa34", this);}
void  aa34 ::foo(){vfunc_called(this, "_ZN4aa343fooEv");}
aa34 ::~aa34(){ note_dtor("aa34", this);} // tgen

static void Test_aa34()
{
  extern Class_Descriptor cd_aa34;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa34, buf);
    aa34 *dp, &lv = *(dp=new (buf) aa34());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa34)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa34.a");
    test_class_info(&lv, &cd_aa34);
    dp->~aa34();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa34(Test_aa34, "aa34", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa34C1Ev();
extern void _ZN4aa34D1Ev();
Name_Map name_map_aa34[] = {
  NSPAIR(_ZN4aa34C1Ev),
  NSPAIR(_ZN4aa34D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa34[];
extern void _ZN4aa343fooEv();
static  VTBL_ENTRY vtc_aa34[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa34[0]),
  (VTBL_ENTRY)&_ZN4aa343fooEv,
};
extern VTBL_ENTRY _ZTI4aa34[];
extern  VTBL_ENTRY _ZTV4aa34[];
Class_Descriptor cd_aa34 = {  "aa34", // class name
  0,0,//no base classes
  &(vtc_aa34[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa34),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa34),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb34  {
  int b;
   bb34(); // _ZN4bb34C1Ev
  virtual void  foo(); // _ZN4bb343fooEv
  ~bb34(); // tgen
};
//SIG(-1 bb34) C1{ v1 Fi}


 bb34 ::bb34(){ note_ctor("bb34", this);}
void  bb34 ::foo(){vfunc_called(this, "_ZN4bb343fooEv");}
bb34 ::~bb34(){ note_dtor("bb34", this);} // tgen

static void Test_bb34()
{
  extern Class_Descriptor cd_bb34;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb34, buf);
    bb34 *dp, &lv = *(dp=new (buf) bb34());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb34)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb34.b");
    test_class_info(&lv, &cd_bb34);
    dp->~bb34();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb34(Test_bb34, "bb34", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb34C1Ev();
extern void _ZN4bb34D1Ev();
Name_Map name_map_bb34[] = {
  NSPAIR(_ZN4bb34C1Ev),
  NSPAIR(_ZN4bb34D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb34[];
extern void _ZN4bb343fooEv();
static  VTBL_ENTRY vtc_bb34[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb34[0]),
  (VTBL_ENTRY)&_ZN4bb343fooEv,
};
extern VTBL_ENTRY _ZTI4bb34[];
extern  VTBL_ENTRY _ZTV4bb34[];
Class_Descriptor cd_bb34 = {  "bb34", // class name
  0,0,//no base classes
  &(vtc_bb34[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb34),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb34),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc34  {
  int c;
   cc34(); // _ZN4cc34C1Ev
  virtual void  foo(); // _ZN4cc343fooEv
  ~cc34(); // tgen
};
//SIG(-1 cc34) C1{ v1 Fi}


 cc34 ::cc34(){ note_ctor("cc34", this);}
void  cc34 ::foo(){vfunc_called(this, "_ZN4cc343fooEv");}
cc34 ::~cc34(){ note_dtor("cc34", this);} // tgen

static void Test_cc34()
{
  extern Class_Descriptor cd_cc34;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc34, buf);
    cc34 *dp, &lv = *(dp=new (buf) cc34());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc34)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc34.c");
    test_class_info(&lv, &cd_cc34);
    dp->~cc34();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc34(Test_cc34, "cc34", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc34C1Ev();
extern void _ZN4cc34D1Ev();
Name_Map name_map_cc34[] = {
  NSPAIR(_ZN4cc34C1Ev),
  NSPAIR(_ZN4cc34D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc34[];
extern void _ZN4cc343fooEv();
static  VTBL_ENTRY vtc_cc34[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc34[0]),
  (VTBL_ENTRY)&_ZN4cc343fooEv,
};
extern VTBL_ENTRY _ZTI4cc34[];
extern  VTBL_ENTRY _ZTV4cc34[];
Class_Descriptor cd_cc34 = {  "cc34", // class name
  0,0,//no base classes
  &(vtc_cc34[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc34),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc34),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd34  {
  int d;
   dd34(); // _ZN4dd34C1Ev
  virtual void  foo(); // _ZN4dd343fooEv
  ~dd34(); // tgen
};
//SIG(-1 dd34) C1{ v1 Fi}


 dd34 ::dd34(){ note_ctor("dd34", this);}
void  dd34 ::foo(){vfunc_called(this, "_ZN4dd343fooEv");}
dd34 ::~dd34(){ note_dtor("dd34", this);} // tgen

static void Test_dd34()
{
  extern Class_Descriptor cd_dd34;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd34, buf);
    dd34 *dp, &lv = *(dp=new (buf) dd34());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd34)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd34.d");
    test_class_info(&lv, &cd_dd34);
    dp->~dd34();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd34(Test_dd34, "dd34", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd34C1Ev();
extern void _ZN4dd34D1Ev();
Name_Map name_map_dd34[] = {
  NSPAIR(_ZN4dd34C1Ev),
  NSPAIR(_ZN4dd34D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd34[];
extern void _ZN4dd343fooEv();
static  VTBL_ENTRY vtc_dd34[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd34[0]),
  (VTBL_ENTRY)&_ZN4dd343fooEv,
};
extern VTBL_ENTRY _ZTI4dd34[];
extern  VTBL_ENTRY _ZTV4dd34[];
Class_Descriptor cd_dd34 = {  "dd34", // class name
  0,0,//no base classes
  &(vtc_dd34[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd34),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd34),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee34  : aa34 , virtual bb34 {
  int e;
   ee34(const ABISELECT(__tsi64,int) *const *); // _ZN4ee34C2Ev
  virtual void  foo(); // _ZN4ee343fooEv
  ~ee34(); // tgen
  ee34(); // tgen
};
//SIG(-1 ee34) C1{ BC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ee34 ::ee34(const ABISELECT(__tsi64,int) *const *){}
void  ee34 ::foo(){vfunc_called(this, "_ZN4ee343fooEv");}
ee34 ::~ee34(){ note_dtor("ee34", this);} // tgen
ee34 ::ee34(){ note_ctor("ee34", this);} // tgen

static void Test_ee34()
{
  extern Class_Descriptor cd_ee34;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee34, buf);
    ee34 *dp, &lv = *(dp=new (buf) ee34());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee34)");
    check_base_class_offset(lv, (aa34*), 0, "ee34");
    check_base_class_offset(lv, (bb34*), ABISELECT(16,12), "ee34");
    check_field_offset(lv, e, ABISELECT(12,8), "ee34.e");
    test_class_info(&lv, &cd_ee34);
    dp->~ee34();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee34(Test_ee34, "ee34", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ee34C1Ev();
extern void _ZN4ee34D1Ev();
Name_Map name_map_ee34[] = {
  NSPAIR(_ZN4ee34C1Ev),
  NSPAIR(_ZN4ee34D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa34;
extern VTBL_ENTRY _ZTI4aa34[];
extern  VTBL_ENTRY _ZTV4aa34[];
extern Class_Descriptor cd_bb34;
extern VTBL_ENTRY _ZTI4bb34[];
extern  VTBL_ENTRY _ZTV4bb34[];
static Base_Class bases_ee34[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa34,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_bb34,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ee34[];
extern void _ZN4ee343fooEv();
extern void ABISELECT(_ZTv0_n24_N4ee343fooEv,_ZTv0_n12_N4ee343fooEv)();
extern void ABISELECT(_ZThn16_N4ee343fooEv,_ZThn12_N4ee343fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee34[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee34[0]),
  (VTBL_ENTRY)&_ZN4ee343fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee34[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee343fooEv,_ZTv0_n12_N4ee343fooEv),
};
extern VTBL_ENTRY _ZTV4ee34[];
static  VTT_ENTRY vtt_ee34[] = {
  {&(_ZTV4ee34[3]),  3,8},
  {&(_ZTV4ee34[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ee34[];
extern  VTBL_ENTRY _ZTV4ee34[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee34[];
static VTBL_ENTRY alt_thunk_names83[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee343fooEv,_ZTv0_n12_N4ee343fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee343fooEv,_ZThn12_N4ee343fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee34 = {  "ee34", // class name
  bases_ee34, 2,
  &(vtc_ee34[0]), // expected_vtbl_contents
  &(vtt_ee34[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ee34),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee34),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ee34),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names83,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff34  : cc34 , dd34 {
  int f;
   ff34(); // _ZN4ff34C1Ev
  virtual void  foo(); // _ZN4ff343fooEv
  ~ff34(); // tgen
};
//SIG(-1 ff34) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ff34 ::ff34(){ note_ctor("ff34", this);}
void  ff34 ::foo(){vfunc_called(this, "_ZN4ff343fooEv");}
ff34 ::~ff34(){ note_dtor("ff34", this);} // tgen

static void Test_ff34()
{
  extern Class_Descriptor cd_ff34;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff34, buf);
    ff34 *dp, &lv = *(dp=new (buf) ff34());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff34)");
    check_base_class_offset(lv, (cc34*), 0, "ff34");
    check_base_class_offset(lv, (dd34*), ABISELECT(16,8), "ff34");
    check_field_offset(lv, f, ABISELECT(28,16), "ff34.f");
    test_class_info(&lv, &cd_ff34);
    dp->~ff34();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff34(Test_ff34, "ff34", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ff34C1Ev();
extern void _ZN4ff34D1Ev();
Name_Map name_map_ff34[] = {
  NSPAIR(_ZN4ff34C1Ev),
  NSPAIR(_ZN4ff34D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc34;
extern VTBL_ENTRY _ZTI4cc34[];
extern  VTBL_ENTRY _ZTV4cc34[];
extern Class_Descriptor cd_dd34;
extern VTBL_ENTRY _ZTI4dd34[];
extern  VTBL_ENTRY _ZTV4dd34[];
static Base_Class bases_ff34[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc34,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_dd34,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ff34[];
extern void _ZN4ff343fooEv();
extern void ABISELECT(_ZThn16_N4ff343fooEv,_ZThn8_N4ff343fooEv)();
static  VTBL_ENTRY vtc_ff34[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4ff34[0]),
  (VTBL_ENTRY)&_ZN4ff343fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ff34[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4ff343fooEv,_ZThn8_N4ff343fooEv),
};
extern VTBL_ENTRY _ZTI4ff34[];
extern  VTBL_ENTRY _ZTV4ff34[];
Class_Descriptor cd_ff34 = {  "ff34", // class name
  bases_ff34, 2,
  &(vtc_ff34[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ff34),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff34),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg34  : ee34 , virtual ff34 {
  int g;
   gg34(const ABISELECT(__tsi64,int) *const *); // _ZN4gg34C2Ev
  virtual void  foo(); // _ZN4gg343fooEv
  ~gg34(); // tgen
  gg34(); // tgen
};
//SIG(1 gg34) C1{ BC2{ BC3{ v1 Fi} VBC4{ v1 Fi} v1 Fi} VBC5{ BC6{ v1 Fi} BC7{ v1 Fi} v1 Fi} v1 Fi}


 gg34 ::gg34(const ABISELECT(__tsi64,int) *const *){}
void  gg34 ::foo(){vfunc_called(this, "_ZN4gg343fooEv");}
gg34 ::~gg34(){ note_dtor("gg34", this);} // tgen
gg34 ::gg34(){ note_ctor("gg34", this);} // tgen

static void Test_gg34()
{
  extern Class_Descriptor cd_gg34;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg34, buf);
    gg34 *dp, &lv = *(dp=new (buf) gg34());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg34)");
    check_base_class_offset(lv, (aa34*)(ee34*), 0, "gg34");
    check_base_class_offset(lv, (bb34*)(ee34*), ABISELECT(24,16), "gg34");
    check_base_class_offset(lv, (ee34*), 0, "gg34");
    check_base_class_offset(lv, (cc34*)(ff34*), ABISELECT(40,24), "gg34");
    check_base_class_offset(lv, (dd34*)(ff34*), ABISELECT(56,32), "gg34");
    check_base_class_offset(lv, (ff34*), ABISELECT(40,24), "gg34");
    check_field_offset(lv, g, ABISELECT(16,12), "gg34.g");
    test_class_info(&lv, &cd_gg34);
    dp->~gg34();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg34(Test_gg34, "gg34", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN4gg34C1Ev();
extern void _ZN4gg34D1Ev();
Name_Map name_map_gg34[] = {
  NSPAIR(_ZN4gg34C1Ev),
  NSPAIR(_ZN4gg34D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa34;
extern VTBL_ENTRY _ZTI4aa34[];
extern  VTBL_ENTRY _ZTV4aa34[];
extern Class_Descriptor cd_bb34;
extern VTBL_ENTRY _ZTI4bb34[];
extern  VTBL_ENTRY _ZTV4bb34[];
extern Class_Descriptor cd_ee34;
extern VTBL_ENTRY _ZTI4ee34[];
extern  VTBL_ENTRY _ZTV4ee34[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee34[];
extern Class_Descriptor cd_cc34;
extern VTBL_ENTRY _ZTI4cc34[];
extern  VTBL_ENTRY _ZTV4cc34[];
extern Class_Descriptor cd_dd34;
extern VTBL_ENTRY _ZTI4dd34[];
extern  VTBL_ENTRY _ZTV4dd34[];
extern Class_Descriptor cd_ff34;
extern VTBL_ENTRY _ZTI4ff34[];
extern  VTBL_ENTRY _ZTV4ff34[];
static Base_Class bases_gg34[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa34,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_bb34,    ABISELECT(24,16), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_ee34,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc34,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_dd34,    ABISELECT(56,32), //bcp->offset
    13, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_ff34,    ABISELECT(40,24), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4gg34[];
extern void _ZN4gg343fooEv();
extern void ABISELECT(_ZTv0_n24_N4gg343fooEv,_ZTv0_n12_N4gg343fooEv)();
extern void ABISELECT(_ZThn24_N4gg343fooEv,_ZThn16_N4gg343fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg343fooEv,_ZTv0_n12_N4gg343fooEv)();
extern void ABISELECT(_ZThn40_N4gg343fooEv,_ZThn24_N4gg343fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n24_N4gg343fooEv,_ZTvn8_n12_N4gg343fooEv)();
static  VTBL_ENTRY vtc_gg34[] = {
  ABISELECT(40,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI4gg34[0]),
  (VTBL_ENTRY)&_ZN4gg343fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI4gg34[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg343fooEv,_ZTv0_n12_N4gg343fooEv),
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI4gg34[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg343fooEv,_ZTv0_n12_N4gg343fooEv),
  ABISELECT(-56,-32),
  (VTBL_ENTRY)&(_ZTI4gg34[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N4gg343fooEv,_ZTvn8_n12_N4gg343fooEv),
};
extern VTBL_ENTRY _ZTV4gg34[];
extern void _ZN4ee343fooEv();
static  VTBL_ENTRY _tg__ZTV4ee34__4gg34[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI4ee34[0]),
  (VTBL_ENTRY)&_ZN4ee343fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ee343fooEv,_ZTv0_n12_N4ee343fooEv)();
extern void ABISELECT(_ZThn24_N4ee343fooEv,_ZThn16_N4ee343fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb34__4ee34__4gg34[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI4ee34[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee343fooEv,_ZTv0_n12_N4ee343fooEv),
};
static  VTT_ENTRY vtt_gg34[] = {
  {&(_ZTV4gg34[4]),  4,16},
  {&(_tg__ZTV4ee34__4gg34[3]),  3,4},
  {&(_tg__ZTV4bb34__4ee34__4gg34[3]),  3,4},
  {&(_ZTV4gg34[8]),  8,16},
  {&(_ZTV4gg34[12]),  12,16},
  {&(_ZTV4gg34[15]),  15,16},
};
extern VTBL_ENTRY _ZTI4gg34[];
extern  VTBL_ENTRY _ZTV4gg34[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg34[];
static VTBL_ENTRY alt_thunk_names84[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee343fooEv,_ZTv0_n12_N4ee343fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N4ee343fooEv,_ZThn16_N4ee343fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg343fooEv,_ZTv0_n12_N4gg343fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N4gg343fooEv,_ZThn24_N4gg343fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N4gg343fooEv,_ZThn16_N4gg343fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg34 = {  "gg34", // class name
  bases_gg34, 6,
  &(vtc_gg34[0]), // expected_vtbl_contents
  &(vtt_gg34[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI4gg34),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg34),16, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg34),6, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names84,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa35  {
  int a;
   aa35(); // _ZN4aa35C1Ev
  virtual void  foo(); // _ZN4aa353fooEv
  ~aa35(); // tgen
};
//SIG(-1 aa35) C1{ v1 Fi}


 aa35 ::aa35(){ note_ctor("aa35", this);}
void  aa35 ::foo(){vfunc_called(this, "_ZN4aa353fooEv");}
aa35 ::~aa35(){ note_dtor("aa35", this);} // tgen

static void Test_aa35()
{
  extern Class_Descriptor cd_aa35;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa35, buf);
    aa35 *dp, &lv = *(dp=new (buf) aa35());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa35)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa35.a");
    test_class_info(&lv, &cd_aa35);
    dp->~aa35();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa35(Test_aa35, "aa35", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa35C1Ev();
extern void _ZN4aa35D1Ev();
Name_Map name_map_aa35[] = {
  NSPAIR(_ZN4aa35C1Ev),
  NSPAIR(_ZN4aa35D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa35[];
extern void _ZN4aa353fooEv();
static  VTBL_ENTRY vtc_aa35[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa35[0]),
  (VTBL_ENTRY)&_ZN4aa353fooEv,
};
extern VTBL_ENTRY _ZTI4aa35[];
extern  VTBL_ENTRY _ZTV4aa35[];
Class_Descriptor cd_aa35 = {  "aa35", // class name
  0,0,//no base classes
  &(vtc_aa35[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa35),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa35),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb35  {
  int b;
   bb35(); // _ZN4bb35C1Ev
  virtual void  foo(); // _ZN4bb353fooEv
  ~bb35(); // tgen
};
//SIG(-1 bb35) C1{ v1 Fi}


 bb35 ::bb35(){ note_ctor("bb35", this);}
void  bb35 ::foo(){vfunc_called(this, "_ZN4bb353fooEv");}
bb35 ::~bb35(){ note_dtor("bb35", this);} // tgen

static void Test_bb35()
{
  extern Class_Descriptor cd_bb35;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb35, buf);
    bb35 *dp, &lv = *(dp=new (buf) bb35());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb35)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb35.b");
    test_class_info(&lv, &cd_bb35);
    dp->~bb35();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb35(Test_bb35, "bb35", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb35C1Ev();
extern void _ZN4bb35D1Ev();
Name_Map name_map_bb35[] = {
  NSPAIR(_ZN4bb35C1Ev),
  NSPAIR(_ZN4bb35D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb35[];
extern void _ZN4bb353fooEv();
static  VTBL_ENTRY vtc_bb35[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb35[0]),
  (VTBL_ENTRY)&_ZN4bb353fooEv,
};
extern VTBL_ENTRY _ZTI4bb35[];
extern  VTBL_ENTRY _ZTV4bb35[];
Class_Descriptor cd_bb35 = {  "bb35", // class name
  0,0,//no base classes
  &(vtc_bb35[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb35),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb35),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc35  {
  int c;
   cc35(); // _ZN4cc35C1Ev
  virtual void  foo(); // _ZN4cc353fooEv
  ~cc35(); // tgen
};
//SIG(-1 cc35) C1{ v1 Fi}


 cc35 ::cc35(){ note_ctor("cc35", this);}
void  cc35 ::foo(){vfunc_called(this, "_ZN4cc353fooEv");}
cc35 ::~cc35(){ note_dtor("cc35", this);} // tgen

static void Test_cc35()
{
  extern Class_Descriptor cd_cc35;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc35, buf);
    cc35 *dp, &lv = *(dp=new (buf) cc35());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc35)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc35.c");
    test_class_info(&lv, &cd_cc35);
    dp->~cc35();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc35(Test_cc35, "cc35", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc35C1Ev();
extern void _ZN4cc35D1Ev();
Name_Map name_map_cc35[] = {
  NSPAIR(_ZN4cc35C1Ev),
  NSPAIR(_ZN4cc35D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc35[];
extern void _ZN4cc353fooEv();
static  VTBL_ENTRY vtc_cc35[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc35[0]),
  (VTBL_ENTRY)&_ZN4cc353fooEv,
};
extern VTBL_ENTRY _ZTI4cc35[];
extern  VTBL_ENTRY _ZTV4cc35[];
Class_Descriptor cd_cc35 = {  "cc35", // class name
  0,0,//no base classes
  &(vtc_cc35[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc35),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc35),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd35  {
  int d;
   dd35(); // _ZN4dd35C1Ev
  virtual void  foo(); // _ZN4dd353fooEv
  ~dd35(); // tgen
};
//SIG(-1 dd35) C1{ v1 Fi}


 dd35 ::dd35(){ note_ctor("dd35", this);}
void  dd35 ::foo(){vfunc_called(this, "_ZN4dd353fooEv");}
dd35 ::~dd35(){ note_dtor("dd35", this);} // tgen

static void Test_dd35()
{
  extern Class_Descriptor cd_dd35;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd35, buf);
    dd35 *dp, &lv = *(dp=new (buf) dd35());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd35)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd35.d");
    test_class_info(&lv, &cd_dd35);
    dp->~dd35();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd35(Test_dd35, "dd35", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd35C1Ev();
extern void _ZN4dd35D1Ev();
Name_Map name_map_dd35[] = {
  NSPAIR(_ZN4dd35C1Ev),
  NSPAIR(_ZN4dd35D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd35[];
extern void _ZN4dd353fooEv();
static  VTBL_ENTRY vtc_dd35[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd35[0]),
  (VTBL_ENTRY)&_ZN4dd353fooEv,
};
extern VTBL_ENTRY _ZTI4dd35[];
extern  VTBL_ENTRY _ZTV4dd35[];
Class_Descriptor cd_dd35 = {  "dd35", // class name
  0,0,//no base classes
  &(vtc_dd35[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd35),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd35),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee35  : virtual aa35 , virtual bb35 {
  int e;
   ee35(const ABISELECT(__tsi64,int) *const *); // _ZN4ee35C2Ev
  virtual void  foo(); // _ZN4ee353fooEv
  ~ee35(); // tgen
  ee35(); // tgen
};
//SIG(-1 ee35) C1{ VBC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ee35 ::ee35(const ABISELECT(__tsi64,int) *const *){}
void  ee35 ::foo(){vfunc_called(this, "_ZN4ee353fooEv");}
ee35 ::~ee35(){ note_dtor("ee35", this);} // tgen
ee35 ::ee35(){ note_ctor("ee35", this);} // tgen

static void Test_ee35()
{
  extern Class_Descriptor cd_ee35;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_ee35, buf);
    ee35 *dp, &lv = *(dp=new (buf) ee35());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(ee35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee35)");
    check_base_class_offset(lv, (aa35*), ABISELECT(16,8), "ee35");
    check_base_class_offset(lv, (bb35*), ABISELECT(32,16), "ee35");
    check_field_offset(lv, e, ABISELECT(8,4), "ee35.e");
    test_class_info(&lv, &cd_ee35);
    dp->~ee35();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee35(Test_ee35, "ee35", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN4ee35C1Ev();
extern void _ZN4ee35D1Ev();
Name_Map name_map_ee35[] = {
  NSPAIR(_ZN4ee35C1Ev),
  NSPAIR(_ZN4ee35D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa35;
extern VTBL_ENTRY _ZTI4aa35[];
extern  VTBL_ENTRY _ZTV4aa35[];
extern Class_Descriptor cd_bb35;
extern VTBL_ENTRY _ZTI4bb35[];
extern  VTBL_ENTRY _ZTV4bb35[];
static Base_Class bases_ee35[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa35,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_bb35,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ee35[];
extern void _ZN4ee353fooEv();
extern void ABISELECT(_ZTv0_n24_N4ee353fooEv,_ZTv0_n12_N4ee353fooEv)();
extern void ABISELECT(_ZThn16_N4ee353fooEv,_ZThn8_N4ee353fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4ee353fooEv,_ZTv0_n12_N4ee353fooEv)();
extern void ABISELECT(_ZThn32_N4ee353fooEv,_ZThn16_N4ee353fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee35[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI4ee35[0]),
  (VTBL_ENTRY)&_ZN4ee353fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ee35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee353fooEv,_ZTv0_n12_N4ee353fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI4ee35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee353fooEv,_ZTv0_n12_N4ee353fooEv),
};
extern VTBL_ENTRY _ZTV4ee35[];
static  VTT_ENTRY vtt_ee35[] = {
  {&(_ZTV4ee35[4]),  4,13},
  {&(_ZTV4ee35[8]),  8,13},
  {&(_ZTV4ee35[12]),  12,13},
};
extern VTBL_ENTRY _ZTI4ee35[];
extern  VTBL_ENTRY _ZTV4ee35[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee35[];
static VTBL_ENTRY alt_thunk_names85[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee353fooEv,_ZTv0_n12_N4ee353fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ee353fooEv,_ZThn16_N4ee353fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee353fooEv,_ZThn8_N4ee353fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee35 = {  "ee35", // class name
  bases_ee35, 2,
  &(vtc_ee35[0]), // expected_vtbl_contents
  &(vtt_ee35[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI4ee35),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee35),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ee35),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names85,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff35  : cc35 , dd35 {
  int f;
   ff35(); // _ZN4ff35C1Ev
  virtual void  foo(); // _ZN4ff353fooEv
  ~ff35(); // tgen
};
//SIG(-1 ff35) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ff35 ::ff35(){ note_ctor("ff35", this);}
void  ff35 ::foo(){vfunc_called(this, "_ZN4ff353fooEv");}
ff35 ::~ff35(){ note_dtor("ff35", this);} // tgen

static void Test_ff35()
{
  extern Class_Descriptor cd_ff35;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff35, buf);
    ff35 *dp, &lv = *(dp=new (buf) ff35());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff35)");
    check_base_class_offset(lv, (cc35*), 0, "ff35");
    check_base_class_offset(lv, (dd35*), ABISELECT(16,8), "ff35");
    check_field_offset(lv, f, ABISELECT(28,16), "ff35.f");
    test_class_info(&lv, &cd_ff35);
    dp->~ff35();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff35(Test_ff35, "ff35", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ff35C1Ev();
extern void _ZN4ff35D1Ev();
Name_Map name_map_ff35[] = {
  NSPAIR(_ZN4ff35C1Ev),
  NSPAIR(_ZN4ff35D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc35;
extern VTBL_ENTRY _ZTI4cc35[];
extern  VTBL_ENTRY _ZTV4cc35[];
extern Class_Descriptor cd_dd35;
extern VTBL_ENTRY _ZTI4dd35[];
extern  VTBL_ENTRY _ZTV4dd35[];
static Base_Class bases_ff35[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc35,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_dd35,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ff35[];
extern void _ZN4ff353fooEv();
extern void ABISELECT(_ZThn16_N4ff353fooEv,_ZThn8_N4ff353fooEv)();
static  VTBL_ENTRY vtc_ff35[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4ff35[0]),
  (VTBL_ENTRY)&_ZN4ff353fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ff35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4ff353fooEv,_ZThn8_N4ff353fooEv),
};
extern VTBL_ENTRY _ZTI4ff35[];
extern  VTBL_ENTRY _ZTV4ff35[];
Class_Descriptor cd_ff35 = {  "ff35", // class name
  bases_ff35, 2,
  &(vtc_ff35[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ff35),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff35),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg35  : ee35 , virtual ff35 {
  int g;
   gg35(const ABISELECT(__tsi64,int) *const *); // _ZN4gg35C2Ev
  virtual void  foo(); // _ZN4gg353fooEv
  ~gg35(); // tgen
  gg35(); // tgen
};
//SIG(1 gg35) C1{ BC2{ VBC3{ v1 Fi} VBC4{ v1 Fi} v1 Fi} VBC5{ BC6{ v1 Fi} BC7{ v1 Fi} v1 Fi} v1 Fi}


 gg35 ::gg35(const ABISELECT(__tsi64,int) *const *){}
void  gg35 ::foo(){vfunc_called(this, "_ZN4gg353fooEv");}
gg35 ::~gg35(){ note_dtor("gg35", this);} // tgen
gg35 ::gg35(){ note_ctor("gg35", this);} // tgen

static void Test_gg35()
{
  extern Class_Descriptor cd_gg35;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,13)];
    init_test(&cd_gg35, buf);
    gg35 *dp, &lv = *(dp=new (buf) gg35());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,48), "sizeof(gg35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg35)");
    check_base_class_offset(lv, (aa35*)(ee35*), ABISELECT(16,12), "gg35");
    check_base_class_offset(lv, (bb35*)(ee35*), ABISELECT(32,20), "gg35");
    check_base_class_offset(lv, (ee35*), 0, "gg35");
    check_base_class_offset(lv, (cc35*)(ff35*), ABISELECT(48,28), "gg35");
    check_base_class_offset(lv, (dd35*)(ff35*), ABISELECT(64,36), "gg35");
    check_base_class_offset(lv, (ff35*), ABISELECT(48,28), "gg35");
    check_field_offset(lv, g, ABISELECT(12,8), "gg35.g");
    test_class_info(&lv, &cd_gg35);
    dp->~gg35();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg35(Test_gg35, "gg35", ABISELECT(80,48));

#else // __cplusplus

extern void _ZN4gg35C1Ev();
extern void _ZN4gg35D1Ev();
Name_Map name_map_gg35[] = {
  NSPAIR(_ZN4gg35C1Ev),
  NSPAIR(_ZN4gg35D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa35;
extern VTBL_ENTRY _ZTI4aa35[];
extern  VTBL_ENTRY _ZTV4aa35[];
extern Class_Descriptor cd_bb35;
extern VTBL_ENTRY _ZTI4bb35[];
extern  VTBL_ENTRY _ZTV4bb35[];
extern Class_Descriptor cd_ee35;
extern VTBL_ENTRY _ZTI4ee35[];
extern  VTBL_ENTRY _ZTV4ee35[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee35[];
extern Class_Descriptor cd_cc35;
extern VTBL_ENTRY _ZTI4cc35[];
extern  VTBL_ENTRY _ZTV4cc35[];
extern Class_Descriptor cd_dd35;
extern VTBL_ENTRY _ZTI4dd35[];
extern  VTBL_ENTRY _ZTV4dd35[];
extern Class_Descriptor cd_ff35;
extern VTBL_ENTRY _ZTI4ff35[];
extern  VTBL_ENTRY _ZTV4ff35[];
static Base_Class bases_gg35[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa35,    ABISELECT(16,12), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_bb35,    ABISELECT(32,20), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_ee35,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc35,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_dd35,    ABISELECT(64,36), //bcp->offset
    18, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_ff35,    ABISELECT(48,28), //bcp->offset
    14, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4gg35[];
extern void _ZN4gg353fooEv();
extern void ABISELECT(_ZTv0_n24_N4gg353fooEv,_ZTv0_n12_N4gg353fooEv)();
extern void ABISELECT(_ZThn16_N4gg353fooEv,_ZThn12_N4gg353fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg353fooEv,_ZTv0_n12_N4gg353fooEv)();
extern void ABISELECT(_ZThn32_N4gg353fooEv,_ZThn20_N4gg353fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg353fooEv,_ZTv0_n12_N4gg353fooEv)();
extern void ABISELECT(_ZThn48_N4gg353fooEv,_ZThn28_N4gg353fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n24_N4gg353fooEv,_ZTvn8_n12_N4gg353fooEv)();
static  VTBL_ENTRY vtc_gg35[] = {
  ABISELECT(48,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4gg35[0]),
  (VTBL_ENTRY)&_ZN4gg353fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4gg35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg353fooEv,_ZTv0_n12_N4gg353fooEv),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI4gg35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg353fooEv,_ZTv0_n12_N4gg353fooEv),
  ABISELECT(-48,-28),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI4gg35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg353fooEv,_ZTv0_n12_N4gg353fooEv),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI4gg35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n24_N4gg353fooEv,_ZTvn8_n12_N4gg353fooEv),
};
extern VTBL_ENTRY _ZTV4gg35[];
extern void _ZN4ee353fooEv();
static  VTBL_ENTRY _tg__ZTV4ee35__4gg35[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee35[0]),
  (VTBL_ENTRY)&_ZN4ee353fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ee353fooEv,_ZTv0_n12_N4ee353fooEv)();
extern void ABISELECT(_ZThn16_N4ee353fooEv,_ZThn12_N4ee353fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4aa35__4ee35__4gg35[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee353fooEv,_ZTv0_n12_N4ee353fooEv),
};
extern void ABISELECT(_ZTv0_n24_N4ee353fooEv,_ZTv0_n12_N4ee353fooEv)();
extern void ABISELECT(_ZThn32_N4ee353fooEv,_ZThn20_N4ee353fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb35__4ee35__4gg35[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI4ee35[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee353fooEv,_ZTv0_n12_N4ee353fooEv),
};
static  VTT_ENTRY vtt_gg35[] = {
  {&(_ZTV4gg35[5]),  5,21},
  {&(_tg__ZTV4ee35__4gg35[4]),  4,5},
  {&(_tg__ZTV4aa35__4ee35__4gg35[3]),  3,4},
  {&(_tg__ZTV4bb35__4ee35__4gg35[3]),  3,4},
  {&(_ZTV4gg35[9]),  9,21},
  {&(_ZTV4gg35[13]),  13,21},
  {&(_ZTV4gg35[17]),  17,21},
  {&(_ZTV4gg35[20]),  20,21},
};
extern VTBL_ENTRY _ZTI4gg35[];
extern  VTBL_ENTRY _ZTV4gg35[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg35[];
static VTBL_ENTRY alt_thunk_names86[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee353fooEv,_ZTv0_n12_N4ee353fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ee353fooEv,_ZThn20_N4ee353fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee353fooEv,_ZThn12_N4ee353fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg353fooEv,_ZTv0_n12_N4gg353fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N4gg353fooEv,_ZThn28_N4gg353fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4gg353fooEv,_ZThn20_N4gg353fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4gg353fooEv,_ZThn12_N4gg353fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg35 = {  "gg35", // class name
  bases_gg35, 6,
  &(vtc_gg35[0]), // expected_vtbl_contents
  &(vtt_gg35[0]), // expected_vtt_contents
  ABISELECT(80,48), // object size
  NSPAIRA(_ZTI4gg35),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg35),21, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg35),8, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names86,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa36  {
  int a;
   aa36(); // _ZN4aa36C1Ev
  virtual void  foo(); // _ZN4aa363fooEv
  ~aa36(); // tgen
};
//SIG(-1 aa36) C1{ v1 Fi}


 aa36 ::aa36(){ note_ctor("aa36", this);}
void  aa36 ::foo(){vfunc_called(this, "_ZN4aa363fooEv");}
aa36 ::~aa36(){ note_dtor("aa36", this);} // tgen

static void Test_aa36()
{
  extern Class_Descriptor cd_aa36;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa36, buf);
    aa36 *dp, &lv = *(dp=new (buf) aa36());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa36)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa36.a");
    test_class_info(&lv, &cd_aa36);
    dp->~aa36();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa36(Test_aa36, "aa36", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa36C1Ev();
extern void _ZN4aa36D1Ev();
Name_Map name_map_aa36[] = {
  NSPAIR(_ZN4aa36C1Ev),
  NSPAIR(_ZN4aa36D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa36[];
extern void _ZN4aa363fooEv();
static  VTBL_ENTRY vtc_aa36[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa36[0]),
  (VTBL_ENTRY)&_ZN4aa363fooEv,
};
extern VTBL_ENTRY _ZTI4aa36[];
extern  VTBL_ENTRY _ZTV4aa36[];
Class_Descriptor cd_aa36 = {  "aa36", // class name
  0,0,//no base classes
  &(vtc_aa36[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa36),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa36),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb36  {
  int b;
   bb36(); // _ZN4bb36C1Ev
  virtual void  foo(); // _ZN4bb363fooEv
  ~bb36(); // tgen
};
//SIG(-1 bb36) C1{ v1 Fi}


 bb36 ::bb36(){ note_ctor("bb36", this);}
void  bb36 ::foo(){vfunc_called(this, "_ZN4bb363fooEv");}
bb36 ::~bb36(){ note_dtor("bb36", this);} // tgen

static void Test_bb36()
{
  extern Class_Descriptor cd_bb36;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb36, buf);
    bb36 *dp, &lv = *(dp=new (buf) bb36());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb36)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb36.b");
    test_class_info(&lv, &cd_bb36);
    dp->~bb36();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb36(Test_bb36, "bb36", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb36C1Ev();
extern void _ZN4bb36D1Ev();
Name_Map name_map_bb36[] = {
  NSPAIR(_ZN4bb36C1Ev),
  NSPAIR(_ZN4bb36D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb36[];
extern void _ZN4bb363fooEv();
static  VTBL_ENTRY vtc_bb36[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb36[0]),
  (VTBL_ENTRY)&_ZN4bb363fooEv,
};
extern VTBL_ENTRY _ZTI4bb36[];
extern  VTBL_ENTRY _ZTV4bb36[];
Class_Descriptor cd_bb36 = {  "bb36", // class name
  0,0,//no base classes
  &(vtc_bb36[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb36),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb36),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc36  {
  int c;
   cc36(); // _ZN4cc36C1Ev
  virtual void  foo(); // _ZN4cc363fooEv
  ~cc36(); // tgen
};
//SIG(-1 cc36) C1{ v1 Fi}


 cc36 ::cc36(){ note_ctor("cc36", this);}
void  cc36 ::foo(){vfunc_called(this, "_ZN4cc363fooEv");}
cc36 ::~cc36(){ note_dtor("cc36", this);} // tgen

static void Test_cc36()
{
  extern Class_Descriptor cd_cc36;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc36, buf);
    cc36 *dp, &lv = *(dp=new (buf) cc36());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc36)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc36.c");
    test_class_info(&lv, &cd_cc36);
    dp->~cc36();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc36(Test_cc36, "cc36", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc36C1Ev();
extern void _ZN4cc36D1Ev();
Name_Map name_map_cc36[] = {
  NSPAIR(_ZN4cc36C1Ev),
  NSPAIR(_ZN4cc36D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc36[];
extern void _ZN4cc363fooEv();
static  VTBL_ENTRY vtc_cc36[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc36[0]),
  (VTBL_ENTRY)&_ZN4cc363fooEv,
};
extern VTBL_ENTRY _ZTI4cc36[];
extern  VTBL_ENTRY _ZTV4cc36[];
Class_Descriptor cd_cc36 = {  "cc36", // class name
  0,0,//no base classes
  &(vtc_cc36[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc36),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc36),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd36  {
  int d;
   dd36(); // _ZN4dd36C1Ev
  virtual void  foo(); // _ZN4dd363fooEv
  ~dd36(); // tgen
};
//SIG(-1 dd36) C1{ v1 Fi}


 dd36 ::dd36(){ note_ctor("dd36", this);}
void  dd36 ::foo(){vfunc_called(this, "_ZN4dd363fooEv");}
dd36 ::~dd36(){ note_dtor("dd36", this);} // tgen

static void Test_dd36()
{
  extern Class_Descriptor cd_dd36;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd36, buf);
    dd36 *dp, &lv = *(dp=new (buf) dd36());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd36)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd36.d");
    test_class_info(&lv, &cd_dd36);
    dp->~dd36();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd36(Test_dd36, "dd36", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd36C1Ev();
extern void _ZN4dd36D1Ev();
Name_Map name_map_dd36[] = {
  NSPAIR(_ZN4dd36C1Ev),
  NSPAIR(_ZN4dd36D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd36[];
extern void _ZN4dd363fooEv();
static  VTBL_ENTRY vtc_dd36[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd36[0]),
  (VTBL_ENTRY)&_ZN4dd363fooEv,
};
extern VTBL_ENTRY _ZTI4dd36[];
extern  VTBL_ENTRY _ZTV4dd36[];
Class_Descriptor cd_dd36 = {  "dd36", // class name
  0,0,//no base classes
  &(vtc_dd36[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd36),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd36),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee36  : aa36 , bb36 {
  int e;
   ee36(); // _ZN4ee36C1Ev
  virtual void  foo(); // _ZN4ee363fooEv
  ~ee36(); // tgen
};
//SIG(-1 ee36) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ee36 ::ee36(){ note_ctor("ee36", this);}
void  ee36 ::foo(){vfunc_called(this, "_ZN4ee363fooEv");}
ee36 ::~ee36(){ note_dtor("ee36", this);} // tgen

static void Test_ee36()
{
  extern Class_Descriptor cd_ee36;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee36, buf);
    ee36 *dp, &lv = *(dp=new (buf) ee36());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee36)");
    check_base_class_offset(lv, (aa36*), 0, "ee36");
    check_base_class_offset(lv, (bb36*), ABISELECT(16,8), "ee36");
    check_field_offset(lv, e, ABISELECT(28,16), "ee36.e");
    test_class_info(&lv, &cd_ee36);
    dp->~ee36();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee36(Test_ee36, "ee36", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ee36C1Ev();
extern void _ZN4ee36D1Ev();
Name_Map name_map_ee36[] = {
  NSPAIR(_ZN4ee36C1Ev),
  NSPAIR(_ZN4ee36D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa36;
extern VTBL_ENTRY _ZTI4aa36[];
extern  VTBL_ENTRY _ZTV4aa36[];
extern Class_Descriptor cd_bb36;
extern VTBL_ENTRY _ZTI4bb36[];
extern  VTBL_ENTRY _ZTV4bb36[];
static Base_Class bases_ee36[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa36,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_bb36,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ee36[];
extern void _ZN4ee363fooEv();
extern void ABISELECT(_ZThn16_N4ee363fooEv,_ZThn8_N4ee363fooEv)();
static  VTBL_ENTRY vtc_ee36[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4ee36[0]),
  (VTBL_ENTRY)&_ZN4ee363fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ee36[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4ee363fooEv,_ZThn8_N4ee363fooEv),
};
extern VTBL_ENTRY _ZTI4ee36[];
extern  VTBL_ENTRY _ZTV4ee36[];
Class_Descriptor cd_ee36 = {  "ee36", // class name
  bases_ee36, 2,
  &(vtc_ee36[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ee36),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee36),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff36  : virtual cc36 , dd36 {
  int f;
   ff36(const ABISELECT(__tsi64,int) *const *); // _ZN4ff36C2Ev
  virtual void  foo(); // _ZN4ff363fooEv
  ~ff36(); // tgen
  ff36(); // tgen
};
//SIG(-1 ff36) C1{ VBC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ff36 ::ff36(const ABISELECT(__tsi64,int) *const *){}
void  ff36 ::foo(){vfunc_called(this, "_ZN4ff363fooEv");}
ff36 ::~ff36(){ note_dtor("ff36", this);} // tgen
ff36 ::ff36(){ note_ctor("ff36", this);} // tgen

static void Test_ff36()
{
  extern Class_Descriptor cd_ff36;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff36, buf);
    ff36 *dp, &lv = *(dp=new (buf) ff36());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff36)");
    check_base_class_offset(lv, (cc36*), ABISELECT(16,12), "ff36");
    check_base_class_offset(lv, (dd36*), 0, "ff36");
    check_field_offset(lv, f, ABISELECT(12,8), "ff36.f");
    test_class_info(&lv, &cd_ff36);
    dp->~ff36();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff36(Test_ff36, "ff36", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ff36C1Ev();
extern void _ZN4ff36D1Ev();
Name_Map name_map_ff36[] = {
  NSPAIR(_ZN4ff36C1Ev),
  NSPAIR(_ZN4ff36D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc36;
extern VTBL_ENTRY _ZTI4cc36[];
extern  VTBL_ENTRY _ZTV4cc36[];
extern Class_Descriptor cd_dd36;
extern VTBL_ENTRY _ZTI4dd36[];
extern  VTBL_ENTRY _ZTV4dd36[];
static Base_Class bases_ff36[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc36,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_dd36,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ff36[];
extern void _ZN4ff363fooEv();
extern void ABISELECT(_ZTv0_n24_N4ff363fooEv,_ZTv0_n12_N4ff363fooEv)();
extern void ABISELECT(_ZThn16_N4ff363fooEv,_ZThn12_N4ff363fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff36[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff36[0]),
  (VTBL_ENTRY)&_ZN4ff363fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff36[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff363fooEv,_ZTv0_n12_N4ff363fooEv),
};
extern VTBL_ENTRY _ZTV4ff36[];
static  VTT_ENTRY vtt_ff36[] = {
  {&(_ZTV4ff36[3]),  3,8},
  {&(_ZTV4ff36[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ff36[];
extern  VTBL_ENTRY _ZTV4ff36[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff36[];
static VTBL_ENTRY alt_thunk_names87[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff363fooEv,_ZTv0_n12_N4ff363fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff363fooEv,_ZThn12_N4ff363fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff36 = {  "ff36", // class name
  bases_ff36, 2,
  &(vtc_ff36[0]), // expected_vtbl_contents
  &(vtt_ff36[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ff36),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff36),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ff36),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names87,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg36  : ee36 , virtual ff36 {
  int g;
   gg36(const ABISELECT(__tsi64,int) *const *); // _ZN4gg36C2Ev
  virtual void  foo(); // _ZN4gg363fooEv
  ~gg36(); // tgen
  gg36(); // tgen
};
//SIG(1 gg36) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} VBC5{ VBC6{ v1 Fi} BC7{ v1 Fi} v1 Fi} v1 Fi}


 gg36 ::gg36(const ABISELECT(__tsi64,int) *const *){}
void  gg36 ::foo(){vfunc_called(this, "_ZN4gg363fooEv");}
gg36 ::~gg36(){ note_dtor("gg36", this);} // tgen
gg36 ::gg36(){ note_ctor("gg36", this);} // tgen

static void Test_gg36()
{
  extern Class_Descriptor cd_gg36;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg36, buf);
    gg36 *dp, &lv = *(dp=new (buf) gg36());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg36)");
    check_base_class_offset(lv, (aa36*)(ee36*), 0, "gg36");
    check_base_class_offset(lv, (bb36*)(ee36*), ABISELECT(16,8), "gg36");
    check_base_class_offset(lv, (ee36*), 0, "gg36");
    check_base_class_offset(lv, (cc36*)(ff36*), ABISELECT(56,36), "gg36");
    check_base_class_offset(lv, (dd36*)(ff36*), ABISELECT(40,24), "gg36");
    check_base_class_offset(lv, (ff36*), ABISELECT(40,24), "gg36");
    check_field_offset(lv, g, ABISELECT(32,20), "gg36.g");
    test_class_info(&lv, &cd_gg36);
    dp->~gg36();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg36(Test_gg36, "gg36", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN4gg36C1Ev();
extern void _ZN4gg36D1Ev();
Name_Map name_map_gg36[] = {
  NSPAIR(_ZN4gg36C1Ev),
  NSPAIR(_ZN4gg36D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa36;
extern VTBL_ENTRY _ZTI4aa36[];
extern  VTBL_ENTRY _ZTV4aa36[];
extern Class_Descriptor cd_bb36;
extern VTBL_ENTRY _ZTI4bb36[];
extern  VTBL_ENTRY _ZTV4bb36[];
extern Class_Descriptor cd_ee36;
extern VTBL_ENTRY _ZTI4ee36[];
extern  VTBL_ENTRY _ZTV4ee36[];
extern Class_Descriptor cd_cc36;
extern VTBL_ENTRY _ZTI4cc36[];
extern  VTBL_ENTRY _ZTV4cc36[];
extern Class_Descriptor cd_dd36;
extern VTBL_ENTRY _ZTI4dd36[];
extern  VTBL_ENTRY _ZTV4dd36[];
extern Class_Descriptor cd_ff36;
extern VTBL_ENTRY _ZTI4ff36[];
extern  VTBL_ENTRY _ZTV4ff36[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff36[];
static Base_Class bases_gg36[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa36,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_bb36,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_ee36,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc36,    ABISELECT(56,36), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_dd36,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_ff36,    ABISELECT(40,24), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4gg36[];
extern void _ZN4gg363fooEv();
extern void ABISELECT(_ZThn16_N4gg363fooEv,_ZThn8_N4gg363fooEv)();
extern void ABISELECT(_ZTv0_n32_N4gg363fooEv,_ZTv0_n16_N4gg363fooEv)();
extern void ABISELECT(_ZThn40_N4gg363fooEv,_ZThn24_N4gg363fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg363fooEv,_ZTv0_n12_N4gg363fooEv)();
extern void ABISELECT(_ZThn56_N4gg363fooEv,_ZThn36_N4gg363fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg36[] = {
  ABISELECT(56,36),
  ABISELECT(40,24),
  0,
  (VTBL_ENTRY)&(_ZTI4gg36[0]),
  (VTBL_ENTRY)&_ZN4gg363fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4gg36[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4gg363fooEv,_ZThn8_N4gg363fooEv),
  ABISELECT(-40,-24),
  ABISELECT(16,12),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI4gg36[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N4gg363fooEv,_ZTv0_n16_N4gg363fooEv),
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI4gg36[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg363fooEv,_ZTv0_n12_N4gg363fooEv),
};
extern VTBL_ENTRY _ZTV4gg36[];
extern void _ZN4ff363fooEv();
static  VTBL_ENTRY _tg__ZTV4ff36__4gg36[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff36[0]),
  (VTBL_ENTRY)&_ZN4ff363fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ff363fooEv,_ZTv0_n12_N4ff363fooEv)();
extern void ABISELECT(_ZThn16_N4ff363fooEv,_ZThn12_N4ff363fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4cc36__4ff36__4gg36[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff36[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff363fooEv,_ZTv0_n12_N4ff363fooEv),
};
static  VTT_ENTRY vtt_gg36[] = {
  {&(_ZTV4gg36[4]),  4,17},
  {&(_ZTV4gg36[12]),  12,17},
  {&(_ZTV4gg36[16]),  16,17},
  {&(_tg__ZTV4ff36__4gg36[3]),  3,4},
  {&(_tg__ZTV4cc36__4ff36__4gg36[3]),  3,4},
};
extern VTBL_ENTRY _ZTI4gg36[];
extern  VTBL_ENTRY _ZTV4gg36[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg36[];
static VTBL_ENTRY alt_thunk_names88[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff363fooEv,_ZTv0_n12_N4ff363fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff363fooEv,_ZThn12_N4ff363fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg363fooEv,_ZTv0_n12_N4gg363fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4gg363fooEv,_ZThn36_N4gg363fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N4gg363fooEv,_ZTv0_n16_N4gg363fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N4gg363fooEv,_ZThn24_N4gg363fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg36 = {  "gg36", // class name
  bases_gg36, 6,
  &(vtc_gg36[0]), // expected_vtbl_contents
  &(vtt_gg36[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI4gg36),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg36),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg36),5, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names88,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa37  {
  int a;
   aa37(); // _ZN4aa37C1Ev
  virtual void  foo(); // _ZN4aa373fooEv
  ~aa37(); // tgen
};
//SIG(-1 aa37) C1{ v1 Fi}


 aa37 ::aa37(){ note_ctor("aa37", this);}
void  aa37 ::foo(){vfunc_called(this, "_ZN4aa373fooEv");}
aa37 ::~aa37(){ note_dtor("aa37", this);} // tgen

static void Test_aa37()
{
  extern Class_Descriptor cd_aa37;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa37, buf);
    aa37 *dp, &lv = *(dp=new (buf) aa37());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa37)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa37.a");
    test_class_info(&lv, &cd_aa37);
    dp->~aa37();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa37(Test_aa37, "aa37", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa37C1Ev();
extern void _ZN4aa37D1Ev();
Name_Map name_map_aa37[] = {
  NSPAIR(_ZN4aa37C1Ev),
  NSPAIR(_ZN4aa37D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa37[];
extern void _ZN4aa373fooEv();
static  VTBL_ENTRY vtc_aa37[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa37[0]),
  (VTBL_ENTRY)&_ZN4aa373fooEv,
};
extern VTBL_ENTRY _ZTI4aa37[];
extern  VTBL_ENTRY _ZTV4aa37[];
Class_Descriptor cd_aa37 = {  "aa37", // class name
  0,0,//no base classes
  &(vtc_aa37[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa37),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa37),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb37  {
  int b;
   bb37(); // _ZN4bb37C1Ev
  virtual void  foo(); // _ZN4bb373fooEv
  ~bb37(); // tgen
};
//SIG(-1 bb37) C1{ v1 Fi}


 bb37 ::bb37(){ note_ctor("bb37", this);}
void  bb37 ::foo(){vfunc_called(this, "_ZN4bb373fooEv");}
bb37 ::~bb37(){ note_dtor("bb37", this);} // tgen

static void Test_bb37()
{
  extern Class_Descriptor cd_bb37;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb37, buf);
    bb37 *dp, &lv = *(dp=new (buf) bb37());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb37)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb37.b");
    test_class_info(&lv, &cd_bb37);
    dp->~bb37();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb37(Test_bb37, "bb37", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb37C1Ev();
extern void _ZN4bb37D1Ev();
Name_Map name_map_bb37[] = {
  NSPAIR(_ZN4bb37C1Ev),
  NSPAIR(_ZN4bb37D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb37[];
extern void _ZN4bb373fooEv();
static  VTBL_ENTRY vtc_bb37[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb37[0]),
  (VTBL_ENTRY)&_ZN4bb373fooEv,
};
extern VTBL_ENTRY _ZTI4bb37[];
extern  VTBL_ENTRY _ZTV4bb37[];
Class_Descriptor cd_bb37 = {  "bb37", // class name
  0,0,//no base classes
  &(vtc_bb37[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb37),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb37),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc37  {
  int c;
   cc37(); // _ZN4cc37C1Ev
  virtual void  foo(); // _ZN4cc373fooEv
  ~cc37(); // tgen
};
//SIG(-1 cc37) C1{ v1 Fi}


 cc37 ::cc37(){ note_ctor("cc37", this);}
void  cc37 ::foo(){vfunc_called(this, "_ZN4cc373fooEv");}
cc37 ::~cc37(){ note_dtor("cc37", this);} // tgen

static void Test_cc37()
{
  extern Class_Descriptor cd_cc37;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc37, buf);
    cc37 *dp, &lv = *(dp=new (buf) cc37());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc37)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc37.c");
    test_class_info(&lv, &cd_cc37);
    dp->~cc37();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc37(Test_cc37, "cc37", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc37C1Ev();
extern void _ZN4cc37D1Ev();
Name_Map name_map_cc37[] = {
  NSPAIR(_ZN4cc37C1Ev),
  NSPAIR(_ZN4cc37D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc37[];
extern void _ZN4cc373fooEv();
static  VTBL_ENTRY vtc_cc37[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc37[0]),
  (VTBL_ENTRY)&_ZN4cc373fooEv,
};
extern VTBL_ENTRY _ZTI4cc37[];
extern  VTBL_ENTRY _ZTV4cc37[];
Class_Descriptor cd_cc37 = {  "cc37", // class name
  0,0,//no base classes
  &(vtc_cc37[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc37),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc37),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd37  {
  int d;
   dd37(); // _ZN4dd37C1Ev
  virtual void  foo(); // _ZN4dd373fooEv
  ~dd37(); // tgen
};
//SIG(-1 dd37) C1{ v1 Fi}


 dd37 ::dd37(){ note_ctor("dd37", this);}
void  dd37 ::foo(){vfunc_called(this, "_ZN4dd373fooEv");}
dd37 ::~dd37(){ note_dtor("dd37", this);} // tgen

static void Test_dd37()
{
  extern Class_Descriptor cd_dd37;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd37, buf);
    dd37 *dp, &lv = *(dp=new (buf) dd37());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd37)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd37.d");
    test_class_info(&lv, &cd_dd37);
    dp->~dd37();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd37(Test_dd37, "dd37", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd37C1Ev();
extern void _ZN4dd37D1Ev();
Name_Map name_map_dd37[] = {
  NSPAIR(_ZN4dd37C1Ev),
  NSPAIR(_ZN4dd37D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd37[];
extern void _ZN4dd373fooEv();
static  VTBL_ENTRY vtc_dd37[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd37[0]),
  (VTBL_ENTRY)&_ZN4dd373fooEv,
};
extern VTBL_ENTRY _ZTI4dd37[];
extern  VTBL_ENTRY _ZTV4dd37[];
Class_Descriptor cd_dd37 = {  "dd37", // class name
  0,0,//no base classes
  &(vtc_dd37[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd37),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd37),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee37  : virtual aa37 , bb37 {
  int e;
   ee37(const ABISELECT(__tsi64,int) *const *); // _ZN4ee37C2Ev
  virtual void  foo(); // _ZN4ee373fooEv
  ~ee37(); // tgen
  ee37(); // tgen
};
//SIG(-1 ee37) C1{ VBC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ee37 ::ee37(const ABISELECT(__tsi64,int) *const *){}
void  ee37 ::foo(){vfunc_called(this, "_ZN4ee373fooEv");}
ee37 ::~ee37(){ note_dtor("ee37", this);} // tgen
ee37 ::ee37(){ note_ctor("ee37", this);} // tgen

static void Test_ee37()
{
  extern Class_Descriptor cd_ee37;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee37, buf);
    ee37 *dp, &lv = *(dp=new (buf) ee37());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee37)");
    check_base_class_offset(lv, (aa37*), ABISELECT(16,12), "ee37");
    check_base_class_offset(lv, (bb37*), 0, "ee37");
    check_field_offset(lv, e, ABISELECT(12,8), "ee37.e");
    test_class_info(&lv, &cd_ee37);
    dp->~ee37();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee37(Test_ee37, "ee37", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ee37C1Ev();
extern void _ZN4ee37D1Ev();
Name_Map name_map_ee37[] = {
  NSPAIR(_ZN4ee37C1Ev),
  NSPAIR(_ZN4ee37D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa37;
extern VTBL_ENTRY _ZTI4aa37[];
extern  VTBL_ENTRY _ZTV4aa37[];
extern Class_Descriptor cd_bb37;
extern VTBL_ENTRY _ZTI4bb37[];
extern  VTBL_ENTRY _ZTV4bb37[];
static Base_Class bases_ee37[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa37,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_bb37,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ee37[];
extern void _ZN4ee373fooEv();
extern void ABISELECT(_ZTv0_n24_N4ee373fooEv,_ZTv0_n12_N4ee373fooEv)();
extern void ABISELECT(_ZThn16_N4ee373fooEv,_ZThn12_N4ee373fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee37[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee37[0]),
  (VTBL_ENTRY)&_ZN4ee373fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee373fooEv,_ZTv0_n12_N4ee373fooEv),
};
extern VTBL_ENTRY _ZTV4ee37[];
static  VTT_ENTRY vtt_ee37[] = {
  {&(_ZTV4ee37[3]),  3,8},
  {&(_ZTV4ee37[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ee37[];
extern  VTBL_ENTRY _ZTV4ee37[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee37[];
static VTBL_ENTRY alt_thunk_names89[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee373fooEv,_ZTv0_n12_N4ee373fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee373fooEv,_ZThn12_N4ee373fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee37 = {  "ee37", // class name
  bases_ee37, 2,
  &(vtc_ee37[0]), // expected_vtbl_contents
  &(vtt_ee37[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ee37),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee37),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ee37),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names89,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff37  : virtual cc37 , dd37 {
  int f;
   ff37(const ABISELECT(__tsi64,int) *const *); // _ZN4ff37C2Ev
  virtual void  foo(); // _ZN4ff373fooEv
  ~ff37(); // tgen
  ff37(); // tgen
};
//SIG(-1 ff37) C1{ VBC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ff37 ::ff37(const ABISELECT(__tsi64,int) *const *){}
void  ff37 ::foo(){vfunc_called(this, "_ZN4ff373fooEv");}
ff37 ::~ff37(){ note_dtor("ff37", this);} // tgen
ff37 ::ff37(){ note_ctor("ff37", this);} // tgen

static void Test_ff37()
{
  extern Class_Descriptor cd_ff37;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff37, buf);
    ff37 *dp, &lv = *(dp=new (buf) ff37());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff37)");
    check_base_class_offset(lv, (cc37*), ABISELECT(16,12), "ff37");
    check_base_class_offset(lv, (dd37*), 0, "ff37");
    check_field_offset(lv, f, ABISELECT(12,8), "ff37.f");
    test_class_info(&lv, &cd_ff37);
    dp->~ff37();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff37(Test_ff37, "ff37", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ff37C1Ev();
extern void _ZN4ff37D1Ev();
Name_Map name_map_ff37[] = {
  NSPAIR(_ZN4ff37C1Ev),
  NSPAIR(_ZN4ff37D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc37;
extern VTBL_ENTRY _ZTI4cc37[];
extern  VTBL_ENTRY _ZTV4cc37[];
extern Class_Descriptor cd_dd37;
extern VTBL_ENTRY _ZTI4dd37[];
extern  VTBL_ENTRY _ZTV4dd37[];
static Base_Class bases_ff37[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc37,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_dd37,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ff37[];
extern void _ZN4ff373fooEv();
extern void ABISELECT(_ZTv0_n24_N4ff373fooEv,_ZTv0_n12_N4ff373fooEv)();
extern void ABISELECT(_ZThn16_N4ff373fooEv,_ZThn12_N4ff373fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff37[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff37[0]),
  (VTBL_ENTRY)&_ZN4ff373fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff373fooEv,_ZTv0_n12_N4ff373fooEv),
};
extern VTBL_ENTRY _ZTV4ff37[];
static  VTT_ENTRY vtt_ff37[] = {
  {&(_ZTV4ff37[3]),  3,8},
  {&(_ZTV4ff37[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ff37[];
extern  VTBL_ENTRY _ZTV4ff37[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff37[];
static VTBL_ENTRY alt_thunk_names90[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff373fooEv,_ZTv0_n12_N4ff373fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff373fooEv,_ZThn12_N4ff373fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff37 = {  "ff37", // class name
  bases_ff37, 2,
  &(vtc_ff37[0]), // expected_vtbl_contents
  &(vtt_ff37[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ff37),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff37),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ff37),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names90,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg37  : ee37 , virtual ff37 {
  int g;
   gg37(const ABISELECT(__tsi64,int) *const *); // _ZN4gg37C2Ev
  virtual void  foo(); // _ZN4gg373fooEv
  ~gg37(); // tgen
  gg37(); // tgen
};
//SIG(1 gg37) C1{ BC2{ VBC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} VBC5{ VBC6{ v1 Fi} BC7{ v1 Fi} v1 Fi} v1 Fi}


 gg37 ::gg37(const ABISELECT(__tsi64,int) *const *){}
void  gg37 ::foo(){vfunc_called(this, "_ZN4gg373fooEv");}
gg37 ::~gg37(){ note_dtor("gg37", this);} // tgen
gg37 ::gg37(){ note_ctor("gg37", this);} // tgen

static void Test_gg37()
{
  extern Class_Descriptor cd_gg37;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg37, buf);
    gg37 *dp, &lv = *(dp=new (buf) gg37());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg37)");
    check_base_class_offset(lv, (aa37*)(ee37*), ABISELECT(24,16), "gg37");
    check_base_class_offset(lv, (bb37*)(ee37*), 0, "gg37");
    check_base_class_offset(lv, (ee37*), 0, "gg37");
    check_base_class_offset(lv, (cc37*)(ff37*), ABISELECT(56,36), "gg37");
    check_base_class_offset(lv, (dd37*)(ff37*), ABISELECT(40,24), "gg37");
    check_base_class_offset(lv, (ff37*), ABISELECT(40,24), "gg37");
    check_field_offset(lv, g, ABISELECT(16,12), "gg37.g");
    test_class_info(&lv, &cd_gg37);
    dp->~gg37();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg37(Test_gg37, "gg37", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN4gg37C1Ev();
extern void _ZN4gg37D1Ev();
Name_Map name_map_gg37[] = {
  NSPAIR(_ZN4gg37C1Ev),
  NSPAIR(_ZN4gg37D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa37;
extern VTBL_ENTRY _ZTI4aa37[];
extern  VTBL_ENTRY _ZTV4aa37[];
extern Class_Descriptor cd_bb37;
extern VTBL_ENTRY _ZTI4bb37[];
extern  VTBL_ENTRY _ZTV4bb37[];
extern Class_Descriptor cd_ee37;
extern VTBL_ENTRY _ZTI4ee37[];
extern  VTBL_ENTRY _ZTV4ee37[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee37[];
extern Class_Descriptor cd_cc37;
extern VTBL_ENTRY _ZTI4cc37[];
extern  VTBL_ENTRY _ZTV4cc37[];
extern Class_Descriptor cd_dd37;
extern VTBL_ENTRY _ZTI4dd37[];
extern  VTBL_ENTRY _ZTV4dd37[];
extern Class_Descriptor cd_ff37;
extern VTBL_ENTRY _ZTI4ff37[];
extern  VTBL_ENTRY _ZTV4ff37[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff37[];
static Base_Class bases_gg37[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa37,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_bb37,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_ee37,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc37,    ABISELECT(56,36), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_dd37,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_ff37,    ABISELECT(40,24), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4gg37[];
extern void _ZN4gg373fooEv();
extern void ABISELECT(_ZTv0_n24_N4gg373fooEv,_ZTv0_n12_N4gg373fooEv)();
extern void ABISELECT(_ZThn24_N4gg373fooEv,_ZThn16_N4gg373fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N4gg373fooEv,_ZTv0_n16_N4gg373fooEv)();
extern void ABISELECT(_ZThn40_N4gg373fooEv,_ZThn24_N4gg373fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg373fooEv,_ZTv0_n12_N4gg373fooEv)();
extern void ABISELECT(_ZThn56_N4gg373fooEv,_ZThn36_N4gg373fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg37[] = {
  ABISELECT(56,36),
  ABISELECT(40,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI4gg37[0]),
  (VTBL_ENTRY)&_ZN4gg373fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI4gg37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg373fooEv,_ZTv0_n12_N4gg373fooEv),
  ABISELECT(-40,-24),
  ABISELECT(16,12),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI4gg37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N4gg373fooEv,_ZTv0_n16_N4gg373fooEv),
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI4gg37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg373fooEv,_ZTv0_n12_N4gg373fooEv),
};
extern VTBL_ENTRY _ZTV4gg37[];
extern void _ZN4ee373fooEv();
static  VTBL_ENTRY _tg__ZTV4ee37__4gg37[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI4ee37[0]),
  (VTBL_ENTRY)&_ZN4ee373fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ee373fooEv,_ZTv0_n12_N4ee373fooEv)();
extern void ABISELECT(_ZThn24_N4ee373fooEv,_ZThn16_N4ee373fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4aa37__4ee37__4gg37[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI4ee37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee373fooEv,_ZTv0_n12_N4ee373fooEv),
};
extern void _ZN4ff373fooEv();
static  VTBL_ENTRY _tg__ZTV4ff37__4gg37[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff37[0]),
  (VTBL_ENTRY)&_ZN4ff373fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ff373fooEv,_ZTv0_n12_N4ff373fooEv)();
extern void ABISELECT(_ZThn16_N4ff373fooEv,_ZThn12_N4ff373fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4cc37__4ff37__4gg37[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff37[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff373fooEv,_ZTv0_n12_N4ff373fooEv),
};
static  VTT_ENTRY vtt_gg37[] = {
  {&(_ZTV4gg37[5]),  5,19},
  {&(_tg__ZTV4ee37__4gg37[3]),  3,4},
  {&(_tg__ZTV4aa37__4ee37__4gg37[3]),  3,4},
  {&(_ZTV4gg37[9]),  9,19},
  {&(_ZTV4gg37[14]),  14,19},
  {&(_ZTV4gg37[18]),  18,19},
  {&(_tg__ZTV4ff37__4gg37[3]),  3,4},
  {&(_tg__ZTV4cc37__4ff37__4gg37[3]),  3,4},
};
extern VTBL_ENTRY _ZTI4gg37[];
extern  VTBL_ENTRY _ZTV4gg37[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg37[];
static VTBL_ENTRY alt_thunk_names91[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff373fooEv,_ZTv0_n12_N4ff373fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff373fooEv,_ZThn12_N4ff373fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee373fooEv,_ZTv0_n12_N4ee373fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N4ee373fooEv,_ZThn16_N4ee373fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N4gg373fooEv,_ZTv0_n16_N4gg373fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N4gg373fooEv,_ZThn24_N4gg373fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg373fooEv,_ZTv0_n12_N4gg373fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4gg373fooEv,_ZThn36_N4gg373fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N4gg373fooEv,_ZThn16_N4gg373fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg37 = {  "gg37", // class name
  bases_gg37, 6,
  &(vtc_gg37[0]), // expected_vtbl_contents
  &(vtt_gg37[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI4gg37),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg37),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg37),8, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names91,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa38  {
  int a;
   aa38(); // _ZN4aa38C1Ev
  virtual void  foo(); // _ZN4aa383fooEv
  ~aa38(); // tgen
};
//SIG(-1 aa38) C1{ v1 Fi}


 aa38 ::aa38(){ note_ctor("aa38", this);}
void  aa38 ::foo(){vfunc_called(this, "_ZN4aa383fooEv");}
aa38 ::~aa38(){ note_dtor("aa38", this);} // tgen

static void Test_aa38()
{
  extern Class_Descriptor cd_aa38;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa38, buf);
    aa38 *dp, &lv = *(dp=new (buf) aa38());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa38)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa38.a");
    test_class_info(&lv, &cd_aa38);
    dp->~aa38();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa38(Test_aa38, "aa38", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa38C1Ev();
extern void _ZN4aa38D1Ev();
Name_Map name_map_aa38[] = {
  NSPAIR(_ZN4aa38C1Ev),
  NSPAIR(_ZN4aa38D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa38[];
extern void _ZN4aa383fooEv();
static  VTBL_ENTRY vtc_aa38[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa38[0]),
  (VTBL_ENTRY)&_ZN4aa383fooEv,
};
extern VTBL_ENTRY _ZTI4aa38[];
extern  VTBL_ENTRY _ZTV4aa38[];
Class_Descriptor cd_aa38 = {  "aa38", // class name
  0,0,//no base classes
  &(vtc_aa38[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa38),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa38),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb38  {
  int b;
   bb38(); // _ZN4bb38C1Ev
  virtual void  foo(); // _ZN4bb383fooEv
  ~bb38(); // tgen
};
//SIG(-1 bb38) C1{ v1 Fi}


 bb38 ::bb38(){ note_ctor("bb38", this);}
void  bb38 ::foo(){vfunc_called(this, "_ZN4bb383fooEv");}
bb38 ::~bb38(){ note_dtor("bb38", this);} // tgen

static void Test_bb38()
{
  extern Class_Descriptor cd_bb38;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb38, buf);
    bb38 *dp, &lv = *(dp=new (buf) bb38());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb38)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb38.b");
    test_class_info(&lv, &cd_bb38);
    dp->~bb38();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb38(Test_bb38, "bb38", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb38C1Ev();
extern void _ZN4bb38D1Ev();
Name_Map name_map_bb38[] = {
  NSPAIR(_ZN4bb38C1Ev),
  NSPAIR(_ZN4bb38D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb38[];
extern void _ZN4bb383fooEv();
static  VTBL_ENTRY vtc_bb38[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb38[0]),
  (VTBL_ENTRY)&_ZN4bb383fooEv,
};
extern VTBL_ENTRY _ZTI4bb38[];
extern  VTBL_ENTRY _ZTV4bb38[];
Class_Descriptor cd_bb38 = {  "bb38", // class name
  0,0,//no base classes
  &(vtc_bb38[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb38),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb38),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc38  {
  int c;
   cc38(); // _ZN4cc38C1Ev
  virtual void  foo(); // _ZN4cc383fooEv
  ~cc38(); // tgen
};
//SIG(-1 cc38) C1{ v1 Fi}


 cc38 ::cc38(){ note_ctor("cc38", this);}
void  cc38 ::foo(){vfunc_called(this, "_ZN4cc383fooEv");}
cc38 ::~cc38(){ note_dtor("cc38", this);} // tgen

static void Test_cc38()
{
  extern Class_Descriptor cd_cc38;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc38, buf);
    cc38 *dp, &lv = *(dp=new (buf) cc38());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc38)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc38.c");
    test_class_info(&lv, &cd_cc38);
    dp->~cc38();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc38(Test_cc38, "cc38", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc38C1Ev();
extern void _ZN4cc38D1Ev();
Name_Map name_map_cc38[] = {
  NSPAIR(_ZN4cc38C1Ev),
  NSPAIR(_ZN4cc38D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc38[];
extern void _ZN4cc383fooEv();
static  VTBL_ENTRY vtc_cc38[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc38[0]),
  (VTBL_ENTRY)&_ZN4cc383fooEv,
};
extern VTBL_ENTRY _ZTI4cc38[];
extern  VTBL_ENTRY _ZTV4cc38[];
Class_Descriptor cd_cc38 = {  "cc38", // class name
  0,0,//no base classes
  &(vtc_cc38[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc38),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc38),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd38  {
  int d;
   dd38(); // _ZN4dd38C1Ev
  virtual void  foo(); // _ZN4dd383fooEv
  ~dd38(); // tgen
};
//SIG(-1 dd38) C1{ v1 Fi}


 dd38 ::dd38(){ note_ctor("dd38", this);}
void  dd38 ::foo(){vfunc_called(this, "_ZN4dd383fooEv");}
dd38 ::~dd38(){ note_dtor("dd38", this);} // tgen

static void Test_dd38()
{
  extern Class_Descriptor cd_dd38;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd38, buf);
    dd38 *dp, &lv = *(dp=new (buf) dd38());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd38)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd38.d");
    test_class_info(&lv, &cd_dd38);
    dp->~dd38();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd38(Test_dd38, "dd38", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd38C1Ev();
extern void _ZN4dd38D1Ev();
Name_Map name_map_dd38[] = {
  NSPAIR(_ZN4dd38C1Ev),
  NSPAIR(_ZN4dd38D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd38[];
extern void _ZN4dd383fooEv();
static  VTBL_ENTRY vtc_dd38[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd38[0]),
  (VTBL_ENTRY)&_ZN4dd383fooEv,
};
extern VTBL_ENTRY _ZTI4dd38[];
extern  VTBL_ENTRY _ZTV4dd38[];
Class_Descriptor cd_dd38 = {  "dd38", // class name
  0,0,//no base classes
  &(vtc_dd38[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd38),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd38),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee38  : aa38 , virtual bb38 {
  int e;
   ee38(const ABISELECT(__tsi64,int) *const *); // _ZN4ee38C2Ev
  virtual void  foo(); // _ZN4ee383fooEv
  ~ee38(); // tgen
  ee38(); // tgen
};
//SIG(-1 ee38) C1{ BC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ee38 ::ee38(const ABISELECT(__tsi64,int) *const *){}
void  ee38 ::foo(){vfunc_called(this, "_ZN4ee383fooEv");}
ee38 ::~ee38(){ note_dtor("ee38", this);} // tgen
ee38 ::ee38(){ note_ctor("ee38", this);} // tgen

static void Test_ee38()
{
  extern Class_Descriptor cd_ee38;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee38, buf);
    ee38 *dp, &lv = *(dp=new (buf) ee38());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee38)");
    check_base_class_offset(lv, (aa38*), 0, "ee38");
    check_base_class_offset(lv, (bb38*), ABISELECT(16,12), "ee38");
    check_field_offset(lv, e, ABISELECT(12,8), "ee38.e");
    test_class_info(&lv, &cd_ee38);
    dp->~ee38();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee38(Test_ee38, "ee38", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ee38C1Ev();
extern void _ZN4ee38D1Ev();
Name_Map name_map_ee38[] = {
  NSPAIR(_ZN4ee38C1Ev),
  NSPAIR(_ZN4ee38D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa38;
extern VTBL_ENTRY _ZTI4aa38[];
extern  VTBL_ENTRY _ZTV4aa38[];
extern Class_Descriptor cd_bb38;
extern VTBL_ENTRY _ZTI4bb38[];
extern  VTBL_ENTRY _ZTV4bb38[];
static Base_Class bases_ee38[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa38,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_bb38,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ee38[];
extern void _ZN4ee383fooEv();
extern void ABISELECT(_ZTv0_n24_N4ee383fooEv,_ZTv0_n12_N4ee383fooEv)();
extern void ABISELECT(_ZThn16_N4ee383fooEv,_ZThn12_N4ee383fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee38[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee38[0]),
  (VTBL_ENTRY)&_ZN4ee383fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee383fooEv,_ZTv0_n12_N4ee383fooEv),
};
extern VTBL_ENTRY _ZTV4ee38[];
static  VTT_ENTRY vtt_ee38[] = {
  {&(_ZTV4ee38[3]),  3,8},
  {&(_ZTV4ee38[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ee38[];
extern  VTBL_ENTRY _ZTV4ee38[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee38[];
static VTBL_ENTRY alt_thunk_names92[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee383fooEv,_ZTv0_n12_N4ee383fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee383fooEv,_ZThn12_N4ee383fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee38 = {  "ee38", // class name
  bases_ee38, 2,
  &(vtc_ee38[0]), // expected_vtbl_contents
  &(vtt_ee38[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ee38),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee38),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ee38),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names92,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff38  : virtual cc38 , dd38 {
  int f;
   ff38(const ABISELECT(__tsi64,int) *const *); // _ZN4ff38C2Ev
  virtual void  foo(); // _ZN4ff383fooEv
  ~ff38(); // tgen
  ff38(); // tgen
};
//SIG(-1 ff38) C1{ VBC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ff38 ::ff38(const ABISELECT(__tsi64,int) *const *){}
void  ff38 ::foo(){vfunc_called(this, "_ZN4ff383fooEv");}
ff38 ::~ff38(){ note_dtor("ff38", this);} // tgen
ff38 ::ff38(){ note_ctor("ff38", this);} // tgen

static void Test_ff38()
{
  extern Class_Descriptor cd_ff38;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff38, buf);
    ff38 *dp, &lv = *(dp=new (buf) ff38());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff38)");
    check_base_class_offset(lv, (cc38*), ABISELECT(16,12), "ff38");
    check_base_class_offset(lv, (dd38*), 0, "ff38");
    check_field_offset(lv, f, ABISELECT(12,8), "ff38.f");
    test_class_info(&lv, &cd_ff38);
    dp->~ff38();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff38(Test_ff38, "ff38", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ff38C1Ev();
extern void _ZN4ff38D1Ev();
Name_Map name_map_ff38[] = {
  NSPAIR(_ZN4ff38C1Ev),
  NSPAIR(_ZN4ff38D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc38;
extern VTBL_ENTRY _ZTI4cc38[];
extern  VTBL_ENTRY _ZTV4cc38[];
extern Class_Descriptor cd_dd38;
extern VTBL_ENTRY _ZTI4dd38[];
extern  VTBL_ENTRY _ZTV4dd38[];
static Base_Class bases_ff38[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc38,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_dd38,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ff38[];
extern void _ZN4ff383fooEv();
extern void ABISELECT(_ZTv0_n24_N4ff383fooEv,_ZTv0_n12_N4ff383fooEv)();
extern void ABISELECT(_ZThn16_N4ff383fooEv,_ZThn12_N4ff383fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff38[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff38[0]),
  (VTBL_ENTRY)&_ZN4ff383fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff383fooEv,_ZTv0_n12_N4ff383fooEv),
};
extern VTBL_ENTRY _ZTV4ff38[];
static  VTT_ENTRY vtt_ff38[] = {
  {&(_ZTV4ff38[3]),  3,8},
  {&(_ZTV4ff38[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ff38[];
extern  VTBL_ENTRY _ZTV4ff38[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff38[];
static VTBL_ENTRY alt_thunk_names93[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff383fooEv,_ZTv0_n12_N4ff383fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff383fooEv,_ZThn12_N4ff383fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff38 = {  "ff38", // class name
  bases_ff38, 2,
  &(vtc_ff38[0]), // expected_vtbl_contents
  &(vtt_ff38[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ff38),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff38),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ff38),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names93,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg38  : ee38 , virtual ff38 {
  int g;
   gg38(const ABISELECT(__tsi64,int) *const *); // _ZN4gg38C2Ev
  virtual void  foo(); // _ZN4gg383fooEv
  ~gg38(); // tgen
  gg38(); // tgen
};
//SIG(1 gg38) C1{ BC2{ BC3{ v1 Fi} VBC4{ v1 Fi} v1 Fi} VBC5{ VBC6{ v1 Fi} BC7{ v1 Fi} v1 Fi} v1 Fi}


 gg38 ::gg38(const ABISELECT(__tsi64,int) *const *){}
void  gg38 ::foo(){vfunc_called(this, "_ZN4gg383fooEv");}
gg38 ::~gg38(){ note_dtor("gg38", this);} // tgen
gg38 ::gg38(){ note_ctor("gg38", this);} // tgen

static void Test_gg38()
{
  extern Class_Descriptor cd_gg38;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg38, buf);
    gg38 *dp, &lv = *(dp=new (buf) gg38());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg38)");
    check_base_class_offset(lv, (aa38*)(ee38*), 0, "gg38");
    check_base_class_offset(lv, (bb38*)(ee38*), ABISELECT(24,16), "gg38");
    check_base_class_offset(lv, (ee38*), 0, "gg38");
    check_base_class_offset(lv, (cc38*)(ff38*), ABISELECT(56,36), "gg38");
    check_base_class_offset(lv, (dd38*)(ff38*), ABISELECT(40,24), "gg38");
    check_base_class_offset(lv, (ff38*), ABISELECT(40,24), "gg38");
    check_field_offset(lv, g, ABISELECT(16,12), "gg38.g");
    test_class_info(&lv, &cd_gg38);
    dp->~gg38();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg38(Test_gg38, "gg38", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN4gg38C1Ev();
extern void _ZN4gg38D1Ev();
Name_Map name_map_gg38[] = {
  NSPAIR(_ZN4gg38C1Ev),
  NSPAIR(_ZN4gg38D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa38;
extern VTBL_ENTRY _ZTI4aa38[];
extern  VTBL_ENTRY _ZTV4aa38[];
extern Class_Descriptor cd_bb38;
extern VTBL_ENTRY _ZTI4bb38[];
extern  VTBL_ENTRY _ZTV4bb38[];
extern Class_Descriptor cd_ee38;
extern VTBL_ENTRY _ZTI4ee38[];
extern  VTBL_ENTRY _ZTV4ee38[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee38[];
extern Class_Descriptor cd_cc38;
extern VTBL_ENTRY _ZTI4cc38[];
extern  VTBL_ENTRY _ZTV4cc38[];
extern Class_Descriptor cd_dd38;
extern VTBL_ENTRY _ZTI4dd38[];
extern  VTBL_ENTRY _ZTV4dd38[];
extern Class_Descriptor cd_ff38;
extern VTBL_ENTRY _ZTI4ff38[];
extern  VTBL_ENTRY _ZTV4ff38[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff38[];
static Base_Class bases_gg38[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa38,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_bb38,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_ee38,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc38,    ABISELECT(56,36), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_dd38,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_ff38,    ABISELECT(40,24), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4gg38[];
extern void _ZN4gg383fooEv();
extern void ABISELECT(_ZTv0_n24_N4gg383fooEv,_ZTv0_n12_N4gg383fooEv)();
extern void ABISELECT(_ZThn24_N4gg383fooEv,_ZThn16_N4gg383fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N4gg383fooEv,_ZTv0_n16_N4gg383fooEv)();
extern void ABISELECT(_ZThn40_N4gg383fooEv,_ZThn24_N4gg383fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg383fooEv,_ZTv0_n12_N4gg383fooEv)();
extern void ABISELECT(_ZThn56_N4gg383fooEv,_ZThn36_N4gg383fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg38[] = {
  ABISELECT(56,36),
  ABISELECT(40,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI4gg38[0]),
  (VTBL_ENTRY)&_ZN4gg383fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI4gg38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg383fooEv,_ZTv0_n12_N4gg383fooEv),
  ABISELECT(-40,-24),
  ABISELECT(16,12),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI4gg38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N4gg383fooEv,_ZTv0_n16_N4gg383fooEv),
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI4gg38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg383fooEv,_ZTv0_n12_N4gg383fooEv),
};
extern VTBL_ENTRY _ZTV4gg38[];
extern void _ZN4ee383fooEv();
static  VTBL_ENTRY _tg__ZTV4ee38__4gg38[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI4ee38[0]),
  (VTBL_ENTRY)&_ZN4ee383fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ee383fooEv,_ZTv0_n12_N4ee383fooEv)();
extern void ABISELECT(_ZThn24_N4ee383fooEv,_ZThn16_N4ee383fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb38__4ee38__4gg38[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI4ee38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee383fooEv,_ZTv0_n12_N4ee383fooEv),
};
extern void _ZN4ff383fooEv();
static  VTBL_ENTRY _tg__ZTV4ff38__4gg38[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff38[0]),
  (VTBL_ENTRY)&_ZN4ff383fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ff383fooEv,_ZTv0_n12_N4ff383fooEv)();
extern void ABISELECT(_ZThn16_N4ff383fooEv,_ZThn12_N4ff383fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4cc38__4ff38__4gg38[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff38[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff383fooEv,_ZTv0_n12_N4ff383fooEv),
};
static  VTT_ENTRY vtt_gg38[] = {
  {&(_ZTV4gg38[5]),  5,19},
  {&(_tg__ZTV4ee38__4gg38[3]),  3,4},
  {&(_tg__ZTV4bb38__4ee38__4gg38[3]),  3,4},
  {&(_ZTV4gg38[9]),  9,19},
  {&(_ZTV4gg38[14]),  14,19},
  {&(_ZTV4gg38[18]),  18,19},
  {&(_tg__ZTV4ff38__4gg38[3]),  3,4},
  {&(_tg__ZTV4cc38__4ff38__4gg38[3]),  3,4},
};
extern VTBL_ENTRY _ZTI4gg38[];
extern  VTBL_ENTRY _ZTV4gg38[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg38[];
static VTBL_ENTRY alt_thunk_names94[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff383fooEv,_ZTv0_n12_N4ff383fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff383fooEv,_ZThn12_N4ff383fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee383fooEv,_ZTv0_n12_N4ee383fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N4ee383fooEv,_ZThn16_N4ee383fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N4gg383fooEv,_ZTv0_n16_N4gg383fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N4gg383fooEv,_ZThn24_N4gg383fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg383fooEv,_ZTv0_n12_N4gg383fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4gg383fooEv,_ZThn36_N4gg383fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N4gg383fooEv,_ZThn16_N4gg383fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg38 = {  "gg38", // class name
  bases_gg38, 6,
  &(vtc_gg38[0]), // expected_vtbl_contents
  &(vtt_gg38[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI4gg38),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg38),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg38),8, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names94,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa39  {
  int a;
   aa39(); // _ZN4aa39C1Ev
  virtual void  foo(); // _ZN4aa393fooEv
  ~aa39(); // tgen
};
//SIG(-1 aa39) C1{ v1 Fi}


 aa39 ::aa39(){ note_ctor("aa39", this);}
void  aa39 ::foo(){vfunc_called(this, "_ZN4aa393fooEv");}
aa39 ::~aa39(){ note_dtor("aa39", this);} // tgen

static void Test_aa39()
{
  extern Class_Descriptor cd_aa39;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa39, buf);
    aa39 *dp, &lv = *(dp=new (buf) aa39());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa39)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa39.a");
    test_class_info(&lv, &cd_aa39);
    dp->~aa39();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa39(Test_aa39, "aa39", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa39C1Ev();
extern void _ZN4aa39D1Ev();
Name_Map name_map_aa39[] = {
  NSPAIR(_ZN4aa39C1Ev),
  NSPAIR(_ZN4aa39D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa39[];
extern void _ZN4aa393fooEv();
static  VTBL_ENTRY vtc_aa39[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa39[0]),
  (VTBL_ENTRY)&_ZN4aa393fooEv,
};
extern VTBL_ENTRY _ZTI4aa39[];
extern  VTBL_ENTRY _ZTV4aa39[];
Class_Descriptor cd_aa39 = {  "aa39", // class name
  0,0,//no base classes
  &(vtc_aa39[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa39),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa39),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb39  {
  int b;
   bb39(); // _ZN4bb39C1Ev
  virtual void  foo(); // _ZN4bb393fooEv
  ~bb39(); // tgen
};
//SIG(-1 bb39) C1{ v1 Fi}


 bb39 ::bb39(){ note_ctor("bb39", this);}
void  bb39 ::foo(){vfunc_called(this, "_ZN4bb393fooEv");}
bb39 ::~bb39(){ note_dtor("bb39", this);} // tgen

static void Test_bb39()
{
  extern Class_Descriptor cd_bb39;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb39, buf);
    bb39 *dp, &lv = *(dp=new (buf) bb39());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb39)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb39.b");
    test_class_info(&lv, &cd_bb39);
    dp->~bb39();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb39(Test_bb39, "bb39", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb39C1Ev();
extern void _ZN4bb39D1Ev();
Name_Map name_map_bb39[] = {
  NSPAIR(_ZN4bb39C1Ev),
  NSPAIR(_ZN4bb39D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb39[];
extern void _ZN4bb393fooEv();
static  VTBL_ENTRY vtc_bb39[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb39[0]),
  (VTBL_ENTRY)&_ZN4bb393fooEv,
};
extern VTBL_ENTRY _ZTI4bb39[];
extern  VTBL_ENTRY _ZTV4bb39[];
Class_Descriptor cd_bb39 = {  "bb39", // class name
  0,0,//no base classes
  &(vtc_bb39[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb39),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb39),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc39  {
  int c;
   cc39(); // _ZN4cc39C1Ev
  virtual void  foo(); // _ZN4cc393fooEv
  ~cc39(); // tgen
};
//SIG(-1 cc39) C1{ v1 Fi}


 cc39 ::cc39(){ note_ctor("cc39", this);}
void  cc39 ::foo(){vfunc_called(this, "_ZN4cc393fooEv");}
cc39 ::~cc39(){ note_dtor("cc39", this);} // tgen

static void Test_cc39()
{
  extern Class_Descriptor cd_cc39;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc39, buf);
    cc39 *dp, &lv = *(dp=new (buf) cc39());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc39)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc39.c");
    test_class_info(&lv, &cd_cc39);
    dp->~cc39();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc39(Test_cc39, "cc39", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc39C1Ev();
extern void _ZN4cc39D1Ev();
Name_Map name_map_cc39[] = {
  NSPAIR(_ZN4cc39C1Ev),
  NSPAIR(_ZN4cc39D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc39[];
extern void _ZN4cc393fooEv();
static  VTBL_ENTRY vtc_cc39[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc39[0]),
  (VTBL_ENTRY)&_ZN4cc393fooEv,
};
extern VTBL_ENTRY _ZTI4cc39[];
extern  VTBL_ENTRY _ZTV4cc39[];
Class_Descriptor cd_cc39 = {  "cc39", // class name
  0,0,//no base classes
  &(vtc_cc39[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc39),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc39),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd39  {
  int d;
   dd39(); // _ZN4dd39C1Ev
  virtual void  foo(); // _ZN4dd393fooEv
  ~dd39(); // tgen
};
//SIG(-1 dd39) C1{ v1 Fi}


 dd39 ::dd39(){ note_ctor("dd39", this);}
void  dd39 ::foo(){vfunc_called(this, "_ZN4dd393fooEv");}
dd39 ::~dd39(){ note_dtor("dd39", this);} // tgen

static void Test_dd39()
{
  extern Class_Descriptor cd_dd39;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd39, buf);
    dd39 *dp, &lv = *(dp=new (buf) dd39());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd39)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd39.d");
    test_class_info(&lv, &cd_dd39);
    dp->~dd39();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd39(Test_dd39, "dd39", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd39C1Ev();
extern void _ZN4dd39D1Ev();
Name_Map name_map_dd39[] = {
  NSPAIR(_ZN4dd39C1Ev),
  NSPAIR(_ZN4dd39D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd39[];
extern void _ZN4dd393fooEv();
static  VTBL_ENTRY vtc_dd39[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd39[0]),
  (VTBL_ENTRY)&_ZN4dd393fooEv,
};
extern VTBL_ENTRY _ZTI4dd39[];
extern  VTBL_ENTRY _ZTV4dd39[];
Class_Descriptor cd_dd39 = {  "dd39", // class name
  0,0,//no base classes
  &(vtc_dd39[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd39),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd39),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee39  : virtual aa39 , virtual bb39 {
  int e;
   ee39(const ABISELECT(__tsi64,int) *const *); // _ZN4ee39C2Ev
  virtual void  foo(); // _ZN4ee393fooEv
  ~ee39(); // tgen
  ee39(); // tgen
};
//SIG(-1 ee39) C1{ VBC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ee39 ::ee39(const ABISELECT(__tsi64,int) *const *){}
void  ee39 ::foo(){vfunc_called(this, "_ZN4ee393fooEv");}
ee39 ::~ee39(){ note_dtor("ee39", this);} // tgen
ee39 ::ee39(){ note_ctor("ee39", this);} // tgen

static void Test_ee39()
{
  extern Class_Descriptor cd_ee39;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_ee39, buf);
    ee39 *dp, &lv = *(dp=new (buf) ee39());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(ee39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee39)");
    check_base_class_offset(lv, (aa39*), ABISELECT(16,8), "ee39");
    check_base_class_offset(lv, (bb39*), ABISELECT(32,16), "ee39");
    check_field_offset(lv, e, ABISELECT(8,4), "ee39.e");
    test_class_info(&lv, &cd_ee39);
    dp->~ee39();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee39(Test_ee39, "ee39", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN4ee39C1Ev();
extern void _ZN4ee39D1Ev();
Name_Map name_map_ee39[] = {
  NSPAIR(_ZN4ee39C1Ev),
  NSPAIR(_ZN4ee39D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa39;
extern VTBL_ENTRY _ZTI4aa39[];
extern  VTBL_ENTRY _ZTV4aa39[];
extern Class_Descriptor cd_bb39;
extern VTBL_ENTRY _ZTI4bb39[];
extern  VTBL_ENTRY _ZTV4bb39[];
static Base_Class bases_ee39[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa39,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_bb39,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ee39[];
extern void _ZN4ee393fooEv();
extern void ABISELECT(_ZTv0_n24_N4ee393fooEv,_ZTv0_n12_N4ee393fooEv)();
extern void ABISELECT(_ZThn16_N4ee393fooEv,_ZThn8_N4ee393fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4ee393fooEv,_ZTv0_n12_N4ee393fooEv)();
extern void ABISELECT(_ZThn32_N4ee393fooEv,_ZThn16_N4ee393fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee39[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI4ee39[0]),
  (VTBL_ENTRY)&_ZN4ee393fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ee39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee393fooEv,_ZTv0_n12_N4ee393fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI4ee39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee393fooEv,_ZTv0_n12_N4ee393fooEv),
};
extern VTBL_ENTRY _ZTV4ee39[];
static  VTT_ENTRY vtt_ee39[] = {
  {&(_ZTV4ee39[4]),  4,13},
  {&(_ZTV4ee39[8]),  8,13},
  {&(_ZTV4ee39[12]),  12,13},
};
extern VTBL_ENTRY _ZTI4ee39[];
extern  VTBL_ENTRY _ZTV4ee39[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee39[];
static VTBL_ENTRY alt_thunk_names95[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee393fooEv,_ZTv0_n12_N4ee393fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ee393fooEv,_ZThn16_N4ee393fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee393fooEv,_ZThn8_N4ee393fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee39 = {  "ee39", // class name
  bases_ee39, 2,
  &(vtc_ee39[0]), // expected_vtbl_contents
  &(vtt_ee39[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI4ee39),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee39),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ee39),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names95,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff39  : virtual cc39 , dd39 {
  int f;
   ff39(const ABISELECT(__tsi64,int) *const *); // _ZN4ff39C2Ev
  virtual void  foo(); // _ZN4ff393fooEv
  ~ff39(); // tgen
  ff39(); // tgen
};
//SIG(-1 ff39) C1{ VBC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ff39 ::ff39(const ABISELECT(__tsi64,int) *const *){}
void  ff39 ::foo(){vfunc_called(this, "_ZN4ff393fooEv");}
ff39 ::~ff39(){ note_dtor("ff39", this);} // tgen
ff39 ::ff39(){ note_ctor("ff39", this);} // tgen

static void Test_ff39()
{
  extern Class_Descriptor cd_ff39;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff39, buf);
    ff39 *dp, &lv = *(dp=new (buf) ff39());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff39)");
    check_base_class_offset(lv, (cc39*), ABISELECT(16,12), "ff39");
    check_base_class_offset(lv, (dd39*), 0, "ff39");
    check_field_offset(lv, f, ABISELECT(12,8), "ff39.f");
    test_class_info(&lv, &cd_ff39);
    dp->~ff39();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff39(Test_ff39, "ff39", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ff39C1Ev();
extern void _ZN4ff39D1Ev();
Name_Map name_map_ff39[] = {
  NSPAIR(_ZN4ff39C1Ev),
  NSPAIR(_ZN4ff39D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc39;
extern VTBL_ENTRY _ZTI4cc39[];
extern  VTBL_ENTRY _ZTV4cc39[];
extern Class_Descriptor cd_dd39;
extern VTBL_ENTRY _ZTI4dd39[];
extern  VTBL_ENTRY _ZTV4dd39[];
static Base_Class bases_ff39[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc39,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_dd39,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ff39[];
extern void _ZN4ff393fooEv();
extern void ABISELECT(_ZTv0_n24_N4ff393fooEv,_ZTv0_n12_N4ff393fooEv)();
extern void ABISELECT(_ZThn16_N4ff393fooEv,_ZThn12_N4ff393fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff39[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff39[0]),
  (VTBL_ENTRY)&_ZN4ff393fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff393fooEv,_ZTv0_n12_N4ff393fooEv),
};
extern VTBL_ENTRY _ZTV4ff39[];
static  VTT_ENTRY vtt_ff39[] = {
  {&(_ZTV4ff39[3]),  3,8},
  {&(_ZTV4ff39[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ff39[];
extern  VTBL_ENTRY _ZTV4ff39[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff39[];
static VTBL_ENTRY alt_thunk_names96[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff393fooEv,_ZTv0_n12_N4ff393fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff393fooEv,_ZThn12_N4ff393fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff39 = {  "ff39", // class name
  bases_ff39, 2,
  &(vtc_ff39[0]), // expected_vtbl_contents
  &(vtt_ff39[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ff39),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff39),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ff39),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names96,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg39  : ee39 , virtual ff39 {
  int g;
   gg39(const ABISELECT(__tsi64,int) *const *); // _ZN4gg39C2Ev
  virtual void  foo(); // _ZN4gg393fooEv
  ~gg39(); // tgen
  gg39(); // tgen
};
//SIG(1 gg39) C1{ BC2{ VBC3{ v1 Fi} VBC4{ v1 Fi} v1 Fi} VBC5{ VBC6{ v1 Fi} BC7{ v1 Fi} v1 Fi} v1 Fi}


 gg39 ::gg39(const ABISELECT(__tsi64,int) *const *){}
void  gg39 ::foo(){vfunc_called(this, "_ZN4gg393fooEv");}
gg39 ::~gg39(){ note_dtor("gg39", this);} // tgen
gg39 ::gg39(){ note_ctor("gg39", this);} // tgen

static void Test_gg39()
{
  extern Class_Descriptor cd_gg39;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,13)];
    init_test(&cd_gg39, buf);
    gg39 *dp, &lv = *(dp=new (buf) gg39());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,48), "sizeof(gg39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg39)");
    check_base_class_offset(lv, (aa39*)(ee39*), ABISELECT(16,12), "gg39");
    check_base_class_offset(lv, (bb39*)(ee39*), ABISELECT(32,20), "gg39");
    check_base_class_offset(lv, (ee39*), 0, "gg39");
    check_base_class_offset(lv, (cc39*)(ff39*), ABISELECT(64,40), "gg39");
    check_base_class_offset(lv, (dd39*)(ff39*), ABISELECT(48,28), "gg39");
    check_base_class_offset(lv, (ff39*), ABISELECT(48,28), "gg39");
    check_field_offset(lv, g, ABISELECT(12,8), "gg39.g");
    test_class_info(&lv, &cd_gg39);
    dp->~gg39();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg39(Test_gg39, "gg39", ABISELECT(80,48));

#else // __cplusplus

extern void _ZN4gg39C1Ev();
extern void _ZN4gg39D1Ev();
Name_Map name_map_gg39[] = {
  NSPAIR(_ZN4gg39C1Ev),
  NSPAIR(_ZN4gg39D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa39;
extern VTBL_ENTRY _ZTI4aa39[];
extern  VTBL_ENTRY _ZTV4aa39[];
extern Class_Descriptor cd_bb39;
extern VTBL_ENTRY _ZTI4bb39[];
extern  VTBL_ENTRY _ZTV4bb39[];
extern Class_Descriptor cd_ee39;
extern VTBL_ENTRY _ZTI4ee39[];
extern  VTBL_ENTRY _ZTV4ee39[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee39[];
extern Class_Descriptor cd_cc39;
extern VTBL_ENTRY _ZTI4cc39[];
extern  VTBL_ENTRY _ZTV4cc39[];
extern Class_Descriptor cd_dd39;
extern VTBL_ENTRY _ZTI4dd39[];
extern  VTBL_ENTRY _ZTV4dd39[];
extern Class_Descriptor cd_ff39;
extern VTBL_ENTRY _ZTI4ff39[];
extern  VTBL_ENTRY _ZTV4ff39[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff39[];
static Base_Class bases_gg39[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa39,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_bb39,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_ee39,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc39,    ABISELECT(64,40), //bcp->offset
    20, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_dd39,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_ff39,    ABISELECT(48,28), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4gg39[];
extern void _ZN4gg393fooEv();
extern void ABISELECT(_ZTv0_n24_N4gg393fooEv,_ZTv0_n12_N4gg393fooEv)();
extern void ABISELECT(_ZThn16_N4gg393fooEv,_ZThn12_N4gg393fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg393fooEv,_ZTv0_n12_N4gg393fooEv)();
extern void ABISELECT(_ZThn32_N4gg393fooEv,_ZThn20_N4gg393fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N4gg393fooEv,_ZTv0_n16_N4gg393fooEv)();
extern void ABISELECT(_ZThn48_N4gg393fooEv,_ZThn28_N4gg393fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg393fooEv,_ZTv0_n12_N4gg393fooEv)();
extern void ABISELECT(_ZThn64_N4gg393fooEv,_ZThn40_N4gg393fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg39[] = {
  ABISELECT(64,40),
  ABISELECT(48,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4gg39[0]),
  (VTBL_ENTRY)&_ZN4gg393fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4gg39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg393fooEv,_ZTv0_n12_N4gg393fooEv),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI4gg39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg393fooEv,_ZTv0_n12_N4gg393fooEv),
  ABISELECT(-48,-28),
  ABISELECT(16,12),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI4gg39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N4gg393fooEv,_ZTv0_n16_N4gg393fooEv),
  ABISELECT(-64,-40),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI4gg39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg393fooEv,_ZTv0_n12_N4gg393fooEv),
};
extern VTBL_ENTRY _ZTV4gg39[];
extern void _ZN4ee393fooEv();
static  VTBL_ENTRY _tg__ZTV4ee39__4gg39[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee39[0]),
  (VTBL_ENTRY)&_ZN4ee393fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ee393fooEv,_ZTv0_n12_N4ee393fooEv)();
extern void ABISELECT(_ZThn16_N4ee393fooEv,_ZThn12_N4ee393fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4aa39__4ee39__4gg39[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee393fooEv,_ZTv0_n12_N4ee393fooEv),
};
extern void ABISELECT(_ZTv0_n24_N4ee393fooEv,_ZTv0_n12_N4ee393fooEv)();
extern void ABISELECT(_ZThn32_N4ee393fooEv,_ZThn20_N4ee393fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb39__4ee39__4gg39[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI4ee39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee393fooEv,_ZTv0_n12_N4ee393fooEv),
};
extern void _ZN4ff393fooEv();
static  VTBL_ENTRY _tg__ZTV4ff39__4gg39[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff39[0]),
  (VTBL_ENTRY)&_ZN4ff393fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ff393fooEv,_ZTv0_n12_N4ff393fooEv)();
extern void ABISELECT(_ZThn16_N4ff393fooEv,_ZThn12_N4ff393fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4cc39__4ff39__4gg39[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff39[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff393fooEv,_ZTv0_n12_N4ff393fooEv),
};
static  VTT_ENTRY vtt_gg39[] = {
  {&(_ZTV4gg39[6]),  6,24},
  {&(_tg__ZTV4ee39__4gg39[4]),  4,5},
  {&(_tg__ZTV4aa39__4ee39__4gg39[3]),  3,4},
  {&(_tg__ZTV4bb39__4ee39__4gg39[3]),  3,4},
  {&(_ZTV4gg39[10]),  10,24},
  {&(_ZTV4gg39[14]),  14,24},
  {&(_ZTV4gg39[19]),  19,24},
  {&(_ZTV4gg39[23]),  23,24},
  {&(_tg__ZTV4ff39__4gg39[3]),  3,4},
  {&(_tg__ZTV4cc39__4ff39__4gg39[3]),  3,4},
};
extern VTBL_ENTRY _ZTI4gg39[];
extern  VTBL_ENTRY _ZTV4gg39[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg39[];
static VTBL_ENTRY alt_thunk_names97[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff393fooEv,_ZTv0_n12_N4ff393fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff393fooEv,_ZThn12_N4ff393fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee393fooEv,_ZTv0_n12_N4ee393fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ee393fooEv,_ZThn20_N4ee393fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee393fooEv,_ZThn12_N4ee393fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N4gg393fooEv,_ZTv0_n16_N4gg393fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N4gg393fooEv,_ZThn28_N4gg393fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg393fooEv,_ZTv0_n12_N4gg393fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N4gg393fooEv,_ZThn40_N4gg393fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4gg393fooEv,_ZThn20_N4gg393fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4gg393fooEv,_ZThn12_N4gg393fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg39 = {  "gg39", // class name
  bases_gg39, 6,
  &(vtc_gg39[0]), // expected_vtbl_contents
  &(vtt_gg39[0]), // expected_vtt_contents
  ABISELECT(80,48), // object size
  NSPAIRA(_ZTI4gg39),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg39),24, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg39),10, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names97,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa40  {
  int a;
   aa40(); // _ZN4aa40C1Ev
  virtual void  foo(); // _ZN4aa403fooEv
  ~aa40(); // tgen
};
//SIG(-1 aa40) C1{ v1 Fi}


 aa40 ::aa40(){ note_ctor("aa40", this);}
void  aa40 ::foo(){vfunc_called(this, "_ZN4aa403fooEv");}
aa40 ::~aa40(){ note_dtor("aa40", this);} // tgen

static void Test_aa40()
{
  extern Class_Descriptor cd_aa40;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa40, buf);
    aa40 *dp, &lv = *(dp=new (buf) aa40());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa40)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa40.a");
    test_class_info(&lv, &cd_aa40);
    dp->~aa40();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa40(Test_aa40, "aa40", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa40C1Ev();
extern void _ZN4aa40D1Ev();
Name_Map name_map_aa40[] = {
  NSPAIR(_ZN4aa40C1Ev),
  NSPAIR(_ZN4aa40D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa40[];
extern void _ZN4aa403fooEv();
static  VTBL_ENTRY vtc_aa40[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa40[0]),
  (VTBL_ENTRY)&_ZN4aa403fooEv,
};
extern VTBL_ENTRY _ZTI4aa40[];
extern  VTBL_ENTRY _ZTV4aa40[];
Class_Descriptor cd_aa40 = {  "aa40", // class name
  0,0,//no base classes
  &(vtc_aa40[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa40),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa40),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb40  {
  int b;
   bb40(); // _ZN4bb40C1Ev
  virtual void  foo(); // _ZN4bb403fooEv
  ~bb40(); // tgen
};
//SIG(-1 bb40) C1{ v1 Fi}


 bb40 ::bb40(){ note_ctor("bb40", this);}
void  bb40 ::foo(){vfunc_called(this, "_ZN4bb403fooEv");}
bb40 ::~bb40(){ note_dtor("bb40", this);} // tgen

static void Test_bb40()
{
  extern Class_Descriptor cd_bb40;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb40, buf);
    bb40 *dp, &lv = *(dp=new (buf) bb40());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb40)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb40.b");
    test_class_info(&lv, &cd_bb40);
    dp->~bb40();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb40(Test_bb40, "bb40", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb40C1Ev();
extern void _ZN4bb40D1Ev();
Name_Map name_map_bb40[] = {
  NSPAIR(_ZN4bb40C1Ev),
  NSPAIR(_ZN4bb40D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb40[];
extern void _ZN4bb403fooEv();
static  VTBL_ENTRY vtc_bb40[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb40[0]),
  (VTBL_ENTRY)&_ZN4bb403fooEv,
};
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
Class_Descriptor cd_bb40 = {  "bb40", // class name
  0,0,//no base classes
  &(vtc_bb40[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb40),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb40),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc40  {
  int c;
   cc40(); // _ZN4cc40C1Ev
  virtual void  foo(); // _ZN4cc403fooEv
  ~cc40(); // tgen
};
//SIG(-1 cc40) C1{ v1 Fi}


 cc40 ::cc40(){ note_ctor("cc40", this);}
void  cc40 ::foo(){vfunc_called(this, "_ZN4cc403fooEv");}
cc40 ::~cc40(){ note_dtor("cc40", this);} // tgen

static void Test_cc40()
{
  extern Class_Descriptor cd_cc40;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc40, buf);
    cc40 *dp, &lv = *(dp=new (buf) cc40());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc40)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc40.c");
    test_class_info(&lv, &cd_cc40);
    dp->~cc40();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc40(Test_cc40, "cc40", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc40C1Ev();
extern void _ZN4cc40D1Ev();
Name_Map name_map_cc40[] = {
  NSPAIR(_ZN4cc40C1Ev),
  NSPAIR(_ZN4cc40D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc40[];
extern void _ZN4cc403fooEv();
static  VTBL_ENTRY vtc_cc40[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc40[0]),
  (VTBL_ENTRY)&_ZN4cc403fooEv,
};
extern VTBL_ENTRY _ZTI4cc40[];
extern  VTBL_ENTRY _ZTV4cc40[];
Class_Descriptor cd_cc40 = {  "cc40", // class name
  0,0,//no base classes
  &(vtc_cc40[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc40),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc40),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd40  {
  int d;
   dd40(); // _ZN4dd40C1Ev
  virtual void  foo(); // _ZN4dd403fooEv
  ~dd40(); // tgen
};
//SIG(-1 dd40) C1{ v1 Fi}


 dd40 ::dd40(){ note_ctor("dd40", this);}
void  dd40 ::foo(){vfunc_called(this, "_ZN4dd403fooEv");}
dd40 ::~dd40(){ note_dtor("dd40", this);} // tgen

static void Test_dd40()
{
  extern Class_Descriptor cd_dd40;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd40, buf);
    dd40 *dp, &lv = *(dp=new (buf) dd40());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd40)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd40.d");
    test_class_info(&lv, &cd_dd40);
    dp->~dd40();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd40(Test_dd40, "dd40", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd40C1Ev();
extern void _ZN4dd40D1Ev();
Name_Map name_map_dd40[] = {
  NSPAIR(_ZN4dd40C1Ev),
  NSPAIR(_ZN4dd40D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd40[];
extern void _ZN4dd403fooEv();
static  VTBL_ENTRY vtc_dd40[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd40[0]),
  (VTBL_ENTRY)&_ZN4dd403fooEv,
};
extern VTBL_ENTRY _ZTI4dd40[];
extern  VTBL_ENTRY _ZTV4dd40[];
Class_Descriptor cd_dd40 = {  "dd40", // class name
  0,0,//no base classes
  &(vtc_dd40[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd40),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd40),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee40  : aa40 , bb40 {
  int e;
   ee40(); // _ZN4ee40C1Ev
  virtual void  foo(); // _ZN4ee403fooEv
  ~ee40(); // tgen
};
//SIG(-1 ee40) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ee40 ::ee40(){ note_ctor("ee40", this);}
void  ee40 ::foo(){vfunc_called(this, "_ZN4ee403fooEv");}
ee40 ::~ee40(){ note_dtor("ee40", this);} // tgen

static void Test_ee40()
{
  extern Class_Descriptor cd_ee40;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee40, buf);
    ee40 *dp, &lv = *(dp=new (buf) ee40());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee40)");
    check_base_class_offset(lv, (aa40*), 0, "ee40");
    check_base_class_offset(lv, (bb40*), ABISELECT(16,8), "ee40");
    check_field_offset(lv, e, ABISELECT(28,16), "ee40.e");
    test_class_info(&lv, &cd_ee40);
    dp->~ee40();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee40(Test_ee40, "ee40", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ee40C1Ev();
extern void _ZN4ee40D1Ev();
Name_Map name_map_ee40[] = {
  NSPAIR(_ZN4ee40C1Ev),
  NSPAIR(_ZN4ee40D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa40;
extern VTBL_ENTRY _ZTI4aa40[];
extern  VTBL_ENTRY _ZTV4aa40[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
static Base_Class bases_ee40[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ee40[];
extern void _ZN4ee403fooEv();
extern void ABISELECT(_ZThn16_N4ee403fooEv,_ZThn8_N4ee403fooEv)();
static  VTBL_ENTRY vtc_ee40[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4ee40[0]),
  (VTBL_ENTRY)&_ZN4ee403fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ee40[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4ee403fooEv,_ZThn8_N4ee403fooEv),
};
extern VTBL_ENTRY _ZTI4ee40[];
extern  VTBL_ENTRY _ZTV4ee40[];
Class_Descriptor cd_ee40 = {  "ee40", // class name
  bases_ee40, 2,
  &(vtc_ee40[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ee40),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee40),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff40  : cc40 , virtual dd40 {
  int f;
   ff40(const ABISELECT(__tsi64,int) *const *); // _ZN4ff40C2Ev
  virtual void  foo(); // _ZN4ff403fooEv
  ~ff40(); // tgen
  ff40(); // tgen
};
//SIG(-1 ff40) C1{ BC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ff40 ::ff40(const ABISELECT(__tsi64,int) *const *){}
void  ff40 ::foo(){vfunc_called(this, "_ZN4ff403fooEv");}
ff40 ::~ff40(){ note_dtor("ff40", this);} // tgen
ff40 ::ff40(){ note_ctor("ff40", this);} // tgen

static void Test_ff40()
{
  extern Class_Descriptor cd_ff40;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff40, buf);
    ff40 *dp, &lv = *(dp=new (buf) ff40());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff40)");
    check_base_class_offset(lv, (cc40*), 0, "ff40");
    check_base_class_offset(lv, (dd40*), ABISELECT(16,12), "ff40");
    check_field_offset(lv, f, ABISELECT(12,8), "ff40.f");
    test_class_info(&lv, &cd_ff40);
    dp->~ff40();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff40(Test_ff40, "ff40", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ff40C1Ev();
extern void _ZN4ff40D1Ev();
Name_Map name_map_ff40[] = {
  NSPAIR(_ZN4ff40C1Ev),
  NSPAIR(_ZN4ff40D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc40;
extern VTBL_ENTRY _ZTI4cc40[];
extern  VTBL_ENTRY _ZTV4cc40[];
extern Class_Descriptor cd_dd40;
extern VTBL_ENTRY _ZTI4dd40[];
extern  VTBL_ENTRY _ZTV4dd40[];
static Base_Class bases_ff40[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_dd40,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ff40[];
extern void _ZN4ff403fooEv();
extern void ABISELECT(_ZTv0_n24_N4ff403fooEv,_ZTv0_n12_N4ff403fooEv)();
extern void ABISELECT(_ZThn16_N4ff403fooEv,_ZThn12_N4ff403fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff40[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff40[0]),
  (VTBL_ENTRY)&_ZN4ff403fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff40[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff403fooEv,_ZTv0_n12_N4ff403fooEv),
};
extern VTBL_ENTRY _ZTV4ff40[];
static  VTT_ENTRY vtt_ff40[] = {
  {&(_ZTV4ff40[3]),  3,8},
  {&(_ZTV4ff40[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ff40[];
extern  VTBL_ENTRY _ZTV4ff40[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff40[];
static VTBL_ENTRY alt_thunk_names98[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff403fooEv,_ZTv0_n12_N4ff403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff403fooEv,_ZThn12_N4ff403fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff40 = {  "ff40", // class name
  bases_ff40, 2,
  &(vtc_ff40[0]), // expected_vtbl_contents
  &(vtt_ff40[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ff40),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff40),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ff40),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names98,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg40  : ee40 , virtual ff40 {
  int g;
   gg40(const ABISELECT(__tsi64,int) *const *); // _ZN4gg40C2Ev
  virtual void  foo(); // _ZN4gg403fooEv
  ~gg40(); // tgen
  gg40(); // tgen
};
//SIG(1 gg40) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} VBC5{ BC6{ v1 Fi} VBC7{ v1 Fi} v1 Fi} v1 Fi}


 gg40 ::gg40(const ABISELECT(__tsi64,int) *const *){}
void  gg40 ::foo(){vfunc_called(this, "_ZN4gg403fooEv");}
gg40 ::~gg40(){ note_dtor("gg40", this);} // tgen
gg40 ::gg40(){ note_ctor("gg40", this);} // tgen

static void Test_gg40()
{
  extern Class_Descriptor cd_gg40;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg40, buf);
    gg40 *dp, &lv = *(dp=new (buf) gg40());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg40)");
    check_base_class_offset(lv, (aa40*)(ee40*), 0, "gg40");
    check_base_class_offset(lv, (bb40*)(ee40*), ABISELECT(16,8), "gg40");
    check_base_class_offset(lv, (ee40*), 0, "gg40");
    check_base_class_offset(lv, (cc40*)(ff40*), ABISELECT(40,24), "gg40");
    check_base_class_offset(lv, (dd40*)(ff40*), ABISELECT(56,36), "gg40");
    check_base_class_offset(lv, (ff40*), ABISELECT(40,24), "gg40");
    check_field_offset(lv, g, ABISELECT(32,20), "gg40.g");
    test_class_info(&lv, &cd_gg40);
    dp->~gg40();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg40(Test_gg40, "gg40", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN4gg40C1Ev();
extern void _ZN4gg40D1Ev();
Name_Map name_map_gg40[] = {
  NSPAIR(_ZN4gg40C1Ev),
  NSPAIR(_ZN4gg40D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa40;
extern VTBL_ENTRY _ZTI4aa40[];
extern  VTBL_ENTRY _ZTV4aa40[];
extern Class_Descriptor cd_bb40;
extern VTBL_ENTRY _ZTI4bb40[];
extern  VTBL_ENTRY _ZTV4bb40[];
extern Class_Descriptor cd_ee40;
extern VTBL_ENTRY _ZTI4ee40[];
extern  VTBL_ENTRY _ZTV4ee40[];
extern Class_Descriptor cd_cc40;
extern VTBL_ENTRY _ZTI4cc40[];
extern  VTBL_ENTRY _ZTV4cc40[];
extern Class_Descriptor cd_dd40;
extern VTBL_ENTRY _ZTI4dd40[];
extern  VTBL_ENTRY _ZTV4dd40[];
extern Class_Descriptor cd_ff40;
extern VTBL_ENTRY _ZTI4ff40[];
extern  VTBL_ENTRY _ZTV4ff40[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff40[];
static Base_Class bases_gg40[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_bb40,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_ee40,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc40,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_dd40,    ABISELECT(56,36), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_ff40,    ABISELECT(40,24), //bcp->offset
    8, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4gg40[];
extern void _ZN4gg403fooEv();
extern void ABISELECT(_ZThn16_N4gg403fooEv,_ZThn8_N4gg403fooEv)();
extern void ABISELECT(_ZTv0_n32_N4gg403fooEv,_ZTv0_n16_N4gg403fooEv)();
extern void ABISELECT(_ZThn40_N4gg403fooEv,_ZThn24_N4gg403fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg403fooEv,_ZTv0_n12_N4gg403fooEv)();
extern void ABISELECT(_ZThn56_N4gg403fooEv,_ZThn36_N4gg403fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg40[] = {
  ABISELECT(56,36),
  ABISELECT(40,24),
  0,
  (VTBL_ENTRY)&(_ZTI4gg40[0]),
  (VTBL_ENTRY)&_ZN4gg403fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4gg40[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N4gg403fooEv,_ZThn8_N4gg403fooEv),
  ABISELECT(-40,-24),
  ABISELECT(16,12),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI4gg40[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N4gg403fooEv,_ZTv0_n16_N4gg403fooEv),
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI4gg40[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg403fooEv,_ZTv0_n12_N4gg403fooEv),
};
extern VTBL_ENTRY _ZTV4gg40[];
extern void _ZN4ff403fooEv();
static  VTBL_ENTRY _tg__ZTV4ff40__4gg40[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff40[0]),
  (VTBL_ENTRY)&_ZN4ff403fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ff403fooEv,_ZTv0_n12_N4ff403fooEv)();
extern void ABISELECT(_ZThn16_N4ff403fooEv,_ZThn12_N4ff403fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4dd40__4ff40__4gg40[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff40[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff403fooEv,_ZTv0_n12_N4ff403fooEv),
};
static  VTT_ENTRY vtt_gg40[] = {
  {&(_ZTV4gg40[4]),  4,17},
  {&(_ZTV4gg40[12]),  12,17},
  {&(_ZTV4gg40[16]),  16,17},
  {&(_tg__ZTV4ff40__4gg40[3]),  3,4},
  {&(_tg__ZTV4dd40__4ff40__4gg40[3]),  3,4},
};
extern VTBL_ENTRY _ZTI4gg40[];
extern  VTBL_ENTRY _ZTV4gg40[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg40[];
static VTBL_ENTRY alt_thunk_names99[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff403fooEv,_ZTv0_n12_N4ff403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff403fooEv,_ZThn12_N4ff403fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg403fooEv,_ZTv0_n12_N4gg403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4gg403fooEv,_ZThn36_N4gg403fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N4gg403fooEv,_ZTv0_n16_N4gg403fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N4gg403fooEv,_ZThn24_N4gg403fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg40 = {  "gg40", // class name
  bases_gg40, 6,
  &(vtc_gg40[0]), // expected_vtbl_contents
  &(vtt_gg40[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI4gg40),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg40),17, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg40),5, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names99,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa41  {
  int a;
   aa41(); // _ZN4aa41C1Ev
  virtual void  foo(); // _ZN4aa413fooEv
  ~aa41(); // tgen
};
//SIG(-1 aa41) C1{ v1 Fi}


 aa41 ::aa41(){ note_ctor("aa41", this);}
void  aa41 ::foo(){vfunc_called(this, "_ZN4aa413fooEv");}
aa41 ::~aa41(){ note_dtor("aa41", this);} // tgen

static void Test_aa41()
{
  extern Class_Descriptor cd_aa41;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa41, buf);
    aa41 *dp, &lv = *(dp=new (buf) aa41());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa41)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa41.a");
    test_class_info(&lv, &cd_aa41);
    dp->~aa41();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa41(Test_aa41, "aa41", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa41C1Ev();
extern void _ZN4aa41D1Ev();
Name_Map name_map_aa41[] = {
  NSPAIR(_ZN4aa41C1Ev),
  NSPAIR(_ZN4aa41D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa41[];
extern void _ZN4aa413fooEv();
static  VTBL_ENTRY vtc_aa41[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa41[0]),
  (VTBL_ENTRY)&_ZN4aa413fooEv,
};
extern VTBL_ENTRY _ZTI4aa41[];
extern  VTBL_ENTRY _ZTV4aa41[];
Class_Descriptor cd_aa41 = {  "aa41", // class name
  0,0,//no base classes
  &(vtc_aa41[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa41),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa41),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb41  {
  int b;
   bb41(); // _ZN4bb41C1Ev
  virtual void  foo(); // _ZN4bb413fooEv
  ~bb41(); // tgen
};
//SIG(-1 bb41) C1{ v1 Fi}


 bb41 ::bb41(){ note_ctor("bb41", this);}
void  bb41 ::foo(){vfunc_called(this, "_ZN4bb413fooEv");}
bb41 ::~bb41(){ note_dtor("bb41", this);} // tgen

static void Test_bb41()
{
  extern Class_Descriptor cd_bb41;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb41, buf);
    bb41 *dp, &lv = *(dp=new (buf) bb41());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb41)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb41.b");
    test_class_info(&lv, &cd_bb41);
    dp->~bb41();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb41(Test_bb41, "bb41", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb41C1Ev();
extern void _ZN4bb41D1Ev();
Name_Map name_map_bb41[] = {
  NSPAIR(_ZN4bb41C1Ev),
  NSPAIR(_ZN4bb41D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb41[];
extern void _ZN4bb413fooEv();
static  VTBL_ENTRY vtc_bb41[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb41[0]),
  (VTBL_ENTRY)&_ZN4bb413fooEv,
};
extern VTBL_ENTRY _ZTI4bb41[];
extern  VTBL_ENTRY _ZTV4bb41[];
Class_Descriptor cd_bb41 = {  "bb41", // class name
  0,0,//no base classes
  &(vtc_bb41[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb41),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb41),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc41  {
  int c;
   cc41(); // _ZN4cc41C1Ev
  virtual void  foo(); // _ZN4cc413fooEv
  ~cc41(); // tgen
};
//SIG(-1 cc41) C1{ v1 Fi}


 cc41 ::cc41(){ note_ctor("cc41", this);}
void  cc41 ::foo(){vfunc_called(this, "_ZN4cc413fooEv");}
cc41 ::~cc41(){ note_dtor("cc41", this);} // tgen

static void Test_cc41()
{
  extern Class_Descriptor cd_cc41;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc41, buf);
    cc41 *dp, &lv = *(dp=new (buf) cc41());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc41)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc41.c");
    test_class_info(&lv, &cd_cc41);
    dp->~cc41();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc41(Test_cc41, "cc41", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc41C1Ev();
extern void _ZN4cc41D1Ev();
Name_Map name_map_cc41[] = {
  NSPAIR(_ZN4cc41C1Ev),
  NSPAIR(_ZN4cc41D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc41[];
extern void _ZN4cc413fooEv();
static  VTBL_ENTRY vtc_cc41[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc41[0]),
  (VTBL_ENTRY)&_ZN4cc413fooEv,
};
extern VTBL_ENTRY _ZTI4cc41[];
extern  VTBL_ENTRY _ZTV4cc41[];
Class_Descriptor cd_cc41 = {  "cc41", // class name
  0,0,//no base classes
  &(vtc_cc41[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc41),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc41),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd41  {
  int d;
   dd41(); // _ZN4dd41C1Ev
  virtual void  foo(); // _ZN4dd413fooEv
  ~dd41(); // tgen
};
//SIG(-1 dd41) C1{ v1 Fi}


 dd41 ::dd41(){ note_ctor("dd41", this);}
void  dd41 ::foo(){vfunc_called(this, "_ZN4dd413fooEv");}
dd41 ::~dd41(){ note_dtor("dd41", this);} // tgen

static void Test_dd41()
{
  extern Class_Descriptor cd_dd41;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd41, buf);
    dd41 *dp, &lv = *(dp=new (buf) dd41());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd41)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd41.d");
    test_class_info(&lv, &cd_dd41);
    dp->~dd41();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd41(Test_dd41, "dd41", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd41C1Ev();
extern void _ZN4dd41D1Ev();
Name_Map name_map_dd41[] = {
  NSPAIR(_ZN4dd41C1Ev),
  NSPAIR(_ZN4dd41D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd41[];
extern void _ZN4dd413fooEv();
static  VTBL_ENTRY vtc_dd41[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd41[0]),
  (VTBL_ENTRY)&_ZN4dd413fooEv,
};
extern VTBL_ENTRY _ZTI4dd41[];
extern  VTBL_ENTRY _ZTV4dd41[];
Class_Descriptor cd_dd41 = {  "dd41", // class name
  0,0,//no base classes
  &(vtc_dd41[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd41),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd41),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee41  : virtual aa41 , bb41 {
  int e;
   ee41(const ABISELECT(__tsi64,int) *const *); // _ZN4ee41C2Ev
  virtual void  foo(); // _ZN4ee413fooEv
  ~ee41(); // tgen
  ee41(); // tgen
};
//SIG(-1 ee41) C1{ VBC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}


 ee41 ::ee41(const ABISELECT(__tsi64,int) *const *){}
void  ee41 ::foo(){vfunc_called(this, "_ZN4ee413fooEv");}
ee41 ::~ee41(){ note_dtor("ee41", this);} // tgen
ee41 ::ee41(){ note_ctor("ee41", this);} // tgen

static void Test_ee41()
{
  extern Class_Descriptor cd_ee41;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee41, buf);
    ee41 *dp, &lv = *(dp=new (buf) ee41());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee41)");
    check_base_class_offset(lv, (aa41*), ABISELECT(16,12), "ee41");
    check_base_class_offset(lv, (bb41*), 0, "ee41");
    check_field_offset(lv, e, ABISELECT(12,8), "ee41.e");
    test_class_info(&lv, &cd_ee41);
    dp->~ee41();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee41(Test_ee41, "ee41", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ee41C1Ev();
extern void _ZN4ee41D1Ev();
Name_Map name_map_ee41[] = {
  NSPAIR(_ZN4ee41C1Ev),
  NSPAIR(_ZN4ee41D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa41;
extern VTBL_ENTRY _ZTI4aa41[];
extern  VTBL_ENTRY _ZTV4aa41[];
extern Class_Descriptor cd_bb41;
extern VTBL_ENTRY _ZTI4bb41[];
extern  VTBL_ENTRY _ZTV4bb41[];
static Base_Class bases_ee41[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa41,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_bb41,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4ee41[];
extern void _ZN4ee413fooEv();
extern void ABISELECT(_ZTv0_n24_N4ee413fooEv,_ZTv0_n12_N4ee413fooEv)();
extern void ABISELECT(_ZThn16_N4ee413fooEv,_ZThn12_N4ee413fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee41[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee41[0]),
  (VTBL_ENTRY)&_ZN4ee413fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee41[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee413fooEv,_ZTv0_n12_N4ee413fooEv),
};
extern VTBL_ENTRY _ZTV4ee41[];
static  VTT_ENTRY vtt_ee41[] = {
  {&(_ZTV4ee41[3]),  3,8},
  {&(_ZTV4ee41[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ee41[];
extern  VTBL_ENTRY _ZTV4ee41[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee41[];
static VTBL_ENTRY alt_thunk_names100[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee413fooEv,_ZTv0_n12_N4ee413fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee413fooEv,_ZThn12_N4ee413fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee41 = {  "ee41", // class name
  bases_ee41, 2,
  &(vtc_ee41[0]), // expected_vtbl_contents
  &(vtt_ee41[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ee41),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee41),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ee41),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names100,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff41  : cc41 , virtual dd41 {
  int f;
   ff41(const ABISELECT(__tsi64,int) *const *); // _ZN4ff41C2Ev
  virtual void  foo(); // _ZN4ff413fooEv
  ~ff41(); // tgen
  ff41(); // tgen
};
//SIG(-1 ff41) C1{ BC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ff41 ::ff41(const ABISELECT(__tsi64,int) *const *){}
void  ff41 ::foo(){vfunc_called(this, "_ZN4ff413fooEv");}
ff41 ::~ff41(){ note_dtor("ff41", this);} // tgen
ff41 ::ff41(){ note_ctor("ff41", this);} // tgen

static void Test_ff41()
{
  extern Class_Descriptor cd_ff41;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff41, buf);
    ff41 *dp, &lv = *(dp=new (buf) ff41());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff41)");
    check_base_class_offset(lv, (cc41*), 0, "ff41");
    check_base_class_offset(lv, (dd41*), ABISELECT(16,12), "ff41");
    check_field_offset(lv, f, ABISELECT(12,8), "ff41.f");
    test_class_info(&lv, &cd_ff41);
    dp->~ff41();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff41(Test_ff41, "ff41", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ff41C1Ev();
extern void _ZN4ff41D1Ev();
Name_Map name_map_ff41[] = {
  NSPAIR(_ZN4ff41C1Ev),
  NSPAIR(_ZN4ff41D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc41;
extern VTBL_ENTRY _ZTI4cc41[];
extern  VTBL_ENTRY _ZTV4cc41[];
extern Class_Descriptor cd_dd41;
extern VTBL_ENTRY _ZTI4dd41[];
extern  VTBL_ENTRY _ZTV4dd41[];
static Base_Class bases_ff41[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc41,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_dd41,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ff41[];
extern void _ZN4ff413fooEv();
extern void ABISELECT(_ZTv0_n24_N4ff413fooEv,_ZTv0_n12_N4ff413fooEv)();
extern void ABISELECT(_ZThn16_N4ff413fooEv,_ZThn12_N4ff413fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff41[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff41[0]),
  (VTBL_ENTRY)&_ZN4ff413fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff41[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff413fooEv,_ZTv0_n12_N4ff413fooEv),
};
extern VTBL_ENTRY _ZTV4ff41[];
static  VTT_ENTRY vtt_ff41[] = {
  {&(_ZTV4ff41[3]),  3,8},
  {&(_ZTV4ff41[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ff41[];
extern  VTBL_ENTRY _ZTV4ff41[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff41[];
static VTBL_ENTRY alt_thunk_names101[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff413fooEv,_ZTv0_n12_N4ff413fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff413fooEv,_ZThn12_N4ff413fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff41 = {  "ff41", // class name
  bases_ff41, 2,
  &(vtc_ff41[0]), // expected_vtbl_contents
  &(vtt_ff41[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ff41),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff41),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ff41),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names101,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg41  : ee41 , virtual ff41 {
  int g;
   gg41(const ABISELECT(__tsi64,int) *const *); // _ZN4gg41C2Ev
  virtual void  foo(); // _ZN4gg413fooEv
  ~gg41(); // tgen
  gg41(); // tgen
};
//SIG(1 gg41) C1{ BC2{ VBC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} VBC5{ BC6{ v1 Fi} VBC7{ v1 Fi} v1 Fi} v1 Fi}


 gg41 ::gg41(const ABISELECT(__tsi64,int) *const *){}
void  gg41 ::foo(){vfunc_called(this, "_ZN4gg413fooEv");}
gg41 ::~gg41(){ note_dtor("gg41", this);} // tgen
gg41 ::gg41(){ note_ctor("gg41", this);} // tgen

static void Test_gg41()
{
  extern Class_Descriptor cd_gg41;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg41, buf);
    gg41 *dp, &lv = *(dp=new (buf) gg41());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg41)");
    check_base_class_offset(lv, (aa41*)(ee41*), ABISELECT(24,16), "gg41");
    check_base_class_offset(lv, (bb41*)(ee41*), 0, "gg41");
    check_base_class_offset(lv, (ee41*), 0, "gg41");
    check_base_class_offset(lv, (cc41*)(ff41*), ABISELECT(40,24), "gg41");
    check_base_class_offset(lv, (dd41*)(ff41*), ABISELECT(56,36), "gg41");
    check_base_class_offset(lv, (ff41*), ABISELECT(40,24), "gg41");
    check_field_offset(lv, g, ABISELECT(16,12), "gg41.g");
    test_class_info(&lv, &cd_gg41);
    dp->~gg41();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg41(Test_gg41, "gg41", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN4gg41C1Ev();
extern void _ZN4gg41D1Ev();
Name_Map name_map_gg41[] = {
  NSPAIR(_ZN4gg41C1Ev),
  NSPAIR(_ZN4gg41D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa41;
extern VTBL_ENTRY _ZTI4aa41[];
extern  VTBL_ENTRY _ZTV4aa41[];
extern Class_Descriptor cd_bb41;
extern VTBL_ENTRY _ZTI4bb41[];
extern  VTBL_ENTRY _ZTV4bb41[];
extern Class_Descriptor cd_ee41;
extern VTBL_ENTRY _ZTI4ee41[];
extern  VTBL_ENTRY _ZTV4ee41[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee41[];
extern Class_Descriptor cd_cc41;
extern VTBL_ENTRY _ZTI4cc41[];
extern  VTBL_ENTRY _ZTV4cc41[];
extern Class_Descriptor cd_dd41;
extern VTBL_ENTRY _ZTI4dd41[];
extern  VTBL_ENTRY _ZTV4dd41[];
extern Class_Descriptor cd_ff41;
extern VTBL_ENTRY _ZTI4ff41[];
extern  VTBL_ENTRY _ZTV4ff41[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff41[];
static Base_Class bases_gg41[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa41,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_bb41,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_ee41,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc41,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_dd41,    ABISELECT(56,36), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_ff41,    ABISELECT(40,24), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4gg41[];
extern void _ZN4gg413fooEv();
extern void ABISELECT(_ZTv0_n24_N4gg413fooEv,_ZTv0_n12_N4gg413fooEv)();
extern void ABISELECT(_ZThn24_N4gg413fooEv,_ZThn16_N4gg413fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N4gg413fooEv,_ZTv0_n16_N4gg413fooEv)();
extern void ABISELECT(_ZThn40_N4gg413fooEv,_ZThn24_N4gg413fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg413fooEv,_ZTv0_n12_N4gg413fooEv)();
extern void ABISELECT(_ZThn56_N4gg413fooEv,_ZThn36_N4gg413fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg41[] = {
  ABISELECT(56,36),
  ABISELECT(40,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI4gg41[0]),
  (VTBL_ENTRY)&_ZN4gg413fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI4gg41[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg413fooEv,_ZTv0_n12_N4gg413fooEv),
  ABISELECT(-40,-24),
  ABISELECT(16,12),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI4gg41[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N4gg413fooEv,_ZTv0_n16_N4gg413fooEv),
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI4gg41[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg413fooEv,_ZTv0_n12_N4gg413fooEv),
};
extern VTBL_ENTRY _ZTV4gg41[];
extern void _ZN4ee413fooEv();
static  VTBL_ENTRY _tg__ZTV4ee41__4gg41[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI4ee41[0]),
  (VTBL_ENTRY)&_ZN4ee413fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ee413fooEv,_ZTv0_n12_N4ee413fooEv)();
extern void ABISELECT(_ZThn24_N4ee413fooEv,_ZThn16_N4ee413fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4aa41__4ee41__4gg41[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI4ee41[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee413fooEv,_ZTv0_n12_N4ee413fooEv),
};
extern void _ZN4ff413fooEv();
static  VTBL_ENTRY _tg__ZTV4ff41__4gg41[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff41[0]),
  (VTBL_ENTRY)&_ZN4ff413fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ff413fooEv,_ZTv0_n12_N4ff413fooEv)();
extern void ABISELECT(_ZThn16_N4ff413fooEv,_ZThn12_N4ff413fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4dd41__4ff41__4gg41[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff41[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff413fooEv,_ZTv0_n12_N4ff413fooEv),
};
static  VTT_ENTRY vtt_gg41[] = {
  {&(_ZTV4gg41[5]),  5,19},
  {&(_tg__ZTV4ee41__4gg41[3]),  3,4},
  {&(_tg__ZTV4aa41__4ee41__4gg41[3]),  3,4},
  {&(_ZTV4gg41[9]),  9,19},
  {&(_ZTV4gg41[14]),  14,19},
  {&(_ZTV4gg41[18]),  18,19},
  {&(_tg__ZTV4ff41__4gg41[3]),  3,4},
  {&(_tg__ZTV4dd41__4ff41__4gg41[3]),  3,4},
};
extern VTBL_ENTRY _ZTI4gg41[];
extern  VTBL_ENTRY _ZTV4gg41[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg41[];
static VTBL_ENTRY alt_thunk_names102[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff413fooEv,_ZTv0_n12_N4ff413fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff413fooEv,_ZThn12_N4ff413fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee413fooEv,_ZTv0_n12_N4ee413fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N4ee413fooEv,_ZThn16_N4ee413fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N4gg413fooEv,_ZTv0_n16_N4gg413fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N4gg413fooEv,_ZThn24_N4gg413fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg413fooEv,_ZTv0_n12_N4gg413fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4gg413fooEv,_ZThn36_N4gg413fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N4gg413fooEv,_ZThn16_N4gg413fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg41 = {  "gg41", // class name
  bases_gg41, 6,
  &(vtc_gg41[0]), // expected_vtbl_contents
  &(vtt_gg41[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI4gg41),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg41),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg41),8, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names102,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa42  {
  int a;
   aa42(); // _ZN4aa42C1Ev
  virtual void  foo(); // _ZN4aa423fooEv
  ~aa42(); // tgen
};
//SIG(-1 aa42) C1{ v1 Fi}


 aa42 ::aa42(){ note_ctor("aa42", this);}
void  aa42 ::foo(){vfunc_called(this, "_ZN4aa423fooEv");}
aa42 ::~aa42(){ note_dtor("aa42", this);} // tgen

static void Test_aa42()
{
  extern Class_Descriptor cd_aa42;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa42, buf);
    aa42 *dp, &lv = *(dp=new (buf) aa42());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa42)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa42.a");
    test_class_info(&lv, &cd_aa42);
    dp->~aa42();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa42(Test_aa42, "aa42", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa42C1Ev();
extern void _ZN4aa42D1Ev();
Name_Map name_map_aa42[] = {
  NSPAIR(_ZN4aa42C1Ev),
  NSPAIR(_ZN4aa42D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa42[];
extern void _ZN4aa423fooEv();
static  VTBL_ENTRY vtc_aa42[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa42[0]),
  (VTBL_ENTRY)&_ZN4aa423fooEv,
};
extern VTBL_ENTRY _ZTI4aa42[];
extern  VTBL_ENTRY _ZTV4aa42[];
Class_Descriptor cd_aa42 = {  "aa42", // class name
  0,0,//no base classes
  &(vtc_aa42[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa42),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa42),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb42  {
  int b;
   bb42(); // _ZN4bb42C1Ev
  virtual void  foo(); // _ZN4bb423fooEv
  ~bb42(); // tgen
};
//SIG(-1 bb42) C1{ v1 Fi}


 bb42 ::bb42(){ note_ctor("bb42", this);}
void  bb42 ::foo(){vfunc_called(this, "_ZN4bb423fooEv");}
bb42 ::~bb42(){ note_dtor("bb42", this);} // tgen

static void Test_bb42()
{
  extern Class_Descriptor cd_bb42;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb42, buf);
    bb42 *dp, &lv = *(dp=new (buf) bb42());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb42)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb42.b");
    test_class_info(&lv, &cd_bb42);
    dp->~bb42();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb42(Test_bb42, "bb42", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb42C1Ev();
extern void _ZN4bb42D1Ev();
Name_Map name_map_bb42[] = {
  NSPAIR(_ZN4bb42C1Ev),
  NSPAIR(_ZN4bb42D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb42[];
extern void _ZN4bb423fooEv();
static  VTBL_ENTRY vtc_bb42[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb42[0]),
  (VTBL_ENTRY)&_ZN4bb423fooEv,
};
extern VTBL_ENTRY _ZTI4bb42[];
extern  VTBL_ENTRY _ZTV4bb42[];
Class_Descriptor cd_bb42 = {  "bb42", // class name
  0,0,//no base classes
  &(vtc_bb42[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb42),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb42),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc42  {
  int c;
   cc42(); // _ZN4cc42C1Ev
  virtual void  foo(); // _ZN4cc423fooEv
  ~cc42(); // tgen
};
//SIG(-1 cc42) C1{ v1 Fi}


 cc42 ::cc42(){ note_ctor("cc42", this);}
void  cc42 ::foo(){vfunc_called(this, "_ZN4cc423fooEv");}
cc42 ::~cc42(){ note_dtor("cc42", this);} // tgen

static void Test_cc42()
{
  extern Class_Descriptor cd_cc42;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc42, buf);
    cc42 *dp, &lv = *(dp=new (buf) cc42());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc42)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc42.c");
    test_class_info(&lv, &cd_cc42);
    dp->~cc42();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc42(Test_cc42, "cc42", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc42C1Ev();
extern void _ZN4cc42D1Ev();
Name_Map name_map_cc42[] = {
  NSPAIR(_ZN4cc42C1Ev),
  NSPAIR(_ZN4cc42D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc42[];
extern void _ZN4cc423fooEv();
static  VTBL_ENTRY vtc_cc42[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc42[0]),
  (VTBL_ENTRY)&_ZN4cc423fooEv,
};
extern VTBL_ENTRY _ZTI4cc42[];
extern  VTBL_ENTRY _ZTV4cc42[];
Class_Descriptor cd_cc42 = {  "cc42", // class name
  0,0,//no base classes
  &(vtc_cc42[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc42),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc42),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd42  {
  int d;
   dd42(); // _ZN4dd42C1Ev
  virtual void  foo(); // _ZN4dd423fooEv
  ~dd42(); // tgen
};
//SIG(-1 dd42) C1{ v1 Fi}


 dd42 ::dd42(){ note_ctor("dd42", this);}
void  dd42 ::foo(){vfunc_called(this, "_ZN4dd423fooEv");}
dd42 ::~dd42(){ note_dtor("dd42", this);} // tgen

static void Test_dd42()
{
  extern Class_Descriptor cd_dd42;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd42, buf);
    dd42 *dp, &lv = *(dp=new (buf) dd42());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd42)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd42.d");
    test_class_info(&lv, &cd_dd42);
    dp->~dd42();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd42(Test_dd42, "dd42", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd42C1Ev();
extern void _ZN4dd42D1Ev();
Name_Map name_map_dd42[] = {
  NSPAIR(_ZN4dd42C1Ev),
  NSPAIR(_ZN4dd42D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd42[];
extern void _ZN4dd423fooEv();
static  VTBL_ENTRY vtc_dd42[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd42[0]),
  (VTBL_ENTRY)&_ZN4dd423fooEv,
};
extern VTBL_ENTRY _ZTI4dd42[];
extern  VTBL_ENTRY _ZTV4dd42[];
Class_Descriptor cd_dd42 = {  "dd42", // class name
  0,0,//no base classes
  &(vtc_dd42[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd42),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd42),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee42  : aa42 , virtual bb42 {
  int e;
   ee42(const ABISELECT(__tsi64,int) *const *); // _ZN4ee42C2Ev
  virtual void  foo(); // _ZN4ee423fooEv
  ~ee42(); // tgen
  ee42(); // tgen
};
//SIG(-1 ee42) C1{ BC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ee42 ::ee42(const ABISELECT(__tsi64,int) *const *){}
void  ee42 ::foo(){vfunc_called(this, "_ZN4ee423fooEv");}
ee42 ::~ee42(){ note_dtor("ee42", this);} // tgen
ee42 ::ee42(){ note_ctor("ee42", this);} // tgen

static void Test_ee42()
{
  extern Class_Descriptor cd_ee42;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ee42, buf);
    ee42 *dp, &lv = *(dp=new (buf) ee42());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ee42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee42)");
    check_base_class_offset(lv, (aa42*), 0, "ee42");
    check_base_class_offset(lv, (bb42*), ABISELECT(16,12), "ee42");
    check_field_offset(lv, e, ABISELECT(12,8), "ee42.e");
    test_class_info(&lv, &cd_ee42);
    dp->~ee42();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee42(Test_ee42, "ee42", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ee42C1Ev();
extern void _ZN4ee42D1Ev();
Name_Map name_map_ee42[] = {
  NSPAIR(_ZN4ee42C1Ev),
  NSPAIR(_ZN4ee42D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa42;
extern VTBL_ENTRY _ZTI4aa42[];
extern  VTBL_ENTRY _ZTV4aa42[];
extern Class_Descriptor cd_bb42;
extern VTBL_ENTRY _ZTI4bb42[];
extern  VTBL_ENTRY _ZTV4bb42[];
static Base_Class bases_ee42[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa42,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_bb42,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ee42[];
extern void _ZN4ee423fooEv();
extern void ABISELECT(_ZTv0_n24_N4ee423fooEv,_ZTv0_n12_N4ee423fooEv)();
extern void ABISELECT(_ZThn16_N4ee423fooEv,_ZThn12_N4ee423fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee42[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee42[0]),
  (VTBL_ENTRY)&_ZN4ee423fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee42[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee423fooEv,_ZTv0_n12_N4ee423fooEv),
};
extern VTBL_ENTRY _ZTV4ee42[];
static  VTT_ENTRY vtt_ee42[] = {
  {&(_ZTV4ee42[3]),  3,8},
  {&(_ZTV4ee42[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ee42[];
extern  VTBL_ENTRY _ZTV4ee42[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee42[];
static VTBL_ENTRY alt_thunk_names103[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee423fooEv,_ZTv0_n12_N4ee423fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee423fooEv,_ZThn12_N4ee423fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee42 = {  "ee42", // class name
  bases_ee42, 2,
  &(vtc_ee42[0]), // expected_vtbl_contents
  &(vtt_ee42[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ee42),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee42),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ee42),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names103,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff42  : cc42 , virtual dd42 {
  int f;
   ff42(const ABISELECT(__tsi64,int) *const *); // _ZN4ff42C2Ev
  virtual void  foo(); // _ZN4ff423fooEv
  ~ff42(); // tgen
  ff42(); // tgen
};
//SIG(-1 ff42) C1{ BC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ff42 ::ff42(const ABISELECT(__tsi64,int) *const *){}
void  ff42 ::foo(){vfunc_called(this, "_ZN4ff423fooEv");}
ff42 ::~ff42(){ note_dtor("ff42", this);} // tgen
ff42 ::ff42(){ note_ctor("ff42", this);} // tgen

static void Test_ff42()
{
  extern Class_Descriptor cd_ff42;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff42, buf);
    ff42 *dp, &lv = *(dp=new (buf) ff42());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff42)");
    check_base_class_offset(lv, (cc42*), 0, "ff42");
    check_base_class_offset(lv, (dd42*), ABISELECT(16,12), "ff42");
    check_field_offset(lv, f, ABISELECT(12,8), "ff42.f");
    test_class_info(&lv, &cd_ff42);
    dp->~ff42();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff42(Test_ff42, "ff42", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ff42C1Ev();
extern void _ZN4ff42D1Ev();
Name_Map name_map_ff42[] = {
  NSPAIR(_ZN4ff42C1Ev),
  NSPAIR(_ZN4ff42D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc42;
extern VTBL_ENTRY _ZTI4cc42[];
extern  VTBL_ENTRY _ZTV4cc42[];
extern Class_Descriptor cd_dd42;
extern VTBL_ENTRY _ZTI4dd42[];
extern  VTBL_ENTRY _ZTV4dd42[];
static Base_Class bases_ff42[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc42,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_dd42,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ff42[];
extern void _ZN4ff423fooEv();
extern void ABISELECT(_ZTv0_n24_N4ff423fooEv,_ZTv0_n12_N4ff423fooEv)();
extern void ABISELECT(_ZThn16_N4ff423fooEv,_ZThn12_N4ff423fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff42[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff42[0]),
  (VTBL_ENTRY)&_ZN4ff423fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff42[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff423fooEv,_ZTv0_n12_N4ff423fooEv),
};
extern VTBL_ENTRY _ZTV4ff42[];
static  VTT_ENTRY vtt_ff42[] = {
  {&(_ZTV4ff42[3]),  3,8},
  {&(_ZTV4ff42[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ff42[];
extern  VTBL_ENTRY _ZTV4ff42[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff42[];
static VTBL_ENTRY alt_thunk_names104[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff423fooEv,_ZTv0_n12_N4ff423fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff423fooEv,_ZThn12_N4ff423fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff42 = {  "ff42", // class name
  bases_ff42, 2,
  &(vtc_ff42[0]), // expected_vtbl_contents
  &(vtt_ff42[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ff42),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff42),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ff42),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names104,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg42  : ee42 , virtual ff42 {
  int g;
   gg42(const ABISELECT(__tsi64,int) *const *); // _ZN4gg42C2Ev
  virtual void  foo(); // _ZN4gg423fooEv
  ~gg42(); // tgen
  gg42(); // tgen
};
//SIG(1 gg42) C1{ BC2{ BC3{ v1 Fi} VBC4{ v1 Fi} v1 Fi} VBC5{ BC6{ v1 Fi} VBC7{ v1 Fi} v1 Fi} v1 Fi}


 gg42 ::gg42(const ABISELECT(__tsi64,int) *const *){}
void  gg42 ::foo(){vfunc_called(this, "_ZN4gg423fooEv");}
gg42 ::~gg42(){ note_dtor("gg42", this);} // tgen
gg42 ::gg42(){ note_ctor("gg42", this);} // tgen

static void Test_gg42()
{
  extern Class_Descriptor cd_gg42;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_gg42, buf);
    gg42 *dp, &lv = *(dp=new (buf) gg42());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(gg42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg42)");
    check_base_class_offset(lv, (aa42*)(ee42*), 0, "gg42");
    check_base_class_offset(lv, (bb42*)(ee42*), ABISELECT(24,16), "gg42");
    check_base_class_offset(lv, (ee42*), 0, "gg42");
    check_base_class_offset(lv, (cc42*)(ff42*), ABISELECT(40,24), "gg42");
    check_base_class_offset(lv, (dd42*)(ff42*), ABISELECT(56,36), "gg42");
    check_base_class_offset(lv, (ff42*), ABISELECT(40,24), "gg42");
    check_field_offset(lv, g, ABISELECT(16,12), "gg42.g");
    test_class_info(&lv, &cd_gg42);
    dp->~gg42();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg42(Test_gg42, "gg42", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN4gg42C1Ev();
extern void _ZN4gg42D1Ev();
Name_Map name_map_gg42[] = {
  NSPAIR(_ZN4gg42C1Ev),
  NSPAIR(_ZN4gg42D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa42;
extern VTBL_ENTRY _ZTI4aa42[];
extern  VTBL_ENTRY _ZTV4aa42[];
extern Class_Descriptor cd_bb42;
extern VTBL_ENTRY _ZTI4bb42[];
extern  VTBL_ENTRY _ZTV4bb42[];
extern Class_Descriptor cd_ee42;
extern VTBL_ENTRY _ZTI4ee42[];
extern  VTBL_ENTRY _ZTV4ee42[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee42[];
extern Class_Descriptor cd_cc42;
extern VTBL_ENTRY _ZTI4cc42[];
extern  VTBL_ENTRY _ZTV4cc42[];
extern Class_Descriptor cd_dd42;
extern VTBL_ENTRY _ZTI4dd42[];
extern  VTBL_ENTRY _ZTV4dd42[];
extern Class_Descriptor cd_ff42;
extern VTBL_ENTRY _ZTI4ff42[];
extern  VTBL_ENTRY _ZTV4ff42[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff42[];
static Base_Class bases_gg42[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa42,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_bb42,    ABISELECT(24,16), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_ee42,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc42,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_dd42,    ABISELECT(56,36), //bcp->offset
    15, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_ff42,    ABISELECT(40,24), //bcp->offset
    10, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4gg42[];
extern void _ZN4gg423fooEv();
extern void ABISELECT(_ZTv0_n24_N4gg423fooEv,_ZTv0_n12_N4gg423fooEv)();
extern void ABISELECT(_ZThn24_N4gg423fooEv,_ZThn16_N4gg423fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N4gg423fooEv,_ZTv0_n16_N4gg423fooEv)();
extern void ABISELECT(_ZThn40_N4gg423fooEv,_ZThn24_N4gg423fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg423fooEv,_ZTv0_n12_N4gg423fooEv)();
extern void ABISELECT(_ZThn56_N4gg423fooEv,_ZThn36_N4gg423fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg42[] = {
  ABISELECT(56,36),
  ABISELECT(40,24),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI4gg42[0]),
  (VTBL_ENTRY)&_ZN4gg423fooEv,
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI4gg42[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg423fooEv,_ZTv0_n12_N4gg423fooEv),
  ABISELECT(-40,-24),
  ABISELECT(16,12),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI4gg42[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N4gg423fooEv,_ZTv0_n16_N4gg423fooEv),
  ABISELECT(-56,-36),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI4gg42[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg423fooEv,_ZTv0_n12_N4gg423fooEv),
};
extern VTBL_ENTRY _ZTV4gg42[];
extern void _ZN4ee423fooEv();
static  VTBL_ENTRY _tg__ZTV4ee42__4gg42[] = {
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI4ee42[0]),
  (VTBL_ENTRY)&_ZN4ee423fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ee423fooEv,_ZTv0_n12_N4ee423fooEv)();
extern void ABISELECT(_ZThn24_N4ee423fooEv,_ZThn16_N4ee423fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb42__4ee42__4gg42[] = {
  ABISELECT(-24,-16),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI4ee42[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee423fooEv,_ZTv0_n12_N4ee423fooEv),
};
extern void _ZN4ff423fooEv();
static  VTBL_ENTRY _tg__ZTV4ff42__4gg42[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff42[0]),
  (VTBL_ENTRY)&_ZN4ff423fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ff423fooEv,_ZTv0_n12_N4ff423fooEv)();
extern void ABISELECT(_ZThn16_N4ff423fooEv,_ZThn12_N4ff423fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4dd42__4ff42__4gg42[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff42[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff423fooEv,_ZTv0_n12_N4ff423fooEv),
};
static  VTT_ENTRY vtt_gg42[] = {
  {&(_ZTV4gg42[5]),  5,19},
  {&(_tg__ZTV4ee42__4gg42[3]),  3,4},
  {&(_tg__ZTV4bb42__4ee42__4gg42[3]),  3,4},
  {&(_ZTV4gg42[9]),  9,19},
  {&(_ZTV4gg42[14]),  14,19},
  {&(_ZTV4gg42[18]),  18,19},
  {&(_tg__ZTV4ff42__4gg42[3]),  3,4},
  {&(_tg__ZTV4dd42__4ff42__4gg42[3]),  3,4},
};
extern VTBL_ENTRY _ZTI4gg42[];
extern  VTBL_ENTRY _ZTV4gg42[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg42[];
static VTBL_ENTRY alt_thunk_names105[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff423fooEv,_ZTv0_n12_N4ff423fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff423fooEv,_ZThn12_N4ff423fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee423fooEv,_ZTv0_n12_N4ee423fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N4ee423fooEv,_ZThn16_N4ee423fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N4gg423fooEv,_ZTv0_n16_N4gg423fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N4gg423fooEv,_ZThn24_N4gg423fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg423fooEv,_ZTv0_n12_N4gg423fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N4gg423fooEv,_ZThn36_N4gg423fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn24_N4gg423fooEv,_ZThn16_N4gg423fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_gg42 = {  "gg42", // class name
  bases_gg42, 6,
  &(vtc_gg42[0]), // expected_vtbl_contents
  &(vtt_gg42[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI4gg42),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4gg42),19, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4gg42),8, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names105,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  aa43  {
  int a;
   aa43(); // _ZN4aa43C1Ev
  virtual void  foo(); // _ZN4aa433fooEv
  ~aa43(); // tgen
};
//SIG(-1 aa43) C1{ v1 Fi}


 aa43 ::aa43(){ note_ctor("aa43", this);}
void  aa43 ::foo(){vfunc_called(this, "_ZN4aa433fooEv");}
aa43 ::~aa43(){ note_dtor("aa43", this);} // tgen

static void Test_aa43()
{
  extern Class_Descriptor cd_aa43;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_aa43, buf);
    aa43 *dp, &lv = *(dp=new (buf) aa43());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(aa43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(aa43)");
    check_field_offset(lv, a, ABISELECT(8,4), "aa43.a");
    test_class_info(&lv, &cd_aa43);
    dp->~aa43();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vaa43(Test_aa43, "aa43", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4aa43C1Ev();
extern void _ZN4aa43D1Ev();
Name_Map name_map_aa43[] = {
  NSPAIR(_ZN4aa43C1Ev),
  NSPAIR(_ZN4aa43D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4aa43[];
extern void _ZN4aa433fooEv();
static  VTBL_ENTRY vtc_aa43[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4aa43[0]),
  (VTBL_ENTRY)&_ZN4aa433fooEv,
};
extern VTBL_ENTRY _ZTI4aa43[];
extern  VTBL_ENTRY _ZTV4aa43[];
Class_Descriptor cd_aa43 = {  "aa43", // class name
  0,0,//no base classes
  &(vtc_aa43[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4aa43),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4aa43),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  bb43  {
  int b;
   bb43(); // _ZN4bb43C1Ev
  virtual void  foo(); // _ZN4bb433fooEv
  ~bb43(); // tgen
};
//SIG(-1 bb43) C1{ v1 Fi}


 bb43 ::bb43(){ note_ctor("bb43", this);}
void  bb43 ::foo(){vfunc_called(this, "_ZN4bb433fooEv");}
bb43 ::~bb43(){ note_dtor("bb43", this);} // tgen

static void Test_bb43()
{
  extern Class_Descriptor cd_bb43;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_bb43, buf);
    bb43 *dp, &lv = *(dp=new (buf) bb43());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(bb43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(bb43)");
    check_field_offset(lv, b, ABISELECT(8,4), "bb43.b");
    test_class_info(&lv, &cd_bb43);
    dp->~bb43();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vbb43(Test_bb43, "bb43", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4bb43C1Ev();
extern void _ZN4bb43D1Ev();
Name_Map name_map_bb43[] = {
  NSPAIR(_ZN4bb43C1Ev),
  NSPAIR(_ZN4bb43D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4bb43[];
extern void _ZN4bb433fooEv();
static  VTBL_ENTRY vtc_bb43[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4bb43[0]),
  (VTBL_ENTRY)&_ZN4bb433fooEv,
};
extern VTBL_ENTRY _ZTI4bb43[];
extern  VTBL_ENTRY _ZTV4bb43[];
Class_Descriptor cd_bb43 = {  "bb43", // class name
  0,0,//no base classes
  &(vtc_bb43[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4bb43),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4bb43),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  cc43  {
  int c;
   cc43(); // _ZN4cc43C1Ev
  virtual void  foo(); // _ZN4cc433fooEv
  ~cc43(); // tgen
};
//SIG(-1 cc43) C1{ v1 Fi}


 cc43 ::cc43(){ note_ctor("cc43", this);}
void  cc43 ::foo(){vfunc_called(this, "_ZN4cc433fooEv");}
cc43 ::~cc43(){ note_dtor("cc43", this);} // tgen

static void Test_cc43()
{
  extern Class_Descriptor cd_cc43;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_cc43, buf);
    cc43 *dp, &lv = *(dp=new (buf) cc43());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(cc43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(cc43)");
    check_field_offset(lv, c, ABISELECT(8,4), "cc43.c");
    test_class_info(&lv, &cd_cc43);
    dp->~cc43();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vcc43(Test_cc43, "cc43", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4cc43C1Ev();
extern void _ZN4cc43D1Ev();
Name_Map name_map_cc43[] = {
  NSPAIR(_ZN4cc43C1Ev),
  NSPAIR(_ZN4cc43D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4cc43[];
extern void _ZN4cc433fooEv();
static  VTBL_ENTRY vtc_cc43[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4cc43[0]),
  (VTBL_ENTRY)&_ZN4cc433fooEv,
};
extern VTBL_ENTRY _ZTI4cc43[];
extern  VTBL_ENTRY _ZTV4cc43[];
Class_Descriptor cd_cc43 = {  "cc43", // class name
  0,0,//no base classes
  &(vtc_cc43[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4cc43),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4cc43),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  dd43  {
  int d;
   dd43(); // _ZN4dd43C1Ev
  virtual void  foo(); // _ZN4dd433fooEv
  ~dd43(); // tgen
};
//SIG(-1 dd43) C1{ v1 Fi}


 dd43 ::dd43(){ note_ctor("dd43", this);}
void  dd43 ::foo(){vfunc_called(this, "_ZN4dd433fooEv");}
dd43 ::~dd43(){ note_dtor("dd43", this);} // tgen

static void Test_dd43()
{
  extern Class_Descriptor cd_dd43;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_dd43, buf);
    dd43 *dp, &lv = *(dp=new (buf) dd43());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(dd43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(dd43)");
    check_field_offset(lv, d, ABISELECT(8,4), "dd43.d");
    test_class_info(&lv, &cd_dd43);
    dp->~dd43();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vdd43(Test_dd43, "dd43", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4dd43C1Ev();
extern void _ZN4dd43D1Ev();
Name_Map name_map_dd43[] = {
  NSPAIR(_ZN4dd43C1Ev),
  NSPAIR(_ZN4dd43D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI4dd43[];
extern void _ZN4dd433fooEv();
static  VTBL_ENTRY vtc_dd43[] = {
  0,
  (VTBL_ENTRY)&(_ZTI4dd43[0]),
  (VTBL_ENTRY)&_ZN4dd433fooEv,
};
extern VTBL_ENTRY _ZTI4dd43[];
extern  VTBL_ENTRY _ZTV4dd43[];
Class_Descriptor cd_dd43 = {  "dd43", // class name
  0,0,//no base classes
  &(vtc_dd43[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4dd43),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV4dd43),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ee43  : virtual aa43 , virtual bb43 {
  int e;
   ee43(const ABISELECT(__tsi64,int) *const *); // _ZN4ee43C2Ev
  virtual void  foo(); // _ZN4ee433fooEv
  ~ee43(); // tgen
  ee43(); // tgen
};
//SIG(-1 ee43) C1{ VBC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ee43 ::ee43(const ABISELECT(__tsi64,int) *const *){}
void  ee43 ::foo(){vfunc_called(this, "_ZN4ee433fooEv");}
ee43 ::~ee43(){ note_dtor("ee43", this);} // tgen
ee43 ::ee43(){ note_ctor("ee43", this);} // tgen

static void Test_ee43()
{
  extern Class_Descriptor cd_ee43;
  void *lvp;
  {
    ABISELECT(double,int) buf[7];
    init_test(&cd_ee43, buf);
    ee43 *dp, &lv = *(dp=new (buf) ee43());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(ee43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ee43)");
    check_base_class_offset(lv, (aa43*), ABISELECT(16,8), "ee43");
    check_base_class_offset(lv, (bb43*), ABISELECT(32,16), "ee43");
    check_field_offset(lv, e, ABISELECT(8,4), "ee43.e");
    test_class_info(&lv, &cd_ee43);
    dp->~ee43();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vee43(Test_ee43, "ee43", ABISELECT(48,24));

#else // __cplusplus

extern void _ZN4ee43C1Ev();
extern void _ZN4ee43D1Ev();
Name_Map name_map_ee43[] = {
  NSPAIR(_ZN4ee43C1Ev),
  NSPAIR(_ZN4ee43D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa43;
extern VTBL_ENTRY _ZTI4aa43[];
extern  VTBL_ENTRY _ZTV4aa43[];
extern Class_Descriptor cd_bb43;
extern VTBL_ENTRY _ZTI4bb43[];
extern  VTBL_ENTRY _ZTV4bb43[];
static Base_Class bases_ee43[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa43,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_bb43,    ABISELECT(32,16), //bcp->offset
    9, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ee43[];
extern void _ZN4ee433fooEv();
extern void ABISELECT(_ZTv0_n24_N4ee433fooEv,_ZTv0_n12_N4ee433fooEv)();
extern void ABISELECT(_ZThn16_N4ee433fooEv,_ZThn8_N4ee433fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4ee433fooEv,_ZTv0_n12_N4ee433fooEv)();
extern void ABISELECT(_ZThn32_N4ee433fooEv,_ZThn16_N4ee433fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ee43[] = {
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI4ee43[0]),
  (VTBL_ENTRY)&_ZN4ee433fooEv,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI4ee43[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee433fooEv,_ZTv0_n12_N4ee433fooEv),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI4ee43[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee433fooEv,_ZTv0_n12_N4ee433fooEv),
};
extern VTBL_ENTRY _ZTV4ee43[];
static  VTT_ENTRY vtt_ee43[] = {
  {&(_ZTV4ee43[4]),  4,13},
  {&(_ZTV4ee43[8]),  8,13},
  {&(_ZTV4ee43[12]),  12,13},
};
extern VTBL_ENTRY _ZTI4ee43[];
extern  VTBL_ENTRY _ZTV4ee43[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee43[];
static VTBL_ENTRY alt_thunk_names106[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee433fooEv,_ZTv0_n12_N4ee433fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ee433fooEv,_ZThn16_N4ee433fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee433fooEv,_ZThn8_N4ee433fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ee43 = {  "ee43", // class name
  bases_ee43, 2,
  &(vtc_ee43[0]), // expected_vtbl_contents
  &(vtt_ee43[0]), // expected_vtt_contents
  ABISELECT(48,24), // object size
  NSPAIRA(_ZTI4ee43),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ee43),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ee43),3, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names106,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ff43  : cc43 , virtual dd43 {
  int f;
   ff43(const ABISELECT(__tsi64,int) *const *); // _ZN4ff43C2Ev
  virtual void  foo(); // _ZN4ff433fooEv
  ~ff43(); // tgen
  ff43(); // tgen
};
//SIG(-1 ff43) C1{ BC2{ v1 Fi} VBC3{ v1 Fi} v1 Fi}


 ff43 ::ff43(const ABISELECT(__tsi64,int) *const *){}
void  ff43 ::foo(){vfunc_called(this, "_ZN4ff433fooEv");}
ff43 ::~ff43(){ note_dtor("ff43", this);} // tgen
ff43 ::ff43(){ note_ctor("ff43", this);} // tgen

static void Test_ff43()
{
  extern Class_Descriptor cd_ff43;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_ff43, buf);
    ff43 *dp, &lv = *(dp=new (buf) ff43());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(ff43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(ff43)");
    check_base_class_offset(lv, (cc43*), 0, "ff43");
    check_base_class_offset(lv, (dd43*), ABISELECT(16,12), "ff43");
    check_field_offset(lv, f, ABISELECT(12,8), "ff43.f");
    test_class_info(&lv, &cd_ff43);
    dp->~ff43();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vff43(Test_ff43, "ff43", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN4ff43C1Ev();
extern void _ZN4ff43D1Ev();
Name_Map name_map_ff43[] = {
  NSPAIR(_ZN4ff43C1Ev),
  NSPAIR(_ZN4ff43D1Ev),
  {0,0}
};
extern Class_Descriptor cd_cc43;
extern VTBL_ENTRY _ZTI4cc43[];
extern  VTBL_ENTRY _ZTV4cc43[];
extern Class_Descriptor cd_dd43;
extern VTBL_ENTRY _ZTI4dd43[];
extern  VTBL_ENTRY _ZTV4dd43[];
static Base_Class bases_ff43[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_cc43,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_dd43,    ABISELECT(16,12), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4ff43[];
extern void _ZN4ff433fooEv();
extern void ABISELECT(_ZTv0_n24_N4ff433fooEv,_ZTv0_n12_N4ff433fooEv)();
extern void ABISELECT(_ZThn16_N4ff433fooEv,_ZThn12_N4ff433fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_ff43[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff43[0]),
  (VTBL_ENTRY)&_ZN4ff433fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff43[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff433fooEv,_ZTv0_n12_N4ff433fooEv),
};
extern VTBL_ENTRY _ZTV4ff43[];
static  VTT_ENTRY vtt_ff43[] = {
  {&(_ZTV4ff43[3]),  3,8},
  {&(_ZTV4ff43[7]),  7,8},
};
extern VTBL_ENTRY _ZTI4ff43[];
extern  VTBL_ENTRY _ZTV4ff43[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff43[];
static VTBL_ENTRY alt_thunk_names107[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff433fooEv,_ZTv0_n12_N4ff433fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff433fooEv,_ZThn12_N4ff433fooEv),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_ff43 = {  "ff43", // class name
  bases_ff43, 2,
  &(vtc_ff43[0]), // expected_vtbl_contents
  &(vtt_ff43[0]), // expected_vtt_contents
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI4ff43),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4ff43),8, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4ff43),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names107,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  gg43  : ee43 , virtual ff43 {
  int g;
   gg43(const ABISELECT(__tsi64,int) *const *); // _ZN4gg43C2Ev
  virtual void  foo(); // _ZN4gg433fooEv
  ~gg43(); // tgen
  gg43(); // tgen
};
//SIG(1 gg43) C1{ BC2{ VBC3{ v1 Fi} VBC4{ v1 Fi} v1 Fi} VBC5{ BC6{ v1 Fi} VBC7{ v1 Fi} v1 Fi} v1 Fi}


 gg43 ::gg43(const ABISELECT(__tsi64,int) *const *){}
void  gg43 ::foo(){vfunc_called(this, "_ZN4gg433fooEv");}
gg43 ::~gg43(){ note_dtor("gg43", this);} // tgen
gg43 ::gg43(){ note_ctor("gg43", this);} // tgen

static void Test_gg43()
{
  extern Class_Descriptor cd_gg43;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,13)];
    init_test(&cd_gg43, buf);
    gg43 *dp, &lv = *(dp=new (buf) gg43());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,48), "sizeof(gg43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(gg43)");
    check_base_class_offset(lv, (aa43*)(ee43*), ABISELECT(16,12), "gg43");
    check_base_class_offset(lv, (bb43*)(ee43*), ABISELECT(32,20), "gg43");
    check_base_class_offset(lv, (ee43*), 0, "gg43");
    check_base_class_offset(lv, (cc43*)(ff43*), ABISELECT(48,28), "gg43");
    check_base_class_offset(lv, (dd43*)(ff43*), ABISELECT(64,40), "gg43");
    check_base_class_offset(lv, (ff43*), ABISELECT(48,28), "gg43");
    check_field_offset(lv, g, ABISELECT(12,8), "gg43.g");
    test_class_info(&lv, &cd_gg43);
    dp->~gg43();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vgg43(Test_gg43, "gg43", ABISELECT(80,48));

#else // __cplusplus

extern void _ZN4gg43C1Ev();
extern void _ZN4gg43D1Ev();
Name_Map name_map_gg43[] = {
  NSPAIR(_ZN4gg43C1Ev),
  NSPAIR(_ZN4gg43D1Ev),
  {0,0}
};
extern Class_Descriptor cd_aa43;
extern VTBL_ENTRY _ZTI4aa43[];
extern  VTBL_ENTRY _ZTV4aa43[];
extern Class_Descriptor cd_bb43;
extern VTBL_ENTRY _ZTI4bb43[];
extern  VTBL_ENTRY _ZTV4bb43[];
extern Class_Descriptor cd_ee43;
extern VTBL_ENTRY _ZTI4ee43[];
extern  VTBL_ENTRY _ZTV4ee43[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ee43[];
extern Class_Descriptor cd_cc43;
extern VTBL_ENTRY _ZTI4cc43[];
extern  VTBL_ENTRY _ZTV4cc43[];
extern Class_Descriptor cd_dd43;
extern VTBL_ENTRY _ZTI4dd43[];
extern  VTBL_ENTRY _ZTV4dd43[];
extern Class_Descriptor cd_ff43;
extern VTBL_ENTRY _ZTI4ff43[];
extern  VTBL_ENTRY _ZTV4ff43[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4ff43[];
static Base_Class bases_gg43[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_aa43,    ABISELECT(16,12), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_bb43,    ABISELECT(32,20), //bcp->offset
    11, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_ee43,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_cc43,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_dd43,    ABISELECT(64,40), //bcp->offset
    20, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_ff43,    ABISELECT(48,28), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4gg43[];
extern void _ZN4gg433fooEv();
extern void ABISELECT(_ZTv0_n24_N4gg433fooEv,_ZTv0_n12_N4gg433fooEv)();
extern void ABISELECT(_ZThn16_N4gg433fooEv,_ZThn12_N4gg433fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg433fooEv,_ZTv0_n12_N4gg433fooEv)();
extern void ABISELECT(_ZThn32_N4gg433fooEv,_ZThn20_N4gg433fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n32_N4gg433fooEv,_ZTv0_n16_N4gg433fooEv)();
extern void ABISELECT(_ZThn48_N4gg433fooEv,_ZThn28_N4gg433fooEv)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N4gg433fooEv,_ZTv0_n12_N4gg433fooEv)();
extern void ABISELECT(_ZThn64_N4gg433fooEv,_ZThn40_N4gg433fooEv)() __attribute__((weak));
static  VTBL_ENTRY vtc_gg43[] = {
  ABISELECT(64,40),
  ABISELECT(48,28),
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4gg43[0]),
  (VTBL_ENTRY)&_ZN4gg433fooEv,
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4gg43[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg433fooEv,_ZTv0_n12_N4gg433fooEv),
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI4gg43[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg433fooEv,_ZTv0_n12_N4gg433fooEv),
  ABISELECT(-48,-28),
  ABISELECT(16,12),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI4gg43[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n32_N4gg433fooEv,_ZTv0_n16_N4gg433fooEv),
  ABISELECT(-64,-40),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI4gg43[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4gg433fooEv,_ZTv0_n12_N4gg433fooEv),
};
extern VTBL_ENTRY _ZTV4gg43[];
extern void _ZN4ee433fooEv();
static  VTBL_ENTRY _tg__ZTV4ee43__4gg43[] = {
  ABISELECT(32,20),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ee43[0]),
  (VTBL_ENTRY)&_ZN4ee433fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ee433fooEv,_ZTv0_n12_N4ee433fooEv)();
extern void ABISELECT(_ZThn16_N4ee433fooEv,_ZThn12_N4ee433fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4aa43__4ee43__4gg43[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ee43[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee433fooEv,_ZTv0_n12_N4ee433fooEv),
};
extern void ABISELECT(_ZTv0_n24_N4ee433fooEv,_ZTv0_n12_N4ee433fooEv)();
extern void ABISELECT(_ZThn32_N4ee433fooEv,_ZThn20_N4ee433fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4bb43__4ee43__4gg43[] = {
  ABISELECT(-32,-20),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI4ee43[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ee433fooEv,_ZTv0_n12_N4ee433fooEv),
};
extern void _ZN4ff433fooEv();
static  VTBL_ENTRY _tg__ZTV4ff43__4gg43[] = {
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI4ff43[0]),
  (VTBL_ENTRY)&_ZN4ff433fooEv,
};
extern void ABISELECT(_ZTv0_n24_N4ff433fooEv,_ZTv0_n12_N4ff433fooEv)();
extern void ABISELECT(_ZThn16_N4ff433fooEv,_ZThn12_N4ff433fooEv)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV4dd43__4ff43__4gg43[] = {
  ABISELECT(-16,-12),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI4ff43[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N4ff433fooEv,_ZTv0_n12_N4ff433fooEv),
};
static  VTT_ENTRY vtt_gg43[] = {
  {&(_ZTV4gg43[6]),  6,24},
  {&(_tg__ZTV4ee43__4gg43[4]),  4,5},
  {&(_tg__ZTV4aa43__4ee43__4gg43[3]),  3,4},
  {&(_tg__ZTV4bb43__4ee43__4gg43[3]),  3,4},
  {&(_ZTV4gg43[10]),  10,24},
  {&(_ZTV4gg43[14]),  14,24},
  {&(_ZTV4gg43[19]),  19,24},
  {&(_ZTV4gg43[23]),  23,24},
  {&(_tg__ZTV4ff43__4gg43[3]),  3,4},
  {&(_tg__ZTV4dd43__4ff43__4gg43[3]),  3,4},
};
extern VTBL_ENTRY _ZTI4gg43[];
extern  VTBL_ENTRY _ZTV4gg43[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4gg43[];
static VTBL_ENTRY alt_thunk_names108[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ff433fooEv,_ZTv0_n12_N4ff433fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ff433fooEv,_ZThn12_N4ff433fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4ee433fooEv,_ZTv0_n12_N4ee433fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4ee433fooEv,_ZThn20_N4ee433fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N4ee433fooEv,_ZThn12_N4ee433fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n32_N4gg433fooEv,_ZTv0_n16_N4gg433fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N4gg433fooEv,_ZThn28_N4gg433fooEv),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N4gg433fooEv,_ZTv0_n12_N4gg433fooEv), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N4gg433fooEv,_ZThn40_N4gg433fooEv),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N4gg433fooEv,_ZThn20_N4gg433f