// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus
namespace ccc { 
struct  AA0  {
  virtual void  abc(); // _ZN3ccc3AA03abcEv
  virtual void  efg(); // _ZN3ccc3AA03efgEv
  virtual void  pqr(); // _ZN3ccc3AA03pqrEv
  ~AA0(); // tgen
  AA0(); // tgen
};
//SIG(-1 _ZN3ccc3AA0E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::AA0 ::abc(){vfunc_called(this, "_ZN3ccc3AA03abcEv");}
void  ccc::AA0 ::efg(){vfunc_called(this, "_ZN3ccc3AA03efgEv");}
void  ccc::AA0 ::pqr(){vfunc_called(this, "_ZN3ccc3AA03pqrEv");}
ccc::AA0 ::~AA0(){ note_dtor("_ZN3ccc3AA0E", this);} // tgen
ccc::AA0 ::AA0(){ note_ctor("_ZN3ccc3AA0E", this);} // tgen
}
static void Test__ZN3ccc3AA0E()
{
  extern Class_Descriptor cd__ZN3ccc3AA0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA0E, buf);
    ::ccc::AA0 *dp, &lv = *(dp=new (buf) ::ccc::AA0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA0E)");
    test_class_info(&lv, &cd__ZN3ccc3AA0E);
    dp->::ccc::AA0::~AA0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA0E(Test__ZN3ccc3AA0E, "_ZN3ccc3AA0E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA0C1Ev();
extern void _ZN3ccc3AA0D1Ev();
Name_Map name_map__ZN3ccc3AA0E[] = {
  NSPAIR(_ZN3ccc3AA0C1Ev),
  NSPAIR(_ZN3ccc3AA0D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA0E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA0E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
Class_Descriptor cd__ZN3ccc3AA0E = {  "_ZN3ccc3AA0E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA0E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA0E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA0E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB0  {
  virtual void  abc(); // _ZN3ccc3BB03abcEv
  virtual void  efg(); // _ZN3ccc3BB03efgEv
  virtual void  pqr(); // _ZN3ccc3BB03pqrEv
  ~BB0(); // tgen
  BB0(); // tgen
};
//SIG(-1 _ZN3ccc3BB0E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::BB0 ::abc(){vfunc_called(this, "_ZN3ccc3BB03abcEv");}
void  ccc::BB0 ::efg(){vfunc_called(this, "_ZN3ccc3BB03efgEv");}
void  ccc::BB0 ::pqr(){vfunc_called(this, "_ZN3ccc3BB03pqrEv");}
ccc::BB0 ::~BB0(){ note_dtor("_ZN3ccc3BB0E", this);} // tgen
ccc::BB0 ::BB0(){ note_ctor("_ZN3ccc3BB0E", this);} // tgen
}
static void Test__ZN3ccc3BB0E()
{
  extern Class_Descriptor cd__ZN3ccc3BB0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB0E, buf);
    ::ccc::BB0 *dp, &lv = *(dp=new (buf) ::ccc::BB0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB0E)");
    test_class_info(&lv, &cd__ZN3ccc3BB0E);
    dp->::ccc::BB0::~BB0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB0E(Test__ZN3ccc3BB0E, "_ZN3ccc3BB0E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB0C1Ev();
extern void _ZN3ccc3BB0D1Ev();
Name_Map name_map__ZN3ccc3BB0E[] = {
  NSPAIR(_ZN3ccc3BB0C1Ev),
  NSPAIR(_ZN3ccc3BB0D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB0E[];
extern void _ZN3ccc3BB03abcEv();
extern void _ZN3ccc3BB03efgEv();
extern void _ZN3ccc3BB03pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB0E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB0E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB03pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB0E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB0E[];
Class_Descriptor cd__ZN3ccc3BB0E = {  "_ZN3ccc3BB0E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB0E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB0E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB0E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA1  {
  virtual void  abc(); // _ZN3ccc3AA13abcEv
  virtual void  pqr(); // _ZN3ccc3AA13pqrEv
  virtual void  efg(); // _ZN3ccc3AA13efgEv
  ~AA1(); // tgen
  AA1(); // tgen
};
//SIG(-1 _ZN3ccc3AA1E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::AA1 ::abc(){vfunc_called(this, "_ZN3ccc3AA13abcEv");}
void  ccc::AA1 ::pqr(){vfunc_called(this, "_ZN3ccc3AA13pqrEv");}
void  ccc::AA1 ::efg(){vfunc_called(this, "_ZN3ccc3AA13efgEv");}
ccc::AA1 ::~AA1(){ note_dtor("_ZN3ccc3AA1E", this);} // tgen
ccc::AA1 ::AA1(){ note_ctor("_ZN3ccc3AA1E", this);} // tgen
}
static void Test__ZN3ccc3AA1E()
{
  extern Class_Descriptor cd__ZN3ccc3AA1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA1E, buf);
    ::ccc::AA1 *dp, &lv = *(dp=new (buf) ::ccc::AA1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA1E)");
    test_class_info(&lv, &cd__ZN3ccc3AA1E);
    dp->::ccc::AA1::~AA1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA1E(Test__ZN3ccc3AA1E, "_ZN3ccc3AA1E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA1C1Ev();
extern void _ZN3ccc3AA1D1Ev();
Name_Map name_map__ZN3ccc3AA1E[] = {
  NSPAIR(_ZN3ccc3AA1C1Ev),
  NSPAIR(_ZN3ccc3AA1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA1E[];
extern void _ZN3ccc3AA13abcEv();
extern void _ZN3ccc3AA13pqrEv();
extern void _ZN3ccc3AA13efgEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA1E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA13abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA13efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA1E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA1E[];
Class_Descriptor cd__ZN3ccc3AA1E = {  "_ZN3ccc3AA1E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA1E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA1E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB1  {
  virtual void  abc(); // _ZN3ccc3BB13abcEv
  virtual void  pqr(); // _ZN3ccc3BB13pqrEv
  virtual void  efg(); // _ZN3ccc3BB13efgEv
  ~BB1(); // tgen
  BB1(); // tgen
};
//SIG(-1 _ZN3ccc3BB1E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::BB1 ::abc(){vfunc_called(this, "_ZN3ccc3BB13abcEv");}
void  ccc::BB1 ::pqr(){vfunc_called(this, "_ZN3ccc3BB13pqrEv");}
void  ccc::BB1 ::efg(){vfunc_called(this, "_ZN3ccc3BB13efgEv");}
ccc::BB1 ::~BB1(){ note_dtor("_ZN3ccc3BB1E", this);} // tgen
ccc::BB1 ::BB1(){ note_ctor("_ZN3ccc3BB1E", this);} // tgen
}
static void Test__ZN3ccc3BB1E()
{
  extern Class_Descriptor cd__ZN3ccc3BB1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB1E, buf);
    ::ccc::BB1 *dp, &lv = *(dp=new (buf) ::ccc::BB1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB1E)");
    test_class_info(&lv, &cd__ZN3ccc3BB1E);
    dp->::ccc::BB1::~BB1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB1E(Test__ZN3ccc3BB1E, "_ZN3ccc3BB1E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB1C1Ev();
extern void _ZN3ccc3BB1D1Ev();
Name_Map name_map__ZN3ccc3BB1E[] = {
  NSPAIR(_ZN3ccc3BB1C1Ev),
  NSPAIR(_ZN3ccc3BB1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB1E[];
extern void _ZN3ccc3BB13abcEv();
extern void _ZN3ccc3BB13pqrEv();
extern void _ZN3ccc3BB13efgEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB1E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB13abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB13efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB1E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB1E[];
Class_Descriptor cd__ZN3ccc3BB1E = {  "_ZN3ccc3BB1E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB1E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB1E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA2  {
  virtual void  efg(); // _ZN3ccc3AA23efgEv
  virtual void  abc(); // _ZN3ccc3AA23abcEv
  virtual void  pqr(); // _ZN3ccc3AA23pqrEv
  ~AA2(); // tgen
  AA2(); // tgen
};
//SIG(-1 _ZN3ccc3AA2E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::AA2 ::efg(){vfunc_called(this, "_ZN3ccc3AA23efgEv");}
void  ccc::AA2 ::abc(){vfunc_called(this, "_ZN3ccc3AA23abcEv");}
void  ccc::AA2 ::pqr(){vfunc_called(this, "_ZN3ccc3AA23pqrEv");}
ccc::AA2 ::~AA2(){ note_dtor("_ZN3ccc3AA2E", this);} // tgen
ccc::AA2 ::AA2(){ note_ctor("_ZN3ccc3AA2E", this);} // tgen
}
static void Test__ZN3ccc3AA2E()
{
  extern Class_Descriptor cd__ZN3ccc3AA2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA2E, buf);
    ::ccc::AA2 *dp, &lv = *(dp=new (buf) ::ccc::AA2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA2E)");
    test_class_info(&lv, &cd__ZN3ccc3AA2E);
    dp->::ccc::AA2::~AA2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA2E(Test__ZN3ccc3AA2E, "_ZN3ccc3AA2E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA2C1Ev();
extern void _ZN3ccc3AA2D1Ev();
Name_Map name_map__ZN3ccc3AA2E[] = {
  NSPAIR(_ZN3ccc3AA2C1Ev),
  NSPAIR(_ZN3ccc3AA2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA2E[];
extern void _ZN3ccc3AA23efgEv();
extern void _ZN3ccc3AA23abcEv();
extern void _ZN3ccc3AA23pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA2E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA23efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA23abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA23pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA2E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA2E[];
Class_Descriptor cd__ZN3ccc3AA2E = {  "_ZN3ccc3AA2E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA2E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA2E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB2  {
  virtual void  efg(); // _ZN3ccc3BB23efgEv
  virtual void  abc(); // _ZN3ccc3BB23abcEv
  virtual void  pqr(); // _ZN3ccc3BB23pqrEv
  ~BB2(); // tgen
  BB2(); // tgen
};
//SIG(-1 _ZN3ccc3BB2E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::BB2 ::efg(){vfunc_called(this, "_ZN3ccc3BB23efgEv");}
void  ccc::BB2 ::abc(){vfunc_called(this, "_ZN3ccc3BB23abcEv");}
void  ccc::BB2 ::pqr(){vfunc_called(this, "_ZN3ccc3BB23pqrEv");}
ccc::BB2 ::~BB2(){ note_dtor("_ZN3ccc3BB2E", this);} // tgen
ccc::BB2 ::BB2(){ note_ctor("_ZN3ccc3BB2E", this);} // tgen
}
static void Test__ZN3ccc3BB2E()
{
  extern Class_Descriptor cd__ZN3ccc3BB2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB2E, buf);
    ::ccc::BB2 *dp, &lv = *(dp=new (buf) ::ccc::BB2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB2E)");
    test_class_info(&lv, &cd__ZN3ccc3BB2E);
    dp->::ccc::BB2::~BB2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB2E(Test__ZN3ccc3BB2E, "_ZN3ccc3BB2E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB2C1Ev();
extern void _ZN3ccc3BB2D1Ev();
Name_Map name_map__ZN3ccc3BB2E[] = {
  NSPAIR(_ZN3ccc3BB2C1Ev),
  NSPAIR(_ZN3ccc3BB2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB2E[];
extern void _ZN3ccc3BB23efgEv();
extern void _ZN3ccc3BB23abcEv();
extern void _ZN3ccc3BB23pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB2E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB23efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB23abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB23pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB2E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB2E[];
Class_Descriptor cd__ZN3ccc3BB2E = {  "_ZN3ccc3BB2E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB2E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB2E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA3  {
  virtual void  efg(); // _ZN3ccc3AA33efgEv
  virtual void  pqr(); // _ZN3ccc3AA33pqrEv
  virtual void  abc(); // _ZN3ccc3AA33abcEv
  ~AA3(); // tgen
  AA3(); // tgen
};
//SIG(-1 _ZN3ccc3AA3E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::AA3 ::efg(){vfunc_called(this, "_ZN3ccc3AA33efgEv");}
void  ccc::AA3 ::pqr(){vfunc_called(this, "_ZN3ccc3AA33pqrEv");}
void  ccc::AA3 ::abc(){vfunc_called(this, "_ZN3ccc3AA33abcEv");}
ccc::AA3 ::~AA3(){ note_dtor("_ZN3ccc3AA3E", this);} // tgen
ccc::AA3 ::AA3(){ note_ctor("_ZN3ccc3AA3E", this);} // tgen
}
static void Test__ZN3ccc3AA3E()
{
  extern Class_Descriptor cd__ZN3ccc3AA3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA3E, buf);
    ::ccc::AA3 *dp, &lv = *(dp=new (buf) ::ccc::AA3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA3E)");
    test_class_info(&lv, &cd__ZN3ccc3AA3E);
    dp->::ccc::AA3::~AA3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA3E(Test__ZN3ccc3AA3E, "_ZN3ccc3AA3E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA3C1Ev();
extern void _ZN3ccc3AA3D1Ev();
Name_Map name_map__ZN3ccc3AA3E[] = {
  NSPAIR(_ZN3ccc3AA3C1Ev),
  NSPAIR(_ZN3ccc3AA3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA3E[];
extern void _ZN3ccc3AA33efgEv();
extern void _ZN3ccc3AA33pqrEv();
extern void _ZN3ccc3AA33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA3E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA33efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA33abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA3E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA3E[];
Class_Descriptor cd__ZN3ccc3AA3E = {  "_ZN3ccc3AA3E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA3E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA3E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB3  {
  virtual void  efg(); // _ZN3ccc3BB33efgEv
  virtual void  pqr(); // _ZN3ccc3BB33pqrEv
  virtual void  abc(); // _ZN3ccc3BB33abcEv
  ~BB3(); // tgen
  BB3(); // tgen
};
//SIG(-1 _ZN3ccc3BB3E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::BB3 ::efg(){vfunc_called(this, "_ZN3ccc3BB33efgEv");}
void  ccc::BB3 ::pqr(){vfunc_called(this, "_ZN3ccc3BB33pqrEv");}
void  ccc::BB3 ::abc(){vfunc_called(this, "_ZN3ccc3BB33abcEv");}
ccc::BB3 ::~BB3(){ note_dtor("_ZN3ccc3BB3E", this);} // tgen
ccc::BB3 ::BB3(){ note_ctor("_ZN3ccc3BB3E", this);} // tgen
}
static void Test__ZN3ccc3BB3E()
{
  extern Class_Descriptor cd__ZN3ccc3BB3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB3E, buf);
    ::ccc::BB3 *dp, &lv = *(dp=new (buf) ::ccc::BB3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB3E)");
    test_class_info(&lv, &cd__ZN3ccc3BB3E);
    dp->::ccc::BB3::~BB3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB3E(Test__ZN3ccc3BB3E, "_ZN3ccc3BB3E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB3C1Ev();
extern void _ZN3ccc3BB3D1Ev();
Name_Map name_map__ZN3ccc3BB3E[] = {
  NSPAIR(_ZN3ccc3BB3C1Ev),
  NSPAIR(_ZN3ccc3BB3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern void _ZN3ccc3BB33efgEv();
extern void _ZN3ccc3BB33pqrEv();
extern void _ZN3ccc3BB33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB3E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB33efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB33abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
Class_Descriptor cd__ZN3ccc3BB3E = {  "_ZN3ccc3BB3E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB3E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB3E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA4  {
  virtual void  pqr(); // _ZN3ccc3AA43pqrEv
  virtual void  abc(); // _ZN3ccc3AA43abcEv
  virtual void  efg(); // _ZN3ccc3AA43efgEv
  ~AA4(); // tgen
  AA4(); // tgen
};
//SIG(-1 _ZN3ccc3AA4E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::AA4 ::pqr(){vfunc_called(this, "_ZN3ccc3AA43pqrEv");}
void  ccc::AA4 ::abc(){vfunc_called(this, "_ZN3ccc3AA43abcEv");}
void  ccc::AA4 ::efg(){vfunc_called(this, "_ZN3ccc3AA43efgEv");}
ccc::AA4 ::~AA4(){ note_dtor("_ZN3ccc3AA4E", this);} // tgen
ccc::AA4 ::AA4(){ note_ctor("_ZN3ccc3AA4E", this);} // tgen
}
static void Test__ZN3ccc3AA4E()
{
  extern Class_Descriptor cd__ZN3ccc3AA4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA4E, buf);
    ::ccc::AA4 *dp, &lv = *(dp=new (buf) ::ccc::AA4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA4E)");
    test_class_info(&lv, &cd__ZN3ccc3AA4E);
    dp->::ccc::AA4::~AA4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA4E(Test__ZN3ccc3AA4E, "_ZN3ccc3AA4E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA4C1Ev();
extern void _ZN3ccc3AA4D1Ev();
Name_Map name_map__ZN3ccc3AA4E[] = {
  NSPAIR(_ZN3ccc3AA4C1Ev),
  NSPAIR(_ZN3ccc3AA4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA4E[];
extern void _ZN3ccc3AA43pqrEv();
extern void _ZN3ccc3AA43abcEv();
extern void _ZN3ccc3AA43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA4E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA4E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA43abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA43efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA4E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA4E[];
Class_Descriptor cd__ZN3ccc3AA4E = {  "_ZN3ccc3AA4E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA4E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA4E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA4E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB4  {
  virtual void  pqr(); // _ZN3ccc3BB43pqrEv
  virtual void  abc(); // _ZN3ccc3BB43abcEv
  virtual void  efg(); // _ZN3ccc3BB43efgEv
  ~BB4(); // tgen
  BB4(); // tgen
};
//SIG(-1 _ZN3ccc3BB4E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::BB4 ::pqr(){vfunc_called(this, "_ZN3ccc3BB43pqrEv");}
void  ccc::BB4 ::abc(){vfunc_called(this, "_ZN3ccc3BB43abcEv");}
void  ccc::BB4 ::efg(){vfunc_called(this, "_ZN3ccc3BB43efgEv");}
ccc::BB4 ::~BB4(){ note_dtor("_ZN3ccc3BB4E", this);} // tgen
ccc::BB4 ::BB4(){ note_ctor("_ZN3ccc3BB4E", this);} // tgen
}
static void Test__ZN3ccc3BB4E()
{
  extern Class_Descriptor cd__ZN3ccc3BB4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB4E, buf);
    ::ccc::BB4 *dp, &lv = *(dp=new (buf) ::ccc::BB4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB4E)");
    test_class_info(&lv, &cd__ZN3ccc3BB4E);
    dp->::ccc::BB4::~BB4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB4E(Test__ZN3ccc3BB4E, "_ZN3ccc3BB4E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB4C1Ev();
extern void _ZN3ccc3BB4D1Ev();
Name_Map name_map__ZN3ccc3BB4E[] = {
  NSPAIR(_ZN3ccc3BB4C1Ev),
  NSPAIR(_ZN3ccc3BB4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern void _ZN3ccc3BB43pqrEv();
extern void _ZN3ccc3BB43abcEv();
extern void _ZN3ccc3BB43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB4E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB4E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB43abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB43efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
Class_Descriptor cd__ZN3ccc3BB4E = {  "_ZN3ccc3BB4E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB4E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB4E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB4E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA5  {
  virtual void  pqr(); // _ZN3ccc3AA53pqrEv
  virtual void  efg(); // _ZN3ccc3AA53efgEv
  virtual void  abc(); // _ZN3ccc3AA53abcEv
  ~AA5(); // tgen
  AA5(); // tgen
};
//SIG(-1 _ZN3ccc3AA5E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::AA5 ::pqr(){vfunc_called(this, "_ZN3ccc3AA53pqrEv");}
void  ccc::AA5 ::efg(){vfunc_called(this, "_ZN3ccc3AA53efgEv");}
void  ccc::AA5 ::abc(){vfunc_called(this, "_ZN3ccc3AA53abcEv");}
ccc::AA5 ::~AA5(){ note_dtor("_ZN3ccc3AA5E", this);} // tgen
ccc::AA5 ::AA5(){ note_ctor("_ZN3ccc3AA5E", this);} // tgen
}
static void Test__ZN3ccc3AA5E()
{
  extern Class_Descriptor cd__ZN3ccc3AA5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA5E, buf);
    ::ccc::AA5 *dp, &lv = *(dp=new (buf) ::ccc::AA5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA5E)");
    test_class_info(&lv, &cd__ZN3ccc3AA5E);
    dp->::ccc::AA5::~AA5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA5E(Test__ZN3ccc3AA5E, "_ZN3ccc3AA5E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA5C1Ev();
extern void _ZN3ccc3AA5D1Ev();
Name_Map name_map__ZN3ccc3AA5E[] = {
  NSPAIR(_ZN3ccc3AA5C1Ev),
  NSPAIR(_ZN3ccc3AA5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern void _ZN3ccc3AA53pqrEv();
extern void _ZN3ccc3AA53efgEv();
extern void _ZN3ccc3AA53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA5E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA5E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA53abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA5E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA5E[];
Class_Descriptor cd__ZN3ccc3AA5E = {  "_ZN3ccc3AA5E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA5E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA5E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA5E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB5  {
  virtual void  pqr(); // _ZN3ccc3BB53pqrEv
  virtual void  efg(); // _ZN3ccc3BB53efgEv
  virtual void  abc(); // _ZN3ccc3BB53abcEv
  ~BB5(); // tgen
  BB5(); // tgen
};
//SIG(-1 _ZN3ccc3BB5E) C1{ v1 v2 v3}
}
namespace ccc { 
void  ccc::BB5 ::pqr(){vfunc_called(this, "_ZN3ccc3BB53pqrEv");}
void  ccc::BB5 ::efg(){vfunc_called(this, "_ZN3ccc3BB53efgEv");}
void  ccc::BB5 ::abc(){vfunc_called(this, "_ZN3ccc3BB53abcEv");}
ccc::BB5 ::~BB5(){ note_dtor("_ZN3ccc3BB5E", this);} // tgen
ccc::BB5 ::BB5(){ note_ctor("_ZN3ccc3BB5E", this);} // tgen
}
static void Test__ZN3ccc3BB5E()
{
  extern Class_Descriptor cd__ZN3ccc3BB5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB5E, buf);
    ::ccc::BB5 *dp, &lv = *(dp=new (buf) ::ccc::BB5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB5E)");
    test_class_info(&lv, &cd__ZN3ccc3BB5E);
    dp->::ccc::BB5::~BB5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB5E(Test__ZN3ccc3BB5E, "_ZN3ccc3BB5E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB5C1Ev();
extern void _ZN3ccc3BB5D1Ev();
Name_Map name_map__ZN3ccc3BB5E[] = {
  NSPAIR(_ZN3ccc3BB5C1Ev),
  NSPAIR(_ZN3ccc3BB5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern void _ZN3ccc3BB53pqrEv();
extern void _ZN3ccc3BB53efgEv();
extern void _ZN3ccc3BB53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB5E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB5E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB53abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
Class_Descriptor cd__ZN3ccc3BB5E = {  "_ZN3ccc3BB5E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB5E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB5E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB5E),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA6  {
  virtual void  abc(); // _ZN3ccc3AA63abcEv
  virtual void  efg(); // _ZN3ccc3AA63efgEv
  ~AA6(); // tgen
  AA6(); // tgen
};
//SIG(-1 _ZN3ccc3AA6E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::AA6 ::abc(){vfunc_called(this, "_ZN3ccc3AA63abcEv");}
void  ccc::AA6 ::efg(){vfunc_called(this, "_ZN3ccc3AA63efgEv");}
ccc::AA6 ::~AA6(){ note_dtor("_ZN3ccc3AA6E", this);} // tgen
ccc::AA6 ::AA6(){ note_ctor("_ZN3ccc3AA6E", this);} // tgen
}
static void Test__ZN3ccc3AA6E()
{
  extern Class_Descriptor cd__ZN3ccc3AA6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA6E, buf);
    ::ccc::AA6 *dp, &lv = *(dp=new (buf) ::ccc::AA6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA6E)");
    test_class_info(&lv, &cd__ZN3ccc3AA6E);
    dp->::ccc::AA6::~AA6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA6E(Test__ZN3ccc3AA6E, "_ZN3ccc3AA6E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA6C1Ev();
extern void _ZN3ccc3AA6D1Ev();
Name_Map name_map__ZN3ccc3AA6E[] = {
  NSPAIR(_ZN3ccc3AA6C1Ev),
  NSPAIR(_ZN3ccc3AA6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA6E[];
extern void _ZN3ccc3AA63abcEv();
extern void _ZN3ccc3AA63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA6E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA63abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA63efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA6E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA6E[];
Class_Descriptor cd__ZN3ccc3AA6E = {  "_ZN3ccc3AA6E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA6E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA6E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA6E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB6  {
  virtual void  abc(); // _ZN3ccc3BB63abcEv
  virtual void  efg(); // _ZN3ccc3BB63efgEv
  ~BB6(); // tgen
  BB6(); // tgen
};
//SIG(-1 _ZN3ccc3BB6E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::BB6 ::abc(){vfunc_called(this, "_ZN3ccc3BB63abcEv");}
void  ccc::BB6 ::efg(){vfunc_called(this, "_ZN3ccc3BB63efgEv");}
ccc::BB6 ::~BB6(){ note_dtor("_ZN3ccc3BB6E", this);} // tgen
ccc::BB6 ::BB6(){ note_ctor("_ZN3ccc3BB6E", this);} // tgen
}
static void Test__ZN3ccc3BB6E()
{
  extern Class_Descriptor cd__ZN3ccc3BB6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB6E, buf);
    ::ccc::BB6 *dp, &lv = *(dp=new (buf) ::ccc::BB6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB6E)");
    test_class_info(&lv, &cd__ZN3ccc3BB6E);
    dp->::ccc::BB6::~BB6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB6E(Test__ZN3ccc3BB6E, "_ZN3ccc3BB6E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB6C1Ev();
extern void _ZN3ccc3BB6D1Ev();
Name_Map name_map__ZN3ccc3BB6E[] = {
  NSPAIR(_ZN3ccc3BB6C1Ev),
  NSPAIR(_ZN3ccc3BB6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern void _ZN3ccc3BB63abcEv();
extern void _ZN3ccc3BB63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB6E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
Class_Descriptor cd__ZN3ccc3BB6E = {  "_ZN3ccc3BB6E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB6E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB6E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB6E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA7  {
  virtual void  abc(); // _ZN3ccc3AA73abcEv
  virtual void  pqr(); // _ZN3ccc3AA73pqrEv
  ~AA7(); // tgen
  AA7(); // tgen
};
//SIG(-1 _ZN3ccc3AA7E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::AA7 ::abc(){vfunc_called(this, "_ZN3ccc3AA73abcEv");}
void  ccc::AA7 ::pqr(){vfunc_called(this, "_ZN3ccc3AA73pqrEv");}
ccc::AA7 ::~AA7(){ note_dtor("_ZN3ccc3AA7E", this);} // tgen
ccc::AA7 ::AA7(){ note_ctor("_ZN3ccc3AA7E", this);} // tgen
}
static void Test__ZN3ccc3AA7E()
{
  extern Class_Descriptor cd__ZN3ccc3AA7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA7E, buf);
    ::ccc::AA7 *dp, &lv = *(dp=new (buf) ::ccc::AA7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA7E)");
    test_class_info(&lv, &cd__ZN3ccc3AA7E);
    dp->::ccc::AA7::~AA7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA7E(Test__ZN3ccc3AA7E, "_ZN3ccc3AA7E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA7C1Ev();
extern void _ZN3ccc3AA7D1Ev();
Name_Map name_map__ZN3ccc3AA7E[] = {
  NSPAIR(_ZN3ccc3AA7C1Ev),
  NSPAIR(_ZN3ccc3AA7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA7E[];
extern void _ZN3ccc3AA73abcEv();
extern void _ZN3ccc3AA73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA7E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA7E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA73pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA7E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA7E[];
Class_Descriptor cd__ZN3ccc3AA7E = {  "_ZN3ccc3AA7E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA7E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA7E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA7E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB7  {
  virtual void  abc(); // _ZN3ccc3BB73abcEv
  virtual void  pqr(); // _ZN3ccc3BB73pqrEv
  ~BB7(); // tgen
  BB7(); // tgen
};
//SIG(-1 _ZN3ccc3BB7E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::BB7 ::abc(){vfunc_called(this, "_ZN3ccc3BB73abcEv");}
void  ccc::BB7 ::pqr(){vfunc_called(this, "_ZN3ccc3BB73pqrEv");}
ccc::BB7 ::~BB7(){ note_dtor("_ZN3ccc3BB7E", this);} // tgen
ccc::BB7 ::BB7(){ note_ctor("_ZN3ccc3BB7E", this);} // tgen
}
static void Test__ZN3ccc3BB7E()
{
  extern Class_Descriptor cd__ZN3ccc3BB7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB7E, buf);
    ::ccc::BB7 *dp, &lv = *(dp=new (buf) ::ccc::BB7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB7E)");
    test_class_info(&lv, &cd__ZN3ccc3BB7E);
    dp->::ccc::BB7::~BB7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB7E(Test__ZN3ccc3BB7E, "_ZN3ccc3BB7E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB7C1Ev();
extern void _ZN3ccc3BB7D1Ev();
Name_Map name_map__ZN3ccc3BB7E[] = {
  NSPAIR(_ZN3ccc3BB7C1Ev),
  NSPAIR(_ZN3ccc3BB7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern void _ZN3ccc3BB73abcEv();
extern void _ZN3ccc3BB73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB7E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB7E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
Class_Descriptor cd__ZN3ccc3BB7E = {  "_ZN3ccc3BB7E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB7E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB7E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB7E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA8  {
  virtual void  efg(); // _ZN3ccc3AA83efgEv
  virtual void  abc(); // _ZN3ccc3AA83abcEv
  ~AA8(); // tgen
  AA8(); // tgen
};
//SIG(-1 _ZN3ccc3AA8E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::AA8 ::efg(){vfunc_called(this, "_ZN3ccc3AA83efgEv");}
void  ccc::AA8 ::abc(){vfunc_called(this, "_ZN3ccc3AA83abcEv");}
ccc::AA8 ::~AA8(){ note_dtor("_ZN3ccc3AA8E", this);} // tgen
ccc::AA8 ::AA8(){ note_ctor("_ZN3ccc3AA8E", this);} // tgen
}
static void Test__ZN3ccc3AA8E()
{
  extern Class_Descriptor cd__ZN3ccc3AA8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA8E, buf);
    ::ccc::AA8 *dp, &lv = *(dp=new (buf) ::ccc::AA8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA8E)");
    test_class_info(&lv, &cd__ZN3ccc3AA8E);
    dp->::ccc::AA8::~AA8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA8E(Test__ZN3ccc3AA8E, "_ZN3ccc3AA8E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA8C1Ev();
extern void _ZN3ccc3AA8D1Ev();
Name_Map name_map__ZN3ccc3AA8E[] = {
  NSPAIR(_ZN3ccc3AA8C1Ev),
  NSPAIR(_ZN3ccc3AA8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA8E[];
extern void _ZN3ccc3AA83efgEv();
extern void _ZN3ccc3AA83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA8E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA83abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA8E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA8E[];
Class_Descriptor cd__ZN3ccc3AA8E = {  "_ZN3ccc3AA8E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA8E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA8E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA8E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB8  {
  virtual void  efg(); // _ZN3ccc3BB83efgEv
  virtual void  abc(); // _ZN3ccc3BB83abcEv
  ~BB8(); // tgen
  BB8(); // tgen
};
//SIG(-1 _ZN3ccc3BB8E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::BB8 ::efg(){vfunc_called(this, "_ZN3ccc3BB83efgEv");}
void  ccc::BB8 ::abc(){vfunc_called(this, "_ZN3ccc3BB83abcEv");}
ccc::BB8 ::~BB8(){ note_dtor("_ZN3ccc3BB8E", this);} // tgen
ccc::BB8 ::BB8(){ note_ctor("_ZN3ccc3BB8E", this);} // tgen
}
static void Test__ZN3ccc3BB8E()
{
  extern Class_Descriptor cd__ZN3ccc3BB8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB8E, buf);
    ::ccc::BB8 *dp, &lv = *(dp=new (buf) ::ccc::BB8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB8E)");
    test_class_info(&lv, &cd__ZN3ccc3BB8E);
    dp->::ccc::BB8::~BB8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB8E(Test__ZN3ccc3BB8E, "_ZN3ccc3BB8E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB8C1Ev();
extern void _ZN3ccc3BB8D1Ev();
Name_Map name_map__ZN3ccc3BB8E[] = {
  NSPAIR(_ZN3ccc3BB8C1Ev),
  NSPAIR(_ZN3ccc3BB8D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern void _ZN3ccc3BB83efgEv();
extern void _ZN3ccc3BB83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB8E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB83abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
Class_Descriptor cd__ZN3ccc3BB8E = {  "_ZN3ccc3BB8E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB8E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB8E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB8E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA9  {
  virtual void  efg(); // _ZN3ccc3AA93efgEv
  virtual void  pqr(); // _ZN3ccc3AA93pqrEv
  ~AA9(); // tgen
  AA9(); // tgen
};
//SIG(-1 _ZN3ccc3AA9E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::AA9 ::efg(){vfunc_called(this, "_ZN3ccc3AA93efgEv");}
void  ccc::AA9 ::pqr(){vfunc_called(this, "_ZN3ccc3AA93pqrEv");}
ccc::AA9 ::~AA9(){ note_dtor("_ZN3ccc3AA9E", this);} // tgen
ccc::AA9 ::AA9(){ note_ctor("_ZN3ccc3AA9E", this);} // tgen
}
static void Test__ZN3ccc3AA9E()
{
  extern Class_Descriptor cd__ZN3ccc3AA9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3AA9E, buf);
    ::ccc::AA9 *dp, &lv = *(dp=new (buf) ::ccc::AA9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3AA9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3AA9E)");
    test_class_info(&lv, &cd__ZN3ccc3AA9E);
    dp->::ccc::AA9::~AA9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3AA9E(Test__ZN3ccc3AA9E, "_ZN3ccc3AA9E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3AA9C1Ev();
extern void _ZN3ccc3AA9D1Ev();
Name_Map name_map__ZN3ccc3AA9E[] = {
  NSPAIR(_ZN3ccc3AA9C1Ev),
  NSPAIR(_ZN3ccc3AA9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3AA9E[];
extern void _ZN3ccc3AA93efgEv();
extern void _ZN3ccc3AA93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3AA9E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3AA9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA93pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3AA9E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA9E[];
Class_Descriptor cd__ZN3ccc3AA9E = {  "_ZN3ccc3AA9E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3AA9E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3AA9E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3AA9E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB9  {
  virtual void  efg(); // _ZN3ccc3BB93efgEv
  virtual void  pqr(); // _ZN3ccc3BB93pqrEv
  ~BB9(); // tgen
  BB9(); // tgen
};
//SIG(-1 _ZN3ccc3BB9E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::BB9 ::efg(){vfunc_called(this, "_ZN3ccc3BB93efgEv");}
void  ccc::BB9 ::pqr(){vfunc_called(this, "_ZN3ccc3BB93pqrEv");}
ccc::BB9 ::~BB9(){ note_dtor("_ZN3ccc3BB9E", this);} // tgen
ccc::BB9 ::BB9(){ note_ctor("_ZN3ccc3BB9E", this);} // tgen
}
static void Test__ZN3ccc3BB9E()
{
  extern Class_Descriptor cd__ZN3ccc3BB9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc3BB9E, buf);
    ::ccc::BB9 *dp, &lv = *(dp=new (buf) ::ccc::BB9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc3BB9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc3BB9E)");
    test_class_info(&lv, &cd__ZN3ccc3BB9E);
    dp->::ccc::BB9::~BB9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc3BB9E(Test__ZN3ccc3BB9E, "_ZN3ccc3BB9E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc3BB9C1Ev();
extern void _ZN3ccc3BB9D1Ev();
Name_Map name_map__ZN3ccc3BB9E[] = {
  NSPAIR(_ZN3ccc3BB9C1Ev),
  NSPAIR(_ZN3ccc3BB9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern void _ZN3ccc3BB93efgEv();
extern void _ZN3ccc3BB93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc3BB9E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc3BB9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB93pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
Class_Descriptor cd__ZN3ccc3BB9E = {  "_ZN3ccc3BB9E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc3BB9E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc3BB9E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc3BB9E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA10  {
  virtual void  pqr(); // _ZN3ccc4AA103pqrEv
  virtual void  abc(); // _ZN3ccc4AA103abcEv
  ~AA10(); // tgen
  AA10(); // tgen
};
//SIG(-1 _ZN3ccc4AA10E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::AA10 ::pqr(){vfunc_called(this, "_ZN3ccc4AA103pqrEv");}
void  ccc::AA10 ::abc(){vfunc_called(this, "_ZN3ccc4AA103abcEv");}
ccc::AA10 ::~AA10(){ note_dtor("_ZN3ccc4AA10E", this);} // tgen
ccc::AA10 ::AA10(){ note_ctor("_ZN3ccc4AA10E", this);} // tgen
}
static void Test__ZN3ccc4AA10E()
{
  extern Class_Descriptor cd__ZN3ccc4AA10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4AA10E, buf);
    ::ccc::AA10 *dp, &lv = *(dp=new (buf) ::ccc::AA10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4AA10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4AA10E)");
    test_class_info(&lv, &cd__ZN3ccc4AA10E);
    dp->::ccc::AA10::~AA10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4AA10E(Test__ZN3ccc4AA10E, "_ZN3ccc4AA10E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4AA10C1Ev();
extern void _ZN3ccc4AA10D1Ev();
Name_Map name_map__ZN3ccc4AA10E[] = {
  NSPAIR(_ZN3ccc4AA10C1Ev),
  NSPAIR(_ZN3ccc4AA10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern void _ZN3ccc4AA103pqrEv();
extern void _ZN3ccc4AA103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc4AA10E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4AA10E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA103abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc4AA10E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA10E[];
Class_Descriptor cd__ZN3ccc4AA10E = {  "_ZN3ccc4AA10E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4AA10E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4AA10E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4AA10E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB10  {
  virtual void  pqr(); // _ZN3ccc4BB103pqrEv
  virtual void  abc(); // _ZN3ccc4BB103abcEv
  ~BB10(); // tgen
  BB10(); // tgen
};
//SIG(-1 _ZN3ccc4BB10E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::BB10 ::pqr(){vfunc_called(this, "_ZN3ccc4BB103pqrEv");}
void  ccc::BB10 ::abc(){vfunc_called(this, "_ZN3ccc4BB103abcEv");}
ccc::BB10 ::~BB10(){ note_dtor("_ZN3ccc4BB10E", this);} // tgen
ccc::BB10 ::BB10(){ note_ctor("_ZN3ccc4BB10E", this);} // tgen
}
static void Test__ZN3ccc4BB10E()
{
  extern Class_Descriptor cd__ZN3ccc4BB10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4BB10E, buf);
    ::ccc::BB10 *dp, &lv = *(dp=new (buf) ::ccc::BB10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4BB10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4BB10E)");
    test_class_info(&lv, &cd__ZN3ccc4BB10E);
    dp->::ccc::BB10::~BB10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4BB10E(Test__ZN3ccc4BB10E, "_ZN3ccc4BB10E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4BB10C1Ev();
extern void _ZN3ccc4BB10D1Ev();
Name_Map name_map__ZN3ccc4BB10E[] = {
  NSPAIR(_ZN3ccc4BB10C1Ev),
  NSPAIR(_ZN3ccc4BB10D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern void _ZN3ccc4BB103pqrEv();
extern void _ZN3ccc4BB103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc4BB10E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4BB10E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4BB103abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
Class_Descriptor cd__ZN3ccc4BB10E = {  "_ZN3ccc4BB10E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4BB10E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4BB10E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4BB10E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA11  {
  virtual void  pqr(); // _ZN3ccc4AA113pqrEv
  virtual void  efg(); // _ZN3ccc4AA113efgEv
  ~AA11(); // tgen
  AA11(); // tgen
};
//SIG(-1 _ZN3ccc4AA11E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::AA11 ::pqr(){vfunc_called(this, "_ZN3ccc4AA113pqrEv");}
void  ccc::AA11 ::efg(){vfunc_called(this, "_ZN3ccc4AA113efgEv");}
ccc::AA11 ::~AA11(){ note_dtor("_ZN3ccc4AA11E", this);} // tgen
ccc::AA11 ::AA11(){ note_ctor("_ZN3ccc4AA11E", this);} // tgen
}
static void Test__ZN3ccc4AA11E()
{
  extern Class_Descriptor cd__ZN3ccc4AA11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4AA11E, buf);
    ::ccc::AA11 *dp, &lv = *(dp=new (buf) ::ccc::AA11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4AA11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4AA11E)");
    test_class_info(&lv, &cd__ZN3ccc4AA11E);
    dp->::ccc::AA11::~AA11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4AA11E(Test__ZN3ccc4AA11E, "_ZN3ccc4AA11E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4AA11C1Ev();
extern void _ZN3ccc4AA11D1Ev();
Name_Map name_map__ZN3ccc4AA11E[] = {
  NSPAIR(_ZN3ccc4AA11C1Ev),
  NSPAIR(_ZN3ccc4AA11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4AA11E[];
extern void _ZN3ccc4AA113pqrEv();
extern void _ZN3ccc4AA113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc4AA11E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4AA11E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4AA113efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc4AA11E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA11E[];
Class_Descriptor cd__ZN3ccc4AA11E = {  "_ZN3ccc4AA11E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4AA11E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4AA11E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4AA11E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB11  {
  virtual void  pqr(); // _ZN3ccc4BB113pqrEv
  virtual void  efg(); // _ZN3ccc4BB113efgEv
  ~BB11(); // tgen
  BB11(); // tgen
};
//SIG(-1 _ZN3ccc4BB11E) C1{ v1 v2}
}
namespace ccc { 
void  ccc::BB11 ::pqr(){vfunc_called(this, "_ZN3ccc4BB113pqrEv");}
void  ccc::BB11 ::efg(){vfunc_called(this, "_ZN3ccc4BB113efgEv");}
ccc::BB11 ::~BB11(){ note_dtor("_ZN3ccc4BB11E", this);} // tgen
ccc::BB11 ::BB11(){ note_ctor("_ZN3ccc4BB11E", this);} // tgen
}
static void Test__ZN3ccc4BB11E()
{
  extern Class_Descriptor cd__ZN3ccc4BB11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4BB11E, buf);
    ::ccc::BB11 *dp, &lv = *(dp=new (buf) ::ccc::BB11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4BB11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4BB11E)");
    test_class_info(&lv, &cd__ZN3ccc4BB11E);
    dp->::ccc::BB11::~BB11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4BB11E(Test__ZN3ccc4BB11E, "_ZN3ccc4BB11E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4BB11C1Ev();
extern void _ZN3ccc4BB11D1Ev();
Name_Map name_map__ZN3ccc4BB11E[] = {
  NSPAIR(_ZN3ccc4BB11C1Ev),
  NSPAIR(_ZN3ccc4BB11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern void _ZN3ccc4BB113pqrEv();
extern void _ZN3ccc4BB113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc4BB11E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4BB11E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4BB113efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
Class_Descriptor cd__ZN3ccc4BB11E = {  "_ZN3ccc4BB11E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4BB11E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4BB11E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4BB11E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA12  {
  virtual void  abc(); // _ZN3ccc4AA123abcEv
  ~AA12(); // tgen
  AA12(); // tgen
};
//SIG(-1 _ZN3ccc4AA12E) C1{ v1}
}
namespace ccc { 
void  ccc::AA12 ::abc(){vfunc_called(this, "_ZN3ccc4AA123abcEv");}
ccc::AA12 ::~AA12(){ note_dtor("_ZN3ccc4AA12E", this);} // tgen
ccc::AA12 ::AA12(){ note_ctor("_ZN3ccc4AA12E", this);} // tgen
}
static void Test__ZN3ccc4AA12E()
{
  extern Class_Descriptor cd__ZN3ccc4AA12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4AA12E, buf);
    ::ccc::AA12 *dp, &lv = *(dp=new (buf) ::ccc::AA12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4AA12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4AA12E)");
    test_class_info(&lv, &cd__ZN3ccc4AA12E);
    dp->::ccc::AA12::~AA12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4AA12E(Test__ZN3ccc4AA12E, "_ZN3ccc4AA12E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4AA12C1Ev();
extern void _ZN3ccc4AA12D1Ev();
Name_Map name_map__ZN3ccc4AA12E[] = {
  NSPAIR(_ZN3ccc4AA12C1Ev),
  NSPAIR(_ZN3ccc4AA12D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4AA12E[];
extern void _ZN3ccc4AA123abcEv();
static  VTBL_ENTRY vtc__ZN3ccc4AA12E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4AA12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA123abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc4AA12E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA12E[];
Class_Descriptor cd__ZN3ccc4AA12E = {  "_ZN3ccc4AA12E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4AA12E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4AA12E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4AA12E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB12  {
  virtual void  abc(); // _ZN3ccc4BB123abcEv
  ~BB12(); // tgen
  BB12(); // tgen
};
//SIG(-1 _ZN3ccc4BB12E) C1{ v1}
}
namespace ccc { 
void  ccc::BB12 ::abc(){vfunc_called(this, "_ZN3ccc4BB123abcEv");}
ccc::BB12 ::~BB12(){ note_dtor("_ZN3ccc4BB12E", this);} // tgen
ccc::BB12 ::BB12(){ note_ctor("_ZN3ccc4BB12E", this);} // tgen
}
static void Test__ZN3ccc4BB12E()
{
  extern Class_Descriptor cd__ZN3ccc4BB12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4BB12E, buf);
    ::ccc::BB12 *dp, &lv = *(dp=new (buf) ::ccc::BB12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4BB12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4BB12E)");
    test_class_info(&lv, &cd__ZN3ccc4BB12E);
    dp->::ccc::BB12::~BB12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4BB12E(Test__ZN3ccc4BB12E, "_ZN3ccc4BB12E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4BB12C1Ev();
extern void _ZN3ccc4BB12D1Ev();
Name_Map name_map__ZN3ccc4BB12E[] = {
  NSPAIR(_ZN3ccc4BB12C1Ev),
  NSPAIR(_ZN3ccc4BB12D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern void _ZN3ccc4BB123abcEv();
static  VTBL_ENTRY vtc__ZN3ccc4BB12E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4BB12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB123abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB12E[];
Class_Descriptor cd__ZN3ccc4BB12E = {  "_ZN3ccc4BB12E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4BB12E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4BB12E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4BB12E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA13  {
  virtual void  efg(); // _ZN3ccc4AA133efgEv
  ~AA13(); // tgen
  AA13(); // tgen
};
//SIG(-1 _ZN3ccc4AA13E) C1{ v1}
}
namespace ccc { 
void  ccc::AA13 ::efg(){vfunc_called(this, "_ZN3ccc4AA133efgEv");}
ccc::AA13 ::~AA13(){ note_dtor("_ZN3ccc4AA13E", this);} // tgen
ccc::AA13 ::AA13(){ note_ctor("_ZN3ccc4AA13E", this);} // tgen
}
static void Test__ZN3ccc4AA13E()
{
  extern Class_Descriptor cd__ZN3ccc4AA13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4AA13E, buf);
    ::ccc::AA13 *dp, &lv = *(dp=new (buf) ::ccc::AA13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4AA13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4AA13E)");
    test_class_info(&lv, &cd__ZN3ccc4AA13E);
    dp->::ccc::AA13::~AA13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4AA13E(Test__ZN3ccc4AA13E, "_ZN3ccc4AA13E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4AA13C1Ev();
extern void _ZN3ccc4AA13D1Ev();
Name_Map name_map__ZN3ccc4AA13E[] = {
  NSPAIR(_ZN3ccc4AA13C1Ev),
  NSPAIR(_ZN3ccc4AA13D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4AA13E[];
extern void _ZN3ccc4AA133efgEv();
static  VTBL_ENTRY vtc__ZN3ccc4AA13E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4AA13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA133efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc4AA13E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA13E[];
Class_Descriptor cd__ZN3ccc4AA13E = {  "_ZN3ccc4AA13E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4AA13E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4AA13E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4AA13E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB13  {
  virtual void  efg(); // _ZN3ccc4BB133efgEv
  ~BB13(); // tgen
  BB13(); // tgen
};
//SIG(-1 _ZN3ccc4BB13E) C1{ v1}
}
namespace ccc { 
void  ccc::BB13 ::efg(){vfunc_called(this, "_ZN3ccc4BB133efgEv");}
ccc::BB13 ::~BB13(){ note_dtor("_ZN3ccc4BB13E", this);} // tgen
ccc::BB13 ::BB13(){ note_ctor("_ZN3ccc4BB13E", this);} // tgen
}
static void Test__ZN3ccc4BB13E()
{
  extern Class_Descriptor cd__ZN3ccc4BB13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4BB13E, buf);
    ::ccc::BB13 *dp, &lv = *(dp=new (buf) ::ccc::BB13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4BB13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4BB13E)");
    test_class_info(&lv, &cd__ZN3ccc4BB13E);
    dp->::ccc::BB13::~BB13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4BB13E(Test__ZN3ccc4BB13E, "_ZN3ccc4BB13E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4BB13C1Ev();
extern void _ZN3ccc4BB13D1Ev();
Name_Map name_map__ZN3ccc4BB13E[] = {
  NSPAIR(_ZN3ccc4BB13C1Ev),
  NSPAIR(_ZN3ccc4BB13D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4BB13E[];
extern void _ZN3ccc4BB133efgEv();
static  VTBL_ENTRY vtc__ZN3ccc4BB13E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4BB13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB133efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc4BB13E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB13E[];
Class_Descriptor cd__ZN3ccc4BB13E = {  "_ZN3ccc4BB13E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4BB13E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4BB13E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4BB13E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA14  {
  virtual void  pqr(); // _ZN3ccc4AA143pqrEv
  ~AA14(); // tgen
  AA14(); // tgen
};
//SIG(-1 _ZN3ccc4AA14E) C1{ v1}
}
namespace ccc { 
void  ccc::AA14 ::pqr(){vfunc_called(this, "_ZN3ccc4AA143pqrEv");}
ccc::AA14 ::~AA14(){ note_dtor("_ZN3ccc4AA14E", this);} // tgen
ccc::AA14 ::AA14(){ note_ctor("_ZN3ccc4AA14E", this);} // tgen
}
static void Test__ZN3ccc4AA14E()
{
  extern Class_Descriptor cd__ZN3ccc4AA14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4AA14E, buf);
    ::ccc::AA14 *dp, &lv = *(dp=new (buf) ::ccc::AA14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4AA14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4AA14E)");
    test_class_info(&lv, &cd__ZN3ccc4AA14E);
    dp->::ccc::AA14::~AA14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4AA14E(Test__ZN3ccc4AA14E, "_ZN3ccc4AA14E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4AA14C1Ev();
extern void _ZN3ccc4AA14D1Ev();
Name_Map name_map__ZN3ccc4AA14E[] = {
  NSPAIR(_ZN3ccc4AA14C1Ev),
  NSPAIR(_ZN3ccc4AA14D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4AA14E[];
extern void _ZN3ccc4AA143pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc4AA14E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4AA14E[0]),
  (VTBL_ENTRY)&_ZN3ccc4AA143pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc4AA14E[];
extern  VTBL_ENTRY _ZTVN3ccc4AA14E[];
Class_Descriptor cd__ZN3ccc4AA14E = {  "_ZN3ccc4AA14E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4AA14E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4AA14E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4AA14E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB14  {
  virtual void  pqr(); // _ZN3ccc4BB143pqrEv
  ~BB14(); // tgen
  BB14(); // tgen
};
//SIG(-1 _ZN3ccc4BB14E) C1{ v1}
}
namespace ccc { 
void  ccc::BB14 ::pqr(){vfunc_called(this, "_ZN3ccc4BB143pqrEv");}
ccc::BB14 ::~BB14(){ note_dtor("_ZN3ccc4BB14E", this);} // tgen
ccc::BB14 ::BB14(){ note_ctor("_ZN3ccc4BB14E", this);} // tgen
}
static void Test__ZN3ccc4BB14E()
{
  extern Class_Descriptor cd__ZN3ccc4BB14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd__ZN3ccc4BB14E, buf);
    ::ccc::BB14 *dp, &lv = *(dp=new (buf) ::ccc::BB14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(_ZN3ccc4BB14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc4BB14E)");
    test_class_info(&lv, &cd__ZN3ccc4BB14E);
    dp->::ccc::BB14::~BB14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc4BB14E(Test__ZN3ccc4BB14E, "_ZN3ccc4BB14E", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3ccc4BB14C1Ev();
extern void _ZN3ccc4BB14D1Ev();
Name_Map name_map__ZN3ccc4BB14E[] = {
  NSPAIR(_ZN3ccc4BB14C1Ev),
  NSPAIR(_ZN3ccc4BB14D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3ccc4BB14E[];
extern void _ZN3ccc4BB143pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc4BB14E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc4BB14E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB143pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc4BB14E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB14E[];
Class_Descriptor cd__ZN3ccc4BB14E = {  "_ZN3ccc4BB14E", // class name
  0,0,//no base classes
  &(vtc__ZN3ccc4BB14E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTIN3ccc4BB14E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3ccc4BB14E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  AA15  {
};
//SIG(-1 _ZN3ccc4AA15E) C1{}
}
namespace ccc { 
}
static void Test__ZN3ccc4AA15E()
{
  {
    init_simple_test("_ZN3ccc4AA15E");
    ::ccc::AA15 lv;
    check2(sizeof(lv), 1, "sizeof(_ZN3ccc4AA15E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN3ccc4AA15E)");
  }
}
static Arrange_To_Call_Me v_ZN3ccc4AA15E(Test__ZN3ccc4AA15E, "_ZN3ccc4AA15E", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTIN3ccc4AA15E[];
VTBL_ENTRY *P__ZTIN3ccc4AA15E = _ZTIN3ccc4AA15E; 
Class_Descriptor cd__ZN3ccc4AA15E = {  "_ZN3ccc4AA15E", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTIN3ccc4AA15E),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  BB15  {
};
//SIG(-1 _ZN3ccc4BB15E) C1{}
}
namespace ccc { 
}
static void Test__ZN3ccc4BB15E()
{
  {
    init_simple_test("_ZN3ccc4BB15E");
    ::ccc::BB15 lv;
    check2(sizeof(lv), 1, "sizeof(_ZN3ccc4BB15E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN3ccc4BB15E)");
  }
}
static Arrange_To_Call_Me v_ZN3ccc4BB15E(Test__ZN3ccc4BB15E, "_ZN3ccc4BB15E", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTIN3ccc4BB15E[];
VTBL_ENTRY *P__ZTIN3ccc4BB15E = _ZTIN3ccc4BB15E; 
Class_Descriptor cd__ZN3ccc4BB15E = {  "_ZN3ccc4BB15E", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTIN3ccc4BB15E),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x0y0  : ::ccc::AA0 , ::ccc::BB0 {
  virtual void  abc(); // _ZN3ccc7CC0x0y03abcEv
  virtual void  efg(); // _ZN3ccc7CC0x0y03efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x0y03pqrEv
  ~CC0x0y0(); // tgen
  CC0x0y0(); // tgen
};
//SIG(1 _ZN3ccc7CC0x0y0E) C1{ BC2{ v1 v2 v3} BC3{ v1 v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x0y0 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x0y03abcEv");}
void  ccc::CC0x0y0 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x0y03efgEv");}
void  ccc::CC0x0y0 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x0y03pqrEv");}
ccc::CC0x0y0 ::~CC0x0y0(){ note_dtor("_ZN3ccc7CC0x0y0E", this);} // tgen
ccc::CC0x0y0 ::CC0x0y0(){ note_ctor("_ZN3ccc7CC0x0y0E", this);} // tgen
}
static void Test__ZN3ccc7CC0x0y0E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x0y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x0y0E, buf);
    ::ccc::CC0x0y0 *dp, &lv = *(dp=new (buf) ::ccc::CC0x0y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x0y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x0y0E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x0y0E");
    check_base_class_offset(lv, (::ccc::BB0*), ABISELECT(8,4), "_ZN3ccc7CC0x0y0E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x0y0E);
    dp->::ccc::CC0x0y0::~CC0x0y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x0y0E(Test__ZN3ccc7CC0x0y0E, "_ZN3ccc7CC0x0y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x0y0C1Ev();
extern void _ZN3ccc7CC0x0y0D1Ev();
Name_Map name_map__ZN3ccc7CC0x0y0E[] = {
  NSPAIR(_ZN3ccc7CC0x0y0C1Ev),
  NSPAIR(_ZN3ccc7CC0x0y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB0E;
extern VTBL_ENTRY _ZTIN3ccc3BB0E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB0E[];
static Base_Class bases__ZN3ccc7CC0x0y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB0E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x0y0E[];
extern void _ZN3ccc7CC0x0y03abcEv();
extern void _ZN3ccc7CC0x0y03efgEv();
extern void _ZN3ccc7CC0x0y03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x0y03abcEv,_ZThn4_N3ccc7CC0x0y03abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x0y03efgEv,_ZThn4_N3ccc7CC0x0y03efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x0y03pqrEv,_ZThn4_N3ccc7CC0x0y03pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x0y0E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x0y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x0y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x0y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x0y03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x0y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x0y03abcEv,_ZThn4_N3ccc7CC0x0y03abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x0y03efgEv,_ZThn4_N3ccc7CC0x0y03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x0y03pqrEv,_ZThn4_N3ccc7CC0x0y03pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x0y0E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x0y0E[];
Class_Descriptor cd__ZN3ccc7CC0x0y0E = {  "_ZN3ccc7CC0x0y0E", // class name
  bases__ZN3ccc7CC0x0y0E, 2,
  &(vtc__ZN3ccc7CC0x0y0E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x0y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x0y0E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x0y1  : ::ccc::AA0 , ::ccc::BB0 {
  virtual void  abc(); // _ZN3ccc7CC0x0y13abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x0y13pqrEv
  virtual void  efg(); // _ZN3ccc7CC0x0y13efgEv
  ~CC0x0y1(); // tgen
  CC0x0y1(); // tgen
};
//SIG(1 _ZN3ccc7CC0x0y1E) C1{ BC2{ v1 v3 v2} BC3{ v1 v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x0y1 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x0y13abcEv");}
void  ccc::CC0x0y1 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x0y13pqrEv");}
void  ccc::CC0x0y1 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x0y13efgEv");}
ccc::CC0x0y1 ::~CC0x0y1(){ note_dtor("_ZN3ccc7CC0x0y1E", this);} // tgen
ccc::CC0x0y1 ::CC0x0y1(){ note_ctor("_ZN3ccc7CC0x0y1E", this);} // tgen
}
static void Test__ZN3ccc7CC0x0y1E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x0y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x0y1E, buf);
    ::ccc::CC0x0y1 *dp, &lv = *(dp=new (buf) ::ccc::CC0x0y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x0y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x0y1E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x0y1E");
    check_base_class_offset(lv, (::ccc::BB0*), ABISELECT(8,4), "_ZN3ccc7CC0x0y1E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x0y1E);
    dp->::ccc::CC0x0y1::~CC0x0y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x0y1E(Test__ZN3ccc7CC0x0y1E, "_ZN3ccc7CC0x0y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x0y1C1Ev();
extern void _ZN3ccc7CC0x0y1D1Ev();
Name_Map name_map__ZN3ccc7CC0x0y1E[] = {
  NSPAIR(_ZN3ccc7CC0x0y1C1Ev),
  NSPAIR(_ZN3ccc7CC0x0y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB0E;
extern VTBL_ENTRY _ZTIN3ccc3BB0E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB0E[];
static Base_Class bases__ZN3ccc7CC0x0y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB0E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x0y1E[];
extern void _ZN3ccc7CC0x0y13abcEv();
extern void _ZN3ccc7CC0x0y13efgEv();
extern void _ZN3ccc7CC0x0y13pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x0y13abcEv,_ZThn4_N3ccc7CC0x0y13abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x0y13efgEv,_ZThn4_N3ccc7CC0x0y13efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x0y13pqrEv,_ZThn4_N3ccc7CC0x0y13pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x0y1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x0y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x0y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x0y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x0y13pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x0y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x0y13abcEv,_ZThn4_N3ccc7CC0x0y13abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x0y13efgEv,_ZThn4_N3ccc7CC0x0y13efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x0y13pqrEv,_ZThn4_N3ccc7CC0x0y13pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x0y1E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x0y1E[];
Class_Descriptor cd__ZN3ccc7CC0x0y1E = {  "_ZN3ccc7CC0x0y1E", // class name
  bases__ZN3ccc7CC0x0y1E, 2,
  &(vtc__ZN3ccc7CC0x0y1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x0y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x0y1E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x0y2  : ::ccc::AA0 , ::ccc::BB0 {
  virtual void  efg(); // _ZN3ccc7CC0x0y23efgEv
  virtual void  abc(); // _ZN3ccc7CC0x0y23abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x0y23pqrEv
  ~CC0x0y2(); // tgen
  CC0x0y2(); // tgen
};
//SIG(1 _ZN3ccc7CC0x0y2E) C1{ BC2{ v2 v1 v3} BC3{ v2 v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x0y2 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x0y23efgEv");}
void  ccc::CC0x0y2 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x0y23abcEv");}
void  ccc::CC0x0y2 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x0y23pqrEv");}
ccc::CC0x0y2 ::~CC0x0y2(){ note_dtor("_ZN3ccc7CC0x0y2E", this);} // tgen
ccc::CC0x0y2 ::CC0x0y2(){ note_ctor("_ZN3ccc7CC0x0y2E", this);} // tgen
}
static void Test__ZN3ccc7CC0x0y2E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x0y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x0y2E, buf);
    ::ccc::CC0x0y2 *dp, &lv = *(dp=new (buf) ::ccc::CC0x0y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x0y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x0y2E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x0y2E");
    check_base_class_offset(lv, (::ccc::BB0*), ABISELECT(8,4), "_ZN3ccc7CC0x0y2E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x0y2E);
    dp->::ccc::CC0x0y2::~CC0x0y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x0y2E(Test__ZN3ccc7CC0x0y2E, "_ZN3ccc7CC0x0y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x0y2C1Ev();
extern void _ZN3ccc7CC0x0y2D1Ev();
Name_Map name_map__ZN3ccc7CC0x0y2E[] = {
  NSPAIR(_ZN3ccc7CC0x0y2C1Ev),
  NSPAIR(_ZN3ccc7CC0x0y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB0E;
extern VTBL_ENTRY _ZTIN3ccc3BB0E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB0E[];
static Base_Class bases__ZN3ccc7CC0x0y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB0E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x0y2E[];
extern void _ZN3ccc7CC0x0y23abcEv();
extern void _ZN3ccc7CC0x0y23efgEv();
extern void _ZN3ccc7CC0x0y23pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x0y23abcEv,_ZThn4_N3ccc7CC0x0y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x0y23efgEv,_ZThn4_N3ccc7CC0x0y23efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x0y23pqrEv,_ZThn4_N3ccc7CC0x0y23pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x0y2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x0y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x0y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x0y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x0y23pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x0y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x0y23abcEv,_ZThn4_N3ccc7CC0x0y23abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x0y23efgEv,_ZThn4_N3ccc7CC0x0y23efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x0y23pqrEv,_ZThn4_N3ccc7CC0x0y23pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x0y2E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x0y2E[];
Class_Descriptor cd__ZN3ccc7CC0x0y2E = {  "_ZN3ccc7CC0x0y2E", // class name
  bases__ZN3ccc7CC0x0y2E, 2,
  &(vtc__ZN3ccc7CC0x0y2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x0y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x0y2E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x0y3  : ::ccc::AA0 , ::ccc::BB0 {
  virtual void  efg(); // _ZN3ccc7CC0x0y33efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x0y33pqrEv
  virtual void  abc(); // _ZN3ccc7CC0x0y33abcEv
  ~CC0x0y3(); // tgen
  CC0x0y3(); // tgen
};
//SIG(1 _ZN3ccc7CC0x0y3E) C1{ BC2{ v3 v1 v2} BC3{ v3 v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x0y3 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x0y33efgEv");}
void  ccc::CC0x0y3 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x0y33pqrEv");}
void  ccc::CC0x0y3 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x0y33abcEv");}
ccc::CC0x0y3 ::~CC0x0y3(){ note_dtor("_ZN3ccc7CC0x0y3E", this);} // tgen
ccc::CC0x0y3 ::CC0x0y3(){ note_ctor("_ZN3ccc7CC0x0y3E", this);} // tgen
}
static void Test__ZN3ccc7CC0x0y3E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x0y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x0y3E, buf);
    ::ccc::CC0x0y3 *dp, &lv = *(dp=new (buf) ::ccc::CC0x0y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x0y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x0y3E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x0y3E");
    check_base_class_offset(lv, (::ccc::BB0*), ABISELECT(8,4), "_ZN3ccc7CC0x0y3E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x0y3E);
    dp->::ccc::CC0x0y3::~CC0x0y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x0y3E(Test__ZN3ccc7CC0x0y3E, "_ZN3ccc7CC0x0y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x0y3C1Ev();
extern void _ZN3ccc7CC0x0y3D1Ev();
Name_Map name_map__ZN3ccc7CC0x0y3E[] = {
  NSPAIR(_ZN3ccc7CC0x0y3C1Ev),
  NSPAIR(_ZN3ccc7CC0x0y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB0E;
extern VTBL_ENTRY _ZTIN3ccc3BB0E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB0E[];
static Base_Class bases__ZN3ccc7CC0x0y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB0E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x0y3E[];
extern void _ZN3ccc7CC0x0y33abcEv();
extern void _ZN3ccc7CC0x0y33efgEv();
extern void _ZN3ccc7CC0x0y33pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x0y33abcEv,_ZThn4_N3ccc7CC0x0y33abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x0y33efgEv,_ZThn4_N3ccc7CC0x0y33efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x0y33pqrEv,_ZThn4_N3ccc7CC0x0y33pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x0y3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x0y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x0y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x0y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x0y33pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x0y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x0y33abcEv,_ZThn4_N3ccc7CC0x0y33abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x0y33efgEv,_ZThn4_N3ccc7CC0x0y33efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x0y33pqrEv,_ZThn4_N3ccc7CC0x0y33pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x0y3E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x0y3E[];
Class_Descriptor cd__ZN3ccc7CC0x0y3E = {  "_ZN3ccc7CC0x0y3E", // class name
  bases__ZN3ccc7CC0x0y3E, 2,
  &(vtc__ZN3ccc7CC0x0y3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x0y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x0y3E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x0y4  : ::ccc::AA0 , ::ccc::BB0 {
  virtual void  pqr(); // _ZN3ccc7CC0x0y43pqrEv
  virtual void  abc(); // _ZN3ccc7CC0x0y43abcEv
  virtual void  efg(); // _ZN3ccc7CC0x0y43efgEv
  ~CC0x0y4(); // tgen
  CC0x0y4(); // tgen
};
//SIG(1 _ZN3ccc7CC0x0y4E) C1{ BC2{ v2 v3 v1} BC3{ v2 v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x0y4 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x0y43pqrEv");}
void  ccc::CC0x0y4 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x0y43abcEv");}
void  ccc::CC0x0y4 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x0y43efgEv");}
ccc::CC0x0y4 ::~CC0x0y4(){ note_dtor("_ZN3ccc7CC0x0y4E", this);} // tgen
ccc::CC0x0y4 ::CC0x0y4(){ note_ctor("_ZN3ccc7CC0x0y4E", this);} // tgen
}
static void Test__ZN3ccc7CC0x0y4E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x0y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x0y4E, buf);
    ::ccc::CC0x0y4 *dp, &lv = *(dp=new (buf) ::ccc::CC0x0y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x0y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x0y4E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x0y4E");
    check_base_class_offset(lv, (::ccc::BB0*), ABISELECT(8,4), "_ZN3ccc7CC0x0y4E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x0y4E);
    dp->::ccc::CC0x0y4::~CC0x0y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x0y4E(Test__ZN3ccc7CC0x0y4E, "_ZN3ccc7CC0x0y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x0y4C1Ev();
extern void _ZN3ccc7CC0x0y4D1Ev();
Name_Map name_map__ZN3ccc7CC0x0y4E[] = {
  NSPAIR(_ZN3ccc7CC0x0y4C1Ev),
  NSPAIR(_ZN3ccc7CC0x0y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB0E;
extern VTBL_ENTRY _ZTIN3ccc3BB0E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB0E[];
static Base_Class bases__ZN3ccc7CC0x0y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB0E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x0y4E[];
extern void _ZN3ccc7CC0x0y43abcEv();
extern void _ZN3ccc7CC0x0y43efgEv();
extern void _ZN3ccc7CC0x0y43pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x0y43abcEv,_ZThn4_N3ccc7CC0x0y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x0y43efgEv,_ZThn4_N3ccc7CC0x0y43efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x0y43pqrEv,_ZThn4_N3ccc7CC0x0y43pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x0y4E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x0y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x0y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x0y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x0y43pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x0y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x0y43abcEv,_ZThn4_N3ccc7CC0x0y43abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x0y43efgEv,_ZThn4_N3ccc7CC0x0y43efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x0y43pqrEv,_ZThn4_N3ccc7CC0x0y43pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x0y4E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x0y4E[];
Class_Descriptor cd__ZN3ccc7CC0x0y4E = {  "_ZN3ccc7CC0x0y4E", // class name
  bases__ZN3ccc7CC0x0y4E, 2,
  &(vtc__ZN3ccc7CC0x0y4E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x0y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x0y4E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x0y5  : ::ccc::AA0 , ::ccc::BB0 {
  virtual void  pqr(); // _ZN3ccc7CC0x0y53pqrEv
  virtual void  efg(); // _ZN3ccc7CC0x0y53efgEv
  virtual void  abc(); // _ZN3ccc7CC0x0y53abcEv
  ~CC0x0y5(); // tgen
  CC0x0y5(); // tgen
};
//SIG(1 _ZN3ccc7CC0x0y5E) C1{ BC2{ v3 v2 v1} BC3{ v3 v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x0y5 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x0y53pqrEv");}
void  ccc::CC0x0y5 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x0y53efgEv");}
void  ccc::CC0x0y5 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x0y53abcEv");}
ccc::CC0x0y5 ::~CC0x0y5(){ note_dtor("_ZN3ccc7CC0x0y5E", this);} // tgen
ccc::CC0x0y5 ::CC0x0y5(){ note_ctor("_ZN3ccc7CC0x0y5E", this);} // tgen
}
static void Test__ZN3ccc7CC0x0y5E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x0y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x0y5E, buf);
    ::ccc::CC0x0y5 *dp, &lv = *(dp=new (buf) ::ccc::CC0x0y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x0y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x0y5E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x0y5E");
    check_base_class_offset(lv, (::ccc::BB0*), ABISELECT(8,4), "_ZN3ccc7CC0x0y5E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x0y5E);
    dp->::ccc::CC0x0y5::~CC0x0y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x0y5E(Test__ZN3ccc7CC0x0y5E, "_ZN3ccc7CC0x0y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x0y5C1Ev();
extern void _ZN3ccc7CC0x0y5D1Ev();
Name_Map name_map__ZN3ccc7CC0x0y5E[] = {
  NSPAIR(_ZN3ccc7CC0x0y5C1Ev),
  NSPAIR(_ZN3ccc7CC0x0y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB0E;
extern VTBL_ENTRY _ZTIN3ccc3BB0E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB0E[];
static Base_Class bases__ZN3ccc7CC0x0y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB0E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x0y5E[];
extern void _ZN3ccc7CC0x0y53abcEv();
extern void _ZN3ccc7CC0x0y53efgEv();
extern void _ZN3ccc7CC0x0y53pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x0y53abcEv,_ZThn4_N3ccc7CC0x0y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x0y53efgEv,_ZThn4_N3ccc7CC0x0y53efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x0y53pqrEv,_ZThn4_N3ccc7CC0x0y53pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x0y5E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x0y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x0y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x0y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x0y53pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x0y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x0y53abcEv,_ZThn4_N3ccc7CC0x0y53abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x0y53efgEv,_ZThn4_N3ccc7CC0x0y53efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x0y53pqrEv,_ZThn4_N3ccc7CC0x0y53pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x0y5E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x0y5E[];
Class_Descriptor cd__ZN3ccc7CC0x0y5E = {  "_ZN3ccc7CC0x0y5E", // class name
  bases__ZN3ccc7CC0x0y5E, 2,
  &(vtc__ZN3ccc7CC0x0y5E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x0y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x0y5E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x0y6  : ::ccc::AA0 , ::ccc::BB0 {
  virtual void  abc(); // _ZN3ccc7CC0x0y63abcEv
  virtual void  efg(); // _ZN3ccc7CC0x0y63efgEv
  ~CC0x0y6(); // tgen
  CC0x0y6(); // tgen
};
//SIG(1 _ZN3ccc7CC0x0y6E) C1{ BC2{ v1 v2 v3} BC3{ v1 v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x0y6 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x0y63abcEv");}
void  ccc::CC0x0y6 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x0y63efgEv");}
ccc::CC0x0y6 ::~CC0x0y6(){ note_dtor("_ZN3ccc7CC0x0y6E", this);} // tgen
ccc::CC0x0y6 ::CC0x0y6(){ note_ctor("_ZN3ccc7CC0x0y6E", this);} // tgen
}
static void Test__ZN3ccc7CC0x0y6E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x0y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x0y6E, buf);
    ::ccc::CC0x0y6 *dp, &lv = *(dp=new (buf) ::ccc::CC0x0y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x0y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x0y6E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x0y6E");
    check_base_class_offset(lv, (::ccc::BB0*), ABISELECT(8,4), "_ZN3ccc7CC0x0y6E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x0y6E);
    dp->::ccc::CC0x0y6::~CC0x0y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x0y6E(Test__ZN3ccc7CC0x0y6E, "_ZN3ccc7CC0x0y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x0y6C1Ev();
extern void _ZN3ccc7CC0x0y6D1Ev();
Name_Map name_map__ZN3ccc7CC0x0y6E[] = {
  NSPAIR(_ZN3ccc7CC0x0y6C1Ev),
  NSPAIR(_ZN3ccc7CC0x0y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB0E;
extern VTBL_ENTRY _ZTIN3ccc3BB0E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB0E[];
static Base_Class bases__ZN3ccc7CC0x0y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB0E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x0y6E[];
extern void _ZN3ccc7CC0x0y63abcEv();
extern void _ZN3ccc7CC0x0y63efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x0y63abcEv,_ZThn4_N3ccc7CC0x0y63abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x0y63efgEv,_ZThn4_N3ccc7CC0x0y63efgEv)();
extern void _ZN3ccc3BB03pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x0y6E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x0y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x0y63abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x0y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x0y6E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x0y63abcEv,_ZThn4_N3ccc7CC0x0y63abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x0y63efgEv,_ZThn4_N3ccc7CC0x0y63efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB03pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x0y6E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x0y6E[];
Class_Descriptor cd__ZN3ccc7CC0x0y6E = {  "_ZN3ccc7CC0x0y6E", // class name
  bases__ZN3ccc7CC0x0y6E, 2,
  &(vtc__ZN3ccc7CC0x0y6E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x0y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x0y6E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x0y7  : ::ccc::AA0 , ::ccc::BB0 {
  virtual void  abc(); // _ZN3ccc7CC0x0y73abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x0y73pqrEv
  ~CC0x0y7(); // tgen
  CC0x0y7(); // tgen
};
//SIG(1 _ZN3ccc7CC0x0y7E) C1{ BC2{ v1 v3 v2} BC3{ v1 v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x0y7 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x0y73abcEv");}
void  ccc::CC0x0y7 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x0y73pqrEv");}
ccc::CC0x0y7 ::~CC0x0y7(){ note_dtor("_ZN3ccc7CC0x0y7E", this);} // tgen
ccc::CC0x0y7 ::CC0x0y7(){ note_ctor("_ZN3ccc7CC0x0y7E", this);} // tgen
}
static void Test__ZN3ccc7CC0x0y7E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x0y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x0y7E, buf);
    ::ccc::CC0x0y7 *dp, &lv = *(dp=new (buf) ::ccc::CC0x0y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x0y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x0y7E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x0y7E");
    check_base_class_offset(lv, (::ccc::BB0*), ABISELECT(8,4), "_ZN3ccc7CC0x0y7E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x0y7E);
    dp->::ccc::CC0x0y7::~CC0x0y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x0y7E(Test__ZN3ccc7CC0x0y7E, "_ZN3ccc7CC0x0y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x0y7C1Ev();
extern void _ZN3ccc7CC0x0y7D1Ev();
Name_Map name_map__ZN3ccc7CC0x0y7E[] = {
  NSPAIR(_ZN3ccc7CC0x0y7C1Ev),
  NSPAIR(_ZN3ccc7CC0x0y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB0E;
extern VTBL_ENTRY _ZTIN3ccc3BB0E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB0E[];
static Base_Class bases__ZN3ccc7CC0x0y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB0E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x0y7E[];
extern void _ZN3ccc7CC0x0y73abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc7CC0x0y73pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x0y73abcEv,_ZThn4_N3ccc7CC0x0y73abcEv)();
extern void _ZN3ccc3BB03efgEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x0y73pqrEv,_ZThn4_N3ccc7CC0x0y73pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x0y7E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x0y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x0y73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x0y73pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x0y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x0y73abcEv,_ZThn4_N3ccc7CC0x0y73abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB03efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x0y73pqrEv,_ZThn4_N3ccc7CC0x0y73pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x0y7E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x0y7E[];
Class_Descriptor cd__ZN3ccc7CC0x0y7E = {  "_ZN3ccc7CC0x0y7E", // class name
  bases__ZN3ccc7CC0x0y7E, 2,
  &(vtc__ZN3ccc7CC0x0y7E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x0y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x0y7E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x0y8  : ::ccc::AA0 , ::ccc::BB0 {
  virtual void  efg(); // _ZN3ccc7CC0x0y83efgEv
  virtual void  abc(); // _ZN3ccc7CC0x0y83abcEv
  ~CC0x0y8(); // tgen
  CC0x0y8(); // tgen
};
//SIG(1 _ZN3ccc7CC0x0y8E) C1{ BC2{ v2 v1 v3} BC3{ v2 v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x0y8 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x0y83efgEv");}
void  ccc::CC0x0y8 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x0y83abcEv");}
ccc::CC0x0y8 ::~CC0x0y8(){ note_dtor("_ZN3ccc7CC0x0y8E", this);} // tgen
ccc::CC0x0y8 ::CC0x0y8(){ note_ctor("_ZN3ccc7CC0x0y8E", this);} // tgen
}
static void Test__ZN3ccc7CC0x0y8E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x0y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x0y8E, buf);
    ::ccc::CC0x0y8 *dp, &lv = *(dp=new (buf) ::ccc::CC0x0y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x0y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x0y8E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x0y8E");
    check_base_class_offset(lv, (::ccc::BB0*), ABISELECT(8,4), "_ZN3ccc7CC0x0y8E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x0y8E);
    dp->::ccc::CC0x0y8::~CC0x0y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x0y8E(Test__ZN3ccc7CC0x0y8E, "_ZN3ccc7CC0x0y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x0y8C1Ev();
extern void _ZN3ccc7CC0x0y8D1Ev();
Name_Map name_map__ZN3ccc7CC0x0y8E[] = {
  NSPAIR(_ZN3ccc7CC0x0y8C1Ev),
  NSPAIR(_ZN3ccc7CC0x0y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB0E;
extern VTBL_ENTRY _ZTIN3ccc3BB0E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB0E[];
static Base_Class bases__ZN3ccc7CC0x0y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB0E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x0y8E[];
extern void _ZN3ccc7CC0x0y83abcEv();
extern void _ZN3ccc7CC0x0y83efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x0y83abcEv,_ZThn4_N3ccc7CC0x0y83abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x0y83efgEv,_ZThn4_N3ccc7CC0x0y83efgEv)();
extern void _ZN3ccc3BB03pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x0y8E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x0y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x0y83abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x0y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x0y8E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x0y83abcEv,_ZThn4_N3ccc7CC0x0y83abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x0y83efgEv,_ZThn4_N3ccc7CC0x0y83efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB03pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x0y8E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x0y8E[];
Class_Descriptor cd__ZN3ccc7CC0x0y8E = {  "_ZN3ccc7CC0x0y8E", // class name
  bases__ZN3ccc7CC0x0y8E, 2,
  &(vtc__ZN3ccc7CC0x0y8E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x0y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x0y8E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x0y9  : ::ccc::AA0 , ::ccc::BB0 {
  virtual void  efg(); // _ZN3ccc7CC0x0y93efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x0y93pqrEv
  ~CC0x0y9(); // tgen
  CC0x0y9(); // tgen
};
//SIG(1 _ZN3ccc7CC0x0y9E) C1{ BC2{ v3 v1 v2} BC3{ v4 v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x0y9 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x0y93efgEv");}
void  ccc::CC0x0y9 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x0y93pqrEv");}
ccc::CC0x0y9 ::~CC0x0y9(){ note_dtor("_ZN3ccc7CC0x0y9E", this);} // tgen
ccc::CC0x0y9 ::CC0x0y9(){ note_ctor("_ZN3ccc7CC0x0y9E", this);} // tgen
}
static void Test__ZN3ccc7CC0x0y9E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x0y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x0y9E, buf);
    ::ccc::CC0x0y9 *dp, &lv = *(dp=new (buf) ::ccc::CC0x0y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x0y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x0y9E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x0y9E");
    check_base_class_offset(lv, (::ccc::BB0*), ABISELECT(8,4), "_ZN3ccc7CC0x0y9E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x0y9E);
    dp->::ccc::CC0x0y9::~CC0x0y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x0y9E(Test__ZN3ccc7CC0x0y9E, "_ZN3ccc7CC0x0y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x0y9C1Ev();
extern void _ZN3ccc7CC0x0y9D1Ev();
Name_Map name_map__ZN3ccc7CC0x0y9E[] = {
  NSPAIR(_ZN3ccc7CC0x0y9C1Ev),
  NSPAIR(_ZN3ccc7CC0x0y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB0E;
extern VTBL_ENTRY _ZTIN3ccc3BB0E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB0E[];
static Base_Class bases__ZN3ccc7CC0x0y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB0E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x0y9E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc7CC0x0y93efgEv();
extern void _ZN3ccc7CC0x0y93pqrEv();
extern void _ZN3ccc3BB03abcEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x0y93efgEv,_ZThn4_N3ccc7CC0x0y93efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x0y93pqrEv,_ZThn4_N3ccc7CC0x0y93pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x0y9E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x0y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x0y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x0y93pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x0y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB03abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x0y93efgEv,_ZThn4_N3ccc7CC0x0y93efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x0y93pqrEv,_ZThn4_N3ccc7CC0x0y93pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x0y9E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x0y9E[];
Class_Descriptor cd__ZN3ccc7CC0x0y9E = {  "_ZN3ccc7CC0x0y9E", // class name
  bases__ZN3ccc7CC0x0y9E, 2,
  &(vtc__ZN3ccc7CC0x0y9E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x0y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x0y9E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x0y10  : ::ccc::AA0 , ::ccc::BB0 {
  virtual void  pqr(); // _ZN3ccc8CC0x0y103pqrEv
  virtual void  abc(); // _ZN3ccc8CC0x0y103abcEv
  ~CC0x0y10(); // tgen
  CC0x0y10(); // tgen
};
//SIG(1 _ZN3ccc8CC0x0y10E) C1{ BC2{ v2 v3 v1} BC3{ v2 v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x0y10 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x0y103pqrEv");}
void  ccc::CC0x0y10 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x0y103abcEv");}
ccc::CC0x0y10 ::~CC0x0y10(){ note_dtor("_ZN3ccc8CC0x0y10E", this);} // tgen
ccc::CC0x0y10 ::CC0x0y10(){ note_ctor("_ZN3ccc8CC0x0y10E", this);} // tgen
}
static void Test__ZN3ccc8CC0x0y10E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x0y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x0y10E, buf);
    ::ccc::CC0x0y10 *dp, &lv = *(dp=new (buf) ::ccc::CC0x0y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x0y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x0y10E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x0y10E");
    check_base_class_offset(lv, (::ccc::BB0*), ABISELECT(8,4), "_ZN3ccc8CC0x0y10E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x0y10E);
    dp->::ccc::CC0x0y10::~CC0x0y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x0y10E(Test__ZN3ccc8CC0x0y10E, "_ZN3ccc8CC0x0y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x0y10C1Ev();
extern void _ZN3ccc8CC0x0y10D1Ev();
Name_Map name_map__ZN3ccc8CC0x0y10E[] = {
  NSPAIR(_ZN3ccc8CC0x0y10C1Ev),
  NSPAIR(_ZN3ccc8CC0x0y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB0E;
extern VTBL_ENTRY _ZTIN3ccc3BB0E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB0E[];
static Base_Class bases__ZN3ccc8CC0x0y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB0E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x0y10E[];
extern void _ZN3ccc8CC0x0y103abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc8CC0x0y103pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x0y103abcEv,_ZThn4_N3ccc8CC0x0y103abcEv)();
extern void _ZN3ccc3BB03efgEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x0y103pqrEv,_ZThn4_N3ccc8CC0x0y103pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x0y10E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x0y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x0y103abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x0y103pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x0y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x0y103abcEv,_ZThn4_N3ccc8CC0x0y103abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB03efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x0y103pqrEv,_ZThn4_N3ccc8CC0x0y103pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x0y10E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x0y10E[];
Class_Descriptor cd__ZN3ccc8CC0x0y10E = {  "_ZN3ccc8CC0x0y10E", // class name
  bases__ZN3ccc8CC0x0y10E, 2,
  &(vtc__ZN3ccc8CC0x0y10E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x0y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x0y10E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x0y11  : ::ccc::AA0 , ::ccc::BB0 {
  virtual void  pqr(); // _ZN3ccc8CC0x0y113pqrEv
  virtual void  efg(); // _ZN3ccc8CC0x0y113efgEv
  ~CC0x0y11(); // tgen
  CC0x0y11(); // tgen
};
//SIG(1 _ZN3ccc8CC0x0y11E) C1{ BC2{ v3 v2 v1} BC3{ v4 v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x0y11 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x0y113pqrEv");}
void  ccc::CC0x0y11 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x0y113efgEv");}
ccc::CC0x0y11 ::~CC0x0y11(){ note_dtor("_ZN3ccc8CC0x0y11E", this);} // tgen
ccc::CC0x0y11 ::CC0x0y11(){ note_ctor("_ZN3ccc8CC0x0y11E", this);} // tgen
}
static void Test__ZN3ccc8CC0x0y11E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x0y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x0y11E, buf);
    ::ccc::CC0x0y11 *dp, &lv = *(dp=new (buf) ::ccc::CC0x0y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x0y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x0y11E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x0y11E");
    check_base_class_offset(lv, (::ccc::BB0*), ABISELECT(8,4), "_ZN3ccc8CC0x0y11E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x0y11E);
    dp->::ccc::CC0x0y11::~CC0x0y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x0y11E(Test__ZN3ccc8CC0x0y11E, "_ZN3ccc8CC0x0y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x0y11C1Ev();
extern void _ZN3ccc8CC0x0y11D1Ev();
Name_Map name_map__ZN3ccc8CC0x0y11E[] = {
  NSPAIR(_ZN3ccc8CC0x0y11C1Ev),
  NSPAIR(_ZN3ccc8CC0x0y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB0E;
extern VTBL_ENTRY _ZTIN3ccc3BB0E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB0E[];
static Base_Class bases__ZN3ccc8CC0x0y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB0E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x0y11E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc8CC0x0y113efgEv();
extern void _ZN3ccc8CC0x0y113pqrEv();
extern void _ZN3ccc3BB03abcEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x0y113efgEv,_ZThn4_N3ccc8CC0x0y113efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC0x0y113pqrEv,_ZThn4_N3ccc8CC0x0y113pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x0y11E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x0y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x0y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x0y113pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x0y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB03abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x0y113efgEv,_ZThn4_N3ccc8CC0x0y113efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x0y113pqrEv,_ZThn4_N3ccc8CC0x0y113pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x0y11E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x0y11E[];
Class_Descriptor cd__ZN3ccc8CC0x0y11E = {  "_ZN3ccc8CC0x0y11E", // class name
  bases__ZN3ccc8CC0x0y11E, 2,
  &(vtc__ZN3ccc8CC0x0y11E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x0y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x0y11E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x0y12  : ::ccc::AA0 , ::ccc::BB0 {
  virtual void  abc(); // _ZN3ccc8CC0x0y123abcEv
  ~CC0x0y12(); // tgen
  CC0x0y12(); // tgen
};
//SIG(1 _ZN3ccc8CC0x0y12E) C1{ BC2{ v1 v2 v3} BC3{ v1 v4 v5} v1}
}
namespace ccc { 
void  ccc::CC0x0y12 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x0y123abcEv");}
ccc::CC0x0y12 ::~CC0x0y12(){ note_dtor("_ZN3ccc8CC0x0y12E", this);} // tgen
ccc::CC0x0y12 ::CC0x0y12(){ note_ctor("_ZN3ccc8CC0x0y12E", this);} // tgen
}
static void Test__ZN3ccc8CC0x0y12E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x0y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x0y12E, buf);
    ::ccc::CC0x0y12 *dp, &lv = *(dp=new (buf) ::ccc::CC0x0y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x0y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x0y12E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x0y12E");
    check_base_class_offset(lv, (::ccc::BB0*), ABISELECT(8,4), "_ZN3ccc8CC0x0y12E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x0y12E);
    dp->::ccc::CC0x0y12::~CC0x0y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x0y12E(Test__ZN3ccc8CC0x0y12E, "_ZN3ccc8CC0x0y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x0y12C1Ev();
extern void _ZN3ccc8CC0x0y12D1Ev();
Name_Map name_map__ZN3ccc8CC0x0y12E[] = {
  NSPAIR(_ZN3ccc8CC0x0y12C1Ev),
  NSPAIR(_ZN3ccc8CC0x0y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB0E;
extern VTBL_ENTRY _ZTIN3ccc3BB0E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB0E[];
static Base_Class bases__ZN3ccc8CC0x0y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB0E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x0y12E[];
extern void _ZN3ccc8CC0x0y123abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x0y123abcEv,_ZThn4_N3ccc8CC0x0y123abcEv)();
extern void _ZN3ccc3BB03efgEv();
extern void _ZN3ccc3BB03pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x0y12E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x0y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x0y123abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x0y12E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x0y123abcEv,_ZThn4_N3ccc8CC0x0y123abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB03pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x0y12E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x0y12E[];
Class_Descriptor cd__ZN3ccc8CC0x0y12E = {  "_ZN3ccc8CC0x0y12E", // class name
  bases__ZN3ccc8CC0x0y12E, 2,
  &(vtc__ZN3ccc8CC0x0y12E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x0y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x0y12E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x0y13  : ::ccc::AA0 , ::ccc::BB0 {
  virtual void  efg(); // _ZN3ccc8CC0x0y133efgEv
  ~CC0x0y13(); // tgen
  CC0x0y13(); // tgen
};
//SIG(1 _ZN3ccc8CC0x0y13E) C1{ BC2{ v2 v1 v3} BC3{ v4 v1 v5} v1}
}
namespace ccc { 
void  ccc::CC0x0y13 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x0y133efgEv");}
ccc::CC0x0y13 ::~CC0x0y13(){ note_dtor("_ZN3ccc8CC0x0y13E", this);} // tgen
ccc::CC0x0y13 ::CC0x0y13(){ note_ctor("_ZN3ccc8CC0x0y13E", this);} // tgen
}
static void Test__ZN3ccc8CC0x0y13E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x0y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x0y13E, buf);
    ::ccc::CC0x0y13 *dp, &lv = *(dp=new (buf) ::ccc::CC0x0y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x0y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x0y13E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x0y13E");
    check_base_class_offset(lv, (::ccc::BB0*), ABISELECT(8,4), "_ZN3ccc8CC0x0y13E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x0y13E);
    dp->::ccc::CC0x0y13::~CC0x0y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x0y13E(Test__ZN3ccc8CC0x0y13E, "_ZN3ccc8CC0x0y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x0y13C1Ev();
extern void _ZN3ccc8CC0x0y13D1Ev();
Name_Map name_map__ZN3ccc8CC0x0y13E[] = {
  NSPAIR(_ZN3ccc8CC0x0y13C1Ev),
  NSPAIR(_ZN3ccc8CC0x0y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB0E;
extern VTBL_ENTRY _ZTIN3ccc3BB0E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB0E[];
static Base_Class bases__ZN3ccc8CC0x0y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB0E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x0y13E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc8CC0x0y133efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc3BB03abcEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x0y133efgEv,_ZThn4_N3ccc8CC0x0y133efgEv)();
extern void _ZN3ccc3BB03pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x0y13E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x0y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x0y133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x0y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB03abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x0y133efgEv,_ZThn4_N3ccc8CC0x0y133efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB03pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x0y13E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x0y13E[];
Class_Descriptor cd__ZN3ccc8CC0x0y13E = {  "_ZN3ccc8CC0x0y13E", // class name
  bases__ZN3ccc8CC0x0y13E, 2,
  &(vtc__ZN3ccc8CC0x0y13E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x0y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x0y13E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x0y14  : ::ccc::AA0 , ::ccc::BB0 {
  virtual void  pqr(); // _ZN3ccc8CC0x0y143pqrEv
  ~CC0x0y14(); // tgen
  CC0x0y14(); // tgen
};
//SIG(1 _ZN3ccc8CC0x0y14E) C1{ BC2{ v2 v3 v1} BC3{ v4 v5 v1} v1}
}
namespace ccc { 
void  ccc::CC0x0y14 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x0y143pqrEv");}
ccc::CC0x0y14 ::~CC0x0y14(){ note_dtor("_ZN3ccc8CC0x0y14E", this);} // tgen
ccc::CC0x0y14 ::CC0x0y14(){ note_ctor("_ZN3ccc8CC0x0y14E", this);} // tgen
}
static void Test__ZN3ccc8CC0x0y14E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x0y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x0y14E, buf);
    ::ccc::CC0x0y14 *dp, &lv = *(dp=new (buf) ::ccc::CC0x0y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x0y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x0y14E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x0y14E");
    check_base_class_offset(lv, (::ccc::BB0*), ABISELECT(8,4), "_ZN3ccc8CC0x0y14E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x0y14E);
    dp->::ccc::CC0x0y14::~CC0x0y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x0y14E(Test__ZN3ccc8CC0x0y14E, "_ZN3ccc8CC0x0y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x0y14C1Ev();
extern void _ZN3ccc8CC0x0y14D1Ev();
Name_Map name_map__ZN3ccc8CC0x0y14E[] = {
  NSPAIR(_ZN3ccc8CC0x0y14C1Ev),
  NSPAIR(_ZN3ccc8CC0x0y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB0E;
extern VTBL_ENTRY _ZTIN3ccc3BB0E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB0E[];
static Base_Class bases__ZN3ccc8CC0x0y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB0E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x0y14E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc8CC0x0y143pqrEv();
extern void _ZN3ccc3BB03abcEv();
extern void _ZN3ccc3BB03efgEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x0y143pqrEv,_ZThn4_N3ccc8CC0x0y143pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x0y14E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x0y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x0y143pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x0y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB03efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x0y143pqrEv,_ZThn4_N3ccc8CC0x0y143pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x0y14E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x0y14E[];
Class_Descriptor cd__ZN3ccc8CC0x0y14E = {  "_ZN3ccc8CC0x0y14E", // class name
  bases__ZN3ccc8CC0x0y14E, 2,
  &(vtc__ZN3ccc8CC0x0y14E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x0y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x0y14E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x0y15  : ::ccc::AA0 , ::ccc::BB0 {
  ~CC0x0y15(); // tgen
  CC0x0y15(); // tgen
};
//SIG(1 _ZN3ccc8CC0x0y15E) C1{ BC2{ v1 v2 v3} BC3{ v4 v5 v6}}
}
namespace ccc { 
ccc::CC0x0y15 ::~CC0x0y15(){ note_dtor("_ZN3ccc8CC0x0y15E", this);} // tgen
ccc::CC0x0y15 ::CC0x0y15(){ note_ctor("_ZN3ccc8CC0x0y15E", this);} // tgen
}
static void Test__ZN3ccc8CC0x0y15E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x0y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x0y15E, buf);
    ::ccc::CC0x0y15 *dp, &lv = *(dp=new (buf) ::ccc::CC0x0y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x0y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x0y15E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x0y15E");
    check_base_class_offset(lv, (::ccc::BB0*), ABISELECT(8,4), "_ZN3ccc8CC0x0y15E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x0y15E);
    dp->::ccc::CC0x0y15::~CC0x0y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x0y15E(Test__ZN3ccc8CC0x0y15E, "_ZN3ccc8CC0x0y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x0y15C1Ev();
extern void _ZN3ccc8CC0x0y15D1Ev();
Name_Map name_map__ZN3ccc8CC0x0y15E[] = {
  NSPAIR(_ZN3ccc8CC0x0y15C1Ev),
  NSPAIR(_ZN3ccc8CC0x0y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB0E;
extern VTBL_ENTRY _ZTIN3ccc3BB0E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB0E[];
static Base_Class bases__ZN3ccc8CC0x0y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB0E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x0y15E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc3BB03abcEv();
extern void _ZN3ccc3BB03efgEv();
extern void _ZN3ccc3BB03pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x0y15E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x0y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x0y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB03pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x0y15E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x0y15E[];
Class_Descriptor cd__ZN3ccc8CC0x0y15E = {  "_ZN3ccc8CC0x0y15E", // class name
  bases__ZN3ccc8CC0x0y15E, 2,
  &(vtc__ZN3ccc8CC0x0y15E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x0y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x0y15E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x1y0  : ::ccc::AA0 , ::ccc::BB1 {
  virtual void  abc(); // _ZN3ccc7CC0x1y03abcEv
  virtual void  efg(); // _ZN3ccc7CC0x1y03efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x1y03pqrEv
  ~CC0x1y0(); // tgen
  CC0x1y0(); // tgen
};
//SIG(1 _ZN3ccc7CC0x1y0E) C1{ BC2{ v1 v2 v3} BC3{ v1 v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x1y0 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x1y03abcEv");}
void  ccc::CC0x1y0 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x1y03efgEv");}
void  ccc::CC0x1y0 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x1y03pqrEv");}
ccc::CC0x1y0 ::~CC0x1y0(){ note_dtor("_ZN3ccc7CC0x1y0E", this);} // tgen
ccc::CC0x1y0 ::CC0x1y0(){ note_ctor("_ZN3ccc7CC0x1y0E", this);} // tgen
}
static void Test__ZN3ccc7CC0x1y0E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x1y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x1y0E, buf);
    ::ccc::CC0x1y0 *dp, &lv = *(dp=new (buf) ::ccc::CC0x1y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x1y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x1y0E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x1y0E");
    check_base_class_offset(lv, (::ccc::BB1*), ABISELECT(8,4), "_ZN3ccc7CC0x1y0E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x1y0E);
    dp->::ccc::CC0x1y0::~CC0x1y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x1y0E(Test__ZN3ccc7CC0x1y0E, "_ZN3ccc7CC0x1y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x1y0C1Ev();
extern void _ZN3ccc7CC0x1y0D1Ev();
Name_Map name_map__ZN3ccc7CC0x1y0E[] = {
  NSPAIR(_ZN3ccc7CC0x1y0C1Ev),
  NSPAIR(_ZN3ccc7CC0x1y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB1E;
extern VTBL_ENTRY _ZTIN3ccc3BB1E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB1E[];
static Base_Class bases__ZN3ccc7CC0x1y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB1E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x1y0E[];
extern void _ZN3ccc7CC0x1y03abcEv();
extern void _ZN3ccc7CC0x1y03efgEv();
extern void _ZN3ccc7CC0x1y03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x1y03abcEv,_ZThn4_N3ccc7CC0x1y03abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x1y03pqrEv,_ZThn4_N3ccc7CC0x1y03pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x1y03efgEv,_ZThn4_N3ccc7CC0x1y03efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x1y0E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x1y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x1y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x1y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x1y03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x1y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x1y03abcEv,_ZThn4_N3ccc7CC0x1y03abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x1y03pqrEv,_ZThn4_N3ccc7CC0x1y03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x1y03efgEv,_ZThn4_N3ccc7CC0x1y03efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x1y0E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x1y0E[];
Class_Descriptor cd__ZN3ccc7CC0x1y0E = {  "_ZN3ccc7CC0x1y0E", // class name
  bases__ZN3ccc7CC0x1y0E, 2,
  &(vtc__ZN3ccc7CC0x1y0E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x1y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x1y0E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x1y1  : ::ccc::AA0 , ::ccc::BB1 {
  virtual void  abc(); // _ZN3ccc7CC0x1y13abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x1y13pqrEv
  virtual void  efg(); // _ZN3ccc7CC0x1y13efgEv
  ~CC0x1y1(); // tgen
  CC0x1y1(); // tgen
};
//SIG(1 _ZN3ccc7CC0x1y1E) C1{ BC2{ v1 v3 v2} BC3{ v1 v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x1y1 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x1y13abcEv");}
void  ccc::CC0x1y1 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x1y13pqrEv");}
void  ccc::CC0x1y1 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x1y13efgEv");}
ccc::CC0x1y1 ::~CC0x1y1(){ note_dtor("_ZN3ccc7CC0x1y1E", this);} // tgen
ccc::CC0x1y1 ::CC0x1y1(){ note_ctor("_ZN3ccc7CC0x1y1E", this);} // tgen
}
static void Test__ZN3ccc7CC0x1y1E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x1y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x1y1E, buf);
    ::ccc::CC0x1y1 *dp, &lv = *(dp=new (buf) ::ccc::CC0x1y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x1y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x1y1E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x1y1E");
    check_base_class_offset(lv, (::ccc::BB1*), ABISELECT(8,4), "_ZN3ccc7CC0x1y1E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x1y1E);
    dp->::ccc::CC0x1y1::~CC0x1y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x1y1E(Test__ZN3ccc7CC0x1y1E, "_ZN3ccc7CC0x1y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x1y1C1Ev();
extern void _ZN3ccc7CC0x1y1D1Ev();
Name_Map name_map__ZN3ccc7CC0x1y1E[] = {
  NSPAIR(_ZN3ccc7CC0x1y1C1Ev),
  NSPAIR(_ZN3ccc7CC0x1y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB1E;
extern VTBL_ENTRY _ZTIN3ccc3BB1E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB1E[];
static Base_Class bases__ZN3ccc7CC0x1y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB1E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x1y1E[];
extern void _ZN3ccc7CC0x1y13abcEv();
extern void _ZN3ccc7CC0x1y13efgEv();
extern void _ZN3ccc7CC0x1y13pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x1y13abcEv,_ZThn4_N3ccc7CC0x1y13abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x1y13pqrEv,_ZThn4_N3ccc7CC0x1y13pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x1y13efgEv,_ZThn4_N3ccc7CC0x1y13efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x1y1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x1y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x1y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x1y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x1y13pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x1y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x1y13abcEv,_ZThn4_N3ccc7CC0x1y13abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x1y13pqrEv,_ZThn4_N3ccc7CC0x1y13pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x1y13efgEv,_ZThn4_N3ccc7CC0x1y13efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x1y1E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x1y1E[];
Class_Descriptor cd__ZN3ccc7CC0x1y1E = {  "_ZN3ccc7CC0x1y1E", // class name
  bases__ZN3ccc7CC0x1y1E, 2,
  &(vtc__ZN3ccc7CC0x1y1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x1y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x1y1E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x1y2  : ::ccc::AA0 , ::ccc::BB1 {
  virtual void  efg(); // _ZN3ccc7CC0x1y23efgEv
  virtual void  abc(); // _ZN3ccc7CC0x1y23abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x1y23pqrEv
  ~CC0x1y2(); // tgen
  CC0x1y2(); // tgen
};
//SIG(1 _ZN3ccc7CC0x1y2E) C1{ BC2{ v2 v1 v3} BC3{ v2 v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x1y2 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x1y23efgEv");}
void  ccc::CC0x1y2 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x1y23abcEv");}
void  ccc::CC0x1y2 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x1y23pqrEv");}
ccc::CC0x1y2 ::~CC0x1y2(){ note_dtor("_ZN3ccc7CC0x1y2E", this);} // tgen
ccc::CC0x1y2 ::CC0x1y2(){ note_ctor("_ZN3ccc7CC0x1y2E", this);} // tgen
}
static void Test__ZN3ccc7CC0x1y2E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x1y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x1y2E, buf);
    ::ccc::CC0x1y2 *dp, &lv = *(dp=new (buf) ::ccc::CC0x1y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x1y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x1y2E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x1y2E");
    check_base_class_offset(lv, (::ccc::BB1*), ABISELECT(8,4), "_ZN3ccc7CC0x1y2E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x1y2E);
    dp->::ccc::CC0x1y2::~CC0x1y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x1y2E(Test__ZN3ccc7CC0x1y2E, "_ZN3ccc7CC0x1y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x1y2C1Ev();
extern void _ZN3ccc7CC0x1y2D1Ev();
Name_Map name_map__ZN3ccc7CC0x1y2E[] = {
  NSPAIR(_ZN3ccc7CC0x1y2C1Ev),
  NSPAIR(_ZN3ccc7CC0x1y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB1E;
extern VTBL_ENTRY _ZTIN3ccc3BB1E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB1E[];
static Base_Class bases__ZN3ccc7CC0x1y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB1E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x1y2E[];
extern void _ZN3ccc7CC0x1y23abcEv();
extern void _ZN3ccc7CC0x1y23efgEv();
extern void _ZN3ccc7CC0x1y23pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x1y23abcEv,_ZThn4_N3ccc7CC0x1y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x1y23pqrEv,_ZThn4_N3ccc7CC0x1y23pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x1y23efgEv,_ZThn4_N3ccc7CC0x1y23efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x1y2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x1y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x1y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x1y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x1y23pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x1y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x1y23abcEv,_ZThn4_N3ccc7CC0x1y23abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x1y23pqrEv,_ZThn4_N3ccc7CC0x1y23pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x1y23efgEv,_ZThn4_N3ccc7CC0x1y23efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x1y2E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x1y2E[];
Class_Descriptor cd__ZN3ccc7CC0x1y2E = {  "_ZN3ccc7CC0x1y2E", // class name
  bases__ZN3ccc7CC0x1y2E, 2,
  &(vtc__ZN3ccc7CC0x1y2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x1y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x1y2E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x1y3  : ::ccc::AA0 , ::ccc::BB1 {
  virtual void  efg(); // _ZN3ccc7CC0x1y33efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x1y33pqrEv
  virtual void  abc(); // _ZN3ccc7CC0x1y33abcEv
  ~CC0x1y3(); // tgen
  CC0x1y3(); // tgen
};
//SIG(1 _ZN3ccc7CC0x1y3E) C1{ BC2{ v3 v1 v2} BC3{ v3 v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x1y3 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x1y33efgEv");}
void  ccc::CC0x1y3 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x1y33pqrEv");}
void  ccc::CC0x1y3 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x1y33abcEv");}
ccc::CC0x1y3 ::~CC0x1y3(){ note_dtor("_ZN3ccc7CC0x1y3E", this);} // tgen
ccc::CC0x1y3 ::CC0x1y3(){ note_ctor("_ZN3ccc7CC0x1y3E", this);} // tgen
}
static void Test__ZN3ccc7CC0x1y3E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x1y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x1y3E, buf);
    ::ccc::CC0x1y3 *dp, &lv = *(dp=new (buf) ::ccc::CC0x1y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x1y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x1y3E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x1y3E");
    check_base_class_offset(lv, (::ccc::BB1*), ABISELECT(8,4), "_ZN3ccc7CC0x1y3E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x1y3E);
    dp->::ccc::CC0x1y3::~CC0x1y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x1y3E(Test__ZN3ccc7CC0x1y3E, "_ZN3ccc7CC0x1y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x1y3C1Ev();
extern void _ZN3ccc7CC0x1y3D1Ev();
Name_Map name_map__ZN3ccc7CC0x1y3E[] = {
  NSPAIR(_ZN3ccc7CC0x1y3C1Ev),
  NSPAIR(_ZN3ccc7CC0x1y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB1E;
extern VTBL_ENTRY _ZTIN3ccc3BB1E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB1E[];
static Base_Class bases__ZN3ccc7CC0x1y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB1E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x1y3E[];
extern void _ZN3ccc7CC0x1y33abcEv();
extern void _ZN3ccc7CC0x1y33efgEv();
extern void _ZN3ccc7CC0x1y33pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x1y33abcEv,_ZThn4_N3ccc7CC0x1y33abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x1y33pqrEv,_ZThn4_N3ccc7CC0x1y33pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x1y33efgEv,_ZThn4_N3ccc7CC0x1y33efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x1y3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x1y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x1y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x1y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x1y33pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x1y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x1y33abcEv,_ZThn4_N3ccc7CC0x1y33abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x1y33pqrEv,_ZThn4_N3ccc7CC0x1y33pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x1y33efgEv,_ZThn4_N3ccc7CC0x1y33efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x1y3E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x1y3E[];
Class_Descriptor cd__ZN3ccc7CC0x1y3E = {  "_ZN3ccc7CC0x1y3E", // class name
  bases__ZN3ccc7CC0x1y3E, 2,
  &(vtc__ZN3ccc7CC0x1y3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x1y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x1y3E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x1y4  : ::ccc::AA0 , ::ccc::BB1 {
  virtual void  pqr(); // _ZN3ccc7CC0x1y43pqrEv
  virtual void  abc(); // _ZN3ccc7CC0x1y43abcEv
  virtual void  efg(); // _ZN3ccc7CC0x1y43efgEv
  ~CC0x1y4(); // tgen
  CC0x1y4(); // tgen
};
//SIG(1 _ZN3ccc7CC0x1y4E) C1{ BC2{ v2 v3 v1} BC3{ v2 v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x1y4 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x1y43pqrEv");}
void  ccc::CC0x1y4 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x1y43abcEv");}
void  ccc::CC0x1y4 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x1y43efgEv");}
ccc::CC0x1y4 ::~CC0x1y4(){ note_dtor("_ZN3ccc7CC0x1y4E", this);} // tgen
ccc::CC0x1y4 ::CC0x1y4(){ note_ctor("_ZN3ccc7CC0x1y4E", this);} // tgen
}
static void Test__ZN3ccc7CC0x1y4E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x1y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x1y4E, buf);
    ::ccc::CC0x1y4 *dp, &lv = *(dp=new (buf) ::ccc::CC0x1y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x1y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x1y4E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x1y4E");
    check_base_class_offset(lv, (::ccc::BB1*), ABISELECT(8,4), "_ZN3ccc7CC0x1y4E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x1y4E);
    dp->::ccc::CC0x1y4::~CC0x1y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x1y4E(Test__ZN3ccc7CC0x1y4E, "_ZN3ccc7CC0x1y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x1y4C1Ev();
extern void _ZN3ccc7CC0x1y4D1Ev();
Name_Map name_map__ZN3ccc7CC0x1y4E[] = {
  NSPAIR(_ZN3ccc7CC0x1y4C1Ev),
  NSPAIR(_ZN3ccc7CC0x1y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB1E;
extern VTBL_ENTRY _ZTIN3ccc3BB1E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB1E[];
static Base_Class bases__ZN3ccc7CC0x1y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB1E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x1y4E[];
extern void _ZN3ccc7CC0x1y43abcEv();
extern void _ZN3ccc7CC0x1y43efgEv();
extern void _ZN3ccc7CC0x1y43pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x1y43abcEv,_ZThn4_N3ccc7CC0x1y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x1y43pqrEv,_ZThn4_N3ccc7CC0x1y43pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x1y43efgEv,_ZThn4_N3ccc7CC0x1y43efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x1y4E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x1y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x1y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x1y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x1y43pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x1y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x1y43abcEv,_ZThn4_N3ccc7CC0x1y43abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x1y43pqrEv,_ZThn4_N3ccc7CC0x1y43pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x1y43efgEv,_ZThn4_N3ccc7CC0x1y43efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x1y4E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x1y4E[];
Class_Descriptor cd__ZN3ccc7CC0x1y4E = {  "_ZN3ccc7CC0x1y4E", // class name
  bases__ZN3ccc7CC0x1y4E, 2,
  &(vtc__ZN3ccc7CC0x1y4E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x1y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x1y4E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x1y5  : ::ccc::AA0 , ::ccc::BB1 {
  virtual void  pqr(); // _ZN3ccc7CC0x1y53pqrEv
  virtual void  efg(); // _ZN3ccc7CC0x1y53efgEv
  virtual void  abc(); // _ZN3ccc7CC0x1y53abcEv
  ~CC0x1y5(); // tgen
  CC0x1y5(); // tgen
};
//SIG(1 _ZN3ccc7CC0x1y5E) C1{ BC2{ v3 v2 v1} BC3{ v3 v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x1y5 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x1y53pqrEv");}
void  ccc::CC0x1y5 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x1y53efgEv");}
void  ccc::CC0x1y5 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x1y53abcEv");}
ccc::CC0x1y5 ::~CC0x1y5(){ note_dtor("_ZN3ccc7CC0x1y5E", this);} // tgen
ccc::CC0x1y5 ::CC0x1y5(){ note_ctor("_ZN3ccc7CC0x1y5E", this);} // tgen
}
static void Test__ZN3ccc7CC0x1y5E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x1y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x1y5E, buf);
    ::ccc::CC0x1y5 *dp, &lv = *(dp=new (buf) ::ccc::CC0x1y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x1y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x1y5E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x1y5E");
    check_base_class_offset(lv, (::ccc::BB1*), ABISELECT(8,4), "_ZN3ccc7CC0x1y5E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x1y5E);
    dp->::ccc::CC0x1y5::~CC0x1y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x1y5E(Test__ZN3ccc7CC0x1y5E, "_ZN3ccc7CC0x1y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x1y5C1Ev();
extern void _ZN3ccc7CC0x1y5D1Ev();
Name_Map name_map__ZN3ccc7CC0x1y5E[] = {
  NSPAIR(_ZN3ccc7CC0x1y5C1Ev),
  NSPAIR(_ZN3ccc7CC0x1y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB1E;
extern VTBL_ENTRY _ZTIN3ccc3BB1E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB1E[];
static Base_Class bases__ZN3ccc7CC0x1y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB1E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x1y5E[];
extern void _ZN3ccc7CC0x1y53abcEv();
extern void _ZN3ccc7CC0x1y53efgEv();
extern void _ZN3ccc7CC0x1y53pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x1y53abcEv,_ZThn4_N3ccc7CC0x1y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x1y53pqrEv,_ZThn4_N3ccc7CC0x1y53pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x1y53efgEv,_ZThn4_N3ccc7CC0x1y53efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x1y5E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x1y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x1y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x1y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x1y53pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x1y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x1y53abcEv,_ZThn4_N3ccc7CC0x1y53abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x1y53pqrEv,_ZThn4_N3ccc7CC0x1y53pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x1y53efgEv,_ZThn4_N3ccc7CC0x1y53efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x1y5E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x1y5E[];
Class_Descriptor cd__ZN3ccc7CC0x1y5E = {  "_ZN3ccc7CC0x1y5E", // class name
  bases__ZN3ccc7CC0x1y5E, 2,
  &(vtc__ZN3ccc7CC0x1y5E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x1y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x1y5E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x1y6  : ::ccc::AA0 , ::ccc::BB1 {
  virtual void  abc(); // _ZN3ccc7CC0x1y63abcEv
  virtual void  efg(); // _ZN3ccc7CC0x1y63efgEv
  ~CC0x1y6(); // tgen
  CC0x1y6(); // tgen
};
//SIG(1 _ZN3ccc7CC0x1y6E) C1{ BC2{ v1 v2 v3} BC3{ v1 v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x1y6 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x1y63abcEv");}
void  ccc::CC0x1y6 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x1y63efgEv");}
ccc::CC0x1y6 ::~CC0x1y6(){ note_dtor("_ZN3ccc7CC0x1y6E", this);} // tgen
ccc::CC0x1y6 ::CC0x1y6(){ note_ctor("_ZN3ccc7CC0x1y6E", this);} // tgen
}
static void Test__ZN3ccc7CC0x1y6E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x1y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x1y6E, buf);
    ::ccc::CC0x1y6 *dp, &lv = *(dp=new (buf) ::ccc::CC0x1y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x1y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x1y6E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x1y6E");
    check_base_class_offset(lv, (::ccc::BB1*), ABISELECT(8,4), "_ZN3ccc7CC0x1y6E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x1y6E);
    dp->::ccc::CC0x1y6::~CC0x1y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x1y6E(Test__ZN3ccc7CC0x1y6E, "_ZN3ccc7CC0x1y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x1y6C1Ev();
extern void _ZN3ccc7CC0x1y6D1Ev();
Name_Map name_map__ZN3ccc7CC0x1y6E[] = {
  NSPAIR(_ZN3ccc7CC0x1y6C1Ev),
  NSPAIR(_ZN3ccc7CC0x1y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB1E;
extern VTBL_ENTRY _ZTIN3ccc3BB1E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB1E[];
static Base_Class bases__ZN3ccc7CC0x1y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB1E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x1y6E[];
extern void _ZN3ccc7CC0x1y63abcEv();
extern void _ZN3ccc7CC0x1y63efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x1y63abcEv,_ZThn4_N3ccc7CC0x1y63abcEv)();
extern void _ZN3ccc3BB13pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x1y63efgEv,_ZThn4_N3ccc7CC0x1y63efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x1y6E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x1y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x1y63abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x1y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x1y6E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x1y63abcEv,_ZThn4_N3ccc7CC0x1y63abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB13pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x1y63efgEv,_ZThn4_N3ccc7CC0x1y63efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x1y6E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x1y6E[];
Class_Descriptor cd__ZN3ccc7CC0x1y6E = {  "_ZN3ccc7CC0x1y6E", // class name
  bases__ZN3ccc7CC0x1y6E, 2,
  &(vtc__ZN3ccc7CC0x1y6E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x1y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x1y6E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x1y7  : ::ccc::AA0 , ::ccc::BB1 {
  virtual void  abc(); // _ZN3ccc7CC0x1y73abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x1y73pqrEv
  ~CC0x1y7(); // tgen
  CC0x1y7(); // tgen
};
//SIG(1 _ZN3ccc7CC0x1y7E) C1{ BC2{ v1 v3 v2} BC3{ v1 v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x1y7 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x1y73abcEv");}
void  ccc::CC0x1y7 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x1y73pqrEv");}
ccc::CC0x1y7 ::~CC0x1y7(){ note_dtor("_ZN3ccc7CC0x1y7E", this);} // tgen
ccc::CC0x1y7 ::CC0x1y7(){ note_ctor("_ZN3ccc7CC0x1y7E", this);} // tgen
}
static void Test__ZN3ccc7CC0x1y7E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x1y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x1y7E, buf);
    ::ccc::CC0x1y7 *dp, &lv = *(dp=new (buf) ::ccc::CC0x1y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x1y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x1y7E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x1y7E");
    check_base_class_offset(lv, (::ccc::BB1*), ABISELECT(8,4), "_ZN3ccc7CC0x1y7E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x1y7E);
    dp->::ccc::CC0x1y7::~CC0x1y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x1y7E(Test__ZN3ccc7CC0x1y7E, "_ZN3ccc7CC0x1y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x1y7C1Ev();
extern void _ZN3ccc7CC0x1y7D1Ev();
Name_Map name_map__ZN3ccc7CC0x1y7E[] = {
  NSPAIR(_ZN3ccc7CC0x1y7C1Ev),
  NSPAIR(_ZN3ccc7CC0x1y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB1E;
extern VTBL_ENTRY _ZTIN3ccc3BB1E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB1E[];
static Base_Class bases__ZN3ccc7CC0x1y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB1E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x1y7E[];
extern void _ZN3ccc7CC0x1y73abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc7CC0x1y73pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x1y73abcEv,_ZThn4_N3ccc7CC0x1y73abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x1y73pqrEv,_ZThn4_N3ccc7CC0x1y73pqrEv)();
extern void _ZN3ccc3BB13efgEv();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x1y7E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x1y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x1y73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x1y73pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x1y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x1y73abcEv,_ZThn4_N3ccc7CC0x1y73abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x1y73pqrEv,_ZThn4_N3ccc7CC0x1y73pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3BB13efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x1y7E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x1y7E[];
Class_Descriptor cd__ZN3ccc7CC0x1y7E = {  "_ZN3ccc7CC0x1y7E", // class name
  bases__ZN3ccc7CC0x1y7E, 2,
  &(vtc__ZN3ccc7CC0x1y7E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x1y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x1y7E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x1y8  : ::ccc::AA0 , ::ccc::BB1 {
  virtual void  efg(); // _ZN3ccc7CC0x1y83efgEv
  virtual void  abc(); // _ZN3ccc7CC0x1y83abcEv
  ~CC0x1y8(); // tgen
  CC0x1y8(); // tgen
};
//SIG(1 _ZN3ccc7CC0x1y8E) C1{ BC2{ v2 v1 v3} BC3{ v2 v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x1y8 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x1y83efgEv");}
void  ccc::CC0x1y8 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x1y83abcEv");}
ccc::CC0x1y8 ::~CC0x1y8(){ note_dtor("_ZN3ccc7CC0x1y8E", this);} // tgen
ccc::CC0x1y8 ::CC0x1y8(){ note_ctor("_ZN3ccc7CC0x1y8E", this);} // tgen
}
static void Test__ZN3ccc7CC0x1y8E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x1y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x1y8E, buf);
    ::ccc::CC0x1y8 *dp, &lv = *(dp=new (buf) ::ccc::CC0x1y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x1y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x1y8E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x1y8E");
    check_base_class_offset(lv, (::ccc::BB1*), ABISELECT(8,4), "_ZN3ccc7CC0x1y8E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x1y8E);
    dp->::ccc::CC0x1y8::~CC0x1y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x1y8E(Test__ZN3ccc7CC0x1y8E, "_ZN3ccc7CC0x1y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x1y8C1Ev();
extern void _ZN3ccc7CC0x1y8D1Ev();
Name_Map name_map__ZN3ccc7CC0x1y8E[] = {
  NSPAIR(_ZN3ccc7CC0x1y8C1Ev),
  NSPAIR(_ZN3ccc7CC0x1y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB1E;
extern VTBL_ENTRY _ZTIN3ccc3BB1E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB1E[];
static Base_Class bases__ZN3ccc7CC0x1y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB1E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x1y8E[];
extern void _ZN3ccc7CC0x1y83abcEv();
extern void _ZN3ccc7CC0x1y83efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x1y83abcEv,_ZThn4_N3ccc7CC0x1y83abcEv)();
extern void _ZN3ccc3BB13pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x1y83efgEv,_ZThn4_N3ccc7CC0x1y83efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x1y8E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x1y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x1y83abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x1y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x1y8E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x1y83abcEv,_ZThn4_N3ccc7CC0x1y83abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB13pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x1y83efgEv,_ZThn4_N3ccc7CC0x1y83efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x1y8E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x1y8E[];
Class_Descriptor cd__ZN3ccc7CC0x1y8E = {  "_ZN3ccc7CC0x1y8E", // class name
  bases__ZN3ccc7CC0x1y8E, 2,
  &(vtc__ZN3ccc7CC0x1y8E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x1y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x1y8E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x1y9  : ::ccc::AA0 , ::ccc::BB1 {
  virtual void  efg(); // _ZN3ccc7CC0x1y93efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x1y93pqrEv
  ~CC0x1y9(); // tgen
  CC0x1y9(); // tgen
};
//SIG(1 _ZN3ccc7CC0x1y9E) C1{ BC2{ v3 v1 v2} BC3{ v4 v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x1y9 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x1y93efgEv");}
void  ccc::CC0x1y9 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x1y93pqrEv");}
ccc::CC0x1y9 ::~CC0x1y9(){ note_dtor("_ZN3ccc7CC0x1y9E", this);} // tgen
ccc::CC0x1y9 ::CC0x1y9(){ note_ctor("_ZN3ccc7CC0x1y9E", this);} // tgen
}
static void Test__ZN3ccc7CC0x1y9E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x1y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x1y9E, buf);
    ::ccc::CC0x1y9 *dp, &lv = *(dp=new (buf) ::ccc::CC0x1y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x1y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x1y9E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x1y9E");
    check_base_class_offset(lv, (::ccc::BB1*), ABISELECT(8,4), "_ZN3ccc7CC0x1y9E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x1y9E);
    dp->::ccc::CC0x1y9::~CC0x1y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x1y9E(Test__ZN3ccc7CC0x1y9E, "_ZN3ccc7CC0x1y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x1y9C1Ev();
extern void _ZN3ccc7CC0x1y9D1Ev();
Name_Map name_map__ZN3ccc7CC0x1y9E[] = {
  NSPAIR(_ZN3ccc7CC0x1y9C1Ev),
  NSPAIR(_ZN3ccc7CC0x1y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB1E;
extern VTBL_ENTRY _ZTIN3ccc3BB1E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB1E[];
static Base_Class bases__ZN3ccc7CC0x1y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB1E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x1y9E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc7CC0x1y93efgEv();
extern void _ZN3ccc7CC0x1y93pqrEv();
extern void _ZN3ccc3BB13abcEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x1y93pqrEv,_ZThn4_N3ccc7CC0x1y93pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x1y93efgEv,_ZThn4_N3ccc7CC0x1y93efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x1y9E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x1y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x1y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x1y93pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x1y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB13abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x1y93pqrEv,_ZThn4_N3ccc7CC0x1y93pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x1y93efgEv,_ZThn4_N3ccc7CC0x1y93efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x1y9E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x1y9E[];
Class_Descriptor cd__ZN3ccc7CC0x1y9E = {  "_ZN3ccc7CC0x1y9E", // class name
  bases__ZN3ccc7CC0x1y9E, 2,
  &(vtc__ZN3ccc7CC0x1y9E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x1y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x1y9E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x1y10  : ::ccc::AA0 , ::ccc::BB1 {
  virtual void  pqr(); // _ZN3ccc8CC0x1y103pqrEv
  virtual void  abc(); // _ZN3ccc8CC0x1y103abcEv
  ~CC0x1y10(); // tgen
  CC0x1y10(); // tgen
};
//SIG(1 _ZN3ccc8CC0x1y10E) C1{ BC2{ v2 v3 v1} BC3{ v2 v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x1y10 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x1y103pqrEv");}
void  ccc::CC0x1y10 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x1y103abcEv");}
ccc::CC0x1y10 ::~CC0x1y10(){ note_dtor("_ZN3ccc8CC0x1y10E", this);} // tgen
ccc::CC0x1y10 ::CC0x1y10(){ note_ctor("_ZN3ccc8CC0x1y10E", this);} // tgen
}
static void Test__ZN3ccc8CC0x1y10E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x1y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x1y10E, buf);
    ::ccc::CC0x1y10 *dp, &lv = *(dp=new (buf) ::ccc::CC0x1y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x1y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x1y10E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x1y10E");
    check_base_class_offset(lv, (::ccc::BB1*), ABISELECT(8,4), "_ZN3ccc8CC0x1y10E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x1y10E);
    dp->::ccc::CC0x1y10::~CC0x1y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x1y10E(Test__ZN3ccc8CC0x1y10E, "_ZN3ccc8CC0x1y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x1y10C1Ev();
extern void _ZN3ccc8CC0x1y10D1Ev();
Name_Map name_map__ZN3ccc8CC0x1y10E[] = {
  NSPAIR(_ZN3ccc8CC0x1y10C1Ev),
  NSPAIR(_ZN3ccc8CC0x1y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB1E;
extern VTBL_ENTRY _ZTIN3ccc3BB1E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB1E[];
static Base_Class bases__ZN3ccc8CC0x1y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB1E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x1y10E[];
extern void _ZN3ccc8CC0x1y103abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc8CC0x1y103pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x1y103abcEv,_ZThn4_N3ccc8CC0x1y103abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC0x1y103pqrEv,_ZThn4_N3ccc8CC0x1y103pqrEv)();
extern void _ZN3ccc3BB13efgEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x1y10E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x1y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x1y103abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x1y103pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x1y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x1y103abcEv,_ZThn4_N3ccc8CC0x1y103abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x1y103pqrEv,_ZThn4_N3ccc8CC0x1y103pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3BB13efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x1y10E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x1y10E[];
Class_Descriptor cd__ZN3ccc8CC0x1y10E = {  "_ZN3ccc8CC0x1y10E", // class name
  bases__ZN3ccc8CC0x1y10E, 2,
  &(vtc__ZN3ccc8CC0x1y10E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x1y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x1y10E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x1y11  : ::ccc::AA0 , ::ccc::BB1 {
  virtual void  pqr(); // _ZN3ccc8CC0x1y113pqrEv
  virtual void  efg(); // _ZN3ccc8CC0x1y113efgEv
  ~CC0x1y11(); // tgen
  CC0x1y11(); // tgen
};
//SIG(1 _ZN3ccc8CC0x1y11E) C1{ BC2{ v3 v2 v1} BC3{ v4 v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x1y11 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x1y113pqrEv");}
void  ccc::CC0x1y11 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x1y113efgEv");}
ccc::CC0x1y11 ::~CC0x1y11(){ note_dtor("_ZN3ccc8CC0x1y11E", this);} // tgen
ccc::CC0x1y11 ::CC0x1y11(){ note_ctor("_ZN3ccc8CC0x1y11E", this);} // tgen
}
static void Test__ZN3ccc8CC0x1y11E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x1y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x1y11E, buf);
    ::ccc::CC0x1y11 *dp, &lv = *(dp=new (buf) ::ccc::CC0x1y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x1y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x1y11E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x1y11E");
    check_base_class_offset(lv, (::ccc::BB1*), ABISELECT(8,4), "_ZN3ccc8CC0x1y11E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x1y11E);
    dp->::ccc::CC0x1y11::~CC0x1y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x1y11E(Test__ZN3ccc8CC0x1y11E, "_ZN3ccc8CC0x1y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x1y11C1Ev();
extern void _ZN3ccc8CC0x1y11D1Ev();
Name_Map name_map__ZN3ccc8CC0x1y11E[] = {
  NSPAIR(_ZN3ccc8CC0x1y11C1Ev),
  NSPAIR(_ZN3ccc8CC0x1y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB1E;
extern VTBL_ENTRY _ZTIN3ccc3BB1E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB1E[];
static Base_Class bases__ZN3ccc8CC0x1y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB1E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x1y11E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc8CC0x1y113efgEv();
extern void _ZN3ccc8CC0x1y113pqrEv();
extern void _ZN3ccc3BB13abcEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x1y113pqrEv,_ZThn4_N3ccc8CC0x1y113pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC0x1y113efgEv,_ZThn4_N3ccc8CC0x1y113efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x1y11E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x1y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x1y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x1y113pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x1y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB13abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x1y113pqrEv,_ZThn4_N3ccc8CC0x1y113pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x1y113efgEv,_ZThn4_N3ccc8CC0x1y113efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x1y11E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x1y11E[];
Class_Descriptor cd__ZN3ccc8CC0x1y11E = {  "_ZN3ccc8CC0x1y11E", // class name
  bases__ZN3ccc8CC0x1y11E, 2,
  &(vtc__ZN3ccc8CC0x1y11E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x1y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x1y11E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x1y12  : ::ccc::AA0 , ::ccc::BB1 {
  virtual void  abc(); // _ZN3ccc8CC0x1y123abcEv
  ~CC0x1y12(); // tgen
  CC0x1y12(); // tgen
};
//SIG(1 _ZN3ccc8CC0x1y12E) C1{ BC2{ v1 v2 v3} BC3{ v1 v4 v5} v1}
}
namespace ccc { 
void  ccc::CC0x1y12 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x1y123abcEv");}
ccc::CC0x1y12 ::~CC0x1y12(){ note_dtor("_ZN3ccc8CC0x1y12E", this);} // tgen
ccc::CC0x1y12 ::CC0x1y12(){ note_ctor("_ZN3ccc8CC0x1y12E", this);} // tgen
}
static void Test__ZN3ccc8CC0x1y12E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x1y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x1y12E, buf);
    ::ccc::CC0x1y12 *dp, &lv = *(dp=new (buf) ::ccc::CC0x1y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x1y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x1y12E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x1y12E");
    check_base_class_offset(lv, (::ccc::BB1*), ABISELECT(8,4), "_ZN3ccc8CC0x1y12E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x1y12E);
    dp->::ccc::CC0x1y12::~CC0x1y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x1y12E(Test__ZN3ccc8CC0x1y12E, "_ZN3ccc8CC0x1y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x1y12C1Ev();
extern void _ZN3ccc8CC0x1y12D1Ev();
Name_Map name_map__ZN3ccc8CC0x1y12E[] = {
  NSPAIR(_ZN3ccc8CC0x1y12C1Ev),
  NSPAIR(_ZN3ccc8CC0x1y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB1E;
extern VTBL_ENTRY _ZTIN3ccc3BB1E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB1E[];
static Base_Class bases__ZN3ccc8CC0x1y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB1E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x1y12E[];
extern void _ZN3ccc8CC0x1y123abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x1y123abcEv,_ZThn4_N3ccc8CC0x1y123abcEv)();
extern void _ZN3ccc3BB13pqrEv();
extern void _ZN3ccc3BB13efgEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x1y12E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x1y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x1y123abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x1y12E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x1y123abcEv,_ZThn4_N3ccc8CC0x1y123abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB13efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x1y12E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x1y12E[];
Class_Descriptor cd__ZN3ccc8CC0x1y12E = {  "_ZN3ccc8CC0x1y12E", // class name
  bases__ZN3ccc8CC0x1y12E, 2,
  &(vtc__ZN3ccc8CC0x1y12E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x1y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x1y12E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x1y13  : ::ccc::AA0 , ::ccc::BB1 {
  virtual void  efg(); // _ZN3ccc8CC0x1y133efgEv
  ~CC0x1y13(); // tgen
  CC0x1y13(); // tgen
};
//SIG(1 _ZN3ccc8CC0x1y13E) C1{ BC2{ v2 v1 v3} BC3{ v4 v5 v1} v1}
}
namespace ccc { 
void  ccc::CC0x1y13 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x1y133efgEv");}
ccc::CC0x1y13 ::~CC0x1y13(){ note_dtor("_ZN3ccc8CC0x1y13E", this);} // tgen
ccc::CC0x1y13 ::CC0x1y13(){ note_ctor("_ZN3ccc8CC0x1y13E", this);} // tgen
}
static void Test__ZN3ccc8CC0x1y13E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x1y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x1y13E, buf);
    ::ccc::CC0x1y13 *dp, &lv = *(dp=new (buf) ::ccc::CC0x1y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x1y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x1y13E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x1y13E");
    check_base_class_offset(lv, (::ccc::BB1*), ABISELECT(8,4), "_ZN3ccc8CC0x1y13E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x1y13E);
    dp->::ccc::CC0x1y13::~CC0x1y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x1y13E(Test__ZN3ccc8CC0x1y13E, "_ZN3ccc8CC0x1y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x1y13C1Ev();
extern void _ZN3ccc8CC0x1y13D1Ev();
Name_Map name_map__ZN3ccc8CC0x1y13E[] = {
  NSPAIR(_ZN3ccc8CC0x1y13C1Ev),
  NSPAIR(_ZN3ccc8CC0x1y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB1E;
extern VTBL_ENTRY _ZTIN3ccc3BB1E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB1E[];
static Base_Class bases__ZN3ccc8CC0x1y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB1E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x1y13E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc8CC0x1y133efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc3BB13abcEv();
extern void _ZN3ccc3BB13pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x1y133efgEv,_ZThn4_N3ccc8CC0x1y133efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x1y13E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x1y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x1y133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x1y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB13abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB13pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x1y133efgEv,_ZThn4_N3ccc8CC0x1y133efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x1y13E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x1y13E[];
Class_Descriptor cd__ZN3ccc8CC0x1y13E = {  "_ZN3ccc8CC0x1y13E", // class name
  bases__ZN3ccc8CC0x1y13E, 2,
  &(vtc__ZN3ccc8CC0x1y13E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x1y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x1y13E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x1y14  : ::ccc::AA0 , ::ccc::BB1 {
  virtual void  pqr(); // _ZN3ccc8CC0x1y143pqrEv
  ~CC0x1y14(); // tgen
  CC0x1y14(); // tgen
};
//SIG(1 _ZN3ccc8CC0x1y14E) C1{ BC2{ v2 v3 v1} BC3{ v4 v1 v5} v1}
}
namespace ccc { 
void  ccc::CC0x1y14 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x1y143pqrEv");}
ccc::CC0x1y14 ::~CC0x1y14(){ note_dtor("_ZN3ccc8CC0x1y14E", this);} // tgen
ccc::CC0x1y14 ::CC0x1y14(){ note_ctor("_ZN3ccc8CC0x1y14E", this);} // tgen
}
static void Test__ZN3ccc8CC0x1y14E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x1y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x1y14E, buf);
    ::ccc::CC0x1y14 *dp, &lv = *(dp=new (buf) ::ccc::CC0x1y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x1y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x1y14E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x1y14E");
    check_base_class_offset(lv, (::ccc::BB1*), ABISELECT(8,4), "_ZN3ccc8CC0x1y14E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x1y14E);
    dp->::ccc::CC0x1y14::~CC0x1y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x1y14E(Test__ZN3ccc8CC0x1y14E, "_ZN3ccc8CC0x1y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x1y14C1Ev();
extern void _ZN3ccc8CC0x1y14D1Ev();
Name_Map name_map__ZN3ccc8CC0x1y14E[] = {
  NSPAIR(_ZN3ccc8CC0x1y14C1Ev),
  NSPAIR(_ZN3ccc8CC0x1y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB1E;
extern VTBL_ENTRY _ZTIN3ccc3BB1E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB1E[];
static Base_Class bases__ZN3ccc8CC0x1y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB1E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x1y14E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc8CC0x1y143pqrEv();
extern void _ZN3ccc3BB13abcEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x1y143pqrEv,_ZThn4_N3ccc8CC0x1y143pqrEv)();
extern void _ZN3ccc3BB13efgEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x1y14E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x1y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x1y143pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x1y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB13abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x1y143pqrEv,_ZThn4_N3ccc8CC0x1y143pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3BB13efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x1y14E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x1y14E[];
Class_Descriptor cd__ZN3ccc8CC0x1y14E = {  "_ZN3ccc8CC0x1y14E", // class name
  bases__ZN3ccc8CC0x1y14E, 2,
  &(vtc__ZN3ccc8CC0x1y14E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x1y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x1y14E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x1y15  : ::ccc::AA0 , ::ccc::BB1 {
  ~CC0x1y15(); // tgen
  CC0x1y15(); // tgen
};
//SIG(1 _ZN3ccc8CC0x1y15E) C1{ BC2{ v1 v2 v3} BC3{ v4 v5 v6}}
}
namespace ccc { 
ccc::CC0x1y15 ::~CC0x1y15(){ note_dtor("_ZN3ccc8CC0x1y15E", this);} // tgen
ccc::CC0x1y15 ::CC0x1y15(){ note_ctor("_ZN3ccc8CC0x1y15E", this);} // tgen
}
static void Test__ZN3ccc8CC0x1y15E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x1y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x1y15E, buf);
    ::ccc::CC0x1y15 *dp, &lv = *(dp=new (buf) ::ccc::CC0x1y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x1y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x1y15E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x1y15E");
    check_base_class_offset(lv, (::ccc::BB1*), ABISELECT(8,4), "_ZN3ccc8CC0x1y15E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x1y15E);
    dp->::ccc::CC0x1y15::~CC0x1y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x1y15E(Test__ZN3ccc8CC0x1y15E, "_ZN3ccc8CC0x1y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x1y15C1Ev();
extern void _ZN3ccc8CC0x1y15D1Ev();
Name_Map name_map__ZN3ccc8CC0x1y15E[] = {
  NSPAIR(_ZN3ccc8CC0x1y15C1Ev),
  NSPAIR(_ZN3ccc8CC0x1y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB1E;
extern VTBL_ENTRY _ZTIN3ccc3BB1E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB1E[];
static Base_Class bases__ZN3ccc8CC0x1y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB1E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x1y15E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc3BB13abcEv();
extern void _ZN3ccc3BB13pqrEv();
extern void _ZN3ccc3BB13efgEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x1y15E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x1y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x1y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB13abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB13pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB13efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x1y15E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x1y15E[];
Class_Descriptor cd__ZN3ccc8CC0x1y15E = {  "_ZN3ccc8CC0x1y15E", // class name
  bases__ZN3ccc8CC0x1y15E, 2,
  &(vtc__ZN3ccc8CC0x1y15E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x1y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x1y15E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x2y0  : ::ccc::AA0 , ::ccc::BB2 {
  virtual void  abc(); // _ZN3ccc7CC0x2y03abcEv
  virtual void  efg(); // _ZN3ccc7CC0x2y03efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x2y03pqrEv
  ~CC0x2y0(); // tgen
  CC0x2y0(); // tgen
};
//SIG(1 _ZN3ccc7CC0x2y0E) C1{ BC2{ v1 v2 v3} BC3{ v2 v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x2y0 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x2y03abcEv");}
void  ccc::CC0x2y0 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x2y03efgEv");}
void  ccc::CC0x2y0 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x2y03pqrEv");}
ccc::CC0x2y0 ::~CC0x2y0(){ note_dtor("_ZN3ccc7CC0x2y0E", this);} // tgen
ccc::CC0x2y0 ::CC0x2y0(){ note_ctor("_ZN3ccc7CC0x2y0E", this);} // tgen
}
static void Test__ZN3ccc7CC0x2y0E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x2y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x2y0E, buf);
    ::ccc::CC0x2y0 *dp, &lv = *(dp=new (buf) ::ccc::CC0x2y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x2y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x2y0E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x2y0E");
    check_base_class_offset(lv, (::ccc::BB2*), ABISELECT(8,4), "_ZN3ccc7CC0x2y0E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x2y0E);
    dp->::ccc::CC0x2y0::~CC0x2y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x2y0E(Test__ZN3ccc7CC0x2y0E, "_ZN3ccc7CC0x2y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x2y0C1Ev();
extern void _ZN3ccc7CC0x2y0D1Ev();
Name_Map name_map__ZN3ccc7CC0x2y0E[] = {
  NSPAIR(_ZN3ccc7CC0x2y0C1Ev),
  NSPAIR(_ZN3ccc7CC0x2y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB2E;
extern VTBL_ENTRY _ZTIN3ccc3BB2E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB2E[];
static Base_Class bases__ZN3ccc7CC0x2y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB2E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x2y0E[];
extern void _ZN3ccc7CC0x2y03abcEv();
extern void _ZN3ccc7CC0x2y03efgEv();
extern void _ZN3ccc7CC0x2y03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x2y03efgEv,_ZThn4_N3ccc7CC0x2y03efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x2y03abcEv,_ZThn4_N3ccc7CC0x2y03abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x2y03pqrEv,_ZThn4_N3ccc7CC0x2y03pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x2y0E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x2y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x2y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x2y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x2y03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x2y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x2y03efgEv,_ZThn4_N3ccc7CC0x2y03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x2y03abcEv,_ZThn4_N3ccc7CC0x2y03abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x2y03pqrEv,_ZThn4_N3ccc7CC0x2y03pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x2y0E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x2y0E[];
Class_Descriptor cd__ZN3ccc7CC0x2y0E = {  "_ZN3ccc7CC0x2y0E", // class name
  bases__ZN3ccc7CC0x2y0E, 2,
  &(vtc__ZN3ccc7CC0x2y0E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x2y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x2y0E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x2y1  : ::ccc::AA0 , ::ccc::BB2 {
  virtual void  abc(); // _ZN3ccc7CC0x2y13abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x2y13pqrEv
  virtual void  efg(); // _ZN3ccc7CC0x2y13efgEv
  ~CC0x2y1(); // tgen
  CC0x2y1(); // tgen
};
//SIG(1 _ZN3ccc7CC0x2y1E) C1{ BC2{ v1 v3 v2} BC3{ v3 v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x2y1 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x2y13abcEv");}
void  ccc::CC0x2y1 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x2y13pqrEv");}
void  ccc::CC0x2y1 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x2y13efgEv");}
ccc::CC0x2y1 ::~CC0x2y1(){ note_dtor("_ZN3ccc7CC0x2y1E", this);} // tgen
ccc::CC0x2y1 ::CC0x2y1(){ note_ctor("_ZN3ccc7CC0x2y1E", this);} // tgen
}
static void Test__ZN3ccc7CC0x2y1E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x2y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x2y1E, buf);
    ::ccc::CC0x2y1 *dp, &lv = *(dp=new (buf) ::ccc::CC0x2y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x2y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x2y1E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x2y1E");
    check_base_class_offset(lv, (::ccc::BB2*), ABISELECT(8,4), "_ZN3ccc7CC0x2y1E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x2y1E);
    dp->::ccc::CC0x2y1::~CC0x2y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x2y1E(Test__ZN3ccc7CC0x2y1E, "_ZN3ccc7CC0x2y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x2y1C1Ev();
extern void _ZN3ccc7CC0x2y1D1Ev();
Name_Map name_map__ZN3ccc7CC0x2y1E[] = {
  NSPAIR(_ZN3ccc7CC0x2y1C1Ev),
  NSPAIR(_ZN3ccc7CC0x2y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB2E;
extern VTBL_ENTRY _ZTIN3ccc3BB2E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB2E[];
static Base_Class bases__ZN3ccc7CC0x2y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB2E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x2y1E[];
extern void _ZN3ccc7CC0x2y13abcEv();
extern void _ZN3ccc7CC0x2y13efgEv();
extern void _ZN3ccc7CC0x2y13pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x2y13efgEv,_ZThn4_N3ccc7CC0x2y13efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x2y13abcEv,_ZThn4_N3ccc7CC0x2y13abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x2y13pqrEv,_ZThn4_N3ccc7CC0x2y13pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x2y1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x2y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x2y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x2y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x2y13pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x2y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x2y13efgEv,_ZThn4_N3ccc7CC0x2y13efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x2y13abcEv,_ZThn4_N3ccc7CC0x2y13abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x2y13pqrEv,_ZThn4_N3ccc7CC0x2y13pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x2y1E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x2y1E[];
Class_Descriptor cd__ZN3ccc7CC0x2y1E = {  "_ZN3ccc7CC0x2y1E", // class name
  bases__ZN3ccc7CC0x2y1E, 2,
  &(vtc__ZN3ccc7CC0x2y1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x2y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x2y1E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x2y2  : ::ccc::AA0 , ::ccc::BB2 {
  virtual void  efg(); // _ZN3ccc7CC0x2y23efgEv
  virtual void  abc(); // _ZN3ccc7CC0x2y23abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x2y23pqrEv
  ~CC0x2y2(); // tgen
  CC0x2y2(); // tgen
};
//SIG(1 _ZN3ccc7CC0x2y2E) C1{ BC2{ v2 v1 v3} BC3{ v1 v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x2y2 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x2y23efgEv");}
void  ccc::CC0x2y2 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x2y23abcEv");}
void  ccc::CC0x2y2 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x2y23pqrEv");}
ccc::CC0x2y2 ::~CC0x2y2(){ note_dtor("_ZN3ccc7CC0x2y2E", this);} // tgen
ccc::CC0x2y2 ::CC0x2y2(){ note_ctor("_ZN3ccc7CC0x2y2E", this);} // tgen
}
static void Test__ZN3ccc7CC0x2y2E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x2y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x2y2E, buf);
    ::ccc::CC0x2y2 *dp, &lv = *(dp=new (buf) ::ccc::CC0x2y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x2y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x2y2E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x2y2E");
    check_base_class_offset(lv, (::ccc::BB2*), ABISELECT(8,4), "_ZN3ccc7CC0x2y2E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x2y2E);
    dp->::ccc::CC0x2y2::~CC0x2y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x2y2E(Test__ZN3ccc7CC0x2y2E, "_ZN3ccc7CC0x2y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x2y2C1Ev();
extern void _ZN3ccc7CC0x2y2D1Ev();
Name_Map name_map__ZN3ccc7CC0x2y2E[] = {
  NSPAIR(_ZN3ccc7CC0x2y2C1Ev),
  NSPAIR(_ZN3ccc7CC0x2y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB2E;
extern VTBL_ENTRY _ZTIN3ccc3BB2E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB2E[];
static Base_Class bases__ZN3ccc7CC0x2y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB2E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x2y2E[];
extern void _ZN3ccc7CC0x2y23abcEv();
extern void _ZN3ccc7CC0x2y23efgEv();
extern void _ZN3ccc7CC0x2y23pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x2y23efgEv,_ZThn4_N3ccc7CC0x2y23efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x2y23abcEv,_ZThn4_N3ccc7CC0x2y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x2y23pqrEv,_ZThn4_N3ccc7CC0x2y23pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x2y2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x2y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x2y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x2y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x2y23pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x2y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x2y23efgEv,_ZThn4_N3ccc7CC0x2y23efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x2y23abcEv,_ZThn4_N3ccc7CC0x2y23abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x2y23pqrEv,_ZThn4_N3ccc7CC0x2y23pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x2y2E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x2y2E[];
Class_Descriptor cd__ZN3ccc7CC0x2y2E = {  "_ZN3ccc7CC0x2y2E", // class name
  bases__ZN3ccc7CC0x2y2E, 2,
  &(vtc__ZN3ccc7CC0x2y2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x2y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x2y2E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x2y3  : ::ccc::AA0 , ::ccc::BB2 {
  virtual void  efg(); // _ZN3ccc7CC0x2y33efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x2y33pqrEv
  virtual void  abc(); // _ZN3ccc7CC0x2y33abcEv
  ~CC0x2y3(); // tgen
  CC0x2y3(); // tgen
};
//SIG(1 _ZN3ccc7CC0x2y3E) C1{ BC2{ v3 v1 v2} BC3{ v1 v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x2y3 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x2y33efgEv");}
void  ccc::CC0x2y3 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x2y33pqrEv");}
void  ccc::CC0x2y3 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x2y33abcEv");}
ccc::CC0x2y3 ::~CC0x2y3(){ note_dtor("_ZN3ccc7CC0x2y3E", this);} // tgen
ccc::CC0x2y3 ::CC0x2y3(){ note_ctor("_ZN3ccc7CC0x2y3E", this);} // tgen
}
static void Test__ZN3ccc7CC0x2y3E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x2y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x2y3E, buf);
    ::ccc::CC0x2y3 *dp, &lv = *(dp=new (buf) ::ccc::CC0x2y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x2y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x2y3E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x2y3E");
    check_base_class_offset(lv, (::ccc::BB2*), ABISELECT(8,4), "_ZN3ccc7CC0x2y3E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x2y3E);
    dp->::ccc::CC0x2y3::~CC0x2y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x2y3E(Test__ZN3ccc7CC0x2y3E, "_ZN3ccc7CC0x2y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x2y3C1Ev();
extern void _ZN3ccc7CC0x2y3D1Ev();
Name_Map name_map__ZN3ccc7CC0x2y3E[] = {
  NSPAIR(_ZN3ccc7CC0x2y3C1Ev),
  NSPAIR(_ZN3ccc7CC0x2y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB2E;
extern VTBL_ENTRY _ZTIN3ccc3BB2E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB2E[];
static Base_Class bases__ZN3ccc7CC0x2y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB2E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x2y3E[];
extern void _ZN3ccc7CC0x2y33abcEv();
extern void _ZN3ccc7CC0x2y33efgEv();
extern void _ZN3ccc7CC0x2y33pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x2y33efgEv,_ZThn4_N3ccc7CC0x2y33efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x2y33abcEv,_ZThn4_N3ccc7CC0x2y33abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x2y33pqrEv,_ZThn4_N3ccc7CC0x2y33pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x2y3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x2y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x2y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x2y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x2y33pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x2y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x2y33efgEv,_ZThn4_N3ccc7CC0x2y33efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x2y33abcEv,_ZThn4_N3ccc7CC0x2y33abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x2y33pqrEv,_ZThn4_N3ccc7CC0x2y33pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x2y3E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x2y3E[];
Class_Descriptor cd__ZN3ccc7CC0x2y3E = {  "_ZN3ccc7CC0x2y3E", // class name
  bases__ZN3ccc7CC0x2y3E, 2,
  &(vtc__ZN3ccc7CC0x2y3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x2y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x2y3E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x2y4  : ::ccc::AA0 , ::ccc::BB2 {
  virtual void  pqr(); // _ZN3ccc7CC0x2y43pqrEv
  virtual void  abc(); // _ZN3ccc7CC0x2y43abcEv
  virtual void  efg(); // _ZN3ccc7CC0x2y43efgEv
  ~CC0x2y4(); // tgen
  CC0x2y4(); // tgen
};
//SIG(1 _ZN3ccc7CC0x2y4E) C1{ BC2{ v2 v3 v1} BC3{ v3 v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x2y4 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x2y43pqrEv");}
void  ccc::CC0x2y4 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x2y43abcEv");}
void  ccc::CC0x2y4 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x2y43efgEv");}
ccc::CC0x2y4 ::~CC0x2y4(){ note_dtor("_ZN3ccc7CC0x2y4E", this);} // tgen
ccc::CC0x2y4 ::CC0x2y4(){ note_ctor("_ZN3ccc7CC0x2y4E", this);} // tgen
}
static void Test__ZN3ccc7CC0x2y4E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x2y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x2y4E, buf);
    ::ccc::CC0x2y4 *dp, &lv = *(dp=new (buf) ::ccc::CC0x2y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x2y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x2y4E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x2y4E");
    check_base_class_offset(lv, (::ccc::BB2*), ABISELECT(8,4), "_ZN3ccc7CC0x2y4E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x2y4E);
    dp->::ccc::CC0x2y4::~CC0x2y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x2y4E(Test__ZN3ccc7CC0x2y4E, "_ZN3ccc7CC0x2y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x2y4C1Ev();
extern void _ZN3ccc7CC0x2y4D1Ev();
Name_Map name_map__ZN3ccc7CC0x2y4E[] = {
  NSPAIR(_ZN3ccc7CC0x2y4C1Ev),
  NSPAIR(_ZN3ccc7CC0x2y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB2E;
extern VTBL_ENTRY _ZTIN3ccc3BB2E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB2E[];
static Base_Class bases__ZN3ccc7CC0x2y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB2E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x2y4E[];
extern void _ZN3ccc7CC0x2y43abcEv();
extern void _ZN3ccc7CC0x2y43efgEv();
extern void _ZN3ccc7CC0x2y43pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x2y43efgEv,_ZThn4_N3ccc7CC0x2y43efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x2y43abcEv,_ZThn4_N3ccc7CC0x2y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x2y43pqrEv,_ZThn4_N3ccc7CC0x2y43pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x2y4E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x2y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x2y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x2y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x2y43pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x2y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x2y43efgEv,_ZThn4_N3ccc7CC0x2y43efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x2y43abcEv,_ZThn4_N3ccc7CC0x2y43abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x2y43pqrEv,_ZThn4_N3ccc7CC0x2y43pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x2y4E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x2y4E[];
Class_Descriptor cd__ZN3ccc7CC0x2y4E = {  "_ZN3ccc7CC0x2y4E", // class name
  bases__ZN3ccc7CC0x2y4E, 2,
  &(vtc__ZN3ccc7CC0x2y4E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x2y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x2y4E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x2y5  : ::ccc::AA0 , ::ccc::BB2 {
  virtual void  pqr(); // _ZN3ccc7CC0x2y53pqrEv
  virtual void  efg(); // _ZN3ccc7CC0x2y53efgEv
  virtual void  abc(); // _ZN3ccc7CC0x2y53abcEv
  ~CC0x2y5(); // tgen
  CC0x2y5(); // tgen
};
//SIG(1 _ZN3ccc7CC0x2y5E) C1{ BC2{ v3 v2 v1} BC3{ v2 v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x2y5 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x2y53pqrEv");}
void  ccc::CC0x2y5 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x2y53efgEv");}
void  ccc::CC0x2y5 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x2y53abcEv");}
ccc::CC0x2y5 ::~CC0x2y5(){ note_dtor("_ZN3ccc7CC0x2y5E", this);} // tgen
ccc::CC0x2y5 ::CC0x2y5(){ note_ctor("_ZN3ccc7CC0x2y5E", this);} // tgen
}
static void Test__ZN3ccc7CC0x2y5E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x2y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x2y5E, buf);
    ::ccc::CC0x2y5 *dp, &lv = *(dp=new (buf) ::ccc::CC0x2y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x2y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x2y5E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x2y5E");
    check_base_class_offset(lv, (::ccc::BB2*), ABISELECT(8,4), "_ZN3ccc7CC0x2y5E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x2y5E);
    dp->::ccc::CC0x2y5::~CC0x2y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x2y5E(Test__ZN3ccc7CC0x2y5E, "_ZN3ccc7CC0x2y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x2y5C1Ev();
extern void _ZN3ccc7CC0x2y5D1Ev();
Name_Map name_map__ZN3ccc7CC0x2y5E[] = {
  NSPAIR(_ZN3ccc7CC0x2y5C1Ev),
  NSPAIR(_ZN3ccc7CC0x2y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB2E;
extern VTBL_ENTRY _ZTIN3ccc3BB2E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB2E[];
static Base_Class bases__ZN3ccc7CC0x2y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB2E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x2y5E[];
extern void _ZN3ccc7CC0x2y53abcEv();
extern void _ZN3ccc7CC0x2y53efgEv();
extern void _ZN3ccc7CC0x2y53pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x2y53efgEv,_ZThn4_N3ccc7CC0x2y53efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x2y53abcEv,_ZThn4_N3ccc7CC0x2y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x2y53pqrEv,_ZThn4_N3ccc7CC0x2y53pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x2y5E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x2y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x2y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x2y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x2y53pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x2y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x2y53efgEv,_ZThn4_N3ccc7CC0x2y53efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x2y53abcEv,_ZThn4_N3ccc7CC0x2y53abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x2y53pqrEv,_ZThn4_N3ccc7CC0x2y53pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x2y5E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x2y5E[];
Class_Descriptor cd__ZN3ccc7CC0x2y5E = {  "_ZN3ccc7CC0x2y5E", // class name
  bases__ZN3ccc7CC0x2y5E, 2,
  &(vtc__ZN3ccc7CC0x2y5E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x2y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x2y5E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x2y6  : ::ccc::AA0 , ::ccc::BB2 {
  virtual void  abc(); // _ZN3ccc7CC0x2y63abcEv
  virtual void  efg(); // _ZN3ccc7CC0x2y63efgEv
  ~CC0x2y6(); // tgen
  CC0x2y6(); // tgen
};
//SIG(1 _ZN3ccc7CC0x2y6E) C1{ BC2{ v1 v2 v3} BC3{ v2 v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x2y6 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x2y63abcEv");}
void  ccc::CC0x2y6 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x2y63efgEv");}
ccc::CC0x2y6 ::~CC0x2y6(){ note_dtor("_ZN3ccc7CC0x2y6E", this);} // tgen
ccc::CC0x2y6 ::CC0x2y6(){ note_ctor("_ZN3ccc7CC0x2y6E", this);} // tgen
}
static void Test__ZN3ccc7CC0x2y6E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x2y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x2y6E, buf);
    ::ccc::CC0x2y6 *dp, &lv = *(dp=new (buf) ::ccc::CC0x2y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x2y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x2y6E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x2y6E");
    check_base_class_offset(lv, (::ccc::BB2*), ABISELECT(8,4), "_ZN3ccc7CC0x2y6E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x2y6E);
    dp->::ccc::CC0x2y6::~CC0x2y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x2y6E(Test__ZN3ccc7CC0x2y6E, "_ZN3ccc7CC0x2y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x2y6C1Ev();
extern void _ZN3ccc7CC0x2y6D1Ev();
Name_Map name_map__ZN3ccc7CC0x2y6E[] = {
  NSPAIR(_ZN3ccc7CC0x2y6C1Ev),
  NSPAIR(_ZN3ccc7CC0x2y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB2E;
extern VTBL_ENTRY _ZTIN3ccc3BB2E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB2E[];
static Base_Class bases__ZN3ccc7CC0x2y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB2E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x2y6E[];
extern void _ZN3ccc7CC0x2y63abcEv();
extern void _ZN3ccc7CC0x2y63efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x2y63efgEv,_ZThn4_N3ccc7CC0x2y63efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x2y63abcEv,_ZThn4_N3ccc7CC0x2y63abcEv)();
extern void _ZN3ccc3BB23pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x2y6E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x2y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x2y63abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x2y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x2y6E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x2y63efgEv,_ZThn4_N3ccc7CC0x2y63efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x2y63abcEv,_ZThn4_N3ccc7CC0x2y63abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB23pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x2y6E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x2y6E[];
Class_Descriptor cd__ZN3ccc7CC0x2y6E = {  "_ZN3ccc7CC0x2y6E", // class name
  bases__ZN3ccc7CC0x2y6E, 2,
  &(vtc__ZN3ccc7CC0x2y6E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x2y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x2y6E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x2y7  : ::ccc::AA0 , ::ccc::BB2 {
  virtual void  abc(); // _ZN3ccc7CC0x2y73abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x2y73pqrEv
  ~CC0x2y7(); // tgen
  CC0x2y7(); // tgen
};
//SIG(1 _ZN3ccc7CC0x2y7E) C1{ BC2{ v1 v3 v2} BC3{ v4 v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x2y7 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x2y73abcEv");}
void  ccc::CC0x2y7 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x2y73pqrEv");}
ccc::CC0x2y7 ::~CC0x2y7(){ note_dtor("_ZN3ccc7CC0x2y7E", this);} // tgen
ccc::CC0x2y7 ::CC0x2y7(){ note_ctor("_ZN3ccc7CC0x2y7E", this);} // tgen
}
static void Test__ZN3ccc7CC0x2y7E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x2y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x2y7E, buf);
    ::ccc::CC0x2y7 *dp, &lv = *(dp=new (buf) ::ccc::CC0x2y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x2y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x2y7E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x2y7E");
    check_base_class_offset(lv, (::ccc::BB2*), ABISELECT(8,4), "_ZN3ccc7CC0x2y7E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x2y7E);
    dp->::ccc::CC0x2y7::~CC0x2y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x2y7E(Test__ZN3ccc7CC0x2y7E, "_ZN3ccc7CC0x2y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x2y7C1Ev();
extern void _ZN3ccc7CC0x2y7D1Ev();
Name_Map name_map__ZN3ccc7CC0x2y7E[] = {
  NSPAIR(_ZN3ccc7CC0x2y7C1Ev),
  NSPAIR(_ZN3ccc7CC0x2y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB2E;
extern VTBL_ENTRY _ZTIN3ccc3BB2E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB2E[];
static Base_Class bases__ZN3ccc7CC0x2y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB2E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x2y7E[];
extern void _ZN3ccc7CC0x2y73abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc7CC0x2y73pqrEv();
extern void _ZN3ccc3BB23efgEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x2y73abcEv,_ZThn4_N3ccc7CC0x2y73abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x2y73pqrEv,_ZThn4_N3ccc7CC0x2y73pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x2y7E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x2y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x2y73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x2y73pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x2y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB23efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x2y73abcEv,_ZThn4_N3ccc7CC0x2y73abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x2y73pqrEv,_ZThn4_N3ccc7CC0x2y73pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x2y7E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x2y7E[];
Class_Descriptor cd__ZN3ccc7CC0x2y7E = {  "_ZN3ccc7CC0x2y7E", // class name
  bases__ZN3ccc7CC0x2y7E, 2,
  &(vtc__ZN3ccc7CC0x2y7E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x2y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x2y7E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x2y8  : ::ccc::AA0 , ::ccc::BB2 {
  virtual void  efg(); // _ZN3ccc7CC0x2y83efgEv
  virtual void  abc(); // _ZN3ccc7CC0x2y83abcEv
  ~CC0x2y8(); // tgen
  CC0x2y8(); // tgen
};
//SIG(1 _ZN3ccc7CC0x2y8E) C1{ BC2{ v2 v1 v3} BC3{ v1 v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x2y8 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x2y83efgEv");}
void  ccc::CC0x2y8 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x2y83abcEv");}
ccc::CC0x2y8 ::~CC0x2y8(){ note_dtor("_ZN3ccc7CC0x2y8E", this);} // tgen
ccc::CC0x2y8 ::CC0x2y8(){ note_ctor("_ZN3ccc7CC0x2y8E", this);} // tgen
}
static void Test__ZN3ccc7CC0x2y8E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x2y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x2y8E, buf);
    ::ccc::CC0x2y8 *dp, &lv = *(dp=new (buf) ::ccc::CC0x2y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x2y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x2y8E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x2y8E");
    check_base_class_offset(lv, (::ccc::BB2*), ABISELECT(8,4), "_ZN3ccc7CC0x2y8E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x2y8E);
    dp->::ccc::CC0x2y8::~CC0x2y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x2y8E(Test__ZN3ccc7CC0x2y8E, "_ZN3ccc7CC0x2y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x2y8C1Ev();
extern void _ZN3ccc7CC0x2y8D1Ev();
Name_Map name_map__ZN3ccc7CC0x2y8E[] = {
  NSPAIR(_ZN3ccc7CC0x2y8C1Ev),
  NSPAIR(_ZN3ccc7CC0x2y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB2E;
extern VTBL_ENTRY _ZTIN3ccc3BB2E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB2E[];
static Base_Class bases__ZN3ccc7CC0x2y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB2E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x2y8E[];
extern void _ZN3ccc7CC0x2y83abcEv();
extern void _ZN3ccc7CC0x2y83efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x2y83efgEv,_ZThn4_N3ccc7CC0x2y83efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x2y83abcEv,_ZThn4_N3ccc7CC0x2y83abcEv)();
extern void _ZN3ccc3BB23pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x2y8E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x2y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x2y83abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x2y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x2y8E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x2y83efgEv,_ZThn4_N3ccc7CC0x2y83efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x2y83abcEv,_ZThn4_N3ccc7CC0x2y83abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB23pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x2y8E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x2y8E[];
Class_Descriptor cd__ZN3ccc7CC0x2y8E = {  "_ZN3ccc7CC0x2y8E", // class name
  bases__ZN3ccc7CC0x2y8E, 2,
  &(vtc__ZN3ccc7CC0x2y8E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x2y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x2y8E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x2y9  : ::ccc::AA0 , ::ccc::BB2 {
  virtual void  efg(); // _ZN3ccc7CC0x2y93efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x2y93pqrEv
  ~CC0x2y9(); // tgen
  CC0x2y9(); // tgen
};
//SIG(1 _ZN3ccc7CC0x2y9E) C1{ BC2{ v3 v1 v2} BC3{ v1 v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x2y9 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x2y93efgEv");}
void  ccc::CC0x2y9 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x2y93pqrEv");}
ccc::CC0x2y9 ::~CC0x2y9(){ note_dtor("_ZN3ccc7CC0x2y9E", this);} // tgen
ccc::CC0x2y9 ::CC0x2y9(){ note_ctor("_ZN3ccc7CC0x2y9E", this);} // tgen
}
static void Test__ZN3ccc7CC0x2y9E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x2y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x2y9E, buf);
    ::ccc::CC0x2y9 *dp, &lv = *(dp=new (buf) ::ccc::CC0x2y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x2y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x2y9E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x2y9E");
    check_base_class_offset(lv, (::ccc::BB2*), ABISELECT(8,4), "_ZN3ccc7CC0x2y9E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x2y9E);
    dp->::ccc::CC0x2y9::~CC0x2y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x2y9E(Test__ZN3ccc7CC0x2y9E, "_ZN3ccc7CC0x2y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x2y9C1Ev();
extern void _ZN3ccc7CC0x2y9D1Ev();
Name_Map name_map__ZN3ccc7CC0x2y9E[] = {
  NSPAIR(_ZN3ccc7CC0x2y9C1Ev),
  NSPAIR(_ZN3ccc7CC0x2y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB2E;
extern VTBL_ENTRY _ZTIN3ccc3BB2E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB2E[];
static Base_Class bases__ZN3ccc7CC0x2y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB2E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x2y9E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc7CC0x2y93efgEv();
extern void _ZN3ccc7CC0x2y93pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x2y93efgEv,_ZThn4_N3ccc7CC0x2y93efgEv)();
extern void _ZN3ccc3BB23abcEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x2y93pqrEv,_ZThn4_N3ccc7CC0x2y93pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x2y9E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x2y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x2y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x2y93pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x2y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x2y93efgEv,_ZThn4_N3ccc7CC0x2y93efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB23abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x2y93pqrEv,_ZThn4_N3ccc7CC0x2y93pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x2y9E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x2y9E[];
Class_Descriptor cd__ZN3ccc7CC0x2y9E = {  "_ZN3ccc7CC0x2y9E", // class name
  bases__ZN3ccc7CC0x2y9E, 2,
  &(vtc__ZN3ccc7CC0x2y9E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x2y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x2y9E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x2y10  : ::ccc::AA0 , ::ccc::BB2 {
  virtual void  pqr(); // _ZN3ccc8CC0x2y103pqrEv
  virtual void  abc(); // _ZN3ccc8CC0x2y103abcEv
  ~CC0x2y10(); // tgen
  CC0x2y10(); // tgen
};
//SIG(1 _ZN3ccc8CC0x2y10E) C1{ BC2{ v2 v3 v1} BC3{ v4 v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x2y10 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x2y103pqrEv");}
void  ccc::CC0x2y10 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x2y103abcEv");}
ccc::CC0x2y10 ::~CC0x2y10(){ note_dtor("_ZN3ccc8CC0x2y10E", this);} // tgen
ccc::CC0x2y10 ::CC0x2y10(){ note_ctor("_ZN3ccc8CC0x2y10E", this);} // tgen
}
static void Test__ZN3ccc8CC0x2y10E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x2y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x2y10E, buf);
    ::ccc::CC0x2y10 *dp, &lv = *(dp=new (buf) ::ccc::CC0x2y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x2y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x2y10E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x2y10E");
    check_base_class_offset(lv, (::ccc::BB2*), ABISELECT(8,4), "_ZN3ccc8CC0x2y10E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x2y10E);
    dp->::ccc::CC0x2y10::~CC0x2y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x2y10E(Test__ZN3ccc8CC0x2y10E, "_ZN3ccc8CC0x2y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x2y10C1Ev();
extern void _ZN3ccc8CC0x2y10D1Ev();
Name_Map name_map__ZN3ccc8CC0x2y10E[] = {
  NSPAIR(_ZN3ccc8CC0x2y10C1Ev),
  NSPAIR(_ZN3ccc8CC0x2y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB2E;
extern VTBL_ENTRY _ZTIN3ccc3BB2E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB2E[];
static Base_Class bases__ZN3ccc8CC0x2y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB2E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x2y10E[];
extern void _ZN3ccc8CC0x2y103abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc8CC0x2y103pqrEv();
extern void _ZN3ccc3BB23efgEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x2y103abcEv,_ZThn4_N3ccc8CC0x2y103abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC0x2y103pqrEv,_ZThn4_N3ccc8CC0x2y103pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x2y10E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x2y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x2y103abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x2y103pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x2y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB23efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x2y103abcEv,_ZThn4_N3ccc8CC0x2y103abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x2y103pqrEv,_ZThn4_N3ccc8CC0x2y103pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x2y10E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x2y10E[];
Class_Descriptor cd__ZN3ccc8CC0x2y10E = {  "_ZN3ccc8CC0x2y10E", // class name
  bases__ZN3ccc8CC0x2y10E, 2,
  &(vtc__ZN3ccc8CC0x2y10E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x2y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x2y10E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x2y11  : ::ccc::AA0 , ::ccc::BB2 {
  virtual void  pqr(); // _ZN3ccc8CC0x2y113pqrEv
  virtual void  efg(); // _ZN3ccc8CC0x2y113efgEv
  ~CC0x2y11(); // tgen
  CC0x2y11(); // tgen
};
//SIG(1 _ZN3ccc8CC0x2y11E) C1{ BC2{ v3 v2 v1} BC3{ v2 v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x2y11 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x2y113pqrEv");}
void  ccc::CC0x2y11 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x2y113efgEv");}
ccc::CC0x2y11 ::~CC0x2y11(){ note_dtor("_ZN3ccc8CC0x2y11E", this);} // tgen
ccc::CC0x2y11 ::CC0x2y11(){ note_ctor("_ZN3ccc8CC0x2y11E", this);} // tgen
}
static void Test__ZN3ccc8CC0x2y11E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x2y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x2y11E, buf);
    ::ccc::CC0x2y11 *dp, &lv = *(dp=new (buf) ::ccc::CC0x2y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x2y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x2y11E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x2y11E");
    check_base_class_offset(lv, (::ccc::BB2*), ABISELECT(8,4), "_ZN3ccc8CC0x2y11E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x2y11E);
    dp->::ccc::CC0x2y11::~CC0x2y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x2y11E(Test__ZN3ccc8CC0x2y11E, "_ZN3ccc8CC0x2y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x2y11C1Ev();
extern void _ZN3ccc8CC0x2y11D1Ev();
Name_Map name_map__ZN3ccc8CC0x2y11E[] = {
  NSPAIR(_ZN3ccc8CC0x2y11C1Ev),
  NSPAIR(_ZN3ccc8CC0x2y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB2E;
extern VTBL_ENTRY _ZTIN3ccc3BB2E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB2E[];
static Base_Class bases__ZN3ccc8CC0x2y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB2E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x2y11E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc8CC0x2y113efgEv();
extern void _ZN3ccc8CC0x2y113pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x2y113efgEv,_ZThn4_N3ccc8CC0x2y113efgEv)();
extern void _ZN3ccc3BB23abcEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x2y113pqrEv,_ZThn4_N3ccc8CC0x2y113pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x2y11E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x2y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x2y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x2y113pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x2y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x2y113efgEv,_ZThn4_N3ccc8CC0x2y113efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB23abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x2y113pqrEv,_ZThn4_N3ccc8CC0x2y113pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x2y11E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x2y11E[];
Class_Descriptor cd__ZN3ccc8CC0x2y11E = {  "_ZN3ccc8CC0x2y11E", // class name
  bases__ZN3ccc8CC0x2y11E, 2,
  &(vtc__ZN3ccc8CC0x2y11E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x2y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x2y11E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x2y12  : ::ccc::AA0 , ::ccc::BB2 {
  virtual void  abc(); // _ZN3ccc8CC0x2y123abcEv
  ~CC0x2y12(); // tgen
  CC0x2y12(); // tgen
};
//SIG(1 _ZN3ccc8CC0x2y12E) C1{ BC2{ v1 v2 v3} BC3{ v4 v1 v5} v1}
}
namespace ccc { 
void  ccc::CC0x2y12 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x2y123abcEv");}
ccc::CC0x2y12 ::~CC0x2y12(){ note_dtor("_ZN3ccc8CC0x2y12E", this);} // tgen
ccc::CC0x2y12 ::CC0x2y12(){ note_ctor("_ZN3ccc8CC0x2y12E", this);} // tgen
}
static void Test__ZN3ccc8CC0x2y12E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x2y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x2y12E, buf);
    ::ccc::CC0x2y12 *dp, &lv = *(dp=new (buf) ::ccc::CC0x2y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x2y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x2y12E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x2y12E");
    check_base_class_offset(lv, (::ccc::BB2*), ABISELECT(8,4), "_ZN3ccc8CC0x2y12E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x2y12E);
    dp->::ccc::CC0x2y12::~CC0x2y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x2y12E(Test__ZN3ccc8CC0x2y12E, "_ZN3ccc8CC0x2y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x2y12C1Ev();
extern void _ZN3ccc8CC0x2y12D1Ev();
Name_Map name_map__ZN3ccc8CC0x2y12E[] = {
  NSPAIR(_ZN3ccc8CC0x2y12C1Ev),
  NSPAIR(_ZN3ccc8CC0x2y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB2E;
extern VTBL_ENTRY _ZTIN3ccc3BB2E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB2E[];
static Base_Class bases__ZN3ccc8CC0x2y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB2E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x2y12E[];
extern void _ZN3ccc8CC0x2y123abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc3BB23efgEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x2y123abcEv,_ZThn4_N3ccc8CC0x2y123abcEv)();
extern void _ZN3ccc3BB23pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x2y12E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x2y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x2y123abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x2y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB23efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x2y123abcEv,_ZThn4_N3ccc8CC0x2y123abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB23pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x2y12E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x2y12E[];
Class_Descriptor cd__ZN3ccc8CC0x2y12E = {  "_ZN3ccc8CC0x2y12E", // class name
  bases__ZN3ccc8CC0x2y12E, 2,
  &(vtc__ZN3ccc8CC0x2y12E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x2y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x2y12E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x2y13  : ::ccc::AA0 , ::ccc::BB2 {
  virtual void  efg(); // _ZN3ccc8CC0x2y133efgEv
  ~CC0x2y13(); // tgen
  CC0x2y13(); // tgen
};
//SIG(1 _ZN3ccc8CC0x2y13E) C1{ BC2{ v2 v1 v3} BC3{ v1 v4 v5} v1}
}
namespace ccc { 
void  ccc::CC0x2y13 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x2y133efgEv");}
ccc::CC0x2y13 ::~CC0x2y13(){ note_dtor("_ZN3ccc8CC0x2y13E", this);} // tgen
ccc::CC0x2y13 ::CC0x2y13(){ note_ctor("_ZN3ccc8CC0x2y13E", this);} // tgen
}
static void Test__ZN3ccc8CC0x2y13E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x2y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x2y13E, buf);
    ::ccc::CC0x2y13 *dp, &lv = *(dp=new (buf) ::ccc::CC0x2y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x2y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x2y13E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x2y13E");
    check_base_class_offset(lv, (::ccc::BB2*), ABISELECT(8,4), "_ZN3ccc8CC0x2y13E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x2y13E);
    dp->::ccc::CC0x2y13::~CC0x2y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x2y13E(Test__ZN3ccc8CC0x2y13E, "_ZN3ccc8CC0x2y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x2y13C1Ev();
extern void _ZN3ccc8CC0x2y13D1Ev();
Name_Map name_map__ZN3ccc8CC0x2y13E[] = {
  NSPAIR(_ZN3ccc8CC0x2y13C1Ev),
  NSPAIR(_ZN3ccc8CC0x2y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB2E;
extern VTBL_ENTRY _ZTIN3ccc3BB2E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB2E[];
static Base_Class bases__ZN3ccc8CC0x2y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB2E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x2y13E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc8CC0x2y133efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x2y133efgEv,_ZThn4_N3ccc8CC0x2y133efgEv)();
extern void _ZN3ccc3BB23abcEv();
extern void _ZN3ccc3BB23pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x2y13E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x2y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x2y133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x2y13E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x2y133efgEv,_ZThn4_N3ccc8CC0x2y133efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB23abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB23pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x2y13E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x2y13E[];
Class_Descriptor cd__ZN3ccc8CC0x2y13E = {  "_ZN3ccc8CC0x2y13E", // class name
  bases__ZN3ccc8CC0x2y13E, 2,
  &(vtc__ZN3ccc8CC0x2y13E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x2y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x2y13E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x2y14  : ::ccc::AA0 , ::ccc::BB2 {
  virtual void  pqr(); // _ZN3ccc8CC0x2y143pqrEv
  ~CC0x2y14(); // tgen
  CC0x2y14(); // tgen
};
//SIG(1 _ZN3ccc8CC0x2y14E) C1{ BC2{ v2 v3 v1} BC3{ v4 v5 v1} v1}
}
namespace ccc { 
void  ccc::CC0x2y14 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x2y143pqrEv");}
ccc::CC0x2y14 ::~CC0x2y14(){ note_dtor("_ZN3ccc8CC0x2y14E", this);} // tgen
ccc::CC0x2y14 ::CC0x2y14(){ note_ctor("_ZN3ccc8CC0x2y14E", this);} // tgen
}
static void Test__ZN3ccc8CC0x2y14E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x2y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x2y14E, buf);
    ::ccc::CC0x2y14 *dp, &lv = *(dp=new (buf) ::ccc::CC0x2y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x2y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x2y14E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x2y14E");
    check_base_class_offset(lv, (::ccc::BB2*), ABISELECT(8,4), "_ZN3ccc8CC0x2y14E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x2y14E);
    dp->::ccc::CC0x2y14::~CC0x2y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x2y14E(Test__ZN3ccc8CC0x2y14E, "_ZN3ccc8CC0x2y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x2y14C1Ev();
extern void _ZN3ccc8CC0x2y14D1Ev();
Name_Map name_map__ZN3ccc8CC0x2y14E[] = {
  NSPAIR(_ZN3ccc8CC0x2y14C1Ev),
  NSPAIR(_ZN3ccc8CC0x2y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB2E;
extern VTBL_ENTRY _ZTIN3ccc3BB2E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB2E[];
static Base_Class bases__ZN3ccc8CC0x2y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB2E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x2y14E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc8CC0x2y143pqrEv();
extern void _ZN3ccc3BB23efgEv();
extern void _ZN3ccc3BB23abcEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x2y143pqrEv,_ZThn4_N3ccc8CC0x2y143pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x2y14E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x2y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x2y143pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x2y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB23efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB23abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x2y143pqrEv,_ZThn4_N3ccc8CC0x2y143pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x2y14E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x2y14E[];
Class_Descriptor cd__ZN3ccc8CC0x2y14E = {  "_ZN3ccc8CC0x2y14E", // class name
  bases__ZN3ccc8CC0x2y14E, 2,
  &(vtc__ZN3ccc8CC0x2y14E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x2y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x2y14E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x2y15  : ::ccc::AA0 , ::ccc::BB2 {
  ~CC0x2y15(); // tgen
  CC0x2y15(); // tgen
};
//SIG(1 _ZN3ccc8CC0x2y15E) C1{ BC2{ v1 v2 v3} BC3{ v4 v5 v6}}
}
namespace ccc { 
ccc::CC0x2y15 ::~CC0x2y15(){ note_dtor("_ZN3ccc8CC0x2y15E", this);} // tgen
ccc::CC0x2y15 ::CC0x2y15(){ note_ctor("_ZN3ccc8CC0x2y15E", this);} // tgen
}
static void Test__ZN3ccc8CC0x2y15E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x2y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x2y15E, buf);
    ::ccc::CC0x2y15 *dp, &lv = *(dp=new (buf) ::ccc::CC0x2y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x2y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x2y15E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x2y15E");
    check_base_class_offset(lv, (::ccc::BB2*), ABISELECT(8,4), "_ZN3ccc8CC0x2y15E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x2y15E);
    dp->::ccc::CC0x2y15::~CC0x2y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x2y15E(Test__ZN3ccc8CC0x2y15E, "_ZN3ccc8CC0x2y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x2y15C1Ev();
extern void _ZN3ccc8CC0x2y15D1Ev();
Name_Map name_map__ZN3ccc8CC0x2y15E[] = {
  NSPAIR(_ZN3ccc8CC0x2y15C1Ev),
  NSPAIR(_ZN3ccc8CC0x2y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB2E;
extern VTBL_ENTRY _ZTIN3ccc3BB2E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB2E[];
static Base_Class bases__ZN3ccc8CC0x2y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB2E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x2y15E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc3BB23efgEv();
extern void _ZN3ccc3BB23abcEv();
extern void _ZN3ccc3BB23pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x2y15E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x2y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x2y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB23efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB23abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB23pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x2y15E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x2y15E[];
Class_Descriptor cd__ZN3ccc8CC0x2y15E = {  "_ZN3ccc8CC0x2y15E", // class name
  bases__ZN3ccc8CC0x2y15E, 2,
  &(vtc__ZN3ccc8CC0x2y15E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x2y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x2y15E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x3y0  : ::ccc::AA0 , ::ccc::BB3 {
  virtual void  abc(); // _ZN3ccc7CC0x3y03abcEv
  virtual void  efg(); // _ZN3ccc7CC0x3y03efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x3y03pqrEv
  ~CC0x3y0(); // tgen
  CC0x3y0(); // tgen
};
//SIG(1 _ZN3ccc7CC0x3y0E) C1{ BC2{ v1 v2 v3} BC3{ v2 v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x3y0 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x3y03abcEv");}
void  ccc::CC0x3y0 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x3y03efgEv");}
void  ccc::CC0x3y0 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x3y03pqrEv");}
ccc::CC0x3y0 ::~CC0x3y0(){ note_dtor("_ZN3ccc7CC0x3y0E", this);} // tgen
ccc::CC0x3y0 ::CC0x3y0(){ note_ctor("_ZN3ccc7CC0x3y0E", this);} // tgen
}
static void Test__ZN3ccc7CC0x3y0E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x3y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x3y0E, buf);
    ::ccc::CC0x3y0 *dp, &lv = *(dp=new (buf) ::ccc::CC0x3y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x3y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x3y0E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x3y0E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc7CC0x3y0E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x3y0E);
    dp->::ccc::CC0x3y0::~CC0x3y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x3y0E(Test__ZN3ccc7CC0x3y0E, "_ZN3ccc7CC0x3y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x3y0C1Ev();
extern void _ZN3ccc7CC0x3y0D1Ev();
Name_Map name_map__ZN3ccc7CC0x3y0E[] = {
  NSPAIR(_ZN3ccc7CC0x3y0C1Ev),
  NSPAIR(_ZN3ccc7CC0x3y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc7CC0x3y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x3y0E[];
extern void _ZN3ccc7CC0x3y03abcEv();
extern void _ZN3ccc7CC0x3y03efgEv();
extern void _ZN3ccc7CC0x3y03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x3y03efgEv,_ZThn4_N3ccc7CC0x3y03efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x3y03pqrEv,_ZThn4_N3ccc7CC0x3y03pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x3y03abcEv,_ZThn4_N3ccc7CC0x3y03abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x3y0E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x3y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x3y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x3y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x3y03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x3y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x3y03efgEv,_ZThn4_N3ccc7CC0x3y03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x3y03pqrEv,_ZThn4_N3ccc7CC0x3y03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x3y03abcEv,_ZThn4_N3ccc7CC0x3y03abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x3y0E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x3y0E[];
Class_Descriptor cd__ZN3ccc7CC0x3y0E = {  "_ZN3ccc7CC0x3y0E", // class name
  bases__ZN3ccc7CC0x3y0E, 2,
  &(vtc__ZN3ccc7CC0x3y0E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x3y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x3y0E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x3y1  : ::ccc::AA0 , ::ccc::BB3 {
  virtual void  abc(); // _ZN3ccc7CC0x3y13abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x3y13pqrEv
  virtual void  efg(); // _ZN3ccc7CC0x3y13efgEv
  ~CC0x3y1(); // tgen
  CC0x3y1(); // tgen
};
//SIG(1 _ZN3ccc7CC0x3y1E) C1{ BC2{ v1 v3 v2} BC3{ v3 v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x3y1 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x3y13abcEv");}
void  ccc::CC0x3y1 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x3y13pqrEv");}
void  ccc::CC0x3y1 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x3y13efgEv");}
ccc::CC0x3y1 ::~CC0x3y1(){ note_dtor("_ZN3ccc7CC0x3y1E", this);} // tgen
ccc::CC0x3y1 ::CC0x3y1(){ note_ctor("_ZN3ccc7CC0x3y1E", this);} // tgen
}
static void Test__ZN3ccc7CC0x3y1E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x3y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x3y1E, buf);
    ::ccc::CC0x3y1 *dp, &lv = *(dp=new (buf) ::ccc::CC0x3y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x3y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x3y1E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x3y1E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc7CC0x3y1E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x3y1E);
    dp->::ccc::CC0x3y1::~CC0x3y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x3y1E(Test__ZN3ccc7CC0x3y1E, "_ZN3ccc7CC0x3y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x3y1C1Ev();
extern void _ZN3ccc7CC0x3y1D1Ev();
Name_Map name_map__ZN3ccc7CC0x3y1E[] = {
  NSPAIR(_ZN3ccc7CC0x3y1C1Ev),
  NSPAIR(_ZN3ccc7CC0x3y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc7CC0x3y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x3y1E[];
extern void _ZN3ccc7CC0x3y13abcEv();
extern void _ZN3ccc7CC0x3y13efgEv();
extern void _ZN3ccc7CC0x3y13pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x3y13efgEv,_ZThn4_N3ccc7CC0x3y13efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x3y13pqrEv,_ZThn4_N3ccc7CC0x3y13pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x3y13abcEv,_ZThn4_N3ccc7CC0x3y13abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x3y1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x3y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x3y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x3y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x3y13pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x3y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x3y13efgEv,_ZThn4_N3ccc7CC0x3y13efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x3y13pqrEv,_ZThn4_N3ccc7CC0x3y13pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x3y13abcEv,_ZThn4_N3ccc7CC0x3y13abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x3y1E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x3y1E[];
Class_Descriptor cd__ZN3ccc7CC0x3y1E = {  "_ZN3ccc7CC0x3y1E", // class name
  bases__ZN3ccc7CC0x3y1E, 2,
  &(vtc__ZN3ccc7CC0x3y1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x3y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x3y1E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x3y2  : ::ccc::AA0 , ::ccc::BB3 {
  virtual void  efg(); // _ZN3ccc7CC0x3y23efgEv
  virtual void  abc(); // _ZN3ccc7CC0x3y23abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x3y23pqrEv
  ~CC0x3y2(); // tgen
  CC0x3y2(); // tgen
};
//SIG(1 _ZN3ccc7CC0x3y2E) C1{ BC2{ v2 v1 v3} BC3{ v1 v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x3y2 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x3y23efgEv");}
void  ccc::CC0x3y2 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x3y23abcEv");}
void  ccc::CC0x3y2 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x3y23pqrEv");}
ccc::CC0x3y2 ::~CC0x3y2(){ note_dtor("_ZN3ccc7CC0x3y2E", this);} // tgen
ccc::CC0x3y2 ::CC0x3y2(){ note_ctor("_ZN3ccc7CC0x3y2E", this);} // tgen
}
static void Test__ZN3ccc7CC0x3y2E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x3y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x3y2E, buf);
    ::ccc::CC0x3y2 *dp, &lv = *(dp=new (buf) ::ccc::CC0x3y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x3y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x3y2E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x3y2E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc7CC0x3y2E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x3y2E);
    dp->::ccc::CC0x3y2::~CC0x3y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x3y2E(Test__ZN3ccc7CC0x3y2E, "_ZN3ccc7CC0x3y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x3y2C1Ev();
extern void _ZN3ccc7CC0x3y2D1Ev();
Name_Map name_map__ZN3ccc7CC0x3y2E[] = {
  NSPAIR(_ZN3ccc7CC0x3y2C1Ev),
  NSPAIR(_ZN3ccc7CC0x3y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc7CC0x3y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x3y2E[];
extern void _ZN3ccc7CC0x3y23abcEv();
extern void _ZN3ccc7CC0x3y23efgEv();
extern void _ZN3ccc7CC0x3y23pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x3y23efgEv,_ZThn4_N3ccc7CC0x3y23efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x3y23pqrEv,_ZThn4_N3ccc7CC0x3y23pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x3y23abcEv,_ZThn4_N3ccc7CC0x3y23abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x3y2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x3y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x3y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x3y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x3y23pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x3y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x3y23efgEv,_ZThn4_N3ccc7CC0x3y23efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x3y23pqrEv,_ZThn4_N3ccc7CC0x3y23pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x3y23abcEv,_ZThn4_N3ccc7CC0x3y23abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x3y2E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x3y2E[];
Class_Descriptor cd__ZN3ccc7CC0x3y2E = {  "_ZN3ccc7CC0x3y2E", // class name
  bases__ZN3ccc7CC0x3y2E, 2,
  &(vtc__ZN3ccc7CC0x3y2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x3y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x3y2E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x3y3  : ::ccc::AA0 , ::ccc::BB3 {
  virtual void  efg(); // _ZN3ccc7CC0x3y33efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x3y33pqrEv
  virtual void  abc(); // _ZN3ccc7CC0x3y33abcEv
  ~CC0x3y3(); // tgen
  CC0x3y3(); // tgen
};
//SIG(1 _ZN3ccc7CC0x3y3E) C1{ BC2{ v3 v1 v2} BC3{ v1 v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x3y3 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x3y33efgEv");}
void  ccc::CC0x3y3 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x3y33pqrEv");}
void  ccc::CC0x3y3 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x3y33abcEv");}
ccc::CC0x3y3 ::~CC0x3y3(){ note_dtor("_ZN3ccc7CC0x3y3E", this);} // tgen
ccc::CC0x3y3 ::CC0x3y3(){ note_ctor("_ZN3ccc7CC0x3y3E", this);} // tgen
}
static void Test__ZN3ccc7CC0x3y3E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x3y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x3y3E, buf);
    ::ccc::CC0x3y3 *dp, &lv = *(dp=new (buf) ::ccc::CC0x3y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x3y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x3y3E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x3y3E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc7CC0x3y3E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x3y3E);
    dp->::ccc::CC0x3y3::~CC0x3y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x3y3E(Test__ZN3ccc7CC0x3y3E, "_ZN3ccc7CC0x3y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x3y3C1Ev();
extern void _ZN3ccc7CC0x3y3D1Ev();
Name_Map name_map__ZN3ccc7CC0x3y3E[] = {
  NSPAIR(_ZN3ccc7CC0x3y3C1Ev),
  NSPAIR(_ZN3ccc7CC0x3y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc7CC0x3y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x3y3E[];
extern void _ZN3ccc7CC0x3y33abcEv();
extern void _ZN3ccc7CC0x3y33efgEv();
extern void _ZN3ccc7CC0x3y33pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x3y33efgEv,_ZThn4_N3ccc7CC0x3y33efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x3y33pqrEv,_ZThn4_N3ccc7CC0x3y33pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x3y33abcEv,_ZThn4_N3ccc7CC0x3y33abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x3y3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x3y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x3y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x3y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x3y33pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x3y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x3y33efgEv,_ZThn4_N3ccc7CC0x3y33efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x3y33pqrEv,_ZThn4_N3ccc7CC0x3y33pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x3y33abcEv,_ZThn4_N3ccc7CC0x3y33abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x3y3E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x3y3E[];
Class_Descriptor cd__ZN3ccc7CC0x3y3E = {  "_ZN3ccc7CC0x3y3E", // class name
  bases__ZN3ccc7CC0x3y3E, 2,
  &(vtc__ZN3ccc7CC0x3y3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x3y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x3y3E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x3y4  : ::ccc::AA0 , ::ccc::BB3 {
  virtual void  pqr(); // _ZN3ccc7CC0x3y43pqrEv
  virtual void  abc(); // _ZN3ccc7CC0x3y43abcEv
  virtual void  efg(); // _ZN3ccc7CC0x3y43efgEv
  ~CC0x3y4(); // tgen
  CC0x3y4(); // tgen
};
//SIG(1 _ZN3ccc7CC0x3y4E) C1{ BC2{ v2 v3 v1} BC3{ v3 v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x3y4 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x3y43pqrEv");}
void  ccc::CC0x3y4 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x3y43abcEv");}
void  ccc::CC0x3y4 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x3y43efgEv");}
ccc::CC0x3y4 ::~CC0x3y4(){ note_dtor("_ZN3ccc7CC0x3y4E", this);} // tgen
ccc::CC0x3y4 ::CC0x3y4(){ note_ctor("_ZN3ccc7CC0x3y4E", this);} // tgen
}
static void Test__ZN3ccc7CC0x3y4E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x3y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x3y4E, buf);
    ::ccc::CC0x3y4 *dp, &lv = *(dp=new (buf) ::ccc::CC0x3y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x3y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x3y4E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x3y4E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc7CC0x3y4E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x3y4E);
    dp->::ccc::CC0x3y4::~CC0x3y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x3y4E(Test__ZN3ccc7CC0x3y4E, "_ZN3ccc7CC0x3y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x3y4C1Ev();
extern void _ZN3ccc7CC0x3y4D1Ev();
Name_Map name_map__ZN3ccc7CC0x3y4E[] = {
  NSPAIR(_ZN3ccc7CC0x3y4C1Ev),
  NSPAIR(_ZN3ccc7CC0x3y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc7CC0x3y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x3y4E[];
extern void _ZN3ccc7CC0x3y43abcEv();
extern void _ZN3ccc7CC0x3y43efgEv();
extern void _ZN3ccc7CC0x3y43pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x3y43efgEv,_ZThn4_N3ccc7CC0x3y43efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x3y43pqrEv,_ZThn4_N3ccc7CC0x3y43pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x3y43abcEv,_ZThn4_N3ccc7CC0x3y43abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x3y4E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x3y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x3y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x3y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x3y43pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x3y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x3y43efgEv,_ZThn4_N3ccc7CC0x3y43efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x3y43pqrEv,_ZThn4_N3ccc7CC0x3y43pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x3y43abcEv,_ZThn4_N3ccc7CC0x3y43abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x3y4E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x3y4E[];
Class_Descriptor cd__ZN3ccc7CC0x3y4E = {  "_ZN3ccc7CC0x3y4E", // class name
  bases__ZN3ccc7CC0x3y4E, 2,
  &(vtc__ZN3ccc7CC0x3y4E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x3y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x3y4E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x3y5  : ::ccc::AA0 , ::ccc::BB3 {
  virtual void  pqr(); // _ZN3ccc7CC0x3y53pqrEv
  virtual void  efg(); // _ZN3ccc7CC0x3y53efgEv
  virtual void  abc(); // _ZN3ccc7CC0x3y53abcEv
  ~CC0x3y5(); // tgen
  CC0x3y5(); // tgen
};
//SIG(1 _ZN3ccc7CC0x3y5E) C1{ BC2{ v3 v2 v1} BC3{ v2 v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x3y5 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x3y53pqrEv");}
void  ccc::CC0x3y5 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x3y53efgEv");}
void  ccc::CC0x3y5 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x3y53abcEv");}
ccc::CC0x3y5 ::~CC0x3y5(){ note_dtor("_ZN3ccc7CC0x3y5E", this);} // tgen
ccc::CC0x3y5 ::CC0x3y5(){ note_ctor("_ZN3ccc7CC0x3y5E", this);} // tgen
}
static void Test__ZN3ccc7CC0x3y5E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x3y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x3y5E, buf);
    ::ccc::CC0x3y5 *dp, &lv = *(dp=new (buf) ::ccc::CC0x3y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x3y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x3y5E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x3y5E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc7CC0x3y5E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x3y5E);
    dp->::ccc::CC0x3y5::~CC0x3y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x3y5E(Test__ZN3ccc7CC0x3y5E, "_ZN3ccc7CC0x3y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x3y5C1Ev();
extern void _ZN3ccc7CC0x3y5D1Ev();
Name_Map name_map__ZN3ccc7CC0x3y5E[] = {
  NSPAIR(_ZN3ccc7CC0x3y5C1Ev),
  NSPAIR(_ZN3ccc7CC0x3y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc7CC0x3y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x3y5E[];
extern void _ZN3ccc7CC0x3y53abcEv();
extern void _ZN3ccc7CC0x3y53efgEv();
extern void _ZN3ccc7CC0x3y53pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x3y53efgEv,_ZThn4_N3ccc7CC0x3y53efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x3y53pqrEv,_ZThn4_N3ccc7CC0x3y53pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x3y53abcEv,_ZThn4_N3ccc7CC0x3y53abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x3y5E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x3y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x3y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x3y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x3y53pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x3y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x3y53efgEv,_ZThn4_N3ccc7CC0x3y53efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x3y53pqrEv,_ZThn4_N3ccc7CC0x3y53pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x3y53abcEv,_ZThn4_N3ccc7CC0x3y53abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x3y5E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x3y5E[];
Class_Descriptor cd__ZN3ccc7CC0x3y5E = {  "_ZN3ccc7CC0x3y5E", // class name
  bases__ZN3ccc7CC0x3y5E, 2,
  &(vtc__ZN3ccc7CC0x3y5E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x3y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x3y5E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x3y6  : ::ccc::AA0 , ::ccc::BB3 {
  virtual void  abc(); // _ZN3ccc7CC0x3y63abcEv
  virtual void  efg(); // _ZN3ccc7CC0x3y63efgEv
  ~CC0x3y6(); // tgen
  CC0x3y6(); // tgen
};
//SIG(1 _ZN3ccc7CC0x3y6E) C1{ BC2{ v1 v2 v3} BC3{ v2 v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x3y6 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x3y63abcEv");}
void  ccc::CC0x3y6 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x3y63efgEv");}
ccc::CC0x3y6 ::~CC0x3y6(){ note_dtor("_ZN3ccc7CC0x3y6E", this);} // tgen
ccc::CC0x3y6 ::CC0x3y6(){ note_ctor("_ZN3ccc7CC0x3y6E", this);} // tgen
}
static void Test__ZN3ccc7CC0x3y6E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x3y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x3y6E, buf);
    ::ccc::CC0x3y6 *dp, &lv = *(dp=new (buf) ::ccc::CC0x3y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x3y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x3y6E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x3y6E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc7CC0x3y6E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x3y6E);
    dp->::ccc::CC0x3y6::~CC0x3y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x3y6E(Test__ZN3ccc7CC0x3y6E, "_ZN3ccc7CC0x3y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x3y6C1Ev();
extern void _ZN3ccc7CC0x3y6D1Ev();
Name_Map name_map__ZN3ccc7CC0x3y6E[] = {
  NSPAIR(_ZN3ccc7CC0x3y6C1Ev),
  NSPAIR(_ZN3ccc7CC0x3y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc7CC0x3y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x3y6E[];
extern void _ZN3ccc7CC0x3y63abcEv();
extern void _ZN3ccc7CC0x3y63efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x3y63efgEv,_ZThn4_N3ccc7CC0x3y63efgEv)();
extern void _ZN3ccc3BB33pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x3y63abcEv,_ZThn4_N3ccc7CC0x3y63abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x3y6E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x3y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x3y63abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x3y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x3y6E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x3y63efgEv,_ZThn4_N3ccc7CC0x3y63efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB33pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x3y63abcEv,_ZThn4_N3ccc7CC0x3y63abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x3y6E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x3y6E[];
Class_Descriptor cd__ZN3ccc7CC0x3y6E = {  "_ZN3ccc7CC0x3y6E", // class name
  bases__ZN3ccc7CC0x3y6E, 2,
  &(vtc__ZN3ccc7CC0x3y6E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x3y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x3y6E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x3y7  : ::ccc::AA0 , ::ccc::BB3 {
  virtual void  abc(); // _ZN3ccc7CC0x3y73abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x3y73pqrEv
  ~CC0x3y7(); // tgen
  CC0x3y7(); // tgen
};
//SIG(1 _ZN3ccc7CC0x3y7E) C1{ BC2{ v1 v3 v2} BC3{ v4 v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x3y7 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x3y73abcEv");}
void  ccc::CC0x3y7 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x3y73pqrEv");}
ccc::CC0x3y7 ::~CC0x3y7(){ note_dtor("_ZN3ccc7CC0x3y7E", this);} // tgen
ccc::CC0x3y7 ::CC0x3y7(){ note_ctor("_ZN3ccc7CC0x3y7E", this);} // tgen
}
static void Test__ZN3ccc7CC0x3y7E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x3y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x3y7E, buf);
    ::ccc::CC0x3y7 *dp, &lv = *(dp=new (buf) ::ccc::CC0x3y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x3y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x3y7E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x3y7E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc7CC0x3y7E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x3y7E);
    dp->::ccc::CC0x3y7::~CC0x3y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x3y7E(Test__ZN3ccc7CC0x3y7E, "_ZN3ccc7CC0x3y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x3y7C1Ev();
extern void _ZN3ccc7CC0x3y7D1Ev();
Name_Map name_map__ZN3ccc7CC0x3y7E[] = {
  NSPAIR(_ZN3ccc7CC0x3y7C1Ev),
  NSPAIR(_ZN3ccc7CC0x3y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc7CC0x3y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x3y7E[];
extern void _ZN3ccc7CC0x3y73abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc7CC0x3y73pqrEv();
extern void _ZN3ccc3BB33efgEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x3y73pqrEv,_ZThn4_N3ccc7CC0x3y73pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x3y73abcEv,_ZThn4_N3ccc7CC0x3y73abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x3y7E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x3y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x3y73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x3y73pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x3y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB33efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x3y73pqrEv,_ZThn4_N3ccc7CC0x3y73pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x3y73abcEv,_ZThn4_N3ccc7CC0x3y73abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x3y7E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x3y7E[];
Class_Descriptor cd__ZN3ccc7CC0x3y7E = {  "_ZN3ccc7CC0x3y7E", // class name
  bases__ZN3ccc7CC0x3y7E, 2,
  &(vtc__ZN3ccc7CC0x3y7E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x3y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x3y7E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x3y8  : ::ccc::AA0 , ::ccc::BB3 {
  virtual void  efg(); // _ZN3ccc7CC0x3y83efgEv
  virtual void  abc(); // _ZN3ccc7CC0x3y83abcEv
  ~CC0x3y8(); // tgen
  CC0x3y8(); // tgen
};
//SIG(1 _ZN3ccc7CC0x3y8E) C1{ BC2{ v2 v1 v3} BC3{ v1 v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x3y8 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x3y83efgEv");}
void  ccc::CC0x3y8 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x3y83abcEv");}
ccc::CC0x3y8 ::~CC0x3y8(){ note_dtor("_ZN3ccc7CC0x3y8E", this);} // tgen
ccc::CC0x3y8 ::CC0x3y8(){ note_ctor("_ZN3ccc7CC0x3y8E", this);} // tgen
}
static void Test__ZN3ccc7CC0x3y8E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x3y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x3y8E, buf);
    ::ccc::CC0x3y8 *dp, &lv = *(dp=new (buf) ::ccc::CC0x3y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x3y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x3y8E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x3y8E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc7CC0x3y8E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x3y8E);
    dp->::ccc::CC0x3y8::~CC0x3y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x3y8E(Test__ZN3ccc7CC0x3y8E, "_ZN3ccc7CC0x3y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x3y8C1Ev();
extern void _ZN3ccc7CC0x3y8D1Ev();
Name_Map name_map__ZN3ccc7CC0x3y8E[] = {
  NSPAIR(_ZN3ccc7CC0x3y8C1Ev),
  NSPAIR(_ZN3ccc7CC0x3y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc7CC0x3y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x3y8E[];
extern void _ZN3ccc7CC0x3y83abcEv();
extern void _ZN3ccc7CC0x3y83efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x3y83efgEv,_ZThn4_N3ccc7CC0x3y83efgEv)();
extern void _ZN3ccc3BB33pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x3y83abcEv,_ZThn4_N3ccc7CC0x3y83abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x3y8E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x3y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x3y83abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x3y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x3y8E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x3y83efgEv,_ZThn4_N3ccc7CC0x3y83efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB33pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x3y83abcEv,_ZThn4_N3ccc7CC0x3y83abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x3y8E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x3y8E[];
Class_Descriptor cd__ZN3ccc7CC0x3y8E = {  "_ZN3ccc7CC0x3y8E", // class name
  bases__ZN3ccc7CC0x3y8E, 2,
  &(vtc__ZN3ccc7CC0x3y8E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x3y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x3y8E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x3y9  : ::ccc::AA0 , ::ccc::BB3 {
  virtual void  efg(); // _ZN3ccc7CC0x3y93efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x3y93pqrEv
  ~CC0x3y9(); // tgen
  CC0x3y9(); // tgen
};
//SIG(1 _ZN3ccc7CC0x3y9E) C1{ BC2{ v3 v1 v2} BC3{ v1 v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x3y9 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x3y93efgEv");}
void  ccc::CC0x3y9 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x3y93pqrEv");}
ccc::CC0x3y9 ::~CC0x3y9(){ note_dtor("_ZN3ccc7CC0x3y9E", this);} // tgen
ccc::CC0x3y9 ::CC0x3y9(){ note_ctor("_ZN3ccc7CC0x3y9E", this);} // tgen
}
static void Test__ZN3ccc7CC0x3y9E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x3y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x3y9E, buf);
    ::ccc::CC0x3y9 *dp, &lv = *(dp=new (buf) ::ccc::CC0x3y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x3y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x3y9E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x3y9E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc7CC0x3y9E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x3y9E);
    dp->::ccc::CC0x3y9::~CC0x3y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x3y9E(Test__ZN3ccc7CC0x3y9E, "_ZN3ccc7CC0x3y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x3y9C1Ev();
extern void _ZN3ccc7CC0x3y9D1Ev();
Name_Map name_map__ZN3ccc7CC0x3y9E[] = {
  NSPAIR(_ZN3ccc7CC0x3y9C1Ev),
  NSPAIR(_ZN3ccc7CC0x3y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc7CC0x3y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x3y9E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc7CC0x3y93efgEv();
extern void _ZN3ccc7CC0x3y93pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x3y93efgEv,_ZThn4_N3ccc7CC0x3y93efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x3y93pqrEv,_ZThn4_N3ccc7CC0x3y93pqrEv)();
extern void _ZN3ccc3BB33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x3y9E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x3y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x3y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x3y93pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x3y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x3y93efgEv,_ZThn4_N3ccc7CC0x3y93efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x3y93pqrEv,_ZThn4_N3ccc7CC0x3y93pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3BB33abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x3y9E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x3y9E[];
Class_Descriptor cd__ZN3ccc7CC0x3y9E = {  "_ZN3ccc7CC0x3y9E", // class name
  bases__ZN3ccc7CC0x3y9E, 2,
  &(vtc__ZN3ccc7CC0x3y9E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x3y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x3y9E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x3y10  : ::ccc::AA0 , ::ccc::BB3 {
  virtual void  pqr(); // _ZN3ccc8CC0x3y103pqrEv
  virtual void  abc(); // _ZN3ccc8CC0x3y103abcEv
  ~CC0x3y10(); // tgen
  CC0x3y10(); // tgen
};
//SIG(1 _ZN3ccc8CC0x3y10E) C1{ BC2{ v2 v3 v1} BC3{ v4 v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x3y10 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x3y103pqrEv");}
void  ccc::CC0x3y10 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x3y103abcEv");}
ccc::CC0x3y10 ::~CC0x3y10(){ note_dtor("_ZN3ccc8CC0x3y10E", this);} // tgen
ccc::CC0x3y10 ::CC0x3y10(){ note_ctor("_ZN3ccc8CC0x3y10E", this);} // tgen
}
static void Test__ZN3ccc8CC0x3y10E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x3y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x3y10E, buf);
    ::ccc::CC0x3y10 *dp, &lv = *(dp=new (buf) ::ccc::CC0x3y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x3y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x3y10E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x3y10E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc8CC0x3y10E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x3y10E);
    dp->::ccc::CC0x3y10::~CC0x3y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x3y10E(Test__ZN3ccc8CC0x3y10E, "_ZN3ccc8CC0x3y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x3y10C1Ev();
extern void _ZN3ccc8CC0x3y10D1Ev();
Name_Map name_map__ZN3ccc8CC0x3y10E[] = {
  NSPAIR(_ZN3ccc8CC0x3y10C1Ev),
  NSPAIR(_ZN3ccc8CC0x3y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc8CC0x3y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x3y10E[];
extern void _ZN3ccc8CC0x3y103abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc8CC0x3y103pqrEv();
extern void _ZN3ccc3BB33efgEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x3y103pqrEv,_ZThn4_N3ccc8CC0x3y103pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC0x3y103abcEv,_ZThn4_N3ccc8CC0x3y103abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x3y10E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x3y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x3y103abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x3y103pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x3y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB33efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x3y103pqrEv,_ZThn4_N3ccc8CC0x3y103pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x3y103abcEv,_ZThn4_N3ccc8CC0x3y103abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x3y10E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x3y10E[];
Class_Descriptor cd__ZN3ccc8CC0x3y10E = {  "_ZN3ccc8CC0x3y10E", // class name
  bases__ZN3ccc8CC0x3y10E, 2,
  &(vtc__ZN3ccc8CC0x3y10E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x3y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x3y10E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x3y11  : ::ccc::AA0 , ::ccc::BB3 {
  virtual void  pqr(); // _ZN3ccc8CC0x3y113pqrEv
  virtual void  efg(); // _ZN3ccc8CC0x3y113efgEv
  ~CC0x3y11(); // tgen
  CC0x3y11(); // tgen
};
//SIG(1 _ZN3ccc8CC0x3y11E) C1{ BC2{ v3 v2 v1} BC3{ v2 v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x3y11 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x3y113pqrEv");}
void  ccc::CC0x3y11 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x3y113efgEv");}
ccc::CC0x3y11 ::~CC0x3y11(){ note_dtor("_ZN3ccc8CC0x3y11E", this);} // tgen
ccc::CC0x3y11 ::CC0x3y11(){ note_ctor("_ZN3ccc8CC0x3y11E", this);} // tgen
}
static void Test__ZN3ccc8CC0x3y11E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x3y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x3y11E, buf);
    ::ccc::CC0x3y11 *dp, &lv = *(dp=new (buf) ::ccc::CC0x3y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x3y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x3y11E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x3y11E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc8CC0x3y11E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x3y11E);
    dp->::ccc::CC0x3y11::~CC0x3y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x3y11E(Test__ZN3ccc8CC0x3y11E, "_ZN3ccc8CC0x3y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x3y11C1Ev();
extern void _ZN3ccc8CC0x3y11D1Ev();
Name_Map name_map__ZN3ccc8CC0x3y11E[] = {
  NSPAIR(_ZN3ccc8CC0x3y11C1Ev),
  NSPAIR(_ZN3ccc8CC0x3y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc8CC0x3y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x3y11E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc8CC0x3y113efgEv();
extern void _ZN3ccc8CC0x3y113pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x3y113efgEv,_ZThn4_N3ccc8CC0x3y113efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC0x3y113pqrEv,_ZThn4_N3ccc8CC0x3y113pqrEv)();
extern void _ZN3ccc3BB33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x3y11E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x3y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x3y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x3y113pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x3y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x3y113efgEv,_ZThn4_N3ccc8CC0x3y113efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x3y113pqrEv,_ZThn4_N3ccc8CC0x3y113pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3BB33abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x3y11E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x3y11E[];
Class_Descriptor cd__ZN3ccc8CC0x3y11E = {  "_ZN3ccc8CC0x3y11E", // class name
  bases__ZN3ccc8CC0x3y11E, 2,
  &(vtc__ZN3ccc8CC0x3y11E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x3y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x3y11E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x3y12  : ::ccc::AA0 , ::ccc::BB3 {
  virtual void  abc(); // _ZN3ccc8CC0x3y123abcEv
  ~CC0x3y12(); // tgen
  CC0x3y12(); // tgen
};
//SIG(1 _ZN3ccc8CC0x3y12E) C1{ BC2{ v1 v2 v3} BC3{ v4 v5 v1} v1}
}
namespace ccc { 
void  ccc::CC0x3y12 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x3y123abcEv");}
ccc::CC0x3y12 ::~CC0x3y12(){ note_dtor("_ZN3ccc8CC0x3y12E", this);} // tgen
ccc::CC0x3y12 ::CC0x3y12(){ note_ctor("_ZN3ccc8CC0x3y12E", this);} // tgen
}
static void Test__ZN3ccc8CC0x3y12E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x3y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x3y12E, buf);
    ::ccc::CC0x3y12 *dp, &lv = *(dp=new (buf) ::ccc::CC0x3y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x3y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x3y12E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x3y12E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc8CC0x3y12E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x3y12E);
    dp->::ccc::CC0x3y12::~CC0x3y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x3y12E(Test__ZN3ccc8CC0x3y12E, "_ZN3ccc8CC0x3y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x3y12C1Ev();
extern void _ZN3ccc8CC0x3y12D1Ev();
Name_Map name_map__ZN3ccc8CC0x3y12E[] = {
  NSPAIR(_ZN3ccc8CC0x3y12C1Ev),
  NSPAIR(_ZN3ccc8CC0x3y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc8CC0x3y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x3y12E[];
extern void _ZN3ccc8CC0x3y123abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc3BB33efgEv();
extern void _ZN3ccc3BB33pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x3y123abcEv,_ZThn4_N3ccc8CC0x3y123abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x3y12E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x3y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x3y123abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x3y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB33efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB33pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x3y123abcEv,_ZThn4_N3ccc8CC0x3y123abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x3y12E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x3y12E[];
Class_Descriptor cd__ZN3ccc8CC0x3y12E = {  "_ZN3ccc8CC0x3y12E", // class name
  bases__ZN3ccc8CC0x3y12E, 2,
  &(vtc__ZN3ccc8CC0x3y12E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x3y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x3y12E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x3y13  : ::ccc::AA0 , ::ccc::BB3 {
  virtual void  efg(); // _ZN3ccc8CC0x3y133efgEv
  ~CC0x3y13(); // tgen
  CC0x3y13(); // tgen
};
//SIG(1 _ZN3ccc8CC0x3y13E) C1{ BC2{ v2 v1 v3} BC3{ v1 v4 v5} v1}
}
namespace ccc { 
void  ccc::CC0x3y13 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x3y133efgEv");}
ccc::CC0x3y13 ::~CC0x3y13(){ note_dtor("_ZN3ccc8CC0x3y13E", this);} // tgen
ccc::CC0x3y13 ::CC0x3y13(){ note_ctor("_ZN3ccc8CC0x3y13E", this);} // tgen
}
static void Test__ZN3ccc8CC0x3y13E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x3y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x3y13E, buf);
    ::ccc::CC0x3y13 *dp, &lv = *(dp=new (buf) ::ccc::CC0x3y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x3y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x3y13E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x3y13E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc8CC0x3y13E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x3y13E);
    dp->::ccc::CC0x3y13::~CC0x3y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x3y13E(Test__ZN3ccc8CC0x3y13E, "_ZN3ccc8CC0x3y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x3y13C1Ev();
extern void _ZN3ccc8CC0x3y13D1Ev();
Name_Map name_map__ZN3ccc8CC0x3y13E[] = {
  NSPAIR(_ZN3ccc8CC0x3y13C1Ev),
  NSPAIR(_ZN3ccc8CC0x3y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc8CC0x3y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x3y13E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc8CC0x3y133efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x3y133efgEv,_ZThn4_N3ccc8CC0x3y133efgEv)();
extern void _ZN3ccc3BB33pqrEv();
extern void _ZN3ccc3BB33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x3y13E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x3y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x3y133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x3y13E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x3y133efgEv,_ZThn4_N3ccc8CC0x3y133efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB33abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x3y13E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x3y13E[];
Class_Descriptor cd__ZN3ccc8CC0x3y13E = {  "_ZN3ccc8CC0x3y13E", // class name
  bases__ZN3ccc8CC0x3y13E, 2,
  &(vtc__ZN3ccc8CC0x3y13E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x3y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x3y13E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x3y14  : ::ccc::AA0 , ::ccc::BB3 {
  virtual void  pqr(); // _ZN3ccc8CC0x3y143pqrEv
  ~CC0x3y14(); // tgen
  CC0x3y14(); // tgen
};
//SIG(1 _ZN3ccc8CC0x3y14E) C1{ BC2{ v2 v3 v1} BC3{ v4 v1 v5} v1}
}
namespace ccc { 
void  ccc::CC0x3y14 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x3y143pqrEv");}
ccc::CC0x3y14 ::~CC0x3y14(){ note_dtor("_ZN3ccc8CC0x3y14E", this);} // tgen
ccc::CC0x3y14 ::CC0x3y14(){ note_ctor("_ZN3ccc8CC0x3y14E", this);} // tgen
}
static void Test__ZN3ccc8CC0x3y14E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x3y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x3y14E, buf);
    ::ccc::CC0x3y14 *dp, &lv = *(dp=new (buf) ::ccc::CC0x3y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x3y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x3y14E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x3y14E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc8CC0x3y14E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x3y14E);
    dp->::ccc::CC0x3y14::~CC0x3y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x3y14E(Test__ZN3ccc8CC0x3y14E, "_ZN3ccc8CC0x3y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x3y14C1Ev();
extern void _ZN3ccc8CC0x3y14D1Ev();
Name_Map name_map__ZN3ccc8CC0x3y14E[] = {
  NSPAIR(_ZN3ccc8CC0x3y14C1Ev),
  NSPAIR(_ZN3ccc8CC0x3y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc8CC0x3y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x3y14E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc8CC0x3y143pqrEv();
extern void _ZN3ccc3BB33efgEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x3y143pqrEv,_ZThn4_N3ccc8CC0x3y143pqrEv)();
extern void _ZN3ccc3BB33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x3y14E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x3y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x3y143pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x3y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB33efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x3y143pqrEv,_ZThn4_N3ccc8CC0x3y143pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3BB33abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x3y14E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x3y14E[];
Class_Descriptor cd__ZN3ccc8CC0x3y14E = {  "_ZN3ccc8CC0x3y14E", // class name
  bases__ZN3ccc8CC0x3y14E, 2,
  &(vtc__ZN3ccc8CC0x3y14E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x3y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x3y14E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x3y15  : ::ccc::AA0 , ::ccc::BB3 {
  ~CC0x3y15(); // tgen
  CC0x3y15(); // tgen
};
//SIG(1 _ZN3ccc8CC0x3y15E) C1{ BC2{ v1 v2 v3} BC3{ v4 v5 v6}}
}
namespace ccc { 
ccc::CC0x3y15 ::~CC0x3y15(){ note_dtor("_ZN3ccc8CC0x3y15E", this);} // tgen
ccc::CC0x3y15 ::CC0x3y15(){ note_ctor("_ZN3ccc8CC0x3y15E", this);} // tgen
}
static void Test__ZN3ccc8CC0x3y15E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x3y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x3y15E, buf);
    ::ccc::CC0x3y15 *dp, &lv = *(dp=new (buf) ::ccc::CC0x3y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x3y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x3y15E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x3y15E");
    check_base_class_offset(lv, (::ccc::BB3*), ABISELECT(8,4), "_ZN3ccc8CC0x3y15E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x3y15E);
    dp->::ccc::CC0x3y15::~CC0x3y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x3y15E(Test__ZN3ccc8CC0x3y15E, "_ZN3ccc8CC0x3y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x3y15C1Ev();
extern void _ZN3ccc8CC0x3y15D1Ev();
Name_Map name_map__ZN3ccc8CC0x3y15E[] = {
  NSPAIR(_ZN3ccc8CC0x3y15C1Ev),
  NSPAIR(_ZN3ccc8CC0x3y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB3E;
extern VTBL_ENTRY _ZTIN3ccc3BB3E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB3E[];
static Base_Class bases__ZN3ccc8CC0x3y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB3E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x3y15E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc3BB33efgEv();
extern void _ZN3ccc3BB33pqrEv();
extern void _ZN3ccc3BB33abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x3y15E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x3y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x3y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB33efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB33pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB33abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x3y15E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x3y15E[];
Class_Descriptor cd__ZN3ccc8CC0x3y15E = {  "_ZN3ccc8CC0x3y15E", // class name
  bases__ZN3ccc8CC0x3y15E, 2,
  &(vtc__ZN3ccc8CC0x3y15E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x3y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x3y15E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x4y0  : ::ccc::AA0 , ::ccc::BB4 {
  virtual void  abc(); // _ZN3ccc7CC0x4y03abcEv
  virtual void  efg(); // _ZN3ccc7CC0x4y03efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x4y03pqrEv
  ~CC0x4y0(); // tgen
  CC0x4y0(); // tgen
};
//SIG(1 _ZN3ccc7CC0x4y0E) C1{ BC2{ v1 v2 v3} BC3{ v3 v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x4y0 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x4y03abcEv");}
void  ccc::CC0x4y0 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x4y03efgEv");}
void  ccc::CC0x4y0 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x4y03pqrEv");}
ccc::CC0x4y0 ::~CC0x4y0(){ note_dtor("_ZN3ccc7CC0x4y0E", this);} // tgen
ccc::CC0x4y0 ::CC0x4y0(){ note_ctor("_ZN3ccc7CC0x4y0E", this);} // tgen
}
static void Test__ZN3ccc7CC0x4y0E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x4y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x4y0E, buf);
    ::ccc::CC0x4y0 *dp, &lv = *(dp=new (buf) ::ccc::CC0x4y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x4y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x4y0E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x4y0E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc7CC0x4y0E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x4y0E);
    dp->::ccc::CC0x4y0::~CC0x4y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x4y0E(Test__ZN3ccc7CC0x4y0E, "_ZN3ccc7CC0x4y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x4y0C1Ev();
extern void _ZN3ccc7CC0x4y0D1Ev();
Name_Map name_map__ZN3ccc7CC0x4y0E[] = {
  NSPAIR(_ZN3ccc7CC0x4y0C1Ev),
  NSPAIR(_ZN3ccc7CC0x4y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7CC0x4y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x4y0E[];
extern void _ZN3ccc7CC0x4y03abcEv();
extern void _ZN3ccc7CC0x4y03efgEv();
extern void _ZN3ccc7CC0x4y03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x4y03pqrEv,_ZThn4_N3ccc7CC0x4y03pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x4y03abcEv,_ZThn4_N3ccc7CC0x4y03abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x4y03efgEv,_ZThn4_N3ccc7CC0x4y03efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x4y0E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x4y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x4y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x4y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x4y03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x4y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x4y03pqrEv,_ZThn4_N3ccc7CC0x4y03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x4y03abcEv,_ZThn4_N3ccc7CC0x4y03abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x4y03efgEv,_ZThn4_N3ccc7CC0x4y03efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x4y0E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x4y0E[];
Class_Descriptor cd__ZN3ccc7CC0x4y0E = {  "_ZN3ccc7CC0x4y0E", // class name
  bases__ZN3ccc7CC0x4y0E, 2,
  &(vtc__ZN3ccc7CC0x4y0E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x4y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x4y0E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x4y1  : ::ccc::AA0 , ::ccc::BB4 {
  virtual void  abc(); // _ZN3ccc7CC0x4y13abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x4y13pqrEv
  virtual void  efg(); // _ZN3ccc7CC0x4y13efgEv
  ~CC0x4y1(); // tgen
  CC0x4y1(); // tgen
};
//SIG(1 _ZN3ccc7CC0x4y1E) C1{ BC2{ v1 v3 v2} BC3{ v2 v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x4y1 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x4y13abcEv");}
void  ccc::CC0x4y1 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x4y13pqrEv");}
void  ccc::CC0x4y1 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x4y13efgEv");}
ccc::CC0x4y1 ::~CC0x4y1(){ note_dtor("_ZN3ccc7CC0x4y1E", this);} // tgen
ccc::CC0x4y1 ::CC0x4y1(){ note_ctor("_ZN3ccc7CC0x4y1E", this);} // tgen
}
static void Test__ZN3ccc7CC0x4y1E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x4y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x4y1E, buf);
    ::ccc::CC0x4y1 *dp, &lv = *(dp=new (buf) ::ccc::CC0x4y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x4y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x4y1E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x4y1E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc7CC0x4y1E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x4y1E);
    dp->::ccc::CC0x4y1::~CC0x4y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x4y1E(Test__ZN3ccc7CC0x4y1E, "_ZN3ccc7CC0x4y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x4y1C1Ev();
extern void _ZN3ccc7CC0x4y1D1Ev();
Name_Map name_map__ZN3ccc7CC0x4y1E[] = {
  NSPAIR(_ZN3ccc7CC0x4y1C1Ev),
  NSPAIR(_ZN3ccc7CC0x4y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7CC0x4y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x4y1E[];
extern void _ZN3ccc7CC0x4y13abcEv();
extern void _ZN3ccc7CC0x4y13efgEv();
extern void _ZN3ccc7CC0x4y13pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x4y13pqrEv,_ZThn4_N3ccc7CC0x4y13pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x4y13abcEv,_ZThn4_N3ccc7CC0x4y13abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x4y13efgEv,_ZThn4_N3ccc7CC0x4y13efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x4y1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x4y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x4y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x4y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x4y13pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x4y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x4y13pqrEv,_ZThn4_N3ccc7CC0x4y13pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x4y13abcEv,_ZThn4_N3ccc7CC0x4y13abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x4y13efgEv,_ZThn4_N3ccc7CC0x4y13efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x4y1E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x4y1E[];
Class_Descriptor cd__ZN3ccc7CC0x4y1E = {  "_ZN3ccc7CC0x4y1E", // class name
  bases__ZN3ccc7CC0x4y1E, 2,
  &(vtc__ZN3ccc7CC0x4y1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x4y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x4y1E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x4y2  : ::ccc::AA0 , ::ccc::BB4 {
  virtual void  efg(); // _ZN3ccc7CC0x4y23efgEv
  virtual void  abc(); // _ZN3ccc7CC0x4y23abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x4y23pqrEv
  ~CC0x4y2(); // tgen
  CC0x4y2(); // tgen
};
//SIG(1 _ZN3ccc7CC0x4y2E) C1{ BC2{ v2 v1 v3} BC3{ v3 v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x4y2 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x4y23efgEv");}
void  ccc::CC0x4y2 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x4y23abcEv");}
void  ccc::CC0x4y2 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x4y23pqrEv");}
ccc::CC0x4y2 ::~CC0x4y2(){ note_dtor("_ZN3ccc7CC0x4y2E", this);} // tgen
ccc::CC0x4y2 ::CC0x4y2(){ note_ctor("_ZN3ccc7CC0x4y2E", this);} // tgen
}
static void Test__ZN3ccc7CC0x4y2E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x4y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x4y2E, buf);
    ::ccc::CC0x4y2 *dp, &lv = *(dp=new (buf) ::ccc::CC0x4y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x4y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x4y2E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x4y2E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc7CC0x4y2E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x4y2E);
    dp->::ccc::CC0x4y2::~CC0x4y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x4y2E(Test__ZN3ccc7CC0x4y2E, "_ZN3ccc7CC0x4y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x4y2C1Ev();
extern void _ZN3ccc7CC0x4y2D1Ev();
Name_Map name_map__ZN3ccc7CC0x4y2E[] = {
  NSPAIR(_ZN3ccc7CC0x4y2C1Ev),
  NSPAIR(_ZN3ccc7CC0x4y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7CC0x4y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x4y2E[];
extern void _ZN3ccc7CC0x4y23abcEv();
extern void _ZN3ccc7CC0x4y23efgEv();
extern void _ZN3ccc7CC0x4y23pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x4y23pqrEv,_ZThn4_N3ccc7CC0x4y23pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x4y23abcEv,_ZThn4_N3ccc7CC0x4y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x4y23efgEv,_ZThn4_N3ccc7CC0x4y23efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x4y2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x4y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x4y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x4y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x4y23pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x4y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x4y23pqrEv,_ZThn4_N3ccc7CC0x4y23pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x4y23abcEv,_ZThn4_N3ccc7CC0x4y23abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x4y23efgEv,_ZThn4_N3ccc7CC0x4y23efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x4y2E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x4y2E[];
Class_Descriptor cd__ZN3ccc7CC0x4y2E = {  "_ZN3ccc7CC0x4y2E", // class name
  bases__ZN3ccc7CC0x4y2E, 2,
  &(vtc__ZN3ccc7CC0x4y2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x4y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x4y2E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x4y3  : ::ccc::AA0 , ::ccc::BB4 {
  virtual void  efg(); // _ZN3ccc7CC0x4y33efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x4y33pqrEv
  virtual void  abc(); // _ZN3ccc7CC0x4y33abcEv
  ~CC0x4y3(); // tgen
  CC0x4y3(); // tgen
};
//SIG(1 _ZN3ccc7CC0x4y3E) C1{ BC2{ v3 v1 v2} BC3{ v2 v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x4y3 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x4y33efgEv");}
void  ccc::CC0x4y3 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x4y33pqrEv");}
void  ccc::CC0x4y3 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x4y33abcEv");}
ccc::CC0x4y3 ::~CC0x4y3(){ note_dtor("_ZN3ccc7CC0x4y3E", this);} // tgen
ccc::CC0x4y3 ::CC0x4y3(){ note_ctor("_ZN3ccc7CC0x4y3E", this);} // tgen
}
static void Test__ZN3ccc7CC0x4y3E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x4y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x4y3E, buf);
    ::ccc::CC0x4y3 *dp, &lv = *(dp=new (buf) ::ccc::CC0x4y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x4y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x4y3E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x4y3E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc7CC0x4y3E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x4y3E);
    dp->::ccc::CC0x4y3::~CC0x4y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x4y3E(Test__ZN3ccc7CC0x4y3E, "_ZN3ccc7CC0x4y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x4y3C1Ev();
extern void _ZN3ccc7CC0x4y3D1Ev();
Name_Map name_map__ZN3ccc7CC0x4y3E[] = {
  NSPAIR(_ZN3ccc7CC0x4y3C1Ev),
  NSPAIR(_ZN3ccc7CC0x4y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7CC0x4y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x4y3E[];
extern void _ZN3ccc7CC0x4y33abcEv();
extern void _ZN3ccc7CC0x4y33efgEv();
extern void _ZN3ccc7CC0x4y33pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x4y33pqrEv,_ZThn4_N3ccc7CC0x4y33pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x4y33abcEv,_ZThn4_N3ccc7CC0x4y33abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x4y33efgEv,_ZThn4_N3ccc7CC0x4y33efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x4y3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x4y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x4y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x4y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x4y33pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x4y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x4y33pqrEv,_ZThn4_N3ccc7CC0x4y33pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x4y33abcEv,_ZThn4_N3ccc7CC0x4y33abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x4y33efgEv,_ZThn4_N3ccc7CC0x4y33efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x4y3E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x4y3E[];
Class_Descriptor cd__ZN3ccc7CC0x4y3E = {  "_ZN3ccc7CC0x4y3E", // class name
  bases__ZN3ccc7CC0x4y3E, 2,
  &(vtc__ZN3ccc7CC0x4y3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x4y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x4y3E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x4y4  : ::ccc::AA0 , ::ccc::BB4 {
  virtual void  pqr(); // _ZN3ccc7CC0x4y43pqrEv
  virtual void  abc(); // _ZN3ccc7CC0x4y43abcEv
  virtual void  efg(); // _ZN3ccc7CC0x4y43efgEv
  ~CC0x4y4(); // tgen
  CC0x4y4(); // tgen
};
//SIG(1 _ZN3ccc7CC0x4y4E) C1{ BC2{ v2 v3 v1} BC3{ v1 v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x4y4 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x4y43pqrEv");}
void  ccc::CC0x4y4 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x4y43abcEv");}
void  ccc::CC0x4y4 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x4y43efgEv");}
ccc::CC0x4y4 ::~CC0x4y4(){ note_dtor("_ZN3ccc7CC0x4y4E", this);} // tgen
ccc::CC0x4y4 ::CC0x4y4(){ note_ctor("_ZN3ccc7CC0x4y4E", this);} // tgen
}
static void Test__ZN3ccc7CC0x4y4E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x4y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x4y4E, buf);
    ::ccc::CC0x4y4 *dp, &lv = *(dp=new (buf) ::ccc::CC0x4y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x4y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x4y4E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x4y4E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc7CC0x4y4E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x4y4E);
    dp->::ccc::CC0x4y4::~CC0x4y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x4y4E(Test__ZN3ccc7CC0x4y4E, "_ZN3ccc7CC0x4y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x4y4C1Ev();
extern void _ZN3ccc7CC0x4y4D1Ev();
Name_Map name_map__ZN3ccc7CC0x4y4E[] = {
  NSPAIR(_ZN3ccc7CC0x4y4C1Ev),
  NSPAIR(_ZN3ccc7CC0x4y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7CC0x4y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x4y4E[];
extern void _ZN3ccc7CC0x4y43abcEv();
extern void _ZN3ccc7CC0x4y43efgEv();
extern void _ZN3ccc7CC0x4y43pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x4y43pqrEv,_ZThn4_N3ccc7CC0x4y43pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x4y43abcEv,_ZThn4_N3ccc7CC0x4y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x4y43efgEv,_ZThn4_N3ccc7CC0x4y43efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x4y4E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x4y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x4y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x4y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x4y43pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x4y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x4y43pqrEv,_ZThn4_N3ccc7CC0x4y43pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x4y43abcEv,_ZThn4_N3ccc7CC0x4y43abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x4y43efgEv,_ZThn4_N3ccc7CC0x4y43efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x4y4E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x4y4E[];
Class_Descriptor cd__ZN3ccc7CC0x4y4E = {  "_ZN3ccc7CC0x4y4E", // class name
  bases__ZN3ccc7CC0x4y4E, 2,
  &(vtc__ZN3ccc7CC0x4y4E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x4y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x4y4E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x4y5  : ::ccc::AA0 , ::ccc::BB4 {
  virtual void  pqr(); // _ZN3ccc7CC0x4y53pqrEv
  virtual void  efg(); // _ZN3ccc7CC0x4y53efgEv
  virtual void  abc(); // _ZN3ccc7CC0x4y53abcEv
  ~CC0x4y5(); // tgen
  CC0x4y5(); // tgen
};
//SIG(1 _ZN3ccc7CC0x4y5E) C1{ BC2{ v3 v2 v1} BC3{ v1 v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x4y5 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x4y53pqrEv");}
void  ccc::CC0x4y5 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x4y53efgEv");}
void  ccc::CC0x4y5 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x4y53abcEv");}
ccc::CC0x4y5 ::~CC0x4y5(){ note_dtor("_ZN3ccc7CC0x4y5E", this);} // tgen
ccc::CC0x4y5 ::CC0x4y5(){ note_ctor("_ZN3ccc7CC0x4y5E", this);} // tgen
}
static void Test__ZN3ccc7CC0x4y5E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x4y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x4y5E, buf);
    ::ccc::CC0x4y5 *dp, &lv = *(dp=new (buf) ::ccc::CC0x4y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x4y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x4y5E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x4y5E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc7CC0x4y5E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x4y5E);
    dp->::ccc::CC0x4y5::~CC0x4y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x4y5E(Test__ZN3ccc7CC0x4y5E, "_ZN3ccc7CC0x4y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x4y5C1Ev();
extern void _ZN3ccc7CC0x4y5D1Ev();
Name_Map name_map__ZN3ccc7CC0x4y5E[] = {
  NSPAIR(_ZN3ccc7CC0x4y5C1Ev),
  NSPAIR(_ZN3ccc7CC0x4y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7CC0x4y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x4y5E[];
extern void _ZN3ccc7CC0x4y53abcEv();
extern void _ZN3ccc7CC0x4y53efgEv();
extern void _ZN3ccc7CC0x4y53pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x4y53pqrEv,_ZThn4_N3ccc7CC0x4y53pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x4y53abcEv,_ZThn4_N3ccc7CC0x4y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x4y53efgEv,_ZThn4_N3ccc7CC0x4y53efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x4y5E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x4y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x4y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x4y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x4y53pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x4y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x4y53pqrEv,_ZThn4_N3ccc7CC0x4y53pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x4y53abcEv,_ZThn4_N3ccc7CC0x4y53abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x4y53efgEv,_ZThn4_N3ccc7CC0x4y53efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x4y5E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x4y5E[];
Class_Descriptor cd__ZN3ccc7CC0x4y5E = {  "_ZN3ccc7CC0x4y5E", // class name
  bases__ZN3ccc7CC0x4y5E, 2,
  &(vtc__ZN3ccc7CC0x4y5E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x4y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x4y5E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x4y6  : ::ccc::AA0 , ::ccc::BB4 {
  virtual void  abc(); // _ZN3ccc7CC0x4y63abcEv
  virtual void  efg(); // _ZN3ccc7CC0x4y63efgEv
  ~CC0x4y6(); // tgen
  CC0x4y6(); // tgen
};
//SIG(1 _ZN3ccc7CC0x4y6E) C1{ BC2{ v1 v2 v3} BC3{ v4 v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x4y6 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x4y63abcEv");}
void  ccc::CC0x4y6 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x4y63efgEv");}
ccc::CC0x4y6 ::~CC0x4y6(){ note_dtor("_ZN3ccc7CC0x4y6E", this);} // tgen
ccc::CC0x4y6 ::CC0x4y6(){ note_ctor("_ZN3ccc7CC0x4y6E", this);} // tgen
}
static void Test__ZN3ccc7CC0x4y6E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x4y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x4y6E, buf);
    ::ccc::CC0x4y6 *dp, &lv = *(dp=new (buf) ::ccc::CC0x4y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x4y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x4y6E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x4y6E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc7CC0x4y6E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x4y6E);
    dp->::ccc::CC0x4y6::~CC0x4y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x4y6E(Test__ZN3ccc7CC0x4y6E, "_ZN3ccc7CC0x4y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x4y6C1Ev();
extern void _ZN3ccc7CC0x4y6D1Ev();
Name_Map name_map__ZN3ccc7CC0x4y6E[] = {
  NSPAIR(_ZN3ccc7CC0x4y6C1Ev),
  NSPAIR(_ZN3ccc7CC0x4y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7CC0x4y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x4y6E[];
extern void _ZN3ccc7CC0x4y63abcEv();
extern void _ZN3ccc7CC0x4y63efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc3BB43pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x4y63abcEv,_ZThn4_N3ccc7CC0x4y63abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x4y63efgEv,_ZThn4_N3ccc7CC0x4y63efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x4y6E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x4y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x4y63abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x4y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x4y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB43pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x4y63abcEv,_ZThn4_N3ccc7CC0x4y63abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x4y63efgEv,_ZThn4_N3ccc7CC0x4y63efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x4y6E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x4y6E[];
Class_Descriptor cd__ZN3ccc7CC0x4y6E = {  "_ZN3ccc7CC0x4y6E", // class name
  bases__ZN3ccc7CC0x4y6E, 2,
  &(vtc__ZN3ccc7CC0x4y6E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x4y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x4y6E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x4y7  : ::ccc::AA0 , ::ccc::BB4 {
  virtual void  abc(); // _ZN3ccc7CC0x4y73abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x4y73pqrEv
  ~CC0x4y7(); // tgen
  CC0x4y7(); // tgen
};
//SIG(1 _ZN3ccc7CC0x4y7E) C1{ BC2{ v1 v3 v2} BC3{ v2 v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x4y7 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x4y73abcEv");}
void  ccc::CC0x4y7 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x4y73pqrEv");}
ccc::CC0x4y7 ::~CC0x4y7(){ note_dtor("_ZN3ccc7CC0x4y7E", this);} // tgen
ccc::CC0x4y7 ::CC0x4y7(){ note_ctor("_ZN3ccc7CC0x4y7E", this);} // tgen
}
static void Test__ZN3ccc7CC0x4y7E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x4y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x4y7E, buf);
    ::ccc::CC0x4y7 *dp, &lv = *(dp=new (buf) ::ccc::CC0x4y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x4y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x4y7E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x4y7E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc7CC0x4y7E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x4y7E);
    dp->::ccc::CC0x4y7::~CC0x4y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x4y7E(Test__ZN3ccc7CC0x4y7E, "_ZN3ccc7CC0x4y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x4y7C1Ev();
extern void _ZN3ccc7CC0x4y7D1Ev();
Name_Map name_map__ZN3ccc7CC0x4y7E[] = {
  NSPAIR(_ZN3ccc7CC0x4y7C1Ev),
  NSPAIR(_ZN3ccc7CC0x4y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7CC0x4y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x4y7E[];
extern void _ZN3ccc7CC0x4y73abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc7CC0x4y73pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x4y73pqrEv,_ZThn4_N3ccc7CC0x4y73pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x4y73abcEv,_ZThn4_N3ccc7CC0x4y73abcEv)();
extern void _ZN3ccc3BB43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x4y7E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x4y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x4y73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x4y73pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x4y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x4y73pqrEv,_ZThn4_N3ccc7CC0x4y73pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x4y73abcEv,_ZThn4_N3ccc7CC0x4y73abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB43efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x4y7E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x4y7E[];
Class_Descriptor cd__ZN3ccc7CC0x4y7E = {  "_ZN3ccc7CC0x4y7E", // class name
  bases__ZN3ccc7CC0x4y7E, 2,
  &(vtc__ZN3ccc7CC0x4y7E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x4y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x4y7E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x4y8  : ::ccc::AA0 , ::ccc::BB4 {
  virtual void  efg(); // _ZN3ccc7CC0x4y83efgEv
  virtual void  abc(); // _ZN3ccc7CC0x4y83abcEv
  ~CC0x4y8(); // tgen
  CC0x4y8(); // tgen
};
//SIG(1 _ZN3ccc7CC0x4y8E) C1{ BC2{ v2 v1 v3} BC3{ v4 v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x4y8 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x4y83efgEv");}
void  ccc::CC0x4y8 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x4y83abcEv");}
ccc::CC0x4y8 ::~CC0x4y8(){ note_dtor("_ZN3ccc7CC0x4y8E", this);} // tgen
ccc::CC0x4y8 ::CC0x4y8(){ note_ctor("_ZN3ccc7CC0x4y8E", this);} // tgen
}
static void Test__ZN3ccc7CC0x4y8E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x4y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x4y8E, buf);
    ::ccc::CC0x4y8 *dp, &lv = *(dp=new (buf) ::ccc::CC0x4y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x4y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x4y8E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x4y8E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc7CC0x4y8E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x4y8E);
    dp->::ccc::CC0x4y8::~CC0x4y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x4y8E(Test__ZN3ccc7CC0x4y8E, "_ZN3ccc7CC0x4y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x4y8C1Ev();
extern void _ZN3ccc7CC0x4y8D1Ev();
Name_Map name_map__ZN3ccc7CC0x4y8E[] = {
  NSPAIR(_ZN3ccc7CC0x4y8C1Ev),
  NSPAIR(_ZN3ccc7CC0x4y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7CC0x4y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x4y8E[];
extern void _ZN3ccc7CC0x4y83abcEv();
extern void _ZN3ccc7CC0x4y83efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc3BB43pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x4y83abcEv,_ZThn4_N3ccc7CC0x4y83abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x4y83efgEv,_ZThn4_N3ccc7CC0x4y83efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x4y8E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x4y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x4y83abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x4y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x4y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB43pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x4y83abcEv,_ZThn4_N3ccc7CC0x4y83abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x4y83efgEv,_ZThn4_N3ccc7CC0x4y83efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x4y8E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x4y8E[];
Class_Descriptor cd__ZN3ccc7CC0x4y8E = {  "_ZN3ccc7CC0x4y8E", // class name
  bases__ZN3ccc7CC0x4y8E, 2,
  &(vtc__ZN3ccc7CC0x4y8E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x4y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x4y8E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x4y9  : ::ccc::AA0 , ::ccc::BB4 {
  virtual void  efg(); // _ZN3ccc7CC0x4y93efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x4y93pqrEv
  ~CC0x4y9(); // tgen
  CC0x4y9(); // tgen
};
//SIG(1 _ZN3ccc7CC0x4y9E) C1{ BC2{ v3 v1 v2} BC3{ v2 v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x4y9 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x4y93efgEv");}
void  ccc::CC0x4y9 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x4y93pqrEv");}
ccc::CC0x4y9 ::~CC0x4y9(){ note_dtor("_ZN3ccc7CC0x4y9E", this);} // tgen
ccc::CC0x4y9 ::CC0x4y9(){ note_ctor("_ZN3ccc7CC0x4y9E", this);} // tgen
}
static void Test__ZN3ccc7CC0x4y9E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x4y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x4y9E, buf);
    ::ccc::CC0x4y9 *dp, &lv = *(dp=new (buf) ::ccc::CC0x4y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x4y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x4y9E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x4y9E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc7CC0x4y9E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x4y9E);
    dp->::ccc::CC0x4y9::~CC0x4y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x4y9E(Test__ZN3ccc7CC0x4y9E, "_ZN3ccc7CC0x4y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x4y9C1Ev();
extern void _ZN3ccc7CC0x4y9D1Ev();
Name_Map name_map__ZN3ccc7CC0x4y9E[] = {
  NSPAIR(_ZN3ccc7CC0x4y9C1Ev),
  NSPAIR(_ZN3ccc7CC0x4y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc7CC0x4y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x4y9E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc7CC0x4y93efgEv();
extern void _ZN3ccc7CC0x4y93pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x4y93pqrEv,_ZThn4_N3ccc7CC0x4y93pqrEv)();
extern void _ZN3ccc3BB43abcEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x4y93efgEv,_ZThn4_N3ccc7CC0x4y93efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x4y9E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x4y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x4y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x4y93pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x4y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x4y93pqrEv,_ZThn4_N3ccc7CC0x4y93pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3BB43abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x4y93efgEv,_ZThn4_N3ccc7CC0x4y93efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x4y9E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x4y9E[];
Class_Descriptor cd__ZN3ccc7CC0x4y9E = {  "_ZN3ccc7CC0x4y9E", // class name
  bases__ZN3ccc7CC0x4y9E, 2,
  &(vtc__ZN3ccc7CC0x4y9E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x4y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x4y9E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x4y10  : ::ccc::AA0 , ::ccc::BB4 {
  virtual void  pqr(); // _ZN3ccc8CC0x4y103pqrEv
  virtual void  abc(); // _ZN3ccc8CC0x4y103abcEv
  ~CC0x4y10(); // tgen
  CC0x4y10(); // tgen
};
//SIG(1 _ZN3ccc8CC0x4y10E) C1{ BC2{ v2 v3 v1} BC3{ v1 v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x4y10 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x4y103pqrEv");}
void  ccc::CC0x4y10 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x4y103abcEv");}
ccc::CC0x4y10 ::~CC0x4y10(){ note_dtor("_ZN3ccc8CC0x4y10E", this);} // tgen
ccc::CC0x4y10 ::CC0x4y10(){ note_ctor("_ZN3ccc8CC0x4y10E", this);} // tgen
}
static void Test__ZN3ccc8CC0x4y10E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x4y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x4y10E, buf);
    ::ccc::CC0x4y10 *dp, &lv = *(dp=new (buf) ::ccc::CC0x4y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x4y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x4y10E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x4y10E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc8CC0x4y10E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x4y10E);
    dp->::ccc::CC0x4y10::~CC0x4y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x4y10E(Test__ZN3ccc8CC0x4y10E, "_ZN3ccc8CC0x4y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x4y10C1Ev();
extern void _ZN3ccc8CC0x4y10D1Ev();
Name_Map name_map__ZN3ccc8CC0x4y10E[] = {
  NSPAIR(_ZN3ccc8CC0x4y10C1Ev),
  NSPAIR(_ZN3ccc8CC0x4y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc8CC0x4y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x4y10E[];
extern void _ZN3ccc8CC0x4y103abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc8CC0x4y103pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x4y103pqrEv,_ZThn4_N3ccc8CC0x4y103pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC0x4y103abcEv,_ZThn4_N3ccc8CC0x4y103abcEv)();
extern void _ZN3ccc3BB43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x4y10E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x4y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x4y103abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x4y103pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x4y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x4y103pqrEv,_ZThn4_N3ccc8CC0x4y103pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x4y103abcEv,_ZThn4_N3ccc8CC0x4y103abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB43efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x4y10E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x4y10E[];
Class_Descriptor cd__ZN3ccc8CC0x4y10E = {  "_ZN3ccc8CC0x4y10E", // class name
  bases__ZN3ccc8CC0x4y10E, 2,
  &(vtc__ZN3ccc8CC0x4y10E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x4y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x4y10E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x4y11  : ::ccc::AA0 , ::ccc::BB4 {
  virtual void  pqr(); // _ZN3ccc8CC0x4y113pqrEv
  virtual void  efg(); // _ZN3ccc8CC0x4y113efgEv
  ~CC0x4y11(); // tgen
  CC0x4y11(); // tgen
};
//SIG(1 _ZN3ccc8CC0x4y11E) C1{ BC2{ v3 v2 v1} BC3{ v1 v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x4y11 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x4y113pqrEv");}
void  ccc::CC0x4y11 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x4y113efgEv");}
ccc::CC0x4y11 ::~CC0x4y11(){ note_dtor("_ZN3ccc8CC0x4y11E", this);} // tgen
ccc::CC0x4y11 ::CC0x4y11(){ note_ctor("_ZN3ccc8CC0x4y11E", this);} // tgen
}
static void Test__ZN3ccc8CC0x4y11E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x4y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x4y11E, buf);
    ::ccc::CC0x4y11 *dp, &lv = *(dp=new (buf) ::ccc::CC0x4y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x4y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x4y11E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x4y11E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc8CC0x4y11E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x4y11E);
    dp->::ccc::CC0x4y11::~CC0x4y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x4y11E(Test__ZN3ccc8CC0x4y11E, "_ZN3ccc8CC0x4y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x4y11C1Ev();
extern void _ZN3ccc8CC0x4y11D1Ev();
Name_Map name_map__ZN3ccc8CC0x4y11E[] = {
  NSPAIR(_ZN3ccc8CC0x4y11C1Ev),
  NSPAIR(_ZN3ccc8CC0x4y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc8CC0x4y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x4y11E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc8CC0x4y113efgEv();
extern void _ZN3ccc8CC0x4y113pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x4y113pqrEv,_ZThn4_N3ccc8CC0x4y113pqrEv)();
extern void _ZN3ccc3BB43abcEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x4y113efgEv,_ZThn4_N3ccc8CC0x4y113efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x4y11E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x4y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x4y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x4y113pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x4y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x4y113pqrEv,_ZThn4_N3ccc8CC0x4y113pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3BB43abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x4y113efgEv,_ZThn4_N3ccc8CC0x4y113efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x4y11E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x4y11E[];
Class_Descriptor cd__ZN3ccc8CC0x4y11E = {  "_ZN3ccc8CC0x4y11E", // class name
  bases__ZN3ccc8CC0x4y11E, 2,
  &(vtc__ZN3ccc8CC0x4y11E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x4y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x4y11E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x4y12  : ::ccc::AA0 , ::ccc::BB4 {
  virtual void  abc(); // _ZN3ccc8CC0x4y123abcEv
  ~CC0x4y12(); // tgen
  CC0x4y12(); // tgen
};
//SIG(1 _ZN3ccc8CC0x4y12E) C1{ BC2{ v1 v2 v3} BC3{ v4 v1 v5} v1}
}
namespace ccc { 
void  ccc::CC0x4y12 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x4y123abcEv");}
ccc::CC0x4y12 ::~CC0x4y12(){ note_dtor("_ZN3ccc8CC0x4y12E", this);} // tgen
ccc::CC0x4y12 ::CC0x4y12(){ note_ctor("_ZN3ccc8CC0x4y12E", this);} // tgen
}
static void Test__ZN3ccc8CC0x4y12E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x4y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x4y12E, buf);
    ::ccc::CC0x4y12 *dp, &lv = *(dp=new (buf) ::ccc::CC0x4y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x4y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x4y12E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x4y12E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc8CC0x4y12E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x4y12E);
    dp->::ccc::CC0x4y12::~CC0x4y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x4y12E(Test__ZN3ccc8CC0x4y12E, "_ZN3ccc8CC0x4y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x4y12C1Ev();
extern void _ZN3ccc8CC0x4y12D1Ev();
Name_Map name_map__ZN3ccc8CC0x4y12E[] = {
  NSPAIR(_ZN3ccc8CC0x4y12C1Ev),
  NSPAIR(_ZN3ccc8CC0x4y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc8CC0x4y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x4y12E[];
extern void _ZN3ccc8CC0x4y123abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc3BB43pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x4y123abcEv,_ZThn4_N3ccc8CC0x4y123abcEv)();
extern void _ZN3ccc3BB43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x4y12E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x4y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x4y123abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x4y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB43pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x4y123abcEv,_ZThn4_N3ccc8CC0x4y123abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB43efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x4y12E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x4y12E[];
Class_Descriptor cd__ZN3ccc8CC0x4y12E = {  "_ZN3ccc8CC0x4y12E", // class name
  bases__ZN3ccc8CC0x4y12E, 2,
  &(vtc__ZN3ccc8CC0x4y12E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x4y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x4y12E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x4y13  : ::ccc::AA0 , ::ccc::BB4 {
  virtual void  efg(); // _ZN3ccc8CC0x4y133efgEv
  ~CC0x4y13(); // tgen
  CC0x4y13(); // tgen
};
//SIG(1 _ZN3ccc8CC0x4y13E) C1{ BC2{ v2 v1 v3} BC3{ v4 v5 v1} v1}
}
namespace ccc { 
void  ccc::CC0x4y13 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x4y133efgEv");}
ccc::CC0x4y13 ::~CC0x4y13(){ note_dtor("_ZN3ccc8CC0x4y13E", this);} // tgen
ccc::CC0x4y13 ::CC0x4y13(){ note_ctor("_ZN3ccc8CC0x4y13E", this);} // tgen
}
static void Test__ZN3ccc8CC0x4y13E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x4y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x4y13E, buf);
    ::ccc::CC0x4y13 *dp, &lv = *(dp=new (buf) ::ccc::CC0x4y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x4y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x4y13E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x4y13E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc8CC0x4y13E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x4y13E);
    dp->::ccc::CC0x4y13::~CC0x4y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x4y13E(Test__ZN3ccc8CC0x4y13E, "_ZN3ccc8CC0x4y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x4y13C1Ev();
extern void _ZN3ccc8CC0x4y13D1Ev();
Name_Map name_map__ZN3ccc8CC0x4y13E[] = {
  NSPAIR(_ZN3ccc8CC0x4y13C1Ev),
  NSPAIR(_ZN3ccc8CC0x4y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc8CC0x4y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x4y13E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc8CC0x4y133efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc3BB43pqrEv();
extern void _ZN3ccc3BB43abcEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x4y133efgEv,_ZThn4_N3ccc8CC0x4y133efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x4y13E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x4y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x4y133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x4y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB43abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x4y133efgEv,_ZThn4_N3ccc8CC0x4y133efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x4y13E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x4y13E[];
Class_Descriptor cd__ZN3ccc8CC0x4y13E = {  "_ZN3ccc8CC0x4y13E", // class name
  bases__ZN3ccc8CC0x4y13E, 2,
  &(vtc__ZN3ccc8CC0x4y13E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x4y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x4y13E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x4y14  : ::ccc::AA0 , ::ccc::BB4 {
  virtual void  pqr(); // _ZN3ccc8CC0x4y143pqrEv
  ~CC0x4y14(); // tgen
  CC0x4y14(); // tgen
};
//SIG(1 _ZN3ccc8CC0x4y14E) C1{ BC2{ v2 v3 v1} BC3{ v1 v4 v5} v1}
}
namespace ccc { 
void  ccc::CC0x4y14 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x4y143pqrEv");}
ccc::CC0x4y14 ::~CC0x4y14(){ note_dtor("_ZN3ccc8CC0x4y14E", this);} // tgen
ccc::CC0x4y14 ::CC0x4y14(){ note_ctor("_ZN3ccc8CC0x4y14E", this);} // tgen
}
static void Test__ZN3ccc8CC0x4y14E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x4y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x4y14E, buf);
    ::ccc::CC0x4y14 *dp, &lv = *(dp=new (buf) ::ccc::CC0x4y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x4y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x4y14E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x4y14E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc8CC0x4y14E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x4y14E);
    dp->::ccc::CC0x4y14::~CC0x4y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x4y14E(Test__ZN3ccc8CC0x4y14E, "_ZN3ccc8CC0x4y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x4y14C1Ev();
extern void _ZN3ccc8CC0x4y14D1Ev();
Name_Map name_map__ZN3ccc8CC0x4y14E[] = {
  NSPAIR(_ZN3ccc8CC0x4y14C1Ev),
  NSPAIR(_ZN3ccc8CC0x4y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc8CC0x4y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x4y14E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc8CC0x4y143pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x4y143pqrEv,_ZThn4_N3ccc8CC0x4y143pqrEv)();
extern void _ZN3ccc3BB43abcEv();
extern void _ZN3ccc3BB43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x4y14E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x4y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x4y143pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x4y14E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x4y143pqrEv,_ZThn4_N3ccc8CC0x4y143pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3BB43abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB43efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x4y14E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x4y14E[];
Class_Descriptor cd__ZN3ccc8CC0x4y14E = {  "_ZN3ccc8CC0x4y14E", // class name
  bases__ZN3ccc8CC0x4y14E, 2,
  &(vtc__ZN3ccc8CC0x4y14E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x4y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x4y14E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x4y15  : ::ccc::AA0 , ::ccc::BB4 {
  ~CC0x4y15(); // tgen
  CC0x4y15(); // tgen
};
//SIG(1 _ZN3ccc8CC0x4y15E) C1{ BC2{ v1 v2 v3} BC3{ v4 v5 v6}}
}
namespace ccc { 
ccc::CC0x4y15 ::~CC0x4y15(){ note_dtor("_ZN3ccc8CC0x4y15E", this);} // tgen
ccc::CC0x4y15 ::CC0x4y15(){ note_ctor("_ZN3ccc8CC0x4y15E", this);} // tgen
}
static void Test__ZN3ccc8CC0x4y15E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x4y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x4y15E, buf);
    ::ccc::CC0x4y15 *dp, &lv = *(dp=new (buf) ::ccc::CC0x4y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x4y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x4y15E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x4y15E");
    check_base_class_offset(lv, (::ccc::BB4*), ABISELECT(8,4), "_ZN3ccc8CC0x4y15E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x4y15E);
    dp->::ccc::CC0x4y15::~CC0x4y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x4y15E(Test__ZN3ccc8CC0x4y15E, "_ZN3ccc8CC0x4y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x4y15C1Ev();
extern void _ZN3ccc8CC0x4y15D1Ev();
Name_Map name_map__ZN3ccc8CC0x4y15E[] = {
  NSPAIR(_ZN3ccc8CC0x4y15C1Ev),
  NSPAIR(_ZN3ccc8CC0x4y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB4E;
extern VTBL_ENTRY _ZTIN3ccc3BB4E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB4E[];
static Base_Class bases__ZN3ccc8CC0x4y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB4E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x4y15E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc3BB43pqrEv();
extern void _ZN3ccc3BB43abcEv();
extern void _ZN3ccc3BB43efgEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x4y15E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x4y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x4y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB43pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB43abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB43efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x4y15E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x4y15E[];
Class_Descriptor cd__ZN3ccc8CC0x4y15E = {  "_ZN3ccc8CC0x4y15E", // class name
  bases__ZN3ccc8CC0x4y15E, 2,
  &(vtc__ZN3ccc8CC0x4y15E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x4y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x4y15E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x5y0  : ::ccc::AA0 , ::ccc::BB5 {
  virtual void  abc(); // _ZN3ccc7CC0x5y03abcEv
  virtual void  efg(); // _ZN3ccc7CC0x5y03efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x5y03pqrEv
  ~CC0x5y0(); // tgen
  CC0x5y0(); // tgen
};
//SIG(1 _ZN3ccc7CC0x5y0E) C1{ BC2{ v1 v2 v3} BC3{ v3 v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x5y0 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x5y03abcEv");}
void  ccc::CC0x5y0 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x5y03efgEv");}
void  ccc::CC0x5y0 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x5y03pqrEv");}
ccc::CC0x5y0 ::~CC0x5y0(){ note_dtor("_ZN3ccc7CC0x5y0E", this);} // tgen
ccc::CC0x5y0 ::CC0x5y0(){ note_ctor("_ZN3ccc7CC0x5y0E", this);} // tgen
}
static void Test__ZN3ccc7CC0x5y0E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x5y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x5y0E, buf);
    ::ccc::CC0x5y0 *dp, &lv = *(dp=new (buf) ::ccc::CC0x5y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x5y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x5y0E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x5y0E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc7CC0x5y0E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x5y0E);
    dp->::ccc::CC0x5y0::~CC0x5y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x5y0E(Test__ZN3ccc7CC0x5y0E, "_ZN3ccc7CC0x5y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x5y0C1Ev();
extern void _ZN3ccc7CC0x5y0D1Ev();
Name_Map name_map__ZN3ccc7CC0x5y0E[] = {
  NSPAIR(_ZN3ccc7CC0x5y0C1Ev),
  NSPAIR(_ZN3ccc7CC0x5y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7CC0x5y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x5y0E[];
extern void _ZN3ccc7CC0x5y03abcEv();
extern void _ZN3ccc7CC0x5y03efgEv();
extern void _ZN3ccc7CC0x5y03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x5y03pqrEv,_ZThn4_N3ccc7CC0x5y03pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x5y03efgEv,_ZThn4_N3ccc7CC0x5y03efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x5y03abcEv,_ZThn4_N3ccc7CC0x5y03abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x5y0E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x5y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x5y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x5y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x5y03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x5y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x5y03pqrEv,_ZThn4_N3ccc7CC0x5y03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x5y03efgEv,_ZThn4_N3ccc7CC0x5y03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x5y03abcEv,_ZThn4_N3ccc7CC0x5y03abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x5y0E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x5y0E[];
Class_Descriptor cd__ZN3ccc7CC0x5y0E = {  "_ZN3ccc7CC0x5y0E", // class name
  bases__ZN3ccc7CC0x5y0E, 2,
  &(vtc__ZN3ccc7CC0x5y0E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x5y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x5y0E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x5y1  : ::ccc::AA0 , ::ccc::BB5 {
  virtual void  abc(); // _ZN3ccc7CC0x5y13abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x5y13pqrEv
  virtual void  efg(); // _ZN3ccc7CC0x5y13efgEv
  ~CC0x5y1(); // tgen
  CC0x5y1(); // tgen
};
//SIG(1 _ZN3ccc7CC0x5y1E) C1{ BC2{ v1 v3 v2} BC3{ v2 v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x5y1 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x5y13abcEv");}
void  ccc::CC0x5y1 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x5y13pqrEv");}
void  ccc::CC0x5y1 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x5y13efgEv");}
ccc::CC0x5y1 ::~CC0x5y1(){ note_dtor("_ZN3ccc7CC0x5y1E", this);} // tgen
ccc::CC0x5y1 ::CC0x5y1(){ note_ctor("_ZN3ccc7CC0x5y1E", this);} // tgen
}
static void Test__ZN3ccc7CC0x5y1E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x5y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x5y1E, buf);
    ::ccc::CC0x5y1 *dp, &lv = *(dp=new (buf) ::ccc::CC0x5y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x5y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x5y1E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x5y1E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc7CC0x5y1E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x5y1E);
    dp->::ccc::CC0x5y1::~CC0x5y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x5y1E(Test__ZN3ccc7CC0x5y1E, "_ZN3ccc7CC0x5y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x5y1C1Ev();
extern void _ZN3ccc7CC0x5y1D1Ev();
Name_Map name_map__ZN3ccc7CC0x5y1E[] = {
  NSPAIR(_ZN3ccc7CC0x5y1C1Ev),
  NSPAIR(_ZN3ccc7CC0x5y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7CC0x5y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x5y1E[];
extern void _ZN3ccc7CC0x5y13abcEv();
extern void _ZN3ccc7CC0x5y13efgEv();
extern void _ZN3ccc7CC0x5y13pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x5y13pqrEv,_ZThn4_N3ccc7CC0x5y13pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x5y13efgEv,_ZThn4_N3ccc7CC0x5y13efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x5y13abcEv,_ZThn4_N3ccc7CC0x5y13abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x5y1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x5y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x5y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x5y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x5y13pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x5y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x5y13pqrEv,_ZThn4_N3ccc7CC0x5y13pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x5y13efgEv,_ZThn4_N3ccc7CC0x5y13efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x5y13abcEv,_ZThn4_N3ccc7CC0x5y13abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x5y1E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x5y1E[];
Class_Descriptor cd__ZN3ccc7CC0x5y1E = {  "_ZN3ccc7CC0x5y1E", // class name
  bases__ZN3ccc7CC0x5y1E, 2,
  &(vtc__ZN3ccc7CC0x5y1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x5y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x5y1E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x5y2  : ::ccc::AA0 , ::ccc::BB5 {
  virtual void  efg(); // _ZN3ccc7CC0x5y23efgEv
  virtual void  abc(); // _ZN3ccc7CC0x5y23abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x5y23pqrEv
  ~CC0x5y2(); // tgen
  CC0x5y2(); // tgen
};
//SIG(1 _ZN3ccc7CC0x5y2E) C1{ BC2{ v2 v1 v3} BC3{ v3 v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x5y2 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x5y23efgEv");}
void  ccc::CC0x5y2 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x5y23abcEv");}
void  ccc::CC0x5y2 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x5y23pqrEv");}
ccc::CC0x5y2 ::~CC0x5y2(){ note_dtor("_ZN3ccc7CC0x5y2E", this);} // tgen
ccc::CC0x5y2 ::CC0x5y2(){ note_ctor("_ZN3ccc7CC0x5y2E", this);} // tgen
}
static void Test__ZN3ccc7CC0x5y2E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x5y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x5y2E, buf);
    ::ccc::CC0x5y2 *dp, &lv = *(dp=new (buf) ::ccc::CC0x5y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x5y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x5y2E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x5y2E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc7CC0x5y2E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x5y2E);
    dp->::ccc::CC0x5y2::~CC0x5y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x5y2E(Test__ZN3ccc7CC0x5y2E, "_ZN3ccc7CC0x5y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x5y2C1Ev();
extern void _ZN3ccc7CC0x5y2D1Ev();
Name_Map name_map__ZN3ccc7CC0x5y2E[] = {
  NSPAIR(_ZN3ccc7CC0x5y2C1Ev),
  NSPAIR(_ZN3ccc7CC0x5y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7CC0x5y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x5y2E[];
extern void _ZN3ccc7CC0x5y23abcEv();
extern void _ZN3ccc7CC0x5y23efgEv();
extern void _ZN3ccc7CC0x5y23pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x5y23pqrEv,_ZThn4_N3ccc7CC0x5y23pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x5y23efgEv,_ZThn4_N3ccc7CC0x5y23efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x5y23abcEv,_ZThn4_N3ccc7CC0x5y23abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x5y2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x5y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x5y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x5y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x5y23pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x5y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x5y23pqrEv,_ZThn4_N3ccc7CC0x5y23pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x5y23efgEv,_ZThn4_N3ccc7CC0x5y23efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x5y23abcEv,_ZThn4_N3ccc7CC0x5y23abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x5y2E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x5y2E[];
Class_Descriptor cd__ZN3ccc7CC0x5y2E = {  "_ZN3ccc7CC0x5y2E", // class name
  bases__ZN3ccc7CC0x5y2E, 2,
  &(vtc__ZN3ccc7CC0x5y2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x5y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x5y2E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x5y3  : ::ccc::AA0 , ::ccc::BB5 {
  virtual void  efg(); // _ZN3ccc7CC0x5y33efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x5y33pqrEv
  virtual void  abc(); // _ZN3ccc7CC0x5y33abcEv
  ~CC0x5y3(); // tgen
  CC0x5y3(); // tgen
};
//SIG(1 _ZN3ccc7CC0x5y3E) C1{ BC2{ v3 v1 v2} BC3{ v2 v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x5y3 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x5y33efgEv");}
void  ccc::CC0x5y3 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x5y33pqrEv");}
void  ccc::CC0x5y3 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x5y33abcEv");}
ccc::CC0x5y3 ::~CC0x5y3(){ note_dtor("_ZN3ccc7CC0x5y3E", this);} // tgen
ccc::CC0x5y3 ::CC0x5y3(){ note_ctor("_ZN3ccc7CC0x5y3E", this);} // tgen
}
static void Test__ZN3ccc7CC0x5y3E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x5y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x5y3E, buf);
    ::ccc::CC0x5y3 *dp, &lv = *(dp=new (buf) ::ccc::CC0x5y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x5y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x5y3E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x5y3E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc7CC0x5y3E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x5y3E);
    dp->::ccc::CC0x5y3::~CC0x5y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x5y3E(Test__ZN3ccc7CC0x5y3E, "_ZN3ccc7CC0x5y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x5y3C1Ev();
extern void _ZN3ccc7CC0x5y3D1Ev();
Name_Map name_map__ZN3ccc7CC0x5y3E[] = {
  NSPAIR(_ZN3ccc7CC0x5y3C1Ev),
  NSPAIR(_ZN3ccc7CC0x5y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7CC0x5y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x5y3E[];
extern void _ZN3ccc7CC0x5y33abcEv();
extern void _ZN3ccc7CC0x5y33efgEv();
extern void _ZN3ccc7CC0x5y33pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x5y33pqrEv,_ZThn4_N3ccc7CC0x5y33pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x5y33efgEv,_ZThn4_N3ccc7CC0x5y33efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x5y33abcEv,_ZThn4_N3ccc7CC0x5y33abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x5y3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x5y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x5y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x5y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x5y33pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x5y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x5y33pqrEv,_ZThn4_N3ccc7CC0x5y33pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x5y33efgEv,_ZThn4_N3ccc7CC0x5y33efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x5y33abcEv,_ZThn4_N3ccc7CC0x5y33abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x5y3E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x5y3E[];
Class_Descriptor cd__ZN3ccc7CC0x5y3E = {  "_ZN3ccc7CC0x5y3E", // class name
  bases__ZN3ccc7CC0x5y3E, 2,
  &(vtc__ZN3ccc7CC0x5y3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x5y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x5y3E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x5y4  : ::ccc::AA0 , ::ccc::BB5 {
  virtual void  pqr(); // _ZN3ccc7CC0x5y43pqrEv
  virtual void  abc(); // _ZN3ccc7CC0x5y43abcEv
  virtual void  efg(); // _ZN3ccc7CC0x5y43efgEv
  ~CC0x5y4(); // tgen
  CC0x5y4(); // tgen
};
//SIG(1 _ZN3ccc7CC0x5y4E) C1{ BC2{ v2 v3 v1} BC3{ v1 v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x5y4 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x5y43pqrEv");}
void  ccc::CC0x5y4 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x5y43abcEv");}
void  ccc::CC0x5y4 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x5y43efgEv");}
ccc::CC0x5y4 ::~CC0x5y4(){ note_dtor("_ZN3ccc7CC0x5y4E", this);} // tgen
ccc::CC0x5y4 ::CC0x5y4(){ note_ctor("_ZN3ccc7CC0x5y4E", this);} // tgen
}
static void Test__ZN3ccc7CC0x5y4E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x5y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x5y4E, buf);
    ::ccc::CC0x5y4 *dp, &lv = *(dp=new (buf) ::ccc::CC0x5y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x5y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x5y4E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x5y4E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc7CC0x5y4E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x5y4E);
    dp->::ccc::CC0x5y4::~CC0x5y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x5y4E(Test__ZN3ccc7CC0x5y4E, "_ZN3ccc7CC0x5y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x5y4C1Ev();
extern void _ZN3ccc7CC0x5y4D1Ev();
Name_Map name_map__ZN3ccc7CC0x5y4E[] = {
  NSPAIR(_ZN3ccc7CC0x5y4C1Ev),
  NSPAIR(_ZN3ccc7CC0x5y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7CC0x5y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x5y4E[];
extern void _ZN3ccc7CC0x5y43abcEv();
extern void _ZN3ccc7CC0x5y43efgEv();
extern void _ZN3ccc7CC0x5y43pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x5y43pqrEv,_ZThn4_N3ccc7CC0x5y43pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x5y43efgEv,_ZThn4_N3ccc7CC0x5y43efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x5y43abcEv,_ZThn4_N3ccc7CC0x5y43abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x5y4E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x5y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x5y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x5y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x5y43pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x5y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x5y43pqrEv,_ZThn4_N3ccc7CC0x5y43pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x5y43efgEv,_ZThn4_N3ccc7CC0x5y43efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x5y43abcEv,_ZThn4_N3ccc7CC0x5y43abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x5y4E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x5y4E[];
Class_Descriptor cd__ZN3ccc7CC0x5y4E = {  "_ZN3ccc7CC0x5y4E", // class name
  bases__ZN3ccc7CC0x5y4E, 2,
  &(vtc__ZN3ccc7CC0x5y4E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x5y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x5y4E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x5y5  : ::ccc::AA0 , ::ccc::BB5 {
  virtual void  pqr(); // _ZN3ccc7CC0x5y53pqrEv
  virtual void  efg(); // _ZN3ccc7CC0x5y53efgEv
  virtual void  abc(); // _ZN3ccc7CC0x5y53abcEv
  ~CC0x5y5(); // tgen
  CC0x5y5(); // tgen
};
//SIG(1 _ZN3ccc7CC0x5y5E) C1{ BC2{ v3 v2 v1} BC3{ v1 v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x5y5 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x5y53pqrEv");}
void  ccc::CC0x5y5 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x5y53efgEv");}
void  ccc::CC0x5y5 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x5y53abcEv");}
ccc::CC0x5y5 ::~CC0x5y5(){ note_dtor("_ZN3ccc7CC0x5y5E", this);} // tgen
ccc::CC0x5y5 ::CC0x5y5(){ note_ctor("_ZN3ccc7CC0x5y5E", this);} // tgen
}
static void Test__ZN3ccc7CC0x5y5E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x5y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x5y5E, buf);
    ::ccc::CC0x5y5 *dp, &lv = *(dp=new (buf) ::ccc::CC0x5y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x5y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x5y5E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x5y5E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc7CC0x5y5E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x5y5E);
    dp->::ccc::CC0x5y5::~CC0x5y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x5y5E(Test__ZN3ccc7CC0x5y5E, "_ZN3ccc7CC0x5y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x5y5C1Ev();
extern void _ZN3ccc7CC0x5y5D1Ev();
Name_Map name_map__ZN3ccc7CC0x5y5E[] = {
  NSPAIR(_ZN3ccc7CC0x5y5C1Ev),
  NSPAIR(_ZN3ccc7CC0x5y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7CC0x5y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x5y5E[];
extern void _ZN3ccc7CC0x5y53abcEv();
extern void _ZN3ccc7CC0x5y53efgEv();
extern void _ZN3ccc7CC0x5y53pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x5y53pqrEv,_ZThn4_N3ccc7CC0x5y53pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x5y53efgEv,_ZThn4_N3ccc7CC0x5y53efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x5y53abcEv,_ZThn4_N3ccc7CC0x5y53abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x5y5E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x5y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x5y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x5y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x5y53pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x5y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x5y53pqrEv,_ZThn4_N3ccc7CC0x5y53pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x5y53efgEv,_ZThn4_N3ccc7CC0x5y53efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x5y53abcEv,_ZThn4_N3ccc7CC0x5y53abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x5y5E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x5y5E[];
Class_Descriptor cd__ZN3ccc7CC0x5y5E = {  "_ZN3ccc7CC0x5y5E", // class name
  bases__ZN3ccc7CC0x5y5E, 2,
  &(vtc__ZN3ccc7CC0x5y5E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x5y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x5y5E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x5y6  : ::ccc::AA0 , ::ccc::BB5 {
  virtual void  abc(); // _ZN3ccc7CC0x5y63abcEv
  virtual void  efg(); // _ZN3ccc7CC0x5y63efgEv
  ~CC0x5y6(); // tgen
  CC0x5y6(); // tgen
};
//SIG(1 _ZN3ccc7CC0x5y6E) C1{ BC2{ v1 v2 v3} BC3{ v4 v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x5y6 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x5y63abcEv");}
void  ccc::CC0x5y6 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x5y63efgEv");}
ccc::CC0x5y6 ::~CC0x5y6(){ note_dtor("_ZN3ccc7CC0x5y6E", this);} // tgen
ccc::CC0x5y6 ::CC0x5y6(){ note_ctor("_ZN3ccc7CC0x5y6E", this);} // tgen
}
static void Test__ZN3ccc7CC0x5y6E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x5y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x5y6E, buf);
    ::ccc::CC0x5y6 *dp, &lv = *(dp=new (buf) ::ccc::CC0x5y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x5y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x5y6E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x5y6E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc7CC0x5y6E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x5y6E);
    dp->::ccc::CC0x5y6::~CC0x5y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x5y6E(Test__ZN3ccc7CC0x5y6E, "_ZN3ccc7CC0x5y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x5y6C1Ev();
extern void _ZN3ccc7CC0x5y6D1Ev();
Name_Map name_map__ZN3ccc7CC0x5y6E[] = {
  NSPAIR(_ZN3ccc7CC0x5y6C1Ev),
  NSPAIR(_ZN3ccc7CC0x5y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7CC0x5y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x5y6E[];
extern void _ZN3ccc7CC0x5y63abcEv();
extern void _ZN3ccc7CC0x5y63efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc3BB53pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x5y63efgEv,_ZThn4_N3ccc7CC0x5y63efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x5y63abcEv,_ZThn4_N3ccc7CC0x5y63abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x5y6E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x5y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x5y63abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x5y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x5y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB53pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x5y63efgEv,_ZThn4_N3ccc7CC0x5y63efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x5y63abcEv,_ZThn4_N3ccc7CC0x5y63abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x5y6E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x5y6E[];
Class_Descriptor cd__ZN3ccc7CC0x5y6E = {  "_ZN3ccc7CC0x5y6E", // class name
  bases__ZN3ccc7CC0x5y6E, 2,
  &(vtc__ZN3ccc7CC0x5y6E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x5y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x5y6E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x5y7  : ::ccc::AA0 , ::ccc::BB5 {
  virtual void  abc(); // _ZN3ccc7CC0x5y73abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x5y73pqrEv
  ~CC0x5y7(); // tgen
  CC0x5y7(); // tgen
};
//SIG(1 _ZN3ccc7CC0x5y7E) C1{ BC2{ v1 v3 v2} BC3{ v2 v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x5y7 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x5y73abcEv");}
void  ccc::CC0x5y7 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x5y73pqrEv");}
ccc::CC0x5y7 ::~CC0x5y7(){ note_dtor("_ZN3ccc7CC0x5y7E", this);} // tgen
ccc::CC0x5y7 ::CC0x5y7(){ note_ctor("_ZN3ccc7CC0x5y7E", this);} // tgen
}
static void Test__ZN3ccc7CC0x5y7E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x5y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x5y7E, buf);
    ::ccc::CC0x5y7 *dp, &lv = *(dp=new (buf) ::ccc::CC0x5y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x5y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x5y7E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x5y7E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc7CC0x5y7E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x5y7E);
    dp->::ccc::CC0x5y7::~CC0x5y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x5y7E(Test__ZN3ccc7CC0x5y7E, "_ZN3ccc7CC0x5y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x5y7C1Ev();
extern void _ZN3ccc7CC0x5y7D1Ev();
Name_Map name_map__ZN3ccc7CC0x5y7E[] = {
  NSPAIR(_ZN3ccc7CC0x5y7C1Ev),
  NSPAIR(_ZN3ccc7CC0x5y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7CC0x5y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x5y7E[];
extern void _ZN3ccc7CC0x5y73abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc7CC0x5y73pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x5y73pqrEv,_ZThn4_N3ccc7CC0x5y73pqrEv)();
extern void _ZN3ccc3BB53efgEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x5y73abcEv,_ZThn4_N3ccc7CC0x5y73abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x5y7E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x5y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x5y73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x5y73pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x5y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x5y73pqrEv,_ZThn4_N3ccc7CC0x5y73pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3BB53efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x5y73abcEv,_ZThn4_N3ccc7CC0x5y73abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x5y7E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x5y7E[];
Class_Descriptor cd__ZN3ccc7CC0x5y7E = {  "_ZN3ccc7CC0x5y7E", // class name
  bases__ZN3ccc7CC0x5y7E, 2,
  &(vtc__ZN3ccc7CC0x5y7E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x5y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x5y7E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x5y8  : ::ccc::AA0 , ::ccc::BB5 {
  virtual void  efg(); // _ZN3ccc7CC0x5y83efgEv
  virtual void  abc(); // _ZN3ccc7CC0x5y83abcEv
  ~CC0x5y8(); // tgen
  CC0x5y8(); // tgen
};
//SIG(1 _ZN3ccc7CC0x5y8E) C1{ BC2{ v2 v1 v3} BC3{ v4 v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x5y8 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x5y83efgEv");}
void  ccc::CC0x5y8 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x5y83abcEv");}
ccc::CC0x5y8 ::~CC0x5y8(){ note_dtor("_ZN3ccc7CC0x5y8E", this);} // tgen
ccc::CC0x5y8 ::CC0x5y8(){ note_ctor("_ZN3ccc7CC0x5y8E", this);} // tgen
}
static void Test__ZN3ccc7CC0x5y8E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x5y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x5y8E, buf);
    ::ccc::CC0x5y8 *dp, &lv = *(dp=new (buf) ::ccc::CC0x5y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x5y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x5y8E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x5y8E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc7CC0x5y8E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x5y8E);
    dp->::ccc::CC0x5y8::~CC0x5y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x5y8E(Test__ZN3ccc7CC0x5y8E, "_ZN3ccc7CC0x5y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x5y8C1Ev();
extern void _ZN3ccc7CC0x5y8D1Ev();
Name_Map name_map__ZN3ccc7CC0x5y8E[] = {
  NSPAIR(_ZN3ccc7CC0x5y8C1Ev),
  NSPAIR(_ZN3ccc7CC0x5y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7CC0x5y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x5y8E[];
extern void _ZN3ccc7CC0x5y83abcEv();
extern void _ZN3ccc7CC0x5y83efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc3BB53pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x5y83efgEv,_ZThn4_N3ccc7CC0x5y83efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x5y83abcEv,_ZThn4_N3ccc7CC0x5y83abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x5y8E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x5y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x5y83abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x5y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x5y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB53pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x5y83efgEv,_ZThn4_N3ccc7CC0x5y83efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x5y83abcEv,_ZThn4_N3ccc7CC0x5y83abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x5y8E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x5y8E[];
Class_Descriptor cd__ZN3ccc7CC0x5y8E = {  "_ZN3ccc7CC0x5y8E", // class name
  bases__ZN3ccc7CC0x5y8E, 2,
  &(vtc__ZN3ccc7CC0x5y8E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x5y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x5y8E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x5y9  : ::ccc::AA0 , ::ccc::BB5 {
  virtual void  efg(); // _ZN3ccc7CC0x5y93efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x5y93pqrEv
  ~CC0x5y9(); // tgen
  CC0x5y9(); // tgen
};
//SIG(1 _ZN3ccc7CC0x5y9E) C1{ BC2{ v3 v1 v2} BC3{ v2 v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x5y9 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x5y93efgEv");}
void  ccc::CC0x5y9 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x5y93pqrEv");}
ccc::CC0x5y9 ::~CC0x5y9(){ note_dtor("_ZN3ccc7CC0x5y9E", this);} // tgen
ccc::CC0x5y9 ::CC0x5y9(){ note_ctor("_ZN3ccc7CC0x5y9E", this);} // tgen
}
static void Test__ZN3ccc7CC0x5y9E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x5y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x5y9E, buf);
    ::ccc::CC0x5y9 *dp, &lv = *(dp=new (buf) ::ccc::CC0x5y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x5y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x5y9E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x5y9E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc7CC0x5y9E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x5y9E);
    dp->::ccc::CC0x5y9::~CC0x5y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x5y9E(Test__ZN3ccc7CC0x5y9E, "_ZN3ccc7CC0x5y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x5y9C1Ev();
extern void _ZN3ccc7CC0x5y9D1Ev();
Name_Map name_map__ZN3ccc7CC0x5y9E[] = {
  NSPAIR(_ZN3ccc7CC0x5y9C1Ev),
  NSPAIR(_ZN3ccc7CC0x5y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc7CC0x5y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x5y9E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc7CC0x5y93efgEv();
extern void _ZN3ccc7CC0x5y93pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x5y93pqrEv,_ZThn4_N3ccc7CC0x5y93pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x5y93efgEv,_ZThn4_N3ccc7CC0x5y93efgEv)();
extern void _ZN3ccc3BB53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x5y9E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x5y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x5y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x5y93pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x5y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x5y93pqrEv,_ZThn4_N3ccc7CC0x5y93pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x5y93efgEv,_ZThn4_N3ccc7CC0x5y93efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB53abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x5y9E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x5y9E[];
Class_Descriptor cd__ZN3ccc7CC0x5y9E = {  "_ZN3ccc7CC0x5y9E", // class name
  bases__ZN3ccc7CC0x5y9E, 2,
  &(vtc__ZN3ccc7CC0x5y9E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x5y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x5y9E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x5y10  : ::ccc::AA0 , ::ccc::BB5 {
  virtual void  pqr(); // _ZN3ccc8CC0x5y103pqrEv
  virtual void  abc(); // _ZN3ccc8CC0x5y103abcEv
  ~CC0x5y10(); // tgen
  CC0x5y10(); // tgen
};
//SIG(1 _ZN3ccc8CC0x5y10E) C1{ BC2{ v2 v3 v1} BC3{ v1 v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x5y10 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x5y103pqrEv");}
void  ccc::CC0x5y10 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x5y103abcEv");}
ccc::CC0x5y10 ::~CC0x5y10(){ note_dtor("_ZN3ccc8CC0x5y10E", this);} // tgen
ccc::CC0x5y10 ::CC0x5y10(){ note_ctor("_ZN3ccc8CC0x5y10E", this);} // tgen
}
static void Test__ZN3ccc8CC0x5y10E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x5y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x5y10E, buf);
    ::ccc::CC0x5y10 *dp, &lv = *(dp=new (buf) ::ccc::CC0x5y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x5y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x5y10E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x5y10E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc8CC0x5y10E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x5y10E);
    dp->::ccc::CC0x5y10::~CC0x5y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x5y10E(Test__ZN3ccc8CC0x5y10E, "_ZN3ccc8CC0x5y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x5y10C1Ev();
extern void _ZN3ccc8CC0x5y10D1Ev();
Name_Map name_map__ZN3ccc8CC0x5y10E[] = {
  NSPAIR(_ZN3ccc8CC0x5y10C1Ev),
  NSPAIR(_ZN3ccc8CC0x5y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc8CC0x5y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x5y10E[];
extern void _ZN3ccc8CC0x5y103abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc8CC0x5y103pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x5y103pqrEv,_ZThn4_N3ccc8CC0x5y103pqrEv)();
extern void _ZN3ccc3BB53efgEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x5y103abcEv,_ZThn4_N3ccc8CC0x5y103abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x5y10E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x5y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x5y103abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x5y103pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x5y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x5y103pqrEv,_ZThn4_N3ccc8CC0x5y103pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3BB53efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x5y103abcEv,_ZThn4_N3ccc8CC0x5y103abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x5y10E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x5y10E[];
Class_Descriptor cd__ZN3ccc8CC0x5y10E = {  "_ZN3ccc8CC0x5y10E", // class name
  bases__ZN3ccc8CC0x5y10E, 2,
  &(vtc__ZN3ccc8CC0x5y10E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x5y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x5y10E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x5y11  : ::ccc::AA0 , ::ccc::BB5 {
  virtual void  pqr(); // _ZN3ccc8CC0x5y113pqrEv
  virtual void  efg(); // _ZN3ccc8CC0x5y113efgEv
  ~CC0x5y11(); // tgen
  CC0x5y11(); // tgen
};
//SIG(1 _ZN3ccc8CC0x5y11E) C1{ BC2{ v3 v2 v1} BC3{ v1 v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x5y11 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x5y113pqrEv");}
void  ccc::CC0x5y11 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x5y113efgEv");}
ccc::CC0x5y11 ::~CC0x5y11(){ note_dtor("_ZN3ccc8CC0x5y11E", this);} // tgen
ccc::CC0x5y11 ::CC0x5y11(){ note_ctor("_ZN3ccc8CC0x5y11E", this);} // tgen
}
static void Test__ZN3ccc8CC0x5y11E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x5y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x5y11E, buf);
    ::ccc::CC0x5y11 *dp, &lv = *(dp=new (buf) ::ccc::CC0x5y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x5y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x5y11E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x5y11E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc8CC0x5y11E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x5y11E);
    dp->::ccc::CC0x5y11::~CC0x5y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x5y11E(Test__ZN3ccc8CC0x5y11E, "_ZN3ccc8CC0x5y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x5y11C1Ev();
extern void _ZN3ccc8CC0x5y11D1Ev();
Name_Map name_map__ZN3ccc8CC0x5y11E[] = {
  NSPAIR(_ZN3ccc8CC0x5y11C1Ev),
  NSPAIR(_ZN3ccc8CC0x5y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc8CC0x5y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x5y11E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc8CC0x5y113efgEv();
extern void _ZN3ccc8CC0x5y113pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x5y113pqrEv,_ZThn4_N3ccc8CC0x5y113pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC0x5y113efgEv,_ZThn4_N3ccc8CC0x5y113efgEv)();
extern void _ZN3ccc3BB53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x5y11E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x5y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x5y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x5y113pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x5y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x5y113pqrEv,_ZThn4_N3ccc8CC0x5y113pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x5y113efgEv,_ZThn4_N3ccc8CC0x5y113efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB53abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x5y11E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x5y11E[];
Class_Descriptor cd__ZN3ccc8CC0x5y11E = {  "_ZN3ccc8CC0x5y11E", // class name
  bases__ZN3ccc8CC0x5y11E, 2,
  &(vtc__ZN3ccc8CC0x5y11E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x5y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x5y11E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x5y12  : ::ccc::AA0 , ::ccc::BB5 {
  virtual void  abc(); // _ZN3ccc8CC0x5y123abcEv
  ~CC0x5y12(); // tgen
  CC0x5y12(); // tgen
};
//SIG(1 _ZN3ccc8CC0x5y12E) C1{ BC2{ v1 v2 v3} BC3{ v4 v5 v1} v1}
}
namespace ccc { 
void  ccc::CC0x5y12 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x5y123abcEv");}
ccc::CC0x5y12 ::~CC0x5y12(){ note_dtor("_ZN3ccc8CC0x5y12E", this);} // tgen
ccc::CC0x5y12 ::CC0x5y12(){ note_ctor("_ZN3ccc8CC0x5y12E", this);} // tgen
}
static void Test__ZN3ccc8CC0x5y12E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x5y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x5y12E, buf);
    ::ccc::CC0x5y12 *dp, &lv = *(dp=new (buf) ::ccc::CC0x5y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x5y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x5y12E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x5y12E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc8CC0x5y12E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x5y12E);
    dp->::ccc::CC0x5y12::~CC0x5y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x5y12E(Test__ZN3ccc8CC0x5y12E, "_ZN3ccc8CC0x5y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x5y12C1Ev();
extern void _ZN3ccc8CC0x5y12D1Ev();
Name_Map name_map__ZN3ccc8CC0x5y12E[] = {
  NSPAIR(_ZN3ccc8CC0x5y12C1Ev),
  NSPAIR(_ZN3ccc8CC0x5y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc8CC0x5y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x5y12E[];
extern void _ZN3ccc8CC0x5y123abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc3BB53pqrEv();
extern void _ZN3ccc3BB53efgEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x5y123abcEv,_ZThn4_N3ccc8CC0x5y123abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x5y12E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x5y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x5y123abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x5y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB53efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x5y123abcEv,_ZThn4_N3ccc8CC0x5y123abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x5y12E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x5y12E[];
Class_Descriptor cd__ZN3ccc8CC0x5y12E = {  "_ZN3ccc8CC0x5y12E", // class name
  bases__ZN3ccc8CC0x5y12E, 2,
  &(vtc__ZN3ccc8CC0x5y12E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x5y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x5y12E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x5y13  : ::ccc::AA0 , ::ccc::BB5 {
  virtual void  efg(); // _ZN3ccc8CC0x5y133efgEv
  ~CC0x5y13(); // tgen
  CC0x5y13(); // tgen
};
//SIG(1 _ZN3ccc8CC0x5y13E) C1{ BC2{ v2 v1 v3} BC3{ v4 v1 v5} v1}
}
namespace ccc { 
void  ccc::CC0x5y13 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x5y133efgEv");}
ccc::CC0x5y13 ::~CC0x5y13(){ note_dtor("_ZN3ccc8CC0x5y13E", this);} // tgen
ccc::CC0x5y13 ::CC0x5y13(){ note_ctor("_ZN3ccc8CC0x5y13E", this);} // tgen
}
static void Test__ZN3ccc8CC0x5y13E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x5y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x5y13E, buf);
    ::ccc::CC0x5y13 *dp, &lv = *(dp=new (buf) ::ccc::CC0x5y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x5y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x5y13E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x5y13E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc8CC0x5y13E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x5y13E);
    dp->::ccc::CC0x5y13::~CC0x5y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x5y13E(Test__ZN3ccc8CC0x5y13E, "_ZN3ccc8CC0x5y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x5y13C1Ev();
extern void _ZN3ccc8CC0x5y13D1Ev();
Name_Map name_map__ZN3ccc8CC0x5y13E[] = {
  NSPAIR(_ZN3ccc8CC0x5y13C1Ev),
  NSPAIR(_ZN3ccc8CC0x5y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc8CC0x5y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x5y13E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc8CC0x5y133efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc3BB53pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x5y133efgEv,_ZThn4_N3ccc8CC0x5y133efgEv)();
extern void _ZN3ccc3BB53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x5y13E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x5y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x5y133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x5y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB53pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x5y133efgEv,_ZThn4_N3ccc8CC0x5y133efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB53abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x5y13E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x5y13E[];
Class_Descriptor cd__ZN3ccc8CC0x5y13E = {  "_ZN3ccc8CC0x5y13E", // class name
  bases__ZN3ccc8CC0x5y13E, 2,
  &(vtc__ZN3ccc8CC0x5y13E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x5y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x5y13E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x5y14  : ::ccc::AA0 , ::ccc::BB5 {
  virtual void  pqr(); // _ZN3ccc8CC0x5y143pqrEv
  ~CC0x5y14(); // tgen
  CC0x5y14(); // tgen
};
//SIG(1 _ZN3ccc8CC0x5y14E) C1{ BC2{ v2 v3 v1} BC3{ v1 v4 v5} v1}
}
namespace ccc { 
void  ccc::CC0x5y14 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x5y143pqrEv");}
ccc::CC0x5y14 ::~CC0x5y14(){ note_dtor("_ZN3ccc8CC0x5y14E", this);} // tgen
ccc::CC0x5y14 ::CC0x5y14(){ note_ctor("_ZN3ccc8CC0x5y14E", this);} // tgen
}
static void Test__ZN3ccc8CC0x5y14E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x5y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x5y14E, buf);
    ::ccc::CC0x5y14 *dp, &lv = *(dp=new (buf) ::ccc::CC0x5y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x5y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x5y14E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x5y14E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc8CC0x5y14E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x5y14E);
    dp->::ccc::CC0x5y14::~CC0x5y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x5y14E(Test__ZN3ccc8CC0x5y14E, "_ZN3ccc8CC0x5y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x5y14C1Ev();
extern void _ZN3ccc8CC0x5y14D1Ev();
Name_Map name_map__ZN3ccc8CC0x5y14E[] = {
  NSPAIR(_ZN3ccc8CC0x5y14C1Ev),
  NSPAIR(_ZN3ccc8CC0x5y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc8CC0x5y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x5y14E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc8CC0x5y143pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x5y143pqrEv,_ZThn4_N3ccc8CC0x5y143pqrEv)();
extern void _ZN3ccc3BB53efgEv();
extern void _ZN3ccc3BB53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x5y14E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x5y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x5y143pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x5y14E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x5y143pqrEv,_ZThn4_N3ccc8CC0x5y143pqrEv),
  (VTBL_ENTRY)&_ZN3ccc3BB53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB53abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x5y14E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x5y14E[];
Class_Descriptor cd__ZN3ccc8CC0x5y14E = {  "_ZN3ccc8CC0x5y14E", // class name
  bases__ZN3ccc8CC0x5y14E, 2,
  &(vtc__ZN3ccc8CC0x5y14E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x5y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x5y14E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x5y15  : ::ccc::AA0 , ::ccc::BB5 {
  ~CC0x5y15(); // tgen
  CC0x5y15(); // tgen
};
//SIG(1 _ZN3ccc8CC0x5y15E) C1{ BC2{ v1 v2 v3} BC3{ v4 v5 v6}}
}
namespace ccc { 
ccc::CC0x5y15 ::~CC0x5y15(){ note_dtor("_ZN3ccc8CC0x5y15E", this);} // tgen
ccc::CC0x5y15 ::CC0x5y15(){ note_ctor("_ZN3ccc8CC0x5y15E", this);} // tgen
}
static void Test__ZN3ccc8CC0x5y15E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x5y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x5y15E, buf);
    ::ccc::CC0x5y15 *dp, &lv = *(dp=new (buf) ::ccc::CC0x5y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x5y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x5y15E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x5y15E");
    check_base_class_offset(lv, (::ccc::BB5*), ABISELECT(8,4), "_ZN3ccc8CC0x5y15E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x5y15E);
    dp->::ccc::CC0x5y15::~CC0x5y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x5y15E(Test__ZN3ccc8CC0x5y15E, "_ZN3ccc8CC0x5y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x5y15C1Ev();
extern void _ZN3ccc8CC0x5y15D1Ev();
Name_Map name_map__ZN3ccc8CC0x5y15E[] = {
  NSPAIR(_ZN3ccc8CC0x5y15C1Ev),
  NSPAIR(_ZN3ccc8CC0x5y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB5E;
extern VTBL_ENTRY _ZTIN3ccc3BB5E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB5E[];
static Base_Class bases__ZN3ccc8CC0x5y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB5E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x5y15E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc3BB53pqrEv();
extern void _ZN3ccc3BB53efgEv();
extern void _ZN3ccc3BB53abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x5y15E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x5y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x5y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB53pqrEv,
  (VTBL_ENTRY)&_ZN3ccc3BB53efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB53abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x5y15E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x5y15E[];
Class_Descriptor cd__ZN3ccc8CC0x5y15E = {  "_ZN3ccc8CC0x5y15E", // class name
  bases__ZN3ccc8CC0x5y15E, 2,
  &(vtc__ZN3ccc8CC0x5y15E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x5y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x5y15E),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x6y0  : ::ccc::AA0 , ::ccc::BB6 {
  virtual void  abc(); // _ZN3ccc7CC0x6y03abcEv
  virtual void  efg(); // _ZN3ccc7CC0x6y03efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x6y03pqrEv
  ~CC0x6y0(); // tgen
  CC0x6y0(); // tgen
};
//SIG(1 _ZN3ccc7CC0x6y0E) C1{ BC2{ v1 v2 v3} BC3{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x6y0 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x6y03abcEv");}
void  ccc::CC0x6y0 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x6y03efgEv");}
void  ccc::CC0x6y0 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x6y03pqrEv");}
ccc::CC0x6y0 ::~CC0x6y0(){ note_dtor("_ZN3ccc7CC0x6y0E", this);} // tgen
ccc::CC0x6y0 ::CC0x6y0(){ note_ctor("_ZN3ccc7CC0x6y0E", this);} // tgen
}
static void Test__ZN3ccc7CC0x6y0E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x6y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x6y0E, buf);
    ::ccc::CC0x6y0 *dp, &lv = *(dp=new (buf) ::ccc::CC0x6y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x6y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x6y0E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x6y0E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc7CC0x6y0E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x6y0E);
    dp->::ccc::CC0x6y0::~CC0x6y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x6y0E(Test__ZN3ccc7CC0x6y0E, "_ZN3ccc7CC0x6y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x6y0C1Ev();
extern void _ZN3ccc7CC0x6y0D1Ev();
Name_Map name_map__ZN3ccc7CC0x6y0E[] = {
  NSPAIR(_ZN3ccc7CC0x6y0C1Ev),
  NSPAIR(_ZN3ccc7CC0x6y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7CC0x6y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x6y0E[];
extern void _ZN3ccc7CC0x6y03abcEv();
extern void _ZN3ccc7CC0x6y03efgEv();
extern void _ZN3ccc7CC0x6y03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x6y03abcEv,_ZThn4_N3ccc7CC0x6y03abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x6y03efgEv,_ZThn4_N3ccc7CC0x6y03efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x6y0E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x6y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x6y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x6y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x6y03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x6y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x6y03abcEv,_ZThn4_N3ccc7CC0x6y03abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x6y03efgEv,_ZThn4_N3ccc7CC0x6y03efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x6y0E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x6y0E[];
Class_Descriptor cd__ZN3ccc7CC0x6y0E = {  "_ZN3ccc7CC0x6y0E", // class name
  bases__ZN3ccc7CC0x6y0E, 2,
  &(vtc__ZN3ccc7CC0x6y0E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x6y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x6y0E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x6y1  : ::ccc::AA0 , ::ccc::BB6 {
  virtual void  abc(); // _ZN3ccc7CC0x6y13abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x6y13pqrEv
  virtual void  efg(); // _ZN3ccc7CC0x6y13efgEv
  ~CC0x6y1(); // tgen
  CC0x6y1(); // tgen
};
//SIG(1 _ZN3ccc7CC0x6y1E) C1{ BC2{ v1 v3 v2} BC3{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x6y1 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x6y13abcEv");}
void  ccc::CC0x6y1 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x6y13pqrEv");}
void  ccc::CC0x6y1 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x6y13efgEv");}
ccc::CC0x6y1 ::~CC0x6y1(){ note_dtor("_ZN3ccc7CC0x6y1E", this);} // tgen
ccc::CC0x6y1 ::CC0x6y1(){ note_ctor("_ZN3ccc7CC0x6y1E", this);} // tgen
}
static void Test__ZN3ccc7CC0x6y1E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x6y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x6y1E, buf);
    ::ccc::CC0x6y1 *dp, &lv = *(dp=new (buf) ::ccc::CC0x6y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x6y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x6y1E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x6y1E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc7CC0x6y1E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x6y1E);
    dp->::ccc::CC0x6y1::~CC0x6y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x6y1E(Test__ZN3ccc7CC0x6y1E, "_ZN3ccc7CC0x6y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x6y1C1Ev();
extern void _ZN3ccc7CC0x6y1D1Ev();
Name_Map name_map__ZN3ccc7CC0x6y1E[] = {
  NSPAIR(_ZN3ccc7CC0x6y1C1Ev),
  NSPAIR(_ZN3ccc7CC0x6y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7CC0x6y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x6y1E[];
extern void _ZN3ccc7CC0x6y13abcEv();
extern void _ZN3ccc7CC0x6y13efgEv();
extern void _ZN3ccc7CC0x6y13pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x6y13abcEv,_ZThn4_N3ccc7CC0x6y13abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x6y13efgEv,_ZThn4_N3ccc7CC0x6y13efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x6y1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x6y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x6y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x6y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x6y13pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x6y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x6y13abcEv,_ZThn4_N3ccc7CC0x6y13abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x6y13efgEv,_ZThn4_N3ccc7CC0x6y13efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x6y1E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x6y1E[];
Class_Descriptor cd__ZN3ccc7CC0x6y1E = {  "_ZN3ccc7CC0x6y1E", // class name
  bases__ZN3ccc7CC0x6y1E, 2,
  &(vtc__ZN3ccc7CC0x6y1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x6y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x6y1E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x6y2  : ::ccc::AA0 , ::ccc::BB6 {
  virtual void  efg(); // _ZN3ccc7CC0x6y23efgEv
  virtual void  abc(); // _ZN3ccc7CC0x6y23abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x6y23pqrEv
  ~CC0x6y2(); // tgen
  CC0x6y2(); // tgen
};
//SIG(1 _ZN3ccc7CC0x6y2E) C1{ BC2{ v2 v1 v3} BC3{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x6y2 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x6y23efgEv");}
void  ccc::CC0x6y2 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x6y23abcEv");}
void  ccc::CC0x6y2 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x6y23pqrEv");}
ccc::CC0x6y2 ::~CC0x6y2(){ note_dtor("_ZN3ccc7CC0x6y2E", this);} // tgen
ccc::CC0x6y2 ::CC0x6y2(){ note_ctor("_ZN3ccc7CC0x6y2E", this);} // tgen
}
static void Test__ZN3ccc7CC0x6y2E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x6y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x6y2E, buf);
    ::ccc::CC0x6y2 *dp, &lv = *(dp=new (buf) ::ccc::CC0x6y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x6y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x6y2E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x6y2E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc7CC0x6y2E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x6y2E);
    dp->::ccc::CC0x6y2::~CC0x6y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x6y2E(Test__ZN3ccc7CC0x6y2E, "_ZN3ccc7CC0x6y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x6y2C1Ev();
extern void _ZN3ccc7CC0x6y2D1Ev();
Name_Map name_map__ZN3ccc7CC0x6y2E[] = {
  NSPAIR(_ZN3ccc7CC0x6y2C1Ev),
  NSPAIR(_ZN3ccc7CC0x6y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7CC0x6y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x6y2E[];
extern void _ZN3ccc7CC0x6y23abcEv();
extern void _ZN3ccc7CC0x6y23efgEv();
extern void _ZN3ccc7CC0x6y23pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x6y23abcEv,_ZThn4_N3ccc7CC0x6y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x6y23efgEv,_ZThn4_N3ccc7CC0x6y23efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x6y2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x6y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x6y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x6y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x6y23pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x6y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x6y23abcEv,_ZThn4_N3ccc7CC0x6y23abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x6y23efgEv,_ZThn4_N3ccc7CC0x6y23efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x6y2E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x6y2E[];
Class_Descriptor cd__ZN3ccc7CC0x6y2E = {  "_ZN3ccc7CC0x6y2E", // class name
  bases__ZN3ccc7CC0x6y2E, 2,
  &(vtc__ZN3ccc7CC0x6y2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x6y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x6y2E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x6y3  : ::ccc::AA0 , ::ccc::BB6 {
  virtual void  efg(); // _ZN3ccc7CC0x6y33efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x6y33pqrEv
  virtual void  abc(); // _ZN3ccc7CC0x6y33abcEv
  ~CC0x6y3(); // tgen
  CC0x6y3(); // tgen
};
//SIG(1 _ZN3ccc7CC0x6y3E) C1{ BC2{ v3 v1 v2} BC3{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x6y3 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x6y33efgEv");}
void  ccc::CC0x6y3 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x6y33pqrEv");}
void  ccc::CC0x6y3 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x6y33abcEv");}
ccc::CC0x6y3 ::~CC0x6y3(){ note_dtor("_ZN3ccc7CC0x6y3E", this);} // tgen
ccc::CC0x6y3 ::CC0x6y3(){ note_ctor("_ZN3ccc7CC0x6y3E", this);} // tgen
}
static void Test__ZN3ccc7CC0x6y3E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x6y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x6y3E, buf);
    ::ccc::CC0x6y3 *dp, &lv = *(dp=new (buf) ::ccc::CC0x6y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x6y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x6y3E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x6y3E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc7CC0x6y3E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x6y3E);
    dp->::ccc::CC0x6y3::~CC0x6y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x6y3E(Test__ZN3ccc7CC0x6y3E, "_ZN3ccc7CC0x6y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x6y3C1Ev();
extern void _ZN3ccc7CC0x6y3D1Ev();
Name_Map name_map__ZN3ccc7CC0x6y3E[] = {
  NSPAIR(_ZN3ccc7CC0x6y3C1Ev),
  NSPAIR(_ZN3ccc7CC0x6y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7CC0x6y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x6y3E[];
extern void _ZN3ccc7CC0x6y33abcEv();
extern void _ZN3ccc7CC0x6y33efgEv();
extern void _ZN3ccc7CC0x6y33pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x6y33abcEv,_ZThn4_N3ccc7CC0x6y33abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x6y33efgEv,_ZThn4_N3ccc7CC0x6y33efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x6y3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x6y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x6y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x6y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x6y33pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x6y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x6y33abcEv,_ZThn4_N3ccc7CC0x6y33abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x6y33efgEv,_ZThn4_N3ccc7CC0x6y33efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x6y3E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x6y3E[];
Class_Descriptor cd__ZN3ccc7CC0x6y3E = {  "_ZN3ccc7CC0x6y3E", // class name
  bases__ZN3ccc7CC0x6y3E, 2,
  &(vtc__ZN3ccc7CC0x6y3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x6y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x6y3E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x6y4  : ::ccc::AA0 , ::ccc::BB6 {
  virtual void  pqr(); // _ZN3ccc7CC0x6y43pqrEv
  virtual void  abc(); // _ZN3ccc7CC0x6y43abcEv
  virtual void  efg(); // _ZN3ccc7CC0x6y43efgEv
  ~CC0x6y4(); // tgen
  CC0x6y4(); // tgen
};
//SIG(1 _ZN3ccc7CC0x6y4E) C1{ BC2{ v2 v3 v1} BC3{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x6y4 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x6y43pqrEv");}
void  ccc::CC0x6y4 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x6y43abcEv");}
void  ccc::CC0x6y4 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x6y43efgEv");}
ccc::CC0x6y4 ::~CC0x6y4(){ note_dtor("_ZN3ccc7CC0x6y4E", this);} // tgen
ccc::CC0x6y4 ::CC0x6y4(){ note_ctor("_ZN3ccc7CC0x6y4E", this);} // tgen
}
static void Test__ZN3ccc7CC0x6y4E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x6y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x6y4E, buf);
    ::ccc::CC0x6y4 *dp, &lv = *(dp=new (buf) ::ccc::CC0x6y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x6y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x6y4E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x6y4E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc7CC0x6y4E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x6y4E);
    dp->::ccc::CC0x6y4::~CC0x6y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x6y4E(Test__ZN3ccc7CC0x6y4E, "_ZN3ccc7CC0x6y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x6y4C1Ev();
extern void _ZN3ccc7CC0x6y4D1Ev();
Name_Map name_map__ZN3ccc7CC0x6y4E[] = {
  NSPAIR(_ZN3ccc7CC0x6y4C1Ev),
  NSPAIR(_ZN3ccc7CC0x6y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7CC0x6y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x6y4E[];
extern void _ZN3ccc7CC0x6y43abcEv();
extern void _ZN3ccc7CC0x6y43efgEv();
extern void _ZN3ccc7CC0x6y43pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x6y43abcEv,_ZThn4_N3ccc7CC0x6y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x6y43efgEv,_ZThn4_N3ccc7CC0x6y43efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x6y4E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x6y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x6y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x6y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x6y43pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x6y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x6y43abcEv,_ZThn4_N3ccc7CC0x6y43abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x6y43efgEv,_ZThn4_N3ccc7CC0x6y43efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x6y4E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x6y4E[];
Class_Descriptor cd__ZN3ccc7CC0x6y4E = {  "_ZN3ccc7CC0x6y4E", // class name
  bases__ZN3ccc7CC0x6y4E, 2,
  &(vtc__ZN3ccc7CC0x6y4E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x6y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x6y4E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x6y5  : ::ccc::AA0 , ::ccc::BB6 {
  virtual void  pqr(); // _ZN3ccc7CC0x6y53pqrEv
  virtual void  efg(); // _ZN3ccc7CC0x6y53efgEv
  virtual void  abc(); // _ZN3ccc7CC0x6y53abcEv
  ~CC0x6y5(); // tgen
  CC0x6y5(); // tgen
};
//SIG(1 _ZN3ccc7CC0x6y5E) C1{ BC2{ v3 v2 v1} BC3{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x6y5 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x6y53pqrEv");}
void  ccc::CC0x6y5 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x6y53efgEv");}
void  ccc::CC0x6y5 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x6y53abcEv");}
ccc::CC0x6y5 ::~CC0x6y5(){ note_dtor("_ZN3ccc7CC0x6y5E", this);} // tgen
ccc::CC0x6y5 ::CC0x6y5(){ note_ctor("_ZN3ccc7CC0x6y5E", this);} // tgen
}
static void Test__ZN3ccc7CC0x6y5E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x6y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x6y5E, buf);
    ::ccc::CC0x6y5 *dp, &lv = *(dp=new (buf) ::ccc::CC0x6y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x6y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x6y5E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x6y5E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc7CC0x6y5E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x6y5E);
    dp->::ccc::CC0x6y5::~CC0x6y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x6y5E(Test__ZN3ccc7CC0x6y5E, "_ZN3ccc7CC0x6y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x6y5C1Ev();
extern void _ZN3ccc7CC0x6y5D1Ev();
Name_Map name_map__ZN3ccc7CC0x6y5E[] = {
  NSPAIR(_ZN3ccc7CC0x6y5C1Ev),
  NSPAIR(_ZN3ccc7CC0x6y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7CC0x6y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x6y5E[];
extern void _ZN3ccc7CC0x6y53abcEv();
extern void _ZN3ccc7CC0x6y53efgEv();
extern void _ZN3ccc7CC0x6y53pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x6y53abcEv,_ZThn4_N3ccc7CC0x6y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x6y53efgEv,_ZThn4_N3ccc7CC0x6y53efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x6y5E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x6y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x6y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x6y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x6y53pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x6y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x6y53abcEv,_ZThn4_N3ccc7CC0x6y53abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x6y53efgEv,_ZThn4_N3ccc7CC0x6y53efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x6y5E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x6y5E[];
Class_Descriptor cd__ZN3ccc7CC0x6y5E = {  "_ZN3ccc7CC0x6y5E", // class name
  bases__ZN3ccc7CC0x6y5E, 2,
  &(vtc__ZN3ccc7CC0x6y5E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x6y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x6y5E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x6y6  : ::ccc::AA0 , ::ccc::BB6 {
  virtual void  abc(); // _ZN3ccc7CC0x6y63abcEv
  virtual void  efg(); // _ZN3ccc7CC0x6y63efgEv
  ~CC0x6y6(); // tgen
  CC0x6y6(); // tgen
};
//SIG(1 _ZN3ccc7CC0x6y6E) C1{ BC2{ v1 v2 v3} BC3{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x6y6 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x6y63abcEv");}
void  ccc::CC0x6y6 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x6y63efgEv");}
ccc::CC0x6y6 ::~CC0x6y6(){ note_dtor("_ZN3ccc7CC0x6y6E", this);} // tgen
ccc::CC0x6y6 ::CC0x6y6(){ note_ctor("_ZN3ccc7CC0x6y6E", this);} // tgen
}
static void Test__ZN3ccc7CC0x6y6E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x6y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x6y6E, buf);
    ::ccc::CC0x6y6 *dp, &lv = *(dp=new (buf) ::ccc::CC0x6y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x6y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x6y6E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x6y6E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc7CC0x6y6E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x6y6E);
    dp->::ccc::CC0x6y6::~CC0x6y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x6y6E(Test__ZN3ccc7CC0x6y6E, "_ZN3ccc7CC0x6y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x6y6C1Ev();
extern void _ZN3ccc7CC0x6y6D1Ev();
Name_Map name_map__ZN3ccc7CC0x6y6E[] = {
  NSPAIR(_ZN3ccc7CC0x6y6C1Ev),
  NSPAIR(_ZN3ccc7CC0x6y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7CC0x6y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x6y6E[];
extern void _ZN3ccc7CC0x6y63abcEv();
extern void _ZN3ccc7CC0x6y63efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x6y63abcEv,_ZThn4_N3ccc7CC0x6y63abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x6y63efgEv,_ZThn4_N3ccc7CC0x6y63efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x6y6E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x6y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x6y63abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x6y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x6y6E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x6y63abcEv,_ZThn4_N3ccc7CC0x6y63abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x6y63efgEv,_ZThn4_N3ccc7CC0x6y63efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x6y6E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x6y6E[];
Class_Descriptor cd__ZN3ccc7CC0x6y6E = {  "_ZN3ccc7CC0x6y6E", // class name
  bases__ZN3ccc7CC0x6y6E, 2,
  &(vtc__ZN3ccc7CC0x6y6E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x6y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x6y6E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x6y7  : ::ccc::AA0 , ::ccc::BB6 {
  virtual void  abc(); // _ZN3ccc7CC0x6y73abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x6y73pqrEv
  ~CC0x6y7(); // tgen
  CC0x6y7(); // tgen
};
//SIG(1 _ZN3ccc7CC0x6y7E) C1{ BC2{ v1 v3 v2} BC3{ v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x6y7 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x6y73abcEv");}
void  ccc::CC0x6y7 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x6y73pqrEv");}
ccc::CC0x6y7 ::~CC0x6y7(){ note_dtor("_ZN3ccc7CC0x6y7E", this);} // tgen
ccc::CC0x6y7 ::CC0x6y7(){ note_ctor("_ZN3ccc7CC0x6y7E", this);} // tgen
}
static void Test__ZN3ccc7CC0x6y7E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x6y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x6y7E, buf);
    ::ccc::CC0x6y7 *dp, &lv = *(dp=new (buf) ::ccc::CC0x6y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x6y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x6y7E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x6y7E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc7CC0x6y7E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x6y7E);
    dp->::ccc::CC0x6y7::~CC0x6y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x6y7E(Test__ZN3ccc7CC0x6y7E, "_ZN3ccc7CC0x6y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x6y7C1Ev();
extern void _ZN3ccc7CC0x6y7D1Ev();
Name_Map name_map__ZN3ccc7CC0x6y7E[] = {
  NSPAIR(_ZN3ccc7CC0x6y7C1Ev),
  NSPAIR(_ZN3ccc7CC0x6y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7CC0x6y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x6y7E[];
extern void _ZN3ccc7CC0x6y73abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc7CC0x6y73pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x6y73abcEv,_ZThn4_N3ccc7CC0x6y73abcEv)();
extern void _ZN3ccc3BB63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x6y7E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x6y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x6y73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x6y73pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x6y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x6y73abcEv,_ZThn4_N3ccc7CC0x6y73abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x6y7E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x6y7E[];
Class_Descriptor cd__ZN3ccc7CC0x6y7E = {  "_ZN3ccc7CC0x6y7E", // class name
  bases__ZN3ccc7CC0x6y7E, 2,
  &(vtc__ZN3ccc7CC0x6y7E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x6y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x6y7E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x6y8  : ::ccc::AA0 , ::ccc::BB6 {
  virtual void  efg(); // _ZN3ccc7CC0x6y83efgEv
  virtual void  abc(); // _ZN3ccc7CC0x6y83abcEv
  ~CC0x6y8(); // tgen
  CC0x6y8(); // tgen
};
//SIG(1 _ZN3ccc7CC0x6y8E) C1{ BC2{ v2 v1 v3} BC3{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x6y8 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x6y83efgEv");}
void  ccc::CC0x6y8 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x6y83abcEv");}
ccc::CC0x6y8 ::~CC0x6y8(){ note_dtor("_ZN3ccc7CC0x6y8E", this);} // tgen
ccc::CC0x6y8 ::CC0x6y8(){ note_ctor("_ZN3ccc7CC0x6y8E", this);} // tgen
}
static void Test__ZN3ccc7CC0x6y8E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x6y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x6y8E, buf);
    ::ccc::CC0x6y8 *dp, &lv = *(dp=new (buf) ::ccc::CC0x6y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x6y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x6y8E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x6y8E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc7CC0x6y8E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x6y8E);
    dp->::ccc::CC0x6y8::~CC0x6y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x6y8E(Test__ZN3ccc7CC0x6y8E, "_ZN3ccc7CC0x6y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x6y8C1Ev();
extern void _ZN3ccc7CC0x6y8D1Ev();
Name_Map name_map__ZN3ccc7CC0x6y8E[] = {
  NSPAIR(_ZN3ccc7CC0x6y8C1Ev),
  NSPAIR(_ZN3ccc7CC0x6y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7CC0x6y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x6y8E[];
extern void _ZN3ccc7CC0x6y83abcEv();
extern void _ZN3ccc7CC0x6y83efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x6y83abcEv,_ZThn4_N3ccc7CC0x6y83abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x6y83efgEv,_ZThn4_N3ccc7CC0x6y83efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x6y8E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x6y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x6y83abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x6y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x6y8E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x6y83abcEv,_ZThn4_N3ccc7CC0x6y83abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x6y83efgEv,_ZThn4_N3ccc7CC0x6y83efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x6y8E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x6y8E[];
Class_Descriptor cd__ZN3ccc7CC0x6y8E = {  "_ZN3ccc7CC0x6y8E", // class name
  bases__ZN3ccc7CC0x6y8E, 2,
  &(vtc__ZN3ccc7CC0x6y8E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x6y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x6y8E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x6y9  : ::ccc::AA0 , ::ccc::BB6 {
  virtual void  efg(); // _ZN3ccc7CC0x6y93efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x6y93pqrEv
  ~CC0x6y9(); // tgen
  CC0x6y9(); // tgen
};
//SIG(1 _ZN3ccc7CC0x6y9E) C1{ BC2{ v3 v1 v2} BC3{ v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x6y9 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x6y93efgEv");}
void  ccc::CC0x6y9 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x6y93pqrEv");}
ccc::CC0x6y9 ::~CC0x6y9(){ note_dtor("_ZN3ccc7CC0x6y9E", this);} // tgen
ccc::CC0x6y9 ::CC0x6y9(){ note_ctor("_ZN3ccc7CC0x6y9E", this);} // tgen
}
static void Test__ZN3ccc7CC0x6y9E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x6y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x6y9E, buf);
    ::ccc::CC0x6y9 *dp, &lv = *(dp=new (buf) ::ccc::CC0x6y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x6y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x6y9E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x6y9E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc7CC0x6y9E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x6y9E);
    dp->::ccc::CC0x6y9::~CC0x6y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x6y9E(Test__ZN3ccc7CC0x6y9E, "_ZN3ccc7CC0x6y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x6y9C1Ev();
extern void _ZN3ccc7CC0x6y9D1Ev();
Name_Map name_map__ZN3ccc7CC0x6y9E[] = {
  NSPAIR(_ZN3ccc7CC0x6y9C1Ev),
  NSPAIR(_ZN3ccc7CC0x6y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc7CC0x6y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x6y9E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc7CC0x6y93efgEv();
extern void _ZN3ccc7CC0x6y93pqrEv();
extern void _ZN3ccc3BB63abcEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x6y93efgEv,_ZThn4_N3ccc7CC0x6y93efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x6y9E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x6y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x6y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x6y93pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x6y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x6y93efgEv,_ZThn4_N3ccc7CC0x6y93efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x6y9E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x6y9E[];
Class_Descriptor cd__ZN3ccc7CC0x6y9E = {  "_ZN3ccc7CC0x6y9E", // class name
  bases__ZN3ccc7CC0x6y9E, 2,
  &(vtc__ZN3ccc7CC0x6y9E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x6y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x6y9E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x6y10  : ::ccc::AA0 , ::ccc::BB6 {
  virtual void  pqr(); // _ZN3ccc8CC0x6y103pqrEv
  virtual void  abc(); // _ZN3ccc8CC0x6y103abcEv
  ~CC0x6y10(); // tgen
  CC0x6y10(); // tgen
};
//SIG(1 _ZN3ccc8CC0x6y10E) C1{ BC2{ v2 v3 v1} BC3{ v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x6y10 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x6y103pqrEv");}
void  ccc::CC0x6y10 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x6y103abcEv");}
ccc::CC0x6y10 ::~CC0x6y10(){ note_dtor("_ZN3ccc8CC0x6y10E", this);} // tgen
ccc::CC0x6y10 ::CC0x6y10(){ note_ctor("_ZN3ccc8CC0x6y10E", this);} // tgen
}
static void Test__ZN3ccc8CC0x6y10E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x6y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x6y10E, buf);
    ::ccc::CC0x6y10 *dp, &lv = *(dp=new (buf) ::ccc::CC0x6y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x6y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x6y10E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x6y10E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc8CC0x6y10E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x6y10E);
    dp->::ccc::CC0x6y10::~CC0x6y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x6y10E(Test__ZN3ccc8CC0x6y10E, "_ZN3ccc8CC0x6y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x6y10C1Ev();
extern void _ZN3ccc8CC0x6y10D1Ev();
Name_Map name_map__ZN3ccc8CC0x6y10E[] = {
  NSPAIR(_ZN3ccc8CC0x6y10C1Ev),
  NSPAIR(_ZN3ccc8CC0x6y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8CC0x6y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x6y10E[];
extern void _ZN3ccc8CC0x6y103abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc8CC0x6y103pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x6y103abcEv,_ZThn4_N3ccc8CC0x6y103abcEv)();
extern void _ZN3ccc3BB63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x6y10E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x6y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x6y103abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x6y103pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x6y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x6y103abcEv,_ZThn4_N3ccc8CC0x6y103abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x6y10E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x6y10E[];
Class_Descriptor cd__ZN3ccc8CC0x6y10E = {  "_ZN3ccc8CC0x6y10E", // class name
  bases__ZN3ccc8CC0x6y10E, 2,
  &(vtc__ZN3ccc8CC0x6y10E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x6y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x6y10E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x6y11  : ::ccc::AA0 , ::ccc::BB6 {
  virtual void  pqr(); // _ZN3ccc8CC0x6y113pqrEv
  virtual void  efg(); // _ZN3ccc8CC0x6y113efgEv
  ~CC0x6y11(); // tgen
  CC0x6y11(); // tgen
};
//SIG(1 _ZN3ccc8CC0x6y11E) C1{ BC2{ v3 v2 v1} BC3{ v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x6y11 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x6y113pqrEv");}
void  ccc::CC0x6y11 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x6y113efgEv");}
ccc::CC0x6y11 ::~CC0x6y11(){ note_dtor("_ZN3ccc8CC0x6y11E", this);} // tgen
ccc::CC0x6y11 ::CC0x6y11(){ note_ctor("_ZN3ccc8CC0x6y11E", this);} // tgen
}
static void Test__ZN3ccc8CC0x6y11E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x6y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x6y11E, buf);
    ::ccc::CC0x6y11 *dp, &lv = *(dp=new (buf) ::ccc::CC0x6y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x6y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x6y11E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x6y11E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc8CC0x6y11E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x6y11E);
    dp->::ccc::CC0x6y11::~CC0x6y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x6y11E(Test__ZN3ccc8CC0x6y11E, "_ZN3ccc8CC0x6y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x6y11C1Ev();
extern void _ZN3ccc8CC0x6y11D1Ev();
Name_Map name_map__ZN3ccc8CC0x6y11E[] = {
  NSPAIR(_ZN3ccc8CC0x6y11C1Ev),
  NSPAIR(_ZN3ccc8CC0x6y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8CC0x6y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x6y11E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc8CC0x6y113efgEv();
extern void _ZN3ccc8CC0x6y113pqrEv();
extern void _ZN3ccc3BB63abcEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x6y113efgEv,_ZThn4_N3ccc8CC0x6y113efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x6y11E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x6y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x6y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x6y113pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x6y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x6y113efgEv,_ZThn4_N3ccc8CC0x6y113efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x6y11E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x6y11E[];
Class_Descriptor cd__ZN3ccc8CC0x6y11E = {  "_ZN3ccc8CC0x6y11E", // class name
  bases__ZN3ccc8CC0x6y11E, 2,
  &(vtc__ZN3ccc8CC0x6y11E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x6y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x6y11E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x6y12  : ::ccc::AA0 , ::ccc::BB6 {
  virtual void  abc(); // _ZN3ccc8CC0x6y123abcEv
  ~CC0x6y12(); // tgen
  CC0x6y12(); // tgen
};
//SIG(1 _ZN3ccc8CC0x6y12E) C1{ BC2{ v1 v2 v3} BC3{ v1 v4} v1}
}
namespace ccc { 
void  ccc::CC0x6y12 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x6y123abcEv");}
ccc::CC0x6y12 ::~CC0x6y12(){ note_dtor("_ZN3ccc8CC0x6y12E", this);} // tgen
ccc::CC0x6y12 ::CC0x6y12(){ note_ctor("_ZN3ccc8CC0x6y12E", this);} // tgen
}
static void Test__ZN3ccc8CC0x6y12E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x6y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x6y12E, buf);
    ::ccc::CC0x6y12 *dp, &lv = *(dp=new (buf) ::ccc::CC0x6y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x6y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x6y12E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x6y12E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc8CC0x6y12E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x6y12E);
    dp->::ccc::CC0x6y12::~CC0x6y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x6y12E(Test__ZN3ccc8CC0x6y12E, "_ZN3ccc8CC0x6y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x6y12C1Ev();
extern void _ZN3ccc8CC0x6y12D1Ev();
Name_Map name_map__ZN3ccc8CC0x6y12E[] = {
  NSPAIR(_ZN3ccc8CC0x6y12C1Ev),
  NSPAIR(_ZN3ccc8CC0x6y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8CC0x6y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x6y12E[];
extern void _ZN3ccc8CC0x6y123abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x6y123abcEv,_ZThn4_N3ccc8CC0x6y123abcEv)();
extern void _ZN3ccc3BB63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x6y12E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x6y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x6y123abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x6y12E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x6y123abcEv,_ZThn4_N3ccc8CC0x6y123abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x6y12E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x6y12E[];
Class_Descriptor cd__ZN3ccc8CC0x6y12E = {  "_ZN3ccc8CC0x6y12E", // class name
  bases__ZN3ccc8CC0x6y12E, 2,
  &(vtc__ZN3ccc8CC0x6y12E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x6y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x6y12E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x6y13  : ::ccc::AA0 , ::ccc::BB6 {
  virtual void  efg(); // _ZN3ccc8CC0x6y133efgEv
  ~CC0x6y13(); // tgen
  CC0x6y13(); // tgen
};
//SIG(1 _ZN3ccc8CC0x6y13E) C1{ BC2{ v2 v1 v3} BC3{ v4 v1} v1}
}
namespace ccc { 
void  ccc::CC0x6y13 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x6y133efgEv");}
ccc::CC0x6y13 ::~CC0x6y13(){ note_dtor("_ZN3ccc8CC0x6y13E", this);} // tgen
ccc::CC0x6y13 ::CC0x6y13(){ note_ctor("_ZN3ccc8CC0x6y13E", this);} // tgen
}
static void Test__ZN3ccc8CC0x6y13E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x6y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x6y13E, buf);
    ::ccc::CC0x6y13 *dp, &lv = *(dp=new (buf) ::ccc::CC0x6y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x6y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x6y13E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x6y13E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc8CC0x6y13E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x6y13E);
    dp->::ccc::CC0x6y13::~CC0x6y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x6y13E(Test__ZN3ccc8CC0x6y13E, "_ZN3ccc8CC0x6y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x6y13C1Ev();
extern void _ZN3ccc8CC0x6y13D1Ev();
Name_Map name_map__ZN3ccc8CC0x6y13E[] = {
  NSPAIR(_ZN3ccc8CC0x6y13C1Ev),
  NSPAIR(_ZN3ccc8CC0x6y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8CC0x6y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x6y13E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc8CC0x6y133efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc3BB63abcEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x6y133efgEv,_ZThn4_N3ccc8CC0x6y133efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x6y13E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x6y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x6y133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x6y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x6y133efgEv,_ZThn4_N3ccc8CC0x6y133efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x6y13E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x6y13E[];
Class_Descriptor cd__ZN3ccc8CC0x6y13E = {  "_ZN3ccc8CC0x6y13E", // class name
  bases__ZN3ccc8CC0x6y13E, 2,
  &(vtc__ZN3ccc8CC0x6y13E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x6y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x6y13E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x6y14  : ::ccc::AA0 , ::ccc::BB6 {
  virtual void  pqr(); // _ZN3ccc8CC0x6y143pqrEv
  ~CC0x6y14(); // tgen
  CC0x6y14(); // tgen
};
//SIG(1 _ZN3ccc8CC0x6y14E) C1{ BC2{ v2 v3 v1} BC3{ v4 v5} v1}
}
namespace ccc { 
void  ccc::CC0x6y14 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x6y143pqrEv");}
ccc::CC0x6y14 ::~CC0x6y14(){ note_dtor("_ZN3ccc8CC0x6y14E", this);} // tgen
ccc::CC0x6y14 ::CC0x6y14(){ note_ctor("_ZN3ccc8CC0x6y14E", this);} // tgen
}
static void Test__ZN3ccc8CC0x6y14E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x6y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x6y14E, buf);
    ::ccc::CC0x6y14 *dp, &lv = *(dp=new (buf) ::ccc::CC0x6y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x6y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x6y14E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x6y14E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc8CC0x6y14E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x6y14E);
    dp->::ccc::CC0x6y14::~CC0x6y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x6y14E(Test__ZN3ccc8CC0x6y14E, "_ZN3ccc8CC0x6y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x6y14C1Ev();
extern void _ZN3ccc8CC0x6y14D1Ev();
Name_Map name_map__ZN3ccc8CC0x6y14E[] = {
  NSPAIR(_ZN3ccc8CC0x6y14C1Ev),
  NSPAIR(_ZN3ccc8CC0x6y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8CC0x6y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x6y14E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc8CC0x6y143pqrEv();
extern void _ZN3ccc3BB63abcEv();
extern void _ZN3ccc3BB63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x6y14E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x6y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x6y143pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x6y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x6y14E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x6y14E[];
Class_Descriptor cd__ZN3ccc8CC0x6y14E = {  "_ZN3ccc8CC0x6y14E", // class name
  bases__ZN3ccc8CC0x6y14E, 2,
  &(vtc__ZN3ccc8CC0x6y14E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x6y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x6y14E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x6y15  : ::ccc::AA0 , ::ccc::BB6 {
  ~CC0x6y15(); // tgen
  CC0x6y15(); // tgen
};
//SIG(1 _ZN3ccc8CC0x6y15E) C1{ BC2{ v1 v2 v3} BC3{ v4 v5}}
}
namespace ccc { 
ccc::CC0x6y15 ::~CC0x6y15(){ note_dtor("_ZN3ccc8CC0x6y15E", this);} // tgen
ccc::CC0x6y15 ::CC0x6y15(){ note_ctor("_ZN3ccc8CC0x6y15E", this);} // tgen
}
static void Test__ZN3ccc8CC0x6y15E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x6y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x6y15E, buf);
    ::ccc::CC0x6y15 *dp, &lv = *(dp=new (buf) ::ccc::CC0x6y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x6y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x6y15E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x6y15E");
    check_base_class_offset(lv, (::ccc::BB6*), ABISELECT(8,4), "_ZN3ccc8CC0x6y15E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x6y15E);
    dp->::ccc::CC0x6y15::~CC0x6y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x6y15E(Test__ZN3ccc8CC0x6y15E, "_ZN3ccc8CC0x6y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x6y15C1Ev();
extern void _ZN3ccc8CC0x6y15D1Ev();
Name_Map name_map__ZN3ccc8CC0x6y15E[] = {
  NSPAIR(_ZN3ccc8CC0x6y15C1Ev),
  NSPAIR(_ZN3ccc8CC0x6y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB6E;
extern VTBL_ENTRY _ZTIN3ccc3BB6E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB6E[];
static Base_Class bases__ZN3ccc8CC0x6y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB6E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x6y15E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc3BB63abcEv();
extern void _ZN3ccc3BB63efgEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x6y15E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x6y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x6y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB63abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB63efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x6y15E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x6y15E[];
Class_Descriptor cd__ZN3ccc8CC0x6y15E = {  "_ZN3ccc8CC0x6y15E", // class name
  bases__ZN3ccc8CC0x6y15E, 2,
  &(vtc__ZN3ccc8CC0x6y15E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x6y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x6y15E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x7y0  : ::ccc::AA0 , ::ccc::BB7 {
  virtual void  abc(); // _ZN3ccc7CC0x7y03abcEv
  virtual void  efg(); // _ZN3ccc7CC0x7y03efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x7y03pqrEv
  ~CC0x7y0(); // tgen
  CC0x7y0(); // tgen
};
//SIG(1 _ZN3ccc7CC0x7y0E) C1{ BC2{ v1 v2 v3} BC3{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x7y0 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x7y03abcEv");}
void  ccc::CC0x7y0 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x7y03efgEv");}
void  ccc::CC0x7y0 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x7y03pqrEv");}
ccc::CC0x7y0 ::~CC0x7y0(){ note_dtor("_ZN3ccc7CC0x7y0E", this);} // tgen
ccc::CC0x7y0 ::CC0x7y0(){ note_ctor("_ZN3ccc7CC0x7y0E", this);} // tgen
}
static void Test__ZN3ccc7CC0x7y0E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x7y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x7y0E, buf);
    ::ccc::CC0x7y0 *dp, &lv = *(dp=new (buf) ::ccc::CC0x7y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x7y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x7y0E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x7y0E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc7CC0x7y0E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x7y0E);
    dp->::ccc::CC0x7y0::~CC0x7y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x7y0E(Test__ZN3ccc7CC0x7y0E, "_ZN3ccc7CC0x7y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x7y0C1Ev();
extern void _ZN3ccc7CC0x7y0D1Ev();
Name_Map name_map__ZN3ccc7CC0x7y0E[] = {
  NSPAIR(_ZN3ccc7CC0x7y0C1Ev),
  NSPAIR(_ZN3ccc7CC0x7y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7CC0x7y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x7y0E[];
extern void _ZN3ccc7CC0x7y03abcEv();
extern void _ZN3ccc7CC0x7y03efgEv();
extern void _ZN3ccc7CC0x7y03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x7y03abcEv,_ZThn4_N3ccc7CC0x7y03abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x7y03pqrEv,_ZThn4_N3ccc7CC0x7y03pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x7y0E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x7y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x7y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x7y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x7y03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x7y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x7y03abcEv,_ZThn4_N3ccc7CC0x7y03abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x7y03pqrEv,_ZThn4_N3ccc7CC0x7y03pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x7y0E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x7y0E[];
Class_Descriptor cd__ZN3ccc7CC0x7y0E = {  "_ZN3ccc7CC0x7y0E", // class name
  bases__ZN3ccc7CC0x7y0E, 2,
  &(vtc__ZN3ccc7CC0x7y0E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x7y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x7y0E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x7y1  : ::ccc::AA0 , ::ccc::BB7 {
  virtual void  abc(); // _ZN3ccc7CC0x7y13abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x7y13pqrEv
  virtual void  efg(); // _ZN3ccc7CC0x7y13efgEv
  ~CC0x7y1(); // tgen
  CC0x7y1(); // tgen
};
//SIG(1 _ZN3ccc7CC0x7y1E) C1{ BC2{ v1 v3 v2} BC3{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x7y1 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x7y13abcEv");}
void  ccc::CC0x7y1 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x7y13pqrEv");}
void  ccc::CC0x7y1 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x7y13efgEv");}
ccc::CC0x7y1 ::~CC0x7y1(){ note_dtor("_ZN3ccc7CC0x7y1E", this);} // tgen
ccc::CC0x7y1 ::CC0x7y1(){ note_ctor("_ZN3ccc7CC0x7y1E", this);} // tgen
}
static void Test__ZN3ccc7CC0x7y1E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x7y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x7y1E, buf);
    ::ccc::CC0x7y1 *dp, &lv = *(dp=new (buf) ::ccc::CC0x7y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x7y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x7y1E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x7y1E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc7CC0x7y1E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x7y1E);
    dp->::ccc::CC0x7y1::~CC0x7y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x7y1E(Test__ZN3ccc7CC0x7y1E, "_ZN3ccc7CC0x7y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x7y1C1Ev();
extern void _ZN3ccc7CC0x7y1D1Ev();
Name_Map name_map__ZN3ccc7CC0x7y1E[] = {
  NSPAIR(_ZN3ccc7CC0x7y1C1Ev),
  NSPAIR(_ZN3ccc7CC0x7y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7CC0x7y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x7y1E[];
extern void _ZN3ccc7CC0x7y13abcEv();
extern void _ZN3ccc7CC0x7y13efgEv();
extern void _ZN3ccc7CC0x7y13pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x7y13abcEv,_ZThn4_N3ccc7CC0x7y13abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x7y13pqrEv,_ZThn4_N3ccc7CC0x7y13pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x7y1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x7y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x7y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x7y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x7y13pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x7y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x7y13abcEv,_ZThn4_N3ccc7CC0x7y13abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x7y13pqrEv,_ZThn4_N3ccc7CC0x7y13pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x7y1E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x7y1E[];
Class_Descriptor cd__ZN3ccc7CC0x7y1E = {  "_ZN3ccc7CC0x7y1E", // class name
  bases__ZN3ccc7CC0x7y1E, 2,
  &(vtc__ZN3ccc7CC0x7y1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x7y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x7y1E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x7y2  : ::ccc::AA0 , ::ccc::BB7 {
  virtual void  efg(); // _ZN3ccc7CC0x7y23efgEv
  virtual void  abc(); // _ZN3ccc7CC0x7y23abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x7y23pqrEv
  ~CC0x7y2(); // tgen
  CC0x7y2(); // tgen
};
//SIG(1 _ZN3ccc7CC0x7y2E) C1{ BC2{ v2 v1 v3} BC3{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x7y2 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x7y23efgEv");}
void  ccc::CC0x7y2 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x7y23abcEv");}
void  ccc::CC0x7y2 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x7y23pqrEv");}
ccc::CC0x7y2 ::~CC0x7y2(){ note_dtor("_ZN3ccc7CC0x7y2E", this);} // tgen
ccc::CC0x7y2 ::CC0x7y2(){ note_ctor("_ZN3ccc7CC0x7y2E", this);} // tgen
}
static void Test__ZN3ccc7CC0x7y2E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x7y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x7y2E, buf);
    ::ccc::CC0x7y2 *dp, &lv = *(dp=new (buf) ::ccc::CC0x7y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x7y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x7y2E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x7y2E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc7CC0x7y2E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x7y2E);
    dp->::ccc::CC0x7y2::~CC0x7y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x7y2E(Test__ZN3ccc7CC0x7y2E, "_ZN3ccc7CC0x7y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x7y2C1Ev();
extern void _ZN3ccc7CC0x7y2D1Ev();
Name_Map name_map__ZN3ccc7CC0x7y2E[] = {
  NSPAIR(_ZN3ccc7CC0x7y2C1Ev),
  NSPAIR(_ZN3ccc7CC0x7y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7CC0x7y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x7y2E[];
extern void _ZN3ccc7CC0x7y23abcEv();
extern void _ZN3ccc7CC0x7y23efgEv();
extern void _ZN3ccc7CC0x7y23pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x7y23abcEv,_ZThn4_N3ccc7CC0x7y23abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x7y23pqrEv,_ZThn4_N3ccc7CC0x7y23pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x7y2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x7y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x7y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x7y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x7y23pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x7y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x7y23abcEv,_ZThn4_N3ccc7CC0x7y23abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x7y23pqrEv,_ZThn4_N3ccc7CC0x7y23pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x7y2E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x7y2E[];
Class_Descriptor cd__ZN3ccc7CC0x7y2E = {  "_ZN3ccc7CC0x7y2E", // class name
  bases__ZN3ccc7CC0x7y2E, 2,
  &(vtc__ZN3ccc7CC0x7y2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x7y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x7y2E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x7y3  : ::ccc::AA0 , ::ccc::BB7 {
  virtual void  efg(); // _ZN3ccc7CC0x7y33efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x7y33pqrEv
  virtual void  abc(); // _ZN3ccc7CC0x7y33abcEv
  ~CC0x7y3(); // tgen
  CC0x7y3(); // tgen
};
//SIG(1 _ZN3ccc7CC0x7y3E) C1{ BC2{ v3 v1 v2} BC3{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x7y3 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x7y33efgEv");}
void  ccc::CC0x7y3 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x7y33pqrEv");}
void  ccc::CC0x7y3 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x7y33abcEv");}
ccc::CC0x7y3 ::~CC0x7y3(){ note_dtor("_ZN3ccc7CC0x7y3E", this);} // tgen
ccc::CC0x7y3 ::CC0x7y3(){ note_ctor("_ZN3ccc7CC0x7y3E", this);} // tgen
}
static void Test__ZN3ccc7CC0x7y3E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x7y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x7y3E, buf);
    ::ccc::CC0x7y3 *dp, &lv = *(dp=new (buf) ::ccc::CC0x7y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x7y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x7y3E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x7y3E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc7CC0x7y3E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x7y3E);
    dp->::ccc::CC0x7y3::~CC0x7y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x7y3E(Test__ZN3ccc7CC0x7y3E, "_ZN3ccc7CC0x7y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x7y3C1Ev();
extern void _ZN3ccc7CC0x7y3D1Ev();
Name_Map name_map__ZN3ccc7CC0x7y3E[] = {
  NSPAIR(_ZN3ccc7CC0x7y3C1Ev),
  NSPAIR(_ZN3ccc7CC0x7y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7CC0x7y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x7y3E[];
extern void _ZN3ccc7CC0x7y33abcEv();
extern void _ZN3ccc7CC0x7y33efgEv();
extern void _ZN3ccc7CC0x7y33pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x7y33abcEv,_ZThn4_N3ccc7CC0x7y33abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x7y33pqrEv,_ZThn4_N3ccc7CC0x7y33pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x7y3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x7y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x7y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x7y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x7y33pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x7y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x7y33abcEv,_ZThn4_N3ccc7CC0x7y33abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x7y33pqrEv,_ZThn4_N3ccc7CC0x7y33pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x7y3E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x7y3E[];
Class_Descriptor cd__ZN3ccc7CC0x7y3E = {  "_ZN3ccc7CC0x7y3E", // class name
  bases__ZN3ccc7CC0x7y3E, 2,
  &(vtc__ZN3ccc7CC0x7y3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x7y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x7y3E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x7y4  : ::ccc::AA0 , ::ccc::BB7 {
  virtual void  pqr(); // _ZN3ccc7CC0x7y43pqrEv
  virtual void  abc(); // _ZN3ccc7CC0x7y43abcEv
  virtual void  efg(); // _ZN3ccc7CC0x7y43efgEv
  ~CC0x7y4(); // tgen
  CC0x7y4(); // tgen
};
//SIG(1 _ZN3ccc7CC0x7y4E) C1{ BC2{ v2 v3 v1} BC3{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x7y4 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x7y43pqrEv");}
void  ccc::CC0x7y4 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x7y43abcEv");}
void  ccc::CC0x7y4 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x7y43efgEv");}
ccc::CC0x7y4 ::~CC0x7y4(){ note_dtor("_ZN3ccc7CC0x7y4E", this);} // tgen
ccc::CC0x7y4 ::CC0x7y4(){ note_ctor("_ZN3ccc7CC0x7y4E", this);} // tgen
}
static void Test__ZN3ccc7CC0x7y4E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x7y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x7y4E, buf);
    ::ccc::CC0x7y4 *dp, &lv = *(dp=new (buf) ::ccc::CC0x7y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x7y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x7y4E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x7y4E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc7CC0x7y4E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x7y4E);
    dp->::ccc::CC0x7y4::~CC0x7y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x7y4E(Test__ZN3ccc7CC0x7y4E, "_ZN3ccc7CC0x7y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x7y4C1Ev();
extern void _ZN3ccc7CC0x7y4D1Ev();
Name_Map name_map__ZN3ccc7CC0x7y4E[] = {
  NSPAIR(_ZN3ccc7CC0x7y4C1Ev),
  NSPAIR(_ZN3ccc7CC0x7y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7CC0x7y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x7y4E[];
extern void _ZN3ccc7CC0x7y43abcEv();
extern void _ZN3ccc7CC0x7y43efgEv();
extern void _ZN3ccc7CC0x7y43pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x7y43abcEv,_ZThn4_N3ccc7CC0x7y43abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x7y43pqrEv,_ZThn4_N3ccc7CC0x7y43pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x7y4E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x7y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x7y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x7y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x7y43pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x7y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x7y43abcEv,_ZThn4_N3ccc7CC0x7y43abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x7y43pqrEv,_ZThn4_N3ccc7CC0x7y43pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x7y4E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x7y4E[];
Class_Descriptor cd__ZN3ccc7CC0x7y4E = {  "_ZN3ccc7CC0x7y4E", // class name
  bases__ZN3ccc7CC0x7y4E, 2,
  &(vtc__ZN3ccc7CC0x7y4E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x7y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x7y4E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x7y5  : ::ccc::AA0 , ::ccc::BB7 {
  virtual void  pqr(); // _ZN3ccc7CC0x7y53pqrEv
  virtual void  efg(); // _ZN3ccc7CC0x7y53efgEv
  virtual void  abc(); // _ZN3ccc7CC0x7y53abcEv
  ~CC0x7y5(); // tgen
  CC0x7y5(); // tgen
};
//SIG(1 _ZN3ccc7CC0x7y5E) C1{ BC2{ v3 v2 v1} BC3{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x7y5 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x7y53pqrEv");}
void  ccc::CC0x7y5 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x7y53efgEv");}
void  ccc::CC0x7y5 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x7y53abcEv");}
ccc::CC0x7y5 ::~CC0x7y5(){ note_dtor("_ZN3ccc7CC0x7y5E", this);} // tgen
ccc::CC0x7y5 ::CC0x7y5(){ note_ctor("_ZN3ccc7CC0x7y5E", this);} // tgen
}
static void Test__ZN3ccc7CC0x7y5E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x7y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x7y5E, buf);
    ::ccc::CC0x7y5 *dp, &lv = *(dp=new (buf) ::ccc::CC0x7y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x7y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x7y5E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x7y5E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc7CC0x7y5E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x7y5E);
    dp->::ccc::CC0x7y5::~CC0x7y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x7y5E(Test__ZN3ccc7CC0x7y5E, "_ZN3ccc7CC0x7y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x7y5C1Ev();
extern void _ZN3ccc7CC0x7y5D1Ev();
Name_Map name_map__ZN3ccc7CC0x7y5E[] = {
  NSPAIR(_ZN3ccc7CC0x7y5C1Ev),
  NSPAIR(_ZN3ccc7CC0x7y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7CC0x7y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x7y5E[];
extern void _ZN3ccc7CC0x7y53abcEv();
extern void _ZN3ccc7CC0x7y53efgEv();
extern void _ZN3ccc7CC0x7y53pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x7y53abcEv,_ZThn4_N3ccc7CC0x7y53abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x7y53pqrEv,_ZThn4_N3ccc7CC0x7y53pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x7y5E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x7y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x7y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x7y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x7y53pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x7y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x7y53abcEv,_ZThn4_N3ccc7CC0x7y53abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x7y53pqrEv,_ZThn4_N3ccc7CC0x7y53pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x7y5E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x7y5E[];
Class_Descriptor cd__ZN3ccc7CC0x7y5E = {  "_ZN3ccc7CC0x7y5E", // class name
  bases__ZN3ccc7CC0x7y5E, 2,
  &(vtc__ZN3ccc7CC0x7y5E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x7y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x7y5E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x7y6  : ::ccc::AA0 , ::ccc::BB7 {
  virtual void  abc(); // _ZN3ccc7CC0x7y63abcEv
  virtual void  efg(); // _ZN3ccc7CC0x7y63efgEv
  ~CC0x7y6(); // tgen
  CC0x7y6(); // tgen
};
//SIG(1 _ZN3ccc7CC0x7y6E) C1{ BC2{ v1 v2 v3} BC3{ v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x7y6 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x7y63abcEv");}
void  ccc::CC0x7y6 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x7y63efgEv");}
ccc::CC0x7y6 ::~CC0x7y6(){ note_dtor("_ZN3ccc7CC0x7y6E", this);} // tgen
ccc::CC0x7y6 ::CC0x7y6(){ note_ctor("_ZN3ccc7CC0x7y6E", this);} // tgen
}
static void Test__ZN3ccc7CC0x7y6E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x7y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x7y6E, buf);
    ::ccc::CC0x7y6 *dp, &lv = *(dp=new (buf) ::ccc::CC0x7y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x7y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x7y6E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x7y6E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc7CC0x7y6E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x7y6E);
    dp->::ccc::CC0x7y6::~CC0x7y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x7y6E(Test__ZN3ccc7CC0x7y6E, "_ZN3ccc7CC0x7y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x7y6C1Ev();
extern void _ZN3ccc7CC0x7y6D1Ev();
Name_Map name_map__ZN3ccc7CC0x7y6E[] = {
  NSPAIR(_ZN3ccc7CC0x7y6C1Ev),
  NSPAIR(_ZN3ccc7CC0x7y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7CC0x7y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x7y6E[];
extern void _ZN3ccc7CC0x7y63abcEv();
extern void _ZN3ccc7CC0x7y63efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x7y63abcEv,_ZThn4_N3ccc7CC0x7y63abcEv)();
extern void _ZN3ccc3BB73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x7y6E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x7y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x7y63abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x7y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x7y6E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x7y63abcEv,_ZThn4_N3ccc7CC0x7y63abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x7y6E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x7y6E[];
Class_Descriptor cd__ZN3ccc7CC0x7y6E = {  "_ZN3ccc7CC0x7y6E", // class name
  bases__ZN3ccc7CC0x7y6E, 2,
  &(vtc__ZN3ccc7CC0x7y6E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x7y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x7y6E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x7y7  : ::ccc::AA0 , ::ccc::BB7 {
  virtual void  abc(); // _ZN3ccc7CC0x7y73abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x7y73pqrEv
  ~CC0x7y7(); // tgen
  CC0x7y7(); // tgen
};
//SIG(1 _ZN3ccc7CC0x7y7E) C1{ BC2{ v1 v3 v2} BC3{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x7y7 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x7y73abcEv");}
void  ccc::CC0x7y7 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x7y73pqrEv");}
ccc::CC0x7y7 ::~CC0x7y7(){ note_dtor("_ZN3ccc7CC0x7y7E", this);} // tgen
ccc::CC0x7y7 ::CC0x7y7(){ note_ctor("_ZN3ccc7CC0x7y7E", this);} // tgen
}
static void Test__ZN3ccc7CC0x7y7E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x7y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x7y7E, buf);
    ::ccc::CC0x7y7 *dp, &lv = *(dp=new (buf) ::ccc::CC0x7y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x7y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x7y7E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x7y7E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc7CC0x7y7E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x7y7E);
    dp->::ccc::CC0x7y7::~CC0x7y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x7y7E(Test__ZN3ccc7CC0x7y7E, "_ZN3ccc7CC0x7y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x7y7C1Ev();
extern void _ZN3ccc7CC0x7y7D1Ev();
Name_Map name_map__ZN3ccc7CC0x7y7E[] = {
  NSPAIR(_ZN3ccc7CC0x7y7C1Ev),
  NSPAIR(_ZN3ccc7CC0x7y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7CC0x7y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x7y7E[];
extern void _ZN3ccc7CC0x7y73abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc7CC0x7y73pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x7y73abcEv,_ZThn4_N3ccc7CC0x7y73abcEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x7y73pqrEv,_ZThn4_N3ccc7CC0x7y73pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x7y7E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x7y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x7y73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x7y73pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x7y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x7y73abcEv,_ZThn4_N3ccc7CC0x7y73abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x7y73pqrEv,_ZThn4_N3ccc7CC0x7y73pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x7y7E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x7y7E[];
Class_Descriptor cd__ZN3ccc7CC0x7y7E = {  "_ZN3ccc7CC0x7y7E", // class name
  bases__ZN3ccc7CC0x7y7E, 2,
  &(vtc__ZN3ccc7CC0x7y7E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x7y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x7y7E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x7y8  : ::ccc::AA0 , ::ccc::BB7 {
  virtual void  efg(); // _ZN3ccc7CC0x7y83efgEv
  virtual void  abc(); // _ZN3ccc7CC0x7y83abcEv
  ~CC0x7y8(); // tgen
  CC0x7y8(); // tgen
};
//SIG(1 _ZN3ccc7CC0x7y8E) C1{ BC2{ v2 v1 v3} BC3{ v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x7y8 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x7y83efgEv");}
void  ccc::CC0x7y8 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x7y83abcEv");}
ccc::CC0x7y8 ::~CC0x7y8(){ note_dtor("_ZN3ccc7CC0x7y8E", this);} // tgen
ccc::CC0x7y8 ::CC0x7y8(){ note_ctor("_ZN3ccc7CC0x7y8E", this);} // tgen
}
static void Test__ZN3ccc7CC0x7y8E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x7y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x7y8E, buf);
    ::ccc::CC0x7y8 *dp, &lv = *(dp=new (buf) ::ccc::CC0x7y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x7y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x7y8E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x7y8E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc7CC0x7y8E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x7y8E);
    dp->::ccc::CC0x7y8::~CC0x7y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x7y8E(Test__ZN3ccc7CC0x7y8E, "_ZN3ccc7CC0x7y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x7y8C1Ev();
extern void _ZN3ccc7CC0x7y8D1Ev();
Name_Map name_map__ZN3ccc7CC0x7y8E[] = {
  NSPAIR(_ZN3ccc7CC0x7y8C1Ev),
  NSPAIR(_ZN3ccc7CC0x7y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7CC0x7y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x7y8E[];
extern void _ZN3ccc7CC0x7y83abcEv();
extern void _ZN3ccc7CC0x7y83efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x7y83abcEv,_ZThn4_N3ccc7CC0x7y83abcEv)();
extern void _ZN3ccc3BB73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x7y8E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x7y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x7y83abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x7y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x7y8E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x7y83abcEv,_ZThn4_N3ccc7CC0x7y83abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x7y8E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x7y8E[];
Class_Descriptor cd__ZN3ccc7CC0x7y8E = {  "_ZN3ccc7CC0x7y8E", // class name
  bases__ZN3ccc7CC0x7y8E, 2,
  &(vtc__ZN3ccc7CC0x7y8E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x7y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x7y8E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x7y9  : ::ccc::AA0 , ::ccc::BB7 {
  virtual void  efg(); // _ZN3ccc7CC0x7y93efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x7y93pqrEv
  ~CC0x7y9(); // tgen
  CC0x7y9(); // tgen
};
//SIG(1 _ZN3ccc7CC0x7y9E) C1{ BC2{ v3 v1 v2} BC3{ v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x7y9 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x7y93efgEv");}
void  ccc::CC0x7y9 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x7y93pqrEv");}
ccc::CC0x7y9 ::~CC0x7y9(){ note_dtor("_ZN3ccc7CC0x7y9E", this);} // tgen
ccc::CC0x7y9 ::CC0x7y9(){ note_ctor("_ZN3ccc7CC0x7y9E", this);} // tgen
}
static void Test__ZN3ccc7CC0x7y9E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x7y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x7y9E, buf);
    ::ccc::CC0x7y9 *dp, &lv = *(dp=new (buf) ::ccc::CC0x7y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x7y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x7y9E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x7y9E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc7CC0x7y9E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x7y9E);
    dp->::ccc::CC0x7y9::~CC0x7y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x7y9E(Test__ZN3ccc7CC0x7y9E, "_ZN3ccc7CC0x7y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x7y9C1Ev();
extern void _ZN3ccc7CC0x7y9D1Ev();
Name_Map name_map__ZN3ccc7CC0x7y9E[] = {
  NSPAIR(_ZN3ccc7CC0x7y9C1Ev),
  NSPAIR(_ZN3ccc7CC0x7y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc7CC0x7y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x7y9E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc7CC0x7y93efgEv();
extern void _ZN3ccc7CC0x7y93pqrEv();
extern void _ZN3ccc3BB73abcEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x7y93pqrEv,_ZThn4_N3ccc7CC0x7y93pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x7y9E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x7y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x7y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x7y93pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x7y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x7y93pqrEv,_ZThn4_N3ccc7CC0x7y93pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x7y9E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x7y9E[];
Class_Descriptor cd__ZN3ccc7CC0x7y9E = {  "_ZN3ccc7CC0x7y9E", // class name
  bases__ZN3ccc7CC0x7y9E, 2,
  &(vtc__ZN3ccc7CC0x7y9E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x7y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x7y9E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x7y10  : ::ccc::AA0 , ::ccc::BB7 {
  virtual void  pqr(); // _ZN3ccc8CC0x7y103pqrEv
  virtual void  abc(); // _ZN3ccc8CC0x7y103abcEv
  ~CC0x7y10(); // tgen
  CC0x7y10(); // tgen
};
//SIG(1 _ZN3ccc8CC0x7y10E) C1{ BC2{ v2 v3 v1} BC3{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x7y10 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x7y103pqrEv");}
void  ccc::CC0x7y10 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x7y103abcEv");}
ccc::CC0x7y10 ::~CC0x7y10(){ note_dtor("_ZN3ccc8CC0x7y10E", this);} // tgen
ccc::CC0x7y10 ::CC0x7y10(){ note_ctor("_ZN3ccc8CC0x7y10E", this);} // tgen
}
static void Test__ZN3ccc8CC0x7y10E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x7y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x7y10E, buf);
    ::ccc::CC0x7y10 *dp, &lv = *(dp=new (buf) ::ccc::CC0x7y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x7y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x7y10E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x7y10E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc8CC0x7y10E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x7y10E);
    dp->::ccc::CC0x7y10::~CC0x7y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x7y10E(Test__ZN3ccc8CC0x7y10E, "_ZN3ccc8CC0x7y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x7y10C1Ev();
extern void _ZN3ccc8CC0x7y10D1Ev();
Name_Map name_map__ZN3ccc8CC0x7y10E[] = {
  NSPAIR(_ZN3ccc8CC0x7y10C1Ev),
  NSPAIR(_ZN3ccc8CC0x7y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8CC0x7y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x7y10E[];
extern void _ZN3ccc8CC0x7y103abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc8CC0x7y103pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x7y103abcEv,_ZThn4_N3ccc8CC0x7y103abcEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC0x7y103pqrEv,_ZThn4_N3ccc8CC0x7y103pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x7y10E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x7y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x7y103abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x7y103pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x7y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x7y103abcEv,_ZThn4_N3ccc8CC0x7y103abcEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x7y103pqrEv,_ZThn4_N3ccc8CC0x7y103pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x7y10E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x7y10E[];
Class_Descriptor cd__ZN3ccc8CC0x7y10E = {  "_ZN3ccc8CC0x7y10E", // class name
  bases__ZN3ccc8CC0x7y10E, 2,
  &(vtc__ZN3ccc8CC0x7y10E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x7y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x7y10E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x7y11  : ::ccc::AA0 , ::ccc::BB7 {
  virtual void  pqr(); // _ZN3ccc8CC0x7y113pqrEv
  virtual void  efg(); // _ZN3ccc8CC0x7y113efgEv
  ~CC0x7y11(); // tgen
  CC0x7y11(); // tgen
};
//SIG(1 _ZN3ccc8CC0x7y11E) C1{ BC2{ v3 v2 v1} BC3{ v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x7y11 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x7y113pqrEv");}
void  ccc::CC0x7y11 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x7y113efgEv");}
ccc::CC0x7y11 ::~CC0x7y11(){ note_dtor("_ZN3ccc8CC0x7y11E", this);} // tgen
ccc::CC0x7y11 ::CC0x7y11(){ note_ctor("_ZN3ccc8CC0x7y11E", this);} // tgen
}
static void Test__ZN3ccc8CC0x7y11E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x7y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x7y11E, buf);
    ::ccc::CC0x7y11 *dp, &lv = *(dp=new (buf) ::ccc::CC0x7y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x7y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x7y11E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x7y11E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc8CC0x7y11E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x7y11E);
    dp->::ccc::CC0x7y11::~CC0x7y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x7y11E(Test__ZN3ccc8CC0x7y11E, "_ZN3ccc8CC0x7y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x7y11C1Ev();
extern void _ZN3ccc8CC0x7y11D1Ev();
Name_Map name_map__ZN3ccc8CC0x7y11E[] = {
  NSPAIR(_ZN3ccc8CC0x7y11C1Ev),
  NSPAIR(_ZN3ccc8CC0x7y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8CC0x7y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x7y11E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc8CC0x7y113efgEv();
extern void _ZN3ccc8CC0x7y113pqrEv();
extern void _ZN3ccc3BB73abcEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x7y113pqrEv,_ZThn4_N3ccc8CC0x7y113pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x7y11E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x7y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x7y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x7y113pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x7y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x7y113pqrEv,_ZThn4_N3ccc8CC0x7y113pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x7y11E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x7y11E[];
Class_Descriptor cd__ZN3ccc8CC0x7y11E = {  "_ZN3ccc8CC0x7y11E", // class name
  bases__ZN3ccc8CC0x7y11E, 2,
  &(vtc__ZN3ccc8CC0x7y11E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x7y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x7y11E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x7y12  : ::ccc::AA0 , ::ccc::BB7 {
  virtual void  abc(); // _ZN3ccc8CC0x7y123abcEv
  ~CC0x7y12(); // tgen
  CC0x7y12(); // tgen
};
//SIG(1 _ZN3ccc8CC0x7y12E) C1{ BC2{ v1 v2 v3} BC3{ v1 v4} v1}
}
namespace ccc { 
void  ccc::CC0x7y12 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x7y123abcEv");}
ccc::CC0x7y12 ::~CC0x7y12(){ note_dtor("_ZN3ccc8CC0x7y12E", this);} // tgen
ccc::CC0x7y12 ::CC0x7y12(){ note_ctor("_ZN3ccc8CC0x7y12E", this);} // tgen
}
static void Test__ZN3ccc8CC0x7y12E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x7y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x7y12E, buf);
    ::ccc::CC0x7y12 *dp, &lv = *(dp=new (buf) ::ccc::CC0x7y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x7y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x7y12E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x7y12E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc8CC0x7y12E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x7y12E);
    dp->::ccc::CC0x7y12::~CC0x7y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x7y12E(Test__ZN3ccc8CC0x7y12E, "_ZN3ccc8CC0x7y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x7y12C1Ev();
extern void _ZN3ccc8CC0x7y12D1Ev();
Name_Map name_map__ZN3ccc8CC0x7y12E[] = {
  NSPAIR(_ZN3ccc8CC0x7y12C1Ev),
  NSPAIR(_ZN3ccc8CC0x7y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8CC0x7y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x7y12E[];
extern void _ZN3ccc8CC0x7y123abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x7y123abcEv,_ZThn4_N3ccc8CC0x7y123abcEv)();
extern void _ZN3ccc3BB73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x7y12E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x7y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x7y123abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x7y12E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x7y123abcEv,_ZThn4_N3ccc8CC0x7y123abcEv),
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x7y12E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x7y12E[];
Class_Descriptor cd__ZN3ccc8CC0x7y12E = {  "_ZN3ccc8CC0x7y12E", // class name
  bases__ZN3ccc8CC0x7y12E, 2,
  &(vtc__ZN3ccc8CC0x7y12E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x7y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x7y12E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x7y13  : ::ccc::AA0 , ::ccc::BB7 {
  virtual void  efg(); // _ZN3ccc8CC0x7y133efgEv
  ~CC0x7y13(); // tgen
  CC0x7y13(); // tgen
};
//SIG(1 _ZN3ccc8CC0x7y13E) C1{ BC2{ v2 v1 v3} BC3{ v4 v5} v1}
}
namespace ccc { 
void  ccc::CC0x7y13 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x7y133efgEv");}
ccc::CC0x7y13 ::~CC0x7y13(){ note_dtor("_ZN3ccc8CC0x7y13E", this);} // tgen
ccc::CC0x7y13 ::CC0x7y13(){ note_ctor("_ZN3ccc8CC0x7y13E", this);} // tgen
}
static void Test__ZN3ccc8CC0x7y13E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x7y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x7y13E, buf);
    ::ccc::CC0x7y13 *dp, &lv = *(dp=new (buf) ::ccc::CC0x7y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x7y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x7y13E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x7y13E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc8CC0x7y13E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x7y13E);
    dp->::ccc::CC0x7y13::~CC0x7y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x7y13E(Test__ZN3ccc8CC0x7y13E, "_ZN3ccc8CC0x7y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x7y13C1Ev();
extern void _ZN3ccc8CC0x7y13D1Ev();
Name_Map name_map__ZN3ccc8CC0x7y13E[] = {
  NSPAIR(_ZN3ccc8CC0x7y13C1Ev),
  NSPAIR(_ZN3ccc8CC0x7y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8CC0x7y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x7y13E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc8CC0x7y133efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc3BB73abcEv();
extern void _ZN3ccc3BB73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x7y13E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x7y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x7y133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x7y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x7y13E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x7y13E[];
Class_Descriptor cd__ZN3ccc8CC0x7y13E = {  "_ZN3ccc8CC0x7y13E", // class name
  bases__ZN3ccc8CC0x7y13E, 2,
  &(vtc__ZN3ccc8CC0x7y13E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x7y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x7y13E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x7y14  : ::ccc::AA0 , ::ccc::BB7 {
  virtual void  pqr(); // _ZN3ccc8CC0x7y143pqrEv
  ~CC0x7y14(); // tgen
  CC0x7y14(); // tgen
};
//SIG(1 _ZN3ccc8CC0x7y14E) C1{ BC2{ v2 v3 v1} BC3{ v4 v1} v1}
}
namespace ccc { 
void  ccc::CC0x7y14 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x7y143pqrEv");}
ccc::CC0x7y14 ::~CC0x7y14(){ note_dtor("_ZN3ccc8CC0x7y14E", this);} // tgen
ccc::CC0x7y14 ::CC0x7y14(){ note_ctor("_ZN3ccc8CC0x7y14E", this);} // tgen
}
static void Test__ZN3ccc8CC0x7y14E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x7y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x7y14E, buf);
    ::ccc::CC0x7y14 *dp, &lv = *(dp=new (buf) ::ccc::CC0x7y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x7y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x7y14E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x7y14E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc8CC0x7y14E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x7y14E);
    dp->::ccc::CC0x7y14::~CC0x7y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x7y14E(Test__ZN3ccc8CC0x7y14E, "_ZN3ccc8CC0x7y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x7y14C1Ev();
extern void _ZN3ccc8CC0x7y14D1Ev();
Name_Map name_map__ZN3ccc8CC0x7y14E[] = {
  NSPAIR(_ZN3ccc8CC0x7y14C1Ev),
  NSPAIR(_ZN3ccc8CC0x7y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8CC0x7y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x7y14E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc8CC0x7y143pqrEv();
extern void _ZN3ccc3BB73abcEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x7y143pqrEv,_ZThn4_N3ccc8CC0x7y143pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x7y14E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x7y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x7y143pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x7y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x7y143pqrEv,_ZThn4_N3ccc8CC0x7y143pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x7y14E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x7y14E[];
Class_Descriptor cd__ZN3ccc8CC0x7y14E = {  "_ZN3ccc8CC0x7y14E", // class name
  bases__ZN3ccc8CC0x7y14E, 2,
  &(vtc__ZN3ccc8CC0x7y14E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x7y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x7y14E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x7y15  : ::ccc::AA0 , ::ccc::BB7 {
  ~CC0x7y15(); // tgen
  CC0x7y15(); // tgen
};
//SIG(1 _ZN3ccc8CC0x7y15E) C1{ BC2{ v1 v2 v3} BC3{ v4 v5}}
}
namespace ccc { 
ccc::CC0x7y15 ::~CC0x7y15(){ note_dtor("_ZN3ccc8CC0x7y15E", this);} // tgen
ccc::CC0x7y15 ::CC0x7y15(){ note_ctor("_ZN3ccc8CC0x7y15E", this);} // tgen
}
static void Test__ZN3ccc8CC0x7y15E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x7y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x7y15E, buf);
    ::ccc::CC0x7y15 *dp, &lv = *(dp=new (buf) ::ccc::CC0x7y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x7y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x7y15E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x7y15E");
    check_base_class_offset(lv, (::ccc::BB7*), ABISELECT(8,4), "_ZN3ccc8CC0x7y15E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x7y15E);
    dp->::ccc::CC0x7y15::~CC0x7y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x7y15E(Test__ZN3ccc8CC0x7y15E, "_ZN3ccc8CC0x7y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x7y15C1Ev();
extern void _ZN3ccc8CC0x7y15D1Ev();
Name_Map name_map__ZN3ccc8CC0x7y15E[] = {
  NSPAIR(_ZN3ccc8CC0x7y15C1Ev),
  NSPAIR(_ZN3ccc8CC0x7y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB7E;
extern VTBL_ENTRY _ZTIN3ccc3BB7E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB7E[];
static Base_Class bases__ZN3ccc8CC0x7y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB7E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x7y15E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc3BB73abcEv();
extern void _ZN3ccc3BB73pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x7y15E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x7y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x7y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3BB73pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x7y15E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x7y15E[];
Class_Descriptor cd__ZN3ccc8CC0x7y15E = {  "_ZN3ccc8CC0x7y15E", // class name
  bases__ZN3ccc8CC0x7y15E, 2,
  &(vtc__ZN3ccc8CC0x7y15E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x7y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x7y15E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x8y0  : ::ccc::AA0 , ::ccc::BB8 {
  virtual void  abc(); // _ZN3ccc7CC0x8y03abcEv
  virtual void  efg(); // _ZN3ccc7CC0x8y03efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x8y03pqrEv
  ~CC0x8y0(); // tgen
  CC0x8y0(); // tgen
};
//SIG(1 _ZN3ccc7CC0x8y0E) C1{ BC2{ v1 v2 v3} BC3{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x8y0 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x8y03abcEv");}
void  ccc::CC0x8y0 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x8y03efgEv");}
void  ccc::CC0x8y0 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x8y03pqrEv");}
ccc::CC0x8y0 ::~CC0x8y0(){ note_dtor("_ZN3ccc7CC0x8y0E", this);} // tgen
ccc::CC0x8y0 ::CC0x8y0(){ note_ctor("_ZN3ccc7CC0x8y0E", this);} // tgen
}
static void Test__ZN3ccc7CC0x8y0E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x8y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x8y0E, buf);
    ::ccc::CC0x8y0 *dp, &lv = *(dp=new (buf) ::ccc::CC0x8y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x8y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x8y0E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x8y0E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc7CC0x8y0E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x8y0E);
    dp->::ccc::CC0x8y0::~CC0x8y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x8y0E(Test__ZN3ccc7CC0x8y0E, "_ZN3ccc7CC0x8y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x8y0C1Ev();
extern void _ZN3ccc7CC0x8y0D1Ev();
Name_Map name_map__ZN3ccc7CC0x8y0E[] = {
  NSPAIR(_ZN3ccc7CC0x8y0C1Ev),
  NSPAIR(_ZN3ccc7CC0x8y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7CC0x8y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x8y0E[];
extern void _ZN3ccc7CC0x8y03abcEv();
extern void _ZN3ccc7CC0x8y03efgEv();
extern void _ZN3ccc7CC0x8y03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x8y03efgEv,_ZThn4_N3ccc7CC0x8y03efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x8y03abcEv,_ZThn4_N3ccc7CC0x8y03abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x8y0E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x8y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x8y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x8y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x8y03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x8y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x8y03efgEv,_ZThn4_N3ccc7CC0x8y03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x8y03abcEv,_ZThn4_N3ccc7CC0x8y03abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x8y0E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x8y0E[];
Class_Descriptor cd__ZN3ccc7CC0x8y0E = {  "_ZN3ccc7CC0x8y0E", // class name
  bases__ZN3ccc7CC0x8y0E, 2,
  &(vtc__ZN3ccc7CC0x8y0E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x8y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x8y0E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x8y1  : ::ccc::AA0 , ::ccc::BB8 {
  virtual void  abc(); // _ZN3ccc7CC0x8y13abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x8y13pqrEv
  virtual void  efg(); // _ZN3ccc7CC0x8y13efgEv
  ~CC0x8y1(); // tgen
  CC0x8y1(); // tgen
};
//SIG(1 _ZN3ccc7CC0x8y1E) C1{ BC2{ v1 v3 v2} BC3{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x8y1 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x8y13abcEv");}
void  ccc::CC0x8y1 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x8y13pqrEv");}
void  ccc::CC0x8y1 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x8y13efgEv");}
ccc::CC0x8y1 ::~CC0x8y1(){ note_dtor("_ZN3ccc7CC0x8y1E", this);} // tgen
ccc::CC0x8y1 ::CC0x8y1(){ note_ctor("_ZN3ccc7CC0x8y1E", this);} // tgen
}
static void Test__ZN3ccc7CC0x8y1E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x8y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x8y1E, buf);
    ::ccc::CC0x8y1 *dp, &lv = *(dp=new (buf) ::ccc::CC0x8y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x8y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x8y1E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x8y1E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc7CC0x8y1E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x8y1E);
    dp->::ccc::CC0x8y1::~CC0x8y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x8y1E(Test__ZN3ccc7CC0x8y1E, "_ZN3ccc7CC0x8y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x8y1C1Ev();
extern void _ZN3ccc7CC0x8y1D1Ev();
Name_Map name_map__ZN3ccc7CC0x8y1E[] = {
  NSPAIR(_ZN3ccc7CC0x8y1C1Ev),
  NSPAIR(_ZN3ccc7CC0x8y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7CC0x8y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x8y1E[];
extern void _ZN3ccc7CC0x8y13abcEv();
extern void _ZN3ccc7CC0x8y13efgEv();
extern void _ZN3ccc7CC0x8y13pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x8y13efgEv,_ZThn4_N3ccc7CC0x8y13efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x8y13abcEv,_ZThn4_N3ccc7CC0x8y13abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x8y1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x8y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x8y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x8y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x8y13pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x8y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x8y13efgEv,_ZThn4_N3ccc7CC0x8y13efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x8y13abcEv,_ZThn4_N3ccc7CC0x8y13abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x8y1E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x8y1E[];
Class_Descriptor cd__ZN3ccc7CC0x8y1E = {  "_ZN3ccc7CC0x8y1E", // class name
  bases__ZN3ccc7CC0x8y1E, 2,
  &(vtc__ZN3ccc7CC0x8y1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x8y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x8y1E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x8y2  : ::ccc::AA0 , ::ccc::BB8 {
  virtual void  efg(); // _ZN3ccc7CC0x8y23efgEv
  virtual void  abc(); // _ZN3ccc7CC0x8y23abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x8y23pqrEv
  ~CC0x8y2(); // tgen
  CC0x8y2(); // tgen
};
//SIG(1 _ZN3ccc7CC0x8y2E) C1{ BC2{ v2 v1 v3} BC3{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x8y2 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x8y23efgEv");}
void  ccc::CC0x8y2 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x8y23abcEv");}
void  ccc::CC0x8y2 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x8y23pqrEv");}
ccc::CC0x8y2 ::~CC0x8y2(){ note_dtor("_ZN3ccc7CC0x8y2E", this);} // tgen
ccc::CC0x8y2 ::CC0x8y2(){ note_ctor("_ZN3ccc7CC0x8y2E", this);} // tgen
}
static void Test__ZN3ccc7CC0x8y2E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x8y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x8y2E, buf);
    ::ccc::CC0x8y2 *dp, &lv = *(dp=new (buf) ::ccc::CC0x8y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x8y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x8y2E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x8y2E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc7CC0x8y2E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x8y2E);
    dp->::ccc::CC0x8y2::~CC0x8y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x8y2E(Test__ZN3ccc7CC0x8y2E, "_ZN3ccc7CC0x8y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x8y2C1Ev();
extern void _ZN3ccc7CC0x8y2D1Ev();
Name_Map name_map__ZN3ccc7CC0x8y2E[] = {
  NSPAIR(_ZN3ccc7CC0x8y2C1Ev),
  NSPAIR(_ZN3ccc7CC0x8y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7CC0x8y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x8y2E[];
extern void _ZN3ccc7CC0x8y23abcEv();
extern void _ZN3ccc7CC0x8y23efgEv();
extern void _ZN3ccc7CC0x8y23pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x8y23efgEv,_ZThn4_N3ccc7CC0x8y23efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x8y23abcEv,_ZThn4_N3ccc7CC0x8y23abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x8y2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x8y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x8y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x8y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x8y23pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x8y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x8y23efgEv,_ZThn4_N3ccc7CC0x8y23efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x8y23abcEv,_ZThn4_N3ccc7CC0x8y23abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x8y2E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x8y2E[];
Class_Descriptor cd__ZN3ccc7CC0x8y2E = {  "_ZN3ccc7CC0x8y2E", // class name
  bases__ZN3ccc7CC0x8y2E, 2,
  &(vtc__ZN3ccc7CC0x8y2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x8y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x8y2E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x8y3  : ::ccc::AA0 , ::ccc::BB8 {
  virtual void  efg(); // _ZN3ccc7CC0x8y33efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x8y33pqrEv
  virtual void  abc(); // _ZN3ccc7CC0x8y33abcEv
  ~CC0x8y3(); // tgen
  CC0x8y3(); // tgen
};
//SIG(1 _ZN3ccc7CC0x8y3E) C1{ BC2{ v3 v1 v2} BC3{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x8y3 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x8y33efgEv");}
void  ccc::CC0x8y3 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x8y33pqrEv");}
void  ccc::CC0x8y3 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x8y33abcEv");}
ccc::CC0x8y3 ::~CC0x8y3(){ note_dtor("_ZN3ccc7CC0x8y3E", this);} // tgen
ccc::CC0x8y3 ::CC0x8y3(){ note_ctor("_ZN3ccc7CC0x8y3E", this);} // tgen
}
static void Test__ZN3ccc7CC0x8y3E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x8y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x8y3E, buf);
    ::ccc::CC0x8y3 *dp, &lv = *(dp=new (buf) ::ccc::CC0x8y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x8y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x8y3E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x8y3E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc7CC0x8y3E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x8y3E);
    dp->::ccc::CC0x8y3::~CC0x8y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x8y3E(Test__ZN3ccc7CC0x8y3E, "_ZN3ccc7CC0x8y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x8y3C1Ev();
extern void _ZN3ccc7CC0x8y3D1Ev();
Name_Map name_map__ZN3ccc7CC0x8y3E[] = {
  NSPAIR(_ZN3ccc7CC0x8y3C1Ev),
  NSPAIR(_ZN3ccc7CC0x8y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7CC0x8y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x8y3E[];
extern void _ZN3ccc7CC0x8y33abcEv();
extern void _ZN3ccc7CC0x8y33efgEv();
extern void _ZN3ccc7CC0x8y33pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x8y33efgEv,_ZThn4_N3ccc7CC0x8y33efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x8y33abcEv,_ZThn4_N3ccc7CC0x8y33abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x8y3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x8y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x8y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x8y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x8y33pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x8y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x8y33efgEv,_ZThn4_N3ccc7CC0x8y33efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x8y33abcEv,_ZThn4_N3ccc7CC0x8y33abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x8y3E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x8y3E[];
Class_Descriptor cd__ZN3ccc7CC0x8y3E = {  "_ZN3ccc7CC0x8y3E", // class name
  bases__ZN3ccc7CC0x8y3E, 2,
  &(vtc__ZN3ccc7CC0x8y3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x8y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x8y3E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x8y4  : ::ccc::AA0 , ::ccc::BB8 {
  virtual void  pqr(); // _ZN3ccc7CC0x8y43pqrEv
  virtual void  abc(); // _ZN3ccc7CC0x8y43abcEv
  virtual void  efg(); // _ZN3ccc7CC0x8y43efgEv
  ~CC0x8y4(); // tgen
  CC0x8y4(); // tgen
};
//SIG(1 _ZN3ccc7CC0x8y4E) C1{ BC2{ v2 v3 v1} BC3{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x8y4 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x8y43pqrEv");}
void  ccc::CC0x8y4 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x8y43abcEv");}
void  ccc::CC0x8y4 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x8y43efgEv");}
ccc::CC0x8y4 ::~CC0x8y4(){ note_dtor("_ZN3ccc7CC0x8y4E", this);} // tgen
ccc::CC0x8y4 ::CC0x8y4(){ note_ctor("_ZN3ccc7CC0x8y4E", this);} // tgen
}
static void Test__ZN3ccc7CC0x8y4E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x8y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x8y4E, buf);
    ::ccc::CC0x8y4 *dp, &lv = *(dp=new (buf) ::ccc::CC0x8y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x8y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x8y4E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x8y4E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc7CC0x8y4E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x8y4E);
    dp->::ccc::CC0x8y4::~CC0x8y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x8y4E(Test__ZN3ccc7CC0x8y4E, "_ZN3ccc7CC0x8y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x8y4C1Ev();
extern void _ZN3ccc7CC0x8y4D1Ev();
Name_Map name_map__ZN3ccc7CC0x8y4E[] = {
  NSPAIR(_ZN3ccc7CC0x8y4C1Ev),
  NSPAIR(_ZN3ccc7CC0x8y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7CC0x8y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x8y4E[];
extern void _ZN3ccc7CC0x8y43abcEv();
extern void _ZN3ccc7CC0x8y43efgEv();
extern void _ZN3ccc7CC0x8y43pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x8y43efgEv,_ZThn4_N3ccc7CC0x8y43efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x8y43abcEv,_ZThn4_N3ccc7CC0x8y43abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x8y4E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x8y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x8y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x8y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x8y43pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x8y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x8y43efgEv,_ZThn4_N3ccc7CC0x8y43efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x8y43abcEv,_ZThn4_N3ccc7CC0x8y43abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x8y4E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x8y4E[];
Class_Descriptor cd__ZN3ccc7CC0x8y4E = {  "_ZN3ccc7CC0x8y4E", // class name
  bases__ZN3ccc7CC0x8y4E, 2,
  &(vtc__ZN3ccc7CC0x8y4E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x8y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x8y4E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x8y5  : ::ccc::AA0 , ::ccc::BB8 {
  virtual void  pqr(); // _ZN3ccc7CC0x8y53pqrEv
  virtual void  efg(); // _ZN3ccc7CC0x8y53efgEv
  virtual void  abc(); // _ZN3ccc7CC0x8y53abcEv
  ~CC0x8y5(); // tgen
  CC0x8y5(); // tgen
};
//SIG(1 _ZN3ccc7CC0x8y5E) C1{ BC2{ v3 v2 v1} BC3{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x8y5 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x8y53pqrEv");}
void  ccc::CC0x8y5 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x8y53efgEv");}
void  ccc::CC0x8y5 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x8y53abcEv");}
ccc::CC0x8y5 ::~CC0x8y5(){ note_dtor("_ZN3ccc7CC0x8y5E", this);} // tgen
ccc::CC0x8y5 ::CC0x8y5(){ note_ctor("_ZN3ccc7CC0x8y5E", this);} // tgen
}
static void Test__ZN3ccc7CC0x8y5E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x8y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x8y5E, buf);
    ::ccc::CC0x8y5 *dp, &lv = *(dp=new (buf) ::ccc::CC0x8y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x8y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x8y5E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x8y5E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc7CC0x8y5E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x8y5E);
    dp->::ccc::CC0x8y5::~CC0x8y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x8y5E(Test__ZN3ccc7CC0x8y5E, "_ZN3ccc7CC0x8y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x8y5C1Ev();
extern void _ZN3ccc7CC0x8y5D1Ev();
Name_Map name_map__ZN3ccc7CC0x8y5E[] = {
  NSPAIR(_ZN3ccc7CC0x8y5C1Ev),
  NSPAIR(_ZN3ccc7CC0x8y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7CC0x8y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x8y5E[];
extern void _ZN3ccc7CC0x8y53abcEv();
extern void _ZN3ccc7CC0x8y53efgEv();
extern void _ZN3ccc7CC0x8y53pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x8y53efgEv,_ZThn4_N3ccc7CC0x8y53efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x8y53abcEv,_ZThn4_N3ccc7CC0x8y53abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x8y5E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x8y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x8y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x8y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x8y53pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x8y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x8y53efgEv,_ZThn4_N3ccc7CC0x8y53efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x8y53abcEv,_ZThn4_N3ccc7CC0x8y53abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x8y5E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x8y5E[];
Class_Descriptor cd__ZN3ccc7CC0x8y5E = {  "_ZN3ccc7CC0x8y5E", // class name
  bases__ZN3ccc7CC0x8y5E, 2,
  &(vtc__ZN3ccc7CC0x8y5E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x8y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x8y5E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x8y6  : ::ccc::AA0 , ::ccc::BB8 {
  virtual void  abc(); // _ZN3ccc7CC0x8y63abcEv
  virtual void  efg(); // _ZN3ccc7CC0x8y63efgEv
  ~CC0x8y6(); // tgen
  CC0x8y6(); // tgen
};
//SIG(1 _ZN3ccc7CC0x8y6E) C1{ BC2{ v1 v2 v3} BC3{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x8y6 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x8y63abcEv");}
void  ccc::CC0x8y6 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x8y63efgEv");}
ccc::CC0x8y6 ::~CC0x8y6(){ note_dtor("_ZN3ccc7CC0x8y6E", this);} // tgen
ccc::CC0x8y6 ::CC0x8y6(){ note_ctor("_ZN3ccc7CC0x8y6E", this);} // tgen
}
static void Test__ZN3ccc7CC0x8y6E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x8y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x8y6E, buf);
    ::ccc::CC0x8y6 *dp, &lv = *(dp=new (buf) ::ccc::CC0x8y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x8y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x8y6E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x8y6E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc7CC0x8y6E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x8y6E);
    dp->::ccc::CC0x8y6::~CC0x8y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x8y6E(Test__ZN3ccc7CC0x8y6E, "_ZN3ccc7CC0x8y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x8y6C1Ev();
extern void _ZN3ccc7CC0x8y6D1Ev();
Name_Map name_map__ZN3ccc7CC0x8y6E[] = {
  NSPAIR(_ZN3ccc7CC0x8y6C1Ev),
  NSPAIR(_ZN3ccc7CC0x8y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7CC0x8y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x8y6E[];
extern void _ZN3ccc7CC0x8y63abcEv();
extern void _ZN3ccc7CC0x8y63efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x8y63efgEv,_ZThn4_N3ccc7CC0x8y63efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x8y63abcEv,_ZThn4_N3ccc7CC0x8y63abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x8y6E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x8y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x8y63abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x8y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x8y6E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x8y63efgEv,_ZThn4_N3ccc7CC0x8y63efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x8y63abcEv,_ZThn4_N3ccc7CC0x8y63abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x8y6E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x8y6E[];
Class_Descriptor cd__ZN3ccc7CC0x8y6E = {  "_ZN3ccc7CC0x8y6E", // class name
  bases__ZN3ccc7CC0x8y6E, 2,
  &(vtc__ZN3ccc7CC0x8y6E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x8y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x8y6E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x8y7  : ::ccc::AA0 , ::ccc::BB8 {
  virtual void  abc(); // _ZN3ccc7CC0x8y73abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x8y73pqrEv
  ~CC0x8y7(); // tgen
  CC0x8y7(); // tgen
};
//SIG(1 _ZN3ccc7CC0x8y7E) C1{ BC2{ v1 v3 v2} BC3{ v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x8y7 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x8y73abcEv");}
void  ccc::CC0x8y7 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x8y73pqrEv");}
ccc::CC0x8y7 ::~CC0x8y7(){ note_dtor("_ZN3ccc7CC0x8y7E", this);} // tgen
ccc::CC0x8y7 ::CC0x8y7(){ note_ctor("_ZN3ccc7CC0x8y7E", this);} // tgen
}
static void Test__ZN3ccc7CC0x8y7E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x8y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x8y7E, buf);
    ::ccc::CC0x8y7 *dp, &lv = *(dp=new (buf) ::ccc::CC0x8y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x8y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x8y7E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x8y7E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc7CC0x8y7E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x8y7E);
    dp->::ccc::CC0x8y7::~CC0x8y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x8y7E(Test__ZN3ccc7CC0x8y7E, "_ZN3ccc7CC0x8y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x8y7C1Ev();
extern void _ZN3ccc7CC0x8y7D1Ev();
Name_Map name_map__ZN3ccc7CC0x8y7E[] = {
  NSPAIR(_ZN3ccc7CC0x8y7C1Ev),
  NSPAIR(_ZN3ccc7CC0x8y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7CC0x8y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x8y7E[];
extern void _ZN3ccc7CC0x8y73abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc7CC0x8y73pqrEv();
extern void _ZN3ccc3BB83efgEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x8y73abcEv,_ZThn4_N3ccc7CC0x8y73abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x8y7E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x8y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x8y73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x8y73pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x8y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB83efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x8y73abcEv,_ZThn4_N3ccc7CC0x8y73abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x8y7E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x8y7E[];
Class_Descriptor cd__ZN3ccc7CC0x8y7E = {  "_ZN3ccc7CC0x8y7E", // class name
  bases__ZN3ccc7CC0x8y7E, 2,
  &(vtc__ZN3ccc7CC0x8y7E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x8y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x8y7E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x8y8  : ::ccc::AA0 , ::ccc::BB8 {
  virtual void  efg(); // _ZN3ccc7CC0x8y83efgEv
  virtual void  abc(); // _ZN3ccc7CC0x8y83abcEv
  ~CC0x8y8(); // tgen
  CC0x8y8(); // tgen
};
//SIG(1 _ZN3ccc7CC0x8y8E) C1{ BC2{ v2 v1 v3} BC3{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x8y8 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x8y83efgEv");}
void  ccc::CC0x8y8 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x8y83abcEv");}
ccc::CC0x8y8 ::~CC0x8y8(){ note_dtor("_ZN3ccc7CC0x8y8E", this);} // tgen
ccc::CC0x8y8 ::CC0x8y8(){ note_ctor("_ZN3ccc7CC0x8y8E", this);} // tgen
}
static void Test__ZN3ccc7CC0x8y8E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x8y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x8y8E, buf);
    ::ccc::CC0x8y8 *dp, &lv = *(dp=new (buf) ::ccc::CC0x8y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x8y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x8y8E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x8y8E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc7CC0x8y8E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x8y8E);
    dp->::ccc::CC0x8y8::~CC0x8y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x8y8E(Test__ZN3ccc7CC0x8y8E, "_ZN3ccc7CC0x8y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x8y8C1Ev();
extern void _ZN3ccc7CC0x8y8D1Ev();
Name_Map name_map__ZN3ccc7CC0x8y8E[] = {
  NSPAIR(_ZN3ccc7CC0x8y8C1Ev),
  NSPAIR(_ZN3ccc7CC0x8y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7CC0x8y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x8y8E[];
extern void _ZN3ccc7CC0x8y83abcEv();
extern void _ZN3ccc7CC0x8y83efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x8y83efgEv,_ZThn4_N3ccc7CC0x8y83efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x8y83abcEv,_ZThn4_N3ccc7CC0x8y83abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x8y8E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x8y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x8y83abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x8y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x8y8E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x8y83efgEv,_ZThn4_N3ccc7CC0x8y83efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x8y83abcEv,_ZThn4_N3ccc7CC0x8y83abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x8y8E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x8y8E[];
Class_Descriptor cd__ZN3ccc7CC0x8y8E = {  "_ZN3ccc7CC0x8y8E", // class name
  bases__ZN3ccc7CC0x8y8E, 2,
  &(vtc__ZN3ccc7CC0x8y8E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x8y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x8y8E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x8y9  : ::ccc::AA0 , ::ccc::BB8 {
  virtual void  efg(); // _ZN3ccc7CC0x8y93efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x8y93pqrEv
  ~CC0x8y9(); // tgen
  CC0x8y9(); // tgen
};
//SIG(1 _ZN3ccc7CC0x8y9E) C1{ BC2{ v3 v1 v2} BC3{ v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x8y9 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x8y93efgEv");}
void  ccc::CC0x8y9 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x8y93pqrEv");}
ccc::CC0x8y9 ::~CC0x8y9(){ note_dtor("_ZN3ccc7CC0x8y9E", this);} // tgen
ccc::CC0x8y9 ::CC0x8y9(){ note_ctor("_ZN3ccc7CC0x8y9E", this);} // tgen
}
static void Test__ZN3ccc7CC0x8y9E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x8y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x8y9E, buf);
    ::ccc::CC0x8y9 *dp, &lv = *(dp=new (buf) ::ccc::CC0x8y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x8y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x8y9E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x8y9E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc7CC0x8y9E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x8y9E);
    dp->::ccc::CC0x8y9::~CC0x8y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x8y9E(Test__ZN3ccc7CC0x8y9E, "_ZN3ccc7CC0x8y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x8y9C1Ev();
extern void _ZN3ccc7CC0x8y9D1Ev();
Name_Map name_map__ZN3ccc7CC0x8y9E[] = {
  NSPAIR(_ZN3ccc7CC0x8y9C1Ev),
  NSPAIR(_ZN3ccc7CC0x8y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc7CC0x8y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x8y9E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc7CC0x8y93efgEv();
extern void _ZN3ccc7CC0x8y93pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x8y93efgEv,_ZThn4_N3ccc7CC0x8y93efgEv)();
extern void _ZN3ccc3BB83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x8y9E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x8y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x8y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x8y93pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x8y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x8y93efgEv,_ZThn4_N3ccc7CC0x8y93efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB83abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x8y9E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x8y9E[];
Class_Descriptor cd__ZN3ccc7CC0x8y9E = {  "_ZN3ccc7CC0x8y9E", // class name
  bases__ZN3ccc7CC0x8y9E, 2,
  &(vtc__ZN3ccc7CC0x8y9E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x8y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x8y9E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x8y10  : ::ccc::AA0 , ::ccc::BB8 {
  virtual void  pqr(); // _ZN3ccc8CC0x8y103pqrEv
  virtual void  abc(); // _ZN3ccc8CC0x8y103abcEv
  ~CC0x8y10(); // tgen
  CC0x8y10(); // tgen
};
//SIG(1 _ZN3ccc8CC0x8y10E) C1{ BC2{ v2 v3 v1} BC3{ v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x8y10 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x8y103pqrEv");}
void  ccc::CC0x8y10 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x8y103abcEv");}
ccc::CC0x8y10 ::~CC0x8y10(){ note_dtor("_ZN3ccc8CC0x8y10E", this);} // tgen
ccc::CC0x8y10 ::CC0x8y10(){ note_ctor("_ZN3ccc8CC0x8y10E", this);} // tgen
}
static void Test__ZN3ccc8CC0x8y10E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x8y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x8y10E, buf);
    ::ccc::CC0x8y10 *dp, &lv = *(dp=new (buf) ::ccc::CC0x8y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x8y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x8y10E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x8y10E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc8CC0x8y10E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x8y10E);
    dp->::ccc::CC0x8y10::~CC0x8y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x8y10E(Test__ZN3ccc8CC0x8y10E, "_ZN3ccc8CC0x8y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x8y10C1Ev();
extern void _ZN3ccc8CC0x8y10D1Ev();
Name_Map name_map__ZN3ccc8CC0x8y10E[] = {
  NSPAIR(_ZN3ccc8CC0x8y10C1Ev),
  NSPAIR(_ZN3ccc8CC0x8y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8CC0x8y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x8y10E[];
extern void _ZN3ccc8CC0x8y103abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc8CC0x8y103pqrEv();
extern void _ZN3ccc3BB83efgEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x8y103abcEv,_ZThn4_N3ccc8CC0x8y103abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x8y10E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x8y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x8y103abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x8y103pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x8y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB83efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x8y103abcEv,_ZThn4_N3ccc8CC0x8y103abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x8y10E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x8y10E[];
Class_Descriptor cd__ZN3ccc8CC0x8y10E = {  "_ZN3ccc8CC0x8y10E", // class name
  bases__ZN3ccc8CC0x8y10E, 2,
  &(vtc__ZN3ccc8CC0x8y10E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x8y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x8y10E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x8y11  : ::ccc::AA0 , ::ccc::BB8 {
  virtual void  pqr(); // _ZN3ccc8CC0x8y113pqrEv
  virtual void  efg(); // _ZN3ccc8CC0x8y113efgEv
  ~CC0x8y11(); // tgen
  CC0x8y11(); // tgen
};
//SIG(1 _ZN3ccc8CC0x8y11E) C1{ BC2{ v3 v2 v1} BC3{ v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x8y11 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x8y113pqrEv");}
void  ccc::CC0x8y11 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x8y113efgEv");}
ccc::CC0x8y11 ::~CC0x8y11(){ note_dtor("_ZN3ccc8CC0x8y11E", this);} // tgen
ccc::CC0x8y11 ::CC0x8y11(){ note_ctor("_ZN3ccc8CC0x8y11E", this);} // tgen
}
static void Test__ZN3ccc8CC0x8y11E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x8y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x8y11E, buf);
    ::ccc::CC0x8y11 *dp, &lv = *(dp=new (buf) ::ccc::CC0x8y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x8y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x8y11E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x8y11E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc8CC0x8y11E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x8y11E);
    dp->::ccc::CC0x8y11::~CC0x8y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x8y11E(Test__ZN3ccc8CC0x8y11E, "_ZN3ccc8CC0x8y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x8y11C1Ev();
extern void _ZN3ccc8CC0x8y11D1Ev();
Name_Map name_map__ZN3ccc8CC0x8y11E[] = {
  NSPAIR(_ZN3ccc8CC0x8y11C1Ev),
  NSPAIR(_ZN3ccc8CC0x8y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8CC0x8y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x8y11E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc8CC0x8y113efgEv();
extern void _ZN3ccc8CC0x8y113pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x8y113efgEv,_ZThn4_N3ccc8CC0x8y113efgEv)();
extern void _ZN3ccc3BB83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x8y11E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x8y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x8y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x8y113pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x8y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x8y113efgEv,_ZThn4_N3ccc8CC0x8y113efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB83abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x8y11E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x8y11E[];
Class_Descriptor cd__ZN3ccc8CC0x8y11E = {  "_ZN3ccc8CC0x8y11E", // class name
  bases__ZN3ccc8CC0x8y11E, 2,
  &(vtc__ZN3ccc8CC0x8y11E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x8y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x8y11E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x8y12  : ::ccc::AA0 , ::ccc::BB8 {
  virtual void  abc(); // _ZN3ccc8CC0x8y123abcEv
  ~CC0x8y12(); // tgen
  CC0x8y12(); // tgen
};
//SIG(1 _ZN3ccc8CC0x8y12E) C1{ BC2{ v1 v2 v3} BC3{ v4 v1} v1}
}
namespace ccc { 
void  ccc::CC0x8y12 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x8y123abcEv");}
ccc::CC0x8y12 ::~CC0x8y12(){ note_dtor("_ZN3ccc8CC0x8y12E", this);} // tgen
ccc::CC0x8y12 ::CC0x8y12(){ note_ctor("_ZN3ccc8CC0x8y12E", this);} // tgen
}
static void Test__ZN3ccc8CC0x8y12E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x8y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x8y12E, buf);
    ::ccc::CC0x8y12 *dp, &lv = *(dp=new (buf) ::ccc::CC0x8y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x8y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x8y12E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x8y12E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc8CC0x8y12E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x8y12E);
    dp->::ccc::CC0x8y12::~CC0x8y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x8y12E(Test__ZN3ccc8CC0x8y12E, "_ZN3ccc8CC0x8y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x8y12C1Ev();
extern void _ZN3ccc8CC0x8y12D1Ev();
Name_Map name_map__ZN3ccc8CC0x8y12E[] = {
  NSPAIR(_ZN3ccc8CC0x8y12C1Ev),
  NSPAIR(_ZN3ccc8CC0x8y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8CC0x8y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x8y12E[];
extern void _ZN3ccc8CC0x8y123abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc3BB83efgEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x8y123abcEv,_ZThn4_N3ccc8CC0x8y123abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x8y12E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x8y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x8y123abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x8y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB83efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x8y123abcEv,_ZThn4_N3ccc8CC0x8y123abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x8y12E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x8y12E[];
Class_Descriptor cd__ZN3ccc8CC0x8y12E = {  "_ZN3ccc8CC0x8y12E", // class name
  bases__ZN3ccc8CC0x8y12E, 2,
  &(vtc__ZN3ccc8CC0x8y12E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x8y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x8y12E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x8y13  : ::ccc::AA0 , ::ccc::BB8 {
  virtual void  efg(); // _ZN3ccc8CC0x8y133efgEv
  ~CC0x8y13(); // tgen
  CC0x8y13(); // tgen
};
//SIG(1 _ZN3ccc8CC0x8y13E) C1{ BC2{ v2 v1 v3} BC3{ v1 v4} v1}
}
namespace ccc { 
void  ccc::CC0x8y13 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x8y133efgEv");}
ccc::CC0x8y13 ::~CC0x8y13(){ note_dtor("_ZN3ccc8CC0x8y13E", this);} // tgen
ccc::CC0x8y13 ::CC0x8y13(){ note_ctor("_ZN3ccc8CC0x8y13E", this);} // tgen
}
static void Test__ZN3ccc8CC0x8y13E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x8y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x8y13E, buf);
    ::ccc::CC0x8y13 *dp, &lv = *(dp=new (buf) ::ccc::CC0x8y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x8y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x8y13E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x8y13E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc8CC0x8y13E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x8y13E);
    dp->::ccc::CC0x8y13::~CC0x8y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x8y13E(Test__ZN3ccc8CC0x8y13E, "_ZN3ccc8CC0x8y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x8y13C1Ev();
extern void _ZN3ccc8CC0x8y13D1Ev();
Name_Map name_map__ZN3ccc8CC0x8y13E[] = {
  NSPAIR(_ZN3ccc8CC0x8y13C1Ev),
  NSPAIR(_ZN3ccc8CC0x8y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8CC0x8y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x8y13E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc8CC0x8y133efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x8y133efgEv,_ZThn4_N3ccc8CC0x8y133efgEv)();
extern void _ZN3ccc3BB83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x8y13E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x8y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x8y133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x8y13E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x8y133efgEv,_ZThn4_N3ccc8CC0x8y133efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB83abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x8y13E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x8y13E[];
Class_Descriptor cd__ZN3ccc8CC0x8y13E = {  "_ZN3ccc8CC0x8y13E", // class name
  bases__ZN3ccc8CC0x8y13E, 2,
  &(vtc__ZN3ccc8CC0x8y13E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x8y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x8y13E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x8y14  : ::ccc::AA0 , ::ccc::BB8 {
  virtual void  pqr(); // _ZN3ccc8CC0x8y143pqrEv
  ~CC0x8y14(); // tgen
  CC0x8y14(); // tgen
};
//SIG(1 _ZN3ccc8CC0x8y14E) C1{ BC2{ v2 v3 v1} BC3{ v4 v5} v1}
}
namespace ccc { 
void  ccc::CC0x8y14 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x8y143pqrEv");}
ccc::CC0x8y14 ::~CC0x8y14(){ note_dtor("_ZN3ccc8CC0x8y14E", this);} // tgen
ccc::CC0x8y14 ::CC0x8y14(){ note_ctor("_ZN3ccc8CC0x8y14E", this);} // tgen
}
static void Test__ZN3ccc8CC0x8y14E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x8y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x8y14E, buf);
    ::ccc::CC0x8y14 *dp, &lv = *(dp=new (buf) ::ccc::CC0x8y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x8y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x8y14E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x8y14E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc8CC0x8y14E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x8y14E);
    dp->::ccc::CC0x8y14::~CC0x8y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x8y14E(Test__ZN3ccc8CC0x8y14E, "_ZN3ccc8CC0x8y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x8y14C1Ev();
extern void _ZN3ccc8CC0x8y14D1Ev();
Name_Map name_map__ZN3ccc8CC0x8y14E[] = {
  NSPAIR(_ZN3ccc8CC0x8y14C1Ev),
  NSPAIR(_ZN3ccc8CC0x8y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8CC0x8y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x8y14E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc8CC0x8y143pqrEv();
extern void _ZN3ccc3BB83efgEv();
extern void _ZN3ccc3BB83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x8y14E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x8y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x8y143pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x8y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB83abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x8y14E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x8y14E[];
Class_Descriptor cd__ZN3ccc8CC0x8y14E = {  "_ZN3ccc8CC0x8y14E", // class name
  bases__ZN3ccc8CC0x8y14E, 2,
  &(vtc__ZN3ccc8CC0x8y14E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x8y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x8y14E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x8y15  : ::ccc::AA0 , ::ccc::BB8 {
  ~CC0x8y15(); // tgen
  CC0x8y15(); // tgen
};
//SIG(1 _ZN3ccc8CC0x8y15E) C1{ BC2{ v1 v2 v3} BC3{ v4 v5}}
}
namespace ccc { 
ccc::CC0x8y15 ::~CC0x8y15(){ note_dtor("_ZN3ccc8CC0x8y15E", this);} // tgen
ccc::CC0x8y15 ::CC0x8y15(){ note_ctor("_ZN3ccc8CC0x8y15E", this);} // tgen
}
static void Test__ZN3ccc8CC0x8y15E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x8y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x8y15E, buf);
    ::ccc::CC0x8y15 *dp, &lv = *(dp=new (buf) ::ccc::CC0x8y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x8y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x8y15E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x8y15E");
    check_base_class_offset(lv, (::ccc::BB8*), ABISELECT(8,4), "_ZN3ccc8CC0x8y15E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x8y15E);
    dp->::ccc::CC0x8y15::~CC0x8y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x8y15E(Test__ZN3ccc8CC0x8y15E, "_ZN3ccc8CC0x8y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x8y15C1Ev();
extern void _ZN3ccc8CC0x8y15D1Ev();
Name_Map name_map__ZN3ccc8CC0x8y15E[] = {
  NSPAIR(_ZN3ccc8CC0x8y15C1Ev),
  NSPAIR(_ZN3ccc8CC0x8y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB8E;
extern VTBL_ENTRY _ZTIN3ccc3BB8E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB8E[];
static Base_Class bases__ZN3ccc8CC0x8y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB8E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x8y15E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc3BB83efgEv();
extern void _ZN3ccc3BB83abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x8y15E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x8y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x8y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB83abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x8y15E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x8y15E[];
Class_Descriptor cd__ZN3ccc8CC0x8y15E = {  "_ZN3ccc8CC0x8y15E", // class name
  bases__ZN3ccc8CC0x8y15E, 2,
  &(vtc__ZN3ccc8CC0x8y15E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x8y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x8y15E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x9y0  : ::ccc::AA0 , ::ccc::BB9 {
  virtual void  abc(); // _ZN3ccc7CC0x9y03abcEv
  virtual void  efg(); // _ZN3ccc7CC0x9y03efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x9y03pqrEv
  ~CC0x9y0(); // tgen
  CC0x9y0(); // tgen
};
//SIG(1 _ZN3ccc7CC0x9y0E) C1{ BC2{ v1 v2 v3} BC3{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x9y0 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x9y03abcEv");}
void  ccc::CC0x9y0 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x9y03efgEv");}
void  ccc::CC0x9y0 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x9y03pqrEv");}
ccc::CC0x9y0 ::~CC0x9y0(){ note_dtor("_ZN3ccc7CC0x9y0E", this);} // tgen
ccc::CC0x9y0 ::CC0x9y0(){ note_ctor("_ZN3ccc7CC0x9y0E", this);} // tgen
}
static void Test__ZN3ccc7CC0x9y0E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x9y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x9y0E, buf);
    ::ccc::CC0x9y0 *dp, &lv = *(dp=new (buf) ::ccc::CC0x9y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x9y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x9y0E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x9y0E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc7CC0x9y0E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x9y0E);
    dp->::ccc::CC0x9y0::~CC0x9y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x9y0E(Test__ZN3ccc7CC0x9y0E, "_ZN3ccc7CC0x9y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x9y0C1Ev();
extern void _ZN3ccc7CC0x9y0D1Ev();
Name_Map name_map__ZN3ccc7CC0x9y0E[] = {
  NSPAIR(_ZN3ccc7CC0x9y0C1Ev),
  NSPAIR(_ZN3ccc7CC0x9y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc7CC0x9y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x9y0E[];
extern void _ZN3ccc7CC0x9y03abcEv();
extern void _ZN3ccc7CC0x9y03efgEv();
extern void _ZN3ccc7CC0x9y03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x9y03efgEv,_ZThn4_N3ccc7CC0x9y03efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x9y03pqrEv,_ZThn4_N3ccc7CC0x9y03pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x9y0E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x9y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x9y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x9y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x9y03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x9y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x9y03efgEv,_ZThn4_N3ccc7CC0x9y03efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x9y03pqrEv,_ZThn4_N3ccc7CC0x9y03pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x9y0E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x9y0E[];
Class_Descriptor cd__ZN3ccc7CC0x9y0E = {  "_ZN3ccc7CC0x9y0E", // class name
  bases__ZN3ccc7CC0x9y0E, 2,
  &(vtc__ZN3ccc7CC0x9y0E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x9y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x9y0E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x9y1  : ::ccc::AA0 , ::ccc::BB9 {
  virtual void  abc(); // _ZN3ccc7CC0x9y13abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x9y13pqrEv
  virtual void  efg(); // _ZN3ccc7CC0x9y13efgEv
  ~CC0x9y1(); // tgen
  CC0x9y1(); // tgen
};
//SIG(1 _ZN3ccc7CC0x9y1E) C1{ BC2{ v1 v3 v2} BC3{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x9y1 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x9y13abcEv");}
void  ccc::CC0x9y1 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x9y13pqrEv");}
void  ccc::CC0x9y1 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x9y13efgEv");}
ccc::CC0x9y1 ::~CC0x9y1(){ note_dtor("_ZN3ccc7CC0x9y1E", this);} // tgen
ccc::CC0x9y1 ::CC0x9y1(){ note_ctor("_ZN3ccc7CC0x9y1E", this);} // tgen
}
static void Test__ZN3ccc7CC0x9y1E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x9y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x9y1E, buf);
    ::ccc::CC0x9y1 *dp, &lv = *(dp=new (buf) ::ccc::CC0x9y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x9y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x9y1E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x9y1E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc7CC0x9y1E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x9y1E);
    dp->::ccc::CC0x9y1::~CC0x9y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x9y1E(Test__ZN3ccc7CC0x9y1E, "_ZN3ccc7CC0x9y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x9y1C1Ev();
extern void _ZN3ccc7CC0x9y1D1Ev();
Name_Map name_map__ZN3ccc7CC0x9y1E[] = {
  NSPAIR(_ZN3ccc7CC0x9y1C1Ev),
  NSPAIR(_ZN3ccc7CC0x9y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc7CC0x9y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x9y1E[];
extern void _ZN3ccc7CC0x9y13abcEv();
extern void _ZN3ccc7CC0x9y13efgEv();
extern void _ZN3ccc7CC0x9y13pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x9y13efgEv,_ZThn4_N3ccc7CC0x9y13efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x9y13pqrEv,_ZThn4_N3ccc7CC0x9y13pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x9y1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x9y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x9y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x9y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x9y13pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x9y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x9y13efgEv,_ZThn4_N3ccc7CC0x9y13efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x9y13pqrEv,_ZThn4_N3ccc7CC0x9y13pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x9y1E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x9y1E[];
Class_Descriptor cd__ZN3ccc7CC0x9y1E = {  "_ZN3ccc7CC0x9y1E", // class name
  bases__ZN3ccc7CC0x9y1E, 2,
  &(vtc__ZN3ccc7CC0x9y1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x9y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x9y1E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x9y2  : ::ccc::AA0 , ::ccc::BB9 {
  virtual void  efg(); // _ZN3ccc7CC0x9y23efgEv
  virtual void  abc(); // _ZN3ccc7CC0x9y23abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x9y23pqrEv
  ~CC0x9y2(); // tgen
  CC0x9y2(); // tgen
};
//SIG(1 _ZN3ccc7CC0x9y2E) C1{ BC2{ v2 v1 v3} BC3{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x9y2 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x9y23efgEv");}
void  ccc::CC0x9y2 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x9y23abcEv");}
void  ccc::CC0x9y2 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x9y23pqrEv");}
ccc::CC0x9y2 ::~CC0x9y2(){ note_dtor("_ZN3ccc7CC0x9y2E", this);} // tgen
ccc::CC0x9y2 ::CC0x9y2(){ note_ctor("_ZN3ccc7CC0x9y2E", this);} // tgen
}
static void Test__ZN3ccc7CC0x9y2E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x9y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x9y2E, buf);
    ::ccc::CC0x9y2 *dp, &lv = *(dp=new (buf) ::ccc::CC0x9y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x9y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x9y2E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x9y2E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc7CC0x9y2E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x9y2E);
    dp->::ccc::CC0x9y2::~CC0x9y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x9y2E(Test__ZN3ccc7CC0x9y2E, "_ZN3ccc7CC0x9y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x9y2C1Ev();
extern void _ZN3ccc7CC0x9y2D1Ev();
Name_Map name_map__ZN3ccc7CC0x9y2E[] = {
  NSPAIR(_ZN3ccc7CC0x9y2C1Ev),
  NSPAIR(_ZN3ccc7CC0x9y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc7CC0x9y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x9y2E[];
extern void _ZN3ccc7CC0x9y23abcEv();
extern void _ZN3ccc7CC0x9y23efgEv();
extern void _ZN3ccc7CC0x9y23pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x9y23efgEv,_ZThn4_N3ccc7CC0x9y23efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x9y23pqrEv,_ZThn4_N3ccc7CC0x9y23pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x9y2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x9y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x9y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x9y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x9y23pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x9y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x9y23efgEv,_ZThn4_N3ccc7CC0x9y23efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x9y23pqrEv,_ZThn4_N3ccc7CC0x9y23pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x9y2E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x9y2E[];
Class_Descriptor cd__ZN3ccc7CC0x9y2E = {  "_ZN3ccc7CC0x9y2E", // class name
  bases__ZN3ccc7CC0x9y2E, 2,
  &(vtc__ZN3ccc7CC0x9y2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x9y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x9y2E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x9y3  : ::ccc::AA0 , ::ccc::BB9 {
  virtual void  efg(); // _ZN3ccc7CC0x9y33efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x9y33pqrEv
  virtual void  abc(); // _ZN3ccc7CC0x9y33abcEv
  ~CC0x9y3(); // tgen
  CC0x9y3(); // tgen
};
//SIG(1 _ZN3ccc7CC0x9y3E) C1{ BC2{ v3 v1 v2} BC3{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x9y3 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x9y33efgEv");}
void  ccc::CC0x9y3 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x9y33pqrEv");}
void  ccc::CC0x9y3 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x9y33abcEv");}
ccc::CC0x9y3 ::~CC0x9y3(){ note_dtor("_ZN3ccc7CC0x9y3E", this);} // tgen
ccc::CC0x9y3 ::CC0x9y3(){ note_ctor("_ZN3ccc7CC0x9y3E", this);} // tgen
}
static void Test__ZN3ccc7CC0x9y3E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x9y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x9y3E, buf);
    ::ccc::CC0x9y3 *dp, &lv = *(dp=new (buf) ::ccc::CC0x9y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x9y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x9y3E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x9y3E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc7CC0x9y3E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x9y3E);
    dp->::ccc::CC0x9y3::~CC0x9y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x9y3E(Test__ZN3ccc7CC0x9y3E, "_ZN3ccc7CC0x9y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x9y3C1Ev();
extern void _ZN3ccc7CC0x9y3D1Ev();
Name_Map name_map__ZN3ccc7CC0x9y3E[] = {
  NSPAIR(_ZN3ccc7CC0x9y3C1Ev),
  NSPAIR(_ZN3ccc7CC0x9y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc7CC0x9y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x9y3E[];
extern void _ZN3ccc7CC0x9y33abcEv();
extern void _ZN3ccc7CC0x9y33efgEv();
extern void _ZN3ccc7CC0x9y33pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x9y33efgEv,_ZThn4_N3ccc7CC0x9y33efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x9y33pqrEv,_ZThn4_N3ccc7CC0x9y33pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x9y3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x9y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x9y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x9y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x9y33pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x9y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x9y33efgEv,_ZThn4_N3ccc7CC0x9y33efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x9y33pqrEv,_ZThn4_N3ccc7CC0x9y33pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x9y3E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x9y3E[];
Class_Descriptor cd__ZN3ccc7CC0x9y3E = {  "_ZN3ccc7CC0x9y3E", // class name
  bases__ZN3ccc7CC0x9y3E, 2,
  &(vtc__ZN3ccc7CC0x9y3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x9y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x9y3E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x9y4  : ::ccc::AA0 , ::ccc::BB9 {
  virtual void  pqr(); // _ZN3ccc7CC0x9y43pqrEv
  virtual void  abc(); // _ZN3ccc7CC0x9y43abcEv
  virtual void  efg(); // _ZN3ccc7CC0x9y43efgEv
  ~CC0x9y4(); // tgen
  CC0x9y4(); // tgen
};
//SIG(1 _ZN3ccc7CC0x9y4E) C1{ BC2{ v2 v3 v1} BC3{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x9y4 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x9y43pqrEv");}
void  ccc::CC0x9y4 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x9y43abcEv");}
void  ccc::CC0x9y4 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x9y43efgEv");}
ccc::CC0x9y4 ::~CC0x9y4(){ note_dtor("_ZN3ccc7CC0x9y4E", this);} // tgen
ccc::CC0x9y4 ::CC0x9y4(){ note_ctor("_ZN3ccc7CC0x9y4E", this);} // tgen
}
static void Test__ZN3ccc7CC0x9y4E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x9y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x9y4E, buf);
    ::ccc::CC0x9y4 *dp, &lv = *(dp=new (buf) ::ccc::CC0x9y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x9y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x9y4E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x9y4E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc7CC0x9y4E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x9y4E);
    dp->::ccc::CC0x9y4::~CC0x9y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x9y4E(Test__ZN3ccc7CC0x9y4E, "_ZN3ccc7CC0x9y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x9y4C1Ev();
extern void _ZN3ccc7CC0x9y4D1Ev();
Name_Map name_map__ZN3ccc7CC0x9y4E[] = {
  NSPAIR(_ZN3ccc7CC0x9y4C1Ev),
  NSPAIR(_ZN3ccc7CC0x9y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc7CC0x9y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x9y4E[];
extern void _ZN3ccc7CC0x9y43abcEv();
extern void _ZN3ccc7CC0x9y43efgEv();
extern void _ZN3ccc7CC0x9y43pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x9y43efgEv,_ZThn4_N3ccc7CC0x9y43efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x9y43pqrEv,_ZThn4_N3ccc7CC0x9y43pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x9y4E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x9y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x9y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x9y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x9y43pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x9y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x9y43efgEv,_ZThn4_N3ccc7CC0x9y43efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x9y43pqrEv,_ZThn4_N3ccc7CC0x9y43pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x9y4E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x9y4E[];
Class_Descriptor cd__ZN3ccc7CC0x9y4E = {  "_ZN3ccc7CC0x9y4E", // class name
  bases__ZN3ccc7CC0x9y4E, 2,
  &(vtc__ZN3ccc7CC0x9y4E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x9y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x9y4E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x9y5  : ::ccc::AA0 , ::ccc::BB9 {
  virtual void  pqr(); // _ZN3ccc7CC0x9y53pqrEv
  virtual void  efg(); // _ZN3ccc7CC0x9y53efgEv
  virtual void  abc(); // _ZN3ccc7CC0x9y53abcEv
  ~CC0x9y5(); // tgen
  CC0x9y5(); // tgen
};
//SIG(1 _ZN3ccc7CC0x9y5E) C1{ BC2{ v3 v2 v1} BC3{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x9y5 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x9y53pqrEv");}
void  ccc::CC0x9y5 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x9y53efgEv");}
void  ccc::CC0x9y5 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x9y53abcEv");}
ccc::CC0x9y5 ::~CC0x9y5(){ note_dtor("_ZN3ccc7CC0x9y5E", this);} // tgen
ccc::CC0x9y5 ::CC0x9y5(){ note_ctor("_ZN3ccc7CC0x9y5E", this);} // tgen
}
static void Test__ZN3ccc7CC0x9y5E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x9y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x9y5E, buf);
    ::ccc::CC0x9y5 *dp, &lv = *(dp=new (buf) ::ccc::CC0x9y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x9y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x9y5E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x9y5E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc7CC0x9y5E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x9y5E);
    dp->::ccc::CC0x9y5::~CC0x9y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x9y5E(Test__ZN3ccc7CC0x9y5E, "_ZN3ccc7CC0x9y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x9y5C1Ev();
extern void _ZN3ccc7CC0x9y5D1Ev();
Name_Map name_map__ZN3ccc7CC0x9y5E[] = {
  NSPAIR(_ZN3ccc7CC0x9y5C1Ev),
  NSPAIR(_ZN3ccc7CC0x9y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc7CC0x9y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x9y5E[];
extern void _ZN3ccc7CC0x9y53abcEv();
extern void _ZN3ccc7CC0x9y53efgEv();
extern void _ZN3ccc7CC0x9y53pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x9y53efgEv,_ZThn4_N3ccc7CC0x9y53efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x9y53pqrEv,_ZThn4_N3ccc7CC0x9y53pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x9y5E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x9y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x9y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x9y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x9y53pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x9y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x9y53efgEv,_ZThn4_N3ccc7CC0x9y53efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x9y53pqrEv,_ZThn4_N3ccc7CC0x9y53pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x9y5E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x9y5E[];
Class_Descriptor cd__ZN3ccc7CC0x9y5E = {  "_ZN3ccc7CC0x9y5E", // class name
  bases__ZN3ccc7CC0x9y5E, 2,
  &(vtc__ZN3ccc7CC0x9y5E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x9y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x9y5E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x9y6  : ::ccc::AA0 , ::ccc::BB9 {
  virtual void  abc(); // _ZN3ccc7CC0x9y63abcEv
  virtual void  efg(); // _ZN3ccc7CC0x9y63efgEv
  ~CC0x9y6(); // tgen
  CC0x9y6(); // tgen
};
//SIG(1 _ZN3ccc7CC0x9y6E) C1{ BC2{ v1 v2 v3} BC3{ v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x9y6 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x9y63abcEv");}
void  ccc::CC0x9y6 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x9y63efgEv");}
ccc::CC0x9y6 ::~CC0x9y6(){ note_dtor("_ZN3ccc7CC0x9y6E", this);} // tgen
ccc::CC0x9y6 ::CC0x9y6(){ note_ctor("_ZN3ccc7CC0x9y6E", this);} // tgen
}
static void Test__ZN3ccc7CC0x9y6E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x9y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x9y6E, buf);
    ::ccc::CC0x9y6 *dp, &lv = *(dp=new (buf) ::ccc::CC0x9y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x9y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x9y6E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x9y6E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc7CC0x9y6E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x9y6E);
    dp->::ccc::CC0x9y6::~CC0x9y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x9y6E(Test__ZN3ccc7CC0x9y6E, "_ZN3ccc7CC0x9y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x9y6C1Ev();
extern void _ZN3ccc7CC0x9y6D1Ev();
Name_Map name_map__ZN3ccc7CC0x9y6E[] = {
  NSPAIR(_ZN3ccc7CC0x9y6C1Ev),
  NSPAIR(_ZN3ccc7CC0x9y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc7CC0x9y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x9y6E[];
extern void _ZN3ccc7CC0x9y63abcEv();
extern void _ZN3ccc7CC0x9y63efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x9y63efgEv,_ZThn4_N3ccc7CC0x9y63efgEv)();
extern void _ZN3ccc3BB93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x9y6E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x9y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x9y63abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x9y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x9y6E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x9y63efgEv,_ZThn4_N3ccc7CC0x9y63efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB93pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x9y6E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x9y6E[];
Class_Descriptor cd__ZN3ccc7CC0x9y6E = {  "_ZN3ccc7CC0x9y6E", // class name
  bases__ZN3ccc7CC0x9y6E, 2,
  &(vtc__ZN3ccc7CC0x9y6E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x9y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x9y6E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x9y7  : ::ccc::AA0 , ::ccc::BB9 {
  virtual void  abc(); // _ZN3ccc7CC0x9y73abcEv
  virtual void  pqr(); // _ZN3ccc7CC0x9y73pqrEv
  ~CC0x9y7(); // tgen
  CC0x9y7(); // tgen
};
//SIG(1 _ZN3ccc7CC0x9y7E) C1{ BC2{ v1 v3 v2} BC3{ v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x9y7 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x9y73abcEv");}
void  ccc::CC0x9y7 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x9y73pqrEv");}
ccc::CC0x9y7 ::~CC0x9y7(){ note_dtor("_ZN3ccc7CC0x9y7E", this);} // tgen
ccc::CC0x9y7 ::CC0x9y7(){ note_ctor("_ZN3ccc7CC0x9y7E", this);} // tgen
}
static void Test__ZN3ccc7CC0x9y7E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x9y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x9y7E, buf);
    ::ccc::CC0x9y7 *dp, &lv = *(dp=new (buf) ::ccc::CC0x9y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x9y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x9y7E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x9y7E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc7CC0x9y7E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x9y7E);
    dp->::ccc::CC0x9y7::~CC0x9y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x9y7E(Test__ZN3ccc7CC0x9y7E, "_ZN3ccc7CC0x9y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x9y7C1Ev();
extern void _ZN3ccc7CC0x9y7D1Ev();
Name_Map name_map__ZN3ccc7CC0x9y7E[] = {
  NSPAIR(_ZN3ccc7CC0x9y7C1Ev),
  NSPAIR(_ZN3ccc7CC0x9y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc7CC0x9y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x9y7E[];
extern void _ZN3ccc7CC0x9y73abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc7CC0x9y73pqrEv();
extern void _ZN3ccc3BB93efgEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x9y73pqrEv,_ZThn4_N3ccc7CC0x9y73pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x9y7E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x9y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x9y73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x9y73pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x9y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB93efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x9y73pqrEv,_ZThn4_N3ccc7CC0x9y73pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x9y7E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x9y7E[];
Class_Descriptor cd__ZN3ccc7CC0x9y7E = {  "_ZN3ccc7CC0x9y7E", // class name
  bases__ZN3ccc7CC0x9y7E, 2,
  &(vtc__ZN3ccc7CC0x9y7E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x9y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x9y7E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x9y8  : ::ccc::AA0 , ::ccc::BB9 {
  virtual void  efg(); // _ZN3ccc7CC0x9y83efgEv
  virtual void  abc(); // _ZN3ccc7CC0x9y83abcEv
  ~CC0x9y8(); // tgen
  CC0x9y8(); // tgen
};
//SIG(1 _ZN3ccc7CC0x9y8E) C1{ BC2{ v2 v1 v3} BC3{ v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x9y8 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x9y83efgEv");}
void  ccc::CC0x9y8 ::abc(){vfunc_called(this, "_ZN3ccc7CC0x9y83abcEv");}
ccc::CC0x9y8 ::~CC0x9y8(){ note_dtor("_ZN3ccc7CC0x9y8E", this);} // tgen
ccc::CC0x9y8 ::CC0x9y8(){ note_ctor("_ZN3ccc7CC0x9y8E", this);} // tgen
}
static void Test__ZN3ccc7CC0x9y8E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x9y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x9y8E, buf);
    ::ccc::CC0x9y8 *dp, &lv = *(dp=new (buf) ::ccc::CC0x9y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x9y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x9y8E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x9y8E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc7CC0x9y8E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x9y8E);
    dp->::ccc::CC0x9y8::~CC0x9y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x9y8E(Test__ZN3ccc7CC0x9y8E, "_ZN3ccc7CC0x9y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x9y8C1Ev();
extern void _ZN3ccc7CC0x9y8D1Ev();
Name_Map name_map__ZN3ccc7CC0x9y8E[] = {
  NSPAIR(_ZN3ccc7CC0x9y8C1Ev),
  NSPAIR(_ZN3ccc7CC0x9y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc7CC0x9y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x9y8E[];
extern void _ZN3ccc7CC0x9y83abcEv();
extern void _ZN3ccc7CC0x9y83efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x9y83efgEv,_ZThn4_N3ccc7CC0x9y83efgEv)();
extern void _ZN3ccc3BB93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x9y8E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x9y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc7CC0x9y83abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x9y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x9y8E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x9y83efgEv,_ZThn4_N3ccc7CC0x9y83efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB93pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x9y8E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x9y8E[];
Class_Descriptor cd__ZN3ccc7CC0x9y8E = {  "_ZN3ccc7CC0x9y8E", // class name
  bases__ZN3ccc7CC0x9y8E, 2,
  &(vtc__ZN3ccc7CC0x9y8E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x9y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x9y8E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x9y9  : ::ccc::AA0 , ::ccc::BB9 {
  virtual void  efg(); // _ZN3ccc7CC0x9y93efgEv
  virtual void  pqr(); // _ZN3ccc7CC0x9y93pqrEv
  ~CC0x9y9(); // tgen
  CC0x9y9(); // tgen
};
//SIG(1 _ZN3ccc7CC0x9y9E) C1{ BC2{ v3 v1 v2} BC3{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x9y9 ::efg(){vfunc_called(this, "_ZN3ccc7CC0x9y93efgEv");}
void  ccc::CC0x9y9 ::pqr(){vfunc_called(this, "_ZN3ccc7CC0x9y93pqrEv");}
ccc::CC0x9y9 ::~CC0x9y9(){ note_dtor("_ZN3ccc7CC0x9y9E", this);} // tgen
ccc::CC0x9y9 ::CC0x9y9(){ note_ctor("_ZN3ccc7CC0x9y9E", this);} // tgen
}
static void Test__ZN3ccc7CC0x9y9E()
{
  extern Class_Descriptor cd__ZN3ccc7CC0x9y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc7CC0x9y9E, buf);
    ::ccc::CC0x9y9 *dp, &lv = *(dp=new (buf) ::ccc::CC0x9y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc7CC0x9y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc7CC0x9y9E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc7CC0x9y9E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc7CC0x9y9E");
    test_class_info(&lv, &cd__ZN3ccc7CC0x9y9E);
    dp->::ccc::CC0x9y9::~CC0x9y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc7CC0x9y9E(Test__ZN3ccc7CC0x9y9E, "_ZN3ccc7CC0x9y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc7CC0x9y9C1Ev();
extern void _ZN3ccc7CC0x9y9D1Ev();
Name_Map name_map__ZN3ccc7CC0x9y9E[] = {
  NSPAIR(_ZN3ccc7CC0x9y9C1Ev),
  NSPAIR(_ZN3ccc7CC0x9y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc7CC0x9y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc7CC0x9y9E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc7CC0x9y93efgEv();
extern void _ZN3ccc7CC0x9y93pqrEv();
extern void ABISELECT(_ZThn8_N3ccc7CC0x9y93efgEv,_ZThn4_N3ccc7CC0x9y93efgEv)();
extern void ABISELECT(_ZThn8_N3ccc7CC0x9y93pqrEv,_ZThn4_N3ccc7CC0x9y93pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc7CC0x9y9E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x9y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x9y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc7CC0x9y93pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc7CC0x9y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x9y93efgEv,_ZThn4_N3ccc7CC0x9y93efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc7CC0x9y93pqrEv,_ZThn4_N3ccc7CC0x9y93pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc7CC0x9y9E[];
extern  VTBL_ENTRY _ZTVN3ccc7CC0x9y9E[];
Class_Descriptor cd__ZN3ccc7CC0x9y9E = {  "_ZN3ccc7CC0x9y9E", // class name
  bases__ZN3ccc7CC0x9y9E, 2,
  &(vtc__ZN3ccc7CC0x9y9E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc7CC0x9y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc7CC0x9y9E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x9y10  : ::ccc::AA0 , ::ccc::BB9 {
  virtual void  pqr(); // _ZN3ccc8CC0x9y103pqrEv
  virtual void  abc(); // _ZN3ccc8CC0x9y103abcEv
  ~CC0x9y10(); // tgen
  CC0x9y10(); // tgen
};
//SIG(1 _ZN3ccc8CC0x9y10E) C1{ BC2{ v2 v3 v1} BC3{ v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x9y10 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x9y103pqrEv");}
void  ccc::CC0x9y10 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x9y103abcEv");}
ccc::CC0x9y10 ::~CC0x9y10(){ note_dtor("_ZN3ccc8CC0x9y10E", this);} // tgen
ccc::CC0x9y10 ::CC0x9y10(){ note_ctor("_ZN3ccc8CC0x9y10E", this);} // tgen
}
static void Test__ZN3ccc8CC0x9y10E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x9y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x9y10E, buf);
    ::ccc::CC0x9y10 *dp, &lv = *(dp=new (buf) ::ccc::CC0x9y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x9y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x9y10E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x9y10E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc8CC0x9y10E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x9y10E);
    dp->::ccc::CC0x9y10::~CC0x9y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x9y10E(Test__ZN3ccc8CC0x9y10E, "_ZN3ccc8CC0x9y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x9y10C1Ev();
extern void _ZN3ccc8CC0x9y10D1Ev();
Name_Map name_map__ZN3ccc8CC0x9y10E[] = {
  NSPAIR(_ZN3ccc8CC0x9y10C1Ev),
  NSPAIR(_ZN3ccc8CC0x9y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc8CC0x9y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x9y10E[];
extern void _ZN3ccc8CC0x9y103abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc8CC0x9y103pqrEv();
extern void _ZN3ccc3BB93efgEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x9y103pqrEv,_ZThn4_N3ccc8CC0x9y103pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x9y10E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x9y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x9y103abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x9y103pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x9y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB93efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x9y103pqrEv,_ZThn4_N3ccc8CC0x9y103pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x9y10E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x9y10E[];
Class_Descriptor cd__ZN3ccc8CC0x9y10E = {  "_ZN3ccc8CC0x9y10E", // class name
  bases__ZN3ccc8CC0x9y10E, 2,
  &(vtc__ZN3ccc8CC0x9y10E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x9y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x9y10E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x9y11  : ::ccc::AA0 , ::ccc::BB9 {
  virtual void  pqr(); // _ZN3ccc8CC0x9y113pqrEv
  virtual void  efg(); // _ZN3ccc8CC0x9y113efgEv
  ~CC0x9y11(); // tgen
  CC0x9y11(); // tgen
};
//SIG(1 _ZN3ccc8CC0x9y11E) C1{ BC2{ v3 v2 v1} BC3{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x9y11 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x9y113pqrEv");}
void  ccc::CC0x9y11 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x9y113efgEv");}
ccc::CC0x9y11 ::~CC0x9y11(){ note_dtor("_ZN3ccc8CC0x9y11E", this);} // tgen
ccc::CC0x9y11 ::CC0x9y11(){ note_ctor("_ZN3ccc8CC0x9y11E", this);} // tgen
}
static void Test__ZN3ccc8CC0x9y11E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x9y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x9y11E, buf);
    ::ccc::CC0x9y11 *dp, &lv = *(dp=new (buf) ::ccc::CC0x9y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x9y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x9y11E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x9y11E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc8CC0x9y11E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x9y11E);
    dp->::ccc::CC0x9y11::~CC0x9y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x9y11E(Test__ZN3ccc8CC0x9y11E, "_ZN3ccc8CC0x9y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x9y11C1Ev();
extern void _ZN3ccc8CC0x9y11D1Ev();
Name_Map name_map__ZN3ccc8CC0x9y11E[] = {
  NSPAIR(_ZN3ccc8CC0x9y11C1Ev),
  NSPAIR(_ZN3ccc8CC0x9y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc8CC0x9y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x9y11E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc8CC0x9y113efgEv();
extern void _ZN3ccc8CC0x9y113pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x9y113efgEv,_ZThn4_N3ccc8CC0x9y113efgEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC0x9y113pqrEv,_ZThn4_N3ccc8CC0x9y113pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x9y11E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x9y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x9y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x9y113pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x9y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x9y113efgEv,_ZThn4_N3ccc8CC0x9y113efgEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x9y113pqrEv,_ZThn4_N3ccc8CC0x9y113pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x9y11E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x9y11E[];
Class_Descriptor cd__ZN3ccc8CC0x9y11E = {  "_ZN3ccc8CC0x9y11E", // class name
  bases__ZN3ccc8CC0x9y11E, 2,
  &(vtc__ZN3ccc8CC0x9y11E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x9y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x9y11E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x9y12  : ::ccc::AA0 , ::ccc::BB9 {
  virtual void  abc(); // _ZN3ccc8CC0x9y123abcEv
  ~CC0x9y12(); // tgen
  CC0x9y12(); // tgen
};
//SIG(1 _ZN3ccc8CC0x9y12E) C1{ BC2{ v1 v2 v3} BC3{ v4 v5} v1}
}
namespace ccc { 
void  ccc::CC0x9y12 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x9y123abcEv");}
ccc::CC0x9y12 ::~CC0x9y12(){ note_dtor("_ZN3ccc8CC0x9y12E", this);} // tgen
ccc::CC0x9y12 ::CC0x9y12(){ note_ctor("_ZN3ccc8CC0x9y12E", this);} // tgen
}
static void Test__ZN3ccc8CC0x9y12E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x9y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x9y12E, buf);
    ::ccc::CC0x9y12 *dp, &lv = *(dp=new (buf) ::ccc::CC0x9y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x9y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x9y12E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x9y12E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc8CC0x9y12E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x9y12E);
    dp->::ccc::CC0x9y12::~CC0x9y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x9y12E(Test__ZN3ccc8CC0x9y12E, "_ZN3ccc8CC0x9y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x9y12C1Ev();
extern void _ZN3ccc8CC0x9y12D1Ev();
Name_Map name_map__ZN3ccc8CC0x9y12E[] = {
  NSPAIR(_ZN3ccc8CC0x9y12C1Ev),
  NSPAIR(_ZN3ccc8CC0x9y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc8CC0x9y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x9y12E[];
extern void _ZN3ccc8CC0x9y123abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc3BB93efgEv();
extern void _ZN3ccc3BB93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x9y12E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x9y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x9y123abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x9y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB93pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x9y12E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x9y12E[];
Class_Descriptor cd__ZN3ccc8CC0x9y12E = {  "_ZN3ccc8CC0x9y12E", // class name
  bases__ZN3ccc8CC0x9y12E, 2,
  &(vtc__ZN3ccc8CC0x9y12E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x9y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x9y12E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x9y13  : ::ccc::AA0 , ::ccc::BB9 {
  virtual void  efg(); // _ZN3ccc8CC0x9y133efgEv
  ~CC0x9y13(); // tgen
  CC0x9y13(); // tgen
};
//SIG(1 _ZN3ccc8CC0x9y13E) C1{ BC2{ v2 v1 v3} BC3{ v1 v4} v1}
}
namespace ccc { 
void  ccc::CC0x9y13 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x9y133efgEv");}
ccc::CC0x9y13 ::~CC0x9y13(){ note_dtor("_ZN3ccc8CC0x9y13E", this);} // tgen
ccc::CC0x9y13 ::CC0x9y13(){ note_ctor("_ZN3ccc8CC0x9y13E", this);} // tgen
}
static void Test__ZN3ccc8CC0x9y13E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x9y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x9y13E, buf);
    ::ccc::CC0x9y13 *dp, &lv = *(dp=new (buf) ::ccc::CC0x9y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x9y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x9y13E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x9y13E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc8CC0x9y13E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x9y13E);
    dp->::ccc::CC0x9y13::~CC0x9y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x9y13E(Test__ZN3ccc8CC0x9y13E, "_ZN3ccc8CC0x9y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x9y13C1Ev();
extern void _ZN3ccc8CC0x9y13D1Ev();
Name_Map name_map__ZN3ccc8CC0x9y13E[] = {
  NSPAIR(_ZN3ccc8CC0x9y13C1Ev),
  NSPAIR(_ZN3ccc8CC0x9y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc8CC0x9y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x9y13E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc8CC0x9y133efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x9y133efgEv,_ZThn4_N3ccc8CC0x9y133efgEv)();
extern void _ZN3ccc3BB93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x9y13E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x9y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x9y133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x9y13E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x9y133efgEv,_ZThn4_N3ccc8CC0x9y133efgEv),
  (VTBL_ENTRY)&_ZN3ccc3BB93pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x9y13E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x9y13E[];
Class_Descriptor cd__ZN3ccc8CC0x9y13E = {  "_ZN3ccc8CC0x9y13E", // class name
  bases__ZN3ccc8CC0x9y13E, 2,
  &(vtc__ZN3ccc8CC0x9y13E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x9y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x9y13E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x9y14  : ::ccc::AA0 , ::ccc::BB9 {
  virtual void  pqr(); // _ZN3ccc8CC0x9y143pqrEv
  ~CC0x9y14(); // tgen
  CC0x9y14(); // tgen
};
//SIG(1 _ZN3ccc8CC0x9y14E) C1{ BC2{ v2 v3 v1} BC3{ v4 v1} v1}
}
namespace ccc { 
void  ccc::CC0x9y14 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x9y143pqrEv");}
ccc::CC0x9y14 ::~CC0x9y14(){ note_dtor("_ZN3ccc8CC0x9y14E", this);} // tgen
ccc::CC0x9y14 ::CC0x9y14(){ note_ctor("_ZN3ccc8CC0x9y14E", this);} // tgen
}
static void Test__ZN3ccc8CC0x9y14E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x9y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x9y14E, buf);
    ::ccc::CC0x9y14 *dp, &lv = *(dp=new (buf) ::ccc::CC0x9y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x9y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x9y14E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x9y14E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc8CC0x9y14E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x9y14E);
    dp->::ccc::CC0x9y14::~CC0x9y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x9y14E(Test__ZN3ccc8CC0x9y14E, "_ZN3ccc8CC0x9y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x9y14C1Ev();
extern void _ZN3ccc8CC0x9y14D1Ev();
Name_Map name_map__ZN3ccc8CC0x9y14E[] = {
  NSPAIR(_ZN3ccc8CC0x9y14C1Ev),
  NSPAIR(_ZN3ccc8CC0x9y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc8CC0x9y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x9y14E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc8CC0x9y143pqrEv();
extern void _ZN3ccc3BB93efgEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x9y143pqrEv,_ZThn4_N3ccc8CC0x9y143pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x9y14E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x9y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x9y143pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x9y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB93efgEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x9y143pqrEv,_ZThn4_N3ccc8CC0x9y143pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x9y14E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x9y14E[];
Class_Descriptor cd__ZN3ccc8CC0x9y14E = {  "_ZN3ccc8CC0x9y14E", // class name
  bases__ZN3ccc8CC0x9y14E, 2,
  &(vtc__ZN3ccc8CC0x9y14E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x9y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x9y14E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x9y15  : ::ccc::AA0 , ::ccc::BB9 {
  ~CC0x9y15(); // tgen
  CC0x9y15(); // tgen
};
//SIG(1 _ZN3ccc8CC0x9y15E) C1{ BC2{ v1 v2 v3} BC3{ v4 v5}}
}
namespace ccc { 
ccc::CC0x9y15 ::~CC0x9y15(){ note_dtor("_ZN3ccc8CC0x9y15E", this);} // tgen
ccc::CC0x9y15 ::CC0x9y15(){ note_ctor("_ZN3ccc8CC0x9y15E", this);} // tgen
}
static void Test__ZN3ccc8CC0x9y15E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x9y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x9y15E, buf);
    ::ccc::CC0x9y15 *dp, &lv = *(dp=new (buf) ::ccc::CC0x9y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x9y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x9y15E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x9y15E");
    check_base_class_offset(lv, (::ccc::BB9*), ABISELECT(8,4), "_ZN3ccc8CC0x9y15E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x9y15E);
    dp->::ccc::CC0x9y15::~CC0x9y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x9y15E(Test__ZN3ccc8CC0x9y15E, "_ZN3ccc8CC0x9y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x9y15C1Ev();
extern void _ZN3ccc8CC0x9y15D1Ev();
Name_Map name_map__ZN3ccc8CC0x9y15E[] = {
  NSPAIR(_ZN3ccc8CC0x9y15C1Ev),
  NSPAIR(_ZN3ccc8CC0x9y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc3BB9E;
extern VTBL_ENTRY _ZTIN3ccc3BB9E[];
extern  VTBL_ENTRY _ZTVN3ccc3BB9E[];
static Base_Class bases__ZN3ccc8CC0x9y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc3BB9E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x9y15E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc3BB93efgEv();
extern void _ZN3ccc3BB93pqrEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x9y15E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x9y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x9y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3BB93efgEv,
  (VTBL_ENTRY)&_ZN3ccc3BB93pqrEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x9y15E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x9y15E[];
Class_Descriptor cd__ZN3ccc8CC0x9y15E = {  "_ZN3ccc8CC0x9y15E", // class name
  bases__ZN3ccc8CC0x9y15E, 2,
  &(vtc__ZN3ccc8CC0x9y15E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x9y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x9y15E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x10y0  : ::ccc::AA0 , ::ccc::BB10 {
  virtual void  abc(); // _ZN3ccc8CC0x10y03abcEv
  virtual void  efg(); // _ZN3ccc8CC0x10y03efgEv
  virtual void  pqr(); // _ZN3ccc8CC0x10y03pqrEv
  ~CC0x10y0(); // tgen
  CC0x10y0(); // tgen
};
//SIG(1 _ZN3ccc8CC0x10y0E) C1{ BC2{ v1 v2 v3} BC3{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x10y0 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x10y03abcEv");}
void  ccc::CC0x10y0 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x10y03efgEv");}
void  ccc::CC0x10y0 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x10y03pqrEv");}
ccc::CC0x10y0 ::~CC0x10y0(){ note_dtor("_ZN3ccc8CC0x10y0E", this);} // tgen
ccc::CC0x10y0 ::CC0x10y0(){ note_ctor("_ZN3ccc8CC0x10y0E", this);} // tgen
}
static void Test__ZN3ccc8CC0x10y0E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x10y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x10y0E, buf);
    ::ccc::CC0x10y0 *dp, &lv = *(dp=new (buf) ::ccc::CC0x10y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x10y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x10y0E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x10y0E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc8CC0x10y0E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x10y0E);
    dp->::ccc::CC0x10y0::~CC0x10y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x10y0E(Test__ZN3ccc8CC0x10y0E, "_ZN3ccc8CC0x10y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x10y0C1Ev();
extern void _ZN3ccc8CC0x10y0D1Ev();
Name_Map name_map__ZN3ccc8CC0x10y0E[] = {
  NSPAIR(_ZN3ccc8CC0x10y0C1Ev),
  NSPAIR(_ZN3ccc8CC0x10y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc8CC0x10y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x10y0E[];
extern void _ZN3ccc8CC0x10y03abcEv();
extern void _ZN3ccc8CC0x10y03efgEv();
extern void _ZN3ccc8CC0x10y03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x10y03pqrEv,_ZThn4_N3ccc8CC0x10y03pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC0x10y03abcEv,_ZThn4_N3ccc8CC0x10y03abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x10y0E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x10y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x10y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x10y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x10y03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x10y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x10y03pqrEv,_ZThn4_N3ccc8CC0x10y03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x10y03abcEv,_ZThn4_N3ccc8CC0x10y03abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x10y0E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x10y0E[];
Class_Descriptor cd__ZN3ccc8CC0x10y0E = {  "_ZN3ccc8CC0x10y0E", // class name
  bases__ZN3ccc8CC0x10y0E, 2,
  &(vtc__ZN3ccc8CC0x10y0E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x10y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x10y0E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x10y1  : ::ccc::AA0 , ::ccc::BB10 {
  virtual void  abc(); // _ZN3ccc8CC0x10y13abcEv
  virtual void  pqr(); // _ZN3ccc8CC0x10y13pqrEv
  virtual void  efg(); // _ZN3ccc8CC0x10y13efgEv
  ~CC0x10y1(); // tgen
  CC0x10y1(); // tgen
};
//SIG(1 _ZN3ccc8CC0x10y1E) C1{ BC2{ v1 v3 v2} BC3{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x10y1 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x10y13abcEv");}
void  ccc::CC0x10y1 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x10y13pqrEv");}
void  ccc::CC0x10y1 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x10y13efgEv");}
ccc::CC0x10y1 ::~CC0x10y1(){ note_dtor("_ZN3ccc8CC0x10y1E", this);} // tgen
ccc::CC0x10y1 ::CC0x10y1(){ note_ctor("_ZN3ccc8CC0x10y1E", this);} // tgen
}
static void Test__ZN3ccc8CC0x10y1E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x10y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x10y1E, buf);
    ::ccc::CC0x10y1 *dp, &lv = *(dp=new (buf) ::ccc::CC0x10y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x10y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x10y1E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x10y1E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc8CC0x10y1E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x10y1E);
    dp->::ccc::CC0x10y1::~CC0x10y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x10y1E(Test__ZN3ccc8CC0x10y1E, "_ZN3ccc8CC0x10y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x10y1C1Ev();
extern void _ZN3ccc8CC0x10y1D1Ev();
Name_Map name_map__ZN3ccc8CC0x10y1E[] = {
  NSPAIR(_ZN3ccc8CC0x10y1C1Ev),
  NSPAIR(_ZN3ccc8CC0x10y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc8CC0x10y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x10y1E[];
extern void _ZN3ccc8CC0x10y13abcEv();
extern void _ZN3ccc8CC0x10y13efgEv();
extern void _ZN3ccc8CC0x10y13pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x10y13pqrEv,_ZThn4_N3ccc8CC0x10y13pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC0x10y13abcEv,_ZThn4_N3ccc8CC0x10y13abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x10y1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x10y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x10y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x10y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x10y13pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x10y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x10y13pqrEv,_ZThn4_N3ccc8CC0x10y13pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x10y13abcEv,_ZThn4_N3ccc8CC0x10y13abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x10y1E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x10y1E[];
Class_Descriptor cd__ZN3ccc8CC0x10y1E = {  "_ZN3ccc8CC0x10y1E", // class name
  bases__ZN3ccc8CC0x10y1E, 2,
  &(vtc__ZN3ccc8CC0x10y1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x10y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x10y1E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x10y2  : ::ccc::AA0 , ::ccc::BB10 {
  virtual void  efg(); // _ZN3ccc8CC0x10y23efgEv
  virtual void  abc(); // _ZN3ccc8CC0x10y23abcEv
  virtual void  pqr(); // _ZN3ccc8CC0x10y23pqrEv
  ~CC0x10y2(); // tgen
  CC0x10y2(); // tgen
};
//SIG(1 _ZN3ccc8CC0x10y2E) C1{ BC2{ v2 v1 v3} BC3{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x10y2 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x10y23efgEv");}
void  ccc::CC0x10y2 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x10y23abcEv");}
void  ccc::CC0x10y2 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x10y23pqrEv");}
ccc::CC0x10y2 ::~CC0x10y2(){ note_dtor("_ZN3ccc8CC0x10y2E", this);} // tgen
ccc::CC0x10y2 ::CC0x10y2(){ note_ctor("_ZN3ccc8CC0x10y2E", this);} // tgen
}
static void Test__ZN3ccc8CC0x10y2E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x10y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x10y2E, buf);
    ::ccc::CC0x10y2 *dp, &lv = *(dp=new (buf) ::ccc::CC0x10y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x10y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x10y2E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x10y2E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc8CC0x10y2E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x10y2E);
    dp->::ccc::CC0x10y2::~CC0x10y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x10y2E(Test__ZN3ccc8CC0x10y2E, "_ZN3ccc8CC0x10y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x10y2C1Ev();
extern void _ZN3ccc8CC0x10y2D1Ev();
Name_Map name_map__ZN3ccc8CC0x10y2E[] = {
  NSPAIR(_ZN3ccc8CC0x10y2C1Ev),
  NSPAIR(_ZN3ccc8CC0x10y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc8CC0x10y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x10y2E[];
extern void _ZN3ccc8CC0x10y23abcEv();
extern void _ZN3ccc8CC0x10y23efgEv();
extern void _ZN3ccc8CC0x10y23pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x10y23pqrEv,_ZThn4_N3ccc8CC0x10y23pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC0x10y23abcEv,_ZThn4_N3ccc8CC0x10y23abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x10y2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x10y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x10y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x10y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x10y23pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x10y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x10y23pqrEv,_ZThn4_N3ccc8CC0x10y23pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x10y23abcEv,_ZThn4_N3ccc8CC0x10y23abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x10y2E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x10y2E[];
Class_Descriptor cd__ZN3ccc8CC0x10y2E = {  "_ZN3ccc8CC0x10y2E", // class name
  bases__ZN3ccc8CC0x10y2E, 2,
  &(vtc__ZN3ccc8CC0x10y2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x10y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x10y2E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x10y3  : ::ccc::AA0 , ::ccc::BB10 {
  virtual void  efg(); // _ZN3ccc8CC0x10y33efgEv
  virtual void  pqr(); // _ZN3ccc8CC0x10y33pqrEv
  virtual void  abc(); // _ZN3ccc8CC0x10y33abcEv
  ~CC0x10y3(); // tgen
  CC0x10y3(); // tgen
};
//SIG(1 _ZN3ccc8CC0x10y3E) C1{ BC2{ v3 v1 v2} BC3{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x10y3 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x10y33efgEv");}
void  ccc::CC0x10y3 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x10y33pqrEv");}
void  ccc::CC0x10y3 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x10y33abcEv");}
ccc::CC0x10y3 ::~CC0x10y3(){ note_dtor("_ZN3ccc8CC0x10y3E", this);} // tgen
ccc::CC0x10y3 ::CC0x10y3(){ note_ctor("_ZN3ccc8CC0x10y3E", this);} // tgen
}
static void Test__ZN3ccc8CC0x10y3E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x10y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x10y3E, buf);
    ::ccc::CC0x10y3 *dp, &lv = *(dp=new (buf) ::ccc::CC0x10y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x10y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x10y3E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x10y3E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc8CC0x10y3E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x10y3E);
    dp->::ccc::CC0x10y3::~CC0x10y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x10y3E(Test__ZN3ccc8CC0x10y3E, "_ZN3ccc8CC0x10y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x10y3C1Ev();
extern void _ZN3ccc8CC0x10y3D1Ev();
Name_Map name_map__ZN3ccc8CC0x10y3E[] = {
  NSPAIR(_ZN3ccc8CC0x10y3C1Ev),
  NSPAIR(_ZN3ccc8CC0x10y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc8CC0x10y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x10y3E[];
extern void _ZN3ccc8CC0x10y33abcEv();
extern void _ZN3ccc8CC0x10y33efgEv();
extern void _ZN3ccc8CC0x10y33pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x10y33pqrEv,_ZThn4_N3ccc8CC0x10y33pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC0x10y33abcEv,_ZThn4_N3ccc8CC0x10y33abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x10y3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x10y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x10y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x10y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x10y33pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x10y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x10y33pqrEv,_ZThn4_N3ccc8CC0x10y33pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x10y33abcEv,_ZThn4_N3ccc8CC0x10y33abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x10y3E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x10y3E[];
Class_Descriptor cd__ZN3ccc8CC0x10y3E = {  "_ZN3ccc8CC0x10y3E", // class name
  bases__ZN3ccc8CC0x10y3E, 2,
  &(vtc__ZN3ccc8CC0x10y3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x10y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x10y3E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x10y4  : ::ccc::AA0 , ::ccc::BB10 {
  virtual void  pqr(); // _ZN3ccc8CC0x10y43pqrEv
  virtual void  abc(); // _ZN3ccc8CC0x10y43abcEv
  virtual void  efg(); // _ZN3ccc8CC0x10y43efgEv
  ~CC0x10y4(); // tgen
  CC0x10y4(); // tgen
};
//SIG(1 _ZN3ccc8CC0x10y4E) C1{ BC2{ v2 v3 v1} BC3{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x10y4 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x10y43pqrEv");}
void  ccc::CC0x10y4 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x10y43abcEv");}
void  ccc::CC0x10y4 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x10y43efgEv");}
ccc::CC0x10y4 ::~CC0x10y4(){ note_dtor("_ZN3ccc8CC0x10y4E", this);} // tgen
ccc::CC0x10y4 ::CC0x10y4(){ note_ctor("_ZN3ccc8CC0x10y4E", this);} // tgen
}
static void Test__ZN3ccc8CC0x10y4E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x10y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x10y4E, buf);
    ::ccc::CC0x10y4 *dp, &lv = *(dp=new (buf) ::ccc::CC0x10y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x10y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x10y4E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x10y4E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc8CC0x10y4E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x10y4E);
    dp->::ccc::CC0x10y4::~CC0x10y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x10y4E(Test__ZN3ccc8CC0x10y4E, "_ZN3ccc8CC0x10y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x10y4C1Ev();
extern void _ZN3ccc8CC0x10y4D1Ev();
Name_Map name_map__ZN3ccc8CC0x10y4E[] = {
  NSPAIR(_ZN3ccc8CC0x10y4C1Ev),
  NSPAIR(_ZN3ccc8CC0x10y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc8CC0x10y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x10y4E[];
extern void _ZN3ccc8CC0x10y43abcEv();
extern void _ZN3ccc8CC0x10y43efgEv();
extern void _ZN3ccc8CC0x10y43pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x10y43pqrEv,_ZThn4_N3ccc8CC0x10y43pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC0x10y43abcEv,_ZThn4_N3ccc8CC0x10y43abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x10y4E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x10y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x10y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x10y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x10y43pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x10y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x10y43pqrEv,_ZThn4_N3ccc8CC0x10y43pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x10y43abcEv,_ZThn4_N3ccc8CC0x10y43abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x10y4E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x10y4E[];
Class_Descriptor cd__ZN3ccc8CC0x10y4E = {  "_ZN3ccc8CC0x10y4E", // class name
  bases__ZN3ccc8CC0x10y4E, 2,
  &(vtc__ZN3ccc8CC0x10y4E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x10y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x10y4E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x10y5  : ::ccc::AA0 , ::ccc::BB10 {
  virtual void  pqr(); // _ZN3ccc8CC0x10y53pqrEv
  virtual void  efg(); // _ZN3ccc8CC0x10y53efgEv
  virtual void  abc(); // _ZN3ccc8CC0x10y53abcEv
  ~CC0x10y5(); // tgen
  CC0x10y5(); // tgen
};
//SIG(1 _ZN3ccc8CC0x10y5E) C1{ BC2{ v3 v2 v1} BC3{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x10y5 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x10y53pqrEv");}
void  ccc::CC0x10y5 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x10y53efgEv");}
void  ccc::CC0x10y5 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x10y53abcEv");}
ccc::CC0x10y5 ::~CC0x10y5(){ note_dtor("_ZN3ccc8CC0x10y5E", this);} // tgen
ccc::CC0x10y5 ::CC0x10y5(){ note_ctor("_ZN3ccc8CC0x10y5E", this);} // tgen
}
static void Test__ZN3ccc8CC0x10y5E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x10y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x10y5E, buf);
    ::ccc::CC0x10y5 *dp, &lv = *(dp=new (buf) ::ccc::CC0x10y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x10y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x10y5E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x10y5E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc8CC0x10y5E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x10y5E);
    dp->::ccc::CC0x10y5::~CC0x10y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x10y5E(Test__ZN3ccc8CC0x10y5E, "_ZN3ccc8CC0x10y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x10y5C1Ev();
extern void _ZN3ccc8CC0x10y5D1Ev();
Name_Map name_map__ZN3ccc8CC0x10y5E[] = {
  NSPAIR(_ZN3ccc8CC0x10y5C1Ev),
  NSPAIR(_ZN3ccc8CC0x10y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc8CC0x10y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x10y5E[];
extern void _ZN3ccc8CC0x10y53abcEv();
extern void _ZN3ccc8CC0x10y53efgEv();
extern void _ZN3ccc8CC0x10y53pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x10y53pqrEv,_ZThn4_N3ccc8CC0x10y53pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC0x10y53abcEv,_ZThn4_N3ccc8CC0x10y53abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x10y5E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x10y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x10y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x10y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x10y53pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x10y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x10y53pqrEv,_ZThn4_N3ccc8CC0x10y53pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x10y53abcEv,_ZThn4_N3ccc8CC0x10y53abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x10y5E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x10y5E[];
Class_Descriptor cd__ZN3ccc8CC0x10y5E = {  "_ZN3ccc8CC0x10y5E", // class name
  bases__ZN3ccc8CC0x10y5E, 2,
  &(vtc__ZN3ccc8CC0x10y5E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x10y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x10y5E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x10y6  : ::ccc::AA0 , ::ccc::BB10 {
  virtual void  abc(); // _ZN3ccc8CC0x10y63abcEv
  virtual void  efg(); // _ZN3ccc8CC0x10y63efgEv
  ~CC0x10y6(); // tgen
  CC0x10y6(); // tgen
};
//SIG(1 _ZN3ccc8CC0x10y6E) C1{ BC2{ v1 v2 v3} BC3{ v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x10y6 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x10y63abcEv");}
void  ccc::CC0x10y6 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x10y63efgEv");}
ccc::CC0x10y6 ::~CC0x10y6(){ note_dtor("_ZN3ccc8CC0x10y6E", this);} // tgen
ccc::CC0x10y6 ::CC0x10y6(){ note_ctor("_ZN3ccc8CC0x10y6E", this);} // tgen
}
static void Test__ZN3ccc8CC0x10y6E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x10y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x10y6E, buf);
    ::ccc::CC0x10y6 *dp, &lv = *(dp=new (buf) ::ccc::CC0x10y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x10y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x10y6E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x10y6E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc8CC0x10y6E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x10y6E);
    dp->::ccc::CC0x10y6::~CC0x10y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x10y6E(Test__ZN3ccc8CC0x10y6E, "_ZN3ccc8CC0x10y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x10y6C1Ev();
extern void _ZN3ccc8CC0x10y6D1Ev();
Name_Map name_map__ZN3ccc8CC0x10y6E[] = {
  NSPAIR(_ZN3ccc8CC0x10y6C1Ev),
  NSPAIR(_ZN3ccc8CC0x10y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc8CC0x10y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x10y6E[];
extern void _ZN3ccc8CC0x10y63abcEv();
extern void _ZN3ccc8CC0x10y63efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc4BB103pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x10y63abcEv,_ZThn4_N3ccc8CC0x10y63abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x10y6E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x10y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x10y63abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x10y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x10y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB103pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x10y63abcEv,_ZThn4_N3ccc8CC0x10y63abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x10y6E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x10y6E[];
Class_Descriptor cd__ZN3ccc8CC0x10y6E = {  "_ZN3ccc8CC0x10y6E", // class name
  bases__ZN3ccc8CC0x10y6E, 2,
  &(vtc__ZN3ccc8CC0x10y6E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x10y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x10y6E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x10y7  : ::ccc::AA0 , ::ccc::BB10 {
  virtual void  abc(); // _ZN3ccc8CC0x10y73abcEv
  virtual void  pqr(); // _ZN3ccc8CC0x10y73pqrEv
  ~CC0x10y7(); // tgen
  CC0x10y7(); // tgen
};
//SIG(1 _ZN3ccc8CC0x10y7E) C1{ BC2{ v1 v3 v2} BC3{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x10y7 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x10y73abcEv");}
void  ccc::CC0x10y7 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x10y73pqrEv");}
ccc::CC0x10y7 ::~CC0x10y7(){ note_dtor("_ZN3ccc8CC0x10y7E", this);} // tgen
ccc::CC0x10y7 ::CC0x10y7(){ note_ctor("_ZN3ccc8CC0x10y7E", this);} // tgen
}
static void Test__ZN3ccc8CC0x10y7E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x10y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x10y7E, buf);
    ::ccc::CC0x10y7 *dp, &lv = *(dp=new (buf) ::ccc::CC0x10y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x10y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x10y7E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x10y7E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc8CC0x10y7E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x10y7E);
    dp->::ccc::CC0x10y7::~CC0x10y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x10y7E(Test__ZN3ccc8CC0x10y7E, "_ZN3ccc8CC0x10y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x10y7C1Ev();
extern void _ZN3ccc8CC0x10y7D1Ev();
Name_Map name_map__ZN3ccc8CC0x10y7E[] = {
  NSPAIR(_ZN3ccc8CC0x10y7C1Ev),
  NSPAIR(_ZN3ccc8CC0x10y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc8CC0x10y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x10y7E[];
extern void _ZN3ccc8CC0x10y73abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc8CC0x10y73pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x10y73pqrEv,_ZThn4_N3ccc8CC0x10y73pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC0x10y73abcEv,_ZThn4_N3ccc8CC0x10y73abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x10y7E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x10y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x10y73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x10y73pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x10y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x10y73pqrEv,_ZThn4_N3ccc8CC0x10y73pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x10y73abcEv,_ZThn4_N3ccc8CC0x10y73abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x10y7E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x10y7E[];
Class_Descriptor cd__ZN3ccc8CC0x10y7E = {  "_ZN3ccc8CC0x10y7E", // class name
  bases__ZN3ccc8CC0x10y7E, 2,
  &(vtc__ZN3ccc8CC0x10y7E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x10y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x10y7E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x10y8  : ::ccc::AA0 , ::ccc::BB10 {
  virtual void  efg(); // _ZN3ccc8CC0x10y83efgEv
  virtual void  abc(); // _ZN3ccc8CC0x10y83abcEv
  ~CC0x10y8(); // tgen
  CC0x10y8(); // tgen
};
//SIG(1 _ZN3ccc8CC0x10y8E) C1{ BC2{ v2 v1 v3} BC3{ v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x10y8 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x10y83efgEv");}
void  ccc::CC0x10y8 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x10y83abcEv");}
ccc::CC0x10y8 ::~CC0x10y8(){ note_dtor("_ZN3ccc8CC0x10y8E", this);} // tgen
ccc::CC0x10y8 ::CC0x10y8(){ note_ctor("_ZN3ccc8CC0x10y8E", this);} // tgen
}
static void Test__ZN3ccc8CC0x10y8E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x10y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x10y8E, buf);
    ::ccc::CC0x10y8 *dp, &lv = *(dp=new (buf) ::ccc::CC0x10y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x10y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x10y8E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x10y8E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc8CC0x10y8E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x10y8E);
    dp->::ccc::CC0x10y8::~CC0x10y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x10y8E(Test__ZN3ccc8CC0x10y8E, "_ZN3ccc8CC0x10y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x10y8C1Ev();
extern void _ZN3ccc8CC0x10y8D1Ev();
Name_Map name_map__ZN3ccc8CC0x10y8E[] = {
  NSPAIR(_ZN3ccc8CC0x10y8C1Ev),
  NSPAIR(_ZN3ccc8CC0x10y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc8CC0x10y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x10y8E[];
extern void _ZN3ccc8CC0x10y83abcEv();
extern void _ZN3ccc8CC0x10y83efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc4BB103pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x10y83abcEv,_ZThn4_N3ccc8CC0x10y83abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x10y8E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x10y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x10y83abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x10y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x10y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB103pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x10y83abcEv,_ZThn4_N3ccc8CC0x10y83abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x10y8E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x10y8E[];
Class_Descriptor cd__ZN3ccc8CC0x10y8E = {  "_ZN3ccc8CC0x10y8E", // class name
  bases__ZN3ccc8CC0x10y8E, 2,
  &(vtc__ZN3ccc8CC0x10y8E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x10y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x10y8E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x10y9  : ::ccc::AA0 , ::ccc::BB10 {
  virtual void  efg(); // _ZN3ccc8CC0x10y93efgEv
  virtual void  pqr(); // _ZN3ccc8CC0x10y93pqrEv
  ~CC0x10y9(); // tgen
  CC0x10y9(); // tgen
};
//SIG(1 _ZN3ccc8CC0x10y9E) C1{ BC2{ v3 v1 v2} BC3{ v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x10y9 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x10y93efgEv");}
void  ccc::CC0x10y9 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x10y93pqrEv");}
ccc::CC0x10y9 ::~CC0x10y9(){ note_dtor("_ZN3ccc8CC0x10y9E", this);} // tgen
ccc::CC0x10y9 ::CC0x10y9(){ note_ctor("_ZN3ccc8CC0x10y9E", this);} // tgen
}
static void Test__ZN3ccc8CC0x10y9E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x10y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x10y9E, buf);
    ::ccc::CC0x10y9 *dp, &lv = *(dp=new (buf) ::ccc::CC0x10y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x10y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x10y9E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x10y9E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc8CC0x10y9E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x10y9E);
    dp->::ccc::CC0x10y9::~CC0x10y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x10y9E(Test__ZN3ccc8CC0x10y9E, "_ZN3ccc8CC0x10y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x10y9C1Ev();
extern void _ZN3ccc8CC0x10y9D1Ev();
Name_Map name_map__ZN3ccc8CC0x10y9E[] = {
  NSPAIR(_ZN3ccc8CC0x10y9C1Ev),
  NSPAIR(_ZN3ccc8CC0x10y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc8CC0x10y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x10y9E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc8CC0x10y93efgEv();
extern void _ZN3ccc8CC0x10y93pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x10y93pqrEv,_ZThn4_N3ccc8CC0x10y93pqrEv)();
extern void _ZN3ccc4BB103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x10y9E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x10y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x10y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x10y93pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x10y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x10y93pqrEv,_ZThn4_N3ccc8CC0x10y93pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4BB103abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x10y9E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x10y9E[];
Class_Descriptor cd__ZN3ccc8CC0x10y9E = {  "_ZN3ccc8CC0x10y9E", // class name
  bases__ZN3ccc8CC0x10y9E, 2,
  &(vtc__ZN3ccc8CC0x10y9E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x10y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x10y9E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x10y10  : ::ccc::AA0 , ::ccc::BB10 {
  virtual void  pqr(); // _ZN3ccc9CC0x10y103pqrEv
  virtual void  abc(); // _ZN3ccc9CC0x10y103abcEv
  ~CC0x10y10(); // tgen
  CC0x10y10(); // tgen
};
//SIG(1 _ZN3ccc9CC0x10y10E) C1{ BC2{ v2 v3 v1} BC3{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x10y10 ::pqr(){vfunc_called(this, "_ZN3ccc9CC0x10y103pqrEv");}
void  ccc::CC0x10y10 ::abc(){vfunc_called(this, "_ZN3ccc9CC0x10y103abcEv");}
ccc::CC0x10y10 ::~CC0x10y10(){ note_dtor("_ZN3ccc9CC0x10y10E", this);} // tgen
ccc::CC0x10y10 ::CC0x10y10(){ note_ctor("_ZN3ccc9CC0x10y10E", this);} // tgen
}
static void Test__ZN3ccc9CC0x10y10E()
{
  extern Class_Descriptor cd__ZN3ccc9CC0x10y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC0x10y10E, buf);
    ::ccc::CC0x10y10 *dp, &lv = *(dp=new (buf) ::ccc::CC0x10y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC0x10y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC0x10y10E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc9CC0x10y10E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc9CC0x10y10E");
    test_class_info(&lv, &cd__ZN3ccc9CC0x10y10E);
    dp->::ccc::CC0x10y10::~CC0x10y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC0x10y10E(Test__ZN3ccc9CC0x10y10E, "_ZN3ccc9CC0x10y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC0x10y10C1Ev();
extern void _ZN3ccc9CC0x10y10D1Ev();
Name_Map name_map__ZN3ccc9CC0x10y10E[] = {
  NSPAIR(_ZN3ccc9CC0x10y10C1Ev),
  NSPAIR(_ZN3ccc9CC0x10y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc9CC0x10y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC0x10y10E[];
extern void _ZN3ccc9CC0x10y103abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc9CC0x10y103pqrEv();
extern void ABISELECT(_ZThn8_N3ccc9CC0x10y103pqrEv,_ZThn4_N3ccc9CC0x10y103pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC0x10y103abcEv,_ZThn4_N3ccc9CC0x10y103abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc9CC0x10y10E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x10y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC0x10y103abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC0x10y103pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x10y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc9CC0x10y103pqrEv,_ZThn4_N3ccc9CC0x10y103pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc9CC0x10y103abcEv,_ZThn4_N3ccc9CC0x10y103abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc9CC0x10y10E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC0x10y10E[];
Class_Descriptor cd__ZN3ccc9CC0x10y10E = {  "_ZN3ccc9CC0x10y10E", // class name
  bases__ZN3ccc9CC0x10y10E, 2,
  &(vtc__ZN3ccc9CC0x10y10E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC0x10y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC0x10y10E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x10y11  : ::ccc::AA0 , ::ccc::BB10 {
  virtual void  pqr(); // _ZN3ccc9CC0x10y113pqrEv
  virtual void  efg(); // _ZN3ccc9CC0x10y113efgEv
  ~CC0x10y11(); // tgen
  CC0x10y11(); // tgen
};
//SIG(1 _ZN3ccc9CC0x10y11E) C1{ BC2{ v3 v2 v1} BC3{ v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x10y11 ::pqr(){vfunc_called(this, "_ZN3ccc9CC0x10y113pqrEv");}
void  ccc::CC0x10y11 ::efg(){vfunc_called(this, "_ZN3ccc9CC0x10y113efgEv");}
ccc::CC0x10y11 ::~CC0x10y11(){ note_dtor("_ZN3ccc9CC0x10y11E", this);} // tgen
ccc::CC0x10y11 ::CC0x10y11(){ note_ctor("_ZN3ccc9CC0x10y11E", this);} // tgen
}
static void Test__ZN3ccc9CC0x10y11E()
{
  extern Class_Descriptor cd__ZN3ccc9CC0x10y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC0x10y11E, buf);
    ::ccc::CC0x10y11 *dp, &lv = *(dp=new (buf) ::ccc::CC0x10y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC0x10y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC0x10y11E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc9CC0x10y11E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc9CC0x10y11E");
    test_class_info(&lv, &cd__ZN3ccc9CC0x10y11E);
    dp->::ccc::CC0x10y11::~CC0x10y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC0x10y11E(Test__ZN3ccc9CC0x10y11E, "_ZN3ccc9CC0x10y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC0x10y11C1Ev();
extern void _ZN3ccc9CC0x10y11D1Ev();
Name_Map name_map__ZN3ccc9CC0x10y11E[] = {
  NSPAIR(_ZN3ccc9CC0x10y11C1Ev),
  NSPAIR(_ZN3ccc9CC0x10y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc9CC0x10y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC0x10y11E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc9CC0x10y113efgEv();
extern void _ZN3ccc9CC0x10y113pqrEv();
extern void ABISELECT(_ZThn8_N3ccc9CC0x10y113pqrEv,_ZThn4_N3ccc9CC0x10y113pqrEv)();
extern void _ZN3ccc4BB103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC0x10y11E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x10y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC0x10y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC0x10y113pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x10y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc9CC0x10y113pqrEv,_ZThn4_N3ccc9CC0x10y113pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4BB103abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc9CC0x10y11E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC0x10y11E[];
Class_Descriptor cd__ZN3ccc9CC0x10y11E = {  "_ZN3ccc9CC0x10y11E", // class name
  bases__ZN3ccc9CC0x10y11E, 2,
  &(vtc__ZN3ccc9CC0x10y11E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC0x10y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC0x10y11E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x10y12  : ::ccc::AA0 , ::ccc::BB10 {
  virtual void  abc(); // _ZN3ccc9CC0x10y123abcEv
  ~CC0x10y12(); // tgen
  CC0x10y12(); // tgen
};
//SIG(1 _ZN3ccc9CC0x10y12E) C1{ BC2{ v1 v2 v3} BC3{ v4 v1} v1}
}
namespace ccc { 
void  ccc::CC0x10y12 ::abc(){vfunc_called(this, "_ZN3ccc9CC0x10y123abcEv");}
ccc::CC0x10y12 ::~CC0x10y12(){ note_dtor("_ZN3ccc9CC0x10y12E", this);} // tgen
ccc::CC0x10y12 ::CC0x10y12(){ note_ctor("_ZN3ccc9CC0x10y12E", this);} // tgen
}
static void Test__ZN3ccc9CC0x10y12E()
{
  extern Class_Descriptor cd__ZN3ccc9CC0x10y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC0x10y12E, buf);
    ::ccc::CC0x10y12 *dp, &lv = *(dp=new (buf) ::ccc::CC0x10y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC0x10y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC0x10y12E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc9CC0x10y12E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc9CC0x10y12E");
    test_class_info(&lv, &cd__ZN3ccc9CC0x10y12E);
    dp->::ccc::CC0x10y12::~CC0x10y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC0x10y12E(Test__ZN3ccc9CC0x10y12E, "_ZN3ccc9CC0x10y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC0x10y12C1Ev();
extern void _ZN3ccc9CC0x10y12D1Ev();
Name_Map name_map__ZN3ccc9CC0x10y12E[] = {
  NSPAIR(_ZN3ccc9CC0x10y12C1Ev),
  NSPAIR(_ZN3ccc9CC0x10y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc9CC0x10y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC0x10y12E[];
extern void _ZN3ccc9CC0x10y123abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc4BB103pqrEv();
extern void ABISELECT(_ZThn8_N3ccc9CC0x10y123abcEv,_ZThn4_N3ccc9CC0x10y123abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc9CC0x10y12E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x10y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC0x10y123abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x10y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB103pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc9CC0x10y123abcEv,_ZThn4_N3ccc9CC0x10y123abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc9CC0x10y12E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC0x10y12E[];
Class_Descriptor cd__ZN3ccc9CC0x10y12E = {  "_ZN3ccc9CC0x10y12E", // class name
  bases__ZN3ccc9CC0x10y12E, 2,
  &(vtc__ZN3ccc9CC0x10y12E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC0x10y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC0x10y12E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x10y13  : ::ccc::AA0 , ::ccc::BB10 {
  virtual void  efg(); // _ZN3ccc9CC0x10y133efgEv
  ~CC0x10y13(); // tgen
  CC0x10y13(); // tgen
};
//SIG(1 _ZN3ccc9CC0x10y13E) C1{ BC2{ v2 v1 v3} BC3{ v4 v5} v1}
}
namespace ccc { 
void  ccc::CC0x10y13 ::efg(){vfunc_called(this, "_ZN3ccc9CC0x10y133efgEv");}
ccc::CC0x10y13 ::~CC0x10y13(){ note_dtor("_ZN3ccc9CC0x10y13E", this);} // tgen
ccc::CC0x10y13 ::CC0x10y13(){ note_ctor("_ZN3ccc9CC0x10y13E", this);} // tgen
}
static void Test__ZN3ccc9CC0x10y13E()
{
  extern Class_Descriptor cd__ZN3ccc9CC0x10y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC0x10y13E, buf);
    ::ccc::CC0x10y13 *dp, &lv = *(dp=new (buf) ::ccc::CC0x10y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC0x10y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC0x10y13E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc9CC0x10y13E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc9CC0x10y13E");
    test_class_info(&lv, &cd__ZN3ccc9CC0x10y13E);
    dp->::ccc::CC0x10y13::~CC0x10y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC0x10y13E(Test__ZN3ccc9CC0x10y13E, "_ZN3ccc9CC0x10y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC0x10y13C1Ev();
extern void _ZN3ccc9CC0x10y13D1Ev();
Name_Map name_map__ZN3ccc9CC0x10y13E[] = {
  NSPAIR(_ZN3ccc9CC0x10y13C1Ev),
  NSPAIR(_ZN3ccc9CC0x10y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc9CC0x10y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC0x10y13E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc9CC0x10y133efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc4BB103pqrEv();
extern void _ZN3ccc4BB103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC0x10y13E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x10y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC0x10y133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x10y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4BB103abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc9CC0x10y13E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC0x10y13E[];
Class_Descriptor cd__ZN3ccc9CC0x10y13E = {  "_ZN3ccc9CC0x10y13E", // class name
  bases__ZN3ccc9CC0x10y13E, 2,
  &(vtc__ZN3ccc9CC0x10y13E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC0x10y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC0x10y13E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x10y14  : ::ccc::AA0 , ::ccc::BB10 {
  virtual void  pqr(); // _ZN3ccc9CC0x10y143pqrEv
  ~CC0x10y14(); // tgen
  CC0x10y14(); // tgen
};
//SIG(1 _ZN3ccc9CC0x10y14E) C1{ BC2{ v2 v3 v1} BC3{ v1 v4} v1}
}
namespace ccc { 
void  ccc::CC0x10y14 ::pqr(){vfunc_called(this, "_ZN3ccc9CC0x10y143pqrEv");}
ccc::CC0x10y14 ::~CC0x10y14(){ note_dtor("_ZN3ccc9CC0x10y14E", this);} // tgen
ccc::CC0x10y14 ::CC0x10y14(){ note_ctor("_ZN3ccc9CC0x10y14E", this);} // tgen
}
static void Test__ZN3ccc9CC0x10y14E()
{
  extern Class_Descriptor cd__ZN3ccc9CC0x10y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC0x10y14E, buf);
    ::ccc::CC0x10y14 *dp, &lv = *(dp=new (buf) ::ccc::CC0x10y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC0x10y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC0x10y14E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc9CC0x10y14E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc9CC0x10y14E");
    test_class_info(&lv, &cd__ZN3ccc9CC0x10y14E);
    dp->::ccc::CC0x10y14::~CC0x10y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC0x10y14E(Test__ZN3ccc9CC0x10y14E, "_ZN3ccc9CC0x10y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC0x10y14C1Ev();
extern void _ZN3ccc9CC0x10y14D1Ev();
Name_Map name_map__ZN3ccc9CC0x10y14E[] = {
  NSPAIR(_ZN3ccc9CC0x10y14C1Ev),
  NSPAIR(_ZN3ccc9CC0x10y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc9CC0x10y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC0x10y14E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc9CC0x10y143pqrEv();
extern void ABISELECT(_ZThn8_N3ccc9CC0x10y143pqrEv,_ZThn4_N3ccc9CC0x10y143pqrEv)();
extern void _ZN3ccc4BB103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC0x10y14E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x10y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC0x10y143pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x10y14E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc9CC0x10y143pqrEv,_ZThn4_N3ccc9CC0x10y143pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4BB103abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc9CC0x10y14E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC0x10y14E[];
Class_Descriptor cd__ZN3ccc9CC0x10y14E = {  "_ZN3ccc9CC0x10y14E", // class name
  bases__ZN3ccc9CC0x10y14E, 2,
  &(vtc__ZN3ccc9CC0x10y14E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC0x10y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC0x10y14E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x10y15  : ::ccc::AA0 , ::ccc::BB10 {
  ~CC0x10y15(); // tgen
  CC0x10y15(); // tgen
};
//SIG(1 _ZN3ccc9CC0x10y15E) C1{ BC2{ v1 v2 v3} BC3{ v4 v5}}
}
namespace ccc { 
ccc::CC0x10y15 ::~CC0x10y15(){ note_dtor("_ZN3ccc9CC0x10y15E", this);} // tgen
ccc::CC0x10y15 ::CC0x10y15(){ note_ctor("_ZN3ccc9CC0x10y15E", this);} // tgen
}
static void Test__ZN3ccc9CC0x10y15E()
{
  extern Class_Descriptor cd__ZN3ccc9CC0x10y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC0x10y15E, buf);
    ::ccc::CC0x10y15 *dp, &lv = *(dp=new (buf) ::ccc::CC0x10y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC0x10y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC0x10y15E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc9CC0x10y15E");
    check_base_class_offset(lv, (::ccc::BB10*), ABISELECT(8,4), "_ZN3ccc9CC0x10y15E");
    test_class_info(&lv, &cd__ZN3ccc9CC0x10y15E);
    dp->::ccc::CC0x10y15::~CC0x10y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC0x10y15E(Test__ZN3ccc9CC0x10y15E, "_ZN3ccc9CC0x10y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC0x10y15C1Ev();
extern void _ZN3ccc9CC0x10y15D1Ev();
Name_Map name_map__ZN3ccc9CC0x10y15E[] = {
  NSPAIR(_ZN3ccc9CC0x10y15C1Ev),
  NSPAIR(_ZN3ccc9CC0x10y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB10E;
extern VTBL_ENTRY _ZTIN3ccc4BB10E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB10E[];
static Base_Class bases__ZN3ccc9CC0x10y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB10E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC0x10y15E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc4BB103pqrEv();
extern void _ZN3ccc4BB103abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC0x10y15E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x10y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x10y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB103pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4BB103abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc9CC0x10y15E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC0x10y15E[];
Class_Descriptor cd__ZN3ccc9CC0x10y15E = {  "_ZN3ccc9CC0x10y15E", // class name
  bases__ZN3ccc9CC0x10y15E, 2,
  &(vtc__ZN3ccc9CC0x10y15E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC0x10y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC0x10y15E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x11y0  : ::ccc::AA0 , ::ccc::BB11 {
  virtual void  abc(); // _ZN3ccc8CC0x11y03abcEv
  virtual void  efg(); // _ZN3ccc8CC0x11y03efgEv
  virtual void  pqr(); // _ZN3ccc8CC0x11y03pqrEv
  ~CC0x11y0(); // tgen
  CC0x11y0(); // tgen
};
//SIG(1 _ZN3ccc8CC0x11y0E) C1{ BC2{ v1 v2 v3} BC3{ v3 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x11y0 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x11y03abcEv");}
void  ccc::CC0x11y0 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x11y03efgEv");}
void  ccc::CC0x11y0 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x11y03pqrEv");}
ccc::CC0x11y0 ::~CC0x11y0(){ note_dtor("_ZN3ccc8CC0x11y0E", this);} // tgen
ccc::CC0x11y0 ::CC0x11y0(){ note_ctor("_ZN3ccc8CC0x11y0E", this);} // tgen
}
static void Test__ZN3ccc8CC0x11y0E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x11y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x11y0E, buf);
    ::ccc::CC0x11y0 *dp, &lv = *(dp=new (buf) ::ccc::CC0x11y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x11y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x11y0E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x11y0E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc8CC0x11y0E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x11y0E);
    dp->::ccc::CC0x11y0::~CC0x11y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x11y0E(Test__ZN3ccc8CC0x11y0E, "_ZN3ccc8CC0x11y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x11y0C1Ev();
extern void _ZN3ccc8CC0x11y0D1Ev();
Name_Map name_map__ZN3ccc8CC0x11y0E[] = {
  NSPAIR(_ZN3ccc8CC0x11y0C1Ev),
  NSPAIR(_ZN3ccc8CC0x11y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc8CC0x11y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x11y0E[];
extern void _ZN3ccc8CC0x11y03abcEv();
extern void _ZN3ccc8CC0x11y03efgEv();
extern void _ZN3ccc8CC0x11y03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x11y03pqrEv,_ZThn4_N3ccc8CC0x11y03pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC0x11y03efgEv,_ZThn4_N3ccc8CC0x11y03efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x11y0E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x11y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x11y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x11y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x11y03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x11y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x11y03pqrEv,_ZThn4_N3ccc8CC0x11y03pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x11y03efgEv,_ZThn4_N3ccc8CC0x11y03efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x11y0E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x11y0E[];
Class_Descriptor cd__ZN3ccc8CC0x11y0E = {  "_ZN3ccc8CC0x11y0E", // class name
  bases__ZN3ccc8CC0x11y0E, 2,
  &(vtc__ZN3ccc8CC0x11y0E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x11y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x11y0E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x11y1  : ::ccc::AA0 , ::ccc::BB11 {
  virtual void  abc(); // _ZN3ccc8CC0x11y13abcEv
  virtual void  pqr(); // _ZN3ccc8CC0x11y13pqrEv
  virtual void  efg(); // _ZN3ccc8CC0x11y13efgEv
  ~CC0x11y1(); // tgen
  CC0x11y1(); // tgen
};
//SIG(1 _ZN3ccc8CC0x11y1E) C1{ BC2{ v1 v3 v2} BC3{ v2 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x11y1 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x11y13abcEv");}
void  ccc::CC0x11y1 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x11y13pqrEv");}
void  ccc::CC0x11y1 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x11y13efgEv");}
ccc::CC0x11y1 ::~CC0x11y1(){ note_dtor("_ZN3ccc8CC0x11y1E", this);} // tgen
ccc::CC0x11y1 ::CC0x11y1(){ note_ctor("_ZN3ccc8CC0x11y1E", this);} // tgen
}
static void Test__ZN3ccc8CC0x11y1E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x11y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x11y1E, buf);
    ::ccc::CC0x11y1 *dp, &lv = *(dp=new (buf) ::ccc::CC0x11y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x11y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x11y1E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x11y1E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc8CC0x11y1E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x11y1E);
    dp->::ccc::CC0x11y1::~CC0x11y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x11y1E(Test__ZN3ccc8CC0x11y1E, "_ZN3ccc8CC0x11y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x11y1C1Ev();
extern void _ZN3ccc8CC0x11y1D1Ev();
Name_Map name_map__ZN3ccc8CC0x11y1E[] = {
  NSPAIR(_ZN3ccc8CC0x11y1C1Ev),
  NSPAIR(_ZN3ccc8CC0x11y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc8CC0x11y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x11y1E[];
extern void _ZN3ccc8CC0x11y13abcEv();
extern void _ZN3ccc8CC0x11y13efgEv();
extern void _ZN3ccc8CC0x11y13pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x11y13pqrEv,_ZThn4_N3ccc8CC0x11y13pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC0x11y13efgEv,_ZThn4_N3ccc8CC0x11y13efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x11y1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x11y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x11y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x11y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x11y13pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x11y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x11y13pqrEv,_ZThn4_N3ccc8CC0x11y13pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x11y13efgEv,_ZThn4_N3ccc8CC0x11y13efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x11y1E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x11y1E[];
Class_Descriptor cd__ZN3ccc8CC0x11y1E = {  "_ZN3ccc8CC0x11y1E", // class name
  bases__ZN3ccc8CC0x11y1E, 2,
  &(vtc__ZN3ccc8CC0x11y1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x11y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x11y1E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x11y2  : ::ccc::AA0 , ::ccc::BB11 {
  virtual void  efg(); // _ZN3ccc8CC0x11y23efgEv
  virtual void  abc(); // _ZN3ccc8CC0x11y23abcEv
  virtual void  pqr(); // _ZN3ccc8CC0x11y23pqrEv
  ~CC0x11y2(); // tgen
  CC0x11y2(); // tgen
};
//SIG(1 _ZN3ccc8CC0x11y2E) C1{ BC2{ v2 v1 v3} BC3{ v3 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x11y2 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x11y23efgEv");}
void  ccc::CC0x11y2 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x11y23abcEv");}
void  ccc::CC0x11y2 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x11y23pqrEv");}
ccc::CC0x11y2 ::~CC0x11y2(){ note_dtor("_ZN3ccc8CC0x11y2E", this);} // tgen
ccc::CC0x11y2 ::CC0x11y2(){ note_ctor("_ZN3ccc8CC0x11y2E", this);} // tgen
}
static void Test__ZN3ccc8CC0x11y2E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x11y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x11y2E, buf);
    ::ccc::CC0x11y2 *dp, &lv = *(dp=new (buf) ::ccc::CC0x11y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x11y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x11y2E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x11y2E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc8CC0x11y2E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x11y2E);
    dp->::ccc::CC0x11y2::~CC0x11y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x11y2E(Test__ZN3ccc8CC0x11y2E, "_ZN3ccc8CC0x11y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x11y2C1Ev();
extern void _ZN3ccc8CC0x11y2D1Ev();
Name_Map name_map__ZN3ccc8CC0x11y2E[] = {
  NSPAIR(_ZN3ccc8CC0x11y2C1Ev),
  NSPAIR(_ZN3ccc8CC0x11y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc8CC0x11y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x11y2E[];
extern void _ZN3ccc8CC0x11y23abcEv();
extern void _ZN3ccc8CC0x11y23efgEv();
extern void _ZN3ccc8CC0x11y23pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x11y23pqrEv,_ZThn4_N3ccc8CC0x11y23pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC0x11y23efgEv,_ZThn4_N3ccc8CC0x11y23efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x11y2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x11y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x11y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x11y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x11y23pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x11y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x11y23pqrEv,_ZThn4_N3ccc8CC0x11y23pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x11y23efgEv,_ZThn4_N3ccc8CC0x11y23efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x11y2E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x11y2E[];
Class_Descriptor cd__ZN3ccc8CC0x11y2E = {  "_ZN3ccc8CC0x11y2E", // class name
  bases__ZN3ccc8CC0x11y2E, 2,
  &(vtc__ZN3ccc8CC0x11y2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x11y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x11y2E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x11y3  : ::ccc::AA0 , ::ccc::BB11 {
  virtual void  efg(); // _ZN3ccc8CC0x11y33efgEv
  virtual void  pqr(); // _ZN3ccc8CC0x11y33pqrEv
  virtual void  abc(); // _ZN3ccc8CC0x11y33abcEv
  ~CC0x11y3(); // tgen
  CC0x11y3(); // tgen
};
//SIG(1 _ZN3ccc8CC0x11y3E) C1{ BC2{ v3 v1 v2} BC3{ v2 v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x11y3 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x11y33efgEv");}
void  ccc::CC0x11y3 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x11y33pqrEv");}
void  ccc::CC0x11y3 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x11y33abcEv");}
ccc::CC0x11y3 ::~CC0x11y3(){ note_dtor("_ZN3ccc8CC0x11y3E", this);} // tgen
ccc::CC0x11y3 ::CC0x11y3(){ note_ctor("_ZN3ccc8CC0x11y3E", this);} // tgen
}
static void Test__ZN3ccc8CC0x11y3E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x11y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x11y3E, buf);
    ::ccc::CC0x11y3 *dp, &lv = *(dp=new (buf) ::ccc::CC0x11y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x11y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x11y3E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x11y3E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc8CC0x11y3E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x11y3E);
    dp->::ccc::CC0x11y3::~CC0x11y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x11y3E(Test__ZN3ccc8CC0x11y3E, "_ZN3ccc8CC0x11y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x11y3C1Ev();
extern void _ZN3ccc8CC0x11y3D1Ev();
Name_Map name_map__ZN3ccc8CC0x11y3E[] = {
  NSPAIR(_ZN3ccc8CC0x11y3C1Ev),
  NSPAIR(_ZN3ccc8CC0x11y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc8CC0x11y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x11y3E[];
extern void _ZN3ccc8CC0x11y33abcEv();
extern void _ZN3ccc8CC0x11y33efgEv();
extern void _ZN3ccc8CC0x11y33pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x11y33pqrEv,_ZThn4_N3ccc8CC0x11y33pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC0x11y33efgEv,_ZThn4_N3ccc8CC0x11y33efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x11y3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x11y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x11y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x11y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x11y33pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x11y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x11y33pqrEv,_ZThn4_N3ccc8CC0x11y33pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x11y33efgEv,_ZThn4_N3ccc8CC0x11y33efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x11y3E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x11y3E[];
Class_Descriptor cd__ZN3ccc8CC0x11y3E = {  "_ZN3ccc8CC0x11y3E", // class name
  bases__ZN3ccc8CC0x11y3E, 2,
  &(vtc__ZN3ccc8CC0x11y3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x11y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x11y3E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x11y4  : ::ccc::AA0 , ::ccc::BB11 {
  virtual void  pqr(); // _ZN3ccc8CC0x11y43pqrEv
  virtual void  abc(); // _ZN3ccc8CC0x11y43abcEv
  virtual void  efg(); // _ZN3ccc8CC0x11y43efgEv
  ~CC0x11y4(); // tgen
  CC0x11y4(); // tgen
};
//SIG(1 _ZN3ccc8CC0x11y4E) C1{ BC2{ v2 v3 v1} BC3{ v1 v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x11y4 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x11y43pqrEv");}
void  ccc::CC0x11y4 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x11y43abcEv");}
void  ccc::CC0x11y4 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x11y43efgEv");}
ccc::CC0x11y4 ::~CC0x11y4(){ note_dtor("_ZN3ccc8CC0x11y4E", this);} // tgen
ccc::CC0x11y4 ::CC0x11y4(){ note_ctor("_ZN3ccc8CC0x11y4E", this);} // tgen
}
static void Test__ZN3ccc8CC0x11y4E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x11y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x11y4E, buf);
    ::ccc::CC0x11y4 *dp, &lv = *(dp=new (buf) ::ccc::CC0x11y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x11y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x11y4E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x11y4E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc8CC0x11y4E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x11y4E);
    dp->::ccc::CC0x11y4::~CC0x11y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x11y4E(Test__ZN3ccc8CC0x11y4E, "_ZN3ccc8CC0x11y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x11y4C1Ev();
extern void _ZN3ccc8CC0x11y4D1Ev();
Name_Map name_map__ZN3ccc8CC0x11y4E[] = {
  NSPAIR(_ZN3ccc8CC0x11y4C1Ev),
  NSPAIR(_ZN3ccc8CC0x11y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc8CC0x11y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x11y4E[];
extern void _ZN3ccc8CC0x11y43abcEv();
extern void _ZN3ccc8CC0x11y43efgEv();
extern void _ZN3ccc8CC0x11y43pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x11y43pqrEv,_ZThn4_N3ccc8CC0x11y43pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC0x11y43efgEv,_ZThn4_N3ccc8CC0x11y43efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x11y4E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x11y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x11y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x11y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x11y43pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x11y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x11y43pqrEv,_ZThn4_N3ccc8CC0x11y43pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x11y43efgEv,_ZThn4_N3ccc8CC0x11y43efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x11y4E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x11y4E[];
Class_Descriptor cd__ZN3ccc8CC0x11y4E = {  "_ZN3ccc8CC0x11y4E", // class name
  bases__ZN3ccc8CC0x11y4E, 2,
  &(vtc__ZN3ccc8CC0x11y4E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x11y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x11y4E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x11y5  : ::ccc::AA0 , ::ccc::BB11 {
  virtual void  pqr(); // _ZN3ccc8CC0x11y53pqrEv
  virtual void  efg(); // _ZN3ccc8CC0x11y53efgEv
  virtual void  abc(); // _ZN3ccc8CC0x11y53abcEv
  ~CC0x11y5(); // tgen
  CC0x11y5(); // tgen
};
//SIG(1 _ZN3ccc8CC0x11y5E) C1{ BC2{ v3 v2 v1} BC3{ v1 v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x11y5 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x11y53pqrEv");}
void  ccc::CC0x11y5 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x11y53efgEv");}
void  ccc::CC0x11y5 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x11y53abcEv");}
ccc::CC0x11y5 ::~CC0x11y5(){ note_dtor("_ZN3ccc8CC0x11y5E", this);} // tgen
ccc::CC0x11y5 ::CC0x11y5(){ note_ctor("_ZN3ccc8CC0x11y5E", this);} // tgen
}
static void Test__ZN3ccc8CC0x11y5E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x11y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x11y5E, buf);
    ::ccc::CC0x11y5 *dp, &lv = *(dp=new (buf) ::ccc::CC0x11y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x11y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x11y5E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x11y5E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc8CC0x11y5E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x11y5E);
    dp->::ccc::CC0x11y5::~CC0x11y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x11y5E(Test__ZN3ccc8CC0x11y5E, "_ZN3ccc8CC0x11y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x11y5C1Ev();
extern void _ZN3ccc8CC0x11y5D1Ev();
Name_Map name_map__ZN3ccc8CC0x11y5E[] = {
  NSPAIR(_ZN3ccc8CC0x11y5C1Ev),
  NSPAIR(_ZN3ccc8CC0x11y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc8CC0x11y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x11y5E[];
extern void _ZN3ccc8CC0x11y53abcEv();
extern void _ZN3ccc8CC0x11y53efgEv();
extern void _ZN3ccc8CC0x11y53pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x11y53pqrEv,_ZThn4_N3ccc8CC0x11y53pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC0x11y53efgEv,_ZThn4_N3ccc8CC0x11y53efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x11y5E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x11y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x11y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x11y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x11y53pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x11y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x11y53pqrEv,_ZThn4_N3ccc8CC0x11y53pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x11y53efgEv,_ZThn4_N3ccc8CC0x11y53efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x11y5E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x11y5E[];
Class_Descriptor cd__ZN3ccc8CC0x11y5E = {  "_ZN3ccc8CC0x11y5E", // class name
  bases__ZN3ccc8CC0x11y5E, 2,
  &(vtc__ZN3ccc8CC0x11y5E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x11y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x11y5E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x11y6  : ::ccc::AA0 , ::ccc::BB11 {
  virtual void  abc(); // _ZN3ccc8CC0x11y63abcEv
  virtual void  efg(); // _ZN3ccc8CC0x11y63efgEv
  ~CC0x11y6(); // tgen
  CC0x11y6(); // tgen
};
//SIG(1 _ZN3ccc8CC0x11y6E) C1{ BC2{ v1 v2 v3} BC3{ v4 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x11y6 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x11y63abcEv");}
void  ccc::CC0x11y6 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x11y63efgEv");}
ccc::CC0x11y6 ::~CC0x11y6(){ note_dtor("_ZN3ccc8CC0x11y6E", this);} // tgen
ccc::CC0x11y6 ::CC0x11y6(){ note_ctor("_ZN3ccc8CC0x11y6E", this);} // tgen
}
static void Test__ZN3ccc8CC0x11y6E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x11y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x11y6E, buf);
    ::ccc::CC0x11y6 *dp, &lv = *(dp=new (buf) ::ccc::CC0x11y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x11y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x11y6E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x11y6E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc8CC0x11y6E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x11y6E);
    dp->::ccc::CC0x11y6::~CC0x11y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x11y6E(Test__ZN3ccc8CC0x11y6E, "_ZN3ccc8CC0x11y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x11y6C1Ev();
extern void _ZN3ccc8CC0x11y6D1Ev();
Name_Map name_map__ZN3ccc8CC0x11y6E[] = {
  NSPAIR(_ZN3ccc8CC0x11y6C1Ev),
  NSPAIR(_ZN3ccc8CC0x11y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc8CC0x11y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x11y6E[];
extern void _ZN3ccc8CC0x11y63abcEv();
extern void _ZN3ccc8CC0x11y63efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc4BB113pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x11y63efgEv,_ZThn4_N3ccc8CC0x11y63efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x11y6E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x11y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x11y63abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x11y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x11y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB113pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x11y63efgEv,_ZThn4_N3ccc8CC0x11y63efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x11y6E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x11y6E[];
Class_Descriptor cd__ZN3ccc8CC0x11y6E = {  "_ZN3ccc8CC0x11y6E", // class name
  bases__ZN3ccc8CC0x11y6E, 2,
  &(vtc__ZN3ccc8CC0x11y6E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x11y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x11y6E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x11y7  : ::ccc::AA0 , ::ccc::BB11 {
  virtual void  abc(); // _ZN3ccc8CC0x11y73abcEv
  virtual void  pqr(); // _ZN3ccc8CC0x11y73pqrEv
  ~CC0x11y7(); // tgen
  CC0x11y7(); // tgen
};
//SIG(1 _ZN3ccc8CC0x11y7E) C1{ BC2{ v1 v3 v2} BC3{ v2 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x11y7 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x11y73abcEv");}
void  ccc::CC0x11y7 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x11y73pqrEv");}
ccc::CC0x11y7 ::~CC0x11y7(){ note_dtor("_ZN3ccc8CC0x11y7E", this);} // tgen
ccc::CC0x11y7 ::CC0x11y7(){ note_ctor("_ZN3ccc8CC0x11y7E", this);} // tgen
}
static void Test__ZN3ccc8CC0x11y7E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x11y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x11y7E, buf);
    ::ccc::CC0x11y7 *dp, &lv = *(dp=new (buf) ::ccc::CC0x11y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x11y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x11y7E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x11y7E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc8CC0x11y7E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x11y7E);
    dp->::ccc::CC0x11y7::~CC0x11y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x11y7E(Test__ZN3ccc8CC0x11y7E, "_ZN3ccc8CC0x11y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x11y7C1Ev();
extern void _ZN3ccc8CC0x11y7D1Ev();
Name_Map name_map__ZN3ccc8CC0x11y7E[] = {
  NSPAIR(_ZN3ccc8CC0x11y7C1Ev),
  NSPAIR(_ZN3ccc8CC0x11y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc8CC0x11y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x11y7E[];
extern void _ZN3ccc8CC0x11y73abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc8CC0x11y73pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x11y73pqrEv,_ZThn4_N3ccc8CC0x11y73pqrEv)();
extern void _ZN3ccc4BB113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x11y7E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x11y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x11y73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x11y73pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x11y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x11y73pqrEv,_ZThn4_N3ccc8CC0x11y73pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4BB113efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x11y7E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x11y7E[];
Class_Descriptor cd__ZN3ccc8CC0x11y7E = {  "_ZN3ccc8CC0x11y7E", // class name
  bases__ZN3ccc8CC0x11y7E, 2,
  &(vtc__ZN3ccc8CC0x11y7E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x11y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x11y7E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x11y8  : ::ccc::AA0 , ::ccc::BB11 {
  virtual void  efg(); // _ZN3ccc8CC0x11y83efgEv
  virtual void  abc(); // _ZN3ccc8CC0x11y83abcEv
  ~CC0x11y8(); // tgen
  CC0x11y8(); // tgen
};
//SIG(1 _ZN3ccc8CC0x11y8E) C1{ BC2{ v2 v1 v3} BC3{ v4 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x11y8 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x11y83efgEv");}
void  ccc::CC0x11y8 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x11y83abcEv");}
ccc::CC0x11y8 ::~CC0x11y8(){ note_dtor("_ZN3ccc8CC0x11y8E", this);} // tgen
ccc::CC0x11y8 ::CC0x11y8(){ note_ctor("_ZN3ccc8CC0x11y8E", this);} // tgen
}
static void Test__ZN3ccc8CC0x11y8E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x11y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x11y8E, buf);
    ::ccc::CC0x11y8 *dp, &lv = *(dp=new (buf) ::ccc::CC0x11y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x11y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x11y8E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x11y8E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc8CC0x11y8E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x11y8E);
    dp->::ccc::CC0x11y8::~CC0x11y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x11y8E(Test__ZN3ccc8CC0x11y8E, "_ZN3ccc8CC0x11y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x11y8C1Ev();
extern void _ZN3ccc8CC0x11y8D1Ev();
Name_Map name_map__ZN3ccc8CC0x11y8E[] = {
  NSPAIR(_ZN3ccc8CC0x11y8C1Ev),
  NSPAIR(_ZN3ccc8CC0x11y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc8CC0x11y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x11y8E[];
extern void _ZN3ccc8CC0x11y83abcEv();
extern void _ZN3ccc8CC0x11y83efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc4BB113pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x11y83efgEv,_ZThn4_N3ccc8CC0x11y83efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x11y8E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x11y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x11y83abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x11y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x11y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB113pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x11y83efgEv,_ZThn4_N3ccc8CC0x11y83efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x11y8E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x11y8E[];
Class_Descriptor cd__ZN3ccc8CC0x11y8E = {  "_ZN3ccc8CC0x11y8E", // class name
  bases__ZN3ccc8CC0x11y8E, 2,
  &(vtc__ZN3ccc8CC0x11y8E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x11y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x11y8E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x11y9  : ::ccc::AA0 , ::ccc::BB11 {
  virtual void  efg(); // _ZN3ccc8CC0x11y93efgEv
  virtual void  pqr(); // _ZN3ccc8CC0x11y93pqrEv
  ~CC0x11y9(); // tgen
  CC0x11y9(); // tgen
};
//SIG(1 _ZN3ccc8CC0x11y9E) C1{ BC2{ v3 v1 v2} BC3{ v2 v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x11y9 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x11y93efgEv");}
void  ccc::CC0x11y9 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x11y93pqrEv");}
ccc::CC0x11y9 ::~CC0x11y9(){ note_dtor("_ZN3ccc8CC0x11y9E", this);} // tgen
ccc::CC0x11y9 ::CC0x11y9(){ note_ctor("_ZN3ccc8CC0x11y9E", this);} // tgen
}
static void Test__ZN3ccc8CC0x11y9E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x11y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x11y9E, buf);
    ::ccc::CC0x11y9 *dp, &lv = *(dp=new (buf) ::ccc::CC0x11y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x11y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x11y9E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x11y9E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc8CC0x11y9E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x11y9E);
    dp->::ccc::CC0x11y9::~CC0x11y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x11y9E(Test__ZN3ccc8CC0x11y9E, "_ZN3ccc8CC0x11y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x11y9C1Ev();
extern void _ZN3ccc8CC0x11y9D1Ev();
Name_Map name_map__ZN3ccc8CC0x11y9E[] = {
  NSPAIR(_ZN3ccc8CC0x11y9C1Ev),
  NSPAIR(_ZN3ccc8CC0x11y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc8CC0x11y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x11y9E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc8CC0x11y93efgEv();
extern void _ZN3ccc8CC0x11y93pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x11y93pqrEv,_ZThn4_N3ccc8CC0x11y93pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc8CC0x11y93efgEv,_ZThn4_N3ccc8CC0x11y93efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x11y9E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x11y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x11y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x11y93pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x11y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x11y93pqrEv,_ZThn4_N3ccc8CC0x11y93pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x11y93efgEv,_ZThn4_N3ccc8CC0x11y93efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x11y9E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x11y9E[];
Class_Descriptor cd__ZN3ccc8CC0x11y9E = {  "_ZN3ccc8CC0x11y9E", // class name
  bases__ZN3ccc8CC0x11y9E, 2,
  &(vtc__ZN3ccc8CC0x11y9E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x11y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x11y9E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x11y10  : ::ccc::AA0 , ::ccc::BB11 {
  virtual void  pqr(); // _ZN3ccc9CC0x11y103pqrEv
  virtual void  abc(); // _ZN3ccc9CC0x11y103abcEv
  ~CC0x11y10(); // tgen
  CC0x11y10(); // tgen
};
//SIG(1 _ZN3ccc9CC0x11y10E) C1{ BC2{ v2 v3 v1} BC3{ v1 v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x11y10 ::pqr(){vfunc_called(this, "_ZN3ccc9CC0x11y103pqrEv");}
void  ccc::CC0x11y10 ::abc(){vfunc_called(this, "_ZN3ccc9CC0x11y103abcEv");}
ccc::CC0x11y10 ::~CC0x11y10(){ note_dtor("_ZN3ccc9CC0x11y10E", this);} // tgen
ccc::CC0x11y10 ::CC0x11y10(){ note_ctor("_ZN3ccc9CC0x11y10E", this);} // tgen
}
static void Test__ZN3ccc9CC0x11y10E()
{
  extern Class_Descriptor cd__ZN3ccc9CC0x11y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC0x11y10E, buf);
    ::ccc::CC0x11y10 *dp, &lv = *(dp=new (buf) ::ccc::CC0x11y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC0x11y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC0x11y10E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc9CC0x11y10E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc9CC0x11y10E");
    test_class_info(&lv, &cd__ZN3ccc9CC0x11y10E);
    dp->::ccc::CC0x11y10::~CC0x11y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC0x11y10E(Test__ZN3ccc9CC0x11y10E, "_ZN3ccc9CC0x11y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC0x11y10C1Ev();
extern void _ZN3ccc9CC0x11y10D1Ev();
Name_Map name_map__ZN3ccc9CC0x11y10E[] = {
  NSPAIR(_ZN3ccc9CC0x11y10C1Ev),
  NSPAIR(_ZN3ccc9CC0x11y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc9CC0x11y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC0x11y10E[];
extern void _ZN3ccc9CC0x11y103abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc9CC0x11y103pqrEv();
extern void ABISELECT(_ZThn8_N3ccc9CC0x11y103pqrEv,_ZThn4_N3ccc9CC0x11y103pqrEv)();
extern void _ZN3ccc4BB113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC0x11y10E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x11y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC0x11y103abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC0x11y103pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x11y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc9CC0x11y103pqrEv,_ZThn4_N3ccc9CC0x11y103pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4BB113efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc9CC0x11y10E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC0x11y10E[];
Class_Descriptor cd__ZN3ccc9CC0x11y10E = {  "_ZN3ccc9CC0x11y10E", // class name
  bases__ZN3ccc9CC0x11y10E, 2,
  &(vtc__ZN3ccc9CC0x11y10E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC0x11y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC0x11y10E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x11y11  : ::ccc::AA0 , ::ccc::BB11 {
  virtual void  pqr(); // _ZN3ccc9CC0x11y113pqrEv
  virtual void  efg(); // _ZN3ccc9CC0x11y113efgEv
  ~CC0x11y11(); // tgen
  CC0x11y11(); // tgen
};
//SIG(1 _ZN3ccc9CC0x11y11E) C1{ BC2{ v3 v2 v1} BC3{ v1 v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x11y11 ::pqr(){vfunc_called(this, "_ZN3ccc9CC0x11y113pqrEv");}
void  ccc::CC0x11y11 ::efg(){vfunc_called(this, "_ZN3ccc9CC0x11y113efgEv");}
ccc::CC0x11y11 ::~CC0x11y11(){ note_dtor("_ZN3ccc9CC0x11y11E", this);} // tgen
ccc::CC0x11y11 ::CC0x11y11(){ note_ctor("_ZN3ccc9CC0x11y11E", this);} // tgen
}
static void Test__ZN3ccc9CC0x11y11E()
{
  extern Class_Descriptor cd__ZN3ccc9CC0x11y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC0x11y11E, buf);
    ::ccc::CC0x11y11 *dp, &lv = *(dp=new (buf) ::ccc::CC0x11y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC0x11y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC0x11y11E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc9CC0x11y11E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc9CC0x11y11E");
    test_class_info(&lv, &cd__ZN3ccc9CC0x11y11E);
    dp->::ccc::CC0x11y11::~CC0x11y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC0x11y11E(Test__ZN3ccc9CC0x11y11E, "_ZN3ccc9CC0x11y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC0x11y11C1Ev();
extern void _ZN3ccc9CC0x11y11D1Ev();
Name_Map name_map__ZN3ccc9CC0x11y11E[] = {
  NSPAIR(_ZN3ccc9CC0x11y11C1Ev),
  NSPAIR(_ZN3ccc9CC0x11y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc9CC0x11y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC0x11y11E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc9CC0x11y113efgEv();
extern void _ZN3ccc9CC0x11y113pqrEv();
extern void ABISELECT(_ZThn8_N3ccc9CC0x11y113pqrEv,_ZThn4_N3ccc9CC0x11y113pqrEv)();
extern void ABISELECT(_ZThn8_N3ccc9CC0x11y113efgEv,_ZThn4_N3ccc9CC0x11y113efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc9CC0x11y11E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x11y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC0x11y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC0x11y113pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x11y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc9CC0x11y113pqrEv,_ZThn4_N3ccc9CC0x11y113pqrEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc9CC0x11y113efgEv,_ZThn4_N3ccc9CC0x11y113efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc9CC0x11y11E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC0x11y11E[];
Class_Descriptor cd__ZN3ccc9CC0x11y11E = {  "_ZN3ccc9CC0x11y11E", // class name
  bases__ZN3ccc9CC0x11y11E, 2,
  &(vtc__ZN3ccc9CC0x11y11E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC0x11y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC0x11y11E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x11y12  : ::ccc::AA0 , ::ccc::BB11 {
  virtual void  abc(); // _ZN3ccc9CC0x11y123abcEv
  ~CC0x11y12(); // tgen
  CC0x11y12(); // tgen
};
//SIG(1 _ZN3ccc9CC0x11y12E) C1{ BC2{ v1 v2 v3} BC3{ v4 v5} v1}
}
namespace ccc { 
void  ccc::CC0x11y12 ::abc(){vfunc_called(this, "_ZN3ccc9CC0x11y123abcEv");}
ccc::CC0x11y12 ::~CC0x11y12(){ note_dtor("_ZN3ccc9CC0x11y12E", this);} // tgen
ccc::CC0x11y12 ::CC0x11y12(){ note_ctor("_ZN3ccc9CC0x11y12E", this);} // tgen
}
static void Test__ZN3ccc9CC0x11y12E()
{
  extern Class_Descriptor cd__ZN3ccc9CC0x11y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC0x11y12E, buf);
    ::ccc::CC0x11y12 *dp, &lv = *(dp=new (buf) ::ccc::CC0x11y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC0x11y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC0x11y12E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc9CC0x11y12E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc9CC0x11y12E");
    test_class_info(&lv, &cd__ZN3ccc9CC0x11y12E);
    dp->::ccc::CC0x11y12::~CC0x11y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC0x11y12E(Test__ZN3ccc9CC0x11y12E, "_ZN3ccc9CC0x11y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC0x11y12C1Ev();
extern void _ZN3ccc9CC0x11y12D1Ev();
Name_Map name_map__ZN3ccc9CC0x11y12E[] = {
  NSPAIR(_ZN3ccc9CC0x11y12C1Ev),
  NSPAIR(_ZN3ccc9CC0x11y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc9CC0x11y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC0x11y12E[];
extern void _ZN3ccc9CC0x11y123abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc4BB113pqrEv();
extern void _ZN3ccc4BB113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC0x11y12E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x11y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC0x11y123abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x11y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4BB113efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc9CC0x11y12E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC0x11y12E[];
Class_Descriptor cd__ZN3ccc9CC0x11y12E = {  "_ZN3ccc9CC0x11y12E", // class name
  bases__ZN3ccc9CC0x11y12E, 2,
  &(vtc__ZN3ccc9CC0x11y12E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC0x11y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC0x11y12E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x11y13  : ::ccc::AA0 , ::ccc::BB11 {
  virtual void  efg(); // _ZN3ccc9CC0x11y133efgEv
  ~CC0x11y13(); // tgen
  CC0x11y13(); // tgen
};
//SIG(1 _ZN3ccc9CC0x11y13E) C1{ BC2{ v2 v1 v3} BC3{ v4 v1} v1}
}
namespace ccc { 
void  ccc::CC0x11y13 ::efg(){vfunc_called(this, "_ZN3ccc9CC0x11y133efgEv");}
ccc::CC0x11y13 ::~CC0x11y13(){ note_dtor("_ZN3ccc9CC0x11y13E", this);} // tgen
ccc::CC0x11y13 ::CC0x11y13(){ note_ctor("_ZN3ccc9CC0x11y13E", this);} // tgen
}
static void Test__ZN3ccc9CC0x11y13E()
{
  extern Class_Descriptor cd__ZN3ccc9CC0x11y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC0x11y13E, buf);
    ::ccc::CC0x11y13 *dp, &lv = *(dp=new (buf) ::ccc::CC0x11y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC0x11y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC0x11y13E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc9CC0x11y13E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc9CC0x11y13E");
    test_class_info(&lv, &cd__ZN3ccc9CC0x11y13E);
    dp->::ccc::CC0x11y13::~CC0x11y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC0x11y13E(Test__ZN3ccc9CC0x11y13E, "_ZN3ccc9CC0x11y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC0x11y13C1Ev();
extern void _ZN3ccc9CC0x11y13D1Ev();
Name_Map name_map__ZN3ccc9CC0x11y13E[] = {
  NSPAIR(_ZN3ccc9CC0x11y13C1Ev),
  NSPAIR(_ZN3ccc9CC0x11y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc9CC0x11y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC0x11y13E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc9CC0x11y133efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc4BB113pqrEv();
extern void ABISELECT(_ZThn8_N3ccc9CC0x11y133efgEv,_ZThn4_N3ccc9CC0x11y133efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc9CC0x11y13E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x11y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC0x11y133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x11y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB113pqrEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc9CC0x11y133efgEv,_ZThn4_N3ccc9CC0x11y133efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc9CC0x11y13E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC0x11y13E[];
Class_Descriptor cd__ZN3ccc9CC0x11y13E = {  "_ZN3ccc9CC0x11y13E", // class name
  bases__ZN3ccc9CC0x11y13E, 2,
  &(vtc__ZN3ccc9CC0x11y13E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC0x11y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC0x11y13E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x11y14  : ::ccc::AA0 , ::ccc::BB11 {
  virtual void  pqr(); // _ZN3ccc9CC0x11y143pqrEv
  ~CC0x11y14(); // tgen
  CC0x11y14(); // tgen
};
//SIG(1 _ZN3ccc9CC0x11y14E) C1{ BC2{ v2 v3 v1} BC3{ v1 v4} v1}
}
namespace ccc { 
void  ccc::CC0x11y14 ::pqr(){vfunc_called(this, "_ZN3ccc9CC0x11y143pqrEv");}
ccc::CC0x11y14 ::~CC0x11y14(){ note_dtor("_ZN3ccc9CC0x11y14E", this);} // tgen
ccc::CC0x11y14 ::CC0x11y14(){ note_ctor("_ZN3ccc9CC0x11y14E", this);} // tgen
}
static void Test__ZN3ccc9CC0x11y14E()
{
  extern Class_Descriptor cd__ZN3ccc9CC0x11y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC0x11y14E, buf);
    ::ccc::CC0x11y14 *dp, &lv = *(dp=new (buf) ::ccc::CC0x11y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC0x11y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC0x11y14E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc9CC0x11y14E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc9CC0x11y14E");
    test_class_info(&lv, &cd__ZN3ccc9CC0x11y14E);
    dp->::ccc::CC0x11y14::~CC0x11y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC0x11y14E(Test__ZN3ccc9CC0x11y14E, "_ZN3ccc9CC0x11y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC0x11y14C1Ev();
extern void _ZN3ccc9CC0x11y14D1Ev();
Name_Map name_map__ZN3ccc9CC0x11y14E[] = {
  NSPAIR(_ZN3ccc9CC0x11y14C1Ev),
  NSPAIR(_ZN3ccc9CC0x11y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc9CC0x11y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC0x11y14E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc9CC0x11y143pqrEv();
extern void ABISELECT(_ZThn8_N3ccc9CC0x11y143pqrEv,_ZThn4_N3ccc9CC0x11y143pqrEv)();
extern void _ZN3ccc4BB113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC0x11y14E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x11y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC0x11y143pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x11y14E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc9CC0x11y143pqrEv,_ZThn4_N3ccc9CC0x11y143pqrEv),
  (VTBL_ENTRY)&_ZN3ccc4BB113efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc9CC0x11y14E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC0x11y14E[];
Class_Descriptor cd__ZN3ccc9CC0x11y14E = {  "_ZN3ccc9CC0x11y14E", // class name
  bases__ZN3ccc9CC0x11y14E, 2,
  &(vtc__ZN3ccc9CC0x11y14E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC0x11y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC0x11y14E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x11y15  : ::ccc::AA0 , ::ccc::BB11 {
  ~CC0x11y15(); // tgen
  CC0x11y15(); // tgen
};
//SIG(1 _ZN3ccc9CC0x11y15E) C1{ BC2{ v1 v2 v3} BC3{ v4 v5}}
}
namespace ccc { 
ccc::CC0x11y15 ::~CC0x11y15(){ note_dtor("_ZN3ccc9CC0x11y15E", this);} // tgen
ccc::CC0x11y15 ::CC0x11y15(){ note_ctor("_ZN3ccc9CC0x11y15E", this);} // tgen
}
static void Test__ZN3ccc9CC0x11y15E()
{
  extern Class_Descriptor cd__ZN3ccc9CC0x11y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC0x11y15E, buf);
    ::ccc::CC0x11y15 *dp, &lv = *(dp=new (buf) ::ccc::CC0x11y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC0x11y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC0x11y15E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc9CC0x11y15E");
    check_base_class_offset(lv, (::ccc::BB11*), ABISELECT(8,4), "_ZN3ccc9CC0x11y15E");
    test_class_info(&lv, &cd__ZN3ccc9CC0x11y15E);
    dp->::ccc::CC0x11y15::~CC0x11y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC0x11y15E(Test__ZN3ccc9CC0x11y15E, "_ZN3ccc9CC0x11y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC0x11y15C1Ev();
extern void _ZN3ccc9CC0x11y15D1Ev();
Name_Map name_map__ZN3ccc9CC0x11y15E[] = {
  NSPAIR(_ZN3ccc9CC0x11y15C1Ev),
  NSPAIR(_ZN3ccc9CC0x11y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB11E;
extern VTBL_ENTRY _ZTIN3ccc4BB11E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB11E[];
static Base_Class bases__ZN3ccc9CC0x11y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB11E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC0x11y15E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc4BB113pqrEv();
extern void _ZN3ccc4BB113efgEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC0x11y15E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x11y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x11y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB113pqrEv,
  (VTBL_ENTRY)&_ZN3ccc4BB113efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc9CC0x11y15E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC0x11y15E[];
Class_Descriptor cd__ZN3ccc9CC0x11y15E = {  "_ZN3ccc9CC0x11y15E", // class name
  bases__ZN3ccc9CC0x11y15E, 2,
  &(vtc__ZN3ccc9CC0x11y15E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC0x11y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC0x11y15E),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x12y0  : ::ccc::AA0 , ::ccc::BB12 {
  virtual void  abc(); // _ZN3ccc8CC0x12y03abcEv
  virtual void  efg(); // _ZN3ccc8CC0x12y03efgEv
  virtual void  pqr(); // _ZN3ccc8CC0x12y03pqrEv
  ~CC0x12y0(); // tgen
  CC0x12y0(); // tgen
};
//SIG(1 _ZN3ccc8CC0x12y0E) C1{ BC2{ v1 v2 v3} BC3{ v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x12y0 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x12y03abcEv");}
void  ccc::CC0x12y0 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x12y03efgEv");}
void  ccc::CC0x12y0 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x12y03pqrEv");}
ccc::CC0x12y0 ::~CC0x12y0(){ note_dtor("_ZN3ccc8CC0x12y0E", this);} // tgen
ccc::CC0x12y0 ::CC0x12y0(){ note_ctor("_ZN3ccc8CC0x12y0E", this);} // tgen
}
static void Test__ZN3ccc8CC0x12y0E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x12y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x12y0E, buf);
    ::ccc::CC0x12y0 *dp, &lv = *(dp=new (buf) ::ccc::CC0x12y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x12y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x12y0E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x12y0E");
    check_base_class_offset(lv, (::ccc::BB12*), ABISELECT(8,4), "_ZN3ccc8CC0x12y0E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x12y0E);
    dp->::ccc::CC0x12y0::~CC0x12y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x12y0E(Test__ZN3ccc8CC0x12y0E, "_ZN3ccc8CC0x12y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x12y0C1Ev();
extern void _ZN3ccc8CC0x12y0D1Ev();
Name_Map name_map__ZN3ccc8CC0x12y0E[] = {
  NSPAIR(_ZN3ccc8CC0x12y0C1Ev),
  NSPAIR(_ZN3ccc8CC0x12y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB12E;
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB12E[];
static Base_Class bases__ZN3ccc8CC0x12y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB12E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x12y0E[];
extern void _ZN3ccc8CC0x12y03abcEv();
extern void _ZN3ccc8CC0x12y03efgEv();
extern void _ZN3ccc8CC0x12y03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x12y03abcEv,_ZThn4_N3ccc8CC0x12y03abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x12y0E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x12y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x12y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x12y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x12y03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x12y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x12y03abcEv,_ZThn4_N3ccc8CC0x12y03abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x12y0E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x12y0E[];
Class_Descriptor cd__ZN3ccc8CC0x12y0E = {  "_ZN3ccc8CC0x12y0E", // class name
  bases__ZN3ccc8CC0x12y0E, 2,
  &(vtc__ZN3ccc8CC0x12y0E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x12y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x12y0E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x12y1  : ::ccc::AA0 , ::ccc::BB12 {
  virtual void  abc(); // _ZN3ccc8CC0x12y13abcEv
  virtual void  pqr(); // _ZN3ccc8CC0x12y13pqrEv
  virtual void  efg(); // _ZN3ccc8CC0x12y13efgEv
  ~CC0x12y1(); // tgen
  CC0x12y1(); // tgen
};
//SIG(1 _ZN3ccc8CC0x12y1E) C1{ BC2{ v1 v3 v2} BC3{ v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x12y1 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x12y13abcEv");}
void  ccc::CC0x12y1 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x12y13pqrEv");}
void  ccc::CC0x12y1 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x12y13efgEv");}
ccc::CC0x12y1 ::~CC0x12y1(){ note_dtor("_ZN3ccc8CC0x12y1E", this);} // tgen
ccc::CC0x12y1 ::CC0x12y1(){ note_ctor("_ZN3ccc8CC0x12y1E", this);} // tgen
}
static void Test__ZN3ccc8CC0x12y1E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x12y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x12y1E, buf);
    ::ccc::CC0x12y1 *dp, &lv = *(dp=new (buf) ::ccc::CC0x12y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x12y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x12y1E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x12y1E");
    check_base_class_offset(lv, (::ccc::BB12*), ABISELECT(8,4), "_ZN3ccc8CC0x12y1E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x12y1E);
    dp->::ccc::CC0x12y1::~CC0x12y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x12y1E(Test__ZN3ccc8CC0x12y1E, "_ZN3ccc8CC0x12y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x12y1C1Ev();
extern void _ZN3ccc8CC0x12y1D1Ev();
Name_Map name_map__ZN3ccc8CC0x12y1E[] = {
  NSPAIR(_ZN3ccc8CC0x12y1C1Ev),
  NSPAIR(_ZN3ccc8CC0x12y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB12E;
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB12E[];
static Base_Class bases__ZN3ccc8CC0x12y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB12E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x12y1E[];
extern void _ZN3ccc8CC0x12y13abcEv();
extern void _ZN3ccc8CC0x12y13efgEv();
extern void _ZN3ccc8CC0x12y13pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x12y13abcEv,_ZThn4_N3ccc8CC0x12y13abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x12y1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x12y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x12y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x12y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x12y13pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x12y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x12y13abcEv,_ZThn4_N3ccc8CC0x12y13abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x12y1E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x12y1E[];
Class_Descriptor cd__ZN3ccc8CC0x12y1E = {  "_ZN3ccc8CC0x12y1E", // class name
  bases__ZN3ccc8CC0x12y1E, 2,
  &(vtc__ZN3ccc8CC0x12y1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x12y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x12y1E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x12y2  : ::ccc::AA0 , ::ccc::BB12 {
  virtual void  efg(); // _ZN3ccc8CC0x12y23efgEv
  virtual void  abc(); // _ZN3ccc8CC0x12y23abcEv
  virtual void  pqr(); // _ZN3ccc8CC0x12y23pqrEv
  ~CC0x12y2(); // tgen
  CC0x12y2(); // tgen
};
//SIG(1 _ZN3ccc8CC0x12y2E) C1{ BC2{ v2 v1 v3} BC3{ v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x12y2 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x12y23efgEv");}
void  ccc::CC0x12y2 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x12y23abcEv");}
void  ccc::CC0x12y2 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x12y23pqrEv");}
ccc::CC0x12y2 ::~CC0x12y2(){ note_dtor("_ZN3ccc8CC0x12y2E", this);} // tgen
ccc::CC0x12y2 ::CC0x12y2(){ note_ctor("_ZN3ccc8CC0x12y2E", this);} // tgen
}
static void Test__ZN3ccc8CC0x12y2E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x12y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x12y2E, buf);
    ::ccc::CC0x12y2 *dp, &lv = *(dp=new (buf) ::ccc::CC0x12y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x12y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x12y2E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x12y2E");
    check_base_class_offset(lv, (::ccc::BB12*), ABISELECT(8,4), "_ZN3ccc8CC0x12y2E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x12y2E);
    dp->::ccc::CC0x12y2::~CC0x12y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x12y2E(Test__ZN3ccc8CC0x12y2E, "_ZN3ccc8CC0x12y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x12y2C1Ev();
extern void _ZN3ccc8CC0x12y2D1Ev();
Name_Map name_map__ZN3ccc8CC0x12y2E[] = {
  NSPAIR(_ZN3ccc8CC0x12y2C1Ev),
  NSPAIR(_ZN3ccc8CC0x12y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB12E;
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB12E[];
static Base_Class bases__ZN3ccc8CC0x12y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB12E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x12y2E[];
extern void _ZN3ccc8CC0x12y23abcEv();
extern void _ZN3ccc8CC0x12y23efgEv();
extern void _ZN3ccc8CC0x12y23pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x12y23abcEv,_ZThn4_N3ccc8CC0x12y23abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x12y2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x12y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x12y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x12y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x12y23pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x12y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x12y23abcEv,_ZThn4_N3ccc8CC0x12y23abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x12y2E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x12y2E[];
Class_Descriptor cd__ZN3ccc8CC0x12y2E = {  "_ZN3ccc8CC0x12y2E", // class name
  bases__ZN3ccc8CC0x12y2E, 2,
  &(vtc__ZN3ccc8CC0x12y2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x12y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x12y2E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x12y3  : ::ccc::AA0 , ::ccc::BB12 {
  virtual void  efg(); // _ZN3ccc8CC0x12y33efgEv
  virtual void  pqr(); // _ZN3ccc8CC0x12y33pqrEv
  virtual void  abc(); // _ZN3ccc8CC0x12y33abcEv
  ~CC0x12y3(); // tgen
  CC0x12y3(); // tgen
};
//SIG(1 _ZN3ccc8CC0x12y3E) C1{ BC2{ v3 v1 v2} BC3{ v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x12y3 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x12y33efgEv");}
void  ccc::CC0x12y3 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x12y33pqrEv");}
void  ccc::CC0x12y3 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x12y33abcEv");}
ccc::CC0x12y3 ::~CC0x12y3(){ note_dtor("_ZN3ccc8CC0x12y3E", this);} // tgen
ccc::CC0x12y3 ::CC0x12y3(){ note_ctor("_ZN3ccc8CC0x12y3E", this);} // tgen
}
static void Test__ZN3ccc8CC0x12y3E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x12y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x12y3E, buf);
    ::ccc::CC0x12y3 *dp, &lv = *(dp=new (buf) ::ccc::CC0x12y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x12y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x12y3E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x12y3E");
    check_base_class_offset(lv, (::ccc::BB12*), ABISELECT(8,4), "_ZN3ccc8CC0x12y3E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x12y3E);
    dp->::ccc::CC0x12y3::~CC0x12y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x12y3E(Test__ZN3ccc8CC0x12y3E, "_ZN3ccc8CC0x12y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x12y3C1Ev();
extern void _ZN3ccc8CC0x12y3D1Ev();
Name_Map name_map__ZN3ccc8CC0x12y3E[] = {
  NSPAIR(_ZN3ccc8CC0x12y3C1Ev),
  NSPAIR(_ZN3ccc8CC0x12y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB12E;
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB12E[];
static Base_Class bases__ZN3ccc8CC0x12y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB12E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x12y3E[];
extern void _ZN3ccc8CC0x12y33abcEv();
extern void _ZN3ccc8CC0x12y33efgEv();
extern void _ZN3ccc8CC0x12y33pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x12y33abcEv,_ZThn4_N3ccc8CC0x12y33abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x12y3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x12y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x12y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x12y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x12y33pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x12y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x12y33abcEv,_ZThn4_N3ccc8CC0x12y33abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x12y3E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x12y3E[];
Class_Descriptor cd__ZN3ccc8CC0x12y3E = {  "_ZN3ccc8CC0x12y3E", // class name
  bases__ZN3ccc8CC0x12y3E, 2,
  &(vtc__ZN3ccc8CC0x12y3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x12y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x12y3E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x12y4  : ::ccc::AA0 , ::ccc::BB12 {
  virtual void  pqr(); // _ZN3ccc8CC0x12y43pqrEv
  virtual void  abc(); // _ZN3ccc8CC0x12y43abcEv
  virtual void  efg(); // _ZN3ccc8CC0x12y43efgEv
  ~CC0x12y4(); // tgen
  CC0x12y4(); // tgen
};
//SIG(1 _ZN3ccc8CC0x12y4E) C1{ BC2{ v2 v3 v1} BC3{ v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x12y4 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x12y43pqrEv");}
void  ccc::CC0x12y4 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x12y43abcEv");}
void  ccc::CC0x12y4 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x12y43efgEv");}
ccc::CC0x12y4 ::~CC0x12y4(){ note_dtor("_ZN3ccc8CC0x12y4E", this);} // tgen
ccc::CC0x12y4 ::CC0x12y4(){ note_ctor("_ZN3ccc8CC0x12y4E", this);} // tgen
}
static void Test__ZN3ccc8CC0x12y4E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x12y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x12y4E, buf);
    ::ccc::CC0x12y4 *dp, &lv = *(dp=new (buf) ::ccc::CC0x12y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x12y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x12y4E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x12y4E");
    check_base_class_offset(lv, (::ccc::BB12*), ABISELECT(8,4), "_ZN3ccc8CC0x12y4E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x12y4E);
    dp->::ccc::CC0x12y4::~CC0x12y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x12y4E(Test__ZN3ccc8CC0x12y4E, "_ZN3ccc8CC0x12y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x12y4C1Ev();
extern void _ZN3ccc8CC0x12y4D1Ev();
Name_Map name_map__ZN3ccc8CC0x12y4E[] = {
  NSPAIR(_ZN3ccc8CC0x12y4C1Ev),
  NSPAIR(_ZN3ccc8CC0x12y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB12E;
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB12E[];
static Base_Class bases__ZN3ccc8CC0x12y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB12E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x12y4E[];
extern void _ZN3ccc8CC0x12y43abcEv();
extern void _ZN3ccc8CC0x12y43efgEv();
extern void _ZN3ccc8CC0x12y43pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x12y43abcEv,_ZThn4_N3ccc8CC0x12y43abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x12y4E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x12y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x12y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x12y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x12y43pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x12y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x12y43abcEv,_ZThn4_N3ccc8CC0x12y43abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x12y4E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x12y4E[];
Class_Descriptor cd__ZN3ccc8CC0x12y4E = {  "_ZN3ccc8CC0x12y4E", // class name
  bases__ZN3ccc8CC0x12y4E, 2,
  &(vtc__ZN3ccc8CC0x12y4E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x12y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x12y4E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x12y5  : ::ccc::AA0 , ::ccc::BB12 {
  virtual void  pqr(); // _ZN3ccc8CC0x12y53pqrEv
  virtual void  efg(); // _ZN3ccc8CC0x12y53efgEv
  virtual void  abc(); // _ZN3ccc8CC0x12y53abcEv
  ~CC0x12y5(); // tgen
  CC0x12y5(); // tgen
};
//SIG(1 _ZN3ccc8CC0x12y5E) C1{ BC2{ v3 v2 v1} BC3{ v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x12y5 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x12y53pqrEv");}
void  ccc::CC0x12y5 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x12y53efgEv");}
void  ccc::CC0x12y5 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x12y53abcEv");}
ccc::CC0x12y5 ::~CC0x12y5(){ note_dtor("_ZN3ccc8CC0x12y5E", this);} // tgen
ccc::CC0x12y5 ::CC0x12y5(){ note_ctor("_ZN3ccc8CC0x12y5E", this);} // tgen
}
static void Test__ZN3ccc8CC0x12y5E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x12y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x12y5E, buf);
    ::ccc::CC0x12y5 *dp, &lv = *(dp=new (buf) ::ccc::CC0x12y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x12y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x12y5E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x12y5E");
    check_base_class_offset(lv, (::ccc::BB12*), ABISELECT(8,4), "_ZN3ccc8CC0x12y5E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x12y5E);
    dp->::ccc::CC0x12y5::~CC0x12y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x12y5E(Test__ZN3ccc8CC0x12y5E, "_ZN3ccc8CC0x12y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x12y5C1Ev();
extern void _ZN3ccc8CC0x12y5D1Ev();
Name_Map name_map__ZN3ccc8CC0x12y5E[] = {
  NSPAIR(_ZN3ccc8CC0x12y5C1Ev),
  NSPAIR(_ZN3ccc8CC0x12y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB12E;
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB12E[];
static Base_Class bases__ZN3ccc8CC0x12y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB12E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x12y5E[];
extern void _ZN3ccc8CC0x12y53abcEv();
extern void _ZN3ccc8CC0x12y53efgEv();
extern void _ZN3ccc8CC0x12y53pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x12y53abcEv,_ZThn4_N3ccc8CC0x12y53abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x12y5E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x12y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x12y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x12y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x12y53pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x12y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x12y53abcEv,_ZThn4_N3ccc8CC0x12y53abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x12y5E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x12y5E[];
Class_Descriptor cd__ZN3ccc8CC0x12y5E = {  "_ZN3ccc8CC0x12y5E", // class name
  bases__ZN3ccc8CC0x12y5E, 2,
  &(vtc__ZN3ccc8CC0x12y5E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x12y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x12y5E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x12y6  : ::ccc::AA0 , ::ccc::BB12 {
  virtual void  abc(); // _ZN3ccc8CC0x12y63abcEv
  virtual void  efg(); // _ZN3ccc8CC0x12y63efgEv
  ~CC0x12y6(); // tgen
  CC0x12y6(); // tgen
};
//SIG(1 _ZN3ccc8CC0x12y6E) C1{ BC2{ v1 v2 v3} BC3{ v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x12y6 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x12y63abcEv");}
void  ccc::CC0x12y6 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x12y63efgEv");}
ccc::CC0x12y6 ::~CC0x12y6(){ note_dtor("_ZN3ccc8CC0x12y6E", this);} // tgen
ccc::CC0x12y6 ::CC0x12y6(){ note_ctor("_ZN3ccc8CC0x12y6E", this);} // tgen
}
static void Test__ZN3ccc8CC0x12y6E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x12y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x12y6E, buf);
    ::ccc::CC0x12y6 *dp, &lv = *(dp=new (buf) ::ccc::CC0x12y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x12y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x12y6E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x12y6E");
    check_base_class_offset(lv, (::ccc::BB12*), ABISELECT(8,4), "_ZN3ccc8CC0x12y6E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x12y6E);
    dp->::ccc::CC0x12y6::~CC0x12y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x12y6E(Test__ZN3ccc8CC0x12y6E, "_ZN3ccc8CC0x12y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x12y6C1Ev();
extern void _ZN3ccc8CC0x12y6D1Ev();
Name_Map name_map__ZN3ccc8CC0x12y6E[] = {
  NSPAIR(_ZN3ccc8CC0x12y6C1Ev),
  NSPAIR(_ZN3ccc8CC0x12y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB12E;
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB12E[];
static Base_Class bases__ZN3ccc8CC0x12y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB12E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x12y6E[];
extern void _ZN3ccc8CC0x12y63abcEv();
extern void _ZN3ccc8CC0x12y63efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x12y63abcEv,_ZThn4_N3ccc8CC0x12y63abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x12y6E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x12y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x12y63abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x12y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x12y6E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x12y63abcEv,_ZThn4_N3ccc8CC0x12y63abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x12y6E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x12y6E[];
Class_Descriptor cd__ZN3ccc8CC0x12y6E = {  "_ZN3ccc8CC0x12y6E", // class name
  bases__ZN3ccc8CC0x12y6E, 2,
  &(vtc__ZN3ccc8CC0x12y6E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x12y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x12y6E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x12y7  : ::ccc::AA0 , ::ccc::BB12 {
  virtual void  abc(); // _ZN3ccc8CC0x12y73abcEv
  virtual void  pqr(); // _ZN3ccc8CC0x12y73pqrEv
  ~CC0x12y7(); // tgen
  CC0x12y7(); // tgen
};
//SIG(1 _ZN3ccc8CC0x12y7E) C1{ BC2{ v1 v3 v2} BC3{ v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x12y7 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x12y73abcEv");}
void  ccc::CC0x12y7 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x12y73pqrEv");}
ccc::CC0x12y7 ::~CC0x12y7(){ note_dtor("_ZN3ccc8CC0x12y7E", this);} // tgen
ccc::CC0x12y7 ::CC0x12y7(){ note_ctor("_ZN3ccc8CC0x12y7E", this);} // tgen
}
static void Test__ZN3ccc8CC0x12y7E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x12y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x12y7E, buf);
    ::ccc::CC0x12y7 *dp, &lv = *(dp=new (buf) ::ccc::CC0x12y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x12y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x12y7E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x12y7E");
    check_base_class_offset(lv, (::ccc::BB12*), ABISELECT(8,4), "_ZN3ccc8CC0x12y7E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x12y7E);
    dp->::ccc::CC0x12y7::~CC0x12y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x12y7E(Test__ZN3ccc8CC0x12y7E, "_ZN3ccc8CC0x12y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x12y7C1Ev();
extern void _ZN3ccc8CC0x12y7D1Ev();
Name_Map name_map__ZN3ccc8CC0x12y7E[] = {
  NSPAIR(_ZN3ccc8CC0x12y7C1Ev),
  NSPAIR(_ZN3ccc8CC0x12y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB12E;
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB12E[];
static Base_Class bases__ZN3ccc8CC0x12y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB12E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x12y7E[];
extern void _ZN3ccc8CC0x12y73abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc8CC0x12y73pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x12y73abcEv,_ZThn4_N3ccc8CC0x12y73abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x12y7E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x12y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x12y73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x12y73pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x12y7E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x12y73abcEv,_ZThn4_N3ccc8CC0x12y73abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x12y7E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x12y7E[];
Class_Descriptor cd__ZN3ccc8CC0x12y7E = {  "_ZN3ccc8CC0x12y7E", // class name
  bases__ZN3ccc8CC0x12y7E, 2,
  &(vtc__ZN3ccc8CC0x12y7E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x12y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x12y7E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x12y8  : ::ccc::AA0 , ::ccc::BB12 {
  virtual void  efg(); // _ZN3ccc8CC0x12y83efgEv
  virtual void  abc(); // _ZN3ccc8CC0x12y83abcEv
  ~CC0x12y8(); // tgen
  CC0x12y8(); // tgen
};
//SIG(1 _ZN3ccc8CC0x12y8E) C1{ BC2{ v2 v1 v3} BC3{ v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x12y8 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x12y83efgEv");}
void  ccc::CC0x12y8 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x12y83abcEv");}
ccc::CC0x12y8 ::~CC0x12y8(){ note_dtor("_ZN3ccc8CC0x12y8E", this);} // tgen
ccc::CC0x12y8 ::CC0x12y8(){ note_ctor("_ZN3ccc8CC0x12y8E", this);} // tgen
}
static void Test__ZN3ccc8CC0x12y8E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x12y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x12y8E, buf);
    ::ccc::CC0x12y8 *dp, &lv = *(dp=new (buf) ::ccc::CC0x12y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x12y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x12y8E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x12y8E");
    check_base_class_offset(lv, (::ccc::BB12*), ABISELECT(8,4), "_ZN3ccc8CC0x12y8E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x12y8E);
    dp->::ccc::CC0x12y8::~CC0x12y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x12y8E(Test__ZN3ccc8CC0x12y8E, "_ZN3ccc8CC0x12y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x12y8C1Ev();
extern void _ZN3ccc8CC0x12y8D1Ev();
Name_Map name_map__ZN3ccc8CC0x12y8E[] = {
  NSPAIR(_ZN3ccc8CC0x12y8C1Ev),
  NSPAIR(_ZN3ccc8CC0x12y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB12E;
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB12E[];
static Base_Class bases__ZN3ccc8CC0x12y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB12E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x12y8E[];
extern void _ZN3ccc8CC0x12y83abcEv();
extern void _ZN3ccc8CC0x12y83efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x12y83abcEv,_ZThn4_N3ccc8CC0x12y83abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x12y8E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x12y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x12y83abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x12y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x12y8E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x12y83abcEv,_ZThn4_N3ccc8CC0x12y83abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x12y8E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x12y8E[];
Class_Descriptor cd__ZN3ccc8CC0x12y8E = {  "_ZN3ccc8CC0x12y8E", // class name
  bases__ZN3ccc8CC0x12y8E, 2,
  &(vtc__ZN3ccc8CC0x12y8E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x12y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x12y8E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x12y9  : ::ccc::AA0 , ::ccc::BB12 {
  virtual void  efg(); // _ZN3ccc8CC0x12y93efgEv
  virtual void  pqr(); // _ZN3ccc8CC0x12y93pqrEv
  ~CC0x12y9(); // tgen
  CC0x12y9(); // tgen
};
//SIG(1 _ZN3ccc8CC0x12y9E) C1{ BC2{ v3 v1 v2} BC3{ v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x12y9 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x12y93efgEv");}
void  ccc::CC0x12y9 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x12y93pqrEv");}
ccc::CC0x12y9 ::~CC0x12y9(){ note_dtor("_ZN3ccc8CC0x12y9E", this);} // tgen
ccc::CC0x12y9 ::CC0x12y9(){ note_ctor("_ZN3ccc8CC0x12y9E", this);} // tgen
}
static void Test__ZN3ccc8CC0x12y9E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x12y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x12y9E, buf);
    ::ccc::CC0x12y9 *dp, &lv = *(dp=new (buf) ::ccc::CC0x12y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x12y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x12y9E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x12y9E");
    check_base_class_offset(lv, (::ccc::BB12*), ABISELECT(8,4), "_ZN3ccc8CC0x12y9E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x12y9E);
    dp->::ccc::CC0x12y9::~CC0x12y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x12y9E(Test__ZN3ccc8CC0x12y9E, "_ZN3ccc8CC0x12y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x12y9C1Ev();
extern void _ZN3ccc8CC0x12y9D1Ev();
Name_Map name_map__ZN3ccc8CC0x12y9E[] = {
  NSPAIR(_ZN3ccc8CC0x12y9C1Ev),
  NSPAIR(_ZN3ccc8CC0x12y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB12E;
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB12E[];
static Base_Class bases__ZN3ccc8CC0x12y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB12E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x12y9E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc8CC0x12y93efgEv();
extern void _ZN3ccc8CC0x12y93pqrEv();
extern void _ZN3ccc4BB123abcEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x12y9E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x12y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x12y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x12y93pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x12y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB123abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x12y9E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x12y9E[];
Class_Descriptor cd__ZN3ccc8CC0x12y9E = {  "_ZN3ccc8CC0x12y9E", // class name
  bases__ZN3ccc8CC0x12y9E, 2,
  &(vtc__ZN3ccc8CC0x12y9E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x12y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x12y9E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x12y10  : ::ccc::AA0 , ::ccc::BB12 {
  virtual void  pqr(); // _ZN3ccc9CC0x12y103pqrEv
  virtual void  abc(); // _ZN3ccc9CC0x12y103abcEv
  ~CC0x12y10(); // tgen
  CC0x12y10(); // tgen
};
//SIG(1 _ZN3ccc9CC0x12y10E) C1{ BC2{ v2 v3 v1} BC3{ v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x12y10 ::pqr(){vfunc_called(this, "_ZN3ccc9CC0x12y103pqrEv");}
void  ccc::CC0x12y10 ::abc(){vfunc_called(this, "_ZN3ccc9CC0x12y103abcEv");}
ccc::CC0x12y10 ::~CC0x12y10(){ note_dtor("_ZN3ccc9CC0x12y10E", this);} // tgen
ccc::CC0x12y10 ::CC0x12y10(){ note_ctor("_ZN3ccc9CC0x12y10E", this);} // tgen
}
static void Test__ZN3ccc9CC0x12y10E()
{
  extern Class_Descriptor cd__ZN3ccc9CC0x12y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC0x12y10E, buf);
    ::ccc::CC0x12y10 *dp, &lv = *(dp=new (buf) ::ccc::CC0x12y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC0x12y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC0x12y10E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc9CC0x12y10E");
    check_base_class_offset(lv, (::ccc::BB12*), ABISELECT(8,4), "_ZN3ccc9CC0x12y10E");
    test_class_info(&lv, &cd__ZN3ccc9CC0x12y10E);
    dp->::ccc::CC0x12y10::~CC0x12y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC0x12y10E(Test__ZN3ccc9CC0x12y10E, "_ZN3ccc9CC0x12y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC0x12y10C1Ev();
extern void _ZN3ccc9CC0x12y10D1Ev();
Name_Map name_map__ZN3ccc9CC0x12y10E[] = {
  NSPAIR(_ZN3ccc9CC0x12y10C1Ev),
  NSPAIR(_ZN3ccc9CC0x12y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB12E;
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB12E[];
static Base_Class bases__ZN3ccc9CC0x12y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB12E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC0x12y10E[];
extern void _ZN3ccc9CC0x12y103abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc9CC0x12y103pqrEv();
extern void ABISELECT(_ZThn8_N3ccc9CC0x12y103abcEv,_ZThn4_N3ccc9CC0x12y103abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc9CC0x12y10E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x12y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC0x12y103abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC0x12y103pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x12y10E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc9CC0x12y103abcEv,_ZThn4_N3ccc9CC0x12y103abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc9CC0x12y10E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC0x12y10E[];
Class_Descriptor cd__ZN3ccc9CC0x12y10E = {  "_ZN3ccc9CC0x12y10E", // class name
  bases__ZN3ccc9CC0x12y10E, 2,
  &(vtc__ZN3ccc9CC0x12y10E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC0x12y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC0x12y10E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x12y11  : ::ccc::AA0 , ::ccc::BB12 {
  virtual void  pqr(); // _ZN3ccc9CC0x12y113pqrEv
  virtual void  efg(); // _ZN3ccc9CC0x12y113efgEv
  ~CC0x12y11(); // tgen
  CC0x12y11(); // tgen
};
//SIG(1 _ZN3ccc9CC0x12y11E) C1{ BC2{ v3 v2 v1} BC3{ v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x12y11 ::pqr(){vfunc_called(this, "_ZN3ccc9CC0x12y113pqrEv");}
void  ccc::CC0x12y11 ::efg(){vfunc_called(this, "_ZN3ccc9CC0x12y113efgEv");}
ccc::CC0x12y11 ::~CC0x12y11(){ note_dtor("_ZN3ccc9CC0x12y11E", this);} // tgen
ccc::CC0x12y11 ::CC0x12y11(){ note_ctor("_ZN3ccc9CC0x12y11E", this);} // tgen
}
static void Test__ZN3ccc9CC0x12y11E()
{
  extern Class_Descriptor cd__ZN3ccc9CC0x12y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC0x12y11E, buf);
    ::ccc::CC0x12y11 *dp, &lv = *(dp=new (buf) ::ccc::CC0x12y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC0x12y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC0x12y11E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc9CC0x12y11E");
    check_base_class_offset(lv, (::ccc::BB12*), ABISELECT(8,4), "_ZN3ccc9CC0x12y11E");
    test_class_info(&lv, &cd__ZN3ccc9CC0x12y11E);
    dp->::ccc::CC0x12y11::~CC0x12y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC0x12y11E(Test__ZN3ccc9CC0x12y11E, "_ZN3ccc9CC0x12y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC0x12y11C1Ev();
extern void _ZN3ccc9CC0x12y11D1Ev();
Name_Map name_map__ZN3ccc9CC0x12y11E[] = {
  NSPAIR(_ZN3ccc9CC0x12y11C1Ev),
  NSPAIR(_ZN3ccc9CC0x12y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB12E;
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB12E[];
static Base_Class bases__ZN3ccc9CC0x12y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB12E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC0x12y11E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc9CC0x12y113efgEv();
extern void _ZN3ccc9CC0x12y113pqrEv();
extern void _ZN3ccc4BB123abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC0x12y11E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x12y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC0x12y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC0x12y113pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x12y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB123abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc9CC0x12y11E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC0x12y11E[];
Class_Descriptor cd__ZN3ccc9CC0x12y11E = {  "_ZN3ccc9CC0x12y11E", // class name
  bases__ZN3ccc9CC0x12y11E, 2,
  &(vtc__ZN3ccc9CC0x12y11E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC0x12y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC0x12y11E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x12y12  : ::ccc::AA0 , ::ccc::BB12 {
  virtual void  abc(); // _ZN3ccc9CC0x12y123abcEv
  ~CC0x12y12(); // tgen
  CC0x12y12(); // tgen
};
//SIG(1 _ZN3ccc9CC0x12y12E) C1{ BC2{ v1 v2 v3} BC3{ v1} v1}
}
namespace ccc { 
void  ccc::CC0x12y12 ::abc(){vfunc_called(this, "_ZN3ccc9CC0x12y123abcEv");}
ccc::CC0x12y12 ::~CC0x12y12(){ note_dtor("_ZN3ccc9CC0x12y12E", this);} // tgen
ccc::CC0x12y12 ::CC0x12y12(){ note_ctor("_ZN3ccc9CC0x12y12E", this);} // tgen
}
static void Test__ZN3ccc9CC0x12y12E()
{
  extern Class_Descriptor cd__ZN3ccc9CC0x12y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC0x12y12E, buf);
    ::ccc::CC0x12y12 *dp, &lv = *(dp=new (buf) ::ccc::CC0x12y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC0x12y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC0x12y12E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc9CC0x12y12E");
    check_base_class_offset(lv, (::ccc::BB12*), ABISELECT(8,4), "_ZN3ccc9CC0x12y12E");
    test_class_info(&lv, &cd__ZN3ccc9CC0x12y12E);
    dp->::ccc::CC0x12y12::~CC0x12y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC0x12y12E(Test__ZN3ccc9CC0x12y12E, "_ZN3ccc9CC0x12y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC0x12y12C1Ev();
extern void _ZN3ccc9CC0x12y12D1Ev();
Name_Map name_map__ZN3ccc9CC0x12y12E[] = {
  NSPAIR(_ZN3ccc9CC0x12y12C1Ev),
  NSPAIR(_ZN3ccc9CC0x12y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB12E;
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB12E[];
static Base_Class bases__ZN3ccc9CC0x12y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB12E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC0x12y12E[];
extern void _ZN3ccc9CC0x12y123abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc9CC0x12y123abcEv,_ZThn4_N3ccc9CC0x12y123abcEv)();
static  VTBL_ENTRY vtc__ZN3ccc9CC0x12y12E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x12y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC0x12y123abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x12y12E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc9CC0x12y123abcEv,_ZThn4_N3ccc9CC0x12y123abcEv),
};
extern VTBL_ENTRY _ZTIN3ccc9CC0x12y12E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC0x12y12E[];
Class_Descriptor cd__ZN3ccc9CC0x12y12E = {  "_ZN3ccc9CC0x12y12E", // class name
  bases__ZN3ccc9CC0x12y12E, 2,
  &(vtc__ZN3ccc9CC0x12y12E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC0x12y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC0x12y12E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x12y13  : ::ccc::AA0 , ::ccc::BB12 {
  virtual void  efg(); // _ZN3ccc9CC0x12y133efgEv
  ~CC0x12y13(); // tgen
  CC0x12y13(); // tgen
};
//SIG(1 _ZN3ccc9CC0x12y13E) C1{ BC2{ v2 v1 v3} BC3{ v4} v1}
}
namespace ccc { 
void  ccc::CC0x12y13 ::efg(){vfunc_called(this, "_ZN3ccc9CC0x12y133efgEv");}
ccc::CC0x12y13 ::~CC0x12y13(){ note_dtor("_ZN3ccc9CC0x12y13E", this);} // tgen
ccc::CC0x12y13 ::CC0x12y13(){ note_ctor("_ZN3ccc9CC0x12y13E", this);} // tgen
}
static void Test__ZN3ccc9CC0x12y13E()
{
  extern Class_Descriptor cd__ZN3ccc9CC0x12y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC0x12y13E, buf);
    ::ccc::CC0x12y13 *dp, &lv = *(dp=new (buf) ::ccc::CC0x12y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC0x12y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC0x12y13E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc9CC0x12y13E");
    check_base_class_offset(lv, (::ccc::BB12*), ABISELECT(8,4), "_ZN3ccc9CC0x12y13E");
    test_class_info(&lv, &cd__ZN3ccc9CC0x12y13E);
    dp->::ccc::CC0x12y13::~CC0x12y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC0x12y13E(Test__ZN3ccc9CC0x12y13E, "_ZN3ccc9CC0x12y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC0x12y13C1Ev();
extern void _ZN3ccc9CC0x12y13D1Ev();
Name_Map name_map__ZN3ccc9CC0x12y13E[] = {
  NSPAIR(_ZN3ccc9CC0x12y13C1Ev),
  NSPAIR(_ZN3ccc9CC0x12y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB12E;
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB12E[];
static Base_Class bases__ZN3ccc9CC0x12y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB12E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC0x12y13E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc9CC0x12y133efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc4BB123abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC0x12y13E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x12y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC0x12y133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x12y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB123abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc9CC0x12y13E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC0x12y13E[];
Class_Descriptor cd__ZN3ccc9CC0x12y13E = {  "_ZN3ccc9CC0x12y13E", // class name
  bases__ZN3ccc9CC0x12y13E, 2,
  &(vtc__ZN3ccc9CC0x12y13E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC0x12y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC0x12y13E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x12y14  : ::ccc::AA0 , ::ccc::BB12 {
  virtual void  pqr(); // _ZN3ccc9CC0x12y143pqrEv
  ~CC0x12y14(); // tgen
  CC0x12y14(); // tgen
};
//SIG(1 _ZN3ccc9CC0x12y14E) C1{ BC2{ v2 v3 v1} BC3{ v4} v1}
}
namespace ccc { 
void  ccc::CC0x12y14 ::pqr(){vfunc_called(this, "_ZN3ccc9CC0x12y143pqrEv");}
ccc::CC0x12y14 ::~CC0x12y14(){ note_dtor("_ZN3ccc9CC0x12y14E", this);} // tgen
ccc::CC0x12y14 ::CC0x12y14(){ note_ctor("_ZN3ccc9CC0x12y14E", this);} // tgen
}
static void Test__ZN3ccc9CC0x12y14E()
{
  extern Class_Descriptor cd__ZN3ccc9CC0x12y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC0x12y14E, buf);
    ::ccc::CC0x12y14 *dp, &lv = *(dp=new (buf) ::ccc::CC0x12y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC0x12y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC0x12y14E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc9CC0x12y14E");
    check_base_class_offset(lv, (::ccc::BB12*), ABISELECT(8,4), "_ZN3ccc9CC0x12y14E");
    test_class_info(&lv, &cd__ZN3ccc9CC0x12y14E);
    dp->::ccc::CC0x12y14::~CC0x12y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC0x12y14E(Test__ZN3ccc9CC0x12y14E, "_ZN3ccc9CC0x12y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC0x12y14C1Ev();
extern void _ZN3ccc9CC0x12y14D1Ev();
Name_Map name_map__ZN3ccc9CC0x12y14E[] = {
  NSPAIR(_ZN3ccc9CC0x12y14C1Ev),
  NSPAIR(_ZN3ccc9CC0x12y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB12E;
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB12E[];
static Base_Class bases__ZN3ccc9CC0x12y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB12E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC0x12y14E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc9CC0x12y143pqrEv();
extern void _ZN3ccc4BB123abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC0x12y14E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x12y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC0x12y143pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x12y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB123abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc9CC0x12y14E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC0x12y14E[];
Class_Descriptor cd__ZN3ccc9CC0x12y14E = {  "_ZN3ccc9CC0x12y14E", // class name
  bases__ZN3ccc9CC0x12y14E, 2,
  &(vtc__ZN3ccc9CC0x12y14E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC0x12y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC0x12y14E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x12y15  : ::ccc::AA0 , ::ccc::BB12 {
  ~CC0x12y15(); // tgen
  CC0x12y15(); // tgen
};
//SIG(1 _ZN3ccc9CC0x12y15E) C1{ BC2{ v1 v2 v3} BC3{ v4}}
}
namespace ccc { 
ccc::CC0x12y15 ::~CC0x12y15(){ note_dtor("_ZN3ccc9CC0x12y15E", this);} // tgen
ccc::CC0x12y15 ::CC0x12y15(){ note_ctor("_ZN3ccc9CC0x12y15E", this);} // tgen
}
static void Test__ZN3ccc9CC0x12y15E()
{
  extern Class_Descriptor cd__ZN3ccc9CC0x12y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC0x12y15E, buf);
    ::ccc::CC0x12y15 *dp, &lv = *(dp=new (buf) ::ccc::CC0x12y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC0x12y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC0x12y15E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc9CC0x12y15E");
    check_base_class_offset(lv, (::ccc::BB12*), ABISELECT(8,4), "_ZN3ccc9CC0x12y15E");
    test_class_info(&lv, &cd__ZN3ccc9CC0x12y15E);
    dp->::ccc::CC0x12y15::~CC0x12y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC0x12y15E(Test__ZN3ccc9CC0x12y15E, "_ZN3ccc9CC0x12y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC0x12y15C1Ev();
extern void _ZN3ccc9CC0x12y15D1Ev();
Name_Map name_map__ZN3ccc9CC0x12y15E[] = {
  NSPAIR(_ZN3ccc9CC0x12y15C1Ev),
  NSPAIR(_ZN3ccc9CC0x12y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB12E;
extern VTBL_ENTRY _ZTIN3ccc4BB12E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB12E[];
static Base_Class bases__ZN3ccc9CC0x12y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB12E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC0x12y15E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc4BB123abcEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC0x12y15E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x12y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x12y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB123abcEv,
};
extern VTBL_ENTRY _ZTIN3ccc9CC0x12y15E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC0x12y15E[];
Class_Descriptor cd__ZN3ccc9CC0x12y15E = {  "_ZN3ccc9CC0x12y15E", // class name
  bases__ZN3ccc9CC0x12y15E, 2,
  &(vtc__ZN3ccc9CC0x12y15E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC0x12y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC0x12y15E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x13y0  : ::ccc::AA0 , ::ccc::BB13 {
  virtual void  abc(); // _ZN3ccc8CC0x13y03abcEv
  virtual void  efg(); // _ZN3ccc8CC0x13y03efgEv
  virtual void  pqr(); // _ZN3ccc8CC0x13y03pqrEv
  ~CC0x13y0(); // tgen
  CC0x13y0(); // tgen
};
//SIG(1 _ZN3ccc8CC0x13y0E) C1{ BC2{ v1 v2 v3} BC3{ v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x13y0 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x13y03abcEv");}
void  ccc::CC0x13y0 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x13y03efgEv");}
void  ccc::CC0x13y0 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x13y03pqrEv");}
ccc::CC0x13y0 ::~CC0x13y0(){ note_dtor("_ZN3ccc8CC0x13y0E", this);} // tgen
ccc::CC0x13y0 ::CC0x13y0(){ note_ctor("_ZN3ccc8CC0x13y0E", this);} // tgen
}
static void Test__ZN3ccc8CC0x13y0E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x13y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x13y0E, buf);
    ::ccc::CC0x13y0 *dp, &lv = *(dp=new (buf) ::ccc::CC0x13y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x13y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x13y0E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x13y0E");
    check_base_class_offset(lv, (::ccc::BB13*), ABISELECT(8,4), "_ZN3ccc8CC0x13y0E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x13y0E);
    dp->::ccc::CC0x13y0::~CC0x13y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x13y0E(Test__ZN3ccc8CC0x13y0E, "_ZN3ccc8CC0x13y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x13y0C1Ev();
extern void _ZN3ccc8CC0x13y0D1Ev();
Name_Map name_map__ZN3ccc8CC0x13y0E[] = {
  NSPAIR(_ZN3ccc8CC0x13y0C1Ev),
  NSPAIR(_ZN3ccc8CC0x13y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB13E;
extern VTBL_ENTRY _ZTIN3ccc4BB13E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB13E[];
static Base_Class bases__ZN3ccc8CC0x13y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB13E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x13y0E[];
extern void _ZN3ccc8CC0x13y03abcEv();
extern void _ZN3ccc8CC0x13y03efgEv();
extern void _ZN3ccc8CC0x13y03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x13y03efgEv,_ZThn4_N3ccc8CC0x13y03efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x13y0E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x13y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x13y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x13y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x13y03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x13y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x13y03efgEv,_ZThn4_N3ccc8CC0x13y03efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x13y0E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x13y0E[];
Class_Descriptor cd__ZN3ccc8CC0x13y0E = {  "_ZN3ccc8CC0x13y0E", // class name
  bases__ZN3ccc8CC0x13y0E, 2,
  &(vtc__ZN3ccc8CC0x13y0E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x13y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x13y0E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x13y1  : ::ccc::AA0 , ::ccc::BB13 {
  virtual void  abc(); // _ZN3ccc8CC0x13y13abcEv
  virtual void  pqr(); // _ZN3ccc8CC0x13y13pqrEv
  virtual void  efg(); // _ZN3ccc8CC0x13y13efgEv
  ~CC0x13y1(); // tgen
  CC0x13y1(); // tgen
};
//SIG(1 _ZN3ccc8CC0x13y1E) C1{ BC2{ v1 v3 v2} BC3{ v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x13y1 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x13y13abcEv");}
void  ccc::CC0x13y1 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x13y13pqrEv");}
void  ccc::CC0x13y1 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x13y13efgEv");}
ccc::CC0x13y1 ::~CC0x13y1(){ note_dtor("_ZN3ccc8CC0x13y1E", this);} // tgen
ccc::CC0x13y1 ::CC0x13y1(){ note_ctor("_ZN3ccc8CC0x13y1E", this);} // tgen
}
static void Test__ZN3ccc8CC0x13y1E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x13y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x13y1E, buf);
    ::ccc::CC0x13y1 *dp, &lv = *(dp=new (buf) ::ccc::CC0x13y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x13y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x13y1E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x13y1E");
    check_base_class_offset(lv, (::ccc::BB13*), ABISELECT(8,4), "_ZN3ccc8CC0x13y1E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x13y1E);
    dp->::ccc::CC0x13y1::~CC0x13y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x13y1E(Test__ZN3ccc8CC0x13y1E, "_ZN3ccc8CC0x13y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x13y1C1Ev();
extern void _ZN3ccc8CC0x13y1D1Ev();
Name_Map name_map__ZN3ccc8CC0x13y1E[] = {
  NSPAIR(_ZN3ccc8CC0x13y1C1Ev),
  NSPAIR(_ZN3ccc8CC0x13y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB13E;
extern VTBL_ENTRY _ZTIN3ccc4BB13E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB13E[];
static Base_Class bases__ZN3ccc8CC0x13y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB13E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x13y1E[];
extern void _ZN3ccc8CC0x13y13abcEv();
extern void _ZN3ccc8CC0x13y13efgEv();
extern void _ZN3ccc8CC0x13y13pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x13y13efgEv,_ZThn4_N3ccc8CC0x13y13efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x13y1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x13y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x13y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x13y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x13y13pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x13y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x13y13efgEv,_ZThn4_N3ccc8CC0x13y13efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x13y1E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x13y1E[];
Class_Descriptor cd__ZN3ccc8CC0x13y1E = {  "_ZN3ccc8CC0x13y1E", // class name
  bases__ZN3ccc8CC0x13y1E, 2,
  &(vtc__ZN3ccc8CC0x13y1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x13y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x13y1E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x13y2  : ::ccc::AA0 , ::ccc::BB13 {
  virtual void  efg(); // _ZN3ccc8CC0x13y23efgEv
  virtual void  abc(); // _ZN3ccc8CC0x13y23abcEv
  virtual void  pqr(); // _ZN3ccc8CC0x13y23pqrEv
  ~CC0x13y2(); // tgen
  CC0x13y2(); // tgen
};
//SIG(1 _ZN3ccc8CC0x13y2E) C1{ BC2{ v2 v1 v3} BC3{ v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x13y2 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x13y23efgEv");}
void  ccc::CC0x13y2 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x13y23abcEv");}
void  ccc::CC0x13y2 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x13y23pqrEv");}
ccc::CC0x13y2 ::~CC0x13y2(){ note_dtor("_ZN3ccc8CC0x13y2E", this);} // tgen
ccc::CC0x13y2 ::CC0x13y2(){ note_ctor("_ZN3ccc8CC0x13y2E", this);} // tgen
}
static void Test__ZN3ccc8CC0x13y2E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x13y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x13y2E, buf);
    ::ccc::CC0x13y2 *dp, &lv = *(dp=new (buf) ::ccc::CC0x13y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x13y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x13y2E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x13y2E");
    check_base_class_offset(lv, (::ccc::BB13*), ABISELECT(8,4), "_ZN3ccc8CC0x13y2E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x13y2E);
    dp->::ccc::CC0x13y2::~CC0x13y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x13y2E(Test__ZN3ccc8CC0x13y2E, "_ZN3ccc8CC0x13y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x13y2C1Ev();
extern void _ZN3ccc8CC0x13y2D1Ev();
Name_Map name_map__ZN3ccc8CC0x13y2E[] = {
  NSPAIR(_ZN3ccc8CC0x13y2C1Ev),
  NSPAIR(_ZN3ccc8CC0x13y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB13E;
extern VTBL_ENTRY _ZTIN3ccc4BB13E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB13E[];
static Base_Class bases__ZN3ccc8CC0x13y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB13E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x13y2E[];
extern void _ZN3ccc8CC0x13y23abcEv();
extern void _ZN3ccc8CC0x13y23efgEv();
extern void _ZN3ccc8CC0x13y23pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x13y23efgEv,_ZThn4_N3ccc8CC0x13y23efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x13y2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x13y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x13y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x13y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x13y23pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x13y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x13y23efgEv,_ZThn4_N3ccc8CC0x13y23efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x13y2E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x13y2E[];
Class_Descriptor cd__ZN3ccc8CC0x13y2E = {  "_ZN3ccc8CC0x13y2E", // class name
  bases__ZN3ccc8CC0x13y2E, 2,
  &(vtc__ZN3ccc8CC0x13y2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x13y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x13y2E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x13y3  : ::ccc::AA0 , ::ccc::BB13 {
  virtual void  efg(); // _ZN3ccc8CC0x13y33efgEv
  virtual void  pqr(); // _ZN3ccc8CC0x13y33pqrEv
  virtual void  abc(); // _ZN3ccc8CC0x13y33abcEv
  ~CC0x13y3(); // tgen
  CC0x13y3(); // tgen
};
//SIG(1 _ZN3ccc8CC0x13y3E) C1{ BC2{ v3 v1 v2} BC3{ v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x13y3 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x13y33efgEv");}
void  ccc::CC0x13y3 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x13y33pqrEv");}
void  ccc::CC0x13y3 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x13y33abcEv");}
ccc::CC0x13y3 ::~CC0x13y3(){ note_dtor("_ZN3ccc8CC0x13y3E", this);} // tgen
ccc::CC0x13y3 ::CC0x13y3(){ note_ctor("_ZN3ccc8CC0x13y3E", this);} // tgen
}
static void Test__ZN3ccc8CC0x13y3E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x13y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x13y3E, buf);
    ::ccc::CC0x13y3 *dp, &lv = *(dp=new (buf) ::ccc::CC0x13y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x13y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x13y3E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x13y3E");
    check_base_class_offset(lv, (::ccc::BB13*), ABISELECT(8,4), "_ZN3ccc8CC0x13y3E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x13y3E);
    dp->::ccc::CC0x13y3::~CC0x13y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x13y3E(Test__ZN3ccc8CC0x13y3E, "_ZN3ccc8CC0x13y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x13y3C1Ev();
extern void _ZN3ccc8CC0x13y3D1Ev();
Name_Map name_map__ZN3ccc8CC0x13y3E[] = {
  NSPAIR(_ZN3ccc8CC0x13y3C1Ev),
  NSPAIR(_ZN3ccc8CC0x13y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB13E;
extern VTBL_ENTRY _ZTIN3ccc4BB13E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB13E[];
static Base_Class bases__ZN3ccc8CC0x13y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB13E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x13y3E[];
extern void _ZN3ccc8CC0x13y33abcEv();
extern void _ZN3ccc8CC0x13y33efgEv();
extern void _ZN3ccc8CC0x13y33pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x13y33efgEv,_ZThn4_N3ccc8CC0x13y33efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x13y3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x13y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x13y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x13y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x13y33pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x13y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x13y33efgEv,_ZThn4_N3ccc8CC0x13y33efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x13y3E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x13y3E[];
Class_Descriptor cd__ZN3ccc8CC0x13y3E = {  "_ZN3ccc8CC0x13y3E", // class name
  bases__ZN3ccc8CC0x13y3E, 2,
  &(vtc__ZN3ccc8CC0x13y3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x13y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x13y3E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x13y4  : ::ccc::AA0 , ::ccc::BB13 {
  virtual void  pqr(); // _ZN3ccc8CC0x13y43pqrEv
  virtual void  abc(); // _ZN3ccc8CC0x13y43abcEv
  virtual void  efg(); // _ZN3ccc8CC0x13y43efgEv
  ~CC0x13y4(); // tgen
  CC0x13y4(); // tgen
};
//SIG(1 _ZN3ccc8CC0x13y4E) C1{ BC2{ v2 v3 v1} BC3{ v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x13y4 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x13y43pqrEv");}
void  ccc::CC0x13y4 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x13y43abcEv");}
void  ccc::CC0x13y4 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x13y43efgEv");}
ccc::CC0x13y4 ::~CC0x13y4(){ note_dtor("_ZN3ccc8CC0x13y4E", this);} // tgen
ccc::CC0x13y4 ::CC0x13y4(){ note_ctor("_ZN3ccc8CC0x13y4E", this);} // tgen
}
static void Test__ZN3ccc8CC0x13y4E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x13y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x13y4E, buf);
    ::ccc::CC0x13y4 *dp, &lv = *(dp=new (buf) ::ccc::CC0x13y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x13y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x13y4E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x13y4E");
    check_base_class_offset(lv, (::ccc::BB13*), ABISELECT(8,4), "_ZN3ccc8CC0x13y4E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x13y4E);
    dp->::ccc::CC0x13y4::~CC0x13y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x13y4E(Test__ZN3ccc8CC0x13y4E, "_ZN3ccc8CC0x13y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x13y4C1Ev();
extern void _ZN3ccc8CC0x13y4D1Ev();
Name_Map name_map__ZN3ccc8CC0x13y4E[] = {
  NSPAIR(_ZN3ccc8CC0x13y4C1Ev),
  NSPAIR(_ZN3ccc8CC0x13y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB13E;
extern VTBL_ENTRY _ZTIN3ccc4BB13E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB13E[];
static Base_Class bases__ZN3ccc8CC0x13y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB13E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x13y4E[];
extern void _ZN3ccc8CC0x13y43abcEv();
extern void _ZN3ccc8CC0x13y43efgEv();
extern void _ZN3ccc8CC0x13y43pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x13y43efgEv,_ZThn4_N3ccc8CC0x13y43efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x13y4E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x13y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x13y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x13y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x13y43pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x13y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x13y43efgEv,_ZThn4_N3ccc8CC0x13y43efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x13y4E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x13y4E[];
Class_Descriptor cd__ZN3ccc8CC0x13y4E = {  "_ZN3ccc8CC0x13y4E", // class name
  bases__ZN3ccc8CC0x13y4E, 2,
  &(vtc__ZN3ccc8CC0x13y4E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x13y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x13y4E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x13y5  : ::ccc::AA0 , ::ccc::BB13 {
  virtual void  pqr(); // _ZN3ccc8CC0x13y53pqrEv
  virtual void  efg(); // _ZN3ccc8CC0x13y53efgEv
  virtual void  abc(); // _ZN3ccc8CC0x13y53abcEv
  ~CC0x13y5(); // tgen
  CC0x13y5(); // tgen
};
//SIG(1 _ZN3ccc8CC0x13y5E) C1{ BC2{ v3 v2 v1} BC3{ v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x13y5 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x13y53pqrEv");}
void  ccc::CC0x13y5 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x13y53efgEv");}
void  ccc::CC0x13y5 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x13y53abcEv");}
ccc::CC0x13y5 ::~CC0x13y5(){ note_dtor("_ZN3ccc8CC0x13y5E", this);} // tgen
ccc::CC0x13y5 ::CC0x13y5(){ note_ctor("_ZN3ccc8CC0x13y5E", this);} // tgen
}
static void Test__ZN3ccc8CC0x13y5E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x13y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x13y5E, buf);
    ::ccc::CC0x13y5 *dp, &lv = *(dp=new (buf) ::ccc::CC0x13y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x13y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x13y5E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x13y5E");
    check_base_class_offset(lv, (::ccc::BB13*), ABISELECT(8,4), "_ZN3ccc8CC0x13y5E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x13y5E);
    dp->::ccc::CC0x13y5::~CC0x13y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x13y5E(Test__ZN3ccc8CC0x13y5E, "_ZN3ccc8CC0x13y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x13y5C1Ev();
extern void _ZN3ccc8CC0x13y5D1Ev();
Name_Map name_map__ZN3ccc8CC0x13y5E[] = {
  NSPAIR(_ZN3ccc8CC0x13y5C1Ev),
  NSPAIR(_ZN3ccc8CC0x13y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB13E;
extern VTBL_ENTRY _ZTIN3ccc4BB13E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB13E[];
static Base_Class bases__ZN3ccc8CC0x13y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB13E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x13y5E[];
extern void _ZN3ccc8CC0x13y53abcEv();
extern void _ZN3ccc8CC0x13y53efgEv();
extern void _ZN3ccc8CC0x13y53pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x13y53efgEv,_ZThn4_N3ccc8CC0x13y53efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x13y5E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x13y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x13y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x13y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x13y53pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x13y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x13y53efgEv,_ZThn4_N3ccc8CC0x13y53efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x13y5E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x13y5E[];
Class_Descriptor cd__ZN3ccc8CC0x13y5E = {  "_ZN3ccc8CC0x13y5E", // class name
  bases__ZN3ccc8CC0x13y5E, 2,
  &(vtc__ZN3ccc8CC0x13y5E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x13y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x13y5E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x13y6  : ::ccc::AA0 , ::ccc::BB13 {
  virtual void  abc(); // _ZN3ccc8CC0x13y63abcEv
  virtual void  efg(); // _ZN3ccc8CC0x13y63efgEv
  ~CC0x13y6(); // tgen
  CC0x13y6(); // tgen
};
//SIG(1 _ZN3ccc8CC0x13y6E) C1{ BC2{ v1 v2 v3} BC3{ v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x13y6 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x13y63abcEv");}
void  ccc::CC0x13y6 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x13y63efgEv");}
ccc::CC0x13y6 ::~CC0x13y6(){ note_dtor("_ZN3ccc8CC0x13y6E", this);} // tgen
ccc::CC0x13y6 ::CC0x13y6(){ note_ctor("_ZN3ccc8CC0x13y6E", this);} // tgen
}
static void Test__ZN3ccc8CC0x13y6E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x13y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x13y6E, buf);
    ::ccc::CC0x13y6 *dp, &lv = *(dp=new (buf) ::ccc::CC0x13y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x13y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x13y6E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x13y6E");
    check_base_class_offset(lv, (::ccc::BB13*), ABISELECT(8,4), "_ZN3ccc8CC0x13y6E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x13y6E);
    dp->::ccc::CC0x13y6::~CC0x13y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x13y6E(Test__ZN3ccc8CC0x13y6E, "_ZN3ccc8CC0x13y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x13y6C1Ev();
extern void _ZN3ccc8CC0x13y6D1Ev();
Name_Map name_map__ZN3ccc8CC0x13y6E[] = {
  NSPAIR(_ZN3ccc8CC0x13y6C1Ev),
  NSPAIR(_ZN3ccc8CC0x13y6D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB13E;
extern VTBL_ENTRY _ZTIN3ccc4BB13E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB13E[];
static Base_Class bases__ZN3ccc8CC0x13y6E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB13E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x13y6E[];
extern void _ZN3ccc8CC0x13y63abcEv();
extern void _ZN3ccc8CC0x13y63efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x13y63efgEv,_ZThn4_N3ccc8CC0x13y63efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x13y6E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x13y6E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x13y63abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x13y63efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x13y6E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x13y63efgEv,_ZThn4_N3ccc8CC0x13y63efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x13y6E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x13y6E[];
Class_Descriptor cd__ZN3ccc8CC0x13y6E = {  "_ZN3ccc8CC0x13y6E", // class name
  bases__ZN3ccc8CC0x13y6E, 2,
  &(vtc__ZN3ccc8CC0x13y6E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x13y6E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x13y6E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x13y7  : ::ccc::AA0 , ::ccc::BB13 {
  virtual void  abc(); // _ZN3ccc8CC0x13y73abcEv
  virtual void  pqr(); // _ZN3ccc8CC0x13y73pqrEv
  ~CC0x13y7(); // tgen
  CC0x13y7(); // tgen
};
//SIG(1 _ZN3ccc8CC0x13y7E) C1{ BC2{ v1 v3 v2} BC3{ v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x13y7 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x13y73abcEv");}
void  ccc::CC0x13y7 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x13y73pqrEv");}
ccc::CC0x13y7 ::~CC0x13y7(){ note_dtor("_ZN3ccc8CC0x13y7E", this);} // tgen
ccc::CC0x13y7 ::CC0x13y7(){ note_ctor("_ZN3ccc8CC0x13y7E", this);} // tgen
}
static void Test__ZN3ccc8CC0x13y7E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x13y7E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x13y7E, buf);
    ::ccc::CC0x13y7 *dp, &lv = *(dp=new (buf) ::ccc::CC0x13y7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x13y7E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x13y7E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x13y7E");
    check_base_class_offset(lv, (::ccc::BB13*), ABISELECT(8,4), "_ZN3ccc8CC0x13y7E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x13y7E);
    dp->::ccc::CC0x13y7::~CC0x13y7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x13y7E(Test__ZN3ccc8CC0x13y7E, "_ZN3ccc8CC0x13y7E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x13y7C1Ev();
extern void _ZN3ccc8CC0x13y7D1Ev();
Name_Map name_map__ZN3ccc8CC0x13y7E[] = {
  NSPAIR(_ZN3ccc8CC0x13y7C1Ev),
  NSPAIR(_ZN3ccc8CC0x13y7D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB13E;
extern VTBL_ENTRY _ZTIN3ccc4BB13E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB13E[];
static Base_Class bases__ZN3ccc8CC0x13y7E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB13E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x13y7E[];
extern void _ZN3ccc8CC0x13y73abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc8CC0x13y73pqrEv();
extern void _ZN3ccc4BB133efgEv();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x13y7E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x13y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x13y73abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x13y73pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x13y7E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB133efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x13y7E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x13y7E[];
Class_Descriptor cd__ZN3ccc8CC0x13y7E = {  "_ZN3ccc8CC0x13y7E", // class name
  bases__ZN3ccc8CC0x13y7E, 2,
  &(vtc__ZN3ccc8CC0x13y7E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x13y7E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x13y7E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x13y8  : ::ccc::AA0 , ::ccc::BB13 {
  virtual void  efg(); // _ZN3ccc8CC0x13y83efgEv
  virtual void  abc(); // _ZN3ccc8CC0x13y83abcEv
  ~CC0x13y8(); // tgen
  CC0x13y8(); // tgen
};
//SIG(1 _ZN3ccc8CC0x13y8E) C1{ BC2{ v2 v1 v3} BC3{ v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x13y8 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x13y83efgEv");}
void  ccc::CC0x13y8 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x13y83abcEv");}
ccc::CC0x13y8 ::~CC0x13y8(){ note_dtor("_ZN3ccc8CC0x13y8E", this);} // tgen
ccc::CC0x13y8 ::CC0x13y8(){ note_ctor("_ZN3ccc8CC0x13y8E", this);} // tgen
}
static void Test__ZN3ccc8CC0x13y8E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x13y8E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x13y8E, buf);
    ::ccc::CC0x13y8 *dp, &lv = *(dp=new (buf) ::ccc::CC0x13y8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x13y8E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x13y8E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x13y8E");
    check_base_class_offset(lv, (::ccc::BB13*), ABISELECT(8,4), "_ZN3ccc8CC0x13y8E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x13y8E);
    dp->::ccc::CC0x13y8::~CC0x13y8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x13y8E(Test__ZN3ccc8CC0x13y8E, "_ZN3ccc8CC0x13y8E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x13y8C1Ev();
extern void _ZN3ccc8CC0x13y8D1Ev();
Name_Map name_map__ZN3ccc8CC0x13y8E[] = {
  NSPAIR(_ZN3ccc8CC0x13y8C1Ev),
  NSPAIR(_ZN3ccc8CC0x13y8D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB13E;
extern VTBL_ENTRY _ZTIN3ccc4BB13E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB13E[];
static Base_Class bases__ZN3ccc8CC0x13y8E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB13E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x13y8E[];
extern void _ZN3ccc8CC0x13y83abcEv();
extern void _ZN3ccc8CC0x13y83efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x13y83efgEv,_ZThn4_N3ccc8CC0x13y83efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x13y8E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x13y8E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x13y83abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x13y83efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x13y8E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x13y83efgEv,_ZThn4_N3ccc8CC0x13y83efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x13y8E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x13y8E[];
Class_Descriptor cd__ZN3ccc8CC0x13y8E = {  "_ZN3ccc8CC0x13y8E", // class name
  bases__ZN3ccc8CC0x13y8E, 2,
  &(vtc__ZN3ccc8CC0x13y8E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x13y8E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x13y8E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x13y9  : ::ccc::AA0 , ::ccc::BB13 {
  virtual void  efg(); // _ZN3ccc8CC0x13y93efgEv
  virtual void  pqr(); // _ZN3ccc8CC0x13y93pqrEv
  ~CC0x13y9(); // tgen
  CC0x13y9(); // tgen
};
//SIG(1 _ZN3ccc8CC0x13y9E) C1{ BC2{ v3 v1 v2} BC3{ v1} v1 v2}
}
namespace ccc { 
void  ccc::CC0x13y9 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x13y93efgEv");}
void  ccc::CC0x13y9 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x13y93pqrEv");}
ccc::CC0x13y9 ::~CC0x13y9(){ note_dtor("_ZN3ccc8CC0x13y9E", this);} // tgen
ccc::CC0x13y9 ::CC0x13y9(){ note_ctor("_ZN3ccc8CC0x13y9E", this);} // tgen
}
static void Test__ZN3ccc8CC0x13y9E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x13y9E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x13y9E, buf);
    ::ccc::CC0x13y9 *dp, &lv = *(dp=new (buf) ::ccc::CC0x13y9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x13y9E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x13y9E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x13y9E");
    check_base_class_offset(lv, (::ccc::BB13*), ABISELECT(8,4), "_ZN3ccc8CC0x13y9E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x13y9E);
    dp->::ccc::CC0x13y9::~CC0x13y9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x13y9E(Test__ZN3ccc8CC0x13y9E, "_ZN3ccc8CC0x13y9E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x13y9C1Ev();
extern void _ZN3ccc8CC0x13y9D1Ev();
Name_Map name_map__ZN3ccc8CC0x13y9E[] = {
  NSPAIR(_ZN3ccc8CC0x13y9C1Ev),
  NSPAIR(_ZN3ccc8CC0x13y9D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB13E;
extern VTBL_ENTRY _ZTIN3ccc4BB13E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB13E[];
static Base_Class bases__ZN3ccc8CC0x13y9E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB13E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x13y9E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc8CC0x13y93efgEv();
extern void _ZN3ccc8CC0x13y93pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x13y93efgEv,_ZThn4_N3ccc8CC0x13y93efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x13y9E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x13y9E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x13y93efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x13y93pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x13y9E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x13y93efgEv,_ZThn4_N3ccc8CC0x13y93efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x13y9E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x13y9E[];
Class_Descriptor cd__ZN3ccc8CC0x13y9E = {  "_ZN3ccc8CC0x13y9E", // class name
  bases__ZN3ccc8CC0x13y9E, 2,
  &(vtc__ZN3ccc8CC0x13y9E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x13y9E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x13y9E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x13y10  : ::ccc::AA0 , ::ccc::BB13 {
  virtual void  pqr(); // _ZN3ccc9CC0x13y103pqrEv
  virtual void  abc(); // _ZN3ccc9CC0x13y103abcEv
  ~CC0x13y10(); // tgen
  CC0x13y10(); // tgen
};
//SIG(1 _ZN3ccc9CC0x13y10E) C1{ BC2{ v2 v3 v1} BC3{ v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x13y10 ::pqr(){vfunc_called(this, "_ZN3ccc9CC0x13y103pqrEv");}
void  ccc::CC0x13y10 ::abc(){vfunc_called(this, "_ZN3ccc9CC0x13y103abcEv");}
ccc::CC0x13y10 ::~CC0x13y10(){ note_dtor("_ZN3ccc9CC0x13y10E", this);} // tgen
ccc::CC0x13y10 ::CC0x13y10(){ note_ctor("_ZN3ccc9CC0x13y10E", this);} // tgen
}
static void Test__ZN3ccc9CC0x13y10E()
{
  extern Class_Descriptor cd__ZN3ccc9CC0x13y10E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC0x13y10E, buf);
    ::ccc::CC0x13y10 *dp, &lv = *(dp=new (buf) ::ccc::CC0x13y10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC0x13y10E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC0x13y10E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc9CC0x13y10E");
    check_base_class_offset(lv, (::ccc::BB13*), ABISELECT(8,4), "_ZN3ccc9CC0x13y10E");
    test_class_info(&lv, &cd__ZN3ccc9CC0x13y10E);
    dp->::ccc::CC0x13y10::~CC0x13y10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC0x13y10E(Test__ZN3ccc9CC0x13y10E, "_ZN3ccc9CC0x13y10E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC0x13y10C1Ev();
extern void _ZN3ccc9CC0x13y10D1Ev();
Name_Map name_map__ZN3ccc9CC0x13y10E[] = {
  NSPAIR(_ZN3ccc9CC0x13y10C1Ev),
  NSPAIR(_ZN3ccc9CC0x13y10D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB13E;
extern VTBL_ENTRY _ZTIN3ccc4BB13E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB13E[];
static Base_Class bases__ZN3ccc9CC0x13y10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB13E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC0x13y10E[];
extern void _ZN3ccc9CC0x13y103abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc9CC0x13y103pqrEv();
extern void _ZN3ccc4BB133efgEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC0x13y10E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x13y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC0x13y103abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC0x13y103pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x13y10E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB133efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc9CC0x13y10E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC0x13y10E[];
Class_Descriptor cd__ZN3ccc9CC0x13y10E = {  "_ZN3ccc9CC0x13y10E", // class name
  bases__ZN3ccc9CC0x13y10E, 2,
  &(vtc__ZN3ccc9CC0x13y10E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC0x13y10E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC0x13y10E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x13y11  : ::ccc::AA0 , ::ccc::BB13 {
  virtual void  pqr(); // _ZN3ccc9CC0x13y113pqrEv
  virtual void  efg(); // _ZN3ccc9CC0x13y113efgEv
  ~CC0x13y11(); // tgen
  CC0x13y11(); // tgen
};
//SIG(1 _ZN3ccc9CC0x13y11E) C1{ BC2{ v3 v2 v1} BC3{ v2} v1 v2}
}
namespace ccc { 
void  ccc::CC0x13y11 ::pqr(){vfunc_called(this, "_ZN3ccc9CC0x13y113pqrEv");}
void  ccc::CC0x13y11 ::efg(){vfunc_called(this, "_ZN3ccc9CC0x13y113efgEv");}
ccc::CC0x13y11 ::~CC0x13y11(){ note_dtor("_ZN3ccc9CC0x13y11E", this);} // tgen
ccc::CC0x13y11 ::CC0x13y11(){ note_ctor("_ZN3ccc9CC0x13y11E", this);} // tgen
}
static void Test__ZN3ccc9CC0x13y11E()
{
  extern Class_Descriptor cd__ZN3ccc9CC0x13y11E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC0x13y11E, buf);
    ::ccc::CC0x13y11 *dp, &lv = *(dp=new (buf) ::ccc::CC0x13y11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC0x13y11E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC0x13y11E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc9CC0x13y11E");
    check_base_class_offset(lv, (::ccc::BB13*), ABISELECT(8,4), "_ZN3ccc9CC0x13y11E");
    test_class_info(&lv, &cd__ZN3ccc9CC0x13y11E);
    dp->::ccc::CC0x13y11::~CC0x13y11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC0x13y11E(Test__ZN3ccc9CC0x13y11E, "_ZN3ccc9CC0x13y11E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC0x13y11C1Ev();
extern void _ZN3ccc9CC0x13y11D1Ev();
Name_Map name_map__ZN3ccc9CC0x13y11E[] = {
  NSPAIR(_ZN3ccc9CC0x13y11C1Ev),
  NSPAIR(_ZN3ccc9CC0x13y11D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB13E;
extern VTBL_ENTRY _ZTIN3ccc4BB13E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB13E[];
static Base_Class bases__ZN3ccc9CC0x13y11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB13E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC0x13y11E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc9CC0x13y113efgEv();
extern void _ZN3ccc9CC0x13y113pqrEv();
extern void ABISELECT(_ZThn8_N3ccc9CC0x13y113efgEv,_ZThn4_N3ccc9CC0x13y113efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc9CC0x13y11E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x13y11E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC0x13y113efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC0x13y113pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x13y11E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc9CC0x13y113efgEv,_ZThn4_N3ccc9CC0x13y113efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc9CC0x13y11E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC0x13y11E[];
Class_Descriptor cd__ZN3ccc9CC0x13y11E = {  "_ZN3ccc9CC0x13y11E", // class name
  bases__ZN3ccc9CC0x13y11E, 2,
  &(vtc__ZN3ccc9CC0x13y11E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC0x13y11E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC0x13y11E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x13y12  : ::ccc::AA0 , ::ccc::BB13 {
  virtual void  abc(); // _ZN3ccc9CC0x13y123abcEv
  ~CC0x13y12(); // tgen
  CC0x13y12(); // tgen
};
//SIG(1 _ZN3ccc9CC0x13y12E) C1{ BC2{ v1 v2 v3} BC3{ v4} v1}
}
namespace ccc { 
void  ccc::CC0x13y12 ::abc(){vfunc_called(this, "_ZN3ccc9CC0x13y123abcEv");}
ccc::CC0x13y12 ::~CC0x13y12(){ note_dtor("_ZN3ccc9CC0x13y12E", this);} // tgen
ccc::CC0x13y12 ::CC0x13y12(){ note_ctor("_ZN3ccc9CC0x13y12E", this);} // tgen
}
static void Test__ZN3ccc9CC0x13y12E()
{
  extern Class_Descriptor cd__ZN3ccc9CC0x13y12E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC0x13y12E, buf);
    ::ccc::CC0x13y12 *dp, &lv = *(dp=new (buf) ::ccc::CC0x13y12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC0x13y12E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC0x13y12E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc9CC0x13y12E");
    check_base_class_offset(lv, (::ccc::BB13*), ABISELECT(8,4), "_ZN3ccc9CC0x13y12E");
    test_class_info(&lv, &cd__ZN3ccc9CC0x13y12E);
    dp->::ccc::CC0x13y12::~CC0x13y12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC0x13y12E(Test__ZN3ccc9CC0x13y12E, "_ZN3ccc9CC0x13y12E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC0x13y12C1Ev();
extern void _ZN3ccc9CC0x13y12D1Ev();
Name_Map name_map__ZN3ccc9CC0x13y12E[] = {
  NSPAIR(_ZN3ccc9CC0x13y12C1Ev),
  NSPAIR(_ZN3ccc9CC0x13y12D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB13E;
extern VTBL_ENTRY _ZTIN3ccc4BB13E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB13E[];
static Base_Class bases__ZN3ccc9CC0x13y12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB13E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC0x13y12E[];
extern void _ZN3ccc9CC0x13y123abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc4BB133efgEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC0x13y12E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x13y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc9CC0x13y123abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x13y12E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB133efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc9CC0x13y12E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC0x13y12E[];
Class_Descriptor cd__ZN3ccc9CC0x13y12E = {  "_ZN3ccc9CC0x13y12E", // class name
  bases__ZN3ccc9CC0x13y12E, 2,
  &(vtc__ZN3ccc9CC0x13y12E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC0x13y12E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC0x13y12E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x13y13  : ::ccc::AA0 , ::ccc::BB13 {
  virtual void  efg(); // _ZN3ccc9CC0x13y133efgEv
  ~CC0x13y13(); // tgen
  CC0x13y13(); // tgen
};
//SIG(1 _ZN3ccc9CC0x13y13E) C1{ BC2{ v2 v1 v3} BC3{ v1} v1}
}
namespace ccc { 
void  ccc::CC0x13y13 ::efg(){vfunc_called(this, "_ZN3ccc9CC0x13y133efgEv");}
ccc::CC0x13y13 ::~CC0x13y13(){ note_dtor("_ZN3ccc9CC0x13y13E", this);} // tgen
ccc::CC0x13y13 ::CC0x13y13(){ note_ctor("_ZN3ccc9CC0x13y13E", this);} // tgen
}
static void Test__ZN3ccc9CC0x13y13E()
{
  extern Class_Descriptor cd__ZN3ccc9CC0x13y13E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC0x13y13E, buf);
    ::ccc::CC0x13y13 *dp, &lv = *(dp=new (buf) ::ccc::CC0x13y13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC0x13y13E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC0x13y13E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc9CC0x13y13E");
    check_base_class_offset(lv, (::ccc::BB13*), ABISELECT(8,4), "_ZN3ccc9CC0x13y13E");
    test_class_info(&lv, &cd__ZN3ccc9CC0x13y13E);
    dp->::ccc::CC0x13y13::~CC0x13y13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC0x13y13E(Test__ZN3ccc9CC0x13y13E, "_ZN3ccc9CC0x13y13E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC0x13y13C1Ev();
extern void _ZN3ccc9CC0x13y13D1Ev();
Name_Map name_map__ZN3ccc9CC0x13y13E[] = {
  NSPAIR(_ZN3ccc9CC0x13y13C1Ev),
  NSPAIR(_ZN3ccc9CC0x13y13D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB13E;
extern VTBL_ENTRY _ZTIN3ccc4BB13E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB13E[];
static Base_Class bases__ZN3ccc9CC0x13y13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB13E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC0x13y13E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc9CC0x13y133efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc9CC0x13y133efgEv,_ZThn4_N3ccc9CC0x13y133efgEv)();
static  VTBL_ENTRY vtc__ZN3ccc9CC0x13y13E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x13y13E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc9CC0x13y133efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x13y13E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc9CC0x13y133efgEv,_ZThn4_N3ccc9CC0x13y133efgEv),
};
extern VTBL_ENTRY _ZTIN3ccc9CC0x13y13E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC0x13y13E[];
Class_Descriptor cd__ZN3ccc9CC0x13y13E = {  "_ZN3ccc9CC0x13y13E", // class name
  bases__ZN3ccc9CC0x13y13E, 2,
  &(vtc__ZN3ccc9CC0x13y13E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC0x13y13E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC0x13y13E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x13y14  : ::ccc::AA0 , ::ccc::BB13 {
  virtual void  pqr(); // _ZN3ccc9CC0x13y143pqrEv
  ~CC0x13y14(); // tgen
  CC0x13y14(); // tgen
};
//SIG(1 _ZN3ccc9CC0x13y14E) C1{ BC2{ v2 v3 v1} BC3{ v4} v1}
}
namespace ccc { 
void  ccc::CC0x13y14 ::pqr(){vfunc_called(this, "_ZN3ccc9CC0x13y143pqrEv");}
ccc::CC0x13y14 ::~CC0x13y14(){ note_dtor("_ZN3ccc9CC0x13y14E", this);} // tgen
ccc::CC0x13y14 ::CC0x13y14(){ note_ctor("_ZN3ccc9CC0x13y14E", this);} // tgen
}
static void Test__ZN3ccc9CC0x13y14E()
{
  extern Class_Descriptor cd__ZN3ccc9CC0x13y14E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC0x13y14E, buf);
    ::ccc::CC0x13y14 *dp, &lv = *(dp=new (buf) ::ccc::CC0x13y14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC0x13y14E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC0x13y14E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc9CC0x13y14E");
    check_base_class_offset(lv, (::ccc::BB13*), ABISELECT(8,4), "_ZN3ccc9CC0x13y14E");
    test_class_info(&lv, &cd__ZN3ccc9CC0x13y14E);
    dp->::ccc::CC0x13y14::~CC0x13y14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC0x13y14E(Test__ZN3ccc9CC0x13y14E, "_ZN3ccc9CC0x13y14E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC0x13y14C1Ev();
extern void _ZN3ccc9CC0x13y14D1Ev();
Name_Map name_map__ZN3ccc9CC0x13y14E[] = {
  NSPAIR(_ZN3ccc9CC0x13y14C1Ev),
  NSPAIR(_ZN3ccc9CC0x13y14D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB13E;
extern VTBL_ENTRY _ZTIN3ccc4BB13E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB13E[];
static Base_Class bases__ZN3ccc9CC0x13y14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB13E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC0x13y14E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc9CC0x13y143pqrEv();
extern void _ZN3ccc4BB133efgEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC0x13y14E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x13y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc9CC0x13y143pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x13y14E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB133efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc9CC0x13y14E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC0x13y14E[];
Class_Descriptor cd__ZN3ccc9CC0x13y14E = {  "_ZN3ccc9CC0x13y14E", // class name
  bases__ZN3ccc9CC0x13y14E, 2,
  &(vtc__ZN3ccc9CC0x13y14E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC0x13y14E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC0x13y14E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x13y15  : ::ccc::AA0 , ::ccc::BB13 {
  ~CC0x13y15(); // tgen
  CC0x13y15(); // tgen
};
//SIG(1 _ZN3ccc9CC0x13y15E) C1{ BC2{ v1 v2 v3} BC3{ v4}}
}
namespace ccc { 
ccc::CC0x13y15 ::~CC0x13y15(){ note_dtor("_ZN3ccc9CC0x13y15E", this);} // tgen
ccc::CC0x13y15 ::CC0x13y15(){ note_ctor("_ZN3ccc9CC0x13y15E", this);} // tgen
}
static void Test__ZN3ccc9CC0x13y15E()
{
  extern Class_Descriptor cd__ZN3ccc9CC0x13y15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc9CC0x13y15E, buf);
    ::ccc::CC0x13y15 *dp, &lv = *(dp=new (buf) ::ccc::CC0x13y15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc9CC0x13y15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc9CC0x13y15E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc9CC0x13y15E");
    check_base_class_offset(lv, (::ccc::BB13*), ABISELECT(8,4), "_ZN3ccc9CC0x13y15E");
    test_class_info(&lv, &cd__ZN3ccc9CC0x13y15E);
    dp->::ccc::CC0x13y15::~CC0x13y15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc9CC0x13y15E(Test__ZN3ccc9CC0x13y15E, "_ZN3ccc9CC0x13y15E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc9CC0x13y15C1Ev();
extern void _ZN3ccc9CC0x13y15D1Ev();
Name_Map name_map__ZN3ccc9CC0x13y15E[] = {
  NSPAIR(_ZN3ccc9CC0x13y15C1Ev),
  NSPAIR(_ZN3ccc9CC0x13y15D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB13E;
extern VTBL_ENTRY _ZTIN3ccc4BB13E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB13E[];
static Base_Class bases__ZN3ccc9CC0x13y15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    0, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB13E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc9CC0x13y15E[];
extern void _ZN3ccc3AA03abcEv();
extern void _ZN3ccc3AA03efgEv();
extern void _ZN3ccc3AA03pqrEv();
extern void _ZN3ccc4BB133efgEv();
static  VTBL_ENTRY vtc__ZN3ccc9CC0x13y15E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x13y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc3AA03abcEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03efgEv,
  (VTBL_ENTRY)&_ZN3ccc3AA03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc9CC0x13y15E[0]),
  (VTBL_ENTRY)&_ZN3ccc4BB133efgEv,
};
extern VTBL_ENTRY _ZTIN3ccc9CC0x13y15E[];
extern  VTBL_ENTRY _ZTVN3ccc9CC0x13y15E[];
Class_Descriptor cd__ZN3ccc9CC0x13y15E = {  "_ZN3ccc9CC0x13y15E", // class name
  bases__ZN3ccc9CC0x13y15E, 2,
  &(vtc__ZN3ccc9CC0x13y15E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc9CC0x13y15E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc9CC0x13y15E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x14y0  : ::ccc::AA0 , ::ccc::BB14 {
  virtual void  abc(); // _ZN3ccc8CC0x14y03abcEv
  virtual void  efg(); // _ZN3ccc8CC0x14y03efgEv
  virtual void  pqr(); // _ZN3ccc8CC0x14y03pqrEv
  ~CC0x14y0(); // tgen
  CC0x14y0(); // tgen
};
//SIG(1 _ZN3ccc8CC0x14y0E) C1{ BC2{ v1 v2 v3} BC3{ v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x14y0 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x14y03abcEv");}
void  ccc::CC0x14y0 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x14y03efgEv");}
void  ccc::CC0x14y0 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x14y03pqrEv");}
ccc::CC0x14y0 ::~CC0x14y0(){ note_dtor("_ZN3ccc8CC0x14y0E", this);} // tgen
ccc::CC0x14y0 ::CC0x14y0(){ note_ctor("_ZN3ccc8CC0x14y0E", this);} // tgen
}
static void Test__ZN3ccc8CC0x14y0E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x14y0E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x14y0E, buf);
    ::ccc::CC0x14y0 *dp, &lv = *(dp=new (buf) ::ccc::CC0x14y0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x14y0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x14y0E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x14y0E");
    check_base_class_offset(lv, (::ccc::BB14*), ABISELECT(8,4), "_ZN3ccc8CC0x14y0E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x14y0E);
    dp->::ccc::CC0x14y0::~CC0x14y0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x14y0E(Test__ZN3ccc8CC0x14y0E, "_ZN3ccc8CC0x14y0E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x14y0C1Ev();
extern void _ZN3ccc8CC0x14y0D1Ev();
Name_Map name_map__ZN3ccc8CC0x14y0E[] = {
  NSPAIR(_ZN3ccc8CC0x14y0C1Ev),
  NSPAIR(_ZN3ccc8CC0x14y0D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB14E;
extern VTBL_ENTRY _ZTIN3ccc4BB14E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB14E[];
static Base_Class bases__ZN3ccc8CC0x14y0E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB14E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x14y0E[];
extern void _ZN3ccc8CC0x14y03abcEv();
extern void _ZN3ccc8CC0x14y03efgEv();
extern void _ZN3ccc8CC0x14y03pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x14y03pqrEv,_ZThn4_N3ccc8CC0x14y03pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x14y0E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x14y0E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x14y03abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x14y03efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x14y03pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x14y0E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x14y03pqrEv,_ZThn4_N3ccc8CC0x14y03pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x14y0E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x14y0E[];
Class_Descriptor cd__ZN3ccc8CC0x14y0E = {  "_ZN3ccc8CC0x14y0E", // class name
  bases__ZN3ccc8CC0x14y0E, 2,
  &(vtc__ZN3ccc8CC0x14y0E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x14y0E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x14y0E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x14y1  : ::ccc::AA0 , ::ccc::BB14 {
  virtual void  abc(); // _ZN3ccc8CC0x14y13abcEv
  virtual void  pqr(); // _ZN3ccc8CC0x14y13pqrEv
  virtual void  efg(); // _ZN3ccc8CC0x14y13efgEv
  ~CC0x14y1(); // tgen
  CC0x14y1(); // tgen
};
//SIG(1 _ZN3ccc8CC0x14y1E) C1{ BC2{ v1 v3 v2} BC3{ v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x14y1 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x14y13abcEv");}
void  ccc::CC0x14y1 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x14y13pqrEv");}
void  ccc::CC0x14y1 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x14y13efgEv");}
ccc::CC0x14y1 ::~CC0x14y1(){ note_dtor("_ZN3ccc8CC0x14y1E", this);} // tgen
ccc::CC0x14y1 ::CC0x14y1(){ note_ctor("_ZN3ccc8CC0x14y1E", this);} // tgen
}
static void Test__ZN3ccc8CC0x14y1E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x14y1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x14y1E, buf);
    ::ccc::CC0x14y1 *dp, &lv = *(dp=new (buf) ::ccc::CC0x14y1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x14y1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x14y1E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x14y1E");
    check_base_class_offset(lv, (::ccc::BB14*), ABISELECT(8,4), "_ZN3ccc8CC0x14y1E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x14y1E);
    dp->::ccc::CC0x14y1::~CC0x14y1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x14y1E(Test__ZN3ccc8CC0x14y1E, "_ZN3ccc8CC0x14y1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x14y1C1Ev();
extern void _ZN3ccc8CC0x14y1D1Ev();
Name_Map name_map__ZN3ccc8CC0x14y1E[] = {
  NSPAIR(_ZN3ccc8CC0x14y1C1Ev),
  NSPAIR(_ZN3ccc8CC0x14y1D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB14E;
extern VTBL_ENTRY _ZTIN3ccc4BB14E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB14E[];
static Base_Class bases__ZN3ccc8CC0x14y1E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB14E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x14y1E[];
extern void _ZN3ccc8CC0x14y13abcEv();
extern void _ZN3ccc8CC0x14y13efgEv();
extern void _ZN3ccc8CC0x14y13pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x14y13pqrEv,_ZThn4_N3ccc8CC0x14y13pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x14y1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x14y1E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x14y13abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x14y13efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x14y13pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x14y1E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x14y13pqrEv,_ZThn4_N3ccc8CC0x14y13pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x14y1E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x14y1E[];
Class_Descriptor cd__ZN3ccc8CC0x14y1E = {  "_ZN3ccc8CC0x14y1E", // class name
  bases__ZN3ccc8CC0x14y1E, 2,
  &(vtc__ZN3ccc8CC0x14y1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x14y1E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x14y1E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x14y2  : ::ccc::AA0 , ::ccc::BB14 {
  virtual void  efg(); // _ZN3ccc8CC0x14y23efgEv
  virtual void  abc(); // _ZN3ccc8CC0x14y23abcEv
  virtual void  pqr(); // _ZN3ccc8CC0x14y23pqrEv
  ~CC0x14y2(); // tgen
  CC0x14y2(); // tgen
};
//SIG(1 _ZN3ccc8CC0x14y2E) C1{ BC2{ v2 v1 v3} BC3{ v3} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x14y2 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x14y23efgEv");}
void  ccc::CC0x14y2 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x14y23abcEv");}
void  ccc::CC0x14y2 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x14y23pqrEv");}
ccc::CC0x14y2 ::~CC0x14y2(){ note_dtor("_ZN3ccc8CC0x14y2E", this);} // tgen
ccc::CC0x14y2 ::CC0x14y2(){ note_ctor("_ZN3ccc8CC0x14y2E", this);} // tgen
}
static void Test__ZN3ccc8CC0x14y2E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x14y2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x14y2E, buf);
    ::ccc::CC0x14y2 *dp, &lv = *(dp=new (buf) ::ccc::CC0x14y2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x14y2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x14y2E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x14y2E");
    check_base_class_offset(lv, (::ccc::BB14*), ABISELECT(8,4), "_ZN3ccc8CC0x14y2E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x14y2E);
    dp->::ccc::CC0x14y2::~CC0x14y2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x14y2E(Test__ZN3ccc8CC0x14y2E, "_ZN3ccc8CC0x14y2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x14y2C1Ev();
extern void _ZN3ccc8CC0x14y2D1Ev();
Name_Map name_map__ZN3ccc8CC0x14y2E[] = {
  NSPAIR(_ZN3ccc8CC0x14y2C1Ev),
  NSPAIR(_ZN3ccc8CC0x14y2D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB14E;
extern VTBL_ENTRY _ZTIN3ccc4BB14E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB14E[];
static Base_Class bases__ZN3ccc8CC0x14y2E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB14E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x14y2E[];
extern void _ZN3ccc8CC0x14y23abcEv();
extern void _ZN3ccc8CC0x14y23efgEv();
extern void _ZN3ccc8CC0x14y23pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x14y23pqrEv,_ZThn4_N3ccc8CC0x14y23pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x14y2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x14y2E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x14y23abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x14y23efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x14y23pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x14y2E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x14y23pqrEv,_ZThn4_N3ccc8CC0x14y23pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x14y2E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x14y2E[];
Class_Descriptor cd__ZN3ccc8CC0x14y2E = {  "_ZN3ccc8CC0x14y2E", // class name
  bases__ZN3ccc8CC0x14y2E, 2,
  &(vtc__ZN3ccc8CC0x14y2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x14y2E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x14y2E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x14y3  : ::ccc::AA0 , ::ccc::BB14 {
  virtual void  efg(); // _ZN3ccc8CC0x14y33efgEv
  virtual void  pqr(); // _ZN3ccc8CC0x14y33pqrEv
  virtual void  abc(); // _ZN3ccc8CC0x14y33abcEv
  ~CC0x14y3(); // tgen
  CC0x14y3(); // tgen
};
//SIG(1 _ZN3ccc8CC0x14y3E) C1{ BC2{ v3 v1 v2} BC3{ v2} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x14y3 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x14y33efgEv");}
void  ccc::CC0x14y3 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x14y33pqrEv");}
void  ccc::CC0x14y3 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x14y33abcEv");}
ccc::CC0x14y3 ::~CC0x14y3(){ note_dtor("_ZN3ccc8CC0x14y3E", this);} // tgen
ccc::CC0x14y3 ::CC0x14y3(){ note_ctor("_ZN3ccc8CC0x14y3E", this);} // tgen
}
static void Test__ZN3ccc8CC0x14y3E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x14y3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x14y3E, buf);
    ::ccc::CC0x14y3 *dp, &lv = *(dp=new (buf) ::ccc::CC0x14y3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x14y3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x14y3E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x14y3E");
    check_base_class_offset(lv, (::ccc::BB14*), ABISELECT(8,4), "_ZN3ccc8CC0x14y3E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x14y3E);
    dp->::ccc::CC0x14y3::~CC0x14y3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x14y3E(Test__ZN3ccc8CC0x14y3E, "_ZN3ccc8CC0x14y3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x14y3C1Ev();
extern void _ZN3ccc8CC0x14y3D1Ev();
Name_Map name_map__ZN3ccc8CC0x14y3E[] = {
  NSPAIR(_ZN3ccc8CC0x14y3C1Ev),
  NSPAIR(_ZN3ccc8CC0x14y3D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB14E;
extern VTBL_ENTRY _ZTIN3ccc4BB14E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB14E[];
static Base_Class bases__ZN3ccc8CC0x14y3E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB14E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x14y3E[];
extern void _ZN3ccc8CC0x14y33abcEv();
extern void _ZN3ccc8CC0x14y33efgEv();
extern void _ZN3ccc8CC0x14y33pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x14y33pqrEv,_ZThn4_N3ccc8CC0x14y33pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x14y3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x14y3E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x14y33abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x14y33efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x14y33pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x14y3E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x14y33pqrEv,_ZThn4_N3ccc8CC0x14y33pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x14y3E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x14y3E[];
Class_Descriptor cd__ZN3ccc8CC0x14y3E = {  "_ZN3ccc8CC0x14y3E", // class name
  bases__ZN3ccc8CC0x14y3E, 2,
  &(vtc__ZN3ccc8CC0x14y3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x14y3E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x14y3E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x14y4  : ::ccc::AA0 , ::ccc::BB14 {
  virtual void  pqr(); // _ZN3ccc8CC0x14y43pqrEv
  virtual void  abc(); // _ZN3ccc8CC0x14y43abcEv
  virtual void  efg(); // _ZN3ccc8CC0x14y43efgEv
  ~CC0x14y4(); // tgen
  CC0x14y4(); // tgen
};
//SIG(1 _ZN3ccc8CC0x14y4E) C1{ BC2{ v2 v3 v1} BC3{ v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x14y4 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x14y43pqrEv");}
void  ccc::CC0x14y4 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x14y43abcEv");}
void  ccc::CC0x14y4 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x14y43efgEv");}
ccc::CC0x14y4 ::~CC0x14y4(){ note_dtor("_ZN3ccc8CC0x14y4E", this);} // tgen
ccc::CC0x14y4 ::CC0x14y4(){ note_ctor("_ZN3ccc8CC0x14y4E", this);} // tgen
}
static void Test__ZN3ccc8CC0x14y4E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x14y4E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x14y4E, buf);
    ::ccc::CC0x14y4 *dp, &lv = *(dp=new (buf) ::ccc::CC0x14y4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x14y4E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x14y4E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x14y4E");
    check_base_class_offset(lv, (::ccc::BB14*), ABISELECT(8,4), "_ZN3ccc8CC0x14y4E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x14y4E);
    dp->::ccc::CC0x14y4::~CC0x14y4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x14y4E(Test__ZN3ccc8CC0x14y4E, "_ZN3ccc8CC0x14y4E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x14y4C1Ev();
extern void _ZN3ccc8CC0x14y4D1Ev();
Name_Map name_map__ZN3ccc8CC0x14y4E[] = {
  NSPAIR(_ZN3ccc8CC0x14y4C1Ev),
  NSPAIR(_ZN3ccc8CC0x14y4D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB14E;
extern VTBL_ENTRY _ZTIN3ccc4BB14E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB14E[];
static Base_Class bases__ZN3ccc8CC0x14y4E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB14E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x14y4E[];
extern void _ZN3ccc8CC0x14y43abcEv();
extern void _ZN3ccc8CC0x14y43efgEv();
extern void _ZN3ccc8CC0x14y43pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x14y43pqrEv,_ZThn4_N3ccc8CC0x14y43pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x14y4E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x14y4E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x14y43abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x14y43efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x14y43pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x14y4E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x14y43pqrEv,_ZThn4_N3ccc8CC0x14y43pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x14y4E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x14y4E[];
Class_Descriptor cd__ZN3ccc8CC0x14y4E = {  "_ZN3ccc8CC0x14y4E", // class name
  bases__ZN3ccc8CC0x14y4E, 2,
  &(vtc__ZN3ccc8CC0x14y4E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x14y4E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x14y4E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x14y5  : ::ccc::AA0 , ::ccc::BB14 {
  virtual void  pqr(); // _ZN3ccc8CC0x14y53pqrEv
  virtual void  efg(); // _ZN3ccc8CC0x14y53efgEv
  virtual void  abc(); // _ZN3ccc8CC0x14y53abcEv
  ~CC0x14y5(); // tgen
  CC0x14y5(); // tgen
};
//SIG(1 _ZN3ccc8CC0x14y5E) C1{ BC2{ v3 v2 v1} BC3{ v1} v1 v2 v3}
}
namespace ccc { 
void  ccc::CC0x14y5 ::pqr(){vfunc_called(this, "_ZN3ccc8CC0x14y53pqrEv");}
void  ccc::CC0x14y5 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x14y53efgEv");}
void  ccc::CC0x14y5 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x14y53abcEv");}
ccc::CC0x14y5 ::~CC0x14y5(){ note_dtor("_ZN3ccc8CC0x14y5E", this);} // tgen
ccc::CC0x14y5 ::CC0x14y5(){ note_ctor("_ZN3ccc8CC0x14y5E", this);} // tgen
}
static void Test__ZN3ccc8CC0x14y5E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x14y5E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x14y5E, buf);
    ::ccc::CC0x14y5 *dp, &lv = *(dp=new (buf) ::ccc::CC0x14y5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x14y5E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x14y5E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x14y5E");
    check_base_class_offset(lv, (::ccc::BB14*), ABISELECT(8,4), "_ZN3ccc8CC0x14y5E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x14y5E);
    dp->::ccc::CC0x14y5::~CC0x14y5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x14y5E(Test__ZN3ccc8CC0x14y5E, "_ZN3ccc8CC0x14y5E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x14y5C1Ev();
extern void _ZN3ccc8CC0x14y5D1Ev();
Name_Map name_map__ZN3ccc8CC0x14y5E[] = {
  NSPAIR(_ZN3ccc8CC0x14y5C1Ev),
  NSPAIR(_ZN3ccc8CC0x14y5D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3ccc3AA0E;
extern VTBL_ENTRY _ZTIN3ccc3AA0E[];
extern  VTBL_ENTRY _ZTVN3ccc3AA0E[];
extern Class_Descriptor cd__ZN3ccc4BB14E;
extern VTBL_ENTRY _ZTIN3ccc4BB14E[];
extern  VTBL_ENTRY _ZTVN3ccc4BB14E[];
static Base_Class bases__ZN3ccc8CC0x14y5E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3ccc3AA0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3ccc4BB14E,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3ccc8CC0x14y5E[];
extern void _ZN3ccc8CC0x14y53abcEv();
extern void _ZN3ccc8CC0x14y53efgEv();
extern void _ZN3ccc8CC0x14y53pqrEv();
extern void ABISELECT(_ZThn8_N3ccc8CC0x14y53pqrEv,_ZThn4_N3ccc8CC0x14y53pqrEv)();
static  VTBL_ENTRY vtc__ZN3ccc8CC0x14y5E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x14y5E[0]),
  (VTBL_ENTRY)&_ZN3ccc8CC0x14y53abcEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x14y53efgEv,
  (VTBL_ENTRY)&_ZN3ccc8CC0x14y53pqrEv,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTIN3ccc8CC0x14y5E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N3ccc8CC0x14y53pqrEv,_ZThn4_N3ccc8CC0x14y53pqrEv),
};
extern VTBL_ENTRY _ZTIN3ccc8CC0x14y5E[];
extern  VTBL_ENTRY _ZTVN3ccc8CC0x14y5E[];
Class_Descriptor cd__ZN3ccc8CC0x14y5E = {  "_ZN3ccc8CC0x14y5E", // class name
  bases__ZN3ccc8CC0x14y5E, 2,
  &(vtc__ZN3ccc8CC0x14y5E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3ccc8CC0x14y5E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3ccc8CC0x14y5E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace ccc { 
struct  CC0x14y6  : ::ccc::AA0 , ::ccc::BB14 {
  virtual void  abc(); // _ZN3ccc8CC0x14y63abcEv
  virtual void  efg(); // _ZN3ccc8CC0x14y63efgEv
  ~CC0x14y6(); // tgen
  CC0x14y6(); // tgen
};
//SIG(1 _ZN3ccc8CC0x14y6E) C1{ BC2{ v1 v2 v3} BC3{ v4} v1 v2}
}
namespace ccc { 
void  ccc::CC0x14y6 ::abc(){vfunc_called(this, "_ZN3ccc8CC0x14y63abcEv");}
void  ccc::CC0x14y6 ::efg(){vfunc_called(this, "_ZN3ccc8CC0x14y63efgEv");}
ccc::CC0x14y6 ::~CC0x14y6(){ note_dtor("_ZN3ccc8CC0x14y6E", this);} // tgen
ccc::CC0x14y6 ::CC0x14y6(){ note_ctor("_ZN3ccc8CC0x14y6E", this);} // tgen
}
static void Test__ZN3ccc8CC0x14y6E()
{
  extern Class_Descriptor cd__ZN3ccc8CC0x14y6E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3ccc8CC0x14y6E, buf);
    ::ccc::CC0x14y6 *dp, &lv = *(dp=new (buf) ::ccc::CC0x14y6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3ccc8CC0x14y6E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3ccc8CC0x14y6E)");
    check_base_class_offset(lv, (::ccc::AA0*), 0, "_ZN3ccc8CC0x14y6E");
    check_base_class_offset(lv, (::ccc::BB14*), ABISELECT(8,4), "_ZN3ccc8CC0x14y6E");
    test_class_info(&lv, &cd__ZN3ccc8CC0x14y6E);
    dp->::ccc::CC0x14y6::~CC0x14y6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3ccc8CC0x14y6E(Test__ZN3ccc8CC0x14y6E, "_ZN3ccc8CC0x14y6E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3ccc8CC0x14y6C1Ev();
extern void _ZN3ccc8CC0x14y6D1Ev();
Name_Map name_map__ZN3ccc8CC0x14y6E[] = {
  NSPAIR(_ZN3ccc8CC0x14y6C1Ev),
  NSPAIR(_ZN3ccc8CC0x14y6D1