// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus
namespace aaa { 
struct  AA1  {
  int pa;
  virtual void  foo(); // _ZN3aaa3AA13fooEv
  ~AA1(); // tgen
  AA1(); // tgen
};
//SIG(-1 _ZN3aaa3AA1E) C1{ v1 Fi}
}
namespace aaa { 
void  aaa::AA1 ::foo(){vfunc_called(this, "_ZN3aaa3AA13fooEv");}
aaa::AA1 ::~AA1(){ note_dtor("_ZN3aaa3AA1E", this);} // tgen
aaa::AA1 ::AA1(){ note_ctor("_ZN3aaa3AA1E", this);} // tgen
}
static void Test__ZN3aaa3AA1E()
{
  extern Class_Descriptor cd__ZN3aaa3AA1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3aaa3AA1E, buf);
    ::aaa::AA1 *dp, &lv = *(dp=new (buf) ::aaa::AA1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3aaa3AA1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa3AA1E)");
    check_field_offset(lv, pa, ABISELECT(8,4), "_ZN3aaa3AA1E.pa");
    test_class_info(&lv, &cd__ZN3aaa3AA1E);
    dp->::aaa::AA1::~AA1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa3AA1E(Test__ZN3aaa3AA1E, "_ZN3aaa3AA1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aaa3AA1C1Ev();
extern void _ZN3aaa3AA1D1Ev();
Name_Map name_map__ZN3aaa3AA1E[] = {
  NSPAIR(_ZN3aaa3AA1C1Ev),
  NSPAIR(_ZN3aaa3AA1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern void _ZN3aaa3AA13fooEv();
static  VTBL_ENTRY vtc__ZN3aaa3AA1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa3AA1E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA13fooEv,
};
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
Class_Descriptor cd__ZN3aaa3AA1E = {  "_ZN3aaa3AA1E", // class name
  0,0,//no base classes
  &(vtc__ZN3aaa3AA1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3aaa3AA1E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3aaa3AA1E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  BB1  {
  int pb;
  virtual void  foo(); // _ZN3aaa3BB13fooEv
  ~BB1(); // tgen
  BB1(); // tgen
};
//SIG(-1 _ZN3aaa3BB1E) C1{ v1 Fi}
}
namespace aaa { 
void  aaa::BB1 ::foo(){vfunc_called(this, "_ZN3aaa3BB13fooEv");}
aaa::BB1 ::~BB1(){ note_dtor("_ZN3aaa3BB1E", this);} // tgen
aaa::BB1 ::BB1(){ note_ctor("_ZN3aaa3BB1E", this);} // tgen
}
static void Test__ZN3aaa3BB1E()
{
  extern Class_Descriptor cd__ZN3aaa3BB1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3aaa3BB1E, buf);
    ::aaa::BB1 *dp, &lv = *(dp=new (buf) ::aaa::BB1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3aaa3BB1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa3BB1E)");
    check_field_offset(lv, pb, ABISELECT(8,4), "_ZN3aaa3BB1E.pb");
    test_class_info(&lv, &cd__ZN3aaa3BB1E);
    dp->::aaa::BB1::~BB1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa3BB1E(Test__ZN3aaa3BB1E, "_ZN3aaa3BB1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aaa3BB1C1Ev();
extern void _ZN3aaa3BB1D1Ev();
Name_Map name_map__ZN3aaa3BB1E[] = {
  NSPAIR(_ZN3aaa3BB1C1Ev),
  NSPAIR(_ZN3aaa3BB1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern void _ZN3aaa3BB13fooEv();
static  VTBL_ENTRY vtc__ZN3aaa3BB1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa3BB1E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB13fooEv,
};
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
Class_Descriptor cd__ZN3aaa3BB1E = {  "_ZN3aaa3BB1E", // class name
  0,0,//no base classes
  &(vtc__ZN3aaa3BB1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3aaa3BB1E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3aaa3BB1E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  CC1  {
  int pc;
  virtual void  foo(); // _ZN3aaa3CC13fooEv
  ~CC1(); // tgen
  CC1(); // tgen
};
//SIG(1 _ZN3aaa3CC1E) C1{ v1 Fi}
}
namespace aaa { 
void  aaa::CC1 ::foo(){vfunc_called(this, "_ZN3aaa3CC13fooEv");}
aaa::CC1 ::~CC1(){ note_dtor("_ZN3aaa3CC1E", this);} // tgen
aaa::CC1 ::CC1(){ note_ctor("_ZN3aaa3CC1E", this);} // tgen
}
static void Test__ZN3aaa3CC1E()
{
  extern Class_Descriptor cd__ZN3aaa3CC1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3aaa3CC1E, buf);
    ::aaa::CC1 *dp, &lv = *(dp=new (buf) ::aaa::CC1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3aaa3CC1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa3CC1E)");
    check_field_offset(lv, pc, ABISELECT(8,4), "_ZN3aaa3CC1E.pc");
    test_class_info(&lv, &cd__ZN3aaa3CC1E);
    dp->::aaa::CC1::~CC1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa3CC1E(Test__ZN3aaa3CC1E, "_ZN3aaa3CC1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aaa3CC1C1Ev();
extern void _ZN3aaa3CC1D1Ev();
Name_Map name_map__ZN3aaa3CC1E[] = {
  NSPAIR(_ZN3aaa3CC1C1Ev),
  NSPAIR(_ZN3aaa3CC1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3aaa3CC1E[];
extern void _ZN3aaa3CC13fooEv();
static  VTBL_ENTRY vtc__ZN3aaa3CC1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa3CC1E[0]),
  (VTBL_ENTRY)&_ZN3aaa3CC13fooEv,
};
extern VTBL_ENTRY _ZTIN3aaa3CC1E[];
extern  VTBL_ENTRY _ZTVN3aaa3CC1E[];
Class_Descriptor cd__ZN3aaa3CC1E = {  "_ZN3aaa3CC1E", // class name
  0,0,//no base classes
  &(vtc__ZN3aaa3CC1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3aaa3CC1E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3aaa3CC1E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  DD1  {
  int pd;
  virtual void  foo(); // _ZN3aaa3DD13fooEv
  ~DD1(); // tgen
  DD1(); // tgen
};
//SIG(1 _ZN3aaa3DD1E) C1{ v1 Fi}
}
namespace aaa { 
void  aaa::DD1 ::foo(){vfunc_called(this, "_ZN3aaa3DD13fooEv");}
aaa::DD1 ::~DD1(){ note_dtor("_ZN3aaa3DD1E", this);} // tgen
aaa::DD1 ::DD1(){ note_ctor("_ZN3aaa3DD1E", this);} // tgen
}
static void Test__ZN3aaa3DD1E()
{
  extern Class_Descriptor cd__ZN3aaa3DD1E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3aaa3DD1E, buf);
    ::aaa::DD1 *dp, &lv = *(dp=new (buf) ::aaa::DD1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3aaa3DD1E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa3DD1E)");
    check_field_offset(lv, pd, ABISELECT(8,4), "_ZN3aaa3DD1E.pd");
    test_class_info(&lv, &cd__ZN3aaa3DD1E);
    dp->::aaa::DD1::~DD1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa3DD1E(Test__ZN3aaa3DD1E, "_ZN3aaa3DD1E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aaa3DD1C1Ev();
extern void _ZN3aaa3DD1D1Ev();
Name_Map name_map__ZN3aaa3DD1E[] = {
  NSPAIR(_ZN3aaa3DD1C1Ev),
  NSPAIR(_ZN3aaa3DD1D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3aaa3DD1E[];
extern void _ZN3aaa3DD13fooEv();
static  VTBL_ENTRY vtc__ZN3aaa3DD1E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa3DD1E[0]),
  (VTBL_ENTRY)&_ZN3aaa3DD13fooEv,
};
extern VTBL_ENTRY _ZTIN3aaa3DD1E[];
extern  VTBL_ENTRY _ZTVN3aaa3DD1E[];
Class_Descriptor cd__ZN3aaa3DD1E = {  "_ZN3aaa3DD1E", // class name
  0,0,//no base classes
  &(vtc__ZN3aaa3DD1E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3aaa3DD1E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3aaa3DD1E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  AA2  {
  int pa;
  virtual void  bar(); // _ZN3aaa3AA23barEv
  ~AA2(); // tgen
  AA2(); // tgen
};
//SIG(-1 _ZN3aaa3AA2E) C1{ v1 Fi}
}
namespace aaa { 
void  aaa::AA2 ::bar(){vfunc_called(this, "_ZN3aaa3AA23barEv");}
aaa::AA2 ::~AA2(){ note_dtor("_ZN3aaa3AA2E", this);} // tgen
aaa::AA2 ::AA2(){ note_ctor("_ZN3aaa3AA2E", this);} // tgen
}
static void Test__ZN3aaa3AA2E()
{
  extern Class_Descriptor cd__ZN3aaa3AA2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3aaa3AA2E, buf);
    ::aaa::AA2 *dp, &lv = *(dp=new (buf) ::aaa::AA2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3aaa3AA2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa3AA2E)");
    check_field_offset(lv, pa, ABISELECT(8,4), "_ZN3aaa3AA2E.pa");
    test_class_info(&lv, &cd__ZN3aaa3AA2E);
    dp->::aaa::AA2::~AA2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa3AA2E(Test__ZN3aaa3AA2E, "_ZN3aaa3AA2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aaa3AA2C1Ev();
extern void _ZN3aaa3AA2D1Ev();
Name_Map name_map__ZN3aaa3AA2E[] = {
  NSPAIR(_ZN3aaa3AA2C1Ev),
  NSPAIR(_ZN3aaa3AA2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern void _ZN3aaa3AA23barEv();
static  VTBL_ENTRY vtc__ZN3aaa3AA2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa3AA2E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA23barEv,
};
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
Class_Descriptor cd__ZN3aaa3AA2E = {  "_ZN3aaa3AA2E", // class name
  0,0,//no base classes
  &(vtc__ZN3aaa3AA2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3aaa3AA2E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3aaa3AA2E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  BB2  {
  int pb;
  virtual void  bar(); // _ZN3aaa3BB23barEv
  ~BB2(); // tgen
  BB2(); // tgen
};
//SIG(-1 _ZN3aaa3BB2E) C1{ v1 Fi}
}
namespace aaa { 
void  aaa::BB2 ::bar(){vfunc_called(this, "_ZN3aaa3BB23barEv");}
aaa::BB2 ::~BB2(){ note_dtor("_ZN3aaa3BB2E", this);} // tgen
aaa::BB2 ::BB2(){ note_ctor("_ZN3aaa3BB2E", this);} // tgen
}
static void Test__ZN3aaa3BB2E()
{
  extern Class_Descriptor cd__ZN3aaa3BB2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3aaa3BB2E, buf);
    ::aaa::BB2 *dp, &lv = *(dp=new (buf) ::aaa::BB2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3aaa3BB2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa3BB2E)");
    check_field_offset(lv, pb, ABISELECT(8,4), "_ZN3aaa3BB2E.pb");
    test_class_info(&lv, &cd__ZN3aaa3BB2E);
    dp->::aaa::BB2::~BB2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa3BB2E(Test__ZN3aaa3BB2E, "_ZN3aaa3BB2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aaa3BB2C1Ev();
extern void _ZN3aaa3BB2D1Ev();
Name_Map name_map__ZN3aaa3BB2E[] = {
  NSPAIR(_ZN3aaa3BB2C1Ev),
  NSPAIR(_ZN3aaa3BB2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern void _ZN3aaa3BB23barEv();
static  VTBL_ENTRY vtc__ZN3aaa3BB2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa3BB2E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB23barEv,
};
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
Class_Descriptor cd__ZN3aaa3BB2E = {  "_ZN3aaa3BB2E", // class name
  0,0,//no base classes
  &(vtc__ZN3aaa3BB2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3aaa3BB2E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3aaa3BB2E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  CC2  {
  int pc;
  virtual void  bar(); // _ZN3aaa3CC23barEv
  ~CC2(); // tgen
  CC2(); // tgen
};
//SIG(1 _ZN3aaa3CC2E) C1{ v1 Fi}
}
namespace aaa { 
void  aaa::CC2 ::bar(){vfunc_called(this, "_ZN3aaa3CC23barEv");}
aaa::CC2 ::~CC2(){ note_dtor("_ZN3aaa3CC2E", this);} // tgen
aaa::CC2 ::CC2(){ note_ctor("_ZN3aaa3CC2E", this);} // tgen
}
static void Test__ZN3aaa3CC2E()
{
  extern Class_Descriptor cd__ZN3aaa3CC2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3aaa3CC2E, buf);
    ::aaa::CC2 *dp, &lv = *(dp=new (buf) ::aaa::CC2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3aaa3CC2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa3CC2E)");
    check_field_offset(lv, pc, ABISELECT(8,4), "_ZN3aaa3CC2E.pc");
    test_class_info(&lv, &cd__ZN3aaa3CC2E);
    dp->::aaa::CC2::~CC2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa3CC2E(Test__ZN3aaa3CC2E, "_ZN3aaa3CC2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aaa3CC2C1Ev();
extern void _ZN3aaa3CC2D1Ev();
Name_Map name_map__ZN3aaa3CC2E[] = {
  NSPAIR(_ZN3aaa3CC2C1Ev),
  NSPAIR(_ZN3aaa3CC2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3aaa3CC2E[];
extern void _ZN3aaa3CC23barEv();
static  VTBL_ENTRY vtc__ZN3aaa3CC2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa3CC2E[0]),
  (VTBL_ENTRY)&_ZN3aaa3CC23barEv,
};
extern VTBL_ENTRY _ZTIN3aaa3CC2E[];
extern  VTBL_ENTRY _ZTVN3aaa3CC2E[];
Class_Descriptor cd__ZN3aaa3CC2E = {  "_ZN3aaa3CC2E", // class name
  0,0,//no base classes
  &(vtc__ZN3aaa3CC2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3aaa3CC2E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3aaa3CC2E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  DD2  {
  int pd;
  virtual void  bar(); // _ZN3aaa3DD23barEv
  ~DD2(); // tgen
  DD2(); // tgen
};
//SIG(1 _ZN3aaa3DD2E) C1{ v1 Fi}
}
namespace aaa { 
void  aaa::DD2 ::bar(){vfunc_called(this, "_ZN3aaa3DD23barEv");}
aaa::DD2 ::~DD2(){ note_dtor("_ZN3aaa3DD2E", this);} // tgen
aaa::DD2 ::DD2(){ note_ctor("_ZN3aaa3DD2E", this);} // tgen
}
static void Test__ZN3aaa3DD2E()
{
  extern Class_Descriptor cd__ZN3aaa3DD2E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3aaa3DD2E, buf);
    ::aaa::DD2 *dp, &lv = *(dp=new (buf) ::aaa::DD2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3aaa3DD2E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa3DD2E)");
    check_field_offset(lv, pd, ABISELECT(8,4), "_ZN3aaa3DD2E.pd");
    test_class_info(&lv, &cd__ZN3aaa3DD2E);
    dp->::aaa::DD2::~DD2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa3DD2E(Test__ZN3aaa3DD2E, "_ZN3aaa3DD2E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aaa3DD2C1Ev();
extern void _ZN3aaa3DD2D1Ev();
Name_Map name_map__ZN3aaa3DD2E[] = {
  NSPAIR(_ZN3aaa3DD2C1Ev),
  NSPAIR(_ZN3aaa3DD2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3aaa3DD2E[];
extern void _ZN3aaa3DD23barEv();
static  VTBL_ENTRY vtc__ZN3aaa3DD2E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa3DD2E[0]),
  (VTBL_ENTRY)&_ZN3aaa3DD23barEv,
};
extern VTBL_ENTRY _ZTIN3aaa3DD2E[];
extern  VTBL_ENTRY _ZTVN3aaa3DD2E[];
Class_Descriptor cd__ZN3aaa3DD2E = {  "_ZN3aaa3DD2E", // class name
  0,0,//no base classes
  &(vtc__ZN3aaa3DD2E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3aaa3DD2E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3aaa3DD2E),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  AA3  {
  int pa;
  virtual void  foo(); // _ZN3aaa3AA33fooEv
  virtual void  bar(); // _ZN3aaa3AA33barEv
  ~AA3(); // tgen
  AA3(); // tgen
};
//SIG(-1 _ZN3aaa3AA3E) C1{ v1 v2 Fi}
}
namespace aaa { 
void  aaa::AA3 ::foo(){vfunc_called(this, "_ZN3aaa3AA33fooEv");}
void  aaa::AA3 ::bar(){vfunc_called(this, "_ZN3aaa3AA33barEv");}
aaa::AA3 ::~AA3(){ note_dtor("_ZN3aaa3AA3E", this);} // tgen
aaa::AA3 ::AA3(){ note_ctor("_ZN3aaa3AA3E", this);} // tgen
}
static void Test__ZN3aaa3AA3E()
{
  extern Class_Descriptor cd__ZN3aaa3AA3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3aaa3AA3E, buf);
    ::aaa::AA3 *dp, &lv = *(dp=new (buf) ::aaa::AA3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3aaa3AA3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa3AA3E)");
    check_field_offset(lv, pa, ABISELECT(8,4), "_ZN3aaa3AA3E.pa");
    test_class_info(&lv, &cd__ZN3aaa3AA3E);
    dp->::aaa::AA3::~AA3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa3AA3E(Test__ZN3aaa3AA3E, "_ZN3aaa3AA3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aaa3AA3C1Ev();
extern void _ZN3aaa3AA3D1Ev();
Name_Map name_map__ZN3aaa3AA3E[] = {
  NSPAIR(_ZN3aaa3AA3C1Ev),
  NSPAIR(_ZN3aaa3AA3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern void _ZN3aaa3AA33fooEv();
extern void _ZN3aaa3AA33barEv();
static  VTBL_ENTRY vtc__ZN3aaa3AA3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa3AA3E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA33fooEv,
  (VTBL_ENTRY)&_ZN3aaa3AA33barEv,
};
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
Class_Descriptor cd__ZN3aaa3AA3E = {  "_ZN3aaa3AA3E", // class name
  0,0,//no base classes
  &(vtc__ZN3aaa3AA3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3aaa3AA3E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3aaa3AA3E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  BB3  {
  int pb;
  virtual void  foo(); // _ZN3aaa3BB33fooEv
  virtual void  bar(); // _ZN3aaa3BB33barEv
  ~BB3(); // tgen
  BB3(); // tgen
};
//SIG(-1 _ZN3aaa3BB3E) C1{ v1 v2 Fi}
}
namespace aaa { 
void  aaa::BB3 ::foo(){vfunc_called(this, "_ZN3aaa3BB33fooEv");}
void  aaa::BB3 ::bar(){vfunc_called(this, "_ZN3aaa3BB33barEv");}
aaa::BB3 ::~BB3(){ note_dtor("_ZN3aaa3BB3E", this);} // tgen
aaa::BB3 ::BB3(){ note_ctor("_ZN3aaa3BB3E", this);} // tgen
}
static void Test__ZN3aaa3BB3E()
{
  extern Class_Descriptor cd__ZN3aaa3BB3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3aaa3BB3E, buf);
    ::aaa::BB3 *dp, &lv = *(dp=new (buf) ::aaa::BB3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3aaa3BB3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa3BB3E)");
    check_field_offset(lv, pb, ABISELECT(8,4), "_ZN3aaa3BB3E.pb");
    test_class_info(&lv, &cd__ZN3aaa3BB3E);
    dp->::aaa::BB3::~BB3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa3BB3E(Test__ZN3aaa3BB3E, "_ZN3aaa3BB3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aaa3BB3C1Ev();
extern void _ZN3aaa3BB3D1Ev();
Name_Map name_map__ZN3aaa3BB3E[] = {
  NSPAIR(_ZN3aaa3BB3C1Ev),
  NSPAIR(_ZN3aaa3BB3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern void _ZN3aaa3BB33fooEv();
extern void _ZN3aaa3BB33barEv();
static  VTBL_ENTRY vtc__ZN3aaa3BB3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa3BB3E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB33fooEv,
  (VTBL_ENTRY)&_ZN3aaa3BB33barEv,
};
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
Class_Descriptor cd__ZN3aaa3BB3E = {  "_ZN3aaa3BB3E", // class name
  0,0,//no base classes
  &(vtc__ZN3aaa3BB3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3aaa3BB3E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3aaa3BB3E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  CC3  {
  int pc;
  virtual void  foo(); // _ZN3aaa3CC33fooEv
  virtual void  bar(); // _ZN3aaa3CC33barEv
  ~CC3(); // tgen
  CC3(); // tgen
};
//SIG(1 _ZN3aaa3CC3E) C1{ v1 v2 Fi}
}
namespace aaa { 
void  aaa::CC3 ::foo(){vfunc_called(this, "_ZN3aaa3CC33fooEv");}
void  aaa::CC3 ::bar(){vfunc_called(this, "_ZN3aaa3CC33barEv");}
aaa::CC3 ::~CC3(){ note_dtor("_ZN3aaa3CC3E", this);} // tgen
aaa::CC3 ::CC3(){ note_ctor("_ZN3aaa3CC3E", this);} // tgen
}
static void Test__ZN3aaa3CC3E()
{
  extern Class_Descriptor cd__ZN3aaa3CC3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3aaa3CC3E, buf);
    ::aaa::CC3 *dp, &lv = *(dp=new (buf) ::aaa::CC3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3aaa3CC3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa3CC3E)");
    check_field_offset(lv, pc, ABISELECT(8,4), "_ZN3aaa3CC3E.pc");
    test_class_info(&lv, &cd__ZN3aaa3CC3E);
    dp->::aaa::CC3::~CC3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa3CC3E(Test__ZN3aaa3CC3E, "_ZN3aaa3CC3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aaa3CC3C1Ev();
extern void _ZN3aaa3CC3D1Ev();
Name_Map name_map__ZN3aaa3CC3E[] = {
  NSPAIR(_ZN3aaa3CC3C1Ev),
  NSPAIR(_ZN3aaa3CC3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3aaa3CC3E[];
extern void _ZN3aaa3CC33fooEv();
extern void _ZN3aaa3CC33barEv();
static  VTBL_ENTRY vtc__ZN3aaa3CC3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa3CC3E[0]),
  (VTBL_ENTRY)&_ZN3aaa3CC33fooEv,
  (VTBL_ENTRY)&_ZN3aaa3CC33barEv,
};
extern VTBL_ENTRY _ZTIN3aaa3CC3E[];
extern  VTBL_ENTRY _ZTVN3aaa3CC3E[];
Class_Descriptor cd__ZN3aaa3CC3E = {  "_ZN3aaa3CC3E", // class name
  0,0,//no base classes
  &(vtc__ZN3aaa3CC3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3aaa3CC3E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3aaa3CC3E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  DD3  {
  int pd;
  virtual void  foo(); // _ZN3aaa3DD33fooEv
  virtual void  bar(); // _ZN3aaa3DD33barEv
  ~DD3(); // tgen
  DD3(); // tgen
};
//SIG(1 _ZN3aaa3DD3E) C1{ v1 v2 Fi}
}
namespace aaa { 
void  aaa::DD3 ::foo(){vfunc_called(this, "_ZN3aaa3DD33fooEv");}
void  aaa::DD3 ::bar(){vfunc_called(this, "_ZN3aaa3DD33barEv");}
aaa::DD3 ::~DD3(){ note_dtor("_ZN3aaa3DD3E", this);} // tgen
aaa::DD3 ::DD3(){ note_ctor("_ZN3aaa3DD3E", this);} // tgen
}
static void Test__ZN3aaa3DD3E()
{
  extern Class_Descriptor cd__ZN3aaa3DD3E;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd__ZN3aaa3DD3E, buf);
    ::aaa::DD3 *dp, &lv = *(dp=new (buf) ::aaa::DD3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(_ZN3aaa3DD3E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa3DD3E)");
    check_field_offset(lv, pd, ABISELECT(8,4), "_ZN3aaa3DD3E.pd");
    test_class_info(&lv, &cd__ZN3aaa3DD3E);
    dp->::aaa::DD3::~DD3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa3DD3E(Test__ZN3aaa3DD3E, "_ZN3aaa3DD3E", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN3aaa3DD3C1Ev();
extern void _ZN3aaa3DD3D1Ev();
Name_Map name_map__ZN3aaa3DD3E[] = {
  NSPAIR(_ZN3aaa3DD3C1Ev),
  NSPAIR(_ZN3aaa3DD3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTIN3aaa3DD3E[];
extern void _ZN3aaa3DD33fooEv();
extern void _ZN3aaa3DD33barEv();
static  VTBL_ENTRY vtc__ZN3aaa3DD3E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa3DD3E[0]),
  (VTBL_ENTRY)&_ZN3aaa3DD33fooEv,
  (VTBL_ENTRY)&_ZN3aaa3DD33barEv,
};
extern VTBL_ENTRY _ZTIN3aaa3DD3E[];
extern  VTBL_ENTRY _ZTVN3aaa3DD3E[];
Class_Descriptor cd__ZN3aaa3DD3E = {  "_ZN3aaa3DD3E", // class name
  0,0,//no base classes
  &(vtc__ZN3aaa3DD3E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTIN3aaa3DD3E),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTVN3aaa3DD3E),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE111  : ::aaa::AA1 , ::aaa::BB1 {
  int pe;
  virtual void  foo(); // _ZN3aaa5EE1113fooEv
  ~EE111(); // tgen
  EE111(); // tgen
};
//SIG(-1 _ZN3aaa5EE111E) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::EE111 ::foo(){vfunc_called(this, "_ZN3aaa5EE1113fooEv");}
aaa::EE111 ::~EE111(){ note_dtor("_ZN3aaa5EE111E", this);} // tgen
aaa::EE111 ::EE111(){ note_ctor("_ZN3aaa5EE111E", this);} // tgen
}
static void Test__ZN3aaa5EE111E()
{
  extern Class_Descriptor cd__ZN3aaa5EE111E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE111E, buf);
    ::aaa::EE111 *dp, &lv = *(dp=new (buf) ::aaa::EE111());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE111E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE111E)");
    check_base_class_offset(lv, (::aaa::AA1*), 0, "_ZN3aaa5EE111E");
    check_base_class_offset(lv, (::aaa::BB1*), ABISELECT(16,8), "_ZN3aaa5EE111E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE111E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE111E);
    dp->::aaa::EE111::~EE111();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE111E(Test__ZN3aaa5EE111E, "_ZN3aaa5EE111E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE111C1Ev();
extern void _ZN3aaa5EE111D1Ev();
Name_Map name_map__ZN3aaa5EE111E[] = {
  NSPAIR(_ZN3aaa5EE111C1Ev),
  NSPAIR(_ZN3aaa5EE111D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
static Base_Class bases__ZN3aaa5EE111E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern void _ZN3aaa5EE1113fooEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa5EE111E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE111E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE111E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
Class_Descriptor cd__ZN3aaa5EE111E = {  "_ZN3aaa5EE111E", // class name
  bases__ZN3aaa5EE111E, 2,
  &(vtc__ZN3aaa5EE111E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE111E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE111E),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF111  : ::aaa::AA1 , ::aaa::BB1 {
  int pf;
  virtual void  foo(); // _ZN3aaa5FF1113fooEv
  ~FF111(); // tgen
  FF111(); // tgen
};
//SIG(-1 _ZN3aaa5FF111E) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::FF111 ::foo(){vfunc_called(this, "_ZN3aaa5FF1113fooEv");}
aaa::FF111 ::~FF111(){ note_dtor("_ZN3aaa5FF111E", this);} // tgen
aaa::FF111 ::FF111(){ note_ctor("_ZN3aaa5FF111E", this);} // tgen
}
static void Test__ZN3aaa5FF111E()
{
  extern Class_Descriptor cd__ZN3aaa5FF111E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF111E, buf);
    ::aaa::FF111 *dp, &lv = *(dp=new (buf) ::aaa::FF111());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF111E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF111E)");
    check_base_class_offset(lv, (::aaa::AA1*), 0, "_ZN3aaa5FF111E");
    check_base_class_offset(lv, (::aaa::BB1*), ABISELECT(16,8), "_ZN3aaa5FF111E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF111E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF111E);
    dp->::aaa::FF111::~FF111();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF111E(Test__ZN3aaa5FF111E, "_ZN3aaa5FF111E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF111C1Ev();
extern void _ZN3aaa5FF111D1Ev();
Name_Map name_map__ZN3aaa5FF111E[] = {
  NSPAIR(_ZN3aaa5FF111C1Ev),
  NSPAIR(_ZN3aaa5FF111D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
static Base_Class bases__ZN3aaa5FF111E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF111E[];
extern void _ZN3aaa5FF1113fooEv();
extern void ABISELECT(_ZThn16_N3aaa5FF1113fooEv,_ZThn8_N3aaa5FF1113fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa5FF111E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF111E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF1113fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF111E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF1113fooEv,_ZThn8_N3aaa5FF1113fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa5FF111E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF111E[];
Class_Descriptor cd__ZN3aaa5FF111E = {  "_ZN3aaa5FF111E", // class name
  bases__ZN3aaa5FF111E, 2,
  &(vtc__ZN3aaa5FF111E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF111E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF111E),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE112  : ::aaa::AA1 , ::aaa::BB1 {
  int pe;
  virtual void  bar(); // _ZN3aaa5EE1123barEv
  ~EE112(); // tgen
  EE112(); // tgen
};
//SIG(-1 _ZN3aaa5EE112E) C1{ BC2{ v2 Fi} BC3{ v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::EE112 ::bar(){vfunc_called(this, "_ZN3aaa5EE1123barEv");}
aaa::EE112 ::~EE112(){ note_dtor("_ZN3aaa5EE112E", this);} // tgen
aaa::EE112 ::EE112(){ note_ctor("_ZN3aaa5EE112E", this);} // tgen
}
static void Test__ZN3aaa5EE112E()
{
  extern Class_Descriptor cd__ZN3aaa5EE112E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE112E, buf);
    ::aaa::EE112 *dp, &lv = *(dp=new (buf) ::aaa::EE112());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE112E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE112E)");
    check_base_class_offset(lv, (::aaa::AA1*), 0, "_ZN3aaa5EE112E");
    check_base_class_offset(lv, (::aaa::BB1*), ABISELECT(16,8), "_ZN3aaa5EE112E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE112E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE112E);
    dp->::aaa::EE112::~EE112();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE112E(Test__ZN3aaa5EE112E, "_ZN3aaa5EE112E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE112C1Ev();
extern void _ZN3aaa5EE112D1Ev();
Name_Map name_map__ZN3aaa5EE112E[] = {
  NSPAIR(_ZN3aaa5EE112C1Ev),
  NSPAIR(_ZN3aaa5EE112D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
static Base_Class bases__ZN3aaa5EE112E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern void _ZN3aaa3AA13fooEv();
extern void _ZN3aaa5EE1123barEv();
extern void _ZN3aaa3BB13fooEv();
static  VTBL_ENTRY vtc__ZN3aaa5EE112E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE112E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA13fooEv,
  (VTBL_ENTRY)&_ZN3aaa5EE1123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE112E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB13fooEv,
};
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
Class_Descriptor cd__ZN3aaa5EE112E = {  "_ZN3aaa5EE112E", // class name
  bases__ZN3aaa5EE112E, 2,
  &(vtc__ZN3aaa5EE112E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE112E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE112E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF112  : ::aaa::AA1 , ::aaa::BB1 {
  int pf;
  virtual void  bar(); // _ZN3aaa5FF1123barEv
  ~FF112(); // tgen
  FF112(); // tgen
};
//SIG(-1 _ZN3aaa5FF112E) C1{ BC2{ v2 Fi} BC3{ v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::FF112 ::bar(){vfunc_called(this, "_ZN3aaa5FF1123barEv");}
aaa::FF112 ::~FF112(){ note_dtor("_ZN3aaa5FF112E", this);} // tgen
aaa::FF112 ::FF112(){ note_ctor("_ZN3aaa5FF112E", this);} // tgen
}
static void Test__ZN3aaa5FF112E()
{
  extern Class_Descriptor cd__ZN3aaa5FF112E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF112E, buf);
    ::aaa::FF112 *dp, &lv = *(dp=new (buf) ::aaa::FF112());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF112E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF112E)");
    check_base_class_offset(lv, (::aaa::AA1*), 0, "_ZN3aaa5FF112E");
    check_base_class_offset(lv, (::aaa::BB1*), ABISELECT(16,8), "_ZN3aaa5FF112E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF112E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF112E);
    dp->::aaa::FF112::~FF112();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF112E(Test__ZN3aaa5FF112E, "_ZN3aaa5FF112E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF112C1Ev();
extern void _ZN3aaa5FF112D1Ev();
Name_Map name_map__ZN3aaa5FF112E[] = {
  NSPAIR(_ZN3aaa5FF112C1Ev),
  NSPAIR(_ZN3aaa5FF112D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
static Base_Class bases__ZN3aaa5FF112E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF112E[];
extern void _ZN3aaa3AA13fooEv();
extern void _ZN3aaa5FF1123barEv();
extern void _ZN3aaa3BB13fooEv();
static  VTBL_ENTRY vtc__ZN3aaa5FF112E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF112E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA13fooEv,
  (VTBL_ENTRY)&_ZN3aaa5FF1123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF112E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB13fooEv,
};
extern VTBL_ENTRY _ZTIN3aaa5FF112E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF112E[];
Class_Descriptor cd__ZN3aaa5FF112E = {  "_ZN3aaa5FF112E", // class name
  bases__ZN3aaa5FF112E, 2,
  &(vtc__ZN3aaa5FF112E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF112E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF112E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE113  : ::aaa::AA1 , ::aaa::BB1 {
  int pe;
  virtual void  foo(); // _ZN3aaa5EE1133fooEv
  virtual void  bar(); // _ZN3aaa5EE1133barEv
  ~EE113(); // tgen
  EE113(); // tgen
};
//SIG(-1 _ZN3aaa5EE113E) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::EE113 ::foo(){vfunc_called(this, "_ZN3aaa5EE1133fooEv");}
void  aaa::EE113 ::bar(){vfunc_called(this, "_ZN3aaa5EE1133barEv");}
aaa::EE113 ::~EE113(){ note_dtor("_ZN3aaa5EE113E", this);} // tgen
aaa::EE113 ::EE113(){ note_ctor("_ZN3aaa5EE113E", this);} // tgen
}
static void Test__ZN3aaa5EE113E()
{
  extern Class_Descriptor cd__ZN3aaa5EE113E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE113E, buf);
    ::aaa::EE113 *dp, &lv = *(dp=new (buf) ::aaa::EE113());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE113E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE113E)");
    check_base_class_offset(lv, (::aaa::AA1*), 0, "_ZN3aaa5EE113E");
    check_base_class_offset(lv, (::aaa::BB1*), ABISELECT(16,8), "_ZN3aaa5EE113E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE113E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE113E);
    dp->::aaa::EE113::~EE113();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE113E(Test__ZN3aaa5EE113E, "_ZN3aaa5EE113E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE113C1Ev();
extern void _ZN3aaa5EE113D1Ev();
Name_Map name_map__ZN3aaa5EE113E[] = {
  NSPAIR(_ZN3aaa5EE113C1Ev),
  NSPAIR(_ZN3aaa5EE113D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
static Base_Class bases__ZN3aaa5EE113E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE113E[];
extern void _ZN3aaa5EE1133fooEv();
extern void _ZN3aaa5EE1133barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1133fooEv,_ZThn8_N3aaa5EE1133fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa5EE113E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE113E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1133fooEv,
  (VTBL_ENTRY)&_ZN3aaa5EE1133barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE113E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1133fooEv,_ZThn8_N3aaa5EE1133fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa5EE113E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE113E[];
Class_Descriptor cd__ZN3aaa5EE113E = {  "_ZN3aaa5EE113E", // class name
  bases__ZN3aaa5EE113E, 2,
  &(vtc__ZN3aaa5EE113E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE113E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE113E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF113  : ::aaa::AA1 , ::aaa::BB1 {
  int pf;
  virtual void  foo(); // _ZN3aaa5FF1133fooEv
  virtual void  bar(); // _ZN3aaa5FF1133barEv
  ~FF113(); // tgen
  FF113(); // tgen
};
//SIG(-1 _ZN3aaa5FF113E) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::FF113 ::foo(){vfunc_called(this, "_ZN3aaa5FF1133fooEv");}
void  aaa::FF113 ::bar(){vfunc_called(this, "_ZN3aaa5FF1133barEv");}
aaa::FF113 ::~FF113(){ note_dtor("_ZN3aaa5FF113E", this);} // tgen
aaa::FF113 ::FF113(){ note_ctor("_ZN3aaa5FF113E", this);} // tgen
}
static void Test__ZN3aaa5FF113E()
{
  extern Class_Descriptor cd__ZN3aaa5FF113E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF113E, buf);
    ::aaa::FF113 *dp, &lv = *(dp=new (buf) ::aaa::FF113());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF113E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF113E)");
    check_base_class_offset(lv, (::aaa::AA1*), 0, "_ZN3aaa5FF113E");
    check_base_class_offset(lv, (::aaa::BB1*), ABISELECT(16,8), "_ZN3aaa5FF113E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF113E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF113E);
    dp->::aaa::FF113::~FF113();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF113E(Test__ZN3aaa5FF113E, "_ZN3aaa5FF113E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF113C1Ev();
extern void _ZN3aaa5FF113D1Ev();
Name_Map name_map__ZN3aaa5FF113E[] = {
  NSPAIR(_ZN3aaa5FF113C1Ev),
  NSPAIR(_ZN3aaa5FF113D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
static Base_Class bases__ZN3aaa5FF113E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF113E[];
extern void _ZN3aaa5FF1133fooEv();
extern void _ZN3aaa5FF1133barEv();
extern void ABISELECT(_ZThn16_N3aaa5FF1133fooEv,_ZThn8_N3aaa5FF1133fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa5FF113E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF113E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF1133fooEv,
  (VTBL_ENTRY)&_ZN3aaa5FF1133barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF113E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF1133fooEv,_ZThn8_N3aaa5FF1133fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa5FF113E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF113E[];
Class_Descriptor cd__ZN3aaa5FF113E = {  "_ZN3aaa5FF113E", // class name
  bases__ZN3aaa5FF113E, 2,
  &(vtc__ZN3aaa5FF113E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF113E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF113E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE121  : ::aaa::AA1 , ::aaa::BB2 {
  int pe;
  virtual void  foo(); // _ZN3aaa5EE1213fooEv
  ~EE121(); // tgen
  EE121(); // tgen
};
//SIG(-1 _ZN3aaa5EE121E) C1{ BC2{ v1 Fi} BC3{ v2 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::EE121 ::foo(){vfunc_called(this, "_ZN3aaa5EE1213fooEv");}
aaa::EE121 ::~EE121(){ note_dtor("_ZN3aaa5EE121E", this);} // tgen
aaa::EE121 ::EE121(){ note_ctor("_ZN3aaa5EE121E", this);} // tgen
}
static void Test__ZN3aaa5EE121E()
{
  extern Class_Descriptor cd__ZN3aaa5EE121E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE121E, buf);
    ::aaa::EE121 *dp, &lv = *(dp=new (buf) ::aaa::EE121());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE121E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE121E)");
    check_base_class_offset(lv, (::aaa::AA1*), 0, "_ZN3aaa5EE121E");
    check_base_class_offset(lv, (::aaa::BB2*), ABISELECT(16,8), "_ZN3aaa5EE121E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE121E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE121E);
    dp->::aaa::EE121::~EE121();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE121E(Test__ZN3aaa5EE121E, "_ZN3aaa5EE121E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE121C1Ev();
extern void _ZN3aaa5EE121D1Ev();
Name_Map name_map__ZN3aaa5EE121E[] = {
  NSPAIR(_ZN3aaa5EE121C1Ev),
  NSPAIR(_ZN3aaa5EE121D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
static Base_Class bases__ZN3aaa5EE121E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE121E[];
extern void _ZN3aaa5EE1213fooEv();
extern void _ZN3aaa3BB23barEv();
static  VTBL_ENTRY vtc__ZN3aaa5EE121E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE121E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1213fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE121E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB23barEv,
};
extern VTBL_ENTRY _ZTIN3aaa5EE121E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE121E[];
Class_Descriptor cd__ZN3aaa5EE121E = {  "_ZN3aaa5EE121E", // class name
  bases__ZN3aaa5EE121E, 2,
  &(vtc__ZN3aaa5EE121E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE121E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE121E),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF121  : ::aaa::AA1 , ::aaa::BB2 {
  int pf;
  virtual void  foo(); // _ZN3aaa5FF1213fooEv
  ~FF121(); // tgen
  FF121(); // tgen
};
//SIG(-1 _ZN3aaa5FF121E) C1{ BC2{ v1 Fi} BC3{ v2 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::FF121 ::foo(){vfunc_called(this, "_ZN3aaa5FF1213fooEv");}
aaa::FF121 ::~FF121(){ note_dtor("_ZN3aaa5FF121E", this);} // tgen
aaa::FF121 ::FF121(){ note_ctor("_ZN3aaa5FF121E", this);} // tgen
}
static void Test__ZN3aaa5FF121E()
{
  extern Class_Descriptor cd__ZN3aaa5FF121E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF121E, buf);
    ::aaa::FF121 *dp, &lv = *(dp=new (buf) ::aaa::FF121());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF121E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF121E)");
    check_base_class_offset(lv, (::aaa::AA1*), 0, "_ZN3aaa5FF121E");
    check_base_class_offset(lv, (::aaa::BB2*), ABISELECT(16,8), "_ZN3aaa5FF121E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF121E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF121E);
    dp->::aaa::FF121::~FF121();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF121E(Test__ZN3aaa5FF121E, "_ZN3aaa5FF121E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF121C1Ev();
extern void _ZN3aaa5FF121D1Ev();
Name_Map name_map__ZN3aaa5FF121E[] = {
  NSPAIR(_ZN3aaa5FF121C1Ev),
  NSPAIR(_ZN3aaa5FF121D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
static Base_Class bases__ZN3aaa5FF121E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF121E[];
extern void _ZN3aaa5FF1213fooEv();
extern void _ZN3aaa3BB23barEv();
static  VTBL_ENTRY vtc__ZN3aaa5FF121E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF121E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF1213fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF121E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB23barEv,
};
extern VTBL_ENTRY _ZTIN3aaa5FF121E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF121E[];
Class_Descriptor cd__ZN3aaa5FF121E = {  "_ZN3aaa5FF121E", // class name
  bases__ZN3aaa5FF121E, 2,
  &(vtc__ZN3aaa5FF121E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF121E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF121E),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE122  : ::aaa::AA1 , ::aaa::BB2 {
  int pe;
  virtual void  bar(); // _ZN3aaa5EE1223barEv
  ~EE122(); // tgen
  EE122(); // tgen
};
//SIG(-1 _ZN3aaa5EE122E) C1{ BC2{ v2 Fi} BC3{ v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::EE122 ::bar(){vfunc_called(this, "_ZN3aaa5EE1223barEv");}
aaa::EE122 ::~EE122(){ note_dtor("_ZN3aaa5EE122E", this);} // tgen
aaa::EE122 ::EE122(){ note_ctor("_ZN3aaa5EE122E", this);} // tgen
}
static void Test__ZN3aaa5EE122E()
{
  extern Class_Descriptor cd__ZN3aaa5EE122E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE122E, buf);
    ::aaa::EE122 *dp, &lv = *(dp=new (buf) ::aaa::EE122());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE122E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE122E)");
    check_base_class_offset(lv, (::aaa::AA1*), 0, "_ZN3aaa5EE122E");
    check_base_class_offset(lv, (::aaa::BB2*), ABISELECT(16,8), "_ZN3aaa5EE122E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE122E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE122E);
    dp->::aaa::EE122::~EE122();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE122E(Test__ZN3aaa5EE122E, "_ZN3aaa5EE122E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE122C1Ev();
extern void _ZN3aaa5EE122D1Ev();
Name_Map name_map__ZN3aaa5EE122E[] = {
  NSPAIR(_ZN3aaa5EE122C1Ev),
  NSPAIR(_ZN3aaa5EE122D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
static Base_Class bases__ZN3aaa5EE122E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE122E[];
extern void _ZN3aaa3AA13fooEv();
extern void _ZN3aaa5EE1223barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1223barEv,_ZThn8_N3aaa5EE1223barEv)();
static  VTBL_ENTRY vtc__ZN3aaa5EE122E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE122E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA13fooEv,
  (VTBL_ENTRY)&_ZN3aaa5EE1223barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE122E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1223barEv,_ZThn8_N3aaa5EE1223barEv),
};
extern VTBL_ENTRY _ZTIN3aaa5EE122E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE122E[];
Class_Descriptor cd__ZN3aaa5EE122E = {  "_ZN3aaa5EE122E", // class name
  bases__ZN3aaa5EE122E, 2,
  &(vtc__ZN3aaa5EE122E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE122E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE122E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF122  : ::aaa::AA1 , ::aaa::BB2 {
  int pf;
  virtual void  bar(); // _ZN3aaa5FF1223barEv
  ~FF122(); // tgen
  FF122(); // tgen
};
//SIG(-1 _ZN3aaa5FF122E) C1{ BC2{ v2 Fi} BC3{ v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::FF122 ::bar(){vfunc_called(this, "_ZN3aaa5FF1223barEv");}
aaa::FF122 ::~FF122(){ note_dtor("_ZN3aaa5FF122E", this);} // tgen
aaa::FF122 ::FF122(){ note_ctor("_ZN3aaa5FF122E", this);} // tgen
}
static void Test__ZN3aaa5FF122E()
{
  extern Class_Descriptor cd__ZN3aaa5FF122E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF122E, buf);
    ::aaa::FF122 *dp, &lv = *(dp=new (buf) ::aaa::FF122());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF122E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF122E)");
    check_base_class_offset(lv, (::aaa::AA1*), 0, "_ZN3aaa5FF122E");
    check_base_class_offset(lv, (::aaa::BB2*), ABISELECT(16,8), "_ZN3aaa5FF122E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF122E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF122E);
    dp->::aaa::FF122::~FF122();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF122E(Test__ZN3aaa5FF122E, "_ZN3aaa5FF122E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF122C1Ev();
extern void _ZN3aaa5FF122D1Ev();
Name_Map name_map__ZN3aaa5FF122E[] = {
  NSPAIR(_ZN3aaa5FF122C1Ev),
  NSPAIR(_ZN3aaa5FF122D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
static Base_Class bases__ZN3aaa5FF122E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF122E[];
extern void _ZN3aaa3AA13fooEv();
extern void _ZN3aaa5FF1223barEv();
extern void ABISELECT(_ZThn16_N3aaa5FF1223barEv,_ZThn8_N3aaa5FF1223barEv)();
static  VTBL_ENTRY vtc__ZN3aaa5FF122E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF122E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA13fooEv,
  (VTBL_ENTRY)&_ZN3aaa5FF1223barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF122E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF1223barEv,_ZThn8_N3aaa5FF1223barEv),
};
extern VTBL_ENTRY _ZTIN3aaa5FF122E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF122E[];
Class_Descriptor cd__ZN3aaa5FF122E = {  "_ZN3aaa5FF122E", // class name
  bases__ZN3aaa5FF122E, 2,
  &(vtc__ZN3aaa5FF122E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF122E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF122E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE123  : ::aaa::AA1 , ::aaa::BB2 {
  int pe;
  virtual void  foo(); // _ZN3aaa5EE1233fooEv
  virtual void  bar(); // _ZN3aaa5EE1233barEv
  ~EE123(); // tgen
  EE123(); // tgen
};
//SIG(-1 _ZN3aaa5EE123E) C1{ BC2{ v1 Fi} BC3{ v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::EE123 ::foo(){vfunc_called(this, "_ZN3aaa5EE1233fooEv");}
void  aaa::EE123 ::bar(){vfunc_called(this, "_ZN3aaa5EE1233barEv");}
aaa::EE123 ::~EE123(){ note_dtor("_ZN3aaa5EE123E", this);} // tgen
aaa::EE123 ::EE123(){ note_ctor("_ZN3aaa5EE123E", this);} // tgen
}
static void Test__ZN3aaa5EE123E()
{
  extern Class_Descriptor cd__ZN3aaa5EE123E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE123E, buf);
    ::aaa::EE123 *dp, &lv = *(dp=new (buf) ::aaa::EE123());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE123E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE123E)");
    check_base_class_offset(lv, (::aaa::AA1*), 0, "_ZN3aaa5EE123E");
    check_base_class_offset(lv, (::aaa::BB2*), ABISELECT(16,8), "_ZN3aaa5EE123E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE123E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE123E);
    dp->::aaa::EE123::~EE123();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE123E(Test__ZN3aaa5EE123E, "_ZN3aaa5EE123E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE123C1Ev();
extern void _ZN3aaa5EE123D1Ev();
Name_Map name_map__ZN3aaa5EE123E[] = {
  NSPAIR(_ZN3aaa5EE123C1Ev),
  NSPAIR(_ZN3aaa5EE123D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
static Base_Class bases__ZN3aaa5EE123E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE123E[];
extern void _ZN3aaa5EE1233fooEv();
extern void _ZN3aaa5EE1233barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1233barEv,_ZThn8_N3aaa5EE1233barEv)();
static  VTBL_ENTRY vtc__ZN3aaa5EE123E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE123E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1233fooEv,
  (VTBL_ENTRY)&_ZN3aaa5EE1233barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE123E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1233barEv,_ZThn8_N3aaa5EE1233barEv),
};
extern VTBL_ENTRY _ZTIN3aaa5EE123E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE123E[];
Class_Descriptor cd__ZN3aaa5EE123E = {  "_ZN3aaa5EE123E", // class name
  bases__ZN3aaa5EE123E, 2,
  &(vtc__ZN3aaa5EE123E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE123E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE123E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF123  : ::aaa::AA1 , ::aaa::BB2 {
  int pf;
  virtual void  foo(); // _ZN3aaa5FF1233fooEv
  virtual void  bar(); // _ZN3aaa5FF1233barEv
  ~FF123(); // tgen
  FF123(); // tgen
};
//SIG(-1 _ZN3aaa5FF123E) C1{ BC2{ v1 Fi} BC3{ v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::FF123 ::foo(){vfunc_called(this, "_ZN3aaa5FF1233fooEv");}
void  aaa::FF123 ::bar(){vfunc_called(this, "_ZN3aaa5FF1233barEv");}
aaa::FF123 ::~FF123(){ note_dtor("_ZN3aaa5FF123E", this);} // tgen
aaa::FF123 ::FF123(){ note_ctor("_ZN3aaa5FF123E", this);} // tgen
}
static void Test__ZN3aaa5FF123E()
{
  extern Class_Descriptor cd__ZN3aaa5FF123E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF123E, buf);
    ::aaa::FF123 *dp, &lv = *(dp=new (buf) ::aaa::FF123());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF123E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF123E)");
    check_base_class_offset(lv, (::aaa::AA1*), 0, "_ZN3aaa5FF123E");
    check_base_class_offset(lv, (::aaa::BB2*), ABISELECT(16,8), "_ZN3aaa5FF123E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF123E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF123E);
    dp->::aaa::FF123::~FF123();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF123E(Test__ZN3aaa5FF123E, "_ZN3aaa5FF123E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF123C1Ev();
extern void _ZN3aaa5FF123D1Ev();
Name_Map name_map__ZN3aaa5FF123E[] = {
  NSPAIR(_ZN3aaa5FF123C1Ev),
  NSPAIR(_ZN3aaa5FF123D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
static Base_Class bases__ZN3aaa5FF123E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF123E[];
extern void _ZN3aaa5FF1233fooEv();
extern void _ZN3aaa5FF1233barEv();
extern void ABISELECT(_ZThn16_N3aaa5FF1233barEv,_ZThn8_N3aaa5FF1233barEv)();
static  VTBL_ENTRY vtc__ZN3aaa5FF123E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF123E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF1233fooEv,
  (VTBL_ENTRY)&_ZN3aaa5FF1233barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF123E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF1233barEv,_ZThn8_N3aaa5FF1233barEv),
};
extern VTBL_ENTRY _ZTIN3aaa5FF123E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF123E[];
Class_Descriptor cd__ZN3aaa5FF123E = {  "_ZN3aaa5FF123E", // class name
  bases__ZN3aaa5FF123E, 2,
  &(vtc__ZN3aaa5FF123E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF123E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF123E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE131  : ::aaa::AA1 , ::aaa::BB3 {
  int pe;
  virtual void  foo(); // _ZN3aaa5EE1313fooEv
  ~EE131(); // tgen
  EE131(); // tgen
};
//SIG(-1 _ZN3aaa5EE131E) C1{ BC2{ v1 Fi} BC3{ v1 v2 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::EE131 ::foo(){vfunc_called(this, "_ZN3aaa5EE1313fooEv");}
aaa::EE131 ::~EE131(){ note_dtor("_ZN3aaa5EE131E", this);} // tgen
aaa::EE131 ::EE131(){ note_ctor("_ZN3aaa5EE131E", this);} // tgen
}
static void Test__ZN3aaa5EE131E()
{
  extern Class_Descriptor cd__ZN3aaa5EE131E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE131E, buf);
    ::aaa::EE131 *dp, &lv = *(dp=new (buf) ::aaa::EE131());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE131E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE131E)");
    check_base_class_offset(lv, (::aaa::AA1*), 0, "_ZN3aaa5EE131E");
    check_base_class_offset(lv, (::aaa::BB3*), ABISELECT(16,8), "_ZN3aaa5EE131E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE131E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE131E);
    dp->::aaa::EE131::~EE131();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE131E(Test__ZN3aaa5EE131E, "_ZN3aaa5EE131E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE131C1Ev();
extern void _ZN3aaa5EE131D1Ev();
Name_Map name_map__ZN3aaa5EE131E[] = {
  NSPAIR(_ZN3aaa5EE131C1Ev),
  NSPAIR(_ZN3aaa5EE131D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
static Base_Class bases__ZN3aaa5EE131E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE131E[];
extern void _ZN3aaa5EE1313fooEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1313fooEv,_ZThn8_N3aaa5EE1313fooEv)();
extern void _ZN3aaa3BB33barEv();
static  VTBL_ENTRY vtc__ZN3aaa5EE131E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE131E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1313fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE131E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1313fooEv,_ZThn8_N3aaa5EE1313fooEv),
  (VTBL_ENTRY)&_ZN3aaa3BB33barEv,
};
extern VTBL_ENTRY _ZTIN3aaa5EE131E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE131E[];
Class_Descriptor cd__ZN3aaa5EE131E = {  "_ZN3aaa5EE131E", // class name
  bases__ZN3aaa5EE131E, 2,
  &(vtc__ZN3aaa5EE131E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE131E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE131E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF131  : ::aaa::AA1 , ::aaa::BB3 {
  int pf;
  virtual void  foo(); // _ZN3aaa5FF1313fooEv
  ~FF131(); // tgen
  FF131(); // tgen
};
//SIG(-1 _ZN3aaa5FF131E) C1{ BC2{ v1 Fi} BC3{ v1 v2 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::FF131 ::foo(){vfunc_called(this, "_ZN3aaa5FF1313fooEv");}
aaa::FF131 ::~FF131(){ note_dtor("_ZN3aaa5FF131E", this);} // tgen
aaa::FF131 ::FF131(){ note_ctor("_ZN3aaa5FF131E", this);} // tgen
}
static void Test__ZN3aaa5FF131E()
{
  extern Class_Descriptor cd__ZN3aaa5FF131E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF131E, buf);
    ::aaa::FF131 *dp, &lv = *(dp=new (buf) ::aaa::FF131());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF131E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF131E)");
    check_base_class_offset(lv, (::aaa::AA1*), 0, "_ZN3aaa5FF131E");
    check_base_class_offset(lv, (::aaa::BB3*), ABISELECT(16,8), "_ZN3aaa5FF131E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF131E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF131E);
    dp->::aaa::FF131::~FF131();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF131E(Test__ZN3aaa5FF131E, "_ZN3aaa5FF131E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF131C1Ev();
extern void _ZN3aaa5FF131D1Ev();
Name_Map name_map__ZN3aaa5FF131E[] = {
  NSPAIR(_ZN3aaa5FF131C1Ev),
  NSPAIR(_ZN3aaa5FF131D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
static Base_Class bases__ZN3aaa5FF131E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF131E[];
extern void _ZN3aaa5FF1313fooEv();
extern void ABISELECT(_ZThn16_N3aaa5FF1313fooEv,_ZThn8_N3aaa5FF1313fooEv)();
extern void _ZN3aaa3BB33barEv();
static  VTBL_ENTRY vtc__ZN3aaa5FF131E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF131E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF1313fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF131E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF1313fooEv,_ZThn8_N3aaa5FF1313fooEv),
  (VTBL_ENTRY)&_ZN3aaa3BB33barEv,
};
extern VTBL_ENTRY _ZTIN3aaa5FF131E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF131E[];
Class_Descriptor cd__ZN3aaa5FF131E = {  "_ZN3aaa5FF131E", // class name
  bases__ZN3aaa5FF131E, 2,
  &(vtc__ZN3aaa5FF131E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF131E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF131E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE132  : ::aaa::AA1 , ::aaa::BB3 {
  int pe;
  virtual void  bar(); // _ZN3aaa5EE1323barEv
  ~EE132(); // tgen
  EE132(); // tgen
};
//SIG(-1 _ZN3aaa5EE132E) C1{ BC2{ v2 Fi} BC3{ v3 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::EE132 ::bar(){vfunc_called(this, "_ZN3aaa5EE1323barEv");}
aaa::EE132 ::~EE132(){ note_dtor("_ZN3aaa5EE132E", this);} // tgen
aaa::EE132 ::EE132(){ note_ctor("_ZN3aaa5EE132E", this);} // tgen
}
static void Test__ZN3aaa5EE132E()
{
  extern Class_Descriptor cd__ZN3aaa5EE132E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE132E, buf);
    ::aaa::EE132 *dp, &lv = *(dp=new (buf) ::aaa::EE132());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE132E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE132E)");
    check_base_class_offset(lv, (::aaa::AA1*), 0, "_ZN3aaa5EE132E");
    check_base_class_offset(lv, (::aaa::BB3*), ABISELECT(16,8), "_ZN3aaa5EE132E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE132E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE132E);
    dp->::aaa::EE132::~EE132();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE132E(Test__ZN3aaa5EE132E, "_ZN3aaa5EE132E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE132C1Ev();
extern void _ZN3aaa5EE132D1Ev();
Name_Map name_map__ZN3aaa5EE132E[] = {
  NSPAIR(_ZN3aaa5EE132C1Ev),
  NSPAIR(_ZN3aaa5EE132D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
static Base_Class bases__ZN3aaa5EE132E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE132E[];
extern void _ZN3aaa3AA13fooEv();
extern void _ZN3aaa5EE1323barEv();
extern void _ZN3aaa3BB33fooEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1323barEv,_ZThn8_N3aaa5EE1323barEv)();
static  VTBL_ENTRY vtc__ZN3aaa5EE132E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE132E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA13fooEv,
  (VTBL_ENTRY)&_ZN3aaa5EE1323barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE132E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1323barEv,_ZThn8_N3aaa5EE1323barEv),
};
extern VTBL_ENTRY _ZTIN3aaa5EE132E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE132E[];
Class_Descriptor cd__ZN3aaa5EE132E = {  "_ZN3aaa5EE132E", // class name
  bases__ZN3aaa5EE132E, 2,
  &(vtc__ZN3aaa5EE132E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE132E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE132E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF132  : ::aaa::AA1 , ::aaa::BB3 {
  int pf;
  virtual void  bar(); // _ZN3aaa5FF1323barEv
  ~FF132(); // tgen
  FF132(); // tgen
};
//SIG(-1 _ZN3aaa5FF132E) C1{ BC2{ v2 Fi} BC3{ v3 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::FF132 ::bar(){vfunc_called(this, "_ZN3aaa5FF1323barEv");}
aaa::FF132 ::~FF132(){ note_dtor("_ZN3aaa5FF132E", this);} // tgen
aaa::FF132 ::FF132(){ note_ctor("_ZN3aaa5FF132E", this);} // tgen
}
static void Test__ZN3aaa5FF132E()
{
  extern Class_Descriptor cd__ZN3aaa5FF132E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF132E, buf);
    ::aaa::FF132 *dp, &lv = *(dp=new (buf) ::aaa::FF132());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF132E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF132E)");
    check_base_class_offset(lv, (::aaa::AA1*), 0, "_ZN3aaa5FF132E");
    check_base_class_offset(lv, (::aaa::BB3*), ABISELECT(16,8), "_ZN3aaa5FF132E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF132E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF132E);
    dp->::aaa::FF132::~FF132();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF132E(Test__ZN3aaa5FF132E, "_ZN3aaa5FF132E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF132C1Ev();
extern void _ZN3aaa5FF132D1Ev();
Name_Map name_map__ZN3aaa5FF132E[] = {
  NSPAIR(_ZN3aaa5FF132C1Ev),
  NSPAIR(_ZN3aaa5FF132D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
static Base_Class bases__ZN3aaa5FF132E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF132E[];
extern void _ZN3aaa3AA13fooEv();
extern void _ZN3aaa5FF1323barEv();
extern void _ZN3aaa3BB33fooEv();
extern void ABISELECT(_ZThn16_N3aaa5FF1323barEv,_ZThn8_N3aaa5FF1323barEv)();
static  VTBL_ENTRY vtc__ZN3aaa5FF132E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF132E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA13fooEv,
  (VTBL_ENTRY)&_ZN3aaa5FF1323barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF132E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF1323barEv,_ZThn8_N3aaa5FF1323barEv),
};
extern VTBL_ENTRY _ZTIN3aaa5FF132E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF132E[];
Class_Descriptor cd__ZN3aaa5FF132E = {  "_ZN3aaa5FF132E", // class name
  bases__ZN3aaa5FF132E, 2,
  &(vtc__ZN3aaa5FF132E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF132E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF132E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE133  : ::aaa::AA1 , ::aaa::BB3 {
  int pe;
  virtual void  foo(); // _ZN3aaa5EE1333fooEv
  virtual void  bar(); // _ZN3aaa5EE1333barEv
  ~EE133(); // tgen
  EE133(); // tgen
};
//SIG(-1 _ZN3aaa5EE133E) C1{ BC2{ v1 Fi} BC3{ v1 v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::EE133 ::foo(){vfunc_called(this, "_ZN3aaa5EE1333fooEv");}
void  aaa::EE133 ::bar(){vfunc_called(this, "_ZN3aaa5EE1333barEv");}
aaa::EE133 ::~EE133(){ note_dtor("_ZN3aaa5EE133E", this);} // tgen
aaa::EE133 ::EE133(){ note_ctor("_ZN3aaa5EE133E", this);} // tgen
}
static void Test__ZN3aaa5EE133E()
{
  extern Class_Descriptor cd__ZN3aaa5EE133E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE133E, buf);
    ::aaa::EE133 *dp, &lv = *(dp=new (buf) ::aaa::EE133());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE133E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE133E)");
    check_base_class_offset(lv, (::aaa::AA1*), 0, "_ZN3aaa5EE133E");
    check_base_class_offset(lv, (::aaa::BB3*), ABISELECT(16,8), "_ZN3aaa5EE133E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE133E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE133E);
    dp->::aaa::EE133::~EE133();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE133E(Test__ZN3aaa5EE133E, "_ZN3aaa5EE133E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE133C1Ev();
extern void _ZN3aaa5EE133D1Ev();
Name_Map name_map__ZN3aaa5EE133E[] = {
  NSPAIR(_ZN3aaa5EE133C1Ev),
  NSPAIR(_ZN3aaa5EE133D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
static Base_Class bases__ZN3aaa5EE133E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE133E[];
extern void _ZN3aaa5EE1333fooEv();
extern void _ZN3aaa5EE1333barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1333fooEv,_ZThn8_N3aaa5EE1333fooEv)();
extern void ABISELECT(_ZThn16_N3aaa5EE1333barEv,_ZThn8_N3aaa5EE1333barEv)();
static  VTBL_ENTRY vtc__ZN3aaa5EE133E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE133E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1333fooEv,
  (VTBL_ENTRY)&_ZN3aaa5EE1333barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE133E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1333fooEv,_ZThn8_N3aaa5EE1333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1333barEv,_ZThn8_N3aaa5EE1333barEv),
};
extern VTBL_ENTRY _ZTIN3aaa5EE133E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE133E[];
Class_Descriptor cd__ZN3aaa5EE133E = {  "_ZN3aaa5EE133E", // class name
  bases__ZN3aaa5EE133E, 2,
  &(vtc__ZN3aaa5EE133E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE133E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE133E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF133  : ::aaa::AA1 , ::aaa::BB3 {
  int pf;
  virtual void  foo(); // _ZN3aaa5FF1333fooEv
  virtual void  bar(); // _ZN3aaa5FF1333barEv
  ~FF133(); // tgen
  FF133(); // tgen
};
//SIG(-1 _ZN3aaa5FF133E) C1{ BC2{ v1 Fi} BC3{ v1 v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::FF133 ::foo(){vfunc_called(this, "_ZN3aaa5FF1333fooEv");}
void  aaa::FF133 ::bar(){vfunc_called(this, "_ZN3aaa5FF1333barEv");}
aaa::FF133 ::~FF133(){ note_dtor("_ZN3aaa5FF133E", this);} // tgen
aaa::FF133 ::FF133(){ note_ctor("_ZN3aaa5FF133E", this);} // tgen
}
static void Test__ZN3aaa5FF133E()
{
  extern Class_Descriptor cd__ZN3aaa5FF133E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF133E, buf);
    ::aaa::FF133 *dp, &lv = *(dp=new (buf) ::aaa::FF133());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF133E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF133E)");
    check_base_class_offset(lv, (::aaa::AA1*), 0, "_ZN3aaa5FF133E");
    check_base_class_offset(lv, (::aaa::BB3*), ABISELECT(16,8), "_ZN3aaa5FF133E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF133E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF133E);
    dp->::aaa::FF133::~FF133();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF133E(Test__ZN3aaa5FF133E, "_ZN3aaa5FF133E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF133C1Ev();
extern void _ZN3aaa5FF133D1Ev();
Name_Map name_map__ZN3aaa5FF133E[] = {
  NSPAIR(_ZN3aaa5FF133C1Ev),
  NSPAIR(_ZN3aaa5FF133D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
static Base_Class bases__ZN3aaa5FF133E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF133E[];
extern void _ZN3aaa5FF1333fooEv();
extern void _ZN3aaa5FF1333barEv();
extern void ABISELECT(_ZThn16_N3aaa5FF1333fooEv,_ZThn8_N3aaa5FF1333fooEv)();
extern void ABISELECT(_ZThn16_N3aaa5FF1333barEv,_ZThn8_N3aaa5FF1333barEv)();
static  VTBL_ENTRY vtc__ZN3aaa5FF133E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF133E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF1333fooEv,
  (VTBL_ENTRY)&_ZN3aaa5FF1333barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF133E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF1333fooEv,_ZThn8_N3aaa5FF1333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF1333barEv,_ZThn8_N3aaa5FF1333barEv),
};
extern VTBL_ENTRY _ZTIN3aaa5FF133E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF133E[];
Class_Descriptor cd__ZN3aaa5FF133E = {  "_ZN3aaa5FF133E", // class name
  bases__ZN3aaa5FF133E, 2,
  &(vtc__ZN3aaa5FF133E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF133E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF133E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE211  : ::aaa::AA2 , ::aaa::BB1 {
  int pe;
  virtual void  foo(); // _ZN3aaa5EE2113fooEv
  ~EE211(); // tgen
  EE211(); // tgen
};
//SIG(-1 _ZN3aaa5EE211E) C1{ BC2{ v2 Fi} BC3{ v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::EE211 ::foo(){vfunc_called(this, "_ZN3aaa5EE2113fooEv");}
aaa::EE211 ::~EE211(){ note_dtor("_ZN3aaa5EE211E", this);} // tgen
aaa::EE211 ::EE211(){ note_ctor("_ZN3aaa5EE211E", this);} // tgen
}
static void Test__ZN3aaa5EE211E()
{
  extern Class_Descriptor cd__ZN3aaa5EE211E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE211E, buf);
    ::aaa::EE211 *dp, &lv = *(dp=new (buf) ::aaa::EE211());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE211E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE211E)");
    check_base_class_offset(lv, (::aaa::AA2*), 0, "_ZN3aaa5EE211E");
    check_base_class_offset(lv, (::aaa::BB1*), ABISELECT(16,8), "_ZN3aaa5EE211E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE211E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE211E);
    dp->::aaa::EE211::~EE211();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE211E(Test__ZN3aaa5EE211E, "_ZN3aaa5EE211E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE211C1Ev();
extern void _ZN3aaa5EE211D1Ev();
Name_Map name_map__ZN3aaa5EE211E[] = {
  NSPAIR(_ZN3aaa5EE211C1Ev),
  NSPAIR(_ZN3aaa5EE211D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
static Base_Class bases__ZN3aaa5EE211E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE211E[];
extern void _ZN3aaa3AA23barEv();
extern void _ZN3aaa5EE2113fooEv();
extern void ABISELECT(_ZThn16_N3aaa5EE2113fooEv,_ZThn8_N3aaa5EE2113fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa5EE211E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE211E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA23barEv,
  (VTBL_ENTRY)&_ZN3aaa5EE2113fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE211E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE2113fooEv,_ZThn8_N3aaa5EE2113fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa5EE211E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE211E[];
Class_Descriptor cd__ZN3aaa5EE211E = {  "_ZN3aaa5EE211E", // class name
  bases__ZN3aaa5EE211E, 2,
  &(vtc__ZN3aaa5EE211E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE211E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE211E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF211  : ::aaa::AA2 , ::aaa::BB1 {
  int pf;
  virtual void  foo(); // _ZN3aaa5FF2113fooEv
  ~FF211(); // tgen
  FF211(); // tgen
};
//SIG(-1 _ZN3aaa5FF211E) C1{ BC2{ v2 Fi} BC3{ v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::FF211 ::foo(){vfunc_called(this, "_ZN3aaa5FF2113fooEv");}
aaa::FF211 ::~FF211(){ note_dtor("_ZN3aaa5FF211E", this);} // tgen
aaa::FF211 ::FF211(){ note_ctor("_ZN3aaa5FF211E", this);} // tgen
}
static void Test__ZN3aaa5FF211E()
{
  extern Class_Descriptor cd__ZN3aaa5FF211E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF211E, buf);
    ::aaa::FF211 *dp, &lv = *(dp=new (buf) ::aaa::FF211());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF211E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF211E)");
    check_base_class_offset(lv, (::aaa::AA2*), 0, "_ZN3aaa5FF211E");
    check_base_class_offset(lv, (::aaa::BB1*), ABISELECT(16,8), "_ZN3aaa5FF211E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF211E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF211E);
    dp->::aaa::FF211::~FF211();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF211E(Test__ZN3aaa5FF211E, "_ZN3aaa5FF211E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF211C1Ev();
extern void _ZN3aaa5FF211D1Ev();
Name_Map name_map__ZN3aaa5FF211E[] = {
  NSPAIR(_ZN3aaa5FF211C1Ev),
  NSPAIR(_ZN3aaa5FF211D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
static Base_Class bases__ZN3aaa5FF211E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF211E[];
extern void _ZN3aaa3AA23barEv();
extern void _ZN3aaa5FF2113fooEv();
extern void ABISELECT(_ZThn16_N3aaa5FF2113fooEv,_ZThn8_N3aaa5FF2113fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa5FF211E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF211E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA23barEv,
  (VTBL_ENTRY)&_ZN3aaa5FF2113fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF211E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF2113fooEv,_ZThn8_N3aaa5FF2113fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa5FF211E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF211E[];
Class_Descriptor cd__ZN3aaa5FF211E = {  "_ZN3aaa5FF211E", // class name
  bases__ZN3aaa5FF211E, 2,
  &(vtc__ZN3aaa5FF211E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF211E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF211E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE212  : ::aaa::AA2 , ::aaa::BB1 {
  int pe;
  virtual void  bar(); // _ZN3aaa5EE2123barEv
  ~EE212(); // tgen
  EE212(); // tgen
};
//SIG(-1 _ZN3aaa5EE212E) C1{ BC2{ v1 Fi} BC3{ v2 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::EE212 ::bar(){vfunc_called(this, "_ZN3aaa5EE2123barEv");}
aaa::EE212 ::~EE212(){ note_dtor("_ZN3aaa5EE212E", this);} // tgen
aaa::EE212 ::EE212(){ note_ctor("_ZN3aaa5EE212E", this);} // tgen
}
static void Test__ZN3aaa5EE212E()
{
  extern Class_Descriptor cd__ZN3aaa5EE212E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE212E, buf);
    ::aaa::EE212 *dp, &lv = *(dp=new (buf) ::aaa::EE212());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE212E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE212E)");
    check_base_class_offset(lv, (::aaa::AA2*), 0, "_ZN3aaa5EE212E");
    check_base_class_offset(lv, (::aaa::BB1*), ABISELECT(16,8), "_ZN3aaa5EE212E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE212E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE212E);
    dp->::aaa::EE212::~EE212();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE212E(Test__ZN3aaa5EE212E, "_ZN3aaa5EE212E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE212C1Ev();
extern void _ZN3aaa5EE212D1Ev();
Name_Map name_map__ZN3aaa5EE212E[] = {
  NSPAIR(_ZN3aaa5EE212C1Ev),
  NSPAIR(_ZN3aaa5EE212D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
static Base_Class bases__ZN3aaa5EE212E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE212E[];
extern void _ZN3aaa5EE2123barEv();
extern void _ZN3aaa3BB13fooEv();
static  VTBL_ENTRY vtc__ZN3aaa5EE212E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE212E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE2123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE212E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB13fooEv,
};
extern VTBL_ENTRY _ZTIN3aaa5EE212E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE212E[];
Class_Descriptor cd__ZN3aaa5EE212E = {  "_ZN3aaa5EE212E", // class name
  bases__ZN3aaa5EE212E, 2,
  &(vtc__ZN3aaa5EE212E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE212E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE212E),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF212  : ::aaa::AA2 , ::aaa::BB1 {
  int pf;
  virtual void  bar(); // _ZN3aaa5FF2123barEv
  ~FF212(); // tgen
  FF212(); // tgen
};
//SIG(-1 _ZN3aaa5FF212E) C1{ BC2{ v1 Fi} BC3{ v2 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::FF212 ::bar(){vfunc_called(this, "_ZN3aaa5FF2123barEv");}
aaa::FF212 ::~FF212(){ note_dtor("_ZN3aaa5FF212E", this);} // tgen
aaa::FF212 ::FF212(){ note_ctor("_ZN3aaa5FF212E", this);} // tgen
}
static void Test__ZN3aaa5FF212E()
{
  extern Class_Descriptor cd__ZN3aaa5FF212E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF212E, buf);
    ::aaa::FF212 *dp, &lv = *(dp=new (buf) ::aaa::FF212());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF212E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF212E)");
    check_base_class_offset(lv, (::aaa::AA2*), 0, "_ZN3aaa5FF212E");
    check_base_class_offset(lv, (::aaa::BB1*), ABISELECT(16,8), "_ZN3aaa5FF212E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF212E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF212E);
    dp->::aaa::FF212::~FF212();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF212E(Test__ZN3aaa5FF212E, "_ZN3aaa5FF212E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF212C1Ev();
extern void _ZN3aaa5FF212D1Ev();
Name_Map name_map__ZN3aaa5FF212E[] = {
  NSPAIR(_ZN3aaa5FF212C1Ev),
  NSPAIR(_ZN3aaa5FF212D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
static Base_Class bases__ZN3aaa5FF212E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF212E[];
extern void _ZN3aaa5FF2123barEv();
extern void _ZN3aaa3BB13fooEv();
static  VTBL_ENTRY vtc__ZN3aaa5FF212E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF212E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF2123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF212E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB13fooEv,
};
extern VTBL_ENTRY _ZTIN3aaa5FF212E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF212E[];
Class_Descriptor cd__ZN3aaa5FF212E = {  "_ZN3aaa5FF212E", // class name
  bases__ZN3aaa5FF212E, 2,
  &(vtc__ZN3aaa5FF212E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF212E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF212E),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE213  : ::aaa::AA2 , ::aaa::BB1 {
  int pe;
  virtual void  foo(); // _ZN3aaa5EE2133fooEv
  virtual void  bar(); // _ZN3aaa5EE2133barEv
  ~EE213(); // tgen
  EE213(); // tgen
};
//SIG(-1 _ZN3aaa5EE213E) C1{ BC2{ v2 Fi} BC3{ v1 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::EE213 ::foo(){vfunc_called(this, "_ZN3aaa5EE2133fooEv");}
void  aaa::EE213 ::bar(){vfunc_called(this, "_ZN3aaa5EE2133barEv");}
aaa::EE213 ::~EE213(){ note_dtor("_ZN3aaa5EE213E", this);} // tgen
aaa::EE213 ::EE213(){ note_ctor("_ZN3aaa5EE213E", this);} // tgen
}
static void Test__ZN3aaa5EE213E()
{
  extern Class_Descriptor cd__ZN3aaa5EE213E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE213E, buf);
    ::aaa::EE213 *dp, &lv = *(dp=new (buf) ::aaa::EE213());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE213E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE213E)");
    check_base_class_offset(lv, (::aaa::AA2*), 0, "_ZN3aaa5EE213E");
    check_base_class_offset(lv, (::aaa::BB1*), ABISELECT(16,8), "_ZN3aaa5EE213E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE213E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE213E);
    dp->::aaa::EE213::~EE213();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE213E(Test__ZN3aaa5EE213E, "_ZN3aaa5EE213E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE213C1Ev();
extern void _ZN3aaa5EE213D1Ev();
Name_Map name_map__ZN3aaa5EE213E[] = {
  NSPAIR(_ZN3aaa5EE213C1Ev),
  NSPAIR(_ZN3aaa5EE213D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
static Base_Class bases__ZN3aaa5EE213E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE213E[];
extern void _ZN3aaa5EE2133barEv();
extern void _ZN3aaa5EE2133fooEv();
extern void ABISELECT(_ZThn16_N3aaa5EE2133fooEv,_ZThn8_N3aaa5EE2133fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa5EE213E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE213E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE2133barEv,
  (VTBL_ENTRY)&_ZN3aaa5EE2133fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE213E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE2133fooEv,_ZThn8_N3aaa5EE2133fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa5EE213E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE213E[];
Class_Descriptor cd__ZN3aaa5EE213E = {  "_ZN3aaa5EE213E", // class name
  bases__ZN3aaa5EE213E, 2,
  &(vtc__ZN3aaa5EE213E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE213E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE213E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF213  : ::aaa::AA2 , ::aaa::BB1 {
  int pf;
  virtual void  foo(); // _ZN3aaa5FF2133fooEv
  virtual void  bar(); // _ZN3aaa5FF2133barEv
  ~FF213(); // tgen
  FF213(); // tgen
};
//SIG(-1 _ZN3aaa5FF213E) C1{ BC2{ v2 Fi} BC3{ v1 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::FF213 ::foo(){vfunc_called(this, "_ZN3aaa5FF2133fooEv");}
void  aaa::FF213 ::bar(){vfunc_called(this, "_ZN3aaa5FF2133barEv");}
aaa::FF213 ::~FF213(){ note_dtor("_ZN3aaa5FF213E", this);} // tgen
aaa::FF213 ::FF213(){ note_ctor("_ZN3aaa5FF213E", this);} // tgen
}
static void Test__ZN3aaa5FF213E()
{
  extern Class_Descriptor cd__ZN3aaa5FF213E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF213E, buf);
    ::aaa::FF213 *dp, &lv = *(dp=new (buf) ::aaa::FF213());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF213E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF213E)");
    check_base_class_offset(lv, (::aaa::AA2*), 0, "_ZN3aaa5FF213E");
    check_base_class_offset(lv, (::aaa::BB1*), ABISELECT(16,8), "_ZN3aaa5FF213E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF213E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF213E);
    dp->::aaa::FF213::~FF213();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF213E(Test__ZN3aaa5FF213E, "_ZN3aaa5FF213E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF213C1Ev();
extern void _ZN3aaa5FF213D1Ev();
Name_Map name_map__ZN3aaa5FF213E[] = {
  NSPAIR(_ZN3aaa5FF213C1Ev),
  NSPAIR(_ZN3aaa5FF213D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
static Base_Class bases__ZN3aaa5FF213E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF213E[];
extern void _ZN3aaa5FF2133barEv();
extern void _ZN3aaa5FF2133fooEv();
extern void ABISELECT(_ZThn16_N3aaa5FF2133fooEv,_ZThn8_N3aaa5FF2133fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa5FF213E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF213E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF2133barEv,
  (VTBL_ENTRY)&_ZN3aaa5FF2133fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF213E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF2133fooEv,_ZThn8_N3aaa5FF2133fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa5FF213E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF213E[];
Class_Descriptor cd__ZN3aaa5FF213E = {  "_ZN3aaa5FF213E", // class name
  bases__ZN3aaa5FF213E, 2,
  &(vtc__ZN3aaa5FF213E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF213E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF213E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE221  : ::aaa::AA2 , ::aaa::BB2 {
  int pe;
  virtual void  foo(); // _ZN3aaa5EE2213fooEv
  ~EE221(); // tgen
  EE221(); // tgen
};
//SIG(-1 _ZN3aaa5EE221E) C1{ BC2{ v2 Fi} BC3{ v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::EE221 ::foo(){vfunc_called(this, "_ZN3aaa5EE2213fooEv");}
aaa::EE221 ::~EE221(){ note_dtor("_ZN3aaa5EE221E", this);} // tgen
aaa::EE221 ::EE221(){ note_ctor("_ZN3aaa5EE221E", this);} // tgen
}
static void Test__ZN3aaa5EE221E()
{
  extern Class_Descriptor cd__ZN3aaa5EE221E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE221E, buf);
    ::aaa::EE221 *dp, &lv = *(dp=new (buf) ::aaa::EE221());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE221E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE221E)");
    check_base_class_offset(lv, (::aaa::AA2*), 0, "_ZN3aaa5EE221E");
    check_base_class_offset(lv, (::aaa::BB2*), ABISELECT(16,8), "_ZN3aaa5EE221E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE221E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE221E);
    dp->::aaa::EE221::~EE221();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE221E(Test__ZN3aaa5EE221E, "_ZN3aaa5EE221E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE221C1Ev();
extern void _ZN3aaa5EE221D1Ev();
Name_Map name_map__ZN3aaa5EE221E[] = {
  NSPAIR(_ZN3aaa5EE221C1Ev),
  NSPAIR(_ZN3aaa5EE221D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
static Base_Class bases__ZN3aaa5EE221E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE221E[];
extern void _ZN3aaa3AA23barEv();
extern void _ZN3aaa5EE2213fooEv();
extern void _ZN3aaa3BB23barEv();
static  VTBL_ENTRY vtc__ZN3aaa5EE221E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE221E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA23barEv,
  (VTBL_ENTRY)&_ZN3aaa5EE2213fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE221E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB23barEv,
};
extern VTBL_ENTRY _ZTIN3aaa5EE221E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE221E[];
Class_Descriptor cd__ZN3aaa5EE221E = {  "_ZN3aaa5EE221E", // class name
  bases__ZN3aaa5EE221E, 2,
  &(vtc__ZN3aaa5EE221E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE221E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE221E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF221  : ::aaa::AA2 , ::aaa::BB2 {
  int pf;
  virtual void  foo(); // _ZN3aaa5FF2213fooEv
  ~FF221(); // tgen
  FF221(); // tgen
};
//SIG(-1 _ZN3aaa5FF221E) C1{ BC2{ v2 Fi} BC3{ v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::FF221 ::foo(){vfunc_called(this, "_ZN3aaa5FF2213fooEv");}
aaa::FF221 ::~FF221(){ note_dtor("_ZN3aaa5FF221E", this);} // tgen
aaa::FF221 ::FF221(){ note_ctor("_ZN3aaa5FF221E", this);} // tgen
}
static void Test__ZN3aaa5FF221E()
{
  extern Class_Descriptor cd__ZN3aaa5FF221E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF221E, buf);
    ::aaa::FF221 *dp, &lv = *(dp=new (buf) ::aaa::FF221());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF221E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF221E)");
    check_base_class_offset(lv, (::aaa::AA2*), 0, "_ZN3aaa5FF221E");
    check_base_class_offset(lv, (::aaa::BB2*), ABISELECT(16,8), "_ZN3aaa5FF221E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF221E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF221E);
    dp->::aaa::FF221::~FF221();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF221E(Test__ZN3aaa5FF221E, "_ZN3aaa5FF221E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF221C1Ev();
extern void _ZN3aaa5FF221D1Ev();
Name_Map name_map__ZN3aaa5FF221E[] = {
  NSPAIR(_ZN3aaa5FF221C1Ev),
  NSPAIR(_ZN3aaa5FF221D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
static Base_Class bases__ZN3aaa5FF221E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF221E[];
extern void _ZN3aaa3AA23barEv();
extern void _ZN3aaa5FF2213fooEv();
extern void _ZN3aaa3BB23barEv();
static  VTBL_ENTRY vtc__ZN3aaa5FF221E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF221E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA23barEv,
  (VTBL_ENTRY)&_ZN3aaa5FF2213fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF221E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB23barEv,
};
extern VTBL_ENTRY _ZTIN3aaa5FF221E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF221E[];
Class_Descriptor cd__ZN3aaa5FF221E = {  "_ZN3aaa5FF221E", // class name
  bases__ZN3aaa5FF221E, 2,
  &(vtc__ZN3aaa5FF221E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF221E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF221E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE222  : ::aaa::AA2 , ::aaa::BB2 {
  int pe;
  virtual void  bar(); // _ZN3aaa5EE2223barEv
  ~EE222(); // tgen
  EE222(); // tgen
};
//SIG(-1 _ZN3aaa5EE222E) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::EE222 ::bar(){vfunc_called(this, "_ZN3aaa5EE2223barEv");}
aaa::EE222 ::~EE222(){ note_dtor("_ZN3aaa5EE222E", this);} // tgen
aaa::EE222 ::EE222(){ note_ctor("_ZN3aaa5EE222E", this);} // tgen
}
static void Test__ZN3aaa5EE222E()
{
  extern Class_Descriptor cd__ZN3aaa5EE222E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE222E, buf);
    ::aaa::EE222 *dp, &lv = *(dp=new (buf) ::aaa::EE222());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE222E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE222E)");
    check_base_class_offset(lv, (::aaa::AA2*), 0, "_ZN3aaa5EE222E");
    check_base_class_offset(lv, (::aaa::BB2*), ABISELECT(16,8), "_ZN3aaa5EE222E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE222E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE222E);
    dp->::aaa::EE222::~EE222();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE222E(Test__ZN3aaa5EE222E, "_ZN3aaa5EE222E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE222C1Ev();
extern void _ZN3aaa5EE222D1Ev();
Name_Map name_map__ZN3aaa5EE222E[] = {
  NSPAIR(_ZN3aaa5EE222C1Ev),
  NSPAIR(_ZN3aaa5EE222D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
static Base_Class bases__ZN3aaa5EE222E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE222E[];
extern void _ZN3aaa5EE2223barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE2223barEv,_ZThn8_N3aaa5EE2223barEv)();
static  VTBL_ENTRY vtc__ZN3aaa5EE222E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE222E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE2223barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE222E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE2223barEv,_ZThn8_N3aaa5EE2223barEv),
};
extern VTBL_ENTRY _ZTIN3aaa5EE222E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE222E[];
Class_Descriptor cd__ZN3aaa5EE222E = {  "_ZN3aaa5EE222E", // class name
  bases__ZN3aaa5EE222E, 2,
  &(vtc__ZN3aaa5EE222E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE222E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE222E),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF222  : ::aaa::AA2 , ::aaa::BB2 {
  int pf;
  virtual void  bar(); // _ZN3aaa5FF2223barEv
  ~FF222(); // tgen
  FF222(); // tgen
};
//SIG(-1 _ZN3aaa5FF222E) C1{ BC2{ v1 Fi} BC3{ v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::FF222 ::bar(){vfunc_called(this, "_ZN3aaa5FF2223barEv");}
aaa::FF222 ::~FF222(){ note_dtor("_ZN3aaa5FF222E", this);} // tgen
aaa::FF222 ::FF222(){ note_ctor("_ZN3aaa5FF222E", this);} // tgen
}
static void Test__ZN3aaa5FF222E()
{
  extern Class_Descriptor cd__ZN3aaa5FF222E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF222E, buf);
    ::aaa::FF222 *dp, &lv = *(dp=new (buf) ::aaa::FF222());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF222E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF222E)");
    check_base_class_offset(lv, (::aaa::AA2*), 0, "_ZN3aaa5FF222E");
    check_base_class_offset(lv, (::aaa::BB2*), ABISELECT(16,8), "_ZN3aaa5FF222E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF222E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF222E);
    dp->::aaa::FF222::~FF222();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF222E(Test__ZN3aaa5FF222E, "_ZN3aaa5FF222E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF222C1Ev();
extern void _ZN3aaa5FF222D1Ev();
Name_Map name_map__ZN3aaa5FF222E[] = {
  NSPAIR(_ZN3aaa5FF222C1Ev),
  NSPAIR(_ZN3aaa5FF222D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
static Base_Class bases__ZN3aaa5FF222E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF222E[];
extern void _ZN3aaa5FF2223barEv();
extern void ABISELECT(_ZThn16_N3aaa5FF2223barEv,_ZThn8_N3aaa5FF2223barEv)();
static  VTBL_ENTRY vtc__ZN3aaa5FF222E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF222E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF2223barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF222E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF2223barEv,_ZThn8_N3aaa5FF2223barEv),
};
extern VTBL_ENTRY _ZTIN3aaa5FF222E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF222E[];
Class_Descriptor cd__ZN3aaa5FF222E = {  "_ZN3aaa5FF222E", // class name
  bases__ZN3aaa5FF222E, 2,
  &(vtc__ZN3aaa5FF222E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF222E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF222E),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE223  : ::aaa::AA2 , ::aaa::BB2 {
  int pe;
  virtual void  foo(); // _ZN3aaa5EE2233fooEv
  virtual void  bar(); // _ZN3aaa5EE2233barEv
  ~EE223(); // tgen
  EE223(); // tgen
};
//SIG(-1 _ZN3aaa5EE223E) C1{ BC2{ v2 Fi} BC3{ v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::EE223 ::foo(){vfunc_called(this, "_ZN3aaa5EE2233fooEv");}
void  aaa::EE223 ::bar(){vfunc_called(this, "_ZN3aaa5EE2233barEv");}
aaa::EE223 ::~EE223(){ note_dtor("_ZN3aaa5EE223E", this);} // tgen
aaa::EE223 ::EE223(){ note_ctor("_ZN3aaa5EE223E", this);} // tgen
}
static void Test__ZN3aaa5EE223E()
{
  extern Class_Descriptor cd__ZN3aaa5EE223E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE223E, buf);
    ::aaa::EE223 *dp, &lv = *(dp=new (buf) ::aaa::EE223());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE223E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE223E)");
    check_base_class_offset(lv, (::aaa::AA2*), 0, "_ZN3aaa5EE223E");
    check_base_class_offset(lv, (::aaa::BB2*), ABISELECT(16,8), "_ZN3aaa5EE223E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE223E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE223E);
    dp->::aaa::EE223::~EE223();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE223E(Test__ZN3aaa5EE223E, "_ZN3aaa5EE223E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE223C1Ev();
extern void _ZN3aaa5EE223D1Ev();
Name_Map name_map__ZN3aaa5EE223E[] = {
  NSPAIR(_ZN3aaa5EE223C1Ev),
  NSPAIR(_ZN3aaa5EE223D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
static Base_Class bases__ZN3aaa5EE223E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE223E[];
extern void _ZN3aaa5EE2233barEv();
extern void _ZN3aaa5EE2233fooEv();
extern void ABISELECT(_ZThn16_N3aaa5EE2233barEv,_ZThn8_N3aaa5EE2233barEv)();
static  VTBL_ENTRY vtc__ZN3aaa5EE223E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE223E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE2233barEv,
  (VTBL_ENTRY)&_ZN3aaa5EE2233fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE223E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE2233barEv,_ZThn8_N3aaa5EE2233barEv),
};
extern VTBL_ENTRY _ZTIN3aaa5EE223E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE223E[];
Class_Descriptor cd__ZN3aaa5EE223E = {  "_ZN3aaa5EE223E", // class name
  bases__ZN3aaa5EE223E, 2,
  &(vtc__ZN3aaa5EE223E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE223E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE223E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF223  : ::aaa::AA2 , ::aaa::BB2 {
  int pf;
  virtual void  foo(); // _ZN3aaa5FF2233fooEv
  virtual void  bar(); // _ZN3aaa5FF2233barEv
  ~FF223(); // tgen
  FF223(); // tgen
};
//SIG(-1 _ZN3aaa5FF223E) C1{ BC2{ v2 Fi} BC3{ v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::FF223 ::foo(){vfunc_called(this, "_ZN3aaa5FF2233fooEv");}
void  aaa::FF223 ::bar(){vfunc_called(this, "_ZN3aaa5FF2233barEv");}
aaa::FF223 ::~FF223(){ note_dtor("_ZN3aaa5FF223E", this);} // tgen
aaa::FF223 ::FF223(){ note_ctor("_ZN3aaa5FF223E", this);} // tgen
}
static void Test__ZN3aaa5FF223E()
{
  extern Class_Descriptor cd__ZN3aaa5FF223E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF223E, buf);
    ::aaa::FF223 *dp, &lv = *(dp=new (buf) ::aaa::FF223());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF223E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF223E)");
    check_base_class_offset(lv, (::aaa::AA2*), 0, "_ZN3aaa5FF223E");
    check_base_class_offset(lv, (::aaa::BB2*), ABISELECT(16,8), "_ZN3aaa5FF223E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF223E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF223E);
    dp->::aaa::FF223::~FF223();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF223E(Test__ZN3aaa5FF223E, "_ZN3aaa5FF223E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF223C1Ev();
extern void _ZN3aaa5FF223D1Ev();
Name_Map name_map__ZN3aaa5FF223E[] = {
  NSPAIR(_ZN3aaa5FF223C1Ev),
  NSPAIR(_ZN3aaa5FF223D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
static Base_Class bases__ZN3aaa5FF223E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF223E[];
extern void _ZN3aaa5FF2233barEv();
extern void _ZN3aaa5FF2233fooEv();
extern void ABISELECT(_ZThn16_N3aaa5FF2233barEv,_ZThn8_N3aaa5FF2233barEv)();
static  VTBL_ENTRY vtc__ZN3aaa5FF223E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF223E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF2233barEv,
  (VTBL_ENTRY)&_ZN3aaa5FF2233fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF223E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF2233barEv,_ZThn8_N3aaa5FF2233barEv),
};
extern VTBL_ENTRY _ZTIN3aaa5FF223E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF223E[];
Class_Descriptor cd__ZN3aaa5FF223E = {  "_ZN3aaa5FF223E", // class name
  bases__ZN3aaa5FF223E, 2,
  &(vtc__ZN3aaa5FF223E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF223E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF223E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE231  : ::aaa::AA2 , ::aaa::BB3 {
  int pe;
  virtual void  foo(); // _ZN3aaa5EE2313fooEv
  ~EE231(); // tgen
  EE231(); // tgen
};
//SIG(-1 _ZN3aaa5EE231E) C1{ BC2{ v2 Fi} BC3{ v1 v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::EE231 ::foo(){vfunc_called(this, "_ZN3aaa5EE2313fooEv");}
aaa::EE231 ::~EE231(){ note_dtor("_ZN3aaa5EE231E", this);} // tgen
aaa::EE231 ::EE231(){ note_ctor("_ZN3aaa5EE231E", this);} // tgen
}
static void Test__ZN3aaa5EE231E()
{
  extern Class_Descriptor cd__ZN3aaa5EE231E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE231E, buf);
    ::aaa::EE231 *dp, &lv = *(dp=new (buf) ::aaa::EE231());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE231E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE231E)");
    check_base_class_offset(lv, (::aaa::AA2*), 0, "_ZN3aaa5EE231E");
    check_base_class_offset(lv, (::aaa::BB3*), ABISELECT(16,8), "_ZN3aaa5EE231E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE231E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE231E);
    dp->::aaa::EE231::~EE231();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE231E(Test__ZN3aaa5EE231E, "_ZN3aaa5EE231E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE231C1Ev();
extern void _ZN3aaa5EE231D1Ev();
Name_Map name_map__ZN3aaa5EE231E[] = {
  NSPAIR(_ZN3aaa5EE231C1Ev),
  NSPAIR(_ZN3aaa5EE231D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
static Base_Class bases__ZN3aaa5EE231E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE231E[];
extern void _ZN3aaa3AA23barEv();
extern void _ZN3aaa5EE2313fooEv();
extern void ABISELECT(_ZThn16_N3aaa5EE2313fooEv,_ZThn8_N3aaa5EE2313fooEv)();
extern void _ZN3aaa3BB33barEv();
static  VTBL_ENTRY vtc__ZN3aaa5EE231E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE231E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA23barEv,
  (VTBL_ENTRY)&_ZN3aaa5EE2313fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE231E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE2313fooEv,_ZThn8_N3aaa5EE2313fooEv),
  (VTBL_ENTRY)&_ZN3aaa3BB33barEv,
};
extern VTBL_ENTRY _ZTIN3aaa5EE231E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE231E[];
Class_Descriptor cd__ZN3aaa5EE231E = {  "_ZN3aaa5EE231E", // class name
  bases__ZN3aaa5EE231E, 2,
  &(vtc__ZN3aaa5EE231E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE231E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE231E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF231  : ::aaa::AA2 , ::aaa::BB3 {
  int pf;
  virtual void  foo(); // _ZN3aaa5FF2313fooEv
  ~FF231(); // tgen
  FF231(); // tgen
};
//SIG(-1 _ZN3aaa5FF231E) C1{ BC2{ v2 Fi} BC3{ v1 v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::FF231 ::foo(){vfunc_called(this, "_ZN3aaa5FF2313fooEv");}
aaa::FF231 ::~FF231(){ note_dtor("_ZN3aaa5FF231E", this);} // tgen
aaa::FF231 ::FF231(){ note_ctor("_ZN3aaa5FF231E", this);} // tgen
}
static void Test__ZN3aaa5FF231E()
{
  extern Class_Descriptor cd__ZN3aaa5FF231E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF231E, buf);
    ::aaa::FF231 *dp, &lv = *(dp=new (buf) ::aaa::FF231());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF231E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF231E)");
    check_base_class_offset(lv, (::aaa::AA2*), 0, "_ZN3aaa5FF231E");
    check_base_class_offset(lv, (::aaa::BB3*), ABISELECT(16,8), "_ZN3aaa5FF231E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF231E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF231E);
    dp->::aaa::FF231::~FF231();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF231E(Test__ZN3aaa5FF231E, "_ZN3aaa5FF231E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF231C1Ev();
extern void _ZN3aaa5FF231D1Ev();
Name_Map name_map__ZN3aaa5FF231E[] = {
  NSPAIR(_ZN3aaa5FF231C1Ev),
  NSPAIR(_ZN3aaa5FF231D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
static Base_Class bases__ZN3aaa5FF231E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF231E[];
extern void _ZN3aaa3AA23barEv();
extern void _ZN3aaa5FF2313fooEv();
extern void ABISELECT(_ZThn16_N3aaa5FF2313fooEv,_ZThn8_N3aaa5FF2313fooEv)();
extern void _ZN3aaa3BB33barEv();
static  VTBL_ENTRY vtc__ZN3aaa5FF231E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF231E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA23barEv,
  (VTBL_ENTRY)&_ZN3aaa5FF2313fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF231E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF2313fooEv,_ZThn8_N3aaa5FF2313fooEv),
  (VTBL_ENTRY)&_ZN3aaa3BB33barEv,
};
extern VTBL_ENTRY _ZTIN3aaa5FF231E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF231E[];
Class_Descriptor cd__ZN3aaa5FF231E = {  "_ZN3aaa5FF231E", // class name
  bases__ZN3aaa5FF231E, 2,
  &(vtc__ZN3aaa5FF231E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF231E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF231E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE232  : ::aaa::AA2 , ::aaa::BB3 {
  int pe;
  virtual void  bar(); // _ZN3aaa5EE2323barEv
  ~EE232(); // tgen
  EE232(); // tgen
};
//SIG(-1 _ZN3aaa5EE232E) C1{ BC2{ v1 Fi} BC3{ v2 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::EE232 ::bar(){vfunc_called(this, "_ZN3aaa5EE2323barEv");}
aaa::EE232 ::~EE232(){ note_dtor("_ZN3aaa5EE232E", this);} // tgen
aaa::EE232 ::EE232(){ note_ctor("_ZN3aaa5EE232E", this);} // tgen
}
static void Test__ZN3aaa5EE232E()
{
  extern Class_Descriptor cd__ZN3aaa5EE232E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE232E, buf);
    ::aaa::EE232 *dp, &lv = *(dp=new (buf) ::aaa::EE232());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE232E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE232E)");
    check_base_class_offset(lv, (::aaa::AA2*), 0, "_ZN3aaa5EE232E");
    check_base_class_offset(lv, (::aaa::BB3*), ABISELECT(16,8), "_ZN3aaa5EE232E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE232E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE232E);
    dp->::aaa::EE232::~EE232();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE232E(Test__ZN3aaa5EE232E, "_ZN3aaa5EE232E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE232C1Ev();
extern void _ZN3aaa5EE232D1Ev();
Name_Map name_map__ZN3aaa5EE232E[] = {
  NSPAIR(_ZN3aaa5EE232C1Ev),
  NSPAIR(_ZN3aaa5EE232D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
static Base_Class bases__ZN3aaa5EE232E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE232E[];
extern void _ZN3aaa5EE2323barEv();
extern void _ZN3aaa3BB33fooEv();
extern void ABISELECT(_ZThn16_N3aaa5EE2323barEv,_ZThn8_N3aaa5EE2323barEv)();
static  VTBL_ENTRY vtc__ZN3aaa5EE232E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE232E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE2323barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE232E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE2323barEv,_ZThn8_N3aaa5EE2323barEv),
};
extern VTBL_ENTRY _ZTIN3aaa5EE232E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE232E[];
Class_Descriptor cd__ZN3aaa5EE232E = {  "_ZN3aaa5EE232E", // class name
  bases__ZN3aaa5EE232E, 2,
  &(vtc__ZN3aaa5EE232E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE232E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE232E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF232  : ::aaa::AA2 , ::aaa::BB3 {
  int pf;
  virtual void  bar(); // _ZN3aaa5FF2323barEv
  ~FF232(); // tgen
  FF232(); // tgen
};
//SIG(-1 _ZN3aaa5FF232E) C1{ BC2{ v1 Fi} BC3{ v2 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::FF232 ::bar(){vfunc_called(this, "_ZN3aaa5FF2323barEv");}
aaa::FF232 ::~FF232(){ note_dtor("_ZN3aaa5FF232E", this);} // tgen
aaa::FF232 ::FF232(){ note_ctor("_ZN3aaa5FF232E", this);} // tgen
}
static void Test__ZN3aaa5FF232E()
{
  extern Class_Descriptor cd__ZN3aaa5FF232E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF232E, buf);
    ::aaa::FF232 *dp, &lv = *(dp=new (buf) ::aaa::FF232());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF232E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF232E)");
    check_base_class_offset(lv, (::aaa::AA2*), 0, "_ZN3aaa5FF232E");
    check_base_class_offset(lv, (::aaa::BB3*), ABISELECT(16,8), "_ZN3aaa5FF232E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF232E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF232E);
    dp->::aaa::FF232::~FF232();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF232E(Test__ZN3aaa5FF232E, "_ZN3aaa5FF232E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF232C1Ev();
extern void _ZN3aaa5FF232D1Ev();
Name_Map name_map__ZN3aaa5FF232E[] = {
  NSPAIR(_ZN3aaa5FF232C1Ev),
  NSPAIR(_ZN3aaa5FF232D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
static Base_Class bases__ZN3aaa5FF232E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF232E[];
extern void _ZN3aaa5FF2323barEv();
extern void _ZN3aaa3BB33fooEv();
extern void ABISELECT(_ZThn16_N3aaa5FF2323barEv,_ZThn8_N3aaa5FF2323barEv)();
static  VTBL_ENTRY vtc__ZN3aaa5FF232E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF232E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF2323barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF232E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF2323barEv,_ZThn8_N3aaa5FF2323barEv),
};
extern VTBL_ENTRY _ZTIN3aaa5FF232E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF232E[];
Class_Descriptor cd__ZN3aaa5FF232E = {  "_ZN3aaa5FF232E", // class name
  bases__ZN3aaa5FF232E, 2,
  &(vtc__ZN3aaa5FF232E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF232E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF232E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE233  : ::aaa::AA2 , ::aaa::BB3 {
  int pe;
  virtual void  foo(); // _ZN3aaa5EE2333fooEv
  virtual void  bar(); // _ZN3aaa5EE2333barEv
  ~EE233(); // tgen
  EE233(); // tgen
};
//SIG(-1 _ZN3aaa5EE233E) C1{ BC2{ v2 Fi} BC3{ v1 v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::EE233 ::foo(){vfunc_called(this, "_ZN3aaa5EE2333fooEv");}
void  aaa::EE233 ::bar(){vfunc_called(this, "_ZN3aaa5EE2333barEv");}
aaa::EE233 ::~EE233(){ note_dtor("_ZN3aaa5EE233E", this);} // tgen
aaa::EE233 ::EE233(){ note_ctor("_ZN3aaa5EE233E", this);} // tgen
}
static void Test__ZN3aaa5EE233E()
{
  extern Class_Descriptor cd__ZN3aaa5EE233E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE233E, buf);
    ::aaa::EE233 *dp, &lv = *(dp=new (buf) ::aaa::EE233());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE233E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE233E)");
    check_base_class_offset(lv, (::aaa::AA2*), 0, "_ZN3aaa5EE233E");
    check_base_class_offset(lv, (::aaa::BB3*), ABISELECT(16,8), "_ZN3aaa5EE233E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE233E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE233E);
    dp->::aaa::EE233::~EE233();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE233E(Test__ZN3aaa5EE233E, "_ZN3aaa5EE233E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE233C1Ev();
extern void _ZN3aaa5EE233D1Ev();
Name_Map name_map__ZN3aaa5EE233E[] = {
  NSPAIR(_ZN3aaa5EE233C1Ev),
  NSPAIR(_ZN3aaa5EE233D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
static Base_Class bases__ZN3aaa5EE233E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE233E[];
extern void _ZN3aaa5EE2333barEv();
extern void _ZN3aaa5EE2333fooEv();
extern void ABISELECT(_ZThn16_N3aaa5EE2333fooEv,_ZThn8_N3aaa5EE2333fooEv)();
extern void ABISELECT(_ZThn16_N3aaa5EE2333barEv,_ZThn8_N3aaa5EE2333barEv)();
static  VTBL_ENTRY vtc__ZN3aaa5EE233E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE233E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE2333barEv,
  (VTBL_ENTRY)&_ZN3aaa5EE2333fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE233E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE2333fooEv,_ZThn8_N3aaa5EE2333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE2333barEv,_ZThn8_N3aaa5EE2333barEv),
};
extern VTBL_ENTRY _ZTIN3aaa5EE233E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE233E[];
Class_Descriptor cd__ZN3aaa5EE233E = {  "_ZN3aaa5EE233E", // class name
  bases__ZN3aaa5EE233E, 2,
  &(vtc__ZN3aaa5EE233E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE233E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE233E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF233  : ::aaa::AA2 , ::aaa::BB3 {
  int pf;
  virtual void  foo(); // _ZN3aaa5FF2333fooEv
  virtual void  bar(); // _ZN3aaa5FF2333barEv
  ~FF233(); // tgen
  FF233(); // tgen
};
//SIG(-1 _ZN3aaa5FF233E) C1{ BC2{ v2 Fi} BC3{ v1 v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::FF233 ::foo(){vfunc_called(this, "_ZN3aaa5FF2333fooEv");}
void  aaa::FF233 ::bar(){vfunc_called(this, "_ZN3aaa5FF2333barEv");}
aaa::FF233 ::~FF233(){ note_dtor("_ZN3aaa5FF233E", this);} // tgen
aaa::FF233 ::FF233(){ note_ctor("_ZN3aaa5FF233E", this);} // tgen
}
static void Test__ZN3aaa5FF233E()
{
  extern Class_Descriptor cd__ZN3aaa5FF233E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF233E, buf);
    ::aaa::FF233 *dp, &lv = *(dp=new (buf) ::aaa::FF233());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF233E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF233E)");
    check_base_class_offset(lv, (::aaa::AA2*), 0, "_ZN3aaa5FF233E");
    check_base_class_offset(lv, (::aaa::BB3*), ABISELECT(16,8), "_ZN3aaa5FF233E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF233E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF233E);
    dp->::aaa::FF233::~FF233();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF233E(Test__ZN3aaa5FF233E, "_ZN3aaa5FF233E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF233C1Ev();
extern void _ZN3aaa5FF233D1Ev();
Name_Map name_map__ZN3aaa5FF233E[] = {
  NSPAIR(_ZN3aaa5FF233C1Ev),
  NSPAIR(_ZN3aaa5FF233D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
static Base_Class bases__ZN3aaa5FF233E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF233E[];
extern void _ZN3aaa5FF2333barEv();
extern void _ZN3aaa5FF2333fooEv();
extern void ABISELECT(_ZThn16_N3aaa5FF2333fooEv,_ZThn8_N3aaa5FF2333fooEv)();
extern void ABISELECT(_ZThn16_N3aaa5FF2333barEv,_ZThn8_N3aaa5FF2333barEv)();
static  VTBL_ENTRY vtc__ZN3aaa5FF233E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF233E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF2333barEv,
  (VTBL_ENTRY)&_ZN3aaa5FF2333fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF233E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF2333fooEv,_ZThn8_N3aaa5FF2333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF2333barEv,_ZThn8_N3aaa5FF2333barEv),
};
extern VTBL_ENTRY _ZTIN3aaa5FF233E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF233E[];
Class_Descriptor cd__ZN3aaa5FF233E = {  "_ZN3aaa5FF233E", // class name
  bases__ZN3aaa5FF233E, 2,
  &(vtc__ZN3aaa5FF233E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF233E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF233E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE311  : ::aaa::AA3 , ::aaa::BB1 {
  int pe;
  virtual void  foo(); // _ZN3aaa5EE3113fooEv
  ~EE311(); // tgen
  EE311(); // tgen
};
//SIG(-1 _ZN3aaa5EE311E) C1{ BC2{ v1 v2 Fi} BC3{ v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::EE311 ::foo(){vfunc_called(this, "_ZN3aaa5EE3113fooEv");}
aaa::EE311 ::~EE311(){ note_dtor("_ZN3aaa5EE311E", this);} // tgen
aaa::EE311 ::EE311(){ note_ctor("_ZN3aaa5EE311E", this);} // tgen
}
static void Test__ZN3aaa5EE311E()
{
  extern Class_Descriptor cd__ZN3aaa5EE311E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE311E, buf);
    ::aaa::EE311 *dp, &lv = *(dp=new (buf) ::aaa::EE311());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE311E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE311E)");
    check_base_class_offset(lv, (::aaa::AA3*), 0, "_ZN3aaa5EE311E");
    check_base_class_offset(lv, (::aaa::BB1*), ABISELECT(16,8), "_ZN3aaa5EE311E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE311E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE311E);
    dp->::aaa::EE311::~EE311();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE311E(Test__ZN3aaa5EE311E, "_ZN3aaa5EE311E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE311C1Ev();
extern void _ZN3aaa5EE311D1Ev();
Name_Map name_map__ZN3aaa5EE311E[] = {
  NSPAIR(_ZN3aaa5EE311C1Ev),
  NSPAIR(_ZN3aaa5EE311D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
static Base_Class bases__ZN3aaa5EE311E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE311E[];
extern void _ZN3aaa5EE3113fooEv();
extern void _ZN3aaa3AA33barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE3113fooEv,_ZThn8_N3aaa5EE3113fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa5EE311E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE311E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE3113fooEv,
  (VTBL_ENTRY)&_ZN3aaa3AA33barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE311E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE3113fooEv,_ZThn8_N3aaa5EE3113fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa5EE311E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE311E[];
Class_Descriptor cd__ZN3aaa5EE311E = {  "_ZN3aaa5EE311E", // class name
  bases__ZN3aaa5EE311E, 2,
  &(vtc__ZN3aaa5EE311E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE311E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE311E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF311  : ::aaa::AA3 , ::aaa::BB1 {
  int pf;
  virtual void  foo(); // _ZN3aaa5FF3113fooEv
  ~FF311(); // tgen
  FF311(); // tgen
};
//SIG(-1 _ZN3aaa5FF311E) C1{ BC2{ v1 v2 Fi} BC3{ v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::FF311 ::foo(){vfunc_called(this, "_ZN3aaa5FF3113fooEv");}
aaa::FF311 ::~FF311(){ note_dtor("_ZN3aaa5FF311E", this);} // tgen
aaa::FF311 ::FF311(){ note_ctor("_ZN3aaa5FF311E", this);} // tgen
}
static void Test__ZN3aaa5FF311E()
{
  extern Class_Descriptor cd__ZN3aaa5FF311E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF311E, buf);
    ::aaa::FF311 *dp, &lv = *(dp=new (buf) ::aaa::FF311());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF311E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF311E)");
    check_base_class_offset(lv, (::aaa::AA3*), 0, "_ZN3aaa5FF311E");
    check_base_class_offset(lv, (::aaa::BB1*), ABISELECT(16,8), "_ZN3aaa5FF311E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF311E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF311E);
    dp->::aaa::FF311::~FF311();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF311E(Test__ZN3aaa5FF311E, "_ZN3aaa5FF311E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF311C1Ev();
extern void _ZN3aaa5FF311D1Ev();
Name_Map name_map__ZN3aaa5FF311E[] = {
  NSPAIR(_ZN3aaa5FF311C1Ev),
  NSPAIR(_ZN3aaa5FF311D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
static Base_Class bases__ZN3aaa5FF311E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF311E[];
extern void _ZN3aaa5FF3113fooEv();
extern void _ZN3aaa3AA33barEv();
extern void ABISELECT(_ZThn16_N3aaa5FF3113fooEv,_ZThn8_N3aaa5FF3113fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa5FF311E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF311E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF3113fooEv,
  (VTBL_ENTRY)&_ZN3aaa3AA33barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF311E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF3113fooEv,_ZThn8_N3aaa5FF3113fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa5FF311E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF311E[];
Class_Descriptor cd__ZN3aaa5FF311E = {  "_ZN3aaa5FF311E", // class name
  bases__ZN3aaa5FF311E, 2,
  &(vtc__ZN3aaa5FF311E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF311E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF311E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE312  : ::aaa::AA3 , ::aaa::BB1 {
  int pe;
  virtual void  bar(); // _ZN3aaa5EE3123barEv
  ~EE312(); // tgen
  EE312(); // tgen
};
//SIG(-1 _ZN3aaa5EE312E) C1{ BC2{ v2 v1 Fi} BC3{ v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::EE312 ::bar(){vfunc_called(this, "_ZN3aaa5EE3123barEv");}
aaa::EE312 ::~EE312(){ note_dtor("_ZN3aaa5EE312E", this);} // tgen
aaa::EE312 ::EE312(){ note_ctor("_ZN3aaa5EE312E", this);} // tgen
}
static void Test__ZN3aaa5EE312E()
{
  extern Class_Descriptor cd__ZN3aaa5EE312E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE312E, buf);
    ::aaa::EE312 *dp, &lv = *(dp=new (buf) ::aaa::EE312());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE312E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE312E)");
    check_base_class_offset(lv, (::aaa::AA3*), 0, "_ZN3aaa5EE312E");
    check_base_class_offset(lv, (::aaa::BB1*), ABISELECT(16,8), "_ZN3aaa5EE312E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE312E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE312E);
    dp->::aaa::EE312::~EE312();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE312E(Test__ZN3aaa5EE312E, "_ZN3aaa5EE312E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE312C1Ev();
extern void _ZN3aaa5EE312D1Ev();
Name_Map name_map__ZN3aaa5EE312E[] = {
  NSPAIR(_ZN3aaa5EE312C1Ev),
  NSPAIR(_ZN3aaa5EE312D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
static Base_Class bases__ZN3aaa5EE312E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE312E[];
extern void _ZN3aaa3AA33fooEv();
extern void _ZN3aaa5EE3123barEv();
extern void _ZN3aaa3BB13fooEv();
static  VTBL_ENTRY vtc__ZN3aaa5EE312E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE312E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA33fooEv,
  (VTBL_ENTRY)&_ZN3aaa5EE3123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE312E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB13fooEv,
};
extern VTBL_ENTRY _ZTIN3aaa5EE312E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE312E[];
Class_Descriptor cd__ZN3aaa5EE312E = {  "_ZN3aaa5EE312E", // class name
  bases__ZN3aaa5EE312E, 2,
  &(vtc__ZN3aaa5EE312E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE312E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE312E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF312  : ::aaa::AA3 , ::aaa::BB1 {
  int pf;
  virtual void  bar(); // _ZN3aaa5FF3123barEv
  ~FF312(); // tgen
  FF312(); // tgen
};
//SIG(-1 _ZN3aaa5FF312E) C1{ BC2{ v2 v1 Fi} BC3{ v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::FF312 ::bar(){vfunc_called(this, "_ZN3aaa5FF3123barEv");}
aaa::FF312 ::~FF312(){ note_dtor("_ZN3aaa5FF312E", this);} // tgen
aaa::FF312 ::FF312(){ note_ctor("_ZN3aaa5FF312E", this);} // tgen
}
static void Test__ZN3aaa5FF312E()
{
  extern Class_Descriptor cd__ZN3aaa5FF312E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF312E, buf);
    ::aaa::FF312 *dp, &lv = *(dp=new (buf) ::aaa::FF312());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF312E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF312E)");
    check_base_class_offset(lv, (::aaa::AA3*), 0, "_ZN3aaa5FF312E");
    check_base_class_offset(lv, (::aaa::BB1*), ABISELECT(16,8), "_ZN3aaa5FF312E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF312E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF312E);
    dp->::aaa::FF312::~FF312();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF312E(Test__ZN3aaa5FF312E, "_ZN3aaa5FF312E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF312C1Ev();
extern void _ZN3aaa5FF312D1Ev();
Name_Map name_map__ZN3aaa5FF312E[] = {
  NSPAIR(_ZN3aaa5FF312C1Ev),
  NSPAIR(_ZN3aaa5FF312D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
static Base_Class bases__ZN3aaa5FF312E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF312E[];
extern void _ZN3aaa3AA33fooEv();
extern void _ZN3aaa5FF3123barEv();
extern void _ZN3aaa3BB13fooEv();
static  VTBL_ENTRY vtc__ZN3aaa5FF312E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF312E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA33fooEv,
  (VTBL_ENTRY)&_ZN3aaa5FF3123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF312E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB13fooEv,
};
extern VTBL_ENTRY _ZTIN3aaa5FF312E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF312E[];
Class_Descriptor cd__ZN3aaa5FF312E = {  "_ZN3aaa5FF312E", // class name
  bases__ZN3aaa5FF312E, 2,
  &(vtc__ZN3aaa5FF312E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF312E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF312E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE313  : ::aaa::AA3 , ::aaa::BB1 {
  int pe;
  virtual void  foo(); // _ZN3aaa5EE3133fooEv
  virtual void  bar(); // _ZN3aaa5EE3133barEv
  ~EE313(); // tgen
  EE313(); // tgen
};
//SIG(-1 _ZN3aaa5EE313E) C1{ BC2{ v1 v2 Fi} BC3{ v1 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::EE313 ::foo(){vfunc_called(this, "_ZN3aaa5EE3133fooEv");}
void  aaa::EE313 ::bar(){vfunc_called(this, "_ZN3aaa5EE3133barEv");}
aaa::EE313 ::~EE313(){ note_dtor("_ZN3aaa5EE313E", this);} // tgen
aaa::EE313 ::EE313(){ note_ctor("_ZN3aaa5EE313E", this);} // tgen
}
static void Test__ZN3aaa5EE313E()
{
  extern Class_Descriptor cd__ZN3aaa5EE313E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE313E, buf);
    ::aaa::EE313 *dp, &lv = *(dp=new (buf) ::aaa::EE313());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE313E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE313E)");
    check_base_class_offset(lv, (::aaa::AA3*), 0, "_ZN3aaa5EE313E");
    check_base_class_offset(lv, (::aaa::BB1*), ABISELECT(16,8), "_ZN3aaa5EE313E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE313E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE313E);
    dp->::aaa::EE313::~EE313();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE313E(Test__ZN3aaa5EE313E, "_ZN3aaa5EE313E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE313C1Ev();
extern void _ZN3aaa5EE313D1Ev();
Name_Map name_map__ZN3aaa5EE313E[] = {
  NSPAIR(_ZN3aaa5EE313C1Ev),
  NSPAIR(_ZN3aaa5EE313D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
static Base_Class bases__ZN3aaa5EE313E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE313E[];
extern void _ZN3aaa5EE3133fooEv();
extern void _ZN3aaa5EE3133barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE3133fooEv,_ZThn8_N3aaa5EE3133fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa5EE313E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE313E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE3133fooEv,
  (VTBL_ENTRY)&_ZN3aaa5EE3133barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE313E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE3133fooEv,_ZThn8_N3aaa5EE3133fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa5EE313E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE313E[];
Class_Descriptor cd__ZN3aaa5EE313E = {  "_ZN3aaa5EE313E", // class name
  bases__ZN3aaa5EE313E, 2,
  &(vtc__ZN3aaa5EE313E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE313E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE313E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF313  : ::aaa::AA3 , ::aaa::BB1 {
  int pf;
  virtual void  foo(); // _ZN3aaa5FF3133fooEv
  virtual void  bar(); // _ZN3aaa5FF3133barEv
  ~FF313(); // tgen
  FF313(); // tgen
};
//SIG(-1 _ZN3aaa5FF313E) C1{ BC2{ v1 v2 Fi} BC3{ v1 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::FF313 ::foo(){vfunc_called(this, "_ZN3aaa5FF3133fooEv");}
void  aaa::FF313 ::bar(){vfunc_called(this, "_ZN3aaa5FF3133barEv");}
aaa::FF313 ::~FF313(){ note_dtor("_ZN3aaa5FF313E", this);} // tgen
aaa::FF313 ::FF313(){ note_ctor("_ZN3aaa5FF313E", this);} // tgen
}
static void Test__ZN3aaa5FF313E()
{
  extern Class_Descriptor cd__ZN3aaa5FF313E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF313E, buf);
    ::aaa::FF313 *dp, &lv = *(dp=new (buf) ::aaa::FF313());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF313E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF313E)");
    check_base_class_offset(lv, (::aaa::AA3*), 0, "_ZN3aaa5FF313E");
    check_base_class_offset(lv, (::aaa::BB1*), ABISELECT(16,8), "_ZN3aaa5FF313E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF313E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF313E);
    dp->::aaa::FF313::~FF313();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF313E(Test__ZN3aaa5FF313E, "_ZN3aaa5FF313E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF313C1Ev();
extern void _ZN3aaa5FF313D1Ev();
Name_Map name_map__ZN3aaa5FF313E[] = {
  NSPAIR(_ZN3aaa5FF313C1Ev),
  NSPAIR(_ZN3aaa5FF313D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
static Base_Class bases__ZN3aaa5FF313E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF313E[];
extern void _ZN3aaa5FF3133fooEv();
extern void _ZN3aaa5FF3133barEv();
extern void ABISELECT(_ZThn16_N3aaa5FF3133fooEv,_ZThn8_N3aaa5FF3133fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa5FF313E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF313E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF3133fooEv,
  (VTBL_ENTRY)&_ZN3aaa5FF3133barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF313E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF3133fooEv,_ZThn8_N3aaa5FF3133fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa5FF313E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF313E[];
Class_Descriptor cd__ZN3aaa5FF313E = {  "_ZN3aaa5FF313E", // class name
  bases__ZN3aaa5FF313E, 2,
  &(vtc__ZN3aaa5FF313E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF313E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF313E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE321  : ::aaa::AA3 , ::aaa::BB2 {
  int pe;
  virtual void  foo(); // _ZN3aaa5EE3213fooEv
  ~EE321(); // tgen
  EE321(); // tgen
};
//SIG(-1 _ZN3aaa5EE321E) C1{ BC2{ v1 v2 Fi} BC3{ v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::EE321 ::foo(){vfunc_called(this, "_ZN3aaa5EE3213fooEv");}
aaa::EE321 ::~EE321(){ note_dtor("_ZN3aaa5EE321E", this);} // tgen
aaa::EE321 ::EE321(){ note_ctor("_ZN3aaa5EE321E", this);} // tgen
}
static void Test__ZN3aaa5EE321E()
{
  extern Class_Descriptor cd__ZN3aaa5EE321E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE321E, buf);
    ::aaa::EE321 *dp, &lv = *(dp=new (buf) ::aaa::EE321());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE321E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE321E)");
    check_base_class_offset(lv, (::aaa::AA3*), 0, "_ZN3aaa5EE321E");
    check_base_class_offset(lv, (::aaa::BB2*), ABISELECT(16,8), "_ZN3aaa5EE321E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE321E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE321E);
    dp->::aaa::EE321::~EE321();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE321E(Test__ZN3aaa5EE321E, "_ZN3aaa5EE321E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE321C1Ev();
extern void _ZN3aaa5EE321D1Ev();
Name_Map name_map__ZN3aaa5EE321E[] = {
  NSPAIR(_ZN3aaa5EE321C1Ev),
  NSPAIR(_ZN3aaa5EE321D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
static Base_Class bases__ZN3aaa5EE321E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE321E[];
extern void _ZN3aaa5EE3213fooEv();
extern void _ZN3aaa3AA33barEv();
extern void _ZN3aaa3BB23barEv();
static  VTBL_ENTRY vtc__ZN3aaa5EE321E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE321E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE3213fooEv,
  (VTBL_ENTRY)&_ZN3aaa3AA33barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE321E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB23barEv,
};
extern VTBL_ENTRY _ZTIN3aaa5EE321E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE321E[];
Class_Descriptor cd__ZN3aaa5EE321E = {  "_ZN3aaa5EE321E", // class name
  bases__ZN3aaa5EE321E, 2,
  &(vtc__ZN3aaa5EE321E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE321E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE321E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF321  : ::aaa::AA3 , ::aaa::BB2 {
  int pf;
  virtual void  foo(); // _ZN3aaa5FF3213fooEv
  ~FF321(); // tgen
  FF321(); // tgen
};
//SIG(-1 _ZN3aaa5FF321E) C1{ BC2{ v1 v2 Fi} BC3{ v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::FF321 ::foo(){vfunc_called(this, "_ZN3aaa5FF3213fooEv");}
aaa::FF321 ::~FF321(){ note_dtor("_ZN3aaa5FF321E", this);} // tgen
aaa::FF321 ::FF321(){ note_ctor("_ZN3aaa5FF321E", this);} // tgen
}
static void Test__ZN3aaa5FF321E()
{
  extern Class_Descriptor cd__ZN3aaa5FF321E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF321E, buf);
    ::aaa::FF321 *dp, &lv = *(dp=new (buf) ::aaa::FF321());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF321E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF321E)");
    check_base_class_offset(lv, (::aaa::AA3*), 0, "_ZN3aaa5FF321E");
    check_base_class_offset(lv, (::aaa::BB2*), ABISELECT(16,8), "_ZN3aaa5FF321E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF321E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF321E);
    dp->::aaa::FF321::~FF321();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF321E(Test__ZN3aaa5FF321E, "_ZN3aaa5FF321E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF321C1Ev();
extern void _ZN3aaa5FF321D1Ev();
Name_Map name_map__ZN3aaa5FF321E[] = {
  NSPAIR(_ZN3aaa5FF321C1Ev),
  NSPAIR(_ZN3aaa5FF321D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
static Base_Class bases__ZN3aaa5FF321E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF321E[];
extern void _ZN3aaa5FF3213fooEv();
extern void _ZN3aaa3AA33barEv();
extern void _ZN3aaa3BB23barEv();
static  VTBL_ENTRY vtc__ZN3aaa5FF321E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF321E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF3213fooEv,
  (VTBL_ENTRY)&_ZN3aaa3AA33barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF321E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB23barEv,
};
extern VTBL_ENTRY _ZTIN3aaa5FF321E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF321E[];
Class_Descriptor cd__ZN3aaa5FF321E = {  "_ZN3aaa5FF321E", // class name
  bases__ZN3aaa5FF321E, 2,
  &(vtc__ZN3aaa5FF321E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF321E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF321E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE322  : ::aaa::AA3 , ::aaa::BB2 {
  int pe;
  virtual void  bar(); // _ZN3aaa5EE3223barEv
  ~EE322(); // tgen
  EE322(); // tgen
};
//SIG(-1 _ZN3aaa5EE322E) C1{ BC2{ v2 v1 Fi} BC3{ v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::EE322 ::bar(){vfunc_called(this, "_ZN3aaa5EE3223barEv");}
aaa::EE322 ::~EE322(){ note_dtor("_ZN3aaa5EE322E", this);} // tgen
aaa::EE322 ::EE322(){ note_ctor("_ZN3aaa5EE322E", this);} // tgen
}
static void Test__ZN3aaa5EE322E()
{
  extern Class_Descriptor cd__ZN3aaa5EE322E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE322E, buf);
    ::aaa::EE322 *dp, &lv = *(dp=new (buf) ::aaa::EE322());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE322E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE322E)");
    check_base_class_offset(lv, (::aaa::AA3*), 0, "_ZN3aaa5EE322E");
    check_base_class_offset(lv, (::aaa::BB2*), ABISELECT(16,8), "_ZN3aaa5EE322E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE322E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE322E);
    dp->::aaa::EE322::~EE322();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE322E(Test__ZN3aaa5EE322E, "_ZN3aaa5EE322E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE322C1Ev();
extern void _ZN3aaa5EE322D1Ev();
Name_Map name_map__ZN3aaa5EE322E[] = {
  NSPAIR(_ZN3aaa5EE322C1Ev),
  NSPAIR(_ZN3aaa5EE322D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
static Base_Class bases__ZN3aaa5EE322E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE322E[];
extern void _ZN3aaa3AA33fooEv();
extern void _ZN3aaa5EE3223barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE3223barEv,_ZThn8_N3aaa5EE3223barEv)();
static  VTBL_ENTRY vtc__ZN3aaa5EE322E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE322E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA33fooEv,
  (VTBL_ENTRY)&_ZN3aaa5EE3223barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE322E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE3223barEv,_ZThn8_N3aaa5EE3223barEv),
};
extern VTBL_ENTRY _ZTIN3aaa5EE322E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE322E[];
Class_Descriptor cd__ZN3aaa5EE322E = {  "_ZN3aaa5EE322E", // class name
  bases__ZN3aaa5EE322E, 2,
  &(vtc__ZN3aaa5EE322E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE322E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE322E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF322  : ::aaa::AA3 , ::aaa::BB2 {
  int pf;
  virtual void  bar(); // _ZN3aaa5FF3223barEv
  ~FF322(); // tgen
  FF322(); // tgen
};
//SIG(-1 _ZN3aaa5FF322E) C1{ BC2{ v2 v1 Fi} BC3{ v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::FF322 ::bar(){vfunc_called(this, "_ZN3aaa5FF3223barEv");}
aaa::FF322 ::~FF322(){ note_dtor("_ZN3aaa5FF322E", this);} // tgen
aaa::FF322 ::FF322(){ note_ctor("_ZN3aaa5FF322E", this);} // tgen
}
static void Test__ZN3aaa5FF322E()
{
  extern Class_Descriptor cd__ZN3aaa5FF322E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF322E, buf);
    ::aaa::FF322 *dp, &lv = *(dp=new (buf) ::aaa::FF322());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF322E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF322E)");
    check_base_class_offset(lv, (::aaa::AA3*), 0, "_ZN3aaa5FF322E");
    check_base_class_offset(lv, (::aaa::BB2*), ABISELECT(16,8), "_ZN3aaa5FF322E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF322E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF322E);
    dp->::aaa::FF322::~FF322();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF322E(Test__ZN3aaa5FF322E, "_ZN3aaa5FF322E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF322C1Ev();
extern void _ZN3aaa5FF322D1Ev();
Name_Map name_map__ZN3aaa5FF322E[] = {
  NSPAIR(_ZN3aaa5FF322C1Ev),
  NSPAIR(_ZN3aaa5FF322D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
static Base_Class bases__ZN3aaa5FF322E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF322E[];
extern void _ZN3aaa3AA33fooEv();
extern void _ZN3aaa5FF3223barEv();
extern void ABISELECT(_ZThn16_N3aaa5FF3223barEv,_ZThn8_N3aaa5FF3223barEv)();
static  VTBL_ENTRY vtc__ZN3aaa5FF322E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF322E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA33fooEv,
  (VTBL_ENTRY)&_ZN3aaa5FF3223barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF322E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF3223barEv,_ZThn8_N3aaa5FF3223barEv),
};
extern VTBL_ENTRY _ZTIN3aaa5FF322E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF322E[];
Class_Descriptor cd__ZN3aaa5FF322E = {  "_ZN3aaa5FF322E", // class name
  bases__ZN3aaa5FF322E, 2,
  &(vtc__ZN3aaa5FF322E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF322E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF322E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE323  : ::aaa::AA3 , ::aaa::BB2 {
  int pe;
  virtual void  foo(); // _ZN3aaa5EE3233fooEv
  virtual void  bar(); // _ZN3aaa5EE3233barEv
  ~EE323(); // tgen
  EE323(); // tgen
};
//SIG(-1 _ZN3aaa5EE323E) C1{ BC2{ v1 v2 Fi} BC3{ v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::EE323 ::foo(){vfunc_called(this, "_ZN3aaa5EE3233fooEv");}
void  aaa::EE323 ::bar(){vfunc_called(this, "_ZN3aaa5EE3233barEv");}
aaa::EE323 ::~EE323(){ note_dtor("_ZN3aaa5EE323E", this);} // tgen
aaa::EE323 ::EE323(){ note_ctor("_ZN3aaa5EE323E", this);} // tgen
}
static void Test__ZN3aaa5EE323E()
{
  extern Class_Descriptor cd__ZN3aaa5EE323E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE323E, buf);
    ::aaa::EE323 *dp, &lv = *(dp=new (buf) ::aaa::EE323());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE323E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE323E)");
    check_base_class_offset(lv, (::aaa::AA3*), 0, "_ZN3aaa5EE323E");
    check_base_class_offset(lv, (::aaa::BB2*), ABISELECT(16,8), "_ZN3aaa5EE323E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE323E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE323E);
    dp->::aaa::EE323::~EE323();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE323E(Test__ZN3aaa5EE323E, "_ZN3aaa5EE323E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE323C1Ev();
extern void _ZN3aaa5EE323D1Ev();
Name_Map name_map__ZN3aaa5EE323E[] = {
  NSPAIR(_ZN3aaa5EE323C1Ev),
  NSPAIR(_ZN3aaa5EE323D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
static Base_Class bases__ZN3aaa5EE323E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE323E[];
extern void _ZN3aaa5EE3233fooEv();
extern void _ZN3aaa5EE3233barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE3233barEv,_ZThn8_N3aaa5EE3233barEv)();
static  VTBL_ENTRY vtc__ZN3aaa5EE323E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE323E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE3233fooEv,
  (VTBL_ENTRY)&_ZN3aaa5EE3233barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE323E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE3233barEv,_ZThn8_N3aaa5EE3233barEv),
};
extern VTBL_ENTRY _ZTIN3aaa5EE323E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE323E[];
Class_Descriptor cd__ZN3aaa5EE323E = {  "_ZN3aaa5EE323E", // class name
  bases__ZN3aaa5EE323E, 2,
  &(vtc__ZN3aaa5EE323E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE323E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE323E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF323  : ::aaa::AA3 , ::aaa::BB2 {
  int pf;
  virtual void  foo(); // _ZN3aaa5FF3233fooEv
  virtual void  bar(); // _ZN3aaa5FF3233barEv
  ~FF323(); // tgen
  FF323(); // tgen
};
//SIG(-1 _ZN3aaa5FF323E) C1{ BC2{ v1 v2 Fi} BC3{ v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::FF323 ::foo(){vfunc_called(this, "_ZN3aaa5FF3233fooEv");}
void  aaa::FF323 ::bar(){vfunc_called(this, "_ZN3aaa5FF3233barEv");}
aaa::FF323 ::~FF323(){ note_dtor("_ZN3aaa5FF323E", this);} // tgen
aaa::FF323 ::FF323(){ note_ctor("_ZN3aaa5FF323E", this);} // tgen
}
static void Test__ZN3aaa5FF323E()
{
  extern Class_Descriptor cd__ZN3aaa5FF323E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF323E, buf);
    ::aaa::FF323 *dp, &lv = *(dp=new (buf) ::aaa::FF323());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF323E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF323E)");
    check_base_class_offset(lv, (::aaa::AA3*), 0, "_ZN3aaa5FF323E");
    check_base_class_offset(lv, (::aaa::BB2*), ABISELECT(16,8), "_ZN3aaa5FF323E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF323E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF323E);
    dp->::aaa::FF323::~FF323();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF323E(Test__ZN3aaa5FF323E, "_ZN3aaa5FF323E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF323C1Ev();
extern void _ZN3aaa5FF323D1Ev();
Name_Map name_map__ZN3aaa5FF323E[] = {
  NSPAIR(_ZN3aaa5FF323C1Ev),
  NSPAIR(_ZN3aaa5FF323D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
static Base_Class bases__ZN3aaa5FF323E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF323E[];
extern void _ZN3aaa5FF3233fooEv();
extern void _ZN3aaa5FF3233barEv();
extern void ABISELECT(_ZThn16_N3aaa5FF3233barEv,_ZThn8_N3aaa5FF3233barEv)();
static  VTBL_ENTRY vtc__ZN3aaa5FF323E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF323E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF3233fooEv,
  (VTBL_ENTRY)&_ZN3aaa5FF3233barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF323E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF3233barEv,_ZThn8_N3aaa5FF3233barEv),
};
extern VTBL_ENTRY _ZTIN3aaa5FF323E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF323E[];
Class_Descriptor cd__ZN3aaa5FF323E = {  "_ZN3aaa5FF323E", // class name
  bases__ZN3aaa5FF323E, 2,
  &(vtc__ZN3aaa5FF323E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF323E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF323E),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE331  : ::aaa::AA3 , ::aaa::BB3 {
  int pe;
  virtual void  foo(); // _ZN3aaa5EE3313fooEv
  ~EE331(); // tgen
  EE331(); // tgen
};
//SIG(-1 _ZN3aaa5EE331E) C1{ BC2{ v1 v2 Fi} BC3{ v1 v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::EE331 ::foo(){vfunc_called(this, "_ZN3aaa5EE3313fooEv");}
aaa::EE331 ::~EE331(){ note_dtor("_ZN3aaa5EE331E", this);} // tgen
aaa::EE331 ::EE331(){ note_ctor("_ZN3aaa5EE331E", this);} // tgen
}
static void Test__ZN3aaa5EE331E()
{
  extern Class_Descriptor cd__ZN3aaa5EE331E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE331E, buf);
    ::aaa::EE331 *dp, &lv = *(dp=new (buf) ::aaa::EE331());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE331E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE331E)");
    check_base_class_offset(lv, (::aaa::AA3*), 0, "_ZN3aaa5EE331E");
    check_base_class_offset(lv, (::aaa::BB3*), ABISELECT(16,8), "_ZN3aaa5EE331E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE331E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE331E);
    dp->::aaa::EE331::~EE331();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE331E(Test__ZN3aaa5EE331E, "_ZN3aaa5EE331E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE331C1Ev();
extern void _ZN3aaa5EE331D1Ev();
Name_Map name_map__ZN3aaa5EE331E[] = {
  NSPAIR(_ZN3aaa5EE331C1Ev),
  NSPAIR(_ZN3aaa5EE331D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
static Base_Class bases__ZN3aaa5EE331E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE331E[];
extern void _ZN3aaa5EE3313fooEv();
extern void _ZN3aaa3AA33barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE3313fooEv,_ZThn8_N3aaa5EE3313fooEv)();
extern void _ZN3aaa3BB33barEv();
static  VTBL_ENTRY vtc__ZN3aaa5EE331E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE331E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE3313fooEv,
  (VTBL_ENTRY)&_ZN3aaa3AA33barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE331E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE3313fooEv,_ZThn8_N3aaa5EE3313fooEv),
  (VTBL_ENTRY)&_ZN3aaa3BB33barEv,
};
extern VTBL_ENTRY _ZTIN3aaa5EE331E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE331E[];
Class_Descriptor cd__ZN3aaa5EE331E = {  "_ZN3aaa5EE331E", // class name
  bases__ZN3aaa5EE331E, 2,
  &(vtc__ZN3aaa5EE331E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE331E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE331E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF331  : ::aaa::AA3 , ::aaa::BB3 {
  int pf;
  virtual void  foo(); // _ZN3aaa5FF3313fooEv
  ~FF331(); // tgen
  FF331(); // tgen
};
//SIG(-1 _ZN3aaa5FF331E) C1{ BC2{ v1 v2 Fi} BC3{ v1 v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::FF331 ::foo(){vfunc_called(this, "_ZN3aaa5FF3313fooEv");}
aaa::FF331 ::~FF331(){ note_dtor("_ZN3aaa5FF331E", this);} // tgen
aaa::FF331 ::FF331(){ note_ctor("_ZN3aaa5FF331E", this);} // tgen
}
static void Test__ZN3aaa5FF331E()
{
  extern Class_Descriptor cd__ZN3aaa5FF331E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF331E, buf);
    ::aaa::FF331 *dp, &lv = *(dp=new (buf) ::aaa::FF331());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF331E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF331E)");
    check_base_class_offset(lv, (::aaa::AA3*), 0, "_ZN3aaa5FF331E");
    check_base_class_offset(lv, (::aaa::BB3*), ABISELECT(16,8), "_ZN3aaa5FF331E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF331E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF331E);
    dp->::aaa::FF331::~FF331();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF331E(Test__ZN3aaa5FF331E, "_ZN3aaa5FF331E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF331C1Ev();
extern void _ZN3aaa5FF331D1Ev();
Name_Map name_map__ZN3aaa5FF331E[] = {
  NSPAIR(_ZN3aaa5FF331C1Ev),
  NSPAIR(_ZN3aaa5FF331D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
static Base_Class bases__ZN3aaa5FF331E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF331E[];
extern void _ZN3aaa5FF3313fooEv();
extern void _ZN3aaa3AA33barEv();
extern void ABISELECT(_ZThn16_N3aaa5FF3313fooEv,_ZThn8_N3aaa5FF3313fooEv)();
extern void _ZN3aaa3BB33barEv();
static  VTBL_ENTRY vtc__ZN3aaa5FF331E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF331E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF3313fooEv,
  (VTBL_ENTRY)&_ZN3aaa3AA33barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF331E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF3313fooEv,_ZThn8_N3aaa5FF3313fooEv),
  (VTBL_ENTRY)&_ZN3aaa3BB33barEv,
};
extern VTBL_ENTRY _ZTIN3aaa5FF331E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF331E[];
Class_Descriptor cd__ZN3aaa5FF331E = {  "_ZN3aaa5FF331E", // class name
  bases__ZN3aaa5FF331E, 2,
  &(vtc__ZN3aaa5FF331E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF331E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF331E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE332  : ::aaa::AA3 , ::aaa::BB3 {
  int pe;
  virtual void  bar(); // _ZN3aaa5EE3323barEv
  ~EE332(); // tgen
  EE332(); // tgen
};
//SIG(-1 _ZN3aaa5EE332E) C1{ BC2{ v2 v1 Fi} BC3{ v3 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::EE332 ::bar(){vfunc_called(this, "_ZN3aaa5EE3323barEv");}
aaa::EE332 ::~EE332(){ note_dtor("_ZN3aaa5EE332E", this);} // tgen
aaa::EE332 ::EE332(){ note_ctor("_ZN3aaa5EE332E", this);} // tgen
}
static void Test__ZN3aaa5EE332E()
{
  extern Class_Descriptor cd__ZN3aaa5EE332E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE332E, buf);
    ::aaa::EE332 *dp, &lv = *(dp=new (buf) ::aaa::EE332());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE332E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE332E)");
    check_base_class_offset(lv, (::aaa::AA3*), 0, "_ZN3aaa5EE332E");
    check_base_class_offset(lv, (::aaa::BB3*), ABISELECT(16,8), "_ZN3aaa5EE332E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE332E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE332E);
    dp->::aaa::EE332::~EE332();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE332E(Test__ZN3aaa5EE332E, "_ZN3aaa5EE332E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE332C1Ev();
extern void _ZN3aaa5EE332D1Ev();
Name_Map name_map__ZN3aaa5EE332E[] = {
  NSPAIR(_ZN3aaa5EE332C1Ev),
  NSPAIR(_ZN3aaa5EE332D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
static Base_Class bases__ZN3aaa5EE332E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE332E[];
extern void _ZN3aaa3AA33fooEv();
extern void _ZN3aaa5EE3323barEv();
extern void _ZN3aaa3BB33fooEv();
extern void ABISELECT(_ZThn16_N3aaa5EE3323barEv,_ZThn8_N3aaa5EE3323barEv)();
static  VTBL_ENTRY vtc__ZN3aaa5EE332E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE332E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA33fooEv,
  (VTBL_ENTRY)&_ZN3aaa5EE3323barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE332E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE3323barEv,_ZThn8_N3aaa5EE3323barEv),
};
extern VTBL_ENTRY _ZTIN3aaa5EE332E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE332E[];
Class_Descriptor cd__ZN3aaa5EE332E = {  "_ZN3aaa5EE332E", // class name
  bases__ZN3aaa5EE332E, 2,
  &(vtc__ZN3aaa5EE332E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE332E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE332E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF332  : ::aaa::AA3 , ::aaa::BB3 {
  int pf;
  virtual void  bar(); // _ZN3aaa5FF3323barEv
  ~FF332(); // tgen
  FF332(); // tgen
};
//SIG(-1 _ZN3aaa5FF332E) C1{ BC2{ v2 v1 Fi} BC3{ v3 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::FF332 ::bar(){vfunc_called(this, "_ZN3aaa5FF3323barEv");}
aaa::FF332 ::~FF332(){ note_dtor("_ZN3aaa5FF332E", this);} // tgen
aaa::FF332 ::FF332(){ note_ctor("_ZN3aaa5FF332E", this);} // tgen
}
static void Test__ZN3aaa5FF332E()
{
  extern Class_Descriptor cd__ZN3aaa5FF332E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF332E, buf);
    ::aaa::FF332 *dp, &lv = *(dp=new (buf) ::aaa::FF332());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF332E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF332E)");
    check_base_class_offset(lv, (::aaa::AA3*), 0, "_ZN3aaa5FF332E");
    check_base_class_offset(lv, (::aaa::BB3*), ABISELECT(16,8), "_ZN3aaa5FF332E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF332E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF332E);
    dp->::aaa::FF332::~FF332();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF332E(Test__ZN3aaa5FF332E, "_ZN3aaa5FF332E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF332C1Ev();
extern void _ZN3aaa5FF332D1Ev();
Name_Map name_map__ZN3aaa5FF332E[] = {
  NSPAIR(_ZN3aaa5FF332C1Ev),
  NSPAIR(_ZN3aaa5FF332D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
static Base_Class bases__ZN3aaa5FF332E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF332E[];
extern void _ZN3aaa3AA33fooEv();
extern void _ZN3aaa5FF3323barEv();
extern void _ZN3aaa3BB33fooEv();
extern void ABISELECT(_ZThn16_N3aaa5FF3323barEv,_ZThn8_N3aaa5FF3323barEv)();
static  VTBL_ENTRY vtc__ZN3aaa5FF332E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF332E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA33fooEv,
  (VTBL_ENTRY)&_ZN3aaa5FF3323barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF332E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF3323barEv,_ZThn8_N3aaa5FF3323barEv),
};
extern VTBL_ENTRY _ZTIN3aaa5FF332E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF332E[];
Class_Descriptor cd__ZN3aaa5FF332E = {  "_ZN3aaa5FF332E", // class name
  bases__ZN3aaa5FF332E, 2,
  &(vtc__ZN3aaa5FF332E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF332E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF332E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  EE333  : ::aaa::AA3 , ::aaa::BB3 {
  int pe;
  virtual void  foo(); // _ZN3aaa5EE3333fooEv
  virtual void  bar(); // _ZN3aaa5EE3333barEv
  ~EE333(); // tgen
  EE333(); // tgen
};
//SIG(-1 _ZN3aaa5EE333E) C1{ BC2{ v1 v2 Fi} BC3{ v1 v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::EE333 ::foo(){vfunc_called(this, "_ZN3aaa5EE3333fooEv");}
void  aaa::EE333 ::bar(){vfunc_called(this, "_ZN3aaa5EE3333barEv");}
aaa::EE333 ::~EE333(){ note_dtor("_ZN3aaa5EE333E", this);} // tgen
aaa::EE333 ::EE333(){ note_ctor("_ZN3aaa5EE333E", this);} // tgen
}
static void Test__ZN3aaa5EE333E()
{
  extern Class_Descriptor cd__ZN3aaa5EE333E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5EE333E, buf);
    ::aaa::EE333 *dp, &lv = *(dp=new (buf) ::aaa::EE333());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5EE333E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5EE333E)");
    check_base_class_offset(lv, (::aaa::AA3*), 0, "_ZN3aaa5EE333E");
    check_base_class_offset(lv, (::aaa::BB3*), ABISELECT(16,8), "_ZN3aaa5EE333E");
    check_field_offset(lv, pe, ABISELECT(28,16), "_ZN3aaa5EE333E.pe");
    test_class_info(&lv, &cd__ZN3aaa5EE333E);
    dp->::aaa::EE333::~EE333();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5EE333E(Test__ZN3aaa5EE333E, "_ZN3aaa5EE333E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5EE333C1Ev();
extern void _ZN3aaa5EE333D1Ev();
Name_Map name_map__ZN3aaa5EE333E[] = {
  NSPAIR(_ZN3aaa5EE333C1Ev),
  NSPAIR(_ZN3aaa5EE333D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
static Base_Class bases__ZN3aaa5EE333E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5EE333E[];
extern void _ZN3aaa5EE3333fooEv();
extern void _ZN3aaa5EE3333barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE3333fooEv,_ZThn8_N3aaa5EE3333fooEv)();
extern void ABISELECT(_ZThn16_N3aaa5EE3333barEv,_ZThn8_N3aaa5EE3333barEv)();
static  VTBL_ENTRY vtc__ZN3aaa5EE333E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5EE333E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE3333fooEv,
  (VTBL_ENTRY)&_ZN3aaa5EE3333barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5EE333E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE3333fooEv,_ZThn8_N3aaa5EE3333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE3333barEv,_ZThn8_N3aaa5EE3333barEv),
};
extern VTBL_ENTRY _ZTIN3aaa5EE333E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE333E[];
Class_Descriptor cd__ZN3aaa5EE333E = {  "_ZN3aaa5EE333E", // class name
  bases__ZN3aaa5EE333E, 2,
  &(vtc__ZN3aaa5EE333E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5EE333E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5EE333E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  FF333  : ::aaa::AA3 , ::aaa::BB3 {
  int pf;
  virtual void  foo(); // _ZN3aaa5FF3333fooEv
  virtual void  bar(); // _ZN3aaa5FF3333barEv
  ~FF333(); // tgen
  FF333(); // tgen
};
//SIG(-1 _ZN3aaa5FF333E) C1{ BC2{ v1 v2 Fi} BC3{ v1 v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::FF333 ::foo(){vfunc_called(this, "_ZN3aaa5FF3333fooEv");}
void  aaa::FF333 ::bar(){vfunc_called(this, "_ZN3aaa5FF3333barEv");}
aaa::FF333 ::~FF333(){ note_dtor("_ZN3aaa5FF333E", this);} // tgen
aaa::FF333 ::FF333(){ note_ctor("_ZN3aaa5FF333E", this);} // tgen
}
static void Test__ZN3aaa5FF333E()
{
  extern Class_Descriptor cd__ZN3aaa5FF333E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN3aaa5FF333E, buf);
    ::aaa::FF333 *dp, &lv = *(dp=new (buf) ::aaa::FF333());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN3aaa5FF333E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa5FF333E)");
    check_base_class_offset(lv, (::aaa::AA3*), 0, "_ZN3aaa5FF333E");
    check_base_class_offset(lv, (::aaa::BB3*), ABISELECT(16,8), "_ZN3aaa5FF333E");
    check_field_offset(lv, pf, ABISELECT(28,16), "_ZN3aaa5FF333E.pf");
    test_class_info(&lv, &cd__ZN3aaa5FF333E);
    dp->::aaa::FF333::~FF333();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa5FF333E(Test__ZN3aaa5FF333E, "_ZN3aaa5FF333E", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN3aaa5FF333C1Ev();
extern void _ZN3aaa5FF333D1Ev();
Name_Map name_map__ZN3aaa5FF333E[] = {
  NSPAIR(_ZN3aaa5FF333C1Ev),
  NSPAIR(_ZN3aaa5FF333D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
static Base_Class bases__ZN3aaa5FF333E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa5FF333E[];
extern void _ZN3aaa5FF3333fooEv();
extern void _ZN3aaa5FF3333barEv();
extern void ABISELECT(_ZThn16_N3aaa5FF3333fooEv,_ZThn8_N3aaa5FF3333fooEv)();
extern void ABISELECT(_ZThn16_N3aaa5FF3333barEv,_ZThn8_N3aaa5FF3333barEv)();
static  VTBL_ENTRY vtc__ZN3aaa5FF333E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa5FF333E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF3333fooEv,
  (VTBL_ENTRY)&_ZN3aaa5FF3333barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa5FF333E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF3333fooEv,_ZThn8_N3aaa5FF3333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF3333barEv,_ZThn8_N3aaa5FF3333barEv),
};
extern VTBL_ENTRY _ZTIN3aaa5FF333E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF333E[];
Class_Descriptor cd__ZN3aaa5FF333E = {  "_ZN3aaa5FF333E", // class name
  bases__ZN3aaa5FF333E, 2,
  &(vtc__ZN3aaa5FF333E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTIN3aaa5FF333E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa5FF333E),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111111  : ::aaa::EE111 , ::aaa::FF111 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11111113fooEv
  ~GG1111111(); // tgen
  GG1111111(); // tgen
};
//SIG(1 _ZN3aaa9GG1111111E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC3 BC4 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1111111 ::foo(){vfunc_called(this, "_ZN3aaa9GG11111113fooEv");}
aaa::GG1111111 ::~GG1111111(){ note_dtor("_ZN3aaa9GG1111111E", this);} // tgen
aaa::GG1111111 ::GG1111111(){ note_ctor("_ZN3aaa9GG1111111E", this);} // tgen
}
static void Test__ZN3aaa9GG1111111E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111111E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111111E, buf);
    ::aaa::GG1111111 *dp, &lv = *(dp=new (buf) ::aaa::GG1111111());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111111E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111111E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111111E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111111E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111111E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF111*), ABISELECT(32,20), "_ZN3aaa9GG1111111E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF111*), ABISELECT(48,28), "_ZN3aaa9GG1111111E");
    check_base_class_offset(lv, (::aaa::FF111*), ABISELECT(32,20), "_ZN3aaa9GG1111111E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111111E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111111E);
    dp->::aaa::GG1111111::~GG1111111();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111111E(Test__ZN3aaa9GG1111111E, "_ZN3aaa9GG1111111E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111111C1Ev();
extern void _ZN3aaa9GG1111111D1Ev();
Name_Map name_map__ZN3aaa9GG1111111E[] = {
  NSPAIR(_ZN3aaa9GG1111111C1Ev),
  NSPAIR(_ZN3aaa9GG1111111D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF111E;
extern VTBL_ENTRY _ZTIN3aaa5FF111E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF111E[];
static Base_Class bases__ZN3aaa9GG1111111E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    9, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF111E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111111E[];
extern void _ZN3aaa9GG11111113fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11111113fooEv,_ZThn8_N3aaa9GG11111113fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11111113fooEv,_ZThn20_N3aaa9GG11111113fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11111113fooEv,_ZThn28_N3aaa9GG11111113fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111111E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111111E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11111113fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111111E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11111113fooEv,_ZThn8_N3aaa9GG11111113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111111E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11111113fooEv,_ZThn20_N3aaa9GG11111113fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111111E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11111113fooEv,_ZThn28_N3aaa9GG11111113fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111111E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111111E[];
Class_Descriptor cd__ZN3aaa9GG1111111E = {  "_ZN3aaa9GG1111111E", // class name
  bases__ZN3aaa9GG1111111E, 6,
  &(vtc__ZN3aaa9GG1111111E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111111E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111111E),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111112  : ::aaa::EE111 , ::aaa::FF111 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11111123barEv
  ~GG1111112(); // tgen
  GG1111112(); // tgen
};
//SIG(1 _ZN3aaa9GG1111112E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC3 BC4 v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1111112 ::bar(){vfunc_called(this, "_ZN3aaa9GG11111123barEv");}
aaa::GG1111112 ::~GG1111112(){ note_dtor("_ZN3aaa9GG1111112E", this);} // tgen
aaa::GG1111112 ::GG1111112(){ note_ctor("_ZN3aaa9GG1111112E", this);} // tgen
}
static void Test__ZN3aaa9GG1111112E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111112E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111112E, buf);
    ::aaa::GG1111112 *dp, &lv = *(dp=new (buf) ::aaa::GG1111112());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111112E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111112E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111112E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111112E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111112E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF111*), ABISELECT(32,20), "_ZN3aaa9GG1111112E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF111*), ABISELECT(48,28), "_ZN3aaa9GG1111112E");
    check_base_class_offset(lv, (::aaa::FF111*), ABISELECT(32,20), "_ZN3aaa9GG1111112E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111112E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111112E);
    dp->::aaa::GG1111112::~GG1111112();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111112E(Test__ZN3aaa9GG1111112E, "_ZN3aaa9GG1111112E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111112C1Ev();
extern void _ZN3aaa9GG1111112D1Ev();
Name_Map name_map__ZN3aaa9GG1111112E[] = {
  NSPAIR(_ZN3aaa9GG1111112C1Ev),
  NSPAIR(_ZN3aaa9GG1111112D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF111E;
extern VTBL_ENTRY _ZTIN3aaa5FF111E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF111E[];
static Base_Class bases__ZN3aaa9GG1111112E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF111E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111112E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11111123barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void _ZN3aaa5FF1113fooEv();
extern void ABISELECT(_ZThn16_N3aaa5FF1113fooEv,_ZThn8_N3aaa5FF1113fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111112E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111112E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11111123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111112E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111112E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF1113fooEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111112E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF1113fooEv,_ZThn8_N3aaa5FF1113fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111112E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111112E[];
Class_Descriptor cd__ZN3aaa9GG1111112E = {  "_ZN3aaa9GG1111112E", // class name
  bases__ZN3aaa9GG1111112E, 6,
  &(vtc__ZN3aaa9GG1111112E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111112E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111112E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111113  : ::aaa::EE111 , ::aaa::FF111 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11111133fooEv
  virtual void  bar(); // _ZN3aaa9GG11111133barEv
  ~GG1111113(); // tgen
  GG1111113(); // tgen
};
//SIG(1 _ZN3aaa9GG1111113E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC3 BC4 v1 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1111113 ::foo(){vfunc_called(this, "_ZN3aaa9GG11111133fooEv");}
void  aaa::GG1111113 ::bar(){vfunc_called(this, "_ZN3aaa9GG11111133barEv");}
aaa::GG1111113 ::~GG1111113(){ note_dtor("_ZN3aaa9GG1111113E", this);} // tgen
aaa::GG1111113 ::GG1111113(){ note_ctor("_ZN3aaa9GG1111113E", this);} // tgen
}
static void Test__ZN3aaa9GG1111113E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111113E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111113E, buf);
    ::aaa::GG1111113 *dp, &lv = *(dp=new (buf) ::aaa::GG1111113());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111113E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111113E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111113E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111113E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111113E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF111*), ABISELECT(32,20), "_ZN3aaa9GG1111113E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF111*), ABISELECT(48,28), "_ZN3aaa9GG1111113E");
    check_base_class_offset(lv, (::aaa::FF111*), ABISELECT(32,20), "_ZN3aaa9GG1111113E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111113E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111113E);
    dp->::aaa::GG1111113::~GG1111113();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111113E(Test__ZN3aaa9GG1111113E, "_ZN3aaa9GG1111113E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111113C1Ev();
extern void _ZN3aaa9GG1111113D1Ev();
Name_Map name_map__ZN3aaa9GG1111113E[] = {
  NSPAIR(_ZN3aaa9GG1111113C1Ev),
  NSPAIR(_ZN3aaa9GG1111113D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF111E;
extern VTBL_ENTRY _ZTIN3aaa5FF111E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF111E[];
static Base_Class bases__ZN3aaa9GG1111113E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF111E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111113E[];
extern void _ZN3aaa9GG11111133fooEv();
extern void _ZN3aaa9GG11111133barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11111133fooEv,_ZThn8_N3aaa9GG11111133fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11111133fooEv,_ZThn20_N3aaa9GG11111133fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11111133fooEv,_ZThn28_N3aaa9GG11111133fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111113E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111113E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11111133fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11111133barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111113E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11111133fooEv,_ZThn8_N3aaa9GG11111133fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111113E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11111133fooEv,_ZThn20_N3aaa9GG11111133fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111113E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11111133fooEv,_ZThn28_N3aaa9GG11111133fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111113E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111113E[];
Class_Descriptor cd__ZN3aaa9GG1111113E = {  "_ZN3aaa9GG1111113E", // class name
  bases__ZN3aaa9GG1111113E, 6,
  &(vtc__ZN3aaa9GG1111113E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111113E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111113E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111121  : ::aaa::EE111 , ::aaa::FF112 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11111213fooEv
  ~GG1111121(); // tgen
  GG1111121(); // tgen
};
//SIG(1 _ZN3aaa9GG1111121E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC3 BC4 v2 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1111121 ::foo(){vfunc_called(this, "_ZN3aaa9GG11111213fooEv");}
aaa::GG1111121 ::~GG1111121(){ note_dtor("_ZN3aaa9GG1111121E", this);} // tgen
aaa::GG1111121 ::GG1111121(){ note_ctor("_ZN3aaa9GG1111121E", this);} // tgen
}
static void Test__ZN3aaa9GG1111121E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111121E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111121E, buf);
    ::aaa::GG1111121 *dp, &lv = *(dp=new (buf) ::aaa::GG1111121());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111121E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111121E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111121E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111121E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111121E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF112*), ABISELECT(32,20), "_ZN3aaa9GG1111121E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF112*), ABISELECT(48,28), "_ZN3aaa9GG1111121E");
    check_base_class_offset(lv, (::aaa::FF112*), ABISELECT(32,20), "_ZN3aaa9GG1111121E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111121E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111121E);
    dp->::aaa::GG1111121::~GG1111121();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111121E(Test__ZN3aaa9GG1111121E, "_ZN3aaa9GG1111121E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111121C1Ev();
extern void _ZN3aaa9GG1111121D1Ev();
Name_Map name_map__ZN3aaa9GG1111121E[] = {
  NSPAIR(_ZN3aaa9GG1111121C1Ev),
  NSPAIR(_ZN3aaa9GG1111121D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF112E;
extern VTBL_ENTRY _ZTIN3aaa5FF112E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF112E[];
static Base_Class bases__ZN3aaa9GG1111121E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF112E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111121E[];
extern void _ZN3aaa9GG11111213fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11111213fooEv,_ZThn8_N3aaa9GG11111213fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11111213fooEv,_ZThn20_N3aaa9GG11111213fooEv)();
extern void _ZN3aaa5FF1123barEv();
extern void ABISELECT(_ZThn48_N3aaa9GG11111213fooEv,_ZThn28_N3aaa9GG11111213fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111121E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111121E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11111213fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111121E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11111213fooEv,_ZThn8_N3aaa9GG11111213fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111121E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11111213fooEv,_ZThn20_N3aaa9GG11111213fooEv),
  (VTBL_ENTRY)&_ZN3aaa5FF1123barEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111121E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11111213fooEv,_ZThn28_N3aaa9GG11111213fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111121E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111121E[];
Class_Descriptor cd__ZN3aaa9GG1111121E = {  "_ZN3aaa9GG1111121E", // class name
  bases__ZN3aaa9GG1111121E, 6,
  &(vtc__ZN3aaa9GG1111121E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111121E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111121E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111122  : ::aaa::EE111 , ::aaa::FF112 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11111223barEv
  ~GG1111122(); // tgen
  GG1111122(); // tgen
};
//SIG(1 _ZN3aaa9GG1111122E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC3 BC4 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1111122 ::bar(){vfunc_called(this, "_ZN3aaa9GG11111223barEv");}
aaa::GG1111122 ::~GG1111122(){ note_dtor("_ZN3aaa9GG1111122E", this);} // tgen
aaa::GG1111122 ::GG1111122(){ note_ctor("_ZN3aaa9GG1111122E", this);} // tgen
}
static void Test__ZN3aaa9GG1111122E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111122E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111122E, buf);
    ::aaa::GG1111122 *dp, &lv = *(dp=new (buf) ::aaa::GG1111122());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111122E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111122E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111122E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111122E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111122E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF112*), ABISELECT(32,20), "_ZN3aaa9GG1111122E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF112*), ABISELECT(48,28), "_ZN3aaa9GG1111122E");
    check_base_class_offset(lv, (::aaa::FF112*), ABISELECT(32,20), "_ZN3aaa9GG1111122E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111122E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111122E);
    dp->::aaa::GG1111122::~GG1111122();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111122E(Test__ZN3aaa9GG1111122E, "_ZN3aaa9GG1111122E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111122C1Ev();
extern void _ZN3aaa9GG1111122D1Ev();
Name_Map name_map__ZN3aaa9GG1111122E[] = {
  NSPAIR(_ZN3aaa9GG1111122C1Ev),
  NSPAIR(_ZN3aaa9GG1111122D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF112E;
extern VTBL_ENTRY _ZTIN3aaa5FF112E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF112E[];
static Base_Class bases__ZN3aaa9GG1111122E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF112E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111122E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11111223barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void _ZN3aaa3AA13fooEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11111223barEv,_ZThn20_N3aaa9GG11111223barEv)();
extern void _ZN3aaa3BB13fooEv();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111122E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111122E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11111223barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111122E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111122E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA13fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11111223barEv,_ZThn20_N3aaa9GG11111223barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111122E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB13fooEv,
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111122E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111122E[];
Class_Descriptor cd__ZN3aaa9GG1111122E = {  "_ZN3aaa9GG1111122E", // class name
  bases__ZN3aaa9GG1111122E, 6,
  &(vtc__ZN3aaa9GG1111122E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111122E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111122E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111123  : ::aaa::EE111 , ::aaa::FF112 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11111233fooEv
  virtual void  bar(); // _ZN3aaa9GG11111233barEv
  ~GG1111123(); // tgen
  GG1111123(); // tgen
};
//SIG(1 _ZN3aaa9GG1111123E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC3 BC4 v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1111123 ::foo(){vfunc_called(this, "_ZN3aaa9GG11111233fooEv");}
void  aaa::GG1111123 ::bar(){vfunc_called(this, "_ZN3aaa9GG11111233barEv");}
aaa::GG1111123 ::~GG1111123(){ note_dtor("_ZN3aaa9GG1111123E", this);} // tgen
aaa::GG1111123 ::GG1111123(){ note_ctor("_ZN3aaa9GG1111123E", this);} // tgen
}
static void Test__ZN3aaa9GG1111123E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111123E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111123E, buf);
    ::aaa::GG1111123 *dp, &lv = *(dp=new (buf) ::aaa::GG1111123());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111123E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111123E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111123E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111123E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111123E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF112*), ABISELECT(32,20), "_ZN3aaa9GG1111123E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF112*), ABISELECT(48,28), "_ZN3aaa9GG1111123E");
    check_base_class_offset(lv, (::aaa::FF112*), ABISELECT(32,20), "_ZN3aaa9GG1111123E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111123E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111123E);
    dp->::aaa::GG1111123::~GG1111123();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111123E(Test__ZN3aaa9GG1111123E, "_ZN3aaa9GG1111123E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111123C1Ev();
extern void _ZN3aaa9GG1111123D1Ev();
Name_Map name_map__ZN3aaa9GG1111123E[] = {
  NSPAIR(_ZN3aaa9GG1111123C1Ev),
  NSPAIR(_ZN3aaa9GG1111123D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF112E;
extern VTBL_ENTRY _ZTIN3aaa5FF112E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF112E[];
static Base_Class bases__ZN3aaa9GG1111123E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF112E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111123E[];
extern void _ZN3aaa9GG11111233fooEv();
extern void _ZN3aaa9GG11111233barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11111233fooEv,_ZThn8_N3aaa9GG11111233fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11111233fooEv,_ZThn20_N3aaa9GG11111233fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11111233barEv,_ZThn20_N3aaa9GG11111233barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11111233fooEv,_ZThn28_N3aaa9GG11111233fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111123E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111123E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11111233fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11111233barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111123E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11111233fooEv,_ZThn8_N3aaa9GG11111233fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111123E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11111233fooEv,_ZThn20_N3aaa9GG11111233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11111233barEv,_ZThn20_N3aaa9GG11111233barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111123E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11111233fooEv,_ZThn28_N3aaa9GG11111233fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111123E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111123E[];
Class_Descriptor cd__ZN3aaa9GG1111123E = {  "_ZN3aaa9GG1111123E", // class name
  bases__ZN3aaa9GG1111123E, 6,
  &(vtc__ZN3aaa9GG1111123E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111123E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111123E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111131  : ::aaa::EE111 , ::aaa::FF113 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11111313fooEv
  ~GG1111131(); // tgen
  GG1111131(); // tgen
};
//SIG(1 _ZN3aaa9GG1111131E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC3 BC4 v1 v2 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1111131 ::foo(){vfunc_called(this, "_ZN3aaa9GG11111313fooEv");}
aaa::GG1111131 ::~GG1111131(){ note_dtor("_ZN3aaa9GG1111131E", this);} // tgen
aaa::GG1111131 ::GG1111131(){ note_ctor("_ZN3aaa9GG1111131E", this);} // tgen
}
static void Test__ZN3aaa9GG1111131E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111131E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111131E, buf);
    ::aaa::GG1111131 *dp, &lv = *(dp=new (buf) ::aaa::GG1111131());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111131E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111131E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111131E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111131E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111131E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF113*), ABISELECT(32,20), "_ZN3aaa9GG1111131E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF113*), ABISELECT(48,28), "_ZN3aaa9GG1111131E");
    check_base_class_offset(lv, (::aaa::FF113*), ABISELECT(32,20), "_ZN3aaa9GG1111131E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111131E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111131E);
    dp->::aaa::GG1111131::~GG1111131();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111131E(Test__ZN3aaa9GG1111131E, "_ZN3aaa9GG1111131E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111131C1Ev();
extern void _ZN3aaa9GG1111131D1Ev();
Name_Map name_map__ZN3aaa9GG1111131E[] = {
  NSPAIR(_ZN3aaa9GG1111131C1Ev),
  NSPAIR(_ZN3aaa9GG1111131D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF113E;
extern VTBL_ENTRY _ZTIN3aaa5FF113E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF113E[];
static Base_Class bases__ZN3aaa9GG1111131E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF113E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111131E[];
extern void _ZN3aaa9GG11111313fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11111313fooEv,_ZThn8_N3aaa9GG11111313fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11111313fooEv,_ZThn20_N3aaa9GG11111313fooEv)();
extern void _ZN3aaa5FF1133barEv();
extern void ABISELECT(_ZThn48_N3aaa9GG11111313fooEv,_ZThn28_N3aaa9GG11111313fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111131E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111131E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11111313fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111131E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11111313fooEv,_ZThn8_N3aaa9GG11111313fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111131E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11111313fooEv,_ZThn20_N3aaa9GG11111313fooEv),
  (VTBL_ENTRY)&_ZN3aaa5FF1133barEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111131E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11111313fooEv,_ZThn28_N3aaa9GG11111313fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111131E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111131E[];
Class_Descriptor cd__ZN3aaa9GG1111131E = {  "_ZN3aaa9GG1111131E", // class name
  bases__ZN3aaa9GG1111131E, 6,
  &(vtc__ZN3aaa9GG1111131E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111131E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111131E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111132  : ::aaa::EE111 , ::aaa::FF113 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11111323barEv
  ~GG1111132(); // tgen
  GG1111132(); // tgen
};
//SIG(1 _ZN3aaa9GG1111132E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC3 BC4 v3 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1111132 ::bar(){vfunc_called(this, "_ZN3aaa9GG11111323barEv");}
aaa::GG1111132 ::~GG1111132(){ note_dtor("_ZN3aaa9GG1111132E", this);} // tgen
aaa::GG1111132 ::GG1111132(){ note_ctor("_ZN3aaa9GG1111132E", this);} // tgen
}
static void Test__ZN3aaa9GG1111132E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111132E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111132E, buf);
    ::aaa::GG1111132 *dp, &lv = *(dp=new (buf) ::aaa::GG1111132());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111132E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111132E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111132E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111132E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111132E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF113*), ABISELECT(32,20), "_ZN3aaa9GG1111132E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF113*), ABISELECT(48,28), "_ZN3aaa9GG1111132E");
    check_base_class_offset(lv, (::aaa::FF113*), ABISELECT(32,20), "_ZN3aaa9GG1111132E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111132E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111132E);
    dp->::aaa::GG1111132::~GG1111132();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111132E(Test__ZN3aaa9GG1111132E, "_ZN3aaa9GG1111132E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111132C1Ev();
extern void _ZN3aaa9GG1111132D1Ev();
Name_Map name_map__ZN3aaa9GG1111132E[] = {
  NSPAIR(_ZN3aaa9GG1111132C1Ev),
  NSPAIR(_ZN3aaa9GG1111132D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF113E;
extern VTBL_ENTRY _ZTIN3aaa5FF113E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF113E[];
static Base_Class bases__ZN3aaa9GG1111132E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF113E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111132E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11111323barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void _ZN3aaa5FF1133fooEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11111323barEv,_ZThn20_N3aaa9GG11111323barEv)();
extern void ABISELECT(_ZThn16_N3aaa5FF1133fooEv,_ZThn8_N3aaa5FF1133fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111132E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111132E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11111323barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111132E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111132E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF1133fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11111323barEv,_ZThn20_N3aaa9GG11111323barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111132E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF1133fooEv,_ZThn8_N3aaa5FF1133fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111132E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111132E[];
Class_Descriptor cd__ZN3aaa9GG1111132E = {  "_ZN3aaa9GG1111132E", // class name
  bases__ZN3aaa9GG1111132E, 6,
  &(vtc__ZN3aaa9GG1111132E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111132E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111132E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111133  : ::aaa::EE111 , ::aaa::FF113 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11111333fooEv
  virtual void  bar(); // _ZN3aaa9GG11111333barEv
  ~GG1111133(); // tgen
  GG1111133(); // tgen
};
//SIG(1 _ZN3aaa9GG1111133E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC3 BC4 v1 v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1111133 ::foo(){vfunc_called(this, "_ZN3aaa9GG11111333fooEv");}
void  aaa::GG1111133 ::bar(){vfunc_called(this, "_ZN3aaa9GG11111333barEv");}
aaa::GG1111133 ::~GG1111133(){ note_dtor("_ZN3aaa9GG1111133E", this);} // tgen
aaa::GG1111133 ::GG1111133(){ note_ctor("_ZN3aaa9GG1111133E", this);} // tgen
}
static void Test__ZN3aaa9GG1111133E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111133E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111133E, buf);
    ::aaa::GG1111133 *dp, &lv = *(dp=new (buf) ::aaa::GG1111133());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111133E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111133E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111133E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111133E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111133E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF113*), ABISELECT(32,20), "_ZN3aaa9GG1111133E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF113*), ABISELECT(48,28), "_ZN3aaa9GG1111133E");
    check_base_class_offset(lv, (::aaa::FF113*), ABISELECT(32,20), "_ZN3aaa9GG1111133E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111133E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111133E);
    dp->::aaa::GG1111133::~GG1111133();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111133E(Test__ZN3aaa9GG1111133E, "_ZN3aaa9GG1111133E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111133C1Ev();
extern void _ZN3aaa9GG1111133D1Ev();
Name_Map name_map__ZN3aaa9GG1111133E[] = {
  NSPAIR(_ZN3aaa9GG1111133C1Ev),
  NSPAIR(_ZN3aaa9GG1111133D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF113E;
extern VTBL_ENTRY _ZTIN3aaa5FF113E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF113E[];
static Base_Class bases__ZN3aaa9GG1111133E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF113E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111133E[];
extern void _ZN3aaa9GG11111333fooEv();
extern void _ZN3aaa9GG11111333barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11111333fooEv,_ZThn8_N3aaa9GG11111333fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11111333fooEv,_ZThn20_N3aaa9GG11111333fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11111333barEv,_ZThn20_N3aaa9GG11111333barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11111333fooEv,_ZThn28_N3aaa9GG11111333fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111133E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111133E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11111333fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11111333barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111133E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11111333fooEv,_ZThn8_N3aaa9GG11111333fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111133E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11111333fooEv,_ZThn20_N3aaa9GG11111333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11111333barEv,_ZThn20_N3aaa9GG11111333barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111133E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11111333fooEv,_ZThn28_N3aaa9GG11111333fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111133E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111133E[];
Class_Descriptor cd__ZN3aaa9GG1111133E = {  "_ZN3aaa9GG1111133E", // class name
  bases__ZN3aaa9GG1111133E, 6,
  &(vtc__ZN3aaa9GG1111133E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111133E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111133E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111211  : ::aaa::EE111 , ::aaa::FF121 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11112113fooEv
  ~GG1111211(); // tgen
  GG1111211(); // tgen
};
//SIG(1 _ZN3aaa9GG1111211E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC3 BC6{ v2 Fi} v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1111211 ::foo(){vfunc_called(this, "_ZN3aaa9GG11112113fooEv");}
aaa::GG1111211 ::~GG1111211(){ note_dtor("_ZN3aaa9GG1111211E", this);} // tgen
aaa::GG1111211 ::GG1111211(){ note_ctor("_ZN3aaa9GG1111211E", this);} // tgen
}
static void Test__ZN3aaa9GG1111211E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111211E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111211E, buf);
    ::aaa::GG1111211 *dp, &lv = *(dp=new (buf) ::aaa::GG1111211());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111211E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111211E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111211E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111211E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111211E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF121*), ABISELECT(32,20), "_ZN3aaa9GG1111211E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF121*), ABISELECT(48,28), "_ZN3aaa9GG1111211E");
    check_base_class_offset(lv, (::aaa::FF121*), ABISELECT(32,20), "_ZN3aaa9GG1111211E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111211E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111211E);
    dp->::aaa::GG1111211::~GG1111211();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111211E(Test__ZN3aaa9GG1111211E, "_ZN3aaa9GG1111211E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111211C1Ev();
extern void _ZN3aaa9GG1111211D1Ev();
Name_Map name_map__ZN3aaa9GG1111211E[] = {
  NSPAIR(_ZN3aaa9GG1111211C1Ev),
  NSPAIR(_ZN3aaa9GG1111211D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF121E;
extern VTBL_ENTRY _ZTIN3aaa5FF121E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF121E[];
static Base_Class bases__ZN3aaa9GG1111211E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    9, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF121E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111211E[];
extern void _ZN3aaa9GG11112113fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11112113fooEv,_ZThn8_N3aaa9GG11112113fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11112113fooEv,_ZThn20_N3aaa9GG11112113fooEv)();
extern void _ZN3aaa3BB23barEv();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111211E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111211E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11112113fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111211E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11112113fooEv,_ZThn8_N3aaa9GG11112113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111211E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11112113fooEv,_ZThn20_N3aaa9GG11112113fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111211E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB23barEv,
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111211E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111211E[];
Class_Descriptor cd__ZN3aaa9GG1111211E = {  "_ZN3aaa9GG1111211E", // class name
  bases__ZN3aaa9GG1111211E, 6,
  &(vtc__ZN3aaa9GG1111211E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111211E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111211E),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111212  : ::aaa::EE111 , ::aaa::FF121 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11112123barEv
  ~GG1111212(); // tgen
  GG1111212(); // tgen
};
//SIG(1 _ZN3aaa9GG1111212E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC3 BC6{ v1 Fi} v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1111212 ::bar(){vfunc_called(this, "_ZN3aaa9GG11112123barEv");}
aaa::GG1111212 ::~GG1111212(){ note_dtor("_ZN3aaa9GG1111212E", this);} // tgen
aaa::GG1111212 ::GG1111212(){ note_ctor("_ZN3aaa9GG1111212E", this);} // tgen
}
static void Test__ZN3aaa9GG1111212E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111212E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111212E, buf);
    ::aaa::GG1111212 *dp, &lv = *(dp=new (buf) ::aaa::GG1111212());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111212E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111212E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111212E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111212E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111212E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF121*), ABISELECT(32,20), "_ZN3aaa9GG1111212E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF121*), ABISELECT(48,28), "_ZN3aaa9GG1111212E");
    check_base_class_offset(lv, (::aaa::FF121*), ABISELECT(32,20), "_ZN3aaa9GG1111212E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111212E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111212E);
    dp->::aaa::GG1111212::~GG1111212();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111212E(Test__ZN3aaa9GG1111212E, "_ZN3aaa9GG1111212E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111212C1Ev();
extern void _ZN3aaa9GG1111212D1Ev();
Name_Map name_map__ZN3aaa9GG1111212E[] = {
  NSPAIR(_ZN3aaa9GG1111212C1Ev),
  NSPAIR(_ZN3aaa9GG1111212D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF121E;
extern VTBL_ENTRY _ZTIN3aaa5FF121E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF121E[];
static Base_Class bases__ZN3aaa9GG1111212E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF121E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111212E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11112123barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void _ZN3aaa5FF1213fooEv();
extern void ABISELECT(_ZThn48_N3aaa9GG11112123barEv,_ZThn28_N3aaa9GG11112123barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111212E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111212E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11112123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111212E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111212E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF1213fooEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111212E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11112123barEv,_ZThn28_N3aaa9GG11112123barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111212E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111212E[];
Class_Descriptor cd__ZN3aaa9GG1111212E = {  "_ZN3aaa9GG1111212E", // class name
  bases__ZN3aaa9GG1111212E, 6,
  &(vtc__ZN3aaa9GG1111212E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111212E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111212E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111213  : ::aaa::EE111 , ::aaa::FF121 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11112133fooEv
  virtual void  bar(); // _ZN3aaa9GG11112133barEv
  ~GG1111213(); // tgen
  GG1111213(); // tgen
};
//SIG(1 _ZN3aaa9GG1111213E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC3 BC6{ v2 Fi} v1 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1111213 ::foo(){vfunc_called(this, "_ZN3aaa9GG11112133fooEv");}
void  aaa::GG1111213 ::bar(){vfunc_called(this, "_ZN3aaa9GG11112133barEv");}
aaa::GG1111213 ::~GG1111213(){ note_dtor("_ZN3aaa9GG1111213E", this);} // tgen
aaa::GG1111213 ::GG1111213(){ note_ctor("_ZN3aaa9GG1111213E", this);} // tgen
}
static void Test__ZN3aaa9GG1111213E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111213E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111213E, buf);
    ::aaa::GG1111213 *dp, &lv = *(dp=new (buf) ::aaa::GG1111213());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111213E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111213E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111213E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111213E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111213E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF121*), ABISELECT(32,20), "_ZN3aaa9GG1111213E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF121*), ABISELECT(48,28), "_ZN3aaa9GG1111213E");
    check_base_class_offset(lv, (::aaa::FF121*), ABISELECT(32,20), "_ZN3aaa9GG1111213E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111213E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111213E);
    dp->::aaa::GG1111213::~GG1111213();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111213E(Test__ZN3aaa9GG1111213E, "_ZN3aaa9GG1111213E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111213C1Ev();
extern void _ZN3aaa9GG1111213D1Ev();
Name_Map name_map__ZN3aaa9GG1111213E[] = {
  NSPAIR(_ZN3aaa9GG1111213C1Ev),
  NSPAIR(_ZN3aaa9GG1111213D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF121E;
extern VTBL_ENTRY _ZTIN3aaa5FF121E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF121E[];
static Base_Class bases__ZN3aaa9GG1111213E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF121E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111213E[];
extern void _ZN3aaa9GG11112133fooEv();
extern void _ZN3aaa9GG11112133barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11112133fooEv,_ZThn8_N3aaa9GG11112133fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11112133fooEv,_ZThn20_N3aaa9GG11112133fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11112133barEv,_ZThn28_N3aaa9GG11112133barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111213E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111213E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11112133fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11112133barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111213E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11112133fooEv,_ZThn8_N3aaa9GG11112133fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111213E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11112133fooEv,_ZThn20_N3aaa9GG11112133fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111213E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11112133barEv,_ZThn28_N3aaa9GG11112133barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111213E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111213E[];
Class_Descriptor cd__ZN3aaa9GG1111213E = {  "_ZN3aaa9GG1111213E", // class name
  bases__ZN3aaa9GG1111213E, 6,
  &(vtc__ZN3aaa9GG1111213E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111213E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111213E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111221  : ::aaa::EE111 , ::aaa::FF122 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11112213fooEv
  ~GG1111221(); // tgen
  GG1111221(); // tgen
};
//SIG(1 _ZN3aaa9GG1111221E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC3 BC6{ v2 Fi} v2 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1111221 ::foo(){vfunc_called(this, "_ZN3aaa9GG11112213fooEv");}
aaa::GG1111221 ::~GG1111221(){ note_dtor("_ZN3aaa9GG1111221E", this);} // tgen
aaa::GG1111221 ::GG1111221(){ note_ctor("_ZN3aaa9GG1111221E", this);} // tgen
}
static void Test__ZN3aaa9GG1111221E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111221E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111221E, buf);
    ::aaa::GG1111221 *dp, &lv = *(dp=new (buf) ::aaa::GG1111221());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111221E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111221E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111221E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111221E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111221E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF122*), ABISELECT(32,20), "_ZN3aaa9GG1111221E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF122*), ABISELECT(48,28), "_ZN3aaa9GG1111221E");
    check_base_class_offset(lv, (::aaa::FF122*), ABISELECT(32,20), "_ZN3aaa9GG1111221E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111221E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111221E);
    dp->::aaa::GG1111221::~GG1111221();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111221E(Test__ZN3aaa9GG1111221E, "_ZN3aaa9GG1111221E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111221C1Ev();
extern void _ZN3aaa9GG1111221D1Ev();
Name_Map name_map__ZN3aaa9GG1111221E[] = {
  NSPAIR(_ZN3aaa9GG1111221C1Ev),
  NSPAIR(_ZN3aaa9GG1111221D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF122E;
extern VTBL_ENTRY _ZTIN3aaa5FF122E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF122E[];
static Base_Class bases__ZN3aaa9GG1111221E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF122E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111221E[];
extern void _ZN3aaa9GG11112213fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11112213fooEv,_ZThn8_N3aaa9GG11112213fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11112213fooEv,_ZThn20_N3aaa9GG11112213fooEv)();
extern void _ZN3aaa5FF1223barEv();
extern void ABISELECT(_ZThn16_N3aaa5FF1223barEv,_ZThn8_N3aaa5FF1223barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111221E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111221E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11112213fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111221E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11112213fooEv,_ZThn8_N3aaa9GG11112213fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111221E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11112213fooEv,_ZThn20_N3aaa9GG11112213fooEv),
  (VTBL_ENTRY)&_ZN3aaa5FF1223barEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111221E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF1223barEv,_ZThn8_N3aaa5FF1223barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111221E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111221E[];
Class_Descriptor cd__ZN3aaa9GG1111221E = {  "_ZN3aaa9GG1111221E", // class name
  bases__ZN3aaa9GG1111221E, 6,
  &(vtc__ZN3aaa9GG1111221E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111221E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111221E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111222  : ::aaa::EE111 , ::aaa::FF122 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11112223barEv
  ~GG1111222(); // tgen
  GG1111222(); // tgen
};
//SIG(1 _ZN3aaa9GG1111222E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC3 BC6{ v1 Fi} v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1111222 ::bar(){vfunc_called(this, "_ZN3aaa9GG11112223barEv");}
aaa::GG1111222 ::~GG1111222(){ note_dtor("_ZN3aaa9GG1111222E", this);} // tgen
aaa::GG1111222 ::GG1111222(){ note_ctor("_ZN3aaa9GG1111222E", this);} // tgen
}
static void Test__ZN3aaa9GG1111222E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111222E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111222E, buf);
    ::aaa::GG1111222 *dp, &lv = *(dp=new (buf) ::aaa::GG1111222());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111222E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111222E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111222E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111222E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111222E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF122*), ABISELECT(32,20), "_ZN3aaa9GG1111222E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF122*), ABISELECT(48,28), "_ZN3aaa9GG1111222E");
    check_base_class_offset(lv, (::aaa::FF122*), ABISELECT(32,20), "_ZN3aaa9GG1111222E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111222E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111222E);
    dp->::aaa::GG1111222::~GG1111222();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111222E(Test__ZN3aaa9GG1111222E, "_ZN3aaa9GG1111222E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111222C1Ev();
extern void _ZN3aaa9GG1111222D1Ev();
Name_Map name_map__ZN3aaa9GG1111222E[] = {
  NSPAIR(_ZN3aaa9GG1111222C1Ev),
  NSPAIR(_ZN3aaa9GG1111222D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF122E;
extern VTBL_ENTRY _ZTIN3aaa5FF122E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF122E[];
static Base_Class bases__ZN3aaa9GG1111222E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF122E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111222E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11112223barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void _ZN3aaa3AA13fooEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11112223barEv,_ZThn20_N3aaa9GG11112223barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11112223barEv,_ZThn28_N3aaa9GG11112223barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111222E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111222E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11112223barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111222E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111222E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA13fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11112223barEv,_ZThn20_N3aaa9GG11112223barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111222E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11112223barEv,_ZThn28_N3aaa9GG11112223barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111222E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111222E[];
Class_Descriptor cd__ZN3aaa9GG1111222E = {  "_ZN3aaa9GG1111222E", // class name
  bases__ZN3aaa9GG1111222E, 6,
  &(vtc__ZN3aaa9GG1111222E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111222E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111222E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111223  : ::aaa::EE111 , ::aaa::FF122 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11112233fooEv
  virtual void  bar(); // _ZN3aaa9GG11112233barEv
  ~GG1111223(); // tgen
  GG1111223(); // tgen
};
//SIG(1 _ZN3aaa9GG1111223E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC3 BC6{ v2 Fi} v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1111223 ::foo(){vfunc_called(this, "_ZN3aaa9GG11112233fooEv");}
void  aaa::GG1111223 ::bar(){vfunc_called(this, "_ZN3aaa9GG11112233barEv");}
aaa::GG1111223 ::~GG1111223(){ note_dtor("_ZN3aaa9GG1111223E", this);} // tgen
aaa::GG1111223 ::GG1111223(){ note_ctor("_ZN3aaa9GG1111223E", this);} // tgen
}
static void Test__ZN3aaa9GG1111223E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111223E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111223E, buf);
    ::aaa::GG1111223 *dp, &lv = *(dp=new (buf) ::aaa::GG1111223());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111223E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111223E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111223E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111223E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111223E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF122*), ABISELECT(32,20), "_ZN3aaa9GG1111223E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF122*), ABISELECT(48,28), "_ZN3aaa9GG1111223E");
    check_base_class_offset(lv, (::aaa::FF122*), ABISELECT(32,20), "_ZN3aaa9GG1111223E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111223E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111223E);
    dp->::aaa::GG1111223::~GG1111223();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111223E(Test__ZN3aaa9GG1111223E, "_ZN3aaa9GG1111223E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111223C1Ev();
extern void _ZN3aaa9GG1111223D1Ev();
Name_Map name_map__ZN3aaa9GG1111223E[] = {
  NSPAIR(_ZN3aaa9GG1111223C1Ev),
  NSPAIR(_ZN3aaa9GG1111223D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF122E;
extern VTBL_ENTRY _ZTIN3aaa5FF122E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF122E[];
static Base_Class bases__ZN3aaa9GG1111223E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF122E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111223E[];
extern void _ZN3aaa9GG11112233fooEv();
extern void _ZN3aaa9GG11112233barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11112233fooEv,_ZThn8_N3aaa9GG11112233fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11112233fooEv,_ZThn20_N3aaa9GG11112233fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11112233barEv,_ZThn20_N3aaa9GG11112233barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11112233barEv,_ZThn28_N3aaa9GG11112233barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111223E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111223E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11112233fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11112233barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111223E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11112233fooEv,_ZThn8_N3aaa9GG11112233fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111223E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11112233fooEv,_ZThn20_N3aaa9GG11112233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11112233barEv,_ZThn20_N3aaa9GG11112233barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111223E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11112233barEv,_ZThn28_N3aaa9GG11112233barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111223E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111223E[];
Class_Descriptor cd__ZN3aaa9GG1111223E = {  "_ZN3aaa9GG1111223E", // class name
  bases__ZN3aaa9GG1111223E, 6,
  &(vtc__ZN3aaa9GG1111223E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111223E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111223E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111231  : ::aaa::EE111 , ::aaa::FF123 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11112313fooEv
  ~GG1111231(); // tgen
  GG1111231(); // tgen
};
//SIG(1 _ZN3aaa9GG1111231E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC3 BC6{ v2 Fi} v1 v2 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1111231 ::foo(){vfunc_called(this, "_ZN3aaa9GG11112313fooEv");}
aaa::GG1111231 ::~GG1111231(){ note_dtor("_ZN3aaa9GG1111231E", this);} // tgen
aaa::GG1111231 ::GG1111231(){ note_ctor("_ZN3aaa9GG1111231E", this);} // tgen
}
static void Test__ZN3aaa9GG1111231E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111231E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111231E, buf);
    ::aaa::GG1111231 *dp, &lv = *(dp=new (buf) ::aaa::GG1111231());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111231E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111231E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111231E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111231E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111231E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF123*), ABISELECT(32,20), "_ZN3aaa9GG1111231E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF123*), ABISELECT(48,28), "_ZN3aaa9GG1111231E");
    check_base_class_offset(lv, (::aaa::FF123*), ABISELECT(32,20), "_ZN3aaa9GG1111231E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111231E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111231E);
    dp->::aaa::GG1111231::~GG1111231();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111231E(Test__ZN3aaa9GG1111231E, "_ZN3aaa9GG1111231E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111231C1Ev();
extern void _ZN3aaa9GG1111231D1Ev();
Name_Map name_map__ZN3aaa9GG1111231E[] = {
  NSPAIR(_ZN3aaa9GG1111231C1Ev),
  NSPAIR(_ZN3aaa9GG1111231D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF123E;
extern VTBL_ENTRY _ZTIN3aaa5FF123E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF123E[];
static Base_Class bases__ZN3aaa9GG1111231E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF123E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111231E[];
extern void _ZN3aaa9GG11112313fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11112313fooEv,_ZThn8_N3aaa9GG11112313fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11112313fooEv,_ZThn20_N3aaa9GG11112313fooEv)();
extern void _ZN3aaa5FF1233barEv();
extern void ABISELECT(_ZThn16_N3aaa5FF1233barEv,_ZThn8_N3aaa5FF1233barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111231E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111231E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11112313fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111231E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11112313fooEv,_ZThn8_N3aaa9GG11112313fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111231E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11112313fooEv,_ZThn20_N3aaa9GG11112313fooEv),
  (VTBL_ENTRY)&_ZN3aaa5FF1233barEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111231E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF1233barEv,_ZThn8_N3aaa5FF1233barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111231E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111231E[];
Class_Descriptor cd__ZN3aaa9GG1111231E = {  "_ZN3aaa9GG1111231E", // class name
  bases__ZN3aaa9GG1111231E, 6,
  &(vtc__ZN3aaa9GG1111231E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111231E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111231E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111232  : ::aaa::EE111 , ::aaa::FF123 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11112323barEv
  ~GG1111232(); // tgen
  GG1111232(); // tgen
};
//SIG(1 _ZN3aaa9GG1111232E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC3 BC6{ v1 Fi} v3 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1111232 ::bar(){vfunc_called(this, "_ZN3aaa9GG11112323barEv");}
aaa::GG1111232 ::~GG1111232(){ note_dtor("_ZN3aaa9GG1111232E", this);} // tgen
aaa::GG1111232 ::GG1111232(){ note_ctor("_ZN3aaa9GG1111232E", this);} // tgen
}
static void Test__ZN3aaa9GG1111232E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111232E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111232E, buf);
    ::aaa::GG1111232 *dp, &lv = *(dp=new (buf) ::aaa::GG1111232());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111232E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111232E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111232E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111232E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111232E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF123*), ABISELECT(32,20), "_ZN3aaa9GG1111232E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF123*), ABISELECT(48,28), "_ZN3aaa9GG1111232E");
    check_base_class_offset(lv, (::aaa::FF123*), ABISELECT(32,20), "_ZN3aaa9GG1111232E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111232E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111232E);
    dp->::aaa::GG1111232::~GG1111232();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111232E(Test__ZN3aaa9GG1111232E, "_ZN3aaa9GG1111232E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111232C1Ev();
extern void _ZN3aaa9GG1111232D1Ev();
Name_Map name_map__ZN3aaa9GG1111232E[] = {
  NSPAIR(_ZN3aaa9GG1111232C1Ev),
  NSPAIR(_ZN3aaa9GG1111232D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF123E;
extern VTBL_ENTRY _ZTIN3aaa5FF123E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF123E[];
static Base_Class bases__ZN3aaa9GG1111232E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF123E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111232E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11112323barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void _ZN3aaa5FF1233fooEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11112323barEv,_ZThn20_N3aaa9GG11112323barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11112323barEv,_ZThn28_N3aaa9GG11112323barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111232E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111232E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11112323barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111232E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111232E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF1233fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11112323barEv,_ZThn20_N3aaa9GG11112323barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111232E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11112323barEv,_ZThn28_N3aaa9GG11112323barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111232E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111232E[];
Class_Descriptor cd__ZN3aaa9GG1111232E = {  "_ZN3aaa9GG1111232E", // class name
  bases__ZN3aaa9GG1111232E, 6,
  &(vtc__ZN3aaa9GG1111232E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111232E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111232E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111233  : ::aaa::EE111 , ::aaa::FF123 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11112333fooEv
  virtual void  bar(); // _ZN3aaa9GG11112333barEv
  ~GG1111233(); // tgen
  GG1111233(); // tgen
};
//SIG(1 _ZN3aaa9GG1111233E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC3 BC6{ v2 Fi} v1 v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1111233 ::foo(){vfunc_called(this, "_ZN3aaa9GG11112333fooEv");}
void  aaa::GG1111233 ::bar(){vfunc_called(this, "_ZN3aaa9GG11112333barEv");}
aaa::GG1111233 ::~GG1111233(){ note_dtor("_ZN3aaa9GG1111233E", this);} // tgen
aaa::GG1111233 ::GG1111233(){ note_ctor("_ZN3aaa9GG1111233E", this);} // tgen
}
static void Test__ZN3aaa9GG1111233E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111233E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111233E, buf);
    ::aaa::GG1111233 *dp, &lv = *(dp=new (buf) ::aaa::GG1111233());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111233E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111233E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111233E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111233E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111233E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF123*), ABISELECT(32,20), "_ZN3aaa9GG1111233E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF123*), ABISELECT(48,28), "_ZN3aaa9GG1111233E");
    check_base_class_offset(lv, (::aaa::FF123*), ABISELECT(32,20), "_ZN3aaa9GG1111233E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111233E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111233E);
    dp->::aaa::GG1111233::~GG1111233();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111233E(Test__ZN3aaa9GG1111233E, "_ZN3aaa9GG1111233E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111233C1Ev();
extern void _ZN3aaa9GG1111233D1Ev();
Name_Map name_map__ZN3aaa9GG1111233E[] = {
  NSPAIR(_ZN3aaa9GG1111233C1Ev),
  NSPAIR(_ZN3aaa9GG1111233D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF123E;
extern VTBL_ENTRY _ZTIN3aaa5FF123E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF123E[];
static Base_Class bases__ZN3aaa9GG1111233E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF123E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111233E[];
extern void _ZN3aaa9GG11112333fooEv();
extern void _ZN3aaa9GG11112333barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11112333fooEv,_ZThn8_N3aaa9GG11112333fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11112333fooEv,_ZThn20_N3aaa9GG11112333fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11112333barEv,_ZThn20_N3aaa9GG11112333barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11112333barEv,_ZThn28_N3aaa9GG11112333barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111233E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111233E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11112333fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11112333barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111233E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11112333fooEv,_ZThn8_N3aaa9GG11112333fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111233E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11112333fooEv,_ZThn20_N3aaa9GG11112333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11112333barEv,_ZThn20_N3aaa9GG11112333barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111233E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11112333barEv,_ZThn28_N3aaa9GG11112333barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111233E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111233E[];
Class_Descriptor cd__ZN3aaa9GG1111233E = {  "_ZN3aaa9GG1111233E", // class name
  bases__ZN3aaa9GG1111233E, 6,
  &(vtc__ZN3aaa9GG1111233E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111233E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111233E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111311  : ::aaa::EE111 , ::aaa::FF131 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11113113fooEv
  ~GG1111311(); // tgen
  GG1111311(); // tgen
};
//SIG(1 _ZN3aaa9GG1111311E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC3 BC6{ v1 v2 Fi} v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1111311 ::foo(){vfunc_called(this, "_ZN3aaa9GG11113113fooEv");}
aaa::GG1111311 ::~GG1111311(){ note_dtor("_ZN3aaa9GG1111311E", this);} // tgen
aaa::GG1111311 ::GG1111311(){ note_ctor("_ZN3aaa9GG1111311E", this);} // tgen
}
static void Test__ZN3aaa9GG1111311E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111311E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111311E, buf);
    ::aaa::GG1111311 *dp, &lv = *(dp=new (buf) ::aaa::GG1111311());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111311E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111311E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111311E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111311E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111311E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF131*), ABISELECT(32,20), "_ZN3aaa9GG1111311E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF131*), ABISELECT(48,28), "_ZN3aaa9GG1111311E");
    check_base_class_offset(lv, (::aaa::FF131*), ABISELECT(32,20), "_ZN3aaa9GG1111311E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111311E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111311E);
    dp->::aaa::GG1111311::~GG1111311();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111311E(Test__ZN3aaa9GG1111311E, "_ZN3aaa9GG1111311E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111311C1Ev();
extern void _ZN3aaa9GG1111311D1Ev();
Name_Map name_map__ZN3aaa9GG1111311E[] = {
  NSPAIR(_ZN3aaa9GG1111311C1Ev),
  NSPAIR(_ZN3aaa9GG1111311D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF131E;
extern VTBL_ENTRY _ZTIN3aaa5FF131E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF131E[];
static Base_Class bases__ZN3aaa9GG1111311E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    9, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF131E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111311E[];
extern void _ZN3aaa9GG11113113fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11113113fooEv,_ZThn8_N3aaa9GG11113113fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11113113fooEv,_ZThn20_N3aaa9GG11113113fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11113113fooEv,_ZThn28_N3aaa9GG11113113fooEv)();
extern void _ZN3aaa3BB33barEv();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111311E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111311E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11113113fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111311E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11113113fooEv,_ZThn8_N3aaa9GG11113113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111311E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11113113fooEv,_ZThn20_N3aaa9GG11113113fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111311E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11113113fooEv,_ZThn28_N3aaa9GG11113113fooEv),
  (VTBL_ENTRY)&_ZN3aaa3BB33barEv,
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111311E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111311E[];
Class_Descriptor cd__ZN3aaa9GG1111311E = {  "_ZN3aaa9GG1111311E", // class name
  bases__ZN3aaa9GG1111311E, 6,
  &(vtc__ZN3aaa9GG1111311E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111311E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111311E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111312  : ::aaa::EE111 , ::aaa::FF131 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11113123barEv
  ~GG1111312(); // tgen
  GG1111312(); // tgen
};
//SIG(1 _ZN3aaa9GG1111312E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC3 BC6{ v3 v1 Fi} v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1111312 ::bar(){vfunc_called(this, "_ZN3aaa9GG11113123barEv");}
aaa::GG1111312 ::~GG1111312(){ note_dtor("_ZN3aaa9GG1111312E", this);} // tgen
aaa::GG1111312 ::GG1111312(){ note_ctor("_ZN3aaa9GG1111312E", this);} // tgen
}
static void Test__ZN3aaa9GG1111312E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111312E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111312E, buf);
    ::aaa::GG1111312 *dp, &lv = *(dp=new (buf) ::aaa::GG1111312());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111312E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111312E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111312E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111312E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111312E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF131*), ABISELECT(32,20), "_ZN3aaa9GG1111312E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF131*), ABISELECT(48,28), "_ZN3aaa9GG1111312E");
    check_base_class_offset(lv, (::aaa::FF131*), ABISELECT(32,20), "_ZN3aaa9GG1111312E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111312E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111312E);
    dp->::aaa::GG1111312::~GG1111312();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111312E(Test__ZN3aaa9GG1111312E, "_ZN3aaa9GG1111312E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111312C1Ev();
extern void _ZN3aaa9GG1111312D1Ev();
Name_Map name_map__ZN3aaa9GG1111312E[] = {
  NSPAIR(_ZN3aaa9GG1111312C1Ev),
  NSPAIR(_ZN3aaa9GG1111312D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF131E;
extern VTBL_ENTRY _ZTIN3aaa5FF131E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF131E[];
static Base_Class bases__ZN3aaa9GG1111312E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF131E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111312E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11113123barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void _ZN3aaa5FF1313fooEv();
extern void ABISELECT(_ZThn16_N3aaa5FF1313fooEv,_ZThn8_N3aaa5FF1313fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11113123barEv,_ZThn28_N3aaa9GG11113123barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111312E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111312E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11113123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111312E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111312E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF1313fooEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111312E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF1313fooEv,_ZThn8_N3aaa5FF1313fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11113123barEv,_ZThn28_N3aaa9GG11113123barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111312E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111312E[];
Class_Descriptor cd__ZN3aaa9GG1111312E = {  "_ZN3aaa9GG1111312E", // class name
  bases__ZN3aaa9GG1111312E, 6,
  &(vtc__ZN3aaa9GG1111312E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111312E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111312E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111313  : ::aaa::EE111 , ::aaa::FF131 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11113133fooEv
  virtual void  bar(); // _ZN3aaa9GG11113133barEv
  ~GG1111313(); // tgen
  GG1111313(); // tgen
};
//SIG(1 _ZN3aaa9GG1111313E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC3 BC6{ v1 v2 Fi} v1 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1111313 ::foo(){vfunc_called(this, "_ZN3aaa9GG11113133fooEv");}
void  aaa::GG1111313 ::bar(){vfunc_called(this, "_ZN3aaa9GG11113133barEv");}
aaa::GG1111313 ::~GG1111313(){ note_dtor("_ZN3aaa9GG1111313E", this);} // tgen
aaa::GG1111313 ::GG1111313(){ note_ctor("_ZN3aaa9GG1111313E", this);} // tgen
}
static void Test__ZN3aaa9GG1111313E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111313E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111313E, buf);
    ::aaa::GG1111313 *dp, &lv = *(dp=new (buf) ::aaa::GG1111313());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111313E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111313E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111313E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111313E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111313E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF131*), ABISELECT(32,20), "_ZN3aaa9GG1111313E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF131*), ABISELECT(48,28), "_ZN3aaa9GG1111313E");
    check_base_class_offset(lv, (::aaa::FF131*), ABISELECT(32,20), "_ZN3aaa9GG1111313E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111313E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111313E);
    dp->::aaa::GG1111313::~GG1111313();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111313E(Test__ZN3aaa9GG1111313E, "_ZN3aaa9GG1111313E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111313C1Ev();
extern void _ZN3aaa9GG1111313D1Ev();
Name_Map name_map__ZN3aaa9GG1111313E[] = {
  NSPAIR(_ZN3aaa9GG1111313C1Ev),
  NSPAIR(_ZN3aaa9GG1111313D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF131E;
extern VTBL_ENTRY _ZTIN3aaa5FF131E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF131E[];
static Base_Class bases__ZN3aaa9GG1111313E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF131E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111313E[];
extern void _ZN3aaa9GG11113133fooEv();
extern void _ZN3aaa9GG11113133barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11113133fooEv,_ZThn8_N3aaa9GG11113133fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11113133fooEv,_ZThn20_N3aaa9GG11113133fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11113133fooEv,_ZThn28_N3aaa9GG11113133fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11113133barEv,_ZThn28_N3aaa9GG11113133barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111313E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111313E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11113133fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11113133barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111313E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11113133fooEv,_ZThn8_N3aaa9GG11113133fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111313E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11113133fooEv,_ZThn20_N3aaa9GG11113133fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111313E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11113133fooEv,_ZThn28_N3aaa9GG11113133fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11113133barEv,_ZThn28_N3aaa9GG11113133barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111313E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111313E[];
Class_Descriptor cd__ZN3aaa9GG1111313E = {  "_ZN3aaa9GG1111313E", // class name
  bases__ZN3aaa9GG1111313E, 6,
  &(vtc__ZN3aaa9GG1111313E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111313E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111313E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111321  : ::aaa::EE111 , ::aaa::FF132 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11113213fooEv
  ~GG1111321(); // tgen
  GG1111321(); // tgen
};
//SIG(1 _ZN3aaa9GG1111321E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC3 BC6{ v1 v2 Fi} v2 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1111321 ::foo(){vfunc_called(this, "_ZN3aaa9GG11113213fooEv");}
aaa::GG1111321 ::~GG1111321(){ note_dtor("_ZN3aaa9GG1111321E", this);} // tgen
aaa::GG1111321 ::GG1111321(){ note_ctor("_ZN3aaa9GG1111321E", this);} // tgen
}
static void Test__ZN3aaa9GG1111321E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111321E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111321E, buf);
    ::aaa::GG1111321 *dp, &lv = *(dp=new (buf) ::aaa::GG1111321());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111321E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111321E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111321E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111321E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111321E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF132*), ABISELECT(32,20), "_ZN3aaa9GG1111321E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF132*), ABISELECT(48,28), "_ZN3aaa9GG1111321E");
    check_base_class_offset(lv, (::aaa::FF132*), ABISELECT(32,20), "_ZN3aaa9GG1111321E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111321E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111321E);
    dp->::aaa::GG1111321::~GG1111321();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111321E(Test__ZN3aaa9GG1111321E, "_ZN3aaa9GG1111321E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111321C1Ev();
extern void _ZN3aaa9GG1111321D1Ev();
Name_Map name_map__ZN3aaa9GG1111321E[] = {
  NSPAIR(_ZN3aaa9GG1111321C1Ev),
  NSPAIR(_ZN3aaa9GG1111321D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF132E;
extern VTBL_ENTRY _ZTIN3aaa5FF132E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF132E[];
static Base_Class bases__ZN3aaa9GG1111321E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF132E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111321E[];
extern void _ZN3aaa9GG11113213fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11113213fooEv,_ZThn8_N3aaa9GG11113213fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11113213fooEv,_ZThn20_N3aaa9GG11113213fooEv)();
extern void _ZN3aaa5FF1323barEv();
extern void ABISELECT(_ZThn48_N3aaa9GG11113213fooEv,_ZThn28_N3aaa9GG11113213fooEv)();
extern void ABISELECT(_ZThn16_N3aaa5FF1323barEv,_ZThn8_N3aaa5FF1323barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111321E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111321E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11113213fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111321E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11113213fooEv,_ZThn8_N3aaa9GG11113213fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111321E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11113213fooEv,_ZThn20_N3aaa9GG11113213fooEv),
  (VTBL_ENTRY)&_ZN3aaa5FF1323barEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111321E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11113213fooEv,_ZThn28_N3aaa9GG11113213fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF1323barEv,_ZThn8_N3aaa5FF1323barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111321E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111321E[];
Class_Descriptor cd__ZN3aaa9GG1111321E = {  "_ZN3aaa9GG1111321E", // class name
  bases__ZN3aaa9GG1111321E, 6,
  &(vtc__ZN3aaa9GG1111321E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111321E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111321E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111322  : ::aaa::EE111 , ::aaa::FF132 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11113223barEv
  ~GG1111322(); // tgen
  GG1111322(); // tgen
};
//SIG(1 _ZN3aaa9GG1111322E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC3 BC6{ v3 v1 Fi} v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1111322 ::bar(){vfunc_called(this, "_ZN3aaa9GG11113223barEv");}
aaa::GG1111322 ::~GG1111322(){ note_dtor("_ZN3aaa9GG1111322E", this);} // tgen
aaa::GG1111322 ::GG1111322(){ note_ctor("_ZN3aaa9GG1111322E", this);} // tgen
}
static void Test__ZN3aaa9GG1111322E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111322E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111322E, buf);
    ::aaa::GG1111322 *dp, &lv = *(dp=new (buf) ::aaa::GG1111322());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111322E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111322E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111322E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111322E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111322E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF132*), ABISELECT(32,20), "_ZN3aaa9GG1111322E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF132*), ABISELECT(48,28), "_ZN3aaa9GG1111322E");
    check_base_class_offset(lv, (::aaa::FF132*), ABISELECT(32,20), "_ZN3aaa9GG1111322E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111322E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111322E);
    dp->::aaa::GG1111322::~GG1111322();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111322E(Test__ZN3aaa9GG1111322E, "_ZN3aaa9GG1111322E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111322C1Ev();
extern void _ZN3aaa9GG1111322D1Ev();
Name_Map name_map__ZN3aaa9GG1111322E[] = {
  NSPAIR(_ZN3aaa9GG1111322C1Ev),
  NSPAIR(_ZN3aaa9GG1111322D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF132E;
extern VTBL_ENTRY _ZTIN3aaa5FF132E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF132E[];
static Base_Class bases__ZN3aaa9GG1111322E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF132E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111322E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11113223barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void _ZN3aaa3AA13fooEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11113223barEv,_ZThn20_N3aaa9GG11113223barEv)();
extern void _ZN3aaa3BB33fooEv();
extern void ABISELECT(_ZThn48_N3aaa9GG11113223barEv,_ZThn28_N3aaa9GG11113223barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111322E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111322E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11113223barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111322E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111322E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA13fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11113223barEv,_ZThn20_N3aaa9GG11113223barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111322E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11113223barEv,_ZThn28_N3aaa9GG11113223barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111322E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111322E[];
Class_Descriptor cd__ZN3aaa9GG1111322E = {  "_ZN3aaa9GG1111322E", // class name
  bases__ZN3aaa9GG1111322E, 6,
  &(vtc__ZN3aaa9GG1111322E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111322E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111322E),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111323  : ::aaa::EE111 , ::aaa::FF132 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11113233fooEv
  virtual void  bar(); // _ZN3aaa9GG11113233barEv
  ~GG1111323(); // tgen
  GG1111323(); // tgen
};
//SIG(1 _ZN3aaa9GG1111323E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC3 BC6{ v1 v2 Fi} v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1111323 ::foo(){vfunc_called(this, "_ZN3aaa9GG11113233fooEv");}
void  aaa::GG1111323 ::bar(){vfunc_called(this, "_ZN3aaa9GG11113233barEv");}
aaa::GG1111323 ::~GG1111323(){ note_dtor("_ZN3aaa9GG1111323E", this);} // tgen
aaa::GG1111323 ::GG1111323(){ note_ctor("_ZN3aaa9GG1111323E", this);} // tgen
}
static void Test__ZN3aaa9GG1111323E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111323E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111323E, buf);
    ::aaa::GG1111323 *dp, &lv = *(dp=new (buf) ::aaa::GG1111323());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111323E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111323E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111323E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111323E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111323E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF132*), ABISELECT(32,20), "_ZN3aaa9GG1111323E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF132*), ABISELECT(48,28), "_ZN3aaa9GG1111323E");
    check_base_class_offset(lv, (::aaa::FF132*), ABISELECT(32,20), "_ZN3aaa9GG1111323E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111323E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111323E);
    dp->::aaa::GG1111323::~GG1111323();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111323E(Test__ZN3aaa9GG1111323E, "_ZN3aaa9GG1111323E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111323C1Ev();
extern void _ZN3aaa9GG1111323D1Ev();
Name_Map name_map__ZN3aaa9GG1111323E[] = {
  NSPAIR(_ZN3aaa9GG1111323C1Ev),
  NSPAIR(_ZN3aaa9GG1111323D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF132E;
extern VTBL_ENTRY _ZTIN3aaa5FF132E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF132E[];
static Base_Class bases__ZN3aaa9GG1111323E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF132E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111323E[];
extern void _ZN3aaa9GG11113233fooEv();
extern void _ZN3aaa9GG11113233barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11113233fooEv,_ZThn8_N3aaa9GG11113233fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11113233fooEv,_ZThn20_N3aaa9GG11113233fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11113233barEv,_ZThn20_N3aaa9GG11113233barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11113233fooEv,_ZThn28_N3aaa9GG11113233fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11113233barEv,_ZThn28_N3aaa9GG11113233barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111323E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111323E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11113233fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11113233barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111323E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11113233fooEv,_ZThn8_N3aaa9GG11113233fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111323E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11113233fooEv,_ZThn20_N3aaa9GG11113233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11113233barEv,_ZThn20_N3aaa9GG11113233barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111323E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11113233fooEv,_ZThn28_N3aaa9GG11113233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11113233barEv,_ZThn28_N3aaa9GG11113233barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111323E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111323E[];
Class_Descriptor cd__ZN3aaa9GG1111323E = {  "_ZN3aaa9GG1111323E", // class name
  bases__ZN3aaa9GG1111323E, 6,
  &(vtc__ZN3aaa9GG1111323E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111323E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111323E),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111331  : ::aaa::EE111 , ::aaa::FF133 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11113313fooEv
  ~GG1111331(); // tgen
  GG1111331(); // tgen
};
//SIG(1 _ZN3aaa9GG1111331E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC3 BC6{ v1 v2 Fi} v1 v2 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1111331 ::foo(){vfunc_called(this, "_ZN3aaa9GG11113313fooEv");}
aaa::GG1111331 ::~GG1111331(){ note_dtor("_ZN3aaa9GG1111331E", this);} // tgen
aaa::GG1111331 ::GG1111331(){ note_ctor("_ZN3aaa9GG1111331E", this);} // tgen
}
static void Test__ZN3aaa9GG1111331E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111331E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111331E, buf);
    ::aaa::GG1111331 *dp, &lv = *(dp=new (buf) ::aaa::GG1111331());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111331E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111331E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111331E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111331E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111331E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF133*), ABISELECT(32,20), "_ZN3aaa9GG1111331E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF133*), ABISELECT(48,28), "_ZN3aaa9GG1111331E");
    check_base_class_offset(lv, (::aaa::FF133*), ABISELECT(32,20), "_ZN3aaa9GG1111331E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111331E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111331E);
    dp->::aaa::GG1111331::~GG1111331();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111331E(Test__ZN3aaa9GG1111331E, "_ZN3aaa9GG1111331E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111331C1Ev();
extern void _ZN3aaa9GG1111331D1Ev();
Name_Map name_map__ZN3aaa9GG1111331E[] = {
  NSPAIR(_ZN3aaa9GG1111331C1Ev),
  NSPAIR(_ZN3aaa9GG1111331D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF133E;
extern VTBL_ENTRY _ZTIN3aaa5FF133E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF133E[];
static Base_Class bases__ZN3aaa9GG1111331E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF133E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111331E[];
extern void _ZN3aaa9GG11113313fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11113313fooEv,_ZThn8_N3aaa9GG11113313fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11113313fooEv,_ZThn20_N3aaa9GG11113313fooEv)();
extern void _ZN3aaa5FF1333barEv();
extern void ABISELECT(_ZThn48_N3aaa9GG11113313fooEv,_ZThn28_N3aaa9GG11113313fooEv)();
extern void ABISELECT(_ZThn16_N3aaa5FF1333barEv,_ZThn8_N3aaa5FF1333barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111331E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111331E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11113313fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111331E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11113313fooEv,_ZThn8_N3aaa9GG11113313fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111331E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11113313fooEv,_ZThn20_N3aaa9GG11113313fooEv),
  (VTBL_ENTRY)&_ZN3aaa5FF1333barEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111331E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11113313fooEv,_ZThn28_N3aaa9GG11113313fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF1333barEv,_ZThn8_N3aaa5FF1333barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111331E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111331E[];
Class_Descriptor cd__ZN3aaa9GG1111331E = {  "_ZN3aaa9GG1111331E", // class name
  bases__ZN3aaa9GG1111331E, 6,
  &(vtc__ZN3aaa9GG1111331E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111331E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111331E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111332  : ::aaa::EE111 , ::aaa::FF133 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11113323barEv
  ~GG1111332(); // tgen
  GG1111332(); // tgen
};
//SIG(1 _ZN3aaa9GG1111332E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC3 BC6{ v3 v1 Fi} v3 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1111332 ::bar(){vfunc_called(this, "_ZN3aaa9GG11113323barEv");}
aaa::GG1111332 ::~GG1111332(){ note_dtor("_ZN3aaa9GG1111332E", this);} // tgen
aaa::GG1111332 ::GG1111332(){ note_ctor("_ZN3aaa9GG1111332E", this);} // tgen
}
static void Test__ZN3aaa9GG1111332E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111332E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111332E, buf);
    ::aaa::GG1111332 *dp, &lv = *(dp=new (buf) ::aaa::GG1111332());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111332E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111332E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111332E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111332E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111332E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF133*), ABISELECT(32,20), "_ZN3aaa9GG1111332E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF133*), ABISELECT(48,28), "_ZN3aaa9GG1111332E");
    check_base_class_offset(lv, (::aaa::FF133*), ABISELECT(32,20), "_ZN3aaa9GG1111332E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111332E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111332E);
    dp->::aaa::GG1111332::~GG1111332();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111332E(Test__ZN3aaa9GG1111332E, "_ZN3aaa9GG1111332E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111332C1Ev();
extern void _ZN3aaa9GG1111332D1Ev();
Name_Map name_map__ZN3aaa9GG1111332E[] = {
  NSPAIR(_ZN3aaa9GG1111332C1Ev),
  NSPAIR(_ZN3aaa9GG1111332D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF133E;
extern VTBL_ENTRY _ZTIN3aaa5FF133E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF133E[];
static Base_Class bases__ZN3aaa9GG1111332E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF133E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111332E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11113323barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void _ZN3aaa5FF1333fooEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11113323barEv,_ZThn20_N3aaa9GG11113323barEv)();
extern void ABISELECT(_ZThn16_N3aaa5FF1333fooEv,_ZThn8_N3aaa5FF1333fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11113323barEv,_ZThn28_N3aaa9GG11113323barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111332E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111332E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11113323barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111332E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111332E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF1333fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11113323barEv,_ZThn20_N3aaa9GG11113323barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111332E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF1333fooEv,_ZThn8_N3aaa5FF1333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11113323barEv,_ZThn28_N3aaa9GG11113323barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111332E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111332E[];
Class_Descriptor cd__ZN3aaa9GG1111332E = {  "_ZN3aaa9GG1111332E", // class name
  bases__ZN3aaa9GG1111332E, 6,
  &(vtc__ZN3aaa9GG1111332E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111332E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111332E),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1111333  : ::aaa::EE111 , ::aaa::FF133 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11113333fooEv
  virtual void  bar(); // _ZN3aaa9GG11113333barEv
  ~GG1111333(); // tgen
  GG1111333(); // tgen
};
//SIG(1 _ZN3aaa9GG1111333E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC3 BC6{ v1 v2 Fi} v1 v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1111333 ::foo(){vfunc_called(this, "_ZN3aaa9GG11113333fooEv");}
void  aaa::GG1111333 ::bar(){vfunc_called(this, "_ZN3aaa9GG11113333barEv");}
aaa::GG1111333 ::~GG1111333(){ note_dtor("_ZN3aaa9GG1111333E", this);} // tgen
aaa::GG1111333 ::GG1111333(){ note_ctor("_ZN3aaa9GG1111333E", this);} // tgen
}
static void Test__ZN3aaa9GG1111333E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1111333E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1111333E, buf);
    ::aaa::GG1111333 *dp, &lv = *(dp=new (buf) ::aaa::GG1111333());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1111333E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1111333E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1111333E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1111333E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1111333E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF133*), ABISELECT(32,20), "_ZN3aaa9GG1111333E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF133*), ABISELECT(48,28), "_ZN3aaa9GG1111333E");
    check_base_class_offset(lv, (::aaa::FF133*), ABISELECT(32,20), "_ZN3aaa9GG1111333E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1111333E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1111333E);
    dp->::aaa::GG1111333::~GG1111333();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1111333E(Test__ZN3aaa9GG1111333E, "_ZN3aaa9GG1111333E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1111333C1Ev();
extern void _ZN3aaa9GG1111333D1Ev();
Name_Map name_map__ZN3aaa9GG1111333E[] = {
  NSPAIR(_ZN3aaa9GG1111333C1Ev),
  NSPAIR(_ZN3aaa9GG1111333D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF133E;
extern VTBL_ENTRY _ZTIN3aaa5FF133E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF133E[];
static Base_Class bases__ZN3aaa9GG1111333E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF133E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1111333E[];
extern void _ZN3aaa9GG11113333fooEv();
extern void _ZN3aaa9GG11113333barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11113333fooEv,_ZThn8_N3aaa9GG11113333fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11113333fooEv,_ZThn20_N3aaa9GG11113333fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11113333barEv,_ZThn20_N3aaa9GG11113333barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11113333fooEv,_ZThn28_N3aaa9GG11113333fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11113333barEv,_ZThn28_N3aaa9GG11113333barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1111333E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111333E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11113333fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11113333barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111333E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11113333fooEv,_ZThn8_N3aaa9GG11113333fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111333E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11113333fooEv,_ZThn20_N3aaa9GG11113333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11113333barEv,_ZThn20_N3aaa9GG11113333barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1111333E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11113333fooEv,_ZThn28_N3aaa9GG11113333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11113333barEv,_ZThn28_N3aaa9GG11113333barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1111333E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1111333E[];
Class_Descriptor cd__ZN3aaa9GG1111333E = {  "_ZN3aaa9GG1111333E", // class name
  bases__ZN3aaa9GG1111333E, 6,
  &(vtc__ZN3aaa9GG1111333E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1111333E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1111333E),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112111  : ::aaa::EE111 , ::aaa::FF211 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11121113fooEv
  ~GG1112111(); // tgen
  GG1112111(); // tgen
};
//SIG(1 _ZN3aaa9GG1112111E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v2 Fi} BC4 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1112111 ::foo(){vfunc_called(this, "_ZN3aaa9GG11121113fooEv");}
aaa::GG1112111 ::~GG1112111(){ note_dtor("_ZN3aaa9GG1112111E", this);} // tgen
aaa::GG1112111 ::GG1112111(){ note_ctor("_ZN3aaa9GG1112111E", this);} // tgen
}
static void Test__ZN3aaa9GG1112111E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112111E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112111E, buf);
    ::aaa::GG1112111 *dp, &lv = *(dp=new (buf) ::aaa::GG1112111());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112111E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112111E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112111E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112111E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112111E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF211*), ABISELECT(32,20), "_ZN3aaa9GG1112111E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF211*), ABISELECT(48,28), "_ZN3aaa9GG1112111E");
    check_base_class_offset(lv, (::aaa::FF211*), ABISELECT(32,20), "_ZN3aaa9GG1112111E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112111E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112111E);
    dp->::aaa::GG1112111::~GG1112111();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112111E(Test__ZN3aaa9GG1112111E, "_ZN3aaa9GG1112111E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112111C1Ev();
extern void _ZN3aaa9GG1112111D1Ev();
Name_Map name_map__ZN3aaa9GG1112111E[] = {
  NSPAIR(_ZN3aaa9GG1112111C1Ev),
  NSPAIR(_ZN3aaa9GG1112111D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF211E;
extern VTBL_ENTRY _ZTIN3aaa5FF211E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF211E[];
static Base_Class bases__ZN3aaa9GG1112111E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF211E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112111E[];
extern void _ZN3aaa9GG11121113fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11121113fooEv,_ZThn8_N3aaa9GG11121113fooEv)();
extern void _ZN3aaa3AA23barEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11121113fooEv,_ZThn20_N3aaa9GG11121113fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11121113fooEv,_ZThn28_N3aaa9GG11121113fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112111E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112111E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11121113fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112111E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11121113fooEv,_ZThn8_N3aaa9GG11121113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112111E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA23barEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11121113fooEv,_ZThn20_N3aaa9GG11121113fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112111E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11121113fooEv,_ZThn28_N3aaa9GG11121113fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112111E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112111E[];
Class_Descriptor cd__ZN3aaa9GG1112111E = {  "_ZN3aaa9GG1112111E", // class name
  bases__ZN3aaa9GG1112111E, 6,
  &(vtc__ZN3aaa9GG1112111E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112111E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112111E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112112  : ::aaa::EE111 , ::aaa::FF211 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11121123barEv
  ~GG1112112(); // tgen
  GG1112112(); // tgen
};
//SIG(1 _ZN3aaa9GG1112112E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC6{ v1 Fi} BC4 v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1112112 ::bar(){vfunc_called(this, "_ZN3aaa9GG11121123barEv");}
aaa::GG1112112 ::~GG1112112(){ note_dtor("_ZN3aaa9GG1112112E", this);} // tgen
aaa::GG1112112 ::GG1112112(){ note_ctor("_ZN3aaa9GG1112112E", this);} // tgen
}
static void Test__ZN3aaa9GG1112112E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112112E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112112E, buf);
    ::aaa::GG1112112 *dp, &lv = *(dp=new (buf) ::aaa::GG1112112());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112112E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112112E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112112E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112112E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112112E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF211*), ABISELECT(32,20), "_ZN3aaa9GG1112112E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF211*), ABISELECT(48,28), "_ZN3aaa9GG1112112E");
    check_base_class_offset(lv, (::aaa::FF211*), ABISELECT(32,20), "_ZN3aaa9GG1112112E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112112E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112112E);
    dp->::aaa::GG1112112::~GG1112112();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112112E(Test__ZN3aaa9GG1112112E, "_ZN3aaa9GG1112112E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112112C1Ev();
extern void _ZN3aaa9GG1112112D1Ev();
Name_Map name_map__ZN3aaa9GG1112112E[] = {
  NSPAIR(_ZN3aaa9GG1112112C1Ev),
  NSPAIR(_ZN3aaa9GG1112112D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF211E;
extern VTBL_ENTRY _ZTIN3aaa5FF211E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF211E[];
static Base_Class bases__ZN3aaa9GG1112112E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF211E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112112E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11121123barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11121123barEv,_ZThn20_N3aaa9GG11121123barEv)();
extern void _ZN3aaa5FF2113fooEv();
extern void ABISELECT(_ZThn16_N3aaa5FF2113fooEv,_ZThn8_N3aaa5FF2113fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112112E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112112E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11121123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112112E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112112E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11121123barEv,_ZThn20_N3aaa9GG11121123barEv),
  (VTBL_ENTRY)&_ZN3aaa5FF2113fooEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112112E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF2113fooEv,_ZThn8_N3aaa5FF2113fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112112E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112112E[];
Class_Descriptor cd__ZN3aaa9GG1112112E = {  "_ZN3aaa9GG1112112E", // class name
  bases__ZN3aaa9GG1112112E, 6,
  &(vtc__ZN3aaa9GG1112112E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112112E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112112E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112113  : ::aaa::EE111 , ::aaa::FF211 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11121133fooEv
  virtual void  bar(); // _ZN3aaa9GG11121133barEv
  ~GG1112113(); // tgen
  GG1112113(); // tgen
};
//SIG(1 _ZN3aaa9GG1112113E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v2 Fi} BC4 v1 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1112113 ::foo(){vfunc_called(this, "_ZN3aaa9GG11121133fooEv");}
void  aaa::GG1112113 ::bar(){vfunc_called(this, "_ZN3aaa9GG11121133barEv");}
aaa::GG1112113 ::~GG1112113(){ note_dtor("_ZN3aaa9GG1112113E", this);} // tgen
aaa::GG1112113 ::GG1112113(){ note_ctor("_ZN3aaa9GG1112113E", this);} // tgen
}
static void Test__ZN3aaa9GG1112113E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112113E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112113E, buf);
    ::aaa::GG1112113 *dp, &lv = *(dp=new (buf) ::aaa::GG1112113());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112113E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112113E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112113E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112113E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112113E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF211*), ABISELECT(32,20), "_ZN3aaa9GG1112113E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF211*), ABISELECT(48,28), "_ZN3aaa9GG1112113E");
    check_base_class_offset(lv, (::aaa::FF211*), ABISELECT(32,20), "_ZN3aaa9GG1112113E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112113E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112113E);
    dp->::aaa::GG1112113::~GG1112113();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112113E(Test__ZN3aaa9GG1112113E, "_ZN3aaa9GG1112113E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112113C1Ev();
extern void _ZN3aaa9GG1112113D1Ev();
Name_Map name_map__ZN3aaa9GG1112113E[] = {
  NSPAIR(_ZN3aaa9GG1112113C1Ev),
  NSPAIR(_ZN3aaa9GG1112113D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF211E;
extern VTBL_ENTRY _ZTIN3aaa5FF211E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF211E[];
static Base_Class bases__ZN3aaa9GG1112113E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF211E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112113E[];
extern void _ZN3aaa9GG11121133fooEv();
extern void _ZN3aaa9GG11121133barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11121133fooEv,_ZThn8_N3aaa9GG11121133fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11121133barEv,_ZThn20_N3aaa9GG11121133barEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11121133fooEv,_ZThn20_N3aaa9GG11121133fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11121133fooEv,_ZThn28_N3aaa9GG11121133fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112113E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112113E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11121133fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11121133barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112113E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11121133fooEv,_ZThn8_N3aaa9GG11121133fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112113E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11121133barEv,_ZThn20_N3aaa9GG11121133barEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11121133fooEv,_ZThn20_N3aaa9GG11121133fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112113E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11121133fooEv,_ZThn28_N3aaa9GG11121133fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112113E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112113E[];
Class_Descriptor cd__ZN3aaa9GG1112113E = {  "_ZN3aaa9GG1112113E", // class name
  bases__ZN3aaa9GG1112113E, 6,
  &(vtc__ZN3aaa9GG1112113E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112113E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112113E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112121  : ::aaa::EE111 , ::aaa::FF212 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11121213fooEv
  ~GG1112121(); // tgen
  GG1112121(); // tgen
};
//SIG(1 _ZN3aaa9GG1112121E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v2 Fi} BC4 v2 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1112121 ::foo(){vfunc_called(this, "_ZN3aaa9GG11121213fooEv");}
aaa::GG1112121 ::~GG1112121(){ note_dtor("_ZN3aaa9GG1112121E", this);} // tgen
aaa::GG1112121 ::GG1112121(){ note_ctor("_ZN3aaa9GG1112121E", this);} // tgen
}
static void Test__ZN3aaa9GG1112121E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112121E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112121E, buf);
    ::aaa::GG1112121 *dp, &lv = *(dp=new (buf) ::aaa::GG1112121());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112121E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112121E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112121E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112121E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112121E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF212*), ABISELECT(32,20), "_ZN3aaa9GG1112121E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF212*), ABISELECT(48,28), "_ZN3aaa9GG1112121E");
    check_base_class_offset(lv, (::aaa::FF212*), ABISELECT(32,20), "_ZN3aaa9GG1112121E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112121E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112121E);
    dp->::aaa::GG1112121::~GG1112121();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112121E(Test__ZN3aaa9GG1112121E, "_ZN3aaa9GG1112121E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112121C1Ev();
extern void _ZN3aaa9GG1112121D1Ev();
Name_Map name_map__ZN3aaa9GG1112121E[] = {
  NSPAIR(_ZN3aaa9GG1112121C1Ev),
  NSPAIR(_ZN3aaa9GG1112121D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF212E;
extern VTBL_ENTRY _ZTIN3aaa5FF212E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF212E[];
static Base_Class bases__ZN3aaa9GG1112121E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    9, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF212E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112121E[];
extern void _ZN3aaa9GG11121213fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11121213fooEv,_ZThn8_N3aaa9GG11121213fooEv)();
extern void _ZN3aaa5FF2123barEv();
extern void ABISELECT(_ZThn48_N3aaa9GG11121213fooEv,_ZThn28_N3aaa9GG11121213fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112121E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112121E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11121213fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112121E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11121213fooEv,_ZThn8_N3aaa9GG11121213fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112121E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF2123barEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112121E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11121213fooEv,_ZThn28_N3aaa9GG11121213fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112121E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112121E[];
Class_Descriptor cd__ZN3aaa9GG1112121E = {  "_ZN3aaa9GG1112121E", // class name
  bases__ZN3aaa9GG1112121E, 6,
  &(vtc__ZN3aaa9GG1112121E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112121E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112121E),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112122  : ::aaa::EE111 , ::aaa::FF212 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11121223barEv
  ~GG1112122(); // tgen
  GG1112122(); // tgen
};
//SIG(1 _ZN3aaa9GG1112122E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC6{ v1 Fi} BC4 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1112122 ::bar(){vfunc_called(this, "_ZN3aaa9GG11121223barEv");}
aaa::GG1112122 ::~GG1112122(){ note_dtor("_ZN3aaa9GG1112122E", this);} // tgen
aaa::GG1112122 ::GG1112122(){ note_ctor("_ZN3aaa9GG1112122E", this);} // tgen
}
static void Test__ZN3aaa9GG1112122E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112122E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112122E, buf);
    ::aaa::GG1112122 *dp, &lv = *(dp=new (buf) ::aaa::GG1112122());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112122E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112122E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112122E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112122E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112122E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF212*), ABISELECT(32,20), "_ZN3aaa9GG1112122E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF212*), ABISELECT(48,28), "_ZN3aaa9GG1112122E");
    check_base_class_offset(lv, (::aaa::FF212*), ABISELECT(32,20), "_ZN3aaa9GG1112122E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112122E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112122E);
    dp->::aaa::GG1112122::~GG1112122();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112122E(Test__ZN3aaa9GG1112122E, "_ZN3aaa9GG1112122E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112122C1Ev();
extern void _ZN3aaa9GG1112122D1Ev();
Name_Map name_map__ZN3aaa9GG1112122E[] = {
  NSPAIR(_ZN3aaa9GG1112122C1Ev),
  NSPAIR(_ZN3aaa9GG1112122D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF212E;
extern VTBL_ENTRY _ZTIN3aaa5FF212E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF212E[];
static Base_Class bases__ZN3aaa9GG1112122E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF212E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112122E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11121223barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11121223barEv,_ZThn20_N3aaa9GG11121223barEv)();
extern void _ZN3aaa3BB13fooEv();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112122E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112122E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11121223barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112122E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112122E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11121223barEv,_ZThn20_N3aaa9GG11121223barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112122E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB13fooEv,
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112122E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112122E[];
Class_Descriptor cd__ZN3aaa9GG1112122E = {  "_ZN3aaa9GG1112122E", // class name
  bases__ZN3aaa9GG1112122E, 6,
  &(vtc__ZN3aaa9GG1112122E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112122E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112122E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112123  : ::aaa::EE111 , ::aaa::FF212 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11121233fooEv
  virtual void  bar(); // _ZN3aaa9GG11121233barEv
  ~GG1112123(); // tgen
  GG1112123(); // tgen
};
//SIG(1 _ZN3aaa9GG1112123E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v2 Fi} BC4 v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1112123 ::foo(){vfunc_called(this, "_ZN3aaa9GG11121233fooEv");}
void  aaa::GG1112123 ::bar(){vfunc_called(this, "_ZN3aaa9GG11121233barEv");}
aaa::GG1112123 ::~GG1112123(){ note_dtor("_ZN3aaa9GG1112123E", this);} // tgen
aaa::GG1112123 ::GG1112123(){ note_ctor("_ZN3aaa9GG1112123E", this);} // tgen
}
static void Test__ZN3aaa9GG1112123E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112123E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112123E, buf);
    ::aaa::GG1112123 *dp, &lv = *(dp=new (buf) ::aaa::GG1112123());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112123E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112123E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112123E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112123E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112123E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF212*), ABISELECT(32,20), "_ZN3aaa9GG1112123E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF212*), ABISELECT(48,28), "_ZN3aaa9GG1112123E");
    check_base_class_offset(lv, (::aaa::FF212*), ABISELECT(32,20), "_ZN3aaa9GG1112123E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112123E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112123E);
    dp->::aaa::GG1112123::~GG1112123();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112123E(Test__ZN3aaa9GG1112123E, "_ZN3aaa9GG1112123E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112123C1Ev();
extern void _ZN3aaa9GG1112123D1Ev();
Name_Map name_map__ZN3aaa9GG1112123E[] = {
  NSPAIR(_ZN3aaa9GG1112123C1Ev),
  NSPAIR(_ZN3aaa9GG1112123D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF212E;
extern VTBL_ENTRY _ZTIN3aaa5FF212E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF212E[];
static Base_Class bases__ZN3aaa9GG1112123E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF212E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112123E[];
extern void _ZN3aaa9GG11121233fooEv();
extern void _ZN3aaa9GG11121233barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11121233fooEv,_ZThn8_N3aaa9GG11121233fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11121233barEv,_ZThn20_N3aaa9GG11121233barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11121233fooEv,_ZThn28_N3aaa9GG11121233fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112123E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112123E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11121233fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11121233barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112123E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11121233fooEv,_ZThn8_N3aaa9GG11121233fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112123E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11121233barEv,_ZThn20_N3aaa9GG11121233barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112123E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11121233fooEv,_ZThn28_N3aaa9GG11121233fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112123E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112123E[];
Class_Descriptor cd__ZN3aaa9GG1112123E = {  "_ZN3aaa9GG1112123E", // class name
  bases__ZN3aaa9GG1112123E, 6,
  &(vtc__ZN3aaa9GG1112123E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112123E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112123E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112131  : ::aaa::EE111 , ::aaa::FF213 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11121313fooEv
  ~GG1112131(); // tgen
  GG1112131(); // tgen
};
//SIG(1 _ZN3aaa9GG1112131E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v2 Fi} BC4 v1 v2 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1112131 ::foo(){vfunc_called(this, "_ZN3aaa9GG11121313fooEv");}
aaa::GG1112131 ::~GG1112131(){ note_dtor("_ZN3aaa9GG1112131E", this);} // tgen
aaa::GG1112131 ::GG1112131(){ note_ctor("_ZN3aaa9GG1112131E", this);} // tgen
}
static void Test__ZN3aaa9GG1112131E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112131E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112131E, buf);
    ::aaa::GG1112131 *dp, &lv = *(dp=new (buf) ::aaa::GG1112131());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112131E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112131E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112131E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112131E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112131E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF213*), ABISELECT(32,20), "_ZN3aaa9GG1112131E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF213*), ABISELECT(48,28), "_ZN3aaa9GG1112131E");
    check_base_class_offset(lv, (::aaa::FF213*), ABISELECT(32,20), "_ZN3aaa9GG1112131E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112131E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112131E);
    dp->::aaa::GG1112131::~GG1112131();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112131E(Test__ZN3aaa9GG1112131E, "_ZN3aaa9GG1112131E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112131C1Ev();
extern void _ZN3aaa9GG1112131D1Ev();
Name_Map name_map__ZN3aaa9GG1112131E[] = {
  NSPAIR(_ZN3aaa9GG1112131C1Ev),
  NSPAIR(_ZN3aaa9GG1112131D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF213E;
extern VTBL_ENTRY _ZTIN3aaa5FF213E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF213E[];
static Base_Class bases__ZN3aaa9GG1112131E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF213E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112131E[];
extern void _ZN3aaa9GG11121313fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11121313fooEv,_ZThn8_N3aaa9GG11121313fooEv)();
extern void _ZN3aaa5FF2133barEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11121313fooEv,_ZThn20_N3aaa9GG11121313fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11121313fooEv,_ZThn28_N3aaa9GG11121313fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112131E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112131E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11121313fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112131E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11121313fooEv,_ZThn8_N3aaa9GG11121313fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112131E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF2133barEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11121313fooEv,_ZThn20_N3aaa9GG11121313fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112131E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11121313fooEv,_ZThn28_N3aaa9GG11121313fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112131E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112131E[];
Class_Descriptor cd__ZN3aaa9GG1112131E = {  "_ZN3aaa9GG1112131E", // class name
  bases__ZN3aaa9GG1112131E, 6,
  &(vtc__ZN3aaa9GG1112131E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112131E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112131E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112132  : ::aaa::EE111 , ::aaa::FF213 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11121323barEv
  ~GG1112132(); // tgen
  GG1112132(); // tgen
};
//SIG(1 _ZN3aaa9GG1112132E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC6{ v1 Fi} BC4 v3 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1112132 ::bar(){vfunc_called(this, "_ZN3aaa9GG11121323barEv");}
aaa::GG1112132 ::~GG1112132(){ note_dtor("_ZN3aaa9GG1112132E", this);} // tgen
aaa::GG1112132 ::GG1112132(){ note_ctor("_ZN3aaa9GG1112132E", this);} // tgen
}
static void Test__ZN3aaa9GG1112132E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112132E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112132E, buf);
    ::aaa::GG1112132 *dp, &lv = *(dp=new (buf) ::aaa::GG1112132());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112132E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112132E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112132E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112132E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112132E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF213*), ABISELECT(32,20), "_ZN3aaa9GG1112132E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF213*), ABISELECT(48,28), "_ZN3aaa9GG1112132E");
    check_base_class_offset(lv, (::aaa::FF213*), ABISELECT(32,20), "_ZN3aaa9GG1112132E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112132E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112132E);
    dp->::aaa::GG1112132::~GG1112132();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112132E(Test__ZN3aaa9GG1112132E, "_ZN3aaa9GG1112132E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112132C1Ev();
extern void _ZN3aaa9GG1112132D1Ev();
Name_Map name_map__ZN3aaa9GG1112132E[] = {
  NSPAIR(_ZN3aaa9GG1112132C1Ev),
  NSPAIR(_ZN3aaa9GG1112132D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF213E;
extern VTBL_ENTRY _ZTIN3aaa5FF213E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF213E[];
static Base_Class bases__ZN3aaa9GG1112132E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF213E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112132E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11121323barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11121323barEv,_ZThn20_N3aaa9GG11121323barEv)();
extern void _ZN3aaa5FF2133fooEv();
extern void ABISELECT(_ZThn16_N3aaa5FF2133fooEv,_ZThn8_N3aaa5FF2133fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112132E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112132E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11121323barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112132E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112132E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11121323barEv,_ZThn20_N3aaa9GG11121323barEv),
  (VTBL_ENTRY)&_ZN3aaa5FF2133fooEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112132E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF2133fooEv,_ZThn8_N3aaa5FF2133fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112132E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112132E[];
Class_Descriptor cd__ZN3aaa9GG1112132E = {  "_ZN3aaa9GG1112132E", // class name
  bases__ZN3aaa9GG1112132E, 6,
  &(vtc__ZN3aaa9GG1112132E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112132E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112132E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112133  : ::aaa::EE111 , ::aaa::FF213 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11121333fooEv
  virtual void  bar(); // _ZN3aaa9GG11121333barEv
  ~GG1112133(); // tgen
  GG1112133(); // tgen
};
//SIG(1 _ZN3aaa9GG1112133E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v2 Fi} BC4 v1 v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1112133 ::foo(){vfunc_called(this, "_ZN3aaa9GG11121333fooEv");}
void  aaa::GG1112133 ::bar(){vfunc_called(this, "_ZN3aaa9GG11121333barEv");}
aaa::GG1112133 ::~GG1112133(){ note_dtor("_ZN3aaa9GG1112133E", this);} // tgen
aaa::GG1112133 ::GG1112133(){ note_ctor("_ZN3aaa9GG1112133E", this);} // tgen
}
static void Test__ZN3aaa9GG1112133E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112133E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112133E, buf);
    ::aaa::GG1112133 *dp, &lv = *(dp=new (buf) ::aaa::GG1112133());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112133E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112133E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112133E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112133E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112133E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF213*), ABISELECT(32,20), "_ZN3aaa9GG1112133E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF213*), ABISELECT(48,28), "_ZN3aaa9GG1112133E");
    check_base_class_offset(lv, (::aaa::FF213*), ABISELECT(32,20), "_ZN3aaa9GG1112133E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112133E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112133E);
    dp->::aaa::GG1112133::~GG1112133();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112133E(Test__ZN3aaa9GG1112133E, "_ZN3aaa9GG1112133E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112133C1Ev();
extern void _ZN3aaa9GG1112133D1Ev();
Name_Map name_map__ZN3aaa9GG1112133E[] = {
  NSPAIR(_ZN3aaa9GG1112133C1Ev),
  NSPAIR(_ZN3aaa9GG1112133D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF213E;
extern VTBL_ENTRY _ZTIN3aaa5FF213E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF213E[];
static Base_Class bases__ZN3aaa9GG1112133E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF213E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112133E[];
extern void _ZN3aaa9GG11121333fooEv();
extern void _ZN3aaa9GG11121333barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11121333fooEv,_ZThn8_N3aaa9GG11121333fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11121333barEv,_ZThn20_N3aaa9GG11121333barEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11121333fooEv,_ZThn20_N3aaa9GG11121333fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11121333fooEv,_ZThn28_N3aaa9GG11121333fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112133E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112133E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11121333fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11121333barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112133E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11121333fooEv,_ZThn8_N3aaa9GG11121333fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112133E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11121333barEv,_ZThn20_N3aaa9GG11121333barEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11121333fooEv,_ZThn20_N3aaa9GG11121333fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112133E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11121333fooEv,_ZThn28_N3aaa9GG11121333fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112133E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112133E[];
Class_Descriptor cd__ZN3aaa9GG1112133E = {  "_ZN3aaa9GG1112133E", // class name
  bases__ZN3aaa9GG1112133E, 6,
  &(vtc__ZN3aaa9GG1112133E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112133E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112133E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112211  : ::aaa::EE111 , ::aaa::FF221 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11122113fooEv
  ~GG1112211(); // tgen
  GG1112211(); // tgen
};
//SIG(1 _ZN3aaa9GG1112211E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v2 Fi} BC7{ v3 Fi} v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1112211 ::foo(){vfunc_called(this, "_ZN3aaa9GG11122113fooEv");}
aaa::GG1112211 ::~GG1112211(){ note_dtor("_ZN3aaa9GG1112211E", this);} // tgen
aaa::GG1112211 ::GG1112211(){ note_ctor("_ZN3aaa9GG1112211E", this);} // tgen
}
static void Test__ZN3aaa9GG1112211E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112211E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112211E, buf);
    ::aaa::GG1112211 *dp, &lv = *(dp=new (buf) ::aaa::GG1112211());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112211E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112211E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112211E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112211E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112211E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF221*), ABISELECT(32,20), "_ZN3aaa9GG1112211E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF221*), ABISELECT(48,28), "_ZN3aaa9GG1112211E");
    check_base_class_offset(lv, (::aaa::FF221*), ABISELECT(32,20), "_ZN3aaa9GG1112211E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112211E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112211E);
    dp->::aaa::GG1112211::~GG1112211();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112211E(Test__ZN3aaa9GG1112211E, "_ZN3aaa9GG1112211E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112211C1Ev();
extern void _ZN3aaa9GG1112211D1Ev();
Name_Map name_map__ZN3aaa9GG1112211E[] = {
  NSPAIR(_ZN3aaa9GG1112211C1Ev),
  NSPAIR(_ZN3aaa9GG1112211D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF221E;
extern VTBL_ENTRY _ZTIN3aaa5FF221E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF221E[];
static Base_Class bases__ZN3aaa9GG1112211E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF221E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112211E[];
extern void _ZN3aaa9GG11122113fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11122113fooEv,_ZThn8_N3aaa9GG11122113fooEv)();
extern void _ZN3aaa3AA23barEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11122113fooEv,_ZThn20_N3aaa9GG11122113fooEv)();
extern void _ZN3aaa3BB23barEv();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112211E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112211E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11122113fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112211E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11122113fooEv,_ZThn8_N3aaa9GG11122113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112211E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA23barEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11122113fooEv,_ZThn20_N3aaa9GG11122113fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112211E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB23barEv,
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112211E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112211E[];
Class_Descriptor cd__ZN3aaa9GG1112211E = {  "_ZN3aaa9GG1112211E", // class name
  bases__ZN3aaa9GG1112211E, 6,
  &(vtc__ZN3aaa9GG1112211E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112211E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112211E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112212  : ::aaa::EE111 , ::aaa::FF221 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11122123barEv
  ~GG1112212(); // tgen
  GG1112212(); // tgen
};
//SIG(1 _ZN3aaa9GG1112212E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC6{ v1 Fi} BC7{ v1 Fi} v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1112212 ::bar(){vfunc_called(this, "_ZN3aaa9GG11122123barEv");}
aaa::GG1112212 ::~GG1112212(){ note_dtor("_ZN3aaa9GG1112212E", this);} // tgen
aaa::GG1112212 ::GG1112212(){ note_ctor("_ZN3aaa9GG1112212E", this);} // tgen
}
static void Test__ZN3aaa9GG1112212E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112212E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112212E, buf);
    ::aaa::GG1112212 *dp, &lv = *(dp=new (buf) ::aaa::GG1112212());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112212E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112212E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112212E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112212E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112212E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF221*), ABISELECT(32,20), "_ZN3aaa9GG1112212E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF221*), ABISELECT(48,28), "_ZN3aaa9GG1112212E");
    check_base_class_offset(lv, (::aaa::FF221*), ABISELECT(32,20), "_ZN3aaa9GG1112212E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112212E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112212E);
    dp->::aaa::GG1112212::~GG1112212();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112212E(Test__ZN3aaa9GG1112212E, "_ZN3aaa9GG1112212E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112212C1Ev();
extern void _ZN3aaa9GG1112212D1Ev();
Name_Map name_map__ZN3aaa9GG1112212E[] = {
  NSPAIR(_ZN3aaa9GG1112212C1Ev),
  NSPAIR(_ZN3aaa9GG1112212D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF221E;
extern VTBL_ENTRY _ZTIN3aaa5FF221E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF221E[];
static Base_Class bases__ZN3aaa9GG1112212E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF221E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112212E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11122123barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11122123barEv,_ZThn20_N3aaa9GG11122123barEv)();
extern void _ZN3aaa5FF2213fooEv();
extern void ABISELECT(_ZThn48_N3aaa9GG11122123barEv,_ZThn28_N3aaa9GG11122123barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112212E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112212E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11122123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112212E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112212E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11122123barEv,_ZThn20_N3aaa9GG11122123barEv),
  (VTBL_ENTRY)&_ZN3aaa5FF2213fooEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112212E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11122123barEv,_ZThn28_N3aaa9GG11122123barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112212E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112212E[];
Class_Descriptor cd__ZN3aaa9GG1112212E = {  "_ZN3aaa9GG1112212E", // class name
  bases__ZN3aaa9GG1112212E, 6,
  &(vtc__ZN3aaa9GG1112212E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112212E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112212E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112213  : ::aaa::EE111 , ::aaa::FF221 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11122133fooEv
  virtual void  bar(); // _ZN3aaa9GG11122133barEv
  ~GG1112213(); // tgen
  GG1112213(); // tgen
};
//SIG(1 _ZN3aaa9GG1112213E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v2 Fi} BC7{ v2 Fi} v1 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1112213 ::foo(){vfunc_called(this, "_ZN3aaa9GG11122133fooEv");}
void  aaa::GG1112213 ::bar(){vfunc_called(this, "_ZN3aaa9GG11122133barEv");}
aaa::GG1112213 ::~GG1112213(){ note_dtor("_ZN3aaa9GG1112213E", this);} // tgen
aaa::GG1112213 ::GG1112213(){ note_ctor("_ZN3aaa9GG1112213E", this);} // tgen
}
static void Test__ZN3aaa9GG1112213E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112213E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112213E, buf);
    ::aaa::GG1112213 *dp, &lv = *(dp=new (buf) ::aaa::GG1112213());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112213E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112213E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112213E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112213E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112213E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF221*), ABISELECT(32,20), "_ZN3aaa9GG1112213E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF221*), ABISELECT(48,28), "_ZN3aaa9GG1112213E");
    check_base_class_offset(lv, (::aaa::FF221*), ABISELECT(32,20), "_ZN3aaa9GG1112213E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112213E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112213E);
    dp->::aaa::GG1112213::~GG1112213();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112213E(Test__ZN3aaa9GG1112213E, "_ZN3aaa9GG1112213E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112213C1Ev();
extern void _ZN3aaa9GG1112213D1Ev();
Name_Map name_map__ZN3aaa9GG1112213E[] = {
  NSPAIR(_ZN3aaa9GG1112213C1Ev),
  NSPAIR(_ZN3aaa9GG1112213D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF221E;
extern VTBL_ENTRY _ZTIN3aaa5FF221E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF221E[];
static Base_Class bases__ZN3aaa9GG1112213E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF221E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112213E[];
extern void _ZN3aaa9GG11122133fooEv();
extern void _ZN3aaa9GG11122133barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11122133fooEv,_ZThn8_N3aaa9GG11122133fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11122133barEv,_ZThn20_N3aaa9GG11122133barEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11122133fooEv,_ZThn20_N3aaa9GG11122133fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11122133barEv,_ZThn28_N3aaa9GG11122133barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112213E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112213E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11122133fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11122133barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112213E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11122133fooEv,_ZThn8_N3aaa9GG11122133fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112213E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11122133barEv,_ZThn20_N3aaa9GG11122133barEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11122133fooEv,_ZThn20_N3aaa9GG11122133fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112213E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11122133barEv,_ZThn28_N3aaa9GG11122133barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112213E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112213E[];
Class_Descriptor cd__ZN3aaa9GG1112213E = {  "_ZN3aaa9GG1112213E", // class name
  bases__ZN3aaa9GG1112213E, 6,
  &(vtc__ZN3aaa9GG1112213E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112213E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112213E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112221  : ::aaa::EE111 , ::aaa::FF222 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11122213fooEv
  ~GG1112221(); // tgen
  GG1112221(); // tgen
};
//SIG(1 _ZN3aaa9GG1112221E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v2 Fi} BC7{ v2 Fi} v2 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1112221 ::foo(){vfunc_called(this, "_ZN3aaa9GG11122213fooEv");}
aaa::GG1112221 ::~GG1112221(){ note_dtor("_ZN3aaa9GG1112221E", this);} // tgen
aaa::GG1112221 ::GG1112221(){ note_ctor("_ZN3aaa9GG1112221E", this);} // tgen
}
static void Test__ZN3aaa9GG1112221E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112221E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112221E, buf);
    ::aaa::GG1112221 *dp, &lv = *(dp=new (buf) ::aaa::GG1112221());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112221E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112221E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112221E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112221E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112221E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF222*), ABISELECT(32,20), "_ZN3aaa9GG1112221E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF222*), ABISELECT(48,28), "_ZN3aaa9GG1112221E");
    check_base_class_offset(lv, (::aaa::FF222*), ABISELECT(32,20), "_ZN3aaa9GG1112221E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112221E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112221E);
    dp->::aaa::GG1112221::~GG1112221();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112221E(Test__ZN3aaa9GG1112221E, "_ZN3aaa9GG1112221E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112221C1Ev();
extern void _ZN3aaa9GG1112221D1Ev();
Name_Map name_map__ZN3aaa9GG1112221E[] = {
  NSPAIR(_ZN3aaa9GG1112221C1Ev),
  NSPAIR(_ZN3aaa9GG1112221D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF222E;
extern VTBL_ENTRY _ZTIN3aaa5FF222E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF222E[];
static Base_Class bases__ZN3aaa9GG1112221E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    9, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF222E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112221E[];
extern void _ZN3aaa9GG11122213fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11122213fooEv,_ZThn8_N3aaa9GG11122213fooEv)();
extern void _ZN3aaa5FF2223barEv();
extern void ABISELECT(_ZThn16_N3aaa5FF2223barEv,_ZThn8_N3aaa5FF2223barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112221E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112221E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11122213fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112221E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11122213fooEv,_ZThn8_N3aaa9GG11122213fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112221E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF2223barEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112221E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF2223barEv,_ZThn8_N3aaa5FF2223barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112221E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112221E[];
Class_Descriptor cd__ZN3aaa9GG1112221E = {  "_ZN3aaa9GG1112221E", // class name
  bases__ZN3aaa9GG1112221E, 6,
  &(vtc__ZN3aaa9GG1112221E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112221E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112221E),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112222  : ::aaa::EE111 , ::aaa::FF222 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11122223barEv
  ~GG1112222(); // tgen
  GG1112222(); // tgen
};
//SIG(1 _ZN3aaa9GG1112222E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC6{ v1 Fi} BC7{ v1 Fi} v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1112222 ::bar(){vfunc_called(this, "_ZN3aaa9GG11122223barEv");}
aaa::GG1112222 ::~GG1112222(){ note_dtor("_ZN3aaa9GG1112222E", this);} // tgen
aaa::GG1112222 ::GG1112222(){ note_ctor("_ZN3aaa9GG1112222E", this);} // tgen
}
static void Test__ZN3aaa9GG1112222E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112222E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112222E, buf);
    ::aaa::GG1112222 *dp, &lv = *(dp=new (buf) ::aaa::GG1112222());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112222E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112222E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112222E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112222E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112222E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF222*), ABISELECT(32,20), "_ZN3aaa9GG1112222E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF222*), ABISELECT(48,28), "_ZN3aaa9GG1112222E");
    check_base_class_offset(lv, (::aaa::FF222*), ABISELECT(32,20), "_ZN3aaa9GG1112222E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112222E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112222E);
    dp->::aaa::GG1112222::~GG1112222();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112222E(Test__ZN3aaa9GG1112222E, "_ZN3aaa9GG1112222E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112222C1Ev();
extern void _ZN3aaa9GG1112222D1Ev();
Name_Map name_map__ZN3aaa9GG1112222E[] = {
  NSPAIR(_ZN3aaa9GG1112222C1Ev),
  NSPAIR(_ZN3aaa9GG1112222D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF222E;
extern VTBL_ENTRY _ZTIN3aaa5FF222E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF222E[];
static Base_Class bases__ZN3aaa9GG1112222E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF222E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112222E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11122223barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11122223barEv,_ZThn20_N3aaa9GG11122223barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11122223barEv,_ZThn28_N3aaa9GG11122223barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112222E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112222E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11122223barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112222E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112222E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11122223barEv,_ZThn20_N3aaa9GG11122223barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112222E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11122223barEv,_ZThn28_N3aaa9GG11122223barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112222E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112222E[];
Class_Descriptor cd__ZN3aaa9GG1112222E = {  "_ZN3aaa9GG1112222E", // class name
  bases__ZN3aaa9GG1112222E, 6,
  &(vtc__ZN3aaa9GG1112222E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112222E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112222E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112223  : ::aaa::EE111 , ::aaa::FF222 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11122233fooEv
  virtual void  bar(); // _ZN3aaa9GG11122233barEv
  ~GG1112223(); // tgen
  GG1112223(); // tgen
};
//SIG(1 _ZN3aaa9GG1112223E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v2 Fi} BC7{ v2 Fi} v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1112223 ::foo(){vfunc_called(this, "_ZN3aaa9GG11122233fooEv");}
void  aaa::GG1112223 ::bar(){vfunc_called(this, "_ZN3aaa9GG11122233barEv");}
aaa::GG1112223 ::~GG1112223(){ note_dtor("_ZN3aaa9GG1112223E", this);} // tgen
aaa::GG1112223 ::GG1112223(){ note_ctor("_ZN3aaa9GG1112223E", this);} // tgen
}
static void Test__ZN3aaa9GG1112223E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112223E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112223E, buf);
    ::aaa::GG1112223 *dp, &lv = *(dp=new (buf) ::aaa::GG1112223());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112223E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112223E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112223E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112223E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112223E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF222*), ABISELECT(32,20), "_ZN3aaa9GG1112223E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF222*), ABISELECT(48,28), "_ZN3aaa9GG1112223E");
    check_base_class_offset(lv, (::aaa::FF222*), ABISELECT(32,20), "_ZN3aaa9GG1112223E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112223E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112223E);
    dp->::aaa::GG1112223::~GG1112223();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112223E(Test__ZN3aaa9GG1112223E, "_ZN3aaa9GG1112223E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112223C1Ev();
extern void _ZN3aaa9GG1112223D1Ev();
Name_Map name_map__ZN3aaa9GG1112223E[] = {
  NSPAIR(_ZN3aaa9GG1112223C1Ev),
  NSPAIR(_ZN3aaa9GG1112223D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF222E;
extern VTBL_ENTRY _ZTIN3aaa5FF222E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF222E[];
static Base_Class bases__ZN3aaa9GG1112223E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF222E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112223E[];
extern void _ZN3aaa9GG11122233fooEv();
extern void _ZN3aaa9GG11122233barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11122233fooEv,_ZThn8_N3aaa9GG11122233fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11122233barEv,_ZThn20_N3aaa9GG11122233barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11122233barEv,_ZThn28_N3aaa9GG11122233barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112223E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112223E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11122233fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11122233barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112223E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11122233fooEv,_ZThn8_N3aaa9GG11122233fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112223E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11122233barEv,_ZThn20_N3aaa9GG11122233barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112223E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11122233barEv,_ZThn28_N3aaa9GG11122233barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112223E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112223E[];
Class_Descriptor cd__ZN3aaa9GG1112223E = {  "_ZN3aaa9GG1112223E", // class name
  bases__ZN3aaa9GG1112223E, 6,
  &(vtc__ZN3aaa9GG1112223E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112223E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112223E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112231  : ::aaa::EE111 , ::aaa::FF223 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11122313fooEv
  ~GG1112231(); // tgen
  GG1112231(); // tgen
};
//SIG(1 _ZN3aaa9GG1112231E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v2 Fi} BC7{ v2 Fi} v1 v2 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1112231 ::foo(){vfunc_called(this, "_ZN3aaa9GG11122313fooEv");}
aaa::GG1112231 ::~GG1112231(){ note_dtor("_ZN3aaa9GG1112231E", this);} // tgen
aaa::GG1112231 ::GG1112231(){ note_ctor("_ZN3aaa9GG1112231E", this);} // tgen
}
static void Test__ZN3aaa9GG1112231E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112231E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112231E, buf);
    ::aaa::GG1112231 *dp, &lv = *(dp=new (buf) ::aaa::GG1112231());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112231E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112231E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112231E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112231E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112231E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF223*), ABISELECT(32,20), "_ZN3aaa9GG1112231E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF223*), ABISELECT(48,28), "_ZN3aaa9GG1112231E");
    check_base_class_offset(lv, (::aaa::FF223*), ABISELECT(32,20), "_ZN3aaa9GG1112231E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112231E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112231E);
    dp->::aaa::GG1112231::~GG1112231();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112231E(Test__ZN3aaa9GG1112231E, "_ZN3aaa9GG1112231E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112231C1Ev();
extern void _ZN3aaa9GG1112231D1Ev();
Name_Map name_map__ZN3aaa9GG1112231E[] = {
  NSPAIR(_ZN3aaa9GG1112231C1Ev),
  NSPAIR(_ZN3aaa9GG1112231D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF223E;
extern VTBL_ENTRY _ZTIN3aaa5FF223E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF223E[];
static Base_Class bases__ZN3aaa9GG1112231E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF223E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112231E[];
extern void _ZN3aaa9GG11122313fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11122313fooEv,_ZThn8_N3aaa9GG11122313fooEv)();
extern void _ZN3aaa5FF2233barEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11122313fooEv,_ZThn20_N3aaa9GG11122313fooEv)();
extern void ABISELECT(_ZThn16_N3aaa5FF2233barEv,_ZThn8_N3aaa5FF2233barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112231E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112231E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11122313fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112231E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11122313fooEv,_ZThn8_N3aaa9GG11122313fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112231E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF2233barEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11122313fooEv,_ZThn20_N3aaa9GG11122313fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112231E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF2233barEv,_ZThn8_N3aaa5FF2233barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112231E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112231E[];
Class_Descriptor cd__ZN3aaa9GG1112231E = {  "_ZN3aaa9GG1112231E", // class name
  bases__ZN3aaa9GG1112231E, 6,
  &(vtc__ZN3aaa9GG1112231E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112231E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112231E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112232  : ::aaa::EE111 , ::aaa::FF223 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11122323barEv
  ~GG1112232(); // tgen
  GG1112232(); // tgen
};
//SIG(1 _ZN3aaa9GG1112232E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC6{ v1 Fi} BC7{ v1 Fi} v3 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1112232 ::bar(){vfunc_called(this, "_ZN3aaa9GG11122323barEv");}
aaa::GG1112232 ::~GG1112232(){ note_dtor("_ZN3aaa9GG1112232E", this);} // tgen
aaa::GG1112232 ::GG1112232(){ note_ctor("_ZN3aaa9GG1112232E", this);} // tgen
}
static void Test__ZN3aaa9GG1112232E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112232E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112232E, buf);
    ::aaa::GG1112232 *dp, &lv = *(dp=new (buf) ::aaa::GG1112232());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112232E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112232E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112232E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112232E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112232E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF223*), ABISELECT(32,20), "_ZN3aaa9GG1112232E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF223*), ABISELECT(48,28), "_ZN3aaa9GG1112232E");
    check_base_class_offset(lv, (::aaa::FF223*), ABISELECT(32,20), "_ZN3aaa9GG1112232E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112232E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112232E);
    dp->::aaa::GG1112232::~GG1112232();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112232E(Test__ZN3aaa9GG1112232E, "_ZN3aaa9GG1112232E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112232C1Ev();
extern void _ZN3aaa9GG1112232D1Ev();
Name_Map name_map__ZN3aaa9GG1112232E[] = {
  NSPAIR(_ZN3aaa9GG1112232C1Ev),
  NSPAIR(_ZN3aaa9GG1112232D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF223E;
extern VTBL_ENTRY _ZTIN3aaa5FF223E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF223E[];
static Base_Class bases__ZN3aaa9GG1112232E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF223E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112232E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11122323barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11122323barEv,_ZThn20_N3aaa9GG11122323barEv)();
extern void _ZN3aaa5FF2233fooEv();
extern void ABISELECT(_ZThn48_N3aaa9GG11122323barEv,_ZThn28_N3aaa9GG11122323barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112232E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112232E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11122323barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112232E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112232E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11122323barEv,_ZThn20_N3aaa9GG11122323barEv),
  (VTBL_ENTRY)&_ZN3aaa5FF2233fooEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112232E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11122323barEv,_ZThn28_N3aaa9GG11122323barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112232E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112232E[];
Class_Descriptor cd__ZN3aaa9GG1112232E = {  "_ZN3aaa9GG1112232E", // class name
  bases__ZN3aaa9GG1112232E, 6,
  &(vtc__ZN3aaa9GG1112232E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112232E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112232E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112233  : ::aaa::EE111 , ::aaa::FF223 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11122333fooEv
  virtual void  bar(); // _ZN3aaa9GG11122333barEv
  ~GG1112233(); // tgen
  GG1112233(); // tgen
};
//SIG(1 _ZN3aaa9GG1112233E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v2 Fi} BC7{ v2 Fi} v1 v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1112233 ::foo(){vfunc_called(this, "_ZN3aaa9GG11122333fooEv");}
void  aaa::GG1112233 ::bar(){vfunc_called(this, "_ZN3aaa9GG11122333barEv");}
aaa::GG1112233 ::~GG1112233(){ note_dtor("_ZN3aaa9GG1112233E", this);} // tgen
aaa::GG1112233 ::GG1112233(){ note_ctor("_ZN3aaa9GG1112233E", this);} // tgen
}
static void Test__ZN3aaa9GG1112233E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112233E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112233E, buf);
    ::aaa::GG1112233 *dp, &lv = *(dp=new (buf) ::aaa::GG1112233());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112233E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112233E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112233E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112233E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112233E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF223*), ABISELECT(32,20), "_ZN3aaa9GG1112233E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF223*), ABISELECT(48,28), "_ZN3aaa9GG1112233E");
    check_base_class_offset(lv, (::aaa::FF223*), ABISELECT(32,20), "_ZN3aaa9GG1112233E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112233E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112233E);
    dp->::aaa::GG1112233::~GG1112233();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112233E(Test__ZN3aaa9GG1112233E, "_ZN3aaa9GG1112233E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112233C1Ev();
extern void _ZN3aaa9GG1112233D1Ev();
Name_Map name_map__ZN3aaa9GG1112233E[] = {
  NSPAIR(_ZN3aaa9GG1112233C1Ev),
  NSPAIR(_ZN3aaa9GG1112233D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF223E;
extern VTBL_ENTRY _ZTIN3aaa5FF223E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF223E[];
static Base_Class bases__ZN3aaa9GG1112233E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF223E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112233E[];
extern void _ZN3aaa9GG11122333fooEv();
extern void _ZN3aaa9GG11122333barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11122333fooEv,_ZThn8_N3aaa9GG11122333fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11122333barEv,_ZThn20_N3aaa9GG11122333barEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11122333fooEv,_ZThn20_N3aaa9GG11122333fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11122333barEv,_ZThn28_N3aaa9GG11122333barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112233E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112233E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11122333fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11122333barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112233E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11122333fooEv,_ZThn8_N3aaa9GG11122333fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112233E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11122333barEv,_ZThn20_N3aaa9GG11122333barEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11122333fooEv,_ZThn20_N3aaa9GG11122333fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112233E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11122333barEv,_ZThn28_N3aaa9GG11122333barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112233E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112233E[];
Class_Descriptor cd__ZN3aaa9GG1112233E = {  "_ZN3aaa9GG1112233E", // class name
  bases__ZN3aaa9GG1112233E, 6,
  &(vtc__ZN3aaa9GG1112233E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112233E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112233E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112311  : ::aaa::EE111 , ::aaa::FF231 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11123113fooEv
  ~GG1112311(); // tgen
  GG1112311(); // tgen
};
//SIG(1 _ZN3aaa9GG1112311E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v2 Fi} BC7{ v1 v3 Fi} v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1112311 ::foo(){vfunc_called(this, "_ZN3aaa9GG11123113fooEv");}
aaa::GG1112311 ::~GG1112311(){ note_dtor("_ZN3aaa9GG1112311E", this);} // tgen
aaa::GG1112311 ::GG1112311(){ note_ctor("_ZN3aaa9GG1112311E", this);} // tgen
}
static void Test__ZN3aaa9GG1112311E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112311E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112311E, buf);
    ::aaa::GG1112311 *dp, &lv = *(dp=new (buf) ::aaa::GG1112311());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112311E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112311E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112311E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112311E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112311E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF231*), ABISELECT(32,20), "_ZN3aaa9GG1112311E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF231*), ABISELECT(48,28), "_ZN3aaa9GG1112311E");
    check_base_class_offset(lv, (::aaa::FF231*), ABISELECT(32,20), "_ZN3aaa9GG1112311E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112311E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112311E);
    dp->::aaa::GG1112311::~GG1112311();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112311E(Test__ZN3aaa9GG1112311E, "_ZN3aaa9GG1112311E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112311C1Ev();
extern void _ZN3aaa9GG1112311D1Ev();
Name_Map name_map__ZN3aaa9GG1112311E[] = {
  NSPAIR(_ZN3aaa9GG1112311C1Ev),
  NSPAIR(_ZN3aaa9GG1112311D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF231E;
extern VTBL_ENTRY _ZTIN3aaa5FF231E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF231E[];
static Base_Class bases__ZN3aaa9GG1112311E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF231E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112311E[];
extern void _ZN3aaa9GG11123113fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11123113fooEv,_ZThn8_N3aaa9GG11123113fooEv)();
extern void _ZN3aaa3AA23barEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11123113fooEv,_ZThn20_N3aaa9GG11123113fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11123113fooEv,_ZThn28_N3aaa9GG11123113fooEv)();
extern void _ZN3aaa3BB33barEv();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112311E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112311E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11123113fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112311E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11123113fooEv,_ZThn8_N3aaa9GG11123113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112311E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA23barEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11123113fooEv,_ZThn20_N3aaa9GG11123113fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112311E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11123113fooEv,_ZThn28_N3aaa9GG11123113fooEv),
  (VTBL_ENTRY)&_ZN3aaa3BB33barEv,
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112311E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112311E[];
Class_Descriptor cd__ZN3aaa9GG1112311E = {  "_ZN3aaa9GG1112311E", // class name
  bases__ZN3aaa9GG1112311E, 6,
  &(vtc__ZN3aaa9GG1112311E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112311E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112311E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112312  : ::aaa::EE111 , ::aaa::FF231 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11123123barEv
  ~GG1112312(); // tgen
  GG1112312(); // tgen
};
//SIG(1 _ZN3aaa9GG1112312E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC6{ v1 Fi} BC7{ v3 v1 Fi} v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1112312 ::bar(){vfunc_called(this, "_ZN3aaa9GG11123123barEv");}
aaa::GG1112312 ::~GG1112312(){ note_dtor("_ZN3aaa9GG1112312E", this);} // tgen
aaa::GG1112312 ::GG1112312(){ note_ctor("_ZN3aaa9GG1112312E", this);} // tgen
}
static void Test__ZN3aaa9GG1112312E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112312E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112312E, buf);
    ::aaa::GG1112312 *dp, &lv = *(dp=new (buf) ::aaa::GG1112312());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112312E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112312E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112312E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112312E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112312E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF231*), ABISELECT(32,20), "_ZN3aaa9GG1112312E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF231*), ABISELECT(48,28), "_ZN3aaa9GG1112312E");
    check_base_class_offset(lv, (::aaa::FF231*), ABISELECT(32,20), "_ZN3aaa9GG1112312E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112312E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112312E);
    dp->::aaa::GG1112312::~GG1112312();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112312E(Test__ZN3aaa9GG1112312E, "_ZN3aaa9GG1112312E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112312C1Ev();
extern void _ZN3aaa9GG1112312D1Ev();
Name_Map name_map__ZN3aaa9GG1112312E[] = {
  NSPAIR(_ZN3aaa9GG1112312C1Ev),
  NSPAIR(_ZN3aaa9GG1112312D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF231E;
extern VTBL_ENTRY _ZTIN3aaa5FF231E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF231E[];
static Base_Class bases__ZN3aaa9GG1112312E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF231E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112312E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11123123barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11123123barEv,_ZThn20_N3aaa9GG11123123barEv)();
extern void _ZN3aaa5FF2313fooEv();
extern void ABISELECT(_ZThn16_N3aaa5FF2313fooEv,_ZThn8_N3aaa5FF2313fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11123123barEv,_ZThn28_N3aaa9GG11123123barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112312E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112312E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11123123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112312E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112312E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11123123barEv,_ZThn20_N3aaa9GG11123123barEv),
  (VTBL_ENTRY)&_ZN3aaa5FF2313fooEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112312E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF2313fooEv,_ZThn8_N3aaa5FF2313fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11123123barEv,_ZThn28_N3aaa9GG11123123barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112312E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112312E[];
Class_Descriptor cd__ZN3aaa9GG1112312E = {  "_ZN3aaa9GG1112312E", // class name
  bases__ZN3aaa9GG1112312E, 6,
  &(vtc__ZN3aaa9GG1112312E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112312E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112312E),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112313  : ::aaa::EE111 , ::aaa::FF231 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11123133fooEv
  virtual void  bar(); // _ZN3aaa9GG11123133barEv
  ~GG1112313(); // tgen
  GG1112313(); // tgen
};
//SIG(1 _ZN3aaa9GG1112313E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v2 Fi} BC7{ v1 v2 Fi} v1 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1112313 ::foo(){vfunc_called(this, "_ZN3aaa9GG11123133fooEv");}
void  aaa::GG1112313 ::bar(){vfunc_called(this, "_ZN3aaa9GG11123133barEv");}
aaa::GG1112313 ::~GG1112313(){ note_dtor("_ZN3aaa9GG1112313E", this);} // tgen
aaa::GG1112313 ::GG1112313(){ note_ctor("_ZN3aaa9GG1112313E", this);} // tgen
}
static void Test__ZN3aaa9GG1112313E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112313E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112313E, buf);
    ::aaa::GG1112313 *dp, &lv = *(dp=new (buf) ::aaa::GG1112313());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112313E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112313E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112313E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112313E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112313E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF231*), ABISELECT(32,20), "_ZN3aaa9GG1112313E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF231*), ABISELECT(48,28), "_ZN3aaa9GG1112313E");
    check_base_class_offset(lv, (::aaa::FF231*), ABISELECT(32,20), "_ZN3aaa9GG1112313E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112313E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112313E);
    dp->::aaa::GG1112313::~GG1112313();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112313E(Test__ZN3aaa9GG1112313E, "_ZN3aaa9GG1112313E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112313C1Ev();
extern void _ZN3aaa9GG1112313D1Ev();
Name_Map name_map__ZN3aaa9GG1112313E[] = {
  NSPAIR(_ZN3aaa9GG1112313C1Ev),
  NSPAIR(_ZN3aaa9GG1112313D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF231E;
extern VTBL_ENTRY _ZTIN3aaa5FF231E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF231E[];
static Base_Class bases__ZN3aaa9GG1112313E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF231E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112313E[];
extern void _ZN3aaa9GG11123133fooEv();
extern void _ZN3aaa9GG11123133barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11123133fooEv,_ZThn8_N3aaa9GG11123133fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11123133barEv,_ZThn20_N3aaa9GG11123133barEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11123133fooEv,_ZThn20_N3aaa9GG11123133fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11123133fooEv,_ZThn28_N3aaa9GG11123133fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11123133barEv,_ZThn28_N3aaa9GG11123133barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112313E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112313E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11123133fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11123133barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112313E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11123133fooEv,_ZThn8_N3aaa9GG11123133fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112313E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11123133barEv,_ZThn20_N3aaa9GG11123133barEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11123133fooEv,_ZThn20_N3aaa9GG11123133fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112313E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11123133fooEv,_ZThn28_N3aaa9GG11123133fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11123133barEv,_ZThn28_N3aaa9GG11123133barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112313E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112313E[];
Class_Descriptor cd__ZN3aaa9GG1112313E = {  "_ZN3aaa9GG1112313E", // class name
  bases__ZN3aaa9GG1112313E, 6,
  &(vtc__ZN3aaa9GG1112313E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112313E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112313E),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112321  : ::aaa::EE111 , ::aaa::FF232 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11123213fooEv
  ~GG1112321(); // tgen
  GG1112321(); // tgen
};
//SIG(1 _ZN3aaa9GG1112321E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v2 Fi} BC7{ v1 v2 Fi} v2 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1112321 ::foo(){vfunc_called(this, "_ZN3aaa9GG11123213fooEv");}
aaa::GG1112321 ::~GG1112321(){ note_dtor("_ZN3aaa9GG1112321E", this);} // tgen
aaa::GG1112321 ::GG1112321(){ note_ctor("_ZN3aaa9GG1112321E", this);} // tgen
}
static void Test__ZN3aaa9GG1112321E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112321E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112321E, buf);
    ::aaa::GG1112321 *dp, &lv = *(dp=new (buf) ::aaa::GG1112321());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112321E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112321E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112321E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112321E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112321E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF232*), ABISELECT(32,20), "_ZN3aaa9GG1112321E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF232*), ABISELECT(48,28), "_ZN3aaa9GG1112321E");
    check_base_class_offset(lv, (::aaa::FF232*), ABISELECT(32,20), "_ZN3aaa9GG1112321E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112321E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112321E);
    dp->::aaa::GG1112321::~GG1112321();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112321E(Test__ZN3aaa9GG1112321E, "_ZN3aaa9GG1112321E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112321C1Ev();
extern void _ZN3aaa9GG1112321D1Ev();
Name_Map name_map__ZN3aaa9GG1112321E[] = {
  NSPAIR(_ZN3aaa9GG1112321C1Ev),
  NSPAIR(_ZN3aaa9GG1112321D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF232E;
extern VTBL_ENTRY _ZTIN3aaa5FF232E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF232E[];
static Base_Class bases__ZN3aaa9GG1112321E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    9, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF232E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112321E[];
extern void _ZN3aaa9GG11123213fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11123213fooEv,_ZThn8_N3aaa9GG11123213fooEv)();
extern void _ZN3aaa5FF2323barEv();
extern void ABISELECT(_ZThn48_N3aaa9GG11123213fooEv,_ZThn28_N3aaa9GG11123213fooEv)();
extern void ABISELECT(_ZThn16_N3aaa5FF2323barEv,_ZThn8_N3aaa5FF2323barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112321E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112321E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11123213fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112321E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11123213fooEv,_ZThn8_N3aaa9GG11123213fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112321E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF2323barEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112321E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11123213fooEv,_ZThn28_N3aaa9GG11123213fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF2323barEv,_ZThn8_N3aaa5FF2323barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112321E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112321E[];
Class_Descriptor cd__ZN3aaa9GG1112321E = {  "_ZN3aaa9GG1112321E", // class name
  bases__ZN3aaa9GG1112321E, 6,
  &(vtc__ZN3aaa9GG1112321E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112321E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112321E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112322  : ::aaa::EE111 , ::aaa::FF232 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11123223barEv
  ~GG1112322(); // tgen
  GG1112322(); // tgen
};
//SIG(1 _ZN3aaa9GG1112322E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC6{ v1 Fi} BC7{ v3 v1 Fi} v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1112322 ::bar(){vfunc_called(this, "_ZN3aaa9GG11123223barEv");}
aaa::GG1112322 ::~GG1112322(){ note_dtor("_ZN3aaa9GG1112322E", this);} // tgen
aaa::GG1112322 ::GG1112322(){ note_ctor("_ZN3aaa9GG1112322E", this);} // tgen
}
static void Test__ZN3aaa9GG1112322E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112322E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112322E, buf);
    ::aaa::GG1112322 *dp, &lv = *(dp=new (buf) ::aaa::GG1112322());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112322E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112322E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112322E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112322E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112322E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF232*), ABISELECT(32,20), "_ZN3aaa9GG1112322E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF232*), ABISELECT(48,28), "_ZN3aaa9GG1112322E");
    check_base_class_offset(lv, (::aaa::FF232*), ABISELECT(32,20), "_ZN3aaa9GG1112322E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112322E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112322E);
    dp->::aaa::GG1112322::~GG1112322();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112322E(Test__ZN3aaa9GG1112322E, "_ZN3aaa9GG1112322E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112322C1Ev();
extern void _ZN3aaa9GG1112322D1Ev();
Name_Map name_map__ZN3aaa9GG1112322E[] = {
  NSPAIR(_ZN3aaa9GG1112322C1Ev),
  NSPAIR(_ZN3aaa9GG1112322D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF232E;
extern VTBL_ENTRY _ZTIN3aaa5FF232E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF232E[];
static Base_Class bases__ZN3aaa9GG1112322E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF232E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112322E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11123223barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11123223barEv,_ZThn20_N3aaa9GG11123223barEv)();
extern void _ZN3aaa3BB33fooEv();
extern void ABISELECT(_ZThn48_N3aaa9GG11123223barEv,_ZThn28_N3aaa9GG11123223barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112322E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112322E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11123223barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112322E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112322E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11123223barEv,_ZThn20_N3aaa9GG11123223barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112322E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11123223barEv,_ZThn28_N3aaa9GG11123223barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112322E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112322E[];
Class_Descriptor cd__ZN3aaa9GG1112322E = {  "_ZN3aaa9GG1112322E", // class name
  bases__ZN3aaa9GG1112322E, 6,
  &(vtc__ZN3aaa9GG1112322E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112322E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112322E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112323  : ::aaa::EE111 , ::aaa::FF232 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11123233fooEv
  virtual void  bar(); // _ZN3aaa9GG11123233barEv
  ~GG1112323(); // tgen
  GG1112323(); // tgen
};
//SIG(1 _ZN3aaa9GG1112323E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v2 Fi} BC7{ v1 v2 Fi} v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1112323 ::foo(){vfunc_called(this, "_ZN3aaa9GG11123233fooEv");}
void  aaa::GG1112323 ::bar(){vfunc_called(this, "_ZN3aaa9GG11123233barEv");}
aaa::GG1112323 ::~GG1112323(){ note_dtor("_ZN3aaa9GG1112323E", this);} // tgen
aaa::GG1112323 ::GG1112323(){ note_ctor("_ZN3aaa9GG1112323E", this);} // tgen
}
static void Test__ZN3aaa9GG1112323E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112323E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112323E, buf);
    ::aaa::GG1112323 *dp, &lv = *(dp=new (buf) ::aaa::GG1112323());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112323E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112323E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112323E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112323E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112323E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF232*), ABISELECT(32,20), "_ZN3aaa9GG1112323E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF232*), ABISELECT(48,28), "_ZN3aaa9GG1112323E");
    check_base_class_offset(lv, (::aaa::FF232*), ABISELECT(32,20), "_ZN3aaa9GG1112323E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112323E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112323E);
    dp->::aaa::GG1112323::~GG1112323();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112323E(Test__ZN3aaa9GG1112323E, "_ZN3aaa9GG1112323E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112323C1Ev();
extern void _ZN3aaa9GG1112323D1Ev();
Name_Map name_map__ZN3aaa9GG1112323E[] = {
  NSPAIR(_ZN3aaa9GG1112323C1Ev),
  NSPAIR(_ZN3aaa9GG1112323D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF232E;
extern VTBL_ENTRY _ZTIN3aaa5FF232E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF232E[];
static Base_Class bases__ZN3aaa9GG1112323E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF232E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112323E[];
extern void _ZN3aaa9GG11123233fooEv();
extern void _ZN3aaa9GG11123233barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11123233fooEv,_ZThn8_N3aaa9GG11123233fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11123233barEv,_ZThn20_N3aaa9GG11123233barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11123233fooEv,_ZThn28_N3aaa9GG11123233fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11123233barEv,_ZThn28_N3aaa9GG11123233barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112323E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112323E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11123233fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11123233barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112323E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11123233fooEv,_ZThn8_N3aaa9GG11123233fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112323E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11123233barEv,_ZThn20_N3aaa9GG11123233barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112323E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11123233fooEv,_ZThn28_N3aaa9GG11123233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11123233barEv,_ZThn28_N3aaa9GG11123233barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112323E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112323E[];
Class_Descriptor cd__ZN3aaa9GG1112323E = {  "_ZN3aaa9GG1112323E", // class name
  bases__ZN3aaa9GG1112323E, 6,
  &(vtc__ZN3aaa9GG1112323E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112323E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112323E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112331  : ::aaa::EE111 , ::aaa::FF233 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11123313fooEv
  ~GG1112331(); // tgen
  GG1112331(); // tgen
};
//SIG(1 _ZN3aaa9GG1112331E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v2 Fi} BC7{ v1 v2 Fi} v1 v2 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1112331 ::foo(){vfunc_called(this, "_ZN3aaa9GG11123313fooEv");}
aaa::GG1112331 ::~GG1112331(){ note_dtor("_ZN3aaa9GG1112331E", this);} // tgen
aaa::GG1112331 ::GG1112331(){ note_ctor("_ZN3aaa9GG1112331E", this);} // tgen
}
static void Test__ZN3aaa9GG1112331E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112331E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112331E, buf);
    ::aaa::GG1112331 *dp, &lv = *(dp=new (buf) ::aaa::GG1112331());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112331E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112331E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112331E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112331E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112331E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF233*), ABISELECT(32,20), "_ZN3aaa9GG1112331E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF233*), ABISELECT(48,28), "_ZN3aaa9GG1112331E");
    check_base_class_offset(lv, (::aaa::FF233*), ABISELECT(32,20), "_ZN3aaa9GG1112331E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112331E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112331E);
    dp->::aaa::GG1112331::~GG1112331();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112331E(Test__ZN3aaa9GG1112331E, "_ZN3aaa9GG1112331E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112331C1Ev();
extern void _ZN3aaa9GG1112331D1Ev();
Name_Map name_map__ZN3aaa9GG1112331E[] = {
  NSPAIR(_ZN3aaa9GG1112331C1Ev),
  NSPAIR(_ZN3aaa9GG1112331D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF233E;
extern VTBL_ENTRY _ZTIN3aaa5FF233E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF233E[];
static Base_Class bases__ZN3aaa9GG1112331E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF233E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112331E[];
extern void _ZN3aaa9GG11123313fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11123313fooEv,_ZThn8_N3aaa9GG11123313fooEv)();
extern void _ZN3aaa5FF2333barEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11123313fooEv,_ZThn20_N3aaa9GG11123313fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11123313fooEv,_ZThn28_N3aaa9GG11123313fooEv)();
extern void ABISELECT(_ZThn16_N3aaa5FF2333barEv,_ZThn8_N3aaa5FF2333barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112331E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112331E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11123313fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112331E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11123313fooEv,_ZThn8_N3aaa9GG11123313fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112331E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF2333barEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11123313fooEv,_ZThn20_N3aaa9GG11123313fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112331E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11123313fooEv,_ZThn28_N3aaa9GG11123313fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF2333barEv,_ZThn8_N3aaa5FF2333barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112331E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112331E[];
Class_Descriptor cd__ZN3aaa9GG1112331E = {  "_ZN3aaa9GG1112331E", // class name
  bases__ZN3aaa9GG1112331E, 6,
  &(vtc__ZN3aaa9GG1112331E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112331E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112331E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112332  : ::aaa::EE111 , ::aaa::FF233 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11123323barEv
  ~GG1112332(); // tgen
  GG1112332(); // tgen
};
//SIG(1 _ZN3aaa9GG1112332E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC6{ v1 Fi} BC7{ v3 v1 Fi} v3 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1112332 ::bar(){vfunc_called(this, "_ZN3aaa9GG11123323barEv");}
aaa::GG1112332 ::~GG1112332(){ note_dtor("_ZN3aaa9GG1112332E", this);} // tgen
aaa::GG1112332 ::GG1112332(){ note_ctor("_ZN3aaa9GG1112332E", this);} // tgen
}
static void Test__ZN3aaa9GG1112332E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112332E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112332E, buf);
    ::aaa::GG1112332 *dp, &lv = *(dp=new (buf) ::aaa::GG1112332());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112332E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112332E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112332E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112332E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112332E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF233*), ABISELECT(32,20), "_ZN3aaa9GG1112332E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF233*), ABISELECT(48,28), "_ZN3aaa9GG1112332E");
    check_base_class_offset(lv, (::aaa::FF233*), ABISELECT(32,20), "_ZN3aaa9GG1112332E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112332E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112332E);
    dp->::aaa::GG1112332::~GG1112332();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112332E(Test__ZN3aaa9GG1112332E, "_ZN3aaa9GG1112332E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112332C1Ev();
extern void _ZN3aaa9GG1112332D1Ev();
Name_Map name_map__ZN3aaa9GG1112332E[] = {
  NSPAIR(_ZN3aaa9GG1112332C1Ev),
  NSPAIR(_ZN3aaa9GG1112332D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF233E;
extern VTBL_ENTRY _ZTIN3aaa5FF233E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF233E[];
static Base_Class bases__ZN3aaa9GG1112332E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF233E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112332E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11123323barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11123323barEv,_ZThn20_N3aaa9GG11123323barEv)();
extern void _ZN3aaa5FF2333fooEv();
extern void ABISELECT(_ZThn16_N3aaa5FF2333fooEv,_ZThn8_N3aaa5FF2333fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11123323barEv,_ZThn28_N3aaa9GG11123323barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112332E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112332E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11123323barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112332E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112332E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11123323barEv,_ZThn20_N3aaa9GG11123323barEv),
  (VTBL_ENTRY)&_ZN3aaa5FF2333fooEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112332E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF2333fooEv,_ZThn8_N3aaa5FF2333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11123323barEv,_ZThn28_N3aaa9GG11123323barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112332E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112332E[];
Class_Descriptor cd__ZN3aaa9GG1112332E = {  "_ZN3aaa9GG1112332E", // class name
  bases__ZN3aaa9GG1112332E, 6,
  &(vtc__ZN3aaa9GG1112332E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112332E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112332E),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1112333  : ::aaa::EE111 , ::aaa::FF233 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11123333fooEv
  virtual void  bar(); // _ZN3aaa9GG11123333barEv
  ~GG1112333(); // tgen
  GG1112333(); // tgen
};
//SIG(1 _ZN3aaa9GG1112333E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v2 Fi} BC7{ v1 v2 Fi} v1 v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1112333 ::foo(){vfunc_called(this, "_ZN3aaa9GG11123333fooEv");}
void  aaa::GG1112333 ::bar(){vfunc_called(this, "_ZN3aaa9GG11123333barEv");}
aaa::GG1112333 ::~GG1112333(){ note_dtor("_ZN3aaa9GG1112333E", this);} // tgen
aaa::GG1112333 ::GG1112333(){ note_ctor("_ZN3aaa9GG1112333E", this);} // tgen
}
static void Test__ZN3aaa9GG1112333E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1112333E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1112333E, buf);
    ::aaa::GG1112333 *dp, &lv = *(dp=new (buf) ::aaa::GG1112333());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1112333E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1112333E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1112333E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1112333E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1112333E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF233*), ABISELECT(32,20), "_ZN3aaa9GG1112333E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF233*), ABISELECT(48,28), "_ZN3aaa9GG1112333E");
    check_base_class_offset(lv, (::aaa::FF233*), ABISELECT(32,20), "_ZN3aaa9GG1112333E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1112333E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1112333E);
    dp->::aaa::GG1112333::~GG1112333();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1112333E(Test__ZN3aaa9GG1112333E, "_ZN3aaa9GG1112333E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1112333C1Ev();
extern void _ZN3aaa9GG1112333D1Ev();
Name_Map name_map__ZN3aaa9GG1112333E[] = {
  NSPAIR(_ZN3aaa9GG1112333C1Ev),
  NSPAIR(_ZN3aaa9GG1112333D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF233E;
extern VTBL_ENTRY _ZTIN3aaa5FF233E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF233E[];
static Base_Class bases__ZN3aaa9GG1112333E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF233E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1112333E[];
extern void _ZN3aaa9GG11123333fooEv();
extern void _ZN3aaa9GG11123333barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11123333fooEv,_ZThn8_N3aaa9GG11123333fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11123333barEv,_ZThn20_N3aaa9GG11123333barEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11123333fooEv,_ZThn20_N3aaa9GG11123333fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11123333fooEv,_ZThn28_N3aaa9GG11123333fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11123333barEv,_ZThn28_N3aaa9GG11123333barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1112333E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112333E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11123333fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11123333barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112333E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11123333fooEv,_ZThn8_N3aaa9GG11123333fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112333E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11123333barEv,_ZThn20_N3aaa9GG11123333barEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11123333fooEv,_ZThn20_N3aaa9GG11123333fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1112333E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11123333fooEv,_ZThn28_N3aaa9GG11123333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11123333barEv,_ZThn28_N3aaa9GG11123333barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1112333E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1112333E[];
Class_Descriptor cd__ZN3aaa9GG1112333E = {  "_ZN3aaa9GG1112333E", // class name
  bases__ZN3aaa9GG1112333E, 6,
  &(vtc__ZN3aaa9GG1112333E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1112333E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1112333E),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113111  : ::aaa::EE111 , ::aaa::FF311 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11131113fooEv
  ~GG1113111(); // tgen
  GG1113111(); // tgen
};
//SIG(1 _ZN3aaa9GG1113111E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 v2 Fi} BC4 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1113111 ::foo(){vfunc_called(this, "_ZN3aaa9GG11131113fooEv");}
aaa::GG1113111 ::~GG1113111(){ note_dtor("_ZN3aaa9GG1113111E", this);} // tgen
aaa::GG1113111 ::GG1113111(){ note_ctor("_ZN3aaa9GG1113111E", this);} // tgen
}
static void Test__ZN3aaa9GG1113111E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113111E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113111E, buf);
    ::aaa::GG1113111 *dp, &lv = *(dp=new (buf) ::aaa::GG1113111());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113111E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113111E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113111E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113111E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113111E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF311*), ABISELECT(32,20), "_ZN3aaa9GG1113111E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF311*), ABISELECT(48,28), "_ZN3aaa9GG1113111E");
    check_base_class_offset(lv, (::aaa::FF311*), ABISELECT(32,20), "_ZN3aaa9GG1113111E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113111E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113111E);
    dp->::aaa::GG1113111::~GG1113111();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113111E(Test__ZN3aaa9GG1113111E, "_ZN3aaa9GG1113111E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113111C1Ev();
extern void _ZN3aaa9GG1113111D1Ev();
Name_Map name_map__ZN3aaa9GG1113111E[] = {
  NSPAIR(_ZN3aaa9GG1113111C1Ev),
  NSPAIR(_ZN3aaa9GG1113111D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF311E;
extern VTBL_ENTRY _ZTIN3aaa5FF311E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF311E[];
static Base_Class bases__ZN3aaa9GG1113111E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF311E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113111E[];
extern void _ZN3aaa9GG11131113fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11131113fooEv,_ZThn8_N3aaa9GG11131113fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11131113fooEv,_ZThn20_N3aaa9GG11131113fooEv)();
extern void _ZN3aaa3AA33barEv();
extern void ABISELECT(_ZThn48_N3aaa9GG11131113fooEv,_ZThn28_N3aaa9GG11131113fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113111E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113111E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11131113fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113111E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11131113fooEv,_ZThn8_N3aaa9GG11131113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113111E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11131113fooEv,_ZThn20_N3aaa9GG11131113fooEv),
  (VTBL_ENTRY)&_ZN3aaa3AA33barEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113111E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11131113fooEv,_ZThn28_N3aaa9GG11131113fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113111E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113111E[];
Class_Descriptor cd__ZN3aaa9GG1113111E = {  "_ZN3aaa9GG1113111E", // class name
  bases__ZN3aaa9GG1113111E, 6,
  &(vtc__ZN3aaa9GG1113111E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113111E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113111E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113112  : ::aaa::EE111 , ::aaa::FF311 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11131123barEv
  ~GG1113112(); // tgen
  GG1113112(); // tgen
};
//SIG(1 _ZN3aaa9GG1113112E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC6{ v3 v1 Fi} BC4 v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1113112 ::bar(){vfunc_called(this, "_ZN3aaa9GG11131123barEv");}
aaa::GG1113112 ::~GG1113112(){ note_dtor("_ZN3aaa9GG1113112E", this);} // tgen
aaa::GG1113112 ::GG1113112(){ note_ctor("_ZN3aaa9GG1113112E", this);} // tgen
}
static void Test__ZN3aaa9GG1113112E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113112E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113112E, buf);
    ::aaa::GG1113112 *dp, &lv = *(dp=new (buf) ::aaa::GG1113112());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113112E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113112E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113112E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113112E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113112E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF311*), ABISELECT(32,20), "_ZN3aaa9GG1113112E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF311*), ABISELECT(48,28), "_ZN3aaa9GG1113112E");
    check_base_class_offset(lv, (::aaa::FF311*), ABISELECT(32,20), "_ZN3aaa9GG1113112E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113112E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113112E);
    dp->::aaa::GG1113112::~GG1113112();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113112E(Test__ZN3aaa9GG1113112E, "_ZN3aaa9GG1113112E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113112C1Ev();
extern void _ZN3aaa9GG1113112D1Ev();
Name_Map name_map__ZN3aaa9GG1113112E[] = {
  NSPAIR(_ZN3aaa9GG1113112C1Ev),
  NSPAIR(_ZN3aaa9GG1113112D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF311E;
extern VTBL_ENTRY _ZTIN3aaa5FF311E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF311E[];
static Base_Class bases__ZN3aaa9GG1113112E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF311E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113112E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11131123barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void _ZN3aaa5FF3113fooEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11131123barEv,_ZThn20_N3aaa9GG11131123barEv)();
extern void ABISELECT(_ZThn16_N3aaa5FF3113fooEv,_ZThn8_N3aaa5FF3113fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113112E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113112E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11131123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113112E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113112E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF3113fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11131123barEv,_ZThn20_N3aaa9GG11131123barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113112E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF3113fooEv,_ZThn8_N3aaa5FF3113fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113112E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113112E[];
Class_Descriptor cd__ZN3aaa9GG1113112E = {  "_ZN3aaa9GG1113112E", // class name
  bases__ZN3aaa9GG1113112E, 6,
  &(vtc__ZN3aaa9GG1113112E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113112E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113112E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113113  : ::aaa::EE111 , ::aaa::FF311 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11131133fooEv
  virtual void  bar(); // _ZN3aaa9GG11131133barEv
  ~GG1113113(); // tgen
  GG1113113(); // tgen
};
//SIG(1 _ZN3aaa9GG1113113E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 v2 Fi} BC4 v1 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1113113 ::foo(){vfunc_called(this, "_ZN3aaa9GG11131133fooEv");}
void  aaa::GG1113113 ::bar(){vfunc_called(this, "_ZN3aaa9GG11131133barEv");}
aaa::GG1113113 ::~GG1113113(){ note_dtor("_ZN3aaa9GG1113113E", this);} // tgen
aaa::GG1113113 ::GG1113113(){ note_ctor("_ZN3aaa9GG1113113E", this);} // tgen
}
static void Test__ZN3aaa9GG1113113E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113113E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113113E, buf);
    ::aaa::GG1113113 *dp, &lv = *(dp=new (buf) ::aaa::GG1113113());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113113E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113113E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113113E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113113E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113113E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF311*), ABISELECT(32,20), "_ZN3aaa9GG1113113E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF311*), ABISELECT(48,28), "_ZN3aaa9GG1113113E");
    check_base_class_offset(lv, (::aaa::FF311*), ABISELECT(32,20), "_ZN3aaa9GG1113113E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113113E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113113E);
    dp->::aaa::GG1113113::~GG1113113();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113113E(Test__ZN3aaa9GG1113113E, "_ZN3aaa9GG1113113E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113113C1Ev();
extern void _ZN3aaa9GG1113113D1Ev();
Name_Map name_map__ZN3aaa9GG1113113E[] = {
  NSPAIR(_ZN3aaa9GG1113113C1Ev),
  NSPAIR(_ZN3aaa9GG1113113D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF311E;
extern VTBL_ENTRY _ZTIN3aaa5FF311E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF311E[];
static Base_Class bases__ZN3aaa9GG1113113E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF311E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113113E[];
extern void _ZN3aaa9GG11131133fooEv();
extern void _ZN3aaa9GG11131133barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11131133fooEv,_ZThn8_N3aaa9GG11131133fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11131133fooEv,_ZThn20_N3aaa9GG11131133fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11131133barEv,_ZThn20_N3aaa9GG11131133barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11131133fooEv,_ZThn28_N3aaa9GG11131133fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113113E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113113E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11131133fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11131133barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113113E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11131133fooEv,_ZThn8_N3aaa9GG11131133fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113113E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11131133fooEv,_ZThn20_N3aaa9GG11131133fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11131133barEv,_ZThn20_N3aaa9GG11131133barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113113E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11131133fooEv,_ZThn28_N3aaa9GG11131133fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113113E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113113E[];
Class_Descriptor cd__ZN3aaa9GG1113113E = {  "_ZN3aaa9GG1113113E", // class name
  bases__ZN3aaa9GG1113113E, 6,
  &(vtc__ZN3aaa9GG1113113E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113113E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113113E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113121  : ::aaa::EE111 , ::aaa::FF312 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11131213fooEv
  ~GG1113121(); // tgen
  GG1113121(); // tgen
};
//SIG(1 _ZN3aaa9GG1113121E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 v2 Fi} BC4 v2 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1113121 ::foo(){vfunc_called(this, "_ZN3aaa9GG11131213fooEv");}
aaa::GG1113121 ::~GG1113121(){ note_dtor("_ZN3aaa9GG1113121E", this);} // tgen
aaa::GG1113121 ::GG1113121(){ note_ctor("_ZN3aaa9GG1113121E", this);} // tgen
}
static void Test__ZN3aaa9GG1113121E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113121E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113121E, buf);
    ::aaa::GG1113121 *dp, &lv = *(dp=new (buf) ::aaa::GG1113121());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113121E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113121E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113121E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113121E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113121E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF312*), ABISELECT(32,20), "_ZN3aaa9GG1113121E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF312*), ABISELECT(48,28), "_ZN3aaa9GG1113121E");
    check_base_class_offset(lv, (::aaa::FF312*), ABISELECT(32,20), "_ZN3aaa9GG1113121E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113121E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113121E);
    dp->::aaa::GG1113121::~GG1113121();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113121E(Test__ZN3aaa9GG1113121E, "_ZN3aaa9GG1113121E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113121C1Ev();
extern void _ZN3aaa9GG1113121D1Ev();
Name_Map name_map__ZN3aaa9GG1113121E[] = {
  NSPAIR(_ZN3aaa9GG1113121C1Ev),
  NSPAIR(_ZN3aaa9GG1113121D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF312E;
extern VTBL_ENTRY _ZTIN3aaa5FF312E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF312E[];
static Base_Class bases__ZN3aaa9GG1113121E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF312E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113121E[];
extern void _ZN3aaa9GG11131213fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11131213fooEv,_ZThn8_N3aaa9GG11131213fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11131213fooEv,_ZThn20_N3aaa9GG11131213fooEv)();
extern void _ZN3aaa5FF3123barEv();
extern void ABISELECT(_ZThn48_N3aaa9GG11131213fooEv,_ZThn28_N3aaa9GG11131213fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113121E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113121E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11131213fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113121E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11131213fooEv,_ZThn8_N3aaa9GG11131213fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113121E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11131213fooEv,_ZThn20_N3aaa9GG11131213fooEv),
  (VTBL_ENTRY)&_ZN3aaa5FF3123barEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113121E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11131213fooEv,_ZThn28_N3aaa9GG11131213fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113121E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113121E[];
Class_Descriptor cd__ZN3aaa9GG1113121E = {  "_ZN3aaa9GG1113121E", // class name
  bases__ZN3aaa9GG1113121E, 6,
  &(vtc__ZN3aaa9GG1113121E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113121E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113121E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113122  : ::aaa::EE111 , ::aaa::FF312 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11131223barEv
  ~GG1113122(); // tgen
  GG1113122(); // tgen
};
//SIG(1 _ZN3aaa9GG1113122E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC6{ v3 v1 Fi} BC4 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1113122 ::bar(){vfunc_called(this, "_ZN3aaa9GG11131223barEv");}
aaa::GG1113122 ::~GG1113122(){ note_dtor("_ZN3aaa9GG1113122E", this);} // tgen
aaa::GG1113122 ::GG1113122(){ note_ctor("_ZN3aaa9GG1113122E", this);} // tgen
}
static void Test__ZN3aaa9GG1113122E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113122E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113122E, buf);
    ::aaa::GG1113122 *dp, &lv = *(dp=new (buf) ::aaa::GG1113122());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113122E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113122E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113122E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113122E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113122E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF312*), ABISELECT(32,20), "_ZN3aaa9GG1113122E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF312*), ABISELECT(48,28), "_ZN3aaa9GG1113122E");
    check_base_class_offset(lv, (::aaa::FF312*), ABISELECT(32,20), "_ZN3aaa9GG1113122E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113122E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113122E);
    dp->::aaa::GG1113122::~GG1113122();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113122E(Test__ZN3aaa9GG1113122E, "_ZN3aaa9GG1113122E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113122C1Ev();
extern void _ZN3aaa9GG1113122D1Ev();
Name_Map name_map__ZN3aaa9GG1113122E[] = {
  NSPAIR(_ZN3aaa9GG1113122C1Ev),
  NSPAIR(_ZN3aaa9GG1113122D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF312E;
extern VTBL_ENTRY _ZTIN3aaa5FF312E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF312E[];
static Base_Class bases__ZN3aaa9GG1113122E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF312E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113122E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11131223barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void _ZN3aaa3AA33fooEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11131223barEv,_ZThn20_N3aaa9GG11131223barEv)();
extern void _ZN3aaa3BB13fooEv();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113122E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113122E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11131223barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113122E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113122E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11131223barEv,_ZThn20_N3aaa9GG11131223barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113122E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB13fooEv,
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113122E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113122E[];
Class_Descriptor cd__ZN3aaa9GG1113122E = {  "_ZN3aaa9GG1113122E", // class name
  bases__ZN3aaa9GG1113122E, 6,
  &(vtc__ZN3aaa9GG1113122E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113122E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113122E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113123  : ::aaa::EE111 , ::aaa::FF312 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11131233fooEv
  virtual void  bar(); // _ZN3aaa9GG11131233barEv
  ~GG1113123(); // tgen
  GG1113123(); // tgen
};
//SIG(1 _ZN3aaa9GG1113123E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 v2 Fi} BC4 v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1113123 ::foo(){vfunc_called(this, "_ZN3aaa9GG11131233fooEv");}
void  aaa::GG1113123 ::bar(){vfunc_called(this, "_ZN3aaa9GG11131233barEv");}
aaa::GG1113123 ::~GG1113123(){ note_dtor("_ZN3aaa9GG1113123E", this);} // tgen
aaa::GG1113123 ::GG1113123(){ note_ctor("_ZN3aaa9GG1113123E", this);} // tgen
}
static void Test__ZN3aaa9GG1113123E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113123E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113123E, buf);
    ::aaa::GG1113123 *dp, &lv = *(dp=new (buf) ::aaa::GG1113123());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113123E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113123E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113123E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113123E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113123E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF312*), ABISELECT(32,20), "_ZN3aaa9GG1113123E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF312*), ABISELECT(48,28), "_ZN3aaa9GG1113123E");
    check_base_class_offset(lv, (::aaa::FF312*), ABISELECT(32,20), "_ZN3aaa9GG1113123E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113123E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113123E);
    dp->::aaa::GG1113123::~GG1113123();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113123E(Test__ZN3aaa9GG1113123E, "_ZN3aaa9GG1113123E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113123C1Ev();
extern void _ZN3aaa9GG1113123D1Ev();
Name_Map name_map__ZN3aaa9GG1113123E[] = {
  NSPAIR(_ZN3aaa9GG1113123C1Ev),
  NSPAIR(_ZN3aaa9GG1113123D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF312E;
extern VTBL_ENTRY _ZTIN3aaa5FF312E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF312E[];
static Base_Class bases__ZN3aaa9GG1113123E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF312E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113123E[];
extern void _ZN3aaa9GG11131233fooEv();
extern void _ZN3aaa9GG11131233barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11131233fooEv,_ZThn8_N3aaa9GG11131233fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11131233fooEv,_ZThn20_N3aaa9GG11131233fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11131233barEv,_ZThn20_N3aaa9GG11131233barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11131233fooEv,_ZThn28_N3aaa9GG11131233fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113123E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113123E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11131233fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11131233barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113123E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11131233fooEv,_ZThn8_N3aaa9GG11131233fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113123E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11131233fooEv,_ZThn20_N3aaa9GG11131233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11131233barEv,_ZThn20_N3aaa9GG11131233barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113123E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11131233fooEv,_ZThn28_N3aaa9GG11131233fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113123E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113123E[];
Class_Descriptor cd__ZN3aaa9GG1113123E = {  "_ZN3aaa9GG1113123E", // class name
  bases__ZN3aaa9GG1113123E, 6,
  &(vtc__ZN3aaa9GG1113123E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113123E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113123E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113131  : ::aaa::EE111 , ::aaa::FF313 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11131313fooEv
  ~GG1113131(); // tgen
  GG1113131(); // tgen
};
//SIG(1 _ZN3aaa9GG1113131E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 v2 Fi} BC4 v1 v2 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1113131 ::foo(){vfunc_called(this, "_ZN3aaa9GG11131313fooEv");}
aaa::GG1113131 ::~GG1113131(){ note_dtor("_ZN3aaa9GG1113131E", this);} // tgen
aaa::GG1113131 ::GG1113131(){ note_ctor("_ZN3aaa9GG1113131E", this);} // tgen
}
static void Test__ZN3aaa9GG1113131E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113131E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113131E, buf);
    ::aaa::GG1113131 *dp, &lv = *(dp=new (buf) ::aaa::GG1113131());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113131E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113131E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113131E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113131E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113131E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF313*), ABISELECT(32,20), "_ZN3aaa9GG1113131E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF313*), ABISELECT(48,28), "_ZN3aaa9GG1113131E");
    check_base_class_offset(lv, (::aaa::FF313*), ABISELECT(32,20), "_ZN3aaa9GG1113131E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113131E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113131E);
    dp->::aaa::GG1113131::~GG1113131();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113131E(Test__ZN3aaa9GG1113131E, "_ZN3aaa9GG1113131E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113131C1Ev();
extern void _ZN3aaa9GG1113131D1Ev();
Name_Map name_map__ZN3aaa9GG1113131E[] = {
  NSPAIR(_ZN3aaa9GG1113131C1Ev),
  NSPAIR(_ZN3aaa9GG1113131D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF313E;
extern VTBL_ENTRY _ZTIN3aaa5FF313E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF313E[];
static Base_Class bases__ZN3aaa9GG1113131E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF313E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113131E[];
extern void _ZN3aaa9GG11131313fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11131313fooEv,_ZThn8_N3aaa9GG11131313fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11131313fooEv,_ZThn20_N3aaa9GG11131313fooEv)();
extern void _ZN3aaa5FF3133barEv();
extern void ABISELECT(_ZThn48_N3aaa9GG11131313fooEv,_ZThn28_N3aaa9GG11131313fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113131E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113131E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11131313fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113131E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11131313fooEv,_ZThn8_N3aaa9GG11131313fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113131E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11131313fooEv,_ZThn20_N3aaa9GG11131313fooEv),
  (VTBL_ENTRY)&_ZN3aaa5FF3133barEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113131E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11131313fooEv,_ZThn28_N3aaa9GG11131313fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113131E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113131E[];
Class_Descriptor cd__ZN3aaa9GG1113131E = {  "_ZN3aaa9GG1113131E", // class name
  bases__ZN3aaa9GG1113131E, 6,
  &(vtc__ZN3aaa9GG1113131E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113131E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113131E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113132  : ::aaa::EE111 , ::aaa::FF313 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11131323barEv
  ~GG1113132(); // tgen
  GG1113132(); // tgen
};
//SIG(1 _ZN3aaa9GG1113132E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC6{ v3 v1 Fi} BC4 v3 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1113132 ::bar(){vfunc_called(this, "_ZN3aaa9GG11131323barEv");}
aaa::GG1113132 ::~GG1113132(){ note_dtor("_ZN3aaa9GG1113132E", this);} // tgen
aaa::GG1113132 ::GG1113132(){ note_ctor("_ZN3aaa9GG1113132E", this);} // tgen
}
static void Test__ZN3aaa9GG1113132E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113132E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113132E, buf);
    ::aaa::GG1113132 *dp, &lv = *(dp=new (buf) ::aaa::GG1113132());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113132E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113132E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113132E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113132E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113132E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF313*), ABISELECT(32,20), "_ZN3aaa9GG1113132E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF313*), ABISELECT(48,28), "_ZN3aaa9GG1113132E");
    check_base_class_offset(lv, (::aaa::FF313*), ABISELECT(32,20), "_ZN3aaa9GG1113132E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113132E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113132E);
    dp->::aaa::GG1113132::~GG1113132();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113132E(Test__ZN3aaa9GG1113132E, "_ZN3aaa9GG1113132E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113132C1Ev();
extern void _ZN3aaa9GG1113132D1Ev();
Name_Map name_map__ZN3aaa9GG1113132E[] = {
  NSPAIR(_ZN3aaa9GG1113132C1Ev),
  NSPAIR(_ZN3aaa9GG1113132D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF313E;
extern VTBL_ENTRY _ZTIN3aaa5FF313E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF313E[];
static Base_Class bases__ZN3aaa9GG1113132E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF313E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113132E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11131323barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void _ZN3aaa5FF3133fooEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11131323barEv,_ZThn20_N3aaa9GG11131323barEv)();
extern void ABISELECT(_ZThn16_N3aaa5FF3133fooEv,_ZThn8_N3aaa5FF3133fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113132E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113132E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11131323barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113132E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113132E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF3133fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11131323barEv,_ZThn20_N3aaa9GG11131323barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113132E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF3133fooEv,_ZThn8_N3aaa5FF3133fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113132E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113132E[];
Class_Descriptor cd__ZN3aaa9GG1113132E = {  "_ZN3aaa9GG1113132E", // class name
  bases__ZN3aaa9GG1113132E, 6,
  &(vtc__ZN3aaa9GG1113132E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113132E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113132E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113133  : ::aaa::EE111 , ::aaa::FF313 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11131333fooEv
  virtual void  bar(); // _ZN3aaa9GG11131333barEv
  ~GG1113133(); // tgen
  GG1113133(); // tgen
};
//SIG(1 _ZN3aaa9GG1113133E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 v2 Fi} BC4 v1 v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1113133 ::foo(){vfunc_called(this, "_ZN3aaa9GG11131333fooEv");}
void  aaa::GG1113133 ::bar(){vfunc_called(this, "_ZN3aaa9GG11131333barEv");}
aaa::GG1113133 ::~GG1113133(){ note_dtor("_ZN3aaa9GG1113133E", this);} // tgen
aaa::GG1113133 ::GG1113133(){ note_ctor("_ZN3aaa9GG1113133E", this);} // tgen
}
static void Test__ZN3aaa9GG1113133E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113133E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113133E, buf);
    ::aaa::GG1113133 *dp, &lv = *(dp=new (buf) ::aaa::GG1113133());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113133E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113133E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113133E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113133E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113133E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF313*), ABISELECT(32,20), "_ZN3aaa9GG1113133E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF313*), ABISELECT(48,28), "_ZN3aaa9GG1113133E");
    check_base_class_offset(lv, (::aaa::FF313*), ABISELECT(32,20), "_ZN3aaa9GG1113133E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113133E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113133E);
    dp->::aaa::GG1113133::~GG1113133();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113133E(Test__ZN3aaa9GG1113133E, "_ZN3aaa9GG1113133E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113133C1Ev();
extern void _ZN3aaa9GG1113133D1Ev();
Name_Map name_map__ZN3aaa9GG1113133E[] = {
  NSPAIR(_ZN3aaa9GG1113133C1Ev),
  NSPAIR(_ZN3aaa9GG1113133D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF313E;
extern VTBL_ENTRY _ZTIN3aaa5FF313E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF313E[];
static Base_Class bases__ZN3aaa9GG1113133E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF313E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113133E[];
extern void _ZN3aaa9GG11131333fooEv();
extern void _ZN3aaa9GG11131333barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11131333fooEv,_ZThn8_N3aaa9GG11131333fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11131333fooEv,_ZThn20_N3aaa9GG11131333fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11131333barEv,_ZThn20_N3aaa9GG11131333barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11131333fooEv,_ZThn28_N3aaa9GG11131333fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113133E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113133E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11131333fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11131333barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113133E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11131333fooEv,_ZThn8_N3aaa9GG11131333fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113133E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11131333fooEv,_ZThn20_N3aaa9GG11131333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11131333barEv,_ZThn20_N3aaa9GG11131333barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113133E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11131333fooEv,_ZThn28_N3aaa9GG11131333fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113133E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113133E[];
Class_Descriptor cd__ZN3aaa9GG1113133E = {  "_ZN3aaa9GG1113133E", // class name
  bases__ZN3aaa9GG1113133E, 6,
  &(vtc__ZN3aaa9GG1113133E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113133E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113133E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113211  : ::aaa::EE111 , ::aaa::FF321 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11132113fooEv
  ~GG1113211(); // tgen
  GG1113211(); // tgen
};
//SIG(1 _ZN3aaa9GG1113211E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 v2 Fi} BC7{ v3 Fi} v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1113211 ::foo(){vfunc_called(this, "_ZN3aaa9GG11132113fooEv");}
aaa::GG1113211 ::~GG1113211(){ note_dtor("_ZN3aaa9GG1113211E", this);} // tgen
aaa::GG1113211 ::GG1113211(){ note_ctor("_ZN3aaa9GG1113211E", this);} // tgen
}
static void Test__ZN3aaa9GG1113211E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113211E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113211E, buf);
    ::aaa::GG1113211 *dp, &lv = *(dp=new (buf) ::aaa::GG1113211());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113211E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113211E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113211E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113211E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113211E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF321*), ABISELECT(32,20), "_ZN3aaa9GG1113211E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF321*), ABISELECT(48,28), "_ZN3aaa9GG1113211E");
    check_base_class_offset(lv, (::aaa::FF321*), ABISELECT(32,20), "_ZN3aaa9GG1113211E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113211E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113211E);
    dp->::aaa::GG1113211::~GG1113211();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113211E(Test__ZN3aaa9GG1113211E, "_ZN3aaa9GG1113211E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113211C1Ev();
extern void _ZN3aaa9GG1113211D1Ev();
Name_Map name_map__ZN3aaa9GG1113211E[] = {
  NSPAIR(_ZN3aaa9GG1113211C1Ev),
  NSPAIR(_ZN3aaa9GG1113211D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF321E;
extern VTBL_ENTRY _ZTIN3aaa5FF321E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF321E[];
static Base_Class bases__ZN3aaa9GG1113211E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF321E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113211E[];
extern void _ZN3aaa9GG11132113fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11132113fooEv,_ZThn8_N3aaa9GG11132113fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11132113fooEv,_ZThn20_N3aaa9GG11132113fooEv)();
extern void _ZN3aaa3AA33barEv();
extern void _ZN3aaa3BB23barEv();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113211E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113211E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11132113fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113211E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11132113fooEv,_ZThn8_N3aaa9GG11132113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113211E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11132113fooEv,_ZThn20_N3aaa9GG11132113fooEv),
  (VTBL_ENTRY)&_ZN3aaa3AA33barEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113211E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB23barEv,
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113211E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113211E[];
Class_Descriptor cd__ZN3aaa9GG1113211E = {  "_ZN3aaa9GG1113211E", // class name
  bases__ZN3aaa9GG1113211E, 6,
  &(vtc__ZN3aaa9GG1113211E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113211E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113211E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113212  : ::aaa::EE111 , ::aaa::FF321 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11132123barEv
  ~GG1113212(); // tgen
  GG1113212(); // tgen
};
//SIG(1 _ZN3aaa9GG1113212E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC6{ v3 v1 Fi} BC7{ v1 Fi} v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1113212 ::bar(){vfunc_called(this, "_ZN3aaa9GG11132123barEv");}
aaa::GG1113212 ::~GG1113212(){ note_dtor("_ZN3aaa9GG1113212E", this);} // tgen
aaa::GG1113212 ::GG1113212(){ note_ctor("_ZN3aaa9GG1113212E", this);} // tgen
}
static void Test__ZN3aaa9GG1113212E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113212E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113212E, buf);
    ::aaa::GG1113212 *dp, &lv = *(dp=new (buf) ::aaa::GG1113212());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113212E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113212E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113212E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113212E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113212E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF321*), ABISELECT(32,20), "_ZN3aaa9GG1113212E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF321*), ABISELECT(48,28), "_ZN3aaa9GG1113212E");
    check_base_class_offset(lv, (::aaa::FF321*), ABISELECT(32,20), "_ZN3aaa9GG1113212E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113212E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113212E);
    dp->::aaa::GG1113212::~GG1113212();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113212E(Test__ZN3aaa9GG1113212E, "_ZN3aaa9GG1113212E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113212C1Ev();
extern void _ZN3aaa9GG1113212D1Ev();
Name_Map name_map__ZN3aaa9GG1113212E[] = {
  NSPAIR(_ZN3aaa9GG1113212C1Ev),
  NSPAIR(_ZN3aaa9GG1113212D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF321E;
extern VTBL_ENTRY _ZTIN3aaa5FF321E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF321E[];
static Base_Class bases__ZN3aaa9GG1113212E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF321E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113212E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11132123barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void _ZN3aaa5FF3213fooEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11132123barEv,_ZThn20_N3aaa9GG11132123barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11132123barEv,_ZThn28_N3aaa9GG11132123barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113212E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113212E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11132123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113212E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113212E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF3213fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11132123barEv,_ZThn20_N3aaa9GG11132123barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113212E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11132123barEv,_ZThn28_N3aaa9GG11132123barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113212E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113212E[];
Class_Descriptor cd__ZN3aaa9GG1113212E = {  "_ZN3aaa9GG1113212E", // class name
  bases__ZN3aaa9GG1113212E, 6,
  &(vtc__ZN3aaa9GG1113212E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113212E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113212E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113213  : ::aaa::EE111 , ::aaa::FF321 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11132133fooEv
  virtual void  bar(); // _ZN3aaa9GG11132133barEv
  ~GG1113213(); // tgen
  GG1113213(); // tgen
};
//SIG(1 _ZN3aaa9GG1113213E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 v2 Fi} BC7{ v2 Fi} v1 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1113213 ::foo(){vfunc_called(this, "_ZN3aaa9GG11132133fooEv");}
void  aaa::GG1113213 ::bar(){vfunc_called(this, "_ZN3aaa9GG11132133barEv");}
aaa::GG1113213 ::~GG1113213(){ note_dtor("_ZN3aaa9GG1113213E", this);} // tgen
aaa::GG1113213 ::GG1113213(){ note_ctor("_ZN3aaa9GG1113213E", this);} // tgen
}
static void Test__ZN3aaa9GG1113213E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113213E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113213E, buf);
    ::aaa::GG1113213 *dp, &lv = *(dp=new (buf) ::aaa::GG1113213());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113213E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113213E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113213E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113213E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113213E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF321*), ABISELECT(32,20), "_ZN3aaa9GG1113213E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF321*), ABISELECT(48,28), "_ZN3aaa9GG1113213E");
    check_base_class_offset(lv, (::aaa::FF321*), ABISELECT(32,20), "_ZN3aaa9GG1113213E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113213E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113213E);
    dp->::aaa::GG1113213::~GG1113213();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113213E(Test__ZN3aaa9GG1113213E, "_ZN3aaa9GG1113213E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113213C1Ev();
extern void _ZN3aaa9GG1113213D1Ev();
Name_Map name_map__ZN3aaa9GG1113213E[] = {
  NSPAIR(_ZN3aaa9GG1113213C1Ev),
  NSPAIR(_ZN3aaa9GG1113213D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF321E;
extern VTBL_ENTRY _ZTIN3aaa5FF321E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF321E[];
static Base_Class bases__ZN3aaa9GG1113213E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF321E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113213E[];
extern void _ZN3aaa9GG11132133fooEv();
extern void _ZN3aaa9GG11132133barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11132133fooEv,_ZThn8_N3aaa9GG11132133fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11132133fooEv,_ZThn20_N3aaa9GG11132133fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11132133barEv,_ZThn20_N3aaa9GG11132133barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11132133barEv,_ZThn28_N3aaa9GG11132133barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113213E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113213E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11132133fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11132133barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113213E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11132133fooEv,_ZThn8_N3aaa9GG11132133fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113213E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11132133fooEv,_ZThn20_N3aaa9GG11132133fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11132133barEv,_ZThn20_N3aaa9GG11132133barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113213E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11132133barEv,_ZThn28_N3aaa9GG11132133barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113213E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113213E[];
Class_Descriptor cd__ZN3aaa9GG1113213E = {  "_ZN3aaa9GG1113213E", // class name
  bases__ZN3aaa9GG1113213E, 6,
  &(vtc__ZN3aaa9GG1113213E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113213E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113213E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113221  : ::aaa::EE111 , ::aaa::FF322 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11132213fooEv
  ~GG1113221(); // tgen
  GG1113221(); // tgen
};
//SIG(1 _ZN3aaa9GG1113221E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 v2 Fi} BC7{ v2 Fi} v2 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1113221 ::foo(){vfunc_called(this, "_ZN3aaa9GG11132213fooEv");}
aaa::GG1113221 ::~GG1113221(){ note_dtor("_ZN3aaa9GG1113221E", this);} // tgen
aaa::GG1113221 ::GG1113221(){ note_ctor("_ZN3aaa9GG1113221E", this);} // tgen
}
static void Test__ZN3aaa9GG1113221E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113221E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113221E, buf);
    ::aaa::GG1113221 *dp, &lv = *(dp=new (buf) ::aaa::GG1113221());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113221E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113221E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113221E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113221E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113221E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF322*), ABISELECT(32,20), "_ZN3aaa9GG1113221E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF322*), ABISELECT(48,28), "_ZN3aaa9GG1113221E");
    check_base_class_offset(lv, (::aaa::FF322*), ABISELECT(32,20), "_ZN3aaa9GG1113221E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113221E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113221E);
    dp->::aaa::GG1113221::~GG1113221();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113221E(Test__ZN3aaa9GG1113221E, "_ZN3aaa9GG1113221E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113221C1Ev();
extern void _ZN3aaa9GG1113221D1Ev();
Name_Map name_map__ZN3aaa9GG1113221E[] = {
  NSPAIR(_ZN3aaa9GG1113221C1Ev),
  NSPAIR(_ZN3aaa9GG1113221D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF322E;
extern VTBL_ENTRY _ZTIN3aaa5FF322E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF322E[];
static Base_Class bases__ZN3aaa9GG1113221E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF322E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113221E[];
extern void _ZN3aaa9GG11132213fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11132213fooEv,_ZThn8_N3aaa9GG11132213fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11132213fooEv,_ZThn20_N3aaa9GG11132213fooEv)();
extern void _ZN3aaa5FF3223barEv();
extern void ABISELECT(_ZThn16_N3aaa5FF3223barEv,_ZThn8_N3aaa5FF3223barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113221E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113221E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11132213fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113221E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11132213fooEv,_ZThn8_N3aaa9GG11132213fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113221E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11132213fooEv,_ZThn20_N3aaa9GG11132213fooEv),
  (VTBL_ENTRY)&_ZN3aaa5FF3223barEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113221E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF3223barEv,_ZThn8_N3aaa5FF3223barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113221E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113221E[];
Class_Descriptor cd__ZN3aaa9GG1113221E = {  "_ZN3aaa9GG1113221E", // class name
  bases__ZN3aaa9GG1113221E, 6,
  &(vtc__ZN3aaa9GG1113221E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113221E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113221E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113222  : ::aaa::EE111 , ::aaa::FF322 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11132223barEv
  ~GG1113222(); // tgen
  GG1113222(); // tgen
};
//SIG(1 _ZN3aaa9GG1113222E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC6{ v3 v1 Fi} BC7{ v1 Fi} v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1113222 ::bar(){vfunc_called(this, "_ZN3aaa9GG11132223barEv");}
aaa::GG1113222 ::~GG1113222(){ note_dtor("_ZN3aaa9GG1113222E", this);} // tgen
aaa::GG1113222 ::GG1113222(){ note_ctor("_ZN3aaa9GG1113222E", this);} // tgen
}
static void Test__ZN3aaa9GG1113222E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113222E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113222E, buf);
    ::aaa::GG1113222 *dp, &lv = *(dp=new (buf) ::aaa::GG1113222());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113222E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113222E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113222E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113222E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113222E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF322*), ABISELECT(32,20), "_ZN3aaa9GG1113222E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF322*), ABISELECT(48,28), "_ZN3aaa9GG1113222E");
    check_base_class_offset(lv, (::aaa::FF322*), ABISELECT(32,20), "_ZN3aaa9GG1113222E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113222E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113222E);
    dp->::aaa::GG1113222::~GG1113222();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113222E(Test__ZN3aaa9GG1113222E, "_ZN3aaa9GG1113222E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113222C1Ev();
extern void _ZN3aaa9GG1113222D1Ev();
Name_Map name_map__ZN3aaa9GG1113222E[] = {
  NSPAIR(_ZN3aaa9GG1113222C1Ev),
  NSPAIR(_ZN3aaa9GG1113222D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF322E;
extern VTBL_ENTRY _ZTIN3aaa5FF322E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF322E[];
static Base_Class bases__ZN3aaa9GG1113222E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF322E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113222E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11132223barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void _ZN3aaa3AA33fooEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11132223barEv,_ZThn20_N3aaa9GG11132223barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11132223barEv,_ZThn28_N3aaa9GG11132223barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113222E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113222E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11132223barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113222E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113222E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11132223barEv,_ZThn20_N3aaa9GG11132223barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113222E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11132223barEv,_ZThn28_N3aaa9GG11132223barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113222E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113222E[];
Class_Descriptor cd__ZN3aaa9GG1113222E = {  "_ZN3aaa9GG1113222E", // class name
  bases__ZN3aaa9GG1113222E, 6,
  &(vtc__ZN3aaa9GG1113222E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113222E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113222E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113223  : ::aaa::EE111 , ::aaa::FF322 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11132233fooEv
  virtual void  bar(); // _ZN3aaa9GG11132233barEv
  ~GG1113223(); // tgen
  GG1113223(); // tgen
};
//SIG(1 _ZN3aaa9GG1113223E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 v2 Fi} BC7{ v2 Fi} v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1113223 ::foo(){vfunc_called(this, "_ZN3aaa9GG11132233fooEv");}
void  aaa::GG1113223 ::bar(){vfunc_called(this, "_ZN3aaa9GG11132233barEv");}
aaa::GG1113223 ::~GG1113223(){ note_dtor("_ZN3aaa9GG1113223E", this);} // tgen
aaa::GG1113223 ::GG1113223(){ note_ctor("_ZN3aaa9GG1113223E", this);} // tgen
}
static void Test__ZN3aaa9GG1113223E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113223E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113223E, buf);
    ::aaa::GG1113223 *dp, &lv = *(dp=new (buf) ::aaa::GG1113223());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113223E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113223E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113223E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113223E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113223E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF322*), ABISELECT(32,20), "_ZN3aaa9GG1113223E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF322*), ABISELECT(48,28), "_ZN3aaa9GG1113223E");
    check_base_class_offset(lv, (::aaa::FF322*), ABISELECT(32,20), "_ZN3aaa9GG1113223E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113223E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113223E);
    dp->::aaa::GG1113223::~GG1113223();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113223E(Test__ZN3aaa9GG1113223E, "_ZN3aaa9GG1113223E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113223C1Ev();
extern void _ZN3aaa9GG1113223D1Ev();
Name_Map name_map__ZN3aaa9GG1113223E[] = {
  NSPAIR(_ZN3aaa9GG1113223C1Ev),
  NSPAIR(_ZN3aaa9GG1113223D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF322E;
extern VTBL_ENTRY _ZTIN3aaa5FF322E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF322E[];
static Base_Class bases__ZN3aaa9GG1113223E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF322E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113223E[];
extern void _ZN3aaa9GG11132233fooEv();
extern void _ZN3aaa9GG11132233barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11132233fooEv,_ZThn8_N3aaa9GG11132233fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11132233fooEv,_ZThn20_N3aaa9GG11132233fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11132233barEv,_ZThn20_N3aaa9GG11132233barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11132233barEv,_ZThn28_N3aaa9GG11132233barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113223E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113223E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11132233fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11132233barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113223E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11132233fooEv,_ZThn8_N3aaa9GG11132233fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113223E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11132233fooEv,_ZThn20_N3aaa9GG11132233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11132233barEv,_ZThn20_N3aaa9GG11132233barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113223E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11132233barEv,_ZThn28_N3aaa9GG11132233barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113223E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113223E[];
Class_Descriptor cd__ZN3aaa9GG1113223E = {  "_ZN3aaa9GG1113223E", // class name
  bases__ZN3aaa9GG1113223E, 6,
  &(vtc__ZN3aaa9GG1113223E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113223E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113223E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113231  : ::aaa::EE111 , ::aaa::FF323 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11132313fooEv
  ~GG1113231(); // tgen
  GG1113231(); // tgen
};
//SIG(1 _ZN3aaa9GG1113231E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 v2 Fi} BC7{ v2 Fi} v1 v2 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1113231 ::foo(){vfunc_called(this, "_ZN3aaa9GG11132313fooEv");}
aaa::GG1113231 ::~GG1113231(){ note_dtor("_ZN3aaa9GG1113231E", this);} // tgen
aaa::GG1113231 ::GG1113231(){ note_ctor("_ZN3aaa9GG1113231E", this);} // tgen
}
static void Test__ZN3aaa9GG1113231E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113231E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113231E, buf);
    ::aaa::GG1113231 *dp, &lv = *(dp=new (buf) ::aaa::GG1113231());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113231E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113231E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113231E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113231E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113231E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF323*), ABISELECT(32,20), "_ZN3aaa9GG1113231E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF323*), ABISELECT(48,28), "_ZN3aaa9GG1113231E");
    check_base_class_offset(lv, (::aaa::FF323*), ABISELECT(32,20), "_ZN3aaa9GG1113231E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113231E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113231E);
    dp->::aaa::GG1113231::~GG1113231();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113231E(Test__ZN3aaa9GG1113231E, "_ZN3aaa9GG1113231E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113231C1Ev();
extern void _ZN3aaa9GG1113231D1Ev();
Name_Map name_map__ZN3aaa9GG1113231E[] = {
  NSPAIR(_ZN3aaa9GG1113231C1Ev),
  NSPAIR(_ZN3aaa9GG1113231D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF323E;
extern VTBL_ENTRY _ZTIN3aaa5FF323E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF323E[];
static Base_Class bases__ZN3aaa9GG1113231E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF323E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113231E[];
extern void _ZN3aaa9GG11132313fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11132313fooEv,_ZThn8_N3aaa9GG11132313fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11132313fooEv,_ZThn20_N3aaa9GG11132313fooEv)();
extern void _ZN3aaa5FF3233barEv();
extern void ABISELECT(_ZThn16_N3aaa5FF3233barEv,_ZThn8_N3aaa5FF3233barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113231E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113231E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11132313fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113231E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11132313fooEv,_ZThn8_N3aaa9GG11132313fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113231E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11132313fooEv,_ZThn20_N3aaa9GG11132313fooEv),
  (VTBL_ENTRY)&_ZN3aaa5FF3233barEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113231E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF3233barEv,_ZThn8_N3aaa5FF3233barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113231E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113231E[];
Class_Descriptor cd__ZN3aaa9GG1113231E = {  "_ZN3aaa9GG1113231E", // class name
  bases__ZN3aaa9GG1113231E, 6,
  &(vtc__ZN3aaa9GG1113231E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113231E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113231E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113232  : ::aaa::EE111 , ::aaa::FF323 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11132323barEv
  ~GG1113232(); // tgen
  GG1113232(); // tgen
};
//SIG(1 _ZN3aaa9GG1113232E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC6{ v3 v1 Fi} BC7{ v1 Fi} v3 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1113232 ::bar(){vfunc_called(this, "_ZN3aaa9GG11132323barEv");}
aaa::GG1113232 ::~GG1113232(){ note_dtor("_ZN3aaa9GG1113232E", this);} // tgen
aaa::GG1113232 ::GG1113232(){ note_ctor("_ZN3aaa9GG1113232E", this);} // tgen
}
static void Test__ZN3aaa9GG1113232E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113232E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113232E, buf);
    ::aaa::GG1113232 *dp, &lv = *(dp=new (buf) ::aaa::GG1113232());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113232E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113232E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113232E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113232E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113232E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF323*), ABISELECT(32,20), "_ZN3aaa9GG1113232E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF323*), ABISELECT(48,28), "_ZN3aaa9GG1113232E");
    check_base_class_offset(lv, (::aaa::FF323*), ABISELECT(32,20), "_ZN3aaa9GG1113232E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113232E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113232E);
    dp->::aaa::GG1113232::~GG1113232();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113232E(Test__ZN3aaa9GG1113232E, "_ZN3aaa9GG1113232E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113232C1Ev();
extern void _ZN3aaa9GG1113232D1Ev();
Name_Map name_map__ZN3aaa9GG1113232E[] = {
  NSPAIR(_ZN3aaa9GG1113232C1Ev),
  NSPAIR(_ZN3aaa9GG1113232D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF323E;
extern VTBL_ENTRY _ZTIN3aaa5FF323E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF323E[];
static Base_Class bases__ZN3aaa9GG1113232E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF323E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113232E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11132323barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void _ZN3aaa5FF3233fooEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11132323barEv,_ZThn20_N3aaa9GG11132323barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11132323barEv,_ZThn28_N3aaa9GG11132323barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113232E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113232E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11132323barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113232E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113232E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF3233fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11132323barEv,_ZThn20_N3aaa9GG11132323barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113232E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11132323barEv,_ZThn28_N3aaa9GG11132323barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113232E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113232E[];
Class_Descriptor cd__ZN3aaa9GG1113232E = {  "_ZN3aaa9GG1113232E", // class name
  bases__ZN3aaa9GG1113232E, 6,
  &(vtc__ZN3aaa9GG1113232E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113232E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113232E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113233  : ::aaa::EE111 , ::aaa::FF323 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11132333fooEv
  virtual void  bar(); // _ZN3aaa9GG11132333barEv
  ~GG1113233(); // tgen
  GG1113233(); // tgen
};
//SIG(1 _ZN3aaa9GG1113233E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 v2 Fi} BC7{ v2 Fi} v1 v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1113233 ::foo(){vfunc_called(this, "_ZN3aaa9GG11132333fooEv");}
void  aaa::GG1113233 ::bar(){vfunc_called(this, "_ZN3aaa9GG11132333barEv");}
aaa::GG1113233 ::~GG1113233(){ note_dtor("_ZN3aaa9GG1113233E", this);} // tgen
aaa::GG1113233 ::GG1113233(){ note_ctor("_ZN3aaa9GG1113233E", this);} // tgen
}
static void Test__ZN3aaa9GG1113233E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113233E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113233E, buf);
    ::aaa::GG1113233 *dp, &lv = *(dp=new (buf) ::aaa::GG1113233());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113233E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113233E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113233E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113233E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113233E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF323*), ABISELECT(32,20), "_ZN3aaa9GG1113233E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF323*), ABISELECT(48,28), "_ZN3aaa9GG1113233E");
    check_base_class_offset(lv, (::aaa::FF323*), ABISELECT(32,20), "_ZN3aaa9GG1113233E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113233E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113233E);
    dp->::aaa::GG1113233::~GG1113233();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113233E(Test__ZN3aaa9GG1113233E, "_ZN3aaa9GG1113233E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113233C1Ev();
extern void _ZN3aaa9GG1113233D1Ev();
Name_Map name_map__ZN3aaa9GG1113233E[] = {
  NSPAIR(_ZN3aaa9GG1113233C1Ev),
  NSPAIR(_ZN3aaa9GG1113233D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF323E;
extern VTBL_ENTRY _ZTIN3aaa5FF323E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF323E[];
static Base_Class bases__ZN3aaa9GG1113233E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF323E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113233E[];
extern void _ZN3aaa9GG11132333fooEv();
extern void _ZN3aaa9GG11132333barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11132333fooEv,_ZThn8_N3aaa9GG11132333fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11132333fooEv,_ZThn20_N3aaa9GG11132333fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11132333barEv,_ZThn20_N3aaa9GG11132333barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11132333barEv,_ZThn28_N3aaa9GG11132333barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113233E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113233E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11132333fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11132333barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113233E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11132333fooEv,_ZThn8_N3aaa9GG11132333fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113233E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11132333fooEv,_ZThn20_N3aaa9GG11132333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11132333barEv,_ZThn20_N3aaa9GG11132333barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113233E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11132333barEv,_ZThn28_N3aaa9GG11132333barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113233E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113233E[];
Class_Descriptor cd__ZN3aaa9GG1113233E = {  "_ZN3aaa9GG1113233E", // class name
  bases__ZN3aaa9GG1113233E, 6,
  &(vtc__ZN3aaa9GG1113233E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113233E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113233E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113311  : ::aaa::EE111 , ::aaa::FF331 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11133113fooEv
  ~GG1113311(); // tgen
  GG1113311(); // tgen
};
//SIG(1 _ZN3aaa9GG1113311E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 v2 Fi} BC7{ v1 v3 Fi} v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1113311 ::foo(){vfunc_called(this, "_ZN3aaa9GG11133113fooEv");}
aaa::GG1113311 ::~GG1113311(){ note_dtor("_ZN3aaa9GG1113311E", this);} // tgen
aaa::GG1113311 ::GG1113311(){ note_ctor("_ZN3aaa9GG1113311E", this);} // tgen
}
static void Test__ZN3aaa9GG1113311E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113311E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113311E, buf);
    ::aaa::GG1113311 *dp, &lv = *(dp=new (buf) ::aaa::GG1113311());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113311E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113311E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113311E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113311E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113311E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF331*), ABISELECT(32,20), "_ZN3aaa9GG1113311E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF331*), ABISELECT(48,28), "_ZN3aaa9GG1113311E");
    check_base_class_offset(lv, (::aaa::FF331*), ABISELECT(32,20), "_ZN3aaa9GG1113311E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113311E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113311E);
    dp->::aaa::GG1113311::~GG1113311();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113311E(Test__ZN3aaa9GG1113311E, "_ZN3aaa9GG1113311E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113311C1Ev();
extern void _ZN3aaa9GG1113311D1Ev();
Name_Map name_map__ZN3aaa9GG1113311E[] = {
  NSPAIR(_ZN3aaa9GG1113311C1Ev),
  NSPAIR(_ZN3aaa9GG1113311D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF331E;
extern VTBL_ENTRY _ZTIN3aaa5FF331E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF331E[];
static Base_Class bases__ZN3aaa9GG1113311E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF331E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113311E[];
extern void _ZN3aaa9GG11133113fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11133113fooEv,_ZThn8_N3aaa9GG11133113fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11133113fooEv,_ZThn20_N3aaa9GG11133113fooEv)();
extern void _ZN3aaa3AA33barEv();
extern void ABISELECT(_ZThn48_N3aaa9GG11133113fooEv,_ZThn28_N3aaa9GG11133113fooEv)();
extern void _ZN3aaa3BB33barEv();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113311E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113311E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11133113fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113311E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11133113fooEv,_ZThn8_N3aaa9GG11133113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113311E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11133113fooEv,_ZThn20_N3aaa9GG11133113fooEv),
  (VTBL_ENTRY)&_ZN3aaa3AA33barEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113311E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11133113fooEv,_ZThn28_N3aaa9GG11133113fooEv),
  (VTBL_ENTRY)&_ZN3aaa3BB33barEv,
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113311E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113311E[];
Class_Descriptor cd__ZN3aaa9GG1113311E = {  "_ZN3aaa9GG1113311E", // class name
  bases__ZN3aaa9GG1113311E, 6,
  &(vtc__ZN3aaa9GG1113311E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113311E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113311E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113312  : ::aaa::EE111 , ::aaa::FF331 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11133123barEv
  ~GG1113312(); // tgen
  GG1113312(); // tgen
};
//SIG(1 _ZN3aaa9GG1113312E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC6{ v3 v1 Fi} BC7{ v3 v1 Fi} v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1113312 ::bar(){vfunc_called(this, "_ZN3aaa9GG11133123barEv");}
aaa::GG1113312 ::~GG1113312(){ note_dtor("_ZN3aaa9GG1113312E", this);} // tgen
aaa::GG1113312 ::GG1113312(){ note_ctor("_ZN3aaa9GG1113312E", this);} // tgen
}
static void Test__ZN3aaa9GG1113312E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113312E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113312E, buf);
    ::aaa::GG1113312 *dp, &lv = *(dp=new (buf) ::aaa::GG1113312());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113312E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113312E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113312E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113312E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113312E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF331*), ABISELECT(32,20), "_ZN3aaa9GG1113312E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF331*), ABISELECT(48,28), "_ZN3aaa9GG1113312E");
    check_base_class_offset(lv, (::aaa::FF331*), ABISELECT(32,20), "_ZN3aaa9GG1113312E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113312E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113312E);
    dp->::aaa::GG1113312::~GG1113312();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113312E(Test__ZN3aaa9GG1113312E, "_ZN3aaa9GG1113312E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113312C1Ev();
extern void _ZN3aaa9GG1113312D1Ev();
Name_Map name_map__ZN3aaa9GG1113312E[] = {
  NSPAIR(_ZN3aaa9GG1113312C1Ev),
  NSPAIR(_ZN3aaa9GG1113312D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF331E;
extern VTBL_ENTRY _ZTIN3aaa5FF331E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF331E[];
static Base_Class bases__ZN3aaa9GG1113312E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF331E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113312E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11133123barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void _ZN3aaa5FF3313fooEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11133123barEv,_ZThn20_N3aaa9GG11133123barEv)();
extern void ABISELECT(_ZThn16_N3aaa5FF3313fooEv,_ZThn8_N3aaa5FF3313fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11133123barEv,_ZThn28_N3aaa9GG11133123barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113312E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113312E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11133123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113312E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113312E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF3313fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11133123barEv,_ZThn20_N3aaa9GG11133123barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113312E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF3313fooEv,_ZThn8_N3aaa5FF3313fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11133123barEv,_ZThn28_N3aaa9GG11133123barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113312E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113312E[];
Class_Descriptor cd__ZN3aaa9GG1113312E = {  "_ZN3aaa9GG1113312E", // class name
  bases__ZN3aaa9GG1113312E, 6,
  &(vtc__ZN3aaa9GG1113312E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113312E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113312E),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113313  : ::aaa::EE111 , ::aaa::FF331 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11133133fooEv
  virtual void  bar(); // _ZN3aaa9GG11133133barEv
  ~GG1113313(); // tgen
  GG1113313(); // tgen
};
//SIG(1 _ZN3aaa9GG1113313E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 v2 Fi} BC7{ v1 v2 Fi} v1 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1113313 ::foo(){vfunc_called(this, "_ZN3aaa9GG11133133fooEv");}
void  aaa::GG1113313 ::bar(){vfunc_called(this, "_ZN3aaa9GG11133133barEv");}
aaa::GG1113313 ::~GG1113313(){ note_dtor("_ZN3aaa9GG1113313E", this);} // tgen
aaa::GG1113313 ::GG1113313(){ note_ctor("_ZN3aaa9GG1113313E", this);} // tgen
}
static void Test__ZN3aaa9GG1113313E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113313E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113313E, buf);
    ::aaa::GG1113313 *dp, &lv = *(dp=new (buf) ::aaa::GG1113313());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113313E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113313E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113313E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113313E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113313E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF331*), ABISELECT(32,20), "_ZN3aaa9GG1113313E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF331*), ABISELECT(48,28), "_ZN3aaa9GG1113313E");
    check_base_class_offset(lv, (::aaa::FF331*), ABISELECT(32,20), "_ZN3aaa9GG1113313E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113313E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113313E);
    dp->::aaa::GG1113313::~GG1113313();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113313E(Test__ZN3aaa9GG1113313E, "_ZN3aaa9GG1113313E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113313C1Ev();
extern void _ZN3aaa9GG1113313D1Ev();
Name_Map name_map__ZN3aaa9GG1113313E[] = {
  NSPAIR(_ZN3aaa9GG1113313C1Ev),
  NSPAIR(_ZN3aaa9GG1113313D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF331E;
extern VTBL_ENTRY _ZTIN3aaa5FF331E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF331E[];
static Base_Class bases__ZN3aaa9GG1113313E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF331E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113313E[];
extern void _ZN3aaa9GG11133133fooEv();
extern void _ZN3aaa9GG11133133barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11133133fooEv,_ZThn8_N3aaa9GG11133133fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11133133fooEv,_ZThn20_N3aaa9GG11133133fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11133133barEv,_ZThn20_N3aaa9GG11133133barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11133133fooEv,_ZThn28_N3aaa9GG11133133fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11133133barEv,_ZThn28_N3aaa9GG11133133barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113313E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113313E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11133133fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11133133barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113313E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11133133fooEv,_ZThn8_N3aaa9GG11133133fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113313E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11133133fooEv,_ZThn20_N3aaa9GG11133133fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11133133barEv,_ZThn20_N3aaa9GG11133133barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113313E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11133133fooEv,_ZThn28_N3aaa9GG11133133fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11133133barEv,_ZThn28_N3aaa9GG11133133barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113313E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113313E[];
Class_Descriptor cd__ZN3aaa9GG1113313E = {  "_ZN3aaa9GG1113313E", // class name
  bases__ZN3aaa9GG1113313E, 6,
  &(vtc__ZN3aaa9GG1113313E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113313E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113313E),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113321  : ::aaa::EE111 , ::aaa::FF332 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11133213fooEv
  ~GG1113321(); // tgen
  GG1113321(); // tgen
};
//SIG(1 _ZN3aaa9GG1113321E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 v2 Fi} BC7{ v1 v2 Fi} v2 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1113321 ::foo(){vfunc_called(this, "_ZN3aaa9GG11133213fooEv");}
aaa::GG1113321 ::~GG1113321(){ note_dtor("_ZN3aaa9GG1113321E", this);} // tgen
aaa::GG1113321 ::GG1113321(){ note_ctor("_ZN3aaa9GG1113321E", this);} // tgen
}
static void Test__ZN3aaa9GG1113321E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113321E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113321E, buf);
    ::aaa::GG1113321 *dp, &lv = *(dp=new (buf) ::aaa::GG1113321());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113321E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113321E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113321E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113321E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113321E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF332*), ABISELECT(32,20), "_ZN3aaa9GG1113321E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF332*), ABISELECT(48,28), "_ZN3aaa9GG1113321E");
    check_base_class_offset(lv, (::aaa::FF332*), ABISELECT(32,20), "_ZN3aaa9GG1113321E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113321E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113321E);
    dp->::aaa::GG1113321::~GG1113321();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113321E(Test__ZN3aaa9GG1113321E, "_ZN3aaa9GG1113321E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113321C1Ev();
extern void _ZN3aaa9GG1113321D1Ev();
Name_Map name_map__ZN3aaa9GG1113321E[] = {
  NSPAIR(_ZN3aaa9GG1113321C1Ev),
  NSPAIR(_ZN3aaa9GG1113321D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF332E;
extern VTBL_ENTRY _ZTIN3aaa5FF332E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF332E[];
static Base_Class bases__ZN3aaa9GG1113321E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF332E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113321E[];
extern void _ZN3aaa9GG11133213fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11133213fooEv,_ZThn8_N3aaa9GG11133213fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11133213fooEv,_ZThn20_N3aaa9GG11133213fooEv)();
extern void _ZN3aaa5FF3323barEv();
extern void ABISELECT(_ZThn48_N3aaa9GG11133213fooEv,_ZThn28_N3aaa9GG11133213fooEv)();
extern void ABISELECT(_ZThn16_N3aaa5FF3323barEv,_ZThn8_N3aaa5FF3323barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113321E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113321E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11133213fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113321E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11133213fooEv,_ZThn8_N3aaa9GG11133213fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113321E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11133213fooEv,_ZThn20_N3aaa9GG11133213fooEv),
  (VTBL_ENTRY)&_ZN3aaa5FF3323barEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113321E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11133213fooEv,_ZThn28_N3aaa9GG11133213fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF3323barEv,_ZThn8_N3aaa5FF3323barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113321E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113321E[];
Class_Descriptor cd__ZN3aaa9GG1113321E = {  "_ZN3aaa9GG1113321E", // class name
  bases__ZN3aaa9GG1113321E, 6,
  &(vtc__ZN3aaa9GG1113321E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113321E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113321E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113322  : ::aaa::EE111 , ::aaa::FF332 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11133223barEv
  ~GG1113322(); // tgen
  GG1113322(); // tgen
};
//SIG(1 _ZN3aaa9GG1113322E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC6{ v3 v1 Fi} BC7{ v4 v1 Fi} v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1113322 ::bar(){vfunc_called(this, "_ZN3aaa9GG11133223barEv");}
aaa::GG1113322 ::~GG1113322(){ note_dtor("_ZN3aaa9GG1113322E", this);} // tgen
aaa::GG1113322 ::GG1113322(){ note_ctor("_ZN3aaa9GG1113322E", this);} // tgen
}
static void Test__ZN3aaa9GG1113322E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113322E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113322E, buf);
    ::aaa::GG1113322 *dp, &lv = *(dp=new (buf) ::aaa::GG1113322());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113322E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113322E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113322E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113322E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113322E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF332*), ABISELECT(32,20), "_ZN3aaa9GG1113322E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF332*), ABISELECT(48,28), "_ZN3aaa9GG1113322E");
    check_base_class_offset(lv, (::aaa::FF332*), ABISELECT(32,20), "_ZN3aaa9GG1113322E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113322E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113322E);
    dp->::aaa::GG1113322::~GG1113322();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113322E(Test__ZN3aaa9GG1113322E, "_ZN3aaa9GG1113322E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113322C1Ev();
extern void _ZN3aaa9GG1113322D1Ev();
Name_Map name_map__ZN3aaa9GG1113322E[] = {
  NSPAIR(_ZN3aaa9GG1113322C1Ev),
  NSPAIR(_ZN3aaa9GG1113322D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF332E;
extern VTBL_ENTRY _ZTIN3aaa5FF332E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF332E[];
static Base_Class bases__ZN3aaa9GG1113322E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF332E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113322E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11133223barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void _ZN3aaa3AA33fooEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11133223barEv,_ZThn20_N3aaa9GG11133223barEv)();
extern void _ZN3aaa3BB33fooEv();
extern void ABISELECT(_ZThn48_N3aaa9GG11133223barEv,_ZThn28_N3aaa9GG11133223barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113322E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113322E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11133223barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113322E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113322E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11133223barEv,_ZThn20_N3aaa9GG11133223barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113322E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11133223barEv,_ZThn28_N3aaa9GG11133223barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113322E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113322E[];
Class_Descriptor cd__ZN3aaa9GG1113322E = {  "_ZN3aaa9GG1113322E", // class name
  bases__ZN3aaa9GG1113322E, 6,
  &(vtc__ZN3aaa9GG1113322E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113322E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113322E),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113323  : ::aaa::EE111 , ::aaa::FF332 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11133233fooEv
  virtual void  bar(); // _ZN3aaa9GG11133233barEv
  ~GG1113323(); // tgen
  GG1113323(); // tgen
};
//SIG(1 _ZN3aaa9GG1113323E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 v2 Fi} BC7{ v1 v2 Fi} v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1113323 ::foo(){vfunc_called(this, "_ZN3aaa9GG11133233fooEv");}
void  aaa::GG1113323 ::bar(){vfunc_called(this, "_ZN3aaa9GG11133233barEv");}
aaa::GG1113323 ::~GG1113323(){ note_dtor("_ZN3aaa9GG1113323E", this);} // tgen
aaa::GG1113323 ::GG1113323(){ note_ctor("_ZN3aaa9GG1113323E", this);} // tgen
}
static void Test__ZN3aaa9GG1113323E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113323E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113323E, buf);
    ::aaa::GG1113323 *dp, &lv = *(dp=new (buf) ::aaa::GG1113323());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113323E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113323E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113323E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113323E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113323E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF332*), ABISELECT(32,20), "_ZN3aaa9GG1113323E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF332*), ABISELECT(48,28), "_ZN3aaa9GG1113323E");
    check_base_class_offset(lv, (::aaa::FF332*), ABISELECT(32,20), "_ZN3aaa9GG1113323E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113323E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113323E);
    dp->::aaa::GG1113323::~GG1113323();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113323E(Test__ZN3aaa9GG1113323E, "_ZN3aaa9GG1113323E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113323C1Ev();
extern void _ZN3aaa9GG1113323D1Ev();
Name_Map name_map__ZN3aaa9GG1113323E[] = {
  NSPAIR(_ZN3aaa9GG1113323C1Ev),
  NSPAIR(_ZN3aaa9GG1113323D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF332E;
extern VTBL_ENTRY _ZTIN3aaa5FF332E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF332E[];
static Base_Class bases__ZN3aaa9GG1113323E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF332E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113323E[];
extern void _ZN3aaa9GG11133233fooEv();
extern void _ZN3aaa9GG11133233barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11133233fooEv,_ZThn8_N3aaa9GG11133233fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11133233fooEv,_ZThn20_N3aaa9GG11133233fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11133233barEv,_ZThn20_N3aaa9GG11133233barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11133233fooEv,_ZThn28_N3aaa9GG11133233fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11133233barEv,_ZThn28_N3aaa9GG11133233barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113323E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113323E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11133233fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11133233barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113323E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11133233fooEv,_ZThn8_N3aaa9GG11133233fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113323E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11133233fooEv,_ZThn20_N3aaa9GG11133233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11133233barEv,_ZThn20_N3aaa9GG11133233barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113323E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11133233fooEv,_ZThn28_N3aaa9GG11133233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11133233barEv,_ZThn28_N3aaa9GG11133233barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113323E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113323E[];
Class_Descriptor cd__ZN3aaa9GG1113323E = {  "_ZN3aaa9GG1113323E", // class name
  bases__ZN3aaa9GG1113323E, 6,
  &(vtc__ZN3aaa9GG1113323E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113323E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113323E),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113331  : ::aaa::EE111 , ::aaa::FF333 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11133313fooEv
  ~GG1113331(); // tgen
  GG1113331(); // tgen
};
//SIG(1 _ZN3aaa9GG1113331E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 v2 Fi} BC7{ v1 v2 Fi} v1 v2 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1113331 ::foo(){vfunc_called(this, "_ZN3aaa9GG11133313fooEv");}
aaa::GG1113331 ::~GG1113331(){ note_dtor("_ZN3aaa9GG1113331E", this);} // tgen
aaa::GG1113331 ::GG1113331(){ note_ctor("_ZN3aaa9GG1113331E", this);} // tgen
}
static void Test__ZN3aaa9GG1113331E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113331E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113331E, buf);
    ::aaa::GG1113331 *dp, &lv = *(dp=new (buf) ::aaa::GG1113331());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113331E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113331E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113331E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113331E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113331E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF333*), ABISELECT(32,20), "_ZN3aaa9GG1113331E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF333*), ABISELECT(48,28), "_ZN3aaa9GG1113331E");
    check_base_class_offset(lv, (::aaa::FF333*), ABISELECT(32,20), "_ZN3aaa9GG1113331E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113331E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113331E);
    dp->::aaa::GG1113331::~GG1113331();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113331E(Test__ZN3aaa9GG1113331E, "_ZN3aaa9GG1113331E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113331C1Ev();
extern void _ZN3aaa9GG1113331D1Ev();
Name_Map name_map__ZN3aaa9GG1113331E[] = {
  NSPAIR(_ZN3aaa9GG1113331C1Ev),
  NSPAIR(_ZN3aaa9GG1113331D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF333E;
extern VTBL_ENTRY _ZTIN3aaa5FF333E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF333E[];
static Base_Class bases__ZN3aaa9GG1113331E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    3, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF333E,    ABISELECT(32,20), //bcp->offset
    6, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113331E[];
extern void _ZN3aaa9GG11133313fooEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11133313fooEv,_ZThn8_N3aaa9GG11133313fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11133313fooEv,_ZThn20_N3aaa9GG11133313fooEv)();
extern void _ZN3aaa5FF3333barEv();
extern void ABISELECT(_ZThn48_N3aaa9GG11133313fooEv,_ZThn28_N3aaa9GG11133313fooEv)();
extern void ABISELECT(_ZThn16_N3aaa5FF3333barEv,_ZThn8_N3aaa5FF3333barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113331E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113331E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11133313fooEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113331E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11133313fooEv,_ZThn8_N3aaa9GG11133313fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113331E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11133313fooEv,_ZThn20_N3aaa9GG11133313fooEv),
  (VTBL_ENTRY)&_ZN3aaa5FF3333barEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113331E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11133313fooEv,_ZThn28_N3aaa9GG11133313fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF3333barEv,_ZThn8_N3aaa5FF3333barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113331E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113331E[];
Class_Descriptor cd__ZN3aaa9GG1113331E = {  "_ZN3aaa9GG1113331E", // class name
  bases__ZN3aaa9GG1113331E, 6,
  &(vtc__ZN3aaa9GG1113331E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113331E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113331E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113332  : ::aaa::EE111 , ::aaa::FF333 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11133323barEv
  ~GG1113332(); // tgen
  GG1113332(); // tgen
};
//SIG(1 _ZN3aaa9GG1113332E) C1{ BC2{ BC3{ v2 Fi} BC4{ v2 Fi} v2 Fi} BC5{ BC6{ v3 v1 Fi} BC7{ v3 v1 Fi} v3 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1113332 ::bar(){vfunc_called(this, "_ZN3aaa9GG11133323barEv");}
aaa::GG1113332 ::~GG1113332(){ note_dtor("_ZN3aaa9GG1113332E", this);} // tgen
aaa::GG1113332 ::GG1113332(){ note_ctor("_ZN3aaa9GG1113332E", this);} // tgen
}
static void Test__ZN3aaa9GG1113332E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113332E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113332E, buf);
    ::aaa::GG1113332 *dp, &lv = *(dp=new (buf) ::aaa::GG1113332());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113332E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113332E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113332E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113332E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113332E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF333*), ABISELECT(32,20), "_ZN3aaa9GG1113332E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF333*), ABISELECT(48,28), "_ZN3aaa9GG1113332E");
    check_base_class_offset(lv, (::aaa::FF333*), ABISELECT(32,20), "_ZN3aaa9GG1113332E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113332E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113332E);
    dp->::aaa::GG1113332::~GG1113332();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113332E(Test__ZN3aaa9GG1113332E, "_ZN3aaa9GG1113332E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113332C1Ev();
extern void _ZN3aaa9GG1113332D1Ev();
Name_Map name_map__ZN3aaa9GG1113332E[] = {
  NSPAIR(_ZN3aaa9GG1113332C1Ev),
  NSPAIR(_ZN3aaa9GG1113332D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF333E;
extern VTBL_ENTRY _ZTIN3aaa5FF333E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF333E[];
static Base_Class bases__ZN3aaa9GG1113332E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF333E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113332E[];
extern void _ZN3aaa5EE1113fooEv();
extern void _ZN3aaa9GG11133323barEv();
extern void ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv)();
extern void _ZN3aaa5FF3333fooEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11133323barEv,_ZThn20_N3aaa9GG11133323barEv)();
extern void ABISELECT(_ZThn16_N3aaa5FF3333fooEv,_ZThn8_N3aaa5FF3333fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11133323barEv,_ZThn28_N3aaa9GG11133323barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113332E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113332E[0]),
  (VTBL_ENTRY)&_ZN3aaa5EE1113fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11133323barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113332E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5EE1113fooEv,_ZThn8_N3aaa5EE1113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113332E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF3333fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11133323barEv,_ZThn20_N3aaa9GG11133323barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113332E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF3333fooEv,_ZThn8_N3aaa5FF3333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11133323barEv,_ZThn28_N3aaa9GG11133323barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113332E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113332E[];
Class_Descriptor cd__ZN3aaa9GG1113332E = {  "_ZN3aaa9GG1113332E", // class name
  bases__ZN3aaa9GG1113332E, 6,
  &(vtc__ZN3aaa9GG1113332E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113332E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113332E),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1113333  : ::aaa::EE111 , ::aaa::FF333 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11133333fooEv
  virtual void  bar(); // _ZN3aaa9GG11133333barEv
  ~GG1113333(); // tgen
  GG1113333(); // tgen
};
//SIG(1 _ZN3aaa9GG1113333E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v1 Fi} BC5{ BC6{ v1 v2 Fi} BC7{ v1 v2 Fi} v1 v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1113333 ::foo(){vfunc_called(this, "_ZN3aaa9GG11133333fooEv");}
void  aaa::GG1113333 ::bar(){vfunc_called(this, "_ZN3aaa9GG11133333barEv");}
aaa::GG1113333 ::~GG1113333(){ note_dtor("_ZN3aaa9GG1113333E", this);} // tgen
aaa::GG1113333 ::GG1113333(){ note_ctor("_ZN3aaa9GG1113333E", this);} // tgen
}
static void Test__ZN3aaa9GG1113333E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1113333E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1113333E, buf);
    ::aaa::GG1113333 *dp, &lv = *(dp=new (buf) ::aaa::GG1113333());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1113333E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1113333E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE111*), 0, "_ZN3aaa9GG1113333E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE111*), ABISELECT(16,8), "_ZN3aaa9GG1113333E");
    check_base_class_offset(lv, (::aaa::EE111*), 0, "_ZN3aaa9GG1113333E");
    check_base_class_offset(lv, (::aaa::AA3*)(::aaa::FF333*), ABISELECT(32,20), "_ZN3aaa9GG1113333E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF333*), ABISELECT(48,28), "_ZN3aaa9GG1113333E");
    check_base_class_offset(lv, (::aaa::FF333*), ABISELECT(32,20), "_ZN3aaa9GG1113333E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1113333E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1113333E);
    dp->::aaa::GG1113333::~GG1113333();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1113333E(Test__ZN3aaa9GG1113333E, "_ZN3aaa9GG1113333E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1113333C1Ev();
extern void _ZN3aaa9GG1113333D1Ev();
Name_Map name_map__ZN3aaa9GG1113333E[] = {
  NSPAIR(_ZN3aaa9GG1113333C1Ev),
  NSPAIR(_ZN3aaa9GG1113333D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE111E;
extern VTBL_ENTRY _ZTIN3aaa5EE111E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE111E[];
extern Class_Descriptor cd__ZN3aaa3AA3E;
extern VTBL_ENTRY _ZTIN3aaa3AA3E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA3E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF333E;
extern VTBL_ENTRY _ZTIN3aaa5FF333E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF333E[];
static Base_Class bases__ZN3aaa9GG1113333E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA3E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF333E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1113333E[];
extern void _ZN3aaa9GG11133333fooEv();
extern void _ZN3aaa9GG11133333barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11133333fooEv,_ZThn8_N3aaa9GG11133333fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11133333fooEv,_ZThn20_N3aaa9GG11133333fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11133333barEv,_ZThn20_N3aaa9GG11133333barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11133333fooEv,_ZThn28_N3aaa9GG11133333fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11133333barEv,_ZThn28_N3aaa9GG11133333barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1113333E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113333E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11133333fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11133333barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113333E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11133333fooEv,_ZThn8_N3aaa9GG11133333fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113333E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11133333fooEv,_ZThn20_N3aaa9GG11133333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11133333barEv,_ZThn20_N3aaa9GG11133333barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1113333E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11133333fooEv,_ZThn28_N3aaa9GG11133333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11133333barEv,_ZThn28_N3aaa9GG11133333barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1113333E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1113333E[];
Class_Descriptor cd__ZN3aaa9GG1113333E = {  "_ZN3aaa9GG1113333E", // class name
  bases__ZN3aaa9GG1113333E, 6,
  &(vtc__ZN3aaa9GG1113333E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1113333E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1113333E),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121111  : ::aaa::EE112 , ::aaa::FF111 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11211113fooEv
  ~GG1121111(); // tgen
  GG1121111(); // tgen
};
//SIG(1 _ZN3aaa9GG1121111E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v2 Fi} BC5{ BC3 BC4 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1121111 ::foo(){vfunc_called(this, "_ZN3aaa9GG11211113fooEv");}
aaa::GG1121111 ::~GG1121111(){ note_dtor("_ZN3aaa9GG1121111E", this);} // tgen
aaa::GG1121111 ::GG1121111(){ note_ctor("_ZN3aaa9GG1121111E", this);} // tgen
}
static void Test__ZN3aaa9GG1121111E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121111E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121111E, buf);
    ::aaa::GG1121111 *dp, &lv = *(dp=new (buf) ::aaa::GG1121111());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121111E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121111E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121111E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121111E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121111E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF111*), ABISELECT(32,20), "_ZN3aaa9GG1121111E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF111*), ABISELECT(48,28), "_ZN3aaa9GG1121111E");
    check_base_class_offset(lv, (::aaa::FF111*), ABISELECT(32,20), "_ZN3aaa9GG1121111E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121111E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121111E);
    dp->::aaa::GG1121111::~GG1121111();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121111E(Test__ZN3aaa9GG1121111E, "_ZN3aaa9GG1121111E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121111C1Ev();
extern void _ZN3aaa9GG1121111D1Ev();
Name_Map name_map__ZN3aaa9GG1121111E[] = {
  NSPAIR(_ZN3aaa9GG1121111C1Ev),
  NSPAIR(_ZN3aaa9GG1121111D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF111E;
extern VTBL_ENTRY _ZTIN3aaa5FF111E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF111E[];
static Base_Class bases__ZN3aaa9GG1121111E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF111E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121111E[];
extern void _ZN3aaa9GG11211113fooEv();
extern void _ZN3aaa5EE1123barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11211113fooEv,_ZThn8_N3aaa9GG11211113fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11211113fooEv,_ZThn20_N3aaa9GG11211113fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11211113fooEv,_ZThn28_N3aaa9GG11211113fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121111E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121111E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11211113fooEv,
  (VTBL_ENTRY)&_ZN3aaa5EE1123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121111E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11211113fooEv,_ZThn8_N3aaa9GG11211113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121111E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11211113fooEv,_ZThn20_N3aaa9GG11211113fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121111E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11211113fooEv,_ZThn28_N3aaa9GG11211113fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121111E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121111E[];
Class_Descriptor cd__ZN3aaa9GG1121111E = {  "_ZN3aaa9GG1121111E", // class name
  bases__ZN3aaa9GG1121111E, 6,
  &(vtc__ZN3aaa9GG1121111E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121111E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121111E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121112  : ::aaa::EE112 , ::aaa::FF111 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11211123barEv
  ~GG1121112(); // tgen
  GG1121112(); // tgen
};
//SIG(1 _ZN3aaa9GG1121112E) C1{ BC2{ BC3{ v2 Fi} BC4{ v3 Fi} v1 Fi} BC5{ BC3 BC4 v4 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1121112 ::bar(){vfunc_called(this, "_ZN3aaa9GG11211123barEv");}
aaa::GG1121112 ::~GG1121112(){ note_dtor("_ZN3aaa9GG1121112E", this);} // tgen
aaa::GG1121112 ::GG1121112(){ note_ctor("_ZN3aaa9GG1121112E", this);} // tgen
}
static void Test__ZN3aaa9GG1121112E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121112E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121112E, buf);
    ::aaa::GG1121112 *dp, &lv = *(dp=new (buf) ::aaa::GG1121112());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121112E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121112E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121112E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121112E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121112E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF111*), ABISELECT(32,20), "_ZN3aaa9GG1121112E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF111*), ABISELECT(48,28), "_ZN3aaa9GG1121112E");
    check_base_class_offset(lv, (::aaa::FF111*), ABISELECT(32,20), "_ZN3aaa9GG1121112E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121112E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121112E);
    dp->::aaa::GG1121112::~GG1121112();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121112E(Test__ZN3aaa9GG1121112E, "_ZN3aaa9GG1121112E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121112C1Ev();
extern void _ZN3aaa9GG1121112D1Ev();
Name_Map name_map__ZN3aaa9GG1121112E[] = {
  NSPAIR(_ZN3aaa9GG1121112C1Ev),
  NSPAIR(_ZN3aaa9GG1121112D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF111E;
extern VTBL_ENTRY _ZTIN3aaa5FF111E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF111E[];
static Base_Class bases__ZN3aaa9GG1121112E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF111E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121112E[];
extern void _ZN3aaa3AA13fooEv();
extern void _ZN3aaa9GG11211123barEv();
extern void _ZN3aaa3BB13fooEv();
extern void _ZN3aaa5FF1113fooEv();
extern void ABISELECT(_ZThn16_N3aaa5FF1113fooEv,_ZThn8_N3aaa5FF1113fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121112E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121112E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA13fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11211123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121112E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB13fooEv,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121112E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF1113fooEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121112E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF1113fooEv,_ZThn8_N3aaa5FF1113fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121112E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121112E[];
Class_Descriptor cd__ZN3aaa9GG1121112E = {  "_ZN3aaa9GG1121112E", // class name
  bases__ZN3aaa9GG1121112E, 6,
  &(vtc__ZN3aaa9GG1121112E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121112E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121112E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121113  : ::aaa::EE112 , ::aaa::FF111 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11211133fooEv
  virtual void  bar(); // _ZN3aaa9GG11211133barEv
  ~GG1121113(); // tgen
  GG1121113(); // tgen
};
//SIG(1 _ZN3aaa9GG1121113E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v2 Fi} BC5{ BC3 BC4 v1 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1121113 ::foo(){vfunc_called(this, "_ZN3aaa9GG11211133fooEv");}
void  aaa::GG1121113 ::bar(){vfunc_called(this, "_ZN3aaa9GG11211133barEv");}
aaa::GG1121113 ::~GG1121113(){ note_dtor("_ZN3aaa9GG1121113E", this);} // tgen
aaa::GG1121113 ::GG1121113(){ note_ctor("_ZN3aaa9GG1121113E", this);} // tgen
}
static void Test__ZN3aaa9GG1121113E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121113E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121113E, buf);
    ::aaa::GG1121113 *dp, &lv = *(dp=new (buf) ::aaa::GG1121113());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121113E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121113E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121113E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121113E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121113E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF111*), ABISELECT(32,20), "_ZN3aaa9GG1121113E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF111*), ABISELECT(48,28), "_ZN3aaa9GG1121113E");
    check_base_class_offset(lv, (::aaa::FF111*), ABISELECT(32,20), "_ZN3aaa9GG1121113E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121113E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121113E);
    dp->::aaa::GG1121113::~GG1121113();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121113E(Test__ZN3aaa9GG1121113E, "_ZN3aaa9GG1121113E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121113C1Ev();
extern void _ZN3aaa9GG1121113D1Ev();
Name_Map name_map__ZN3aaa9GG1121113E[] = {
  NSPAIR(_ZN3aaa9GG1121113C1Ev),
  NSPAIR(_ZN3aaa9GG1121113D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF111E;
extern VTBL_ENTRY _ZTIN3aaa5FF111E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF111E[];
static Base_Class bases__ZN3aaa9GG1121113E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF111E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121113E[];
extern void _ZN3aaa9GG11211133fooEv();
extern void _ZN3aaa9GG11211133barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11211133fooEv,_ZThn8_N3aaa9GG11211133fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11211133fooEv,_ZThn20_N3aaa9GG11211133fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11211133fooEv,_ZThn28_N3aaa9GG11211133fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121113E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121113E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11211133fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11211133barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121113E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11211133fooEv,_ZThn8_N3aaa9GG11211133fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121113E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11211133fooEv,_ZThn20_N3aaa9GG11211133fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121113E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11211133fooEv,_ZThn28_N3aaa9GG11211133fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121113E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121113E[];
Class_Descriptor cd__ZN3aaa9GG1121113E = {  "_ZN3aaa9GG1121113E", // class name
  bases__ZN3aaa9GG1121113E, 6,
  &(vtc__ZN3aaa9GG1121113E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121113E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121113E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121121  : ::aaa::EE112 , ::aaa::FF112 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11211213fooEv
  ~GG1121121(); // tgen
  GG1121121(); // tgen
};
//SIG(1 _ZN3aaa9GG1121121E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v2 Fi} BC5{ BC3 BC4 v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1121121 ::foo(){vfunc_called(this, "_ZN3aaa9GG11211213fooEv");}
aaa::GG1121121 ::~GG1121121(){ note_dtor("_ZN3aaa9GG1121121E", this);} // tgen
aaa::GG1121121 ::GG1121121(){ note_ctor("_ZN3aaa9GG1121121E", this);} // tgen
}
static void Test__ZN3aaa9GG1121121E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121121E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121121E, buf);
    ::aaa::GG1121121 *dp, &lv = *(dp=new (buf) ::aaa::GG1121121());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121121E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121121E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121121E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121121E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121121E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF112*), ABISELECT(32,20), "_ZN3aaa9GG1121121E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF112*), ABISELECT(48,28), "_ZN3aaa9GG1121121E");
    check_base_class_offset(lv, (::aaa::FF112*), ABISELECT(32,20), "_ZN3aaa9GG1121121E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121121E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121121E);
    dp->::aaa::GG1121121::~GG1121121();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121121E(Test__ZN3aaa9GG1121121E, "_ZN3aaa9GG1121121E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121121C1Ev();
extern void _ZN3aaa9GG1121121D1Ev();
Name_Map name_map__ZN3aaa9GG1121121E[] = {
  NSPAIR(_ZN3aaa9GG1121121C1Ev),
  NSPAIR(_ZN3aaa9GG1121121D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF112E;
extern VTBL_ENTRY _ZTIN3aaa5FF112E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF112E[];
static Base_Class bases__ZN3aaa9GG1121121E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF112E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121121E[];
extern void _ZN3aaa9GG11211213fooEv();
extern void _ZN3aaa5EE1123barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11211213fooEv,_ZThn8_N3aaa9GG11211213fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11211213fooEv,_ZThn20_N3aaa9GG11211213fooEv)();
extern void _ZN3aaa5FF1123barEv();
extern void ABISELECT(_ZThn48_N3aaa9GG11211213fooEv,_ZThn28_N3aaa9GG11211213fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121121E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121121E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11211213fooEv,
  (VTBL_ENTRY)&_ZN3aaa5EE1123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121121E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11211213fooEv,_ZThn8_N3aaa9GG11211213fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121121E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11211213fooEv,_ZThn20_N3aaa9GG11211213fooEv),
  (VTBL_ENTRY)&_ZN3aaa5FF1123barEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121121E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11211213fooEv,_ZThn28_N3aaa9GG11211213fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121121E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121121E[];
Class_Descriptor cd__ZN3aaa9GG1121121E = {  "_ZN3aaa9GG1121121E", // class name
  bases__ZN3aaa9GG1121121E, 6,
  &(vtc__ZN3aaa9GG1121121E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121121E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121121E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121122  : ::aaa::EE112 , ::aaa::FF112 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11211223barEv
  ~GG1121122(); // tgen
  GG1121122(); // tgen
};
//SIG(1 _ZN3aaa9GG1121122E) C1{ BC2{ BC3{ v2 Fi} BC4{ v3 Fi} v1 Fi} BC5{ BC3 BC4 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1121122 ::bar(){vfunc_called(this, "_ZN3aaa9GG11211223barEv");}
aaa::GG1121122 ::~GG1121122(){ note_dtor("_ZN3aaa9GG1121122E", this);} // tgen
aaa::GG1121122 ::GG1121122(){ note_ctor("_ZN3aaa9GG1121122E", this);} // tgen
}
static void Test__ZN3aaa9GG1121122E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121122E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121122E, buf);
    ::aaa::GG1121122 *dp, &lv = *(dp=new (buf) ::aaa::GG1121122());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121122E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121122E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121122E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121122E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121122E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF112*), ABISELECT(32,20), "_ZN3aaa9GG1121122E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF112*), ABISELECT(48,28), "_ZN3aaa9GG1121122E");
    check_base_class_offset(lv, (::aaa::FF112*), ABISELECT(32,20), "_ZN3aaa9GG1121122E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121122E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121122E);
    dp->::aaa::GG1121122::~GG1121122();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121122E(Test__ZN3aaa9GG1121122E, "_ZN3aaa9GG1121122E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121122C1Ev();
extern void _ZN3aaa9GG1121122D1Ev();
Name_Map name_map__ZN3aaa9GG1121122E[] = {
  NSPAIR(_ZN3aaa9GG1121122C1Ev),
  NSPAIR(_ZN3aaa9GG1121122D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF112E;
extern VTBL_ENTRY _ZTIN3aaa5FF112E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF112E[];
static Base_Class bases__ZN3aaa9GG1121122E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF112E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121122E[];
extern void _ZN3aaa3AA13fooEv();
extern void _ZN3aaa9GG11211223barEv();
extern void _ZN3aaa3BB13fooEv();
extern void _ZN3aaa3AA13fooEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11211223barEv,_ZThn20_N3aaa9GG11211223barEv)();
extern void _ZN3aaa3BB13fooEv();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121122E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121122E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA13fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11211223barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121122E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB13fooEv,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121122E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA13fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11211223barEv,_ZThn20_N3aaa9GG11211223barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121122E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB13fooEv,
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121122E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121122E[];
Class_Descriptor cd__ZN3aaa9GG1121122E = {  "_ZN3aaa9GG1121122E", // class name
  bases__ZN3aaa9GG1121122E, 6,
  &(vtc__ZN3aaa9GG1121122E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121122E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121122E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121123  : ::aaa::EE112 , ::aaa::FF112 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11211233fooEv
  virtual void  bar(); // _ZN3aaa9GG11211233barEv
  ~GG1121123(); // tgen
  GG1121123(); // tgen
};
//SIG(1 _ZN3aaa9GG1121123E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v2 Fi} BC5{ BC3 BC4 v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1121123 ::foo(){vfunc_called(this, "_ZN3aaa9GG11211233fooEv");}
void  aaa::GG1121123 ::bar(){vfunc_called(this, "_ZN3aaa9GG11211233barEv");}
aaa::GG1121123 ::~GG1121123(){ note_dtor("_ZN3aaa9GG1121123E", this);} // tgen
aaa::GG1121123 ::GG1121123(){ note_ctor("_ZN3aaa9GG1121123E", this);} // tgen
}
static void Test__ZN3aaa9GG1121123E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121123E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121123E, buf);
    ::aaa::GG1121123 *dp, &lv = *(dp=new (buf) ::aaa::GG1121123());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121123E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121123E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121123E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121123E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121123E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF112*), ABISELECT(32,20), "_ZN3aaa9GG1121123E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF112*), ABISELECT(48,28), "_ZN3aaa9GG1121123E");
    check_base_class_offset(lv, (::aaa::FF112*), ABISELECT(32,20), "_ZN3aaa9GG1121123E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121123E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121123E);
    dp->::aaa::GG1121123::~GG1121123();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121123E(Test__ZN3aaa9GG1121123E, "_ZN3aaa9GG1121123E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121123C1Ev();
extern void _ZN3aaa9GG1121123D1Ev();
Name_Map name_map__ZN3aaa9GG1121123E[] = {
  NSPAIR(_ZN3aaa9GG1121123C1Ev),
  NSPAIR(_ZN3aaa9GG1121123D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF112E;
extern VTBL_ENTRY _ZTIN3aaa5FF112E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF112E[];
static Base_Class bases__ZN3aaa9GG1121123E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF112E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121123E[];
extern void _ZN3aaa9GG11211233fooEv();
extern void _ZN3aaa9GG11211233barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11211233fooEv,_ZThn8_N3aaa9GG11211233fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11211233fooEv,_ZThn20_N3aaa9GG11211233fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11211233barEv,_ZThn20_N3aaa9GG11211233barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11211233fooEv,_ZThn28_N3aaa9GG11211233fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121123E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121123E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11211233fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11211233barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121123E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11211233fooEv,_ZThn8_N3aaa9GG11211233fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121123E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11211233fooEv,_ZThn20_N3aaa9GG11211233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11211233barEv,_ZThn20_N3aaa9GG11211233barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121123E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11211233fooEv,_ZThn28_N3aaa9GG11211233fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121123E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121123E[];
Class_Descriptor cd__ZN3aaa9GG1121123E = {  "_ZN3aaa9GG1121123E", // class name
  bases__ZN3aaa9GG1121123E, 6,
  &(vtc__ZN3aaa9GG1121123E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121123E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121123E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121131  : ::aaa::EE112 , ::aaa::FF113 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11211313fooEv
  ~GG1121131(); // tgen
  GG1121131(); // tgen
};
//SIG(1 _ZN3aaa9GG1121131E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v2 Fi} BC5{ BC3 BC4 v1 v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1121131 ::foo(){vfunc_called(this, "_ZN3aaa9GG11211313fooEv");}
aaa::GG1121131 ::~GG1121131(){ note_dtor("_ZN3aaa9GG1121131E", this);} // tgen
aaa::GG1121131 ::GG1121131(){ note_ctor("_ZN3aaa9GG1121131E", this);} // tgen
}
static void Test__ZN3aaa9GG1121131E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121131E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121131E, buf);
    ::aaa::GG1121131 *dp, &lv = *(dp=new (buf) ::aaa::GG1121131());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121131E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121131E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121131E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121131E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121131E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF113*), ABISELECT(32,20), "_ZN3aaa9GG1121131E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF113*), ABISELECT(48,28), "_ZN3aaa9GG1121131E");
    check_base_class_offset(lv, (::aaa::FF113*), ABISELECT(32,20), "_ZN3aaa9GG1121131E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121131E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121131E);
    dp->::aaa::GG1121131::~GG1121131();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121131E(Test__ZN3aaa9GG1121131E, "_ZN3aaa9GG1121131E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121131C1Ev();
extern void _ZN3aaa9GG1121131D1Ev();
Name_Map name_map__ZN3aaa9GG1121131E[] = {
  NSPAIR(_ZN3aaa9GG1121131C1Ev),
  NSPAIR(_ZN3aaa9GG1121131D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF113E;
extern VTBL_ENTRY _ZTIN3aaa5FF113E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF113E[];
static Base_Class bases__ZN3aaa9GG1121131E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF113E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121131E[];
extern void _ZN3aaa9GG11211313fooEv();
extern void _ZN3aaa5EE1123barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11211313fooEv,_ZThn8_N3aaa9GG11211313fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11211313fooEv,_ZThn20_N3aaa9GG11211313fooEv)();
extern void _ZN3aaa5FF1133barEv();
extern void ABISELECT(_ZThn48_N3aaa9GG11211313fooEv,_ZThn28_N3aaa9GG11211313fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121131E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121131E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11211313fooEv,
  (VTBL_ENTRY)&_ZN3aaa5EE1123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121131E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11211313fooEv,_ZThn8_N3aaa9GG11211313fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121131E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11211313fooEv,_ZThn20_N3aaa9GG11211313fooEv),
  (VTBL_ENTRY)&_ZN3aaa5FF1133barEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121131E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11211313fooEv,_ZThn28_N3aaa9GG11211313fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121131E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121131E[];
Class_Descriptor cd__ZN3aaa9GG1121131E = {  "_ZN3aaa9GG1121131E", // class name
  bases__ZN3aaa9GG1121131E, 6,
  &(vtc__ZN3aaa9GG1121131E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121131E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121131E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121132  : ::aaa::EE112 , ::aaa::FF113 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11211323barEv
  ~GG1121132(); // tgen
  GG1121132(); // tgen
};
//SIG(1 _ZN3aaa9GG1121132E) C1{ BC2{ BC3{ v2 Fi} BC4{ v3 Fi} v1 Fi} BC5{ BC3 BC4 v4 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1121132 ::bar(){vfunc_called(this, "_ZN3aaa9GG11211323barEv");}
aaa::GG1121132 ::~GG1121132(){ note_dtor("_ZN3aaa9GG1121132E", this);} // tgen
aaa::GG1121132 ::GG1121132(){ note_ctor("_ZN3aaa9GG1121132E", this);} // tgen
}
static void Test__ZN3aaa9GG1121132E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121132E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121132E, buf);
    ::aaa::GG1121132 *dp, &lv = *(dp=new (buf) ::aaa::GG1121132());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121132E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121132E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121132E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121132E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121132E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF113*), ABISELECT(32,20), "_ZN3aaa9GG1121132E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF113*), ABISELECT(48,28), "_ZN3aaa9GG1121132E");
    check_base_class_offset(lv, (::aaa::FF113*), ABISELECT(32,20), "_ZN3aaa9GG1121132E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121132E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121132E);
    dp->::aaa::GG1121132::~GG1121132();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121132E(Test__ZN3aaa9GG1121132E, "_ZN3aaa9GG1121132E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121132C1Ev();
extern void _ZN3aaa9GG1121132D1Ev();
Name_Map name_map__ZN3aaa9GG1121132E[] = {
  NSPAIR(_ZN3aaa9GG1121132C1Ev),
  NSPAIR(_ZN3aaa9GG1121132D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF113E;
extern VTBL_ENTRY _ZTIN3aaa5FF113E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF113E[];
static Base_Class bases__ZN3aaa9GG1121132E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF113E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121132E[];
extern void _ZN3aaa3AA13fooEv();
extern void _ZN3aaa9GG11211323barEv();
extern void _ZN3aaa3BB13fooEv();
extern void _ZN3aaa5FF1133fooEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11211323barEv,_ZThn20_N3aaa9GG11211323barEv)();
extern void ABISELECT(_ZThn16_N3aaa5FF1133fooEv,_ZThn8_N3aaa5FF1133fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121132E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121132E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA13fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11211323barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121132E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB13fooEv,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121132E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF1133fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11211323barEv,_ZThn20_N3aaa9GG11211323barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121132E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF1133fooEv,_ZThn8_N3aaa5FF1133fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121132E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121132E[];
Class_Descriptor cd__ZN3aaa9GG1121132E = {  "_ZN3aaa9GG1121132E", // class name
  bases__ZN3aaa9GG1121132E, 6,
  &(vtc__ZN3aaa9GG1121132E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121132E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121132E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121133  : ::aaa::EE112 , ::aaa::FF113 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11211333fooEv
  virtual void  bar(); // _ZN3aaa9GG11211333barEv
  ~GG1121133(); // tgen
  GG1121133(); // tgen
};
//SIG(1 _ZN3aaa9GG1121133E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v2 Fi} BC5{ BC3 BC4 v1 v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1121133 ::foo(){vfunc_called(this, "_ZN3aaa9GG11211333fooEv");}
void  aaa::GG1121133 ::bar(){vfunc_called(this, "_ZN3aaa9GG11211333barEv");}
aaa::GG1121133 ::~GG1121133(){ note_dtor("_ZN3aaa9GG1121133E", this);} // tgen
aaa::GG1121133 ::GG1121133(){ note_ctor("_ZN3aaa9GG1121133E", this);} // tgen
}
static void Test__ZN3aaa9GG1121133E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121133E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121133E, buf);
    ::aaa::GG1121133 *dp, &lv = *(dp=new (buf) ::aaa::GG1121133());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121133E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121133E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121133E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121133E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121133E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF113*), ABISELECT(32,20), "_ZN3aaa9GG1121133E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF113*), ABISELECT(48,28), "_ZN3aaa9GG1121133E");
    check_base_class_offset(lv, (::aaa::FF113*), ABISELECT(32,20), "_ZN3aaa9GG1121133E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121133E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121133E);
    dp->::aaa::GG1121133::~GG1121133();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121133E(Test__ZN3aaa9GG1121133E, "_ZN3aaa9GG1121133E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121133C1Ev();
extern void _ZN3aaa9GG1121133D1Ev();
Name_Map name_map__ZN3aaa9GG1121133E[] = {
  NSPAIR(_ZN3aaa9GG1121133C1Ev),
  NSPAIR(_ZN3aaa9GG1121133D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF113E;
extern VTBL_ENTRY _ZTIN3aaa5FF113E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF113E[];
static Base_Class bases__ZN3aaa9GG1121133E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF113E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121133E[];
extern void _ZN3aaa9GG11211333fooEv();
extern void _ZN3aaa9GG11211333barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11211333fooEv,_ZThn8_N3aaa9GG11211333fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11211333fooEv,_ZThn20_N3aaa9GG11211333fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11211333barEv,_ZThn20_N3aaa9GG11211333barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11211333fooEv,_ZThn28_N3aaa9GG11211333fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121133E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121133E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11211333fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11211333barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121133E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11211333fooEv,_ZThn8_N3aaa9GG11211333fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121133E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11211333fooEv,_ZThn20_N3aaa9GG11211333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11211333barEv,_ZThn20_N3aaa9GG11211333barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121133E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11211333fooEv,_ZThn28_N3aaa9GG11211333fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121133E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121133E[];
Class_Descriptor cd__ZN3aaa9GG1121133E = {  "_ZN3aaa9GG1121133E", // class name
  bases__ZN3aaa9GG1121133E, 6,
  &(vtc__ZN3aaa9GG1121133E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121133E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121133E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121211  : ::aaa::EE112 , ::aaa::FF121 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11212113fooEv
  ~GG1121211(); // tgen
  GG1121211(); // tgen
};
//SIG(1 _ZN3aaa9GG1121211E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v2 Fi} BC5{ BC3 BC6{ v3 Fi} v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1121211 ::foo(){vfunc_called(this, "_ZN3aaa9GG11212113fooEv");}
aaa::GG1121211 ::~GG1121211(){ note_dtor("_ZN3aaa9GG1121211E", this);} // tgen
aaa::GG1121211 ::GG1121211(){ note_ctor("_ZN3aaa9GG1121211E", this);} // tgen
}
static void Test__ZN3aaa9GG1121211E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121211E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121211E, buf);
    ::aaa::GG1121211 *dp, &lv = *(dp=new (buf) ::aaa::GG1121211());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121211E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121211E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121211E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121211E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121211E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF121*), ABISELECT(32,20), "_ZN3aaa9GG1121211E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF121*), ABISELECT(48,28), "_ZN3aaa9GG1121211E");
    check_base_class_offset(lv, (::aaa::FF121*), ABISELECT(32,20), "_ZN3aaa9GG1121211E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121211E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121211E);
    dp->::aaa::GG1121211::~GG1121211();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121211E(Test__ZN3aaa9GG1121211E, "_ZN3aaa9GG1121211E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121211C1Ev();
extern void _ZN3aaa9GG1121211D1Ev();
Name_Map name_map__ZN3aaa9GG1121211E[] = {
  NSPAIR(_ZN3aaa9GG1121211C1Ev),
  NSPAIR(_ZN3aaa9GG1121211D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF121E;
extern VTBL_ENTRY _ZTIN3aaa5FF121E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF121E[];
static Base_Class bases__ZN3aaa9GG1121211E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF121E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121211E[];
extern void _ZN3aaa9GG11212113fooEv();
extern void _ZN3aaa5EE1123barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11212113fooEv,_ZThn8_N3aaa9GG11212113fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11212113fooEv,_ZThn20_N3aaa9GG11212113fooEv)();
extern void _ZN3aaa3BB23barEv();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121211E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121211E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11212113fooEv,
  (VTBL_ENTRY)&_ZN3aaa5EE1123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121211E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11212113fooEv,_ZThn8_N3aaa9GG11212113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121211E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11212113fooEv,_ZThn20_N3aaa9GG11212113fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121211E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB23barEv,
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121211E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121211E[];
Class_Descriptor cd__ZN3aaa9GG1121211E = {  "_ZN3aaa9GG1121211E", // class name
  bases__ZN3aaa9GG1121211E, 6,
  &(vtc__ZN3aaa9GG1121211E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121211E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121211E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121212  : ::aaa::EE112 , ::aaa::FF121 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11212123barEv
  ~GG1121212(); // tgen
  GG1121212(); // tgen
};
//SIG(1 _ZN3aaa9GG1121212E) C1{ BC2{ BC3{ v2 Fi} BC4{ v3 Fi} v1 Fi} BC5{ BC3 BC6{ v1 Fi} v4 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1121212 ::bar(){vfunc_called(this, "_ZN3aaa9GG11212123barEv");}
aaa::GG1121212 ::~GG1121212(){ note_dtor("_ZN3aaa9GG1121212E", this);} // tgen
aaa::GG1121212 ::GG1121212(){ note_ctor("_ZN3aaa9GG1121212E", this);} // tgen
}
static void Test__ZN3aaa9GG1121212E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121212E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121212E, buf);
    ::aaa::GG1121212 *dp, &lv = *(dp=new (buf) ::aaa::GG1121212());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121212E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121212E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121212E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121212E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121212E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF121*), ABISELECT(32,20), "_ZN3aaa9GG1121212E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF121*), ABISELECT(48,28), "_ZN3aaa9GG1121212E");
    check_base_class_offset(lv, (::aaa::FF121*), ABISELECT(32,20), "_ZN3aaa9GG1121212E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121212E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121212E);
    dp->::aaa::GG1121212::~GG1121212();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121212E(Test__ZN3aaa9GG1121212E, "_ZN3aaa9GG1121212E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121212C1Ev();
extern void _ZN3aaa9GG1121212D1Ev();
Name_Map name_map__ZN3aaa9GG1121212E[] = {
  NSPAIR(_ZN3aaa9GG1121212C1Ev),
  NSPAIR(_ZN3aaa9GG1121212D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF121E;
extern VTBL_ENTRY _ZTIN3aaa5FF121E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF121E[];
static Base_Class bases__ZN3aaa9GG1121212E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF121E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121212E[];
extern void _ZN3aaa3AA13fooEv();
extern void _ZN3aaa9GG11212123barEv();
extern void _ZN3aaa3BB13fooEv();
extern void _ZN3aaa5FF1213fooEv();
extern void ABISELECT(_ZThn48_N3aaa9GG11212123barEv,_ZThn28_N3aaa9GG11212123barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121212E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121212E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA13fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11212123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121212E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB13fooEv,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121212E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF1213fooEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121212E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11212123barEv,_ZThn28_N3aaa9GG11212123barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121212E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121212E[];
Class_Descriptor cd__ZN3aaa9GG1121212E = {  "_ZN3aaa9GG1121212E", // class name
  bases__ZN3aaa9GG1121212E, 6,
  &(vtc__ZN3aaa9GG1121212E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121212E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121212E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121213  : ::aaa::EE112 , ::aaa::FF121 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11212133fooEv
  virtual void  bar(); // _ZN3aaa9GG11212133barEv
  ~GG1121213(); // tgen
  GG1121213(); // tgen
};
//SIG(1 _ZN3aaa9GG1121213E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v2 Fi} BC5{ BC3 BC6{ v2 Fi} v1 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1121213 ::foo(){vfunc_called(this, "_ZN3aaa9GG11212133fooEv");}
void  aaa::GG1121213 ::bar(){vfunc_called(this, "_ZN3aaa9GG11212133barEv");}
aaa::GG1121213 ::~GG1121213(){ note_dtor("_ZN3aaa9GG1121213E", this);} // tgen
aaa::GG1121213 ::GG1121213(){ note_ctor("_ZN3aaa9GG1121213E", this);} // tgen
}
static void Test__ZN3aaa9GG1121213E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121213E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121213E, buf);
    ::aaa::GG1121213 *dp, &lv = *(dp=new (buf) ::aaa::GG1121213());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121213E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121213E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121213E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121213E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121213E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF121*), ABISELECT(32,20), "_ZN3aaa9GG1121213E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF121*), ABISELECT(48,28), "_ZN3aaa9GG1121213E");
    check_base_class_offset(lv, (::aaa::FF121*), ABISELECT(32,20), "_ZN3aaa9GG1121213E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121213E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121213E);
    dp->::aaa::GG1121213::~GG1121213();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121213E(Test__ZN3aaa9GG1121213E, "_ZN3aaa9GG1121213E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121213C1Ev();
extern void _ZN3aaa9GG1121213D1Ev();
Name_Map name_map__ZN3aaa9GG1121213E[] = {
  NSPAIR(_ZN3aaa9GG1121213C1Ev),
  NSPAIR(_ZN3aaa9GG1121213D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF121E;
extern VTBL_ENTRY _ZTIN3aaa5FF121E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF121E[];
static Base_Class bases__ZN3aaa9GG1121213E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF121E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121213E[];
extern void _ZN3aaa9GG11212133fooEv();
extern void _ZN3aaa9GG11212133barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11212133fooEv,_ZThn8_N3aaa9GG11212133fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11212133fooEv,_ZThn20_N3aaa9GG11212133fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11212133barEv,_ZThn28_N3aaa9GG11212133barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121213E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121213E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11212133fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11212133barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121213E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11212133fooEv,_ZThn8_N3aaa9GG11212133fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121213E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11212133fooEv,_ZThn20_N3aaa9GG11212133fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121213E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11212133barEv,_ZThn28_N3aaa9GG11212133barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121213E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121213E[];
Class_Descriptor cd__ZN3aaa9GG1121213E = {  "_ZN3aaa9GG1121213E", // class name
  bases__ZN3aaa9GG1121213E, 6,
  &(vtc__ZN3aaa9GG1121213E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121213E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121213E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121221  : ::aaa::EE112 , ::aaa::FF122 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11212213fooEv
  ~GG1121221(); // tgen
  GG1121221(); // tgen
};
//SIG(1 _ZN3aaa9GG1121221E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v2 Fi} BC5{ BC3 BC6{ v3 Fi} v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1121221 ::foo(){vfunc_called(this, "_ZN3aaa9GG11212213fooEv");}
aaa::GG1121221 ::~GG1121221(){ note_dtor("_ZN3aaa9GG1121221E", this);} // tgen
aaa::GG1121221 ::GG1121221(){ note_ctor("_ZN3aaa9GG1121221E", this);} // tgen
}
static void Test__ZN3aaa9GG1121221E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121221E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121221E, buf);
    ::aaa::GG1121221 *dp, &lv = *(dp=new (buf) ::aaa::GG1121221());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121221E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121221E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121221E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121221E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121221E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF122*), ABISELECT(32,20), "_ZN3aaa9GG1121221E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF122*), ABISELECT(48,28), "_ZN3aaa9GG1121221E");
    check_base_class_offset(lv, (::aaa::FF122*), ABISELECT(32,20), "_ZN3aaa9GG1121221E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121221E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121221E);
    dp->::aaa::GG1121221::~GG1121221();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121221E(Test__ZN3aaa9GG1121221E, "_ZN3aaa9GG1121221E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121221C1Ev();
extern void _ZN3aaa9GG1121221D1Ev();
Name_Map name_map__ZN3aaa9GG1121221E[] = {
  NSPAIR(_ZN3aaa9GG1121221C1Ev),
  NSPAIR(_ZN3aaa9GG1121221D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF122E;
extern VTBL_ENTRY _ZTIN3aaa5FF122E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF122E[];
static Base_Class bases__ZN3aaa9GG1121221E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF122E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121221E[];
extern void _ZN3aaa9GG11212213fooEv();
extern void _ZN3aaa5EE1123barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11212213fooEv,_ZThn8_N3aaa9GG11212213fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11212213fooEv,_ZThn20_N3aaa9GG11212213fooEv)();
extern void _ZN3aaa5FF1223barEv();
extern void ABISELECT(_ZThn16_N3aaa5FF1223barEv,_ZThn8_N3aaa5FF1223barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121221E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121221E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11212213fooEv,
  (VTBL_ENTRY)&_ZN3aaa5EE1123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121221E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11212213fooEv,_ZThn8_N3aaa9GG11212213fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121221E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11212213fooEv,_ZThn20_N3aaa9GG11212213fooEv),
  (VTBL_ENTRY)&_ZN3aaa5FF1223barEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121221E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF1223barEv,_ZThn8_N3aaa5FF1223barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121221E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121221E[];
Class_Descriptor cd__ZN3aaa9GG1121221E = {  "_ZN3aaa9GG1121221E", // class name
  bases__ZN3aaa9GG1121221E, 6,
  &(vtc__ZN3aaa9GG1121221E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121221E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121221E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121222  : ::aaa::EE112 , ::aaa::FF122 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11212223barEv
  ~GG1121222(); // tgen
  GG1121222(); // tgen
};
//SIG(1 _ZN3aaa9GG1121222E) C1{ BC2{ BC3{ v2 Fi} BC4{ v3 Fi} v1 Fi} BC5{ BC3 BC6{ v1 Fi} v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1121222 ::bar(){vfunc_called(this, "_ZN3aaa9GG11212223barEv");}
aaa::GG1121222 ::~GG1121222(){ note_dtor("_ZN3aaa9GG1121222E", this);} // tgen
aaa::GG1121222 ::GG1121222(){ note_ctor("_ZN3aaa9GG1121222E", this);} // tgen
}
static void Test__ZN3aaa9GG1121222E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121222E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121222E, buf);
    ::aaa::GG1121222 *dp, &lv = *(dp=new (buf) ::aaa::GG1121222());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121222E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121222E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121222E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121222E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121222E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF122*), ABISELECT(32,20), "_ZN3aaa9GG1121222E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF122*), ABISELECT(48,28), "_ZN3aaa9GG1121222E");
    check_base_class_offset(lv, (::aaa::FF122*), ABISELECT(32,20), "_ZN3aaa9GG1121222E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121222E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121222E);
    dp->::aaa::GG1121222::~GG1121222();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121222E(Test__ZN3aaa9GG1121222E, "_ZN3aaa9GG1121222E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121222C1Ev();
extern void _ZN3aaa9GG1121222D1Ev();
Name_Map name_map__ZN3aaa9GG1121222E[] = {
  NSPAIR(_ZN3aaa9GG1121222C1Ev),
  NSPAIR(_ZN3aaa9GG1121222D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF122E;
extern VTBL_ENTRY _ZTIN3aaa5FF122E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF122E[];
static Base_Class bases__ZN3aaa9GG1121222E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF122E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121222E[];
extern void _ZN3aaa3AA13fooEv();
extern void _ZN3aaa9GG11212223barEv();
extern void _ZN3aaa3BB13fooEv();
extern void _ZN3aaa3AA13fooEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11212223barEv,_ZThn20_N3aaa9GG11212223barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11212223barEv,_ZThn28_N3aaa9GG11212223barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121222E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121222E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA13fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11212223barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121222E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB13fooEv,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121222E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA13fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11212223barEv,_ZThn20_N3aaa9GG11212223barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121222E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11212223barEv,_ZThn28_N3aaa9GG11212223barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121222E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121222E[];
Class_Descriptor cd__ZN3aaa9GG1121222E = {  "_ZN3aaa9GG1121222E", // class name
  bases__ZN3aaa9GG1121222E, 6,
  &(vtc__ZN3aaa9GG1121222E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121222E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121222E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121223  : ::aaa::EE112 , ::aaa::FF122 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11212233fooEv
  virtual void  bar(); // _ZN3aaa9GG11212233barEv
  ~GG1121223(); // tgen
  GG1121223(); // tgen
};
//SIG(1 _ZN3aaa9GG1121223E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v2 Fi} BC5{ BC3 BC6{ v2 Fi} v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1121223 ::foo(){vfunc_called(this, "_ZN3aaa9GG11212233fooEv");}
void  aaa::GG1121223 ::bar(){vfunc_called(this, "_ZN3aaa9GG11212233barEv");}
aaa::GG1121223 ::~GG1121223(){ note_dtor("_ZN3aaa9GG1121223E", this);} // tgen
aaa::GG1121223 ::GG1121223(){ note_ctor("_ZN3aaa9GG1121223E", this);} // tgen
}
static void Test__ZN3aaa9GG1121223E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121223E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121223E, buf);
    ::aaa::GG1121223 *dp, &lv = *(dp=new (buf) ::aaa::GG1121223());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121223E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121223E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121223E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121223E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121223E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF122*), ABISELECT(32,20), "_ZN3aaa9GG1121223E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF122*), ABISELECT(48,28), "_ZN3aaa9GG1121223E");
    check_base_class_offset(lv, (::aaa::FF122*), ABISELECT(32,20), "_ZN3aaa9GG1121223E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121223E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121223E);
    dp->::aaa::GG1121223::~GG1121223();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121223E(Test__ZN3aaa9GG1121223E, "_ZN3aaa9GG1121223E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121223C1Ev();
extern void _ZN3aaa9GG1121223D1Ev();
Name_Map name_map__ZN3aaa9GG1121223E[] = {
  NSPAIR(_ZN3aaa9GG1121223C1Ev),
  NSPAIR(_ZN3aaa9GG1121223D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF122E;
extern VTBL_ENTRY _ZTIN3aaa5FF122E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF122E[];
static Base_Class bases__ZN3aaa9GG1121223E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF122E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121223E[];
extern void _ZN3aaa9GG11212233fooEv();
extern void _ZN3aaa9GG11212233barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11212233fooEv,_ZThn8_N3aaa9GG11212233fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11212233fooEv,_ZThn20_N3aaa9GG11212233fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11212233barEv,_ZThn20_N3aaa9GG11212233barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11212233barEv,_ZThn28_N3aaa9GG11212233barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121223E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121223E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11212233fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11212233barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121223E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11212233fooEv,_ZThn8_N3aaa9GG11212233fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121223E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11212233fooEv,_ZThn20_N3aaa9GG11212233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11212233barEv,_ZThn20_N3aaa9GG11212233barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121223E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11212233barEv,_ZThn28_N3aaa9GG11212233barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121223E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121223E[];
Class_Descriptor cd__ZN3aaa9GG1121223E = {  "_ZN3aaa9GG1121223E", // class name
  bases__ZN3aaa9GG1121223E, 6,
  &(vtc__ZN3aaa9GG1121223E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121223E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121223E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121231  : ::aaa::EE112 , ::aaa::FF123 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11212313fooEv
  ~GG1121231(); // tgen
  GG1121231(); // tgen
};
//SIG(1 _ZN3aaa9GG1121231E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v2 Fi} BC5{ BC3 BC6{ v3 Fi} v1 v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1121231 ::foo(){vfunc_called(this, "_ZN3aaa9GG11212313fooEv");}
aaa::GG1121231 ::~GG1121231(){ note_dtor("_ZN3aaa9GG1121231E", this);} // tgen
aaa::GG1121231 ::GG1121231(){ note_ctor("_ZN3aaa9GG1121231E", this);} // tgen
}
static void Test__ZN3aaa9GG1121231E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121231E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121231E, buf);
    ::aaa::GG1121231 *dp, &lv = *(dp=new (buf) ::aaa::GG1121231());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121231E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121231E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121231E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121231E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121231E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF123*), ABISELECT(32,20), "_ZN3aaa9GG1121231E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF123*), ABISELECT(48,28), "_ZN3aaa9GG1121231E");
    check_base_class_offset(lv, (::aaa::FF123*), ABISELECT(32,20), "_ZN3aaa9GG1121231E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121231E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121231E);
    dp->::aaa::GG1121231::~GG1121231();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121231E(Test__ZN3aaa9GG1121231E, "_ZN3aaa9GG1121231E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121231C1Ev();
extern void _ZN3aaa9GG1121231D1Ev();
Name_Map name_map__ZN3aaa9GG1121231E[] = {
  NSPAIR(_ZN3aaa9GG1121231C1Ev),
  NSPAIR(_ZN3aaa9GG1121231D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF123E;
extern VTBL_ENTRY _ZTIN3aaa5FF123E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF123E[];
static Base_Class bases__ZN3aaa9GG1121231E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF123E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121231E[];
extern void _ZN3aaa9GG11212313fooEv();
extern void _ZN3aaa5EE1123barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11212313fooEv,_ZThn8_N3aaa9GG11212313fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11212313fooEv,_ZThn20_N3aaa9GG11212313fooEv)();
extern void _ZN3aaa5FF1233barEv();
extern void ABISELECT(_ZThn16_N3aaa5FF1233barEv,_ZThn8_N3aaa5FF1233barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121231E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121231E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11212313fooEv,
  (VTBL_ENTRY)&_ZN3aaa5EE1123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121231E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11212313fooEv,_ZThn8_N3aaa9GG11212313fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121231E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11212313fooEv,_ZThn20_N3aaa9GG11212313fooEv),
  (VTBL_ENTRY)&_ZN3aaa5FF1233barEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121231E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF1233barEv,_ZThn8_N3aaa5FF1233barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121231E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121231E[];
Class_Descriptor cd__ZN3aaa9GG1121231E = {  "_ZN3aaa9GG1121231E", // class name
  bases__ZN3aaa9GG1121231E, 6,
  &(vtc__ZN3aaa9GG1121231E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121231E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121231E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121232  : ::aaa::EE112 , ::aaa::FF123 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11212323barEv
  ~GG1121232(); // tgen
  GG1121232(); // tgen
};
//SIG(1 _ZN3aaa9GG1121232E) C1{ BC2{ BC3{ v2 Fi} BC4{ v3 Fi} v1 Fi} BC5{ BC3 BC6{ v1 Fi} v4 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1121232 ::bar(){vfunc_called(this, "_ZN3aaa9GG11212323barEv");}
aaa::GG1121232 ::~GG1121232(){ note_dtor("_ZN3aaa9GG1121232E", this);} // tgen
aaa::GG1121232 ::GG1121232(){ note_ctor("_ZN3aaa9GG1121232E", this);} // tgen
}
static void Test__ZN3aaa9GG1121232E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121232E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121232E, buf);
    ::aaa::GG1121232 *dp, &lv = *(dp=new (buf) ::aaa::GG1121232());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121232E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121232E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121232E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121232E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121232E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF123*), ABISELECT(32,20), "_ZN3aaa9GG1121232E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF123*), ABISELECT(48,28), "_ZN3aaa9GG1121232E");
    check_base_class_offset(lv, (::aaa::FF123*), ABISELECT(32,20), "_ZN3aaa9GG1121232E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121232E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121232E);
    dp->::aaa::GG1121232::~GG1121232();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121232E(Test__ZN3aaa9GG1121232E, "_ZN3aaa9GG1121232E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121232C1Ev();
extern void _ZN3aaa9GG1121232D1Ev();
Name_Map name_map__ZN3aaa9GG1121232E[] = {
  NSPAIR(_ZN3aaa9GG1121232C1Ev),
  NSPAIR(_ZN3aaa9GG1121232D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF123E;
extern VTBL_ENTRY _ZTIN3aaa5FF123E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF123E[];
static Base_Class bases__ZN3aaa9GG1121232E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF123E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121232E[];
extern void _ZN3aaa3AA13fooEv();
extern void _ZN3aaa9GG11212323barEv();
extern void _ZN3aaa3BB13fooEv();
extern void _ZN3aaa5FF1233fooEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11212323barEv,_ZThn20_N3aaa9GG11212323barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11212323barEv,_ZThn28_N3aaa9GG11212323barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121232E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121232E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA13fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11212323barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121232E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB13fooEv,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121232E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF1233fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11212323barEv,_ZThn20_N3aaa9GG11212323barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121232E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11212323barEv,_ZThn28_N3aaa9GG11212323barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121232E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121232E[];
Class_Descriptor cd__ZN3aaa9GG1121232E = {  "_ZN3aaa9GG1121232E", // class name
  bases__ZN3aaa9GG1121232E, 6,
  &(vtc__ZN3aaa9GG1121232E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121232E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121232E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121233  : ::aaa::EE112 , ::aaa::FF123 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11212333fooEv
  virtual void  bar(); // _ZN3aaa9GG11212333barEv
  ~GG1121233(); // tgen
  GG1121233(); // tgen
};
//SIG(1 _ZN3aaa9GG1121233E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v2 Fi} BC5{ BC3 BC6{ v2 Fi} v1 v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1121233 ::foo(){vfunc_called(this, "_ZN3aaa9GG11212333fooEv");}
void  aaa::GG1121233 ::bar(){vfunc_called(this, "_ZN3aaa9GG11212333barEv");}
aaa::GG1121233 ::~GG1121233(){ note_dtor("_ZN3aaa9GG1121233E", this);} // tgen
aaa::GG1121233 ::GG1121233(){ note_ctor("_ZN3aaa9GG1121233E", this);} // tgen
}
static void Test__ZN3aaa9GG1121233E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121233E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121233E, buf);
    ::aaa::GG1121233 *dp, &lv = *(dp=new (buf) ::aaa::GG1121233());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121233E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121233E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121233E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121233E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121233E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF123*), ABISELECT(32,20), "_ZN3aaa9GG1121233E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF123*), ABISELECT(48,28), "_ZN3aaa9GG1121233E");
    check_base_class_offset(lv, (::aaa::FF123*), ABISELECT(32,20), "_ZN3aaa9GG1121233E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121233E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121233E);
    dp->::aaa::GG1121233::~GG1121233();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121233E(Test__ZN3aaa9GG1121233E, "_ZN3aaa9GG1121233E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121233C1Ev();
extern void _ZN3aaa9GG1121233D1Ev();
Name_Map name_map__ZN3aaa9GG1121233E[] = {
  NSPAIR(_ZN3aaa9GG1121233C1Ev),
  NSPAIR(_ZN3aaa9GG1121233D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB2E;
extern VTBL_ENTRY _ZTIN3aaa3BB2E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB2E[];
extern Class_Descriptor cd__ZN3aaa5FF123E;
extern VTBL_ENTRY _ZTIN3aaa5FF123E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF123E[];
static Base_Class bases__ZN3aaa9GG1121233E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB2E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF123E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121233E[];
extern void _ZN3aaa9GG11212333fooEv();
extern void _ZN3aaa9GG11212333barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11212333fooEv,_ZThn8_N3aaa9GG11212333fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11212333fooEv,_ZThn20_N3aaa9GG11212333fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11212333barEv,_ZThn20_N3aaa9GG11212333barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11212333barEv,_ZThn28_N3aaa9GG11212333barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121233E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121233E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11212333fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11212333barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121233E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11212333fooEv,_ZThn8_N3aaa9GG11212333fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121233E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11212333fooEv,_ZThn20_N3aaa9GG11212333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11212333barEv,_ZThn20_N3aaa9GG11212333barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121233E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11212333barEv,_ZThn28_N3aaa9GG11212333barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121233E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121233E[];
Class_Descriptor cd__ZN3aaa9GG1121233E = {  "_ZN3aaa9GG1121233E", // class name
  bases__ZN3aaa9GG1121233E, 6,
  &(vtc__ZN3aaa9GG1121233E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121233E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121233E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121311  : ::aaa::EE112 , ::aaa::FF131 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11213113fooEv
  ~GG1121311(); // tgen
  GG1121311(); // tgen
};
//SIG(1 _ZN3aaa9GG1121311E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v2 Fi} BC5{ BC3 BC6{ v1 v3 Fi} v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1121311 ::foo(){vfunc_called(this, "_ZN3aaa9GG11213113fooEv");}
aaa::GG1121311 ::~GG1121311(){ note_dtor("_ZN3aaa9GG1121311E", this);} // tgen
aaa::GG1121311 ::GG1121311(){ note_ctor("_ZN3aaa9GG1121311E", this);} // tgen
}
static void Test__ZN3aaa9GG1121311E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121311E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121311E, buf);
    ::aaa::GG1121311 *dp, &lv = *(dp=new (buf) ::aaa::GG1121311());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121311E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121311E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121311E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121311E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121311E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF131*), ABISELECT(32,20), "_ZN3aaa9GG1121311E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF131*), ABISELECT(48,28), "_ZN3aaa9GG1121311E");
    check_base_class_offset(lv, (::aaa::FF131*), ABISELECT(32,20), "_ZN3aaa9GG1121311E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121311E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121311E);
    dp->::aaa::GG1121311::~GG1121311();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121311E(Test__ZN3aaa9GG1121311E, "_ZN3aaa9GG1121311E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121311C1Ev();
extern void _ZN3aaa9GG1121311D1Ev();
Name_Map name_map__ZN3aaa9GG1121311E[] = {
  NSPAIR(_ZN3aaa9GG1121311C1Ev),
  NSPAIR(_ZN3aaa9GG1121311D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF131E;
extern VTBL_ENTRY _ZTIN3aaa5FF131E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF131E[];
static Base_Class bases__ZN3aaa9GG1121311E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF131E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121311E[];
extern void _ZN3aaa9GG11213113fooEv();
extern void _ZN3aaa5EE1123barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11213113fooEv,_ZThn8_N3aaa9GG11213113fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11213113fooEv,_ZThn20_N3aaa9GG11213113fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11213113fooEv,_ZThn28_N3aaa9GG11213113fooEv)();
extern void _ZN3aaa3BB33barEv();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121311E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121311E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11213113fooEv,
  (VTBL_ENTRY)&_ZN3aaa5EE1123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121311E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11213113fooEv,_ZThn8_N3aaa9GG11213113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121311E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11213113fooEv,_ZThn20_N3aaa9GG11213113fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121311E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11213113fooEv,_ZThn28_N3aaa9GG11213113fooEv),
  (VTBL_ENTRY)&_ZN3aaa3BB33barEv,
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121311E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121311E[];
Class_Descriptor cd__ZN3aaa9GG1121311E = {  "_ZN3aaa9GG1121311E", // class name
  bases__ZN3aaa9GG1121311E, 6,
  &(vtc__ZN3aaa9GG1121311E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121311E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121311E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121312  : ::aaa::EE112 , ::aaa::FF131 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11213123barEv
  ~GG1121312(); // tgen
  GG1121312(); // tgen
};
//SIG(1 _ZN3aaa9GG1121312E) C1{ BC2{ BC3{ v2 Fi} BC4{ v3 Fi} v1 Fi} BC5{ BC3 BC6{ v4 v1 Fi} v4 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1121312 ::bar(){vfunc_called(this, "_ZN3aaa9GG11213123barEv");}
aaa::GG1121312 ::~GG1121312(){ note_dtor("_ZN3aaa9GG1121312E", this);} // tgen
aaa::GG1121312 ::GG1121312(){ note_ctor("_ZN3aaa9GG1121312E", this);} // tgen
}
static void Test__ZN3aaa9GG1121312E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121312E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121312E, buf);
    ::aaa::GG1121312 *dp, &lv = *(dp=new (buf) ::aaa::GG1121312());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121312E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121312E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121312E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121312E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121312E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF131*), ABISELECT(32,20), "_ZN3aaa9GG1121312E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF131*), ABISELECT(48,28), "_ZN3aaa9GG1121312E");
    check_base_class_offset(lv, (::aaa::FF131*), ABISELECT(32,20), "_ZN3aaa9GG1121312E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121312E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121312E);
    dp->::aaa::GG1121312::~GG1121312();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121312E(Test__ZN3aaa9GG1121312E, "_ZN3aaa9GG1121312E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121312C1Ev();
extern void _ZN3aaa9GG1121312D1Ev();
Name_Map name_map__ZN3aaa9GG1121312E[] = {
  NSPAIR(_ZN3aaa9GG1121312C1Ev),
  NSPAIR(_ZN3aaa9GG1121312D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF131E;
extern VTBL_ENTRY _ZTIN3aaa5FF131E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF131E[];
static Base_Class bases__ZN3aaa9GG1121312E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF131E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121312E[];
extern void _ZN3aaa3AA13fooEv();
extern void _ZN3aaa9GG11213123barEv();
extern void _ZN3aaa3BB13fooEv();
extern void _ZN3aaa5FF1313fooEv();
extern void ABISELECT(_ZThn16_N3aaa5FF1313fooEv,_ZThn8_N3aaa5FF1313fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11213123barEv,_ZThn28_N3aaa9GG11213123barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121312E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121312E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA13fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11213123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121312E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB13fooEv,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121312E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF1313fooEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121312E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF1313fooEv,_ZThn8_N3aaa5FF1313fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11213123barEv,_ZThn28_N3aaa9GG11213123barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121312E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121312E[];
Class_Descriptor cd__ZN3aaa9GG1121312E = {  "_ZN3aaa9GG1121312E", // class name
  bases__ZN3aaa9GG1121312E, 6,
  &(vtc__ZN3aaa9GG1121312E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121312E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121312E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121313  : ::aaa::EE112 , ::aaa::FF131 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11213133fooEv
  virtual void  bar(); // _ZN3aaa9GG11213133barEv
  ~GG1121313(); // tgen
  GG1121313(); // tgen
};
//SIG(1 _ZN3aaa9GG1121313E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v2 Fi} BC5{ BC3 BC6{ v1 v2 Fi} v1 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1121313 ::foo(){vfunc_called(this, "_ZN3aaa9GG11213133fooEv");}
void  aaa::GG1121313 ::bar(){vfunc_called(this, "_ZN3aaa9GG11213133barEv");}
aaa::GG1121313 ::~GG1121313(){ note_dtor("_ZN3aaa9GG1121313E", this);} // tgen
aaa::GG1121313 ::GG1121313(){ note_ctor("_ZN3aaa9GG1121313E", this);} // tgen
}
static void Test__ZN3aaa9GG1121313E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121313E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121313E, buf);
    ::aaa::GG1121313 *dp, &lv = *(dp=new (buf) ::aaa::GG1121313());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121313E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121313E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121313E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121313E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121313E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF131*), ABISELECT(32,20), "_ZN3aaa9GG1121313E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF131*), ABISELECT(48,28), "_ZN3aaa9GG1121313E");
    check_base_class_offset(lv, (::aaa::FF131*), ABISELECT(32,20), "_ZN3aaa9GG1121313E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121313E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121313E);
    dp->::aaa::GG1121313::~GG1121313();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121313E(Test__ZN3aaa9GG1121313E, "_ZN3aaa9GG1121313E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121313C1Ev();
extern void _ZN3aaa9GG1121313D1Ev();
Name_Map name_map__ZN3aaa9GG1121313E[] = {
  NSPAIR(_ZN3aaa9GG1121313C1Ev),
  NSPAIR(_ZN3aaa9GG1121313D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF131E;
extern VTBL_ENTRY _ZTIN3aaa5FF131E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF131E[];
static Base_Class bases__ZN3aaa9GG1121313E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF131E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121313E[];
extern void _ZN3aaa9GG11213133fooEv();
extern void _ZN3aaa9GG11213133barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11213133fooEv,_ZThn8_N3aaa9GG11213133fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11213133fooEv,_ZThn20_N3aaa9GG11213133fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11213133fooEv,_ZThn28_N3aaa9GG11213133fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11213133barEv,_ZThn28_N3aaa9GG11213133barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121313E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121313E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11213133fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11213133barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121313E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11213133fooEv,_ZThn8_N3aaa9GG11213133fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121313E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11213133fooEv,_ZThn20_N3aaa9GG11213133fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121313E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11213133fooEv,_ZThn28_N3aaa9GG11213133fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11213133barEv,_ZThn28_N3aaa9GG11213133barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121313E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121313E[];
Class_Descriptor cd__ZN3aaa9GG1121313E = {  "_ZN3aaa9GG1121313E", // class name
  bases__ZN3aaa9GG1121313E, 6,
  &(vtc__ZN3aaa9GG1121313E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121313E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121313E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121321  : ::aaa::EE112 , ::aaa::FF132 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11213213fooEv
  ~GG1121321(); // tgen
  GG1121321(); // tgen
};
//SIG(1 _ZN3aaa9GG1121321E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v2 Fi} BC5{ BC3 BC6{ v1 v3 Fi} v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1121321 ::foo(){vfunc_called(this, "_ZN3aaa9GG11213213fooEv");}
aaa::GG1121321 ::~GG1121321(){ note_dtor("_ZN3aaa9GG1121321E", this);} // tgen
aaa::GG1121321 ::GG1121321(){ note_ctor("_ZN3aaa9GG1121321E", this);} // tgen
}
static void Test__ZN3aaa9GG1121321E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121321E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121321E, buf);
    ::aaa::GG1121321 *dp, &lv = *(dp=new (buf) ::aaa::GG1121321());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121321E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121321E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121321E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121321E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121321E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF132*), ABISELECT(32,20), "_ZN3aaa9GG1121321E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF132*), ABISELECT(48,28), "_ZN3aaa9GG1121321E");
    check_base_class_offset(lv, (::aaa::FF132*), ABISELECT(32,20), "_ZN3aaa9GG1121321E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121321E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121321E);
    dp->::aaa::GG1121321::~GG1121321();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121321E(Test__ZN3aaa9GG1121321E, "_ZN3aaa9GG1121321E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121321C1Ev();
extern void _ZN3aaa9GG1121321D1Ev();
Name_Map name_map__ZN3aaa9GG1121321E[] = {
  NSPAIR(_ZN3aaa9GG1121321C1Ev),
  NSPAIR(_ZN3aaa9GG1121321D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF132E;
extern VTBL_ENTRY _ZTIN3aaa5FF132E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF132E[];
static Base_Class bases__ZN3aaa9GG1121321E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF132E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121321E[];
extern void _ZN3aaa9GG11213213fooEv();
extern void _ZN3aaa5EE1123barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11213213fooEv,_ZThn8_N3aaa9GG11213213fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11213213fooEv,_ZThn20_N3aaa9GG11213213fooEv)();
extern void _ZN3aaa5FF1323barEv();
extern void ABISELECT(_ZThn48_N3aaa9GG11213213fooEv,_ZThn28_N3aaa9GG11213213fooEv)();
extern void ABISELECT(_ZThn16_N3aaa5FF1323barEv,_ZThn8_N3aaa5FF1323barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121321E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121321E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11213213fooEv,
  (VTBL_ENTRY)&_ZN3aaa5EE1123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121321E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11213213fooEv,_ZThn8_N3aaa9GG11213213fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121321E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11213213fooEv,_ZThn20_N3aaa9GG11213213fooEv),
  (VTBL_ENTRY)&_ZN3aaa5FF1323barEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121321E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11213213fooEv,_ZThn28_N3aaa9GG11213213fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF1323barEv,_ZThn8_N3aaa5FF1323barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121321E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121321E[];
Class_Descriptor cd__ZN3aaa9GG1121321E = {  "_ZN3aaa9GG1121321E", // class name
  bases__ZN3aaa9GG1121321E, 6,
  &(vtc__ZN3aaa9GG1121321E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121321E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121321E),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121322  : ::aaa::EE112 , ::aaa::FF132 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11213223barEv
  ~GG1121322(); // tgen
  GG1121322(); // tgen
};
//SIG(1 _ZN3aaa9GG1121322E) C1{ BC2{ BC3{ v2 Fi} BC4{ v3 Fi} v1 Fi} BC5{ BC3 BC6{ v4 v1 Fi} v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1121322 ::bar(){vfunc_called(this, "_ZN3aaa9GG11213223barEv");}
aaa::GG1121322 ::~GG1121322(){ note_dtor("_ZN3aaa9GG1121322E", this);} // tgen
aaa::GG1121322 ::GG1121322(){ note_ctor("_ZN3aaa9GG1121322E", this);} // tgen
}
static void Test__ZN3aaa9GG1121322E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121322E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121322E, buf);
    ::aaa::GG1121322 *dp, &lv = *(dp=new (buf) ::aaa::GG1121322());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121322E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121322E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121322E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121322E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121322E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF132*), ABISELECT(32,20), "_ZN3aaa9GG1121322E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF132*), ABISELECT(48,28), "_ZN3aaa9GG1121322E");
    check_base_class_offset(lv, (::aaa::FF132*), ABISELECT(32,20), "_ZN3aaa9GG1121322E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121322E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121322E);
    dp->::aaa::GG1121322::~GG1121322();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121322E(Test__ZN3aaa9GG1121322E, "_ZN3aaa9GG1121322E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121322C1Ev();
extern void _ZN3aaa9GG1121322D1Ev();
Name_Map name_map__ZN3aaa9GG1121322E[] = {
  NSPAIR(_ZN3aaa9GG1121322C1Ev),
  NSPAIR(_ZN3aaa9GG1121322D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF132E;
extern VTBL_ENTRY _ZTIN3aaa5FF132E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF132E[];
static Base_Class bases__ZN3aaa9GG1121322E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF132E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121322E[];
extern void _ZN3aaa3AA13fooEv();
extern void _ZN3aaa9GG11213223barEv();
extern void _ZN3aaa3BB13fooEv();
extern void _ZN3aaa3AA13fooEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11213223barEv,_ZThn20_N3aaa9GG11213223barEv)();
extern void _ZN3aaa3BB33fooEv();
extern void ABISELECT(_ZThn48_N3aaa9GG11213223barEv,_ZThn28_N3aaa9GG11213223barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121322E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121322E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA13fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11213223barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121322E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB13fooEv,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121322E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA13fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11213223barEv,_ZThn20_N3aaa9GG11213223barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121322E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB33fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11213223barEv,_ZThn28_N3aaa9GG11213223barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121322E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121322E[];
Class_Descriptor cd__ZN3aaa9GG1121322E = {  "_ZN3aaa9GG1121322E", // class name
  bases__ZN3aaa9GG1121322E, 6,
  &(vtc__ZN3aaa9GG1121322E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121322E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121322E),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121323  : ::aaa::EE112 , ::aaa::FF132 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11213233fooEv
  virtual void  bar(); // _ZN3aaa9GG11213233barEv
  ~GG1121323(); // tgen
  GG1121323(); // tgen
};
//SIG(1 _ZN3aaa9GG1121323E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v2 Fi} BC5{ BC3 BC6{ v1 v2 Fi} v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1121323 ::foo(){vfunc_called(this, "_ZN3aaa9GG11213233fooEv");}
void  aaa::GG1121323 ::bar(){vfunc_called(this, "_ZN3aaa9GG11213233barEv");}
aaa::GG1121323 ::~GG1121323(){ note_dtor("_ZN3aaa9GG1121323E", this);} // tgen
aaa::GG1121323 ::GG1121323(){ note_ctor("_ZN3aaa9GG1121323E", this);} // tgen
}
static void Test__ZN3aaa9GG1121323E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121323E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121323E, buf);
    ::aaa::GG1121323 *dp, &lv = *(dp=new (buf) ::aaa::GG1121323());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121323E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121323E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121323E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121323E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121323E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF132*), ABISELECT(32,20), "_ZN3aaa9GG1121323E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF132*), ABISELECT(48,28), "_ZN3aaa9GG1121323E");
    check_base_class_offset(lv, (::aaa::FF132*), ABISELECT(32,20), "_ZN3aaa9GG1121323E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121323E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121323E);
    dp->::aaa::GG1121323::~GG1121323();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121323E(Test__ZN3aaa9GG1121323E, "_ZN3aaa9GG1121323E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121323C1Ev();
extern void _ZN3aaa9GG1121323D1Ev();
Name_Map name_map__ZN3aaa9GG1121323E[] = {
  NSPAIR(_ZN3aaa9GG1121323C1Ev),
  NSPAIR(_ZN3aaa9GG1121323D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF132E;
extern VTBL_ENTRY _ZTIN3aaa5FF132E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF132E[];
static Base_Class bases__ZN3aaa9GG1121323E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF132E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121323E[];
extern void _ZN3aaa9GG11213233fooEv();
extern void _ZN3aaa9GG11213233barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11213233fooEv,_ZThn8_N3aaa9GG11213233fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11213233fooEv,_ZThn20_N3aaa9GG11213233fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11213233barEv,_ZThn20_N3aaa9GG11213233barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11213233fooEv,_ZThn28_N3aaa9GG11213233fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11213233barEv,_ZThn28_N3aaa9GG11213233barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121323E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121323E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11213233fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11213233barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121323E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11213233fooEv,_ZThn8_N3aaa9GG11213233fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121323E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11213233fooEv,_ZThn20_N3aaa9GG11213233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11213233barEv,_ZThn20_N3aaa9GG11213233barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121323E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11213233fooEv,_ZThn28_N3aaa9GG11213233fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11213233barEv,_ZThn28_N3aaa9GG11213233barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121323E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121323E[];
Class_Descriptor cd__ZN3aaa9GG1121323E = {  "_ZN3aaa9GG1121323E", // class name
  bases__ZN3aaa9GG1121323E, 6,
  &(vtc__ZN3aaa9GG1121323E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121323E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121323E),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121331  : ::aaa::EE112 , ::aaa::FF133 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11213313fooEv
  ~GG1121331(); // tgen
  GG1121331(); // tgen
};
//SIG(1 _ZN3aaa9GG1121331E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v2 Fi} BC5{ BC3 BC6{ v1 v3 Fi} v1 v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1121331 ::foo(){vfunc_called(this, "_ZN3aaa9GG11213313fooEv");}
aaa::GG1121331 ::~GG1121331(){ note_dtor("_ZN3aaa9GG1121331E", this);} // tgen
aaa::GG1121331 ::GG1121331(){ note_ctor("_ZN3aaa9GG1121331E", this);} // tgen
}
static void Test__ZN3aaa9GG1121331E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121331E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121331E, buf);
    ::aaa::GG1121331 *dp, &lv = *(dp=new (buf) ::aaa::GG1121331());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121331E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121331E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121331E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121331E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121331E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF133*), ABISELECT(32,20), "_ZN3aaa9GG1121331E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF133*), ABISELECT(48,28), "_ZN3aaa9GG1121331E");
    check_base_class_offset(lv, (::aaa::FF133*), ABISELECT(32,20), "_ZN3aaa9GG1121331E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121331E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121331E);
    dp->::aaa::GG1121331::~GG1121331();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121331E(Test__ZN3aaa9GG1121331E, "_ZN3aaa9GG1121331E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121331C1Ev();
extern void _ZN3aaa9GG1121331D1Ev();
Name_Map name_map__ZN3aaa9GG1121331E[] = {
  NSPAIR(_ZN3aaa9GG1121331C1Ev),
  NSPAIR(_ZN3aaa9GG1121331D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF133E;
extern VTBL_ENTRY _ZTIN3aaa5FF133E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF133E[];
static Base_Class bases__ZN3aaa9GG1121331E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF133E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121331E[];
extern void _ZN3aaa9GG11213313fooEv();
extern void _ZN3aaa5EE1123barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11213313fooEv,_ZThn8_N3aaa9GG11213313fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11213313fooEv,_ZThn20_N3aaa9GG11213313fooEv)();
extern void _ZN3aaa5FF1333barEv();
extern void ABISELECT(_ZThn48_N3aaa9GG11213313fooEv,_ZThn28_N3aaa9GG11213313fooEv)();
extern void ABISELECT(_ZThn16_N3aaa5FF1333barEv,_ZThn8_N3aaa5FF1333barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121331E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121331E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11213313fooEv,
  (VTBL_ENTRY)&_ZN3aaa5EE1123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121331E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11213313fooEv,_ZThn8_N3aaa9GG11213313fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121331E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11213313fooEv,_ZThn20_N3aaa9GG11213313fooEv),
  (VTBL_ENTRY)&_ZN3aaa5FF1333barEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121331E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11213313fooEv,_ZThn28_N3aaa9GG11213313fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF1333barEv,_ZThn8_N3aaa5FF1333barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121331E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121331E[];
Class_Descriptor cd__ZN3aaa9GG1121331E = {  "_ZN3aaa9GG1121331E", // class name
  bases__ZN3aaa9GG1121331E, 6,
  &(vtc__ZN3aaa9GG1121331E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121331E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121331E),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121332  : ::aaa::EE112 , ::aaa::FF133 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11213323barEv
  ~GG1121332(); // tgen
  GG1121332(); // tgen
};
//SIG(1 _ZN3aaa9GG1121332E) C1{ BC2{ BC3{ v2 Fi} BC4{ v3 Fi} v1 Fi} BC5{ BC3 BC6{ v4 v1 Fi} v4 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1121332 ::bar(){vfunc_called(this, "_ZN3aaa9GG11213323barEv");}
aaa::GG1121332 ::~GG1121332(){ note_dtor("_ZN3aaa9GG1121332E", this);} // tgen
aaa::GG1121332 ::GG1121332(){ note_ctor("_ZN3aaa9GG1121332E", this);} // tgen
}
static void Test__ZN3aaa9GG1121332E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121332E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121332E, buf);
    ::aaa::GG1121332 *dp, &lv = *(dp=new (buf) ::aaa::GG1121332());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121332E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121332E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121332E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121332E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121332E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF133*), ABISELECT(32,20), "_ZN3aaa9GG1121332E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF133*), ABISELECT(48,28), "_ZN3aaa9GG1121332E");
    check_base_class_offset(lv, (::aaa::FF133*), ABISELECT(32,20), "_ZN3aaa9GG1121332E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121332E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121332E);
    dp->::aaa::GG1121332::~GG1121332();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121332E(Test__ZN3aaa9GG1121332E, "_ZN3aaa9GG1121332E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121332C1Ev();
extern void _ZN3aaa9GG1121332D1Ev();
Name_Map name_map__ZN3aaa9GG1121332E[] = {
  NSPAIR(_ZN3aaa9GG1121332C1Ev),
  NSPAIR(_ZN3aaa9GG1121332D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF133E;
extern VTBL_ENTRY _ZTIN3aaa5FF133E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF133E[];
static Base_Class bases__ZN3aaa9GG1121332E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF133E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121332E[];
extern void _ZN3aaa3AA13fooEv();
extern void _ZN3aaa9GG11213323barEv();
extern void _ZN3aaa3BB13fooEv();
extern void _ZN3aaa5FF1333fooEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11213323barEv,_ZThn20_N3aaa9GG11213323barEv)();
extern void ABISELECT(_ZThn16_N3aaa5FF1333fooEv,_ZThn8_N3aaa5FF1333fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11213323barEv,_ZThn28_N3aaa9GG11213323barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121332E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121332E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA13fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11213323barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121332E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB13fooEv,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121332E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF1333fooEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11213323barEv,_ZThn20_N3aaa9GG11213323barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121332E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF1333fooEv,_ZThn8_N3aaa5FF1333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11213323barEv,_ZThn28_N3aaa9GG11213323barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121332E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121332E[];
Class_Descriptor cd__ZN3aaa9GG1121332E = {  "_ZN3aaa9GG1121332E", // class name
  bases__ZN3aaa9GG1121332E, 6,
  &(vtc__ZN3aaa9GG1121332E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121332E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121332E),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1121333  : ::aaa::EE112 , ::aaa::FF133 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11213333fooEv
  virtual void  bar(); // _ZN3aaa9GG11213333barEv
  ~GG1121333(); // tgen
  GG1121333(); // tgen
};
//SIG(1 _ZN3aaa9GG1121333E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v2 Fi} BC5{ BC3 BC6{ v1 v2 Fi} v1 v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1121333 ::foo(){vfunc_called(this, "_ZN3aaa9GG11213333fooEv");}
void  aaa::GG1121333 ::bar(){vfunc_called(this, "_ZN3aaa9GG11213333barEv");}
aaa::GG1121333 ::~GG1121333(){ note_dtor("_ZN3aaa9GG1121333E", this);} // tgen
aaa::GG1121333 ::GG1121333(){ note_ctor("_ZN3aaa9GG1121333E", this);} // tgen
}
static void Test__ZN3aaa9GG1121333E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1121333E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1121333E, buf);
    ::aaa::GG1121333 *dp, &lv = *(dp=new (buf) ::aaa::GG1121333());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1121333E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1121333E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1121333E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1121333E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1121333E");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::FF133*), ABISELECT(32,20), "_ZN3aaa9GG1121333E");
    check_base_class_offset(lv, (::aaa::BB3*)(::aaa::FF133*), ABISELECT(48,28), "_ZN3aaa9GG1121333E");
    check_base_class_offset(lv, (::aaa::FF133*), ABISELECT(32,20), "_ZN3aaa9GG1121333E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1121333E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1121333E);
    dp->::aaa::GG1121333::~GG1121333();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1121333E(Test__ZN3aaa9GG1121333E, "_ZN3aaa9GG1121333E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1121333C1Ev();
extern void _ZN3aaa9GG1121333D1Ev();
Name_Map name_map__ZN3aaa9GG1121333E[] = {
  NSPAIR(_ZN3aaa9GG1121333C1Ev),
  NSPAIR(_ZN3aaa9GG1121333D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB3E;
extern VTBL_ENTRY _ZTIN3aaa3BB3E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB3E[];
extern Class_Descriptor cd__ZN3aaa5FF133E;
extern VTBL_ENTRY _ZTIN3aaa5FF133E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF133E[];
static Base_Class bases__ZN3aaa9GG1121333E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA1E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB3E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF133E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1121333E[];
extern void _ZN3aaa9GG11213333fooEv();
extern void _ZN3aaa9GG11213333barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11213333fooEv,_ZThn8_N3aaa9GG11213333fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11213333fooEv,_ZThn20_N3aaa9GG11213333fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11213333barEv,_ZThn20_N3aaa9GG11213333barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11213333fooEv,_ZThn28_N3aaa9GG11213333fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11213333barEv,_ZThn28_N3aaa9GG11213333barEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1121333E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121333E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11213333fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11213333barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121333E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11213333fooEv,_ZThn8_N3aaa9GG11213333fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121333E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11213333fooEv,_ZThn20_N3aaa9GG11213333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11213333barEv,_ZThn20_N3aaa9GG11213333barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1121333E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11213333fooEv,_ZThn28_N3aaa9GG11213333fooEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11213333barEv,_ZThn28_N3aaa9GG11213333barEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1121333E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1121333E[];
Class_Descriptor cd__ZN3aaa9GG1121333E = {  "_ZN3aaa9GG1121333E", // class name
  bases__ZN3aaa9GG1121333E, 6,
  &(vtc__ZN3aaa9GG1121333E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1121333E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1121333E),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1122111  : ::aaa::EE112 , ::aaa::FF211 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11221113fooEv
  ~GG1122111(); // tgen
  GG1122111(); // tgen
};
//SIG(1 _ZN3aaa9GG1122111E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v2 Fi} BC5{ BC6{ v3 Fi} BC4 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1122111 ::foo(){vfunc_called(this, "_ZN3aaa9GG11221113fooEv");}
aaa::GG1122111 ::~GG1122111(){ note_dtor("_ZN3aaa9GG1122111E", this);} // tgen
aaa::GG1122111 ::GG1122111(){ note_ctor("_ZN3aaa9GG1122111E", this);} // tgen
}
static void Test__ZN3aaa9GG1122111E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1122111E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1122111E, buf);
    ::aaa::GG1122111 *dp, &lv = *(dp=new (buf) ::aaa::GG1122111());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1122111E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1122111E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1122111E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1122111E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1122111E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF211*), ABISELECT(32,20), "_ZN3aaa9GG1122111E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF211*), ABISELECT(48,28), "_ZN3aaa9GG1122111E");
    check_base_class_offset(lv, (::aaa::FF211*), ABISELECT(32,20), "_ZN3aaa9GG1122111E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1122111E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1122111E);
    dp->::aaa::GG1122111::~GG1122111();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1122111E(Test__ZN3aaa9GG1122111E, "_ZN3aaa9GG1122111E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1122111C1Ev();
extern void _ZN3aaa9GG1122111D1Ev();
Name_Map name_map__ZN3aaa9GG1122111E[] = {
  NSPAIR(_ZN3aaa9GG1122111C1Ev),
  NSPAIR(_ZN3aaa9GG1122111D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF211E;
extern VTBL_ENTRY _ZTIN3aaa5FF211E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF211E[];
static Base_Class bases__ZN3aaa9GG1122111E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF211E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1122111E[];
extern void _ZN3aaa9GG11221113fooEv();
extern void _ZN3aaa5EE1123barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11221113fooEv,_ZThn8_N3aaa9GG11221113fooEv)();
extern void _ZN3aaa3AA23barEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11221113fooEv,_ZThn20_N3aaa9GG11221113fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11221113fooEv,_ZThn28_N3aaa9GG11221113fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1122111E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122111E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11221113fooEv,
  (VTBL_ENTRY)&_ZN3aaa5EE1123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122111E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11221113fooEv,_ZThn8_N3aaa9GG11221113fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122111E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA23barEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11221113fooEv,_ZThn20_N3aaa9GG11221113fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122111E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11221113fooEv,_ZThn28_N3aaa9GG11221113fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1122111E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1122111E[];
Class_Descriptor cd__ZN3aaa9GG1122111E = {  "_ZN3aaa9GG1122111E", // class name
  bases__ZN3aaa9GG1122111E, 6,
  &(vtc__ZN3aaa9GG1122111E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1122111E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1122111E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1122112  : ::aaa::EE112 , ::aaa::FF211 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11221123barEv
  ~GG1122112(); // tgen
  GG1122112(); // tgen
};
//SIG(1 _ZN3aaa9GG1122112E) C1{ BC2{ BC3{ v2 Fi} BC4{ v3 Fi} v1 Fi} BC5{ BC6{ v1 Fi} BC4 v4 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1122112 ::bar(){vfunc_called(this, "_ZN3aaa9GG11221123barEv");}
aaa::GG1122112 ::~GG1122112(){ note_dtor("_ZN3aaa9GG1122112E", this);} // tgen
aaa::GG1122112 ::GG1122112(){ note_ctor("_ZN3aaa9GG1122112E", this);} // tgen
}
static void Test__ZN3aaa9GG1122112E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1122112E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1122112E, buf);
    ::aaa::GG1122112 *dp, &lv = *(dp=new (buf) ::aaa::GG1122112());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1122112E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1122112E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1122112E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1122112E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1122112E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF211*), ABISELECT(32,20), "_ZN3aaa9GG1122112E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF211*), ABISELECT(48,28), "_ZN3aaa9GG1122112E");
    check_base_class_offset(lv, (::aaa::FF211*), ABISELECT(32,20), "_ZN3aaa9GG1122112E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1122112E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1122112E);
    dp->::aaa::GG1122112::~GG1122112();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1122112E(Test__ZN3aaa9GG1122112E, "_ZN3aaa9GG1122112E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1122112C1Ev();
extern void _ZN3aaa9GG1122112D1Ev();
Name_Map name_map__ZN3aaa9GG1122112E[] = {
  NSPAIR(_ZN3aaa9GG1122112C1Ev),
  NSPAIR(_ZN3aaa9GG1122112D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF211E;
extern VTBL_ENTRY _ZTIN3aaa5FF211E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF211E[];
static Base_Class bases__ZN3aaa9GG1122112E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF211E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1122112E[];
extern void _ZN3aaa3AA13fooEv();
extern void _ZN3aaa9GG11221123barEv();
extern void _ZN3aaa3BB13fooEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11221123barEv,_ZThn20_N3aaa9GG11221123barEv)();
extern void _ZN3aaa5FF2113fooEv();
extern void ABISELECT(_ZThn16_N3aaa5FF2113fooEv,_ZThn8_N3aaa5FF2113fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1122112E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122112E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA13fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11221123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122112E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB13fooEv,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122112E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11221123barEv,_ZThn20_N3aaa9GG11221123barEv),
  (VTBL_ENTRY)&_ZN3aaa5FF2113fooEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122112E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF2113fooEv,_ZThn8_N3aaa5FF2113fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1122112E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1122112E[];
Class_Descriptor cd__ZN3aaa9GG1122112E = {  "_ZN3aaa9GG1122112E", // class name
  bases__ZN3aaa9GG1122112E, 6,
  &(vtc__ZN3aaa9GG1122112E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1122112E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1122112E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1122113  : ::aaa::EE112 , ::aaa::FF211 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11221133fooEv
  virtual void  bar(); // _ZN3aaa9GG11221133barEv
  ~GG1122113(); // tgen
  GG1122113(); // tgen
};
//SIG(1 _ZN3aaa9GG1122113E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v2 Fi} BC5{ BC6{ v2 Fi} BC4 v1 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1122113 ::foo(){vfunc_called(this, "_ZN3aaa9GG11221133fooEv");}
void  aaa::GG1122113 ::bar(){vfunc_called(this, "_ZN3aaa9GG11221133barEv");}
aaa::GG1122113 ::~GG1122113(){ note_dtor("_ZN3aaa9GG1122113E", this);} // tgen
aaa::GG1122113 ::GG1122113(){ note_ctor("_ZN3aaa9GG1122113E", this);} // tgen
}
static void Test__ZN3aaa9GG1122113E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1122113E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1122113E, buf);
    ::aaa::GG1122113 *dp, &lv = *(dp=new (buf) ::aaa::GG1122113());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1122113E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1122113E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1122113E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1122113E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1122113E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF211*), ABISELECT(32,20), "_ZN3aaa9GG1122113E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF211*), ABISELECT(48,28), "_ZN3aaa9GG1122113E");
    check_base_class_offset(lv, (::aaa::FF211*), ABISELECT(32,20), "_ZN3aaa9GG1122113E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1122113E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1122113E);
    dp->::aaa::GG1122113::~GG1122113();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1122113E(Test__ZN3aaa9GG1122113E, "_ZN3aaa9GG1122113E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1122113C1Ev();
extern void _ZN3aaa9GG1122113D1Ev();
Name_Map name_map__ZN3aaa9GG1122113E[] = {
  NSPAIR(_ZN3aaa9GG1122113C1Ev),
  NSPAIR(_ZN3aaa9GG1122113D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF211E;
extern VTBL_ENTRY _ZTIN3aaa5FF211E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF211E[];
static Base_Class bases__ZN3aaa9GG1122113E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF211E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1122113E[];
extern void _ZN3aaa9GG11221133fooEv();
extern void _ZN3aaa9GG11221133barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11221133fooEv,_ZThn8_N3aaa9GG11221133fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11221133barEv,_ZThn20_N3aaa9GG11221133barEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11221133fooEv,_ZThn20_N3aaa9GG11221133fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11221133fooEv,_ZThn28_N3aaa9GG11221133fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1122113E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122113E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11221133fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11221133barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122113E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11221133fooEv,_ZThn8_N3aaa9GG11221133fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122113E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11221133barEv,_ZThn20_N3aaa9GG11221133barEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11221133fooEv,_ZThn20_N3aaa9GG11221133fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122113E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11221133fooEv,_ZThn28_N3aaa9GG11221133fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1122113E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1122113E[];
Class_Descriptor cd__ZN3aaa9GG1122113E = {  "_ZN3aaa9GG1122113E", // class name
  bases__ZN3aaa9GG1122113E, 6,
  &(vtc__ZN3aaa9GG1122113E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1122113E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1122113E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1122121  : ::aaa::EE112 , ::aaa::FF212 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11221213fooEv
  ~GG1122121(); // tgen
  GG1122121(); // tgen
};
//SIG(1 _ZN3aaa9GG1122121E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v2 Fi} BC5{ BC6{ v3 Fi} BC4 v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1122121 ::foo(){vfunc_called(this, "_ZN3aaa9GG11221213fooEv");}
aaa::GG1122121 ::~GG1122121(){ note_dtor("_ZN3aaa9GG1122121E", this);} // tgen
aaa::GG1122121 ::GG1122121(){ note_ctor("_ZN3aaa9GG1122121E", this);} // tgen
}
static void Test__ZN3aaa9GG1122121E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1122121E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1122121E, buf);
    ::aaa::GG1122121 *dp, &lv = *(dp=new (buf) ::aaa::GG1122121());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1122121E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1122121E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1122121E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1122121E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1122121E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF212*), ABISELECT(32,20), "_ZN3aaa9GG1122121E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF212*), ABISELECT(48,28), "_ZN3aaa9GG1122121E");
    check_base_class_offset(lv, (::aaa::FF212*), ABISELECT(32,20), "_ZN3aaa9GG1122121E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1122121E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1122121E);
    dp->::aaa::GG1122121::~GG1122121();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1122121E(Test__ZN3aaa9GG1122121E, "_ZN3aaa9GG1122121E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1122121C1Ev();
extern void _ZN3aaa9GG1122121D1Ev();
Name_Map name_map__ZN3aaa9GG1122121E[] = {
  NSPAIR(_ZN3aaa9GG1122121C1Ev),
  NSPAIR(_ZN3aaa9GG1122121D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF212E;
extern VTBL_ENTRY _ZTIN3aaa5FF212E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF212E[];
static Base_Class bases__ZN3aaa9GG1122121E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF212E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1122121E[];
extern void _ZN3aaa9GG11221213fooEv();
extern void _ZN3aaa5EE1123barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11221213fooEv,_ZThn8_N3aaa9GG11221213fooEv)();
extern void _ZN3aaa5FF2123barEv();
extern void ABISELECT(_ZThn48_N3aaa9GG11221213fooEv,_ZThn28_N3aaa9GG11221213fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1122121E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122121E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11221213fooEv,
  (VTBL_ENTRY)&_ZN3aaa5EE1123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122121E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11221213fooEv,_ZThn8_N3aaa9GG11221213fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122121E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF2123barEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122121E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11221213fooEv,_ZThn28_N3aaa9GG11221213fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1122121E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1122121E[];
Class_Descriptor cd__ZN3aaa9GG1122121E = {  "_ZN3aaa9GG1122121E", // class name
  bases__ZN3aaa9GG1122121E, 6,
  &(vtc__ZN3aaa9GG1122121E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1122121E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1122121E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1122122  : ::aaa::EE112 , ::aaa::FF212 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11221223barEv
  ~GG1122122(); // tgen
  GG1122122(); // tgen
};
//SIG(1 _ZN3aaa9GG1122122E) C1{ BC2{ BC3{ v2 Fi} BC4{ v3 Fi} v1 Fi} BC5{ BC6{ v1 Fi} BC4 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1122122 ::bar(){vfunc_called(this, "_ZN3aaa9GG11221223barEv");}
aaa::GG1122122 ::~GG1122122(){ note_dtor("_ZN3aaa9GG1122122E", this);} // tgen
aaa::GG1122122 ::GG1122122(){ note_ctor("_ZN3aaa9GG1122122E", this);} // tgen
}
static void Test__ZN3aaa9GG1122122E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1122122E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1122122E, buf);
    ::aaa::GG1122122 *dp, &lv = *(dp=new (buf) ::aaa::GG1122122());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1122122E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1122122E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1122122E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1122122E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1122122E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF212*), ABISELECT(32,20), "_ZN3aaa9GG1122122E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF212*), ABISELECT(48,28), "_ZN3aaa9GG1122122E");
    check_base_class_offset(lv, (::aaa::FF212*), ABISELECT(32,20), "_ZN3aaa9GG1122122E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1122122E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1122122E);
    dp->::aaa::GG1122122::~GG1122122();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1122122E(Test__ZN3aaa9GG1122122E, "_ZN3aaa9GG1122122E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1122122C1Ev();
extern void _ZN3aaa9GG1122122D1Ev();
Name_Map name_map__ZN3aaa9GG1122122E[] = {
  NSPAIR(_ZN3aaa9GG1122122C1Ev),
  NSPAIR(_ZN3aaa9GG1122122D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF212E;
extern VTBL_ENTRY _ZTIN3aaa5FF212E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF212E[];
static Base_Class bases__ZN3aaa9GG1122122E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF212E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1122122E[];
extern void _ZN3aaa3AA13fooEv();
extern void _ZN3aaa9GG11221223barEv();
extern void _ZN3aaa3BB13fooEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11221223barEv,_ZThn20_N3aaa9GG11221223barEv)();
extern void _ZN3aaa3BB13fooEv();
static  VTBL_ENTRY vtc__ZN3aaa9GG1122122E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122122E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA13fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11221223barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122122E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB13fooEv,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122122E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11221223barEv,_ZThn20_N3aaa9GG11221223barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122122E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB13fooEv,
};
extern VTBL_ENTRY _ZTIN3aaa9GG1122122E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1122122E[];
Class_Descriptor cd__ZN3aaa9GG1122122E = {  "_ZN3aaa9GG1122122E", // class name
  bases__ZN3aaa9GG1122122E, 6,
  &(vtc__ZN3aaa9GG1122122E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1122122E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1122122E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1122123  : ::aaa::EE112 , ::aaa::FF212 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11221233fooEv
  virtual void  bar(); // _ZN3aaa9GG11221233barEv
  ~GG1122123(); // tgen
  GG1122123(); // tgen
};
//SIG(1 _ZN3aaa9GG1122123E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v2 Fi} BC5{ BC6{ v2 Fi} BC4 v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1122123 ::foo(){vfunc_called(this, "_ZN3aaa9GG11221233fooEv");}
void  aaa::GG1122123 ::bar(){vfunc_called(this, "_ZN3aaa9GG11221233barEv");}
aaa::GG1122123 ::~GG1122123(){ note_dtor("_ZN3aaa9GG1122123E", this);} // tgen
aaa::GG1122123 ::GG1122123(){ note_ctor("_ZN3aaa9GG1122123E", this);} // tgen
}
static void Test__ZN3aaa9GG1122123E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1122123E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1122123E, buf);
    ::aaa::GG1122123 *dp, &lv = *(dp=new (buf) ::aaa::GG1122123());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1122123E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1122123E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1122123E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1122123E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1122123E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF212*), ABISELECT(32,20), "_ZN3aaa9GG1122123E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF212*), ABISELECT(48,28), "_ZN3aaa9GG1122123E");
    check_base_class_offset(lv, (::aaa::FF212*), ABISELECT(32,20), "_ZN3aaa9GG1122123E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1122123E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1122123E);
    dp->::aaa::GG1122123::~GG1122123();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1122123E(Test__ZN3aaa9GG1122123E, "_ZN3aaa9GG1122123E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1122123C1Ev();
extern void _ZN3aaa9GG1122123D1Ev();
Name_Map name_map__ZN3aaa9GG1122123E[] = {
  NSPAIR(_ZN3aaa9GG1122123C1Ev),
  NSPAIR(_ZN3aaa9GG1122123D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF212E;
extern VTBL_ENTRY _ZTIN3aaa5FF212E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF212E[];
static Base_Class bases__ZN3aaa9GG1122123E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF212E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1122123E[];
extern void _ZN3aaa9GG11221233fooEv();
extern void _ZN3aaa9GG11221233barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11221233fooEv,_ZThn8_N3aaa9GG11221233fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11221233barEv,_ZThn20_N3aaa9GG11221233barEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11221233fooEv,_ZThn28_N3aaa9GG11221233fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1122123E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122123E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11221233fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11221233barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122123E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11221233fooEv,_ZThn8_N3aaa9GG11221233fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122123E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11221233barEv,_ZThn20_N3aaa9GG11221233barEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122123E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11221233fooEv,_ZThn28_N3aaa9GG11221233fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1122123E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1122123E[];
Class_Descriptor cd__ZN3aaa9GG1122123E = {  "_ZN3aaa9GG1122123E", // class name
  bases__ZN3aaa9GG1122123E, 6,
  &(vtc__ZN3aaa9GG1122123E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1122123E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1122123E),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1122131  : ::aaa::EE112 , ::aaa::FF213 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11221313fooEv
  ~GG1122131(); // tgen
  GG1122131(); // tgen
};
//SIG(1 _ZN3aaa9GG1122131E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v2 Fi} BC5{ BC6{ v3 Fi} BC4 v1 v3 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1122131 ::foo(){vfunc_called(this, "_ZN3aaa9GG11221313fooEv");}
aaa::GG1122131 ::~GG1122131(){ note_dtor("_ZN3aaa9GG1122131E", this);} // tgen
aaa::GG1122131 ::GG1122131(){ note_ctor("_ZN3aaa9GG1122131E", this);} // tgen
}
static void Test__ZN3aaa9GG1122131E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1122131E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1122131E, buf);
    ::aaa::GG1122131 *dp, &lv = *(dp=new (buf) ::aaa::GG1122131());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1122131E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1122131E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1122131E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1122131E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1122131E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF213*), ABISELECT(32,20), "_ZN3aaa9GG1122131E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF213*), ABISELECT(48,28), "_ZN3aaa9GG1122131E");
    check_base_class_offset(lv, (::aaa::FF213*), ABISELECT(32,20), "_ZN3aaa9GG1122131E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1122131E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1122131E);
    dp->::aaa::GG1122131::~GG1122131();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1122131E(Test__ZN3aaa9GG1122131E, "_ZN3aaa9GG1122131E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1122131C1Ev();
extern void _ZN3aaa9GG1122131D1Ev();
Name_Map name_map__ZN3aaa9GG1122131E[] = {
  NSPAIR(_ZN3aaa9GG1122131C1Ev),
  NSPAIR(_ZN3aaa9GG1122131D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF213E;
extern VTBL_ENTRY _ZTIN3aaa5FF213E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF213E[];
static Base_Class bases__ZN3aaa9GG1122131E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF213E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1122131E[];
extern void _ZN3aaa9GG11221313fooEv();
extern void _ZN3aaa5EE1123barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11221313fooEv,_ZThn8_N3aaa9GG11221313fooEv)();
extern void _ZN3aaa5FF2133barEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11221313fooEv,_ZThn20_N3aaa9GG11221313fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11221313fooEv,_ZThn28_N3aaa9GG11221313fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1122131E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122131E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11221313fooEv,
  (VTBL_ENTRY)&_ZN3aaa5EE1123barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122131E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11221313fooEv,_ZThn8_N3aaa9GG11221313fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122131E[0]),
  (VTBL_ENTRY)&_ZN3aaa5FF2133barEv,
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11221313fooEv,_ZThn20_N3aaa9GG11221313fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122131E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11221313fooEv,_ZThn28_N3aaa9GG11221313fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1122131E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1122131E[];
Class_Descriptor cd__ZN3aaa9GG1122131E = {  "_ZN3aaa9GG1122131E", // class name
  bases__ZN3aaa9GG1122131E, 6,
  &(vtc__ZN3aaa9GG1122131E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1122131E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1122131E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1122132  : ::aaa::EE112 , ::aaa::FF213 {
  int pg;
  virtual void  bar(); // _ZN3aaa9GG11221323barEv
  ~GG1122132(); // tgen
  GG1122132(); // tgen
};
//SIG(1 _ZN3aaa9GG1122132E) C1{ BC2{ BC3{ v2 Fi} BC4{ v3 Fi} v1 Fi} BC5{ BC6{ v1 Fi} BC4 v4 v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1122132 ::bar(){vfunc_called(this, "_ZN3aaa9GG11221323barEv");}
aaa::GG1122132 ::~GG1122132(){ note_dtor("_ZN3aaa9GG1122132E", this);} // tgen
aaa::GG1122132 ::GG1122132(){ note_ctor("_ZN3aaa9GG1122132E", this);} // tgen
}
static void Test__ZN3aaa9GG1122132E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1122132E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1122132E, buf);
    ::aaa::GG1122132 *dp, &lv = *(dp=new (buf) ::aaa::GG1122132());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1122132E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1122132E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1122132E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1122132E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1122132E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF213*), ABISELECT(32,20), "_ZN3aaa9GG1122132E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF213*), ABISELECT(48,28), "_ZN3aaa9GG1122132E");
    check_base_class_offset(lv, (::aaa::FF213*), ABISELECT(32,20), "_ZN3aaa9GG1122132E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1122132E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1122132E);
    dp->::aaa::GG1122132::~GG1122132();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1122132E(Test__ZN3aaa9GG1122132E, "_ZN3aaa9GG1122132E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1122132C1Ev();
extern void _ZN3aaa9GG1122132D1Ev();
Name_Map name_map__ZN3aaa9GG1122132E[] = {
  NSPAIR(_ZN3aaa9GG1122132C1Ev),
  NSPAIR(_ZN3aaa9GG1122132D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF213E;
extern VTBL_ENTRY _ZTIN3aaa5FF213E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF213E[];
static Base_Class bases__ZN3aaa9GG1122132E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF213E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1122132E[];
extern void _ZN3aaa3AA13fooEv();
extern void _ZN3aaa9GG11221323barEv();
extern void _ZN3aaa3BB13fooEv();
extern void ABISELECT(_ZThn32_N3aaa9GG11221323barEv,_ZThn20_N3aaa9GG11221323barEv)();
extern void _ZN3aaa5FF2133fooEv();
extern void ABISELECT(_ZThn16_N3aaa5FF2133fooEv,_ZThn8_N3aaa5FF2133fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1122132E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122132E[0]),
  (VTBL_ENTRY)&_ZN3aaa3AA13fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11221323barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122132E[0]),
  (VTBL_ENTRY)&_ZN3aaa3BB13fooEv,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122132E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11221323barEv,_ZThn20_N3aaa9GG11221323barEv),
  (VTBL_ENTRY)&_ZN3aaa5FF2133fooEv,
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122132E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa5FF2133fooEv,_ZThn8_N3aaa5FF2133fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1122132E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1122132E[];
Class_Descriptor cd__ZN3aaa9GG1122132E = {  "_ZN3aaa9GG1122132E", // class name
  bases__ZN3aaa9GG1122132E, 6,
  &(vtc__ZN3aaa9GG1122132E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1122132E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1122132E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1122133  : ::aaa::EE112 , ::aaa::FF213 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11221333fooEv
  virtual void  bar(); // _ZN3aaa9GG11221333barEv
  ~GG1122133(); // tgen
  GG1122133(); // tgen
};
//SIG(1 _ZN3aaa9GG1122133E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v2 Fi} BC5{ BC6{ v2 Fi} BC4 v1 v2 Fi} v1 v2 Fi}
}
namespace aaa { 
void  aaa::GG1122133 ::foo(){vfunc_called(this, "_ZN3aaa9GG11221333fooEv");}
void  aaa::GG1122133 ::bar(){vfunc_called(this, "_ZN3aaa9GG11221333barEv");}
aaa::GG1122133 ::~GG1122133(){ note_dtor("_ZN3aaa9GG1122133E", this);} // tgen
aaa::GG1122133 ::GG1122133(){ note_ctor("_ZN3aaa9GG1122133E", this);} // tgen
}
static void Test__ZN3aaa9GG1122133E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1122133E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1122133E, buf);
    ::aaa::GG1122133 *dp, &lv = *(dp=new (buf) ::aaa::GG1122133());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1122133E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1122133E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1122133E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1122133E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1122133E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF213*), ABISELECT(32,20), "_ZN3aaa9GG1122133E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::FF213*), ABISELECT(48,28), "_ZN3aaa9GG1122133E");
    check_base_class_offset(lv, (::aaa::FF213*), ABISELECT(32,20), "_ZN3aaa9GG1122133E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1122133E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1122133E);
    dp->::aaa::GG1122133::~GG1122133();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1122133E(Test__ZN3aaa9GG1122133E, "_ZN3aaa9GG1122133E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1122133C1Ev();
extern void _ZN3aaa9GG1122133D1Ev();
Name_Map name_map__ZN3aaa9GG1122133E[] = {
  NSPAIR(_ZN3aaa9GG1122133C1Ev),
  NSPAIR(_ZN3aaa9GG1122133D1Ev),
  {0,0}
};
extern Class_Descriptor cd__ZN3aaa3AA1E;
extern VTBL_ENTRY _ZTIN3aaa3AA1E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA1E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5EE112E;
extern VTBL_ENTRY _ZTIN3aaa5EE112E[];
extern  VTBL_ENTRY _ZTVN3aaa5EE112E[];
extern Class_Descriptor cd__ZN3aaa3AA2E;
extern VTBL_ENTRY _ZTIN3aaa3AA2E[];
extern  VTBL_ENTRY _ZTVN3aaa3AA2E[];
extern Class_Descriptor cd__ZN3aaa3BB1E;
extern VTBL_ENTRY _ZTIN3aaa3BB1E[];
extern  VTBL_ENTRY _ZTVN3aaa3BB1E[];
extern Class_Descriptor cd__ZN3aaa5FF213E;
extern VTBL_ENTRY _ZTIN3aaa5FF213E[];
extern  VTBL_ENTRY _ZTVN3aaa5FF213E[];
static Base_Class bases__ZN3aaa9GG1122133E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN3aaa3AA1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(16,8), //bcp->offset
    4, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5EE112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN3aaa3AA2E,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa3BB1E,    ABISELECT(48,28), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd__ZN3aaa5FF213E,    ABISELECT(32,20), //bcp->offset
    7, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTIN3aaa9GG1122133E[];
extern void _ZN3aaa9GG11221333fooEv();
extern void _ZN3aaa9GG11221333barEv();
extern void ABISELECT(_ZThn16_N3aaa9GG11221333fooEv,_ZThn8_N3aaa9GG11221333fooEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11221333barEv,_ZThn20_N3aaa9GG11221333barEv)();
extern void ABISELECT(_ZThn32_N3aaa9GG11221333fooEv,_ZThn20_N3aaa9GG11221333fooEv)();
extern void ABISELECT(_ZThn48_N3aaa9GG11221333fooEv,_ZThn28_N3aaa9GG11221333fooEv)();
static  VTBL_ENTRY vtc__ZN3aaa9GG1122133E[] = {
  0,
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122133E[0]),
  (VTBL_ENTRY)&_ZN3aaa9GG11221333fooEv,
  (VTBL_ENTRY)&_ZN3aaa9GG11221333barEv,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122133E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N3aaa9GG11221333fooEv,_ZThn8_N3aaa9GG11221333fooEv),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122133E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11221333barEv,_ZThn20_N3aaa9GG11221333barEv),
  (VTBL_ENTRY)&ABISELECT(_ZThn32_N3aaa9GG11221333fooEv,_ZThn20_N3aaa9GG11221333fooEv),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTIN3aaa9GG1122133E[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn48_N3aaa9GG11221333fooEv,_ZThn28_N3aaa9GG11221333fooEv),
};
extern VTBL_ENTRY _ZTIN3aaa9GG1122133E[];
extern  VTBL_ENTRY _ZTVN3aaa9GG1122133E[];
Class_Descriptor cd__ZN3aaa9GG1122133E = {  "_ZN3aaa9GG1122133E", // class name
  bases__ZN3aaa9GG1122133E, 6,
  &(vtc__ZN3aaa9GG1122133E[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTIN3aaa9GG1122133E),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTVN3aaa9GG1122133E),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaa { 
struct  GG1122211  : ::aaa::EE112 , ::aaa::FF221 {
  int pg;
  virtual void  foo(); // _ZN3aaa9GG11222113fooEv
  ~GG1122211(); // tgen
  GG1122211(); // tgen
};
//SIG(1 _ZN3aaa9GG1122211E) C1{ BC2{ BC3{ v1 Fi} BC4{ v1 Fi} v2 Fi} BC5{ BC6{ v3 Fi} BC7{ v4 Fi} v1 Fi} v1 Fi}
}
namespace aaa { 
void  aaa::GG1122211 ::foo(){vfunc_called(this, "_ZN3aaa9GG11222113fooEv");}
aaa::GG1122211 ::~GG1122211(){ note_dtor("_ZN3aaa9GG1122211E", this);} // tgen
aaa::GG1122211 ::GG1122211(){ note_ctor("_ZN3aaa9GG1122211E", this);} // tgen
}
static void Test__ZN3aaa9GG1122211E()
{
  extern Class_Descriptor cd__ZN3aaa9GG1122211E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd__ZN3aaa9GG1122211E, buf);
    ::aaa::GG1122211 *dp, &lv = *(dp=new (buf) ::aaa::GG1122211());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(_ZN3aaa9GG1122211E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN3aaa9GG1122211E)");
    check_base_class_offset(lv, (::aaa::AA1*)(::aaa::EE112*), 0, "_ZN3aaa9GG1122211E");
    check_base_class_offset(lv, (::aaa::BB1*)(::aaa::EE112*), ABISELECT(16,8), "_ZN3aaa9GG1122211E");
    check_base_class_offset(lv, (::aaa::EE112*), 0, "_ZN3aaa9GG1122211E");
    check_base_class_offset(lv, (::aaa::AA2*)(::aaa::FF221*), ABISELECT(32,20), "_ZN3aaa9GG1122211E");
    check_base_class_offset(lv, (::aaa::BB2*)(::aaa::FF221*), ABISELECT(48,28), "_ZN3aaa9GG1122211E");
    check_base_class_offset(lv, (::aaa::FF221*), ABISELECT(32,20), "_ZN3aaa9GG1122211E");
    check_field_offset(lv, pg, ABISELECT(64,40), "_ZN3aaa9GG1122211E.pg");
    test_class_info(&lv, &cd__ZN3aaa9GG1122211E);
    dp->::aaa::GG1122211::~GG1122211();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN3aaa9GG1122211E(Test__ZN3aaa9GG1122211E, "_ZN3aaa9GG1122211E", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN3aaa9GG1122211C1Ev();
extern void _ZN3aaa9GG