// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus
namespace bbbb { 
struct  ww0  {
};
//SIG(-1 _ZN4bbbb3ww0E) C1{}
}
namespace bbbb { 
}
static void Test__ZN4bbbb3ww0E()
{
  {
    init_simple_test("_ZN4bbbb3ww0E");
    ::bbbb::ww0 lv;
    check2(sizeof(lv), 1, "sizeof(_ZN4bbbb3ww0E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb3ww0E)");
  }
}
static Arrange_To_Call_Me v_ZN4bbbb3ww0E(Test__ZN4bbbb3ww0E, "_ZN4bbbb3ww0E", 1);

#else // __cplusplus

Class_Descriptor cd__ZN4bbbb3ww0E = {  "_ZN4bbbb3ww0E", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  xx00  : ::bbbb::ww0 {
};
//SIG(-1 _ZN4bbbb4xx00E) C1{ BC2{}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb4xx00E()
{
  extern Class_Descriptor cd__ZN4bbbb4xx00E;
  void *lvp;
  {
    char buf[1];
    init_test(&cd__ZN4bbbb4xx00E, buf);
    ::bbbb::xx00 &lv = *(new (buf) ::bbbb::xx00());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(_ZN4bbbb4xx00E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb4xx00E)");
    check_base_class_offset(lv, (::bbbb::ww0*), 0, "_ZN4bbbb4xx00E");
    test_class_info(&lv, &cd__ZN4bbbb4xx00E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb4xx00E(Test__ZN4bbbb4xx00E, "_ZN4bbbb4xx00E", 1);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
static Base_Class bases__ZN4bbbb4xx00E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb4xx00E = {  "_ZN4bbbb4xx00E", // class name
  bases__ZN4bbbb4xx00E, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy000  : ::bbbb::xx00 {
};
//SIG(-1 _ZN4bbbb5yy000E) C1{ BC2{ BC3{}}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy000E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy000E;
  void *lvp;
  {
    char buf[1];
    init_test(&cd__ZN4bbbb5yy000E, buf);
    ::bbbb::yy000 &lv = *(new (buf) ::bbbb::yy000());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(_ZN4bbbb5yy000E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb5yy000E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*), 0, "_ZN4bbbb5yy000E");
    check_base_class_offset(lv, (::bbbb::xx00*), 0, "_ZN4bbbb5yy000E");
    test_class_info(&lv, &cd__ZN4bbbb5yy000E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy000E(Test__ZN4bbbb5yy000E, "_ZN4bbbb5yy000E", 1);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
static Base_Class bases__ZN4bbbb5yy000E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy000E = {  "_ZN4bbbb5yy000E", // class name
  bases__ZN4bbbb5yy000E, 2,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0000  : ::bbbb::yy000 {
};
//SIG(1 _ZN4bbbb6zz0000E) C1{ BC2{ BC3{ BC4{}}}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0000E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0000E;
  void *lvp;
  {
    char buf[1];
    init_test(&cd__ZN4bbbb6zz0000E, buf);
    ::bbbb::zz0000 &lv = *(new (buf) ::bbbb::zz0000());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(_ZN4bbbb6zz0000E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb6zz0000E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*)(::bbbb::yy000*), 0, "_ZN4bbbb6zz0000E");
    check_base_class_offset(lv, (::bbbb::xx00*)(::bbbb::yy000*), 0, "_ZN4bbbb6zz0000E");
    check_base_class_offset(lv, (::bbbb::yy000*), 0, "_ZN4bbbb6zz0000E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0000E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0000E(Test__ZN4bbbb6zz0000E, "_ZN4bbbb6zz0000E", 1);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
extern Class_Descriptor cd__ZN4bbbb5yy000E;
static Base_Class bases__ZN4bbbb6zz0000E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy000E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0000E = {  "_ZN4bbbb6zz0000E", // class name
  bases__ZN4bbbb6zz0000E, 3,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1000  : ::bbbb::yy000 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1000E) C1{ BC2{ BC3{ BC4{}}} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1000E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1000E;
  void *lvp;
  {
    char buf[1];
    init_test(&cd__ZN4bbbb6zz1000E, buf);
    ::bbbb::zz1000 &lv = *(new (buf) ::bbbb::zz1000());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(_ZN4bbbb6zz1000E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb6zz1000E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*)(::bbbb::yy000*), 0, "_ZN4bbbb6zz1000E");
    check_base_class_offset(lv, (::bbbb::xx00*)(::bbbb::yy000*), 0, "_ZN4bbbb6zz1000E");
    check_base_class_offset(lv, (::bbbb::yy000*), 0, "_ZN4bbbb6zz1000E");
    check_field_offset(lv, fd, 0, "_ZN4bbbb6zz1000E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1000E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1000E(Test__ZN4bbbb6zz1000E, "_ZN4bbbb6zz1000E", 1);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
extern Class_Descriptor cd__ZN4bbbb5yy000E;
static Base_Class bases__ZN4bbbb6zz1000E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy000E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1000E = {  "_ZN4bbbb6zz1000E", // class name
  bases__ZN4bbbb6zz1000E, 3,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2000  : ::bbbb::yy000 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2000E) C1{ BC2{ BC3{ BC4{}}} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2000E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2000E;
  void *lvp;
  {
    short buf[2];
    init_test(&cd__ZN4bbbb6zz2000E, buf);
    ::bbbb::zz2000 &lv = *(new (buf) ::bbbb::zz2000());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4bbbb6zz2000E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz2000E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*)(::bbbb::yy000*), 0, "_ZN4bbbb6zz2000E");
    check_base_class_offset(lv, (::bbbb::xx00*)(::bbbb::yy000*), 0, "_ZN4bbbb6zz2000E");
    check_base_class_offset(lv, (::bbbb::yy000*), 0, "_ZN4bbbb6zz2000E");
    check_field_offset(lv, fd, 0, "_ZN4bbbb6zz2000E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2000E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2000E(Test__ZN4bbbb6zz2000E, "_ZN4bbbb6zz2000E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
extern Class_Descriptor cd__ZN4bbbb5yy000E;
static Base_Class bases__ZN4bbbb6zz2000E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy000E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2000E = {  "_ZN4bbbb6zz2000E", // class name
  bases__ZN4bbbb6zz2000E, 3,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3000  : ::bbbb::yy000 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3000E) C1{ BC2{ BC3{ BC4{}}} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3000E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3000E;
  void *lvp;
  {
    int buf[2];
    init_test(&cd__ZN4bbbb6zz3000E, buf);
    ::bbbb::zz3000 &lv = *(new (buf) ::bbbb::zz3000());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz3000E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3000E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*)(::bbbb::yy000*), 0, "_ZN4bbbb6zz3000E");
    check_base_class_offset(lv, (::bbbb::xx00*)(::bbbb::yy000*), 0, "_ZN4bbbb6zz3000E");
    check_base_class_offset(lv, (::bbbb::yy000*), 0, "_ZN4bbbb6zz3000E");
    check_field_offset(lv, fd, 0, "_ZN4bbbb6zz3000E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3000E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3000E(Test__ZN4bbbb6zz3000E, "_ZN4bbbb6zz3000E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
extern Class_Descriptor cd__ZN4bbbb5yy000E;
static Base_Class bases__ZN4bbbb6zz3000E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy000E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3000E = {  "_ZN4bbbb6zz3000E", // class name
  bases__ZN4bbbb6zz3000E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4000  : ::bbbb::yy000 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4000E) C1{ BC2{ BC3{ BC4{}}} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4000E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4000E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(2,3)];
    init_test(&cd__ZN4bbbb6zz4000E, buf);
    ::bbbb::zz4000 &lv = *(new (buf) ::bbbb::zz4000());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz4000E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4000E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*)(::bbbb::yy000*), 0, "_ZN4bbbb6zz4000E");
    check_base_class_offset(lv, (::bbbb::xx00*)(::bbbb::yy000*), 0, "_ZN4bbbb6zz4000E");
    check_base_class_offset(lv, (::bbbb::yy000*), 0, "_ZN4bbbb6zz4000E");
    check_field_offset(lv, fd, 0, "_ZN4bbbb6zz4000E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4000E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4000E(Test__ZN4bbbb6zz4000E, "_ZN4bbbb6zz4000E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
extern Class_Descriptor cd__ZN4bbbb5yy000E;
static Base_Class bases__ZN4bbbb6zz4000E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy000E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4000E = {  "_ZN4bbbb6zz4000E", // class name
  bases__ZN4bbbb6zz4000E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy100  : ::bbbb::xx00 {
  char fc;
};
//SIG(-1 _ZN4bbbb5yy100E) C1{ BC2{ BC3{}} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy100E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy100E;
  void *lvp;
  {
    char buf[1];
    init_test(&cd__ZN4bbbb5yy100E, buf);
    ::bbbb::yy100 &lv = *(new (buf) ::bbbb::yy100());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(_ZN4bbbb5yy100E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb5yy100E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*), 0, "_ZN4bbbb5yy100E");
    check_base_class_offset(lv, (::bbbb::xx00*), 0, "_ZN4bbbb5yy100E");
    check_field_offset(lv, fc, 0, "_ZN4bbbb5yy100E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy100E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy100E(Test__ZN4bbbb5yy100E, "_ZN4bbbb5yy100E", 1);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
static Base_Class bases__ZN4bbbb5yy100E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy100E = {  "_ZN4bbbb5yy100E", // class name
  bases__ZN4bbbb5yy100E, 2,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0100  : ::bbbb::yy100 {
};
//SIG(1 _ZN4bbbb6zz0100E) C1{ BC2{ BC3{ BC4{}} Fc}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0100E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0100E;
  void *lvp;
  {
    char buf[1];
    init_test(&cd__ZN4bbbb6zz0100E, buf);
    ::bbbb::zz0100 &lv = *(new (buf) ::bbbb::zz0100());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(_ZN4bbbb6zz0100E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb6zz0100E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*)(::bbbb::yy100*), 0, "_ZN4bbbb6zz0100E");
    check_base_class_offset(lv, (::bbbb::xx00*)(::bbbb::yy100*), 0, "_ZN4bbbb6zz0100E");
    check_base_class_offset(lv, (::bbbb::yy100*), 0, "_ZN4bbbb6zz0100E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0100E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0100E(Test__ZN4bbbb6zz0100E, "_ZN4bbbb6zz0100E", 1);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
extern Class_Descriptor cd__ZN4bbbb5yy100E;
static Base_Class bases__ZN4bbbb6zz0100E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy100E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0100E = {  "_ZN4bbbb6zz0100E", // class name
  bases__ZN4bbbb6zz0100E, 3,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1100  : ::bbbb::yy100 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1100E) C1{ BC2{ BC3{ BC4{}} Fc} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1100E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1100E;
  void *lvp;
  {
    char buf[2];
    init_test(&cd__ZN4bbbb6zz1100E, buf);
    ::bbbb::zz1100 &lv = *(new (buf) ::bbbb::zz1100());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4bbbb6zz1100E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb6zz1100E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*)(::bbbb::yy100*), 0, "_ZN4bbbb6zz1100E");
    check_base_class_offset(lv, (::bbbb::xx00*)(::bbbb::yy100*), 0, "_ZN4bbbb6zz1100E");
    check_base_class_offset(lv, (::bbbb::yy100*), 0, "_ZN4bbbb6zz1100E");
    check_field_offset(lv, fd, 1, "_ZN4bbbb6zz1100E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1100E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1100E(Test__ZN4bbbb6zz1100E, "_ZN4bbbb6zz1100E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
extern Class_Descriptor cd__ZN4bbbb5yy100E;
static Base_Class bases__ZN4bbbb6zz1100E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy100E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1100E = {  "_ZN4bbbb6zz1100E", // class name
  bases__ZN4bbbb6zz1100E, 3,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2100  : ::bbbb::yy100 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2100E) C1{ BC2{ BC3{ BC4{}} Fc} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2100E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2100E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb6zz2100E, buf);
    ::bbbb::zz2100 &lv = *(new (buf) ::bbbb::zz2100());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz2100E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz2100E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*)(::bbbb::yy100*), 0, "_ZN4bbbb6zz2100E");
    check_base_class_offset(lv, (::bbbb::xx00*)(::bbbb::yy100*), 0, "_ZN4bbbb6zz2100E");
    check_base_class_offset(lv, (::bbbb::yy100*), 0, "_ZN4bbbb6zz2100E");
    check_field_offset(lv, fd, 2, "_ZN4bbbb6zz2100E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2100E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2100E(Test__ZN4bbbb6zz2100E, "_ZN4bbbb6zz2100E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
extern Class_Descriptor cd__ZN4bbbb5yy100E;
static Base_Class bases__ZN4bbbb6zz2100E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy100E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2100E = {  "_ZN4bbbb6zz2100E", // class name
  bases__ZN4bbbb6zz2100E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3100  : ::bbbb::yy100 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3100E) C1{ BC2{ BC3{ BC4{}} Fc} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3100E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3100E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz3100E, buf);
    ::bbbb::zz3100 &lv = *(new (buf) ::bbbb::zz3100());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz3100E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3100E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*)(::bbbb::yy100*), 0, "_ZN4bbbb6zz3100E");
    check_base_class_offset(lv, (::bbbb::xx00*)(::bbbb::yy100*), 0, "_ZN4bbbb6zz3100E");
    check_base_class_offset(lv, (::bbbb::yy100*), 0, "_ZN4bbbb6zz3100E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz3100E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3100E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3100E(Test__ZN4bbbb6zz3100E, "_ZN4bbbb6zz3100E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
extern Class_Descriptor cd__ZN4bbbb5yy100E;
static Base_Class bases__ZN4bbbb6zz3100E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy100E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3100E = {  "_ZN4bbbb6zz3100E", // class name
  bases__ZN4bbbb6zz3100E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4100  : ::bbbb::yy100 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4100E) C1{ BC2{ BC3{ BC4{}} Fc} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4100E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4100E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz4100E, buf);
    ::bbbb::zz4100 &lv = *(new (buf) ::bbbb::zz4100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz4100E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4100E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*)(::bbbb::yy100*), 0, "_ZN4bbbb6zz4100E");
    check_base_class_offset(lv, (::bbbb::xx00*)(::bbbb::yy100*), 0, "_ZN4bbbb6zz4100E");
    check_base_class_offset(lv, (::bbbb::yy100*), 0, "_ZN4bbbb6zz4100E");
    check_field_offset(lv, fd, ABISELECT(8,4), "_ZN4bbbb6zz4100E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4100E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4100E(Test__ZN4bbbb6zz4100E, "_ZN4bbbb6zz4100E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
extern Class_Descriptor cd__ZN4bbbb5yy100E;
static Base_Class bases__ZN4bbbb6zz4100E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy100E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4100E = {  "_ZN4bbbb6zz4100E", // class name
  bases__ZN4bbbb6zz4100E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy200  : ::bbbb::xx00 {
  short fc;
};
//SIG(-1 _ZN4bbbb5yy200E) C1{ BC2{ BC3{}} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy200E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy200E;
  void *lvp;
  {
    short buf[2];
    init_test(&cd__ZN4bbbb5yy200E, buf);
    ::bbbb::yy200 &lv = *(new (buf) ::bbbb::yy200());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4bbbb5yy200E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb5yy200E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*), 0, "_ZN4bbbb5yy200E");
    check_base_class_offset(lv, (::bbbb::xx00*), 0, "_ZN4bbbb5yy200E");
    check_field_offset(lv, fc, 0, "_ZN4bbbb5yy200E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy200E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy200E(Test__ZN4bbbb5yy200E, "_ZN4bbbb5yy200E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
static Base_Class bases__ZN4bbbb5yy200E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy200E = {  "_ZN4bbbb5yy200E", // class name
  bases__ZN4bbbb5yy200E, 2,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0200  : ::bbbb::yy200 {
};
//SIG(1 _ZN4bbbb6zz0200E) C1{ BC2{ BC3{ BC4{}} Fs}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0200E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0200E;
  void *lvp;
  {
    short buf[2];
    init_test(&cd__ZN4bbbb6zz0200E, buf);
    ::bbbb::zz0200 &lv = *(new (buf) ::bbbb::zz0200());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4bbbb6zz0200E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz0200E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*)(::bbbb::yy200*), 0, "_ZN4bbbb6zz0200E");
    check_base_class_offset(lv, (::bbbb::xx00*)(::bbbb::yy200*), 0, "_ZN4bbbb6zz0200E");
    check_base_class_offset(lv, (::bbbb::yy200*), 0, "_ZN4bbbb6zz0200E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0200E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0200E(Test__ZN4bbbb6zz0200E, "_ZN4bbbb6zz0200E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
extern Class_Descriptor cd__ZN4bbbb5yy200E;
static Base_Class bases__ZN4bbbb6zz0200E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy200E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0200E = {  "_ZN4bbbb6zz0200E", // class name
  bases__ZN4bbbb6zz0200E, 3,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1200  : ::bbbb::yy200 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1200E) C1{ BC2{ BC3{ BC4{}} Fs} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1200E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1200E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb6zz1200E, buf);
    ::bbbb::zz1200 &lv = *(new (buf) ::bbbb::zz1200());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz1200E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz1200E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*)(::bbbb::yy200*), 0, "_ZN4bbbb6zz1200E");
    check_base_class_offset(lv, (::bbbb::xx00*)(::bbbb::yy200*), 0, "_ZN4bbbb6zz1200E");
    check_base_class_offset(lv, (::bbbb::yy200*), 0, "_ZN4bbbb6zz1200E");
    check_field_offset(lv, fd, 2, "_ZN4bbbb6zz1200E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1200E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1200E(Test__ZN4bbbb6zz1200E, "_ZN4bbbb6zz1200E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
extern Class_Descriptor cd__ZN4bbbb5yy200E;
static Base_Class bases__ZN4bbbb6zz1200E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy200E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1200E = {  "_ZN4bbbb6zz1200E", // class name
  bases__ZN4bbbb6zz1200E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2200  : ::bbbb::yy200 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2200E) C1{ BC2{ BC3{ BC4{}} Fs} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2200E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2200E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb6zz2200E, buf);
    ::bbbb::zz2200 &lv = *(new (buf) ::bbbb::zz2200());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz2200E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz2200E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*)(::bbbb::yy200*), 0, "_ZN4bbbb6zz2200E");
    check_base_class_offset(lv, (::bbbb::xx00*)(::bbbb::yy200*), 0, "_ZN4bbbb6zz2200E");
    check_base_class_offset(lv, (::bbbb::yy200*), 0, "_ZN4bbbb6zz2200E");
    check_field_offset(lv, fd, 2, "_ZN4bbbb6zz2200E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2200E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2200E(Test__ZN4bbbb6zz2200E, "_ZN4bbbb6zz2200E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
extern Class_Descriptor cd__ZN4bbbb5yy200E;
static Base_Class bases__ZN4bbbb6zz2200E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy200E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2200E = {  "_ZN4bbbb6zz2200E", // class name
  bases__ZN4bbbb6zz2200E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3200  : ::bbbb::yy200 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3200E) C1{ BC2{ BC3{ BC4{}} Fs} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3200E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3200E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz3200E, buf);
    ::bbbb::zz3200 &lv = *(new (buf) ::bbbb::zz3200());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz3200E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3200E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*)(::bbbb::yy200*), 0, "_ZN4bbbb6zz3200E");
    check_base_class_offset(lv, (::bbbb::xx00*)(::bbbb::yy200*), 0, "_ZN4bbbb6zz3200E");
    check_base_class_offset(lv, (::bbbb::yy200*), 0, "_ZN4bbbb6zz3200E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz3200E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3200E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3200E(Test__ZN4bbbb6zz3200E, "_ZN4bbbb6zz3200E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
extern Class_Descriptor cd__ZN4bbbb5yy200E;
static Base_Class bases__ZN4bbbb6zz3200E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy200E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3200E = {  "_ZN4bbbb6zz3200E", // class name
  bases__ZN4bbbb6zz3200E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4200  : ::bbbb::yy200 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4200E) C1{ BC2{ BC3{ BC4{}} Fs} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4200E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4200E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz4200E, buf);
    ::bbbb::zz4200 &lv = *(new (buf) ::bbbb::zz4200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz4200E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4200E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*)(::bbbb::yy200*), 0, "_ZN4bbbb6zz4200E");
    check_base_class_offset(lv, (::bbbb::xx00*)(::bbbb::yy200*), 0, "_ZN4bbbb6zz4200E");
    check_base_class_offset(lv, (::bbbb::yy200*), 0, "_ZN4bbbb6zz4200E");
    check_field_offset(lv, fd, ABISELECT(8,4), "_ZN4bbbb6zz4200E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4200E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4200E(Test__ZN4bbbb6zz4200E, "_ZN4bbbb6zz4200E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
extern Class_Descriptor cd__ZN4bbbb5yy200E;
static Base_Class bases__ZN4bbbb6zz4200E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy200E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4200E = {  "_ZN4bbbb6zz4200E", // class name
  bases__ZN4bbbb6zz4200E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy300  : ::bbbb::xx00 {
  int fc;
};
//SIG(-1 _ZN4bbbb5yy300E) C1{ BC2{ BC3{}} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy300E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy300E;
  void *lvp;
  {
    int buf[2];
    init_test(&cd__ZN4bbbb5yy300E, buf);
    ::bbbb::yy300 &lv = *(new (buf) ::bbbb::yy300());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb5yy300E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb5yy300E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*), 0, "_ZN4bbbb5yy300E");
    check_base_class_offset(lv, (::bbbb::xx00*), 0, "_ZN4bbbb5yy300E");
    check_field_offset(lv, fc, 0, "_ZN4bbbb5yy300E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy300E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy300E(Test__ZN4bbbb5yy300E, "_ZN4bbbb5yy300E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
static Base_Class bases__ZN4bbbb5yy300E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy300E = {  "_ZN4bbbb5yy300E", // class name
  bases__ZN4bbbb5yy300E, 2,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0300  : ::bbbb::yy300 {
};
//SIG(1 _ZN4bbbb6zz0300E) C1{ BC2{ BC3{ BC4{}} Fi}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0300E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0300E;
  void *lvp;
  {
    int buf[2];
    init_test(&cd__ZN4bbbb6zz0300E, buf);
    ::bbbb::zz0300 &lv = *(new (buf) ::bbbb::zz0300());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz0300E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz0300E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*)(::bbbb::yy300*), 0, "_ZN4bbbb6zz0300E");
    check_base_class_offset(lv, (::bbbb::xx00*)(::bbbb::yy300*), 0, "_ZN4bbbb6zz0300E");
    check_base_class_offset(lv, (::bbbb::yy300*), 0, "_ZN4bbbb6zz0300E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0300E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0300E(Test__ZN4bbbb6zz0300E, "_ZN4bbbb6zz0300E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
extern Class_Descriptor cd__ZN4bbbb5yy300E;
static Base_Class bases__ZN4bbbb6zz0300E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy300E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0300E = {  "_ZN4bbbb6zz0300E", // class name
  bases__ZN4bbbb6zz0300E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1300  : ::bbbb::yy300 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1300E) C1{ BC2{ BC3{ BC4{}} Fi} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1300E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1300E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz1300E, buf);
    ::bbbb::zz1300 &lv = *(new (buf) ::bbbb::zz1300());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz1300E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz1300E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*)(::bbbb::yy300*), 0, "_ZN4bbbb6zz1300E");
    check_base_class_offset(lv, (::bbbb::xx00*)(::bbbb::yy300*), 0, "_ZN4bbbb6zz1300E");
    check_base_class_offset(lv, (::bbbb::yy300*), 0, "_ZN4bbbb6zz1300E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz1300E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1300E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1300E(Test__ZN4bbbb6zz1300E, "_ZN4bbbb6zz1300E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
extern Class_Descriptor cd__ZN4bbbb5yy300E;
static Base_Class bases__ZN4bbbb6zz1300E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy300E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1300E = {  "_ZN4bbbb6zz1300E", // class name
  bases__ZN4bbbb6zz1300E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2300  : ::bbbb::yy300 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2300E) C1{ BC2{ BC3{ BC4{}} Fi} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2300E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2300E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz2300E, buf);
    ::bbbb::zz2300 &lv = *(new (buf) ::bbbb::zz2300());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz2300E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz2300E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*)(::bbbb::yy300*), 0, "_ZN4bbbb6zz2300E");
    check_base_class_offset(lv, (::bbbb::xx00*)(::bbbb::yy300*), 0, "_ZN4bbbb6zz2300E");
    check_base_class_offset(lv, (::bbbb::yy300*), 0, "_ZN4bbbb6zz2300E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz2300E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2300E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2300E(Test__ZN4bbbb6zz2300E, "_ZN4bbbb6zz2300E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
extern Class_Descriptor cd__ZN4bbbb5yy300E;
static Base_Class bases__ZN4bbbb6zz2300E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy300E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2300E = {  "_ZN4bbbb6zz2300E", // class name
  bases__ZN4bbbb6zz2300E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3300  : ::bbbb::yy300 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3300E) C1{ BC2{ BC3{ BC4{}} Fi} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3300E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3300E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz3300E, buf);
    ::bbbb::zz3300 &lv = *(new (buf) ::bbbb::zz3300());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz3300E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3300E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*)(::bbbb::yy300*), 0, "_ZN4bbbb6zz3300E");
    check_base_class_offset(lv, (::bbbb::xx00*)(::bbbb::yy300*), 0, "_ZN4bbbb6zz3300E");
    check_base_class_offset(lv, (::bbbb::yy300*), 0, "_ZN4bbbb6zz3300E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz3300E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3300E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3300E(Test__ZN4bbbb6zz3300E, "_ZN4bbbb6zz3300E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
extern Class_Descriptor cd__ZN4bbbb5yy300E;
static Base_Class bases__ZN4bbbb6zz3300E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy300E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3300E = {  "_ZN4bbbb6zz3300E", // class name
  bases__ZN4bbbb6zz3300E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4300  : ::bbbb::yy300 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4300E) C1{ BC2{ BC3{ BC4{}} Fi} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4300E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4300E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz4300E, buf);
    ::bbbb::zz4300 &lv = *(new (buf) ::bbbb::zz4300());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz4300E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4300E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*)(::bbbb::yy300*), 0, "_ZN4bbbb6zz4300E");
    check_base_class_offset(lv, (::bbbb::xx00*)(::bbbb::yy300*), 0, "_ZN4bbbb6zz4300E");
    check_base_class_offset(lv, (::bbbb::yy300*), 0, "_ZN4bbbb6zz4300E");
    check_field_offset(lv, fd, ABISELECT(8,4), "_ZN4bbbb6zz4300E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4300E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4300E(Test__ZN4bbbb6zz4300E, "_ZN4bbbb6zz4300E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
extern Class_Descriptor cd__ZN4bbbb5yy300E;
static Base_Class bases__ZN4bbbb6zz4300E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy300E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4300E = {  "_ZN4bbbb6zz4300E", // class name
  bases__ZN4bbbb6zz4300E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy400  : ::bbbb::xx00 {
  double fc;
};
//SIG(-1 _ZN4bbbb5yy400E) C1{ BC2{ BC3{}} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy400E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy400E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(2,3)];
    init_test(&cd__ZN4bbbb5yy400E, buf);
    ::bbbb::yy400 &lv = *(new (buf) ::bbbb::yy400());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb5yy400E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb5yy400E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*), 0, "_ZN4bbbb5yy400E");
    check_base_class_offset(lv, (::bbbb::xx00*), 0, "_ZN4bbbb5yy400E");
    check_field_offset(lv, fc, 0, "_ZN4bbbb5yy400E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy400E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy400E(Test__ZN4bbbb5yy400E, "_ZN4bbbb5yy400E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
static Base_Class bases__ZN4bbbb5yy400E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy400E = {  "_ZN4bbbb5yy400E", // class name
  bases__ZN4bbbb5yy400E, 2,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0400  : ::bbbb::yy400 {
};
//SIG(1 _ZN4bbbb6zz0400E) C1{ BC2{ BC3{ BC4{}} FL}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0400E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0400E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(2,3)];
    init_test(&cd__ZN4bbbb6zz0400E, buf);
    ::bbbb::zz0400 &lv = *(new (buf) ::bbbb::zz0400());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz0400E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz0400E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*)(::bbbb::yy400*), 0, "_ZN4bbbb6zz0400E");
    check_base_class_offset(lv, (::bbbb::xx00*)(::bbbb::yy400*), 0, "_ZN4bbbb6zz0400E");
    check_base_class_offset(lv, (::bbbb::yy400*), 0, "_ZN4bbbb6zz0400E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0400E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0400E(Test__ZN4bbbb6zz0400E, "_ZN4bbbb6zz0400E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
extern Class_Descriptor cd__ZN4bbbb5yy400E;
static Base_Class bases__ZN4bbbb6zz0400E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy400E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0400E = {  "_ZN4bbbb6zz0400E", // class name
  bases__ZN4bbbb6zz0400E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1400  : ::bbbb::yy400 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1400E) C1{ BC2{ BC3{ BC4{}} FL} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1400E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1400E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz1400E, buf);
    ::bbbb::zz1400 &lv = *(new (buf) ::bbbb::zz1400());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz1400E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz1400E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*)(::bbbb::yy400*), 0, "_ZN4bbbb6zz1400E");
    check_base_class_offset(lv, (::bbbb::xx00*)(::bbbb::yy400*), 0, "_ZN4bbbb6zz1400E");
    check_base_class_offset(lv, (::bbbb::yy400*), 0, "_ZN4bbbb6zz1400E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz1400E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1400E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1400E(Test__ZN4bbbb6zz1400E, "_ZN4bbbb6zz1400E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
extern Class_Descriptor cd__ZN4bbbb5yy400E;
static Base_Class bases__ZN4bbbb6zz1400E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy400E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1400E = {  "_ZN4bbbb6zz1400E", // class name
  bases__ZN4bbbb6zz1400E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2400  : ::bbbb::yy400 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2400E) C1{ BC2{ BC3{ BC4{}} FL} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2400E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2400E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz2400E, buf);
    ::bbbb::zz2400 &lv = *(new (buf) ::bbbb::zz2400());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz2400E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz2400E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*)(::bbbb::yy400*), 0, "_ZN4bbbb6zz2400E");
    check_base_class_offset(lv, (::bbbb::xx00*)(::bbbb::yy400*), 0, "_ZN4bbbb6zz2400E");
    check_base_class_offset(lv, (::bbbb::yy400*), 0, "_ZN4bbbb6zz2400E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz2400E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2400E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2400E(Test__ZN4bbbb6zz2400E, "_ZN4bbbb6zz2400E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
extern Class_Descriptor cd__ZN4bbbb5yy400E;
static Base_Class bases__ZN4bbbb6zz2400E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy400E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2400E = {  "_ZN4bbbb6zz2400E", // class name
  bases__ZN4bbbb6zz2400E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3400  : ::bbbb::yy400 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3400E) C1{ BC2{ BC3{ BC4{}} FL} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3400E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3400E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz3400E, buf);
    ::bbbb::zz3400 &lv = *(new (buf) ::bbbb::zz3400());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz3400E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz3400E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*)(::bbbb::yy400*), 0, "_ZN4bbbb6zz3400E");
    check_base_class_offset(lv, (::bbbb::xx00*)(::bbbb::yy400*), 0, "_ZN4bbbb6zz3400E");
    check_base_class_offset(lv, (::bbbb::yy400*), 0, "_ZN4bbbb6zz3400E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz3400E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3400E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3400E(Test__ZN4bbbb6zz3400E, "_ZN4bbbb6zz3400E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
extern Class_Descriptor cd__ZN4bbbb5yy400E;
static Base_Class bases__ZN4bbbb6zz3400E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy400E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3400E = {  "_ZN4bbbb6zz3400E", // class name
  bases__ZN4bbbb6zz3400E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4400  : ::bbbb::yy400 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4400E) C1{ BC2{ BC3{ BC4{}} FL} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4400E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4400E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,5)];
    init_test(&cd__ZN4bbbb6zz4400E, buf);
    ::bbbb::zz4400 &lv = *(new (buf) ::bbbb::zz4400());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz4400E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4400E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx00*)(::bbbb::yy400*), 0, "_ZN4bbbb6zz4400E");
    check_base_class_offset(lv, (::bbbb::xx00*)(::bbbb::yy400*), 0, "_ZN4bbbb6zz4400E");
    check_base_class_offset(lv, (::bbbb::yy400*), 0, "_ZN4bbbb6zz4400E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz4400E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4400E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4400E(Test__ZN4bbbb6zz4400E, "_ZN4bbbb6zz4400E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx00E;
extern Class_Descriptor cd__ZN4bbbb5yy400E;
static Base_Class bases__ZN4bbbb6zz4400E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx00E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy400E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4400E = {  "_ZN4bbbb6zz4400E", // class name
  bases__ZN4bbbb6zz4400E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  xx10  : ::bbbb::ww0 {
  char fb;
};
//SIG(-1 _ZN4bbbb4xx10E) C1{ BC2{} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb4xx10E()
{
  extern Class_Descriptor cd__ZN4bbbb4xx10E;
  void *lvp;
  {
    char buf[1];
    init_test(&cd__ZN4bbbb4xx10E, buf);
    ::bbbb::xx10 &lv = *(new (buf) ::bbbb::xx10());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(_ZN4bbbb4xx10E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb4xx10E)");
    check_base_class_offset(lv, (::bbbb::ww0*), 0, "_ZN4bbbb4xx10E");
    check_field_offset(lv, fb, 0, "_ZN4bbbb4xx10E.fb");
    test_class_info(&lv, &cd__ZN4bbbb4xx10E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb4xx10E(Test__ZN4bbbb4xx10E, "_ZN4bbbb4xx10E", 1);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
static Base_Class bases__ZN4bbbb4xx10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb4xx10E = {  "_ZN4bbbb4xx10E", // class name
  bases__ZN4bbbb4xx10E, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy010  : ::bbbb::xx10 {
};
//SIG(-1 _ZN4bbbb5yy010E) C1{ BC2{ BC3{} Fc}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy010E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy010E;
  void *lvp;
  {
    char buf[1];
    init_test(&cd__ZN4bbbb5yy010E, buf);
    ::bbbb::yy010 &lv = *(new (buf) ::bbbb::yy010());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(_ZN4bbbb5yy010E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb5yy010E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*), 0, "_ZN4bbbb5yy010E");
    check_base_class_offset(lv, (::bbbb::xx10*), 0, "_ZN4bbbb5yy010E");
    test_class_info(&lv, &cd__ZN4bbbb5yy010E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy010E(Test__ZN4bbbb5yy010E, "_ZN4bbbb5yy010E", 1);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
static Base_Class bases__ZN4bbbb5yy010E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy010E = {  "_ZN4bbbb5yy010E", // class name
  bases__ZN4bbbb5yy010E, 2,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0010  : ::bbbb::yy010 {
};
//SIG(1 _ZN4bbbb6zz0010E) C1{ BC2{ BC3{ BC4{} Fc}}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0010E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0010E;
  void *lvp;
  {
    char buf[1];
    init_test(&cd__ZN4bbbb6zz0010E, buf);
    ::bbbb::zz0010 &lv = *(new (buf) ::bbbb::zz0010());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(_ZN4bbbb6zz0010E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb6zz0010E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*)(::bbbb::yy010*), 0, "_ZN4bbbb6zz0010E");
    check_base_class_offset(lv, (::bbbb::xx10*)(::bbbb::yy010*), 0, "_ZN4bbbb6zz0010E");
    check_base_class_offset(lv, (::bbbb::yy010*), 0, "_ZN4bbbb6zz0010E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0010E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0010E(Test__ZN4bbbb6zz0010E, "_ZN4bbbb6zz0010E", 1);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
extern Class_Descriptor cd__ZN4bbbb5yy010E;
static Base_Class bases__ZN4bbbb6zz0010E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy010E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0010E = {  "_ZN4bbbb6zz0010E", // class name
  bases__ZN4bbbb6zz0010E, 3,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1010  : ::bbbb::yy010 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1010E) C1{ BC2{ BC3{ BC4{} Fc}} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1010E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1010E;
  void *lvp;
  {
    char buf[2];
    init_test(&cd__ZN4bbbb6zz1010E, buf);
    ::bbbb::zz1010 &lv = *(new (buf) ::bbbb::zz1010());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4bbbb6zz1010E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb6zz1010E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*)(::bbbb::yy010*), 0, "_ZN4bbbb6zz1010E");
    check_base_class_offset(lv, (::bbbb::xx10*)(::bbbb::yy010*), 0, "_ZN4bbbb6zz1010E");
    check_base_class_offset(lv, (::bbbb::yy010*), 0, "_ZN4bbbb6zz1010E");
    check_field_offset(lv, fd, 1, "_ZN4bbbb6zz1010E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1010E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1010E(Test__ZN4bbbb6zz1010E, "_ZN4bbbb6zz1010E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
extern Class_Descriptor cd__ZN4bbbb5yy010E;
static Base_Class bases__ZN4bbbb6zz1010E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy010E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1010E = {  "_ZN4bbbb6zz1010E", // class name
  bases__ZN4bbbb6zz1010E, 3,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2010  : ::bbbb::yy010 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2010E) C1{ BC2{ BC3{ BC4{} Fc}} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2010E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2010E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb6zz2010E, buf);
    ::bbbb::zz2010 &lv = *(new (buf) ::bbbb::zz2010());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz2010E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz2010E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*)(::bbbb::yy010*), 0, "_ZN4bbbb6zz2010E");
    check_base_class_offset(lv, (::bbbb::xx10*)(::bbbb::yy010*), 0, "_ZN4bbbb6zz2010E");
    check_base_class_offset(lv, (::bbbb::yy010*), 0, "_ZN4bbbb6zz2010E");
    check_field_offset(lv, fd, 2, "_ZN4bbbb6zz2010E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2010E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2010E(Test__ZN4bbbb6zz2010E, "_ZN4bbbb6zz2010E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
extern Class_Descriptor cd__ZN4bbbb5yy010E;
static Base_Class bases__ZN4bbbb6zz2010E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy010E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2010E = {  "_ZN4bbbb6zz2010E", // class name
  bases__ZN4bbbb6zz2010E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3010  : ::bbbb::yy010 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3010E) C1{ BC2{ BC3{ BC4{} Fc}} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3010E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3010E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz3010E, buf);
    ::bbbb::zz3010 &lv = *(new (buf) ::bbbb::zz3010());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz3010E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3010E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*)(::bbbb::yy010*), 0, "_ZN4bbbb6zz3010E");
    check_base_class_offset(lv, (::bbbb::xx10*)(::bbbb::yy010*), 0, "_ZN4bbbb6zz3010E");
    check_base_class_offset(lv, (::bbbb::yy010*), 0, "_ZN4bbbb6zz3010E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz3010E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3010E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3010E(Test__ZN4bbbb6zz3010E, "_ZN4bbbb6zz3010E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
extern Class_Descriptor cd__ZN4bbbb5yy010E;
static Base_Class bases__ZN4bbbb6zz3010E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy010E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3010E = {  "_ZN4bbbb6zz3010E", // class name
  bases__ZN4bbbb6zz3010E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4010  : ::bbbb::yy010 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4010E) C1{ BC2{ BC3{ BC4{} Fc}} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4010E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4010E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz4010E, buf);
    ::bbbb::zz4010 &lv = *(new (buf) ::bbbb::zz4010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz4010E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4010E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*)(::bbbb::yy010*), 0, "_ZN4bbbb6zz4010E");
    check_base_class_offset(lv, (::bbbb::xx10*)(::bbbb::yy010*), 0, "_ZN4bbbb6zz4010E");
    check_base_class_offset(lv, (::bbbb::yy010*), 0, "_ZN4bbbb6zz4010E");
    check_field_offset(lv, fd, ABISELECT(8,4), "_ZN4bbbb6zz4010E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4010E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4010E(Test__ZN4bbbb6zz4010E, "_ZN4bbbb6zz4010E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
extern Class_Descriptor cd__ZN4bbbb5yy010E;
static Base_Class bases__ZN4bbbb6zz4010E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy010E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4010E = {  "_ZN4bbbb6zz4010E", // class name
  bases__ZN4bbbb6zz4010E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy110  : ::bbbb::xx10 {
  char fc;
};
//SIG(-1 _ZN4bbbb5yy110E) C1{ BC2{ BC3{} Fc} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy110E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy110E;
  void *lvp;
  {
    char buf[2];
    init_test(&cd__ZN4bbbb5yy110E, buf);
    ::bbbb::yy110 &lv = *(new (buf) ::bbbb::yy110());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4bbbb5yy110E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb5yy110E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*), 0, "_ZN4bbbb5yy110E");
    check_base_class_offset(lv, (::bbbb::xx10*), 0, "_ZN4bbbb5yy110E");
    check_field_offset(lv, fc, 1, "_ZN4bbbb5yy110E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy110E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy110E(Test__ZN4bbbb5yy110E, "_ZN4bbbb5yy110E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
static Base_Class bases__ZN4bbbb5yy110E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy110E = {  "_ZN4bbbb5yy110E", // class name
  bases__ZN4bbbb5yy110E, 2,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0110  : ::bbbb::yy110 {
};
//SIG(1 _ZN4bbbb6zz0110E) C1{ BC2{ BC3{ BC4{} Fc} Fc}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0110E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0110E;
  void *lvp;
  {
    char buf[2];
    init_test(&cd__ZN4bbbb6zz0110E, buf);
    ::bbbb::zz0110 &lv = *(new (buf) ::bbbb::zz0110());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4bbbb6zz0110E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb6zz0110E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*)(::bbbb::yy110*), 0, "_ZN4bbbb6zz0110E");
    check_base_class_offset(lv, (::bbbb::xx10*)(::bbbb::yy110*), 0, "_ZN4bbbb6zz0110E");
    check_base_class_offset(lv, (::bbbb::yy110*), 0, "_ZN4bbbb6zz0110E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0110E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0110E(Test__ZN4bbbb6zz0110E, "_ZN4bbbb6zz0110E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
extern Class_Descriptor cd__ZN4bbbb5yy110E;
static Base_Class bases__ZN4bbbb6zz0110E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy110E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0110E = {  "_ZN4bbbb6zz0110E", // class name
  bases__ZN4bbbb6zz0110E, 3,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1110  : ::bbbb::yy110 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1110E) C1{ BC2{ BC3{ BC4{} Fc} Fc} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1110E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1110E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4bbbb6zz1110E, buf);
    ::bbbb::zz1110 &lv = *(new (buf) ::bbbb::zz1110());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4bbbb6zz1110E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb6zz1110E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*)(::bbbb::yy110*), 0, "_ZN4bbbb6zz1110E");
    check_base_class_offset(lv, (::bbbb::xx10*)(::bbbb::yy110*), 0, "_ZN4bbbb6zz1110E");
    check_base_class_offset(lv, (::bbbb::yy110*), 0, "_ZN4bbbb6zz1110E");
    check_field_offset(lv, fd, 2, "_ZN4bbbb6zz1110E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1110E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1110E(Test__ZN4bbbb6zz1110E, "_ZN4bbbb6zz1110E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
extern Class_Descriptor cd__ZN4bbbb5yy110E;
static Base_Class bases__ZN4bbbb6zz1110E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy110E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1110E = {  "_ZN4bbbb6zz1110E", // class name
  bases__ZN4bbbb6zz1110E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2110  : ::bbbb::yy110 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2110E) C1{ BC2{ BC3{ BC4{} Fc} Fc} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2110E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2110E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb6zz2110E, buf);
    ::bbbb::zz2110 &lv = *(new (buf) ::bbbb::zz2110());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz2110E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz2110E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*)(::bbbb::yy110*), 0, "_ZN4bbbb6zz2110E");
    check_base_class_offset(lv, (::bbbb::xx10*)(::bbbb::yy110*), 0, "_ZN4bbbb6zz2110E");
    check_base_class_offset(lv, (::bbbb::yy110*), 0, "_ZN4bbbb6zz2110E");
    check_field_offset(lv, fd, 2, "_ZN4bbbb6zz2110E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2110E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2110E(Test__ZN4bbbb6zz2110E, "_ZN4bbbb6zz2110E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
extern Class_Descriptor cd__ZN4bbbb5yy110E;
static Base_Class bases__ZN4bbbb6zz2110E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy110E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2110E = {  "_ZN4bbbb6zz2110E", // class name
  bases__ZN4bbbb6zz2110E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3110  : ::bbbb::yy110 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3110E) C1{ BC2{ BC3{ BC4{} Fc} Fc} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3110E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3110E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz3110E, buf);
    ::bbbb::zz3110 &lv = *(new (buf) ::bbbb::zz3110());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz3110E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3110E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*)(::bbbb::yy110*), 0, "_ZN4bbbb6zz3110E");
    check_base_class_offset(lv, (::bbbb::xx10*)(::bbbb::yy110*), 0, "_ZN4bbbb6zz3110E");
    check_base_class_offset(lv, (::bbbb::yy110*), 0, "_ZN4bbbb6zz3110E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz3110E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3110E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3110E(Test__ZN4bbbb6zz3110E, "_ZN4bbbb6zz3110E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
extern Class_Descriptor cd__ZN4bbbb5yy110E;
static Base_Class bases__ZN4bbbb6zz3110E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy110E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3110E = {  "_ZN4bbbb6zz3110E", // class name
  bases__ZN4bbbb6zz3110E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4110  : ::bbbb::yy110 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4110E) C1{ BC2{ BC3{ BC4{} Fc} Fc} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4110E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4110E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz4110E, buf);
    ::bbbb::zz4110 &lv = *(new (buf) ::bbbb::zz4110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz4110E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4110E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*)(::bbbb::yy110*), 0, "_ZN4bbbb6zz4110E");
    check_base_class_offset(lv, (::bbbb::xx10*)(::bbbb::yy110*), 0, "_ZN4bbbb6zz4110E");
    check_base_class_offset(lv, (::bbbb::yy110*), 0, "_ZN4bbbb6zz4110E");
    check_field_offset(lv, fd, ABISELECT(8,4), "_ZN4bbbb6zz4110E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4110E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4110E(Test__ZN4bbbb6zz4110E, "_ZN4bbbb6zz4110E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
extern Class_Descriptor cd__ZN4bbbb5yy110E;
static Base_Class bases__ZN4bbbb6zz4110E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy110E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4110E = {  "_ZN4bbbb6zz4110E", // class name
  bases__ZN4bbbb6zz4110E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy210  : ::bbbb::xx10 {
  short fc;
};
//SIG(-1 _ZN4bbbb5yy210E) C1{ BC2{ BC3{} Fc} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy210E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy210E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb5yy210E, buf);
    ::bbbb::yy210 &lv = *(new (buf) ::bbbb::yy210());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb5yy210E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb5yy210E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*), 0, "_ZN4bbbb5yy210E");
    check_base_class_offset(lv, (::bbbb::xx10*), 0, "_ZN4bbbb5yy210E");
    check_field_offset(lv, fc, 2, "_ZN4bbbb5yy210E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy210E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy210E(Test__ZN4bbbb5yy210E, "_ZN4bbbb5yy210E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
static Base_Class bases__ZN4bbbb5yy210E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy210E = {  "_ZN4bbbb5yy210E", // class name
  bases__ZN4bbbb5yy210E, 2,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0210  : ::bbbb::yy210 {
};
//SIG(1 _ZN4bbbb6zz0210E) C1{ BC2{ BC3{ BC4{} Fc} Fs}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0210E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0210E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb6zz0210E, buf);
    ::bbbb::zz0210 &lv = *(new (buf) ::bbbb::zz0210());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz0210E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz0210E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*)(::bbbb::yy210*), 0, "_ZN4bbbb6zz0210E");
    check_base_class_offset(lv, (::bbbb::xx10*)(::bbbb::yy210*), 0, "_ZN4bbbb6zz0210E");
    check_base_class_offset(lv, (::bbbb::yy210*), 0, "_ZN4bbbb6zz0210E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0210E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0210E(Test__ZN4bbbb6zz0210E, "_ZN4bbbb6zz0210E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
extern Class_Descriptor cd__ZN4bbbb5yy210E;
static Base_Class bases__ZN4bbbb6zz0210E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy210E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0210E = {  "_ZN4bbbb6zz0210E", // class name
  bases__ZN4bbbb6zz0210E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1210  : ::bbbb::yy210 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1210E) C1{ BC2{ BC3{ BC4{} Fc} Fs} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1210E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1210E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb6zz1210E, buf);
    ::bbbb::zz1210 &lv = *(new (buf) ::bbbb::zz1210());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb6zz1210E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz1210E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*)(::bbbb::yy210*), 0, "_ZN4bbbb6zz1210E");
    check_base_class_offset(lv, (::bbbb::xx10*)(::bbbb::yy210*), 0, "_ZN4bbbb6zz1210E");
    check_base_class_offset(lv, (::bbbb::yy210*), 0, "_ZN4bbbb6zz1210E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz1210E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1210E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1210E(Test__ZN4bbbb6zz1210E, "_ZN4bbbb6zz1210E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
extern Class_Descriptor cd__ZN4bbbb5yy210E;
static Base_Class bases__ZN4bbbb6zz1210E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy210E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1210E = {  "_ZN4bbbb6zz1210E", // class name
  bases__ZN4bbbb6zz1210E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2210  : ::bbbb::yy210 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2210E) C1{ BC2{ BC3{ BC4{} Fc} Fs} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2210E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2210E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb6zz2210E, buf);
    ::bbbb::zz2210 &lv = *(new (buf) ::bbbb::zz2210());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb6zz2210E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz2210E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*)(::bbbb::yy210*), 0, "_ZN4bbbb6zz2210E");
    check_base_class_offset(lv, (::bbbb::xx10*)(::bbbb::yy210*), 0, "_ZN4bbbb6zz2210E");
    check_base_class_offset(lv, (::bbbb::yy210*), 0, "_ZN4bbbb6zz2210E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz2210E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2210E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2210E(Test__ZN4bbbb6zz2210E, "_ZN4bbbb6zz2210E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
extern Class_Descriptor cd__ZN4bbbb5yy210E;
static Base_Class bases__ZN4bbbb6zz2210E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy210E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2210E = {  "_ZN4bbbb6zz2210E", // class name
  bases__ZN4bbbb6zz2210E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3210  : ::bbbb::yy210 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3210E) C1{ BC2{ BC3{ BC4{} Fc} Fs} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3210E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3210E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz3210E, buf);
    ::bbbb::zz3210 &lv = *(new (buf) ::bbbb::zz3210());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz3210E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3210E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*)(::bbbb::yy210*), 0, "_ZN4bbbb6zz3210E");
    check_base_class_offset(lv, (::bbbb::xx10*)(::bbbb::yy210*), 0, "_ZN4bbbb6zz3210E");
    check_base_class_offset(lv, (::bbbb::yy210*), 0, "_ZN4bbbb6zz3210E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz3210E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3210E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3210E(Test__ZN4bbbb6zz3210E, "_ZN4bbbb6zz3210E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
extern Class_Descriptor cd__ZN4bbbb5yy210E;
static Base_Class bases__ZN4bbbb6zz3210E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy210E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3210E = {  "_ZN4bbbb6zz3210E", // class name
  bases__ZN4bbbb6zz3210E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4210  : ::bbbb::yy210 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4210E) C1{ BC2{ BC3{ BC4{} Fc} Fs} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4210E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4210E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz4210E, buf);
    ::bbbb::zz4210 &lv = *(new (buf) ::bbbb::zz4210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz4210E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4210E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*)(::bbbb::yy210*), 0, "_ZN4bbbb6zz4210E");
    check_base_class_offset(lv, (::bbbb::xx10*)(::bbbb::yy210*), 0, "_ZN4bbbb6zz4210E");
    check_base_class_offset(lv, (::bbbb::yy210*), 0, "_ZN4bbbb6zz4210E");
    check_field_offset(lv, fd, ABISELECT(8,4), "_ZN4bbbb6zz4210E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4210E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4210E(Test__ZN4bbbb6zz4210E, "_ZN4bbbb6zz4210E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
extern Class_Descriptor cd__ZN4bbbb5yy210E;
static Base_Class bases__ZN4bbbb6zz4210E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy210E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4210E = {  "_ZN4bbbb6zz4210E", // class name
  bases__ZN4bbbb6zz4210E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy310  : ::bbbb::xx10 {
  int fc;
};
//SIG(-1 _ZN4bbbb5yy310E) C1{ BC2{ BC3{} Fc} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy310E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy310E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb5yy310E, buf);
    ::bbbb::yy310 &lv = *(new (buf) ::bbbb::yy310());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb5yy310E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb5yy310E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*), 0, "_ZN4bbbb5yy310E");
    check_base_class_offset(lv, (::bbbb::xx10*), 0, "_ZN4bbbb5yy310E");
    check_field_offset(lv, fc, 4, "_ZN4bbbb5yy310E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy310E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy310E(Test__ZN4bbbb5yy310E, "_ZN4bbbb5yy310E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
static Base_Class bases__ZN4bbbb5yy310E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy310E = {  "_ZN4bbbb5yy310E", // class name
  bases__ZN4bbbb5yy310E, 2,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0310  : ::bbbb::yy310 {
};
//SIG(1 _ZN4bbbb6zz0310E) C1{ BC2{ BC3{ BC4{} Fc} Fi}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0310E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0310E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz0310E, buf);
    ::bbbb::zz0310 &lv = *(new (buf) ::bbbb::zz0310());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz0310E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz0310E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*)(::bbbb::yy310*), 0, "_ZN4bbbb6zz0310E");
    check_base_class_offset(lv, (::bbbb::xx10*)(::bbbb::yy310*), 0, "_ZN4bbbb6zz0310E");
    check_base_class_offset(lv, (::bbbb::yy310*), 0, "_ZN4bbbb6zz0310E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0310E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0310E(Test__ZN4bbbb6zz0310E, "_ZN4bbbb6zz0310E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
extern Class_Descriptor cd__ZN4bbbb5yy310E;
static Base_Class bases__ZN4bbbb6zz0310E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy310E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0310E = {  "_ZN4bbbb6zz0310E", // class name
  bases__ZN4bbbb6zz0310E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1310  : ::bbbb::yy310 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1310E) C1{ BC2{ BC3{ BC4{} Fc} Fi} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1310E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1310E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz1310E, buf);
    ::bbbb::zz1310 &lv = *(new (buf) ::bbbb::zz1310());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz1310E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz1310E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*)(::bbbb::yy310*), 0, "_ZN4bbbb6zz1310E");
    check_base_class_offset(lv, (::bbbb::xx10*)(::bbbb::yy310*), 0, "_ZN4bbbb6zz1310E");
    check_base_class_offset(lv, (::bbbb::yy310*), 0, "_ZN4bbbb6zz1310E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz1310E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1310E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1310E(Test__ZN4bbbb6zz1310E, "_ZN4bbbb6zz1310E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
extern Class_Descriptor cd__ZN4bbbb5yy310E;
static Base_Class bases__ZN4bbbb6zz1310E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy310E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1310E = {  "_ZN4bbbb6zz1310E", // class name
  bases__ZN4bbbb6zz1310E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2310  : ::bbbb::yy310 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2310E) C1{ BC2{ BC3{ BC4{} Fc} Fi} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2310E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2310E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz2310E, buf);
    ::bbbb::zz2310 &lv = *(new (buf) ::bbbb::zz2310());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz2310E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz2310E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*)(::bbbb::yy310*), 0, "_ZN4bbbb6zz2310E");
    check_base_class_offset(lv, (::bbbb::xx10*)(::bbbb::yy310*), 0, "_ZN4bbbb6zz2310E");
    check_base_class_offset(lv, (::bbbb::yy310*), 0, "_ZN4bbbb6zz2310E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz2310E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2310E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2310E(Test__ZN4bbbb6zz2310E, "_ZN4bbbb6zz2310E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
extern Class_Descriptor cd__ZN4bbbb5yy310E;
static Base_Class bases__ZN4bbbb6zz2310E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy310E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2310E = {  "_ZN4bbbb6zz2310E", // class name
  bases__ZN4bbbb6zz2310E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3310  : ::bbbb::yy310 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3310E) C1{ BC2{ BC3{ BC4{} Fc} Fi} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3310E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3310E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz3310E, buf);
    ::bbbb::zz3310 &lv = *(new (buf) ::bbbb::zz3310());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz3310E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3310E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*)(::bbbb::yy310*), 0, "_ZN4bbbb6zz3310E");
    check_base_class_offset(lv, (::bbbb::xx10*)(::bbbb::yy310*), 0, "_ZN4bbbb6zz3310E");
    check_base_class_offset(lv, (::bbbb::yy310*), 0, "_ZN4bbbb6zz3310E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz3310E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3310E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3310E(Test__ZN4bbbb6zz3310E, "_ZN4bbbb6zz3310E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
extern Class_Descriptor cd__ZN4bbbb5yy310E;
static Base_Class bases__ZN4bbbb6zz3310E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy310E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3310E = {  "_ZN4bbbb6zz3310E", // class name
  bases__ZN4bbbb6zz3310E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4310  : ::bbbb::yy310 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4310E) C1{ BC2{ BC3{ BC4{} Fc} Fi} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4310E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4310E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,5)];
    init_test(&cd__ZN4bbbb6zz4310E, buf);
    ::bbbb::zz4310 &lv = *(new (buf) ::bbbb::zz4310());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz4310E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4310E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*)(::bbbb::yy310*), 0, "_ZN4bbbb6zz4310E");
    check_base_class_offset(lv, (::bbbb::xx10*)(::bbbb::yy310*), 0, "_ZN4bbbb6zz4310E");
    check_base_class_offset(lv, (::bbbb::yy310*), 0, "_ZN4bbbb6zz4310E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz4310E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4310E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4310E(Test__ZN4bbbb6zz4310E, "_ZN4bbbb6zz4310E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
extern Class_Descriptor cd__ZN4bbbb5yy310E;
static Base_Class bases__ZN4bbbb6zz4310E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy310E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4310E = {  "_ZN4bbbb6zz4310E", // class name
  bases__ZN4bbbb6zz4310E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy410  : ::bbbb::xx10 {
  double fc;
};
//SIG(-1 _ZN4bbbb5yy410E) C1{ BC2{ BC3{} Fc} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy410E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy410E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb5yy410E, buf);
    ::bbbb::yy410 &lv = *(new (buf) ::bbbb::yy410());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb5yy410E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb5yy410E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*), 0, "_ZN4bbbb5yy410E");
    check_base_class_offset(lv, (::bbbb::xx10*), 0, "_ZN4bbbb5yy410E");
    check_field_offset(lv, fc, ABISELECT(8,4), "_ZN4bbbb5yy410E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy410E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy410E(Test__ZN4bbbb5yy410E, "_ZN4bbbb5yy410E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
static Base_Class bases__ZN4bbbb5yy410E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy410E = {  "_ZN4bbbb5yy410E", // class name
  bases__ZN4bbbb5yy410E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0410  : ::bbbb::yy410 {
};
//SIG(1 _ZN4bbbb6zz0410E) C1{ BC2{ BC3{ BC4{} Fc} FL}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0410E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0410E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz0410E, buf);
    ::bbbb::zz0410 &lv = *(new (buf) ::bbbb::zz0410());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz0410E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz0410E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*)(::bbbb::yy410*), 0, "_ZN4bbbb6zz0410E");
    check_base_class_offset(lv, (::bbbb::xx10*)(::bbbb::yy410*), 0, "_ZN4bbbb6zz0410E");
    check_base_class_offset(lv, (::bbbb::yy410*), 0, "_ZN4bbbb6zz0410E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0410E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0410E(Test__ZN4bbbb6zz0410E, "_ZN4bbbb6zz0410E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
extern Class_Descriptor cd__ZN4bbbb5yy410E;
static Base_Class bases__ZN4bbbb6zz0410E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy410E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0410E = {  "_ZN4bbbb6zz0410E", // class name
  bases__ZN4bbbb6zz0410E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1410  : ::bbbb::yy410 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1410E) C1{ BC2{ BC3{ BC4{} Fc} FL} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1410E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1410E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz1410E, buf);
    ::bbbb::zz1410 &lv = *(new (buf) ::bbbb::zz1410());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz1410E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz1410E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*)(::bbbb::yy410*), 0, "_ZN4bbbb6zz1410E");
    check_base_class_offset(lv, (::bbbb::xx10*)(::bbbb::yy410*), 0, "_ZN4bbbb6zz1410E");
    check_base_class_offset(lv, (::bbbb::yy410*), 0, "_ZN4bbbb6zz1410E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz1410E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1410E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1410E(Test__ZN4bbbb6zz1410E, "_ZN4bbbb6zz1410E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
extern Class_Descriptor cd__ZN4bbbb5yy410E;
static Base_Class bases__ZN4bbbb6zz1410E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy410E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1410E = {  "_ZN4bbbb6zz1410E", // class name
  bases__ZN4bbbb6zz1410E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2410  : ::bbbb::yy410 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2410E) C1{ BC2{ BC3{ BC4{} Fc} FL} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2410E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2410E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz2410E, buf);
    ::bbbb::zz2410 &lv = *(new (buf) ::bbbb::zz2410());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz2410E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz2410E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*)(::bbbb::yy410*), 0, "_ZN4bbbb6zz2410E");
    check_base_class_offset(lv, (::bbbb::xx10*)(::bbbb::yy410*), 0, "_ZN4bbbb6zz2410E");
    check_base_class_offset(lv, (::bbbb::yy410*), 0, "_ZN4bbbb6zz2410E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz2410E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2410E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2410E(Test__ZN4bbbb6zz2410E, "_ZN4bbbb6zz2410E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
extern Class_Descriptor cd__ZN4bbbb5yy410E;
static Base_Class bases__ZN4bbbb6zz2410E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy410E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2410E = {  "_ZN4bbbb6zz2410E", // class name
  bases__ZN4bbbb6zz2410E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3410  : ::bbbb::yy410 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3410E) C1{ BC2{ BC3{ BC4{} Fc} FL} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3410E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3410E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz3410E, buf);
    ::bbbb::zz3410 &lv = *(new (buf) ::bbbb::zz3410());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz3410E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz3410E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*)(::bbbb::yy410*), 0, "_ZN4bbbb6zz3410E");
    check_base_class_offset(lv, (::bbbb::xx10*)(::bbbb::yy410*), 0, "_ZN4bbbb6zz3410E");
    check_base_class_offset(lv, (::bbbb::yy410*), 0, "_ZN4bbbb6zz3410E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz3410E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3410E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3410E(Test__ZN4bbbb6zz3410E, "_ZN4bbbb6zz3410E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
extern Class_Descriptor cd__ZN4bbbb5yy410E;
static Base_Class bases__ZN4bbbb6zz3410E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy410E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3410E = {  "_ZN4bbbb6zz3410E", // class name
  bases__ZN4bbbb6zz3410E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4410  : ::bbbb::yy410 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4410E) C1{ BC2{ BC3{ BC4{} Fc} FL} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4410E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4410E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz4410E, buf);
    ::bbbb::zz4410 &lv = *(new (buf) ::bbbb::zz4410());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz4410E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4410E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx10*)(::bbbb::yy410*), 0, "_ZN4bbbb6zz4410E");
    check_base_class_offset(lv, (::bbbb::xx10*)(::bbbb::yy410*), 0, "_ZN4bbbb6zz4410E");
    check_base_class_offset(lv, (::bbbb::yy410*), 0, "_ZN4bbbb6zz4410E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz4410E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4410E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4410E(Test__ZN4bbbb6zz4410E, "_ZN4bbbb6zz4410E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx10E;
extern Class_Descriptor cd__ZN4bbbb5yy410E;
static Base_Class bases__ZN4bbbb6zz4410E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx10E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy410E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4410E = {  "_ZN4bbbb6zz4410E", // class name
  bases__ZN4bbbb6zz4410E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  xx20  : ::bbbb::ww0 {
  short fb;
};
//SIG(-1 _ZN4bbbb4xx20E) C1{ BC2{} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb4xx20E()
{
  extern Class_Descriptor cd__ZN4bbbb4xx20E;
  void *lvp;
  {
    short buf[2];
    init_test(&cd__ZN4bbbb4xx20E, buf);
    ::bbbb::xx20 &lv = *(new (buf) ::bbbb::xx20());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4bbbb4xx20E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb4xx20E)");
    check_base_class_offset(lv, (::bbbb::ww0*), 0, "_ZN4bbbb4xx20E");
    check_field_offset(lv, fb, 0, "_ZN4bbbb4xx20E.fb");
    test_class_info(&lv, &cd__ZN4bbbb4xx20E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb4xx20E(Test__ZN4bbbb4xx20E, "_ZN4bbbb4xx20E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
static Base_Class bases__ZN4bbbb4xx20E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb4xx20E = {  "_ZN4bbbb4xx20E", // class name
  bases__ZN4bbbb4xx20E, 1,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy020  : ::bbbb::xx20 {
};
//SIG(-1 _ZN4bbbb5yy020E) C1{ BC2{ BC3{} Fs}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy020E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy020E;
  void *lvp;
  {
    short buf[2];
    init_test(&cd__ZN4bbbb5yy020E, buf);
    ::bbbb::yy020 &lv = *(new (buf) ::bbbb::yy020());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4bbbb5yy020E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb5yy020E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*), 0, "_ZN4bbbb5yy020E");
    check_base_class_offset(lv, (::bbbb::xx20*), 0, "_ZN4bbbb5yy020E");
    test_class_info(&lv, &cd__ZN4bbbb5yy020E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy020E(Test__ZN4bbbb5yy020E, "_ZN4bbbb5yy020E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
static Base_Class bases__ZN4bbbb5yy020E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy020E = {  "_ZN4bbbb5yy020E", // class name
  bases__ZN4bbbb5yy020E, 2,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0020  : ::bbbb::yy020 {
};
//SIG(1 _ZN4bbbb6zz0020E) C1{ BC2{ BC3{ BC4{} Fs}}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0020E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0020E;
  void *lvp;
  {
    short buf[2];
    init_test(&cd__ZN4bbbb6zz0020E, buf);
    ::bbbb::zz0020 &lv = *(new (buf) ::bbbb::zz0020());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4bbbb6zz0020E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz0020E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*)(::bbbb::yy020*), 0, "_ZN4bbbb6zz0020E");
    check_base_class_offset(lv, (::bbbb::xx20*)(::bbbb::yy020*), 0, "_ZN4bbbb6zz0020E");
    check_base_class_offset(lv, (::bbbb::yy020*), 0, "_ZN4bbbb6zz0020E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0020E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0020E(Test__ZN4bbbb6zz0020E, "_ZN4bbbb6zz0020E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
extern Class_Descriptor cd__ZN4bbbb5yy020E;
static Base_Class bases__ZN4bbbb6zz0020E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy020E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0020E = {  "_ZN4bbbb6zz0020E", // class name
  bases__ZN4bbbb6zz0020E, 3,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1020  : ::bbbb::yy020 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1020E) C1{ BC2{ BC3{ BC4{} Fs}} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1020E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1020E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb6zz1020E, buf);
    ::bbbb::zz1020 &lv = *(new (buf) ::bbbb::zz1020());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz1020E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz1020E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*)(::bbbb::yy020*), 0, "_ZN4bbbb6zz1020E");
    check_base_class_offset(lv, (::bbbb::xx20*)(::bbbb::yy020*), 0, "_ZN4bbbb6zz1020E");
    check_base_class_offset(lv, (::bbbb::yy020*), 0, "_ZN4bbbb6zz1020E");
    check_field_offset(lv, fd, 2, "_ZN4bbbb6zz1020E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1020E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1020E(Test__ZN4bbbb6zz1020E, "_ZN4bbbb6zz1020E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
extern Class_Descriptor cd__ZN4bbbb5yy020E;
static Base_Class bases__ZN4bbbb6zz1020E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy020E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1020E = {  "_ZN4bbbb6zz1020E", // class name
  bases__ZN4bbbb6zz1020E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2020  : ::bbbb::yy020 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2020E) C1{ BC2{ BC3{ BC4{} Fs}} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2020E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2020E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb6zz2020E, buf);
    ::bbbb::zz2020 &lv = *(new (buf) ::bbbb::zz2020());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz2020E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz2020E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*)(::bbbb::yy020*), 0, "_ZN4bbbb6zz2020E");
    check_base_class_offset(lv, (::bbbb::xx20*)(::bbbb::yy020*), 0, "_ZN4bbbb6zz2020E");
    check_base_class_offset(lv, (::bbbb::yy020*), 0, "_ZN4bbbb6zz2020E");
    check_field_offset(lv, fd, 2, "_ZN4bbbb6zz2020E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2020E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2020E(Test__ZN4bbbb6zz2020E, "_ZN4bbbb6zz2020E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
extern Class_Descriptor cd__ZN4bbbb5yy020E;
static Base_Class bases__ZN4bbbb6zz2020E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy020E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2020E = {  "_ZN4bbbb6zz2020E", // class name
  bases__ZN4bbbb6zz2020E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3020  : ::bbbb::yy020 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3020E) C1{ BC2{ BC3{ BC4{} Fs}} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3020E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3020E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz3020E, buf);
    ::bbbb::zz3020 &lv = *(new (buf) ::bbbb::zz3020());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz3020E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3020E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*)(::bbbb::yy020*), 0, "_ZN4bbbb6zz3020E");
    check_base_class_offset(lv, (::bbbb::xx20*)(::bbbb::yy020*), 0, "_ZN4bbbb6zz3020E");
    check_base_class_offset(lv, (::bbbb::yy020*), 0, "_ZN4bbbb6zz3020E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz3020E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3020E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3020E(Test__ZN4bbbb6zz3020E, "_ZN4bbbb6zz3020E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
extern Class_Descriptor cd__ZN4bbbb5yy020E;
static Base_Class bases__ZN4bbbb6zz3020E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy020E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3020E = {  "_ZN4bbbb6zz3020E", // class name
  bases__ZN4bbbb6zz3020E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4020  : ::bbbb::yy020 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4020E) C1{ BC2{ BC3{ BC4{} Fs}} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4020E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4020E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz4020E, buf);
    ::bbbb::zz4020 &lv = *(new (buf) ::bbbb::zz4020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz4020E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4020E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*)(::bbbb::yy020*), 0, "_ZN4bbbb6zz4020E");
    check_base_class_offset(lv, (::bbbb::xx20*)(::bbbb::yy020*), 0, "_ZN4bbbb6zz4020E");
    check_base_class_offset(lv, (::bbbb::yy020*), 0, "_ZN4bbbb6zz4020E");
    check_field_offset(lv, fd, ABISELECT(8,4), "_ZN4bbbb6zz4020E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4020E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4020E(Test__ZN4bbbb6zz4020E, "_ZN4bbbb6zz4020E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
extern Class_Descriptor cd__ZN4bbbb5yy020E;
static Base_Class bases__ZN4bbbb6zz4020E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy020E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4020E = {  "_ZN4bbbb6zz4020E", // class name
  bases__ZN4bbbb6zz4020E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy120  : ::bbbb::xx20 {
  char fc;
};
//SIG(-1 _ZN4bbbb5yy120E) C1{ BC2{ BC3{} Fs} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy120E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy120E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb5yy120E, buf);
    ::bbbb::yy120 &lv = *(new (buf) ::bbbb::yy120());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb5yy120E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb5yy120E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*), 0, "_ZN4bbbb5yy120E");
    check_base_class_offset(lv, (::bbbb::xx20*), 0, "_ZN4bbbb5yy120E");
    check_field_offset(lv, fc, 2, "_ZN4bbbb5yy120E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy120E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy120E(Test__ZN4bbbb5yy120E, "_ZN4bbbb5yy120E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
static Base_Class bases__ZN4bbbb5yy120E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy120E = {  "_ZN4bbbb5yy120E", // class name
  bases__ZN4bbbb5yy120E, 2,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0120  : ::bbbb::yy120 {
};
//SIG(1 _ZN4bbbb6zz0120E) C1{ BC2{ BC3{ BC4{} Fs} Fc}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0120E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0120E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb6zz0120E, buf);
    ::bbbb::zz0120 &lv = *(new (buf) ::bbbb::zz0120());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz0120E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz0120E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*)(::bbbb::yy120*), 0, "_ZN4bbbb6zz0120E");
    check_base_class_offset(lv, (::bbbb::xx20*)(::bbbb::yy120*), 0, "_ZN4bbbb6zz0120E");
    check_base_class_offset(lv, (::bbbb::yy120*), 0, "_ZN4bbbb6zz0120E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0120E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0120E(Test__ZN4bbbb6zz0120E, "_ZN4bbbb6zz0120E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
extern Class_Descriptor cd__ZN4bbbb5yy120E;
static Base_Class bases__ZN4bbbb6zz0120E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy120E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0120E = {  "_ZN4bbbb6zz0120E", // class name
  bases__ZN4bbbb6zz0120E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1120  : ::bbbb::yy120 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1120E) C1{ BC2{ BC3{ BC4{} Fs} Fc} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1120E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1120E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb6zz1120E, buf);
    ::bbbb::zz1120 &lv = *(new (buf) ::bbbb::zz1120());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz1120E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz1120E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*)(::bbbb::yy120*), 0, "_ZN4bbbb6zz1120E");
    check_base_class_offset(lv, (::bbbb::xx20*)(::bbbb::yy120*), 0, "_ZN4bbbb6zz1120E");
    check_base_class_offset(lv, (::bbbb::yy120*), 0, "_ZN4bbbb6zz1120E");
    check_field_offset(lv, fd, 3, "_ZN4bbbb6zz1120E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1120E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1120E(Test__ZN4bbbb6zz1120E, "_ZN4bbbb6zz1120E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
extern Class_Descriptor cd__ZN4bbbb5yy120E;
static Base_Class bases__ZN4bbbb6zz1120E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy120E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1120E = {  "_ZN4bbbb6zz1120E", // class name
  bases__ZN4bbbb6zz1120E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2120  : ::bbbb::yy120 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2120E) C1{ BC2{ BC3{ BC4{} Fs} Fc} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2120E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2120E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb6zz2120E, buf);
    ::bbbb::zz2120 &lv = *(new (buf) ::bbbb::zz2120());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb6zz2120E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz2120E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*)(::bbbb::yy120*), 0, "_ZN4bbbb6zz2120E");
    check_base_class_offset(lv, (::bbbb::xx20*)(::bbbb::yy120*), 0, "_ZN4bbbb6zz2120E");
    check_base_class_offset(lv, (::bbbb::yy120*), 0, "_ZN4bbbb6zz2120E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz2120E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2120E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2120E(Test__ZN4bbbb6zz2120E, "_ZN4bbbb6zz2120E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
extern Class_Descriptor cd__ZN4bbbb5yy120E;
static Base_Class bases__ZN4bbbb6zz2120E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy120E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2120E = {  "_ZN4bbbb6zz2120E", // class name
  bases__ZN4bbbb6zz2120E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3120  : ::bbbb::yy120 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3120E) C1{ BC2{ BC3{ BC4{} Fs} Fc} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3120E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3120E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz3120E, buf);
    ::bbbb::zz3120 &lv = *(new (buf) ::bbbb::zz3120());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz3120E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3120E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*)(::bbbb::yy120*), 0, "_ZN4bbbb6zz3120E");
    check_base_class_offset(lv, (::bbbb::xx20*)(::bbbb::yy120*), 0, "_ZN4bbbb6zz3120E");
    check_base_class_offset(lv, (::bbbb::yy120*), 0, "_ZN4bbbb6zz3120E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz3120E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3120E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3120E(Test__ZN4bbbb6zz3120E, "_ZN4bbbb6zz3120E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
extern Class_Descriptor cd__ZN4bbbb5yy120E;
static Base_Class bases__ZN4bbbb6zz3120E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy120E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3120E = {  "_ZN4bbbb6zz3120E", // class name
  bases__ZN4bbbb6zz3120E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4120  : ::bbbb::yy120 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4120E) C1{ BC2{ BC3{ BC4{} Fs} Fc} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4120E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4120E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz4120E, buf);
    ::bbbb::zz4120 &lv = *(new (buf) ::bbbb::zz4120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz4120E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4120E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*)(::bbbb::yy120*), 0, "_ZN4bbbb6zz4120E");
    check_base_class_offset(lv, (::bbbb::xx20*)(::bbbb::yy120*), 0, "_ZN4bbbb6zz4120E");
    check_base_class_offset(lv, (::bbbb::yy120*), 0, "_ZN4bbbb6zz4120E");
    check_field_offset(lv, fd, ABISELECT(8,4), "_ZN4bbbb6zz4120E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4120E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4120E(Test__ZN4bbbb6zz4120E, "_ZN4bbbb6zz4120E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
extern Class_Descriptor cd__ZN4bbbb5yy120E;
static Base_Class bases__ZN4bbbb6zz4120E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy120E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4120E = {  "_ZN4bbbb6zz4120E", // class name
  bases__ZN4bbbb6zz4120E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy220  : ::bbbb::xx20 {
  short fc;
};
//SIG(-1 _ZN4bbbb5yy220E) C1{ BC2{ BC3{} Fs} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy220E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy220E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb5yy220E, buf);
    ::bbbb::yy220 &lv = *(new (buf) ::bbbb::yy220());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb5yy220E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb5yy220E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*), 0, "_ZN4bbbb5yy220E");
    check_base_class_offset(lv, (::bbbb::xx20*), 0, "_ZN4bbbb5yy220E");
    check_field_offset(lv, fc, 2, "_ZN4bbbb5yy220E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy220E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy220E(Test__ZN4bbbb5yy220E, "_ZN4bbbb5yy220E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
static Base_Class bases__ZN4bbbb5yy220E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy220E = {  "_ZN4bbbb5yy220E", // class name
  bases__ZN4bbbb5yy220E, 2,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0220  : ::bbbb::yy220 {
};
//SIG(1 _ZN4bbbb6zz0220E) C1{ BC2{ BC3{ BC4{} Fs} Fs}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0220E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0220E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb6zz0220E, buf);
    ::bbbb::zz0220 &lv = *(new (buf) ::bbbb::zz0220());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz0220E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz0220E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*)(::bbbb::yy220*), 0, "_ZN4bbbb6zz0220E");
    check_base_class_offset(lv, (::bbbb::xx20*)(::bbbb::yy220*), 0, "_ZN4bbbb6zz0220E");
    check_base_class_offset(lv, (::bbbb::yy220*), 0, "_ZN4bbbb6zz0220E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0220E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0220E(Test__ZN4bbbb6zz0220E, "_ZN4bbbb6zz0220E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
extern Class_Descriptor cd__ZN4bbbb5yy220E;
static Base_Class bases__ZN4bbbb6zz0220E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy220E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0220E = {  "_ZN4bbbb6zz0220E", // class name
  bases__ZN4bbbb6zz0220E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1220  : ::bbbb::yy220 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1220E) C1{ BC2{ BC3{ BC4{} Fs} Fs} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1220E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1220E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb6zz1220E, buf);
    ::bbbb::zz1220 &lv = *(new (buf) ::bbbb::zz1220());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb6zz1220E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz1220E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*)(::bbbb::yy220*), 0, "_ZN4bbbb6zz1220E");
    check_base_class_offset(lv, (::bbbb::xx20*)(::bbbb::yy220*), 0, "_ZN4bbbb6zz1220E");
    check_base_class_offset(lv, (::bbbb::yy220*), 0, "_ZN4bbbb6zz1220E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz1220E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1220E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1220E(Test__ZN4bbbb6zz1220E, "_ZN4bbbb6zz1220E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
extern Class_Descriptor cd__ZN4bbbb5yy220E;
static Base_Class bases__ZN4bbbb6zz1220E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy220E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1220E = {  "_ZN4bbbb6zz1220E", // class name
  bases__ZN4bbbb6zz1220E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2220  : ::bbbb::yy220 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2220E) C1{ BC2{ BC3{ BC4{} Fs} Fs} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2220E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2220E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb6zz2220E, buf);
    ::bbbb::zz2220 &lv = *(new (buf) ::bbbb::zz2220());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb6zz2220E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz2220E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*)(::bbbb::yy220*), 0, "_ZN4bbbb6zz2220E");
    check_base_class_offset(lv, (::bbbb::xx20*)(::bbbb::yy220*), 0, "_ZN4bbbb6zz2220E");
    check_base_class_offset(lv, (::bbbb::yy220*), 0, "_ZN4bbbb6zz2220E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz2220E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2220E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2220E(Test__ZN4bbbb6zz2220E, "_ZN4bbbb6zz2220E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
extern Class_Descriptor cd__ZN4bbbb5yy220E;
static Base_Class bases__ZN4bbbb6zz2220E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy220E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2220E = {  "_ZN4bbbb6zz2220E", // class name
  bases__ZN4bbbb6zz2220E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3220  : ::bbbb::yy220 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3220E) C1{ BC2{ BC3{ BC4{} Fs} Fs} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3220E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3220E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz3220E, buf);
    ::bbbb::zz3220 &lv = *(new (buf) ::bbbb::zz3220());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz3220E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3220E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*)(::bbbb::yy220*), 0, "_ZN4bbbb6zz3220E");
    check_base_class_offset(lv, (::bbbb::xx20*)(::bbbb::yy220*), 0, "_ZN4bbbb6zz3220E");
    check_base_class_offset(lv, (::bbbb::yy220*), 0, "_ZN4bbbb6zz3220E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz3220E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3220E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3220E(Test__ZN4bbbb6zz3220E, "_ZN4bbbb6zz3220E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
extern Class_Descriptor cd__ZN4bbbb5yy220E;
static Base_Class bases__ZN4bbbb6zz3220E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy220E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3220E = {  "_ZN4bbbb6zz3220E", // class name
  bases__ZN4bbbb6zz3220E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4220  : ::bbbb::yy220 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4220E) C1{ BC2{ BC3{ BC4{} Fs} Fs} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4220E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4220E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz4220E, buf);
    ::bbbb::zz4220 &lv = *(new (buf) ::bbbb::zz4220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz4220E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4220E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*)(::bbbb::yy220*), 0, "_ZN4bbbb6zz4220E");
    check_base_class_offset(lv, (::bbbb::xx20*)(::bbbb::yy220*), 0, "_ZN4bbbb6zz4220E");
    check_base_class_offset(lv, (::bbbb::yy220*), 0, "_ZN4bbbb6zz4220E");
    check_field_offset(lv, fd, ABISELECT(8,4), "_ZN4bbbb6zz4220E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4220E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4220E(Test__ZN4bbbb6zz4220E, "_ZN4bbbb6zz4220E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
extern Class_Descriptor cd__ZN4bbbb5yy220E;
static Base_Class bases__ZN4bbbb6zz4220E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy220E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4220E = {  "_ZN4bbbb6zz4220E", // class name
  bases__ZN4bbbb6zz4220E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy320  : ::bbbb::xx20 {
  int fc;
};
//SIG(-1 _ZN4bbbb5yy320E) C1{ BC2{ BC3{} Fs} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy320E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy320E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb5yy320E, buf);
    ::bbbb::yy320 &lv = *(new (buf) ::bbbb::yy320());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb5yy320E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb5yy320E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*), 0, "_ZN4bbbb5yy320E");
    check_base_class_offset(lv, (::bbbb::xx20*), 0, "_ZN4bbbb5yy320E");
    check_field_offset(lv, fc, 4, "_ZN4bbbb5yy320E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy320E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy320E(Test__ZN4bbbb5yy320E, "_ZN4bbbb5yy320E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
static Base_Class bases__ZN4bbbb5yy320E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy320E = {  "_ZN4bbbb5yy320E", // class name
  bases__ZN4bbbb5yy320E, 2,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0320  : ::bbbb::yy320 {
};
//SIG(1 _ZN4bbbb6zz0320E) C1{ BC2{ BC3{ BC4{} Fs} Fi}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0320E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0320E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz0320E, buf);
    ::bbbb::zz0320 &lv = *(new (buf) ::bbbb::zz0320());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz0320E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz0320E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*)(::bbbb::yy320*), 0, "_ZN4bbbb6zz0320E");
    check_base_class_offset(lv, (::bbbb::xx20*)(::bbbb::yy320*), 0, "_ZN4bbbb6zz0320E");
    check_base_class_offset(lv, (::bbbb::yy320*), 0, "_ZN4bbbb6zz0320E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0320E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0320E(Test__ZN4bbbb6zz0320E, "_ZN4bbbb6zz0320E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
extern Class_Descriptor cd__ZN4bbbb5yy320E;
static Base_Class bases__ZN4bbbb6zz0320E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy320E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0320E = {  "_ZN4bbbb6zz0320E", // class name
  bases__ZN4bbbb6zz0320E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1320  : ::bbbb::yy320 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1320E) C1{ BC2{ BC3{ BC4{} Fs} Fi} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1320E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1320E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz1320E, buf);
    ::bbbb::zz1320 &lv = *(new (buf) ::bbbb::zz1320());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz1320E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz1320E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*)(::bbbb::yy320*), 0, "_ZN4bbbb6zz1320E");
    check_base_class_offset(lv, (::bbbb::xx20*)(::bbbb::yy320*), 0, "_ZN4bbbb6zz1320E");
    check_base_class_offset(lv, (::bbbb::yy320*), 0, "_ZN4bbbb6zz1320E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz1320E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1320E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1320E(Test__ZN4bbbb6zz1320E, "_ZN4bbbb6zz1320E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
extern Class_Descriptor cd__ZN4bbbb5yy320E;
static Base_Class bases__ZN4bbbb6zz1320E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy320E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1320E = {  "_ZN4bbbb6zz1320E", // class name
  bases__ZN4bbbb6zz1320E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2320  : ::bbbb::yy320 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2320E) C1{ BC2{ BC3{ BC4{} Fs} Fi} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2320E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2320E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz2320E, buf);
    ::bbbb::zz2320 &lv = *(new (buf) ::bbbb::zz2320());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz2320E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz2320E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*)(::bbbb::yy320*), 0, "_ZN4bbbb6zz2320E");
    check_base_class_offset(lv, (::bbbb::xx20*)(::bbbb::yy320*), 0, "_ZN4bbbb6zz2320E");
    check_base_class_offset(lv, (::bbbb::yy320*), 0, "_ZN4bbbb6zz2320E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz2320E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2320E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2320E(Test__ZN4bbbb6zz2320E, "_ZN4bbbb6zz2320E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
extern Class_Descriptor cd__ZN4bbbb5yy320E;
static Base_Class bases__ZN4bbbb6zz2320E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy320E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2320E = {  "_ZN4bbbb6zz2320E", // class name
  bases__ZN4bbbb6zz2320E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3320  : ::bbbb::yy320 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3320E) C1{ BC2{ BC3{ BC4{} Fs} Fi} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3320E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3320E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz3320E, buf);
    ::bbbb::zz3320 &lv = *(new (buf) ::bbbb::zz3320());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz3320E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3320E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*)(::bbbb::yy320*), 0, "_ZN4bbbb6zz3320E");
    check_base_class_offset(lv, (::bbbb::xx20*)(::bbbb::yy320*), 0, "_ZN4bbbb6zz3320E");
    check_base_class_offset(lv, (::bbbb::yy320*), 0, "_ZN4bbbb6zz3320E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz3320E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3320E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3320E(Test__ZN4bbbb6zz3320E, "_ZN4bbbb6zz3320E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
extern Class_Descriptor cd__ZN4bbbb5yy320E;
static Base_Class bases__ZN4bbbb6zz3320E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy320E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3320E = {  "_ZN4bbbb6zz3320E", // class name
  bases__ZN4bbbb6zz3320E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4320  : ::bbbb::yy320 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4320E) C1{ BC2{ BC3{ BC4{} Fs} Fi} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4320E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4320E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,5)];
    init_test(&cd__ZN4bbbb6zz4320E, buf);
    ::bbbb::zz4320 &lv = *(new (buf) ::bbbb::zz4320());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz4320E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4320E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*)(::bbbb::yy320*), 0, "_ZN4bbbb6zz4320E");
    check_base_class_offset(lv, (::bbbb::xx20*)(::bbbb::yy320*), 0, "_ZN4bbbb6zz4320E");
    check_base_class_offset(lv, (::bbbb::yy320*), 0, "_ZN4bbbb6zz4320E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz4320E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4320E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4320E(Test__ZN4bbbb6zz4320E, "_ZN4bbbb6zz4320E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
extern Class_Descriptor cd__ZN4bbbb5yy320E;
static Base_Class bases__ZN4bbbb6zz4320E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy320E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4320E = {  "_ZN4bbbb6zz4320E", // class name
  bases__ZN4bbbb6zz4320E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy420  : ::bbbb::xx20 {
  double fc;
};
//SIG(-1 _ZN4bbbb5yy420E) C1{ BC2{ BC3{} Fs} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy420E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy420E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb5yy420E, buf);
    ::bbbb::yy420 &lv = *(new (buf) ::bbbb::yy420());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb5yy420E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb5yy420E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*), 0, "_ZN4bbbb5yy420E");
    check_base_class_offset(lv, (::bbbb::xx20*), 0, "_ZN4bbbb5yy420E");
    check_field_offset(lv, fc, ABISELECT(8,4), "_ZN4bbbb5yy420E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy420E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy420E(Test__ZN4bbbb5yy420E, "_ZN4bbbb5yy420E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
static Base_Class bases__ZN4bbbb5yy420E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy420E = {  "_ZN4bbbb5yy420E", // class name
  bases__ZN4bbbb5yy420E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0420  : ::bbbb::yy420 {
};
//SIG(1 _ZN4bbbb6zz0420E) C1{ BC2{ BC3{ BC4{} Fs} FL}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0420E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0420E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz0420E, buf);
    ::bbbb::zz0420 &lv = *(new (buf) ::bbbb::zz0420());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz0420E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz0420E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*)(::bbbb::yy420*), 0, "_ZN4bbbb6zz0420E");
    check_base_class_offset(lv, (::bbbb::xx20*)(::bbbb::yy420*), 0, "_ZN4bbbb6zz0420E");
    check_base_class_offset(lv, (::bbbb::yy420*), 0, "_ZN4bbbb6zz0420E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0420E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0420E(Test__ZN4bbbb6zz0420E, "_ZN4bbbb6zz0420E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
extern Class_Descriptor cd__ZN4bbbb5yy420E;
static Base_Class bases__ZN4bbbb6zz0420E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy420E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0420E = {  "_ZN4bbbb6zz0420E", // class name
  bases__ZN4bbbb6zz0420E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1420  : ::bbbb::yy420 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1420E) C1{ BC2{ BC3{ BC4{} Fs} FL} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1420E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1420E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz1420E, buf);
    ::bbbb::zz1420 &lv = *(new (buf) ::bbbb::zz1420());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz1420E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz1420E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*)(::bbbb::yy420*), 0, "_ZN4bbbb6zz1420E");
    check_base_class_offset(lv, (::bbbb::xx20*)(::bbbb::yy420*), 0, "_ZN4bbbb6zz1420E");
    check_base_class_offset(lv, (::bbbb::yy420*), 0, "_ZN4bbbb6zz1420E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz1420E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1420E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1420E(Test__ZN4bbbb6zz1420E, "_ZN4bbbb6zz1420E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
extern Class_Descriptor cd__ZN4bbbb5yy420E;
static Base_Class bases__ZN4bbbb6zz1420E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy420E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1420E = {  "_ZN4bbbb6zz1420E", // class name
  bases__ZN4bbbb6zz1420E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2420  : ::bbbb::yy420 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2420E) C1{ BC2{ BC3{ BC4{} Fs} FL} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2420E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2420E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz2420E, buf);
    ::bbbb::zz2420 &lv = *(new (buf) ::bbbb::zz2420());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz2420E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz2420E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*)(::bbbb::yy420*), 0, "_ZN4bbbb6zz2420E");
    check_base_class_offset(lv, (::bbbb::xx20*)(::bbbb::yy420*), 0, "_ZN4bbbb6zz2420E");
    check_base_class_offset(lv, (::bbbb::yy420*), 0, "_ZN4bbbb6zz2420E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz2420E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2420E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2420E(Test__ZN4bbbb6zz2420E, "_ZN4bbbb6zz2420E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
extern Class_Descriptor cd__ZN4bbbb5yy420E;
static Base_Class bases__ZN4bbbb6zz2420E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy420E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2420E = {  "_ZN4bbbb6zz2420E", // class name
  bases__ZN4bbbb6zz2420E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3420  : ::bbbb::yy420 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3420E) C1{ BC2{ BC3{ BC4{} Fs} FL} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3420E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3420E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz3420E, buf);
    ::bbbb::zz3420 &lv = *(new (buf) ::bbbb::zz3420());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz3420E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz3420E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*)(::bbbb::yy420*), 0, "_ZN4bbbb6zz3420E");
    check_base_class_offset(lv, (::bbbb::xx20*)(::bbbb::yy420*), 0, "_ZN4bbbb6zz3420E");
    check_base_class_offset(lv, (::bbbb::yy420*), 0, "_ZN4bbbb6zz3420E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz3420E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3420E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3420E(Test__ZN4bbbb6zz3420E, "_ZN4bbbb6zz3420E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
extern Class_Descriptor cd__ZN4bbbb5yy420E;
static Base_Class bases__ZN4bbbb6zz3420E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy420E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3420E = {  "_ZN4bbbb6zz3420E", // class name
  bases__ZN4bbbb6zz3420E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4420  : ::bbbb::yy420 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4420E) C1{ BC2{ BC3{ BC4{} Fs} FL} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4420E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4420E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz4420E, buf);
    ::bbbb::zz4420 &lv = *(new (buf) ::bbbb::zz4420());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz4420E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4420E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx20*)(::bbbb::yy420*), 0, "_ZN4bbbb6zz4420E");
    check_base_class_offset(lv, (::bbbb::xx20*)(::bbbb::yy420*), 0, "_ZN4bbbb6zz4420E");
    check_base_class_offset(lv, (::bbbb::yy420*), 0, "_ZN4bbbb6zz4420E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz4420E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4420E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4420E(Test__ZN4bbbb6zz4420E, "_ZN4bbbb6zz4420E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx20E;
extern Class_Descriptor cd__ZN4bbbb5yy420E;
static Base_Class bases__ZN4bbbb6zz4420E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx20E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy420E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4420E = {  "_ZN4bbbb6zz4420E", // class name
  bases__ZN4bbbb6zz4420E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  xx30  : ::bbbb::ww0 {
  int fb;
};
//SIG(-1 _ZN4bbbb4xx30E) C1{ BC2{} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb4xx30E()
{
  extern Class_Descriptor cd__ZN4bbbb4xx30E;
  void *lvp;
  {
    int buf[2];
    init_test(&cd__ZN4bbbb4xx30E, buf);
    ::bbbb::xx30 &lv = *(new (buf) ::bbbb::xx30());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb4xx30E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb4xx30E)");
    check_base_class_offset(lv, (::bbbb::ww0*), 0, "_ZN4bbbb4xx30E");
    check_field_offset(lv, fb, 0, "_ZN4bbbb4xx30E.fb");
    test_class_info(&lv, &cd__ZN4bbbb4xx30E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb4xx30E(Test__ZN4bbbb4xx30E, "_ZN4bbbb4xx30E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
static Base_Class bases__ZN4bbbb4xx30E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb4xx30E = {  "_ZN4bbbb4xx30E", // class name
  bases__ZN4bbbb4xx30E, 1,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy030  : ::bbbb::xx30 {
};
//SIG(-1 _ZN4bbbb5yy030E) C1{ BC2{ BC3{} Fi}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy030E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy030E;
  void *lvp;
  {
    int buf[2];
    init_test(&cd__ZN4bbbb5yy030E, buf);
    ::bbbb::yy030 &lv = *(new (buf) ::bbbb::yy030());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb5yy030E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb5yy030E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*), 0, "_ZN4bbbb5yy030E");
    check_base_class_offset(lv, (::bbbb::xx30*), 0, "_ZN4bbbb5yy030E");
    test_class_info(&lv, &cd__ZN4bbbb5yy030E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy030E(Test__ZN4bbbb5yy030E, "_ZN4bbbb5yy030E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
static Base_Class bases__ZN4bbbb5yy030E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy030E = {  "_ZN4bbbb5yy030E", // class name
  bases__ZN4bbbb5yy030E, 2,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0030  : ::bbbb::yy030 {
};
//SIG(1 _ZN4bbbb6zz0030E) C1{ BC2{ BC3{ BC4{} Fi}}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0030E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0030E;
  void *lvp;
  {
    int buf[2];
    init_test(&cd__ZN4bbbb6zz0030E, buf);
    ::bbbb::zz0030 &lv = *(new (buf) ::bbbb::zz0030());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz0030E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz0030E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*)(::bbbb::yy030*), 0, "_ZN4bbbb6zz0030E");
    check_base_class_offset(lv, (::bbbb::xx30*)(::bbbb::yy030*), 0, "_ZN4bbbb6zz0030E");
    check_base_class_offset(lv, (::bbbb::yy030*), 0, "_ZN4bbbb6zz0030E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0030E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0030E(Test__ZN4bbbb6zz0030E, "_ZN4bbbb6zz0030E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
extern Class_Descriptor cd__ZN4bbbb5yy030E;
static Base_Class bases__ZN4bbbb6zz0030E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy030E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0030E = {  "_ZN4bbbb6zz0030E", // class name
  bases__ZN4bbbb6zz0030E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1030  : ::bbbb::yy030 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1030E) C1{ BC2{ BC3{ BC4{} Fi}} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1030E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1030E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz1030E, buf);
    ::bbbb::zz1030 &lv = *(new (buf) ::bbbb::zz1030());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz1030E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz1030E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*)(::bbbb::yy030*), 0, "_ZN4bbbb6zz1030E");
    check_base_class_offset(lv, (::bbbb::xx30*)(::bbbb::yy030*), 0, "_ZN4bbbb6zz1030E");
    check_base_class_offset(lv, (::bbbb::yy030*), 0, "_ZN4bbbb6zz1030E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz1030E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1030E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1030E(Test__ZN4bbbb6zz1030E, "_ZN4bbbb6zz1030E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
extern Class_Descriptor cd__ZN4bbbb5yy030E;
static Base_Class bases__ZN4bbbb6zz1030E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy030E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1030E = {  "_ZN4bbbb6zz1030E", // class name
  bases__ZN4bbbb6zz1030E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2030  : ::bbbb::yy030 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2030E) C1{ BC2{ BC3{ BC4{} Fi}} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2030E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2030E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz2030E, buf);
    ::bbbb::zz2030 &lv = *(new (buf) ::bbbb::zz2030());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz2030E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz2030E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*)(::bbbb::yy030*), 0, "_ZN4bbbb6zz2030E");
    check_base_class_offset(lv, (::bbbb::xx30*)(::bbbb::yy030*), 0, "_ZN4bbbb6zz2030E");
    check_base_class_offset(lv, (::bbbb::yy030*), 0, "_ZN4bbbb6zz2030E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz2030E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2030E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2030E(Test__ZN4bbbb6zz2030E, "_ZN4bbbb6zz2030E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
extern Class_Descriptor cd__ZN4bbbb5yy030E;
static Base_Class bases__ZN4bbbb6zz2030E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy030E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2030E = {  "_ZN4bbbb6zz2030E", // class name
  bases__ZN4bbbb6zz2030E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3030  : ::bbbb::yy030 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3030E) C1{ BC2{ BC3{ BC4{} Fi}} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3030E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3030E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz3030E, buf);
    ::bbbb::zz3030 &lv = *(new (buf) ::bbbb::zz3030());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz3030E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3030E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*)(::bbbb::yy030*), 0, "_ZN4bbbb6zz3030E");
    check_base_class_offset(lv, (::bbbb::xx30*)(::bbbb::yy030*), 0, "_ZN4bbbb6zz3030E");
    check_base_class_offset(lv, (::bbbb::yy030*), 0, "_ZN4bbbb6zz3030E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz3030E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3030E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3030E(Test__ZN4bbbb6zz3030E, "_ZN4bbbb6zz3030E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
extern Class_Descriptor cd__ZN4bbbb5yy030E;
static Base_Class bases__ZN4bbbb6zz3030E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy030E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3030E = {  "_ZN4bbbb6zz3030E", // class name
  bases__ZN4bbbb6zz3030E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4030  : ::bbbb::yy030 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4030E) C1{ BC2{ BC3{ BC4{} Fi}} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4030E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4030E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz4030E, buf);
    ::bbbb::zz4030 &lv = *(new (buf) ::bbbb::zz4030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz4030E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4030E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*)(::bbbb::yy030*), 0, "_ZN4bbbb6zz4030E");
    check_base_class_offset(lv, (::bbbb::xx30*)(::bbbb::yy030*), 0, "_ZN4bbbb6zz4030E");
    check_base_class_offset(lv, (::bbbb::yy030*), 0, "_ZN4bbbb6zz4030E");
    check_field_offset(lv, fd, ABISELECT(8,4), "_ZN4bbbb6zz4030E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4030E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4030E(Test__ZN4bbbb6zz4030E, "_ZN4bbbb6zz4030E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
extern Class_Descriptor cd__ZN4bbbb5yy030E;
static Base_Class bases__ZN4bbbb6zz4030E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy030E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4030E = {  "_ZN4bbbb6zz4030E", // class name
  bases__ZN4bbbb6zz4030E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy130  : ::bbbb::xx30 {
  char fc;
};
//SIG(-1 _ZN4bbbb5yy130E) C1{ BC2{ BC3{} Fi} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy130E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy130E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb5yy130E, buf);
    ::bbbb::yy130 &lv = *(new (buf) ::bbbb::yy130());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb5yy130E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb5yy130E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*), 0, "_ZN4bbbb5yy130E");
    check_base_class_offset(lv, (::bbbb::xx30*), 0, "_ZN4bbbb5yy130E");
    check_field_offset(lv, fc, 4, "_ZN4bbbb5yy130E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy130E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy130E(Test__ZN4bbbb5yy130E, "_ZN4bbbb5yy130E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
static Base_Class bases__ZN4bbbb5yy130E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy130E = {  "_ZN4bbbb5yy130E", // class name
  bases__ZN4bbbb5yy130E, 2,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0130  : ::bbbb::yy130 {
};
//SIG(1 _ZN4bbbb6zz0130E) C1{ BC2{ BC3{ BC4{} Fi} Fc}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0130E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0130E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz0130E, buf);
    ::bbbb::zz0130 &lv = *(new (buf) ::bbbb::zz0130());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz0130E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz0130E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*)(::bbbb::yy130*), 0, "_ZN4bbbb6zz0130E");
    check_base_class_offset(lv, (::bbbb::xx30*)(::bbbb::yy130*), 0, "_ZN4bbbb6zz0130E");
    check_base_class_offset(lv, (::bbbb::yy130*), 0, "_ZN4bbbb6zz0130E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0130E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0130E(Test__ZN4bbbb6zz0130E, "_ZN4bbbb6zz0130E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
extern Class_Descriptor cd__ZN4bbbb5yy130E;
static Base_Class bases__ZN4bbbb6zz0130E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy130E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0130E = {  "_ZN4bbbb6zz0130E", // class name
  bases__ZN4bbbb6zz0130E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1130  : ::bbbb::yy130 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1130E) C1{ BC2{ BC3{ BC4{} Fi} Fc} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1130E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1130E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz1130E, buf);
    ::bbbb::zz1130 &lv = *(new (buf) ::bbbb::zz1130());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz1130E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz1130E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*)(::bbbb::yy130*), 0, "_ZN4bbbb6zz1130E");
    check_base_class_offset(lv, (::bbbb::xx30*)(::bbbb::yy130*), 0, "_ZN4bbbb6zz1130E");
    check_base_class_offset(lv, (::bbbb::yy130*), 0, "_ZN4bbbb6zz1130E");
    check_field_offset(lv, fd, 5, "_ZN4bbbb6zz1130E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1130E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1130E(Test__ZN4bbbb6zz1130E, "_ZN4bbbb6zz1130E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
extern Class_Descriptor cd__ZN4bbbb5yy130E;
static Base_Class bases__ZN4bbbb6zz1130E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy130E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1130E = {  "_ZN4bbbb6zz1130E", // class name
  bases__ZN4bbbb6zz1130E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2130  : ::bbbb::yy130 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2130E) C1{ BC2{ BC3{ BC4{} Fi} Fc} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2130E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2130E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz2130E, buf);
    ::bbbb::zz2130 &lv = *(new (buf) ::bbbb::zz2130());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz2130E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz2130E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*)(::bbbb::yy130*), 0, "_ZN4bbbb6zz2130E");
    check_base_class_offset(lv, (::bbbb::xx30*)(::bbbb::yy130*), 0, "_ZN4bbbb6zz2130E");
    check_base_class_offset(lv, (::bbbb::yy130*), 0, "_ZN4bbbb6zz2130E");
    check_field_offset(lv, fd, 6, "_ZN4bbbb6zz2130E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2130E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2130E(Test__ZN4bbbb6zz2130E, "_ZN4bbbb6zz2130E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
extern Class_Descriptor cd__ZN4bbbb5yy130E;
static Base_Class bases__ZN4bbbb6zz2130E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy130E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2130E = {  "_ZN4bbbb6zz2130E", // class name
  bases__ZN4bbbb6zz2130E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3130  : ::bbbb::yy130 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3130E) C1{ BC2{ BC3{ BC4{} Fi} Fc} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3130E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3130E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz3130E, buf);
    ::bbbb::zz3130 &lv = *(new (buf) ::bbbb::zz3130());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz3130E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3130E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*)(::bbbb::yy130*), 0, "_ZN4bbbb6zz3130E");
    check_base_class_offset(lv, (::bbbb::xx30*)(::bbbb::yy130*), 0, "_ZN4bbbb6zz3130E");
    check_base_class_offset(lv, (::bbbb::yy130*), 0, "_ZN4bbbb6zz3130E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz3130E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3130E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3130E(Test__ZN4bbbb6zz3130E, "_ZN4bbbb6zz3130E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
extern Class_Descriptor cd__ZN4bbbb5yy130E;
static Base_Class bases__ZN4bbbb6zz3130E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy130E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3130E = {  "_ZN4bbbb6zz3130E", // class name
  bases__ZN4bbbb6zz3130E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4130  : ::bbbb::yy130 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4130E) C1{ BC2{ BC3{ BC4{} Fi} Fc} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4130E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4130E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,5)];
    init_test(&cd__ZN4bbbb6zz4130E, buf);
    ::bbbb::zz4130 &lv = *(new (buf) ::bbbb::zz4130());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz4130E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4130E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*)(::bbbb::yy130*), 0, "_ZN4bbbb6zz4130E");
    check_base_class_offset(lv, (::bbbb::xx30*)(::bbbb::yy130*), 0, "_ZN4bbbb6zz4130E");
    check_base_class_offset(lv, (::bbbb::yy130*), 0, "_ZN4bbbb6zz4130E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz4130E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4130E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4130E(Test__ZN4bbbb6zz4130E, "_ZN4bbbb6zz4130E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
extern Class_Descriptor cd__ZN4bbbb5yy130E;
static Base_Class bases__ZN4bbbb6zz4130E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy130E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4130E = {  "_ZN4bbbb6zz4130E", // class name
  bases__ZN4bbbb6zz4130E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy230  : ::bbbb::xx30 {
  short fc;
};
//SIG(-1 _ZN4bbbb5yy230E) C1{ BC2{ BC3{} Fi} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy230E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy230E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb5yy230E, buf);
    ::bbbb::yy230 &lv = *(new (buf) ::bbbb::yy230());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb5yy230E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb5yy230E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*), 0, "_ZN4bbbb5yy230E");
    check_base_class_offset(lv, (::bbbb::xx30*), 0, "_ZN4bbbb5yy230E");
    check_field_offset(lv, fc, 4, "_ZN4bbbb5yy230E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy230E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy230E(Test__ZN4bbbb5yy230E, "_ZN4bbbb5yy230E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
static Base_Class bases__ZN4bbbb5yy230E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy230E = {  "_ZN4bbbb5yy230E", // class name
  bases__ZN4bbbb5yy230E, 2,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0230  : ::bbbb::yy230 {
};
//SIG(1 _ZN4bbbb6zz0230E) C1{ BC2{ BC3{ BC4{} Fi} Fs}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0230E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0230E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz0230E, buf);
    ::bbbb::zz0230 &lv = *(new (buf) ::bbbb::zz0230());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz0230E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz0230E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*)(::bbbb::yy230*), 0, "_ZN4bbbb6zz0230E");
    check_base_class_offset(lv, (::bbbb::xx30*)(::bbbb::yy230*), 0, "_ZN4bbbb6zz0230E");
    check_base_class_offset(lv, (::bbbb::yy230*), 0, "_ZN4bbbb6zz0230E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0230E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0230E(Test__ZN4bbbb6zz0230E, "_ZN4bbbb6zz0230E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
extern Class_Descriptor cd__ZN4bbbb5yy230E;
static Base_Class bases__ZN4bbbb6zz0230E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy230E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0230E = {  "_ZN4bbbb6zz0230E", // class name
  bases__ZN4bbbb6zz0230E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1230  : ::bbbb::yy230 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1230E) C1{ BC2{ BC3{ BC4{} Fi} Fs} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1230E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1230E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz1230E, buf);
    ::bbbb::zz1230 &lv = *(new (buf) ::bbbb::zz1230());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz1230E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz1230E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*)(::bbbb::yy230*), 0, "_ZN4bbbb6zz1230E");
    check_base_class_offset(lv, (::bbbb::xx30*)(::bbbb::yy230*), 0, "_ZN4bbbb6zz1230E");
    check_base_class_offset(lv, (::bbbb::yy230*), 0, "_ZN4bbbb6zz1230E");
    check_field_offset(lv, fd, 6, "_ZN4bbbb6zz1230E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1230E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1230E(Test__ZN4bbbb6zz1230E, "_ZN4bbbb6zz1230E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
extern Class_Descriptor cd__ZN4bbbb5yy230E;
static Base_Class bases__ZN4bbbb6zz1230E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy230E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1230E = {  "_ZN4bbbb6zz1230E", // class name
  bases__ZN4bbbb6zz1230E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2230  : ::bbbb::yy230 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2230E) C1{ BC2{ BC3{ BC4{} Fi} Fs} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2230E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2230E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz2230E, buf);
    ::bbbb::zz2230 &lv = *(new (buf) ::bbbb::zz2230());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz2230E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz2230E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*)(::bbbb::yy230*), 0, "_ZN4bbbb6zz2230E");
    check_base_class_offset(lv, (::bbbb::xx30*)(::bbbb::yy230*), 0, "_ZN4bbbb6zz2230E");
    check_base_class_offset(lv, (::bbbb::yy230*), 0, "_ZN4bbbb6zz2230E");
    check_field_offset(lv, fd, 6, "_ZN4bbbb6zz2230E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2230E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2230E(Test__ZN4bbbb6zz2230E, "_ZN4bbbb6zz2230E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
extern Class_Descriptor cd__ZN4bbbb5yy230E;
static Base_Class bases__ZN4bbbb6zz2230E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy230E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2230E = {  "_ZN4bbbb6zz2230E", // class name
  bases__ZN4bbbb6zz2230E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3230  : ::bbbb::yy230 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3230E) C1{ BC2{ BC3{ BC4{} Fi} Fs} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3230E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3230E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz3230E, buf);
    ::bbbb::zz3230 &lv = *(new (buf) ::bbbb::zz3230());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz3230E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3230E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*)(::bbbb::yy230*), 0, "_ZN4bbbb6zz3230E");
    check_base_class_offset(lv, (::bbbb::xx30*)(::bbbb::yy230*), 0, "_ZN4bbbb6zz3230E");
    check_base_class_offset(lv, (::bbbb::yy230*), 0, "_ZN4bbbb6zz3230E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz3230E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3230E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3230E(Test__ZN4bbbb6zz3230E, "_ZN4bbbb6zz3230E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
extern Class_Descriptor cd__ZN4bbbb5yy230E;
static Base_Class bases__ZN4bbbb6zz3230E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy230E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3230E = {  "_ZN4bbbb6zz3230E", // class name
  bases__ZN4bbbb6zz3230E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4230  : ::bbbb::yy230 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4230E) C1{ BC2{ BC3{ BC4{} Fi} Fs} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4230E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4230E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,5)];
    init_test(&cd__ZN4bbbb6zz4230E, buf);
    ::bbbb::zz4230 &lv = *(new (buf) ::bbbb::zz4230());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz4230E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4230E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*)(::bbbb::yy230*), 0, "_ZN4bbbb6zz4230E");
    check_base_class_offset(lv, (::bbbb::xx30*)(::bbbb::yy230*), 0, "_ZN4bbbb6zz4230E");
    check_base_class_offset(lv, (::bbbb::yy230*), 0, "_ZN4bbbb6zz4230E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz4230E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4230E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4230E(Test__ZN4bbbb6zz4230E, "_ZN4bbbb6zz4230E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
extern Class_Descriptor cd__ZN4bbbb5yy230E;
static Base_Class bases__ZN4bbbb6zz4230E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy230E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4230E = {  "_ZN4bbbb6zz4230E", // class name
  bases__ZN4bbbb6zz4230E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy330  : ::bbbb::xx30 {
  int fc;
};
//SIG(-1 _ZN4bbbb5yy330E) C1{ BC2{ BC3{} Fi} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy330E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy330E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb5yy330E, buf);
    ::bbbb::yy330 &lv = *(new (buf) ::bbbb::yy330());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb5yy330E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb5yy330E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*), 0, "_ZN4bbbb5yy330E");
    check_base_class_offset(lv, (::bbbb::xx30*), 0, "_ZN4bbbb5yy330E");
    check_field_offset(lv, fc, 4, "_ZN4bbbb5yy330E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy330E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy330E(Test__ZN4bbbb5yy330E, "_ZN4bbbb5yy330E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
static Base_Class bases__ZN4bbbb5yy330E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy330E = {  "_ZN4bbbb5yy330E", // class name
  bases__ZN4bbbb5yy330E, 2,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0330  : ::bbbb::yy330 {
};
//SIG(1 _ZN4bbbb6zz0330E) C1{ BC2{ BC3{ BC4{} Fi} Fi}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0330E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0330E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz0330E, buf);
    ::bbbb::zz0330 &lv = *(new (buf) ::bbbb::zz0330());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz0330E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz0330E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*)(::bbbb::yy330*), 0, "_ZN4bbbb6zz0330E");
    check_base_class_offset(lv, (::bbbb::xx30*)(::bbbb::yy330*), 0, "_ZN4bbbb6zz0330E");
    check_base_class_offset(lv, (::bbbb::yy330*), 0, "_ZN4bbbb6zz0330E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0330E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0330E(Test__ZN4bbbb6zz0330E, "_ZN4bbbb6zz0330E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
extern Class_Descriptor cd__ZN4bbbb5yy330E;
static Base_Class bases__ZN4bbbb6zz0330E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy330E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0330E = {  "_ZN4bbbb6zz0330E", // class name
  bases__ZN4bbbb6zz0330E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1330  : ::bbbb::yy330 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1330E) C1{ BC2{ BC3{ BC4{} Fi} Fi} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1330E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1330E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz1330E, buf);
    ::bbbb::zz1330 &lv = *(new (buf) ::bbbb::zz1330());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz1330E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz1330E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*)(::bbbb::yy330*), 0, "_ZN4bbbb6zz1330E");
    check_base_class_offset(lv, (::bbbb::xx30*)(::bbbb::yy330*), 0, "_ZN4bbbb6zz1330E");
    check_base_class_offset(lv, (::bbbb::yy330*), 0, "_ZN4bbbb6zz1330E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz1330E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1330E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1330E(Test__ZN4bbbb6zz1330E, "_ZN4bbbb6zz1330E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
extern Class_Descriptor cd__ZN4bbbb5yy330E;
static Base_Class bases__ZN4bbbb6zz1330E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy330E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1330E = {  "_ZN4bbbb6zz1330E", // class name
  bases__ZN4bbbb6zz1330E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2330  : ::bbbb::yy330 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2330E) C1{ BC2{ BC3{ BC4{} Fi} Fi} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2330E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2330E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz2330E, buf);
    ::bbbb::zz2330 &lv = *(new (buf) ::bbbb::zz2330());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz2330E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz2330E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*)(::bbbb::yy330*), 0, "_ZN4bbbb6zz2330E");
    check_base_class_offset(lv, (::bbbb::xx30*)(::bbbb::yy330*), 0, "_ZN4bbbb6zz2330E");
    check_base_class_offset(lv, (::bbbb::yy330*), 0, "_ZN4bbbb6zz2330E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz2330E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2330E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2330E(Test__ZN4bbbb6zz2330E, "_ZN4bbbb6zz2330E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
extern Class_Descriptor cd__ZN4bbbb5yy330E;
static Base_Class bases__ZN4bbbb6zz2330E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy330E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2330E = {  "_ZN4bbbb6zz2330E", // class name
  bases__ZN4bbbb6zz2330E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3330  : ::bbbb::yy330 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3330E) C1{ BC2{ BC3{ BC4{} Fi} Fi} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3330E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3330E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz3330E, buf);
    ::bbbb::zz3330 &lv = *(new (buf) ::bbbb::zz3330());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz3330E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3330E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*)(::bbbb::yy330*), 0, "_ZN4bbbb6zz3330E");
    check_base_class_offset(lv, (::bbbb::xx30*)(::bbbb::yy330*), 0, "_ZN4bbbb6zz3330E");
    check_base_class_offset(lv, (::bbbb::yy330*), 0, "_ZN4bbbb6zz3330E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz3330E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3330E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3330E(Test__ZN4bbbb6zz3330E, "_ZN4bbbb6zz3330E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
extern Class_Descriptor cd__ZN4bbbb5yy330E;
static Base_Class bases__ZN4bbbb6zz3330E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy330E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3330E = {  "_ZN4bbbb6zz3330E", // class name
  bases__ZN4bbbb6zz3330E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4330  : ::bbbb::yy330 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4330E) C1{ BC2{ BC3{ BC4{} Fi} Fi} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4330E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4330E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,5)];
    init_test(&cd__ZN4bbbb6zz4330E, buf);
    ::bbbb::zz4330 &lv = *(new (buf) ::bbbb::zz4330());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz4330E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4330E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*)(::bbbb::yy330*), 0, "_ZN4bbbb6zz4330E");
    check_base_class_offset(lv, (::bbbb::xx30*)(::bbbb::yy330*), 0, "_ZN4bbbb6zz4330E");
    check_base_class_offset(lv, (::bbbb::yy330*), 0, "_ZN4bbbb6zz4330E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz4330E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4330E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4330E(Test__ZN4bbbb6zz4330E, "_ZN4bbbb6zz4330E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
extern Class_Descriptor cd__ZN4bbbb5yy330E;
static Base_Class bases__ZN4bbbb6zz4330E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy330E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4330E = {  "_ZN4bbbb6zz4330E", // class name
  bases__ZN4bbbb6zz4330E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy430  : ::bbbb::xx30 {
  double fc;
};
//SIG(-1 _ZN4bbbb5yy430E) C1{ BC2{ BC3{} Fi} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy430E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy430E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb5yy430E, buf);
    ::bbbb::yy430 &lv = *(new (buf) ::bbbb::yy430());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb5yy430E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb5yy430E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*), 0, "_ZN4bbbb5yy430E");
    check_base_class_offset(lv, (::bbbb::xx30*), 0, "_ZN4bbbb5yy430E");
    check_field_offset(lv, fc, ABISELECT(8,4), "_ZN4bbbb5yy430E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy430E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy430E(Test__ZN4bbbb5yy430E, "_ZN4bbbb5yy430E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
static Base_Class bases__ZN4bbbb5yy430E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy430E = {  "_ZN4bbbb5yy430E", // class name
  bases__ZN4bbbb5yy430E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0430  : ::bbbb::yy430 {
};
//SIG(1 _ZN4bbbb6zz0430E) C1{ BC2{ BC3{ BC4{} Fi} FL}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0430E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0430E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz0430E, buf);
    ::bbbb::zz0430 &lv = *(new (buf) ::bbbb::zz0430());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz0430E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz0430E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*)(::bbbb::yy430*), 0, "_ZN4bbbb6zz0430E");
    check_base_class_offset(lv, (::bbbb::xx30*)(::bbbb::yy430*), 0, "_ZN4bbbb6zz0430E");
    check_base_class_offset(lv, (::bbbb::yy430*), 0, "_ZN4bbbb6zz0430E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0430E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0430E(Test__ZN4bbbb6zz0430E, "_ZN4bbbb6zz0430E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
extern Class_Descriptor cd__ZN4bbbb5yy430E;
static Base_Class bases__ZN4bbbb6zz0430E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy430E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0430E = {  "_ZN4bbbb6zz0430E", // class name
  bases__ZN4bbbb6zz0430E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1430  : ::bbbb::yy430 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1430E) C1{ BC2{ BC3{ BC4{} Fi} FL} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1430E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1430E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz1430E, buf);
    ::bbbb::zz1430 &lv = *(new (buf) ::bbbb::zz1430());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz1430E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz1430E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*)(::bbbb::yy430*), 0, "_ZN4bbbb6zz1430E");
    check_base_class_offset(lv, (::bbbb::xx30*)(::bbbb::yy430*), 0, "_ZN4bbbb6zz1430E");
    check_base_class_offset(lv, (::bbbb::yy430*), 0, "_ZN4bbbb6zz1430E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz1430E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1430E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1430E(Test__ZN4bbbb6zz1430E, "_ZN4bbbb6zz1430E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
extern Class_Descriptor cd__ZN4bbbb5yy430E;
static Base_Class bases__ZN4bbbb6zz1430E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy430E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1430E = {  "_ZN4bbbb6zz1430E", // class name
  bases__ZN4bbbb6zz1430E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2430  : ::bbbb::yy430 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2430E) C1{ BC2{ BC3{ BC4{} Fi} FL} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2430E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2430E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz2430E, buf);
    ::bbbb::zz2430 &lv = *(new (buf) ::bbbb::zz2430());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz2430E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz2430E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*)(::bbbb::yy430*), 0, "_ZN4bbbb6zz2430E");
    check_base_class_offset(lv, (::bbbb::xx30*)(::bbbb::yy430*), 0, "_ZN4bbbb6zz2430E");
    check_base_class_offset(lv, (::bbbb::yy430*), 0, "_ZN4bbbb6zz2430E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz2430E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2430E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2430E(Test__ZN4bbbb6zz2430E, "_ZN4bbbb6zz2430E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
extern Class_Descriptor cd__ZN4bbbb5yy430E;
static Base_Class bases__ZN4bbbb6zz2430E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy430E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2430E = {  "_ZN4bbbb6zz2430E", // class name
  bases__ZN4bbbb6zz2430E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3430  : ::bbbb::yy430 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3430E) C1{ BC2{ BC3{ BC4{} Fi} FL} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3430E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3430E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz3430E, buf);
    ::bbbb::zz3430 &lv = *(new (buf) ::bbbb::zz3430());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz3430E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz3430E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*)(::bbbb::yy430*), 0, "_ZN4bbbb6zz3430E");
    check_base_class_offset(lv, (::bbbb::xx30*)(::bbbb::yy430*), 0, "_ZN4bbbb6zz3430E");
    check_base_class_offset(lv, (::bbbb::yy430*), 0, "_ZN4bbbb6zz3430E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz3430E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3430E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3430E(Test__ZN4bbbb6zz3430E, "_ZN4bbbb6zz3430E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
extern Class_Descriptor cd__ZN4bbbb5yy430E;
static Base_Class bases__ZN4bbbb6zz3430E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy430E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3430E = {  "_ZN4bbbb6zz3430E", // class name
  bases__ZN4bbbb6zz3430E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4430  : ::bbbb::yy430 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4430E) C1{ BC2{ BC3{ BC4{} Fi} FL} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4430E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4430E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz4430E, buf);
    ::bbbb::zz4430 &lv = *(new (buf) ::bbbb::zz4430());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz4430E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4430E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx30*)(::bbbb::yy430*), 0, "_ZN4bbbb6zz4430E");
    check_base_class_offset(lv, (::bbbb::xx30*)(::bbbb::yy430*), 0, "_ZN4bbbb6zz4430E");
    check_base_class_offset(lv, (::bbbb::yy430*), 0, "_ZN4bbbb6zz4430E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz4430E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4430E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4430E(Test__ZN4bbbb6zz4430E, "_ZN4bbbb6zz4430E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx30E;
extern Class_Descriptor cd__ZN4bbbb5yy430E;
static Base_Class bases__ZN4bbbb6zz4430E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx30E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy430E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4430E = {  "_ZN4bbbb6zz4430E", // class name
  bases__ZN4bbbb6zz4430E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  xx40  : ::bbbb::ww0 {
  double fb;
};
//SIG(-1 _ZN4bbbb4xx40E) C1{ BC2{} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb4xx40E()
{
  extern Class_Descriptor cd__ZN4bbbb4xx40E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(2,3)];
    init_test(&cd__ZN4bbbb4xx40E, buf);
    ::bbbb::xx40 &lv = *(new (buf) ::bbbb::xx40());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb4xx40E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb4xx40E)");
    check_base_class_offset(lv, (::bbbb::ww0*), 0, "_ZN4bbbb4xx40E");
    check_field_offset(lv, fb, 0, "_ZN4bbbb4xx40E.fb");
    test_class_info(&lv, &cd__ZN4bbbb4xx40E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb4xx40E(Test__ZN4bbbb4xx40E, "_ZN4bbbb4xx40E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
static Base_Class bases__ZN4bbbb4xx40E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb4xx40E = {  "_ZN4bbbb4xx40E", // class name
  bases__ZN4bbbb4xx40E, 1,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy040  : ::bbbb::xx40 {
};
//SIG(-1 _ZN4bbbb5yy040E) C1{ BC2{ BC3{} FL}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy040E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy040E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(2,3)];
    init_test(&cd__ZN4bbbb5yy040E, buf);
    ::bbbb::yy040 &lv = *(new (buf) ::bbbb::yy040());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb5yy040E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb5yy040E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*), 0, "_ZN4bbbb5yy040E");
    check_base_class_offset(lv, (::bbbb::xx40*), 0, "_ZN4bbbb5yy040E");
    test_class_info(&lv, &cd__ZN4bbbb5yy040E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy040E(Test__ZN4bbbb5yy040E, "_ZN4bbbb5yy040E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
static Base_Class bases__ZN4bbbb5yy040E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy040E = {  "_ZN4bbbb5yy040E", // class name
  bases__ZN4bbbb5yy040E, 2,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0040  : ::bbbb::yy040 {
};
//SIG(1 _ZN4bbbb6zz0040E) C1{ BC2{ BC3{ BC4{} FL}}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0040E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0040E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(2,3)];
    init_test(&cd__ZN4bbbb6zz0040E, buf);
    ::bbbb::zz0040 &lv = *(new (buf) ::bbbb::zz0040());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz0040E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz0040E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*)(::bbbb::yy040*), 0, "_ZN4bbbb6zz0040E");
    check_base_class_offset(lv, (::bbbb::xx40*)(::bbbb::yy040*), 0, "_ZN4bbbb6zz0040E");
    check_base_class_offset(lv, (::bbbb::yy040*), 0, "_ZN4bbbb6zz0040E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0040E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0040E(Test__ZN4bbbb6zz0040E, "_ZN4bbbb6zz0040E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
extern Class_Descriptor cd__ZN4bbbb5yy040E;
static Base_Class bases__ZN4bbbb6zz0040E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy040E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0040E = {  "_ZN4bbbb6zz0040E", // class name
  bases__ZN4bbbb6zz0040E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1040  : ::bbbb::yy040 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1040E) C1{ BC2{ BC3{ BC4{} FL}} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1040E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1040E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz1040E, buf);
    ::bbbb::zz1040 &lv = *(new (buf) ::bbbb::zz1040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz1040E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz1040E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*)(::bbbb::yy040*), 0, "_ZN4bbbb6zz1040E");
    check_base_class_offset(lv, (::bbbb::xx40*)(::bbbb::yy040*), 0, "_ZN4bbbb6zz1040E");
    check_base_class_offset(lv, (::bbbb::yy040*), 0, "_ZN4bbbb6zz1040E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz1040E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1040E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1040E(Test__ZN4bbbb6zz1040E, "_ZN4bbbb6zz1040E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
extern Class_Descriptor cd__ZN4bbbb5yy040E;
static Base_Class bases__ZN4bbbb6zz1040E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy040E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1040E = {  "_ZN4bbbb6zz1040E", // class name
  bases__ZN4bbbb6zz1040E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2040  : ::bbbb::yy040 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2040E) C1{ BC2{ BC3{ BC4{} FL}} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2040E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2040E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz2040E, buf);
    ::bbbb::zz2040 &lv = *(new (buf) ::bbbb::zz2040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz2040E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz2040E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*)(::bbbb::yy040*), 0, "_ZN4bbbb6zz2040E");
    check_base_class_offset(lv, (::bbbb::xx40*)(::bbbb::yy040*), 0, "_ZN4bbbb6zz2040E");
    check_base_class_offset(lv, (::bbbb::yy040*), 0, "_ZN4bbbb6zz2040E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz2040E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2040E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2040E(Test__ZN4bbbb6zz2040E, "_ZN4bbbb6zz2040E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
extern Class_Descriptor cd__ZN4bbbb5yy040E;
static Base_Class bases__ZN4bbbb6zz2040E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy040E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2040E = {  "_ZN4bbbb6zz2040E", // class name
  bases__ZN4bbbb6zz2040E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3040  : ::bbbb::yy040 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3040E) C1{ BC2{ BC3{ BC4{} FL}} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3040E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3040E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz3040E, buf);
    ::bbbb::zz3040 &lv = *(new (buf) ::bbbb::zz3040());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz3040E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz3040E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*)(::bbbb::yy040*), 0, "_ZN4bbbb6zz3040E");
    check_base_class_offset(lv, (::bbbb::xx40*)(::bbbb::yy040*), 0, "_ZN4bbbb6zz3040E");
    check_base_class_offset(lv, (::bbbb::yy040*), 0, "_ZN4bbbb6zz3040E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz3040E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3040E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3040E(Test__ZN4bbbb6zz3040E, "_ZN4bbbb6zz3040E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
extern Class_Descriptor cd__ZN4bbbb5yy040E;
static Base_Class bases__ZN4bbbb6zz3040E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy040E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3040E = {  "_ZN4bbbb6zz3040E", // class name
  bases__ZN4bbbb6zz3040E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4040  : ::bbbb::yy040 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4040E) C1{ BC2{ BC3{ BC4{} FL}} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4040E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4040E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,5)];
    init_test(&cd__ZN4bbbb6zz4040E, buf);
    ::bbbb::zz4040 &lv = *(new (buf) ::bbbb::zz4040());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz4040E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4040E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*)(::bbbb::yy040*), 0, "_ZN4bbbb6zz4040E");
    check_base_class_offset(lv, (::bbbb::xx40*)(::bbbb::yy040*), 0, "_ZN4bbbb6zz4040E");
    check_base_class_offset(lv, (::bbbb::yy040*), 0, "_ZN4bbbb6zz4040E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz4040E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4040E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4040E(Test__ZN4bbbb6zz4040E, "_ZN4bbbb6zz4040E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
extern Class_Descriptor cd__ZN4bbbb5yy040E;
static Base_Class bases__ZN4bbbb6zz4040E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy040E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4040E = {  "_ZN4bbbb6zz4040E", // class name
  bases__ZN4bbbb6zz4040E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy140  : ::bbbb::xx40 {
  char fc;
};
//SIG(-1 _ZN4bbbb5yy140E) C1{ BC2{ BC3{} FL} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy140E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy140E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb5yy140E, buf);
    ::bbbb::yy140 &lv = *(new (buf) ::bbbb::yy140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb5yy140E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb5yy140E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*), 0, "_ZN4bbbb5yy140E");
    check_base_class_offset(lv, (::bbbb::xx40*), 0, "_ZN4bbbb5yy140E");
    check_field_offset(lv, fc, 8, "_ZN4bbbb5yy140E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy140E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy140E(Test__ZN4bbbb5yy140E, "_ZN4bbbb5yy140E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
static Base_Class bases__ZN4bbbb5yy140E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy140E = {  "_ZN4bbbb5yy140E", // class name
  bases__ZN4bbbb5yy140E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0140  : ::bbbb::yy140 {
};
//SIG(1 _ZN4bbbb6zz0140E) C1{ BC2{ BC3{ BC4{} FL} Fc}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0140E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0140E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz0140E, buf);
    ::bbbb::zz0140 &lv = *(new (buf) ::bbbb::zz0140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz0140E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz0140E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*)(::bbbb::yy140*), 0, "_ZN4bbbb6zz0140E");
    check_base_class_offset(lv, (::bbbb::xx40*)(::bbbb::yy140*), 0, "_ZN4bbbb6zz0140E");
    check_base_class_offset(lv, (::bbbb::yy140*), 0, "_ZN4bbbb6zz0140E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0140E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0140E(Test__ZN4bbbb6zz0140E, "_ZN4bbbb6zz0140E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
extern Class_Descriptor cd__ZN4bbbb5yy140E;
static Base_Class bases__ZN4bbbb6zz0140E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy140E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0140E = {  "_ZN4bbbb6zz0140E", // class name
  bases__ZN4bbbb6zz0140E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1140  : ::bbbb::yy140 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1140E) C1{ BC2{ BC3{ BC4{} FL} Fc} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1140E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1140E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz1140E, buf);
    ::bbbb::zz1140 &lv = *(new (buf) ::bbbb::zz1140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz1140E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz1140E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*)(::bbbb::yy140*), 0, "_ZN4bbbb6zz1140E");
    check_base_class_offset(lv, (::bbbb::xx40*)(::bbbb::yy140*), 0, "_ZN4bbbb6zz1140E");
    check_base_class_offset(lv, (::bbbb::yy140*), 0, "_ZN4bbbb6zz1140E");
    check_field_offset(lv, fd, 9, "_ZN4bbbb6zz1140E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1140E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1140E(Test__ZN4bbbb6zz1140E, "_ZN4bbbb6zz1140E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
extern Class_Descriptor cd__ZN4bbbb5yy140E;
static Base_Class bases__ZN4bbbb6zz1140E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy140E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1140E = {  "_ZN4bbbb6zz1140E", // class name
  bases__ZN4bbbb6zz1140E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2140  : ::bbbb::yy140 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2140E) C1{ BC2{ BC3{ BC4{} FL} Fc} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2140E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2140E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz2140E, buf);
    ::bbbb::zz2140 &lv = *(new (buf) ::bbbb::zz2140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz2140E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz2140E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*)(::bbbb::yy140*), 0, "_ZN4bbbb6zz2140E");
    check_base_class_offset(lv, (::bbbb::xx40*)(::bbbb::yy140*), 0, "_ZN4bbbb6zz2140E");
    check_base_class_offset(lv, (::bbbb::yy140*), 0, "_ZN4bbbb6zz2140E");
    check_field_offset(lv, fd, 10, "_ZN4bbbb6zz2140E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2140E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2140E(Test__ZN4bbbb6zz2140E, "_ZN4bbbb6zz2140E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
extern Class_Descriptor cd__ZN4bbbb5yy140E;
static Base_Class bases__ZN4bbbb6zz2140E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy140E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2140E = {  "_ZN4bbbb6zz2140E", // class name
  bases__ZN4bbbb6zz2140E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3140  : ::bbbb::yy140 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3140E) C1{ BC2{ BC3{ BC4{} FL} Fc} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3140E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3140E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,5)];
    init_test(&cd__ZN4bbbb6zz3140E, buf);
    ::bbbb::zz3140 &lv = *(new (buf) ::bbbb::zz3140());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz3140E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz3140E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*)(::bbbb::yy140*), 0, "_ZN4bbbb6zz3140E");
    check_base_class_offset(lv, (::bbbb::xx40*)(::bbbb::yy140*), 0, "_ZN4bbbb6zz3140E");
    check_base_class_offset(lv, (::bbbb::yy140*), 0, "_ZN4bbbb6zz3140E");
    check_field_offset(lv, fd, 12, "_ZN4bbbb6zz3140E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3140E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3140E(Test__ZN4bbbb6zz3140E, "_ZN4bbbb6zz3140E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
extern Class_Descriptor cd__ZN4bbbb5yy140E;
static Base_Class bases__ZN4bbbb6zz3140E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy140E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3140E = {  "_ZN4bbbb6zz3140E", // class name
  bases__ZN4bbbb6zz3140E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4140  : ::bbbb::yy140 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4140E) C1{ BC2{ BC3{ BC4{} FL} Fc} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4140E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4140E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz4140E, buf);
    ::bbbb::zz4140 &lv = *(new (buf) ::bbbb::zz4140());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz4140E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4140E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*)(::bbbb::yy140*), 0, "_ZN4bbbb6zz4140E");
    check_base_class_offset(lv, (::bbbb::xx40*)(::bbbb::yy140*), 0, "_ZN4bbbb6zz4140E");
    check_base_class_offset(lv, (::bbbb::yy140*), 0, "_ZN4bbbb6zz4140E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz4140E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4140E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4140E(Test__ZN4bbbb6zz4140E, "_ZN4bbbb6zz4140E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
extern Class_Descriptor cd__ZN4bbbb5yy140E;
static Base_Class bases__ZN4bbbb6zz4140E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy140E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4140E = {  "_ZN4bbbb6zz4140E", // class name
  bases__ZN4bbbb6zz4140E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy240  : ::bbbb::xx40 {
  short fc;
};
//SIG(-1 _ZN4bbbb5yy240E) C1{ BC2{ BC3{} FL} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy240E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy240E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb5yy240E, buf);
    ::bbbb::yy240 &lv = *(new (buf) ::bbbb::yy240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb5yy240E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb5yy240E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*), 0, "_ZN4bbbb5yy240E");
    check_base_class_offset(lv, (::bbbb::xx40*), 0, "_ZN4bbbb5yy240E");
    check_field_offset(lv, fc, 8, "_ZN4bbbb5yy240E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy240E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy240E(Test__ZN4bbbb5yy240E, "_ZN4bbbb5yy240E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
static Base_Class bases__ZN4bbbb5yy240E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy240E = {  "_ZN4bbbb5yy240E", // class name
  bases__ZN4bbbb5yy240E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0240  : ::bbbb::yy240 {
};
//SIG(1 _ZN4bbbb6zz0240E) C1{ BC2{ BC3{ BC4{} FL} Fs}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0240E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0240E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz0240E, buf);
    ::bbbb::zz0240 &lv = *(new (buf) ::bbbb::zz0240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz0240E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz0240E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*)(::bbbb::yy240*), 0, "_ZN4bbbb6zz0240E");
    check_base_class_offset(lv, (::bbbb::xx40*)(::bbbb::yy240*), 0, "_ZN4bbbb6zz0240E");
    check_base_class_offset(lv, (::bbbb::yy240*), 0, "_ZN4bbbb6zz0240E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0240E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0240E(Test__ZN4bbbb6zz0240E, "_ZN4bbbb6zz0240E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
extern Class_Descriptor cd__ZN4bbbb5yy240E;
static Base_Class bases__ZN4bbbb6zz0240E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy240E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0240E = {  "_ZN4bbbb6zz0240E", // class name
  bases__ZN4bbbb6zz0240E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1240  : ::bbbb::yy240 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1240E) C1{ BC2{ BC3{ BC4{} FL} Fs} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1240E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1240E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz1240E, buf);
    ::bbbb::zz1240 &lv = *(new (buf) ::bbbb::zz1240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz1240E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz1240E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*)(::bbbb::yy240*), 0, "_ZN4bbbb6zz1240E");
    check_base_class_offset(lv, (::bbbb::xx40*)(::bbbb::yy240*), 0, "_ZN4bbbb6zz1240E");
    check_base_class_offset(lv, (::bbbb::yy240*), 0, "_ZN4bbbb6zz1240E");
    check_field_offset(lv, fd, 10, "_ZN4bbbb6zz1240E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1240E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1240E(Test__ZN4bbbb6zz1240E, "_ZN4bbbb6zz1240E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
extern Class_Descriptor cd__ZN4bbbb5yy240E;
static Base_Class bases__ZN4bbbb6zz1240E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy240E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1240E = {  "_ZN4bbbb6zz1240E", // class name
  bases__ZN4bbbb6zz1240E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2240  : ::bbbb::yy240 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2240E) C1{ BC2{ BC3{ BC4{} FL} Fs} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2240E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2240E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz2240E, buf);
    ::bbbb::zz2240 &lv = *(new (buf) ::bbbb::zz2240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz2240E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz2240E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*)(::bbbb::yy240*), 0, "_ZN4bbbb6zz2240E");
    check_base_class_offset(lv, (::bbbb::xx40*)(::bbbb::yy240*), 0, "_ZN4bbbb6zz2240E");
    check_base_class_offset(lv, (::bbbb::yy240*), 0, "_ZN4bbbb6zz2240E");
    check_field_offset(lv, fd, 10, "_ZN4bbbb6zz2240E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2240E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2240E(Test__ZN4bbbb6zz2240E, "_ZN4bbbb6zz2240E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
extern Class_Descriptor cd__ZN4bbbb5yy240E;
static Base_Class bases__ZN4bbbb6zz2240E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy240E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2240E = {  "_ZN4bbbb6zz2240E", // class name
  bases__ZN4bbbb6zz2240E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3240  : ::bbbb::yy240 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3240E) C1{ BC2{ BC3{ BC4{} FL} Fs} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3240E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3240E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,5)];
    init_test(&cd__ZN4bbbb6zz3240E, buf);
    ::bbbb::zz3240 &lv = *(new (buf) ::bbbb::zz3240());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz3240E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz3240E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*)(::bbbb::yy240*), 0, "_ZN4bbbb6zz3240E");
    check_base_class_offset(lv, (::bbbb::xx40*)(::bbbb::yy240*), 0, "_ZN4bbbb6zz3240E");
    check_base_class_offset(lv, (::bbbb::yy240*), 0, "_ZN4bbbb6zz3240E");
    check_field_offset(lv, fd, 12, "_ZN4bbbb6zz3240E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3240E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3240E(Test__ZN4bbbb6zz3240E, "_ZN4bbbb6zz3240E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
extern Class_Descriptor cd__ZN4bbbb5yy240E;
static Base_Class bases__ZN4bbbb6zz3240E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy240E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3240E = {  "_ZN4bbbb6zz3240E", // class name
  bases__ZN4bbbb6zz3240E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4240  : ::bbbb::yy240 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4240E) C1{ BC2{ BC3{ BC4{} FL} Fs} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4240E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4240E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz4240E, buf);
    ::bbbb::zz4240 &lv = *(new (buf) ::bbbb::zz4240());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz4240E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4240E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*)(::bbbb::yy240*), 0, "_ZN4bbbb6zz4240E");
    check_base_class_offset(lv, (::bbbb::xx40*)(::bbbb::yy240*), 0, "_ZN4bbbb6zz4240E");
    check_base_class_offset(lv, (::bbbb::yy240*), 0, "_ZN4bbbb6zz4240E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz4240E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4240E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4240E(Test__ZN4bbbb6zz4240E, "_ZN4bbbb6zz4240E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
extern Class_Descriptor cd__ZN4bbbb5yy240E;
static Base_Class bases__ZN4bbbb6zz4240E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy240E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4240E = {  "_ZN4bbbb6zz4240E", // class name
  bases__ZN4bbbb6zz4240E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy340  : ::bbbb::xx40 {
  int fc;
};
//SIG(-1 _ZN4bbbb5yy340E) C1{ BC2{ BC3{} FL} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy340E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy340E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb5yy340E, buf);
    ::bbbb::yy340 &lv = *(new (buf) ::bbbb::yy340());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb5yy340E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb5yy340E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*), 0, "_ZN4bbbb5yy340E");
    check_base_class_offset(lv, (::bbbb::xx40*), 0, "_ZN4bbbb5yy340E");
    check_field_offset(lv, fc, 8, "_ZN4bbbb5yy340E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy340E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy340E(Test__ZN4bbbb5yy340E, "_ZN4bbbb5yy340E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
static Base_Class bases__ZN4bbbb5yy340E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy340E = {  "_ZN4bbbb5yy340E", // class name
  bases__ZN4bbbb5yy340E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0340  : ::bbbb::yy340 {
};
//SIG(1 _ZN4bbbb6zz0340E) C1{ BC2{ BC3{ BC4{} FL} Fi}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0340E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0340E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz0340E, buf);
    ::bbbb::zz0340 &lv = *(new (buf) ::bbbb::zz0340());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz0340E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz0340E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*)(::bbbb::yy340*), 0, "_ZN4bbbb6zz0340E");
    check_base_class_offset(lv, (::bbbb::xx40*)(::bbbb::yy340*), 0, "_ZN4bbbb6zz0340E");
    check_base_class_offset(lv, (::bbbb::yy340*), 0, "_ZN4bbbb6zz0340E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0340E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0340E(Test__ZN4bbbb6zz0340E, "_ZN4bbbb6zz0340E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
extern Class_Descriptor cd__ZN4bbbb5yy340E;
static Base_Class bases__ZN4bbbb6zz0340E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy340E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0340E = {  "_ZN4bbbb6zz0340E", // class name
  bases__ZN4bbbb6zz0340E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1340  : ::bbbb::yy340 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1340E) C1{ BC2{ BC3{ BC4{} FL} Fi} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1340E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1340E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,5)];
    init_test(&cd__ZN4bbbb6zz1340E, buf);
    ::bbbb::zz1340 &lv = *(new (buf) ::bbbb::zz1340());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz1340E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz1340E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*)(::bbbb::yy340*), 0, "_ZN4bbbb6zz1340E");
    check_base_class_offset(lv, (::bbbb::xx40*)(::bbbb::yy340*), 0, "_ZN4bbbb6zz1340E");
    check_base_class_offset(lv, (::bbbb::yy340*), 0, "_ZN4bbbb6zz1340E");
    check_field_offset(lv, fd, 12, "_ZN4bbbb6zz1340E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1340E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1340E(Test__ZN4bbbb6zz1340E, "_ZN4bbbb6zz1340E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
extern Class_Descriptor cd__ZN4bbbb5yy340E;
static Base_Class bases__ZN4bbbb6zz1340E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy340E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1340E = {  "_ZN4bbbb6zz1340E", // class name
  bases__ZN4bbbb6zz1340E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2340  : ::bbbb::yy340 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2340E) C1{ BC2{ BC3{ BC4{} FL} Fi} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2340E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2340E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,5)];
    init_test(&cd__ZN4bbbb6zz2340E, buf);
    ::bbbb::zz2340 &lv = *(new (buf) ::bbbb::zz2340());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz2340E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz2340E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*)(::bbbb::yy340*), 0, "_ZN4bbbb6zz2340E");
    check_base_class_offset(lv, (::bbbb::xx40*)(::bbbb::yy340*), 0, "_ZN4bbbb6zz2340E");
    check_base_class_offset(lv, (::bbbb::yy340*), 0, "_ZN4bbbb6zz2340E");
    check_field_offset(lv, fd, 12, "_ZN4bbbb6zz2340E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2340E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2340E(Test__ZN4bbbb6zz2340E, "_ZN4bbbb6zz2340E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
extern Class_Descriptor cd__ZN4bbbb5yy340E;
static Base_Class bases__ZN4bbbb6zz2340E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy340E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2340E = {  "_ZN4bbbb6zz2340E", // class name
  bases__ZN4bbbb6zz2340E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3340  : ::bbbb::yy340 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3340E) C1{ BC2{ BC3{ BC4{} FL} Fi} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3340E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3340E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,5)];
    init_test(&cd__ZN4bbbb6zz3340E, buf);
    ::bbbb::zz3340 &lv = *(new (buf) ::bbbb::zz3340());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz3340E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz3340E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*)(::bbbb::yy340*), 0, "_ZN4bbbb6zz3340E");
    check_base_class_offset(lv, (::bbbb::xx40*)(::bbbb::yy340*), 0, "_ZN4bbbb6zz3340E");
    check_base_class_offset(lv, (::bbbb::yy340*), 0, "_ZN4bbbb6zz3340E");
    check_field_offset(lv, fd, 12, "_ZN4bbbb6zz3340E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3340E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3340E(Test__ZN4bbbb6zz3340E, "_ZN4bbbb6zz3340E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
extern Class_Descriptor cd__ZN4bbbb5yy340E;
static Base_Class bases__ZN4bbbb6zz3340E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy340E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3340E = {  "_ZN4bbbb6zz3340E", // class name
  bases__ZN4bbbb6zz3340E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4340  : ::bbbb::yy340 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4340E) C1{ BC2{ BC3{ BC4{} FL} Fi} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4340E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4340E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz4340E, buf);
    ::bbbb::zz4340 &lv = *(new (buf) ::bbbb::zz4340());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz4340E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4340E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*)(::bbbb::yy340*), 0, "_ZN4bbbb6zz4340E");
    check_base_class_offset(lv, (::bbbb::xx40*)(::bbbb::yy340*), 0, "_ZN4bbbb6zz4340E");
    check_base_class_offset(lv, (::bbbb::yy340*), 0, "_ZN4bbbb6zz4340E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz4340E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4340E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4340E(Test__ZN4bbbb6zz4340E, "_ZN4bbbb6zz4340E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
extern Class_Descriptor cd__ZN4bbbb5yy340E;
static Base_Class bases__ZN4bbbb6zz4340E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy340E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4340E = {  "_ZN4bbbb6zz4340E", // class name
  bases__ZN4bbbb6zz4340E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy440  : ::bbbb::xx40 {
  double fc;
};
//SIG(-1 _ZN4bbbb5yy440E) C1{ BC2{ BC3{} FL} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy440E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy440E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,5)];
    init_test(&cd__ZN4bbbb5yy440E, buf);
    ::bbbb::yy440 &lv = *(new (buf) ::bbbb::yy440());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb5yy440E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb5yy440E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*), 0, "_ZN4bbbb5yy440E");
    check_base_class_offset(lv, (::bbbb::xx40*), 0, "_ZN4bbbb5yy440E");
    check_field_offset(lv, fc, 8, "_ZN4bbbb5yy440E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy440E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy440E(Test__ZN4bbbb5yy440E, "_ZN4bbbb5yy440E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
static Base_Class bases__ZN4bbbb5yy440E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy440E = {  "_ZN4bbbb5yy440E", // class name
  bases__ZN4bbbb5yy440E, 2,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0440  : ::bbbb::yy440 {
};
//SIG(1 _ZN4bbbb6zz0440E) C1{ BC2{ BC3{ BC4{} FL} FL}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0440E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0440E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,5)];
    init_test(&cd__ZN4bbbb6zz0440E, buf);
    ::bbbb::zz0440 &lv = *(new (buf) ::bbbb::zz0440());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz0440E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz0440E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*)(::bbbb::yy440*), 0, "_ZN4bbbb6zz0440E");
    check_base_class_offset(lv, (::bbbb::xx40*)(::bbbb::yy440*), 0, "_ZN4bbbb6zz0440E");
    check_base_class_offset(lv, (::bbbb::yy440*), 0, "_ZN4bbbb6zz0440E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0440E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0440E(Test__ZN4bbbb6zz0440E, "_ZN4bbbb6zz0440E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
extern Class_Descriptor cd__ZN4bbbb5yy440E;
static Base_Class bases__ZN4bbbb6zz0440E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy440E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0440E = {  "_ZN4bbbb6zz0440E", // class name
  bases__ZN4bbbb6zz0440E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1440  : ::bbbb::yy440 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1440E) C1{ BC2{ BC3{ BC4{} FL} FL} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1440E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1440E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz1440E, buf);
    ::bbbb::zz1440 &lv = *(new (buf) ::bbbb::zz1440());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz1440E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz1440E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*)(::bbbb::yy440*), 0, "_ZN4bbbb6zz1440E");
    check_base_class_offset(lv, (::bbbb::xx40*)(::bbbb::yy440*), 0, "_ZN4bbbb6zz1440E");
    check_base_class_offset(lv, (::bbbb::yy440*), 0, "_ZN4bbbb6zz1440E");
    check_field_offset(lv, fd, 16, "_ZN4bbbb6zz1440E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1440E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1440E(Test__ZN4bbbb6zz1440E, "_ZN4bbbb6zz1440E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
extern Class_Descriptor cd__ZN4bbbb5yy440E;
static Base_Class bases__ZN4bbbb6zz1440E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy440E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1440E = {  "_ZN4bbbb6zz1440E", // class name
  bases__ZN4bbbb6zz1440E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2440  : ::bbbb::yy440 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2440E) C1{ BC2{ BC3{ BC4{} FL} FL} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2440E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2440E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz2440E, buf);
    ::bbbb::zz2440 &lv = *(new (buf) ::bbbb::zz2440());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz2440E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz2440E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*)(::bbbb::yy440*), 0, "_ZN4bbbb6zz2440E");
    check_base_class_offset(lv, (::bbbb::xx40*)(::bbbb::yy440*), 0, "_ZN4bbbb6zz2440E");
    check_base_class_offset(lv, (::bbbb::yy440*), 0, "_ZN4bbbb6zz2440E");
    check_field_offset(lv, fd, 16, "_ZN4bbbb6zz2440E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2440E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2440E(Test__ZN4bbbb6zz2440E, "_ZN4bbbb6zz2440E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
extern Class_Descriptor cd__ZN4bbbb5yy440E;
static Base_Class bases__ZN4bbbb6zz2440E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy440E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2440E = {  "_ZN4bbbb6zz2440E", // class name
  bases__ZN4bbbb6zz2440E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3440  : ::bbbb::yy440 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3440E) C1{ BC2{ BC3{ BC4{} FL} FL} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3440E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3440E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz3440E, buf);
    ::bbbb::zz3440 &lv = *(new (buf) ::bbbb::zz3440());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz3440E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz3440E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*)(::bbbb::yy440*), 0, "_ZN4bbbb6zz3440E");
    check_base_class_offset(lv, (::bbbb::xx40*)(::bbbb::yy440*), 0, "_ZN4bbbb6zz3440E");
    check_base_class_offset(lv, (::bbbb::yy440*), 0, "_ZN4bbbb6zz3440E");
    check_field_offset(lv, fd, 16, "_ZN4bbbb6zz3440E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3440E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3440E(Test__ZN4bbbb6zz3440E, "_ZN4bbbb6zz3440E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
extern Class_Descriptor cd__ZN4bbbb5yy440E;
static Base_Class bases__ZN4bbbb6zz3440E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy440E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3440E = {  "_ZN4bbbb6zz3440E", // class name
  bases__ZN4bbbb6zz3440E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4440  : ::bbbb::yy440 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4440E) C1{ BC2{ BC3{ BC4{} FL} FL} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4440E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4440E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,7)];
    init_test(&cd__ZN4bbbb6zz4440E, buf);
    ::bbbb::zz4440 &lv = *(new (buf) ::bbbb::zz4440());
    lvp = (void*)&lv;
    check2(sizeof(lv), 24, "sizeof(_ZN4bbbb6zz4440E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4440E)");
    check_base_class_offset(lv, (::bbbb::ww0*)(::bbbb::xx40*)(::bbbb::yy440*), 0, "_ZN4bbbb6zz4440E");
    check_base_class_offset(lv, (::bbbb::xx40*)(::bbbb::yy440*), 0, "_ZN4bbbb6zz4440E");
    check_base_class_offset(lv, (::bbbb::yy440*), 0, "_ZN4bbbb6zz4440E");
    check_field_offset(lv, fd, 16, "_ZN4bbbb6zz4440E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4440E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4440E(Test__ZN4bbbb6zz4440E, "_ZN4bbbb6zz4440E", 24);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww0E;
extern Class_Descriptor cd__ZN4bbbb4xx40E;
extern Class_Descriptor cd__ZN4bbbb5yy440E;
static Base_Class bases__ZN4bbbb6zz4440E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx40E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy440E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4440E = {  "_ZN4bbbb6zz4440E", // class name
  bases__ZN4bbbb6zz4440E, 3,
  0, // no vftv
  0, //no vtt
  24, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  ww1  {
  char fa;
};
//SIG(-1 _ZN4bbbb3ww1E) C1{ Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb3ww1E()
{
  {
    init_simple_test("_ZN4bbbb3ww1E");
    ::bbbb::ww1 lv;
    check2(sizeof(lv), 1, "sizeof(_ZN4bbbb3ww1E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb3ww1E)");
    check_field_offset(lv, fa, 0, "_ZN4bbbb3ww1E.fa");
  }
}
static Arrange_To_Call_Me v_ZN4bbbb3ww1E(Test__ZN4bbbb3ww1E, "_ZN4bbbb3ww1E", 1);

#else // __cplusplus

Class_Descriptor cd__ZN4bbbb3ww1E = {  "_ZN4bbbb3ww1E", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  xx01  : ::bbbb::ww1 {
};
//SIG(-1 _ZN4bbbb4xx01E) C1{ BC2{ Fc}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb4xx01E()
{
  extern Class_Descriptor cd__ZN4bbbb4xx01E;
  void *lvp;
  {
    char buf[1];
    init_test(&cd__ZN4bbbb4xx01E, buf);
    ::bbbb::xx01 &lv = *(new (buf) ::bbbb::xx01());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(_ZN4bbbb4xx01E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb4xx01E)");
    check_base_class_offset(lv, (::bbbb::ww1*), 0, "_ZN4bbbb4xx01E");
    test_class_info(&lv, &cd__ZN4bbbb4xx01E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb4xx01E(Test__ZN4bbbb4xx01E, "_ZN4bbbb4xx01E", 1);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
static Base_Class bases__ZN4bbbb4xx01E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb4xx01E = {  "_ZN4bbbb4xx01E", // class name
  bases__ZN4bbbb4xx01E, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy001  : ::bbbb::xx01 {
};
//SIG(-1 _ZN4bbbb5yy001E) C1{ BC2{ BC3{ Fc}}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy001E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy001E;
  void *lvp;
  {
    char buf[1];
    init_test(&cd__ZN4bbbb5yy001E, buf);
    ::bbbb::yy001 &lv = *(new (buf) ::bbbb::yy001());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(_ZN4bbbb5yy001E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb5yy001E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*), 0, "_ZN4bbbb5yy001E");
    check_base_class_offset(lv, (::bbbb::xx01*), 0, "_ZN4bbbb5yy001E");
    test_class_info(&lv, &cd__ZN4bbbb5yy001E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy001E(Test__ZN4bbbb5yy001E, "_ZN4bbbb5yy001E", 1);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
static Base_Class bases__ZN4bbbb5yy001E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy001E = {  "_ZN4bbbb5yy001E", // class name
  bases__ZN4bbbb5yy001E, 2,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0001  : ::bbbb::yy001 {
};
//SIG(1 _ZN4bbbb6zz0001E) C1{ BC2{ BC3{ BC4{ Fc}}}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0001E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0001E;
  void *lvp;
  {
    char buf[1];
    init_test(&cd__ZN4bbbb6zz0001E, buf);
    ::bbbb::zz0001 &lv = *(new (buf) ::bbbb::zz0001());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(_ZN4bbbb6zz0001E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb6zz0001E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*)(::bbbb::yy001*), 0, "_ZN4bbbb6zz0001E");
    check_base_class_offset(lv, (::bbbb::xx01*)(::bbbb::yy001*), 0, "_ZN4bbbb6zz0001E");
    check_base_class_offset(lv, (::bbbb::yy001*), 0, "_ZN4bbbb6zz0001E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0001E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0001E(Test__ZN4bbbb6zz0001E, "_ZN4bbbb6zz0001E", 1);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
extern Class_Descriptor cd__ZN4bbbb5yy001E;
static Base_Class bases__ZN4bbbb6zz0001E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy001E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0001E = {  "_ZN4bbbb6zz0001E", // class name
  bases__ZN4bbbb6zz0001E, 3,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1001  : ::bbbb::yy001 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1001E) C1{ BC2{ BC3{ BC4{ Fc}}} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1001E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1001E;
  void *lvp;
  {
    char buf[2];
    init_test(&cd__ZN4bbbb6zz1001E, buf);
    ::bbbb::zz1001 &lv = *(new (buf) ::bbbb::zz1001());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4bbbb6zz1001E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb6zz1001E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*)(::bbbb::yy001*), 0, "_ZN4bbbb6zz1001E");
    check_base_class_offset(lv, (::bbbb::xx01*)(::bbbb::yy001*), 0, "_ZN4bbbb6zz1001E");
    check_base_class_offset(lv, (::bbbb::yy001*), 0, "_ZN4bbbb6zz1001E");
    check_field_offset(lv, fd, 1, "_ZN4bbbb6zz1001E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1001E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1001E(Test__ZN4bbbb6zz1001E, "_ZN4bbbb6zz1001E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
extern Class_Descriptor cd__ZN4bbbb5yy001E;
static Base_Class bases__ZN4bbbb6zz1001E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy001E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1001E = {  "_ZN4bbbb6zz1001E", // class name
  bases__ZN4bbbb6zz1001E, 3,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2001  : ::bbbb::yy001 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2001E) C1{ BC2{ BC3{ BC4{ Fc}}} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2001E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2001E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb6zz2001E, buf);
    ::bbbb::zz2001 &lv = *(new (buf) ::bbbb::zz2001());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz2001E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz2001E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*)(::bbbb::yy001*), 0, "_ZN4bbbb6zz2001E");
    check_base_class_offset(lv, (::bbbb::xx01*)(::bbbb::yy001*), 0, "_ZN4bbbb6zz2001E");
    check_base_class_offset(lv, (::bbbb::yy001*), 0, "_ZN4bbbb6zz2001E");
    check_field_offset(lv, fd, 2, "_ZN4bbbb6zz2001E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2001E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2001E(Test__ZN4bbbb6zz2001E, "_ZN4bbbb6zz2001E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
extern Class_Descriptor cd__ZN4bbbb5yy001E;
static Base_Class bases__ZN4bbbb6zz2001E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy001E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2001E = {  "_ZN4bbbb6zz2001E", // class name
  bases__ZN4bbbb6zz2001E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3001  : ::bbbb::yy001 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3001E) C1{ BC2{ BC3{ BC4{ Fc}}} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3001E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3001E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz3001E, buf);
    ::bbbb::zz3001 &lv = *(new (buf) ::bbbb::zz3001());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz3001E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3001E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*)(::bbbb::yy001*), 0, "_ZN4bbbb6zz3001E");
    check_base_class_offset(lv, (::bbbb::xx01*)(::bbbb::yy001*), 0, "_ZN4bbbb6zz3001E");
    check_base_class_offset(lv, (::bbbb::yy001*), 0, "_ZN4bbbb6zz3001E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz3001E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3001E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3001E(Test__ZN4bbbb6zz3001E, "_ZN4bbbb6zz3001E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
extern Class_Descriptor cd__ZN4bbbb5yy001E;
static Base_Class bases__ZN4bbbb6zz3001E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy001E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3001E = {  "_ZN4bbbb6zz3001E", // class name
  bases__ZN4bbbb6zz3001E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4001  : ::bbbb::yy001 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4001E) C1{ BC2{ BC3{ BC4{ Fc}}} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4001E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4001E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz4001E, buf);
    ::bbbb::zz4001 &lv = *(new (buf) ::bbbb::zz4001());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz4001E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4001E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*)(::bbbb::yy001*), 0, "_ZN4bbbb6zz4001E");
    check_base_class_offset(lv, (::bbbb::xx01*)(::bbbb::yy001*), 0, "_ZN4bbbb6zz4001E");
    check_base_class_offset(lv, (::bbbb::yy001*), 0, "_ZN4bbbb6zz4001E");
    check_field_offset(lv, fd, ABISELECT(8,4), "_ZN4bbbb6zz4001E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4001E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4001E(Test__ZN4bbbb6zz4001E, "_ZN4bbbb6zz4001E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
extern Class_Descriptor cd__ZN4bbbb5yy001E;
static Base_Class bases__ZN4bbbb6zz4001E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy001E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4001E = {  "_ZN4bbbb6zz4001E", // class name
  bases__ZN4bbbb6zz4001E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy101  : ::bbbb::xx01 {
  char fc;
};
//SIG(-1 _ZN4bbbb5yy101E) C1{ BC2{ BC3{ Fc}} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy101E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy101E;
  void *lvp;
  {
    char buf[2];
    init_test(&cd__ZN4bbbb5yy101E, buf);
    ::bbbb::yy101 &lv = *(new (buf) ::bbbb::yy101());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4bbbb5yy101E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb5yy101E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*), 0, "_ZN4bbbb5yy101E");
    check_base_class_offset(lv, (::bbbb::xx01*), 0, "_ZN4bbbb5yy101E");
    check_field_offset(lv, fc, 1, "_ZN4bbbb5yy101E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy101E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy101E(Test__ZN4bbbb5yy101E, "_ZN4bbbb5yy101E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
static Base_Class bases__ZN4bbbb5yy101E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy101E = {  "_ZN4bbbb5yy101E", // class name
  bases__ZN4bbbb5yy101E, 2,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0101  : ::bbbb::yy101 {
};
//SIG(1 _ZN4bbbb6zz0101E) C1{ BC2{ BC3{ BC4{ Fc}} Fc}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0101E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0101E;
  void *lvp;
  {
    char buf[2];
    init_test(&cd__ZN4bbbb6zz0101E, buf);
    ::bbbb::zz0101 &lv = *(new (buf) ::bbbb::zz0101());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4bbbb6zz0101E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb6zz0101E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*)(::bbbb::yy101*), 0, "_ZN4bbbb6zz0101E");
    check_base_class_offset(lv, (::bbbb::xx01*)(::bbbb::yy101*), 0, "_ZN4bbbb6zz0101E");
    check_base_class_offset(lv, (::bbbb::yy101*), 0, "_ZN4bbbb6zz0101E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0101E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0101E(Test__ZN4bbbb6zz0101E, "_ZN4bbbb6zz0101E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
extern Class_Descriptor cd__ZN4bbbb5yy101E;
static Base_Class bases__ZN4bbbb6zz0101E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy101E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0101E = {  "_ZN4bbbb6zz0101E", // class name
  bases__ZN4bbbb6zz0101E, 3,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1101  : ::bbbb::yy101 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1101E) C1{ BC2{ BC3{ BC4{ Fc}} Fc} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1101E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1101E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4bbbb6zz1101E, buf);
    ::bbbb::zz1101 &lv = *(new (buf) ::bbbb::zz1101());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4bbbb6zz1101E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb6zz1101E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*)(::bbbb::yy101*), 0, "_ZN4bbbb6zz1101E");
    check_base_class_offset(lv, (::bbbb::xx01*)(::bbbb::yy101*), 0, "_ZN4bbbb6zz1101E");
    check_base_class_offset(lv, (::bbbb::yy101*), 0, "_ZN4bbbb6zz1101E");
    check_field_offset(lv, fd, 2, "_ZN4bbbb6zz1101E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1101E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1101E(Test__ZN4bbbb6zz1101E, "_ZN4bbbb6zz1101E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
extern Class_Descriptor cd__ZN4bbbb5yy101E;
static Base_Class bases__ZN4bbbb6zz1101E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy101E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1101E = {  "_ZN4bbbb6zz1101E", // class name
  bases__ZN4bbbb6zz1101E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2101  : ::bbbb::yy101 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2101E) C1{ BC2{ BC3{ BC4{ Fc}} Fc} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2101E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2101E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb6zz2101E, buf);
    ::bbbb::zz2101 &lv = *(new (buf) ::bbbb::zz2101());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz2101E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz2101E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*)(::bbbb::yy101*), 0, "_ZN4bbbb6zz2101E");
    check_base_class_offset(lv, (::bbbb::xx01*)(::bbbb::yy101*), 0, "_ZN4bbbb6zz2101E");
    check_base_class_offset(lv, (::bbbb::yy101*), 0, "_ZN4bbbb6zz2101E");
    check_field_offset(lv, fd, 2, "_ZN4bbbb6zz2101E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2101E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2101E(Test__ZN4bbbb6zz2101E, "_ZN4bbbb6zz2101E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
extern Class_Descriptor cd__ZN4bbbb5yy101E;
static Base_Class bases__ZN4bbbb6zz2101E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy101E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2101E = {  "_ZN4bbbb6zz2101E", // class name
  bases__ZN4bbbb6zz2101E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3101  : ::bbbb::yy101 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3101E) C1{ BC2{ BC3{ BC4{ Fc}} Fc} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3101E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3101E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz3101E, buf);
    ::bbbb::zz3101 &lv = *(new (buf) ::bbbb::zz3101());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz3101E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3101E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*)(::bbbb::yy101*), 0, "_ZN4bbbb6zz3101E");
    check_base_class_offset(lv, (::bbbb::xx01*)(::bbbb::yy101*), 0, "_ZN4bbbb6zz3101E");
    check_base_class_offset(lv, (::bbbb::yy101*), 0, "_ZN4bbbb6zz3101E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz3101E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3101E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3101E(Test__ZN4bbbb6zz3101E, "_ZN4bbbb6zz3101E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
extern Class_Descriptor cd__ZN4bbbb5yy101E;
static Base_Class bases__ZN4bbbb6zz3101E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy101E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3101E = {  "_ZN4bbbb6zz3101E", // class name
  bases__ZN4bbbb6zz3101E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4101  : ::bbbb::yy101 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4101E) C1{ BC2{ BC3{ BC4{ Fc}} Fc} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4101E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4101E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz4101E, buf);
    ::bbbb::zz4101 &lv = *(new (buf) ::bbbb::zz4101());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz4101E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4101E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*)(::bbbb::yy101*), 0, "_ZN4bbbb6zz4101E");
    check_base_class_offset(lv, (::bbbb::xx01*)(::bbbb::yy101*), 0, "_ZN4bbbb6zz4101E");
    check_base_class_offset(lv, (::bbbb::yy101*), 0, "_ZN4bbbb6zz4101E");
    check_field_offset(lv, fd, ABISELECT(8,4), "_ZN4bbbb6zz4101E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4101E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4101E(Test__ZN4bbbb6zz4101E, "_ZN4bbbb6zz4101E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
extern Class_Descriptor cd__ZN4bbbb5yy101E;
static Base_Class bases__ZN4bbbb6zz4101E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy101E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4101E = {  "_ZN4bbbb6zz4101E", // class name
  bases__ZN4bbbb6zz4101E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy201  : ::bbbb::xx01 {
  short fc;
};
//SIG(-1 _ZN4bbbb5yy201E) C1{ BC2{ BC3{ Fc}} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy201E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy201E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb5yy201E, buf);
    ::bbbb::yy201 &lv = *(new (buf) ::bbbb::yy201());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb5yy201E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb5yy201E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*), 0, "_ZN4bbbb5yy201E");
    check_base_class_offset(lv, (::bbbb::xx01*), 0, "_ZN4bbbb5yy201E");
    check_field_offset(lv, fc, 2, "_ZN4bbbb5yy201E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy201E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy201E(Test__ZN4bbbb5yy201E, "_ZN4bbbb5yy201E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
static Base_Class bases__ZN4bbbb5yy201E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy201E = {  "_ZN4bbbb5yy201E", // class name
  bases__ZN4bbbb5yy201E, 2,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0201  : ::bbbb::yy201 {
};
//SIG(1 _ZN4bbbb6zz0201E) C1{ BC2{ BC3{ BC4{ Fc}} Fs}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0201E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0201E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb6zz0201E, buf);
    ::bbbb::zz0201 &lv = *(new (buf) ::bbbb::zz0201());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz0201E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz0201E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*)(::bbbb::yy201*), 0, "_ZN4bbbb6zz0201E");
    check_base_class_offset(lv, (::bbbb::xx01*)(::bbbb::yy201*), 0, "_ZN4bbbb6zz0201E");
    check_base_class_offset(lv, (::bbbb::yy201*), 0, "_ZN4bbbb6zz0201E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0201E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0201E(Test__ZN4bbbb6zz0201E, "_ZN4bbbb6zz0201E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
extern Class_Descriptor cd__ZN4bbbb5yy201E;
static Base_Class bases__ZN4bbbb6zz0201E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy201E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0201E = {  "_ZN4bbbb6zz0201E", // class name
  bases__ZN4bbbb6zz0201E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1201  : ::bbbb::yy201 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1201E) C1{ BC2{ BC3{ BC4{ Fc}} Fs} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1201E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1201E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb6zz1201E, buf);
    ::bbbb::zz1201 &lv = *(new (buf) ::bbbb::zz1201());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb6zz1201E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz1201E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*)(::bbbb::yy201*), 0, "_ZN4bbbb6zz1201E");
    check_base_class_offset(lv, (::bbbb::xx01*)(::bbbb::yy201*), 0, "_ZN4bbbb6zz1201E");
    check_base_class_offset(lv, (::bbbb::yy201*), 0, "_ZN4bbbb6zz1201E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz1201E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1201E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1201E(Test__ZN4bbbb6zz1201E, "_ZN4bbbb6zz1201E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
extern Class_Descriptor cd__ZN4bbbb5yy201E;
static Base_Class bases__ZN4bbbb6zz1201E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy201E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1201E = {  "_ZN4bbbb6zz1201E", // class name
  bases__ZN4bbbb6zz1201E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2201  : ::bbbb::yy201 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2201E) C1{ BC2{ BC3{ BC4{ Fc}} Fs} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2201E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2201E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb6zz2201E, buf);
    ::bbbb::zz2201 &lv = *(new (buf) ::bbbb::zz2201());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb6zz2201E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz2201E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*)(::bbbb::yy201*), 0, "_ZN4bbbb6zz2201E");
    check_base_class_offset(lv, (::bbbb::xx01*)(::bbbb::yy201*), 0, "_ZN4bbbb6zz2201E");
    check_base_class_offset(lv, (::bbbb::yy201*), 0, "_ZN4bbbb6zz2201E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz2201E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2201E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2201E(Test__ZN4bbbb6zz2201E, "_ZN4bbbb6zz2201E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
extern Class_Descriptor cd__ZN4bbbb5yy201E;
static Base_Class bases__ZN4bbbb6zz2201E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy201E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2201E = {  "_ZN4bbbb6zz2201E", // class name
  bases__ZN4bbbb6zz2201E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3201  : ::bbbb::yy201 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3201E) C1{ BC2{ BC3{ BC4{ Fc}} Fs} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3201E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3201E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz3201E, buf);
    ::bbbb::zz3201 &lv = *(new (buf) ::bbbb::zz3201());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz3201E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3201E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*)(::bbbb::yy201*), 0, "_ZN4bbbb6zz3201E");
    check_base_class_offset(lv, (::bbbb::xx01*)(::bbbb::yy201*), 0, "_ZN4bbbb6zz3201E");
    check_base_class_offset(lv, (::bbbb::yy201*), 0, "_ZN4bbbb6zz3201E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz3201E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3201E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3201E(Test__ZN4bbbb6zz3201E, "_ZN4bbbb6zz3201E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
extern Class_Descriptor cd__ZN4bbbb5yy201E;
static Base_Class bases__ZN4bbbb6zz3201E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy201E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3201E = {  "_ZN4bbbb6zz3201E", // class name
  bases__ZN4bbbb6zz3201E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4201  : ::bbbb::yy201 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4201E) C1{ BC2{ BC3{ BC4{ Fc}} Fs} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4201E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4201E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz4201E, buf);
    ::bbbb::zz4201 &lv = *(new (buf) ::bbbb::zz4201());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz4201E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4201E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*)(::bbbb::yy201*), 0, "_ZN4bbbb6zz4201E");
    check_base_class_offset(lv, (::bbbb::xx01*)(::bbbb::yy201*), 0, "_ZN4bbbb6zz4201E");
    check_base_class_offset(lv, (::bbbb::yy201*), 0, "_ZN4bbbb6zz4201E");
    check_field_offset(lv, fd, ABISELECT(8,4), "_ZN4bbbb6zz4201E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4201E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4201E(Test__ZN4bbbb6zz4201E, "_ZN4bbbb6zz4201E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
extern Class_Descriptor cd__ZN4bbbb5yy201E;
static Base_Class bases__ZN4bbbb6zz4201E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy201E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4201E = {  "_ZN4bbbb6zz4201E", // class name
  bases__ZN4bbbb6zz4201E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy301  : ::bbbb::xx01 {
  int fc;
};
//SIG(-1 _ZN4bbbb5yy301E) C1{ BC2{ BC3{ Fc}} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy301E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy301E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb5yy301E, buf);
    ::bbbb::yy301 &lv = *(new (buf) ::bbbb::yy301());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb5yy301E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb5yy301E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*), 0, "_ZN4bbbb5yy301E");
    check_base_class_offset(lv, (::bbbb::xx01*), 0, "_ZN4bbbb5yy301E");
    check_field_offset(lv, fc, 4, "_ZN4bbbb5yy301E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy301E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy301E(Test__ZN4bbbb5yy301E, "_ZN4bbbb5yy301E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
static Base_Class bases__ZN4bbbb5yy301E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy301E = {  "_ZN4bbbb5yy301E", // class name
  bases__ZN4bbbb5yy301E, 2,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0301  : ::bbbb::yy301 {
};
//SIG(1 _ZN4bbbb6zz0301E) C1{ BC2{ BC3{ BC4{ Fc}} Fi}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0301E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0301E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz0301E, buf);
    ::bbbb::zz0301 &lv = *(new (buf) ::bbbb::zz0301());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz0301E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz0301E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*)(::bbbb::yy301*), 0, "_ZN4bbbb6zz0301E");
    check_base_class_offset(lv, (::bbbb::xx01*)(::bbbb::yy301*), 0, "_ZN4bbbb6zz0301E");
    check_base_class_offset(lv, (::bbbb::yy301*), 0, "_ZN4bbbb6zz0301E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0301E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0301E(Test__ZN4bbbb6zz0301E, "_ZN4bbbb6zz0301E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
extern Class_Descriptor cd__ZN4bbbb5yy301E;
static Base_Class bases__ZN4bbbb6zz0301E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy301E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0301E = {  "_ZN4bbbb6zz0301E", // class name
  bases__ZN4bbbb6zz0301E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1301  : ::bbbb::yy301 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1301E) C1{ BC2{ BC3{ BC4{ Fc}} Fi} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1301E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1301E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz1301E, buf);
    ::bbbb::zz1301 &lv = *(new (buf) ::bbbb::zz1301());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz1301E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz1301E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*)(::bbbb::yy301*), 0, "_ZN4bbbb6zz1301E");
    check_base_class_offset(lv, (::bbbb::xx01*)(::bbbb::yy301*), 0, "_ZN4bbbb6zz1301E");
    check_base_class_offset(lv, (::bbbb::yy301*), 0, "_ZN4bbbb6zz1301E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz1301E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1301E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1301E(Test__ZN4bbbb6zz1301E, "_ZN4bbbb6zz1301E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
extern Class_Descriptor cd__ZN4bbbb5yy301E;
static Base_Class bases__ZN4bbbb6zz1301E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy301E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1301E = {  "_ZN4bbbb6zz1301E", // class name
  bases__ZN4bbbb6zz1301E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2301  : ::bbbb::yy301 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2301E) C1{ BC2{ BC3{ BC4{ Fc}} Fi} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2301E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2301E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz2301E, buf);
    ::bbbb::zz2301 &lv = *(new (buf) ::bbbb::zz2301());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz2301E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz2301E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*)(::bbbb::yy301*), 0, "_ZN4bbbb6zz2301E");
    check_base_class_offset(lv, (::bbbb::xx01*)(::bbbb::yy301*), 0, "_ZN4bbbb6zz2301E");
    check_base_class_offset(lv, (::bbbb::yy301*), 0, "_ZN4bbbb6zz2301E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz2301E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2301E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2301E(Test__ZN4bbbb6zz2301E, "_ZN4bbbb6zz2301E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
extern Class_Descriptor cd__ZN4bbbb5yy301E;
static Base_Class bases__ZN4bbbb6zz2301E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy301E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2301E = {  "_ZN4bbbb6zz2301E", // class name
  bases__ZN4bbbb6zz2301E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3301  : ::bbbb::yy301 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3301E) C1{ BC2{ BC3{ BC4{ Fc}} Fi} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3301E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3301E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz3301E, buf);
    ::bbbb::zz3301 &lv = *(new (buf) ::bbbb::zz3301());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz3301E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3301E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*)(::bbbb::yy301*), 0, "_ZN4bbbb6zz3301E");
    check_base_class_offset(lv, (::bbbb::xx01*)(::bbbb::yy301*), 0, "_ZN4bbbb6zz3301E");
    check_base_class_offset(lv, (::bbbb::yy301*), 0, "_ZN4bbbb6zz3301E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz3301E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3301E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3301E(Test__ZN4bbbb6zz3301E, "_ZN4bbbb6zz3301E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
extern Class_Descriptor cd__ZN4bbbb5yy301E;
static Base_Class bases__ZN4bbbb6zz3301E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy301E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3301E = {  "_ZN4bbbb6zz3301E", // class name
  bases__ZN4bbbb6zz3301E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4301  : ::bbbb::yy301 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4301E) C1{ BC2{ BC3{ BC4{ Fc}} Fi} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4301E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4301E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,5)];
    init_test(&cd__ZN4bbbb6zz4301E, buf);
    ::bbbb::zz4301 &lv = *(new (buf) ::bbbb::zz4301());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz4301E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4301E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*)(::bbbb::yy301*), 0, "_ZN4bbbb6zz4301E");
    check_base_class_offset(lv, (::bbbb::xx01*)(::bbbb::yy301*), 0, "_ZN4bbbb6zz4301E");
    check_base_class_offset(lv, (::bbbb::yy301*), 0, "_ZN4bbbb6zz4301E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz4301E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4301E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4301E(Test__ZN4bbbb6zz4301E, "_ZN4bbbb6zz4301E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
extern Class_Descriptor cd__ZN4bbbb5yy301E;
static Base_Class bases__ZN4bbbb6zz4301E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy301E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4301E = {  "_ZN4bbbb6zz4301E", // class name
  bases__ZN4bbbb6zz4301E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy401  : ::bbbb::xx01 {
  double fc;
};
//SIG(-1 _ZN4bbbb5yy401E) C1{ BC2{ BC3{ Fc}} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy401E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy401E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb5yy401E, buf);
    ::bbbb::yy401 &lv = *(new (buf) ::bbbb::yy401());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb5yy401E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb5yy401E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*), 0, "_ZN4bbbb5yy401E");
    check_base_class_offset(lv, (::bbbb::xx01*), 0, "_ZN4bbbb5yy401E");
    check_field_offset(lv, fc, ABISELECT(8,4), "_ZN4bbbb5yy401E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy401E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy401E(Test__ZN4bbbb5yy401E, "_ZN4bbbb5yy401E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
static Base_Class bases__ZN4bbbb5yy401E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy401E = {  "_ZN4bbbb5yy401E", // class name
  bases__ZN4bbbb5yy401E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0401  : ::bbbb::yy401 {
};
//SIG(1 _ZN4bbbb6zz0401E) C1{ BC2{ BC3{ BC4{ Fc}} FL}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0401E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0401E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz0401E, buf);
    ::bbbb::zz0401 &lv = *(new (buf) ::bbbb::zz0401());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz0401E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz0401E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*)(::bbbb::yy401*), 0, "_ZN4bbbb6zz0401E");
    check_base_class_offset(lv, (::bbbb::xx01*)(::bbbb::yy401*), 0, "_ZN4bbbb6zz0401E");
    check_base_class_offset(lv, (::bbbb::yy401*), 0, "_ZN4bbbb6zz0401E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0401E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0401E(Test__ZN4bbbb6zz0401E, "_ZN4bbbb6zz0401E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
extern Class_Descriptor cd__ZN4bbbb5yy401E;
static Base_Class bases__ZN4bbbb6zz0401E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy401E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0401E = {  "_ZN4bbbb6zz0401E", // class name
  bases__ZN4bbbb6zz0401E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1401  : ::bbbb::yy401 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1401E) C1{ BC2{ BC3{ BC4{ Fc}} FL} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1401E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1401E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz1401E, buf);
    ::bbbb::zz1401 &lv = *(new (buf) ::bbbb::zz1401());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz1401E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz1401E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*)(::bbbb::yy401*), 0, "_ZN4bbbb6zz1401E");
    check_base_class_offset(lv, (::bbbb::xx01*)(::bbbb::yy401*), 0, "_ZN4bbbb6zz1401E");
    check_base_class_offset(lv, (::bbbb::yy401*), 0, "_ZN4bbbb6zz1401E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz1401E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1401E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1401E(Test__ZN4bbbb6zz1401E, "_ZN4bbbb6zz1401E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
extern Class_Descriptor cd__ZN4bbbb5yy401E;
static Base_Class bases__ZN4bbbb6zz1401E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy401E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1401E = {  "_ZN4bbbb6zz1401E", // class name
  bases__ZN4bbbb6zz1401E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2401  : ::bbbb::yy401 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2401E) C1{ BC2{ BC3{ BC4{ Fc}} FL} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2401E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2401E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz2401E, buf);
    ::bbbb::zz2401 &lv = *(new (buf) ::bbbb::zz2401());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz2401E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz2401E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*)(::bbbb::yy401*), 0, "_ZN4bbbb6zz2401E");
    check_base_class_offset(lv, (::bbbb::xx01*)(::bbbb::yy401*), 0, "_ZN4bbbb6zz2401E");
    check_base_class_offset(lv, (::bbbb::yy401*), 0, "_ZN4bbbb6zz2401E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz2401E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2401E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2401E(Test__ZN4bbbb6zz2401E, "_ZN4bbbb6zz2401E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
extern Class_Descriptor cd__ZN4bbbb5yy401E;
static Base_Class bases__ZN4bbbb6zz2401E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy401E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2401E = {  "_ZN4bbbb6zz2401E", // class name
  bases__ZN4bbbb6zz2401E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3401  : ::bbbb::yy401 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3401E) C1{ BC2{ BC3{ BC4{ Fc}} FL} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3401E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3401E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz3401E, buf);
    ::bbbb::zz3401 &lv = *(new (buf) ::bbbb::zz3401());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz3401E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz3401E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*)(::bbbb::yy401*), 0, "_ZN4bbbb6zz3401E");
    check_base_class_offset(lv, (::bbbb::xx01*)(::bbbb::yy401*), 0, "_ZN4bbbb6zz3401E");
    check_base_class_offset(lv, (::bbbb::yy401*), 0, "_ZN4bbbb6zz3401E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz3401E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3401E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3401E(Test__ZN4bbbb6zz3401E, "_ZN4bbbb6zz3401E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
extern Class_Descriptor cd__ZN4bbbb5yy401E;
static Base_Class bases__ZN4bbbb6zz3401E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy401E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3401E = {  "_ZN4bbbb6zz3401E", // class name
  bases__ZN4bbbb6zz3401E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4401  : ::bbbb::yy401 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4401E) C1{ BC2{ BC3{ BC4{ Fc}} FL} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4401E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4401E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz4401E, buf);
    ::bbbb::zz4401 &lv = *(new (buf) ::bbbb::zz4401());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz4401E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4401E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx01*)(::bbbb::yy401*), 0, "_ZN4bbbb6zz4401E");
    check_base_class_offset(lv, (::bbbb::xx01*)(::bbbb::yy401*), 0, "_ZN4bbbb6zz4401E");
    check_base_class_offset(lv, (::bbbb::yy401*), 0, "_ZN4bbbb6zz4401E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz4401E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4401E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4401E(Test__ZN4bbbb6zz4401E, "_ZN4bbbb6zz4401E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx01E;
extern Class_Descriptor cd__ZN4bbbb5yy401E;
static Base_Class bases__ZN4bbbb6zz4401E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx01E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy401E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4401E = {  "_ZN4bbbb6zz4401E", // class name
  bases__ZN4bbbb6zz4401E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  xx11  : ::bbbb::ww1 {
  char fb;
};
//SIG(-1 _ZN4bbbb4xx11E) C1{ BC2{ Fc} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb4xx11E()
{
  extern Class_Descriptor cd__ZN4bbbb4xx11E;
  void *lvp;
  {
    char buf[2];
    init_test(&cd__ZN4bbbb4xx11E, buf);
    ::bbbb::xx11 &lv = *(new (buf) ::bbbb::xx11());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4bbbb4xx11E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb4xx11E)");
    check_base_class_offset(lv, (::bbbb::ww1*), 0, "_ZN4bbbb4xx11E");
    check_field_offset(lv, fb, 1, "_ZN4bbbb4xx11E.fb");
    test_class_info(&lv, &cd__ZN4bbbb4xx11E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb4xx11E(Test__ZN4bbbb4xx11E, "_ZN4bbbb4xx11E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
static Base_Class bases__ZN4bbbb4xx11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb4xx11E = {  "_ZN4bbbb4xx11E", // class name
  bases__ZN4bbbb4xx11E, 1,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy011  : ::bbbb::xx11 {
};
//SIG(-1 _ZN4bbbb5yy011E) C1{ BC2{ BC3{ Fc} Fc}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy011E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy011E;
  void *lvp;
  {
    char buf[2];
    init_test(&cd__ZN4bbbb5yy011E, buf);
    ::bbbb::yy011 &lv = *(new (buf) ::bbbb::yy011());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4bbbb5yy011E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb5yy011E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*), 0, "_ZN4bbbb5yy011E");
    check_base_class_offset(lv, (::bbbb::xx11*), 0, "_ZN4bbbb5yy011E");
    test_class_info(&lv, &cd__ZN4bbbb5yy011E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy011E(Test__ZN4bbbb5yy011E, "_ZN4bbbb5yy011E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
static Base_Class bases__ZN4bbbb5yy011E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy011E = {  "_ZN4bbbb5yy011E", // class name
  bases__ZN4bbbb5yy011E, 2,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0011  : ::bbbb::yy011 {
};
//SIG(1 _ZN4bbbb6zz0011E) C1{ BC2{ BC3{ BC4{ Fc} Fc}}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0011E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0011E;
  void *lvp;
  {
    char buf[2];
    init_test(&cd__ZN4bbbb6zz0011E, buf);
    ::bbbb::zz0011 &lv = *(new (buf) ::bbbb::zz0011());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4bbbb6zz0011E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb6zz0011E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*)(::bbbb::yy011*), 0, "_ZN4bbbb6zz0011E");
    check_base_class_offset(lv, (::bbbb::xx11*)(::bbbb::yy011*), 0, "_ZN4bbbb6zz0011E");
    check_base_class_offset(lv, (::bbbb::yy011*), 0, "_ZN4bbbb6zz0011E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0011E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0011E(Test__ZN4bbbb6zz0011E, "_ZN4bbbb6zz0011E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
extern Class_Descriptor cd__ZN4bbbb5yy011E;
static Base_Class bases__ZN4bbbb6zz0011E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy011E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0011E = {  "_ZN4bbbb6zz0011E", // class name
  bases__ZN4bbbb6zz0011E, 3,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1011  : ::bbbb::yy011 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1011E) C1{ BC2{ BC3{ BC4{ Fc} Fc}} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1011E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1011E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4bbbb6zz1011E, buf);
    ::bbbb::zz1011 &lv = *(new (buf) ::bbbb::zz1011());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4bbbb6zz1011E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb6zz1011E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*)(::bbbb::yy011*), 0, "_ZN4bbbb6zz1011E");
    check_base_class_offset(lv, (::bbbb::xx11*)(::bbbb::yy011*), 0, "_ZN4bbbb6zz1011E");
    check_base_class_offset(lv, (::bbbb::yy011*), 0, "_ZN4bbbb6zz1011E");
    check_field_offset(lv, fd, 2, "_ZN4bbbb6zz1011E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1011E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1011E(Test__ZN4bbbb6zz1011E, "_ZN4bbbb6zz1011E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
extern Class_Descriptor cd__ZN4bbbb5yy011E;
static Base_Class bases__ZN4bbbb6zz1011E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy011E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1011E = {  "_ZN4bbbb6zz1011E", // class name
  bases__ZN4bbbb6zz1011E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2011  : ::bbbb::yy011 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2011E) C1{ BC2{ BC3{ BC4{ Fc} Fc}} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2011E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2011E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb6zz2011E, buf);
    ::bbbb::zz2011 &lv = *(new (buf) ::bbbb::zz2011());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz2011E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz2011E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*)(::bbbb::yy011*), 0, "_ZN4bbbb6zz2011E");
    check_base_class_offset(lv, (::bbbb::xx11*)(::bbbb::yy011*), 0, "_ZN4bbbb6zz2011E");
    check_base_class_offset(lv, (::bbbb::yy011*), 0, "_ZN4bbbb6zz2011E");
    check_field_offset(lv, fd, 2, "_ZN4bbbb6zz2011E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2011E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2011E(Test__ZN4bbbb6zz2011E, "_ZN4bbbb6zz2011E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
extern Class_Descriptor cd__ZN4bbbb5yy011E;
static Base_Class bases__ZN4bbbb6zz2011E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy011E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2011E = {  "_ZN4bbbb6zz2011E", // class name
  bases__ZN4bbbb6zz2011E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3011  : ::bbbb::yy011 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3011E) C1{ BC2{ BC3{ BC4{ Fc} Fc}} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3011E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3011E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz3011E, buf);
    ::bbbb::zz3011 &lv = *(new (buf) ::bbbb::zz3011());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz3011E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3011E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*)(::bbbb::yy011*), 0, "_ZN4bbbb6zz3011E");
    check_base_class_offset(lv, (::bbbb::xx11*)(::bbbb::yy011*), 0, "_ZN4bbbb6zz3011E");
    check_base_class_offset(lv, (::bbbb::yy011*), 0, "_ZN4bbbb6zz3011E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz3011E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3011E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3011E(Test__ZN4bbbb6zz3011E, "_ZN4bbbb6zz3011E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
extern Class_Descriptor cd__ZN4bbbb5yy011E;
static Base_Class bases__ZN4bbbb6zz3011E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy011E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3011E = {  "_ZN4bbbb6zz3011E", // class name
  bases__ZN4bbbb6zz3011E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4011  : ::bbbb::yy011 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4011E) C1{ BC2{ BC3{ BC4{ Fc} Fc}} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4011E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4011E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz4011E, buf);
    ::bbbb::zz4011 &lv = *(new (buf) ::bbbb::zz4011());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz4011E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4011E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*)(::bbbb::yy011*), 0, "_ZN4bbbb6zz4011E");
    check_base_class_offset(lv, (::bbbb::xx11*)(::bbbb::yy011*), 0, "_ZN4bbbb6zz4011E");
    check_base_class_offset(lv, (::bbbb::yy011*), 0, "_ZN4bbbb6zz4011E");
    check_field_offset(lv, fd, ABISELECT(8,4), "_ZN4bbbb6zz4011E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4011E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4011E(Test__ZN4bbbb6zz4011E, "_ZN4bbbb6zz4011E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
extern Class_Descriptor cd__ZN4bbbb5yy011E;
static Base_Class bases__ZN4bbbb6zz4011E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy011E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4011E = {  "_ZN4bbbb6zz4011E", // class name
  bases__ZN4bbbb6zz4011E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy111  : ::bbbb::xx11 {
  char fc;
};
//SIG(-1 _ZN4bbbb5yy111E) C1{ BC2{ BC3{ Fc} Fc} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy111E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy111E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4bbbb5yy111E, buf);
    ::bbbb::yy111 &lv = *(new (buf) ::bbbb::yy111());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4bbbb5yy111E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb5yy111E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*), 0, "_ZN4bbbb5yy111E");
    check_base_class_offset(lv, (::bbbb::xx11*), 0, "_ZN4bbbb5yy111E");
    check_field_offset(lv, fc, 2, "_ZN4bbbb5yy111E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy111E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy111E(Test__ZN4bbbb5yy111E, "_ZN4bbbb5yy111E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
static Base_Class bases__ZN4bbbb5yy111E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy111E = {  "_ZN4bbbb5yy111E", // class name
  bases__ZN4bbbb5yy111E, 2,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0111  : ::bbbb::yy111 {
};
//SIG(1 _ZN4bbbb6zz0111E) C1{ BC2{ BC3{ BC4{ Fc} Fc} Fc}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0111E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0111E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4bbbb6zz0111E, buf);
    ::bbbb::zz0111 &lv = *(new (buf) ::bbbb::zz0111());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4bbbb6zz0111E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb6zz0111E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*)(::bbbb::yy111*), 0, "_ZN4bbbb6zz0111E");
    check_base_class_offset(lv, (::bbbb::xx11*)(::bbbb::yy111*), 0, "_ZN4bbbb6zz0111E");
    check_base_class_offset(lv, (::bbbb::yy111*), 0, "_ZN4bbbb6zz0111E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0111E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0111E(Test__ZN4bbbb6zz0111E, "_ZN4bbbb6zz0111E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
extern Class_Descriptor cd__ZN4bbbb5yy111E;
static Base_Class bases__ZN4bbbb6zz0111E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0111E = {  "_ZN4bbbb6zz0111E", // class name
  bases__ZN4bbbb6zz0111E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1111  : ::bbbb::yy111 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1111E) C1{ BC2{ BC3{ BC4{ Fc} Fc} Fc} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1111E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1111E;
  void *lvp;
  {
    char buf[4];
    init_test(&cd__ZN4bbbb6zz1111E, buf);
    ::bbbb::zz1111 &lv = *(new (buf) ::bbbb::zz1111());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz1111E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4bbbb6zz1111E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*)(::bbbb::yy111*), 0, "_ZN4bbbb6zz1111E");
    check_base_class_offset(lv, (::bbbb::xx11*)(::bbbb::yy111*), 0, "_ZN4bbbb6zz1111E");
    check_base_class_offset(lv, (::bbbb::yy111*), 0, "_ZN4bbbb6zz1111E");
    check_field_offset(lv, fd, 3, "_ZN4bbbb6zz1111E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1111E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1111E(Test__ZN4bbbb6zz1111E, "_ZN4bbbb6zz1111E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
extern Class_Descriptor cd__ZN4bbbb5yy111E;
static Base_Class bases__ZN4bbbb6zz1111E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1111E = {  "_ZN4bbbb6zz1111E", // class name
  bases__ZN4bbbb6zz1111E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2111  : ::bbbb::yy111 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2111E) C1{ BC2{ BC3{ BC4{ Fc} Fc} Fc} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2111E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2111E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb6zz2111E, buf);
    ::bbbb::zz2111 &lv = *(new (buf) ::bbbb::zz2111());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb6zz2111E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz2111E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*)(::bbbb::yy111*), 0, "_ZN4bbbb6zz2111E");
    check_base_class_offset(lv, (::bbbb::xx11*)(::bbbb::yy111*), 0, "_ZN4bbbb6zz2111E");
    check_base_class_offset(lv, (::bbbb::yy111*), 0, "_ZN4bbbb6zz2111E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz2111E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2111E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2111E(Test__ZN4bbbb6zz2111E, "_ZN4bbbb6zz2111E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
extern Class_Descriptor cd__ZN4bbbb5yy111E;
static Base_Class bases__ZN4bbbb6zz2111E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2111E = {  "_ZN4bbbb6zz2111E", // class name
  bases__ZN4bbbb6zz2111E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3111  : ::bbbb::yy111 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3111E) C1{ BC2{ BC3{ BC4{ Fc} Fc} Fc} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3111E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3111E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz3111E, buf);
    ::bbbb::zz3111 &lv = *(new (buf) ::bbbb::zz3111());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz3111E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3111E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*)(::bbbb::yy111*), 0, "_ZN4bbbb6zz3111E");
    check_base_class_offset(lv, (::bbbb::xx11*)(::bbbb::yy111*), 0, "_ZN4bbbb6zz3111E");
    check_base_class_offset(lv, (::bbbb::yy111*), 0, "_ZN4bbbb6zz3111E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz3111E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3111E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3111E(Test__ZN4bbbb6zz3111E, "_ZN4bbbb6zz3111E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
extern Class_Descriptor cd__ZN4bbbb5yy111E;
static Base_Class bases__ZN4bbbb6zz3111E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3111E = {  "_ZN4bbbb6zz3111E", // class name
  bases__ZN4bbbb6zz3111E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4111  : ::bbbb::yy111 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4111E) C1{ BC2{ BC3{ BC4{ Fc} Fc} Fc} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4111E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4111E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz4111E, buf);
    ::bbbb::zz4111 &lv = *(new (buf) ::bbbb::zz4111());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz4111E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4111E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*)(::bbbb::yy111*), 0, "_ZN4bbbb6zz4111E");
    check_base_class_offset(lv, (::bbbb::xx11*)(::bbbb::yy111*), 0, "_ZN4bbbb6zz4111E");
    check_base_class_offset(lv, (::bbbb::yy111*), 0, "_ZN4bbbb6zz4111E");
    check_field_offset(lv, fd, ABISELECT(8,4), "_ZN4bbbb6zz4111E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4111E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4111E(Test__ZN4bbbb6zz4111E, "_ZN4bbbb6zz4111E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
extern Class_Descriptor cd__ZN4bbbb5yy111E;
static Base_Class bases__ZN4bbbb6zz4111E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy111E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4111E = {  "_ZN4bbbb6zz4111E", // class name
  bases__ZN4bbbb6zz4111E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy211  : ::bbbb::xx11 {
  short fc;
};
//SIG(-1 _ZN4bbbb5yy211E) C1{ BC2{ BC3{ Fc} Fc} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy211E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy211E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb5yy211E, buf);
    ::bbbb::yy211 &lv = *(new (buf) ::bbbb::yy211());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb5yy211E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb5yy211E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*), 0, "_ZN4bbbb5yy211E");
    check_base_class_offset(lv, (::bbbb::xx11*), 0, "_ZN4bbbb5yy211E");
    check_field_offset(lv, fc, 2, "_ZN4bbbb5yy211E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy211E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy211E(Test__ZN4bbbb5yy211E, "_ZN4bbbb5yy211E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
static Base_Class bases__ZN4bbbb5yy211E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy211E = {  "_ZN4bbbb5yy211E", // class name
  bases__ZN4bbbb5yy211E, 2,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0211  : ::bbbb::yy211 {
};
//SIG(1 _ZN4bbbb6zz0211E) C1{ BC2{ BC3{ BC4{ Fc} Fc} Fs}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0211E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0211E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb6zz0211E, buf);
    ::bbbb::zz0211 &lv = *(new (buf) ::bbbb::zz0211());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz0211E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz0211E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*)(::bbbb::yy211*), 0, "_ZN4bbbb6zz0211E");
    check_base_class_offset(lv, (::bbbb::xx11*)(::bbbb::yy211*), 0, "_ZN4bbbb6zz0211E");
    check_base_class_offset(lv, (::bbbb::yy211*), 0, "_ZN4bbbb6zz0211E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0211E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0211E(Test__ZN4bbbb6zz0211E, "_ZN4bbbb6zz0211E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
extern Class_Descriptor cd__ZN4bbbb5yy211E;
static Base_Class bases__ZN4bbbb6zz0211E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy211E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0211E = {  "_ZN4bbbb6zz0211E", // class name
  bases__ZN4bbbb6zz0211E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1211  : ::bbbb::yy211 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1211E) C1{ BC2{ BC3{ BC4{ Fc} Fc} Fs} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1211E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1211E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb6zz1211E, buf);
    ::bbbb::zz1211 &lv = *(new (buf) ::bbbb::zz1211());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb6zz1211E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz1211E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*)(::bbbb::yy211*), 0, "_ZN4bbbb6zz1211E");
    check_base_class_offset(lv, (::bbbb::xx11*)(::bbbb::yy211*), 0, "_ZN4bbbb6zz1211E");
    check_base_class_offset(lv, (::bbbb::yy211*), 0, "_ZN4bbbb6zz1211E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz1211E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1211E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1211E(Test__ZN4bbbb6zz1211E, "_ZN4bbbb6zz1211E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
extern Class_Descriptor cd__ZN4bbbb5yy211E;
static Base_Class bases__ZN4bbbb6zz1211E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy211E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1211E = {  "_ZN4bbbb6zz1211E", // class name
  bases__ZN4bbbb6zz1211E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2211  : ::bbbb::yy211 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2211E) C1{ BC2{ BC3{ BC4{ Fc} Fc} Fs} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2211E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2211E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb6zz2211E, buf);
    ::bbbb::zz2211 &lv = *(new (buf) ::bbbb::zz2211());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb6zz2211E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz2211E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*)(::bbbb::yy211*), 0, "_ZN4bbbb6zz2211E");
    check_base_class_offset(lv, (::bbbb::xx11*)(::bbbb::yy211*), 0, "_ZN4bbbb6zz2211E");
    check_base_class_offset(lv, (::bbbb::yy211*), 0, "_ZN4bbbb6zz2211E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz2211E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2211E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2211E(Test__ZN4bbbb6zz2211E, "_ZN4bbbb6zz2211E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
extern Class_Descriptor cd__ZN4bbbb5yy211E;
static Base_Class bases__ZN4bbbb6zz2211E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy211E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2211E = {  "_ZN4bbbb6zz2211E", // class name
  bases__ZN4bbbb6zz2211E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3211  : ::bbbb::yy211 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3211E) C1{ BC2{ BC3{ BC4{ Fc} Fc} Fs} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3211E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3211E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz3211E, buf);
    ::bbbb::zz3211 &lv = *(new (buf) ::bbbb::zz3211());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz3211E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3211E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*)(::bbbb::yy211*), 0, "_ZN4bbbb6zz3211E");
    check_base_class_offset(lv, (::bbbb::xx11*)(::bbbb::yy211*), 0, "_ZN4bbbb6zz3211E");
    check_base_class_offset(lv, (::bbbb::yy211*), 0, "_ZN4bbbb6zz3211E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz3211E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3211E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3211E(Test__ZN4bbbb6zz3211E, "_ZN4bbbb6zz3211E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
extern Class_Descriptor cd__ZN4bbbb5yy211E;
static Base_Class bases__ZN4bbbb6zz3211E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy211E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3211E = {  "_ZN4bbbb6zz3211E", // class name
  bases__ZN4bbbb6zz3211E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4211  : ::bbbb::yy211 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4211E) C1{ BC2{ BC3{ BC4{ Fc} Fc} Fs} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4211E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4211E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz4211E, buf);
    ::bbbb::zz4211 &lv = *(new (buf) ::bbbb::zz4211());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz4211E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4211E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*)(::bbbb::yy211*), 0, "_ZN4bbbb6zz4211E");
    check_base_class_offset(lv, (::bbbb::xx11*)(::bbbb::yy211*), 0, "_ZN4bbbb6zz4211E");
    check_base_class_offset(lv, (::bbbb::yy211*), 0, "_ZN4bbbb6zz4211E");
    check_field_offset(lv, fd, ABISELECT(8,4), "_ZN4bbbb6zz4211E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4211E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4211E(Test__ZN4bbbb6zz4211E, "_ZN4bbbb6zz4211E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
extern Class_Descriptor cd__ZN4bbbb5yy211E;
static Base_Class bases__ZN4bbbb6zz4211E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy211E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4211E = {  "_ZN4bbbb6zz4211E", // class name
  bases__ZN4bbbb6zz4211E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy311  : ::bbbb::xx11 {
  int fc;
};
//SIG(-1 _ZN4bbbb5yy311E) C1{ BC2{ BC3{ Fc} Fc} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy311E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy311E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb5yy311E, buf);
    ::bbbb::yy311 &lv = *(new (buf) ::bbbb::yy311());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb5yy311E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb5yy311E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*), 0, "_ZN4bbbb5yy311E");
    check_base_class_offset(lv, (::bbbb::xx11*), 0, "_ZN4bbbb5yy311E");
    check_field_offset(lv, fc, 4, "_ZN4bbbb5yy311E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy311E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy311E(Test__ZN4bbbb5yy311E, "_ZN4bbbb5yy311E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
static Base_Class bases__ZN4bbbb5yy311E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy311E = {  "_ZN4bbbb5yy311E", // class name
  bases__ZN4bbbb5yy311E, 2,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0311  : ::bbbb::yy311 {
};
//SIG(1 _ZN4bbbb6zz0311E) C1{ BC2{ BC3{ BC4{ Fc} Fc} Fi}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0311E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0311E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz0311E, buf);
    ::bbbb::zz0311 &lv = *(new (buf) ::bbbb::zz0311());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz0311E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz0311E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*)(::bbbb::yy311*), 0, "_ZN4bbbb6zz0311E");
    check_base_class_offset(lv, (::bbbb::xx11*)(::bbbb::yy311*), 0, "_ZN4bbbb6zz0311E");
    check_base_class_offset(lv, (::bbbb::yy311*), 0, "_ZN4bbbb6zz0311E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0311E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0311E(Test__ZN4bbbb6zz0311E, "_ZN4bbbb6zz0311E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
extern Class_Descriptor cd__ZN4bbbb5yy311E;
static Base_Class bases__ZN4bbbb6zz0311E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy311E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0311E = {  "_ZN4bbbb6zz0311E", // class name
  bases__ZN4bbbb6zz0311E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1311  : ::bbbb::yy311 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1311E) C1{ BC2{ BC3{ BC4{ Fc} Fc} Fi} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1311E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1311E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz1311E, buf);
    ::bbbb::zz1311 &lv = *(new (buf) ::bbbb::zz1311());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz1311E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz1311E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*)(::bbbb::yy311*), 0, "_ZN4bbbb6zz1311E");
    check_base_class_offset(lv, (::bbbb::xx11*)(::bbbb::yy311*), 0, "_ZN4bbbb6zz1311E");
    check_base_class_offset(lv, (::bbbb::yy311*), 0, "_ZN4bbbb6zz1311E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz1311E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1311E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1311E(Test__ZN4bbbb6zz1311E, "_ZN4bbbb6zz1311E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
extern Class_Descriptor cd__ZN4bbbb5yy311E;
static Base_Class bases__ZN4bbbb6zz1311E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy311E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1311E = {  "_ZN4bbbb6zz1311E", // class name
  bases__ZN4bbbb6zz1311E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2311  : ::bbbb::yy311 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2311E) C1{ BC2{ BC3{ BC4{ Fc} Fc} Fi} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2311E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2311E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz2311E, buf);
    ::bbbb::zz2311 &lv = *(new (buf) ::bbbb::zz2311());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz2311E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz2311E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*)(::bbbb::yy311*), 0, "_ZN4bbbb6zz2311E");
    check_base_class_offset(lv, (::bbbb::xx11*)(::bbbb::yy311*), 0, "_ZN4bbbb6zz2311E");
    check_base_class_offset(lv, (::bbbb::yy311*), 0, "_ZN4bbbb6zz2311E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz2311E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2311E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2311E(Test__ZN4bbbb6zz2311E, "_ZN4bbbb6zz2311E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
extern Class_Descriptor cd__ZN4bbbb5yy311E;
static Base_Class bases__ZN4bbbb6zz2311E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy311E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2311E = {  "_ZN4bbbb6zz2311E", // class name
  bases__ZN4bbbb6zz2311E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3311  : ::bbbb::yy311 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3311E) C1{ BC2{ BC3{ BC4{ Fc} Fc} Fi} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3311E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3311E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz3311E, buf);
    ::bbbb::zz3311 &lv = *(new (buf) ::bbbb::zz3311());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz3311E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3311E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*)(::bbbb::yy311*), 0, "_ZN4bbbb6zz3311E");
    check_base_class_offset(lv, (::bbbb::xx11*)(::bbbb::yy311*), 0, "_ZN4bbbb6zz3311E");
    check_base_class_offset(lv, (::bbbb::yy311*), 0, "_ZN4bbbb6zz3311E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz3311E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3311E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3311E(Test__ZN4bbbb6zz3311E, "_ZN4bbbb6zz3311E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
extern Class_Descriptor cd__ZN4bbbb5yy311E;
static Base_Class bases__ZN4bbbb6zz3311E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy311E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3311E = {  "_ZN4bbbb6zz3311E", // class name
  bases__ZN4bbbb6zz3311E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4311  : ::bbbb::yy311 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4311E) C1{ BC2{ BC3{ BC4{ Fc} Fc} Fi} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4311E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4311E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,5)];
    init_test(&cd__ZN4bbbb6zz4311E, buf);
    ::bbbb::zz4311 &lv = *(new (buf) ::bbbb::zz4311());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz4311E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4311E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*)(::bbbb::yy311*), 0, "_ZN4bbbb6zz4311E");
    check_base_class_offset(lv, (::bbbb::xx11*)(::bbbb::yy311*), 0, "_ZN4bbbb6zz4311E");
    check_base_class_offset(lv, (::bbbb::yy311*), 0, "_ZN4bbbb6zz4311E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz4311E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4311E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4311E(Test__ZN4bbbb6zz4311E, "_ZN4bbbb6zz4311E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
extern Class_Descriptor cd__ZN4bbbb5yy311E;
static Base_Class bases__ZN4bbbb6zz4311E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy311E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4311E = {  "_ZN4bbbb6zz4311E", // class name
  bases__ZN4bbbb6zz4311E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy411  : ::bbbb::xx11 {
  double fc;
};
//SIG(-1 _ZN4bbbb5yy411E) C1{ BC2{ BC3{ Fc} Fc} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy411E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy411E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb5yy411E, buf);
    ::bbbb::yy411 &lv = *(new (buf) ::bbbb::yy411());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb5yy411E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb5yy411E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*), 0, "_ZN4bbbb5yy411E");
    check_base_class_offset(lv, (::bbbb::xx11*), 0, "_ZN4bbbb5yy411E");
    check_field_offset(lv, fc, ABISELECT(8,4), "_ZN4bbbb5yy411E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy411E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy411E(Test__ZN4bbbb5yy411E, "_ZN4bbbb5yy411E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
static Base_Class bases__ZN4bbbb5yy411E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy411E = {  "_ZN4bbbb5yy411E", // class name
  bases__ZN4bbbb5yy411E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0411  : ::bbbb::yy411 {
};
//SIG(1 _ZN4bbbb6zz0411E) C1{ BC2{ BC3{ BC4{ Fc} Fc} FL}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0411E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0411E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz0411E, buf);
    ::bbbb::zz0411 &lv = *(new (buf) ::bbbb::zz0411());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz0411E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz0411E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*)(::bbbb::yy411*), 0, "_ZN4bbbb6zz0411E");
    check_base_class_offset(lv, (::bbbb::xx11*)(::bbbb::yy411*), 0, "_ZN4bbbb6zz0411E");
    check_base_class_offset(lv, (::bbbb::yy411*), 0, "_ZN4bbbb6zz0411E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0411E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0411E(Test__ZN4bbbb6zz0411E, "_ZN4bbbb6zz0411E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
extern Class_Descriptor cd__ZN4bbbb5yy411E;
static Base_Class bases__ZN4bbbb6zz0411E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy411E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0411E = {  "_ZN4bbbb6zz0411E", // class name
  bases__ZN4bbbb6zz0411E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1411  : ::bbbb::yy411 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1411E) C1{ BC2{ BC3{ BC4{ Fc} Fc} FL} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1411E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1411E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz1411E, buf);
    ::bbbb::zz1411 &lv = *(new (buf) ::bbbb::zz1411());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz1411E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz1411E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*)(::bbbb::yy411*), 0, "_ZN4bbbb6zz1411E");
    check_base_class_offset(lv, (::bbbb::xx11*)(::bbbb::yy411*), 0, "_ZN4bbbb6zz1411E");
    check_base_class_offset(lv, (::bbbb::yy411*), 0, "_ZN4bbbb6zz1411E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz1411E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1411E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1411E(Test__ZN4bbbb6zz1411E, "_ZN4bbbb6zz1411E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
extern Class_Descriptor cd__ZN4bbbb5yy411E;
static Base_Class bases__ZN4bbbb6zz1411E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy411E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1411E = {  "_ZN4bbbb6zz1411E", // class name
  bases__ZN4bbbb6zz1411E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2411  : ::bbbb::yy411 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2411E) C1{ BC2{ BC3{ BC4{ Fc} Fc} FL} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2411E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2411E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz2411E, buf);
    ::bbbb::zz2411 &lv = *(new (buf) ::bbbb::zz2411());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz2411E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz2411E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*)(::bbbb::yy411*), 0, "_ZN4bbbb6zz2411E");
    check_base_class_offset(lv, (::bbbb::xx11*)(::bbbb::yy411*), 0, "_ZN4bbbb6zz2411E");
    check_base_class_offset(lv, (::bbbb::yy411*), 0, "_ZN4bbbb6zz2411E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz2411E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2411E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2411E(Test__ZN4bbbb6zz2411E, "_ZN4bbbb6zz2411E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
extern Class_Descriptor cd__ZN4bbbb5yy411E;
static Base_Class bases__ZN4bbbb6zz2411E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy411E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2411E = {  "_ZN4bbbb6zz2411E", // class name
  bases__ZN4bbbb6zz2411E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3411  : ::bbbb::yy411 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3411E) C1{ BC2{ BC3{ BC4{ Fc} Fc} FL} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3411E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3411E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz3411E, buf);
    ::bbbb::zz3411 &lv = *(new (buf) ::bbbb::zz3411());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz3411E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz3411E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*)(::bbbb::yy411*), 0, "_ZN4bbbb6zz3411E");
    check_base_class_offset(lv, (::bbbb::xx11*)(::bbbb::yy411*), 0, "_ZN4bbbb6zz3411E");
    check_base_class_offset(lv, (::bbbb::yy411*), 0, "_ZN4bbbb6zz3411E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz3411E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3411E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3411E(Test__ZN4bbbb6zz3411E, "_ZN4bbbb6zz3411E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
extern Class_Descriptor cd__ZN4bbbb5yy411E;
static Base_Class bases__ZN4bbbb6zz3411E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy411E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3411E = {  "_ZN4bbbb6zz3411E", // class name
  bases__ZN4bbbb6zz3411E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4411  : ::bbbb::yy411 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4411E) C1{ BC2{ BC3{ BC4{ Fc} Fc} FL} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4411E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4411E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz4411E, buf);
    ::bbbb::zz4411 &lv = *(new (buf) ::bbbb::zz4411());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz4411E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4411E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx11*)(::bbbb::yy411*), 0, "_ZN4bbbb6zz4411E");
    check_base_class_offset(lv, (::bbbb::xx11*)(::bbbb::yy411*), 0, "_ZN4bbbb6zz4411E");
    check_base_class_offset(lv, (::bbbb::yy411*), 0, "_ZN4bbbb6zz4411E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz4411E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4411E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4411E(Test__ZN4bbbb6zz4411E, "_ZN4bbbb6zz4411E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx11E;
extern Class_Descriptor cd__ZN4bbbb5yy411E;
static Base_Class bases__ZN4bbbb6zz4411E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx11E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy411E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4411E = {  "_ZN4bbbb6zz4411E", // class name
  bases__ZN4bbbb6zz4411E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  xx21  : ::bbbb::ww1 {
  short fb;
};
//SIG(-1 _ZN4bbbb4xx21E) C1{ BC2{ Fc} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb4xx21E()
{
  extern Class_Descriptor cd__ZN4bbbb4xx21E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb4xx21E, buf);
    ::bbbb::xx21 &lv = *(new (buf) ::bbbb::xx21());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb4xx21E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb4xx21E)");
    check_base_class_offset(lv, (::bbbb::ww1*), 0, "_ZN4bbbb4xx21E");
    check_field_offset(lv, fb, 2, "_ZN4bbbb4xx21E.fb");
    test_class_info(&lv, &cd__ZN4bbbb4xx21E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb4xx21E(Test__ZN4bbbb4xx21E, "_ZN4bbbb4xx21E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
static Base_Class bases__ZN4bbbb4xx21E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb4xx21E = {  "_ZN4bbbb4xx21E", // class name
  bases__ZN4bbbb4xx21E, 1,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy021  : ::bbbb::xx21 {
};
//SIG(-1 _ZN4bbbb5yy021E) C1{ BC2{ BC3{ Fc} Fs}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy021E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy021E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb5yy021E, buf);
    ::bbbb::yy021 &lv = *(new (buf) ::bbbb::yy021());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb5yy021E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb5yy021E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*), 0, "_ZN4bbbb5yy021E");
    check_base_class_offset(lv, (::bbbb::xx21*), 0, "_ZN4bbbb5yy021E");
    test_class_info(&lv, &cd__ZN4bbbb5yy021E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy021E(Test__ZN4bbbb5yy021E, "_ZN4bbbb5yy021E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
static Base_Class bases__ZN4bbbb5yy021E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy021E = {  "_ZN4bbbb5yy021E", // class name
  bases__ZN4bbbb5yy021E, 2,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0021  : ::bbbb::yy021 {
};
//SIG(1 _ZN4bbbb6zz0021E) C1{ BC2{ BC3{ BC4{ Fc} Fs}}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0021E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0021E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb6zz0021E, buf);
    ::bbbb::zz0021 &lv = *(new (buf) ::bbbb::zz0021());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz0021E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz0021E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*)(::bbbb::yy021*), 0, "_ZN4bbbb6zz0021E");
    check_base_class_offset(lv, (::bbbb::xx21*)(::bbbb::yy021*), 0, "_ZN4bbbb6zz0021E");
    check_base_class_offset(lv, (::bbbb::yy021*), 0, "_ZN4bbbb6zz0021E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0021E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0021E(Test__ZN4bbbb6zz0021E, "_ZN4bbbb6zz0021E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
extern Class_Descriptor cd__ZN4bbbb5yy021E;
static Base_Class bases__ZN4bbbb6zz0021E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy021E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0021E = {  "_ZN4bbbb6zz0021E", // class name
  bases__ZN4bbbb6zz0021E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1021  : ::bbbb::yy021 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1021E) C1{ BC2{ BC3{ BC4{ Fc} Fs}} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1021E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1021E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb6zz1021E, buf);
    ::bbbb::zz1021 &lv = *(new (buf) ::bbbb::zz1021());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb6zz1021E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz1021E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*)(::bbbb::yy021*), 0, "_ZN4bbbb6zz1021E");
    check_base_class_offset(lv, (::bbbb::xx21*)(::bbbb::yy021*), 0, "_ZN4bbbb6zz1021E");
    check_base_class_offset(lv, (::bbbb::yy021*), 0, "_ZN4bbbb6zz1021E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz1021E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1021E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1021E(Test__ZN4bbbb6zz1021E, "_ZN4bbbb6zz1021E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
extern Class_Descriptor cd__ZN4bbbb5yy021E;
static Base_Class bases__ZN4bbbb6zz1021E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy021E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1021E = {  "_ZN4bbbb6zz1021E", // class name
  bases__ZN4bbbb6zz1021E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2021  : ::bbbb::yy021 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2021E) C1{ BC2{ BC3{ BC4{ Fc} Fs}} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2021E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2021E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb6zz2021E, buf);
    ::bbbb::zz2021 &lv = *(new (buf) ::bbbb::zz2021());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb6zz2021E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz2021E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*)(::bbbb::yy021*), 0, "_ZN4bbbb6zz2021E");
    check_base_class_offset(lv, (::bbbb::xx21*)(::bbbb::yy021*), 0, "_ZN4bbbb6zz2021E");
    check_base_class_offset(lv, (::bbbb::yy021*), 0, "_ZN4bbbb6zz2021E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz2021E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2021E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2021E(Test__ZN4bbbb6zz2021E, "_ZN4bbbb6zz2021E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
extern Class_Descriptor cd__ZN4bbbb5yy021E;
static Base_Class bases__ZN4bbbb6zz2021E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy021E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2021E = {  "_ZN4bbbb6zz2021E", // class name
  bases__ZN4bbbb6zz2021E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3021  : ::bbbb::yy021 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3021E) C1{ BC2{ BC3{ BC4{ Fc} Fs}} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3021E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3021E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz3021E, buf);
    ::bbbb::zz3021 &lv = *(new (buf) ::bbbb::zz3021());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz3021E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3021E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*)(::bbbb::yy021*), 0, "_ZN4bbbb6zz3021E");
    check_base_class_offset(lv, (::bbbb::xx21*)(::bbbb::yy021*), 0, "_ZN4bbbb6zz3021E");
    check_base_class_offset(lv, (::bbbb::yy021*), 0, "_ZN4bbbb6zz3021E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz3021E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3021E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3021E(Test__ZN4bbbb6zz3021E, "_ZN4bbbb6zz3021E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
extern Class_Descriptor cd__ZN4bbbb5yy021E;
static Base_Class bases__ZN4bbbb6zz3021E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy021E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3021E = {  "_ZN4bbbb6zz3021E", // class name
  bases__ZN4bbbb6zz3021E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4021  : ::bbbb::yy021 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4021E) C1{ BC2{ BC3{ BC4{ Fc} Fs}} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4021E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4021E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz4021E, buf);
    ::bbbb::zz4021 &lv = *(new (buf) ::bbbb::zz4021());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz4021E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4021E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*)(::bbbb::yy021*), 0, "_ZN4bbbb6zz4021E");
    check_base_class_offset(lv, (::bbbb::xx21*)(::bbbb::yy021*), 0, "_ZN4bbbb6zz4021E");
    check_base_class_offset(lv, (::bbbb::yy021*), 0, "_ZN4bbbb6zz4021E");
    check_field_offset(lv, fd, ABISELECT(8,4), "_ZN4bbbb6zz4021E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4021E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4021E(Test__ZN4bbbb6zz4021E, "_ZN4bbbb6zz4021E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
extern Class_Descriptor cd__ZN4bbbb5yy021E;
static Base_Class bases__ZN4bbbb6zz4021E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy021E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4021E = {  "_ZN4bbbb6zz4021E", // class name
  bases__ZN4bbbb6zz4021E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy121  : ::bbbb::xx21 {
  char fc;
};
//SIG(-1 _ZN4bbbb5yy121E) C1{ BC2{ BC3{ Fc} Fs} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy121E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy121E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb5yy121E, buf);
    ::bbbb::yy121 &lv = *(new (buf) ::bbbb::yy121());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb5yy121E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb5yy121E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*), 0, "_ZN4bbbb5yy121E");
    check_base_class_offset(lv, (::bbbb::xx21*), 0, "_ZN4bbbb5yy121E");
    check_field_offset(lv, fc, 4, "_ZN4bbbb5yy121E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy121E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy121E(Test__ZN4bbbb5yy121E, "_ZN4bbbb5yy121E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
static Base_Class bases__ZN4bbbb5yy121E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy121E = {  "_ZN4bbbb5yy121E", // class name
  bases__ZN4bbbb5yy121E, 2,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0121  : ::bbbb::yy121 {
};
//SIG(1 _ZN4bbbb6zz0121E) C1{ BC2{ BC3{ BC4{ Fc} Fs} Fc}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0121E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0121E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb6zz0121E, buf);
    ::bbbb::zz0121 &lv = *(new (buf) ::bbbb::zz0121());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb6zz0121E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz0121E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*)(::bbbb::yy121*), 0, "_ZN4bbbb6zz0121E");
    check_base_class_offset(lv, (::bbbb::xx21*)(::bbbb::yy121*), 0, "_ZN4bbbb6zz0121E");
    check_base_class_offset(lv, (::bbbb::yy121*), 0, "_ZN4bbbb6zz0121E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0121E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0121E(Test__ZN4bbbb6zz0121E, "_ZN4bbbb6zz0121E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
extern Class_Descriptor cd__ZN4bbbb5yy121E;
static Base_Class bases__ZN4bbbb6zz0121E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy121E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0121E = {  "_ZN4bbbb6zz0121E", // class name
  bases__ZN4bbbb6zz0121E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1121  : ::bbbb::yy121 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1121E) C1{ BC2{ BC3{ BC4{ Fc} Fs} Fc} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1121E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1121E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb6zz1121E, buf);
    ::bbbb::zz1121 &lv = *(new (buf) ::bbbb::zz1121());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb6zz1121E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz1121E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*)(::bbbb::yy121*), 0, "_ZN4bbbb6zz1121E");
    check_base_class_offset(lv, (::bbbb::xx21*)(::bbbb::yy121*), 0, "_ZN4bbbb6zz1121E");
    check_base_class_offset(lv, (::bbbb::yy121*), 0, "_ZN4bbbb6zz1121E");
    check_field_offset(lv, fd, 5, "_ZN4bbbb6zz1121E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1121E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1121E(Test__ZN4bbbb6zz1121E, "_ZN4bbbb6zz1121E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
extern Class_Descriptor cd__ZN4bbbb5yy121E;
static Base_Class bases__ZN4bbbb6zz1121E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy121E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1121E = {  "_ZN4bbbb6zz1121E", // class name
  bases__ZN4bbbb6zz1121E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2121  : ::bbbb::yy121 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2121E) C1{ BC2{ BC3{ BC4{ Fc} Fs} Fc} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2121E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2121E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4bbbb6zz2121E, buf);
    ::bbbb::zz2121 &lv = *(new (buf) ::bbbb::zz2121());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz2121E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz2121E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*)(::bbbb::yy121*), 0, "_ZN4bbbb6zz2121E");
    check_base_class_offset(lv, (::bbbb::xx21*)(::bbbb::yy121*), 0, "_ZN4bbbb6zz2121E");
    check_base_class_offset(lv, (::bbbb::yy121*), 0, "_ZN4bbbb6zz2121E");
    check_field_offset(lv, fd, 6, "_ZN4bbbb6zz2121E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2121E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2121E(Test__ZN4bbbb6zz2121E, "_ZN4bbbb6zz2121E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
extern Class_Descriptor cd__ZN4bbbb5yy121E;
static Base_Class bases__ZN4bbbb6zz2121E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy121E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2121E = {  "_ZN4bbbb6zz2121E", // class name
  bases__ZN4bbbb6zz2121E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3121  : ::bbbb::yy121 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3121E) C1{ BC2{ BC3{ BC4{ Fc} Fs} Fc} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3121E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3121E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz3121E, buf);
    ::bbbb::zz3121 &lv = *(new (buf) ::bbbb::zz3121());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz3121E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3121E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*)(::bbbb::yy121*), 0, "_ZN4bbbb6zz3121E");
    check_base_class_offset(lv, (::bbbb::xx21*)(::bbbb::yy121*), 0, "_ZN4bbbb6zz3121E");
    check_base_class_offset(lv, (::bbbb::yy121*), 0, "_ZN4bbbb6zz3121E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz3121E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3121E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3121E(Test__ZN4bbbb6zz3121E, "_ZN4bbbb6zz3121E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
extern Class_Descriptor cd__ZN4bbbb5yy121E;
static Base_Class bases__ZN4bbbb6zz3121E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy121E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3121E = {  "_ZN4bbbb6zz3121E", // class name
  bases__ZN4bbbb6zz3121E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4121  : ::bbbb::yy121 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4121E) C1{ BC2{ BC3{ BC4{ Fc} Fs} Fc} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4121E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4121E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,5)];
    init_test(&cd__ZN4bbbb6zz4121E, buf);
    ::bbbb::zz4121 &lv = *(new (buf) ::bbbb::zz4121());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz4121E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4121E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*)(::bbbb::yy121*), 0, "_ZN4bbbb6zz4121E");
    check_base_class_offset(lv, (::bbbb::xx21*)(::bbbb::yy121*), 0, "_ZN4bbbb6zz4121E");
    check_base_class_offset(lv, (::bbbb::yy121*), 0, "_ZN4bbbb6zz4121E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz4121E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4121E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4121E(Test__ZN4bbbb6zz4121E, "_ZN4bbbb6zz4121E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
extern Class_Descriptor cd__ZN4bbbb5yy121E;
static Base_Class bases__ZN4bbbb6zz4121E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy121E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4121E = {  "_ZN4bbbb6zz4121E", // class name
  bases__ZN4bbbb6zz4121E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy221  : ::bbbb::xx21 {
  short fc;
};
//SIG(-1 _ZN4bbbb5yy221E) C1{ BC2{ BC3{ Fc} Fs} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy221E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy221E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb5yy221E, buf);
    ::bbbb::yy221 &lv = *(new (buf) ::bbbb::yy221());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb5yy221E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb5yy221E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*), 0, "_ZN4bbbb5yy221E");
    check_base_class_offset(lv, (::bbbb::xx21*), 0, "_ZN4bbbb5yy221E");
    check_field_offset(lv, fc, 4, "_ZN4bbbb5yy221E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy221E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy221E(Test__ZN4bbbb5yy221E, "_ZN4bbbb5yy221E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
static Base_Class bases__ZN4bbbb5yy221E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy221E = {  "_ZN4bbbb5yy221E", // class name
  bases__ZN4bbbb5yy221E, 2,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0221  : ::bbbb::yy221 {
};
//SIG(1 _ZN4bbbb6zz0221E) C1{ BC2{ BC3{ BC4{ Fc} Fs} Fs}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0221E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0221E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb6zz0221E, buf);
    ::bbbb::zz0221 &lv = *(new (buf) ::bbbb::zz0221());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb6zz0221E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz0221E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*)(::bbbb::yy221*), 0, "_ZN4bbbb6zz0221E");
    check_base_class_offset(lv, (::bbbb::xx21*)(::bbbb::yy221*), 0, "_ZN4bbbb6zz0221E");
    check_base_class_offset(lv, (::bbbb::yy221*), 0, "_ZN4bbbb6zz0221E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0221E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0221E(Test__ZN4bbbb6zz0221E, "_ZN4bbbb6zz0221E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
extern Class_Descriptor cd__ZN4bbbb5yy221E;
static Base_Class bases__ZN4bbbb6zz0221E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy221E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0221E = {  "_ZN4bbbb6zz0221E", // class name
  bases__ZN4bbbb6zz0221E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1221  : ::bbbb::yy221 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1221E) C1{ BC2{ BC3{ BC4{ Fc} Fs} Fs} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1221E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1221E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4bbbb6zz1221E, buf);
    ::bbbb::zz1221 &lv = *(new (buf) ::bbbb::zz1221());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz1221E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz1221E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*)(::bbbb::yy221*), 0, "_ZN4bbbb6zz1221E");
    check_base_class_offset(lv, (::bbbb::xx21*)(::bbbb::yy221*), 0, "_ZN4bbbb6zz1221E");
    check_base_class_offset(lv, (::bbbb::yy221*), 0, "_ZN4bbbb6zz1221E");
    check_field_offset(lv, fd, 6, "_ZN4bbbb6zz1221E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1221E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1221E(Test__ZN4bbbb6zz1221E, "_ZN4bbbb6zz1221E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
extern Class_Descriptor cd__ZN4bbbb5yy221E;
static Base_Class bases__ZN4bbbb6zz1221E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy221E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1221E = {  "_ZN4bbbb6zz1221E", // class name
  bases__ZN4bbbb6zz1221E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2221  : ::bbbb::yy221 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2221E) C1{ BC2{ BC3{ BC4{ Fc} Fs} Fs} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2221E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2221E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4bbbb6zz2221E, buf);
    ::bbbb::zz2221 &lv = *(new (buf) ::bbbb::zz2221());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz2221E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz2221E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*)(::bbbb::yy221*), 0, "_ZN4bbbb6zz2221E");
    check_base_class_offset(lv, (::bbbb::xx21*)(::bbbb::yy221*), 0, "_ZN4bbbb6zz2221E");
    check_base_class_offset(lv, (::bbbb::yy221*), 0, "_ZN4bbbb6zz2221E");
    check_field_offset(lv, fd, 6, "_ZN4bbbb6zz2221E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2221E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2221E(Test__ZN4bbbb6zz2221E, "_ZN4bbbb6zz2221E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
extern Class_Descriptor cd__ZN4bbbb5yy221E;
static Base_Class bases__ZN4bbbb6zz2221E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy221E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2221E = {  "_ZN4bbbb6zz2221E", // class name
  bases__ZN4bbbb6zz2221E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3221  : ::bbbb::yy221 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3221E) C1{ BC2{ BC3{ BC4{ Fc} Fs} Fs} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3221E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3221E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz3221E, buf);
    ::bbbb::zz3221 &lv = *(new (buf) ::bbbb::zz3221());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz3221E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3221E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*)(::bbbb::yy221*), 0, "_ZN4bbbb6zz3221E");
    check_base_class_offset(lv, (::bbbb::xx21*)(::bbbb::yy221*), 0, "_ZN4bbbb6zz3221E");
    check_base_class_offset(lv, (::bbbb::yy221*), 0, "_ZN4bbbb6zz3221E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz3221E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3221E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3221E(Test__ZN4bbbb6zz3221E, "_ZN4bbbb6zz3221E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
extern Class_Descriptor cd__ZN4bbbb5yy221E;
static Base_Class bases__ZN4bbbb6zz3221E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy221E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3221E = {  "_ZN4bbbb6zz3221E", // class name
  bases__ZN4bbbb6zz3221E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4221  : ::bbbb::yy221 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4221E) C1{ BC2{ BC3{ BC4{ Fc} Fs} Fs} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4221E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4221E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,5)];
    init_test(&cd__ZN4bbbb6zz4221E, buf);
    ::bbbb::zz4221 &lv = *(new (buf) ::bbbb::zz4221());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz4221E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4221E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*)(::bbbb::yy221*), 0, "_ZN4bbbb6zz4221E");
    check_base_class_offset(lv, (::bbbb::xx21*)(::bbbb::yy221*), 0, "_ZN4bbbb6zz4221E");
    check_base_class_offset(lv, (::bbbb::yy221*), 0, "_ZN4bbbb6zz4221E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz4221E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4221E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4221E(Test__ZN4bbbb6zz4221E, "_ZN4bbbb6zz4221E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
extern Class_Descriptor cd__ZN4bbbb5yy221E;
static Base_Class bases__ZN4bbbb6zz4221E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy221E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4221E = {  "_ZN4bbbb6zz4221E", // class name
  bases__ZN4bbbb6zz4221E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy321  : ::bbbb::xx21 {
  int fc;
};
//SIG(-1 _ZN4bbbb5yy321E) C1{ BC2{ BC3{ Fc} Fs} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy321E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy321E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb5yy321E, buf);
    ::bbbb::yy321 &lv = *(new (buf) ::bbbb::yy321());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb5yy321E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb5yy321E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*), 0, "_ZN4bbbb5yy321E");
    check_base_class_offset(lv, (::bbbb::xx21*), 0, "_ZN4bbbb5yy321E");
    check_field_offset(lv, fc, 4, "_ZN4bbbb5yy321E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy321E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy321E(Test__ZN4bbbb5yy321E, "_ZN4bbbb5yy321E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
static Base_Class bases__ZN4bbbb5yy321E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy321E = {  "_ZN4bbbb5yy321E", // class name
  bases__ZN4bbbb5yy321E, 2,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0321  : ::bbbb::yy321 {
};
//SIG(1 _ZN4bbbb6zz0321E) C1{ BC2{ BC3{ BC4{ Fc} Fs} Fi}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0321E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0321E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz0321E, buf);
    ::bbbb::zz0321 &lv = *(new (buf) ::bbbb::zz0321());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz0321E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz0321E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*)(::bbbb::yy321*), 0, "_ZN4bbbb6zz0321E");
    check_base_class_offset(lv, (::bbbb::xx21*)(::bbbb::yy321*), 0, "_ZN4bbbb6zz0321E");
    check_base_class_offset(lv, (::bbbb::yy321*), 0, "_ZN4bbbb6zz0321E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0321E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0321E(Test__ZN4bbbb6zz0321E, "_ZN4bbbb6zz0321E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
extern Class_Descriptor cd__ZN4bbbb5yy321E;
static Base_Class bases__ZN4bbbb6zz0321E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy321E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0321E = {  "_ZN4bbbb6zz0321E", // class name
  bases__ZN4bbbb6zz0321E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1321  : ::bbbb::yy321 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1321E) C1{ BC2{ BC3{ BC4{ Fc} Fs} Fi} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1321E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1321E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz1321E, buf);
    ::bbbb::zz1321 &lv = *(new (buf) ::bbbb::zz1321());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz1321E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz1321E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*)(::bbbb::yy321*), 0, "_ZN4bbbb6zz1321E");
    check_base_class_offset(lv, (::bbbb::xx21*)(::bbbb::yy321*), 0, "_ZN4bbbb6zz1321E");
    check_base_class_offset(lv, (::bbbb::yy321*), 0, "_ZN4bbbb6zz1321E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz1321E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1321E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1321E(Test__ZN4bbbb6zz1321E, "_ZN4bbbb6zz1321E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
extern Class_Descriptor cd__ZN4bbbb5yy321E;
static Base_Class bases__ZN4bbbb6zz1321E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy321E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1321E = {  "_ZN4bbbb6zz1321E", // class name
  bases__ZN4bbbb6zz1321E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2321  : ::bbbb::yy321 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2321E) C1{ BC2{ BC3{ BC4{ Fc} Fs} Fi} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2321E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2321E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz2321E, buf);
    ::bbbb::zz2321 &lv = *(new (buf) ::bbbb::zz2321());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz2321E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz2321E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*)(::bbbb::yy321*), 0, "_ZN4bbbb6zz2321E");
    check_base_class_offset(lv, (::bbbb::xx21*)(::bbbb::yy321*), 0, "_ZN4bbbb6zz2321E");
    check_base_class_offset(lv, (::bbbb::yy321*), 0, "_ZN4bbbb6zz2321E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz2321E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2321E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2321E(Test__ZN4bbbb6zz2321E, "_ZN4bbbb6zz2321E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
extern Class_Descriptor cd__ZN4bbbb5yy321E;
static Base_Class bases__ZN4bbbb6zz2321E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy321E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2321E = {  "_ZN4bbbb6zz2321E", // class name
  bases__ZN4bbbb6zz2321E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3321  : ::bbbb::yy321 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3321E) C1{ BC2{ BC3{ BC4{ Fc} Fs} Fi} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3321E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3321E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz3321E, buf);
    ::bbbb::zz3321 &lv = *(new (buf) ::bbbb::zz3321());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz3321E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3321E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*)(::bbbb::yy321*), 0, "_ZN4bbbb6zz3321E");
    check_base_class_offset(lv, (::bbbb::xx21*)(::bbbb::yy321*), 0, "_ZN4bbbb6zz3321E");
    check_base_class_offset(lv, (::bbbb::yy321*), 0, "_ZN4bbbb6zz3321E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz3321E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3321E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3321E(Test__ZN4bbbb6zz3321E, "_ZN4bbbb6zz3321E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
extern Class_Descriptor cd__ZN4bbbb5yy321E;
static Base_Class bases__ZN4bbbb6zz3321E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy321E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3321E = {  "_ZN4bbbb6zz3321E", // class name
  bases__ZN4bbbb6zz3321E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4321  : ::bbbb::yy321 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4321E) C1{ BC2{ BC3{ BC4{ Fc} Fs} Fi} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4321E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4321E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,5)];
    init_test(&cd__ZN4bbbb6zz4321E, buf);
    ::bbbb::zz4321 &lv = *(new (buf) ::bbbb::zz4321());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz4321E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4321E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*)(::bbbb::yy321*), 0, "_ZN4bbbb6zz4321E");
    check_base_class_offset(lv, (::bbbb::xx21*)(::bbbb::yy321*), 0, "_ZN4bbbb6zz4321E");
    check_base_class_offset(lv, (::bbbb::yy321*), 0, "_ZN4bbbb6zz4321E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz4321E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4321E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4321E(Test__ZN4bbbb6zz4321E, "_ZN4bbbb6zz4321E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
extern Class_Descriptor cd__ZN4bbbb5yy321E;
static Base_Class bases__ZN4bbbb6zz4321E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy321E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4321E = {  "_ZN4bbbb6zz4321E", // class name
  bases__ZN4bbbb6zz4321E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy421  : ::bbbb::xx21 {
  double fc;
};
//SIG(-1 _ZN4bbbb5yy421E) C1{ BC2{ BC3{ Fc} Fs} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy421E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy421E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb5yy421E, buf);
    ::bbbb::yy421 &lv = *(new (buf) ::bbbb::yy421());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb5yy421E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb5yy421E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*), 0, "_ZN4bbbb5yy421E");
    check_base_class_offset(lv, (::bbbb::xx21*), 0, "_ZN4bbbb5yy421E");
    check_field_offset(lv, fc, ABISELECT(8,4), "_ZN4bbbb5yy421E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy421E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy421E(Test__ZN4bbbb5yy421E, "_ZN4bbbb5yy421E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
static Base_Class bases__ZN4bbbb5yy421E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy421E = {  "_ZN4bbbb5yy421E", // class name
  bases__ZN4bbbb5yy421E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0421  : ::bbbb::yy421 {
};
//SIG(1 _ZN4bbbb6zz0421E) C1{ BC2{ BC3{ BC4{ Fc} Fs} FL}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0421E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0421E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz0421E, buf);
    ::bbbb::zz0421 &lv = *(new (buf) ::bbbb::zz0421());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz0421E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz0421E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*)(::bbbb::yy421*), 0, "_ZN4bbbb6zz0421E");
    check_base_class_offset(lv, (::bbbb::xx21*)(::bbbb::yy421*), 0, "_ZN4bbbb6zz0421E");
    check_base_class_offset(lv, (::bbbb::yy421*), 0, "_ZN4bbbb6zz0421E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0421E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0421E(Test__ZN4bbbb6zz0421E, "_ZN4bbbb6zz0421E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
extern Class_Descriptor cd__ZN4bbbb5yy421E;
static Base_Class bases__ZN4bbbb6zz0421E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy421E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0421E = {  "_ZN4bbbb6zz0421E", // class name
  bases__ZN4bbbb6zz0421E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1421  : ::bbbb::yy421 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1421E) C1{ BC2{ BC3{ BC4{ Fc} Fs} FL} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1421E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1421E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz1421E, buf);
    ::bbbb::zz1421 &lv = *(new (buf) ::bbbb::zz1421());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz1421E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz1421E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*)(::bbbb::yy421*), 0, "_ZN4bbbb6zz1421E");
    check_base_class_offset(lv, (::bbbb::xx21*)(::bbbb::yy421*), 0, "_ZN4bbbb6zz1421E");
    check_base_class_offset(lv, (::bbbb::yy421*), 0, "_ZN4bbbb6zz1421E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz1421E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1421E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1421E(Test__ZN4bbbb6zz1421E, "_ZN4bbbb6zz1421E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
extern Class_Descriptor cd__ZN4bbbb5yy421E;
static Base_Class bases__ZN4bbbb6zz1421E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy421E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1421E = {  "_ZN4bbbb6zz1421E", // class name
  bases__ZN4bbbb6zz1421E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2421  : ::bbbb::yy421 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2421E) C1{ BC2{ BC3{ BC4{ Fc} Fs} FL} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2421E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2421E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz2421E, buf);
    ::bbbb::zz2421 &lv = *(new (buf) ::bbbb::zz2421());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz2421E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz2421E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*)(::bbbb::yy421*), 0, "_ZN4bbbb6zz2421E");
    check_base_class_offset(lv, (::bbbb::xx21*)(::bbbb::yy421*), 0, "_ZN4bbbb6zz2421E");
    check_base_class_offset(lv, (::bbbb::yy421*), 0, "_ZN4bbbb6zz2421E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz2421E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2421E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2421E(Test__ZN4bbbb6zz2421E, "_ZN4bbbb6zz2421E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
extern Class_Descriptor cd__ZN4bbbb5yy421E;
static Base_Class bases__ZN4bbbb6zz2421E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy421E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2421E = {  "_ZN4bbbb6zz2421E", // class name
  bases__ZN4bbbb6zz2421E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3421  : ::bbbb::yy421 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3421E) C1{ BC2{ BC3{ BC4{ Fc} Fs} FL} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3421E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3421E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz3421E, buf);
    ::bbbb::zz3421 &lv = *(new (buf) ::bbbb::zz3421());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz3421E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz3421E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*)(::bbbb::yy421*), 0, "_ZN4bbbb6zz3421E");
    check_base_class_offset(lv, (::bbbb::xx21*)(::bbbb::yy421*), 0, "_ZN4bbbb6zz3421E");
    check_base_class_offset(lv, (::bbbb::yy421*), 0, "_ZN4bbbb6zz3421E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz3421E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3421E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3421E(Test__ZN4bbbb6zz3421E, "_ZN4bbbb6zz3421E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
extern Class_Descriptor cd__ZN4bbbb5yy421E;
static Base_Class bases__ZN4bbbb6zz3421E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy421E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3421E = {  "_ZN4bbbb6zz3421E", // class name
  bases__ZN4bbbb6zz3421E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4421  : ::bbbb::yy421 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4421E) C1{ BC2{ BC3{ BC4{ Fc} Fs} FL} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4421E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4421E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz4421E, buf);
    ::bbbb::zz4421 &lv = *(new (buf) ::bbbb::zz4421());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz4421E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4421E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx21*)(::bbbb::yy421*), 0, "_ZN4bbbb6zz4421E");
    check_base_class_offset(lv, (::bbbb::xx21*)(::bbbb::yy421*), 0, "_ZN4bbbb6zz4421E");
    check_base_class_offset(lv, (::bbbb::yy421*), 0, "_ZN4bbbb6zz4421E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz4421E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4421E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4421E(Test__ZN4bbbb6zz4421E, "_ZN4bbbb6zz4421E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx21E;
extern Class_Descriptor cd__ZN4bbbb5yy421E;
static Base_Class bases__ZN4bbbb6zz4421E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx21E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy421E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4421E = {  "_ZN4bbbb6zz4421E", // class name
  bases__ZN4bbbb6zz4421E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  xx31  : ::bbbb::ww1 {
  int fb;
};
//SIG(-1 _ZN4bbbb4xx31E) C1{ BC2{ Fc} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb4xx31E()
{
  extern Class_Descriptor cd__ZN4bbbb4xx31E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb4xx31E, buf);
    ::bbbb::xx31 &lv = *(new (buf) ::bbbb::xx31());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb4xx31E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb4xx31E)");
    check_base_class_offset(lv, (::bbbb::ww1*), 0, "_ZN4bbbb4xx31E");
    check_field_offset(lv, fb, 4, "_ZN4bbbb4xx31E.fb");
    test_class_info(&lv, &cd__ZN4bbbb4xx31E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb4xx31E(Test__ZN4bbbb4xx31E, "_ZN4bbbb4xx31E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
static Base_Class bases__ZN4bbbb4xx31E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb4xx31E = {  "_ZN4bbbb4xx31E", // class name
  bases__ZN4bbbb4xx31E, 1,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy031  : ::bbbb::xx31 {
};
//SIG(-1 _ZN4bbbb5yy031E) C1{ BC2{ BC3{ Fc} Fi}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy031E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy031E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb5yy031E, buf);
    ::bbbb::yy031 &lv = *(new (buf) ::bbbb::yy031());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb5yy031E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb5yy031E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*), 0, "_ZN4bbbb5yy031E");
    check_base_class_offset(lv, (::bbbb::xx31*), 0, "_ZN4bbbb5yy031E");
    test_class_info(&lv, &cd__ZN4bbbb5yy031E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy031E(Test__ZN4bbbb5yy031E, "_ZN4bbbb5yy031E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
static Base_Class bases__ZN4bbbb5yy031E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy031E = {  "_ZN4bbbb5yy031E", // class name
  bases__ZN4bbbb5yy031E, 2,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0031  : ::bbbb::yy031 {
};
//SIG(1 _ZN4bbbb6zz0031E) C1{ BC2{ BC3{ BC4{ Fc} Fi}}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0031E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0031E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz0031E, buf);
    ::bbbb::zz0031 &lv = *(new (buf) ::bbbb::zz0031());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz0031E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz0031E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*)(::bbbb::yy031*), 0, "_ZN4bbbb6zz0031E");
    check_base_class_offset(lv, (::bbbb::xx31*)(::bbbb::yy031*), 0, "_ZN4bbbb6zz0031E");
    check_base_class_offset(lv, (::bbbb::yy031*), 0, "_ZN4bbbb6zz0031E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0031E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0031E(Test__ZN4bbbb6zz0031E, "_ZN4bbbb6zz0031E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
extern Class_Descriptor cd__ZN4bbbb5yy031E;
static Base_Class bases__ZN4bbbb6zz0031E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy031E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0031E = {  "_ZN4bbbb6zz0031E", // class name
  bases__ZN4bbbb6zz0031E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1031  : ::bbbb::yy031 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1031E) C1{ BC2{ BC3{ BC4{ Fc} Fi}} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1031E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1031E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz1031E, buf);
    ::bbbb::zz1031 &lv = *(new (buf) ::bbbb::zz1031());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz1031E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz1031E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*)(::bbbb::yy031*), 0, "_ZN4bbbb6zz1031E");
    check_base_class_offset(lv, (::bbbb::xx31*)(::bbbb::yy031*), 0, "_ZN4bbbb6zz1031E");
    check_base_class_offset(lv, (::bbbb::yy031*), 0, "_ZN4bbbb6zz1031E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz1031E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1031E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1031E(Test__ZN4bbbb6zz1031E, "_ZN4bbbb6zz1031E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
extern Class_Descriptor cd__ZN4bbbb5yy031E;
static Base_Class bases__ZN4bbbb6zz1031E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy031E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1031E = {  "_ZN4bbbb6zz1031E", // class name
  bases__ZN4bbbb6zz1031E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2031  : ::bbbb::yy031 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2031E) C1{ BC2{ BC3{ BC4{ Fc} Fi}} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2031E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2031E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz2031E, buf);
    ::bbbb::zz2031 &lv = *(new (buf) ::bbbb::zz2031());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz2031E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz2031E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*)(::bbbb::yy031*), 0, "_ZN4bbbb6zz2031E");
    check_base_class_offset(lv, (::bbbb::xx31*)(::bbbb::yy031*), 0, "_ZN4bbbb6zz2031E");
    check_base_class_offset(lv, (::bbbb::yy031*), 0, "_ZN4bbbb6zz2031E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz2031E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2031E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2031E(Test__ZN4bbbb6zz2031E, "_ZN4bbbb6zz2031E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
extern Class_Descriptor cd__ZN4bbbb5yy031E;
static Base_Class bases__ZN4bbbb6zz2031E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy031E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2031E = {  "_ZN4bbbb6zz2031E", // class name
  bases__ZN4bbbb6zz2031E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3031  : ::bbbb::yy031 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3031E) C1{ BC2{ BC3{ BC4{ Fc} Fi}} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3031E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3031E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz3031E, buf);
    ::bbbb::zz3031 &lv = *(new (buf) ::bbbb::zz3031());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz3031E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3031E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*)(::bbbb::yy031*), 0, "_ZN4bbbb6zz3031E");
    check_base_class_offset(lv, (::bbbb::xx31*)(::bbbb::yy031*), 0, "_ZN4bbbb6zz3031E");
    check_base_class_offset(lv, (::bbbb::yy031*), 0, "_ZN4bbbb6zz3031E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz3031E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3031E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3031E(Test__ZN4bbbb6zz3031E, "_ZN4bbbb6zz3031E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
extern Class_Descriptor cd__ZN4bbbb5yy031E;
static Base_Class bases__ZN4bbbb6zz3031E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy031E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3031E = {  "_ZN4bbbb6zz3031E", // class name
  bases__ZN4bbbb6zz3031E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4031  : ::bbbb::yy031 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4031E) C1{ BC2{ BC3{ BC4{ Fc} Fi}} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4031E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4031E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,5)];
    init_test(&cd__ZN4bbbb6zz4031E, buf);
    ::bbbb::zz4031 &lv = *(new (buf) ::bbbb::zz4031());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz4031E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4031E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*)(::bbbb::yy031*), 0, "_ZN4bbbb6zz4031E");
    check_base_class_offset(lv, (::bbbb::xx31*)(::bbbb::yy031*), 0, "_ZN4bbbb6zz4031E");
    check_base_class_offset(lv, (::bbbb::yy031*), 0, "_ZN4bbbb6zz4031E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz4031E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4031E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4031E(Test__ZN4bbbb6zz4031E, "_ZN4bbbb6zz4031E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
extern Class_Descriptor cd__ZN4bbbb5yy031E;
static Base_Class bases__ZN4bbbb6zz4031E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy031E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4031E = {  "_ZN4bbbb6zz4031E", // class name
  bases__ZN4bbbb6zz4031E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy131  : ::bbbb::xx31 {
  char fc;
};
//SIG(-1 _ZN4bbbb5yy131E) C1{ BC2{ BC3{ Fc} Fi} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy131E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy131E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb5yy131E, buf);
    ::bbbb::yy131 &lv = *(new (buf) ::bbbb::yy131());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb5yy131E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb5yy131E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*), 0, "_ZN4bbbb5yy131E");
    check_base_class_offset(lv, (::bbbb::xx31*), 0, "_ZN4bbbb5yy131E");
    check_field_offset(lv, fc, 8, "_ZN4bbbb5yy131E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy131E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy131E(Test__ZN4bbbb5yy131E, "_ZN4bbbb5yy131E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
static Base_Class bases__ZN4bbbb5yy131E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy131E = {  "_ZN4bbbb5yy131E", // class name
  bases__ZN4bbbb5yy131E, 2,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0131  : ::bbbb::yy131 {
};
//SIG(1 _ZN4bbbb6zz0131E) C1{ BC2{ BC3{ BC4{ Fc} Fi} Fc}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0131E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0131E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz0131E, buf);
    ::bbbb::zz0131 &lv = *(new (buf) ::bbbb::zz0131());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz0131E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz0131E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*)(::bbbb::yy131*), 0, "_ZN4bbbb6zz0131E");
    check_base_class_offset(lv, (::bbbb::xx31*)(::bbbb::yy131*), 0, "_ZN4bbbb6zz0131E");
    check_base_class_offset(lv, (::bbbb::yy131*), 0, "_ZN4bbbb6zz0131E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0131E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0131E(Test__ZN4bbbb6zz0131E, "_ZN4bbbb6zz0131E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
extern Class_Descriptor cd__ZN4bbbb5yy131E;
static Base_Class bases__ZN4bbbb6zz0131E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy131E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0131E = {  "_ZN4bbbb6zz0131E", // class name
  bases__ZN4bbbb6zz0131E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1131  : ::bbbb::yy131 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1131E) C1{ BC2{ BC3{ BC4{ Fc} Fi} Fc} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1131E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1131E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz1131E, buf);
    ::bbbb::zz1131 &lv = *(new (buf) ::bbbb::zz1131());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz1131E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz1131E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*)(::bbbb::yy131*), 0, "_ZN4bbbb6zz1131E");
    check_base_class_offset(lv, (::bbbb::xx31*)(::bbbb::yy131*), 0, "_ZN4bbbb6zz1131E");
    check_base_class_offset(lv, (::bbbb::yy131*), 0, "_ZN4bbbb6zz1131E");
    check_field_offset(lv, fd, 9, "_ZN4bbbb6zz1131E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1131E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1131E(Test__ZN4bbbb6zz1131E, "_ZN4bbbb6zz1131E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
extern Class_Descriptor cd__ZN4bbbb5yy131E;
static Base_Class bases__ZN4bbbb6zz1131E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy131E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1131E = {  "_ZN4bbbb6zz1131E", // class name
  bases__ZN4bbbb6zz1131E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2131  : ::bbbb::yy131 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2131E) C1{ BC2{ BC3{ BC4{ Fc} Fi} Fc} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2131E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2131E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz2131E, buf);
    ::bbbb::zz2131 &lv = *(new (buf) ::bbbb::zz2131());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz2131E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz2131E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*)(::bbbb::yy131*), 0, "_ZN4bbbb6zz2131E");
    check_base_class_offset(lv, (::bbbb::xx31*)(::bbbb::yy131*), 0, "_ZN4bbbb6zz2131E");
    check_base_class_offset(lv, (::bbbb::yy131*), 0, "_ZN4bbbb6zz2131E");
    check_field_offset(lv, fd, 10, "_ZN4bbbb6zz2131E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2131E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2131E(Test__ZN4bbbb6zz2131E, "_ZN4bbbb6zz2131E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
extern Class_Descriptor cd__ZN4bbbb5yy131E;
static Base_Class bases__ZN4bbbb6zz2131E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy131E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2131E = {  "_ZN4bbbb6zz2131E", // class name
  bases__ZN4bbbb6zz2131E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3131  : ::bbbb::yy131 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3131E) C1{ BC2{ BC3{ BC4{ Fc} Fi} Fc} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3131E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3131E;
  void *lvp;
  {
    int buf[5];
    init_test(&cd__ZN4bbbb6zz3131E, buf);
    ::bbbb::zz3131 &lv = *(new (buf) ::bbbb::zz3131());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz3131E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3131E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*)(::bbbb::yy131*), 0, "_ZN4bbbb6zz3131E");
    check_base_class_offset(lv, (::bbbb::xx31*)(::bbbb::yy131*), 0, "_ZN4bbbb6zz3131E");
    check_base_class_offset(lv, (::bbbb::yy131*), 0, "_ZN4bbbb6zz3131E");
    check_field_offset(lv, fd, 12, "_ZN4bbbb6zz3131E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3131E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3131E(Test__ZN4bbbb6zz3131E, "_ZN4bbbb6zz3131E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
extern Class_Descriptor cd__ZN4bbbb5yy131E;
static Base_Class bases__ZN4bbbb6zz3131E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy131E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3131E = {  "_ZN4bbbb6zz3131E", // class name
  bases__ZN4bbbb6zz3131E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4131  : ::bbbb::yy131 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4131E) C1{ BC2{ BC3{ BC4{ Fc} Fi} Fc} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4131E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4131E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz4131E, buf);
    ::bbbb::zz4131 &lv = *(new (buf) ::bbbb::zz4131());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz4131E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4131E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*)(::bbbb::yy131*), 0, "_ZN4bbbb6zz4131E");
    check_base_class_offset(lv, (::bbbb::xx31*)(::bbbb::yy131*), 0, "_ZN4bbbb6zz4131E");
    check_base_class_offset(lv, (::bbbb::yy131*), 0, "_ZN4bbbb6zz4131E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz4131E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4131E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4131E(Test__ZN4bbbb6zz4131E, "_ZN4bbbb6zz4131E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
extern Class_Descriptor cd__ZN4bbbb5yy131E;
static Base_Class bases__ZN4bbbb6zz4131E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy131E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4131E = {  "_ZN4bbbb6zz4131E", // class name
  bases__ZN4bbbb6zz4131E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy231  : ::bbbb::xx31 {
  short fc;
};
//SIG(-1 _ZN4bbbb5yy231E) C1{ BC2{ BC3{ Fc} Fi} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy231E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy231E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb5yy231E, buf);
    ::bbbb::yy231 &lv = *(new (buf) ::bbbb::yy231());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb5yy231E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb5yy231E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*), 0, "_ZN4bbbb5yy231E");
    check_base_class_offset(lv, (::bbbb::xx31*), 0, "_ZN4bbbb5yy231E");
    check_field_offset(lv, fc, 8, "_ZN4bbbb5yy231E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy231E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy231E(Test__ZN4bbbb5yy231E, "_ZN4bbbb5yy231E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
static Base_Class bases__ZN4bbbb5yy231E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy231E = {  "_ZN4bbbb5yy231E", // class name
  bases__ZN4bbbb5yy231E, 2,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0231  : ::bbbb::yy231 {
};
//SIG(1 _ZN4bbbb6zz0231E) C1{ BC2{ BC3{ BC4{ Fc} Fi} Fs}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0231E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0231E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz0231E, buf);
    ::bbbb::zz0231 &lv = *(new (buf) ::bbbb::zz0231());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz0231E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz0231E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*)(::bbbb::yy231*), 0, "_ZN4bbbb6zz0231E");
    check_base_class_offset(lv, (::bbbb::xx31*)(::bbbb::yy231*), 0, "_ZN4bbbb6zz0231E");
    check_base_class_offset(lv, (::bbbb::yy231*), 0, "_ZN4bbbb6zz0231E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0231E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0231E(Test__ZN4bbbb6zz0231E, "_ZN4bbbb6zz0231E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
extern Class_Descriptor cd__ZN4bbbb5yy231E;
static Base_Class bases__ZN4bbbb6zz0231E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy231E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0231E = {  "_ZN4bbbb6zz0231E", // class name
  bases__ZN4bbbb6zz0231E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1231  : ::bbbb::yy231 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1231E) C1{ BC2{ BC3{ BC4{ Fc} Fi} Fs} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1231E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1231E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz1231E, buf);
    ::bbbb::zz1231 &lv = *(new (buf) ::bbbb::zz1231());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz1231E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz1231E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*)(::bbbb::yy231*), 0, "_ZN4bbbb6zz1231E");
    check_base_class_offset(lv, (::bbbb::xx31*)(::bbbb::yy231*), 0, "_ZN4bbbb6zz1231E");
    check_base_class_offset(lv, (::bbbb::yy231*), 0, "_ZN4bbbb6zz1231E");
    check_field_offset(lv, fd, 10, "_ZN4bbbb6zz1231E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1231E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1231E(Test__ZN4bbbb6zz1231E, "_ZN4bbbb6zz1231E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
extern Class_Descriptor cd__ZN4bbbb5yy231E;
static Base_Class bases__ZN4bbbb6zz1231E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy231E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1231E = {  "_ZN4bbbb6zz1231E", // class name
  bases__ZN4bbbb6zz1231E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2231  : ::bbbb::yy231 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2231E) C1{ BC2{ BC3{ BC4{ Fc} Fi} Fs} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2231E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2231E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz2231E, buf);
    ::bbbb::zz2231 &lv = *(new (buf) ::bbbb::zz2231());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz2231E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz2231E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*)(::bbbb::yy231*), 0, "_ZN4bbbb6zz2231E");
    check_base_class_offset(lv, (::bbbb::xx31*)(::bbbb::yy231*), 0, "_ZN4bbbb6zz2231E");
    check_base_class_offset(lv, (::bbbb::yy231*), 0, "_ZN4bbbb6zz2231E");
    check_field_offset(lv, fd, 10, "_ZN4bbbb6zz2231E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2231E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2231E(Test__ZN4bbbb6zz2231E, "_ZN4bbbb6zz2231E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
extern Class_Descriptor cd__ZN4bbbb5yy231E;
static Base_Class bases__ZN4bbbb6zz2231E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy231E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2231E = {  "_ZN4bbbb6zz2231E", // class name
  bases__ZN4bbbb6zz2231E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3231  : ::bbbb::yy231 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3231E) C1{ BC2{ BC3{ BC4{ Fc} Fi} Fs} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3231E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3231E;
  void *lvp;
  {
    int buf[5];
    init_test(&cd__ZN4bbbb6zz3231E, buf);
    ::bbbb::zz3231 &lv = *(new (buf) ::bbbb::zz3231());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz3231E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3231E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*)(::bbbb::yy231*), 0, "_ZN4bbbb6zz3231E");
    check_base_class_offset(lv, (::bbbb::xx31*)(::bbbb::yy231*), 0, "_ZN4bbbb6zz3231E");
    check_base_class_offset(lv, (::bbbb::yy231*), 0, "_ZN4bbbb6zz3231E");
    check_field_offset(lv, fd, 12, "_ZN4bbbb6zz3231E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3231E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3231E(Test__ZN4bbbb6zz3231E, "_ZN4bbbb6zz3231E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
extern Class_Descriptor cd__ZN4bbbb5yy231E;
static Base_Class bases__ZN4bbbb6zz3231E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy231E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3231E = {  "_ZN4bbbb6zz3231E", // class name
  bases__ZN4bbbb6zz3231E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4231  : ::bbbb::yy231 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4231E) C1{ BC2{ BC3{ BC4{ Fc} Fi} Fs} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4231E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4231E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz4231E, buf);
    ::bbbb::zz4231 &lv = *(new (buf) ::bbbb::zz4231());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz4231E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4231E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*)(::bbbb::yy231*), 0, "_ZN4bbbb6zz4231E");
    check_base_class_offset(lv, (::bbbb::xx31*)(::bbbb::yy231*), 0, "_ZN4bbbb6zz4231E");
    check_base_class_offset(lv, (::bbbb::yy231*), 0, "_ZN4bbbb6zz4231E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz4231E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4231E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4231E(Test__ZN4bbbb6zz4231E, "_ZN4bbbb6zz4231E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
extern Class_Descriptor cd__ZN4bbbb5yy231E;
static Base_Class bases__ZN4bbbb6zz4231E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy231E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4231E = {  "_ZN4bbbb6zz4231E", // class name
  bases__ZN4bbbb6zz4231E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy331  : ::bbbb::xx31 {
  int fc;
};
//SIG(-1 _ZN4bbbb5yy331E) C1{ BC2{ BC3{ Fc} Fi} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy331E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy331E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb5yy331E, buf);
    ::bbbb::yy331 &lv = *(new (buf) ::bbbb::yy331());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb5yy331E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb5yy331E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*), 0, "_ZN4bbbb5yy331E");
    check_base_class_offset(lv, (::bbbb::xx31*), 0, "_ZN4bbbb5yy331E");
    check_field_offset(lv, fc, 8, "_ZN4bbbb5yy331E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy331E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy331E(Test__ZN4bbbb5yy331E, "_ZN4bbbb5yy331E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
static Base_Class bases__ZN4bbbb5yy331E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy331E = {  "_ZN4bbbb5yy331E", // class name
  bases__ZN4bbbb5yy331E, 2,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0331  : ::bbbb::yy331 {
};
//SIG(1 _ZN4bbbb6zz0331E) C1{ BC2{ BC3{ BC4{ Fc} Fi} Fi}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0331E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0331E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz0331E, buf);
    ::bbbb::zz0331 &lv = *(new (buf) ::bbbb::zz0331());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz0331E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz0331E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*)(::bbbb::yy331*), 0, "_ZN4bbbb6zz0331E");
    check_base_class_offset(lv, (::bbbb::xx31*)(::bbbb::yy331*), 0, "_ZN4bbbb6zz0331E");
    check_base_class_offset(lv, (::bbbb::yy331*), 0, "_ZN4bbbb6zz0331E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0331E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0331E(Test__ZN4bbbb6zz0331E, "_ZN4bbbb6zz0331E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
extern Class_Descriptor cd__ZN4bbbb5yy331E;
static Base_Class bases__ZN4bbbb6zz0331E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy331E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0331E = {  "_ZN4bbbb6zz0331E", // class name
  bases__ZN4bbbb6zz0331E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1331  : ::bbbb::yy331 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1331E) C1{ BC2{ BC3{ BC4{ Fc} Fi} Fi} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1331E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1331E;
  void *lvp;
  {
    int buf[5];
    init_test(&cd__ZN4bbbb6zz1331E, buf);
    ::bbbb::zz1331 &lv = *(new (buf) ::bbbb::zz1331());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz1331E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz1331E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*)(::bbbb::yy331*), 0, "_ZN4bbbb6zz1331E");
    check_base_class_offset(lv, (::bbbb::xx31*)(::bbbb::yy331*), 0, "_ZN4bbbb6zz1331E");
    check_base_class_offset(lv, (::bbbb::yy331*), 0, "_ZN4bbbb6zz1331E");
    check_field_offset(lv, fd, 12, "_ZN4bbbb6zz1331E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1331E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1331E(Test__ZN4bbbb6zz1331E, "_ZN4bbbb6zz1331E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
extern Class_Descriptor cd__ZN4bbbb5yy331E;
static Base_Class bases__ZN4bbbb6zz1331E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy331E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1331E = {  "_ZN4bbbb6zz1331E", // class name
  bases__ZN4bbbb6zz1331E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2331  : ::bbbb::yy331 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2331E) C1{ BC2{ BC3{ BC4{ Fc} Fi} Fi} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2331E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2331E;
  void *lvp;
  {
    int buf[5];
    init_test(&cd__ZN4bbbb6zz2331E, buf);
    ::bbbb::zz2331 &lv = *(new (buf) ::bbbb::zz2331());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz2331E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz2331E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*)(::bbbb::yy331*), 0, "_ZN4bbbb6zz2331E");
    check_base_class_offset(lv, (::bbbb::xx31*)(::bbbb::yy331*), 0, "_ZN4bbbb6zz2331E");
    check_base_class_offset(lv, (::bbbb::yy331*), 0, "_ZN4bbbb6zz2331E");
    check_field_offset(lv, fd, 12, "_ZN4bbbb6zz2331E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2331E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2331E(Test__ZN4bbbb6zz2331E, "_ZN4bbbb6zz2331E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
extern Class_Descriptor cd__ZN4bbbb5yy331E;
static Base_Class bases__ZN4bbbb6zz2331E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy331E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2331E = {  "_ZN4bbbb6zz2331E", // class name
  bases__ZN4bbbb6zz2331E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3331  : ::bbbb::yy331 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3331E) C1{ BC2{ BC3{ BC4{ Fc} Fi} Fi} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3331E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3331E;
  void *lvp;
  {
    int buf[5];
    init_test(&cd__ZN4bbbb6zz3331E, buf);
    ::bbbb::zz3331 &lv = *(new (buf) ::bbbb::zz3331());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz3331E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3331E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*)(::bbbb::yy331*), 0, "_ZN4bbbb6zz3331E");
    check_base_class_offset(lv, (::bbbb::xx31*)(::bbbb::yy331*), 0, "_ZN4bbbb6zz3331E");
    check_base_class_offset(lv, (::bbbb::yy331*), 0, "_ZN4bbbb6zz3331E");
    check_field_offset(lv, fd, 12, "_ZN4bbbb6zz3331E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3331E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3331E(Test__ZN4bbbb6zz3331E, "_ZN4bbbb6zz3331E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
extern Class_Descriptor cd__ZN4bbbb5yy331E;
static Base_Class bases__ZN4bbbb6zz3331E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy331E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3331E = {  "_ZN4bbbb6zz3331E", // class name
  bases__ZN4bbbb6zz3331E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4331  : ::bbbb::yy331 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4331E) C1{ BC2{ BC3{ BC4{ Fc} Fi} Fi} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4331E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4331E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz4331E, buf);
    ::bbbb::zz4331 &lv = *(new (buf) ::bbbb::zz4331());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz4331E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4331E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*)(::bbbb::yy331*), 0, "_ZN4bbbb6zz4331E");
    check_base_class_offset(lv, (::bbbb::xx31*)(::bbbb::yy331*), 0, "_ZN4bbbb6zz4331E");
    check_base_class_offset(lv, (::bbbb::yy331*), 0, "_ZN4bbbb6zz4331E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz4331E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4331E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4331E(Test__ZN4bbbb6zz4331E, "_ZN4bbbb6zz4331E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
extern Class_Descriptor cd__ZN4bbbb5yy331E;
static Base_Class bases__ZN4bbbb6zz4331E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy331E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4331E = {  "_ZN4bbbb6zz4331E", // class name
  bases__ZN4bbbb6zz4331E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy431  : ::bbbb::xx31 {
  double fc;
};
//SIG(-1 _ZN4bbbb5yy431E) C1{ BC2{ BC3{ Fc} Fi} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy431E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy431E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,5)];
    init_test(&cd__ZN4bbbb5yy431E, buf);
    ::bbbb::yy431 &lv = *(new (buf) ::bbbb::yy431());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb5yy431E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb5yy431E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*), 0, "_ZN4bbbb5yy431E");
    check_base_class_offset(lv, (::bbbb::xx31*), 0, "_ZN4bbbb5yy431E");
    check_field_offset(lv, fc, 8, "_ZN4bbbb5yy431E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy431E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy431E(Test__ZN4bbbb5yy431E, "_ZN4bbbb5yy431E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
static Base_Class bases__ZN4bbbb5yy431E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy431E = {  "_ZN4bbbb5yy431E", // class name
  bases__ZN4bbbb5yy431E, 2,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0431  : ::bbbb::yy431 {
};
//SIG(1 _ZN4bbbb6zz0431E) C1{ BC2{ BC3{ BC4{ Fc} Fi} FL}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0431E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0431E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,5)];
    init_test(&cd__ZN4bbbb6zz0431E, buf);
    ::bbbb::zz0431 &lv = *(new (buf) ::bbbb::zz0431());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz0431E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz0431E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*)(::bbbb::yy431*), 0, "_ZN4bbbb6zz0431E");
    check_base_class_offset(lv, (::bbbb::xx31*)(::bbbb::yy431*), 0, "_ZN4bbbb6zz0431E");
    check_base_class_offset(lv, (::bbbb::yy431*), 0, "_ZN4bbbb6zz0431E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0431E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0431E(Test__ZN4bbbb6zz0431E, "_ZN4bbbb6zz0431E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
extern Class_Descriptor cd__ZN4bbbb5yy431E;
static Base_Class bases__ZN4bbbb6zz0431E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy431E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0431E = {  "_ZN4bbbb6zz0431E", // class name
  bases__ZN4bbbb6zz0431E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1431  : ::bbbb::yy431 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1431E) C1{ BC2{ BC3{ BC4{ Fc} Fi} FL} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1431E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1431E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz1431E, buf);
    ::bbbb::zz1431 &lv = *(new (buf) ::bbbb::zz1431());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz1431E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz1431E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*)(::bbbb::yy431*), 0, "_ZN4bbbb6zz1431E");
    check_base_class_offset(lv, (::bbbb::xx31*)(::bbbb::yy431*), 0, "_ZN4bbbb6zz1431E");
    check_base_class_offset(lv, (::bbbb::yy431*), 0, "_ZN4bbbb6zz1431E");
    check_field_offset(lv, fd, 16, "_ZN4bbbb6zz1431E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1431E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1431E(Test__ZN4bbbb6zz1431E, "_ZN4bbbb6zz1431E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
extern Class_Descriptor cd__ZN4bbbb5yy431E;
static Base_Class bases__ZN4bbbb6zz1431E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy431E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1431E = {  "_ZN4bbbb6zz1431E", // class name
  bases__ZN4bbbb6zz1431E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2431  : ::bbbb::yy431 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2431E) C1{ BC2{ BC3{ BC4{ Fc} Fi} FL} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2431E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2431E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz2431E, buf);
    ::bbbb::zz2431 &lv = *(new (buf) ::bbbb::zz2431());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz2431E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz2431E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*)(::bbbb::yy431*), 0, "_ZN4bbbb6zz2431E");
    check_base_class_offset(lv, (::bbbb::xx31*)(::bbbb::yy431*), 0, "_ZN4bbbb6zz2431E");
    check_base_class_offset(lv, (::bbbb::yy431*), 0, "_ZN4bbbb6zz2431E");
    check_field_offset(lv, fd, 16, "_ZN4bbbb6zz2431E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2431E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2431E(Test__ZN4bbbb6zz2431E, "_ZN4bbbb6zz2431E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
extern Class_Descriptor cd__ZN4bbbb5yy431E;
static Base_Class bases__ZN4bbbb6zz2431E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy431E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2431E = {  "_ZN4bbbb6zz2431E", // class name
  bases__ZN4bbbb6zz2431E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3431  : ::bbbb::yy431 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3431E) C1{ BC2{ BC3{ BC4{ Fc} Fi} FL} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3431E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3431E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz3431E, buf);
    ::bbbb::zz3431 &lv = *(new (buf) ::bbbb::zz3431());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz3431E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz3431E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*)(::bbbb::yy431*), 0, "_ZN4bbbb6zz3431E");
    check_base_class_offset(lv, (::bbbb::xx31*)(::bbbb::yy431*), 0, "_ZN4bbbb6zz3431E");
    check_base_class_offset(lv, (::bbbb::yy431*), 0, "_ZN4bbbb6zz3431E");
    check_field_offset(lv, fd, 16, "_ZN4bbbb6zz3431E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3431E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3431E(Test__ZN4bbbb6zz3431E, "_ZN4bbbb6zz3431E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
extern Class_Descriptor cd__ZN4bbbb5yy431E;
static Base_Class bases__ZN4bbbb6zz3431E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy431E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3431E = {  "_ZN4bbbb6zz3431E", // class name
  bases__ZN4bbbb6zz3431E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4431  : ::bbbb::yy431 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4431E) C1{ BC2{ BC3{ BC4{ Fc} Fi} FL} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4431E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4431E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,7)];
    init_test(&cd__ZN4bbbb6zz4431E, buf);
    ::bbbb::zz4431 &lv = *(new (buf) ::bbbb::zz4431());
    lvp = (void*)&lv;
    check2(sizeof(lv), 24, "sizeof(_ZN4bbbb6zz4431E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4431E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx31*)(::bbbb::yy431*), 0, "_ZN4bbbb6zz4431E");
    check_base_class_offset(lv, (::bbbb::xx31*)(::bbbb::yy431*), 0, "_ZN4bbbb6zz4431E");
    check_base_class_offset(lv, (::bbbb::yy431*), 0, "_ZN4bbbb6zz4431E");
    check_field_offset(lv, fd, 16, "_ZN4bbbb6zz4431E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4431E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4431E(Test__ZN4bbbb6zz4431E, "_ZN4bbbb6zz4431E", 24);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx31E;
extern Class_Descriptor cd__ZN4bbbb5yy431E;
static Base_Class bases__ZN4bbbb6zz4431E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx31E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy431E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4431E = {  "_ZN4bbbb6zz4431E", // class name
  bases__ZN4bbbb6zz4431E, 3,
  0, // no vftv
  0, //no vtt
  24, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  xx41  : ::bbbb::ww1 {
  double fb;
};
//SIG(-1 _ZN4bbbb4xx41E) C1{ BC2{ Fc} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb4xx41E()
{
  extern Class_Descriptor cd__ZN4bbbb4xx41E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb4xx41E, buf);
    ::bbbb::xx41 &lv = *(new (buf) ::bbbb::xx41());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb4xx41E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb4xx41E)");
    check_base_class_offset(lv, (::bbbb::ww1*), 0, "_ZN4bbbb4xx41E");
    check_field_offset(lv, fb, ABISELECT(8,4), "_ZN4bbbb4xx41E.fb");
    test_class_info(&lv, &cd__ZN4bbbb4xx41E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb4xx41E(Test__ZN4bbbb4xx41E, "_ZN4bbbb4xx41E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
static Base_Class bases__ZN4bbbb4xx41E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb4xx41E = {  "_ZN4bbbb4xx41E", // class name
  bases__ZN4bbbb4xx41E, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy041  : ::bbbb::xx41 {
};
//SIG(-1 _ZN4bbbb5yy041E) C1{ BC2{ BC3{ Fc} FL}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy041E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy041E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb5yy041E, buf);
    ::bbbb::yy041 &lv = *(new (buf) ::bbbb::yy041());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb5yy041E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb5yy041E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*), 0, "_ZN4bbbb5yy041E");
    check_base_class_offset(lv, (::bbbb::xx41*), 0, "_ZN4bbbb5yy041E");
    test_class_info(&lv, &cd__ZN4bbbb5yy041E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy041E(Test__ZN4bbbb5yy041E, "_ZN4bbbb5yy041E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
static Base_Class bases__ZN4bbbb5yy041E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy041E = {  "_ZN4bbbb5yy041E", // class name
  bases__ZN4bbbb5yy041E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0041  : ::bbbb::yy041 {
};
//SIG(1 _ZN4bbbb6zz0041E) C1{ BC2{ BC3{ BC4{ Fc} FL}}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0041E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0041E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz0041E, buf);
    ::bbbb::zz0041 &lv = *(new (buf) ::bbbb::zz0041());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz0041E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz0041E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*)(::bbbb::yy041*), 0, "_ZN4bbbb6zz0041E");
    check_base_class_offset(lv, (::bbbb::xx41*)(::bbbb::yy041*), 0, "_ZN4bbbb6zz0041E");
    check_base_class_offset(lv, (::bbbb::yy041*), 0, "_ZN4bbbb6zz0041E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0041E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0041E(Test__ZN4bbbb6zz0041E, "_ZN4bbbb6zz0041E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
extern Class_Descriptor cd__ZN4bbbb5yy041E;
static Base_Class bases__ZN4bbbb6zz0041E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy041E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0041E = {  "_ZN4bbbb6zz0041E", // class name
  bases__ZN4bbbb6zz0041E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1041  : ::bbbb::yy041 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1041E) C1{ BC2{ BC3{ BC4{ Fc} FL}} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1041E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1041E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz1041E, buf);
    ::bbbb::zz1041 &lv = *(new (buf) ::bbbb::zz1041());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz1041E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz1041E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*)(::bbbb::yy041*), 0, "_ZN4bbbb6zz1041E");
    check_base_class_offset(lv, (::bbbb::xx41*)(::bbbb::yy041*), 0, "_ZN4bbbb6zz1041E");
    check_base_class_offset(lv, (::bbbb::yy041*), 0, "_ZN4bbbb6zz1041E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz1041E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1041E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1041E(Test__ZN4bbbb6zz1041E, "_ZN4bbbb6zz1041E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
extern Class_Descriptor cd__ZN4bbbb5yy041E;
static Base_Class bases__ZN4bbbb6zz1041E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy041E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1041E = {  "_ZN4bbbb6zz1041E", // class name
  bases__ZN4bbbb6zz1041E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2041  : ::bbbb::yy041 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2041E) C1{ BC2{ BC3{ BC4{ Fc} FL}} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2041E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2041E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz2041E, buf);
    ::bbbb::zz2041 &lv = *(new (buf) ::bbbb::zz2041());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz2041E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz2041E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*)(::bbbb::yy041*), 0, "_ZN4bbbb6zz2041E");
    check_base_class_offset(lv, (::bbbb::xx41*)(::bbbb::yy041*), 0, "_ZN4bbbb6zz2041E");
    check_base_class_offset(lv, (::bbbb::yy041*), 0, "_ZN4bbbb6zz2041E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz2041E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2041E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2041E(Test__ZN4bbbb6zz2041E, "_ZN4bbbb6zz2041E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
extern Class_Descriptor cd__ZN4bbbb5yy041E;
static Base_Class bases__ZN4bbbb6zz2041E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy041E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2041E = {  "_ZN4bbbb6zz2041E", // class name
  bases__ZN4bbbb6zz2041E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3041  : ::bbbb::yy041 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3041E) C1{ BC2{ BC3{ BC4{ Fc} FL}} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3041E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3041E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz3041E, buf);
    ::bbbb::zz3041 &lv = *(new (buf) ::bbbb::zz3041());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz3041E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz3041E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*)(::bbbb::yy041*), 0, "_ZN4bbbb6zz3041E");
    check_base_class_offset(lv, (::bbbb::xx41*)(::bbbb::yy041*), 0, "_ZN4bbbb6zz3041E");
    check_base_class_offset(lv, (::bbbb::yy041*), 0, "_ZN4bbbb6zz3041E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz3041E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3041E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3041E(Test__ZN4bbbb6zz3041E, "_ZN4bbbb6zz3041E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
extern Class_Descriptor cd__ZN4bbbb5yy041E;
static Base_Class bases__ZN4bbbb6zz3041E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy041E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3041E = {  "_ZN4bbbb6zz3041E", // class name
  bases__ZN4bbbb6zz3041E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4041  : ::bbbb::yy041 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4041E) C1{ BC2{ BC3{ BC4{ Fc} FL}} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4041E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4041E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz4041E, buf);
    ::bbbb::zz4041 &lv = *(new (buf) ::bbbb::zz4041());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz4041E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4041E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*)(::bbbb::yy041*), 0, "_ZN4bbbb6zz4041E");
    check_base_class_offset(lv, (::bbbb::xx41*)(::bbbb::yy041*), 0, "_ZN4bbbb6zz4041E");
    check_base_class_offset(lv, (::bbbb::yy041*), 0, "_ZN4bbbb6zz4041E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz4041E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4041E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4041E(Test__ZN4bbbb6zz4041E, "_ZN4bbbb6zz4041E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
extern Class_Descriptor cd__ZN4bbbb5yy041E;
static Base_Class bases__ZN4bbbb6zz4041E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy041E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4041E = {  "_ZN4bbbb6zz4041E", // class name
  bases__ZN4bbbb6zz4041E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy141  : ::bbbb::xx41 {
  char fc;
};
//SIG(-1 _ZN4bbbb5yy141E) C1{ BC2{ BC3{ Fc} FL} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy141E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy141E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb5yy141E, buf);
    ::bbbb::yy141 &lv = *(new (buf) ::bbbb::yy141());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb5yy141E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb5yy141E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*), 0, "_ZN4bbbb5yy141E");
    check_base_class_offset(lv, (::bbbb::xx41*), 0, "_ZN4bbbb5yy141E");
    check_field_offset(lv, fc, ABISELECT(16,12), "_ZN4bbbb5yy141E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy141E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy141E(Test__ZN4bbbb5yy141E, "_ZN4bbbb5yy141E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
static Base_Class bases__ZN4bbbb5yy141E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy141E = {  "_ZN4bbbb5yy141E", // class name
  bases__ZN4bbbb5yy141E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0141  : ::bbbb::yy141 {
};
//SIG(1 _ZN4bbbb6zz0141E) C1{ BC2{ BC3{ BC4{ Fc} FL} Fc}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0141E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0141E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz0141E, buf);
    ::bbbb::zz0141 &lv = *(new (buf) ::bbbb::zz0141());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz0141E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz0141E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*)(::bbbb::yy141*), 0, "_ZN4bbbb6zz0141E");
    check_base_class_offset(lv, (::bbbb::xx41*)(::bbbb::yy141*), 0, "_ZN4bbbb6zz0141E");
    check_base_class_offset(lv, (::bbbb::yy141*), 0, "_ZN4bbbb6zz0141E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0141E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0141E(Test__ZN4bbbb6zz0141E, "_ZN4bbbb6zz0141E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
extern Class_Descriptor cd__ZN4bbbb5yy141E;
static Base_Class bases__ZN4bbbb6zz0141E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy141E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0141E = {  "_ZN4bbbb6zz0141E", // class name
  bases__ZN4bbbb6zz0141E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1141  : ::bbbb::yy141 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1141E) C1{ BC2{ BC3{ BC4{ Fc} FL} Fc} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1141E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1141E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz1141E, buf);
    ::bbbb::zz1141 &lv = *(new (buf) ::bbbb::zz1141());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz1141E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz1141E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*)(::bbbb::yy141*), 0, "_ZN4bbbb6zz1141E");
    check_base_class_offset(lv, (::bbbb::xx41*)(::bbbb::yy141*), 0, "_ZN4bbbb6zz1141E");
    check_base_class_offset(lv, (::bbbb::yy141*), 0, "_ZN4bbbb6zz1141E");
    check_field_offset(lv, fd, ABISELECT(17,13), "_ZN4bbbb6zz1141E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1141E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1141E(Test__ZN4bbbb6zz1141E, "_ZN4bbbb6zz1141E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
extern Class_Descriptor cd__ZN4bbbb5yy141E;
static Base_Class bases__ZN4bbbb6zz1141E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy141E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1141E = {  "_ZN4bbbb6zz1141E", // class name
  bases__ZN4bbbb6zz1141E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2141  : ::bbbb::yy141 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2141E) C1{ BC2{ BC3{ BC4{ Fc} FL} Fc} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2141E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2141E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz2141E, buf);
    ::bbbb::zz2141 &lv = *(new (buf) ::bbbb::zz2141());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz2141E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz2141E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*)(::bbbb::yy141*), 0, "_ZN4bbbb6zz2141E");
    check_base_class_offset(lv, (::bbbb::xx41*)(::bbbb::yy141*), 0, "_ZN4bbbb6zz2141E");
    check_base_class_offset(lv, (::bbbb::yy141*), 0, "_ZN4bbbb6zz2141E");
    check_field_offset(lv, fd, ABISELECT(18,14), "_ZN4bbbb6zz2141E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2141E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2141E(Test__ZN4bbbb6zz2141E, "_ZN4bbbb6zz2141E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
extern Class_Descriptor cd__ZN4bbbb5yy141E;
static Base_Class bases__ZN4bbbb6zz2141E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy141E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2141E = {  "_ZN4bbbb6zz2141E", // class name
  bases__ZN4bbbb6zz2141E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3141  : ::bbbb::yy141 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3141E) C1{ BC2{ BC3{ BC4{ Fc} FL} Fc} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3141E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3141E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz3141E, buf);
    ::bbbb::zz3141 &lv = *(new (buf) ::bbbb::zz3141());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz3141E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz3141E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*)(::bbbb::yy141*), 0, "_ZN4bbbb6zz3141E");
    check_base_class_offset(lv, (::bbbb::xx41*)(::bbbb::yy141*), 0, "_ZN4bbbb6zz3141E");
    check_base_class_offset(lv, (::bbbb::yy141*), 0, "_ZN4bbbb6zz3141E");
    check_field_offset(lv, fd, ABISELECT(20,16), "_ZN4bbbb6zz3141E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3141E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3141E(Test__ZN4bbbb6zz3141E, "_ZN4bbbb6zz3141E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
extern Class_Descriptor cd__ZN4bbbb5yy141E;
static Base_Class bases__ZN4bbbb6zz3141E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy141E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3141E = {  "_ZN4bbbb6zz3141E", // class name
  bases__ZN4bbbb6zz3141E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4141  : ::bbbb::yy141 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4141E) C1{ BC2{ BC3{ BC4{ Fc} FL} Fc} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4141E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4141E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4bbbb6zz4141E, buf);
    ::bbbb::zz4141 &lv = *(new (buf) ::bbbb::zz4141());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4bbbb6zz4141E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4141E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*)(::bbbb::yy141*), 0, "_ZN4bbbb6zz4141E");
    check_base_class_offset(lv, (::bbbb::xx41*)(::bbbb::yy141*), 0, "_ZN4bbbb6zz4141E");
    check_base_class_offset(lv, (::bbbb::yy141*), 0, "_ZN4bbbb6zz4141E");
    check_field_offset(lv, fd, ABISELECT(24,16), "_ZN4bbbb6zz4141E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4141E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4141E(Test__ZN4bbbb6zz4141E, "_ZN4bbbb6zz4141E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
extern Class_Descriptor cd__ZN4bbbb5yy141E;
static Base_Class bases__ZN4bbbb6zz4141E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy141E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4141E = {  "_ZN4bbbb6zz4141E", // class name
  bases__ZN4bbbb6zz4141E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy241  : ::bbbb::xx41 {
  short fc;
};
//SIG(-1 _ZN4bbbb5yy241E) C1{ BC2{ BC3{ Fc} FL} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy241E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy241E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb5yy241E, buf);
    ::bbbb::yy241 &lv = *(new (buf) ::bbbb::yy241());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb5yy241E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb5yy241E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*), 0, "_ZN4bbbb5yy241E");
    check_base_class_offset(lv, (::bbbb::xx41*), 0, "_ZN4bbbb5yy241E");
    check_field_offset(lv, fc, ABISELECT(16,12), "_ZN4bbbb5yy241E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy241E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy241E(Test__ZN4bbbb5yy241E, "_ZN4bbbb5yy241E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
static Base_Class bases__ZN4bbbb5yy241E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy241E = {  "_ZN4bbbb5yy241E", // class name
  bases__ZN4bbbb5yy241E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0241  : ::bbbb::yy241 {
};
//SIG(1 _ZN4bbbb6zz0241E) C1{ BC2{ BC3{ BC4{ Fc} FL} Fs}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0241E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0241E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz0241E, buf);
    ::bbbb::zz0241 &lv = *(new (buf) ::bbbb::zz0241());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz0241E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz0241E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*)(::bbbb::yy241*), 0, "_ZN4bbbb6zz0241E");
    check_base_class_offset(lv, (::bbbb::xx41*)(::bbbb::yy241*), 0, "_ZN4bbbb6zz0241E");
    check_base_class_offset(lv, (::bbbb::yy241*), 0, "_ZN4bbbb6zz0241E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0241E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0241E(Test__ZN4bbbb6zz0241E, "_ZN4bbbb6zz0241E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
extern Class_Descriptor cd__ZN4bbbb5yy241E;
static Base_Class bases__ZN4bbbb6zz0241E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy241E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0241E = {  "_ZN4bbbb6zz0241E", // class name
  bases__ZN4bbbb6zz0241E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1241  : ::bbbb::yy241 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1241E) C1{ BC2{ BC3{ BC4{ Fc} FL} Fs} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1241E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1241E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz1241E, buf);
    ::bbbb::zz1241 &lv = *(new (buf) ::bbbb::zz1241());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz1241E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz1241E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*)(::bbbb::yy241*), 0, "_ZN4bbbb6zz1241E");
    check_base_class_offset(lv, (::bbbb::xx41*)(::bbbb::yy241*), 0, "_ZN4bbbb6zz1241E");
    check_base_class_offset(lv, (::bbbb::yy241*), 0, "_ZN4bbbb6zz1241E");
    check_field_offset(lv, fd, ABISELECT(18,14), "_ZN4bbbb6zz1241E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1241E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1241E(Test__ZN4bbbb6zz1241E, "_ZN4bbbb6zz1241E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
extern Class_Descriptor cd__ZN4bbbb5yy241E;
static Base_Class bases__ZN4bbbb6zz1241E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy241E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1241E = {  "_ZN4bbbb6zz1241E", // class name
  bases__ZN4bbbb6zz1241E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2241  : ::bbbb::yy241 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2241E) C1{ BC2{ BC3{ BC4{ Fc} FL} Fs} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2241E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2241E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz2241E, buf);
    ::bbbb::zz2241 &lv = *(new (buf) ::bbbb::zz2241());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz2241E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz2241E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*)(::bbbb::yy241*), 0, "_ZN4bbbb6zz2241E");
    check_base_class_offset(lv, (::bbbb::xx41*)(::bbbb::yy241*), 0, "_ZN4bbbb6zz2241E");
    check_base_class_offset(lv, (::bbbb::yy241*), 0, "_ZN4bbbb6zz2241E");
    check_field_offset(lv, fd, ABISELECT(18,14), "_ZN4bbbb6zz2241E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2241E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2241E(Test__ZN4bbbb6zz2241E, "_ZN4bbbb6zz2241E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
extern Class_Descriptor cd__ZN4bbbb5yy241E;
static Base_Class bases__ZN4bbbb6zz2241E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy241E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2241E = {  "_ZN4bbbb6zz2241E", // class name
  bases__ZN4bbbb6zz2241E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3241  : ::bbbb::yy241 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3241E) C1{ BC2{ BC3{ BC4{ Fc} FL} Fs} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3241E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3241E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz3241E, buf);
    ::bbbb::zz3241 &lv = *(new (buf) ::bbbb::zz3241());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz3241E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz3241E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*)(::bbbb::yy241*), 0, "_ZN4bbbb6zz3241E");
    check_base_class_offset(lv, (::bbbb::xx41*)(::bbbb::yy241*), 0, "_ZN4bbbb6zz3241E");
    check_base_class_offset(lv, (::bbbb::yy241*), 0, "_ZN4bbbb6zz3241E");
    check_field_offset(lv, fd, ABISELECT(20,16), "_ZN4bbbb6zz3241E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3241E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3241E(Test__ZN4bbbb6zz3241E, "_ZN4bbbb6zz3241E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
extern Class_Descriptor cd__ZN4bbbb5yy241E;
static Base_Class bases__ZN4bbbb6zz3241E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy241E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3241E = {  "_ZN4bbbb6zz3241E", // class name
  bases__ZN4bbbb6zz3241E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4241  : ::bbbb::yy241 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4241E) C1{ BC2{ BC3{ BC4{ Fc} FL} Fs} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4241E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4241E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4bbbb6zz4241E, buf);
    ::bbbb::zz4241 &lv = *(new (buf) ::bbbb::zz4241());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4bbbb6zz4241E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4241E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*)(::bbbb::yy241*), 0, "_ZN4bbbb6zz4241E");
    check_base_class_offset(lv, (::bbbb::xx41*)(::bbbb::yy241*), 0, "_ZN4bbbb6zz4241E");
    check_base_class_offset(lv, (::bbbb::yy241*), 0, "_ZN4bbbb6zz4241E");
    check_field_offset(lv, fd, ABISELECT(24,16), "_ZN4bbbb6zz4241E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4241E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4241E(Test__ZN4bbbb6zz4241E, "_ZN4bbbb6zz4241E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
extern Class_Descriptor cd__ZN4bbbb5yy241E;
static Base_Class bases__ZN4bbbb6zz4241E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy241E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4241E = {  "_ZN4bbbb6zz4241E", // class name
  bases__ZN4bbbb6zz4241E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy341  : ::bbbb::xx41 {
  int fc;
};
//SIG(-1 _ZN4bbbb5yy341E) C1{ BC2{ BC3{ Fc} FL} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy341E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy341E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb5yy341E, buf);
    ::bbbb::yy341 &lv = *(new (buf) ::bbbb::yy341());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb5yy341E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb5yy341E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*), 0, "_ZN4bbbb5yy341E");
    check_base_class_offset(lv, (::bbbb::xx41*), 0, "_ZN4bbbb5yy341E");
    check_field_offset(lv, fc, ABISELECT(16,12), "_ZN4bbbb5yy341E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy341E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy341E(Test__ZN4bbbb5yy341E, "_ZN4bbbb5yy341E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
static Base_Class bases__ZN4bbbb5yy341E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy341E = {  "_ZN4bbbb5yy341E", // class name
  bases__ZN4bbbb5yy341E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0341  : ::bbbb::yy341 {
};
//SIG(1 _ZN4bbbb6zz0341E) C1{ BC2{ BC3{ BC4{ Fc} FL} Fi}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0341E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0341E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz0341E, buf);
    ::bbbb::zz0341 &lv = *(new (buf) ::bbbb::zz0341());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz0341E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz0341E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*)(::bbbb::yy341*), 0, "_ZN4bbbb6zz0341E");
    check_base_class_offset(lv, (::bbbb::xx41*)(::bbbb::yy341*), 0, "_ZN4bbbb6zz0341E");
    check_base_class_offset(lv, (::bbbb::yy341*), 0, "_ZN4bbbb6zz0341E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0341E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0341E(Test__ZN4bbbb6zz0341E, "_ZN4bbbb6zz0341E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
extern Class_Descriptor cd__ZN4bbbb5yy341E;
static Base_Class bases__ZN4bbbb6zz0341E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy341E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0341E = {  "_ZN4bbbb6zz0341E", // class name
  bases__ZN4bbbb6zz0341E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1341  : ::bbbb::yy341 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1341E) C1{ BC2{ BC3{ BC4{ Fc} FL} Fi} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1341E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1341E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz1341E, buf);
    ::bbbb::zz1341 &lv = *(new (buf) ::bbbb::zz1341());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz1341E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz1341E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*)(::bbbb::yy341*), 0, "_ZN4bbbb6zz1341E");
    check_base_class_offset(lv, (::bbbb::xx41*)(::bbbb::yy341*), 0, "_ZN4bbbb6zz1341E");
    check_base_class_offset(lv, (::bbbb::yy341*), 0, "_ZN4bbbb6zz1341E");
    check_field_offset(lv, fd, ABISELECT(20,16), "_ZN4bbbb6zz1341E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1341E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1341E(Test__ZN4bbbb6zz1341E, "_ZN4bbbb6zz1341E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
extern Class_Descriptor cd__ZN4bbbb5yy341E;
static Base_Class bases__ZN4bbbb6zz1341E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy341E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1341E = {  "_ZN4bbbb6zz1341E", // class name
  bases__ZN4bbbb6zz1341E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2341  : ::bbbb::yy341 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2341E) C1{ BC2{ BC3{ BC4{ Fc} FL} Fi} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2341E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2341E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz2341E, buf);
    ::bbbb::zz2341 &lv = *(new (buf) ::bbbb::zz2341());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz2341E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz2341E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*)(::bbbb::yy341*), 0, "_ZN4bbbb6zz2341E");
    check_base_class_offset(lv, (::bbbb::xx41*)(::bbbb::yy341*), 0, "_ZN4bbbb6zz2341E");
    check_base_class_offset(lv, (::bbbb::yy341*), 0, "_ZN4bbbb6zz2341E");
    check_field_offset(lv, fd, ABISELECT(20,16), "_ZN4bbbb6zz2341E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2341E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2341E(Test__ZN4bbbb6zz2341E, "_ZN4bbbb6zz2341E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
extern Class_Descriptor cd__ZN4bbbb5yy341E;
static Base_Class bases__ZN4bbbb6zz2341E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy341E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2341E = {  "_ZN4bbbb6zz2341E", // class name
  bases__ZN4bbbb6zz2341E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3341  : ::bbbb::yy341 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3341E) C1{ BC2{ BC3{ BC4{ Fc} FL} Fi} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3341E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3341E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz3341E, buf);
    ::bbbb::zz3341 &lv = *(new (buf) ::bbbb::zz3341());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz3341E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz3341E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*)(::bbbb::yy341*), 0, "_ZN4bbbb6zz3341E");
    check_base_class_offset(lv, (::bbbb::xx41*)(::bbbb::yy341*), 0, "_ZN4bbbb6zz3341E");
    check_base_class_offset(lv, (::bbbb::yy341*), 0, "_ZN4bbbb6zz3341E");
    check_field_offset(lv, fd, ABISELECT(20,16), "_ZN4bbbb6zz3341E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3341E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3341E(Test__ZN4bbbb6zz3341E, "_ZN4bbbb6zz3341E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
extern Class_Descriptor cd__ZN4bbbb5yy341E;
static Base_Class bases__ZN4bbbb6zz3341E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy341E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3341E = {  "_ZN4bbbb6zz3341E", // class name
  bases__ZN4bbbb6zz3341E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4341  : ::bbbb::yy341 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4341E) C1{ BC2{ BC3{ BC4{ Fc} FL} Fi} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4341E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4341E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4bbbb6zz4341E, buf);
    ::bbbb::zz4341 &lv = *(new (buf) ::bbbb::zz4341());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4bbbb6zz4341E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4341E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*)(::bbbb::yy341*), 0, "_ZN4bbbb6zz4341E");
    check_base_class_offset(lv, (::bbbb::xx41*)(::bbbb::yy341*), 0, "_ZN4bbbb6zz4341E");
    check_base_class_offset(lv, (::bbbb::yy341*), 0, "_ZN4bbbb6zz4341E");
    check_field_offset(lv, fd, ABISELECT(24,16), "_ZN4bbbb6zz4341E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4341E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4341E(Test__ZN4bbbb6zz4341E, "_ZN4bbbb6zz4341E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
extern Class_Descriptor cd__ZN4bbbb5yy341E;
static Base_Class bases__ZN4bbbb6zz4341E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy341E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4341E = {  "_ZN4bbbb6zz4341E", // class name
  bases__ZN4bbbb6zz4341E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy441  : ::bbbb::xx41 {
  double fc;
};
//SIG(-1 _ZN4bbbb5yy441E) C1{ BC2{ BC3{ Fc} FL} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy441E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy441E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb5yy441E, buf);
    ::bbbb::yy441 &lv = *(new (buf) ::bbbb::yy441());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb5yy441E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb5yy441E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*), 0, "_ZN4bbbb5yy441E");
    check_base_class_offset(lv, (::bbbb::xx41*), 0, "_ZN4bbbb5yy441E");
    check_field_offset(lv, fc, ABISELECT(16,12), "_ZN4bbbb5yy441E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy441E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy441E(Test__ZN4bbbb5yy441E, "_ZN4bbbb5yy441E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
static Base_Class bases__ZN4bbbb5yy441E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy441E = {  "_ZN4bbbb5yy441E", // class name
  bases__ZN4bbbb5yy441E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0441  : ::bbbb::yy441 {
};
//SIG(1 _ZN4bbbb6zz0441E) C1{ BC2{ BC3{ BC4{ Fc} FL} FL}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0441E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0441E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz0441E, buf);
    ::bbbb::zz0441 &lv = *(new (buf) ::bbbb::zz0441());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz0441E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz0441E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*)(::bbbb::yy441*), 0, "_ZN4bbbb6zz0441E");
    check_base_class_offset(lv, (::bbbb::xx41*)(::bbbb::yy441*), 0, "_ZN4bbbb6zz0441E");
    check_base_class_offset(lv, (::bbbb::yy441*), 0, "_ZN4bbbb6zz0441E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0441E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0441E(Test__ZN4bbbb6zz0441E, "_ZN4bbbb6zz0441E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
extern Class_Descriptor cd__ZN4bbbb5yy441E;
static Base_Class bases__ZN4bbbb6zz0441E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy441E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0441E = {  "_ZN4bbbb6zz0441E", // class name
  bases__ZN4bbbb6zz0441E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1441  : ::bbbb::yy441 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1441E) C1{ BC2{ BC3{ BC4{ Fc} FL} FL} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1441E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1441E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4bbbb6zz1441E, buf);
    ::bbbb::zz1441 &lv = *(new (buf) ::bbbb::zz1441());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4bbbb6zz1441E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz1441E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*)(::bbbb::yy441*), 0, "_ZN4bbbb6zz1441E");
    check_base_class_offset(lv, (::bbbb::xx41*)(::bbbb::yy441*), 0, "_ZN4bbbb6zz1441E");
    check_base_class_offset(lv, (::bbbb::yy441*), 0, "_ZN4bbbb6zz1441E");
    check_field_offset(lv, fd, ABISELECT(24,20), "_ZN4bbbb6zz1441E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1441E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1441E(Test__ZN4bbbb6zz1441E, "_ZN4bbbb6zz1441E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
extern Class_Descriptor cd__ZN4bbbb5yy441E;
static Base_Class bases__ZN4bbbb6zz1441E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy441E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1441E = {  "_ZN4bbbb6zz1441E", // class name
  bases__ZN4bbbb6zz1441E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2441  : ::bbbb::yy441 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2441E) C1{ BC2{ BC3{ BC4{ Fc} FL} FL} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2441E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2441E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4bbbb6zz2441E, buf);
    ::bbbb::zz2441 &lv = *(new (buf) ::bbbb::zz2441());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4bbbb6zz2441E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz2441E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*)(::bbbb::yy441*), 0, "_ZN4bbbb6zz2441E");
    check_base_class_offset(lv, (::bbbb::xx41*)(::bbbb::yy441*), 0, "_ZN4bbbb6zz2441E");
    check_base_class_offset(lv, (::bbbb::yy441*), 0, "_ZN4bbbb6zz2441E");
    check_field_offset(lv, fd, ABISELECT(24,20), "_ZN4bbbb6zz2441E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2441E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2441E(Test__ZN4bbbb6zz2441E, "_ZN4bbbb6zz2441E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
extern Class_Descriptor cd__ZN4bbbb5yy441E;
static Base_Class bases__ZN4bbbb6zz2441E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy441E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2441E = {  "_ZN4bbbb6zz2441E", // class name
  bases__ZN4bbbb6zz2441E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3441  : ::bbbb::yy441 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3441E) C1{ BC2{ BC3{ BC4{ Fc} FL} FL} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3441E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3441E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4bbbb6zz3441E, buf);
    ::bbbb::zz3441 &lv = *(new (buf) ::bbbb::zz3441());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4bbbb6zz3441E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz3441E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*)(::bbbb::yy441*), 0, "_ZN4bbbb6zz3441E");
    check_base_class_offset(lv, (::bbbb::xx41*)(::bbbb::yy441*), 0, "_ZN4bbbb6zz3441E");
    check_base_class_offset(lv, (::bbbb::yy441*), 0, "_ZN4bbbb6zz3441E");
    check_field_offset(lv, fd, ABISELECT(24,20), "_ZN4bbbb6zz3441E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3441E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3441E(Test__ZN4bbbb6zz3441E, "_ZN4bbbb6zz3441E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
extern Class_Descriptor cd__ZN4bbbb5yy441E;
static Base_Class bases__ZN4bbbb6zz3441E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy441E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3441E = {  "_ZN4bbbb6zz3441E", // class name
  bases__ZN4bbbb6zz3441E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4441  : ::bbbb::yy441 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4441E) C1{ BC2{ BC3{ BC4{ Fc} FL} FL} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4441E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4441E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,8)];
    init_test(&cd__ZN4bbbb6zz4441E, buf);
    ::bbbb::zz4441 &lv = *(new (buf) ::bbbb::zz4441());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,28), "sizeof(_ZN4bbbb6zz4441E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4441E)");
    check_base_class_offset(lv, (::bbbb::ww1*)(::bbbb::xx41*)(::bbbb::yy441*), 0, "_ZN4bbbb6zz4441E");
    check_base_class_offset(lv, (::bbbb::xx41*)(::bbbb::yy441*), 0, "_ZN4bbbb6zz4441E");
    check_base_class_offset(lv, (::bbbb::yy441*), 0, "_ZN4bbbb6zz4441E");
    check_field_offset(lv, fd, ABISELECT(24,20), "_ZN4bbbb6zz4441E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4441E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4441E(Test__ZN4bbbb6zz4441E, "_ZN4bbbb6zz4441E", ABISELECT(32,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww1E;
extern Class_Descriptor cd__ZN4bbbb4xx41E;
extern Class_Descriptor cd__ZN4bbbb5yy441E;
static Base_Class bases__ZN4bbbb6zz4441E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx41E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy441E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4441E = {  "_ZN4bbbb6zz4441E", // class name
  bases__ZN4bbbb6zz4441E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  ww2  {
  short fa;
};
//SIG(-1 _ZN4bbbb3ww2E) C1{ Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb3ww2E()
{
  {
    init_simple_test("_ZN4bbbb3ww2E");
    ::bbbb::ww2 lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4bbbb3ww2E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb3ww2E)");
    check_field_offset(lv, fa, 0, "_ZN4bbbb3ww2E.fa");
  }
}
static Arrange_To_Call_Me v_ZN4bbbb3ww2E(Test__ZN4bbbb3ww2E, "_ZN4bbbb3ww2E", 2);

#else // __cplusplus

Class_Descriptor cd__ZN4bbbb3ww2E = {  "_ZN4bbbb3ww2E", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  xx02  : ::bbbb::ww2 {
};
//SIG(-1 _ZN4bbbb4xx02E) C1{ BC2{ Fs}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb4xx02E()
{
  extern Class_Descriptor cd__ZN4bbbb4xx02E;
  void *lvp;
  {
    short buf[2];
    init_test(&cd__ZN4bbbb4xx02E, buf);
    ::bbbb::xx02 &lv = *(new (buf) ::bbbb::xx02());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4bbbb4xx02E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb4xx02E)");
    check_base_class_offset(lv, (::bbbb::ww2*), 0, "_ZN4bbbb4xx02E");
    test_class_info(&lv, &cd__ZN4bbbb4xx02E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb4xx02E(Test__ZN4bbbb4xx02E, "_ZN4bbbb4xx02E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
static Base_Class bases__ZN4bbbb4xx02E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb4xx02E = {  "_ZN4bbbb4xx02E", // class name
  bases__ZN4bbbb4xx02E, 1,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy002  : ::bbbb::xx02 {
};
//SIG(-1 _ZN4bbbb5yy002E) C1{ BC2{ BC3{ Fs}}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy002E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy002E;
  void *lvp;
  {
    short buf[2];
    init_test(&cd__ZN4bbbb5yy002E, buf);
    ::bbbb::yy002 &lv = *(new (buf) ::bbbb::yy002());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4bbbb5yy002E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb5yy002E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*), 0, "_ZN4bbbb5yy002E");
    check_base_class_offset(lv, (::bbbb::xx02*), 0, "_ZN4bbbb5yy002E");
    test_class_info(&lv, &cd__ZN4bbbb5yy002E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy002E(Test__ZN4bbbb5yy002E, "_ZN4bbbb5yy002E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
static Base_Class bases__ZN4bbbb5yy002E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy002E = {  "_ZN4bbbb5yy002E", // class name
  bases__ZN4bbbb5yy002E, 2,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0002  : ::bbbb::yy002 {
};
//SIG(1 _ZN4bbbb6zz0002E) C1{ BC2{ BC3{ BC4{ Fs}}}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0002E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0002E;
  void *lvp;
  {
    short buf[2];
    init_test(&cd__ZN4bbbb6zz0002E, buf);
    ::bbbb::zz0002 &lv = *(new (buf) ::bbbb::zz0002());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4bbbb6zz0002E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz0002E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*)(::bbbb::yy002*), 0, "_ZN4bbbb6zz0002E");
    check_base_class_offset(lv, (::bbbb::xx02*)(::bbbb::yy002*), 0, "_ZN4bbbb6zz0002E");
    check_base_class_offset(lv, (::bbbb::yy002*), 0, "_ZN4bbbb6zz0002E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0002E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0002E(Test__ZN4bbbb6zz0002E, "_ZN4bbbb6zz0002E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
extern Class_Descriptor cd__ZN4bbbb5yy002E;
static Base_Class bases__ZN4bbbb6zz0002E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy002E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0002E = {  "_ZN4bbbb6zz0002E", // class name
  bases__ZN4bbbb6zz0002E, 3,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1002  : ::bbbb::yy002 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1002E) C1{ BC2{ BC3{ BC4{ Fs}}} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1002E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1002E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb6zz1002E, buf);
    ::bbbb::zz1002 &lv = *(new (buf) ::bbbb::zz1002());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz1002E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz1002E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*)(::bbbb::yy002*), 0, "_ZN4bbbb6zz1002E");
    check_base_class_offset(lv, (::bbbb::xx02*)(::bbbb::yy002*), 0, "_ZN4bbbb6zz1002E");
    check_base_class_offset(lv, (::bbbb::yy002*), 0, "_ZN4bbbb6zz1002E");
    check_field_offset(lv, fd, 2, "_ZN4bbbb6zz1002E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1002E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1002E(Test__ZN4bbbb6zz1002E, "_ZN4bbbb6zz1002E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
extern Class_Descriptor cd__ZN4bbbb5yy002E;
static Base_Class bases__ZN4bbbb6zz1002E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy002E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1002E = {  "_ZN4bbbb6zz1002E", // class name
  bases__ZN4bbbb6zz1002E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2002  : ::bbbb::yy002 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2002E) C1{ BC2{ BC3{ BC4{ Fs}}} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2002E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2002E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb6zz2002E, buf);
    ::bbbb::zz2002 &lv = *(new (buf) ::bbbb::zz2002());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz2002E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz2002E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*)(::bbbb::yy002*), 0, "_ZN4bbbb6zz2002E");
    check_base_class_offset(lv, (::bbbb::xx02*)(::bbbb::yy002*), 0, "_ZN4bbbb6zz2002E");
    check_base_class_offset(lv, (::bbbb::yy002*), 0, "_ZN4bbbb6zz2002E");
    check_field_offset(lv, fd, 2, "_ZN4bbbb6zz2002E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2002E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2002E(Test__ZN4bbbb6zz2002E, "_ZN4bbbb6zz2002E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
extern Class_Descriptor cd__ZN4bbbb5yy002E;
static Base_Class bases__ZN4bbbb6zz2002E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy002E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2002E = {  "_ZN4bbbb6zz2002E", // class name
  bases__ZN4bbbb6zz2002E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3002  : ::bbbb::yy002 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3002E) C1{ BC2{ BC3{ BC4{ Fs}}} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3002E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3002E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz3002E, buf);
    ::bbbb::zz3002 &lv = *(new (buf) ::bbbb::zz3002());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz3002E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3002E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*)(::bbbb::yy002*), 0, "_ZN4bbbb6zz3002E");
    check_base_class_offset(lv, (::bbbb::xx02*)(::bbbb::yy002*), 0, "_ZN4bbbb6zz3002E");
    check_base_class_offset(lv, (::bbbb::yy002*), 0, "_ZN4bbbb6zz3002E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz3002E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3002E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3002E(Test__ZN4bbbb6zz3002E, "_ZN4bbbb6zz3002E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
extern Class_Descriptor cd__ZN4bbbb5yy002E;
static Base_Class bases__ZN4bbbb6zz3002E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy002E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3002E = {  "_ZN4bbbb6zz3002E", // class name
  bases__ZN4bbbb6zz3002E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4002  : ::bbbb::yy002 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4002E) C1{ BC2{ BC3{ BC4{ Fs}}} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4002E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4002E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz4002E, buf);
    ::bbbb::zz4002 &lv = *(new (buf) ::bbbb::zz4002());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz4002E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4002E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*)(::bbbb::yy002*), 0, "_ZN4bbbb6zz4002E");
    check_base_class_offset(lv, (::bbbb::xx02*)(::bbbb::yy002*), 0, "_ZN4bbbb6zz4002E");
    check_base_class_offset(lv, (::bbbb::yy002*), 0, "_ZN4bbbb6zz4002E");
    check_field_offset(lv, fd, ABISELECT(8,4), "_ZN4bbbb6zz4002E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4002E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4002E(Test__ZN4bbbb6zz4002E, "_ZN4bbbb6zz4002E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
extern Class_Descriptor cd__ZN4bbbb5yy002E;
static Base_Class bases__ZN4bbbb6zz4002E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy002E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4002E = {  "_ZN4bbbb6zz4002E", // class name
  bases__ZN4bbbb6zz4002E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy102  : ::bbbb::xx02 {
  char fc;
};
//SIG(-1 _ZN4bbbb5yy102E) C1{ BC2{ BC3{ Fs}} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy102E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy102E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb5yy102E, buf);
    ::bbbb::yy102 &lv = *(new (buf) ::bbbb::yy102());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb5yy102E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb5yy102E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*), 0, "_ZN4bbbb5yy102E");
    check_base_class_offset(lv, (::bbbb::xx02*), 0, "_ZN4bbbb5yy102E");
    check_field_offset(lv, fc, 2, "_ZN4bbbb5yy102E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy102E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy102E(Test__ZN4bbbb5yy102E, "_ZN4bbbb5yy102E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
static Base_Class bases__ZN4bbbb5yy102E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy102E = {  "_ZN4bbbb5yy102E", // class name
  bases__ZN4bbbb5yy102E, 2,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0102  : ::bbbb::yy102 {
};
//SIG(1 _ZN4bbbb6zz0102E) C1{ BC2{ BC3{ BC4{ Fs}} Fc}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0102E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0102E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb6zz0102E, buf);
    ::bbbb::zz0102 &lv = *(new (buf) ::bbbb::zz0102());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz0102E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz0102E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*)(::bbbb::yy102*), 0, "_ZN4bbbb6zz0102E");
    check_base_class_offset(lv, (::bbbb::xx02*)(::bbbb::yy102*), 0, "_ZN4bbbb6zz0102E");
    check_base_class_offset(lv, (::bbbb::yy102*), 0, "_ZN4bbbb6zz0102E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0102E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0102E(Test__ZN4bbbb6zz0102E, "_ZN4bbbb6zz0102E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
extern Class_Descriptor cd__ZN4bbbb5yy102E;
static Base_Class bases__ZN4bbbb6zz0102E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy102E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0102E = {  "_ZN4bbbb6zz0102E", // class name
  bases__ZN4bbbb6zz0102E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1102  : ::bbbb::yy102 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1102E) C1{ BC2{ BC3{ BC4{ Fs}} Fc} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1102E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1102E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb6zz1102E, buf);
    ::bbbb::zz1102 &lv = *(new (buf) ::bbbb::zz1102());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz1102E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz1102E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*)(::bbbb::yy102*), 0, "_ZN4bbbb6zz1102E");
    check_base_class_offset(lv, (::bbbb::xx02*)(::bbbb::yy102*), 0, "_ZN4bbbb6zz1102E");
    check_base_class_offset(lv, (::bbbb::yy102*), 0, "_ZN4bbbb6zz1102E");
    check_field_offset(lv, fd, 3, "_ZN4bbbb6zz1102E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1102E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1102E(Test__ZN4bbbb6zz1102E, "_ZN4bbbb6zz1102E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
extern Class_Descriptor cd__ZN4bbbb5yy102E;
static Base_Class bases__ZN4bbbb6zz1102E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy102E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1102E = {  "_ZN4bbbb6zz1102E", // class name
  bases__ZN4bbbb6zz1102E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2102  : ::bbbb::yy102 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2102E) C1{ BC2{ BC3{ BC4{ Fs}} Fc} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2102E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2102E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb6zz2102E, buf);
    ::bbbb::zz2102 &lv = *(new (buf) ::bbbb::zz2102());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb6zz2102E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz2102E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*)(::bbbb::yy102*), 0, "_ZN4bbbb6zz2102E");
    check_base_class_offset(lv, (::bbbb::xx02*)(::bbbb::yy102*), 0, "_ZN4bbbb6zz2102E");
    check_base_class_offset(lv, (::bbbb::yy102*), 0, "_ZN4bbbb6zz2102E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz2102E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2102E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2102E(Test__ZN4bbbb6zz2102E, "_ZN4bbbb6zz2102E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
extern Class_Descriptor cd__ZN4bbbb5yy102E;
static Base_Class bases__ZN4bbbb6zz2102E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy102E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2102E = {  "_ZN4bbbb6zz2102E", // class name
  bases__ZN4bbbb6zz2102E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3102  : ::bbbb::yy102 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3102E) C1{ BC2{ BC3{ BC4{ Fs}} Fc} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3102E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3102E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz3102E, buf);
    ::bbbb::zz3102 &lv = *(new (buf) ::bbbb::zz3102());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz3102E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3102E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*)(::bbbb::yy102*), 0, "_ZN4bbbb6zz3102E");
    check_base_class_offset(lv, (::bbbb::xx02*)(::bbbb::yy102*), 0, "_ZN4bbbb6zz3102E");
    check_base_class_offset(lv, (::bbbb::yy102*), 0, "_ZN4bbbb6zz3102E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz3102E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3102E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3102E(Test__ZN4bbbb6zz3102E, "_ZN4bbbb6zz3102E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
extern Class_Descriptor cd__ZN4bbbb5yy102E;
static Base_Class bases__ZN4bbbb6zz3102E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy102E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3102E = {  "_ZN4bbbb6zz3102E", // class name
  bases__ZN4bbbb6zz3102E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4102  : ::bbbb::yy102 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4102E) C1{ BC2{ BC3{ BC4{ Fs}} Fc} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4102E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4102E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz4102E, buf);
    ::bbbb::zz4102 &lv = *(new (buf) ::bbbb::zz4102());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz4102E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4102E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*)(::bbbb::yy102*), 0, "_ZN4bbbb6zz4102E");
    check_base_class_offset(lv, (::bbbb::xx02*)(::bbbb::yy102*), 0, "_ZN4bbbb6zz4102E");
    check_base_class_offset(lv, (::bbbb::yy102*), 0, "_ZN4bbbb6zz4102E");
    check_field_offset(lv, fd, ABISELECT(8,4), "_ZN4bbbb6zz4102E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4102E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4102E(Test__ZN4bbbb6zz4102E, "_ZN4bbbb6zz4102E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
extern Class_Descriptor cd__ZN4bbbb5yy102E;
static Base_Class bases__ZN4bbbb6zz4102E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy102E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4102E = {  "_ZN4bbbb6zz4102E", // class name
  bases__ZN4bbbb6zz4102E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy202  : ::bbbb::xx02 {
  short fc;
};
//SIG(-1 _ZN4bbbb5yy202E) C1{ BC2{ BC3{ Fs}} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy202E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy202E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb5yy202E, buf);
    ::bbbb::yy202 &lv = *(new (buf) ::bbbb::yy202());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb5yy202E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb5yy202E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*), 0, "_ZN4bbbb5yy202E");
    check_base_class_offset(lv, (::bbbb::xx02*), 0, "_ZN4bbbb5yy202E");
    check_field_offset(lv, fc, 2, "_ZN4bbbb5yy202E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy202E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy202E(Test__ZN4bbbb5yy202E, "_ZN4bbbb5yy202E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
static Base_Class bases__ZN4bbbb5yy202E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy202E = {  "_ZN4bbbb5yy202E", // class name
  bases__ZN4bbbb5yy202E, 2,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0202  : ::bbbb::yy202 {
};
//SIG(1 _ZN4bbbb6zz0202E) C1{ BC2{ BC3{ BC4{ Fs}} Fs}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0202E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0202E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb6zz0202E, buf);
    ::bbbb::zz0202 &lv = *(new (buf) ::bbbb::zz0202());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz0202E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz0202E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*)(::bbbb::yy202*), 0, "_ZN4bbbb6zz0202E");
    check_base_class_offset(lv, (::bbbb::xx02*)(::bbbb::yy202*), 0, "_ZN4bbbb6zz0202E");
    check_base_class_offset(lv, (::bbbb::yy202*), 0, "_ZN4bbbb6zz0202E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0202E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0202E(Test__ZN4bbbb6zz0202E, "_ZN4bbbb6zz0202E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
extern Class_Descriptor cd__ZN4bbbb5yy202E;
static Base_Class bases__ZN4bbbb6zz0202E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy202E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0202E = {  "_ZN4bbbb6zz0202E", // class name
  bases__ZN4bbbb6zz0202E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1202  : ::bbbb::yy202 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1202E) C1{ BC2{ BC3{ BC4{ Fs}} Fs} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1202E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1202E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb6zz1202E, buf);
    ::bbbb::zz1202 &lv = *(new (buf) ::bbbb::zz1202());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb6zz1202E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz1202E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*)(::bbbb::yy202*), 0, "_ZN4bbbb6zz1202E");
    check_base_class_offset(lv, (::bbbb::xx02*)(::bbbb::yy202*), 0, "_ZN4bbbb6zz1202E");
    check_base_class_offset(lv, (::bbbb::yy202*), 0, "_ZN4bbbb6zz1202E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz1202E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1202E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1202E(Test__ZN4bbbb6zz1202E, "_ZN4bbbb6zz1202E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
extern Class_Descriptor cd__ZN4bbbb5yy202E;
static Base_Class bases__ZN4bbbb6zz1202E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy202E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1202E = {  "_ZN4bbbb6zz1202E", // class name
  bases__ZN4bbbb6zz1202E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2202  : ::bbbb::yy202 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2202E) C1{ BC2{ BC3{ BC4{ Fs}} Fs} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2202E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2202E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb6zz2202E, buf);
    ::bbbb::zz2202 &lv = *(new (buf) ::bbbb::zz2202());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb6zz2202E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz2202E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*)(::bbbb::yy202*), 0, "_ZN4bbbb6zz2202E");
    check_base_class_offset(lv, (::bbbb::xx02*)(::bbbb::yy202*), 0, "_ZN4bbbb6zz2202E");
    check_base_class_offset(lv, (::bbbb::yy202*), 0, "_ZN4bbbb6zz2202E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz2202E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2202E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2202E(Test__ZN4bbbb6zz2202E, "_ZN4bbbb6zz2202E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
extern Class_Descriptor cd__ZN4bbbb5yy202E;
static Base_Class bases__ZN4bbbb6zz2202E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy202E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2202E = {  "_ZN4bbbb6zz2202E", // class name
  bases__ZN4bbbb6zz2202E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3202  : ::bbbb::yy202 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3202E) C1{ BC2{ BC3{ BC4{ Fs}} Fs} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3202E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3202E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz3202E, buf);
    ::bbbb::zz3202 &lv = *(new (buf) ::bbbb::zz3202());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz3202E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3202E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*)(::bbbb::yy202*), 0, "_ZN4bbbb6zz3202E");
    check_base_class_offset(lv, (::bbbb::xx02*)(::bbbb::yy202*), 0, "_ZN4bbbb6zz3202E");
    check_base_class_offset(lv, (::bbbb::yy202*), 0, "_ZN4bbbb6zz3202E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz3202E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3202E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3202E(Test__ZN4bbbb6zz3202E, "_ZN4bbbb6zz3202E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
extern Class_Descriptor cd__ZN4bbbb5yy202E;
static Base_Class bases__ZN4bbbb6zz3202E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy202E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3202E = {  "_ZN4bbbb6zz3202E", // class name
  bases__ZN4bbbb6zz3202E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4202  : ::bbbb::yy202 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4202E) C1{ BC2{ BC3{ BC4{ Fs}} Fs} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4202E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4202E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz4202E, buf);
    ::bbbb::zz4202 &lv = *(new (buf) ::bbbb::zz4202());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz4202E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4202E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*)(::bbbb::yy202*), 0, "_ZN4bbbb6zz4202E");
    check_base_class_offset(lv, (::bbbb::xx02*)(::bbbb::yy202*), 0, "_ZN4bbbb6zz4202E");
    check_base_class_offset(lv, (::bbbb::yy202*), 0, "_ZN4bbbb6zz4202E");
    check_field_offset(lv, fd, ABISELECT(8,4), "_ZN4bbbb6zz4202E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4202E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4202E(Test__ZN4bbbb6zz4202E, "_ZN4bbbb6zz4202E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
extern Class_Descriptor cd__ZN4bbbb5yy202E;
static Base_Class bases__ZN4bbbb6zz4202E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy202E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4202E = {  "_ZN4bbbb6zz4202E", // class name
  bases__ZN4bbbb6zz4202E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy302  : ::bbbb::xx02 {
  int fc;
};
//SIG(-1 _ZN4bbbb5yy302E) C1{ BC2{ BC3{ Fs}} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy302E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy302E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb5yy302E, buf);
    ::bbbb::yy302 &lv = *(new (buf) ::bbbb::yy302());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb5yy302E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb5yy302E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*), 0, "_ZN4bbbb5yy302E");
    check_base_class_offset(lv, (::bbbb::xx02*), 0, "_ZN4bbbb5yy302E");
    check_field_offset(lv, fc, 4, "_ZN4bbbb5yy302E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy302E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy302E(Test__ZN4bbbb5yy302E, "_ZN4bbbb5yy302E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
static Base_Class bases__ZN4bbbb5yy302E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy302E = {  "_ZN4bbbb5yy302E", // class name
  bases__ZN4bbbb5yy302E, 2,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0302  : ::bbbb::yy302 {
};
//SIG(1 _ZN4bbbb6zz0302E) C1{ BC2{ BC3{ BC4{ Fs}} Fi}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0302E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0302E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz0302E, buf);
    ::bbbb::zz0302 &lv = *(new (buf) ::bbbb::zz0302());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz0302E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz0302E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*)(::bbbb::yy302*), 0, "_ZN4bbbb6zz0302E");
    check_base_class_offset(lv, (::bbbb::xx02*)(::bbbb::yy302*), 0, "_ZN4bbbb6zz0302E");
    check_base_class_offset(lv, (::bbbb::yy302*), 0, "_ZN4bbbb6zz0302E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0302E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0302E(Test__ZN4bbbb6zz0302E, "_ZN4bbbb6zz0302E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
extern Class_Descriptor cd__ZN4bbbb5yy302E;
static Base_Class bases__ZN4bbbb6zz0302E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy302E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0302E = {  "_ZN4bbbb6zz0302E", // class name
  bases__ZN4bbbb6zz0302E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1302  : ::bbbb::yy302 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1302E) C1{ BC2{ BC3{ BC4{ Fs}} Fi} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1302E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1302E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz1302E, buf);
    ::bbbb::zz1302 &lv = *(new (buf) ::bbbb::zz1302());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz1302E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz1302E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*)(::bbbb::yy302*), 0, "_ZN4bbbb6zz1302E");
    check_base_class_offset(lv, (::bbbb::xx02*)(::bbbb::yy302*), 0, "_ZN4bbbb6zz1302E");
    check_base_class_offset(lv, (::bbbb::yy302*), 0, "_ZN4bbbb6zz1302E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz1302E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1302E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1302E(Test__ZN4bbbb6zz1302E, "_ZN4bbbb6zz1302E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
extern Class_Descriptor cd__ZN4bbbb5yy302E;
static Base_Class bases__ZN4bbbb6zz1302E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy302E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1302E = {  "_ZN4bbbb6zz1302E", // class name
  bases__ZN4bbbb6zz1302E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2302  : ::bbbb::yy302 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2302E) C1{ BC2{ BC3{ BC4{ Fs}} Fi} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2302E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2302E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz2302E, buf);
    ::bbbb::zz2302 &lv = *(new (buf) ::bbbb::zz2302());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz2302E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz2302E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*)(::bbbb::yy302*), 0, "_ZN4bbbb6zz2302E");
    check_base_class_offset(lv, (::bbbb::xx02*)(::bbbb::yy302*), 0, "_ZN4bbbb6zz2302E");
    check_base_class_offset(lv, (::bbbb::yy302*), 0, "_ZN4bbbb6zz2302E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz2302E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2302E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2302E(Test__ZN4bbbb6zz2302E, "_ZN4bbbb6zz2302E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
extern Class_Descriptor cd__ZN4bbbb5yy302E;
static Base_Class bases__ZN4bbbb6zz2302E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy302E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2302E = {  "_ZN4bbbb6zz2302E", // class name
  bases__ZN4bbbb6zz2302E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3302  : ::bbbb::yy302 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3302E) C1{ BC2{ BC3{ BC4{ Fs}} Fi} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3302E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3302E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz3302E, buf);
    ::bbbb::zz3302 &lv = *(new (buf) ::bbbb::zz3302());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz3302E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3302E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*)(::bbbb::yy302*), 0, "_ZN4bbbb6zz3302E");
    check_base_class_offset(lv, (::bbbb::xx02*)(::bbbb::yy302*), 0, "_ZN4bbbb6zz3302E");
    check_base_class_offset(lv, (::bbbb::yy302*), 0, "_ZN4bbbb6zz3302E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz3302E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3302E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3302E(Test__ZN4bbbb6zz3302E, "_ZN4bbbb6zz3302E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
extern Class_Descriptor cd__ZN4bbbb5yy302E;
static Base_Class bases__ZN4bbbb6zz3302E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy302E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3302E = {  "_ZN4bbbb6zz3302E", // class name
  bases__ZN4bbbb6zz3302E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4302  : ::bbbb::yy302 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4302E) C1{ BC2{ BC3{ BC4{ Fs}} Fi} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4302E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4302E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,5)];
    init_test(&cd__ZN4bbbb6zz4302E, buf);
    ::bbbb::zz4302 &lv = *(new (buf) ::bbbb::zz4302());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz4302E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4302E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*)(::bbbb::yy302*), 0, "_ZN4bbbb6zz4302E");
    check_base_class_offset(lv, (::bbbb::xx02*)(::bbbb::yy302*), 0, "_ZN4bbbb6zz4302E");
    check_base_class_offset(lv, (::bbbb::yy302*), 0, "_ZN4bbbb6zz4302E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz4302E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4302E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4302E(Test__ZN4bbbb6zz4302E, "_ZN4bbbb6zz4302E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
extern Class_Descriptor cd__ZN4bbbb5yy302E;
static Base_Class bases__ZN4bbbb6zz4302E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy302E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4302E = {  "_ZN4bbbb6zz4302E", // class name
  bases__ZN4bbbb6zz4302E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy402  : ::bbbb::xx02 {
  double fc;
};
//SIG(-1 _ZN4bbbb5yy402E) C1{ BC2{ BC3{ Fs}} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy402E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy402E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb5yy402E, buf);
    ::bbbb::yy402 &lv = *(new (buf) ::bbbb::yy402());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb5yy402E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb5yy402E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*), 0, "_ZN4bbbb5yy402E");
    check_base_class_offset(lv, (::bbbb::xx02*), 0, "_ZN4bbbb5yy402E");
    check_field_offset(lv, fc, ABISELECT(8,4), "_ZN4bbbb5yy402E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy402E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy402E(Test__ZN4bbbb5yy402E, "_ZN4bbbb5yy402E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
static Base_Class bases__ZN4bbbb5yy402E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy402E = {  "_ZN4bbbb5yy402E", // class name
  bases__ZN4bbbb5yy402E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0402  : ::bbbb::yy402 {
};
//SIG(1 _ZN4bbbb6zz0402E) C1{ BC2{ BC3{ BC4{ Fs}} FL}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0402E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0402E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz0402E, buf);
    ::bbbb::zz0402 &lv = *(new (buf) ::bbbb::zz0402());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz0402E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz0402E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*)(::bbbb::yy402*), 0, "_ZN4bbbb6zz0402E");
    check_base_class_offset(lv, (::bbbb::xx02*)(::bbbb::yy402*), 0, "_ZN4bbbb6zz0402E");
    check_base_class_offset(lv, (::bbbb::yy402*), 0, "_ZN4bbbb6zz0402E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0402E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0402E(Test__ZN4bbbb6zz0402E, "_ZN4bbbb6zz0402E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
extern Class_Descriptor cd__ZN4bbbb5yy402E;
static Base_Class bases__ZN4bbbb6zz0402E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy402E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0402E = {  "_ZN4bbbb6zz0402E", // class name
  bases__ZN4bbbb6zz0402E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1402  : ::bbbb::yy402 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1402E) C1{ BC2{ BC3{ BC4{ Fs}} FL} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1402E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1402E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz1402E, buf);
    ::bbbb::zz1402 &lv = *(new (buf) ::bbbb::zz1402());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz1402E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz1402E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*)(::bbbb::yy402*), 0, "_ZN4bbbb6zz1402E");
    check_base_class_offset(lv, (::bbbb::xx02*)(::bbbb::yy402*), 0, "_ZN4bbbb6zz1402E");
    check_base_class_offset(lv, (::bbbb::yy402*), 0, "_ZN4bbbb6zz1402E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz1402E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1402E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1402E(Test__ZN4bbbb6zz1402E, "_ZN4bbbb6zz1402E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
extern Class_Descriptor cd__ZN4bbbb5yy402E;
static Base_Class bases__ZN4bbbb6zz1402E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy402E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1402E = {  "_ZN4bbbb6zz1402E", // class name
  bases__ZN4bbbb6zz1402E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2402  : ::bbbb::yy402 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2402E) C1{ BC2{ BC3{ BC4{ Fs}} FL} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2402E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2402E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz2402E, buf);
    ::bbbb::zz2402 &lv = *(new (buf) ::bbbb::zz2402());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz2402E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz2402E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*)(::bbbb::yy402*), 0, "_ZN4bbbb6zz2402E");
    check_base_class_offset(lv, (::bbbb::xx02*)(::bbbb::yy402*), 0, "_ZN4bbbb6zz2402E");
    check_base_class_offset(lv, (::bbbb::yy402*), 0, "_ZN4bbbb6zz2402E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz2402E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2402E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2402E(Test__ZN4bbbb6zz2402E, "_ZN4bbbb6zz2402E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
extern Class_Descriptor cd__ZN4bbbb5yy402E;
static Base_Class bases__ZN4bbbb6zz2402E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy402E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2402E = {  "_ZN4bbbb6zz2402E", // class name
  bases__ZN4bbbb6zz2402E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3402  : ::bbbb::yy402 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3402E) C1{ BC2{ BC3{ BC4{ Fs}} FL} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3402E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3402E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz3402E, buf);
    ::bbbb::zz3402 &lv = *(new (buf) ::bbbb::zz3402());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz3402E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz3402E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*)(::bbbb::yy402*), 0, "_ZN4bbbb6zz3402E");
    check_base_class_offset(lv, (::bbbb::xx02*)(::bbbb::yy402*), 0, "_ZN4bbbb6zz3402E");
    check_base_class_offset(lv, (::bbbb::yy402*), 0, "_ZN4bbbb6zz3402E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz3402E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3402E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3402E(Test__ZN4bbbb6zz3402E, "_ZN4bbbb6zz3402E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
extern Class_Descriptor cd__ZN4bbbb5yy402E;
static Base_Class bases__ZN4bbbb6zz3402E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy402E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3402E = {  "_ZN4bbbb6zz3402E", // class name
  bases__ZN4bbbb6zz3402E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4402  : ::bbbb::yy402 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4402E) C1{ BC2{ BC3{ BC4{ Fs}} FL} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4402E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4402E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz4402E, buf);
    ::bbbb::zz4402 &lv = *(new (buf) ::bbbb::zz4402());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz4402E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4402E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx02*)(::bbbb::yy402*), 0, "_ZN4bbbb6zz4402E");
    check_base_class_offset(lv, (::bbbb::xx02*)(::bbbb::yy402*), 0, "_ZN4bbbb6zz4402E");
    check_base_class_offset(lv, (::bbbb::yy402*), 0, "_ZN4bbbb6zz4402E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz4402E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4402E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4402E(Test__ZN4bbbb6zz4402E, "_ZN4bbbb6zz4402E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx02E;
extern Class_Descriptor cd__ZN4bbbb5yy402E;
static Base_Class bases__ZN4bbbb6zz4402E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx02E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy402E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4402E = {  "_ZN4bbbb6zz4402E", // class name
  bases__ZN4bbbb6zz4402E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  xx12  : ::bbbb::ww2 {
  char fb;
};
//SIG(-1 _ZN4bbbb4xx12E) C1{ BC2{ Fs} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb4xx12E()
{
  extern Class_Descriptor cd__ZN4bbbb4xx12E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb4xx12E, buf);
    ::bbbb::xx12 &lv = *(new (buf) ::bbbb::xx12());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb4xx12E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb4xx12E)");
    check_base_class_offset(lv, (::bbbb::ww2*), 0, "_ZN4bbbb4xx12E");
    check_field_offset(lv, fb, 2, "_ZN4bbbb4xx12E.fb");
    test_class_info(&lv, &cd__ZN4bbbb4xx12E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb4xx12E(Test__ZN4bbbb4xx12E, "_ZN4bbbb4xx12E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
static Base_Class bases__ZN4bbbb4xx12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb4xx12E = {  "_ZN4bbbb4xx12E", // class name
  bases__ZN4bbbb4xx12E, 1,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy012  : ::bbbb::xx12 {
};
//SIG(-1 _ZN4bbbb5yy012E) C1{ BC2{ BC3{ Fs} Fc}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy012E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy012E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb5yy012E, buf);
    ::bbbb::yy012 &lv = *(new (buf) ::bbbb::yy012());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb5yy012E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb5yy012E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*), 0, "_ZN4bbbb5yy012E");
    check_base_class_offset(lv, (::bbbb::xx12*), 0, "_ZN4bbbb5yy012E");
    test_class_info(&lv, &cd__ZN4bbbb5yy012E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy012E(Test__ZN4bbbb5yy012E, "_ZN4bbbb5yy012E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
static Base_Class bases__ZN4bbbb5yy012E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy012E = {  "_ZN4bbbb5yy012E", // class name
  bases__ZN4bbbb5yy012E, 2,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0012  : ::bbbb::yy012 {
};
//SIG(1 _ZN4bbbb6zz0012E) C1{ BC2{ BC3{ BC4{ Fs} Fc}}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0012E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0012E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb6zz0012E, buf);
    ::bbbb::zz0012 &lv = *(new (buf) ::bbbb::zz0012());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz0012E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz0012E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*)(::bbbb::yy012*), 0, "_ZN4bbbb6zz0012E");
    check_base_class_offset(lv, (::bbbb::xx12*)(::bbbb::yy012*), 0, "_ZN4bbbb6zz0012E");
    check_base_class_offset(lv, (::bbbb::yy012*), 0, "_ZN4bbbb6zz0012E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0012E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0012E(Test__ZN4bbbb6zz0012E, "_ZN4bbbb6zz0012E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
extern Class_Descriptor cd__ZN4bbbb5yy012E;
static Base_Class bases__ZN4bbbb6zz0012E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy012E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0012E = {  "_ZN4bbbb6zz0012E", // class name
  bases__ZN4bbbb6zz0012E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1012  : ::bbbb::yy012 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1012E) C1{ BC2{ BC3{ BC4{ Fs} Fc}} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1012E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1012E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb6zz1012E, buf);
    ::bbbb::zz1012 &lv = *(new (buf) ::bbbb::zz1012());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz1012E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz1012E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*)(::bbbb::yy012*), 0, "_ZN4bbbb6zz1012E");
    check_base_class_offset(lv, (::bbbb::xx12*)(::bbbb::yy012*), 0, "_ZN4bbbb6zz1012E");
    check_base_class_offset(lv, (::bbbb::yy012*), 0, "_ZN4bbbb6zz1012E");
    check_field_offset(lv, fd, 3, "_ZN4bbbb6zz1012E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1012E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1012E(Test__ZN4bbbb6zz1012E, "_ZN4bbbb6zz1012E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
extern Class_Descriptor cd__ZN4bbbb5yy012E;
static Base_Class bases__ZN4bbbb6zz1012E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy012E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1012E = {  "_ZN4bbbb6zz1012E", // class name
  bases__ZN4bbbb6zz1012E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2012  : ::bbbb::yy012 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2012E) C1{ BC2{ BC3{ BC4{ Fs} Fc}} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2012E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2012E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb6zz2012E, buf);
    ::bbbb::zz2012 &lv = *(new (buf) ::bbbb::zz2012());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb6zz2012E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz2012E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*)(::bbbb::yy012*), 0, "_ZN4bbbb6zz2012E");
    check_base_class_offset(lv, (::bbbb::xx12*)(::bbbb::yy012*), 0, "_ZN4bbbb6zz2012E");
    check_base_class_offset(lv, (::bbbb::yy012*), 0, "_ZN4bbbb6zz2012E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz2012E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2012E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2012E(Test__ZN4bbbb6zz2012E, "_ZN4bbbb6zz2012E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
extern Class_Descriptor cd__ZN4bbbb5yy012E;
static Base_Class bases__ZN4bbbb6zz2012E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy012E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2012E = {  "_ZN4bbbb6zz2012E", // class name
  bases__ZN4bbbb6zz2012E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3012  : ::bbbb::yy012 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3012E) C1{ BC2{ BC3{ BC4{ Fs} Fc}} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3012E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3012E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz3012E, buf);
    ::bbbb::zz3012 &lv = *(new (buf) ::bbbb::zz3012());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz3012E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3012E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*)(::bbbb::yy012*), 0, "_ZN4bbbb6zz3012E");
    check_base_class_offset(lv, (::bbbb::xx12*)(::bbbb::yy012*), 0, "_ZN4bbbb6zz3012E");
    check_base_class_offset(lv, (::bbbb::yy012*), 0, "_ZN4bbbb6zz3012E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz3012E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3012E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3012E(Test__ZN4bbbb6zz3012E, "_ZN4bbbb6zz3012E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
extern Class_Descriptor cd__ZN4bbbb5yy012E;
static Base_Class bases__ZN4bbbb6zz3012E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy012E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3012E = {  "_ZN4bbbb6zz3012E", // class name
  bases__ZN4bbbb6zz3012E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4012  : ::bbbb::yy012 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4012E) C1{ BC2{ BC3{ BC4{ Fs} Fc}} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4012E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4012E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz4012E, buf);
    ::bbbb::zz4012 &lv = *(new (buf) ::bbbb::zz4012());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz4012E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4012E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*)(::bbbb::yy012*), 0, "_ZN4bbbb6zz4012E");
    check_base_class_offset(lv, (::bbbb::xx12*)(::bbbb::yy012*), 0, "_ZN4bbbb6zz4012E");
    check_base_class_offset(lv, (::bbbb::yy012*), 0, "_ZN4bbbb6zz4012E");
    check_field_offset(lv, fd, ABISELECT(8,4), "_ZN4bbbb6zz4012E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4012E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4012E(Test__ZN4bbbb6zz4012E, "_ZN4bbbb6zz4012E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
extern Class_Descriptor cd__ZN4bbbb5yy012E;
static Base_Class bases__ZN4bbbb6zz4012E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy012E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4012E = {  "_ZN4bbbb6zz4012E", // class name
  bases__ZN4bbbb6zz4012E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy112  : ::bbbb::xx12 {
  char fc;
};
//SIG(-1 _ZN4bbbb5yy112E) C1{ BC2{ BC3{ Fs} Fc} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy112E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy112E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb5yy112E, buf);
    ::bbbb::yy112 &lv = *(new (buf) ::bbbb::yy112());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb5yy112E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb5yy112E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*), 0, "_ZN4bbbb5yy112E");
    check_base_class_offset(lv, (::bbbb::xx12*), 0, "_ZN4bbbb5yy112E");
    check_field_offset(lv, fc, 3, "_ZN4bbbb5yy112E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy112E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy112E(Test__ZN4bbbb5yy112E, "_ZN4bbbb5yy112E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
static Base_Class bases__ZN4bbbb5yy112E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy112E = {  "_ZN4bbbb5yy112E", // class name
  bases__ZN4bbbb5yy112E, 2,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0112  : ::bbbb::yy112 {
};
//SIG(1 _ZN4bbbb6zz0112E) C1{ BC2{ BC3{ BC4{ Fs} Fc} Fc}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0112E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0112E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb6zz0112E, buf);
    ::bbbb::zz0112 &lv = *(new (buf) ::bbbb::zz0112());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz0112E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz0112E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*)(::bbbb::yy112*), 0, "_ZN4bbbb6zz0112E");
    check_base_class_offset(lv, (::bbbb::xx12*)(::bbbb::yy112*), 0, "_ZN4bbbb6zz0112E");
    check_base_class_offset(lv, (::bbbb::yy112*), 0, "_ZN4bbbb6zz0112E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0112E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0112E(Test__ZN4bbbb6zz0112E, "_ZN4bbbb6zz0112E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
extern Class_Descriptor cd__ZN4bbbb5yy112E;
static Base_Class bases__ZN4bbbb6zz0112E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0112E = {  "_ZN4bbbb6zz0112E", // class name
  bases__ZN4bbbb6zz0112E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1112  : ::bbbb::yy112 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1112E) C1{ BC2{ BC3{ BC4{ Fs} Fc} Fc} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1112E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1112E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb6zz1112E, buf);
    ::bbbb::zz1112 &lv = *(new (buf) ::bbbb::zz1112());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb6zz1112E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz1112E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*)(::bbbb::yy112*), 0, "_ZN4bbbb6zz1112E");
    check_base_class_offset(lv, (::bbbb::xx12*)(::bbbb::yy112*), 0, "_ZN4bbbb6zz1112E");
    check_base_class_offset(lv, (::bbbb::yy112*), 0, "_ZN4bbbb6zz1112E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz1112E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1112E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1112E(Test__ZN4bbbb6zz1112E, "_ZN4bbbb6zz1112E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
extern Class_Descriptor cd__ZN4bbbb5yy112E;
static Base_Class bases__ZN4bbbb6zz1112E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1112E = {  "_ZN4bbbb6zz1112E", // class name
  bases__ZN4bbbb6zz1112E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2112  : ::bbbb::yy112 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2112E) C1{ BC2{ BC3{ BC4{ Fs} Fc} Fc} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2112E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2112E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb6zz2112E, buf);
    ::bbbb::zz2112 &lv = *(new (buf) ::bbbb::zz2112());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb6zz2112E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz2112E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*)(::bbbb::yy112*), 0, "_ZN4bbbb6zz2112E");
    check_base_class_offset(lv, (::bbbb::xx12*)(::bbbb::yy112*), 0, "_ZN4bbbb6zz2112E");
    check_base_class_offset(lv, (::bbbb::yy112*), 0, "_ZN4bbbb6zz2112E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz2112E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2112E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2112E(Test__ZN4bbbb6zz2112E, "_ZN4bbbb6zz2112E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
extern Class_Descriptor cd__ZN4bbbb5yy112E;
static Base_Class bases__ZN4bbbb6zz2112E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2112E = {  "_ZN4bbbb6zz2112E", // class name
  bases__ZN4bbbb6zz2112E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3112  : ::bbbb::yy112 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3112E) C1{ BC2{ BC3{ BC4{ Fs} Fc} Fc} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3112E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3112E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz3112E, buf);
    ::bbbb::zz3112 &lv = *(new (buf) ::bbbb::zz3112());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz3112E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3112E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*)(::bbbb::yy112*), 0, "_ZN4bbbb6zz3112E");
    check_base_class_offset(lv, (::bbbb::xx12*)(::bbbb::yy112*), 0, "_ZN4bbbb6zz3112E");
    check_base_class_offset(lv, (::bbbb::yy112*), 0, "_ZN4bbbb6zz3112E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz3112E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3112E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3112E(Test__ZN4bbbb6zz3112E, "_ZN4bbbb6zz3112E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
extern Class_Descriptor cd__ZN4bbbb5yy112E;
static Base_Class bases__ZN4bbbb6zz3112E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3112E = {  "_ZN4bbbb6zz3112E", // class name
  bases__ZN4bbbb6zz3112E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4112  : ::bbbb::yy112 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4112E) C1{ BC2{ BC3{ BC4{ Fs} Fc} Fc} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4112E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4112E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz4112E, buf);
    ::bbbb::zz4112 &lv = *(new (buf) ::bbbb::zz4112());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz4112E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4112E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*)(::bbbb::yy112*), 0, "_ZN4bbbb6zz4112E");
    check_base_class_offset(lv, (::bbbb::xx12*)(::bbbb::yy112*), 0, "_ZN4bbbb6zz4112E");
    check_base_class_offset(lv, (::bbbb::yy112*), 0, "_ZN4bbbb6zz4112E");
    check_field_offset(lv, fd, ABISELECT(8,4), "_ZN4bbbb6zz4112E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4112E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4112E(Test__ZN4bbbb6zz4112E, "_ZN4bbbb6zz4112E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
extern Class_Descriptor cd__ZN4bbbb5yy112E;
static Base_Class bases__ZN4bbbb6zz4112E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy112E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4112E = {  "_ZN4bbbb6zz4112E", // class name
  bases__ZN4bbbb6zz4112E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy212  : ::bbbb::xx12 {
  short fc;
};
//SIG(-1 _ZN4bbbb5yy212E) C1{ BC2{ BC3{ Fs} Fc} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy212E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy212E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb5yy212E, buf);
    ::bbbb::yy212 &lv = *(new (buf) ::bbbb::yy212());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb5yy212E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb5yy212E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*), 0, "_ZN4bbbb5yy212E");
    check_base_class_offset(lv, (::bbbb::xx12*), 0, "_ZN4bbbb5yy212E");
    check_field_offset(lv, fc, 4, "_ZN4bbbb5yy212E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy212E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy212E(Test__ZN4bbbb5yy212E, "_ZN4bbbb5yy212E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
static Base_Class bases__ZN4bbbb5yy212E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy212E = {  "_ZN4bbbb5yy212E", // class name
  bases__ZN4bbbb5yy212E, 2,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0212  : ::bbbb::yy212 {
};
//SIG(1 _ZN4bbbb6zz0212E) C1{ BC2{ BC3{ BC4{ Fs} Fc} Fs}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0212E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0212E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb6zz0212E, buf);
    ::bbbb::zz0212 &lv = *(new (buf) ::bbbb::zz0212());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb6zz0212E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz0212E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*)(::bbbb::yy212*), 0, "_ZN4bbbb6zz0212E");
    check_base_class_offset(lv, (::bbbb::xx12*)(::bbbb::yy212*), 0, "_ZN4bbbb6zz0212E");
    check_base_class_offset(lv, (::bbbb::yy212*), 0, "_ZN4bbbb6zz0212E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0212E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0212E(Test__ZN4bbbb6zz0212E, "_ZN4bbbb6zz0212E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
extern Class_Descriptor cd__ZN4bbbb5yy212E;
static Base_Class bases__ZN4bbbb6zz0212E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy212E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0212E = {  "_ZN4bbbb6zz0212E", // class name
  bases__ZN4bbbb6zz0212E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1212  : ::bbbb::yy212 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1212E) C1{ BC2{ BC3{ BC4{ Fs} Fc} Fs} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1212E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1212E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4bbbb6zz1212E, buf);
    ::bbbb::zz1212 &lv = *(new (buf) ::bbbb::zz1212());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz1212E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz1212E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*)(::bbbb::yy212*), 0, "_ZN4bbbb6zz1212E");
    check_base_class_offset(lv, (::bbbb::xx12*)(::bbbb::yy212*), 0, "_ZN4bbbb6zz1212E");
    check_base_class_offset(lv, (::bbbb::yy212*), 0, "_ZN4bbbb6zz1212E");
    check_field_offset(lv, fd, 6, "_ZN4bbbb6zz1212E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1212E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1212E(Test__ZN4bbbb6zz1212E, "_ZN4bbbb6zz1212E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
extern Class_Descriptor cd__ZN4bbbb5yy212E;
static Base_Class bases__ZN4bbbb6zz1212E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy212E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1212E = {  "_ZN4bbbb6zz1212E", // class name
  bases__ZN4bbbb6zz1212E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2212  : ::bbbb::yy212 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2212E) C1{ BC2{ BC3{ BC4{ Fs} Fc} Fs} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2212E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2212E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4bbbb6zz2212E, buf);
    ::bbbb::zz2212 &lv = *(new (buf) ::bbbb::zz2212());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz2212E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz2212E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*)(::bbbb::yy212*), 0, "_ZN4bbbb6zz2212E");
    check_base_class_offset(lv, (::bbbb::xx12*)(::bbbb::yy212*), 0, "_ZN4bbbb6zz2212E");
    check_base_class_offset(lv, (::bbbb::yy212*), 0, "_ZN4bbbb6zz2212E");
    check_field_offset(lv, fd, 6, "_ZN4bbbb6zz2212E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2212E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2212E(Test__ZN4bbbb6zz2212E, "_ZN4bbbb6zz2212E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
extern Class_Descriptor cd__ZN4bbbb5yy212E;
static Base_Class bases__ZN4bbbb6zz2212E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy212E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2212E = {  "_ZN4bbbb6zz2212E", // class name
  bases__ZN4bbbb6zz2212E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3212  : ::bbbb::yy212 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3212E) C1{ BC2{ BC3{ BC4{ Fs} Fc} Fs} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3212E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3212E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz3212E, buf);
    ::bbbb::zz3212 &lv = *(new (buf) ::bbbb::zz3212());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz3212E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3212E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*)(::bbbb::yy212*), 0, "_ZN4bbbb6zz3212E");
    check_base_class_offset(lv, (::bbbb::xx12*)(::bbbb::yy212*), 0, "_ZN4bbbb6zz3212E");
    check_base_class_offset(lv, (::bbbb::yy212*), 0, "_ZN4bbbb6zz3212E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz3212E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3212E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3212E(Test__ZN4bbbb6zz3212E, "_ZN4bbbb6zz3212E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
extern Class_Descriptor cd__ZN4bbbb5yy212E;
static Base_Class bases__ZN4bbbb6zz3212E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy212E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3212E = {  "_ZN4bbbb6zz3212E", // class name
  bases__ZN4bbbb6zz3212E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4212  : ::bbbb::yy212 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4212E) C1{ BC2{ BC3{ BC4{ Fs} Fc} Fs} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4212E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4212E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,5)];
    init_test(&cd__ZN4bbbb6zz4212E, buf);
    ::bbbb::zz4212 &lv = *(new (buf) ::bbbb::zz4212());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz4212E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4212E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*)(::bbbb::yy212*), 0, "_ZN4bbbb6zz4212E");
    check_base_class_offset(lv, (::bbbb::xx12*)(::bbbb::yy212*), 0, "_ZN4bbbb6zz4212E");
    check_base_class_offset(lv, (::bbbb::yy212*), 0, "_ZN4bbbb6zz4212E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz4212E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4212E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4212E(Test__ZN4bbbb6zz4212E, "_ZN4bbbb6zz4212E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
extern Class_Descriptor cd__ZN4bbbb5yy212E;
static Base_Class bases__ZN4bbbb6zz4212E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy212E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4212E = {  "_ZN4bbbb6zz4212E", // class name
  bases__ZN4bbbb6zz4212E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy312  : ::bbbb::xx12 {
  int fc;
};
//SIG(-1 _ZN4bbbb5yy312E) C1{ BC2{ BC3{ Fs} Fc} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy312E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy312E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb5yy312E, buf);
    ::bbbb::yy312 &lv = *(new (buf) ::bbbb::yy312());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb5yy312E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb5yy312E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*), 0, "_ZN4bbbb5yy312E");
    check_base_class_offset(lv, (::bbbb::xx12*), 0, "_ZN4bbbb5yy312E");
    check_field_offset(lv, fc, 4, "_ZN4bbbb5yy312E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy312E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy312E(Test__ZN4bbbb5yy312E, "_ZN4bbbb5yy312E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
static Base_Class bases__ZN4bbbb5yy312E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy312E = {  "_ZN4bbbb5yy312E", // class name
  bases__ZN4bbbb5yy312E, 2,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0312  : ::bbbb::yy312 {
};
//SIG(1 _ZN4bbbb6zz0312E) C1{ BC2{ BC3{ BC4{ Fs} Fc} Fi}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0312E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0312E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz0312E, buf);
    ::bbbb::zz0312 &lv = *(new (buf) ::bbbb::zz0312());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz0312E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz0312E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*)(::bbbb::yy312*), 0, "_ZN4bbbb6zz0312E");
    check_base_class_offset(lv, (::bbbb::xx12*)(::bbbb::yy312*), 0, "_ZN4bbbb6zz0312E");
    check_base_class_offset(lv, (::bbbb::yy312*), 0, "_ZN4bbbb6zz0312E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0312E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0312E(Test__ZN4bbbb6zz0312E, "_ZN4bbbb6zz0312E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
extern Class_Descriptor cd__ZN4bbbb5yy312E;
static Base_Class bases__ZN4bbbb6zz0312E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy312E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0312E = {  "_ZN4bbbb6zz0312E", // class name
  bases__ZN4bbbb6zz0312E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1312  : ::bbbb::yy312 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1312E) C1{ BC2{ BC3{ BC4{ Fs} Fc} Fi} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1312E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1312E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz1312E, buf);
    ::bbbb::zz1312 &lv = *(new (buf) ::bbbb::zz1312());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz1312E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz1312E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*)(::bbbb::yy312*), 0, "_ZN4bbbb6zz1312E");
    check_base_class_offset(lv, (::bbbb::xx12*)(::bbbb::yy312*), 0, "_ZN4bbbb6zz1312E");
    check_base_class_offset(lv, (::bbbb::yy312*), 0, "_ZN4bbbb6zz1312E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz1312E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1312E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1312E(Test__ZN4bbbb6zz1312E, "_ZN4bbbb6zz1312E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
extern Class_Descriptor cd__ZN4bbbb5yy312E;
static Base_Class bases__ZN4bbbb6zz1312E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy312E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1312E = {  "_ZN4bbbb6zz1312E", // class name
  bases__ZN4bbbb6zz1312E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2312  : ::bbbb::yy312 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2312E) C1{ BC2{ BC3{ BC4{ Fs} Fc} Fi} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2312E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2312E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz2312E, buf);
    ::bbbb::zz2312 &lv = *(new (buf) ::bbbb::zz2312());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz2312E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz2312E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*)(::bbbb::yy312*), 0, "_ZN4bbbb6zz2312E");
    check_base_class_offset(lv, (::bbbb::xx12*)(::bbbb::yy312*), 0, "_ZN4bbbb6zz2312E");
    check_base_class_offset(lv, (::bbbb::yy312*), 0, "_ZN4bbbb6zz2312E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz2312E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2312E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2312E(Test__ZN4bbbb6zz2312E, "_ZN4bbbb6zz2312E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
extern Class_Descriptor cd__ZN4bbbb5yy312E;
static Base_Class bases__ZN4bbbb6zz2312E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy312E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2312E = {  "_ZN4bbbb6zz2312E", // class name
  bases__ZN4bbbb6zz2312E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3312  : ::bbbb::yy312 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3312E) C1{ BC2{ BC3{ BC4{ Fs} Fc} Fi} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3312E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3312E;
  void *lvp;
  {
    int buf[4];
    init_test(&cd__ZN4bbbb6zz3312E, buf);
    ::bbbb::zz3312 &lv = *(new (buf) ::bbbb::zz3312());
    lvp = (void*)&lv;
    check2(sizeof(lv), 12, "sizeof(_ZN4bbbb6zz3312E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3312E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*)(::bbbb::yy312*), 0, "_ZN4bbbb6zz3312E");
    check_base_class_offset(lv, (::bbbb::xx12*)(::bbbb::yy312*), 0, "_ZN4bbbb6zz3312E");
    check_base_class_offset(lv, (::bbbb::yy312*), 0, "_ZN4bbbb6zz3312E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz3312E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3312E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3312E(Test__ZN4bbbb6zz3312E, "_ZN4bbbb6zz3312E", 12);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
extern Class_Descriptor cd__ZN4bbbb5yy312E;
static Base_Class bases__ZN4bbbb6zz3312E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy312E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3312E = {  "_ZN4bbbb6zz3312E", // class name
  bases__ZN4bbbb6zz3312E, 3,
  0, // no vftv
  0, //no vtt
  12, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4312  : ::bbbb::yy312 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4312E) C1{ BC2{ BC3{ BC4{ Fs} Fc} Fi} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4312E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4312E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,5)];
    init_test(&cd__ZN4bbbb6zz4312E, buf);
    ::bbbb::zz4312 &lv = *(new (buf) ::bbbb::zz4312());
    lvp = (void*)&lv;
    check2(sizeof(lv), 16, "sizeof(_ZN4bbbb6zz4312E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4312E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*)(::bbbb::yy312*), 0, "_ZN4bbbb6zz4312E");
    check_base_class_offset(lv, (::bbbb::xx12*)(::bbbb::yy312*), 0, "_ZN4bbbb6zz4312E");
    check_base_class_offset(lv, (::bbbb::yy312*), 0, "_ZN4bbbb6zz4312E");
    check_field_offset(lv, fd, 8, "_ZN4bbbb6zz4312E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4312E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4312E(Test__ZN4bbbb6zz4312E, "_ZN4bbbb6zz4312E", 16);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
extern Class_Descriptor cd__ZN4bbbb5yy312E;
static Base_Class bases__ZN4bbbb6zz4312E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy312E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4312E = {  "_ZN4bbbb6zz4312E", // class name
  bases__ZN4bbbb6zz4312E, 3,
  0, // no vftv
  0, //no vtt
  16, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy412  : ::bbbb::xx12 {
  double fc;
};
//SIG(-1 _ZN4bbbb5yy412E) C1{ BC2{ BC3{ Fs} Fc} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy412E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy412E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb5yy412E, buf);
    ::bbbb::yy412 &lv = *(new (buf) ::bbbb::yy412());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb5yy412E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb5yy412E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*), 0, "_ZN4bbbb5yy412E");
    check_base_class_offset(lv, (::bbbb::xx12*), 0, "_ZN4bbbb5yy412E");
    check_field_offset(lv, fc, ABISELECT(8,4), "_ZN4bbbb5yy412E.fc");
    test_class_info(&lv, &cd__ZN4bbbb5yy412E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy412E(Test__ZN4bbbb5yy412E, "_ZN4bbbb5yy412E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
static Base_Class bases__ZN4bbbb5yy412E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy412E = {  "_ZN4bbbb5yy412E", // class name
  bases__ZN4bbbb5yy412E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0412  : ::bbbb::yy412 {
};
//SIG(1 _ZN4bbbb6zz0412E) C1{ BC2{ BC3{ BC4{ Fs} Fc} FL}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0412E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0412E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4bbbb6zz0412E, buf);
    ::bbbb::zz0412 &lv = *(new (buf) ::bbbb::zz0412());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4bbbb6zz0412E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz0412E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*)(::bbbb::yy412*), 0, "_ZN4bbbb6zz0412E");
    check_base_class_offset(lv, (::bbbb::xx12*)(::bbbb::yy412*), 0, "_ZN4bbbb6zz0412E");
    check_base_class_offset(lv, (::bbbb::yy412*), 0, "_ZN4bbbb6zz0412E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0412E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0412E(Test__ZN4bbbb6zz0412E, "_ZN4bbbb6zz0412E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
extern Class_Descriptor cd__ZN4bbbb5yy412E;
static Base_Class bases__ZN4bbbb6zz0412E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy412E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0412E = {  "_ZN4bbbb6zz0412E", // class name
  bases__ZN4bbbb6zz0412E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1412  : ::bbbb::yy412 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1412E) C1{ BC2{ BC3{ BC4{ Fs} Fc} FL} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1412E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1412E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz1412E, buf);
    ::bbbb::zz1412 &lv = *(new (buf) ::bbbb::zz1412());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz1412E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz1412E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*)(::bbbb::yy412*), 0, "_ZN4bbbb6zz1412E");
    check_base_class_offset(lv, (::bbbb::xx12*)(::bbbb::yy412*), 0, "_ZN4bbbb6zz1412E");
    check_base_class_offset(lv, (::bbbb::yy412*), 0, "_ZN4bbbb6zz1412E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz1412E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1412E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1412E(Test__ZN4bbbb6zz1412E, "_ZN4bbbb6zz1412E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
extern Class_Descriptor cd__ZN4bbbb5yy412E;
static Base_Class bases__ZN4bbbb6zz1412E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy412E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1412E = {  "_ZN4bbbb6zz1412E", // class name
  bases__ZN4bbbb6zz1412E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2412  : ::bbbb::yy412 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2412E) C1{ BC2{ BC3{ BC4{ Fs} Fc} FL} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2412E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2412E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz2412E, buf);
    ::bbbb::zz2412 &lv = *(new (buf) ::bbbb::zz2412());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz2412E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz2412E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*)(::bbbb::yy412*), 0, "_ZN4bbbb6zz2412E");
    check_base_class_offset(lv, (::bbbb::xx12*)(::bbbb::yy412*), 0, "_ZN4bbbb6zz2412E");
    check_base_class_offset(lv, (::bbbb::yy412*), 0, "_ZN4bbbb6zz2412E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz2412E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2412E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2412E(Test__ZN4bbbb6zz2412E, "_ZN4bbbb6zz2412E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
extern Class_Descriptor cd__ZN4bbbb5yy412E;
static Base_Class bases__ZN4bbbb6zz2412E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy412E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2412E = {  "_ZN4bbbb6zz2412E", // class name
  bases__ZN4bbbb6zz2412E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3412  : ::bbbb::yy412 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3412E) C1{ BC2{ BC3{ BC4{ Fs} Fc} FL} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3412E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3412E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4bbbb6zz3412E, buf);
    ::bbbb::zz3412 &lv = *(new (buf) ::bbbb::zz3412());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4bbbb6zz3412E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz3412E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*)(::bbbb::yy412*), 0, "_ZN4bbbb6zz3412E");
    check_base_class_offset(lv, (::bbbb::xx12*)(::bbbb::yy412*), 0, "_ZN4bbbb6zz3412E");
    check_base_class_offset(lv, (::bbbb::yy412*), 0, "_ZN4bbbb6zz3412E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz3412E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3412E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3412E(Test__ZN4bbbb6zz3412E, "_ZN4bbbb6zz3412E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
extern Class_Descriptor cd__ZN4bbbb5yy412E;
static Base_Class bases__ZN4bbbb6zz3412E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy412E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz3412E = {  "_ZN4bbbb6zz3412E", // class name
  bases__ZN4bbbb6zz3412E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz4412  : ::bbbb::yy412 {
  double fd;
};
//SIG(1 _ZN4bbbb6zz4412E) C1{ BC2{ BC3{ BC4{ Fs} Fc} FL} FL}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz4412E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz4412E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4bbbb6zz4412E, buf);
    ::bbbb::zz4412 &lv = *(new (buf) ::bbbb::zz4412());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4bbbb6zz4412E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4bbbb6zz4412E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx12*)(::bbbb::yy412*), 0, "_ZN4bbbb6zz4412E");
    check_base_class_offset(lv, (::bbbb::xx12*)(::bbbb::yy412*), 0, "_ZN4bbbb6zz4412E");
    check_base_class_offset(lv, (::bbbb::yy412*), 0, "_ZN4bbbb6zz4412E");
    check_field_offset(lv, fd, ABISELECT(16,12), "_ZN4bbbb6zz4412E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz4412E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz4412E(Test__ZN4bbbb6zz4412E, "_ZN4bbbb6zz4412E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx12E;
extern Class_Descriptor cd__ZN4bbbb5yy412E;
static Base_Class bases__ZN4bbbb6zz4412E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx12E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy412E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz4412E = {  "_ZN4bbbb6zz4412E", // class name
  bases__ZN4bbbb6zz4412E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  xx22  : ::bbbb::ww2 {
  short fb;
};
//SIG(-1 _ZN4bbbb4xx22E) C1{ BC2{ Fs} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb4xx22E()
{
  extern Class_Descriptor cd__ZN4bbbb4xx22E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb4xx22E, buf);
    ::bbbb::xx22 &lv = *(new (buf) ::bbbb::xx22());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb4xx22E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb4xx22E)");
    check_base_class_offset(lv, (::bbbb::ww2*), 0, "_ZN4bbbb4xx22E");
    check_field_offset(lv, fb, 2, "_ZN4bbbb4xx22E.fb");
    test_class_info(&lv, &cd__ZN4bbbb4xx22E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb4xx22E(Test__ZN4bbbb4xx22E, "_ZN4bbbb4xx22E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
static Base_Class bases__ZN4bbbb4xx22E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb4xx22E = {  "_ZN4bbbb4xx22E", // class name
  bases__ZN4bbbb4xx22E, 1,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  yy022  : ::bbbb::xx22 {
};
//SIG(-1 _ZN4bbbb5yy022E) C1{ BC2{ BC3{ Fs} Fs}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb5yy022E()
{
  extern Class_Descriptor cd__ZN4bbbb5yy022E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb5yy022E, buf);
    ::bbbb::yy022 &lv = *(new (buf) ::bbbb::yy022());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb5yy022E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb5yy022E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx22*), 0, "_ZN4bbbb5yy022E");
    check_base_class_offset(lv, (::bbbb::xx22*), 0, "_ZN4bbbb5yy022E");
    test_class_info(&lv, &cd__ZN4bbbb5yy022E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb5yy022E(Test__ZN4bbbb5yy022E, "_ZN4bbbb5yy022E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx22E;
static Base_Class bases__ZN4bbbb5yy022E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx22E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb5yy022E = {  "_ZN4bbbb5yy022E", // class name
  bases__ZN4bbbb5yy022E, 2,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz0022  : ::bbbb::yy022 {
};
//SIG(1 _ZN4bbbb6zz0022E) C1{ BC2{ BC3{ BC4{ Fs} Fs}}}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz0022E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz0022E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4bbbb6zz0022E, buf);
    ::bbbb::zz0022 &lv = *(new (buf) ::bbbb::zz0022());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4bbbb6zz0022E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz0022E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx22*)(::bbbb::yy022*), 0, "_ZN4bbbb6zz0022E");
    check_base_class_offset(lv, (::bbbb::xx22*)(::bbbb::yy022*), 0, "_ZN4bbbb6zz0022E");
    check_base_class_offset(lv, (::bbbb::yy022*), 0, "_ZN4bbbb6zz0022E");
    test_class_info(&lv, &cd__ZN4bbbb6zz0022E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz0022E(Test__ZN4bbbb6zz0022E, "_ZN4bbbb6zz0022E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx22E;
extern Class_Descriptor cd__ZN4bbbb5yy022E;
static Base_Class bases__ZN4bbbb6zz0022E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx22E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy022E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz0022E = {  "_ZN4bbbb6zz0022E", // class name
  bases__ZN4bbbb6zz0022E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz1022  : ::bbbb::yy022 {
  char fd;
};
//SIG(1 _ZN4bbbb6zz1022E) C1{ BC2{ BC3{ BC4{ Fs} Fs}} Fc}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz1022E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz1022E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb6zz1022E, buf);
    ::bbbb::zz1022 &lv = *(new (buf) ::bbbb::zz1022());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb6zz1022E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz1022E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx22*)(::bbbb::yy022*), 0, "_ZN4bbbb6zz1022E");
    check_base_class_offset(lv, (::bbbb::xx22*)(::bbbb::yy022*), 0, "_ZN4bbbb6zz1022E");
    check_base_class_offset(lv, (::bbbb::yy022*), 0, "_ZN4bbbb6zz1022E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz1022E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz1022E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz1022E(Test__ZN4bbbb6zz1022E, "_ZN4bbbb6zz1022E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx22E;
extern Class_Descriptor cd__ZN4bbbb5yy022E;
static Base_Class bases__ZN4bbbb6zz1022E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx22E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy022E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz1022E = {  "_ZN4bbbb6zz1022E", // class name
  bases__ZN4bbbb6zz1022E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz2022  : ::bbbb::yy022 {
  short fd;
};
//SIG(1 _ZN4bbbb6zz2022E) C1{ BC2{ BC3{ BC4{ Fs} Fs}} Fs}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz2022E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz2022E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4bbbb6zz2022E, buf);
    ::bbbb::zz2022 &lv = *(new (buf) ::bbbb::zz2022());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4bbbb6zz2022E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4bbbb6zz2022E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx22*)(::bbbb::yy022*), 0, "_ZN4bbbb6zz2022E");
    check_base_class_offset(lv, (::bbbb::xx22*)(::bbbb::yy022*), 0, "_ZN4bbbb6zz2022E");
    check_base_class_offset(lv, (::bbbb::yy022*), 0, "_ZN4bbbb6zz2022E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz2022E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz2022E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz2022E(Test__ZN4bbbb6zz2022E, "_ZN4bbbb6zz2022E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4bbbb3ww2E;
extern Class_Descriptor cd__ZN4bbbb4xx22E;
extern Class_Descriptor cd__ZN4bbbb5yy022E;
static Base_Class bases__ZN4bbbb6zz2022E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4bbbb3ww2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb4xx22E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd__ZN4bbbb5yy022E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4bbbb6zz2022E = {  "_ZN4bbbb6zz2022E", // class name
  bases__ZN4bbbb6zz2022E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace bbbb { 
struct  zz3022  : ::bbbb::yy022 {
  int fd;
};
//SIG(1 _ZN4bbbb6zz3022E) C1{ BC2{ BC3{ BC4{ Fs} Fs}} Fi}
}
namespace bbbb { 
}
static void Test__ZN4bbbb6zz3022E()
{
  extern Class_Descriptor cd__ZN4bbbb6zz3022E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4bbbb6zz3022E, buf);
    ::bbbb::zz3022 &lv = *(new (buf) ::bbbb::zz3022());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4bbbb6zz3022E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4bbbb6zz3022E)");
    check_base_class_offset(lv, (::bbbb::ww2*)(::bbbb::xx22*)(::bbbb::yy022*), 0, "_ZN4bbbb6zz3022E");
    check_base_class_offset(lv, (::bbbb::xx22*)(::bbbb::yy022*), 0, "_ZN4bbbb6zz3022E");
    check_base_class_offset(lv, (::bbbb::yy022*), 0, "_ZN4bbbb6zz3022E");
    check_field_offset(lv, fd, 4, "_ZN4bbbb6zz3022E.fd");
    test_class_info(&lv, &cd__ZN4bbbb6zz3022E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4bbbb6zz3022E(Test__ZN4b