// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus
namespace aaaa { 
struct  aa0  {
  double a;
  char b;
};
//SIG(-1 _ZN4aaaa3aa0E) C1{ FL Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa3aa0E()
{
  {
    init_simple_test("_ZN4aaaa3aa0E");
    ::aaaa::aa0 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4aaaa3aa0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa3aa0E)");
    check_field_offset(lv, a, 0, "_ZN4aaaa3aa0E.a");
    check_field_offset(lv, b, 8, "_ZN4aaaa3aa0E.b");
  }
}
static Arrange_To_Call_Me v_ZN4aaaa3aa0E(Test__ZN4aaaa3aa0E, "_ZN4aaaa3aa0E", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd__ZN4aaaa3aa0E = {  "_ZN4aaaa3aa0E", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  aa1  {
  char b;
};
//SIG(-1 _ZN4aaaa3aa1E) C1{ Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa3aa1E()
{
  {
    init_simple_test("_ZN4aaaa3aa1E");
    ::aaaa::aa1 lv;
    check2(sizeof(lv), 1, "sizeof(_ZN4aaaa3aa1E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa3aa1E)");
    check_field_offset(lv, b, 0, "_ZN4aaaa3aa1E.b");
  }
}
static Arrange_To_Call_Me v_ZN4aaaa3aa1E(Test__ZN4aaaa3aa1E, "_ZN4aaaa3aa1E", 1);

#else // __cplusplus

Class_Descriptor cd__ZN4aaaa3aa1E = {  "_ZN4aaaa3aa1E", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  aa2  {
};
//SIG(-1 _ZN4aaaa3aa2E) C1{}
}
namespace aaaa { 
}
static void Test__ZN4aaaa3aa2E()
{
  {
    init_simple_test("_ZN4aaaa3aa2E");
    ::aaaa::aa2 lv;
    check2(sizeof(lv), 1, "sizeof(_ZN4aaaa3aa2E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa3aa2E)");
  }
}
static Arrange_To_Call_Me v_ZN4aaaa3aa2E(Test__ZN4aaaa3aa2E, "_ZN4aaaa3aa2E", 1);

#else // __cplusplus

Class_Descriptor cd__ZN4aaaa3aa2E = {  "_ZN4aaaa3aa2E", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  aa3  {
  short c;
};
//SIG(-1 _ZN4aaaa3aa3E) C1{ Fs}
}
namespace aaaa { 
}
static void Test__ZN4aaaa3aa3E()
{
  {
    init_simple_test("_ZN4aaaa3aa3E");
    ::aaaa::aa3 lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4aaaa3aa3E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa3aa3E)");
    check_field_offset(lv, c, 0, "_ZN4aaaa3aa3E.c");
  }
}
static Arrange_To_Call_Me v_ZN4aaaa3aa3E(Test__ZN4aaaa3aa3E, "_ZN4aaaa3aa3E", 2);

#else // __cplusplus

Class_Descriptor cd__ZN4aaaa3aa3E = {  "_ZN4aaaa3aa3E", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  bb0  {
  double a;
  char b;
};
//SIG(-1 _ZN4aaaa3bb0E) C1{ FL Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa3bb0E()
{
  {
    init_simple_test("_ZN4aaaa3bb0E");
    ::aaaa::bb0 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4aaaa3bb0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa3bb0E)");
    check_field_offset(lv, a, 0, "_ZN4aaaa3bb0E.a");
    check_field_offset(lv, b, 8, "_ZN4aaaa3bb0E.b");
  }
}
static Arrange_To_Call_Me v_ZN4aaaa3bb0E(Test__ZN4aaaa3bb0E, "_ZN4aaaa3bb0E", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd__ZN4aaaa3bb0E = {  "_ZN4aaaa3bb0E", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  bb1  {
  char b;
};
//SIG(-1 _ZN4aaaa3bb1E) C1{ Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa3bb1E()
{
  {
    init_simple_test("_ZN4aaaa3bb1E");
    ::aaaa::bb1 lv;
    check2(sizeof(lv), 1, "sizeof(_ZN4aaaa3bb1E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa3bb1E)");
    check_field_offset(lv, b, 0, "_ZN4aaaa3bb1E.b");
  }
}
static Arrange_To_Call_Me v_ZN4aaaa3bb1E(Test__ZN4aaaa3bb1E, "_ZN4aaaa3bb1E", 1);

#else // __cplusplus

Class_Descriptor cd__ZN4aaaa3bb1E = {  "_ZN4aaaa3bb1E", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  bb2  {
};
//SIG(-1 _ZN4aaaa3bb2E) C1{}
}
namespace aaaa { 
}
static void Test__ZN4aaaa3bb2E()
{
  {
    init_simple_test("_ZN4aaaa3bb2E");
    ::aaaa::bb2 lv;
    check2(sizeof(lv), 1, "sizeof(_ZN4aaaa3bb2E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa3bb2E)");
  }
}
static Arrange_To_Call_Me v_ZN4aaaa3bb2E(Test__ZN4aaaa3bb2E, "_ZN4aaaa3bb2E", 1);

#else // __cplusplus

Class_Descriptor cd__ZN4aaaa3bb2E = {  "_ZN4aaaa3bb2E", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  bb3  {
  short c;
};
//SIG(-1 _ZN4aaaa3bb3E) C1{ Fs}
}
namespace aaaa { 
}
static void Test__ZN4aaaa3bb3E()
{
  {
    init_simple_test("_ZN4aaaa3bb3E");
    ::aaaa::bb3 lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4aaaa3bb3E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa3bb3E)");
    check_field_offset(lv, c, 0, "_ZN4aaaa3bb3E.c");
  }
}
static Arrange_To_Call_Me v_ZN4aaaa3bb3E(Test__ZN4aaaa3bb3E, "_ZN4aaaa3bb3E", 2);

#else // __cplusplus

Class_Descriptor cd__ZN4aaaa3bb3E = {  "_ZN4aaaa3bb3E", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  cc0  {
  double a;
  char b;
};
//SIG(-1 _ZN4aaaa3cc0E) C1{ FL Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa3cc0E()
{
  {
    init_simple_test("_ZN4aaaa3cc0E");
    ::aaaa::cc0 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4aaaa3cc0E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa3cc0E)");
    check_field_offset(lv, a, 0, "_ZN4aaaa3cc0E.a");
    check_field_offset(lv, b, 8, "_ZN4aaaa3cc0E.b");
  }
}
static Arrange_To_Call_Me v_ZN4aaaa3cc0E(Test__ZN4aaaa3cc0E, "_ZN4aaaa3cc0E", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd__ZN4aaaa3cc0E = {  "_ZN4aaaa3cc0E", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  cc1  {
  char b;
};
//SIG(-1 _ZN4aaaa3cc1E) C1{ Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa3cc1E()
{
  {
    init_simple_test("_ZN4aaaa3cc1E");
    ::aaaa::cc1 lv;
    check2(sizeof(lv), 1, "sizeof(_ZN4aaaa3cc1E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa3cc1E)");
    check_field_offset(lv, b, 0, "_ZN4aaaa3cc1E.b");
  }
}
static Arrange_To_Call_Me v_ZN4aaaa3cc1E(Test__ZN4aaaa3cc1E, "_ZN4aaaa3cc1E", 1);

#else // __cplusplus

Class_Descriptor cd__ZN4aaaa3cc1E = {  "_ZN4aaaa3cc1E", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  cc2  {
};
//SIG(-1 _ZN4aaaa3cc2E) C1{}
}
namespace aaaa { 
}
static void Test__ZN4aaaa3cc2E()
{
  {
    init_simple_test("_ZN4aaaa3cc2E");
    ::aaaa::cc2 lv;
    check2(sizeof(lv), 1, "sizeof(_ZN4aaaa3cc2E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa3cc2E)");
  }
}
static Arrange_To_Call_Me v_ZN4aaaa3cc2E(Test__ZN4aaaa3cc2E, "_ZN4aaaa3cc2E", 1);

#else // __cplusplus

Class_Descriptor cd__ZN4aaaa3cc2E = {  "_ZN4aaaa3cc2E", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  cc3  {
  short c;
};
//SIG(-1 _ZN4aaaa3cc3E) C1{ Fs}
}
namespace aaaa { 
}
static void Test__ZN4aaaa3cc3E()
{
  {
    init_simple_test("_ZN4aaaa3cc3E");
    ::aaaa::cc3 lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4aaaa3cc3E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa3cc3E)");
    check_field_offset(lv, c, 0, "_ZN4aaaa3cc3E.c");
  }
}
static Arrange_To_Call_Me v_ZN4aaaa3cc3E(Test__ZN4aaaa3cc3E, "_ZN4aaaa3cc3E", 2);

#else // __cplusplus

Class_Descriptor cd__ZN4aaaa3cc3E = {  "_ZN4aaaa3cc3E", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  da00  : ::aaaa::aa0 {
};
//SIG(1 _ZN4aaaa4da00E) C1{ BC2{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa4da00E()
{
  extern Class_Descriptor cd__ZN4aaaa4da00E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4aaaa4da00E, buf);
    ::aaaa::da00 &lv = *(new (buf) ::aaaa::da00());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4aaaa4da00E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa4da00E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa4da00E");
    test_class_info(&lv, &cd__ZN4aaaa4da00E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa4da00E(Test__ZN4aaaa4da00E, "_ZN4aaaa4da00E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
static Base_Class bases__ZN4aaaa4da00E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa4da00E = {  "_ZN4aaaa4da00E", // class name
  bases__ZN4aaaa4da00E, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  da01  : ::aaaa::aa0 {
  char xc;
};
//SIG(1 _ZN4aaaa4da01E) C1{ BC2{ FL Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa4da01E()
{
  extern Class_Descriptor cd__ZN4aaaa4da01E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa4da01E, buf);
    ::aaaa::da01 &lv = *(new (buf) ::aaaa::da01());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa4da01E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa4da01E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa4da01E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa4da01E.xc");
    test_class_info(&lv, &cd__ZN4aaaa4da01E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa4da01E(Test__ZN4aaaa4da01E, "_ZN4aaaa4da01E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
static Base_Class bases__ZN4aaaa4da01E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa4da01E = {  "_ZN4aaaa4da01E", // class name
  bases__ZN4aaaa4da01E, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  da02  : ::aaaa::aa0 {
  char xc[2];
};
//SIG(1 _ZN4aaaa4da02E) C1{ BC2{ FL Fc} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa4da02E()
{
  extern Class_Descriptor cd__ZN4aaaa4da02E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa4da02E, buf);
    ::aaaa::da02 &lv = *(new (buf) ::aaaa::da02());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa4da02E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa4da02E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa4da02E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa4da02E.xc");
    test_class_info(&lv, &cd__ZN4aaaa4da02E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa4da02E(Test__ZN4aaaa4da02E, "_ZN4aaaa4da02E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
static Base_Class bases__ZN4aaaa4da02E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa4da02E = {  "_ZN4aaaa4da02E", // class name
  bases__ZN4aaaa4da02E, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  da03  : ::aaaa::aa0 {
  char xc[3];
};
//SIG(1 _ZN4aaaa4da03E) C1{ BC2{ FL Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa4da03E()
{
  extern Class_Descriptor cd__ZN4aaaa4da03E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa4da03E, buf);
    ::aaaa::da03 &lv = *(new (buf) ::aaaa::da03());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa4da03E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa4da03E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa4da03E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa4da03E.xc");
    test_class_info(&lv, &cd__ZN4aaaa4da03E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa4da03E(Test__ZN4aaaa4da03E, "_ZN4aaaa4da03E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
static Base_Class bases__ZN4aaaa4da03E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa4da03E = {  "_ZN4aaaa4da03E", // class name
  bases__ZN4aaaa4da03E, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  da04  : ::aaaa::aa0 {
  int fi;
};
//SIG(1 _ZN4aaaa4da04E) C1{ BC2{ FL Fc} Fi}
}
namespace aaaa { 
}
static void Test__ZN4aaaa4da04E()
{
  extern Class_Descriptor cd__ZN4aaaa4da04E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa4da04E, buf);
    ::aaaa::da04 &lv = *(new (buf) ::aaaa::da04());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa4da04E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa4da04E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa4da04E");
    check_field_offset(lv, fi, ABISELECT(16,12), "_ZN4aaaa4da04E.fi");
    test_class_info(&lv, &cd__ZN4aaaa4da04E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa4da04E(Test__ZN4aaaa4da04E, "_ZN4aaaa4da04E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
static Base_Class bases__ZN4aaaa4da04E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa4da04E = {  "_ZN4aaaa4da04E", // class name
  bases__ZN4aaaa4da04E, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  da05  : ::aaaa::aa0 {
  __tsi64 lli;
};
//SIG(1 _ZN4aaaa4da05E) C1{ BC2{ FL Fc} FL}
}
namespace aaaa { 
}
static void Test__ZN4aaaa4da05E()
{
  extern Class_Descriptor cd__ZN4aaaa4da05E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa4da05E, buf);
    ::aaaa::da05 &lv = *(new (buf) ::aaaa::da05());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa4da05E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa4da05E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa4da05E");
    check_field_offset(lv, lli, ABISELECT(16,12), "_ZN4aaaa4da05E.lli");
    test_class_info(&lv, &cd__ZN4aaaa4da05E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa4da05E(Test__ZN4aaaa4da05E, "_ZN4aaaa4da05E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
static Base_Class bases__ZN4aaaa4da05E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa4da05E = {  "_ZN4aaaa4da05E", // class name
  bases__ZN4aaaa4da05E, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db000  : ::aaaa::aa0 , ::aaaa::bb0 {
};
//SIG(1 _ZN4aaaa5db000E) C1{ BC2{ FL Fc} BC3{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db000E()
{
  extern Class_Descriptor cd__ZN4aaaa5db000E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4aaaa5db000E, buf);
    ::aaaa::db000 &lv = *(new (buf) ::aaaa::db000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4aaaa5db000E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db000E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa5db000E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa5db000E");
    test_class_info(&lv, &cd__ZN4aaaa5db000E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db000E(Test__ZN4aaaa5db000E, "_ZN4aaaa5db000E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
static Base_Class bases__ZN4aaaa5db000E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db000E = {  "_ZN4aaaa5db000E", // class name
  bases__ZN4aaaa5db000E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db001  : ::aaaa::aa0 , ::aaaa::bb0 {
};
//SIG(1 _ZN4aaaa5db001E) C1{ BC2{ FL Fc} BC3{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db001E()
{
  extern Class_Descriptor cd__ZN4aaaa5db001E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4aaaa5db001E, buf);
    ::aaaa::db001 &lv = *(new (buf) ::aaaa::db001());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4aaaa5db001E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db001E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa5db001E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa5db001E");
    test_class_info(&lv, &cd__ZN4aaaa5db001E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db001E(Test__ZN4aaaa5db001E, "_ZN4aaaa5db001E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
static Base_Class bases__ZN4aaaa5db001E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db001E = {  "_ZN4aaaa5db001E", // class name
  bases__ZN4aaaa5db001E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db002  : ::aaaa::aa0 , ::aaaa::bb0 {
};
//SIG(1 _ZN4aaaa5db002E) C1{ BC2{ FL Fc} BC3{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db002E()
{
  extern Class_Descriptor cd__ZN4aaaa5db002E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4aaaa5db002E, buf);
    ::aaaa::db002 &lv = *(new (buf) ::aaaa::db002());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4aaaa5db002E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db002E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa5db002E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa5db002E");
    test_class_info(&lv, &cd__ZN4aaaa5db002E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db002E(Test__ZN4aaaa5db002E, "_ZN4aaaa5db002E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
static Base_Class bases__ZN4aaaa5db002E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db002E = {  "_ZN4aaaa5db002E", // class name
  bases__ZN4aaaa5db002E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db003  : ::aaaa::aa0 , ::aaaa::bb0 {
};
//SIG(1 _ZN4aaaa5db003E) C1{ BC2{ FL Fc} BC3{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db003E()
{
  extern Class_Descriptor cd__ZN4aaaa5db003E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4aaaa5db003E, buf);
    ::aaaa::db003 &lv = *(new (buf) ::aaaa::db003());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4aaaa5db003E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db003E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa5db003E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa5db003E");
    test_class_info(&lv, &cd__ZN4aaaa5db003E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db003E(Test__ZN4aaaa5db003E, "_ZN4aaaa5db003E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
static Base_Class bases__ZN4aaaa5db003E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db003E = {  "_ZN4aaaa5db003E", // class name
  bases__ZN4aaaa5db003E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db004  : ::aaaa::aa0 , ::aaaa::bb0 {
};
//SIG(1 _ZN4aaaa5db004E) C1{ BC2{ FL Fc} BC3{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db004E()
{
  extern Class_Descriptor cd__ZN4aaaa5db004E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4aaaa5db004E, buf);
    ::aaaa::db004 &lv = *(new (buf) ::aaaa::db004());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4aaaa5db004E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db004E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa5db004E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa5db004E");
    test_class_info(&lv, &cd__ZN4aaaa5db004E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db004E(Test__ZN4aaaa5db004E, "_ZN4aaaa5db004E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
static Base_Class bases__ZN4aaaa5db004E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db004E = {  "_ZN4aaaa5db004E", // class name
  bases__ZN4aaaa5db004E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db005  : ::aaaa::aa0 , ::aaaa::bb0 {
};
//SIG(1 _ZN4aaaa5db005E) C1{ BC2{ FL Fc} BC3{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db005E()
{
  extern Class_Descriptor cd__ZN4aaaa5db005E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4aaaa5db005E, buf);
    ::aaaa::db005 &lv = *(new (buf) ::aaaa::db005());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4aaaa5db005E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db005E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa5db005E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa5db005E");
    test_class_info(&lv, &cd__ZN4aaaa5db005E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db005E(Test__ZN4aaaa5db005E, "_ZN4aaaa5db005E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
static Base_Class bases__ZN4aaaa5db005E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db005E = {  "_ZN4aaaa5db005E", // class name
  bases__ZN4aaaa5db005E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0000  : ::aaaa::aa0 , ::aaaa::bb0 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc0000E) C1{ BC2{ FL Fc} BC3{ FL Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0000E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0000E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd__ZN4aaaa6dc0000E, buf);
    ::aaaa::dc0000 &lv = *(new (buf) ::aaaa::dc0000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(_ZN4aaaa6dc0000E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0000E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0000E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa6dc0000E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(32,24), "_ZN4aaaa6dc0000E");
    test_class_info(&lv, &cd__ZN4aaaa6dc0000E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0000E(Test__ZN4aaaa6dc0000E, "_ZN4aaaa6dc0000E", ABISELECT(48,36));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc0000E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0000E = {  "_ZN4aaaa6dc0000E", // class name
  bases__ZN4aaaa6dc0000E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(48,36), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0001  : ::aaaa::aa0 , ::aaaa::bb0 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc0001E) C1{ BC2{ FL Fc} BC3{ FL Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0001E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0001E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd__ZN4aaaa6dc0001E, buf);
    ::aaaa::dc0001 &lv = *(new (buf) ::aaaa::dc0001());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(_ZN4aaaa6dc0001E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0001E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0001E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa6dc0001E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(32,24), "_ZN4aaaa6dc0001E");
    test_class_info(&lv, &cd__ZN4aaaa6dc0001E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0001E(Test__ZN4aaaa6dc0001E, "_ZN4aaaa6dc0001E", ABISELECT(48,36));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc0001E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0001E = {  "_ZN4aaaa6dc0001E", // class name
  bases__ZN4aaaa6dc0001E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(48,36), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0002  : ::aaaa::aa0 , ::aaaa::bb0 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc0002E) C1{ BC2{ FL Fc} BC3{ FL Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0002E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0002E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd__ZN4aaaa6dc0002E, buf);
    ::aaaa::dc0002 &lv = *(new (buf) ::aaaa::dc0002());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(_ZN4aaaa6dc0002E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0002E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0002E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa6dc0002E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(32,24), "_ZN4aaaa6dc0002E");
    test_class_info(&lv, &cd__ZN4aaaa6dc0002E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0002E(Test__ZN4aaaa6dc0002E, "_ZN4aaaa6dc0002E", ABISELECT(48,36));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc0002E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0002E = {  "_ZN4aaaa6dc0002E", // class name
  bases__ZN4aaaa6dc0002E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(48,36), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0003  : ::aaaa::aa0 , ::aaaa::bb0 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc0003E) C1{ BC2{ FL Fc} BC3{ FL Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0003E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0003E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd__ZN4aaaa6dc0003E, buf);
    ::aaaa::dc0003 &lv = *(new (buf) ::aaaa::dc0003());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(_ZN4aaaa6dc0003E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0003E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0003E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa6dc0003E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(32,24), "_ZN4aaaa6dc0003E");
    test_class_info(&lv, &cd__ZN4aaaa6dc0003E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0003E(Test__ZN4aaaa6dc0003E, "_ZN4aaaa6dc0003E", ABISELECT(48,36));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc0003E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0003E = {  "_ZN4aaaa6dc0003E", // class name
  bases__ZN4aaaa6dc0003E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(48,36), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0004  : ::aaaa::aa0 , ::aaaa::bb0 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc0004E) C1{ BC2{ FL Fc} BC3{ FL Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0004E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0004E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd__ZN4aaaa6dc0004E, buf);
    ::aaaa::dc0004 &lv = *(new (buf) ::aaaa::dc0004());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(_ZN4aaaa6dc0004E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0004E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0004E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa6dc0004E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(32,24), "_ZN4aaaa6dc0004E");
    test_class_info(&lv, &cd__ZN4aaaa6dc0004E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0004E(Test__ZN4aaaa6dc0004E, "_ZN4aaaa6dc0004E", ABISELECT(48,36));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc0004E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0004E = {  "_ZN4aaaa6dc0004E", // class name
  bases__ZN4aaaa6dc0004E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(48,36), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0005  : ::aaaa::aa0 , ::aaaa::bb0 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc0005E) C1{ BC2{ FL Fc} BC3{ FL Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0005E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0005E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,10)];
    init_test(&cd__ZN4aaaa6dc0005E, buf);
    ::aaaa::dc0005 &lv = *(new (buf) ::aaaa::dc0005());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,36), "sizeof(_ZN4aaaa6dc0005E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0005E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0005E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa6dc0005E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(32,24), "_ZN4aaaa6dc0005E");
    test_class_info(&lv, &cd__ZN4aaaa6dc0005E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0005E(Test__ZN4aaaa6dc0005E, "_ZN4aaaa6dc0005E", ABISELECT(48,36));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc0005E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0005E = {  "_ZN4aaaa6dc0005E", // class name
  bases__ZN4aaaa6dc0005E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(48,36), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0010  : ::aaaa::aa0 , ::aaaa::bb0 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc0010E) C1{ BC2{ FL Fc} BC3{ FL Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0010E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0010E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc0010E, buf);
    ::aaaa::dc0010 &lv = *(new (buf) ::aaaa::dc0010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc0010E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0010E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0010E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa6dc0010E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(32,24), "_ZN4aaaa6dc0010E");
    check_field_offset(lv, xc, ABISELECT(33,25), "_ZN4aaaa6dc0010E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0010E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0010E(Test__ZN4aaaa6dc0010E, "_ZN4aaaa6dc0010E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc0010E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0010E = {  "_ZN4aaaa6dc0010E", // class name
  bases__ZN4aaaa6dc0010E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0011  : ::aaaa::aa0 , ::aaaa::bb0 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc0011E) C1{ BC2{ FL Fc} BC3{ FL Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0011E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0011E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc0011E, buf);
    ::aaaa::dc0011 &lv = *(new (buf) ::aaaa::dc0011());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc0011E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0011E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0011E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa6dc0011E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(32,24), "_ZN4aaaa6dc0011E");
    check_field_offset(lv, xc, ABISELECT(33,25), "_ZN4aaaa6dc0011E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0011E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0011E(Test__ZN4aaaa6dc0011E, "_ZN4aaaa6dc0011E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc0011E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0011E = {  "_ZN4aaaa6dc0011E", // class name
  bases__ZN4aaaa6dc0011E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0012  : ::aaaa::aa0 , ::aaaa::bb0 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc0012E) C1{ BC2{ FL Fc} BC3{ FL Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0012E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0012E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc0012E, buf);
    ::aaaa::dc0012 &lv = *(new (buf) ::aaaa::dc0012());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc0012E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0012E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0012E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa6dc0012E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(32,24), "_ZN4aaaa6dc0012E");
    check_field_offset(lv, xc, ABISELECT(33,25), "_ZN4aaaa6dc0012E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0012E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0012E(Test__ZN4aaaa6dc0012E, "_ZN4aaaa6dc0012E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc0012E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0012E = {  "_ZN4aaaa6dc0012E", // class name
  bases__ZN4aaaa6dc0012E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0013  : ::aaaa::aa0 , ::aaaa::bb0 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc0013E) C1{ BC2{ FL Fc} BC3{ FL Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0013E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0013E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc0013E, buf);
    ::aaaa::dc0013 &lv = *(new (buf) ::aaaa::dc0013());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc0013E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0013E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0013E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa6dc0013E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(32,24), "_ZN4aaaa6dc0013E");
    check_field_offset(lv, xc, ABISELECT(33,25), "_ZN4aaaa6dc0013E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0013E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0013E(Test__ZN4aaaa6dc0013E, "_ZN4aaaa6dc0013E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc0013E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0013E = {  "_ZN4aaaa6dc0013E", // class name
  bases__ZN4aaaa6dc0013E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0014  : ::aaaa::aa0 , ::aaaa::bb0 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc0014E) C1{ BC2{ FL Fc} BC3{ FL Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0014E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0014E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc0014E, buf);
    ::aaaa::dc0014 &lv = *(new (buf) ::aaaa::dc0014());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc0014E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0014E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0014E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa6dc0014E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(32,24), "_ZN4aaaa6dc0014E");
    check_field_offset(lv, xc, ABISELECT(33,25), "_ZN4aaaa6dc0014E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0014E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0014E(Test__ZN4aaaa6dc0014E, "_ZN4aaaa6dc0014E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc0014E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0014E = {  "_ZN4aaaa6dc0014E", // class name
  bases__ZN4aaaa6dc0014E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0015  : ::aaaa::aa0 , ::aaaa::bb0 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc0015E) C1{ BC2{ FL Fc} BC3{ FL Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0015E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0015E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc0015E, buf);
    ::aaaa::dc0015 &lv = *(new (buf) ::aaaa::dc0015());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc0015E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0015E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0015E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa6dc0015E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(32,24), "_ZN4aaaa6dc0015E");
    check_field_offset(lv, xc, ABISELECT(33,25), "_ZN4aaaa6dc0015E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0015E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0015E(Test__ZN4aaaa6dc0015E, "_ZN4aaaa6dc0015E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc0015E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0015E = {  "_ZN4aaaa6dc0015E", // class name
  bases__ZN4aaaa6dc0015E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0020  : ::aaaa::aa0 , ::aaaa::bb0 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc0020E) C1{ BC2{ FL Fc} BC3{ FL Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0020E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0020E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc0020E, buf);
    ::aaaa::dc0020 &lv = *(new (buf) ::aaaa::dc0020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc0020E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0020E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0020E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa6dc0020E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc0020E");
    check_field_offset(lv, xc, ABISELECT(32,24), "_ZN4aaaa6dc0020E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0020E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0020E(Test__ZN4aaaa6dc0020E, "_ZN4aaaa6dc0020E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc0020E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0020E = {  "_ZN4aaaa6dc0020E", // class name
  bases__ZN4aaaa6dc0020E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0021  : ::aaaa::aa0 , ::aaaa::bb0 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc0021E) C1{ BC2{ FL Fc} BC3{ FL Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0021E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0021E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc0021E, buf);
    ::aaaa::dc0021 &lv = *(new (buf) ::aaaa::dc0021());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc0021E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0021E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0021E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa6dc0021E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc0021E");
    check_field_offset(lv, xc, ABISELECT(32,24), "_ZN4aaaa6dc0021E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0021E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0021E(Test__ZN4aaaa6dc0021E, "_ZN4aaaa6dc0021E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc0021E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0021E = {  "_ZN4aaaa6dc0021E", // class name
  bases__ZN4aaaa6dc0021E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0022  : ::aaaa::aa0 , ::aaaa::bb0 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc0022E) C1{ BC2{ FL Fc} BC3{ FL Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0022E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0022E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc0022E, buf);
    ::aaaa::dc0022 &lv = *(new (buf) ::aaaa::dc0022());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc0022E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0022E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0022E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa6dc0022E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc0022E");
    check_field_offset(lv, xc, ABISELECT(32,24), "_ZN4aaaa6dc0022E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0022E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0022E(Test__ZN4aaaa6dc0022E, "_ZN4aaaa6dc0022E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc0022E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0022E = {  "_ZN4aaaa6dc0022E", // class name
  bases__ZN4aaaa6dc0022E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0023  : ::aaaa::aa0 , ::aaaa::bb0 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc0023E) C1{ BC2{ FL Fc} BC3{ FL Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0023E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0023E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc0023E, buf);
    ::aaaa::dc0023 &lv = *(new (buf) ::aaaa::dc0023());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc0023E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0023E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0023E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa6dc0023E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc0023E");
    check_field_offset(lv, xc, ABISELECT(32,24), "_ZN4aaaa6dc0023E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0023E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0023E(Test__ZN4aaaa6dc0023E, "_ZN4aaaa6dc0023E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc0023E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0023E = {  "_ZN4aaaa6dc0023E", // class name
  bases__ZN4aaaa6dc0023E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0024  : ::aaaa::aa0 , ::aaaa::bb0 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc0024E) C1{ BC2{ FL Fc} BC3{ FL Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0024E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0024E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc0024E, buf);
    ::aaaa::dc0024 &lv = *(new (buf) ::aaaa::dc0024());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc0024E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0024E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0024E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa6dc0024E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc0024E");
    check_field_offset(lv, xc, ABISELECT(32,24), "_ZN4aaaa6dc0024E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0024E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0024E(Test__ZN4aaaa6dc0024E, "_ZN4aaaa6dc0024E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc0024E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0024E = {  "_ZN4aaaa6dc0024E", // class name
  bases__ZN4aaaa6dc0024E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0025  : ::aaaa::aa0 , ::aaaa::bb0 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc0025E) C1{ BC2{ FL Fc} BC3{ FL Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0025E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0025E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc0025E, buf);
    ::aaaa::dc0025 &lv = *(new (buf) ::aaaa::dc0025());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc0025E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0025E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0025E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa6dc0025E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc0025E");
    check_field_offset(lv, xc, ABISELECT(32,24), "_ZN4aaaa6dc0025E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0025E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0025E(Test__ZN4aaaa6dc0025E, "_ZN4aaaa6dc0025E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc0025E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0025E = {  "_ZN4aaaa6dc0025E", // class name
  bases__ZN4aaaa6dc0025E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0030  : ::aaaa::aa0 , ::aaaa::bb0 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc0030E) C1{ BC2{ FL Fc} BC3{ FL Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0030E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0030E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd__ZN4aaaa6dc0030E, buf);
    ::aaaa::dc0030 &lv = *(new (buf) ::aaaa::dc0030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(_ZN4aaaa6dc0030E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0030E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0030E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa6dc0030E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(32,24), "_ZN4aaaa6dc0030E");
    check_field_offset(lv, xc, ABISELECT(34,26), "_ZN4aaaa6dc0030E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0030E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0030E(Test__ZN4aaaa6dc0030E, "_ZN4aaaa6dc0030E", ABISELECT(40,32));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc0030E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0030E = {  "_ZN4aaaa6dc0030E", // class name
  bases__ZN4aaaa6dc0030E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,32), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0031  : ::aaaa::aa0 , ::aaaa::bb0 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc0031E) C1{ BC2{ FL Fc} BC3{ FL Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0031E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0031E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd__ZN4aaaa6dc0031E, buf);
    ::aaaa::dc0031 &lv = *(new (buf) ::aaaa::dc0031());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(_ZN4aaaa6dc0031E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0031E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0031E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa6dc0031E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(32,24), "_ZN4aaaa6dc0031E");
    check_field_offset(lv, xc, ABISELECT(34,26), "_ZN4aaaa6dc0031E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0031E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0031E(Test__ZN4aaaa6dc0031E, "_ZN4aaaa6dc0031E", ABISELECT(40,32));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc0031E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0031E = {  "_ZN4aaaa6dc0031E", // class name
  bases__ZN4aaaa6dc0031E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,32), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0032  : ::aaaa::aa0 , ::aaaa::bb0 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc0032E) C1{ BC2{ FL Fc} BC3{ FL Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0032E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0032E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd__ZN4aaaa6dc0032E, buf);
    ::aaaa::dc0032 &lv = *(new (buf) ::aaaa::dc0032());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(_ZN4aaaa6dc0032E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0032E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0032E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa6dc0032E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(32,24), "_ZN4aaaa6dc0032E");
    check_field_offset(lv, xc, ABISELECT(34,26), "_ZN4aaaa6dc0032E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0032E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0032E(Test__ZN4aaaa6dc0032E, "_ZN4aaaa6dc0032E", ABISELECT(40,32));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc0032E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0032E = {  "_ZN4aaaa6dc0032E", // class name
  bases__ZN4aaaa6dc0032E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,32), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0033  : ::aaaa::aa0 , ::aaaa::bb0 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc0033E) C1{ BC2{ FL Fc} BC3{ FL Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0033E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0033E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd__ZN4aaaa6dc0033E, buf);
    ::aaaa::dc0033 &lv = *(new (buf) ::aaaa::dc0033());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(_ZN4aaaa6dc0033E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0033E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0033E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa6dc0033E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(32,24), "_ZN4aaaa6dc0033E");
    check_field_offset(lv, xc, ABISELECT(34,26), "_ZN4aaaa6dc0033E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0033E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0033E(Test__ZN4aaaa6dc0033E, "_ZN4aaaa6dc0033E", ABISELECT(40,32));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc0033E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0033E = {  "_ZN4aaaa6dc0033E", // class name
  bases__ZN4aaaa6dc0033E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,32), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0034  : ::aaaa::aa0 , ::aaaa::bb0 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc0034E) C1{ BC2{ FL Fc} BC3{ FL Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0034E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0034E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd__ZN4aaaa6dc0034E, buf);
    ::aaaa::dc0034 &lv = *(new (buf) ::aaaa::dc0034());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(_ZN4aaaa6dc0034E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0034E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0034E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa6dc0034E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(32,24), "_ZN4aaaa6dc0034E");
    check_field_offset(lv, xc, ABISELECT(34,26), "_ZN4aaaa6dc0034E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0034E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0034E(Test__ZN4aaaa6dc0034E, "_ZN4aaaa6dc0034E", ABISELECT(40,32));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc0034E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0034E = {  "_ZN4aaaa6dc0034E", // class name
  bases__ZN4aaaa6dc0034E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,32), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0035  : ::aaaa::aa0 , ::aaaa::bb0 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc0035E) C1{ BC2{ FL Fc} BC3{ FL Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0035E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0035E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,9)];
    init_test(&cd__ZN4aaaa6dc0035E, buf);
    ::aaaa::dc0035 &lv = *(new (buf) ::aaaa::dc0035());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,32), "sizeof(_ZN4aaaa6dc0035E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0035E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0035E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(16,12), "_ZN4aaaa6dc0035E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(32,24), "_ZN4aaaa6dc0035E");
    check_field_offset(lv, xc, ABISELECT(34,26), "_ZN4aaaa6dc0035E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0035E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0035E(Test__ZN4aaaa6dc0035E, "_ZN4aaaa6dc0035E", ABISELECT(40,32));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc0035E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(32,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0035E = {  "_ZN4aaaa6dc0035E", // class name
  bases__ZN4aaaa6dc0035E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,32), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db010  : ::aaaa::aa0 , ::aaaa::bb1 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db010E) C1{ BC2{ FL Fc} BC3{ Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db010E()
{
  extern Class_Descriptor cd__ZN4aaaa5db010E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa5db010E, buf);
    ::aaaa::db010 &lv = *(new (buf) ::aaaa::db010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa5db010E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db010E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa5db010E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa5db010E");
    check_field_offset(lv, xc, ABISELECT(17,13), "_ZN4aaaa5db010E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db010E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db010E(Test__ZN4aaaa5db010E, "_ZN4aaaa5db010E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
static Base_Class bases__ZN4aaaa5db010E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db010E = {  "_ZN4aaaa5db010E", // class name
  bases__ZN4aaaa5db010E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db011  : ::aaaa::aa0 , ::aaaa::bb1 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db011E) C1{ BC2{ FL Fc} BC3{ Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db011E()
{
  extern Class_Descriptor cd__ZN4aaaa5db011E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa5db011E, buf);
    ::aaaa::db011 &lv = *(new (buf) ::aaaa::db011());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa5db011E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db011E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa5db011E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa5db011E");
    check_field_offset(lv, xc, ABISELECT(17,13), "_ZN4aaaa5db011E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db011E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db011E(Test__ZN4aaaa5db011E, "_ZN4aaaa5db011E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
static Base_Class bases__ZN4aaaa5db011E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db011E = {  "_ZN4aaaa5db011E", // class name
  bases__ZN4aaaa5db011E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db012  : ::aaaa::aa0 , ::aaaa::bb1 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db012E) C1{ BC2{ FL Fc} BC3{ Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db012E()
{
  extern Class_Descriptor cd__ZN4aaaa5db012E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa5db012E, buf);
    ::aaaa::db012 &lv = *(new (buf) ::aaaa::db012());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa5db012E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db012E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa5db012E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa5db012E");
    check_field_offset(lv, xc, ABISELECT(17,13), "_ZN4aaaa5db012E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db012E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db012E(Test__ZN4aaaa5db012E, "_ZN4aaaa5db012E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
static Base_Class bases__ZN4aaaa5db012E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db012E = {  "_ZN4aaaa5db012E", // class name
  bases__ZN4aaaa5db012E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db013  : ::aaaa::aa0 , ::aaaa::bb1 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db013E) C1{ BC2{ FL Fc} BC3{ Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db013E()
{
  extern Class_Descriptor cd__ZN4aaaa5db013E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa5db013E, buf);
    ::aaaa::db013 &lv = *(new (buf) ::aaaa::db013());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa5db013E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db013E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa5db013E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa5db013E");
    check_field_offset(lv, xc, ABISELECT(17,13), "_ZN4aaaa5db013E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db013E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db013E(Test__ZN4aaaa5db013E, "_ZN4aaaa5db013E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
static Base_Class bases__ZN4aaaa5db013E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db013E = {  "_ZN4aaaa5db013E", // class name
  bases__ZN4aaaa5db013E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db014  : ::aaaa::aa0 , ::aaaa::bb1 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db014E) C1{ BC2{ FL Fc} BC3{ Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db014E()
{
  extern Class_Descriptor cd__ZN4aaaa5db014E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa5db014E, buf);
    ::aaaa::db014 &lv = *(new (buf) ::aaaa::db014());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa5db014E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db014E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa5db014E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa5db014E");
    check_field_offset(lv, xc, ABISELECT(17,13), "_ZN4aaaa5db014E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db014E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db014E(Test__ZN4aaaa5db014E, "_ZN4aaaa5db014E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
static Base_Class bases__ZN4aaaa5db014E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db014E = {  "_ZN4aaaa5db014E", // class name
  bases__ZN4aaaa5db014E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db015  : ::aaaa::aa0 , ::aaaa::bb1 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db015E) C1{ BC2{ FL Fc} BC3{ Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db015E()
{
  extern Class_Descriptor cd__ZN4aaaa5db015E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa5db015E, buf);
    ::aaaa::db015 &lv = *(new (buf) ::aaaa::db015());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa5db015E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db015E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa5db015E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa5db015E");
    check_field_offset(lv, xc, ABISELECT(17,13), "_ZN4aaaa5db015E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db015E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db015E(Test__ZN4aaaa5db015E, "_ZN4aaaa5db015E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
static Base_Class bases__ZN4aaaa5db015E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db015E = {  "_ZN4aaaa5db015E", // class name
  bases__ZN4aaaa5db015E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0100  : ::aaaa::aa0 , ::aaaa::bb1 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc0100E) C1{ BC2{ FL Fc} BC3{ Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0100E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0100E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc0100E, buf);
    ::aaaa::dc0100 &lv = *(new (buf) ::aaaa::dc0100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc0100E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0100E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0100E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa6dc0100E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(24,16), "_ZN4aaaa6dc0100E");
    test_class_info(&lv, &cd__ZN4aaaa6dc0100E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0100E(Test__ZN4aaaa6dc0100E, "_ZN4aaaa6dc0100E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc0100E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0100E = {  "_ZN4aaaa6dc0100E", // class name
  bases__ZN4aaaa6dc0100E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0101  : ::aaaa::aa0 , ::aaaa::bb1 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc0101E) C1{ BC2{ FL Fc} BC3{ Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0101E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0101E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc0101E, buf);
    ::aaaa::dc0101 &lv = *(new (buf) ::aaaa::dc0101());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc0101E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0101E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0101E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa6dc0101E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(24,16), "_ZN4aaaa6dc0101E");
    test_class_info(&lv, &cd__ZN4aaaa6dc0101E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0101E(Test__ZN4aaaa6dc0101E, "_ZN4aaaa6dc0101E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc0101E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0101E = {  "_ZN4aaaa6dc0101E", // class name
  bases__ZN4aaaa6dc0101E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0102  : ::aaaa::aa0 , ::aaaa::bb1 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc0102E) C1{ BC2{ FL Fc} BC3{ Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0102E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0102E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc0102E, buf);
    ::aaaa::dc0102 &lv = *(new (buf) ::aaaa::dc0102());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc0102E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0102E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0102E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa6dc0102E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(24,16), "_ZN4aaaa6dc0102E");
    test_class_info(&lv, &cd__ZN4aaaa6dc0102E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0102E(Test__ZN4aaaa6dc0102E, "_ZN4aaaa6dc0102E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc0102E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0102E = {  "_ZN4aaaa6dc0102E", // class name
  bases__ZN4aaaa6dc0102E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0103  : ::aaaa::aa0 , ::aaaa::bb1 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc0103E) C1{ BC2{ FL Fc} BC3{ Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0103E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0103E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc0103E, buf);
    ::aaaa::dc0103 &lv = *(new (buf) ::aaaa::dc0103());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc0103E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0103E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0103E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa6dc0103E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(24,16), "_ZN4aaaa6dc0103E");
    test_class_info(&lv, &cd__ZN4aaaa6dc0103E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0103E(Test__ZN4aaaa6dc0103E, "_ZN4aaaa6dc0103E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc0103E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0103E = {  "_ZN4aaaa6dc0103E", // class name
  bases__ZN4aaaa6dc0103E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0104  : ::aaaa::aa0 , ::aaaa::bb1 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc0104E) C1{ BC2{ FL Fc} BC3{ Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0104E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0104E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc0104E, buf);
    ::aaaa::dc0104 &lv = *(new (buf) ::aaaa::dc0104());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc0104E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0104E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0104E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa6dc0104E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(24,16), "_ZN4aaaa6dc0104E");
    test_class_info(&lv, &cd__ZN4aaaa6dc0104E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0104E(Test__ZN4aaaa6dc0104E, "_ZN4aaaa6dc0104E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc0104E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0104E = {  "_ZN4aaaa6dc0104E", // class name
  bases__ZN4aaaa6dc0104E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0105  : ::aaaa::aa0 , ::aaaa::bb1 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc0105E) C1{ BC2{ FL Fc} BC3{ Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0105E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0105E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc0105E, buf);
    ::aaaa::dc0105 &lv = *(new (buf) ::aaaa::dc0105());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc0105E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0105E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0105E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa6dc0105E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(24,16), "_ZN4aaaa6dc0105E");
    test_class_info(&lv, &cd__ZN4aaaa6dc0105E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0105E(Test__ZN4aaaa6dc0105E, "_ZN4aaaa6dc0105E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc0105E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0105E = {  "_ZN4aaaa6dc0105E", // class name
  bases__ZN4aaaa6dc0105E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0110  : ::aaaa::aa0 , ::aaaa::bb1 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc0110E) C1{ BC2{ FL Fc} BC3{ Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0110E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0110E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0110E, buf);
    ::aaaa::dc0110 &lv = *(new (buf) ::aaaa::dc0110());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0110E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0110E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0110E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa6dc0110E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(17,13), "_ZN4aaaa6dc0110E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa6dc0110E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0110E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0110E(Test__ZN4aaaa6dc0110E, "_ZN4aaaa6dc0110E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc0110E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(17,13), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0110E = {  "_ZN4aaaa6dc0110E", // class name
  bases__ZN4aaaa6dc0110E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0111  : ::aaaa::aa0 , ::aaaa::bb1 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc0111E) C1{ BC2{ FL Fc} BC3{ Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0111E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0111E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0111E, buf);
    ::aaaa::dc0111 &lv = *(new (buf) ::aaaa::dc0111());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0111E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0111E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0111E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa6dc0111E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(17,13), "_ZN4aaaa6dc0111E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa6dc0111E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0111E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0111E(Test__ZN4aaaa6dc0111E, "_ZN4aaaa6dc0111E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc0111E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(17,13), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0111E = {  "_ZN4aaaa6dc0111E", // class name
  bases__ZN4aaaa6dc0111E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0112  : ::aaaa::aa0 , ::aaaa::bb1 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc0112E) C1{ BC2{ FL Fc} BC3{ Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0112E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0112E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0112E, buf);
    ::aaaa::dc0112 &lv = *(new (buf) ::aaaa::dc0112());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0112E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0112E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0112E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa6dc0112E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(17,13), "_ZN4aaaa6dc0112E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa6dc0112E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0112E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0112E(Test__ZN4aaaa6dc0112E, "_ZN4aaaa6dc0112E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc0112E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(17,13), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0112E = {  "_ZN4aaaa6dc0112E", // class name
  bases__ZN4aaaa6dc0112E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0113  : ::aaaa::aa0 , ::aaaa::bb1 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc0113E) C1{ BC2{ FL Fc} BC3{ Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0113E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0113E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0113E, buf);
    ::aaaa::dc0113 &lv = *(new (buf) ::aaaa::dc0113());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0113E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0113E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0113E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa6dc0113E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(17,13), "_ZN4aaaa6dc0113E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa6dc0113E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0113E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0113E(Test__ZN4aaaa6dc0113E, "_ZN4aaaa6dc0113E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc0113E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(17,13), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0113E = {  "_ZN4aaaa6dc0113E", // class name
  bases__ZN4aaaa6dc0113E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0114  : ::aaaa::aa0 , ::aaaa::bb1 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc0114E) C1{ BC2{ FL Fc} BC3{ Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0114E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0114E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0114E, buf);
    ::aaaa::dc0114 &lv = *(new (buf) ::aaaa::dc0114());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0114E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0114E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0114E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa6dc0114E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(17,13), "_ZN4aaaa6dc0114E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa6dc0114E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0114E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0114E(Test__ZN4aaaa6dc0114E, "_ZN4aaaa6dc0114E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc0114E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(17,13), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0114E = {  "_ZN4aaaa6dc0114E", // class name
  bases__ZN4aaaa6dc0114E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0115  : ::aaaa::aa0 , ::aaaa::bb1 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc0115E) C1{ BC2{ FL Fc} BC3{ Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0115E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0115E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0115E, buf);
    ::aaaa::dc0115 &lv = *(new (buf) ::aaaa::dc0115());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0115E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0115E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0115E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa6dc0115E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(17,13), "_ZN4aaaa6dc0115E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa6dc0115E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0115E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0115E(Test__ZN4aaaa6dc0115E, "_ZN4aaaa6dc0115E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc0115E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(17,13), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0115E = {  "_ZN4aaaa6dc0115E", // class name
  bases__ZN4aaaa6dc0115E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0120  : ::aaaa::aa0 , ::aaaa::bb1 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc0120E) C1{ BC2{ FL Fc} BC3{ Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0120E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0120E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0120E, buf);
    ::aaaa::dc0120 &lv = *(new (buf) ::aaaa::dc0120());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0120E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0120E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0120E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa6dc0120E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc0120E");
    check_field_offset(lv, xc, ABISELECT(17,13), "_ZN4aaaa6dc0120E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0120E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0120E(Test__ZN4aaaa6dc0120E, "_ZN4aaaa6dc0120E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc0120E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0120E = {  "_ZN4aaaa6dc0120E", // class name
  bases__ZN4aaaa6dc0120E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0121  : ::aaaa::aa0 , ::aaaa::bb1 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc0121E) C1{ BC2{ FL Fc} BC3{ Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0121E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0121E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0121E, buf);
    ::aaaa::dc0121 &lv = *(new (buf) ::aaaa::dc0121());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0121E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0121E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0121E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa6dc0121E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc0121E");
    check_field_offset(lv, xc, ABISELECT(17,13), "_ZN4aaaa6dc0121E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0121E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0121E(Test__ZN4aaaa6dc0121E, "_ZN4aaaa6dc0121E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc0121E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0121E = {  "_ZN4aaaa6dc0121E", // class name
  bases__ZN4aaaa6dc0121E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0122  : ::aaaa::aa0 , ::aaaa::bb1 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc0122E) C1{ BC2{ FL Fc} BC3{ Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0122E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0122E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0122E, buf);
    ::aaaa::dc0122 &lv = *(new (buf) ::aaaa::dc0122());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0122E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0122E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0122E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa6dc0122E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc0122E");
    check_field_offset(lv, xc, ABISELECT(17,13), "_ZN4aaaa6dc0122E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0122E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0122E(Test__ZN4aaaa6dc0122E, "_ZN4aaaa6dc0122E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc0122E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0122E = {  "_ZN4aaaa6dc0122E", // class name
  bases__ZN4aaaa6dc0122E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0123  : ::aaaa::aa0 , ::aaaa::bb1 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc0123E) C1{ BC2{ FL Fc} BC3{ Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0123E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0123E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0123E, buf);
    ::aaaa::dc0123 &lv = *(new (buf) ::aaaa::dc0123());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0123E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0123E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0123E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa6dc0123E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc0123E");
    check_field_offset(lv, xc, ABISELECT(17,13), "_ZN4aaaa6dc0123E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0123E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0123E(Test__ZN4aaaa6dc0123E, "_ZN4aaaa6dc0123E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc0123E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0123E = {  "_ZN4aaaa6dc0123E", // class name
  bases__ZN4aaaa6dc0123E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0124  : ::aaaa::aa0 , ::aaaa::bb1 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc0124E) C1{ BC2{ FL Fc} BC3{ Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0124E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0124E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0124E, buf);
    ::aaaa::dc0124 &lv = *(new (buf) ::aaaa::dc0124());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0124E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0124E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0124E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa6dc0124E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc0124E");
    check_field_offset(lv, xc, ABISELECT(17,13), "_ZN4aaaa6dc0124E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0124E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0124E(Test__ZN4aaaa6dc0124E, "_ZN4aaaa6dc0124E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc0124E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0124E = {  "_ZN4aaaa6dc0124E", // class name
  bases__ZN4aaaa6dc0124E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0125  : ::aaaa::aa0 , ::aaaa::bb1 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc0125E) C1{ BC2{ FL Fc} BC3{ Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0125E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0125E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0125E, buf);
    ::aaaa::dc0125 &lv = *(new (buf) ::aaaa::dc0125());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0125E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0125E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0125E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa6dc0125E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc0125E");
    check_field_offset(lv, xc, ABISELECT(17,13), "_ZN4aaaa6dc0125E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0125E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0125E(Test__ZN4aaaa6dc0125E, "_ZN4aaaa6dc0125E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc0125E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0125E = {  "_ZN4aaaa6dc0125E", // class name
  bases__ZN4aaaa6dc0125E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0130  : ::aaaa::aa0 , ::aaaa::bb1 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc0130E) C1{ BC2{ FL Fc} BC3{ Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0130E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0130E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa6dc0130E, buf);
    ::aaaa::dc0130 &lv = *(new (buf) ::aaaa::dc0130());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa6dc0130E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0130E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0130E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa6dc0130E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(18,14), "_ZN4aaaa6dc0130E");
    check_field_offset(lv, xc, ABISELECT(20,16), "_ZN4aaaa6dc0130E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0130E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0130E(Test__ZN4aaaa6dc0130E, "_ZN4aaaa6dc0130E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc0130E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(18,14), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0130E = {  "_ZN4aaaa6dc0130E", // class name
  bases__ZN4aaaa6dc0130E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0131  : ::aaaa::aa0 , ::aaaa::bb1 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc0131E) C1{ BC2{ FL Fc} BC3{ Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0131E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0131E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa6dc0131E, buf);
    ::aaaa::dc0131 &lv = *(new (buf) ::aaaa::dc0131());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa6dc0131E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0131E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0131E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa6dc0131E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(18,14), "_ZN4aaaa6dc0131E");
    check_field_offset(lv, xc, ABISELECT(20,16), "_ZN4aaaa6dc0131E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0131E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0131E(Test__ZN4aaaa6dc0131E, "_ZN4aaaa6dc0131E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc0131E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(18,14), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0131E = {  "_ZN4aaaa6dc0131E", // class name
  bases__ZN4aaaa6dc0131E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0132  : ::aaaa::aa0 , ::aaaa::bb1 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc0132E) C1{ BC2{ FL Fc} BC3{ Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0132E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0132E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa6dc0132E, buf);
    ::aaaa::dc0132 &lv = *(new (buf) ::aaaa::dc0132());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa6dc0132E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0132E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0132E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa6dc0132E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(18,14), "_ZN4aaaa6dc0132E");
    check_field_offset(lv, xc, ABISELECT(20,16), "_ZN4aaaa6dc0132E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0132E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0132E(Test__ZN4aaaa6dc0132E, "_ZN4aaaa6dc0132E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc0132E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(18,14), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0132E = {  "_ZN4aaaa6dc0132E", // class name
  bases__ZN4aaaa6dc0132E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0133  : ::aaaa::aa0 , ::aaaa::bb1 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc0133E) C1{ BC2{ FL Fc} BC3{ Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0133E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0133E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa6dc0133E, buf);
    ::aaaa::dc0133 &lv = *(new (buf) ::aaaa::dc0133());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa6dc0133E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0133E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0133E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa6dc0133E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(18,14), "_ZN4aaaa6dc0133E");
    check_field_offset(lv, xc, ABISELECT(20,16), "_ZN4aaaa6dc0133E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0133E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0133E(Test__ZN4aaaa6dc0133E, "_ZN4aaaa6dc0133E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc0133E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(18,14), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0133E = {  "_ZN4aaaa6dc0133E", // class name
  bases__ZN4aaaa6dc0133E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0134  : ::aaaa::aa0 , ::aaaa::bb1 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc0134E) C1{ BC2{ FL Fc} BC3{ Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0134E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0134E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa6dc0134E, buf);
    ::aaaa::dc0134 &lv = *(new (buf) ::aaaa::dc0134());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa6dc0134E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0134E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0134E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa6dc0134E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(18,14), "_ZN4aaaa6dc0134E");
    check_field_offset(lv, xc, ABISELECT(20,16), "_ZN4aaaa6dc0134E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0134E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0134E(Test__ZN4aaaa6dc0134E, "_ZN4aaaa6dc0134E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc0134E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(18,14), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0134E = {  "_ZN4aaaa6dc0134E", // class name
  bases__ZN4aaaa6dc0134E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0135  : ::aaaa::aa0 , ::aaaa::bb1 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc0135E) C1{ BC2{ FL Fc} BC3{ Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0135E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0135E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa6dc0135E, buf);
    ::aaaa::dc0135 &lv = *(new (buf) ::aaaa::dc0135());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa6dc0135E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0135E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0135E");
    check_base_class_offset(lv, (::aaaa::bb1*), ABISELECT(16,12), "_ZN4aaaa6dc0135E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(18,14), "_ZN4aaaa6dc0135E");
    check_field_offset(lv, xc, ABISELECT(20,16), "_ZN4aaaa6dc0135E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0135E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0135E(Test__ZN4aaaa6dc0135E, "_ZN4aaaa6dc0135E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc0135E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(18,14), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0135E = {  "_ZN4aaaa6dc0135E", // class name
  bases__ZN4aaaa6dc0135E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db020  : ::aaaa::aa0 , ::aaaa::bb2 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db020E) C1{ BC2{ FL Fc} BC3{} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db020E()
{
  extern Class_Descriptor cd__ZN4aaaa5db020E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa5db020E, buf);
    ::aaaa::db020 &lv = *(new (buf) ::aaaa::db020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa5db020E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db020E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa5db020E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa5db020E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa5db020E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db020E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db020E(Test__ZN4aaaa5db020E, "_ZN4aaaa5db020E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
static Base_Class bases__ZN4aaaa5db020E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db020E = {  "_ZN4aaaa5db020E", // class name
  bases__ZN4aaaa5db020E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db021  : ::aaaa::aa0 , ::aaaa::bb2 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db021E) C1{ BC2{ FL Fc} BC3{} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db021E()
{
  extern Class_Descriptor cd__ZN4aaaa5db021E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa5db021E, buf);
    ::aaaa::db021 &lv = *(new (buf) ::aaaa::db021());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa5db021E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db021E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa5db021E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa5db021E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa5db021E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db021E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db021E(Test__ZN4aaaa5db021E, "_ZN4aaaa5db021E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
static Base_Class bases__ZN4aaaa5db021E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db021E = {  "_ZN4aaaa5db021E", // class name
  bases__ZN4aaaa5db021E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db022  : ::aaaa::aa0 , ::aaaa::bb2 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db022E) C1{ BC2{ FL Fc} BC3{} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db022E()
{
  extern Class_Descriptor cd__ZN4aaaa5db022E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa5db022E, buf);
    ::aaaa::db022 &lv = *(new (buf) ::aaaa::db022());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa5db022E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db022E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa5db022E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa5db022E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa5db022E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db022E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db022E(Test__ZN4aaaa5db022E, "_ZN4aaaa5db022E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
static Base_Class bases__ZN4aaaa5db022E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db022E = {  "_ZN4aaaa5db022E", // class name
  bases__ZN4aaaa5db022E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db023  : ::aaaa::aa0 , ::aaaa::bb2 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db023E) C1{ BC2{ FL Fc} BC3{} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db023E()
{
  extern Class_Descriptor cd__ZN4aaaa5db023E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa5db023E, buf);
    ::aaaa::db023 &lv = *(new (buf) ::aaaa::db023());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa5db023E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db023E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa5db023E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa5db023E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa5db023E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db023E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db023E(Test__ZN4aaaa5db023E, "_ZN4aaaa5db023E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
static Base_Class bases__ZN4aaaa5db023E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db023E = {  "_ZN4aaaa5db023E", // class name
  bases__ZN4aaaa5db023E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db024  : ::aaaa::aa0 , ::aaaa::bb2 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db024E) C1{ BC2{ FL Fc} BC3{} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db024E()
{
  extern Class_Descriptor cd__ZN4aaaa5db024E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa5db024E, buf);
    ::aaaa::db024 &lv = *(new (buf) ::aaaa::db024());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa5db024E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db024E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa5db024E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa5db024E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa5db024E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db024E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db024E(Test__ZN4aaaa5db024E, "_ZN4aaaa5db024E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
static Base_Class bases__ZN4aaaa5db024E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db024E = {  "_ZN4aaaa5db024E", // class name
  bases__ZN4aaaa5db024E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db025  : ::aaaa::aa0 , ::aaaa::bb2 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db025E) C1{ BC2{ FL Fc} BC3{} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db025E()
{
  extern Class_Descriptor cd__ZN4aaaa5db025E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa5db025E, buf);
    ::aaaa::db025 &lv = *(new (buf) ::aaaa::db025());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa5db025E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db025E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa5db025E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa5db025E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa5db025E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db025E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db025E(Test__ZN4aaaa5db025E, "_ZN4aaaa5db025E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
static Base_Class bases__ZN4aaaa5db025E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db025E = {  "_ZN4aaaa5db025E", // class name
  bases__ZN4aaaa5db025E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0200  : ::aaaa::aa0 , ::aaaa::bb2 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc0200E) C1{ BC2{ FL Fc} BC3{} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0200E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0200E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4aaaa6dc0200E, buf);
    ::aaaa::dc0200 &lv = *(new (buf) ::aaaa::dc0200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4aaaa6dc0200E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0200E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0200E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc0200E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(16,12), "_ZN4aaaa6dc0200E");
    test_class_info(&lv, &cd__ZN4aaaa6dc0200E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0200E(Test__ZN4aaaa6dc0200E, "_ZN4aaaa6dc0200E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc0200E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0200E = {  "_ZN4aaaa6dc0200E", // class name
  bases__ZN4aaaa6dc0200E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0201  : ::aaaa::aa0 , ::aaaa::bb2 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc0201E) C1{ BC2{ FL Fc} BC3{} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0201E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0201E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4aaaa6dc0201E, buf);
    ::aaaa::dc0201 &lv = *(new (buf) ::aaaa::dc0201());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4aaaa6dc0201E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0201E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0201E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc0201E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(16,12), "_ZN4aaaa6dc0201E");
    test_class_info(&lv, &cd__ZN4aaaa6dc0201E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0201E(Test__ZN4aaaa6dc0201E, "_ZN4aaaa6dc0201E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc0201E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0201E = {  "_ZN4aaaa6dc0201E", // class name
  bases__ZN4aaaa6dc0201E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0202  : ::aaaa::aa0 , ::aaaa::bb2 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc0202E) C1{ BC2{ FL Fc} BC3{} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0202E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0202E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4aaaa6dc0202E, buf);
    ::aaaa::dc0202 &lv = *(new (buf) ::aaaa::dc0202());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4aaaa6dc0202E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0202E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0202E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc0202E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(16,12), "_ZN4aaaa6dc0202E");
    test_class_info(&lv, &cd__ZN4aaaa6dc0202E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0202E(Test__ZN4aaaa6dc0202E, "_ZN4aaaa6dc0202E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc0202E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0202E = {  "_ZN4aaaa6dc0202E", // class name
  bases__ZN4aaaa6dc0202E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0203  : ::aaaa::aa0 , ::aaaa::bb2 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc0203E) C1{ BC2{ FL Fc} BC3{} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0203E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0203E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4aaaa6dc0203E, buf);
    ::aaaa::dc0203 &lv = *(new (buf) ::aaaa::dc0203());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4aaaa6dc0203E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0203E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0203E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc0203E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(16,12), "_ZN4aaaa6dc0203E");
    test_class_info(&lv, &cd__ZN4aaaa6dc0203E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0203E(Test__ZN4aaaa6dc0203E, "_ZN4aaaa6dc0203E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc0203E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0203E = {  "_ZN4aaaa6dc0203E", // class name
  bases__ZN4aaaa6dc0203E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0204  : ::aaaa::aa0 , ::aaaa::bb2 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc0204E) C1{ BC2{ FL Fc} BC3{} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0204E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0204E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4aaaa6dc0204E, buf);
    ::aaaa::dc0204 &lv = *(new (buf) ::aaaa::dc0204());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4aaaa6dc0204E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0204E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0204E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc0204E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(16,12), "_ZN4aaaa6dc0204E");
    test_class_info(&lv, &cd__ZN4aaaa6dc0204E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0204E(Test__ZN4aaaa6dc0204E, "_ZN4aaaa6dc0204E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc0204E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0204E = {  "_ZN4aaaa6dc0204E", // class name
  bases__ZN4aaaa6dc0204E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0205  : ::aaaa::aa0 , ::aaaa::bb2 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc0205E) C1{ BC2{ FL Fc} BC3{} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0205E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0205E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4aaaa6dc0205E, buf);
    ::aaaa::dc0205 &lv = *(new (buf) ::aaaa::dc0205());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4aaaa6dc0205E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0205E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0205E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc0205E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(16,12), "_ZN4aaaa6dc0205E");
    test_class_info(&lv, &cd__ZN4aaaa6dc0205E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0205E(Test__ZN4aaaa6dc0205E, "_ZN4aaaa6dc0205E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc0205E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0205E = {  "_ZN4aaaa6dc0205E", // class name
  bases__ZN4aaaa6dc0205E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0210  : ::aaaa::aa0 , ::aaaa::bb2 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc0210E) C1{ BC2{ FL Fc} BC3{} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0210E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0210E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0210E, buf);
    ::aaaa::dc0210 &lv = *(new (buf) ::aaaa::dc0210());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0210E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0210E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0210E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc0210E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(16,12), "_ZN4aaaa6dc0210E");
    check_field_offset(lv, xc, ABISELECT(17,13), "_ZN4aaaa6dc0210E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0210E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0210E(Test__ZN4aaaa6dc0210E, "_ZN4aaaa6dc0210E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc0210E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0210E = {  "_ZN4aaaa6dc0210E", // class name
  bases__ZN4aaaa6dc0210E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0211  : ::aaaa::aa0 , ::aaaa::bb2 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc0211E) C1{ BC2{ FL Fc} BC3{} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0211E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0211E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0211E, buf);
    ::aaaa::dc0211 &lv = *(new (buf) ::aaaa::dc0211());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0211E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0211E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0211E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc0211E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(16,12), "_ZN4aaaa6dc0211E");
    check_field_offset(lv, xc, ABISELECT(17,13), "_ZN4aaaa6dc0211E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0211E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0211E(Test__ZN4aaaa6dc0211E, "_ZN4aaaa6dc0211E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc0211E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0211E = {  "_ZN4aaaa6dc0211E", // class name
  bases__ZN4aaaa6dc0211E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0212  : ::aaaa::aa0 , ::aaaa::bb2 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc0212E) C1{ BC2{ FL Fc} BC3{} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0212E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0212E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0212E, buf);
    ::aaaa::dc0212 &lv = *(new (buf) ::aaaa::dc0212());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0212E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0212E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0212E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc0212E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(16,12), "_ZN4aaaa6dc0212E");
    check_field_offset(lv, xc, ABISELECT(17,13), "_ZN4aaaa6dc0212E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0212E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0212E(Test__ZN4aaaa6dc0212E, "_ZN4aaaa6dc0212E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc0212E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0212E = {  "_ZN4aaaa6dc0212E", // class name
  bases__ZN4aaaa6dc0212E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0213  : ::aaaa::aa0 , ::aaaa::bb2 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc0213E) C1{ BC2{ FL Fc} BC3{} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0213E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0213E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0213E, buf);
    ::aaaa::dc0213 &lv = *(new (buf) ::aaaa::dc0213());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0213E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0213E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0213E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc0213E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(16,12), "_ZN4aaaa6dc0213E");
    check_field_offset(lv, xc, ABISELECT(17,13), "_ZN4aaaa6dc0213E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0213E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0213E(Test__ZN4aaaa6dc0213E, "_ZN4aaaa6dc0213E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc0213E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0213E = {  "_ZN4aaaa6dc0213E", // class name
  bases__ZN4aaaa6dc0213E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0214  : ::aaaa::aa0 , ::aaaa::bb2 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc0214E) C1{ BC2{ FL Fc} BC3{} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0214E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0214E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0214E, buf);
    ::aaaa::dc0214 &lv = *(new (buf) ::aaaa::dc0214());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0214E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0214E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0214E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc0214E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(16,12), "_ZN4aaaa6dc0214E");
    check_field_offset(lv, xc, ABISELECT(17,13), "_ZN4aaaa6dc0214E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0214E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0214E(Test__ZN4aaaa6dc0214E, "_ZN4aaaa6dc0214E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc0214E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0214E = {  "_ZN4aaaa6dc0214E", // class name
  bases__ZN4aaaa6dc0214E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0215  : ::aaaa::aa0 , ::aaaa::bb2 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc0215E) C1{ BC2{ FL Fc} BC3{} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0215E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0215E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0215E, buf);
    ::aaaa::dc0215 &lv = *(new (buf) ::aaaa::dc0215());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0215E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0215E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0215E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc0215E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(16,12), "_ZN4aaaa6dc0215E");
    check_field_offset(lv, xc, ABISELECT(17,13), "_ZN4aaaa6dc0215E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0215E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0215E(Test__ZN4aaaa6dc0215E, "_ZN4aaaa6dc0215E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc0215E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0215E = {  "_ZN4aaaa6dc0215E", // class name
  bases__ZN4aaaa6dc0215E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0220  : ::aaaa::aa0 , ::aaaa::bb2 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc0220E) C1{ BC2{ FL Fc} BC3{} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0220E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0220E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0220E, buf);
    ::aaaa::dc0220 &lv = *(new (buf) ::aaaa::dc0220());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0220E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0220E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0220E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc0220E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc0220E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa6dc0220E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0220E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0220E(Test__ZN4aaaa6dc0220E, "_ZN4aaaa6dc0220E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc0220E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0220E = {  "_ZN4aaaa6dc0220E", // class name
  bases__ZN4aaaa6dc0220E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0221  : ::aaaa::aa0 , ::aaaa::bb2 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc0221E) C1{ BC2{ FL Fc} BC3{} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0221E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0221E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0221E, buf);
    ::aaaa::dc0221 &lv = *(new (buf) ::aaaa::dc0221());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0221E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0221E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0221E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc0221E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc0221E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa6dc0221E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0221E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0221E(Test__ZN4aaaa6dc0221E, "_ZN4aaaa6dc0221E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc0221E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0221E = {  "_ZN4aaaa6dc0221E", // class name
  bases__ZN4aaaa6dc0221E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0222  : ::aaaa::aa0 , ::aaaa::bb2 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc0222E) C1{ BC2{ FL Fc} BC3{} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0222E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0222E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0222E, buf);
    ::aaaa::dc0222 &lv = *(new (buf) ::aaaa::dc0222());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0222E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0222E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0222E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc0222E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc0222E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa6dc0222E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0222E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0222E(Test__ZN4aaaa6dc0222E, "_ZN4aaaa6dc0222E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc0222E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0222E = {  "_ZN4aaaa6dc0222E", // class name
  bases__ZN4aaaa6dc0222E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0223  : ::aaaa::aa0 , ::aaaa::bb2 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc0223E) C1{ BC2{ FL Fc} BC3{} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0223E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0223E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0223E, buf);
    ::aaaa::dc0223 &lv = *(new (buf) ::aaaa::dc0223());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0223E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0223E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0223E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc0223E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc0223E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa6dc0223E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0223E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0223E(Test__ZN4aaaa6dc0223E, "_ZN4aaaa6dc0223E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc0223E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0223E = {  "_ZN4aaaa6dc0223E", // class name
  bases__ZN4aaaa6dc0223E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0224  : ::aaaa::aa0 , ::aaaa::bb2 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc0224E) C1{ BC2{ FL Fc} BC3{} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0224E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0224E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0224E, buf);
    ::aaaa::dc0224 &lv = *(new (buf) ::aaaa::dc0224());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0224E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0224E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0224E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc0224E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc0224E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa6dc0224E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0224E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0224E(Test__ZN4aaaa6dc0224E, "_ZN4aaaa6dc0224E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc0224E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0224E = {  "_ZN4aaaa6dc0224E", // class name
  bases__ZN4aaaa6dc0224E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0225  : ::aaaa::aa0 , ::aaaa::bb2 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc0225E) C1{ BC2{ FL Fc} BC3{} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0225E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0225E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0225E, buf);
    ::aaaa::dc0225 &lv = *(new (buf) ::aaaa::dc0225());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0225E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0225E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0225E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc0225E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc0225E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa6dc0225E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0225E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0225E(Test__ZN4aaaa6dc0225E, "_ZN4aaaa6dc0225E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc0225E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0225E = {  "_ZN4aaaa6dc0225E", // class name
  bases__ZN4aaaa6dc0225E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0230  : ::aaaa::aa0 , ::aaaa::bb2 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc0230E) C1{ BC2{ FL Fc} BC3{} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0230E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0230E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa6dc0230E, buf);
    ::aaaa::dc0230 &lv = *(new (buf) ::aaaa::dc0230());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa6dc0230E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0230E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0230E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc0230E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(16,12), "_ZN4aaaa6dc0230E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa6dc0230E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0230E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0230E(Test__ZN4aaaa6dc0230E, "_ZN4aaaa6dc0230E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc0230E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0230E = {  "_ZN4aaaa6dc0230E", // class name
  bases__ZN4aaaa6dc0230E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0231  : ::aaaa::aa0 , ::aaaa::bb2 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc0231E) C1{ BC2{ FL Fc} BC3{} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0231E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0231E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa6dc0231E, buf);
    ::aaaa::dc0231 &lv = *(new (buf) ::aaaa::dc0231());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa6dc0231E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0231E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0231E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc0231E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(16,12), "_ZN4aaaa6dc0231E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa6dc0231E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0231E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0231E(Test__ZN4aaaa6dc0231E, "_ZN4aaaa6dc0231E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc0231E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0231E = {  "_ZN4aaaa6dc0231E", // class name
  bases__ZN4aaaa6dc0231E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0232  : ::aaaa::aa0 , ::aaaa::bb2 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc0232E) C1{ BC2{ FL Fc} BC3{} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0232E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0232E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa6dc0232E, buf);
    ::aaaa::dc0232 &lv = *(new (buf) ::aaaa::dc0232());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa6dc0232E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0232E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0232E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc0232E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(16,12), "_ZN4aaaa6dc0232E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa6dc0232E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0232E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0232E(Test__ZN4aaaa6dc0232E, "_ZN4aaaa6dc0232E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc0232E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0232E = {  "_ZN4aaaa6dc0232E", // class name
  bases__ZN4aaaa6dc0232E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0233  : ::aaaa::aa0 , ::aaaa::bb2 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc0233E) C1{ BC2{ FL Fc} BC3{} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0233E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0233E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa6dc0233E, buf);
    ::aaaa::dc0233 &lv = *(new (buf) ::aaaa::dc0233());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa6dc0233E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0233E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0233E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc0233E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(16,12), "_ZN4aaaa6dc0233E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa6dc0233E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0233E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0233E(Test__ZN4aaaa6dc0233E, "_ZN4aaaa6dc0233E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc0233E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0233E = {  "_ZN4aaaa6dc0233E", // class name
  bases__ZN4aaaa6dc0233E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0234  : ::aaaa::aa0 , ::aaaa::bb2 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc0234E) C1{ BC2{ FL Fc} BC3{} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0234E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0234E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa6dc0234E, buf);
    ::aaaa::dc0234 &lv = *(new (buf) ::aaaa::dc0234());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa6dc0234E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0234E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0234E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc0234E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(16,12), "_ZN4aaaa6dc0234E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa6dc0234E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0234E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0234E(Test__ZN4aaaa6dc0234E, "_ZN4aaaa6dc0234E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc0234E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0234E = {  "_ZN4aaaa6dc0234E", // class name
  bases__ZN4aaaa6dc0234E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0235  : ::aaaa::aa0 , ::aaaa::bb2 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc0235E) C1{ BC2{ FL Fc} BC3{} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0235E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0235E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa6dc0235E, buf);
    ::aaaa::dc0235 &lv = *(new (buf) ::aaaa::dc0235());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa6dc0235E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0235E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0235E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc0235E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(16,12), "_ZN4aaaa6dc0235E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa6dc0235E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0235E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0235E(Test__ZN4aaaa6dc0235E, "_ZN4aaaa6dc0235E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc0235E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0235E = {  "_ZN4aaaa6dc0235E", // class name
  bases__ZN4aaaa6dc0235E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db030  : ::aaaa::aa0 , ::aaaa::bb3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db030E) C1{ BC2{ FL Fc} BC3{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db030E()
{
  extern Class_Descriptor cd__ZN4aaaa5db030E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa5db030E, buf);
    ::aaaa::db030 &lv = *(new (buf) ::aaaa::db030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa5db030E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db030E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa5db030E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa5db030E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa5db030E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db030E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db030E(Test__ZN4aaaa5db030E, "_ZN4aaaa5db030E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
static Base_Class bases__ZN4aaaa5db030E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db030E = {  "_ZN4aaaa5db030E", // class name
  bases__ZN4aaaa5db030E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db031  : ::aaaa::aa0 , ::aaaa::bb3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db031E) C1{ BC2{ FL Fc} BC3{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db031E()
{
  extern Class_Descriptor cd__ZN4aaaa5db031E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa5db031E, buf);
    ::aaaa::db031 &lv = *(new (buf) ::aaaa::db031());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa5db031E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db031E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa5db031E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa5db031E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa5db031E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db031E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db031E(Test__ZN4aaaa5db031E, "_ZN4aaaa5db031E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
static Base_Class bases__ZN4aaaa5db031E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db031E = {  "_ZN4aaaa5db031E", // class name
  bases__ZN4aaaa5db031E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db032  : ::aaaa::aa0 , ::aaaa::bb3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db032E) C1{ BC2{ FL Fc} BC3{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db032E()
{
  extern Class_Descriptor cd__ZN4aaaa5db032E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa5db032E, buf);
    ::aaaa::db032 &lv = *(new (buf) ::aaaa::db032());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa5db032E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db032E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa5db032E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa5db032E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa5db032E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db032E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db032E(Test__ZN4aaaa5db032E, "_ZN4aaaa5db032E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
static Base_Class bases__ZN4aaaa5db032E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db032E = {  "_ZN4aaaa5db032E", // class name
  bases__ZN4aaaa5db032E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db033  : ::aaaa::aa0 , ::aaaa::bb3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db033E) C1{ BC2{ FL Fc} BC3{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db033E()
{
  extern Class_Descriptor cd__ZN4aaaa5db033E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa5db033E, buf);
    ::aaaa::db033 &lv = *(new (buf) ::aaaa::db033());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa5db033E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db033E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa5db033E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa5db033E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa5db033E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db033E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db033E(Test__ZN4aaaa5db033E, "_ZN4aaaa5db033E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
static Base_Class bases__ZN4aaaa5db033E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db033E = {  "_ZN4aaaa5db033E", // class name
  bases__ZN4aaaa5db033E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db034  : ::aaaa::aa0 , ::aaaa::bb3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db034E) C1{ BC2{ FL Fc} BC3{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db034E()
{
  extern Class_Descriptor cd__ZN4aaaa5db034E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa5db034E, buf);
    ::aaaa::db034 &lv = *(new (buf) ::aaaa::db034());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa5db034E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db034E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa5db034E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa5db034E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa5db034E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db034E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db034E(Test__ZN4aaaa5db034E, "_ZN4aaaa5db034E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
static Base_Class bases__ZN4aaaa5db034E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db034E = {  "_ZN4aaaa5db034E", // class name
  bases__ZN4aaaa5db034E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db035  : ::aaaa::aa0 , ::aaaa::bb3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db035E) C1{ BC2{ FL Fc} BC3{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db035E()
{
  extern Class_Descriptor cd__ZN4aaaa5db035E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa5db035E, buf);
    ::aaaa::db035 &lv = *(new (buf) ::aaaa::db035());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa5db035E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db035E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa5db035E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa5db035E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa5db035E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db035E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db035E(Test__ZN4aaaa5db035E, "_ZN4aaaa5db035E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
static Base_Class bases__ZN4aaaa5db035E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db035E = {  "_ZN4aaaa5db035E", // class name
  bases__ZN4aaaa5db035E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0300  : ::aaaa::aa0 , ::aaaa::bb3 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc0300E) C1{ BC2{ FL Fc} BC3{ Fs} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0300E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0300E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc0300E, buf);
    ::aaaa::dc0300 &lv = *(new (buf) ::aaaa::dc0300());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc0300E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0300E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0300E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa6dc0300E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(24,16), "_ZN4aaaa6dc0300E");
    test_class_info(&lv, &cd__ZN4aaaa6dc0300E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0300E(Test__ZN4aaaa6dc0300E, "_ZN4aaaa6dc0300E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc0300E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0300E = {  "_ZN4aaaa6dc0300E", // class name
  bases__ZN4aaaa6dc0300E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0301  : ::aaaa::aa0 , ::aaaa::bb3 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc0301E) C1{ BC2{ FL Fc} BC3{ Fs} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0301E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0301E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc0301E, buf);
    ::aaaa::dc0301 &lv = *(new (buf) ::aaaa::dc0301());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc0301E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0301E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0301E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa6dc0301E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(24,16), "_ZN4aaaa6dc0301E");
    test_class_info(&lv, &cd__ZN4aaaa6dc0301E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0301E(Test__ZN4aaaa6dc0301E, "_ZN4aaaa6dc0301E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc0301E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0301E = {  "_ZN4aaaa6dc0301E", // class name
  bases__ZN4aaaa6dc0301E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0302  : ::aaaa::aa0 , ::aaaa::bb3 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc0302E) C1{ BC2{ FL Fc} BC3{ Fs} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0302E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0302E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc0302E, buf);
    ::aaaa::dc0302 &lv = *(new (buf) ::aaaa::dc0302());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc0302E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0302E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0302E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa6dc0302E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(24,16), "_ZN4aaaa6dc0302E");
    test_class_info(&lv, &cd__ZN4aaaa6dc0302E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0302E(Test__ZN4aaaa6dc0302E, "_ZN4aaaa6dc0302E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc0302E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0302E = {  "_ZN4aaaa6dc0302E", // class name
  bases__ZN4aaaa6dc0302E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0303  : ::aaaa::aa0 , ::aaaa::bb3 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc0303E) C1{ BC2{ FL Fc} BC3{ Fs} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0303E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0303E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc0303E, buf);
    ::aaaa::dc0303 &lv = *(new (buf) ::aaaa::dc0303());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc0303E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0303E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0303E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa6dc0303E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(24,16), "_ZN4aaaa6dc0303E");
    test_class_info(&lv, &cd__ZN4aaaa6dc0303E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0303E(Test__ZN4aaaa6dc0303E, "_ZN4aaaa6dc0303E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc0303E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0303E = {  "_ZN4aaaa6dc0303E", // class name
  bases__ZN4aaaa6dc0303E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0304  : ::aaaa::aa0 , ::aaaa::bb3 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc0304E) C1{ BC2{ FL Fc} BC3{ Fs} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0304E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0304E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc0304E, buf);
    ::aaaa::dc0304 &lv = *(new (buf) ::aaaa::dc0304());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc0304E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0304E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0304E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa6dc0304E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(24,16), "_ZN4aaaa6dc0304E");
    test_class_info(&lv, &cd__ZN4aaaa6dc0304E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0304E(Test__ZN4aaaa6dc0304E, "_ZN4aaaa6dc0304E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc0304E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0304E = {  "_ZN4aaaa6dc0304E", // class name
  bases__ZN4aaaa6dc0304E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0305  : ::aaaa::aa0 , ::aaaa::bb3 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc0305E) C1{ BC2{ FL Fc} BC3{ Fs} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0305E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0305E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc0305E, buf);
    ::aaaa::dc0305 &lv = *(new (buf) ::aaaa::dc0305());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc0305E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0305E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0305E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa6dc0305E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(24,16), "_ZN4aaaa6dc0305E");
    test_class_info(&lv, &cd__ZN4aaaa6dc0305E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0305E(Test__ZN4aaaa6dc0305E, "_ZN4aaaa6dc0305E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc0305E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0305E = {  "_ZN4aaaa6dc0305E", // class name
  bases__ZN4aaaa6dc0305E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0310  : ::aaaa::aa0 , ::aaaa::bb3 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc0310E) C1{ BC2{ FL Fc} BC3{ Fs} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0310E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0310E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0310E, buf);
    ::aaaa::dc0310 &lv = *(new (buf) ::aaaa::dc0310());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0310E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0310E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0310E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa6dc0310E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(18,14), "_ZN4aaaa6dc0310E");
    check_field_offset(lv, xc, ABISELECT(19,15), "_ZN4aaaa6dc0310E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0310E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0310E(Test__ZN4aaaa6dc0310E, "_ZN4aaaa6dc0310E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc0310E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(18,14), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0310E = {  "_ZN4aaaa6dc0310E", // class name
  bases__ZN4aaaa6dc0310E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0311  : ::aaaa::aa0 , ::aaaa::bb3 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc0311E) C1{ BC2{ FL Fc} BC3{ Fs} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0311E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0311E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0311E, buf);
    ::aaaa::dc0311 &lv = *(new (buf) ::aaaa::dc0311());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0311E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0311E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0311E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa6dc0311E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(18,14), "_ZN4aaaa6dc0311E");
    check_field_offset(lv, xc, ABISELECT(19,15), "_ZN4aaaa6dc0311E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0311E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0311E(Test__ZN4aaaa6dc0311E, "_ZN4aaaa6dc0311E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc0311E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(18,14), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0311E = {  "_ZN4aaaa6dc0311E", // class name
  bases__ZN4aaaa6dc0311E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0312  : ::aaaa::aa0 , ::aaaa::bb3 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc0312E) C1{ BC2{ FL Fc} BC3{ Fs} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0312E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0312E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0312E, buf);
    ::aaaa::dc0312 &lv = *(new (buf) ::aaaa::dc0312());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0312E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0312E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0312E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa6dc0312E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(18,14), "_ZN4aaaa6dc0312E");
    check_field_offset(lv, xc, ABISELECT(19,15), "_ZN4aaaa6dc0312E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0312E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0312E(Test__ZN4aaaa6dc0312E, "_ZN4aaaa6dc0312E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc0312E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(18,14), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0312E = {  "_ZN4aaaa6dc0312E", // class name
  bases__ZN4aaaa6dc0312E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0313  : ::aaaa::aa0 , ::aaaa::bb3 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc0313E) C1{ BC2{ FL Fc} BC3{ Fs} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0313E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0313E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0313E, buf);
    ::aaaa::dc0313 &lv = *(new (buf) ::aaaa::dc0313());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0313E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0313E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0313E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa6dc0313E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(18,14), "_ZN4aaaa6dc0313E");
    check_field_offset(lv, xc, ABISELECT(19,15), "_ZN4aaaa6dc0313E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0313E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0313E(Test__ZN4aaaa6dc0313E, "_ZN4aaaa6dc0313E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc0313E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(18,14), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0313E = {  "_ZN4aaaa6dc0313E", // class name
  bases__ZN4aaaa6dc0313E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0314  : ::aaaa::aa0 , ::aaaa::bb3 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc0314E) C1{ BC2{ FL Fc} BC3{ Fs} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0314E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0314E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0314E, buf);
    ::aaaa::dc0314 &lv = *(new (buf) ::aaaa::dc0314());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0314E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0314E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0314E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa6dc0314E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(18,14), "_ZN4aaaa6dc0314E");
    check_field_offset(lv, xc, ABISELECT(19,15), "_ZN4aaaa6dc0314E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0314E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0314E(Test__ZN4aaaa6dc0314E, "_ZN4aaaa6dc0314E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc0314E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(18,14), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0314E = {  "_ZN4aaaa6dc0314E", // class name
  bases__ZN4aaaa6dc0314E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0315  : ::aaaa::aa0 , ::aaaa::bb3 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc0315E) C1{ BC2{ FL Fc} BC3{ Fs} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0315E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0315E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0315E, buf);
    ::aaaa::dc0315 &lv = *(new (buf) ::aaaa::dc0315());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0315E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0315E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0315E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa6dc0315E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(18,14), "_ZN4aaaa6dc0315E");
    check_field_offset(lv, xc, ABISELECT(19,15), "_ZN4aaaa6dc0315E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0315E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0315E(Test__ZN4aaaa6dc0315E, "_ZN4aaaa6dc0315E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc0315E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(18,14), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0315E = {  "_ZN4aaaa6dc0315E", // class name
  bases__ZN4aaaa6dc0315E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0320  : ::aaaa::aa0 , ::aaaa::bb3 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc0320E) C1{ BC2{ FL Fc} BC3{ Fs} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0320E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0320E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0320E, buf);
    ::aaaa::dc0320 &lv = *(new (buf) ::aaaa::dc0320());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0320E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0320E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0320E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa6dc0320E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc0320E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa6dc0320E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0320E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0320E(Test__ZN4aaaa6dc0320E, "_ZN4aaaa6dc0320E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc0320E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0320E = {  "_ZN4aaaa6dc0320E", // class name
  bases__ZN4aaaa6dc0320E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0321  : ::aaaa::aa0 , ::aaaa::bb3 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc0321E) C1{ BC2{ FL Fc} BC3{ Fs} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0321E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0321E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0321E, buf);
    ::aaaa::dc0321 &lv = *(new (buf) ::aaaa::dc0321());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0321E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0321E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0321E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa6dc0321E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc0321E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa6dc0321E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0321E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0321E(Test__ZN4aaaa6dc0321E, "_ZN4aaaa6dc0321E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc0321E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0321E = {  "_ZN4aaaa6dc0321E", // class name
  bases__ZN4aaaa6dc0321E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0322  : ::aaaa::aa0 , ::aaaa::bb3 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc0322E) C1{ BC2{ FL Fc} BC3{ Fs} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0322E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0322E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0322E, buf);
    ::aaaa::dc0322 &lv = *(new (buf) ::aaaa::dc0322());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0322E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0322E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0322E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa6dc0322E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc0322E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa6dc0322E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0322E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0322E(Test__ZN4aaaa6dc0322E, "_ZN4aaaa6dc0322E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc0322E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0322E = {  "_ZN4aaaa6dc0322E", // class name
  bases__ZN4aaaa6dc0322E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0323  : ::aaaa::aa0 , ::aaaa::bb3 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc0323E) C1{ BC2{ FL Fc} BC3{ Fs} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0323E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0323E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0323E, buf);
    ::aaaa::dc0323 &lv = *(new (buf) ::aaaa::dc0323());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0323E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0323E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0323E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa6dc0323E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc0323E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa6dc0323E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0323E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0323E(Test__ZN4aaaa6dc0323E, "_ZN4aaaa6dc0323E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc0323E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0323E = {  "_ZN4aaaa6dc0323E", // class name
  bases__ZN4aaaa6dc0323E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0324  : ::aaaa::aa0 , ::aaaa::bb3 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc0324E) C1{ BC2{ FL Fc} BC3{ Fs} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0324E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0324E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0324E, buf);
    ::aaaa::dc0324 &lv = *(new (buf) ::aaaa::dc0324());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0324E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0324E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0324E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa6dc0324E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc0324E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa6dc0324E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0324E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0324E(Test__ZN4aaaa6dc0324E, "_ZN4aaaa6dc0324E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc0324E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0324E = {  "_ZN4aaaa6dc0324E", // class name
  bases__ZN4aaaa6dc0324E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0325  : ::aaaa::aa0 , ::aaaa::bb3 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc0325E) C1{ BC2{ FL Fc} BC3{ Fs} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0325E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0325E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc0325E, buf);
    ::aaaa::dc0325 &lv = *(new (buf) ::aaaa::dc0325());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc0325E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0325E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0325E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa6dc0325E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc0325E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa6dc0325E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0325E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0325E(Test__ZN4aaaa6dc0325E, "_ZN4aaaa6dc0325E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc0325E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0325E = {  "_ZN4aaaa6dc0325E", // class name
  bases__ZN4aaaa6dc0325E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0330  : ::aaaa::aa0 , ::aaaa::bb3 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc0330E) C1{ BC2{ FL Fc} BC3{ Fs} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0330E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0330E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa6dc0330E, buf);
    ::aaaa::dc0330 &lv = *(new (buf) ::aaaa::dc0330());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa6dc0330E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0330E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0330E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa6dc0330E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(18,14), "_ZN4aaaa6dc0330E");
    check_field_offset(lv, xc, ABISELECT(20,16), "_ZN4aaaa6dc0330E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0330E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0330E(Test__ZN4aaaa6dc0330E, "_ZN4aaaa6dc0330E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc0330E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(18,14), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0330E = {  "_ZN4aaaa6dc0330E", // class name
  bases__ZN4aaaa6dc0330E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0331  : ::aaaa::aa0 , ::aaaa::bb3 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc0331E) C1{ BC2{ FL Fc} BC3{ Fs} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0331E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0331E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa6dc0331E, buf);
    ::aaaa::dc0331 &lv = *(new (buf) ::aaaa::dc0331());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa6dc0331E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0331E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0331E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa6dc0331E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(18,14), "_ZN4aaaa6dc0331E");
    check_field_offset(lv, xc, ABISELECT(20,16), "_ZN4aaaa6dc0331E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0331E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0331E(Test__ZN4aaaa6dc0331E, "_ZN4aaaa6dc0331E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc0331E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(18,14), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0331E = {  "_ZN4aaaa6dc0331E", // class name
  bases__ZN4aaaa6dc0331E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0332  : ::aaaa::aa0 , ::aaaa::bb3 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc0332E) C1{ BC2{ FL Fc} BC3{ Fs} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0332E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0332E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa6dc0332E, buf);
    ::aaaa::dc0332 &lv = *(new (buf) ::aaaa::dc0332());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa6dc0332E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0332E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0332E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa6dc0332E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(18,14), "_ZN4aaaa6dc0332E");
    check_field_offset(lv, xc, ABISELECT(20,16), "_ZN4aaaa6dc0332E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0332E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0332E(Test__ZN4aaaa6dc0332E, "_ZN4aaaa6dc0332E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc0332E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(18,14), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0332E = {  "_ZN4aaaa6dc0332E", // class name
  bases__ZN4aaaa6dc0332E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0333  : ::aaaa::aa0 , ::aaaa::bb3 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc0333E) C1{ BC2{ FL Fc} BC3{ Fs} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0333E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0333E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa6dc0333E, buf);
    ::aaaa::dc0333 &lv = *(new (buf) ::aaaa::dc0333());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa6dc0333E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0333E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0333E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa6dc0333E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(18,14), "_ZN4aaaa6dc0333E");
    check_field_offset(lv, xc, ABISELECT(20,16), "_ZN4aaaa6dc0333E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0333E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0333E(Test__ZN4aaaa6dc0333E, "_ZN4aaaa6dc0333E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc0333E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(18,14), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0333E = {  "_ZN4aaaa6dc0333E", // class name
  bases__ZN4aaaa6dc0333E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0334  : ::aaaa::aa0 , ::aaaa::bb3 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc0334E) C1{ BC2{ FL Fc} BC3{ Fs} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0334E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0334E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa6dc0334E, buf);
    ::aaaa::dc0334 &lv = *(new (buf) ::aaaa::dc0334());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa6dc0334E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0334E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0334E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa6dc0334E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(18,14), "_ZN4aaaa6dc0334E");
    check_field_offset(lv, xc, ABISELECT(20,16), "_ZN4aaaa6dc0334E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0334E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0334E(Test__ZN4aaaa6dc0334E, "_ZN4aaaa6dc0334E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc0334E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(18,14), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0334E = {  "_ZN4aaaa6dc0334E", // class name
  bases__ZN4aaaa6dc0334E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc0335  : ::aaaa::aa0 , ::aaaa::bb3 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc0335E) C1{ BC2{ FL Fc} BC3{ Fs} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc0335E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc0335E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa6dc0335E, buf);
    ::aaaa::dc0335 &lv = *(new (buf) ::aaaa::dc0335());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa6dc0335E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc0335E)");
    check_base_class_offset(lv, (::aaaa::aa0*), 0, "_ZN4aaaa6dc0335E");
    check_base_class_offset(lv, (::aaaa::bb3*), ABISELECT(16,12), "_ZN4aaaa6dc0335E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(18,14), "_ZN4aaaa6dc0335E");
    check_field_offset(lv, xc, ABISELECT(20,16), "_ZN4aaaa6dc0335E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc0335E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc0335E(Test__ZN4aaaa6dc0335E, "_ZN4aaaa6dc0335E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa0E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc0335E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(18,14), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc0335E = {  "_ZN4aaaa6dc0335E", // class name
  bases__ZN4aaaa6dc0335E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  da10  : ::aaaa::aa1 {
};
//SIG(1 _ZN4aaaa4da10E) C1{ BC2{ Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa4da10E()
{
  extern Class_Descriptor cd__ZN4aaaa4da10E;
  void *lvp;
  {
    char buf[1];
    init_test(&cd__ZN4aaaa4da10E, buf);
    ::aaaa::da10 &lv = *(new (buf) ::aaaa::da10());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(_ZN4aaaa4da10E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa4da10E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa4da10E");
    test_class_info(&lv, &cd__ZN4aaaa4da10E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa4da10E(Test__ZN4aaaa4da10E, "_ZN4aaaa4da10E", 1);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
static Base_Class bases__ZN4aaaa4da10E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa4da10E = {  "_ZN4aaaa4da10E", // class name
  bases__ZN4aaaa4da10E, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  da11  : ::aaaa::aa1 {
  char xc;
};
//SIG(1 _ZN4aaaa4da11E) C1{ BC2{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa4da11E()
{
  extern Class_Descriptor cd__ZN4aaaa4da11E;
  void *lvp;
  {
    char buf[2];
    init_test(&cd__ZN4aaaa4da11E, buf);
    ::aaaa::da11 &lv = *(new (buf) ::aaaa::da11());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4aaaa4da11E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa4da11E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa4da11E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa4da11E.xc");
    test_class_info(&lv, &cd__ZN4aaaa4da11E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa4da11E(Test__ZN4aaaa4da11E, "_ZN4aaaa4da11E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
static Base_Class bases__ZN4aaaa4da11E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa4da11E = {  "_ZN4aaaa4da11E", // class name
  bases__ZN4aaaa4da11E, 1,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  da12  : ::aaaa::aa1 {
  char xc[2];
};
//SIG(1 _ZN4aaaa4da12E) C1{ BC2{ Fc} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa4da12E()
{
  extern Class_Descriptor cd__ZN4aaaa4da12E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa4da12E, buf);
    ::aaaa::da12 &lv = *(new (buf) ::aaaa::da12());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa4da12E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa4da12E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa4da12E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa4da12E.xc");
    test_class_info(&lv, &cd__ZN4aaaa4da12E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa4da12E(Test__ZN4aaaa4da12E, "_ZN4aaaa4da12E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
static Base_Class bases__ZN4aaaa4da12E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa4da12E = {  "_ZN4aaaa4da12E", // class name
  bases__ZN4aaaa4da12E, 1,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  da13  : ::aaaa::aa1 {
  char xc[3];
};
//SIG(1 _ZN4aaaa4da13E) C1{ BC2{ Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa4da13E()
{
  extern Class_Descriptor cd__ZN4aaaa4da13E;
  void *lvp;
  {
    char buf[4];
    init_test(&cd__ZN4aaaa4da13E, buf);
    ::aaaa::da13 &lv = *(new (buf) ::aaaa::da13());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa4da13E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa4da13E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa4da13E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa4da13E.xc");
    test_class_info(&lv, &cd__ZN4aaaa4da13E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa4da13E(Test__ZN4aaaa4da13E, "_ZN4aaaa4da13E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
static Base_Class bases__ZN4aaaa4da13E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa4da13E = {  "_ZN4aaaa4da13E", // class name
  bases__ZN4aaaa4da13E, 1,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  da14  : ::aaaa::aa1 {
  int fi;
};
//SIG(1 _ZN4aaaa4da14E) C1{ BC2{ Fc} Fi}
}
namespace aaaa { 
}
static void Test__ZN4aaaa4da14E()
{
  extern Class_Descriptor cd__ZN4aaaa4da14E;
  void *lvp;
  {
    int buf[3];
    init_test(&cd__ZN4aaaa4da14E, buf);
    ::aaaa::da14 &lv = *(new (buf) ::aaaa::da14());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa4da14E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4aaaa4da14E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa4da14E");
    check_field_offset(lv, fi, 4, "_ZN4aaaa4da14E.fi");
    test_class_info(&lv, &cd__ZN4aaaa4da14E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa4da14E(Test__ZN4aaaa4da14E, "_ZN4aaaa4da14E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
static Base_Class bases__ZN4aaaa4da14E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa4da14E = {  "_ZN4aaaa4da14E", // class name
  bases__ZN4aaaa4da14E, 1,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  da15  : ::aaaa::aa1 {
  __tsi64 lli;
};
//SIG(1 _ZN4aaaa4da15E) C1{ BC2{ Fc} FL}
}
namespace aaaa { 
}
static void Test__ZN4aaaa4da15E()
{
  extern Class_Descriptor cd__ZN4aaaa4da15E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4aaaa4da15E, buf);
    ::aaaa::da15 &lv = *(new (buf) ::aaaa::da15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4aaaa4da15E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa4da15E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa4da15E");
    check_field_offset(lv, lli, ABISELECT(8,4), "_ZN4aaaa4da15E.lli");
    test_class_info(&lv, &cd__ZN4aaaa4da15E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa4da15E(Test__ZN4aaaa4da15E, "_ZN4aaaa4da15E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
static Base_Class bases__ZN4aaaa4da15E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa4da15E = {  "_ZN4aaaa4da15E", // class name
  bases__ZN4aaaa4da15E, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db100  : ::aaaa::aa1 , ::aaaa::bb0 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db100E) C1{ BC2{ Fc} BC3{ FL Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db100E()
{
  extern Class_Descriptor cd__ZN4aaaa5db100E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN4aaaa5db100E, buf);
    ::aaaa::db100 &lv = *(new (buf) ::aaaa::db100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN4aaaa5db100E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db100E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa5db100E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa5db100E");
    check_field_offset(lv, xc, ABISELECT(24,16), "_ZN4aaaa5db100E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db100E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db100E(Test__ZN4aaaa5db100E, "_ZN4aaaa5db100E", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
static Base_Class bases__ZN4aaaa5db100E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db100E = {  "_ZN4aaaa5db100E", // class name
  bases__ZN4aaaa5db100E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db101  : ::aaaa::aa1 , ::aaaa::bb0 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db101E) C1{ BC2{ Fc} BC3{ FL Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db101E()
{
  extern Class_Descriptor cd__ZN4aaaa5db101E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN4aaaa5db101E, buf);
    ::aaaa::db101 &lv = *(new (buf) ::aaaa::db101());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN4aaaa5db101E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db101E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa5db101E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa5db101E");
    check_field_offset(lv, xc, ABISELECT(24,16), "_ZN4aaaa5db101E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db101E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db101E(Test__ZN4aaaa5db101E, "_ZN4aaaa5db101E", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
static Base_Class bases__ZN4aaaa5db101E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db101E = {  "_ZN4aaaa5db101E", // class name
  bases__ZN4aaaa5db101E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db102  : ::aaaa::aa1 , ::aaaa::bb0 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db102E) C1{ BC2{ Fc} BC3{ FL Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db102E()
{
  extern Class_Descriptor cd__ZN4aaaa5db102E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN4aaaa5db102E, buf);
    ::aaaa::db102 &lv = *(new (buf) ::aaaa::db102());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN4aaaa5db102E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db102E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa5db102E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa5db102E");
    check_field_offset(lv, xc, ABISELECT(24,16), "_ZN4aaaa5db102E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db102E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db102E(Test__ZN4aaaa5db102E, "_ZN4aaaa5db102E", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
static Base_Class bases__ZN4aaaa5db102E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db102E = {  "_ZN4aaaa5db102E", // class name
  bases__ZN4aaaa5db102E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db103  : ::aaaa::aa1 , ::aaaa::bb0 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db103E) C1{ BC2{ Fc} BC3{ FL Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db103E()
{
  extern Class_Descriptor cd__ZN4aaaa5db103E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN4aaaa5db103E, buf);
    ::aaaa::db103 &lv = *(new (buf) ::aaaa::db103());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN4aaaa5db103E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db103E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa5db103E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa5db103E");
    check_field_offset(lv, xc, ABISELECT(24,16), "_ZN4aaaa5db103E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db103E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db103E(Test__ZN4aaaa5db103E, "_ZN4aaaa5db103E", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
static Base_Class bases__ZN4aaaa5db103E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db103E = {  "_ZN4aaaa5db103E", // class name
  bases__ZN4aaaa5db103E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db104  : ::aaaa::aa1 , ::aaaa::bb0 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db104E) C1{ BC2{ Fc} BC3{ FL Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db104E()
{
  extern Class_Descriptor cd__ZN4aaaa5db104E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN4aaaa5db104E, buf);
    ::aaaa::db104 &lv = *(new (buf) ::aaaa::db104());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN4aaaa5db104E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db104E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa5db104E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa5db104E");
    check_field_offset(lv, xc, ABISELECT(24,16), "_ZN4aaaa5db104E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db104E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db104E(Test__ZN4aaaa5db104E, "_ZN4aaaa5db104E", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
static Base_Class bases__ZN4aaaa5db104E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db104E = {  "_ZN4aaaa5db104E", // class name
  bases__ZN4aaaa5db104E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db105  : ::aaaa::aa1 , ::aaaa::bb0 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db105E) C1{ BC2{ Fc} BC3{ FL Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db105E()
{
  extern Class_Descriptor cd__ZN4aaaa5db105E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN4aaaa5db105E, buf);
    ::aaaa::db105 &lv = *(new (buf) ::aaaa::db105());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN4aaaa5db105E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db105E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa5db105E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa5db105E");
    check_field_offset(lv, xc, ABISELECT(24,16), "_ZN4aaaa5db105E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db105E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db105E(Test__ZN4aaaa5db105E, "_ZN4aaaa5db105E", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
static Base_Class bases__ZN4aaaa5db105E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db105E = {  "_ZN4aaaa5db105E", // class name
  bases__ZN4aaaa5db105E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1000  : ::aaaa::aa1 , ::aaaa::bb0 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc1000E) C1{ BC2{ Fc} BC3{ FL Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1000E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1000E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc1000E, buf);
    ::aaaa::dc1000 &lv = *(new (buf) ::aaaa::dc1000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc1000E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1000E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1000E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa6dc1000E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(24,16), "_ZN4aaaa6dc1000E");
    test_class_info(&lv, &cd__ZN4aaaa6dc1000E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1000E(Test__ZN4aaaa6dc1000E, "_ZN4aaaa6dc1000E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc1000E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1000E = {  "_ZN4aaaa6dc1000E", // class name
  bases__ZN4aaaa6dc1000E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1001  : ::aaaa::aa1 , ::aaaa::bb0 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc1001E) C1{ BC2{ Fc} BC3{ FL Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1001E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1001E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc1001E, buf);
    ::aaaa::dc1001 &lv = *(new (buf) ::aaaa::dc1001());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc1001E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1001E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1001E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa6dc1001E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(24,16), "_ZN4aaaa6dc1001E");
    test_class_info(&lv, &cd__ZN4aaaa6dc1001E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1001E(Test__ZN4aaaa6dc1001E, "_ZN4aaaa6dc1001E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc1001E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1001E = {  "_ZN4aaaa6dc1001E", // class name
  bases__ZN4aaaa6dc1001E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1002  : ::aaaa::aa1 , ::aaaa::bb0 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc1002E) C1{ BC2{ Fc} BC3{ FL Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1002E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1002E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc1002E, buf);
    ::aaaa::dc1002 &lv = *(new (buf) ::aaaa::dc1002());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc1002E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1002E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1002E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa6dc1002E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(24,16), "_ZN4aaaa6dc1002E");
    test_class_info(&lv, &cd__ZN4aaaa6dc1002E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1002E(Test__ZN4aaaa6dc1002E, "_ZN4aaaa6dc1002E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc1002E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1002E = {  "_ZN4aaaa6dc1002E", // class name
  bases__ZN4aaaa6dc1002E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1003  : ::aaaa::aa1 , ::aaaa::bb0 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc1003E) C1{ BC2{ Fc} BC3{ FL Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1003E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1003E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc1003E, buf);
    ::aaaa::dc1003 &lv = *(new (buf) ::aaaa::dc1003());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc1003E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1003E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1003E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa6dc1003E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(24,16), "_ZN4aaaa6dc1003E");
    test_class_info(&lv, &cd__ZN4aaaa6dc1003E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1003E(Test__ZN4aaaa6dc1003E, "_ZN4aaaa6dc1003E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc1003E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1003E = {  "_ZN4aaaa6dc1003E", // class name
  bases__ZN4aaaa6dc1003E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1004  : ::aaaa::aa1 , ::aaaa::bb0 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc1004E) C1{ BC2{ Fc} BC3{ FL Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1004E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1004E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc1004E, buf);
    ::aaaa::dc1004 &lv = *(new (buf) ::aaaa::dc1004());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc1004E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1004E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1004E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa6dc1004E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(24,16), "_ZN4aaaa6dc1004E");
    test_class_info(&lv, &cd__ZN4aaaa6dc1004E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1004E(Test__ZN4aaaa6dc1004E, "_ZN4aaaa6dc1004E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc1004E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1004E = {  "_ZN4aaaa6dc1004E", // class name
  bases__ZN4aaaa6dc1004E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1005  : ::aaaa::aa1 , ::aaaa::bb0 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc1005E) C1{ BC2{ Fc} BC3{ FL Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1005E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1005E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd__ZN4aaaa6dc1005E, buf);
    ::aaaa::dc1005 &lv = *(new (buf) ::aaaa::dc1005());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(_ZN4aaaa6dc1005E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1005E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1005E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa6dc1005E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(24,16), "_ZN4aaaa6dc1005E");
    test_class_info(&lv, &cd__ZN4aaaa6dc1005E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1005E(Test__ZN4aaaa6dc1005E, "_ZN4aaaa6dc1005E", ABISELECT(40,28));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc1005E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1005E = {  "_ZN4aaaa6dc1005E", // class name
  bases__ZN4aaaa6dc1005E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(40,28), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1010  : ::aaaa::aa1 , ::aaaa::bb0 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc1010E) C1{ BC2{ Fc} BC3{ FL Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1010E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1010E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN4aaaa6dc1010E, buf);
    ::aaaa::dc1010 &lv = *(new (buf) ::aaaa::dc1010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN4aaaa6dc1010E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1010E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1010E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa6dc1010E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(24,16), "_ZN4aaaa6dc1010E");
    check_field_offset(lv, xc, ABISELECT(25,17), "_ZN4aaaa6dc1010E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1010E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1010E(Test__ZN4aaaa6dc1010E, "_ZN4aaaa6dc1010E", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc1010E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1010E = {  "_ZN4aaaa6dc1010E", // class name
  bases__ZN4aaaa6dc1010E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1011  : ::aaaa::aa1 , ::aaaa::bb0 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc1011E) C1{ BC2{ Fc} BC3{ FL Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1011E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1011E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN4aaaa6dc1011E, buf);
    ::aaaa::dc1011 &lv = *(new (buf) ::aaaa::dc1011());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN4aaaa6dc1011E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1011E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1011E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa6dc1011E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(24,16), "_ZN4aaaa6dc1011E");
    check_field_offset(lv, xc, ABISELECT(25,17), "_ZN4aaaa6dc1011E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1011E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1011E(Test__ZN4aaaa6dc1011E, "_ZN4aaaa6dc1011E", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc1011E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1011E = {  "_ZN4aaaa6dc1011E", // class name
  bases__ZN4aaaa6dc1011E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1012  : ::aaaa::aa1 , ::aaaa::bb0 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc1012E) C1{ BC2{ Fc} BC3{ FL Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1012E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1012E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN4aaaa6dc1012E, buf);
    ::aaaa::dc1012 &lv = *(new (buf) ::aaaa::dc1012());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN4aaaa6dc1012E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1012E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1012E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa6dc1012E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(24,16), "_ZN4aaaa6dc1012E");
    check_field_offset(lv, xc, ABISELECT(25,17), "_ZN4aaaa6dc1012E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1012E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1012E(Test__ZN4aaaa6dc1012E, "_ZN4aaaa6dc1012E", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc1012E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1012E = {  "_ZN4aaaa6dc1012E", // class name
  bases__ZN4aaaa6dc1012E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1013  : ::aaaa::aa1 , ::aaaa::bb0 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc1013E) C1{ BC2{ Fc} BC3{ FL Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1013E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1013E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN4aaaa6dc1013E, buf);
    ::aaaa::dc1013 &lv = *(new (buf) ::aaaa::dc1013());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN4aaaa6dc1013E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1013E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1013E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa6dc1013E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(24,16), "_ZN4aaaa6dc1013E");
    check_field_offset(lv, xc, ABISELECT(25,17), "_ZN4aaaa6dc1013E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1013E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1013E(Test__ZN4aaaa6dc1013E, "_ZN4aaaa6dc1013E", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc1013E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1013E = {  "_ZN4aaaa6dc1013E", // class name
  bases__ZN4aaaa6dc1013E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1014  : ::aaaa::aa1 , ::aaaa::bb0 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc1014E) C1{ BC2{ Fc} BC3{ FL Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1014E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1014E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN4aaaa6dc1014E, buf);
    ::aaaa::dc1014 &lv = *(new (buf) ::aaaa::dc1014());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN4aaaa6dc1014E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1014E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1014E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa6dc1014E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(24,16), "_ZN4aaaa6dc1014E");
    check_field_offset(lv, xc, ABISELECT(25,17), "_ZN4aaaa6dc1014E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1014E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1014E(Test__ZN4aaaa6dc1014E, "_ZN4aaaa6dc1014E", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc1014E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1014E = {  "_ZN4aaaa6dc1014E", // class name
  bases__ZN4aaaa6dc1014E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1015  : ::aaaa::aa1 , ::aaaa::bb0 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc1015E) C1{ BC2{ Fc} BC3{ FL Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1015E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1015E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN4aaaa6dc1015E, buf);
    ::aaaa::dc1015 &lv = *(new (buf) ::aaaa::dc1015());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN4aaaa6dc1015E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1015E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1015E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa6dc1015E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(24,16), "_ZN4aaaa6dc1015E");
    check_field_offset(lv, xc, ABISELECT(25,17), "_ZN4aaaa6dc1015E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1015E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1015E(Test__ZN4aaaa6dc1015E, "_ZN4aaaa6dc1015E", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc1015E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1015E = {  "_ZN4aaaa6dc1015E", // class name
  bases__ZN4aaaa6dc1015E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1020  : ::aaaa::aa1 , ::aaaa::bb0 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc1020E) C1{ BC2{ Fc} BC3{ FL Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1020E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1020E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN4aaaa6dc1020E, buf);
    ::aaaa::dc1020 &lv = *(new (buf) ::aaaa::dc1020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN4aaaa6dc1020E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1020E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1020E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa6dc1020E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc1020E");
    check_field_offset(lv, xc, ABISELECT(24,16), "_ZN4aaaa6dc1020E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1020E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1020E(Test__ZN4aaaa6dc1020E, "_ZN4aaaa6dc1020E", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc1020E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1020E = {  "_ZN4aaaa6dc1020E", // class name
  bases__ZN4aaaa6dc1020E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1021  : ::aaaa::aa1 , ::aaaa::bb0 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc1021E) C1{ BC2{ Fc} BC3{ FL Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1021E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1021E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN4aaaa6dc1021E, buf);
    ::aaaa::dc1021 &lv = *(new (buf) ::aaaa::dc1021());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN4aaaa6dc1021E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1021E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1021E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa6dc1021E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc1021E");
    check_field_offset(lv, xc, ABISELECT(24,16), "_ZN4aaaa6dc1021E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1021E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1021E(Test__ZN4aaaa6dc1021E, "_ZN4aaaa6dc1021E", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc1021E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1021E = {  "_ZN4aaaa6dc1021E", // class name
  bases__ZN4aaaa6dc1021E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1022  : ::aaaa::aa1 , ::aaaa::bb0 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc1022E) C1{ BC2{ Fc} BC3{ FL Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1022E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1022E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN4aaaa6dc1022E, buf);
    ::aaaa::dc1022 &lv = *(new (buf) ::aaaa::dc1022());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN4aaaa6dc1022E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1022E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1022E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa6dc1022E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc1022E");
    check_field_offset(lv, xc, ABISELECT(24,16), "_ZN4aaaa6dc1022E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1022E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1022E(Test__ZN4aaaa6dc1022E, "_ZN4aaaa6dc1022E", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc1022E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1022E = {  "_ZN4aaaa6dc1022E", // class name
  bases__ZN4aaaa6dc1022E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1023  : ::aaaa::aa1 , ::aaaa::bb0 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc1023E) C1{ BC2{ Fc} BC3{ FL Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1023E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1023E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN4aaaa6dc1023E, buf);
    ::aaaa::dc1023 &lv = *(new (buf) ::aaaa::dc1023());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN4aaaa6dc1023E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1023E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1023E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa6dc1023E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc1023E");
    check_field_offset(lv, xc, ABISELECT(24,16), "_ZN4aaaa6dc1023E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1023E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1023E(Test__ZN4aaaa6dc1023E, "_ZN4aaaa6dc1023E", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc1023E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1023E = {  "_ZN4aaaa6dc1023E", // class name
  bases__ZN4aaaa6dc1023E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1024  : ::aaaa::aa1 , ::aaaa::bb0 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc1024E) C1{ BC2{ Fc} BC3{ FL Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1024E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1024E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN4aaaa6dc1024E, buf);
    ::aaaa::dc1024 &lv = *(new (buf) ::aaaa::dc1024());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN4aaaa6dc1024E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1024E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1024E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa6dc1024E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc1024E");
    check_field_offset(lv, xc, ABISELECT(24,16), "_ZN4aaaa6dc1024E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1024E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1024E(Test__ZN4aaaa6dc1024E, "_ZN4aaaa6dc1024E", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc1024E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1024E = {  "_ZN4aaaa6dc1024E", // class name
  bases__ZN4aaaa6dc1024E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1025  : ::aaaa::aa1 , ::aaaa::bb0 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc1025E) C1{ BC2{ Fc} BC3{ FL Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1025E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1025E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd__ZN4aaaa6dc1025E, buf);
    ::aaaa::dc1025 &lv = *(new (buf) ::aaaa::dc1025());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(_ZN4aaaa6dc1025E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1025E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1025E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa6dc1025E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc1025E");
    check_field_offset(lv, xc, ABISELECT(24,16), "_ZN4aaaa6dc1025E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1025E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1025E(Test__ZN4aaaa6dc1025E, "_ZN4aaaa6dc1025E", ABISELECT(32,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc1025E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1025E = {  "_ZN4aaaa6dc1025E", // class name
  bases__ZN4aaaa6dc1025E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1030  : ::aaaa::aa1 , ::aaaa::bb0 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc1030E) C1{ BC2{ Fc} BC3{ FL Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1030E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1030E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4aaaa6dc1030E, buf);
    ::aaaa::dc1030 &lv = *(new (buf) ::aaaa::dc1030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4aaaa6dc1030E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1030E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1030E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa6dc1030E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(24,16), "_ZN4aaaa6dc1030E");
    check_field_offset(lv, xc, ABISELECT(26,18), "_ZN4aaaa6dc1030E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1030E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1030E(Test__ZN4aaaa6dc1030E, "_ZN4aaaa6dc1030E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc1030E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1030E = {  "_ZN4aaaa6dc1030E", // class name
  bases__ZN4aaaa6dc1030E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1031  : ::aaaa::aa1 , ::aaaa::bb0 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc1031E) C1{ BC2{ Fc} BC3{ FL Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1031E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1031E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4aaaa6dc1031E, buf);
    ::aaaa::dc1031 &lv = *(new (buf) ::aaaa::dc1031());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4aaaa6dc1031E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1031E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1031E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa6dc1031E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(24,16), "_ZN4aaaa6dc1031E");
    check_field_offset(lv, xc, ABISELECT(26,18), "_ZN4aaaa6dc1031E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1031E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1031E(Test__ZN4aaaa6dc1031E, "_ZN4aaaa6dc1031E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc1031E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1031E = {  "_ZN4aaaa6dc1031E", // class name
  bases__ZN4aaaa6dc1031E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1032  : ::aaaa::aa1 , ::aaaa::bb0 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc1032E) C1{ BC2{ Fc} BC3{ FL Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1032E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1032E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4aaaa6dc1032E, buf);
    ::aaaa::dc1032 &lv = *(new (buf) ::aaaa::dc1032());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4aaaa6dc1032E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1032E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1032E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa6dc1032E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(24,16), "_ZN4aaaa6dc1032E");
    check_field_offset(lv, xc, ABISELECT(26,18), "_ZN4aaaa6dc1032E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1032E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1032E(Test__ZN4aaaa6dc1032E, "_ZN4aaaa6dc1032E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc1032E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1032E = {  "_ZN4aaaa6dc1032E", // class name
  bases__ZN4aaaa6dc1032E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1033  : ::aaaa::aa1 , ::aaaa::bb0 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc1033E) C1{ BC2{ Fc} BC3{ FL Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1033E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1033E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4aaaa6dc1033E, buf);
    ::aaaa::dc1033 &lv = *(new (buf) ::aaaa::dc1033());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4aaaa6dc1033E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1033E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1033E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa6dc1033E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(24,16), "_ZN4aaaa6dc1033E");
    check_field_offset(lv, xc, ABISELECT(26,18), "_ZN4aaaa6dc1033E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1033E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1033E(Test__ZN4aaaa6dc1033E, "_ZN4aaaa6dc1033E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc1033E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1033E = {  "_ZN4aaaa6dc1033E", // class name
  bases__ZN4aaaa6dc1033E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1034  : ::aaaa::aa1 , ::aaaa::bb0 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc1034E) C1{ BC2{ Fc} BC3{ FL Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1034E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1034E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4aaaa6dc1034E, buf);
    ::aaaa::dc1034 &lv = *(new (buf) ::aaaa::dc1034());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4aaaa6dc1034E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1034E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1034E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa6dc1034E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(24,16), "_ZN4aaaa6dc1034E");
    check_field_offset(lv, xc, ABISELECT(26,18), "_ZN4aaaa6dc1034E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1034E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1034E(Test__ZN4aaaa6dc1034E, "_ZN4aaaa6dc1034E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc1034E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1034E = {  "_ZN4aaaa6dc1034E", // class name
  bases__ZN4aaaa6dc1034E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1035  : ::aaaa::aa1 , ::aaaa::bb0 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc1035E) C1{ BC2{ Fc} BC3{ FL Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1035E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1035E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4aaaa6dc1035E, buf);
    ::aaaa::dc1035 &lv = *(new (buf) ::aaaa::dc1035());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4aaaa6dc1035E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1035E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1035E");
    check_base_class_offset(lv, (::aaaa::bb0*), ABISELECT(8,4), "_ZN4aaaa6dc1035E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(24,16), "_ZN4aaaa6dc1035E");
    check_field_offset(lv, xc, ABISELECT(26,18), "_ZN4aaaa6dc1035E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1035E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1035E(Test__ZN4aaaa6dc1035E, "_ZN4aaaa6dc1035E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc1035E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1035E = {  "_ZN4aaaa6dc1035E", // class name
  bases__ZN4aaaa6dc1035E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db110  : ::aaaa::aa1 , ::aaaa::bb1 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db110E) C1{ BC2{ Fc} BC3{ Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db110E()
{
  extern Class_Descriptor cd__ZN4aaaa5db110E;
  void *lvp;
  {
    char buf[5];
    init_test(&cd__ZN4aaaa5db110E, buf);
    ::aaaa::db110 &lv = *(new (buf) ::aaaa::db110());
    lvp = (void*)&lv;
    check2(sizeof(lv), 5, "sizeof(_ZN4aaaa5db110E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa5db110E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa5db110E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa5db110E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa5db110E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db110E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db110E(Test__ZN4aaaa5db110E, "_ZN4aaaa5db110E", 5);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
static Base_Class bases__ZN4aaaa5db110E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db110E = {  "_ZN4aaaa5db110E", // class name
  bases__ZN4aaaa5db110E, 2,
  0, // no vftv
  0, //no vtt
  5, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db111  : ::aaaa::aa1 , ::aaaa::bb1 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db111E) C1{ BC2{ Fc} BC3{ Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db111E()
{
  extern Class_Descriptor cd__ZN4aaaa5db111E;
  void *lvp;
  {
    char buf[5];
    init_test(&cd__ZN4aaaa5db111E, buf);
    ::aaaa::db111 &lv = *(new (buf) ::aaaa::db111());
    lvp = (void*)&lv;
    check2(sizeof(lv), 5, "sizeof(_ZN4aaaa5db111E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa5db111E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa5db111E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa5db111E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa5db111E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db111E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db111E(Test__ZN4aaaa5db111E, "_ZN4aaaa5db111E", 5);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
static Base_Class bases__ZN4aaaa5db111E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db111E = {  "_ZN4aaaa5db111E", // class name
  bases__ZN4aaaa5db111E, 2,
  0, // no vftv
  0, //no vtt
  5, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db112  : ::aaaa::aa1 , ::aaaa::bb1 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db112E) C1{ BC2{ Fc} BC3{ Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db112E()
{
  extern Class_Descriptor cd__ZN4aaaa5db112E;
  void *lvp;
  {
    char buf[5];
    init_test(&cd__ZN4aaaa5db112E, buf);
    ::aaaa::db112 &lv = *(new (buf) ::aaaa::db112());
    lvp = (void*)&lv;
    check2(sizeof(lv), 5, "sizeof(_ZN4aaaa5db112E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa5db112E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa5db112E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa5db112E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa5db112E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db112E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db112E(Test__ZN4aaaa5db112E, "_ZN4aaaa5db112E", 5);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
static Base_Class bases__ZN4aaaa5db112E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db112E = {  "_ZN4aaaa5db112E", // class name
  bases__ZN4aaaa5db112E, 2,
  0, // no vftv
  0, //no vtt
  5, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db113  : ::aaaa::aa1 , ::aaaa::bb1 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db113E) C1{ BC2{ Fc} BC3{ Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db113E()
{
  extern Class_Descriptor cd__ZN4aaaa5db113E;
  void *lvp;
  {
    char buf[5];
    init_test(&cd__ZN4aaaa5db113E, buf);
    ::aaaa::db113 &lv = *(new (buf) ::aaaa::db113());
    lvp = (void*)&lv;
    check2(sizeof(lv), 5, "sizeof(_ZN4aaaa5db113E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa5db113E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa5db113E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa5db113E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa5db113E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db113E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db113E(Test__ZN4aaaa5db113E, "_ZN4aaaa5db113E", 5);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
static Base_Class bases__ZN4aaaa5db113E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db113E = {  "_ZN4aaaa5db113E", // class name
  bases__ZN4aaaa5db113E, 2,
  0, // no vftv
  0, //no vtt
  5, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db114  : ::aaaa::aa1 , ::aaaa::bb1 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db114E) C1{ BC2{ Fc} BC3{ Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db114E()
{
  extern Class_Descriptor cd__ZN4aaaa5db114E;
  void *lvp;
  {
    char buf[5];
    init_test(&cd__ZN4aaaa5db114E, buf);
    ::aaaa::db114 &lv = *(new (buf) ::aaaa::db114());
    lvp = (void*)&lv;
    check2(sizeof(lv), 5, "sizeof(_ZN4aaaa5db114E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa5db114E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa5db114E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa5db114E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa5db114E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db114E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db114E(Test__ZN4aaaa5db114E, "_ZN4aaaa5db114E", 5);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
static Base_Class bases__ZN4aaaa5db114E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db114E = {  "_ZN4aaaa5db114E", // class name
  bases__ZN4aaaa5db114E, 2,
  0, // no vftv
  0, //no vtt
  5, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db115  : ::aaaa::aa1 , ::aaaa::bb1 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db115E) C1{ BC2{ Fc} BC3{ Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db115E()
{
  extern Class_Descriptor cd__ZN4aaaa5db115E;
  void *lvp;
  {
    char buf[5];
    init_test(&cd__ZN4aaaa5db115E, buf);
    ::aaaa::db115 &lv = *(new (buf) ::aaaa::db115());
    lvp = (void*)&lv;
    check2(sizeof(lv), 5, "sizeof(_ZN4aaaa5db115E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa5db115E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa5db115E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa5db115E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa5db115E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db115E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db115E(Test__ZN4aaaa5db115E, "_ZN4aaaa5db115E", 5);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
static Base_Class bases__ZN4aaaa5db115E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db115E = {  "_ZN4aaaa5db115E", // class name
  bases__ZN4aaaa5db115E, 2,
  0, // no vftv
  0, //no vtt
  5, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1100  : ::aaaa::aa1 , ::aaaa::bb1 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc1100E) C1{ BC2{ Fc} BC3{ Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1100E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1100E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc1100E, buf);
    ::aaaa::dc1100 &lv = *(new (buf) ::aaaa::dc1100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc1100E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1100E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1100E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa6dc1100E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc1100E");
    test_class_info(&lv, &cd__ZN4aaaa6dc1100E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1100E(Test__ZN4aaaa6dc1100E, "_ZN4aaaa6dc1100E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc1100E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1100E = {  "_ZN4aaaa6dc1100E", // class name
  bases__ZN4aaaa6dc1100E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1101  : ::aaaa::aa1 , ::aaaa::bb1 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc1101E) C1{ BC2{ Fc} BC3{ Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1101E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1101E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc1101E, buf);
    ::aaaa::dc1101 &lv = *(new (buf) ::aaaa::dc1101());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc1101E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1101E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1101E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa6dc1101E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc1101E");
    test_class_info(&lv, &cd__ZN4aaaa6dc1101E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1101E(Test__ZN4aaaa6dc1101E, "_ZN4aaaa6dc1101E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc1101E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1101E = {  "_ZN4aaaa6dc1101E", // class name
  bases__ZN4aaaa6dc1101E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1102  : ::aaaa::aa1 , ::aaaa::bb1 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc1102E) C1{ BC2{ Fc} BC3{ Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1102E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1102E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc1102E, buf);
    ::aaaa::dc1102 &lv = *(new (buf) ::aaaa::dc1102());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc1102E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1102E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1102E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa6dc1102E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc1102E");
    test_class_info(&lv, &cd__ZN4aaaa6dc1102E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1102E(Test__ZN4aaaa6dc1102E, "_ZN4aaaa6dc1102E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc1102E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1102E = {  "_ZN4aaaa6dc1102E", // class name
  bases__ZN4aaaa6dc1102E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1103  : ::aaaa::aa1 , ::aaaa::bb1 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc1103E) C1{ BC2{ Fc} BC3{ Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1103E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1103E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc1103E, buf);
    ::aaaa::dc1103 &lv = *(new (buf) ::aaaa::dc1103());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc1103E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1103E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1103E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa6dc1103E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc1103E");
    test_class_info(&lv, &cd__ZN4aaaa6dc1103E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1103E(Test__ZN4aaaa6dc1103E, "_ZN4aaaa6dc1103E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc1103E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1103E = {  "_ZN4aaaa6dc1103E", // class name
  bases__ZN4aaaa6dc1103E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1104  : ::aaaa::aa1 , ::aaaa::bb1 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc1104E) C1{ BC2{ Fc} BC3{ Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1104E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1104E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc1104E, buf);
    ::aaaa::dc1104 &lv = *(new (buf) ::aaaa::dc1104());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc1104E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1104E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1104E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa6dc1104E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc1104E");
    test_class_info(&lv, &cd__ZN4aaaa6dc1104E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1104E(Test__ZN4aaaa6dc1104E, "_ZN4aaaa6dc1104E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc1104E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1104E = {  "_ZN4aaaa6dc1104E", // class name
  bases__ZN4aaaa6dc1104E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1105  : ::aaaa::aa1 , ::aaaa::bb1 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc1105E) C1{ BC2{ Fc} BC3{ Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1105E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1105E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc1105E, buf);
    ::aaaa::dc1105 &lv = *(new (buf) ::aaaa::dc1105());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc1105E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1105E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1105E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa6dc1105E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc1105E");
    test_class_info(&lv, &cd__ZN4aaaa6dc1105E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1105E(Test__ZN4aaaa6dc1105E, "_ZN4aaaa6dc1105E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc1105E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1105E = {  "_ZN4aaaa6dc1105E", // class name
  bases__ZN4aaaa6dc1105E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1110  : ::aaaa::aa1 , ::aaaa::bb1 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc1110E) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1110E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1110E;
  void *lvp;
  {
    char buf[4];
    init_test(&cd__ZN4aaaa6dc1110E, buf);
    ::aaaa::dc1110 &lv = *(new (buf) ::aaaa::dc1110());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa6dc1110E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc1110E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1110E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa6dc1110E");
    check_base_class_offset(lv, (::aaaa::cc1*), 2, "_ZN4aaaa6dc1110E");
    check_field_offset(lv, xc, 3, "_ZN4aaaa6dc1110E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1110E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1110E(Test__ZN4aaaa6dc1110E, "_ZN4aaaa6dc1110E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc1110E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1110E = {  "_ZN4aaaa6dc1110E", // class name
  bases__ZN4aaaa6dc1110E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1111  : ::aaaa::aa1 , ::aaaa::bb1 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc1111E) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1111E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1111E;
  void *lvp;
  {
    char buf[4];
    init_test(&cd__ZN4aaaa6dc1111E, buf);
    ::aaaa::dc1111 &lv = *(new (buf) ::aaaa::dc1111());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa6dc1111E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc1111E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1111E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa6dc1111E");
    check_base_class_offset(lv, (::aaaa::cc1*), 2, "_ZN4aaaa6dc1111E");
    check_field_offset(lv, xc, 3, "_ZN4aaaa6dc1111E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1111E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1111E(Test__ZN4aaaa6dc1111E, "_ZN4aaaa6dc1111E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc1111E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1111E = {  "_ZN4aaaa6dc1111E", // class name
  bases__ZN4aaaa6dc1111E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1112  : ::aaaa::aa1 , ::aaaa::bb1 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc1112E) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1112E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1112E;
  void *lvp;
  {
    char buf[4];
    init_test(&cd__ZN4aaaa6dc1112E, buf);
    ::aaaa::dc1112 &lv = *(new (buf) ::aaaa::dc1112());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa6dc1112E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc1112E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1112E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa6dc1112E");
    check_base_class_offset(lv, (::aaaa::cc1*), 2, "_ZN4aaaa6dc1112E");
    check_field_offset(lv, xc, 3, "_ZN4aaaa6dc1112E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1112E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1112E(Test__ZN4aaaa6dc1112E, "_ZN4aaaa6dc1112E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc1112E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1112E = {  "_ZN4aaaa6dc1112E", // class name
  bases__ZN4aaaa6dc1112E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1113  : ::aaaa::aa1 , ::aaaa::bb1 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc1113E) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1113E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1113E;
  void *lvp;
  {
    char buf[4];
    init_test(&cd__ZN4aaaa6dc1113E, buf);
    ::aaaa::dc1113 &lv = *(new (buf) ::aaaa::dc1113());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa6dc1113E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc1113E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1113E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa6dc1113E");
    check_base_class_offset(lv, (::aaaa::cc1*), 2, "_ZN4aaaa6dc1113E");
    check_field_offset(lv, xc, 3, "_ZN4aaaa6dc1113E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1113E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1113E(Test__ZN4aaaa6dc1113E, "_ZN4aaaa6dc1113E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc1113E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1113E = {  "_ZN4aaaa6dc1113E", // class name
  bases__ZN4aaaa6dc1113E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1114  : ::aaaa::aa1 , ::aaaa::bb1 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc1114E) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1114E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1114E;
  void *lvp;
  {
    char buf[4];
    init_test(&cd__ZN4aaaa6dc1114E, buf);
    ::aaaa::dc1114 &lv = *(new (buf) ::aaaa::dc1114());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa6dc1114E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc1114E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1114E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa6dc1114E");
    check_base_class_offset(lv, (::aaaa::cc1*), 2, "_ZN4aaaa6dc1114E");
    check_field_offset(lv, xc, 3, "_ZN4aaaa6dc1114E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1114E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1114E(Test__ZN4aaaa6dc1114E, "_ZN4aaaa6dc1114E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc1114E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1114E = {  "_ZN4aaaa6dc1114E", // class name
  bases__ZN4aaaa6dc1114E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1115  : ::aaaa::aa1 , ::aaaa::bb1 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc1115E) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1115E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1115E;
  void *lvp;
  {
    char buf[4];
    init_test(&cd__ZN4aaaa6dc1115E, buf);
    ::aaaa::dc1115 &lv = *(new (buf) ::aaaa::dc1115());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa6dc1115E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc1115E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1115E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa6dc1115E");
    check_base_class_offset(lv, (::aaaa::cc1*), 2, "_ZN4aaaa6dc1115E");
    check_field_offset(lv, xc, 3, "_ZN4aaaa6dc1115E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1115E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1115E(Test__ZN4aaaa6dc1115E, "_ZN4aaaa6dc1115E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc1115E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1115E = {  "_ZN4aaaa6dc1115E", // class name
  bases__ZN4aaaa6dc1115E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1120  : ::aaaa::aa1 , ::aaaa::bb1 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc1120E) C1{ BC2{ Fc} BC3{ Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1120E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1120E;
  void *lvp;
  {
    char buf[4];
    init_test(&cd__ZN4aaaa6dc1120E, buf);
    ::aaaa::dc1120 &lv = *(new (buf) ::aaaa::dc1120());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa6dc1120E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc1120E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1120E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa6dc1120E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc1120E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc1120E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1120E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1120E(Test__ZN4aaaa6dc1120E, "_ZN4aaaa6dc1120E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc1120E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1120E = {  "_ZN4aaaa6dc1120E", // class name
  bases__ZN4aaaa6dc1120E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1121  : ::aaaa::aa1 , ::aaaa::bb1 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc1121E) C1{ BC2{ Fc} BC3{ Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1121E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1121E;
  void *lvp;
  {
    char buf[4];
    init_test(&cd__ZN4aaaa6dc1121E, buf);
    ::aaaa::dc1121 &lv = *(new (buf) ::aaaa::dc1121());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa6dc1121E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc1121E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1121E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa6dc1121E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc1121E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc1121E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1121E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1121E(Test__ZN4aaaa6dc1121E, "_ZN4aaaa6dc1121E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc1121E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1121E = {  "_ZN4aaaa6dc1121E", // class name
  bases__ZN4aaaa6dc1121E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1122  : ::aaaa::aa1 , ::aaaa::bb1 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc1122E) C1{ BC2{ Fc} BC3{ Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1122E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1122E;
  void *lvp;
  {
    char buf[4];
    init_test(&cd__ZN4aaaa6dc1122E, buf);
    ::aaaa::dc1122 &lv = *(new (buf) ::aaaa::dc1122());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa6dc1122E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc1122E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1122E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa6dc1122E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc1122E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc1122E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1122E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1122E(Test__ZN4aaaa6dc1122E, "_ZN4aaaa6dc1122E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc1122E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1122E = {  "_ZN4aaaa6dc1122E", // class name
  bases__ZN4aaaa6dc1122E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1123  : ::aaaa::aa1 , ::aaaa::bb1 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc1123E) C1{ BC2{ Fc} BC3{ Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1123E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1123E;
  void *lvp;
  {
    char buf[4];
    init_test(&cd__ZN4aaaa6dc1123E, buf);
    ::aaaa::dc1123 &lv = *(new (buf) ::aaaa::dc1123());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa6dc1123E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc1123E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1123E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa6dc1123E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc1123E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc1123E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1123E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1123E(Test__ZN4aaaa6dc1123E, "_ZN4aaaa6dc1123E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc1123E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1123E = {  "_ZN4aaaa6dc1123E", // class name
  bases__ZN4aaaa6dc1123E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1124  : ::aaaa::aa1 , ::aaaa::bb1 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc1124E) C1{ BC2{ Fc} BC3{ Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1124E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1124E;
  void *lvp;
  {
    char buf[4];
    init_test(&cd__ZN4aaaa6dc1124E, buf);
    ::aaaa::dc1124 &lv = *(new (buf) ::aaaa::dc1124());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa6dc1124E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc1124E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1124E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa6dc1124E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc1124E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc1124E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1124E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1124E(Test__ZN4aaaa6dc1124E, "_ZN4aaaa6dc1124E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc1124E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1124E = {  "_ZN4aaaa6dc1124E", // class name
  bases__ZN4aaaa6dc1124E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1125  : ::aaaa::aa1 , ::aaaa::bb1 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc1125E) C1{ BC2{ Fc} BC3{ Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1125E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1125E;
  void *lvp;
  {
    char buf[4];
    init_test(&cd__ZN4aaaa6dc1125E, buf);
    ::aaaa::dc1125 &lv = *(new (buf) ::aaaa::dc1125());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa6dc1125E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc1125E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1125E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa6dc1125E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc1125E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc1125E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1125E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1125E(Test__ZN4aaaa6dc1125E, "_ZN4aaaa6dc1125E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc1125E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1125E = {  "_ZN4aaaa6dc1125E", // class name
  bases__ZN4aaaa6dc1125E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1130  : ::aaaa::aa1 , ::aaaa::bb1 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc1130E) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1130E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1130E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa6dc1130E, buf);
    ::aaaa::dc1130 &lv = *(new (buf) ::aaaa::dc1130());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa6dc1130E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1130E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1130E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa6dc1130E");
    check_base_class_offset(lv, (::aaaa::cc3*), 2, "_ZN4aaaa6dc1130E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc1130E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1130E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1130E(Test__ZN4aaaa6dc1130E, "_ZN4aaaa6dc1130E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc1130E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1130E = {  "_ZN4aaaa6dc1130E", // class name
  bases__ZN4aaaa6dc1130E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1131  : ::aaaa::aa1 , ::aaaa::bb1 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc1131E) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1131E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1131E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa6dc1131E, buf);
    ::aaaa::dc1131 &lv = *(new (buf) ::aaaa::dc1131());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa6dc1131E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1131E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1131E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa6dc1131E");
    check_base_class_offset(lv, (::aaaa::cc3*), 2, "_ZN4aaaa6dc1131E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc1131E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1131E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1131E(Test__ZN4aaaa6dc1131E, "_ZN4aaaa6dc1131E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc1131E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1131E = {  "_ZN4aaaa6dc1131E", // class name
  bases__ZN4aaaa6dc1131E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1132  : ::aaaa::aa1 , ::aaaa::bb1 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc1132E) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1132E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1132E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa6dc1132E, buf);
    ::aaaa::dc1132 &lv = *(new (buf) ::aaaa::dc1132());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa6dc1132E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1132E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1132E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa6dc1132E");
    check_base_class_offset(lv, (::aaaa::cc3*), 2, "_ZN4aaaa6dc1132E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc1132E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1132E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1132E(Test__ZN4aaaa6dc1132E, "_ZN4aaaa6dc1132E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc1132E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1132E = {  "_ZN4aaaa6dc1132E", // class name
  bases__ZN4aaaa6dc1132E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1133  : ::aaaa::aa1 , ::aaaa::bb1 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc1133E) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1133E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1133E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa6dc1133E, buf);
    ::aaaa::dc1133 &lv = *(new (buf) ::aaaa::dc1133());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa6dc1133E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1133E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1133E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa6dc1133E");
    check_base_class_offset(lv, (::aaaa::cc3*), 2, "_ZN4aaaa6dc1133E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc1133E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1133E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1133E(Test__ZN4aaaa6dc1133E, "_ZN4aaaa6dc1133E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc1133E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1133E = {  "_ZN4aaaa6dc1133E", // class name
  bases__ZN4aaaa6dc1133E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1134  : ::aaaa::aa1 , ::aaaa::bb1 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc1134E) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1134E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1134E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa6dc1134E, buf);
    ::aaaa::dc1134 &lv = *(new (buf) ::aaaa::dc1134());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa6dc1134E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1134E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1134E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa6dc1134E");
    check_base_class_offset(lv, (::aaaa::cc3*), 2, "_ZN4aaaa6dc1134E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc1134E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1134E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1134E(Test__ZN4aaaa6dc1134E, "_ZN4aaaa6dc1134E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc1134E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1134E = {  "_ZN4aaaa6dc1134E", // class name
  bases__ZN4aaaa6dc1134E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1135  : ::aaaa::aa1 , ::aaaa::bb1 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc1135E) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1135E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1135E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa6dc1135E, buf);
    ::aaaa::dc1135 &lv = *(new (buf) ::aaaa::dc1135());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa6dc1135E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1135E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1135E");
    check_base_class_offset(lv, (::aaaa::bb1*), 1, "_ZN4aaaa6dc1135E");
    check_base_class_offset(lv, (::aaaa::cc3*), 2, "_ZN4aaaa6dc1135E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc1135E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1135E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1135E(Test__ZN4aaaa6dc1135E, "_ZN4aaaa6dc1135E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc1135E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1135E = {  "_ZN4aaaa6dc1135E", // class name
  bases__ZN4aaaa6dc1135E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db120  : ::aaaa::aa1 , ::aaaa::bb2 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db120E) C1{ BC2{ Fc} BC3{} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db120E()
{
  extern Class_Descriptor cd__ZN4aaaa5db120E;
  void *lvp;
  {
    char buf[4];
    init_test(&cd__ZN4aaaa5db120E, buf);
    ::aaaa::db120 &lv = *(new (buf) ::aaaa::db120());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa5db120E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa5db120E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa5db120E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa5db120E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa5db120E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db120E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db120E(Test__ZN4aaaa5db120E, "_ZN4aaaa5db120E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
static Base_Class bases__ZN4aaaa5db120E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db120E = {  "_ZN4aaaa5db120E", // class name
  bases__ZN4aaaa5db120E, 2,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db121  : ::aaaa::aa1 , ::aaaa::bb2 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db121E) C1{ BC2{ Fc} BC3{} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db121E()
{
  extern Class_Descriptor cd__ZN4aaaa5db121E;
  void *lvp;
  {
    char buf[4];
    init_test(&cd__ZN4aaaa5db121E, buf);
    ::aaaa::db121 &lv = *(new (buf) ::aaaa::db121());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa5db121E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa5db121E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa5db121E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa5db121E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa5db121E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db121E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db121E(Test__ZN4aaaa5db121E, "_ZN4aaaa5db121E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
static Base_Class bases__ZN4aaaa5db121E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db121E = {  "_ZN4aaaa5db121E", // class name
  bases__ZN4aaaa5db121E, 2,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db122  : ::aaaa::aa1 , ::aaaa::bb2 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db122E) C1{ BC2{ Fc} BC3{} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db122E()
{
  extern Class_Descriptor cd__ZN4aaaa5db122E;
  void *lvp;
  {
    char buf[4];
    init_test(&cd__ZN4aaaa5db122E, buf);
    ::aaaa::db122 &lv = *(new (buf) ::aaaa::db122());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa5db122E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa5db122E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa5db122E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa5db122E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa5db122E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db122E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db122E(Test__ZN4aaaa5db122E, "_ZN4aaaa5db122E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
static Base_Class bases__ZN4aaaa5db122E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db122E = {  "_ZN4aaaa5db122E", // class name
  bases__ZN4aaaa5db122E, 2,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db123  : ::aaaa::aa1 , ::aaaa::bb2 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db123E) C1{ BC2{ Fc} BC3{} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db123E()
{
  extern Class_Descriptor cd__ZN4aaaa5db123E;
  void *lvp;
  {
    char buf[4];
    init_test(&cd__ZN4aaaa5db123E, buf);
    ::aaaa::db123 &lv = *(new (buf) ::aaaa::db123());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa5db123E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa5db123E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa5db123E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa5db123E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa5db123E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db123E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db123E(Test__ZN4aaaa5db123E, "_ZN4aaaa5db123E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
static Base_Class bases__ZN4aaaa5db123E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db123E = {  "_ZN4aaaa5db123E", // class name
  bases__ZN4aaaa5db123E, 2,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db124  : ::aaaa::aa1 , ::aaaa::bb2 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db124E) C1{ BC2{ Fc} BC3{} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db124E()
{
  extern Class_Descriptor cd__ZN4aaaa5db124E;
  void *lvp;
  {
    char buf[4];
    init_test(&cd__ZN4aaaa5db124E, buf);
    ::aaaa::db124 &lv = *(new (buf) ::aaaa::db124());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa5db124E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa5db124E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa5db124E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa5db124E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa5db124E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db124E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db124E(Test__ZN4aaaa5db124E, "_ZN4aaaa5db124E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
static Base_Class bases__ZN4aaaa5db124E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db124E = {  "_ZN4aaaa5db124E", // class name
  bases__ZN4aaaa5db124E, 2,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db125  : ::aaaa::aa1 , ::aaaa::bb2 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db125E) C1{ BC2{ Fc} BC3{} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db125E()
{
  extern Class_Descriptor cd__ZN4aaaa5db125E;
  void *lvp;
  {
    char buf[4];
    init_test(&cd__ZN4aaaa5db125E, buf);
    ::aaaa::db125 &lv = *(new (buf) ::aaaa::db125());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa5db125E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa5db125E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa5db125E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa5db125E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa5db125E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db125E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db125E(Test__ZN4aaaa5db125E, "_ZN4aaaa5db125E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
static Base_Class bases__ZN4aaaa5db125E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db125E = {  "_ZN4aaaa5db125E", // class name
  bases__ZN4aaaa5db125E, 2,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1200  : ::aaaa::aa1 , ::aaaa::bb2 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc1200E) C1{ BC2{ Fc} BC3{} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1200E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1200E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc1200E, buf);
    ::aaaa::dc1200 &lv = *(new (buf) ::aaaa::dc1200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc1200E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1200E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1200E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc1200E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc1200E");
    test_class_info(&lv, &cd__ZN4aaaa6dc1200E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1200E(Test__ZN4aaaa6dc1200E, "_ZN4aaaa6dc1200E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc1200E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1200E = {  "_ZN4aaaa6dc1200E", // class name
  bases__ZN4aaaa6dc1200E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1201  : ::aaaa::aa1 , ::aaaa::bb2 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc1201E) C1{ BC2{ Fc} BC3{} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1201E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1201E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc1201E, buf);
    ::aaaa::dc1201 &lv = *(new (buf) ::aaaa::dc1201());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc1201E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1201E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1201E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc1201E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc1201E");
    test_class_info(&lv, &cd__ZN4aaaa6dc1201E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1201E(Test__ZN4aaaa6dc1201E, "_ZN4aaaa6dc1201E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc1201E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1201E = {  "_ZN4aaaa6dc1201E", // class name
  bases__ZN4aaaa6dc1201E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1202  : ::aaaa::aa1 , ::aaaa::bb2 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc1202E) C1{ BC2{ Fc} BC3{} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1202E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1202E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc1202E, buf);
    ::aaaa::dc1202 &lv = *(new (buf) ::aaaa::dc1202());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc1202E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1202E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1202E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc1202E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc1202E");
    test_class_info(&lv, &cd__ZN4aaaa6dc1202E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1202E(Test__ZN4aaaa6dc1202E, "_ZN4aaaa6dc1202E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc1202E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1202E = {  "_ZN4aaaa6dc1202E", // class name
  bases__ZN4aaaa6dc1202E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1203  : ::aaaa::aa1 , ::aaaa::bb2 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc1203E) C1{ BC2{ Fc} BC3{} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1203E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1203E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc1203E, buf);
    ::aaaa::dc1203 &lv = *(new (buf) ::aaaa::dc1203());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc1203E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1203E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1203E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc1203E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc1203E");
    test_class_info(&lv, &cd__ZN4aaaa6dc1203E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1203E(Test__ZN4aaaa6dc1203E, "_ZN4aaaa6dc1203E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc1203E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1203E = {  "_ZN4aaaa6dc1203E", // class name
  bases__ZN4aaaa6dc1203E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1204  : ::aaaa::aa1 , ::aaaa::bb2 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc1204E) C1{ BC2{ Fc} BC3{} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1204E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1204E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc1204E, buf);
    ::aaaa::dc1204 &lv = *(new (buf) ::aaaa::dc1204());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc1204E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1204E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1204E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc1204E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc1204E");
    test_class_info(&lv, &cd__ZN4aaaa6dc1204E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1204E(Test__ZN4aaaa6dc1204E, "_ZN4aaaa6dc1204E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc1204E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1204E = {  "_ZN4aaaa6dc1204E", // class name
  bases__ZN4aaaa6dc1204E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1205  : ::aaaa::aa1 , ::aaaa::bb2 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc1205E) C1{ BC2{ Fc} BC3{} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1205E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1205E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc1205E, buf);
    ::aaaa::dc1205 &lv = *(new (buf) ::aaaa::dc1205());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc1205E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1205E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1205E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc1205E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc1205E");
    test_class_info(&lv, &cd__ZN4aaaa6dc1205E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1205E(Test__ZN4aaaa6dc1205E, "_ZN4aaaa6dc1205E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc1205E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1205E = {  "_ZN4aaaa6dc1205E", // class name
  bases__ZN4aaaa6dc1205E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1210  : ::aaaa::aa1 , ::aaaa::bb2 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc1210E) C1{ BC2{ Fc} BC3{} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1210E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1210E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa6dc1210E, buf);
    ::aaaa::dc1210 &lv = *(new (buf) ::aaaa::dc1210());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa6dc1210E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc1210E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1210E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc1210E");
    check_base_class_offset(lv, (::aaaa::cc1*), 1, "_ZN4aaaa6dc1210E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc1210E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1210E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1210E(Test__ZN4aaaa6dc1210E, "_ZN4aaaa6dc1210E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc1210E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1210E = {  "_ZN4aaaa6dc1210E", // class name
  bases__ZN4aaaa6dc1210E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1211  : ::aaaa::aa1 , ::aaaa::bb2 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc1211E) C1{ BC2{ Fc} BC3{} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1211E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1211E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa6dc1211E, buf);
    ::aaaa::dc1211 &lv = *(new (buf) ::aaaa::dc1211());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa6dc1211E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc1211E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1211E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc1211E");
    check_base_class_offset(lv, (::aaaa::cc1*), 1, "_ZN4aaaa6dc1211E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc1211E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1211E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1211E(Test__ZN4aaaa6dc1211E, "_ZN4aaaa6dc1211E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc1211E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1211E = {  "_ZN4aaaa6dc1211E", // class name
  bases__ZN4aaaa6dc1211E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1212  : ::aaaa::aa1 , ::aaaa::bb2 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc1212E) C1{ BC2{ Fc} BC3{} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1212E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1212E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa6dc1212E, buf);
    ::aaaa::dc1212 &lv = *(new (buf) ::aaaa::dc1212());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa6dc1212E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc1212E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1212E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc1212E");
    check_base_class_offset(lv, (::aaaa::cc1*), 1, "_ZN4aaaa6dc1212E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc1212E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1212E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1212E(Test__ZN4aaaa6dc1212E, "_ZN4aaaa6dc1212E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc1212E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1212E = {  "_ZN4aaaa6dc1212E", // class name
  bases__ZN4aaaa6dc1212E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1213  : ::aaaa::aa1 , ::aaaa::bb2 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc1213E) C1{ BC2{ Fc} BC3{} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1213E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1213E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa6dc1213E, buf);
    ::aaaa::dc1213 &lv = *(new (buf) ::aaaa::dc1213());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa6dc1213E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc1213E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1213E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc1213E");
    check_base_class_offset(lv, (::aaaa::cc1*), 1, "_ZN4aaaa6dc1213E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc1213E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1213E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1213E(Test__ZN4aaaa6dc1213E, "_ZN4aaaa6dc1213E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc1213E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1213E = {  "_ZN4aaaa6dc1213E", // class name
  bases__ZN4aaaa6dc1213E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1214  : ::aaaa::aa1 , ::aaaa::bb2 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc1214E) C1{ BC2{ Fc} BC3{} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1214E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1214E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa6dc1214E, buf);
    ::aaaa::dc1214 &lv = *(new (buf) ::aaaa::dc1214());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa6dc1214E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc1214E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1214E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc1214E");
    check_base_class_offset(lv, (::aaaa::cc1*), 1, "_ZN4aaaa6dc1214E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc1214E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1214E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1214E(Test__ZN4aaaa6dc1214E, "_ZN4aaaa6dc1214E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc1214E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1214E = {  "_ZN4aaaa6dc1214E", // class name
  bases__ZN4aaaa6dc1214E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1215  : ::aaaa::aa1 , ::aaaa::bb2 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc1215E) C1{ BC2{ Fc} BC3{} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1215E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1215E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa6dc1215E, buf);
    ::aaaa::dc1215 &lv = *(new (buf) ::aaaa::dc1215());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa6dc1215E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc1215E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1215E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc1215E");
    check_base_class_offset(lv, (::aaaa::cc1*), 1, "_ZN4aaaa6dc1215E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc1215E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1215E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1215E(Test__ZN4aaaa6dc1215E, "_ZN4aaaa6dc1215E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc1215E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1215E = {  "_ZN4aaaa6dc1215E", // class name
  bases__ZN4aaaa6dc1215E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1220  : ::aaaa::aa1 , ::aaaa::bb2 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc1220E) C1{ BC2{ Fc} BC3{} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1220E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1220E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa6dc1220E, buf);
    ::aaaa::dc1220 &lv = *(new (buf) ::aaaa::dc1220());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa6dc1220E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc1220E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1220E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc1220E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc1220E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa6dc1220E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1220E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1220E(Test__ZN4aaaa6dc1220E, "_ZN4aaaa6dc1220E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc1220E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1220E = {  "_ZN4aaaa6dc1220E", // class name
  bases__ZN4aaaa6dc1220E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1221  : ::aaaa::aa1 , ::aaaa::bb2 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc1221E) C1{ BC2{ Fc} BC3{} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1221E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1221E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa6dc1221E, buf);
    ::aaaa::dc1221 &lv = *(new (buf) ::aaaa::dc1221());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa6dc1221E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc1221E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1221E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc1221E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc1221E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa6dc1221E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1221E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1221E(Test__ZN4aaaa6dc1221E, "_ZN4aaaa6dc1221E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc1221E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1221E = {  "_ZN4aaaa6dc1221E", // class name
  bases__ZN4aaaa6dc1221E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1222  : ::aaaa::aa1 , ::aaaa::bb2 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc1222E) C1{ BC2{ Fc} BC3{} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1222E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1222E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa6dc1222E, buf);
    ::aaaa::dc1222 &lv = *(new (buf) ::aaaa::dc1222());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa6dc1222E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc1222E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1222E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc1222E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc1222E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa6dc1222E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1222E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1222E(Test__ZN4aaaa6dc1222E, "_ZN4aaaa6dc1222E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc1222E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1222E = {  "_ZN4aaaa6dc1222E", // class name
  bases__ZN4aaaa6dc1222E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1223  : ::aaaa::aa1 , ::aaaa::bb2 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc1223E) C1{ BC2{ Fc} BC3{} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1223E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1223E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa6dc1223E, buf);
    ::aaaa::dc1223 &lv = *(new (buf) ::aaaa::dc1223());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa6dc1223E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc1223E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1223E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc1223E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc1223E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa6dc1223E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1223E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1223E(Test__ZN4aaaa6dc1223E, "_ZN4aaaa6dc1223E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc1223E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1223E = {  "_ZN4aaaa6dc1223E", // class name
  bases__ZN4aaaa6dc1223E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1224  : ::aaaa::aa1 , ::aaaa::bb2 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc1224E) C1{ BC2{ Fc} BC3{} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1224E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1224E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa6dc1224E, buf);
    ::aaaa::dc1224 &lv = *(new (buf) ::aaaa::dc1224());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa6dc1224E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc1224E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1224E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc1224E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc1224E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa6dc1224E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1224E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1224E(Test__ZN4aaaa6dc1224E, "_ZN4aaaa6dc1224E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc1224E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1224E = {  "_ZN4aaaa6dc1224E", // class name
  bases__ZN4aaaa6dc1224E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1225  : ::aaaa::aa1 , ::aaaa::bb2 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc1225E) C1{ BC2{ Fc} BC3{} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1225E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1225E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa6dc1225E, buf);
    ::aaaa::dc1225 &lv = *(new (buf) ::aaaa::dc1225());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa6dc1225E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc1225E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1225E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc1225E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc1225E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa6dc1225E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1225E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1225E(Test__ZN4aaaa6dc1225E, "_ZN4aaaa6dc1225E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc1225E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1225E = {  "_ZN4aaaa6dc1225E", // class name
  bases__ZN4aaaa6dc1225E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1230  : ::aaaa::aa1 , ::aaaa::bb2 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc1230E) C1{ BC2{ Fc} BC3{} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1230E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1230E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa6dc1230E, buf);
    ::aaaa::dc1230 &lv = *(new (buf) ::aaaa::dc1230());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa6dc1230E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1230E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1230E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc1230E");
    check_base_class_offset(lv, (::aaaa::cc3*), 2, "_ZN4aaaa6dc1230E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc1230E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1230E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1230E(Test__ZN4aaaa6dc1230E, "_ZN4aaaa6dc1230E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc1230E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1230E = {  "_ZN4aaaa6dc1230E", // class name
  bases__ZN4aaaa6dc1230E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1231  : ::aaaa::aa1 , ::aaaa::bb2 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc1231E) C1{ BC2{ Fc} BC3{} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1231E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1231E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa6dc1231E, buf);
    ::aaaa::dc1231 &lv = *(new (buf) ::aaaa::dc1231());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa6dc1231E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1231E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1231E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc1231E");
    check_base_class_offset(lv, (::aaaa::cc3*), 2, "_ZN4aaaa6dc1231E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc1231E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1231E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1231E(Test__ZN4aaaa6dc1231E, "_ZN4aaaa6dc1231E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc1231E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1231E = {  "_ZN4aaaa6dc1231E", // class name
  bases__ZN4aaaa6dc1231E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1232  : ::aaaa::aa1 , ::aaaa::bb2 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc1232E) C1{ BC2{ Fc} BC3{} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1232E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1232E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa6dc1232E, buf);
    ::aaaa::dc1232 &lv = *(new (buf) ::aaaa::dc1232());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa6dc1232E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1232E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1232E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc1232E");
    check_base_class_offset(lv, (::aaaa::cc3*), 2, "_ZN4aaaa6dc1232E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc1232E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1232E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1232E(Test__ZN4aaaa6dc1232E, "_ZN4aaaa6dc1232E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc1232E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1232E = {  "_ZN4aaaa6dc1232E", // class name
  bases__ZN4aaaa6dc1232E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1233  : ::aaaa::aa1 , ::aaaa::bb2 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc1233E) C1{ BC2{ Fc} BC3{} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1233E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1233E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa6dc1233E, buf);
    ::aaaa::dc1233 &lv = *(new (buf) ::aaaa::dc1233());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa6dc1233E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1233E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1233E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc1233E");
    check_base_class_offset(lv, (::aaaa::cc3*), 2, "_ZN4aaaa6dc1233E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc1233E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1233E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1233E(Test__ZN4aaaa6dc1233E, "_ZN4aaaa6dc1233E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc1233E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1233E = {  "_ZN4aaaa6dc1233E", // class name
  bases__ZN4aaaa6dc1233E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1234  : ::aaaa::aa1 , ::aaaa::bb2 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc1234E) C1{ BC2{ Fc} BC3{} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1234E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1234E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa6dc1234E, buf);
    ::aaaa::dc1234 &lv = *(new (buf) ::aaaa::dc1234());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa6dc1234E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1234E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1234E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc1234E");
    check_base_class_offset(lv, (::aaaa::cc3*), 2, "_ZN4aaaa6dc1234E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc1234E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1234E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1234E(Test__ZN4aaaa6dc1234E, "_ZN4aaaa6dc1234E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc1234E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1234E = {  "_ZN4aaaa6dc1234E", // class name
  bases__ZN4aaaa6dc1234E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1235  : ::aaaa::aa1 , ::aaaa::bb2 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc1235E) C1{ BC2{ Fc} BC3{} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1235E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1235E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa6dc1235E, buf);
    ::aaaa::dc1235 &lv = *(new (buf) ::aaaa::dc1235());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa6dc1235E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1235E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1235E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc1235E");
    check_base_class_offset(lv, (::aaaa::cc3*), 2, "_ZN4aaaa6dc1235E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc1235E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1235E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1235E(Test__ZN4aaaa6dc1235E, "_ZN4aaaa6dc1235E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc1235E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1235E = {  "_ZN4aaaa6dc1235E", // class name
  bases__ZN4aaaa6dc1235E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db130  : ::aaaa::aa1 , ::aaaa::bb3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db130E) C1{ BC2{ Fc} BC3{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db130E()
{
  extern Class_Descriptor cd__ZN4aaaa5db130E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa5db130E, buf);
    ::aaaa::db130 &lv = *(new (buf) ::aaaa::db130());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa5db130E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa5db130E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa5db130E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa5db130E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa5db130E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db130E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db130E(Test__ZN4aaaa5db130E, "_ZN4aaaa5db130E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
static Base_Class bases__ZN4aaaa5db130E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db130E = {  "_ZN4aaaa5db130E", // class name
  bases__ZN4aaaa5db130E, 2,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db131  : ::aaaa::aa1 , ::aaaa::bb3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db131E) C1{ BC2{ Fc} BC3{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db131E()
{
  extern Class_Descriptor cd__ZN4aaaa5db131E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa5db131E, buf);
    ::aaaa::db131 &lv = *(new (buf) ::aaaa::db131());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa5db131E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa5db131E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa5db131E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa5db131E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa5db131E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db131E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db131E(Test__ZN4aaaa5db131E, "_ZN4aaaa5db131E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
static Base_Class bases__ZN4aaaa5db131E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db131E = {  "_ZN4aaaa5db131E", // class name
  bases__ZN4aaaa5db131E, 2,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db132  : ::aaaa::aa1 , ::aaaa::bb3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db132E) C1{ BC2{ Fc} BC3{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db132E()
{
  extern Class_Descriptor cd__ZN4aaaa5db132E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa5db132E, buf);
    ::aaaa::db132 &lv = *(new (buf) ::aaaa::db132());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa5db132E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa5db132E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa5db132E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa5db132E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa5db132E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db132E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db132E(Test__ZN4aaaa5db132E, "_ZN4aaaa5db132E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
static Base_Class bases__ZN4aaaa5db132E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db132E = {  "_ZN4aaaa5db132E", // class name
  bases__ZN4aaaa5db132E, 2,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db133  : ::aaaa::aa1 , ::aaaa::bb3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db133E) C1{ BC2{ Fc} BC3{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db133E()
{
  extern Class_Descriptor cd__ZN4aaaa5db133E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa5db133E, buf);
    ::aaaa::db133 &lv = *(new (buf) ::aaaa::db133());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa5db133E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa5db133E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa5db133E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa5db133E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa5db133E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db133E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db133E(Test__ZN4aaaa5db133E, "_ZN4aaaa5db133E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
static Base_Class bases__ZN4aaaa5db133E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db133E = {  "_ZN4aaaa5db133E", // class name
  bases__ZN4aaaa5db133E, 2,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db134  : ::aaaa::aa1 , ::aaaa::bb3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db134E) C1{ BC2{ Fc} BC3{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db134E()
{
  extern Class_Descriptor cd__ZN4aaaa5db134E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa5db134E, buf);
    ::aaaa::db134 &lv = *(new (buf) ::aaaa::db134());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa5db134E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa5db134E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa5db134E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa5db134E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa5db134E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db134E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db134E(Test__ZN4aaaa5db134E, "_ZN4aaaa5db134E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
static Base_Class bases__ZN4aaaa5db134E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db134E = {  "_ZN4aaaa5db134E", // class name
  bases__ZN4aaaa5db134E, 2,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db135  : ::aaaa::aa1 , ::aaaa::bb3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db135E) C1{ BC2{ Fc} BC3{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db135E()
{
  extern Class_Descriptor cd__ZN4aaaa5db135E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa5db135E, buf);
    ::aaaa::db135 &lv = *(new (buf) ::aaaa::db135());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa5db135E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa5db135E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa5db135E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa5db135E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa5db135E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db135E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db135E(Test__ZN4aaaa5db135E, "_ZN4aaaa5db135E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
static Base_Class bases__ZN4aaaa5db135E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db135E = {  "_ZN4aaaa5db135E", // class name
  bases__ZN4aaaa5db135E, 2,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1300  : ::aaaa::aa1 , ::aaaa::bb3 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc1300E) C1{ BC2{ Fc} BC3{ Fs} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1300E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1300E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc1300E, buf);
    ::aaaa::dc1300 &lv = *(new (buf) ::aaaa::dc1300());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc1300E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1300E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1300E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa6dc1300E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc1300E");
    test_class_info(&lv, &cd__ZN4aaaa6dc1300E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1300E(Test__ZN4aaaa6dc1300E, "_ZN4aaaa6dc1300E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc1300E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1300E = {  "_ZN4aaaa6dc1300E", // class name
  bases__ZN4aaaa6dc1300E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1301  : ::aaaa::aa1 , ::aaaa::bb3 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc1301E) C1{ BC2{ Fc} BC3{ Fs} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1301E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1301E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc1301E, buf);
    ::aaaa::dc1301 &lv = *(new (buf) ::aaaa::dc1301());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc1301E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1301E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1301E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa6dc1301E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc1301E");
    test_class_info(&lv, &cd__ZN4aaaa6dc1301E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1301E(Test__ZN4aaaa6dc1301E, "_ZN4aaaa6dc1301E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc1301E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1301E = {  "_ZN4aaaa6dc1301E", // class name
  bases__ZN4aaaa6dc1301E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1302  : ::aaaa::aa1 , ::aaaa::bb3 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc1302E) C1{ BC2{ Fc} BC3{ Fs} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1302E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1302E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc1302E, buf);
    ::aaaa::dc1302 &lv = *(new (buf) ::aaaa::dc1302());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc1302E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1302E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1302E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa6dc1302E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc1302E");
    test_class_info(&lv, &cd__ZN4aaaa6dc1302E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1302E(Test__ZN4aaaa6dc1302E, "_ZN4aaaa6dc1302E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc1302E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1302E = {  "_ZN4aaaa6dc1302E", // class name
  bases__ZN4aaaa6dc1302E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1303  : ::aaaa::aa1 , ::aaaa::bb3 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc1303E) C1{ BC2{ Fc} BC3{ Fs} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1303E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1303E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc1303E, buf);
    ::aaaa::dc1303 &lv = *(new (buf) ::aaaa::dc1303());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc1303E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1303E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1303E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa6dc1303E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc1303E");
    test_class_info(&lv, &cd__ZN4aaaa6dc1303E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1303E(Test__ZN4aaaa6dc1303E, "_ZN4aaaa6dc1303E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc1303E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1303E = {  "_ZN4aaaa6dc1303E", // class name
  bases__ZN4aaaa6dc1303E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1304  : ::aaaa::aa1 , ::aaaa::bb3 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc1304E) C1{ BC2{ Fc} BC3{ Fs} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1304E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1304E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc1304E, buf);
    ::aaaa::dc1304 &lv = *(new (buf) ::aaaa::dc1304());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc1304E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1304E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1304E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa6dc1304E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc1304E");
    test_class_info(&lv, &cd__ZN4aaaa6dc1304E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1304E(Test__ZN4aaaa6dc1304E, "_ZN4aaaa6dc1304E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc1304E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1304E = {  "_ZN4aaaa6dc1304E", // class name
  bases__ZN4aaaa6dc1304E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1305  : ::aaaa::aa1 , ::aaaa::bb3 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc1305E) C1{ BC2{ Fc} BC3{ Fs} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1305E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1305E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc1305E, buf);
    ::aaaa::dc1305 &lv = *(new (buf) ::aaaa::dc1305());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc1305E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc1305E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1305E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa6dc1305E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc1305E");
    test_class_info(&lv, &cd__ZN4aaaa6dc1305E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1305E(Test__ZN4aaaa6dc1305E, "_ZN4aaaa6dc1305E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc1305E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1305E = {  "_ZN4aaaa6dc1305E", // class name
  bases__ZN4aaaa6dc1305E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1310  : ::aaaa::aa1 , ::aaaa::bb3 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc1310E) C1{ BC2{ Fc} BC3{ Fs} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1310E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1310E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4aaaa6dc1310E, buf);
    ::aaaa::dc1310 &lv = *(new (buf) ::aaaa::dc1310());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4aaaa6dc1310E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1310E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1310E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa6dc1310E");
    check_base_class_offset(lv, (::aaaa::cc1*), 4, "_ZN4aaaa6dc1310E");
    check_field_offset(lv, xc, 5, "_ZN4aaaa6dc1310E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1310E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1310E(Test__ZN4aaaa6dc1310E, "_ZN4aaaa6dc1310E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc1310E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1310E = {  "_ZN4aaaa6dc1310E", // class name
  bases__ZN4aaaa6dc1310E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1311  : ::aaaa::aa1 , ::aaaa::bb3 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc1311E) C1{ BC2{ Fc} BC3{ Fs} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1311E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1311E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4aaaa6dc1311E, buf);
    ::aaaa::dc1311 &lv = *(new (buf) ::aaaa::dc1311());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4aaaa6dc1311E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1311E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1311E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa6dc1311E");
    check_base_class_offset(lv, (::aaaa::cc1*), 4, "_ZN4aaaa6dc1311E");
    check_field_offset(lv, xc, 5, "_ZN4aaaa6dc1311E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1311E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1311E(Test__ZN4aaaa6dc1311E, "_ZN4aaaa6dc1311E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc1311E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1311E = {  "_ZN4aaaa6dc1311E", // class name
  bases__ZN4aaaa6dc1311E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1312  : ::aaaa::aa1 , ::aaaa::bb3 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc1312E) C1{ BC2{ Fc} BC3{ Fs} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1312E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1312E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4aaaa6dc1312E, buf);
    ::aaaa::dc1312 &lv = *(new (buf) ::aaaa::dc1312());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4aaaa6dc1312E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1312E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1312E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa6dc1312E");
    check_base_class_offset(lv, (::aaaa::cc1*), 4, "_ZN4aaaa6dc1312E");
    check_field_offset(lv, xc, 5, "_ZN4aaaa6dc1312E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1312E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1312E(Test__ZN4aaaa6dc1312E, "_ZN4aaaa6dc1312E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc1312E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1312E = {  "_ZN4aaaa6dc1312E", // class name
  bases__ZN4aaaa6dc1312E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1313  : ::aaaa::aa1 , ::aaaa::bb3 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc1313E) C1{ BC2{ Fc} BC3{ Fs} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1313E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1313E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4aaaa6dc1313E, buf);
    ::aaaa::dc1313 &lv = *(new (buf) ::aaaa::dc1313());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4aaaa6dc1313E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1313E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1313E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa6dc1313E");
    check_base_class_offset(lv, (::aaaa::cc1*), 4, "_ZN4aaaa6dc1313E");
    check_field_offset(lv, xc, 5, "_ZN4aaaa6dc1313E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1313E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1313E(Test__ZN4aaaa6dc1313E, "_ZN4aaaa6dc1313E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc1313E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1313E = {  "_ZN4aaaa6dc1313E", // class name
  bases__ZN4aaaa6dc1313E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1314  : ::aaaa::aa1 , ::aaaa::bb3 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc1314E) C1{ BC2{ Fc} BC3{ Fs} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1314E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1314E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4aaaa6dc1314E, buf);
    ::aaaa::dc1314 &lv = *(new (buf) ::aaaa::dc1314());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4aaaa6dc1314E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1314E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1314E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa6dc1314E");
    check_base_class_offset(lv, (::aaaa::cc1*), 4, "_ZN4aaaa6dc1314E");
    check_field_offset(lv, xc, 5, "_ZN4aaaa6dc1314E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1314E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1314E(Test__ZN4aaaa6dc1314E, "_ZN4aaaa6dc1314E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc1314E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1314E = {  "_ZN4aaaa6dc1314E", // class name
  bases__ZN4aaaa6dc1314E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1315  : ::aaaa::aa1 , ::aaaa::bb3 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc1315E) C1{ BC2{ Fc} BC3{ Fs} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1315E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1315E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4aaaa6dc1315E, buf);
    ::aaaa::dc1315 &lv = *(new (buf) ::aaaa::dc1315());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4aaaa6dc1315E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1315E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1315E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa6dc1315E");
    check_base_class_offset(lv, (::aaaa::cc1*), 4, "_ZN4aaaa6dc1315E");
    check_field_offset(lv, xc, 5, "_ZN4aaaa6dc1315E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1315E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1315E(Test__ZN4aaaa6dc1315E, "_ZN4aaaa6dc1315E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc1315E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1315E = {  "_ZN4aaaa6dc1315E", // class name
  bases__ZN4aaaa6dc1315E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1320  : ::aaaa::aa1 , ::aaaa::bb3 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc1320E) C1{ BC2{ Fc} BC3{ Fs} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1320E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1320E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4aaaa6dc1320E, buf);
    ::aaaa::dc1320 &lv = *(new (buf) ::aaaa::dc1320());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4aaaa6dc1320E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1320E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1320E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa6dc1320E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc1320E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc1320E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1320E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1320E(Test__ZN4aaaa6dc1320E, "_ZN4aaaa6dc1320E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc1320E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1320E = {  "_ZN4aaaa6dc1320E", // class name
  bases__ZN4aaaa6dc1320E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1321  : ::aaaa::aa1 , ::aaaa::bb3 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc1321E) C1{ BC2{ Fc} BC3{ Fs} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1321E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1321E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4aaaa6dc1321E, buf);
    ::aaaa::dc1321 &lv = *(new (buf) ::aaaa::dc1321());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4aaaa6dc1321E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1321E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1321E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa6dc1321E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc1321E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc1321E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1321E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1321E(Test__ZN4aaaa6dc1321E, "_ZN4aaaa6dc1321E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc1321E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1321E = {  "_ZN4aaaa6dc1321E", // class name
  bases__ZN4aaaa6dc1321E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1322  : ::aaaa::aa1 , ::aaaa::bb3 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc1322E) C1{ BC2{ Fc} BC3{ Fs} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1322E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1322E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4aaaa6dc1322E, buf);
    ::aaaa::dc1322 &lv = *(new (buf) ::aaaa::dc1322());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4aaaa6dc1322E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1322E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1322E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa6dc1322E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc1322E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc1322E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1322E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1322E(Test__ZN4aaaa6dc1322E, "_ZN4aaaa6dc1322E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc1322E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1322E = {  "_ZN4aaaa6dc1322E", // class name
  bases__ZN4aaaa6dc1322E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1323  : ::aaaa::aa1 , ::aaaa::bb3 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc1323E) C1{ BC2{ Fc} BC3{ Fs} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1323E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1323E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4aaaa6dc1323E, buf);
    ::aaaa::dc1323 &lv = *(new (buf) ::aaaa::dc1323());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4aaaa6dc1323E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1323E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1323E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa6dc1323E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc1323E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc1323E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1323E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1323E(Test__ZN4aaaa6dc1323E, "_ZN4aaaa6dc1323E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc1323E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1323E = {  "_ZN4aaaa6dc1323E", // class name
  bases__ZN4aaaa6dc1323E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1324  : ::aaaa::aa1 , ::aaaa::bb3 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc1324E) C1{ BC2{ Fc} BC3{ Fs} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1324E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1324E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4aaaa6dc1324E, buf);
    ::aaaa::dc1324 &lv = *(new (buf) ::aaaa::dc1324());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4aaaa6dc1324E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1324E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1324E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa6dc1324E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc1324E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc1324E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1324E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1324E(Test__ZN4aaaa6dc1324E, "_ZN4aaaa6dc1324E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc1324E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1324E = {  "_ZN4aaaa6dc1324E", // class name
  bases__ZN4aaaa6dc1324E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1325  : ::aaaa::aa1 , ::aaaa::bb3 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc1325E) C1{ BC2{ Fc} BC3{ Fs} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1325E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1325E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4aaaa6dc1325E, buf);
    ::aaaa::dc1325 &lv = *(new (buf) ::aaaa::dc1325());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4aaaa6dc1325E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1325E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1325E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa6dc1325E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc1325E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc1325E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1325E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1325E(Test__ZN4aaaa6dc1325E, "_ZN4aaaa6dc1325E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc1325E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1325E = {  "_ZN4aaaa6dc1325E", // class name
  bases__ZN4aaaa6dc1325E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1330  : ::aaaa::aa1 , ::aaaa::bb3 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc1330E) C1{ BC2{ Fc} BC3{ Fs} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1330E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1330E;
  void *lvp;
  {
    short buf[6];
    init_test(&cd__ZN4aaaa6dc1330E, buf);
    ::aaaa::dc1330 &lv = *(new (buf) ::aaaa::dc1330());
    lvp = (void*)&lv;
    check2(sizeof(lv), 10, "sizeof(_ZN4aaaa6dc1330E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1330E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1330E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa6dc1330E");
    check_base_class_offset(lv, (::aaaa::cc3*), 4, "_ZN4aaaa6dc1330E");
    check_field_offset(lv, xc, 6, "_ZN4aaaa6dc1330E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1330E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1330E(Test__ZN4aaaa6dc1330E, "_ZN4aaaa6dc1330E", 10);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc1330E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1330E = {  "_ZN4aaaa6dc1330E", // class name
  bases__ZN4aaaa6dc1330E, 3,
  0, // no vftv
  0, //no vtt
  10, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1331  : ::aaaa::aa1 , ::aaaa::bb3 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc1331E) C1{ BC2{ Fc} BC3{ Fs} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1331E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1331E;
  void *lvp;
  {
    short buf[6];
    init_test(&cd__ZN4aaaa6dc1331E, buf);
    ::aaaa::dc1331 &lv = *(new (buf) ::aaaa::dc1331());
    lvp = (void*)&lv;
    check2(sizeof(lv), 10, "sizeof(_ZN4aaaa6dc1331E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1331E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1331E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa6dc1331E");
    check_base_class_offset(lv, (::aaaa::cc3*), 4, "_ZN4aaaa6dc1331E");
    check_field_offset(lv, xc, 6, "_ZN4aaaa6dc1331E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1331E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1331E(Test__ZN4aaaa6dc1331E, "_ZN4aaaa6dc1331E", 10);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc1331E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1331E = {  "_ZN4aaaa6dc1331E", // class name
  bases__ZN4aaaa6dc1331E, 3,
  0, // no vftv
  0, //no vtt
  10, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1332  : ::aaaa::aa1 , ::aaaa::bb3 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc1332E) C1{ BC2{ Fc} BC3{ Fs} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1332E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1332E;
  void *lvp;
  {
    short buf[6];
    init_test(&cd__ZN4aaaa6dc1332E, buf);
    ::aaaa::dc1332 &lv = *(new (buf) ::aaaa::dc1332());
    lvp = (void*)&lv;
    check2(sizeof(lv), 10, "sizeof(_ZN4aaaa6dc1332E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1332E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1332E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa6dc1332E");
    check_base_class_offset(lv, (::aaaa::cc3*), 4, "_ZN4aaaa6dc1332E");
    check_field_offset(lv, xc, 6, "_ZN4aaaa6dc1332E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1332E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1332E(Test__ZN4aaaa6dc1332E, "_ZN4aaaa6dc1332E", 10);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc1332E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1332E = {  "_ZN4aaaa6dc1332E", // class name
  bases__ZN4aaaa6dc1332E, 3,
  0, // no vftv
  0, //no vtt
  10, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1333  : ::aaaa::aa1 , ::aaaa::bb3 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc1333E) C1{ BC2{ Fc} BC3{ Fs} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1333E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1333E;
  void *lvp;
  {
    short buf[6];
    init_test(&cd__ZN4aaaa6dc1333E, buf);
    ::aaaa::dc1333 &lv = *(new (buf) ::aaaa::dc1333());
    lvp = (void*)&lv;
    check2(sizeof(lv), 10, "sizeof(_ZN4aaaa6dc1333E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1333E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1333E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa6dc1333E");
    check_base_class_offset(lv, (::aaaa::cc3*), 4, "_ZN4aaaa6dc1333E");
    check_field_offset(lv, xc, 6, "_ZN4aaaa6dc1333E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1333E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1333E(Test__ZN4aaaa6dc1333E, "_ZN4aaaa6dc1333E", 10);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc1333E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1333E = {  "_ZN4aaaa6dc1333E", // class name
  bases__ZN4aaaa6dc1333E, 3,
  0, // no vftv
  0, //no vtt
  10, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1334  : ::aaaa::aa1 , ::aaaa::bb3 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc1334E) C1{ BC2{ Fc} BC3{ Fs} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1334E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1334E;
  void *lvp;
  {
    short buf[6];
    init_test(&cd__ZN4aaaa6dc1334E, buf);
    ::aaaa::dc1334 &lv = *(new (buf) ::aaaa::dc1334());
    lvp = (void*)&lv;
    check2(sizeof(lv), 10, "sizeof(_ZN4aaaa6dc1334E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1334E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1334E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa6dc1334E");
    check_base_class_offset(lv, (::aaaa::cc3*), 4, "_ZN4aaaa6dc1334E");
    check_field_offset(lv, xc, 6, "_ZN4aaaa6dc1334E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1334E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1334E(Test__ZN4aaaa6dc1334E, "_ZN4aaaa6dc1334E", 10);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc1334E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1334E = {  "_ZN4aaaa6dc1334E", // class name
  bases__ZN4aaaa6dc1334E, 3,
  0, // no vftv
  0, //no vtt
  10, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc1335  : ::aaaa::aa1 , ::aaaa::bb3 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc1335E) C1{ BC2{ Fc} BC3{ Fs} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc1335E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc1335E;
  void *lvp;
  {
    short buf[6];
    init_test(&cd__ZN4aaaa6dc1335E, buf);
    ::aaaa::dc1335 &lv = *(new (buf) ::aaaa::dc1335());
    lvp = (void*)&lv;
    check2(sizeof(lv), 10, "sizeof(_ZN4aaaa6dc1335E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc1335E)");
    check_base_class_offset(lv, (::aaaa::aa1*), 0, "_ZN4aaaa6dc1335E");
    check_base_class_offset(lv, (::aaaa::bb3*), 2, "_ZN4aaaa6dc1335E");
    check_base_class_offset(lv, (::aaaa::cc3*), 4, "_ZN4aaaa6dc1335E");
    check_field_offset(lv, xc, 6, "_ZN4aaaa6dc1335E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc1335E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc1335E(Test__ZN4aaaa6dc1335E, "_ZN4aaaa6dc1335E", 10);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa1E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc1335E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc1335E = {  "_ZN4aaaa6dc1335E", // class name
  bases__ZN4aaaa6dc1335E, 3,
  0, // no vftv
  0, //no vtt
  10, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  da20  : ::aaaa::aa2 {
};
//SIG(1 _ZN4aaaa4da20E) C1{ BC2{}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa4da20E()
{
  extern Class_Descriptor cd__ZN4aaaa4da20E;
  void *lvp;
  {
    char buf[1];
    init_test(&cd__ZN4aaaa4da20E, buf);
    ::aaaa::da20 &lv = *(new (buf) ::aaaa::da20());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(_ZN4aaaa4da20E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa4da20E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa4da20E");
    test_class_info(&lv, &cd__ZN4aaaa4da20E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa4da20E(Test__ZN4aaaa4da20E, "_ZN4aaaa4da20E", 1);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
static Base_Class bases__ZN4aaaa4da20E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa4da20E = {  "_ZN4aaaa4da20E", // class name
  bases__ZN4aaaa4da20E, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  da21  : ::aaaa::aa2 {
  char xc;
};
//SIG(1 _ZN4aaaa4da21E) C1{ BC2{} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa4da21E()
{
  extern Class_Descriptor cd__ZN4aaaa4da21E;
  void *lvp;
  {
    char buf[1];
    init_test(&cd__ZN4aaaa4da21E, buf);
    ::aaaa::da21 &lv = *(new (buf) ::aaaa::da21());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(_ZN4aaaa4da21E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa4da21E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa4da21E");
    check_field_offset(lv, xc, 0, "_ZN4aaaa4da21E.xc");
    test_class_info(&lv, &cd__ZN4aaaa4da21E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa4da21E(Test__ZN4aaaa4da21E, "_ZN4aaaa4da21E", 1);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
static Base_Class bases__ZN4aaaa4da21E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa4da21E = {  "_ZN4aaaa4da21E", // class name
  bases__ZN4aaaa4da21E, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  da22  : ::aaaa::aa2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa4da22E) C1{ BC2{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa4da22E()
{
  extern Class_Descriptor cd__ZN4aaaa4da22E;
  void *lvp;
  {
    char buf[2];
    init_test(&cd__ZN4aaaa4da22E, buf);
    ::aaaa::da22 &lv = *(new (buf) ::aaaa::da22());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4aaaa4da22E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa4da22E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa4da22E");
    check_field_offset(lv, xc, 0, "_ZN4aaaa4da22E.xc");
    test_class_info(&lv, &cd__ZN4aaaa4da22E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa4da22E(Test__ZN4aaaa4da22E, "_ZN4aaaa4da22E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
static Base_Class bases__ZN4aaaa4da22E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa4da22E = {  "_ZN4aaaa4da22E", // class name
  bases__ZN4aaaa4da22E, 1,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  da23  : ::aaaa::aa2 {
  char xc[3];
};
//SIG(1 _ZN4aaaa4da23E) C1{ BC2{} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa4da23E()
{
  extern Class_Descriptor cd__ZN4aaaa4da23E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa4da23E, buf);
    ::aaaa::da23 &lv = *(new (buf) ::aaaa::da23());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa4da23E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa4da23E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa4da23E");
    check_field_offset(lv, xc, 0, "_ZN4aaaa4da23E.xc");
    test_class_info(&lv, &cd__ZN4aaaa4da23E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa4da23E(Test__ZN4aaaa4da23E, "_ZN4aaaa4da23E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
static Base_Class bases__ZN4aaaa4da23E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa4da23E = {  "_ZN4aaaa4da23E", // class name
  bases__ZN4aaaa4da23E, 1,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  da24  : ::aaaa::aa2 {
  int fi;
};
//SIG(1 _ZN4aaaa4da24E) C1{ BC2{} Fi}
}
namespace aaaa { 
}
static void Test__ZN4aaaa4da24E()
{
  extern Class_Descriptor cd__ZN4aaaa4da24E;
  void *lvp;
  {
    int buf[2];
    init_test(&cd__ZN4aaaa4da24E, buf);
    ::aaaa::da24 &lv = *(new (buf) ::aaaa::da24());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa4da24E)");
    check2(__alignof__(lv), 4, "__alignof__(_ZN4aaaa4da24E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa4da24E");
    check_field_offset(lv, fi, 0, "_ZN4aaaa4da24E.fi");
    test_class_info(&lv, &cd__ZN4aaaa4da24E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa4da24E(Test__ZN4aaaa4da24E, "_ZN4aaaa4da24E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
static Base_Class bases__ZN4aaaa4da24E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa4da24E = {  "_ZN4aaaa4da24E", // class name
  bases__ZN4aaaa4da24E, 1,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  da25  : ::aaaa::aa2 {
  __tsi64 lli;
};
//SIG(1 _ZN4aaaa4da25E) C1{ BC2{} FL}
}
namespace aaaa { 
}
static void Test__ZN4aaaa4da25E()
{
  extern Class_Descriptor cd__ZN4aaaa4da25E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(2,3)];
    init_test(&cd__ZN4aaaa4da25E, buf);
    ::aaaa::da25 &lv = *(new (buf) ::aaaa::da25());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa4da25E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa4da25E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa4da25E");
    check_field_offset(lv, lli, 0, "_ZN4aaaa4da25E.lli");
    test_class_info(&lv, &cd__ZN4aaaa4da25E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa4da25E(Test__ZN4aaaa4da25E, "_ZN4aaaa4da25E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
static Base_Class bases__ZN4aaaa4da25E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa4da25E = {  "_ZN4aaaa4da25E", // class name
  bases__ZN4aaaa4da25E, 1,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db200  : ::aaaa::aa2 , ::aaaa::bb0 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db200E) C1{ BC2{} BC3{ FL Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db200E()
{
  extern Class_Descriptor cd__ZN4aaaa5db200E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa5db200E, buf);
    ::aaaa::db200 &lv = *(new (buf) ::aaaa::db200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa5db200E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db200E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa5db200E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa5db200E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa5db200E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db200E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db200E(Test__ZN4aaaa5db200E, "_ZN4aaaa5db200E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
static Base_Class bases__ZN4aaaa5db200E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db200E = {  "_ZN4aaaa5db200E", // class name
  bases__ZN4aaaa5db200E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db201  : ::aaaa::aa2 , ::aaaa::bb0 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db201E) C1{ BC2{} BC3{ FL Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db201E()
{
  extern Class_Descriptor cd__ZN4aaaa5db201E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa5db201E, buf);
    ::aaaa::db201 &lv = *(new (buf) ::aaaa::db201());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa5db201E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db201E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa5db201E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa5db201E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa5db201E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db201E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db201E(Test__ZN4aaaa5db201E, "_ZN4aaaa5db201E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
static Base_Class bases__ZN4aaaa5db201E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db201E = {  "_ZN4aaaa5db201E", // class name
  bases__ZN4aaaa5db201E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db202  : ::aaaa::aa2 , ::aaaa::bb0 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db202E) C1{ BC2{} BC3{ FL Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db202E()
{
  extern Class_Descriptor cd__ZN4aaaa5db202E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa5db202E, buf);
    ::aaaa::db202 &lv = *(new (buf) ::aaaa::db202());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa5db202E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db202E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa5db202E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa5db202E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa5db202E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db202E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db202E(Test__ZN4aaaa5db202E, "_ZN4aaaa5db202E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
static Base_Class bases__ZN4aaaa5db202E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db202E = {  "_ZN4aaaa5db202E", // class name
  bases__ZN4aaaa5db202E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db203  : ::aaaa::aa2 , ::aaaa::bb0 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db203E) C1{ BC2{} BC3{ FL Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db203E()
{
  extern Class_Descriptor cd__ZN4aaaa5db203E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa5db203E, buf);
    ::aaaa::db203 &lv = *(new (buf) ::aaaa::db203());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa5db203E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db203E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa5db203E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa5db203E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa5db203E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db203E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db203E(Test__ZN4aaaa5db203E, "_ZN4aaaa5db203E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
static Base_Class bases__ZN4aaaa5db203E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db203E = {  "_ZN4aaaa5db203E", // class name
  bases__ZN4aaaa5db203E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db204  : ::aaaa::aa2 , ::aaaa::bb0 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db204E) C1{ BC2{} BC3{ FL Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db204E()
{
  extern Class_Descriptor cd__ZN4aaaa5db204E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa5db204E, buf);
    ::aaaa::db204 &lv = *(new (buf) ::aaaa::db204());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa5db204E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db204E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa5db204E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa5db204E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa5db204E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db204E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db204E(Test__ZN4aaaa5db204E, "_ZN4aaaa5db204E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
static Base_Class bases__ZN4aaaa5db204E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db204E = {  "_ZN4aaaa5db204E", // class name
  bases__ZN4aaaa5db204E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db205  : ::aaaa::aa2 , ::aaaa::bb0 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db205E) C1{ BC2{} BC3{ FL Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db205E()
{
  extern Class_Descriptor cd__ZN4aaaa5db205E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa5db205E, buf);
    ::aaaa::db205 &lv = *(new (buf) ::aaaa::db205());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa5db205E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa5db205E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa5db205E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa5db205E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa5db205E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db205E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db205E(Test__ZN4aaaa5db205E, "_ZN4aaaa5db205E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
static Base_Class bases__ZN4aaaa5db205E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db205E = {  "_ZN4aaaa5db205E", // class name
  bases__ZN4aaaa5db205E, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2000  : ::aaaa::aa2 , ::aaaa::bb0 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc2000E) C1{ BC2{} BC3{ FL Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2000E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2000E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4aaaa6dc2000E, buf);
    ::aaaa::dc2000 &lv = *(new (buf) ::aaaa::dc2000());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4aaaa6dc2000E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2000E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2000E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa6dc2000E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(16,12), "_ZN4aaaa6dc2000E");
    test_class_info(&lv, &cd__ZN4aaaa6dc2000E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2000E(Test__ZN4aaaa6dc2000E, "_ZN4aaaa6dc2000E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc2000E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2000E = {  "_ZN4aaaa6dc2000E", // class name
  bases__ZN4aaaa6dc2000E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2001  : ::aaaa::aa2 , ::aaaa::bb0 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc2001E) C1{ BC2{} BC3{ FL Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2001E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2001E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4aaaa6dc2001E, buf);
    ::aaaa::dc2001 &lv = *(new (buf) ::aaaa::dc2001());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4aaaa6dc2001E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2001E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2001E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa6dc2001E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(16,12), "_ZN4aaaa6dc2001E");
    test_class_info(&lv, &cd__ZN4aaaa6dc2001E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2001E(Test__ZN4aaaa6dc2001E, "_ZN4aaaa6dc2001E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc2001E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2001E = {  "_ZN4aaaa6dc2001E", // class name
  bases__ZN4aaaa6dc2001E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2002  : ::aaaa::aa2 , ::aaaa::bb0 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc2002E) C1{ BC2{} BC3{ FL Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2002E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2002E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4aaaa6dc2002E, buf);
    ::aaaa::dc2002 &lv = *(new (buf) ::aaaa::dc2002());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4aaaa6dc2002E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2002E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2002E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa6dc2002E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(16,12), "_ZN4aaaa6dc2002E");
    test_class_info(&lv, &cd__ZN4aaaa6dc2002E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2002E(Test__ZN4aaaa6dc2002E, "_ZN4aaaa6dc2002E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc2002E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2002E = {  "_ZN4aaaa6dc2002E", // class name
  bases__ZN4aaaa6dc2002E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2003  : ::aaaa::aa2 , ::aaaa::bb0 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc2003E) C1{ BC2{} BC3{ FL Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2003E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2003E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4aaaa6dc2003E, buf);
    ::aaaa::dc2003 &lv = *(new (buf) ::aaaa::dc2003());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4aaaa6dc2003E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2003E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2003E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa6dc2003E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(16,12), "_ZN4aaaa6dc2003E");
    test_class_info(&lv, &cd__ZN4aaaa6dc2003E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2003E(Test__ZN4aaaa6dc2003E, "_ZN4aaaa6dc2003E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc2003E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2003E = {  "_ZN4aaaa6dc2003E", // class name
  bases__ZN4aaaa6dc2003E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2004  : ::aaaa::aa2 , ::aaaa::bb0 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc2004E) C1{ BC2{} BC3{ FL Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2004E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2004E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4aaaa6dc2004E, buf);
    ::aaaa::dc2004 &lv = *(new (buf) ::aaaa::dc2004());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4aaaa6dc2004E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2004E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2004E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa6dc2004E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(16,12), "_ZN4aaaa6dc2004E");
    test_class_info(&lv, &cd__ZN4aaaa6dc2004E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2004E(Test__ZN4aaaa6dc2004E, "_ZN4aaaa6dc2004E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc2004E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2004E = {  "_ZN4aaaa6dc2004E", // class name
  bases__ZN4aaaa6dc2004E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2005  : ::aaaa::aa2 , ::aaaa::bb0 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc2005E) C1{ BC2{} BC3{ FL Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2005E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2005E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,7)];
    init_test(&cd__ZN4aaaa6dc2005E, buf);
    ::aaaa::dc2005 &lv = *(new (buf) ::aaaa::dc2005());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(_ZN4aaaa6dc2005E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2005E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2005E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa6dc2005E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(16,12), "_ZN4aaaa6dc2005E");
    test_class_info(&lv, &cd__ZN4aaaa6dc2005E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2005E(Test__ZN4aaaa6dc2005E, "_ZN4aaaa6dc2005E", ABISELECT(32,24));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc2005E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2005E = {  "_ZN4aaaa6dc2005E", // class name
  bases__ZN4aaaa6dc2005E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(32,24), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2010  : ::aaaa::aa2 , ::aaaa::bb0 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc2010E) C1{ BC2{} BC3{ FL Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2010E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2010E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc2010E, buf);
    ::aaaa::dc2010 &lv = *(new (buf) ::aaaa::dc2010());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc2010E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2010E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2010E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa6dc2010E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(16,12), "_ZN4aaaa6dc2010E");
    check_field_offset(lv, xc, ABISELECT(17,13), "_ZN4aaaa6dc2010E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2010E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2010E(Test__ZN4aaaa6dc2010E, "_ZN4aaaa6dc2010E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc2010E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2010E = {  "_ZN4aaaa6dc2010E", // class name
  bases__ZN4aaaa6dc2010E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2011  : ::aaaa::aa2 , ::aaaa::bb0 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc2011E) C1{ BC2{} BC3{ FL Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2011E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2011E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc2011E, buf);
    ::aaaa::dc2011 &lv = *(new (buf) ::aaaa::dc2011());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc2011E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2011E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2011E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa6dc2011E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(16,12), "_ZN4aaaa6dc2011E");
    check_field_offset(lv, xc, ABISELECT(17,13), "_ZN4aaaa6dc2011E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2011E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2011E(Test__ZN4aaaa6dc2011E, "_ZN4aaaa6dc2011E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc2011E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2011E = {  "_ZN4aaaa6dc2011E", // class name
  bases__ZN4aaaa6dc2011E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2012  : ::aaaa::aa2 , ::aaaa::bb0 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc2012E) C1{ BC2{} BC3{ FL Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2012E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2012E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc2012E, buf);
    ::aaaa::dc2012 &lv = *(new (buf) ::aaaa::dc2012());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc2012E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2012E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2012E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa6dc2012E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(16,12), "_ZN4aaaa6dc2012E");
    check_field_offset(lv, xc, ABISELECT(17,13), "_ZN4aaaa6dc2012E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2012E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2012E(Test__ZN4aaaa6dc2012E, "_ZN4aaaa6dc2012E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc2012E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2012E = {  "_ZN4aaaa6dc2012E", // class name
  bases__ZN4aaaa6dc2012E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2013  : ::aaaa::aa2 , ::aaaa::bb0 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc2013E) C1{ BC2{} BC3{ FL Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2013E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2013E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc2013E, buf);
    ::aaaa::dc2013 &lv = *(new (buf) ::aaaa::dc2013());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc2013E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2013E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2013E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa6dc2013E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(16,12), "_ZN4aaaa6dc2013E");
    check_field_offset(lv, xc, ABISELECT(17,13), "_ZN4aaaa6dc2013E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2013E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2013E(Test__ZN4aaaa6dc2013E, "_ZN4aaaa6dc2013E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc2013E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2013E = {  "_ZN4aaaa6dc2013E", // class name
  bases__ZN4aaaa6dc2013E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2014  : ::aaaa::aa2 , ::aaaa::bb0 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc2014E) C1{ BC2{} BC3{ FL Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2014E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2014E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc2014E, buf);
    ::aaaa::dc2014 &lv = *(new (buf) ::aaaa::dc2014());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc2014E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2014E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2014E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa6dc2014E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(16,12), "_ZN4aaaa6dc2014E");
    check_field_offset(lv, xc, ABISELECT(17,13), "_ZN4aaaa6dc2014E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2014E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2014E(Test__ZN4aaaa6dc2014E, "_ZN4aaaa6dc2014E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc2014E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2014E = {  "_ZN4aaaa6dc2014E", // class name
  bases__ZN4aaaa6dc2014E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2015  : ::aaaa::aa2 , ::aaaa::bb0 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc2015E) C1{ BC2{} BC3{ FL Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2015E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2015E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc2015E, buf);
    ::aaaa::dc2015 &lv = *(new (buf) ::aaaa::dc2015());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc2015E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2015E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2015E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa6dc2015E");
    check_base_class_offset(lv, (::aaaa::cc1*), ABISELECT(16,12), "_ZN4aaaa6dc2015E");
    check_field_offset(lv, xc, ABISELECT(17,13), "_ZN4aaaa6dc2015E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2015E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2015E(Test__ZN4aaaa6dc2015E, "_ZN4aaaa6dc2015E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc2015E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2015E = {  "_ZN4aaaa6dc2015E", // class name
  bases__ZN4aaaa6dc2015E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2020  : ::aaaa::aa2 , ::aaaa::bb0 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc2020E) C1{ BC2{} BC3{ FL Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2020E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2020E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc2020E, buf);
    ::aaaa::dc2020 &lv = *(new (buf) ::aaaa::dc2020());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc2020E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2020E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2020E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa6dc2020E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc2020E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa6dc2020E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2020E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2020E(Test__ZN4aaaa6dc2020E, "_ZN4aaaa6dc2020E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc2020E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2020E = {  "_ZN4aaaa6dc2020E", // class name
  bases__ZN4aaaa6dc2020E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2021  : ::aaaa::aa2 , ::aaaa::bb0 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc2021E) C1{ BC2{} BC3{ FL Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2021E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2021E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc2021E, buf);
    ::aaaa::dc2021 &lv = *(new (buf) ::aaaa::dc2021());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc2021E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2021E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2021E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa6dc2021E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc2021E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa6dc2021E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2021E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2021E(Test__ZN4aaaa6dc2021E, "_ZN4aaaa6dc2021E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc2021E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2021E = {  "_ZN4aaaa6dc2021E", // class name
  bases__ZN4aaaa6dc2021E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2022  : ::aaaa::aa2 , ::aaaa::bb0 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc2022E) C1{ BC2{} BC3{ FL Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2022E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2022E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc2022E, buf);
    ::aaaa::dc2022 &lv = *(new (buf) ::aaaa::dc2022());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc2022E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2022E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2022E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa6dc2022E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc2022E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa6dc2022E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2022E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2022E(Test__ZN4aaaa6dc2022E, "_ZN4aaaa6dc2022E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc2022E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2022E = {  "_ZN4aaaa6dc2022E", // class name
  bases__ZN4aaaa6dc2022E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2023  : ::aaaa::aa2 , ::aaaa::bb0 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc2023E) C1{ BC2{} BC3{ FL Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2023E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2023E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc2023E, buf);
    ::aaaa::dc2023 &lv = *(new (buf) ::aaaa::dc2023());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc2023E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2023E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2023E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa6dc2023E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc2023E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa6dc2023E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2023E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2023E(Test__ZN4aaaa6dc2023E, "_ZN4aaaa6dc2023E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc2023E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2023E = {  "_ZN4aaaa6dc2023E", // class name
  bases__ZN4aaaa6dc2023E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2024  : ::aaaa::aa2 , ::aaaa::bb0 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc2024E) C1{ BC2{} BC3{ FL Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2024E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2024E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc2024E, buf);
    ::aaaa::dc2024 &lv = *(new (buf) ::aaaa::dc2024());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc2024E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2024E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2024E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa6dc2024E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc2024E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa6dc2024E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2024E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2024E(Test__ZN4aaaa6dc2024E, "_ZN4aaaa6dc2024E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc2024E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2024E = {  "_ZN4aaaa6dc2024E", // class name
  bases__ZN4aaaa6dc2024E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2025  : ::aaaa::aa2 , ::aaaa::bb0 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc2025E) C1{ BC2{} BC3{ FL Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2025E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2025E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc2025E, buf);
    ::aaaa::dc2025 &lv = *(new (buf) ::aaaa::dc2025());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc2025E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2025E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2025E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa6dc2025E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc2025E");
    check_field_offset(lv, xc, ABISELECT(16,12), "_ZN4aaaa6dc2025E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2025E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2025E(Test__ZN4aaaa6dc2025E, "_ZN4aaaa6dc2025E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc2025E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2025E = {  "_ZN4aaaa6dc2025E", // class name
  bases__ZN4aaaa6dc2025E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2030  : ::aaaa::aa2 , ::aaaa::bb0 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc2030E) C1{ BC2{} BC3{ FL Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2030E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2030E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa6dc2030E, buf);
    ::aaaa::dc2030 &lv = *(new (buf) ::aaaa::dc2030());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa6dc2030E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2030E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2030E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa6dc2030E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(16,12), "_ZN4aaaa6dc2030E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa6dc2030E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2030E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2030E(Test__ZN4aaaa6dc2030E, "_ZN4aaaa6dc2030E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc2030E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2030E = {  "_ZN4aaaa6dc2030E", // class name
  bases__ZN4aaaa6dc2030E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2031  : ::aaaa::aa2 , ::aaaa::bb0 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc2031E) C1{ BC2{} BC3{ FL Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2031E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2031E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa6dc2031E, buf);
    ::aaaa::dc2031 &lv = *(new (buf) ::aaaa::dc2031());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa6dc2031E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2031E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2031E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa6dc2031E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(16,12), "_ZN4aaaa6dc2031E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa6dc2031E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2031E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2031E(Test__ZN4aaaa6dc2031E, "_ZN4aaaa6dc2031E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc2031E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2031E = {  "_ZN4aaaa6dc2031E", // class name
  bases__ZN4aaaa6dc2031E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2032  : ::aaaa::aa2 , ::aaaa::bb0 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc2032E) C1{ BC2{} BC3{ FL Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2032E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2032E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa6dc2032E, buf);
    ::aaaa::dc2032 &lv = *(new (buf) ::aaaa::dc2032());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa6dc2032E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2032E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2032E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa6dc2032E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(16,12), "_ZN4aaaa6dc2032E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa6dc2032E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2032E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2032E(Test__ZN4aaaa6dc2032E, "_ZN4aaaa6dc2032E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc2032E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2032E = {  "_ZN4aaaa6dc2032E", // class name
  bases__ZN4aaaa6dc2032E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2033  : ::aaaa::aa2 , ::aaaa::bb0 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc2033E) C1{ BC2{} BC3{ FL Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2033E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2033E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa6dc2033E, buf);
    ::aaaa::dc2033 &lv = *(new (buf) ::aaaa::dc2033());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa6dc2033E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2033E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2033E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa6dc2033E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(16,12), "_ZN4aaaa6dc2033E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa6dc2033E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2033E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2033E(Test__ZN4aaaa6dc2033E, "_ZN4aaaa6dc2033E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc2033E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2033E = {  "_ZN4aaaa6dc2033E", // class name
  bases__ZN4aaaa6dc2033E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2034  : ::aaaa::aa2 , ::aaaa::bb0 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc2034E) C1{ BC2{} BC3{ FL Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2034E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2034E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa6dc2034E, buf);
    ::aaaa::dc2034 &lv = *(new (buf) ::aaaa::dc2034());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa6dc2034E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2034E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2034E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa6dc2034E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(16,12), "_ZN4aaaa6dc2034E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa6dc2034E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2034E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2034E(Test__ZN4aaaa6dc2034E, "_ZN4aaaa6dc2034E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc2034E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2034E = {  "_ZN4aaaa6dc2034E", // class name
  bases__ZN4aaaa6dc2034E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2035  : ::aaaa::aa2 , ::aaaa::bb0 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc2035E) C1{ BC2{} BC3{ FL Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2035E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2035E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,6)];
    init_test(&cd__ZN4aaaa6dc2035E, buf);
    ::aaaa::dc2035 &lv = *(new (buf) ::aaaa::dc2035());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,20), "sizeof(_ZN4aaaa6dc2035E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2035E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2035E");
    check_base_class_offset(lv, (::aaaa::bb0*), 0, "_ZN4aaaa6dc2035E");
    check_base_class_offset(lv, (::aaaa::cc3*), ABISELECT(16,12), "_ZN4aaaa6dc2035E");
    check_field_offset(lv, xc, ABISELECT(18,14), "_ZN4aaaa6dc2035E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2035E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2035E(Test__ZN4aaaa6dc2035E, "_ZN4aaaa6dc2035E", ABISELECT(24,20));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb0E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc2035E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2035E = {  "_ZN4aaaa6dc2035E", // class name
  bases__ZN4aaaa6dc2035E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,20), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db210  : ::aaaa::aa2 , ::aaaa::bb1 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db210E) C1{ BC2{} BC3{ Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db210E()
{
  extern Class_Descriptor cd__ZN4aaaa5db210E;
  void *lvp;
  {
    char buf[4];
    init_test(&cd__ZN4aaaa5db210E, buf);
    ::aaaa::db210 &lv = *(new (buf) ::aaaa::db210());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa5db210E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa5db210E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa5db210E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa5db210E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa5db210E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db210E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db210E(Test__ZN4aaaa5db210E, "_ZN4aaaa5db210E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
static Base_Class bases__ZN4aaaa5db210E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db210E = {  "_ZN4aaaa5db210E", // class name
  bases__ZN4aaaa5db210E, 2,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db211  : ::aaaa::aa2 , ::aaaa::bb1 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db211E) C1{ BC2{} BC3{ Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db211E()
{
  extern Class_Descriptor cd__ZN4aaaa5db211E;
  void *lvp;
  {
    char buf[4];
    init_test(&cd__ZN4aaaa5db211E, buf);
    ::aaaa::db211 &lv = *(new (buf) ::aaaa::db211());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa5db211E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa5db211E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa5db211E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa5db211E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa5db211E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db211E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db211E(Test__ZN4aaaa5db211E, "_ZN4aaaa5db211E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
static Base_Class bases__ZN4aaaa5db211E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db211E = {  "_ZN4aaaa5db211E", // class name
  bases__ZN4aaaa5db211E, 2,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db212  : ::aaaa::aa2 , ::aaaa::bb1 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db212E) C1{ BC2{} BC3{ Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db212E()
{
  extern Class_Descriptor cd__ZN4aaaa5db212E;
  void *lvp;
  {
    char buf[4];
    init_test(&cd__ZN4aaaa5db212E, buf);
    ::aaaa::db212 &lv = *(new (buf) ::aaaa::db212());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa5db212E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa5db212E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa5db212E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa5db212E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa5db212E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db212E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db212E(Test__ZN4aaaa5db212E, "_ZN4aaaa5db212E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
static Base_Class bases__ZN4aaaa5db212E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db212E = {  "_ZN4aaaa5db212E", // class name
  bases__ZN4aaaa5db212E, 2,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db213  : ::aaaa::aa2 , ::aaaa::bb1 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db213E) C1{ BC2{} BC3{ Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db213E()
{
  extern Class_Descriptor cd__ZN4aaaa5db213E;
  void *lvp;
  {
    char buf[4];
    init_test(&cd__ZN4aaaa5db213E, buf);
    ::aaaa::db213 &lv = *(new (buf) ::aaaa::db213());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa5db213E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa5db213E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa5db213E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa5db213E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa5db213E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db213E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db213E(Test__ZN4aaaa5db213E, "_ZN4aaaa5db213E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
static Base_Class bases__ZN4aaaa5db213E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db213E = {  "_ZN4aaaa5db213E", // class name
  bases__ZN4aaaa5db213E, 2,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db214  : ::aaaa::aa2 , ::aaaa::bb1 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db214E) C1{ BC2{} BC3{ Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db214E()
{
  extern Class_Descriptor cd__ZN4aaaa5db214E;
  void *lvp;
  {
    char buf[4];
    init_test(&cd__ZN4aaaa5db214E, buf);
    ::aaaa::db214 &lv = *(new (buf) ::aaaa::db214());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa5db214E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa5db214E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa5db214E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa5db214E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa5db214E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db214E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db214E(Test__ZN4aaaa5db214E, "_ZN4aaaa5db214E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
static Base_Class bases__ZN4aaaa5db214E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db214E = {  "_ZN4aaaa5db214E", // class name
  bases__ZN4aaaa5db214E, 2,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db215  : ::aaaa::aa2 , ::aaaa::bb1 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db215E) C1{ BC2{} BC3{ Fc} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db215E()
{
  extern Class_Descriptor cd__ZN4aaaa5db215E;
  void *lvp;
  {
    char buf[4];
    init_test(&cd__ZN4aaaa5db215E, buf);
    ::aaaa::db215 &lv = *(new (buf) ::aaaa::db215());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa5db215E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa5db215E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa5db215E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa5db215E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa5db215E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db215E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db215E(Test__ZN4aaaa5db215E, "_ZN4aaaa5db215E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
static Base_Class bases__ZN4aaaa5db215E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db215E = {  "_ZN4aaaa5db215E", // class name
  bases__ZN4aaaa5db215E, 2,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2100  : ::aaaa::aa2 , ::aaaa::bb1 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc2100E) C1{ BC2{} BC3{ Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2100E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2100E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc2100E, buf);
    ::aaaa::dc2100 &lv = *(new (buf) ::aaaa::dc2100());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc2100E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2100E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2100E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa6dc2100E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc2100E");
    test_class_info(&lv, &cd__ZN4aaaa6dc2100E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2100E(Test__ZN4aaaa6dc2100E, "_ZN4aaaa6dc2100E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc2100E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2100E = {  "_ZN4aaaa6dc2100E", // class name
  bases__ZN4aaaa6dc2100E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2101  : ::aaaa::aa2 , ::aaaa::bb1 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc2101E) C1{ BC2{} BC3{ Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2101E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2101E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc2101E, buf);
    ::aaaa::dc2101 &lv = *(new (buf) ::aaaa::dc2101());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc2101E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2101E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2101E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa6dc2101E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc2101E");
    test_class_info(&lv, &cd__ZN4aaaa6dc2101E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2101E(Test__ZN4aaaa6dc2101E, "_ZN4aaaa6dc2101E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc2101E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2101E = {  "_ZN4aaaa6dc2101E", // class name
  bases__ZN4aaaa6dc2101E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2102  : ::aaaa::aa2 , ::aaaa::bb1 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc2102E) C1{ BC2{} BC3{ Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2102E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2102E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc2102E, buf);
    ::aaaa::dc2102 &lv = *(new (buf) ::aaaa::dc2102());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc2102E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2102E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2102E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa6dc2102E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc2102E");
    test_class_info(&lv, &cd__ZN4aaaa6dc2102E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2102E(Test__ZN4aaaa6dc2102E, "_ZN4aaaa6dc2102E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc2102E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2102E = {  "_ZN4aaaa6dc2102E", // class name
  bases__ZN4aaaa6dc2102E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2103  : ::aaaa::aa2 , ::aaaa::bb1 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc2103E) C1{ BC2{} BC3{ Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2103E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2103E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc2103E, buf);
    ::aaaa::dc2103 &lv = *(new (buf) ::aaaa::dc2103());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc2103E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2103E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2103E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa6dc2103E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc2103E");
    test_class_info(&lv, &cd__ZN4aaaa6dc2103E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2103E(Test__ZN4aaaa6dc2103E, "_ZN4aaaa6dc2103E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc2103E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2103E = {  "_ZN4aaaa6dc2103E", // class name
  bases__ZN4aaaa6dc2103E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2104  : ::aaaa::aa2 , ::aaaa::bb1 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc2104E) C1{ BC2{} BC3{ Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2104E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2104E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc2104E, buf);
    ::aaaa::dc2104 &lv = *(new (buf) ::aaaa::dc2104());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc2104E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2104E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2104E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa6dc2104E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc2104E");
    test_class_info(&lv, &cd__ZN4aaaa6dc2104E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2104E(Test__ZN4aaaa6dc2104E, "_ZN4aaaa6dc2104E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc2104E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2104E = {  "_ZN4aaaa6dc2104E", // class name
  bases__ZN4aaaa6dc2104E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2105  : ::aaaa::aa2 , ::aaaa::bb1 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc2105E) C1{ BC2{} BC3{ Fc} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2105E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2105E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc2105E, buf);
    ::aaaa::dc2105 &lv = *(new (buf) ::aaaa::dc2105());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc2105E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2105E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2105E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa6dc2105E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc2105E");
    test_class_info(&lv, &cd__ZN4aaaa6dc2105E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2105E(Test__ZN4aaaa6dc2105E, "_ZN4aaaa6dc2105E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc2105E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2105E = {  "_ZN4aaaa6dc2105E", // class name
  bases__ZN4aaaa6dc2105E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2110  : ::aaaa::aa2 , ::aaaa::bb1 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc2110E) C1{ BC2{} BC3{ Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2110E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2110E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa6dc2110E, buf);
    ::aaaa::dc2110 &lv = *(new (buf) ::aaaa::dc2110());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa6dc2110E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc2110E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2110E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa6dc2110E");
    check_base_class_offset(lv, (::aaaa::cc1*), 1, "_ZN4aaaa6dc2110E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc2110E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2110E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2110E(Test__ZN4aaaa6dc2110E, "_ZN4aaaa6dc2110E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc2110E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2110E = {  "_ZN4aaaa6dc2110E", // class name
  bases__ZN4aaaa6dc2110E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2111  : ::aaaa::aa2 , ::aaaa::bb1 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc2111E) C1{ BC2{} BC3{ Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2111E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2111E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa6dc2111E, buf);
    ::aaaa::dc2111 &lv = *(new (buf) ::aaaa::dc2111());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa6dc2111E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc2111E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2111E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa6dc2111E");
    check_base_class_offset(lv, (::aaaa::cc1*), 1, "_ZN4aaaa6dc2111E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc2111E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2111E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2111E(Test__ZN4aaaa6dc2111E, "_ZN4aaaa6dc2111E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc2111E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2111E = {  "_ZN4aaaa6dc2111E", // class name
  bases__ZN4aaaa6dc2111E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2112  : ::aaaa::aa2 , ::aaaa::bb1 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc2112E) C1{ BC2{} BC3{ Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2112E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2112E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa6dc2112E, buf);
    ::aaaa::dc2112 &lv = *(new (buf) ::aaaa::dc2112());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa6dc2112E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc2112E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2112E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa6dc2112E");
    check_base_class_offset(lv, (::aaaa::cc1*), 1, "_ZN4aaaa6dc2112E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc2112E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2112E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2112E(Test__ZN4aaaa6dc2112E, "_ZN4aaaa6dc2112E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc2112E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2112E = {  "_ZN4aaaa6dc2112E", // class name
  bases__ZN4aaaa6dc2112E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2113  : ::aaaa::aa2 , ::aaaa::bb1 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc2113E) C1{ BC2{} BC3{ Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2113E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2113E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa6dc2113E, buf);
    ::aaaa::dc2113 &lv = *(new (buf) ::aaaa::dc2113());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa6dc2113E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc2113E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2113E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa6dc2113E");
    check_base_class_offset(lv, (::aaaa::cc1*), 1, "_ZN4aaaa6dc2113E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc2113E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2113E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2113E(Test__ZN4aaaa6dc2113E, "_ZN4aaaa6dc2113E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc2113E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2113E = {  "_ZN4aaaa6dc2113E", // class name
  bases__ZN4aaaa6dc2113E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2114  : ::aaaa::aa2 , ::aaaa::bb1 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc2114E) C1{ BC2{} BC3{ Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2114E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2114E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa6dc2114E, buf);
    ::aaaa::dc2114 &lv = *(new (buf) ::aaaa::dc2114());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa6dc2114E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc2114E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2114E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa6dc2114E");
    check_base_class_offset(lv, (::aaaa::cc1*), 1, "_ZN4aaaa6dc2114E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc2114E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2114E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2114E(Test__ZN4aaaa6dc2114E, "_ZN4aaaa6dc2114E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc2114E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2114E = {  "_ZN4aaaa6dc2114E", // class name
  bases__ZN4aaaa6dc2114E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2115  : ::aaaa::aa2 , ::aaaa::bb1 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc2115E) C1{ BC2{} BC3{ Fc} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2115E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2115E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa6dc2115E, buf);
    ::aaaa::dc2115 &lv = *(new (buf) ::aaaa::dc2115());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa6dc2115E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc2115E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2115E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa6dc2115E");
    check_base_class_offset(lv, (::aaaa::cc1*), 1, "_ZN4aaaa6dc2115E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc2115E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2115E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2115E(Test__ZN4aaaa6dc2115E, "_ZN4aaaa6dc2115E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc2115E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2115E = {  "_ZN4aaaa6dc2115E", // class name
  bases__ZN4aaaa6dc2115E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2120  : ::aaaa::aa2 , ::aaaa::bb1 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc2120E) C1{ BC2{} BC3{ Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2120E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2120E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa6dc2120E, buf);
    ::aaaa::dc2120 &lv = *(new (buf) ::aaaa::dc2120());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa6dc2120E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc2120E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2120E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa6dc2120E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc2120E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa6dc2120E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2120E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2120E(Test__ZN4aaaa6dc2120E, "_ZN4aaaa6dc2120E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc2120E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2120E = {  "_ZN4aaaa6dc2120E", // class name
  bases__ZN4aaaa6dc2120E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2121  : ::aaaa::aa2 , ::aaaa::bb1 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc2121E) C1{ BC2{} BC3{ Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2121E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2121E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa6dc2121E, buf);
    ::aaaa::dc2121 &lv = *(new (buf) ::aaaa::dc2121());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa6dc2121E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc2121E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2121E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa6dc2121E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc2121E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa6dc2121E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2121E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2121E(Test__ZN4aaaa6dc2121E, "_ZN4aaaa6dc2121E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc2121E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2121E = {  "_ZN4aaaa6dc2121E", // class name
  bases__ZN4aaaa6dc2121E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2122  : ::aaaa::aa2 , ::aaaa::bb1 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc2122E) C1{ BC2{} BC3{ Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2122E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2122E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa6dc2122E, buf);
    ::aaaa::dc2122 &lv = *(new (buf) ::aaaa::dc2122());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa6dc2122E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc2122E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2122E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa6dc2122E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc2122E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa6dc2122E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2122E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2122E(Test__ZN4aaaa6dc2122E, "_ZN4aaaa6dc2122E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc2122E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2122E = {  "_ZN4aaaa6dc2122E", // class name
  bases__ZN4aaaa6dc2122E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2123  : ::aaaa::aa2 , ::aaaa::bb1 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc2123E) C1{ BC2{} BC3{ Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2123E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2123E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa6dc2123E, buf);
    ::aaaa::dc2123 &lv = *(new (buf) ::aaaa::dc2123());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa6dc2123E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc2123E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2123E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa6dc2123E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc2123E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa6dc2123E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2123E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2123E(Test__ZN4aaaa6dc2123E, "_ZN4aaaa6dc2123E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc2123E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2123E = {  "_ZN4aaaa6dc2123E", // class name
  bases__ZN4aaaa6dc2123E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2124  : ::aaaa::aa2 , ::aaaa::bb1 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc2124E) C1{ BC2{} BC3{ Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2124E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2124E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa6dc2124E, buf);
    ::aaaa::dc2124 &lv = *(new (buf) ::aaaa::dc2124());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa6dc2124E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc2124E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2124E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa6dc2124E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc2124E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa6dc2124E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2124E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2124E(Test__ZN4aaaa6dc2124E, "_ZN4aaaa6dc2124E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc2124E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2124E = {  "_ZN4aaaa6dc2124E", // class name
  bases__ZN4aaaa6dc2124E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2125  : ::aaaa::aa2 , ::aaaa::bb1 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc2125E) C1{ BC2{} BC3{ Fc} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2125E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2125E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa6dc2125E, buf);
    ::aaaa::dc2125 &lv = *(new (buf) ::aaaa::dc2125());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa6dc2125E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc2125E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2125E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa6dc2125E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc2125E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa6dc2125E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2125E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2125E(Test__ZN4aaaa6dc2125E, "_ZN4aaaa6dc2125E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc2125E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2125E = {  "_ZN4aaaa6dc2125E", // class name
  bases__ZN4aaaa6dc2125E, 3,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2130  : ::aaaa::aa2 , ::aaaa::bb1 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc2130E) C1{ BC2{} BC3{ Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2130E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2130E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa6dc2130E, buf);
    ::aaaa::dc2130 &lv = *(new (buf) ::aaaa::dc2130());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa6dc2130E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2130E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2130E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa6dc2130E");
    check_base_class_offset(lv, (::aaaa::cc3*), 2, "_ZN4aaaa6dc2130E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc2130E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2130E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2130E(Test__ZN4aaaa6dc2130E, "_ZN4aaaa6dc2130E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc2130E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2130E = {  "_ZN4aaaa6dc2130E", // class name
  bases__ZN4aaaa6dc2130E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2131  : ::aaaa::aa2 , ::aaaa::bb1 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc2131E) C1{ BC2{} BC3{ Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2131E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2131E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa6dc2131E, buf);
    ::aaaa::dc2131 &lv = *(new (buf) ::aaaa::dc2131());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa6dc2131E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2131E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2131E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa6dc2131E");
    check_base_class_offset(lv, (::aaaa::cc3*), 2, "_ZN4aaaa6dc2131E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc2131E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2131E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2131E(Test__ZN4aaaa6dc2131E, "_ZN4aaaa6dc2131E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc2131E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2131E = {  "_ZN4aaaa6dc2131E", // class name
  bases__ZN4aaaa6dc2131E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2132  : ::aaaa::aa2 , ::aaaa::bb1 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc2132E) C1{ BC2{} BC3{ Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2132E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2132E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa6dc2132E, buf);
    ::aaaa::dc2132 &lv = *(new (buf) ::aaaa::dc2132());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa6dc2132E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2132E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2132E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa6dc2132E");
    check_base_class_offset(lv, (::aaaa::cc3*), 2, "_ZN4aaaa6dc2132E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc2132E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2132E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2132E(Test__ZN4aaaa6dc2132E, "_ZN4aaaa6dc2132E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc2132E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2132E = {  "_ZN4aaaa6dc2132E", // class name
  bases__ZN4aaaa6dc2132E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2133  : ::aaaa::aa2 , ::aaaa::bb1 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc2133E) C1{ BC2{} BC3{ Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2133E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2133E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa6dc2133E, buf);
    ::aaaa::dc2133 &lv = *(new (buf) ::aaaa::dc2133());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa6dc2133E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2133E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2133E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa6dc2133E");
    check_base_class_offset(lv, (::aaaa::cc3*), 2, "_ZN4aaaa6dc2133E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc2133E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2133E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2133E(Test__ZN4aaaa6dc2133E, "_ZN4aaaa6dc2133E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc2133E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2133E = {  "_ZN4aaaa6dc2133E", // class name
  bases__ZN4aaaa6dc2133E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2134  : ::aaaa::aa2 , ::aaaa::bb1 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc2134E) C1{ BC2{} BC3{ Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2134E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2134E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa6dc2134E, buf);
    ::aaaa::dc2134 &lv = *(new (buf) ::aaaa::dc2134());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa6dc2134E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2134E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2134E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa6dc2134E");
    check_base_class_offset(lv, (::aaaa::cc3*), 2, "_ZN4aaaa6dc2134E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc2134E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2134E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2134E(Test__ZN4aaaa6dc2134E, "_ZN4aaaa6dc2134E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc2134E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2134E = {  "_ZN4aaaa6dc2134E", // class name
  bases__ZN4aaaa6dc2134E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2135  : ::aaaa::aa2 , ::aaaa::bb1 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc2135E) C1{ BC2{} BC3{ Fc} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2135E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2135E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa6dc2135E, buf);
    ::aaaa::dc2135 &lv = *(new (buf) ::aaaa::dc2135());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa6dc2135E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2135E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2135E");
    check_base_class_offset(lv, (::aaaa::bb1*), 0, "_ZN4aaaa6dc2135E");
    check_base_class_offset(lv, (::aaaa::cc3*), 2, "_ZN4aaaa6dc2135E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc2135E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2135E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2135E(Test__ZN4aaaa6dc2135E, "_ZN4aaaa6dc2135E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb1E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc2135E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2135E = {  "_ZN4aaaa6dc2135E", // class name
  bases__ZN4aaaa6dc2135E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db220  : ::aaaa::aa2 , ::aaaa::bb2 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db220E) C1{ BC2{} BC3{} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db220E()
{
  extern Class_Descriptor cd__ZN4aaaa5db220E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa5db220E, buf);
    ::aaaa::db220 &lv = *(new (buf) ::aaaa::db220());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa5db220E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa5db220E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa5db220E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa5db220E");
    check_field_offset(lv, xc, 0, "_ZN4aaaa5db220E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db220E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db220E(Test__ZN4aaaa5db220E, "_ZN4aaaa5db220E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
static Base_Class bases__ZN4aaaa5db220E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db220E = {  "_ZN4aaaa5db220E", // class name
  bases__ZN4aaaa5db220E, 2,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db221  : ::aaaa::aa2 , ::aaaa::bb2 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db221E) C1{ BC2{} BC3{} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db221E()
{
  extern Class_Descriptor cd__ZN4aaaa5db221E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa5db221E, buf);
    ::aaaa::db221 &lv = *(new (buf) ::aaaa::db221());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa5db221E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa5db221E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa5db221E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa5db221E");
    check_field_offset(lv, xc, 0, "_ZN4aaaa5db221E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db221E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db221E(Test__ZN4aaaa5db221E, "_ZN4aaaa5db221E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
static Base_Class bases__ZN4aaaa5db221E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db221E = {  "_ZN4aaaa5db221E", // class name
  bases__ZN4aaaa5db221E, 2,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db222  : ::aaaa::aa2 , ::aaaa::bb2 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db222E) C1{ BC2{} BC3{} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db222E()
{
  extern Class_Descriptor cd__ZN4aaaa5db222E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa5db222E, buf);
    ::aaaa::db222 &lv = *(new (buf) ::aaaa::db222());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa5db222E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa5db222E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa5db222E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa5db222E");
    check_field_offset(lv, xc, 0, "_ZN4aaaa5db222E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db222E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db222E(Test__ZN4aaaa5db222E, "_ZN4aaaa5db222E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
static Base_Class bases__ZN4aaaa5db222E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db222E = {  "_ZN4aaaa5db222E", // class name
  bases__ZN4aaaa5db222E, 2,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db223  : ::aaaa::aa2 , ::aaaa::bb2 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db223E) C1{ BC2{} BC3{} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db223E()
{
  extern Class_Descriptor cd__ZN4aaaa5db223E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa5db223E, buf);
    ::aaaa::db223 &lv = *(new (buf) ::aaaa::db223());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa5db223E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa5db223E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa5db223E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa5db223E");
    check_field_offset(lv, xc, 0, "_ZN4aaaa5db223E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db223E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db223E(Test__ZN4aaaa5db223E, "_ZN4aaaa5db223E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
static Base_Class bases__ZN4aaaa5db223E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db223E = {  "_ZN4aaaa5db223E", // class name
  bases__ZN4aaaa5db223E, 2,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db224  : ::aaaa::aa2 , ::aaaa::bb2 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db224E) C1{ BC2{} BC3{} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db224E()
{
  extern Class_Descriptor cd__ZN4aaaa5db224E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa5db224E, buf);
    ::aaaa::db224 &lv = *(new (buf) ::aaaa::db224());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa5db224E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa5db224E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa5db224E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa5db224E");
    check_field_offset(lv, xc, 0, "_ZN4aaaa5db224E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db224E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db224E(Test__ZN4aaaa5db224E, "_ZN4aaaa5db224E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
static Base_Class bases__ZN4aaaa5db224E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db224E = {  "_ZN4aaaa5db224E", // class name
  bases__ZN4aaaa5db224E, 2,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db225  : ::aaaa::aa2 , ::aaaa::bb2 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db225E) C1{ BC2{} BC3{} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db225E()
{
  extern Class_Descriptor cd__ZN4aaaa5db225E;
  void *lvp;
  {
    char buf[3];
    init_test(&cd__ZN4aaaa5db225E, buf);
    ::aaaa::db225 &lv = *(new (buf) ::aaaa::db225());
    lvp = (void*)&lv;
    check2(sizeof(lv), 3, "sizeof(_ZN4aaaa5db225E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa5db225E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa5db225E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa5db225E");
    check_field_offset(lv, xc, 0, "_ZN4aaaa5db225E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db225E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db225E(Test__ZN4aaaa5db225E, "_ZN4aaaa5db225E", 3);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
static Base_Class bases__ZN4aaaa5db225E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db225E = {  "_ZN4aaaa5db225E", // class name
  bases__ZN4aaaa5db225E, 2,
  0, // no vftv
  0, //no vtt
  3, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2200  : ::aaaa::aa2 , ::aaaa::bb2 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc2200E) C1{ BC2{} BC3{} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2200E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2200E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4aaaa6dc2200E, buf);
    ::aaaa::dc2200 &lv = *(new (buf) ::aaaa::dc2200());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4aaaa6dc2200E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2200E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2200E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc2200E");
    check_base_class_offset(lv, (::aaaa::cc0*), 0, "_ZN4aaaa6dc2200E");
    test_class_info(&lv, &cd__ZN4aaaa6dc2200E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2200E(Test__ZN4aaaa6dc2200E, "_ZN4aaaa6dc2200E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc2200E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2200E = {  "_ZN4aaaa6dc2200E", // class name
  bases__ZN4aaaa6dc2200E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2201  : ::aaaa::aa2 , ::aaaa::bb2 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc2201E) C1{ BC2{} BC3{} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2201E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2201E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4aaaa6dc2201E, buf);
    ::aaaa::dc2201 &lv = *(new (buf) ::aaaa::dc2201());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4aaaa6dc2201E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2201E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2201E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc2201E");
    check_base_class_offset(lv, (::aaaa::cc0*), 0, "_ZN4aaaa6dc2201E");
    test_class_info(&lv, &cd__ZN4aaaa6dc2201E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2201E(Test__ZN4aaaa6dc2201E, "_ZN4aaaa6dc2201E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc2201E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2201E = {  "_ZN4aaaa6dc2201E", // class name
  bases__ZN4aaaa6dc2201E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2202  : ::aaaa::aa2 , ::aaaa::bb2 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc2202E) C1{ BC2{} BC3{} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2202E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2202E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4aaaa6dc2202E, buf);
    ::aaaa::dc2202 &lv = *(new (buf) ::aaaa::dc2202());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4aaaa6dc2202E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2202E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2202E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc2202E");
    check_base_class_offset(lv, (::aaaa::cc0*), 0, "_ZN4aaaa6dc2202E");
    test_class_info(&lv, &cd__ZN4aaaa6dc2202E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2202E(Test__ZN4aaaa6dc2202E, "_ZN4aaaa6dc2202E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc2202E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2202E = {  "_ZN4aaaa6dc2202E", // class name
  bases__ZN4aaaa6dc2202E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2203  : ::aaaa::aa2 , ::aaaa::bb2 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc2203E) C1{ BC2{} BC3{} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2203E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2203E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4aaaa6dc2203E, buf);
    ::aaaa::dc2203 &lv = *(new (buf) ::aaaa::dc2203());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4aaaa6dc2203E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2203E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2203E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc2203E");
    check_base_class_offset(lv, (::aaaa::cc0*), 0, "_ZN4aaaa6dc2203E");
    test_class_info(&lv, &cd__ZN4aaaa6dc2203E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2203E(Test__ZN4aaaa6dc2203E, "_ZN4aaaa6dc2203E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc2203E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2203E = {  "_ZN4aaaa6dc2203E", // class name
  bases__ZN4aaaa6dc2203E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2204  : ::aaaa::aa2 , ::aaaa::bb2 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc2204E) C1{ BC2{} BC3{} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2204E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2204E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4aaaa6dc2204E, buf);
    ::aaaa::dc2204 &lv = *(new (buf) ::aaaa::dc2204());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4aaaa6dc2204E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2204E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2204E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc2204E");
    check_base_class_offset(lv, (::aaaa::cc0*), 0, "_ZN4aaaa6dc2204E");
    test_class_info(&lv, &cd__ZN4aaaa6dc2204E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2204E(Test__ZN4aaaa6dc2204E, "_ZN4aaaa6dc2204E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc2204E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2204E = {  "_ZN4aaaa6dc2204E", // class name
  bases__ZN4aaaa6dc2204E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2205  : ::aaaa::aa2 , ::aaaa::bb2 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc2205E) C1{ BC2{} BC3{} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2205E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2205E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd__ZN4aaaa6dc2205E, buf);
    ::aaaa::dc2205 &lv = *(new (buf) ::aaaa::dc2205());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(_ZN4aaaa6dc2205E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2205E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2205E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc2205E");
    check_base_class_offset(lv, (::aaaa::cc0*), 0, "_ZN4aaaa6dc2205E");
    test_class_info(&lv, &cd__ZN4aaaa6dc2205E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2205E(Test__ZN4aaaa6dc2205E, "_ZN4aaaa6dc2205E", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc2205E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2205E = {  "_ZN4aaaa6dc2205E", // class name
  bases__ZN4aaaa6dc2205E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2210  : ::aaaa::aa2 , ::aaaa::bb2 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc2210E) C1{ BC2{} BC3{} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2210E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2210E;
  void *lvp;
  {
    char buf[2];
    init_test(&cd__ZN4aaaa6dc2210E, buf);
    ::aaaa::dc2210 &lv = *(new (buf) ::aaaa::dc2210());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4aaaa6dc2210E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc2210E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2210E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc2210E");
    check_base_class_offset(lv, (::aaaa::cc1*), 0, "_ZN4aaaa6dc2210E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa6dc2210E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2210E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2210E(Test__ZN4aaaa6dc2210E, "_ZN4aaaa6dc2210E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc2210E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2210E = {  "_ZN4aaaa6dc2210E", // class name
  bases__ZN4aaaa6dc2210E, 3,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2211  : ::aaaa::aa2 , ::aaaa::bb2 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc2211E) C1{ BC2{} BC3{} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2211E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2211E;
  void *lvp;
  {
    char buf[2];
    init_test(&cd__ZN4aaaa6dc2211E, buf);
    ::aaaa::dc2211 &lv = *(new (buf) ::aaaa::dc2211());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4aaaa6dc2211E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc2211E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2211E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc2211E");
    check_base_class_offset(lv, (::aaaa::cc1*), 0, "_ZN4aaaa6dc2211E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa6dc2211E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2211E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2211E(Test__ZN4aaaa6dc2211E, "_ZN4aaaa6dc2211E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc2211E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2211E = {  "_ZN4aaaa6dc2211E", // class name
  bases__ZN4aaaa6dc2211E, 3,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2212  : ::aaaa::aa2 , ::aaaa::bb2 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc2212E) C1{ BC2{} BC3{} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2212E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2212E;
  void *lvp;
  {
    char buf[2];
    init_test(&cd__ZN4aaaa6dc2212E, buf);
    ::aaaa::dc2212 &lv = *(new (buf) ::aaaa::dc2212());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4aaaa6dc2212E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc2212E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2212E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc2212E");
    check_base_class_offset(lv, (::aaaa::cc1*), 0, "_ZN4aaaa6dc2212E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa6dc2212E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2212E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2212E(Test__ZN4aaaa6dc2212E, "_ZN4aaaa6dc2212E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc2212E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2212E = {  "_ZN4aaaa6dc2212E", // class name
  bases__ZN4aaaa6dc2212E, 3,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2213  : ::aaaa::aa2 , ::aaaa::bb2 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc2213E) C1{ BC2{} BC3{} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2213E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2213E;
  void *lvp;
  {
    char buf[2];
    init_test(&cd__ZN4aaaa6dc2213E, buf);
    ::aaaa::dc2213 &lv = *(new (buf) ::aaaa::dc2213());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4aaaa6dc2213E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc2213E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2213E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc2213E");
    check_base_class_offset(lv, (::aaaa::cc1*), 0, "_ZN4aaaa6dc2213E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa6dc2213E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2213E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2213E(Test__ZN4aaaa6dc2213E, "_ZN4aaaa6dc2213E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc2213E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2213E = {  "_ZN4aaaa6dc2213E", // class name
  bases__ZN4aaaa6dc2213E, 3,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2214  : ::aaaa::aa2 , ::aaaa::bb2 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc2214E) C1{ BC2{} BC3{} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2214E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2214E;
  void *lvp;
  {
    char buf[2];
    init_test(&cd__ZN4aaaa6dc2214E, buf);
    ::aaaa::dc2214 &lv = *(new (buf) ::aaaa::dc2214());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4aaaa6dc2214E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc2214E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2214E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc2214E");
    check_base_class_offset(lv, (::aaaa::cc1*), 0, "_ZN4aaaa6dc2214E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa6dc2214E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2214E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2214E(Test__ZN4aaaa6dc2214E, "_ZN4aaaa6dc2214E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc2214E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2214E = {  "_ZN4aaaa6dc2214E", // class name
  bases__ZN4aaaa6dc2214E, 3,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2215  : ::aaaa::aa2 , ::aaaa::bb2 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc2215E) C1{ BC2{} BC3{} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2215E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2215E;
  void *lvp;
  {
    char buf[2];
    init_test(&cd__ZN4aaaa6dc2215E, buf);
    ::aaaa::dc2215 &lv = *(new (buf) ::aaaa::dc2215());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4aaaa6dc2215E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc2215E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2215E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc2215E");
    check_base_class_offset(lv, (::aaaa::cc1*), 0, "_ZN4aaaa6dc2215E");
    check_field_offset(lv, xc, 1, "_ZN4aaaa6dc2215E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2215E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2215E(Test__ZN4aaaa6dc2215E, "_ZN4aaaa6dc2215E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc2215E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2215E = {  "_ZN4aaaa6dc2215E", // class name
  bases__ZN4aaaa6dc2215E, 3,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2220  : ::aaaa::aa2 , ::aaaa::bb2 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc2220E) C1{ BC2{} BC3{} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2220E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2220E;
  void *lvp;
  {
    char buf[2];
    init_test(&cd__ZN4aaaa6dc2220E, buf);
    ::aaaa::dc2220 &lv = *(new (buf) ::aaaa::dc2220());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4aaaa6dc2220E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc2220E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2220E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc2220E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc2220E");
    check_field_offset(lv, xc, 0, "_ZN4aaaa6dc2220E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2220E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2220E(Test__ZN4aaaa6dc2220E, "_ZN4aaaa6dc2220E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc2220E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2220E = {  "_ZN4aaaa6dc2220E", // class name
  bases__ZN4aaaa6dc2220E, 3,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2221  : ::aaaa::aa2 , ::aaaa::bb2 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc2221E) C1{ BC2{} BC3{} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2221E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2221E;
  void *lvp;
  {
    char buf[2];
    init_test(&cd__ZN4aaaa6dc2221E, buf);
    ::aaaa::dc2221 &lv = *(new (buf) ::aaaa::dc2221());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4aaaa6dc2221E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc2221E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2221E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc2221E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc2221E");
    check_field_offset(lv, xc, 0, "_ZN4aaaa6dc2221E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2221E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2221E(Test__ZN4aaaa6dc2221E, "_ZN4aaaa6dc2221E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc2221E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2221E = {  "_ZN4aaaa6dc2221E", // class name
  bases__ZN4aaaa6dc2221E, 3,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2222  : ::aaaa::aa2 , ::aaaa::bb2 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc2222E) C1{ BC2{} BC3{} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2222E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2222E;
  void *lvp;
  {
    char buf[2];
    init_test(&cd__ZN4aaaa6dc2222E, buf);
    ::aaaa::dc2222 &lv = *(new (buf) ::aaaa::dc2222());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4aaaa6dc2222E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc2222E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2222E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc2222E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc2222E");
    check_field_offset(lv, xc, 0, "_ZN4aaaa6dc2222E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2222E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2222E(Test__ZN4aaaa6dc2222E, "_ZN4aaaa6dc2222E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc2222E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2222E = {  "_ZN4aaaa6dc2222E", // class name
  bases__ZN4aaaa6dc2222E, 3,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2223  : ::aaaa::aa2 , ::aaaa::bb2 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc2223E) C1{ BC2{} BC3{} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2223E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2223E;
  void *lvp;
  {
    char buf[2];
    init_test(&cd__ZN4aaaa6dc2223E, buf);
    ::aaaa::dc2223 &lv = *(new (buf) ::aaaa::dc2223());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4aaaa6dc2223E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc2223E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2223E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc2223E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc2223E");
    check_field_offset(lv, xc, 0, "_ZN4aaaa6dc2223E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2223E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2223E(Test__ZN4aaaa6dc2223E, "_ZN4aaaa6dc2223E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc2223E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2223E = {  "_ZN4aaaa6dc2223E", // class name
  bases__ZN4aaaa6dc2223E, 3,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2224  : ::aaaa::aa2 , ::aaaa::bb2 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc2224E) C1{ BC2{} BC3{} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2224E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2224E;
  void *lvp;
  {
    char buf[2];
    init_test(&cd__ZN4aaaa6dc2224E, buf);
    ::aaaa::dc2224 &lv = *(new (buf) ::aaaa::dc2224());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4aaaa6dc2224E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc2224E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2224E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc2224E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc2224E");
    check_field_offset(lv, xc, 0, "_ZN4aaaa6dc2224E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2224E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2224E(Test__ZN4aaaa6dc2224E, "_ZN4aaaa6dc2224E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc2224E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2224E = {  "_ZN4aaaa6dc2224E", // class name
  bases__ZN4aaaa6dc2224E, 3,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2225  : ::aaaa::aa2 , ::aaaa::bb2 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc2225E) C1{ BC2{} BC3{} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2225E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2225E;
  void *lvp;
  {
    char buf[2];
    init_test(&cd__ZN4aaaa6dc2225E, buf);
    ::aaaa::dc2225 &lv = *(new (buf) ::aaaa::dc2225());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(_ZN4aaaa6dc2225E)");
    check2(__alignof__(lv), 1, "__alignof__(_ZN4aaaa6dc2225E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2225E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc2225E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc2225E");
    check_field_offset(lv, xc, 0, "_ZN4aaaa6dc2225E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2225E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2225E(Test__ZN4aaaa6dc2225E, "_ZN4aaaa6dc2225E", 2);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc2225E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2225E = {  "_ZN4aaaa6dc2225E", // class name
  bases__ZN4aaaa6dc2225E, 3,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2230  : ::aaaa::aa2 , ::aaaa::bb2 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc2230E) C1{ BC2{} BC3{} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2230E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2230E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4aaaa6dc2230E, buf);
    ::aaaa::dc2230 &lv = *(new (buf) ::aaaa::dc2230());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4aaaa6dc2230E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2230E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2230E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc2230E");
    check_base_class_offset(lv, (::aaaa::cc3*), 0, "_ZN4aaaa6dc2230E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc2230E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2230E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2230E(Test__ZN4aaaa6dc2230E, "_ZN4aaaa6dc2230E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc2230E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2230E = {  "_ZN4aaaa6dc2230E", // class name
  bases__ZN4aaaa6dc2230E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2231  : ::aaaa::aa2 , ::aaaa::bb2 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc2231E) C1{ BC2{} BC3{} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2231E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2231E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4aaaa6dc2231E, buf);
    ::aaaa::dc2231 &lv = *(new (buf) ::aaaa::dc2231());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4aaaa6dc2231E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2231E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2231E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc2231E");
    check_base_class_offset(lv, (::aaaa::cc3*), 0, "_ZN4aaaa6dc2231E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc2231E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2231E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2231E(Test__ZN4aaaa6dc2231E, "_ZN4aaaa6dc2231E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc2231E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2231E = {  "_ZN4aaaa6dc2231E", // class name
  bases__ZN4aaaa6dc2231E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2232  : ::aaaa::aa2 , ::aaaa::bb2 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc2232E) C1{ BC2{} BC3{} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2232E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2232E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4aaaa6dc2232E, buf);
    ::aaaa::dc2232 &lv = *(new (buf) ::aaaa::dc2232());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4aaaa6dc2232E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2232E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2232E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc2232E");
    check_base_class_offset(lv, (::aaaa::cc3*), 0, "_ZN4aaaa6dc2232E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc2232E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2232E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2232E(Test__ZN4aaaa6dc2232E, "_ZN4aaaa6dc2232E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc2232E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2232E = {  "_ZN4aaaa6dc2232E", // class name
  bases__ZN4aaaa6dc2232E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2233  : ::aaaa::aa2 , ::aaaa::bb2 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc2233E) C1{ BC2{} BC3{} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2233E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2233E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4aaaa6dc2233E, buf);
    ::aaaa::dc2233 &lv = *(new (buf) ::aaaa::dc2233());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4aaaa6dc2233E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2233E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2233E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc2233E");
    check_base_class_offset(lv, (::aaaa::cc3*), 0, "_ZN4aaaa6dc2233E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc2233E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2233E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2233E(Test__ZN4aaaa6dc2233E, "_ZN4aaaa6dc2233E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc2233E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2233E = {  "_ZN4aaaa6dc2233E", // class name
  bases__ZN4aaaa6dc2233E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2234  : ::aaaa::aa2 , ::aaaa::bb2 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc2234E) C1{ BC2{} BC3{} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2234E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2234E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4aaaa6dc2234E, buf);
    ::aaaa::dc2234 &lv = *(new (buf) ::aaaa::dc2234());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4aaaa6dc2234E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2234E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2234E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc2234E");
    check_base_class_offset(lv, (::aaaa::cc3*), 0, "_ZN4aaaa6dc2234E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc2234E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2234E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2234E(Test__ZN4aaaa6dc2234E, "_ZN4aaaa6dc2234E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc2234E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2234E = {  "_ZN4aaaa6dc2234E", // class name
  bases__ZN4aaaa6dc2234E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2235  : ::aaaa::aa2 , ::aaaa::bb2 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc2235E) C1{ BC2{} BC3{} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2235E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2235E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4aaaa6dc2235E, buf);
    ::aaaa::dc2235 &lv = *(new (buf) ::aaaa::dc2235());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4aaaa6dc2235E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2235E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2235E");
    check_base_class_offset(lv, (::aaaa::bb2*), 0, "_ZN4aaaa6dc2235E");
    check_base_class_offset(lv, (::aaaa::cc3*), 0, "_ZN4aaaa6dc2235E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc2235E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2235E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2235E(Test__ZN4aaaa6dc2235E, "_ZN4aaaa6dc2235E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb2E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc2235E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2235E = {  "_ZN4aaaa6dc2235E", // class name
  bases__ZN4aaaa6dc2235E, 3,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db230  : ::aaaa::aa2 , ::aaaa::bb3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db230E) C1{ BC2{} BC3{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db230E()
{
  extern Class_Descriptor cd__ZN4aaaa5db230E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4aaaa5db230E, buf);
    ::aaaa::db230 &lv = *(new (buf) ::aaaa::db230());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4aaaa5db230E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa5db230E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa5db230E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa5db230E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa5db230E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db230E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db230E(Test__ZN4aaaa5db230E, "_ZN4aaaa5db230E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
static Base_Class bases__ZN4aaaa5db230E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db230E = {  "_ZN4aaaa5db230E", // class name
  bases__ZN4aaaa5db230E, 2,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db231  : ::aaaa::aa2 , ::aaaa::bb3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db231E) C1{ BC2{} BC3{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db231E()
{
  extern Class_Descriptor cd__ZN4aaaa5db231E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4aaaa5db231E, buf);
    ::aaaa::db231 &lv = *(new (buf) ::aaaa::db231());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4aaaa5db231E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa5db231E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa5db231E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa5db231E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa5db231E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db231E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db231E(Test__ZN4aaaa5db231E, "_ZN4aaaa5db231E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
static Base_Class bases__ZN4aaaa5db231E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db231E = {  "_ZN4aaaa5db231E", // class name
  bases__ZN4aaaa5db231E, 2,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db232  : ::aaaa::aa2 , ::aaaa::bb3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db232E) C1{ BC2{} BC3{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db232E()
{
  extern Class_Descriptor cd__ZN4aaaa5db232E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4aaaa5db232E, buf);
    ::aaaa::db232 &lv = *(new (buf) ::aaaa::db232());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4aaaa5db232E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa5db232E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa5db232E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa5db232E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa5db232E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db232E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db232E(Test__ZN4aaaa5db232E, "_ZN4aaaa5db232E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
static Base_Class bases__ZN4aaaa5db232E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db232E = {  "_ZN4aaaa5db232E", // class name
  bases__ZN4aaaa5db232E, 2,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db233  : ::aaaa::aa2 , ::aaaa::bb3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db233E) C1{ BC2{} BC3{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db233E()
{
  extern Class_Descriptor cd__ZN4aaaa5db233E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4aaaa5db233E, buf);
    ::aaaa::db233 &lv = *(new (buf) ::aaaa::db233());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4aaaa5db233E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa5db233E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa5db233E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa5db233E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa5db233E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db233E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db233E(Test__ZN4aaaa5db233E, "_ZN4aaaa5db233E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
static Base_Class bases__ZN4aaaa5db233E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db233E = {  "_ZN4aaaa5db233E", // class name
  bases__ZN4aaaa5db233E, 2,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db234  : ::aaaa::aa2 , ::aaaa::bb3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db234E) C1{ BC2{} BC3{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db234E()
{
  extern Class_Descriptor cd__ZN4aaaa5db234E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4aaaa5db234E, buf);
    ::aaaa::db234 &lv = *(new (buf) ::aaaa::db234());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4aaaa5db234E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa5db234E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa5db234E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa5db234E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa5db234E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db234E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db234E(Test__ZN4aaaa5db234E, "_ZN4aaaa5db234E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
static Base_Class bases__ZN4aaaa5db234E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db234E = {  "_ZN4aaaa5db234E", // class name
  bases__ZN4aaaa5db234E, 2,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  db235  : ::aaaa::aa2 , ::aaaa::bb3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa5db235E) C1{ BC2{} BC3{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa5db235E()
{
  extern Class_Descriptor cd__ZN4aaaa5db235E;
  void *lvp;
  {
    short buf[4];
    init_test(&cd__ZN4aaaa5db235E, buf);
    ::aaaa::db235 &lv = *(new (buf) ::aaaa::db235());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(_ZN4aaaa5db235E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa5db235E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa5db235E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa5db235E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa5db235E.xc");
    test_class_info(&lv, &cd__ZN4aaaa5db235E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa5db235E(Test__ZN4aaaa5db235E, "_ZN4aaaa5db235E", 6);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
static Base_Class bases__ZN4aaaa5db235E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa5db235E = {  "_ZN4aaaa5db235E", // class name
  bases__ZN4aaaa5db235E, 2,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2300  : ::aaaa::aa2 , ::aaaa::bb3 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc2300E) C1{ BC2{} BC3{ Fs} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2300E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2300E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc2300E, buf);
    ::aaaa::dc2300 &lv = *(new (buf) ::aaaa::dc2300());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc2300E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2300E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2300E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa6dc2300E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc2300E");
    test_class_info(&lv, &cd__ZN4aaaa6dc2300E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2300E(Test__ZN4aaaa6dc2300E, "_ZN4aaaa6dc2300E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc2300E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2300E = {  "_ZN4aaaa6dc2300E", // class name
  bases__ZN4aaaa6dc2300E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2301  : ::aaaa::aa2 , ::aaaa::bb3 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc2301E) C1{ BC2{} BC3{ Fs} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2301E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2301E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc2301E, buf);
    ::aaaa::dc2301 &lv = *(new (buf) ::aaaa::dc2301());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc2301E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2301E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2301E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa6dc2301E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc2301E");
    test_class_info(&lv, &cd__ZN4aaaa6dc2301E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2301E(Test__ZN4aaaa6dc2301E, "_ZN4aaaa6dc2301E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc2301E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2301E = {  "_ZN4aaaa6dc2301E", // class name
  bases__ZN4aaaa6dc2301E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2302  : ::aaaa::aa2 , ::aaaa::bb3 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc2302E) C1{ BC2{} BC3{ Fs} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2302E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2302E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc2302E, buf);
    ::aaaa::dc2302 &lv = *(new (buf) ::aaaa::dc2302());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc2302E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2302E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2302E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa6dc2302E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc2302E");
    test_class_info(&lv, &cd__ZN4aaaa6dc2302E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2302E(Test__ZN4aaaa6dc2302E, "_ZN4aaaa6dc2302E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc2302E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2302E = {  "_ZN4aaaa6dc2302E", // class name
  bases__ZN4aaaa6dc2302E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2303  : ::aaaa::aa2 , ::aaaa::bb3 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc2303E) C1{ BC2{} BC3{ Fs} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2303E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2303E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc2303E, buf);
    ::aaaa::dc2303 &lv = *(new (buf) ::aaaa::dc2303());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc2303E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2303E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2303E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa6dc2303E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc2303E");
    test_class_info(&lv, &cd__ZN4aaaa6dc2303E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2303E(Test__ZN4aaaa6dc2303E, "_ZN4aaaa6dc2303E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc2303E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2303E = {  "_ZN4aaaa6dc2303E", // class name
  bases__ZN4aaaa6dc2303E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2304  : ::aaaa::aa2 , ::aaaa::bb3 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc2304E) C1{ BC2{} BC3{ Fs} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2304E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2304E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc2304E, buf);
    ::aaaa::dc2304 &lv = *(new (buf) ::aaaa::dc2304());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc2304E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2304E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2304E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa6dc2304E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc2304E");
    test_class_info(&lv, &cd__ZN4aaaa6dc2304E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2304E(Test__ZN4aaaa6dc2304E, "_ZN4aaaa6dc2304E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc2304E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2304E = {  "_ZN4aaaa6dc2304E", // class name
  bases__ZN4aaaa6dc2304E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2305  : ::aaaa::aa2 , ::aaaa::bb3 , ::aaaa::cc0 {
};
//SIG(1 _ZN4aaaa6dc2305E) C1{ BC2{} BC3{ Fs} BC4{ FL Fc}}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2305E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2305E;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd__ZN4aaaa6dc2305E, buf);
    ::aaaa::dc2305 &lv = *(new (buf) ::aaaa::dc2305());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(_ZN4aaaa6dc2305E)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(_ZN4aaaa6dc2305E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2305E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa6dc2305E");
    check_base_class_offset(lv, (::aaaa::cc0*), ABISELECT(8,4), "_ZN4aaaa6dc2305E");
    test_class_info(&lv, &cd__ZN4aaaa6dc2305E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2305E(Test__ZN4aaaa6dc2305E, "_ZN4aaaa6dc2305E", ABISELECT(24,16));

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc0E;
static Base_Class bases__ZN4aaaa6dc2305E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc0E,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2305E = {  "_ZN4aaaa6dc2305E", // class name
  bases__ZN4aaaa6dc2305E, 3,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,16), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2310  : ::aaaa::aa2 , ::aaaa::bb3 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc2310E) C1{ BC2{} BC3{ Fs} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2310E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2310E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4aaaa6dc2310E, buf);
    ::aaaa::dc2310 &lv = *(new (buf) ::aaaa::dc2310());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa6dc2310E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2310E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2310E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa6dc2310E");
    check_base_class_offset(lv, (::aaaa::cc1*), 2, "_ZN4aaaa6dc2310E");
    check_field_offset(lv, xc, 3, "_ZN4aaaa6dc2310E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2310E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2310E(Test__ZN4aaaa6dc2310E, "_ZN4aaaa6dc2310E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc2310E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2310E = {  "_ZN4aaaa6dc2310E", // class name
  bases__ZN4aaaa6dc2310E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2311  : ::aaaa::aa2 , ::aaaa::bb3 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc2311E) C1{ BC2{} BC3{ Fs} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2311E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2311E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4aaaa6dc2311E, buf);
    ::aaaa::dc2311 &lv = *(new (buf) ::aaaa::dc2311());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa6dc2311E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2311E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2311E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa6dc2311E");
    check_base_class_offset(lv, (::aaaa::cc1*), 2, "_ZN4aaaa6dc2311E");
    check_field_offset(lv, xc, 3, "_ZN4aaaa6dc2311E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2311E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2311E(Test__ZN4aaaa6dc2311E, "_ZN4aaaa6dc2311E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc2311E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2311E = {  "_ZN4aaaa6dc2311E", // class name
  bases__ZN4aaaa6dc2311E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2312  : ::aaaa::aa2 , ::aaaa::bb3 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc2312E) C1{ BC2{} BC3{ Fs} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2312E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2312E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4aaaa6dc2312E, buf);
    ::aaaa::dc2312 &lv = *(new (buf) ::aaaa::dc2312());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa6dc2312E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2312E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2312E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa6dc2312E");
    check_base_class_offset(lv, (::aaaa::cc1*), 2, "_ZN4aaaa6dc2312E");
    check_field_offset(lv, xc, 3, "_ZN4aaaa6dc2312E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2312E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2312E(Test__ZN4aaaa6dc2312E, "_ZN4aaaa6dc2312E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc2312E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2312E = {  "_ZN4aaaa6dc2312E", // class name
  bases__ZN4aaaa6dc2312E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2313  : ::aaaa::aa2 , ::aaaa::bb3 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc2313E) C1{ BC2{} BC3{ Fs} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2313E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2313E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4aaaa6dc2313E, buf);
    ::aaaa::dc2313 &lv = *(new (buf) ::aaaa::dc2313());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa6dc2313E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2313E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2313E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa6dc2313E");
    check_base_class_offset(lv, (::aaaa::cc1*), 2, "_ZN4aaaa6dc2313E");
    check_field_offset(lv, xc, 3, "_ZN4aaaa6dc2313E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2313E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2313E(Test__ZN4aaaa6dc2313E, "_ZN4aaaa6dc2313E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc2313E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2313E = {  "_ZN4aaaa6dc2313E", // class name
  bases__ZN4aaaa6dc2313E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2314  : ::aaaa::aa2 , ::aaaa::bb3 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc2314E) C1{ BC2{} BC3{ Fs} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2314E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2314E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4aaaa6dc2314E, buf);
    ::aaaa::dc2314 &lv = *(new (buf) ::aaaa::dc2314());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa6dc2314E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2314E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2314E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa6dc2314E");
    check_base_class_offset(lv, (::aaaa::cc1*), 2, "_ZN4aaaa6dc2314E");
    check_field_offset(lv, xc, 3, "_ZN4aaaa6dc2314E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2314E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2314E(Test__ZN4aaaa6dc2314E, "_ZN4aaaa6dc2314E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc2314E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2314E = {  "_ZN4aaaa6dc2314E", // class name
  bases__ZN4aaaa6dc2314E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2315  : ::aaaa::aa2 , ::aaaa::bb3 , ::aaaa::cc1 {
  char xc;
};
//SIG(1 _ZN4aaaa6dc2315E) C1{ BC2{} BC3{ Fs} BC4{ Fc} Fc}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2315E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2315E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4aaaa6dc2315E, buf);
    ::aaaa::dc2315 &lv = *(new (buf) ::aaaa::dc2315());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa6dc2315E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2315E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2315E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa6dc2315E");
    check_base_class_offset(lv, (::aaaa::cc1*), 2, "_ZN4aaaa6dc2315E");
    check_field_offset(lv, xc, 3, "_ZN4aaaa6dc2315E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2315E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2315E(Test__ZN4aaaa6dc2315E, "_ZN4aaaa6dc2315E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc1E;
static Base_Class bases__ZN4aaaa6dc2315E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc1E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2315E = {  "_ZN4aaaa6dc2315E", // class name
  bases__ZN4aaaa6dc2315E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2320  : ::aaaa::aa2 , ::aaaa::bb3 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc2320E) C1{ BC2{} BC3{ Fs} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2320E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2320E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4aaaa6dc2320E, buf);
    ::aaaa::dc2320 &lv = *(new (buf) ::aaaa::dc2320());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa6dc2320E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2320E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2320E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa6dc2320E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc2320E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc2320E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2320E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2320E(Test__ZN4aaaa6dc2320E, "_ZN4aaaa6dc2320E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc2320E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2320E = {  "_ZN4aaaa6dc2320E", // class name
  bases__ZN4aaaa6dc2320E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2321  : ::aaaa::aa2 , ::aaaa::bb3 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc2321E) C1{ BC2{} BC3{ Fs} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2321E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2321E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4aaaa6dc2321E, buf);
    ::aaaa::dc2321 &lv = *(new (buf) ::aaaa::dc2321());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa6dc2321E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2321E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2321E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa6dc2321E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc2321E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc2321E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2321E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2321E(Test__ZN4aaaa6dc2321E, "_ZN4aaaa6dc2321E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc2321E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2321E = {  "_ZN4aaaa6dc2321E", // class name
  bases__ZN4aaaa6dc2321E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2322  : ::aaaa::aa2 , ::aaaa::bb3 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc2322E) C1{ BC2{} BC3{ Fs} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2322E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2322E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4aaaa6dc2322E, buf);
    ::aaaa::dc2322 &lv = *(new (buf) ::aaaa::dc2322());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa6dc2322E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2322E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2322E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa6dc2322E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc2322E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc2322E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2322E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2322E(Test__ZN4aaaa6dc2322E, "_ZN4aaaa6dc2322E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc2322E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2322E = {  "_ZN4aaaa6dc2322E", // class name
  bases__ZN4aaaa6dc2322E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2323  : ::aaaa::aa2 , ::aaaa::bb3 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc2323E) C1{ BC2{} BC3{ Fs} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2323E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2323E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4aaaa6dc2323E, buf);
    ::aaaa::dc2323 &lv = *(new (buf) ::aaaa::dc2323());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa6dc2323E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2323E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2323E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa6dc2323E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc2323E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc2323E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2323E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2323E(Test__ZN4aaaa6dc2323E, "_ZN4aaaa6dc2323E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc2323E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2323E = {  "_ZN4aaaa6dc2323E", // class name
  bases__ZN4aaaa6dc2323E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2324  : ::aaaa::aa2 , ::aaaa::bb3 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc2324E) C1{ BC2{} BC3{ Fs} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2324E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2324E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4aaaa6dc2324E, buf);
    ::aaaa::dc2324 &lv = *(new (buf) ::aaaa::dc2324());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa6dc2324E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2324E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2324E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa6dc2324E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc2324E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc2324E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2324E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2324E(Test__ZN4aaaa6dc2324E, "_ZN4aaaa6dc2324E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc2324E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2324E = {  "_ZN4aaaa6dc2324E", // class name
  bases__ZN4aaaa6dc2324E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2325  : ::aaaa::aa2 , ::aaaa::bb3 , ::aaaa::cc2 {
  char xc[2];
};
//SIG(1 _ZN4aaaa6dc2325E) C1{ BC2{} BC3{ Fs} BC4{} Fc[2]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2325E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2325E;
  void *lvp;
  {
    short buf[3];
    init_test(&cd__ZN4aaaa6dc2325E, buf);
    ::aaaa::dc2325 &lv = *(new (buf) ::aaaa::dc2325());
    lvp = (void*)&lv;
    check2(sizeof(lv), 4, "sizeof(_ZN4aaaa6dc2325E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2325E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2325E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa6dc2325E");
    check_base_class_offset(lv, (::aaaa::cc2*), 0, "_ZN4aaaa6dc2325E");
    check_field_offset(lv, xc, 2, "_ZN4aaaa6dc2325E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2325E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2325E(Test__ZN4aaaa6dc2325E, "_ZN4aaaa6dc2325E", 4);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc2E;
static Base_Class bases__ZN4aaaa6dc2325E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2325E = {  "_ZN4aaaa6dc2325E", // class name
  bases__ZN4aaaa6dc2325E, 3,
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2330  : ::aaaa::aa2 , ::aaaa::bb3 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc2330E) C1{ BC2{} BC3{ Fs} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2330E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2330E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa6dc2330E, buf);
    ::aaaa::dc2330 &lv = *(new (buf) ::aaaa::dc2330());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa6dc2330E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2330E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2330E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa6dc2330E");
    check_base_class_offset(lv, (::aaaa::cc3*), 2, "_ZN4aaaa6dc2330E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc2330E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2330E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2330E(Test__ZN4aaaa6dc2330E, "_ZN4aaaa6dc2330E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc2330E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2330E = {  "_ZN4aaaa6dc2330E", // class name
  bases__ZN4aaaa6dc2330E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2331  : ::aaaa::aa2 , ::aaaa::bb3 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc2331E) C1{ BC2{} BC3{ Fs} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2331E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2331E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa6dc2331E, buf);
    ::aaaa::dc2331 &lv = *(new (buf) ::aaaa::dc2331());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa6dc2331E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2331E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2331E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa6dc2331E");
    check_base_class_offset(lv, (::aaaa::cc3*), 2, "_ZN4aaaa6dc2331E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc2331E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2331E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2331E(Test__ZN4aaaa6dc2331E, "_ZN4aaaa6dc2331E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc2331E[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd__ZN4aaaa3aa2E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3bb3E,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd__ZN4aaaa3cc3E,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd__ZN4aaaa6dc2331E = {  "_ZN4aaaa6dc2331E", // class name
  bases__ZN4aaaa6dc2331E, 3,
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus
namespace aaaa { 
struct  dc2332  : ::aaaa::aa2 , ::aaaa::bb3 , ::aaaa::cc3 {
  char xc[3];
};
//SIG(1 _ZN4aaaa6dc2332E) C1{ BC2{} BC3{ Fs} BC4{ Fs} Fc[3]}
}
namespace aaaa { 
}
static void Test__ZN4aaaa6dc2332E()
{
  extern Class_Descriptor cd__ZN4aaaa6dc2332E;
  void *lvp;
  {
    short buf[5];
    init_test(&cd__ZN4aaaa6dc2332E, buf);
    ::aaaa::dc2332 &lv = *(new (buf) ::aaaa::dc2332());
    lvp = (void*)&lv;
    check2(sizeof(lv), 8, "sizeof(_ZN4aaaa6dc2332E)");
    check2(__alignof__(lv), 2, "__alignof__(_ZN4aaaa6dc2332E)");
    check_base_class_offset(lv, (::aaaa::aa2*), 0, "_ZN4aaaa6dc2332E");
    check_base_class_offset(lv, (::aaaa::bb3*), 0, "_ZN4aaaa6dc2332E");
    check_base_class_offset(lv, (::aaaa::cc3*), 2, "_ZN4aaaa6dc2332E");
    check_field_offset(lv, xc, 4, "_ZN4aaaa6dc2332E.xc");
    test_class_info(&lv, &cd__ZN4aaaa6dc2332E);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me v_ZN4aaaa6dc2332E(Test__ZN4aaaa6dc2332E, "_ZN4aaaa6dc2332E", 8);

#else // __cplusplus

extern Class_Descriptor cd__ZN4aaaa3aa2E;
extern Class_Descriptor cd__ZN4aaaa3bb3E;
extern Class_Descriptor cd__ZN4aaaa3cc3E;
static Base_Class bases__ZN4aaaa6dc2332E[] = {
  // 