// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  si  {
};
//SIG(-1 si) C1{}



static void Test_si()
{
  {
    init_simple_test("si");
    si lv;
    check2(sizeof(lv), 1, "sizeof(si)");
    check2(__alignof__(lv), 1, "__alignof__(si)");
  }
}
static Arrange_To_Call_Me vsi(Test_si, "si", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI2si[];
VTBL_ENTRY *P__ZTI2si = _ZTI2si; 
Class_Descriptor cd_si = {  "si", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI2si),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  sj  {
};
//SIG(-1 sj) C1{}



static void Test_sj()
{
  {
    init_simple_test("sj");
    sj lv;
    check2(sizeof(lv), 1, "sizeof(sj)");
    check2(__alignof__(lv), 1, "__alignof__(sj)");
  }
}
static Arrange_To_Call_Me vsj(Test_sj, "sj", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI2sj[];
VTBL_ENTRY *P__ZTI2sj = _ZTI2sj; 
Class_Descriptor cd_sj = {  "sj", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI2sj),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  sl  {
};
//SIG(-1 sl) C1{}



static void Test_sl()
{
  {
    init_simple_test("sl");
    sl lv;
    check2(sizeof(lv), 1, "sizeof(sl)");
    check2(__alignof__(lv), 1, "__alignof__(sl)");
  }
}
static Arrange_To_Call_Me vsl(Test_sl, "sl", 1);

#else // __cplusplus

Class_Descriptor cd_sl = {  "sl", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  sm  {
};
//SIG(-1 sm) C1{}



static void Test_sm()
{
  {
    init_simple_test("sm");
    sm lv;
    check2(sizeof(lv), 1, "sizeof(sm)");
    check2(__alignof__(lv), 1, "__alignof__(sm)");
  }
}
static Arrange_To_Call_Me vsm(Test_sm, "sm", 1);

#else // __cplusplus

Class_Descriptor cd_sm = {  "sm", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  sk  {
};
//SIG(-1 sk) C1{}



static void Test_sk()
{
  {
    init_simple_test("sk");
    sk lv;
    check2(sizeof(lv), 1, "sizeof(sk)");
    check2(__alignof__(lv), 1, "__alignof__(sk)");
  }
}
static Arrange_To_Call_Me vsk(Test_sk, "sk", 1);

#else // __cplusplus

Class_Descriptor cd_sk = {  "sk", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  sk01  : virtual sj {
  ~sk01(); // tgen
  sk01(); // tgen
};
//SIG(-1 sk01) C1{ VBC2{}}


sk01 ::~sk01(){ note_dtor("sk01", this);} // tgen
sk01 ::sk01(){ note_ctor("sk01", this);} // tgen

static void Test_sk01()
{
  extern Class_Descriptor cd_sk01;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_sk01, buf);
    sk01 *dp, &lv = *(dp=new (buf) sk01());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(sk01)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(sk01)");
    check_base_class_offset(lv, (sj*), 0, "sk01");
    test_class_info(&lv, &cd_sk01);
    dp->~sk01();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vsk01(Test_sk01, "sk01", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4sk01C1Ev();
extern void _ZN4sk01D1Ev();
Name_Map name_map_sk01[] = {
  NSPAIR(_ZN4sk01C1Ev),
  NSPAIR(_ZN4sk01D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
static Base_Class bases_sk01[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4sk01[];
static  VTBL_ENTRY vtc_sk01[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
extern VTBL_ENTRY _ZTV4sk01[];
static  VTT_ENTRY vtt_sk01[] = {
  {&(_ZTV4sk01[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
Class_Descriptor cd_sk01 = {  "sk01", // class name
  bases_sk01, 1,
  &(vtc_sk01[0]), // expected_vtbl_contents
  &(vtt_sk01[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4sk01),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV4sk01),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4sk01),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  sk02  : sj {
};
//SIG(-1 sk02) C1{ BC2{}}



static void Test_sk02()
{
  extern Class_Descriptor cd_sk02;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_sk02, buf);
    sk02 &lv = *(new (buf) sk02());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(sk02)");
    check2(__alignof__(lv), 1, "__alignof__(sk02)");
    check_base_class_offset(lv, (sj*), 0, "sk02");
    test_class_info(&lv, &cd_sk02);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vsk02(Test_sk02, "sk02", 1);

#else // __cplusplus

extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
static Base_Class bases_sk02[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4sk02[];
Class_Descriptor cd_sk02 = {  "sk02", // class name
  bases_sk02, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI4sk02),ABISELECT(24,12), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  sk11  : virtual si , virtual sj {
  ~sk11(); // tgen
  sk11(); // tgen
};
//SIG(-1 sk11) C1{ VBC2{} VBC3{}}


sk11 ::~sk11(){ note_dtor("sk11", this);} // tgen
sk11 ::sk11(){ note_ctor("sk11", this);} // tgen

static void Test_sk11()
{
  extern Class_Descriptor cd_sk11;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_sk11, buf);
    sk11 *dp, &lv = *(dp=new (buf) sk11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(sk11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(sk11)");
    check_base_class_offset(lv, (si*), 0, "sk11");
    check_base_class_offset(lv, (sj*), 0, "sk11");
    test_class_info(&lv, &cd_sk11);
    dp->~sk11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vsk11(Test_sk11, "sk11", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4sk11C1Ev();
extern void _ZN4sk11D1Ev();
Name_Map name_map_sk11[] = {
  NSPAIR(_ZN4sk11C1Ev),
  NSPAIR(_ZN4sk11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
static Base_Class bases_sk11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4sk11[];
static  VTBL_ENTRY vtc_sk11[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
extern VTBL_ENTRY _ZTV4sk11[];
static  VTT_ENTRY vtt_sk11[] = {
  {&(_ZTV4sk11[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
Class_Descriptor cd_sk11 = {  "sk11", // class name
  bases_sk11, 2,
  &(vtc_sk11[0]), // expected_vtbl_contents
  &(vtt_sk11[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4sk11),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4sk11),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4sk11),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  sk12  : virtual si , sj {
  ~sk12(); // tgen
  sk12(); // tgen
};
//SIG(-1 sk12) C1{ VBC2{} BC3{}}


sk12 ::~sk12(){ note_dtor("sk12", this);} // tgen
sk12 ::sk12(){ note_ctor("sk12", this);} // tgen

static void Test_sk12()
{
  extern Class_Descriptor cd_sk12;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_sk12, buf);
    sk12 *dp, &lv = *(dp=new (buf) sk12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(sk12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(sk12)");
    check_base_class_offset(lv, (si*), 0, "sk12");
    check_base_class_offset(lv, (sj*), 0, "sk12");
    test_class_info(&lv, &cd_sk12);
    dp->~sk12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vsk12(Test_sk12, "sk12", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4sk12C1Ev();
extern void _ZN4sk12D1Ev();
Name_Map name_map_sk12[] = {
  NSPAIR(_ZN4sk12C1Ev),
  NSPAIR(_ZN4sk12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
static Base_Class bases_sk12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4sk12[];
static  VTBL_ENTRY vtc_sk12[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
extern VTBL_ENTRY _ZTV4sk12[];
static  VTT_ENTRY vtt_sk12[] = {
  {&(_ZTV4sk12[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
Class_Descriptor cd_sk12 = {  "sk12", // class name
  bases_sk12, 2,
  &(vtc_sk12[0]), // expected_vtbl_contents
  &(vtt_sk12[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4sk12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4sk12),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4sk12),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  sk21  : si , virtual sj {
  ~sk21(); // tgen
  sk21(); // tgen
};
//SIG(-1 sk21) C1{ BC2{} VBC3{}}


sk21 ::~sk21(){ note_dtor("sk21", this);} // tgen
sk21 ::sk21(){ note_ctor("sk21", this);} // tgen

static void Test_sk21()
{
  extern Class_Descriptor cd_sk21;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_sk21, buf);
    sk21 *dp, &lv = *(dp=new (buf) sk21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(sk21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(sk21)");
    check_base_class_offset(lv, (si*), 0, "sk21");
    check_base_class_offset(lv, (sj*), 0, "sk21");
    test_class_info(&lv, &cd_sk21);
    dp->~sk21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vsk21(Test_sk21, "sk21", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4sk21C1Ev();
extern void _ZN4sk21D1Ev();
Name_Map name_map_sk21[] = {
  NSPAIR(_ZN4sk21C1Ev),
  NSPAIR(_ZN4sk21D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
static Base_Class bases_sk21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4sk21[];
static  VTBL_ENTRY vtc_sk21[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
extern VTBL_ENTRY _ZTV4sk21[];
static  VTT_ENTRY vtt_sk21[] = {
  {&(_ZTV4sk21[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
Class_Descriptor cd_sk21 = {  "sk21", // class name
  bases_sk21, 2,
  &(vtc_sk21[0]), // expected_vtbl_contents
  &(vtt_sk21[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4sk21),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4sk21),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4sk21),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  sk22  : si , sj {
};
//SIG(-1 sk22) C1{ BC2{} BC3{}}



static void Test_sk22()
{
  extern Class_Descriptor cd_sk22;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_sk22, buf);
    sk22 &lv = *(new (buf) sk22());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(sk22)");
    check2(__alignof__(lv), 1, "__alignof__(sk22)");
    check_base_class_offset(lv, (si*), 0, "sk22");
    check_base_class_offset(lv, (sj*), 0, "sk22");
    test_class_info(&lv, &cd_sk22);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vsk22(Test_sk22, "sk22", 1);

#else // __cplusplus

extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
static Base_Class bases_sk22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4sk22[];
Class_Descriptor cd_sk22 = {  "sk22", // class name
  bases_sk22, 2,
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI4sk22),ABISELECT(56,32), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  sk00  {
};
//SIG(-1 sk00) C1{}



static void Test_sk00()
{
  {
    init_simple_test("sk00");
    sk00 lv;
    check2(sizeof(lv), 1, "sizeof(sk00)");
    check2(__alignof__(lv), 1, "__alignof__(sk00)");
  }
}
static Arrange_To_Call_Me vsk00(Test_sk00, "sk00", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI4sk00[];
VTBL_ENTRY *P__ZTI4sk00 = _ZTI4sk00; 
Class_Descriptor cd_sk00 = {  "sk00", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI4sk00),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  tk00  {
};
//SIG(-1 tk00) C1{}



static void Test_tk00()
{
  {
    init_simple_test("tk00");
    tk00 lv;
    check2(sizeof(lv), 1, "sizeof(tk00)");
    check2(__alignof__(lv), 1, "__alignof__(tk00)");
  }
}
static Arrange_To_Call_Me vtk00(Test_tk00, "tk00", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI4tk00[];
VTBL_ENTRY *P__ZTI4tk00 = _ZTI4tk00; 
Class_Descriptor cd_tk00 = {  "tk00", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI4tk00),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  tk01  : virtual sj {
  ~tk01(); // tgen
  tk01(); // tgen
};
//SIG(-1 tk01) C1{ VBC2{}}


tk01 ::~tk01(){ note_dtor("tk01", this);} // tgen
tk01 ::tk01(){ note_ctor("tk01", this);} // tgen

static void Test_tk01()
{
  extern Class_Descriptor cd_tk01;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_tk01, buf);
    tk01 *dp, &lv = *(dp=new (buf) tk01());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(tk01)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(tk01)");
    check_base_class_offset(lv, (sj*), 0, "tk01");
    test_class_info(&lv, &cd_tk01);
    dp->~tk01();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vtk01(Test_tk01, "tk01", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4tk01C1Ev();
extern void _ZN4tk01D1Ev();
Name_Map name_map_tk01[] = {
  NSPAIR(_ZN4tk01C1Ev),
  NSPAIR(_ZN4tk01D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
static Base_Class bases_tk01[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4tk01[];
static  VTBL_ENTRY vtc_tk01[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
extern VTBL_ENTRY _ZTV4tk01[];
static  VTT_ENTRY vtt_tk01[] = {
  {&(_ZTV4tk01[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
Class_Descriptor cd_tk01 = {  "tk01", // class name
  bases_tk01, 1,
  &(vtc_tk01[0]), // expected_vtbl_contents
  &(vtt_tk01[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4tk01),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV4tk01),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4tk01),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  tk02  : sj {
};
//SIG(-1 tk02) C1{ BC2{}}



static void Test_tk02()
{
  extern Class_Descriptor cd_tk02;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_tk02, buf);
    tk02 &lv = *(new (buf) tk02());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(tk02)");
    check2(__alignof__(lv), 1, "__alignof__(tk02)");
    check_base_class_offset(lv, (sj*), 0, "tk02");
    test_class_info(&lv, &cd_tk02);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vtk02(Test_tk02, "tk02", 1);

#else // __cplusplus

extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
static Base_Class bases_tk02[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4tk02[];
Class_Descriptor cd_tk02 = {  "tk02", // class name
  bases_tk02, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI4tk02),ABISELECT(24,12), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  tk11  : virtual si , virtual sj {
  ~tk11(); // tgen
  tk11(); // tgen
};
//SIG(-1 tk11) C1{ VBC2{} VBC3{}}


tk11 ::~tk11(){ note_dtor("tk11", this);} // tgen
tk11 ::tk11(){ note_ctor("tk11", this);} // tgen

static void Test_tk11()
{
  extern Class_Descriptor cd_tk11;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_tk11, buf);
    tk11 *dp, &lv = *(dp=new (buf) tk11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(tk11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(tk11)");
    check_base_class_offset(lv, (si*), 0, "tk11");
    check_base_class_offset(lv, (sj*), 0, "tk11");
    test_class_info(&lv, &cd_tk11);
    dp->~tk11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vtk11(Test_tk11, "tk11", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4tk11C1Ev();
extern void _ZN4tk11D1Ev();
Name_Map name_map_tk11[] = {
  NSPAIR(_ZN4tk11C1Ev),
  NSPAIR(_ZN4tk11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
static Base_Class bases_tk11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4tk11[];
static  VTBL_ENTRY vtc_tk11[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
extern VTBL_ENTRY _ZTV4tk11[];
static  VTT_ENTRY vtt_tk11[] = {
  {&(_ZTV4tk11[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
Class_Descriptor cd_tk11 = {  "tk11", // class name
  bases_tk11, 2,
  &(vtc_tk11[0]), // expected_vtbl_contents
  &(vtt_tk11[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4tk11),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4tk11),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4tk11),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  tk12  : virtual si , sj {
  ~tk12(); // tgen
  tk12(); // tgen
};
//SIG(-1 tk12) C1{ VBC2{} BC3{}}


tk12 ::~tk12(){ note_dtor("tk12", this);} // tgen
tk12 ::tk12(){ note_ctor("tk12", this);} // tgen

static void Test_tk12()
{
  extern Class_Descriptor cd_tk12;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_tk12, buf);
    tk12 *dp, &lv = *(dp=new (buf) tk12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(tk12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(tk12)");
    check_base_class_offset(lv, (si*), 0, "tk12");
    check_base_class_offset(lv, (sj*), 0, "tk12");
    test_class_info(&lv, &cd_tk12);
    dp->~tk12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vtk12(Test_tk12, "tk12", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4tk12C1Ev();
extern void _ZN4tk12D1Ev();
Name_Map name_map_tk12[] = {
  NSPAIR(_ZN4tk12C1Ev),
  NSPAIR(_ZN4tk12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
static Base_Class bases_tk12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4tk12[];
static  VTBL_ENTRY vtc_tk12[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
extern VTBL_ENTRY _ZTV4tk12[];
static  VTT_ENTRY vtt_tk12[] = {
  {&(_ZTV4tk12[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
Class_Descriptor cd_tk12 = {  "tk12", // class name
  bases_tk12, 2,
  &(vtc_tk12[0]), // expected_vtbl_contents
  &(vtt_tk12[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4tk12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4tk12),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4tk12),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  tk21  : si , virtual sj {
  ~tk21(); // tgen
  tk21(); // tgen
};
//SIG(-1 tk21) C1{ BC2{} VBC3{}}


tk21 ::~tk21(){ note_dtor("tk21", this);} // tgen
tk21 ::tk21(){ note_ctor("tk21", this);} // tgen

static void Test_tk21()
{
  extern Class_Descriptor cd_tk21;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_tk21, buf);
    tk21 *dp, &lv = *(dp=new (buf) tk21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(tk21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(tk21)");
    check_base_class_offset(lv, (si*), 0, "tk21");
    check_base_class_offset(lv, (sj*), 0, "tk21");
    test_class_info(&lv, &cd_tk21);
    dp->~tk21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vtk21(Test_tk21, "tk21", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4tk21C1Ev();
extern void _ZN4tk21D1Ev();
Name_Map name_map_tk21[] = {
  NSPAIR(_ZN4tk21C1Ev),
  NSPAIR(_ZN4tk21D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
static Base_Class bases_tk21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4tk21[];
static  VTBL_ENTRY vtc_tk21[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
extern VTBL_ENTRY _ZTV4tk21[];
static  VTT_ENTRY vtt_tk21[] = {
  {&(_ZTV4tk21[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
Class_Descriptor cd_tk21 = {  "tk21", // class name
  bases_tk21, 2,
  &(vtc_tk21[0]), // expected_vtbl_contents
  &(vtt_tk21[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4tk21),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4tk21),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4tk21),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  tk22  : si , sj {
};
//SIG(-1 tk22) C1{ BC2{} BC3{}}



static void Test_tk22()
{
  extern Class_Descriptor cd_tk22;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_tk22, buf);
    tk22 &lv = *(new (buf) tk22());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(tk22)");
    check2(__alignof__(lv), 1, "__alignof__(tk22)");
    check_base_class_offset(lv, (si*), 0, "tk22");
    check_base_class_offset(lv, (sj*), 0, "tk22");
    test_class_info(&lv, &cd_tk22);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vtk22(Test_tk22, "tk22", 1);

#else // __cplusplus

extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
static Base_Class bases_tk22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4tk22[];
Class_Descriptor cd_tk22 = {  "tk22", // class name
  bases_tk22, 2,
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI4tk22),ABISELECT(56,32), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  xt0  : tk00 {
};
//SIG(1 xt0) C1{ BC2{}}



static void Test_xt0()
{
  extern Class_Descriptor cd_xt0;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_xt0, buf);
    xt0 &lv = *(new (buf) xt0());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(xt0)");
    check2(__alignof__(lv), 1, "__alignof__(xt0)");
    check_base_class_offset(lv, (tk00*), 0, "xt0");
    test_class_info(&lv, &cd_xt0);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vxt0(Test_xt0, "xt0", 1);

#else // __cplusplus

extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_xt0[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_xt0 = {  "xt0", // class name
  bases_xt0, 1,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  yt0  : virtual tk00 {
  ~yt0(); // tgen
  yt0(); // tgen
};
//SIG(1 yt0) C1{ VBC2{}}


yt0 ::~yt0(){ note_dtor("yt0", this);} // tgen
yt0 ::yt0(){ note_ctor("yt0", this);} // tgen

static void Test_yt0()
{
  extern Class_Descriptor cd_yt0;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_yt0, buf);
    yt0 *dp, &lv = *(dp=new (buf) yt0());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(yt0)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(yt0)");
    check_base_class_offset(lv, (tk00*), 0, "yt0");
    test_class_info(&lv, &cd_yt0);
    dp->~yt0();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vyt0(Test_yt0, "yt0", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3yt0C1Ev();
extern void _ZN3yt0D1Ev();
Name_Map name_map_yt0[] = {
  NSPAIR(_ZN3yt0C1Ev),
  NSPAIR(_ZN3yt0D1Ev),
  {0,0}
};
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_yt0[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3yt0[];
static  VTBL_ENTRY vtc_yt0[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI3yt0[0]),
};
extern VTBL_ENTRY _ZTV3yt0[];
static  VTT_ENTRY vtt_yt0[] = {
  {&(_ZTV3yt0[3]),  3,3},
};
extern VTBL_ENTRY _ZTI3yt0[];
extern  VTBL_ENTRY _ZTV3yt0[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3yt0[];
Class_Descriptor cd_yt0 = {  "yt0", // class name
  bases_yt0, 1,
  &(vtc_yt0[0]), // expected_vtbl_contents
  &(vtt_yt0[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI3yt0),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV3yt0),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3yt0),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za00  : sk00 , tk00 {
};
//SIG(1 za00) C1{ BC2{} BC3{}}



static void Test_za00()
{
  extern Class_Descriptor cd_za00;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_za00, buf);
    za00 &lv = *(new (buf) za00());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(za00)");
    check2(__alignof__(lv), 1, "__alignof__(za00)");
    check_base_class_offset(lv, (sk00*), 0, "za00");
    check_base_class_offset(lv, (tk00*), 0, "za00");
    test_class_info(&lv, &cd_za00);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza00(Test_za00, "za00", 1);

#else // __cplusplus

extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_za00[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_za00 = {  "za00", // class name
  bases_za00, 2,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb00  : sk00 , virtual tk00 {
  ~zb00(); // tgen
  zb00(); // tgen
};
//SIG(1 zb00) C1{ BC2{} VBC3{}}


zb00 ::~zb00(){ note_dtor("zb00", this);} // tgen
zb00 ::zb00(){ note_ctor("zb00", this);} // tgen

static void Test_zb00()
{
  extern Class_Descriptor cd_zb00;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zb00, buf);
    zb00 *dp, &lv = *(dp=new (buf) zb00());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zb00)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb00)");
    check_base_class_offset(lv, (sk00*), 0, "zb00");
    check_base_class_offset(lv, (tk00*), 0, "zb00");
    test_class_info(&lv, &cd_zb00);
    dp->~zb00();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb00(Test_zb00, "zb00", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zb00C1Ev();
extern void _ZN4zb00D1Ev();
Name_Map name_map_zb00[] = {
  NSPAIR(_ZN4zb00C1Ev),
  NSPAIR(_ZN4zb00D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_zb00[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb00[];
static  VTBL_ENTRY vtc_zb00[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb00[0]),
};
extern VTBL_ENTRY _ZTV4zb00[];
static  VTT_ENTRY vtt_zb00[] = {
  {&(_ZTV4zb00[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb00[];
extern  VTBL_ENTRY _ZTV4zb00[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb00[];
Class_Descriptor cd_zb00 = {  "zb00", // class name
  bases_zb00, 2,
  &(vtc_zb00[0]), // expected_vtbl_contents
  &(vtt_zb00[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zb00),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb00),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb00),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc00  : virtual sk00 , tk00 {
  ~zc00(); // tgen
  zc00(); // tgen
};
//SIG(1 zc00) C1{ VBC2{} BC3{}}


zc00 ::~zc00(){ note_dtor("zc00", this);} // tgen
zc00 ::zc00(){ note_ctor("zc00", this);} // tgen

static void Test_zc00()
{
  extern Class_Descriptor cd_zc00;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zc00, buf);
    zc00 *dp, &lv = *(dp=new (buf) zc00());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zc00)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc00)");
    check_base_class_offset(lv, (sk00*), 0, "zc00");
    check_base_class_offset(lv, (tk00*), 0, "zc00");
    test_class_info(&lv, &cd_zc00);
    dp->~zc00();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc00(Test_zc00, "zc00", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zc00C1Ev();
extern void _ZN4zc00D1Ev();
Name_Map name_map_zc00[] = {
  NSPAIR(_ZN4zc00C1Ev),
  NSPAIR(_ZN4zc00D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_zc00[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc00[];
static  VTBL_ENTRY vtc_zc00[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc00[0]),
};
extern VTBL_ENTRY _ZTV4zc00[];
static  VTT_ENTRY vtt_zc00[] = {
  {&(_ZTV4zc00[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc00[];
extern  VTBL_ENTRY _ZTV4zc00[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc00[];
Class_Descriptor cd_zc00 = {  "zc00", // class name
  bases_zc00, 2,
  &(vtc_zc00[0]), // expected_vtbl_contents
  &(vtt_zc00[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zc00),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc00),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc00),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd00  : virtual sk00 , virtual tk00 {
  ~zd00(); // tgen
  zd00(); // tgen
};
//SIG(1 zd00) C1{ VBC2{} VBC3{}}


zd00 ::~zd00(){ note_dtor("zd00", this);} // tgen
zd00 ::zd00(){ note_ctor("zd00", this);} // tgen

static void Test_zd00()
{
  extern Class_Descriptor cd_zd00;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zd00, buf);
    zd00 *dp, &lv = *(dp=new (buf) zd00());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zd00)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd00)");
    check_base_class_offset(lv, (sk00*), 0, "zd00");
    check_base_class_offset(lv, (tk00*), 0, "zd00");
    test_class_info(&lv, &cd_zd00);
    dp->~zd00();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd00(Test_zd00, "zd00", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zd00C1Ev();
extern void _ZN4zd00D1Ev();
Name_Map name_map_zd00[] = {
  NSPAIR(_ZN4zd00C1Ev),
  NSPAIR(_ZN4zd00D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_zd00[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd00[];
static  VTBL_ENTRY vtc_zd00[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd00[0]),
};
extern VTBL_ENTRY _ZTV4zd00[];
static  VTT_ENTRY vtt_zd00[] = {
  {&(_ZTV4zd00[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zd00[];
extern  VTBL_ENTRY _ZTV4zd00[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd00[];
Class_Descriptor cd_zd00 = {  "zd00", // class name
  bases_zd00, 2,
  &(vtc_zd00[0]), // expected_vtbl_contents
  &(vtt_zd00[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zd00),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd00),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd00),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za01  : sk00 , tk01 {
  ~za01(); // tgen
  za01(); // tgen
};
//SIG(1 za01) C1{ BC2{} BC3{ VBC4{}}}


za01 ::~za01(){ note_dtor("za01", this);} // tgen
za01 ::za01(){ note_ctor("za01", this);} // tgen

static void Test_za01()
{
  extern Class_Descriptor cd_za01;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_za01, buf);
    za01 *dp, &lv = *(dp=new (buf) za01());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(za01)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za01)");
    check_base_class_offset(lv, (sk00*), 0, "za01");
    check_base_class_offset(lv, (sj*)(tk01*), 0, "za01");
    check_base_class_offset(lv, (tk01*), 0, "za01");
    test_class_info(&lv, &cd_za01);
    dp->~za01();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza01(Test_za01, "za01", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4za01C1Ev();
extern void _ZN4za01D1Ev();
Name_Map name_map_za01[] = {
  NSPAIR(_ZN4za01C1Ev),
  NSPAIR(_ZN4za01D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_za01[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_tk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za01[];
static  VTBL_ENTRY vtc_za01[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za01[0]),
};
extern VTBL_ENTRY _ZTV4za01[];
static  VTBL_ENTRY _tg__ZTV4tk01__4za01[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTT_ENTRY vtt_za01[] = {
  {&(_ZTV4za01[3]),  3,3},
  {&(_tg__ZTV4tk01__4za01[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4za01[];
extern  VTBL_ENTRY _ZTV4za01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za01[];
Class_Descriptor cd_za01 = {  "za01", // class name
  bases_za01, 3,
  &(vtc_za01[0]), // expected_vtbl_contents
  &(vtt_za01[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4za01),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za01),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za01),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb01  : sk00 , virtual tk01 {
  ~zb01(); // tgen
  zb01(); // tgen
};
//SIG(1 zb01) C1{ BC2{} VBC3{ VBC4{}}}


zb01 ::~zb01(){ note_dtor("zb01", this);} // tgen
zb01 ::zb01(){ note_ctor("zb01", this);} // tgen

static void Test_zb01()
{
  extern Class_Descriptor cd_zb01;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zb01, buf);
    zb01 *dp, &lv = *(dp=new (buf) zb01());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zb01)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb01)");
    check_base_class_offset(lv, (sk00*), 0, "zb01");
    check_base_class_offset(lv, (sj*)(tk01*), 0, "zb01");
    check_base_class_offset(lv, (tk01*), 0, "zb01");
    test_class_info(&lv, &cd_zb01);
    dp->~zb01();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb01(Test_zb01, "zb01", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zb01C1Ev();
extern void _ZN4zb01D1Ev();
Name_Map name_map_zb01[] = {
  NSPAIR(_ZN4zb01C1Ev),
  NSPAIR(_ZN4zb01D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_zb01[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_tk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb01[];
static  VTBL_ENTRY vtc_zb01[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb01[0]),
};
extern VTBL_ENTRY _ZTV4zb01[];
static  VTBL_ENTRY _tg__ZTV4tk01__4zb01[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTT_ENTRY vtt_zb01[] = {
  {&(_ZTV4zb01[4]),  4,4},
  {&(_ZTV4zb01[4]),  4,4},
  {&(_tg__ZTV4tk01__4zb01[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb01[];
extern  VTBL_ENTRY _ZTV4zb01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb01[];
Class_Descriptor cd_zb01 = {  "zb01", // class name
  bases_zb01, 3,
  &(vtc_zb01[0]), // expected_vtbl_contents
  &(vtt_zb01[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zb01),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb01),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb01),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc01  : virtual sk00 , tk01 {
  ~zc01(); // tgen
  zc01(); // tgen
};
//SIG(1 zc01) C1{ VBC2{} BC3{ VBC4{}}}


zc01 ::~zc01(){ note_dtor("zc01", this);} // tgen
zc01 ::zc01(){ note_ctor("zc01", this);} // tgen

static void Test_zc01()
{
  extern Class_Descriptor cd_zc01;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zc01, buf);
    zc01 *dp, &lv = *(dp=new (buf) zc01());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zc01)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc01)");
    check_base_class_offset(lv, (sk00*), 0, "zc01");
    check_base_class_offset(lv, (sj*)(tk01*), 0, "zc01");
    check_base_class_offset(lv, (tk01*), 0, "zc01");
    test_class_info(&lv, &cd_zc01);
    dp->~zc01();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc01(Test_zc01, "zc01", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zc01C1Ev();
extern void _ZN4zc01D1Ev();
Name_Map name_map_zc01[] = {
  NSPAIR(_ZN4zc01C1Ev),
  NSPAIR(_ZN4zc01D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_zc01[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_tk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc01[];
static  VTBL_ENTRY vtc_zc01[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc01[0]),
};
extern VTBL_ENTRY _ZTV4zc01[];
static  VTBL_ENTRY _tg__ZTV4tk01__4zc01[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTT_ENTRY vtt_zc01[] = {
  {&(_ZTV4zc01[4]),  4,4},
  {&(_tg__ZTV4tk01__4zc01[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc01[];
extern  VTBL_ENTRY _ZTV4zc01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc01[];
Class_Descriptor cd_zc01 = {  "zc01", // class name
  bases_zc01, 3,
  &(vtc_zc01[0]), // expected_vtbl_contents
  &(vtt_zc01[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zc01),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc01),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc01),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd01  : virtual sk00 , virtual tk01 {
  ~zd01(); // tgen
  zd01(); // tgen
};
//SIG(1 zd01) C1{ VBC2{} VBC3{ VBC4{}}}


zd01 ::~zd01(){ note_dtor("zd01", this);} // tgen
zd01 ::zd01(){ note_ctor("zd01", this);} // tgen

static void Test_zd01()
{
  extern Class_Descriptor cd_zd01;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zd01, buf);
    zd01 *dp, &lv = *(dp=new (buf) zd01());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zd01)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd01)");
    check_base_class_offset(lv, (sk00*), 0, "zd01");
    check_base_class_offset(lv, (sj*)(tk01*), 0, "zd01");
    check_base_class_offset(lv, (tk01*), 0, "zd01");
    test_class_info(&lv, &cd_zd01);
    dp->~zd01();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd01(Test_zd01, "zd01", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zd01C1Ev();
extern void _ZN4zd01D1Ev();
Name_Map name_map_zd01[] = {
  NSPAIR(_ZN4zd01C1Ev),
  NSPAIR(_ZN4zd01D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_zd01[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_tk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd01[];
static  VTBL_ENTRY vtc_zd01[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd01[0]),
};
extern VTBL_ENTRY _ZTV4zd01[];
static  VTBL_ENTRY _tg__ZTV4tk01__4zd01[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTT_ENTRY vtt_zd01[] = {
  {&(_ZTV4zd01[5]),  5,5},
  {&(_ZTV4zd01[5]),  5,5},
  {&(_tg__ZTV4tk01__4zd01[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd01[];
extern  VTBL_ENTRY _ZTV4zd01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd01[];
Class_Descriptor cd_zd01 = {  "zd01", // class name
  bases_zd01, 3,
  &(vtc_zd01[0]), // expected_vtbl_contents
  &(vtt_zd01[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zd01),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd01),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd01),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za02  : sk00 , tk02 {
};
//SIG(1 za02) C1{ BC2{} BC3{ BC4{}}}



static void Test_za02()
{
  extern Class_Descriptor cd_za02;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_za02, buf);
    za02 &lv = *(new (buf) za02());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(za02)");
    check2(__alignof__(lv), 1, "__alignof__(za02)");
    check_base_class_offset(lv, (sk00*), 0, "za02");
    check_base_class_offset(lv, (sj*)(tk02*), 0, "za02");
    check_base_class_offset(lv, (tk02*), 0, "za02");
    test_class_info(&lv, &cd_za02);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza02(Test_za02, "za02", 1);

#else // __cplusplus

extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_za02[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_tk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_za02 = {  "za02", // class name
  bases_za02, 3,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb02  : sk00 , virtual tk02 {
  ~zb02(); // tgen
  zb02(); // tgen
};
//SIG(1 zb02) C1{ BC2{} VBC3{ BC4{}}}


zb02 ::~zb02(){ note_dtor("zb02", this);} // tgen
zb02 ::zb02(){ note_ctor("zb02", this);} // tgen

static void Test_zb02()
{
  extern Class_Descriptor cd_zb02;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zb02, buf);
    zb02 *dp, &lv = *(dp=new (buf) zb02());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zb02)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb02)");
    check_base_class_offset(lv, (sk00*), 0, "zb02");
    check_base_class_offset(lv, (sj*)(tk02*), 0, "zb02");
    check_base_class_offset(lv, (tk02*), 0, "zb02");
    test_class_info(&lv, &cd_zb02);
    dp->~zb02();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb02(Test_zb02, "zb02", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zb02C1Ev();
extern void _ZN4zb02D1Ev();
Name_Map name_map_zb02[] = {
  NSPAIR(_ZN4zb02C1Ev),
  NSPAIR(_ZN4zb02D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_zb02[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_tk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb02[];
static  VTBL_ENTRY vtc_zb02[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb02[0]),
};
extern VTBL_ENTRY _ZTV4zb02[];
static  VTT_ENTRY vtt_zb02[] = {
  {&(_ZTV4zb02[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb02[];
extern  VTBL_ENTRY _ZTV4zb02[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb02[];
Class_Descriptor cd_zb02 = {  "zb02", // class name
  bases_zb02, 3,
  &(vtc_zb02[0]), // expected_vtbl_contents
  &(vtt_zb02[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zb02),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb02),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb02),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc02  : virtual sk00 , tk02 {
  ~zc02(); // tgen
  zc02(); // tgen
};
//SIG(1 zc02) C1{ VBC2{} BC3{ BC4{}}}


zc02 ::~zc02(){ note_dtor("zc02", this);} // tgen
zc02 ::zc02(){ note_ctor("zc02", this);} // tgen

static void Test_zc02()
{
  extern Class_Descriptor cd_zc02;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zc02, buf);
    zc02 *dp, &lv = *(dp=new (buf) zc02());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zc02)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc02)");
    check_base_class_offset(lv, (sk00*), 0, "zc02");
    check_base_class_offset(lv, (sj*)(tk02*), 0, "zc02");
    check_base_class_offset(lv, (tk02*), 0, "zc02");
    test_class_info(&lv, &cd_zc02);
    dp->~zc02();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc02(Test_zc02, "zc02", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zc02C1Ev();
extern void _ZN4zc02D1Ev();
Name_Map name_map_zc02[] = {
  NSPAIR(_ZN4zc02C1Ev),
  NSPAIR(_ZN4zc02D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_zc02[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_tk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc02[];
static  VTBL_ENTRY vtc_zc02[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc02[0]),
};
extern VTBL_ENTRY _ZTV4zc02[];
static  VTT_ENTRY vtt_zc02[] = {
  {&(_ZTV4zc02[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc02[];
extern  VTBL_ENTRY _ZTV4zc02[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc02[];
Class_Descriptor cd_zc02 = {  "zc02", // class name
  bases_zc02, 3,
  &(vtc_zc02[0]), // expected_vtbl_contents
  &(vtt_zc02[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zc02),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc02),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc02),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd02  : virtual sk00 , virtual tk02 {
  ~zd02(); // tgen
  zd02(); // tgen
};
//SIG(1 zd02) C1{ VBC2{} VBC3{ BC4{}}}


zd02 ::~zd02(){ note_dtor("zd02", this);} // tgen
zd02 ::zd02(){ note_ctor("zd02", this);} // tgen

static void Test_zd02()
{
  extern Class_Descriptor cd_zd02;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zd02, buf);
    zd02 *dp, &lv = *(dp=new (buf) zd02());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zd02)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd02)");
    check_base_class_offset(lv, (sk00*), 0, "zd02");
    check_base_class_offset(lv, (sj*)(tk02*), 0, "zd02");
    check_base_class_offset(lv, (tk02*), 0, "zd02");
    test_class_info(&lv, &cd_zd02);
    dp->~zd02();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd02(Test_zd02, "zd02", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zd02C1Ev();
extern void _ZN4zd02D1Ev();
Name_Map name_map_zd02[] = {
  NSPAIR(_ZN4zd02C1Ev),
  NSPAIR(_ZN4zd02D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_zd02[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_tk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd02[];
static  VTBL_ENTRY vtc_zd02[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd02[0]),
};
extern VTBL_ENTRY _ZTV4zd02[];
static  VTT_ENTRY vtt_zd02[] = {
  {&(_ZTV4zd02[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zd02[];
extern  VTBL_ENTRY _ZTV4zd02[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd02[];
Class_Descriptor cd_zd02 = {  "zd02", // class name
  bases_zd02, 3,
  &(vtc_zd02[0]), // expected_vtbl_contents
  &(vtt_zd02[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zd02),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd02),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd02),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za03  : sk00 , tk11 {
  ~za03(); // tgen
  za03(); // tgen
};
//SIG(1 za03) C1{ BC2{} BC3{ VBC4{} VBC5{}}}


za03 ::~za03(){ note_dtor("za03", this);} // tgen
za03 ::za03(){ note_ctor("za03", this);} // tgen

static void Test_za03()
{
  extern Class_Descriptor cd_za03;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_za03, buf);
    za03 *dp, &lv = *(dp=new (buf) za03());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(za03)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za03)");
    check_base_class_offset(lv, (sk00*), 0, "za03");
    check_base_class_offset(lv, (si*)(tk11*), 0, "za03");
    check_base_class_offset(lv, (sj*)(tk11*), 0, "za03");
    check_base_class_offset(lv, (tk11*), 0, "za03");
    test_class_info(&lv, &cd_za03);
    dp->~za03();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza03(Test_za03, "za03", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4za03C1Ev();
extern void _ZN4za03D1Ev();
Name_Map name_map_za03[] = {
  NSPAIR(_ZN4za03C1Ev),
  NSPAIR(_ZN4za03D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_za03[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_tk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za03[];
static  VTBL_ENTRY vtc_za03[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za03[0]),
};
extern VTBL_ENTRY _ZTV4za03[];
static  VTBL_ENTRY _tg__ZTV4tk11__4za03[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTT_ENTRY vtt_za03[] = {
  {&(_ZTV4za03[4]),  4,4},
  {&(_tg__ZTV4tk11__4za03[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4za03[];
extern  VTBL_ENTRY _ZTV4za03[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za03[];
Class_Descriptor cd_za03 = {  "za03", // class name
  bases_za03, 4,
  &(vtc_za03[0]), // expected_vtbl_contents
  &(vtt_za03[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4za03),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za03),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za03),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb03  : sk00 , virtual tk11 {
  ~zb03(); // tgen
  zb03(); // tgen
};
//SIG(1 zb03) C1{ BC2{} VBC3{ VBC4{} VBC5{}}}


zb03 ::~zb03(){ note_dtor("zb03", this);} // tgen
zb03 ::zb03(){ note_ctor("zb03", this);} // tgen

static void Test_zb03()
{
  extern Class_Descriptor cd_zb03;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zb03, buf);
    zb03 *dp, &lv = *(dp=new (buf) zb03());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zb03)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb03)");
    check_base_class_offset(lv, (sk00*), 0, "zb03");
    check_base_class_offset(lv, (si*)(tk11*), 0, "zb03");
    check_base_class_offset(lv, (sj*)(tk11*), 0, "zb03");
    check_base_class_offset(lv, (tk11*), 0, "zb03");
    test_class_info(&lv, &cd_zb03);
    dp->~zb03();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb03(Test_zb03, "zb03", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zb03C1Ev();
extern void _ZN4zb03D1Ev();
Name_Map name_map_zb03[] = {
  NSPAIR(_ZN4zb03C1Ev),
  NSPAIR(_ZN4zb03D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_zb03[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_tk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb03[];
static  VTBL_ENTRY vtc_zb03[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb03[0]),
};
extern VTBL_ENTRY _ZTV4zb03[];
static  VTBL_ENTRY _tg__ZTV4tk11__4zb03[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTT_ENTRY vtt_zb03[] = {
  {&(_ZTV4zb03[5]),  5,5},
  {&(_ZTV4zb03[5]),  5,5},
  {&(_tg__ZTV4tk11__4zb03[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zb03[];
extern  VTBL_ENTRY _ZTV4zb03[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb03[];
Class_Descriptor cd_zb03 = {  "zb03", // class name
  bases_zb03, 4,
  &(vtc_zb03[0]), // expected_vtbl_contents
  &(vtt_zb03[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zb03),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb03),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb03),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc03  : virtual sk00 , tk11 {
  ~zc03(); // tgen
  zc03(); // tgen
};
//SIG(1 zc03) C1{ VBC2{} BC3{ VBC4{} VBC5{}}}


zc03 ::~zc03(){ note_dtor("zc03", this);} // tgen
zc03 ::zc03(){ note_ctor("zc03", this);} // tgen

static void Test_zc03()
{
  extern Class_Descriptor cd_zc03;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zc03, buf);
    zc03 *dp, &lv = *(dp=new (buf) zc03());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zc03)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc03)");
    check_base_class_offset(lv, (sk00*), 0, "zc03");
    check_base_class_offset(lv, (si*)(tk11*), 0, "zc03");
    check_base_class_offset(lv, (sj*)(tk11*), 0, "zc03");
    check_base_class_offset(lv, (tk11*), 0, "zc03");
    test_class_info(&lv, &cd_zc03);
    dp->~zc03();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc03(Test_zc03, "zc03", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zc03C1Ev();
extern void _ZN4zc03D1Ev();
Name_Map name_map_zc03[] = {
  NSPAIR(_ZN4zc03C1Ev),
  NSPAIR(_ZN4zc03D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_zc03[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_tk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc03[];
static  VTBL_ENTRY vtc_zc03[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc03[0]),
};
extern VTBL_ENTRY _ZTV4zc03[];
static  VTBL_ENTRY _tg__ZTV4tk11__4zc03[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTT_ENTRY vtt_zc03[] = {
  {&(_ZTV4zc03[5]),  5,5},
  {&(_tg__ZTV4tk11__4zc03[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zc03[];
extern  VTBL_ENTRY _ZTV4zc03[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc03[];
Class_Descriptor cd_zc03 = {  "zc03", // class name
  bases_zc03, 4,
  &(vtc_zc03[0]), // expected_vtbl_contents
  &(vtt_zc03[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zc03),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc03),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc03),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd03  : virtual sk00 , virtual tk11 {
  ~zd03(); // tgen
  zd03(); // tgen
};
//SIG(1 zd03) C1{ VBC2{} VBC3{ VBC4{} VBC5{}}}


zd03 ::~zd03(){ note_dtor("zd03", this);} // tgen
zd03 ::zd03(){ note_ctor("zd03", this);} // tgen

static void Test_zd03()
{
  extern Class_Descriptor cd_zd03;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zd03, buf);
    zd03 *dp, &lv = *(dp=new (buf) zd03());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zd03)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd03)");
    check_base_class_offset(lv, (sk00*), 0, "zd03");
    check_base_class_offset(lv, (si*)(tk11*), 0, "zd03");
    check_base_class_offset(lv, (sj*)(tk11*), 0, "zd03");
    check_base_class_offset(lv, (tk11*), 0, "zd03");
    test_class_info(&lv, &cd_zd03);
    dp->~zd03();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd03(Test_zd03, "zd03", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zd03C1Ev();
extern void _ZN4zd03D1Ev();
Name_Map name_map_zd03[] = {
  NSPAIR(_ZN4zd03C1Ev),
  NSPAIR(_ZN4zd03D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_zd03[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_tk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd03[];
static  VTBL_ENTRY vtc_zd03[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd03[0]),
};
extern VTBL_ENTRY _ZTV4zd03[];
static  VTBL_ENTRY _tg__ZTV4tk11__4zd03[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTT_ENTRY vtt_zd03[] = {
  {&(_ZTV4zd03[6]),  6,6},
  {&(_ZTV4zd03[6]),  6,6},
  {&(_tg__ZTV4tk11__4zd03[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zd03[];
extern  VTBL_ENTRY _ZTV4zd03[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd03[];
Class_Descriptor cd_zd03 = {  "zd03", // class name
  bases_zd03, 4,
  &(vtc_zd03[0]), // expected_vtbl_contents
  &(vtt_zd03[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zd03),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd03),6, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd03),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za04  : sk00 , tk12 {
  ~za04(); // tgen
  za04(); // tgen
};
//SIG(1 za04) C1{ BC2{} BC3{ VBC4{} BC5{}}}


za04 ::~za04(){ note_dtor("za04", this);} // tgen
za04 ::za04(){ note_ctor("za04", this);} // tgen

static void Test_za04()
{
  extern Class_Descriptor cd_za04;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_za04, buf);
    za04 *dp, &lv = *(dp=new (buf) za04());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(za04)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za04)");
    check_base_class_offset(lv, (sk00*), 0, "za04");
    check_base_class_offset(lv, (si*)(tk12*), 0, "za04");
    check_base_class_offset(lv, (sj*)(tk12*), 0, "za04");
    check_base_class_offset(lv, (tk12*), 0, "za04");
    test_class_info(&lv, &cd_za04);
    dp->~za04();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza04(Test_za04, "za04", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4za04C1Ev();
extern void _ZN4za04D1Ev();
Name_Map name_map_za04[] = {
  NSPAIR(_ZN4za04C1Ev),
  NSPAIR(_ZN4za04D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_za04[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_tk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za04[];
static  VTBL_ENTRY vtc_za04[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za04[0]),
};
extern VTBL_ENTRY _ZTV4za04[];
static  VTBL_ENTRY _tg__ZTV4tk12__4za04[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTT_ENTRY vtt_za04[] = {
  {&(_ZTV4za04[3]),  3,3},
  {&(_tg__ZTV4tk12__4za04[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4za04[];
extern  VTBL_ENTRY _ZTV4za04[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za04[];
Class_Descriptor cd_za04 = {  "za04", // class name
  bases_za04, 4,
  &(vtc_za04[0]), // expected_vtbl_contents
  &(vtt_za04[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4za04),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za04),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za04),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb04  : sk00 , virtual tk12 {
  ~zb04(); // tgen
  zb04(); // tgen
};
//SIG(1 zb04) C1{ BC2{} VBC3{ VBC4{} BC5{}}}


zb04 ::~zb04(){ note_dtor("zb04", this);} // tgen
zb04 ::zb04(){ note_ctor("zb04", this);} // tgen

static void Test_zb04()
{
  extern Class_Descriptor cd_zb04;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zb04, buf);
    zb04 *dp, &lv = *(dp=new (buf) zb04());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zb04)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb04)");
    check_base_class_offset(lv, (sk00*), 0, "zb04");
    check_base_class_offset(lv, (si*)(tk12*), 0, "zb04");
    check_base_class_offset(lv, (sj*)(tk12*), 0, "zb04");
    check_base_class_offset(lv, (tk12*), 0, "zb04");
    test_class_info(&lv, &cd_zb04);
    dp->~zb04();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb04(Test_zb04, "zb04", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zb04C1Ev();
extern void _ZN4zb04D1Ev();
Name_Map name_map_zb04[] = {
  NSPAIR(_ZN4zb04C1Ev),
  NSPAIR(_ZN4zb04D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_zb04[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_tk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb04[];
static  VTBL_ENTRY vtc_zb04[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb04[0]),
};
extern VTBL_ENTRY _ZTV4zb04[];
static  VTBL_ENTRY _tg__ZTV4tk12__4zb04[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTT_ENTRY vtt_zb04[] = {
  {&(_ZTV4zb04[4]),  4,4},
  {&(_ZTV4zb04[4]),  4,4},
  {&(_tg__ZTV4tk12__4zb04[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb04[];
extern  VTBL_ENTRY _ZTV4zb04[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb04[];
Class_Descriptor cd_zb04 = {  "zb04", // class name
  bases_zb04, 4,
  &(vtc_zb04[0]), // expected_vtbl_contents
  &(vtt_zb04[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zb04),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb04),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb04),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc04  : virtual sk00 , tk12 {
  ~zc04(); // tgen
  zc04(); // tgen
};
//SIG(1 zc04) C1{ VBC2{} BC3{ VBC4{} BC5{}}}


zc04 ::~zc04(){ note_dtor("zc04", this);} // tgen
zc04 ::zc04(){ note_ctor("zc04", this);} // tgen

static void Test_zc04()
{
  extern Class_Descriptor cd_zc04;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zc04, buf);
    zc04 *dp, &lv = *(dp=new (buf) zc04());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zc04)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc04)");
    check_base_class_offset(lv, (sk00*), 0, "zc04");
    check_base_class_offset(lv, (si*)(tk12*), 0, "zc04");
    check_base_class_offset(lv, (sj*)(tk12*), 0, "zc04");
    check_base_class_offset(lv, (tk12*), 0, "zc04");
    test_class_info(&lv, &cd_zc04);
    dp->~zc04();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc04(Test_zc04, "zc04", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zc04C1Ev();
extern void _ZN4zc04D1Ev();
Name_Map name_map_zc04[] = {
  NSPAIR(_ZN4zc04C1Ev),
  NSPAIR(_ZN4zc04D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_zc04[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_tk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc04[];
static  VTBL_ENTRY vtc_zc04[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc04[0]),
};
extern VTBL_ENTRY _ZTV4zc04[];
static  VTBL_ENTRY _tg__ZTV4tk12__4zc04[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTT_ENTRY vtt_zc04[] = {
  {&(_ZTV4zc04[4]),  4,4},
  {&(_tg__ZTV4tk12__4zc04[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc04[];
extern  VTBL_ENTRY _ZTV4zc04[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc04[];
Class_Descriptor cd_zc04 = {  "zc04", // class name
  bases_zc04, 4,
  &(vtc_zc04[0]), // expected_vtbl_contents
  &(vtt_zc04[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zc04),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc04),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc04),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd04  : virtual sk00 , virtual tk12 {
  ~zd04(); // tgen
  zd04(); // tgen
};
//SIG(1 zd04) C1{ VBC2{} VBC3{ VBC4{} BC5{}}}


zd04 ::~zd04(){ note_dtor("zd04", this);} // tgen
zd04 ::zd04(){ note_ctor("zd04", this);} // tgen

static void Test_zd04()
{
  extern Class_Descriptor cd_zd04;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zd04, buf);
    zd04 *dp, &lv = *(dp=new (buf) zd04());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zd04)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd04)");
    check_base_class_offset(lv, (sk00*), 0, "zd04");
    check_base_class_offset(lv, (si*)(tk12*), 0, "zd04");
    check_base_class_offset(lv, (sj*)(tk12*), 0, "zd04");
    check_base_class_offset(lv, (tk12*), 0, "zd04");
    test_class_info(&lv, &cd_zd04);
    dp->~zd04();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd04(Test_zd04, "zd04", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zd04C1Ev();
extern void _ZN4zd04D1Ev();
Name_Map name_map_zd04[] = {
  NSPAIR(_ZN4zd04C1Ev),
  NSPAIR(_ZN4zd04D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_zd04[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_tk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd04[];
static  VTBL_ENTRY vtc_zd04[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd04[0]),
};
extern VTBL_ENTRY _ZTV4zd04[];
static  VTBL_ENTRY _tg__ZTV4tk12__4zd04[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTT_ENTRY vtt_zd04[] = {
  {&(_ZTV4zd04[5]),  5,5},
  {&(_ZTV4zd04[5]),  5,5},
  {&(_tg__ZTV4tk12__4zd04[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd04[];
extern  VTBL_ENTRY _ZTV4zd04[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd04[];
Class_Descriptor cd_zd04 = {  "zd04", // class name
  bases_zd04, 4,
  &(vtc_zd04[0]), // expected_vtbl_contents
  &(vtt_zd04[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zd04),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd04),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd04),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za05  : sk00 , tk21 {
  ~za05(); // tgen
  za05(); // tgen
};
//SIG(1 za05) C1{ BC2{} BC3{ BC4{} VBC5{}}}


za05 ::~za05(){ note_dtor("za05", this);} // tgen
za05 ::za05(){ note_ctor("za05", this);} // tgen

static void Test_za05()
{
  extern Class_Descriptor cd_za05;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_za05, buf);
    za05 *dp, &lv = *(dp=new (buf) za05());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(za05)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za05)");
    check_base_class_offset(lv, (sk00*), 0, "za05");
    check_base_class_offset(lv, (si*)(tk21*), 0, "za05");
    check_base_class_offset(lv, (sj*)(tk21*), 0, "za05");
    check_base_class_offset(lv, (tk21*), 0, "za05");
    test_class_info(&lv, &cd_za05);
    dp->~za05();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza05(Test_za05, "za05", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4za05C1Ev();
extern void _ZN4za05D1Ev();
Name_Map name_map_za05[] = {
  NSPAIR(_ZN4za05C1Ev),
  NSPAIR(_ZN4za05D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_za05[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_tk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za05[];
static  VTBL_ENTRY vtc_za05[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za05[0]),
};
extern VTBL_ENTRY _ZTV4za05[];
static  VTBL_ENTRY _tg__ZTV4tk21__4za05[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTT_ENTRY vtt_za05[] = {
  {&(_ZTV4za05[3]),  3,3},
  {&(_tg__ZTV4tk21__4za05[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4za05[];
extern  VTBL_ENTRY _ZTV4za05[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za05[];
Class_Descriptor cd_za05 = {  "za05", // class name
  bases_za05, 4,
  &(vtc_za05[0]), // expected_vtbl_contents
  &(vtt_za05[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4za05),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za05),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za05),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb05  : sk00 , virtual tk21 {
  ~zb05(); // tgen
  zb05(); // tgen
};
//SIG(1 zb05) C1{ BC2{} VBC3{ BC4{} VBC5{}}}


zb05 ::~zb05(){ note_dtor("zb05", this);} // tgen
zb05 ::zb05(){ note_ctor("zb05", this);} // tgen

static void Test_zb05()
{
  extern Class_Descriptor cd_zb05;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zb05, buf);
    zb05 *dp, &lv = *(dp=new (buf) zb05());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zb05)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb05)");
    check_base_class_offset(lv, (sk00*), 0, "zb05");
    check_base_class_offset(lv, (si*)(tk21*), 0, "zb05");
    check_base_class_offset(lv, (sj*)(tk21*), 0, "zb05");
    check_base_class_offset(lv, (tk21*), 0, "zb05");
    test_class_info(&lv, &cd_zb05);
    dp->~zb05();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb05(Test_zb05, "zb05", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zb05C1Ev();
extern void _ZN4zb05D1Ev();
Name_Map name_map_zb05[] = {
  NSPAIR(_ZN4zb05C1Ev),
  NSPAIR(_ZN4zb05D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_zb05[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_tk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb05[];
static  VTBL_ENTRY vtc_zb05[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb05[0]),
};
extern VTBL_ENTRY _ZTV4zb05[];
static  VTBL_ENTRY _tg__ZTV4tk21__4zb05[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTT_ENTRY vtt_zb05[] = {
  {&(_ZTV4zb05[4]),  4,4},
  {&(_ZTV4zb05[4]),  4,4},
  {&(_tg__ZTV4tk21__4zb05[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb05[];
extern  VTBL_ENTRY _ZTV4zb05[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb05[];
Class_Descriptor cd_zb05 = {  "zb05", // class name
  bases_zb05, 4,
  &(vtc_zb05[0]), // expected_vtbl_contents
  &(vtt_zb05[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zb05),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb05),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb05),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc05  : virtual sk00 , tk21 {
  ~zc05(); // tgen
  zc05(); // tgen
};
//SIG(1 zc05) C1{ VBC2{} BC3{ BC4{} VBC5{}}}


zc05 ::~zc05(){ note_dtor("zc05", this);} // tgen
zc05 ::zc05(){ note_ctor("zc05", this);} // tgen

static void Test_zc05()
{
  extern Class_Descriptor cd_zc05;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zc05, buf);
    zc05 *dp, &lv = *(dp=new (buf) zc05());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zc05)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc05)");
    check_base_class_offset(lv, (sk00*), 0, "zc05");
    check_base_class_offset(lv, (si*)(tk21*), 0, "zc05");
    check_base_class_offset(lv, (sj*)(tk21*), 0, "zc05");
    check_base_class_offset(lv, (tk21*), 0, "zc05");
    test_class_info(&lv, &cd_zc05);
    dp->~zc05();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc05(Test_zc05, "zc05", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zc05C1Ev();
extern void _ZN4zc05D1Ev();
Name_Map name_map_zc05[] = {
  NSPAIR(_ZN4zc05C1Ev),
  NSPAIR(_ZN4zc05D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_zc05[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_tk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc05[];
static  VTBL_ENTRY vtc_zc05[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc05[0]),
};
extern VTBL_ENTRY _ZTV4zc05[];
static  VTBL_ENTRY _tg__ZTV4tk21__4zc05[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTT_ENTRY vtt_zc05[] = {
  {&(_ZTV4zc05[4]),  4,4},
  {&(_tg__ZTV4tk21__4zc05[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc05[];
extern  VTBL_ENTRY _ZTV4zc05[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc05[];
Class_Descriptor cd_zc05 = {  "zc05", // class name
  bases_zc05, 4,
  &(vtc_zc05[0]), // expected_vtbl_contents
  &(vtt_zc05[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zc05),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc05),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc05),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd05  : virtual sk00 , virtual tk21 {
  ~zd05(); // tgen
  zd05(); // tgen
};
//SIG(1 zd05) C1{ VBC2{} VBC3{ BC4{} VBC5{}}}


zd05 ::~zd05(){ note_dtor("zd05", this);} // tgen
zd05 ::zd05(){ note_ctor("zd05", this);} // tgen

static void Test_zd05()
{
  extern Class_Descriptor cd_zd05;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zd05, buf);
    zd05 *dp, &lv = *(dp=new (buf) zd05());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zd05)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd05)");
    check_base_class_offset(lv, (sk00*), 0, "zd05");
    check_base_class_offset(lv, (si*)(tk21*), 0, "zd05");
    check_base_class_offset(lv, (sj*)(tk21*), 0, "zd05");
    check_base_class_offset(lv, (tk21*), 0, "zd05");
    test_class_info(&lv, &cd_zd05);
    dp->~zd05();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd05(Test_zd05, "zd05", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zd05C1Ev();
extern void _ZN4zd05D1Ev();
Name_Map name_map_zd05[] = {
  NSPAIR(_ZN4zd05C1Ev),
  NSPAIR(_ZN4zd05D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_zd05[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_tk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd05[];
static  VTBL_ENTRY vtc_zd05[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd05[0]),
};
extern VTBL_ENTRY _ZTV4zd05[];
static  VTBL_ENTRY _tg__ZTV4tk21__4zd05[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTT_ENTRY vtt_zd05[] = {
  {&(_ZTV4zd05[5]),  5,5},
  {&(_ZTV4zd05[5]),  5,5},
  {&(_tg__ZTV4tk21__4zd05[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd05[];
extern  VTBL_ENTRY _ZTV4zd05[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd05[];
Class_Descriptor cd_zd05 = {  "zd05", // class name
  bases_zd05, 4,
  &(vtc_zd05[0]), // expected_vtbl_contents
  &(vtt_zd05[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zd05),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd05),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd05),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za06  : sk00 , tk22 {
};
//SIG(1 za06) C1{ BC2{} BC3{ BC4{} BC5{}}}



static void Test_za06()
{
  extern Class_Descriptor cd_za06;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_za06, buf);
    za06 &lv = *(new (buf) za06());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(za06)");
    check2(__alignof__(lv), 1, "__alignof__(za06)");
    check_base_class_offset(lv, (sk00*), 0, "za06");
    check_base_class_offset(lv, (si*)(tk22*), 0, "za06");
    check_base_class_offset(lv, (sj*)(tk22*), 0, "za06");
    check_base_class_offset(lv, (tk22*), 0, "za06");
    test_class_info(&lv, &cd_za06);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza06(Test_za06, "za06", 1);

#else // __cplusplus

extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_za06[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_tk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_za06 = {  "za06", // class name
  bases_za06, 4,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb06  : sk00 , virtual tk22 {
  ~zb06(); // tgen
  zb06(); // tgen
};
//SIG(1 zb06) C1{ BC2{} VBC3{ BC4{} BC5{}}}


zb06 ::~zb06(){ note_dtor("zb06", this);} // tgen
zb06 ::zb06(){ note_ctor("zb06", this);} // tgen

static void Test_zb06()
{
  extern Class_Descriptor cd_zb06;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zb06, buf);
    zb06 *dp, &lv = *(dp=new (buf) zb06());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zb06)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb06)");
    check_base_class_offset(lv, (sk00*), 0, "zb06");
    check_base_class_offset(lv, (si*)(tk22*), 0, "zb06");
    check_base_class_offset(lv, (sj*)(tk22*), 0, "zb06");
    check_base_class_offset(lv, (tk22*), 0, "zb06");
    test_class_info(&lv, &cd_zb06);
    dp->~zb06();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb06(Test_zb06, "zb06", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zb06C1Ev();
extern void _ZN4zb06D1Ev();
Name_Map name_map_zb06[] = {
  NSPAIR(_ZN4zb06C1Ev),
  NSPAIR(_ZN4zb06D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_zb06[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_tk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb06[];
static  VTBL_ENTRY vtc_zb06[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb06[0]),
};
extern VTBL_ENTRY _ZTV4zb06[];
static  VTT_ENTRY vtt_zb06[] = {
  {&(_ZTV4zb06[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb06[];
extern  VTBL_ENTRY _ZTV4zb06[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb06[];
Class_Descriptor cd_zb06 = {  "zb06", // class name
  bases_zb06, 4,
  &(vtc_zb06[0]), // expected_vtbl_contents
  &(vtt_zb06[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zb06),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb06),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb06),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc06  : virtual sk00 , tk22 {
  ~zc06(); // tgen
  zc06(); // tgen
};
//SIG(1 zc06) C1{ VBC2{} BC3{ BC4{} BC5{}}}


zc06 ::~zc06(){ note_dtor("zc06", this);} // tgen
zc06 ::zc06(){ note_ctor("zc06", this);} // tgen

static void Test_zc06()
{
  extern Class_Descriptor cd_zc06;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zc06, buf);
    zc06 *dp, &lv = *(dp=new (buf) zc06());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zc06)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc06)");
    check_base_class_offset(lv, (sk00*), 0, "zc06");
    check_base_class_offset(lv, (si*)(tk22*), 0, "zc06");
    check_base_class_offset(lv, (sj*)(tk22*), 0, "zc06");
    check_base_class_offset(lv, (tk22*), 0, "zc06");
    test_class_info(&lv, &cd_zc06);
    dp->~zc06();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc06(Test_zc06, "zc06", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zc06C1Ev();
extern void _ZN4zc06D1Ev();
Name_Map name_map_zc06[] = {
  NSPAIR(_ZN4zc06C1Ev),
  NSPAIR(_ZN4zc06D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_zc06[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_tk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc06[];
static  VTBL_ENTRY vtc_zc06[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc06[0]),
};
extern VTBL_ENTRY _ZTV4zc06[];
static  VTT_ENTRY vtt_zc06[] = {
  {&(_ZTV4zc06[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc06[];
extern  VTBL_ENTRY _ZTV4zc06[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc06[];
Class_Descriptor cd_zc06 = {  "zc06", // class name
  bases_zc06, 4,
  &(vtc_zc06[0]), // expected_vtbl_contents
  &(vtt_zc06[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zc06),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc06),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc06),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd06  : virtual sk00 , virtual tk22 {
  ~zd06(); // tgen
  zd06(); // tgen
};
//SIG(1 zd06) C1{ VBC2{} VBC3{ BC4{} BC5{}}}


zd06 ::~zd06(){ note_dtor("zd06", this);} // tgen
zd06 ::zd06(){ note_ctor("zd06", this);} // tgen

static void Test_zd06()
{
  extern Class_Descriptor cd_zd06;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zd06, buf);
    zd06 *dp, &lv = *(dp=new (buf) zd06());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zd06)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd06)");
    check_base_class_offset(lv, (sk00*), 0, "zd06");
    check_base_class_offset(lv, (si*)(tk22*), 0, "zd06");
    check_base_class_offset(lv, (sj*)(tk22*), 0, "zd06");
    check_base_class_offset(lv, (tk22*), 0, "zd06");
    test_class_info(&lv, &cd_zd06);
    dp->~zd06();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd06(Test_zd06, "zd06", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zd06C1Ev();
extern void _ZN4zd06D1Ev();
Name_Map name_map_zd06[] = {
  NSPAIR(_ZN4zd06C1Ev),
  NSPAIR(_ZN4zd06D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sk00;
extern VTBL_ENTRY _ZTI4sk00[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_zd06[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_tk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd06[];
static  VTBL_ENTRY vtc_zd06[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd06[0]),
};
extern VTBL_ENTRY _ZTV4zd06[];
static  VTT_ENTRY vtt_zd06[] = {
  {&(_ZTV4zd06[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zd06[];
extern  VTBL_ENTRY _ZTV4zd06[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd06[];
Class_Descriptor cd_zd06 = {  "zd06", // class name
  bases_zd06, 4,
  &(vtc_zd06[0]), // expected_vtbl_contents
  &(vtt_zd06[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zd06),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd06),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd06),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  xt1  : tk01 {
  ~xt1(); // tgen
  xt1(); // tgen
};
//SIG(1 xt1) C1{ BC2{ VBC3{}}}


xt1 ::~xt1(){ note_dtor("xt1", this);} // tgen
xt1 ::xt1(){ note_ctor("xt1", this);} // tgen

static void Test_xt1()
{
  extern Class_Descriptor cd_xt1;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_xt1, buf);
    xt1 *dp, &lv = *(dp=new (buf) xt1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(xt1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(xt1)");
    check_base_class_offset(lv, (sj*)(tk01*), 0, "xt1");
    check_base_class_offset(lv, (tk01*), 0, "xt1");
    test_class_info(&lv, &cd_xt1);
    dp->~xt1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vxt1(Test_xt1, "xt1", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3xt1C1Ev();
extern void _ZN3xt1D1Ev();
Name_Map name_map_xt1[] = {
  NSPAIR(_ZN3xt1C1Ev),
  NSPAIR(_ZN3xt1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_xt1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_tk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3xt1[];
static  VTBL_ENTRY vtc_xt1[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI3xt1[0]),
};
extern VTBL_ENTRY _ZTV3xt1[];
static  VTBL_ENTRY _tg__ZTV4tk01__3xt1[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTT_ENTRY vtt_xt1[] = {
  {&(_ZTV3xt1[3]),  3,3},
  {&(_tg__ZTV4tk01__3xt1[3]),  3,3},
};
extern VTBL_ENTRY _ZTI3xt1[];
extern  VTBL_ENTRY _ZTV3xt1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3xt1[];
Class_Descriptor cd_xt1 = {  "xt1", // class name
  bases_xt1, 2,
  &(vtc_xt1[0]), // expected_vtbl_contents
  &(vtt_xt1[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI3xt1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV3xt1),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3xt1),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  yt1  : virtual tk01 {
  ~yt1(); // tgen
  yt1(); // tgen
};
//SIG(1 yt1) C1{ VBC2{ VBC3{}}}


yt1 ::~yt1(){ note_dtor("yt1", this);} // tgen
yt1 ::yt1(){ note_ctor("yt1", this);} // tgen

static void Test_yt1()
{
  extern Class_Descriptor cd_yt1;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_yt1, buf);
    yt1 *dp, &lv = *(dp=new (buf) yt1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(yt1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(yt1)");
    check_base_class_offset(lv, (sj*)(tk01*), 0, "yt1");
    check_base_class_offset(lv, (tk01*), 0, "yt1");
    test_class_info(&lv, &cd_yt1);
    dp->~yt1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vyt1(Test_yt1, "yt1", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3yt1C1Ev();
extern void _ZN3yt1D1Ev();
Name_Map name_map_yt1[] = {
  NSPAIR(_ZN3yt1C1Ev),
  NSPAIR(_ZN3yt1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_yt1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_tk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3yt1[];
static  VTBL_ENTRY vtc_yt1[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI3yt1[0]),
};
extern VTBL_ENTRY _ZTV3yt1[];
static  VTBL_ENTRY _tg__ZTV4tk01__3yt1[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTT_ENTRY vtt_yt1[] = {
  {&(_ZTV3yt1[4]),  4,4},
  {&(_ZTV3yt1[4]),  4,4},
  {&(_tg__ZTV4tk01__3yt1[3]),  3,3},
};
extern VTBL_ENTRY _ZTI3yt1[];
extern  VTBL_ENTRY _ZTV3yt1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3yt1[];
Class_Descriptor cd_yt1 = {  "yt1", // class name
  bases_yt1, 2,
  &(vtc_yt1[0]), // expected_vtbl_contents
  &(vtt_yt1[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI3yt1),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV3yt1),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3yt1),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za10  : sk01 , tk00 {
  ~za10(); // tgen
  za10(); // tgen
};
//SIG(1 za10) C1{ BC2{ VBC3{}} BC4{}}


za10 ::~za10(){ note_dtor("za10", this);} // tgen
za10 ::za10(){ note_ctor("za10", this);} // tgen

static void Test_za10()
{
  extern Class_Descriptor cd_za10;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_za10, buf);
    za10 *dp, &lv = *(dp=new (buf) za10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(za10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za10)");
    check_base_class_offset(lv, (sj*)(sk01*), 0, "za10");
    check_base_class_offset(lv, (sk01*), 0, "za10");
    check_base_class_offset(lv, (tk00*), 0, "za10");
    test_class_info(&lv, &cd_za10);
    dp->~za10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza10(Test_za10, "za10", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4za10C1Ev();
extern void _ZN4za10D1Ev();
Name_Map name_map_za10[] = {
  NSPAIR(_ZN4za10C1Ev),
  NSPAIR(_ZN4za10D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_za10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za10[];
static  VTBL_ENTRY vtc_za10[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za10[0]),
};
extern VTBL_ENTRY _ZTV4za10[];
static  VTBL_ENTRY _tg__ZTV4sk01__4za10[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTT_ENTRY vtt_za10[] = {
  {&(_ZTV4za10[3]),  3,3},
  {&(_tg__ZTV4sk01__4za10[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4za10[];
extern  VTBL_ENTRY _ZTV4za10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za10[];
Class_Descriptor cd_za10 = {  "za10", // class name
  bases_za10, 3,
  &(vtc_za10[0]), // expected_vtbl_contents
  &(vtt_za10[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4za10),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za10),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za10),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb10  : sk01 , virtual tk00 {
  ~zb10(); // tgen
  zb10(); // tgen
};
//SIG(1 zb10) C1{ BC2{ VBC3{}} VBC4{}}


zb10 ::~zb10(){ note_dtor("zb10", this);} // tgen
zb10 ::zb10(){ note_ctor("zb10", this);} // tgen

static void Test_zb10()
{
  extern Class_Descriptor cd_zb10;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zb10, buf);
    zb10 *dp, &lv = *(dp=new (buf) zb10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zb10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb10)");
    check_base_class_offset(lv, (sj*)(sk01*), 0, "zb10");
    check_base_class_offset(lv, (sk01*), 0, "zb10");
    check_base_class_offset(lv, (tk00*), 0, "zb10");
    test_class_info(&lv, &cd_zb10);
    dp->~zb10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb10(Test_zb10, "zb10", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zb10C1Ev();
extern void _ZN4zb10D1Ev();
Name_Map name_map_zb10[] = {
  NSPAIR(_ZN4zb10C1Ev),
  NSPAIR(_ZN4zb10D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_zb10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb10[];
static  VTBL_ENTRY vtc_zb10[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb10[0]),
};
extern VTBL_ENTRY _ZTV4zb10[];
static  VTBL_ENTRY _tg__ZTV4sk01__4zb10[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTT_ENTRY vtt_zb10[] = {
  {&(_ZTV4zb10[4]),  4,4},
  {&(_tg__ZTV4sk01__4zb10[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb10[];
extern  VTBL_ENTRY _ZTV4zb10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb10[];
Class_Descriptor cd_zb10 = {  "zb10", // class name
  bases_zb10, 3,
  &(vtc_zb10[0]), // expected_vtbl_contents
  &(vtt_zb10[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zb10),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb10),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb10),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc10  : virtual sk01 , tk00 {
  ~zc10(); // tgen
  zc10(); // tgen
};
//SIG(1 zc10) C1{ VBC2{ VBC3{}} BC4{}}


zc10 ::~zc10(){ note_dtor("zc10", this);} // tgen
zc10 ::zc10(){ note_ctor("zc10", this);} // tgen

static void Test_zc10()
{
  extern Class_Descriptor cd_zc10;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zc10, buf);
    zc10 *dp, &lv = *(dp=new (buf) zc10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zc10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc10)");
    check_base_class_offset(lv, (sj*)(sk01*), 0, "zc10");
    check_base_class_offset(lv, (sk01*), 0, "zc10");
    check_base_class_offset(lv, (tk00*), 0, "zc10");
    test_class_info(&lv, &cd_zc10);
    dp->~zc10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc10(Test_zc10, "zc10", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zc10C1Ev();
extern void _ZN4zc10D1Ev();
Name_Map name_map_zc10[] = {
  NSPAIR(_ZN4zc10C1Ev),
  NSPAIR(_ZN4zc10D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_zc10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc10[];
static  VTBL_ENTRY vtc_zc10[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc10[0]),
};
extern VTBL_ENTRY _ZTV4zc10[];
static  VTBL_ENTRY _tg__ZTV4sk01__4zc10[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTT_ENTRY vtt_zc10[] = {
  {&(_ZTV4zc10[4]),  4,4},
  {&(_ZTV4zc10[4]),  4,4},
  {&(_tg__ZTV4sk01__4zc10[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc10[];
extern  VTBL_ENTRY _ZTV4zc10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc10[];
Class_Descriptor cd_zc10 = {  "zc10", // class name
  bases_zc10, 3,
  &(vtc_zc10[0]), // expected_vtbl_contents
  &(vtt_zc10[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zc10),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc10),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc10),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd10  : virtual sk01 , virtual tk00 {
  ~zd10(); // tgen
  zd10(); // tgen
};
//SIG(1 zd10) C1{ VBC2{ VBC3{}} VBC4{}}


zd10 ::~zd10(){ note_dtor("zd10", this);} // tgen
zd10 ::zd10(){ note_ctor("zd10", this);} // tgen

static void Test_zd10()
{
  extern Class_Descriptor cd_zd10;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zd10, buf);
    zd10 *dp, &lv = *(dp=new (buf) zd10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zd10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd10)");
    check_base_class_offset(lv, (sj*)(sk01*), 0, "zd10");
    check_base_class_offset(lv, (sk01*), 0, "zd10");
    check_base_class_offset(lv, (tk00*), 0, "zd10");
    test_class_info(&lv, &cd_zd10);
    dp->~zd10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd10(Test_zd10, "zd10", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zd10C1Ev();
extern void _ZN4zd10D1Ev();
Name_Map name_map_zd10[] = {
  NSPAIR(_ZN4zd10C1Ev),
  NSPAIR(_ZN4zd10D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_zd10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd10[];
static  VTBL_ENTRY vtc_zd10[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd10[0]),
};
extern VTBL_ENTRY _ZTV4zd10[];
static  VTBL_ENTRY _tg__ZTV4sk01__4zd10[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTT_ENTRY vtt_zd10[] = {
  {&(_ZTV4zd10[5]),  5,5},
  {&(_ZTV4zd10[5]),  5,5},
  {&(_tg__ZTV4sk01__4zd10[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd10[];
extern  VTBL_ENTRY _ZTV4zd10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd10[];
Class_Descriptor cd_zd10 = {  "zd10", // class name
  bases_zd10, 3,
  &(vtc_zd10[0]), // expected_vtbl_contents
  &(vtt_zd10[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zd10),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd10),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd10),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za11  : sk01 , tk01 {
  ~za11(); // tgen
  za11(); // tgen
};
//SIG(1 za11) C1{ BC2{ VBC3{}} BC4{ VBC3}}


za11 ::~za11(){ note_dtor("za11", this);} // tgen
za11 ::za11(){ note_ctor("za11", this);} // tgen

static void Test_za11()
{
  extern Class_Descriptor cd_za11;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za11, buf);
    za11 *dp, &lv = *(dp=new (buf) za11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za11)");
    check_base_class_offset(lv, (sj*)(sk01*), 0, "za11");
    check_base_class_offset(lv, (sj*)(tk01*), 0, "za11");
    check_base_class_offset(lv, (sk01*), 0, "za11");
    check_base_class_offset(lv, (tk01*), ABISELECT(8,4), "za11");
    test_class_info(&lv, &cd_za11);
    dp->~za11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza11(Test_za11, "za11", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za11C1Ev();
extern void _ZN4za11D1Ev();
Name_Map name_map_za11[] = {
  NSPAIR(_ZN4za11C1Ev),
  NSPAIR(_ZN4za11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_za11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_tk01,    ABISELECT(8,4), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za11[];
static  VTBL_ENTRY vtc_za11[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za11[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4za11[0]),
};
extern VTBL_ENTRY _ZTV4za11[];
static  VTBL_ENTRY _tg__ZTV4sk01__4za11[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk01__4za11[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTT_ENTRY vtt_za11[] = {
  {&(_ZTV4za11[3]),  3,6},
  {&(_tg__ZTV4sk01__4za11[3]),  3,3},
  {&(_tg__ZTV4tk01__4za11[3]),  3,3},
  {&(_ZTV4za11[6]),  6,6},
};
extern VTBL_ENTRY _ZTI4za11[];
extern  VTBL_ENTRY _ZTV4za11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za11[];
Class_Descriptor cd_za11 = {  "za11", // class name
  bases_za11, 3,
  &(vtc_za11[0]), // expected_vtbl_contents
  &(vtt_za11[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za11),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za11),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za11),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb11  : sk01 , virtual tk01 {
  ~zb11(); // tgen
  zb11(); // tgen
};
//SIG(1 zb11) C1{ BC2{ VBC3{}} VBC4{ VBC3}}


zb11 ::~zb11(){ note_dtor("zb11", this);} // tgen
zb11 ::zb11(){ note_ctor("zb11", this);} // tgen

static void Test_zb11()
{
  extern Class_Descriptor cd_zb11;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb11, buf);
    zb11 *dp, &lv = *(dp=new (buf) zb11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb11)");
    check_base_class_offset(lv, (sj*)(sk01*), 0, "zb11");
    check_base_class_offset(lv, (sj*)(tk01*), 0, "zb11");
    check_base_class_offset(lv, (sk01*), 0, "zb11");
    check_base_class_offset(lv, (tk01*), ABISELECT(8,4), "zb11");
    test_class_info(&lv, &cd_zb11);
    dp->~zb11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb11(Test_zb11, "zb11", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb11C1Ev();
extern void _ZN4zb11D1Ev();
Name_Map name_map_zb11[] = {
  NSPAIR(_ZN4zb11C1Ev),
  NSPAIR(_ZN4zb11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_zb11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_tk01,    ABISELECT(8,4), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb11[];
static  VTBL_ENTRY vtc_zb11[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb11[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zb11[0]),
};
extern VTBL_ENTRY _ZTV4zb11[];
static  VTBL_ENTRY _tg__ZTV4sk01__4zb11[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk01__4zb11[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTT_ENTRY vtt_zb11[] = {
  {&(_ZTV4zb11[4]),  4,7},
  {&(_tg__ZTV4sk01__4zb11[3]),  3,3},
  {&(_ZTV4zb11[7]),  7,7},
  {&(_tg__ZTV4tk01__4zb11[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb11[];
extern  VTBL_ENTRY _ZTV4zb11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb11[];
Class_Descriptor cd_zb11 = {  "zb11", // class name
  bases_zb11, 3,
  &(vtc_zb11[0]), // expected_vtbl_contents
  &(vtt_zb11[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb11),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb11),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb11),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc11  : virtual sk01 , tk01 {
  ~zc11(); // tgen
  zc11(); // tgen
};
//SIG(1 zc11) C1{ VBC2{ VBC3{}} BC4{ VBC3}}


zc11 ::~zc11(){ note_dtor("zc11", this);} // tgen
zc11 ::zc11(){ note_ctor("zc11", this);} // tgen

static void Test_zc11()
{
  extern Class_Descriptor cd_zc11;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc11, buf);
    zc11 *dp, &lv = *(dp=new (buf) zc11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc11)");
    check_base_class_offset(lv, (sj*)(sk01*), 0, "zc11");
    check_base_class_offset(lv, (sj*)(tk01*), 0, "zc11");
    check_base_class_offset(lv, (sk01*), ABISELECT(8,4), "zc11");
    check_base_class_offset(lv, (tk01*), 0, "zc11");
    test_class_info(&lv, &cd_zc11);
    dp->~zc11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc11(Test_zc11, "zc11", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc11C1Ev();
extern void _ZN4zc11D1Ev();
Name_Map name_map_zc11[] = {
  NSPAIR(_ZN4zc11C1Ev),
  NSPAIR(_ZN4zc11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_zc11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    ABISELECT(8,4), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_tk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc11[];
static  VTBL_ENTRY vtc_zc11[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc11[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zc11[0]),
};
extern VTBL_ENTRY _ZTV4zc11[];
static  VTBL_ENTRY _tg__ZTV4tk01__4zc11[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTBL_ENTRY _tg__ZTV4sk01__4zc11[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTT_ENTRY vtt_zc11[] = {
  {&(_ZTV4zc11[4]),  4,7},
  {&(_tg__ZTV4tk01__4zc11[3]),  3,3},
  {&(_ZTV4zc11[7]),  7,7},
  {&(_tg__ZTV4sk01__4zc11[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc11[];
extern  VTBL_ENTRY _ZTV4zc11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc11[];
Class_Descriptor cd_zc11 = {  "zc11", // class name
  bases_zc11, 3,
  &(vtc_zc11[0]), // expected_vtbl_contents
  &(vtt_zc11[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc11),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc11),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc11),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd11  : virtual sk01 , virtual tk01 {
  ~zd11(); // tgen
  zd11(); // tgen
};
//SIG(1 zd11) C1{ VBC2{ VBC3{}} VBC4{ VBC3}}


zd11 ::~zd11(){ note_dtor("zd11", this);} // tgen
zd11 ::zd11(){ note_ctor("zd11", this);} // tgen

static void Test_zd11()
{
  extern Class_Descriptor cd_zd11;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd11, buf);
    zd11 *dp, &lv = *(dp=new (buf) zd11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd11)");
    check_base_class_offset(lv, (sj*)(sk01*), 0, "zd11");
    check_base_class_offset(lv, (sj*)(tk01*), 0, "zd11");
    check_base_class_offset(lv, (sk01*), 0, "zd11");
    check_base_class_offset(lv, (tk01*), ABISELECT(8,4), "zd11");
    test_class_info(&lv, &cd_zd11);
    dp->~zd11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd11(Test_zd11, "zd11", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd11C1Ev();
extern void _ZN4zd11D1Ev();
Name_Map name_map_zd11[] = {
  NSPAIR(_ZN4zd11C1Ev),
  NSPAIR(_ZN4zd11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_zd11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_tk01,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd11[];
static  VTBL_ENTRY vtc_zd11[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd11[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zd11[0]),
};
extern VTBL_ENTRY _ZTV4zd11[];
static  VTBL_ENTRY _tg__ZTV4sk01__4zd11[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk01__4zd11[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTT_ENTRY vtt_zd11[] = {
  {&(_ZTV4zd11[5]),  5,8},
  {&(_ZTV4zd11[5]),  5,8},
  {&(_ZTV4zd11[8]),  8,8},
  {&(_tg__ZTV4sk01__4zd11[3]),  3,3},
  {&(_tg__ZTV4tk01__4zd11[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd11[];
extern  VTBL_ENTRY _ZTV4zd11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd11[];
Class_Descriptor cd_zd11 = {  "zd11", // class name
  bases_zd11, 3,
  &(vtc_zd11[0]), // expected_vtbl_contents
  &(vtt_zd11[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd11),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd11),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd11),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za12  : sk01 , tk02 {
  ~za12(); // tgen
  za12(); // tgen
};
//SIG(1 za12) C1{ BC2{ VBC3{}} BC4{ BC3}}


za12 ::~za12(){ note_dtor("za12", this);} // tgen
za12 ::za12(){ note_ctor("za12", this);} // tgen

static void Test_za12()
{
  extern Class_Descriptor cd_za12;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za12, buf);
    za12 *dp, &lv = *(dp=new (buf) za12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za12)");
    check_base_class_offset(lv, (sj*)(sk01*), ABISELECT(8,4), "za12");
    check_base_class_offset(lv, (sk01*), 0, "za12");
    check_base_class_offset(lv, (sj*)(tk02*), 0, "za12");
    check_base_class_offset(lv, (tk02*), 0, "za12");
    test_class_info(&lv, &cd_za12);
    dp->~za12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza12(Test_za12, "za12", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za12C1Ev();
extern void _ZN4za12D1Ev();
Name_Map name_map_za12[] = {
  NSPAIR(_ZN4za12C1Ev),
  NSPAIR(_ZN4za12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_za12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_tk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za12[];
static  VTBL_ENTRY vtc_za12[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4za12[0]),
};
extern VTBL_ENTRY _ZTV4za12[];
static  VTBL_ENTRY _tg__ZTV4sk01__4za12[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTT_ENTRY vtt_za12[] = {
  {&(_ZTV4za12[3]),  3,3},
  {&(_tg__ZTV4sk01__4za12[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4za12[];
extern  VTBL_ENTRY _ZTV4za12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za12[];
Class_Descriptor cd_za12 = {  "za12", // class name
  bases_za12, 4,
  &(vtc_za12[0]), // expected_vtbl_contents
  &(vtt_za12[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za12),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za12),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb12  : sk01 , virtual tk02 {
  ~zb12(); // tgen
  zb12(); // tgen
};
//SIG(1 zb12) C1{ BC2{ VBC3{}} VBC4{ BC3}}


zb12 ::~zb12(){ note_dtor("zb12", this);} // tgen
zb12 ::zb12(){ note_ctor("zb12", this);} // tgen

static void Test_zb12()
{
  extern Class_Descriptor cd_zb12;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb12, buf);
    zb12 *dp, &lv = *(dp=new (buf) zb12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb12)");
    check_base_class_offset(lv, (sj*)(sk01*), 0, "zb12");
    check_base_class_offset(lv, (sk01*), 0, "zb12");
    check_base_class_offset(lv, (sj*)(tk02*), ABISELECT(8,4), "zb12");
    check_base_class_offset(lv, (tk02*), ABISELECT(8,4), "zb12");
    test_class_info(&lv, &cd_zb12);
    dp->~zb12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb12(Test_zb12, "zb12", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb12C1Ev();
extern void _ZN4zb12D1Ev();
Name_Map name_map_zb12[] = {
  NSPAIR(_ZN4zb12C1Ev),
  NSPAIR(_ZN4zb12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_zb12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_tk02,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb12[];
static  VTBL_ENTRY vtc_zb12[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb12[0]),
};
extern VTBL_ENTRY _ZTV4zb12[];
static  VTBL_ENTRY _tg__ZTV4sk01__4zb12[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTT_ENTRY vtt_zb12[] = {
  {&(_ZTV4zb12[4]),  4,4},
  {&(_tg__ZTV4sk01__4zb12[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb12[];
extern  VTBL_ENTRY _ZTV4zb12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb12[];
Class_Descriptor cd_zb12 = {  "zb12", // class name
  bases_zb12, 4,
  &(vtc_zb12[0]), // expected_vtbl_contents
  &(vtt_zb12[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb12),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb12),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc12  : virtual sk01 , tk02 {
  ~zc12(); // tgen
  zc12(); // tgen
};
//SIG(1 zc12) C1{ VBC2{ VBC3{}} BC4{ BC3}}


zc12 ::~zc12(){ note_dtor("zc12", this);} // tgen
zc12 ::zc12(){ note_ctor("zc12", this);} // tgen

static void Test_zc12()
{
  extern Class_Descriptor cd_zc12;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc12, buf);
    zc12 *dp, &lv = *(dp=new (buf) zc12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc12)");
    check_base_class_offset(lv, (sj*)(sk01*), ABISELECT(8,4), "zc12");
    check_base_class_offset(lv, (sk01*), 0, "zc12");
    check_base_class_offset(lv, (sj*)(tk02*), 0, "zc12");
    check_base_class_offset(lv, (tk02*), 0, "zc12");
    test_class_info(&lv, &cd_zc12);
    dp->~zc12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc12(Test_zc12, "zc12", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc12C1Ev();
extern void _ZN4zc12D1Ev();
Name_Map name_map_zc12[] = {
  NSPAIR(_ZN4zc12C1Ev),
  NSPAIR(_ZN4zc12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_zc12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_tk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc12[];
static  VTBL_ENTRY vtc_zc12[] = {
  0,
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4zc12[0]),
};
extern VTBL_ENTRY _ZTV4zc12[];
static  VTBL_ENTRY _tg__ZTV4sk01__4zc12[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTT_ENTRY vtt_zc12[] = {
  {&(_ZTV4zc12[4]),  4,4},
  {&(_ZTV4zc12[4]),  4,4},
  {&(_tg__ZTV4sk01__4zc12[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc12[];
extern  VTBL_ENTRY _ZTV4zc12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc12[];
Class_Descriptor cd_zc12 = {  "zc12", // class name
  bases_zc12, 4,
  &(vtc_zc12[0]), // expected_vtbl_contents
  &(vtt_zc12[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc12),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc12),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd12  : virtual sk01 , virtual tk02 {
  ~zd12(); // tgen
  zd12(); // tgen
};
//SIG(1 zd12) C1{ VBC2{ VBC3{}} VBC4{ BC3}}


zd12 ::~zd12(){ note_dtor("zd12", this);} // tgen
zd12 ::zd12(){ note_ctor("zd12", this);} // tgen

static void Test_zd12()
{
  extern Class_Descriptor cd_zd12;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd12, buf);
    zd12 *dp, &lv = *(dp=new (buf) zd12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd12)");
    check_base_class_offset(lv, (sj*)(sk01*), 0, "zd12");
    check_base_class_offset(lv, (sk01*), 0, "zd12");
    check_base_class_offset(lv, (sj*)(tk02*), ABISELECT(8,4), "zd12");
    check_base_class_offset(lv, (tk02*), ABISELECT(8,4), "zd12");
    test_class_info(&lv, &cd_zd12);
    dp->~zd12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd12(Test_zd12, "zd12", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd12C1Ev();
extern void _ZN4zd12D1Ev();
Name_Map name_map_zd12[] = {
  NSPAIR(_ZN4zd12C1Ev),
  NSPAIR(_ZN4zd12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_zd12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_tk02,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd12[];
static  VTBL_ENTRY vtc_zd12[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd12[0]),
};
extern VTBL_ENTRY _ZTV4zd12[];
static  VTBL_ENTRY _tg__ZTV4sk01__4zd12[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTT_ENTRY vtt_zd12[] = {
  {&(_ZTV4zd12[5]),  5,5},
  {&(_ZTV4zd12[5]),  5,5},
  {&(_tg__ZTV4sk01__4zd12[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd12[];
extern  VTBL_ENTRY _ZTV4zd12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd12[];
Class_Descriptor cd_zd12 = {  "zd12", // class name
  bases_zd12, 4,
  &(vtc_zd12[0]), // expected_vtbl_contents
  &(vtt_zd12[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd12),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd12),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd12),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za13  : sk01 , tk11 {
  ~za13(); // tgen
  za13(); // tgen
};
//SIG(1 za13) C1{ BC2{ VBC3{}} BC4{ VBC5{} VBC3}}


za13 ::~za13(){ note_dtor("za13", this);} // tgen
za13 ::za13(){ note_ctor("za13", this);} // tgen

static void Test_za13()
{
  extern Class_Descriptor cd_za13;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za13, buf);
    za13 *dp, &lv = *(dp=new (buf) za13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za13)");
    check_base_class_offset(lv, (sj*)(sk01*), 0, "za13");
    check_base_class_offset(lv, (sj*)(tk11*), 0, "za13");
    check_base_class_offset(lv, (sk01*), 0, "za13");
    check_base_class_offset(lv, (si*)(tk11*), 0, "za13");
    check_base_class_offset(lv, (tk11*), ABISELECT(8,4), "za13");
    test_class_info(&lv, &cd_za13);
    dp->~za13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza13(Test_za13, "za13", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za13C1Ev();
extern void _ZN4za13D1Ev();
Name_Map name_map_za13[] = {
  NSPAIR(_ZN4za13C1Ev),
  NSPAIR(_ZN4za13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_za13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_tk11,    ABISELECT(8,4), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za13[];
static  VTBL_ENTRY vtc_za13[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za13[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4za13[0]),
};
extern VTBL_ENTRY _ZTV4za13[];
static  VTBL_ENTRY _tg__ZTV4sk01__4za13[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk11__4za13[] = {
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTT_ENTRY vtt_za13[] = {
  {&(_ZTV4za13[4]),  4,8},
  {&(_tg__ZTV4sk01__4za13[3]),  3,3},
  {&(_tg__ZTV4tk11__4za13[4]),  4,4},
  {&(_ZTV4za13[8]),  8,8},
};
extern VTBL_ENTRY _ZTI4za13[];
extern  VTBL_ENTRY _ZTV4za13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za13[];
Class_Descriptor cd_za13 = {  "za13", // class name
  bases_za13, 4,
  &(vtc_za13[0]), // expected_vtbl_contents
  &(vtt_za13[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za13),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za13),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za13),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb13  : sk01 , virtual tk11 {
  ~zb13(); // tgen
  zb13(); // tgen
};
//SIG(1 zb13) C1{ BC2{ VBC3{}} VBC4{ VBC5{} VBC3}}


zb13 ::~zb13(){ note_dtor("zb13", this);} // tgen
zb13 ::zb13(){ note_ctor("zb13", this);} // tgen

static void Test_zb13()
{
  extern Class_Descriptor cd_zb13;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb13, buf);
    zb13 *dp, &lv = *(dp=new (buf) zb13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb13)");
    check_base_class_offset(lv, (sj*)(sk01*), 0, "zb13");
    check_base_class_offset(lv, (sj*)(tk11*), 0, "zb13");
    check_base_class_offset(lv, (sk01*), 0, "zb13");
    check_base_class_offset(lv, (si*)(tk11*), 0, "zb13");
    check_base_class_offset(lv, (tk11*), ABISELECT(8,4), "zb13");
    test_class_info(&lv, &cd_zb13);
    dp->~zb13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb13(Test_zb13, "zb13", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb13C1Ev();
extern void _ZN4zb13D1Ev();
Name_Map name_map_zb13[] = {
  NSPAIR(_ZN4zb13C1Ev),
  NSPAIR(_ZN4zb13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_zb13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_tk11,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb13[];
static  VTBL_ENTRY vtc_zb13[] = {
  0,
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb13[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zb13[0]),
};
extern VTBL_ENTRY _ZTV4zb13[];
static  VTBL_ENTRY _tg__ZTV4sk01__4zb13[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk11__4zb13[] = {
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTT_ENTRY vtt_zb13[] = {
  {&(_ZTV4zb13[5]),  5,9},
  {&(_tg__ZTV4sk01__4zb13[3]),  3,3},
  {&(_ZTV4zb13[9]),  9,9},
  {&(_tg__ZTV4tk11__4zb13[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zb13[];
extern  VTBL_ENTRY _ZTV4zb13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb13[];
Class_Descriptor cd_zb13 = {  "zb13", // class name
  bases_zb13, 4,
  &(vtc_zb13[0]), // expected_vtbl_contents
  &(vtt_zb13[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb13),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb13),9, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb13),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc13  : virtual sk01 , tk11 {
  ~zc13(); // tgen
  zc13(); // tgen
};
//SIG(1 zc13) C1{ VBC2{ VBC3{}} BC4{ VBC5{} VBC3}}


zc13 ::~zc13(){ note_dtor("zc13", this);} // tgen
zc13 ::zc13(){ note_ctor("zc13", this);} // tgen

static void Test_zc13()
{
  extern Class_Descriptor cd_zc13;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc13, buf);
    zc13 *dp, &lv = *(dp=new (buf) zc13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc13)");
    check_base_class_offset(lv, (sj*)(sk01*), 0, "zc13");
    check_base_class_offset(lv, (sj*)(tk11*), 0, "zc13");
    check_base_class_offset(lv, (sk01*), ABISELECT(8,4), "zc13");
    check_base_class_offset(lv, (si*)(tk11*), 0, "zc13");
    check_base_class_offset(lv, (tk11*), 0, "zc13");
    test_class_info(&lv, &cd_zc13);
    dp->~zc13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc13(Test_zc13, "zc13", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc13C1Ev();
extern void _ZN4zc13D1Ev();
Name_Map name_map_zc13[] = {
  NSPAIR(_ZN4zc13C1Ev),
  NSPAIR(_ZN4zc13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_zc13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_tk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc13[];
static  VTBL_ENTRY vtc_zc13[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc13[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zc13[0]),
};
extern VTBL_ENTRY _ZTV4zc13[];
static  VTBL_ENTRY _tg__ZTV4tk11__4zc13[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTBL_ENTRY _tg__ZTV4sk01__4zc13[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTT_ENTRY vtt_zc13[] = {
  {&(_ZTV4zc13[5]),  5,8},
  {&(_tg__ZTV4tk11__4zc13[4]),  4,4},
  {&(_ZTV4zc13[8]),  8,8},
  {&(_tg__ZTV4sk01__4zc13[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc13[];
extern  VTBL_ENTRY _ZTV4zc13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc13[];
Class_Descriptor cd_zc13 = {  "zc13", // class name
  bases_zc13, 4,
  &(vtc_zc13[0]), // expected_vtbl_contents
  &(vtt_zc13[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc13),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc13),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc13),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd13  : virtual sk01 , virtual tk11 {
  ~zd13(); // tgen
  zd13(); // tgen
};
//SIG(1 zd13) C1{ VBC2{ VBC3{}} VBC4{ VBC5{} VBC3}}


zd13 ::~zd13(){ note_dtor("zd13", this);} // tgen
zd13 ::zd13(){ note_ctor("zd13", this);} // tgen

static void Test_zd13()
{
  extern Class_Descriptor cd_zd13;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd13, buf);
    zd13 *dp, &lv = *(dp=new (buf) zd13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd13)");
    check_base_class_offset(lv, (sj*)(sk01*), 0, "zd13");
    check_base_class_offset(lv, (sj*)(tk11*), 0, "zd13");
    check_base_class_offset(lv, (sk01*), 0, "zd13");
    check_base_class_offset(lv, (si*)(tk11*), 0, "zd13");
    check_base_class_offset(lv, (tk11*), ABISELECT(8,4), "zd13");
    test_class_info(&lv, &cd_zd13);
    dp->~zd13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd13(Test_zd13, "zd13", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd13C1Ev();
extern void _ZN4zd13D1Ev();
Name_Map name_map_zd13[] = {
  NSPAIR(_ZN4zd13C1Ev),
  NSPAIR(_ZN4zd13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_zd13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_tk11,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd13[];
static  VTBL_ENTRY vtc_zd13[] = {
  0,
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd13[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zd13[0]),
};
extern VTBL_ENTRY _ZTV4zd13[];
static  VTBL_ENTRY _tg__ZTV4sk01__4zd13[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk11__4zd13[] = {
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTT_ENTRY vtt_zd13[] = {
  {&(_ZTV4zd13[6]),  6,10},
  {&(_ZTV4zd13[6]),  6,10},
  {&(_ZTV4zd13[10]),  10,10},
  {&(_tg__ZTV4sk01__4zd13[3]),  3,3},
  {&(_tg__ZTV4tk11__4zd13[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zd13[];
extern  VTBL_ENTRY _ZTV4zd13[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd13[];
Class_Descriptor cd_zd13 = {  "zd13", // class name
  bases_zd13, 4,
  &(vtc_zd13[0]), // expected_vtbl_contents
  &(vtt_zd13[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd13),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd13),10, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd13),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za14  : sk01 , tk12 {
  ~za14(); // tgen
  za14(); // tgen
};
//SIG(1 za14) C1{ BC2{ VBC3{}} BC4{ VBC5{} BC3}}


za14 ::~za14(){ note_dtor("za14", this);} // tgen
za14 ::za14(){ note_ctor("za14", this);} // tgen

static void Test_za14()
{
  extern Class_Descriptor cd_za14;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za14, buf);
    za14 *dp, &lv = *(dp=new (buf) za14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za14)");
    check_base_class_offset(lv, (sj*)(sk01*), 0, "za14");
    check_base_class_offset(lv, (sk01*), 0, "za14");
    check_base_class_offset(lv, (si*)(tk12*), 0, "za14");
    check_base_class_offset(lv, (sj*)(tk12*), ABISELECT(8,4), "za14");
    check_base_class_offset(lv, (tk12*), ABISELECT(8,4), "za14");
    test_class_info(&lv, &cd_za14);
    dp->~za14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza14(Test_za14, "za14", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za14C1Ev();
extern void _ZN4za14D1Ev();
Name_Map name_map_za14[] = {
  NSPAIR(_ZN4za14C1Ev),
  NSPAIR(_ZN4za14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_za14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk12,    ABISELECT(8,4), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za14[];
static  VTBL_ENTRY vtc_za14[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za14[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4za14[0]),
};
extern VTBL_ENTRY _ZTV4za14[];
static  VTBL_ENTRY _tg__ZTV4sk01__4za14[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk12__4za14[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTT_ENTRY vtt_za14[] = {
  {&(_ZTV4za14[4]),  4,7},
  {&(_tg__ZTV4sk01__4za14[3]),  3,3},
  {&(_tg__ZTV4tk12__4za14[3]),  3,3},
  {&(_ZTV4za14[7]),  7,7},
};
extern VTBL_ENTRY _ZTI4za14[];
extern  VTBL_ENTRY _ZTV4za14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za14[];
Class_Descriptor cd_za14 = {  "za14", // class name
  bases_za14, 5,
  &(vtc_za14[0]), // expected_vtbl_contents
  &(vtt_za14[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za14),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za14),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za14),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb14  : sk01 , virtual tk12 {
  ~zb14(); // tgen
  zb14(); // tgen
};
//SIG(1 zb14) C1{ BC2{ VBC3{}} VBC4{ VBC5{} BC3}}


zb14 ::~zb14(){ note_dtor("zb14", this);} // tgen
zb14 ::zb14(){ note_ctor("zb14", this);} // tgen

static void Test_zb14()
{
  extern Class_Descriptor cd_zb14;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb14, buf);
    zb14 *dp, &lv = *(dp=new (buf) zb14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb14)");
    check_base_class_offset(lv, (sj*)(sk01*), 0, "zb14");
    check_base_class_offset(lv, (sk01*), 0, "zb14");
    check_base_class_offset(lv, (si*)(tk12*), 0, "zb14");
    check_base_class_offset(lv, (sj*)(tk12*), ABISELECT(8,4), "zb14");
    check_base_class_offset(lv, (tk12*), ABISELECT(8,4), "zb14");
    test_class_info(&lv, &cd_zb14);
    dp->~zb14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb14(Test_zb14, "zb14", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb14C1Ev();
extern void _ZN4zb14D1Ev();
Name_Map name_map_zb14[] = {
  NSPAIR(_ZN4zb14C1Ev),
  NSPAIR(_ZN4zb14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_zb14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk12,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb14[];
static  VTBL_ENTRY vtc_zb14[] = {
  0,
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb14[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zb14[0]),
};
extern VTBL_ENTRY _ZTV4zb14[];
static  VTBL_ENTRY _tg__ZTV4sk01__4zb14[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk12__4zb14[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTT_ENTRY vtt_zb14[] = {
  {&(_ZTV4zb14[5]),  5,8},
  {&(_tg__ZTV4sk01__4zb14[3]),  3,3},
  {&(_ZTV4zb14[8]),  8,8},
  {&(_tg__ZTV4tk12__4zb14[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb14[];
extern  VTBL_ENTRY _ZTV4zb14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb14[];
Class_Descriptor cd_zb14 = {  "zb14", // class name
  bases_zb14, 5,
  &(vtc_zb14[0]), // expected_vtbl_contents
  &(vtt_zb14[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb14),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb14),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb14),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc14  : virtual sk01 , tk12 {
  ~zc14(); // tgen
  zc14(); // tgen
};
//SIG(1 zc14) C1{ VBC2{ VBC3{}} BC4{ VBC5{} BC3}}


zc14 ::~zc14(){ note_dtor("zc14", this);} // tgen
zc14 ::zc14(){ note_ctor("zc14", this);} // tgen

static void Test_zc14()
{
  extern Class_Descriptor cd_zc14;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_zc14, buf);
    zc14 *dp, &lv = *(dp=new (buf) zc14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(zc14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc14)");
    check_base_class_offset(lv, (sj*)(sk01*), ABISELECT(16,8), "zc14");
    check_base_class_offset(lv, (sk01*), ABISELECT(8,4), "zc14");
    check_base_class_offset(lv, (si*)(tk12*), 0, "zc14");
    check_base_class_offset(lv, (sj*)(tk12*), 0, "zc14");
    check_base_class_offset(lv, (tk12*), 0, "zc14");
    test_class_info(&lv, &cd_zc14);
    dp->~zc14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc14(Test_zc14, "zc14", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN4zc14C1Ev();
extern void _ZN4zc14D1Ev();
Name_Map name_map_zc14[] = {
  NSPAIR(_ZN4zc14C1Ev),
  NSPAIR(_ZN4zc14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_zc14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc14[];
static  VTBL_ENTRY vtc_zc14[] = {
  ABISELECT(16,8),
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc14[0]),
  ABISELECT(8,4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zc14[0]),
};
extern VTBL_ENTRY _ZTV4zc14[];
static  VTBL_ENTRY _tg__ZTV4tk12__4zc14[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTBL_ENTRY _tg__ZTV4sk01__4zc14[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTT_ENTRY vtt_zc14[] = {
  {&(_ZTV4zc14[5]),  5,8},
  {&(_tg__ZTV4tk12__4zc14[3]),  3,3},
  {&(_ZTV4zc14[8]),  8,8},
  {&(_tg__ZTV4sk01__4zc14[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc14[];
extern  VTBL_ENTRY _ZTV4zc14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc14[];
Class_Descriptor cd_zc14 = {  "zc14", // class name
  bases_zc14, 5,
  &(vtc_zc14[0]), // expected_vtbl_contents
  &(vtt_zc14[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI4zc14),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc14),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc14),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd14  : virtual sk01 , virtual tk12 {
  ~zd14(); // tgen
  zd14(); // tgen
};
//SIG(1 zd14) C1{ VBC2{ VBC3{}} VBC4{ VBC5{} BC3}}


zd14 ::~zd14(){ note_dtor("zd14", this);} // tgen
zd14 ::zd14(){ note_ctor("zd14", this);} // tgen

static void Test_zd14()
{
  extern Class_Descriptor cd_zd14;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd14, buf);
    zd14 *dp, &lv = *(dp=new (buf) zd14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd14)");
    check_base_class_offset(lv, (sj*)(sk01*), 0, "zd14");
    check_base_class_offset(lv, (sk01*), 0, "zd14");
    check_base_class_offset(lv, (si*)(tk12*), 0, "zd14");
    check_base_class_offset(lv, (sj*)(tk12*), ABISELECT(8,4), "zd14");
    check_base_class_offset(lv, (tk12*), ABISELECT(8,4), "zd14");
    test_class_info(&lv, &cd_zd14);
    dp->~zd14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd14(Test_zd14, "zd14", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd14C1Ev();
extern void _ZN4zd14D1Ev();
Name_Map name_map_zd14[] = {
  NSPAIR(_ZN4zd14C1Ev),
  NSPAIR(_ZN4zd14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_zd14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk12,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd14[];
static  VTBL_ENTRY vtc_zd14[] = {
  0,
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd14[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zd14[0]),
};
extern VTBL_ENTRY _ZTV4zd14[];
static  VTBL_ENTRY _tg__ZTV4sk01__4zd14[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk12__4zd14[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTT_ENTRY vtt_zd14[] = {
  {&(_ZTV4zd14[6]),  6,9},
  {&(_ZTV4zd14[6]),  6,9},
  {&(_ZTV4zd14[9]),  9,9},
  {&(_tg__ZTV4sk01__4zd14[3]),  3,3},
  {&(_tg__ZTV4tk12__4zd14[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd14[];
extern  VTBL_ENTRY _ZTV4zd14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd14[];
Class_Descriptor cd_zd14 = {  "zd14", // class name
  bases_zd14, 5,
  &(vtc_zd14[0]), // expected_vtbl_contents
  &(vtt_zd14[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd14),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd14),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd14),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za15  : sk01 , tk21 {
  ~za15(); // tgen
  za15(); // tgen
};
//SIG(1 za15) C1{ BC2{ VBC3{}} BC4{ BC5{} VBC3}}


za15 ::~za15(){ note_dtor("za15", this);} // tgen
za15 ::za15(){ note_ctor("za15", this);} // tgen

static void Test_za15()
{
  extern Class_Descriptor cd_za15;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za15, buf);
    za15 *dp, &lv = *(dp=new (buf) za15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za15)");
    check_base_class_offset(lv, (sj*)(sk01*), 0, "za15");
    check_base_class_offset(lv, (sj*)(tk21*), 0, "za15");
    check_base_class_offset(lv, (sk01*), 0, "za15");
    check_base_class_offset(lv, (si*)(tk21*), ABISELECT(8,4), "za15");
    check_base_class_offset(lv, (tk21*), ABISELECT(8,4), "za15");
    test_class_info(&lv, &cd_za15);
    dp->~za15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza15(Test_za15, "za15", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za15C1Ev();
extern void _ZN4za15D1Ev();
Name_Map name_map_za15[] = {
  NSPAIR(_ZN4za15C1Ev),
  NSPAIR(_ZN4za15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_za15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_tk21,    ABISELECT(8,4), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za15[];
static  VTBL_ENTRY vtc_za15[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za15[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4za15[0]),
};
extern VTBL_ENTRY _ZTV4za15[];
static  VTBL_ENTRY _tg__ZTV4sk01__4za15[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk21__4za15[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTT_ENTRY vtt_za15[] = {
  {&(_ZTV4za15[3]),  3,6},
  {&(_tg__ZTV4sk01__4za15[3]),  3,3},
  {&(_tg__ZTV4tk21__4za15[3]),  3,3},
  {&(_ZTV4za15[6]),  6,6},
};
extern VTBL_ENTRY _ZTI4za15[];
extern  VTBL_ENTRY _ZTV4za15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za15[];
Class_Descriptor cd_za15 = {  "za15", // class name
  bases_za15, 4,
  &(vtc_za15[0]), // expected_vtbl_contents
  &(vtt_za15[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za15),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za15),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za15),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb15  : sk01 , virtual tk21 {
  ~zb15(); // tgen
  zb15(); // tgen
};
//SIG(1 zb15) C1{ BC2{ VBC3{}} VBC4{ BC5{} VBC3}}


zb15 ::~zb15(){ note_dtor("zb15", this);} // tgen
zb15 ::zb15(){ note_ctor("zb15", this);} // tgen

static void Test_zb15()
{
  extern Class_Descriptor cd_zb15;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb15, buf);
    zb15 *dp, &lv = *(dp=new (buf) zb15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb15)");
    check_base_class_offset(lv, (sj*)(sk01*), 0, "zb15");
    check_base_class_offset(lv, (sj*)(tk21*), 0, "zb15");
    check_base_class_offset(lv, (sk01*), 0, "zb15");
    check_base_class_offset(lv, (si*)(tk21*), ABISELECT(8,4), "zb15");
    check_base_class_offset(lv, (tk21*), ABISELECT(8,4), "zb15");
    test_class_info(&lv, &cd_zb15);
    dp->~zb15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb15(Test_zb15, "zb15", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb15C1Ev();
extern void _ZN4zb15D1Ev();
Name_Map name_map_zb15[] = {
  NSPAIR(_ZN4zb15C1Ev),
  NSPAIR(_ZN4zb15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_zb15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_tk21,    ABISELECT(8,4), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb15[];
static  VTBL_ENTRY vtc_zb15[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb15[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zb15[0]),
};
extern VTBL_ENTRY _ZTV4zb15[];
static  VTBL_ENTRY _tg__ZTV4sk01__4zb15[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk21__4zb15[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTT_ENTRY vtt_zb15[] = {
  {&(_ZTV4zb15[4]),  4,7},
  {&(_tg__ZTV4sk01__4zb15[3]),  3,3},
  {&(_ZTV4zb15[7]),  7,7},
  {&(_tg__ZTV4tk21__4zb15[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb15[];
extern  VTBL_ENTRY _ZTV4zb15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb15[];
Class_Descriptor cd_zb15 = {  "zb15", // class name
  bases_zb15, 4,
  &(vtc_zb15[0]), // expected_vtbl_contents
  &(vtt_zb15[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb15),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb15),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb15),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc15  : virtual sk01 , tk21 {
  ~zc15(); // tgen
  zc15(); // tgen
};
//SIG(1 zc15) C1{ VBC2{ VBC3{}} BC4{ BC5{} VBC3}}


zc15 ::~zc15(){ note_dtor("zc15", this);} // tgen
zc15 ::zc15(){ note_ctor("zc15", this);} // tgen

static void Test_zc15()
{
  extern Class_Descriptor cd_zc15;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc15, buf);
    zc15 *dp, &lv = *(dp=new (buf) zc15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc15)");
    check_base_class_offset(lv, (sj*)(sk01*), 0, "zc15");
    check_base_class_offset(lv, (sj*)(tk21*), 0, "zc15");
    check_base_class_offset(lv, (sk01*), ABISELECT(8,4), "zc15");
    check_base_class_offset(lv, (si*)(tk21*), 0, "zc15");
    check_base_class_offset(lv, (tk21*), 0, "zc15");
    test_class_info(&lv, &cd_zc15);
    dp->~zc15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc15(Test_zc15, "zc15", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc15C1Ev();
extern void _ZN4zc15D1Ev();
Name_Map name_map_zc15[] = {
  NSPAIR(_ZN4zc15C1Ev),
  NSPAIR(_ZN4zc15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_zc15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    ABISELECT(8,4), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_tk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc15[];
static  VTBL_ENTRY vtc_zc15[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc15[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zc15[0]),
};
extern VTBL_ENTRY _ZTV4zc15[];
static  VTBL_ENTRY _tg__ZTV4tk21__4zc15[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTBL_ENTRY _tg__ZTV4sk01__4zc15[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTT_ENTRY vtt_zc15[] = {
  {&(_ZTV4zc15[4]),  4,7},
  {&(_tg__ZTV4tk21__4zc15[3]),  3,3},
  {&(_ZTV4zc15[7]),  7,7},
  {&(_tg__ZTV4sk01__4zc15[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc15[];
extern  VTBL_ENTRY _ZTV4zc15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc15[];
Class_Descriptor cd_zc15 = {  "zc15", // class name
  bases_zc15, 4,
  &(vtc_zc15[0]), // expected_vtbl_contents
  &(vtt_zc15[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc15),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc15),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc15),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd15  : virtual sk01 , virtual tk21 {
  ~zd15(); // tgen
  zd15(); // tgen
};
//SIG(1 zd15) C1{ VBC2{ VBC3{}} VBC4{ BC5{} VBC3}}


zd15 ::~zd15(){ note_dtor("zd15", this);} // tgen
zd15 ::zd15(){ note_ctor("zd15", this);} // tgen

static void Test_zd15()
{
  extern Class_Descriptor cd_zd15;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd15, buf);
    zd15 *dp, &lv = *(dp=new (buf) zd15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd15)");
    check_base_class_offset(lv, (sj*)(sk01*), 0, "zd15");
    check_base_class_offset(lv, (sj*)(tk21*), 0, "zd15");
    check_base_class_offset(lv, (sk01*), 0, "zd15");
    check_base_class_offset(lv, (si*)(tk21*), ABISELECT(8,4), "zd15");
    check_base_class_offset(lv, (tk21*), ABISELECT(8,4), "zd15");
    test_class_info(&lv, &cd_zd15);
    dp->~zd15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd15(Test_zd15, "zd15", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd15C1Ev();
extern void _ZN4zd15D1Ev();
Name_Map name_map_zd15[] = {
  NSPAIR(_ZN4zd15C1Ev),
  NSPAIR(_ZN4zd15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_zd15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_tk21,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd15[];
static  VTBL_ENTRY vtc_zd15[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd15[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zd15[0]),
};
extern VTBL_ENTRY _ZTV4zd15[];
static  VTBL_ENTRY _tg__ZTV4sk01__4zd15[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk21__4zd15[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTT_ENTRY vtt_zd15[] = {
  {&(_ZTV4zd15[5]),  5,8},
  {&(_ZTV4zd15[5]),  5,8},
  {&(_ZTV4zd15[8]),  8,8},
  {&(_tg__ZTV4sk01__4zd15[3]),  3,3},
  {&(_tg__ZTV4tk21__4zd15[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd15[];
extern  VTBL_ENTRY _ZTV4zd15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd15[];
Class_Descriptor cd_zd15 = {  "zd15", // class name
  bases_zd15, 4,
  &(vtc_zd15[0]), // expected_vtbl_contents
  &(vtt_zd15[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd15),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd15),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd15),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za16  : sk01 , tk22 {
  ~za16(); // tgen
  za16(); // tgen
};
//SIG(1 za16) C1{ BC2{ VBC3{}} BC4{ BC5{} BC3}}


za16 ::~za16(){ note_dtor("za16", this);} // tgen
za16 ::za16(){ note_ctor("za16", this);} // tgen

static void Test_za16()
{
  extern Class_Descriptor cd_za16;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za16, buf);
    za16 *dp, &lv = *(dp=new (buf) za16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za16)");
    check_base_class_offset(lv, (sj*)(sk01*), ABISELECT(8,4), "za16");
    check_base_class_offset(lv, (sk01*), 0, "za16");
    check_base_class_offset(lv, (si*)(tk22*), 0, "za16");
    check_base_class_offset(lv, (sj*)(tk22*), 0, "za16");
    check_base_class_offset(lv, (tk22*), 0, "za16");
    test_class_info(&lv, &cd_za16);
    dp->~za16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza16(Test_za16, "za16", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za16C1Ev();
extern void _ZN4za16D1Ev();
Name_Map name_map_za16[] = {
  NSPAIR(_ZN4za16C1Ev),
  NSPAIR(_ZN4za16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_za16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za16[];
static  VTBL_ENTRY vtc_za16[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4za16[0]),
};
extern VTBL_ENTRY _ZTV4za16[];
static  VTBL_ENTRY _tg__ZTV4sk01__4za16[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTT_ENTRY vtt_za16[] = {
  {&(_ZTV4za16[3]),  3,3},
  {&(_tg__ZTV4sk01__4za16[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4za16[];
extern  VTBL_ENTRY _ZTV4za16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za16[];
Class_Descriptor cd_za16 = {  "za16", // class name
  bases_za16, 5,
  &(vtc_za16[0]), // expected_vtbl_contents
  &(vtt_za16[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za16),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za16),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za16),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb16  : sk01 , virtual tk22 {
  ~zb16(); // tgen
  zb16(); // tgen
};
//SIG(1 zb16) C1{ BC2{ VBC3{}} VBC4{ BC5{} BC3}}


zb16 ::~zb16(){ note_dtor("zb16", this);} // tgen
zb16 ::zb16(){ note_ctor("zb16", this);} // tgen

static void Test_zb16()
{
  extern Class_Descriptor cd_zb16;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb16, buf);
    zb16 *dp, &lv = *(dp=new (buf) zb16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb16)");
    check_base_class_offset(lv, (sj*)(sk01*), 0, "zb16");
    check_base_class_offset(lv, (sk01*), 0, "zb16");
    check_base_class_offset(lv, (si*)(tk22*), ABISELECT(8,4), "zb16");
    check_base_class_offset(lv, (sj*)(tk22*), ABISELECT(8,4), "zb16");
    check_base_class_offset(lv, (tk22*), ABISELECT(8,4), "zb16");
    test_class_info(&lv, &cd_zb16);
    dp->~zb16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb16(Test_zb16, "zb16", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb16C1Ev();
extern void _ZN4zb16D1Ev();
Name_Map name_map_zb16[] = {
  NSPAIR(_ZN4zb16C1Ev),
  NSPAIR(_ZN4zb16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_zb16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk22,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb16[];
static  VTBL_ENTRY vtc_zb16[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb16[0]),
};
extern VTBL_ENTRY _ZTV4zb16[];
static  VTBL_ENTRY _tg__ZTV4sk01__4zb16[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTT_ENTRY vtt_zb16[] = {
  {&(_ZTV4zb16[4]),  4,4},
  {&(_tg__ZTV4sk01__4zb16[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb16[];
extern  VTBL_ENTRY _ZTV4zb16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb16[];
Class_Descriptor cd_zb16 = {  "zb16", // class name
  bases_zb16, 5,
  &(vtc_zb16[0]), // expected_vtbl_contents
  &(vtt_zb16[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb16),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb16),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb16),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc16  : virtual sk01 , tk22 {
  ~zc16(); // tgen
  zc16(); // tgen
};
//SIG(1 zc16) C1{ VBC2{ VBC3{}} BC4{ BC5{} BC3}}


zc16 ::~zc16(){ note_dtor("zc16", this);} // tgen
zc16 ::zc16(){ note_ctor("zc16", this);} // tgen

static void Test_zc16()
{
  extern Class_Descriptor cd_zc16;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc16, buf);
    zc16 *dp, &lv = *(dp=new (buf) zc16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc16)");
    check_base_class_offset(lv, (sj*)(sk01*), ABISELECT(8,4), "zc16");
    check_base_class_offset(lv, (sk01*), 0, "zc16");
    check_base_class_offset(lv, (si*)(tk22*), 0, "zc16");
    check_base_class_offset(lv, (sj*)(tk22*), 0, "zc16");
    check_base_class_offset(lv, (tk22*), 0, "zc16");
    test_class_info(&lv, &cd_zc16);
    dp->~zc16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc16(Test_zc16, "zc16", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc16C1Ev();
extern void _ZN4zc16D1Ev();
Name_Map name_map_zc16[] = {
  NSPAIR(_ZN4zc16C1Ev),
  NSPAIR(_ZN4zc16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_zc16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc16[];
static  VTBL_ENTRY vtc_zc16[] = {
  0,
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4zc16[0]),
};
extern VTBL_ENTRY _ZTV4zc16[];
static  VTBL_ENTRY _tg__ZTV4sk01__4zc16[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTT_ENTRY vtt_zc16[] = {
  {&(_ZTV4zc16[4]),  4,4},
  {&(_ZTV4zc16[4]),  4,4},
  {&(_tg__ZTV4sk01__4zc16[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc16[];
extern  VTBL_ENTRY _ZTV4zc16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc16[];
Class_Descriptor cd_zc16 = {  "zc16", // class name
  bases_zc16, 5,
  &(vtc_zc16[0]), // expected_vtbl_contents
  &(vtt_zc16[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc16),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc16),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc16),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd16  : virtual sk01 , virtual tk22 {
  ~zd16(); // tgen
  zd16(); // tgen
};
//SIG(1 zd16) C1{ VBC2{ VBC3{}} VBC4{ BC5{} BC3}}


zd16 ::~zd16(){ note_dtor("zd16", this);} // tgen
zd16 ::zd16(){ note_ctor("zd16", this);} // tgen

static void Test_zd16()
{
  extern Class_Descriptor cd_zd16;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd16, buf);
    zd16 *dp, &lv = *(dp=new (buf) zd16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd16)");
    check_base_class_offset(lv, (sj*)(sk01*), 0, "zd16");
    check_base_class_offset(lv, (sk01*), 0, "zd16");
    check_base_class_offset(lv, (si*)(tk22*), ABISELECT(8,4), "zd16");
    check_base_class_offset(lv, (sj*)(tk22*), ABISELECT(8,4), "zd16");
    check_base_class_offset(lv, (tk22*), ABISELECT(8,4), "zd16");
    test_class_info(&lv, &cd_zd16);
    dp->~zd16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd16(Test_zd16, "zd16", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd16C1Ev();
extern void _ZN4zd16D1Ev();
Name_Map name_map_zd16[] = {
  NSPAIR(_ZN4zd16C1Ev),
  NSPAIR(_ZN4zd16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk01;
extern VTBL_ENTRY _ZTI4sk01[];
extern  VTBL_ENTRY _ZTV4sk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk01[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_zd16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_sk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk22,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd16[];
static  VTBL_ENTRY vtc_zd16[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd16[0]),
};
extern VTBL_ENTRY _ZTV4zd16[];
static  VTBL_ENTRY _tg__ZTV4sk01__4zd16[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk01[0]),
};
static  VTT_ENTRY vtt_zd16[] = {
  {&(_ZTV4zd16[5]),  5,5},
  {&(_ZTV4zd16[5]),  5,5},
  {&(_tg__ZTV4sk01__4zd16[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd16[];
extern  VTBL_ENTRY _ZTV4zd16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd16[];
Class_Descriptor cd_zd16 = {  "zd16", // class name
  bases_zd16, 5,
  &(vtc_zd16[0]), // expected_vtbl_contents
  &(vtt_zd16[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd16),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd16),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd16),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  xt2  : tk02 {
};
//SIG(1 xt2) C1{ BC2{ BC3{}}}



static void Test_xt2()
{
  extern Class_Descriptor cd_xt2;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_xt2, buf);
    xt2 &lv = *(new (buf) xt2());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(xt2)");
    check2(__alignof__(lv), 1, "__alignof__(xt2)");
    check_base_class_offset(lv, (sj*)(tk02*), 0, "xt2");
    check_base_class_offset(lv, (tk02*), 0, "xt2");
    test_class_info(&lv, &cd_xt2);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vxt2(Test_xt2, "xt2", 1);

#else // __cplusplus

extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_xt2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_tk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_xt2 = {  "xt2", // class name
  bases_xt2, 2,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  yt2  : virtual tk02 {
  ~yt2(); // tgen
  yt2(); // tgen
};
//SIG(1 yt2) C1{ VBC2{ BC3{}}}


yt2 ::~yt2(){ note_dtor("yt2", this);} // tgen
yt2 ::yt2(){ note_ctor("yt2", this);} // tgen

static void Test_yt2()
{
  extern Class_Descriptor cd_yt2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_yt2, buf);
    yt2 *dp, &lv = *(dp=new (buf) yt2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(yt2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(yt2)");
    check_base_class_offset(lv, (sj*)(tk02*), 0, "yt2");
    check_base_class_offset(lv, (tk02*), 0, "yt2");
    test_class_info(&lv, &cd_yt2);
    dp->~yt2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vyt2(Test_yt2, "yt2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3yt2C1Ev();
extern void _ZN3yt2D1Ev();
Name_Map name_map_yt2[] = {
  NSPAIR(_ZN3yt2C1Ev),
  NSPAIR(_ZN3yt2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_yt2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_tk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3yt2[];
static  VTBL_ENTRY vtc_yt2[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI3yt2[0]),
};
extern VTBL_ENTRY _ZTV3yt2[];
static  VTT_ENTRY vtt_yt2[] = {
  {&(_ZTV3yt2[3]),  3,3},
};
extern VTBL_ENTRY _ZTI3yt2[];
extern  VTBL_ENTRY _ZTV3yt2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3yt2[];
Class_Descriptor cd_yt2 = {  "yt2", // class name
  bases_yt2, 2,
  &(vtc_yt2[0]), // expected_vtbl_contents
  &(vtt_yt2[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI3yt2),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV3yt2),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3yt2),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za20  : sk02 , tk00 {
};
//SIG(1 za20) C1{ BC2{ BC3{}} BC4{}}



static void Test_za20()
{
  extern Class_Descriptor cd_za20;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_za20, buf);
    za20 &lv = *(new (buf) za20());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(za20)");
    check2(__alignof__(lv), 1, "__alignof__(za20)");
    check_base_class_offset(lv, (sj*)(sk02*), 0, "za20");
    check_base_class_offset(lv, (sk02*), 0, "za20");
    check_base_class_offset(lv, (tk00*), 0, "za20");
    test_class_info(&lv, &cd_za20);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza20(Test_za20, "za20", 1);

#else // __cplusplus

extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_za20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_za20 = {  "za20", // class name
  bases_za20, 3,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb20  : sk02 , virtual tk00 {
  ~zb20(); // tgen
  zb20(); // tgen
};
//SIG(1 zb20) C1{ BC2{ BC3{}} VBC4{}}


zb20 ::~zb20(){ note_dtor("zb20", this);} // tgen
zb20 ::zb20(){ note_ctor("zb20", this);} // tgen

static void Test_zb20()
{
  extern Class_Descriptor cd_zb20;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zb20, buf);
    zb20 *dp, &lv = *(dp=new (buf) zb20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zb20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb20)");
    check_base_class_offset(lv, (sj*)(sk02*), 0, "zb20");
    check_base_class_offset(lv, (sk02*), 0, "zb20");
    check_base_class_offset(lv, (tk00*), 0, "zb20");
    test_class_info(&lv, &cd_zb20);
    dp->~zb20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb20(Test_zb20, "zb20", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zb20C1Ev();
extern void _ZN4zb20D1Ev();
Name_Map name_map_zb20[] = {
  NSPAIR(_ZN4zb20C1Ev),
  NSPAIR(_ZN4zb20D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_zb20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb20[];
static  VTBL_ENTRY vtc_zb20[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb20[0]),
};
extern VTBL_ENTRY _ZTV4zb20[];
static  VTT_ENTRY vtt_zb20[] = {
  {&(_ZTV4zb20[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb20[];
extern  VTBL_ENTRY _ZTV4zb20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb20[];
Class_Descriptor cd_zb20 = {  "zb20", // class name
  bases_zb20, 3,
  &(vtc_zb20[0]), // expected_vtbl_contents
  &(vtt_zb20[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zb20),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb20),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb20),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc20  : virtual sk02 , tk00 {
  ~zc20(); // tgen
  zc20(); // tgen
};
//SIG(1 zc20) C1{ VBC2{ BC3{}} BC4{}}


zc20 ::~zc20(){ note_dtor("zc20", this);} // tgen
zc20 ::zc20(){ note_ctor("zc20", this);} // tgen

static void Test_zc20()
{
  extern Class_Descriptor cd_zc20;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zc20, buf);
    zc20 *dp, &lv = *(dp=new (buf) zc20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zc20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc20)");
    check_base_class_offset(lv, (sj*)(sk02*), 0, "zc20");
    check_base_class_offset(lv, (sk02*), 0, "zc20");
    check_base_class_offset(lv, (tk00*), 0, "zc20");
    test_class_info(&lv, &cd_zc20);
    dp->~zc20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc20(Test_zc20, "zc20", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zc20C1Ev();
extern void _ZN4zc20D1Ev();
Name_Map name_map_zc20[] = {
  NSPAIR(_ZN4zc20C1Ev),
  NSPAIR(_ZN4zc20D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_zc20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc20[];
static  VTBL_ENTRY vtc_zc20[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc20[0]),
};
extern VTBL_ENTRY _ZTV4zc20[];
static  VTT_ENTRY vtt_zc20[] = {
  {&(_ZTV4zc20[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc20[];
extern  VTBL_ENTRY _ZTV4zc20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc20[];
Class_Descriptor cd_zc20 = {  "zc20", // class name
  bases_zc20, 3,
  &(vtc_zc20[0]), // expected_vtbl_contents
  &(vtt_zc20[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zc20),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc20),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc20),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd20  : virtual sk02 , virtual tk00 {
  ~zd20(); // tgen
  zd20(); // tgen
};
//SIG(1 zd20) C1{ VBC2{ BC3{}} VBC4{}}


zd20 ::~zd20(){ note_dtor("zd20", this);} // tgen
zd20 ::zd20(){ note_ctor("zd20", this);} // tgen

static void Test_zd20()
{
  extern Class_Descriptor cd_zd20;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zd20, buf);
    zd20 *dp, &lv = *(dp=new (buf) zd20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zd20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd20)");
    check_base_class_offset(lv, (sj*)(sk02*), 0, "zd20");
    check_base_class_offset(lv, (sk02*), 0, "zd20");
    check_base_class_offset(lv, (tk00*), 0, "zd20");
    test_class_info(&lv, &cd_zd20);
    dp->~zd20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd20(Test_zd20, "zd20", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zd20C1Ev();
extern void _ZN4zd20D1Ev();
Name_Map name_map_zd20[] = {
  NSPAIR(_ZN4zd20C1Ev),
  NSPAIR(_ZN4zd20D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_zd20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd20[];
static  VTBL_ENTRY vtc_zd20[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd20[0]),
};
extern VTBL_ENTRY _ZTV4zd20[];
static  VTT_ENTRY vtt_zd20[] = {
  {&(_ZTV4zd20[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zd20[];
extern  VTBL_ENTRY _ZTV4zd20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd20[];
Class_Descriptor cd_zd20 = {  "zd20", // class name
  bases_zd20, 3,
  &(vtc_zd20[0]), // expected_vtbl_contents
  &(vtt_zd20[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zd20),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd20),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd20),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za21  : sk02 , tk01 {
  ~za21(); // tgen
  za21(); // tgen
};
//SIG(1 za21) C1{ BC2{ BC3{}} BC4{ VBC3}}


za21 ::~za21(){ note_dtor("za21", this);} // tgen
za21 ::za21(){ note_ctor("za21", this);} // tgen

static void Test_za21()
{
  extern Class_Descriptor cd_za21;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za21, buf);
    za21 *dp, &lv = *(dp=new (buf) za21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za21)");
    check_base_class_offset(lv, (sj*)(sk02*), 0, "za21");
    check_base_class_offset(lv, (sk02*), 0, "za21");
    check_base_class_offset(lv, (sj*)(tk01*), ABISELECT(8,4), "za21");
    check_base_class_offset(lv, (tk01*), 0, "za21");
    test_class_info(&lv, &cd_za21);
    dp->~za21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza21(Test_za21, "za21", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za21C1Ev();
extern void _ZN4za21D1Ev();
Name_Map name_map_za21[] = {
  NSPAIR(_ZN4za21C1Ev),
  NSPAIR(_ZN4za21D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_za21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_tk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za21[];
static  VTBL_ENTRY vtc_za21[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4za21[0]),
};
extern VTBL_ENTRY _ZTV4za21[];
static  VTBL_ENTRY _tg__ZTV4tk01__4za21[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTT_ENTRY vtt_za21[] = {
  {&(_ZTV4za21[3]),  3,3},
  {&(_tg__ZTV4tk01__4za21[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4za21[];
extern  VTBL_ENTRY _ZTV4za21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za21[];
Class_Descriptor cd_za21 = {  "za21", // class name
  bases_za21, 4,
  &(vtc_za21[0]), // expected_vtbl_contents
  &(vtt_za21[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za21),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za21),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za21),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb21  : sk02 , virtual tk01 {
  ~zb21(); // tgen
  zb21(); // tgen
};
//SIG(1 zb21) C1{ BC2{ BC3{}} VBC4{ VBC3}}


zb21 ::~zb21(){ note_dtor("zb21", this);} // tgen
zb21 ::zb21(){ note_ctor("zb21", this);} // tgen

static void Test_zb21()
{
  extern Class_Descriptor cd_zb21;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb21, buf);
    zb21 *dp, &lv = *(dp=new (buf) zb21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb21)");
    check_base_class_offset(lv, (sj*)(sk02*), 0, "zb21");
    check_base_class_offset(lv, (sk02*), 0, "zb21");
    check_base_class_offset(lv, (sj*)(tk01*), ABISELECT(8,4), "zb21");
    check_base_class_offset(lv, (tk01*), 0, "zb21");
    test_class_info(&lv, &cd_zb21);
    dp->~zb21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb21(Test_zb21, "zb21", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb21C1Ev();
extern void _ZN4zb21D1Ev();
Name_Map name_map_zb21[] = {
  NSPAIR(_ZN4zb21C1Ev),
  NSPAIR(_ZN4zb21D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_zb21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_tk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb21[];
static  VTBL_ENTRY vtc_zb21[] = {
  0,
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4zb21[0]),
};
extern VTBL_ENTRY _ZTV4zb21[];
static  VTBL_ENTRY _tg__ZTV4tk01__4zb21[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTT_ENTRY vtt_zb21[] = {
  {&(_ZTV4zb21[4]),  4,4},
  {&(_ZTV4zb21[4]),  4,4},
  {&(_tg__ZTV4tk01__4zb21[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb21[];
extern  VTBL_ENTRY _ZTV4zb21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb21[];
Class_Descriptor cd_zb21 = {  "zb21", // class name
  bases_zb21, 4,
  &(vtc_zb21[0]), // expected_vtbl_contents
  &(vtt_zb21[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb21),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb21),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb21),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc21  : virtual sk02 , tk01 {
  ~zc21(); // tgen
  zc21(); // tgen
};
//SIG(1 zc21) C1{ VBC2{ BC3{}} BC4{ VBC3}}


zc21 ::~zc21(){ note_dtor("zc21", this);} // tgen
zc21 ::zc21(){ note_ctor("zc21", this);} // tgen

static void Test_zc21()
{
  extern Class_Descriptor cd_zc21;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc21, buf);
    zc21 *dp, &lv = *(dp=new (buf) zc21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc21)");
    check_base_class_offset(lv, (sj*)(sk02*), 0, "zc21");
    check_base_class_offset(lv, (sk02*), 0, "zc21");
    check_base_class_offset(lv, (sj*)(tk01*), ABISELECT(8,4), "zc21");
    check_base_class_offset(lv, (tk01*), 0, "zc21");
    test_class_info(&lv, &cd_zc21);
    dp->~zc21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc21(Test_zc21, "zc21", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc21C1Ev();
extern void _ZN4zc21D1Ev();
Name_Map name_map_zc21[] = {
  NSPAIR(_ZN4zc21C1Ev),
  NSPAIR(_ZN4zc21D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_zc21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_tk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc21[];
static  VTBL_ENTRY vtc_zc21[] = {
  0,
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4zc21[0]),
};
extern VTBL_ENTRY _ZTV4zc21[];
static  VTBL_ENTRY _tg__ZTV4tk01__4zc21[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTT_ENTRY vtt_zc21[] = {
  {&(_ZTV4zc21[4]),  4,4},
  {&(_tg__ZTV4tk01__4zc21[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc21[];
extern  VTBL_ENTRY _ZTV4zc21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc21[];
Class_Descriptor cd_zc21 = {  "zc21", // class name
  bases_zc21, 4,
  &(vtc_zc21[0]), // expected_vtbl_contents
  &(vtt_zc21[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc21),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc21),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc21),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd21  : virtual sk02 , virtual tk01 {
  ~zd21(); // tgen
  zd21(); // tgen
};
//SIG(1 zd21) C1{ VBC2{ BC3{}} VBC4{ VBC3}}


zd21 ::~zd21(){ note_dtor("zd21", this);} // tgen
zd21 ::zd21(){ note_ctor("zd21", this);} // tgen

static void Test_zd21()
{
  extern Class_Descriptor cd_zd21;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd21, buf);
    zd21 *dp, &lv = *(dp=new (buf) zd21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd21)");
    check_base_class_offset(lv, (sj*)(sk02*), 0, "zd21");
    check_base_class_offset(lv, (sk02*), 0, "zd21");
    check_base_class_offset(lv, (sj*)(tk01*), ABISELECT(8,4), "zd21");
    check_base_class_offset(lv, (tk01*), 0, "zd21");
    test_class_info(&lv, &cd_zd21);
    dp->~zd21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd21(Test_zd21, "zd21", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd21C1Ev();
extern void _ZN4zd21D1Ev();
Name_Map name_map_zd21[] = {
  NSPAIR(_ZN4zd21C1Ev),
  NSPAIR(_ZN4zd21D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_zd21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_tk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd21[];
static  VTBL_ENTRY vtc_zd21[] = {
  0,
  0,
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4zd21[0]),
};
extern VTBL_ENTRY _ZTV4zd21[];
static  VTBL_ENTRY _tg__ZTV4tk01__4zd21[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTT_ENTRY vtt_zd21[] = {
  {&(_ZTV4zd21[5]),  5,5},
  {&(_ZTV4zd21[5]),  5,5},
  {&(_tg__ZTV4tk01__4zd21[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd21[];
extern  VTBL_ENTRY _ZTV4zd21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd21[];
Class_Descriptor cd_zd21 = {  "zd21", // class name
  bases_zd21, 4,
  &(vtc_zd21[0]), // expected_vtbl_contents
  &(vtt_zd21[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd21),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd21),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd21),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za22  : sk02 , tk02 {
};
//SIG(1 za22) C1{ BC2{ BC3{}} BC4{ BC3}}



static void Test_za22()
{
  extern Class_Descriptor cd_za22;
  void *lvp;
  {
    char buf[2];
    init_test(&cd_za22, buf);
    za22 &lv = *(new (buf) za22());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(za22)");
    check2(__alignof__(lv), 1, "__alignof__(za22)");
    check_base_class_offset(lv, (sj*)(sk02*), 0, "za22");
    check_base_class_offset(lv, (sk02*), 0, "za22");
    check_base_class_offset(lv, (sj*)(tk02*), 1, "za22");
    check_base_class_offset(lv, (tk02*), 1, "za22");
    test_class_info(&lv, &cd_za22);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza22(Test_za22, "za22", 2);

#else // __cplusplus

extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_za22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_tk02,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_za22 = {  "za22", // class name
  bases_za22, 4,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb22  : sk02 , virtual tk02 {
  ~zb22(); // tgen
  zb22(); // tgen
};
//SIG(1 zb22) C1{ BC2{ BC3{}} VBC4{ BC3}}


zb22 ::~zb22(){ note_dtor("zb22", this);} // tgen
zb22 ::zb22(){ note_ctor("zb22", this);} // tgen

static void Test_zb22()
{
  extern Class_Descriptor cd_zb22;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb22, buf);
    zb22 *dp, &lv = *(dp=new (buf) zb22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb22)");
    check_base_class_offset(lv, (sj*)(sk02*), 0, "zb22");
    check_base_class_offset(lv, (sk02*), 0, "zb22");
    check_base_class_offset(lv, (sj*)(tk02*), ABISELECT(8,4), "zb22");
    check_base_class_offset(lv, (tk02*), ABISELECT(8,4), "zb22");
    test_class_info(&lv, &cd_zb22);
    dp->~zb22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb22(Test_zb22, "zb22", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb22C1Ev();
extern void _ZN4zb22D1Ev();
Name_Map name_map_zb22[] = {
  NSPAIR(_ZN4zb22C1Ev),
  NSPAIR(_ZN4zb22D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_zb22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_tk02,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb22[];
static  VTBL_ENTRY vtc_zb22[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4zb22[0]),
};
extern VTBL_ENTRY _ZTV4zb22[];
static  VTT_ENTRY vtt_zb22[] = {
  {&(_ZTV4zb22[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb22[];
extern  VTBL_ENTRY _ZTV4zb22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb22[];
Class_Descriptor cd_zb22 = {  "zb22", // class name
  bases_zb22, 4,
  &(vtc_zb22[0]), // expected_vtbl_contents
  &(vtt_zb22[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb22),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb22),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb22),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc22  : virtual sk02 , tk02 {
  ~zc22(); // tgen
  zc22(); // tgen
};
//SIG(1 zc22) C1{ VBC2{ BC3{}} BC4{ BC3}}


zc22 ::~zc22(){ note_dtor("zc22", this);} // tgen
zc22 ::zc22(){ note_ctor("zc22", this);} // tgen

static void Test_zc22()
{
  extern Class_Descriptor cd_zc22;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc22, buf);
    zc22 *dp, &lv = *(dp=new (buf) zc22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc22)");
    check_base_class_offset(lv, (sj*)(sk02*), ABISELECT(8,4), "zc22");
    check_base_class_offset(lv, (sk02*), ABISELECT(8,4), "zc22");
    check_base_class_offset(lv, (sj*)(tk02*), 0, "zc22");
    check_base_class_offset(lv, (tk02*), 0, "zc22");
    test_class_info(&lv, &cd_zc22);
    dp->~zc22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc22(Test_zc22, "zc22", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc22C1Ev();
extern void _ZN4zc22D1Ev();
Name_Map name_map_zc22[] = {
  NSPAIR(_ZN4zc22C1Ev),
  NSPAIR(_ZN4zc22D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_zc22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_tk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc22[];
static  VTBL_ENTRY vtc_zc22[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4zc22[0]),
};
extern VTBL_ENTRY _ZTV4zc22[];
static  VTT_ENTRY vtt_zc22[] = {
  {&(_ZTV4zc22[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc22[];
extern  VTBL_ENTRY _ZTV4zc22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc22[];
Class_Descriptor cd_zc22 = {  "zc22", // class name
  bases_zc22, 4,
  &(vtc_zc22[0]), // expected_vtbl_contents
  &(vtt_zc22[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc22),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc22),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc22),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd22  : virtual sk02 , virtual tk02 {
  ~zd22(); // tgen
  zd22(); // tgen
};
//SIG(1 zd22) C1{ VBC2{ BC3{}} VBC4{ BC3}}


zd22 ::~zd22(){ note_dtor("zd22", this);} // tgen
zd22 ::zd22(){ note_ctor("zd22", this);} // tgen

static void Test_zd22()
{
  extern Class_Descriptor cd_zd22;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd22, buf);
    zd22 *dp, &lv = *(dp=new (buf) zd22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd22)");
    check_base_class_offset(lv, (sj*)(sk02*), 0, "zd22");
    check_base_class_offset(lv, (sk02*), 0, "zd22");
    check_base_class_offset(lv, (sj*)(tk02*), ABISELECT(8,4), "zd22");
    check_base_class_offset(lv, (tk02*), ABISELECT(8,4), "zd22");
    test_class_info(&lv, &cd_zd22);
    dp->~zd22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd22(Test_zd22, "zd22", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd22C1Ev();
extern void _ZN4zd22D1Ev();
Name_Map name_map_zd22[] = {
  NSPAIR(_ZN4zd22C1Ev),
  NSPAIR(_ZN4zd22D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_zd22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_tk02,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd22[];
static  VTBL_ENTRY vtc_zd22[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd22[0]),
};
extern VTBL_ENTRY _ZTV4zd22[];
static  VTT_ENTRY vtt_zd22[] = {
  {&(_ZTV4zd22[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zd22[];
extern  VTBL_ENTRY _ZTV4zd22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd22[];
Class_Descriptor cd_zd22 = {  "zd22", // class name
  bases_zd22, 4,
  &(vtc_zd22[0]), // expected_vtbl_contents
  &(vtt_zd22[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd22),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd22),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd22),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za23  : sk02 , tk11 {
  ~za23(); // tgen
  za23(); // tgen
};
//SIG(1 za23) C1{ BC2{ BC3{}} BC4{ VBC5{} VBC3}}


za23 ::~za23(){ note_dtor("za23", this);} // tgen
za23 ::za23(){ note_ctor("za23", this);} // tgen

static void Test_za23()
{
  extern Class_Descriptor cd_za23;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za23, buf);
    za23 *dp, &lv = *(dp=new (buf) za23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za23)");
    check_base_class_offset(lv, (sj*)(sk02*), 0, "za23");
    check_base_class_offset(lv, (sk02*), 0, "za23");
    check_base_class_offset(lv, (si*)(tk11*), 0, "za23");
    check_base_class_offset(lv, (sj*)(tk11*), ABISELECT(8,4), "za23");
    check_base_class_offset(lv, (tk11*), 0, "za23");
    test_class_info(&lv, &cd_za23);
    dp->~za23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza23(Test_za23, "za23", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za23C1Ev();
extern void _ZN4za23D1Ev();
Name_Map name_map_za23[] = {
  NSPAIR(_ZN4za23C1Ev),
  NSPAIR(_ZN4za23D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_za23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_tk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za23[];
static  VTBL_ENTRY vtc_za23[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za23[0]),
};
extern VTBL_ENTRY _ZTV4za23[];
static  VTBL_ENTRY _tg__ZTV4tk11__4za23[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTT_ENTRY vtt_za23[] = {
  {&(_ZTV4za23[4]),  4,4},
  {&(_tg__ZTV4tk11__4za23[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4za23[];
extern  VTBL_ENTRY _ZTV4za23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za23[];
Class_Descriptor cd_za23 = {  "za23", // class name
  bases_za23, 5,
  &(vtc_za23[0]), // expected_vtbl_contents
  &(vtt_za23[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za23),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za23),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za23),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb23  : sk02 , virtual tk11 {
  ~zb23(); // tgen
  zb23(); // tgen
};
//SIG(1 zb23) C1{ BC2{ BC3{}} VBC4{ VBC5{} VBC3}}


zb23 ::~zb23(){ note_dtor("zb23", this);} // tgen
zb23 ::zb23(){ note_ctor("zb23", this);} // tgen

static void Test_zb23()
{
  extern Class_Descriptor cd_zb23;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb23, buf);
    zb23 *dp, &lv = *(dp=new (buf) zb23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb23)");
    check_base_class_offset(lv, (sj*)(sk02*), 0, "zb23");
    check_base_class_offset(lv, (sk02*), 0, "zb23");
    check_base_class_offset(lv, (si*)(tk11*), 0, "zb23");
    check_base_class_offset(lv, (sj*)(tk11*), ABISELECT(8,4), "zb23");
    check_base_class_offset(lv, (tk11*), 0, "zb23");
    test_class_info(&lv, &cd_zb23);
    dp->~zb23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb23(Test_zb23, "zb23", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb23C1Ev();
extern void _ZN4zb23D1Ev();
Name_Map name_map_zb23[] = {
  NSPAIR(_ZN4zb23C1Ev),
  NSPAIR(_ZN4zb23D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_zb23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_tk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb23[];
static  VTBL_ENTRY vtc_zb23[] = {
  0,
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb23[0]),
};
extern VTBL_ENTRY _ZTV4zb23[];
static  VTBL_ENTRY _tg__ZTV4tk11__4zb23[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTT_ENTRY vtt_zb23[] = {
  {&(_ZTV4zb23[5]),  5,5},
  {&(_ZTV4zb23[5]),  5,5},
  {&(_tg__ZTV4tk11__4zb23[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zb23[];
extern  VTBL_ENTRY _ZTV4zb23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb23[];
Class_Descriptor cd_zb23 = {  "zb23", // class name
  bases_zb23, 5,
  &(vtc_zb23[0]), // expected_vtbl_contents
  &(vtt_zb23[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb23),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb23),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb23),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc23  : virtual sk02 , tk11 {
  ~zc23(); // tgen
  zc23(); // tgen
};
//SIG(1 zc23) C1{ VBC2{ BC3{}} BC4{ VBC5{} VBC3}}


zc23 ::~zc23(){ note_dtor("zc23", this);} // tgen
zc23 ::zc23(){ note_ctor("zc23", this);} // tgen

static void Test_zc23()
{
  extern Class_Descriptor cd_zc23;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc23, buf);
    zc23 *dp, &lv = *(dp=new (buf) zc23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc23)");
    check_base_class_offset(lv, (sj*)(sk02*), 0, "zc23");
    check_base_class_offset(lv, (sk02*), 0, "zc23");
    check_base_class_offset(lv, (si*)(tk11*), 0, "zc23");
    check_base_class_offset(lv, (sj*)(tk11*), ABISELECT(8,4), "zc23");
    check_base_class_offset(lv, (tk11*), 0, "zc23");
    test_class_info(&lv, &cd_zc23);
    dp->~zc23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc23(Test_zc23, "zc23", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc23C1Ev();
extern void _ZN4zc23D1Ev();
Name_Map name_map_zc23[] = {
  NSPAIR(_ZN4zc23C1Ev),
  NSPAIR(_ZN4zc23D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_zc23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_tk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc23[];
static  VTBL_ENTRY vtc_zc23[] = {
  0,
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc23[0]),
};
extern VTBL_ENTRY _ZTV4zc23[];
static  VTBL_ENTRY _tg__ZTV4tk11__4zc23[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTT_ENTRY vtt_zc23[] = {
  {&(_ZTV4zc23[5]),  5,5},
  {&(_tg__ZTV4tk11__4zc23[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zc23[];
extern  VTBL_ENTRY _ZTV4zc23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc23[];
Class_Descriptor cd_zc23 = {  "zc23", // class name
  bases_zc23, 5,
  &(vtc_zc23[0]), // expected_vtbl_contents
  &(vtt_zc23[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc23),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc23),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc23),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd23  : virtual sk02 , virtual tk11 {
  ~zd23(); // tgen
  zd23(); // tgen
};
//SIG(1 zd23) C1{ VBC2{ BC3{}} VBC4{ VBC5{} VBC3}}


zd23 ::~zd23(){ note_dtor("zd23", this);} // tgen
zd23 ::zd23(){ note_ctor("zd23", this);} // tgen

static void Test_zd23()
{
  extern Class_Descriptor cd_zd23;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd23, buf);
    zd23 *dp, &lv = *(dp=new (buf) zd23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd23)");
    check_base_class_offset(lv, (sj*)(sk02*), 0, "zd23");
    check_base_class_offset(lv, (sk02*), 0, "zd23");
    check_base_class_offset(lv, (si*)(tk11*), 0, "zd23");
    check_base_class_offset(lv, (sj*)(tk11*), ABISELECT(8,4), "zd23");
    check_base_class_offset(lv, (tk11*), 0, "zd23");
    test_class_info(&lv, &cd_zd23);
    dp->~zd23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd23(Test_zd23, "zd23", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd23C1Ev();
extern void _ZN4zd23D1Ev();
Name_Map name_map_zd23[] = {
  NSPAIR(_ZN4zd23C1Ev),
  NSPAIR(_ZN4zd23D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_zd23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_tk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd23[];
static  VTBL_ENTRY vtc_zd23[] = {
  0,
  0,
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd23[0]),
};
extern VTBL_ENTRY _ZTV4zd23[];
static  VTBL_ENTRY _tg__ZTV4tk11__4zd23[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTT_ENTRY vtt_zd23[] = {
  {&(_ZTV4zd23[6]),  6,6},
  {&(_ZTV4zd23[6]),  6,6},
  {&(_tg__ZTV4tk11__4zd23[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zd23[];
extern  VTBL_ENTRY _ZTV4zd23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd23[];
Class_Descriptor cd_zd23 = {  "zd23", // class name
  bases_zd23, 5,
  &(vtc_zd23[0]), // expected_vtbl_contents
  &(vtt_zd23[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd23),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd23),6, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd23),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za24  : sk02 , tk12 {
  ~za24(); // tgen
  za24(); // tgen
};
//SIG(1 za24) C1{ BC2{ BC3{}} BC4{ VBC5{} BC3}}


za24 ::~za24(){ note_dtor("za24", this);} // tgen
za24 ::za24(){ note_ctor("za24", this);} // tgen

static void Test_za24()
{
  extern Class_Descriptor cd_za24;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za24, buf);
    za24 *dp, &lv = *(dp=new (buf) za24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za24)");
    check_base_class_offset(lv, (sj*)(sk02*), ABISELECT(8,4), "za24");
    check_base_class_offset(lv, (sk02*), ABISELECT(8,4), "za24");
    check_base_class_offset(lv, (si*)(tk12*), 0, "za24");
    check_base_class_offset(lv, (sj*)(tk12*), 0, "za24");
    check_base_class_offset(lv, (tk12*), 0, "za24");
    test_class_info(&lv, &cd_za24);
    dp->~za24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza24(Test_za24, "za24", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za24C1Ev();
extern void _ZN4za24D1Ev();
Name_Map name_map_za24[] = {
  NSPAIR(_ZN4za24C1Ev),
  NSPAIR(_ZN4za24D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_za24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za24[];
static  VTBL_ENTRY vtc_za24[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za24[0]),
};
extern VTBL_ENTRY _ZTV4za24[];
static  VTBL_ENTRY _tg__ZTV4tk12__4za24[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTT_ENTRY vtt_za24[] = {
  {&(_ZTV4za24[3]),  3,3},
  {&(_tg__ZTV4tk12__4za24[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4za24[];
extern  VTBL_ENTRY _ZTV4za24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za24[];
Class_Descriptor cd_za24 = {  "za24", // class name
  bases_za24, 5,
  &(vtc_za24[0]), // expected_vtbl_contents
  &(vtt_za24[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za24),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za24),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za24),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb24  : sk02 , virtual tk12 {
  ~zb24(); // tgen
  zb24(); // tgen
};
//SIG(1 zb24) C1{ BC2{ BC3{}} VBC4{ VBC5{} BC3}}


zb24 ::~zb24(){ note_dtor("zb24", this);} // tgen
zb24 ::zb24(){ note_ctor("zb24", this);} // tgen

static void Test_zb24()
{
  extern Class_Descriptor cd_zb24;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb24, buf);
    zb24 *dp, &lv = *(dp=new (buf) zb24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb24)");
    check_base_class_offset(lv, (sj*)(sk02*), ABISELECT(8,4), "zb24");
    check_base_class_offset(lv, (sk02*), ABISELECT(8,4), "zb24");
    check_base_class_offset(lv, (si*)(tk12*), 0, "zb24");
    check_base_class_offset(lv, (sj*)(tk12*), 0, "zb24");
    check_base_class_offset(lv, (tk12*), 0, "zb24");
    test_class_info(&lv, &cd_zb24);
    dp->~zb24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb24(Test_zb24, "zb24", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb24C1Ev();
extern void _ZN4zb24D1Ev();
Name_Map name_map_zb24[] = {
  NSPAIR(_ZN4zb24C1Ev),
  NSPAIR(_ZN4zb24D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_zb24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb24[];
static  VTBL_ENTRY vtc_zb24[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb24[0]),
};
extern VTBL_ENTRY _ZTV4zb24[];
static  VTBL_ENTRY _tg__ZTV4tk12__4zb24[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTT_ENTRY vtt_zb24[] = {
  {&(_ZTV4zb24[4]),  4,4},
  {&(_ZTV4zb24[4]),  4,4},
  {&(_tg__ZTV4tk12__4zb24[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb24[];
extern  VTBL_ENTRY _ZTV4zb24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb24[];
Class_Descriptor cd_zb24 = {  "zb24", // class name
  bases_zb24, 5,
  &(vtc_zb24[0]), // expected_vtbl_contents
  &(vtt_zb24[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb24),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb24),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb24),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc24  : virtual sk02 , tk12 {
  ~zc24(); // tgen
  zc24(); // tgen
};
//SIG(1 zc24) C1{ VBC2{ BC3{}} BC4{ VBC5{} BC3}}


zc24 ::~zc24(){ note_dtor("zc24", this);} // tgen
zc24 ::zc24(){ note_ctor("zc24", this);} // tgen

static void Test_zc24()
{
  extern Class_Descriptor cd_zc24;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc24, buf);
    zc24 *dp, &lv = *(dp=new (buf) zc24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc24)");
    check_base_class_offset(lv, (sj*)(sk02*), ABISELECT(8,4), "zc24");
    check_base_class_offset(lv, (sk02*), ABISELECT(8,4), "zc24");
    check_base_class_offset(lv, (si*)(tk12*), 0, "zc24");
    check_base_class_offset(lv, (sj*)(tk12*), 0, "zc24");
    check_base_class_offset(lv, (tk12*), 0, "zc24");
    test_class_info(&lv, &cd_zc24);
    dp->~zc24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc24(Test_zc24, "zc24", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc24C1Ev();
extern void _ZN4zc24D1Ev();
Name_Map name_map_zc24[] = {
  NSPAIR(_ZN4zc24C1Ev),
  NSPAIR(_ZN4zc24D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_zc24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc24[];
static  VTBL_ENTRY vtc_zc24[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc24[0]),
};
extern VTBL_ENTRY _ZTV4zc24[];
static  VTBL_ENTRY _tg__ZTV4tk12__4zc24[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTT_ENTRY vtt_zc24[] = {
  {&(_ZTV4zc24[4]),  4,4},
  {&(_tg__ZTV4tk12__4zc24[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc24[];
extern  VTBL_ENTRY _ZTV4zc24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc24[];
Class_Descriptor cd_zc24 = {  "zc24", // class name
  bases_zc24, 5,
  &(vtc_zc24[0]), // expected_vtbl_contents
  &(vtt_zc24[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc24),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc24),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc24),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd24  : virtual sk02 , virtual tk12 {
  ~zd24(); // tgen
  zd24(); // tgen
};
//SIG(1 zd24) C1{ VBC2{ BC3{}} VBC4{ VBC5{} BC3}}


zd24 ::~zd24(){ note_dtor("zd24", this);} // tgen
zd24 ::zd24(){ note_ctor("zd24", this);} // tgen

static void Test_zd24()
{
  extern Class_Descriptor cd_zd24;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd24, buf);
    zd24 *dp, &lv = *(dp=new (buf) zd24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd24)");
    check_base_class_offset(lv, (sj*)(sk02*), ABISELECT(8,4), "zd24");
    check_base_class_offset(lv, (sk02*), ABISELECT(8,4), "zd24");
    check_base_class_offset(lv, (si*)(tk12*), 0, "zd24");
    check_base_class_offset(lv, (sj*)(tk12*), 0, "zd24");
    check_base_class_offset(lv, (tk12*), 0, "zd24");
    test_class_info(&lv, &cd_zd24);
    dp->~zd24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd24(Test_zd24, "zd24", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd24C1Ev();
extern void _ZN4zd24D1Ev();
Name_Map name_map_zd24[] = {
  NSPAIR(_ZN4zd24C1Ev),
  NSPAIR(_ZN4zd24D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_zd24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd24[];
static  VTBL_ENTRY vtc_zd24[] = {
  0,
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd24[0]),
};
extern VTBL_ENTRY _ZTV4zd24[];
static  VTBL_ENTRY _tg__ZTV4tk12__4zd24[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTT_ENTRY vtt_zd24[] = {
  {&(_ZTV4zd24[5]),  5,5},
  {&(_ZTV4zd24[5]),  5,5},
  {&(_tg__ZTV4tk12__4zd24[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd24[];
extern  VTBL_ENTRY _ZTV4zd24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd24[];
Class_Descriptor cd_zd24 = {  "zd24", // class name
  bases_zd24, 5,
  &(vtc_zd24[0]), // expected_vtbl_contents
  &(vtt_zd24[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd24),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd24),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd24),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za25  : sk02 , tk21 {
  ~za25(); // tgen
  za25(); // tgen
};
//SIG(1 za25) C1{ BC2{ BC3{}} BC4{ BC5{} VBC3}}


za25 ::~za25(){ note_dtor("za25", this);} // tgen
za25 ::za25(){ note_ctor("za25", this);} // tgen

static void Test_za25()
{
  extern Class_Descriptor cd_za25;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za25, buf);
    za25 *dp, &lv = *(dp=new (buf) za25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za25)");
    check_base_class_offset(lv, (sj*)(sk02*), 0, "za25");
    check_base_class_offset(lv, (sk02*), 0, "za25");
    check_base_class_offset(lv, (si*)(tk21*), 0, "za25");
    check_base_class_offset(lv, (sj*)(tk21*), ABISELECT(8,4), "za25");
    check_base_class_offset(lv, (tk21*), 0, "za25");
    test_class_info(&lv, &cd_za25);
    dp->~za25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza25(Test_za25, "za25", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za25C1Ev();
extern void _ZN4za25D1Ev();
Name_Map name_map_za25[] = {
  NSPAIR(_ZN4za25C1Ev),
  NSPAIR(_ZN4za25D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_za25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_tk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za25[];
static  VTBL_ENTRY vtc_za25[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4za25[0]),
};
extern VTBL_ENTRY _ZTV4za25[];
static  VTBL_ENTRY _tg__ZTV4tk21__4za25[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTT_ENTRY vtt_za25[] = {
  {&(_ZTV4za25[3]),  3,3},
  {&(_tg__ZTV4tk21__4za25[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4za25[];
extern  VTBL_ENTRY _ZTV4za25[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za25[];
Class_Descriptor cd_za25 = {  "za25", // class name
  bases_za25, 5,
  &(vtc_za25[0]), // expected_vtbl_contents
  &(vtt_za25[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za25),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za25),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za25),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb25  : sk02 , virtual tk21 {
  ~zb25(); // tgen
  zb25(); // tgen
};
//SIG(1 zb25) C1{ BC2{ BC3{}} VBC4{ BC5{} VBC3}}


zb25 ::~zb25(){ note_dtor("zb25", this);} // tgen
zb25 ::zb25(){ note_ctor("zb25", this);} // tgen

static void Test_zb25()
{
  extern Class_Descriptor cd_zb25;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb25, buf);
    zb25 *dp, &lv = *(dp=new (buf) zb25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb25)");
    check_base_class_offset(lv, (sj*)(sk02*), 0, "zb25");
    check_base_class_offset(lv, (sk02*), 0, "zb25");
    check_base_class_offset(lv, (si*)(tk21*), 0, "zb25");
    check_base_class_offset(lv, (sj*)(tk21*), ABISELECT(8,4), "zb25");
    check_base_class_offset(lv, (tk21*), 0, "zb25");
    test_class_info(&lv, &cd_zb25);
    dp->~zb25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb25(Test_zb25, "zb25", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb25C1Ev();
extern void _ZN4zb25D1Ev();
Name_Map name_map_zb25[] = {
  NSPAIR(_ZN4zb25C1Ev),
  NSPAIR(_ZN4zb25D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_zb25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_tk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb25[];
static  VTBL_ENTRY vtc_zb25[] = {
  0,
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4zb25[0]),
};
extern VTBL_ENTRY _ZTV4zb25[];
static  VTBL_ENTRY _tg__ZTV4tk21__4zb25[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTT_ENTRY vtt_zb25[] = {
  {&(_ZTV4zb25[4]),  4,4},
  {&(_ZTV4zb25[4]),  4,4},
  {&(_tg__ZTV4tk21__4zb25[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb25[];
extern  VTBL_ENTRY _ZTV4zb25[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb25[];
Class_Descriptor cd_zb25 = {  "zb25", // class name
  bases_zb25, 5,
  &(vtc_zb25[0]), // expected_vtbl_contents
  &(vtt_zb25[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb25),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb25),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb25),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc25  : virtual sk02 , tk21 {
  ~zc25(); // tgen
  zc25(); // tgen
};
//SIG(1 zc25) C1{ VBC2{ BC3{}} BC4{ BC5{} VBC3}}


zc25 ::~zc25(){ note_dtor("zc25", this);} // tgen
zc25 ::zc25(){ note_ctor("zc25", this);} // tgen

static void Test_zc25()
{
  extern Class_Descriptor cd_zc25;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc25, buf);
    zc25 *dp, &lv = *(dp=new (buf) zc25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc25)");
    check_base_class_offset(lv, (sj*)(sk02*), 0, "zc25");
    check_base_class_offset(lv, (sk02*), 0, "zc25");
    check_base_class_offset(lv, (si*)(tk21*), 0, "zc25");
    check_base_class_offset(lv, (sj*)(tk21*), ABISELECT(8,4), "zc25");
    check_base_class_offset(lv, (tk21*), 0, "zc25");
    test_class_info(&lv, &cd_zc25);
    dp->~zc25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc25(Test_zc25, "zc25", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc25C1Ev();
extern void _ZN4zc25D1Ev();
Name_Map name_map_zc25[] = {
  NSPAIR(_ZN4zc25C1Ev),
  NSPAIR(_ZN4zc25D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_zc25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_tk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc25[];
static  VTBL_ENTRY vtc_zc25[] = {
  0,
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4zc25[0]),
};
extern VTBL_ENTRY _ZTV4zc25[];
static  VTBL_ENTRY _tg__ZTV4tk21__4zc25[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTT_ENTRY vtt_zc25[] = {
  {&(_ZTV4zc25[4]),  4,4},
  {&(_tg__ZTV4tk21__4zc25[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc25[];
extern  VTBL_ENTRY _ZTV4zc25[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc25[];
Class_Descriptor cd_zc25 = {  "zc25", // class name
  bases_zc25, 5,
  &(vtc_zc25[0]), // expected_vtbl_contents
  &(vtt_zc25[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc25),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc25),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc25),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd25  : virtual sk02 , virtual tk21 {
  ~zd25(); // tgen
  zd25(); // tgen
};
//SIG(1 zd25) C1{ VBC2{ BC3{}} VBC4{ BC5{} VBC3}}


zd25 ::~zd25(){ note_dtor("zd25", this);} // tgen
zd25 ::zd25(){ note_ctor("zd25", this);} // tgen

static void Test_zd25()
{
  extern Class_Descriptor cd_zd25;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd25, buf);
    zd25 *dp, &lv = *(dp=new (buf) zd25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd25)");
    check_base_class_offset(lv, (sj*)(sk02*), 0, "zd25");
    check_base_class_offset(lv, (sk02*), 0, "zd25");
    check_base_class_offset(lv, (si*)(tk21*), 0, "zd25");
    check_base_class_offset(lv, (sj*)(tk21*), ABISELECT(8,4), "zd25");
    check_base_class_offset(lv, (tk21*), 0, "zd25");
    test_class_info(&lv, &cd_zd25);
    dp->~zd25();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd25(Test_zd25, "zd25", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd25C1Ev();
extern void _ZN4zd25D1Ev();
Name_Map name_map_zd25[] = {
  NSPAIR(_ZN4zd25C1Ev),
  NSPAIR(_ZN4zd25D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_zd25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_tk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd25[];
static  VTBL_ENTRY vtc_zd25[] = {
  0,
  0,
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4zd25[0]),
};
extern VTBL_ENTRY _ZTV4zd25[];
static  VTBL_ENTRY _tg__ZTV4tk21__4zd25[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTT_ENTRY vtt_zd25[] = {
  {&(_ZTV4zd25[5]),  5,5},
  {&(_ZTV4zd25[5]),  5,5},
  {&(_tg__ZTV4tk21__4zd25[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd25[];
extern  VTBL_ENTRY _ZTV4zd25[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd25[];
Class_Descriptor cd_zd25 = {  "zd25", // class name
  bases_zd25, 5,
  &(vtc_zd25[0]), // expected_vtbl_contents
  &(vtt_zd25[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd25),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd25),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd25),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za26  : sk02 , tk22 {
};
//SIG(1 za26) C1{ BC2{ BC3{}} BC4{ BC5{} BC3}}



static void Test_za26()
{
  extern Class_Descriptor cd_za26;
  void *lvp;
  {
    char buf[2];
    init_test(&cd_za26, buf);
    za26 &lv = *(new (buf) za26());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(za26)");
    check2(__alignof__(lv), 1, "__alignof__(za26)");
    check_base_class_offset(lv, (sj*)(sk02*), 0, "za26");
    check_base_class_offset(lv, (sk02*), 0, "za26");
    check_base_class_offset(lv, (si*)(tk22*), 1, "za26");
    check_base_class_offset(lv, (sj*)(tk22*), 1, "za26");
    check_base_class_offset(lv, (tk22*), 1, "za26");
    test_class_info(&lv, &cd_za26);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza26(Test_za26, "za26", 2);

#else // __cplusplus

extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_za26[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_sj,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk22,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_za26 = {  "za26", // class name
  bases_za26, 5,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb26  : sk02 , virtual tk22 {
  ~zb26(); // tgen
  zb26(); // tgen
};
//SIG(1 zb26) C1{ BC2{ BC3{}} VBC4{ BC5{} BC3}}


zb26 ::~zb26(){ note_dtor("zb26", this);} // tgen
zb26 ::zb26(){ note_ctor("zb26", this);} // tgen

static void Test_zb26()
{
  extern Class_Descriptor cd_zb26;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb26, buf);
    zb26 *dp, &lv = *(dp=new (buf) zb26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb26)");
    check_base_class_offset(lv, (sj*)(sk02*), 0, "zb26");
    check_base_class_offset(lv, (sk02*), 0, "zb26");
    check_base_class_offset(lv, (si*)(tk22*), ABISELECT(8,4), "zb26");
    check_base_class_offset(lv, (sj*)(tk22*), ABISELECT(8,4), "zb26");
    check_base_class_offset(lv, (tk22*), ABISELECT(8,4), "zb26");
    test_class_info(&lv, &cd_zb26);
    dp->~zb26();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb26(Test_zb26, "zb26", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb26C1Ev();
extern void _ZN4zb26D1Ev();
Name_Map name_map_zb26[] = {
  NSPAIR(_ZN4zb26C1Ev),
  NSPAIR(_ZN4zb26D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_zb26[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk22,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb26[];
static  VTBL_ENTRY vtc_zb26[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4zb26[0]),
};
extern VTBL_ENTRY _ZTV4zb26[];
static  VTT_ENTRY vtt_zb26[] = {
  {&(_ZTV4zb26[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb26[];
extern  VTBL_ENTRY _ZTV4zb26[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb26[];
Class_Descriptor cd_zb26 = {  "zb26", // class name
  bases_zb26, 5,
  &(vtc_zb26[0]), // expected_vtbl_contents
  &(vtt_zb26[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb26),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb26),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb26),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc26  : virtual sk02 , tk22 {
  ~zc26(); // tgen
  zc26(); // tgen
};
//SIG(1 zc26) C1{ VBC2{ BC3{}} BC4{ BC5{} BC3}}


zc26 ::~zc26(){ note_dtor("zc26", this);} // tgen
zc26 ::zc26(){ note_ctor("zc26", this);} // tgen

static void Test_zc26()
{
  extern Class_Descriptor cd_zc26;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc26, buf);
    zc26 *dp, &lv = *(dp=new (buf) zc26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc26)");
    check_base_class_offset(lv, (sj*)(sk02*), ABISELECT(8,4), "zc26");
    check_base_class_offset(lv, (sk02*), ABISELECT(8,4), "zc26");
    check_base_class_offset(lv, (si*)(tk22*), 0, "zc26");
    check_base_class_offset(lv, (sj*)(tk22*), 0, "zc26");
    check_base_class_offset(lv, (tk22*), 0, "zc26");
    test_class_info(&lv, &cd_zc26);
    dp->~zc26();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc26(Test_zc26, "zc26", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc26C1Ev();
extern void _ZN4zc26D1Ev();
Name_Map name_map_zc26[] = {
  NSPAIR(_ZN4zc26C1Ev),
  NSPAIR(_ZN4zc26D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_zc26[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc26[];
static  VTBL_ENTRY vtc_zc26[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4zc26[0]),
};
extern VTBL_ENTRY _ZTV4zc26[];
static  VTT_ENTRY vtt_zc26[] = {
  {&(_ZTV4zc26[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc26[];
extern  VTBL_ENTRY _ZTV4zc26[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc26[];
Class_Descriptor cd_zc26 = {  "zc26", // class name
  bases_zc26, 5,
  &(vtc_zc26[0]), // expected_vtbl_contents
  &(vtt_zc26[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc26),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc26),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc26),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd26  : virtual sk02 , virtual tk22 {
  ~zd26(); // tgen
  zd26(); // tgen
};
//SIG(1 zd26) C1{ VBC2{ BC3{}} VBC4{ BC5{} BC3}}


zd26 ::~zd26(){ note_dtor("zd26", this);} // tgen
zd26 ::zd26(){ note_ctor("zd26", this);} // tgen

static void Test_zd26()
{
  extern Class_Descriptor cd_zd26;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd26, buf);
    zd26 *dp, &lv = *(dp=new (buf) zd26());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd26)");
    check_base_class_offset(lv, (sj*)(sk02*), 0, "zd26");
    check_base_class_offset(lv, (sk02*), 0, "zd26");
    check_base_class_offset(lv, (si*)(tk22*), ABISELECT(8,4), "zd26");
    check_base_class_offset(lv, (sj*)(tk22*), ABISELECT(8,4), "zd26");
    check_base_class_offset(lv, (tk22*), ABISELECT(8,4), "zd26");
    test_class_info(&lv, &cd_zd26);
    dp->~zd26();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd26(Test_zd26, "zd26", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd26C1Ev();
extern void _ZN4zd26D1Ev();
Name_Map name_map_zd26[] = {
  NSPAIR(_ZN4zd26C1Ev),
  NSPAIR(_ZN4zd26D1Ev),
  {0,0}
};
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk02;
extern VTBL_ENTRY _ZTI4sk02[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_zd26[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_sk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk22,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd26[];
static  VTBL_ENTRY vtc_zd26[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd26[0]),
};
extern VTBL_ENTRY _ZTV4zd26[];
static  VTT_ENTRY vtt_zd26[] = {
  {&(_ZTV4zd26[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zd26[];
extern  VTBL_ENTRY _ZTV4zd26[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd26[];
Class_Descriptor cd_zd26 = {  "zd26", // class name
  bases_zd26, 5,
  &(vtc_zd26[0]), // expected_vtbl_contents
  &(vtt_zd26[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd26),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd26),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd26),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  xt3  : tk11 {
  ~xt3(); // tgen
  xt3(); // tgen
};
//SIG(1 xt3) C1{ BC2{ VBC3{} VBC4{}}}


xt3 ::~xt3(){ note_dtor("xt3", this);} // tgen
xt3 ::xt3(){ note_ctor("xt3", this);} // tgen

static void Test_xt3()
{
  extern Class_Descriptor cd_xt3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_xt3, buf);
    xt3 *dp, &lv = *(dp=new (buf) xt3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(xt3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(xt3)");
    check_base_class_offset(lv, (si*)(tk11*), 0, "xt3");
    check_base_class_offset(lv, (sj*)(tk11*), 0, "xt3");
    check_base_class_offset(lv, (tk11*), 0, "xt3");
    test_class_info(&lv, &cd_xt3);
    dp->~xt3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vxt3(Test_xt3, "xt3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3xt3C1Ev();
extern void _ZN3xt3D1Ev();
Name_Map name_map_xt3[] = {
  NSPAIR(_ZN3xt3C1Ev),
  NSPAIR(_ZN3xt3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_xt3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_tk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3xt3[];
static  VTBL_ENTRY vtc_xt3[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI3xt3[0]),
};
extern VTBL_ENTRY _ZTV3xt3[];
static  VTBL_ENTRY _tg__ZTV4tk11__3xt3[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTT_ENTRY vtt_xt3[] = {
  {&(_ZTV3xt3[4]),  4,4},
  {&(_tg__ZTV4tk11__3xt3[4]),  4,4},
};
extern VTBL_ENTRY _ZTI3xt3[];
extern  VTBL_ENTRY _ZTV3xt3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3xt3[];
Class_Descriptor cd_xt3 = {  "xt3", // class name
  bases_xt3, 3,
  &(vtc_xt3[0]), // expected_vtbl_contents
  &(vtt_xt3[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI3xt3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV3xt3),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3xt3),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  yt3  : virtual tk11 {
  ~yt3(); // tgen
  yt3(); // tgen
};
//SIG(1 yt3) C1{ VBC2{ VBC3{} VBC4{}}}


yt3 ::~yt3(){ note_dtor("yt3", this);} // tgen
yt3 ::yt3(){ note_ctor("yt3", this);} // tgen

static void Test_yt3()
{
  extern Class_Descriptor cd_yt3;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_yt3, buf);
    yt3 *dp, &lv = *(dp=new (buf) yt3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(yt3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(yt3)");
    check_base_class_offset(lv, (si*)(tk11*), 0, "yt3");
    check_base_class_offset(lv, (sj*)(tk11*), 0, "yt3");
    check_base_class_offset(lv, (tk11*), 0, "yt3");
    test_class_info(&lv, &cd_yt3);
    dp->~yt3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vyt3(Test_yt3, "yt3", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3yt3C1Ev();
extern void _ZN3yt3D1Ev();
Name_Map name_map_yt3[] = {
  NSPAIR(_ZN3yt3C1Ev),
  NSPAIR(_ZN3yt3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_yt3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_tk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3yt3[];
static  VTBL_ENTRY vtc_yt3[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI3yt3[0]),
};
extern VTBL_ENTRY _ZTV3yt3[];
static  VTBL_ENTRY _tg__ZTV4tk11__3yt3[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTT_ENTRY vtt_yt3[] = {
  {&(_ZTV3yt3[5]),  5,5},
  {&(_ZTV3yt3[5]),  5,5},
  {&(_tg__ZTV4tk11__3yt3[4]),  4,4},
};
extern VTBL_ENTRY _ZTI3yt3[];
extern  VTBL_ENTRY _ZTV3yt3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3yt3[];
Class_Descriptor cd_yt3 = {  "yt3", // class name
  bases_yt3, 3,
  &(vtc_yt3[0]), // expected_vtbl_contents
  &(vtt_yt3[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI3yt3),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV3yt3),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3yt3),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za30  : sk11 , tk00 {
  ~za30(); // tgen
  za30(); // tgen
};
//SIG(1 za30) C1{ BC2{ VBC3{} VBC4{}} BC5{}}


za30 ::~za30(){ note_dtor("za30", this);} // tgen
za30 ::za30(){ note_ctor("za30", this);} // tgen

static void Test_za30()
{
  extern Class_Descriptor cd_za30;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_za30, buf);
    za30 *dp, &lv = *(dp=new (buf) za30());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(za30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za30)");
    check_base_class_offset(lv, (si*)(sk11*), 0, "za30");
    check_base_class_offset(lv, (sj*)(sk11*), 0, "za30");
    check_base_class_offset(lv, (sk11*), 0, "za30");
    check_base_class_offset(lv, (tk00*), 0, "za30");
    test_class_info(&lv, &cd_za30);
    dp->~za30();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza30(Test_za30, "za30", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4za30C1Ev();
extern void _ZN4za30D1Ev();
Name_Map name_map_za30[] = {
  NSPAIR(_ZN4za30C1Ev),
  NSPAIR(_ZN4za30D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_za30[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za30[];
static  VTBL_ENTRY vtc_za30[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za30[0]),
};
extern VTBL_ENTRY _ZTV4za30[];
static  VTBL_ENTRY _tg__ZTV4sk11__4za30[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTT_ENTRY vtt_za30[] = {
  {&(_ZTV4za30[4]),  4,4},
  {&(_tg__ZTV4sk11__4za30[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4za30[];
extern  VTBL_ENTRY _ZTV4za30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za30[];
Class_Descriptor cd_za30 = {  "za30", // class name
  bases_za30, 4,
  &(vtc_za30[0]), // expected_vtbl_contents
  &(vtt_za30[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4za30),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za30),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za30),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb30  : sk11 , virtual tk00 {
  ~zb30(); // tgen
  zb30(); // tgen
};
//SIG(1 zb30) C1{ BC2{ VBC3{} VBC4{}} VBC5{}}


zb30 ::~zb30(){ note_dtor("zb30", this);} // tgen
zb30 ::zb30(){ note_ctor("zb30", this);} // tgen

static void Test_zb30()
{
  extern Class_Descriptor cd_zb30;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zb30, buf);
    zb30 *dp, &lv = *(dp=new (buf) zb30());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zb30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb30)");
    check_base_class_offset(lv, (si*)(sk11*), 0, "zb30");
    check_base_class_offset(lv, (sj*)(sk11*), 0, "zb30");
    check_base_class_offset(lv, (sk11*), 0, "zb30");
    check_base_class_offset(lv, (tk00*), 0, "zb30");
    test_class_info(&lv, &cd_zb30);
    dp->~zb30();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb30(Test_zb30, "zb30", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zb30C1Ev();
extern void _ZN4zb30D1Ev();
Name_Map name_map_zb30[] = {
  NSPAIR(_ZN4zb30C1Ev),
  NSPAIR(_ZN4zb30D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_zb30[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb30[];
static  VTBL_ENTRY vtc_zb30[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb30[0]),
};
extern VTBL_ENTRY _ZTV4zb30[];
static  VTBL_ENTRY _tg__ZTV4sk11__4zb30[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTT_ENTRY vtt_zb30[] = {
  {&(_ZTV4zb30[5]),  5,5},
  {&(_tg__ZTV4sk11__4zb30[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zb30[];
extern  VTBL_ENTRY _ZTV4zb30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb30[];
Class_Descriptor cd_zb30 = {  "zb30", // class name
  bases_zb30, 4,
  &(vtc_zb30[0]), // expected_vtbl_contents
  &(vtt_zb30[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zb30),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb30),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb30),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc30  : virtual sk11 , tk00 {
  ~zc30(); // tgen
  zc30(); // tgen
};
//SIG(1 zc30) C1{ VBC2{ VBC3{} VBC4{}} BC5{}}


zc30 ::~zc30(){ note_dtor("zc30", this);} // tgen
zc30 ::zc30(){ note_ctor("zc30", this);} // tgen

static void Test_zc30()
{
  extern Class_Descriptor cd_zc30;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zc30, buf);
    zc30 *dp, &lv = *(dp=new (buf) zc30());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zc30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc30)");
    check_base_class_offset(lv, (si*)(sk11*), 0, "zc30");
    check_base_class_offset(lv, (sj*)(sk11*), 0, "zc30");
    check_base_class_offset(lv, (sk11*), 0, "zc30");
    check_base_class_offset(lv, (tk00*), 0, "zc30");
    test_class_info(&lv, &cd_zc30);
    dp->~zc30();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc30(Test_zc30, "zc30", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zc30C1Ev();
extern void _ZN4zc30D1Ev();
Name_Map name_map_zc30[] = {
  NSPAIR(_ZN4zc30C1Ev),
  NSPAIR(_ZN4zc30D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_zc30[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc30[];
static  VTBL_ENTRY vtc_zc30[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc30[0]),
};
extern VTBL_ENTRY _ZTV4zc30[];
static  VTBL_ENTRY _tg__ZTV4sk11__4zc30[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTT_ENTRY vtt_zc30[] = {
  {&(_ZTV4zc30[5]),  5,5},
  {&(_ZTV4zc30[5]),  5,5},
  {&(_tg__ZTV4sk11__4zc30[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zc30[];
extern  VTBL_ENTRY _ZTV4zc30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc30[];
Class_Descriptor cd_zc30 = {  "zc30", // class name
  bases_zc30, 4,
  &(vtc_zc30[0]), // expected_vtbl_contents
  &(vtt_zc30[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zc30),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc30),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc30),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd30  : virtual sk11 , virtual tk00 {
  ~zd30(); // tgen
  zd30(); // tgen
};
//SIG(1 zd30) C1{ VBC2{ VBC3{} VBC4{}} VBC5{}}


zd30 ::~zd30(){ note_dtor("zd30", this);} // tgen
zd30 ::zd30(){ note_ctor("zd30", this);} // tgen

static void Test_zd30()
{
  extern Class_Descriptor cd_zd30;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zd30, buf);
    zd30 *dp, &lv = *(dp=new (buf) zd30());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zd30)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd30)");
    check_base_class_offset(lv, (si*)(sk11*), 0, "zd30");
    check_base_class_offset(lv, (sj*)(sk11*), 0, "zd30");
    check_base_class_offset(lv, (sk11*), 0, "zd30");
    check_base_class_offset(lv, (tk00*), 0, "zd30");
    test_class_info(&lv, &cd_zd30);
    dp->~zd30();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd30(Test_zd30, "zd30", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zd30C1Ev();
extern void _ZN4zd30D1Ev();
Name_Map name_map_zd30[] = {
  NSPAIR(_ZN4zd30C1Ev),
  NSPAIR(_ZN4zd30D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_zd30[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd30[];
static  VTBL_ENTRY vtc_zd30[] = {
  0,
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd30[0]),
};
extern VTBL_ENTRY _ZTV4zd30[];
static  VTBL_ENTRY _tg__ZTV4sk11__4zd30[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTT_ENTRY vtt_zd30[] = {
  {&(_ZTV4zd30[6]),  6,6},
  {&(_ZTV4zd30[6]),  6,6},
  {&(_tg__ZTV4sk11__4zd30[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zd30[];
extern  VTBL_ENTRY _ZTV4zd30[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd30[];
Class_Descriptor cd_zd30 = {  "zd30", // class name
  bases_zd30, 4,
  &(vtc_zd30[0]), // expected_vtbl_contents
  &(vtt_zd30[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zd30),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd30),6, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd30),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za31  : sk11 , tk01 {
  ~za31(); // tgen
  za31(); // tgen
};
//SIG(1 za31) C1{ BC2{ VBC3{} VBC4{}} BC5{ VBC4}}


za31 ::~za31(){ note_dtor("za31", this);} // tgen
za31 ::za31(){ note_ctor("za31", this);} // tgen

static void Test_za31()
{
  extern Class_Descriptor cd_za31;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za31, buf);
    za31 *dp, &lv = *(dp=new (buf) za31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za31)");
    check_base_class_offset(lv, (si*)(sk11*), 0, "za31");
    check_base_class_offset(lv, (sj*)(sk11*), 0, "za31");
    check_base_class_offset(lv, (sj*)(tk01*), 0, "za31");
    check_base_class_offset(lv, (sk11*), 0, "za31");
    check_base_class_offset(lv, (tk01*), ABISELECT(8,4), "za31");
    test_class_info(&lv, &cd_za31);
    dp->~za31();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza31(Test_za31, "za31", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za31C1Ev();
extern void _ZN4za31D1Ev();
Name_Map name_map_za31[] = {
  NSPAIR(_ZN4za31C1Ev),
  NSPAIR(_ZN4za31D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_za31[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_tk01,    ABISELECT(8,4), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za31[];
static  VTBL_ENTRY vtc_za31[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za31[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4za31[0]),
};
extern VTBL_ENTRY _ZTV4za31[];
static  VTBL_ENTRY _tg__ZTV4sk11__4za31[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk01__4za31[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTT_ENTRY vtt_za31[] = {
  {&(_ZTV4za31[4]),  4,7},
  {&(_tg__ZTV4sk11__4za31[4]),  4,4},
  {&(_tg__ZTV4tk01__4za31[3]),  3,3},
  {&(_ZTV4za31[7]),  7,7},
};
extern VTBL_ENTRY _ZTI4za31[];
extern  VTBL_ENTRY _ZTV4za31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za31[];
Class_Descriptor cd_za31 = {  "za31", // class name
  bases_za31, 4,
  &(vtc_za31[0]), // expected_vtbl_contents
  &(vtt_za31[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za31),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za31),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za31),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb31  : sk11 , virtual tk01 {
  ~zb31(); // tgen
  zb31(); // tgen
};
//SIG(1 zb31) C1{ BC2{ VBC3{} VBC4{}} VBC5{ VBC4}}


zb31 ::~zb31(){ note_dtor("zb31", this);} // tgen
zb31 ::zb31(){ note_ctor("zb31", this);} // tgen

static void Test_zb31()
{
  extern Class_Descriptor cd_zb31;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb31, buf);
    zb31 *dp, &lv = *(dp=new (buf) zb31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb31)");
    check_base_class_offset(lv, (si*)(sk11*), 0, "zb31");
    check_base_class_offset(lv, (sj*)(sk11*), 0, "zb31");
    check_base_class_offset(lv, (sj*)(tk01*), 0, "zb31");
    check_base_class_offset(lv, (sk11*), 0, "zb31");
    check_base_class_offset(lv, (tk01*), ABISELECT(8,4), "zb31");
    test_class_info(&lv, &cd_zb31);
    dp->~zb31();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb31(Test_zb31, "zb31", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb31C1Ev();
extern void _ZN4zb31D1Ev();
Name_Map name_map_zb31[] = {
  NSPAIR(_ZN4zb31C1Ev),
  NSPAIR(_ZN4zb31D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_zb31[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_tk01,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb31[];
static  VTBL_ENTRY vtc_zb31[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb31[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zb31[0]),
};
extern VTBL_ENTRY _ZTV4zb31[];
static  VTBL_ENTRY _tg__ZTV4sk11__4zb31[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk01__4zb31[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTT_ENTRY vtt_zb31[] = {
  {&(_ZTV4zb31[5]),  5,8},
  {&(_tg__ZTV4sk11__4zb31[4]),  4,4},
  {&(_ZTV4zb31[8]),  8,8},
  {&(_tg__ZTV4tk01__4zb31[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb31[];
extern  VTBL_ENTRY _ZTV4zb31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb31[];
Class_Descriptor cd_zb31 = {  "zb31", // class name
  bases_zb31, 4,
  &(vtc_zb31[0]), // expected_vtbl_contents
  &(vtt_zb31[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb31),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb31),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb31),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc31  : virtual sk11 , tk01 {
  ~zc31(); // tgen
  zc31(); // tgen
};
//SIG(1 zc31) C1{ VBC2{ VBC3{} VBC4{}} BC5{ VBC4}}


zc31 ::~zc31(){ note_dtor("zc31", this);} // tgen
zc31 ::zc31(){ note_ctor("zc31", this);} // tgen

static void Test_zc31()
{
  extern Class_Descriptor cd_zc31;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc31, buf);
    zc31 *dp, &lv = *(dp=new (buf) zc31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc31)");
    check_base_class_offset(lv, (si*)(sk11*), 0, "zc31");
    check_base_class_offset(lv, (sj*)(sk11*), 0, "zc31");
    check_base_class_offset(lv, (sj*)(tk01*), 0, "zc31");
    check_base_class_offset(lv, (sk11*), ABISELECT(8,4), "zc31");
    check_base_class_offset(lv, (tk01*), 0, "zc31");
    test_class_info(&lv, &cd_zc31);
    dp->~zc31();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc31(Test_zc31, "zc31", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc31C1Ev();
extern void _ZN4zc31D1Ev();
Name_Map name_map_zc31[] = {
  NSPAIR(_ZN4zc31C1Ev),
  NSPAIR(_ZN4zc31D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_zc31[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_tk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc31[];
static  VTBL_ENTRY vtc_zc31[] = {
  0,
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc31[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zc31[0]),
};
extern VTBL_ENTRY _ZTV4zc31[];
static  VTBL_ENTRY _tg__ZTV4tk01__4zc31[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTBL_ENTRY _tg__ZTV4sk11__4zc31[] = {
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTT_ENTRY vtt_zc31[] = {
  {&(_ZTV4zc31[5]),  5,9},
  {&(_tg__ZTV4tk01__4zc31[3]),  3,3},
  {&(_ZTV4zc31[9]),  9,9},
  {&(_tg__ZTV4sk11__4zc31[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zc31[];
extern  VTBL_ENTRY _ZTV4zc31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc31[];
Class_Descriptor cd_zc31 = {  "zc31", // class name
  bases_zc31, 4,
  &(vtc_zc31[0]), // expected_vtbl_contents
  &(vtt_zc31[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc31),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc31),9, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc31),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd31  : virtual sk11 , virtual tk01 {
  ~zd31(); // tgen
  zd31(); // tgen
};
//SIG(1 zd31) C1{ VBC2{ VBC3{} VBC4{}} VBC5{ VBC4}}


zd31 ::~zd31(){ note_dtor("zd31", this);} // tgen
zd31 ::zd31(){ note_ctor("zd31", this);} // tgen

static void Test_zd31()
{
  extern Class_Descriptor cd_zd31;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd31, buf);
    zd31 *dp, &lv = *(dp=new (buf) zd31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd31)");
    check_base_class_offset(lv, (si*)(sk11*), 0, "zd31");
    check_base_class_offset(lv, (sj*)(sk11*), 0, "zd31");
    check_base_class_offset(lv, (sj*)(tk01*), 0, "zd31");
    check_base_class_offset(lv, (sk11*), 0, "zd31");
    check_base_class_offset(lv, (tk01*), ABISELECT(8,4), "zd31");
    test_class_info(&lv, &cd_zd31);
    dp->~zd31();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd31(Test_zd31, "zd31", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd31C1Ev();
extern void _ZN4zd31D1Ev();
Name_Map name_map_zd31[] = {
  NSPAIR(_ZN4zd31C1Ev),
  NSPAIR(_ZN4zd31D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_zd31[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_tk01,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd31[];
static  VTBL_ENTRY vtc_zd31[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd31[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zd31[0]),
};
extern VTBL_ENTRY _ZTV4zd31[];
static  VTBL_ENTRY _tg__ZTV4sk11__4zd31[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk01__4zd31[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTT_ENTRY vtt_zd31[] = {
  {&(_ZTV4zd31[6]),  6,9},
  {&(_ZTV4zd31[6]),  6,9},
  {&(_ZTV4zd31[9]),  9,9},
  {&(_tg__ZTV4sk11__4zd31[4]),  4,4},
  {&(_tg__ZTV4tk01__4zd31[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd31[];
extern  VTBL_ENTRY _ZTV4zd31[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd31[];
Class_Descriptor cd_zd31 = {  "zd31", // class name
  bases_zd31, 4,
  &(vtc_zd31[0]), // expected_vtbl_contents
  &(vtt_zd31[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd31),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd31),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd31),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za32  : sk11 , tk02 {
  ~za32(); // tgen
  za32(); // tgen
};
//SIG(1 za32) C1{ BC2{ VBC3{} VBC4{}} BC5{ BC4}}


za32 ::~za32(){ note_dtor("za32", this);} // tgen
za32 ::za32(){ note_ctor("za32", this);} // tgen

static void Test_za32()
{
  extern Class_Descriptor cd_za32;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za32, buf);
    za32 *dp, &lv = *(dp=new (buf) za32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za32)");
    check_base_class_offset(lv, (si*)(sk11*), 0, "za32");
    check_base_class_offset(lv, (sj*)(sk11*), ABISELECT(8,4), "za32");
    check_base_class_offset(lv, (sk11*), 0, "za32");
    check_base_class_offset(lv, (sj*)(tk02*), 0, "za32");
    check_base_class_offset(lv, (tk02*), 0, "za32");
    test_class_info(&lv, &cd_za32);
    dp->~za32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza32(Test_za32, "za32", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za32C1Ev();
extern void _ZN4za32D1Ev();
Name_Map name_map_za32[] = {
  NSPAIR(_ZN4za32C1Ev),
  NSPAIR(_ZN4za32D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_za32[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za32[];
static  VTBL_ENTRY vtc_za32[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za32[0]),
};
extern VTBL_ENTRY _ZTV4za32[];
static  VTBL_ENTRY _tg__ZTV4sk11__4za32[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTT_ENTRY vtt_za32[] = {
  {&(_ZTV4za32[4]),  4,4},
  {&(_tg__ZTV4sk11__4za32[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4za32[];
extern  VTBL_ENTRY _ZTV4za32[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za32[];
Class_Descriptor cd_za32 = {  "za32", // class name
  bases_za32, 5,
  &(vtc_za32[0]), // expected_vtbl_contents
  &(vtt_za32[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za32),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za32),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za32),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb32  : sk11 , virtual tk02 {
  ~zb32(); // tgen
  zb32(); // tgen
};
//SIG(1 zb32) C1{ BC2{ VBC3{} VBC4{}} VBC5{ BC4}}


zb32 ::~zb32(){ note_dtor("zb32", this);} // tgen
zb32 ::zb32(){ note_ctor("zb32", this);} // tgen

static void Test_zb32()
{
  extern Class_Descriptor cd_zb32;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb32, buf);
    zb32 *dp, &lv = *(dp=new (buf) zb32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb32)");
    check_base_class_offset(lv, (si*)(sk11*), 0, "zb32");
    check_base_class_offset(lv, (sj*)(sk11*), 0, "zb32");
    check_base_class_offset(lv, (sk11*), 0, "zb32");
    check_base_class_offset(lv, (sj*)(tk02*), ABISELECT(8,4), "zb32");
    check_base_class_offset(lv, (tk02*), ABISELECT(8,4), "zb32");
    test_class_info(&lv, &cd_zb32);
    dp->~zb32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb32(Test_zb32, "zb32", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb32C1Ev();
extern void _ZN4zb32D1Ev();
Name_Map name_map_zb32[] = {
  NSPAIR(_ZN4zb32C1Ev),
  NSPAIR(_ZN4zb32D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_zb32[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk02,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb32[];
static  VTBL_ENTRY vtc_zb32[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb32[0]),
};
extern VTBL_ENTRY _ZTV4zb32[];
static  VTBL_ENTRY _tg__ZTV4sk11__4zb32[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTT_ENTRY vtt_zb32[] = {
  {&(_ZTV4zb32[5]),  5,5},
  {&(_tg__ZTV4sk11__4zb32[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zb32[];
extern  VTBL_ENTRY _ZTV4zb32[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb32[];
Class_Descriptor cd_zb32 = {  "zb32", // class name
  bases_zb32, 5,
  &(vtc_zb32[0]), // expected_vtbl_contents
  &(vtt_zb32[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb32),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb32),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb32),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc32  : virtual sk11 , tk02 {
  ~zc32(); // tgen
  zc32(); // tgen
};
//SIG(1 zc32) C1{ VBC2{ VBC3{} VBC4{}} BC5{ BC4}}


zc32 ::~zc32(){ note_dtor("zc32", this);} // tgen
zc32 ::zc32(){ note_ctor("zc32", this);} // tgen

static void Test_zc32()
{
  extern Class_Descriptor cd_zc32;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc32, buf);
    zc32 *dp, &lv = *(dp=new (buf) zc32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc32)");
    check_base_class_offset(lv, (si*)(sk11*), 0, "zc32");
    check_base_class_offset(lv, (sj*)(sk11*), ABISELECT(8,4), "zc32");
    check_base_class_offset(lv, (sk11*), 0, "zc32");
    check_base_class_offset(lv, (sj*)(tk02*), 0, "zc32");
    check_base_class_offset(lv, (tk02*), 0, "zc32");
    test_class_info(&lv, &cd_zc32);
    dp->~zc32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc32(Test_zc32, "zc32", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc32C1Ev();
extern void _ZN4zc32D1Ev();
Name_Map name_map_zc32[] = {
  NSPAIR(_ZN4zc32C1Ev),
  NSPAIR(_ZN4zc32D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_zc32[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc32[];
static  VTBL_ENTRY vtc_zc32[] = {
  0,
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc32[0]),
};
extern VTBL_ENTRY _ZTV4zc32[];
static  VTBL_ENTRY _tg__ZTV4sk11__4zc32[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTT_ENTRY vtt_zc32[] = {
  {&(_ZTV4zc32[5]),  5,5},
  {&(_ZTV4zc32[5]),  5,5},
  {&(_tg__ZTV4sk11__4zc32[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zc32[];
extern  VTBL_ENTRY _ZTV4zc32[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc32[];
Class_Descriptor cd_zc32 = {  "zc32", // class name
  bases_zc32, 5,
  &(vtc_zc32[0]), // expected_vtbl_contents
  &(vtt_zc32[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc32),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc32),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc32),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd32  : virtual sk11 , virtual tk02 {
  ~zd32(); // tgen
  zd32(); // tgen
};
//SIG(1 zd32) C1{ VBC2{ VBC3{} VBC4{}} VBC5{ BC4}}


zd32 ::~zd32(){ note_dtor("zd32", this);} // tgen
zd32 ::zd32(){ note_ctor("zd32", this);} // tgen

static void Test_zd32()
{
  extern Class_Descriptor cd_zd32;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd32, buf);
    zd32 *dp, &lv = *(dp=new (buf) zd32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd32)");
    check_base_class_offset(lv, (si*)(sk11*), 0, "zd32");
    check_base_class_offset(lv, (sj*)(sk11*), 0, "zd32");
    check_base_class_offset(lv, (sk11*), 0, "zd32");
    check_base_class_offset(lv, (sj*)(tk02*), ABISELECT(8,4), "zd32");
    check_base_class_offset(lv, (tk02*), ABISELECT(8,4), "zd32");
    test_class_info(&lv, &cd_zd32);
    dp->~zd32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd32(Test_zd32, "zd32", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd32C1Ev();
extern void _ZN4zd32D1Ev();
Name_Map name_map_zd32[] = {
  NSPAIR(_ZN4zd32C1Ev),
  NSPAIR(_ZN4zd32D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_zd32[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk02,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd32[];
static  VTBL_ENTRY vtc_zd32[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd32[0]),
};
extern VTBL_ENTRY _ZTV4zd32[];
static  VTBL_ENTRY _tg__ZTV4sk11__4zd32[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTT_ENTRY vtt_zd32[] = {
  {&(_ZTV4zd32[6]),  6,6},
  {&(_ZTV4zd32[6]),  6,6},
  {&(_tg__ZTV4sk11__4zd32[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zd32[];
extern  VTBL_ENTRY _ZTV4zd32[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd32[];
Class_Descriptor cd_zd32 = {  "zd32", // class name
  bases_zd32, 5,
  &(vtc_zd32[0]), // expected_vtbl_contents
  &(vtt_zd32[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd32),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd32),6, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd32),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za33  : sk11 , tk11 {
  ~za33(); // tgen
  za33(); // tgen
};
//SIG(1 za33) C1{ BC2{ VBC3{} VBC4{}} BC5{ VBC3 VBC4}}


za33 ::~za33(){ note_dtor("za33", this);} // tgen
za33 ::za33(){ note_ctor("za33", this);} // tgen

static void Test_za33()
{
  extern Class_Descriptor cd_za33;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za33, buf);
    za33 *dp, &lv = *(dp=new (buf) za33());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za33)");
    check_base_class_offset(lv, (si*)(sk11*), 0, "za33");
    check_base_class_offset(lv, (si*)(tk11*), 0, "za33");
    check_base_class_offset(lv, (sj*)(sk11*), 0, "za33");
    check_base_class_offset(lv, (sj*)(tk11*), 0, "za33");
    check_base_class_offset(lv, (sk11*), 0, "za33");
    check_base_class_offset(lv, (tk11*), ABISELECT(8,4), "za33");
    test_class_info(&lv, &cd_za33);
    dp->~za33();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza33(Test_za33, "za33", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za33C1Ev();
extern void _ZN4za33D1Ev();
Name_Map name_map_za33[] = {
  NSPAIR(_ZN4za33C1Ev),
  NSPAIR(_ZN4za33D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_za33[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_tk11,    ABISELECT(8,4), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za33[];
static  VTBL_ENTRY vtc_za33[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za33[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4za33[0]),
};
extern VTBL_ENTRY _ZTV4za33[];
static  VTBL_ENTRY _tg__ZTV4sk11__4za33[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk11__4za33[] = {
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTT_ENTRY vtt_za33[] = {
  {&(_ZTV4za33[4]),  4,8},
  {&(_tg__ZTV4sk11__4za33[4]),  4,4},
  {&(_tg__ZTV4tk11__4za33[4]),  4,4},
  {&(_ZTV4za33[8]),  8,8},
};
extern VTBL_ENTRY _ZTI4za33[];
extern  VTBL_ENTRY _ZTV4za33[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za33[];
Class_Descriptor cd_za33 = {  "za33", // class name
  bases_za33, 4,
  &(vtc_za33[0]), // expected_vtbl_contents
  &(vtt_za33[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za33),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za33),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za33),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb33  : sk11 , virtual tk11 {
  ~zb33(); // tgen
  zb33(); // tgen
};
//SIG(1 zb33) C1{ BC2{ VBC3{} VBC4{}} VBC5{ VBC3 VBC4}}


zb33 ::~zb33(){ note_dtor("zb33", this);} // tgen
zb33 ::zb33(){ note_ctor("zb33", this);} // tgen

static void Test_zb33()
{
  extern Class_Descriptor cd_zb33;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb33, buf);
    zb33 *dp, &lv = *(dp=new (buf) zb33());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb33)");
    check_base_class_offset(lv, (si*)(sk11*), 0, "zb33");
    check_base_class_offset(lv, (si*)(tk11*), 0, "zb33");
    check_base_class_offset(lv, (sj*)(sk11*), 0, "zb33");
    check_base_class_offset(lv, (sj*)(tk11*), 0, "zb33");
    check_base_class_offset(lv, (sk11*), 0, "zb33");
    check_base_class_offset(lv, (tk11*), ABISELECT(8,4), "zb33");
    test_class_info(&lv, &cd_zb33);
    dp->~zb33();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb33(Test_zb33, "zb33", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb33C1Ev();
extern void _ZN4zb33D1Ev();
Name_Map name_map_zb33[] = {
  NSPAIR(_ZN4zb33C1Ev),
  NSPAIR(_ZN4zb33D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_zb33[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_tk11,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb33[];
static  VTBL_ENTRY vtc_zb33[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb33[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zb33[0]),
};
extern VTBL_ENTRY _ZTV4zb33[];
static  VTBL_ENTRY _tg__ZTV4sk11__4zb33[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk11__4zb33[] = {
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTT_ENTRY vtt_zb33[] = {
  {&(_ZTV4zb33[5]),  5,9},
  {&(_tg__ZTV4sk11__4zb33[4]),  4,4},
  {&(_ZTV4zb33[9]),  9,9},
  {&(_tg__ZTV4tk11__4zb33[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zb33[];
extern  VTBL_ENTRY _ZTV4zb33[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb33[];
Class_Descriptor cd_zb33 = {  "zb33", // class name
  bases_zb33, 4,
  &(vtc_zb33[0]), // expected_vtbl_contents
  &(vtt_zb33[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb33),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb33),9, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb33),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc33  : virtual sk11 , tk11 {
  ~zc33(); // tgen
  zc33(); // tgen
};
//SIG(1 zc33) C1{ VBC2{ VBC3{} VBC4{}} BC5{ VBC3 VBC4}}


zc33 ::~zc33(){ note_dtor("zc33", this);} // tgen
zc33 ::zc33(){ note_ctor("zc33", this);} // tgen

static void Test_zc33()
{
  extern Class_Descriptor cd_zc33;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc33, buf);
    zc33 *dp, &lv = *(dp=new (buf) zc33());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc33)");
    check_base_class_offset(lv, (si*)(sk11*), 0, "zc33");
    check_base_class_offset(lv, (si*)(tk11*), 0, "zc33");
    check_base_class_offset(lv, (sj*)(sk11*), 0, "zc33");
    check_base_class_offset(lv, (sj*)(tk11*), 0, "zc33");
    check_base_class_offset(lv, (sk11*), ABISELECT(8,4), "zc33");
    check_base_class_offset(lv, (tk11*), 0, "zc33");
    test_class_info(&lv, &cd_zc33);
    dp->~zc33();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc33(Test_zc33, "zc33", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc33C1Ev();
extern void _ZN4zc33D1Ev();
Name_Map name_map_zc33[] = {
  NSPAIR(_ZN4zc33C1Ev),
  NSPAIR(_ZN4zc33D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_zc33[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_tk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc33[];
static  VTBL_ENTRY vtc_zc33[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc33[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zc33[0]),
};
extern VTBL_ENTRY _ZTV4zc33[];
static  VTBL_ENTRY _tg__ZTV4tk11__4zc33[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTBL_ENTRY _tg__ZTV4sk11__4zc33[] = {
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTT_ENTRY vtt_zc33[] = {
  {&(_ZTV4zc33[5]),  5,9},
  {&(_tg__ZTV4tk11__4zc33[4]),  4,4},
  {&(_ZTV4zc33[9]),  9,9},
  {&(_tg__ZTV4sk11__4zc33[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zc33[];
extern  VTBL_ENTRY _ZTV4zc33[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc33[];
Class_Descriptor cd_zc33 = {  "zc33", // class name
  bases_zc33, 4,
  &(vtc_zc33[0]), // expected_vtbl_contents
  &(vtt_zc33[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc33),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc33),9, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc33),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd33  : virtual sk11 , virtual tk11 {
  ~zd33(); // tgen
  zd33(); // tgen
};
//SIG(1 zd33) C1{ VBC2{ VBC3{} VBC4{}} VBC5{ VBC3 VBC4}}


zd33 ::~zd33(){ note_dtor("zd33", this);} // tgen
zd33 ::zd33(){ note_ctor("zd33", this);} // tgen

static void Test_zd33()
{
  extern Class_Descriptor cd_zd33;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd33, buf);
    zd33 *dp, &lv = *(dp=new (buf) zd33());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd33)");
    check_base_class_offset(lv, (si*)(sk11*), 0, "zd33");
    check_base_class_offset(lv, (si*)(tk11*), 0, "zd33");
    check_base_class_offset(lv, (sj*)(sk11*), 0, "zd33");
    check_base_class_offset(lv, (sj*)(tk11*), 0, "zd33");
    check_base_class_offset(lv, (sk11*), 0, "zd33");
    check_base_class_offset(lv, (tk11*), ABISELECT(8,4), "zd33");
    test_class_info(&lv, &cd_zd33);
    dp->~zd33();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd33(Test_zd33, "zd33", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd33C1Ev();
extern void _ZN4zd33D1Ev();
Name_Map name_map_zd33[] = {
  NSPAIR(_ZN4zd33C1Ev),
  NSPAIR(_ZN4zd33D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_zd33[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_tk11,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd33[];
static  VTBL_ENTRY vtc_zd33[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd33[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zd33[0]),
};
extern VTBL_ENTRY _ZTV4zd33[];
static  VTBL_ENTRY _tg__ZTV4sk11__4zd33[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk11__4zd33[] = {
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTT_ENTRY vtt_zd33[] = {
  {&(_ZTV4zd33[6]),  6,10},
  {&(_ZTV4zd33[6]),  6,10},
  {&(_ZTV4zd33[10]),  10,10},
  {&(_tg__ZTV4sk11__4zd33[4]),  4,4},
  {&(_tg__ZTV4tk11__4zd33[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zd33[];
extern  VTBL_ENTRY _ZTV4zd33[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd33[];
Class_Descriptor cd_zd33 = {  "zd33", // class name
  bases_zd33, 4,
  &(vtc_zd33[0]), // expected_vtbl_contents
  &(vtt_zd33[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd33),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd33),10, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd33),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za34  : sk11 , tk12 {
  ~za34(); // tgen
  za34(); // tgen
};
//SIG(1 za34) C1{ BC2{ VBC3{} VBC4{}} BC5{ VBC3 BC4}}


za34 ::~za34(){ note_dtor("za34", this);} // tgen
za34 ::za34(){ note_ctor("za34", this);} // tgen

static void Test_za34()
{
  extern Class_Descriptor cd_za34;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za34, buf);
    za34 *dp, &lv = *(dp=new (buf) za34());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za34)");
    check_base_class_offset(lv, (si*)(sk11*), 0, "za34");
    check_base_class_offset(lv, (si*)(tk12*), 0, "za34");
    check_base_class_offset(lv, (sj*)(sk11*), 0, "za34");
    check_base_class_offset(lv, (sk11*), 0, "za34");
    check_base_class_offset(lv, (sj*)(tk12*), ABISELECT(8,4), "za34");
    check_base_class_offset(lv, (tk12*), ABISELECT(8,4), "za34");
    test_class_info(&lv, &cd_za34);
    dp->~za34();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza34(Test_za34, "za34", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za34C1Ev();
extern void _ZN4za34D1Ev();
Name_Map name_map_za34[] = {
  NSPAIR(_ZN4za34C1Ev),
  NSPAIR(_ZN4za34D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_za34[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk12,    ABISELECT(8,4), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za34[];
static  VTBL_ENTRY vtc_za34[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za34[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4za34[0]),
};
extern VTBL_ENTRY _ZTV4za34[];
static  VTBL_ENTRY _tg__ZTV4sk11__4za34[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk12__4za34[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTT_ENTRY vtt_za34[] = {
  {&(_ZTV4za34[4]),  4,7},
  {&(_tg__ZTV4sk11__4za34[4]),  4,4},
  {&(_tg__ZTV4tk12__4za34[3]),  3,3},
  {&(_ZTV4za34[7]),  7,7},
};
extern VTBL_ENTRY _ZTI4za34[];
extern  VTBL_ENTRY _ZTV4za34[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za34[];
Class_Descriptor cd_za34 = {  "za34", // class name
  bases_za34, 5,
  &(vtc_za34[0]), // expected_vtbl_contents
  &(vtt_za34[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za34),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za34),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za34),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb34  : sk11 , virtual tk12 {
  ~zb34(); // tgen
  zb34(); // tgen
};
//SIG(1 zb34) C1{ BC2{ VBC3{} VBC4{}} VBC5{ VBC3 BC4}}


zb34 ::~zb34(){ note_dtor("zb34", this);} // tgen
zb34 ::zb34(){ note_ctor("zb34", this);} // tgen

static void Test_zb34()
{
  extern Class_Descriptor cd_zb34;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb34, buf);
    zb34 *dp, &lv = *(dp=new (buf) zb34());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb34)");
    check_base_class_offset(lv, (si*)(sk11*), 0, "zb34");
    check_base_class_offset(lv, (si*)(tk12*), 0, "zb34");
    check_base_class_offset(lv, (sj*)(sk11*), 0, "zb34");
    check_base_class_offset(lv, (sk11*), 0, "zb34");
    check_base_class_offset(lv, (sj*)(tk12*), ABISELECT(8,4), "zb34");
    check_base_class_offset(lv, (tk12*), ABISELECT(8,4), "zb34");
    test_class_info(&lv, &cd_zb34);
    dp->~zb34();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb34(Test_zb34, "zb34", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb34C1Ev();
extern void _ZN4zb34D1Ev();
Name_Map name_map_zb34[] = {
  NSPAIR(_ZN4zb34C1Ev),
  NSPAIR(_ZN4zb34D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_zb34[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk12,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb34[];
static  VTBL_ENTRY vtc_zb34[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb34[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zb34[0]),
};
extern VTBL_ENTRY _ZTV4zb34[];
static  VTBL_ENTRY _tg__ZTV4sk11__4zb34[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk12__4zb34[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTT_ENTRY vtt_zb34[] = {
  {&(_ZTV4zb34[5]),  5,8},
  {&(_tg__ZTV4sk11__4zb34[4]),  4,4},
  {&(_ZTV4zb34[8]),  8,8},
  {&(_tg__ZTV4tk12__4zb34[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb34[];
extern  VTBL_ENTRY _ZTV4zb34[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb34[];
Class_Descriptor cd_zb34 = {  "zb34", // class name
  bases_zb34, 5,
  &(vtc_zb34[0]), // expected_vtbl_contents
  &(vtt_zb34[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb34),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb34),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb34),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc34  : virtual sk11 , tk12 {
  ~zc34(); // tgen
  zc34(); // tgen
};
//SIG(1 zc34) C1{ VBC2{ VBC3{} VBC4{}} BC5{ VBC3 BC4}}


zc34 ::~zc34(){ note_dtor("zc34", this);} // tgen
zc34 ::zc34(){ note_ctor("zc34", this);} // tgen

static void Test_zc34()
{
  extern Class_Descriptor cd_zc34;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_zc34, buf);
    zc34 *dp, &lv = *(dp=new (buf) zc34());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(zc34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc34)");
    check_base_class_offset(lv, (si*)(sk11*), 0, "zc34");
    check_base_class_offset(lv, (si*)(tk12*), 0, "zc34");
    check_base_class_offset(lv, (sj*)(sk11*), ABISELECT(16,8), "zc34");
    check_base_class_offset(lv, (sk11*), ABISELECT(8,4), "zc34");
    check_base_class_offset(lv, (sj*)(tk12*), 0, "zc34");
    check_base_class_offset(lv, (tk12*), 0, "zc34");
    test_class_info(&lv, &cd_zc34);
    dp->~zc34();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc34(Test_zc34, "zc34", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN4zc34C1Ev();
extern void _ZN4zc34D1Ev();
Name_Map name_map_zc34[] = {
  NSPAIR(_ZN4zc34C1Ev),
  NSPAIR(_ZN4zc34D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_zc34[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc34[];
static  VTBL_ENTRY vtc_zc34[] = {
  ABISELECT(16,8),
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc34[0]),
  ABISELECT(8,4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zc34[0]),
};
extern VTBL_ENTRY _ZTV4zc34[];
static  VTBL_ENTRY _tg__ZTV4tk12__4zc34[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTBL_ENTRY _tg__ZTV4sk11__4zc34[] = {
  ABISELECT(8,4),
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTT_ENTRY vtt_zc34[] = {
  {&(_ZTV4zc34[5]),  5,9},
  {&(_tg__ZTV4tk12__4zc34[3]),  3,3},
  {&(_ZTV4zc34[9]),  9,9},
  {&(_tg__ZTV4sk11__4zc34[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zc34[];
extern  VTBL_ENTRY _ZTV4zc34[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc34[];
Class_Descriptor cd_zc34 = {  "zc34", // class name
  bases_zc34, 5,
  &(vtc_zc34[0]), // expected_vtbl_contents
  &(vtt_zc34[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI4zc34),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc34),9, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc34),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd34  : virtual sk11 , virtual tk12 {
  ~zd34(); // tgen
  zd34(); // tgen
};
//SIG(1 zd34) C1{ VBC2{ VBC3{} VBC4{}} VBC5{ VBC3 BC4}}


zd34 ::~zd34(){ note_dtor("zd34", this);} // tgen
zd34 ::zd34(){ note_ctor("zd34", this);} // tgen

static void Test_zd34()
{
  extern Class_Descriptor cd_zd34;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd34, buf);
    zd34 *dp, &lv = *(dp=new (buf) zd34());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd34)");
    check_base_class_offset(lv, (si*)(sk11*), 0, "zd34");
    check_base_class_offset(lv, (si*)(tk12*), 0, "zd34");
    check_base_class_offset(lv, (sj*)(sk11*), 0, "zd34");
    check_base_class_offset(lv, (sk11*), 0, "zd34");
    check_base_class_offset(lv, (sj*)(tk12*), ABISELECT(8,4), "zd34");
    check_base_class_offset(lv, (tk12*), ABISELECT(8,4), "zd34");
    test_class_info(&lv, &cd_zd34);
    dp->~zd34();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd34(Test_zd34, "zd34", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd34C1Ev();
extern void _ZN4zd34D1Ev();
Name_Map name_map_zd34[] = {
  NSPAIR(_ZN4zd34C1Ev),
  NSPAIR(_ZN4zd34D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_zd34[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk12,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd34[];
static  VTBL_ENTRY vtc_zd34[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd34[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zd34[0]),
};
extern VTBL_ENTRY _ZTV4zd34[];
static  VTBL_ENTRY _tg__ZTV4sk11__4zd34[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk12__4zd34[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTT_ENTRY vtt_zd34[] = {
  {&(_ZTV4zd34[6]),  6,9},
  {&(_ZTV4zd34[6]),  6,9},
  {&(_ZTV4zd34[9]),  9,9},
  {&(_tg__ZTV4sk11__4zd34[4]),  4,4},
  {&(_tg__ZTV4tk12__4zd34[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd34[];
extern  VTBL_ENTRY _ZTV4zd34[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd34[];
Class_Descriptor cd_zd34 = {  "zd34", // class name
  bases_zd34, 5,
  &(vtc_zd34[0]), // expected_vtbl_contents
  &(vtt_zd34[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd34),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd34),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd34),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za35  : sk11 , tk21 {
  ~za35(); // tgen
  za35(); // tgen
};
//SIG(1 za35) C1{ BC2{ VBC3{} VBC4{}} BC5{ BC3 VBC4}}


za35 ::~za35(){ note_dtor("za35", this);} // tgen
za35 ::za35(){ note_ctor("za35", this);} // tgen

static void Test_za35()
{
  extern Class_Descriptor cd_za35;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za35, buf);
    za35 *dp, &lv = *(dp=new (buf) za35());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za35)");
    check_base_class_offset(lv, (si*)(sk11*), 0, "za35");
    check_base_class_offset(lv, (sj*)(sk11*), 0, "za35");
    check_base_class_offset(lv, (sj*)(tk21*), 0, "za35");
    check_base_class_offset(lv, (sk11*), 0, "za35");
    check_base_class_offset(lv, (si*)(tk21*), ABISELECT(8,4), "za35");
    check_base_class_offset(lv, (tk21*), ABISELECT(8,4), "za35");
    test_class_info(&lv, &cd_za35);
    dp->~za35();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza35(Test_za35, "za35", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za35C1Ev();
extern void _ZN4za35D1Ev();
Name_Map name_map_za35[] = {
  NSPAIR(_ZN4za35C1Ev),
  NSPAIR(_ZN4za35D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_za35[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk21,    ABISELECT(8,4), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za35[];
static  VTBL_ENTRY vtc_za35[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za35[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4za35[0]),
};
extern VTBL_ENTRY _ZTV4za35[];
static  VTBL_ENTRY _tg__ZTV4sk11__4za35[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk21__4za35[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTT_ENTRY vtt_za35[] = {
  {&(_ZTV4za35[4]),  4,7},
  {&(_tg__ZTV4sk11__4za35[4]),  4,4},
  {&(_tg__ZTV4tk21__4za35[3]),  3,3},
  {&(_ZTV4za35[7]),  7,7},
};
extern VTBL_ENTRY _ZTI4za35[];
extern  VTBL_ENTRY _ZTV4za35[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za35[];
Class_Descriptor cd_za35 = {  "za35", // class name
  bases_za35, 5,
  &(vtc_za35[0]), // expected_vtbl_contents
  &(vtt_za35[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za35),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za35),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za35),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb35  : sk11 , virtual tk21 {
  ~zb35(); // tgen
  zb35(); // tgen
};
//SIG(1 zb35) C1{ BC2{ VBC3{} VBC4{}} VBC5{ BC3 VBC4}}


zb35 ::~zb35(){ note_dtor("zb35", this);} // tgen
zb35 ::zb35(){ note_ctor("zb35", this);} // tgen

static void Test_zb35()
{
  extern Class_Descriptor cd_zb35;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb35, buf);
    zb35 *dp, &lv = *(dp=new (buf) zb35());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb35)");
    check_base_class_offset(lv, (si*)(sk11*), 0, "zb35");
    check_base_class_offset(lv, (sj*)(sk11*), 0, "zb35");
    check_base_class_offset(lv, (sj*)(tk21*), 0, "zb35");
    check_base_class_offset(lv, (sk11*), 0, "zb35");
    check_base_class_offset(lv, (si*)(tk21*), ABISELECT(8,4), "zb35");
    check_base_class_offset(lv, (tk21*), ABISELECT(8,4), "zb35");
    test_class_info(&lv, &cd_zb35);
    dp->~zb35();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb35(Test_zb35, "zb35", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb35C1Ev();
extern void _ZN4zb35D1Ev();
Name_Map name_map_zb35[] = {
  NSPAIR(_ZN4zb35C1Ev),
  NSPAIR(_ZN4zb35D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_zb35[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk21,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb35[];
static  VTBL_ENTRY vtc_zb35[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb35[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zb35[0]),
};
extern VTBL_ENTRY _ZTV4zb35[];
static  VTBL_ENTRY _tg__ZTV4sk11__4zb35[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk21__4zb35[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTT_ENTRY vtt_zb35[] = {
  {&(_ZTV4zb35[5]),  5,8},
  {&(_tg__ZTV4sk11__4zb35[4]),  4,4},
  {&(_ZTV4zb35[8]),  8,8},
  {&(_tg__ZTV4tk21__4zb35[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb35[];
extern  VTBL_ENTRY _ZTV4zb35[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb35[];
Class_Descriptor cd_zb35 = {  "zb35", // class name
  bases_zb35, 5,
  &(vtc_zb35[0]), // expected_vtbl_contents
  &(vtt_zb35[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb35),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb35),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb35),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc35  : virtual sk11 , tk21 {
  ~zc35(); // tgen
  zc35(); // tgen
};
//SIG(1 zc35) C1{ VBC2{ VBC3{} VBC4{}} BC5{ BC3 VBC4}}


zc35 ::~zc35(){ note_dtor("zc35", this);} // tgen
zc35 ::zc35(){ note_ctor("zc35", this);} // tgen

static void Test_zc35()
{
  extern Class_Descriptor cd_zc35;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_zc35, buf);
    zc35 *dp, &lv = *(dp=new (buf) zc35());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(zc35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc35)");
    check_base_class_offset(lv, (si*)(sk11*), ABISELECT(16,8), "zc35");
    check_base_class_offset(lv, (sj*)(sk11*), 0, "zc35");
    check_base_class_offset(lv, (sj*)(tk21*), 0, "zc35");
    check_base_class_offset(lv, (sk11*), ABISELECT(8,4), "zc35");
    check_base_class_offset(lv, (si*)(tk21*), 0, "zc35");
    check_base_class_offset(lv, (tk21*), 0, "zc35");
    test_class_info(&lv, &cd_zc35);
    dp->~zc35();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc35(Test_zc35, "zc35", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN4zc35C1Ev();
extern void _ZN4zc35D1Ev();
Name_Map name_map_zc35[] = {
  NSPAIR(_ZN4zc35C1Ev),
  NSPAIR(_ZN4zc35D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_zc35[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc35[];
static  VTBL_ENTRY vtc_zc35[] = {
  ABISELECT(16,8),
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc35[0]),
  ABISELECT(-8,-4),
  ABISELECT(8,4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zc35[0]),
};
extern VTBL_ENTRY _ZTV4zc35[];
static  VTBL_ENTRY _tg__ZTV4tk21__4zc35[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTBL_ENTRY _tg__ZTV4sk11__4zc35[] = {
  ABISELECT(-8,-4),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTT_ENTRY vtt_zc35[] = {
  {&(_ZTV4zc35[5]),  5,9},
  {&(_tg__ZTV4tk21__4zc35[3]),  3,3},
  {&(_ZTV4zc35[9]),  9,9},
  {&(_tg__ZTV4sk11__4zc35[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zc35[];
extern  VTBL_ENTRY _ZTV4zc35[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc35[];
Class_Descriptor cd_zc35 = {  "zc35", // class name
  bases_zc35, 5,
  &(vtc_zc35[0]), // expected_vtbl_contents
  &(vtt_zc35[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI4zc35),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc35),9, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc35),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd35  : virtual sk11 , virtual tk21 {
  ~zd35(); // tgen
  zd35(); // tgen
};
//SIG(1 zd35) C1{ VBC2{ VBC3{} VBC4{}} VBC5{ BC3 VBC4}}


zd35 ::~zd35(){ note_dtor("zd35", this);} // tgen
zd35 ::zd35(){ note_ctor("zd35", this);} // tgen

static void Test_zd35()
{
  extern Class_Descriptor cd_zd35;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd35, buf);
    zd35 *dp, &lv = *(dp=new (buf) zd35());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd35)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd35)");
    check_base_class_offset(lv, (si*)(sk11*), 0, "zd35");
    check_base_class_offset(lv, (sj*)(sk11*), 0, "zd35");
    check_base_class_offset(lv, (sj*)(tk21*), 0, "zd35");
    check_base_class_offset(lv, (sk11*), 0, "zd35");
    check_base_class_offset(lv, (si*)(tk21*), ABISELECT(8,4), "zd35");
    check_base_class_offset(lv, (tk21*), ABISELECT(8,4), "zd35");
    test_class_info(&lv, &cd_zd35);
    dp->~zd35();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd35(Test_zd35, "zd35", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd35C1Ev();
extern void _ZN4zd35D1Ev();
Name_Map name_map_zd35[] = {
  NSPAIR(_ZN4zd35C1Ev),
  NSPAIR(_ZN4zd35D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_zd35[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk21,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd35[];
static  VTBL_ENTRY vtc_zd35[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd35[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zd35[0]),
};
extern VTBL_ENTRY _ZTV4zd35[];
static  VTBL_ENTRY _tg__ZTV4sk11__4zd35[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk21__4zd35[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTT_ENTRY vtt_zd35[] = {
  {&(_ZTV4zd35[6]),  6,9},
  {&(_ZTV4zd35[6]),  6,9},
  {&(_ZTV4zd35[9]),  9,9},
  {&(_tg__ZTV4sk11__4zd35[4]),  4,4},
  {&(_tg__ZTV4tk21__4zd35[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd35[];
extern  VTBL_ENTRY _ZTV4zd35[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd35[];
Class_Descriptor cd_zd35 = {  "zd35", // class name
  bases_zd35, 5,
  &(vtc_zd35[0]), // expected_vtbl_contents
  &(vtt_zd35[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd35),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd35),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd35),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za36  : sk11 , tk22 {
  ~za36(); // tgen
  za36(); // tgen
};
//SIG(1 za36) C1{ BC2{ VBC3{} VBC4{}} BC5{ BC3 BC4}}


za36 ::~za36(){ note_dtor("za36", this);} // tgen
za36 ::za36(){ note_ctor("za36", this);} // tgen

static void Test_za36()
{
  extern Class_Descriptor cd_za36;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za36, buf);
    za36 *dp, &lv = *(dp=new (buf) za36());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za36)");
    check_base_class_offset(lv, (si*)(sk11*), ABISELECT(8,4), "za36");
    check_base_class_offset(lv, (sj*)(sk11*), ABISELECT(8,4), "za36");
    check_base_class_offset(lv, (sk11*), 0, "za36");
    check_base_class_offset(lv, (si*)(tk22*), 0, "za36");
    check_base_class_offset(lv, (sj*)(tk22*), 0, "za36");
    check_base_class_offset(lv, (tk22*), 0, "za36");
    test_class_info(&lv, &cd_za36);
    dp->~za36();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza36(Test_za36, "za36", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za36C1Ev();
extern void _ZN4za36D1Ev();
Name_Map name_map_za36[] = {
  NSPAIR(_ZN4za36C1Ev),
  NSPAIR(_ZN4za36D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_za36[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_tk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za36[];
static  VTBL_ENTRY vtc_za36[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4za36[0]),
};
extern VTBL_ENTRY _ZTV4za36[];
static  VTBL_ENTRY _tg__ZTV4sk11__4za36[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTT_ENTRY vtt_za36[] = {
  {&(_ZTV4za36[4]),  4,4},
  {&(_tg__ZTV4sk11__4za36[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4za36[];
extern  VTBL_ENTRY _ZTV4za36[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za36[];
Class_Descriptor cd_za36 = {  "za36", // class name
  bases_za36, 6,
  &(vtc_za36[0]), // expected_vtbl_contents
  &(vtt_za36[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za36),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za36),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za36),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb36  : sk11 , virtual tk22 {
  ~zb36(); // tgen
  zb36(); // tgen
};
//SIG(1 zb36) C1{ BC2{ VBC3{} VBC4{}} VBC5{ BC3 BC4}}


zb36 ::~zb36(){ note_dtor("zb36", this);} // tgen
zb36 ::zb36(){ note_ctor("zb36", this);} // tgen

static void Test_zb36()
{
  extern Class_Descriptor cd_zb36;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb36, buf);
    zb36 *dp, &lv = *(dp=new (buf) zb36());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb36)");
    check_base_class_offset(lv, (si*)(sk11*), 0, "zb36");
    check_base_class_offset(lv, (sj*)(sk11*), 0, "zb36");
    check_base_class_offset(lv, (sk11*), 0, "zb36");
    check_base_class_offset(lv, (si*)(tk22*), ABISELECT(8,4), "zb36");
    check_base_class_offset(lv, (sj*)(tk22*), ABISELECT(8,4), "zb36");
    check_base_class_offset(lv, (tk22*), ABISELECT(8,4), "zb36");
    test_class_info(&lv, &cd_zb36);
    dp->~zb36();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb36(Test_zb36, "zb36", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb36C1Ev();
extern void _ZN4zb36D1Ev();
Name_Map name_map_zb36[] = {
  NSPAIR(_ZN4zb36C1Ev),
  NSPAIR(_ZN4zb36D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_zb36[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_tk22,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb36[];
static  VTBL_ENTRY vtc_zb36[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb36[0]),
};
extern VTBL_ENTRY _ZTV4zb36[];
static  VTBL_ENTRY _tg__ZTV4sk11__4zb36[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTT_ENTRY vtt_zb36[] = {
  {&(_ZTV4zb36[5]),  5,5},
  {&(_tg__ZTV4sk11__4zb36[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zb36[];
extern  VTBL_ENTRY _ZTV4zb36[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb36[];
Class_Descriptor cd_zb36 = {  "zb36", // class name
  bases_zb36, 6,
  &(vtc_zb36[0]), // expected_vtbl_contents
  &(vtt_zb36[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb36),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb36),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb36),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc36  : virtual sk11 , tk22 {
  ~zc36(); // tgen
  zc36(); // tgen
};
//SIG(1 zc36) C1{ VBC2{ VBC3{} VBC4{}} BC5{ BC3 BC4}}


zc36 ::~zc36(){ note_dtor("zc36", this);} // tgen
zc36 ::zc36(){ note_ctor("zc36", this);} // tgen

static void Test_zc36()
{
  extern Class_Descriptor cd_zc36;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc36, buf);
    zc36 *dp, &lv = *(dp=new (buf) zc36());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc36)");
    check_base_class_offset(lv, (si*)(sk11*), ABISELECT(8,4), "zc36");
    check_base_class_offset(lv, (sj*)(sk11*), ABISELECT(8,4), "zc36");
    check_base_class_offset(lv, (sk11*), 0, "zc36");
    check_base_class_offset(lv, (si*)(tk22*), 0, "zc36");
    check_base_class_offset(lv, (sj*)(tk22*), 0, "zc36");
    check_base_class_offset(lv, (tk22*), 0, "zc36");
    test_class_info(&lv, &cd_zc36);
    dp->~zc36();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc36(Test_zc36, "zc36", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc36C1Ev();
extern void _ZN4zc36D1Ev();
Name_Map name_map_zc36[] = {
  NSPAIR(_ZN4zc36C1Ev),
  NSPAIR(_ZN4zc36D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_zc36[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_tk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc36[];
static  VTBL_ENTRY vtc_zc36[] = {
  0,
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4zc36[0]),
};
extern VTBL_ENTRY _ZTV4zc36[];
static  VTBL_ENTRY _tg__ZTV4sk11__4zc36[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTT_ENTRY vtt_zc36[] = {
  {&(_ZTV4zc36[5]),  5,5},
  {&(_ZTV4zc36[5]),  5,5},
  {&(_tg__ZTV4sk11__4zc36[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zc36[];
extern  VTBL_ENTRY _ZTV4zc36[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc36[];
Class_Descriptor cd_zc36 = {  "zc36", // class name
  bases_zc36, 6,
  &(vtc_zc36[0]), // expected_vtbl_contents
  &(vtt_zc36[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc36),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc36),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc36),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd36  : virtual sk11 , virtual tk22 {
  ~zd36(); // tgen
  zd36(); // tgen
};
//SIG(1 zd36) C1{ VBC2{ VBC3{} VBC4{}} VBC5{ BC3 BC4}}


zd36 ::~zd36(){ note_dtor("zd36", this);} // tgen
zd36 ::zd36(){ note_ctor("zd36", this);} // tgen

static void Test_zd36()
{
  extern Class_Descriptor cd_zd36;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd36, buf);
    zd36 *dp, &lv = *(dp=new (buf) zd36());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd36)");
    check_base_class_offset(lv, (si*)(sk11*), 0, "zd36");
    check_base_class_offset(lv, (sj*)(sk11*), 0, "zd36");
    check_base_class_offset(lv, (sk11*), 0, "zd36");
    check_base_class_offset(lv, (si*)(tk22*), ABISELECT(8,4), "zd36");
    check_base_class_offset(lv, (sj*)(tk22*), ABISELECT(8,4), "zd36");
    check_base_class_offset(lv, (tk22*), ABISELECT(8,4), "zd36");
    test_class_info(&lv, &cd_zd36);
    dp->~zd36();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd36(Test_zd36, "zd36", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd36C1Ev();
extern void _ZN4zd36D1Ev();
Name_Map name_map_zd36[] = {
  NSPAIR(_ZN4zd36C1Ev),
  NSPAIR(_ZN4zd36D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk11;
extern VTBL_ENTRY _ZTI4sk11[];
extern  VTBL_ENTRY _ZTV4sk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk11[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_zd36[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_tk22,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd36[];
static  VTBL_ENTRY vtc_zd36[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd36[0]),
};
extern VTBL_ENTRY _ZTV4zd36[];
static  VTBL_ENTRY _tg__ZTV4sk11__4zd36[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk11[0]),
};
static  VTT_ENTRY vtt_zd36[] = {
  {&(_ZTV4zd36[6]),  6,6},
  {&(_ZTV4zd36[6]),  6,6},
  {&(_tg__ZTV4sk11__4zd36[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zd36[];
extern  VTBL_ENTRY _ZTV4zd36[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd36[];
Class_Descriptor cd_zd36 = {  "zd36", // class name
  bases_zd36, 6,
  &(vtc_zd36[0]), // expected_vtbl_contents
  &(vtt_zd36[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd36),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd36),6, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd36),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  xt4  : tk12 {
  ~xt4(); // tgen
  xt4(); // tgen
};
//SIG(1 xt4) C1{ BC2{ VBC3{} BC4{}}}


xt4 ::~xt4(){ note_dtor("xt4", this);} // tgen
xt4 ::xt4(){ note_ctor("xt4", this);} // tgen

static void Test_xt4()
{
  extern Class_Descriptor cd_xt4;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_xt4, buf);
    xt4 *dp, &lv = *(dp=new (buf) xt4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(xt4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(xt4)");
    check_base_class_offset(lv, (si*)(tk12*), 0, "xt4");
    check_base_class_offset(lv, (sj*)(tk12*), 0, "xt4");
    check_base_class_offset(lv, (tk12*), 0, "xt4");
    test_class_info(&lv, &cd_xt4);
    dp->~xt4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vxt4(Test_xt4, "xt4", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3xt4C1Ev();
extern void _ZN3xt4D1Ev();
Name_Map name_map_xt4[] = {
  NSPAIR(_ZN3xt4C1Ev),
  NSPAIR(_ZN3xt4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_xt4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_tk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3xt4[];
static  VTBL_ENTRY vtc_xt4[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI3xt4[0]),
};
extern VTBL_ENTRY _ZTV3xt4[];
static  VTBL_ENTRY _tg__ZTV4tk12__3xt4[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTT_ENTRY vtt_xt4[] = {
  {&(_ZTV3xt4[3]),  3,3},
  {&(_tg__ZTV4tk12__3xt4[3]),  3,3},
};
extern VTBL_ENTRY _ZTI3xt4[];
extern  VTBL_ENTRY _ZTV3xt4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3xt4[];
Class_Descriptor cd_xt4 = {  "xt4", // class name
  bases_xt4, 3,
  &(vtc_xt4[0]), // expected_vtbl_contents
  &(vtt_xt4[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI3xt4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV3xt4),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3xt4),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  yt4  : virtual tk12 {
  ~yt4(); // tgen
  yt4(); // tgen
};
//SIG(1 yt4) C1{ VBC2{ VBC3{} BC4{}}}


yt4 ::~yt4(){ note_dtor("yt4", this);} // tgen
yt4 ::yt4(){ note_ctor("yt4", this);} // tgen

static void Test_yt4()
{
  extern Class_Descriptor cd_yt4;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_yt4, buf);
    yt4 *dp, &lv = *(dp=new (buf) yt4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(yt4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(yt4)");
    check_base_class_offset(lv, (si*)(tk12*), 0, "yt4");
    check_base_class_offset(lv, (sj*)(tk12*), 0, "yt4");
    check_base_class_offset(lv, (tk12*), 0, "yt4");
    test_class_info(&lv, &cd_yt4);
    dp->~yt4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vyt4(Test_yt4, "yt4", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3yt4C1Ev();
extern void _ZN3yt4D1Ev();
Name_Map name_map_yt4[] = {
  NSPAIR(_ZN3yt4C1Ev),
  NSPAIR(_ZN3yt4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_yt4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_tk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3yt4[];
static  VTBL_ENTRY vtc_yt4[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI3yt4[0]),
};
extern VTBL_ENTRY _ZTV3yt4[];
static  VTBL_ENTRY _tg__ZTV4tk12__3yt4[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTT_ENTRY vtt_yt4[] = {
  {&(_ZTV3yt4[4]),  4,4},
  {&(_ZTV3yt4[4]),  4,4},
  {&(_tg__ZTV4tk12__3yt4[3]),  3,3},
};
extern VTBL_ENTRY _ZTI3yt4[];
extern  VTBL_ENTRY _ZTV3yt4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3yt4[];
Class_Descriptor cd_yt4 = {  "yt4", // class name
  bases_yt4, 3,
  &(vtc_yt4[0]), // expected_vtbl_contents
  &(vtt_yt4[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI3yt4),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV3yt4),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3yt4),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za40  : sk12 , tk00 {
  ~za40(); // tgen
  za40(); // tgen
};
//SIG(1 za40) C1{ BC2{ VBC3{} BC4{}} BC5{}}


za40 ::~za40(){ note_dtor("za40", this);} // tgen
za40 ::za40(){ note_ctor("za40", this);} // tgen

static void Test_za40()
{
  extern Class_Descriptor cd_za40;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_za40, buf);
    za40 *dp, &lv = *(dp=new (buf) za40());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(za40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za40)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "za40");
    check_base_class_offset(lv, (sj*)(sk12*), 0, "za40");
    check_base_class_offset(lv, (sk12*), 0, "za40");
    check_base_class_offset(lv, (tk00*), 0, "za40");
    test_class_info(&lv, &cd_za40);
    dp->~za40();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza40(Test_za40, "za40", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4za40C1Ev();
extern void _ZN4za40D1Ev();
Name_Map name_map_za40[] = {
  NSPAIR(_ZN4za40C1Ev),
  NSPAIR(_ZN4za40D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_za40[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za40[];
static  VTBL_ENTRY vtc_za40[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za40[0]),
};
extern VTBL_ENTRY _ZTV4za40[];
static  VTBL_ENTRY _tg__ZTV4sk12__4za40[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTT_ENTRY vtt_za40[] = {
  {&(_ZTV4za40[3]),  3,3},
  {&(_tg__ZTV4sk12__4za40[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4za40[];
extern  VTBL_ENTRY _ZTV4za40[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za40[];
Class_Descriptor cd_za40 = {  "za40", // class name
  bases_za40, 4,
  &(vtc_za40[0]), // expected_vtbl_contents
  &(vtt_za40[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4za40),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za40),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za40),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb40  : sk12 , virtual tk00 {
  ~zb40(); // tgen
  zb40(); // tgen
};
//SIG(1 zb40) C1{ BC2{ VBC3{} BC4{}} VBC5{}}


zb40 ::~zb40(){ note_dtor("zb40", this);} // tgen
zb40 ::zb40(){ note_ctor("zb40", this);} // tgen

static void Test_zb40()
{
  extern Class_Descriptor cd_zb40;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zb40, buf);
    zb40 *dp, &lv = *(dp=new (buf) zb40());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zb40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb40)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "zb40");
    check_base_class_offset(lv, (sj*)(sk12*), 0, "zb40");
    check_base_class_offset(lv, (sk12*), 0, "zb40");
    check_base_class_offset(lv, (tk00*), 0, "zb40");
    test_class_info(&lv, &cd_zb40);
    dp->~zb40();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb40(Test_zb40, "zb40", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zb40C1Ev();
extern void _ZN4zb40D1Ev();
Name_Map name_map_zb40[] = {
  NSPAIR(_ZN4zb40C1Ev),
  NSPAIR(_ZN4zb40D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_zb40[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb40[];
static  VTBL_ENTRY vtc_zb40[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb40[0]),
};
extern VTBL_ENTRY _ZTV4zb40[];
static  VTBL_ENTRY _tg__ZTV4sk12__4zb40[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTT_ENTRY vtt_zb40[] = {
  {&(_ZTV4zb40[4]),  4,4},
  {&(_tg__ZTV4sk12__4zb40[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb40[];
extern  VTBL_ENTRY _ZTV4zb40[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb40[];
Class_Descriptor cd_zb40 = {  "zb40", // class name
  bases_zb40, 4,
  &(vtc_zb40[0]), // expected_vtbl_contents
  &(vtt_zb40[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zb40),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb40),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb40),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc40  : virtual sk12 , tk00 {
  ~zc40(); // tgen
  zc40(); // tgen
};
//SIG(1 zc40) C1{ VBC2{ VBC3{} BC4{}} BC5{}}


zc40 ::~zc40(){ note_dtor("zc40", this);} // tgen
zc40 ::zc40(){ note_ctor("zc40", this);} // tgen

static void Test_zc40()
{
  extern Class_Descriptor cd_zc40;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zc40, buf);
    zc40 *dp, &lv = *(dp=new (buf) zc40());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zc40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc40)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "zc40");
    check_base_class_offset(lv, (sj*)(sk12*), 0, "zc40");
    check_base_class_offset(lv, (sk12*), 0, "zc40");
    check_base_class_offset(lv, (tk00*), 0, "zc40");
    test_class_info(&lv, &cd_zc40);
    dp->~zc40();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc40(Test_zc40, "zc40", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zc40C1Ev();
extern void _ZN4zc40D1Ev();
Name_Map name_map_zc40[] = {
  NSPAIR(_ZN4zc40C1Ev),
  NSPAIR(_ZN4zc40D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_zc40[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc40[];
static  VTBL_ENTRY vtc_zc40[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc40[0]),
};
extern VTBL_ENTRY _ZTV4zc40[];
static  VTBL_ENTRY _tg__ZTV4sk12__4zc40[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTT_ENTRY vtt_zc40[] = {
  {&(_ZTV4zc40[4]),  4,4},
  {&(_ZTV4zc40[4]),  4,4},
  {&(_tg__ZTV4sk12__4zc40[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc40[];
extern  VTBL_ENTRY _ZTV4zc40[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc40[];
Class_Descriptor cd_zc40 = {  "zc40", // class name
  bases_zc40, 4,
  &(vtc_zc40[0]), // expected_vtbl_contents
  &(vtt_zc40[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zc40),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc40),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc40),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd40  : virtual sk12 , virtual tk00 {
  ~zd40(); // tgen
  zd40(); // tgen
};
//SIG(1 zd40) C1{ VBC2{ VBC3{} BC4{}} VBC5{}}


zd40 ::~zd40(){ note_dtor("zd40", this);} // tgen
zd40 ::zd40(){ note_ctor("zd40", this);} // tgen

static void Test_zd40()
{
  extern Class_Descriptor cd_zd40;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zd40, buf);
    zd40 *dp, &lv = *(dp=new (buf) zd40());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zd40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd40)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "zd40");
    check_base_class_offset(lv, (sj*)(sk12*), 0, "zd40");
    check_base_class_offset(lv, (sk12*), 0, "zd40");
    check_base_class_offset(lv, (tk00*), 0, "zd40");
    test_class_info(&lv, &cd_zd40);
    dp->~zd40();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd40(Test_zd40, "zd40", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zd40C1Ev();
extern void _ZN4zd40D1Ev();
Name_Map name_map_zd40[] = {
  NSPAIR(_ZN4zd40C1Ev),
  NSPAIR(_ZN4zd40D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_zd40[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd40[];
static  VTBL_ENTRY vtc_zd40[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd40[0]),
};
extern VTBL_ENTRY _ZTV4zd40[];
static  VTBL_ENTRY _tg__ZTV4sk12__4zd40[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTT_ENTRY vtt_zd40[] = {
  {&(_ZTV4zd40[5]),  5,5},
  {&(_ZTV4zd40[5]),  5,5},
  {&(_tg__ZTV4sk12__4zd40[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd40[];
extern  VTBL_ENTRY _ZTV4zd40[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd40[];
Class_Descriptor cd_zd40 = {  "zd40", // class name
  bases_zd40, 4,
  &(vtc_zd40[0]), // expected_vtbl_contents
  &(vtt_zd40[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zd40),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd40),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd40),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za41  : sk12 , tk01 {
  ~za41(); // tgen
  za41(); // tgen
};
//SIG(1 za41) C1{ BC2{ VBC3{} BC4{}} BC5{ VBC4}}


za41 ::~za41(){ note_dtor("za41", this);} // tgen
za41 ::za41(){ note_ctor("za41", this);} // tgen

static void Test_za41()
{
  extern Class_Descriptor cd_za41;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_za41, buf);
    za41 *dp, &lv = *(dp=new (buf) za41());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(za41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za41)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "za41");
    check_base_class_offset(lv, (sj*)(sk12*), 0, "za41");
    check_base_class_offset(lv, (sk12*), 0, "za41");
    check_base_class_offset(lv, (sj*)(tk01*), ABISELECT(16,8), "za41");
    check_base_class_offset(lv, (tk01*), ABISELECT(8,4), "za41");
    test_class_info(&lv, &cd_za41);
    dp->~za41();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza41(Test_za41, "za41", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN4za41C1Ev();
extern void _ZN4za41D1Ev();
Name_Map name_map_za41[] = {
  NSPAIR(_ZN4za41C1Ev),
  NSPAIR(_ZN4za41D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_za41[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_tk01,    ABISELECT(8,4), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za41[];
static  VTBL_ENTRY vtc_za41[] = {
  ABISELECT(16,8),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za41[0]),
  ABISELECT(8,4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4za41[0]),
};
extern VTBL_ENTRY _ZTV4za41[];
static  VTBL_ENTRY _tg__ZTV4sk12__4za41[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk01__4za41[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTT_ENTRY vtt_za41[] = {
  {&(_ZTV4za41[4]),  4,7},
  {&(_tg__ZTV4sk12__4za41[3]),  3,3},
  {&(_tg__ZTV4tk01__4za41[3]),  3,3},
  {&(_ZTV4za41[7]),  7,7},
};
extern VTBL_ENTRY _ZTI4za41[];
extern  VTBL_ENTRY _ZTV4za41[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za41[];
Class_Descriptor cd_za41 = {  "za41", // class name
  bases_za41, 5,
  &(vtc_za41[0]), // expected_vtbl_contents
  &(vtt_za41[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI4za41),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za41),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za41),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb41  : sk12 , virtual tk01 {
  ~zb41(); // tgen
  zb41(); // tgen
};
//SIG(1 zb41) C1{ BC2{ VBC3{} BC4{}} VBC5{ VBC4}}


zb41 ::~zb41(){ note_dtor("zb41", this);} // tgen
zb41 ::zb41(){ note_ctor("zb41", this);} // tgen

static void Test_zb41()
{
  extern Class_Descriptor cd_zb41;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_zb41, buf);
    zb41 *dp, &lv = *(dp=new (buf) zb41());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(zb41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb41)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "zb41");
    check_base_class_offset(lv, (sj*)(sk12*), 0, "zb41");
    check_base_class_offset(lv, (sk12*), 0, "zb41");
    check_base_class_offset(lv, (sj*)(tk01*), ABISELECT(16,8), "zb41");
    check_base_class_offset(lv, (tk01*), ABISELECT(8,4), "zb41");
    test_class_info(&lv, &cd_zb41);
    dp->~zb41();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb41(Test_zb41, "zb41", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN4zb41C1Ev();
extern void _ZN4zb41D1Ev();
Name_Map name_map_zb41[] = {
  NSPAIR(_ZN4zb41C1Ev),
  NSPAIR(_ZN4zb41D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_zb41[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_tk01,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb41[];
static  VTBL_ENTRY vtc_zb41[] = {
  ABISELECT(16,8),
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb41[0]),
  ABISELECT(8,4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zb41[0]),
};
extern VTBL_ENTRY _ZTV4zb41[];
static  VTBL_ENTRY _tg__ZTV4sk12__4zb41[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk01__4zb41[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTT_ENTRY vtt_zb41[] = {
  {&(_ZTV4zb41[5]),  5,8},
  {&(_tg__ZTV4sk12__4zb41[3]),  3,3},
  {&(_ZTV4zb41[8]),  8,8},
  {&(_tg__ZTV4tk01__4zb41[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb41[];
extern  VTBL_ENTRY _ZTV4zb41[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb41[];
Class_Descriptor cd_zb41 = {  "zb41", // class name
  bases_zb41, 5,
  &(vtc_zb41[0]), // expected_vtbl_contents
  &(vtt_zb41[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI4zb41),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb41),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb41),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc41  : virtual sk12 , tk01 {
  ~zc41(); // tgen
  zc41(); // tgen
};
//SIG(1 zc41) C1{ VBC2{ VBC3{} BC4{}} BC5{ VBC4}}


zc41 ::~zc41(){ note_dtor("zc41", this);} // tgen
zc41 ::zc41(){ note_ctor("zc41", this);} // tgen

static void Test_zc41()
{
  extern Class_Descriptor cd_zc41;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc41, buf);
    zc41 *dp, &lv = *(dp=new (buf) zc41());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc41)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "zc41");
    check_base_class_offset(lv, (sj*)(sk12*), ABISELECT(8,4), "zc41");
    check_base_class_offset(lv, (sk12*), ABISELECT(8,4), "zc41");
    check_base_class_offset(lv, (sj*)(tk01*), 0, "zc41");
    check_base_class_offset(lv, (tk01*), 0, "zc41");
    test_class_info(&lv, &cd_zc41);
    dp->~zc41();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc41(Test_zc41, "zc41", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc41C1Ev();
extern void _ZN4zc41D1Ev();
Name_Map name_map_zc41[] = {
  NSPAIR(_ZN4zc41C1Ev),
  NSPAIR(_ZN4zc41D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_zc41[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_tk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc41[];
static  VTBL_ENTRY vtc_zc41[] = {
  0,
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc41[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zc41[0]),
};
extern VTBL_ENTRY _ZTV4zc41[];
static  VTBL_ENTRY _tg__ZTV4tk01__4zc41[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTBL_ENTRY _tg__ZTV4sk12__4zc41[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTT_ENTRY vtt_zc41[] = {
  {&(_ZTV4zc41[5]),  5,8},
  {&(_tg__ZTV4tk01__4zc41[3]),  3,3},
  {&(_ZTV4zc41[8]),  8,8},
  {&(_tg__ZTV4sk12__4zc41[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc41[];
extern  VTBL_ENTRY _ZTV4zc41[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc41[];
Class_Descriptor cd_zc41 = {  "zc41", // class name
  bases_zc41, 5,
  &(vtc_zc41[0]), // expected_vtbl_contents
  &(vtt_zc41[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc41),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc41),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc41),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd41  : virtual sk12 , virtual tk01 {
  ~zd41(); // tgen
  zd41(); // tgen
};
//SIG(1 zd41) C1{ VBC2{ VBC3{} BC4{}} VBC5{ VBC4}}


zd41 ::~zd41(){ note_dtor("zd41", this);} // tgen
zd41 ::zd41(){ note_ctor("zd41", this);} // tgen

static void Test_zd41()
{
  extern Class_Descriptor cd_zd41;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_zd41, buf);
    zd41 *dp, &lv = *(dp=new (buf) zd41());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(zd41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd41)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "zd41");
    check_base_class_offset(lv, (sj*)(sk12*), 0, "zd41");
    check_base_class_offset(lv, (sk12*), 0, "zd41");
    check_base_class_offset(lv, (sj*)(tk01*), ABISELECT(16,8), "zd41");
    check_base_class_offset(lv, (tk01*), ABISELECT(8,4), "zd41");
    test_class_info(&lv, &cd_zd41);
    dp->~zd41();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd41(Test_zd41, "zd41", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN4zd41C1Ev();
extern void _ZN4zd41D1Ev();
Name_Map name_map_zd41[] = {
  NSPAIR(_ZN4zd41C1Ev),
  NSPAIR(_ZN4zd41D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_zd41[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_tk01,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd41[];
static  VTBL_ENTRY vtc_zd41[] = {
  ABISELECT(16,8),
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd41[0]),
  ABISELECT(8,4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zd41[0]),
};
extern VTBL_ENTRY _ZTV4zd41[];
static  VTBL_ENTRY _tg__ZTV4sk12__4zd41[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk01__4zd41[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTT_ENTRY vtt_zd41[] = {
  {&(_ZTV4zd41[6]),  6,9},
  {&(_ZTV4zd41[6]),  6,9},
  {&(_ZTV4zd41[9]),  9,9},
  {&(_tg__ZTV4sk12__4zd41[3]),  3,3},
  {&(_tg__ZTV4tk01__4zd41[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd41[];
extern  VTBL_ENTRY _ZTV4zd41[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd41[];
Class_Descriptor cd_zd41 = {  "zd41", // class name
  bases_zd41, 5,
  &(vtc_zd41[0]), // expected_vtbl_contents
  &(vtt_zd41[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI4zd41),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd41),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd41),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za42  : sk12 , tk02 {
  ~za42(); // tgen
  za42(); // tgen
};
//SIG(1 za42) C1{ BC2{ VBC3{} BC4{}} BC5{ BC4}}


za42 ::~za42(){ note_dtor("za42", this);} // tgen
za42 ::za42(){ note_ctor("za42", this);} // tgen

static void Test_za42()
{
  extern Class_Descriptor cd_za42;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za42, buf);
    za42 *dp, &lv = *(dp=new (buf) za42());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za42)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "za42");
    check_base_class_offset(lv, (sj*)(sk12*), 0, "za42");
    check_base_class_offset(lv, (sk12*), 0, "za42");
    check_base_class_offset(lv, (sj*)(tk02*), ABISELECT(8,4), "za42");
    check_base_class_offset(lv, (tk02*), ABISELECT(8,4), "za42");
    test_class_info(&lv, &cd_za42);
    dp->~za42();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza42(Test_za42, "za42", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za42C1Ev();
extern void _ZN4za42D1Ev();
Name_Map name_map_za42[] = {
  NSPAIR(_ZN4za42C1Ev),
  NSPAIR(_ZN4za42D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_za42[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk02,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za42[];
static  VTBL_ENTRY vtc_za42[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za42[0]),
};
extern VTBL_ENTRY _ZTV4za42[];
static  VTBL_ENTRY _tg__ZTV4sk12__4za42[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTT_ENTRY vtt_za42[] = {
  {&(_ZTV4za42[3]),  3,3},
  {&(_tg__ZTV4sk12__4za42[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4za42[];
extern  VTBL_ENTRY _ZTV4za42[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za42[];
Class_Descriptor cd_za42 = {  "za42", // class name
  bases_za42, 5,
  &(vtc_za42[0]), // expected_vtbl_contents
  &(vtt_za42[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za42),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za42),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za42),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb42  : sk12 , virtual tk02 {
  ~zb42(); // tgen
  zb42(); // tgen
};
//SIG(1 zb42) C1{ BC2{ VBC3{} BC4{}} VBC5{ BC4}}


zb42 ::~zb42(){ note_dtor("zb42", this);} // tgen
zb42 ::zb42(){ note_ctor("zb42", this);} // tgen

static void Test_zb42()
{
  extern Class_Descriptor cd_zb42;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb42, buf);
    zb42 *dp, &lv = *(dp=new (buf) zb42());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb42)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "zb42");
    check_base_class_offset(lv, (sj*)(sk12*), 0, "zb42");
    check_base_class_offset(lv, (sk12*), 0, "zb42");
    check_base_class_offset(lv, (sj*)(tk02*), ABISELECT(8,4), "zb42");
    check_base_class_offset(lv, (tk02*), ABISELECT(8,4), "zb42");
    test_class_info(&lv, &cd_zb42);
    dp->~zb42();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb42(Test_zb42, "zb42", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb42C1Ev();
extern void _ZN4zb42D1Ev();
Name_Map name_map_zb42[] = {
  NSPAIR(_ZN4zb42C1Ev),
  NSPAIR(_ZN4zb42D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_zb42[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk02,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb42[];
static  VTBL_ENTRY vtc_zb42[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb42[0]),
};
extern VTBL_ENTRY _ZTV4zb42[];
static  VTBL_ENTRY _tg__ZTV4sk12__4zb42[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTT_ENTRY vtt_zb42[] = {
  {&(_ZTV4zb42[4]),  4,4},
  {&(_tg__ZTV4sk12__4zb42[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb42[];
extern  VTBL_ENTRY _ZTV4zb42[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb42[];
Class_Descriptor cd_zb42 = {  "zb42", // class name
  bases_zb42, 5,
  &(vtc_zb42[0]), // expected_vtbl_contents
  &(vtt_zb42[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb42),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb42),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb42),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc42  : virtual sk12 , tk02 {
  ~zc42(); // tgen
  zc42(); // tgen
};
//SIG(1 zc42) C1{ VBC2{ VBC3{} BC4{}} BC5{ BC4}}


zc42 ::~zc42(){ note_dtor("zc42", this);} // tgen
zc42 ::zc42(){ note_ctor("zc42", this);} // tgen

static void Test_zc42()
{
  extern Class_Descriptor cd_zc42;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc42, buf);
    zc42 *dp, &lv = *(dp=new (buf) zc42());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc42)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "zc42");
    check_base_class_offset(lv, (sj*)(sk12*), 0, "zc42");
    check_base_class_offset(lv, (sk12*), 0, "zc42");
    check_base_class_offset(lv, (sj*)(tk02*), ABISELECT(8,4), "zc42");
    check_base_class_offset(lv, (tk02*), ABISELECT(8,4), "zc42");
    test_class_info(&lv, &cd_zc42);
    dp->~zc42();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc42(Test_zc42, "zc42", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc42C1Ev();
extern void _ZN4zc42D1Ev();
Name_Map name_map_zc42[] = {
  NSPAIR(_ZN4zc42C1Ev),
  NSPAIR(_ZN4zc42D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_zc42[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk02,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc42[];
static  VTBL_ENTRY vtc_zc42[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc42[0]),
};
extern VTBL_ENTRY _ZTV4zc42[];
static  VTBL_ENTRY _tg__ZTV4sk12__4zc42[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTT_ENTRY vtt_zc42[] = {
  {&(_ZTV4zc42[4]),  4,4},
  {&(_ZTV4zc42[4]),  4,4},
  {&(_tg__ZTV4sk12__4zc42[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc42[];
extern  VTBL_ENTRY _ZTV4zc42[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc42[];
Class_Descriptor cd_zc42 = {  "zc42", // class name
  bases_zc42, 5,
  &(vtc_zc42[0]), // expected_vtbl_contents
  &(vtt_zc42[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc42),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc42),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc42),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd42  : virtual sk12 , virtual tk02 {
  ~zd42(); // tgen
  zd42(); // tgen
};
//SIG(1 zd42) C1{ VBC2{ VBC3{} BC4{}} VBC5{ BC4}}


zd42 ::~zd42(){ note_dtor("zd42", this);} // tgen
zd42 ::zd42(){ note_ctor("zd42", this);} // tgen

static void Test_zd42()
{
  extern Class_Descriptor cd_zd42;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd42, buf);
    zd42 *dp, &lv = *(dp=new (buf) zd42());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd42)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "zd42");
    check_base_class_offset(lv, (sj*)(sk12*), 0, "zd42");
    check_base_class_offset(lv, (sk12*), 0, "zd42");
    check_base_class_offset(lv, (sj*)(tk02*), ABISELECT(8,4), "zd42");
    check_base_class_offset(lv, (tk02*), ABISELECT(8,4), "zd42");
    test_class_info(&lv, &cd_zd42);
    dp->~zd42();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd42(Test_zd42, "zd42", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd42C1Ev();
extern void _ZN4zd42D1Ev();
Name_Map name_map_zd42[] = {
  NSPAIR(_ZN4zd42C1Ev),
  NSPAIR(_ZN4zd42D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_zd42[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk02,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd42[];
static  VTBL_ENTRY vtc_zd42[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd42[0]),
};
extern VTBL_ENTRY _ZTV4zd42[];
static  VTBL_ENTRY _tg__ZTV4sk12__4zd42[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTT_ENTRY vtt_zd42[] = {
  {&(_ZTV4zd42[5]),  5,5},
  {&(_ZTV4zd42[5]),  5,5},
  {&(_tg__ZTV4sk12__4zd42[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd42[];
extern  VTBL_ENTRY _ZTV4zd42[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd42[];
Class_Descriptor cd_zd42 = {  "zd42", // class name
  bases_zd42, 5,
  &(vtc_zd42[0]), // expected_vtbl_contents
  &(vtt_zd42[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd42),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd42),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd42),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za43  : sk12 , tk11 {
  ~za43(); // tgen
  za43(); // tgen
};
//SIG(1 za43) C1{ BC2{ VBC3{} BC4{}} BC5{ VBC3 VBC4}}


za43 ::~za43(){ note_dtor("za43", this);} // tgen
za43 ::za43(){ note_ctor("za43", this);} // tgen

static void Test_za43()
{
  extern Class_Descriptor cd_za43;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_za43, buf);
    za43 *dp, &lv = *(dp=new (buf) za43());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(za43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za43)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "za43");
    check_base_class_offset(lv, (si*)(tk11*), 0, "za43");
    check_base_class_offset(lv, (sj*)(sk12*), 0, "za43");
    check_base_class_offset(lv, (sk12*), 0, "za43");
    check_base_class_offset(lv, (sj*)(tk11*), ABISELECT(16,8), "za43");
    check_base_class_offset(lv, (tk11*), ABISELECT(8,4), "za43");
    test_class_info(&lv, &cd_za43);
    dp->~za43();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza43(Test_za43, "za43", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN4za43C1Ev();
extern void _ZN4za43D1Ev();
Name_Map name_map_za43[] = {
  NSPAIR(_ZN4za43C1Ev),
  NSPAIR(_ZN4za43D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_za43[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_tk11,    ABISELECT(8,4), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za43[];
static  VTBL_ENTRY vtc_za43[] = {
  ABISELECT(16,8),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za43[0]),
  ABISELECT(8,4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4za43[0]),
};
extern VTBL_ENTRY _ZTV4za43[];
static  VTBL_ENTRY _tg__ZTV4sk12__4za43[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk11__4za43[] = {
  ABISELECT(8,4),
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTT_ENTRY vtt_za43[] = {
  {&(_ZTV4za43[4]),  4,8},
  {&(_tg__ZTV4sk12__4za43[3]),  3,3},
  {&(_tg__ZTV4tk11__4za43[4]),  4,4},
  {&(_ZTV4za43[8]),  8,8},
};
extern VTBL_ENTRY _ZTI4za43[];
extern  VTBL_ENTRY _ZTV4za43[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za43[];
Class_Descriptor cd_za43 = {  "za43", // class name
  bases_za43, 5,
  &(vtc_za43[0]), // expected_vtbl_contents
  &(vtt_za43[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI4za43),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za43),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za43),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb43  : sk12 , virtual tk11 {
  ~zb43(); // tgen
  zb43(); // tgen
};
//SIG(1 zb43) C1{ BC2{ VBC3{} BC4{}} VBC5{ VBC3 VBC4}}


zb43 ::~zb43(){ note_dtor("zb43", this);} // tgen
zb43 ::zb43(){ note_ctor("zb43", this);} // tgen

static void Test_zb43()
{
  extern Class_Descriptor cd_zb43;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_zb43, buf);
    zb43 *dp, &lv = *(dp=new (buf) zb43());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(zb43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb43)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "zb43");
    check_base_class_offset(lv, (si*)(tk11*), 0, "zb43");
    check_base_class_offset(lv, (sj*)(sk12*), 0, "zb43");
    check_base_class_offset(lv, (sk12*), 0, "zb43");
    check_base_class_offset(lv, (sj*)(tk11*), ABISELECT(16,8), "zb43");
    check_base_class_offset(lv, (tk11*), ABISELECT(8,4), "zb43");
    test_class_info(&lv, &cd_zb43);
    dp->~zb43();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb43(Test_zb43, "zb43", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN4zb43C1Ev();
extern void _ZN4zb43D1Ev();
Name_Map name_map_zb43[] = {
  NSPAIR(_ZN4zb43C1Ev),
  NSPAIR(_ZN4zb43D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_zb43[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_tk11,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb43[];
static  VTBL_ENTRY vtc_zb43[] = {
  ABISELECT(16,8),
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb43[0]),
  ABISELECT(8,4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zb43[0]),
};
extern VTBL_ENTRY _ZTV4zb43[];
static  VTBL_ENTRY _tg__ZTV4sk12__4zb43[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk11__4zb43[] = {
  ABISELECT(8,4),
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTT_ENTRY vtt_zb43[] = {
  {&(_ZTV4zb43[5]),  5,9},
  {&(_tg__ZTV4sk12__4zb43[3]),  3,3},
  {&(_ZTV4zb43[9]),  9,9},
  {&(_tg__ZTV4tk11__4zb43[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zb43[];
extern  VTBL_ENTRY _ZTV4zb43[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb43[];
Class_Descriptor cd_zb43 = {  "zb43", // class name
  bases_zb43, 5,
  &(vtc_zb43[0]), // expected_vtbl_contents
  &(vtt_zb43[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI4zb43),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb43),9, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb43),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc43  : virtual sk12 , tk11 {
  ~zc43(); // tgen
  zc43(); // tgen
};
//SIG(1 zc43) C1{ VBC2{ VBC3{} BC4{}} BC5{ VBC3 VBC4}}


zc43 ::~zc43(){ note_dtor("zc43", this);} // tgen
zc43 ::zc43(){ note_ctor("zc43", this);} // tgen

static void Test_zc43()
{
  extern Class_Descriptor cd_zc43;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc43, buf);
    zc43 *dp, &lv = *(dp=new (buf) zc43());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc43)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "zc43");
    check_base_class_offset(lv, (si*)(tk11*), 0, "zc43");
    check_base_class_offset(lv, (sj*)(sk12*), ABISELECT(8,4), "zc43");
    check_base_class_offset(lv, (sk12*), ABISELECT(8,4), "zc43");
    check_base_class_offset(lv, (sj*)(tk11*), 0, "zc43");
    check_base_class_offset(lv, (tk11*), 0, "zc43");
    test_class_info(&lv, &cd_zc43);
    dp->~zc43();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc43(Test_zc43, "zc43", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc43C1Ev();
extern void _ZN4zc43D1Ev();
Name_Map name_map_zc43[] = {
  NSPAIR(_ZN4zc43C1Ev),
  NSPAIR(_ZN4zc43D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_zc43[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_tk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc43[];
static  VTBL_ENTRY vtc_zc43[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc43[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zc43[0]),
};
extern VTBL_ENTRY _ZTV4zc43[];
static  VTBL_ENTRY _tg__ZTV4tk11__4zc43[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTBL_ENTRY _tg__ZTV4sk12__4zc43[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTT_ENTRY vtt_zc43[] = {
  {&(_ZTV4zc43[5]),  5,8},
  {&(_tg__ZTV4tk11__4zc43[4]),  4,4},
  {&(_ZTV4zc43[8]),  8,8},
  {&(_tg__ZTV4sk12__4zc43[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc43[];
extern  VTBL_ENTRY _ZTV4zc43[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc43[];
Class_Descriptor cd_zc43 = {  "zc43", // class name
  bases_zc43, 5,
  &(vtc_zc43[0]), // expected_vtbl_contents
  &(vtt_zc43[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc43),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc43),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc43),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd43  : virtual sk12 , virtual tk11 {
  ~zd43(); // tgen
  zd43(); // tgen
};
//SIG(1 zd43) C1{ VBC2{ VBC3{} BC4{}} VBC5{ VBC3 VBC4}}


zd43 ::~zd43(){ note_dtor("zd43", this);} // tgen
zd43 ::zd43(){ note_ctor("zd43", this);} // tgen

static void Test_zd43()
{
  extern Class_Descriptor cd_zd43;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_zd43, buf);
    zd43 *dp, &lv = *(dp=new (buf) zd43());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(zd43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd43)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "zd43");
    check_base_class_offset(lv, (si*)(tk11*), 0, "zd43");
    check_base_class_offset(lv, (sj*)(sk12*), 0, "zd43");
    check_base_class_offset(lv, (sk12*), 0, "zd43");
    check_base_class_offset(lv, (sj*)(tk11*), ABISELECT(16,8), "zd43");
    check_base_class_offset(lv, (tk11*), ABISELECT(8,4), "zd43");
    test_class_info(&lv, &cd_zd43);
    dp->~zd43();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd43(Test_zd43, "zd43", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN4zd43C1Ev();
extern void _ZN4zd43D1Ev();
Name_Map name_map_zd43[] = {
  NSPAIR(_ZN4zd43C1Ev),
  NSPAIR(_ZN4zd43D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_zd43[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_tk11,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd43[];
static  VTBL_ENTRY vtc_zd43[] = {
  ABISELECT(16,8),
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd43[0]),
  ABISELECT(8,4),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zd43[0]),
};
extern VTBL_ENTRY _ZTV4zd43[];
static  VTBL_ENTRY _tg__ZTV4sk12__4zd43[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk11__4zd43[] = {
  ABISELECT(8,4),
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTT_ENTRY vtt_zd43[] = {
  {&(_ZTV4zd43[6]),  6,10},
  {&(_ZTV4zd43[6]),  6,10},
  {&(_ZTV4zd43[10]),  10,10},
  {&(_tg__ZTV4sk12__4zd43[3]),  3,3},
  {&(_tg__ZTV4tk11__4zd43[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zd43[];
extern  VTBL_ENTRY _ZTV4zd43[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd43[];
Class_Descriptor cd_zd43 = {  "zd43", // class name
  bases_zd43, 5,
  &(vtc_zd43[0]), // expected_vtbl_contents
  &(vtt_zd43[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI4zd43),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd43),10, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd43),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za44  : sk12 , tk12 {
  ~za44(); // tgen
  za44(); // tgen
};
//SIG(1 za44) C1{ BC2{ VBC3{} BC4{}} BC5{ VBC3 BC4}}


za44 ::~za44(){ note_dtor("za44", this);} // tgen
za44 ::za44(){ note_ctor("za44", this);} // tgen

static void Test_za44()
{
  extern Class_Descriptor cd_za44;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za44, buf);
    za44 *dp, &lv = *(dp=new (buf) za44());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za44)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za44)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "za44");
    check_base_class_offset(lv, (si*)(tk12*), 0, "za44");
    check_base_class_offset(lv, (sj*)(sk12*), 0, "za44");
    check_base_class_offset(lv, (sk12*), 0, "za44");
    check_base_class_offset(lv, (sj*)(tk12*), ABISELECT(8,4), "za44");
    check_base_class_offset(lv, (tk12*), ABISELECT(8,4), "za44");
    test_class_info(&lv, &cd_za44);
    dp->~za44();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza44(Test_za44, "za44", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za44C1Ev();
extern void _ZN4za44D1Ev();
Name_Map name_map_za44[] = {
  NSPAIR(_ZN4za44C1Ev),
  NSPAIR(_ZN4za44D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_za44[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk12,    ABISELECT(8,4), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za44[];
static  VTBL_ENTRY vtc_za44[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za44[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4za44[0]),
};
extern VTBL_ENTRY _ZTV4za44[];
static  VTBL_ENTRY _tg__ZTV4sk12__4za44[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk12__4za44[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTT_ENTRY vtt_za44[] = {
  {&(_ZTV4za44[3]),  3,6},
  {&(_tg__ZTV4sk12__4za44[3]),  3,3},
  {&(_tg__ZTV4tk12__4za44[3]),  3,3},
  {&(_ZTV4za44[6]),  6,6},
};
extern VTBL_ENTRY _ZTI4za44[];
extern  VTBL_ENTRY _ZTV4za44[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za44[];
Class_Descriptor cd_za44 = {  "za44", // class name
  bases_za44, 5,
  &(vtc_za44[0]), // expected_vtbl_contents
  &(vtt_za44[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za44),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za44),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za44),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb44  : sk12 , virtual tk12 {
  ~zb44(); // tgen
  zb44(); // tgen
};
//SIG(1 zb44) C1{ BC2{ VBC3{} BC4{}} VBC5{ VBC3 BC4}}


zb44 ::~zb44(){ note_dtor("zb44", this);} // tgen
zb44 ::zb44(){ note_ctor("zb44", this);} // tgen

static void Test_zb44()
{
  extern Class_Descriptor cd_zb44;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb44, buf);
    zb44 *dp, &lv = *(dp=new (buf) zb44());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb44)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb44)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "zb44");
    check_base_class_offset(lv, (si*)(tk12*), 0, "zb44");
    check_base_class_offset(lv, (sj*)(sk12*), 0, "zb44");
    check_base_class_offset(lv, (sk12*), 0, "zb44");
    check_base_class_offset(lv, (sj*)(tk12*), ABISELECT(8,4), "zb44");
    check_base_class_offset(lv, (tk12*), ABISELECT(8,4), "zb44");
    test_class_info(&lv, &cd_zb44);
    dp->~zb44();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb44(Test_zb44, "zb44", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb44C1Ev();
extern void _ZN4zb44D1Ev();
Name_Map name_map_zb44[] = {
  NSPAIR(_ZN4zb44C1Ev),
  NSPAIR(_ZN4zb44D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_zb44[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk12,    ABISELECT(8,4), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb44[];
static  VTBL_ENTRY vtc_zb44[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb44[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zb44[0]),
};
extern VTBL_ENTRY _ZTV4zb44[];
static  VTBL_ENTRY _tg__ZTV4sk12__4zb44[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk12__4zb44[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTT_ENTRY vtt_zb44[] = {
  {&(_ZTV4zb44[4]),  4,7},
  {&(_tg__ZTV4sk12__4zb44[3]),  3,3},
  {&(_ZTV4zb44[7]),  7,7},
  {&(_tg__ZTV4tk12__4zb44[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb44[];
extern  VTBL_ENTRY _ZTV4zb44[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb44[];
Class_Descriptor cd_zb44 = {  "zb44", // class name
  bases_zb44, 5,
  &(vtc_zb44[0]), // expected_vtbl_contents
  &(vtt_zb44[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb44),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb44),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb44),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc44  : virtual sk12 , tk12 {
  ~zc44(); // tgen
  zc44(); // tgen
};
//SIG(1 zc44) C1{ VBC2{ VBC3{} BC4{}} BC5{ VBC3 BC4}}


zc44 ::~zc44(){ note_dtor("zc44", this);} // tgen
zc44 ::zc44(){ note_ctor("zc44", this);} // tgen

static void Test_zc44()
{
  extern Class_Descriptor cd_zc44;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc44, buf);
    zc44 *dp, &lv = *(dp=new (buf) zc44());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc44)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc44)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "zc44");
    check_base_class_offset(lv, (si*)(tk12*), 0, "zc44");
    check_base_class_offset(lv, (sj*)(sk12*), ABISELECT(8,4), "zc44");
    check_base_class_offset(lv, (sk12*), ABISELECT(8,4), "zc44");
    check_base_class_offset(lv, (sj*)(tk12*), 0, "zc44");
    check_base_class_offset(lv, (tk12*), 0, "zc44");
    test_class_info(&lv, &cd_zc44);
    dp->~zc44();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc44(Test_zc44, "zc44", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc44C1Ev();
extern void _ZN4zc44D1Ev();
Name_Map name_map_zc44[] = {
  NSPAIR(_ZN4zc44C1Ev),
  NSPAIR(_ZN4zc44D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_zc44[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    ABISELECT(8,4), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc44[];
static  VTBL_ENTRY vtc_zc44[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc44[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zc44[0]),
};
extern VTBL_ENTRY _ZTV4zc44[];
static  VTBL_ENTRY _tg__ZTV4tk12__4zc44[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTBL_ENTRY _tg__ZTV4sk12__4zc44[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTT_ENTRY vtt_zc44[] = {
  {&(_ZTV4zc44[4]),  4,7},
  {&(_tg__ZTV4tk12__4zc44[3]),  3,3},
  {&(_ZTV4zc44[7]),  7,7},
  {&(_tg__ZTV4sk12__4zc44[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc44[];
extern  VTBL_ENTRY _ZTV4zc44[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc44[];
Class_Descriptor cd_zc44 = {  "zc44", // class name
  bases_zc44, 5,
  &(vtc_zc44[0]), // expected_vtbl_contents
  &(vtt_zc44[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc44),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc44),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc44),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd44  : virtual sk12 , virtual tk12 {
  ~zd44(); // tgen
  zd44(); // tgen
};
//SIG(1 zd44) C1{ VBC2{ VBC3{} BC4{}} VBC5{ VBC3 BC4}}


zd44 ::~zd44(){ note_dtor("zd44", this);} // tgen
zd44 ::zd44(){ note_ctor("zd44", this);} // tgen

static void Test_zd44()
{
  extern Class_Descriptor cd_zd44;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd44, buf);
    zd44 *dp, &lv = *(dp=new (buf) zd44());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd44)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd44)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "zd44");
    check_base_class_offset(lv, (si*)(tk12*), 0, "zd44");
    check_base_class_offset(lv, (sj*)(sk12*), 0, "zd44");
    check_base_class_offset(lv, (sk12*), 0, "zd44");
    check_base_class_offset(lv, (sj*)(tk12*), ABISELECT(8,4), "zd44");
    check_base_class_offset(lv, (tk12*), ABISELECT(8,4), "zd44");
    test_class_info(&lv, &cd_zd44);
    dp->~zd44();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd44(Test_zd44, "zd44", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd44C1Ev();
extern void _ZN4zd44D1Ev();
Name_Map name_map_zd44[] = {
  NSPAIR(_ZN4zd44C1Ev),
  NSPAIR(_ZN4zd44D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_zd44[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk12,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd44[];
static  VTBL_ENTRY vtc_zd44[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd44[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zd44[0]),
};
extern VTBL_ENTRY _ZTV4zd44[];
static  VTBL_ENTRY _tg__ZTV4sk12__4zd44[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk12__4zd44[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTT_ENTRY vtt_zd44[] = {
  {&(_ZTV4zd44[5]),  5,8},
  {&(_ZTV4zd44[5]),  5,8},
  {&(_ZTV4zd44[8]),  8,8},
  {&(_tg__ZTV4sk12__4zd44[3]),  3,3},
  {&(_tg__ZTV4tk12__4zd44[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd44[];
extern  VTBL_ENTRY _ZTV4zd44[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd44[];
Class_Descriptor cd_zd44 = {  "zd44", // class name
  bases_zd44, 5,
  &(vtc_zd44[0]), // expected_vtbl_contents
  &(vtt_zd44[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd44),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd44),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd44),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za45  : sk12 , tk21 {
  ~za45(); // tgen
  za45(); // tgen
};
//SIG(1 za45) C1{ BC2{ VBC3{} BC4{}} BC5{ BC3 VBC4}}


za45 ::~za45(){ note_dtor("za45", this);} // tgen
za45 ::za45(){ note_ctor("za45", this);} // tgen

static void Test_za45()
{
  extern Class_Descriptor cd_za45;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_za45, buf);
    za45 *dp, &lv = *(dp=new (buf) za45());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(za45)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za45)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "za45");
    check_base_class_offset(lv, (sj*)(sk12*), 0, "za45");
    check_base_class_offset(lv, (sk12*), 0, "za45");
    check_base_class_offset(lv, (si*)(tk21*), ABISELECT(8,4), "za45");
    check_base_class_offset(lv, (sj*)(tk21*), ABISELECT(16,8), "za45");
    check_base_class_offset(lv, (tk21*), ABISELECT(8,4), "za45");
    test_class_info(&lv, &cd_za45);
    dp->~za45();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza45(Test_za45, "za45", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN4za45C1Ev();
extern void _ZN4za45D1Ev();
Name_Map name_map_za45[] = {
  NSPAIR(_ZN4za45C1Ev),
  NSPAIR(_ZN4za45D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_za45[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_tk21,    ABISELECT(8,4), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za45[];
static  VTBL_ENTRY vtc_za45[] = {
  ABISELECT(16,8),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za45[0]),
  ABISELECT(8,4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4za45[0]),
};
extern VTBL_ENTRY _ZTV4za45[];
static  VTBL_ENTRY _tg__ZTV4sk12__4za45[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk21__4za45[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTT_ENTRY vtt_za45[] = {
  {&(_ZTV4za45[4]),  4,7},
  {&(_tg__ZTV4sk12__4za45[3]),  3,3},
  {&(_tg__ZTV4tk21__4za45[3]),  3,3},
  {&(_ZTV4za45[7]),  7,7},
};
extern VTBL_ENTRY _ZTI4za45[];
extern  VTBL_ENTRY _ZTV4za45[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za45[];
Class_Descriptor cd_za45 = {  "za45", // class name
  bases_za45, 6,
  &(vtc_za45[0]), // expected_vtbl_contents
  &(vtt_za45[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI4za45),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za45),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za45),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb45  : sk12 , virtual tk21 {
  ~zb45(); // tgen
  zb45(); // tgen
};
//SIG(1 zb45) C1{ BC2{ VBC3{} BC4{}} VBC5{ BC3 VBC4}}


zb45 ::~zb45(){ note_dtor("zb45", this);} // tgen
zb45 ::zb45(){ note_ctor("zb45", this);} // tgen

static void Test_zb45()
{
  extern Class_Descriptor cd_zb45;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_zb45, buf);
    zb45 *dp, &lv = *(dp=new (buf) zb45());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(zb45)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb45)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "zb45");
    check_base_class_offset(lv, (sj*)(sk12*), 0, "zb45");
    check_base_class_offset(lv, (sk12*), 0, "zb45");
    check_base_class_offset(lv, (si*)(tk21*), ABISELECT(8,4), "zb45");
    check_base_class_offset(lv, (sj*)(tk21*), ABISELECT(16,8), "zb45");
    check_base_class_offset(lv, (tk21*), ABISELECT(8,4), "zb45");
    test_class_info(&lv, &cd_zb45);
    dp->~zb45();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb45(Test_zb45, "zb45", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN4zb45C1Ev();
extern void _ZN4zb45D1Ev();
Name_Map name_map_zb45[] = {
  NSPAIR(_ZN4zb45C1Ev),
  NSPAIR(_ZN4zb45D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_zb45[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_tk21,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb45[];
static  VTBL_ENTRY vtc_zb45[] = {
  ABISELECT(16,8),
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb45[0]),
  ABISELECT(8,4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zb45[0]),
};
extern VTBL_ENTRY _ZTV4zb45[];
static  VTBL_ENTRY _tg__ZTV4sk12__4zb45[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk21__4zb45[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTT_ENTRY vtt_zb45[] = {
  {&(_ZTV4zb45[5]),  5,8},
  {&(_tg__ZTV4sk12__4zb45[3]),  3,3},
  {&(_ZTV4zb45[8]),  8,8},
  {&(_tg__ZTV4tk21__4zb45[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb45[];
extern  VTBL_ENTRY _ZTV4zb45[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb45[];
Class_Descriptor cd_zb45 = {  "zb45", // class name
  bases_zb45, 6,
  &(vtc_zb45[0]), // expected_vtbl_contents
  &(vtt_zb45[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI4zb45),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb45),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb45),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc45  : virtual sk12 , tk21 {
  ~zc45(); // tgen
  zc45(); // tgen
};
//SIG(1 zc45) C1{ VBC2{ VBC3{} BC4{}} BC5{ BC3 VBC4}}


zc45 ::~zc45(){ note_dtor("zc45", this);} // tgen
zc45 ::zc45(){ note_ctor("zc45", this);} // tgen

static void Test_zc45()
{
  extern Class_Descriptor cd_zc45;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_zc45, buf);
    zc45 *dp, &lv = *(dp=new (buf) zc45());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(zc45)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc45)");
    check_base_class_offset(lv, (si*)(sk12*), ABISELECT(16,8), "zc45");
    check_base_class_offset(lv, (sj*)(sk12*), ABISELECT(8,4), "zc45");
    check_base_class_offset(lv, (sk12*), ABISELECT(8,4), "zc45");
    check_base_class_offset(lv, (si*)(tk21*), 0, "zc45");
    check_base_class_offset(lv, (sj*)(tk21*), 0, "zc45");
    check_base_class_offset(lv, (tk21*), 0, "zc45");
    test_class_info(&lv, &cd_zc45);
    dp->~zc45();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc45(Test_zc45, "zc45", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN4zc45C1Ev();
extern void _ZN4zc45D1Ev();
Name_Map name_map_zc45[] = {
  NSPAIR(_ZN4zc45C1Ev),
  NSPAIR(_ZN4zc45D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_zc45[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_tk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc45[];
static  VTBL_ENTRY vtc_zc45[] = {
  ABISELECT(16,8),
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc45[0]),
  ABISELECT(8,4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zc45[0]),
};
extern VTBL_ENTRY _ZTV4zc45[];
static  VTBL_ENTRY _tg__ZTV4tk21__4zc45[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTBL_ENTRY _tg__ZTV4sk12__4zc45[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTT_ENTRY vtt_zc45[] = {
  {&(_ZTV4zc45[5]),  5,8},
  {&(_tg__ZTV4tk21__4zc45[3]),  3,3},
  {&(_ZTV4zc45[8]),  8,8},
  {&(_tg__ZTV4sk12__4zc45[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc45[];
extern  VTBL_ENTRY _ZTV4zc45[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc45[];
Class_Descriptor cd_zc45 = {  "zc45", // class name
  bases_zc45, 6,
  &(vtc_zc45[0]), // expected_vtbl_contents
  &(vtt_zc45[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI4zc45),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc45),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc45),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd45  : virtual sk12 , virtual tk21 {
  ~zd45(); // tgen
  zd45(); // tgen
};
//SIG(1 zd45) C1{ VBC2{ VBC3{} BC4{}} VBC5{ BC3 VBC4}}


zd45 ::~zd45(){ note_dtor("zd45", this);} // tgen
zd45 ::zd45(){ note_ctor("zd45", this);} // tgen

static void Test_zd45()
{
  extern Class_Descriptor cd_zd45;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_zd45, buf);
    zd45 *dp, &lv = *(dp=new (buf) zd45());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(zd45)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd45)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "zd45");
    check_base_class_offset(lv, (sj*)(sk12*), 0, "zd45");
    check_base_class_offset(lv, (sk12*), 0, "zd45");
    check_base_class_offset(lv, (si*)(tk21*), ABISELECT(8,4), "zd45");
    check_base_class_offset(lv, (sj*)(tk21*), ABISELECT(16,8), "zd45");
    check_base_class_offset(lv, (tk21*), ABISELECT(8,4), "zd45");
    test_class_info(&lv, &cd_zd45);
    dp->~zd45();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd45(Test_zd45, "zd45", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN4zd45C1Ev();
extern void _ZN4zd45D1Ev();
Name_Map name_map_zd45[] = {
  NSPAIR(_ZN4zd45C1Ev),
  NSPAIR(_ZN4zd45D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_zd45[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_tk21,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd45[];
static  VTBL_ENTRY vtc_zd45[] = {
  ABISELECT(16,8),
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd45[0]),
  ABISELECT(8,4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zd45[0]),
};
extern VTBL_ENTRY _ZTV4zd45[];
static  VTBL_ENTRY _tg__ZTV4sk12__4zd45[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk21__4zd45[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTT_ENTRY vtt_zd45[] = {
  {&(_ZTV4zd45[6]),  6,9},
  {&(_ZTV4zd45[6]),  6,9},
  {&(_ZTV4zd45[9]),  9,9},
  {&(_tg__ZTV4sk12__4zd45[3]),  3,3},
  {&(_tg__ZTV4tk21__4zd45[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd45[];
extern  VTBL_ENTRY _ZTV4zd45[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd45[];
Class_Descriptor cd_zd45 = {  "zd45", // class name
  bases_zd45, 6,
  &(vtc_zd45[0]), // expected_vtbl_contents
  &(vtt_zd45[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI4zd45),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd45),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd45),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za46  : sk12 , tk22 {
  ~za46(); // tgen
  za46(); // tgen
};
//SIG(1 za46) C1{ BC2{ VBC3{} BC4{}} BC5{ BC3 BC4}}


za46 ::~za46(){ note_dtor("za46", this);} // tgen
za46 ::za46(){ note_ctor("za46", this);} // tgen

static void Test_za46()
{
  extern Class_Descriptor cd_za46;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za46, buf);
    za46 *dp, &lv = *(dp=new (buf) za46());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za46)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za46)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "za46");
    check_base_class_offset(lv, (sj*)(sk12*), 0, "za46");
    check_base_class_offset(lv, (sk12*), 0, "za46");
    check_base_class_offset(lv, (si*)(tk22*), ABISELECT(8,4), "za46");
    check_base_class_offset(lv, (sj*)(tk22*), ABISELECT(8,4), "za46");
    check_base_class_offset(lv, (tk22*), ABISELECT(8,4), "za46");
    test_class_info(&lv, &cd_za46);
    dp->~za46();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza46(Test_za46, "za46", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za46C1Ev();
extern void _ZN4za46D1Ev();
Name_Map name_map_za46[] = {
  NSPAIR(_ZN4za46C1Ev),
  NSPAIR(_ZN4za46D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_za46[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_tk22,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za46[];
static  VTBL_ENTRY vtc_za46[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za46[0]),
};
extern VTBL_ENTRY _ZTV4za46[];
static  VTBL_ENTRY _tg__ZTV4sk12__4za46[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTT_ENTRY vtt_za46[] = {
  {&(_ZTV4za46[3]),  3,3},
  {&(_tg__ZTV4sk12__4za46[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4za46[];
extern  VTBL_ENTRY _ZTV4za46[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za46[];
Class_Descriptor cd_za46 = {  "za46", // class name
  bases_za46, 6,
  &(vtc_za46[0]), // expected_vtbl_contents
  &(vtt_za46[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za46),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za46),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za46),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb46  : sk12 , virtual tk22 {
  ~zb46(); // tgen
  zb46(); // tgen
};
//SIG(1 zb46) C1{ BC2{ VBC3{} BC4{}} VBC5{ BC3 BC4}}


zb46 ::~zb46(){ note_dtor("zb46", this);} // tgen
zb46 ::zb46(){ note_ctor("zb46", this);} // tgen

static void Test_zb46()
{
  extern Class_Descriptor cd_zb46;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb46, buf);
    zb46 *dp, &lv = *(dp=new (buf) zb46());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb46)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb46)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "zb46");
    check_base_class_offset(lv, (sj*)(sk12*), 0, "zb46");
    check_base_class_offset(lv, (sk12*), 0, "zb46");
    check_base_class_offset(lv, (si*)(tk22*), ABISELECT(8,4), "zb46");
    check_base_class_offset(lv, (sj*)(tk22*), ABISELECT(8,4), "zb46");
    check_base_class_offset(lv, (tk22*), ABISELECT(8,4), "zb46");
    test_class_info(&lv, &cd_zb46);
    dp->~zb46();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb46(Test_zb46, "zb46", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb46C1Ev();
extern void _ZN4zb46D1Ev();
Name_Map name_map_zb46[] = {
  NSPAIR(_ZN4zb46C1Ev),
  NSPAIR(_ZN4zb46D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_zb46[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_tk22,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb46[];
static  VTBL_ENTRY vtc_zb46[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb46[0]),
};
extern VTBL_ENTRY _ZTV4zb46[];
static  VTBL_ENTRY _tg__ZTV4sk12__4zb46[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTT_ENTRY vtt_zb46[] = {
  {&(_ZTV4zb46[4]),  4,4},
  {&(_tg__ZTV4sk12__4zb46[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb46[];
extern  VTBL_ENTRY _ZTV4zb46[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb46[];
Class_Descriptor cd_zb46 = {  "zb46", // class name
  bases_zb46, 6,
  &(vtc_zb46[0]), // expected_vtbl_contents
  &(vtt_zb46[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb46),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb46),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb46),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc46  : virtual sk12 , tk22 {
  ~zc46(); // tgen
  zc46(); // tgen
};
//SIG(1 zc46) C1{ VBC2{ VBC3{} BC4{}} BC5{ BC3 BC4}}


zc46 ::~zc46(){ note_dtor("zc46", this);} // tgen
zc46 ::zc46(){ note_ctor("zc46", this);} // tgen

static void Test_zc46()
{
  extern Class_Descriptor cd_zc46;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc46, buf);
    zc46 *dp, &lv = *(dp=new (buf) zc46());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc46)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc46)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "zc46");
    check_base_class_offset(lv, (sj*)(sk12*), 0, "zc46");
    check_base_class_offset(lv, (sk12*), 0, "zc46");
    check_base_class_offset(lv, (si*)(tk22*), ABISELECT(8,4), "zc46");
    check_base_class_offset(lv, (sj*)(tk22*), ABISELECT(8,4), "zc46");
    check_base_class_offset(lv, (tk22*), ABISELECT(8,4), "zc46");
    test_class_info(&lv, &cd_zc46);
    dp->~zc46();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc46(Test_zc46, "zc46", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc46C1Ev();
extern void _ZN4zc46D1Ev();
Name_Map name_map_zc46[] = {
  NSPAIR(_ZN4zc46C1Ev),
  NSPAIR(_ZN4zc46D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_zc46[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_tk22,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc46[];
static  VTBL_ENTRY vtc_zc46[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc46[0]),
};
extern VTBL_ENTRY _ZTV4zc46[];
static  VTBL_ENTRY _tg__ZTV4sk12__4zc46[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTT_ENTRY vtt_zc46[] = {
  {&(_ZTV4zc46[4]),  4,4},
  {&(_ZTV4zc46[4]),  4,4},
  {&(_tg__ZTV4sk12__4zc46[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc46[];
extern  VTBL_ENTRY _ZTV4zc46[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc46[];
Class_Descriptor cd_zc46 = {  "zc46", // class name
  bases_zc46, 6,
  &(vtc_zc46[0]), // expected_vtbl_contents
  &(vtt_zc46[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc46),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc46),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc46),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd46  : virtual sk12 , virtual tk22 {
  ~zd46(); // tgen
  zd46(); // tgen
};
//SIG(1 zd46) C1{ VBC2{ VBC3{} BC4{}} VBC5{ BC3 BC4}}


zd46 ::~zd46(){ note_dtor("zd46", this);} // tgen
zd46 ::zd46(){ note_ctor("zd46", this);} // tgen

static void Test_zd46()
{
  extern Class_Descriptor cd_zd46;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd46, buf);
    zd46 *dp, &lv = *(dp=new (buf) zd46());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd46)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd46)");
    check_base_class_offset(lv, (si*)(sk12*), 0, "zd46");
    check_base_class_offset(lv, (sj*)(sk12*), 0, "zd46");
    check_base_class_offset(lv, (sk12*), 0, "zd46");
    check_base_class_offset(lv, (si*)(tk22*), ABISELECT(8,4), "zd46");
    check_base_class_offset(lv, (sj*)(tk22*), ABISELECT(8,4), "zd46");
    check_base_class_offset(lv, (tk22*), ABISELECT(8,4), "zd46");
    test_class_info(&lv, &cd_zd46);
    dp->~zd46();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd46(Test_zd46, "zd46", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd46C1Ev();
extern void _ZN4zd46D1Ev();
Name_Map name_map_zd46[] = {
  NSPAIR(_ZN4zd46C1Ev),
  NSPAIR(_ZN4zd46D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk12;
extern VTBL_ENTRY _ZTI4sk12[];
extern  VTBL_ENTRY _ZTV4sk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk12[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_zd46[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_tk22,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd46[];
static  VTBL_ENTRY vtc_zd46[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd46[0]),
};
extern VTBL_ENTRY _ZTV4zd46[];
static  VTBL_ENTRY _tg__ZTV4sk12__4zd46[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk12[0]),
};
static  VTT_ENTRY vtt_zd46[] = {
  {&(_ZTV4zd46[5]),  5,5},
  {&(_ZTV4zd46[5]),  5,5},
  {&(_tg__ZTV4sk12__4zd46[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd46[];
extern  VTBL_ENTRY _ZTV4zd46[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd46[];
Class_Descriptor cd_zd46 = {  "zd46", // class name
  bases_zd46, 6,
  &(vtc_zd46[0]), // expected_vtbl_contents
  &(vtt_zd46[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd46),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd46),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd46),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  xt5  : tk21 {
  ~xt5(); // tgen
  xt5(); // tgen
};
//SIG(1 xt5) C1{ BC2{ BC3{} VBC4{}}}


xt5 ::~xt5(){ note_dtor("xt5", this);} // tgen
xt5 ::xt5(){ note_ctor("xt5", this);} // tgen

static void Test_xt5()
{
  extern Class_Descriptor cd_xt5;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_xt5, buf);
    xt5 *dp, &lv = *(dp=new (buf) xt5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(xt5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(xt5)");
    check_base_class_offset(lv, (si*)(tk21*), 0, "xt5");
    check_base_class_offset(lv, (sj*)(tk21*), 0, "xt5");
    check_base_class_offset(lv, (tk21*), 0, "xt5");
    test_class_info(&lv, &cd_xt5);
    dp->~xt5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vxt5(Test_xt5, "xt5", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3xt5C1Ev();
extern void _ZN3xt5D1Ev();
Name_Map name_map_xt5[] = {
  NSPAIR(_ZN3xt5C1Ev),
  NSPAIR(_ZN3xt5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_xt5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_tk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI3xt5[];
static  VTBL_ENTRY vtc_xt5[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI3xt5[0]),
};
extern VTBL_ENTRY _ZTV3xt5[];
static  VTBL_ENTRY _tg__ZTV4tk21__3xt5[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTT_ENTRY vtt_xt5[] = {
  {&(_ZTV3xt5[3]),  3,3},
  {&(_tg__ZTV4tk21__3xt5[3]),  3,3},
};
extern VTBL_ENTRY _ZTI3xt5[];
extern  VTBL_ENTRY _ZTV3xt5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3xt5[];
Class_Descriptor cd_xt5 = {  "xt5", // class name
  bases_xt5, 3,
  &(vtc_xt5[0]), // expected_vtbl_contents
  &(vtt_xt5[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI3xt5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV3xt5),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3xt5),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  yt5  : virtual tk21 {
  ~yt5(); // tgen
  yt5(); // tgen
};
//SIG(1 yt5) C1{ VBC2{ BC3{} VBC4{}}}


yt5 ::~yt5(){ note_dtor("yt5", this);} // tgen
yt5 ::yt5(){ note_ctor("yt5", this);} // tgen

static void Test_yt5()
{
  extern Class_Descriptor cd_yt5;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_yt5, buf);
    yt5 *dp, &lv = *(dp=new (buf) yt5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(yt5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(yt5)");
    check_base_class_offset(lv, (si*)(tk21*), 0, "yt5");
    check_base_class_offset(lv, (sj*)(tk21*), 0, "yt5");
    check_base_class_offset(lv, (tk21*), 0, "yt5");
    test_class_info(&lv, &cd_yt5);
    dp->~yt5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vyt5(Test_yt5, "yt5", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3yt5C1Ev();
extern void _ZN3yt5D1Ev();
Name_Map name_map_yt5[] = {
  NSPAIR(_ZN3yt5C1Ev),
  NSPAIR(_ZN3yt5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_yt5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_tk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3yt5[];
static  VTBL_ENTRY vtc_yt5[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI3yt5[0]),
};
extern VTBL_ENTRY _ZTV3yt5[];
static  VTBL_ENTRY _tg__ZTV4tk21__3yt5[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTT_ENTRY vtt_yt5[] = {
  {&(_ZTV3yt5[4]),  4,4},
  {&(_ZTV3yt5[4]),  4,4},
  {&(_tg__ZTV4tk21__3yt5[3]),  3,3},
};
extern VTBL_ENTRY _ZTI3yt5[];
extern  VTBL_ENTRY _ZTV3yt5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3yt5[];
Class_Descriptor cd_yt5 = {  "yt5", // class name
  bases_yt5, 3,
  &(vtc_yt5[0]), // expected_vtbl_contents
  &(vtt_yt5[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI3yt5),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV3yt5),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3yt5),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za50  : sk21 , tk00 {
  ~za50(); // tgen
  za50(); // tgen
};
//SIG(1 za50) C1{ BC2{ BC3{} VBC4{}} BC5{}}


za50 ::~za50(){ note_dtor("za50", this);} // tgen
za50 ::za50(){ note_ctor("za50", this);} // tgen

static void Test_za50()
{
  extern Class_Descriptor cd_za50;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_za50, buf);
    za50 *dp, &lv = *(dp=new (buf) za50());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(za50)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za50)");
    check_base_class_offset(lv, (si*)(sk21*), 0, "za50");
    check_base_class_offset(lv, (sj*)(sk21*), 0, "za50");
    check_base_class_offset(lv, (sk21*), 0, "za50");
    check_base_class_offset(lv, (tk00*), 0, "za50");
    test_class_info(&lv, &cd_za50);
    dp->~za50();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza50(Test_za50, "za50", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4za50C1Ev();
extern void _ZN4za50D1Ev();
Name_Map name_map_za50[] = {
  NSPAIR(_ZN4za50C1Ev),
  NSPAIR(_ZN4za50D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_za50[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za50[];
static  VTBL_ENTRY vtc_za50[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za50[0]),
};
extern VTBL_ENTRY _ZTV4za50[];
static  VTBL_ENTRY _tg__ZTV4sk21__4za50[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTT_ENTRY vtt_za50[] = {
  {&(_ZTV4za50[3]),  3,3},
  {&(_tg__ZTV4sk21__4za50[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4za50[];
extern  VTBL_ENTRY _ZTV4za50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za50[];
Class_Descriptor cd_za50 = {  "za50", // class name
  bases_za50, 4,
  &(vtc_za50[0]), // expected_vtbl_contents
  &(vtt_za50[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4za50),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za50),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za50),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb50  : sk21 , virtual tk00 {
  ~zb50(); // tgen
  zb50(); // tgen
};
//SIG(1 zb50) C1{ BC2{ BC3{} VBC4{}} VBC5{}}


zb50 ::~zb50(){ note_dtor("zb50", this);} // tgen
zb50 ::zb50(){ note_ctor("zb50", this);} // tgen

static void Test_zb50()
{
  extern Class_Descriptor cd_zb50;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zb50, buf);
    zb50 *dp, &lv = *(dp=new (buf) zb50());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zb50)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb50)");
    check_base_class_offset(lv, (si*)(sk21*), 0, "zb50");
    check_base_class_offset(lv, (sj*)(sk21*), 0, "zb50");
    check_base_class_offset(lv, (sk21*), 0, "zb50");
    check_base_class_offset(lv, (tk00*), 0, "zb50");
    test_class_info(&lv, &cd_zb50);
    dp->~zb50();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb50(Test_zb50, "zb50", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zb50C1Ev();
extern void _ZN4zb50D1Ev();
Name_Map name_map_zb50[] = {
  NSPAIR(_ZN4zb50C1Ev),
  NSPAIR(_ZN4zb50D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_zb50[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb50[];
static  VTBL_ENTRY vtc_zb50[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb50[0]),
};
extern VTBL_ENTRY _ZTV4zb50[];
static  VTBL_ENTRY _tg__ZTV4sk21__4zb50[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTT_ENTRY vtt_zb50[] = {
  {&(_ZTV4zb50[4]),  4,4},
  {&(_tg__ZTV4sk21__4zb50[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb50[];
extern  VTBL_ENTRY _ZTV4zb50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb50[];
Class_Descriptor cd_zb50 = {  "zb50", // class name
  bases_zb50, 4,
  &(vtc_zb50[0]), // expected_vtbl_contents
  &(vtt_zb50[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zb50),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb50),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb50),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc50  : virtual sk21 , tk00 {
  ~zc50(); // tgen
  zc50(); // tgen
};
//SIG(1 zc50) C1{ VBC2{ BC3{} VBC4{}} BC5{}}


zc50 ::~zc50(){ note_dtor("zc50", this);} // tgen
zc50 ::zc50(){ note_ctor("zc50", this);} // tgen

static void Test_zc50()
{
  extern Class_Descriptor cd_zc50;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zc50, buf);
    zc50 *dp, &lv = *(dp=new (buf) zc50());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zc50)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc50)");
    check_base_class_offset(lv, (si*)(sk21*), 0, "zc50");
    check_base_class_offset(lv, (sj*)(sk21*), 0, "zc50");
    check_base_class_offset(lv, (sk21*), 0, "zc50");
    check_base_class_offset(lv, (tk00*), 0, "zc50");
    test_class_info(&lv, &cd_zc50);
    dp->~zc50();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc50(Test_zc50, "zc50", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zc50C1Ev();
extern void _ZN4zc50D1Ev();
Name_Map name_map_zc50[] = {
  NSPAIR(_ZN4zc50C1Ev),
  NSPAIR(_ZN4zc50D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_zc50[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc50[];
static  VTBL_ENTRY vtc_zc50[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc50[0]),
};
extern VTBL_ENTRY _ZTV4zc50[];
static  VTBL_ENTRY _tg__ZTV4sk21__4zc50[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTT_ENTRY vtt_zc50[] = {
  {&(_ZTV4zc50[4]),  4,4},
  {&(_ZTV4zc50[4]),  4,4},
  {&(_tg__ZTV4sk21__4zc50[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc50[];
extern  VTBL_ENTRY _ZTV4zc50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc50[];
Class_Descriptor cd_zc50 = {  "zc50", // class name
  bases_zc50, 4,
  &(vtc_zc50[0]), // expected_vtbl_contents
  &(vtt_zc50[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zc50),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc50),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc50),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd50  : virtual sk21 , virtual tk00 {
  ~zd50(); // tgen
  zd50(); // tgen
};
//SIG(1 zd50) C1{ VBC2{ BC3{} VBC4{}} VBC5{}}


zd50 ::~zd50(){ note_dtor("zd50", this);} // tgen
zd50 ::zd50(){ note_ctor("zd50", this);} // tgen

static void Test_zd50()
{
  extern Class_Descriptor cd_zd50;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zd50, buf);
    zd50 *dp, &lv = *(dp=new (buf) zd50());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zd50)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd50)");
    check_base_class_offset(lv, (si*)(sk21*), 0, "zd50");
    check_base_class_offset(lv, (sj*)(sk21*), 0, "zd50");
    check_base_class_offset(lv, (sk21*), 0, "zd50");
    check_base_class_offset(lv, (tk00*), 0, "zd50");
    test_class_info(&lv, &cd_zd50);
    dp->~zd50();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd50(Test_zd50, "zd50", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zd50C1Ev();
extern void _ZN4zd50D1Ev();
Name_Map name_map_zd50[] = {
  NSPAIR(_ZN4zd50C1Ev),
  NSPAIR(_ZN4zd50D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_zd50[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd50[];
static  VTBL_ENTRY vtc_zd50[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd50[0]),
};
extern VTBL_ENTRY _ZTV4zd50[];
static  VTBL_ENTRY _tg__ZTV4sk21__4zd50[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTT_ENTRY vtt_zd50[] = {
  {&(_ZTV4zd50[5]),  5,5},
  {&(_ZTV4zd50[5]),  5,5},
  {&(_tg__ZTV4sk21__4zd50[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd50[];
extern  VTBL_ENTRY _ZTV4zd50[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd50[];
Class_Descriptor cd_zd50 = {  "zd50", // class name
  bases_zd50, 4,
  &(vtc_zd50[0]), // expected_vtbl_contents
  &(vtt_zd50[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zd50),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd50),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd50),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za51  : sk21 , tk01 {
  ~za51(); // tgen
  za51(); // tgen
};
//SIG(1 za51) C1{ BC2{ BC3{} VBC4{}} BC5{ VBC4}}


za51 ::~za51(){ note_dtor("za51", this);} // tgen
za51 ::za51(){ note_ctor("za51", this);} // tgen

static void Test_za51()
{
  extern Class_Descriptor cd_za51;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za51, buf);
    za51 *dp, &lv = *(dp=new (buf) za51());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za51)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za51)");
    check_base_class_offset(lv, (si*)(sk21*), 0, "za51");
    check_base_class_offset(lv, (sj*)(sk21*), 0, "za51");
    check_base_class_offset(lv, (sj*)(tk01*), 0, "za51");
    check_base_class_offset(lv, (sk21*), 0, "za51");
    check_base_class_offset(lv, (tk01*), ABISELECT(8,4), "za51");
    test_class_info(&lv, &cd_za51);
    dp->~za51();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza51(Test_za51, "za51", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za51C1Ev();
extern void _ZN4za51D1Ev();
Name_Map name_map_za51[] = {
  NSPAIR(_ZN4za51C1Ev),
  NSPAIR(_ZN4za51D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_za51[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_tk01,    ABISELECT(8,4), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za51[];
static  VTBL_ENTRY vtc_za51[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za51[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4za51[0]),
};
extern VTBL_ENTRY _ZTV4za51[];
static  VTBL_ENTRY _tg__ZTV4sk21__4za51[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk01__4za51[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTT_ENTRY vtt_za51[] = {
  {&(_ZTV4za51[3]),  3,6},
  {&(_tg__ZTV4sk21__4za51[3]),  3,3},
  {&(_tg__ZTV4tk01__4za51[3]),  3,3},
  {&(_ZTV4za51[6]),  6,6},
};
extern VTBL_ENTRY _ZTI4za51[];
extern  VTBL_ENTRY _ZTV4za51[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za51[];
Class_Descriptor cd_za51 = {  "za51", // class name
  bases_za51, 4,
  &(vtc_za51[0]), // expected_vtbl_contents
  &(vtt_za51[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za51),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za51),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za51),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb51  : sk21 , virtual tk01 {
  ~zb51(); // tgen
  zb51(); // tgen
};
//SIG(1 zb51) C1{ BC2{ BC3{} VBC4{}} VBC5{ VBC4}}


zb51 ::~zb51(){ note_dtor("zb51", this);} // tgen
zb51 ::zb51(){ note_ctor("zb51", this);} // tgen

static void Test_zb51()
{
  extern Class_Descriptor cd_zb51;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb51, buf);
    zb51 *dp, &lv = *(dp=new (buf) zb51());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb51)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb51)");
    check_base_class_offset(lv, (si*)(sk21*), 0, "zb51");
    check_base_class_offset(lv, (sj*)(sk21*), 0, "zb51");
    check_base_class_offset(lv, (sj*)(tk01*), 0, "zb51");
    check_base_class_offset(lv, (sk21*), 0, "zb51");
    check_base_class_offset(lv, (tk01*), ABISELECT(8,4), "zb51");
    test_class_info(&lv, &cd_zb51);
    dp->~zb51();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb51(Test_zb51, "zb51", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb51C1Ev();
extern void _ZN4zb51D1Ev();
Name_Map name_map_zb51[] = {
  NSPAIR(_ZN4zb51C1Ev),
  NSPAIR(_ZN4zb51D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_zb51[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_tk01,    ABISELECT(8,4), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb51[];
static  VTBL_ENTRY vtc_zb51[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb51[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zb51[0]),
};
extern VTBL_ENTRY _ZTV4zb51[];
static  VTBL_ENTRY _tg__ZTV4sk21__4zb51[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk01__4zb51[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTT_ENTRY vtt_zb51[] = {
  {&(_ZTV4zb51[4]),  4,7},
  {&(_tg__ZTV4sk21__4zb51[3]),  3,3},
  {&(_ZTV4zb51[7]),  7,7},
  {&(_tg__ZTV4tk01__4zb51[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb51[];
extern  VTBL_ENTRY _ZTV4zb51[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb51[];
Class_Descriptor cd_zb51 = {  "zb51", // class name
  bases_zb51, 4,
  &(vtc_zb51[0]), // expected_vtbl_contents
  &(vtt_zb51[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb51),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb51),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb51),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc51  : virtual sk21 , tk01 {
  ~zc51(); // tgen
  zc51(); // tgen
};
//SIG(1 zc51) C1{ VBC2{ BC3{} VBC4{}} BC5{ VBC4}}


zc51 ::~zc51(){ note_dtor("zc51", this);} // tgen
zc51 ::zc51(){ note_ctor("zc51", this);} // tgen

static void Test_zc51()
{
  extern Class_Descriptor cd_zc51;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc51, buf);
    zc51 *dp, &lv = *(dp=new (buf) zc51());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc51)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc51)");
    check_base_class_offset(lv, (si*)(sk21*), ABISELECT(8,4), "zc51");
    check_base_class_offset(lv, (sj*)(sk21*), 0, "zc51");
    check_base_class_offset(lv, (sj*)(tk01*), 0, "zc51");
    check_base_class_offset(lv, (sk21*), ABISELECT(8,4), "zc51");
    check_base_class_offset(lv, (tk01*), 0, "zc51");
    test_class_info(&lv, &cd_zc51);
    dp->~zc51();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc51(Test_zc51, "zc51", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc51C1Ev();
extern void _ZN4zc51D1Ev();
Name_Map name_map_zc51[] = {
  NSPAIR(_ZN4zc51C1Ev),
  NSPAIR(_ZN4zc51D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_zc51[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    ABISELECT(8,4), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_tk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc51[];
static  VTBL_ENTRY vtc_zc51[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc51[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zc51[0]),
};
extern VTBL_ENTRY _ZTV4zc51[];
static  VTBL_ENTRY _tg__ZTV4tk01__4zc51[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTBL_ENTRY _tg__ZTV4sk21__4zc51[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTT_ENTRY vtt_zc51[] = {
  {&(_ZTV4zc51[4]),  4,7},
  {&(_tg__ZTV4tk01__4zc51[3]),  3,3},
  {&(_ZTV4zc51[7]),  7,7},
  {&(_tg__ZTV4sk21__4zc51[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc51[];
extern  VTBL_ENTRY _ZTV4zc51[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc51[];
Class_Descriptor cd_zc51 = {  "zc51", // class name
  bases_zc51, 4,
  &(vtc_zc51[0]), // expected_vtbl_contents
  &(vtt_zc51[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc51),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc51),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc51),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd51  : virtual sk21 , virtual tk01 {
  ~zd51(); // tgen
  zd51(); // tgen
};
//SIG(1 zd51) C1{ VBC2{ BC3{} VBC4{}} VBC5{ VBC4}}


zd51 ::~zd51(){ note_dtor("zd51", this);} // tgen
zd51 ::zd51(){ note_ctor("zd51", this);} // tgen

static void Test_zd51()
{
  extern Class_Descriptor cd_zd51;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd51, buf);
    zd51 *dp, &lv = *(dp=new (buf) zd51());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd51)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd51)");
    check_base_class_offset(lv, (si*)(sk21*), 0, "zd51");
    check_base_class_offset(lv, (sj*)(sk21*), 0, "zd51");
    check_base_class_offset(lv, (sj*)(tk01*), 0, "zd51");
    check_base_class_offset(lv, (sk21*), 0, "zd51");
    check_base_class_offset(lv, (tk01*), ABISELECT(8,4), "zd51");
    test_class_info(&lv, &cd_zd51);
    dp->~zd51();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd51(Test_zd51, "zd51", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd51C1Ev();
extern void _ZN4zd51D1Ev();
Name_Map name_map_zd51[] = {
  NSPAIR(_ZN4zd51C1Ev),
  NSPAIR(_ZN4zd51D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_zd51[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_tk01,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd51[];
static  VTBL_ENTRY vtc_zd51[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd51[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zd51[0]),
};
extern VTBL_ENTRY _ZTV4zd51[];
static  VTBL_ENTRY _tg__ZTV4sk21__4zd51[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk01__4zd51[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTT_ENTRY vtt_zd51[] = {
  {&(_ZTV4zd51[5]),  5,8},
  {&(_ZTV4zd51[5]),  5,8},
  {&(_ZTV4zd51[8]),  8,8},
  {&(_tg__ZTV4sk21__4zd51[3]),  3,3},
  {&(_tg__ZTV4tk01__4zd51[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd51[];
extern  VTBL_ENTRY _ZTV4zd51[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd51[];
Class_Descriptor cd_zd51 = {  "zd51", // class name
  bases_zd51, 4,
  &(vtc_zd51[0]), // expected_vtbl_contents
  &(vtt_zd51[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd51),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd51),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd51),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za52  : sk21 , tk02 {
  ~za52(); // tgen
  za52(); // tgen
};
//SIG(1 za52) C1{ BC2{ BC3{} VBC4{}} BC5{ BC4}}


za52 ::~za52(){ note_dtor("za52", this);} // tgen
za52 ::za52(){ note_ctor("za52", this);} // tgen

static void Test_za52()
{
  extern Class_Descriptor cd_za52;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za52, buf);
    za52 *dp, &lv = *(dp=new (buf) za52());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za52)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za52)");
    check_base_class_offset(lv, (si*)(sk21*), 0, "za52");
    check_base_class_offset(lv, (sj*)(sk21*), ABISELECT(8,4), "za52");
    check_base_class_offset(lv, (sk21*), 0, "za52");
    check_base_class_offset(lv, (sj*)(tk02*), 0, "za52");
    check_base_class_offset(lv, (tk02*), 0, "za52");
    test_class_info(&lv, &cd_za52);
    dp->~za52();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza52(Test_za52, "za52", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za52C1Ev();
extern void _ZN4za52D1Ev();
Name_Map name_map_za52[] = {
  NSPAIR(_ZN4za52C1Ev),
  NSPAIR(_ZN4za52D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_za52[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za52[];
static  VTBL_ENTRY vtc_za52[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4za52[0]),
};
extern VTBL_ENTRY _ZTV4za52[];
static  VTBL_ENTRY _tg__ZTV4sk21__4za52[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTT_ENTRY vtt_za52[] = {
  {&(_ZTV4za52[3]),  3,3},
  {&(_tg__ZTV4sk21__4za52[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4za52[];
extern  VTBL_ENTRY _ZTV4za52[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za52[];
Class_Descriptor cd_za52 = {  "za52", // class name
  bases_za52, 5,
  &(vtc_za52[0]), // expected_vtbl_contents
  &(vtt_za52[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za52),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za52),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za52),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb52  : sk21 , virtual tk02 {
  ~zb52(); // tgen
  zb52(); // tgen
};
//SIG(1 zb52) C1{ BC2{ BC3{} VBC4{}} VBC5{ BC4}}


zb52 ::~zb52(){ note_dtor("zb52", this);} // tgen
zb52 ::zb52(){ note_ctor("zb52", this);} // tgen

static void Test_zb52()
{
  extern Class_Descriptor cd_zb52;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb52, buf);
    zb52 *dp, &lv = *(dp=new (buf) zb52());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb52)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb52)");
    check_base_class_offset(lv, (si*)(sk21*), 0, "zb52");
    check_base_class_offset(lv, (sj*)(sk21*), 0, "zb52");
    check_base_class_offset(lv, (sk21*), 0, "zb52");
    check_base_class_offset(lv, (sj*)(tk02*), ABISELECT(8,4), "zb52");
    check_base_class_offset(lv, (tk02*), ABISELECT(8,4), "zb52");
    test_class_info(&lv, &cd_zb52);
    dp->~zb52();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb52(Test_zb52, "zb52", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb52C1Ev();
extern void _ZN4zb52D1Ev();
Name_Map name_map_zb52[] = {
  NSPAIR(_ZN4zb52C1Ev),
  NSPAIR(_ZN4zb52D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_zb52[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk02,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb52[];
static  VTBL_ENTRY vtc_zb52[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb52[0]),
};
extern VTBL_ENTRY _ZTV4zb52[];
static  VTBL_ENTRY _tg__ZTV4sk21__4zb52[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTT_ENTRY vtt_zb52[] = {
  {&(_ZTV4zb52[4]),  4,4},
  {&(_tg__ZTV4sk21__4zb52[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb52[];
extern  VTBL_ENTRY _ZTV4zb52[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb52[];
Class_Descriptor cd_zb52 = {  "zb52", // class name
  bases_zb52, 5,
  &(vtc_zb52[0]), // expected_vtbl_contents
  &(vtt_zb52[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb52),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb52),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb52),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc52  : virtual sk21 , tk02 {
  ~zc52(); // tgen
  zc52(); // tgen
};
//SIG(1 zc52) C1{ VBC2{ BC3{} VBC4{}} BC5{ BC4}}


zc52 ::~zc52(){ note_dtor("zc52", this);} // tgen
zc52 ::zc52(){ note_ctor("zc52", this);} // tgen

static void Test_zc52()
{
  extern Class_Descriptor cd_zc52;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc52, buf);
    zc52 *dp, &lv = *(dp=new (buf) zc52());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc52)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc52)");
    check_base_class_offset(lv, (si*)(sk21*), 0, "zc52");
    check_base_class_offset(lv, (sj*)(sk21*), ABISELECT(8,4), "zc52");
    check_base_class_offset(lv, (sk21*), 0, "zc52");
    check_base_class_offset(lv, (sj*)(tk02*), 0, "zc52");
    check_base_class_offset(lv, (tk02*), 0, "zc52");
    test_class_info(&lv, &cd_zc52);
    dp->~zc52();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc52(Test_zc52, "zc52", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc52C1Ev();
extern void _ZN4zc52D1Ev();
Name_Map name_map_zc52[] = {
  NSPAIR(_ZN4zc52C1Ev),
  NSPAIR(_ZN4zc52D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_zc52[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc52[];
static  VTBL_ENTRY vtc_zc52[] = {
  0,
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4zc52[0]),
};
extern VTBL_ENTRY _ZTV4zc52[];
static  VTBL_ENTRY _tg__ZTV4sk21__4zc52[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTT_ENTRY vtt_zc52[] = {
  {&(_ZTV4zc52[4]),  4,4},
  {&(_ZTV4zc52[4]),  4,4},
  {&(_tg__ZTV4sk21__4zc52[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc52[];
extern  VTBL_ENTRY _ZTV4zc52[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc52[];
Class_Descriptor cd_zc52 = {  "zc52", // class name
  bases_zc52, 5,
  &(vtc_zc52[0]), // expected_vtbl_contents
  &(vtt_zc52[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc52),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc52),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc52),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd52  : virtual sk21 , virtual tk02 {
  ~zd52(); // tgen
  zd52(); // tgen
};
//SIG(1 zd52) C1{ VBC2{ BC3{} VBC4{}} VBC5{ BC4}}


zd52 ::~zd52(){ note_dtor("zd52", this);} // tgen
zd52 ::zd52(){ note_ctor("zd52", this);} // tgen

static void Test_zd52()
{
  extern Class_Descriptor cd_zd52;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd52, buf);
    zd52 *dp, &lv = *(dp=new (buf) zd52());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd52)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd52)");
    check_base_class_offset(lv, (si*)(sk21*), 0, "zd52");
    check_base_class_offset(lv, (sj*)(sk21*), 0, "zd52");
    check_base_class_offset(lv, (sk21*), 0, "zd52");
    check_base_class_offset(lv, (sj*)(tk02*), ABISELECT(8,4), "zd52");
    check_base_class_offset(lv, (tk02*), ABISELECT(8,4), "zd52");
    test_class_info(&lv, &cd_zd52);
    dp->~zd52();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd52(Test_zd52, "zd52", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd52C1Ev();
extern void _ZN4zd52D1Ev();
Name_Map name_map_zd52[] = {
  NSPAIR(_ZN4zd52C1Ev),
  NSPAIR(_ZN4zd52D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_zd52[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk02,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd52[];
static  VTBL_ENTRY vtc_zd52[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd52[0]),
};
extern VTBL_ENTRY _ZTV4zd52[];
static  VTBL_ENTRY _tg__ZTV4sk21__4zd52[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTT_ENTRY vtt_zd52[] = {
  {&(_ZTV4zd52[5]),  5,5},
  {&(_ZTV4zd52[5]),  5,5},
  {&(_tg__ZTV4sk21__4zd52[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd52[];
extern  VTBL_ENTRY _ZTV4zd52[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd52[];
Class_Descriptor cd_zd52 = {  "zd52", // class name
  bases_zd52, 5,
  &(vtc_zd52[0]), // expected_vtbl_contents
  &(vtt_zd52[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd52),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd52),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd52),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za53  : sk21 , tk11 {
  ~za53(); // tgen
  za53(); // tgen
};
//SIG(1 za53) C1{ BC2{ BC3{} VBC4{}} BC5{ VBC3 VBC4}}


za53 ::~za53(){ note_dtor("za53", this);} // tgen
za53 ::za53(){ note_ctor("za53", this);} // tgen

static void Test_za53()
{
  extern Class_Descriptor cd_za53;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_za53, buf);
    za53 *dp, &lv = *(dp=new (buf) za53());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(za53)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za53)");
    check_base_class_offset(lv, (si*)(sk21*), 0, "za53");
    check_base_class_offset(lv, (sj*)(sk21*), 0, "za53");
    check_base_class_offset(lv, (sj*)(tk11*), 0, "za53");
    check_base_class_offset(lv, (sk21*), 0, "za53");
    check_base_class_offset(lv, (si*)(tk11*), ABISELECT(16,8), "za53");
    check_base_class_offset(lv, (tk11*), ABISELECT(8,4), "za53");
    test_class_info(&lv, &cd_za53);
    dp->~za53();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza53(Test_za53, "za53", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN4za53C1Ev();
extern void _ZN4za53D1Ev();
Name_Map name_map_za53[] = {
  NSPAIR(_ZN4za53C1Ev),
  NSPAIR(_ZN4za53D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_za53[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_tk11,    ABISELECT(8,4), //bcp->offset
    4, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za53[];
static  VTBL_ENTRY vtc_za53[] = {
  ABISELECT(16,8),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za53[0]),
  ABISELECT(-8,-4),
  ABISELECT(8,4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4za53[0]),
};
extern VTBL_ENTRY _ZTV4za53[];
static  VTBL_ENTRY _tg__ZTV4sk21__4za53[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk11__4za53[] = {
  ABISELECT(-8,-4),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTT_ENTRY vtt_za53[] = {
  {&(_ZTV4za53[4]),  4,8},
  {&(_tg__ZTV4sk21__4za53[3]),  3,3},
  {&(_tg__ZTV4tk11__4za53[4]),  4,4},
  {&(_ZTV4za53[8]),  8,8},
};
extern VTBL_ENTRY _ZTI4za53[];
extern  VTBL_ENTRY _ZTV4za53[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za53[];
Class_Descriptor cd_za53 = {  "za53", // class name
  bases_za53, 5,
  &(vtc_za53[0]), // expected_vtbl_contents
  &(vtt_za53[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI4za53),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za53),8, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za53),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb53  : sk21 , virtual tk11 {
  ~zb53(); // tgen
  zb53(); // tgen
};
//SIG(1 zb53) C1{ BC2{ BC3{} VBC4{}} VBC5{ VBC3 VBC4}}


zb53 ::~zb53(){ note_dtor("zb53", this);} // tgen
zb53 ::zb53(){ note_ctor("zb53", this);} // tgen

static void Test_zb53()
{
  extern Class_Descriptor cd_zb53;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_zb53, buf);
    zb53 *dp, &lv = *(dp=new (buf) zb53());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(zb53)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb53)");
    check_base_class_offset(lv, (si*)(sk21*), 0, "zb53");
    check_base_class_offset(lv, (sj*)(sk21*), 0, "zb53");
    check_base_class_offset(lv, (sj*)(tk11*), 0, "zb53");
    check_base_class_offset(lv, (sk21*), 0, "zb53");
    check_base_class_offset(lv, (si*)(tk11*), ABISELECT(16,8), "zb53");
    check_base_class_offset(lv, (tk11*), ABISELECT(8,4), "zb53");
    test_class_info(&lv, &cd_zb53);
    dp->~zb53();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb53(Test_zb53, "zb53", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN4zb53C1Ev();
extern void _ZN4zb53D1Ev();
Name_Map name_map_zb53[] = {
  NSPAIR(_ZN4zb53C1Ev),
  NSPAIR(_ZN4zb53D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_zb53[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_tk11,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb53[];
static  VTBL_ENTRY vtc_zb53[] = {
  ABISELECT(16,8),
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb53[0]),
  ABISELECT(-8,-4),
  ABISELECT(8,4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zb53[0]),
};
extern VTBL_ENTRY _ZTV4zb53[];
static  VTBL_ENTRY _tg__ZTV4sk21__4zb53[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk11__4zb53[] = {
  ABISELECT(-8,-4),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTT_ENTRY vtt_zb53[] = {
  {&(_ZTV4zb53[5]),  5,9},
  {&(_tg__ZTV4sk21__4zb53[3]),  3,3},
  {&(_ZTV4zb53[9]),  9,9},
  {&(_tg__ZTV4tk11__4zb53[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zb53[];
extern  VTBL_ENTRY _ZTV4zb53[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb53[];
Class_Descriptor cd_zb53 = {  "zb53", // class name
  bases_zb53, 5,
  &(vtc_zb53[0]), // expected_vtbl_contents
  &(vtt_zb53[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI4zb53),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb53),9, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb53),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc53  : virtual sk21 , tk11 {
  ~zc53(); // tgen
  zc53(); // tgen
};
//SIG(1 zc53) C1{ VBC2{ BC3{} VBC4{}} BC5{ VBC3 VBC4}}


zc53 ::~zc53(){ note_dtor("zc53", this);} // tgen
zc53 ::zc53(){ note_ctor("zc53", this);} // tgen

static void Test_zc53()
{
  extern Class_Descriptor cd_zc53;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc53, buf);
    zc53 *dp, &lv = *(dp=new (buf) zc53());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc53)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc53)");
    check_base_class_offset(lv, (si*)(sk21*), ABISELECT(8,4), "zc53");
    check_base_class_offset(lv, (sj*)(sk21*), 0, "zc53");
    check_base_class_offset(lv, (sj*)(tk11*), 0, "zc53");
    check_base_class_offset(lv, (sk21*), ABISELECT(8,4), "zc53");
    check_base_class_offset(lv, (si*)(tk11*), 0, "zc53");
    check_base_class_offset(lv, (tk11*), 0, "zc53");
    test_class_info(&lv, &cd_zc53);
    dp->~zc53();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc53(Test_zc53, "zc53", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc53C1Ev();
extern void _ZN4zc53D1Ev();
Name_Map name_map_zc53[] = {
  NSPAIR(_ZN4zc53C1Ev),
  NSPAIR(_ZN4zc53D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_zc53[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_tk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc53[];
static  VTBL_ENTRY vtc_zc53[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc53[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zc53[0]),
};
extern VTBL_ENTRY _ZTV4zc53[];
static  VTBL_ENTRY _tg__ZTV4tk11__4zc53[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTBL_ENTRY _tg__ZTV4sk21__4zc53[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTT_ENTRY vtt_zc53[] = {
  {&(_ZTV4zc53[5]),  5,8},
  {&(_tg__ZTV4tk11__4zc53[4]),  4,4},
  {&(_ZTV4zc53[8]),  8,8},
  {&(_tg__ZTV4sk21__4zc53[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc53[];
extern  VTBL_ENTRY _ZTV4zc53[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc53[];
Class_Descriptor cd_zc53 = {  "zc53", // class name
  bases_zc53, 5,
  &(vtc_zc53[0]), // expected_vtbl_contents
  &(vtt_zc53[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc53),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc53),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc53),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd53  : virtual sk21 , virtual tk11 {
  ~zd53(); // tgen
  zd53(); // tgen
};
//SIG(1 zd53) C1{ VBC2{ BC3{} VBC4{}} VBC5{ VBC3 VBC4}}


zd53 ::~zd53(){ note_dtor("zd53", this);} // tgen
zd53 ::zd53(){ note_ctor("zd53", this);} // tgen

static void Test_zd53()
{
  extern Class_Descriptor cd_zd53;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_zd53, buf);
    zd53 *dp, &lv = *(dp=new (buf) zd53());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(zd53)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd53)");
    check_base_class_offset(lv, (si*)(sk21*), 0, "zd53");
    check_base_class_offset(lv, (sj*)(sk21*), 0, "zd53");
    check_base_class_offset(lv, (sj*)(tk11*), 0, "zd53");
    check_base_class_offset(lv, (sk21*), 0, "zd53");
    check_base_class_offset(lv, (si*)(tk11*), ABISELECT(16,8), "zd53");
    check_base_class_offset(lv, (tk11*), ABISELECT(8,4), "zd53");
    test_class_info(&lv, &cd_zd53);
    dp->~zd53();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd53(Test_zd53, "zd53", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN4zd53C1Ev();
extern void _ZN4zd53D1Ev();
Name_Map name_map_zd53[] = {
  NSPAIR(_ZN4zd53C1Ev),
  NSPAIR(_ZN4zd53D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_zd53[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_tk11,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd53[];
static  VTBL_ENTRY vtc_zd53[] = {
  ABISELECT(16,8),
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd53[0]),
  ABISELECT(-8,-4),
  ABISELECT(8,4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zd53[0]),
};
extern VTBL_ENTRY _ZTV4zd53[];
static  VTBL_ENTRY _tg__ZTV4sk21__4zd53[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk11__4zd53[] = {
  ABISELECT(-8,-4),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTT_ENTRY vtt_zd53[] = {
  {&(_ZTV4zd53[6]),  6,10},
  {&(_ZTV4zd53[6]),  6,10},
  {&(_ZTV4zd53[10]),  10,10},
  {&(_tg__ZTV4sk21__4zd53[3]),  3,3},
  {&(_tg__ZTV4tk11__4zd53[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zd53[];
extern  VTBL_ENTRY _ZTV4zd53[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd53[];
Class_Descriptor cd_zd53 = {  "zd53", // class name
  bases_zd53, 5,
  &(vtc_zd53[0]), // expected_vtbl_contents
  &(vtt_zd53[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI4zd53),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd53),10, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd53),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za54  : sk21 , tk12 {
  ~za54(); // tgen
  za54(); // tgen
};
//SIG(1 za54) C1{ BC2{ BC3{} VBC4{}} BC5{ VBC3 BC4}}


za54 ::~za54(){ note_dtor("za54", this);} // tgen
za54 ::za54(){ note_ctor("za54", this);} // tgen

static void Test_za54()
{
  extern Class_Descriptor cd_za54;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_za54, buf);
    za54 *dp, &lv = *(dp=new (buf) za54());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(za54)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za54)");
    check_base_class_offset(lv, (si*)(sk21*), 0, "za54");
    check_base_class_offset(lv, (sj*)(sk21*), 0, "za54");
    check_base_class_offset(lv, (sk21*), 0, "za54");
    check_base_class_offset(lv, (si*)(tk12*), ABISELECT(16,8), "za54");
    check_base_class_offset(lv, (sj*)(tk12*), ABISELECT(8,4), "za54");
    check_base_class_offset(lv, (tk12*), ABISELECT(8,4), "za54");
    test_class_info(&lv, &cd_za54);
    dp->~za54();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza54(Test_za54, "za54", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN4za54C1Ev();
extern void _ZN4za54D1Ev();
Name_Map name_map_za54[] = {
  NSPAIR(_ZN4za54C1Ev),
  NSPAIR(_ZN4za54D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_za54[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_tk12,    ABISELECT(8,4), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za54[];
static  VTBL_ENTRY vtc_za54[] = {
  ABISELECT(16,8),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za54[0]),
  ABISELECT(8,4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4za54[0]),
};
extern VTBL_ENTRY _ZTV4za54[];
static  VTBL_ENTRY _tg__ZTV4sk21__4za54[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk12__4za54[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTT_ENTRY vtt_za54[] = {
  {&(_ZTV4za54[4]),  4,7},
  {&(_tg__ZTV4sk21__4za54[3]),  3,3},
  {&(_tg__ZTV4tk12__4za54[3]),  3,3},
  {&(_ZTV4za54[7]),  7,7},
};
extern VTBL_ENTRY _ZTI4za54[];
extern  VTBL_ENTRY _ZTV4za54[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za54[];
Class_Descriptor cd_za54 = {  "za54", // class name
  bases_za54, 6,
  &(vtc_za54[0]), // expected_vtbl_contents
  &(vtt_za54[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI4za54),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za54),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za54),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb54  : sk21 , virtual tk12 {
  ~zb54(); // tgen
  zb54(); // tgen
};
//SIG(1 zb54) C1{ BC2{ BC3{} VBC4{}} VBC5{ VBC3 BC4}}


zb54 ::~zb54(){ note_dtor("zb54", this);} // tgen
zb54 ::zb54(){ note_ctor("zb54", this);} // tgen

static void Test_zb54()
{
  extern Class_Descriptor cd_zb54;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_zb54, buf);
    zb54 *dp, &lv = *(dp=new (buf) zb54());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(zb54)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb54)");
    check_base_class_offset(lv, (si*)(sk21*), 0, "zb54");
    check_base_class_offset(lv, (sj*)(sk21*), 0, "zb54");
    check_base_class_offset(lv, (sk21*), 0, "zb54");
    check_base_class_offset(lv, (si*)(tk12*), ABISELECT(16,8), "zb54");
    check_base_class_offset(lv, (sj*)(tk12*), ABISELECT(8,4), "zb54");
    check_base_class_offset(lv, (tk12*), ABISELECT(8,4), "zb54");
    test_class_info(&lv, &cd_zb54);
    dp->~zb54();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb54(Test_zb54, "zb54", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN4zb54C1Ev();
extern void _ZN4zb54D1Ev();
Name_Map name_map_zb54[] = {
  NSPAIR(_ZN4zb54C1Ev),
  NSPAIR(_ZN4zb54D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_zb54[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_tk12,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb54[];
static  VTBL_ENTRY vtc_zb54[] = {
  ABISELECT(16,8),
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb54[0]),
  ABISELECT(8,4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zb54[0]),
};
extern VTBL_ENTRY _ZTV4zb54[];
static  VTBL_ENTRY _tg__ZTV4sk21__4zb54[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk12__4zb54[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTT_ENTRY vtt_zb54[] = {
  {&(_ZTV4zb54[5]),  5,8},
  {&(_tg__ZTV4sk21__4zb54[3]),  3,3},
  {&(_ZTV4zb54[8]),  8,8},
  {&(_tg__ZTV4tk12__4zb54[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb54[];
extern  VTBL_ENTRY _ZTV4zb54[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb54[];
Class_Descriptor cd_zb54 = {  "zb54", // class name
  bases_zb54, 6,
  &(vtc_zb54[0]), // expected_vtbl_contents
  &(vtt_zb54[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI4zb54),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb54),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb54),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc54  : virtual sk21 , tk12 {
  ~zc54(); // tgen
  zc54(); // tgen
};
//SIG(1 zc54) C1{ VBC2{ BC3{} VBC4{}} BC5{ VBC3 BC4}}


zc54 ::~zc54(){ note_dtor("zc54", this);} // tgen
zc54 ::zc54(){ note_ctor("zc54", this);} // tgen

static void Test_zc54()
{
  extern Class_Descriptor cd_zc54;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_zc54, buf);
    zc54 *dp, &lv = *(dp=new (buf) zc54());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(zc54)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc54)");
    check_base_class_offset(lv, (si*)(sk21*), ABISELECT(8,4), "zc54");
    check_base_class_offset(lv, (sj*)(sk21*), ABISELECT(16,8), "zc54");
    check_base_class_offset(lv, (sk21*), ABISELECT(8,4), "zc54");
    check_base_class_offset(lv, (si*)(tk12*), 0, "zc54");
    check_base_class_offset(lv, (sj*)(tk12*), 0, "zc54");
    check_base_class_offset(lv, (tk12*), 0, "zc54");
    test_class_info(&lv, &cd_zc54);
    dp->~zc54();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc54(Test_zc54, "zc54", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN4zc54C1Ev();
extern void _ZN4zc54D1Ev();
Name_Map name_map_zc54[] = {
  NSPAIR(_ZN4zc54C1Ev),
  NSPAIR(_ZN4zc54D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_zc54[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_tk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc54[];
static  VTBL_ENTRY vtc_zc54[] = {
  ABISELECT(16,8),
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc54[0]),
  ABISELECT(8,4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zc54[0]),
};
extern VTBL_ENTRY _ZTV4zc54[];
static  VTBL_ENTRY _tg__ZTV4tk12__4zc54[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTBL_ENTRY _tg__ZTV4sk21__4zc54[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTT_ENTRY vtt_zc54[] = {
  {&(_ZTV4zc54[5]),  5,8},
  {&(_tg__ZTV4tk12__4zc54[3]),  3,3},
  {&(_ZTV4zc54[8]),  8,8},
  {&(_tg__ZTV4sk21__4zc54[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc54[];
extern  VTBL_ENTRY _ZTV4zc54[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc54[];
Class_Descriptor cd_zc54 = {  "zc54", // class name
  bases_zc54, 6,
  &(vtc_zc54[0]), // expected_vtbl_contents
  &(vtt_zc54[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI4zc54),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc54),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc54),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd54  : virtual sk21 , virtual tk12 {
  ~zd54(); // tgen
  zd54(); // tgen
};
//SIG(1 zd54) C1{ VBC2{ BC3{} VBC4{}} VBC5{ VBC3 BC4}}


zd54 ::~zd54(){ note_dtor("zd54", this);} // tgen
zd54 ::zd54(){ note_ctor("zd54", this);} // tgen

static void Test_zd54()
{
  extern Class_Descriptor cd_zd54;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_zd54, buf);
    zd54 *dp, &lv = *(dp=new (buf) zd54());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(zd54)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd54)");
    check_base_class_offset(lv, (si*)(sk21*), 0, "zd54");
    check_base_class_offset(lv, (sj*)(sk21*), 0, "zd54");
    check_base_class_offset(lv, (sk21*), 0, "zd54");
    check_base_class_offset(lv, (si*)(tk12*), ABISELECT(16,8), "zd54");
    check_base_class_offset(lv, (sj*)(tk12*), ABISELECT(8,4), "zd54");
    check_base_class_offset(lv, (tk12*), ABISELECT(8,4), "zd54");
    test_class_info(&lv, &cd_zd54);
    dp->~zd54();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd54(Test_zd54, "zd54", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN4zd54C1Ev();
extern void _ZN4zd54D1Ev();
Name_Map name_map_zd54[] = {
  NSPAIR(_ZN4zd54C1Ev),
  NSPAIR(_ZN4zd54D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_zd54[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_tk12,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd54[];
static  VTBL_ENTRY vtc_zd54[] = {
  ABISELECT(16,8),
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd54[0]),
  ABISELECT(8,4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zd54[0]),
};
extern VTBL_ENTRY _ZTV4zd54[];
static  VTBL_ENTRY _tg__ZTV4sk21__4zd54[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk12__4zd54[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTT_ENTRY vtt_zd54[] = {
  {&(_ZTV4zd54[6]),  6,9},
  {&(_ZTV4zd54[6]),  6,9},
  {&(_ZTV4zd54[9]),  9,9},
  {&(_tg__ZTV4sk21__4zd54[3]),  3,3},
  {&(_tg__ZTV4tk12__4zd54[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd54[];
extern  VTBL_ENTRY _ZTV4zd54[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd54[];
Class_Descriptor cd_zd54 = {  "zd54", // class name
  bases_zd54, 6,
  &(vtc_zd54[0]), // expected_vtbl_contents
  &(vtt_zd54[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI4zd54),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd54),9, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd54),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za55  : sk21 , tk21 {
  ~za55(); // tgen
  za55(); // tgen
};
//SIG(1 za55) C1{ BC2{ BC3{} VBC4{}} BC5{ BC3 VBC4}}


za55 ::~za55(){ note_dtor("za55", this);} // tgen
za55 ::za55(){ note_ctor("za55", this);} // tgen

static void Test_za55()
{
  extern Class_Descriptor cd_za55;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za55, buf);
    za55 *dp, &lv = *(dp=new (buf) za55());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za55)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za55)");
    check_base_class_offset(lv, (si*)(sk21*), 0, "za55");
    check_base_class_offset(lv, (sj*)(sk21*), 0, "za55");
    check_base_class_offset(lv, (sj*)(tk21*), 0, "za55");
    check_base_class_offset(lv, (sk21*), 0, "za55");
    check_base_class_offset(lv, (si*)(tk21*), ABISELECT(8,4), "za55");
    check_base_class_offset(lv, (tk21*), ABISELECT(8,4), "za55");
    test_class_info(&lv, &cd_za55);
    dp->~za55();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza55(Test_za55, "za55", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za55C1Ev();
extern void _ZN4za55D1Ev();
Name_Map name_map_za55[] = {
  NSPAIR(_ZN4za55C1Ev),
  NSPAIR(_ZN4za55D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_za55[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk21,    ABISELECT(8,4), //bcp->offset
    3, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za55[];
static  VTBL_ENTRY vtc_za55[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za55[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4za55[0]),
};
extern VTBL_ENTRY _ZTV4za55[];
static  VTBL_ENTRY _tg__ZTV4sk21__4za55[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk21__4za55[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTT_ENTRY vtt_za55[] = {
  {&(_ZTV4za55[3]),  3,6},
  {&(_tg__ZTV4sk21__4za55[3]),  3,3},
  {&(_tg__ZTV4tk21__4za55[3]),  3,3},
  {&(_ZTV4za55[6]),  6,6},
};
extern VTBL_ENTRY _ZTI4za55[];
extern  VTBL_ENTRY _ZTV4za55[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za55[];
Class_Descriptor cd_za55 = {  "za55", // class name
  bases_za55, 5,
  &(vtc_za55[0]), // expected_vtbl_contents
  &(vtt_za55[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za55),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za55),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za55),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb55  : sk21 , virtual tk21 {
  ~zb55(); // tgen
  zb55(); // tgen
};
//SIG(1 zb55) C1{ BC2{ BC3{} VBC4{}} VBC5{ BC3 VBC4}}


zb55 ::~zb55(){ note_dtor("zb55", this);} // tgen
zb55 ::zb55(){ note_ctor("zb55", this);} // tgen

static void Test_zb55()
{
  extern Class_Descriptor cd_zb55;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb55, buf);
    zb55 *dp, &lv = *(dp=new (buf) zb55());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb55)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb55)");
    check_base_class_offset(lv, (si*)(sk21*), 0, "zb55");
    check_base_class_offset(lv, (sj*)(sk21*), 0, "zb55");
    check_base_class_offset(lv, (sj*)(tk21*), 0, "zb55");
    check_base_class_offset(lv, (sk21*), 0, "zb55");
    check_base_class_offset(lv, (si*)(tk21*), ABISELECT(8,4), "zb55");
    check_base_class_offset(lv, (tk21*), ABISELECT(8,4), "zb55");
    test_class_info(&lv, &cd_zb55);
    dp->~zb55();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb55(Test_zb55, "zb55", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb55C1Ev();
extern void _ZN4zb55D1Ev();
Name_Map name_map_zb55[] = {
  NSPAIR(_ZN4zb55C1Ev),
  NSPAIR(_ZN4zb55D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_zb55[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk21,    ABISELECT(8,4), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb55[];
static  VTBL_ENTRY vtc_zb55[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb55[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zb55[0]),
};
extern VTBL_ENTRY _ZTV4zb55[];
static  VTBL_ENTRY _tg__ZTV4sk21__4zb55[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk21__4zb55[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTT_ENTRY vtt_zb55[] = {
  {&(_ZTV4zb55[4]),  4,7},
  {&(_tg__ZTV4sk21__4zb55[3]),  3,3},
  {&(_ZTV4zb55[7]),  7,7},
  {&(_tg__ZTV4tk21__4zb55[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb55[];
extern  VTBL_ENTRY _ZTV4zb55[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb55[];
Class_Descriptor cd_zb55 = {  "zb55", // class name
  bases_zb55, 5,
  &(vtc_zb55[0]), // expected_vtbl_contents
  &(vtt_zb55[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb55),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb55),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb55),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc55  : virtual sk21 , tk21 {
  ~zc55(); // tgen
  zc55(); // tgen
};
//SIG(1 zc55) C1{ VBC2{ BC3{} VBC4{}} BC5{ BC3 VBC4}}


zc55 ::~zc55(){ note_dtor("zc55", this);} // tgen
zc55 ::zc55(){ note_ctor("zc55", this);} // tgen

static void Test_zc55()
{
  extern Class_Descriptor cd_zc55;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc55, buf);
    zc55 *dp, &lv = *(dp=new (buf) zc55());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc55)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc55)");
    check_base_class_offset(lv, (si*)(sk21*), ABISELECT(8,4), "zc55");
    check_base_class_offset(lv, (sj*)(sk21*), 0, "zc55");
    check_base_class_offset(lv, (sj*)(tk21*), 0, "zc55");
    check_base_class_offset(lv, (sk21*), ABISELECT(8,4), "zc55");
    check_base_class_offset(lv, (si*)(tk21*), 0, "zc55");
    check_base_class_offset(lv, (tk21*), 0, "zc55");
    test_class_info(&lv, &cd_zc55);
    dp->~zc55();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc55(Test_zc55, "zc55", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc55C1Ev();
extern void _ZN4zc55D1Ev();
Name_Map name_map_zc55[] = {
  NSPAIR(_ZN4zc55C1Ev),
  NSPAIR(_ZN4zc55D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_zc55[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    ABISELECT(8,4), //bcp->offset
    4, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc55[];
static  VTBL_ENTRY vtc_zc55[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc55[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zc55[0]),
};
extern VTBL_ENTRY _ZTV4zc55[];
static  VTBL_ENTRY _tg__ZTV4tk21__4zc55[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTBL_ENTRY _tg__ZTV4sk21__4zc55[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTT_ENTRY vtt_zc55[] = {
  {&(_ZTV4zc55[4]),  4,7},
  {&(_tg__ZTV4tk21__4zc55[3]),  3,3},
  {&(_ZTV4zc55[7]),  7,7},
  {&(_tg__ZTV4sk21__4zc55[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc55[];
extern  VTBL_ENTRY _ZTV4zc55[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc55[];
Class_Descriptor cd_zc55 = {  "zc55", // class name
  bases_zc55, 5,
  &(vtc_zc55[0]), // expected_vtbl_contents
  &(vtt_zc55[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc55),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc55),7, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc55),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd55  : virtual sk21 , virtual tk21 {
  ~zd55(); // tgen
  zd55(); // tgen
};
//SIG(1 zd55) C1{ VBC2{ BC3{} VBC4{}} VBC5{ BC3 VBC4}}


zd55 ::~zd55(){ note_dtor("zd55", this);} // tgen
zd55 ::zd55(){ note_ctor("zd55", this);} // tgen

static void Test_zd55()
{
  extern Class_Descriptor cd_zd55;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd55, buf);
    zd55 *dp, &lv = *(dp=new (buf) zd55());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd55)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd55)");
    check_base_class_offset(lv, (si*)(sk21*), 0, "zd55");
    check_base_class_offset(lv, (sj*)(sk21*), 0, "zd55");
    check_base_class_offset(lv, (sj*)(tk21*), 0, "zd55");
    check_base_class_offset(lv, (sk21*), 0, "zd55");
    check_base_class_offset(lv, (si*)(tk21*), ABISELECT(8,4), "zd55");
    check_base_class_offset(lv, (tk21*), ABISELECT(8,4), "zd55");
    test_class_info(&lv, &cd_zd55);
    dp->~zd55();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd55(Test_zd55, "zd55", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd55C1Ev();
extern void _ZN4zd55D1Ev();
Name_Map name_map_zd55[] = {
  NSPAIR(_ZN4zd55C1Ev),
  NSPAIR(_ZN4zd55D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_zd55[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk21,    ABISELECT(8,4), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd55[];
static  VTBL_ENTRY vtc_zd55[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd55[0]),
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI4zd55[0]),
};
extern VTBL_ENTRY _ZTV4zd55[];
static  VTBL_ENTRY _tg__ZTV4sk21__4zd55[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTBL_ENTRY _tg__ZTV4tk21__4zd55[] = {
  ABISELECT(-8,-4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTT_ENTRY vtt_zd55[] = {
  {&(_ZTV4zd55[5]),  5,8},
  {&(_ZTV4zd55[5]),  5,8},
  {&(_ZTV4zd55[8]),  8,8},
  {&(_tg__ZTV4sk21__4zd55[3]),  3,3},
  {&(_tg__ZTV4tk21__4zd55[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd55[];
extern  VTBL_ENTRY _ZTV4zd55[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd55[];
Class_Descriptor cd_zd55 = {  "zd55", // class name
  bases_zd55, 5,
  &(vtc_zd55[0]), // expected_vtbl_contents
  &(vtt_zd55[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd55),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd55),8, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd55),5, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za56  : sk21 , tk22 {
  ~za56(); // tgen
  za56(); // tgen
};
//SIG(1 za56) C1{ BC2{ BC3{} VBC4{}} BC5{ BC3 BC4}}


za56 ::~za56(){ note_dtor("za56", this);} // tgen
za56 ::za56(){ note_ctor("za56", this);} // tgen

static void Test_za56()
{
  extern Class_Descriptor cd_za56;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za56, buf);
    za56 *dp, &lv = *(dp=new (buf) za56());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za56)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za56)");
    check_base_class_offset(lv, (si*)(sk21*), 0, "za56");
    check_base_class_offset(lv, (sj*)(sk21*), 0, "za56");
    check_base_class_offset(lv, (sk21*), 0, "za56");
    check_base_class_offset(lv, (si*)(tk22*), ABISELECT(8,4), "za56");
    check_base_class_offset(lv, (sj*)(tk22*), ABISELECT(8,4), "za56");
    check_base_class_offset(lv, (tk22*), ABISELECT(8,4), "za56");
    test_class_info(&lv, &cd_za56);
    dp->~za56();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza56(Test_za56, "za56", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za56C1Ev();
extern void _ZN4za56D1Ev();
Name_Map name_map_za56[] = {
  NSPAIR(_ZN4za56C1Ev),
  NSPAIR(_ZN4za56D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_za56[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_tk22,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za56[];
static  VTBL_ENTRY vtc_za56[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za56[0]),
};
extern VTBL_ENTRY _ZTV4za56[];
static  VTBL_ENTRY _tg__ZTV4sk21__4za56[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTT_ENTRY vtt_za56[] = {
  {&(_ZTV4za56[3]),  3,3},
  {&(_tg__ZTV4sk21__4za56[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4za56[];
extern  VTBL_ENTRY _ZTV4za56[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za56[];
Class_Descriptor cd_za56 = {  "za56", // class name
  bases_za56, 6,
  &(vtc_za56[0]), // expected_vtbl_contents
  &(vtt_za56[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za56),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za56),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za56),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb56  : sk21 , virtual tk22 {
  ~zb56(); // tgen
  zb56(); // tgen
};
//SIG(1 zb56) C1{ BC2{ BC3{} VBC4{}} VBC5{ BC3 BC4}}


zb56 ::~zb56(){ note_dtor("zb56", this);} // tgen
zb56 ::zb56(){ note_ctor("zb56", this);} // tgen

static void Test_zb56()
{
  extern Class_Descriptor cd_zb56;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb56, buf);
    zb56 *dp, &lv = *(dp=new (buf) zb56());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb56)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb56)");
    check_base_class_offset(lv, (si*)(sk21*), 0, "zb56");
    check_base_class_offset(lv, (sj*)(sk21*), 0, "zb56");
    check_base_class_offset(lv, (sk21*), 0, "zb56");
    check_base_class_offset(lv, (si*)(tk22*), ABISELECT(8,4), "zb56");
    check_base_class_offset(lv, (sj*)(tk22*), ABISELECT(8,4), "zb56");
    check_base_class_offset(lv, (tk22*), ABISELECT(8,4), "zb56");
    test_class_info(&lv, &cd_zb56);
    dp->~zb56();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb56(Test_zb56, "zb56", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb56C1Ev();
extern void _ZN4zb56D1Ev();
Name_Map name_map_zb56[] = {
  NSPAIR(_ZN4zb56C1Ev),
  NSPAIR(_ZN4zb56D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_zb56[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_tk22,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb56[];
static  VTBL_ENTRY vtc_zb56[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb56[0]),
};
extern VTBL_ENTRY _ZTV4zb56[];
static  VTBL_ENTRY _tg__ZTV4sk21__4zb56[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTT_ENTRY vtt_zb56[] = {
  {&(_ZTV4zb56[4]),  4,4},
  {&(_tg__ZTV4sk21__4zb56[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb56[];
extern  VTBL_ENTRY _ZTV4zb56[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb56[];
Class_Descriptor cd_zb56 = {  "zb56", // class name
  bases_zb56, 6,
  &(vtc_zb56[0]), // expected_vtbl_contents
  &(vtt_zb56[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb56),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb56),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb56),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc56  : virtual sk21 , tk22 {
  ~zc56(); // tgen
  zc56(); // tgen
};
//SIG(1 zc56) C1{ VBC2{ BC3{} VBC4{}} BC5{ BC3 BC4}}


zc56 ::~zc56(){ note_dtor("zc56", this);} // tgen
zc56 ::zc56(){ note_ctor("zc56", this);} // tgen

static void Test_zc56()
{
  extern Class_Descriptor cd_zc56;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc56, buf);
    zc56 *dp, &lv = *(dp=new (buf) zc56());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc56)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc56)");
    check_base_class_offset(lv, (si*)(sk21*), 0, "zc56");
    check_base_class_offset(lv, (sj*)(sk21*), 0, "zc56");
    check_base_class_offset(lv, (sk21*), 0, "zc56");
    check_base_class_offset(lv, (si*)(tk22*), ABISELECT(8,4), "zc56");
    check_base_class_offset(lv, (sj*)(tk22*), ABISELECT(8,4), "zc56");
    check_base_class_offset(lv, (tk22*), ABISELECT(8,4), "zc56");
    test_class_info(&lv, &cd_zc56);
    dp->~zc56();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc56(Test_zc56, "zc56", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc56C1Ev();
extern void _ZN4zc56D1Ev();
Name_Map name_map_zc56[] = {
  NSPAIR(_ZN4zc56C1Ev),
  NSPAIR(_ZN4zc56D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_zc56[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_tk22,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc56[];
static  VTBL_ENTRY vtc_zc56[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc56[0]),
};
extern VTBL_ENTRY _ZTV4zc56[];
static  VTBL_ENTRY _tg__ZTV4sk21__4zc56[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTT_ENTRY vtt_zc56[] = {
  {&(_ZTV4zc56[4]),  4,4},
  {&(_ZTV4zc56[4]),  4,4},
  {&(_tg__ZTV4sk21__4zc56[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc56[];
extern  VTBL_ENTRY _ZTV4zc56[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc56[];
Class_Descriptor cd_zc56 = {  "zc56", // class name
  bases_zc56, 6,
  &(vtc_zc56[0]), // expected_vtbl_contents
  &(vtt_zc56[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc56),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc56),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc56),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd56  : virtual sk21 , virtual tk22 {
  ~zd56(); // tgen
  zd56(); // tgen
};
//SIG(1 zd56) C1{ VBC2{ BC3{} VBC4{}} VBC5{ BC3 BC4}}


zd56 ::~zd56(){ note_dtor("zd56", this);} // tgen
zd56 ::zd56(){ note_ctor("zd56", this);} // tgen

static void Test_zd56()
{
  extern Class_Descriptor cd_zd56;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd56, buf);
    zd56 *dp, &lv = *(dp=new (buf) zd56());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd56)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd56)");
    check_base_class_offset(lv, (si*)(sk21*), 0, "zd56");
    check_base_class_offset(lv, (sj*)(sk21*), 0, "zd56");
    check_base_class_offset(lv, (sk21*), 0, "zd56");
    check_base_class_offset(lv, (si*)(tk22*), ABISELECT(8,4), "zd56");
    check_base_class_offset(lv, (sj*)(tk22*), ABISELECT(8,4), "zd56");
    check_base_class_offset(lv, (tk22*), ABISELECT(8,4), "zd56");
    test_class_info(&lv, &cd_zd56);
    dp->~zd56();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd56(Test_zd56, "zd56", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd56C1Ev();
extern void _ZN4zd56D1Ev();
Name_Map name_map_zd56[] = {
  NSPAIR(_ZN4zd56C1Ev),
  NSPAIR(_ZN4zd56D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk21;
extern VTBL_ENTRY _ZTI4sk21[];
extern  VTBL_ENTRY _ZTV4sk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4sk21[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_zd56[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_sk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_tk22,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd56[];
static  VTBL_ENTRY vtc_zd56[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd56[0]),
};
extern VTBL_ENTRY _ZTV4zd56[];
static  VTBL_ENTRY _tg__ZTV4sk21__4zd56[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4sk21[0]),
};
static  VTT_ENTRY vtt_zd56[] = {
  {&(_ZTV4zd56[5]),  5,5},
  {&(_ZTV4zd56[5]),  5,5},
  {&(_tg__ZTV4sk21__4zd56[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd56[];
extern  VTBL_ENTRY _ZTV4zd56[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd56[];
Class_Descriptor cd_zd56 = {  "zd56", // class name
  bases_zd56, 6,
  &(vtc_zd56[0]), // expected_vtbl_contents
  &(vtt_zd56[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd56),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd56),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd56),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  xt6  : tk22 {
};
//SIG(1 xt6) C1{ BC2{ BC3{} BC4{}}}



static void Test_xt6()
{
  extern Class_Descriptor cd_xt6;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_xt6, buf);
    xt6 &lv = *(new (buf) xt6());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(xt6)");
    check2(__alignof__(lv), 1, "__alignof__(xt6)");
    check_base_class_offset(lv, (si*)(tk22*), 0, "xt6");
    check_base_class_offset(lv, (sj*)(tk22*), 0, "xt6");
    check_base_class_offset(lv, (tk22*), 0, "xt6");
    test_class_info(&lv, &cd_xt6);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vxt6(Test_xt6, "xt6", 1);

#else // __cplusplus

extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_xt6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_tk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_xt6 = {  "xt6", // class name
  bases_xt6, 3,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  yt6  : virtual tk22 {
  ~yt6(); // tgen
  yt6(); // tgen
};
//SIG(1 yt6) C1{ VBC2{ BC3{} BC4{}}}


yt6 ::~yt6(){ note_dtor("yt6", this);} // tgen
yt6 ::yt6(){ note_ctor("yt6", this);} // tgen

static void Test_yt6()
{
  extern Class_Descriptor cd_yt6;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_yt6, buf);
    yt6 *dp, &lv = *(dp=new (buf) yt6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(yt6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(yt6)");
    check_base_class_offset(lv, (si*)(tk22*), 0, "yt6");
    check_base_class_offset(lv, (sj*)(tk22*), 0, "yt6");
    check_base_class_offset(lv, (tk22*), 0, "yt6");
    test_class_info(&lv, &cd_yt6);
    dp->~yt6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vyt6(Test_yt6, "yt6", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN3yt6C1Ev();
extern void _ZN3yt6D1Ev();
Name_Map name_map_yt6[] = {
  NSPAIR(_ZN3yt6C1Ev),
  NSPAIR(_ZN3yt6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_yt6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_tk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI3yt6[];
static  VTBL_ENTRY vtc_yt6[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI3yt6[0]),
};
extern VTBL_ENTRY _ZTV3yt6[];
static  VTT_ENTRY vtt_yt6[] = {
  {&(_ZTV3yt6[3]),  3,3},
};
extern VTBL_ENTRY _ZTI3yt6[];
extern  VTBL_ENTRY _ZTV3yt6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT3yt6[];
Class_Descriptor cd_yt6 = {  "yt6", // class name
  bases_yt6, 3,
  &(vtc_yt6[0]), // expected_vtbl_contents
  &(vtt_yt6[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI3yt6),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV3yt6),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT3yt6),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za60  : sk22 , tk00 {
};
//SIG(1 za60) C1{ BC2{ BC3{} BC4{}} BC5{}}



static void Test_za60()
{
  extern Class_Descriptor cd_za60;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_za60, buf);
    za60 &lv = *(new (buf) za60());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(za60)");
    check2(__alignof__(lv), 1, "__alignof__(za60)");
    check_base_class_offset(lv, (si*)(sk22*), 0, "za60");
    check_base_class_offset(lv, (sj*)(sk22*), 0, "za60");
    check_base_class_offset(lv, (sk22*), 0, "za60");
    check_base_class_offset(lv, (tk00*), 0, "za60");
    test_class_info(&lv, &cd_za60);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza60(Test_za60, "za60", 1);

#else // __cplusplus

extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_za60[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_za60 = {  "za60", // class name
  bases_za60, 4,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb60  : sk22 , virtual tk00 {
  ~zb60(); // tgen
  zb60(); // tgen
};
//SIG(1 zb60) C1{ BC2{ BC3{} BC4{}} VBC5{}}


zb60 ::~zb60(){ note_dtor("zb60", this);} // tgen
zb60 ::zb60(){ note_ctor("zb60", this);} // tgen

static void Test_zb60()
{
  extern Class_Descriptor cd_zb60;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zb60, buf);
    zb60 *dp, &lv = *(dp=new (buf) zb60());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zb60)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb60)");
    check_base_class_offset(lv, (si*)(sk22*), 0, "zb60");
    check_base_class_offset(lv, (sj*)(sk22*), 0, "zb60");
    check_base_class_offset(lv, (sk22*), 0, "zb60");
    check_base_class_offset(lv, (tk00*), 0, "zb60");
    test_class_info(&lv, &cd_zb60);
    dp->~zb60();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb60(Test_zb60, "zb60", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zb60C1Ev();
extern void _ZN4zb60D1Ev();
Name_Map name_map_zb60[] = {
  NSPAIR(_ZN4zb60C1Ev),
  NSPAIR(_ZN4zb60D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_zb60[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb60[];
static  VTBL_ENTRY vtc_zb60[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb60[0]),
};
extern VTBL_ENTRY _ZTV4zb60[];
static  VTT_ENTRY vtt_zb60[] = {
  {&(_ZTV4zb60[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb60[];
extern  VTBL_ENTRY _ZTV4zb60[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb60[];
Class_Descriptor cd_zb60 = {  "zb60", // class name
  bases_zb60, 4,
  &(vtc_zb60[0]), // expected_vtbl_contents
  &(vtt_zb60[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zb60),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb60),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb60),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc60  : virtual sk22 , tk00 {
  ~zc60(); // tgen
  zc60(); // tgen
};
//SIG(1 zc60) C1{ VBC2{ BC3{} BC4{}} BC5{}}


zc60 ::~zc60(){ note_dtor("zc60", this);} // tgen
zc60 ::zc60(){ note_ctor("zc60", this);} // tgen

static void Test_zc60()
{
  extern Class_Descriptor cd_zc60;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zc60, buf);
    zc60 *dp, &lv = *(dp=new (buf) zc60());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zc60)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc60)");
    check_base_class_offset(lv, (si*)(sk22*), 0, "zc60");
    check_base_class_offset(lv, (sj*)(sk22*), 0, "zc60");
    check_base_class_offset(lv, (sk22*), 0, "zc60");
    check_base_class_offset(lv, (tk00*), 0, "zc60");
    test_class_info(&lv, &cd_zc60);
    dp->~zc60();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc60(Test_zc60, "zc60", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zc60C1Ev();
extern void _ZN4zc60D1Ev();
Name_Map name_map_zc60[] = {
  NSPAIR(_ZN4zc60C1Ev),
  NSPAIR(_ZN4zc60D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_zc60[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc60[];
static  VTBL_ENTRY vtc_zc60[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc60[0]),
};
extern VTBL_ENTRY _ZTV4zc60[];
static  VTT_ENTRY vtt_zc60[] = {
  {&(_ZTV4zc60[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc60[];
extern  VTBL_ENTRY _ZTV4zc60[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc60[];
Class_Descriptor cd_zc60 = {  "zc60", // class name
  bases_zc60, 4,
  &(vtc_zc60[0]), // expected_vtbl_contents
  &(vtt_zc60[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zc60),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc60),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc60),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd60  : virtual sk22 , virtual tk00 {
  ~zd60(); // tgen
  zd60(); // tgen
};
//SIG(1 zd60) C1{ VBC2{ BC3{} BC4{}} VBC5{}}


zd60 ::~zd60(){ note_dtor("zd60", this);} // tgen
zd60 ::zd60(){ note_ctor("zd60", this);} // tgen

static void Test_zd60()
{
  extern Class_Descriptor cd_zd60;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_zd60, buf);
    zd60 *dp, &lv = *(dp=new (buf) zd60());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(zd60)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd60)");
    check_base_class_offset(lv, (si*)(sk22*), 0, "zd60");
    check_base_class_offset(lv, (sj*)(sk22*), 0, "zd60");
    check_base_class_offset(lv, (sk22*), 0, "zd60");
    check_base_class_offset(lv, (tk00*), 0, "zd60");
    test_class_info(&lv, &cd_zd60);
    dp->~zd60();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd60(Test_zd60, "zd60", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN4zd60C1Ev();
extern void _ZN4zd60D1Ev();
Name_Map name_map_zd60[] = {
  NSPAIR(_ZN4zd60C1Ev),
  NSPAIR(_ZN4zd60D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_tk00;
extern VTBL_ENTRY _ZTI4tk00[];
static Base_Class bases_zd60[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_tk00,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd60[];
static  VTBL_ENTRY vtc_zd60[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd60[0]),
};
extern VTBL_ENTRY _ZTV4zd60[];
static  VTT_ENTRY vtt_zd60[] = {
  {&(_ZTV4zd60[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zd60[];
extern  VTBL_ENTRY _ZTV4zd60[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd60[];
Class_Descriptor cd_zd60 = {  "zd60", // class name
  bases_zd60, 4,
  &(vtc_zd60[0]), // expected_vtbl_contents
  &(vtt_zd60[0]), // expected_vtt_contents
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI4zd60),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd60),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd60),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za61  : sk22 , tk01 {
  ~za61(); // tgen
  za61(); // tgen
};
//SIG(1 za61) C1{ BC2{ BC3{} BC4{}} BC5{ VBC4}}


za61 ::~za61(){ note_dtor("za61", this);} // tgen
za61 ::za61(){ note_ctor("za61", this);} // tgen

static void Test_za61()
{
  extern Class_Descriptor cd_za61;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za61, buf);
    za61 *dp, &lv = *(dp=new (buf) za61());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za61)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za61)");
    check_base_class_offset(lv, (si*)(sk22*), 0, "za61");
    check_base_class_offset(lv, (sj*)(sk22*), 0, "za61");
    check_base_class_offset(lv, (sk22*), 0, "za61");
    check_base_class_offset(lv, (sj*)(tk01*), ABISELECT(8,4), "za61");
    check_base_class_offset(lv, (tk01*), 0, "za61");
    test_class_info(&lv, &cd_za61);
    dp->~za61();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza61(Test_za61, "za61", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za61C1Ev();
extern void _ZN4za61D1Ev();
Name_Map name_map_za61[] = {
  NSPAIR(_ZN4za61C1Ev),
  NSPAIR(_ZN4za61D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_za61[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_tk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za61[];
static  VTBL_ENTRY vtc_za61[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4za61[0]),
};
extern VTBL_ENTRY _ZTV4za61[];
static  VTBL_ENTRY _tg__ZTV4tk01__4za61[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTT_ENTRY vtt_za61[] = {
  {&(_ZTV4za61[3]),  3,3},
  {&(_tg__ZTV4tk01__4za61[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4za61[];
extern  VTBL_ENTRY _ZTV4za61[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za61[];
Class_Descriptor cd_za61 = {  "za61", // class name
  bases_za61, 5,
  &(vtc_za61[0]), // expected_vtbl_contents
  &(vtt_za61[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za61),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za61),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za61),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb61  : sk22 , virtual tk01 {
  ~zb61(); // tgen
  zb61(); // tgen
};
//SIG(1 zb61) C1{ BC2{ BC3{} BC4{}} VBC5{ VBC4}}


zb61 ::~zb61(){ note_dtor("zb61", this);} // tgen
zb61 ::zb61(){ note_ctor("zb61", this);} // tgen

static void Test_zb61()
{
  extern Class_Descriptor cd_zb61;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb61, buf);
    zb61 *dp, &lv = *(dp=new (buf) zb61());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb61)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb61)");
    check_base_class_offset(lv, (si*)(sk22*), 0, "zb61");
    check_base_class_offset(lv, (sj*)(sk22*), 0, "zb61");
    check_base_class_offset(lv, (sk22*), 0, "zb61");
    check_base_class_offset(lv, (sj*)(tk01*), ABISELECT(8,4), "zb61");
    check_base_class_offset(lv, (tk01*), 0, "zb61");
    test_class_info(&lv, &cd_zb61);
    dp->~zb61();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb61(Test_zb61, "zb61", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb61C1Ev();
extern void _ZN4zb61D1Ev();
Name_Map name_map_zb61[] = {
  NSPAIR(_ZN4zb61C1Ev),
  NSPAIR(_ZN4zb61D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_zb61[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_tk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb61[];
static  VTBL_ENTRY vtc_zb61[] = {
  0,
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4zb61[0]),
};
extern VTBL_ENTRY _ZTV4zb61[];
static  VTBL_ENTRY _tg__ZTV4tk01__4zb61[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTT_ENTRY vtt_zb61[] = {
  {&(_ZTV4zb61[4]),  4,4},
  {&(_ZTV4zb61[4]),  4,4},
  {&(_tg__ZTV4tk01__4zb61[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb61[];
extern  VTBL_ENTRY _ZTV4zb61[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb61[];
Class_Descriptor cd_zb61 = {  "zb61", // class name
  bases_zb61, 5,
  &(vtc_zb61[0]), // expected_vtbl_contents
  &(vtt_zb61[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb61),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb61),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb61),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc61  : virtual sk22 , tk01 {
  ~zc61(); // tgen
  zc61(); // tgen
};
//SIG(1 zc61) C1{ VBC2{ BC3{} BC4{}} BC5{ VBC4}}


zc61 ::~zc61(){ note_dtor("zc61", this);} // tgen
zc61 ::zc61(){ note_ctor("zc61", this);} // tgen

static void Test_zc61()
{
  extern Class_Descriptor cd_zc61;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc61, buf);
    zc61 *dp, &lv = *(dp=new (buf) zc61());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc61)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc61)");
    check_base_class_offset(lv, (si*)(sk22*), 0, "zc61");
    check_base_class_offset(lv, (sj*)(sk22*), 0, "zc61");
    check_base_class_offset(lv, (sk22*), 0, "zc61");
    check_base_class_offset(lv, (sj*)(tk01*), ABISELECT(8,4), "zc61");
    check_base_class_offset(lv, (tk01*), 0, "zc61");
    test_class_info(&lv, &cd_zc61);
    dp->~zc61();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc61(Test_zc61, "zc61", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc61C1Ev();
extern void _ZN4zc61D1Ev();
Name_Map name_map_zc61[] = {
  NSPAIR(_ZN4zc61C1Ev),
  NSPAIR(_ZN4zc61D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_zc61[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_tk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc61[];
static  VTBL_ENTRY vtc_zc61[] = {
  0,
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4zc61[0]),
};
extern VTBL_ENTRY _ZTV4zc61[];
static  VTBL_ENTRY _tg__ZTV4tk01__4zc61[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTT_ENTRY vtt_zc61[] = {
  {&(_ZTV4zc61[4]),  4,4},
  {&(_tg__ZTV4tk01__4zc61[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc61[];
extern  VTBL_ENTRY _ZTV4zc61[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc61[];
Class_Descriptor cd_zc61 = {  "zc61", // class name
  bases_zc61, 5,
  &(vtc_zc61[0]), // expected_vtbl_contents
  &(vtt_zc61[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc61),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc61),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc61),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd61  : virtual sk22 , virtual tk01 {
  ~zd61(); // tgen
  zd61(); // tgen
};
//SIG(1 zd61) C1{ VBC2{ BC3{} BC4{}} VBC5{ VBC4}}


zd61 ::~zd61(){ note_dtor("zd61", this);} // tgen
zd61 ::zd61(){ note_ctor("zd61", this);} // tgen

static void Test_zd61()
{
  extern Class_Descriptor cd_zd61;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd61, buf);
    zd61 *dp, &lv = *(dp=new (buf) zd61());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd61)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd61)");
    check_base_class_offset(lv, (si*)(sk22*), 0, "zd61");
    check_base_class_offset(lv, (sj*)(sk22*), 0, "zd61");
    check_base_class_offset(lv, (sk22*), 0, "zd61");
    check_base_class_offset(lv, (sj*)(tk01*), ABISELECT(8,4), "zd61");
    check_base_class_offset(lv, (tk01*), 0, "zd61");
    test_class_info(&lv, &cd_zd61);
    dp->~zd61();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd61(Test_zd61, "zd61", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd61C1Ev();
extern void _ZN4zd61D1Ev();
Name_Map name_map_zd61[] = {
  NSPAIR(_ZN4zd61C1Ev),
  NSPAIR(_ZN4zd61D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk01;
extern VTBL_ENTRY _ZTI4tk01[];
extern  VTBL_ENTRY _ZTV4tk01[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk01[];
static Base_Class bases_zd61[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_tk01,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd61[];
static  VTBL_ENTRY vtc_zd61[] = {
  0,
  0,
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4zd61[0]),
};
extern VTBL_ENTRY _ZTV4zd61[];
static  VTBL_ENTRY _tg__ZTV4tk01__4zd61[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk01[0]),
};
static  VTT_ENTRY vtt_zd61[] = {
  {&(_ZTV4zd61[5]),  5,5},
  {&(_ZTV4zd61[5]),  5,5},
  {&(_tg__ZTV4tk01__4zd61[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd61[];
extern  VTBL_ENTRY _ZTV4zd61[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd61[];
Class_Descriptor cd_zd61 = {  "zd61", // class name
  bases_zd61, 5,
  &(vtc_zd61[0]), // expected_vtbl_contents
  &(vtt_zd61[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd61),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd61),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd61),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za62  : sk22 , tk02 {
};
//SIG(1 za62) C1{ BC2{ BC3{} BC4{}} BC5{ BC4}}



static void Test_za62()
{
  extern Class_Descriptor cd_za62;
  void *lvp;
  {
    char buf[2];
    init_test(&cd_za62, buf);
    za62 &lv = *(new (buf) za62());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(za62)");
    check2(__alignof__(lv), 1, "__alignof__(za62)");
    check_base_class_offset(lv, (si*)(sk22*), 0, "za62");
    check_base_class_offset(lv, (sj*)(sk22*), 0, "za62");
    check_base_class_offset(lv, (sk22*), 0, "za62");
    check_base_class_offset(lv, (sj*)(tk02*), 1, "za62");
    check_base_class_offset(lv, (tk02*), 1, "za62");
    test_class_info(&lv, &cd_za62);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza62(Test_za62, "za62", 2);

#else // __cplusplus

extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_za62[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk02,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_za62 = {  "za62", // class name
  bases_za62, 5,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb62  : sk22 , virtual tk02 {
  ~zb62(); // tgen
  zb62(); // tgen
};
//SIG(1 zb62) C1{ BC2{ BC3{} BC4{}} VBC5{ BC4}}


zb62 ::~zb62(){ note_dtor("zb62", this);} // tgen
zb62 ::zb62(){ note_ctor("zb62", this);} // tgen

static void Test_zb62()
{
  extern Class_Descriptor cd_zb62;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb62, buf);
    zb62 *dp, &lv = *(dp=new (buf) zb62());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb62)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb62)");
    check_base_class_offset(lv, (si*)(sk22*), 0, "zb62");
    check_base_class_offset(lv, (sj*)(sk22*), 0, "zb62");
    check_base_class_offset(lv, (sk22*), 0, "zb62");
    check_base_class_offset(lv, (sj*)(tk02*), ABISELECT(8,4), "zb62");
    check_base_class_offset(lv, (tk02*), ABISELECT(8,4), "zb62");
    test_class_info(&lv, &cd_zb62);
    dp->~zb62();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb62(Test_zb62, "zb62", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb62C1Ev();
extern void _ZN4zb62D1Ev();
Name_Map name_map_zb62[] = {
  NSPAIR(_ZN4zb62C1Ev),
  NSPAIR(_ZN4zb62D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_zb62[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk02,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb62[];
static  VTBL_ENTRY vtc_zb62[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4zb62[0]),
};
extern VTBL_ENTRY _ZTV4zb62[];
static  VTT_ENTRY vtt_zb62[] = {
  {&(_ZTV4zb62[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb62[];
extern  VTBL_ENTRY _ZTV4zb62[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb62[];
Class_Descriptor cd_zb62 = {  "zb62", // class name
  bases_zb62, 5,
  &(vtc_zb62[0]), // expected_vtbl_contents
  &(vtt_zb62[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb62),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb62),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb62),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc62  : virtual sk22 , tk02 {
  ~zc62(); // tgen
  zc62(); // tgen
};
//SIG(1 zc62) C1{ VBC2{ BC3{} BC4{}} BC5{ BC4}}


zc62 ::~zc62(){ note_dtor("zc62", this);} // tgen
zc62 ::zc62(){ note_ctor("zc62", this);} // tgen

static void Test_zc62()
{
  extern Class_Descriptor cd_zc62;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc62, buf);
    zc62 *dp, &lv = *(dp=new (buf) zc62());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc62)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc62)");
    check_base_class_offset(lv, (si*)(sk22*), ABISELECT(8,4), "zc62");
    check_base_class_offset(lv, (sj*)(sk22*), ABISELECT(8,4), "zc62");
    check_base_class_offset(lv, (sk22*), ABISELECT(8,4), "zc62");
    check_base_class_offset(lv, (sj*)(tk02*), 0, "zc62");
    check_base_class_offset(lv, (tk02*), 0, "zc62");
    test_class_info(&lv, &cd_zc62);
    dp->~zc62();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc62(Test_zc62, "zc62", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc62C1Ev();
extern void _ZN4zc62D1Ev();
Name_Map name_map_zc62[] = {
  NSPAIR(_ZN4zc62C1Ev),
  NSPAIR(_ZN4zc62D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_zc62[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk02,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc62[];
static  VTBL_ENTRY vtc_zc62[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4zc62[0]),
};
extern VTBL_ENTRY _ZTV4zc62[];
static  VTT_ENTRY vtt_zc62[] = {
  {&(_ZTV4zc62[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc62[];
extern  VTBL_ENTRY _ZTV4zc62[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc62[];
Class_Descriptor cd_zc62 = {  "zc62", // class name
  bases_zc62, 5,
  &(vtc_zc62[0]), // expected_vtbl_contents
  &(vtt_zc62[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc62),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc62),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc62),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd62  : virtual sk22 , virtual tk02 {
  ~zd62(); // tgen
  zd62(); // tgen
};
//SIG(1 zd62) C1{ VBC2{ BC3{} BC4{}} VBC5{ BC4}}


zd62 ::~zd62(){ note_dtor("zd62", this);} // tgen
zd62 ::zd62(){ note_ctor("zd62", this);} // tgen

static void Test_zd62()
{
  extern Class_Descriptor cd_zd62;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd62, buf);
    zd62 *dp, &lv = *(dp=new (buf) zd62());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd62)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd62)");
    check_base_class_offset(lv, (si*)(sk22*), 0, "zd62");
    check_base_class_offset(lv, (sj*)(sk22*), 0, "zd62");
    check_base_class_offset(lv, (sk22*), 0, "zd62");
    check_base_class_offset(lv, (sj*)(tk02*), ABISELECT(8,4), "zd62");
    check_base_class_offset(lv, (tk02*), ABISELECT(8,4), "zd62");
    test_class_info(&lv, &cd_zd62);
    dp->~zd62();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd62(Test_zd62, "zd62", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd62C1Ev();
extern void _ZN4zd62D1Ev();
Name_Map name_map_zd62[] = {
  NSPAIR(_ZN4zd62C1Ev),
  NSPAIR(_ZN4zd62D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk02;
extern VTBL_ENTRY _ZTI4tk02[];
static Base_Class bases_zd62[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_tk02,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd62[];
static  VTBL_ENTRY vtc_zd62[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd62[0]),
};
extern VTBL_ENTRY _ZTV4zd62[];
static  VTT_ENTRY vtt_zd62[] = {
  {&(_ZTV4zd62[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zd62[];
extern  VTBL_ENTRY _ZTV4zd62[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd62[];
Class_Descriptor cd_zd62 = {  "zd62", // class name
  bases_zd62, 5,
  &(vtc_zd62[0]), // expected_vtbl_contents
  &(vtt_zd62[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd62),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd62),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd62),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za63  : sk22 , tk11 {
  ~za63(); // tgen
  za63(); // tgen
};
//SIG(1 za63) C1{ BC2{ BC3{} BC4{}} BC5{ VBC3 VBC4}}


za63 ::~za63(){ note_dtor("za63", this);} // tgen
za63 ::za63(){ note_ctor("za63", this);} // tgen

static void Test_za63()
{
  extern Class_Descriptor cd_za63;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za63, buf);
    za63 *dp, &lv = *(dp=new (buf) za63());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za63)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za63)");
    check_base_class_offset(lv, (si*)(sk22*), 0, "za63");
    check_base_class_offset(lv, (sj*)(sk22*), 0, "za63");
    check_base_class_offset(lv, (sk22*), 0, "za63");
    check_base_class_offset(lv, (si*)(tk11*), ABISELECT(8,4), "za63");
    check_base_class_offset(lv, (sj*)(tk11*), ABISELECT(8,4), "za63");
    check_base_class_offset(lv, (tk11*), 0, "za63");
    test_class_info(&lv, &cd_za63);
    dp->~za63();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza63(Test_za63, "za63", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za63C1Ev();
extern void _ZN4za63D1Ev();
Name_Map name_map_za63[] = {
  NSPAIR(_ZN4za63C1Ev),
  NSPAIR(_ZN4za63D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_za63[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_tk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za63[];
static  VTBL_ENTRY vtc_za63[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4za63[0]),
};
extern VTBL_ENTRY _ZTV4za63[];
static  VTBL_ENTRY _tg__ZTV4tk11__4za63[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTT_ENTRY vtt_za63[] = {
  {&(_ZTV4za63[4]),  4,4},
  {&(_tg__ZTV4tk11__4za63[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4za63[];
extern  VTBL_ENTRY _ZTV4za63[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za63[];
Class_Descriptor cd_za63 = {  "za63", // class name
  bases_za63, 6,
  &(vtc_za63[0]), // expected_vtbl_contents
  &(vtt_za63[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za63),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za63),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za63),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb63  : sk22 , virtual tk11 {
  ~zb63(); // tgen
  zb63(); // tgen
};
//SIG(1 zb63) C1{ BC2{ BC3{} BC4{}} VBC5{ VBC3 VBC4}}


zb63 ::~zb63(){ note_dtor("zb63", this);} // tgen
zb63 ::zb63(){ note_ctor("zb63", this);} // tgen

static void Test_zb63()
{
  extern Class_Descriptor cd_zb63;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb63, buf);
    zb63 *dp, &lv = *(dp=new (buf) zb63());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb63)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb63)");
    check_base_class_offset(lv, (si*)(sk22*), 0, "zb63");
    check_base_class_offset(lv, (sj*)(sk22*), 0, "zb63");
    check_base_class_offset(lv, (sk22*), 0, "zb63");
    check_base_class_offset(lv, (si*)(tk11*), ABISELECT(8,4), "zb63");
    check_base_class_offset(lv, (sj*)(tk11*), ABISELECT(8,4), "zb63");
    check_base_class_offset(lv, (tk11*), 0, "zb63");
    test_class_info(&lv, &cd_zb63);
    dp->~zb63();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb63(Test_zb63, "zb63", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb63C1Ev();
extern void _ZN4zb63D1Ev();
Name_Map name_map_zb63[] = {
  NSPAIR(_ZN4zb63C1Ev),
  NSPAIR(_ZN4zb63D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_zb63[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_tk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb63[];
static  VTBL_ENTRY vtc_zb63[] = {
  0,
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4zb63[0]),
};
extern VTBL_ENTRY _ZTV4zb63[];
static  VTBL_ENTRY _tg__ZTV4tk11__4zb63[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTT_ENTRY vtt_zb63[] = {
  {&(_ZTV4zb63[5]),  5,5},
  {&(_ZTV4zb63[5]),  5,5},
  {&(_tg__ZTV4tk11__4zb63[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zb63[];
extern  VTBL_ENTRY _ZTV4zb63[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb63[];
Class_Descriptor cd_zb63 = {  "zb63", // class name
  bases_zb63, 6,
  &(vtc_zb63[0]), // expected_vtbl_contents
  &(vtt_zb63[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb63),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb63),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb63),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc63  : virtual sk22 , tk11 {
  ~zc63(); // tgen
  zc63(); // tgen
};
//SIG(1 zc63) C1{ VBC2{ BC3{} BC4{}} BC5{ VBC3 VBC4}}


zc63 ::~zc63(){ note_dtor("zc63", this);} // tgen
zc63 ::zc63(){ note_ctor("zc63", this);} // tgen

static void Test_zc63()
{
  extern Class_Descriptor cd_zc63;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc63, buf);
    zc63 *dp, &lv = *(dp=new (buf) zc63());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc63)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc63)");
    check_base_class_offset(lv, (si*)(sk22*), 0, "zc63");
    check_base_class_offset(lv, (sj*)(sk22*), 0, "zc63");
    check_base_class_offset(lv, (sk22*), 0, "zc63");
    check_base_class_offset(lv, (si*)(tk11*), ABISELECT(8,4), "zc63");
    check_base_class_offset(lv, (sj*)(tk11*), ABISELECT(8,4), "zc63");
    check_base_class_offset(lv, (tk11*), 0, "zc63");
    test_class_info(&lv, &cd_zc63);
    dp->~zc63();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc63(Test_zc63, "zc63", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc63C1Ev();
extern void _ZN4zc63D1Ev();
Name_Map name_map_zc63[] = {
  NSPAIR(_ZN4zc63C1Ev),
  NSPAIR(_ZN4zc63D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_zc63[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_tk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc63[];
static  VTBL_ENTRY vtc_zc63[] = {
  0,
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4zc63[0]),
};
extern VTBL_ENTRY _ZTV4zc63[];
static  VTBL_ENTRY _tg__ZTV4tk11__4zc63[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTT_ENTRY vtt_zc63[] = {
  {&(_ZTV4zc63[5]),  5,5},
  {&(_tg__ZTV4tk11__4zc63[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zc63[];
extern  VTBL_ENTRY _ZTV4zc63[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc63[];
Class_Descriptor cd_zc63 = {  "zc63", // class name
  bases_zc63, 6,
  &(vtc_zc63[0]), // expected_vtbl_contents
  &(vtt_zc63[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc63),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc63),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc63),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd63  : virtual sk22 , virtual tk11 {
  ~zd63(); // tgen
  zd63(); // tgen
};
//SIG(1 zd63) C1{ VBC2{ BC3{} BC4{}} VBC5{ VBC3 VBC4}}


zd63 ::~zd63(){ note_dtor("zd63", this);} // tgen
zd63 ::zd63(){ note_ctor("zd63", this);} // tgen

static void Test_zd63()
{
  extern Class_Descriptor cd_zd63;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd63, buf);
    zd63 *dp, &lv = *(dp=new (buf) zd63());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd63)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd63)");
    check_base_class_offset(lv, (si*)(sk22*), 0, "zd63");
    check_base_class_offset(lv, (sj*)(sk22*), 0, "zd63");
    check_base_class_offset(lv, (sk22*), 0, "zd63");
    check_base_class_offset(lv, (si*)(tk11*), ABISELECT(8,4), "zd63");
    check_base_class_offset(lv, (sj*)(tk11*), ABISELECT(8,4), "zd63");
    check_base_class_offset(lv, (tk11*), 0, "zd63");
    test_class_info(&lv, &cd_zd63);
    dp->~zd63();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd63(Test_zd63, "zd63", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd63C1Ev();
extern void _ZN4zd63D1Ev();
Name_Map name_map_zd63[] = {
  NSPAIR(_ZN4zd63C1Ev),
  NSPAIR(_ZN4zd63D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk11;
extern VTBL_ENTRY _ZTI4tk11[];
extern  VTBL_ENTRY _ZTV4tk11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk11[];
static Base_Class bases_zd63[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_tk11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd63[];
static  VTBL_ENTRY vtc_zd63[] = {
  0,
  0,
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4zd63[0]),
};
extern VTBL_ENTRY _ZTV4zd63[];
static  VTBL_ENTRY _tg__ZTV4tk11__4zd63[] = {
  ABISELECT(8,4),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4tk11[0]),
};
static  VTT_ENTRY vtt_zd63[] = {
  {&(_ZTV4zd63[6]),  6,6},
  {&(_ZTV4zd63[6]),  6,6},
  {&(_tg__ZTV4tk11__4zd63[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zd63[];
extern  VTBL_ENTRY _ZTV4zd63[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd63[];
Class_Descriptor cd_zd63 = {  "zd63", // class name
  bases_zd63, 6,
  &(vtc_zd63[0]), // expected_vtbl_contents
  &(vtt_zd63[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd63),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd63),6, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd63),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za64  : sk22 , tk12 {
  ~za64(); // tgen
  za64(); // tgen
};
//SIG(1 za64) C1{ BC2{ BC3{} BC4{}} BC5{ VBC3 BC4}}


za64 ::~za64(){ note_dtor("za64", this);} // tgen
za64 ::za64(){ note_ctor("za64", this);} // tgen

static void Test_za64()
{
  extern Class_Descriptor cd_za64;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za64, buf);
    za64 *dp, &lv = *(dp=new (buf) za64());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za64)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za64)");
    check_base_class_offset(lv, (si*)(sk22*), ABISELECT(8,4), "za64");
    check_base_class_offset(lv, (sj*)(sk22*), ABISELECT(8,4), "za64");
    check_base_class_offset(lv, (sk22*), ABISELECT(8,4), "za64");
    check_base_class_offset(lv, (si*)(tk12*), 0, "za64");
    check_base_class_offset(lv, (sj*)(tk12*), 0, "za64");
    check_base_class_offset(lv, (tk12*), 0, "za64");
    test_class_info(&lv, &cd_za64);
    dp->~za64();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza64(Test_za64, "za64", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za64C1Ev();
extern void _ZN4za64D1Ev();
Name_Map name_map_za64[] = {
  NSPAIR(_ZN4za64C1Ev),
  NSPAIR(_ZN4za64D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_za64[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_tk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za64[];
static  VTBL_ENTRY vtc_za64[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za64[0]),
};
extern VTBL_ENTRY _ZTV4za64[];
static  VTBL_ENTRY _tg__ZTV4tk12__4za64[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTT_ENTRY vtt_za64[] = {
  {&(_ZTV4za64[3]),  3,3},
  {&(_tg__ZTV4tk12__4za64[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4za64[];
extern  VTBL_ENTRY _ZTV4za64[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za64[];
Class_Descriptor cd_za64 = {  "za64", // class name
  bases_za64, 6,
  &(vtc_za64[0]), // expected_vtbl_contents
  &(vtt_za64[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za64),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za64),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za64),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb64  : sk22 , virtual tk12 {
  ~zb64(); // tgen
  zb64(); // tgen
};
//SIG(1 zb64) C1{ BC2{ BC3{} BC4{}} VBC5{ VBC3 BC4}}


zb64 ::~zb64(){ note_dtor("zb64", this);} // tgen
zb64 ::zb64(){ note_ctor("zb64", this);} // tgen

static void Test_zb64()
{
  extern Class_Descriptor cd_zb64;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb64, buf);
    zb64 *dp, &lv = *(dp=new (buf) zb64());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb64)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb64)");
    check_base_class_offset(lv, (si*)(sk22*), ABISELECT(8,4), "zb64");
    check_base_class_offset(lv, (sj*)(sk22*), ABISELECT(8,4), "zb64");
    check_base_class_offset(lv, (sk22*), ABISELECT(8,4), "zb64");
    check_base_class_offset(lv, (si*)(tk12*), 0, "zb64");
    check_base_class_offset(lv, (sj*)(tk12*), 0, "zb64");
    check_base_class_offset(lv, (tk12*), 0, "zb64");
    test_class_info(&lv, &cd_zb64);
    dp->~zb64();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb64(Test_zb64, "zb64", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb64C1Ev();
extern void _ZN4zb64D1Ev();
Name_Map name_map_zb64[] = {
  NSPAIR(_ZN4zb64C1Ev),
  NSPAIR(_ZN4zb64D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_zb64[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_tk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb64[];
static  VTBL_ENTRY vtc_zb64[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb64[0]),
};
extern VTBL_ENTRY _ZTV4zb64[];
static  VTBL_ENTRY _tg__ZTV4tk12__4zb64[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTT_ENTRY vtt_zb64[] = {
  {&(_ZTV4zb64[4]),  4,4},
  {&(_ZTV4zb64[4]),  4,4},
  {&(_tg__ZTV4tk12__4zb64[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb64[];
extern  VTBL_ENTRY _ZTV4zb64[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb64[];
Class_Descriptor cd_zb64 = {  "zb64", // class name
  bases_zb64, 6,
  &(vtc_zb64[0]), // expected_vtbl_contents
  &(vtt_zb64[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb64),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb64),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb64),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc64  : virtual sk22 , tk12 {
  ~zc64(); // tgen
  zc64(); // tgen
};
//SIG(1 zc64) C1{ VBC2{ BC3{} BC4{}} BC5{ VBC3 BC4}}


zc64 ::~zc64(){ note_dtor("zc64", this);} // tgen
zc64 ::zc64(){ note_ctor("zc64", this);} // tgen

static void Test_zc64()
{
  extern Class_Descriptor cd_zc64;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc64, buf);
    zc64 *dp, &lv = *(dp=new (buf) zc64());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc64)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc64)");
    check_base_class_offset(lv, (si*)(sk22*), ABISELECT(8,4), "zc64");
    check_base_class_offset(lv, (sj*)(sk22*), ABISELECT(8,4), "zc64");
    check_base_class_offset(lv, (sk22*), ABISELECT(8,4), "zc64");
    check_base_class_offset(lv, (si*)(tk12*), 0, "zc64");
    check_base_class_offset(lv, (sj*)(tk12*), 0, "zc64");
    check_base_class_offset(lv, (tk12*), 0, "zc64");
    test_class_info(&lv, &cd_zc64);
    dp->~zc64();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc64(Test_zc64, "zc64", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc64C1Ev();
extern void _ZN4zc64D1Ev();
Name_Map name_map_zc64[] = {
  NSPAIR(_ZN4zc64C1Ev),
  NSPAIR(_ZN4zc64D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_zc64[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_tk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc64[];
static  VTBL_ENTRY vtc_zc64[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc64[0]),
};
extern VTBL_ENTRY _ZTV4zc64[];
static  VTBL_ENTRY _tg__ZTV4tk12__4zc64[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTT_ENTRY vtt_zc64[] = {
  {&(_ZTV4zc64[4]),  4,4},
  {&(_tg__ZTV4tk12__4zc64[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc64[];
extern  VTBL_ENTRY _ZTV4zc64[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc64[];
Class_Descriptor cd_zc64 = {  "zc64", // class name
  bases_zc64, 6,
  &(vtc_zc64[0]), // expected_vtbl_contents
  &(vtt_zc64[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc64),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc64),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc64),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd64  : virtual sk22 , virtual tk12 {
  ~zd64(); // tgen
  zd64(); // tgen
};
//SIG(1 zd64) C1{ VBC2{ BC3{} BC4{}} VBC5{ VBC3 BC4}}


zd64 ::~zd64(){ note_dtor("zd64", this);} // tgen
zd64 ::zd64(){ note_ctor("zd64", this);} // tgen

static void Test_zd64()
{
  extern Class_Descriptor cd_zd64;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd64, buf);
    zd64 *dp, &lv = *(dp=new (buf) zd64());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd64)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd64)");
    check_base_class_offset(lv, (si*)(sk22*), ABISELECT(8,4), "zd64");
    check_base_class_offset(lv, (sj*)(sk22*), ABISELECT(8,4), "zd64");
    check_base_class_offset(lv, (sk22*), ABISELECT(8,4), "zd64");
    check_base_class_offset(lv, (si*)(tk12*), 0, "zd64");
    check_base_class_offset(lv, (sj*)(tk12*), 0, "zd64");
    check_base_class_offset(lv, (tk12*), 0, "zd64");
    test_class_info(&lv, &cd_zd64);
    dp->~zd64();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd64(Test_zd64, "zd64", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd64C1Ev();
extern void _ZN4zd64D1Ev();
Name_Map name_map_zd64[] = {
  NSPAIR(_ZN4zd64C1Ev),
  NSPAIR(_ZN4zd64D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk12;
extern VTBL_ENTRY _ZTI4tk12[];
extern  VTBL_ENTRY _ZTV4tk12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk12[];
static Base_Class bases_zd64[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_tk12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd64[];
static  VTBL_ENTRY vtc_zd64[] = {
  0,
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd64[0]),
};
extern VTBL_ENTRY _ZTV4zd64[];
static  VTBL_ENTRY _tg__ZTV4tk12__4zd64[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk12[0]),
};
static  VTT_ENTRY vtt_zd64[] = {
  {&(_ZTV4zd64[5]),  5,5},
  {&(_ZTV4zd64[5]),  5,5},
  {&(_tg__ZTV4tk12__4zd64[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd64[];
extern  VTBL_ENTRY _ZTV4zd64[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd64[];
Class_Descriptor cd_zd64 = {  "zd64", // class name
  bases_zd64, 6,
  &(vtc_zd64[0]), // expected_vtbl_contents
  &(vtt_zd64[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd64),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd64),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd64),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za65  : sk22 , tk21 {
  ~za65(); // tgen
  za65(); // tgen
};
//SIG(1 za65) C1{ BC2{ BC3{} BC4{}} BC5{ BC3 VBC4}}


za65 ::~za65(){ note_dtor("za65", this);} // tgen
za65 ::za65(){ note_ctor("za65", this);} // tgen

static void Test_za65()
{
  extern Class_Descriptor cd_za65;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_za65, buf);
    za65 *dp, &lv = *(dp=new (buf) za65());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(za65)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(za65)");
    check_base_class_offset(lv, (si*)(sk22*), ABISELECT(8,4), "za65");
    check_base_class_offset(lv, (sj*)(sk22*), ABISELECT(8,4), "za65");
    check_base_class_offset(lv, (sk22*), ABISELECT(8,4), "za65");
    check_base_class_offset(lv, (si*)(tk21*), 0, "za65");
    check_base_class_offset(lv, (sj*)(tk21*), 0, "za65");
    check_base_class_offset(lv, (tk21*), 0, "za65");
    test_class_info(&lv, &cd_za65);
    dp->~za65();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza65(Test_za65, "za65", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4za65C1Ev();
extern void _ZN4za65D1Ev();
Name_Map name_map_za65[] = {
  NSPAIR(_ZN4za65C1Ev),
  NSPAIR(_ZN4za65D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_za65[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_tk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4za65[];
static  VTBL_ENTRY vtc_za65[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4za65[0]),
};
extern VTBL_ENTRY _ZTV4za65[];
static  VTBL_ENTRY _tg__ZTV4tk21__4za65[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTT_ENTRY vtt_za65[] = {
  {&(_ZTV4za65[3]),  3,3},
  {&(_tg__ZTV4tk21__4za65[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4za65[];
extern  VTBL_ENTRY _ZTV4za65[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4za65[];
Class_Descriptor cd_za65 = {  "za65", // class name
  bases_za65, 6,
  &(vtc_za65[0]), // expected_vtbl_contents
  &(vtt_za65[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4za65),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4za65),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4za65),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb65  : sk22 , virtual tk21 {
  ~zb65(); // tgen
  zb65(); // tgen
};
//SIG(1 zb65) C1{ BC2{ BC3{} BC4{}} VBC5{ BC3 VBC4}}


zb65 ::~zb65(){ note_dtor("zb65", this);} // tgen
zb65 ::zb65(){ note_ctor("zb65", this);} // tgen

static void Test_zb65()
{
  extern Class_Descriptor cd_zb65;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb65, buf);
    zb65 *dp, &lv = *(dp=new (buf) zb65());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb65)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb65)");
    check_base_class_offset(lv, (si*)(sk22*), ABISELECT(8,4), "zb65");
    check_base_class_offset(lv, (sj*)(sk22*), ABISELECT(8,4), "zb65");
    check_base_class_offset(lv, (sk22*), ABISELECT(8,4), "zb65");
    check_base_class_offset(lv, (si*)(tk21*), 0, "zb65");
    check_base_class_offset(lv, (sj*)(tk21*), 0, "zb65");
    check_base_class_offset(lv, (tk21*), 0, "zb65");
    test_class_info(&lv, &cd_zb65);
    dp->~zb65();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb65(Test_zb65, "zb65", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb65C1Ev();
extern void _ZN4zb65D1Ev();
Name_Map name_map_zb65[] = {
  NSPAIR(_ZN4zb65C1Ev),
  NSPAIR(_ZN4zb65D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_zb65[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_tk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb65[];
static  VTBL_ENTRY vtc_zb65[] = {
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zb65[0]),
};
extern VTBL_ENTRY _ZTV4zb65[];
static  VTBL_ENTRY _tg__ZTV4tk21__4zb65[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTT_ENTRY vtt_zb65[] = {
  {&(_ZTV4zb65[4]),  4,4},
  {&(_ZTV4zb65[4]),  4,4},
  {&(_tg__ZTV4tk21__4zb65[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb65[];
extern  VTBL_ENTRY _ZTV4zb65[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb65[];
Class_Descriptor cd_zb65 = {  "zb65", // class name
  bases_zb65, 6,
  &(vtc_zb65[0]), // expected_vtbl_contents
  &(vtt_zb65[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb65),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb65),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb65),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc65  : virtual sk22 , tk21 {
  ~zc65(); // tgen
  zc65(); // tgen
};
//SIG(1 zc65) C1{ VBC2{ BC3{} BC4{}} BC5{ BC3 VBC4}}


zc65 ::~zc65(){ note_dtor("zc65", this);} // tgen
zc65 ::zc65(){ note_ctor("zc65", this);} // tgen

static void Test_zc65()
{
  extern Class_Descriptor cd_zc65;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc65, buf);
    zc65 *dp, &lv = *(dp=new (buf) zc65());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc65)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc65)");
    check_base_class_offset(lv, (si*)(sk22*), ABISELECT(8,4), "zc65");
    check_base_class_offset(lv, (sj*)(sk22*), ABISELECT(8,4), "zc65");
    check_base_class_offset(lv, (sk22*), ABISELECT(8,4), "zc65");
    check_base_class_offset(lv, (si*)(tk21*), 0, "zc65");
    check_base_class_offset(lv, (sj*)(tk21*), 0, "zc65");
    check_base_class_offset(lv, (tk21*), 0, "zc65");
    test_class_info(&lv, &cd_zc65);
    dp->~zc65();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc65(Test_zc65, "zc65", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc65C1Ev();
extern void _ZN4zc65D1Ev();
Name_Map name_map_zc65[] = {
  NSPAIR(_ZN4zc65C1Ev),
  NSPAIR(_ZN4zc65D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_zc65[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_tk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc65[];
static  VTBL_ENTRY vtc_zc65[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zc65[0]),
};
extern VTBL_ENTRY _ZTV4zc65[];
static  VTBL_ENTRY _tg__ZTV4tk21__4zc65[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTT_ENTRY vtt_zc65[] = {
  {&(_ZTV4zc65[4]),  4,4},
  {&(_tg__ZTV4tk21__4zc65[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc65[];
extern  VTBL_ENTRY _ZTV4zc65[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc65[];
Class_Descriptor cd_zc65 = {  "zc65", // class name
  bases_zc65, 6,
  &(vtc_zc65[0]), // expected_vtbl_contents
  &(vtt_zc65[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc65),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc65),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc65),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd65  : virtual sk22 , virtual tk21 {
  ~zd65(); // tgen
  zd65(); // tgen
};
//SIG(1 zd65) C1{ VBC2{ BC3{} BC4{}} VBC5{ BC3 VBC4}}


zd65 ::~zd65(){ note_dtor("zd65", this);} // tgen
zd65 ::zd65(){ note_ctor("zd65", this);} // tgen

static void Test_zd65()
{
  extern Class_Descriptor cd_zd65;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd65, buf);
    zd65 *dp, &lv = *(dp=new (buf) zd65());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd65)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd65)");
    check_base_class_offset(lv, (si*)(sk22*), ABISELECT(8,4), "zd65");
    check_base_class_offset(lv, (sj*)(sk22*), ABISELECT(8,4), "zd65");
    check_base_class_offset(lv, (sk22*), ABISELECT(8,4), "zd65");
    check_base_class_offset(lv, (si*)(tk21*), 0, "zd65");
    check_base_class_offset(lv, (sj*)(tk21*), 0, "zd65");
    check_base_class_offset(lv, (tk21*), 0, "zd65");
    test_class_info(&lv, &cd_zd65);
    dp->~zd65();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd65(Test_zd65, "zd65", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd65C1Ev();
extern void _ZN4zd65D1Ev();
Name_Map name_map_zd65[] = {
  NSPAIR(_ZN4zd65C1Ev),
  NSPAIR(_ZN4zd65D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk21;
extern VTBL_ENTRY _ZTI4tk21[];
extern  VTBL_ENTRY _ZTV4tk21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4tk21[];
static Base_Class bases_zd65[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_tk21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd65[];
static  VTBL_ENTRY vtc_zd65[] = {
  0,
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd65[0]),
};
extern VTBL_ENTRY _ZTV4zd65[];
static  VTBL_ENTRY _tg__ZTV4tk21__4zd65[] = {
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4tk21[0]),
};
static  VTT_ENTRY vtt_zd65[] = {
  {&(_ZTV4zd65[5]),  5,5},
  {&(_ZTV4zd65[5]),  5,5},
  {&(_tg__ZTV4tk21__4zd65[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zd65[];
extern  VTBL_ENTRY _ZTV4zd65[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd65[];
Class_Descriptor cd_zd65 = {  "zd65", // class name
  bases_zd65, 6,
  &(vtc_zd65[0]), // expected_vtbl_contents
  &(vtt_zd65[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd65),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd65),5, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd65),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  za66  : sk22 , tk22 {
};
//SIG(1 za66) C1{ BC2{ BC3{} BC4{}} BC5{ BC3 BC4}}



static void Test_za66()
{
  extern Class_Descriptor cd_za66;
  void *lvp;
  {
    char buf[2];
    init_test(&cd_za66, buf);
    za66 &lv = *(new (buf) za66());
    lvp = (void*)&lv;
    check2(sizeof(lv), 2, "sizeof(za66)");
    check2(__alignof__(lv), 1, "__alignof__(za66)");
    check_base_class_offset(lv, (si*)(sk22*), 0, "za66");
    check_base_class_offset(lv, (sj*)(sk22*), 0, "za66");
    check_base_class_offset(lv, (sk22*), 0, "za66");
    check_base_class_offset(lv, (si*)(tk22*), 1, "za66");
    check_base_class_offset(lv, (sj*)(tk22*), 1, "za66");
    check_base_class_offset(lv, (tk22*), 1, "za66");
    test_class_info(&lv, &cd_za66);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vza66(Test_za66, "za66", 2);

#else // __cplusplus

extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_za66[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_sj,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_tk22,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_za66 = {  "za66", // class name
  bases_za66, 6,
  0, // no vftv
  0, //no vtt
  2, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zb66  : sk22 , virtual tk22 {
  ~zb66(); // tgen
  zb66(); // tgen
};
//SIG(1 zb66) C1{ BC2{ BC3{} BC4{}} VBC5{ BC3 BC4}}


zb66 ::~zb66(){ note_dtor("zb66", this);} // tgen
zb66 ::zb66(){ note_ctor("zb66", this);} // tgen

static void Test_zb66()
{
  extern Class_Descriptor cd_zb66;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zb66, buf);
    zb66 *dp, &lv = *(dp=new (buf) zb66());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zb66)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zb66)");
    check_base_class_offset(lv, (si*)(sk22*), 0, "zb66");
    check_base_class_offset(lv, (sj*)(sk22*), 0, "zb66");
    check_base_class_offset(lv, (sk22*), 0, "zb66");
    check_base_class_offset(lv, (si*)(tk22*), ABISELECT(8,4), "zb66");
    check_base_class_offset(lv, (sj*)(tk22*), ABISELECT(8,4), "zb66");
    check_base_class_offset(lv, (tk22*), ABISELECT(8,4), "zb66");
    test_class_info(&lv, &cd_zb66);
    dp->~zb66();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzb66(Test_zb66, "zb66", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zb66C1Ev();
extern void _ZN4zb66D1Ev();
Name_Map name_map_zb66[] = {
  NSPAIR(_ZN4zb66C1Ev),
  NSPAIR(_ZN4zb66D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_zb66[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_tk22,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zb66[];
static  VTBL_ENTRY vtc_zb66[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4zb66[0]),
};
extern VTBL_ENTRY _ZTV4zb66[];
static  VTT_ENTRY vtt_zb66[] = {
  {&(_ZTV4zb66[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zb66[];
extern  VTBL_ENTRY _ZTV4zb66[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zb66[];
Class_Descriptor cd_zb66 = {  "zb66", // class name
  bases_zb66, 6,
  &(vtc_zb66[0]), // expected_vtbl_contents
  &(vtt_zb66[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zb66),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zb66),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zb66),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zc66  : virtual sk22 , tk22 {
  ~zc66(); // tgen
  zc66(); // tgen
};
//SIG(1 zc66) C1{ VBC2{ BC3{} BC4{}} BC5{ BC3 BC4}}


zc66 ::~zc66(){ note_dtor("zc66", this);} // tgen
zc66 ::zc66(){ note_ctor("zc66", this);} // tgen

static void Test_zc66()
{
  extern Class_Descriptor cd_zc66;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zc66, buf);
    zc66 *dp, &lv = *(dp=new (buf) zc66());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zc66)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zc66)");
    check_base_class_offset(lv, (si*)(sk22*), ABISELECT(8,4), "zc66");
    check_base_class_offset(lv, (sj*)(sk22*), ABISELECT(8,4), "zc66");
    check_base_class_offset(lv, (sk22*), ABISELECT(8,4), "zc66");
    check_base_class_offset(lv, (si*)(tk22*), 0, "zc66");
    check_base_class_offset(lv, (sj*)(tk22*), 0, "zc66");
    check_base_class_offset(lv, (tk22*), 0, "zc66");
    test_class_info(&lv, &cd_zc66);
    dp->~zc66();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzc66(Test_zc66, "zc66", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zc66C1Ev();
extern void _ZN4zc66D1Ev();
Name_Map name_map_zc66[] = {
  NSPAIR(_ZN4zc66C1Ev),
  NSPAIR(_ZN4zc66D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_zc66[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_tk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI4zc66[];
static  VTBL_ENTRY vtc_zc66[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI4zc66[0]),
};
extern VTBL_ENTRY _ZTV4zc66[];
static  VTT_ENTRY vtt_zc66[] = {
  {&(_ZTV4zc66[3]),  3,3},
};
extern VTBL_ENTRY _ZTI4zc66[];
extern  VTBL_ENTRY _ZTV4zc66[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zc66[];
Class_Descriptor cd_zc66 = {  "zc66", // class name
  bases_zc66, 6,
  &(vtc_zc66[0]), // expected_vtbl_contents
  &(vtt_zc66[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zc66),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zc66),3, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zc66),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  zd66  : virtual sk22 , virtual tk22 {
  ~zd66(); // tgen
  zd66(); // tgen
};
//SIG(1 zd66) C1{ VBC2{ BC3{} BC4{}} VBC5{ BC3 BC4}}


zd66 ::~zd66(){ note_dtor("zd66", this);} // tgen
zd66 ::zd66(){ note_ctor("zd66", this);} // tgen

static void Test_zd66()
{
  extern Class_Descriptor cd_zd66;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_zd66, buf);
    zd66 *dp, &lv = *(dp=new (buf) zd66());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(zd66)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(zd66)");
    check_base_class_offset(lv, (si*)(sk22*), 0, "zd66");
    check_base_class_offset(lv, (sj*)(sk22*), 0, "zd66");
    check_base_class_offset(lv, (sk22*), 0, "zd66");
    check_base_class_offset(lv, (si*)(tk22*), ABISELECT(8,4), "zd66");
    check_base_class_offset(lv, (sj*)(tk22*), ABISELECT(8,4), "zd66");
    check_base_class_offset(lv, (tk22*), ABISELECT(8,4), "zd66");
    test_class_info(&lv, &cd_zd66);
    dp->~zd66();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vzd66(Test_zd66, "zd66", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN4zd66C1Ev();
extern void _ZN4zd66D1Ev();
Name_Map name_map_zd66[] = {
  NSPAIR(_ZN4zd66C1Ev),
  NSPAIR(_ZN4zd66D1Ev),
  {0,0}
};
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk22;
extern VTBL_ENTRY _ZTI4sk22[];
extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_tk22;
extern VTBL_ENTRY _ZTI4tk22[];
static Base_Class bases_zd66[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_sk22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_si,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_sj,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_tk22,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI4zd66[];
static  VTBL_ENTRY vtc_zd66[] = {
  ABISELECT(8,4),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI4zd66[0]),
};
extern VTBL_ENTRY _ZTV4zd66[];
static  VTT_ENTRY vtt_zd66[] = {
  {&(_ZTV4zd66[4]),  4,4},
};
extern VTBL_ENTRY _ZTI4zd66[];
extern  VTBL_ENTRY _ZTV4zd66[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT4zd66[];
Class_Descriptor cd_zd66 = {  "zd66", // class name
  bases_zd66, 6,
  &(vtc_zd66[0]), // expected_vtbl_contents
  &(vtt_zd66[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI4zd66),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV4zd66),4, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT4zd66),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  yi  {
  char x;
};
//SIG(-1 yi) C1{ Fc}



static void Test_yi()
{
  {
    init_simple_test("yi");
    yi lv;
    check2(sizeof(lv), 1, "sizeof(yi)");
    check2(__alignof__(lv), 1, "__alignof__(yi)");
    check_field_offset(lv, x, 0, "yi.x");
  }
}
static Arrange_To_Call_Me vyi(Test_yi, "yi", 1);

#else // __cplusplus

Class_Descriptor cd_yi = {  "yi", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  yj  {
  char x;
};
//SIG(-1 yj) C1{ Fc}



static void Test_yj()
{
  {
    init_simple_test("yj");
    yj lv;
    check2(sizeof(lv), 1, "sizeof(yj)");
    check2(__alignof__(lv), 1, "__alignof__(yj)");
    check_field_offset(lv, x, 0, "yj.x");
  }
}
static Arrange_To_Call_Me vyj(Test_yj, "yj", 1);

#else // __cplusplus

Class_Descriptor cd_yj = {  "yj", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  yk  {
  char x;
};
//SIG(-1 yk) C1{ Fc}



static void Test_yk()
{
  {
    init_simple_test("yk");
    yk lv;
    check2(sizeof(lv), 1, "sizeof(yk)");
    check2(__alignof__(lv), 1, "__alignof__(yk)");
    check_field_offset(lv, x, 0, "yk.x");
  }
}
static Arrange_To_Call_Me vyk(Test_yk, "yk", 1);

#else // __cplusplus

Class_Descriptor cd_yk = {  "yk", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  yl  {
  char x;
};
//SIG(-1 yl) C1{ Fc}



static void Test_yl()
{
  {
    init_simple_test("yl");
    yl lv;
    check2(sizeof(lv), 1, "sizeof(yl)");
    check2(__alignof__(lv), 1, "__alignof__(yl)");
    check_field_offset(lv, x, 0, "yl.x");
  }
}
static Arrange_To_Call_Me vyl(Test_yl, "yl", 1);

#else // __cplusplus

Class_Descriptor cd_yl = {  "yl", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  ym  {
  char x;
};
//SIG(-1 ym) C1{ Fc}



static void Test_ym()
{
  {
    init_simple_test("ym");
    ym lv;
    check2(sizeof(lv), 1, "sizeof(ym)");
    check2(__alignof__(lv), 1, "__alignof__(ym)");
    check_field_offset(lv, x, 0, "ym.x");
  }
}
static Arrange_To_Call_Me vym(Test_ym, "ym", 1);

#else // __cplusplus

Class_Descriptor cd_ym = {  "ym", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de0  : yi , yj , yk , yl , ym {
  char c;
};
//SIG(1 de0) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fc} BC5{ Fc} BC6{ Fc} Fc}



static void Test_de0()
{
  extern Class_Descriptor cd_de0;
  void *lvp;
  {
    char buf[6];
    init_test(&cd_de0, buf);
    de0 &lv = *(new (buf) de0());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(de0)");
    check2(__alignof__(lv), 1, "__alignof__(de0)");
    check_base_class_offset(lv, (yi*), 0, "de0");
    check_base_class_offset(lv, (yj*), 1, "de0");
    check_base_class_offset(lv, (yk*), 2, "de0");
    check_base_class_offset(lv, (yl*), 3, "de0");
    check_base_class_offset(lv, (ym*), 4, "de0");
    check_field_offset(lv, c, 5, "de0.c");
    test_class_info(&lv, &cd_de0);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde0(Test_de0, "de0", 6);

#else // __cplusplus

extern Class_Descriptor cd_yi;
extern Class_Descriptor cd_yj;
extern Class_Descriptor cd_yk;
extern Class_Descriptor cd_yl;
extern Class_Descriptor cd_ym;
static Base_Class bases_de0[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_yi,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yj,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yk,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yl,    3, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_ym,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de0 = {  "de0", // class name
  bases_de0, 5,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de1  : si , sj , sk , sl , sm {
  char c;
};
//SIG(1 de1) C1{ BC2{} BC3{} BC4{} BC5{} BC6{} Fc}



static void Test_de1()
{
  extern Class_Descriptor cd_de1;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_de1, buf);
    de1 &lv = *(new (buf) de1());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(de1)");
    check2(__alignof__(lv), 1, "__alignof__(de1)");
    check_base_class_offset(lv, (si*), 0, "de1");
    check_base_class_offset(lv, (sj*), 0, "de1");
    check_base_class_offset(lv, (sk*), 0, "de1");
    check_base_class_offset(lv, (sl*), 0, "de1");
    check_base_class_offset(lv, (sm*), 0, "de1");
    check_field_offset(lv, c, 0, "de1.c");
    test_class_info(&lv, &cd_de1);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde1(Test_de1, "de1", 1);

#else // __cplusplus

extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk;
extern Class_Descriptor cd_sl;
extern Class_Descriptor cd_sm;
static Base_Class bases_de1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sk,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sl,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sm,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de1 = {  "de1", // class name
  bases_de1, 5,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de2  : yi , yj , yk , yl , ym {
  char c;
};
//SIG(1 de2) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fc} BC5{ Fc} BC6{ Fc} Fc}



static void Test_de2()
{
  extern Class_Descriptor cd_de2;
  void *lvp;
  {
    char buf[6];
    init_test(&cd_de2, buf);
    de2 &lv = *(new (buf) de2());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(de2)");
    check2(__alignof__(lv), 1, "__alignof__(de2)");
    check_base_class_offset(lv, (yi*), 0, "de2");
    check_base_class_offset(lv, (yj*), 1, "de2");
    check_base_class_offset(lv, (yk*), 2, "de2");
    check_base_class_offset(lv, (yl*), 3, "de2");
    check_base_class_offset(lv, (ym*), 4, "de2");
    check_field_offset(lv, c, 5, "de2.c");
    test_class_info(&lv, &cd_de2);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde2(Test_de2, "de2", 6);

#else // __cplusplus

extern Class_Descriptor cd_yi;
extern Class_Descriptor cd_yj;
extern Class_Descriptor cd_yk;
extern Class_Descriptor cd_yl;
extern Class_Descriptor cd_ym;
static Base_Class bases_de2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_yi,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yj,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yk,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yl,    3, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_ym,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de2 = {  "de2", // class name
  bases_de2, 5,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de3  : si , sj , sk , sl , sm {
  char c;
};
//SIG(1 de3) C1{ BC2{} BC3{} BC4{} BC5{} BC6{} Fc}



static void Test_de3()
{
  extern Class_Descriptor cd_de3;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_de3, buf);
    de3 &lv = *(new (buf) de3());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(de3)");
    check2(__alignof__(lv), 1, "__alignof__(de3)");
    check_base_class_offset(lv, (si*), 0, "de3");
    check_base_class_offset(lv, (sj*), 0, "de3");
    check_base_class_offset(lv, (sk*), 0, "de3");
    check_base_class_offset(lv, (sl*), 0, "de3");
    check_base_class_offset(lv, (sm*), 0, "de3");
    check_field_offset(lv, c, 0, "de3.c");
    test_class_info(&lv, &cd_de3);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde3(Test_de3, "de3", 1);

#else // __cplusplus

extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk;
extern Class_Descriptor cd_sl;
extern Class_Descriptor cd_sm;
static Base_Class bases_de3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sk,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sl,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sm,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de3 = {  "de3", // class name
  bases_de3, 5,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de4  : yi , yj , yk , yl , ym {
  char c;
};
//SIG(1 de4) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fc} BC5{ Fc} BC6{ Fc} Fc}



static void Test_de4()
{
  extern Class_Descriptor cd_de4;
  void *lvp;
  {
    char buf[6];
    init_test(&cd_de4, buf);
    de4 &lv = *(new (buf) de4());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(de4)");
    check2(__alignof__(lv), 1, "__alignof__(de4)");
    check_base_class_offset(lv, (yi*), 0, "de4");
    check_base_class_offset(lv, (yj*), 1, "de4");
    check_base_class_offset(lv, (yk*), 2, "de4");
    check_base_class_offset(lv, (yl*), 3, "de4");
    check_base_class_offset(lv, (ym*), 4, "de4");
    check_field_offset(lv, c, 5, "de4.c");
    test_class_info(&lv, &cd_de4);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde4(Test_de4, "de4", 6);

#else // __cplusplus

extern Class_Descriptor cd_yi;
extern Class_Descriptor cd_yj;
extern Class_Descriptor cd_yk;
extern Class_Descriptor cd_yl;
extern Class_Descriptor cd_ym;
static Base_Class bases_de4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_yi,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yj,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yk,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yl,    3, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_ym,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de4 = {  "de4", // class name
  bases_de4, 5,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de5  : si , sj , sk , sl , sm {
  char c;
};
//SIG(1 de5) C1{ BC2{} BC3{} BC4{} BC5{} BC6{} Fc}



static void Test_de5()
{
  extern Class_Descriptor cd_de5;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_de5, buf);
    de5 &lv = *(new (buf) de5());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(de5)");
    check2(__alignof__(lv), 1, "__alignof__(de5)");
    check_base_class_offset(lv, (si*), 0, "de5");
    check_base_class_offset(lv, (sj*), 0, "de5");
    check_base_class_offset(lv, (sk*), 0, "de5");
    check_base_class_offset(lv, (sl*), 0, "de5");
    check_base_class_offset(lv, (sm*), 0, "de5");
    check_field_offset(lv, c, 0, "de5.c");
    test_class_info(&lv, &cd_de5);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde5(Test_de5, "de5", 1);

#else // __cplusplus

extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk;
extern Class_Descriptor cd_sl;
extern Class_Descriptor cd_sm;
static Base_Class bases_de5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sk,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sl,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sm,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de5 = {  "de5", // class name
  bases_de5, 5,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de6  : yi , yj , yk , yl , ym {
  char c;
};
//SIG(1 de6) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fc} BC5{ Fc} BC6{ Fc} Fc}



static void Test_de6()
{
  extern Class_Descriptor cd_de6;
  void *lvp;
  {
    char buf[6];
    init_test(&cd_de6, buf);
    de6 &lv = *(new (buf) de6());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(de6)");
    check2(__alignof__(lv), 1, "__alignof__(de6)");
    check_base_class_offset(lv, (yi*), 0, "de6");
    check_base_class_offset(lv, (yj*), 1, "de6");
    check_base_class_offset(lv, (yk*), 2, "de6");
    check_base_class_offset(lv, (yl*), 3, "de6");
    check_base_class_offset(lv, (ym*), 4, "de6");
    check_field_offset(lv, c, 5, "de6.c");
    test_class_info(&lv, &cd_de6);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde6(Test_de6, "de6", 6);

#else // __cplusplus

extern Class_Descriptor cd_yi;
extern Class_Descriptor cd_yj;
extern Class_Descriptor cd_yk;
extern Class_Descriptor cd_yl;
extern Class_Descriptor cd_ym;
static Base_Class bases_de6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_yi,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yj,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yk,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yl,    3, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_ym,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de6 = {  "de6", // class name
  bases_de6, 5,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de7  : si , sj , sk , sl , sm {
  char c;
};
//SIG(1 de7) C1{ BC2{} BC3{} BC4{} BC5{} BC6{} Fc}



static void Test_de7()
{
  extern Class_Descriptor cd_de7;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_de7, buf);
    de7 &lv = *(new (buf) de7());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(de7)");
    check2(__alignof__(lv), 1, "__alignof__(de7)");
    check_base_class_offset(lv, (si*), 0, "de7");
    check_base_class_offset(lv, (sj*), 0, "de7");
    check_base_class_offset(lv, (sk*), 0, "de7");
    check_base_class_offset(lv, (sl*), 0, "de7");
    check_base_class_offset(lv, (sm*), 0, "de7");
    check_field_offset(lv, c, 0, "de7.c");
    test_class_info(&lv, &cd_de7);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde7(Test_de7, "de7", 1);

#else // __cplusplus

extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk;
extern Class_Descriptor cd_sl;
extern Class_Descriptor cd_sm;
static Base_Class bases_de7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sk,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sl,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sm,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de7 = {  "de7", // class name
  bases_de7, 5,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de8  : yi , yj , yk , yl , ym {
  char c;
};
//SIG(1 de8) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fc} BC5{ Fc} BC6{ Fc} Fc}



static void Test_de8()
{
  extern Class_Descriptor cd_de8;
  void *lvp;
  {
    char buf[6];
    init_test(&cd_de8, buf);
    de8 &lv = *(new (buf) de8());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(de8)");
    check2(__alignof__(lv), 1, "__alignof__(de8)");
    check_base_class_offset(lv, (yi*), 0, "de8");
    check_base_class_offset(lv, (yj*), 1, "de8");
    check_base_class_offset(lv, (yk*), 2, "de8");
    check_base_class_offset(lv, (yl*), 3, "de8");
    check_base_class_offset(lv, (ym*), 4, "de8");
    check_field_offset(lv, c, 5, "de8.c");
    test_class_info(&lv, &cd_de8);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde8(Test_de8, "de8", 6);

#else // __cplusplus

extern Class_Descriptor cd_yi;
extern Class_Descriptor cd_yj;
extern Class_Descriptor cd_yk;
extern Class_Descriptor cd_yl;
extern Class_Descriptor cd_ym;
static Base_Class bases_de8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_yi,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yj,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yk,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yl,    3, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_ym,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de8 = {  "de8", // class name
  bases_de8, 5,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de9  : si , sj , sk , sl , sm {
  char c;
};
//SIG(1 de9) C1{ BC2{} BC3{} BC4{} BC5{} BC6{} Fc}



static void Test_de9()
{
  extern Class_Descriptor cd_de9;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_de9, buf);
    de9 &lv = *(new (buf) de9());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(de9)");
    check2(__alignof__(lv), 1, "__alignof__(de9)");
    check_base_class_offset(lv, (si*), 0, "de9");
    check_base_class_offset(lv, (sj*), 0, "de9");
    check_base_class_offset(lv, (sk*), 0, "de9");
    check_base_class_offset(lv, (sl*), 0, "de9");
    check_base_class_offset(lv, (sm*), 0, "de9");
    check_field_offset(lv, c, 0, "de9.c");
    test_class_info(&lv, &cd_de9);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde9(Test_de9, "de9", 1);

#else // __cplusplus

extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk;
extern Class_Descriptor cd_sl;
extern Class_Descriptor cd_sm;
static Base_Class bases_de9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sk,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sl,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sm,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de9 = {  "de9", // class name
  bases_de9, 5,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de10  : yi , yj , yk , yl , ym {
  char c;
};
//SIG(1 de10) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fc} BC5{ Fc} BC6{ Fc} Fc}



static void Test_de10()
{
  extern Class_Descriptor cd_de10;
  void *lvp;
  {
    char buf[6];
    init_test(&cd_de10, buf);
    de10 &lv = *(new (buf) de10());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(de10)");
    check2(__alignof__(lv), 1, "__alignof__(de10)");
    check_base_class_offset(lv, (yi*), 0, "de10");
    check_base_class_offset(lv, (yj*), 1, "de10");
    check_base_class_offset(lv, (yk*), 2, "de10");
    check_base_class_offset(lv, (yl*), 3, "de10");
    check_base_class_offset(lv, (ym*), 4, "de10");
    check_field_offset(lv, c, 5, "de10.c");
    test_class_info(&lv, &cd_de10);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde10(Test_de10, "de10", 6);

#else // __cplusplus

extern Class_Descriptor cd_yi;
extern Class_Descriptor cd_yj;
extern Class_Descriptor cd_yk;
extern Class_Descriptor cd_yl;
extern Class_Descriptor cd_ym;
static Base_Class bases_de10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_yi,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yj,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yk,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yl,    3, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_ym,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de10 = {  "de10", // class name
  bases_de10, 5,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de11  : si , sj , sk , sl , sm {
  char c;
};
//SIG(1 de11) C1{ BC2{} BC3{} BC4{} BC5{} BC6{} Fc}



static void Test_de11()
{
  extern Class_Descriptor cd_de11;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_de11, buf);
    de11 &lv = *(new (buf) de11());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(de11)");
    check2(__alignof__(lv), 1, "__alignof__(de11)");
    check_base_class_offset(lv, (si*), 0, "de11");
    check_base_class_offset(lv, (sj*), 0, "de11");
    check_base_class_offset(lv, (sk*), 0, "de11");
    check_base_class_offset(lv, (sl*), 0, "de11");
    check_base_class_offset(lv, (sm*), 0, "de11");
    check_field_offset(lv, c, 0, "de11.c");
    test_class_info(&lv, &cd_de11);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde11(Test_de11, "de11", 1);

#else // __cplusplus

extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk;
extern Class_Descriptor cd_sl;
extern Class_Descriptor cd_sm;
static Base_Class bases_de11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sk,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sl,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sm,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de11 = {  "de11", // class name
  bases_de11, 5,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de12  : yi , yj , yk , yl , ym {
  char c;
};
//SIG(1 de12) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fc} BC5{ Fc} BC6{ Fc} Fc}



static void Test_de12()
{
  extern Class_Descriptor cd_de12;
  void *lvp;
  {
    char buf[6];
    init_test(&cd_de12, buf);
    de12 &lv = *(new (buf) de12());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(de12)");
    check2(__alignof__(lv), 1, "__alignof__(de12)");
    check_base_class_offset(lv, (yi*), 0, "de12");
    check_base_class_offset(lv, (yj*), 1, "de12");
    check_base_class_offset(lv, (yk*), 2, "de12");
    check_base_class_offset(lv, (yl*), 3, "de12");
    check_base_class_offset(lv, (ym*), 4, "de12");
    check_field_offset(lv, c, 5, "de12.c");
    test_class_info(&lv, &cd_de12);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde12(Test_de12, "de12", 6);

#else // __cplusplus

extern Class_Descriptor cd_yi;
extern Class_Descriptor cd_yj;
extern Class_Descriptor cd_yk;
extern Class_Descriptor cd_yl;
extern Class_Descriptor cd_ym;
static Base_Class bases_de12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_yi,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yj,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yk,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yl,    3, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_ym,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de12 = {  "de12", // class name
  bases_de12, 5,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de13  : si , sj , sk , sl , sm {
  char c;
};
//SIG(1 de13) C1{ BC2{} BC3{} BC4{} BC5{} BC6{} Fc}



static void Test_de13()
{
  extern Class_Descriptor cd_de13;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_de13, buf);
    de13 &lv = *(new (buf) de13());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(de13)");
    check2(__alignof__(lv), 1, "__alignof__(de13)");
    check_base_class_offset(lv, (si*), 0, "de13");
    check_base_class_offset(lv, (sj*), 0, "de13");
    check_base_class_offset(lv, (sk*), 0, "de13");
    check_base_class_offset(lv, (sl*), 0, "de13");
    check_base_class_offset(lv, (sm*), 0, "de13");
    check_field_offset(lv, c, 0, "de13.c");
    test_class_info(&lv, &cd_de13);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde13(Test_de13, "de13", 1);

#else // __cplusplus

extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk;
extern Class_Descriptor cd_sl;
extern Class_Descriptor cd_sm;
static Base_Class bases_de13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sk,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sl,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sm,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de13 = {  "de13", // class name
  bases_de13, 5,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de14  : yi , yj , yk , yl , ym {
  char c;
};
//SIG(1 de14) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fc} BC5{ Fc} BC6{ Fc} Fc}



static void Test_de14()
{
  extern Class_Descriptor cd_de14;
  void *lvp;
  {
    char buf[6];
    init_test(&cd_de14, buf);
    de14 &lv = *(new (buf) de14());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(de14)");
    check2(__alignof__(lv), 1, "__alignof__(de14)");
    check_base_class_offset(lv, (yi*), 0, "de14");
    check_base_class_offset(lv, (yj*), 1, "de14");
    check_base_class_offset(lv, (yk*), 2, "de14");
    check_base_class_offset(lv, (yl*), 3, "de14");
    check_base_class_offset(lv, (ym*), 4, "de14");
    check_field_offset(lv, c, 5, "de14.c");
    test_class_info(&lv, &cd_de14);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde14(Test_de14, "de14", 6);

#else // __cplusplus

extern Class_Descriptor cd_yi;
extern Class_Descriptor cd_yj;
extern Class_Descriptor cd_yk;
extern Class_Descriptor cd_yl;
extern Class_Descriptor cd_ym;
static Base_Class bases_de14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_yi,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yj,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yk,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yl,    3, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_ym,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de14 = {  "de14", // class name
  bases_de14, 5,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de15  : si , sj , sk , sl , sm {
  char c;
};
//SIG(1 de15) C1{ BC2{} BC3{} BC4{} BC5{} BC6{} Fc}



static void Test_de15()
{
  extern Class_Descriptor cd_de15;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_de15, buf);
    de15 &lv = *(new (buf) de15());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(de15)");
    check2(__alignof__(lv), 1, "__alignof__(de15)");
    check_base_class_offset(lv, (si*), 0, "de15");
    check_base_class_offset(lv, (sj*), 0, "de15");
    check_base_class_offset(lv, (sk*), 0, "de15");
    check_base_class_offset(lv, (sl*), 0, "de15");
    check_base_class_offset(lv, (sm*), 0, "de15");
    check_field_offset(lv, c, 0, "de15.c");
    test_class_info(&lv, &cd_de15);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde15(Test_de15, "de15", 1);

#else // __cplusplus

extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk;
extern Class_Descriptor cd_sl;
extern Class_Descriptor cd_sm;
static Base_Class bases_de15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sk,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sl,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sm,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de15 = {  "de15", // class name
  bases_de15, 5,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de16  : yi , yj , yk , yl , ym {
  char c;
};
//SIG(1 de16) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fc} BC5{ Fc} BC6{ Fc} Fc}



static void Test_de16()
{
  extern Class_Descriptor cd_de16;
  void *lvp;
  {
    char buf[6];
    init_test(&cd_de16, buf);
    de16 &lv = *(new (buf) de16());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(de16)");
    check2(__alignof__(lv), 1, "__alignof__(de16)");
    check_base_class_offset(lv, (yi*), 0, "de16");
    check_base_class_offset(lv, (yj*), 1, "de16");
    check_base_class_offset(lv, (yk*), 2, "de16");
    check_base_class_offset(lv, (yl*), 3, "de16");
    check_base_class_offset(lv, (ym*), 4, "de16");
    check_field_offset(lv, c, 5, "de16.c");
    test_class_info(&lv, &cd_de16);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde16(Test_de16, "de16", 6);

#else // __cplusplus

extern Class_Descriptor cd_yi;
extern Class_Descriptor cd_yj;
extern Class_Descriptor cd_yk;
extern Class_Descriptor cd_yl;
extern Class_Descriptor cd_ym;
static Base_Class bases_de16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_yi,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yj,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yk,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yl,    3, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_ym,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de16 = {  "de16", // class name
  bases_de16, 5,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de17  : si , sj , sk , sl , sm {
  char c;
};
//SIG(1 de17) C1{ BC2{} BC3{} BC4{} BC5{} BC6{} Fc}



static void Test_de17()
{
  extern Class_Descriptor cd_de17;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_de17, buf);
    de17 &lv = *(new (buf) de17());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(de17)");
    check2(__alignof__(lv), 1, "__alignof__(de17)");
    check_base_class_offset(lv, (si*), 0, "de17");
    check_base_class_offset(lv, (sj*), 0, "de17");
    check_base_class_offset(lv, (sk*), 0, "de17");
    check_base_class_offset(lv, (sl*), 0, "de17");
    check_base_class_offset(lv, (sm*), 0, "de17");
    check_field_offset(lv, c, 0, "de17.c");
    test_class_info(&lv, &cd_de17);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde17(Test_de17, "de17", 1);

#else // __cplusplus

extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk;
extern Class_Descriptor cd_sl;
extern Class_Descriptor cd_sm;
static Base_Class bases_de17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sk,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sl,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sm,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de17 = {  "de17", // class name
  bases_de17, 5,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de18  : yi , yj , yk , yl , ym {
  char c;
};
//SIG(1 de18) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fc} BC5{ Fc} BC6{ Fc} Fc}



static void Test_de18()
{
  extern Class_Descriptor cd_de18;
  void *lvp;
  {
    char buf[6];
    init_test(&cd_de18, buf);
    de18 &lv = *(new (buf) de18());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(de18)");
    check2(__alignof__(lv), 1, "__alignof__(de18)");
    check_base_class_offset(lv, (yi*), 0, "de18");
    check_base_class_offset(lv, (yj*), 1, "de18");
    check_base_class_offset(lv, (yk*), 2, "de18");
    check_base_class_offset(lv, (yl*), 3, "de18");
    check_base_class_offset(lv, (ym*), 4, "de18");
    check_field_offset(lv, c, 5, "de18.c");
    test_class_info(&lv, &cd_de18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde18(Test_de18, "de18", 6);

#else // __cplusplus

extern Class_Descriptor cd_yi;
extern Class_Descriptor cd_yj;
extern Class_Descriptor cd_yk;
extern Class_Descriptor cd_yl;
extern Class_Descriptor cd_ym;
static Base_Class bases_de18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_yi,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yj,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yk,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yl,    3, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_ym,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de18 = {  "de18", // class name
  bases_de18, 5,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de19  : si , sj , sk , sl , sm {
  char c;
};
//SIG(1 de19) C1{ BC2{} BC3{} BC4{} BC5{} BC6{} Fc}



static void Test_de19()
{
  extern Class_Descriptor cd_de19;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_de19, buf);
    de19 &lv = *(new (buf) de19());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(de19)");
    check2(__alignof__(lv), 1, "__alignof__(de19)");
    check_base_class_offset(lv, (si*), 0, "de19");
    check_base_class_offset(lv, (sj*), 0, "de19");
    check_base_class_offset(lv, (sk*), 0, "de19");
    check_base_class_offset(lv, (sl*), 0, "de19");
    check_base_class_offset(lv, (sm*), 0, "de19");
    check_field_offset(lv, c, 0, "de19.c");
    test_class_info(&lv, &cd_de19);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde19(Test_de19, "de19", 1);

#else // __cplusplus

extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk;
extern Class_Descriptor cd_sl;
extern Class_Descriptor cd_sm;
static Base_Class bases_de19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sk,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sl,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sm,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de19 = {  "de19", // class name
  bases_de19, 5,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de20  : yi , yj , yk , yl , ym {
  char c;
};
//SIG(1 de20) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fc} BC5{ Fc} BC6{ Fc} Fc}



static void Test_de20()
{
  extern Class_Descriptor cd_de20;
  void *lvp;
  {
    char buf[6];
    init_test(&cd_de20, buf);
    de20 &lv = *(new (buf) de20());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(de20)");
    check2(__alignof__(lv), 1, "__alignof__(de20)");
    check_base_class_offset(lv, (yi*), 0, "de20");
    check_base_class_offset(lv, (yj*), 1, "de20");
    check_base_class_offset(lv, (yk*), 2, "de20");
    check_base_class_offset(lv, (yl*), 3, "de20");
    check_base_class_offset(lv, (ym*), 4, "de20");
    check_field_offset(lv, c, 5, "de20.c");
    test_class_info(&lv, &cd_de20);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde20(Test_de20, "de20", 6);

#else // __cplusplus

extern Class_Descriptor cd_yi;
extern Class_Descriptor cd_yj;
extern Class_Descriptor cd_yk;
extern Class_Descriptor cd_yl;
extern Class_Descriptor cd_ym;
static Base_Class bases_de20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_yi,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yj,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yk,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yl,    3, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_ym,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de20 = {  "de20", // class name
  bases_de20, 5,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de21  : si , sj , sk , sl , sm {
  char c;
};
//SIG(1 de21) C1{ BC2{} BC3{} BC4{} BC5{} BC6{} Fc}



static void Test_de21()
{
  extern Class_Descriptor cd_de21;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_de21, buf);
    de21 &lv = *(new (buf) de21());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(de21)");
    check2(__alignof__(lv), 1, "__alignof__(de21)");
    check_base_class_offset(lv, (si*), 0, "de21");
    check_base_class_offset(lv, (sj*), 0, "de21");
    check_base_class_offset(lv, (sk*), 0, "de21");
    check_base_class_offset(lv, (sl*), 0, "de21");
    check_base_class_offset(lv, (sm*), 0, "de21");
    check_field_offset(lv, c, 0, "de21.c");
    test_class_info(&lv, &cd_de21);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde21(Test_de21, "de21", 1);

#else // __cplusplus

extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk;
extern Class_Descriptor cd_sl;
extern Class_Descriptor cd_sm;
static Base_Class bases_de21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sk,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sl,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sm,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de21 = {  "de21", // class name
  bases_de21, 5,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de22  : yi , yj , yk , yl , ym {
  char c;
};
//SIG(1 de22) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fc} BC5{ Fc} BC6{ Fc} Fc}



static void Test_de22()
{
  extern Class_Descriptor cd_de22;
  void *lvp;
  {
    char buf[6];
    init_test(&cd_de22, buf);
    de22 &lv = *(new (buf) de22());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(de22)");
    check2(__alignof__(lv), 1, "__alignof__(de22)");
    check_base_class_offset(lv, (yi*), 0, "de22");
    check_base_class_offset(lv, (yj*), 1, "de22");
    check_base_class_offset(lv, (yk*), 2, "de22");
    check_base_class_offset(lv, (yl*), 3, "de22");
    check_base_class_offset(lv, (ym*), 4, "de22");
    check_field_offset(lv, c, 5, "de22.c");
    test_class_info(&lv, &cd_de22);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde22(Test_de22, "de22", 6);

#else // __cplusplus

extern Class_Descriptor cd_yi;
extern Class_Descriptor cd_yj;
extern Class_Descriptor cd_yk;
extern Class_Descriptor cd_yl;
extern Class_Descriptor cd_ym;
static Base_Class bases_de22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_yi,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yj,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yk,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yl,    3, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_ym,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de22 = {  "de22", // class name
  bases_de22, 5,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de23  : si , sj , sk , sl , sm {
  char c;
};
//SIG(1 de23) C1{ BC2{} BC3{} BC4{} BC5{} BC6{} Fc}



static void Test_de23()
{
  extern Class_Descriptor cd_de23;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_de23, buf);
    de23 &lv = *(new (buf) de23());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(de23)");
    check2(__alignof__(lv), 1, "__alignof__(de23)");
    check_base_class_offset(lv, (si*), 0, "de23");
    check_base_class_offset(lv, (sj*), 0, "de23");
    check_base_class_offset(lv, (sk*), 0, "de23");
    check_base_class_offset(lv, (sl*), 0, "de23");
    check_base_class_offset(lv, (sm*), 0, "de23");
    check_field_offset(lv, c, 0, "de23.c");
    test_class_info(&lv, &cd_de23);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde23(Test_de23, "de23", 1);

#else // __cplusplus

extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk;
extern Class_Descriptor cd_sl;
extern Class_Descriptor cd_sm;
static Base_Class bases_de23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sk,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sl,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sm,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de23 = {  "de23", // class name
  bases_de23, 5,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de24  : yi , yj , yk , yl , ym {
  char c;
};
//SIG(1 de24) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fc} BC5{ Fc} BC6{ Fc} Fc}



static void Test_de24()
{
  extern Class_Descriptor cd_de24;
  void *lvp;
  {
    char buf[6];
    init_test(&cd_de24, buf);
    de24 &lv = *(new (buf) de24());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(de24)");
    check2(__alignof__(lv), 1, "__alignof__(de24)");
    check_base_class_offset(lv, (yi*), 0, "de24");
    check_base_class_offset(lv, (yj*), 1, "de24");
    check_base_class_offset(lv, (yk*), 2, "de24");
    check_base_class_offset(lv, (yl*), 3, "de24");
    check_base_class_offset(lv, (ym*), 4, "de24");
    check_field_offset(lv, c, 5, "de24.c");
    test_class_info(&lv, &cd_de24);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde24(Test_de24, "de24", 6);

#else // __cplusplus

extern Class_Descriptor cd_yi;
extern Class_Descriptor cd_yj;
extern Class_Descriptor cd_yk;
extern Class_Descriptor cd_yl;
extern Class_Descriptor cd_ym;
static Base_Class bases_de24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_yi,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yj,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yk,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yl,    3, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_ym,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de24 = {  "de24", // class name
  bases_de24, 5,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de25  : si , sj , sk , sl , sm {
  char c;
};
//SIG(1 de25) C1{ BC2{} BC3{} BC4{} BC5{} BC6{} Fc}



static void Test_de25()
{
  extern Class_Descriptor cd_de25;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_de25, buf);
    de25 &lv = *(new (buf) de25());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(de25)");
    check2(__alignof__(lv), 1, "__alignof__(de25)");
    check_base_class_offset(lv, (si*), 0, "de25");
    check_base_class_offset(lv, (sj*), 0, "de25");
    check_base_class_offset(lv, (sk*), 0, "de25");
    check_base_class_offset(lv, (sl*), 0, "de25");
    check_base_class_offset(lv, (sm*), 0, "de25");
    check_field_offset(lv, c, 0, "de25.c");
    test_class_info(&lv, &cd_de25);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde25(Test_de25, "de25", 1);

#else // __cplusplus

extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk;
extern Class_Descriptor cd_sl;
extern Class_Descriptor cd_sm;
static Base_Class bases_de25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sk,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sl,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sm,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de25 = {  "de25", // class name
  bases_de25, 5,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de26  : yi , yj , yk , yl , ym {
  char c;
};
//SIG(1 de26) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fc} BC5{ Fc} BC6{ Fc} Fc}



static void Test_de26()
{
  extern Class_Descriptor cd_de26;
  void *lvp;
  {
    char buf[6];
    init_test(&cd_de26, buf);
    de26 &lv = *(new (buf) de26());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(de26)");
    check2(__alignof__(lv), 1, "__alignof__(de26)");
    check_base_class_offset(lv, (yi*), 0, "de26");
    check_base_class_offset(lv, (yj*), 1, "de26");
    check_base_class_offset(lv, (yk*), 2, "de26");
    check_base_class_offset(lv, (yl*), 3, "de26");
    check_base_class_offset(lv, (ym*), 4, "de26");
    check_field_offset(lv, c, 5, "de26.c");
    test_class_info(&lv, &cd_de26);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde26(Test_de26, "de26", 6);

#else // __cplusplus

extern Class_Descriptor cd_yi;
extern Class_Descriptor cd_yj;
extern Class_Descriptor cd_yk;
extern Class_Descriptor cd_yl;
extern Class_Descriptor cd_ym;
static Base_Class bases_de26[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_yi,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yj,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yk,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yl,    3, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_ym,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de26 = {  "de26", // class name
  bases_de26, 5,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de27  : si , sj , sk , sl , sm {
  char c;
};
//SIG(1 de27) C1{ BC2{} BC3{} BC4{} BC5{} BC6{} Fc}



static void Test_de27()
{
  extern Class_Descriptor cd_de27;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_de27, buf);
    de27 &lv = *(new (buf) de27());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(de27)");
    check2(__alignof__(lv), 1, "__alignof__(de27)");
    check_base_class_offset(lv, (si*), 0, "de27");
    check_base_class_offset(lv, (sj*), 0, "de27");
    check_base_class_offset(lv, (sk*), 0, "de27");
    check_base_class_offset(lv, (sl*), 0, "de27");
    check_base_class_offset(lv, (sm*), 0, "de27");
    check_field_offset(lv, c, 0, "de27.c");
    test_class_info(&lv, &cd_de27);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde27(Test_de27, "de27", 1);

#else // __cplusplus

extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk;
extern Class_Descriptor cd_sl;
extern Class_Descriptor cd_sm;
static Base_Class bases_de27[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sk,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sl,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sm,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de27 = {  "de27", // class name
  bases_de27, 5,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de28  : yi , yj , yk , yl , ym {
  char c;
};
//SIG(1 de28) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fc} BC5{ Fc} BC6{ Fc} Fc}



static void Test_de28()
{
  extern Class_Descriptor cd_de28;
  void *lvp;
  {
    char buf[6];
    init_test(&cd_de28, buf);
    de28 &lv = *(new (buf) de28());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(de28)");
    check2(__alignof__(lv), 1, "__alignof__(de28)");
    check_base_class_offset(lv, (yi*), 0, "de28");
    check_base_class_offset(lv, (yj*), 1, "de28");
    check_base_class_offset(lv, (yk*), 2, "de28");
    check_base_class_offset(lv, (yl*), 3, "de28");
    check_base_class_offset(lv, (ym*), 4, "de28");
    check_field_offset(lv, c, 5, "de28.c");
    test_class_info(&lv, &cd_de28);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde28(Test_de28, "de28", 6);

#else // __cplusplus

extern Class_Descriptor cd_yi;
extern Class_Descriptor cd_yj;
extern Class_Descriptor cd_yk;
extern Class_Descriptor cd_yl;
extern Class_Descriptor cd_ym;
static Base_Class bases_de28[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_yi,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yj,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yk,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yl,    3, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_ym,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de28 = {  "de28", // class name
  bases_de28, 5,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de29  : si , sj , sk , sl , sm {
  char c;
};
//SIG(1 de29) C1{ BC2{} BC3{} BC4{} BC5{} BC6{} Fc}



static void Test_de29()
{
  extern Class_Descriptor cd_de29;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_de29, buf);
    de29 &lv = *(new (buf) de29());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(de29)");
    check2(__alignof__(lv), 1, "__alignof__(de29)");
    check_base_class_offset(lv, (si*), 0, "de29");
    check_base_class_offset(lv, (sj*), 0, "de29");
    check_base_class_offset(lv, (sk*), 0, "de29");
    check_base_class_offset(lv, (sl*), 0, "de29");
    check_base_class_offset(lv, (sm*), 0, "de29");
    check_field_offset(lv, c, 0, "de29.c");
    test_class_info(&lv, &cd_de29);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde29(Test_de29, "de29", 1);

#else // __cplusplus

extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk;
extern Class_Descriptor cd_sl;
extern Class_Descriptor cd_sm;
static Base_Class bases_de29[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sk,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sl,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sm,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de29 = {  "de29", // class name
  bases_de29, 5,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de30  : yi , yj , yk , yl , ym {
  char c;
};
//SIG(1 de30) C1{ BC2{ Fc} BC3{ Fc} BC4{ Fc} BC5{ Fc} BC6{ Fc} Fc}



static void Test_de30()
{
  extern Class_Descriptor cd_de30;
  void *lvp;
  {
    char buf[6];
    init_test(&cd_de30, buf);
    de30 &lv = *(new (buf) de30());
    lvp = (void*)&lv;
    check2(sizeof(lv), 6, "sizeof(de30)");
    check2(__alignof__(lv), 1, "__alignof__(de30)");
    check_base_class_offset(lv, (yi*), 0, "de30");
    check_base_class_offset(lv, (yj*), 1, "de30");
    check_base_class_offset(lv, (yk*), 2, "de30");
    check_base_class_offset(lv, (yl*), 3, "de30");
    check_base_class_offset(lv, (ym*), 4, "de30");
    check_field_offset(lv, c, 5, "de30.c");
    test_class_info(&lv, &cd_de30);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde30(Test_de30, "de30", 6);

#else // __cplusplus

extern Class_Descriptor cd_yi;
extern Class_Descriptor cd_yj;
extern Class_Descriptor cd_yk;
extern Class_Descriptor cd_yl;
extern Class_Descriptor cd_ym;
static Base_Class bases_de30[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_yi,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yj,    1, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yk,    2, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_yl,    3, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_ym,    4, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de30 = {  "de30", // class name
  bases_de30, 5,
  0, // no vftv
  0, //no vtt
  6, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  de31  : si , sj , sk , sl , sm {
  char c;
};
//SIG(1 de31) C1{ BC2{} BC3{} BC4{} BC5{} BC6{} Fc}



static void Test_de31()
{
  extern Class_Descriptor cd_de31;
  void *lvp;
  {
    char buf[1];
    init_test(&cd_de31, buf);
    de31 &lv = *(new (buf) de31());
    lvp = (void*)&lv;
    check2(sizeof(lv), 1, "sizeof(de31)");
    check2(__alignof__(lv), 1, "__alignof__(de31)");
    check_base_class_offset(lv, (si*), 0, "de31");
    check_base_class_offset(lv, (sj*), 0, "de31");
    check_base_class_offset(lv, (sk*), 0, "de31");
    check_base_class_offset(lv, (sl*), 0, "de31");
    check_base_class_offset(lv, (sm*), 0, "de31");
    check_field_offset(lv, c, 0, "de31.c");
    test_class_info(&lv, &cd_de31);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vde31(Test_de31, "de31", 1);

#else // __cplusplus

extern Class_Descriptor cd_si;
extern VTBL_ENTRY _ZTI2si[];
extern Class_Descriptor cd_sj;
extern VTBL_ENTRY _ZTI2sj[];
extern Class_Descriptor cd_sk;
extern Class_Descriptor cd_sl;
extern Class_Descriptor cd_sm;
static Base_Class bases_de31[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_si,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sj,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sk,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sl,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_sm,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_de31 = {  "de31", // class name
  bases_de31, 5,
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  fe0  {
  ::yi fa;
  ::yj fb;
  ::yk fc;
  ::yl fd;
  ::ym fe;
  char c;
};
//SIG(1 fe0) C1{ FC2{ Fc} FC3{ Fc} FC4{ Fc} FC5{ Fc} FC6{ Fc} Fc}



static void Test_fe0()
{
  {
    init_simple_test("fe0");
    fe0 lv;
    check2(sizeof(lv), 6, "sizeof(fe0)");
    check2(__alignof__(lv), 1, "__alignof__(fe0)");
    check_field_offset(lv, fa, 0, "fe0.fa");
    check_field_offset(lv, fb, 1, "fe0.fb");
    check_field_offset(lv, fc, 2, "fe0.fc");
    check_field_offset(lv, fd, 3, "fe0.fd");
    check_field_offset(lv, fe, 4, "fe0.fe");
    check_field_offset(lv, c, 5, "fe0.c");
  }
}
static Arrange_To_Call_Me vfe0(Test_fe0, "fe0", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  fe1  {
  ::si fa;
  ::sj fb;
  ::sk fc;
  ::sl fd;
  ::sm fe;
  char c;
};
//SIG(1 fe1) C1{ FC2{} FC3{} FC4{} FC5{} FC6{} Fc}



static void Test_fe1()
{
  {
    init_simple_test("fe1");
    fe1 lv;
    check2(sizeof(lv), 6, "sizeof(fe1)");
    check2(__alignof__(lv), 1, "__alignof__(fe1)");
    check_field_offset(lv, fa, 0, "fe1.fa");
    check_field_offset(lv, fb, 1, "fe1.fb");
    check_field_offset(lv, fc, 2, "fe1.fc");
    check_field_offset(lv, fd, 3, "fe1.fd");
    check_field_offset(lv, fe, 4, "fe1.fe");
    check_field_offset(lv, c, 5, "fe1.c");
  }
}
static Arrange_To_Call_Me vfe1(Test_fe1, "fe1", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  fe2  {
  ::yi fa;
  ::yj fb;
  ::yk fc;
  ::yl fd;
  ::ym fe;
  char c;
};
//SIG(1 fe2) C1{ FC2{ Fc} FC3{ Fc} FC4{ Fc} FC5{ Fc} FC6{ Fc} Fc}



static void Test_fe2()
{
  {
    init_simple_test("fe2");
    fe2 lv;
    check2(sizeof(lv), 6, "sizeof(fe2)");
    check2(__alignof__(lv), 1, "__alignof__(fe2)");
    check_field_offset(lv, fa, 0, "fe2.fa");
    check_field_offset(lv, fb, 1, "fe2.fb");
    check_field_offset(lv, fc, 2, "fe2.fc");
    check_field_offset(lv, fd, 3, "fe2.fd");
    check_field_offset(lv, fe, 4, "fe2.fe");
    check_field_offset(lv, c, 5, "fe2.c");
  }
}
static Arrange_To_Call_Me vfe2(Test_fe2, "fe2", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  fe3  {
  ::si fa;
  ::sj fb;
  ::sk fc;
  ::sl fd;
  ::sm fe;
  char c;
};
//SIG(1 fe3) C1{ FC2{} FC3{} FC4{} FC5{} FC6{} Fc}



static void Test_fe3()
{
  {
    init_simple_test("fe3");
    fe3 lv;
    check2(sizeof(lv), 6, "sizeof(fe3)");
    check2(__alignof__(lv), 1, "__alignof__(fe3)");
    check_field_offset(lv, fa, 0, "fe3.fa");
    check_field_offset(lv, fb, 1, "fe3.fb");
    check_field_offset(lv, fc, 2, "fe3.fc");
    check_field_offset(lv, fd, 3, "fe3.fd");
    check_field_offset(lv, fe, 4, "fe3.fe");
    check_field_offset(lv, c, 5, "fe3.c");
  }
}
static Arrange_To_Call_Me vfe3(Test_fe3, "fe3", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  fe4  {
  ::yi fa;
  ::yj fb;
  ::yk fc;
  ::yl fd;
  ::ym fe;
  char c;
};
//SIG(1 fe4) C1{ FC2{ Fc} FC3{ Fc} FC4{ Fc} FC5{ Fc} FC6{ Fc} Fc}



static void Test_fe4()
{
  {
    init_simple_test("fe4");
    fe4 lv;
    check2(sizeof(lv), 6, "sizeof(fe4)");
    check2(__alignof__(lv), 1, "__alignof__(fe4)");
    check_field_offset(lv, fa, 0, "fe4.fa");
    check_field_offset(lv, fb, 1, "fe4.fb");
    check_field_offset(lv, fc, 2, "fe4.fc");
    check_field_offset(lv, fd, 3, "fe4.fd");
    check_field_offset(lv, fe, 4, "fe4.fe");
    check_field_offset(lv, c, 5, "fe4.c");
  }
}
static Arrange_To_Call_Me vfe4(Test_fe4, "fe4", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  fe5  {
  ::si fa;
  ::sj fb;
  ::sk fc;
  ::sl fd;
  ::sm fe;
  char c;
};
//SIG(1 fe5) C1{ FC2{} FC3{} FC4{} FC5{} FC6{} Fc}



static void Test_fe5()
{
  {
    init_simple_test("fe5");
    fe5 lv;
    check2(sizeof(lv), 6, "sizeof(fe5)");
    check2(__alignof__(lv), 1, "__alignof__(fe5)");
    check_field_offset(lv, fa, 0, "fe5.fa");
    check_field_offset(lv, fb, 1, "fe5.fb");
    check_field_offset(lv, fc, 2, "fe5.fc");
    check_field_offset(lv, fd, 3, "fe5.fd");
    check_field_offset(lv, fe, 4, "fe5.fe");
    check_field_offset(lv, c, 5, "fe5.c");
  }
}
static Arrange_To_Call_Me vfe5(Test_fe5, "fe5", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  fe6  {
  ::yi fa;
  ::yj fb;
  ::yk fc;
  ::yl fd;
  ::ym fe;
  char c;
};
//SIG(1 fe6) C1{ FC2{ Fc} FC3{ Fc} FC4{ Fc} FC5{ Fc} FC6{ Fc} Fc}



static void Test_fe6()
{
  {
    init_simple_test("fe6");
    fe6 lv;
    check2(sizeof(lv), 6, "sizeof(fe6)");
    check2(__alignof__(lv), 1, "__alignof__(fe6)");
    check_field_offset(lv, fa, 0, "fe6.fa");
    check_field_offset(lv, fb, 1, "fe6.fb");
    check_field_offset(lv, fc, 2, "fe6.fc");
    check_field_offset(lv, fd, 3, "fe6.fd");
    check_field_offset(lv, fe, 4, "fe6.fe");
    check_field_offset(lv, c, 5, "fe6.c");
  }
}
static Arrange_To_Call_Me vfe6(Test_fe6, "fe6", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  fe7  {
  ::si fa;
  ::sj fb;
  ::sk fc;
  ::sl fd;
  ::sm fe;
  char c;
};
//SIG(1 fe7) C1{ FC2{} FC3{} FC4{} FC5{} FC6{} Fc}



static void Test_fe7()
{
  {
    init_simple_test("fe7");
    fe7 lv;
    check2(sizeof(lv), 6, "sizeof(fe7)");
    check2(__alignof__(lv), 1, "__alignof__(fe7)");
    check_field_offset(lv, fa, 0, "fe7.fa");
    check_field_offset(lv, fb, 1, "fe7.fb");
    check_field_offset(lv, fc, 2, "fe7.fc");
    check_field_offset(lv, fd, 3, "fe7.fd");
    check_field_offset(lv, fe, 4, "fe7.fe");
    check_field_offset(lv, c, 5, "fe7.c");
  }
}
static Arrange_To_Call_Me vfe7(Test_fe7, "fe7", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  fe8  {
  ::yi fa;
  ::yj fb;
  ::yk fc;
  ::yl fd;
  ::ym fe;
  char c;
};
//SIG(1 fe8) C1{ FC2{ Fc} FC3{ Fc} FC4{ Fc} FC5{ Fc} FC6{ Fc} Fc}



static void Test_fe8()
{
  {
    init_simple_test("fe8");
    fe8 lv;
    check2(sizeof(lv), 6, "sizeof(fe8)");
    check2(__alignof__(lv), 1, "__alignof__(fe8)");
    check_field_offset(lv, fa, 0, "fe8.fa");
    check_field_offset(lv, fb, 1, "fe8.fb");
    check_field_offset(lv, fc, 2, "fe8.fc");
    check_field_offset(lv, fd, 3, "fe8.fd");
    check_field_offset(lv, fe, 4, "fe8.fe");
    check_field_offset(lv, c, 5, "fe8.c");
  }
}
static Arrange_To_Call_Me vfe8(Test_fe8, "fe8", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  fe9  {
  ::si fa;
  ::sj fb;
  ::sk fc;
  ::sl fd;
  ::sm fe;
  char c;
};
//SIG(1 fe9) C1{ FC2{} FC3{} FC4{} FC5{} FC6{} Fc}



static void Test_fe9()
{
  {
    init_simple_test("fe9");
    fe9 lv;
    check2(sizeof(lv), 6, "sizeof(fe9)");
    check2(__alignof__(lv), 1, "__alignof__(fe9)");
    check_field_offset(lv, fa, 0, "fe9.fa");
    check_field_offset(lv, fb, 1, "fe9.fb");
    check_field_offset(lv, fc, 2, "fe9.fc");
    check_field_offset(lv, fd, 3, "fe9.fd");
    check_field_offset(lv, fe, 4, "fe9.fe");
    check_field_offset(lv, c, 5, "fe9.c");
  }
}
static Arrange_To_Call_Me vfe9(Test_fe9, "fe9", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  fe10  {
  ::yi fa;
  ::yj fb;
  ::yk fc;
  ::yl fd;
  ::ym fe;
  char c;
};
//SIG(1 fe10) C1{ FC2{ Fc} FC3{ Fc} FC4{ Fc} FC5{ Fc} FC6{ Fc} Fc}



static void Test_fe10()
{
  {
    init_simple_test("fe10");
    fe10 lv;
    check2(sizeof(lv), 6, "sizeof(fe10)");
    check2(__alignof__(lv), 1, "__alignof__(fe10)");
    check_field_offset(lv, fa, 0, "fe10.fa");
    check_field_offset(lv, fb, 1, "fe10.fb");
    check_field_offset(lv, fc, 2, "fe10.fc");
    check_field_offset(lv, fd, 3, "fe10.fd");
    check_field_offset(lv, fe, 4, "fe10.fe");
    check_field_offset(lv, c, 5, "fe10.c");
  }
}
static Arrange_To_Call_Me vfe10(Test_fe10, "fe10", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  fe11  {
  ::si fa;
  ::sj fb;
  ::sk fc;
  ::sl fd;
  ::sm fe;
  char c;
};
//SIG(1 fe11) C1{ FC2{} FC3{} FC4{} FC5{} FC6{} Fc}



static void Test_fe11()
{
  {
    init_simple_test("fe11");
    fe11 lv;
    check2(sizeof(lv), 6, "sizeof(fe11)");
    check2(__alignof__(lv), 1, "__alignof__(fe11)");
    check_field_offset(lv, fa, 0, "fe11.fa");
    check_field_offset(lv, fb, 1, "fe11.fb");
    check_field_offset(lv, fc, 2, "fe11.fc");
    check_field_offset(lv, fd, 3, "fe11.fd");
    check_field_offset(lv, fe, 4, "fe11.fe");
    check_field_offset(lv, c, 5, "fe11.c");
  }
}
static Arrange_To_Call_Me vfe11(Test_fe11, "fe11", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  fe12  {
  ::yi fa;
  ::yj fb;
  ::yk fc;
  ::yl fd;
  ::ym fe;
  char c;
};
//SIG(1 fe12) C1{ FC2{ Fc} FC3{ Fc} FC4{ Fc} FC5{ Fc} FC6{ Fc} Fc}



static void Test_fe12()
{
  {
    init_simple_test("fe12");
    fe12 lv;
    check2(sizeof(lv), 6, "sizeof(fe12)");
    check2(__alignof__(lv), 1, "__alignof__(fe12)");
    check_field_offset(lv, fa, 0, "fe12.fa");
    check_field_offset(lv, fb, 1, "fe12.fb");
    check_field_offset(lv, fc, 2, "fe12.fc");
    check_field_offset(lv, fd, 3, "fe12.fd");
    check_field_offset(lv, fe, 4, "fe12.fe");
    check_field_offset(lv, c, 5, "fe12.c");
  }
}
static Arrange_To_Call_Me vfe12(Test_fe12, "fe12", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  fe13  {
  ::si fa;
  ::sj fb;
  ::sk fc;
  ::sl fd;
  ::sm fe;
  char c;
};
//SIG(1 fe13) C1{ FC2{} FC3{} FC4{} FC5{} FC6{} Fc}



static void Test_fe13()
{
  {
    init_simple_test("fe13");
    fe13 lv;
    check2(sizeof(lv), 6, "sizeof(fe13)");
    check2(__alignof__(lv), 1, "__alignof__(fe13)");
    check_field_offset(lv, fa, 0, "fe13.fa");
    check_field_offset(lv, fb, 1, "fe13.fb");
    check_field_offset(lv, fc, 2, "fe13.fc");
    check_field_offset(lv, fd, 3, "fe13.fd");
    check_field_offset(lv, fe, 4, "fe13.fe");
    check_field_offset(lv, c, 5, "fe13.c");
  }
}
static Arrange_To_Call_Me vfe13(Test_fe13, "fe13", 6);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  fe14  {
  ::yi fa;
  ::yj fb;
  ::yk fc;
  ::yl fd;
  ::ym fe;
  char c;
};
//SIG(1 fe14) C1{ FC2{ Fc} FC3{ Fc} FC4{ Fc} FC5{ Fc} FC6{ Fc} Fc}



static void Test_fe14()
{
  {
    init_simple_test("fe14");
    fe14 lv;
    check2(sizeof(lv), 6, "sizeof(fe14)");
    check2(__alignof__(lv), 1, "__alignof__(fe14)");
    check_field_offset(lv, fa, 0, "fe14.fa");
    check_field_offset(lv, fb, 1, "fe14.fb");
   