// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S3213C4_nt  {
  int s3213c4f0[2];
  void  mf3213c4(); // _ZN10S3213C4_nt8mf3213c4Ev
};
//SIG(-1 S3213C4_nt) C1{ m Fi[2]}


void  S3213C4_nt ::mf3213c4(){}

//skip512 S3213C4_nt

#else // __cplusplus

Class_Descriptor cd_S3213C4_nt = {  "S3213C4_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  8, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3213C3_nt  {
  int s3213c3f0;
  __tsi64 s3213c3f1;
  void *s3213c3f2[4];
  int s3213c3f3[2];
  void *s3213c3f4;
  ::S3213C4_nt s3213c3f5;
  void *s3213c3f6[2];
  virtual  ~S3213C3_nt(); // _ZN10S3213C3_ntD1Ev
  virtual void  v4(); // _ZN10S3213C3_nt2v4Ev
  virtual void  v5(); // _ZN10S3213C3_nt2v5Ev
  virtual void  v6(); // _ZN10S3213C3_nt2v6Ev
  virtual void  v7(); // _ZN10S3213C3_nt2v7Ev
  virtual void  v8(); // _ZN10S3213C3_nt2v8Ev
  virtual void  v9(); // _ZN10S3213C3_nt2v9Ev
  virtual void  v10(); // _ZN10S3213C3_nt3v10Ev
  virtual void  v11(); // _ZN10S3213C3_nt3v11Ev
  virtual void  v12(); // _ZN10S3213C3_nt3v12Ev
  virtual void  v13(); // _ZN10S3213C3_nt3v13Ev
  virtual void  v14(); // _ZN10S3213C3_nt3v14Ev
  virtual void  v15(); // _ZN10S3213C3_nt3v15Ev
  virtual void  v16(); // _ZN10S3213C3_nt3v16Ev
  virtual void  v17(); // _ZN10S3213C3_nt3v17Ev
  virtual void  v18(); // _ZN10S3213C3_nt3v18Ev
  virtual void  v19(); // _ZN10S3213C3_nt3v19Ev
  virtual void  v20(); // _ZN10S3213C3_nt3v20Ev
  virtual void  v21(); // _ZN10S3213C3_nt3v21Ev
  virtual void  v22(); // _ZN10S3213C3_nt3v22Ev
  virtual void  v23(); // _ZN10S3213C3_nt3v23Ev
  virtual void  v24(); // _ZN10S3213C3_nt3v24Ev
  virtual void  v25(); // _ZN10S3213C3_nt3v25Ev
  virtual void  v26(); // _ZN10S3213C3_nt3v26Ev
  virtual void  v27(); // _ZN10S3213C3_nt3v27Ev
  virtual void  v28(); // _ZN10S3213C3_nt3v28Ev
  virtual void  v29(); // _ZN10S3213C3_nt3v29Ev
  virtual void  v30(); // _ZN10S3213C3_nt3v30Ev
  virtual void  v31(); // _ZN10S3213C3_nt3v31Ev
  virtual void  v32(); // _ZN10S3213C3_nt3v32Ev
  virtual void  v33(); // _ZN10S3213C3_nt3v33Ev
  virtual void  v34(); // _ZN10S3213C3_nt3v34Ev
  virtual void  v35(); // _ZN10S3213C3_nt3v35Ev
  virtual void  v36(); // _ZN10S3213C3_nt3v36Ev
  virtual void  v37(); // _ZN10S3213C3_nt3v37Ev
  virtual void  v38(); // _ZN10S3213C3_nt3v38Ev
  virtual void  v39(); // _ZN10S3213C3_nt3v39Ev
  virtual void  v40(); // _ZN10S3213C3_nt3v40Ev
  virtual void  v41(); // _ZN10S3213C3_nt3v41Ev
  virtual void  v42(); // _ZN10S3213C3_nt3v42Ev
  virtual void  v43(); // _ZN10S3213C3_nt3v43Ev
  virtual void  v44(); // _ZN10S3213C3_nt3v44Ev
  virtual void  v45(); // _ZN10S3213C3_nt3v45Ev
  virtual void  v46(); // _ZN10S3213C3_nt3v46Ev
  virtual void  v47(); // _ZN10S3213C3_nt3v47Ev
  virtual void  v48(); // _ZN10S3213C3_nt3v48Ev
  virtual void  v49(); // _ZN10S3213C3_nt3v49Ev
  virtual void  v50(); // _ZN10S3213C3_nt3v50Ev
  virtual void  v51(); // _ZN10S3213C3_nt3v51Ev
  virtual void  v52(); // _ZN10S3213C3_nt3v52Ev
  virtual void  v53(); // _ZN10S3213C3_nt3v53Ev
  virtual void  v54(); // _ZN10S3213C3_nt3v54Ev
  virtual void  v55(); // _ZN10S3213C3_nt3v55Ev
  virtual void  v56(); // _ZN10S3213C3_nt3v56Ev
  virtual void  v57(); // _ZN10S3213C3_nt3v57Ev
  virtual void  v58(); // _ZN10S3213C3_nt3v58Ev
  virtual void  v59(); // _ZN10S3213C3_nt3v59Ev
  virtual void  v60(); // _ZN10S3213C3_nt3v60Ev
  virtual void  v61(); // _ZN10S3213C3_nt3v61Ev
  virtual void  v62(); // _ZN10S3213C3_nt3v62Ev
  virtual void  v63(); // _ZN10S3213C3_nt3v63Ev
  virtual void  v64(); // _ZN10S3213C3_nt3v64Ev
  virtual void  v65(); // _ZN10S3213C3_nt3v65Ev
  virtual void  v66(); // _ZN10S3213C3_nt3v66Ev
  virtual void  v67(); // _ZN10S3213C3_nt3v67Ev
  S3213C3_nt(); // tgen
};
//SIG(-1 S3213C3_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S3213C3_nt ::~S3213C3_nt(){ note_dtor("S3213C3_nt", this);}
void  S3213C3_nt ::v4(){vfunc_called(this, "_ZN10S3213C3_nt2v4Ev");}
void  S3213C3_nt ::v5(){vfunc_called(this, "_ZN10S3213C3_nt2v5Ev");}
void  S3213C3_nt ::v6(){vfunc_called(this, "_ZN10S3213C3_nt2v6Ev");}
void  S3213C3_nt ::v7(){vfunc_called(this, "_ZN10S3213C3_nt2v7Ev");}
void  S3213C3_nt ::v8(){vfunc_called(this, "_ZN10S3213C3_nt2v8Ev");}
void  S3213C3_nt ::v9(){vfunc_called(this, "_ZN10S3213C3_nt2v9Ev");}
void  S3213C3_nt ::v10(){vfunc_called(this, "_ZN10S3213C3_nt3v10Ev");}
void  S3213C3_nt ::v11(){vfunc_called(this, "_ZN10S3213C3_nt3v11Ev");}
void  S3213C3_nt ::v12(){vfunc_called(this, "_ZN10S3213C3_nt3v12Ev");}
void  S3213C3_nt ::v13(){vfunc_called(this, "_ZN10S3213C3_nt3v13Ev");}
void  S3213C3_nt ::v14(){vfunc_called(this, "_ZN10S3213C3_nt3v14Ev");}
void  S3213C3_nt ::v15(){vfunc_called(this, "_ZN10S3213C3_nt3v15Ev");}
void  S3213C3_nt ::v16(){vfunc_called(this, "_ZN10S3213C3_nt3v16Ev");}
void  S3213C3_nt ::v17(){vfunc_called(this, "_ZN10S3213C3_nt3v17Ev");}
void  S3213C3_nt ::v18(){vfunc_called(this, "_ZN10S3213C3_nt3v18Ev");}
void  S3213C3_nt ::v19(){vfunc_called(this, "_ZN10S3213C3_nt3v19Ev");}
void  S3213C3_nt ::v20(){vfunc_called(this, "_ZN10S3213C3_nt3v20Ev");}
void  S3213C3_nt ::v21(){vfunc_called(this, "_ZN10S3213C3_nt3v21Ev");}
void  S3213C3_nt ::v22(){vfunc_called(this, "_ZN10S3213C3_nt3v22Ev");}
void  S3213C3_nt ::v23(){vfunc_called(this, "_ZN10S3213C3_nt3v23Ev");}
void  S3213C3_nt ::v24(){vfunc_called(this, "_ZN10S3213C3_nt3v24Ev");}
void  S3213C3_nt ::v25(){vfunc_called(this, "_ZN10S3213C3_nt3v25Ev");}
void  S3213C3_nt ::v26(){vfunc_called(this, "_ZN10S3213C3_nt3v26Ev");}
void  S3213C3_nt ::v27(){vfunc_called(this, "_ZN10S3213C3_nt3v27Ev");}
void  S3213C3_nt ::v28(){vfunc_called(this, "_ZN10S3213C3_nt3v28Ev");}
void  S3213C3_nt ::v29(){vfunc_called(this, "_ZN10S3213C3_nt3v29Ev");}
void  S3213C3_nt ::v30(){vfunc_called(this, "_ZN10S3213C3_nt3v30Ev");}
void  S3213C3_nt ::v31(){vfunc_called(this, "_ZN10S3213C3_nt3v31Ev");}
void  S3213C3_nt ::v32(){vfunc_called(this, "_ZN10S3213C3_nt3v32Ev");}
void  S3213C3_nt ::v33(){vfunc_called(this, "_ZN10S3213C3_nt3v33Ev");}
void  S3213C3_nt ::v34(){vfunc_called(this, "_ZN10S3213C3_nt3v34Ev");}
void  S3213C3_nt ::v35(){vfunc_called(this, "_ZN10S3213C3_nt3v35Ev");}
void  S3213C3_nt ::v36(){vfunc_called(this, "_ZN10S3213C3_nt3v36Ev");}
void  S3213C3_nt ::v37(){vfunc_called(this, "_ZN10S3213C3_nt3v37Ev");}
void  S3213C3_nt ::v38(){vfunc_called(this, "_ZN10S3213C3_nt3v38Ev");}
void  S3213C3_nt ::v39(){vfunc_called(this, "_ZN10S3213C3_nt3v39Ev");}
void  S3213C3_nt ::v40(){vfunc_called(this, "_ZN10S3213C3_nt3v40Ev");}
void  S3213C3_nt ::v41(){vfunc_called(this, "_ZN10S3213C3_nt3v41Ev");}
void  S3213C3_nt ::v42(){vfunc_called(this, "_ZN10S3213C3_nt3v42Ev");}
void  S3213C3_nt ::v43(){vfunc_called(this, "_ZN10S3213C3_nt3v43Ev");}
void  S3213C3_nt ::v44(){vfunc_called(this, "_ZN10S3213C3_nt3v44Ev");}
void  S3213C3_nt ::v45(){vfunc_called(this, "_ZN10S3213C3_nt3v45Ev");}
void  S3213C3_nt ::v46(){vfunc_called(this, "_ZN10S3213C3_nt3v46Ev");}
void  S3213C3_nt ::v47(){vfunc_called(this, "_ZN10S3213C3_nt3v47Ev");}
void  S3213C3_nt ::v48(){vfunc_called(this, "_ZN10S3213C3_nt3v48Ev");}
void  S3213C3_nt ::v49(){vfunc_called(this, "_ZN10S3213C3_nt3v49Ev");}
void  S3213C3_nt ::v50(){vfunc_called(this, "_ZN10S3213C3_nt3v50Ev");}
void  S3213C3_nt ::v51(){vfunc_called(this, "_ZN10S3213C3_nt3v51Ev");}
void  S3213C3_nt ::v52(){vfunc_called(this, "_ZN10S3213C3_nt3v52Ev");}
void  S3213C3_nt ::v53(){vfunc_called(this, "_ZN10S3213C3_nt3v53Ev");}
void  S3213C3_nt ::v54(){vfunc_called(this, "_ZN10S3213C3_nt3v54Ev");}
void  S3213C3_nt ::v55(){vfunc_called(this, "_ZN10S3213C3_nt3v55Ev");}
void  S3213C3_nt ::v56(){vfunc_called(this, "_ZN10S3213C3_nt3v56Ev");}
void  S3213C3_nt ::v57(){vfunc_called(this, "_ZN10S3213C3_nt3v57Ev");}
void  S3213C3_nt ::v58(){vfunc_called(this, "_ZN10S3213C3_nt3v58Ev");}
void  S3213C3_nt ::v59(){vfunc_called(this, "_ZN10S3213C3_nt3v59Ev");}
void  S3213C3_nt ::v60(){vfunc_called(this, "_ZN10S3213C3_nt3v60Ev");}
void  S3213C3_nt ::v61(){vfunc_called(this, "_ZN10S3213C3_nt3v61Ev");}
void  S3213C3_nt ::v62(){vfunc_called(this, "_ZN10S3213C3_nt3v62Ev");}
void  S3213C3_nt ::v63(){vfunc_called(this, "_ZN10S3213C3_nt3v63Ev");}
void  S3213C3_nt ::v64(){vfunc_called(this, "_ZN10S3213C3_nt3v64Ev");}
void  S3213C3_nt ::v65(){vfunc_called(this, "_ZN10S3213C3_nt3v65Ev");}
void  S3213C3_nt ::v66(){vfunc_called(this, "_ZN10S3213C3_nt3v66Ev");}
void  S3213C3_nt ::v67(){vfunc_called(this, "_ZN10S3213C3_nt3v67Ev");}
S3213C3_nt ::S3213C3_nt(){ note_ctor("S3213C3_nt", this);} // tgen

//skip512 S3213C3_nt

#else // __cplusplus

extern void _ZN10S3213C3_ntC1Ev();
extern void _ZN10S3213C3_ntD1Ev();
Name_Map name_map_S3213C3_nt[] = {
  NSPAIR(_ZN10S3213C3_ntC1Ev),
  NSPAIR(_ZN10S3213C3_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S3213C3_nt[];
extern void _ZN10S3213C3_ntD1Ev();
extern void _ZN10S3213C3_ntD0Ev();
extern void _ZN10S3213C3_nt2v4Ev();
extern void _ZN10S3213C3_nt2v5Ev();
extern void _ZN10S3213C3_nt2v6Ev();
extern void _ZN10S3213C3_nt2v7Ev();
extern void _ZN10S3213C3_nt2v8Ev();
extern void _ZN10S3213C3_nt2v9Ev();
extern void _ZN10S3213C3_nt3v10Ev();
extern void _ZN10S3213C3_nt3v11Ev();
extern void _ZN10S3213C3_nt3v12Ev();
extern void _ZN10S3213C3_nt3v13Ev();
extern void _ZN10S3213C3_nt3v14Ev();
extern void _ZN10S3213C3_nt3v15Ev();
extern void _ZN10S3213C3_nt3v16Ev();
extern void _ZN10S3213C3_nt3v17Ev();
extern void _ZN10S3213C3_nt3v18Ev();
extern void _ZN10S3213C3_nt3v19Ev();
extern void _ZN10S3213C3_nt3v20Ev();
extern void _ZN10S3213C3_nt3v21Ev();
extern void _ZN10S3213C3_nt3v22Ev();
extern void _ZN10S3213C3_nt3v23Ev();
extern void _ZN10S3213C3_nt3v24Ev();
extern void _ZN10S3213C3_nt3v25Ev();
extern void _ZN10S3213C3_nt3v26Ev();
extern void _ZN10S3213C3_nt3v27Ev();
extern void _ZN10S3213C3_nt3v28Ev();
extern void _ZN10S3213C3_nt3v29Ev();
extern void _ZN10S3213C3_nt3v30Ev();
extern void _ZN10S3213C3_nt3v31Ev();
extern void _ZN10S3213C3_nt3v32Ev();
extern void _ZN10S3213C3_nt3v33Ev();
extern void _ZN10S3213C3_nt3v34Ev();
extern void _ZN10S3213C3_nt3v35Ev();
extern void _ZN10S3213C3_nt3v36Ev();
extern void _ZN10S3213C3_nt3v37Ev();
extern void _ZN10S3213C3_nt3v38Ev();
extern void _ZN10S3213C3_nt3v39Ev();
extern void _ZN10S3213C3_nt3v40Ev();
extern void _ZN10S3213C3_nt3v41Ev();
extern void _ZN10S3213C3_nt3v42Ev();
extern void _ZN10S3213C3_nt3v43Ev();
extern void _ZN10S3213C3_nt3v44Ev();
extern void _ZN10S3213C3_nt3v45Ev();
extern void _ZN10S3213C3_nt3v46Ev();
extern void _ZN10S3213C3_nt3v47Ev();
extern void _ZN10S3213C3_nt3v48Ev();
extern void _ZN10S3213C3_nt3v49Ev();
extern void _ZN10S3213C3_nt3v50Ev();
extern void _ZN10S3213C3_nt3v51Ev();
extern void _ZN10S3213C3_nt3v52Ev();
extern void _ZN10S3213C3_nt3v53Ev();
extern void _ZN10S3213C3_nt3v54Ev();
extern void _ZN10S3213C3_nt3v55Ev();
extern void _ZN10S3213C3_nt3v56Ev();
extern void _ZN10S3213C3_nt3v57Ev();
extern void _ZN10S3213C3_nt3v58Ev();
extern void _ZN10S3213C3_nt3v59Ev();
extern void _ZN10S3213C3_nt3v60Ev();
extern void _ZN10S3213C3_nt3v61Ev();
extern void _ZN10S3213C3_nt3v62Ev();
extern void _ZN10S3213C3_nt3v63Ev();
extern void _ZN10S3213C3_nt3v64Ev();
extern void _ZN10S3213C3_nt3v65Ev();
extern void _ZN10S3213C3_nt3v66Ev();
extern void _ZN10S3213C3_nt3v67Ev();
static  VTBL_ENTRY vtc_S3213C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S3213C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S3213C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v67Ev,
};
extern VTBL_ENTRY _ZTI10S3213C3_nt[];
VTBL_ENTRY *P__ZTI10S3213C3_nt = _ZTI10S3213C3_nt; 
extern  VTBL_ENTRY _ZTV10S3213C3_nt[];
Class_Descriptor cd_S3213C3_nt = {  "S3213C3_nt", // class name
  0,0,//no base classes
  &(vtc_S3213C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI10S3213C3_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S3213C3_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3213C7_nt  {
  void *s3213c7f0;
  int s3213c7f1[2];
  void  mf3213c7(); // _ZN10S3213C7_nt8mf3213c7Ev
};
//SIG(-1 S3213C7_nt) C1{ m Fp Fi[2]}


void  S3213C7_nt ::mf3213c7(){}

//skip512 S3213C7_nt

#else // __cplusplus

Class_Descriptor cd_S3213C7_nt = {  "S3213C7_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3213C6_nt  : S3213C7_nt {
};
//SIG(-1 S3213C6_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S3213C6_nt

#else // __cplusplus

extern Class_Descriptor cd_S3213C7_nt;
static Base_Class bases_S3213C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3213C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3213C6_nt = {  "S3213C6_nt", // class name
  bases_S3213C6_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3213C5_nt  : S3213C6_nt {
};
//SIG(-1 S3213C5_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S3213C5_nt

#else // __cplusplus

extern Class_Descriptor cd_S3213C7_nt;
extern Class_Descriptor cd_S3213C6_nt;
static Base_Class bases_S3213C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3213C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3213C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3213C8_nt  {
  int s3213c8f0;
  void  mf3213c8(); // _ZN10S3213C8_nt8mf3213c8Ev
};
//SIG(-1 S3213C8_nt) C1{ m Fi}


void  S3213C8_nt ::mf3213c8(){}

//skip512 S3213C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3213C12  : S3213C7_nt {
};
//SIG(-1 S3213C12) C1{ BC2{ m Fp Fi[2]}}



static void Test_S3213C12()
{
  extern Class_Descriptor cd_S3213C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3213C12, buf);
    S3213C12 &lv = *(new (buf) S3213C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3213C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3213C12)");
    check_base_class_offset(lv, (S3213C7_nt*), 0, "S3213C12");
    test_class_info(&lv, &cd_S3213C12);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3213C12(Test_S3213C12, "S3213C12", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3213C7_nt;
static Base_Class bases_S3213C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3213C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3213C12 = {  "S3213C12", // class name
  bases_S3213C12, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3213C11  : S3213C12 {
};
//SIG(-1 S3213C11) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S3213C11()
{
  extern Class_Descriptor cd_S3213C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3213C11, buf);
    S3213C11 &lv = *(new (buf) S3213C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3213C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3213C11)");
    check_base_class_offset(lv, (S3213C7_nt*)(S3213C12*), 0, "S3213C11");
    check_base_class_offset(lv, (S3213C12*), 0, "S3213C11");
    test_class_info(&lv, &cd_S3213C11);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3213C11(Test_S3213C11, "S3213C11", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3213C7_nt;
extern Class_Descriptor cd_S3213C12;
static Base_Class bases_S3213C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3213C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3213C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3213C11 = {  "S3213C11", // class name
  bases_S3213C11, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3213C13_nt  {
  int s3213c13f0[3];
  void  mf3213c13(); // _ZN11S3213C13_nt9mf3213c13Ev
};
//SIG(-1 S3213C13_nt) C1{ m Fi[3]}


void  S3213C13_nt ::mf3213c13(){}

//skip512 S3213C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3213C18  : S3213C7_nt {
};
//SIG(-1 S3213C18) C1{ BC2{ m Fp Fi[2]}}



static void Test_S3213C18()
{
  extern Class_Descriptor cd_S3213C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3213C18, buf);
    S3213C18 &lv = *(new (buf) S3213C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3213C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3213C18)");
    check_base_class_offset(lv, (S3213C7_nt*), 0, "S3213C18");
    test_class_info(&lv, &cd_S3213C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3213C18(Test_S3213C18, "S3213C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3213C7_nt;
static Base_Class bases_S3213C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3213C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3213C18 = {  "S3213C18", // class name
  bases_S3213C18, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3213C17  : S3213C18 {
};
//SIG(-1 S3213C17) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S3213C17()
{
  extern Class_Descriptor cd_S3213C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3213C17, buf);
    S3213C17 &lv = *(new (buf) S3213C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3213C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3213C17)");
    check_base_class_offset(lv, (S3213C7_nt*)(S3213C18*), 0, "S3213C17");
    check_base_class_offset(lv, (S3213C18*), 0, "S3213C17");
    test_class_info(&lv, &cd_S3213C17);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3213C17(Test_S3213C17, "S3213C17", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3213C7_nt;
extern Class_Descriptor cd_S3213C18;
static Base_Class bases_S3213C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3213C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3213C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3213C17 = {  "S3213C17", // class name
  bases_S3213C17, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3213C2_nt  : S3213C3_nt {
  ::S3213C5_nt s3213c2f0;
  ::S3213C5_nt s3213c2f1;
  ::S3213C8_nt s3213c2f2;
  int s3213c2f3;
  char s3213c2f4[4];
  void *s3213c2f5[2];
  ::S3213C5_nt s3213c2f6;
  unsigned int s3213c2f7:1;
  unsigned int s3213c2f8:1;
  unsigned int s3213c2f9:1;
  unsigned int s3213c2f10:1;
  unsigned int s3213c2f11:1;
  unsigned int s3213c2f12:1;
  unsigned int s3213c2f13:1;
  unsigned int s3213c2f14:1;
  unsigned int s3213c2f15:1;
  unsigned int s3213c2f16:1;
  unsigned int s3213c2f17:1;
  unsigned int s3213c2f18:1;
  unsigned int s3213c2f19:1;
  unsigned int s3213c2f20:1;
  unsigned int s3213c2f21:1;
  unsigned int s3213c2f22:1;
  unsigned int s3213c2f23:1;
  unsigned int s3213c2f24:1;
  unsigned int s3213c2f25:1;
  unsigned int s3213c2f26:1;
  unsigned int s3213c2f27:1;
  unsigned int s3213c2f28:1;
  unsigned int s3213c2f29:1;
  unsigned int s3213c2f30:1;
  unsigned int s3213c2f31:1;
  unsigned int s3213c2f32:1;
  unsigned int s3213c2f33:1;
  unsigned int s3213c2f34:1;
  unsigned int s3213c2f35:1;
  unsigned int s3213c2f36:1;
  unsigned int s3213c2f37:1;
  unsigned int s3213c2f38:1;
  unsigned int s3213c2f39:1;
  unsigned int s3213c2f40:1;
  unsigned int s3213c2f41:1;
  unsigned int s3213c2f42:1;
  unsigned int s3213c2f43:1;
  unsigned int s3213c2f44:1;
  unsigned int s3213c2f45:1;
  unsigned int s3213c2f46:1;
  unsigned int s3213c2f47:1;
  unsigned int s3213c2f48:1;
  unsigned int s3213c2f49:1;
  unsigned int s3213c2f50:1;
  unsigned int s3213c2f51:1;
  unsigned int s3213c2f52:1;
  unsigned int s3213c2f53:1;
  unsigned int s3213c2f54:1;
  unsigned int s3213c2f55:1;
  unsigned int s3213c2f56:1;
  unsigned int s3213c2f57:1;
  unsigned int s3213c2f58:1;
  unsigned int s3213c2f59:1;
  unsigned int s3213c2f60:1;
  unsigned int s3213c2f61:1;
  unsigned int s3213c2f62:1;
  unsigned int s3213c2f63:1;
  unsigned int s3213c2f64:1;
  unsigned int s3213c2f65:1;
  unsigned int s3213c2f66:1;
  unsigned int s3213c2f67:1;
  unsigned int s3213c2f68:1;
  unsigned int s3213c2f69:1;
  unsigned int s3213c2f70:1;
  unsigned int s3213c2f71:1;
  unsigned int s3213c2f72:1;
  unsigned int s3213c2f73:1;
  unsigned int s3213c2f74:1;
  unsigned int s3213c2f75:1;
  unsigned int s3213c2f76:1;
  unsigned int s3213c2f77:1;
  unsigned int s3213c2f78:1;
  unsigned int s3213c2f79:1;
  unsigned int s3213c2f80:1;
  unsigned int s3213c2f81:1;
  unsigned int s3213c2f82:1;
  unsigned int s3213c2f83:1;
  int s3213c2f84[5];
  void *s3213c2f85[2];
  int s3213c2f86[3];
  ::S3213C4_nt s3213c2f87;
  ::S3213C4_nt s3213c2f88;
  ::S3213C4_nt s3213c2f89;
  ::S3213C11 s3213c2f90;
  ::S3213C11 s3213c2f91;
  int s3213c2f92;
  void *s3213c2f93[2];
  ::S3213C13_nt s3213c2f94;
  ::S3213C13_nt s3213c2f95;
  ::S3213C13_nt s3213c2f96;
  ::S3213C13_nt s3213c2f97;
  void *s3213c2f98;
  ::S3213C4_nt s3213c2f99;
  ::S3213C11 s3213c2f100;
  ::S3213C13_nt s3213c2f101;
  ::S3213C13_nt s3213c2f102;
  int s3213c2f103;
  ::S3213C13_nt s3213c2f104;
  ::S3213C13_nt s3213c2f105;
  void *s3213c2f106;
  int s3213c2f107;
  char s3213c2f108;
  ::S3213C13_nt s3213c2f109;
  ::S3213C13_nt s3213c2f110;
  void *s3213c2f111;
  int s3213c2f112;
  void *s3213c2f113;
  ::S3213C11 s3213c2f114;
  ::S3213C17 s3213c2f115;
  ::S3213C17 s3213c2f116;
  virtual  ~S3213C2_nt(); // _ZN10S3213C2_ntD1Ev
  virtual void  v68(); // _ZN10S3213C2_nt3v68Ev
  virtual void  v69(); // _ZN10S3213C2_nt3v69Ev
  virtual void  v70(); // _ZN10S3213C2_nt3v70Ev
  virtual void  v71(); // _ZN10S3213C2_nt3v71Ev
  virtual void  v72(); // _ZN10S3213C2_nt3v72Ev
  virtual void  v73(); // _ZN10S3213C2_nt3v73Ev
  virtual void  v74(); // _ZN10S3213C2_nt3v74Ev
  virtual void  v75(); // _ZN10S3213C2_nt3v75Ev
  virtual void  v76(); // _ZN10S3213C2_nt3v76Ev
  virtual void  v77(); // _ZN10S3213C2_nt3v77Ev
  virtual void  v78(); // _ZN10S3213C2_nt3v78Ev
  virtual void  v79(); // _ZN10S3213C2_nt3v79Ev
  virtual void  v80(); // _ZN10S3213C2_nt3v80Ev
  virtual void  v81(); // _ZN10S3213C2_nt3v81Ev
  virtual void  v82(); // _ZN10S3213C2_nt3v82Ev
  virtual void  v83(); // _ZN10S3213C2_nt3v83Ev
  virtual void  v84(); // _ZN10S3213C2_nt3v84Ev
  virtual void  v85(); // _ZN10S3213C2_nt3v85Ev
  virtual void  v86(); // _ZN10S3213C2_nt3v86Ev
  virtual void  v87(); // _ZN10S3213C2_nt3v87Ev
  virtual void  v88(); // _ZN10S3213C2_nt3v88Ev
  virtual void  v89(); // _ZN10S3213C2_nt3v89Ev
  virtual void  v90(); // _ZN10S3213C2_nt3v90Ev
  virtual void  v91(); // _ZN10S3213C2_nt3v91Ev
  virtual void  v92(); // _ZN10S3213C2_nt3v92Ev
  virtual void  v93(); // _ZN10S3213C2_nt3v93Ev
  virtual void  v94(); // _ZN10S3213C2_nt3v94Ev
  virtual void  v95(); // _ZN10S3213C2_nt3v95Ev
  virtual void  v96(); // _ZN10S3213C2_nt3v96Ev
  virtual void  v97(); // _ZN10S3213C2_nt3v97Ev
  virtual void  v98(); // _ZN10S3213C2_nt3v98Ev
  virtual void  v99(); // _ZN10S3213C2_nt3v99Ev
  virtual void  v100(); // _ZN10S3213C2_nt4v100Ev
  virtual void  v101(); // _ZN10S3213C2_nt4v101Ev
  virtual void  v102(); // _ZN10S3213C2_nt4v102Ev
  virtual void  v103(); // _ZN10S3213C2_nt4v103Ev
  virtual void  v104(); // _ZN10S3213C2_nt4v104Ev
  virtual void  v105(); // _ZN10S3213C2_nt4v105Ev
  virtual void  v106(); // _ZN10S3213C2_nt4v106Ev
  virtual void  v107(); // _ZN10S3213C2_nt4v107Ev
  virtual void  v108(); // _ZN10S3213C2_nt4v108Ev
  virtual void  v109(); // _ZN10S3213C2_nt4v109Ev
  virtual void  v110(); // _ZN10S3213C2_nt4v110Ev
  virtual void  v111(); // _ZN10S3213C2_nt4v111Ev
  virtual void  v112(); // _ZN10S3213C2_nt4v112Ev
  virtual void  v113(); // _ZN10S3213C2_nt4v113Ev
  virtual void  v114(); // _ZN10S3213C2_nt4v114Ev
  virtual void  v115(); // _ZN10S3213C2_nt4v115Ev
  virtual void  v116(); // _ZN10S3213C2_nt4v116Ev
  virtual void  v117(); // _ZN10S3213C2_nt4v117Ev
  virtual void  v118(); // _ZN10S3213C2_nt4v118Ev
  virtual void  v119(); // _ZN10S3213C2_nt4v119Ev
  virtual void  v120(); // _ZN10S3213C2_nt4v120Ev
  virtual void  v121(); // _ZN10S3213C2_nt4v121Ev
  virtual void  v122(); // _ZN10S3213C2_nt4v122Ev
  virtual void  v123(); // _ZN10S3213C2_nt4v123Ev
  virtual void  v124(); // _ZN10S3213C2_nt4v124Ev
  virtual void  v125(); // _ZN10S3213C2_nt4v125Ev
  virtual void  v126(); // _ZN10S3213C2_nt4v126Ev
  virtual void  v127(); // _ZN10S3213C2_nt4v127Ev
  virtual void  v128(); // _ZN10S3213C2_nt4v128Ev
  virtual void  v129(); // _ZN10S3213C2_nt4v129Ev
  virtual void  v130(); // _ZN10S3213C2_nt4v130Ev
  virtual void  v131(); // _ZN10S3213C2_nt4v131Ev
  virtual void  v132(); // _ZN10S3213C2_nt4v132Ev
  virtual void  v133(); // _ZN10S3213C2_nt4v133Ev
  virtual void  v134(); // _ZN10S3213C2_nt4v134Ev
  virtual void  v135(); // _ZN10S3213C2_nt4v135Ev
  virtual void  v136(); // _ZN10S3213C2_nt4v136Ev
  virtual void  v137(); // _ZN10S3213C2_nt4v137Ev
  virtual void  v138(); // _ZN10S3213C2_nt4v138Ev
  virtual void  v139(); // _ZN10S3213C2_nt4v139Ev
  virtual void  v140(); // _ZN10S3213C2_nt4v140Ev
  virtual void  v141(); // _ZN10S3213C2_nt4v141Ev
  virtual void  v142(); // _ZN10S3213C2_nt4v142Ev
  virtual void  v143(); // _ZN10S3213C2_nt4v143Ev
  virtual void  v144(); // _ZN10S3213C2_nt4v144Ev
  virtual void  v145(); // _ZN10S3213C2_nt4v145Ev
  virtual void  v146(); // _ZN10S3213C2_nt4v146Ev
  virtual void  v147(); // _ZN10S3213C2_nt4v147Ev
  virtual void  v148(); // _ZN10S3213C2_nt4v148Ev
  virtual void  v149(); // _ZN10S3213C2_nt4v149Ev
  virtual void  v150(); // _ZN10S3213C2_nt4v150Ev
  virtual void  v151(); // _ZN10S3213C2_nt4v151Ev
  virtual void  v152(); // _ZN10S3213C2_nt4v152Ev
  virtual void  v153(); // _ZN10S3213C2_nt4v153Ev
  virtual void  v154(); // _ZN10S3213C2_nt4v154Ev
  virtual void  v155(); // _ZN10S3213C2_nt4v155Ev
  virtual void  v156(); // _ZN10S3213C2_nt4v156Ev
  virtual void  v157(); // _ZN10S3213C2_nt4v157Ev
  virtual void  v158(); // _ZN10S3213C2_nt4v158Ev
  virtual void  v159(); // _ZN10S3213C2_nt4v159Ev
  virtual void  v160(); // _ZN10S3213C2_nt4v160Ev
  virtual void  v161(); // _ZN10S3213C2_nt4v161Ev
  virtual void  v162(); // _ZN10S3213C2_nt4v162Ev
  virtual void  v163(); // _ZN10S3213C2_nt4v163Ev
  virtual void  v164(); // _ZN10S3213C2_nt4v164Ev
  virtual void  v165(); // _ZN10S3213C2_nt4v165Ev
  virtual void  v166(); // _ZN10S3213C2_nt4v166Ev
  virtual void  v167(); // _ZN10S3213C2_nt4v167Ev
  virtual void  v168(); // _ZN10S3213C2_nt4v168Ev
  virtual void  v169(); // _ZN10S3213C2_nt4v169Ev
  virtual void  v170(); // _ZN10S3213C2_nt4v170Ev
  virtual void  v171(); // _ZN10S3213C2_nt4v171Ev
  virtual void  v172(); // _ZN10S3213C2_nt4v172Ev
  virtual void  v173(); // _ZN10S3213C2_nt4v173Ev
  virtual void  v174(); // _ZN10S3213C2_nt4v174Ev
  virtual void  v175(); // _ZN10S3213C2_nt4v175Ev
  virtual void  v176(); // _ZN10S3213C2_nt4v176Ev
  virtual void  v177(); // _ZN10S3213C2_nt4v177Ev
  virtual void  v178(); // _ZN10S3213C2_nt4v178Ev
  virtual void  v179(); // _ZN10S3213C2_nt4v179Ev
  virtual void  v180(); // _ZN10S3213C2_nt4v180Ev
  virtual void  v181(); // _ZN10S3213C2_nt4v181Ev
  virtual void  v182(); // _ZN10S3213C2_nt4v182Ev
  virtual void  v183(); // _ZN10S3213C2_nt4v183Ev
  virtual void  v184(); // _ZN10S3213C2_nt4v184Ev
  virtual void  v185(); // _ZN10S3213C2_nt4v185Ev
  virtual void  v186(); // _ZN10S3213C2_nt4v186Ev
  virtual void  v187(); // _ZN10S3213C2_nt4v187Ev
  virtual void  v188(); // _ZN10S3213C2_nt4v188Ev
  virtual void  v189(); // _ZN10S3213C2_nt4v189Ev
  virtual void  v190(); // _ZN10S3213C2_nt4v190Ev
  virtual void  v191(); // _ZN10S3213C2_nt4v191Ev
  virtual void  v192(); // _ZN10S3213C2_nt4v192Ev
  virtual void  v193(); // _ZN10S3213C2_nt4v193Ev
  virtual void  v194(); // _ZN10S3213C2_nt4v194Ev
  virtual void  v195(); // _ZN10S3213C2_nt4v195Ev
  virtual void  v196(); // _ZN10S3213C2_nt4v196Ev
  virtual void  v197(); // _ZN10S3213C2_nt4v197Ev
  virtual void  v198(); // _ZN10S3213C2_nt4v198Ev
  virtual void  v199(); // _ZN10S3213C2_nt4v199Ev
  virtual void  v200(); // _ZN10S3213C2_nt4v200Ev
  virtual void  v201(); // _ZN10S3213C2_nt4v201Ev
  virtual void  v202(); // _ZN10S3213C2_nt4v202Ev
  virtual void  v203(); // _ZN10S3213C2_nt4v203Ev
  virtual void  v204(); // _ZN10S3213C2_nt4v204Ev
  virtual void  v205(); // _ZN10S3213C2_nt4v205Ev
  virtual void  v206(); // _ZN10S3213C2_nt4v206Ev
  virtual void  v207(); // _ZN10S3213C2_nt4v207Ev
  virtual void  v208(); // _ZN10S3213C2_nt4v208Ev
  virtual void  v209(); // _ZN10S3213C2_nt4v209Ev
  virtual void  v210(); // _ZN10S3213C2_nt4v210Ev
  S3213C2_nt(); // tgen
};
//SIG(-1 S3213C2_nt) C1{ BC2{ vd v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC4 FC7{ m Fi} Fi Fc[4] Fp[2] FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC3 FC3 FC3 FC8{ BC9{ BC6}} FC8 Fi Fp[2] FC10{ m Fi[3]} FC10 FC10 FC10 Fp FC3 FC8 FC10 FC10 Fi FC10 FC10 Fp Fi Fc FC10 FC10 Fp Fi Fp FC8 FC11{ BC12{ BC6}} FC11}


 S3213C2_nt ::~S3213C2_nt(){ note_dtor("S3213C2_nt", this);}
void  S3213C2_nt ::v68(){vfunc_called(this, "_ZN10S3213C2_nt3v68Ev");}
void  S3213C2_nt ::v69(){vfunc_called(this, "_ZN10S3213C2_nt3v69Ev");}
void  S3213C2_nt ::v70(){vfunc_called(this, "_ZN10S3213C2_nt3v70Ev");}
void  S3213C2_nt ::v71(){vfunc_called(this, "_ZN10S3213C2_nt3v71Ev");}
void  S3213C2_nt ::v72(){vfunc_called(this, "_ZN10S3213C2_nt3v72Ev");}
void  S3213C2_nt ::v73(){vfunc_called(this, "_ZN10S3213C2_nt3v73Ev");}
void  S3213C2_nt ::v74(){vfunc_called(this, "_ZN10S3213C2_nt3v74Ev");}
void  S3213C2_nt ::v75(){vfunc_called(this, "_ZN10S3213C2_nt3v75Ev");}
void  S3213C2_nt ::v76(){vfunc_called(this, "_ZN10S3213C2_nt3v76Ev");}
void  S3213C2_nt ::v77(){vfunc_called(this, "_ZN10S3213C2_nt3v77Ev");}
void  S3213C2_nt ::v78(){vfunc_called(this, "_ZN10S3213C2_nt3v78Ev");}
void  S3213C2_nt ::v79(){vfunc_called(this, "_ZN10S3213C2_nt3v79Ev");}
void  S3213C2_nt ::v80(){vfunc_called(this, "_ZN10S3213C2_nt3v80Ev");}
void  S3213C2_nt ::v81(){vfunc_called(this, "_ZN10S3213C2_nt3v81Ev");}
void  S3213C2_nt ::v82(){vfunc_called(this, "_ZN10S3213C2_nt3v82Ev");}
void  S3213C2_nt ::v83(){vfunc_called(this, "_ZN10S3213C2_nt3v83Ev");}
void  S3213C2_nt ::v84(){vfunc_called(this, "_ZN10S3213C2_nt3v84Ev");}
void  S3213C2_nt ::v85(){vfunc_called(this, "_ZN10S3213C2_nt3v85Ev");}
void  S3213C2_nt ::v86(){vfunc_called(this, "_ZN10S3213C2_nt3v86Ev");}
void  S3213C2_nt ::v87(){vfunc_called(this, "_ZN10S3213C2_nt3v87Ev");}
void  S3213C2_nt ::v88(){vfunc_called(this, "_ZN10S3213C2_nt3v88Ev");}
void  S3213C2_nt ::v89(){vfunc_called(this, "_ZN10S3213C2_nt3v89Ev");}
void  S3213C2_nt ::v90(){vfunc_called(this, "_ZN10S3213C2_nt3v90Ev");}
void  S3213C2_nt ::v91(){vfunc_called(this, "_ZN10S3213C2_nt3v91Ev");}
void  S3213C2_nt ::v92(){vfunc_called(this, "_ZN10S3213C2_nt3v92Ev");}
void  S3213C2_nt ::v93(){vfunc_called(this, "_ZN10S3213C2_nt3v93Ev");}
void  S3213C2_nt ::v94(){vfunc_called(this, "_ZN10S3213C2_nt3v94Ev");}
void  S3213C2_nt ::v95(){vfunc_called(this, "_ZN10S3213C2_nt3v95Ev");}
void  S3213C2_nt ::v96(){vfunc_called(this, "_ZN10S3213C2_nt3v96Ev");}
void  S3213C2_nt ::v97(){vfunc_called(this, "_ZN10S3213C2_nt3v97Ev");}
void  S3213C2_nt ::v98(){vfunc_called(this, "_ZN10S3213C2_nt3v98Ev");}
void  S3213C2_nt ::v99(){vfunc_called(this, "_ZN10S3213C2_nt3v99Ev");}
void  S3213C2_nt ::v100(){vfunc_called(this, "_ZN10S3213C2_nt4v100Ev");}
void  S3213C2_nt ::v101(){vfunc_called(this, "_ZN10S3213C2_nt4v101Ev");}
void  S3213C2_nt ::v102(){vfunc_called(this, "_ZN10S3213C2_nt4v102Ev");}
void  S3213C2_nt ::v103(){vfunc_called(this, "_ZN10S3213C2_nt4v103Ev");}
void  S3213C2_nt ::v104(){vfunc_called(this, "_ZN10S3213C2_nt4v104Ev");}
void  S3213C2_nt ::v105(){vfunc_called(this, "_ZN10S3213C2_nt4v105Ev");}
void  S3213C2_nt ::v106(){vfunc_called(this, "_ZN10S3213C2_nt4v106Ev");}
void  S3213C2_nt ::v107(){vfunc_called(this, "_ZN10S3213C2_nt4v107Ev");}
void  S3213C2_nt ::v108(){vfunc_called(this, "_ZN10S3213C2_nt4v108Ev");}
void  S3213C2_nt ::v109(){vfunc_called(this, "_ZN10S3213C2_nt4v109Ev");}
void  S3213C2_nt ::v110(){vfunc_called(this, "_ZN10S3213C2_nt4v110Ev");}
void  S3213C2_nt ::v111(){vfunc_called(this, "_ZN10S3213C2_nt4v111Ev");}
void  S3213C2_nt ::v112(){vfunc_called(this, "_ZN10S3213C2_nt4v112Ev");}
void  S3213C2_nt ::v113(){vfunc_called(this, "_ZN10S3213C2_nt4v113Ev");}
void  S3213C2_nt ::v114(){vfunc_called(this, "_ZN10S3213C2_nt4v114Ev");}
void  S3213C2_nt ::v115(){vfunc_called(this, "_ZN10S3213C2_nt4v115Ev");}
void  S3213C2_nt ::v116(){vfunc_called(this, "_ZN10S3213C2_nt4v116Ev");}
void  S3213C2_nt ::v117(){vfunc_called(this, "_ZN10S3213C2_nt4v117Ev");}
void  S3213C2_nt ::v118(){vfunc_called(this, "_ZN10S3213C2_nt4v118Ev");}
void  S3213C2_nt ::v119(){vfunc_called(this, "_ZN10S3213C2_nt4v119Ev");}
void  S3213C2_nt ::v120(){vfunc_called(this, "_ZN10S3213C2_nt4v120Ev");}
void  S3213C2_nt ::v121(){vfunc_called(this, "_ZN10S3213C2_nt4v121Ev");}
void  S3213C2_nt ::v122(){vfunc_called(this, "_ZN10S3213C2_nt4v122Ev");}
void  S3213C2_nt ::v123(){vfunc_called(this, "_ZN10S3213C2_nt4v123Ev");}
void  S3213C2_nt ::v124(){vfunc_called(this, "_ZN10S3213C2_nt4v124Ev");}
void  S3213C2_nt ::v125(){vfunc_called(this, "_ZN10S3213C2_nt4v125Ev");}
void  S3213C2_nt ::v126(){vfunc_called(this, "_ZN10S3213C2_nt4v126Ev");}
void  S3213C2_nt ::v127(){vfunc_called(this, "_ZN10S3213C2_nt4v127Ev");}
void  S3213C2_nt ::v128(){vfunc_called(this, "_ZN10S3213C2_nt4v128Ev");}
void  S3213C2_nt ::v129(){vfunc_called(this, "_ZN10S3213C2_nt4v129Ev");}
void  S3213C2_nt ::v130(){vfunc_called(this, "_ZN10S3213C2_nt4v130Ev");}
void  S3213C2_nt ::v131(){vfunc_called(this, "_ZN10S3213C2_nt4v131Ev");}
void  S3213C2_nt ::v132(){vfunc_called(this, "_ZN10S3213C2_nt4v132Ev");}
void  S3213C2_nt ::v133(){vfunc_called(this, "_ZN10S3213C2_nt4v133Ev");}
void  S3213C2_nt ::v134(){vfunc_called(this, "_ZN10S3213C2_nt4v134Ev");}
void  S3213C2_nt ::v135(){vfunc_called(this, "_ZN10S3213C2_nt4v135Ev");}
void  S3213C2_nt ::v136(){vfunc_called(this, "_ZN10S3213C2_nt4v136Ev");}
void  S3213C2_nt ::v137(){vfunc_called(this, "_ZN10S3213C2_nt4v137Ev");}
void  S3213C2_nt ::v138(){vfunc_called(this, "_ZN10S3213C2_nt4v138Ev");}
void  S3213C2_nt ::v139(){vfunc_called(this, "_ZN10S3213C2_nt4v139Ev");}
void  S3213C2_nt ::v140(){vfunc_called(this, "_ZN10S3213C2_nt4v140Ev");}
void  S3213C2_nt ::v141(){vfunc_called(this, "_ZN10S3213C2_nt4v141Ev");}
void  S3213C2_nt ::v142(){vfunc_called(this, "_ZN10S3213C2_nt4v142Ev");}
void  S3213C2_nt ::v143(){vfunc_called(this, "_ZN10S3213C2_nt4v143Ev");}
void  S3213C2_nt ::v144(){vfunc_called(this, "_ZN10S3213C2_nt4v144Ev");}
void  S3213C2_nt ::v145(){vfunc_called(this, "_ZN10S3213C2_nt4v145Ev");}
void  S3213C2_nt ::v146(){vfunc_called(this, "_ZN10S3213C2_nt4v146Ev");}
void  S3213C2_nt ::v147(){vfunc_called(this, "_ZN10S3213C2_nt4v147Ev");}
void  S3213C2_nt ::v148(){vfunc_called(this, "_ZN10S3213C2_nt4v148Ev");}
void  S3213C2_nt ::v149(){vfunc_called(this, "_ZN10S3213C2_nt4v149Ev");}
void  S3213C2_nt ::v150(){vfunc_called(this, "_ZN10S3213C2_nt4v150Ev");}
void  S3213C2_nt ::v151(){vfunc_called(this, "_ZN10S3213C2_nt4v151Ev");}
void  S3213C2_nt ::v152(){vfunc_called(this, "_ZN10S3213C2_nt4v152Ev");}
void  S3213C2_nt ::v153(){vfunc_called(this, "_ZN10S3213C2_nt4v153Ev");}
void  S3213C2_nt ::v154(){vfunc_called(this, "_ZN10S3213C2_nt4v154Ev");}
void  S3213C2_nt ::v155(){vfunc_called(this, "_ZN10S3213C2_nt4v155Ev");}
void  S3213C2_nt ::v156(){vfunc_called(this, "_ZN10S3213C2_nt4v156Ev");}
void  S3213C2_nt ::v157(){vfunc_called(this, "_ZN10S3213C2_nt4v157Ev");}
void  S3213C2_nt ::v158(){vfunc_called(this, "_ZN10S3213C2_nt4v158Ev");}
void  S3213C2_nt ::v159(){vfunc_called(this, "_ZN10S3213C2_nt4v159Ev");}
void  S3213C2_nt ::v160(){vfunc_called(this, "_ZN10S3213C2_nt4v160Ev");}
void  S3213C2_nt ::v161(){vfunc_called(this, "_ZN10S3213C2_nt4v161Ev");}
void  S3213C2_nt ::v162(){vfunc_called(this, "_ZN10S3213C2_nt4v162Ev");}
void  S3213C2_nt ::v163(){vfunc_called(this, "_ZN10S3213C2_nt4v163Ev");}
void  S3213C2_nt ::v164(){vfunc_called(this, "_ZN10S3213C2_nt4v164Ev");}
void  S3213C2_nt ::v165(){vfunc_called(this, "_ZN10S3213C2_nt4v165Ev");}
void  S3213C2_nt ::v166(){vfunc_called(this, "_ZN10S3213C2_nt4v166Ev");}
void  S3213C2_nt ::v167(){vfunc_called(this, "_ZN10S3213C2_nt4v167Ev");}
void  S3213C2_nt ::v168(){vfunc_called(this, "_ZN10S3213C2_nt4v168Ev");}
void  S3213C2_nt ::v169(){vfunc_called(this, "_ZN10S3213C2_nt4v169Ev");}
void  S3213C2_nt ::v170(){vfunc_called(this, "_ZN10S3213C2_nt4v170Ev");}
void  S3213C2_nt ::v171(){vfunc_called(this, "_ZN10S3213C2_nt4v171Ev");}
void  S3213C2_nt ::v172(){vfunc_called(this, "_ZN10S3213C2_nt4v172Ev");}
void  S3213C2_nt ::v173(){vfunc_called(this, "_ZN10S3213C2_nt4v173Ev");}
void  S3213C2_nt ::v174(){vfunc_called(this, "_ZN10S3213C2_nt4v174Ev");}
void  S3213C2_nt ::v175(){vfunc_called(this, "_ZN10S3213C2_nt4v175Ev");}
void  S3213C2_nt ::v176(){vfunc_called(this, "_ZN10S3213C2_nt4v176Ev");}
void  S3213C2_nt ::v177(){vfunc_called(this, "_ZN10S3213C2_nt4v177Ev");}
void  S3213C2_nt ::v178(){vfunc_called(this, "_ZN10S3213C2_nt4v178Ev");}
void  S3213C2_nt ::v179(){vfunc_called(this, "_ZN10S3213C2_nt4v179Ev");}
void  S3213C2_nt ::v180(){vfunc_called(this, "_ZN10S3213C2_nt4v180Ev");}
void  S3213C2_nt ::v181(){vfunc_called(this, "_ZN10S3213C2_nt4v181Ev");}
void  S3213C2_nt ::v182(){vfunc_called(this, "_ZN10S3213C2_nt4v182Ev");}
void  S3213C2_nt ::v183(){vfunc_called(this, "_ZN10S3213C2_nt4v183Ev");}
void  S3213C2_nt ::v184(){vfunc_called(this, "_ZN10S3213C2_nt4v184Ev");}
void  S3213C2_nt ::v185(){vfunc_called(this, "_ZN10S3213C2_nt4v185Ev");}
void  S3213C2_nt ::v186(){vfunc_called(this, "_ZN10S3213C2_nt4v186Ev");}
void  S3213C2_nt ::v187(){vfunc_called(this, "_ZN10S3213C2_nt4v187Ev");}
void  S3213C2_nt ::v188(){vfunc_called(this, "_ZN10S3213C2_nt4v188Ev");}
void  S3213C2_nt ::v189(){vfunc_called(this, "_ZN10S3213C2_nt4v189Ev");}
void  S3213C2_nt ::v190(){vfunc_called(this, "_ZN10S3213C2_nt4v190Ev");}
void  S3213C2_nt ::v191(){vfunc_called(this, "_ZN10S3213C2_nt4v191Ev");}
void  S3213C2_nt ::v192(){vfunc_called(this, "_ZN10S3213C2_nt4v192Ev");}
void  S3213C2_nt ::v193(){vfunc_called(this, "_ZN10S3213C2_nt4v193Ev");}
void  S3213C2_nt ::v194(){vfunc_called(this, "_ZN10S3213C2_nt4v194Ev");}
void  S3213C2_nt ::v195(){vfunc_called(this, "_ZN10S3213C2_nt4v195Ev");}
void  S3213C2_nt ::v196(){vfunc_called(this, "_ZN10S3213C2_nt4v196Ev");}
void  S3213C2_nt ::v197(){vfunc_called(this, "_ZN10S3213C2_nt4v197Ev");}
void  S3213C2_nt ::v198(){vfunc_called(this, "_ZN10S3213C2_nt4v198Ev");}
void  S3213C2_nt ::v199(){vfunc_called(this, "_ZN10S3213C2_nt4v199Ev");}
void  S3213C2_nt ::v200(){vfunc_called(this, "_ZN10S3213C2_nt4v200Ev");}
void  S3213C2_nt ::v201(){vfunc_called(this, "_ZN10S3213C2_nt4v201Ev");}
void  S3213C2_nt ::v202(){vfunc_called(this, "_ZN10S3213C2_nt4v202Ev");}
void  S3213C2_nt ::v203(){vfunc_called(this, "_ZN10S3213C2_nt4v203Ev");}
void  S3213C2_nt ::v204(){vfunc_called(this, "_ZN10S3213C2_nt4v204Ev");}
void  S3213C2_nt ::v205(){vfunc_called(this, "_ZN10S3213C2_nt4v205Ev");}
void  S3213C2_nt ::v206(){vfunc_called(this, "_ZN10S3213C2_nt4v206Ev");}
void  S3213C2_nt ::v207(){vfunc_called(this, "_ZN10S3213C2_nt4v207Ev");}
void  S3213C2_nt ::v208(){vfunc_called(this, "_ZN10S3213C2_nt4v208Ev");}
void  S3213C2_nt ::v209(){vfunc_called(this, "_ZN10S3213C2_nt4v209Ev");}
void  S3213C2_nt ::v210(){vfunc_called(this, "_ZN10S3213C2_nt4v210Ev");}
S3213C2_nt ::S3213C2_nt(){ note_ctor("S3213C2_nt", this);} // tgen

//skip512 S3213C2_nt

#else // __cplusplus

extern void _ZN10S3213C2_ntC1Ev();
extern void _ZN10S3213C2_ntD1Ev();
Name_Map name_map_S3213C2_nt[] = {
  NSPAIR(_ZN10S3213C2_ntC1Ev),
  NSPAIR(_ZN10S3213C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3213C3_nt;
extern VTBL_ENTRY _ZTI10S3213C3_nt[];
extern  VTBL_ENTRY _ZTV10S3213C3_nt[];
static Base_Class bases_S3213C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3213C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S3213C2_nt[];
extern void _ZN10S3213C2_ntD1Ev();
extern void _ZN10S3213C2_ntD0Ev();
extern void _ZN10S3213C3_nt2v4Ev();
extern void _ZN10S3213C3_nt2v5Ev();
extern void _ZN10S3213C3_nt2v6Ev();
extern void _ZN10S3213C3_nt2v7Ev();
extern void _ZN10S3213C3_nt2v8Ev();
extern void _ZN10S3213C3_nt2v9Ev();
extern void _ZN10S3213C3_nt3v10Ev();
extern void _ZN10S3213C3_nt3v11Ev();
extern void _ZN10S3213C3_nt3v12Ev();
extern void _ZN10S3213C3_nt3v13Ev();
extern void _ZN10S3213C3_nt3v14Ev();
extern void _ZN10S3213C3_nt3v15Ev();
extern void _ZN10S3213C3_nt3v16Ev();
extern void _ZN10S3213C3_nt3v17Ev();
extern void _ZN10S3213C3_nt3v18Ev();
extern void _ZN10S3213C3_nt3v19Ev();
extern void _ZN10S3213C3_nt3v20Ev();
extern void _ZN10S3213C3_nt3v21Ev();
extern void _ZN10S3213C3_nt3v22Ev();
extern void _ZN10S3213C3_nt3v23Ev();
extern void _ZN10S3213C3_nt3v24Ev();
extern void _ZN10S3213C3_nt3v25Ev();
extern void _ZN10S3213C3_nt3v26Ev();
extern void _ZN10S3213C3_nt3v27Ev();
extern void _ZN10S3213C3_nt3v28Ev();
extern void _ZN10S3213C3_nt3v29Ev();
extern void _ZN10S3213C3_nt3v30Ev();
extern void _ZN10S3213C3_nt3v31Ev();
extern void _ZN10S3213C3_nt3v32Ev();
extern void _ZN10S3213C3_nt3v33Ev();
extern void _ZN10S3213C3_nt3v34Ev();
extern void _ZN10S3213C3_nt3v35Ev();
extern void _ZN10S3213C3_nt3v36Ev();
extern void _ZN10S3213C3_nt3v37Ev();
extern void _ZN10S3213C3_nt3v38Ev();
extern void _ZN10S3213C3_nt3v39Ev();
extern void _ZN10S3213C3_nt3v40Ev();
extern void _ZN10S3213C3_nt3v41Ev();
extern void _ZN10S3213C3_nt3v42Ev();
extern void _ZN10S3213C3_nt3v43Ev();
extern void _ZN10S3213C3_nt3v44Ev();
extern void _ZN10S3213C3_nt3v45Ev();
extern void _ZN10S3213C3_nt3v46Ev();
extern void _ZN10S3213C3_nt3v47Ev();
extern void _ZN10S3213C3_nt3v48Ev();
extern void _ZN10S3213C3_nt3v49Ev();
extern void _ZN10S3213C3_nt3v50Ev();
extern void _ZN10S3213C3_nt3v51Ev();
extern void _ZN10S3213C3_nt3v52Ev();
extern void _ZN10S3213C3_nt3v53Ev();
extern void _ZN10S3213C3_nt3v54Ev();
extern void _ZN10S3213C3_nt3v55Ev();
extern void _ZN10S3213C3_nt3v56Ev();
extern void _ZN10S3213C3_nt3v57Ev();
extern void _ZN10S3213C3_nt3v58Ev();
extern void _ZN10S3213C3_nt3v59Ev();
extern void _ZN10S3213C3_nt3v60Ev();
extern void _ZN10S3213C3_nt3v61Ev();
extern void _ZN10S3213C3_nt3v62Ev();
extern void _ZN10S3213C3_nt3v63Ev();
extern void _ZN10S3213C3_nt3v64Ev();
extern void _ZN10S3213C3_nt3v65Ev();
extern void _ZN10S3213C3_nt3v66Ev();
extern void _ZN10S3213C3_nt3v67Ev();
extern void _ZN10S3213C2_nt3v68Ev();
extern void _ZN10S3213C2_nt3v69Ev();
extern void _ZN10S3213C2_nt3v70Ev();
extern void _ZN10S3213C2_nt3v71Ev();
extern void _ZN10S3213C2_nt3v72Ev();
extern void _ZN10S3213C2_nt3v73Ev();
extern void _ZN10S3213C2_nt3v74Ev();
extern void _ZN10S3213C2_nt3v75Ev();
extern void _ZN10S3213C2_nt3v76Ev();
extern void _ZN10S3213C2_nt3v77Ev();
extern void _ZN10S3213C2_nt3v78Ev();
extern void _ZN10S3213C2_nt3v79Ev();
extern void _ZN10S3213C2_nt3v80Ev();
extern void _ZN10S3213C2_nt3v81Ev();
extern void _ZN10S3213C2_nt3v82Ev();
extern void _ZN10S3213C2_nt3v83Ev();
extern void _ZN10S3213C2_nt3v84Ev();
extern void _ZN10S3213C2_nt3v85Ev();
extern void _ZN10S3213C2_nt3v86Ev();
extern void _ZN10S3213C2_nt3v87Ev();
extern void _ZN10S3213C2_nt3v88Ev();
extern void _ZN10S3213C2_nt3v89Ev();
extern void _ZN10S3213C2_nt3v90Ev();
extern void _ZN10S3213C2_nt3v91Ev();
extern void _ZN10S3213C2_nt3v92Ev();
extern void _ZN10S3213C2_nt3v93Ev();
extern void _ZN10S3213C2_nt3v94Ev();
extern void _ZN10S3213C2_nt3v95Ev();
extern void _ZN10S3213C2_nt3v96Ev();
extern void _ZN10S3213C2_nt3v97Ev();
extern void _ZN10S3213C2_nt3v98Ev();
extern void _ZN10S3213C2_nt3v99Ev();
extern void _ZN10S3213C2_nt4v100Ev();
extern void _ZN10S3213C2_nt4v101Ev();
extern void _ZN10S3213C2_nt4v102Ev();
extern void _ZN10S3213C2_nt4v103Ev();
extern void _ZN10S3213C2_nt4v104Ev();
extern void _ZN10S3213C2_nt4v105Ev();
extern void _ZN10S3213C2_nt4v106Ev();
extern void _ZN10S3213C2_nt4v107Ev();
extern void _ZN10S3213C2_nt4v108Ev();
extern void _ZN10S3213C2_nt4v109Ev();
extern void _ZN10S3213C2_nt4v110Ev();
extern void _ZN10S3213C2_nt4v111Ev();
extern void _ZN10S3213C2_nt4v112Ev();
extern void _ZN10S3213C2_nt4v113Ev();
extern void _ZN10S3213C2_nt4v114Ev();
extern void _ZN10S3213C2_nt4v115Ev();
extern void _ZN10S3213C2_nt4v116Ev();
extern void _ZN10S3213C2_nt4v117Ev();
extern void _ZN10S3213C2_nt4v118Ev();
extern void _ZN10S3213C2_nt4v119Ev();
extern void _ZN10S3213C2_nt4v120Ev();
extern void _ZN10S3213C2_nt4v121Ev();
extern void _ZN10S3213C2_nt4v122Ev();
extern void _ZN10S3213C2_nt4v123Ev();
extern void _ZN10S3213C2_nt4v124Ev();
extern void _ZN10S3213C2_nt4v125Ev();
extern void _ZN10S3213C2_nt4v126Ev();
extern void _ZN10S3213C2_nt4v127Ev();
extern void _ZN10S3213C2_nt4v128Ev();
extern void _ZN10S3213C2_nt4v129Ev();
extern void _ZN10S3213C2_nt4v130Ev();
extern void _ZN10S3213C2_nt4v131Ev();
extern void _ZN10S3213C2_nt4v132Ev();
extern void _ZN10S3213C2_nt4v133Ev();
extern void _ZN10S3213C2_nt4v134Ev();
extern void _ZN10S3213C2_nt4v135Ev();
extern void _ZN10S3213C2_nt4v136Ev();
extern void _ZN10S3213C2_nt4v137Ev();
extern void _ZN10S3213C2_nt4v138Ev();
extern void _ZN10S3213C2_nt4v139Ev();
extern void _ZN10S3213C2_nt4v140Ev();
extern void _ZN10S3213C2_nt4v141Ev();
extern void _ZN10S3213C2_nt4v142Ev();
extern void _ZN10S3213C2_nt4v143Ev();
extern void _ZN10S3213C2_nt4v144Ev();
extern void _ZN10S3213C2_nt4v145Ev();
extern void _ZN10S3213C2_nt4v146Ev();
extern void _ZN10S3213C2_nt4v147Ev();
extern void _ZN10S3213C2_nt4v148Ev();
extern void _ZN10S3213C2_nt4v149Ev();
extern void _ZN10S3213C2_nt4v150Ev();
extern void _ZN10S3213C2_nt4v151Ev();
extern void _ZN10S3213C2_nt4v152Ev();
extern void _ZN10S3213C2_nt4v153Ev();
extern void _ZN10S3213C2_nt4v154Ev();
extern void _ZN10S3213C2_nt4v155Ev();
extern void _ZN10S3213C2_nt4v156Ev();
extern void _ZN10S3213C2_nt4v157Ev();
extern void _ZN10S3213C2_nt4v158Ev();
extern void _ZN10S3213C2_nt4v159Ev();
extern void _ZN10S3213C2_nt4v160Ev();
extern void _ZN10S3213C2_nt4v161Ev();
extern void _ZN10S3213C2_nt4v162Ev();
extern void _ZN10S3213C2_nt4v163Ev();
extern void _ZN10S3213C2_nt4v164Ev();
extern void _ZN10S3213C2_nt4v165Ev();
extern void _ZN10S3213C2_nt4v166Ev();
extern void _ZN10S3213C2_nt4v167Ev();
extern void _ZN10S3213C2_nt4v168Ev();
extern void _ZN10S3213C2_nt4v169Ev();
extern void _ZN10S3213C2_nt4v170Ev();
extern void _ZN10S3213C2_nt4v171Ev();
extern void _ZN10S3213C2_nt4v172Ev();
extern void _ZN10S3213C2_nt4v173Ev();
extern void _ZN10S3213C2_nt4v174Ev();
extern void _ZN10S3213C2_nt4v175Ev();
extern void _ZN10S3213C2_nt4v176Ev();
extern void _ZN10S3213C2_nt4v177Ev();
extern void _ZN10S3213C2_nt4v178Ev();
extern void _ZN10S3213C2_nt4v179Ev();
extern void _ZN10S3213C2_nt4v180Ev();
extern void _ZN10S3213C2_nt4v181Ev();
extern void _ZN10S3213C2_nt4v182Ev();
extern void _ZN10S3213C2_nt4v183Ev();
extern void _ZN10S3213C2_nt4v184Ev();
extern void _ZN10S3213C2_nt4v185Ev();
extern void _ZN10S3213C2_nt4v186Ev();
extern void _ZN10S3213C2_nt4v187Ev();
extern void _ZN10S3213C2_nt4v188Ev();
extern void _ZN10S3213C2_nt4v189Ev();
extern void _ZN10S3213C2_nt4v190Ev();
extern void _ZN10S3213C2_nt4v191Ev();
extern void _ZN10S3213C2_nt4v192Ev();
extern void _ZN10S3213C2_nt4v193Ev();
extern void _ZN10S3213C2_nt4v194Ev();
extern void _ZN10S3213C2_nt4v195Ev();
extern void _ZN10S3213C2_nt4v196Ev();
extern void _ZN10S3213C2_nt4v197Ev();
extern void _ZN10S3213C2_nt4v198Ev();
extern void _ZN10S3213C2_nt4v199Ev();
extern void _ZN10S3213C2_nt4v200Ev();
extern void _ZN10S3213C2_nt4v201Ev();
extern void _ZN10S3213C2_nt4v202Ev();
extern void _ZN10S3213C2_nt4v203Ev();
extern void _ZN10S3213C2_nt4v204Ev();
extern void _ZN10S3213C2_nt4v205Ev();
extern void _ZN10S3213C2_nt4v206Ev();
extern void _ZN10S3213C2_nt4v207Ev();
extern void _ZN10S3213C2_nt4v208Ev();
extern void _ZN10S3213C2_nt4v209Ev();
extern void _ZN10S3213C2_nt4v210Ev();
static  VTBL_ENTRY vtc_S3213C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S3213C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S3213C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v210Ev,
};
extern VTBL_ENTRY _ZTI10S3213C2_nt[];
VTBL_ENTRY *P__ZTI10S3213C2_nt = _ZTI10S3213C2_nt; 
extern  VTBL_ENTRY _ZTV10S3213C2_nt[];
Class_Descriptor cd_S3213C2_nt = {  "S3213C2_nt", // class name
  bases_S3213C2_nt, 1,
  &(vtc_S3213C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI10S3213C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S3213C2_nt),211, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3213C1  : S3213C2_nt {
  char s3213c1f0;
  void *s3213c1f1;
  virtual  ~S3213C1(); // _ZN7S3213C1D1Ev
  virtual void  v1(); // _ZN7S3213C12v1Ev
  virtual void  v2(); // _ZN7S3213C12v2Ev
  virtual void  v3(); // _ZN7S3213C12v3Ev
  S3213C1(); // tgen
};
//SIG(1 S3213C1) C1{ BC2{ BC3{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC5 FC8{ m Fi} Fi Fc[4] Fp[2] FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC4 FC4 FC4 FC9{ BC10{ BC7}} FC9 Fi Fp[2] FC11{ m Fi[3]} FC11 FC11 FC11 Fp FC4 FC9 FC11 FC11 Fi FC11 FC11 Fp Fi Fc FC11 FC11 Fp Fi Fp FC9 FC12{ BC13{ BC7}} FC12} vd v1 v2 v3 Fc Fp}


 S3213C1 ::~S3213C1(){ note_dtor("S3213C1", this);}
void  S3213C1 ::v1(){vfunc_called(this, "_ZN7S3213C12v1Ev");}
void  S3213C1 ::v2(){vfunc_called(this, "_ZN7S3213C12v2Ev");}
void  S3213C1 ::v3(){vfunc_called(this, "_ZN7S3213C12v3Ev");}
S3213C1 ::S3213C1(){ note_ctor("S3213C1", this);} // tgen

static void Test_S3213C1()
{
  extern Class_Descriptor cd_S3213C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(74,112)];
    init_test(&cd_S3213C1, buf);
    S3213C1 *dp, &lv = *(dp=new (buf) S3213C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(584,444), "sizeof(S3213C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3213C1)");
    check_base_class_offset(lv, (S3213C3_nt*)(S3213C2_nt*), 0, "S3213C1");
    check_base_class_offset(lv, (S3213C2_nt*), 0, "S3213C1");
    check_field_offset(lv, s3213c1f0, ABISELECT(568,436), "S3213C1.s3213c1f0");
    check_field_offset(lv, s3213c1f1, ABISELECT(576,440), "S3213C1.s3213c1f1");
    test_class_info(&lv, &cd_S3213C1);
    dp->~S3213C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3213C1(Test_S3213C1, "S3213C1", ABISELECT(584,444));

#else // __cplusplus

extern void _ZN7S3213C1C1Ev();
extern void _ZN7S3213C1D1Ev();
Name_Map name_map_S3213C1[] = {
  NSPAIR(_ZN7S3213C1C1Ev),
  NSPAIR(_ZN7S3213C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3213C3_nt;
extern VTBL_ENTRY _ZTI10S3213C3_nt[];
extern  VTBL_ENTRY _ZTV10S3213C3_nt[];
extern Class_Descriptor cd_S3213C2_nt;
extern VTBL_ENTRY _ZTI10S3213C2_nt[];
extern  VTBL_ENTRY _ZTV10S3213C2_nt[];
static Base_Class bases_S3213C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3213C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3213C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3213C1[];
extern void _ZN7S3213C1D1Ev();
extern void _ZN7S3213C1D0Ev();
extern void _ZN10S3213C3_nt2v4Ev();
extern void _ZN10S3213C3_nt2v5Ev();
extern void _ZN10S3213C3_nt2v6Ev();
extern void _ZN10S3213C3_nt2v7Ev();
extern void _ZN10S3213C3_nt2v8Ev();
extern void _ZN10S3213C3_nt2v9Ev();
extern void _ZN10S3213C3_nt3v10Ev();
extern void _ZN10S3213C3_nt3v11Ev();
extern void _ZN10S3213C3_nt3v12Ev();
extern void _ZN10S3213C3_nt3v13Ev();
extern void _ZN10S3213C3_nt3v14Ev();
extern void _ZN10S3213C3_nt3v15Ev();
extern void _ZN10S3213C3_nt3v16Ev();
extern void _ZN10S3213C3_nt3v17Ev();
extern void _ZN10S3213C3_nt3v18Ev();
extern void _ZN10S3213C3_nt3v19Ev();
extern void _ZN10S3213C3_nt3v20Ev();
extern void _ZN10S3213C3_nt3v21Ev();
extern void _ZN10S3213C3_nt3v22Ev();
extern void _ZN10S3213C3_nt3v23Ev();
extern void _ZN10S3213C3_nt3v24Ev();
extern void _ZN10S3213C3_nt3v25Ev();
extern void _ZN10S3213C3_nt3v26Ev();
extern void _ZN10S3213C3_nt3v27Ev();
extern void _ZN10S3213C3_nt3v28Ev();
extern void _ZN10S3213C3_nt3v29Ev();
extern void _ZN10S3213C3_nt3v30Ev();
extern void _ZN10S3213C3_nt3v31Ev();
extern void _ZN10S3213C3_nt3v32Ev();
extern void _ZN10S3213C3_nt3v33Ev();
extern void _ZN10S3213C3_nt3v34Ev();
extern void _ZN10S3213C3_nt3v35Ev();
extern void _ZN10S3213C3_nt3v36Ev();
extern void _ZN10S3213C3_nt3v37Ev();
extern void _ZN10S3213C3_nt3v38Ev();
extern void _ZN10S3213C3_nt3v39Ev();
extern void _ZN10S3213C3_nt3v40Ev();
extern void _ZN10S3213C3_nt3v41Ev();
extern void _ZN10S3213C3_nt3v42Ev();
extern void _ZN10S3213C3_nt3v43Ev();
extern void _ZN10S3213C3_nt3v44Ev();
extern void _ZN10S3213C3_nt3v45Ev();
extern void _ZN10S3213C3_nt3v46Ev();
extern void _ZN10S3213C3_nt3v47Ev();
extern void _ZN10S3213C3_nt3v48Ev();
extern void _ZN10S3213C3_nt3v49Ev();
extern void _ZN10S3213C3_nt3v50Ev();
extern void _ZN10S3213C3_nt3v51Ev();
extern void _ZN10S3213C3_nt3v52Ev();
extern void _ZN10S3213C3_nt3v53Ev();
extern void _ZN10S3213C3_nt3v54Ev();
extern void _ZN10S3213C3_nt3v55Ev();
extern void _ZN10S3213C3_nt3v56Ev();
extern void _ZN10S3213C3_nt3v57Ev();
extern void _ZN10S3213C3_nt3v58Ev();
extern void _ZN10S3213C3_nt3v59Ev();
extern void _ZN10S3213C3_nt3v60Ev();
extern void _ZN10S3213C3_nt3v61Ev();
extern void _ZN10S3213C3_nt3v62Ev();
extern void _ZN10S3213C3_nt3v63Ev();
extern void _ZN10S3213C3_nt3v64Ev();
extern void _ZN10S3213C3_nt3v65Ev();
extern void _ZN10S3213C3_nt3v66Ev();
extern void _ZN10S3213C3_nt3v67Ev();
extern void _ZN10S3213C2_nt3v68Ev();
extern void _ZN10S3213C2_nt3v69Ev();
extern void _ZN10S3213C2_nt3v70Ev();
extern void _ZN10S3213C2_nt3v71Ev();
extern void _ZN10S3213C2_nt3v72Ev();
extern void _ZN10S3213C2_nt3v73Ev();
extern void _ZN10S3213C2_nt3v74Ev();
extern void _ZN10S3213C2_nt3v75Ev();
extern void _ZN10S3213C2_nt3v76Ev();
extern void _ZN10S3213C2_nt3v77Ev();
extern void _ZN10S3213C2_nt3v78Ev();
extern void _ZN10S3213C2_nt3v79Ev();
extern void _ZN10S3213C2_nt3v80Ev();
extern void _ZN10S3213C2_nt3v81Ev();
extern void _ZN10S3213C2_nt3v82Ev();
extern void _ZN10S3213C2_nt3v83Ev();
extern void _ZN10S3213C2_nt3v84Ev();
extern void _ZN10S3213C2_nt3v85Ev();
extern void _ZN10S3213C2_nt3v86Ev();
extern void _ZN10S3213C2_nt3v87Ev();
extern void _ZN10S3213C2_nt3v88Ev();
extern void _ZN10S3213C2_nt3v89Ev();
extern void _ZN10S3213C2_nt3v90Ev();
extern void _ZN10S3213C2_nt3v91Ev();
extern void _ZN10S3213C2_nt3v92Ev();
extern void _ZN10S3213C2_nt3v93Ev();
extern void _ZN10S3213C2_nt3v94Ev();
extern void _ZN10S3213C2_nt3v95Ev();
extern void _ZN10S3213C2_nt3v96Ev();
extern void _ZN10S3213C2_nt3v97Ev();
extern void _ZN10S3213C2_nt3v98Ev();
extern void _ZN10S3213C2_nt3v99Ev();
extern void _ZN10S3213C2_nt4v100Ev();
extern void _ZN10S3213C2_nt4v101Ev();
extern void _ZN10S3213C2_nt4v102Ev();
extern void _ZN10S3213C2_nt4v103Ev();
extern void _ZN10S3213C2_nt4v104Ev();
extern void _ZN10S3213C2_nt4v105Ev();
extern void _ZN10S3213C2_nt4v106Ev();
extern void _ZN10S3213C2_nt4v107Ev();
extern void _ZN10S3213C2_nt4v108Ev();
extern void _ZN10S3213C2_nt4v109Ev();
extern void _ZN10S3213C2_nt4v110Ev();
extern void _ZN10S3213C2_nt4v111Ev();
extern void _ZN10S3213C2_nt4v112Ev();
extern void _ZN10S3213C2_nt4v113Ev();
extern void _ZN10S3213C2_nt4v114Ev();
extern void _ZN10S3213C2_nt4v115Ev();
extern void _ZN10S3213C2_nt4v116Ev();
extern void _ZN10S3213C2_nt4v117Ev();
extern void _ZN10S3213C2_nt4v118Ev();
extern void _ZN10S3213C2_nt4v119Ev();
extern void _ZN10S3213C2_nt4v120Ev();
extern void _ZN10S3213C2_nt4v121Ev();
extern void _ZN10S3213C2_nt4v122Ev();
extern void _ZN10S3213C2_nt4v123Ev();
extern void _ZN10S3213C2_nt4v124Ev();
extern void _ZN10S3213C2_nt4v125Ev();
extern void _ZN10S3213C2_nt4v126Ev();
extern void _ZN10S3213C2_nt4v127Ev();
extern void _ZN10S3213C2_nt4v128Ev();
extern void _ZN10S3213C2_nt4v129Ev();
extern void _ZN10S3213C2_nt4v130Ev();
extern void _ZN10S3213C2_nt4v131Ev();
extern void _ZN10S3213C2_nt4v132Ev();
extern void _ZN10S3213C2_nt4v133Ev();
extern void _ZN10S3213C2_nt4v134Ev();
extern void _ZN10S3213C2_nt4v135Ev();
extern void _ZN10S3213C2_nt4v136Ev();
extern void _ZN10S3213C2_nt4v137Ev();
extern void _ZN10S3213C2_nt4v138Ev();
extern void _ZN10S3213C2_nt4v139Ev();
extern void _ZN10S3213C2_nt4v140Ev();
extern void _ZN10S3213C2_nt4v141Ev();
extern void _ZN10S3213C2_nt4v142Ev();
extern void _ZN10S3213C2_nt4v143Ev();
extern void _ZN10S3213C2_nt4v144Ev();
extern void _ZN10S3213C2_nt4v145Ev();
extern void _ZN10S3213C2_nt4v146Ev();
extern void _ZN10S3213C2_nt4v147Ev();
extern void _ZN10S3213C2_nt4v148Ev();
extern void _ZN10S3213C2_nt4v149Ev();
extern void _ZN10S3213C2_nt4v150Ev();
extern void _ZN10S3213C2_nt4v151Ev();
extern void _ZN10S3213C2_nt4v152Ev();
extern void _ZN10S3213C2_nt4v153Ev();
extern void _ZN10S3213C2_nt4v154Ev();
extern void _ZN10S3213C2_nt4v155Ev();
extern void _ZN10S3213C2_nt4v156Ev();
extern void _ZN10S3213C2_nt4v157Ev();
extern void _ZN10S3213C2_nt4v158Ev();
extern void _ZN10S3213C2_nt4v159Ev();
extern void _ZN10S3213C2_nt4v160Ev();
extern void _ZN10S3213C2_nt4v161Ev();
extern void _ZN10S3213C2_nt4v162Ev();
extern void _ZN10S3213C2_nt4v163Ev();
extern void _ZN10S3213C2_nt4v164Ev();
extern void _ZN10S3213C2_nt4v165Ev();
extern void _ZN10S3213C2_nt4v166Ev();
extern void _ZN10S3213C2_nt4v167Ev();
extern void _ZN10S3213C2_nt4v168Ev();
extern void _ZN10S3213C2_nt4v169Ev();
extern void _ZN10S3213C2_nt4v170Ev();
extern void _ZN10S3213C2_nt4v171Ev();
extern void _ZN10S3213C2_nt4v172Ev();
extern void _ZN10S3213C2_nt4v173Ev();
extern void _ZN10S3213C2_nt4v174Ev();
extern void _ZN10S3213C2_nt4v175Ev();
extern void _ZN10S3213C2_nt4v176Ev();
extern void _ZN10S3213C2_nt4v177Ev();
extern void _ZN10S3213C2_nt4v178Ev();
extern void _ZN10S3213C2_nt4v179Ev();
extern void _ZN10S3213C2_nt4v180Ev();
extern void _ZN10S3213C2_nt4v181Ev();
extern void _ZN10S3213C2_nt4v182Ev();
extern void _ZN10S3213C2_nt4v183Ev();
extern void _ZN10S3213C2_nt4v184Ev();
extern void _ZN10S3213C2_nt4v185Ev();
extern void _ZN10S3213C2_nt4v186Ev();
extern void _ZN10S3213C2_nt4v187Ev();
extern void _ZN10S3213C2_nt4v188Ev();
extern void _ZN10S3213C2_nt4v189Ev();
extern void _ZN10S3213C2_nt4v190Ev();
extern void _ZN10S3213C2_nt4v191Ev();
extern void _ZN10S3213C2_nt4v192Ev();
extern void _ZN10S3213C2_nt4v193Ev();
extern void _ZN10S3213C2_nt4v194Ev();
extern void _ZN10S3213C2_nt4v195Ev();
extern void _ZN10S3213C2_nt4v196Ev();
extern void _ZN10S3213C2_nt4v197Ev();
extern void _ZN10S3213C2_nt4v198Ev();
extern void _ZN10S3213C2_nt4v199Ev();
extern void _ZN10S3213C2_nt4v200Ev();
extern void _ZN10S3213C2_nt4v201Ev();
extern void _ZN10S3213C2_nt4v202Ev();
extern void _ZN10S3213C2_nt4v203Ev();
extern void _ZN10S3213C2_nt4v204Ev();
extern void _ZN10S3213C2_nt4v205Ev();
extern void _ZN10S3213C2_nt4v206Ev();
extern void _ZN10S3213C2_nt4v207Ev();
extern void _ZN10S3213C2_nt4v208Ev();
extern void _ZN10S3213C2_nt4v209Ev();
extern void _ZN10S3213C2_nt4v210Ev();
extern void _ZN7S3213C12v1Ev();
extern void _ZN7S3213C12v2Ev();
extern void _ZN7S3213C12v3Ev();
static  VTBL_ENTRY vtc_S3213C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3213C1[0]),
  (VTBL_ENTRY)&_ZN7S3213C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3213C1D0Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S3213C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S3213C2_nt4v210Ev,
  (VTBL_ENTRY)&_ZN7S3213C12v1Ev,
  (VTBL_ENTRY)&_ZN7S3213C12v2Ev,
  (VTBL_ENTRY)&_ZN7S3213C12v3Ev,
};
extern VTBL_ENTRY _ZTI7S3213C1[];
extern  VTBL_ENTRY _ZTV7S3213C1[];
Class_Descriptor cd_S3213C1 = {  "S3213C1", // class name
  bases_S3213C1, 2,
  &(vtc_S3213C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(584,444), // object size
  NSPAIRA(_ZTI7S3213C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3213C1),214, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C7_nt  {
  void  mf1587c7(); // _ZN10S1587C7_nt8mf1587c7Ev
};
//SIG(-1 S1587C7_nt) C1{ m}


void  S1587C7_nt ::mf1587c7(){}

//skip512 S1587C7_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S1587C7_nt[];
VTBL_ENTRY *P__ZTI10S1587C7_nt = _ZTI10S1587C7_nt; 
Class_Descriptor cd_S1587C7_nt = {  "S1587C7_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI10S1587C7_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C6_nt  {
  void *s1587c6f0;
  int s1587c6f1;
  ::S1587C7_nt s1587c6f2;
  void  mf1587c6(); // _ZN10S1587C6_nt8mf1587c6Ev
};
//SIG(-1 S1587C6_nt) C1{ m Fp Fi FC2{ m}}


void  S1587C6_nt ::mf1587c6(){}

//skip512 S1587C6_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C5_nt  {
  ::S1587C6_nt s1587c5f0;
  int s1587c5f1;
  void  mf1587c5(); // _ZN10S1587C5_nt8mf1587c5Ev
};
//SIG(-1 S1587C5_nt) C1{ m FC2{ m Fp Fi FC3{ m}} Fi}


void  S1587C5_nt ::mf1587c5(){}

//skip512 S1587C5_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C4  {
  void *s1587c4f0;
  ::S1587C5_nt s1587c4f1;
  char s1587c4f2;
  int s1587c4f3;
  virtual  ~S1587C4(); // _ZN7S1587C4D1Ev
  virtual void  v9(); // _ZN7S1587C42v9Ev
  virtual void  v10(); // _ZN7S1587C43v10Ev
  virtual void  v11(); // _ZN7S1587C43v11Ev
  virtual void  v12(); // _ZN7S1587C43v12Ev
  virtual void  v13(); // _ZN7S1587C43v13Ev
  virtual void  v14(); // _ZN7S1587C43v14Ev
  virtual void  v15(); // _ZN7S1587C43v15Ev
  virtual void  v16(); // _ZN7S1587C43v16Ev
  virtual void  v17(); // _ZN7S1587C43v17Ev
  virtual void  v18(); // _ZN7S1587C43v18Ev
  virtual void  v19(); // _ZN7S1587C43v19Ev
  virtual void  v20(); // _ZN7S1587C43v20Ev
  virtual void  v21(); // _ZN7S1587C43v21Ev
  S1587C4(); // tgen
};
//SIG(-1 S1587C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 Fp FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fc Fi}


 S1587C4 ::~S1587C4(){ note_dtor("S1587C4", this);}
void  S1587C4 ::v9(){vfunc_called(this, "_ZN7S1587C42v9Ev");}
void  S1587C4 ::v10(){vfunc_called(this, "_ZN7S1587C43v10Ev");}
void  S1587C4 ::v11(){vfunc_called(this, "_ZN7S1587C43v11Ev");}
void  S1587C4 ::v12(){vfunc_called(this, "_ZN7S1587C43v12Ev");}
void  S1587C4 ::v13(){vfunc_called(this, "_ZN7S1587C43v13Ev");}
void  S1587C4 ::v14(){vfunc_called(this, "_ZN7S1587C43v14Ev");}
void  S1587C4 ::v15(){vfunc_called(this, "_ZN7S1587C43v15Ev");}
void  S1587C4 ::v16(){vfunc_called(this, "_ZN7S1587C43v16Ev");}
void  S1587C4 ::v17(){vfunc_called(this, "_ZN7S1587C43v17Ev");}
void  S1587C4 ::v18(){vfunc_called(this, "_ZN7S1587C43v18Ev");}
void  S1587C4 ::v19(){vfunc_called(this, "_ZN7S1587C43v19Ev");}
void  S1587C4 ::v20(){vfunc_called(this, "_ZN7S1587C43v20Ev");}
void  S1587C4 ::v21(){vfunc_called(this, "_ZN7S1587C43v21Ev");}
S1587C4 ::S1587C4(){ note_ctor("S1587C4", this);} // tgen

static void Test_S1587C4()
{
  extern Class_Descriptor cd_S1587C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_S1587C4, buf);
    S1587C4 *dp, &lv = *(dp=new (buf) S1587C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(S1587C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C4)");
    check_field_offset(lv, s1587c4f0, ABISELECT(8,4), "S1587C4.s1587c4f0");
    check_field_offset(lv, s1587c4f1, ABISELECT(16,8), "S1587C4.s1587c4f1");
    check_field_offset(lv, s1587c4f2, ABISELECT(40,24), "S1587C4.s1587c4f2");
    check_field_offset(lv, s1587c4f3, ABISELECT(44,28), "S1587C4.s1587c4f3");
    test_class_info(&lv, &cd_S1587C4);
    dp->~S1587C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1587C4(Test_S1587C4, "S1587C4", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7S1587C4C1Ev();
extern void _ZN7S1587C4D1Ev();
Name_Map name_map_S1587C4[] = {
  NSPAIR(_ZN7S1587C4C1Ev),
  NSPAIR(_ZN7S1587C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1587C4[];
extern void _ZN7S1587C4D1Ev();
extern void _ZN7S1587C4D0Ev();
extern void _ZN7S1587C42v9Ev();
extern void _ZN7S1587C43v10Ev();
extern void _ZN7S1587C43v11Ev();
extern void _ZN7S1587C43v12Ev();
extern void _ZN7S1587C43v13Ev();
extern void _ZN7S1587C43v14Ev();
extern void _ZN7S1587C43v15Ev();
extern void _ZN7S1587C43v16Ev();
extern void _ZN7S1587C43v17Ev();
extern void _ZN7S1587C43v18Ev();
extern void _ZN7S1587C43v19Ev();
extern void _ZN7S1587C43v20Ev();
extern void _ZN7S1587C43v21Ev();
static  VTBL_ENTRY vtc_S1587C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1587C4[0]),
  (VTBL_ENTRY)&_ZN7S1587C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1587C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1587C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v21Ev,
};
extern VTBL_ENTRY _ZTI7S1587C4[];
extern  VTBL_ENTRY _ZTV7S1587C4[];
Class_Descriptor cd_S1587C4 = {  "S1587C4", // class name
  0,0,//no base classes
  &(vtc_S1587C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7S1587C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1587C4),17, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C3  : S1587C4 {
  void *s1587c3f0[3];
  int s1587c3f1;
  virtual  ~S1587C3(); // _ZN7S1587C3D1Ev
  virtual void  v22(); // _ZN7S1587C33v22Ev
  virtual void  v23(); // _ZN7S1587C33v23Ev
  virtual void  v24(); // _ZN7S1587C33v24Ev
  virtual void  v25(); // _ZN7S1587C33v25Ev
  virtual void  v26(); // _ZN7S1587C33v26Ev
  virtual void  v27(); // _ZN7S1587C33v27Ev
  virtual void  v28(); // _ZN7S1587C33v28Ev
  virtual void  v29(); // _ZN7S1587C33v29Ev
  virtual void  v30(); // _ZN7S1587C33v30Ev
  virtual void  v31(); // _ZN7S1587C33v31Ev
  virtual void  v32(); // _ZN7S1587C33v32Ev
  S1587C3(); // tgen
};
//SIG(-1 S1587C3) C1{ BC2{ vd v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fc Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 Fp[3] Fi}


 S1587C3 ::~S1587C3(){ note_dtor("S1587C3", this);}
void  S1587C3 ::v22(){vfunc_called(this, "_ZN7S1587C33v22Ev");}
void  S1587C3 ::v23(){vfunc_called(this, "_ZN7S1587C33v23Ev");}
void  S1587C3 ::v24(){vfunc_called(this, "_ZN7S1587C33v24Ev");}
void  S1587C3 ::v25(){vfunc_called(this, "_ZN7S1587C33v25Ev");}
void  S1587C3 ::v26(){vfunc_called(this, "_ZN7S1587C33v26Ev");}
void  S1587C3 ::v27(){vfunc_called(this, "_ZN7S1587C33v27Ev");}
void  S1587C3 ::v28(){vfunc_called(this, "_ZN7S1587C33v28Ev");}
void  S1587C3 ::v29(){vfunc_called(this, "_ZN7S1587C33v29Ev");}
void  S1587C3 ::v30(){vfunc_called(this, "_ZN7S1587C33v30Ev");}
void  S1587C3 ::v31(){vfunc_called(this, "_ZN7S1587C33v31Ev");}
void  S1587C3 ::v32(){vfunc_called(this, "_ZN7S1587C33v32Ev");}
S1587C3 ::S1587C3(){ note_ctor("S1587C3", this);} // tgen

static void Test_S1587C3()
{
  extern Class_Descriptor cd_S1587C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,13)];
    init_test(&cd_S1587C3, buf);
    S1587C3 *dp, &lv = *(dp=new (buf) S1587C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,48), "sizeof(S1587C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C3)");
    check_base_class_offset(lv, (S1587C4*), 0, "S1587C3");
    check_field_offset(lv, s1587c3f0, ABISELECT(48,32), "S1587C3.s1587c3f0");
    check_field_offset(lv, s1587c3f1, ABISELECT(72,44), "S1587C3.s1587c3f1");
    test_class_info(&lv, &cd_S1587C3);
    dp->~S1587C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1587C3(Test_S1587C3, "S1587C3", ABISELECT(80,48));

#else // __cplusplus

extern void _ZN7S1587C3C1Ev();
extern void _ZN7S1587C3D1Ev();
Name_Map name_map_S1587C3[] = {
  NSPAIR(_ZN7S1587C3C1Ev),
  NSPAIR(_ZN7S1587C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1587C4;
extern VTBL_ENTRY _ZTI7S1587C4[];
extern  VTBL_ENTRY _ZTV7S1587C4[];
static Base_Class bases_S1587C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1587C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1587C3[];
extern void _ZN7S1587C3D1Ev();
extern void _ZN7S1587C3D0Ev();
extern void _ZN7S1587C42v9Ev();
extern void _ZN7S1587C43v10Ev();
extern void _ZN7S1587C43v11Ev();
extern void _ZN7S1587C43v12Ev();
extern void _ZN7S1587C43v13Ev();
extern void _ZN7S1587C43v14Ev();
extern void _ZN7S1587C43v15Ev();
extern void _ZN7S1587C43v16Ev();
extern void _ZN7S1587C43v17Ev();
extern void _ZN7S1587C43v18Ev();
extern void _ZN7S1587C43v19Ev();
extern void _ZN7S1587C43v20Ev();
extern void _ZN7S1587C43v21Ev();
extern void _ZN7S1587C33v22Ev();
extern void _ZN7S1587C33v23Ev();
extern void _ZN7S1587C33v24Ev();
extern void _ZN7S1587C33v25Ev();
extern void _ZN7S1587C33v26Ev();
extern void _ZN7S1587C33v27Ev();
extern void _ZN7S1587C33v28Ev();
extern void _ZN7S1587C33v29Ev();
extern void _ZN7S1587C33v30Ev();
extern void _ZN7S1587C33v31Ev();
extern void _ZN7S1587C33v32Ev();
static  VTBL_ENTRY vtc_S1587C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1587C3[0]),
  (VTBL_ENTRY)&_ZN7S1587C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1587C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1587C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v29Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v30Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v31Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v32Ev,
};
extern VTBL_ENTRY _ZTI7S1587C3[];
extern  VTBL_ENTRY _ZTV7S1587C3[];
Class_Descriptor cd_S1587C3 = {  "S1587C3", // class name
  bases_S1587C3, 1,
  &(vtc_S1587C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,48), // object size
  NSPAIRA(_ZTI7S1587C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1587C3),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C9_nt  {
  __tsi64 s1587c9f0;
  void  mf1587c9(); // _ZN10S1587C9_nt8mf1587c9Ev
};
//SIG(-1 S1587C9_nt) C1{ m FL}


void  S1587C9_nt ::mf1587c9(){}

//skip512 S1587C9_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S1587C9_nt[];
VTBL_ENTRY *P__ZTI10S1587C9_nt = _ZTI10S1587C9_nt; 
Class_Descriptor cd_S1587C9_nt = {  "S1587C9_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  8, // object size
  NSPAIRA(_ZTI10S1587C9_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C8_nt  {
  ::S1587C9_nt s1587c8f0;
  void  mf1587c8(); // _ZN10S1587C8_nt8mf1587c8Ev
};
//SIG(-1 S1587C8_nt) C1{ m FC2{ m FL}}


void  S1587C8_nt ::mf1587c8(){}

//skip512 S1587C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C2  : S1587C3 {
  void *s1587c2f0[2];
  int s1587c2f1[3];
  ::S1587C5_nt s1587c2f2;
  char s1587c2f3;
  ::S1587C8_nt s1587c2f4;
  char s1587c2f5;
  int s1587c2f6;
  char s1587c2f7;
  int s1587c2f8;
  char s1587c2f9[2];
  int s1587c2f10;
  char s1587c2f11;
  virtual  ~S1587C2(); // _ZN7S1587C2D1Ev
  virtual void  v33(); // _ZN7S1587C23v33Ev
  virtual void  v34(); // _ZN7S1587C23v34Ev
  virtual void  v35(); // _ZN7S1587C23v35Ev
  virtual void  v36(); // _ZN7S1587C23v36Ev
  virtual void  v37(); // _ZN7S1587C23v37Ev
  virtual void  v38(); // _ZN7S1587C23v38Ev
  virtual void  v39(); // _ZN7S1587C23v39Ev
  virtual void  v40(); // _ZN7S1587C23v40Ev
  virtual void  v41(); // _ZN7S1587C23v41Ev
  virtual void  v42(); // _ZN7S1587C23v42Ev
  virtual void  v43(); // _ZN7S1587C23v43Ev
  virtual void  v44(); // _ZN7S1587C23v44Ev
  virtual void  v45(); // _ZN7S1587C23v45Ev
  virtual void  v46(); // _ZN7S1587C23v46Ev
  virtual void  v47(); // _ZN7S1587C23v47Ev
  virtual void  v48(); // _ZN7S1587C23v48Ev
  virtual void  v49(); // _ZN7S1587C23v49Ev
  S1587C2(); // tgen
};
//SIG(-1 S1587C2) C1{ BC2{ BC3{ vd v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 Fp FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fc Fi} vd v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 Fp[3] Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 Fp[2] Fi[3] FC4 Fc FC7{ m FC8{ m FL}} Fc Fi Fc Fi Fc[2] Fi Fc}


 S1587C2 ::~S1587C2(){ note_dtor("S1587C2", this);}
void  S1587C2 ::v33(){vfunc_called(this, "_ZN7S1587C23v33Ev");}
void  S1587C2 ::v34(){vfunc_called(this, "_ZN7S1587C23v34Ev");}
void  S1587C2 ::v35(){vfunc_called(this, "_ZN7S1587C23v35Ev");}
void  S1587C2 ::v36(){vfunc_called(this, "_ZN7S1587C23v36Ev");}
void  S1587C2 ::v37(){vfunc_called(this, "_ZN7S1587C23v37Ev");}
void  S1587C2 ::v38(){vfunc_called(this, "_ZN7S1587C23v38Ev");}
void  S1587C2 ::v39(){vfunc_called(this, "_ZN7S1587C23v39Ev");}
void  S1587C2 ::v40(){vfunc_called(this, "_ZN7S1587C23v40Ev");}
void  S1587C2 ::v41(){vfunc_called(this, "_ZN7S1587C23v41Ev");}
void  S1587C2 ::v42(){vfunc_called(this, "_ZN7S1587C23v42Ev");}
void  S1587C2 ::v43(){vfunc_called(this, "_ZN7S1587C23v43Ev");}
void  S1587C2 ::v44(){vfunc_called(this, "_ZN7S1587C23v44Ev");}
void  S1587C2 ::v45(){vfunc_called(this, "_ZN7S1587C23v45Ev");}
void  S1587C2 ::v46(){vfunc_called(this, "_ZN7S1587C23v46Ev");}
void  S1587C2 ::v47(){vfunc_called(this, "_ZN7S1587C23v47Ev");}
void  S1587C2 ::v48(){vfunc_called(this, "_ZN7S1587C23v48Ev");}
void  S1587C2 ::v49(){vfunc_called(this, "_ZN7S1587C23v49Ev");}
S1587C2 ::S1587C2(){ note_ctor("S1587C2", this);} // tgen

static void Test_S1587C2()
{
  extern Class_Descriptor cd_S1587C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,32)];
    init_test(&cd_S1587C2, buf);
    S1587C2 *dp, &lv = *(dp=new (buf) S1587C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,124), "sizeof(S1587C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C2)");
    check_base_class_offset(lv, (S1587C4*)(S1587C3*), 0, "S1587C2");
    check_base_class_offset(lv, (S1587C3*), 0, "S1587C2");
    check_field_offset(lv, s1587c2f0, ABISELECT(80,48), "S1587C2.s1587c2f0");
    check_field_offset(lv, s1587c2f1, ABISELECT(96,56), "S1587C2.s1587c2f1");
    check_field_offset(lv, s1587c2f2, ABISELECT(112,68), "S1587C2.s1587c2f2");
    check_field_offset(lv, s1587c2f3, ABISELECT(136,84), "S1587C2.s1587c2f3");
    check_field_offset(lv, s1587c2f4, ABISELECT(144,88), "S1587C2.s1587c2f4");
    check_field_offset(lv, s1587c2f5, ABISELECT(152,96), "S1587C2.s1587c2f5");
    check_field_offset(lv, s1587c2f6, ABISELECT(156,100), "S1587C2.s1587c2f6");
    check_field_offset(lv, s1587c2f7, ABISELECT(160,104), "S1587C2.s1587c2f7");
    check_field_offset(lv, s1587c2f8, ABISELECT(164,108), "S1587C2.s1587c2f8");
    check_field_offset(lv, s1587c2f9, ABISELECT(168,112), "S1587C2.s1587c2f9");
    check_field_offset(lv, s1587c2f10, ABISELECT(172,116), "S1587C2.s1587c2f10");
    check_field_offset(lv, s1587c2f11, ABISELECT(176,120), "S1587C2.s1587c2f11");
    test_class_info(&lv, &cd_S1587C2);
    dp->~S1587C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1587C2(Test_S1587C2, "S1587C2", ABISELECT(184,124));

#else // __cplusplus

extern void _ZN7S1587C2C1Ev();
extern void _ZN7S1587C2D1Ev();
Name_Map name_map_S1587C2[] = {
  NSPAIR(_ZN7S1587C2C1Ev),
  NSPAIR(_ZN7S1587C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1587C4;
extern VTBL_ENTRY _ZTI7S1587C4[];
extern  VTBL_ENTRY _ZTV7S1587C4[];
extern Class_Descriptor cd_S1587C3;
extern VTBL_ENTRY _ZTI7S1587C3[];
extern  VTBL_ENTRY _ZTV7S1587C3[];
static Base_Class bases_S1587C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1587C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1587C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1587C2[];
extern void _ZN7S1587C2D1Ev();
extern void _ZN7S1587C2D0Ev();
extern void _ZN7S1587C42v9Ev();
extern void _ZN7S1587C43v10Ev();
extern void _ZN7S1587C43v11Ev();
extern void _ZN7S1587C43v12Ev();
extern void _ZN7S1587C43v13Ev();
extern void _ZN7S1587C43v14Ev();
extern void _ZN7S1587C43v15Ev();
extern void _ZN7S1587C43v16Ev();
extern void _ZN7S1587C43v17Ev();
extern void _ZN7S1587C43v18Ev();
extern void _ZN7S1587C43v19Ev();
extern void _ZN7S1587C43v20Ev();
extern void _ZN7S1587C43v21Ev();
extern void _ZN7S1587C33v22Ev();
extern void _ZN7S1587C33v23Ev();
extern void _ZN7S1587C33v24Ev();
extern void _ZN7S1587C33v25Ev();
extern void _ZN7S1587C33v26Ev();
extern void _ZN7S1587C33v27Ev();
extern void _ZN7S1587C33v28Ev();
extern void _ZN7S1587C33v29Ev();
extern void _ZN7S1587C33v30Ev();
extern void _ZN7S1587C33v31Ev();
extern void _ZN7S1587C33v32Ev();
extern void _ZN7S1587C23v33Ev();
extern void _ZN7S1587C23v34Ev();
extern void _ZN7S1587C23v35Ev();
extern void _ZN7S1587C23v36Ev();
extern void _ZN7S1587C23v37Ev();
extern void _ZN7S1587C23v38Ev();
extern void _ZN7S1587C23v39Ev();
extern void _ZN7S1587C23v40Ev();
extern void _ZN7S1587C23v41Ev();
extern void _ZN7S1587C23v42Ev();
extern void _ZN7S1587C23v43Ev();
extern void _ZN7S1587C23v44Ev();
extern void _ZN7S1587C23v45Ev();
extern void _ZN7S1587C23v46Ev();
extern void _ZN7S1587C23v47Ev();
extern void _ZN7S1587C23v48Ev();
extern void _ZN7S1587C23v49Ev();
static  VTBL_ENTRY vtc_S1587C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1587C2[0]),
  (VTBL_ENTRY)&_ZN7S1587C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1587C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1587C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v29Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v30Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v31Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v32Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v33Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v34Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v35Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v36Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v37Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v38Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v39Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v40Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v41Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v42Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v43Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v44Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v45Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v46Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v47Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v48Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v49Ev,
};
extern VTBL_ENTRY _ZTI7S1587C2[];
extern  VTBL_ENTRY _ZTV7S1587C2[];
Class_Descriptor cd_S1587C2 = {  "S1587C2", // class name
  bases_S1587C2, 2,
  &(vtc_S1587C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,124), // object size
  NSPAIRA(_ZTI7S1587C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1587C2),45, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C15_nt  {
  void *s1587c15f0;
  int s1587c15f1;
  void  mf1587c15(); // _ZN11S1587C15_nt9mf1587c15Ev
};
//SIG(-1 S1587C15_nt) C1{ m Fp Fi}


void  S1587C15_nt ::mf1587c15(){}

//skip512 S1587C15_nt

#else // __cplusplus

Class_Descriptor cd_S1587C15_nt = {  "S1587C15_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,8), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C14  : S1587C15_nt {
  void *s1587c14f0;
};
//SIG(-1 S1587C14) C1{ BC2{ m Fp Fi} Fp}



static void Test_S1587C14()
{
  extern Class_Descriptor cd_S1587C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S1587C14, buf);
    S1587C14 &lv = *(new (buf) S1587C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S1587C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C14)");
    check_base_class_offset(lv, (S1587C15_nt*), 0, "S1587C14");
    check_field_offset(lv, s1587c14f0, ABISELECT(16,8), "S1587C14.s1587c14f0");
    test_class_info(&lv, &cd_S1587C14);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1587C14(Test_S1587C14, "S1587C14", ABISELECT(24,12));

#else // __cplusplus

extern Class_Descriptor cd_S1587C15_nt;
static Base_Class bases_S1587C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1587C15_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1587C14 = {  "S1587C14", // class name
  bases_S1587C14, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(24,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C13  {
  void *s1587c13f0;
  ::S1587C14 s1587c13f1;
  char s1587c13f2;
  void *s1587c13f3;
  void  mf1587c13(); // _ZN8S1587C139mf1587c13Ev
};
//SIG(-1 S1587C13) C1{ m Fp FC2{ BC3{ m Fp Fi} Fp} Fc Fp}


void  S1587C13 ::mf1587c13(){}

static void Test_S1587C13()
{
  {
    init_simple_test("S1587C13");
    S1587C13 lv;
    check2(sizeof(lv), ABISELECT(48,24), "sizeof(S1587C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C13)");
    check_field_offset(lv, s1587c13f0, 0, "S1587C13.s1587c13f0");
    check_field_offset(lv, s1587c13f1, ABISELECT(8,4), "S1587C13.s1587c13f1");
    check_field_offset(lv, s1587c13f2, ABISELECT(32,16), "S1587C13.s1587c13f2");
    check_field_offset(lv, s1587c13f3, ABISELECT(40,20), "S1587C13.s1587c13f3");
  }
}
static Arrange_To_Call_Me vS1587C13(Test_S1587C13, "S1587C13", ABISELECT(48,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C12  {
  void *s1587c12f0;
  int s1587c12f1;
  ::S1587C13 s1587c12f2;
  void  mf1587c12(); // _ZN8S1587C129mf1587c12Ev
};
//SIG(-1 S1587C12) C1{ m Fp Fi FC2{ m Fp FC3{ BC4{ m Fp Fi} Fp} Fc Fp}}


void  S1587C12 ::mf1587c12(){}

static void Test_S1587C12()
{
  {
    init_simple_test("S1587C12");
    S1587C12 lv;
    check2(sizeof(lv), ABISELECT(64,32), "sizeof(S1587C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C12)");
    check_field_offset(lv, s1587c12f0, 0, "S1587C12.s1587c12f0");
    check_field_offset(lv, s1587c12f1, ABISELECT(8,4), "S1587C12.s1587c12f1");
    check_field_offset(lv, s1587c12f2, ABISELECT(16,8), "S1587C12.s1587c12f2");
  }
}
static Arrange_To_Call_Me vS1587C12(Test_S1587C12, "S1587C12", ABISELECT(64,32));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C16_nt  {
  char s1587c16f0;
  void  mf1587c16(); // _ZN11S1587C16_nt9mf1587c16Ev
};
//SIG(-1 S1587C16_nt) C1{ m Fc}


void  S1587C16_nt ::mf1587c16(){}

//skip512 S1587C16_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C17  {
  void *s1587c17f0[2];
  int s1587c17f1[2];
  void  mf1587c17(); // _ZN8S1587C179mf1587c17Ev
};
//SIG(-1 S1587C17) C1{ m Fp[2] Fi[2]}


void  S1587C17 ::mf1587c17(){}

static void Test_S1587C17()
{
  {
    init_simple_test("S1587C17");
    S1587C17 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S1587C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C17)");
    check_field_offset(lv, s1587c17f0, 0, "S1587C17.s1587c17f0");
    check_field_offset(lv, s1587c17f1, ABISELECT(16,8), "S1587C17.s1587c17f1");
  }
}
static Arrange_To_Call_Me vS1587C17(Test_S1587C17, "S1587C17", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C20_nt  {
  void *s1587c20f0[2];
  void  mf1587c20(); // _ZN11S1587C20_nt9mf1587c20Ev
};
//SIG(-1 S1587C20_nt) C1{ m Fp[2]}


void  S1587C20_nt ::mf1587c20(){}

//skip512 S1587C20_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C22  {
  void *s1587c22f0[2];
  void  mf1587c22(); // _ZN8S1587C229mf1587c22Ev
};
//SIG(-1 S1587C22) C1{ m Fp[2]}


void  S1587C22 ::mf1587c22(){}

static void Test_S1587C22()
{
  {
    init_simple_test("S1587C22");
    S1587C22 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S1587C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C22)");
    check_field_offset(lv, s1587c22f0, 0, "S1587C22.s1587c22f0");
  }
}
static Arrange_To_Call_Me vS1587C22(Test_S1587C22, "S1587C22", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C24  {
  int s1587c24f0;
};
//SIG(-1 S1587C24) C1{ Fi}



static void Test_S1587C24()
{
  {
    init_simple_test("S1587C24");
    S1587C24 lv;
    check2(sizeof(lv), 4, "sizeof(S1587C24)");
    check2(__alignof__(lv), 4, "__alignof__(S1587C24)");
    check_field_offset(lv, s1587c24f0, 0, "S1587C24.s1587c24f0");
  }
}
static Arrange_To_Call_Me vS1587C24(Test_S1587C24, "S1587C24", 4);

#else // __cplusplus

Class_Descriptor cd_S1587C24 = {  "S1587C24", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C25_nt  {
  int s1587c25f0[3];
};
//SIG(-1 S1587C25_nt) C1{ Fi[3]}



//skip512 S1587C25_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C23  {
  int s1587c23f0[3];
  ::S1587C24 s1587c23f1;
  ::S1587C25_nt s1587c23f2;
};
//SIG(-1 S1587C23) C1{ Fi[3] FC2{ Fi} FC3{ Fi[3]}}



static void Test_S1587C23()
{
  {
    init_simple_test("S1587C23");
    S1587C23 lv;
    check2(sizeof(lv), 28, "sizeof(S1587C23)");
    check2(__alignof__(lv), 4, "__alignof__(S1587C23)");
    check_field_offset(lv, s1587c23f0, 0, "S1587C23.s1587c23f0");
    check_field_offset(lv, s1587c23f1, 12, "S1587C23.s1587c23f1");
    check_field_offset(lv, s1587c23f2, 16, "S1587C23.s1587c23f2");
  }
}
static Arrange_To_Call_Me vS1587C23(Test_S1587C23, "S1587C23", 28);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C18  {
  ::S1587C17 s1587c18f0;
  void *s1587c18f1[2];
  char s1587c18f2;
  void *s1587c18f3;
  ::S1587C20_nt s1587c18f4;
  ::S1587C20_nt s1587c18f5;
  ::S1587C22 s1587c18f6;
  void *s1587c18f7;
  int s1587c18f8;
  ::S1587C23 s1587c18f9;
  int s1587c18f10[3];
  char s1587c18f11;
  ::S1587C25_nt s1587c18f12;
  int s1587c18f13;
  void  mf1587c18(); // _ZN8S1587C189mf1587c18Ev
};
//SIG(-1 S1587C18) C1{ m FC2{ m Fp[2] Fi[2]} Fp[2] Fc Fp FC3{ m Fp[2]} FC3 FC4{ m Fp[2]} Fp Fi FC5{ Fi[3] FC6{ Fi} FC7{ Fi[3]}} Fi[3] Fc FC7 Fi}


void  S1587C18 ::mf1587c18(){}

static void Test_S1587C18()
{
  {
    init_simple_test("S1587C18");
    S1587C18 lv;
    check2(sizeof(lv), ABISELECT(176,124), "sizeof(S1587C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C18)");
    check_field_offset(lv, s1587c18f0, 0, "S1587C18.s1587c18f0");
    check_field_offset(lv, s1587c18f1, ABISELECT(24,16), "S1587C18.s1587c18f1");
    check_field_offset(lv, s1587c18f2, ABISELECT(40,24), "S1587C18.s1587c18f2");
    check_field_offset(lv, s1587c18f3, ABISELECT(48,28), "S1587C18.s1587c18f3");
    check_field_offset(lv, s1587c18f4, ABISELECT(56,32), "S1587C18.s1587c18f4");
    check_field_offset(lv, s1587c18f5, ABISELECT(72,40), "S1587C18.s1587c18f5");
    check_field_offset(lv, s1587c18f6, ABISELECT(88,48), "S1587C18.s1587c18f6");
    check_field_offset(lv, s1587c18f7, ABISELECT(104,56), "S1587C18.s1587c18f7");
    check_field_offset(lv, s1587c18f8, ABISELECT(112,60), "S1587C18.s1587c18f8");
    check_field_offset(lv, s1587c18f9, ABISELECT(116,64), "S1587C18.s1587c18f9");
    check_field_offset(lv, s1587c18f10, ABISELECT(144,92), "S1587C18.s1587c18f10");
    check_field_offset(lv, s1587c18f11, ABISELECT(156,104), "S1587C18.s1587c18f11");
    check_field_offset(lv, s1587c18f12, ABISELECT(160,108), "S1587C18.s1587c18f12");
    check_field_offset(lv, s1587c18f13, ABISELECT(172,120), "S1587C18.s1587c18f13");
  }
}
static Arrange_To_Call_Me vS1587C18(Test_S1587C18, "S1587C18", ABISELECT(176,124));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C26  {
  int s1587c26f0[2];
  char s1587c26f1[193];
  __tsi64 s1587c26f2;
  char s1587c26f3;
};
//SIG(1 S1587C26) C1{ Fi[2] Fc[193] FL Fc}



static void Test_S1587C26()
{
  {
    init_simple_test("S1587C26");
    S1587C26 lv;
    check2(sizeof(lv), ABISELECT(224,216), "sizeof(S1587C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C26)");
    check_field_offset(lv, s1587c26f0, 0, "S1587C26.s1587c26f0");
    check_field_offset(lv, s1587c26f1, 8, "S1587C26.s1587c26f1");
    check_field_offset(lv, s1587c26f2, ABISELECT(208,204), "S1587C26.s1587c26f2");
    check_field_offset(lv, s1587c26f3, ABISELECT(216,212), "S1587C26.s1587c26f3");
  }
}
static Arrange_To_Call_Me vS1587C26(Test_S1587C26, "S1587C26", ABISELECT(224,216));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C30  {
  char s1587c30f0[20];
};
//SIG(-1 S1587C30) C1{ Fc[20]}



static void Test_S1587C30()
{
  {
    init_simple_test("S1587C30");
    S1587C30 lv;
    check2(sizeof(lv), 20, "sizeof(S1587C30)");
    check2(__alignof__(lv), 1, "__alignof__(S1587C30)");
    check_field_offset(lv, s1587c30f0, 0, "S1587C30.s1587c30f0");
  }
}
static Arrange_To_Call_Me vS1587C30(Test_S1587C30, "S1587C30", 20);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C29  {
  ::S1587C30 s1587c29f0;
  char s1587c29f1[16];
};
//SIG(-1 S1587C29) C1{ FC2{ Fc[20]} Fc[16]}



static void Test_S1587C29()
{
  {
    init_simple_test("S1587C29");
    S1587C29 lv;
    check2(sizeof(lv), 36, "sizeof(S1587C29)");
    check2(__alignof__(lv), 1, "__alignof__(S1587C29)");
    check_field_offset(lv, s1587c29f0, 0, "S1587C29.s1587c29f0");
    check_field_offset(lv, s1587c29f1, 20, "S1587C29.s1587c29f1");
  }
}
static Arrange_To_Call_Me vS1587C29(Test_S1587C29, "S1587C29", 36);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C27  {
  ::S1587C22 s1587c27f0;
  ::S1587C6_nt s1587c27f1;
  ::S1587C29 s1587c27f2;
  void  mf1587c27(); // _ZN8S1587C279mf1587c27Ev
};
//SIG(-1 S1587C27) C1{ m FC2{ m Fp[2]} FC3{ m Fp Fi FC4{ m}} FC5{ FC6{ Fc[20]} Fc[16]}}


void  S1587C27 ::mf1587c27(){}

static void Test_S1587C27()
{
  {
    init_simple_test("S1587C27");
    S1587C27 lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S1587C27)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C27)");
    check_field_offset(lv, s1587c27f0, 0, "S1587C27.s1587c27f0");
    check_field_offset(lv, s1587c27f1, ABISELECT(16,8), "S1587C27.s1587c27f1");
    check_field_offset(lv, s1587c27f2, ABISELECT(32,20), "S1587C27.s1587c27f2");
  }
}
static Arrange_To_Call_Me vS1587C27(Test_S1587C27, "S1587C27", ABISELECT(72,56));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C32  {
  __tsi64 s1587c32f0;
  void *s1587c32f1;
  int s1587c32f2;
  virtual  ~S1587C32(); // _ZN8S1587C32D1Ev
  virtual void  v52(); // _ZN8S1587C323v52Ev
  virtual void  v53(); // _ZN8S1587C323v53Ev
  virtual void  v54(); // _ZN8S1587C323v54Ev
  S1587C32(); // tgen
};
//SIG(-1 S1587C32) C1{ vd v1 v2 v3 FL Fp Fi}


 S1587C32 ::~S1587C32(){ note_dtor("S1587C32", this);}
void  S1587C32 ::v52(){vfunc_called(this, "_ZN8S1587C323v52Ev");}
void  S1587C32 ::v53(){vfunc_called(this, "_ZN8S1587C323v53Ev");}
void  S1587C32 ::v54(){vfunc_called(this, "_ZN8S1587C323v54Ev");}
S1587C32 ::S1587C32(){ note_ctor("S1587C32", this);} // tgen

static void Test_S1587C32()
{
  extern Class_Descriptor cd_S1587C32;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_S1587C32, buf);
    S1587C32 *dp, &lv = *(dp=new (buf) S1587C32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S1587C32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C32)");
    check_field_offset(lv, s1587c32f0, ABISELECT(8,4), "S1587C32.s1587c32f0");
    check_field_offset(lv, s1587c32f1, ABISELECT(16,12), "S1587C32.s1587c32f1");
    check_field_offset(lv, s1587c32f2, ABISELECT(24,16), "S1587C32.s1587c32f2");
    test_class_info(&lv, &cd_S1587C32);
    dp->~S1587C32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1587C32(Test_S1587C32, "S1587C32", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN8S1587C32C1Ev();
extern void _ZN8S1587C32D1Ev();
Name_Map name_map_S1587C32[] = {
  NSPAIR(_ZN8S1587C32C1Ev),
  NSPAIR(_ZN8S1587C32D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S1587C32[];
extern void _ZN8S1587C32D1Ev();
extern void _ZN8S1587C32D0Ev();
extern void _ZN8S1587C323v52Ev();
extern void _ZN8S1587C323v53Ev();
extern void _ZN8S1587C323v54Ev();
static  VTBL_ENTRY vtc_S1587C32[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S1587C32[0]),
  (VTBL_ENTRY)&_ZN8S1587C32D1Ev,
  (VTBL_ENTRY)&_ZN8S1587C32D0Ev,
  (VTBL_ENTRY)&_ZN8S1587C323v52Ev,
  (VTBL_ENTRY)&_ZN8S1587C323v53Ev,
  (VTBL_ENTRY)&_ZN8S1587C323v54Ev,
};
extern VTBL_ENTRY _ZTI8S1587C32[];
extern  VTBL_ENTRY _ZTV8S1587C32[];
Class_Descriptor cd_S1587C32 = {  "S1587C32", // class name
  0,0,//no base classes
  &(vtc_S1587C32[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI8S1587C32),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S1587C32),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C31  : S1587C32 {
  int s1587c31f0;
  char s1587c31f1;
  virtual  ~S1587C31(); // _ZN8S1587C31D1Ev
  virtual void  v50(); // _ZN8S1587C313v50Ev
  virtual void  v51(); // _ZN8S1587C313v51Ev
  S1587C31(); // tgen
};
//SIG(-1 S1587C31) C1{ BC2{ vd v3 v4 v5 FL Fp Fi} vd v1 v2 Fi Fc}


 S1587C31 ::~S1587C31(){ note_dtor("S1587C31", this);}
void  S1587C31 ::v50(){vfunc_called(this, "_ZN8S1587C313v50Ev");}
void  S1587C31 ::v51(){vfunc_called(this, "_ZN8S1587C313v51Ev");}
S1587C31 ::S1587C31(){ note_ctor("S1587C31", this);} // tgen

static void Test_S1587C31()
{
  extern Class_Descriptor cd_S1587C31;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S1587C31, buf);
    S1587C31 *dp, &lv = *(dp=new (buf) S1587C31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S1587C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C31)");
    check_base_class_offset(lv, (S1587C32*), 0, "S1587C31");
    check_field_offset(lv, s1587c31f0, ABISELECT(28,20), "S1587C31.s1587c31f0");
    check_field_offset(lv, s1587c31f1, ABISELECT(32,24), "S1587C31.s1587c31f1");
    test_class_info(&lv, &cd_S1587C31);
    dp->~S1587C31();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1587C31(Test_S1587C31, "S1587C31", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN8S1587C31C1Ev();
extern void _ZN8S1587C31D1Ev();
Name_Map name_map_S1587C31[] = {
  NSPAIR(_ZN8S1587C31C1Ev),
  NSPAIR(_ZN8S1587C31D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1587C32;
extern VTBL_ENTRY _ZTI8S1587C32[];
extern  VTBL_ENTRY _ZTV8S1587C32[];
static Base_Class bases_S1587C31[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1587C32,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S1587C31[];
extern void _ZN8S1587C31D1Ev();
extern void _ZN8S1587C31D0Ev();
extern void _ZN8S1587C323v52Ev();
extern void _ZN8S1587C323v53Ev();
extern void _ZN8S1587C323v54Ev();
extern void _ZN8S1587C313v50Ev();
extern void _ZN8S1587C313v51Ev();
static  VTBL_ENTRY vtc_S1587C31[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S1587C31[0]),
  (VTBL_ENTRY)&_ZN8S1587C31D1Ev,
  (VTBL_ENTRY)&_ZN8S1587C31D0Ev,
  (VTBL_ENTRY)&_ZN8S1587C323v52Ev,
  (VTBL_ENTRY)&_ZN8S1587C323v53Ev,
  (VTBL_ENTRY)&_ZN8S1587C323v54Ev,
  (VTBL_ENTRY)&_ZN8S1587C313v50Ev,
  (VTBL_ENTRY)&_ZN8S1587C313v51Ev,
};
extern VTBL_ENTRY _ZTI8S1587C31[];
extern  VTBL_ENTRY _ZTV8S1587C31[];
Class_Descriptor cd_S1587C31 = {  "S1587C31", // class name
  bases_S1587C31, 1,
  &(vtc_S1587C31[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI8S1587C31),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S1587C31),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C33  {
  int s1587c33f0[2];
  char s1587c33f1[197];
  int s1587c33f2;
  char s1587c33f3;
  __tsi64 s1587c33f4[3];
  int s1587c33f5;
  char s1587c33f6[33];
  int s1587c33f7[4];
  char s1587c33f8[65];
  int s1587c33f9;
  char s1587c33f10[65];
  int s1587c33f11[4];
};
//SIG(-1 S1587C33) C1{ Fi[2] Fc[197] Fi Fc FL[3] Fi Fc[33] Fi[4] Fc[65] Fi Fc[65] Fi[4]}



static void Test_S1587C33()
{
  {
    init_simple_test("S1587C33");
    S1587C33 lv;
    check2(sizeof(lv), ABISELECT(456,452), "sizeof(S1587C33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C33)");
    check_field_offset(lv, s1587c33f0, 0, "S1587C33.s1587c33f0");
    check_field_offset(lv, s1587c33f1, 8, "S1587C33.s1587c33f1");
    check_field_offset(lv, s1587c33f2, 208, "S1587C33.s1587c33f2");
    check_field_offset(lv, s1587c33f3, 212, "S1587C33.s1587c33f3");
    check_field_offset(lv, s1587c33f4, 216, "S1587C33.s1587c33f4");
    check_field_offset(lv, s1587c33f5, 240, "S1587C33.s1587c33f5");
    check_field_offset(lv, s1587c33f6, 244, "S1587C33.s1587c33f6");
    check_field_offset(lv, s1587c33f7, 280, "S1587C33.s1587c33f7");
    check_field_offset(lv, s1587c33f8, 296, "S1587C33.s1587c33f8");
    check_field_offset(lv, s1587c33f9, 364, "S1587C33.s1587c33f9");
    check_field_offset(lv, s1587c33f10, 368, "S1587C33.s1587c33f10");
    check_field_offset(lv, s1587c33f11, 436, "S1587C33.s1587c33f11");
  }
}
static Arrange_To_Call_Me vS1587C33(Test_S1587C33, "S1587C33", ABISELECT(456,452));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C36  : S3213C4_nt {
  char s1587c36f0[193];
};
//SIG(-1 S1587C36) C1{ BC2{ m Fi[2]} Fc[193]}



static void Test_S1587C36()
{
  extern Class_Descriptor cd_S1587C36;
  void *lvp;
  {
    int buf[52];
    init_test(&cd_S1587C36, buf);
    S1587C36 &lv = *(new (buf) S1587C36());
    lvp = (void*)&lv;
    check2(sizeof(lv), 204, "sizeof(S1587C36)");
    check2(__alignof__(lv), 4, "__alignof__(S1587C36)");
    check_base_class_offset(lv, (S3213C4_nt*), 0, "S1587C36");
    check_field_offset(lv, s1587c36f0, 8, "S1587C36.s1587c36f0");
    test_class_info(&lv, &cd_S1587C36);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1587C36(Test_S1587C36, "S1587C36", 204);

#else // __cplusplus

extern Class_Descriptor cd_S3213C4_nt;
static Base_Class bases_S1587C36[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3213C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1587C36 = {  "S1587C36", // class name
  bases_S1587C36, 1,
  0, // no vftv
  0, //no vtt
  204, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C35  {
  int s1587c35f0[3];
  char s1587c35f1[2];
  int s1587c35f2;
  ::S1587C36 s1587c35f3;
  int s1587c35f4;
};
//SIG(1 S1587C35) C1{ Fi[3] Fc[2] Fi FC2{ BC3{ m Fi[2]} Fc[193]} Fi}



static void Test_S1587C35()
{
  {
    init_simple_test("S1587C35");
    S1587C35 lv;
    check2(sizeof(lv), 228, "sizeof(S1587C35)");
    check2(__alignof__(lv), 4, "__alignof__(S1587C35)");
    check_field_offset(lv, s1587c35f0, 0, "S1587C35.s1587c35f0");
    check_field_offset(lv, s1587c35f1, 12, "S1587C35.s1587c35f1");
    check_field_offset(lv, s1587c35f2, 16, "S1587C35.s1587c35f2");
    check_field_offset(lv, s1587c35f3, 20, "S1587C35.s1587c35f3");
    check_field_offset(lv, s1587c35f4, 224, "S1587C35.s1587c35f4");
  }
}
static Arrange_To_Call_Me vS1587C35(Test_S1587C35, "S1587C35", 228);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C38  {
  void *s1587c38f0[2];
  void  mf1587c38(); // _ZN8S1587C389mf1587c38Ev
};
//SIG(-1 S1587C38) C1{ m Fp[2]}


void  S1587C38 ::mf1587c38(){}

static void Test_S1587C38()
{
  {
    init_simple_test("S1587C38");
    S1587C38 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S1587C38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C38)");
    check_field_offset(lv, s1587c38f0, 0, "S1587C38.s1587c38f0");
  }
}
static Arrange_To_Call_Me vS1587C38(Test_S1587C38, "S1587C38", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C37  {
  ::S1587C38 s1587c37f0;
  char s1587c37f1;
  void *s1587c37f2;
  char s1587c37f3;
  void  mf1587c37(); // _ZN8S1587C379mf1587c37Ev
};
//SIG(-1 S1587C37) C1{ m FC2{ m Fp[2]} Fc Fp Fc}


void  S1587C37 ::mf1587c37(){}

static void Test_S1587C37()
{
  {
    init_simple_test("S1587C37");
    S1587C37 lv;
    check2(sizeof(lv), ABISELECT(40,20), "sizeof(S1587C37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C37)");
    check_field_offset(lv, s1587c37f0, 0, "S1587C37.s1587c37f0");
    check_field_offset(lv, s1587c37f1, ABISELECT(16,8), "S1587C37.s1587c37f1");
    check_field_offset(lv, s1587c37f2, ABISELECT(24,12), "S1587C37.s1587c37f2");
    check_field_offset(lv, s1587c37f3, ABISELECT(32,16), "S1587C37.s1587c37f3");
  }
}
static Arrange_To_Call_Me vS1587C37(Test_S1587C37, "S1587C37", ABISELECT(40,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C42  {
  __tsi64 s1587c42f0;
  char s1587c42f1;
  void  mf1587c42(); // _ZN8S1587C429mf1587c42Ev
  virtual  ~S1587C42(); // _ZN8S1587C42D1Ev
  S1587C42(); // tgen
};
//SIG(-1 S1587C42) C1{ vd m FL Fc}


void  S1587C42 ::mf1587c42(){}
 S1587C42 ::~S1587C42(){ note_dtor("S1587C42", this);}
S1587C42 ::S1587C42(){ note_ctor("S1587C42", this);} // tgen

static void Test_S1587C42()
{
  extern Class_Descriptor cd_S1587C42;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_S1587C42, buf);
    S1587C42 *dp, &lv = *(dp=new (buf) S1587C42());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S1587C42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C42)");
    check_field_offset(lv, s1587c42f0, ABISELECT(8,4), "S1587C42.s1587c42f0");
    check_field_offset(lv, s1587c42f1, ABISELECT(16,12), "S1587C42.s1587c42f1");
    test_class_info(&lv, &cd_S1587C42);
    dp->~S1587C42();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1587C42(Test_S1587C42, "S1587C42", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN8S1587C42C1Ev();
extern void _ZN8S1587C42D1Ev();
Name_Map name_map_S1587C42[] = {
  NSPAIR(_ZN8S1587C42C1Ev),
  NSPAIR(_ZN8S1587C42D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S1587C42[];
extern void _ZN8S1587C42D1Ev();
extern void _ZN8S1587C42D0Ev();
static  VTBL_ENTRY vtc_S1587C42[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S1587C42[0]),
  (VTBL_ENTRY)&_ZN8S1587C42D1Ev,
  (VTBL_ENTRY)&_ZN8S1587C42D0Ev,
};
extern VTBL_ENTRY _ZTI8S1587C42[];
extern  VTBL_ENTRY _ZTV8S1587C42[];
Class_Descriptor cd_S1587C42 = {  "S1587C42", // class name
  0,0,//no base classes
  &(vtc_S1587C42[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI8S1587C42),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S1587C42),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C41  {
  ::S1587C42 s1587c41f0;
  ::S1587C42 s1587c41f1;
  void  mf1587c41(); // _ZN8S1587C419mf1587c41Ev
};
//SIG(-1 S1587C41) C1{ m FC2{ vd m FL Fc} FC2}


void  S1587C41 ::mf1587c41(){}

static void Test_S1587C41()
{
  {
    init_simple_test("S1587C41");
    S1587C41 lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(S1587C41)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C41)");
    check_field_offset(lv, s1587c41f0, 0, "S1587C41.s1587c41f0");
    check_field_offset(lv, s1587c41f1, ABISELECT(24,16), "S1587C41.s1587c41f1");
  }
}
static Arrange_To_Call_Me vS1587C41(Test_S1587C41, "S1587C41", ABISELECT(48,32));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C40  {
  ::S1587C41 s1587c40f0;
  int s1587c40f1;
};
//SIG(1 S1587C40) C1{ FC2{ m FC3{ vd m FL Fc} FC3} Fi}



static void Test_S1587C40()
{
  {
    init_simple_test("S1587C40");
    S1587C40 lv;
    check2(sizeof(lv), ABISELECT(56,36), "sizeof(S1587C40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C40)");
    check_field_offset(lv, s1587c40f0, 0, "S1587C40.s1587c40f0");
    check_field_offset(lv, s1587c40f1, ABISELECT(48,32), "S1587C40.s1587c40f1");
  }
}
static Arrange_To_Call_Me vS1587C40(Test_S1587C40, "S1587C40", ABISELECT(56,36));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C44_nt  {
};
//SIG(-1 S1587C44_nt) C1{}



//skip512 S1587C44_nt

#else // __cplusplus

Class_Descriptor cd_S1587C44_nt = {  "S1587C44_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C45  {
  void *s1587c45f0[2];
  void  mf1587c45(); // _ZN8S1587C459mf1587c45Ev
};
//SIG(-1 S1587C45) C1{ m Fp[2]}


void  S1587C45 ::mf1587c45(){}

static void Test_S1587C45()
{
  {
    init_simple_test("S1587C45");
    S1587C45 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S1587C45)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C45)");
    check_field_offset(lv, s1587c45f0, 0, "S1587C45.s1587c45f0");
  }
}
static Arrange_To_Call_Me vS1587C45(Test_S1587C45, "S1587C45", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C47  {
  void *s1587c47f0[3];
  int s1587c47f1[3];
  char s1587c47f2[3];
  int s1587c47f3[8];
  char s1587c47f4[2];
  void *s1587c47f5[6];
  int s1587c47f6[3];
  virtual  ~S1587C47(); // _ZN8S1587C47D1Ev
  virtual void  v58(); // _ZN8S1587C473v58Ev
  virtual void  v59(); // _ZN8S1587C473v59Ev
  virtual void  v60(); // _ZN8S1587C473v60Ev
  virtual void  v61(); // _ZN8S1587C473v61Ev
  virtual void  v62(); // _ZN8S1587C473v62Ev
  virtual void  v63(); // _ZN8S1587C473v63Ev
  virtual void  v64(); // _ZN8S1587C473v64Ev
  S1587C47(); // tgen
};
//SIG(-1 S1587C47) C1{ vd v1 v2 v3 v4 v5 v6 v7 Fp[3] Fi[3] Fc[3] Fi[8] Fc[2] Fp[6] Fi[3]}


 S1587C47 ::~S1587C47(){ note_dtor("S1587C47", this);}
void  S1587C47 ::v58(){vfunc_called(this, "_ZN8S1587C473v58Ev");}
void  S1587C47 ::v59(){vfunc_called(this, "_ZN8S1587C473v59Ev");}
void  S1587C47 ::v60(){vfunc_called(this, "_ZN8S1587C473v60Ev");}
void  S1587C47 ::v61(){vfunc_called(this, "_ZN8S1587C473v61Ev");}
void  S1587C47 ::v62(){vfunc_called(this, "_ZN8S1587C473v62Ev");}
void  S1587C47 ::v63(){vfunc_called(this, "_ZN8S1587C473v63Ev");}
void  S1587C47 ::v64(){vfunc_called(this, "_ZN8S1587C473v64Ev");}
S1587C47 ::S1587C47(){ note_ctor("S1587C47", this);} // tgen

static void Test_S1587C47()
{
  extern Class_Descriptor cd_S1587C47;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(20,27)];
    init_test(&cd_S1587C47, buf);
    S1587C47 *dp, &lv = *(dp=new (buf) S1587C47());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(152,104), "sizeof(S1587C47)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C47)");
    check_field_offset(lv, s1587c47f0, ABISELECT(8,4), "S1587C47.s1587c47f0");
    check_field_offset(lv, s1587c47f1, ABISELECT(32,16), "S1587C47.s1587c47f1");
    check_field_offset(lv, s1587c47f2, ABISELECT(44,28), "S1587C47.s1587c47f2");
    check_field_offset(lv, s1587c47f3, ABISELECT(48,32), "S1587C47.s1587c47f3");
    check_field_offset(lv, s1587c47f4, ABISELECT(80,64), "S1587C47.s1587c47f4");
    check_field_offset(lv, s1587c47f5, ABISELECT(88,68), "S1587C47.s1587c47f5");
    check_field_offset(lv, s1587c47f6, ABISELECT(136,92), "S1587C47.s1587c47f6");
    test_class_info(&lv, &cd_S1587C47);
    dp->~S1587C47();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1587C47(Test_S1587C47, "S1587C47", ABISELECT(152,104));

#else // __cplusplus

extern void _ZN8S1587C47C1Ev();
extern void _ZN8S1587C47D1Ev();
Name_Map name_map_S1587C47[] = {
  NSPAIR(_ZN8S1587C47C1Ev),
  NSPAIR(_ZN8S1587C47D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S1587C47[];
extern void _ZN8S1587C47D1Ev();
extern void _ZN8S1587C47D0Ev();
extern void _ZN8S1587C473v58Ev();
extern void _ZN8S1587C473v59Ev();
extern void _ZN8S1587C473v60Ev();
extern void _ZN8S1587C473v61Ev();
extern void _ZN8S1587C473v62Ev();
extern void _ZN8S1587C473v63Ev();
extern void _ZN8S1587C473v64Ev();
static  VTBL_ENTRY vtc_S1587C47[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S1587C47[0]),
  (VTBL_ENTRY)&_ZN8S1587C47D1Ev,
  (VTBL_ENTRY)&_ZN8S1587C47D0Ev,
  (VTBL_ENTRY)&_ZN8S1587C473v58Ev,
  (VTBL_ENTRY)&_ZN8S1587C473v59Ev,
  (VTBL_ENTRY)&_ZN8S1587C473v60Ev,
  (VTBL_ENTRY)&_ZN8S1587C473v61Ev,
  (VTBL_ENTRY)&_ZN8S1587C473v62Ev,
  (VTBL_ENTRY)&_ZN8S1587C473v63Ev,
  (VTBL_ENTRY)&_ZN8S1587C473v64Ev,
};
extern VTBL_ENTRY _ZTI8S1587C47[];
extern  VTBL_ENTRY _ZTV8S1587C47[];
Class_Descriptor cd_S1587C47 = {  "S1587C47", // class name
  0,0,//no base classes
  &(vtc_S1587C47[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(152,104), // object size
  NSPAIRA(_ZTI8S1587C47),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S1587C47),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C46  : S1587C47 {
  ::S1587C13 s1587c46f0;
  ::S1587C14 s1587c46f1;
  virtual  ~S1587C46(); // _ZN8S1587C46D1Ev
  virtual void  v55(); // _ZN8S1587C463v55Ev
  virtual void  v56(); // _ZN8S1587C463v56Ev
  virtual void  v57(); // _ZN8S1587C463v57Ev
  S1587C46(); // tgen
};
//SIG(-1 S1587C46) C1{ BC2{ vd v4 v5 v6 v7 v8 v9 v10 Fp[3] Fi[3] Fc[3] Fi[8] Fc[2] Fp[6] Fi[3]} vd v1 v2 v3 FC3{ m Fp FC4{ BC5{ m Fp Fi} Fp} Fc Fp} FC4}


 S1587C46 ::~S1587C46(){ note_dtor("S1587C46", this);}
void  S1587C46 ::v55(){vfunc_called(this, "_ZN8S1587C463v55Ev");}
void  S1587C46 ::v56(){vfunc_called(this, "_ZN8S1587C463v56Ev");}
void  S1587C46 ::v57(){vfunc_called(this, "_ZN8S1587C463v57Ev");}
S1587C46 ::S1587C46(){ note_ctor("S1587C46", this);} // tgen

static void Test_S1587C46()
{
  extern Class_Descriptor cd_S1587C46;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(29,36)];
    init_test(&cd_S1587C46, buf);
    S1587C46 *dp, &lv = *(dp=new (buf) S1587C46());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(224,140), "sizeof(S1587C46)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C46)");
    check_base_class_offset(lv, (S1587C47*), 0, "S1587C46");
    check_field_offset(lv, s1587c46f0, ABISELECT(152,104), "S1587C46.s1587c46f0");
    check_field_offset(lv, s1587c46f1, ABISELECT(200,128), "S1587C46.s1587c46f1");
    test_class_info(&lv, &cd_S1587C46);
    dp->~S1587C46();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1587C46(Test_S1587C46, "S1587C46", ABISELECT(224,140));

#else // __cplusplus

extern void _ZN8S1587C46C1Ev();
extern void _ZN8S1587C46D1Ev();
Name_Map name_map_S1587C46[] = {
  NSPAIR(_ZN8S1587C46C1Ev),
  NSPAIR(_ZN8S1587C46D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1587C47;
extern VTBL_ENTRY _ZTI8S1587C47[];
extern  VTBL_ENTRY _ZTV8S1587C47[];
static Base_Class bases_S1587C46[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1587C47,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S1587C46[];
extern void _ZN8S1587C46D1Ev();
extern void _ZN8S1587C46D0Ev();
extern void _ZN8S1587C473v58Ev();
extern void _ZN8S1587C473v59Ev();
extern void _ZN8S1587C473v60Ev();
extern void _ZN8S1587C473v61Ev();
extern void _ZN8S1587C473v62Ev();
extern void _ZN8S1587C473v63Ev();
extern void _ZN8S1587C473v64Ev();
extern void _ZN8S1587C463v55Ev();
extern void _ZN8S1587C463v56Ev();
extern void _ZN8S1587C463v57Ev();
static  VTBL_ENTRY vtc_S1587C46[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S1587C46[0]),
  (VTBL_ENTRY)&_ZN8S1587C46D1Ev,
  (VTBL_ENTRY)&_ZN8S1587C46D0Ev,
  (VTBL_ENTRY)&_ZN8S1587C473v58Ev,
  (VTBL_ENTRY)&_ZN8S1587C473v59Ev,
  (VTBL_ENTRY)&_ZN8S1587C473v60Ev,
  (VTBL_ENTRY)&_ZN8S1587C473v61Ev,
  (VTBL_ENTRY)&_ZN8S1587C473v62Ev,
  (VTBL_ENTRY)&_ZN8S1587C473v63Ev,
  (VTBL_ENTRY)&_ZN8S1587C473v64Ev,
  (VTBL_ENTRY)&_ZN8S1587C463v55Ev,
  (VTBL_ENTRY)&_ZN8S1587C463v56Ev,
  (VTBL_ENTRY)&_ZN8S1587C463v57Ev,
};
extern VTBL_ENTRY _ZTI8S1587C46[];
extern  VTBL_ENTRY _ZTV8S1587C46[];
Class_Descriptor cd_S1587C46 = {  "S1587C46", // class name
  bases_S1587C46, 1,
  &(vtc_S1587C46[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(224,140), // object size
  NSPAIRA(_ZTI8S1587C46),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S1587C46),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C50  {
  virtual  ~S1587C50(); // _ZN8S1587C50D1Ev
  virtual void  v79(); // _ZN8S1587C503v79Ev
  virtual void  v80(); // _ZN8S1587C503v80Ev
  virtual void  v81(); // _ZN8S1587C503v81Ev
  virtual void  v82(); // _ZN8S1587C503v82Ev
  virtual void  v83(); // _ZN8S1587C503v83Ev
  virtual void  v84(); // _ZN8S1587C503v84Ev
  virtual void  v85(); // _ZN8S1587C503v85Ev
  virtual void  v86(); // _ZN8S1587C503v86Ev
  virtual void  v87(); // _ZN8S1587C503v87Ev
  virtual void  v88(); // _ZN8S1587C503v88Ev
  virtual void  v89(); // _ZN8S1587C503v89Ev
  virtual void  v90(); // _ZN8S1587C503v90Ev
  virtual void  v91(); // _ZN8S1587C503v91Ev
  virtual void  v92(); // _ZN8S1587C503v92Ev
  virtual void  v93(); // _ZN8S1587C503v93Ev
  virtual void  v94(); // _ZN8S1587C503v94Ev
  virtual void  v95(); // _ZN8S1587C503v95Ev
  virtual void  v96(); // _ZN8S1587C503v96Ev
  virtual void  v97(); // _ZN8S1587C503v97Ev
  virtual void  v98(); // _ZN8S1587C503v98Ev
  virtual void  v99(); // _ZN8S1587C503v99Ev
  virtual void  v100(); // _ZN8S1587C504v100Ev
  virtual void  v101(); // _ZN8S1587C504v101Ev
  virtual void  v102(); // _ZN8S1587C504v102Ev
  virtual void  v103(); // _ZN8S1587C504v103Ev
  virtual void  v104(); // _ZN8S1587C504v104Ev
  S1587C50(); // tgen
};
//SIG(-1 S1587C50) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26}


 S1587C50 ::~S1587C50(){ note_dtor("S1587C50", this);}
void  S1587C50 ::v79(){vfunc_called(this, "_ZN8S1587C503v79Ev");}
void  S1587C50 ::v80(){vfunc_called(this, "_ZN8S1587C503v80Ev");}
void  S1587C50 ::v81(){vfunc_called(this, "_ZN8S1587C503v81Ev");}
void  S1587C50 ::v82(){vfunc_called(this, "_ZN8S1587C503v82Ev");}
void  S1587C50 ::v83(){vfunc_called(this, "_ZN8S1587C503v83Ev");}
void  S1587C50 ::v84(){vfunc_called(this, "_ZN8S1587C503v84Ev");}
void  S1587C50 ::v85(){vfunc_called(this, "_ZN8S1587C503v85Ev");}
void  S1587C50 ::v86(){vfunc_called(this, "_ZN8S1587C503v86Ev");}
void  S1587C50 ::v87(){vfunc_called(this, "_ZN8S1587C503v87Ev");}
void  S1587C50 ::v88(){vfunc_called(this, "_ZN8S1587C503v88Ev");}
void  S1587C50 ::v89(){vfunc_called(this, "_ZN8S1587C503v89Ev");}
void  S1587C50 ::v90(){vfunc_called(this, "_ZN8S1587C503v90Ev");}
void  S1587C50 ::v91(){vfunc_called(this, "_ZN8S1587C503v91Ev");}
void  S1587C50 ::v92(){vfunc_called(this, "_ZN8S1587C503v92Ev");}
void  S1587C50 ::v93(){vfunc_called(this, "_ZN8S1587C503v93Ev");}
void  S1587C50 ::v94(){vfunc_called(this, "_ZN8S1587C503v94Ev");}
void  S1587C50 ::v95(){vfunc_called(this, "_ZN8S1587C503v95Ev");}
void  S1587C50 ::v96(){vfunc_called(this, "_ZN8S1587C503v96Ev");}
void  S1587C50 ::v97(){vfunc_called(this, "_ZN8S1587C503v97Ev");}
void  S1587C50 ::v98(){vfunc_called(this, "_ZN8S1587C503v98Ev");}
void  S1587C50 ::v99(){vfunc_called(this, "_ZN8S1587C503v99Ev");}
void  S1587C50 ::v100(){vfunc_called(this, "_ZN8S1587C504v100Ev");}
void  S1587C50 ::v101(){vfunc_called(this, "_ZN8S1587C504v101Ev");}
void  S1587C50 ::v102(){vfunc_called(this, "_ZN8S1587C504v102Ev");}
void  S1587C50 ::v103(){vfunc_called(this, "_ZN8S1587C504v103Ev");}
void  S1587C50 ::v104(){vfunc_called(this, "_ZN8S1587C504v104Ev");}
S1587C50 ::S1587C50(){ note_ctor("S1587C50", this);} // tgen

static void Test_S1587C50()
{
  extern Class_Descriptor cd_S1587C50;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1587C50, buf);
    S1587C50 *dp, &lv = *(dp=new (buf) S1587C50());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1587C50)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C50)");
    test_class_info(&lv, &cd_S1587C50);
    dp->~S1587C50();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1587C50(Test_S1587C50, "S1587C50", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S1587C50C1Ev();
extern void _ZN8S1587C50D1Ev();
Name_Map name_map_S1587C50[] = {
  NSPAIR(_ZN8S1587C50C1Ev),
  NSPAIR(_ZN8S1587C50D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S1587C50[];
extern void _ZN8S1587C50D1Ev();
extern void _ZN8S1587C50D0Ev();
extern void _ZN8S1587C503v79Ev();
extern void _ZN8S1587C503v80Ev();
extern void _ZN8S1587C503v81Ev();
extern void _ZN8S1587C503v82Ev();
extern void _ZN8S1587C503v83Ev();
extern void _ZN8S1587C503v84Ev();
extern void _ZN8S1587C503v85Ev();
extern void _ZN8S1587C503v86Ev();
extern void _ZN8S1587C503v87Ev();
extern void _ZN8S1587C503v88Ev();
extern void _ZN8S1587C503v89Ev();
extern void _ZN8S1587C503v90Ev();
extern void _ZN8S1587C503v91Ev();
extern void _ZN8S1587C503v92Ev();
extern void _ZN8S1587C503v93Ev();
extern void _ZN8S1587C503v94Ev();
extern void _ZN8S1587C503v95Ev();
extern void _ZN8S1587C503v96Ev();
extern void _ZN8S1587C503v97Ev();
extern void _ZN8S1587C503v98Ev();
extern void _ZN8S1587C503v99Ev();
extern void _ZN8S1587C504v100Ev();
extern void _ZN8S1587C504v101Ev();
extern void _ZN8S1587C504v102Ev();
extern void _ZN8S1587C504v103Ev();
extern void _ZN8S1587C504v104Ev();
static  VTBL_ENTRY vtc_S1587C50[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S1587C50[0]),
  (VTBL_ENTRY)&_ZN8S1587C50D1Ev,
  (VTBL_ENTRY)&_ZN8S1587C50D0Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v79Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v80Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v81Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v82Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v83Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v84Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v85Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v86Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v87Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v88Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v89Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v90Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v91Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v92Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v93Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v94Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v95Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v96Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v97Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v98Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v99Ev,
  (VTBL_ENTRY)&_ZN8S1587C504v100Ev,
  (VTBL_ENTRY)&_ZN8S1587C504v101Ev,
  (VTBL_ENTRY)&_ZN8S1587C504v102Ev,
  (VTBL_ENTRY)&_ZN8S1587C504v103Ev,
  (VTBL_ENTRY)&_ZN8S1587C504v104Ev,
};
extern VTBL_ENTRY _ZTI8S1587C50[];
extern  VTBL_ENTRY _ZTV8S1587C50[];
Class_Descriptor cd_S1587C50 = {  "S1587C50", // class name
  0,0,//no base classes
  &(vtc_S1587C50[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S1587C50),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S1587C50),30, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C49  : S1587C50 {
  void *s1587c49f0;
  int s1587c49f1;
  virtual  ~S1587C49(); // _ZN8S1587C49D1Ev
  virtual void  v65(); // _ZN8S1587C493v65Ev
  virtual void  v66(); // _ZN8S1587C493v66Ev
  virtual void  v67(); // _ZN8S1587C493v67Ev
  virtual void  v68(); // _ZN8S1587C493v68Ev
  virtual void  v69(); // _ZN8S1587C493v69Ev
  virtual void  v70(); // _ZN8S1587C493v70Ev
  virtual void  v71(); // _ZN8S1587C493v71Ev
  virtual void  v72(); // _ZN8S1587C493v72Ev
  virtual void  v73(); // _ZN8S1587C493v73Ev
  virtual void  v74(); // _ZN8S1587C493v74Ev
  virtual void  v75(); // _ZN8S1587C493v75Ev
  virtual void  v76(); // _ZN8S1587C493v76Ev
  virtual void  v77(); // _ZN8S1587C493v77Ev
  virtual void  v78(); // _ZN8S1587C493v78Ev
  S1587C49(); // tgen
};
//SIG(-1 S1587C49) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp Fi}


 S1587C49 ::~S1587C49(){ note_dtor("S1587C49", this);}
void  S1587C49 ::v65(){vfunc_called(this, "_ZN8S1587C493v65Ev");}
void  S1587C49 ::v66(){vfunc_called(this, "_ZN8S1587C493v66Ev");}
void  S1587C49 ::v67(){vfunc_called(this, "_ZN8S1587C493v67Ev");}
void  S1587C49 ::v68(){vfunc_called(this, "_ZN8S1587C493v68Ev");}
void  S1587C49 ::v69(){vfunc_called(this, "_ZN8S1587C493v69Ev");}
void  S1587C49 ::v70(){vfunc_called(this, "_ZN8S1587C493v70Ev");}
void  S1587C49 ::v71(){vfunc_called(this, "_ZN8S1587C493v71Ev");}
void  S1587C49 ::v72(){vfunc_called(this, "_ZN8S1587C493v72Ev");}
void  S1587C49 ::v73(){vfunc_called(this, "_ZN8S1587C493v73Ev");}
void  S1587C49 ::v74(){vfunc_called(this, "_ZN8S1587C493v74Ev");}
void  S1587C49 ::v75(){vfunc_called(this, "_ZN8S1587C493v75Ev");}
void  S1587C49 ::v76(){vfunc_called(this, "_ZN8S1587C493v76Ev");}
void  S1587C49 ::v77(){vfunc_called(this, "_ZN8S1587C493v77Ev");}
void  S1587C49 ::v78(){vfunc_called(this, "_ZN8S1587C493v78Ev");}
S1587C49 ::S1587C49(){ note_ctor("S1587C49", this);} // tgen

static void Test_S1587C49()
{
  extern Class_Descriptor cd_S1587C49;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S1587C49, buf);
    S1587C49 *dp, &lv = *(dp=new (buf) S1587C49());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S1587C49)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C49)");
    check_base_class_offset(lv, (S1587C50*), 0, "S1587C49");
    check_field_offset(lv, s1587c49f0, ABISELECT(8,4), "S1587C49.s1587c49f0");
    check_field_offset(lv, s1587c49f1, ABISELECT(16,8), "S1587C49.s1587c49f1");
    test_class_info(&lv, &cd_S1587C49);
    dp->~S1587C49();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1587C49(Test_S1587C49, "S1587C49", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN8S1587C49C1Ev();
extern void _ZN8S1587C49D1Ev();
Name_Map name_map_S1587C49[] = {
  NSPAIR(_ZN8S1587C49C1Ev),
  NSPAIR(_ZN8S1587C49D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1587C50;
extern VTBL_ENTRY _ZTI8S1587C50[];
extern  VTBL_ENTRY _ZTV8S1587C50[];
static Base_Class bases_S1587C49[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1587C50,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S1587C49[];
extern void _ZN8S1587C49D1Ev();
extern void _ZN8S1587C49D0Ev();
extern void _ZN8S1587C503v79Ev();
extern void _ZN8S1587C503v80Ev();
extern void _ZN8S1587C503v81Ev();
extern void _ZN8S1587C503v82Ev();
extern void _ZN8S1587C503v83Ev();
extern void _ZN8S1587C503v84Ev();
extern void _ZN8S1587C503v85Ev();
extern void _ZN8S1587C503v86Ev();
extern void _ZN8S1587C503v87Ev();
extern void _ZN8S1587C503v88Ev();
extern void _ZN8S1587C503v89Ev();
extern void _ZN8S1587C503v90Ev();
extern void _ZN8S1587C503v91Ev();
extern void _ZN8S1587C503v92Ev();
extern void _ZN8S1587C503v93Ev();
extern void _ZN8S1587C503v94Ev();
extern void _ZN8S1587C503v95Ev();
extern void _ZN8S1587C503v96Ev();
extern void _ZN8S1587C503v97Ev();
extern void _ZN8S1587C503v98Ev();
extern void _ZN8S1587C503v99Ev();
extern void _ZN8S1587C504v100Ev();
extern void _ZN8S1587C504v101Ev();
extern void _ZN8S1587C504v102Ev();
extern void _ZN8S1587C504v103Ev();
extern void _ZN8S1587C504v104Ev();
extern void _ZN8S1587C493v65Ev();
extern void _ZN8S1587C493v66Ev();
extern void _ZN8S1587C493v67Ev();
extern void _ZN8S1587C493v68Ev();
extern void _ZN8S1587C493v69Ev();
extern void _ZN8S1587C493v70Ev();
extern void _ZN8S1587C493v71Ev();
extern void _ZN8S1587C493v72Ev();
extern void _ZN8S1587C493v73Ev();
extern void _ZN8S1587C493v74Ev();
extern void _ZN8S1587C493v75Ev();
extern void _ZN8S1587C493v76Ev();
extern void _ZN8S1587C493v77Ev();
extern void _ZN8S1587C493v78Ev();
static  VTBL_ENTRY vtc_S1587C49[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S1587C49[0]),
  (VTBL_ENTRY)&_ZN8S1587C49D1Ev,
  (VTBL_ENTRY)&_ZN8S1587C49D0Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v79Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v80Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v81Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v82Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v83Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v84Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v85Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v86Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v87Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v88Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v89Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v90Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v91Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v92Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v93Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v94Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v95Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v96Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v97Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v98Ev,
  (VTBL_ENTRY)&_ZN8S1587C503v99Ev,
  (VTBL_ENTRY)&_ZN8S1587C504v100Ev,
  (VTBL_ENTRY)&_ZN8S1587C504v101Ev,
  (VTBL_ENTRY)&_ZN8S1587C504v102Ev,
  (VTBL_ENTRY)&_ZN8S1587C504v103Ev,
  (VTBL_ENTRY)&_ZN8S1587C504v104Ev,
  (VTBL_ENTRY)&_ZN8S1587C493v65Ev,
  (VTBL_ENTRY)&_ZN8S1587C493v66Ev,
  (VTBL_ENTRY)&_ZN8S1587C493v67Ev,
  (VTBL_ENTRY)&_ZN8S1587C493v68Ev,
  (VTBL_ENTRY)&_ZN8S1587C493v69Ev,
  (VTBL_ENTRY)&_ZN8S1587C493v70Ev,
  (VTBL_ENTRY)&_ZN8S1587C493v71Ev,
  (VTBL_ENTRY)&_ZN8S1587C493v72Ev,
  (VTBL_ENTRY)&_ZN8S1587C493v73Ev,
  (VTBL_ENTRY)&_ZN8S1587C493v74Ev,
  (VTBL_ENTRY)&_ZN8S1587C493v75Ev,
  (VTBL_ENTRY)&_ZN8S1587C493v76Ev,
  (VTBL_ENTRY)&_ZN8S1587C493v77Ev,
  (VTBL_ENTRY)&_ZN8S1587C493v78Ev,
};
extern VTBL_ENTRY _ZTI8S1587C49[];
extern  VTBL_ENTRY _ZTV8S1587C49[];
Class_Descriptor cd_S1587C49 = {  "S1587C49", // class name
  bases_S1587C49, 1,
  &(vtc_S1587C49[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI8S1587C49),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S1587C49),44, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C51  {
  void *s1587c51f0;
  int s1587c51f1[5];
  void  mf1587c51(); // _ZN8S1587C519mf1587c51Ev
};
//SIG(-1 S1587C51) C1{ m Fp Fi[5]}


void  S1587C51 ::mf1587c51(){}

static void Test_S1587C51()
{
  {
    init_simple_test("S1587C51");
    S1587C51 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(S1587C51)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C51)");
    check_field_offset(lv, s1587c51f0, 0, "S1587C51.s1587c51f0");
    check_field_offset(lv, s1587c51f1, ABISELECT(8,4), "S1587C51.s1587c51f1");
  }
}
static Arrange_To_Call_Me vS1587C51(Test_S1587C51, "S1587C51", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C53  {
  void *s1587c53f0;
  virtual  ~S1587C53(); // _ZN8S1587C53D1Ev
  virtual void  v107(); // _ZN8S1587C534v107Ev
  virtual void  v108(); // _ZN8S1587C534v108Ev
  virtual void  v109(); // _ZN8S1587C534v109Ev
  virtual void  v110(); // _ZN8S1587C534v110Ev
  virtual void  v111(); // _ZN8S1587C534v111Ev
  virtual void  v112(); // _ZN8S1587C534v112Ev
  virtual void  v113(); // _ZN8S1587C534v113Ev
  virtual void  v114(); // _ZN8S1587C534v114Ev
  virtual void  v115(); // _ZN8S1587C534v115Ev
  S1587C53(); // tgen
};
//SIG(-1 S1587C53) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fp}


 S1587C53 ::~S1587C53(){ note_dtor("S1587C53", this);}
void  S1587C53 ::v107(){vfunc_called(this, "_ZN8S1587C534v107Ev");}
void  S1587C53 ::v108(){vfunc_called(this, "_ZN8S1587C534v108Ev");}
void  S1587C53 ::v109(){vfunc_called(this, "_ZN8S1587C534v109Ev");}
void  S1587C53 ::v110(){vfunc_called(this, "_ZN8S1587C534v110Ev");}
void  S1587C53 ::v111(){vfunc_called(this, "_ZN8S1587C534v111Ev");}
void  S1587C53 ::v112(){vfunc_called(this, "_ZN8S1587C534v112Ev");}
void  S1587C53 ::v113(){vfunc_called(this, "_ZN8S1587C534v113Ev");}
void  S1587C53 ::v114(){vfunc_called(this, "_ZN8S1587C534v114Ev");}
void  S1587C53 ::v115(){vfunc_called(this, "_ZN8S1587C534v115Ev");}
S1587C53 ::S1587C53(){ note_ctor("S1587C53", this);} // tgen

static void Test_S1587C53()
{
  extern Class_Descriptor cd_S1587C53;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S1587C53, buf);
    S1587C53 *dp, &lv = *(dp=new (buf) S1587C53());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S1587C53)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C53)");
    check_field_offset(lv, s1587c53f0, ABISELECT(8,4), "S1587C53.s1587c53f0");
    test_class_info(&lv, &cd_S1587C53);
    dp->~S1587C53();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1587C53(Test_S1587C53, "S1587C53", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S1587C53C1Ev();
extern void _ZN8S1587C53D1Ev();
Name_Map name_map_S1587C53[] = {
  NSPAIR(_ZN8S1587C53C1Ev),
  NSPAIR(_ZN8S1587C53D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S1587C53[];
extern void _ZN8S1587C53D1Ev();
extern void _ZN8S1587C53D0Ev();
extern void _ZN8S1587C534v107Ev();
extern void _ZN8S1587C534v108Ev();
extern void _ZN8S1587C534v109Ev();
extern void _ZN8S1587C534v110Ev();
extern void _ZN8S1587C534v111Ev();
extern void _ZN8S1587C534v112Ev();
extern void _ZN8S1587C534v113Ev();
extern void _ZN8S1587C534v114Ev();
extern void _ZN8S1587C534v115Ev();
static  VTBL_ENTRY vtc_S1587C53[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S1587C53[0]),
  (VTBL_ENTRY)&_ZN8S1587C53D1Ev,
  (VTBL_ENTRY)&_ZN8S1587C53D0Ev,
  (VTBL_ENTRY)&_ZN8S1587C534v107Ev,
  (VTBL_ENTRY)&_ZN8S1587C534v108Ev,
  (VTBL_ENTRY)&_ZN8S1587C534v109Ev,
  (VTBL_ENTRY)&_ZN8S1587C534v110Ev,
  (VTBL_ENTRY)&_ZN8S1587C534v111Ev,
  (VTBL_ENTRY)&_ZN8S1587C534v112Ev,
  (VTBL_ENTRY)&_ZN8S1587C534v113Ev,
  (VTBL_ENTRY)&_ZN8S1587C534v114Ev,
  (VTBL_ENTRY)&_ZN8S1587C534v115Ev,
};
extern VTBL_ENTRY _ZTI8S1587C53[];
extern  VTBL_ENTRY _ZTV8S1587C53[];
Class_Descriptor cd_S1587C53 = {  "S1587C53", // class name
  0,0,//no base classes
  &(vtc_S1587C53[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S1587C53),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S1587C53),13, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C52  : S1587C53 {
  char s1587c52f0;
  int s1587c52f1;
  char s1587c52f2[2];
  void *s1587c52f3;
  ::S1587C44_nt s1587c52f4;
  virtual  ~S1587C52(); // _ZN8S1587C52D1Ev
  virtual void  v105(); // _ZN8S1587C524v105Ev
  virtual void  v106(); // _ZN8S1587C524v106Ev
  S1587C52(); // tgen
};
//SIG(-1 S1587C52) C1{ BC2{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 Fp} vd v1 v2 Fc Fi Fc[2] Fp FC3{}}


 S1587C52 ::~S1587C52(){ note_dtor("S1587C52", this);}
void  S1587C52 ::v105(){vfunc_called(this, "_ZN8S1587C524v105Ev");}
void  S1587C52 ::v106(){vfunc_called(this, "_ZN8S1587C524v106Ev");}
S1587C52 ::S1587C52(){ note_ctor("S1587C52", this);} // tgen

static void Test_S1587C52()
{
  extern Class_Descriptor cd_S1587C52;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,8)];
    init_test(&cd_S1587C52, buf);
    S1587C52 *dp, &lv = *(dp=new (buf) S1587C52());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(S1587C52)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C52)");
    check_base_class_offset(lv, (S1587C53*), 0, "S1587C52");
    check_field_offset(lv, s1587c52f0, ABISELECT(16,8), "S1587C52.s1587c52f0");
    check_field_offset(lv, s1587c52f1, ABISELECT(20,12), "S1587C52.s1587c52f1");
    check_field_offset(lv, s1587c52f2, ABISELECT(24,16), "S1587C52.s1587c52f2");
    check_field_offset(lv, s1587c52f3, ABISELECT(32,20), "S1587C52.s1587c52f3");
    check_field_offset(lv, s1587c52f4, ABISELECT(40,24), "S1587C52.s1587c52f4");
    test_class_info(&lv, &cd_S1587C52);
    dp->~S1587C52();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1587C52(Test_S1587C52, "S1587C52", ABISELECT(48,28));

#else // __cplusplus

extern void _ZN8S1587C52C1Ev();
extern void _ZN8S1587C52D1Ev();
Name_Map name_map_S1587C52[] = {
  NSPAIR(_ZN8S1587C52C1Ev),
  NSPAIR(_ZN8S1587C52D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1587C53;
extern VTBL_ENTRY _ZTI8S1587C53[];
extern  VTBL_ENTRY _ZTV8S1587C53[];
static Base_Class bases_S1587C52[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1587C53,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S1587C52[];
extern void _ZN8S1587C52D1Ev();
extern void _ZN8S1587C52D0Ev();
extern void _ZN8S1587C534v107Ev();
extern void _ZN8S1587C534v108Ev();
extern void _ZN8S1587C534v109Ev();
extern void _ZN8S1587C534v110Ev();
extern void _ZN8S1587C534v111Ev();
extern void _ZN8S1587C534v112Ev();
extern void _ZN8S1587C534v113Ev();
extern void _ZN8S1587C534v114Ev();
extern void _ZN8S1587C534v115Ev();
extern void _ZN8S1587C524v105Ev();
extern void _ZN8S1587C524v106Ev();
static  VTBL_ENTRY vtc_S1587C52[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S1587C52[0]),
  (VTBL_ENTRY)&_ZN8S1587C52D1Ev,
  (VTBL_ENTRY)&_ZN8S1587C52D0Ev,
  (VTBL_ENTRY)&_ZN8S1587C534v107Ev,
  (VTBL_ENTRY)&_ZN8S1587C534v108Ev,
  (VTBL_ENTRY)&_ZN8S1587C534v109Ev,
  (VTBL_ENTRY)&_ZN8S1587C534v110Ev,
  (VTBL_ENTRY)&_ZN8S1587C534v111Ev,
  (VTBL_ENTRY)&_ZN8S1587C534v112Ev,
  (VTBL_ENTRY)&_ZN8S1587C534v113Ev,
  (VTBL_ENTRY)&_ZN8S1587C534v114Ev,
  (VTBL_ENTRY)&_ZN8S1587C534v115Ev,
  (VTBL_ENTRY)&_ZN8S1587C524v105Ev,
  (VTBL_ENTRY)&_ZN8S1587C524v106Ev,
};
extern VTBL_ENTRY _ZTI8S1587C52[];
extern  VTBL_ENTRY _ZTV8S1587C52[];
Class_Descriptor cd_S1587C52 = {  "S1587C52", // class name
  bases_S1587C52, 1,
  &(vtc_S1587C52[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,28), // object size
  NSPAIRA(_ZTI8S1587C52),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S1587C52),15, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C54_nt  {
  int s1587c54f0[2];
  void  mf1587c54(); // _ZN11S1587C54_nt9mf1587c54Ev
  virtual  ~S1587C54_nt(); // _ZN11S1587C54_ntD1Ev
  S1587C54_nt(); // tgen
};
//SIG(-1 S1587C54_nt) C1{ vd m Fi[2]}


void  S1587C54_nt ::mf1587c54(){}
 S1587C54_nt ::~S1587C54_nt(){ note_dtor("S1587C54_nt", this);}
S1587C54_nt ::S1587C54_nt(){ note_ctor("S1587C54_nt", this);} // tgen

//skip512 S1587C54_nt

#else // __cplusplus

extern void _ZN11S1587C54_ntC1Ev();
extern void _ZN11S1587C54_ntD1Ev();
Name_Map name_map_S1587C54_nt[] = {
  NSPAIR(_ZN11S1587C54_ntC1Ev),
  NSPAIR(_ZN11S1587C54_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S1587C54_nt[];
extern void _ZN11S1587C54_ntD1Ev();
extern void _ZN11S1587C54_ntD0Ev();
static  VTBL_ENTRY vtc_S1587C54_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S1587C54_nt[0]),
  (VTBL_ENTRY)&_ZN11S1587C54_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S1587C54_ntD0Ev,
};
extern VTBL_ENTRY _ZTI11S1587C54_nt[];
VTBL_ENTRY *P__ZTI11S1587C54_nt = _ZTI11S1587C54_nt; 
extern  VTBL_ENTRY _ZTV11S1587C54_nt[];
Class_Descriptor cd_S1587C54_nt = {  "S1587C54_nt", // class name
  0,0,//no base classes
  &(vtc_S1587C54_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,12), // object size
  NSPAIRA(_ZTI11S1587C54_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S1587C54_nt),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C43  {
  ::S1587C44_nt s1587c43f0;
  ::S1587C44_nt s1587c43f1;
  ::S1587C44_nt s1587c43f2;
  ::S1587C44_nt s1587c43f3;
  ::S1587C44_nt s1587c43f4;
  ::S1587C44_nt s1587c43f5;
  ::S1587C44_nt s1587c43f6;
  ::S1587C44_nt s1587c43f7;
  void *s1587c43f8;
  char s1587c43f9;
  void *s1587c43f10[2];
  ::S3213C4_nt s1587c43f11;
  int s1587c43f12;
  ::S1587C45 s1587c43f13;
  ::S1587C46 s1587c43f14;
  ::S1587C49 s1587c43f15;
  ::S1587C51 s1587c43f16;
  ::S1587C52 s1587c43f17;
  ::S1587C52 s1587c43f18;
  ::S1587C54_nt s1587c43f19;
  void *s1587c43f20[2];
  int s1587c43f21;
  void  mf1587c43(); // _ZN8S1587C439mf1587c43Ev
};
//SIG(-1 S1587C43) C1{ m FC2{} FC2 FC2 FC2 FC2 FC2 FC2 FC2 Fp Fc Fp[2] FC3{ m Fi[2]} Fi FC4{ m Fp[2]} FC5{ BC6{ vd v4 v5 v6 v7 v8 v9 v10 Fp[3] Fi[3] Fc[3] Fi[8] Fc[2] Fp[6] Fi[3]} vd v1 v2 v3 FC7{ m Fp FC8{ BC9{ m Fp Fi} Fp} Fc Fp} FC8} FC10{ BC11{ vd v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50} vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp Fi} FC12{ m Fp Fi[5]} FC13{ BC14{ vd v53 v54 v55 v56 v57 v58 v59 v60 v61 Fp} vd v51 v52 Fc Fi Fc[2] Fp FC2} FC13 FC15{ vd m Fi[2]} Fp[2] Fi}


void  S1587C43 ::mf1587c43(){}

static void Test_S1587C43()
{
  {
    init_simple_test("S1587C43");
    S1587C43 lv;
    check2(sizeof(lv), ABISELECT(488,300), "sizeof(S1587C43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C43)");
    check_field_offset(lv, s1587c43f0, 0, "S1587C43.s1587c43f0");
    check_field_offset(lv, s1587c43f1, 1, "S1587C43.s1587c43f1");
    check_field_offset(lv, s1587c43f2, 2, "S1587C43.s1587c43f2");
    check_field_offset(lv, s1587c43f3, 3, "S1587C43.s1587c43f3");
    check_field_offset(lv, s1587c43f4, 4, "S1587C43.s1587c43f4");
    check_field_offset(lv, s1587c43f5, 5, "S1587C43.s1587c43f5");
    check_field_offset(lv, s1587c43f6, 6, "S1587C43.s1587c43f6");
    check_field_offset(lv, s1587c43f7, 7, "S1587C43.s1587c43f7");
    check_field_offset(lv, s1587c43f8, 8, "S1587C43.s1587c43f8");
    check_field_offset(lv, s1587c43f9, ABISELECT(16,12), "S1587C43.s1587c43f9");
    check_field_offset(lv, s1587c43f10, ABISELECT(24,16), "S1587C43.s1587c43f10");
    check_field_offset(lv, s1587c43f11, ABISELECT(40,24), "S1587C43.s1587c43f11");
    check_field_offset(lv, s1587c43f12, ABISELECT(48,32), "S1587C43.s1587c43f12");
    check_field_offset(lv, s1587c43f13, ABISELECT(56,36), "S1587C43.s1587c43f13");
    check_field_offset(lv, s1587c43f14, ABISELECT(72,44), "S1587C43.s1587c43f14");
    check_field_offset(lv, s1587c43f15, ABISELECT(296,184), "S1587C43.s1587c43f15");
    check_field_offset(lv, s1587c43f16, ABISELECT(320,196), "S1587C43.s1587c43f16");
    check_field_offset(lv, s1587c43f17, ABISELECT(352,220), "S1587C43.s1587c43f17");
    check_field_offset(lv, s1587c43f18, ABISELECT(400,248), "S1587C43.s1587c43f18");
    check_field_offset(lv, s1587c43f19, ABISELECT(448,276), "S1587C43.s1587c43f19");
    check_field_offset(lv, s1587c43f20, ABISELECT(464,288), "S1587C43.s1587c43f20");
    check_field_offset(lv, s1587c43f21, ABISELECT(480,296), "S1587C43.s1587c43f21");
  }
}
static Arrange_To_Call_Me vS1587C43(Test_S1587C43, "S1587C43", ABISELECT(488,300));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C56  {
  virtual  ~S1587C56(); // _ZN8S1587C56D1Ev
  virtual void  v130(); // _ZN8S1587C564v130Ev
  virtual void  v131(); // _ZN8S1587C564v131Ev
  virtual void  v132(); // _ZN8S1587C564v132Ev
  virtual void  v133(); // _ZN8S1587C564v133Ev
  virtual void  v134(); // _ZN8S1587C564v134Ev
  virtual void  v135(); // _ZN8S1587C564v135Ev
  virtual void  v136(); // _ZN8S1587C564v136Ev
  virtual void  v137(); // _ZN8S1587C564v137Ev
  virtual void  v138(); // _ZN8S1587C564v138Ev
  virtual void  v139(); // _ZN8S1587C564v139Ev
  virtual void  v140(); // _ZN8S1587C564v140Ev
  virtual void  v141(); // _ZN8S1587C564v141Ev
  virtual void  v142(); // _ZN8S1587C564v142Ev
  virtual void  v143(); // _ZN8S1587C564v143Ev
  S1587C56(); // tgen
};
//SIG(-1 S1587C56) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14}


 S1587C56 ::~S1587C56(){ note_dtor("S1587C56", this);}
void  S1587C56 ::v130(){vfunc_called(this, "_ZN8S1587C564v130Ev");}
void  S1587C56 ::v131(){vfunc_called(this, "_ZN8S1587C564v131Ev");}
void  S1587C56 ::v132(){vfunc_called(this, "_ZN8S1587C564v132Ev");}
void  S1587C56 ::v133(){vfunc_called(this, "_ZN8S1587C564v133Ev");}
void  S1587C56 ::v134(){vfunc_called(this, "_ZN8S1587C564v134Ev");}
void  S1587C56 ::v135(){vfunc_called(this, "_ZN8S1587C564v135Ev");}
void  S1587C56 ::v136(){vfunc_called(this, "_ZN8S1587C564v136Ev");}
void  S1587C56 ::v137(){vfunc_called(this, "_ZN8S1587C564v137Ev");}
void  S1587C56 ::v138(){vfunc_called(this, "_ZN8S1587C564v138Ev");}
void  S1587C56 ::v139(){vfunc_called(this, "_ZN8S1587C564v139Ev");}
void  S1587C56 ::v140(){vfunc_called(this, "_ZN8S1587C564v140Ev");}
void  S1587C56 ::v141(){vfunc_called(this, "_ZN8S1587C564v141Ev");}
void  S1587C56 ::v142(){vfunc_called(this, "_ZN8S1587C564v142Ev");}
void  S1587C56 ::v143(){vfunc_called(this, "_ZN8S1587C564v143Ev");}
S1587C56 ::S1587C56(){ note_ctor("S1587C56", this);} // tgen

static void Test_S1587C56()
{
  extern Class_Descriptor cd_S1587C56;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1587C56, buf);
    S1587C56 *dp, &lv = *(dp=new (buf) S1587C56());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1587C56)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C56)");
    test_class_info(&lv, &cd_S1587C56);
    dp->~S1587C56();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1587C56(Test_S1587C56, "S1587C56", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S1587C56C1Ev();
extern void _ZN8S1587C56D1Ev();
Name_Map name_map_S1587C56[] = {
  NSPAIR(_ZN8S1587C56C1Ev),
  NSPAIR(_ZN8S1587C56D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S1587C56[];
extern void _ZN8S1587C56D1Ev();
extern void _ZN8S1587C56D0Ev();
extern void _ZN8S1587C564v130Ev();
extern void _ZN8S1587C564v131Ev();
extern void _ZN8S1587C564v132Ev();
extern void _ZN8S1587C564v133Ev();
extern void _ZN8S1587C564v134Ev();
extern void _ZN8S1587C564v135Ev();
extern void _ZN8S1587C564v136Ev();
extern void _ZN8S1587C564v137Ev();
extern void _ZN8S1587C564v138Ev();
extern void _ZN8S1587C564v139Ev();
extern void _ZN8S1587C564v140Ev();
extern void _ZN8S1587C564v141Ev();
extern void _ZN8S1587C564v142Ev();
extern void _ZN8S1587C564v143Ev();
static  VTBL_ENTRY vtc_S1587C56[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S1587C56[0]),
  (VTBL_ENTRY)&_ZN8S1587C56D1Ev,
  (VTBL_ENTRY)&_ZN8S1587C56D0Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v130Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v131Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v132Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v133Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v134Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v135Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v136Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v137Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v138Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v139Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v140Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v141Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v142Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v143Ev,
};
extern VTBL_ENTRY _ZTI8S1587C56[];
extern  VTBL_ENTRY _ZTV8S1587C56[];
Class_Descriptor cd_S1587C56 = {  "S1587C56", // class name
  0,0,//no base classes
  &(vtc_S1587C56[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S1587C56),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S1587C56),18, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C55  : S1587C56 {
  void *s1587c55f0;
  virtual void  v116(); // _ZN8S1587C554v116Ev
  virtual void  v117(); // _ZN8S1587C554v117Ev
  virtual void  v118(); // _ZN8S1587C554v118Ev
  virtual void  v119(); // _ZN8S1587C554v119Ev
  virtual void  v120(); // _ZN8S1587C554v120Ev
  virtual void  v121(); // _ZN8S1587C554v121Ev
  virtual void  v122(); // _ZN8S1587C554v122Ev
  virtual void  v123(); // _ZN8S1587C554v123Ev
  virtual void  v124(); // _ZN8S1587C554v124Ev
  virtual void  v125(); // _ZN8S1587C554v125Ev
  virtual void  v126(); // _ZN8S1587C554v126Ev
  virtual void  v127(); // _ZN8S1587C554v127Ev
  virtual void  v128(); // _ZN8S1587C554v128Ev
  virtual void  v129(); // _ZN8S1587C554v129Ev
  ~S1587C55(); // tgen
  S1587C55(); // tgen
};
//SIG(-1 S1587C55) C1{ BC2{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp}


void  S1587C55 ::v116(){vfunc_called(this, "_ZN8S1587C554v116Ev");}
void  S1587C55 ::v117(){vfunc_called(this, "_ZN8S1587C554v117Ev");}
void  S1587C55 ::v118(){vfunc_called(this, "_ZN8S1587C554v118Ev");}
void  S1587C55 ::v119(){vfunc_called(this, "_ZN8S1587C554v119Ev");}
void  S1587C55 ::v120(){vfunc_called(this, "_ZN8S1587C554v120Ev");}
void  S1587C55 ::v121(){vfunc_called(this, "_ZN8S1587C554v121Ev");}
void  S1587C55 ::v122(){vfunc_called(this, "_ZN8S1587C554v122Ev");}
void  S1587C55 ::v123(){vfunc_called(this, "_ZN8S1587C554v123Ev");}
void  S1587C55 ::v124(){vfunc_called(this, "_ZN8S1587C554v124Ev");}
void  S1587C55 ::v125(){vfunc_called(this, "_ZN8S1587C554v125Ev");}
void  S1587C55 ::v126(){vfunc_called(this, "_ZN8S1587C554v126Ev");}
void  S1587C55 ::v127(){vfunc_called(this, "_ZN8S1587C554v127Ev");}
void  S1587C55 ::v128(){vfunc_called(this, "_ZN8S1587C554v128Ev");}
void  S1587C55 ::v129(){vfunc_called(this, "_ZN8S1587C554v129Ev");}
S1587C55 ::~S1587C55(){ note_dtor("S1587C55", this);} // tgen
S1587C55 ::S1587C55(){ note_ctor("S1587C55", this);} // tgen

static void Test_S1587C55()
{
  extern Class_Descriptor cd_S1587C55;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S1587C55, buf);
    S1587C55 *dp, &lv = *(dp=new (buf) S1587C55());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S1587C55)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C55)");
    check_base_class_offset(lv, (S1587C56*), 0, "S1587C55");
    check_field_offset(lv, s1587c55f0, ABISELECT(8,4), "S1587C55.s1587c55f0");
    test_class_info(&lv, &cd_S1587C55);
    dp->~S1587C55();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1587C55(Test_S1587C55, "S1587C55", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S1587C55C1Ev();
extern void _ZN8S1587C55D1Ev();
Name_Map name_map_S1587C55[] = {
  NSPAIR(_ZN8S1587C55C1Ev),
  NSPAIR(_ZN8S1587C55D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1587C56;
extern VTBL_ENTRY _ZTI8S1587C56[];
extern  VTBL_ENTRY _ZTV8S1587C56[];
static Base_Class bases_S1587C55[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1587C56,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S1587C55[];
extern void _ZN8S1587C55D1Ev();
extern void _ZN8S1587C55D0Ev();
extern void _ZN8S1587C564v130Ev();
extern void _ZN8S1587C564v131Ev();
extern void _ZN8S1587C564v132Ev();
extern void _ZN8S1587C564v133Ev();
extern void _ZN8S1587C564v134Ev();
extern void _ZN8S1587C564v135Ev();
extern void _ZN8S1587C564v136Ev();
extern void _ZN8S1587C564v137Ev();
extern void _ZN8S1587C564v138Ev();
extern void _ZN8S1587C564v139Ev();
extern void _ZN8S1587C564v140Ev();
extern void _ZN8S1587C564v141Ev();
extern void _ZN8S1587C564v142Ev();
extern void _ZN8S1587C564v143Ev();
extern void _ZN8S1587C554v116Ev();
extern void _ZN8S1587C554v117Ev();
extern void _ZN8S1587C554v118Ev();
extern void _ZN8S1587C554v119Ev();
extern void _ZN8S1587C554v120Ev();
extern void _ZN8S1587C554v121Ev();
extern void _ZN8S1587C554v122Ev();
extern void _ZN8S1587C554v123Ev();
extern void _ZN8S1587C554v124Ev();
extern void _ZN8S1587C554v125Ev();
extern void _ZN8S1587C554v126Ev();
extern void _ZN8S1587C554v127Ev();
extern void _ZN8S1587C554v128Ev();
extern void _ZN8S1587C554v129Ev();
static  VTBL_ENTRY vtc_S1587C55[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S1587C55[0]),
  (VTBL_ENTRY)&_ZN8S1587C55D1Ev,
  (VTBL_ENTRY)&_ZN8S1587C55D0Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v130Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v131Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v132Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v133Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v134Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v135Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v136Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v137Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v138Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v139Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v140Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v141Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v142Ev,
  (VTBL_ENTRY)&_ZN8S1587C564v143Ev,
  (VTBL_ENTRY)&_ZN8S1587C554v116Ev,
  (VTBL_ENTRY)&_ZN8S1587C554v117Ev,
  (VTBL_ENTRY)&_ZN8S1587C554v118Ev,
  (VTBL_ENTRY)&_ZN8S1587C554v119Ev,
  (VTBL_ENTRY)&_ZN8S1587C554v120Ev,
  (VTBL_ENTRY)&_ZN8S1587C554v121Ev,
  (VTBL_ENTRY)&_ZN8S1587C554v122Ev,
  (VTBL_ENTRY)&_ZN8S1587C554v123Ev,
  (VTBL_ENTRY)&_ZN8S1587C554v124Ev,
  (VTBL_ENTRY)&_ZN8S1587C554v125Ev,
  (VTBL_ENTRY)&_ZN8S1587C554v126Ev,
  (VTBL_ENTRY)&_ZN8S1587C554v127Ev,
  (VTBL_ENTRY)&_ZN8S1587C554v128Ev,
  (VTBL_ENTRY)&_ZN8S1587C554v129Ev,
};
extern VTBL_ENTRY _ZTI8S1587C55[];
extern  VTBL_ENTRY _ZTV8S1587C55[];
Class_Descriptor cd_S1587C55 = {  "S1587C55", // class name
  bases_S1587C55, 1,
  &(vtc_S1587C55[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S1587C55),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S1587C55),32, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C57  {
  void *s1587c57f0;
  __tsi64 s1587c57f1;
  void  mf1587c57(); // _ZN8S1587C579mf1587c57Ev
};
//SIG(-1 S1587C57) C1{ m Fp FL}


void  S1587C57 ::mf1587c57(){}

static void Test_S1587C57()
{
  {
    init_simple_test("S1587C57");
    S1587C57 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1587C57)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C57)");
    check_field_offset(lv, s1587c57f0, 0, "S1587C57.s1587c57f0");
    check_field_offset(lv, s1587c57f1, ABISELECT(8,4), "S1587C57.s1587c57f1");
  }
}
static Arrange_To_Call_Me vS1587C57(Test_S1587C57, "S1587C57", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1587C1  : S1587C2 {
  ::S1587C6_nt s1587c1f0;
  ::S1587C12 s1587c1f1;
  ::S1587C16_nt s1587c1f2;
  ::S1587C17 s1587c1f3;
  ::S1587C18 s1587c1f4;
  ::S1587C18 s1587c1f5;
  ::S1587C18 s1587c1f6;
  int s1587c1f7;
  ::S1587C26 s1587c1f8[10];
  ::S1587C27 s1587c1f9;
  ::S1587C6_nt s1587c1f10;
  ::S1587C31 s1587c1f11[10];
  ::S1587C31 s1587c1f12[10];
  char s1587c1f13;
  ::S1587C33 s1587c1f14;
  char s1587c1f15;
  ::S3213C4_nt s1587c1f16;
  char s1587c1f17;
  int s1587c1f18[2];
  char s1587c1f19;
  int s1587c1f20[2];
  ::S1587C35 s1587c1f21[5];
  ::S1587C13 s1587c1f22;
  ::S1587C37 s1587c1f23;
  ::S1587C38 s1587c1f24;
  ::S1587C40 s1587c1f25[5];
  ::S1587C41 s1587c1f26[10];
  int s1587c1f27;
  ::S1587C43 s1587c1f28;
  ::S1587C55 s1587c1f29;
  ::S1587C57 s1587c1f30;
  virtual  ~S1587C1(); // _ZN7S1587C1D1Ev
  virtual void  v1(); // _ZN7S1587C12v1Ev
  virtual void  v2(); // _ZN7S1587C12v2Ev
  virtual void  v3(); // _ZN7S1587C12v3Ev
  virtual void  v4(); // _ZN7S1587C12v4Ev
  virtual void  v5(); // _ZN7S1587C12v5Ev
  virtual void  v6(); // _ZN7S1587C12v6Ev
  virtual void  v7(); // _ZN7S1587C12v7Ev
  virtual void  v8(); // _ZN7S1587C12v8Ev
  S1587C1(); // tgen
};
//SIG(1 S1587C1) C1{ BC2{ BC3{ BC4{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 Fp FC5{ m FC6{ m Fp Fi FC7{ m}} Fi} Fc Fi} vd v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 Fp[3] Fi} vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 Fp[2] Fi[3] FC5 Fc FC8{ m FC9{ m FL}} Fc Fi Fc Fi Fc[2] Fi Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 FC6 FC10{ m Fp Fi FC11{ m Fp FC12{ BC13{ m Fp Fi} Fp} Fc Fp}} FC14{ m Fc} FC15{ m Fp[2] Fi[2]} FC16{ m FC15 Fp[2] Fc Fp FC17{ m Fp[2]} FC17 FC18{ m Fp[2]} Fp Fi FC19{ Fi[3] FC20{ Fi} FC21{ Fi[3]}} Fi[3] Fc FC21 Fi} FC16 FC16 Fi FC22{ Fi[2] Fc[193] FL Fc}[10] FC23{ m FC18 FC6 FC24{ FC25{ Fc[20]} Fc[16]}} FC6 FC26{ BC27{ vd v52 v53 v54 FL Fp Fi} vd v50 v51 Fi Fc}[10] FC26[10] Fc FC28{ Fi[2] Fc[197] Fi Fc FL[3] Fi Fc[33] Fi[4] Fc[65] Fi Fc[65] Fi[4]} Fc FC29{ m Fi[2]} Fc Fi[2] Fc Fi[2] FC30{ Fi[3] Fc[2] Fi FC31{ BC29 Fc[193]} Fi}[5] FC11 FC32{ m FC33{ m Fp[2]} Fc Fp Fc} FC33 FC34{ FC35{ m FC36{ vd m FL Fc} FC36} Fi}[5] FC35[10] Fi FC37{ m FC38{} FC38 FC38 FC38 FC38 FC38 FC38 FC38 Fp Fc Fp[2] FC29 Fi FC39{ m Fp[2]} FC40{ BC41{ vd v58 v59 v60 v61 v62 v63 v64 Fp[3] Fi[3] Fc[3] Fi[8] Fc[2] Fp[6] Fi[3]} vd v55 v56 v57 FC11 FC12} FC42{ BC43{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104} vd v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 Fp Fi} FC44{ m Fp Fi[5]} FC45{ BC46{ vd v107 v108 v109 v110 v111 v112 v113 v114 v115 Fp} vd v105 v106 Fc Fi Fc[2] Fp FC38} FC45 FC47{ vd m Fi[2]} Fp[2] Fi} FC48{ BC49{ vd v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143} v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 Fp} FC50{ m Fp FL}}


 S1587C1 ::~S1587C1(){ note_dtor("S1587C1", this);}
void  S1587C1 ::v1(){vfunc_called(this, "_ZN7S1587C12v1Ev");}
void  S1587C1 ::v2(){vfunc_called(this, "_ZN7S1587C12v2Ev");}
void  S1587C1 ::v3(){vfunc_called(this, "_ZN7S1587C12v3Ev");}
void  S1587C1 ::v4(){vfunc_called(this, "_ZN7S1587C12v4Ev");}
void  S1587C1 ::v5(){vfunc_called(this, "_ZN7S1587C12v5Ev");}
void  S1587C1 ::v6(){vfunc_called(this, "_ZN7S1587C12v6Ev");}
void  S1587C1 ::v7(){vfunc_called(this, "_ZN7S1587C12v7Ev");}
void  S1587C1 ::v8(){vfunc_called(this, "_ZN7S1587C12v8Ev");}
S1587C1 ::S1587C1(){ note_ctor("S1587C1", this);} // tgen

static void Test_S1587C1()
{
  extern Class_Descriptor cd_S1587C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(875,1466)];
    init_test(&cd_S1587C1, buf);
    S1587C1 *dp, &lv = *(dp=new (buf) S1587C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(6992,5860), "sizeof(S1587C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1587C1)");
    check_base_class_offset(lv, (S1587C4*)(S1587C3*)(S1587C2*), 0, "S1587C1");
    check_base_class_offset(lv, (S1587C3*)(S1587C2*), 0, "S1587C1");
    check_base_class_offset(lv, (S1587C2*), 0, "S1587C1");
    check_field_offset(lv, s1587c1f0, ABISELECT(184,124), "S1587C1.s1587c1f0");
    check_field_offset(lv, s1587c1f1, ABISELECT(200,136), "S1587C1.s1587c1f1");
    check_field_offset(lv, s1587c1f2, ABISELECT(264,168), "S1587C1.s1587c1f2");
    check_field_offset(lv, s1587c1f3, ABISELECT(272,172), "S1587C1.s1587c1f3");
    check_field_offset(lv, s1587c1f4, ABISELECT(296,188), "S1587C1.s1587c1f4");
    check_field_offset(lv, s1587c1f5, ABISELECT(472,312), "S1587C1.s1587c1f5");
    check_field_offset(lv, s1587c1f6, ABISELECT(648,436), "S1587C1.s1587c1f6");
    check_field_offset(lv, s1587c1f7, ABISELECT(824,560), "S1587C1.s1587c1f7");
    check_field_offset(lv, s1587c1f8, ABISELECT(832,564), "S1587C1.s1587c1f8");
    check_field_offset(lv, s1587c1f9, ABISELECT(3072,2724), "S1587C1.s1587c1f9");
    check_field_offset(lv, s1587c1f10, ABISELECT(3144,2780), "S1587C1.s1587c1f10");
    check_field_offset(lv, s1587c1f11, ABISELECT(3160,2792), "S1587C1.s1587c1f11");
    check_field_offset(lv, s1587c1f12, ABISELECT(3560,3072), "S1587C1.s1587c1f12");
    check_field_offset(lv, s1587c1f13, ABISELECT(3960,3352), "S1587C1.s1587c1f13");
    check_field_offset(lv, s1587c1f14, ABISELECT(3968,3356), "S1587C1.s1587c1f14");
    check_field_offset(lv, s1587c1f15, ABISELECT(4424,3808), "S1587C1.s1587c1f15");
    check_field_offset(lv, s1587c1f16, ABISELECT(4428,3812), "S1587C1.s1587c1f16");
    check_field_offset(lv, s1587c1f17, ABISELECT(4436,3820), "S1587C1.s1587c1f17");
    check_field_offset(lv, s1587c1f18, ABISELECT(4440,3824), "S1587C1.s1587c1f18");
    check_field_offset(lv, s1587c1f19, ABISELECT(4448,3832), "S1587C1.s1587c1f19");
    check_field_offset(lv, s1587c1f20, ABISELECT(4452,3836), "S1587C1.s1587c1f20");
    check_field_offset(lv, s1587c1f21, ABISELECT(4460,3844), "S1587C1.s1587c1f21");
    check_field_offset(lv, s1587c1f22, ABISELECT(5600,4984), "S1587C1.s1587c1f22");
    check_field_offset(lv, s1587c1f23, ABISELECT(5648,5008), "S1587C1.s1587c1f23");
    check_field_offset(lv, s1587c1f24, ABISELECT(5688,5028), "S1587C1.s1587c1f24");
    check_field_offset(lv, s1587c1f25, ABISELECT(5704,5036), "S1587C1.s1587c1f25");
    check_field_offset(lv, s1587c1f26, ABISELECT(5984,5216), "S1587C1.s1587c1f26");
    check_field_offset(lv, s1587c1f27, ABISELECT(6464,5536), "S1587C1.s1587c1f27");
    check_field_offset(lv, s1587c1f28, ABISELECT(6472,5540), "S1587C1.s1587c1f28");
    check_field_offset(lv, s1587c1f29, ABISELECT(6960,5840), "S1587C1.s1587c1f29");
    check_field_offset(lv, s1587c1f30, ABISELECT(6976,5848), "S1587C1.s1587c1f30");
    test_class_info(&lv, &cd_S1587C1);
    dp->~S1587C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1587C1(Test_S1587C1, "S1587C1", ABISELECT(6992,5860));

#else // __cplusplus

extern void _ZN7S1587C1C1Ev();
extern void _ZN7S1587C1D1Ev();
Name_Map name_map_S1587C1[] = {
  NSPAIR(_ZN7S1587C1C1Ev),
  NSPAIR(_ZN7S1587C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1587C4;
extern VTBL_ENTRY _ZTI7S1587C4[];
extern  VTBL_ENTRY _ZTV7S1587C4[];
extern Class_Descriptor cd_S1587C3;
extern VTBL_ENTRY _ZTI7S1587C3[];
extern  VTBL_ENTRY _ZTV7S1587C3[];
extern Class_Descriptor cd_S1587C2;
extern VTBL_ENTRY _ZTI7S1587C2[];
extern  VTBL_ENTRY _ZTV7S1587C2[];
static Base_Class bases_S1587C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1587C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1587C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1587C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1587C1[];
extern void _ZN7S1587C1D1Ev();
extern void _ZN7S1587C1D0Ev();
extern void _ZN7S1587C42v9Ev();
extern void _ZN7S1587C43v10Ev();
extern void _ZN7S1587C43v11Ev();
extern void _ZN7S1587C43v12Ev();
extern void _ZN7S1587C43v13Ev();
extern void _ZN7S1587C43v14Ev();
extern void _ZN7S1587C43v15Ev();
extern void _ZN7S1587C43v16Ev();
extern void _ZN7S1587C43v17Ev();
extern void _ZN7S1587C43v18Ev();
extern void _ZN7S1587C43v19Ev();
extern void _ZN7S1587C43v20Ev();
extern void _ZN7S1587C43v21Ev();
extern void _ZN7S1587C33v22Ev();
extern void _ZN7S1587C33v23Ev();
extern void _ZN7S1587C33v24Ev();
extern void _ZN7S1587C33v25Ev();
extern void _ZN7S1587C33v26Ev();
extern void _ZN7S1587C33v27Ev();
extern void _ZN7S1587C33v28Ev();
extern void _ZN7S1587C33v29Ev();
extern void _ZN7S1587C33v30Ev();
extern void _ZN7S1587C33v31Ev();
extern void _ZN7S1587C33v32Ev();
extern void _ZN7S1587C23v33Ev();
extern void _ZN7S1587C23v34Ev();
extern void _ZN7S1587C23v35Ev();
extern void _ZN7S1587C23v36Ev();
extern void _ZN7S1587C23v37Ev();
extern void _ZN7S1587C23v38Ev();
extern void _ZN7S1587C23v39Ev();
extern void _ZN7S1587C23v40Ev();
extern void _ZN7S1587C23v41Ev();
extern void _ZN7S1587C23v42Ev();
extern void _ZN7S1587C23v43Ev();
extern void _ZN7S1587C23v44Ev();
extern void _ZN7S1587C23v45Ev();
extern void _ZN7S1587C23v46Ev();
extern void _ZN7S1587C23v47Ev();
extern void _ZN7S1587C23v48Ev();
extern void _ZN7S1587C23v49Ev();
extern void _ZN7S1587C12v1Ev();
extern void _ZN7S1587C12v2Ev();
extern void _ZN7S1587C12v3Ev();
extern void _ZN7S1587C12v4Ev();
extern void _ZN7S1587C12v5Ev();
extern void _ZN7S1587C12v6Ev();
extern void _ZN7S1587C12v7Ev();
extern void _ZN7S1587C12v8Ev();
static  VTBL_ENTRY vtc_S1587C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1587C1[0]),
  (VTBL_ENTRY)&_ZN7S1587C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1587C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1587C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1587C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v22Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v23Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v29Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v30Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v31Ev,
  (VTBL_ENTRY)&_ZN7S1587C33v32Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v33Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v34Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v35Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v36Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v37Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v38Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v39Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v40Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v41Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v42Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v43Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v44Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v45Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v46Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v47Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v48Ev,
  (VTBL_ENTRY)&_ZN7S1587C23v49Ev,
  (VTBL_ENTRY)&_ZN7S1587C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1587C12v2Ev,
  (VTBL_ENTRY)&_ZN7S1587C12v3Ev,
  (VTBL_ENTRY)&_ZN7S1587C12v4Ev,
  (VTBL_ENTRY)&_ZN7S1587C12v5Ev,
  (VTBL_ENTRY)&_ZN7S1587C12v6Ev,
  (VTBL_ENTRY)&_ZN7S1587C12v7Ev,
  (VTBL_ENTRY)&_ZN7S1587C12v8Ev,
};
extern VTBL_ENTRY _ZTI7S1587C1[];
extern  VTBL_ENTRY _ZTV7S1587C1[];
Class_Descriptor cd_S1587C1 = {  "S1587C1", // class name
  bases_S1587C1, 3,
  &(vtc_S1587C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(6992,5860), // object size
  NSPAIRA(_ZTI7S1587C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1587C1),53, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C6  {
  void *s154c6f0;
  ::S1587C5_nt s154c6f1;
  char s154c6f2;
  int s154c6f3;
  virtual  ~S154C6(); // _ZN6S154C6D1Ev
  virtual void  v15(); // _ZN6S154C63v15Ev
  virtual void  v16(); // _ZN6S154C63v16Ev
  virtual void  v17(); // _ZN6S154C63v17Ev
  virtual void  v18(); // _ZN6S154C63v18Ev
  virtual void  v19(); // _ZN6S154C63v19Ev
  virtual void  v20(); // _ZN6S154C63v20Ev
  virtual void  v21(); // _ZN6S154C63v21Ev
  virtual void  v22(); // _ZN6S154C63v22Ev
  virtual void  v23(); // _ZN6S154C63v23Ev
  virtual void  v24(); // _ZN6S154C63v24Ev
  virtual void  v25(); // _ZN6S154C63v25Ev
  virtual void  v26(); // _ZN6S154C63v26Ev
  virtual void  v27(); // _ZN6S154C63v27Ev
  S154C6(); // tgen
};
//SIG(-1 S154C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 Fp FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fc Fi}


 S154C6 ::~S154C6(){ note_dtor("S154C6", this);}
void  S154C6 ::v15(){vfunc_called(this, "_ZN6S154C63v15Ev");}
void  S154C6 ::v16(){vfunc_called(this, "_ZN6S154C63v16Ev");}
void  S154C6 ::v17(){vfunc_called(this, "_ZN6S154C63v17Ev");}
void  S154C6 ::v18(){vfunc_called(this, "_ZN6S154C63v18Ev");}
void  S154C6 ::v19(){vfunc_called(this, "_ZN6S154C63v19Ev");}
void  S154C6 ::v20(){vfunc_called(this, "_ZN6S154C63v20Ev");}
void  S154C6 ::v21(){vfunc_called(this, "_ZN6S154C63v21Ev");}
void  S154C6 ::v22(){vfunc_called(this, "_ZN6S154C63v22Ev");}
void  S154C6 ::v23(){vfunc_called(this, "_ZN6S154C63v23Ev");}
void  S154C6 ::v24(){vfunc_called(this, "_ZN6S154C63v24Ev");}
void  S154C6 ::v25(){vfunc_called(this, "_ZN6S154C63v25Ev");}
void  S154C6 ::v26(){vfunc_called(this, "_ZN6S154C63v26Ev");}
void  S154C6 ::v27(){vfunc_called(this, "_ZN6S154C63v27Ev");}
S154C6 ::S154C6(){ note_ctor("S154C6", this);} // tgen

static void Test_S154C6()
{
  extern Class_Descriptor cd_S154C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_S154C6, buf);
    S154C6 *dp, &lv = *(dp=new (buf) S154C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(S154C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C6)");
    check_field_offset(lv, s154c6f0, ABISELECT(8,4), "S154C6.s154c6f0");
    check_field_offset(lv, s154c6f1, ABISELECT(16,8), "S154C6.s154c6f1");
    check_field_offset(lv, s154c6f2, ABISELECT(40,24), "S154C6.s154c6f2");
    check_field_offset(lv, s154c6f3, ABISELECT(44,28), "S154C6.s154c6f3");
    test_class_info(&lv, &cd_S154C6);
    dp->~S154C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS154C6(Test_S154C6, "S154C6", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN6S154C6C1Ev();
extern void _ZN6S154C6D1Ev();
Name_Map name_map_S154C6[] = {
  NSPAIR(_ZN6S154C6C1Ev),
  NSPAIR(_ZN6S154C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S154C6[];
extern void _ZN6S154C6D1Ev();
extern void _ZN6S154C6D0Ev();
extern void _ZN6S154C63v15Ev();
extern void _ZN6S154C63v16Ev();
extern void _ZN6S154C63v17Ev();
extern void _ZN6S154C63v18Ev();
extern void _ZN6S154C63v19Ev();
extern void _ZN6S154C63v20Ev();
extern void _ZN6S154C63v21Ev();
extern void _ZN6S154C63v22Ev();
extern void _ZN6S154C63v23Ev();
extern void _ZN6S154C63v24Ev();
extern void _ZN6S154C63v25Ev();
extern void _ZN6S154C63v26Ev();
extern void _ZN6S154C63v27Ev();
static  VTBL_ENTRY vtc_S154C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S154C6[0]),
  (VTBL_ENTRY)&_ZN6S154C6D1Ev,
  (VTBL_ENTRY)&_ZN6S154C6D0Ev,
  (VTBL_ENTRY)&_ZN6S154C63v15Ev,
  (VTBL_ENTRY)&_ZN6S154C63v16Ev,
  (VTBL_ENTRY)&_ZN6S154C63v17Ev,
  (VTBL_ENTRY)&_ZN6S154C63v18Ev,
  (VTBL_ENTRY)&_ZN6S154C63v19Ev,
  (VTBL_ENTRY)&_ZN6S154C63v20Ev,
  (VTBL_ENTRY)&_ZN6S154C63v21Ev,
  (VTBL_ENTRY)&_ZN6S154C63v22Ev,
  (VTBL_ENTRY)&_ZN6S154C63v23Ev,
  (VTBL_ENTRY)&_ZN6S154C63v24Ev,
  (VTBL_ENTRY)&_ZN6S154C63v25Ev,
  (VTBL_ENTRY)&_ZN6S154C63v26Ev,
  (VTBL_ENTRY)&_ZN6S154C63v27Ev,
};
extern VTBL_ENTRY _ZTI6S154C6[];
extern  VTBL_ENTRY _ZTV6S154C6[];
Class_Descriptor cd_S154C6 = {  "S154C6", // class name
  0,0,//no base classes
  &(vtc_S154C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI6S154C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S154C6),17, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C5  : S154C6 {
  void *s154c5f0[3];
  int s154c5f1;
  virtual  ~S154C5(); // _ZN6S154C5D1Ev
  virtual void  v28(); // _ZN6S154C53v28Ev
  virtual void  v29(); // _ZN6S154C53v29Ev
  virtual void  v30(); // _ZN6S154C53v30Ev
  virtual void  v31(); // _ZN6S154C53v31Ev
  virtual void  v32(); // _ZN6S154C53v32Ev
  virtual void  v33(); // _ZN6S154C53v33Ev
  virtual void  v34(); // _ZN6S154C53v34Ev
  virtual void  v35(); // _ZN6S154C53v35Ev
  virtual void  v36(); // _ZN6S154C53v36Ev
  virtual void  v37(); // _ZN6S154C53v37Ev
  virtual void  v38(); // _ZN6S154C53v38Ev
  S154C5(); // tgen
};
//SIG(-1 S154C5) C1{ BC2{ vd v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fc Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 Fp[3] Fi}


 S154C5 ::~S154C5(){ note_dtor("S154C5", this);}
void  S154C5 ::v28(){vfunc_called(this, "_ZN6S154C53v28Ev");}
void  S154C5 ::v29(){vfunc_called(this, "_ZN6S154C53v29Ev");}
void  S154C5 ::v30(){vfunc_called(this, "_ZN6S154C53v30Ev");}
void  S154C5 ::v31(){vfunc_called(this, "_ZN6S154C53v31Ev");}
void  S154C5 ::v32(){vfunc_called(this, "_ZN6S154C53v32Ev");}
void  S154C5 ::v33(){vfunc_called(this, "_ZN6S154C53v33Ev");}
void  S154C5 ::v34(){vfunc_called(this, "_ZN6S154C53v34Ev");}
void  S154C5 ::v35(){vfunc_called(this, "_ZN6S154C53v35Ev");}
void  S154C5 ::v36(){vfunc_called(this, "_ZN6S154C53v36Ev");}
void  S154C5 ::v37(){vfunc_called(this, "_ZN6S154C53v37Ev");}
void  S154C5 ::v38(){vfunc_called(this, "_ZN6S154C53v38Ev");}
S154C5 ::S154C5(){ note_ctor("S154C5", this);} // tgen

static void Test_S154C5()
{
  extern Class_Descriptor cd_S154C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,13)];
    init_test(&cd_S154C5, buf);
    S154C5 *dp, &lv = *(dp=new (buf) S154C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,48), "sizeof(S154C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C5)");
    check_base_class_offset(lv, (S154C6*), 0, "S154C5");
    check_field_offset(lv, s154c5f0, ABISELECT(48,32), "S154C5.s154c5f0");
    check_field_offset(lv, s154c5f1, ABISELECT(72,44), "S154C5.s154c5f1");
    test_class_info(&lv, &cd_S154C5);
    dp->~S154C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS154C5(Test_S154C5, "S154C5", ABISELECT(80,48));

#else // __cplusplus

extern void _ZN6S154C5C1Ev();
extern void _ZN6S154C5D1Ev();
Name_Map name_map_S154C5[] = {
  NSPAIR(_ZN6S154C5C1Ev),
  NSPAIR(_ZN6S154C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S154C6;
extern VTBL_ENTRY _ZTI6S154C6[];
extern  VTBL_ENTRY _ZTV6S154C6[];
static Base_Class bases_S154C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S154C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S154C5[];
extern void _ZN6S154C5D1Ev();
extern void _ZN6S154C5D0Ev();
extern void _ZN6S154C63v15Ev();
extern void _ZN6S154C63v16Ev();
extern void _ZN6S154C63v17Ev();
extern void _ZN6S154C63v18Ev();
extern void _ZN6S154C63v19Ev();
extern void _ZN6S154C63v20Ev();
extern void _ZN6S154C63v21Ev();
extern void _ZN6S154C63v22Ev();
extern void _ZN6S154C63v23Ev();
extern void _ZN6S154C63v24Ev();
extern void _ZN6S154C63v25Ev();
extern void _ZN6S154C63v26Ev();
extern void _ZN6S154C63v27Ev();
extern void _ZN6S154C53v28Ev();
extern void _ZN6S154C53v29Ev();
extern void _ZN6S154C53v30Ev();
extern void _ZN6S154C53v31Ev();
extern void _ZN6S154C53v32Ev();
extern void _ZN6S154C53v33Ev();
extern void _ZN6S154C53v34Ev();
extern void _ZN6S154C53v35Ev();
extern void _ZN6S154C53v36Ev();
extern void _ZN6S154C53v37Ev();
extern void _ZN6S154C53v38Ev();
static  VTBL_ENTRY vtc_S154C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S154C5[0]),
  (VTBL_ENTRY)&_ZN6S154C5D1Ev,
  (VTBL_ENTRY)&_ZN6S154C5D0Ev,
  (VTBL_ENTRY)&_ZN6S154C63v15Ev,
  (VTBL_ENTRY)&_ZN6S154C63v16Ev,
  (VTBL_ENTRY)&_ZN6S154C63v17Ev,
  (VTBL_ENTRY)&_ZN6S154C63v18Ev,
  (VTBL_ENTRY)&_ZN6S154C63v19Ev,
  (VTBL_ENTRY)&_ZN6S154C63v20Ev,
  (VTBL_ENTRY)&_ZN6S154C63v21Ev,
  (VTBL_ENTRY)&_ZN6S154C63v22Ev,
  (VTBL_ENTRY)&_ZN6S154C63v23Ev,
  (VTBL_ENTRY)&_ZN6S154C63v24Ev,
  (VTBL_ENTRY)&_ZN6S154C63v25Ev,
  (VTBL_ENTRY)&_ZN6S154C63v26Ev,
  (VTBL_ENTRY)&_ZN6S154C63v27Ev,
  (VTBL_ENTRY)&_ZN6S154C53v28Ev,
  (VTBL_ENTRY)&_ZN6S154C53v29Ev,
  (VTBL_ENTRY)&_ZN6S154C53v30Ev,
  (VTBL_ENTRY)&_ZN6S154C53v31Ev,
  (VTBL_ENTRY)&_ZN6S154C53v32Ev,
  (VTBL_ENTRY)&_ZN6S154C53v33Ev,
  (VTBL_ENTRY)&_ZN6S154C53v34Ev,
  (VTBL_ENTRY)&_ZN6S154C53v35Ev,
  (VTBL_ENTRY)&_ZN6S154C53v36Ev,
  (VTBL_ENTRY)&_ZN6S154C53v37Ev,
  (VTBL_ENTRY)&_ZN6S154C53v38Ev,
};
extern VTBL_ENTRY _ZTI6S154C5[];
extern  VTBL_ENTRY _ZTV6S154C5[];
Class_Descriptor cd_S154C5 = {  "S154C5", // class name
  bases_S154C5, 1,
  &(vtc_S154C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,48), // object size
  NSPAIRA(_ZTI6S154C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S154C5),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C4  : S154C5 {
  void *s154c4f0[2];
  int s154c4f1[3];
  ::S1587C5_nt s154c4f2;
  char s154c4f3;
  ::S1587C8_nt s154c4f4;
  char s154c4f5;
  int s154c4f6;
  char s154c4f7;
  int s154c4f8;
  char s154c4f9[2];
  int s154c4f10;
  char s154c4f11;
  virtual  ~S154C4(); // _ZN6S154C4D1Ev
  virtual void  v39(); // _ZN6S154C43v39Ev
  virtual void  v40(); // _ZN6S154C43v40Ev
  virtual void  v41(); // _ZN6S154C43v41Ev
  virtual void  v42(); // _ZN6S154C43v42Ev
  virtual void  v43(); // _ZN6S154C43v43Ev
  virtual void  v44(); // _ZN6S154C43v44Ev
  virtual void  v45(); // _ZN6S154C43v45Ev
  virtual void  v46(); // _ZN6S154C43v46Ev
  virtual void  v47(); // _ZN6S154C43v47Ev
  virtual void  v48(); // _ZN6S154C43v48Ev
  virtual void  v49(); // _ZN6S154C43v49Ev
  virtual void  v50(); // _ZN6S154C43v50Ev
  virtual void  v51(); // _ZN6S154C43v51Ev
  virtual void  v52(); // _ZN6S154C43v52Ev
  virtual void  v53(); // _ZN6S154C43v53Ev
  virtual void  v54(); // _ZN6S154C43v54Ev
  virtual void  v55(); // _ZN6S154C43v55Ev
  S154C4(); // tgen
};
//SIG(-1 S154C4) C1{ BC2{ BC3{ vd v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 Fp FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fc Fi} vd v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 Fp[3] Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 Fp[2] Fi[3] FC4 Fc FC7{ m FC8{ m FL}} Fc Fi Fc Fi Fc[2] Fi Fc}


 S154C4 ::~S154C4(){ note_dtor("S154C4", this);}
void  S154C4 ::v39(){vfunc_called(this, "_ZN6S154C43v39Ev");}
void  S154C4 ::v40(){vfunc_called(this, "_ZN6S154C43v40Ev");}
void  S154C4 ::v41(){vfunc_called(this, "_ZN6S154C43v41Ev");}
void  S154C4 ::v42(){vfunc_called(this, "_ZN6S154C43v42Ev");}
void  S154C4 ::v43(){vfunc_called(this, "_ZN6S154C43v43Ev");}
void  S154C4 ::v44(){vfunc_called(this, "_ZN6S154C43v44Ev");}
void  S154C4 ::v45(){vfunc_called(this, "_ZN6S154C43v45Ev");}
void  S154C4 ::v46(){vfunc_called(this, "_ZN6S154C43v46Ev");}
void  S154C4 ::v47(){vfunc_called(this, "_ZN6S154C43v47Ev");}
void  S154C4 ::v48(){vfunc_called(this, "_ZN6S154C43v48Ev");}
void  S154C4 ::v49(){vfunc_called(this, "_ZN6S154C43v49Ev");}
void  S154C4 ::v50(){vfunc_called(this, "_ZN6S154C43v50Ev");}
void  S154C4 ::v51(){vfunc_called(this, "_ZN6S154C43v51Ev");}
void  S154C4 ::v52(){vfunc_called(this, "_ZN6S154C43v52Ev");}
void  S154C4 ::v53(){vfunc_called(this, "_ZN6S154C43v53Ev");}
void  S154C4 ::v54(){vfunc_called(this, "_ZN6S154C43v54Ev");}
void  S154C4 ::v55(){vfunc_called(this, "_ZN6S154C43v55Ev");}
S154C4 ::S154C4(){ note_ctor("S154C4", this);} // tgen

static void Test_S154C4()
{
  extern Class_Descriptor cd_S154C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,32)];
    init_test(&cd_S154C4, buf);
    S154C4 *dp, &lv = *(dp=new (buf) S154C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,124), "sizeof(S154C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C4)");
    check_base_class_offset(lv, (S154C6*)(S154C5*), 0, "S154C4");
    check_base_class_offset(lv, (S154C5*), 0, "S154C4");
    check_field_offset(lv, s154c4f0, ABISELECT(80,48), "S154C4.s154c4f0");
    check_field_offset(lv, s154c4f1, ABISELECT(96,56), "S154C4.s154c4f1");
    check_field_offset(lv, s154c4f2, ABISELECT(112,68), "S154C4.s154c4f2");
    check_field_offset(lv, s154c4f3, ABISELECT(136,84), "S154C4.s154c4f3");
    check_field_offset(lv, s154c4f4, ABISELECT(144,88), "S154C4.s154c4f4");
    check_field_offset(lv, s154c4f5, ABISELECT(152,96), "S154C4.s154c4f5");
    check_field_offset(lv, s154c4f6, ABISELECT(156,100), "S154C4.s154c4f6");
    check_field_offset(lv, s154c4f7, ABISELECT(160,104), "S154C4.s154c4f7");
    check_field_offset(lv, s154c4f8, ABISELECT(164,108), "S154C4.s154c4f8");
    check_field_offset(lv, s154c4f9, ABISELECT(168,112), "S154C4.s154c4f9");
    check_field_offset(lv, s154c4f10, ABISELECT(172,116), "S154C4.s154c4f10");
    check_field_offset(lv, s154c4f11, ABISELECT(176,120), "S154C4.s154c4f11");
    test_class_info(&lv, &cd_S154C4);
    dp->~S154C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS154C4(Test_S154C4, "S154C4", ABISELECT(184,124));

#else // __cplusplus

extern void _ZN6S154C4C1Ev();
extern void _ZN6S154C4D1Ev();
Name_Map name_map_S154C4[] = {
  NSPAIR(_ZN6S154C4C1Ev),
  NSPAIR(_ZN6S154C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S154C6;
extern VTBL_ENTRY _ZTI6S154C6[];
extern  VTBL_ENTRY _ZTV6S154C6[];
extern Class_Descriptor cd_S154C5;
extern VTBL_ENTRY _ZTI6S154C5[];
extern  VTBL_ENTRY _ZTV6S154C5[];
static Base_Class bases_S154C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S154C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S154C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S154C4[];
extern void _ZN6S154C4D1Ev();
extern void _ZN6S154C4D0Ev();
extern void _ZN6S154C63v15Ev();
extern void _ZN6S154C63v16Ev();
extern void _ZN6S154C63v17Ev();
extern void _ZN6S154C63v18Ev();
extern void _ZN6S154C63v19Ev();
extern void _ZN6S154C63v20Ev();
extern void _ZN6S154C63v21Ev();
extern void _ZN6S154C63v22Ev();
extern void _ZN6S154C63v23Ev();
extern void _ZN6S154C63v24Ev();
extern void _ZN6S154C63v25Ev();
extern void _ZN6S154C63v26Ev();
extern void _ZN6S154C63v27Ev();
extern void _ZN6S154C53v28Ev();
extern void _ZN6S154C53v29Ev();
extern void _ZN6S154C53v30Ev();
extern void _ZN6S154C53v31Ev();
extern void _ZN6S154C53v32Ev();
extern void _ZN6S154C53v33Ev();
extern void _ZN6S154C53v34Ev();
extern void _ZN6S154C53v35Ev();
extern void _ZN6S154C53v36Ev();
extern void _ZN6S154C53v37Ev();
extern void _ZN6S154C53v38Ev();
extern void _ZN6S154C43v39Ev();
extern void _ZN6S154C43v40Ev();
extern void _ZN6S154C43v41Ev();
extern void _ZN6S154C43v42Ev();
extern void _ZN6S154C43v43Ev();
extern void _ZN6S154C43v44Ev();
extern void _ZN6S154C43v45Ev();
extern void _ZN6S154C43v46Ev();
extern void _ZN6S154C43v47Ev();
extern void _ZN6S154C43v48Ev();
extern void _ZN6S154C43v49Ev();
extern void _ZN6S154C43v50Ev();
extern void _ZN6S154C43v51Ev();
extern void _ZN6S154C43v52Ev();
extern void _ZN6S154C43v53Ev();
extern void _ZN6S154C43v54Ev();
extern void _ZN6S154C43v55Ev();
static  VTBL_ENTRY vtc_S154C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S154C4[0]),
  (VTBL_ENTRY)&_ZN6S154C4D1Ev,
  (VTBL_ENTRY)&_ZN6S154C4D0Ev,
  (VTBL_ENTRY)&_ZN6S154C63v15Ev,
  (VTBL_ENTRY)&_ZN6S154C63v16Ev,
  (VTBL_ENTRY)&_ZN6S154C63v17Ev,
  (VTBL_ENTRY)&_ZN6S154C63v18Ev,
  (VTBL_ENTRY)&_ZN6S154C63v19Ev,
  (VTBL_ENTRY)&_ZN6S154C63v20Ev,
  (VTBL_ENTRY)&_ZN6S154C63v21Ev,
  (VTBL_ENTRY)&_ZN6S154C63v22Ev,
  (VTBL_ENTRY)&_ZN6S154C63v23Ev,
  (VTBL_ENTRY)&_ZN6S154C63v24Ev,
  (VTBL_ENTRY)&_ZN6S154C63v25Ev,
  (VTBL_ENTRY)&_ZN6S154C63v26Ev,
  (VTBL_ENTRY)&_ZN6S154C63v27Ev,
  (VTBL_ENTRY)&_ZN6S154C53v28Ev,
  (VTBL_ENTRY)&_ZN6S154C53v29Ev,
  (VTBL_ENTRY)&_ZN6S154C53v30Ev,
  (VTBL_ENTRY)&_ZN6S154C53v31Ev,
  (VTBL_ENTRY)&_ZN6S154C53v32Ev,
  (VTBL_ENTRY)&_ZN6S154C53v33Ev,
  (VTBL_ENTRY)&_ZN6S154C53v34Ev,
  (VTBL_ENTRY)&_ZN6S154C53v35Ev,
  (VTBL_ENTRY)&_ZN6S154C53v36Ev,
  (VTBL_ENTRY)&_ZN6S154C53v37Ev,
  (VTBL_ENTRY)&_ZN6S154C53v38Ev,
  (VTBL_ENTRY)&_ZN6S154C43v39Ev,
  (VTBL_ENTRY)&_ZN6S154C43v40Ev,
  (VTBL_ENTRY)&_ZN6S154C43v41Ev,
  (VTBL_ENTRY)&_ZN6S154C43v42Ev,
  (VTBL_ENTRY)&_ZN6S154C43v43Ev,
  (VTBL_ENTRY)&_ZN6S154C43v44Ev,
  (VTBL_ENTRY)&_ZN6S154C43v45Ev,
  (VTBL_ENTRY)&_ZN6S154C43v46Ev,
  (VTBL_ENTRY)&_ZN6S154C43v47Ev,
  (VTBL_ENTRY)&_ZN6S154C43v48Ev,
  (VTBL_ENTRY)&_ZN6S154C43v49Ev,
  (VTBL_ENTRY)&_ZN6S154C43v50Ev,
  (VTBL_ENTRY)&_ZN6S154C43v51Ev,
  (VTBL_ENTRY)&_ZN6S154C43v52Ev,
  (VTBL_ENTRY)&_ZN6S154C43v53Ev,
  (VTBL_ENTRY)&_ZN6S154C43v54Ev,
  (VTBL_ENTRY)&_ZN6S154C43v55Ev,
};
extern VTBL_ENTRY _ZTI6S154C4[];
extern  VTBL_ENTRY _ZTV6S154C4[];
Class_Descriptor cd_S154C4 = {  "S154C4", // class name
  bases_S154C4, 2,
  &(vtc_S154C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,124), // object size
  NSPAIRA(_ZTI6S154C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S154C4),45, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C3  : S154C4 {
  int s154c3f0[4];
  virtual  ~S154C3(); // _ZN6S154C3D1Ev
  virtual void  v56(); // _ZN6S154C33v56Ev
  virtual void  v57(); // _ZN6S154C33v57Ev
  virtual void  v58(); // _ZN6S154C33v58Ev
  virtual void  v59(); // _ZN6S154C33v59Ev
  virtual void  v60(); // _ZN6S154C33v60Ev
  virtual void  v61(); // _ZN6S154C33v61Ev
  virtual void  v62(); // _ZN6S154C33v62Ev
  virtual void  v63(); // _ZN6S154C33v63Ev
  virtual void  v64(); // _ZN6S154C33v64Ev
  virtual void  v65(); // _ZN6S154C33v65Ev
  virtual void  v66(); // _ZN6S154C33v66Ev
  virtual void  v67(); // _ZN6S154C33v67Ev
  virtual void  v68(); // _ZN6S154C33v68Ev
  S154C3(); // tgen
};
//SIG(-1 S154C3) C1{ BC2{ BC3{ BC4{ vd v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 Fp FC5{ m FC6{ m Fp Fi FC7{ m}} Fi} Fc Fi} vd v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 Fp[3] Fi} vd v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 Fp[2] Fi[3] FC5 Fc FC8{ m FC9{ m FL}} Fc Fi Fc Fi Fc[2] Fi Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 Fi[4]}


 S154C3 ::~S154C3(){ note_dtor("S154C3", this);}
void  S154C3 ::v56(){vfunc_called(this, "_ZN6S154C33v56Ev");}
void  S154C3 ::v57(){vfunc_called(this, "_ZN6S154C33v57Ev");}
void  S154C3 ::v58(){vfunc_called(this, "_ZN6S154C33v58Ev");}
void  S154C3 ::v59(){vfunc_called(this, "_ZN6S154C33v59Ev");}
void  S154C3 ::v60(){vfunc_called(this, "_ZN6S154C33v60Ev");}
void  S154C3 ::v61(){vfunc_called(this, "_ZN6S154C33v61Ev");}
void  S154C3 ::v62(){vfunc_called(this, "_ZN6S154C33v62Ev");}
void  S154C3 ::v63(){vfunc_called(this, "_ZN6S154C33v63Ev");}
void  S154C3 ::v64(){vfunc_called(this, "_ZN6S154C33v64Ev");}
void  S154C3 ::v65(){vfunc_called(this, "_ZN6S154C33v65Ev");}
void  S154C3 ::v66(){vfunc_called(this, "_ZN6S154C33v66Ev");}
void  S154C3 ::v67(){vfunc_called(this, "_ZN6S154C33v67Ev");}
void  S154C3 ::v68(){vfunc_called(this, "_ZN6S154C33v68Ev");}
S154C3 ::S154C3(){ note_ctor("S154C3", this);} // tgen

static void Test_S154C3()
{
  extern Class_Descriptor cd_S154C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,36)];
    init_test(&cd_S154C3, buf);
    S154C3 *dp, &lv = *(dp=new (buf) S154C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,140), "sizeof(S154C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C3)");
    check_base_class_offset(lv, (S154C6*)(S154C5*)(S154C4*), 0, "S154C3");
    check_base_class_offset(lv, (S154C5*)(S154C4*), 0, "S154C3");
    check_base_class_offset(lv, (S154C4*), 0, "S154C3");
    check_field_offset(lv, s154c3f0, ABISELECT(180,124), "S154C3.s154c3f0");
    test_class_info(&lv, &cd_S154C3);
    dp->~S154C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS154C3(Test_S154C3, "S154C3", ABISELECT(200,140));

#else // __cplusplus

extern void _ZN6S154C3C1Ev();
extern void _ZN6S154C3D1Ev();
Name_Map name_map_S154C3[] = {
  NSPAIR(_ZN6S154C3C1Ev),
  NSPAIR(_ZN6S154C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S154C6;
extern VTBL_ENTRY _ZTI6S154C6[];
extern  VTBL_ENTRY _ZTV6S154C6[];
extern Class_Descriptor cd_S154C5;
extern VTBL_ENTRY _ZTI6S154C5[];
extern  VTBL_ENTRY _ZTV6S154C5[];
extern Class_Descriptor cd_S154C4;
extern VTBL_ENTRY _ZTI6S154C4[];
extern  VTBL_ENTRY _ZTV6S154C4[];
static Base_Class bases_S154C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S154C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S154C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S154C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S154C3[];
extern void _ZN6S154C3D1Ev();
extern void _ZN6S154C3D0Ev();
extern void _ZN6S154C63v15Ev();
extern void _ZN6S154C63v16Ev();
extern void _ZN6S154C63v17Ev();
extern void _ZN6S154C63v18Ev();
extern void _ZN6S154C63v19Ev();
extern void _ZN6S154C63v20Ev();
extern void _ZN6S154C63v21Ev();
extern void _ZN6S154C63v22Ev();
extern void _ZN6S154C63v23Ev();
extern void _ZN6S154C63v24Ev();
extern void _ZN6S154C63v25Ev();
extern void _ZN6S154C63v26Ev();
extern void _ZN6S154C63v27Ev();
extern void _ZN6S154C53v28Ev();
extern void _ZN6S154C53v29Ev();
extern void _ZN6S154C53v30Ev();
extern void _ZN6S154C53v31Ev();
extern void _ZN6S154C53v32Ev();
extern void _ZN6S154C53v33Ev();
extern void _ZN6S154C53v34Ev();
extern void _ZN6S154C53v35Ev();
extern void _ZN6S154C53v36Ev();
extern void _ZN6S154C53v37Ev();
extern void _ZN6S154C53v38Ev();
extern void _ZN6S154C43v39Ev();
extern void _ZN6S154C43v40Ev();
extern void _ZN6S154C43v41Ev();
extern void _ZN6S154C43v42Ev();
extern void _ZN6S154C43v43Ev();
extern void _ZN6S154C43v44Ev();
extern void _ZN6S154C43v45Ev();
extern void _ZN6S154C43v46Ev();
extern void _ZN6S154C43v47Ev();
extern void _ZN6S154C43v48Ev();
extern void _ZN6S154C43v49Ev();
extern void _ZN6S154C43v50Ev();
extern void _ZN6S154C43v51Ev();
extern void _ZN6S154C43v52Ev();
extern void _ZN6S154C43v53Ev();
extern void _ZN6S154C43v54Ev();
extern void _ZN6S154C43v55Ev();
extern void _ZN6S154C33v56Ev();
extern void _ZN6S154C33v57Ev();
extern void _ZN6S154C33v58Ev();
extern void _ZN6S154C33v59Ev();
extern void _ZN6S154C33v60Ev();
extern void _ZN6S154C33v61Ev();
extern void _ZN6S154C33v62Ev();
extern void _ZN6S154C33v63Ev();
extern void _ZN6S154C33v64Ev();
extern void _ZN6S154C33v65Ev();
extern void _ZN6S154C33v66Ev();
extern void _ZN6S154C33v67Ev();
extern void _ZN6S154C33v68Ev();
static  VTBL_ENTRY vtc_S154C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S154C3[0]),
  (VTBL_ENTRY)&_ZN6S154C3D1Ev,
  (VTBL_ENTRY)&_ZN6S154C3D0Ev,
  (VTBL_ENTRY)&_ZN6S154C63v15Ev,
  (VTBL_ENTRY)&_ZN6S154C63v16Ev,
  (VTBL_ENTRY)&_ZN6S154C63v17Ev,
  (VTBL_ENTRY)&_ZN6S154C63v18Ev,
  (VTBL_ENTRY)&_ZN6S154C63v19Ev,
  (VTBL_ENTRY)&_ZN6S154C63v20Ev,
  (VTBL_ENTRY)&_ZN6S154C63v21Ev,
  (VTBL_ENTRY)&_ZN6S154C63v22Ev,
  (VTBL_ENTRY)&_ZN6S154C63v23Ev,
  (VTBL_ENTRY)&_ZN6S154C63v24Ev,
  (VTBL_ENTRY)&_ZN6S154C63v25Ev,
  (VTBL_ENTRY)&_ZN6S154C63v26Ev,
  (VTBL_ENTRY)&_ZN6S154C63v27Ev,
  (VTBL_ENTRY)&_ZN6S154C53v28Ev,
  (VTBL_ENTRY)&_ZN6S154C53v29Ev,
  (VTBL_ENTRY)&_ZN6S154C53v30Ev,
  (VTBL_ENTRY)&_ZN6S154C53v31Ev,
  (VTBL_ENTRY)&_ZN6S154C53v32Ev,
  (VTBL_ENTRY)&_ZN6S154C53v33Ev,
  (VTBL_ENTRY)&_ZN6S154C53v34Ev,
  (VTBL_ENTRY)&_ZN6S154C53v35Ev,
  (VTBL_ENTRY)&_ZN6S154C53v36Ev,
  (VTBL_ENTRY)&_ZN6S154C53v37Ev,
  (VTBL_ENTRY)&_ZN6S154C53v38Ev,
  (VTBL_ENTRY)&_ZN6S154C43v39Ev,
  (VTBL_ENTRY)&_ZN6S154C43v40Ev,
  (VTBL_ENTRY)&_ZN6S154C43v41Ev,
  (VTBL_ENTRY)&_ZN6S154C43v42Ev,
  (VTBL_ENTRY)&_ZN6S154C43v43Ev,
  (VTBL_ENTRY)&_ZN6S154C43v44Ev,
  (VTBL_ENTRY)&_ZN6S154C43v45Ev,
  (VTBL_ENTRY)&_ZN6S154C43v46Ev,
  (VTBL_ENTRY)&_ZN6S154C43v47Ev,
  (VTBL_ENTRY)&_ZN6S154C43v48Ev,
  (VTBL_ENTRY)&_ZN6S154C43v49Ev,
  (VTBL_ENTRY)&_ZN6S154C43v50Ev,
  (VTBL_ENTRY)&_ZN6S154C43v51Ev,
  (VTBL_ENTRY)&_ZN6S154C43v52Ev,
  (VTBL_ENTRY)&_ZN6S154C43v53Ev,
  (VTBL_ENTRY)&_ZN6S154C43v54Ev,
  (VTBL_ENTRY)&_ZN6S154C43v55Ev,
  (VTBL_ENTRY)&_ZN6S154C33v56Ev,
  (VTBL_ENTRY)&_ZN6S154C33v57Ev,
  (VTBL_ENTRY)&_ZN6S154C33v58Ev,
  (VTBL_ENTRY)&_ZN6S154C33v59Ev,
  (VTBL_ENTRY)&_ZN6S154C33v60Ev,
  (VTBL_ENTRY)&_ZN6S154C33v61Ev,
  (VTBL_ENTRY)&_ZN6S154C33v62Ev,
  (VTBL_ENTRY)&_ZN6S154C33v63Ev,
  (VTBL_ENTRY)&_ZN6S154C33v64Ev,
  (VTBL_ENTRY)&_ZN6S154C33v65Ev,
  (VTBL_ENTRY)&_ZN6S154C33v66Ev,
  (VTBL_ENTRY)&_ZN6S154C33v67Ev,
  (VTBL_ENTRY)&_ZN6S154C33v68Ev,
};
extern VTBL_ENTRY _ZTI6S154C3[];
extern  VTBL_ENTRY _ZTV6S154C3[];
Class_Descriptor cd_S154C3 = {  "S154C3", // class name
  bases_S154C3, 3,
  &(vtc_S154C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,140), // object size
  NSPAIRA(_ZTI6S154C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S154C3),58, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C12  {
  int s154c12f0;
  void *s154c12f1;
  int s154c12f2;
  void  mf154c12(); // _ZN7S154C128mf154c12Ev
};
//SIG(-1 S154C12) C1{ m Fi Fp Fi}


void  S154C12 ::mf154c12(){}

static void Test_S154C12()
{
  {
    init_simple_test("S154C12");
    S154C12 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S154C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C12)");
    check_field_offset(lv, s154c12f0, 0, "S154C12.s154c12f0");
    check_field_offset(lv, s154c12f1, ABISELECT(8,4), "S154C12.s154c12f1");
    check_field_offset(lv, s154c12f2, ABISELECT(16,8), "S154C12.s154c12f2");
  }
}
static Arrange_To_Call_Me vS154C12(Test_S154C12, "S154C12", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C2  : S154C3 {
  void *s154c2f0;
  char s154c2f1;
  int s154c2f2;
  char s154c2f3[3];
  int s154c2f4;
  ::S154C12 s154c2f5;
  int s154c2f6[2];
  virtual  ~S154C2(); // _ZN6S154C2D1Ev
  virtual void  v69(); // _ZN6S154C23v69Ev
  virtual void  v70(); // _ZN6S154C23v70Ev
  virtual void  v71(); // _ZN6S154C23v71Ev
  virtual void  v72(); // _ZN6S154C23v72Ev
  virtual void  v73(); // _ZN6S154C23v73Ev
  virtual void  v74(); // _ZN6S154C23v74Ev
  virtual void  v75(); // _ZN6S154C23v75Ev
  virtual void  v76(); // _ZN6S154C23v76Ev
  virtual void  v77(); // _ZN6S154C23v77Ev
  virtual void  v78(); // _ZN6S154C23v78Ev
  S154C2(); // tgen
};
//SIG(-1 S154C2) C1{ BC2{ BC3{ BC4{ BC5{ vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} Fc Fi} vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 Fp[3] Fi} vd v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 Fp[2] Fi[3] FC6 Fc FC9{ m FC10{ m FL}} Fc Fi Fc Fi Fc[2] Fi Fc} vd v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi[4]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp Fc Fi Fc[3] Fi FC11{ m Fi Fp Fi} Fi[2]}


 S154C2 ::~S154C2(){ note_dtor("S154C2", this);}
void  S154C2 ::v69(){vfunc_called(this, "_ZN6S154C23v69Ev");}
void  S154C2 ::v70(){vfunc_called(this, "_ZN6S154C23v70Ev");}
void  S154C2 ::v71(){vfunc_called(this, "_ZN6S154C23v71Ev");}
void  S154C2 ::v72(){vfunc_called(this, "_ZN6S154C23v72Ev");}
void  S154C2 ::v73(){vfunc_called(this, "_ZN6S154C23v73Ev");}
void  S154C2 ::v74(){vfunc_called(this, "_ZN6S154C23v74Ev");}
void  S154C2 ::v75(){vfunc_called(this, "_ZN6S154C23v75Ev");}
void  S154C2 ::v76(){vfunc_called(this, "_ZN6S154C23v76Ev");}
void  S154C2 ::v77(){vfunc_called(this, "_ZN6S154C23v77Ev");}
void  S154C2 ::v78(){vfunc_called(this, "_ZN6S154C23v78Ev");}
S154C2 ::S154C2(){ note_ctor("S154C2", this);} // tgen

static void Test_S154C2()
{
  extern Class_Descriptor cd_S154C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,46)];
    init_test(&cd_S154C2, buf);
    S154C2 *dp, &lv = *(dp=new (buf) S154C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,180), "sizeof(S154C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C2)");
    check_base_class_offset(lv, (S154C6*)(S154C5*)(S154C4*)(S154C3*), 0, "S154C2");
    check_base_class_offset(lv, (S154C5*)(S154C4*)(S154C3*), 0, "S154C2");
    check_base_class_offset(lv, (S154C4*)(S154C3*), 0, "S154C2");
    check_base_class_offset(lv, (S154C3*), 0, "S154C2");
    check_field_offset(lv, s154c2f0, ABISELECT(200,140), "S154C2.s154c2f0");
    check_field_offset(lv, s154c2f1, ABISELECT(208,144), "S154C2.s154c2f1");
    check_field_offset(lv, s154c2f2, ABISELECT(212,148), "S154C2.s154c2f2");
    check_field_offset(lv, s154c2f3, ABISELECT(216,152), "S154C2.s154c2f3");
    check_field_offset(lv, s154c2f4, ABISELECT(220,156), "S154C2.s154c2f4");
    check_field_offset(lv, s154c2f5, ABISELECT(224,160), "S154C2.s154c2f5");
    check_field_offset(lv, s154c2f6, ABISELECT(248,172), "S154C2.s154c2f6");
    test_class_info(&lv, &cd_S154C2);
    dp->~S154C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS154C2(Test_S154C2, "S154C2", ABISELECT(256,180));

#else // __cplusplus

extern void _ZN6S154C2C1Ev();
extern void _ZN6S154C2D1Ev();
Name_Map name_map_S154C2[] = {
  NSPAIR(_ZN6S154C2C1Ev),
  NSPAIR(_ZN6S154C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S154C6;
extern VTBL_ENTRY _ZTI6S154C6[];
extern  VTBL_ENTRY _ZTV6S154C6[];
extern Class_Descriptor cd_S154C5;
extern VTBL_ENTRY _ZTI6S154C5[];
extern  VTBL_ENTRY _ZTV6S154C5[];
extern Class_Descriptor cd_S154C4;
extern VTBL_ENTRY _ZTI6S154C4[];
extern  VTBL_ENTRY _ZTV6S154C4[];
extern Class_Descriptor cd_S154C3;
extern VTBL_ENTRY _ZTI6S154C3[];
extern  VTBL_ENTRY _ZTV6S154C3[];
static Base_Class bases_S154C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S154C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S154C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S154C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S154C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S154C2[];
extern void _ZN6S154C2D1Ev();
extern void _ZN6S154C2D0Ev();
extern void _ZN6S154C63v15Ev();
extern void _ZN6S154C63v16Ev();
extern void _ZN6S154C63v17Ev();
extern void _ZN6S154C63v18Ev();
extern void _ZN6S154C63v19Ev();
extern void _ZN6S154C63v20Ev();
extern void _ZN6S154C63v21Ev();
extern void _ZN6S154C63v22Ev();
extern void _ZN6S154C63v23Ev();
extern void _ZN6S154C63v24Ev();
extern void _ZN6S154C63v25Ev();
extern void _ZN6S154C63v26Ev();
extern void _ZN6S154C63v27Ev();
extern void _ZN6S154C53v28Ev();
extern void _ZN6S154C53v29Ev();
extern void _ZN6S154C53v30Ev();
extern void _ZN6S154C53v31Ev();
extern void _ZN6S154C53v32Ev();
extern void _ZN6S154C53v33Ev();
extern void _ZN6S154C53v34Ev();
extern void _ZN6S154C53v35Ev();
extern void _ZN6S154C53v36Ev();
extern void _ZN6S154C53v37Ev();
extern void _ZN6S154C53v38Ev();
extern void _ZN6S154C43v39Ev();
extern void _ZN6S154C43v40Ev();
extern void _ZN6S154C43v41Ev();
extern void _ZN6S154C43v42Ev();
extern void _ZN6S154C43v43Ev();
extern void _ZN6S154C43v44Ev();
extern void _ZN6S154C43v45Ev();
extern void _ZN6S154C43v46Ev();
extern void _ZN6S154C43v47Ev();
extern void _ZN6S154C43v48Ev();
extern void _ZN6S154C43v49Ev();
extern void _ZN6S154C43v50Ev();
extern void _ZN6S154C43v51Ev();
extern void _ZN6S154C43v52Ev();
extern void _ZN6S154C43v53Ev();
extern void _ZN6S154C43v54Ev();
extern void _ZN6S154C43v55Ev();
extern void _ZN6S154C33v56Ev();
extern void _ZN6S154C33v57Ev();
extern void _ZN6S154C33v58Ev();
extern void _ZN6S154C33v59Ev();
extern void _ZN6S154C33v60Ev();
extern void _ZN6S154C33v61Ev();
extern void _ZN6S154C33v62Ev();
extern void _ZN6S154C33v63Ev();
extern void _ZN6S154C33v64Ev();
extern void _ZN6S154C33v65Ev();
extern void _ZN6S154C33v66Ev();
extern void _ZN6S154C33v67Ev();
extern void _ZN6S154C33v68Ev();
extern void _ZN6S154C23v69Ev();
extern void _ZN6S154C23v70Ev();
extern void _ZN6S154C23v71Ev();
extern void _ZN6S154C23v72Ev();
extern void _ZN6S154C23v73Ev();
extern void _ZN6S154C23v74Ev();
extern void _ZN6S154C23v75Ev();
extern void _ZN6S154C23v76Ev();
extern void _ZN6S154C23v77Ev();
extern void _ZN6S154C23v78Ev();
static  VTBL_ENTRY vtc_S154C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S154C2[0]),
  (VTBL_ENTRY)&_ZN6S154C2D1Ev,
  (VTBL_ENTRY)&_ZN6S154C2D0Ev,
  (VTBL_ENTRY)&_ZN6S154C63v15Ev,
  (VTBL_ENTRY)&_ZN6S154C63v16Ev,
  (VTBL_ENTRY)&_ZN6S154C63v17Ev,
  (VTBL_ENTRY)&_ZN6S154C63v18Ev,
  (VTBL_ENTRY)&_ZN6S154C63v19Ev,
  (VTBL_ENTRY)&_ZN6S154C63v20Ev,
  (VTBL_ENTRY)&_ZN6S154C63v21Ev,
  (VTBL_ENTRY)&_ZN6S154C63v22Ev,
  (VTBL_ENTRY)&_ZN6S154C63v23Ev,
  (VTBL_ENTRY)&_ZN6S154C63v24Ev,
  (VTBL_ENTRY)&_ZN6S154C63v25Ev,
  (VTBL_ENTRY)&_ZN6S154C63v26Ev,
  (VTBL_ENTRY)&_ZN6S154C63v27Ev,
  (VTBL_ENTRY)&_ZN6S154C53v28Ev,
  (VTBL_ENTRY)&_ZN6S154C53v29Ev,
  (VTBL_ENTRY)&_ZN6S154C53v30Ev,
  (VTBL_ENTRY)&_ZN6S154C53v31Ev,
  (VTBL_ENTRY)&_ZN6S154C53v32Ev,
  (VTBL_ENTRY)&_ZN6S154C53v33Ev,
  (VTBL_ENTRY)&_ZN6S154C53v34Ev,
  (VTBL_ENTRY)&_ZN6S154C53v35Ev,
  (VTBL_ENTRY)&_ZN6S154C53v36Ev,
  (VTBL_ENTRY)&_ZN6S154C53v37Ev,
  (VTBL_ENTRY)&_ZN6S154C53v38Ev,
  (VTBL_ENTRY)&_ZN6S154C43v39Ev,
  (VTBL_ENTRY)&_ZN6S154C43v40Ev,
  (VTBL_ENTRY)&_ZN6S154C43v41Ev,
  (VTBL_ENTRY)&_ZN6S154C43v42Ev,
  (VTBL_ENTRY)&_ZN6S154C43v43Ev,
  (VTBL_ENTRY)&_ZN6S154C43v44Ev,
  (VTBL_ENTRY)&_ZN6S154C43v45Ev,
  (VTBL_ENTRY)&_ZN6S154C43v46Ev,
  (VTBL_ENTRY)&_ZN6S154C43v47Ev,
  (VTBL_ENTRY)&_ZN6S154C43v48Ev,
  (VTBL_ENTRY)&_ZN6S154C43v49Ev,
  (VTBL_ENTRY)&_ZN6S154C43v50Ev,
  (VTBL_ENTRY)&_ZN6S154C43v51Ev,
  (VTBL_ENTRY)&_ZN6S154C43v52Ev,
  (VTBL_ENTRY)&_ZN6S154C43v53Ev,
  (VTBL_ENTRY)&_ZN6S154C43v54Ev,
  (VTBL_ENTRY)&_ZN6S154C43v55Ev,
  (VTBL_ENTRY)&_ZN6S154C33v56Ev,
  (VTBL_ENTRY)&_ZN6S154C33v57Ev,
  (VTBL_ENTRY)&_ZN6S154C33v58Ev,
  (VTBL_ENTRY)&_ZN6S154C33v59Ev,
  (VTBL_ENTRY)&_ZN6S154C33v60Ev,
  (VTBL_ENTRY)&_ZN6S154C33v61Ev,
  (VTBL_ENTRY)&_ZN6S154C33v62Ev,
  (VTBL_ENTRY)&_ZN6S154C33v63Ev,
  (VTBL_ENTRY)&_ZN6S154C33v64Ev,
  (VTBL_ENTRY)&_ZN6S154C33v65Ev,
  (VTBL_ENTRY)&_ZN6S154C33v66Ev,
  (VTBL_ENTRY)&_ZN6S154C33v67Ev,
  (VTBL_ENTRY)&_ZN6S154C33v68Ev,
  (VTBL_ENTRY)&_ZN6S154C23v69Ev,
  (VTBL_ENTRY)&_ZN6S154C23v70Ev,
  (VTBL_ENTRY)&_ZN6S154C23v71Ev,
  (VTBL_ENTRY)&_ZN6S154C23v72Ev,
  (VTBL_ENTRY)&_ZN6S154C23v73Ev,
  (VTBL_ENTRY)&_ZN6S154C23v74Ev,
  (VTBL_ENTRY)&_ZN6S154C23v75Ev,
  (VTBL_ENTRY)&_ZN6S154C23v76Ev,
  (VTBL_ENTRY)&_ZN6S154C23v77Ev,
  (VTBL_ENTRY)&_ZN6S154C23v78Ev,
};
extern VTBL_ENTRY _ZTI6S154C2[];
extern  VTBL_ENTRY _ZTV6S154C2[];
Class_Descriptor cd_S154C2 = {  "S154C2", // class name
  bases_S154C2, 4,
  &(vtc_S154C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,180), // object size
  NSPAIRA(_ZTI6S154C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S154C2),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C15  {
  int s154c15f0[2];
  char s154c15f1[17];
  int s154c15f2;
  void *s154c15f3;
};
//SIG(-1 S154C15) C1{ Fi[2] Fc[17] Fi Fp}



static void Test_S154C15()
{
  {
    init_simple_test("S154C15");
    S154C15 lv;
    check2(sizeof(lv), ABISELECT(40,36), "sizeof(S154C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C15)");
    check_field_offset(lv, s154c15f0, 0, "S154C15.s154c15f0");
    check_field_offset(lv, s154c15f1, 8, "S154C15.s154c15f1");
    check_field_offset(lv, s154c15f2, 28, "S154C15.s154c15f2");
    check_field_offset(lv, s154c15f3, 32, "S154C15.s154c15f3");
  }
}
static Arrange_To_Call_Me vS154C15(Test_S154C15, "S154C15", ABISELECT(40,36));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C14  {
  int s154c14f0[3];
  char s154c14f1[193];
  int s154c14f2;
  char s154c14f3[33];
  __tsi64 s154c14f4[2];
  int s154c14f5;
  ::S154C15 s154c14f6;
  int s154c14f7[2];
  char s154c14f8[66];
};
//SIG(-1 S154C14) C1{ Fi[3] Fc[193] Fi Fc[33] FL[2] Fi FC2{ Fi[2] Fc[17] Fi Fp} Fi[2] Fc[66]}



static void Test_S154C14()
{
  {
    init_simple_test("S154C14");
    S154C14 lv;
    check2(sizeof(lv), ABISELECT(392,380), "sizeof(S154C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C14)");
    check_field_offset(lv, s154c14f0, 0, "S154C14.s154c14f0");
    check_field_offset(lv, s154c14f1, 12, "S154C14.s154c14f1");
    check_field_offset(lv, s154c14f2, 208, "S154C14.s154c14f2");
    check_field_offset(lv, s154c14f3, 212, "S154C14.s154c14f3");
    check_field_offset(lv, s154c14f4, 248, "S154C14.s154c14f4");
    check_field_offset(lv, s154c14f5, 264, "S154C14.s154c14f5");
    check_field_offset(lv, s154c14f6, ABISELECT(272,268), "S154C14.s154c14f6");
    check_field_offset(lv, s154c14f7, ABISELECT(312,304), "S154C14.s154c14f7");
    check_field_offset(lv, s154c14f8, ABISELECT(320,312), "S154C14.s154c14f8");
  }
}
static Arrange_To_Call_Me vS154C14(Test_S154C14, "S154C14", ABISELECT(392,380));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C17  {
  __tsi64 s154c17f0;
  void *s154c17f1;
  int s154c17f2;
  virtual  ~S154C17(); // _ZN7S154C17D1Ev
  virtual void  v81(); // _ZN7S154C173v81Ev
  virtual void  v82(); // _ZN7S154C173v82Ev
  virtual void  v83(); // _ZN7S154C173v83Ev
  S154C17(); // tgen
};
//SIG(-1 S154C17) C1{ vd v1 v2 v3 FL Fp Fi}


 S154C17 ::~S154C17(){ note_dtor("S154C17", this);}
void  S154C17 ::v81(){vfunc_called(this, "_ZN7S154C173v81Ev");}
void  S154C17 ::v82(){vfunc_called(this, "_ZN7S154C173v82Ev");}
void  S154C17 ::v83(){vfunc_called(this, "_ZN7S154C173v83Ev");}
S154C17 ::S154C17(){ note_ctor("S154C17", this);} // tgen

static void Test_S154C17()
{
  extern Class_Descriptor cd_S154C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(5,6)];
    init_test(&cd_S154C17, buf);
    S154C17 *dp, &lv = *(dp=new (buf) S154C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S154C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C17)");
    check_field_offset(lv, s154c17f0, ABISELECT(8,4), "S154C17.s154c17f0");
    check_field_offset(lv, s154c17f1, ABISELECT(16,12), "S154C17.s154c17f1");
    check_field_offset(lv, s154c17f2, ABISELECT(24,16), "S154C17.s154c17f2");
    test_class_info(&lv, &cd_S154C17);
    dp->~S154C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS154C17(Test_S154C17, "S154C17", ABISELECT(32,20));

#else // __cplusplus

extern void _ZN7S154C17C1Ev();
extern void _ZN7S154C17D1Ev();
Name_Map name_map_S154C17[] = {
  NSPAIR(_ZN7S154C17C1Ev),
  NSPAIR(_ZN7S154C17D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S154C17[];
extern void _ZN7S154C17D1Ev();
extern void _ZN7S154C17D0Ev();
extern void _ZN7S154C173v81Ev();
extern void _ZN7S154C173v82Ev();
extern void _ZN7S154C173v83Ev();
static  VTBL_ENTRY vtc_S154C17[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S154C17[0]),
  (VTBL_ENTRY)&_ZN7S154C17D1Ev,
  (VTBL_ENTRY)&_ZN7S154C17D0Ev,
  (VTBL_ENTRY)&_ZN7S154C173v81Ev,
  (VTBL_ENTRY)&_ZN7S154C173v82Ev,
  (VTBL_ENTRY)&_ZN7S154C173v83Ev,
};
extern VTBL_ENTRY _ZTI7S154C17[];
extern  VTBL_ENTRY _ZTV7S154C17[];
Class_Descriptor cd_S154C17 = {  "S154C17", // class name
  0,0,//no base classes
  &(vtc_S154C17[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(32,20), // object size
  NSPAIRA(_ZTI7S154C17),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S154C17),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C16  : S154C17 {
  int s154c16f0;
  char s154c16f1;
  virtual  ~S154C16(); // _ZN7S154C16D1Ev
  virtual void  v79(); // _ZN7S154C163v79Ev
  virtual void  v80(); // _ZN7S154C163v80Ev
  S154C16(); // tgen
};
//SIG(-1 S154C16) C1{ BC2{ vd v3 v4 v5 FL Fp Fi} vd v1 v2 Fi Fc}


 S154C16 ::~S154C16(){ note_dtor("S154C16", this);}
void  S154C16 ::v79(){vfunc_called(this, "_ZN7S154C163v79Ev");}
void  S154C16 ::v80(){vfunc_called(this, "_ZN7S154C163v80Ev");}
S154C16 ::S154C16(){ note_ctor("S154C16", this);} // tgen

static void Test_S154C16()
{
  extern Class_Descriptor cd_S154C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,8)];
    init_test(&cd_S154C16, buf);
    S154C16 *dp, &lv = *(dp=new (buf) S154C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,28), "sizeof(S154C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C16)");
    check_base_class_offset(lv, (S154C17*), 0, "S154C16");
    check_field_offset(lv, s154c16f0, ABISELECT(28,20), "S154C16.s154c16f0");
    check_field_offset(lv, s154c16f1, ABISELECT(32,24), "S154C16.s154c16f1");
    test_class_info(&lv, &cd_S154C16);
    dp->~S154C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS154C16(Test_S154C16, "S154C16", ABISELECT(40,28));

#else // __cplusplus

extern void _ZN7S154C16C1Ev();
extern void _ZN7S154C16D1Ev();
Name_Map name_map_S154C16[] = {
  NSPAIR(_ZN7S154C16C1Ev),
  NSPAIR(_ZN7S154C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S154C17;
extern VTBL_ENTRY _ZTI7S154C17[];
extern  VTBL_ENTRY _ZTV7S154C17[];
static Base_Class bases_S154C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S154C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S154C16[];
extern void _ZN7S154C16D1Ev();
extern void _ZN7S154C16D0Ev();
extern void _ZN7S154C173v81Ev();
extern void _ZN7S154C173v82Ev();
extern void _ZN7S154C173v83Ev();
extern void _ZN7S154C163v79Ev();
extern void _ZN7S154C163v80Ev();
static  VTBL_ENTRY vtc_S154C16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S154C16[0]),
  (VTBL_ENTRY)&_ZN7S154C16D1Ev,
  (VTBL_ENTRY)&_ZN7S154C16D0Ev,
  (VTBL_ENTRY)&_ZN7S154C173v81Ev,
  (VTBL_ENTRY)&_ZN7S154C173v82Ev,
  (VTBL_ENTRY)&_ZN7S154C173v83Ev,
  (VTBL_ENTRY)&_ZN7S154C163v79Ev,
  (VTBL_ENTRY)&_ZN7S154C163v80Ev,
};
extern VTBL_ENTRY _ZTI7S154C16[];
extern  VTBL_ENTRY _ZTV7S154C16[];
Class_Descriptor cd_S154C16 = {  "S154C16", // class name
  bases_S154C16, 1,
  &(vtc_S154C16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,28), // object size
  NSPAIRA(_ZTI7S154C16),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S154C16),9, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C27_nt  {
  ::S1587C38 s154c27f0;
  void  mf154c27(); // _ZN10S154C27_nt8mf154c27Ev
};
//SIG(-1 S154C27_nt) C1{ m FC2{ m Fp[2]}}


void  S154C27_nt ::mf154c27(){}

//skip512 S154C27_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C33  {
  void *s154c33f0[3];
  int s154c33f1[3];
  char s154c33f2[3];
  int s154c33f3[8];
  char s154c33f4[2];
  void *s154c33f5[6];
  int s154c33f6[3];
  virtual  ~S154C33(); // _ZN7S154C33D1Ev
  virtual void  v89(); // _ZN7S154C333v89Ev
  virtual void  v90(); // _ZN7S154C333v90Ev
  virtual void  v91(); // _ZN7S154C333v91Ev
  virtual void  v92(); // _ZN7S154C333v92Ev
  virtual void  v93(); // _ZN7S154C333v93Ev
  virtual void  v94(); // _ZN7S154C333v94Ev
  virtual void  v95(); // _ZN7S154C333v95Ev
  S154C33(); // tgen
};
//SIG(-1 S154C33) C1{ vd v1 v2 v3 v4 v5 v6 v7 Fp[3] Fi[3] Fc[3] Fi[8] Fc[2] Fp[6] Fi[3]}


 S154C33 ::~S154C33(){ note_dtor("S154C33", this);}
void  S154C33 ::v89(){vfunc_called(this, "_ZN7S154C333v89Ev");}
void  S154C33 ::v90(){vfunc_called(this, "_ZN7S154C333v90Ev");}
void  S154C33 ::v91(){vfunc_called(this, "_ZN7S154C333v91Ev");}
void  S154C33 ::v92(){vfunc_called(this, "_ZN7S154C333v92Ev");}
void  S154C33 ::v93(){vfunc_called(this, "_ZN7S154C333v93Ev");}
void  S154C33 ::v94(){vfunc_called(this, "_ZN7S154C333v94Ev");}
void  S154C33 ::v95(){vfunc_called(this, "_ZN7S154C333v95Ev");}
S154C33 ::S154C33(){ note_ctor("S154C33", this);} // tgen

static void Test_S154C33()
{
  extern Class_Descriptor cd_S154C33;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(20,27)];
    init_test(&cd_S154C33, buf);
    S154C33 *dp, &lv = *(dp=new (buf) S154C33());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(152,104), "sizeof(S154C33)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C33)");
    check_field_offset(lv, s154c33f0, ABISELECT(8,4), "S154C33.s154c33f0");
    check_field_offset(lv, s154c33f1, ABISELECT(32,16), "S154C33.s154c33f1");
    check_field_offset(lv, s154c33f2, ABISELECT(44,28), "S154C33.s154c33f2");
    check_field_offset(lv, s154c33f3, ABISELECT(48,32), "S154C33.s154c33f3");
    check_field_offset(lv, s154c33f4, ABISELECT(80,64), "S154C33.s154c33f4");
    check_field_offset(lv, s154c33f5, ABISELECT(88,68), "S154C33.s154c33f5");
    check_field_offset(lv, s154c33f6, ABISELECT(136,92), "S154C33.s154c33f6");
    test_class_info(&lv, &cd_S154C33);
    dp->~S154C33();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS154C33(Test_S154C33, "S154C33", ABISELECT(152,104));

#else // __cplusplus

extern void _ZN7S154C33C1Ev();
extern void _ZN7S154C33D1Ev();
Name_Map name_map_S154C33[] = {
  NSPAIR(_ZN7S154C33C1Ev),
  NSPAIR(_ZN7S154C33D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S154C33[];
extern void _ZN7S154C33D1Ev();
extern void _ZN7S154C33D0Ev();
extern void _ZN7S154C333v89Ev();
extern void _ZN7S154C333v90Ev();
extern void _ZN7S154C333v91Ev();
extern void _ZN7S154C333v92Ev();
extern void _ZN7S154C333v93Ev();
extern void _ZN7S154C333v94Ev();
extern void _ZN7S154C333v95Ev();
static  VTBL_ENTRY vtc_S154C33[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S154C33[0]),
  (VTBL_ENTRY)&_ZN7S154C33D1Ev,
  (VTBL_ENTRY)&_ZN7S154C33D0Ev,
  (VTBL_ENTRY)&_ZN7S154C333v89Ev,
  (VTBL_ENTRY)&_ZN7S154C333v90Ev,
  (VTBL_ENTRY)&_ZN7S154C333v91Ev,
  (VTBL_ENTRY)&_ZN7S154C333v92Ev,
  (VTBL_ENTRY)&_ZN7S154C333v93Ev,
  (VTBL_ENTRY)&_ZN7S154C333v94Ev,
  (VTBL_ENTRY)&_ZN7S154C333v95Ev,
};
extern VTBL_ENTRY _ZTI7S154C33[];
extern  VTBL_ENTRY _ZTV7S154C33[];
Class_Descriptor cd_S154C33 = {  "S154C33", // class name
  0,0,//no base classes
  &(vtc_S154C33[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(152,104), // object size
  NSPAIRA(_ZTI7S154C33),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S154C33),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C34  {
  char s154c34f0[65];
  ::S1587C29 s154c34f1;
  int s154c34f2[2];
  __tsi64 s154c34f3;
  int s154c34f4;
};
//SIG(-1 S154C34) C1{ Fc[65] FC2{ FC3{ Fc[20]} Fc[16]} Fi[2] FL Fi}



static void Test_S154C34()
{
  {
    init_simple_test("S154C34");
    S154C34 lv;
    check2(sizeof(lv), ABISELECT(128,124), "sizeof(S154C34)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C34)");
    check_field_offset(lv, s154c34f0, 0, "S154C34.s154c34f0");
    check_field_offset(lv, s154c34f1, 65, "S154C34.s154c34f1");
    check_field_offset(lv, s154c34f2, 104, "S154C34.s154c34f2");
    check_field_offset(lv, s154c34f3, 112, "S154C34.s154c34f3");
    check_field_offset(lv, s154c34f4, 120, "S154C34.s154c34f4");
  }
}
static Arrange_To_Call_Me vS154C34(Test_S154C34, "S154C34", ABISELECT(128,124));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C35  {
  int s154c35f0;
  char s154c35f1[815];
  int s154c35f2[5];
};
//SIG(-1 S154C35) C1{ Fi Fc[815] Fi[5]}



static void Test_S154C35()
{
  {
    init_simple_test("S154C35");
    S154C35 lv;
    check2(sizeof(lv), 840, "sizeof(S154C35)");
    check2(__alignof__(lv), 4, "__alignof__(S154C35)");
    check_field_offset(lv, s154c35f0, 0, "S154C35.s154c35f0");
    check_field_offset(lv, s154c35f1, 4, "S154C35.s154c35f1");
    check_field_offset(lv, s154c35f2, 820, "S154C35.s154c35f2");
  }
}
static Arrange_To_Call_Me vS154C35(Test_S154C35, "S154C35", 840);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C37  {
  char s154c37f0[33];
  int s154c37f1;
  char s154c37f2;
  ::S1587C6_nt s154c37f3;
  int s154c37f4;
  char s154c37f5;
};
//SIG(1 S154C37) C1{ Fc[33] Fi Fc FC2{ m Fp Fi FC3{ m}} Fi Fc}



static void Test_S154C37()
{
  {
    init_simple_test("S154C37");
    S154C37 lv;
    check2(sizeof(lv), ABISELECT(72,64), "sizeof(S154C37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C37)");
    check_field_offset(lv, s154c37f0, 0, "S154C37.s154c37f0");
    check_field_offset(lv, s154c37f1, 36, "S154C37.s154c37f1");
    check_field_offset(lv, s154c37f2, 40, "S154C37.s154c37f2");
    check_field_offset(lv, s154c37f3, ABISELECT(48,44), "S154C37.s154c37f3");
    check_field_offset(lv, s154c37f4, ABISELECT(64,56), "S154C37.s154c37f4");
    check_field_offset(lv, s154c37f5, ABISELECT(68,60), "S154C37.s154c37f5");
  }
}
static Arrange_To_Call_Me vS154C37(Test_S154C37, "S154C37", ABISELECT(72,64));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C36  {
  int s154c36f0;
  ::S154C37 s154c36f1[5];
};
//SIG(-1 S154C36) C1{ Fi FC2{ Fc[33] Fi Fc FC3{ m Fp Fi FC4{ m}} Fi Fc}[5]}



static void Test_S154C36()
{
  {
    init_simple_test("S154C36");
    S154C36 lv;
    check2(sizeof(lv), ABISELECT(368,324), "sizeof(S154C36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C36)");
    check_field_offset(lv, s154c36f0, 0, "S154C36.s154c36f0");
    check_field_offset(lv, s154c36f1, ABISELECT(8,4), "S154C36.s154c36f1");
  }
}
static Arrange_To_Call_Me vS154C36(Test_S154C36, "S154C36", ABISELECT(368,324));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C38  {
  void *s154c38f0[2];
  int s154c38f1[2];
  __tsi64 s154c38f2;
  char s154c38f3[193];
};
//SIG(-1 S154C38) C1{ Fp[2] Fi[2] FL Fc[193]}



static void Test_S154C38()
{
  {
    init_simple_test("S154C38");
    S154C38 lv;
    check2(sizeof(lv), ABISELECT(232,220), "sizeof(S154C38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C38)");
    check_field_offset(lv, s154c38f0, 0, "S154C38.s154c38f0");
    check_field_offset(lv, s154c38f1, ABISELECT(16,8), "S154C38.s154c38f1");
    check_field_offset(lv, s154c38f2, ABISELECT(24,16), "S154C38.s154c38f2");
    check_field_offset(lv, s154c38f3, ABISELECT(32,24), "S154C38.s154c38f3");
  }
}
static Arrange_To_Call_Me vS154C38(Test_S154C38, "S154C38", ABISELECT(232,220));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C39  {
  char s154c39f0;
  void *s154c39f1[2];
  void  mf154c39(); // _ZN7S154C398mf154c39Ev
};
//SIG(-1 S154C39) C1{ m Fc Fp[2]}


void  S154C39 ::mf154c39(){}

static void Test_S154C39()
{
  {
    init_simple_test("S154C39");
    S154C39 lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S154C39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C39)");
    check_field_offset(lv, s154c39f0, 0, "S154C39.s154c39f0");
    check_field_offset(lv, s154c39f1, ABISELECT(8,4), "S154C39.s154c39f1");
  }
}
static Arrange_To_Call_Me vS154C39(Test_S154C39, "S154C39", ABISELECT(24,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C45  {
  int s154c45f0;
  char s154c45f1[331];
  int s154c45f2[2];
  char s154c45f3;
  int s154c45f4;
  char s154c45f5[812];
  int s154c45f6[5];
  char s154c45f7;
};
//SIG(-1 S154C45) C1{ Fi Fc[331] Fi[2] Fc Fi Fc[812] Fi[5] Fc}



static void Test_S154C45()
{
  {
    init_simple_test("S154C45");
    S154C45 lv;
    check2(sizeof(lv), 1188, "sizeof(S154C45)");
    check2(__alignof__(lv), 4, "__alignof__(S154C45)");
    check_field_offset(lv, s154c45f0, 0, "S154C45.s154c45f0");
    check_field_offset(lv, s154c45f1, 4, "S154C45.s154c45f1");
    check_field_offset(lv, s154c45f2, 336, "S154C45.s154c45f2");
    check_field_offset(lv, s154c45f3, 344, "S154C45.s154c45f3");
    check_field_offset(lv, s154c45f4, 348, "S154C45.s154c45f4");
    check_field_offset(lv, s154c45f5, 352, "S154C45.s154c45f5");
    check_field_offset(lv, s154c45f6, 1164, "S154C45.s154c45f6");
    check_field_offset(lv, s154c45f7, 1184, "S154C45.s154c45f7");
  }
}
static Arrange_To_Call_Me vS154C45(Test_S154C45, "S154C45", 1188);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C46  {
  int s154c46f0[2];
  char s154c46f1[271];
  __tsi64 s154c46f2;
  char s154c46f3[193];
  int s154c46f4;
  char s154c46f5[65];
  int s154c46f6[2];
  char s154c46f7[96];
  __tsi64 s154c46f8;
  char s154c46f9[68];
};
//SIG(-1 S154C46) C1{ Fi[2] Fc[271] FL Fc[193] Fi Fc[65] Fi[2] Fc[96] FL Fc[68]}



static void Test_S154C46()
{
  {
    init_simple_test("S154C46");
    S154C46 lv;
    check2(sizeof(lv), ABISELECT(744,736), "sizeof(S154C46)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C46)");
    check_field_offset(lv, s154c46f0, 0, "S154C46.s154c46f0");
    check_field_offset(lv, s154c46f1, 8, "S154C46.s154c46f1");
    check_field_offset(lv, s154c46f2, 280, "S154C46.s154c46f2");
    check_field_offset(lv, s154c46f3, 288, "S154C46.s154c46f3");
    check_field_offset(lv, s154c46f4, 484, "S154C46.s154c46f4");
    check_field_offset(lv, s154c46f5, 488, "S154C46.s154c46f5");
    check_field_offset(lv, s154c46f6, 556, "S154C46.s154c46f6");
    check_field_offset(lv, s154c46f7, 564, "S154C46.s154c46f7");
    check_field_offset(lv, s154c46f8, ABISELECT(664,660), "S154C46.s154c46f8");
    check_field_offset(lv, s154c46f9, ABISELECT(672,668), "S154C46.s154c46f9");
  }
}
static Arrange_To_Call_Me vS154C46(Test_S154C46, "S154C46", ABISELECT(744,736));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C47  : S154C16 {
  void *s154c47f0;
  virtual  ~S154C47(); // _ZN7S154C47D1Ev
  virtual void  v101(); // _ZN7S154C474v101Ev
  S154C47(); // tgen
};
//SIG(-1 S154C47) C1{ BC2{ BC3{ vd v2 v3 v4 FL Fp Fi} vd v5 v6 Fi Fc} vd v1 Fp}


 S154C47 ::~S154C47(){ note_dtor("S154C47", this);}
void  S154C47 ::v101(){vfunc_called(this, "_ZN7S154C474v101Ev");}
S154C47 ::S154C47(){ note_ctor("S154C47", this);} // tgen

static void Test_S154C47()
{
  extern Class_Descriptor cd_S154C47;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_S154C47, buf);
    S154C47 *dp, &lv = *(dp=new (buf) S154C47());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(S154C47)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C47)");
    check_base_class_offset(lv, (S154C17*)(S154C16*), 0, "S154C47");
    check_base_class_offset(lv, (S154C16*), 0, "S154C47");
    check_field_offset(lv, s154c47f0, ABISELECT(40,28), "S154C47.s154c47f0");
    test_class_info(&lv, &cd_S154C47);
    dp->~S154C47();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS154C47(Test_S154C47, "S154C47", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN7S154C47C1Ev();
extern void _ZN7S154C47D1Ev();
Name_Map name_map_S154C47[] = {
  NSPAIR(_ZN7S154C47C1Ev),
  NSPAIR(_ZN7S154C47D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S154C17;
extern VTBL_ENTRY _ZTI7S154C17[];
extern  VTBL_ENTRY _ZTV7S154C17[];
extern Class_Descriptor cd_S154C16;
extern VTBL_ENTRY _ZTI7S154C16[];
extern  VTBL_ENTRY _ZTV7S154C16[];
static Base_Class bases_S154C47[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S154C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S154C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S154C47[];
extern void _ZN7S154C47D1Ev();
extern void _ZN7S154C47D0Ev();
extern void _ZN7S154C173v81Ev();
extern void _ZN7S154C173v82Ev();
extern void _ZN7S154C173v83Ev();
extern void _ZN7S154C163v79Ev();
extern void _ZN7S154C163v80Ev();
extern void _ZN7S154C474v101Ev();
static  VTBL_ENTRY vtc_S154C47[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S154C47[0]),
  (VTBL_ENTRY)&_ZN7S154C47D1Ev,
  (VTBL_ENTRY)&_ZN7S154C47D0Ev,
  (VTBL_ENTRY)&_ZN7S154C173v81Ev,
  (VTBL_ENTRY)&_ZN7S154C173v82Ev,
  (VTBL_ENTRY)&_ZN7S154C173v83Ev,
  (VTBL_ENTRY)&_ZN7S154C163v79Ev,
  (VTBL_ENTRY)&_ZN7S154C163v80Ev,
  (VTBL_ENTRY)&_ZN7S154C474v101Ev,
};
extern VTBL_ENTRY _ZTI7S154C47[];
extern  VTBL_ENTRY _ZTV7S154C47[];
Class_Descriptor cd_S154C47 = {  "S154C47", // class name
  bases_S154C47, 2,
  &(vtc_S154C47[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI7S154C47),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S154C47),10, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C48  {
  ::S1587C22 s154c48f0;
  int s154c48f1[3];
  void  mf154c48(); // _ZN7S154C488mf154c48Ev
};
//SIG(-1 S154C48) C1{ m FC2{ m Fp[2]} Fi[3]}


void  S154C48 ::mf154c48(){}

static void Test_S154C48()
{
  {
    init_simple_test("S154C48");
    S154C48 lv;
    check2(sizeof(lv), ABISELECT(32,20), "sizeof(S154C48)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C48)");
    check_field_offset(lv, s154c48f0, 0, "S154C48.s154c48f0");
    check_field_offset(lv, s154c48f1, ABISELECT(16,8), "S154C48.s154c48f1");
  }
}
static Arrange_To_Call_Me vS154C48(Test_S154C48, "S154C48", ABISELECT(32,20));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C50  {
  char s154c50f0[2];
  void *s154c50f1;
  void  mf154c50(); // _ZN7S154C508mf154c50Ev
};
//SIG(-1 S154C50) C1{ m Fc[2] Fp}


void  S154C50 ::mf154c50(){}

static void Test_S154C50()
{
  {
    init_simple_test("S154C50");
    S154C50 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S154C50)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C50)");
    check_field_offset(lv, s154c50f0, 0, "S154C50.s154c50f0");
    check_field_offset(lv, s154c50f1, ABISELECT(8,4), "S154C50.s154c50f1");
  }
}
static Arrange_To_Call_Me vS154C50(Test_S154C50, "S154C50", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C51  {
  ::S1587C6_nt s154c51f0;
  ::S1587C6_nt s154c51f1;
  int s154c51f2;
  ::S1587C20_nt s154c51f3;
  void *s154c51f4[2];
  void  mf154c51(); // _ZN7S154C518mf154c51Ev
};
//SIG(-1 S154C51) C1{ m FC2{ m Fp Fi FC3{ m}} FC2 Fi FC4{ m Fp[2]} Fp[2]}


void  S154C51 ::mf154c51(){}

static void Test_S154C51()
{
  {
    init_simple_test("S154C51");
    S154C51 lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(S154C51)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C51)");
    check_field_offset(lv, s154c51f0, 0, "S154C51.s154c51f0");
    check_field_offset(lv, s154c51f1, ABISELECT(16,12), "S154C51.s154c51f1");
    check_field_offset(lv, s154c51f2, ABISELECT(32,24), "S154C51.s154c51f2");
    check_field_offset(lv, s154c51f3, ABISELECT(40,28), "S154C51.s154c51f3");
    check_field_offset(lv, s154c51f4, ABISELECT(56,36), "S154C51.s154c51f4");
  }
}
static Arrange_To_Call_Me vS154C51(Test_S154C51, "S154C51", ABISELECT(72,44));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C53  {
  char s154c53f0;
  int s154c53f1;
  void  mf154c53(); // _ZN7S154C538mf154c53Ev
};
//SIG(-1 S154C53) C1{ m Fc Fi}


void  S154C53 ::mf154c53(){}

static void Test_S154C53()
{
  {
    init_simple_test("S154C53");
    S154C53 lv;
    check2(sizeof(lv), 8, "sizeof(S154C53)");
    check2(__alignof__(lv), 4, "__alignof__(S154C53)");
    check_field_offset(lv, s154c53f0, 0, "S154C53.s154c53f0");
    check_field_offset(lv, s154c53f1, 4, "S154C53.s154c53f1");
  }
}
static Arrange_To_Call_Me vS154C53(Test_S154C53, "S154C53", 8);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C54  {
  void *s154c54f0[2];
  int s154c54f1[2];
  void  mf154c54(); // _ZN7S154C548mf154c54Ev
};
//SIG(-1 S154C54) C1{ m Fp[2] Fi[2]}


void  S154C54 ::mf154c54(){}

static void Test_S154C54()
{
  {
    init_simple_test("S154C54");
    S154C54 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S154C54)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C54)");
    check_field_offset(lv, s154c54f0, 0, "S154C54.s154c54f0");
    check_field_offset(lv, s154c54f1, ABISELECT(16,8), "S154C54.s154c54f1");
  }
}
static Arrange_To_Call_Me vS154C54(Test_S154C54, "S154C54", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C56_nt  {
  __tsi64 s154c56f0[2];
  void  mf154c56(); // _ZN10S154C56_nt8mf154c56Ev
};
//SIG(-1 S154C56_nt) C1{ m FL[2]}


void  S154C56_nt ::mf154c56(){}

//skip512 S154C56_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C55_nt  {
  ::S154C56_nt s154c55f0;
  void  mf154c55(); // _ZN10S154C55_nt8mf154c55Ev
};
//SIG(-1 S154C55_nt) C1{ m FC2{ m FL[2]}}


void  S154C55_nt ::mf154c55(){}

//skip512 S154C55_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C44  : S154C33 {
  char s154c44f0[2];
  int s154c44f1;
  void *s154c44f2;
  __tsi64 s154c44f3;
  int s154c44f4;
  ::S154C45 s154c44f5;
  ::S154C46 s154c44f6;
  int s154c44f7;
  ::S154C16 s154c44f8;
  ::S154C16 s154c44f9;
  ::S154C47 s154c44f10;
  ::S1587C13 s154c44f11;
  ::S154C39 s154c44f12;
  ::S154C48 s154c44f13;
  ::S154C50 s154c44f14;
  ::S1587C7_nt s154c44f15;
  ::S154C51 s154c44f16;
  ::S154C53 s154c44f17;
  ::S154C27_nt s154c44f18;
  ::S154C54 s154c44f19;
  char s154c44f20;
  ::S154C16 s154c44f21[5];
  char s154c44f22;
  ::S154C55_nt s154c44f23;
  char s154c44f24;
  int s154c44f25[2];
  ::S154C54 s154c44f26;
  virtual  ~S154C44(); // _ZN7S154C44D1Ev
  virtual void  v96(); // _ZN7S154C443v96Ev
  virtual void  v97(); // _ZN7S154C443v97Ev
  virtual void  v98(); // _ZN7S154C443v98Ev
  virtual void  v99(); // _ZN7S154C443v99Ev
  virtual void  v100(); // _ZN7S154C444v100Ev
  S154C44(); // tgen
};
//SIG(-1 S154C44) C1{ BC2{ vd v6 v7 v8 v9 v10 v11 v12 Fp[3] Fi[3] Fc[3] Fi[8] Fc[2] Fp[6] Fi[3]} vd v1 v2 v3 v4 v5 Fc[2] Fi Fp FL Fi FC3{ Fi Fc[331] Fi[2] Fc Fi Fc[812] Fi[5] Fc} FC4{ Fi[2] Fc[271] FL Fc[193] Fi Fc[65] Fi[2] Fc[96] FL Fc[68]} Fi FC5{ BC6{ vd v15 v16 v17 FL Fp Fi} vd v13 v14 Fi Fc} FC5 FC7{ BC5 vd v18 Fp} FC8{ m Fp FC9{ BC10{ m Fp Fi} Fp} Fc Fp} FC11{ m Fc Fp[2]} FC12{ m FC13{ m Fp[2]} Fi[3]} FC14{ m Fc[2] Fp} FC15{ m} FC16{ m FC17{ m Fp Fi FC15} FC17 Fi FC18{ m Fp[2]} Fp[2]} FC19{ m Fc Fi} FC20{ m FC21{ m Fp[2]}} FC22{ m Fp[2] Fi[2]} Fc FC5[5] Fc FC23{ m FC24{ m FL[2]}} Fc Fi[2] FC22}


 S154C44 ::~S154C44(){ note_dtor("S154C44", this);}
void  S154C44 ::v96(){vfunc_called(this, "_ZN7S154C443v96Ev");}
void  S154C44 ::v97(){vfunc_called(this, "_ZN7S154C443v97Ev");}
void  S154C44 ::v98(){vfunc_called(this, "_ZN7S154C443v98Ev");}
void  S154C44 ::v99(){vfunc_called(this, "_ZN7S154C443v99Ev");}
void  S154C44 ::v100(){vfunc_called(this, "_ZN7S154C444v100Ev");}
S154C44 ::S154C44(){ note_ctor("S154C44", this);} // tgen

static void Test_S154C44()
{
  extern Class_Descriptor cd_S154C44;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(347,621)];
    init_test(&cd_S154C44, buf);
    S154C44 *dp, &lv = *(dp=new (buf) S154C44());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2768,2480), "sizeof(S154C44)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C44)");
    check_base_class_offset(lv, (S154C33*), 0, "S154C44");
    check_field_offset(lv, s154c44f0, ABISELECT(148,104), "S154C44.s154c44f0");
    check_field_offset(lv, s154c44f1, ABISELECT(152,108), "S154C44.s154c44f1");
    check_field_offset(lv, s154c44f2, ABISELECT(160,112), "S154C44.s154c44f2");
    check_field_offset(lv, s154c44f3, ABISELECT(168,116), "S154C44.s154c44f3");
    check_field_offset(lv, s154c44f4, ABISELECT(176,124), "S154C44.s154c44f4");
    check_field_offset(lv, s154c44f5, ABISELECT(180,128), "S154C44.s154c44f5");
    check_field_offset(lv, s154c44f6, ABISELECT(1368,1316), "S154C44.s154c44f6");
    check_field_offset(lv, s154c44f7, ABISELECT(2112,2052), "S154C44.s154c44f7");
    check_field_offset(lv, s154c44f8, ABISELECT(2120,2056), "S154C44.s154c44f8");
    check_field_offset(lv, s154c44f9, ABISELECT(2160,2084), "S154C44.s154c44f9");
    check_field_offset(lv, s154c44f10, ABISELECT(2200,2112), "S154C44.s154c44f10");
    check_field_offset(lv, s154c44f11, ABISELECT(2248,2144), "S154C44.s154c44f11");
    check_field_offset(lv, s154c44f12, ABISELECT(2296,2168), "S154C44.s154c44f12");
    check_field_offset(lv, s154c44f13, ABISELECT(2320,2180), "S154C44.s154c44f13");
    check_field_offset(lv, s154c44f14, ABISELECT(2352,2200), "S154C44.s154c44f14");
    check_field_offset(lv, s154c44f15, ABISELECT(2368,2208), "S154C44.s154c44f15");
    check_field_offset(lv, s154c44f16, ABISELECT(2376,2212), "S154C44.s154c44f16");
    check_field_offset(lv, s154c44f17, ABISELECT(2448,2256), "S154C44.s154c44f17");
    check_field_offset(lv, s154c44f18, ABISELECT(2456,2264), "S154C44.s154c44f18");
    check_field_offset(lv, s154c44f19, ABISELECT(2472,2272), "S154C44.s154c44f19");
    check_field_offset(lv, s154c44f20, ABISELECT(2496,2288), "S154C44.s154c44f20");
    check_field_offset(lv, s154c44f21, ABISELECT(2504,2292), "S154C44.s154c44f21");
    check_field_offset(lv, s154c44f22, ABISELECT(2704,2432), "S154C44.s154c44f22");
    check_field_offset(lv, s154c44f23, ABISELECT(2712,2436), "S154C44.s154c44f23");
    check_field_offset(lv, s154c44f24, ABISELECT(2728,2452), "S154C44.s154c44f24");
    check_field_offset(lv, s154c44f25, ABISELECT(2732,2456), "S154C44.s154c44f25");
    check_field_offset(lv, s154c44f26, ABISELECT(2744,2464), "S154C44.s154c44f26");
    test_class_info(&lv, &cd_S154C44);
    dp->~S154C44();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS154C44(Test_S154C44, "S154C44", ABISELECT(2768,2480));

#else // __cplusplus

extern void _ZN7S154C44C1Ev();
extern void _ZN7S154C44D1Ev();
Name_Map name_map_S154C44[] = {
  NSPAIR(_ZN7S154C44C1Ev),
  NSPAIR(_ZN7S154C44D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S154C33;
extern VTBL_ENTRY _ZTI7S154C33[];
extern  VTBL_ENTRY _ZTV7S154C33[];
static Base_Class bases_S154C44[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S154C33,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S154C44[];
extern void _ZN7S154C44D1Ev();
extern void _ZN7S154C44D0Ev();
extern void _ZN7S154C333v89Ev();
extern void _ZN7S154C333v90Ev();
extern void _ZN7S154C333v91Ev();
extern void _ZN7S154C333v92Ev();
extern void _ZN7S154C333v93Ev();
extern void _ZN7S154C333v94Ev();
extern void _ZN7S154C333v95Ev();
extern void _ZN7S154C443v96Ev();
extern void _ZN7S154C443v97Ev();
extern void _ZN7S154C443v98Ev();
extern void _ZN7S154C443v99Ev();
extern void _ZN7S154C444v100Ev();
static  VTBL_ENTRY vtc_S154C44[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S154C44[0]),
  (VTBL_ENTRY)&_ZN7S154C44D1Ev,
  (VTBL_ENTRY)&_ZN7S154C44D0Ev,
  (VTBL_ENTRY)&_ZN7S154C333v89Ev,
  (VTBL_ENTRY)&_ZN7S154C333v90Ev,
  (VTBL_ENTRY)&_ZN7S154C333v91Ev,
  (VTBL_ENTRY)&_ZN7S154C333v92Ev,
  (VTBL_ENTRY)&_ZN7S154C333v93Ev,
  (VTBL_ENTRY)&_ZN7S154C333v94Ev,
  (VTBL_ENTRY)&_ZN7S154C333v95Ev,
  (VTBL_ENTRY)&_ZN7S154C443v96Ev,
  (VTBL_ENTRY)&_ZN7S154C443v97Ev,
  (VTBL_ENTRY)&_ZN7S154C443v98Ev,
  (VTBL_ENTRY)&_ZN7S154C443v99Ev,
  (VTBL_ENTRY)&_ZN7S154C444v100Ev,
};
extern VTBL_ENTRY _ZTI7S154C44[];
extern  VTBL_ENTRY _ZTV7S154C44[];
Class_Descriptor cd_S154C44 = {  "S154C44", // class name
  bases_S154C44, 1,
  &(vtc_S154C44[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2768,2480), // object size
  NSPAIRA(_ZTI7S154C44),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S154C44),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C57  {
  void *s154c57f0[2];
  void  mf154c57(); // _ZN7S154C578mf154c57Ev
};
//SIG(-1 S154C57) C1{ m Fp[2]}


void  S154C57 ::mf154c57(){}

static void Test_S154C57()
{
  {
    init_simple_test("S154C57");
    S154C57 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S154C57)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C57)");
    check_field_offset(lv, s154c57f0, 0, "S154C57.s154c57f0");
  }
}
static Arrange_To_Call_Me vS154C57(Test_S154C57, "S154C57", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C32  : S154C33 {
  char s154c32f0[2];
  ::S154C34 s154c32f1;
  ::S154C35 s154c32f2;
  ::S154C36 s154c32f3;
  char s154c32f4;
  ::S154C38 s154c32f5;
  ::S154C16 s154c32f6;
  ::S154C16 s154c32f7[5];
  __tsi64 s154c32f8;
  int s154c32f9[5];
  __tsi64 s154c32f10[5];
  ::S154C39 s154c32f11;
  ::S1587C7_nt s154c32f12;
  ::S1587C13 s154c32f13;
  ::S154C44 s154c32f14;
  ::S154C57 s154c32f15;
  ::S154C57 s154c32f16;
  int s154c32f17;
  virtual  ~S154C32(); // _ZN7S154C32D1Ev
  virtual void  v84(); // _ZN7S154C323v84Ev
  virtual void  v85(); // _ZN7S154C323v85Ev
  virtual void  v86(); // _ZN7S154C323v86Ev
  virtual void  v87(); // _ZN7S154C323v87Ev
  virtual void  v88(); // _ZN7S154C323v88Ev
  S154C32(); // tgen
};
//SIG(-1 S154C32) C1{ BC2{ vd v6 v7 v8 v9 v10 v11 v12 Fp[3] Fi[3] Fc[3] Fi[8] Fc[2] Fp[6] Fi[3]} vd v1 v2 v3 v4 v5 Fc[2] FC3{ Fc[65] FC4{ FC5{ Fc[20]} Fc[16]} Fi[2] FL Fi} FC6{ Fi Fc[815] Fi[5]} FC7{ Fi FC8{ Fc[33] Fi Fc FC9{ m Fp Fi FC10{ m}} Fi Fc}[5]} Fc FC11{ Fp[2] Fi[2] FL Fc[193]} FC12{ BC13{ vd v15 v16 v17 FL Fp Fi} vd v13 v14 Fi Fc} FC12[5] FL Fi[5] FL[5] FC14{ m Fc Fp[2]} FC10 FC15{ m Fp FC16{ BC17{ m Fp Fi} Fp} Fc Fp} FC18{ BC2 vd v18 v19 v20 v21 v22 Fc[2] Fi Fp FL Fi FC19{ Fi Fc[331] Fi[2] Fc Fi Fc[812] Fi[5] Fc} FC20{ Fi[2] Fc[271] FL Fc[193] Fi Fc[65] Fi[2] Fc[96] FL Fc[68]} Fi FC12 FC12 FC21{ BC12 vd v23 Fp} FC15 FC14 FC22{ m FC23{ m Fp[2]} Fi[3]} FC24{ m Fc[2] Fp} FC10 FC25{ m FC9 FC9 Fi FC26{ m Fp[2]} Fp[2]} FC27{ m Fc Fi} FC28{ m FC29{ m Fp[2]}} FC30{ m Fp[2] Fi[2]} Fc FC12[5] Fc FC31{ m FC32{ m FL[2]}} Fc Fi[2] FC30} FC33{ m Fp[2]} FC33 Fi}


 S154C32 ::~S154C32(){ note_dtor("S154C32", this);}
void  S154C32 ::v84(){vfunc_called(this, "_ZN7S154C323v84Ev");}
void  S154C32 ::v85(){vfunc_called(this, "_ZN7S154C323v85Ev");}
void  S154C32 ::v86(){vfunc_called(this, "_ZN7S154C323v86Ev");}
void  S154C32 ::v87(){vfunc_called(this, "_ZN7S154C323v87Ev");}
void  S154C32 ::v88(){vfunc_called(this, "_ZN7S154C323v88Ev");}
S154C32 ::S154C32(){ note_ctor("S154C32", this);} // tgen

static void Test_S154C32()
{
  extern Class_Descriptor cd_S154C32;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(617,1100)];
    init_test(&cd_S154C32, buf);
    S154C32 *dp, &lv = *(dp=new (buf) S154C32());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(4928,4396), "sizeof(S154C32)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C32)");
    check_base_class_offset(lv, (S154C33*), 0, "S154C32");
    check_field_offset(lv, s154c32f0, ABISELECT(148,104), "S154C32.s154c32f0");
    check_field_offset(lv, s154c32f1, ABISELECT(152,108), "S154C32.s154c32f1");
    check_field_offset(lv, s154c32f2, ABISELECT(280,232), "S154C32.s154c32f2");
    check_field_offset(lv, s154c32f3, ABISELECT(1120,1072), "S154C32.s154c32f3");
    check_field_offset(lv, s154c32f4, ABISELECT(1488,1396), "S154C32.s154c32f4");
    check_field_offset(lv, s154c32f5, ABISELECT(1496,1400), "S154C32.s154c32f5");
    check_field_offset(lv, s154c32f6, ABISELECT(1728,1620), "S154C32.s154c32f6");
    check_field_offset(lv, s154c32f7, ABISELECT(1768,1648), "S154C32.s154c32f7");
    check_field_offset(lv, s154c32f8, ABISELECT(1968,1788), "S154C32.s154c32f8");
    check_field_offset(lv, s154c32f9, ABISELECT(1976,1796), "S154C32.s154c32f9");
    check_field_offset(lv, s154c32f10, ABISELECT(2000,1816), "S154C32.s154c32f10");
    check_field_offset(lv, s154c32f11, ABISELECT(2040,1856), "S154C32.s154c32f11");
    check_field_offset(lv, s154c32f12, ABISELECT(2064,1868), "S154C32.s154c32f12");
    check_field_offset(lv, s154c32f13, ABISELECT(2072,1872), "S154C32.s154c32f13");
    check_field_offset(lv, s154c32f14, ABISELECT(2120,1896), "S154C32.s154c32f14");
    check_field_offset(lv, s154c32f15, ABISELECT(4888,4376), "S154C32.s154c32f15");
    check_field_offset(lv, s154c32f16, ABISELECT(4904,4384), "S154C32.s154c32f16");
    check_field_offset(lv, s154c32f17, ABISELECT(4920,4392), "S154C32.s154c32f17");
    test_class_info(&lv, &cd_S154C32);
    dp->~S154C32();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS154C32(Test_S154C32, "S154C32", ABISELECT(4928,4396));

#else // __cplusplus

extern void _ZN7S154C32C1Ev();
extern void _ZN7S154C32D1Ev();
Name_Map name_map_S154C32[] = {
  NSPAIR(_ZN7S154C32C1Ev),
  NSPAIR(_ZN7S154C32D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S154C33;
extern VTBL_ENTRY _ZTI7S154C33[];
extern  VTBL_ENTRY _ZTV7S154C33[];
static Base_Class bases_S154C32[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S154C33,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S154C32[];
extern void _ZN7S154C32D1Ev();
extern void _ZN7S154C32D0Ev();
extern void _ZN7S154C333v89Ev();
extern void _ZN7S154C333v90Ev();
extern void _ZN7S154C333v91Ev();
extern void _ZN7S154C333v92Ev();
extern void _ZN7S154C333v93Ev();
extern void _ZN7S154C333v94Ev();
extern void _ZN7S154C333v95Ev();
extern void _ZN7S154C323v84Ev();
extern void _ZN7S154C323v85Ev();
extern void _ZN7S154C323v86Ev();
extern void _ZN7S154C323v87Ev();
extern void _ZN7S154C323v88Ev();
static  VTBL_ENTRY vtc_S154C32[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S154C32[0]),
  (VTBL_ENTRY)&_ZN7S154C32D1Ev,
  (VTBL_ENTRY)&_ZN7S154C32D0Ev,
  (VTBL_ENTRY)&_ZN7S154C333v89Ev,
  (VTBL_ENTRY)&_ZN7S154C333v90Ev,
  (VTBL_ENTRY)&_ZN7S154C333v91Ev,
  (VTBL_ENTRY)&_ZN7S154C333v92Ev,
  (VTBL_ENTRY)&_ZN7S154C333v93Ev,
  (VTBL_ENTRY)&_ZN7S154C333v94Ev,
  (VTBL_ENTRY)&_ZN7S154C333v95Ev,
  (VTBL_ENTRY)&_ZN7S154C323v84Ev,
  (VTBL_ENTRY)&_ZN7S154C323v85Ev,
  (VTBL_ENTRY)&_ZN7S154C323v86Ev,
  (VTBL_ENTRY)&_ZN7S154C323v87Ev,
  (VTBL_ENTRY)&_ZN7S154C323v88Ev,
};
extern VTBL_ENTRY _ZTI7S154C32[];
extern  VTBL_ENTRY _ZTV7S154C32[];
Class_Descriptor cd_S154C32 = {  "S154C32", // class name
  bases_S154C32, 1,
  &(vtc_S154C32[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(4928,4396), // object size
  NSPAIRA(_ZTI7S154C32),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S154C32),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C59  {
  void *s154c59f0[2];
  void  mf154c59(); // _ZN7S154C598mf154c59Ev
};
//SIG(-1 S154C59) C1{ m Fp[2]}


void  S154C59 ::mf154c59(){}

static void Test_S154C59()
{
  {
    init_simple_test("S154C59");
    S154C59 lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S154C59)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C59)");
    check_field_offset(lv, s154c59f0, 0, "S154C59.s154c59f0");
  }
}
static Arrange_To_Call_Me vS154C59(Test_S154C59, "S154C59", ABISELECT(16,8));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S154C1  : S154C2 {
  ::S1587C17 s154c1f0;
  char s154c1f1;
  int s154c1f2;
  ::S154C14 s154c1f3;
  void *s154c1f4;
  ::S154C16 s154c1f5;
  ::S154C16 s154c1f6;
  ::S1587C45 s154c1f7;
  ::S1587C18 s154c1f8;
  ::S1587C18 s154c1f9;
  ::S1587C18 s154c1f10;
  void *s154c1f11;
  ::S154C27_nt s154c1f12;
  ::S154C27_nt s154c1f13;
  ::S154C27_nt s154c1f14;
  ::S1587C27 s154c1f15;
  ::S154C32 s154c1f16;
  ::S1587C13 s154c1f17;
  ::S1587C8_nt s154c1f18;
  int s154c1f19[34];
  ::S154C59 s154c1f20;
  int s154c1f21;
  virtual  ~S154C1(); // _ZN6S154C1D1Ev
  virtual void  v1(); // _ZN6S154C12v1Ev
  virtual void  v2(); // _ZN6S154C12v2Ev
  virtual void  v3(); // _ZN6S154C12v3Ev
  virtual void  v4(); // _ZN6S154C12v4Ev
  virtual void  v5(); // _ZN6S154C12v5Ev
  virtual void  v6(); // _ZN6S154C12v6Ev
  virtual void  v7(); // _ZN6S154C12v7Ev
  virtual void  v8(); // _ZN6S154C12v8Ev
  virtual void  v9(); // _ZN6S154C12v9Ev
  virtual void  v10(); // _ZN6S154C13v10Ev
  virtual void  v11(); // _ZN6S154C13v11Ev
  virtual void  v12(); // _ZN6S154C13v12Ev
  virtual void  v13(); // _ZN6S154C13v13Ev
  virtual void  v14(); // _ZN6S154C13v14Ev
  S154C1(); // tgen
};
//SIG(1 S154C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 Fp FC7{ m FC8{ m Fp Fi FC9{ m}} Fi} Fc Fi} vd v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 Fp[3] Fi} vd v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 Fp[2] Fi[3] FC7 Fc FC10{ m FC11{ m FL}} Fc Fi Fc Fi Fc[2] Fi Fc} vd v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi[4]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 Fp Fc Fi Fc[3] Fi FC12{ m Fi Fp Fi} Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 FC13{ m Fp[2] Fi[2]} Fc Fi FC14{ Fi[3] Fc[193] Fi Fc[33] FL[2] Fi FC15{ Fi[2] Fc[17] Fi Fp} Fi[2] Fc[66]} Fp FC16{ BC17{ vd v81 v82 v83 FL Fp Fi} vd v79 v80 Fi Fc} FC16 FC18{ m Fp[2]} FC19{ m FC13 Fp[2] Fc Fp FC20{ m Fp[2]} FC20 FC21{ m Fp[2]} Fp Fi FC22{ Fi[3] FC23{ Fi} FC24{ Fi[3]}} Fi[3] Fc FC24 Fi} FC19 FC19 Fp FC25{ m FC26{ m Fp[2]}} FC25 FC25 FC27{ m FC21 FC8 FC28{ FC29{ Fc[20]} Fc[16]}} FC30{ BC31{ vd v89 v90 v91 v92 v93 v94 v95 Fp[3] Fi[3] Fc[3] Fi[8] Fc[2] Fp[6] Fi[3]} vd v84 v85 v86 v87 v88 Fc[2] FC32{ Fc[65] FC28 Fi[2] FL Fi} FC33{ Fi Fc[815] Fi[5]} FC34{ Fi FC35{ Fc[33] Fi Fc FC8 Fi Fc}[5]} Fc FC36{ Fp[2] Fi[2] FL Fc[193]} FC16 FC16[5] FL Fi[5] FL[5] FC37{ m Fc Fp[2]} FC9 FC38{ m Fp FC39{ BC40{ m Fp Fi} Fp} Fc Fp} FC41{ BC31 vd v96 v97 v98 v99 v100 Fc[2] Fi Fp FL Fi FC42{ Fi Fc[331] Fi[2] Fc Fi Fc[812] Fi[5] Fc} FC43{ Fi[2] Fc[271] FL Fc[193] Fi Fc[65] Fi[2] Fc[96] FL Fc[68]} Fi FC16 FC16 FC44{ BC16 vd v101 Fp} FC38 FC37 FC45{ m FC21 Fi[3]} FC46{ m Fc[2] Fp} FC9 FC47{ m FC8 FC8 Fi FC20 Fp[2]} FC48{ m Fc Fi} FC25 FC49{ m Fp[2] Fi[2]} Fc FC16[5] Fc FC50{ m FC51{ m FL[2]}} Fc Fi[2] FC49} FC52{ m Fp[2]} FC52 Fi} FC38 FC10 Fi[34] FC53{ m Fp[2]} Fi}


 S154C1 ::~S154C1(){ note_dtor("S154C1", this);}
void  S154C1 ::v1(){vfunc_called(this, "_ZN6S154C12v1Ev");}
void  S154C1 ::v2(){vfunc_called(this, "_ZN6S154C12v2Ev");}
void  S154C1 ::v3(){vfunc_called(this, "_ZN6S154C12v3Ev");}
void  S154C1 ::v4(){vfunc_called(this, "_ZN6S154C12v4Ev");}
void  S154C1 ::v5(){vfunc_called(this, "_ZN6S154C12v5Ev");}
void  S154C1 ::v6(){vfunc_called(this, "_ZN6S154C12v6Ev");}
void  S154C1 ::v7(){vfunc_called(this, "_ZN6S154C12v7Ev");}
void  S154C1 ::v8(){vfunc_called(this, "_ZN6S154C12v8Ev");}
void  S154C1 ::v9(){vfunc_called(this, "_ZN6S154C12v9Ev");}
void  S154C1 ::v10(){vfunc_called(this, "_ZN6S154C13v10Ev");}
void  S154C1 ::v11(){vfunc_called(this, "_ZN6S154C13v11Ev");}
void  S154C1 ::v12(){vfunc_called(this, "_ZN6S154C13v12Ev");}
void  S154C1 ::v13(){vfunc_called(this, "_ZN6S154C13v13Ev");}
void  S154C1 ::v14(){vfunc_called(this, "_ZN6S154C13v14Ev");}
S154C1 ::S154C1(){ note_ctor("S154C1", this);} // tgen

static void Test_S154C1()
{
  extern Class_Descriptor cd_S154C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(824,1422)];
    init_test(&cd_S154C1, buf);
    S154C1 *dp, &lv = *(dp=new (buf) S154C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(6584,5684), "sizeof(S154C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S154C1)");
    check_base_class_offset(lv, (S154C6*)(S154C5*)(S154C4*)(S154C3*)(S154C2*), 0, "S154C1");
    check_base_class_offset(lv, (S154C5*)(S154C4*)(S154C3*)(S154C2*), 0, "S154C1");
    check_base_class_offset(lv, (S154C4*)(S154C3*)(S154C2*), 0, "S154C1");
    check_base_class_offset(lv, (S154C3*)(S154C2*), 0, "S154C1");
    check_base_class_offset(lv, (S154C2*), 0, "S154C1");
    check_field_offset(lv, s154c1f0, ABISELECT(256,180), "S154C1.s154c1f0");
    check_field_offset(lv, s154c1f1, ABISELECT(280,196), "S154C1.s154c1f1");
    check_field_offset(lv, s154c1f2, ABISELECT(284,200), "S154C1.s154c1f2");
    check_field_offset(lv, s154c1f3, ABISELECT(288,204), "S154C1.s154c1f3");
    check_field_offset(lv, s154c1f4, ABISELECT(680,584), "S154C1.s154c1f4");
    check_field_offset(lv, s154c1f5, ABISELECT(688,588), "S154C1.s154c1f5");
    check_field_offset(lv, s154c1f6, ABISELECT(728,616), "S154C1.s154c1f6");
    check_field_offset(lv, s154c1f7, ABISELECT(768,644), "S154C1.s154c1f7");
    check_field_offset(lv, s154c1f8, ABISELECT(784,652), "S154C1.s154c1f8");
    check_field_offset(lv, s154c1f9, ABISELECT(960,776), "S154C1.s154c1f9");
    check_field_offset(lv, s154c1f10, ABISELECT(1136,900), "S154C1.s154c1f10");
    check_field_offset(lv, s154c1f11, ABISELECT(1312,1024), "S154C1.s154c1f11");
    check_field_offset(lv, s154c1f12, ABISELECT(1320,1028), "S154C1.s154c1f12");
    check_field_offset(lv, s154c1f13, ABISELECT(1336,1036), "S154C1.s154c1f13");
    check_field_offset(lv, s154c1f14, ABISELECT(1352,1044), "S154C1.s154c1f14");
    check_field_offset(lv, s154c1f15, ABISELECT(1368,1052), "S154C1.s154c1f15");
    check_field_offset(lv, s154c1f16, ABISELECT(1440,1108), "S154C1.s154c1f16");
    check_field_offset(lv, s154c1f17, ABISELECT(6368,5504), "S154C1.s154c1f17");
    check_field_offset(lv, s154c1f18, ABISELECT(6416,5528), "S154C1.s154c1f18");
    check_field_offset(lv, s154c1f19, ABISELECT(6424,5536), "S154C1.s154c1f19");
    check_field_offset(lv, s154c1f20, ABISELECT(6560,5672), "S154C1.s154c1f20");
    check_field_offset(lv, s154c1f21, ABISELECT(6576,5680), "S154C1.s154c1f21");
    test_class_info(&lv, &cd_S154C1);
    dp->~S154C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS154C1(Test_S154C1, "S154C1", ABISELECT(6584,5684));

#else // __cplusplus

extern void _ZN6S154C1C1Ev();
extern void _ZN6S154C1D1Ev();
Name_Map name_map_S154C1[] = {
  NSPAIR(_ZN6S154C1C1Ev),
  NSPAIR(_ZN6S154C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S154C6;
extern VTBL_ENTRY _ZTI6S154C6[];
extern  VTBL_ENTRY _ZTV6S154C6[];
extern Class_Descriptor cd_S154C5;
extern VTBL_ENTRY _ZTI6S154C5[];
extern  VTBL_ENTRY _ZTV6S154C5[];
extern Class_Descriptor cd_S154C4;
extern VTBL_ENTRY _ZTI6S154C4[];
extern  VTBL_ENTRY _ZTV6S154C4[];
extern Class_Descriptor cd_S154C3;
extern VTBL_ENTRY _ZTI6S154C3[];
extern  VTBL_ENTRY _ZTV6S154C3[];
extern Class_Descriptor cd_S154C2;
extern VTBL_ENTRY _ZTI6S154C2[];
extern  VTBL_ENTRY _ZTV6S154C2[];
static Base_Class bases_S154C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S154C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S154C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S154C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S154C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S154C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S154C1[];
extern void _ZN6S154C1D1Ev();
extern void _ZN6S154C1D0Ev();
extern void _ZN6S154C63v15Ev();
extern void _ZN6S154C63v16Ev();
extern void _ZN6S154C63v17Ev();
extern void _ZN6S154C63v18Ev();
extern void _ZN6S154C63v19Ev();
extern void _ZN6S154C63v20Ev();
extern void _ZN6S154C63v21Ev();
extern void _ZN6S154C63v22Ev();
extern void _ZN6S154C63v23Ev();
extern void _ZN6S154C63v24Ev();
extern void _ZN6S154C63v25Ev();
extern void _ZN6S154C63v26Ev();
extern void _ZN6S154C63v27Ev();
extern void _ZN6S154C53v28Ev();
extern void _ZN6S154C53v29Ev();
extern void _ZN6S154C53v30Ev();
extern void _ZN6S154C53v31Ev();
extern void _ZN6S154C53v32Ev();
extern void _ZN6S154C53v33Ev();
extern void _ZN6S154C53v34Ev();
extern void _ZN6S154C53v35Ev();
extern void _ZN6S154C53v36Ev();
extern void _ZN6S154C53v37Ev();
extern void _ZN6S154C53v38Ev();
extern void _ZN6S154C43v39Ev();
extern void _ZN6S154C43v40Ev();
extern void _ZN6S154C43v41Ev();
extern void _ZN6S154C43v42Ev();
extern void _ZN6S154C43v43Ev();
extern void _ZN6S154C43v44Ev();
extern void _ZN6S154C43v45Ev();
extern void _ZN6S154C43v46Ev();
extern void _ZN6S154C43v47Ev();
extern void _ZN6S154C43v48Ev();
extern void _ZN6S154C43v49Ev();
extern void _ZN6S154C43v50Ev();
extern void _ZN6S154C43v51Ev();
extern void _ZN6S154C43v52Ev();
extern void _ZN6S154C43v53Ev();
extern void _ZN6S154C43v54Ev();
extern void _ZN6S154C43v55Ev();
extern void _ZN6S154C33v56Ev();
extern void _ZN6S154C33v57Ev();
extern void _ZN6S154C33v58Ev();
extern void _ZN6S154C33v59Ev();
extern void _ZN6S154C33v60Ev();
extern void _ZN6S154C33v61Ev();
extern void _ZN6S154C33v62Ev();
extern void _ZN6S154C33v63Ev();
extern void _ZN6S154C33v64Ev();
extern void _ZN6S154C33v65Ev();
extern void _ZN6S154C33v66Ev();
extern void _ZN6S154C33v67Ev();
extern void _ZN6S154C33v68Ev();
extern void _ZN6S154C23v69Ev();
extern void _ZN6S154C23v70Ev();
extern void _ZN6S154C23v71Ev();
extern void _ZN6S154C23v72Ev();
extern void _ZN6S154C23v73Ev();
extern void _ZN6S154C23v74Ev();
extern void _ZN6S154C23v75Ev();
extern void _ZN6S154C23v76Ev();
extern void _ZN6S154C23v77Ev();
extern void _ZN6S154C23v78Ev();
extern void _ZN6S154C12v1Ev();
extern void _ZN6S154C12v2Ev();
extern void _ZN6S154C12v3Ev();
extern void _ZN6S154C12v4Ev();
extern void _ZN6S154C12v5Ev();
extern void _ZN6S154C12v6Ev();
extern void _ZN6S154C12v7Ev();
extern void _ZN6S154C12v8Ev();
extern void _ZN6S154C12v9Ev();
extern void _ZN6S154C13v10Ev();
extern void _ZN6S154C13v11Ev();
extern void _ZN6S154C13v12Ev();
extern void _ZN6S154C13v13Ev();
extern void _ZN6S154C13v14Ev();
static  VTBL_ENTRY vtc_S154C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S154C1[0]),
  (VTBL_ENTRY)&_ZN6S154C1D1Ev,
  (VTBL_ENTRY)&_ZN6S154C1D0Ev,
  (VTBL_ENTRY)&_ZN6S154C63v15Ev,
  (VTBL_ENTRY)&_ZN6S154C63v16Ev,
  (VTBL_ENTRY)&_ZN6S154C63v17Ev,
  (VTBL_ENTRY)&_ZN6S154C63v18Ev,
  (VTBL_ENTRY)&_ZN6S154C63v19Ev,
  (VTBL_ENTRY)&_ZN6S154C63v20Ev,
  (VTBL_ENTRY)&_ZN6S154C63v21Ev,
  (VTBL_ENTRY)&_ZN6S154C63v22Ev,
  (VTBL_ENTRY)&_ZN6S154C63v23Ev,
  (VTBL_ENTRY)&_ZN6S154C63v24Ev,
  (VTBL_ENTRY)&_ZN6S154C63v25Ev,
  (VTBL_ENTRY)&_ZN6S154C63v26Ev,
  (VTBL_ENTRY)&_ZN6S154C63v27Ev,
  (VTBL_ENTRY)&_ZN6S154C53v28Ev,
  (VTBL_ENTRY)&_ZN6S154C53v29Ev,
  (VTBL_ENTRY)&_ZN6S154C53v30Ev,
  (VTBL_ENTRY)&_ZN6S154C53v31Ev,
  (VTBL_ENTRY)&_ZN6S154C53v32Ev,
  (VTBL_ENTRY)&_ZN6S154C53v33Ev,
  (VTBL_ENTRY)&_ZN6S154C53v34Ev,
  (VTBL_ENTRY)&_ZN6S154C53v35Ev,
  (VTBL_ENTRY)&_ZN6S154C53v36Ev,
  (VTBL_ENTRY)&_ZN6S154C53v37Ev,
  (VTBL_ENTRY)&_ZN6S154C53v38Ev,
  (VTBL_ENTRY)&_ZN6S154C43v39Ev,
  (VTBL_ENTRY)&_ZN6S154C43v40Ev,
  (VTBL_ENTRY)&_ZN6S154C43v41Ev,
  (VTBL_ENTRY)&_ZN6S154C43v42Ev,
  (VTBL_ENTRY)&_ZN6S154C43v43Ev,
  (VTBL_ENTRY)&_ZN6S154C43v44Ev,
  (VTBL_ENTRY)&_ZN6S154C43v45Ev,
  (VTBL_ENTRY)&_ZN6S154C43v46Ev,
  (VTBL_ENTRY)&_ZN6S154C43v47Ev,
  (VTBL_ENTRY)&_ZN6S154C43v48Ev,
  (VTBL_ENTRY)&_ZN6S154C43v49Ev,
  (VTBL_ENTRY)&_ZN6S154C43v50Ev,
  (VTBL_ENTRY)&_ZN6S154C43v51Ev,
  (VTBL_ENTRY)&_ZN6S154C43v52Ev,
  (VTBL_ENTRY)&_ZN6S154C43v53Ev,
  (VTBL_ENTRY)&_ZN6S154C43v54Ev,
  (VTBL_ENTRY)&_ZN6S154C43v55Ev,
  (VTBL_ENTRY)&_ZN6S154C33v56Ev,
  (VTBL_ENTRY)&_ZN6S154C33v57Ev,
  (VTBL_ENTRY)&_ZN6S154C33v58Ev,
  (VTBL_ENTRY)&_ZN6S154C33v59Ev,
  (VTBL_ENTRY)&_ZN6S154C33v60Ev,
  (VTBL_ENTRY)&_ZN6S154C33v61Ev,
  (VTBL_ENTRY)&_ZN6S154C33v62Ev,
  (VTBL_ENTRY)&_ZN6S154C33v63Ev,
  (VTBL_ENTRY)&_ZN6S154C33v64Ev,
  (VTBL_ENTRY)&_ZN6S154C33v65Ev,
  (VTBL_ENTRY)&_ZN6S154C33v66Ev,
  (VTBL_ENTRY)&_ZN6S154C33v67Ev,
  (VTBL_ENTRY)&_ZN6S154C33v68Ev,
  (VTBL_ENTRY)&_ZN6S154C23v69Ev,
  (VTBL_ENTRY)&_ZN6S154C23v70Ev,
  (VTBL_ENTRY)&_ZN6S154C23v71Ev,
  (VTBL_ENTRY)&_ZN6S154C23v72Ev,
  (VTBL_ENTRY)&_ZN6S154C23v73Ev,
  (VTBL_ENTRY)&_ZN6S154C23v74Ev,
  (VTBL_ENTRY)&_ZN6S154C23v75Ev,
  (VTBL_ENTRY)&_ZN6S154C23v76Ev,
  (VTBL_ENTRY)&_ZN6S154C23v77Ev,
  (VTBL_ENTRY)&_ZN6S154C23v78Ev,
  (VTBL_ENTRY)&_ZN6S154C12v1Ev,
  (VTBL_ENTRY)&_ZN6S154C12v2Ev,
  (VTBL_ENTRY)&_ZN6S154C12v3Ev,
  (VTBL_ENTRY)&_ZN6S154C12v4Ev,
  (VTBL_ENTRY)&_ZN6S154C12v5Ev,
  (VTBL_ENTRY)&_ZN6S154C12v6Ev,
  (VTBL_ENTRY)&_ZN6S154C12v7Ev,
  (VTBL_ENTRY)&_ZN6S154C12v8Ev,
  (VTBL_ENTRY)&_ZN6S154C12v9Ev,
  (VTBL_ENTRY)&_ZN6S154C13v10Ev,
  (VTBL_ENTRY)&_ZN6S154C13v11Ev,
  (VTBL_ENTRY)&_ZN6S154C13v12Ev,
  (VTBL_ENTRY)&_ZN6S154C13v13Ev,
  (VTBL_ENTRY)&_ZN6S154C13v14Ev,
};
extern VTBL_ENTRY _ZTI6S154C1[];
extern  VTBL_ENTRY _ZTV6S154C1[];
Class_Descriptor cd_S154C1 = {  "S154C1", // class name
  bases_S154C1, 5,
  &(vtc_S154C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(6584,5684), // object size
  NSPAIRA(_ZTI6S154C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S154C1),82, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S152C6  {
  void *s152c6f0;
  ::S1587C5_nt s152c6f1;
  char s152c6f2;
  int s152c6f3;
  virtual  ~S152C6(); // _ZN6S152C6D1Ev
  virtual void  v13(); // _ZN6S152C63v13Ev
  virtual void  v14(); // _ZN6S152C63v14Ev
  virtual void  v15(); // _ZN6S152C63v15Ev
  virtual void  v16(); // _ZN6S152C63v16Ev
  virtual void  v17(); // _ZN6S152C63v17Ev
  virtual void  v18(); // _ZN6S152C63v18Ev
  virtual void  v19(); // _ZN6S152C63v19Ev
  virtual void  v20(); // _ZN6S152C63v20Ev
  virtual void  v21(); // _ZN6S152C63v21Ev
  virtual void  v22(); // _ZN6S152C63v22Ev
  virtual void  v23(); // _ZN6S152C63v23Ev
  virtual void  v24(); // _ZN6S152C63v24Ev
  virtual void  v25(); // _ZN6S152C63v25Ev
  S152C6(); // tgen
};
//SIG(-1 S152C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 Fp FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fc Fi}


 S152C6 ::~S152C6(){ note_dtor("S152C6", this);}
void  S152C6 ::v13(){vfunc_called(this, "_ZN6S152C63v13Ev");}
void  S152C6 ::v14(){vfunc_called(this, "_ZN6S152C63v14Ev");}
void  S152C6 ::v15(){vfunc_called(this, "_ZN6S152C63v15Ev");}
void  S152C6 ::v16(){vfunc_called(this, "_ZN6S152C63v16Ev");}
void  S152C6 ::v17(){vfunc_called(this, "_ZN6S152C63v17Ev");}
void  S152C6 ::v18(){vfunc_called(this, "_ZN6S152C63v18Ev");}
void  S152C6 ::v19(){vfunc_called(this, "_ZN6S152C63v19Ev");}
void  S152C6 ::v20(){vfunc_called(this, "_ZN6S152C63v20Ev");}
void  S152C6 ::v21(){vfunc_called(this, "_ZN6S152C63v21Ev");}
void  S152C6 ::v22(){vfunc_called(this, "_ZN6S152C63v22Ev");}
void  S152C6 ::v23(){vfunc_called(this, "_ZN6S152C63v23Ev");}
void  S152C6 ::v24(){vfunc_called(this, "_ZN6S152C63v24Ev");}
void  S152C6 ::v25(){vfunc_called(this, "_ZN6S152C63v25Ev");}
S152C6 ::S152C6(){ note_ctor("S152C6", this);} // tgen

static void Test_S152C6()
{
  extern Class_Descriptor cd_S152C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_S152C6, buf);
    S152C6 *dp, &lv = *(dp=new (buf) S152C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(S152C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S152C6)");
    check_field_offset(lv, s152c6f0, ABISELECT(8,4), "S152C6.s152c6f0");
    check_field_offset(lv, s152c6f1, ABISELECT(16,8), "S152C6.s152c6f1");
    check_field_offset(lv, s152c6f2, ABISELECT(40,24), "S152C6.s152c6f2");
    check_field_offset(lv, s152c6f3, ABISELECT(44,28), "S152C6.s152c6f3");
    test_class_info(&lv, &cd_S152C6);
    dp->~S152C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS152C6(Test_S152C6, "S152C6", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN6S152C6C1Ev();
extern void _ZN6S152C6D1Ev();
Name_Map name_map_S152C6[] = {
  NSPAIR(_ZN6S152C6C1Ev),
  NSPAIR(_ZN6S152C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S152C6[];
extern void _ZN6S152C6D1Ev();
extern void _ZN6S152C6D0Ev();
extern void _ZN6S152C63v13Ev();
extern void _ZN6S152C63v14Ev();
extern void _ZN6S152C63v15Ev();
extern void _ZN6S152C63v16Ev();
extern void _ZN6S152C63v17Ev();
extern void _ZN6S152C63v18Ev();
extern void _ZN6S152C63v19Ev();
extern void _ZN6S152C63v20Ev();
extern void _ZN6S152C63v21Ev();
extern void _ZN6S152C63v22Ev();
extern void _ZN6S152C63v23Ev();
extern void _ZN6S152C63v24Ev();
extern void _ZN6S152C63v25Ev();
static  VTBL_ENTRY vtc_S152C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S152C6[0]),
  (VTBL_ENTRY)&_ZN6S152C6D1Ev,
  (VTBL_ENTRY)&_ZN6S152C6D0Ev,
  (VTBL_ENTRY)&_ZN6S152C63v13Ev,
  (VTBL_ENTRY)&_ZN6S152C63v14Ev,
  (VTBL_ENTRY)&_ZN6S152C63v15Ev,
  (VTBL_ENTRY)&_ZN6S152C63v16Ev,
  (VTBL_ENTRY)&_ZN6S152C63v17Ev,
  (VTBL_ENTRY)&_ZN6S152C63v18Ev,
  (VTBL_ENTRY)&_ZN6S152C63v19Ev,
  (VTBL_ENTRY)&_ZN6S152C63v20Ev,
  (VTBL_ENTRY)&_ZN6S152C63v21Ev,
  (VTBL_ENTRY)&_ZN6S152C63v22Ev,
  (VTBL_ENTRY)&_ZN6S152C63v23Ev,
  (VTBL_ENTRY)&_ZN6S152C63v24Ev,
  (VTBL_ENTRY)&_ZN6S152C63v25Ev,
};
extern VTBL_ENTRY _ZTI6S152C6[];
extern  VTBL_ENTRY _ZTV6S152C6[];
Class_Descriptor cd_S152C6 = {  "S152C6", // class name
  0,0,//no base classes
  &(vtc_S152C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI6S152C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S152C6),17, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S152C5  : S152C6 {
  void *s152c5f0[3];
  int s152c5f1;
  virtual  ~S152C5(); // _ZN6S152C5D1Ev
  virtual void  v26(); // _ZN6S152C53v26Ev
  virtual void  v27(); // _ZN6S152C53v27Ev
  virtual void  v28(); // _ZN6S152C53v28Ev
  virtual void  v29(); // _ZN6S152C53v29Ev
  virtual void  v30(); // _ZN6S152C53v30Ev
  virtual void  v31(); // _ZN6S152C53v31Ev
  virtual void  v32(); // _ZN6S152C53v32Ev
  virtual void  v33(); // _ZN6S152C53v33Ev
  virtual void  v34(); // _ZN6S152C53v34Ev
  virtual void  v35(); // _ZN6S152C53v35Ev
  virtual void  v36(); // _ZN6S152C53v36Ev
  S152C5(); // tgen
};
//SIG(-1 S152C5) C1{ BC2{ vd v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fc Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 Fp[3] Fi}


 S152C5 ::~S152C5(){ note_dtor("S152C5", this);}
void  S152C5 ::v26(){vfunc_called(this, "_ZN6S152C53v26Ev");}
void  S152C5 ::v27(){vfunc_called(this, "_ZN6S152C53v27Ev");}
void  S152C5 ::v28(){vfunc_called(this, "_ZN6S152C53v28Ev");}
void  S152C5 ::v29(){vfunc_called(this, "_ZN6S152C53v29Ev");}
void  S152C5 ::v30(){vfunc_called(this, "_ZN6S152C53v30Ev");}
void  S152C5 ::v31(){vfunc_called(this, "_ZN6S152C53v31Ev");}
void  S152C5 ::v32(){vfunc_called(this, "_ZN6S152C53v32Ev");}
void  S152C5 ::v33(){vfunc_called(this, "_ZN6S152C53v33Ev");}
void  S152C5 ::v34(){vfunc_called(this, "_ZN6S152C53v34Ev");}
void  S152C5 ::v35(){vfunc_called(this, "_ZN6S152C53v35Ev");}
void  S152C5 ::v36(){vfunc_called(this, "_ZN6S152C53v36Ev");}
S152C5 ::S152C5(){ note_ctor("S152C5", this);} // tgen

static void Test_S152C5()
{
  extern Class_Descriptor cd_S152C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,13)];
    init_test(&cd_S152C5, buf);
    S152C5 *dp, &lv = *(dp=new (buf) S152C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,48), "sizeof(S152C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S152C5)");
    check_base_class_offset(lv, (S152C6*), 0, "S152C5");
    check_field_offset(lv, s152c5f0, ABISELECT(48,32), "S152C5.s152c5f0");
    check_field_offset(lv, s152c5f1, ABISELECT(72,44), "S152C5.s152c5f1");
    test_class_info(&lv, &cd_S152C5);
    dp->~S152C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS152C5(Test_S152C5, "S152C5", ABISELECT(80,48));

#else // __cplusplus

extern void _ZN6S152C5C1Ev();
extern void _ZN6S152C5D1Ev();
Name_Map name_map_S152C5[] = {
  NSPAIR(_ZN6S152C5C1Ev),
  NSPAIR(_ZN6S152C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S152C6;
extern VTBL_ENTRY _ZTI6S152C6[];
extern  VTBL_ENTRY _ZTV6S152C6[];
static Base_Class bases_S152C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S152C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S152C5[];
extern void _ZN6S152C5D1Ev();
extern void _ZN6S152C5D0Ev();
extern void _ZN6S152C63v13Ev();
extern void _ZN6S152C63v14Ev();
extern void _ZN6S152C63v15Ev();
extern void _ZN6S152C63v16Ev();
extern void _ZN6S152C63v17Ev();
extern void _ZN6S152C63v18Ev();
extern void _ZN6S152C63v19Ev();
extern void _ZN6S152C63v20Ev();
extern void _ZN6S152C63v21Ev();
extern void _ZN6S152C63v22Ev();
extern void _ZN6S152C63v23Ev();
extern void _ZN6S152C63v24Ev();
extern void _ZN6S152C63v25Ev();
extern void _ZN6S152C53v26Ev();
extern void _ZN6S152C53v27Ev();
extern void _ZN6S152C53v28Ev();
extern void _ZN6S152C53v29Ev();
extern void _ZN6S152C53v30Ev();
extern void _ZN6S152C53v31Ev();
extern void _ZN6S152C53v32Ev();
extern void _ZN6S152C53v33Ev();
extern void _ZN6S152C53v34Ev();
extern void _ZN6S152C53v35Ev();
extern void _ZN6S152C53v36Ev();
static  VTBL_ENTRY vtc_S152C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S152C5[0]),
  (VTBL_ENTRY)&_ZN6S152C5D1Ev,
  (VTBL_ENTRY)&_ZN6S152C5D0Ev,
  (VTBL_ENTRY)&_ZN6S152C63v13Ev,
  (VTBL_ENTRY)&_ZN6S152C63v14Ev,
  (VTBL_ENTRY)&_ZN6S152C63v15Ev,
  (VTBL_ENTRY)&_ZN6S152C63v16Ev,
  (VTBL_ENTRY)&_ZN6S152C63v17Ev,
  (VTBL_ENTRY)&_ZN6S152C63v18Ev,
  (VTBL_ENTRY)&_ZN6S152C63v19Ev,
  (VTBL_ENTRY)&_ZN6S152C63v20Ev,
  (VTBL_ENTRY)&_ZN6S152C63v21Ev,
  (VTBL_ENTRY)&_ZN6S152C63v22Ev,
  (VTBL_ENTRY)&_ZN6S152C63v23Ev,
  (VTBL_ENTRY)&_ZN6S152C63v24Ev,
  (VTBL_ENTRY)&_ZN6S152C63v25Ev,
  (VTBL_ENTRY)&_ZN6S152C53v26Ev,
  (VTBL_ENTRY)&_ZN6S152C53v27Ev,
  (VTBL_ENTRY)&_ZN6S152C53v28Ev,
  (VTBL_ENTRY)&_ZN6S152C53v29Ev,
  (VTBL_ENTRY)&_ZN6S152C53v30Ev,
  (VTBL_ENTRY)&_ZN6S152C53v31Ev,
  (VTBL_ENTRY)&_ZN6S152C53v32Ev,
  (VTBL_ENTRY)&_ZN6S152C53v33Ev,
  (VTBL_ENTRY)&_ZN6S152C53v34Ev,
  (VTBL_ENTRY)&_ZN6S152C53v35Ev,
  (VTBL_ENTRY)&_ZN6S152C53v36Ev,
};
extern VTBL_ENTRY _ZTI6S152C5[];
extern  VTBL_ENTRY _ZTV6S152C5[];
Class_Descriptor cd_S152C5 = {  "S152C5", // class name
  bases_S152C5, 1,
  &(vtc_S152C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,48), // object size
  NSPAIRA(_ZTI6S152C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S152C5),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S152C4  : S152C5 {
  void *s152c4f0[2];
  int s152c4f1[3];
  ::S1587C5_nt s152c4f2;
  char s152c4f3;
  ::S1587C8_nt s152c4f4;
  char s152c4f5;
  int s152c4f6;
  char s152c4f7;
  int s152c4f8;
  char s152c4f9[2];
  int s152c4f10;
  char s152c4f11;
  virtual  ~S152C4(); // _ZN6S152C4D1Ev
  virtual void  v37(); // _ZN6S152C43v37Ev
  virtual void  v38(); // _ZN6S152C43v38Ev
  virtual void  v39(); // _ZN6S152C43v39Ev
  virtual void  v40(); // _ZN6S152C43v40Ev
  virtual void  v41(); // _ZN6S152C43v41Ev
  virtual void  v42(); // _ZN6S152C43v42Ev
  virtual void  v43(); // _ZN6S152C43v43Ev
  virtual void  v44(); // _ZN6S152C43v44Ev
  virtual void  v45(); // _ZN6S152C43v45Ev
  virtual void  v46(); // _ZN6S152C43v46Ev
  virtual void  v47(); // _ZN6S152C43v47Ev
  virtual void  v48(); // _ZN6S152C43v48Ev
  virtual void  v49(); // _ZN6S152C43v49Ev
  virtual void  v50(); // _ZN6S152C43v50Ev
  virtual void  v51(); // _ZN6S152C43v51Ev
  virtual void  v52(); // _ZN6S152C43v52Ev
  virtual void  v53(); // _ZN6S152C43v53Ev
  S152C4(); // tgen
};
//SIG(-1 S152C4) C1{ BC2{ BC3{ vd v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 Fp FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fc Fi} vd v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 Fp[3] Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 Fp[2] Fi[3] FC4 Fc FC7{ m FC8{ m FL}} Fc Fi Fc Fi Fc[2] Fi Fc}


 S152C4 ::~S152C4(){ note_dtor("S152C4", this);}
void  S152C4 ::v37(){vfunc_called(this, "_ZN6S152C43v37Ev");}
void  S152C4 ::v38(){vfunc_called(this, "_ZN6S152C43v38Ev");}
void  S152C4 ::v39(){vfunc_called(this, "_ZN6S152C43v39Ev");}
void  S152C4 ::v40(){vfunc_called(this, "_ZN6S152C43v40Ev");}
void  S152C4 ::v41(){vfunc_called(this, "_ZN6S152C43v41Ev");}
void  S152C4 ::v42(){vfunc_called(this, "_ZN6S152C43v42Ev");}
void  S152C4 ::v43(){vfunc_called(this, "_ZN6S152C43v43Ev");}
void  S152C4 ::v44(){vfunc_called(this, "_ZN6S152C43v44Ev");}
void  S152C4 ::v45(){vfunc_called(this, "_ZN6S152C43v45Ev");}
void  S152C4 ::v46(){vfunc_called(this, "_ZN6S152C43v46Ev");}
void  S152C4 ::v47(){vfunc_called(this, "_ZN6S152C43v47Ev");}
void  S152C4 ::v48(){vfunc_called(this, "_ZN6S152C43v48Ev");}
void  S152C4 ::v49(){vfunc_called(this, "_ZN6S152C43v49Ev");}
void  S152C4 ::v50(){vfunc_called(this, "_ZN6S152C43v50Ev");}
void  S152C4 ::v51(){vfunc_called(this, "_ZN6S152C43v51Ev");}
void  S152C4 ::v52(){vfunc_called(this, "_ZN6S152C43v52Ev");}
void  S152C4 ::v53(){vfunc_called(this, "_ZN6S152C43v53Ev");}
S152C4 ::S152C4(){ note_ctor("S152C4", this);} // tgen

static void Test_S152C4()
{
  extern Class_Descriptor cd_S152C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,32)];
    init_test(&cd_S152C4, buf);
    S152C4 *dp, &lv = *(dp=new (buf) S152C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,124), "sizeof(S152C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S152C4)");
    check_base_class_offset(lv, (S152C6*)(S152C5*), 0, "S152C4");
    check_base_class_offset(lv, (S152C5*), 0, "S152C4");
    check_field_offset(lv, s152c4f0, ABISELECT(80,48), "S152C4.s152c4f0");
    check_field_offset(lv, s152c4f1, ABISELECT(96,56), "S152C4.s152c4f1");
    check_field_offset(lv, s152c4f2, ABISELECT(112,68), "S152C4.s152c4f2");
    check_field_offset(lv, s152c4f3, ABISELECT(136,84), "S152C4.s152c4f3");
    check_field_offset(lv, s152c4f4, ABISELECT(144,88), "S152C4.s152c4f4");
    check_field_offset(lv, s152c4f5, ABISELECT(152,96), "S152C4.s152c4f5");
    check_field_offset(lv, s152c4f6, ABISELECT(156,100), "S152C4.s152c4f6");
    check_field_offset(lv, s152c4f7, ABISELECT(160,104), "S152C4.s152c4f7");
    check_field_offset(lv, s152c4f8, ABISELECT(164,108), "S152C4.s152c4f8");
    check_field_offset(lv, s152c4f9, ABISELECT(168,112), "S152C4.s152c4f9");
    check_field_offset(lv, s152c4f10, ABISELECT(172,116), "S152C4.s152c4f10");
    check_field_offset(lv, s152c4f11, ABISELECT(176,120), "S152C4.s152c4f11");
    test_class_info(&lv, &cd_S152C4);
    dp->~S152C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS152C4(Test_S152C4, "S152C4", ABISELECT(184,124));

#else // __cplusplus

extern void _ZN6S152C4C1Ev();
extern void _ZN6S152C4D1Ev();
Name_Map name_map_S152C4[] = {
  NSPAIR(_ZN6S152C4C1Ev),
  NSPAIR(_ZN6S152C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S152C6;
extern VTBL_ENTRY _ZTI6S152C6[];
extern  VTBL_ENTRY _ZTV6S152C6[];
extern Class_Descriptor cd_S152C5;
extern VTBL_ENTRY _ZTI6S152C5[];
extern  VTBL_ENTRY _ZTV6S152C5[];
static Base_Class bases_S152C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S152C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S152C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S152C4[];
extern void _ZN6S152C4D1Ev();
extern void _ZN6S152C4D0Ev();
extern void _ZN6S152C63v13Ev();
extern void _ZN6S152C63v14Ev();
extern void _ZN6S152C63v15Ev();
extern void _ZN6S152C63v16Ev();
extern void _ZN6S152C63v17Ev();
extern void _ZN6S152C63v18Ev();
extern void _ZN6S152C63v19Ev();
extern void _ZN6S152C63v20Ev();
extern void _ZN6S152C63v21Ev();
extern void _ZN6S152C63v22Ev();
extern void _ZN6S152C63v23Ev();
extern void _ZN6S152C63v24Ev();
extern void _ZN6S152C63v25Ev();
extern void _ZN6S152C53v26Ev();
extern void _ZN6S152C53v27Ev();
extern void _ZN6S152C53v28Ev();
extern void _ZN6S152C53v29Ev();
extern void _ZN6S152C53v30Ev();
extern void _ZN6S152C53v31Ev();
extern void _ZN6S152C53v32Ev();
extern void _ZN6S152C53v33Ev();
extern void _ZN6S152C53v34Ev();
extern void _ZN6S152C53v35Ev();
extern void _ZN6S152C53v36Ev();
extern void _ZN6S152C43v37Ev();
extern void _ZN6S152C43v38Ev();
extern void _ZN6S152C43v39Ev();
extern void _ZN6S152C43v40Ev();
extern void _ZN6S152C43v41Ev();
extern void _ZN6S152C43v42Ev();
extern void _ZN6S152C43v43Ev();
extern void _ZN6S152C43v44Ev();
extern void _ZN6S152C43v45Ev();
extern void _ZN6S152C43v46Ev();
extern void _ZN6S152C43v47Ev();
extern void _ZN6S152C43v48Ev();
extern void _ZN6S152C43v49Ev();
extern void _ZN6S152C43v50Ev();
extern void _ZN6S152C43v51Ev();
extern void _ZN6S152C43v52Ev();
extern void _ZN6S152C43v53Ev();
static  VTBL_ENTRY vtc_S152C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S152C4[0]),
  (VTBL_ENTRY)&_ZN6S152C4D1Ev,
  (VTBL_ENTRY)&_ZN6S152C4D0Ev,
  (VTBL_ENTRY)&_ZN6S152C63v13Ev,
  (VTBL_ENTRY)&_ZN6S152C63v14Ev,
  (VTBL_ENTRY)&_ZN6S152C63v15Ev,
  (VTBL_ENTRY)&_ZN6S152C63v16Ev,
  (VTBL_ENTRY)&_ZN6S152C63v17Ev,
  (VTBL_ENTRY)&_ZN6S152C63v18Ev,
  (VTBL_ENTRY)&_ZN6S152C63v19Ev,
  (VTBL_ENTRY)&_ZN6S152C63v20Ev,
  (VTBL_ENTRY)&_ZN6S152C63v21Ev,
  (VTBL_ENTRY)&_ZN6S152C63v22Ev,
  (VTBL_ENTRY)&_ZN6S152C63v23Ev,
  (VTBL_ENTRY)&_ZN6S152C63v24Ev,
  (VTBL_ENTRY)&_ZN6S152C63v25Ev,
  (VTBL_ENTRY)&_ZN6S152C53v26Ev,
  (VTBL_ENTRY)&_ZN6S152C53v27Ev,
  (VTBL_ENTRY)&_ZN6S152C53v28Ev,
  (VTBL_ENTRY)&_ZN6S152C53v29Ev,
  (VTBL_ENTRY)&_ZN6S152C53v30Ev,
  (VTBL_ENTRY)&_ZN6S152C53v31Ev,
  (VTBL_ENTRY)&_ZN6S152C53v32Ev,
  (VTBL_ENTRY)&_ZN6S152C53v33Ev,
  (VTBL_ENTRY)&_ZN6S152C53v34Ev,
  (VTBL_ENTRY)&_ZN6S152C53v35Ev,
  (VTBL_ENTRY)&_ZN6S152C53v36Ev,
  (VTBL_ENTRY)&_ZN6S152C43v37Ev,
  (VTBL_ENTRY)&_ZN6S152C43v38Ev,
  (VTBL_ENTRY)&_ZN6S152C43v39Ev,
  (VTBL_ENTRY)&_ZN6S152C43v40Ev,
  (VTBL_ENTRY)&_ZN6S152C43v41Ev,
  (VTBL_ENTRY)&_ZN6S152C43v42Ev,
  (VTBL_ENTRY)&_ZN6S152C43v43Ev,
  (VTBL_ENTRY)&_ZN6S152C43v44Ev,
  (VTBL_ENTRY)&_ZN6S152C43v45Ev,
  (VTBL_ENTRY)&_ZN6S152C43v46Ev,
  (VTBL_ENTRY)&_ZN6S152C43v47Ev,
  (VTBL_ENTRY)&_ZN6S152C43v48Ev,
  (VTBL_ENTRY)&_ZN6S152C43v49Ev,
  (VTBL_ENTRY)&_ZN6S152C43v50Ev,
  (VTBL_ENTRY)&_ZN6S152C43v51Ev,
  (VTBL_ENTRY)&_ZN6S152C43v52Ev,
  (VTBL_ENTRY)&_ZN6S152C43v53Ev,
};
extern VTBL_ENTRY _ZTI6S152C4[];
extern  VTBL_ENTRY _ZTV6S152C4[];
Class_Descriptor cd_S152C4 = {  "S152C4", // class name
  bases_S152C4, 2,
  &(vtc_S152C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,124), // object size
  NSPAIRA(_ZTI6S152C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S152C4),45, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S152C3  : S152C4 {
  int s152c3f0[4];
  virtual  ~S152C3(); // _ZN6S152C3D1Ev
  virtual void  v54(); // _ZN6S152C33v54Ev
  virtual void  v55(); // _ZN6S152C33v55Ev
  virtual void  v56(); // _ZN6S152C33v56Ev
  virtual void  v57(); // _ZN6S152C33v57Ev
  virtual void  v58(); // _ZN6S152C33v58Ev
  virtual void  v59(); // _ZN6S152C33v59Ev
  virtual void  v60(); // _ZN6S152C33v60Ev
  virtual void  v61(); // _ZN6S152C33v61Ev
  virtual void  v62(); // _ZN6S152C33v62Ev
  virtual void  v63(); // _ZN6S152C33v63Ev
  virtual void  v64(); // _ZN6S152C33v64Ev
  virtual void  v65(); // _ZN6S152C33v65Ev
  virtual void  v66(); // _ZN6S152C33v66Ev
  S152C3(); // tgen
};
//SIG(-1 S152C3) C1{ BC2{ BC3{ BC4{ vd v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 Fp FC5{ m FC6{ m Fp Fi FC7{ m}} Fi} Fc Fi} vd v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 Fp[3] Fi} vd v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 Fp[2] Fi[3] FC5 Fc FC8{ m FC9{ m FL}} Fc Fi Fc Fi Fc[2] Fi Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 Fi[4]}


 S152C3 ::~S152C3(){ note_dtor("S152C3", this);}
void  S152C3 ::v54(){vfunc_called(this, "_ZN6S152C33v54Ev");}
void  S152C3 ::v55(){vfunc_called(this, "_ZN6S152C33v55Ev");}
void  S152C3 ::v56(){vfunc_called(this, "_ZN6S152C33v56Ev");}
void  S152C3 ::v57(){vfunc_called(this, "_ZN6S152C33v57Ev");}
void  S152C3 ::v58(){vfunc_called(this, "_ZN6S152C33v58Ev");}
void  S152C3 ::v59(){vfunc_called(this, "_ZN6S152C33v59Ev");}
void  S152C3 ::v60(){vfunc_called(this, "_ZN6S152C33v60Ev");}
void  S152C3 ::v61(){vfunc_called(this, "_ZN6S152C33v61Ev");}
void  S152C3 ::v62(){vfunc_called(this, "_ZN6S152C33v62Ev");}
void  S152C3 ::v63(){vfunc_called(this, "_ZN6S152C33v63Ev");}
void  S152C3 ::v64(){vfunc_called(this, "_ZN6S152C33v64Ev");}
void  S152C3 ::v65(){vfunc_called(this, "_ZN6S152C33v65Ev");}
void  S152C3 ::v66(){vfunc_called(this, "_ZN6S152C33v66Ev");}
S152C3 ::S152C3(){ note_ctor("S152C3", this);} // tgen

static void Test_S152C3()
{
  extern Class_Descriptor cd_S152C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,36)];
    init_test(&cd_S152C3, buf);
    S152C3 *dp, &lv = *(dp=new (buf) S152C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,140), "sizeof(S152C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S152C3)");
    check_base_class_offset(lv, (S152C6*)(S152C5*)(S152C4*), 0, "S152C3");
    check_base_class_offset(lv, (S152C5*)(S152C4*), 0, "S152C3");
    check_base_class_offset(lv, (S152C4*), 0, "S152C3");
    check_field_offset(lv, s152c3f0, ABISELECT(180,124), "S152C3.s152c3f0");
    test_class_info(&lv, &cd_S152C3);
    dp->~S152C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS152C3(Test_S152C3, "S152C3", ABISELECT(200,140));

#else // __cplusplus

extern void _ZN6S152C3C1Ev();
extern void _ZN6S152C3D1Ev();
Name_Map name_map_S152C3[] = {
  NSPAIR(_ZN6S152C3C1Ev),
  NSPAIR(_ZN6S152C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S152C6;
extern VTBL_ENTRY _ZTI6S152C6[];
extern  VTBL_ENTRY _ZTV6S152C6[];
extern Class_Descriptor cd_S152C5;
extern VTBL_ENTRY _ZTI6S152C5[];
extern  VTBL_ENTRY _ZTV6S152C5[];
extern Class_Descriptor cd_S152C4;
extern VTBL_ENTRY _ZTI6S152C4[];
extern  VTBL_ENTRY _ZTV6S152C4[];
static Base_Class bases_S152C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S152C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S152C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S152C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S152C3[];
extern void _ZN6S152C3D1Ev();
extern void _ZN6S152C3D0Ev();
extern void _ZN6S152C63v13Ev();
extern void _ZN6S152C63v14Ev();
extern void _ZN6S152C63v15Ev();
extern void _ZN6S152C63v16Ev();
extern void _ZN6S152C63v17Ev();
extern void _ZN6S152C63v18Ev();
extern void _ZN6S152C63v19Ev();
extern void _ZN6S152C63v20Ev();
extern void _ZN6S152C63v21Ev();
extern void _ZN6S152C63v22Ev();
extern void _ZN6S152C63v23Ev();
extern void _ZN6S152C63v24Ev();
extern void _ZN6S152C63v25Ev();
extern void _ZN6S152C53v26Ev();
extern void _ZN6S152C53v27Ev();
extern void _ZN6S152C53v28Ev();
extern void _ZN6S152C53v29Ev();
extern void _ZN6S152C53v30Ev();
extern void _ZN6S152C53v31Ev();
extern void _ZN6S152C53v32Ev();
extern void _ZN6S152C53v33Ev();
extern void _ZN6S152C53v34Ev();
extern void _ZN6S152C53v35Ev();
extern void _ZN6S152C53v36Ev();
extern void _ZN6S152C43v37Ev();
extern void _ZN6S152C43v38Ev();
extern void _ZN6S152C43v39Ev();
extern void _ZN6S152C43v40Ev();
extern void _ZN6S152C43v41Ev();
extern void _ZN6S152C43v42Ev();
extern void _ZN6S152C43v43Ev();
extern void _ZN6S152C43v44Ev();
extern void _ZN6S152C43v45Ev();
extern void _ZN6S152C43v46Ev();
extern void _ZN6S152C43v47Ev();
extern void _ZN6S152C43v48Ev();
extern void _ZN6S152C43v49Ev();
extern void _ZN6S152C43v50Ev();
extern void _ZN6S152C43v51Ev();
extern void _ZN6S152C43v52Ev();
extern void _ZN6S152C43v53Ev();
extern void _ZN6S152C33v54Ev();
extern void _ZN6S152C33v55Ev();
extern void _ZN6S152C33v56Ev();
extern void _ZN6S152C33v57Ev();
extern void _ZN6S152C33v58Ev();
extern void _ZN6S152C33v59Ev();
extern void _ZN6S152C33v60Ev();
extern void _ZN6S152C33v61Ev();
extern void _ZN6S152C33v62Ev();
extern void _ZN6S152C33v63Ev();
extern void _ZN6S152C33v64Ev();
extern void _ZN6S152C33v65Ev();
extern void _ZN6S152C33v66Ev();
static  VTBL_ENTRY vtc_S152C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S152C3[0]),
  (VTBL_ENTRY)&_ZN6S152C3D1Ev,
  (VTBL_ENTRY)&_ZN6S152C3D0Ev,
  (VTBL_ENTRY)&_ZN6S152C63v13Ev,
  (VTBL_ENTRY)&_ZN6S152C63v14Ev,
  (VTBL_ENTRY)&_ZN6S152C63v15Ev,
  (VTBL_ENTRY)&_ZN6S152C63v16Ev,
  (VTBL_ENTRY)&_ZN6S152C63v17Ev,
  (VTBL_ENTRY)&_ZN6S152C63v18Ev,
  (VTBL_ENTRY)&_ZN6S152C63v19Ev,
  (VTBL_ENTRY)&_ZN6S152C63v20Ev,
  (VTBL_ENTRY)&_ZN6S152C63v21Ev,
  (VTBL_ENTRY)&_ZN6S152C63v22Ev,
  (VTBL_ENTRY)&_ZN6S152C63v23Ev,
  (VTBL_ENTRY)&_ZN6S152C63v24Ev,
  (VTBL_ENTRY)&_ZN6S152C63v25Ev,
  (VTBL_ENTRY)&_ZN6S152C53v26Ev,
  (VTBL_ENTRY)&_ZN6S152C53v27Ev,
  (VTBL_ENTRY)&_ZN6S152C53v28Ev,
  (VTBL_ENTRY)&_ZN6S152C53v29Ev,
  (VTBL_ENTRY)&_ZN6S152C53v30Ev,
  (VTBL_ENTRY)&_ZN6S152C53v31Ev,
  (VTBL_ENTRY)&_ZN6S152C53v32Ev,
  (VTBL_ENTRY)&_ZN6S152C53v33Ev,
  (VTBL_ENTRY)&_ZN6S152C53v34Ev,
  (VTBL_ENTRY)&_ZN6S152C53v35Ev,
  (VTBL_ENTRY)&_ZN6S152C53v36Ev,
  (VTBL_ENTRY)&_ZN6S152C43v37Ev,
  (VTBL_ENTRY)&_ZN6S152C43v38Ev,
  (VTBL_ENTRY)&_ZN6S152C43v39Ev,
  (VTBL_ENTRY)&_ZN6S152C43v40Ev,
  (VTBL_ENTRY)&_ZN6S152C43v41Ev,
  (VTBL_ENTRY)&_ZN6S152C43v42Ev,
  (VTBL_ENTRY)&_ZN6S152C43v43Ev,
  (VTBL_ENTRY)&_ZN6S152C43v44Ev,
  (VTBL_ENTRY)&_ZN6S152C43v45Ev,
  (VTBL_ENTRY)&_ZN6S152C43v46Ev,
  (VTBL_ENTRY)&_ZN6S152C43v47Ev,
  (VTBL_ENTRY)&_ZN6S152C43v48Ev,
  (VTBL_ENTRY)&_ZN6S152C43v49Ev,
  (VTBL_ENTRY)&_ZN6S152C43v50Ev,
  (VTBL_ENTRY)&_ZN6S152C43v51Ev,
  (VTBL_ENTRY)&_ZN6S152C43v52Ev,
  (VTBL_ENTRY)&_ZN6S152C43v53Ev,
  (VTBL_ENTRY)&_ZN6S152C33v54Ev,
  (VTBL_ENTRY)&_ZN6S152C33v55Ev,
  (VTBL_ENTRY)&_ZN6S152C33v56Ev,
  (VTBL_ENTRY)&_ZN6S152C33v57Ev,
  (VTBL_ENTRY)&_ZN6S152C33v58Ev,
  (VTBL_ENTRY)&_ZN6S152C33v59Ev,
  (VTBL_ENTRY)&_ZN6S152C33v60Ev,
  (VTBL_ENTRY)&_ZN6S152C33v61Ev,
  (VTBL_ENTRY)&_ZN6S152C33v62Ev,
  (VTBL_ENTRY)&_ZN6S152C33v63Ev,
  (VTBL_ENTRY)&_ZN6S152C33v64Ev,
  (VTBL_ENTRY)&_ZN6S152C33v65Ev,
  (VTBL_ENTRY)&_ZN6S152C33v66Ev,
};
extern VTBL_ENTRY _ZTI6S152C3[];
extern  VTBL_ENTRY _ZTV6S152C3[];
Class_Descriptor cd_S152C3 = {  "S152C3", // class name
  bases_S152C3, 3,
  &(vtc_S152C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,140), // object size
  NSPAIRA(_ZTI6S152C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S152C3),58, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S152C2  : S152C3 {
  void *s152c2f0;
  char s152c2f1;
  int s152c2f2;
  char s152c2f3[3];
  int s152c2f4;
  ::S154C12 s152c2f5;
  int s152c2f6[2];
  virtual  ~S152C2(); // _ZN6S152C2D1Ev
  virtual void  v67(); // _ZN6S152C23v67Ev
  virtual void  v68(); // _ZN6S152C23v68Ev
  virtual void  v69(); // _ZN6S152C23v69Ev
  virtual void  v70(); // _ZN6S152C23v70Ev
  virtual void  v71(); // _ZN6S152C23v71Ev
  virtual void  v72(); // _ZN6S152C23v72Ev
  virtual void  v73(); // _ZN6S152C23v73Ev
  virtual void  v74(); // _ZN6S152C23v74Ev
  virtual void  v75(); // _ZN6S152C23v75Ev
  virtual void  v76(); // _ZN6S152C23v76Ev
  S152C2(); // tgen
};
//SIG(-1 S152C2) C1{ BC2{ BC3{ BC4{ BC5{ vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} Fc Fi} vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 Fp[3] Fi} vd v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 Fp[2] Fi[3] FC6 Fc FC9{ m FC10{ m FL}} Fc Fi Fc Fi Fc[2] Fi Fc} vd v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi[4]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp Fc Fi Fc[3] Fi FC11{ m Fi Fp Fi} Fi[2]}


 S152C2 ::~S152C2(){ note_dtor("S152C2", this);}
void  S152C2 ::v67(){vfunc_called(this, "_ZN6S152C23v67Ev");}
void  S152C2 ::v68(){vfunc_called(this, "_ZN6S152C23v68Ev");}
void  S152C2 ::v69(){vfunc_called(this, "_ZN6S152C23v69Ev");}
void  S152C2 ::v70(){vfunc_called(this, "_ZN6S152C23v70Ev");}
void  S152C2 ::v71(){vfunc_called(this, "_ZN6S152C23v71Ev");}
void  S152C2 ::v72(){vfunc_called(this, "_ZN6S152C23v72Ev");}
void  S152C2 ::v73(){vfunc_called(this, "_ZN6S152C23v73Ev");}
void  S152C2 ::v74(){vfunc_called(this, "_ZN6S152C23v74Ev");}
void  S152C2 ::v75(){vfunc_called(this, "_ZN6S152C23v75Ev");}
void  S152C2 ::v76(){vfunc_called(this, "_ZN6S152C23v76Ev");}
S152C2 ::S152C2(){ note_ctor("S152C2", this);} // tgen

static void Test_S152C2()
{
  extern Class_Descriptor cd_S152C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,46)];
    init_test(&cd_S152C2, buf);
    S152C2 *dp, &lv = *(dp=new (buf) S152C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,180), "sizeof(S152C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S152C2)");
    check_base_class_offset(lv, (S152C6*)(S152C5*)(S152C4*)(S152C3*), 0, "S152C2");
    check_base_class_offset(lv, (S152C5*)(S152C4*)(S152C3*), 0, "S152C2");
    check_base_class_offset(lv, (S152C4*)(S152C3*), 0, "S152C2");
    check_base_class_offset(lv, (S152C3*), 0, "S152C2");
    check_field_offset(lv, s152c2f0, ABISELECT(200,140), "S152C2.s152c2f0");
    check_field_offset(lv, s152c2f1, ABISELECT(208,144), "S152C2.s152c2f1");
    check_field_offset(lv, s152c2f2, ABISELECT(212,148), "S152C2.s152c2f2");
    check_field_offset(lv, s152c2f3, ABISELECT(216,152), "S152C2.s152c2f3");
    check_field_offset(lv, s152c2f4, ABISELECT(220,156), "S152C2.s152c2f4");
    check_field_offset(lv, s152c2f5, ABISELECT(224,160), "S152C2.s152c2f5");
    check_field_offset(lv, s152c2f6, ABISELECT(248,172), "S152C2.s152c2f6");
    test_class_info(&lv, &cd_S152C2);
    dp->~S152C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS152C2(Test_S152C2, "S152C2", ABISELECT(256,180));

#else // __cplusplus

extern void _ZN6S152C2C1Ev();
extern void _ZN6S152C2D1Ev();
Name_Map name_map_S152C2[] = {
  NSPAIR(_ZN6S152C2C1Ev),
  NSPAIR(_ZN6S152C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S152C6;
extern VTBL_ENTRY _ZTI6S152C6[];
extern  VTBL_ENTRY _ZTV6S152C6[];
extern Class_Descriptor cd_S152C5;
extern VTBL_ENTRY _ZTI6S152C5[];
extern  VTBL_ENTRY _ZTV6S152C5[];
extern Class_Descriptor cd_S152C4;
extern VTBL_ENTRY _ZTI6S152C4[];
extern  VTBL_ENTRY _ZTV6S152C4[];
extern Class_Descriptor cd_S152C3;
extern VTBL_ENTRY _ZTI6S152C3[];
extern  VTBL_ENTRY _ZTV6S152C3[];
static Base_Class bases_S152C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S152C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S152C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S152C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S152C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S152C2[];
extern void _ZN6S152C2D1Ev();
extern void _ZN6S152C2D0Ev();
extern void _ZN6S152C63v13Ev();
extern void _ZN6S152C63v14Ev();
extern void _ZN6S152C63v15Ev();
extern void _ZN6S152C63v16Ev();
extern void _ZN6S152C63v17Ev();
extern void _ZN6S152C63v18Ev();
extern void _ZN6S152C63v19Ev();
extern void _ZN6S152C63v20Ev();
extern void _ZN6S152C63v21Ev();
extern void _ZN6S152C63v22Ev();
extern void _ZN6S152C63v23Ev();
extern void _ZN6S152C63v24Ev();
extern void _ZN6S152C63v25Ev();
extern void _ZN6S152C53v26Ev();
extern void _ZN6S152C53v27Ev();
extern void _ZN6S152C53v28Ev();
extern void _ZN6S152C53v29Ev();
extern void _ZN6S152C53v30Ev();
extern void _ZN6S152C53v31Ev();
extern void _ZN6S152C53v32Ev();
extern void _ZN6S152C53v33Ev();
extern void _ZN6S152C53v34Ev();
extern void _ZN6S152C53v35Ev();
extern void _ZN6S152C53v36Ev();
extern void _ZN6S152C43v37Ev();
extern void _ZN6S152C43v38Ev();
extern void _ZN6S152C43v39Ev();
extern void _ZN6S152C43v40Ev();
extern void _ZN6S152C43v41Ev();
extern void _ZN6S152C43v42Ev();
extern void _ZN6S152C43v43Ev();
extern void _ZN6S152C43v44Ev();
extern void _ZN6S152C43v45Ev();
extern void _ZN6S152C43v46Ev();
extern void _ZN6S152C43v47Ev();
extern void _ZN6S152C43v48Ev();
extern void _ZN6S152C43v49Ev();
extern void _ZN6S152C43v50Ev();
extern void _ZN6S152C43v51Ev();
extern void _ZN6S152C43v52Ev();
extern void _ZN6S152C43v53Ev();
extern void _ZN6S152C33v54Ev();
extern void _ZN6S152C33v55Ev();
extern void _ZN6S152C33v56Ev();
extern void _ZN6S152C33v57Ev();
extern void _ZN6S152C33v58Ev();
extern void _ZN6S152C33v59Ev();
extern void _ZN6S152C33v60Ev();
extern void _ZN6S152C33v61Ev();
extern void _ZN6S152C33v62Ev();
extern void _ZN6S152C33v63Ev();
extern void _ZN6S152C33v64Ev();
extern void _ZN6S152C33v65Ev();
extern void _ZN6S152C33v66Ev();
extern void _ZN6S152C23v67Ev();
extern void _ZN6S152C23v68Ev();
extern void _ZN6S152C23v69Ev();
extern void _ZN6S152C23v70Ev();
extern void _ZN6S152C23v71Ev();
extern void _ZN6S152C23v72Ev();
extern void _ZN6S152C23v73Ev();
extern void _ZN6S152C23v74Ev();
extern void _ZN6S152C23v75Ev();
extern void _ZN6S152C23v76Ev();
static  VTBL_ENTRY vtc_S152C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S152C2[0]),
  (VTBL_ENTRY)&_ZN6S152C2D1Ev,
  (VTBL_ENTRY)&_ZN6S152C2D0Ev,
  (VTBL_ENTRY)&_ZN6S152C63v13Ev,
  (VTBL_ENTRY)&_ZN6S152C63v14Ev,
  (VTBL_ENTRY)&_ZN6S152C63v15Ev,
  (VTBL_ENTRY)&_ZN6S152C63v16Ev,
  (VTBL_ENTRY)&_ZN6S152C63v17Ev,
  (VTBL_ENTRY)&_ZN6S152C63v18Ev,
  (VTBL_ENTRY)&_ZN6S152C63v19Ev,
  (VTBL_ENTRY)&_ZN6S152C63v20Ev,
  (VTBL_ENTRY)&_ZN6S152C63v21Ev,
  (VTBL_ENTRY)&_ZN6S152C63v22Ev,
  (VTBL_ENTRY)&_ZN6S152C63v23Ev,
  (VTBL_ENTRY)&_ZN6S152C63v24Ev,
  (VTBL_ENTRY)&_ZN6S152C63v25Ev,
  (VTBL_ENTRY)&_ZN6S152C53v26Ev,
  (VTBL_ENTRY)&_ZN6S152C53v27Ev,
  (VTBL_ENTRY)&_ZN6S152C53v28Ev,
  (VTBL_ENTRY)&_ZN6S152C53v29Ev,
  (VTBL_ENTRY)&_ZN6S152C53v30Ev,
  (VTBL_ENTRY)&_ZN6S152C53v31Ev,
  (VTBL_ENTRY)&_ZN6S152C53v32Ev,
  (VTBL_ENTRY)&_ZN6S152C53v33Ev,
  (VTBL_ENTRY)&_ZN6S152C53v34Ev,
  (VTBL_ENTRY)&_ZN6S152C53v35Ev,
  (VTBL_ENTRY)&_ZN6S152C53v36Ev,
  (VTBL_ENTRY)&_ZN6S152C43v37Ev,
  (VTBL_ENTRY)&_ZN6S152C43v38Ev,
  (VTBL_ENTRY)&_ZN6S152C43v39Ev,
  (VTBL_ENTRY)&_ZN6S152C43v40Ev,
  (VTBL_ENTRY)&_ZN6S152C43v41Ev,
  (VTBL_ENTRY)&_ZN6S152C43v42Ev,
  (VTBL_ENTRY)&_ZN6S152C43v43Ev,
  (VTBL_ENTRY)&_ZN6S152C43v44Ev,
  (VTBL_ENTRY)&_ZN6S152C43v45Ev,
  (VTBL_ENTRY)&_ZN6S152C43v46Ev,
  (VTBL_ENTRY)&_ZN6S152C43v47Ev,
  (VTBL_ENTRY)&_ZN6S152C43v48Ev,
  (VTBL_ENTRY)&_ZN6S152C43v49Ev,
  (VTBL_ENTRY)&_ZN6S152C43v50Ev,
  (VTBL_ENTRY)&_ZN6S152C43v51Ev,
  (VTBL_ENTRY)&_ZN6S152C43v52Ev,
  (VTBL_ENTRY)&_ZN6S152C43v53Ev,
  (VTBL_ENTRY)&_ZN6S152C33v54Ev,
  (VTBL_ENTRY)&_ZN6S152C33v55Ev,
  (VTBL_ENTRY)&_ZN6S152C33v56Ev,
  (VTBL_ENTRY)&_ZN6S152C33v57Ev,
  (VTBL_ENTRY)&_ZN6S152C33v58Ev,
  (VTBL_ENTRY)&_ZN6S152C33v59Ev,
  (VTBL_ENTRY)&_ZN6S152C33v60Ev,
  (VTBL_ENTRY)&_ZN6S152C33v61Ev,
  (VTBL_ENTRY)&_ZN6S152C33v62Ev,
  (VTBL_ENTRY)&_ZN6S152C33v63Ev,
  (VTBL_ENTRY)&_ZN6S152C33v64Ev,
  (VTBL_ENTRY)&_ZN6S152C33v65Ev,
  (VTBL_ENTRY)&_ZN6S152C33v66Ev,
  (VTBL_ENTRY)&_ZN6S152C23v67Ev,
  (VTBL_ENTRY)&_ZN6S152C23v68Ev,
  (VTBL_ENTRY)&_ZN6S152C23v69Ev,
  (VTBL_ENTRY)&_ZN6S152C23v70Ev,
  (VTBL_ENTRY)&_ZN6S152C23v71Ev,
  (VTBL_ENTRY)&_ZN6S152C23v72Ev,
  (VTBL_ENTRY)&_ZN6S152C23v73Ev,
  (VTBL_ENTRY)&_ZN6S152C23v74Ev,
  (VTBL_ENTRY)&_ZN6S152C23v75Ev,
  (VTBL_ENTRY)&_ZN6S152C23v76Ev,
};
extern VTBL_ENTRY _ZTI6S152C2[];
extern  VTBL_ENTRY _ZTV6S152C2[];
Class_Descriptor cd_S152C2 = {  "S152C2", // class name
  bases_S152C2, 4,
  &(vtc_S152C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,180), // object size
  NSPAIRA(_ZTI6S152C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S152C2),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S152C14  {
  char s152c14f0;
  int s152c14f1;
  char s152c14f2[97];
};
//SIG(-1 S152C14) C1{ Fc Fi Fc[97]}



static void Test_S152C14()
{
  {
    init_simple_test("S152C14");
    S152C14 lv;
    check2(sizeof(lv), 108, "sizeof(S152C14)");
    check2(__alignof__(lv), 4, "__alignof__(S152C14)");
    check_field_offset(lv, s152c14f0, 0, "S152C14.s152c14f0");
    check_field_offset(lv, s152c14f1, 4, "S152C14.s152c14f1");
    check_field_offset(lv, s152c14f2, 8, "S152C14.s152c14f2");
  }
}
static Arrange_To_Call_Me vS152C14(Test_S152C14, "S152C14", 108);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S152C1  : S152C2 {
  ::S1587C17 s152c1f0;
  char s152c1f1;
  int s152c1f2;
  ::S152C14 s152c1f3;
  int s152c1f4;
  ::S1587C27 s152c1f5;
  ::S1587C18 s152c1f6;
  int s152c1f7;
  ::S1587C18 s152c1f8;
  ::S1587C18 s152c1f9;
  ::S154C27_nt s152c1f10;
  ::S154C32 s152c1f11;
  ::S1587C13 s152c1f12;
  __tsi64 s152c1f13;
  ::S1587C8_nt s152c1f14;
  void *s152c1f15;
  virtual  ~S152C1(); // _ZN6S152C1D1Ev
  virtual void  v1(); // _ZN6S152C12v1Ev
  virtual void  v2(); // _ZN6S152C12v2Ev
  virtual void  v3(); // _ZN6S152C12v3Ev
  virtual void  v4(); // _ZN6S152C12v4Ev
  virtual void  v5(); // _ZN6S152C12v5Ev
  virtual void  v6(); // _ZN6S152C12v6Ev
  virtual void  v7(); // _ZN6S152C12v7Ev
  virtual void  v8(); // _ZN6S152C12v8Ev
  virtual void  v9(); // _ZN6S152C12v9Ev
  virtual void  v10(); // _ZN6S152C13v10Ev
  virtual void  v11(); // _ZN6S152C13v11Ev
  virtual void  v12(); // _ZN6S152C13v12Ev
  S152C1(); // tgen
};
//SIG(1 S152C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 Fp FC7{ m FC8{ m Fp Fi FC9{ m}} Fi} Fc Fi} vd v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 Fp[3] Fi} vd v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 Fp[2] Fi[3] FC7 Fc FC10{ m FC11{ m FL}} Fc Fi Fc Fi Fc[2] Fi Fc} vd v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi[4]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 Fp Fc Fi Fc[3] Fi FC12{ m Fi Fp Fi} Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 FC13{ m Fp[2] Fi[2]} Fc Fi FC14{ Fc Fi Fc[97]} Fi FC15{ m FC16{ m Fp[2]} FC8 FC17{ FC18{ Fc[20]} Fc[16]}} FC19{ m FC13 Fp[2] Fc Fp FC20{ m Fp[2]} FC20 FC16 Fp Fi FC21{ Fi[3] FC22{ Fi} FC23{ Fi[3]}} Fi[3] Fc FC23 Fi} Fi FC19 FC19 FC24{ m FC25{ m Fp[2]}} FC26{ BC27{ vd v82 v83 v84 v85 v86 v87 v88 Fp[3] Fi[3] Fc[3] Fi[8] Fc[2] Fp[6] Fi[3]} vd v77 v78 v79 v80 v81 Fc[2] FC28{ Fc[65] FC17 Fi[2] FL Fi} FC29{ Fi Fc[815] Fi[5]} FC30{ Fi FC31{ Fc[33] Fi Fc FC8 Fi Fc}[5]} Fc FC32{ Fp[2] Fi[2] FL Fc[193]} FC33{ BC34{ vd v91 v92 v93 FL Fp Fi} vd v89 v90 Fi Fc} FC33[5] FL Fi[5] FL[5] FC35{ m Fc Fp[2]} FC9 FC36{ m Fp FC37{ BC38{ m Fp Fi} Fp} Fc Fp} FC39{ BC27 vd v94 v95 v96 v97 v98 Fc[2] Fi Fp FL Fi FC40{ Fi Fc[331] Fi[2] Fc Fi Fc[812] Fi[5] Fc} FC41{ Fi[2] Fc[271] FL Fc[193] Fi Fc[65] Fi[2] Fc[96] FL Fc[68]} Fi FC33 FC33 FC42{ BC33 vd v99 Fp} FC36 FC35 FC43{ m FC16 Fi[3]} FC44{ m Fc[2] Fp} FC9 FC45{ m FC8 FC8 Fi FC20 Fp[2]} FC46{ m Fc Fi} FC24 FC47{ m Fp[2] Fi[2]} Fc FC33[5] Fc FC48{ m FC49{ m FL[2]}} Fc Fi[2] FC47} FC50{ m Fp[2]} FC50 Fi} FC36 FL FC10 Fp}


 S152C1 ::~S152C1(){ note_dtor("S152C1", this);}
void  S152C1 ::v1(){vfunc_called(this, "_ZN6S152C12v1Ev");}
void  S152C1 ::v2(){vfunc_called(this, "_ZN6S152C12v2Ev");}
void  S152C1 ::v3(){vfunc_called(this, "_ZN6S152C12v3Ev");}
void  S152C1 ::v4(){vfunc_called(this, "_ZN6S152C12v4Ev");}
void  S152C1 ::v5(){vfunc_called(this, "_ZN6S152C12v5Ev");}
void  S152C1 ::v6(){vfunc_called(this, "_ZN6S152C12v6Ev");}
void  S152C1 ::v7(){vfunc_called(this, "_ZN6S152C12v7Ev");}
void  S152C1 ::v8(){vfunc_called(this, "_ZN6S152C12v8Ev");}
void  S152C1 ::v9(){vfunc_called(this, "_ZN6S152C12v9Ev");}
void  S152C1 ::v10(){vfunc_called(this, "_ZN6S152C13v10Ev");}
void  S152C1 ::v11(){vfunc_called(this, "_ZN6S152C13v11Ev");}
void  S152C1 ::v12(){vfunc_called(this, "_ZN6S152C13v12Ev");}
S152C1 ::S152C1(){ note_ctor("S152C1", this);} // tgen

static void Test_S152C1()
{
  extern Class_Descriptor cd_S152C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(754,1300)];
    init_test(&cd_S152C1, buf);
    S152C1 *dp, &lv = *(dp=new (buf) S152C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(6024,5196), "sizeof(S152C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S152C1)");
    check_base_class_offset(lv, (S152C6*)(S152C5*)(S152C4*)(S152C3*)(S152C2*), 0, "S152C1");
    check_base_class_offset(lv, (S152C5*)(S152C4*)(S152C3*)(S152C2*), 0, "S152C1");
    check_base_class_offset(lv, (S152C4*)(S152C3*)(S152C2*), 0, "S152C1");
    check_base_class_offset(lv, (S152C3*)(S152C2*), 0, "S152C1");
    check_base_class_offset(lv, (S152C2*), 0, "S152C1");
    check_field_offset(lv, s152c1f0, ABISELECT(256,180), "S152C1.s152c1f0");
    check_field_offset(lv, s152c1f1, ABISELECT(280,196), "S152C1.s152c1f1");
    check_field_offset(lv, s152c1f2, ABISELECT(284,200), "S152C1.s152c1f2");
    check_field_offset(lv, s152c1f3, ABISELECT(288,204), "S152C1.s152c1f3");
    check_field_offset(lv, s152c1f4, ABISELECT(396,312), "S152C1.s152c1f4");
    check_field_offset(lv, s152c1f5, ABISELECT(400,316), "S152C1.s152c1f5");
    check_field_offset(lv, s152c1f6, ABISELECT(472,372), "S152C1.s152c1f6");
    check_field_offset(lv, s152c1f7, ABISELECT(648,496), "S152C1.s152c1f7");
    check_field_offset(lv, s152c1f8, ABISELECT(656,500), "S152C1.s152c1f8");
    check_field_offset(lv, s152c1f9, ABISELECT(832,624), "S152C1.s152c1f9");
    check_field_offset(lv, s152c1f10, ABISELECT(1008,748), "S152C1.s152c1f10");
    check_field_offset(lv, s152c1f11, ABISELECT(1024,756), "S152C1.s152c1f11");
    check_field_offset(lv, s152c1f12, ABISELECT(5952,5152), "S152C1.s152c1f12");
    check_field_offset(lv, s152c1f13, ABISELECT(6000,5176), "S152C1.s152c1f13");
    check_field_offset(lv, s152c1f14, ABISELECT(6008,5184), "S152C1.s152c1f14");
    check_field_offset(lv, s152c1f15, ABISELECT(6016,5192), "S152C1.s152c1f15");
    test_class_info(&lv, &cd_S152C1);
    dp->~S152C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS152C1(Test_S152C1, "S152C1", ABISELECT(6024,5196));

#else // __cplusplus

extern void _ZN6S152C1C1Ev();
extern void _ZN6S152C1D1Ev();
Name_Map name_map_S152C1[] = {
  NSPAIR(_ZN6S152C1C1Ev),
  NSPAIR(_ZN6S152C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S152C6;
extern VTBL_ENTRY _ZTI6S152C6[];
extern  VTBL_ENTRY _ZTV6S152C6[];
extern Class_Descriptor cd_S152C5;
extern VTBL_ENTRY _ZTI6S152C5[];
extern  VTBL_ENTRY _ZTV6S152C5[];
extern Class_Descriptor cd_S152C4;
extern VTBL_ENTRY _ZTI6S152C4[];
extern  VTBL_ENTRY _ZTV6S152C4[];
extern Class_Descriptor cd_S152C3;
extern VTBL_ENTRY _ZTI6S152C3[];
extern  VTBL_ENTRY _ZTV6S152C3[];
extern Class_Descriptor cd_S152C2;
extern VTBL_ENTRY _ZTI6S152C2[];
extern  VTBL_ENTRY _ZTV6S152C2[];
static Base_Class bases_S152C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S152C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S152C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S152C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S152C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S152C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S152C1[];
extern void _ZN6S152C1D1Ev();
extern void _ZN6S152C1D0Ev();
extern void _ZN6S152C63v13Ev();
extern void _ZN6S152C63v14Ev();
extern void _ZN6S152C63v15Ev();
extern void _ZN6S152C63v16Ev();
extern void _ZN6S152C63v17Ev();
extern void _ZN6S152C63v18Ev();
extern void _ZN6S152C63v19Ev();
extern void _ZN6S152C63v20Ev();
extern void _ZN6S152C63v21Ev();
extern void _ZN6S152C63v22Ev();
extern void _ZN6S152C63v23Ev();
extern void _ZN6S152C63v24Ev();
extern void _ZN6S152C63v25Ev();
extern void _ZN6S152C53v26Ev();
extern void _ZN6S152C53v27Ev();
extern void _ZN6S152C53v28Ev();
extern void _ZN6S152C53v29Ev();
extern void _ZN6S152C53v30Ev();
extern void _ZN6S152C53v31Ev();
extern void _ZN6S152C53v32Ev();
extern void _ZN6S152C53v33Ev();
extern void _ZN6S152C53v34Ev();
extern void _ZN6S152C53v35Ev();
extern void _ZN6S152C53v36Ev();
extern void _ZN6S152C43v37Ev();
extern void _ZN6S152C43v38Ev();
extern void _ZN6S152C43v39Ev();
extern void _ZN6S152C43v40Ev();
extern void _ZN6S152C43v41Ev();
extern void _ZN6S152C43v42Ev();
extern void _ZN6S152C43v43Ev();
extern void _ZN6S152C43v44Ev();
extern void _ZN6S152C43v45Ev();
extern void _ZN6S152C43v46Ev();
extern void _ZN6S152C43v47Ev();
extern void _ZN6S152C43v48Ev();
extern void _ZN6S152C43v49Ev();
extern void _ZN6S152C43v50Ev();
extern void _ZN6S152C43v51Ev();
extern void _ZN6S152C43v52Ev();
extern void _ZN6S152C43v53Ev();
extern void _ZN6S152C33v54Ev();
extern void _ZN6S152C33v55Ev();
extern void _ZN6S152C33v56Ev();
extern void _ZN6S152C33v57Ev();
extern void _ZN6S152C33v58Ev();
extern void _ZN6S152C33v59Ev();
extern void _ZN6S152C33v60Ev();
extern void _ZN6S152C33v61Ev();
extern void _ZN6S152C33v62Ev();
extern void _ZN6S152C33v63Ev();
extern void _ZN6S152C33v64Ev();
extern void _ZN6S152C33v65Ev();
extern void _ZN6S152C33v66Ev();
extern void _ZN6S152C23v67Ev();
extern void _ZN6S152C23v68Ev();
extern void _ZN6S152C23v69Ev();
extern void _ZN6S152C23v70Ev();
extern void _ZN6S152C23v71Ev();
extern void _ZN6S152C23v72Ev();
extern void _ZN6S152C23v73Ev();
extern void _ZN6S152C23v74Ev();
extern void _ZN6S152C23v75Ev();
extern void _ZN6S152C23v76Ev();
extern void _ZN6S152C12v1Ev();
extern void _ZN6S152C12v2Ev();
extern void _ZN6S152C12v3Ev();
extern void _ZN6S152C12v4Ev();
extern void _ZN6S152C12v5Ev();
extern void _ZN6S152C12v6Ev();
extern void _ZN6S152C12v7Ev();
extern void _ZN6S152C12v8Ev();
extern void _ZN6S152C12v9Ev();
extern void _ZN6S152C13v10Ev();
extern void _ZN6S152C13v11Ev();
extern void _ZN6S152C13v12Ev();
static  VTBL_ENTRY vtc_S152C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S152C1[0]),
  (VTBL_ENTRY)&_ZN6S152C1D1Ev,
  (VTBL_ENTRY)&_ZN6S152C1D0Ev,
  (VTBL_ENTRY)&_ZN6S152C63v13Ev,
  (VTBL_ENTRY)&_ZN6S152C63v14Ev,
  (VTBL_ENTRY)&_ZN6S152C63v15Ev,
  (VTBL_ENTRY)&_ZN6S152C63v16Ev,
  (VTBL_ENTRY)&_ZN6S152C63v17Ev,
  (VTBL_ENTRY)&_ZN6S152C63v18Ev,
  (VTBL_ENTRY)&_ZN6S152C63v19Ev,
  (VTBL_ENTRY)&_ZN6S152C63v20Ev,
  (VTBL_ENTRY)&_ZN6S152C63v21Ev,
  (VTBL_ENTRY)&_ZN6S152C63v22Ev,
  (VTBL_ENTRY)&_ZN6S152C63v23Ev,
  (VTBL_ENTRY)&_ZN6S152C63v24Ev,
  (VTBL_ENTRY)&_ZN6S152C63v25Ev,
  (VTBL_ENTRY)&_ZN6S152C53v26Ev,
  (VTBL_ENTRY)&_ZN6S152C53v27Ev,
  (VTBL_ENTRY)&_ZN6S152C53v28Ev,
  (VTBL_ENTRY)&_ZN6S152C53v29Ev,
  (VTBL_ENTRY)&_ZN6S152C53v30Ev,
  (VTBL_ENTRY)&_ZN6S152C53v31Ev,
  (VTBL_ENTRY)&_ZN6S152C53v32Ev,
  (VTBL_ENTRY)&_ZN6S152C53v33Ev,
  (VTBL_ENTRY)&_ZN6S152C53v34Ev,
  (VTBL_ENTRY)&_ZN6S152C53v35Ev,
  (VTBL_ENTRY)&_ZN6S152C53v36Ev,
  (VTBL_ENTRY)&_ZN6S152C43v37Ev,
  (VTBL_ENTRY)&_ZN6S152C43v38Ev,
  (VTBL_ENTRY)&_ZN6S152C43v39Ev,
  (VTBL_ENTRY)&_ZN6S152C43v40Ev,
  (VTBL_ENTRY)&_ZN6S152C43v41Ev,
  (VTBL_ENTRY)&_ZN6S152C43v42Ev,
  (VTBL_ENTRY)&_ZN6S152C43v43Ev,
  (VTBL_ENTRY)&_ZN6S152C43v44Ev,
  (VTBL_ENTRY)&_ZN6S152C43v45Ev,
  (VTBL_ENTRY)&_ZN6S152C43v46Ev,
  (VTBL_ENTRY)&_ZN6S152C43v47Ev,
  (VTBL_ENTRY)&_ZN6S152C43v48Ev,
  (VTBL_ENTRY)&_ZN6S152C43v49Ev,
  (VTBL_ENTRY)&_ZN6S152C43v50Ev,
  (VTBL_ENTRY)&_ZN6S152C43v51Ev,
  (VTBL_ENTRY)&_ZN6S152C43v52Ev,
  (VTBL_ENTRY)&_ZN6S152C43v53Ev,
  (VTBL_ENTRY)&_ZN6S152C33v54Ev,
  (VTBL_ENTRY)&_ZN6S152C33v55Ev,
  (VTBL_ENTRY)&_ZN6S152C33v56Ev,
  (VTBL_ENTRY)&_ZN6S152C33v57Ev,
  (VTBL_ENTRY)&_ZN6S152C33v58Ev,
  (VTBL_ENTRY)&_ZN6S152C33v59Ev,
  (VTBL_ENTRY)&_ZN6S152C33v60Ev,
  (VTBL_ENTRY)&_ZN6S152C33v61Ev,
  (VTBL_ENTRY)&_ZN6S152C33v62Ev,
  (VTBL_ENTRY)&_ZN6S152C33v63Ev,
  (VTBL_ENTRY)&_ZN6S152C33v64Ev,
  (VTBL_ENTRY)&_ZN6S152C33v65Ev,
  (VTBL_ENTRY)&_ZN6S152C33v66Ev,
  (VTBL_ENTRY)&_ZN6S152C23v67Ev,
  (VTBL_ENTRY)&_ZN6S152C23v68Ev,
  (VTBL_ENTRY)&_ZN6S152C23v69Ev,
  (VTBL_ENTRY)&_ZN6S152C23v70Ev,
  (VTBL_ENTRY)&_ZN6S152C23v71Ev,
  (VTBL_ENTRY)&_ZN6S152C23v72Ev,
  (VTBL_ENTRY)&_ZN6S152C23v73Ev,
  (VTBL_ENTRY)&_ZN6S152C23v74Ev,
  (VTBL_ENTRY)&_ZN6S152C23v75Ev,
  (VTBL_ENTRY)&_ZN6S152C23v76Ev,
  (VTBL_ENTRY)&_ZN6S152C12v1Ev,
  (VTBL_ENTRY)&_ZN6S152C12v2Ev,
  (VTBL_ENTRY)&_ZN6S152C12v3Ev,
  (VTBL_ENTRY)&_ZN6S152C12v4Ev,
  (VTBL_ENTRY)&_ZN6S152C12v5Ev,
  (VTBL_ENTRY)&_ZN6S152C12v6Ev,
  (VTBL_ENTRY)&_ZN6S152C12v7Ev,
  (VTBL_ENTRY)&_ZN6S152C12v8Ev,
  (VTBL_ENTRY)&_ZN6S152C12v9Ev,
  (VTBL_ENTRY)&_ZN6S152C13v10Ev,
  (VTBL_ENTRY)&_ZN6S152C13v11Ev,
  (VTBL_ENTRY)&_ZN6S152C13v12Ev,
};
extern VTBL_ENTRY _ZTI6S152C1[];
extern  VTBL_ENTRY _ZTV6S152C1[];
Class_Descriptor cd_S152C1 = {  "S152C1", // class name
  bases_S152C1, 5,
  &(vtc_S152C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(6024,5196), // object size
  NSPAIRA(_ZTI6S152C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S152C1),80, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S153C6  {
  void *s153c6f0;
  ::S1587C5_nt s153c6f1;
  char s153c6f2;
  int s153c6f3;
  virtual  ~S153C6(); // _ZN6S153C6D1Ev
  virtual void  v13(); // _ZN6S153C63v13Ev
  virtual void  v14(); // _ZN6S153C63v14Ev
  virtual void  v15(); // _ZN6S153C63v15Ev
  virtual void  v16(); // _ZN6S153C63v16Ev
  virtual void  v17(); // _ZN6S153C63v17Ev
  virtual void  v18(); // _ZN6S153C63v18Ev
  virtual void  v19(); // _ZN6S153C63v19Ev
  virtual void  v20(); // _ZN6S153C63v20Ev
  virtual void  v21(); // _ZN6S153C63v21Ev
  virtual void  v22(); // _ZN6S153C63v22Ev
  virtual void  v23(); // _ZN6S153C63v23Ev
  virtual void  v24(); // _ZN6S153C63v24Ev
  virtual void  v25(); // _ZN6S153C63v25Ev
  S153C6(); // tgen
};
//SIG(-1 S153C6) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 Fp FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fc Fi}


 S153C6 ::~S153C6(){ note_dtor("S153C6", this);}
void  S153C6 ::v13(){vfunc_called(this, "_ZN6S153C63v13Ev");}
void  S153C6 ::v14(){vfunc_called(this, "_ZN6S153C63v14Ev");}
void  S153C6 ::v15(){vfunc_called(this, "_ZN6S153C63v15Ev");}
void  S153C6 ::v16(){vfunc_called(this, "_ZN6S153C63v16Ev");}
void  S153C6 ::v17(){vfunc_called(this, "_ZN6S153C63v17Ev");}
void  S153C6 ::v18(){vfunc_called(this, "_ZN6S153C63v18Ev");}
void  S153C6 ::v19(){vfunc_called(this, "_ZN6S153C63v19Ev");}
void  S153C6 ::v20(){vfunc_called(this, "_ZN6S153C63v20Ev");}
void  S153C6 ::v21(){vfunc_called(this, "_ZN6S153C63v21Ev");}
void  S153C6 ::v22(){vfunc_called(this, "_ZN6S153C63v22Ev");}
void  S153C6 ::v23(){vfunc_called(this, "_ZN6S153C63v23Ev");}
void  S153C6 ::v24(){vfunc_called(this, "_ZN6S153C63v24Ev");}
void  S153C6 ::v25(){vfunc_called(this, "_ZN6S153C63v25Ev");}
S153C6 ::S153C6(){ note_ctor("S153C6", this);} // tgen

static void Test_S153C6()
{
  extern Class_Descriptor cd_S153C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_S153C6, buf);
    S153C6 *dp, &lv = *(dp=new (buf) S153C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(S153C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S153C6)");
    check_field_offset(lv, s153c6f0, ABISELECT(8,4), "S153C6.s153c6f0");
    check_field_offset(lv, s153c6f1, ABISELECT(16,8), "S153C6.s153c6f1");
    check_field_offset(lv, s153c6f2, ABISELECT(40,24), "S153C6.s153c6f2");
    check_field_offset(lv, s153c6f3, ABISELECT(44,28), "S153C6.s153c6f3");
    test_class_info(&lv, &cd_S153C6);
    dp->~S153C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS153C6(Test_S153C6, "S153C6", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN6S153C6C1Ev();
extern void _ZN6S153C6D1Ev();
Name_Map name_map_S153C6[] = {
  NSPAIR(_ZN6S153C6C1Ev),
  NSPAIR(_ZN6S153C6D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S153C6[];
extern void _ZN6S153C6D1Ev();
extern void _ZN6S153C6D0Ev();
extern void _ZN6S153C63v13Ev();
extern void _ZN6S153C63v14Ev();
extern void _ZN6S153C63v15Ev();
extern void _ZN6S153C63v16Ev();
extern void _ZN6S153C63v17Ev();
extern void _ZN6S153C63v18Ev();
extern void _ZN6S153C63v19Ev();
extern void _ZN6S153C63v20Ev();
extern void _ZN6S153C63v21Ev();
extern void _ZN6S153C63v22Ev();
extern void _ZN6S153C63v23Ev();
extern void _ZN6S153C63v24Ev();
extern void _ZN6S153C63v25Ev();
static  VTBL_ENTRY vtc_S153C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S153C6[0]),
  (VTBL_ENTRY)&_ZN6S153C6D1Ev,
  (VTBL_ENTRY)&_ZN6S153C6D0Ev,
  (VTBL_ENTRY)&_ZN6S153C63v13Ev,
  (VTBL_ENTRY)&_ZN6S153C63v14Ev,
  (VTBL_ENTRY)&_ZN6S153C63v15Ev,
  (VTBL_ENTRY)&_ZN6S153C63v16Ev,
  (VTBL_ENTRY)&_ZN6S153C63v17Ev,
  (VTBL_ENTRY)&_ZN6S153C63v18Ev,
  (VTBL_ENTRY)&_ZN6S153C63v19Ev,
  (VTBL_ENTRY)&_ZN6S153C63v20Ev,
  (VTBL_ENTRY)&_ZN6S153C63v21Ev,
  (VTBL_ENTRY)&_ZN6S153C63v22Ev,
  (VTBL_ENTRY)&_ZN6S153C63v23Ev,
  (VTBL_ENTRY)&_ZN6S153C63v24Ev,
  (VTBL_ENTRY)&_ZN6S153C63v25Ev,
};
extern VTBL_ENTRY _ZTI6S153C6[];
extern  VTBL_ENTRY _ZTV6S153C6[];
Class_Descriptor cd_S153C6 = {  "S153C6", // class name
  0,0,//no base classes
  &(vtc_S153C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI6S153C6),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S153C6),17, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S153C5  : S153C6 {
  void *s153c5f0[3];
  int s153c5f1;
  virtual  ~S153C5(); // _ZN6S153C5D1Ev
  virtual void  v26(); // _ZN6S153C53v26Ev
  virtual void  v27(); // _ZN6S153C53v27Ev
  virtual void  v28(); // _ZN6S153C53v28Ev
  virtual void  v29(); // _ZN6S153C53v29Ev
  virtual void  v30(); // _ZN6S153C53v30Ev
  virtual void  v31(); // _ZN6S153C53v31Ev
  virtual void  v32(); // _ZN6S153C53v32Ev
  virtual void  v33(); // _ZN6S153C53v33Ev
  virtual void  v34(); // _ZN6S153C53v34Ev
  virtual void  v35(); // _ZN6S153C53v35Ev
  virtual void  v36(); // _ZN6S153C53v36Ev
  S153C5(); // tgen
};
//SIG(-1 S153C5) C1{ BC2{ vd v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fc Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 Fp[3] Fi}


 S153C5 ::~S153C5(){ note_dtor("S153C5", this);}
void  S153C5 ::v26(){vfunc_called(this, "_ZN6S153C53v26Ev");}
void  S153C5 ::v27(){vfunc_called(this, "_ZN6S153C53v27Ev");}
void  S153C5 ::v28(){vfunc_called(this, "_ZN6S153C53v28Ev");}
void  S153C5 ::v29(){vfunc_called(this, "_ZN6S153C53v29Ev");}
void  S153C5 ::v30(){vfunc_called(this, "_ZN6S153C53v30Ev");}
void  S153C5 ::v31(){vfunc_called(this, "_ZN6S153C53v31Ev");}
void  S153C5 ::v32(){vfunc_called(this, "_ZN6S153C53v32Ev");}
void  S153C5 ::v33(){vfunc_called(this, "_ZN6S153C53v33Ev");}
void  S153C5 ::v34(){vfunc_called(this, "_ZN6S153C53v34Ev");}
void  S153C5 ::v35(){vfunc_called(this, "_ZN6S153C53v35Ev");}
void  S153C5 ::v36(){vfunc_called(this, "_ZN6S153C53v36Ev");}
S153C5 ::S153C5(){ note_ctor("S153C5", this);} // tgen

static void Test_S153C5()
{
  extern Class_Descriptor cd_S153C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,13)];
    init_test(&cd_S153C5, buf);
    S153C5 *dp, &lv = *(dp=new (buf) S153C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,48), "sizeof(S153C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S153C5)");
    check_base_class_offset(lv, (S153C6*), 0, "S153C5");
    check_field_offset(lv, s153c5f0, ABISELECT(48,32), "S153C5.s153c5f0");
    check_field_offset(lv, s153c5f1, ABISELECT(72,44), "S153C5.s153c5f1");
    test_class_info(&lv, &cd_S153C5);
    dp->~S153C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS153C5(Test_S153C5, "S153C5", ABISELECT(80,48));

#else // __cplusplus

extern void _ZN6S153C5C1Ev();
extern void _ZN6S153C5D1Ev();
Name_Map name_map_S153C5[] = {
  NSPAIR(_ZN6S153C5C1Ev),
  NSPAIR(_ZN6S153C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S153C6;
extern VTBL_ENTRY _ZTI6S153C6[];
extern  VTBL_ENTRY _ZTV6S153C6[];
static Base_Class bases_S153C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S153C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S153C5[];
extern void _ZN6S153C5D1Ev();
extern void _ZN6S153C5D0Ev();
extern void _ZN6S153C63v13Ev();
extern void _ZN6S153C63v14Ev();
extern void _ZN6S153C63v15Ev();
extern void _ZN6S153C63v16Ev();
extern void _ZN6S153C63v17Ev();
extern void _ZN6S153C63v18Ev();
extern void _ZN6S153C63v19Ev();
extern void _ZN6S153C63v20Ev();
extern void _ZN6S153C63v21Ev();
extern void _ZN6S153C63v22Ev();
extern void _ZN6S153C63v23Ev();
extern void _ZN6S153C63v24Ev();
extern void _ZN6S153C63v25Ev();
extern void _ZN6S153C53v26Ev();
extern void _ZN6S153C53v27Ev();
extern void _ZN6S153C53v28Ev();
extern void _ZN6S153C53v29Ev();
extern void _ZN6S153C53v30Ev();
extern void _ZN6S153C53v31Ev();
extern void _ZN6S153C53v32Ev();
extern void _ZN6S153C53v33Ev();
extern void _ZN6S153C53v34Ev();
extern void _ZN6S153C53v35Ev();
extern void _ZN6S153C53v36Ev();
static  VTBL_ENTRY vtc_S153C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S153C5[0]),
  (VTBL_ENTRY)&_ZN6S153C5D1Ev,
  (VTBL_ENTRY)&_ZN6S153C5D0Ev,
  (VTBL_ENTRY)&_ZN6S153C63v13Ev,
  (VTBL_ENTRY)&_ZN6S153C63v14Ev,
  (VTBL_ENTRY)&_ZN6S153C63v15Ev,
  (VTBL_ENTRY)&_ZN6S153C63v16Ev,
  (VTBL_ENTRY)&_ZN6S153C63v17Ev,
  (VTBL_ENTRY)&_ZN6S153C63v18Ev,
  (VTBL_ENTRY)&_ZN6S153C63v19Ev,
  (VTBL_ENTRY)&_ZN6S153C63v20Ev,
  (VTBL_ENTRY)&_ZN6S153C63v21Ev,
  (VTBL_ENTRY)&_ZN6S153C63v22Ev,
  (VTBL_ENTRY)&_ZN6S153C63v23Ev,
  (VTBL_ENTRY)&_ZN6S153C63v24Ev,
  (VTBL_ENTRY)&_ZN6S153C63v25Ev,
  (VTBL_ENTRY)&_ZN6S153C53v26Ev,
  (VTBL_ENTRY)&_ZN6S153C53v27Ev,
  (VTBL_ENTRY)&_ZN6S153C53v28Ev,
  (VTBL_ENTRY)&_ZN6S153C53v29Ev,
  (VTBL_ENTRY)&_ZN6S153C53v30Ev,
  (VTBL_ENTRY)&_ZN6S153C53v31Ev,
  (VTBL_ENTRY)&_ZN6S153C53v32Ev,
  (VTBL_ENTRY)&_ZN6S153C53v33Ev,
  (VTBL_ENTRY)&_ZN6S153C53v34Ev,
  (VTBL_ENTRY)&_ZN6S153C53v35Ev,
  (VTBL_ENTRY)&_ZN6S153C53v36Ev,
};
extern VTBL_ENTRY _ZTI6S153C5[];
extern  VTBL_ENTRY _ZTV6S153C5[];
Class_Descriptor cd_S153C5 = {  "S153C5", // class name
  bases_S153C5, 1,
  &(vtc_S153C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,48), // object size
  NSPAIRA(_ZTI6S153C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S153C5),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S153C4  : S153C5 {
  void *s153c4f0[2];
  int s153c4f1[3];
  ::S1587C5_nt s153c4f2;
  char s153c4f3;
  ::S1587C8_nt s153c4f4;
  char s153c4f5;
  int s153c4f6;
  char s153c4f7;
  int s153c4f8;
  char s153c4f9[2];
  int s153c4f10;
  char s153c4f11;
  virtual  ~S153C4(); // _ZN6S153C4D1Ev
  virtual void  v37(); // _ZN6S153C43v37Ev
  virtual void  v38(); // _ZN6S153C43v38Ev
  virtual void  v39(); // _ZN6S153C43v39Ev
  virtual void  v40(); // _ZN6S153C43v40Ev
  virtual void  v41(); // _ZN6S153C43v41Ev
  virtual void  v42(); // _ZN6S153C43v42Ev
  virtual void  v43(); // _ZN6S153C43v43Ev
  virtual void  v44(); // _ZN6S153C43v44Ev
  virtual void  v45(); // _ZN6S153C43v45Ev
  virtual void  v46(); // _ZN6S153C43v46Ev
  virtual void  v47(); // _ZN6S153C43v47Ev
  virtual void  v48(); // _ZN6S153C43v48Ev
  virtual void  v49(); // _ZN6S153C43v49Ev
  virtual void  v50(); // _ZN6S153C43v50Ev
  virtual void  v51(); // _ZN6S153C43v51Ev
  virtual void  v52(); // _ZN6S153C43v52Ev
  virtual void  v53(); // _ZN6S153C43v53Ev
  S153C4(); // tgen
};
//SIG(-1 S153C4) C1{ BC2{ BC3{ vd v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 Fp FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fc Fi} vd v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 Fp[3] Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 Fp[2] Fi[3] FC4 Fc FC7{ m FC8{ m FL}} Fc Fi Fc Fi Fc[2] Fi Fc}


 S153C4 ::~S153C4(){ note_dtor("S153C4", this);}
void  S153C4 ::v37(){vfunc_called(this, "_ZN6S153C43v37Ev");}
void  S153C4 ::v38(){vfunc_called(this, "_ZN6S153C43v38Ev");}
void  S153C4 ::v39(){vfunc_called(this, "_ZN6S153C43v39Ev");}
void  S153C4 ::v40(){vfunc_called(this, "_ZN6S153C43v40Ev");}
void  S153C4 ::v41(){vfunc_called(this, "_ZN6S153C43v41Ev");}
void  S153C4 ::v42(){vfunc_called(this, "_ZN6S153C43v42Ev");}
void  S153C4 ::v43(){vfunc_called(this, "_ZN6S153C43v43Ev");}
void  S153C4 ::v44(){vfunc_called(this, "_ZN6S153C43v44Ev");}
void  S153C4 ::v45(){vfunc_called(this, "_ZN6S153C43v45Ev");}
void  S153C4 ::v46(){vfunc_called(this, "_ZN6S153C43v46Ev");}
void  S153C4 ::v47(){vfunc_called(this, "_ZN6S153C43v47Ev");}
void  S153C4 ::v48(){vfunc_called(this, "_ZN6S153C43v48Ev");}
void  S153C4 ::v49(){vfunc_called(this, "_ZN6S153C43v49Ev");}
void  S153C4 ::v50(){vfunc_called(this, "_ZN6S153C43v50Ev");}
void  S153C4 ::v51(){vfunc_called(this, "_ZN6S153C43v51Ev");}
void  S153C4 ::v52(){vfunc_called(this, "_ZN6S153C43v52Ev");}
void  S153C4 ::v53(){vfunc_called(this, "_ZN6S153C43v53Ev");}
S153C4 ::S153C4(){ note_ctor("S153C4", this);} // tgen

static void Test_S153C4()
{
  extern Class_Descriptor cd_S153C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,32)];
    init_test(&cd_S153C4, buf);
    S153C4 *dp, &lv = *(dp=new (buf) S153C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,124), "sizeof(S153C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S153C4)");
    check_base_class_offset(lv, (S153C6*)(S153C5*), 0, "S153C4");
    check_base_class_offset(lv, (S153C5*), 0, "S153C4");
    check_field_offset(lv, s153c4f0, ABISELECT(80,48), "S153C4.s153c4f0");
    check_field_offset(lv, s153c4f1, ABISELECT(96,56), "S153C4.s153c4f1");
    check_field_offset(lv, s153c4f2, ABISELECT(112,68), "S153C4.s153c4f2");
    check_field_offset(lv, s153c4f3, ABISELECT(136,84), "S153C4.s153c4f3");
    check_field_offset(lv, s153c4f4, ABISELECT(144,88), "S153C4.s153c4f4");
    check_field_offset(lv, s153c4f5, ABISELECT(152,96), "S153C4.s153c4f5");
    check_field_offset(lv, s153c4f6, ABISELECT(156,100), "S153C4.s153c4f6");
    check_field_offset(lv, s153c4f7, ABISELECT(160,104), "S153C4.s153c4f7");
    check_field_offset(lv, s153c4f8, ABISELECT(164,108), "S153C4.s153c4f8");
    check_field_offset(lv, s153c4f9, ABISELECT(168,112), "S153C4.s153c4f9");
    check_field_offset(lv, s153c4f10, ABISELECT(172,116), "S153C4.s153c4f10");
    check_field_offset(lv, s153c4f11, ABISELECT(176,120), "S153C4.s153c4f11");
    test_class_info(&lv, &cd_S153C4);
    dp->~S153C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS153C4(Test_S153C4, "S153C4", ABISELECT(184,124));

#else // __cplusplus

extern void _ZN6S153C4C1Ev();
extern void _ZN6S153C4D1Ev();
Name_Map name_map_S153C4[] = {
  NSPAIR(_ZN6S153C4C1Ev),
  NSPAIR(_ZN6S153C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S153C6;
extern VTBL_ENTRY _ZTI6S153C6[];
extern  VTBL_ENTRY _ZTV6S153C6[];
extern Class_Descriptor cd_S153C5;
extern VTBL_ENTRY _ZTI6S153C5[];
extern  VTBL_ENTRY _ZTV6S153C5[];
static Base_Class bases_S153C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S153C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S153C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S153C4[];
extern void _ZN6S153C4D1Ev();
extern void _ZN6S153C4D0Ev();
extern void _ZN6S153C63v13Ev();
extern void _ZN6S153C63v14Ev();
extern void _ZN6S153C63v15Ev();
extern void _ZN6S153C63v16Ev();
extern void _ZN6S153C63v17Ev();
extern void _ZN6S153C63v18Ev();
extern void _ZN6S153C63v19Ev();
extern void _ZN6S153C63v20Ev();
extern void _ZN6S153C63v21Ev();
extern void _ZN6S153C63v22Ev();
extern void _ZN6S153C63v23Ev();
extern void _ZN6S153C63v24Ev();
extern void _ZN6S153C63v25Ev();
extern void _ZN6S153C53v26Ev();
extern void _ZN6S153C53v27Ev();
extern void _ZN6S153C53v28Ev();
extern void _ZN6S153C53v29Ev();
extern void _ZN6S153C53v30Ev();
extern void _ZN6S153C53v31Ev();
extern void _ZN6S153C53v32Ev();
extern void _ZN6S153C53v33Ev();
extern void _ZN6S153C53v34Ev();
extern void _ZN6S153C53v35Ev();
extern void _ZN6S153C53v36Ev();
extern void _ZN6S153C43v37Ev();
extern void _ZN6S153C43v38Ev();
extern void _ZN6S153C43v39Ev();
extern void _ZN6S153C43v40Ev();
extern void _ZN6S153C43v41Ev();
extern void _ZN6S153C43v42Ev();
extern void _ZN6S153C43v43Ev();
extern void _ZN6S153C43v44Ev();
extern void _ZN6S153C43v45Ev();
extern void _ZN6S153C43v46Ev();
extern void _ZN6S153C43v47Ev();
extern void _ZN6S153C43v48Ev();
extern void _ZN6S153C43v49Ev();
extern void _ZN6S153C43v50Ev();
extern void _ZN6S153C43v51Ev();
extern void _ZN6S153C43v52Ev();
extern void _ZN6S153C43v53Ev();
static  VTBL_ENTRY vtc_S153C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S153C4[0]),
  (VTBL_ENTRY)&_ZN6S153C4D1Ev,
  (VTBL_ENTRY)&_ZN6S153C4D0Ev,
  (VTBL_ENTRY)&_ZN6S153C63v13Ev,
  (VTBL_ENTRY)&_ZN6S153C63v14Ev,
  (VTBL_ENTRY)&_ZN6S153C63v15Ev,
  (VTBL_ENTRY)&_ZN6S153C63v16Ev,
  (VTBL_ENTRY)&_ZN6S153C63v17Ev,
  (VTBL_ENTRY)&_ZN6S153C63v18Ev,
  (VTBL_ENTRY)&_ZN6S153C63v19Ev,
  (VTBL_ENTRY)&_ZN6S153C63v20Ev,
  (VTBL_ENTRY)&_ZN6S153C63v21Ev,
  (VTBL_ENTRY)&_ZN6S153C63v22Ev,
  (VTBL_ENTRY)&_ZN6S153C63v23Ev,
  (VTBL_ENTRY)&_ZN6S153C63v24Ev,
  (VTBL_ENTRY)&_ZN6S153C63v25Ev,
  (VTBL_ENTRY)&_ZN6S153C53v26Ev,
  (VTBL_ENTRY)&_ZN6S153C53v27Ev,
  (VTBL_ENTRY)&_ZN6S153C53v28Ev,
  (VTBL_ENTRY)&_ZN6S153C53v29Ev,
  (VTBL_ENTRY)&_ZN6S153C53v30Ev,
  (VTBL_ENTRY)&_ZN6S153C53v31Ev,
  (VTBL_ENTRY)&_ZN6S153C53v32Ev,
  (VTBL_ENTRY)&_ZN6S153C53v33Ev,
  (VTBL_ENTRY)&_ZN6S153C53v34Ev,
  (VTBL_ENTRY)&_ZN6S153C53v35Ev,
  (VTBL_ENTRY)&_ZN6S153C53v36Ev,
  (VTBL_ENTRY)&_ZN6S153C43v37Ev,
  (VTBL_ENTRY)&_ZN6S153C43v38Ev,
  (VTBL_ENTRY)&_ZN6S153C43v39Ev,
  (VTBL_ENTRY)&_ZN6S153C43v40Ev,
  (VTBL_ENTRY)&_ZN6S153C43v41Ev,
  (VTBL_ENTRY)&_ZN6S153C43v42Ev,
  (VTBL_ENTRY)&_ZN6S153C43v43Ev,
  (VTBL_ENTRY)&_ZN6S153C43v44Ev,
  (VTBL_ENTRY)&_ZN6S153C43v45Ev,
  (VTBL_ENTRY)&_ZN6S153C43v46Ev,
  (VTBL_ENTRY)&_ZN6S153C43v47Ev,
  (VTBL_ENTRY)&_ZN6S153C43v48Ev,
  (VTBL_ENTRY)&_ZN6S153C43v49Ev,
  (VTBL_ENTRY)&_ZN6S153C43v50Ev,
  (VTBL_ENTRY)&_ZN6S153C43v51Ev,
  (VTBL_ENTRY)&_ZN6S153C43v52Ev,
  (VTBL_ENTRY)&_ZN6S153C43v53Ev,
};
extern VTBL_ENTRY _ZTI6S153C4[];
extern  VTBL_ENTRY _ZTV6S153C4[];
Class_Descriptor cd_S153C4 = {  "S153C4", // class name
  bases_S153C4, 2,
  &(vtc_S153C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,124), // object size
  NSPAIRA(_ZTI6S153C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S153C4),45, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S153C3  : S153C4 {
  int s153c3f0[4];
  virtual  ~S153C3(); // _ZN6S153C3D1Ev
  virtual void  v54(); // _ZN6S153C33v54Ev
  virtual void  v55(); // _ZN6S153C33v55Ev
  virtual void  v56(); // _ZN6S153C33v56Ev
  virtual void  v57(); // _ZN6S153C33v57Ev
  virtual void  v58(); // _ZN6S153C33v58Ev
  virtual void  v59(); // _ZN6S153C33v59Ev
  virtual void  v60(); // _ZN6S153C33v60Ev
  virtual void  v61(); // _ZN6S153C33v61Ev
  virtual void  v62(); // _ZN6S153C33v62Ev
  virtual void  v63(); // _ZN6S153C33v63Ev
  virtual void  v64(); // _ZN6S153C33v64Ev
  virtual void  v65(); // _ZN6S153C33v65Ev
  virtual void  v66(); // _ZN6S153C33v66Ev
  S153C3(); // tgen
};
//SIG(-1 S153C3) C1{ BC2{ BC3{ BC4{ vd v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 Fp FC5{ m FC6{ m Fp Fi FC7{ m}} Fi} Fc Fi} vd v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 Fp[3] Fi} vd v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 Fp[2] Fi[3] FC5 Fc FC8{ m FC9{ m FL}} Fc Fi Fc Fi Fc[2] Fi Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 Fi[4]}


 S153C3 ::~S153C3(){ note_dtor("S153C3", this);}
void  S153C3 ::v54(){vfunc_called(this, "_ZN6S153C33v54Ev");}
void  S153C3 ::v55(){vfunc_called(this, "_ZN6S153C33v55Ev");}
void  S153C3 ::v56(){vfunc_called(this, "_ZN6S153C33v56Ev");}
void  S153C3 ::v57(){vfunc_called(this, "_ZN6S153C33v57Ev");}
void  S153C3 ::v58(){vfunc_called(this, "_ZN6S153C33v58Ev");}
void  S153C3 ::v59(){vfunc_called(this, "_ZN6S153C33v59Ev");}
void  S153C3 ::v60(){vfunc_called(this, "_ZN6S153C33v60Ev");}
void  S153C3 ::v61(){vfunc_called(this, "_ZN6S153C33v61Ev");}
void  S153C3 ::v62(){vfunc_called(this, "_ZN6S153C33v62Ev");}
void  S153C3 ::v63(){vfunc_called(this, "_ZN6S153C33v63Ev");}
void  S153C3 ::v64(){vfunc_called(this, "_ZN6S153C33v64Ev");}
void  S153C3 ::v65(){vfunc_called(this, "_ZN6S153C33v65Ev");}
void  S153C3 ::v66(){vfunc_called(this, "_ZN6S153C33v66Ev");}
S153C3 ::S153C3(){ note_ctor("S153C3", this);} // tgen

static void Test_S153C3()
{
  extern Class_Descriptor cd_S153C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,36)];
    init_test(&cd_S153C3, buf);
    S153C3 *dp, &lv = *(dp=new (buf) S153C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,140), "sizeof(S153C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S153C3)");
    check_base_class_offset(lv, (S153C6*)(S153C5*)(S153C4*), 0, "S153C3");
    check_base_class_offset(lv, (S153C5*)(S153C4*), 0, "S153C3");
    check_base_class_offset(lv, (S153C4*), 0, "S153C3");
    check_field_offset(lv, s153c3f0, ABISELECT(180,124), "S153C3.s153c3f0");
    test_class_info(&lv, &cd_S153C3);
    dp->~S153C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS153C3(Test_S153C3, "S153C3", ABISELECT(200,140));

#else // __cplusplus

extern void _ZN6S153C3C1Ev();
extern void _ZN6S153C3D1Ev();
Name_Map name_map_S153C3[] = {
  NSPAIR(_ZN6S153C3C1Ev),
  NSPAIR(_ZN6S153C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S153C6;
extern VTBL_ENTRY _ZTI6S153C6[];
extern  VTBL_ENTRY _ZTV6S153C6[];
extern Class_Descriptor cd_S153C5;
extern VTBL_ENTRY _ZTI6S153C5[];
extern  VTBL_ENTRY _ZTV6S153C5[];
extern Class_Descriptor cd_S153C4;
extern VTBL_ENTRY _ZTI6S153C4[];
extern  VTBL_ENTRY _ZTV6S153C4[];
static Base_Class bases_S153C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S153C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S153C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S153C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S153C3[];
extern void _ZN6S153C3D1Ev();
extern void _ZN6S153C3D0Ev();
extern void _ZN6S153C63v13Ev();
extern void _ZN6S153C63v14Ev();
extern void _ZN6S153C63v15Ev();
extern void _ZN6S153C63v16Ev();
extern void _ZN6S153C63v17Ev();
extern void _ZN6S153C63v18Ev();
extern void _ZN6S153C63v19Ev();
extern void _ZN6S153C63v20Ev();
extern void _ZN6S153C63v21Ev();
extern void _ZN6S153C63v22Ev();
extern void _ZN6S153C63v23Ev();
extern void _ZN6S153C63v24Ev();
extern void _ZN6S153C63v25Ev();
extern void _ZN6S153C53v26Ev();
extern void _ZN6S153C53v27Ev();
extern void _ZN6S153C53v28Ev();
extern void _ZN6S153C53v29Ev();
extern void _ZN6S153C53v30Ev();
extern void _ZN6S153C53v31Ev();
extern void _ZN6S153C53v32Ev();
extern void _ZN6S153C53v33Ev();
extern void _ZN6S153C53v34Ev();
extern void _ZN6S153C53v35Ev();
extern void _ZN6S153C53v36Ev();
extern void _ZN6S153C43v37Ev();
extern void _ZN6S153C43v38Ev();
extern void _ZN6S153C43v39Ev();
extern void _ZN6S153C43v40Ev();
extern void _ZN6S153C43v41Ev();
extern void _ZN6S153C43v42Ev();
extern void _ZN6S153C43v43Ev();
extern void _ZN6S153C43v44Ev();
extern void _ZN6S153C43v45Ev();
extern void _ZN6S153C43v46Ev();
extern void _ZN6S153C43v47Ev();
extern void _ZN6S153C43v48Ev();
extern void _ZN6S153C43v49Ev();
extern void _ZN6S153C43v50Ev();
extern void _ZN6S153C43v51Ev();
extern void _ZN6S153C43v52Ev();
extern void _ZN6S153C43v53Ev();
extern void _ZN6S153C33v54Ev();
extern void _ZN6S153C33v55Ev();
extern void _ZN6S153C33v56Ev();
extern void _ZN6S153C33v57Ev();
extern void _ZN6S153C33v58Ev();
extern void _ZN6S153C33v59Ev();
extern void _ZN6S153C33v60Ev();
extern void _ZN6S153C33v61Ev();
extern void _ZN6S153C33v62Ev();
extern void _ZN6S153C33v63Ev();
extern void _ZN6S153C33v64Ev();
extern void _ZN6S153C33v65Ev();
extern void _ZN6S153C33v66Ev();
static  VTBL_ENTRY vtc_S153C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S153C3[0]),
  (VTBL_ENTRY)&_ZN6S153C3D1Ev,
  (VTBL_ENTRY)&_ZN6S153C3D0Ev,
  (VTBL_ENTRY)&_ZN6S153C63v13Ev,
  (VTBL_ENTRY)&_ZN6S153C63v14Ev,
  (VTBL_ENTRY)&_ZN6S153C63v15Ev,
  (VTBL_ENTRY)&_ZN6S153C63v16Ev,
  (VTBL_ENTRY)&_ZN6S153C63v17Ev,
  (VTBL_ENTRY)&_ZN6S153C63v18Ev,
  (VTBL_ENTRY)&_ZN6S153C63v19Ev,
  (VTBL_ENTRY)&_ZN6S153C63v20Ev,
  (VTBL_ENTRY)&_ZN6S153C63v21Ev,
  (VTBL_ENTRY)&_ZN6S153C63v22Ev,
  (VTBL_ENTRY)&_ZN6S153C63v23Ev,
  (VTBL_ENTRY)&_ZN6S153C63v24Ev,
  (VTBL_ENTRY)&_ZN6S153C63v25Ev,
  (VTBL_ENTRY)&_ZN6S153C53v26Ev,
  (VTBL_ENTRY)&_ZN6S153C53v27Ev,
  (VTBL_ENTRY)&_ZN6S153C53v28Ev,
  (VTBL_ENTRY)&_ZN6S153C53v29Ev,
  (VTBL_ENTRY)&_ZN6S153C53v30Ev,
  (VTBL_ENTRY)&_ZN6S153C53v31Ev,
  (VTBL_ENTRY)&_ZN6S153C53v32Ev,
  (VTBL_ENTRY)&_ZN6S153C53v33Ev,
  (VTBL_ENTRY)&_ZN6S153C53v34Ev,
  (VTBL_ENTRY)&_ZN6S153C53v35Ev,
  (VTBL_ENTRY)&_ZN6S153C53v36Ev,
  (VTBL_ENTRY)&_ZN6S153C43v37Ev,
  (VTBL_ENTRY)&_ZN6S153C43v38Ev,
  (VTBL_ENTRY)&_ZN6S153C43v39Ev,
  (VTBL_ENTRY)&_ZN6S153C43v40Ev,
  (VTBL_ENTRY)&_ZN6S153C43v41Ev,
  (VTBL_ENTRY)&_ZN6S153C43v42Ev,
  (VTBL_ENTRY)&_ZN6S153C43v43Ev,
  (VTBL_ENTRY)&_ZN6S153C43v44Ev,
  (VTBL_ENTRY)&_ZN6S153C43v45Ev,
  (VTBL_ENTRY)&_ZN6S153C43v46Ev,
  (VTBL_ENTRY)&_ZN6S153C43v47Ev,
  (VTBL_ENTRY)&_ZN6S153C43v48Ev,
  (VTBL_ENTRY)&_ZN6S153C43v49Ev,
  (VTBL_ENTRY)&_ZN6S153C43v50Ev,
  (VTBL_ENTRY)&_ZN6S153C43v51Ev,
  (VTBL_ENTRY)&_ZN6S153C43v52Ev,
  (VTBL_ENTRY)&_ZN6S153C43v53Ev,
  (VTBL_ENTRY)&_ZN6S153C33v54Ev,
  (VTBL_ENTRY)&_ZN6S153C33v55Ev,
  (VTBL_ENTRY)&_ZN6S153C33v56Ev,
  (VTBL_ENTRY)&_ZN6S153C33v57Ev,
  (VTBL_ENTRY)&_ZN6S153C33v58Ev,
  (VTBL_ENTRY)&_ZN6S153C33v59Ev,
  (VTBL_ENTRY)&_ZN6S153C33v60Ev,
  (VTBL_ENTRY)&_ZN6S153C33v61Ev,
  (VTBL_ENTRY)&_ZN6S153C33v62Ev,
  (VTBL_ENTRY)&_ZN6S153C33v63Ev,
  (VTBL_ENTRY)&_ZN6S153C33v64Ev,
  (VTBL_ENTRY)&_ZN6S153C33v65Ev,
  (VTBL_ENTRY)&_ZN6S153C33v66Ev,
};
extern VTBL_ENTRY _ZTI6S153C3[];
extern  VTBL_ENTRY _ZTV6S153C3[];
Class_Descriptor cd_S153C3 = {  "S153C3", // class name
  bases_S153C3, 3,
  &(vtc_S153C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,140), // object size
  NSPAIRA(_ZTI6S153C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S153C3),58, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S153C2  : S153C3 {
  void *s153c2f0;
  char s153c2f1;
  int s153c2f2;
  char s153c2f3[3];
  int s153c2f4;
  ::S154C12 s153c2f5;
  int s153c2f6[2];
  virtual  ~S153C2(); // _ZN6S153C2D1Ev
  virtual void  v67(); // _ZN6S153C23v67Ev
  virtual void  v68(); // _ZN6S153C23v68Ev
  virtual void  v69(); // _ZN6S153C23v69Ev
  virtual void  v70(); // _ZN6S153C23v70Ev
  virtual void  v71(); // _ZN6S153C23v71Ev
  virtual void  v72(); // _ZN6S153C23v72Ev
  virtual void  v73(); // _ZN6S153C23v73Ev
  virtual void  v74(); // _ZN6S153C23v74Ev
  virtual void  v75(); // _ZN6S153C23v75Ev
  virtual void  v76(); // _ZN6S153C23v76Ev
  S153C2(); // tgen
};
//SIG(-1 S153C2) C1{ BC2{ BC3{ BC4{ BC5{ vd v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} Fc Fi} vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 Fp[3] Fi} vd v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 Fp[2] Fi[3] FC6 Fc FC9{ m FC10{ m FL}} Fc Fi Fc Fi Fc[2] Fi Fc} vd v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi[4]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 Fp Fc Fi Fc[3] Fi FC11{ m Fi Fp Fi} Fi[2]}


 S153C2 ::~S153C2(){ note_dtor("S153C2", this);}
void  S153C2 ::v67(){vfunc_called(this, "_ZN6S153C23v67Ev");}
void  S153C2 ::v68(){vfunc_called(this, "_ZN6S153C23v68Ev");}
void  S153C2 ::v69(){vfunc_called(this, "_ZN6S153C23v69Ev");}
void  S153C2 ::v70(){vfunc_called(this, "_ZN6S153C23v70Ev");}
void  S153C2 ::v71(){vfunc_called(this, "_ZN6S153C23v71Ev");}
void  S153C2 ::v72(){vfunc_called(this, "_ZN6S153C23v72Ev");}
void  S153C2 ::v73(){vfunc_called(this, "_ZN6S153C23v73Ev");}
void  S153C2 ::v74(){vfunc_called(this, "_ZN6S153C23v74Ev");}
void  S153C2 ::v75(){vfunc_called(this, "_ZN6S153C23v75Ev");}
void  S153C2 ::v76(){vfunc_called(this, "_ZN6S153C23v76Ev");}
S153C2 ::S153C2(){ note_ctor("S153C2", this);} // tgen

static void Test_S153C2()
{
  extern Class_Descriptor cd_S153C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(33,46)];
    init_test(&cd_S153C2, buf);
    S153C2 *dp, &lv = *(dp=new (buf) S153C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(256,180), "sizeof(S153C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S153C2)");
    check_base_class_offset(lv, (S153C6*)(S153C5*)(S153C4*)(S153C3*), 0, "S153C2");
    check_base_class_offset(lv, (S153C5*)(S153C4*)(S153C3*), 0, "S153C2");
    check_base_class_offset(lv, (S153C4*)(S153C3*), 0, "S153C2");
    check_base_class_offset(lv, (S153C3*), 0, "S153C2");
    check_field_offset(lv, s153c2f0, ABISELECT(200,140), "S153C2.s153c2f0");
    check_field_offset(lv, s153c2f1, ABISELECT(208,144), "S153C2.s153c2f1");
    check_field_offset(lv, s153c2f2, ABISELECT(212,148), "S153C2.s153c2f2");
    check_field_offset(lv, s153c2f3, ABISELECT(216,152), "S153C2.s153c2f3");
    check_field_offset(lv, s153c2f4, ABISELECT(220,156), "S153C2.s153c2f4");
    check_field_offset(lv, s153c2f5, ABISELECT(224,160), "S153C2.s153c2f5");
    check_field_offset(lv, s153c2f6, ABISELECT(248,172), "S153C2.s153c2f6");
    test_class_info(&lv, &cd_S153C2);
    dp->~S153C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS153C2(Test_S153C2, "S153C2", ABISELECT(256,180));

#else // __cplusplus

extern void _ZN6S153C2C1Ev();
extern void _ZN6S153C2D1Ev();
Name_Map name_map_S153C2[] = {
  NSPAIR(_ZN6S153C2C1Ev),
  NSPAIR(_ZN6S153C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S153C6;
extern VTBL_ENTRY _ZTI6S153C6[];
extern  VTBL_ENTRY _ZTV6S153C6[];
extern Class_Descriptor cd_S153C5;
extern VTBL_ENTRY _ZTI6S153C5[];
extern  VTBL_ENTRY _ZTV6S153C5[];
extern Class_Descriptor cd_S153C4;
extern VTBL_ENTRY _ZTI6S153C4[];
extern  VTBL_ENTRY _ZTV6S153C4[];
extern Class_Descriptor cd_S153C3;
extern VTBL_ENTRY _ZTI6S153C3[];
extern  VTBL_ENTRY _ZTV6S153C3[];
static Base_Class bases_S153C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S153C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S153C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S153C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S153C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S153C2[];
extern void _ZN6S153C2D1Ev();
extern void _ZN6S153C2D0Ev();
extern void _ZN6S153C63v13Ev();
extern void _ZN6S153C63v14Ev();
extern void _ZN6S153C63v15Ev();
extern void _ZN6S153C63v16Ev();
extern void _ZN6S153C63v17Ev();
extern void _ZN6S153C63v18Ev();
extern void _ZN6S153C63v19Ev();
extern void _ZN6S153C63v20Ev();
extern void _ZN6S153C63v21Ev();
extern void _ZN6S153C63v22Ev();
extern void _ZN6S153C63v23Ev();
extern void _ZN6S153C63v24Ev();
extern void _ZN6S153C63v25Ev();
extern void _ZN6S153C53v26Ev();
extern void _ZN6S153C53v27Ev();
extern void _ZN6S153C53v28Ev();
extern void _ZN6S153C53v29Ev();
extern void _ZN6S153C53v30Ev();
extern void _ZN6S153C53v31Ev();
extern void _ZN6S153C53v32Ev();
extern void _ZN6S153C53v33Ev();
extern void _ZN6S153C53v34Ev();
extern void _ZN6S153C53v35Ev();
extern void _ZN6S153C53v36Ev();
extern void _ZN6S153C43v37Ev();
extern void _ZN6S153C43v38Ev();
extern void _ZN6S153C43v39Ev();
extern void _ZN6S153C43v40Ev();
extern void _ZN6S153C43v41Ev();
extern void _ZN6S153C43v42Ev();
extern void _ZN6S153C43v43Ev();
extern void _ZN6S153C43v44Ev();
extern void _ZN6S153C43v45Ev();
extern void _ZN6S153C43v46Ev();
extern void _ZN6S153C43v47Ev();
extern void _ZN6S153C43v48Ev();
extern void _ZN6S153C43v49Ev();
extern void _ZN6S153C43v50Ev();
extern void _ZN6S153C43v51Ev();
extern void _ZN6S153C43v52Ev();
extern void _ZN6S153C43v53Ev();
extern void _ZN6S153C33v54Ev();
extern void _ZN6S153C33v55Ev();
extern void _ZN6S153C33v56Ev();
extern void _ZN6S153C33v57Ev();
extern void _ZN6S153C33v58Ev();
extern void _ZN6S153C33v59Ev();
extern void _ZN6S153C33v60Ev();
extern void _ZN6S153C33v61Ev();
extern void _ZN6S153C33v62Ev();
extern void _ZN6S153C33v63Ev();
extern void _ZN6S153C33v64Ev();
extern void _ZN6S153C33v65Ev();
extern void _ZN6S153C33v66Ev();
extern void _ZN6S153C23v67Ev();
extern void _ZN6S153C23v68Ev();
extern void _ZN6S153C23v69Ev();
extern void _ZN6S153C23v70Ev();
extern void _ZN6S153C23v71Ev();
extern void _ZN6S153C23v72Ev();
extern void _ZN6S153C23v73Ev();
extern void _ZN6S153C23v74Ev();
extern void _ZN6S153C23v75Ev();
extern void _ZN6S153C23v76Ev();
static  VTBL_ENTRY vtc_S153C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S153C2[0]),
  (VTBL_ENTRY)&_ZN6S153C2D1Ev,
  (VTBL_ENTRY)&_ZN6S153C2D0Ev,
  (VTBL_ENTRY)&_ZN6S153C63v13Ev,
  (VTBL_ENTRY)&_ZN6S153C63v14Ev,
  (VTBL_ENTRY)&_ZN6S153C63v15Ev,
  (VTBL_ENTRY)&_ZN6S153C63v16Ev,
  (VTBL_ENTRY)&_ZN6S153C63v17Ev,
  (VTBL_ENTRY)&_ZN6S153C63v18Ev,
  (VTBL_ENTRY)&_ZN6S153C63v19Ev,
  (VTBL_ENTRY)&_ZN6S153C63v20Ev,
  (VTBL_ENTRY)&_ZN6S153C63v21Ev,
  (VTBL_ENTRY)&_ZN6S153C63v22Ev,
  (VTBL_ENTRY)&_ZN6S153C63v23Ev,
  (VTBL_ENTRY)&_ZN6S153C63v24Ev,
  (VTBL_ENTRY)&_ZN6S153C63v25Ev,
  (VTBL_ENTRY)&_ZN6S153C53v26Ev,
  (VTBL_ENTRY)&_ZN6S153C53v27Ev,
  (VTBL_ENTRY)&_ZN6S153C53v28Ev,
  (VTBL_ENTRY)&_ZN6S153C53v29Ev,
  (VTBL_ENTRY)&_ZN6S153C53v30Ev,
  (VTBL_ENTRY)&_ZN6S153C53v31Ev,
  (VTBL_ENTRY)&_ZN6S153C53v32Ev,
  (VTBL_ENTRY)&_ZN6S153C53v33Ev,
  (VTBL_ENTRY)&_ZN6S153C53v34Ev,
  (VTBL_ENTRY)&_ZN6S153C53v35Ev,
  (VTBL_ENTRY)&_ZN6S153C53v36Ev,
  (VTBL_ENTRY)&_ZN6S153C43v37Ev,
  (VTBL_ENTRY)&_ZN6S153C43v38Ev,
  (VTBL_ENTRY)&_ZN6S153C43v39Ev,
  (VTBL_ENTRY)&_ZN6S153C43v40Ev,
  (VTBL_ENTRY)&_ZN6S153C43v41Ev,
  (VTBL_ENTRY)&_ZN6S153C43v42Ev,
  (VTBL_ENTRY)&_ZN6S153C43v43Ev,
  (VTBL_ENTRY)&_ZN6S153C43v44Ev,
  (VTBL_ENTRY)&_ZN6S153C43v45Ev,
  (VTBL_ENTRY)&_ZN6S153C43v46Ev,
  (VTBL_ENTRY)&_ZN6S153C43v47Ev,
  (VTBL_ENTRY)&_ZN6S153C43v48Ev,
  (VTBL_ENTRY)&_ZN6S153C43v49Ev,
  (VTBL_ENTRY)&_ZN6S153C43v50Ev,
  (VTBL_ENTRY)&_ZN6S153C43v51Ev,
  (VTBL_ENTRY)&_ZN6S153C43v52Ev,
  (VTBL_ENTRY)&_ZN6S153C43v53Ev,
  (VTBL_ENTRY)&_ZN6S153C33v54Ev,
  (VTBL_ENTRY)&_ZN6S153C33v55Ev,
  (VTBL_ENTRY)&_ZN6S153C33v56Ev,
  (VTBL_ENTRY)&_ZN6S153C33v57Ev,
  (VTBL_ENTRY)&_ZN6S153C33v58Ev,
  (VTBL_ENTRY)&_ZN6S153C33v59Ev,
  (VTBL_ENTRY)&_ZN6S153C33v60Ev,
  (VTBL_ENTRY)&_ZN6S153C33v61Ev,
  (VTBL_ENTRY)&_ZN6S153C33v62Ev,
  (VTBL_ENTRY)&_ZN6S153C33v63Ev,
  (VTBL_ENTRY)&_ZN6S153C33v64Ev,
  (VTBL_ENTRY)&_ZN6S153C33v65Ev,
  (VTBL_ENTRY)&_ZN6S153C33v66Ev,
  (VTBL_ENTRY)&_ZN6S153C23v67Ev,
  (VTBL_ENTRY)&_ZN6S153C23v68Ev,
  (VTBL_ENTRY)&_ZN6S153C23v69Ev,
  (VTBL_ENTRY)&_ZN6S153C23v70Ev,
  (VTBL_ENTRY)&_ZN6S153C23v71Ev,
  (VTBL_ENTRY)&_ZN6S153C23v72Ev,
  (VTBL_ENTRY)&_ZN6S153C23v73Ev,
  (VTBL_ENTRY)&_ZN6S153C23v74Ev,
  (VTBL_ENTRY)&_ZN6S153C23v75Ev,
  (VTBL_ENTRY)&_ZN6S153C23v76Ev,
};
extern VTBL_ENTRY _ZTI6S153C2[];
extern  VTBL_ENTRY _ZTV6S153C2[];
Class_Descriptor cd_S153C2 = {  "S153C2", // class name
  bases_S153C2, 4,
  &(vtc_S153C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(256,180), // object size
  NSPAIRA(_ZTI6S153C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S153C2),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S153C13  {
  char s153c13f0[33];
  int s153c13f1;
};
//SIG(-1 S153C13) C1{ Fc[33] Fi}



static void Test_S153C13()
{
  {
    init_simple_test("S153C13");
    S153C13 lv;
    check2(sizeof(lv), 40, "sizeof(S153C13)");
    check2(__alignof__(lv), 4, "__alignof__(S153C13)");
    check_field_offset(lv, s153c13f0, 0, "S153C13.s153c13f0");
    check_field_offset(lv, s153c13f1, 36, "S153C13.s153c13f1");
  }
}
static Arrange_To_Call_Me vS153C13(Test_S153C13, "S153C13", 40);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S153C1  : S153C2 {
  int s153c1f0;
  ::S153C13 s153c1f1;
  ::S1587C17 s153c1f2;
  ::S1587C18 s153c1f3;
  ::S154C27_nt s153c1f4;
  void *s153c1f5;
  ::S154C51 s153c1f6;
  ::S1587C31 s153c1f7;
  ::S1587C31 s153c1f8;
  char s153c1f9;
  ::S154C53 s153c1f10;
  ::S1587C13 s153c1f11;
  virtual  ~S153C1(); // _ZN6S153C1D1Ev
  virtual void  v1(); // _ZN6S153C12v1Ev
  virtual void  v2(); // _ZN6S153C12v2Ev
  virtual void  v3(); // _ZN6S153C12v3Ev
  virtual void  v4(); // _ZN6S153C12v4Ev
  virtual void  v5(); // _ZN6S153C12v5Ev
  virtual void  v6(); // _ZN6S153C12v6Ev
  virtual void  v7(); // _ZN6S153C12v7Ev
  virtual void  v8(); // _ZN6S153C12v8Ev
  virtual void  v9(); // _ZN6S153C12v9Ev
  virtual void  v10(); // _ZN6S153C13v10Ev
  virtual void  v11(); // _ZN6S153C13v11Ev
  virtual void  v12(); // _ZN6S153C13v12Ev
  S153C1(); // tgen
};
//SIG(1 S153C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 Fp FC7{ m FC8{ m Fp Fi FC9{ m}} Fi} Fc Fi} vd v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 Fp[3] Fi} vd v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 Fp[2] Fi[3] FC7 Fc FC10{ m FC11{ m FL}} Fc Fi Fc Fi Fc[2] Fi Fc} vd v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi[4]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 Fp Fc Fi Fc[3] Fi FC12{ m Fi Fp Fi} Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fi FC13{ Fc[33] Fi} FC14{ m Fp[2] Fi[2]} FC15{ m FC14 Fp[2] Fc Fp FC16{ m Fp[2]} FC16 FC17{ m Fp[2]} Fp Fi FC18{ Fi[3] FC19{ Fi} FC20{ Fi[3]}} Fi[3] Fc FC20 Fi} FC21{ m FC22{ m Fp[2]}} Fp FC23{ m FC8 FC8 Fi FC16 Fp[2]} FC24{ BC25{ vd v79 v80 v81 FL Fp Fi} vd v77 v78 Fi Fc} FC24 Fc FC26{ m Fc Fi} FC27{ m Fp FC28{ BC29{ m Fp Fi} Fp} Fc Fp}}


 S153C1 ::~S153C1(){ note_dtor("S153C1", this);}
void  S153C1 ::v1(){vfunc_called(this, "_ZN6S153C12v1Ev");}
void  S153C1 ::v2(){vfunc_called(this, "_ZN6S153C12v2Ev");}
void  S153C1 ::v3(){vfunc_called(this, "_ZN6S153C12v3Ev");}
void  S153C1 ::v4(){vfunc_called(this, "_ZN6S153C12v4Ev");}
void  S153C1 ::v5(){vfunc_called(this, "_ZN6S153C12v5Ev");}
void  S153C1 ::v6(){vfunc_called(this, "_ZN6S153C12v6Ev");}
void  S153C1 ::v7(){vfunc_called(this, "_ZN6S153C12v7Ev");}
void  S153C1 ::v8(){vfunc_called(this, "_ZN6S153C12v8Ev");}
void  S153C1 ::v9(){vfunc_called(this, "_ZN6S153C12v9Ev");}
void  S153C1 ::v10(){vfunc_called(this, "_ZN6S153C13v10Ev");}
void  S153C1 ::v11(){vfunc_called(this, "_ZN6S153C13v11Ev");}
void  S153C1 ::v12(){vfunc_called(this, "_ZN6S153C13v12Ev");}
S153C1 ::S153C1(){ note_ctor("S153C1", this);} // tgen

static void Test_S153C1()
{
  extern Class_Descriptor cd_S153C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(94,129)];
    init_test(&cd_S153C1, buf);
    S153C1 *dp, &lv = *(dp=new (buf) S153C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(744,512), "sizeof(S153C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S153C1)");
    check_base_class_offset(lv, (S153C6*)(S153C5*)(S153C4*)(S153C3*)(S153C2*), 0, "S153C1");
    check_base_class_offset(lv, (S153C5*)(S153C4*)(S153C3*)(S153C2*), 0, "S153C1");
    check_base_class_offset(lv, (S153C4*)(S153C3*)(S153C2*), 0, "S153C1");
    check_base_class_offset(lv, (S153C3*)(S153C2*), 0, "S153C1");
    check_base_class_offset(lv, (S153C2*), 0, "S153C1");
    check_field_offset(lv, s153c1f0, ABISELECT(256,180), "S153C1.s153c1f0");
    check_field_offset(lv, s153c1f1, ABISELECT(260,184), "S153C1.s153c1f1");
    check_field_offset(lv, s153c1f2, ABISELECT(304,224), "S153C1.s153c1f2");
    check_field_offset(lv, s153c1f3, ABISELECT(328,240), "S153C1.s153c1f3");
    check_field_offset(lv, s153c1f4, ABISELECT(504,364), "S153C1.s153c1f4");
    check_field_offset(lv, s153c1f5, ABISELECT(520,372), "S153C1.s153c1f5");
    check_field_offset(lv, s153c1f6, ABISELECT(528,376), "S153C1.s153c1f6");
    check_field_offset(lv, s153c1f7, ABISELECT(600,420), "S153C1.s153c1f7");
    check_field_offset(lv, s153c1f8, ABISELECT(640,448), "S153C1.s153c1f8");
    check_field_offset(lv, s153c1f9, ABISELECT(680,476), "S153C1.s153c1f9");
    check_field_offset(lv, s153c1f10, ABISELECT(684,480), "S153C1.s153c1f10");
    check_field_offset(lv, s153c1f11, ABISELECT(696,488), "S153C1.s153c1f11");
    test_class_info(&lv, &cd_S153C1);
    dp->~S153C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS153C1(Test_S153C1, "S153C1", ABISELECT(744,512));

#else // __cplusplus

extern void _ZN6S153C1C1Ev();
extern void _ZN6S153C1D1Ev();
Name_Map name_map_S153C1[] = {
  NSPAIR(_ZN6S153C1C1Ev),
  NSPAIR(_ZN6S153C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S153C6;
extern VTBL_ENTRY _ZTI6S153C6[];
extern  VTBL_ENTRY _ZTV6S153C6[];
extern Class_Descriptor cd_S153C5;
extern VTBL_ENTRY _ZTI6S153C5[];
extern  VTBL_ENTRY _ZTV6S153C5[];
extern Class_Descriptor cd_S153C4;
extern VTBL_ENTRY _ZTI6S153C4[];
extern  VTBL_ENTRY _ZTV6S153C4[];
extern Class_Descriptor cd_S153C3;
extern VTBL_ENTRY _ZTI6S153C3[];
extern  VTBL_ENTRY _ZTV6S153C3[];
extern Class_Descriptor cd_S153C2;
extern VTBL_ENTRY _ZTI6S153C2[];
extern  VTBL_ENTRY _ZTV6S153C2[];
static Base_Class bases_S153C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S153C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S153C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S153C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S153C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S153C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S153C1[];
extern void _ZN6S153C1D1Ev();
extern void _ZN6S153C1D0Ev();
extern void _ZN6S153C63v13Ev();
extern void _ZN6S153C63v14Ev();
extern void _ZN6S153C63v15Ev();
extern void _ZN6S153C63v16Ev();
extern void _ZN6S153C63v17Ev();
extern void _ZN6S153C63v18Ev();
extern void _ZN6S153C63v19Ev();
extern void _ZN6S153C63v20Ev();
extern void _ZN6S153C63v21Ev();
extern void _ZN6S153C63v22Ev();
extern void _ZN6S153C63v23Ev();
extern void _ZN6S153C63v24Ev();
extern void _ZN6S153C63v25Ev();
extern void _ZN6S153C53v26Ev();
extern void _ZN6S153C53v27Ev();
extern void _ZN6S153C53v28Ev();
extern void _ZN6S153C53v29Ev();
extern void _ZN6S153C53v30Ev();
extern void _ZN6S153C53v31Ev();
extern void _ZN6S153C53v32Ev();
extern void _ZN6S153C53v33Ev();
extern void _ZN6S153C53v34Ev();
extern void _ZN6S153C53v35Ev();
extern void _ZN6S153C53v36Ev();
extern void _ZN6S153C43v37Ev();
extern void _ZN6S153C43v38Ev();
extern void _ZN6S153C43v39Ev();
extern void _ZN6S153C43v40Ev();
extern void _ZN6S153C43v41Ev();
extern void _ZN6S153C43v42Ev();
extern void _ZN6S153C43v43Ev();
extern void _ZN6S153C43v44Ev();
extern void _ZN6S153C43v45Ev();
extern void _ZN6S153C43v46Ev();
extern void _ZN6S153C43v47Ev();
extern void _ZN6S153C43v48Ev();
extern void _ZN6S153C43v49Ev();
extern void _ZN6S153C43v50Ev();
extern void _ZN6S153C43v51Ev();
extern void _ZN6S153C43v52Ev();
extern void _ZN6S153C43v53Ev();
extern void _ZN6S153C33v54Ev();
extern void _ZN6S153C33v55Ev();
extern void _ZN6S153C33v56Ev();
extern void _ZN6S153C33v57Ev();
extern void _ZN6S153C33v58Ev();
extern void _ZN6S153C33v59Ev();
extern void _ZN6S153C33v60Ev();
extern void _ZN6S153C33v61Ev();
extern void _ZN6S153C33v62Ev();
extern void _ZN6S153C33v63Ev();
extern void _ZN6S153C33v64Ev();
extern void _ZN6S153C33v65Ev();
extern void _ZN6S153C33v66Ev();
extern void _ZN6S153C23v67Ev();
extern void _ZN6S153C23v68Ev();
extern void _ZN6S153C23v69Ev();
extern void _ZN6S153C23v70Ev();
extern void _ZN6S153C23v71Ev();
extern void _ZN6S153C23v72Ev();
extern void _ZN6S153C23v73Ev();
extern void _ZN6S153C23v74Ev();
extern void _ZN6S153C23v75Ev();
extern void _ZN6S153C23v76Ev();
extern void _ZN6S153C12v1Ev();
extern void _ZN6S153C12v2Ev();
extern void _ZN6S153C12v3Ev();
extern void _ZN6S153C12v4Ev();
extern void _ZN6S153C12v5Ev();
extern void _ZN6S153C12v6Ev();
extern void _ZN6S153C12v7Ev();
extern void _ZN6S153C12v8Ev();
extern void _ZN6S153C12v9Ev();
extern void _ZN6S153C13v10Ev();
extern void _ZN6S153C13v11Ev();
extern void _ZN6S153C13v12Ev();
static  VTBL_ENTRY vtc_S153C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S153C1[0]),
  (VTBL_ENTRY)&_ZN6S153C1D1Ev,
  (VTBL_ENTRY)&_ZN6S153C1D0Ev,
  (VTBL_ENTRY)&_ZN6S153C63v13Ev,
  (VTBL_ENTRY)&_ZN6S153C63v14Ev,
  (VTBL_ENTRY)&_ZN6S153C63v15Ev,
  (VTBL_ENTRY)&_ZN6S153C63v16Ev,
  (VTBL_ENTRY)&_ZN6S153C63v17Ev,
  (VTBL_ENTRY)&_ZN6S153C63v18Ev,
  (VTBL_ENTRY)&_ZN6S153C63v19Ev,
  (VTBL_ENTRY)&_ZN6S153C63v20Ev,
  (VTBL_ENTRY)&_ZN6S153C63v21Ev,
  (VTBL_ENTRY)&_ZN6S153C63v22Ev,
  (VTBL_ENTRY)&_ZN6S153C63v23Ev,
  (VTBL_ENTRY)&_ZN6S153C63v24Ev,
  (VTBL_ENTRY)&_ZN6S153C63v25Ev,
  (VTBL_ENTRY)&_ZN6S153C53v26Ev,
  (VTBL_ENTRY)&_ZN6S153C53v27Ev,
  (VTBL_ENTRY)&_ZN6S153C53v28Ev,
  (VTBL_ENTRY)&_ZN6S153C53v29Ev,
  (VTBL_ENTRY)&_ZN6S153C53v30Ev,
  (VTBL_ENTRY)&_ZN6S153C53v31Ev,
  (VTBL_ENTRY)&_ZN6S153C53v32Ev,
  (VTBL_ENTRY)&_ZN6S153C53v33Ev,
  (VTBL_ENTRY)&_ZN6S153C53v34Ev,
  (VTBL_ENTRY)&_ZN6S153C53v35Ev,
  (VTBL_ENTRY)&_ZN6S153C53v36Ev,
  (VTBL_ENTRY)&_ZN6S153C43v37Ev,
  (VTBL_ENTRY)&_ZN6S153C43v38Ev,
  (VTBL_ENTRY)&_ZN6S153C43v39Ev,
  (VTBL_ENTRY)&_ZN6S153C43v40Ev,
  (VTBL_ENTRY)&_ZN6S153C43v41Ev,
  (VTBL_ENTRY)&_ZN6S153C43v42Ev,
  (VTBL_ENTRY)&_ZN6S153C43v43Ev,
  (VTBL_ENTRY)&_ZN6S153C43v44Ev,
  (VTBL_ENTRY)&_ZN6S153C43v45Ev,
  (VTBL_ENTRY)&_ZN6S153C43v46Ev,
  (VTBL_ENTRY)&_ZN6S153C43v47Ev,
  (VTBL_ENTRY)&_ZN6S153C43v48Ev,
  (VTBL_ENTRY)&_ZN6S153C43v49Ev,
  (VTBL_ENTRY)&_ZN6S153C43v50Ev,
  (VTBL_ENTRY)&_ZN6S153C43v51Ev,
  (VTBL_ENTRY)&_ZN6S153C43v52Ev,
  (VTBL_ENTRY)&_ZN6S153C43v53Ev,
  (VTBL_ENTRY)&_ZN6S153C33v54Ev,
  (VTBL_ENTRY)&_ZN6S153C33v55Ev,
  (VTBL_ENTRY)&_ZN6S153C33v56Ev,
  (VTBL_ENTRY)&_ZN6S153C33v57Ev,
  (VTBL_ENTRY)&_ZN6S153C33v58Ev,
  (VTBL_ENTRY)&_ZN6S153C33v59Ev,
  (VTBL_ENTRY)&_ZN6S153C33v60Ev,
  (VTBL_ENTRY)&_ZN6S153C33v61Ev,
  (VTBL_ENTRY)&_ZN6S153C33v62Ev,
  (VTBL_ENTRY)&_ZN6S153C33v63Ev,
  (VTBL_ENTRY)&_ZN6S153C33v64Ev,
  (VTBL_ENTRY)&_ZN6S153C33v65Ev,
  (VTBL_ENTRY)&_ZN6S153C33v66Ev,
  (VTBL_ENTRY)&_ZN6S153C23v67Ev,
  (VTBL_ENTRY)&_ZN6S153C23v68Ev,
  (VTBL_ENTRY)&_ZN6S153C23v69Ev,
  (VTBL_ENTRY)&_ZN6S153C23v70Ev,
  (VTBL_ENTRY)&_ZN6S153C23v71Ev,
  (VTBL_ENTRY)&_ZN6S153C23v72Ev,
  (VTBL_ENTRY)&_ZN6S153C23v73Ev,
  (VTBL_ENTRY)&_ZN6S153C23v74Ev,
  (VTBL_ENTRY)&_ZN6S153C23v75Ev,
  (VTBL_ENTRY)&_ZN6S153C23v76Ev,
  (VTBL_ENTRY)&_ZN6S153C12v1Ev,
  (VTBL_ENTRY)&_ZN6S153C12v2Ev,
  (VTBL_ENTRY)&_ZN6S153C12v3Ev,
  (VTBL_ENTRY)&_ZN6S153C12v4Ev,
  (VTBL_ENTRY)&_ZN6S153C12v5Ev,
  (VTBL_ENTRY)&_ZN6S153C12v6Ev,
  (VTBL_ENTRY)&_ZN6S153C12v7Ev,
  (VTBL_ENTRY)&_ZN6S153C12v8Ev,
  (VTBL_ENTRY)&_ZN6S153C12v9Ev,
  (VTBL_ENTRY)&_ZN6S153C13v10Ev,
  (VTBL_ENTRY)&_ZN6S153C13v11Ev,
  (VTBL_ENTRY)&_ZN6S153C13v12Ev,
};
extern VTBL_ENTRY _ZTI6S153C1[];
extern  VTBL_ENTRY _ZTV6S153C1[];
Class_Descriptor cd_S153C1 = {  "S153C1", // class name
  bases_S153C1, 5,
  &(vtc_S153C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(744,512), // object size
  NSPAIRA(_ZTI6S153C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S153C1),80, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S886C9_nt  {
  void  mf886c9(); // _ZN9S886C9_nt7mf886c9Ev
};
//SIG(-1 S886C9_nt) C1{ m}


void  S886C9_nt ::mf886c9(){}

//skip512 S886C9_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI9S886C9_nt[];
VTBL_ENTRY *P__ZTI9S886C9_nt = _ZTI9S886C9_nt; 
Class_Descriptor cd_S886C9_nt = {  "S886C9_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI9S886C9_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S886C7_nt  {
  void *s886c7f0;
  int s886c7f1;
  ::S1587C7_nt s886c7f2;
  ::S886C9_nt s886c7f3;
  void  mf886c7(); // _ZN9S886C7_nt7mf886c7Ev
};
//SIG(-1 S886C7_nt) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S886C7_nt ::mf886c7(){}

//skip512 S886C7_nt

#else // __cplusplus

Class_Descriptor cd_S886C7_nt = {  "S886C7_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S886C6_nt  : S886C7_nt {
};
//SIG(-1 S886C6_nt) C1{ BC2{ m Fp Fi FC3{ m} FC4{ m}}}



//skip512 S886C6_nt

#else // __cplusplus

extern Class_Descriptor cd_S886C7_nt;
static Base_Class bases_S886C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S886C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S886C11_nt  {
  long s886c11f0[4];
};
//SIG(-1 S886C11_nt) C1{ Fl[4]}



//skip512 S886C11_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S886C10_nt  {
  ::S886C11_nt s886c10f0;
  void  mf886c10(); // _ZN10S886C10_nt8mf886c10Ev
};
//SIG(-1 S886C10_nt) C1{ m FC2{ Fl[4]}}


void  S886C10_nt ::mf886c10(){}

//skip512 S886C10_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S886C5  {
  void *s886c5f0;
  ::S886C6_nt s886c5f1;
  ::S886C10_nt s886c5f2;
  char s886c5f3;
  virtual  ~S886C5(); // _ZN6S886C5D1Ev
  virtual void  v2(); // _ZN6S886C52v2Ev
  virtual void  v3(); // _ZN6S886C52v3Ev
  virtual void  v4(); // _ZN6S886C52v4Ev
  virtual void  v5(); // _ZN6S886C52v5Ev
  virtual void  v6(); // _ZN6S886C52v6Ev
  virtual void  v7(); // _ZN6S886C52v7Ev
  virtual void  v8(); // _ZN6S886C52v8Ev
  virtual void  v9(); // _ZN6S886C52v9Ev
  virtual void  v10(); // _ZN6S886C53v10Ev
  virtual void  v11(); // _ZN6S886C53v11Ev
  virtual void  v12(); // _ZN6S886C53v12Ev
  virtual void  v13(); // _ZN6S886C53v13Ev
  S886C5(); // tgen
};
//SIG(-1 S886C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fp FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}} FC6{ m FC7{ Fl[4]}} Fc}


 S886C5 ::~S886C5(){ note_dtor("S886C5", this);}
void  S886C5 ::v2(){vfunc_called(this, "_ZN6S886C52v2Ev");}
void  S886C5 ::v3(){vfunc_called(this, "_ZN6S886C52v3Ev");}
void  S886C5 ::v4(){vfunc_called(this, "_ZN6S886C52v4Ev");}
void  S886C5 ::v5(){vfunc_called(this, "_ZN6S886C52v5Ev");}
void  S886C5 ::v6(){vfunc_called(this, "_ZN6S886C52v6Ev");}
void  S886C5 ::v7(){vfunc_called(this, "_ZN6S886C52v7Ev");}
void  S886C5 ::v8(){vfunc_called(this, "_ZN6S886C52v8Ev");}
void  S886C5 ::v9(){vfunc_called(this, "_ZN6S886C52v9Ev");}
void  S886C5 ::v10(){vfunc_called(this, "_ZN6S886C53v10Ev");}
void  S886C5 ::v11(){vfunc_called(this, "_ZN6S886C53v11Ev");}
void  S886C5 ::v12(){vfunc_called(this, "_ZN6S886C53v12Ev");}
void  S886C5 ::v13(){vfunc_called(this, "_ZN6S886C53v13Ev");}
S886C5 ::S886C5(){ note_ctor("S886C5", this);} // tgen

static void Test_S886C5()
{
  extern Class_Descriptor cd_S886C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,11)];
    init_test(&cd_S886C5, buf);
    S886C5 *dp, &lv = *(dp=new (buf) S886C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,40), "sizeof(S886C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S886C5)");
    check_field_offset(lv, s886c5f0, ABISELECT(8,4), "S886C5.s886c5f0");
    check_field_offset(lv, s886c5f1, ABISELECT(16,8), "S886C5.s886c5f1");
    check_field_offset(lv, s886c5f2, ABISELECT(32,20), "S886C5.s886c5f2");
    check_field_offset(lv, s886c5f3, ABISELECT(64,36), "S886C5.s886c5f3");
    test_class_info(&lv, &cd_S886C5);
    dp->~S886C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS886C5(Test_S886C5, "S886C5", ABISELECT(72,40));

#else // __cplusplus

extern void _ZN6S886C5C1Ev();
extern void _ZN6S886C5D1Ev();
Name_Map name_map_S886C5[] = {
  NSPAIR(_ZN6S886C5C1Ev),
  NSPAIR(_ZN6S886C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S886C5[];
extern void _ZN6S886C5D1Ev();
extern void _ZN6S886C5D0Ev();
extern void _ZN6S886C52v2Ev();
extern void _ZN6S886C52v3Ev();
extern void _ZN6S886C52v4Ev();
extern void _ZN6S886C52v5Ev();
extern void _ZN6S886C52v6Ev();
extern void _ZN6S886C52v7Ev();
extern void _ZN6S886C52v8Ev();
extern void _ZN6S886C52v9Ev();
extern void _ZN6S886C53v10Ev();
extern void _ZN6S886C53v11Ev();
extern void _ZN6S886C53v12Ev();
extern void _ZN6S886C53v13Ev();
static  VTBL_ENTRY vtc_S886C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S886C5[0]),
  (VTBL_ENTRY)&_ZN6S886C5D1Ev,
  (VTBL_ENTRY)&_ZN6S886C5D0Ev,
  (VTBL_ENTRY)&_ZN6S886C52v2Ev,
  (VTBL_ENTRY)&_ZN6S886C52v3Ev,
  (VTBL_ENTRY)&_ZN6S886C52v4Ev,
  (VTBL_ENTRY)&_ZN6S886C52v5Ev,
  (VTBL_ENTRY)&_ZN6S886C52v6Ev,
  (VTBL_ENTRY)&_ZN6S886C52v7Ev,
  (VTBL_ENTRY)&_ZN6S886C52v8Ev,
  (VTBL_ENTRY)&_ZN6S886C52v9Ev,
  (VTBL_ENTRY)&_ZN6S886C53v10Ev,
  (VTBL_ENTRY)&_ZN6S886C53v11Ev,
  (VTBL_ENTRY)&_ZN6S886C53v12Ev,
  (VTBL_ENTRY)&_ZN6S886C53v13Ev,
};
extern VTBL_ENTRY _ZTI6S886C5[];
extern  VTBL_ENTRY _ZTV6S886C5[];
Class_Descriptor cd_S886C5 = {  "S886C5", // class name
  0,0,//no base classes
  &(vtc_S886C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI6S886C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S886C5),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S886C12_nt  {
  void *s886c12f0;
  int s886c12f1[2];
  ::S886C9_nt s886c12f2;
  void  mf886c12(); // _ZN10S886C12_nt8mf886c12Ev
};
//SIG(-1 S886C12_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S886C12_nt ::mf886c12(){}

//skip512 S886C12_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S886C4  : S886C5 {
  ::S886C12_nt s886c4f0;
  virtual  ~S886C4(); // _ZN6S886C4D1Ev
  virtual void  v14(); // _ZN6S886C43v14Ev
  virtual void  v15(); // _ZN6S886C43v15Ev
  virtual void  v16(); // _ZN6S886C43v16Ev
  virtual void  v17(); // _ZN6S886C43v17Ev
  virtual void  v18(); // _ZN6S886C43v18Ev
  virtual void  v19(); // _ZN6S886C43v19Ev
  virtual void  v20(); // _ZN6S886C43v20Ev
  S886C4(); // tgen
};
//SIG(-1 S886C4) C1{ BC2{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 Fp FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}} FC7{ m FC8{ Fl[4]}} Fc} vd v1 v2 v3 v4 v5 v6 v7 FC9{ m Fp Fi[2] FC6}}


 S886C4 ::~S886C4(){ note_dtor("S886C4", this);}
void  S886C4 ::v14(){vfunc_called(this, "_ZN6S886C43v14Ev");}
void  S886C4 ::v15(){vfunc_called(this, "_ZN6S886C43v15Ev");}
void  S886C4 ::v16(){vfunc_called(this, "_ZN6S886C43v16Ev");}
void  S886C4 ::v17(){vfunc_called(this, "_ZN6S886C43v17Ev");}
void  S886C4 ::v18(){vfunc_called(this, "_ZN6S886C43v18Ev");}
void  S886C4 ::v19(){vfunc_called(this, "_ZN6S886C43v19Ev");}
void  S886C4 ::v20(){vfunc_called(this, "_ZN6S886C43v20Ev");}
S886C4 ::S886C4(){ note_ctor("S886C4", this);} // tgen

static void Test_S886C4()
{
  extern Class_Descriptor cd_S886C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,15)];
    init_test(&cd_S886C4, buf);
    S886C4 *dp, &lv = *(dp=new (buf) S886C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,56), "sizeof(S886C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S886C4)");
    check_base_class_offset(lv, (S886C5*), 0, "S886C4");
    check_field_offset(lv, s886c4f0, ABISELECT(72,40), "S886C4.s886c4f0");
    test_class_info(&lv, &cd_S886C4);
    dp->~S886C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS886C4(Test_S886C4, "S886C4", ABISELECT(96,56));

#else // __cplusplus

extern void _ZN6S886C4C1Ev();
extern void _ZN6S886C4D1Ev();
Name_Map name_map_S886C4[] = {
  NSPAIR(_ZN6S886C4C1Ev),
  NSPAIR(_ZN6S886C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S886C5;
extern VTBL_ENTRY _ZTI6S886C5[];
extern  VTBL_ENTRY _ZTV6S886C5[];
static Base_Class bases_S886C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S886C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S886C4[];
extern void _ZN6S886C4D1Ev();
extern void _ZN6S886C4D0Ev();
extern void _ZN6S886C52v2Ev();
extern void _ZN6S886C52v3Ev();
extern void _ZN6S886C52v4Ev();
extern void _ZN6S886C52v5Ev();
extern void _ZN6S886C52v6Ev();
extern void _ZN6S886C52v7Ev();
extern void _ZN6S886C52v8Ev();
extern void _ZN6S886C52v9Ev();
extern void _ZN6S886C53v10Ev();
extern void _ZN6S886C53v11Ev();
extern void _ZN6S886C53v12Ev();
extern void _ZN6S886C53v13Ev();
extern void _ZN6S886C43v14Ev();
extern void _ZN6S886C43v15Ev();
extern void _ZN6S886C43v16Ev();
extern void _ZN6S886C43v17Ev();
extern void _ZN6S886C43v18Ev();
extern void _ZN6S886C43v19Ev();
extern void _ZN6S886C43v20Ev();
static  VTBL_ENTRY vtc_S886C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S886C4[0]),
  (VTBL_ENTRY)&_ZN6S886C4D1Ev,
  (VTBL_ENTRY)&_ZN6S886C4D0Ev,
  (VTBL_ENTRY)&_ZN6S886C52v2Ev,
  (VTBL_ENTRY)&_ZN6S886C52v3Ev,
  (VTBL_ENTRY)&_ZN6S886C52v4Ev,
  (VTBL_ENTRY)&_ZN6S886C52v5Ev,
  (VTBL_ENTRY)&_ZN6S886C52v6Ev,
  (VTBL_ENTRY)&_ZN6S886C52v7Ev,
  (VTBL_ENTRY)&_ZN6S886C52v8Ev,
  (VTBL_ENTRY)&_ZN6S886C52v9Ev,
  (VTBL_ENTRY)&_ZN6S886C53v10Ev,
  (VTBL_ENTRY)&_ZN6S886C53v11Ev,
  (VTBL_ENTRY)&_ZN6S886C53v12Ev,
  (VTBL_ENTRY)&_ZN6S886C53v13Ev,
  (VTBL_ENTRY)&_ZN6S886C43v14Ev,
  (VTBL_ENTRY)&_ZN6S886C43v15Ev,
  (VTBL_ENTRY)&_ZN6S886C43v16Ev,
  (VTBL_ENTRY)&_ZN6S886C43v17Ev,
  (VTBL_ENTRY)&_ZN6S886C43v18Ev,
  (VTBL_ENTRY)&_ZN6S886C43v19Ev,
  (VTBL_ENTRY)&_ZN6S886C43v20Ev,
};
extern VTBL_ENTRY _ZTI6S886C4[];
extern  VTBL_ENTRY _ZTV6S886C4[];
Class_Descriptor cd_S886C4 = {  "S886C4", // class name
  bases_S886C4, 1,
  &(vtc_S886C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,56), // object size
  NSPAIRA(_ZTI6S886C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S886C4),23, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S886C16_nt  {
  virtual  ~S886C16_nt(); // _ZN10S886C16_ntD1Ev
  virtual void  v21(); // _ZN10S886C16_nt3v21Ev
  virtual void  v22(); // _ZN10S886C16_nt3v22Ev
  virtual void  v23(); // _ZN10S886C16_nt3v23Ev
  S886C16_nt(); // tgen
};
//SIG(-1 S886C16_nt) C1{ vd v1 v2 v3}


 S886C16_nt ::~S886C16_nt(){ note_dtor("S886C16_nt", this);}
void  S886C16_nt ::v21(){vfunc_called(this, "_ZN10S886C16_nt3v21Ev");}
void  S886C16_nt ::v22(){vfunc_called(this, "_ZN10S886C16_nt3v22Ev");}
void  S886C16_nt ::v23(){vfunc_called(this, "_ZN10S886C16_nt3v23Ev");}
S886C16_nt ::S886C16_nt(){ note_ctor("S886C16_nt", this);} // tgen

//skip512 S886C16_nt

#else // __cplusplus

extern void _ZN10S886C16_ntC1Ev();
extern void _ZN10S886C16_ntD1Ev();
Name_Map name_map_S886C16_nt[] = {
  NSPAIR(_ZN10S886C16_ntC1Ev),
  NSPAIR(_ZN10S886C16_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S886C16_nt[];
extern void _ZN10S886C16_ntD1Ev();
extern void _ZN10S886C16_ntD0Ev();
extern void _ZN10S886C16_nt3v21Ev();
extern void _ZN10S886C16_nt3v22Ev();
extern void _ZN10S886C16_nt3v23Ev();
static  VTBL_ENTRY vtc_S886C16_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S886C16_nt[0]),
  (VTBL_ENTRY)&_ZN10S886C16_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S886C16_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S886C16_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S886C16_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S886C16_nt3v23Ev,
};
extern VTBL_ENTRY _ZTI10S886C16_nt[];
VTBL_ENTRY *P__ZTI10S886C16_nt = _ZTI10S886C16_nt; 
extern  VTBL_ENTRY _ZTV10S886C16_nt[];
Class_Descriptor cd_S886C16_nt = {  "S886C16_nt", // class name
  0,0,//no base classes
  &(vtc_S886C16_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S886C16_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S886C16_nt),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S886C15  : S886C16_nt {
  virtual  ~S886C15(); // _ZN7S886C15D1Ev
  virtual void  v24(); // _ZN7S886C153v24Ev
  virtual void  v25(); // _ZN7S886C153v25Ev
  virtual void  v26(); // _ZN7S886C153v26Ev
  virtual void  v27(); // _ZN7S886C153v27Ev
  S886C15(); // tgen
};
//SIG(-1 S886C15) C1{ BC2{ vd v5 v6 v7} vd v1 v2 v3 v4}


 S886C15 ::~S886C15(){ note_dtor("S886C15", this);}
void  S886C15 ::v24(){vfunc_called(this, "_ZN7S886C153v24Ev");}
void  S886C15 ::v25(){vfunc_called(this, "_ZN7S886C153v25Ev");}
void  S886C15 ::v26(){vfunc_called(this, "_ZN7S886C153v26Ev");}
void  S886C15 ::v27(){vfunc_called(this, "_ZN7S886C153v27Ev");}
S886C15 ::S886C15(){ note_ctor("S886C15", this);} // tgen

static void Test_S886C15()
{
  extern Class_Descriptor cd_S886C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S886C15, buf);
    S886C15 *dp, &lv = *(dp=new (buf) S886C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S886C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S886C15)");
    check_base_class_offset(lv, (S886C16_nt*), 0, "S886C15");
    test_class_info(&lv, &cd_S886C15);
    dp->~S886C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS886C15(Test_S886C15, "S886C15", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S886C15C1Ev();
extern void _ZN7S886C15D1Ev();
Name_Map name_map_S886C15[] = {
  NSPAIR(_ZN7S886C15C1Ev),
  NSPAIR(_ZN7S886C15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S886C16_nt;
extern VTBL_ENTRY _ZTI10S886C16_nt[];
extern  VTBL_ENTRY _ZTV10S886C16_nt[];
static Base_Class bases_S886C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S886C16_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S886C15[];
extern void _ZN7S886C15D1Ev();
extern void _ZN7S886C15D0Ev();
extern void _ZN10S886C16_nt3v21Ev();
extern void _ZN10S886C16_nt3v22Ev();
extern void _ZN10S886C16_nt3v23Ev();
extern void _ZN7S886C153v24Ev();
extern void _ZN7S886C153v25Ev();
extern void _ZN7S886C153v26Ev();
extern void _ZN7S886C153v27Ev();
static  VTBL_ENTRY vtc_S886C15[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S886C15[0]),
  (VTBL_ENTRY)&_ZN7S886C15D1Ev,
  (VTBL_ENTRY)&_ZN7S886C15D0Ev,
  (VTBL_ENTRY)&_ZN10S886C16_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S886C16_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S886C16_nt3v23Ev,
  (VTBL_ENTRY)&_ZN7S886C153v24Ev,
  (VTBL_ENTRY)&_ZN7S886C153v25Ev,
  (VTBL_ENTRY)&_ZN7S886C153v26Ev,
  (VTBL_ENTRY)&_ZN7S886C153v27Ev,
};
extern VTBL_ENTRY _ZTI7S886C15[];
extern  VTBL_ENTRY _ZTV7S886C15[];
Class_Descriptor cd_S886C15 = {  "S886C15", // class name
  bases_S886C15, 1,
  &(vtc_S886C15[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S886C15),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S886C15),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S886C14  : S886C15 {
  ::S886C12_nt s886c14f0;
  ::S886C10_nt s886c14f1;
  char s886c14f2;
  virtual  ~S886C14(); // _ZN7S886C14D1Ev
  virtual void  v28(); // _ZN7S886C143v28Ev
  virtual void  v29(); // _ZN7S886C143v29Ev
  virtual void  v30(); // _ZN7S886C143v30Ev
  S886C14(); // tgen
};
//SIG(-1 S886C14) C1{ BC2{ BC3{ vd v4 v5 v6} vd v7 v8 v9 v10} vd v1 v2 v3 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ Fl[4]}} Fc}


 S886C14 ::~S886C14(){ note_dtor("S886C14", this);}
void  S886C14 ::v28(){vfunc_called(this, "_ZN7S886C143v28Ev");}
void  S886C14 ::v29(){vfunc_called(this, "_ZN7S886C143v29Ev");}
void  S886C14 ::v30(){vfunc_called(this, "_ZN7S886C143v30Ev");}
S886C14 ::S886C14(){ note_ctor("S886C14", this);} // tgen

static void Test_S886C14()
{
  extern Class_Descriptor cd_S886C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,11)];
    init_test(&cd_S886C14, buf);
    S886C14 *dp, &lv = *(dp=new (buf) S886C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,40), "sizeof(S886C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S886C14)");
    check_base_class_offset(lv, (S886C16_nt*)(S886C15*), 0, "S886C14");
    check_base_class_offset(lv, (S886C15*), 0, "S886C14");
    check_field_offset(lv, s886c14f0, ABISELECT(8,4), "S886C14.s886c14f0");
    check_field_offset(lv, s886c14f1, ABISELECT(32,20), "S886C14.s886c14f1");
    check_field_offset(lv, s886c14f2, ABISELECT(64,36), "S886C14.s886c14f2");
    test_class_info(&lv, &cd_S886C14);
    dp->~S886C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS886C14(Test_S886C14, "S886C14", ABISELECT(72,40));

#else // __cplusplus

extern void _ZN7S886C14C1Ev();
extern void _ZN7S886C14D1Ev();
Name_Map name_map_S886C14[] = {
  NSPAIR(_ZN7S886C14C1Ev),
  NSPAIR(_ZN7S886C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S886C16_nt;
extern VTBL_ENTRY _ZTI10S886C16_nt[];
extern  VTBL_ENTRY _ZTV10S886C16_nt[];
extern Class_Descriptor cd_S886C15;
extern VTBL_ENTRY _ZTI7S886C15[];
extern  VTBL_ENTRY _ZTV7S886C15[];
static Base_Class bases_S886C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S886C16_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S886C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S886C14[];
extern void _ZN7S886C14D1Ev();
extern void _ZN7S886C14D0Ev();
extern void _ZN10S886C16_nt3v21Ev();
extern void _ZN10S886C16_nt3v22Ev();
extern void _ZN10S886C16_nt3v23Ev();
extern void _ZN7S886C153v24Ev();
extern void _ZN7S886C153v25Ev();
extern void _ZN7S886C153v26Ev();
extern void _ZN7S886C153v27Ev();
extern void _ZN7S886C143v28Ev();
extern void _ZN7S886C143v29Ev();
extern void _ZN7S886C143v30Ev();
static  VTBL_ENTRY vtc_S886C14[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S886C14[0]),
  (VTBL_ENTRY)&_ZN7S886C14D1Ev,
  (VTBL_ENTRY)&_ZN7S886C14D0Ev,
  (VTBL_ENTRY)&_ZN10S886C16_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S886C16_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S886C16_nt3v23Ev,
  (VTBL_ENTRY)&_ZN7S886C153v24Ev,
  (VTBL_ENTRY)&_ZN7S886C153v25Ev,
  (VTBL_ENTRY)&_ZN7S886C153v26Ev,
  (VTBL_ENTRY)&_ZN7S886C153v27Ev,
  (VTBL_ENTRY)&_ZN7S886C143v28Ev,
  (VTBL_ENTRY)&_ZN7S886C143v29Ev,
  (VTBL_ENTRY)&_ZN7S886C143v30Ev,
};
extern VTBL_ENTRY _ZTI7S886C14[];
extern  VTBL_ENTRY _ZTV7S886C14[];
Class_Descriptor cd_S886C14 = {  "S886C14", // class name
  bases_S886C14, 2,
  &(vtc_S886C14[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI7S886C14),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S886C14),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S886C20  {
  virtual  ~S886C20(); // _ZN7S886C20D1Ev
  virtual void  v31(); // _ZN7S886C203v31Ev
  virtual void  v32(); // _ZN7S886C203v32Ev
  virtual void  v33(); // _ZN7S886C203v33Ev
  virtual void  v34(); // _ZN7S886C203v34Ev
  virtual void  v35(); // _ZN7S886C203v35Ev
  virtual void  v36(); // _ZN7S886C203v36Ev
  virtual void  v37(); // _ZN7S886C203v37Ev
  virtual void  v38(); // _ZN7S886C203v38Ev
  virtual void  v39(); // _ZN7S886C203v39Ev
  virtual void  v40(); // _ZN7S886C203v40Ev
  virtual void  v41(); // _ZN7S886C203v41Ev
  virtual void  v42(); // _ZN7S886C203v42Ev
  virtual void  v43(); // _ZN7S886C203v43Ev
  virtual void  v44(); // _ZN7S886C203v44Ev
  virtual void  v45(); // _ZN7S886C203v45Ev
  virtual void  v46(); // _ZN7S886C203v46Ev
  virtual void  v47(); // _ZN7S886C203v47Ev
  virtual void  v48(); // _ZN7S886C203v48Ev
  virtual void  v49(); // _ZN7S886C203v49Ev
  virtual void  v50(); // _ZN7S886C203v50Ev
  virtual void  v51(); // _ZN7S886C203v51Ev
  virtual void  v52(); // _ZN7S886C203v52Ev
  virtual void  v53(); // _ZN7S886C203v53Ev
  virtual void  v54(); // _ZN7S886C203v54Ev
  virtual void  v55(); // _ZN7S886C203v55Ev
  virtual void  v56(); // _ZN7S886C203v56Ev
  S886C20(); // tgen
};
//SIG(-1 S886C20) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26}


 S886C20 ::~S886C20(){ note_dtor("S886C20", this);}
void  S886C20 ::v31(){vfunc_called(this, "_ZN7S886C203v31Ev");}
void  S886C20 ::v32(){vfunc_called(this, "_ZN7S886C203v32Ev");}
void  S886C20 ::v33(){vfunc_called(this, "_ZN7S886C203v33Ev");}
void  S886C20 ::v34(){vfunc_called(this, "_ZN7S886C203v34Ev");}
void  S886C20 ::v35(){vfunc_called(this, "_ZN7S886C203v35Ev");}
void  S886C20 ::v36(){vfunc_called(this, "_ZN7S886C203v36Ev");}
void  S886C20 ::v37(){vfunc_called(this, "_ZN7S886C203v37Ev");}
void  S886C20 ::v38(){vfunc_called(this, "_ZN7S886C203v38Ev");}
void  S886C20 ::v39(){vfunc_called(this, "_ZN7S886C203v39Ev");}
void  S886C20 ::v40(){vfunc_called(this, "_ZN7S886C203v40Ev");}
void  S886C20 ::v41(){vfunc_called(this, "_ZN7S886C203v41Ev");}
void  S886C20 ::v42(){vfunc_called(this, "_ZN7S886C203v42Ev");}
void  S886C20 ::v43(){vfunc_called(this, "_ZN7S886C203v43Ev");}
void  S886C20 ::v44(){vfunc_called(this, "_ZN7S886C203v44Ev");}
void  S886C20 ::v45(){vfunc_called(this, "_ZN7S886C203v45Ev");}
void  S886C20 ::v46(){vfunc_called(this, "_ZN7S886C203v46Ev");}
void  S886C20 ::v47(){vfunc_called(this, "_ZN7S886C203v47Ev");}
void  S886C20 ::v48(){vfunc_called(this, "_ZN7S886C203v48Ev");}
void  S886C20 ::v49(){vfunc_called(this, "_ZN7S886C203v49Ev");}
void  S886C20 ::v50(){vfunc_called(this, "_ZN7S886C203v50Ev");}
void  S886C20 ::v51(){vfunc_called(this, "_ZN7S886C203v51Ev");}
void  S886C20 ::v52(){vfunc_called(this, "_ZN7S886C203v52Ev");}
void  S886C20 ::v53(){vfunc_called(this, "_ZN7S886C203v53Ev");}
void  S886C20 ::v54(){vfunc_called(this, "_ZN7S886C203v54Ev");}
void  S886C20 ::v55(){vfunc_called(this, "_ZN7S886C203v55Ev");}
void  S886C20 ::v56(){vfunc_called(this, "_ZN7S886C203v56Ev");}
S886C20 ::S886C20(){ note_ctor("S886C20", this);} // tgen

static void Test_S886C20()
{
  extern Class_Descriptor cd_S886C20;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S886C20, buf);
    S886C20 *dp, &lv = *(dp=new (buf) S886C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S886C20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S886C20)");
    test_class_info(&lv, &cd_S886C20);
    dp->~S886C20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS886C20(Test_S886C20, "S886C20", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S886C20C1Ev();
extern void _ZN7S886C20D1Ev();
Name_Map name_map_S886C20[] = {
  NSPAIR(_ZN7S886C20C1Ev),
  NSPAIR(_ZN7S886C20D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S886C20[];
extern void _ZN7S886C20D1Ev();
extern void _ZN7S886C20D0Ev();
extern void _ZN7S886C203v31Ev();
extern void _ZN7S886C203v32Ev();
extern void _ZN7S886C203v33Ev();
extern void _ZN7S886C203v34Ev();
extern void _ZN7S886C203v35Ev();
extern void _ZN7S886C203v36Ev();
extern void _ZN7S886C203v37Ev();
extern void _ZN7S886C203v38Ev();
extern void _ZN7S886C203v39Ev();
extern void _ZN7S886C203v40Ev();
extern void _ZN7S886C203v41Ev();
extern void _ZN7S886C203v42Ev();
extern void _ZN7S886C203v43Ev();
extern void _ZN7S886C203v44Ev();
extern void _ZN7S886C203v45Ev();
extern void _ZN7S886C203v46Ev();
extern void _ZN7S886C203v47Ev();
extern void _ZN7S886C203v48Ev();
extern void _ZN7S886C203v49Ev();
extern void _ZN7S886C203v50Ev();
extern void _ZN7S886C203v51Ev();
extern void _ZN7S886C203v52Ev();
extern void _ZN7S886C203v53Ev();
extern void _ZN7S886C203v54Ev();
extern void _ZN7S886C203v55Ev();
extern void _ZN7S886C203v56Ev();
static  VTBL_ENTRY vtc_S886C20[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S886C20[0]),
  (VTBL_ENTRY)&_ZN7S886C20D1Ev,
  (VTBL_ENTRY)&_ZN7S886C20D0Ev,
  (VTBL_ENTRY)&_ZN7S886C203v31Ev,
  (VTBL_ENTRY)&_ZN7S886C203v32Ev,
  (VTBL_ENTRY)&_ZN7S886C203v33Ev,
  (VTBL_ENTRY)&_ZN7S886C203v34Ev,
  (VTBL_ENTRY)&_ZN7S886C203v35Ev,
  (VTBL_ENTRY)&_ZN7S886C203v36Ev,
  (VTBL_ENTRY)&_ZN7S886C203v37Ev,
  (VTBL_ENTRY)&_ZN7S886C203v38Ev,
  (VTBL_ENTRY)&_ZN7S886C203v39Ev,
  (VTBL_ENTRY)&_ZN7S886C203v40Ev,
  (VTBL_ENTRY)&_ZN7S886C203v41Ev,
  (VTBL_ENTRY)&_ZN7S886C203v42Ev,
  (VTBL_ENTRY)&_ZN7S886C203v43Ev,
  (VTBL_ENTRY)&_ZN7S886C203v44Ev,
  (VTBL_ENTRY)&_ZN7S886C203v45Ev,
  (VTBL_ENTRY)&_ZN7S886C203v46Ev,
  (VTBL_ENTRY)&_ZN7S886C203v47Ev,
  (VTBL_ENTRY)&_ZN7S886C203v48Ev,
  (VTBL_ENTRY)&_ZN7S886C203v49Ev,
  (VTBL_ENTRY)&_ZN7S886C203v50Ev,
  (VTBL_ENTRY)&_ZN7S886C203v51Ev,
  (VTBL_ENTRY)&_ZN7S886C203v52Ev,
  (VTBL_ENTRY)&_ZN7S886C203v53Ev,
  (VTBL_ENTRY)&_ZN7S886C203v54Ev,
  (VTBL_ENTRY)&_ZN7S886C203v55Ev,
  (VTBL_ENTRY)&_ZN7S886C203v56Ev,
};
extern VTBL_ENTRY _ZTI7S886C20[];
extern  VTBL_ENTRY _ZTV7S886C20[];
Class_Descriptor cd_S886C20 = {  "S886C20", // class name
  0,0,//no base classes
  &(vtc_S886C20[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S886C20),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S886C20),30, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S886C23  {
  void *s886c23f0;
  int s886c23f1[4];
  char s886c23f2;
  int s886c23f3[3];
  void  mf886c23(); // _ZN7S886C238mf886c23Ev
};
//SIG(-1 S886C23) C1{ m Fp Fi[4] Fc Fi[3]}


void  S886C23 ::mf886c23(){}

static void Test_S886C23()
{
  {
    init_simple_test("S886C23");
    S886C23 lv;
    check2(sizeof(lv), ABISELECT(40,36), "sizeof(S886C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S886C23)");
    check_field_offset(lv, s886c23f0, 0, "S886C23.s886c23f0");
    check_field_offset(lv, s886c23f1, ABISELECT(8,4), "S886C23.s886c23f1");
    check_field_offset(lv, s886c23f2, ABISELECT(24,20), "S886C23.s886c23f2");
    check_field_offset(lv, s886c23f3, ABISELECT(28,24), "S886C23.s886c23f3");
  }
}
static Arrange_To_Call_Me vS886C23(Test_S886C23, "S886C23", ABISELECT(40,36));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S886C3  : S886C4 , S886C14 , S886C20 {
  ::S1587C6_nt s886c3f0;
  char s886c3f1[2];
  int s886c3f2;
  void *s886c3f3[5];
  char s886c3f4[2];
  void *s886c3f5;
  ::S886C23 s886c3f6;
  __tsi64 s886c3f7[2];
  int s886c3f8[2];
  virtual  ~S886C3(); // _ZN6S886C3D1Ev
  virtual void  v57(); // _ZN6S886C33v57Ev
  virtual void  v58(); // _ZN6S886C33v58Ev
  virtual void  v59(); // _ZN6S886C33v59Ev
  virtual void  v60(); // _ZN6S886C33v60Ev
  virtual void  v61(); // _ZN6S886C33v61Ev
  virtual void  v62(); // _ZN6S886C33v62Ev
  virtual void  v63(); // _ZN6S886C33v63Ev
  virtual void  v64(); // _ZN6S886C33v64Ev
  virtual void  v65(); // _ZN6S886C33v65Ev
  virtual void  v66(); // _ZN6S886C33v66Ev
  virtual void  v67(); // _ZN6S886C33v67Ev
  virtual void  v68(); // _ZN6S886C33v68Ev
  virtual void  v69(); // _ZN6S886C33v69Ev
  virtual void  v70(); // _ZN6S886C33v70Ev
  virtual void  v71(); // _ZN6S886C33v71Ev
  virtual void  v72(); // _ZN6S886C33v72Ev
  virtual void  v73(); // _ZN6S886C33v73Ev
  virtual void  v74(); // _ZN6S886C33v74Ev
  virtual void  v75(); // _ZN6S886C33v75Ev
  virtual void  v76(); // _ZN6S886C33v76Ev
  virtual void  v77(); // _ZN6S886C33v77Ev
  virtual void  v78(); // _ZN6S886C33v78Ev
  virtual void  v79(); // _ZN6S886C33v79Ev
  virtual void  v80(); // _ZN6S886C33v80Ev
  virtual void  v81(); // _ZN6S886C33v81Ev
  virtual void  v82(); // _ZN6S886C33v82Ev
  virtual void  v83(); // _ZN6S886C33v83Ev
  virtual void  v84(); // _ZN6S886C33v84Ev
  virtual void  v85(); // _ZN6S886C33v85Ev
  virtual void  v86(); // _ZN6S886C33v86Ev
  virtual void  v87(); // _ZN6S886C33v87Ev
  virtual void  v88(); // _ZN6S886C33v88Ev
  S886C3(); // tgen
};
//SIG(-1 S886C3) C1{ BC2{ BC3{ vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 Fp FC4{ BC5{ m Fp Fi FC6{ m} FC7{ m}}} FC8{ m FC9{ Fl[4]}} Fc} vd v45 v46 v47 v48 v49 v50 v51 FC10{ m Fp Fi[2] FC7}} BC11{ BC12{ BC13{ vd v52 v53 v54} vd v55 v56 v57 v58} vd v59 v60 v61 FC10 FC8 Fc} BC14{ vd v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 FC15{ m Fp Fi FC6} Fc[2] Fi Fp[5] Fc[2] Fp FC16{ m Fp Fi[4] Fc Fi[3]} FL[2] Fi[2]}


 S886C3 ::~S886C3(){ note_dtor("S886C3", this);}
void  S886C3 ::v57(){vfunc_called(this, "_ZN6S886C33v57Ev");}
void  S886C3 ::v58(){vfunc_called(this, "_ZN6S886C33v58Ev");}
void  S886C3 ::v59(){vfunc_called(this, "_ZN6S886C33v59Ev");}
void  S886C3 ::v60(){vfunc_called(this, "_ZN6S886C33v60Ev");}
void  S886C3 ::v61(){vfunc_called(this, "_ZN6S886C33v61Ev");}
void  S886C3 ::v62(){vfunc_called(this, "_ZN6S886C33v62Ev");}
void  S886C3 ::v63(){vfunc_called(this, "_ZN6S886C33v63Ev");}
void  S886C3 ::v64(){vfunc_called(this, "_ZN6S886C33v64Ev");}
void  S886C3 ::v65(){vfunc_called(this, "_ZN6S886C33v65Ev");}
void  S886C3 ::v66(){vfunc_called(this, "_ZN6S886C33v66Ev");}
void  S886C3 ::v67(){vfunc_called(this, "_ZN6S886C33v67Ev");}
void  S886C3 ::v68(){vfunc_called(this, "_ZN6S886C33v68Ev");}
void  S886C3 ::v69(){vfunc_called(this, "_ZN6S886C33v69Ev");}
void  S886C3 ::v70(){vfunc_called(this, "_ZN6S886C33v70Ev");}
void  S886C3 ::v71(){vfunc_called(this, "_ZN6S886C33v71Ev");}
void  S886C3 ::v72(){vfunc_called(this, "_ZN6S886C33v72Ev");}
void  S886C3 ::v73(){vfunc_called(this, "_ZN6S886C33v73Ev");}
void  S886C3 ::v74(){vfunc_called(this, "_ZN6S886C33v74Ev");}
void  S886C3 ::v75(){vfunc_called(this, "_ZN6S886C33v75Ev");}
void  S886C3 ::v76(){vfunc_called(this, "_ZN6S886C33v76Ev");}
void  S886C3 ::v77(){vfunc_called(this, "_ZN6S886C33v77Ev");}
void  S886C3 ::v78(){vfunc_called(this, "_ZN6S886C33v78Ev");}
void  S886C3 ::v79(){vfunc_called(this, "_ZN6S886C33v79Ev");}
void  S886C3 ::v80(){vfunc_called(this, "_ZN6S886C33v80Ev");}
void  S886C3 ::v81(){vfunc_called(this, "_ZN6S886C33v81Ev");}
void  S886C3 ::v82(){vfunc_called(this, "_ZN6S886C33v82Ev");}
void  S886C3 ::v83(){vfunc_called(this, "_ZN6S886C33v83Ev");}
void  S886C3 ::v84(){vfunc_called(this, "_ZN6S886C33v84Ev");}
void  S886C3 ::v85(){vfunc_called(this, "_ZN6S886C33v85Ev");}
void  S886C3 ::v86(){vfunc_called(this, "_ZN6S886C33v86Ev");}
void  S886C3 ::v87(){vfunc_called(this, "_ZN6S886C33v87Ev");}
void  S886C3 ::v88(){vfunc_called(this, "_ZN6S886C33v88Ev");}
S886C3 ::S886C3(){ note_ctor("S886C3", this);} // tgen

static void Test_S886C3()
{
  extern Class_Descriptor cd_S886C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(41,53)];
    init_test(&cd_S886C3, buf);
    S886C3 *dp, &lv = *(dp=new (buf) S886C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(320,208), "sizeof(S886C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S886C3)");
    check_base_class_offset(lv, (S886C5*)(S886C4*), 0, "S886C3");
    check_base_class_offset(lv, (S886C4*), 0, "S886C3");
    check_base_class_offset(lv, (S886C16_nt*)(S886C15*)(S886C14*), ABISELECT(96,56), "S886C3");
    check_base_class_offset(lv, (S886C15*)(S886C14*), ABISELECT(96,56), "S886C3");
    check_base_class_offset(lv, (S886C14*), ABISELECT(96,56), "S886C3");
    check_base_class_offset(lv, (S886C20*), ABISELECT(168,96), "S886C3");
    check_field_offset(lv, s886c3f0, ABISELECT(176,100), "S886C3.s886c3f0");
    check_field_offset(lv, s886c3f1, ABISELECT(192,112), "S886C3.s886c3f1");
    check_field_offset(lv, s886c3f2, ABISELECT(196,116), "S886C3.s886c3f2");
    check_field_offset(lv, s886c3f3, ABISELECT(200,120), "S886C3.s886c3f3");
    check_field_offset(lv, s886c3f4, ABISELECT(240,140), "S886C3.s886c3f4");
    check_field_offset(lv, s886c3f5, ABISELECT(248,144), "S886C3.s886c3f5");
    check_field_offset(lv, s886c3f6, ABISELECT(256,148), "S886C3.s886c3f6");
    check_field_offset(lv, s886c3f7, ABISELECT(296,184), "S886C3.s886c3f7");
    check_field_offset(lv, s886c3f8, ABISELECT(312,200), "S886C3.s886c3f8");
    test_class_info(&lv, &cd_S886C3);
    dp->~S886C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS886C3(Test_S886C3, "S886C3", ABISELECT(320,208));

#else // __cplusplus

extern void _ZN6S886C3C1Ev();
extern void _ZN6S886C3D1Ev();
Name_Map name_map_S886C3[] = {
  NSPAIR(_ZN6S886C3C1Ev),
  NSPAIR(_ZN6S886C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S886C5;
extern VTBL_ENTRY _ZTI6S886C5[];
extern  VTBL_ENTRY _ZTV6S886C5[];
extern Class_Descriptor cd_S886C4;
extern VTBL_ENTRY _ZTI6S886C4[];
extern  VTBL_ENTRY _ZTV6S886C4[];
extern Class_Descriptor cd_S886C16_nt;
extern VTBL_ENTRY _ZTI10S886C16_nt[];
extern  VTBL_ENTRY _ZTV10S886C16_nt[];
extern Class_Descriptor cd_S886C15;
extern VTBL_ENTRY _ZTI7S886C15[];
extern  VTBL_ENTRY _ZTV7S886C15[];
extern Class_Descriptor cd_S886C14;
extern VTBL_ENTRY _ZTI7S886C14[];
extern  VTBL_ENTRY _ZTV7S886C14[];
extern Class_Descriptor cd_S886C20;
extern VTBL_ENTRY _ZTI7S886C20[];
extern  VTBL_ENTRY _ZTV7S886C20[];
static Base_Class bases_S886C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S886C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S886C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S886C16_nt,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S886C15,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S886C14,    ABISELECT(96,56), //bcp->offset
    55, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S886C20,    ABISELECT(168,96), //bcp->offset
    69, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S886C3[];
extern void _ZN6S886C3D1Ev();
extern void _ZN6S886C3D0Ev();
extern void _ZN6S886C52v2Ev();
extern void _ZN6S886C52v3Ev();
extern void _ZN6S886C52v4Ev();
extern void _ZN6S886C52v5Ev();
extern void _ZN6S886C52v6Ev();
extern void _ZN6S886C52v7Ev();
extern void _ZN6S886C52v8Ev();
extern void _ZN6S886C52v9Ev();
extern void _ZN6S886C53v10Ev();
extern void _ZN6S886C53v11Ev();
extern void _ZN6S886C53v12Ev();
extern void _ZN6S886C53v13Ev();
extern void _ZN6S886C43v14Ev();
extern void _ZN6S886C43v15Ev();
extern void _ZN6S886C43v16Ev();
extern void _ZN6S886C43v17Ev();
extern void _ZN6S886C43v18Ev();
extern void _ZN6S886C43v19Ev();
extern void _ZN6S886C43v20Ev();
extern void _ZN6S886C33v57Ev();
extern void _ZN6S886C33v58Ev();
extern void _ZN6S886C33v59Ev();
extern void _ZN6S886C33v60Ev();
extern void _ZN6S886C33v61Ev();
extern void _ZN6S886C33v62Ev();
extern void _ZN6S886C33v63Ev();
extern void _ZN6S886C33v64Ev();
extern void _ZN6S886C33v65Ev();
extern void _ZN6S886C33v66Ev();
extern void _ZN6S886C33v67Ev();
extern void _ZN6S886C33v68Ev();
extern void _ZN6S886C33v69Ev();
extern void _ZN6S886C33v70Ev();
extern void _ZN6S886C33v71Ev();
extern void _ZN6S886C33v72Ev();
extern void _ZN6S886C33v73Ev();
extern void _ZN6S886C33v74Ev();
extern void _ZN6S886C33v75Ev();
extern void _ZN6S886C33v76Ev();
extern void _ZN6S886C33v77Ev();
extern void _ZN6S886C33v78Ev();
extern void _ZN6S886C33v79Ev();
extern void _ZN6S886C33v80Ev();
extern void _ZN6S886C33v81Ev();
extern void _ZN6S886C33v82Ev();
extern void _ZN6S886C33v83Ev();
extern void _ZN6S886C33v84Ev();
extern void _ZN6S886C33v85Ev();
extern void _ZN6S886C33v86Ev();
extern void _ZN6S886C33v87Ev();
extern void _ZN6S886C33v88Ev();
extern void ABISELECT(_ZThn96_N6S886C3D1Ev,_ZThn56_N6S886C3D1Ev)();
extern void ABISELECT(_ZThn96_N6S886C3D0Ev,_ZThn56_N6S886C3D0Ev)();
extern void _ZN10S886C16_nt3v21Ev();
extern void _ZN10S886C16_nt3v22Ev();
extern void _ZN10S886C16_nt3v23Ev();
extern void _ZN7S886C153v24Ev();
extern void _ZN7S886C153v25Ev();
extern void _ZN7S886C153v26Ev();
extern void _ZN7S886C153v27Ev();
extern void _ZN7S886C143v28Ev();
extern void _ZN7S886C143v29Ev();
extern void _ZN7S886C143v30Ev();
extern void ABISELECT(_ZThn168_N6S886C3D1Ev,_ZThn96_N6S886C3D1Ev)();
extern void ABISELECT(_ZThn168_N6S886C3D0Ev,_ZThn96_N6S886C3D0Ev)();
extern void _ZN7S886C203v31Ev();
extern void _ZN7S886C203v32Ev();
extern void _ZN7S886C203v33Ev();
extern void _ZN7S886C203v34Ev();
extern void _ZN7S886C203v35Ev();
extern void _ZN7S886C203v36Ev();
extern void _ZN7S886C203v37Ev();
extern void _ZN7S886C203v38Ev();
extern void _ZN7S886C203v39Ev();
extern void _ZN7S886C203v40Ev();
extern void _ZN7S886C203v41Ev();
extern void _ZN7S886C203v42Ev();
extern void _ZN7S886C203v43Ev();
extern void _ZN7S886C203v44Ev();
extern void _ZN7S886C203v45Ev();
extern void _ZN7S886C203v46Ev();
extern void _ZN7S886C203v47Ev();
extern void _ZN7S886C203v48Ev();
extern void _ZN7S886C203v49Ev();
extern void _ZN7S886C203v50Ev();
extern void _ZN7S886C203v51Ev();
extern void _ZN7S886C203v52Ev();
extern void _ZN7S886C203v53Ev();
extern void _ZN7S886C203v54Ev();
extern void _ZN7S886C203v55Ev();
extern void _ZN7S886C203v56Ev();
static  VTBL_ENTRY vtc_S886C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S886C3[0]),
  (VTBL_ENTRY)&_ZN6S886C3D1Ev,
  (VTBL_ENTRY)&_ZN6S886C3D0Ev,
  (VTBL_ENTRY)&_ZN6S886C52v2Ev,
  (VTBL_ENTRY)&_ZN6S886C52v3Ev,
  (VTBL_ENTRY)&_ZN6S886C52v4Ev,
  (VTBL_ENTRY)&_ZN6S886C52v5Ev,
  (VTBL_ENTRY)&_ZN6S886C52v6Ev,
  (VTBL_ENTRY)&_ZN6S886C52v7Ev,
  (VTBL_ENTRY)&_ZN6S886C52v8Ev,
  (VTBL_ENTRY)&_ZN6S886C52v9Ev,
  (VTBL_ENTRY)&_ZN6S886C53v10Ev,
  (VTBL_ENTRY)&_ZN6S886C53v11Ev,
  (VTBL_ENTRY)&_ZN6S886C53v12Ev,
  (VTBL_ENTRY)&_ZN6S886C53v13Ev,
  (VTBL_ENTRY)&_ZN6S886C43v14Ev,
  (VTBL_ENTRY)&_ZN6S886C43v15Ev,
  (VTBL_ENTRY)&_ZN6S886C43v16Ev,
  (VTBL_ENTRY)&_ZN6S886C43v17Ev,
  (VTBL_ENTRY)&_ZN6S886C43v18Ev,
  (VTBL_ENTRY)&_ZN6S886C43v19Ev,
  (VTBL_ENTRY)&_ZN6S886C43v20Ev,
  (VTBL_ENTRY)&_ZN6S886C33v57Ev,
  (VTBL_ENTRY)&_ZN6S886C33v58Ev,
  (VTBL_ENTRY)&_ZN6S886C33v59Ev,
  (VTBL_ENTRY)&_ZN6S886C33v60Ev,
  (VTBL_ENTRY)&_ZN6S886C33v61Ev,
  (VTBL_ENTRY)&_ZN6S886C33v62Ev,
  (VTBL_ENTRY)&_ZN6S886C33v63Ev,
  (VTBL_ENTRY)&_ZN6S886C33v64Ev,
  (VTBL_ENTRY)&_ZN6S886C33v65Ev,
  (VTBL_ENTRY)&_ZN6S886C33v66Ev,
  (VTBL_ENTRY)&_ZN6S886C33v67Ev,
  (VTBL_ENTRY)&_ZN6S886C33v68Ev,
  (VTBL_ENTRY)&_ZN6S886C33v69Ev,
  (VTBL_ENTRY)&_ZN6S886C33v70Ev,
  (VTBL_ENTRY)&_ZN6S886C33v71Ev,
  (VTBL_ENTRY)&_ZN6S886C33v72Ev,
  (VTBL_ENTRY)&_ZN6S886C33v73Ev,
  (VTBL_ENTRY)&_ZN6S886C33v74Ev,
  (VTBL_ENTRY)&_ZN6S886C33v75Ev,
  (VTBL_ENTRY)&_ZN6S886C33v76Ev,
  (VTBL_ENTRY)&_ZN6S886C33v77Ev,
  (VTBL_ENTRY)&_ZN6S886C33v78Ev,
  (VTBL_ENTRY)&_ZN6S886C33v79Ev,
  (VTBL_ENTRY)&_ZN6S886C33v80Ev,
  (VTBL_ENTRY)&_ZN6S886C33v81Ev,
  (VTBL_ENTRY)&_ZN6S886C33v82Ev,
  (VTBL_ENTRY)&_ZN6S886C33v83Ev,
  (VTBL_ENTRY)&_ZN6S886C33v84Ev,
  (VTBL_ENTRY)&_ZN6S886C33v85Ev,
  (VTBL_ENTRY)&_ZN6S886C33v86Ev,
  (VTBL_ENTRY)&_ZN6S886C33v87Ev,
  (VTBL_ENTRY)&_ZN6S886C33v88Ev,
  ABISELECT(-96,-56),
  (VTBL_ENTRY)&(_ZTI6S886C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N6S886C3D1Ev,_ZThn56_N6S886C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N6S886C3D0Ev,_ZThn56_N6S886C3D0Ev),
  (VTBL_ENTRY)&_ZN10S886C16_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S886C16_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S886C16_nt3v23Ev,
  (VTBL_ENTRY)&_ZN7S886C153v24Ev,
  (VTBL_ENTRY)&_ZN7S886C153v25Ev,
  (VTBL_ENTRY)&_ZN7S886C153v26Ev,
  (VTBL_ENTRY)&_ZN7S886C153v27Ev,
  (VTBL_ENTRY)&_ZN7S886C143v28Ev,
  (VTBL_ENTRY)&_ZN7S886C143v29Ev,
  (VTBL_ENTRY)&_ZN7S886C143v30Ev,
  ABISELECT(-168,-96),
  (VTBL_ENTRY)&(_ZTI6S886C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N6S886C3D1Ev,_ZThn96_N6S886C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N6S886C3D0Ev,_ZThn96_N6S886C3D0Ev),
  (VTBL_ENTRY)&_ZN7S886C203v31Ev,
  (VTBL_ENTRY)&_ZN7S886C203v32Ev,
  (VTBL_ENTRY)&_ZN7S886C203v33Ev,
  (VTBL_ENTRY)&_ZN7S886C203v34Ev,
  (VTBL_ENTRY)&_ZN7S886C203v35Ev,
  (VTBL_ENTRY)&_ZN7S886C203v36Ev,
  (VTBL_ENTRY)&_ZN7S886C203v37Ev,
  (VTBL_ENTRY)&_ZN7S886C203v38Ev,
  (VTBL_ENTRY)&_ZN7S886C203v39Ev,
  (VTBL_ENTRY)&_ZN7S886C203v40Ev,
  (VTBL_ENTRY)&_ZN7S886C203v41Ev,
  (VTBL_ENTRY)&_ZN7S886C203v42Ev,
  (VTBL_ENTRY)&_ZN7S886C203v43Ev,
  (VTBL_ENTRY)&_ZN7S886C203v44Ev,
  (VTBL_ENTRY)&_ZN7S886C203v45Ev,
  (VTBL_ENTRY)&_ZN7S886C203v46Ev,
  (VTBL_ENTRY)&_ZN7S886C203v47Ev,
  (VTBL_ENTRY)&_ZN7S886C203v48Ev,
  (VTBL_ENTRY)&_ZN7S886C203v49Ev,
  (VTBL_ENTRY)&_ZN7S886C203v50Ev,
  (VTBL_ENTRY)&_ZN7S886C203v51Ev,
  (VTBL_ENTRY)&_ZN7S886C203v52Ev,
  (VTBL_ENTRY)&_ZN7S886C203v53Ev,
  (VTBL_ENTRY)&_ZN7S886C203v54Ev,
  (VTBL_ENTRY)&_ZN7S886C203v55Ev,
  (VTBL_ENTRY)&_ZN7S886C203v56Ev,
};
extern VTBL_ENTRY _ZTI6S886C3[];
extern  VTBL_ENTRY _ZTV6S886C3[];
Class_Descriptor cd_S886C3 = {  "S886C3", // class name
  bases_S886C3, 6,
  &(vtc_S886C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(320,208), // object size
  NSPAIRA(_ZTI6S886C3),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV6S886C3),99, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S886C26_nt  {
  int s886c26f0[4];
};
//SIG(-1 S886C26_nt) C1{ Fi[4]}



//skip512 S886C26_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S886C25_nt  {
  void *s886c25f0;
  ::S886C26_nt s886c25f1;
  void  mf886c25(); // _ZN10S886C25_nt8mf886c25Ev
};
//SIG(-1 S886C25_nt) C1{ m Fp FC2{ Fi[4]}}


void  S886C25_nt ::mf886c25(){}

//skip512 S886C25_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S886C24  {
  void *s886c24f0;
  ::S886C10_nt s886c24f1;
  ::S886C25_nt s886c24f2;
  int s886c24f3;
  char s886c24f4;
  void  mf886c24(); // _ZN7S886C248mf886c24Ev
};
//SIG(-1 S886C24) C1{ m Fp FC2{ m FC3{ Fl[4]}} FC4{ m Fp FC5{ Fi[4]}} Fi Fc}


void  S886C24 ::mf886c24(){}

static void Test_S886C24()
{
  {
    init_simple_test("S886C24");
    S886C24 lv;
    check2(sizeof(lv), ABISELECT(72,48), "sizeof(S886C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S886C24)");
    check_field_offset(lv, s886c24f0, 0, "S886C24.s886c24f0");
    check_field_offset(lv, s886c24f1, ABISELECT(8,4), "S886C24.s886c24f1");
    check_field_offset(lv, s886c24f2, ABISELECT(40,20), "S886C24.s886c24f2");
    check_field_offset(lv, s886c24f3, ABISELECT(64,40), "S886C24.s886c24f3");
    check_field_offset(lv, s886c24f4, ABISELECT(68,44), "S886C24.s886c24f4");
  }
}
static Arrange_To_Call_Me vS886C24(Test_S886C24, "S886C24", ABISELECT(72,48));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S886C2  : S886C3 {
  ::S886C10_nt s886c2f0;
  ::S886C24 s886c2f1;
  int s886c2f2;
  virtual  ~S886C2(); // _ZN6S886C2D1Ev
  virtual void  v89(); // _ZN6S886C23v89Ev
  virtual void  v90(); // _ZN6S886C23v90Ev
  virtual void  v91(); // _ZN6S886C23v91Ev
  virtual void  v92(); // _ZN6S886C23v92Ev
  virtual void  v93(); // _ZN6S886C23v93Ev
  virtual void  v94(); // _ZN6S886C23v94Ev
  virtual void  v95(); // _ZN6S886C23v95Ev
  virtual void  v96(); // _ZN6S886C23v96Ev
  virtual void  v97(); // _ZN6S886C23v97Ev
  S886C2(); // tgen
};
//SIG(-1 S886C2) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 Fp FC5{ BC6{ m Fp Fi FC7{ m} FC8{ m}}} FC9{ m FC10{ Fl[4]}} Fc} vd v22 v23 v24 v25 v26 v27 v28 FC11{ m Fp Fi[2] FC8}} BC12{ BC13{ BC14{ vd v29 v30 v31} vd v32 v33 v34 v35} vd v36 v37 v38 FC11 FC9 Fc} BC15{ vd v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64} vd v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 FC16{ m Fp Fi FC7} Fc[2] Fi Fp[5] Fc[2] Fp FC17{ m Fp Fi[4] Fc Fi[3]} FL[2] Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 FC9 FC18{ m Fp FC9 FC19{ m Fp FC20{ Fi[4]}} Fi Fc} Fi}


 S886C2 ::~S886C2(){ note_dtor("S886C2", this);}
void  S886C2 ::v89(){vfunc_called(this, "_ZN6S886C23v89Ev");}
void  S886C2 ::v90(){vfunc_called(this, "_ZN6S886C23v90Ev");}
void  S886C2 ::v91(){vfunc_called(this, "_ZN6S886C23v91Ev");}
void  S886C2 ::v92(){vfunc_called(this, "_ZN6S886C23v92Ev");}
void  S886C2 ::v93(){vfunc_called(this, "_ZN6S886C23v93Ev");}
void  S886C2 ::v94(){vfunc_called(this, "_ZN6S886C23v94Ev");}
void  S886C2 ::v95(){vfunc_called(this, "_ZN6S886C23v95Ev");}
void  S886C2 ::v96(){vfunc_called(this, "_ZN6S886C23v96Ev");}
void  S886C2 ::v97(){vfunc_called(this, "_ZN6S886C23v97Ev");}
S886C2 ::S886C2(){ note_ctor("S886C2", this);} // tgen

static void Test_S886C2()
{
  extern Class_Descriptor cd_S886C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(55,70)];
    init_test(&cd_S886C2, buf);
    S886C2 *dp, &lv = *(dp=new (buf) S886C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(432,276), "sizeof(S886C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S886C2)");
    check_base_class_offset(lv, (S886C5*)(S886C4*)(S886C3*), 0, "S886C2");
    check_base_class_offset(lv, (S886C4*)(S886C3*), 0, "S886C2");
    check_base_class_offset(lv, (S886C16_nt*)(S886C15*)(S886C14*)(S886C3*), ABISELECT(96,56), "S886C2");
    check_base_class_offset(lv, (S886C15*)(S886C14*)(S886C3*), ABISELECT(96,56), "S886C2");
    check_base_class_offset(lv, (S886C14*)(S886C3*), ABISELECT(96,56), "S886C2");
    check_base_class_offset(lv, (S886C20*)(S886C3*), ABISELECT(168,96), "S886C2");
    check_base_class_offset(lv, (S886C3*), 0, "S886C2");
    check_field_offset(lv, s886c2f0, ABISELECT(320,208), "S886C2.s886c2f0");
    check_field_offset(lv, s886c2f1, ABISELECT(352,224), "S886C2.s886c2f1");
    check_field_offset(lv, s886c2f2, ABISELECT(424,272), "S886C2.s886c2f2");
    test_class_info(&lv, &cd_S886C2);
    dp->~S886C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS886C2(Test_S886C2, "S886C2", ABISELECT(432,276));

#else // __cplusplus

extern void _ZN6S886C2C1Ev();
extern void _ZN6S886C2D1Ev();
Name_Map name_map_S886C2[] = {
  NSPAIR(_ZN6S886C2C1Ev),
  NSPAIR(_ZN6S886C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S886C5;
extern VTBL_ENTRY _ZTI6S886C5[];
extern  VTBL_ENTRY _ZTV6S886C5[];
extern Class_Descriptor cd_S886C4;
extern VTBL_ENTRY _ZTI6S886C4[];
extern  VTBL_ENTRY _ZTV6S886C4[];
extern Class_Descriptor cd_S886C16_nt;
extern VTBL_ENTRY _ZTI10S886C16_nt[];
extern  VTBL_ENTRY _ZTV10S886C16_nt[];
extern Class_Descriptor cd_S886C15;
extern VTBL_ENTRY _ZTI7S886C15[];
extern  VTBL_ENTRY _ZTV7S886C15[];
extern Class_Descriptor cd_S886C14;
extern VTBL_ENTRY _ZTI7S886C14[];
extern  VTBL_ENTRY _ZTV7S886C14[];
extern Class_Descriptor cd_S886C20;
extern VTBL_ENTRY _ZTI7S886C20[];
extern  VTBL_ENTRY _ZTV7S886C20[];
extern Class_Descriptor cd_S886C3;
extern VTBL_ENTRY _ZTI6S886C3[];
extern  VTBL_ENTRY _ZTV6S886C3[];
static Base_Class bases_S886C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S886C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S886C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S886C16_nt,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S886C15,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S886C14,    ABISELECT(96,56), //bcp->offset
    64, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S886C20,    ABISELECT(168,96), //bcp->offset
    78, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S886C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S886C2[];
extern void _ZN6S886C2D1Ev();
extern void _ZN6S886C2D0Ev();
extern void _ZN6S886C52v2Ev();
extern void _ZN6S886C52v3Ev();
extern void _ZN6S886C52v4Ev();
extern void _ZN6S886C52v5Ev();
extern void _ZN6S886C52v6Ev();
extern void _ZN6S886C52v7Ev();
extern void _ZN6S886C52v8Ev();
extern void _ZN6S886C52v9Ev();
extern void _ZN6S886C53v10Ev();
extern void _ZN6S886C53v11Ev();
extern void _ZN6S886C53v12Ev();
extern void _ZN6S886C53v13Ev();
extern void _ZN6S886C43v14Ev();
extern void _ZN6S886C43v15Ev();
extern void _ZN6S886C43v16Ev();
extern void _ZN6S886C43v17Ev();
extern void _ZN6S886C43v18Ev();
extern void _ZN6S886C43v19Ev();
extern void _ZN6S886C43v20Ev();
extern void _ZN6S886C33v57Ev();
extern void _ZN6S886C33v58Ev();
extern void _ZN6S886C33v59Ev();
extern void _ZN6S886C33v60Ev();
extern void _ZN6S886C33v61Ev();
extern void _ZN6S886C33v62Ev();
extern void _ZN6S886C33v63Ev();
extern void _ZN6S886C33v64Ev();
extern void _ZN6S886C33v65Ev();
extern void _ZN6S886C33v66Ev();
extern void _ZN6S886C33v67Ev();
extern void _ZN6S886C33v68Ev();
extern void _ZN6S886C33v69Ev();
extern void _ZN6S886C33v70Ev();
extern void _ZN6S886C33v71Ev();
extern void _ZN6S886C33v72Ev();
extern void _ZN6S886C33v73Ev();
extern void _ZN6S886C33v74Ev();
extern void _ZN6S886C33v75Ev();
extern void _ZN6S886C33v76Ev();
extern void _ZN6S886C33v77Ev();
extern void _ZN6S886C33v78Ev();
extern void _ZN6S886C33v79Ev();
extern void _ZN6S886C33v80Ev();
extern void _ZN6S886C33v81Ev();
extern void _ZN6S886C33v82Ev();
extern void _ZN6S886C33v83Ev();
extern void _ZN6S886C33v84Ev();
extern void _ZN6S886C33v85Ev();
extern void _ZN6S886C33v86Ev();
extern void _ZN6S886C33v87Ev();
extern void _ZN6S886C33v88Ev();
extern void _ZN6S886C23v89Ev();
extern void _ZN6S886C23v90Ev();
extern void _ZN6S886C23v91Ev();
extern void _ZN6S886C23v92Ev();
extern void _ZN6S886C23v93Ev();
extern void _ZN6S886C23v94Ev();
extern void _ZN6S886C23v95Ev();
extern void _ZN6S886C23v96Ev();
extern void _ZN6S886C23v97Ev();
extern void ABISELECT(_ZThn96_N6S886C2D1Ev,_ZThn56_N6S886C2D1Ev)();
extern void ABISELECT(_ZThn96_N6S886C2D0Ev,_ZThn56_N6S886C2D0Ev)();
extern void _ZN10S886C16_nt3v21Ev();
extern void _ZN10S886C16_nt3v22Ev();
extern void _ZN10S886C16_nt3v23Ev();
extern void _ZN7S886C153v24Ev();
extern void _ZN7S886C153v25Ev();
extern void _ZN7S886C153v26Ev();
extern void _ZN7S886C153v27Ev();
extern void _ZN7S886C143v28Ev();
extern void _ZN7S886C143v29Ev();
extern void _ZN7S886C143v30Ev();
extern void ABISELECT(_ZThn168_N6S886C2D1Ev,_ZThn96_N6S886C2D1Ev)();
extern void ABISELECT(_ZThn168_N6S886C2D0Ev,_ZThn96_N6S886C2D0Ev)();
extern void _ZN7S886C203v31Ev();
extern void _ZN7S886C203v32Ev();
extern void _ZN7S886C203v33Ev();
extern void _ZN7S886C203v34Ev();
extern void _ZN7S886C203v35Ev();
extern void _ZN7S886C203v36Ev();
extern void _ZN7S886C203v37Ev();
extern void _ZN7S886C203v38Ev();
extern void _ZN7S886C203v39Ev();
extern void _ZN7S886C203v40Ev();
extern void _ZN7S886C203v41Ev();
extern void _ZN7S886C203v42Ev();
extern void _ZN7S886C203v43Ev();
extern void _ZN7S886C203v44Ev();
extern void _ZN7S886C203v45Ev();
extern void _ZN7S886C203v46Ev();
extern void _ZN7S886C203v47Ev();
extern void _ZN7S886C203v48Ev();
extern void _ZN7S886C203v49Ev();
extern void _ZN7S886C203v50Ev();
extern void _ZN7S886C203v51Ev();
extern void _ZN7S886C203v52Ev();
extern void _ZN7S886C203v53Ev();
extern void _ZN7S886C203v54Ev();
extern void _ZN7S886C203v55Ev();
extern void _ZN7S886C203v56Ev();
static  VTBL_ENTRY vtc_S886C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S886C2[0]),
  (VTBL_ENTRY)&_ZN6S886C2D1Ev,
  (VTBL_ENTRY)&_ZN6S886C2D0Ev,
  (VTBL_ENTRY)&_ZN6S886C52v2Ev,
  (VTBL_ENTRY)&_ZN6S886C52v3Ev,
  (VTBL_ENTRY)&_ZN6S886C52v4Ev,
  (VTBL_ENTRY)&_ZN6S886C52v5Ev,
  (VTBL_ENTRY)&_ZN6S886C52v6Ev,
  (VTBL_ENTRY)&_ZN6S886C52v7Ev,
  (VTBL_ENTRY)&_ZN6S886C52v8Ev,
  (VTBL_ENTRY)&_ZN6S886C52v9Ev,
  (VTBL_ENTRY)&_ZN6S886C53v10Ev,
  (VTBL_ENTRY)&_ZN6S886C53v11Ev,
  (VTBL_ENTRY)&_ZN6S886C53v12Ev,
  (VTBL_ENTRY)&_ZN6S886C53v13Ev,
  (VTBL_ENTRY)&_ZN6S886C43v14Ev,
  (VTBL_ENTRY)&_ZN6S886C43v15Ev,
  (VTBL_ENTRY)&_ZN6S886C43v16Ev,
  (VTBL_ENTRY)&_ZN6S886C43v17Ev,
  (VTBL_ENTRY)&_ZN6S886C43v18Ev,
  (VTBL_ENTRY)&_ZN6S886C43v19Ev,
  (VTBL_ENTRY)&_ZN6S886C43v20Ev,
  (VTBL_ENTRY)&_ZN6S886C33v57Ev,
  (VTBL_ENTRY)&_ZN6S886C33v58Ev,
  (VTBL_ENTRY)&_ZN6S886C33v59Ev,
  (VTBL_ENTRY)&_ZN6S886C33v60Ev,
  (VTBL_ENTRY)&_ZN6S886C33v61Ev,
  (VTBL_ENTRY)&_ZN6S886C33v62Ev,
  (VTBL_ENTRY)&_ZN6S886C33v63Ev,
  (VTBL_ENTRY)&_ZN6S886C33v64Ev,
  (VTBL_ENTRY)&_ZN6S886C33v65Ev,
  (VTBL_ENTRY)&_ZN6S886C33v66Ev,
  (VTBL_ENTRY)&_ZN6S886C33v67Ev,
  (VTBL_ENTRY)&_ZN6S886C33v68Ev,
  (VTBL_ENTRY)&_ZN6S886C33v69Ev,
  (VTBL_ENTRY)&_ZN6S886C33v70Ev,
  (VTBL_ENTRY)&_ZN6S886C33v71Ev,
  (VTBL_ENTRY)&_ZN6S886C33v72Ev,
  (VTBL_ENTRY)&_ZN6S886C33v73Ev,
  (VTBL_ENTRY)&_ZN6S886C33v74Ev,
  (VTBL_ENTRY)&_ZN6S886C33v75Ev,
  (VTBL_ENTRY)&_ZN6S886C33v76Ev,
  (VTBL_ENTRY)&_ZN6S886C33v77Ev,
  (VTBL_ENTRY)&_ZN6S886C33v78Ev,
  (VTBL_ENTRY)&_ZN6S886C33v79Ev,
  (VTBL_ENTRY)&_ZN6S886C33v80Ev,
  (VTBL_ENTRY)&_ZN6S886C33v81Ev,
  (VTBL_ENTRY)&_ZN6S886C33v82Ev,
  (VTBL_ENTRY)&_ZN6S886C33v83Ev,
  (VTBL_ENTRY)&_ZN6S886C33v84Ev,
  (VTBL_ENTRY)&_ZN6S886C33v85Ev,
  (VTBL_ENTRY)&_ZN6S886C33v86Ev,
  (VTBL_ENTRY)&_ZN6S886C33v87Ev,
  (VTBL_ENTRY)&_ZN6S886C33v88Ev,
  (VTBL_ENTRY)&_ZN6S886C23v89Ev,
  (VTBL_ENTRY)&_ZN6S886C23v90Ev,
  (VTBL_ENTRY)&_ZN6S886C23v91Ev,
  (VTBL_ENTRY)&_ZN6S886C23v92Ev,
  (VTBL_ENTRY)&_ZN6S886C23v93Ev,
  (VTBL_ENTRY)&_ZN6S886C23v94Ev,
  (VTBL_ENTRY)&_ZN6S886C23v95Ev,
  (VTBL_ENTRY)&_ZN6S886C23v96Ev,
  (VTBL_ENTRY)&_ZN6S886C23v97Ev,
  ABISELECT(-96,-56),
  (VTBL_ENTRY)&(_ZTI6S886C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N6S886C2D1Ev,_ZThn56_N6S886C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N6S886C2D0Ev,_ZThn56_N6S886C2D0Ev),
  (VTBL_ENTRY)&_ZN10S886C16_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S886C16_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S886C16_nt3v23Ev,
  (VTBL_ENTRY)&_ZN7S886C153v24Ev,
  (VTBL_ENTRY)&_ZN7S886C153v25Ev,
  (VTBL_ENTRY)&_ZN7S886C153v26Ev,
  (VTBL_ENTRY)&_ZN7S886C153v27Ev,
  (VTBL_ENTRY)&_ZN7S886C143v28Ev,
  (VTBL_ENTRY)&_ZN7S886C143v29Ev,
  (VTBL_ENTRY)&_ZN7S886C143v30Ev,
  ABISELECT(-168,-96),
  (VTBL_ENTRY)&(_ZTI6S886C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N6S886C2D1Ev,_ZThn96_N6S886C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N6S886C2D0Ev,_ZThn96_N6S886C2D0Ev),
  (VTBL_ENTRY)&_ZN7S886C203v31Ev,
  (VTBL_ENTRY)&_ZN7S886C203v32Ev,
  (VTBL_ENTRY)&_ZN7S886C203v33Ev,
  (VTBL_ENTRY)&_ZN7S886C203v34Ev,
  (VTBL_ENTRY)&_ZN7S886C203v35Ev,
  (VTBL_ENTRY)&_ZN7S886C203v36Ev,
  (VTBL_ENTRY)&_ZN7S886C203v37Ev,
  (VTBL_ENTRY)&_ZN7S886C203v38Ev,
  (VTBL_ENTRY)&_ZN7S886C203v39Ev,
  (VTBL_ENTRY)&_ZN7S886C203v40Ev,
  (VTBL_ENTRY)&_ZN7S886C203v41Ev,
  (VTBL_ENTRY)&_ZN7S886C203v42Ev,
  (VTBL_ENTRY)&_ZN7S886C203v43Ev,
  (VTBL_ENTRY)&_ZN7S886C203v44Ev,
  (VTBL_ENTRY)&_ZN7S886C203v45Ev,
  (VTBL_ENTRY)&_ZN7S886C203v46Ev,
  (VTBL_ENTRY)&_ZN7S886C203v47Ev,
  (VTBL_ENTRY)&_ZN7S886C203v48Ev,
  (VTBL_ENTRY)&_ZN7S886C203v49Ev,
  (VTBL_ENTRY)&_ZN7S886C203v50Ev,
  (VTBL_ENTRY)&_ZN7S886C203v51Ev,
  (VTBL_ENTRY)&_ZN7S886C203v52Ev,
  (VTBL_ENTRY)&_ZN7S886C203v53Ev,
  (VTBL_ENTRY)&_ZN7S886C203v54Ev,
  (VTBL_ENTRY)&_ZN7S886C203v55Ev,
  (VTBL_ENTRY)&_ZN7S886C203v56Ev,
};
extern VTBL_ENTRY _ZTI6S886C2[];
extern  VTBL_ENTRY _ZTV6S886C2[];
Class_Descriptor cd_S886C2 = {  "S886C2", // class name
  bases_S886C2, 7,
  &(vtc_S886C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(432,276), // object size
  NSPAIRA(_ZTI6S886C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S886C2),108, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  7, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S886C1  : S886C2 {
  virtual  ~S886C1(); // _ZN6S886C1D1Ev
  virtual void  v1(); // _ZN6S886C12v1Ev
  S886C1(); // tgen
};
//SIG(1 S886C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 Fp FC6{ BC7{ m Fp Fi FC8{ m} FC9{ m}}} FC10{ m FC11{ Fl[4]}} Fc} vd v14 v15 v16 v17 v18 v19 v20 FC12{ m Fp Fi[2] FC9}} BC13{ BC14{ BC15{ vd v21 v22 v23} vd v24 v25 v26 v27} vd v28 v29 v30 FC12 FC10 Fc} BC16{ vd v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56} vd v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 FC17{ m Fp Fi FC8} Fc[2] Fi Fp[5] Fc[2] Fp FC18{ m Fp Fi[4] Fc Fi[3]} FL[2] Fi[2]} vd v89 v90 v91 v92 v93 v94 v95 v96 v97 FC10 FC19{ m Fp FC10 FC20{ m Fp FC21{ Fi[4]}} Fi Fc} Fi} vd v1}


 S886C1 ::~S886C1(){ note_dtor("S886C1", this);}
void  S886C1 ::v1(){vfunc_called(this, "_ZN6S886C12v1Ev");}
S886C1 ::S886C1(){ note_ctor("S886C1", this);} // tgen

static void Test_S886C1()
{
  extern Class_Descriptor cd_S886C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(55,70)];
    init_test(&cd_S886C1, buf);
    S886C1 *dp, &lv = *(dp=new (buf) S886C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(432,276), "sizeof(S886C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S886C1)");
    check_base_class_offset(lv, (S886C5*)(S886C4*)(S886C3*)(S886C2*), 0, "S886C1");
    check_base_class_offset(lv, (S886C4*)(S886C3*)(S886C2*), 0, "S886C1");
    check_base_class_offset(lv, (S886C16_nt*)(S886C15*)(S886C14*)(S886C3*)(S886C2*), ABISELECT(96,56), "S886C1");
    check_base_class_offset(lv, (S886C15*)(S886C14*)(S886C3*)(S886C2*), ABISELECT(96,56), "S886C1");
    check_base_class_offset(lv, (S886C14*)(S886C3*)(S886C2*), ABISELECT(96,56), "S886C1");
    check_base_class_offset(lv, (S886C20*)(S886C3*)(S886C2*), ABISELECT(168,96), "S886C1");
    check_base_class_offset(lv, (S886C3*)(S886C2*), 0, "S886C1");
    check_base_class_offset(lv, (S886C2*), 0, "S886C1");
    test_class_info(&lv, &cd_S886C1);
    dp->~S886C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS886C1(Test_S886C1, "S886C1", ABISELECT(432,276));

#else // __cplusplus

extern void _ZN6S886C1C1Ev();
extern void _ZN6S886C1D1Ev();
Name_Map name_map_S886C1[] = {
  NSPAIR(_ZN6S886C1C1Ev),
  NSPAIR(_ZN6S886C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S886C5;
extern VTBL_ENTRY _ZTI6S886C5[];
extern  VTBL_ENTRY _ZTV6S886C5[];
extern Class_Descriptor cd_S886C4;
extern VTBL_ENTRY _ZTI6S886C4[];
extern  VTBL_ENTRY _ZTV6S886C4[];
extern Class_Descriptor cd_S886C16_nt;
extern VTBL_ENTRY _ZTI10S886C16_nt[];
extern  VTBL_ENTRY _ZTV10S886C16_nt[];
extern Class_Descriptor cd_S886C15;
extern VTBL_ENTRY _ZTI7S886C15[];
extern  VTBL_ENTRY _ZTV7S886C15[];
extern Class_Descriptor cd_S886C14;
extern VTBL_ENTRY _ZTI7S886C14[];
extern  VTBL_ENTRY _ZTV7S886C14[];
extern Class_Descriptor cd_S886C20;
extern VTBL_ENTRY _ZTI7S886C20[];
extern  VTBL_ENTRY _ZTV7S886C20[];
extern Class_Descriptor cd_S886C3;
extern VTBL_ENTRY _ZTI6S886C3[];
extern  VTBL_ENTRY _ZTV6S886C3[];
extern Class_Descriptor cd_S886C2;
extern VTBL_ENTRY _ZTI6S886C2[];
extern  VTBL_ENTRY _ZTV6S886C2[];
static Base_Class bases_S886C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S886C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S886C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S886C16_nt,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S886C15,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S886C14,    ABISELECT(96,56), //bcp->offset
    65, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S886C20,    ABISELECT(168,96), //bcp->offset
    79, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S886C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S886C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S886C1[];
extern void _ZN6S886C1D1Ev();
extern void _ZN6S886C1D0Ev();
extern void _ZN6S886C52v2Ev();
extern void _ZN6S886C52v3Ev();
extern void _ZN6S886C52v4Ev();
extern void _ZN6S886C52v5Ev();
extern void _ZN6S886C52v6Ev();
extern void _ZN6S886C52v7Ev();
extern void _ZN6S886C52v8Ev();
extern void _ZN6S886C52v9Ev();
extern void _ZN6S886C53v10Ev();
extern void _ZN6S886C53v11Ev();
extern void _ZN6S886C53v12Ev();
extern void _ZN6S886C53v13Ev();
extern void _ZN6S886C43v14Ev();
extern void _ZN6S886C43v15Ev();
extern void _ZN6S886C43v16Ev();
extern void _ZN6S886C43v17Ev();
extern void _ZN6S886C43v18Ev();
extern void _ZN6S886C43v19Ev();
extern void _ZN6S886C43v20Ev();
extern void _ZN6S886C33v57Ev();
extern void _ZN6S886C33v58Ev();
extern void _ZN6S886C33v59Ev();
extern void _ZN6S886C33v60Ev();
extern void _ZN6S886C33v61Ev();
extern void _ZN6S886C33v62Ev();
extern void _ZN6S886C33v63Ev();
extern void _ZN6S886C33v64Ev();
extern void _ZN6S886C33v65Ev();
extern void _ZN6S886C33v66Ev();
extern void _ZN6S886C33v67Ev();
extern void _ZN6S886C33v68Ev();
extern void _ZN6S886C33v69Ev();
extern void _ZN6S886C33v70Ev();
extern void _ZN6S886C33v71Ev();
extern void _ZN6S886C33v72Ev();
extern void _ZN6S886C33v73Ev();
extern void _ZN6S886C33v74Ev();
extern void _ZN6S886C33v75Ev();
extern void _ZN6S886C33v76Ev();
extern void _ZN6S886C33v77Ev();
extern void _ZN6S886C33v78Ev();
extern void _ZN6S886C33v79Ev();
extern void _ZN6S886C33v80Ev();
extern void _ZN6S886C33v81Ev();
extern void _ZN6S886C33v82Ev();
extern void _ZN6S886C33v83Ev();
extern void _ZN6S886C33v84Ev();
extern void _ZN6S886C33v85Ev();
extern void _ZN6S886C33v86Ev();
extern void _ZN6S886C33v87Ev();
extern void _ZN6S886C33v88Ev();
extern void _ZN6S886C23v89Ev();
extern void _ZN6S886C23v90Ev();
extern void _ZN6S886C23v91Ev();
extern void _ZN6S886C23v92Ev();
extern void _ZN6S886C23v93Ev();
extern void _ZN6S886C23v94Ev();
extern void _ZN6S886C23v95Ev();
extern void _ZN6S886C23v96Ev();
extern void _ZN6S886C23v97Ev();
extern void _ZN6S886C12v1Ev();
extern void ABISELECT(_ZThn96_N6S886C1D1Ev,_ZThn56_N6S886C1D1Ev)();
extern void ABISELECT(_ZThn96_N6S886C1D0Ev,_ZThn56_N6S886C1D0Ev)();
extern void _ZN10S886C16_nt3v21Ev();
extern void _ZN10S886C16_nt3v22Ev();
extern void _ZN10S886C16_nt3v23Ev();
extern void _ZN7S886C153v24Ev();
extern void _ZN7S886C153v25Ev();
extern void _ZN7S886C153v26Ev();
extern void _ZN7S886C153v27Ev();
extern void _ZN7S886C143v28Ev();
extern void _ZN7S886C143v29Ev();
extern void _ZN7S886C143v30Ev();
extern void ABISELECT(_ZThn168_N6S886C1D1Ev,_ZThn96_N6S886C1D1Ev)();
extern void ABISELECT(_ZThn168_N6S886C1D0Ev,_ZThn96_N6S886C1D0Ev)();
extern void _ZN7S886C203v31Ev();
extern void _ZN7S886C203v32Ev();
extern void _ZN7S886C203v33Ev();
extern void _ZN7S886C203v34Ev();
extern void _ZN7S886C203v35Ev();
extern void _ZN7S886C203v36Ev();
extern void _ZN7S886C203v37Ev();
extern void _ZN7S886C203v38Ev();
extern void _ZN7S886C203v39Ev();
extern void _ZN7S886C203v40Ev();
extern void _ZN7S886C203v41Ev();
extern void _ZN7S886C203v42Ev();
extern void _ZN7S886C203v43Ev();
extern void _ZN7S886C203v44Ev();
extern void _ZN7S886C203v45Ev();
extern void _ZN7S886C203v46Ev();
extern void _ZN7S886C203v47Ev();
extern void _ZN7S886C203v48Ev();
extern void _ZN7S886C203v49Ev();
extern void _ZN7S886C203v50Ev();
extern void _ZN7S886C203v51Ev();
extern void _ZN7S886C203v52Ev();
extern void _ZN7S886C203v53Ev();
extern void _ZN7S886C203v54Ev();
extern void _ZN7S886C203v55Ev();
extern void _ZN7S886C203v56Ev();
static  VTBL_ENTRY vtc_S886C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S886C1[0]),
  (VTBL_ENTRY)&_ZN6S886C1D1Ev,
  (VTBL_ENTRY)&_ZN6S886C1D0Ev,
  (VTBL_ENTRY)&_ZN6S886C52v2Ev,
  (VTBL_ENTRY)&_ZN6S886C52v3Ev,
  (VTBL_ENTRY)&_ZN6S886C52v4Ev,
  (VTBL_ENTRY)&_ZN6S886C52v5Ev,
  (VTBL_ENTRY)&_ZN6S886C52v6Ev,
  (VTBL_ENTRY)&_ZN6S886C52v7Ev,
  (VTBL_ENTRY)&_ZN6S886C52v8Ev,
  (VTBL_ENTRY)&_ZN6S886C52v9Ev,
  (VTBL_ENTRY)&_ZN6S886C53v10Ev,
  (VTBL_ENTRY)&_ZN6S886C53v11Ev,
  (VTBL_ENTRY)&_ZN6S886C53v12Ev,
  (VTBL_ENTRY)&_ZN6S886C53v13Ev,
  (VTBL_ENTRY)&_ZN6S886C43v14Ev,
  (VTBL_ENTRY)&_ZN6S886C43v15Ev,
  (VTBL_ENTRY)&_ZN6S886C43v16Ev,
  (VTBL_ENTRY)&_ZN6S886C43v17Ev,
  (VTBL_ENTRY)&_ZN6S886C43v18Ev,
  (VTBL_ENTRY)&_ZN6S886C43v19Ev,
  (VTBL_ENTRY)&_ZN6S886C43v20Ev,
  (VTBL_ENTRY)&_ZN6S886C33v57Ev,
  (VTBL_ENTRY)&_ZN6S886C33v58Ev,
  (VTBL_ENTRY)&_ZN6S886C33v59Ev,
  (VTBL_ENTRY)&_ZN6S886C33v60Ev,
  (VTBL_ENTRY)&_ZN6S886C33v61Ev,
  (VTBL_ENTRY)&_ZN6S886C33v62Ev,
  (VTBL_ENTRY)&_ZN6S886C33v63Ev,
  (VTBL_ENTRY)&_ZN6S886C33v64Ev,
  (VTBL_ENTRY)&_ZN6S886C33v65Ev,
  (VTBL_ENTRY)&_ZN6S886C33v66Ev,
  (VTBL_ENTRY)&_ZN6S886C33v67Ev,
  (VTBL_ENTRY)&_ZN6S886C33v68Ev,
  (VTBL_ENTRY)&_ZN6S886C33v69Ev,
  (VTBL_ENTRY)&_ZN6S886C33v70Ev,
  (VTBL_ENTRY)&_ZN6S886C33v71Ev,
  (VTBL_ENTRY)&_ZN6S886C33v72Ev,
  (VTBL_ENTRY)&_ZN6S886C33v73Ev,
  (VTBL_ENTRY)&_ZN6S886C33v74Ev,
  (VTBL_ENTRY)&_ZN6S886C33v75Ev,
  (VTBL_ENTRY)&_ZN6S886C33v76Ev,
  (VTBL_ENTRY)&_ZN6S886C33v77Ev,
  (VTBL_ENTRY)&_ZN6S886C33v78Ev,
  (VTBL_ENTRY)&_ZN6S886C33v79Ev,
  (VTBL_ENTRY)&_ZN6S886C33v80Ev,
  (VTBL_ENTRY)&_ZN6S886C33v81Ev,
  (VTBL_ENTRY)&_ZN6S886C33v82Ev,
  (VTBL_ENTRY)&_ZN6S886C33v83Ev,
  (VTBL_ENTRY)&_ZN6S886C33v84Ev,
  (VTBL_ENTRY)&_ZN6S886C33v85Ev,
  (VTBL_ENTRY)&_ZN6S886C33v86Ev,
  (VTBL_ENTRY)&_ZN6S886C33v87Ev,
  (VTBL_ENTRY)&_ZN6S886C33v88Ev,
  (VTBL_ENTRY)&_ZN6S886C23v89Ev,
  (VTBL_ENTRY)&_ZN6S886C23v90Ev,
  (VTBL_ENTRY)&_ZN6S886C23v91Ev,
  (VTBL_ENTRY)&_ZN6S886C23v92Ev,
  (VTBL_ENTRY)&_ZN6S886C23v93Ev,
  (VTBL_ENTRY)&_ZN6S886C23v94Ev,
  (VTBL_ENTRY)&_ZN6S886C23v95Ev,
  (VTBL_ENTRY)&_ZN6S886C23v96Ev,
  (VTBL_ENTRY)&_ZN6S886C23v97Ev,
  (VTBL_ENTRY)&_ZN6S886C12v1Ev,
  ABISELECT(-96,-56),
  (VTBL_ENTRY)&(_ZTI6S886C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N6S886C1D1Ev,_ZThn56_N6S886C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N6S886C1D0Ev,_ZThn56_N6S886C1D0Ev),
  (VTBL_ENTRY)&_ZN10S886C16_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S886C16_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S886C16_nt3v23Ev,
  (VTBL_ENTRY)&_ZN7S886C153v24Ev,
  (VTBL_ENTRY)&_ZN7S886C153v25Ev,
  (VTBL_ENTRY)&_ZN7S886C153v26Ev,
  (VTBL_ENTRY)&_ZN7S886C153v27Ev,
  (VTBL_ENTRY)&_ZN7S886C143v28Ev,
  (VTBL_ENTRY)&_ZN7S886C143v29Ev,
  (VTBL_ENTRY)&_ZN7S886C143v30Ev,
  ABISELECT(-168,-96),
  (VTBL_ENTRY)&(_ZTI6S886C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N6S886C1D1Ev,_ZThn96_N6S886C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N6S886C1D0Ev,_ZThn96_N6S886C1D0Ev),
  (VTBL_ENTRY)&_ZN7S886C203v31Ev,
  (VTBL_ENTRY)&_ZN7S886C203v32Ev,
  (VTBL_ENTRY)&_ZN7S886C203v33Ev,
  (VTBL_ENTRY)&_ZN7S886C203v34Ev,
  (VTBL_ENTRY)&_ZN7S886C203v35Ev,
  (VTBL_ENTRY)&_ZN7S886C203v36Ev,
  (VTBL_ENTRY)&_ZN7S886C203v37Ev,
  (VTBL_ENTRY)&_ZN7S886C203v38Ev,
  (VTBL_ENTRY)&_ZN7S886C203v39Ev,
  (VTBL_ENTRY)&_ZN7S886C203v40Ev,
  (VTBL_ENTRY)&_ZN7S886C203v41Ev,
  (VTBL_ENTRY)&_ZN7S886C203v42Ev,
  (VTBL_ENTRY)&_ZN7S886C203v43Ev,
  (VTBL_ENTRY)&_ZN7S886C203v44Ev,
  (VTBL_ENTRY)&_ZN7S886C203v45Ev,
  (VTBL_ENTRY)&_ZN7S886C203v46Ev,
  (VTBL_ENTRY)&_ZN7S886C203v47Ev,
  (VTBL_ENTRY)&_ZN7S886C203v48Ev,
  (VTBL_ENTRY)&_ZN7S886C203v49Ev,
  (VTBL_ENTRY)&_ZN7S886C203v50Ev,
  (VTBL_ENTRY)&_ZN7S886C203v51Ev,
  (VTBL_ENTRY)&_ZN7S886C203v52Ev,
  (VTBL_ENTRY)&_ZN7S886C203v53Ev,
  (VTBL_ENTRY)&_ZN7S886C203v54Ev,
  (VTBL_ENTRY)&_ZN7S886C203v55Ev,
  (VTBL_ENTRY)&_ZN7S886C203v56Ev,
};
extern VTBL_ENTRY _ZTI6S886C1[];
extern  VTBL_ENTRY _ZTV6S886C1[];
Class_Descriptor cd_S886C1 = {  "S886C1", // class name
  bases_S886C1, 8,
  &(vtc_S886C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(432,276), // object size
  NSPAIRA(_ZTI6S886C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S886C1),109, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  8, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S887C11_nt  {
  __tsi64 s887c11f0[4];
};
//SIG(-1 S887C11_nt) C1{ FL[4]}



//skip512 S887C11_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S887C10_nt  {
  ::S887C11_nt s887c10f0;
  void  mf887c10(); // _ZN10S887C10_nt8mf887c10Ev
};
//SIG(-1 S887C10_nt) C1{ m FC2{ FL[4]}}


void  S887C10_nt ::mf887c10(){}

//skip512 S887C10_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S887C5  {
  void *s887c5f0;
  ::S886C6_nt s887c5f1;
  ::S887C10_nt s887c5f2;
  char s887c5f3;
  virtual  ~S887C5(); // _ZN6S887C5D1Ev
  virtual void  v2(); // _ZN6S887C52v2Ev
  virtual void  v3(); // _ZN6S887C52v3Ev
  virtual void  v4(); // _ZN6S887C52v4Ev
  virtual void  v5(); // _ZN6S887C52v5Ev
  virtual void  v6(); // _ZN6S887C52v6Ev
  virtual void  v7(); // _ZN6S887C52v7Ev
  virtual void  v8(); // _ZN6S887C52v8Ev
  virtual void  v9(); // _ZN6S887C52v9Ev
  virtual void  v10(); // _ZN6S887C53v10Ev
  virtual void  v11(); // _ZN6S887C53v11Ev
  virtual void  v12(); // _ZN6S887C53v12Ev
  virtual void  v13(); // _ZN6S887C53v13Ev
  S887C5(); // tgen
};
//SIG(-1 S887C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fp FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}} FC6{ m FC7{ FL[4]}} Fc}


 S887C5 ::~S887C5(){ note_dtor("S887C5", this);}
void  S887C5 ::v2(){vfunc_called(this, "_ZN6S887C52v2Ev");}
void  S887C5 ::v3(){vfunc_called(this, "_ZN6S887C52v3Ev");}
void  S887C5 ::v4(){vfunc_called(this, "_ZN6S887C52v4Ev");}
void  S887C5 ::v5(){vfunc_called(this, "_ZN6S887C52v5Ev");}
void  S887C5 ::v6(){vfunc_called(this, "_ZN6S887C52v6Ev");}
void  S887C5 ::v7(){vfunc_called(this, "_ZN6S887C52v7Ev");}
void  S887C5 ::v8(){vfunc_called(this, "_ZN6S887C52v8Ev");}
void  S887C5 ::v9(){vfunc_called(this, "_ZN6S887C52v9Ev");}
void  S887C5 ::v10(){vfunc_called(this, "_ZN6S887C53v10Ev");}
void  S887C5 ::v11(){vfunc_called(this, "_ZN6S887C53v11Ev");}
void  S887C5 ::v12(){vfunc_called(this, "_ZN6S887C53v12Ev");}
void  S887C5 ::v13(){vfunc_called(this, "_ZN6S887C53v13Ev");}
S887C5 ::S887C5(){ note_ctor("S887C5", this);} // tgen

static void Test_S887C5()
{
  extern Class_Descriptor cd_S887C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S887C5, buf);
    S887C5 *dp, &lv = *(dp=new (buf) S887C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S887C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S887C5)");
    check_field_offset(lv, s887c5f0, ABISELECT(8,4), "S887C5.s887c5f0");
    check_field_offset(lv, s887c5f1, ABISELECT(16,8), "S887C5.s887c5f1");
    check_field_offset(lv, s887c5f2, ABISELECT(32,20), "S887C5.s887c5f2");
    check_field_offset(lv, s887c5f3, ABISELECT(64,52), "S887C5.s887c5f3");
    test_class_info(&lv, &cd_S887C5);
    dp->~S887C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS887C5(Test_S887C5, "S887C5", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN6S887C5C1Ev();
extern void _ZN6S887C5D1Ev();
Name_Map name_map_S887C5[] = {
  NSPAIR(_ZN6S887C5C1Ev),
  NSPAIR(_ZN6S887C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S887C5[];
extern void _ZN6S887C5D1Ev();
extern void _ZN6S887C5D0Ev();
extern void _ZN6S887C52v2Ev();
extern void _ZN6S887C52v3Ev();
extern void _ZN6S887C52v4Ev();
extern void _ZN6S887C52v5Ev();
extern void _ZN6S887C52v6Ev();
extern void _ZN6S887C52v7Ev();
extern void _ZN6S887C52v8Ev();
extern void _ZN6S887C52v9Ev();
extern void _ZN6S887C53v10Ev();
extern void _ZN6S887C53v11Ev();
extern void _ZN6S887C53v12Ev();
extern void _ZN6S887C53v13Ev();
static  VTBL_ENTRY vtc_S887C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S887C5[0]),
  (VTBL_ENTRY)&_ZN6S887C5D1Ev,
  (VTBL_ENTRY)&_ZN6S887C5D0Ev,
  (VTBL_ENTRY)&_ZN6S887C52v2Ev,
  (VTBL_ENTRY)&_ZN6S887C52v3Ev,
  (VTBL_ENTRY)&_ZN6S887C52v4Ev,
  (VTBL_ENTRY)&_ZN6S887C52v5Ev,
  (VTBL_ENTRY)&_ZN6S887C52v6Ev,
  (VTBL_ENTRY)&_ZN6S887C52v7Ev,
  (VTBL_ENTRY)&_ZN6S887C52v8Ev,
  (VTBL_ENTRY)&_ZN6S887C52v9Ev,
  (VTBL_ENTRY)&_ZN6S887C53v10Ev,
  (VTBL_ENTRY)&_ZN6S887C53v11Ev,
  (VTBL_ENTRY)&_ZN6S887C53v12Ev,
  (VTBL_ENTRY)&_ZN6S887C53v13Ev,
};
extern VTBL_ENTRY _ZTI6S887C5[];
extern  VTBL_ENTRY _ZTV6S887C5[];
Class_Descriptor cd_S887C5 = {  "S887C5", // class name
  0,0,//no base classes
  &(vtc_S887C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI6S887C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S887C5),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S887C4  : S887C5 {
  ::S886C12_nt s887c4f0;
  virtual  ~S887C4(); // _ZN6S887C4D1Ev
  virtual void  v14(); // _ZN6S887C43v14Ev
  virtual void  v15(); // _ZN6S887C43v15Ev
  virtual void  v16(); // _ZN6S887C43v16Ev
  virtual void  v17(); // _ZN6S887C43v17Ev
  virtual void  v18(); // _ZN6S887C43v18Ev
  virtual void  v19(); // _ZN6S887C43v19Ev
  virtual void  v20(); // _ZN6S887C43v20Ev
  S887C4(); // tgen
};
//SIG(-1 S887C4) C1{ BC2{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 Fp FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}} FC7{ m FC8{ FL[4]}} Fc} vd v1 v2 v3 v4 v5 v6 v7 FC9{ m Fp Fi[2] FC6}}


 S887C4 ::~S887C4(){ note_dtor("S887C4", this);}
void  S887C4 ::v14(){vfunc_called(this, "_ZN6S887C43v14Ev");}
void  S887C4 ::v15(){vfunc_called(this, "_ZN6S887C43v15Ev");}
void  S887C4 ::v16(){vfunc_called(this, "_ZN6S887C43v16Ev");}
void  S887C4 ::v17(){vfunc_called(this, "_ZN6S887C43v17Ev");}
void  S887C4 ::v18(){vfunc_called(this, "_ZN6S887C43v18Ev");}
void  S887C4 ::v19(){vfunc_called(this, "_ZN6S887C43v19Ev");}
void  S887C4 ::v20(){vfunc_called(this, "_ZN6S887C43v20Ev");}
S887C4 ::S887C4(){ note_ctor("S887C4", this);} // tgen

static void Test_S887C4()
{
  extern Class_Descriptor cd_S887C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,19)];
    init_test(&cd_S887C4, buf);
    S887C4 *dp, &lv = *(dp=new (buf) S887C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,72), "sizeof(S887C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S887C4)");
    check_base_class_offset(lv, (S887C5*), 0, "S887C4");
    check_field_offset(lv, s887c4f0, ABISELECT(72,56), "S887C4.s887c4f0");
    test_class_info(&lv, &cd_S887C4);
    dp->~S887C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS887C4(Test_S887C4, "S887C4", ABISELECT(96,72));

#else // __cplusplus

extern void _ZN6S887C4C1Ev();
extern void _ZN6S887C4D1Ev();
Name_Map name_map_S887C4[] = {
  NSPAIR(_ZN6S887C4C1Ev),
  NSPAIR(_ZN6S887C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S887C5;
extern VTBL_ENTRY _ZTI6S887C5[];
extern  VTBL_ENTRY _ZTV6S887C5[];
static Base_Class bases_S887C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S887C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S887C4[];
extern void _ZN6S887C4D1Ev();
extern void _ZN6S887C4D0Ev();
extern void _ZN6S887C52v2Ev();
extern void _ZN6S887C52v3Ev();
extern void _ZN6S887C52v4Ev();
extern void _ZN6S887C52v5Ev();
extern void _ZN6S887C52v6Ev();
extern void _ZN6S887C52v7Ev();
extern void _ZN6S887C52v8Ev();
extern void _ZN6S887C52v9Ev();
extern void _ZN6S887C53v10Ev();
extern void _ZN6S887C53v11Ev();
extern void _ZN6S887C53v12Ev();
extern void _ZN6S887C53v13Ev();
extern void _ZN6S887C43v14Ev();
extern void _ZN6S887C43v15Ev();
extern void _ZN6S887C43v16Ev();
extern void _ZN6S887C43v17Ev();
extern void _ZN6S887C43v18Ev();
extern void _ZN6S887C43v19Ev();
extern void _ZN6S887C43v20Ev();
static  VTBL_ENTRY vtc_S887C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S887C4[0]),
  (VTBL_ENTRY)&_ZN6S887C4D1Ev,
  (VTBL_ENTRY)&_ZN6S887C4D0Ev,
  (VTBL_ENTRY)&_ZN6S887C52v2Ev,
  (VTBL_ENTRY)&_ZN6S887C52v3Ev,
  (VTBL_ENTRY)&_ZN6S887C52v4Ev,
  (VTBL_ENTRY)&_ZN6S887C52v5Ev,
  (VTBL_ENTRY)&_ZN6S887C52v6Ev,
  (VTBL_ENTRY)&_ZN6S887C52v7Ev,
  (VTBL_ENTRY)&_ZN6S887C52v8Ev,
  (VTBL_ENTRY)&_ZN6S887C52v9Ev,
  (VTBL_ENTRY)&_ZN6S887C53v10Ev,
  (VTBL_ENTRY)&_ZN6S887C53v11Ev,
  (VTBL_ENTRY)&_ZN6S887C53v12Ev,
  (VTBL_ENTRY)&_ZN6S887C53v13Ev,
  (VTBL_ENTRY)&_ZN6S887C43v14Ev,
  (VTBL_ENTRY)&_ZN6S887C43v15Ev,
  (VTBL_ENTRY)&_ZN6S887C43v16Ev,
  (VTBL_ENTRY)&_ZN6S887C43v17Ev,
  (VTBL_ENTRY)&_ZN6S887C43v18Ev,
  (VTBL_ENTRY)&_ZN6S887C43v19Ev,
  (VTBL_ENTRY)&_ZN6S887C43v20Ev,
};
extern VTBL_ENTRY _ZTI6S887C4[];
extern  VTBL_ENTRY _ZTV6S887C4[];
Class_Descriptor cd_S887C4 = {  "S887C4", // class name
  bases_S887C4, 1,
  &(vtc_S887C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,72), // object size
  NSPAIRA(_ZTI6S887C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S887C4),23, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S887C16  {
  virtual  ~S887C16(); // _ZN7S887C16D1Ev
  virtual void  v21(); // _ZN7S887C163v21Ev
  virtual void  v22(); // _ZN7S887C163v22Ev
  virtual void  v23(); // _ZN7S887C163v23Ev
  S887C16(); // tgen
};
//SIG(-1 S887C16) C1{ vd v1 v2 v3}


 S887C16 ::~S887C16(){ note_dtor("S887C16", this);}
void  S887C16 ::v21(){vfunc_called(this, "_ZN7S887C163v21Ev");}
void  S887C16 ::v22(){vfunc_called(this, "_ZN7S887C163v22Ev");}
void  S887C16 ::v23(){vfunc_called(this, "_ZN7S887C163v23Ev");}
S887C16 ::S887C16(){ note_ctor("S887C16", this);} // tgen

static void Test_S887C16()
{
  extern Class_Descriptor cd_S887C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S887C16, buf);
    S887C16 *dp, &lv = *(dp=new (buf) S887C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S887C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S887C16)");
    test_class_info(&lv, &cd_S887C16);
    dp->~S887C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS887C16(Test_S887C16, "S887C16", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S887C16C1Ev();
extern void _ZN7S887C16D1Ev();
Name_Map name_map_S887C16[] = {
  NSPAIR(_ZN7S887C16C1Ev),
  NSPAIR(_ZN7S887C16D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S887C16[];
extern void _ZN7S887C16D1Ev();
extern void _ZN7S887C16D0Ev();
extern void _ZN7S887C163v21Ev();
extern void _ZN7S887C163v22Ev();
extern void _ZN7S887C163v23Ev();
static  VTBL_ENTRY vtc_S887C16[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S887C16[0]),
  (VTBL_ENTRY)&_ZN7S887C16D1Ev,
  (VTBL_ENTRY)&_ZN7S887C16D0Ev,
  (VTBL_ENTRY)&_ZN7S887C163v21Ev,
  (VTBL_ENTRY)&_ZN7S887C163v22Ev,
  (VTBL_ENTRY)&_ZN7S887C163v23Ev,
};
extern VTBL_ENTRY _ZTI7S887C16[];
extern  VTBL_ENTRY _ZTV7S887C16[];
Class_Descriptor cd_S887C16 = {  "S887C16", // class name
  0,0,//no base classes
  &(vtc_S887C16[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S887C16),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S887C16),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S887C15  : S887C16 {
  virtual  ~S887C15(); // _ZN7S887C15D1Ev
  virtual void  v24(); // _ZN7S887C153v24Ev
  virtual void  v25(); // _ZN7S887C153v25Ev
  virtual void  v26(); // _ZN7S887C153v26Ev
  virtual void  v27(); // _ZN7S887C153v27Ev
  S887C15(); // tgen
};
//SIG(-1 S887C15) C1{ BC2{ vd v5 v6 v7} vd v1 v2 v3 v4}


 S887C15 ::~S887C15(){ note_dtor("S887C15", this);}
void  S887C15 ::v24(){vfunc_called(this, "_ZN7S887C153v24Ev");}
void  S887C15 ::v25(){vfunc_called(this, "_ZN7S887C153v25Ev");}
void  S887C15 ::v26(){vfunc_called(this, "_ZN7S887C153v26Ev");}
void  S887C15 ::v27(){vfunc_called(this, "_ZN7S887C153v27Ev");}
S887C15 ::S887C15(){ note_ctor("S887C15", this);} // tgen

static void Test_S887C15()
{
  extern Class_Descriptor cd_S887C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S887C15, buf);
    S887C15 *dp, &lv = *(dp=new (buf) S887C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S887C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S887C15)");
    check_base_class_offset(lv, (S887C16*), 0, "S887C15");
    test_class_info(&lv, &cd_S887C15);
    dp->~S887C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS887C15(Test_S887C15, "S887C15", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S887C15C1Ev();
extern void _ZN7S887C15D1Ev();
Name_Map name_map_S887C15[] = {
  NSPAIR(_ZN7S887C15C1Ev),
  NSPAIR(_ZN7S887C15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S887C16;
extern VTBL_ENTRY _ZTI7S887C16[];
extern  VTBL_ENTRY _ZTV7S887C16[];
static Base_Class bases_S887C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S887C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S887C15[];
extern void _ZN7S887C15D1Ev();
extern void _ZN7S887C15D0Ev();
extern void _ZN7S887C163v21Ev();
extern void _ZN7S887C163v22Ev();
extern void _ZN7S887C163v23Ev();
extern void _ZN7S887C153v24Ev();
extern void _ZN7S887C153v25Ev();
extern void _ZN7S887C153v26Ev();
extern void _ZN7S887C153v27Ev();
static  VTBL_ENTRY vtc_S887C15[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S887C15[0]),
  (VTBL_ENTRY)&_ZN7S887C15D1Ev,
  (VTBL_ENTRY)&_ZN7S887C15D0Ev,
  (VTBL_ENTRY)&_ZN7S887C163v21Ev,
  (VTBL_ENTRY)&_ZN7S887C163v22Ev,
  (VTBL_ENTRY)&_ZN7S887C163v23Ev,
  (VTBL_ENTRY)&_ZN7S887C153v24Ev,
  (VTBL_ENTRY)&_ZN7S887C153v25Ev,
  (VTBL_ENTRY)&_ZN7S887C153v26Ev,
  (VTBL_ENTRY)&_ZN7S887C153v27Ev,
};
extern VTBL_ENTRY _ZTI7S887C15[];
extern  VTBL_ENTRY _ZTV7S887C15[];
Class_Descriptor cd_S887C15 = {  "S887C15", // class name
  bases_S887C15, 1,
  &(vtc_S887C15[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S887C15),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S887C15),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S887C17  {
  void *s887c17f0;
  int s887c17f1[2];
  ::S1587C7_nt s887c17f2;
  void  mf887c17(); // _ZN7S887C178mf887c17Ev
};
//SIG(-1 S887C17) C1{ m Fp Fi[2] FC2{ m}}


void  S887C17 ::mf887c17(){}

static void Test_S887C17()
{
  {
    init_simple_test("S887C17");
    S887C17 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S887C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S887C17)");
    check_field_offset(lv, s887c17f0, 0, "S887C17.s887c17f0");
    check_field_offset(lv, s887c17f1, ABISELECT(8,4), "S887C17.s887c17f1");
    check_field_offset(lv, s887c17f2, ABISELECT(16,12), "S887C17.s887c17f2");
  }
}
static Arrange_To_Call_Me vS887C17(Test_S887C17, "S887C17", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S887C14  : S887C15 {
  ::S887C17 s887c14f0;
  ::S887C10_nt s887c14f1;
  char s887c14f2;
  virtual  ~S887C14(); // _ZN7S887C14D1Ev
  virtual void  v28(); // _ZN7S887C143v28Ev
  virtual void  v29(); // _ZN7S887C143v29Ev
  virtual void  v30(); // _ZN7S887C143v30Ev
  S887C14(); // tgen
};
//SIG(-1 S887C14) C1{ BC2{ BC3{ vd v4 v5 v6} vd v7 v8 v9 v10} vd v1 v2 v3 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ FL[4]}} Fc}


 S887C14 ::~S887C14(){ note_dtor("S887C14", this);}
void  S887C14 ::v28(){vfunc_called(this, "_ZN7S887C143v28Ev");}
void  S887C14 ::v29(){vfunc_called(this, "_ZN7S887C143v29Ev");}
void  S887C14 ::v30(){vfunc_called(this, "_ZN7S887C143v30Ev");}
S887C14 ::S887C14(){ note_ctor("S887C14", this);} // tgen

static void Test_S887C14()
{
  extern Class_Descriptor cd_S887C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S887C14, buf);
    S887C14 *dp, &lv = *(dp=new (buf) S887C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S887C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S887C14)");
    check_base_class_offset(lv, (S887C16*)(S887C15*), 0, "S887C14");
    check_base_class_offset(lv, (S887C15*), 0, "S887C14");
    check_field_offset(lv, s887c14f0, ABISELECT(8,4), "S887C14.s887c14f0");
    check_field_offset(lv, s887c14f1, ABISELECT(32,20), "S887C14.s887c14f1");
    check_field_offset(lv, s887c14f2, ABISELECT(64,52), "S887C14.s887c14f2");
    test_class_info(&lv, &cd_S887C14);
    dp->~S887C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS887C14(Test_S887C14, "S887C14", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S887C14C1Ev();
extern void _ZN7S887C14D1Ev();
Name_Map name_map_S887C14[] = {
  NSPAIR(_ZN7S887C14C1Ev),
  NSPAIR(_ZN7S887C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S887C16;
extern VTBL_ENTRY _ZTI7S887C16[];
extern  VTBL_ENTRY _ZTV7S887C16[];
extern Class_Descriptor cd_S887C15;
extern VTBL_ENTRY _ZTI7S887C15[];
extern  VTBL_ENTRY _ZTV7S887C15[];
static Base_Class bases_S887C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S887C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S887C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S887C14[];
extern void _ZN7S887C14D1Ev();
extern void _ZN7S887C14D0Ev();
extern void _ZN7S887C163v21Ev();
extern void _ZN7S887C163v22Ev();
extern void _ZN7S887C163v23Ev();
extern void _ZN7S887C153v24Ev();
extern void _ZN7S887C153v25Ev();
extern void _ZN7S887C153v26Ev();
extern void _ZN7S887C153v27Ev();
extern void _ZN7S887C143v28Ev();
extern void _ZN7S887C143v29Ev();
extern void _ZN7S887C143v30Ev();
static  VTBL_ENTRY vtc_S887C14[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S887C14[0]),
  (VTBL_ENTRY)&_ZN7S887C14D1Ev,
  (VTBL_ENTRY)&_ZN7S887C14D0Ev,
  (VTBL_ENTRY)&_ZN7S887C163v21Ev,
  (VTBL_ENTRY)&_ZN7S887C163v22Ev,
  (VTBL_ENTRY)&_ZN7S887C163v23Ev,
  (VTBL_ENTRY)&_ZN7S887C153v24Ev,
  (VTBL_ENTRY)&_ZN7S887C153v25Ev,
  (VTBL_ENTRY)&_ZN7S887C153v26Ev,
  (VTBL_ENTRY)&_ZN7S887C153v27Ev,
  (VTBL_ENTRY)&_ZN7S887C143v28Ev,
  (VTBL_ENTRY)&_ZN7S887C143v29Ev,
  (VTBL_ENTRY)&_ZN7S887C143v30Ev,
};
extern VTBL_ENTRY _ZTI7S887C14[];
extern  VTBL_ENTRY _ZTV7S887C14[];
Class_Descriptor cd_S887C14 = {  "S887C14", // class name
  bases_S887C14, 2,
  &(vtc_S887C14[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S887C14),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S887C14),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S887C20  {
  virtual  ~S887C20(); // _ZN7S887C20D1Ev
  virtual void  v31(); // _ZN7S887C203v31Ev
  virtual void  v32(); // _ZN7S887C203v32Ev
  virtual void  v33(); // _ZN7S887C203v33Ev
  virtual void  v34(); // _ZN7S887C203v34Ev
  virtual void  v35(); // _ZN7S887C203v35Ev
  virtual void  v36(); // _ZN7S887C203v36Ev
  virtual void  v37(); // _ZN7S887C203v37Ev
  virtual void  v38(); // _ZN7S887C203v38Ev
  virtual void  v39(); // _ZN7S887C203v39Ev
  virtual void  v40(); // _ZN7S887C203v40Ev
  virtual void  v41(); // _ZN7S887C203v41Ev
  virtual void  v42(); // _ZN7S887C203v42Ev
  virtual void  v43(); // _ZN7S887C203v43Ev
  virtual void  v44(); // _ZN7S887C203v44Ev
  virtual void  v45(); // _ZN7S887C203v45Ev
  virtual void  v46(); // _ZN7S887C203v46Ev
  virtual void  v47(); // _ZN7S887C203v47Ev
  virtual void  v48(); // _ZN7S887C203v48Ev
  virtual void  v49(); // _ZN7S887C203v49Ev
  virtual void  v50(); // _ZN7S887C203v50Ev
  virtual void  v51(); // _ZN7S887C203v51Ev
  virtual void  v52(); // _ZN7S887C203v52Ev
  virtual void  v53(); // _ZN7S887C203v53Ev
  virtual void  v54(); // _ZN7S887C203v54Ev
  virtual void  v55(); // _ZN7S887C203v55Ev
  virtual void  v56(); // _ZN7S887C203v56Ev
  S887C20(); // tgen
};
//SIG(-1 S887C20) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26}


 S887C20 ::~S887C20(){ note_dtor("S887C20", this);}
void  S887C20 ::v31(){vfunc_called(this, "_ZN7S887C203v31Ev");}
void  S887C20 ::v32(){vfunc_called(this, "_ZN7S887C203v32Ev");}
void  S887C20 ::v33(){vfunc_called(this, "_ZN7S887C203v33Ev");}
void  S887C20 ::v34(){vfunc_called(this, "_ZN7S887C203v34Ev");}
void  S887C20 ::v35(){vfunc_called(this, "_ZN7S887C203v35Ev");}
void  S887C20 ::v36(){vfunc_called(this, "_ZN7S887C203v36Ev");}
void  S887C20 ::v37(){vfunc_called(this, "_ZN7S887C203v37Ev");}
void  S887C20 ::v38(){vfunc_called(this, "_ZN7S887C203v38Ev");}
void  S887C20 ::v39(){vfunc_called(this, "_ZN7S887C203v39Ev");}
void  S887C20 ::v40(){vfunc_called(this, "_ZN7S887C203v40Ev");}
void  S887C20 ::v41(){vfunc_called(this, "_ZN7S887C203v41Ev");}
void  S887C20 ::v42(){vfunc_called(this, "_ZN7S887C203v42Ev");}
void  S887C20 ::v43(){vfunc_called(this, "_ZN7S887C203v43Ev");}
void  S887C20 ::v44(){vfunc_called(this, "_ZN7S887C203v44Ev");}
void  S887C20 ::v45(){vfunc_called(this, "_ZN7S887C203v45Ev");}
void  S887C20 ::v46(){vfunc_called(this, "_ZN7S887C203v46Ev");}
void  S887C20 ::v47(){vfunc_called(this, "_ZN7S887C203v47Ev");}
void  S887C20 ::v48(){vfunc_called(this, "_ZN7S887C203v48Ev");}
void  S887C20 ::v49(){vfunc_called(this, "_ZN7S887C203v49Ev");}
void  S887C20 ::v50(){vfunc_called(this, "_ZN7S887C203v50Ev");}
void  S887C20 ::v51(){vfunc_called(this, "_ZN7S887C203v51Ev");}
void  S887C20 ::v52(){vfunc_called(this, "_ZN7S887C203v52Ev");}
void  S887C20 ::v53(){vfunc_called(this, "_ZN7S887C203v53Ev");}
void  S887C20 ::v54(){vfunc_called(this, "_ZN7S887C203v54Ev");}
void  S887C20 ::v55(){vfunc_called(this, "_ZN7S887C203v55Ev");}
void  S887C20 ::v56(){vfunc_called(this, "_ZN7S887C203v56Ev");}
S887C20 ::S887C20(){ note_ctor("S887C20", this);} // tgen

static void Test_S887C20()
{
  extern Class_Descriptor cd_S887C20;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S887C20, buf);
    S887C20 *dp, &lv = *(dp=new (buf) S887C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S887C20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S887C20)");
    test_class_info(&lv, &cd_S887C20);
    dp->~S887C20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS887C20(Test_S887C20, "S887C20", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S887C20C1Ev();
extern void _ZN7S887C20D1Ev();
Name_Map name_map_S887C20[] = {
  NSPAIR(_ZN7S887C20C1Ev),
  NSPAIR(_ZN7S887C20D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S887C20[];
extern void _ZN7S887C20D1Ev();
extern void _ZN7S887C20D0Ev();
extern void _ZN7S887C203v31Ev();
extern void _ZN7S887C203v32Ev();
extern void _ZN7S887C203v33Ev();
extern void _ZN7S887C203v34Ev();
extern void _ZN7S887C203v35Ev();
extern void _ZN7S887C203v36Ev();
extern void _ZN7S887C203v37Ev();
extern void _ZN7S887C203v38Ev();
extern void _ZN7S887C203v39Ev();
extern void _ZN7S887C203v40Ev();
extern void _ZN7S887C203v41Ev();
extern void _ZN7S887C203v42Ev();
extern void _ZN7S887C203v43Ev();
extern void _ZN7S887C203v44Ev();
extern void _ZN7S887C203v45Ev();
extern void _ZN7S887C203v46Ev();
extern void _ZN7S887C203v47Ev();
extern void _ZN7S887C203v48Ev();
extern void _ZN7S887C203v49Ev();
extern void _ZN7S887C203v50Ev();
extern void _ZN7S887C203v51Ev();
extern void _ZN7S887C203v52Ev();
extern void _ZN7S887C203v53Ev();
extern void _ZN7S887C203v54Ev();
extern void _ZN7S887C203v55Ev();
extern void _ZN7S887C203v56Ev();
static  VTBL_ENTRY vtc_S887C20[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S887C20[0]),
  (VTBL_ENTRY)&_ZN7S887C20D1Ev,
  (VTBL_ENTRY)&_ZN7S887C20D0Ev,
  (VTBL_ENTRY)&_ZN7S887C203v31Ev,
  (VTBL_ENTRY)&_ZN7S887C203v32Ev,
  (VTBL_ENTRY)&_ZN7S887C203v33Ev,
  (VTBL_ENTRY)&_ZN7S887C203v34Ev,
  (VTBL_ENTRY)&_ZN7S887C203v35Ev,
  (VTBL_ENTRY)&_ZN7S887C203v36Ev,
  (VTBL_ENTRY)&_ZN7S887C203v37Ev,
  (VTBL_ENTRY)&_ZN7S887C203v38Ev,
  (VTBL_ENTRY)&_ZN7S887C203v39Ev,
  (VTBL_ENTRY)&_ZN7S887C203v40Ev,
  (VTBL_ENTRY)&_ZN7S887C203v41Ev,
  (VTBL_ENTRY)&_ZN7S887C203v42Ev,
  (VTBL_ENTRY)&_ZN7S887C203v43Ev,
  (VTBL_ENTRY)&_ZN7S887C203v44Ev,
  (VTBL_ENTRY)&_ZN7S887C203v45Ev,
  (VTBL_ENTRY)&_ZN7S887C203v46Ev,
  (VTBL_ENTRY)&_ZN7S887C203v47Ev,
  (VTBL_ENTRY)&_ZN7S887C203v48Ev,
  (VTBL_ENTRY)&_ZN7S887C203v49Ev,
  (VTBL_ENTRY)&_ZN7S887C203v50Ev,
  (VTBL_ENTRY)&_ZN7S887C203v51Ev,
  (VTBL_ENTRY)&_ZN7S887C203v52Ev,
  (VTBL_ENTRY)&_ZN7S887C203v53Ev,
  (VTBL_ENTRY)&_ZN7S887C203v54Ev,
  (VTBL_ENTRY)&_ZN7S887C203v55Ev,
  (VTBL_ENTRY)&_ZN7S887C203v56Ev,
};
extern VTBL_ENTRY _ZTI7S887C20[];
extern  VTBL_ENTRY _ZTV7S887C20[];
Class_Descriptor cd_S887C20 = {  "S887C20", // class name
  0,0,//no base classes
  &(vtc_S887C20[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S887C20),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S887C20),30, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S887C3  : S887C4 , S887C14 , S887C20 {
  ::S1587C6_nt s887c3f0;
  char s887c3f1[2];
  int s887c3f2;
  void *s887c3f3[5];
  char s887c3f4[2];
  void *s887c3f5;
  ::S886C23 s887c3f6;
  __tsi64 s887c3f7[2];
  int s887c3f8[2];
  virtual  ~S887C3(); // _ZN6S887C3D1Ev
  virtual void  v57(); // _ZN6S887C33v57Ev
  virtual void  v58(); // _ZN6S887C33v58Ev
  virtual void  v59(); // _ZN6S887C33v59Ev
  virtual void  v60(); // _ZN6S887C33v60Ev
  virtual void  v61(); // _ZN6S887C33v61Ev
  virtual void  v62(); // _ZN6S887C33v62Ev
  virtual void  v63(); // _ZN6S887C33v63Ev
  virtual void  v64(); // _ZN6S887C33v64Ev
  virtual void  v65(); // _ZN6S887C33v65Ev
  virtual void  v66(); // _ZN6S887C33v66Ev
  virtual void  v67(); // _ZN6S887C33v67Ev
  virtual void  v68(); // _ZN6S887C33v68Ev
  virtual void  v69(); // _ZN6S887C33v69Ev
  virtual void  v70(); // _ZN6S887C33v70Ev
  virtual void  v71(); // _ZN6S887C33v71Ev
  virtual void  v72(); // _ZN6S887C33v72Ev
  virtual void  v73(); // _ZN6S887C33v73Ev
  virtual void  v74(); // _ZN6S887C33v74Ev
  virtual void  v75(); // _ZN6S887C33v75Ev
  virtual void  v76(); // _ZN6S887C33v76Ev
  virtual void  v77(); // _ZN6S887C33v77Ev
  virtual void  v78(); // _ZN6S887C33v78Ev
  virtual void  v79(); // _ZN6S887C33v79Ev
  virtual void  v80(); // _ZN6S887C33v80Ev
  virtual void  v81(); // _ZN6S887C33v81Ev
  virtual void  v82(); // _ZN6S887C33v82Ev
  virtual void  v83(); // _ZN6S887C33v83Ev
  virtual void  v84(); // _ZN6S887C33v84Ev
  virtual void  v85(); // _ZN6S887C33v85Ev
  virtual void  v86(); // _ZN6S887C33v86Ev
  virtual void  v87(); // _ZN6S887C33v87Ev
  virtual void  v88(); // _ZN6S887C33v88Ev
  S887C3(); // tgen
};
//SIG(-1 S887C3) C1{ BC2{ BC3{ vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 Fp FC4{ BC5{ m Fp Fi FC6{ m} FC7{ m}}} FC8{ m FC9{ FL[4]}} Fc} vd v45 v46 v47 v48 v49 v50 v51 FC10{ m Fp Fi[2] FC7}} BC11{ BC12{ BC13{ vd v52 v53 v54} vd v55 v56 v57 v58} vd v59 v60 v61 FC14{ m Fp Fi[2] FC6} FC8 Fc} BC15{ vd v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 FC16{ m Fp Fi FC6} Fc[2] Fi Fp[5] Fc[2] Fp FC17{ m Fp Fi[4] Fc Fi[3]} FL[2] Fi[2]}


 S887C3 ::~S887C3(){ note_dtor("S887C3", this);}
void  S887C3 ::v57(){vfunc_called(this, "_ZN6S887C33v57Ev");}
void  S887C3 ::v58(){vfunc_called(this, "_ZN6S887C33v58Ev");}
void  S887C3 ::v59(){vfunc_called(this, "_ZN6S887C33v59Ev");}
void  S887C3 ::v60(){vfunc_called(this, "_ZN6S887C33v60Ev");}
void  S887C3 ::v61(){vfunc_called(this, "_ZN6S887C33v61Ev");}
void  S887C3 ::v62(){vfunc_called(this, "_ZN6S887C33v62Ev");}
void  S887C3 ::v63(){vfunc_called(this, "_ZN6S887C33v63Ev");}
void  S887C3 ::v64(){vfunc_called(this, "_ZN6S887C33v64Ev");}
void  S887C3 ::v65(){vfunc_called(this, "_ZN6S887C33v65Ev");}
void  S887C3 ::v66(){vfunc_called(this, "_ZN6S887C33v66Ev");}
void  S887C3 ::v67(){vfunc_called(this, "_ZN6S887C33v67Ev");}
void  S887C3 ::v68(){vfunc_called(this, "_ZN6S887C33v68Ev");}
void  S887C3 ::v69(){vfunc_called(this, "_ZN6S887C33v69Ev");}
void  S887C3 ::v70(){vfunc_called(this, "_ZN6S887C33v70Ev");}
void  S887C3 ::v71(){vfunc_called(this, "_ZN6S887C33v71Ev");}
void  S887C3 ::v72(){vfunc_called(this, "_ZN6S887C33v72Ev");}
void  S887C3 ::v73(){vfunc_called(this, "_ZN6S887C33v73Ev");}
void  S887C3 ::v74(){vfunc_called(this, "_ZN6S887C33v74Ev");}
void  S887C3 ::v75(){vfunc_called(this, "_ZN6S887C33v75Ev");}
void  S887C3 ::v76(){vfunc_called(this, "_ZN6S887C33v76Ev");}
void  S887C3 ::v77(){vfunc_called(this, "_ZN6S887C33v77Ev");}
void  S887C3 ::v78(){vfunc_called(this, "_ZN6S887C33v78Ev");}
void  S887C3 ::v79(){vfunc_called(this, "_ZN6S887C33v79Ev");}
void  S887C3 ::v80(){vfunc_called(this, "_ZN6S887C33v80Ev");}
void  S887C3 ::v81(){vfunc_called(this, "_ZN6S887C33v81Ev");}
void  S887C3 ::v82(){vfunc_called(this, "_ZN6S887C33v82Ev");}
void  S887C3 ::v83(){vfunc_called(this, "_ZN6S887C33v83Ev");}
void  S887C3 ::v84(){vfunc_called(this, "_ZN6S887C33v84Ev");}
void  S887C3 ::v85(){vfunc_called(this, "_ZN6S887C33v85Ev");}
void  S887C3 ::v86(){vfunc_called(this, "_ZN6S887C33v86Ev");}
void  S887C3 ::v87(){vfunc_called(this, "_ZN6S887C33v87Ev");}
void  S887C3 ::v88(){vfunc_called(this, "_ZN6S887C33v88Ev");}
S887C3 ::S887C3(){ note_ctor("S887C3", this);} // tgen

static void Test_S887C3()
{
  extern Class_Descriptor cd_S887C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(41,61)];
    init_test(&cd_S887C3, buf);
    S887C3 *dp, &lv = *(dp=new (buf) S887C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(320,240), "sizeof(S887C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S887C3)");
    check_base_class_offset(lv, (S887C5*)(S887C4*), 0, "S887C3");
    check_base_class_offset(lv, (S887C4*), 0, "S887C3");
    check_base_class_offset(lv, (S887C16*)(S887C15*)(S887C14*), ABISELECT(96,72), "S887C3");
    check_base_class_offset(lv, (S887C15*)(S887C14*), ABISELECT(96,72), "S887C3");
    check_base_class_offset(lv, (S887C14*), ABISELECT(96,72), "S887C3");
    check_base_class_offset(lv, (S887C20*), ABISELECT(168,128), "S887C3");
    check_field_offset(lv, s887c3f0, ABISELECT(176,132), "S887C3.s887c3f0");
    check_field_offset(lv, s887c3f1, ABISELECT(192,144), "S887C3.s887c3f1");
    check_field_offset(lv, s887c3f2, ABISELECT(196,148), "S887C3.s887c3f2");
    check_field_offset(lv, s887c3f3, ABISELECT(200,152), "S887C3.s887c3f3");
    check_field_offset(lv, s887c3f4, ABISELECT(240,172), "S887C3.s887c3f4");
    check_field_offset(lv, s887c3f5, ABISELECT(248,176), "S887C3.s887c3f5");
    check_field_offset(lv, s887c3f6, ABISELECT(256,180), "S887C3.s887c3f6");
    check_field_offset(lv, s887c3f7, ABISELECT(296,216), "S887C3.s887c3f7");
    check_field_offset(lv, s887c3f8, ABISELECT(312,232), "S887C3.s887c3f8");
    test_class_info(&lv, &cd_S887C3);
    dp->~S887C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS887C3(Test_S887C3, "S887C3", ABISELECT(320,240));

#else // __cplusplus

extern void _ZN6S887C3C1Ev();
extern void _ZN6S887C3D1Ev();
Name_Map name_map_S887C3[] = {
  NSPAIR(_ZN6S887C3C1Ev),
  NSPAIR(_ZN6S887C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S887C5;
extern VTBL_ENTRY _ZTI6S887C5[];
extern  VTBL_ENTRY _ZTV6S887C5[];
extern Class_Descriptor cd_S887C4;
extern VTBL_ENTRY _ZTI6S887C4[];
extern  VTBL_ENTRY _ZTV6S887C4[];
extern Class_Descriptor cd_S887C16;
extern VTBL_ENTRY _ZTI7S887C16[];
extern  VTBL_ENTRY _ZTV7S887C16[];
extern Class_Descriptor cd_S887C15;
extern VTBL_ENTRY _ZTI7S887C15[];
extern  VTBL_ENTRY _ZTV7S887C15[];
extern Class_Descriptor cd_S887C14;
extern VTBL_ENTRY _ZTI7S887C14[];
extern  VTBL_ENTRY _ZTV7S887C14[];
extern Class_Descriptor cd_S887C20;
extern VTBL_ENTRY _ZTI7S887C20[];
extern  VTBL_ENTRY _ZTV7S887C20[];
static Base_Class bases_S887C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S887C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S887C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S887C16,    ABISELECT(96,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S887C15,    ABISELECT(96,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S887C14,    ABISELECT(96,72), //bcp->offset
    55, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S887C20,    ABISELECT(168,128), //bcp->offset
    69, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S887C3[];
extern void _ZN6S887C3D1Ev();
extern void _ZN6S887C3D0Ev();
extern void _ZN6S887C52v2Ev();
extern void _ZN6S887C52v3Ev();
extern void _ZN6S887C52v4Ev();
extern void _ZN6S887C52v5Ev();
extern void _ZN6S887C52v6Ev();
extern void _ZN6S887C52v7Ev();
extern void _ZN6S887C52v8Ev();
extern void _ZN6S887C52v9Ev();
extern void _ZN6S887C53v10Ev();
extern void _ZN6S887C53v11Ev();
extern void _ZN6S887C53v12Ev();
extern void _ZN6S887C53v13Ev();
extern void _ZN6S887C43v14Ev();
extern void _ZN6S887C43v15Ev();
extern void _ZN6S887C43v16Ev();
extern void _ZN6S887C43v17Ev();
extern void _ZN6S887C43v18Ev();
extern void _ZN6S887C43v19Ev();
extern void _ZN6S887C43v20Ev();
extern void _ZN6S887C33v57Ev();
extern void _ZN6S887C33v58Ev();
extern void _ZN6S887C33v59Ev();
extern void _ZN6S887C33v60Ev();
extern void _ZN6S887C33v61Ev();
extern void _ZN6S887C33v62Ev();
extern void _ZN6S887C33v63Ev();
extern void _ZN6S887C33v64Ev();
extern void _ZN6S887C33v65Ev();
extern void _ZN6S887C33v66Ev();
extern void _ZN6S887C33v67Ev();
extern void _ZN6S887C33v68Ev();
extern void _ZN6S887C33v69Ev();
extern void _ZN6S887C33v70Ev();
extern void _ZN6S887C33v71Ev();
extern void _ZN6S887C33v72Ev();
extern void _ZN6S887C33v73Ev();
extern void _ZN6S887C33v74Ev();
extern void _ZN6S887C33v75Ev();
extern void _ZN6S887C33v76Ev();
extern void _ZN6S887C33v77Ev();
extern void _ZN6S887C33v78Ev();
extern void _ZN6S887C33v79Ev();
extern void _ZN6S887C33v80Ev();
extern void _ZN6S887C33v81Ev();
extern void _ZN6S887C33v82Ev();
extern void _ZN6S887C33v83Ev();
extern void _ZN6S887C33v84Ev();
extern void _ZN6S887C33v85Ev();
extern void _ZN6S887C33v86Ev();
extern void _ZN6S887C33v87Ev();
extern void _ZN6S887C33v88Ev();
extern void ABISELECT(_ZThn96_N6S887C3D1Ev,_ZThn72_N6S887C3D1Ev)();
extern void ABISELECT(_ZThn96_N6S887C3D0Ev,_ZThn72_N6S887C3D0Ev)();
extern void _ZN7S887C163v21Ev();
extern void _ZN7S887C163v22Ev();
extern void _ZN7S887C163v23Ev();
extern void _ZN7S887C153v24Ev();
extern void _ZN7S887C153v25Ev();
extern void _ZN7S887C153v26Ev();
extern void _ZN7S887C153v27Ev();
extern void _ZN7S887C143v28Ev();
extern void _ZN7S887C143v29Ev();
extern void _ZN7S887C143v30Ev();
extern void ABISELECT(_ZThn168_N6S887C3D1Ev,_ZThn128_N6S887C3D1Ev)();
extern void ABISELECT(_ZThn168_N6S887C3D0Ev,_ZThn128_N6S887C3D0Ev)();
extern void _ZN7S887C203v31Ev();
extern void _ZN7S887C203v32Ev();
extern void _ZN7S887C203v33Ev();
extern void _ZN7S887C203v34Ev();
extern void _ZN7S887C203v35Ev();
extern void _ZN7S887C203v36Ev();
extern void _ZN7S887C203v37Ev();
extern void _ZN7S887C203v38Ev();
extern void _ZN7S887C203v39Ev();
extern void _ZN7S887C203v40Ev();
extern void _ZN7S887C203v41Ev();
extern void _ZN7S887C203v42Ev();
extern void _ZN7S887C203v43Ev();
extern void _ZN7S887C203v44Ev();
extern void _ZN7S887C203v45Ev();
extern void _ZN7S887C203v46Ev();
extern void _ZN7S887C203v47Ev();
extern void _ZN7S887C203v48Ev();
extern void _ZN7S887C203v49Ev();
extern void _ZN7S887C203v50Ev();
extern void _ZN7S887C203v51Ev();
extern void _ZN7S887C203v52Ev();
extern void _ZN7S887C203v53Ev();
extern void _ZN7S887C203v54Ev();
extern void _ZN7S887C203v55Ev();
extern void _ZN7S887C203v56Ev();
static  VTBL_ENTRY vtc_S887C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S887C3[0]),
  (VTBL_ENTRY)&_ZN6S887C3D1Ev,
  (VTBL_ENTRY)&_ZN6S887C3D0Ev,
  (VTBL_ENTRY)&_ZN6S887C52v2Ev,
  (VTBL_ENTRY)&_ZN6S887C52v3Ev,
  (VTBL_ENTRY)&_ZN6S887C52v4Ev,
  (VTBL_ENTRY)&_ZN6S887C52v5Ev,
  (VTBL_ENTRY)&_ZN6S887C52v6Ev,
  (VTBL_ENTRY)&_ZN6S887C52v7Ev,
  (VTBL_ENTRY)&_ZN6S887C52v8Ev,
  (VTBL_ENTRY)&_ZN6S887C52v9Ev,
  (VTBL_ENTRY)&_ZN6S887C53v10Ev,
  (VTBL_ENTRY)&_ZN6S887C53v11Ev,
  (VTBL_ENTRY)&_ZN6S887C53v12Ev,
  (VTBL_ENTRY)&_ZN6S887C53v13Ev,
  (VTBL_ENTRY)&_ZN6S887C43v14Ev,
  (VTBL_ENTRY)&_ZN6S887C43v15Ev,
  (VTBL_ENTRY)&_ZN6S887C43v16Ev,
  (VTBL_ENTRY)&_ZN6S887C43v17Ev,
  (VTBL_ENTRY)&_ZN6S887C43v18Ev,
  (VTBL_ENTRY)&_ZN6S887C43v19Ev,
  (VTBL_ENTRY)&_ZN6S887C43v20Ev,
  (VTBL_ENTRY)&_ZN6S887C33v57Ev,
  (VTBL_ENTRY)&_ZN6S887C33v58Ev,
  (VTBL_ENTRY)&_ZN6S887C33v59Ev,
  (VTBL_ENTRY)&_ZN6S887C33v60Ev,
  (VTBL_ENTRY)&_ZN6S887C33v61Ev,
  (VTBL_ENTRY)&_ZN6S887C33v62Ev,
  (VTBL_ENTRY)&_ZN6S887C33v63Ev,
  (VTBL_ENTRY)&_ZN6S887C33v64Ev,
  (VTBL_ENTRY)&_ZN6S887C33v65Ev,
  (VTBL_ENTRY)&_ZN6S887C33v66Ev,
  (VTBL_ENTRY)&_ZN6S887C33v67Ev,
  (VTBL_ENTRY)&_ZN6S887C33v68Ev,
  (VTBL_ENTRY)&_ZN6S887C33v69Ev,
  (VTBL_ENTRY)&_ZN6S887C33v70Ev,
  (VTBL_ENTRY)&_ZN6S887C33v71Ev,
  (VTBL_ENTRY)&_ZN6S887C33v72Ev,
  (VTBL_ENTRY)&_ZN6S887C33v73Ev,
  (VTBL_ENTRY)&_ZN6S887C33v74Ev,
  (VTBL_ENTRY)&_ZN6S887C33v75Ev,
  (VTBL_ENTRY)&_ZN6S887C33v76Ev,
  (VTBL_ENTRY)&_ZN6S887C33v77Ev,
  (VTBL_ENTRY)&_ZN6S887C33v78Ev,
  (VTBL_ENTRY)&_ZN6S887C33v79Ev,
  (VTBL_ENTRY)&_ZN6S887C33v80Ev,
  (VTBL_ENTRY)&_ZN6S887C33v81Ev,
  (VTBL_ENTRY)&_ZN6S887C33v82Ev,
  (VTBL_ENTRY)&_ZN6S887C33v83Ev,
  (VTBL_ENTRY)&_ZN6S887C33v84Ev,
  (VTBL_ENTRY)&_ZN6S887C33v85Ev,
  (VTBL_ENTRY)&_ZN6S887C33v86Ev,
  (VTBL_ENTRY)&_ZN6S887C33v87Ev,
  (VTBL_ENTRY)&_ZN6S887C33v88Ev,
  ABISELECT(-96,-72),
  (VTBL_ENTRY)&(_ZTI6S887C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N6S887C3D1Ev,_ZThn72_N6S887C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N6S887C3D0Ev,_ZThn72_N6S887C3D0Ev),
  (VTBL_ENTRY)&_ZN7S887C163v21Ev,
  (VTBL_ENTRY)&_ZN7S887C163v22Ev,
  (VTBL_ENTRY)&_ZN7S887C163v23Ev,
  (VTBL_ENTRY)&_ZN7S887C153v24Ev,
  (VTBL_ENTRY)&_ZN7S887C153v25Ev,
  (VTBL_ENTRY)&_ZN7S887C153v26Ev,
  (VTBL_ENTRY)&_ZN7S887C153v27Ev,
  (VTBL_ENTRY)&_ZN7S887C143v28Ev,
  (VTBL_ENTRY)&_ZN7S887C143v29Ev,
  (VTBL_ENTRY)&_ZN7S887C143v30Ev,
  ABISELECT(-168,-128),
  (VTBL_ENTRY)&(_ZTI6S887C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N6S887C3D1Ev,_ZThn128_N6S887C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N6S887C3D0Ev,_ZThn128_N6S887C3D0Ev),
  (VTBL_ENTRY)&_ZN7S887C203v31Ev,
  (VTBL_ENTRY)&_ZN7S887C203v32Ev,
  (VTBL_ENTRY)&_ZN7S887C203v33Ev,
  (VTBL_ENTRY)&_ZN7S887C203v34Ev,
  (VTBL_ENTRY)&_ZN7S887C203v35Ev,
  (VTBL_ENTRY)&_ZN7S887C203v36Ev,
  (VTBL_ENTRY)&_ZN7S887C203v37Ev,
  (VTBL_ENTRY)&_ZN7S887C203v38Ev,
  (VTBL_ENTRY)&_ZN7S887C203v39Ev,
  (VTBL_ENTRY)&_ZN7S887C203v40Ev,
  (VTBL_ENTRY)&_ZN7S887C203v41Ev,
  (VTBL_ENTRY)&_ZN7S887C203v42Ev,
  (VTBL_ENTRY)&_ZN7S887C203v43Ev,
  (VTBL_ENTRY)&_ZN7S887C203v44Ev,
  (VTBL_ENTRY)&_ZN7S887C203v45Ev,
  (VTBL_ENTRY)&_ZN7S887C203v46Ev,
  (VTBL_ENTRY)&_ZN7S887C203v47Ev,
  (VTBL_ENTRY)&_ZN7S887C203v48Ev,
  (VTBL_ENTRY)&_ZN7S887C203v49Ev,
  (VTBL_ENTRY)&_ZN7S887C203v50Ev,
  (VTBL_ENTRY)&_ZN7S887C203v51Ev,
  (VTBL_ENTRY)&_ZN7S887C203v52Ev,
  (VTBL_ENTRY)&_ZN7S887C203v53Ev,
  (VTBL_ENTRY)&_ZN7S887C203v54Ev,
  (VTBL_ENTRY)&_ZN7S887C203v55Ev,
  (VTBL_ENTRY)&_ZN7S887C203v56Ev,
};
extern VTBL_ENTRY _ZTI6S887C3[];
extern  VTBL_ENTRY _ZTV6S887C3[];
Class_Descriptor cd_S887C3 = {  "S887C3", // class name
  bases_S887C3, 6,
  &(vtc_S887C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(320,240), // object size
  NSPAIRA(_ZTI6S887C3),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV6S887C3),99, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S887C24  {
  void *s887c24f0;
  ::S887C10_nt s887c24f1;
  ::S886C25_nt s887c24f2;
  int s887c24f3;
  char s887c24f4;
  void  mf887c24(); // _ZN7S887C248mf887c24Ev
};
//SIG(-1 S887C24) C1{ m Fp FC2{ m FC3{ FL[4]}} FC4{ m Fp FC5{ Fi[4]}} Fi Fc}


void  S887C24 ::mf887c24(){}

static void Test_S887C24()
{
  {
    init_simple_test("S887C24");
    S887C24 lv;
    check2(sizeof(lv), ABISELECT(72,64), "sizeof(S887C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S887C24)");
    check_field_offset(lv, s887c24f0, 0, "S887C24.s887c24f0");
    check_field_offset(lv, s887c24f1, ABISELECT(8,4), "S887C24.s887c24f1");
    check_field_offset(lv, s887c24f2, ABISELECT(40,36), "S887C24.s887c24f2");
    check_field_offset(lv, s887c24f3, ABISELECT(64,56), "S887C24.s887c24f3");
    check_field_offset(lv, s887c24f4, ABISELECT(68,60), "S887C24.s887c24f4");
  }
}
static Arrange_To_Call_Me vS887C24(Test_S887C24, "S887C24", ABISELECT(72,64));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S887C2  : S887C3 {
  ::S887C10_nt s887c2f0;
  ::S887C24 s887c2f1;
  int s887c2f2;
  virtual  ~S887C2(); // _ZN6S887C2D1Ev
  virtual void  v89(); // _ZN6S887C23v89Ev
  virtual void  v90(); // _ZN6S887C23v90Ev
  virtual void  v91(); // _ZN6S887C23v91Ev
  virtual void  v92(); // _ZN6S887C23v92Ev
  virtual void  v93(); // _ZN6S887C23v93Ev
  virtual void  v94(); // _ZN6S887C23v94Ev
  virtual void  v95(); // _ZN6S887C23v95Ev
  virtual void  v96(); // _ZN6S887C23v96Ev
  virtual void  v97(); // _ZN6S887C23v97Ev
  S887C2(); // tgen
};
//SIG(-1 S887C2) C1{ BC2{ BC3{ BC4{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 Fp FC5{ BC6{ m Fp Fi FC7{ m} FC8{ m}}} FC9{ m FC10{ FL[4]}} Fc} vd v22 v23 v24 v25 v26 v27 v28 FC11{ m Fp Fi[2] FC8}} BC12{ BC13{ BC14{ vd v29 v30 v31} vd v32 v33 v34 v35} vd v36 v37 v38 FC15{ m Fp Fi[2] FC7} FC9 Fc} BC16{ vd v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64} vd v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 FC17{ m Fp Fi FC7} Fc[2] Fi Fp[5] Fc[2] Fp FC18{ m Fp Fi[4] Fc Fi[3]} FL[2] Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 FC9 FC19{ m Fp FC9 FC20{ m Fp FC21{ Fi[4]}} Fi Fc} Fi}


 S887C2 ::~S887C2(){ note_dtor("S887C2", this);}
void  S887C2 ::v89(){vfunc_called(this, "_ZN6S887C23v89Ev");}
void  S887C2 ::v90(){vfunc_called(this, "_ZN6S887C23v90Ev");}
void  S887C2 ::v91(){vfunc_called(this, "_ZN6S887C23v91Ev");}
void  S887C2 ::v92(){vfunc_called(this, "_ZN6S887C23v92Ev");}
void  S887C2 ::v93(){vfunc_called(this, "_ZN6S887C23v93Ev");}
void  S887C2 ::v94(){vfunc_called(this, "_ZN6S887C23v94Ev");}
void  S887C2 ::v95(){vfunc_called(this, "_ZN6S887C23v95Ev");}
void  S887C2 ::v96(){vfunc_called(this, "_ZN6S887C23v96Ev");}
void  S887C2 ::v97(){vfunc_called(this, "_ZN6S887C23v97Ev");}
S887C2 ::S887C2(){ note_ctor("S887C2", this);} // tgen

static void Test_S887C2()
{
  extern Class_Descriptor cd_S887C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(55,86)];
    init_test(&cd_S887C2, buf);
    S887C2 *dp, &lv = *(dp=new (buf) S887C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(432,340), "sizeof(S887C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S887C2)");
    check_base_class_offset(lv, (S887C5*)(S887C4*)(S887C3*), 0, "S887C2");
    check_base_class_offset(lv, (S887C4*)(S887C3*), 0, "S887C2");
    check_base_class_offset(lv, (S887C16*)(S887C15*)(S887C14*)(S887C3*), ABISELECT(96,72), "S887C2");
    check_base_class_offset(lv, (S887C15*)(S887C14*)(S887C3*), ABISELECT(96,72), "S887C2");
    check_base_class_offset(lv, (S887C14*)(S887C3*), ABISELECT(96,72), "S887C2");
    check_base_class_offset(lv, (S887C20*)(S887C3*), ABISELECT(168,128), "S887C2");
    check_base_class_offset(lv, (S887C3*), 0, "S887C2");
    check_field_offset(lv, s887c2f0, ABISELECT(320,240), "S887C2.s887c2f0");
    check_field_offset(lv, s887c2f1, ABISELECT(352,272), "S887C2.s887c2f1");
    check_field_offset(lv, s887c2f2, ABISELECT(424,336), "S887C2.s887c2f2");
    test_class_info(&lv, &cd_S887C2);
    dp->~S887C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS887C2(Test_S887C2, "S887C2", ABISELECT(432,340));

#else // __cplusplus

extern void _ZN6S887C2C1Ev();
extern void _ZN6S887C2D1Ev();
Name_Map name_map_S887C2[] = {
  NSPAIR(_ZN6S887C2C1Ev),
  NSPAIR(_ZN6S887C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S887C5;
extern VTBL_ENTRY _ZTI6S887C5[];
extern  VTBL_ENTRY _ZTV6S887C5[];
extern Class_Descriptor cd_S887C4;
extern VTBL_ENTRY _ZTI6S887C4[];
extern  VTBL_ENTRY _ZTV6S887C4[];
extern Class_Descriptor cd_S887C16;
extern VTBL_ENTRY _ZTI7S887C16[];
extern  VTBL_ENTRY _ZTV7S887C16[];
extern Class_Descriptor cd_S887C15;
extern VTBL_ENTRY _ZTI7S887C15[];
extern  VTBL_ENTRY _ZTV7S887C15[];
extern Class_Descriptor cd_S887C14;
extern VTBL_ENTRY _ZTI7S887C14[];
extern  VTBL_ENTRY _ZTV7S887C14[];
extern Class_Descriptor cd_S887C20;
extern VTBL_ENTRY _ZTI7S887C20[];
extern  VTBL_ENTRY _ZTV7S887C20[];
extern Class_Descriptor cd_S887C3;
extern VTBL_ENTRY _ZTI6S887C3[];
extern  VTBL_ENTRY _ZTV6S887C3[];
static Base_Class bases_S887C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S887C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S887C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S887C16,    ABISELECT(96,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S887C15,    ABISELECT(96,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S887C14,    ABISELECT(96,72), //bcp->offset
    64, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S887C20,    ABISELECT(168,128), //bcp->offset
    78, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S887C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S887C2[];
extern void _ZN6S887C2D1Ev();
extern void _ZN6S887C2D0Ev();
extern void _ZN6S887C52v2Ev();
extern void _ZN6S887C52v3Ev();
extern void _ZN6S887C52v4Ev();
extern void _ZN6S887C52v5Ev();
extern void _ZN6S887C52v6Ev();
extern void _ZN6S887C52v7Ev();
extern void _ZN6S887C52v8Ev();
extern void _ZN6S887C52v9Ev();
extern void _ZN6S887C53v10Ev();
extern void _ZN6S887C53v11Ev();
extern void _ZN6S887C53v12Ev();
extern void _ZN6S887C53v13Ev();
extern void _ZN6S887C43v14Ev();
extern void _ZN6S887C43v15Ev();
extern void _ZN6S887C43v16Ev();
extern void _ZN6S887C43v17Ev();
extern void _ZN6S887C43v18Ev();
extern void _ZN6S887C43v19Ev();
extern void _ZN6S887C43v20Ev();
extern void _ZN6S887C33v57Ev();
extern void _ZN6S887C33v58Ev();
extern void _ZN6S887C33v59Ev();
extern void _ZN6S887C33v60Ev();
extern void _ZN6S887C33v61Ev();
extern void _ZN6S887C33v62Ev();
extern void _ZN6S887C33v63Ev();
extern void _ZN6S887C33v64Ev();
extern void _ZN6S887C33v65Ev();
extern void _ZN6S887C33v66Ev();
extern void _ZN6S887C33v67Ev();
extern void _ZN6S887C33v68Ev();
extern void _ZN6S887C33v69Ev();
extern void _ZN6S887C33v70Ev();
extern void _ZN6S887C33v71Ev();
extern void _ZN6S887C33v72Ev();
extern void _ZN6S887C33v73Ev();
extern void _ZN6S887C33v74Ev();
extern void _ZN6S887C33v75Ev();
extern void _ZN6S887C33v76Ev();
extern void _ZN6S887C33v77Ev();
extern void _ZN6S887C33v78Ev();
extern void _ZN6S887C33v79Ev();
extern void _ZN6S887C33v80Ev();
extern void _ZN6S887C33v81Ev();
extern void _ZN6S887C33v82Ev();
extern void _ZN6S887C33v83Ev();
extern void _ZN6S887C33v84Ev();
extern void _ZN6S887C33v85Ev();
extern void _ZN6S887C33v86Ev();
extern void _ZN6S887C33v87Ev();
extern void _ZN6S887C33v88Ev();
extern void _ZN6S887C23v89Ev();
extern void _ZN6S887C23v90Ev();
extern void _ZN6S887C23v91Ev();
extern void _ZN6S887C23v92Ev();
extern void _ZN6S887C23v93Ev();
extern void _ZN6S887C23v94Ev();
extern void _ZN6S887C23v95Ev();
extern void _ZN6S887C23v96Ev();
extern void _ZN6S887C23v97Ev();
extern void ABISELECT(_ZThn96_N6S887C2D1Ev,_ZThn72_N6S887C2D1Ev)();
extern void ABISELECT(_ZThn96_N6S887C2D0Ev,_ZThn72_N6S887C2D0Ev)();
extern void _ZN7S887C163v21Ev();
extern void _ZN7S887C163v22Ev();
extern void _ZN7S887C163v23Ev();
extern void _ZN7S887C153v24Ev();
extern void _ZN7S887C153v25Ev();
extern void _ZN7S887C153v26Ev();
extern void _ZN7S887C153v27Ev();
extern void _ZN7S887C143v28Ev();
extern void _ZN7S887C143v29Ev();
extern void _ZN7S887C143v30Ev();
extern void ABISELECT(_ZThn168_N6S887C2D1Ev,_ZThn128_N6S887C2D1Ev)();
extern void ABISELECT(_ZThn168_N6S887C2D0Ev,_ZThn128_N6S887C2D0Ev)();
extern void _ZN7S887C203v31Ev();
extern void _ZN7S887C203v32Ev();
extern void _ZN7S887C203v33Ev();
extern void _ZN7S887C203v34Ev();
extern void _ZN7S887C203v35Ev();
extern void _ZN7S887C203v36Ev();
extern void _ZN7S887C203v37Ev();
extern void _ZN7S887C203v38Ev();
extern void _ZN7S887C203v39Ev();
extern void _ZN7S887C203v40Ev();
extern void _ZN7S887C203v41Ev();
extern void _ZN7S887C203v42Ev();
extern void _ZN7S887C203v43Ev();
extern void _ZN7S887C203v44Ev();
extern void _ZN7S887C203v45Ev();
extern void _ZN7S887C203v46Ev();
extern void _ZN7S887C203v47Ev();
extern void _ZN7S887C203v48Ev();
extern void _ZN7S887C203v49Ev();
extern void _ZN7S887C203v50Ev();
extern void _ZN7S887C203v51Ev();
extern void _ZN7S887C203v52Ev();
extern void _ZN7S887C203v53Ev();
extern void _ZN7S887C203v54Ev();
extern void _ZN7S887C203v55Ev();
extern void _ZN7S887C203v56Ev();
static  VTBL_ENTRY vtc_S887C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S887C2[0]),
  (VTBL_ENTRY)&_ZN6S887C2D1Ev,
  (VTBL_ENTRY)&_ZN6S887C2D0Ev,
  (VTBL_ENTRY)&_ZN6S887C52v2Ev,
  (VTBL_ENTRY)&_ZN6S887C52v3Ev,
  (VTBL_ENTRY)&_ZN6S887C52v4Ev,
  (VTBL_ENTRY)&_ZN6S887C52v5Ev,
  (VTBL_ENTRY)&_ZN6S887C52v6Ev,
  (VTBL_ENTRY)&_ZN6S887C52v7Ev,
  (VTBL_ENTRY)&_ZN6S887C52v8Ev,
  (VTBL_ENTRY)&_ZN6S887C52v9Ev,
  (VTBL_ENTRY)&_ZN6S887C53v10Ev,
  (VTBL_ENTRY)&_ZN6S887C53v11Ev,
  (VTBL_ENTRY)&_ZN6S887C53v12Ev,
  (VTBL_ENTRY)&_ZN6S887C53v13Ev,
  (VTBL_ENTRY)&_ZN6S887C43v14Ev,
  (VTBL_ENTRY)&_ZN6S887C43v15Ev,
  (VTBL_ENTRY)&_ZN6S887C43v16Ev,
  (VTBL_ENTRY)&_ZN6S887C43v17Ev,
  (VTBL_ENTRY)&_ZN6S887C43v18Ev,
  (VTBL_ENTRY)&_ZN6S887C43v19Ev,
  (VTBL_ENTRY)&_ZN6S887C43v20Ev,
  (VTBL_ENTRY)&_ZN6S887C33v57Ev,
  (VTBL_ENTRY)&_ZN6S887C33v58Ev,
  (VTBL_ENTRY)&_ZN6S887C33v59Ev,
  (VTBL_ENTRY)&_ZN6S887C33v60Ev,
  (VTBL_ENTRY)&_ZN6S887C33v61Ev,
  (VTBL_ENTRY)&_ZN6S887C33v62Ev,
  (VTBL_ENTRY)&_ZN6S887C33v63Ev,
  (VTBL_ENTRY)&_ZN6S887C33v64Ev,
  (VTBL_ENTRY)&_ZN6S887C33v65Ev,
  (VTBL_ENTRY)&_ZN6S887C33v66Ev,
  (VTBL_ENTRY)&_ZN6S887C33v67Ev,
  (VTBL_ENTRY)&_ZN6S887C33v68Ev,
  (VTBL_ENTRY)&_ZN6S887C33v69Ev,
  (VTBL_ENTRY)&_ZN6S887C33v70Ev,
  (VTBL_ENTRY)&_ZN6S887C33v71Ev,
  (VTBL_ENTRY)&_ZN6S887C33v72Ev,
  (VTBL_ENTRY)&_ZN6S887C33v73Ev,
  (VTBL_ENTRY)&_ZN6S887C33v74Ev,
  (VTBL_ENTRY)&_ZN6S887C33v75Ev,
  (VTBL_ENTRY)&_ZN6S887C33v76Ev,
  (VTBL_ENTRY)&_ZN6S887C33v77Ev,
  (VTBL_ENTRY)&_ZN6S887C33v78Ev,
  (VTBL_ENTRY)&_ZN6S887C33v79Ev,
  (VTBL_ENTRY)&_ZN6S887C33v80Ev,
  (VTBL_ENTRY)&_ZN6S887C33v81Ev,
  (VTBL_ENTRY)&_ZN6S887C33v82Ev,
  (VTBL_ENTRY)&_ZN6S887C33v83Ev,
  (VTBL_ENTRY)&_ZN6S887C33v84Ev,
  (VTBL_ENTRY)&_ZN6S887C33v85Ev,
  (VTBL_ENTRY)&_ZN6S887C33v86Ev,
  (VTBL_ENTRY)&_ZN6S887C33v87Ev,
  (VTBL_ENTRY)&_ZN6S887C33v88Ev,
  (VTBL_ENTRY)&_ZN6S887C23v89Ev,
  (VTBL_ENTRY)&_ZN6S887C23v90Ev,
  (VTBL_ENTRY)&_ZN6S887C23v91Ev,
  (VTBL_ENTRY)&_ZN6S887C23v92Ev,
  (VTBL_ENTRY)&_ZN6S887C23v93Ev,
  (VTBL_ENTRY)&_ZN6S887C23v94Ev,
  (VTBL_ENTRY)&_ZN6S887C23v95Ev,
  (VTBL_ENTRY)&_ZN6S887C23v96Ev,
  (VTBL_ENTRY)&_ZN6S887C23v97Ev,
  ABISELECT(-96,-72),
  (VTBL_ENTRY)&(_ZTI6S887C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N6S887C2D1Ev,_ZThn72_N6S887C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N6S887C2D0Ev,_ZThn72_N6S887C2D0Ev),
  (VTBL_ENTRY)&_ZN7S887C163v21Ev,
  (VTBL_ENTRY)&_ZN7S887C163v22Ev,
  (VTBL_ENTRY)&_ZN7S887C163v23Ev,
  (VTBL_ENTRY)&_ZN7S887C153v24Ev,
  (VTBL_ENTRY)&_ZN7S887C153v25Ev,
  (VTBL_ENTRY)&_ZN7S887C153v26Ev,
  (VTBL_ENTRY)&_ZN7S887C153v27Ev,
  (VTBL_ENTRY)&_ZN7S887C143v28Ev,
  (VTBL_ENTRY)&_ZN7S887C143v29Ev,
  (VTBL_ENTRY)&_ZN7S887C143v30Ev,
  ABISELECT(-168,-128),
  (VTBL_ENTRY)&(_ZTI6S887C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N6S887C2D1Ev,_ZThn128_N6S887C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N6S887C2D0Ev,_ZThn128_N6S887C2D0Ev),
  (VTBL_ENTRY)&_ZN7S887C203v31Ev,
  (VTBL_ENTRY)&_ZN7S887C203v32Ev,
  (VTBL_ENTRY)&_ZN7S887C203v33Ev,
  (VTBL_ENTRY)&_ZN7S887C203v34Ev,
  (VTBL_ENTRY)&_ZN7S887C203v35Ev,
  (VTBL_ENTRY)&_ZN7S887C203v36Ev,
  (VTBL_ENTRY)&_ZN7S887C203v37Ev,
  (VTBL_ENTRY)&_ZN7S887C203v38Ev,
  (VTBL_ENTRY)&_ZN7S887C203v39Ev,
  (VTBL_ENTRY)&_ZN7S887C203v40Ev,
  (VTBL_ENTRY)&_ZN7S887C203v41Ev,
  (VTBL_ENTRY)&_ZN7S887C203v42Ev,
  (VTBL_ENTRY)&_ZN7S887C203v43Ev,
  (VTBL_ENTRY)&_ZN7S887C203v44Ev,
  (VTBL_ENTRY)&_ZN7S887C203v45Ev,
  (VTBL_ENTRY)&_ZN7S887C203v46Ev,
  (VTBL_ENTRY)&_ZN7S887C203v47Ev,
  (VTBL_ENTRY)&_ZN7S887C203v48Ev,
  (VTBL_ENTRY)&_ZN7S887C203v49Ev,
  (VTBL_ENTRY)&_ZN7S887C203v50Ev,
  (VTBL_ENTRY)&_ZN7S887C203v51Ev,
  (VTBL_ENTRY)&_ZN7S887C203v52Ev,
  (VTBL_ENTRY)&_ZN7S887C203v53Ev,
  (VTBL_ENTRY)&_ZN7S887C203v54Ev,
  (VTBL_ENTRY)&_ZN7S887C203v55Ev,
  (VTBL_ENTRY)&_ZN7S887C203v56Ev,
};
extern VTBL_ENTRY _ZTI6S887C2[];
extern  VTBL_ENTRY _ZTV6S887C2[];
Class_Descriptor cd_S887C2 = {  "S887C2", // class name
  bases_S887C2, 7,
  &(vtc_S887C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(432,340), // object size
  NSPAIRA(_ZTI6S887C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S887C2),108, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  7, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S887C1  : S887C2 {
  virtual  ~S887C1(); // _ZN6S887C1D1Ev
  virtual void  v1(); // _ZN6S887C12v1Ev
  S887C1(); // tgen
};
//SIG(1 S887C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 Fp FC6{ BC7{ m Fp Fi FC8{ m} FC9{ m}}} FC10{ m FC11{ FL[4]}} Fc} vd v14 v15 v16 v17 v18 v19 v20 FC12{ m Fp Fi[2] FC9}} BC13{ BC14{ BC15{ vd v21 v22 v23} vd v24 v25 v26 v27} vd v28 v29 v30 FC16{ m Fp Fi[2] FC8} FC10 Fc} BC17{ vd v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56} vd v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 FC18{ m Fp Fi FC8} Fc[2] Fi Fp[5] Fc[2] Fp FC19{ m Fp Fi[4] Fc Fi[3]} FL[2] Fi[2]} vd v89 v90 v91 v92 v93 v94 v95 v96 v97 FC10 FC20{ m Fp FC10 FC21{ m Fp FC22{ Fi[4]}} Fi Fc} Fi} vd v1}


 S887C1 ::~S887C1(){ note_dtor("S887C1", this);}
void  S887C1 ::v1(){vfunc_called(this, "_ZN6S887C12v1Ev");}
S887C1 ::S887C1(){ note_ctor("S887C1", this);} // tgen

static void Test_S887C1()
{
  extern Class_Descriptor cd_S887C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(55,86)];
    init_test(&cd_S887C1, buf);
    S887C1 *dp, &lv = *(dp=new (buf) S887C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(432,340), "sizeof(S887C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S887C1)");
    check_base_class_offset(lv, (S887C5*)(S887C4*)(S887C3*)(S887C2*), 0, "S887C1");
    check_base_class_offset(lv, (S887C4*)(S887C3*)(S887C2*), 0, "S887C1");
    check_base_class_offset(lv, (S887C16*)(S887C15*)(S887C14*)(S887C3*)(S887C2*), ABISELECT(96,72), "S887C1");
    check_base_class_offset(lv, (S887C15*)(S887C14*)(S887C3*)(S887C2*), ABISELECT(96,72), "S887C1");
    check_base_class_offset(lv, (S887C14*)(S887C3*)(S887C2*), ABISELECT(96,72), "S887C1");
    check_base_class_offset(lv, (S887C20*)(S887C3*)(S887C2*), ABISELECT(168,128), "S887C1");
    check_base_class_offset(lv, (S887C3*)(S887C2*), 0, "S887C1");
    check_base_class_offset(lv, (S887C2*), 0, "S887C1");
    test_class_info(&lv, &cd_S887C1);
    dp->~S887C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS887C1(Test_S887C1, "S887C1", ABISELECT(432,340));

#else // __cplusplus

extern void _ZN6S887C1C1Ev();
extern void _ZN6S887C1D1Ev();
Name_Map name_map_S887C1[] = {
  NSPAIR(_ZN6S887C1C1Ev),
  NSPAIR(_ZN6S887C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S887C5;
extern VTBL_ENTRY _ZTI6S887C5[];
extern  VTBL_ENTRY _ZTV6S887C5[];
extern Class_Descriptor cd_S887C4;
extern VTBL_ENTRY _ZTI6S887C4[];
extern  VTBL_ENTRY _ZTV6S887C4[];
extern Class_Descriptor cd_S887C16;
extern VTBL_ENTRY _ZTI7S887C16[];
extern  VTBL_ENTRY _ZTV7S887C16[];
extern Class_Descriptor cd_S887C15;
extern VTBL_ENTRY _ZTI7S887C15[];
extern  VTBL_ENTRY _ZTV7S887C15[];
extern Class_Descriptor cd_S887C14;
extern VTBL_ENTRY _ZTI7S887C14[];
extern  VTBL_ENTRY _ZTV7S887C14[];
extern Class_Descriptor cd_S887C20;
extern VTBL_ENTRY _ZTI7S887C20[];
extern  VTBL_ENTRY _ZTV7S887C20[];
extern Class_Descriptor cd_S887C3;
extern VTBL_ENTRY _ZTI6S887C3[];
extern  VTBL_ENTRY _ZTV6S887C3[];
extern Class_Descriptor cd_S887C2;
extern VTBL_ENTRY _ZTI6S887C2[];
extern  VTBL_ENTRY _ZTV6S887C2[];
static Base_Class bases_S887C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S887C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S887C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S887C16,    ABISELECT(96,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S887C15,    ABISELECT(96,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S887C14,    ABISELECT(96,72), //bcp->offset
    65, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S887C20,    ABISELECT(168,128), //bcp->offset
    79, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S887C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S887C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S887C1[];
extern void _ZN6S887C1D1Ev();
extern void _ZN6S887C1D0Ev();
extern void _ZN6S887C52v2Ev();
extern void _ZN6S887C52v3Ev();
extern void _ZN6S887C52v4Ev();
extern void _ZN6S887C52v5Ev();
extern void _ZN6S887C52v6Ev();
extern void _ZN6S887C52v7Ev();
extern void _ZN6S887C52v8Ev();
extern void _ZN6S887C52v9Ev();
extern void _ZN6S887C53v10Ev();
extern void _ZN6S887C53v11Ev();
extern void _ZN6S887C53v12Ev();
extern void _ZN6S887C53v13Ev();
extern void _ZN6S887C43v14Ev();
extern void _ZN6S887C43v15Ev();
extern void _ZN6S887C43v16Ev();
extern void _ZN6S887C43v17Ev();
extern void _ZN6S887C43v18Ev();
extern void _ZN6S887C43v19Ev();
extern void _ZN6S887C43v20Ev();
extern void _ZN6S887C33v57Ev();
extern void _ZN6S887C33v58Ev();
extern void _ZN6S887C33v59Ev();
extern void _ZN6S887C33v60Ev();
extern void _ZN6S887C33v61Ev();
extern void _ZN6S887C33v62Ev();
extern void _ZN6S887C33v63Ev();
extern void _ZN6S887C33v64Ev();
extern void _ZN6S887C33v65Ev();
extern void _ZN6S887C33v66Ev();
extern void _ZN6S887C33v67Ev();
extern void _ZN6S887C33v68Ev();
extern void _ZN6S887C33v69Ev();
extern void _ZN6S887C33v70Ev();
extern void _ZN6S887C33v71Ev();
extern void _ZN6S887C33v72Ev();
extern void _ZN6S887C33v73Ev();
extern void _ZN6S887C33v74Ev();
extern void _ZN6S887C33v75Ev();
extern void _ZN6S887C33v76Ev();
extern void _ZN6S887C33v77Ev();
extern void _ZN6S887C33v78Ev();
extern void _ZN6S887C33v79Ev();
extern void _ZN6S887C33v80Ev();
extern void _ZN6S887C33v81Ev();
extern void _ZN6S887C33v82Ev();
extern void _ZN6S887C33v83Ev();
extern void _ZN6S887C33v84Ev();
extern void _ZN6S887C33v85Ev();
extern void _ZN6S887C33v86Ev();
extern void _ZN6S887C33v87Ev();
extern void _ZN6S887C33v88Ev();
extern void _ZN6S887C23v89Ev();
extern void _ZN6S887C23v90Ev();
extern void _ZN6S887C23v91Ev();
extern void _ZN6S887C23v92Ev();
extern void _ZN6S887C23v93Ev();
extern void _ZN6S887C23v94Ev();
extern void _ZN6S887C23v95Ev();
extern void _ZN6S887C23v96Ev();
extern void _ZN6S887C23v97Ev();
extern void _ZN6S887C12v1Ev();
extern void ABISELECT(_ZThn96_N6S887C1D1Ev,_ZThn72_N6S887C1D1Ev)();
extern void ABISELECT(_ZThn96_N6S887C1D0Ev,_ZThn72_N6S887C1D0Ev)();
extern void _ZN7S887C163v21Ev();
extern void _ZN7S887C163v22Ev();
extern void _ZN7S887C163v23Ev();
extern void _ZN7S887C153v24Ev();
extern void _ZN7S887C153v25Ev();
extern void _ZN7S887C153v26Ev();
extern void _ZN7S887C153v27Ev();
extern void _ZN7S887C143v28Ev();
extern void _ZN7S887C143v29Ev();
extern void _ZN7S887C143v30Ev();
extern void ABISELECT(_ZThn168_N6S887C1D1Ev,_ZThn128_N6S887C1D1Ev)();
extern void ABISELECT(_ZThn168_N6S887C1D0Ev,_ZThn128_N6S887C1D0Ev)();
extern void _ZN7S887C203v31Ev();
extern void _ZN7S887C203v32Ev();
extern void _ZN7S887C203v33Ev();
extern void _ZN7S887C203v34Ev();
extern void _ZN7S887C203v35Ev();
extern void _ZN7S887C203v36Ev();
extern void _ZN7S887C203v37Ev();
extern void _ZN7S887C203v38Ev();
extern void _ZN7S887C203v39Ev();
extern void _ZN7S887C203v40Ev();
extern void _ZN7S887C203v41Ev();
extern void _ZN7S887C203v42Ev();
extern void _ZN7S887C203v43Ev();
extern void _ZN7S887C203v44Ev();
extern void _ZN7S887C203v45Ev();
extern void _ZN7S887C203v46Ev();
extern void _ZN7S887C203v47Ev();
extern void _ZN7S887C203v48Ev();
extern void _ZN7S887C203v49Ev();
extern void _ZN7S887C203v50Ev();
extern void _ZN7S887C203v51Ev();
extern void _ZN7S887C203v52Ev();
extern void _ZN7S887C203v53Ev();
extern void _ZN7S887C203v54Ev();
extern void _ZN7S887C203v55Ev();
extern void _ZN7S887C203v56Ev();
static  VTBL_ENTRY vtc_S887C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S887C1[0]),
  (VTBL_ENTRY)&_ZN6S887C1D1Ev,
  (VTBL_ENTRY)&_ZN6S887C1D0Ev,
  (VTBL_ENTRY)&_ZN6S887C52v2Ev,
  (VTBL_ENTRY)&_ZN6S887C52v3Ev,
  (VTBL_ENTRY)&_ZN6S887C52v4Ev,
  (VTBL_ENTRY)&_ZN6S887C52v5Ev,
  (VTBL_ENTRY)&_ZN6S887C52v6Ev,
  (VTBL_ENTRY)&_ZN6S887C52v7Ev,
  (VTBL_ENTRY)&_ZN6S887C52v8Ev,
  (VTBL_ENTRY)&_ZN6S887C52v9Ev,
  (VTBL_ENTRY)&_ZN6S887C53v10Ev,
  (VTBL_ENTRY)&_ZN6S887C53v11Ev,
  (VTBL_ENTRY)&_ZN6S887C53v12Ev,
  (VTBL_ENTRY)&_ZN6S887C53v13Ev,
  (VTBL_ENTRY)&_ZN6S887C43v14Ev,
  (VTBL_ENTRY)&_ZN6S887C43v15Ev,
  (VTBL_ENTRY)&_ZN6S887C43v16Ev,
  (VTBL_ENTRY)&_ZN6S887C43v17Ev,
  (VTBL_ENTRY)&_ZN6S887C43v18Ev,
  (VTBL_ENTRY)&_ZN6S887C43v19Ev,
  (VTBL_ENTRY)&_ZN6S887C43v20Ev,
  (VTBL_ENTRY)&_ZN6S887C33v57Ev,
  (VTBL_ENTRY)&_ZN6S887C33v58Ev,
  (VTBL_ENTRY)&_ZN6S887C33v59Ev,
  (VTBL_ENTRY)&_ZN6S887C33v60Ev,
  (VTBL_ENTRY)&_ZN6S887C33v61Ev,
  (VTBL_ENTRY)&_ZN6S887C33v62Ev,
  (VTBL_ENTRY)&_ZN6S887C33v63Ev,
  (VTBL_ENTRY)&_ZN6S887C33v64Ev,
  (VTBL_ENTRY)&_ZN6S887C33v65Ev,
  (VTBL_ENTRY)&_ZN6S887C33v66Ev,
  (VTBL_ENTRY)&_ZN6S887C33v67Ev,
  (VTBL_ENTRY)&_ZN6S887C33v68Ev,
  (VTBL_ENTRY)&_ZN6S887C33v69Ev,
  (VTBL_ENTRY)&_ZN6S887C33v70Ev,
  (VTBL_ENTRY)&_ZN6S887C33v71Ev,
  (VTBL_ENTRY)&_ZN6S887C33v72Ev,
  (VTBL_ENTRY)&_ZN6S887C33v73Ev,
  (VTBL_ENTRY)&_ZN6S887C33v74Ev,
  (VTBL_ENTRY)&_ZN6S887C33v75Ev,
  (VTBL_ENTRY)&_ZN6S887C33v76Ev,
  (VTBL_ENTRY)&_ZN6S887C33v77Ev,
  (VTBL_ENTRY)&_ZN6S887C33v78Ev,
  (VTBL_ENTRY)&_ZN6S887C33v79Ev,
  (VTBL_ENTRY)&_ZN6S887C33v80Ev,
  (VTBL_ENTRY)&_ZN6S887C33v81Ev,
  (VTBL_ENTRY)&_ZN6S887C33v82Ev,
  (VTBL_ENTRY)&_ZN6S887C33v83Ev,
  (VTBL_ENTRY)&_ZN6S887C33v84Ev,
  (VTBL_ENTRY)&_ZN6S887C33v85Ev,
  (VTBL_ENTRY)&_ZN6S887C33v86Ev,
  (VTBL_ENTRY)&_ZN6S887C33v87Ev,
  (VTBL_ENTRY)&_ZN6S887C33v88Ev,
  (VTBL_ENTRY)&_ZN6S887C23v89Ev,
  (VTBL_ENTRY)&_ZN6S887C23v90Ev,
  (VTBL_ENTRY)&_ZN6S887C23v91Ev,
  (VTBL_ENTRY)&_ZN6S887C23v92Ev,
  (VTBL_ENTRY)&_ZN6S887C23v93Ev,
  (VTBL_ENTRY)&_ZN6S887C23v94Ev,
  (VTBL_ENTRY)&_ZN6S887C23v95Ev,
  (VTBL_ENTRY)&_ZN6S887C23v96Ev,
  (VTBL_ENTRY)&_ZN6S887C23v97Ev,
  (VTBL_ENTRY)&_ZN6S887C12v1Ev,
  ABISELECT(-96,-72),
  (VTBL_ENTRY)&(_ZTI6S887C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N6S887C1D1Ev,_ZThn72_N6S887C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N6S887C1D0Ev,_ZThn72_N6S887C1D0Ev),
  (VTBL_ENTRY)&_ZN7S887C163v21Ev,
  (VTBL_ENTRY)&_ZN7S887C163v22Ev,
  (VTBL_ENTRY)&_ZN7S887C163v23Ev,
  (VTBL_ENTRY)&_ZN7S887C153v24Ev,
  (VTBL_ENTRY)&_ZN7S887C153v25Ev,
  (VTBL_ENTRY)&_ZN7S887C153v26Ev,
  (VTBL_ENTRY)&_ZN7S887C153v27Ev,
  (VTBL_ENTRY)&_ZN7S887C143v28Ev,
  (VTBL_ENTRY)&_ZN7S887C143v29Ev,
  (VTBL_ENTRY)&_ZN7S887C143v30Ev,
  ABISELECT(-168,-128),
  (VTBL_ENTRY)&(_ZTI6S887C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N6S887C1D1Ev,_ZThn128_N6S887C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N6S887C1D0Ev,_ZThn128_N6S887C1D0Ev),
  (VTBL_ENTRY)&_ZN7S887C203v31Ev,
  (VTBL_ENTRY)&_ZN7S887C203v32Ev,
  (VTBL_ENTRY)&_ZN7S887C203v33Ev,
  (VTBL_ENTRY)&_ZN7S887C203v34Ev,
  (VTBL_ENTRY)&_ZN7S887C203v35Ev,
  (VTBL_ENTRY)&_ZN7S887C203v36Ev,
  (VTBL_ENTRY)&_ZN7S887C203v37Ev,
  (VTBL_ENTRY)&_ZN7S887C203v38Ev,
  (VTBL_ENTRY)&_ZN7S887C203v39Ev,
  (VTBL_ENTRY)&_ZN7S887C203v40Ev,
  (VTBL_ENTRY)&_ZN7S887C203v41Ev,
  (VTBL_ENTRY)&_ZN7S887C203v42Ev,
  (VTBL_ENTRY)&_ZN7S887C203v43Ev,
  (VTBL_ENTRY)&_ZN7S887C203v44Ev,
  (VTBL_ENTRY)&_ZN7S887C203v45Ev,
  (VTBL_ENTRY)&_ZN7S887C203v46Ev,
  (VTBL_ENTRY)&_ZN7S887C203v47Ev,
  (VTBL_ENTRY)&_ZN7S887C203v48Ev,
  (VTBL_ENTRY)&_ZN7S887C203v49Ev,
  (VTBL_ENTRY)&_ZN7S887C203v50Ev,
  (VTBL_ENTRY)&_ZN7S887C203v51Ev,
  (VTBL_ENTRY)&_ZN7S887C203v52Ev,
  (VTBL_ENTRY)&_ZN7S887C203v53Ev,
  (VTBL_ENTRY)&_ZN7S887C203v54Ev,
  (VTBL_ENTRY)&_ZN7S887C203v55Ev,
  (VTBL_ENTRY)&_ZN7S887C203v56Ev,
};
extern VTBL_ENTRY _ZTI6S887C1[];
extern  VTBL_ENTRY _ZTV6S887C1[];
Class_Descriptor cd_S887C1 = {  "S887C1", // class name
  bases_S887C1, 8,
  &(vtc_S887C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(432,340), // object size
  NSPAIRA(_ZTI6S887C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S887C1),109, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  8, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2402C4  {
  void *s2402c4f0;
  ::S886C6_nt s2402c4f1;
  ::S887C10_nt s2402c4f2;
  char s2402c4f3;
  virtual  ~S2402C4(); // _ZN7S2402C4D1Ev
  virtual void  v6(); // _ZN7S2402C42v6Ev
  virtual void  v7(); // _ZN7S2402C42v7Ev
  virtual void  v8(); // _ZN7S2402C42v8Ev
  virtual void  v9(); // _ZN7S2402C42v9Ev
  virtual void  v10(); // _ZN7S2402C43v10Ev
  virtual void  v11(); // _ZN7S2402C43v11Ev
  virtual void  v12(); // _ZN7S2402C43v12Ev
  virtual void  v13(); // _ZN7S2402C43v13Ev
  virtual void  v14(); // _ZN7S2402C43v14Ev
  virtual void  v15(); // _ZN7S2402C43v15Ev
  virtual void  v16(); // _ZN7S2402C43v16Ev
  virtual void  v17(); // _ZN7S2402C43v17Ev
  S2402C4(); // tgen
};
//SIG(-1 S2402C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fp FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}} FC6{ m FC7{ FL[4]}} Fc}


 S2402C4 ::~S2402C4(){ note_dtor("S2402C4", this);}
void  S2402C4 ::v6(){vfunc_called(this, "_ZN7S2402C42v6Ev");}
void  S2402C4 ::v7(){vfunc_called(this, "_ZN7S2402C42v7Ev");}
void  S2402C4 ::v8(){vfunc_called(this, "_ZN7S2402C42v8Ev");}
void  S2402C4 ::v9(){vfunc_called(this, "_ZN7S2402C42v9Ev");}
void  S2402C4 ::v10(){vfunc_called(this, "_ZN7S2402C43v10Ev");}
void  S2402C4 ::v11(){vfunc_called(this, "_ZN7S2402C43v11Ev");}
void  S2402C4 ::v12(){vfunc_called(this, "_ZN7S2402C43v12Ev");}
void  S2402C4 ::v13(){vfunc_called(this, "_ZN7S2402C43v13Ev");}
void  S2402C4 ::v14(){vfunc_called(this, "_ZN7S2402C43v14Ev");}
void  S2402C4 ::v15(){vfunc_called(this, "_ZN7S2402C43v15Ev");}
void  S2402C4 ::v16(){vfunc_called(this, "_ZN7S2402C43v16Ev");}
void  S2402C4 ::v17(){vfunc_called(this, "_ZN7S2402C43v17Ev");}
S2402C4 ::S2402C4(){ note_ctor("S2402C4", this);} // tgen

static void Test_S2402C4()
{
  extern Class_Descriptor cd_S2402C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S2402C4, buf);
    S2402C4 *dp, &lv = *(dp=new (buf) S2402C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S2402C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2402C4)");
    check_field_offset(lv, s2402c4f0, ABISELECT(8,4), "S2402C4.s2402c4f0");
    check_field_offset(lv, s2402c4f1, ABISELECT(16,8), "S2402C4.s2402c4f1");
    check_field_offset(lv, s2402c4f2, ABISELECT(32,20), "S2402C4.s2402c4f2");
    check_field_offset(lv, s2402c4f3, ABISELECT(64,52), "S2402C4.s2402c4f3");
    test_class_info(&lv, &cd_S2402C4);
    dp->~S2402C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2402C4(Test_S2402C4, "S2402C4", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S2402C4C1Ev();
extern void _ZN7S2402C4D1Ev();
Name_Map name_map_S2402C4[] = {
  NSPAIR(_ZN7S2402C4C1Ev),
  NSPAIR(_ZN7S2402C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2402C4[];
extern void _ZN7S2402C4D1Ev();
extern void _ZN7S2402C4D0Ev();
extern void _ZN7S2402C42v6Ev();
extern void _ZN7S2402C42v7Ev();
extern void _ZN7S2402C42v8Ev();
extern void _ZN7S2402C42v9Ev();
extern void _ZN7S2402C43v10Ev();
extern void _ZN7S2402C43v11Ev();
extern void _ZN7S2402C43v12Ev();
extern void _ZN7S2402C43v13Ev();
extern void _ZN7S2402C43v14Ev();
extern void _ZN7S2402C43v15Ev();
extern void _ZN7S2402C43v16Ev();
extern void _ZN7S2402C43v17Ev();
static  VTBL_ENTRY vtc_S2402C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2402C4[0]),
  (VTBL_ENTRY)&_ZN7S2402C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2402C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2402C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2402C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2402C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2402C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v14Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v15Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v17Ev,
};
extern VTBL_ENTRY _ZTI7S2402C4[];
extern  VTBL_ENTRY _ZTV7S2402C4[];
Class_Descriptor cd_S2402C4 = {  "S2402C4", // class name
  0,0,//no base classes
  &(vtc_S2402C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S2402C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2402C4),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2402C3  : S2402C4 {
  ::S887C17 s2402c3f0;
  virtual  ~S2402C3(); // _ZN7S2402C3D1Ev
  virtual void  v18(); // _ZN7S2402C33v18Ev
  virtual void  v19(); // _ZN7S2402C33v19Ev
  virtual void  v20(); // _ZN7S2402C33v20Ev
  virtual void  v21(); // _ZN7S2402C33v21Ev
  virtual void  v22(); // _ZN7S2402C33v22Ev
  virtual void  v23(); // _ZN7S2402C33v23Ev
  virtual void  v24(); // _ZN7S2402C33v24Ev
  S2402C3(); // tgen
};
//SIG(-1 S2402C3) C1{ BC2{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 Fp FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}} FC7{ m FC8{ FL[4]}} Fc} vd v1 v2 v3 v4 v5 v6 v7 FC9{ m Fp Fi[2] FC5}}


 S2402C3 ::~S2402C3(){ note_dtor("S2402C3", this);}
void  S2402C3 ::v18(){vfunc_called(this, "_ZN7S2402C33v18Ev");}
void  S2402C3 ::v19(){vfunc_called(this, "_ZN7S2402C33v19Ev");}
void  S2402C3 ::v20(){vfunc_called(this, "_ZN7S2402C33v20Ev");}
void  S2402C3 ::v21(){vfunc_called(this, "_ZN7S2402C33v21Ev");}
void  S2402C3 ::v22(){vfunc_called(this, "_ZN7S2402C33v22Ev");}
void  S2402C3 ::v23(){vfunc_called(this, "_ZN7S2402C33v23Ev");}
void  S2402C3 ::v24(){vfunc_called(this, "_ZN7S2402C33v24Ev");}
S2402C3 ::S2402C3(){ note_ctor("S2402C3", this);} // tgen

static void Test_S2402C3()
{
  extern Class_Descriptor cd_S2402C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,19)];
    init_test(&cd_S2402C3, buf);
    S2402C3 *dp, &lv = *(dp=new (buf) S2402C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,72), "sizeof(S2402C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2402C3)");
    check_base_class_offset(lv, (S2402C4*), 0, "S2402C3");
    check_field_offset(lv, s2402c3f0, ABISELECT(72,56), "S2402C3.s2402c3f0");
    test_class_info(&lv, &cd_S2402C3);
    dp->~S2402C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2402C3(Test_S2402C3, "S2402C3", ABISELECT(96,72));

#else // __cplusplus

extern void _ZN7S2402C3C1Ev();
extern void _ZN7S2402C3D1Ev();
Name_Map name_map_S2402C3[] = {
  NSPAIR(_ZN7S2402C3C1Ev),
  NSPAIR(_ZN7S2402C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2402C4;
extern VTBL_ENTRY _ZTI7S2402C4[];
extern  VTBL_ENTRY _ZTV7S2402C4[];
static Base_Class bases_S2402C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2402C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2402C3[];
extern void _ZN7S2402C3D1Ev();
extern void _ZN7S2402C3D0Ev();
extern void _ZN7S2402C42v6Ev();
extern void _ZN7S2402C42v7Ev();
extern void _ZN7S2402C42v8Ev();
extern void _ZN7S2402C42v9Ev();
extern void _ZN7S2402C43v10Ev();
extern void _ZN7S2402C43v11Ev();
extern void _ZN7S2402C43v12Ev();
extern void _ZN7S2402C43v13Ev();
extern void _ZN7S2402C43v14Ev();
extern void _ZN7S2402C43v15Ev();
extern void _ZN7S2402C43v16Ev();
extern void _ZN7S2402C43v17Ev();
extern void _ZN7S2402C33v18Ev();
extern void _ZN7S2402C33v19Ev();
extern void _ZN7S2402C33v20Ev();
extern void _ZN7S2402C33v21Ev();
extern void _ZN7S2402C33v22Ev();
extern void _ZN7S2402C33v23Ev();
extern void _ZN7S2402C33v24Ev();
static  VTBL_ENTRY vtc_S2402C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2402C3[0]),
  (VTBL_ENTRY)&_ZN7S2402C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2402C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2402C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2402C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2402C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2402C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v14Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v15Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2402C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2402C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2402C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2402C33v21Ev,
  (VTBL_ENTRY)&_ZN7S2402C33v22Ev,
  (VTBL_ENTRY)&_ZN7S2402C33v23Ev,
  (VTBL_ENTRY)&_ZN7S2402C33v24Ev,
};
extern VTBL_ENTRY _ZTI7S2402C3[];
extern  VTBL_ENTRY _ZTV7S2402C3[];
Class_Descriptor cd_S2402C3 = {  "S2402C3", // class name
  bases_S2402C3, 1,
  &(vtc_S2402C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,72), // object size
  NSPAIRA(_ZTI7S2402C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2402C3),23, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2402C15  {
  virtual  ~S2402C15(); // _ZN8S2402C15D1Ev
  virtual void  v25(); // _ZN8S2402C153v25Ev
  virtual void  v26(); // _ZN8S2402C153v26Ev
  virtual void  v27(); // _ZN8S2402C153v27Ev
  S2402C15(); // tgen
};
//SIG(-1 S2402C15) C1{ vd v1 v2 v3}


 S2402C15 ::~S2402C15(){ note_dtor("S2402C15", this);}
void  S2402C15 ::v25(){vfunc_called(this, "_ZN8S2402C153v25Ev");}
void  S2402C15 ::v26(){vfunc_called(this, "_ZN8S2402C153v26Ev");}
void  S2402C15 ::v27(){vfunc_called(this, "_ZN8S2402C153v27Ev");}
S2402C15 ::S2402C15(){ note_ctor("S2402C15", this);} // tgen

static void Test_S2402C15()
{
  extern Class_Descriptor cd_S2402C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2402C15, buf);
    S2402C15 *dp, &lv = *(dp=new (buf) S2402C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2402C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2402C15)");
    test_class_info(&lv, &cd_S2402C15);
    dp->~S2402C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2402C15(Test_S2402C15, "S2402C15", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2402C15C1Ev();
extern void _ZN8S2402C15D1Ev();
Name_Map name_map_S2402C15[] = {
  NSPAIR(_ZN8S2402C15C1Ev),
  NSPAIR(_ZN8S2402C15D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2402C15[];
extern void _ZN8S2402C15D1Ev();
extern void _ZN8S2402C15D0Ev();
extern void _ZN8S2402C153v25Ev();
extern void _ZN8S2402C153v26Ev();
extern void _ZN8S2402C153v27Ev();
static  VTBL_ENTRY vtc_S2402C15[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2402C15[0]),
  (VTBL_ENTRY)&_ZN8S2402C15D1Ev,
  (VTBL_ENTRY)&_ZN8S2402C15D0Ev,
  (VTBL_ENTRY)&_ZN8S2402C153v25Ev,
  (VTBL_ENTRY)&_ZN8S2402C153v26Ev,
  (VTBL_ENTRY)&_ZN8S2402C153v27Ev,
};
extern VTBL_ENTRY _ZTI8S2402C15[];
extern  VTBL_ENTRY _ZTV8S2402C15[];
Class_Descriptor cd_S2402C15 = {  "S2402C15", // class name
  0,0,//no base classes
  &(vtc_S2402C15[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2402C15),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2402C15),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2402C14  : S2402C15 {
  virtual  ~S2402C14(); // _ZN8S2402C14D1Ev
  virtual void  v28(); // _ZN8S2402C143v28Ev
  virtual void  v29(); // _ZN8S2402C143v29Ev
  virtual void  v30(); // _ZN8S2402C143v30Ev
  virtual void  v31(); // _ZN8S2402C143v31Ev
  S2402C14(); // tgen
};
//SIG(-1 S2402C14) C1{ BC2{ vd v5 v6 v7} vd v1 v2 v3 v4}


 S2402C14 ::~S2402C14(){ note_dtor("S2402C14", this);}
void  S2402C14 ::v28(){vfunc_called(this, "_ZN8S2402C143v28Ev");}
void  S2402C14 ::v29(){vfunc_called(this, "_ZN8S2402C143v29Ev");}
void  S2402C14 ::v30(){vfunc_called(this, "_ZN8S2402C143v30Ev");}
void  S2402C14 ::v31(){vfunc_called(this, "_ZN8S2402C143v31Ev");}
S2402C14 ::S2402C14(){ note_ctor("S2402C14", this);} // tgen

static void Test_S2402C14()
{
  extern Class_Descriptor cd_S2402C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2402C14, buf);
    S2402C14 *dp, &lv = *(dp=new (buf) S2402C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2402C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2402C14)");
    check_base_class_offset(lv, (S2402C15*), 0, "S2402C14");
    test_class_info(&lv, &cd_S2402C14);
    dp->~S2402C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2402C14(Test_S2402C14, "S2402C14", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2402C14C1Ev();
extern void _ZN8S2402C14D1Ev();
Name_Map name_map_S2402C14[] = {
  NSPAIR(_ZN8S2402C14C1Ev),
  NSPAIR(_ZN8S2402C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2402C15;
extern VTBL_ENTRY _ZTI8S2402C15[];
extern  VTBL_ENTRY _ZTV8S2402C15[];
static Base_Class bases_S2402C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2402C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S2402C14[];
extern void _ZN8S2402C14D1Ev();
extern void _ZN8S2402C14D0Ev();
extern void _ZN8S2402C153v25Ev();
extern void _ZN8S2402C153v26Ev();
extern void _ZN8S2402C153v27Ev();
extern void _ZN8S2402C143v28Ev();
extern void _ZN8S2402C143v29Ev();
extern void _ZN8S2402C143v30Ev();
extern void _ZN8S2402C143v31Ev();
static  VTBL_ENTRY vtc_S2402C14[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2402C14[0]),
  (VTBL_ENTRY)&_ZN8S2402C14D1Ev,
  (VTBL_ENTRY)&_ZN8S2402C14D0Ev,
  (VTBL_ENTRY)&_ZN8S2402C153v25Ev,
  (VTBL_ENTRY)&_ZN8S2402C153v26Ev,
  (VTBL_ENTRY)&_ZN8S2402C153v27Ev,
  (VTBL_ENTRY)&_ZN8S2402C143v28Ev,
  (VTBL_ENTRY)&_ZN8S2402C143v29Ev,
  (VTBL_ENTRY)&_ZN8S2402C143v30Ev,
  (VTBL_ENTRY)&_ZN8S2402C143v31Ev,
};
extern VTBL_ENTRY _ZTI8S2402C14[];
extern  VTBL_ENTRY _ZTV8S2402C14[];
Class_Descriptor cd_S2402C14 = {  "S2402C14", // class name
  bases_S2402C14, 1,
  &(vtc_S2402C14[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2402C14),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S2402C14),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2402C18_nt  {
  ::S887C11_nt s2402c18f0;
  void  mf2402c18(); // _ZN11S2402C18_nt9mf2402c18Ev
};
//SIG(-1 S2402C18_nt) C1{ m FC2{ FL[4]}}


void  S2402C18_nt ::mf2402c18(){}

//skip512 S2402C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2402C13  : S2402C14 {
  ::S886C12_nt s2402c13f0;
  ::S2402C18_nt s2402c13f1;
  char s2402c13f2;
  virtual  ~S2402C13(); // _ZN8S2402C13D1Ev
  virtual void  v32(); // _ZN8S2402C133v32Ev
  virtual void  v33(); // _ZN8S2402C133v33Ev
  virtual void  v34(); // _ZN8S2402C133v34Ev
  S2402C13(); // tgen
};
//SIG(-1 S2402C13) C1{ BC2{ BC3{ vd v4 v5 v6} vd v7 v8 v9 v10} vd v1 v2 v3 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ FL[4]}} Fc}


 S2402C13 ::~S2402C13(){ note_dtor("S2402C13", this);}
void  S2402C13 ::v32(){vfunc_called(this, "_ZN8S2402C133v32Ev");}
void  S2402C13 ::v33(){vfunc_called(this, "_ZN8S2402C133v33Ev");}
void  S2402C13 ::v34(){vfunc_called(this, "_ZN8S2402C133v34Ev");}
S2402C13 ::S2402C13(){ note_ctor("S2402C13", this);} // tgen

static void Test_S2402C13()
{
  extern Class_Descriptor cd_S2402C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S2402C13, buf);
    S2402C13 *dp, &lv = *(dp=new (buf) S2402C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S2402C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2402C13)");
    check_base_class_offset(lv, (S2402C15*)(S2402C14*), 0, "S2402C13");
    check_base_class_offset(lv, (S2402C14*), 0, "S2402C13");
    check_field_offset(lv, s2402c13f0, ABISELECT(8,4), "S2402C13.s2402c13f0");
    check_field_offset(lv, s2402c13f1, ABISELECT(32,20), "S2402C13.s2402c13f1");
    check_field_offset(lv, s2402c13f2, ABISELECT(64,52), "S2402C13.s2402c13f2");
    test_class_info(&lv, &cd_S2402C13);
    dp->~S2402C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2402C13(Test_S2402C13, "S2402C13", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN8S2402C13C1Ev();
extern void _ZN8S2402C13D1Ev();
Name_Map name_map_S2402C13[] = {
  NSPAIR(_ZN8S2402C13C1Ev),
  NSPAIR(_ZN8S2402C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2402C15;
extern VTBL_ENTRY _ZTI8S2402C15[];
extern  VTBL_ENTRY _ZTV8S2402C15[];
extern Class_Descriptor cd_S2402C14;
extern VTBL_ENTRY _ZTI8S2402C14[];
extern  VTBL_ENTRY _ZTV8S2402C14[];
static Base_Class bases_S2402C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2402C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2402C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S2402C13[];
extern void _ZN8S2402C13D1Ev();
extern void _ZN8S2402C13D0Ev();
extern void _ZN8S2402C153v25Ev();
extern void _ZN8S2402C153v26Ev();
extern void _ZN8S2402C153v27Ev();
extern void _ZN8S2402C143v28Ev();
extern void _ZN8S2402C143v29Ev();
extern void _ZN8S2402C143v30Ev();
extern void _ZN8S2402C143v31Ev();
extern void _ZN8S2402C133v32Ev();
extern void _ZN8S2402C133v33Ev();
extern void _ZN8S2402C133v34Ev();
static  VTBL_ENTRY vtc_S2402C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2402C13[0]),
  (VTBL_ENTRY)&_ZN8S2402C13D1Ev,
  (VTBL_ENTRY)&_ZN8S2402C13D0Ev,
  (VTBL_ENTRY)&_ZN8S2402C153v25Ev,
  (VTBL_ENTRY)&_ZN8S2402C153v26Ev,
  (VTBL_ENTRY)&_ZN8S2402C153v27Ev,
  (VTBL_ENTRY)&_ZN8S2402C143v28Ev,
  (VTBL_ENTRY)&_ZN8S2402C143v29Ev,
  (VTBL_ENTRY)&_ZN8S2402C143v30Ev,
  (VTBL_ENTRY)&_ZN8S2402C143v31Ev,
  (VTBL_ENTRY)&_ZN8S2402C133v32Ev,
  (VTBL_ENTRY)&_ZN8S2402C133v33Ev,
  (VTBL_ENTRY)&_ZN8S2402C133v34Ev,
};
extern VTBL_ENTRY _ZTI8S2402C13[];
extern  VTBL_ENTRY _ZTV8S2402C13[];
Class_Descriptor cd_S2402C13 = {  "S2402C13", // class name
  bases_S2402C13, 2,
  &(vtc_S2402C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI8S2402C13),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S2402C13),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2402C19  {
  virtual  ~S2402C19(); // _ZN8S2402C19D1Ev
  virtual void  v35(); // _ZN8S2402C193v35Ev
  virtual void  v36(); // _ZN8S2402C193v36Ev
  virtual void  v37(); // _ZN8S2402C193v37Ev
  virtual void  v38(); // _ZN8S2402C193v38Ev
  virtual void  v39(); // _ZN8S2402C193v39Ev
  virtual void  v40(); // _ZN8S2402C193v40Ev
  virtual void  v41(); // _ZN8S2402C193v41Ev
  virtual void  v42(); // _ZN8S2402C193v42Ev
  virtual void  v43(); // _ZN8S2402C193v43Ev
  virtual void  v44(); // _ZN8S2402C193v44Ev
  virtual void  v45(); // _ZN8S2402C193v45Ev
  virtual void  v46(); // _ZN8S2402C193v46Ev
  virtual void  v47(); // _ZN8S2402C193v47Ev
  virtual void  v48(); // _ZN8S2402C193v48Ev
  virtual void  v49(); // _ZN8S2402C193v49Ev
  virtual void  v50(); // _ZN8S2402C193v50Ev
  virtual void  v51(); // _ZN8S2402C193v51Ev
  virtual void  v52(); // _ZN8S2402C193v52Ev
  virtual void  v53(); // _ZN8S2402C193v53Ev
  virtual void  v54(); // _ZN8S2402C193v54Ev
  virtual void  v55(); // _ZN8S2402C193v55Ev
  virtual void  v56(); // _ZN8S2402C193v56Ev
  virtual void  v57(); // _ZN8S2402C193v57Ev
  virtual void  v58(); // _ZN8S2402C193v58Ev
  virtual void  v59(); // _ZN8S2402C193v59Ev
  virtual void  v60(); // _ZN8S2402C193v60Ev
  S2402C19(); // tgen
};
//SIG(-1 S2402C19) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26}


 S2402C19 ::~S2402C19(){ note_dtor("S2402C19", this);}
void  S2402C19 ::v35(){vfunc_called(this, "_ZN8S2402C193v35Ev");}
void  S2402C19 ::v36(){vfunc_called(this, "_ZN8S2402C193v36Ev");}
void  S2402C19 ::v37(){vfunc_called(this, "_ZN8S2402C193v37Ev");}
void  S2402C19 ::v38(){vfunc_called(this, "_ZN8S2402C193v38Ev");}
void  S2402C19 ::v39(){vfunc_called(this, "_ZN8S2402C193v39Ev");}
void  S2402C19 ::v40(){vfunc_called(this, "_ZN8S2402C193v40Ev");}
void  S2402C19 ::v41(){vfunc_called(this, "_ZN8S2402C193v41Ev");}
void  S2402C19 ::v42(){vfunc_called(this, "_ZN8S2402C193v42Ev");}
void  S2402C19 ::v43(){vfunc_called(this, "_ZN8S2402C193v43Ev");}
void  S2402C19 ::v44(){vfunc_called(this, "_ZN8S2402C193v44Ev");}
void  S2402C19 ::v45(){vfunc_called(this, "_ZN8S2402C193v45Ev");}
void  S2402C19 ::v46(){vfunc_called(this, "_ZN8S2402C193v46Ev");}
void  S2402C19 ::v47(){vfunc_called(this, "_ZN8S2402C193v47Ev");}
void  S2402C19 ::v48(){vfunc_called(this, "_ZN8S2402C193v48Ev");}
void  S2402C19 ::v49(){vfunc_called(this, "_ZN8S2402C193v49Ev");}
void  S2402C19 ::v50(){vfunc_called(this, "_ZN8S2402C193v50Ev");}
void  S2402C19 ::v51(){vfunc_called(this, "_ZN8S2402C193v51Ev");}
void  S2402C19 ::v52(){vfunc_called(this, "_ZN8S2402C193v52Ev");}
void  S2402C19 ::v53(){vfunc_called(this, "_ZN8S2402C193v53Ev");}
void  S2402C19 ::v54(){vfunc_called(this, "_ZN8S2402C193v54Ev");}
void  S2402C19 ::v55(){vfunc_called(this, "_ZN8S2402C193v55Ev");}
void  S2402C19 ::v56(){vfunc_called(this, "_ZN8S2402C193v56Ev");}
void  S2402C19 ::v57(){vfunc_called(this, "_ZN8S2402C193v57Ev");}
void  S2402C19 ::v58(){vfunc_called(this, "_ZN8S2402C193v58Ev");}
void  S2402C19 ::v59(){vfunc_called(this, "_ZN8S2402C193v59Ev");}
void  S2402C19 ::v60(){vfunc_called(this, "_ZN8S2402C193v60Ev");}
S2402C19 ::S2402C19(){ note_ctor("S2402C19", this);} // tgen

static void Test_S2402C19()
{
  extern Class_Descriptor cd_S2402C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2402C19, buf);
    S2402C19 *dp, &lv = *(dp=new (buf) S2402C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2402C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2402C19)");
    test_class_info(&lv, &cd_S2402C19);
    dp->~S2402C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2402C19(Test_S2402C19, "S2402C19", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2402C19C1Ev();
extern void _ZN8S2402C19D1Ev();
Name_Map name_map_S2402C19[] = {
  NSPAIR(_ZN8S2402C19C1Ev),
  NSPAIR(_ZN8S2402C19D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2402C19[];
extern void _ZN8S2402C19D1Ev();
extern void _ZN8S2402C19D0Ev();
extern void _ZN8S2402C193v35Ev();
extern void _ZN8S2402C193v36Ev();
extern void _ZN8S2402C193v37Ev();
extern void _ZN8S2402C193v38Ev();
extern void _ZN8S2402C193v39Ev();
extern void _ZN8S2402C193v40Ev();
extern void _ZN8S2402C193v41Ev();
extern void _ZN8S2402C193v42Ev();
extern void _ZN8S2402C193v43Ev();
extern void _ZN8S2402C193v44Ev();
extern void _ZN8S2402C193v45Ev();
extern void _ZN8S2402C193v46Ev();
extern void _ZN8S2402C193v47Ev();
extern void _ZN8S2402C193v48Ev();
extern void _ZN8S2402C193v49Ev();
extern void _ZN8S2402C193v50Ev();
extern void _ZN8S2402C193v51Ev();
extern void _ZN8S2402C193v52Ev();
extern void _ZN8S2402C193v53Ev();
extern void _ZN8S2402C193v54Ev();
extern void _ZN8S2402C193v55Ev();
extern void _ZN8S2402C193v56Ev();
extern void _ZN8S2402C193v57Ev();
extern void _ZN8S2402C193v58Ev();
extern void _ZN8S2402C193v59Ev();
extern void _ZN8S2402C193v60Ev();
static  VTBL_ENTRY vtc_S2402C19[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2402C19[0]),
  (VTBL_ENTRY)&_ZN8S2402C19D1Ev,
  (VTBL_ENTRY)&_ZN8S2402C19D0Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v35Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v36Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v37Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v38Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v39Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v40Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v41Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v42Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v43Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v44Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v45Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v46Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v47Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v48Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v49Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v50Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v51Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v52Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v53Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v54Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v55Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v56Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v57Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v58Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v59Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v60Ev,
};
extern VTBL_ENTRY _ZTI8S2402C19[];
extern  VTBL_ENTRY _ZTV8S2402C19[];
Class_Descriptor cd_S2402C19 = {  "S2402C19", // class name
  0,0,//no base classes
  &(vtc_S2402C19[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2402C19),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2402C19),30, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2402C2  : S2402C3 , S2402C13 , S2402C19 {
  ::S1587C6_nt s2402c2f0;
  char s2402c2f1[2];
  int s2402c2f2;
  void *s2402c2f3[5];
  char s2402c2f4[2];
  void *s2402c2f5;
  ::S886C23 s2402c2f6;
  __tsi64 s2402c2f7[2];
  int s2402c2f8[2];
  virtual  ~S2402C2(); // _ZN7S2402C2D1Ev
  virtual void  v61(); // _ZN7S2402C23v61Ev
  virtual void  v62(); // _ZN7S2402C23v62Ev
  virtual void  v63(); // _ZN7S2402C23v63Ev
  virtual void  v64(); // _ZN7S2402C23v64Ev
  virtual void  v65(); // _ZN7S2402C23v65Ev
  virtual void  v66(); // _ZN7S2402C23v66Ev
  virtual void  v67(); // _ZN7S2402C23v67Ev
  virtual void  v68(); // _ZN7S2402C23v68Ev
  virtual void  v69(); // _ZN7S2402C23v69Ev
  virtual void  v70(); // _ZN7S2402C23v70Ev
  virtual void  v71(); // _ZN7S2402C23v71Ev
  virtual void  v72(); // _ZN7S2402C23v72Ev
  virtual void  v73(); // _ZN7S2402C23v73Ev
  virtual void  v74(); // _ZN7S2402C23v74Ev
  virtual void  v75(); // _ZN7S2402C23v75Ev
  virtual void  v76(); // _ZN7S2402C23v76Ev
  virtual void  v77(); // _ZN7S2402C23v77Ev
  virtual void  v78(); // _ZN7S2402C23v78Ev
  virtual void  v79(); // _ZN7S2402C23v79Ev
  virtual void  v80(); // _ZN7S2402C23v80Ev
  virtual void  v81(); // _ZN7S2402C23v81Ev
  virtual void  v82(); // _ZN7S2402C23v82Ev
  virtual void  v83(); // _ZN7S2402C23v83Ev
  virtual void  v84(); // _ZN7S2402C23v84Ev
  virtual void  v85(); // _ZN7S2402C23v85Ev
  virtual void  v86(); // _ZN7S2402C23v86Ev
  virtual void  v87(); // _ZN7S2402C23v87Ev
  virtual void  v88(); // _ZN7S2402C23v88Ev
  virtual void  v89(); // _ZN7S2402C23v89Ev
  virtual void  v90(); // _ZN7S2402C23v90Ev
  virtual void  v91(); // _ZN7S2402C23v91Ev
  virtual void  v92(); // _ZN7S2402C23v92Ev
  S2402C2(); // tgen
};
//SIG(-1 S2402C2) C1{ BC2{ BC3{ vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 Fp FC4{ BC5{ m Fp Fi FC6{ m} FC7{ m}}} FC8{ m FC9{ FL[4]}} Fc} vd v45 v46 v47 v48 v49 v50 v51 FC10{ m Fp Fi[2] FC6}} BC11{ BC12{ BC13{ vd v52 v53 v54} vd v55 v56 v57 v58} vd v59 v60 v61 FC14{ m Fp Fi[2] FC7} FC15{ m FC9} Fc} BC16{ vd v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 FC17{ m Fp Fi FC6} Fc[2] Fi Fp[5] Fc[2] Fp FC18{ m Fp Fi[4] Fc Fi[3]} FL[2] Fi[2]}


 S2402C2 ::~S2402C2(){ note_dtor("S2402C2", this);}
void  S2402C2 ::v61(){vfunc_called(this, "_ZN7S2402C23v61Ev");}
void  S2402C2 ::v62(){vfunc_called(this, "_ZN7S2402C23v62Ev");}
void  S2402C2 ::v63(){vfunc_called(this, "_ZN7S2402C23v63Ev");}
void  S2402C2 ::v64(){vfunc_called(this, "_ZN7S2402C23v64Ev");}
void  S2402C2 ::v65(){vfunc_called(this, "_ZN7S2402C23v65Ev");}
void  S2402C2 ::v66(){vfunc_called(this, "_ZN7S2402C23v66Ev");}
void  S2402C2 ::v67(){vfunc_called(this, "_ZN7S2402C23v67Ev");}
void  S2402C2 ::v68(){vfunc_called(this, "_ZN7S2402C23v68Ev");}
void  S2402C2 ::v69(){vfunc_called(this, "_ZN7S2402C23v69Ev");}
void  S2402C2 ::v70(){vfunc_called(this, "_ZN7S2402C23v70Ev");}
void  S2402C2 ::v71(){vfunc_called(this, "_ZN7S2402C23v71Ev");}
void  S2402C2 ::v72(){vfunc_called(this, "_ZN7S2402C23v72Ev");}
void  S2402C2 ::v73(){vfunc_called(this, "_ZN7S2402C23v73Ev");}
void  S2402C2 ::v74(){vfunc_called(this, "_ZN7S2402C23v74Ev");}
void  S2402C2 ::v75(){vfunc_called(this, "_ZN7S2402C23v75Ev");}
void  S2402C2 ::v76(){vfunc_called(this, "_ZN7S2402C23v76Ev");}
void  S2402C2 ::v77(){vfunc_called(this, "_ZN7S2402C23v77Ev");}
void  S2402C2 ::v78(){vfunc_called(this, "_ZN7S2402C23v78Ev");}
void  S2402C2 ::v79(){vfunc_called(this, "_ZN7S2402C23v79Ev");}
void  S2402C2 ::v80(){vfunc_called(this, "_ZN7S2402C23v80Ev");}
void  S2402C2 ::v81(){vfunc_called(this, "_ZN7S2402C23v81Ev");}
void  S2402C2 ::v82(){vfunc_called(this, "_ZN7S2402C23v82Ev");}
void  S2402C2 ::v83(){vfunc_called(this, "_ZN7S2402C23v83Ev");}
void  S2402C2 ::v84(){vfunc_called(this, "_ZN7S2402C23v84Ev");}
void  S2402C2 ::v85(){vfunc_called(this, "_ZN7S2402C23v85Ev");}
void  S2402C2 ::v86(){vfunc_called(this, "_ZN7S2402C23v86Ev");}
void  S2402C2 ::v87(){vfunc_called(this, "_ZN7S2402C23v87Ev");}
void  S2402C2 ::v88(){vfunc_called(this, "_ZN7S2402C23v88Ev");}
void  S2402C2 ::v89(){vfunc_called(this, "_ZN7S2402C23v89Ev");}
void  S2402C2 ::v90(){vfunc_called(this, "_ZN7S2402C23v90Ev");}
void  S2402C2 ::v91(){vfunc_called(this, "_ZN7S2402C23v91Ev");}
void  S2402C2 ::v92(){vfunc_called(this, "_ZN7S2402C23v92Ev");}
S2402C2 ::S2402C2(){ note_ctor("S2402C2", this);} // tgen

static void Test_S2402C2()
{
  extern Class_Descriptor cd_S2402C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(41,61)];
    init_test(&cd_S2402C2, buf);
    S2402C2 *dp, &lv = *(dp=new (buf) S2402C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(320,240), "sizeof(S2402C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2402C2)");
    check_base_class_offset(lv, (S2402C4*)(S2402C3*), 0, "S2402C2");
    check_base_class_offset(lv, (S2402C3*), 0, "S2402C2");
    check_base_class_offset(lv, (S2402C15*)(S2402C14*)(S2402C13*), ABISELECT(96,72), "S2402C2");
    check_base_class_offset(lv, (S2402C14*)(S2402C13*), ABISELECT(96,72), "S2402C2");
    check_base_class_offset(lv, (S2402C13*), ABISELECT(96,72), "S2402C2");
    check_base_class_offset(lv, (S2402C19*), ABISELECT(168,128), "S2402C2");
    check_field_offset(lv, s2402c2f0, ABISELECT(176,132), "S2402C2.s2402c2f0");
    check_field_offset(lv, s2402c2f1, ABISELECT(192,144), "S2402C2.s2402c2f1");
    check_field_offset(lv, s2402c2f2, ABISELECT(196,148), "S2402C2.s2402c2f2");
    check_field_offset(lv, s2402c2f3, ABISELECT(200,152), "S2402C2.s2402c2f3");
    check_field_offset(lv, s2402c2f4, ABISELECT(240,172), "S2402C2.s2402c2f4");
    check_field_offset(lv, s2402c2f5, ABISELECT(248,176), "S2402C2.s2402c2f5");
    check_field_offset(lv, s2402c2f6, ABISELECT(256,180), "S2402C2.s2402c2f6");
    check_field_offset(lv, s2402c2f7, ABISELECT(296,216), "S2402C2.s2402c2f7");
    check_field_offset(lv, s2402c2f8, ABISELECT(312,232), "S2402C2.s2402c2f8");
    test_class_info(&lv, &cd_S2402C2);
    dp->~S2402C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2402C2(Test_S2402C2, "S2402C2", ABISELECT(320,240));

#else // __cplusplus

extern void _ZN7S2402C2C1Ev();
extern void _ZN7S2402C2D1Ev();
Name_Map name_map_S2402C2[] = {
  NSPAIR(_ZN7S2402C2C1Ev),
  NSPAIR(_ZN7S2402C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2402C4;
extern VTBL_ENTRY _ZTI7S2402C4[];
extern  VTBL_ENTRY _ZTV7S2402C4[];
extern Class_Descriptor cd_S2402C3;
extern VTBL_ENTRY _ZTI7S2402C3[];
extern  VTBL_ENTRY _ZTV7S2402C3[];
extern Class_Descriptor cd_S2402C15;
extern VTBL_ENTRY _ZTI8S2402C15[];
extern  VTBL_ENTRY _ZTV8S2402C15[];
extern Class_Descriptor cd_S2402C14;
extern VTBL_ENTRY _ZTI8S2402C14[];
extern  VTBL_ENTRY _ZTV8S2402C14[];
extern Class_Descriptor cd_S2402C13;
extern VTBL_ENTRY _ZTI8S2402C13[];
extern  VTBL_ENTRY _ZTV8S2402C13[];
extern Class_Descriptor cd_S2402C19;
extern VTBL_ENTRY _ZTI8S2402C19[];
extern  VTBL_ENTRY _ZTV8S2402C19[];
static Base_Class bases_S2402C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2402C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2402C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2402C15,    ABISELECT(96,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2402C14,    ABISELECT(96,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2402C13,    ABISELECT(96,72), //bcp->offset
    55, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2402C19,    ABISELECT(168,128), //bcp->offset
    69, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2402C2[];
extern void _ZN7S2402C2D1Ev();
extern void _ZN7S2402C2D0Ev();
extern void _ZN7S2402C42v6Ev();
extern void _ZN7S2402C42v7Ev();
extern void _ZN7S2402C42v8Ev();
extern void _ZN7S2402C42v9Ev();
extern void _ZN7S2402C43v10Ev();
extern void _ZN7S2402C43v11Ev();
extern void _ZN7S2402C43v12Ev();
extern void _ZN7S2402C43v13Ev();
extern void _ZN7S2402C43v14Ev();
extern void _ZN7S2402C43v15Ev();
extern void _ZN7S2402C43v16Ev();
extern void _ZN7S2402C43v17Ev();
extern void _ZN7S2402C33v18Ev();
extern void _ZN7S2402C33v19Ev();
extern void _ZN7S2402C33v20Ev();
extern void _ZN7S2402C33v21Ev();
extern void _ZN7S2402C33v22Ev();
extern void _ZN7S2402C33v23Ev();
extern void _ZN7S2402C33v24Ev();
extern void _ZN7S2402C23v61Ev();
extern void _ZN7S2402C23v62Ev();
extern void _ZN7S2402C23v63Ev();
extern void _ZN7S2402C23v64Ev();
extern void _ZN7S2402C23v65Ev();
extern void _ZN7S2402C23v66Ev();
extern void _ZN7S2402C23v67Ev();
extern void _ZN7S2402C23v68Ev();
extern void _ZN7S2402C23v69Ev();
extern void _ZN7S2402C23v70Ev();
extern void _ZN7S2402C23v71Ev();
extern void _ZN7S2402C23v72Ev();
extern void _ZN7S2402C23v73Ev();
extern void _ZN7S2402C23v74Ev();
extern void _ZN7S2402C23v75Ev();
extern void _ZN7S2402C23v76Ev();
extern void _ZN7S2402C23v77Ev();
extern void _ZN7S2402C23v78Ev();
extern void _ZN7S2402C23v79Ev();
extern void _ZN7S2402C23v80Ev();
extern void _ZN7S2402C23v81Ev();
extern void _ZN7S2402C23v82Ev();
extern void _ZN7S2402C23v83Ev();
extern void _ZN7S2402C23v84Ev();
extern void _ZN7S2402C23v85Ev();
extern void _ZN7S2402C23v86Ev();
extern void _ZN7S2402C23v87Ev();
extern void _ZN7S2402C23v88Ev();
extern void _ZN7S2402C23v89Ev();
extern void _ZN7S2402C23v90Ev();
extern void _ZN7S2402C23v91Ev();
extern void _ZN7S2402C23v92Ev();
extern void ABISELECT(_ZThn96_N7S2402C2D1Ev,_ZThn72_N7S2402C2D1Ev)();
extern void ABISELECT(_ZThn96_N7S2402C2D0Ev,_ZThn72_N7S2402C2D0Ev)();
extern void _ZN8S2402C153v25Ev();
extern void _ZN8S2402C153v26Ev();
extern void _ZN8S2402C153v27Ev();
extern void _ZN8S2402C143v28Ev();
extern void _ZN8S2402C143v29Ev();
extern void _ZN8S2402C143v30Ev();
extern void _ZN8S2402C143v31Ev();
extern void _ZN8S2402C133v32Ev();
extern void _ZN8S2402C133v33Ev();
extern void _ZN8S2402C133v34Ev();
extern void ABISELECT(_ZThn168_N7S2402C2D1Ev,_ZThn128_N7S2402C2D1Ev)();
extern void ABISELECT(_ZThn168_N7S2402C2D0Ev,_ZThn128_N7S2402C2D0Ev)();
extern void _ZN8S2402C193v35Ev();
extern void _ZN8S2402C193v36Ev();
extern void _ZN8S2402C193v37Ev();
extern void _ZN8S2402C193v38Ev();
extern void _ZN8S2402C193v39Ev();
extern void _ZN8S2402C193v40Ev();
extern void _ZN8S2402C193v41Ev();
extern void _ZN8S2402C193v42Ev();
extern void _ZN8S2402C193v43Ev();
extern void _ZN8S2402C193v44Ev();
extern void _ZN8S2402C193v45Ev();
extern void _ZN8S2402C193v46Ev();
extern void _ZN8S2402C193v47Ev();
extern void _ZN8S2402C193v48Ev();
extern void _ZN8S2402C193v49Ev();
extern void _ZN8S2402C193v50Ev();
extern void _ZN8S2402C193v51Ev();
extern void _ZN8S2402C193v52Ev();
extern void _ZN8S2402C193v53Ev();
extern void _ZN8S2402C193v54Ev();
extern void _ZN8S2402C193v55Ev();
extern void _ZN8S2402C193v56Ev();
extern void _ZN8S2402C193v57Ev();
extern void _ZN8S2402C193v58Ev();
extern void _ZN8S2402C193v59Ev();
extern void _ZN8S2402C193v60Ev();
static  VTBL_ENTRY vtc_S2402C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2402C2[0]),
  (VTBL_ENTRY)&_ZN7S2402C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2402C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2402C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2402C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2402C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2402C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v14Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v15Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2402C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2402C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2402C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2402C33v21Ev,
  (VTBL_ENTRY)&_ZN7S2402C33v22Ev,
  (VTBL_ENTRY)&_ZN7S2402C33v23Ev,
  (VTBL_ENTRY)&_ZN7S2402C33v24Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v61Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v62Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v63Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v64Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v65Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v66Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v67Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v68Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v69Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v70Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v71Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v72Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v73Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v74Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v75Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v76Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v77Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v78Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v79Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v80Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v81Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v82Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v83Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v84Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v85Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v86Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v87Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v88Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v89Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v90Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v91Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v92Ev,
  ABISELECT(-96,-72),
  (VTBL_ENTRY)&(_ZTI7S2402C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N7S2402C2D1Ev,_ZThn72_N7S2402C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N7S2402C2D0Ev,_ZThn72_N7S2402C2D0Ev),
  (VTBL_ENTRY)&_ZN8S2402C153v25Ev,
  (VTBL_ENTRY)&_ZN8S2402C153v26Ev,
  (VTBL_ENTRY)&_ZN8S2402C153v27Ev,
  (VTBL_ENTRY)&_ZN8S2402C143v28Ev,
  (VTBL_ENTRY)&_ZN8S2402C143v29Ev,
  (VTBL_ENTRY)&_ZN8S2402C143v30Ev,
  (VTBL_ENTRY)&_ZN8S2402C143v31Ev,
  (VTBL_ENTRY)&_ZN8S2402C133v32Ev,
  (VTBL_ENTRY)&_ZN8S2402C133v33Ev,
  (VTBL_ENTRY)&_ZN8S2402C133v34Ev,
  ABISELECT(-168,-128),
  (VTBL_ENTRY)&(_ZTI7S2402C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N7S2402C2D1Ev,_ZThn128_N7S2402C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N7S2402C2D0Ev,_ZThn128_N7S2402C2D0Ev),
  (VTBL_ENTRY)&_ZN8S2402C193v35Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v36Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v37Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v38Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v39Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v40Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v41Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v42Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v43Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v44Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v45Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v46Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v47Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v48Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v49Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v50Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v51Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v52Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v53Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v54Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v55Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v56Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v57Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v58Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v59Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v60Ev,
};
extern VTBL_ENTRY _ZTI7S2402C2[];
extern  VTBL_ENTRY _ZTV7S2402C2[];
Class_Descriptor cd_S2402C2 = {  "S2402C2", // class name
  bases_S2402C2, 6,
  &(vtc_S2402C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(320,240), // object size
  NSPAIRA(_ZTI7S2402C2),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S2402C2),99, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2402C23_nt  {
  virtual  ~S2402C23_nt(); // _ZN11S2402C23_ntD1Ev
  virtual void  v93(); // _ZN11S2402C23_nt3v93Ev
  S2402C23_nt(); // tgen
};
//SIG(-1 S2402C23_nt) C1{ vd v1}


 S2402C23_nt ::~S2402C23_nt(){ note_dtor("S2402C23_nt", this);}
void  S2402C23_nt ::v93(){vfunc_called(this, "_ZN11S2402C23_nt3v93Ev");}
S2402C23_nt ::S2402C23_nt(){ note_ctor("S2402C23_nt", this);} // tgen

//skip512 S2402C23_nt

#else // __cplusplus

extern void _ZN11S2402C23_ntC1Ev();
extern void _ZN11S2402C23_ntD1Ev();
Name_Map name_map_S2402C23_nt[] = {
  NSPAIR(_ZN11S2402C23_ntC1Ev),
  NSPAIR(_ZN11S2402C23_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S2402C23_nt[];
extern void _ZN11S2402C23_ntD1Ev();
extern void _ZN11S2402C23_ntD0Ev();
extern void _ZN11S2402C23_nt3v93Ev();
static  VTBL_ENTRY vtc_S2402C23_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S2402C23_nt[0]),
  (VTBL_ENTRY)&_ZN11S2402C23_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S2402C23_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S2402C23_nt3v93Ev,
};
extern VTBL_ENTRY _ZTI11S2402C23_nt[];
VTBL_ENTRY *P__ZTI11S2402C23_nt = _ZTI11S2402C23_nt; 
extern  VTBL_ENTRY _ZTV11S2402C23_nt[];
Class_Descriptor cd_S2402C23_nt = {  "S2402C23_nt", // class name
  0,0,//no base classes
  &(vtc_S2402C23_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S2402C23_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S2402C23_nt),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2402C1  : S2402C2 , S2402C23_nt {
  int s2402c1f0;
  char s2402c1f1;
  virtual  ~S2402C1(); // _ZN7S2402C1D1Ev
  virtual void  v1(); // _ZN7S2402C12v1Ev
  virtual void  v2(); // _ZN7S2402C12v2Ev
  virtual void  v3(); // _ZN7S2402C12v3Ev
  virtual void  v4(); // _ZN7S2402C12v4Ev
  virtual void  v5(); // _ZN7S2402C12v5Ev
  S2402C1(); // tgen
};
//SIG(1 S2402C1) C1{ BC2{ BC3{ BC4{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 Fp FC5{ BC6{ m Fp Fi FC7{ m} FC8{ m}}} FC9{ m FC10{ FL[4]}} Fc} vd v18 v19 v20 v21 v22 v23 v24 FC11{ m Fp Fi[2] FC7}} BC12{ BC13{ BC14{ vd v25 v26 v27} vd v28 v29 v30 v31} vd v32 v33 v34 FC15{ m Fp Fi[2] FC8} FC16{ m FC10} Fc} BC17{ vd v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60} vd v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 FC18{ m Fp Fi FC7} Fc[2] Fi Fp[5] Fc[2] Fp FC19{ m Fp Fi[4] Fc Fi[3]} FL[2] Fi[2]} BC20{ vd v93} vd v1 v2 v3 v4 v5 Fi Fc}


 S2402C1 ::~S2402C1(){ note_dtor("S2402C1", this);}
void  S2402C1 ::v1(){vfunc_called(this, "_ZN7S2402C12v1Ev");}
void  S2402C1 ::v2(){vfunc_called(this, "_ZN7S2402C12v2Ev");}
void  S2402C1 ::v3(){vfunc_called(this, "_ZN7S2402C12v3Ev");}
void  S2402C1 ::v4(){vfunc_called(this, "_ZN7S2402C12v4Ev");}
void  S2402C1 ::v5(){vfunc_called(this, "_ZN7S2402C12v5Ev");}
S2402C1 ::S2402C1(){ note_ctor("S2402C1", this);} // tgen

static void Test_S2402C1()
{
  extern Class_Descriptor cd_S2402C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(43,64)];
    init_test(&cd_S2402C1, buf);
    S2402C1 *dp, &lv = *(dp=new (buf) S2402C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(336,252), "sizeof(S2402C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2402C1)");
    check_base_class_offset(lv, (S2402C4*)(S2402C3*)(S2402C2*), 0, "S2402C1");
    check_base_class_offset(lv, (S2402C3*)(S2402C2*), 0, "S2402C1");
    check_base_class_offset(lv, (S2402C15*)(S2402C14*)(S2402C13*)(S2402C2*), ABISELECT(96,72), "S2402C1");
    check_base_class_offset(lv, (S2402C14*)(S2402C13*)(S2402C2*), ABISELECT(96,72), "S2402C1");
    check_base_class_offset(lv, (S2402C13*)(S2402C2*), ABISELECT(96,72), "S2402C1");
    check_base_class_offset(lv, (S2402C19*)(S2402C2*), ABISELECT(168,128), "S2402C1");
    check_base_class_offset(lv, (S2402C2*), 0, "S2402C1");
    check_base_class_offset(lv, (S2402C23_nt*), ABISELECT(320,240), "S2402C1");
    check_field_offset(lv, s2402c1f0, ABISELECT(328,244), "S2402C1.s2402c1f0");
    check_field_offset(lv, s2402c1f1, ABISELECT(332,248), "S2402C1.s2402c1f1");
    test_class_info(&lv, &cd_S2402C1);
    dp->~S2402C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2402C1(Test_S2402C1, "S2402C1", ABISELECT(336,252));

#else // __cplusplus

extern void _ZN7S2402C1C1Ev();
extern void _ZN7S2402C1D1Ev();
Name_Map name_map_S2402C1[] = {
  NSPAIR(_ZN7S2402C1C1Ev),
  NSPAIR(_ZN7S2402C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2402C4;
extern VTBL_ENTRY _ZTI7S2402C4[];
extern  VTBL_ENTRY _ZTV7S2402C4[];
extern Class_Descriptor cd_S2402C3;
extern VTBL_ENTRY _ZTI7S2402C3[];
extern  VTBL_ENTRY _ZTV7S2402C3[];
extern Class_Descriptor cd_S2402C15;
extern VTBL_ENTRY _ZTI8S2402C15[];
extern  VTBL_ENTRY _ZTV8S2402C15[];
extern Class_Descriptor cd_S2402C14;
extern VTBL_ENTRY _ZTI8S2402C14[];
extern  VTBL_ENTRY _ZTV8S2402C14[];
extern Class_Descriptor cd_S2402C13;
extern VTBL_ENTRY _ZTI8S2402C13[];
extern  VTBL_ENTRY _ZTV8S2402C13[];
extern Class_Descriptor cd_S2402C19;
extern VTBL_ENTRY _ZTI8S2402C19[];
extern  VTBL_ENTRY _ZTV8S2402C19[];
extern Class_Descriptor cd_S2402C2;
extern VTBL_ENTRY _ZTI7S2402C2[];
extern  VTBL_ENTRY _ZTV7S2402C2[];
extern Class_Descriptor cd_S2402C23_nt;
extern VTBL_ENTRY _ZTI11S2402C23_nt[];
extern  VTBL_ENTRY _ZTV11S2402C23_nt[];
static Base_Class bases_S2402C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2402C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2402C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2402C15,    ABISELECT(96,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2402C14,    ABISELECT(96,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2402C13,    ABISELECT(96,72), //bcp->offset
    60, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2402C19,    ABISELECT(168,128), //bcp->offset
    74, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2402C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2402C23_nt,    ABISELECT(320,240), //bcp->offset
    104, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2402C1[];
extern void _ZN7S2402C1D1Ev();
extern void _ZN7S2402C1D0Ev();
extern void _ZN7S2402C42v6Ev();
extern void _ZN7S2402C42v7Ev();
extern void _ZN7S2402C42v8Ev();
extern void _ZN7S2402C42v9Ev();
extern void _ZN7S2402C43v10Ev();
extern void _ZN7S2402C43v11Ev();
extern void _ZN7S2402C43v12Ev();
extern void _ZN7S2402C43v13Ev();
extern void _ZN7S2402C43v14Ev();
extern void _ZN7S2402C43v15Ev();
extern void _ZN7S2402C43v16Ev();
extern void _ZN7S2402C43v17Ev();
extern void _ZN7S2402C33v18Ev();
extern void _ZN7S2402C33v19Ev();
extern void _ZN7S2402C33v20Ev();
extern void _ZN7S2402C33v21Ev();
extern void _ZN7S2402C33v22Ev();
extern void _ZN7S2402C33v23Ev();
extern void _ZN7S2402C33v24Ev();
extern void _ZN7S2402C23v61Ev();
extern void _ZN7S2402C23v62Ev();
extern void _ZN7S2402C23v63Ev();
extern void _ZN7S2402C23v64Ev();
extern void _ZN7S2402C23v65Ev();
extern void _ZN7S2402C23v66Ev();
extern void _ZN7S2402C23v67Ev();
extern void _ZN7S2402C23v68Ev();
extern void _ZN7S2402C23v69Ev();
extern void _ZN7S2402C23v70Ev();
extern void _ZN7S2402C23v71Ev();
extern void _ZN7S2402C23v72Ev();
extern void _ZN7S2402C23v73Ev();
extern void _ZN7S2402C23v74Ev();
extern void _ZN7S2402C23v75Ev();
extern void _ZN7S2402C23v76Ev();
extern void _ZN7S2402C23v77Ev();
extern void _ZN7S2402C23v78Ev();
extern void _ZN7S2402C23v79Ev();
extern void _ZN7S2402C23v80Ev();
extern void _ZN7S2402C23v81Ev();
extern void _ZN7S2402C23v82Ev();
extern void _ZN7S2402C23v83Ev();
extern void _ZN7S2402C23v84Ev();
extern void _ZN7S2402C23v85Ev();
extern void _ZN7S2402C23v86Ev();
extern void _ZN7S2402C23v87Ev();
extern void _ZN7S2402C23v88Ev();
extern void _ZN7S2402C23v89Ev();
extern void _ZN7S2402C23v90Ev();
extern void _ZN7S2402C23v91Ev();
extern void _ZN7S2402C23v92Ev();
extern void _ZN7S2402C12v1Ev();
extern void _ZN7S2402C12v2Ev();
extern void _ZN7S2402C12v3Ev();
extern void _ZN7S2402C12v4Ev();
extern void _ZN7S2402C12v5Ev();
extern void ABISELECT(_ZThn96_N7S2402C1D1Ev,_ZThn72_N7S2402C1D1Ev)();
extern void ABISELECT(_ZThn96_N7S2402C1D0Ev,_ZThn72_N7S2402C1D0Ev)();
extern void _ZN8S2402C153v25Ev();
extern void _ZN8S2402C153v26Ev();
extern void _ZN8S2402C153v27Ev();
extern void _ZN8S2402C143v28Ev();
extern void _ZN8S2402C143v29Ev();
extern void _ZN8S2402C143v30Ev();
extern void _ZN8S2402C143v31Ev();
extern void _ZN8S2402C133v32Ev();
extern void _ZN8S2402C133v33Ev();
extern void _ZN8S2402C133v34Ev();
extern void ABISELECT(_ZThn168_N7S2402C1D1Ev,_ZThn128_N7S2402C1D1Ev)();
extern void ABISELECT(_ZThn168_N7S2402C1D0Ev,_ZThn128_N7S2402C1D0Ev)();
extern void _ZN8S2402C193v35Ev();
extern void _ZN8S2402C193v36Ev();
extern void _ZN8S2402C193v37Ev();
extern void _ZN8S2402C193v38Ev();
extern void _ZN8S2402C193v39Ev();
extern void _ZN8S2402C193v40Ev();
extern void _ZN8S2402C193v41Ev();
extern void _ZN8S2402C193v42Ev();
extern void _ZN8S2402C193v43Ev();
extern void _ZN8S2402C193v44Ev();
extern void _ZN8S2402C193v45Ev();
extern void _ZN8S2402C193v46Ev();
extern void _ZN8S2402C193v47Ev();
extern void _ZN8S2402C193v48Ev();
extern void _ZN8S2402C193v49Ev();
extern void _ZN8S2402C193v50Ev();
extern void _ZN8S2402C193v51Ev();
extern void _ZN8S2402C193v52Ev();
extern void _ZN8S2402C193v53Ev();
extern void _ZN8S2402C193v54Ev();
extern void _ZN8S2402C193v55Ev();
extern void _ZN8S2402C193v56Ev();
extern void _ZN8S2402C193v57Ev();
extern void _ZN8S2402C193v58Ev();
extern void _ZN8S2402C193v59Ev();
extern void _ZN8S2402C193v60Ev();
extern void ABISELECT(_ZThn320_N7S2402C1D1Ev,_ZThn240_N7S2402C1D1Ev)();
extern void ABISELECT(_ZThn320_N7S2402C1D0Ev,_ZThn240_N7S2402C1D0Ev)();
extern void _ZN11S2402C23_nt3v93Ev();
static  VTBL_ENTRY vtc_S2402C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2402C1[0]),
  (VTBL_ENTRY)&_ZN7S2402C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2402C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2402C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2402C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2402C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2402C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v14Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v15Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2402C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2402C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2402C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2402C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2402C33v21Ev,
  (VTBL_ENTRY)&_ZN7S2402C33v22Ev,
  (VTBL_ENTRY)&_ZN7S2402C33v23Ev,
  (VTBL_ENTRY)&_ZN7S2402C33v24Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v61Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v62Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v63Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v64Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v65Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v66Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v67Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v68Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v69Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v70Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v71Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v72Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v73Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v74Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v75Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v76Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v77Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v78Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v79Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v80Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v81Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v82Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v83Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v84Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v85Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v86Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v87Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v88Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v89Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v90Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v91Ev,
  (VTBL_ENTRY)&_ZN7S2402C23v92Ev,
  (VTBL_ENTRY)&_ZN7S2402C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2402C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2402C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2402C12v4Ev,
  (VTBL_ENTRY)&_ZN7S2402C12v5Ev,
  ABISELECT(-96,-72),
  (VTBL_ENTRY)&(_ZTI7S2402C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N7S2402C1D1Ev,_ZThn72_N7S2402C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N7S2402C1D0Ev,_ZThn72_N7S2402C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2402C153v25Ev,
  (VTBL_ENTRY)&_ZN8S2402C153v26Ev,
  (VTBL_ENTRY)&_ZN8S2402C153v27Ev,
  (VTBL_ENTRY)&_ZN8S2402C143v28Ev,
  (VTBL_ENTRY)&_ZN8S2402C143v29Ev,
  (VTBL_ENTRY)&_ZN8S2402C143v30Ev,
  (VTBL_ENTRY)&_ZN8S2402C143v31Ev,
  (VTBL_ENTRY)&_ZN8S2402C133v32Ev,
  (VTBL_ENTRY)&_ZN8S2402C133v33Ev,
  (VTBL_ENTRY)&_ZN8S2402C133v34Ev,
  ABISELECT(-168,-128),
  (VTBL_ENTRY)&(_ZTI7S2402C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N7S2402C1D1Ev,_ZThn128_N7S2402C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N7S2402C1D0Ev,_ZThn128_N7S2402C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2402C193v35Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v36Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v37Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v38Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v39Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v40Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v41Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v42Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v43Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v44Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v45Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v46Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v47Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v48Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v49Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v50Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v51Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v52Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v53Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v54Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v55Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v56Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v57Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v58Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v59Ev,
  (VTBL_ENTRY)&_ZN8S2402C193v60Ev,
  ABISELECT(-320,-240),
  (VTBL_ENTRY)&(_ZTI7S2402C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn320_N7S2402C1D1Ev,_ZThn240_N7S2402C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn320_N7S2402C1D0Ev,_ZThn240_N7S2402C1D0Ev),
  (VTBL_ENTRY)&_ZN11S2402C23_nt3v93Ev,
};
extern VTBL_ENTRY _ZTI7S2402C1[];
extern  VTBL_ENTRY _ZTV7S2402C1[];
Class_Descriptor cd_S2402C1 = {  "S2402C1", // class name
  bases_S2402C1, 8,
  &(vtc_S2402C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(336,252), // object size
  NSPAIRA(_ZTI7S2402C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2402C1),109, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  8, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2401C4  {
  void *s2401c4f0;
  ::S886C6_nt s2401c4f1;
  ::S886C10_nt s2401c4f2;
  char s2401c4f3;
  virtual  ~S2401C4(); // _ZN7S2401C4D1Ev
  virtual void  v6(); // _ZN7S2401C42v6Ev
  virtual void  v7(); // _ZN7S2401C42v7Ev
  virtual void  v8(); // _ZN7S2401C42v8Ev
  virtual void  v9(); // _ZN7S2401C42v9Ev
  virtual void  v10(); // _ZN7S2401C43v10Ev
  virtual void  v11(); // _ZN7S2401C43v11Ev
  virtual void  v12(); // _ZN7S2401C43v12Ev
  virtual void  v13(); // _ZN7S2401C43v13Ev
  virtual void  v14(); // _ZN7S2401C43v14Ev
  virtual void  v15(); // _ZN7S2401C43v15Ev
  virtual void  v16(); // _ZN7S2401C43v16Ev
  virtual void  v17(); // _ZN7S2401C43v17Ev
  S2401C4(); // tgen
};
//SIG(-1 S2401C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fp FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}} FC6{ m FC7{ Fl[4]}} Fc}


 S2401C4 ::~S2401C4(){ note_dtor("S2401C4", this);}
void  S2401C4 ::v6(){vfunc_called(this, "_ZN7S2401C42v6Ev");}
void  S2401C4 ::v7(){vfunc_called(this, "_ZN7S2401C42v7Ev");}
void  S2401C4 ::v8(){vfunc_called(this, "_ZN7S2401C42v8Ev");}
void  S2401C4 ::v9(){vfunc_called(this, "_ZN7S2401C42v9Ev");}
void  S2401C4 ::v10(){vfunc_called(this, "_ZN7S2401C43v10Ev");}
void  S2401C4 ::v11(){vfunc_called(this, "_ZN7S2401C43v11Ev");}
void  S2401C4 ::v12(){vfunc_called(this, "_ZN7S2401C43v12Ev");}
void  S2401C4 ::v13(){vfunc_called(this, "_ZN7S2401C43v13Ev");}
void  S2401C4 ::v14(){vfunc_called(this, "_ZN7S2401C43v14Ev");}
void  S2401C4 ::v15(){vfunc_called(this, "_ZN7S2401C43v15Ev");}
void  S2401C4 ::v16(){vfunc_called(this, "_ZN7S2401C43v16Ev");}
void  S2401C4 ::v17(){vfunc_called(this, "_ZN7S2401C43v17Ev");}
S2401C4 ::S2401C4(){ note_ctor("S2401C4", this);} // tgen

static void Test_S2401C4()
{
  extern Class_Descriptor cd_S2401C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,11)];
    init_test(&cd_S2401C4, buf);
    S2401C4 *dp, &lv = *(dp=new (buf) S2401C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,40), "sizeof(S2401C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2401C4)");
    check_field_offset(lv, s2401c4f0, ABISELECT(8,4), "S2401C4.s2401c4f0");
    check_field_offset(lv, s2401c4f1, ABISELECT(16,8), "S2401C4.s2401c4f1");
    check_field_offset(lv, s2401c4f2, ABISELECT(32,20), "S2401C4.s2401c4f2");
    check_field_offset(lv, s2401c4f3, ABISELECT(64,36), "S2401C4.s2401c4f3");
    test_class_info(&lv, &cd_S2401C4);
    dp->~S2401C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2401C4(Test_S2401C4, "S2401C4", ABISELECT(72,40));

#else // __cplusplus

extern void _ZN7S2401C4C1Ev();
extern void _ZN7S2401C4D1Ev();
Name_Map name_map_S2401C4[] = {
  NSPAIR(_ZN7S2401C4C1Ev),
  NSPAIR(_ZN7S2401C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2401C4[];
extern void _ZN7S2401C4D1Ev();
extern void _ZN7S2401C4D0Ev();
extern void _ZN7S2401C42v6Ev();
extern void _ZN7S2401C42v7Ev();
extern void _ZN7S2401C42v8Ev();
extern void _ZN7S2401C42v9Ev();
extern void _ZN7S2401C43v10Ev();
extern void _ZN7S2401C43v11Ev();
extern void _ZN7S2401C43v12Ev();
extern void _ZN7S2401C43v13Ev();
extern void _ZN7S2401C43v14Ev();
extern void _ZN7S2401C43v15Ev();
extern void _ZN7S2401C43v16Ev();
extern void _ZN7S2401C43v17Ev();
static  VTBL_ENTRY vtc_S2401C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2401C4[0]),
  (VTBL_ENTRY)&_ZN7S2401C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2401C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2401C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2401C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2401C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2401C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v14Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v15Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v17Ev,
};
extern VTBL_ENTRY _ZTI7S2401C4[];
extern  VTBL_ENTRY _ZTV7S2401C4[];
Class_Descriptor cd_S2401C4 = {  "S2401C4", // class name
  0,0,//no base classes
  &(vtc_S2401C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI7S2401C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2401C4),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2401C3  : S2401C4 {
  ::S887C17 s2401c3f0;
  virtual  ~S2401C3(); // _ZN7S2401C3D1Ev
  virtual void  v18(); // _ZN7S2401C33v18Ev
  virtual void  v19(); // _ZN7S2401C33v19Ev
  virtual void  v20(); // _ZN7S2401C33v20Ev
  virtual void  v21(); // _ZN7S2401C33v21Ev
  virtual void  v22(); // _ZN7S2401C33v22Ev
  virtual void  v23(); // _ZN7S2401C33v23Ev
  virtual void  v24(); // _ZN7S2401C33v24Ev
  S2401C3(); // tgen
};
//SIG(-1 S2401C3) C1{ BC2{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 Fp FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}} FC7{ m FC8{ Fl[4]}} Fc} vd v1 v2 v3 v4 v5 v6 v7 FC9{ m Fp Fi[2] FC5}}


 S2401C3 ::~S2401C3(){ note_dtor("S2401C3", this);}
void  S2401C3 ::v18(){vfunc_called(this, "_ZN7S2401C33v18Ev");}
void  S2401C3 ::v19(){vfunc_called(this, "_ZN7S2401C33v19Ev");}
void  S2401C3 ::v20(){vfunc_called(this, "_ZN7S2401C33v20Ev");}
void  S2401C3 ::v21(){vfunc_called(this, "_ZN7S2401C33v21Ev");}
void  S2401C3 ::v22(){vfunc_called(this, "_ZN7S2401C33v22Ev");}
void  S2401C3 ::v23(){vfunc_called(this, "_ZN7S2401C33v23Ev");}
void  S2401C3 ::v24(){vfunc_called(this, "_ZN7S2401C33v24Ev");}
S2401C3 ::S2401C3(){ note_ctor("S2401C3", this);} // tgen

static void Test_S2401C3()
{
  extern Class_Descriptor cd_S2401C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,15)];
    init_test(&cd_S2401C3, buf);
    S2401C3 *dp, &lv = *(dp=new (buf) S2401C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,56), "sizeof(S2401C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2401C3)");
    check_base_class_offset(lv, (S2401C4*), 0, "S2401C3");
    check_field_offset(lv, s2401c3f0, ABISELECT(72,40), "S2401C3.s2401c3f0");
    test_class_info(&lv, &cd_S2401C3);
    dp->~S2401C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2401C3(Test_S2401C3, "S2401C3", ABISELECT(96,56));

#else // __cplusplus

extern void _ZN7S2401C3C1Ev();
extern void _ZN7S2401C3D1Ev();
Name_Map name_map_S2401C3[] = {
  NSPAIR(_ZN7S2401C3C1Ev),
  NSPAIR(_ZN7S2401C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2401C4;
extern VTBL_ENTRY _ZTI7S2401C4[];
extern  VTBL_ENTRY _ZTV7S2401C4[];
static Base_Class bases_S2401C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2401C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2401C3[];
extern void _ZN7S2401C3D1Ev();
extern void _ZN7S2401C3D0Ev();
extern void _ZN7S2401C42v6Ev();
extern void _ZN7S2401C42v7Ev();
extern void _ZN7S2401C42v8Ev();
extern void _ZN7S2401C42v9Ev();
extern void _ZN7S2401C43v10Ev();
extern void _ZN7S2401C43v11Ev();
extern void _ZN7S2401C43v12Ev();
extern void _ZN7S2401C43v13Ev();
extern void _ZN7S2401C43v14Ev();
extern void _ZN7S2401C43v15Ev();
extern void _ZN7S2401C43v16Ev();
extern void _ZN7S2401C43v17Ev();
extern void _ZN7S2401C33v18Ev();
extern void _ZN7S2401C33v19Ev();
extern void _ZN7S2401C33v20Ev();
extern void _ZN7S2401C33v21Ev();
extern void _ZN7S2401C33v22Ev();
extern void _ZN7S2401C33v23Ev();
extern void _ZN7S2401C33v24Ev();
static  VTBL_ENTRY vtc_S2401C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2401C3[0]),
  (VTBL_ENTRY)&_ZN7S2401C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2401C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2401C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2401C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2401C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2401C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v14Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v15Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2401C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2401C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2401C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2401C33v21Ev,
  (VTBL_ENTRY)&_ZN7S2401C33v22Ev,
  (VTBL_ENTRY)&_ZN7S2401C33v23Ev,
  (VTBL_ENTRY)&_ZN7S2401C33v24Ev,
};
extern VTBL_ENTRY _ZTI7S2401C3[];
extern  VTBL_ENTRY _ZTV7S2401C3[];
Class_Descriptor cd_S2401C3 = {  "S2401C3", // class name
  bases_S2401C3, 1,
  &(vtc_S2401C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,56), // object size
  NSPAIRA(_ZTI7S2401C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2401C3),23, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2401C15  {
  virtual  ~S2401C15(); // _ZN8S2401C15D1Ev
  virtual void  v25(); // _ZN8S2401C153v25Ev
  virtual void  v26(); // _ZN8S2401C153v26Ev
  virtual void  v27(); // _ZN8S2401C153v27Ev
  S2401C15(); // tgen
};
//SIG(-1 S2401C15) C1{ vd v1 v2 v3}


 S2401C15 ::~S2401C15(){ note_dtor("S2401C15", this);}
void  S2401C15 ::v25(){vfunc_called(this, "_ZN8S2401C153v25Ev");}
void  S2401C15 ::v26(){vfunc_called(this, "_ZN8S2401C153v26Ev");}
void  S2401C15 ::v27(){vfunc_called(this, "_ZN8S2401C153v27Ev");}
S2401C15 ::S2401C15(){ note_ctor("S2401C15", this);} // tgen

static void Test_S2401C15()
{
  extern Class_Descriptor cd_S2401C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2401C15, buf);
    S2401C15 *dp, &lv = *(dp=new (buf) S2401C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2401C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2401C15)");
    test_class_info(&lv, &cd_S2401C15);
    dp->~S2401C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2401C15(Test_S2401C15, "S2401C15", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2401C15C1Ev();
extern void _ZN8S2401C15D1Ev();
Name_Map name_map_S2401C15[] = {
  NSPAIR(_ZN8S2401C15C1Ev),
  NSPAIR(_ZN8S2401C15D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2401C15[];
extern void _ZN8S2401C15D1Ev();
extern void _ZN8S2401C15D0Ev();
extern void _ZN8S2401C153v25Ev();
extern void _ZN8S2401C153v26Ev();
extern void _ZN8S2401C153v27Ev();
static  VTBL_ENTRY vtc_S2401C15[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2401C15[0]),
  (VTBL_ENTRY)&_ZN8S2401C15D1Ev,
  (VTBL_ENTRY)&_ZN8S2401C15D0Ev,
  (VTBL_ENTRY)&_ZN8S2401C153v25Ev,
  (VTBL_ENTRY)&_ZN8S2401C153v26Ev,
  (VTBL_ENTRY)&_ZN8S2401C153v27Ev,
};
extern VTBL_ENTRY _ZTI8S2401C15[];
extern  VTBL_ENTRY _ZTV8S2401C15[];
Class_Descriptor cd_S2401C15 = {  "S2401C15", // class name
  0,0,//no base classes
  &(vtc_S2401C15[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2401C15),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2401C15),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2401C14  : S2401C15 {
  virtual  ~S2401C14(); // _ZN8S2401C14D1Ev
  virtual void  v28(); // _ZN8S2401C143v28Ev
  virtual void  v29(); // _ZN8S2401C143v29Ev
  virtual void  v30(); // _ZN8S2401C143v30Ev
  virtual void  v31(); // _ZN8S2401C143v31Ev
  S2401C14(); // tgen
};
//SIG(-1 S2401C14) C1{ BC2{ vd v5 v6 v7} vd v1 v2 v3 v4}


 S2401C14 ::~S2401C14(){ note_dtor("S2401C14", this);}
void  S2401C14 ::v28(){vfunc_called(this, "_ZN8S2401C143v28Ev");}
void  S2401C14 ::v29(){vfunc_called(this, "_ZN8S2401C143v29Ev");}
void  S2401C14 ::v30(){vfunc_called(this, "_ZN8S2401C143v30Ev");}
void  S2401C14 ::v31(){vfunc_called(this, "_ZN8S2401C143v31Ev");}
S2401C14 ::S2401C14(){ note_ctor("S2401C14", this);} // tgen

static void Test_S2401C14()
{
  extern Class_Descriptor cd_S2401C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2401C14, buf);
    S2401C14 *dp, &lv = *(dp=new (buf) S2401C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2401C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2401C14)");
    check_base_class_offset(lv, (S2401C15*), 0, "S2401C14");
    test_class_info(&lv, &cd_S2401C14);
    dp->~S2401C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2401C14(Test_S2401C14, "S2401C14", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2401C14C1Ev();
extern void _ZN8S2401C14D1Ev();
Name_Map name_map_S2401C14[] = {
  NSPAIR(_ZN8S2401C14C1Ev),
  NSPAIR(_ZN8S2401C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2401C15;
extern VTBL_ENTRY _ZTI8S2401C15[];
extern  VTBL_ENTRY _ZTV8S2401C15[];
static Base_Class bases_S2401C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2401C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S2401C14[];
extern void _ZN8S2401C14D1Ev();
extern void _ZN8S2401C14D0Ev();
extern void _ZN8S2401C153v25Ev();
extern void _ZN8S2401C153v26Ev();
extern void _ZN8S2401C153v27Ev();
extern void _ZN8S2401C143v28Ev();
extern void _ZN8S2401C143v29Ev();
extern void _ZN8S2401C143v30Ev();
extern void _ZN8S2401C143v31Ev();
static  VTBL_ENTRY vtc_S2401C14[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2401C14[0]),
  (VTBL_ENTRY)&_ZN8S2401C14D1Ev,
  (VTBL_ENTRY)&_ZN8S2401C14D0Ev,
  (VTBL_ENTRY)&_ZN8S2401C153v25Ev,
  (VTBL_ENTRY)&_ZN8S2401C153v26Ev,
  (VTBL_ENTRY)&_ZN8S2401C153v27Ev,
  (VTBL_ENTRY)&_ZN8S2401C143v28Ev,
  (VTBL_ENTRY)&_ZN8S2401C143v29Ev,
  (VTBL_ENTRY)&_ZN8S2401C143v30Ev,
  (VTBL_ENTRY)&_ZN8S2401C143v31Ev,
};
extern VTBL_ENTRY _ZTI8S2401C14[];
extern  VTBL_ENTRY _ZTV8S2401C14[];
Class_Descriptor cd_S2401C14 = {  "S2401C14", // class name
  bases_S2401C14, 1,
  &(vtc_S2401C14[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2401C14),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S2401C14),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2401C18_nt  {
  ::S886C11_nt s2401c18f0;
  void  mf2401c18(); // _ZN11S2401C18_nt9mf2401c18Ev
};
//SIG(-1 S2401C18_nt) C1{ m FC2{ Fl[4]}}


void  S2401C18_nt ::mf2401c18(){}

//skip512 S2401C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2401C13  : S2401C14 {
  ::S886C12_nt s2401c13f0;
  ::S2401C18_nt s2401c13f1;
  char s2401c13f2;
  virtual  ~S2401C13(); // _ZN8S2401C13D1Ev
  virtual void  v32(); // _ZN8S2401C133v32Ev
  virtual void  v33(); // _ZN8S2401C133v33Ev
  virtual void  v34(); // _ZN8S2401C133v34Ev
  S2401C13(); // tgen
};
//SIG(-1 S2401C13) C1{ BC2{ BC3{ vd v4 v5 v6} vd v7 v8 v9 v10} vd v1 v2 v3 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ Fl[4]}} Fc}


 S2401C13 ::~S2401C13(){ note_dtor("S2401C13", this);}
void  S2401C13 ::v32(){vfunc_called(this, "_ZN8S2401C133v32Ev");}
void  S2401C13 ::v33(){vfunc_called(this, "_ZN8S2401C133v33Ev");}
void  S2401C13 ::v34(){vfunc_called(this, "_ZN8S2401C133v34Ev");}
S2401C13 ::S2401C13(){ note_ctor("S2401C13", this);} // tgen

static void Test_S2401C13()
{
  extern Class_Descriptor cd_S2401C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,11)];
    init_test(&cd_S2401C13, buf);
    S2401C13 *dp, &lv = *(dp=new (buf) S2401C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,40), "sizeof(S2401C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2401C13)");
    check_base_class_offset(lv, (S2401C15*)(S2401C14*), 0, "S2401C13");
    check_base_class_offset(lv, (S2401C14*), 0, "S2401C13");
    check_field_offset(lv, s2401c13f0, ABISELECT(8,4), "S2401C13.s2401c13f0");
    check_field_offset(lv, s2401c13f1, ABISELECT(32,20), "S2401C13.s2401c13f1");
    check_field_offset(lv, s2401c13f2, ABISELECT(64,36), "S2401C13.s2401c13f2");
    test_class_info(&lv, &cd_S2401C13);
    dp->~S2401C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2401C13(Test_S2401C13, "S2401C13", ABISELECT(72,40));

#else // __cplusplus

extern void _ZN8S2401C13C1Ev();
extern void _ZN8S2401C13D1Ev();
Name_Map name_map_S2401C13[] = {
  NSPAIR(_ZN8S2401C13C1Ev),
  NSPAIR(_ZN8S2401C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2401C15;
extern VTBL_ENTRY _ZTI8S2401C15[];
extern  VTBL_ENTRY _ZTV8S2401C15[];
extern Class_Descriptor cd_S2401C14;
extern VTBL_ENTRY _ZTI8S2401C14[];
extern  VTBL_ENTRY _ZTV8S2401C14[];
static Base_Class bases_S2401C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2401C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2401C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S2401C13[];
extern void _ZN8S2401C13D1Ev();
extern void _ZN8S2401C13D0Ev();
extern void _ZN8S2401C153v25Ev();
extern void _ZN8S2401C153v26Ev();
extern void _ZN8S2401C153v27Ev();
extern void _ZN8S2401C143v28Ev();
extern void _ZN8S2401C143v29Ev();
extern void _ZN8S2401C143v30Ev();
extern void _ZN8S2401C143v31Ev();
extern void _ZN8S2401C133v32Ev();
extern void _ZN8S2401C133v33Ev();
extern void _ZN8S2401C133v34Ev();
static  VTBL_ENTRY vtc_S2401C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2401C13[0]),
  (VTBL_ENTRY)&_ZN8S2401C13D1Ev,
  (VTBL_ENTRY)&_ZN8S2401C13D0Ev,
  (VTBL_ENTRY)&_ZN8S2401C153v25Ev,
  (VTBL_ENTRY)&_ZN8S2401C153v26Ev,
  (VTBL_ENTRY)&_ZN8S2401C153v27Ev,
  (VTBL_ENTRY)&_ZN8S2401C143v28Ev,
  (VTBL_ENTRY)&_ZN8S2401C143v29Ev,
  (VTBL_ENTRY)&_ZN8S2401C143v30Ev,
  (VTBL_ENTRY)&_ZN8S2401C143v31Ev,
  (VTBL_ENTRY)&_ZN8S2401C133v32Ev,
  (VTBL_ENTRY)&_ZN8S2401C133v33Ev,
  (VTBL_ENTRY)&_ZN8S2401C133v34Ev,
};
extern VTBL_ENTRY _ZTI8S2401C13[];
extern  VTBL_ENTRY _ZTV8S2401C13[];
Class_Descriptor cd_S2401C13 = {  "S2401C13", // class name
  bases_S2401C13, 2,
  &(vtc_S2401C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI8S2401C13),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S2401C13),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2401C19  {
  virtual  ~S2401C19(); // _ZN8S2401C19D1Ev
  virtual void  v35(); // _ZN8S2401C193v35Ev
  virtual void  v36(); // _ZN8S2401C193v36Ev
  virtual void  v37(); // _ZN8S2401C193v37Ev
  virtual void  v38(); // _ZN8S2401C193v38Ev
  virtual void  v39(); // _ZN8S2401C193v39Ev
  virtual void  v40(); // _ZN8S2401C193v40Ev
  virtual void  v41(); // _ZN8S2401C193v41Ev
  virtual void  v42(); // _ZN8S2401C193v42Ev
  virtual void  v43(); // _ZN8S2401C193v43Ev
  virtual void  v44(); // _ZN8S2401C193v44Ev
  virtual void  v45(); // _ZN8S2401C193v45Ev
  virtual void  v46(); // _ZN8S2401C193v46Ev
  virtual void  v47(); // _ZN8S2401C193v47Ev
  virtual void  v48(); // _ZN8S2401C193v48Ev
  virtual void  v49(); // _ZN8S2401C193v49Ev
  virtual void  v50(); // _ZN8S2401C193v50Ev
  virtual void  v51(); // _ZN8S2401C193v51Ev
  virtual void  v52(); // _ZN8S2401C193v52Ev
  virtual void  v53(); // _ZN8S2401C193v53Ev
  virtual void  v54(); // _ZN8S2401C193v54Ev
  virtual void  v55(); // _ZN8S2401C193v55Ev
  virtual void  v56(); // _ZN8S2401C193v56Ev
  virtual void  v57(); // _ZN8S2401C193v57Ev
  virtual void  v58(); // _ZN8S2401C193v58Ev
  virtual void  v59(); // _ZN8S2401C193v59Ev
  virtual void  v60(); // _ZN8S2401C193v60Ev
  S2401C19(); // tgen
};
//SIG(-1 S2401C19) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26}


 S2401C19 ::~S2401C19(){ note_dtor("S2401C19", this);}
void  S2401C19 ::v35(){vfunc_called(this, "_ZN8S2401C193v35Ev");}
void  S2401C19 ::v36(){vfunc_called(this, "_ZN8S2401C193v36Ev");}
void  S2401C19 ::v37(){vfunc_called(this, "_ZN8S2401C193v37Ev");}
void  S2401C19 ::v38(){vfunc_called(this, "_ZN8S2401C193v38Ev");}
void  S2401C19 ::v39(){vfunc_called(this, "_ZN8S2401C193v39Ev");}
void  S2401C19 ::v40(){vfunc_called(this, "_ZN8S2401C193v40Ev");}
void  S2401C19 ::v41(){vfunc_called(this, "_ZN8S2401C193v41Ev");}
void  S2401C19 ::v42(){vfunc_called(this, "_ZN8S2401C193v42Ev");}
void  S2401C19 ::v43(){vfunc_called(this, "_ZN8S2401C193v43Ev");}
void  S2401C19 ::v44(){vfunc_called(this, "_ZN8S2401C193v44Ev");}
void  S2401C19 ::v45(){vfunc_called(this, "_ZN8S2401C193v45Ev");}
void  S2401C19 ::v46(){vfunc_called(this, "_ZN8S2401C193v46Ev");}
void  S2401C19 ::v47(){vfunc_called(this, "_ZN8S2401C193v47Ev");}
void  S2401C19 ::v48(){vfunc_called(this, "_ZN8S2401C193v48Ev");}
void  S2401C19 ::v49(){vfunc_called(this, "_ZN8S2401C193v49Ev");}
void  S2401C19 ::v50(){vfunc_called(this, "_ZN8S2401C193v50Ev");}
void  S2401C19 ::v51(){vfunc_called(this, "_ZN8S2401C193v51Ev");}
void  S2401C19 ::v52(){vfunc_called(this, "_ZN8S2401C193v52Ev");}
void  S2401C19 ::v53(){vfunc_called(this, "_ZN8S2401C193v53Ev");}
void  S2401C19 ::v54(){vfunc_called(this, "_ZN8S2401C193v54Ev");}
void  S2401C19 ::v55(){vfunc_called(this, "_ZN8S2401C193v55Ev");}
void  S2401C19 ::v56(){vfunc_called(this, "_ZN8S2401C193v56Ev");}
void  S2401C19 ::v57(){vfunc_called(this, "_ZN8S2401C193v57Ev");}
void  S2401C19 ::v58(){vfunc_called(this, "_ZN8S2401C193v58Ev");}
void  S2401C19 ::v59(){vfunc_called(this, "_ZN8S2401C193v59Ev");}
void  S2401C19 ::v60(){vfunc_called(this, "_ZN8S2401C193v60Ev");}
S2401C19 ::S2401C19(){ note_ctor("S2401C19", this);} // tgen

static void Test_S2401C19()
{
  extern Class_Descriptor cd_S2401C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2401C19, buf);
    S2401C19 *dp, &lv = *(dp=new (buf) S2401C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2401C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2401C19)");
    test_class_info(&lv, &cd_S2401C19);
    dp->~S2401C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2401C19(Test_S2401C19, "S2401C19", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2401C19C1Ev();
extern void _ZN8S2401C19D1Ev();
Name_Map name_map_S2401C19[] = {
  NSPAIR(_ZN8S2401C19C1Ev),
  NSPAIR(_ZN8S2401C19D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2401C19[];
extern void _ZN8S2401C19D1Ev();
extern void _ZN8S2401C19D0Ev();
extern void _ZN8S2401C193v35Ev();
extern void _ZN8S2401C193v36Ev();
extern void _ZN8S2401C193v37Ev();
extern void _ZN8S2401C193v38Ev();
extern void _ZN8S2401C193v39Ev();
extern void _ZN8S2401C193v40Ev();
extern void _ZN8S2401C193v41Ev();
extern void _ZN8S2401C193v42Ev();
extern void _ZN8S2401C193v43Ev();
extern void _ZN8S2401C193v44Ev();
extern void _ZN8S2401C193v45Ev();
extern void _ZN8S2401C193v46Ev();
extern void _ZN8S2401C193v47Ev();
extern void _ZN8S2401C193v48Ev();
extern void _ZN8S2401C193v49Ev();
extern void _ZN8S2401C193v50Ev();
extern void _ZN8S2401C193v51Ev();
extern void _ZN8S2401C193v52Ev();
extern void _ZN8S2401C193v53Ev();
extern void _ZN8S2401C193v54Ev();
extern void _ZN8S2401C193v55Ev();
extern void _ZN8S2401C193v56Ev();
extern void _ZN8S2401C193v57Ev();
extern void _ZN8S2401C193v58Ev();
extern void _ZN8S2401C193v59Ev();
extern void _ZN8S2401C193v60Ev();
static  VTBL_ENTRY vtc_S2401C19[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2401C19[0]),
  (VTBL_ENTRY)&_ZN8S2401C19D1Ev,
  (VTBL_ENTRY)&_ZN8S2401C19D0Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v35Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v36Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v37Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v38Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v39Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v40Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v41Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v42Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v43Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v44Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v45Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v46Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v47Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v48Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v49Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v50Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v51Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v52Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v53Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v54Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v55Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v56Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v57Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v58Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v59Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v60Ev,
};
extern VTBL_ENTRY _ZTI8S2401C19[];
extern  VTBL_ENTRY _ZTV8S2401C19[];
Class_Descriptor cd_S2401C19 = {  "S2401C19", // class name
  0,0,//no base classes
  &(vtc_S2401C19[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2401C19),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2401C19),30, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2401C2  : S2401C3 , S2401C13 , S2401C19 {
  ::S1587C6_nt s2401c2f0;
  char s2401c2f1[2];
  int s2401c2f2;
  void *s2401c2f3[5];
  char s2401c2f4[2];
  void *s2401c2f5;
  ::S886C23 s2401c2f6;
  __tsi64 s2401c2f7[2];
  int s2401c2f8[2];
  virtual  ~S2401C2(); // _ZN7S2401C2D1Ev
  virtual void  v61(); // _ZN7S2401C23v61Ev
  virtual void  v62(); // _ZN7S2401C23v62Ev
  virtual void  v63(); // _ZN7S2401C23v63Ev
  virtual void  v64(); // _ZN7S2401C23v64Ev
  virtual void  v65(); // _ZN7S2401C23v65Ev
  virtual void  v66(); // _ZN7S2401C23v66Ev
  virtual void  v67(); // _ZN7S2401C23v67Ev
  virtual void  v68(); // _ZN7S2401C23v68Ev
  virtual void  v69(); // _ZN7S2401C23v69Ev
  virtual void  v70(); // _ZN7S2401C23v70Ev
  virtual void  v71(); // _ZN7S2401C23v71Ev
  virtual void  v72(); // _ZN7S2401C23v72Ev
  virtual void  v73(); // _ZN7S2401C23v73Ev
  virtual void  v74(); // _ZN7S2401C23v74Ev
  virtual void  v75(); // _ZN7S2401C23v75Ev
  virtual void  v76(); // _ZN7S2401C23v76Ev
  virtual void  v77(); // _ZN7S2401C23v77Ev
  virtual void  v78(); // _ZN7S2401C23v78Ev
  virtual void  v79(); // _ZN7S2401C23v79Ev
  virtual void  v80(); // _ZN7S2401C23v80Ev
  virtual void  v81(); // _ZN7S2401C23v81Ev
  virtual void  v82(); // _ZN7S2401C23v82Ev
  virtual void  v83(); // _ZN7S2401C23v83Ev
  virtual void  v84(); // _ZN7S2401C23v84Ev
  virtual void  v85(); // _ZN7S2401C23v85Ev
  virtual void  v86(); // _ZN7S2401C23v86Ev
  virtual void  v87(); // _ZN7S2401C23v87Ev
  virtual void  v88(); // _ZN7S2401C23v88Ev
  virtual void  v89(); // _ZN7S2401C23v89Ev
  virtual void  v90(); // _ZN7S2401C23v90Ev
  virtual void  v91(); // _ZN7S2401C23v91Ev
  virtual void  v92(); // _ZN7S2401C23v92Ev
  S2401C2(); // tgen
};
//SIG(-1 S2401C2) C1{ BC2{ BC3{ vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 Fp FC4{ BC5{ m Fp Fi FC6{ m} FC7{ m}}} FC8{ m FC9{ Fl[4]}} Fc} vd v45 v46 v47 v48 v49 v50 v51 FC10{ m Fp Fi[2] FC6}} BC11{ BC12{ BC13{ vd v52 v53 v54} vd v55 v56 v57 v58} vd v59 v60 v61 FC14{ m Fp Fi[2] FC7} FC15{ m FC9} Fc} BC16{ vd v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 FC17{ m Fp Fi FC6} Fc[2] Fi Fp[5] Fc[2] Fp FC18{ m Fp Fi[4] Fc Fi[3]} FL[2] Fi[2]}


 S2401C2 ::~S2401C2(){ note_dtor("S2401C2", this);}
void  S2401C2 ::v61(){vfunc_called(this, "_ZN7S2401C23v61Ev");}
void  S2401C2 ::v62(){vfunc_called(this, "_ZN7S2401C23v62Ev");}
void  S2401C2 ::v63(){vfunc_called(this, "_ZN7S2401C23v63Ev");}
void  S2401C2 ::v64(){vfunc_called(this, "_ZN7S2401C23v64Ev");}
void  S2401C2 ::v65(){vfunc_called(this, "_ZN7S2401C23v65Ev");}
void  S2401C2 ::v66(){vfunc_called(this, "_ZN7S2401C23v66Ev");}
void  S2401C2 ::v67(){vfunc_called(this, "_ZN7S2401C23v67Ev");}
void  S2401C2 ::v68(){vfunc_called(this, "_ZN7S2401C23v68Ev");}
void  S2401C2 ::v69(){vfunc_called(this, "_ZN7S2401C23v69Ev");}
void  S2401C2 ::v70(){vfunc_called(this, "_ZN7S2401C23v70Ev");}
void  S2401C2 ::v71(){vfunc_called(this, "_ZN7S2401C23v71Ev");}
void  S2401C2 ::v72(){vfunc_called(this, "_ZN7S2401C23v72Ev");}
void  S2401C2 ::v73(){vfunc_called(this, "_ZN7S2401C23v73Ev");}
void  S2401C2 ::v74(){vfunc_called(this, "_ZN7S2401C23v74Ev");}
void  S2401C2 ::v75(){vfunc_called(this, "_ZN7S2401C23v75Ev");}
void  S2401C2 ::v76(){vfunc_called(this, "_ZN7S2401C23v76Ev");}
void  S2401C2 ::v77(){vfunc_called(this, "_ZN7S2401C23v77Ev");}
void  S2401C2 ::v78(){vfunc_called(this, "_ZN7S2401C23v78Ev");}
void  S2401C2 ::v79(){vfunc_called(this, "_ZN7S2401C23v79Ev");}
void  S2401C2 ::v80(){vfunc_called(this, "_ZN7S2401C23v80Ev");}
void  S2401C2 ::v81(){vfunc_called(this, "_ZN7S2401C23v81Ev");}
void  S2401C2 ::v82(){vfunc_called(this, "_ZN7S2401C23v82Ev");}
void  S2401C2 ::v83(){vfunc_called(this, "_ZN7S2401C23v83Ev");}
void  S2401C2 ::v84(){vfunc_called(this, "_ZN7S2401C23v84Ev");}
void  S2401C2 ::v85(){vfunc_called(this, "_ZN7S2401C23v85Ev");}
void  S2401C2 ::v86(){vfunc_called(this, "_ZN7S2401C23v86Ev");}
void  S2401C2 ::v87(){vfunc_called(this, "_ZN7S2401C23v87Ev");}
void  S2401C2 ::v88(){vfunc_called(this, "_ZN7S2401C23v88Ev");}
void  S2401C2 ::v89(){vfunc_called(this, "_ZN7S2401C23v89Ev");}
void  S2401C2 ::v90(){vfunc_called(this, "_ZN7S2401C23v90Ev");}
void  S2401C2 ::v91(){vfunc_called(this, "_ZN7S2401C23v91Ev");}
void  S2401C2 ::v92(){vfunc_called(this, "_ZN7S2401C23v92Ev");}
S2401C2 ::S2401C2(){ note_ctor("S2401C2", this);} // tgen

static void Test_S2401C2()
{
  extern Class_Descriptor cd_S2401C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(41,53)];
    init_test(&cd_S2401C2, buf);
    S2401C2 *dp, &lv = *(dp=new (buf) S2401C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(320,208), "sizeof(S2401C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2401C2)");
    check_base_class_offset(lv, (S2401C4*)(S2401C3*), 0, "S2401C2");
    check_base_class_offset(lv, (S2401C3*), 0, "S2401C2");
    check_base_class_offset(lv, (S2401C15*)(S2401C14*)(S2401C13*), ABISELECT(96,56), "S2401C2");
    check_base_class_offset(lv, (S2401C14*)(S2401C13*), ABISELECT(96,56), "S2401C2");
    check_base_class_offset(lv, (S2401C13*), ABISELECT(96,56), "S2401C2");
    check_base_class_offset(lv, (S2401C19*), ABISELECT(168,96), "S2401C2");
    check_field_offset(lv, s2401c2f0, ABISELECT(176,100), "S2401C2.s2401c2f0");
    check_field_offset(lv, s2401c2f1, ABISELECT(192,112), "S2401C2.s2401c2f1");
    check_field_offset(lv, s2401c2f2, ABISELECT(196,116), "S2401C2.s2401c2f2");
    check_field_offset(lv, s2401c2f3, ABISELECT(200,120), "S2401C2.s2401c2f3");
    check_field_offset(lv, s2401c2f4, ABISELECT(240,140), "S2401C2.s2401c2f4");
    check_field_offset(lv, s2401c2f5, ABISELECT(248,144), "S2401C2.s2401c2f5");
    check_field_offset(lv, s2401c2f6, ABISELECT(256,148), "S2401C2.s2401c2f6");
    check_field_offset(lv, s2401c2f7, ABISELECT(296,184), "S2401C2.s2401c2f7");
    check_field_offset(lv, s2401c2f8, ABISELECT(312,200), "S2401C2.s2401c2f8");
    test_class_info(&lv, &cd_S2401C2);
    dp->~S2401C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2401C2(Test_S2401C2, "S2401C2", ABISELECT(320,208));

#else // __cplusplus

extern void _ZN7S2401C2C1Ev();
extern void _ZN7S2401C2D1Ev();
Name_Map name_map_S2401C2[] = {
  NSPAIR(_ZN7S2401C2C1Ev),
  NSPAIR(_ZN7S2401C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2401C4;
extern VTBL_ENTRY _ZTI7S2401C4[];
extern  VTBL_ENTRY _ZTV7S2401C4[];
extern Class_Descriptor cd_S2401C3;
extern VTBL_ENTRY _ZTI7S2401C3[];
extern  VTBL_ENTRY _ZTV7S2401C3[];
extern Class_Descriptor cd_S2401C15;
extern VTBL_ENTRY _ZTI8S2401C15[];
extern  VTBL_ENTRY _ZTV8S2401C15[];
extern Class_Descriptor cd_S2401C14;
extern VTBL_ENTRY _ZTI8S2401C14[];
extern  VTBL_ENTRY _ZTV8S2401C14[];
extern Class_Descriptor cd_S2401C13;
extern VTBL_ENTRY _ZTI8S2401C13[];
extern  VTBL_ENTRY _ZTV8S2401C13[];
extern Class_Descriptor cd_S2401C19;
extern VTBL_ENTRY _ZTI8S2401C19[];
extern  VTBL_ENTRY _ZTV8S2401C19[];
static Base_Class bases_S2401C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2401C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2401C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2401C15,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2401C14,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2401C13,    ABISELECT(96,56), //bcp->offset
    55, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2401C19,    ABISELECT(168,96), //bcp->offset
    69, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2401C2[];
extern void _ZN7S2401C2D1Ev();
extern void _ZN7S2401C2D0Ev();
extern void _ZN7S2401C42v6Ev();
extern void _ZN7S2401C42v7Ev();
extern void _ZN7S2401C42v8Ev();
extern void _ZN7S2401C42v9Ev();
extern void _ZN7S2401C43v10Ev();
extern void _ZN7S2401C43v11Ev();
extern void _ZN7S2401C43v12Ev();
extern void _ZN7S2401C43v13Ev();
extern void _ZN7S2401C43v14Ev();
extern void _ZN7S2401C43v15Ev();
extern void _ZN7S2401C43v16Ev();
extern void _ZN7S2401C43v17Ev();
extern void _ZN7S2401C33v18Ev();
extern void _ZN7S2401C33v19Ev();
extern void _ZN7S2401C33v20Ev();
extern void _ZN7S2401C33v21Ev();
extern void _ZN7S2401C33v22Ev();
extern void _ZN7S2401C33v23Ev();
extern void _ZN7S2401C33v24Ev();
extern void _ZN7S2401C23v61Ev();
extern void _ZN7S2401C23v62Ev();
extern void _ZN7S2401C23v63Ev();
extern void _ZN7S2401C23v64Ev();
extern void _ZN7S2401C23v65Ev();
extern void _ZN7S2401C23v66Ev();
extern void _ZN7S2401C23v67Ev();
extern void _ZN7S2401C23v68Ev();
extern void _ZN7S2401C23v69Ev();
extern void _ZN7S2401C23v70Ev();
extern void _ZN7S2401C23v71Ev();
extern void _ZN7S2401C23v72Ev();
extern void _ZN7S2401C23v73Ev();
extern void _ZN7S2401C23v74Ev();
extern void _ZN7S2401C23v75Ev();
extern void _ZN7S2401C23v76Ev();
extern void _ZN7S2401C23v77Ev();
extern void _ZN7S2401C23v78Ev();
extern void _ZN7S2401C23v79Ev();
extern void _ZN7S2401C23v80Ev();
extern void _ZN7S2401C23v81Ev();
extern void _ZN7S2401C23v82Ev();
extern void _ZN7S2401C23v83Ev();
extern void _ZN7S2401C23v84Ev();
extern void _ZN7S2401C23v85Ev();
extern void _ZN7S2401C23v86Ev();
extern void _ZN7S2401C23v87Ev();
extern void _ZN7S2401C23v88Ev();
extern void _ZN7S2401C23v89Ev();
extern void _ZN7S2401C23v90Ev();
extern void _ZN7S2401C23v91Ev();
extern void _ZN7S2401C23v92Ev();
extern void ABISELECT(_ZThn96_N7S2401C2D1Ev,_ZThn56_N7S2401C2D1Ev)();
extern void ABISELECT(_ZThn96_N7S2401C2D0Ev,_ZThn56_N7S2401C2D0Ev)();
extern void _ZN8S2401C153v25Ev();
extern void _ZN8S2401C153v26Ev();
extern void _ZN8S2401C153v27Ev();
extern void _ZN8S2401C143v28Ev();
extern void _ZN8S2401C143v29Ev();
extern void _ZN8S2401C143v30Ev();
extern void _ZN8S2401C143v31Ev();
extern void _ZN8S2401C133v32Ev();
extern void _ZN8S2401C133v33Ev();
extern void _ZN8S2401C133v34Ev();
extern void ABISELECT(_ZThn168_N7S2401C2D1Ev,_ZThn96_N7S2401C2D1Ev)();
extern void ABISELECT(_ZThn168_N7S2401C2D0Ev,_ZThn96_N7S2401C2D0Ev)();
extern void _ZN8S2401C193v35Ev();
extern void _ZN8S2401C193v36Ev();
extern void _ZN8S2401C193v37Ev();
extern void _ZN8S2401C193v38Ev();
extern void _ZN8S2401C193v39Ev();
extern void _ZN8S2401C193v40Ev();
extern void _ZN8S2401C193v41Ev();
extern void _ZN8S2401C193v42Ev();
extern void _ZN8S2401C193v43Ev();
extern void _ZN8S2401C193v44Ev();
extern void _ZN8S2401C193v45Ev();
extern void _ZN8S2401C193v46Ev();
extern void _ZN8S2401C193v47Ev();
extern void _ZN8S2401C193v48Ev();
extern void _ZN8S2401C193v49Ev();
extern void _ZN8S2401C193v50Ev();
extern void _ZN8S2401C193v51Ev();
extern void _ZN8S2401C193v52Ev();
extern void _ZN8S2401C193v53Ev();
extern void _ZN8S2401C193v54Ev();
extern void _ZN8S2401C193v55Ev();
extern void _ZN8S2401C193v56Ev();
extern void _ZN8S2401C193v57Ev();
extern void _ZN8S2401C193v58Ev();
extern void _ZN8S2401C193v59Ev();
extern void _ZN8S2401C193v60Ev();
static  VTBL_ENTRY vtc_S2401C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2401C2[0]),
  (VTBL_ENTRY)&_ZN7S2401C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2401C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2401C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2401C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2401C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2401C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v14Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v15Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2401C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2401C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2401C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2401C33v21Ev,
  (VTBL_ENTRY)&_ZN7S2401C33v22Ev,
  (VTBL_ENTRY)&_ZN7S2401C33v23Ev,
  (VTBL_ENTRY)&_ZN7S2401C33v24Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v61Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v62Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v63Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v64Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v65Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v66Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v67Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v68Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v69Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v70Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v71Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v72Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v73Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v74Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v75Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v76Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v77Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v78Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v79Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v80Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v81Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v82Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v83Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v84Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v85Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v86Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v87Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v88Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v89Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v90Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v91Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v92Ev,
  ABISELECT(-96,-56),
  (VTBL_ENTRY)&(_ZTI7S2401C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N7S2401C2D1Ev,_ZThn56_N7S2401C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N7S2401C2D0Ev,_ZThn56_N7S2401C2D0Ev),
  (VTBL_ENTRY)&_ZN8S2401C153v25Ev,
  (VTBL_ENTRY)&_ZN8S2401C153v26Ev,
  (VTBL_ENTRY)&_ZN8S2401C153v27Ev,
  (VTBL_ENTRY)&_ZN8S2401C143v28Ev,
  (VTBL_ENTRY)&_ZN8S2401C143v29Ev,
  (VTBL_ENTRY)&_ZN8S2401C143v30Ev,
  (VTBL_ENTRY)&_ZN8S2401C143v31Ev,
  (VTBL_ENTRY)&_ZN8S2401C133v32Ev,
  (VTBL_ENTRY)&_ZN8S2401C133v33Ev,
  (VTBL_ENTRY)&_ZN8S2401C133v34Ev,
  ABISELECT(-168,-96),
  (VTBL_ENTRY)&(_ZTI7S2401C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N7S2401C2D1Ev,_ZThn96_N7S2401C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N7S2401C2D0Ev,_ZThn96_N7S2401C2D0Ev),
  (VTBL_ENTRY)&_ZN8S2401C193v35Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v36Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v37Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v38Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v39Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v40Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v41Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v42Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v43Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v44Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v45Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v46Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v47Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v48Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v49Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v50Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v51Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v52Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v53Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v54Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v55Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v56Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v57Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v58Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v59Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v60Ev,
};
extern VTBL_ENTRY _ZTI7S2401C2[];
extern  VTBL_ENTRY _ZTV7S2401C2[];
Class_Descriptor cd_S2401C2 = {  "S2401C2", // class name
  bases_S2401C2, 6,
  &(vtc_S2401C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(320,208), // object size
  NSPAIRA(_ZTI7S2401C2),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S2401C2),99, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2401C23  {
  virtual  ~S2401C23(); // _ZN8S2401C23D1Ev
  virtual void  v93(); // _ZN8S2401C233v93Ev
  S2401C23(); // tgen
};
//SIG(-1 S2401C23) C1{ vd v1}


 S2401C23 ::~S2401C23(){ note_dtor("S2401C23", this);}
void  S2401C23 ::v93(){vfunc_called(this, "_ZN8S2401C233v93Ev");}
S2401C23 ::S2401C23(){ note_ctor("S2401C23", this);} // tgen

static void Test_S2401C23()
{
  extern Class_Descriptor cd_S2401C23;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2401C23, buf);
    S2401C23 *dp, &lv = *(dp=new (buf) S2401C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2401C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2401C23)");
    test_class_info(&lv, &cd_S2401C23);
    dp->~S2401C23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2401C23(Test_S2401C23, "S2401C23", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2401C23C1Ev();
extern void _ZN8S2401C23D1Ev();
Name_Map name_map_S2401C23[] = {
  NSPAIR(_ZN8S2401C23C1Ev),
  NSPAIR(_ZN8S2401C23D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2401C23[];
extern void _ZN8S2401C23D1Ev();
extern void _ZN8S2401C23D0Ev();
extern void _ZN8S2401C233v93Ev();
static  VTBL_ENTRY vtc_S2401C23[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2401C23[0]),
  (VTBL_ENTRY)&_ZN8S2401C23D1Ev,
  (VTBL_ENTRY)&_ZN8S2401C23D0Ev,
  (VTBL_ENTRY)&_ZN8S2401C233v93Ev,
};
extern VTBL_ENTRY _ZTI8S2401C23[];
extern  VTBL_ENTRY _ZTV8S2401C23[];
Class_Descriptor cd_S2401C23 = {  "S2401C23", // class name
  0,0,//no base classes
  &(vtc_S2401C23[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2401C23),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2401C23),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2401C1  : S2401C2 , S2401C23 {
  int s2401c1f0;
  char s2401c1f1;
  virtual  ~S2401C1(); // _ZN7S2401C1D1Ev
  virtual void  v1(); // _ZN7S2401C12v1Ev
  virtual void  v2(); // _ZN7S2401C12v2Ev
  virtual void  v3(); // _ZN7S2401C12v3Ev
  virtual void  v4(); // _ZN7S2401C12v4Ev
  virtual void  v5(); // _ZN7S2401C12v5Ev
  S2401C1(); // tgen
};
//SIG(1 S2401C1) C1{ BC2{ BC3{ BC4{ vd v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 Fp FC5{ BC6{ m Fp Fi FC7{ m} FC8{ m}}} FC9{ m FC10{ Fl[4]}} Fc} vd v18 v19 v20 v21 v22 v23 v24 FC11{ m Fp Fi[2] FC7}} BC12{ BC13{ BC14{ vd v25 v26 v27} vd v28 v29 v30 v31} vd v32 v33 v34 FC15{ m Fp Fi[2] FC8} FC16{ m FC10} Fc} BC17{ vd v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60} vd v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 FC18{ m Fp Fi FC7} Fc[2] Fi Fp[5] Fc[2] Fp FC19{ m Fp Fi[4] Fc Fi[3]} FL[2] Fi[2]} BC20{ vd v93} vd v1 v2 v3 v4 v5 Fi Fc}


 S2401C1 ::~S2401C1(){ note_dtor("S2401C1", this);}
void  S2401C1 ::v1(){vfunc_called(this, "_ZN7S2401C12v1Ev");}
void  S2401C1 ::v2(){vfunc_called(this, "_ZN7S2401C12v2Ev");}
void  S2401C1 ::v3(){vfunc_called(this, "_ZN7S2401C12v3Ev");}
void  S2401C1 ::v4(){vfunc_called(this, "_ZN7S2401C12v4Ev");}
void  S2401C1 ::v5(){vfunc_called(this, "_ZN7S2401C12v5Ev");}
S2401C1 ::S2401C1(){ note_ctor("S2401C1", this);} // tgen

static void Test_S2401C1()
{
  extern Class_Descriptor cd_S2401C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(43,56)];
    init_test(&cd_S2401C1, buf);
    S2401C1 *dp, &lv = *(dp=new (buf) S2401C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(336,220), "sizeof(S2401C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2401C1)");
    check_base_class_offset(lv, (S2401C4*)(S2401C3*)(S2401C2*), 0, "S2401C1");
    check_base_class_offset(lv, (S2401C3*)(S2401C2*), 0, "S2401C1");
    check_base_class_offset(lv, (S2401C15*)(S2401C14*)(S2401C13*)(S2401C2*), ABISELECT(96,56), "S2401C1");
    check_base_class_offset(lv, (S2401C14*)(S2401C13*)(S2401C2*), ABISELECT(96,56), "S2401C1");
    check_base_class_offset(lv, (S2401C13*)(S2401C2*), ABISELECT(96,56), "S2401C1");
    check_base_class_offset(lv, (S2401C19*)(S2401C2*), ABISELECT(168,96), "S2401C1");
    check_base_class_offset(lv, (S2401C2*), 0, "S2401C1");
    check_base_class_offset(lv, (S2401C23*), ABISELECT(320,208), "S2401C1");
    check_field_offset(lv, s2401c1f0, ABISELECT(328,212), "S2401C1.s2401c1f0");
    check_field_offset(lv, s2401c1f1, ABISELECT(332,216), "S2401C1.s2401c1f1");
    test_class_info(&lv, &cd_S2401C1);
    dp->~S2401C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2401C1(Test_S2401C1, "S2401C1", ABISELECT(336,220));

#else // __cplusplus

extern void _ZN7S2401C1C1Ev();
extern void _ZN7S2401C1D1Ev();
Name_Map name_map_S2401C1[] = {
  NSPAIR(_ZN7S2401C1C1Ev),
  NSPAIR(_ZN7S2401C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2401C4;
extern VTBL_ENTRY _ZTI7S2401C4[];
extern  VTBL_ENTRY _ZTV7S2401C4[];
extern Class_Descriptor cd_S2401C3;
extern VTBL_ENTRY _ZTI7S2401C3[];
extern  VTBL_ENTRY _ZTV7S2401C3[];
extern Class_Descriptor cd_S2401C15;
extern VTBL_ENTRY _ZTI8S2401C15[];
extern  VTBL_ENTRY _ZTV8S2401C15[];
extern Class_Descriptor cd_S2401C14;
extern VTBL_ENTRY _ZTI8S2401C14[];
extern  VTBL_ENTRY _ZTV8S2401C14[];
extern Class_Descriptor cd_S2401C13;
extern VTBL_ENTRY _ZTI8S2401C13[];
extern  VTBL_ENTRY _ZTV8S2401C13[];
extern Class_Descriptor cd_S2401C19;
extern VTBL_ENTRY _ZTI8S2401C19[];
extern  VTBL_ENTRY _ZTV8S2401C19[];
extern Class_Descriptor cd_S2401C2;
extern VTBL_ENTRY _ZTI7S2401C2[];
extern  VTBL_ENTRY _ZTV7S2401C2[];
extern Class_Descriptor cd_S2401C23;
extern VTBL_ENTRY _ZTI8S2401C23[];
extern  VTBL_ENTRY _ZTV8S2401C23[];
static Base_Class bases_S2401C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2401C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2401C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2401C15,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2401C14,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2401C13,    ABISELECT(96,56), //bcp->offset
    60, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2401C19,    ABISELECT(168,96), //bcp->offset
    74, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2401C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2401C23,    ABISELECT(320,208), //bcp->offset
    104, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2401C1[];
extern void _ZN7S2401C1D1Ev();
extern void _ZN7S2401C1D0Ev();
extern void _ZN7S2401C42v6Ev();
extern void _ZN7S2401C42v7Ev();
extern void _ZN7S2401C42v8Ev();
extern void _ZN7S2401C42v9Ev();
extern void _ZN7S2401C43v10Ev();
extern void _ZN7S2401C43v11Ev();
extern void _ZN7S2401C43v12Ev();
extern void _ZN7S2401C43v13Ev();
extern void _ZN7S2401C43v14Ev();
extern void _ZN7S2401C43v15Ev();
extern void _ZN7S2401C43v16Ev();
extern void _ZN7S2401C43v17Ev();
extern void _ZN7S2401C33v18Ev();
extern void _ZN7S2401C33v19Ev();
extern void _ZN7S2401C33v20Ev();
extern void _ZN7S2401C33v21Ev();
extern void _ZN7S2401C33v22Ev();
extern void _ZN7S2401C33v23Ev();
extern void _ZN7S2401C33v24Ev();
extern void _ZN7S2401C23v61Ev();
extern void _ZN7S2401C23v62Ev();
extern void _ZN7S2401C23v63Ev();
extern void _ZN7S2401C23v64Ev();
extern void _ZN7S2401C23v65Ev();
extern void _ZN7S2401C23v66Ev();
extern void _ZN7S2401C23v67Ev();
extern void _ZN7S2401C23v68Ev();
extern void _ZN7S2401C23v69Ev();
extern void _ZN7S2401C23v70Ev();
extern void _ZN7S2401C23v71Ev();
extern void _ZN7S2401C23v72Ev();
extern void _ZN7S2401C23v73Ev();
extern void _ZN7S2401C23v74Ev();
extern void _ZN7S2401C23v75Ev();
extern void _ZN7S2401C23v76Ev();
extern void _ZN7S2401C23v77Ev();
extern void _ZN7S2401C23v78Ev();
extern void _ZN7S2401C23v79Ev();
extern void _ZN7S2401C23v80Ev();
extern void _ZN7S2401C23v81Ev();
extern void _ZN7S2401C23v82Ev();
extern void _ZN7S2401C23v83Ev();
extern void _ZN7S2401C23v84Ev();
extern void _ZN7S2401C23v85Ev();
extern void _ZN7S2401C23v86Ev();
extern void _ZN7S2401C23v87Ev();
extern void _ZN7S2401C23v88Ev();
extern void _ZN7S2401C23v89Ev();
extern void _ZN7S2401C23v90Ev();
extern void _ZN7S2401C23v91Ev();
extern void _ZN7S2401C23v92Ev();
extern void _ZN7S2401C12v1Ev();
extern void _ZN7S2401C12v2Ev();
extern void _ZN7S2401C12v3Ev();
extern void _ZN7S2401C12v4Ev();
extern void _ZN7S2401C12v5Ev();
extern void ABISELECT(_ZThn96_N7S2401C1D1Ev,_ZThn56_N7S2401C1D1Ev)();
extern void ABISELECT(_ZThn96_N7S2401C1D0Ev,_ZThn56_N7S2401C1D0Ev)();
extern void _ZN8S2401C153v25Ev();
extern void _ZN8S2401C153v26Ev();
extern void _ZN8S2401C153v27Ev();
extern void _ZN8S2401C143v28Ev();
extern void _ZN8S2401C143v29Ev();
extern void _ZN8S2401C143v30Ev();
extern void _ZN8S2401C143v31Ev();
extern void _ZN8S2401C133v32Ev();
extern void _ZN8S2401C133v33Ev();
extern void _ZN8S2401C133v34Ev();
extern void ABISELECT(_ZThn168_N7S2401C1D1Ev,_ZThn96_N7S2401C1D1Ev)();
extern void ABISELECT(_ZThn168_N7S2401C1D0Ev,_ZThn96_N7S2401C1D0Ev)();
extern void _ZN8S2401C193v35Ev();
extern void _ZN8S2401C193v36Ev();
extern void _ZN8S2401C193v37Ev();
extern void _ZN8S2401C193v38Ev();
extern void _ZN8S2401C193v39Ev();
extern void _ZN8S2401C193v40Ev();
extern void _ZN8S2401C193v41Ev();
extern void _ZN8S2401C193v42Ev();
extern void _ZN8S2401C193v43Ev();
extern void _ZN8S2401C193v44Ev();
extern void _ZN8S2401C193v45Ev();
extern void _ZN8S2401C193v46Ev();
extern void _ZN8S2401C193v47Ev();
extern void _ZN8S2401C193v48Ev();
extern void _ZN8S2401C193v49Ev();
extern void _ZN8S2401C193v50Ev();
extern void _ZN8S2401C193v51Ev();
extern void _ZN8S2401C193v52Ev();
extern void _ZN8S2401C193v53Ev();
extern void _ZN8S2401C193v54Ev();
extern void _ZN8S2401C193v55Ev();
extern void _ZN8S2401C193v56Ev();
extern void _ZN8S2401C193v57Ev();
extern void _ZN8S2401C193v58Ev();
extern void _ZN8S2401C193v59Ev();
extern void _ZN8S2401C193v60Ev();
extern void ABISELECT(_ZThn320_N7S2401C1D1Ev,_ZThn208_N7S2401C1D1Ev)();
extern void ABISELECT(_ZThn320_N7S2401C1D0Ev,_ZThn208_N7S2401C1D0Ev)();
extern void _ZN8S2401C233v93Ev();
static  VTBL_ENTRY vtc_S2401C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2401C1[0]),
  (VTBL_ENTRY)&_ZN7S2401C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2401C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2401C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2401C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2401C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2401C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v14Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v15Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2401C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2401C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2401C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2401C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2401C33v21Ev,
  (VTBL_ENTRY)&_ZN7S2401C33v22Ev,
  (VTBL_ENTRY)&_ZN7S2401C33v23Ev,
  (VTBL_ENTRY)&_ZN7S2401C33v24Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v61Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v62Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v63Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v64Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v65Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v66Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v67Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v68Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v69Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v70Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v71Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v72Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v73Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v74Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v75Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v76Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v77Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v78Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v79Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v80Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v81Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v82Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v83Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v84Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v85Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v86Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v87Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v88Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v89Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v90Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v91Ev,
  (VTBL_ENTRY)&_ZN7S2401C23v92Ev,
  (VTBL_ENTRY)&_ZN7S2401C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2401C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2401C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2401C12v4Ev,
  (VTBL_ENTRY)&_ZN7S2401C12v5Ev,
  ABISELECT(-96,-56),
  (VTBL_ENTRY)&(_ZTI7S2401C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N7S2401C1D1Ev,_ZThn56_N7S2401C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N7S2401C1D0Ev,_ZThn56_N7S2401C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2401C153v25Ev,
  (VTBL_ENTRY)&_ZN8S2401C153v26Ev,
  (VTBL_ENTRY)&_ZN8S2401C153v27Ev,
  (VTBL_ENTRY)&_ZN8S2401C143v28Ev,
  (VTBL_ENTRY)&_ZN8S2401C143v29Ev,
  (VTBL_ENTRY)&_ZN8S2401C143v30Ev,
  (VTBL_ENTRY)&_ZN8S2401C143v31Ev,
  (VTBL_ENTRY)&_ZN8S2401C133v32Ev,
  (VTBL_ENTRY)&_ZN8S2401C133v33Ev,
  (VTBL_ENTRY)&_ZN8S2401C133v34Ev,
  ABISELECT(-168,-96),
  (VTBL_ENTRY)&(_ZTI7S2401C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N7S2401C1D1Ev,_ZThn96_N7S2401C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N7S2401C1D0Ev,_ZThn96_N7S2401C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2401C193v35Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v36Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v37Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v38Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v39Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v40Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v41Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v42Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v43Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v44Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v45Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v46Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v47Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v48Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v49Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v50Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v51Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v52Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v53Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v54Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v55Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v56Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v57Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v58Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v59Ev,
  (VTBL_ENTRY)&_ZN8S2401C193v60Ev,
  ABISELECT(-320,-208),
  (VTBL_ENTRY)&(_ZTI7S2401C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn320_N7S2401C1D1Ev,_ZThn208_N7S2401C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn320_N7S2401C1D0Ev,_ZThn208_N7S2401C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2401C233v93Ev,
};
extern VTBL_ENTRY _ZTI7S2401C1[];
extern  VTBL_ENTRY _ZTV7S2401C1[];
Class_Descriptor cd_S2401C1 = {  "S2401C1", // class name
  bases_S2401C1, 8,
  &(vtc_S2401C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(336,220), // object size
  NSPAIRA(_ZTI7S2401C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2401C1),109, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  8, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S506C5  {
  void *s506c5f0;
  ::S1587C5_nt s506c5f1;
  char s506c5f2;
  int s506c5f3;
  virtual  ~S506C5(); // _ZN6S506C5D1Ev
  virtual void  v21(); // _ZN6S506C53v21Ev
  virtual void  v22(); // _ZN6S506C53v22Ev
  virtual void  v23(); // _ZN6S506C53v23Ev
  virtual void  v24(); // _ZN6S506C53v24Ev
  virtual void  v25(); // _ZN6S506C53v25Ev
  virtual void  v26(); // _ZN6S506C53v26Ev
  virtual void  v27(); // _ZN6S506C53v27Ev
  virtual void  v28(); // _ZN6S506C53v28Ev
  virtual void  v29(); // _ZN6S506C53v29Ev
  virtual void  v30(); // _ZN6S506C53v30Ev
  virtual void  v31(); // _ZN6S506C53v31Ev
  virtual void  v32(); // _ZN6S506C53v32Ev
  virtual void  v33(); // _ZN6S506C53v33Ev
  S506C5(); // tgen
};
//SIG(-1 S506C5) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 Fp FC2{ m FC3{ m Fp Fi FC4{ m}} Fi} Fc Fi}


 S506C5 ::~S506C5(){ note_dtor("S506C5", this);}
void  S506C5 ::v21(){vfunc_called(this, "_ZN6S506C53v21Ev");}
void  S506C5 ::v22(){vfunc_called(this, "_ZN6S506C53v22Ev");}
void  S506C5 ::v23(){vfunc_called(this, "_ZN6S506C53v23Ev");}
void  S506C5 ::v24(){vfunc_called(this, "_ZN6S506C53v24Ev");}
void  S506C5 ::v25(){vfunc_called(this, "_ZN6S506C53v25Ev");}
void  S506C5 ::v26(){vfunc_called(this, "_ZN6S506C53v26Ev");}
void  S506C5 ::v27(){vfunc_called(this, "_ZN6S506C53v27Ev");}
void  S506C5 ::v28(){vfunc_called(this, "_ZN6S506C53v28Ev");}
void  S506C5 ::v29(){vfunc_called(this, "_ZN6S506C53v29Ev");}
void  S506C5 ::v30(){vfunc_called(this, "_ZN6S506C53v30Ev");}
void  S506C5 ::v31(){vfunc_called(this, "_ZN6S506C53v31Ev");}
void  S506C5 ::v32(){vfunc_called(this, "_ZN6S506C53v32Ev");}
void  S506C5 ::v33(){vfunc_called(this, "_ZN6S506C53v33Ev");}
S506C5 ::S506C5(){ note_ctor("S506C5", this);} // tgen

static void Test_S506C5()
{
  extern Class_Descriptor cd_S506C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,9)];
    init_test(&cd_S506C5, buf);
    S506C5 *dp, &lv = *(dp=new (buf) S506C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,32), "sizeof(S506C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S506C5)");
    check_field_offset(lv, s506c5f0, ABISELECT(8,4), "S506C5.s506c5f0");
    check_field_offset(lv, s506c5f1, ABISELECT(16,8), "S506C5.s506c5f1");
    check_field_offset(lv, s506c5f2, ABISELECT(40,24), "S506C5.s506c5f2");
    check_field_offset(lv, s506c5f3, ABISELECT(44,28), "S506C5.s506c5f3");
    test_class_info(&lv, &cd_S506C5);
    dp->~S506C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS506C5(Test_S506C5, "S506C5", ABISELECT(48,32));

#else // __cplusplus

extern void _ZN6S506C5C1Ev();
extern void _ZN6S506C5D1Ev();
Name_Map name_map_S506C5[] = {
  NSPAIR(_ZN6S506C5C1Ev),
  NSPAIR(_ZN6S506C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI6S506C5[];
extern void _ZN6S506C5D1Ev();
extern void _ZN6S506C5D0Ev();
extern void _ZN6S506C53v21Ev();
extern void _ZN6S506C53v22Ev();
extern void _ZN6S506C53v23Ev();
extern void _ZN6S506C53v24Ev();
extern void _ZN6S506C53v25Ev();
extern void _ZN6S506C53v26Ev();
extern void _ZN6S506C53v27Ev();
extern void _ZN6S506C53v28Ev();
extern void _ZN6S506C53v29Ev();
extern void _ZN6S506C53v30Ev();
extern void _ZN6S506C53v31Ev();
extern void _ZN6S506C53v32Ev();
extern void _ZN6S506C53v33Ev();
static  VTBL_ENTRY vtc_S506C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S506C5[0]),
  (VTBL_ENTRY)&_ZN6S506C5D1Ev,
  (VTBL_ENTRY)&_ZN6S506C5D0Ev,
  (VTBL_ENTRY)&_ZN6S506C53v21Ev,
  (VTBL_ENTRY)&_ZN6S506C53v22Ev,
  (VTBL_ENTRY)&_ZN6S506C53v23Ev,
  (VTBL_ENTRY)&_ZN6S506C53v24Ev,
  (VTBL_ENTRY)&_ZN6S506C53v25Ev,
  (VTBL_ENTRY)&_ZN6S506C53v26Ev,
  (VTBL_ENTRY)&_ZN6S506C53v27Ev,
  (VTBL_ENTRY)&_ZN6S506C53v28Ev,
  (VTBL_ENTRY)&_ZN6S506C53v29Ev,
  (VTBL_ENTRY)&_ZN6S506C53v30Ev,
  (VTBL_ENTRY)&_ZN6S506C53v31Ev,
  (VTBL_ENTRY)&_ZN6S506C53v32Ev,
  (VTBL_ENTRY)&_ZN6S506C53v33Ev,
};
extern VTBL_ENTRY _ZTI6S506C5[];
extern  VTBL_ENTRY _ZTV6S506C5[];
Class_Descriptor cd_S506C5 = {  "S506C5", // class name
  0,0,//no base classes
  &(vtc_S506C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,32), // object size
  NSPAIRA(_ZTI6S506C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV6S506C5),17, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S506C4  : S506C5 {
  void *s506c4f0[3];
  int s506c4f1;
  virtual  ~S506C4(); // _ZN6S506C4D1Ev
  virtual void  v34(); // _ZN6S506C43v34Ev
  virtual void  v35(); // _ZN6S506C43v35Ev
  virtual void  v36(); // _ZN6S506C43v36Ev
  virtual void  v37(); // _ZN6S506C43v37Ev
  virtual void  v38(); // _ZN6S506C43v38Ev
  virtual void  v39(); // _ZN6S506C43v39Ev
  virtual void  v40(); // _ZN6S506C43v40Ev
  virtual void  v41(); // _ZN6S506C43v41Ev
  virtual void  v42(); // _ZN6S506C43v42Ev
  virtual void  v43(); // _ZN6S506C43v43Ev
  virtual void  v44(); // _ZN6S506C43v44Ev
  S506C4(); // tgen
};
//SIG(-1 S506C4) C1{ BC2{ vd v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 Fp FC3{ m FC4{ m Fp Fi FC5{ m}} Fi} Fc Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 Fp[3] Fi}


 S506C4 ::~S506C4(){ note_dtor("S506C4", this);}
void  S506C4 ::v34(){vfunc_called(this, "_ZN6S506C43v34Ev");}
void  S506C4 ::v35(){vfunc_called(this, "_ZN6S506C43v35Ev");}
void  S506C4 ::v36(){vfunc_called(this, "_ZN6S506C43v36Ev");}
void  S506C4 ::v37(){vfunc_called(this, "_ZN6S506C43v37Ev");}
void  S506C4 ::v38(){vfunc_called(this, "_ZN6S506C43v38Ev");}
void  S506C4 ::v39(){vfunc_called(this, "_ZN6S506C43v39Ev");}
void  S506C4 ::v40(){vfunc_called(this, "_ZN6S506C43v40Ev");}
void  S506C4 ::v41(){vfunc_called(this, "_ZN6S506C43v41Ev");}
void  S506C4 ::v42(){vfunc_called(this, "_ZN6S506C43v42Ev");}
void  S506C4 ::v43(){vfunc_called(this, "_ZN6S506C43v43Ev");}
void  S506C4 ::v44(){vfunc_called(this, "_ZN6S506C43v44Ev");}
S506C4 ::S506C4(){ note_ctor("S506C4", this);} // tgen

static void Test_S506C4()
{
  extern Class_Descriptor cd_S506C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,13)];
    init_test(&cd_S506C4, buf);
    S506C4 *dp, &lv = *(dp=new (buf) S506C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,48), "sizeof(S506C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S506C4)");
    check_base_class_offset(lv, (S506C5*), 0, "S506C4");
    check_field_offset(lv, s506c4f0, ABISELECT(48,32), "S506C4.s506c4f0");
    check_field_offset(lv, s506c4f1, ABISELECT(72,44), "S506C4.s506c4f1");
    test_class_info(&lv, &cd_S506C4);
    dp->~S506C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS506C4(Test_S506C4, "S506C4", ABISELECT(80,48));

#else // __cplusplus

extern void _ZN6S506C4C1Ev();
extern void _ZN6S506C4D1Ev();
Name_Map name_map_S506C4[] = {
  NSPAIR(_ZN6S506C4C1Ev),
  NSPAIR(_ZN6S506C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S506C5;
extern VTBL_ENTRY _ZTI6S506C5[];
extern  VTBL_ENTRY _ZTV6S506C5[];
static Base_Class bases_S506C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S506C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S506C4[];
extern void _ZN6S506C4D1Ev();
extern void _ZN6S506C4D0Ev();
extern void _ZN6S506C53v21Ev();
extern void _ZN6S506C53v22Ev();
extern void _ZN6S506C53v23Ev();
extern void _ZN6S506C53v24Ev();
extern void _ZN6S506C53v25Ev();
extern void _ZN6S506C53v26Ev();
extern void _ZN6S506C53v27Ev();
extern void _ZN6S506C53v28Ev();
extern void _ZN6S506C53v29Ev();
extern void _ZN6S506C53v30Ev();
extern void _ZN6S506C53v31Ev();
extern void _ZN6S506C53v32Ev();
extern void _ZN6S506C53v33Ev();
extern void _ZN6S506C43v34Ev();
extern void _ZN6S506C43v35Ev();
extern void _ZN6S506C43v36Ev();
extern void _ZN6S506C43v37Ev();
extern void _ZN6S506C43v38Ev();
extern void _ZN6S506C43v39Ev();
extern void _ZN6S506C43v40Ev();
extern void _ZN6S506C43v41Ev();
extern void _ZN6S506C43v42Ev();
extern void _ZN6S506C43v43Ev();
extern void _ZN6S506C43v44Ev();
static  VTBL_ENTRY vtc_S506C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S506C4[0]),
  (VTBL_ENTRY)&_ZN6S506C4D1Ev,
  (VTBL_ENTRY)&_ZN6S506C4D0Ev,
  (VTBL_ENTRY)&_ZN6S506C53v21Ev,
  (VTBL_ENTRY)&_ZN6S506C53v22Ev,
  (VTBL_ENTRY)&_ZN6S506C53v23Ev,
  (VTBL_ENTRY)&_ZN6S506C53v24Ev,
  (VTBL_ENTRY)&_ZN6S506C53v25Ev,
  (VTBL_ENTRY)&_ZN6S506C53v26Ev,
  (VTBL_ENTRY)&_ZN6S506C53v27Ev,
  (VTBL_ENTRY)&_ZN6S506C53v28Ev,
  (VTBL_ENTRY)&_ZN6S506C53v29Ev,
  (VTBL_ENTRY)&_ZN6S506C53v30Ev,
  (VTBL_ENTRY)&_ZN6S506C53v31Ev,
  (VTBL_ENTRY)&_ZN6S506C53v32Ev,
  (VTBL_ENTRY)&_ZN6S506C53v33Ev,
  (VTBL_ENTRY)&_ZN6S506C43v34Ev,
  (VTBL_ENTRY)&_ZN6S506C43v35Ev,
  (VTBL_ENTRY)&_ZN6S506C43v36Ev,
  (VTBL_ENTRY)&_ZN6S506C43v37Ev,
  (VTBL_ENTRY)&_ZN6S506C43v38Ev,
  (VTBL_ENTRY)&_ZN6S506C43v39Ev,
  (VTBL_ENTRY)&_ZN6S506C43v40Ev,
  (VTBL_ENTRY)&_ZN6S506C43v41Ev,
  (VTBL_ENTRY)&_ZN6S506C43v42Ev,
  (VTBL_ENTRY)&_ZN6S506C43v43Ev,
  (VTBL_ENTRY)&_ZN6S506C43v44Ev,
};
extern VTBL_ENTRY _ZTI6S506C4[];
extern  VTBL_ENTRY _ZTV6S506C4[];
Class_Descriptor cd_S506C4 = {  "S506C4", // class name
  bases_S506C4, 1,
  &(vtc_S506C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,48), // object size
  NSPAIRA(_ZTI6S506C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S506C4),28, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S506C3  : S506C4 {
  void *s506c3f0[2];
  int s506c3f1[3];
  ::S1587C5_nt s506c3f2;
  char s506c3f3;
  ::S1587C8_nt s506c3f4;
  char s506c3f5;
  int s506c3f6;
  char s506c3f7;
  int s506c3f8;
  char s506c3f9[2];
  int s506c3f10;
  char s506c3f11;
  virtual  ~S506C3(); // _ZN6S506C3D1Ev
  virtual void  v45(); // _ZN6S506C33v45Ev
  virtual void  v46(); // _ZN6S506C33v46Ev
  virtual void  v47(); // _ZN6S506C33v47Ev
  virtual void  v48(); // _ZN6S506C33v48Ev
  virtual void  v49(); // _ZN6S506C33v49Ev
  virtual void  v50(); // _ZN6S506C33v50Ev
  virtual void  v51(); // _ZN6S506C33v51Ev
  virtual void  v52(); // _ZN6S506C33v52Ev
  virtual void  v53(); // _ZN6S506C33v53Ev
  virtual void  v54(); // _ZN6S506C33v54Ev
  virtual void  v55(); // _ZN6S506C33v55Ev
  virtual void  v56(); // _ZN6S506C33v56Ev
  virtual void  v57(); // _ZN6S506C33v57Ev
  virtual void  v58(); // _ZN6S506C33v58Ev
  virtual void  v59(); // _ZN6S506C33v59Ev
  virtual void  v60(); // _ZN6S506C33v60Ev
  virtual void  v61(); // _ZN6S506C33v61Ev
  S506C3(); // tgen
};
//SIG(-1 S506C3) C1{ BC2{ BC3{ vd v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 Fp FC4{ m FC5{ m Fp Fi FC6{ m}} Fi} Fc Fi} vd v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 Fp[3] Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 Fp[2] Fi[3] FC4 Fc FC7{ m FC8{ m FL}} Fc Fi Fc Fi Fc[2] Fi Fc}


 S506C3 ::~S506C3(){ note_dtor("S506C3", this);}
void  S506C3 ::v45(){vfunc_called(this, "_ZN6S506C33v45Ev");}
void  S506C3 ::v46(){vfunc_called(this, "_ZN6S506C33v46Ev");}
void  S506C3 ::v47(){vfunc_called(this, "_ZN6S506C33v47Ev");}
void  S506C3 ::v48(){vfunc_called(this, "_ZN6S506C33v48Ev");}
void  S506C3 ::v49(){vfunc_called(this, "_ZN6S506C33v49Ev");}
void  S506C3 ::v50(){vfunc_called(this, "_ZN6S506C33v50Ev");}
void  S506C3 ::v51(){vfunc_called(this, "_ZN6S506C33v51Ev");}
void  S506C3 ::v52(){vfunc_called(this, "_ZN6S506C33v52Ev");}
void  S506C3 ::v53(){vfunc_called(this, "_ZN6S506C33v53Ev");}
void  S506C3 ::v54(){vfunc_called(this, "_ZN6S506C33v54Ev");}
void  S506C3 ::v55(){vfunc_called(this, "_ZN6S506C33v55Ev");}
void  S506C3 ::v56(){vfunc_called(this, "_ZN6S506C33v56Ev");}
void  S506C3 ::v57(){vfunc_called(this, "_ZN6S506C33v57Ev");}
void  S506C3 ::v58(){vfunc_called(this, "_ZN6S506C33v58Ev");}
void  S506C3 ::v59(){vfunc_called(this, "_ZN6S506C33v59Ev");}
void  S506C3 ::v60(){vfunc_called(this, "_ZN6S506C33v60Ev");}
void  S506C3 ::v61(){vfunc_called(this, "_ZN6S506C33v61Ev");}
S506C3 ::S506C3(){ note_ctor("S506C3", this);} // tgen

static void Test_S506C3()
{
  extern Class_Descriptor cd_S506C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(24,32)];
    init_test(&cd_S506C3, buf);
    S506C3 *dp, &lv = *(dp=new (buf) S506C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(184,124), "sizeof(S506C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S506C3)");
    check_base_class_offset(lv, (S506C5*)(S506C4*), 0, "S506C3");
    check_base_class_offset(lv, (S506C4*), 0, "S506C3");
    check_field_offset(lv, s506c3f0, ABISELECT(80,48), "S506C3.s506c3f0");
    check_field_offset(lv, s506c3f1, ABISELECT(96,56), "S506C3.s506c3f1");
    check_field_offset(lv, s506c3f2, ABISELECT(112,68), "S506C3.s506c3f2");
    check_field_offset(lv, s506c3f3, ABISELECT(136,84), "S506C3.s506c3f3");
    check_field_offset(lv, s506c3f4, ABISELECT(144,88), "S506C3.s506c3f4");
    check_field_offset(lv, s506c3f5, ABISELECT(152,96), "S506C3.s506c3f5");
    check_field_offset(lv, s506c3f6, ABISELECT(156,100), "S506C3.s506c3f6");
    check_field_offset(lv, s506c3f7, ABISELECT(160,104), "S506C3.s506c3f7");
    check_field_offset(lv, s506c3f8, ABISELECT(164,108), "S506C3.s506c3f8");
    check_field_offset(lv, s506c3f9, ABISELECT(168,112), "S506C3.s506c3f9");
    check_field_offset(lv, s506c3f10, ABISELECT(172,116), "S506C3.s506c3f10");
    check_field_offset(lv, s506c3f11, ABISELECT(176,120), "S506C3.s506c3f11");
    test_class_info(&lv, &cd_S506C3);
    dp->~S506C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS506C3(Test_S506C3, "S506C3", ABISELECT(184,124));

#else // __cplusplus

extern void _ZN6S506C3C1Ev();
extern void _ZN6S506C3D1Ev();
Name_Map name_map_S506C3[] = {
  NSPAIR(_ZN6S506C3C1Ev),
  NSPAIR(_ZN6S506C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S506C5;
extern VTBL_ENTRY _ZTI6S506C5[];
extern  VTBL_ENTRY _ZTV6S506C5[];
extern Class_Descriptor cd_S506C4;
extern VTBL_ENTRY _ZTI6S506C4[];
extern  VTBL_ENTRY _ZTV6S506C4[];
static Base_Class bases_S506C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S506C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S506C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S506C3[];
extern void _ZN6S506C3D1Ev();
extern void _ZN6S506C3D0Ev();
extern void _ZN6S506C53v21Ev();
extern void _ZN6S506C53v22Ev();
extern void _ZN6S506C53v23Ev();
extern void _ZN6S506C53v24Ev();
extern void _ZN6S506C53v25Ev();
extern void _ZN6S506C53v26Ev();
extern void _ZN6S506C53v27Ev();
extern void _ZN6S506C53v28Ev();
extern void _ZN6S506C53v29Ev();
extern void _ZN6S506C53v30Ev();
extern void _ZN6S506C53v31Ev();
extern void _ZN6S506C53v32Ev();
extern void _ZN6S506C53v33Ev();
extern void _ZN6S506C43v34Ev();
extern void _ZN6S506C43v35Ev();
extern void _ZN6S506C43v36Ev();
extern void _ZN6S506C43v37Ev();
extern void _ZN6S506C43v38Ev();
extern void _ZN6S506C43v39Ev();
extern void _ZN6S506C43v40Ev();
extern void _ZN6S506C43v41Ev();
extern void _ZN6S506C43v42Ev();
extern void _ZN6S506C43v43Ev();
extern void _ZN6S506C43v44Ev();
extern void _ZN6S506C33v45Ev();
extern void _ZN6S506C33v46Ev();
extern void _ZN6S506C33v47Ev();
extern void _ZN6S506C33v48Ev();
extern void _ZN6S506C33v49Ev();
extern void _ZN6S506C33v50Ev();
extern void _ZN6S506C33v51Ev();
extern void _ZN6S506C33v52Ev();
extern void _ZN6S506C33v53Ev();
extern void _ZN6S506C33v54Ev();
extern void _ZN6S506C33v55Ev();
extern void _ZN6S506C33v56Ev();
extern void _ZN6S506C33v57Ev();
extern void _ZN6S506C33v58Ev();
extern void _ZN6S506C33v59Ev();
extern void _ZN6S506C33v60Ev();
extern void _ZN6S506C33v61Ev();
static  VTBL_ENTRY vtc_S506C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S506C3[0]),
  (VTBL_ENTRY)&_ZN6S506C3D1Ev,
  (VTBL_ENTRY)&_ZN6S506C3D0Ev,
  (VTBL_ENTRY)&_ZN6S506C53v21Ev,
  (VTBL_ENTRY)&_ZN6S506C53v22Ev,
  (VTBL_ENTRY)&_ZN6S506C53v23Ev,
  (VTBL_ENTRY)&_ZN6S506C53v24Ev,
  (VTBL_ENTRY)&_ZN6S506C53v25Ev,
  (VTBL_ENTRY)&_ZN6S506C53v26Ev,
  (VTBL_ENTRY)&_ZN6S506C53v27Ev,
  (VTBL_ENTRY)&_ZN6S506C53v28Ev,
  (VTBL_ENTRY)&_ZN6S506C53v29Ev,
  (VTBL_ENTRY)&_ZN6S506C53v30Ev,
  (VTBL_ENTRY)&_ZN6S506C53v31Ev,
  (VTBL_ENTRY)&_ZN6S506C53v32Ev,
  (VTBL_ENTRY)&_ZN6S506C53v33Ev,
  (VTBL_ENTRY)&_ZN6S506C43v34Ev,
  (VTBL_ENTRY)&_ZN6S506C43v35Ev,
  (VTBL_ENTRY)&_ZN6S506C43v36Ev,
  (VTBL_ENTRY)&_ZN6S506C43v37Ev,
  (VTBL_ENTRY)&_ZN6S506C43v38Ev,
  (VTBL_ENTRY)&_ZN6S506C43v39Ev,
  (VTBL_ENTRY)&_ZN6S506C43v40Ev,
  (VTBL_ENTRY)&_ZN6S506C43v41Ev,
  (VTBL_ENTRY)&_ZN6S506C43v42Ev,
  (VTBL_ENTRY)&_ZN6S506C43v43Ev,
  (VTBL_ENTRY)&_ZN6S506C43v44Ev,
  (VTBL_ENTRY)&_ZN6S506C33v45Ev,
  (VTBL_ENTRY)&_ZN6S506C33v46Ev,
  (VTBL_ENTRY)&_ZN6S506C33v47Ev,
  (VTBL_ENTRY)&_ZN6S506C33v48Ev,
  (VTBL_ENTRY)&_ZN6S506C33v49Ev,
  (VTBL_ENTRY)&_ZN6S506C33v50Ev,
  (VTBL_ENTRY)&_ZN6S506C33v51Ev,
  (VTBL_ENTRY)&_ZN6S506C33v52Ev,
  (VTBL_ENTRY)&_ZN6S506C33v53Ev,
  (VTBL_ENTRY)&_ZN6S506C33v54Ev,
  (VTBL_ENTRY)&_ZN6S506C33v55Ev,
  (VTBL_ENTRY)&_ZN6S506C33v56Ev,
  (VTBL_ENTRY)&_ZN6S506C33v57Ev,
  (VTBL_ENTRY)&_ZN6S506C33v58Ev,
  (VTBL_ENTRY)&_ZN6S506C33v59Ev,
  (VTBL_ENTRY)&_ZN6S506C33v60Ev,
  (VTBL_ENTRY)&_ZN6S506C33v61Ev,
};
extern VTBL_ENTRY _ZTI6S506C3[];
extern  VTBL_ENTRY _ZTV6S506C3[];
Class_Descriptor cd_S506C3 = {  "S506C3", // class name
  bases_S506C3, 2,
  &(vtc_S506C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(184,124), // object size
  NSPAIRA(_ZTI6S506C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S506C3),45, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S506C2  : S506C3 {
  int s506c2f0[4];
  virtual  ~S506C2(); // _ZN6S506C2D1Ev
  virtual void  v62(); // _ZN6S506C23v62Ev
  virtual void  v63(); // _ZN6S506C23v63Ev
  virtual void  v64(); // _ZN6S506C23v64Ev
  virtual void  v65(); // _ZN6S506C23v65Ev
  virtual void  v66(); // _ZN6S506C23v66Ev
  virtual void  v67(); // _ZN6S506C23v67Ev
  virtual void  v68(); // _ZN6S506C23v68Ev
  virtual void  v69(); // _ZN6S506C23v69Ev
  virtual void  v70(); // _ZN6S506C23v70Ev
  virtual void  v71(); // _ZN6S506C23v71Ev
  virtual void  v72(); // _ZN6S506C23v72Ev
  virtual void  v73(); // _ZN6S506C23v73Ev
  virtual void  v74(); // _ZN6S506C23v74Ev
  S506C2(); // tgen
};
//SIG(-1 S506C2) C1{ BC2{ BC3{ BC4{ vd v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 Fp FC5{ m FC6{ m Fp Fi FC7{ m}} Fi} Fc Fi} vd v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 Fp[3] Fi} vd v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 Fp[2] Fi[3] FC5 Fc FC8{ m FC9{ m FL}} Fc Fi Fc Fi Fc[2] Fi Fc} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 Fi[4]}


 S506C2 ::~S506C2(){ note_dtor("S506C2", this);}
void  S506C2 ::v62(){vfunc_called(this, "_ZN6S506C23v62Ev");}
void  S506C2 ::v63(){vfunc_called(this, "_ZN6S506C23v63Ev");}
void  S506C2 ::v64(){vfunc_called(this, "_ZN6S506C23v64Ev");}
void  S506C2 ::v65(){vfunc_called(this, "_ZN6S506C23v65Ev");}
void  S506C2 ::v66(){vfunc_called(this, "_ZN6S506C23v66Ev");}
void  S506C2 ::v67(){vfunc_called(this, "_ZN6S506C23v67Ev");}
void  S506C2 ::v68(){vfunc_called(this, "_ZN6S506C23v68Ev");}
void  S506C2 ::v69(){vfunc_called(this, "_ZN6S506C23v69Ev");}
void  S506C2 ::v70(){vfunc_called(this, "_ZN6S506C23v70Ev");}
void  S506C2 ::v71(){vfunc_called(this, "_ZN6S506C23v71Ev");}
void  S506C2 ::v72(){vfunc_called(this, "_ZN6S506C23v72Ev");}
void  S506C2 ::v73(){vfunc_called(this, "_ZN6S506C23v73Ev");}
void  S506C2 ::v74(){vfunc_called(this, "_ZN6S506C23v74Ev");}
S506C2 ::S506C2(){ note_ctor("S506C2", this);} // tgen

static void Test_S506C2()
{
  extern Class_Descriptor cd_S506C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(26,36)];
    init_test(&cd_S506C2, buf);
    S506C2 *dp, &lv = *(dp=new (buf) S506C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(200,140), "sizeof(S506C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S506C2)");
    check_base_class_offset(lv, (S506C5*)(S506C4*)(S506C3*), 0, "S506C2");
    check_base_class_offset(lv, (S506C4*)(S506C3*), 0, "S506C2");
    check_base_class_offset(lv, (S506C3*), 0, "S506C2");
    check_field_offset(lv, s506c2f0, ABISELECT(180,124), "S506C2.s506c2f0");
    test_class_info(&lv, &cd_S506C2);
    dp->~S506C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS506C2(Test_S506C2, "S506C2", ABISELECT(200,140));

#else // __cplusplus

extern void _ZN6S506C2C1Ev();
extern void _ZN6S506C2D1Ev();
Name_Map name_map_S506C2[] = {
  NSPAIR(_ZN6S506C2C1Ev),
  NSPAIR(_ZN6S506C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S506C5;
extern VTBL_ENTRY _ZTI6S506C5[];
extern  VTBL_ENTRY _ZTV6S506C5[];
extern Class_Descriptor cd_S506C4;
extern VTBL_ENTRY _ZTI6S506C4[];
extern  VTBL_ENTRY _ZTV6S506C4[];
extern Class_Descriptor cd_S506C3;
extern VTBL_ENTRY _ZTI6S506C3[];
extern  VTBL_ENTRY _ZTV6S506C3[];
static Base_Class bases_S506C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S506C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S506C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S506C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S506C2[];
extern void _ZN6S506C2D1Ev();
extern void _ZN6S506C2D0Ev();
extern void _ZN6S506C53v21Ev();
extern void _ZN6S506C53v22Ev();
extern void _ZN6S506C53v23Ev();
extern void _ZN6S506C53v24Ev();
extern void _ZN6S506C53v25Ev();
extern void _ZN6S506C53v26Ev();
extern void _ZN6S506C53v27Ev();
extern void _ZN6S506C53v28Ev();
extern void _ZN6S506C53v29Ev();
extern void _ZN6S506C53v30Ev();
extern void _ZN6S506C53v31Ev();
extern void _ZN6S506C53v32Ev();
extern void _ZN6S506C53v33Ev();
extern void _ZN6S506C43v34Ev();
extern void _ZN6S506C43v35Ev();
extern void _ZN6S506C43v36Ev();
extern void _ZN6S506C43v37Ev();
extern void _ZN6S506C43v38Ev();
extern void _ZN6S506C43v39Ev();
extern void _ZN6S506C43v40Ev();
extern void _ZN6S506C43v41Ev();
extern void _ZN6S506C43v42Ev();
extern void _ZN6S506C43v43Ev();
extern void _ZN6S506C43v44Ev();
extern void _ZN6S506C33v45Ev();
extern void _ZN6S506C33v46Ev();
extern void _ZN6S506C33v47Ev();
extern void _ZN6S506C33v48Ev();
extern void _ZN6S506C33v49Ev();
extern void _ZN6S506C33v50Ev();
extern void _ZN6S506C33v51Ev();
extern void _ZN6S506C33v52Ev();
extern void _ZN6S506C33v53Ev();
extern void _ZN6S506C33v54Ev();
extern void _ZN6S506C33v55Ev();
extern void _ZN6S506C33v56Ev();
extern void _ZN6S506C33v57Ev();
extern void _ZN6S506C33v58Ev();
extern void _ZN6S506C33v59Ev();
extern void _ZN6S506C33v60Ev();
extern void _ZN6S506C33v61Ev();
extern void _ZN6S506C23v62Ev();
extern void _ZN6S506C23v63Ev();
extern void _ZN6S506C23v64Ev();
extern void _ZN6S506C23v65Ev();
extern void _ZN6S506C23v66Ev();
extern void _ZN6S506C23v67Ev();
extern void _ZN6S506C23v68Ev();
extern void _ZN6S506C23v69Ev();
extern void _ZN6S506C23v70Ev();
extern void _ZN6S506C23v71Ev();
extern void _ZN6S506C23v72Ev();
extern void _ZN6S506C23v73Ev();
extern void _ZN6S506C23v74Ev();
static  VTBL_ENTRY vtc_S506C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S506C2[0]),
  (VTBL_ENTRY)&_ZN6S506C2D1Ev,
  (VTBL_ENTRY)&_ZN6S506C2D0Ev,
  (VTBL_ENTRY)&_ZN6S506C53v21Ev,
  (VTBL_ENTRY)&_ZN6S506C53v22Ev,
  (VTBL_ENTRY)&_ZN6S506C53v23Ev,
  (VTBL_ENTRY)&_ZN6S506C53v24Ev,
  (VTBL_ENTRY)&_ZN6S506C53v25Ev,
  (VTBL_ENTRY)&_ZN6S506C53v26Ev,
  (VTBL_ENTRY)&_ZN6S506C53v27Ev,
  (VTBL_ENTRY)&_ZN6S506C53v28Ev,
  (VTBL_ENTRY)&_ZN6S506C53v29Ev,
  (VTBL_ENTRY)&_ZN6S506C53v30Ev,
  (VTBL_ENTRY)&_ZN6S506C53v31Ev,
  (VTBL_ENTRY)&_ZN6S506C53v32Ev,
  (VTBL_ENTRY)&_ZN6S506C53v33Ev,
  (VTBL_ENTRY)&_ZN6S506C43v34Ev,
  (VTBL_ENTRY)&_ZN6S506C43v35Ev,
  (VTBL_ENTRY)&_ZN6S506C43v36Ev,
  (VTBL_ENTRY)&_ZN6S506C43v37Ev,
  (VTBL_ENTRY)&_ZN6S506C43v38Ev,
  (VTBL_ENTRY)&_ZN6S506C43v39Ev,
  (VTBL_ENTRY)&_ZN6S506C43v40Ev,
  (VTBL_ENTRY)&_ZN6S506C43v41Ev,
  (VTBL_ENTRY)&_ZN6S506C43v42Ev,
  (VTBL_ENTRY)&_ZN6S506C43v43Ev,
  (VTBL_ENTRY)&_ZN6S506C43v44Ev,
  (VTBL_ENTRY)&_ZN6S506C33v45Ev,
  (VTBL_ENTRY)&_ZN6S506C33v46Ev,
  (VTBL_ENTRY)&_ZN6S506C33v47Ev,
  (VTBL_ENTRY)&_ZN6S506C33v48Ev,
  (VTBL_ENTRY)&_ZN6S506C33v49Ev,
  (VTBL_ENTRY)&_ZN6S506C33v50Ev,
  (VTBL_ENTRY)&_ZN6S506C33v51Ev,
  (VTBL_ENTRY)&_ZN6S506C33v52Ev,
  (VTBL_ENTRY)&_ZN6S506C33v53Ev,
  (VTBL_ENTRY)&_ZN6S506C33v54Ev,
  (VTBL_ENTRY)&_ZN6S506C33v55Ev,
  (VTBL_ENTRY)&_ZN6S506C33v56Ev,
  (VTBL_ENTRY)&_ZN6S506C33v57Ev,
  (VTBL_ENTRY)&_ZN6S506C33v58Ev,
  (VTBL_ENTRY)&_ZN6S506C33v59Ev,
  (VTBL_ENTRY)&_ZN6S506C33v60Ev,
  (VTBL_ENTRY)&_ZN6S506C33v61Ev,
  (VTBL_ENTRY)&_ZN6S506C23v62Ev,
  (VTBL_ENTRY)&_ZN6S506C23v63Ev,
  (VTBL_ENTRY)&_ZN6S506C23v64Ev,
  (VTBL_ENTRY)&_ZN6S506C23v65Ev,
  (VTBL_ENTRY)&_ZN6S506C23v66Ev,
  (VTBL_ENTRY)&_ZN6S506C23v67Ev,
  (VTBL_ENTRY)&_ZN6S506C23v68Ev,
  (VTBL_ENTRY)&_ZN6S506C23v69Ev,
  (VTBL_ENTRY)&_ZN6S506C23v70Ev,
  (VTBL_ENTRY)&_ZN6S506C23v71Ev,
  (VTBL_ENTRY)&_ZN6S506C23v72Ev,
  (VTBL_ENTRY)&_ZN6S506C23v73Ev,
  (VTBL_ENTRY)&_ZN6S506C23v74Ev,
};
extern VTBL_ENTRY _ZTI6S506C2[];
extern  VTBL_ENTRY _ZTV6S506C2[];
Class_Descriptor cd_S506C2 = {  "S506C2", // class name
  bases_S506C2, 3,
  &(vtc_S506C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(200,140), // object size
  NSPAIRA(_ZTI6S506C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S506C2),58, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S506C1  : S506C2 {
  ::S1587C45 s506c1f0;
  ::S1587C38 s506c1f1;
  void *s506c1f2;
  ::S1587C22 s506c1f3;
  void *s506c1f4;
  __tsi64 s506c1f5;
  ::S887C17 s506c1f6;
  int s506c1f7[3];
  __tsi64 s506c1f8[2];
  int s506c1f9[3];
  char s506c1f10;
  int s506c1f11[2];
  char s506c1f12;
  ::S1587C31 s506c1f13[150];
  int s506c1f14[2];
  void *s506c1f15;
  int s506c1f16[2];
  __tsi64 s506c1f17;
  void *s506c1f18[2];
  int s506c1f19[5];
  char s506c1f20;
  virtual  ~S506C1(); // _ZN6S506C1D1Ev
  virtual void  v1(); // _ZN6S506C12v1Ev
  virtual void  v2(); // _ZN6S506C12v2Ev
  virtual void  v3(); // _ZN6S506C12v3Ev
  virtual void  v4(); // _ZN6S506C12v4Ev
  virtual void  v5(); // _ZN6S506C12v5Ev
  virtual void  v6(); // _ZN6S506C12v6Ev
  virtual void  v7(); // _ZN6S506C12v7Ev
  virtual void  v8(); // _ZN6S506C12v8Ev
  virtual void  v9(); // _ZN6S506C12v9Ev
  virtual void  v10(); // _ZN6S506C13v10Ev
  virtual void  v11(); // _ZN6S506C13v11Ev
  virtual void  v12(); // _ZN6S506C13v12Ev
  virtual void  v13(); // _ZN6S506C13v13Ev
  virtual void  v14(); // _ZN6S506C13v14Ev
  virtual void  v15(); // _ZN6S506C13v15Ev
  virtual void  v16(); // _ZN6S506C13v16Ev
  virtual void  v17(); // _ZN6S506C13v17Ev
  virtual void  v18(); // _ZN6S506C13v18Ev
  virtual void  v19(); // _ZN6S506C13v19Ev
  virtual void  v20(); // _ZN6S506C13v20Ev
  S506C1(); // tgen
};
//SIG(1 S506C1) C1{ BC2{ BC3{ BC4{ BC5{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 Fp FC6{ m FC7{ m Fp Fi FC8{ m}} Fi} Fc Fi} vd v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 Fp[3] Fi} vd v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 Fp[2] Fi[3] FC6 Fc FC9{ m FC10{ m FL}} Fc Fi Fc Fi Fc[2] Fi Fc} vd v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 Fi[4]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 FC11{ m Fp[2]} FC12{ m Fp[2]} Fp FC13{ m Fp[2]} Fp FL FC14{ m Fp Fi[2] FC8} Fi[3] FL[2] Fi[3] Fc Fi[2] Fc FC15{ BC16{ vd v77 v78 v79 FL Fp Fi} vd v75 v76 Fi Fc}[150] Fi[2] Fp Fi[2] FL Fp[2] Fi[5] Fc}


 S506C1 ::~S506C1(){ note_dtor("S506C1", this);}
void  S506C1 ::v1(){vfunc_called(this, "_ZN6S506C12v1Ev");}
void  S506C1 ::v2(){vfunc_called(this, "_ZN6S506C12v2Ev");}
void  S506C1 ::v3(){vfunc_called(this, "_ZN6S506C12v3Ev");}
void  S506C1 ::v4(){vfunc_called(this, "_ZN6S506C12v4Ev");}
void  S506C1 ::v5(){vfunc_called(this, "_ZN6S506C12v5Ev");}
void  S506C1 ::v6(){vfunc_called(this, "_ZN6S506C12v6Ev");}
void  S506C1 ::v7(){vfunc_called(this, "_ZN6S506C12v7Ev");}
void  S506C1 ::v8(){vfunc_called(this, "_ZN6S506C12v8Ev");}
void  S506C1 ::v9(){vfunc_called(this, "_ZN6S506C12v9Ev");}
void  S506C1 ::v10(){vfunc_called(this, "_ZN6S506C13v10Ev");}
void  S506C1 ::v11(){vfunc_called(this, "_ZN6S506C13v11Ev");}
void  S506C1 ::v12(){vfunc_called(this, "_ZN6S506C13v12Ev");}
void  S506C1 ::v13(){vfunc_called(this, "_ZN6S506C13v13Ev");}
void  S506C1 ::v14(){vfunc_called(this, "_ZN6S506C13v14Ev");}
void  S506C1 ::v15(){vfunc_called(this, "_ZN6S506C13v15Ev");}
void  S506C1 ::v16(){vfunc_called(this, "_ZN6S506C13v16Ev");}
void  S506C1 ::v17(){vfunc_called(this, "_ZN6S506C13v17Ev");}
void  S506C1 ::v18(){vfunc_called(this, "_ZN6S506C13v18Ev");}
void  S506C1 ::v19(){vfunc_called(this, "_ZN6S506C13v19Ev");}
void  S506C1 ::v20(){vfunc_called(this, "_ZN6S506C13v20Ev");}
S506C1 ::S506C1(){ note_ctor("S506C1", this);} // tgen

static void Test_S506C1()
{
  extern Class_Descriptor cd_S506C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(805,1129)];
    init_test(&cd_S506C1, buf);
    S506C1 *dp, &lv = *(dp=new (buf) S506C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(6432,4512), "sizeof(S506C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S506C1)");
    check_base_class_offset(lv, (S506C5*)(S506C4*)(S506C3*)(S506C2*), 0, "S506C1");
    check_base_class_offset(lv, (S506C4*)(S506C3*)(S506C2*), 0, "S506C1");
    check_base_class_offset(lv, (S506C3*)(S506C2*), 0, "S506C1");
    check_base_class_offset(lv, (S506C2*), 0, "S506C1");
    check_field_offset(lv, s506c1f0, ABISELECT(200,140), "S506C1.s506c1f0");
    check_field_offset(lv, s506c1f1, ABISELECT(216,148), "S506C1.s506c1f1");
    check_field_offset(lv, s506c1f2, ABISELECT(232,156), "S506C1.s506c1f2");
    check_field_offset(lv, s506c1f3, ABISELECT(240,160), "S506C1.s506c1f3");
    check_field_offset(lv, s506c1f4, ABISELECT(256,168), "S506C1.s506c1f4");
    check_field_offset(lv, s506c1f5, ABISELECT(264,172), "S506C1.s506c1f5");
    check_field_offset(lv, s506c1f6, ABISELECT(272,180), "S506C1.s506c1f6");
    check_field_offset(lv, s506c1f7, ABISELECT(296,196), "S506C1.s506c1f7");
    check_field_offset(lv, s506c1f8, ABISELECT(312,208), "S506C1.s506c1f8");
    check_field_offset(lv, s506c1f9, ABISELECT(328,224), "S506C1.s506c1f9");
    check_field_offset(lv, s506c1f10, ABISELECT(340,236), "S506C1.s506c1f10");
    check_field_offset(lv, s506c1f11, ABISELECT(344,240), "S506C1.s506c1f11");
    check_field_offset(lv, s506c1f12, ABISELECT(352,248), "S506C1.s506c1f12");
    check_field_offset(lv, s506c1f13, ABISELECT(360,252), "S506C1.s506c1f13");
    check_field_offset(lv, s506c1f14, ABISELECT(6360,4452), "S506C1.s506c1f14");
    check_field_offset(lv, s506c1f15, ABISELECT(6368,4460), "S506C1.s506c1f15");
    check_field_offset(lv, s506c1f16, ABISELECT(6376,4464), "S506C1.s506c1f16");
    check_field_offset(lv, s506c1f17, ABISELECT(6384,4472), "S506C1.s506c1f17");
    check_field_offset(lv, s506c1f18, ABISELECT(6392,4480), "S506C1.s506c1f18");
    check_field_offset(lv, s506c1f19, ABISELECT(6408,4488), "S506C1.s506c1f19");
    check_field_offset(lv, s506c1f20, ABISELECT(6428,4508), "S506C1.s506c1f20");
    test_class_info(&lv, &cd_S506C1);
    dp->~S506C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS506C1(Test_S506C1, "S506C1", ABISELECT(6432,4512));

#else // __cplusplus

extern void _ZN6S506C1C1Ev();
extern void _ZN6S506C1D1Ev();
Name_Map name_map_S506C1[] = {
  NSPAIR(_ZN6S506C1C1Ev),
  NSPAIR(_ZN6S506C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S506C5;
extern VTBL_ENTRY _ZTI6S506C5[];
extern  VTBL_ENTRY _ZTV6S506C5[];
extern Class_Descriptor cd_S506C4;
extern VTBL_ENTRY _ZTI6S506C4[];
extern  VTBL_ENTRY _ZTV6S506C4[];
extern Class_Descriptor cd_S506C3;
extern VTBL_ENTRY _ZTI6S506C3[];
extern  VTBL_ENTRY _ZTV6S506C3[];
extern Class_Descriptor cd_S506C2;
extern VTBL_ENTRY _ZTI6S506C2[];
extern  VTBL_ENTRY _ZTV6S506C2[];
static Base_Class bases_S506C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S506C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S506C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S506C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S506C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI6S506C1[];
extern void _ZN6S506C1D1Ev();
extern void _ZN6S506C1D0Ev();
extern void _ZN6S506C53v21Ev();
extern void _ZN6S506C53v22Ev();
extern void _ZN6S506C53v23Ev();
extern void _ZN6S506C53v24Ev();
extern void _ZN6S506C53v25Ev();
extern void _ZN6S506C53v26Ev();
extern void _ZN6S506C53v27Ev();
extern void _ZN6S506C53v28Ev();
extern void _ZN6S506C53v29Ev();
extern void _ZN6S506C53v30Ev();
extern void _ZN6S506C53v31Ev();
extern void _ZN6S506C53v32Ev();
extern void _ZN6S506C53v33Ev();
extern void _ZN6S506C43v34Ev();
extern void _ZN6S506C43v35Ev();
extern void _ZN6S506C43v36Ev();
extern void _ZN6S506C43v37Ev();
extern void _ZN6S506C43v38Ev();
extern void _ZN6S506C43v39Ev();
extern void _ZN6S506C43v40Ev();
extern void _ZN6S506C43v41Ev();
extern void _ZN6S506C43v42Ev();
extern void _ZN6S506C43v43Ev();
extern void _ZN6S506C43v44Ev();
extern void _ZN6S506C33v45Ev();
extern void _ZN6S506C33v46Ev();
extern void _ZN6S506C33v47Ev();
extern void _ZN6S506C33v48Ev();
extern void _ZN6S506C33v49Ev();
extern void _ZN6S506C33v50Ev();
extern void _ZN6S506C33v51Ev();
extern void _ZN6S506C33v52Ev();
extern void _ZN6S506C33v53Ev();
extern void _ZN6S506C33v54Ev();
extern void _ZN6S506C33v55Ev();
extern void _ZN6S506C33v56Ev();
extern void _ZN6S506C33v57Ev();
extern void _ZN6S506C33v58Ev();
extern void _ZN6S506C33v59Ev();
extern void _ZN6S506C33v60Ev();
extern void _ZN6S506C33v61Ev();
extern void _ZN6S506C23v62Ev();
extern void _ZN6S506C23v63Ev();
extern void _ZN6S506C23v64Ev();
extern void _ZN6S506C23v65Ev();
extern void _ZN6S506C23v66Ev();
extern void _ZN6S506C23v67Ev();
extern void _ZN6S506C23v68Ev();
extern void _ZN6S506C23v69Ev();
extern void _ZN6S506C23v70Ev();
extern void _ZN6S506C23v71Ev();
extern void _ZN6S506C23v72Ev();
extern void _ZN6S506C23v73Ev();
extern void _ZN6S506C23v74Ev();
extern void _ZN6S506C12v1Ev();
extern void _ZN6S506C12v2Ev();
extern void _ZN6S506C12v3Ev();
extern void _ZN6S506C12v4Ev();
extern void _ZN6S506C12v5Ev();
extern void _ZN6S506C12v6Ev();
extern void _ZN6S506C12v7Ev();
extern void _ZN6S506C12v8Ev();
extern void _ZN6S506C12v9Ev();
extern void _ZN6S506C13v10Ev();
extern void _ZN6S506C13v11Ev();
extern void _ZN6S506C13v12Ev();
extern void _ZN6S506C13v13Ev();
extern void _ZN6S506C13v14Ev();
extern void _ZN6S506C13v15Ev();
extern void _ZN6S506C13v16Ev();
extern void _ZN6S506C13v17Ev();
extern void _ZN6S506C13v18Ev();
extern void _ZN6S506C13v19Ev();
extern void _ZN6S506C13v20Ev();
static  VTBL_ENTRY vtc_S506C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI6S506C1[0]),
  (VTBL_ENTRY)&_ZN6S506C1D1Ev,
  (VTBL_ENTRY)&_ZN6S506C1D0Ev,
  (VTBL_ENTRY)&_ZN6S506C53v21Ev,
  (VTBL_ENTRY)&_ZN6S506C53v22Ev,
  (VTBL_ENTRY)&_ZN6S506C53v23Ev,
  (VTBL_ENTRY)&_ZN6S506C53v24Ev,
  (VTBL_ENTRY)&_ZN6S506C53v25Ev,
  (VTBL_ENTRY)&_ZN6S506C53v26Ev,
  (VTBL_ENTRY)&_ZN6S506C53v27Ev,
  (VTBL_ENTRY)&_ZN6S506C53v28Ev,
  (VTBL_ENTRY)&_ZN6S506C53v29Ev,
  (VTBL_ENTRY)&_ZN6S506C53v30Ev,
  (VTBL_ENTRY)&_ZN6S506C53v31Ev,
  (VTBL_ENTRY)&_ZN6S506C53v32Ev,
  (VTBL_ENTRY)&_ZN6S506C53v33Ev,
  (VTBL_ENTRY)&_ZN6S506C43v34Ev,
  (VTBL_ENTRY)&_ZN6S506C43v35Ev,
  (VTBL_ENTRY)&_ZN6S506C43v36Ev,
  (VTBL_ENTRY)&_ZN6S506C43v37Ev,
  (VTBL_ENTRY)&_ZN6S506C43v38Ev,
  (VTBL_ENTRY)&_ZN6S506C43v39Ev,
  (VTBL_ENTRY)&_ZN6S506C43v40Ev,
  (VTBL_ENTRY)&_ZN6S506C43v41Ev,
  (VTBL_ENTRY)&_ZN6S506C43v42Ev,
  (VTBL_ENTRY)&_ZN6S506C43v43Ev,
  (VTBL_ENTRY)&_ZN6S506C43v44Ev,
  (VTBL_ENTRY)&_ZN6S506C33v45Ev,
  (VTBL_ENTRY)&_ZN6S506C33v46Ev,
  (VTBL_ENTRY)&_ZN6S506C33v47Ev,
  (VTBL_ENTRY)&_ZN6S506C33v48Ev,
  (VTBL_ENTRY)&_ZN6S506C33v49Ev,
  (VTBL_ENTRY)&_ZN6S506C33v50Ev,
  (VTBL_ENTRY)&_ZN6S506C33v51Ev,
  (VTBL_ENTRY)&_ZN6S506C33v52Ev,
  (VTBL_ENTRY)&_ZN6S506C33v53Ev,
  (VTBL_ENTRY)&_ZN6S506C33v54Ev,
  (VTBL_ENTRY)&_ZN6S506C33v55Ev,
  (VTBL_ENTRY)&_ZN6S506C33v56Ev,
  (VTBL_ENTRY)&_ZN6S506C33v57Ev,
  (VTBL_ENTRY)&_ZN6S506C33v58Ev,
  (VTBL_ENTRY)&_ZN6S506C33v59Ev,
  (VTBL_ENTRY)&_ZN6S506C33v60Ev,
  (VTBL_ENTRY)&_ZN6S506C33v61Ev,
  (VTBL_ENTRY)&_ZN6S506C23v62Ev,
  (VTBL_ENTRY)&_ZN6S506C23v63Ev,
  (VTBL_ENTRY)&_ZN6S506C23v64Ev,
  (VTBL_ENTRY)&_ZN6S506C23v65Ev,
  (VTBL_ENTRY)&_ZN6S506C23v66Ev,
  (VTBL_ENTRY)&_ZN6S506C23v67Ev,
  (VTBL_ENTRY)&_ZN6S506C23v68Ev,
  (VTBL_ENTRY)&_ZN6S506C23v69Ev,
  (VTBL_ENTRY)&_ZN6S506C23v70Ev,
  (VTBL_ENTRY)&_ZN6S506C23v71Ev,
  (VTBL_ENTRY)&_ZN6S506C23v72Ev,
  (VTBL_ENTRY)&_ZN6S506C23v73Ev,
  (VTBL_ENTRY)&_ZN6S506C23v74Ev,
  (VTBL_ENTRY)&_ZN6S506C12v1Ev,
  (VTBL_ENTRY)&_ZN6S506C12v2Ev,
  (VTBL_ENTRY)&_ZN6S506C12v3Ev,
  (VTBL_ENTRY)&_ZN6S506C12v4Ev,
  (VTBL_ENTRY)&_ZN6S506C12v5Ev,
  (VTBL_ENTRY)&_ZN6S506C12v6Ev,
  (VTBL_ENTRY)&_ZN6S506C12v7Ev,
  (VTBL_ENTRY)&_ZN6S506C12v8Ev,
  (VTBL_ENTRY)&_ZN6S506C12v9Ev,
  (VTBL_ENTRY)&_ZN6S506C13v10Ev,
  (VTBL_ENTRY)&_ZN6S506C13v11Ev,
  (VTBL_ENTRY)&_ZN6S506C13v12Ev,
  (VTBL_ENTRY)&_ZN6S506C13v13Ev,
  (VTBL_ENTRY)&_ZN6S506C13v14Ev,
  (VTBL_ENTRY)&_ZN6S506C13v15Ev,
  (VTBL_ENTRY)&_ZN6S506C13v16Ev,
  (VTBL_ENTRY)&_ZN6S506C13v17Ev,
  (VTBL_ENTRY)&_ZN6S506C13v18Ev,
  (VTBL_ENTRY)&_ZN6S506C13v19Ev,
  (VTBL_ENTRY)&_ZN6S506C13v20Ev,
};
extern VTBL_ENTRY _ZTI6S506C1[];
extern  VTBL_ENTRY _ZTV6S506C1[];
Class_Descriptor cd_S506C1 = {  "S506C1", // class name
  bases_S506C1, 4,
  &(vtc_S506C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(6432,4512), // object size
  NSPAIRA(_ZTI6S506C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV6S506C1),78, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2209C4  {
  void *s2209c4f0;
  ::S886C6_nt s2209c4f1;
  ::S2402C18_nt s2209c4f2;
  char s2209c4f3;
  virtual  ~S2209C4(); // _ZN7S2209C4D1Ev
  virtual void  v3(); // _ZN7S2209C42v3Ev
  virtual void  v4(); // _ZN7S2209C42v4Ev
  virtual void  v5(); // _ZN7S2209C42v5Ev
  virtual void  v6(); // _ZN7S2209C42v6Ev
  virtual void  v7(); // _ZN7S2209C42v7Ev
  virtual void  v8(); // _ZN7S2209C42v8Ev
  virtual void  v9(); // _ZN7S2209C42v9Ev
  virtual void  v10(); // _ZN7S2209C43v10Ev
  virtual void  v11(); // _ZN7S2209C43v11Ev
  virtual void  v12(); // _ZN7S2209C43v12Ev
  virtual void  v13(); // _ZN7S2209C43v13Ev
  virtual void  v14(); // _ZN7S2209C43v14Ev
  S2209C4(); // tgen
};
//SIG(-1 S2209C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fp FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}} FC6{ m FC7{ FL[4]}} Fc}


 S2209C4 ::~S2209C4(){ note_dtor("S2209C4", this);}
void  S2209C4 ::v3(){vfunc_called(this, "_ZN7S2209C42v3Ev");}
void  S2209C4 ::v4(){vfunc_called(this, "_ZN7S2209C42v4Ev");}
void  S2209C4 ::v5(){vfunc_called(this, "_ZN7S2209C42v5Ev");}
void  S2209C4 ::v6(){vfunc_called(this, "_ZN7S2209C42v6Ev");}
void  S2209C4 ::v7(){vfunc_called(this, "_ZN7S2209C42v7Ev");}
void  S2209C4 ::v8(){vfunc_called(this, "_ZN7S2209C42v8Ev");}
void  S2209C4 ::v9(){vfunc_called(this, "_ZN7S2209C42v9Ev");}
void  S2209C4 ::v10(){vfunc_called(this, "_ZN7S2209C43v10Ev");}
void  S2209C4 ::v11(){vfunc_called(this, "_ZN7S2209C43v11Ev");}
void  S2209C4 ::v12(){vfunc_called(this, "_ZN7S2209C43v12Ev");}
void  S2209C4 ::v13(){vfunc_called(this, "_ZN7S2209C43v13Ev");}
void  S2209C4 ::v14(){vfunc_called(this, "_ZN7S2209C43v14Ev");}
S2209C4 ::S2209C4(){ note_ctor("S2209C4", this);} // tgen

static void Test_S2209C4()
{
  extern Class_Descriptor cd_S2209C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S2209C4, buf);
    S2209C4 *dp, &lv = *(dp=new (buf) S2209C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S2209C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2209C4)");
    check_field_offset(lv, s2209c4f0, ABISELECT(8,4), "S2209C4.s2209c4f0");
    check_field_offset(lv, s2209c4f1, ABISELECT(16,8), "S2209C4.s2209c4f1");
    check_field_offset(lv, s2209c4f2, ABISELECT(32,20), "S2209C4.s2209c4f2");
    check_field_offset(lv, s2209c4f3, ABISELECT(64,52), "S2209C4.s2209c4f3");
    test_class_info(&lv, &cd_S2209C4);
    dp->~S2209C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2209C4(Test_S2209C4, "S2209C4", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN7S2209C4C1Ev();
extern void _ZN7S2209C4D1Ev();
Name_Map name_map_S2209C4[] = {
  NSPAIR(_ZN7S2209C4C1Ev),
  NSPAIR(_ZN7S2209C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2209C4[];
extern void _ZN7S2209C4D1Ev();
extern void _ZN7S2209C4D0Ev();
extern void _ZN7S2209C42v3Ev();
extern void _ZN7S2209C42v4Ev();
extern void _ZN7S2209C42v5Ev();
extern void _ZN7S2209C42v6Ev();
extern void _ZN7S2209C42v7Ev();
extern void _ZN7S2209C42v8Ev();
extern void _ZN7S2209C42v9Ev();
extern void _ZN7S2209C43v10Ev();
extern void _ZN7S2209C43v11Ev();
extern void _ZN7S2209C43v12Ev();
extern void _ZN7S2209C43v13Ev();
extern void _ZN7S2209C43v14Ev();
static  VTBL_ENTRY vtc_S2209C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2209C4[0]),
  (VTBL_ENTRY)&_ZN7S2209C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2209C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2209C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2209C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2209C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2209C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2209C43v14Ev,
};
extern VTBL_ENTRY _ZTI7S2209C4[];
extern  VTBL_ENTRY _ZTV7S2209C4[];
Class_Descriptor cd_S2209C4 = {  "S2209C4", // class name
  0,0,//no base classes
  &(vtc_S2209C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI7S2209C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2209C4),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2209C3  : S2209C4 {
  ::S887C17 s2209c3f0;
  virtual  ~S2209C3(); // _ZN7S2209C3D1Ev
  virtual void  v15(); // _ZN7S2209C33v15Ev
  virtual void  v16(); // _ZN7S2209C33v16Ev
  virtual void  v17(); // _ZN7S2209C33v17Ev
  virtual void  v18(); // _ZN7S2209C33v18Ev
  virtual void  v19(); // _ZN7S2209C33v19Ev
  virtual void  v20(); // _ZN7S2209C33v20Ev
  virtual void  v21(); // _ZN7S2209C33v21Ev
  S2209C3(); // tgen
};
//SIG(-1 S2209C3) C1{ BC2{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 Fp FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}} FC7{ m FC8{ FL[4]}} Fc} vd v1 v2 v3 v4 v5 v6 v7 FC9{ m Fp Fi[2] FC5}}


 S2209C3 ::~S2209C3(){ note_dtor("S2209C3", this);}
void  S2209C3 ::v15(){vfunc_called(this, "_ZN7S2209C33v15Ev");}
void  S2209C3 ::v16(){vfunc_called(this, "_ZN7S2209C33v16Ev");}
void  S2209C3 ::v17(){vfunc_called(this, "_ZN7S2209C33v17Ev");}
void  S2209C3 ::v18(){vfunc_called(this, "_ZN7S2209C33v18Ev");}
void  S2209C3 ::v19(){vfunc_called(this, "_ZN7S2209C33v19Ev");}
void  S2209C3 ::v20(){vfunc_called(this, "_ZN7S2209C33v20Ev");}
void  S2209C3 ::v21(){vfunc_called(this, "_ZN7S2209C33v21Ev");}
S2209C3 ::S2209C3(){ note_ctor("S2209C3", this);} // tgen

static void Test_S2209C3()
{
  extern Class_Descriptor cd_S2209C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,19)];
    init_test(&cd_S2209C3, buf);
    S2209C3 *dp, &lv = *(dp=new (buf) S2209C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,72), "sizeof(S2209C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2209C3)");
    check_base_class_offset(lv, (S2209C4*), 0, "S2209C3");
    check_field_offset(lv, s2209c3f0, ABISELECT(72,56), "S2209C3.s2209c3f0");
    test_class_info(&lv, &cd_S2209C3);
    dp->~S2209C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2209C3(Test_S2209C3, "S2209C3", ABISELECT(96,72));

#else // __cplusplus

extern void _ZN7S2209C3C1Ev();
extern void _ZN7S2209C3D1Ev();
Name_Map name_map_S2209C3[] = {
  NSPAIR(_ZN7S2209C3C1Ev),
  NSPAIR(_ZN7S2209C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2209C4;
extern VTBL_ENTRY _ZTI7S2209C4[];
extern  VTBL_ENTRY _ZTV7S2209C4[];
static Base_Class bases_S2209C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2209C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2209C3[];
extern void _ZN7S2209C3D1Ev();
extern void _ZN7S2209C3D0Ev();
extern void _ZN7S2209C42v3Ev();
extern void _ZN7S2209C42v4Ev();
extern void _ZN7S2209C42v5Ev();
extern void _ZN7S2209C42v6Ev();
extern void _ZN7S2209C42v7Ev();
extern void _ZN7S2209C42v8Ev();
extern void _ZN7S2209C42v9Ev();
extern void _ZN7S2209C43v10Ev();
extern void _ZN7S2209C43v11Ev();
extern void _ZN7S2209C43v12Ev();
extern void _ZN7S2209C43v13Ev();
extern void _ZN7S2209C43v14Ev();
extern void _ZN7S2209C33v15Ev();
extern void _ZN7S2209C33v16Ev();
extern void _ZN7S2209C33v17Ev();
extern void _ZN7S2209C33v18Ev();
extern void _ZN7S2209C33v19Ev();
extern void _ZN7S2209C33v20Ev();
extern void _ZN7S2209C33v21Ev();
static  VTBL_ENTRY vtc_S2209C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2209C3[0]),
  (VTBL_ENTRY)&_ZN7S2209C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2209C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2209C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2209C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2209C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2209C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2209C43v14Ev,
  (VTBL_ENTRY)&_ZN7S2209C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2209C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2209C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2209C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2209C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2209C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2209C33v21Ev,
};
extern VTBL_ENTRY _ZTI7S2209C3[];
extern  VTBL_ENTRY _ZTV7S2209C3[];
Class_Descriptor cd_S2209C3 = {  "S2209C3", // class name
  bases_S2209C3, 1,
  &(vtc_S2209C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,72), // object size
  NSPAIRA(_ZTI7S2209C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2209C3),23, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2209C15  {
  virtual  ~S2209C15(); // _ZN8S2209C15D1Ev
  virtual void  v22(); // _ZN8S2209C153v22Ev
  virtual void  v23(); // _ZN8S2209C153v23Ev
  virtual void  v24(); // _ZN8S2209C153v24Ev
  S2209C15(); // tgen
};
//SIG(-1 S2209C15) C1{ vd v1 v2 v3}


 S2209C15 ::~S2209C15(){ note_dtor("S2209C15", this);}
void  S2209C15 ::v22(){vfunc_called(this, "_ZN8S2209C153v22Ev");}
void  S2209C15 ::v23(){vfunc_called(this, "_ZN8S2209C153v23Ev");}
void  S2209C15 ::v24(){vfunc_called(this, "_ZN8S2209C153v24Ev");}
S2209C15 ::S2209C15(){ note_ctor("S2209C15", this);} // tgen

static void Test_S2209C15()
{
  extern Class_Descriptor cd_S2209C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2209C15, buf);
    S2209C15 *dp, &lv = *(dp=new (buf) S2209C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2209C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2209C15)");
    test_class_info(&lv, &cd_S2209C15);
    dp->~S2209C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2209C15(Test_S2209C15, "S2209C15", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2209C15C1Ev();
extern void _ZN8S2209C15D1Ev();
Name_Map name_map_S2209C15[] = {
  NSPAIR(_ZN8S2209C15C1Ev),
  NSPAIR(_ZN8S2209C15D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2209C15[];
extern void _ZN8S2209C15D1Ev();
extern void _ZN8S2209C15D0Ev();
extern void _ZN8S2209C153v22Ev();
extern void _ZN8S2209C153v23Ev();
extern void _ZN8S2209C153v24Ev();
static  VTBL_ENTRY vtc_S2209C15[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2209C15[0]),
  (VTBL_ENTRY)&_ZN8S2209C15D1Ev,
  (VTBL_ENTRY)&_ZN8S2209C15D0Ev,
  (VTBL_ENTRY)&_ZN8S2209C153v22Ev,
  (VTBL_ENTRY)&_ZN8S2209C153v23Ev,
  (VTBL_ENTRY)&_ZN8S2209C153v24Ev,
};
extern VTBL_ENTRY _ZTI8S2209C15[];
extern  VTBL_ENTRY _ZTV8S2209C15[];
Class_Descriptor cd_S2209C15 = {  "S2209C15", // class name
  0,0,//no base classes
  &(vtc_S2209C15[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2209C15),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2209C15),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2209C14  : S2209C15 {
  virtual  ~S2209C14(); // _ZN8S2209C14D1Ev
  virtual void  v25(); // _ZN8S2209C143v25Ev
  virtual void  v26(); // _ZN8S2209C143v26Ev
  virtual void  v27(); // _ZN8S2209C143v27Ev
  virtual void  v28(); // _ZN8S2209C143v28Ev
  S2209C14(); // tgen
};
//SIG(-1 S2209C14) C1{ BC2{ vd v5 v6 v7} vd v1 v2 v3 v4}


 S2209C14 ::~S2209C14(){ note_dtor("S2209C14", this);}
void  S2209C14 ::v25(){vfunc_called(this, "_ZN8S2209C143v25Ev");}
void  S2209C14 ::v26(){vfunc_called(this, "_ZN8S2209C143v26Ev");}
void  S2209C14 ::v27(){vfunc_called(this, "_ZN8S2209C143v27Ev");}
void  S2209C14 ::v28(){vfunc_called(this, "_ZN8S2209C143v28Ev");}
S2209C14 ::S2209C14(){ note_ctor("S2209C14", this);} // tgen

static void Test_S2209C14()
{
  extern Class_Descriptor cd_S2209C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2209C14, buf);
    S2209C14 *dp, &lv = *(dp=new (buf) S2209C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2209C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2209C14)");
    check_base_class_offset(lv, (S2209C15*), 0, "S2209C14");
    test_class_info(&lv, &cd_S2209C14);
    dp->~S2209C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2209C14(Test_S2209C14, "S2209C14", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2209C14C1Ev();
extern void _ZN8S2209C14D1Ev();
Name_Map name_map_S2209C14[] = {
  NSPAIR(_ZN8S2209C14C1Ev),
  NSPAIR(_ZN8S2209C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2209C15;
extern VTBL_ENTRY _ZTI8S2209C15[];
extern  VTBL_ENTRY _ZTV8S2209C15[];
static Base_Class bases_S2209C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2209C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S2209C14[];
extern void _ZN8S2209C14D1Ev();
extern void _ZN8S2209C14D0Ev();
extern void _ZN8S2209C153v22Ev();
extern void _ZN8S2209C153v23Ev();
extern void _ZN8S2209C153v24Ev();
extern void _ZN8S2209C143v25Ev();
extern void _ZN8S2209C143v26Ev();
extern void _ZN8S2209C143v27Ev();
extern void _ZN8S2209C143v28Ev();
static  VTBL_ENTRY vtc_S2209C14[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2209C14[0]),
  (VTBL_ENTRY)&_ZN8S2209C14D1Ev,
  (VTBL_ENTRY)&_ZN8S2209C14D0Ev,
  (VTBL_ENTRY)&_ZN8S2209C153v22Ev,
  (VTBL_ENTRY)&_ZN8S2209C153v23Ev,
  (VTBL_ENTRY)&_ZN8S2209C153v24Ev,
  (VTBL_ENTRY)&_ZN8S2209C143v25Ev,
  (VTBL_ENTRY)&_ZN8S2209C143v26Ev,
  (VTBL_ENTRY)&_ZN8S2209C143v27Ev,
  (VTBL_ENTRY)&_ZN8S2209C143v28Ev,
};
extern VTBL_ENTRY _ZTI8S2209C14[];
extern  VTBL_ENTRY _ZTV8S2209C14[];
Class_Descriptor cd_S2209C14 = {  "S2209C14", // class name
  bases_S2209C14, 1,
  &(vtc_S2209C14[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2209C14),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S2209C14),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2209C13  : S2209C14 {
  ::S886C12_nt s2209c13f0;
  ::S887C10_nt s2209c13f1;
  char s2209c13f2;
  virtual  ~S2209C13(); // _ZN8S2209C13D1Ev
  virtual void  v29(); // _ZN8S2209C133v29Ev
  virtual void  v30(); // _ZN8S2209C133v30Ev
  virtual void  v31(); // _ZN8S2209C133v31Ev
  S2209C13(); // tgen
};
//SIG(-1 S2209C13) C1{ BC2{ BC3{ vd v4 v5 v6} vd v7 v8 v9 v10} vd v1 v2 v3 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ FL[4]}} Fc}


 S2209C13 ::~S2209C13(){ note_dtor("S2209C13", this);}
void  S2209C13 ::v29(){vfunc_called(this, "_ZN8S2209C133v29Ev");}
void  S2209C13 ::v30(){vfunc_called(this, "_ZN8S2209C133v30Ev");}
void  S2209C13 ::v31(){vfunc_called(this, "_ZN8S2209C133v31Ev");}
S2209C13 ::S2209C13(){ note_ctor("S2209C13", this);} // tgen

static void Test_S2209C13()
{
  extern Class_Descriptor cd_S2209C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,15)];
    init_test(&cd_S2209C13, buf);
    S2209C13 *dp, &lv = *(dp=new (buf) S2209C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,56), "sizeof(S2209C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2209C13)");
    check_base_class_offset(lv, (S2209C15*)(S2209C14*), 0, "S2209C13");
    check_base_class_offset(lv, (S2209C14*), 0, "S2209C13");
    check_field_offset(lv, s2209c13f0, ABISELECT(8,4), "S2209C13.s2209c13f0");
    check_field_offset(lv, s2209c13f1, ABISELECT(32,20), "S2209C13.s2209c13f1");
    check_field_offset(lv, s2209c13f2, ABISELECT(64,52), "S2209C13.s2209c13f2");
    test_class_info(&lv, &cd_S2209C13);
    dp->~S2209C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2209C13(Test_S2209C13, "S2209C13", ABISELECT(72,56));

#else // __cplusplus

extern void _ZN8S2209C13C1Ev();
extern void _ZN8S2209C13D1Ev();
Name_Map name_map_S2209C13[] = {
  NSPAIR(_ZN8S2209C13C1Ev),
  NSPAIR(_ZN8S2209C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2209C15;
extern VTBL_ENTRY _ZTI8S2209C15[];
extern  VTBL_ENTRY _ZTV8S2209C15[];
extern Class_Descriptor cd_S2209C14;
extern VTBL_ENTRY _ZTI8S2209C14[];
extern  VTBL_ENTRY _ZTV8S2209C14[];
static Base_Class bases_S2209C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2209C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2209C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S2209C13[];
extern void _ZN8S2209C13D1Ev();
extern void _ZN8S2209C13D0Ev();
extern void _ZN8S2209C153v22Ev();
extern void _ZN8S2209C153v23Ev();
extern void _ZN8S2209C153v24Ev();
extern void _ZN8S2209C143v25Ev();
extern void _ZN8S2209C143v26Ev();
extern void _ZN8S2209C143v27Ev();
extern void _ZN8S2209C143v28Ev();
extern void _ZN8S2209C133v29Ev();
extern void _ZN8S2209C133v30Ev();
extern void _ZN8S2209C133v31Ev();
static  VTBL_ENTRY vtc_S2209C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2209C13[0]),
  (VTBL_ENTRY)&_ZN8S2209C13D1Ev,
  (VTBL_ENTRY)&_ZN8S2209C13D0Ev,
  (VTBL_ENTRY)&_ZN8S2209C153v22Ev,
  (VTBL_ENTRY)&_ZN8S2209C153v23Ev,
  (VTBL_ENTRY)&_ZN8S2209C153v24Ev,
  (VTBL_ENTRY)&_ZN8S2209C143v25Ev,
  (VTBL_ENTRY)&_ZN8S2209C143v26Ev,
  (VTBL_ENTRY)&_ZN8S2209C143v27Ev,
  (VTBL_ENTRY)&_ZN8S2209C143v28Ev,
  (VTBL_ENTRY)&_ZN8S2209C133v29Ev,
  (VTBL_ENTRY)&_ZN8S2209C133v30Ev,
  (VTBL_ENTRY)&_ZN8S2209C133v31Ev,
};
extern VTBL_ENTRY _ZTI8S2209C13[];
extern  VTBL_ENTRY _ZTV8S2209C13[];
Class_Descriptor cd_S2209C13 = {  "S2209C13", // class name
  bases_S2209C13, 2,
  &(vtc_S2209C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,56), // object size
  NSPAIRA(_ZTI8S2209C13),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S2209C13),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2209C19  {
  virtual  ~S2209C19(); // _ZN8S2209C19D1Ev
  virtual void  v32(); // _ZN8S2209C193v32Ev
  virtual void  v33(); // _ZN8S2209C193v33Ev
  virtual void  v34(); // _ZN8S2209C193v34Ev
  virtual void  v35(); // _ZN8S2209C193v35Ev
  virtual void  v36(); // _ZN8S2209C193v36Ev
  virtual void  v37(); // _ZN8S2209C193v37Ev
  virtual void  v38(); // _ZN8S2209C193v38Ev
  virtual void  v39(); // _ZN8S2209C193v39Ev
  virtual void  v40(); // _ZN8S2209C193v40Ev
  virtual void  v41(); // _ZN8S2209C193v41Ev
  virtual void  v42(); // _ZN8S2209C193v42Ev
  virtual void  v43(); // _ZN8S2209C193v43Ev
  virtual void  v44(); // _ZN8S2209C193v44Ev
  virtual void  v45(); // _ZN8S2209C193v45Ev
  virtual void  v46(); // _ZN8S2209C193v46Ev
  virtual void  v47(); // _ZN8S2209C193v47Ev
  virtual void  v48(); // _ZN8S2209C193v48Ev
  virtual void  v49(); // _ZN8S2209C193v49Ev
  virtual void  v50(); // _ZN8S2209C193v50Ev
  virtual void  v51(); // _ZN8S2209C193v51Ev
  virtual void  v52(); // _ZN8S2209C193v52Ev
  virtual void  v53(); // _ZN8S2209C193v53Ev
  virtual void  v54(); // _ZN8S2209C193v54Ev
  virtual void  v55(); // _ZN8S2209C193v55Ev
  virtual void  v56(); // _ZN8S2209C193v56Ev
  virtual void  v57(); // _ZN8S2209C193v57Ev
  S2209C19(); // tgen
};
//SIG(-1 S2209C19) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26}


 S2209C19 ::~S2209C19(){ note_dtor("S2209C19", this);}
void  S2209C19 ::v32(){vfunc_called(this, "_ZN8S2209C193v32Ev");}
void  S2209C19 ::v33(){vfunc_called(this, "_ZN8S2209C193v33Ev");}
void  S2209C19 ::v34(){vfunc_called(this, "_ZN8S2209C193v34Ev");}
void  S2209C19 ::v35(){vfunc_called(this, "_ZN8S2209C193v35Ev");}
void  S2209C19 ::v36(){vfunc_called(this, "_ZN8S2209C193v36Ev");}
void  S2209C19 ::v37(){vfunc_called(this, "_ZN8S2209C193v37Ev");}
void  S2209C19 ::v38(){vfunc_called(this, "_ZN8S2209C193v38Ev");}
void  S2209C19 ::v39(){vfunc_called(this, "_ZN8S2209C193v39Ev");}
void  S2209C19 ::v40(){vfunc_called(this, "_ZN8S2209C193v40Ev");}
void  S2209C19 ::v41(){vfunc_called(this, "_ZN8S2209C193v41Ev");}
void  S2209C19 ::v42(){vfunc_called(this, "_ZN8S2209C193v42Ev");}
void  S2209C19 ::v43(){vfunc_called(this, "_ZN8S2209C193v43Ev");}
void  S2209C19 ::v44(){vfunc_called(this, "_ZN8S2209C193v44Ev");}
void  S2209C19 ::v45(){vfunc_called(this, "_ZN8S2209C193v45Ev");}
void  S2209C19 ::v46(){vfunc_called(this, "_ZN8S2209C193v46Ev");}
void  S2209C19 ::v47(){vfunc_called(this, "_ZN8S2209C193v47Ev");}
void  S2209C19 ::v48(){vfunc_called(this, "_ZN8S2209C193v48Ev");}
void  S2209C19 ::v49(){vfunc_called(this, "_ZN8S2209C193v49Ev");}
void  S2209C19 ::v50(){vfunc_called(this, "_ZN8S2209C193v50Ev");}
void  S2209C19 ::v51(){vfunc_called(this, "_ZN8S2209C193v51Ev");}
void  S2209C19 ::v52(){vfunc_called(this, "_ZN8S2209C193v52Ev");}
void  S2209C19 ::v53(){vfunc_called(this, "_ZN8S2209C193v53Ev");}
void  S2209C19 ::v54(){vfunc_called(this, "_ZN8S2209C193v54Ev");}
void  S2209C19 ::v55(){vfunc_called(this, "_ZN8S2209C193v55Ev");}
void  S2209C19 ::v56(){vfunc_called(this, "_ZN8S2209C193v56Ev");}
void  S2209C19 ::v57(){vfunc_called(this, "_ZN8S2209C193v57Ev");}
S2209C19 ::S2209C19(){ note_ctor("S2209C19", this);} // tgen

static void Test_S2209C19()
{
  extern Class_Descriptor cd_S2209C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2209C19, buf);
    S2209C19 *dp, &lv = *(dp=new (buf) S2209C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2209C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2209C19)");
    test_class_info(&lv, &cd_S2209C19);
    dp->~S2209C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2209C19(Test_S2209C19, "S2209C19", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2209C19C1Ev();
extern void _ZN8S2209C19D1Ev();
Name_Map name_map_S2209C19[] = {
  NSPAIR(_ZN8S2209C19C1Ev),
  NSPAIR(_ZN8S2209C19D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2209C19[];
extern void _ZN8S2209C19D1Ev();
extern void _ZN8S2209C19D0Ev();
extern void _ZN8S2209C193v32Ev();
extern void _ZN8S2209C193v33Ev();
extern void _ZN8S2209C193v34Ev();
extern void _ZN8S2209C193v35Ev();
extern void _ZN8S2209C193v36Ev();
extern void _ZN8S2209C193v37Ev();
extern void _ZN8S2209C193v38Ev();
extern void _ZN8S2209C193v39Ev();
extern void _ZN8S2209C193v40Ev();
extern void _ZN8S2209C193v41Ev();
extern void _ZN8S2209C193v42Ev();
extern void _ZN8S2209C193v43Ev();
extern void _ZN8S2209C193v44Ev();
extern void _ZN8S2209C193v45Ev();
extern void _ZN8S2209C193v46Ev();
extern void _ZN8S2209C193v47Ev();
extern void _ZN8S2209C193v48Ev();
extern void _ZN8S2209C193v49Ev();
extern void _ZN8S2209C193v50Ev();
extern void _ZN8S2209C193v51Ev();
extern void _ZN8S2209C193v52Ev();
extern void _ZN8S2209C193v53Ev();
extern void _ZN8S2209C193v54Ev();
extern void _ZN8S2209C193v55Ev();
extern void _ZN8S2209C193v56Ev();
extern void _ZN8S2209C193v57Ev();
static  VTBL_ENTRY vtc_S2209C19[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2209C19[0]),
  (VTBL_ENTRY)&_ZN8S2209C19D1Ev,
  (VTBL_ENTRY)&_ZN8S2209C19D0Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v32Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v33Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v34Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v35Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v36Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v37Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v38Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v39Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v40Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v41Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v42Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v43Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v44Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v45Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v46Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v47Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v48Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v49Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v50Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v51Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v52Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v53Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v54Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v55Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v56Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v57Ev,
};
extern VTBL_ENTRY _ZTI8S2209C19[];
extern  VTBL_ENTRY _ZTV8S2209C19[];
Class_Descriptor cd_S2209C19 = {  "S2209C19", // class name
  0,0,//no base classes
  &(vtc_S2209C19[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2209C19),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2209C19),30, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2209C2  : S2209C3 , S2209C13 , S2209C19 {
  ::S1587C6_nt s2209c2f0;
  char s2209c2f1[2];
  int s2209c2f2;
  void *s2209c2f3[5];
  char s2209c2f4[2];
  void *s2209c2f5;
  ::S886C23 s2209c2f6;
  __tsi64 s2209c2f7[2];
  int s2209c2f8[2];
  virtual  ~S2209C2(); // _ZN7S2209C2D1Ev
  virtual void  v58(); // _ZN7S2209C23v58Ev
  virtual void  v59(); // _ZN7S2209C23v59Ev
  virtual void  v60(); // _ZN7S2209C23v60Ev
  virtual void  v61(); // _ZN7S2209C23v61Ev
  virtual void  v62(); // _ZN7S2209C23v62Ev
  virtual void  v63(); // _ZN7S2209C23v63Ev
  virtual void  v64(); // _ZN7S2209C23v64Ev
  virtual void  v65(); // _ZN7S2209C23v65Ev
  virtual void  v66(); // _ZN7S2209C23v66Ev
  virtual void  v67(); // _ZN7S2209C23v67Ev
  virtual void  v68(); // _ZN7S2209C23v68Ev
  virtual void  v69(); // _ZN7S2209C23v69Ev
  virtual void  v70(); // _ZN7S2209C23v70Ev
  virtual void  v71(); // _ZN7S2209C23v71Ev
  virtual void  v72(); // _ZN7S2209C23v72Ev
  virtual void  v73(); // _ZN7S2209C23v73Ev
  virtual void  v74(); // _ZN7S2209C23v74Ev
  virtual void  v75(); // _ZN7S2209C23v75Ev
  virtual void  v76(); // _ZN7S2209C23v76Ev
  virtual void  v77(); // _ZN7S2209C23v77Ev
  virtual void  v78(); // _ZN7S2209C23v78Ev
  virtual void  v79(); // _ZN7S2209C23v79Ev
  virtual void  v80(); // _ZN7S2209C23v80Ev
  virtual void  v81(); // _ZN7S2209C23v81Ev
  virtual void  v82(); // _ZN7S2209C23v82Ev
  virtual void  v83(); // _ZN7S2209C23v83Ev
  virtual void  v84(); // _ZN7S2209C23v84Ev
  virtual void  v85(); // _ZN7S2209C23v85Ev
  virtual void  v86(); // _ZN7S2209C23v86Ev
  virtual void  v87(); // _ZN7S2209C23v87Ev
  virtual void  v88(); // _ZN7S2209C23v88Ev
  virtual void  v89(); // _ZN7S2209C23v89Ev
  S2209C2(); // tgen
};
//SIG(-1 S2209C2) C1{ BC2{ BC3{ vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 Fp FC4{ BC5{ m Fp Fi FC6{ m} FC7{ m}}} FC8{ m FC9{ FL[4]}} Fc} vd v45 v46 v47 v48 v49 v50 v51 FC10{ m Fp Fi[2] FC6}} BC11{ BC12{ BC13{ vd v52 v53 v54} vd v55 v56 v57 v58} vd v59 v60 v61 FC14{ m Fp Fi[2] FC7} FC15{ m FC9} Fc} BC16{ vd v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 FC17{ m Fp Fi FC6} Fc[2] Fi Fp[5] Fc[2] Fp FC18{ m Fp Fi[4] Fc Fi[3]} FL[2] Fi[2]}


 S2209C2 ::~S2209C2(){ note_dtor("S2209C2", this);}
void  S2209C2 ::v58(){vfunc_called(this, "_ZN7S2209C23v58Ev");}
void  S2209C2 ::v59(){vfunc_called(this, "_ZN7S2209C23v59Ev");}
void  S2209C2 ::v60(){vfunc_called(this, "_ZN7S2209C23v60Ev");}
void  S2209C2 ::v61(){vfunc_called(this, "_ZN7S2209C23v61Ev");}
void  S2209C2 ::v62(){vfunc_called(this, "_ZN7S2209C23v62Ev");}
void  S2209C2 ::v63(){vfunc_called(this, "_ZN7S2209C23v63Ev");}
void  S2209C2 ::v64(){vfunc_called(this, "_ZN7S2209C23v64Ev");}
void  S2209C2 ::v65(){vfunc_called(this, "_ZN7S2209C23v65Ev");}
void  S2209C2 ::v66(){vfunc_called(this, "_ZN7S2209C23v66Ev");}
void  S2209C2 ::v67(){vfunc_called(this, "_ZN7S2209C23v67Ev");}
void  S2209C2 ::v68(){vfunc_called(this, "_ZN7S2209C23v68Ev");}
void  S2209C2 ::v69(){vfunc_called(this, "_ZN7S2209C23v69Ev");}
void  S2209C2 ::v70(){vfunc_called(this, "_ZN7S2209C23v70Ev");}
void  S2209C2 ::v71(){vfunc_called(this, "_ZN7S2209C23v71Ev");}
void  S2209C2 ::v72(){vfunc_called(this, "_ZN7S2209C23v72Ev");}
void  S2209C2 ::v73(){vfunc_called(this, "_ZN7S2209C23v73Ev");}
void  S2209C2 ::v74(){vfunc_called(this, "_ZN7S2209C23v74Ev");}
void  S2209C2 ::v75(){vfunc_called(this, "_ZN7S2209C23v75Ev");}
void  S2209C2 ::v76(){vfunc_called(this, "_ZN7S2209C23v76Ev");}
void  S2209C2 ::v77(){vfunc_called(this, "_ZN7S2209C23v77Ev");}
void  S2209C2 ::v78(){vfunc_called(this, "_ZN7S2209C23v78Ev");}
void  S2209C2 ::v79(){vfunc_called(this, "_ZN7S2209C23v79Ev");}
void  S2209C2 ::v80(){vfunc_called(this, "_ZN7S2209C23v80Ev");}
void  S2209C2 ::v81(){vfunc_called(this, "_ZN7S2209C23v81Ev");}
void  S2209C2 ::v82(){vfunc_called(this, "_ZN7S2209C23v82Ev");}
void  S2209C2 ::v83(){vfunc_called(this, "_ZN7S2209C23v83Ev");}
void  S2209C2 ::v84(){vfunc_called(this, "_ZN7S2209C23v84Ev");}
void  S2209C2 ::v85(){vfunc_called(this, "_ZN7S2209C23v85Ev");}
void  S2209C2 ::v86(){vfunc_called(this, "_ZN7S2209C23v86Ev");}
void  S2209C2 ::v87(){vfunc_called(this, "_ZN7S2209C23v87Ev");}
void  S2209C2 ::v88(){vfunc_called(this, "_ZN7S2209C23v88Ev");}
void  S2209C2 ::v89(){vfunc_called(this, "_ZN7S2209C23v89Ev");}
S2209C2 ::S2209C2(){ note_ctor("S2209C2", this);} // tgen

static void Test_S2209C2()
{
  extern Class_Descriptor cd_S2209C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(41,61)];
    init_test(&cd_S2209C2, buf);
    S2209C2 *dp, &lv = *(dp=new (buf) S2209C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(320,240), "sizeof(S2209C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2209C2)");
    check_base_class_offset(lv, (S2209C4*)(S2209C3*), 0, "S2209C2");
    check_base_class_offset(lv, (S2209C3*), 0, "S2209C2");
    check_base_class_offset(lv, (S2209C15*)(S2209C14*)(S2209C13*), ABISELECT(96,72), "S2209C2");
    check_base_class_offset(lv, (S2209C14*)(S2209C13*), ABISELECT(96,72), "S2209C2");
    check_base_class_offset(lv, (S2209C13*), ABISELECT(96,72), "S2209C2");
    check_base_class_offset(lv, (S2209C19*), ABISELECT(168,128), "S2209C2");
    check_field_offset(lv, s2209c2f0, ABISELECT(176,132), "S2209C2.s2209c2f0");
    check_field_offset(lv, s2209c2f1, ABISELECT(192,144), "S2209C2.s2209c2f1");
    check_field_offset(lv, s2209c2f2, ABISELECT(196,148), "S2209C2.s2209c2f2");
    check_field_offset(lv, s2209c2f3, ABISELECT(200,152), "S2209C2.s2209c2f3");
    check_field_offset(lv, s2209c2f4, ABISELECT(240,172), "S2209C2.s2209c2f4");
    check_field_offset(lv, s2209c2f5, ABISELECT(248,176), "S2209C2.s2209c2f5");
    check_field_offset(lv, s2209c2f6, ABISELECT(256,180), "S2209C2.s2209c2f6");
    check_field_offset(lv, s2209c2f7, ABISELECT(296,216), "S2209C2.s2209c2f7");
    check_field_offset(lv, s2209c2f8, ABISELECT(312,232), "S2209C2.s2209c2f8");
    test_class_info(&lv, &cd_S2209C2);
    dp->~S2209C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2209C2(Test_S2209C2, "S2209C2", ABISELECT(320,240));

#else // __cplusplus

extern void _ZN7S2209C2C1Ev();
extern void _ZN7S2209C2D1Ev();
Name_Map name_map_S2209C2[] = {
  NSPAIR(_ZN7S2209C2C1Ev),
  NSPAIR(_ZN7S2209C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2209C4;
extern VTBL_ENTRY _ZTI7S2209C4[];
extern  VTBL_ENTRY _ZTV7S2209C4[];
extern Class_Descriptor cd_S2209C3;
extern VTBL_ENTRY _ZTI7S2209C3[];
extern  VTBL_ENTRY _ZTV7S2209C3[];
extern Class_Descriptor cd_S2209C15;
extern VTBL_ENTRY _ZTI8S2209C15[];
extern  VTBL_ENTRY _ZTV8S2209C15[];
extern Class_Descriptor cd_S2209C14;
extern VTBL_ENTRY _ZTI8S2209C14[];
extern  VTBL_ENTRY _ZTV8S2209C14[];
extern Class_Descriptor cd_S2209C13;
extern VTBL_ENTRY _ZTI8S2209C13[];
extern  VTBL_ENTRY _ZTV8S2209C13[];
extern Class_Descriptor cd_S2209C19;
extern VTBL_ENTRY _ZTI8S2209C19[];
extern  VTBL_ENTRY _ZTV8S2209C19[];
static Base_Class bases_S2209C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2209C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2209C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2209C15,    ABISELECT(96,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2209C14,    ABISELECT(96,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2209C13,    ABISELECT(96,72), //bcp->offset
    55, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2209C19,    ABISELECT(168,128), //bcp->offset
    69, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2209C2[];
extern void _ZN7S2209C2D1Ev();
extern void _ZN7S2209C2D0Ev();
extern void _ZN7S2209C42v3Ev();
extern void _ZN7S2209C42v4Ev();
extern void _ZN7S2209C42v5Ev();
extern void _ZN7S2209C42v6Ev();
extern void _ZN7S2209C42v7Ev();
extern void _ZN7S2209C42v8Ev();
extern void _ZN7S2209C42v9Ev();
extern void _ZN7S2209C43v10Ev();
extern void _ZN7S2209C43v11Ev();
extern void _ZN7S2209C43v12Ev();
extern void _ZN7S2209C43v13Ev();
extern void _ZN7S2209C43v14Ev();
extern void _ZN7S2209C33v15Ev();
extern void _ZN7S2209C33v16Ev();
extern void _ZN7S2209C33v17Ev();
extern void _ZN7S2209C33v18Ev();
extern void _ZN7S2209C33v19Ev();
extern void _ZN7S2209C33v20Ev();
extern void _ZN7S2209C33v21Ev();
extern void _ZN7S2209C23v58Ev();
extern void _ZN7S2209C23v59Ev();
extern void _ZN7S2209C23v60Ev();
extern void _ZN7S2209C23v61Ev();
extern void _ZN7S2209C23v62Ev();
extern void _ZN7S2209C23v63Ev();
extern void _ZN7S2209C23v64Ev();
extern void _ZN7S2209C23v65Ev();
extern void _ZN7S2209C23v66Ev();
extern void _ZN7S2209C23v67Ev();
extern void _ZN7S2209C23v68Ev();
extern void _ZN7S2209C23v69Ev();
extern void _ZN7S2209C23v70Ev();
extern void _ZN7S2209C23v71Ev();
extern void _ZN7S2209C23v72Ev();
extern void _ZN7S2209C23v73Ev();
extern void _ZN7S2209C23v74Ev();
extern void _ZN7S2209C23v75Ev();
extern void _ZN7S2209C23v76Ev();
extern void _ZN7S2209C23v77Ev();
extern void _ZN7S2209C23v78Ev();
extern void _ZN7S2209C23v79Ev();
extern void _ZN7S2209C23v80Ev();
extern void _ZN7S2209C23v81Ev();
extern void _ZN7S2209C23v82Ev();
extern void _ZN7S2209C23v83Ev();
extern void _ZN7S2209C23v84Ev();
extern void _ZN7S2209C23v85Ev();
extern void _ZN7S2209C23v86Ev();
extern void _ZN7S2209C23v87Ev();
extern void _ZN7S2209C23v88Ev();
extern void _ZN7S2209C23v89Ev();
extern void ABISELECT(_ZThn96_N7S2209C2D1Ev,_ZThn72_N7S2209C2D1Ev)();
extern void ABISELECT(_ZThn96_N7S2209C2D0Ev,_ZThn72_N7S2209C2D0Ev)();
extern void _ZN8S2209C153v22Ev();
extern void _ZN8S2209C153v23Ev();
extern void _ZN8S2209C153v24Ev();
extern void _ZN8S2209C143v25Ev();
extern void _ZN8S2209C143v26Ev();
extern void _ZN8S2209C143v27Ev();
extern void _ZN8S2209C143v28Ev();
extern void _ZN8S2209C133v29Ev();
extern void _ZN8S2209C133v30Ev();
extern void _ZN8S2209C133v31Ev();
extern void ABISELECT(_ZThn168_N7S2209C2D1Ev,_ZThn128_N7S2209C2D1Ev)();
extern void ABISELECT(_ZThn168_N7S2209C2D0Ev,_ZThn128_N7S2209C2D0Ev)();
extern void _ZN8S2209C193v32Ev();
extern void _ZN8S2209C193v33Ev();
extern void _ZN8S2209C193v34Ev();
extern void _ZN8S2209C193v35Ev();
extern void _ZN8S2209C193v36Ev();
extern void _ZN8S2209C193v37Ev();
extern void _ZN8S2209C193v38Ev();
extern void _ZN8S2209C193v39Ev();
extern void _ZN8S2209C193v40Ev();
extern void _ZN8S2209C193v41Ev();
extern void _ZN8S2209C193v42Ev();
extern void _ZN8S2209C193v43Ev();
extern void _ZN8S2209C193v44Ev();
extern void _ZN8S2209C193v45Ev();
extern void _ZN8S2209C193v46Ev();
extern void _ZN8S2209C193v47Ev();
extern void _ZN8S2209C193v48Ev();
extern void _ZN8S2209C193v49Ev();
extern void _ZN8S2209C193v50Ev();
extern void _ZN8S2209C193v51Ev();
extern void _ZN8S2209C193v52Ev();
extern void _ZN8S2209C193v53Ev();
extern void _ZN8S2209C193v54Ev();
extern void _ZN8S2209C193v55Ev();
extern void _ZN8S2209C193v56Ev();
extern void _ZN8S2209C193v57Ev();
static  VTBL_ENTRY vtc_S2209C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2209C2[0]),
  (VTBL_ENTRY)&_ZN7S2209C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2209C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2209C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2209C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2209C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2209C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2209C43v14Ev,
  (VTBL_ENTRY)&_ZN7S2209C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2209C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2209C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2209C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2209C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2209C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2209C33v21Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v58Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v59Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v60Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v61Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v62Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v63Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v64Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v65Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v66Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v67Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v68Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v69Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v70Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v71Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v72Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v73Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v74Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v75Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v76Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v77Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v78Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v79Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v80Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v81Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v82Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v83Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v84Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v85Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v86Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v87Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v88Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v89Ev,
  ABISELECT(-96,-72),
  (VTBL_ENTRY)&(_ZTI7S2209C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N7S2209C2D1Ev,_ZThn72_N7S2209C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N7S2209C2D0Ev,_ZThn72_N7S2209C2D0Ev),
  (VTBL_ENTRY)&_ZN8S2209C153v22Ev,
  (VTBL_ENTRY)&_ZN8S2209C153v23Ev,
  (VTBL_ENTRY)&_ZN8S2209C153v24Ev,
  (VTBL_ENTRY)&_ZN8S2209C143v25Ev,
  (VTBL_ENTRY)&_ZN8S2209C143v26Ev,
  (VTBL_ENTRY)&_ZN8S2209C143v27Ev,
  (VTBL_ENTRY)&_ZN8S2209C143v28Ev,
  (VTBL_ENTRY)&_ZN8S2209C133v29Ev,
  (VTBL_ENTRY)&_ZN8S2209C133v30Ev,
  (VTBL_ENTRY)&_ZN8S2209C133v31Ev,
  ABISELECT(-168,-128),
  (VTBL_ENTRY)&(_ZTI7S2209C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N7S2209C2D1Ev,_ZThn128_N7S2209C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N7S2209C2D0Ev,_ZThn128_N7S2209C2D0Ev),
  (VTBL_ENTRY)&_ZN8S2209C193v32Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v33Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v34Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v35Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v36Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v37Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v38Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v39Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v40Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v41Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v42Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v43Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v44Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v45Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v46Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v47Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v48Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v49Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v50Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v51Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v52Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v53Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v54Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v55Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v56Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v57Ev,
};
extern VTBL_ENTRY _ZTI7S2209C2[];
extern  VTBL_ENTRY _ZTV7S2209C2[];
Class_Descriptor cd_S2209C2 = {  "S2209C2", // class name
  bases_S2209C2, 6,
  &(vtc_S2209C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(320,240), // object size
  NSPAIRA(_ZTI7S2209C2),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S2209C2),99, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2209C1  : S2209C2 {
  virtual  ~S2209C1(); // _ZN7S2209C1D1Ev
  virtual void  v1(); // _ZN7S2209C12v1Ev
  virtual void  v2(); // _ZN7S2209C12v2Ev
  S2209C1(); // tgen
};
//SIG(1 S2209C1) C1{ BC2{ BC3{ BC4{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp FC5{ BC6{ m Fp Fi FC7{ m} FC8{ m}}} FC9{ m FC10{ FL[4]}} Fc} vd v15 v16 v17 v18 v19 v20 v21 FC11{ m Fp Fi[2] FC7}} BC12{ BC13{ BC14{ vd v22 v23 v24} vd v25 v26 v27 v28} vd v29 v30 v31 FC15{ m Fp Fi[2] FC8} FC16{ m FC10} Fc} BC17{ vd v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57} vd v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 FC18{ m Fp Fi FC7} Fc[2] Fi Fp[5] Fc[2] Fp FC19{ m Fp Fi[4] Fc Fi[3]} FL[2] Fi[2]} vd v1 v2}


 S2209C1 ::~S2209C1(){ note_dtor("S2209C1", this);}
void  S2209C1 ::v1(){vfunc_called(this, "_ZN7S2209C12v1Ev");}
void  S2209C1 ::v2(){vfunc_called(this, "_ZN7S2209C12v2Ev");}
S2209C1 ::S2209C1(){ note_ctor("S2209C1", this);} // tgen

static void Test_S2209C1()
{
  extern Class_Descriptor cd_S2209C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(41,61)];
    init_test(&cd_S2209C1, buf);
    S2209C1 *dp, &lv = *(dp=new (buf) S2209C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(320,240), "sizeof(S2209C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2209C1)");
    check_base_class_offset(lv, (S2209C4*)(S2209C3*)(S2209C2*), 0, "S2209C1");
    check_base_class_offset(lv, (S2209C3*)(S2209C2*), 0, "S2209C1");
    check_base_class_offset(lv, (S2209C15*)(S2209C14*)(S2209C13*)(S2209C2*), ABISELECT(96,72), "S2209C1");
    check_base_class_offset(lv, (S2209C14*)(S2209C13*)(S2209C2*), ABISELECT(96,72), "S2209C1");
    check_base_class_offset(lv, (S2209C13*)(S2209C2*), ABISELECT(96,72), "S2209C1");
    check_base_class_offset(lv, (S2209C19*)(S2209C2*), ABISELECT(168,128), "S2209C1");
    check_base_class_offset(lv, (S2209C2*), 0, "S2209C1");
    test_class_info(&lv, &cd_S2209C1);
    dp->~S2209C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2209C1(Test_S2209C1, "S2209C1", ABISELECT(320,240));

#else // __cplusplus

extern void _ZN7S2209C1C1Ev();
extern void _ZN7S2209C1D1Ev();
Name_Map name_map_S2209C1[] = {
  NSPAIR(_ZN7S2209C1C1Ev),
  NSPAIR(_ZN7S2209C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2209C4;
extern VTBL_ENTRY _ZTI7S2209C4[];
extern  VTBL_ENTRY _ZTV7S2209C4[];
extern Class_Descriptor cd_S2209C3;
extern VTBL_ENTRY _ZTI7S2209C3[];
extern  VTBL_ENTRY _ZTV7S2209C3[];
extern Class_Descriptor cd_S2209C15;
extern VTBL_ENTRY _ZTI8S2209C15[];
extern  VTBL_ENTRY _ZTV8S2209C15[];
extern Class_Descriptor cd_S2209C14;
extern VTBL_ENTRY _ZTI8S2209C14[];
extern  VTBL_ENTRY _ZTV8S2209C14[];
extern Class_Descriptor cd_S2209C13;
extern VTBL_ENTRY _ZTI8S2209C13[];
extern  VTBL_ENTRY _ZTV8S2209C13[];
extern Class_Descriptor cd_S2209C19;
extern VTBL_ENTRY _ZTI8S2209C19[];
extern  VTBL_ENTRY _ZTV8S2209C19[];
extern Class_Descriptor cd_S2209C2;
extern VTBL_ENTRY _ZTI7S2209C2[];
extern  VTBL_ENTRY _ZTV7S2209C2[];
static Base_Class bases_S2209C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2209C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2209C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2209C15,    ABISELECT(96,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2209C14,    ABISELECT(96,72), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2209C13,    ABISELECT(96,72), //bcp->offset
    57, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2209C19,    ABISELECT(168,128), //bcp->offset
    71, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2209C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2209C1[];
extern void _ZN7S2209C1D1Ev();
extern void _ZN7S2209C1D0Ev();
extern void _ZN7S2209C42v3Ev();
extern void _ZN7S2209C42v4Ev();
extern void _ZN7S2209C42v5Ev();
extern void _ZN7S2209C42v6Ev();
extern void _ZN7S2209C42v7Ev();
extern void _ZN7S2209C42v8Ev();
extern void _ZN7S2209C42v9Ev();
extern void _ZN7S2209C43v10Ev();
extern void _ZN7S2209C43v11Ev();
extern void _ZN7S2209C43v12Ev();
extern void _ZN7S2209C43v13Ev();
extern void _ZN7S2209C43v14Ev();
extern void _ZN7S2209C33v15Ev();
extern void _ZN7S2209C33v16Ev();
extern void _ZN7S2209C33v17Ev();
extern void _ZN7S2209C33v18Ev();
extern void _ZN7S2209C33v19Ev();
extern void _ZN7S2209C33v20Ev();
extern void _ZN7S2209C33v21Ev();
extern void _ZN7S2209C23v58Ev();
extern void _ZN7S2209C23v59Ev();
extern void _ZN7S2209C23v60Ev();
extern void _ZN7S2209C23v61Ev();
extern void _ZN7S2209C23v62Ev();
extern void _ZN7S2209C23v63Ev();
extern void _ZN7S2209C23v64Ev();
extern void _ZN7S2209C23v65Ev();
extern void _ZN7S2209C23v66Ev();
extern void _ZN7S2209C23v67Ev();
extern void _ZN7S2209C23v68Ev();
extern void _ZN7S2209C23v69Ev();
extern void _ZN7S2209C23v70Ev();
extern void _ZN7S2209C23v71Ev();
extern void _ZN7S2209C23v72Ev();
extern void _ZN7S2209C23v73Ev();
extern void _ZN7S2209C23v74Ev();
extern void _ZN7S2209C23v75Ev();
extern void _ZN7S2209C23v76Ev();
extern void _ZN7S2209C23v77Ev();
extern void _ZN7S2209C23v78Ev();
extern void _ZN7S2209C23v79Ev();
extern void _ZN7S2209C23v80Ev();
extern void _ZN7S2209C23v81Ev();
extern void _ZN7S2209C23v82Ev();
extern void _ZN7S2209C23v83Ev();
extern void _ZN7S2209C23v84Ev();
extern void _ZN7S2209C23v85Ev();
extern void _ZN7S2209C23v86Ev();
extern void _ZN7S2209C23v87Ev();
extern void _ZN7S2209C23v88Ev();
extern void _ZN7S2209C23v89Ev();
extern void _ZN7S2209C12v1Ev();
extern void _ZN7S2209C12v2Ev();
extern void ABISELECT(_ZThn96_N7S2209C1D1Ev,_ZThn72_N7S2209C1D1Ev)();
extern void ABISELECT(_ZThn96_N7S2209C1D0Ev,_ZThn72_N7S2209C1D0Ev)();
extern void _ZN8S2209C153v22Ev();
extern void _ZN8S2209C153v23Ev();
extern void _ZN8S2209C153v24Ev();
extern void _ZN8S2209C143v25Ev();
extern void _ZN8S2209C143v26Ev();
extern void _ZN8S2209C143v27Ev();
extern void _ZN8S2209C143v28Ev();
extern void _ZN8S2209C133v29Ev();
extern void _ZN8S2209C133v30Ev();
extern void _ZN8S2209C133v31Ev();
extern void ABISELECT(_ZThn168_N7S2209C1D1Ev,_ZThn128_N7S2209C1D1Ev)();
extern void ABISELECT(_ZThn168_N7S2209C1D0Ev,_ZThn128_N7S2209C1D0Ev)();
extern void _ZN8S2209C193v32Ev();
extern void _ZN8S2209C193v33Ev();
extern void _ZN8S2209C193v34Ev();
extern void _ZN8S2209C193v35Ev();
extern void _ZN8S2209C193v36Ev();
extern void _ZN8S2209C193v37Ev();
extern void _ZN8S2209C193v38Ev();
extern void _ZN8S2209C193v39Ev();
extern void _ZN8S2209C193v40Ev();
extern void _ZN8S2209C193v41Ev();
extern void _ZN8S2209C193v42Ev();
extern void _ZN8S2209C193v43Ev();
extern void _ZN8S2209C193v44Ev();
extern void _ZN8S2209C193v45Ev();
extern void _ZN8S2209C193v46Ev();
extern void _ZN8S2209C193v47Ev();
extern void _ZN8S2209C193v48Ev();
extern void _ZN8S2209C193v49Ev();
extern void _ZN8S2209C193v50Ev();
extern void _ZN8S2209C193v51Ev();
extern void _ZN8S2209C193v52Ev();
extern void _ZN8S2209C193v53Ev();
extern void _ZN8S2209C193v54Ev();
extern void _ZN8S2209C193v55Ev();
extern void _ZN8S2209C193v56Ev();
extern void _ZN8S2209C193v57Ev();
static  VTBL_ENTRY vtc_S2209C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2209C1[0]),
  (VTBL_ENTRY)&_ZN7S2209C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2209C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2209C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2209C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2209C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2209C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2209C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2209C43v14Ev,
  (VTBL_ENTRY)&_ZN7S2209C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2209C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2209C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2209C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2209C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2209C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2209C33v21Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v58Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v59Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v60Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v61Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v62Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v63Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v64Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v65Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v66Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v67Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v68Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v69Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v70Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v71Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v72Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v73Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v74Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v75Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v76Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v77Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v78Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v79Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v80Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v81Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v82Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v83Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v84Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v85Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v86Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v87Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v88Ev,
  (VTBL_ENTRY)&_ZN7S2209C23v89Ev,
  (VTBL_ENTRY)&_ZN7S2209C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2209C12v2Ev,
  ABISELECT(-96,-72),
  (VTBL_ENTRY)&(_ZTI7S2209C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N7S2209C1D1Ev,_ZThn72_N7S2209C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N7S2209C1D0Ev,_ZThn72_N7S2209C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2209C153v22Ev,
  (VTBL_ENTRY)&_ZN8S2209C153v23Ev,
  (VTBL_ENTRY)&_ZN8S2209C153v24Ev,
  (VTBL_ENTRY)&_ZN8S2209C143v25Ev,
  (VTBL_ENTRY)&_ZN8S2209C143v26Ev,
  (VTBL_ENTRY)&_ZN8S2209C143v27Ev,
  (VTBL_ENTRY)&_ZN8S2209C143v28Ev,
  (VTBL_ENTRY)&_ZN8S2209C133v29Ev,
  (VTBL_ENTRY)&_ZN8S2209C133v30Ev,
  (VTBL_ENTRY)&_ZN8S2209C133v31Ev,
  ABISELECT(-168,-128),
  (VTBL_ENTRY)&(_ZTI7S2209C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N7S2209C1D1Ev,_ZThn128_N7S2209C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N7S2209C1D0Ev,_ZThn128_N7S2209C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2209C193v32Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v33Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v34Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v35Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v36Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v37Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v38Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v39Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v40Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v41Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v42Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v43Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v44Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v45Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v46Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v47Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v48Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v49Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v50Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v51Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v52Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v53Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v54Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v55Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v56Ev,
  (VTBL_ENTRY)&_ZN8S2209C193v57Ev,
};
extern VTBL_ENTRY _ZTI7S2209C1[];
extern  VTBL_ENTRY _ZTV7S2209C1[];
Class_Descriptor cd_S2209C1 = {  "S2209C1", // class name
  bases_S2209C1, 7,
  &(vtc_S2209C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(320,240), // object size
  NSPAIRA(_ZTI7S2209C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2209C1),101, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  7, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2208C4  {
  void *s2208c4f0;
  ::S886C6_nt s2208c4f1;
  ::S2401C18_nt s2208c4f2;
  char s2208c4f3;
  virtual  ~S2208C4(); // _ZN7S2208C4D1Ev
  virtual void  v3(); // _ZN7S2208C42v3Ev
  virtual void  v4(); // _ZN7S2208C42v4Ev
  virtual void  v5(); // _ZN7S2208C42v5Ev
  virtual void  v6(); // _ZN7S2208C42v6Ev
  virtual void  v7(); // _ZN7S2208C42v7Ev
  virtual void  v8(); // _ZN7S2208C42v8Ev
  virtual void  v9(); // _ZN7S2208C42v9Ev
  virtual void  v10(); // _ZN7S2208C43v10Ev
  virtual void  v11(); // _ZN7S2208C43v11Ev
  virtual void  v12(); // _ZN7S2208C43v12Ev
  virtual void  v13(); // _ZN7S2208C43v13Ev
  virtual void  v14(); // _ZN7S2208C43v14Ev
  S2208C4(); // tgen
};
//SIG(-1 S2208C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 Fp FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}} FC6{ m FC7{ Fl[4]}} Fc}


 S2208C4 ::~S2208C4(){ note_dtor("S2208C4", this);}
void  S2208C4 ::v3(){vfunc_called(this, "_ZN7S2208C42v3Ev");}
void  S2208C4 ::v4(){vfunc_called(this, "_ZN7S2208C42v4Ev");}
void  S2208C4 ::v5(){vfunc_called(this, "_ZN7S2208C42v5Ev");}
void  S2208C4 ::v6(){vfunc_called(this, "_ZN7S2208C42v6Ev");}
void  S2208C4 ::v7(){vfunc_called(this, "_ZN7S2208C42v7Ev");}
void  S2208C4 ::v8(){vfunc_called(this, "_ZN7S2208C42v8Ev");}
void  S2208C4 ::v9(){vfunc_called(this, "_ZN7S2208C42v9Ev");}
void  S2208C4 ::v10(){vfunc_called(this, "_ZN7S2208C43v10Ev");}
void  S2208C4 ::v11(){vfunc_called(this, "_ZN7S2208C43v11Ev");}
void  S2208C4 ::v12(){vfunc_called(this, "_ZN7S2208C43v12Ev");}
void  S2208C4 ::v13(){vfunc_called(this, "_ZN7S2208C43v13Ev");}
void  S2208C4 ::v14(){vfunc_called(this, "_ZN7S2208C43v14Ev");}
S2208C4 ::S2208C4(){ note_ctor("S2208C4", this);} // tgen

static void Test_S2208C4()
{
  extern Class_Descriptor cd_S2208C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,11)];
    init_test(&cd_S2208C4, buf);
    S2208C4 *dp, &lv = *(dp=new (buf) S2208C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,40), "sizeof(S2208C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2208C4)");
    check_field_offset(lv, s2208c4f0, ABISELECT(8,4), "S2208C4.s2208c4f0");
    check_field_offset(lv, s2208c4f1, ABISELECT(16,8), "S2208C4.s2208c4f1");
    check_field_offset(lv, s2208c4f2, ABISELECT(32,20), "S2208C4.s2208c4f2");
    check_field_offset(lv, s2208c4f3, ABISELECT(64,36), "S2208C4.s2208c4f3");
    test_class_info(&lv, &cd_S2208C4);
    dp->~S2208C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2208C4(Test_S2208C4, "S2208C4", ABISELECT(72,40));

#else // __cplusplus

extern void _ZN7S2208C4C1Ev();
extern void _ZN7S2208C4D1Ev();
Name_Map name_map_S2208C4[] = {
  NSPAIR(_ZN7S2208C4C1Ev),
  NSPAIR(_ZN7S2208C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2208C4[];
extern void _ZN7S2208C4D1Ev();
extern void _ZN7S2208C4D0Ev();
extern void _ZN7S2208C42v3Ev();
extern void _ZN7S2208C42v4Ev();
extern void _ZN7S2208C42v5Ev();
extern void _ZN7S2208C42v6Ev();
extern void _ZN7S2208C42v7Ev();
extern void _ZN7S2208C42v8Ev();
extern void _ZN7S2208C42v9Ev();
extern void _ZN7S2208C43v10Ev();
extern void _ZN7S2208C43v11Ev();
extern void _ZN7S2208C43v12Ev();
extern void _ZN7S2208C43v13Ev();
extern void _ZN7S2208C43v14Ev();
static  VTBL_ENTRY vtc_S2208C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2208C4[0]),
  (VTBL_ENTRY)&_ZN7S2208C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2208C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2208C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2208C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2208C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2208C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2208C43v14Ev,
};
extern VTBL_ENTRY _ZTI7S2208C4[];
extern  VTBL_ENTRY _ZTV7S2208C4[];
Class_Descriptor cd_S2208C4 = {  "S2208C4", // class name
  0,0,//no base classes
  &(vtc_S2208C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI7S2208C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2208C4),16, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2208C3  : S2208C4 {
  ::S887C17 s2208c3f0;
  virtual  ~S2208C3(); // _ZN7S2208C3D1Ev
  virtual void  v15(); // _ZN7S2208C33v15Ev
  virtual void  v16(); // _ZN7S2208C33v16Ev
  virtual void  v17(); // _ZN7S2208C33v17Ev
  virtual void  v18(); // _ZN7S2208C33v18Ev
  virtual void  v19(); // _ZN7S2208C33v19Ev
  virtual void  v20(); // _ZN7S2208C33v20Ev
  virtual void  v21(); // _ZN7S2208C33v21Ev
  S2208C3(); // tgen
};
//SIG(-1 S2208C3) C1{ BC2{ vd v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 Fp FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}} FC7{ m FC8{ Fl[4]}} Fc} vd v1 v2 v3 v4 v5 v6 v7 FC9{ m Fp Fi[2] FC5}}


 S2208C3 ::~S2208C3(){ note_dtor("S2208C3", this);}
void  S2208C3 ::v15(){vfunc_called(this, "_ZN7S2208C33v15Ev");}
void  S2208C3 ::v16(){vfunc_called(this, "_ZN7S2208C33v16Ev");}
void  S2208C3 ::v17(){vfunc_called(this, "_ZN7S2208C33v17Ev");}
void  S2208C3 ::v18(){vfunc_called(this, "_ZN7S2208C33v18Ev");}
void  S2208C3 ::v19(){vfunc_called(this, "_ZN7S2208C33v19Ev");}
void  S2208C3 ::v20(){vfunc_called(this, "_ZN7S2208C33v20Ev");}
void  S2208C3 ::v21(){vfunc_called(this, "_ZN7S2208C33v21Ev");}
S2208C3 ::S2208C3(){ note_ctor("S2208C3", this);} // tgen

static void Test_S2208C3()
{
  extern Class_Descriptor cd_S2208C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,15)];
    init_test(&cd_S2208C3, buf);
    S2208C3 *dp, &lv = *(dp=new (buf) S2208C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,56), "sizeof(S2208C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2208C3)");
    check_base_class_offset(lv, (S2208C4*), 0, "S2208C3");
    check_field_offset(lv, s2208c3f0, ABISELECT(72,40), "S2208C3.s2208c3f0");
    test_class_info(&lv, &cd_S2208C3);
    dp->~S2208C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2208C3(Test_S2208C3, "S2208C3", ABISELECT(96,56));

#else // __cplusplus

extern void _ZN7S2208C3C1Ev();
extern void _ZN7S2208C3D1Ev();
Name_Map name_map_S2208C3[] = {
  NSPAIR(_ZN7S2208C3C1Ev),
  NSPAIR(_ZN7S2208C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2208C4;
extern VTBL_ENTRY _ZTI7S2208C4[];
extern  VTBL_ENTRY _ZTV7S2208C4[];
static Base_Class bases_S2208C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2208C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2208C3[];
extern void _ZN7S2208C3D1Ev();
extern void _ZN7S2208C3D0Ev();
extern void _ZN7S2208C42v3Ev();
extern void _ZN7S2208C42v4Ev();
extern void _ZN7S2208C42v5Ev();
extern void _ZN7S2208C42v6Ev();
extern void _ZN7S2208C42v7Ev();
extern void _ZN7S2208C42v8Ev();
extern void _ZN7S2208C42v9Ev();
extern void _ZN7S2208C43v10Ev();
extern void _ZN7S2208C43v11Ev();
extern void _ZN7S2208C43v12Ev();
extern void _ZN7S2208C43v13Ev();
extern void _ZN7S2208C43v14Ev();
extern void _ZN7S2208C33v15Ev();
extern void _ZN7S2208C33v16Ev();
extern void _ZN7S2208C33v17Ev();
extern void _ZN7S2208C33v18Ev();
extern void _ZN7S2208C33v19Ev();
extern void _ZN7S2208C33v20Ev();
extern void _ZN7S2208C33v21Ev();
static  VTBL_ENTRY vtc_S2208C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2208C3[0]),
  (VTBL_ENTRY)&_ZN7S2208C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2208C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2208C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2208C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2208C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2208C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2208C43v14Ev,
  (VTBL_ENTRY)&_ZN7S2208C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2208C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2208C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2208C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2208C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2208C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2208C33v21Ev,
};
extern VTBL_ENTRY _ZTI7S2208C3[];
extern  VTBL_ENTRY _ZTV7S2208C3[];
Class_Descriptor cd_S2208C3 = {  "S2208C3", // class name
  bases_S2208C3, 1,
  &(vtc_S2208C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,56), // object size
  NSPAIRA(_ZTI7S2208C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2208C3),23, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2208C15  {
  virtual  ~S2208C15(); // _ZN8S2208C15D1Ev
  virtual void  v22(); // _ZN8S2208C153v22Ev
  virtual void  v23(); // _ZN8S2208C153v23Ev
  virtual void  v24(); // _ZN8S2208C153v24Ev
  S2208C15(); // tgen
};
//SIG(-1 S2208C15) C1{ vd v1 v2 v3}


 S2208C15 ::~S2208C15(){ note_dtor("S2208C15", this);}
void  S2208C15 ::v22(){vfunc_called(this, "_ZN8S2208C153v22Ev");}
void  S2208C15 ::v23(){vfunc_called(this, "_ZN8S2208C153v23Ev");}
void  S2208C15 ::v24(){vfunc_called(this, "_ZN8S2208C153v24Ev");}
S2208C15 ::S2208C15(){ note_ctor("S2208C15", this);} // tgen

static void Test_S2208C15()
{
  extern Class_Descriptor cd_S2208C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2208C15, buf);
    S2208C15 *dp, &lv = *(dp=new (buf) S2208C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2208C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2208C15)");
    test_class_info(&lv, &cd_S2208C15);
    dp->~S2208C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2208C15(Test_S2208C15, "S2208C15", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2208C15C1Ev();
extern void _ZN8S2208C15D1Ev();
Name_Map name_map_S2208C15[] = {
  NSPAIR(_ZN8S2208C15C1Ev),
  NSPAIR(_ZN8S2208C15D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2208C15[];
extern void _ZN8S2208C15D1Ev();
extern void _ZN8S2208C15D0Ev();
extern void _ZN8S2208C153v22Ev();
extern void _ZN8S2208C153v23Ev();
extern void _ZN8S2208C153v24Ev();
static  VTBL_ENTRY vtc_S2208C15[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2208C15[0]),
  (VTBL_ENTRY)&_ZN8S2208C15D1Ev,
  (VTBL_ENTRY)&_ZN8S2208C15D0Ev,
  (VTBL_ENTRY)&_ZN8S2208C153v22Ev,
  (VTBL_ENTRY)&_ZN8S2208C153v23Ev,
  (VTBL_ENTRY)&_ZN8S2208C153v24Ev,
};
extern VTBL_ENTRY _ZTI8S2208C15[];
extern  VTBL_ENTRY _ZTV8S2208C15[];
Class_Descriptor cd_S2208C15 = {  "S2208C15", // class name
  0,0,//no base classes
  &(vtc_S2208C15[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2208C15),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2208C15),7, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2208C14  : S2208C15 {
  virtual  ~S2208C14(); // _ZN8S2208C14D1Ev
  virtual void  v25(); // _ZN8S2208C143v25Ev
  virtual void  v26(); // _ZN8S2208C143v26Ev
  virtual void  v27(); // _ZN8S2208C143v27Ev
  virtual void  v28(); // _ZN8S2208C143v28Ev
  S2208C14(); // tgen
};
//SIG(-1 S2208C14) C1{ BC2{ vd v5 v6 v7} vd v1 v2 v3 v4}


 S2208C14 ::~S2208C14(){ note_dtor("S2208C14", this);}
void  S2208C14 ::v25(){vfunc_called(this, "_ZN8S2208C143v25Ev");}
void  S2208C14 ::v26(){vfunc_called(this, "_ZN8S2208C143v26Ev");}
void  S2208C14 ::v27(){vfunc_called(this, "_ZN8S2208C143v27Ev");}
void  S2208C14 ::v28(){vfunc_called(this, "_ZN8S2208C143v28Ev");}
S2208C14 ::S2208C14(){ note_ctor("S2208C14", this);} // tgen

static void Test_S2208C14()
{
  extern Class_Descriptor cd_S2208C14;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2208C14, buf);
    S2208C14 *dp, &lv = *(dp=new (buf) S2208C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2208C14)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2208C14)");
    check_base_class_offset(lv, (S2208C15*), 0, "S2208C14");
    test_class_info(&lv, &cd_S2208C14);
    dp->~S2208C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2208C14(Test_S2208C14, "S2208C14", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2208C14C1Ev();
extern void _ZN8S2208C14D1Ev();
Name_Map name_map_S2208C14[] = {
  NSPAIR(_ZN8S2208C14C1Ev),
  NSPAIR(_ZN8S2208C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2208C15;
extern VTBL_ENTRY _ZTI8S2208C15[];
extern  VTBL_ENTRY _ZTV8S2208C15[];
static Base_Class bases_S2208C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2208C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S2208C14[];
extern void _ZN8S2208C14D1Ev();
extern void _ZN8S2208C14D0Ev();
extern void _ZN8S2208C153v22Ev();
extern void _ZN8S2208C153v23Ev();
extern void _ZN8S2208C153v24Ev();
extern void _ZN8S2208C143v25Ev();
extern void _ZN8S2208C143v26Ev();
extern void _ZN8S2208C143v27Ev();
extern void _ZN8S2208C143v28Ev();
static  VTBL_ENTRY vtc_S2208C14[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2208C14[0]),
  (VTBL_ENTRY)&_ZN8S2208C14D1Ev,
  (VTBL_ENTRY)&_ZN8S2208C14D0Ev,
  (VTBL_ENTRY)&_ZN8S2208C153v22Ev,
  (VTBL_ENTRY)&_ZN8S2208C153v23Ev,
  (VTBL_ENTRY)&_ZN8S2208C153v24Ev,
  (VTBL_ENTRY)&_ZN8S2208C143v25Ev,
  (VTBL_ENTRY)&_ZN8S2208C143v26Ev,
  (VTBL_ENTRY)&_ZN8S2208C143v27Ev,
  (VTBL_ENTRY)&_ZN8S2208C143v28Ev,
};
extern VTBL_ENTRY _ZTI8S2208C14[];
extern  VTBL_ENTRY _ZTV8S2208C14[];
Class_Descriptor cd_S2208C14 = {  "S2208C14", // class name
  bases_S2208C14, 1,
  &(vtc_S2208C14[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2208C14),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S2208C14),11, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2208C13  : S2208C14 {
  ::S886C12_nt s2208c13f0;
  ::S886C10_nt s2208c13f1;
  char s2208c13f2;
  virtual  ~S2208C13(); // _ZN8S2208C13D1Ev
  virtual void  v29(); // _ZN8S2208C133v29Ev
  virtual void  v30(); // _ZN8S2208C133v30Ev
  virtual void  v31(); // _ZN8S2208C133v31Ev
  S2208C13(); // tgen
};
//SIG(-1 S2208C13) C1{ BC2{ BC3{ vd v4 v5 v6} vd v7 v8 v9 v10} vd v1 v2 v3 FC4{ m Fp Fi[2] FC5{ m}} FC6{ m FC7{ Fl[4]}} Fc}


 S2208C13 ::~S2208C13(){ note_dtor("S2208C13", this);}
void  S2208C13 ::v29(){vfunc_called(this, "_ZN8S2208C133v29Ev");}
void  S2208C13 ::v30(){vfunc_called(this, "_ZN8S2208C133v30Ev");}
void  S2208C13 ::v31(){vfunc_called(this, "_ZN8S2208C133v31Ev");}
S2208C13 ::S2208C13(){ note_ctor("S2208C13", this);} // tgen

static void Test_S2208C13()
{
  extern Class_Descriptor cd_S2208C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,11)];
    init_test(&cd_S2208C13, buf);
    S2208C13 *dp, &lv = *(dp=new (buf) S2208C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,40), "sizeof(S2208C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2208C13)");
    check_base_class_offset(lv, (S2208C15*)(S2208C14*), 0, "S2208C13");
    check_base_class_offset(lv, (S2208C14*), 0, "S2208C13");
    check_field_offset(lv, s2208c13f0, ABISELECT(8,4), "S2208C13.s2208c13f0");
    check_field_offset(lv, s2208c13f1, ABISELECT(32,20), "S2208C13.s2208c13f1");
    check_field_offset(lv, s2208c13f2, ABISELECT(64,36), "S2208C13.s2208c13f2");
    test_class_info(&lv, &cd_S2208C13);
    dp->~S2208C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2208C13(Test_S2208C13, "S2208C13", ABISELECT(72,40));

#else // __cplusplus

extern void _ZN8S2208C13C1Ev();
extern void _ZN8S2208C13D1Ev();
Name_Map name_map_S2208C13[] = {
  NSPAIR(_ZN8S2208C13C1Ev),
  NSPAIR(_ZN8S2208C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2208C15;
extern VTBL_ENTRY _ZTI8S2208C15[];
extern  VTBL_ENTRY _ZTV8S2208C15[];
extern Class_Descriptor cd_S2208C14;
extern VTBL_ENTRY _ZTI8S2208C14[];
extern  VTBL_ENTRY _ZTV8S2208C14[];
static Base_Class bases_S2208C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2208C15,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2208C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S2208C13[];
extern void _ZN8S2208C13D1Ev();
extern void _ZN8S2208C13D0Ev();
extern void _ZN8S2208C153v22Ev();
extern void _ZN8S2208C153v23Ev();
extern void _ZN8S2208C153v24Ev();
extern void _ZN8S2208C143v25Ev();
extern void _ZN8S2208C143v26Ev();
extern void _ZN8S2208C143v27Ev();
extern void _ZN8S2208C143v28Ev();
extern void _ZN8S2208C133v29Ev();
extern void _ZN8S2208C133v30Ev();
extern void _ZN8S2208C133v31Ev();
static  VTBL_ENTRY vtc_S2208C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2208C13[0]),
  (VTBL_ENTRY)&_ZN8S2208C13D1Ev,
  (VTBL_ENTRY)&_ZN8S2208C13D0Ev,
  (VTBL_ENTRY)&_ZN8S2208C153v22Ev,
  (VTBL_ENTRY)&_ZN8S2208C153v23Ev,
  (VTBL_ENTRY)&_ZN8S2208C153v24Ev,
  (VTBL_ENTRY)&_ZN8S2208C143v25Ev,
  (VTBL_ENTRY)&_ZN8S2208C143v26Ev,
  (VTBL_ENTRY)&_ZN8S2208C143v27Ev,
  (VTBL_ENTRY)&_ZN8S2208C143v28Ev,
  (VTBL_ENTRY)&_ZN8S2208C133v29Ev,
  (VTBL_ENTRY)&_ZN8S2208C133v30Ev,
  (VTBL_ENTRY)&_ZN8S2208C133v31Ev,
};
extern VTBL_ENTRY _ZTI8S2208C13[];
extern  VTBL_ENTRY _ZTV8S2208C13[];
Class_Descriptor cd_S2208C13 = {  "S2208C13", // class name
  bases_S2208C13, 2,
  &(vtc_S2208C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(72,40), // object size
  NSPAIRA(_ZTI8S2208C13),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S2208C13),14, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2208C19  {
  virtual  ~S2208C19(); // _ZN8S2208C19D1Ev
  virtual void  v32(); // _ZN8S2208C193v32Ev
  virtual void  v33(); // _ZN8S2208C193v33Ev
  virtual void  v34(); // _ZN8S2208C193v34Ev
  virtual void  v35(); // _ZN8S2208C193v35Ev
  virtual void  v36(); // _ZN8S2208C193v36Ev
  virtual void  v37(); // _ZN8S2208C193v37Ev
  virtual void  v38(); // _ZN8S2208C193v38Ev
  virtual void  v39(); // _ZN8S2208C193v39Ev
  virtual void  v40(); // _ZN8S2208C193v40Ev
  virtual void  v41(); // _ZN8S2208C193v41Ev
  virtual void  v42(); // _ZN8S2208C193v42Ev
  virtual void  v43(); // _ZN8S2208C193v43Ev
  virtual void  v44(); // _ZN8S2208C193v44Ev
  virtual void  v45(); // _ZN8S2208C193v45Ev
  virtual void  v46(); // _ZN8S2208C193v46Ev
  virtual void  v47(); // _ZN8S2208C193v47Ev
  virtual void  v48(); // _ZN8S2208C193v48Ev
  virtual void  v49(); // _ZN8S2208C193v49Ev
  virtual void  v50(); // _ZN8S2208C193v50Ev
  virtual void  v51(); // _ZN8S2208C193v51Ev
  virtual void  v52(); // _ZN8S2208C193v52Ev
  virtual void  v53(); // _ZN8S2208C193v53Ev
  virtual void  v54(); // _ZN8S2208C193v54Ev
  virtual void  v55(); // _ZN8S2208C193v55Ev
  virtual void  v56(); // _ZN8S2208C193v56Ev
  virtual void  v57(); // _ZN8S2208C193v57Ev
  S2208C19(); // tgen
};
//SIG(-1 S2208C19) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26}


 S2208C19 ::~S2208C19(){ note_dtor("S2208C19", this);}
void  S2208C19 ::v32(){vfunc_called(this, "_ZN8S2208C193v32Ev");}
void  S2208C19 ::v33(){vfunc_called(this, "_ZN8S2208C193v33Ev");}
void  S2208C19 ::v34(){vfunc_called(this, "_ZN8S2208C193v34Ev");}
void  S2208C19 ::v35(){vfunc_called(this, "_ZN8S2208C193v35Ev");}
void  S2208C19 ::v36(){vfunc_called(this, "_ZN8S2208C193v36Ev");}
void  S2208C19 ::v37(){vfunc_called(this, "_ZN8S2208C193v37Ev");}
void  S2208C19 ::v38(){vfunc_called(this, "_ZN8S2208C193v38Ev");}
void  S2208C19 ::v39(){vfunc_called(this, "_ZN8S2208C193v39Ev");}
void  S2208C19 ::v40(){vfunc_called(this, "_ZN8S2208C193v40Ev");}
void  S2208C19 ::v41(){vfunc_called(this, "_ZN8S2208C193v41Ev");}
void  S2208C19 ::v42(){vfunc_called(this, "_ZN8S2208C193v42Ev");}
void  S2208C19 ::v43(){vfunc_called(this, "_ZN8S2208C193v43Ev");}
void  S2208C19 ::v44(){vfunc_called(this, "_ZN8S2208C193v44Ev");}
void  S2208C19 ::v45(){vfunc_called(this, "_ZN8S2208C193v45Ev");}
void  S2208C19 ::v46(){vfunc_called(this, "_ZN8S2208C193v46Ev");}
void  S2208C19 ::v47(){vfunc_called(this, "_ZN8S2208C193v47Ev");}
void  S2208C19 ::v48(){vfunc_called(this, "_ZN8S2208C193v48Ev");}
void  S2208C19 ::v49(){vfunc_called(this, "_ZN8S2208C193v49Ev");}
void  S2208C19 ::v50(){vfunc_called(this, "_ZN8S2208C193v50Ev");}
void  S2208C19 ::v51(){vfunc_called(this, "_ZN8S2208C193v51Ev");}
void  S2208C19 ::v52(){vfunc_called(this, "_ZN8S2208C193v52Ev");}
void  S2208C19 ::v53(){vfunc_called(this, "_ZN8S2208C193v53Ev");}
void  S2208C19 ::v54(){vfunc_called(this, "_ZN8S2208C193v54Ev");}
void  S2208C19 ::v55(){vfunc_called(this, "_ZN8S2208C193v55Ev");}
void  S2208C19 ::v56(){vfunc_called(this, "_ZN8S2208C193v56Ev");}
void  S2208C19 ::v57(){vfunc_called(this, "_ZN8S2208C193v57Ev");}
S2208C19 ::S2208C19(){ note_ctor("S2208C19", this);} // tgen

static void Test_S2208C19()
{
  extern Class_Descriptor cd_S2208C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S2208C19, buf);
    S2208C19 *dp, &lv = *(dp=new (buf) S2208C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S2208C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2208C19)");
    test_class_info(&lv, &cd_S2208C19);
    dp->~S2208C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2208C19(Test_S2208C19, "S2208C19", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S2208C19C1Ev();
extern void _ZN8S2208C19D1Ev();
Name_Map name_map_S2208C19[] = {
  NSPAIR(_ZN8S2208C19C1Ev),
  NSPAIR(_ZN8S2208C19D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2208C19[];
extern void _ZN8S2208C19D1Ev();
extern void _ZN8S2208C19D0Ev();
extern void _ZN8S2208C193v32Ev();
extern void _ZN8S2208C193v33Ev();
extern void _ZN8S2208C193v34Ev();
extern void _ZN8S2208C193v35Ev();
extern void _ZN8S2208C193v36Ev();
extern void _ZN8S2208C193v37Ev();
extern void _ZN8S2208C193v38Ev();
extern void _ZN8S2208C193v39Ev();
extern void _ZN8S2208C193v40Ev();
extern void _ZN8S2208C193v41Ev();
extern void _ZN8S2208C193v42Ev();
extern void _ZN8S2208C193v43Ev();
extern void _ZN8S2208C193v44Ev();
extern void _ZN8S2208C193v45Ev();
extern void _ZN8S2208C193v46Ev();
extern void _ZN8S2208C193v47Ev();
extern void _ZN8S2208C193v48Ev();
extern void _ZN8S2208C193v49Ev();
extern void _ZN8S2208C193v50Ev();
extern void _ZN8S2208C193v51Ev();
extern void _ZN8S2208C193v52Ev();
extern void _ZN8S2208C193v53Ev();
extern void _ZN8S2208C193v54Ev();
extern void _ZN8S2208C193v55Ev();
extern void _ZN8S2208C193v56Ev();
extern void _ZN8S2208C193v57Ev();
static  VTBL_ENTRY vtc_S2208C19[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2208C19[0]),
  (VTBL_ENTRY)&_ZN8S2208C19D1Ev,
  (VTBL_ENTRY)&_ZN8S2208C19D0Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v32Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v33Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v34Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v35Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v36Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v37Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v38Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v39Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v40Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v41Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v42Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v43Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v44Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v45Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v46Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v47Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v48Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v49Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v50Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v51Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v52Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v53Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v54Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v55Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v56Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v57Ev,
};
extern VTBL_ENTRY _ZTI8S2208C19[];
extern  VTBL_ENTRY _ZTV8S2208C19[];
Class_Descriptor cd_S2208C19 = {  "S2208C19", // class name
  0,0,//no base classes
  &(vtc_S2208C19[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S2208C19),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2208C19),30, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2208C2  : S2208C3 , S2208C13 , S2208C19 {
  ::S1587C6_nt s2208c2f0;
  char s2208c2f1[2];
  int s2208c2f2;
  void *s2208c2f3[5];
  char s2208c2f4[2];
  void *s2208c2f5;
  ::S886C23 s2208c2f6;
  __tsi64 s2208c2f7[2];
  int s2208c2f8[2];
  virtual  ~S2208C2(); // _ZN7S2208C2D1Ev
  virtual void  v58(); // _ZN7S2208C23v58Ev
  virtual void  v59(); // _ZN7S2208C23v59Ev
  virtual void  v60(); // _ZN7S2208C23v60Ev
  virtual void  v61(); // _ZN7S2208C23v61Ev
  virtual void  v62(); // _ZN7S2208C23v62Ev
  virtual void  v63(); // _ZN7S2208C23v63Ev
  virtual void  v64(); // _ZN7S2208C23v64Ev
  virtual void  v65(); // _ZN7S2208C23v65Ev
  virtual void  v66(); // _ZN7S2208C23v66Ev
  virtual void  v67(); // _ZN7S2208C23v67Ev
  virtual void  v68(); // _ZN7S2208C23v68Ev
  virtual void  v69(); // _ZN7S2208C23v69Ev
  virtual void  v70(); // _ZN7S2208C23v70Ev
  virtual void  v71(); // _ZN7S2208C23v71Ev
  virtual void  v72(); // _ZN7S2208C23v72Ev
  virtual void  v73(); // _ZN7S2208C23v73Ev
  virtual void  v74(); // _ZN7S2208C23v74Ev
  virtual void  v75(); // _ZN7S2208C23v75Ev
  virtual void  v76(); // _ZN7S2208C23v76Ev
  virtual void  v77(); // _ZN7S2208C23v77Ev
  virtual void  v78(); // _ZN7S2208C23v78Ev
  virtual void  v79(); // _ZN7S2208C23v79Ev
  virtual void  v80(); // _ZN7S2208C23v80Ev
  virtual void  v81(); // _ZN7S2208C23v81Ev
  virtual void  v82(); // _ZN7S2208C23v82Ev
  virtual void  v83(); // _ZN7S2208C23v83Ev
  virtual void  v84(); // _ZN7S2208C23v84Ev
  virtual void  v85(); // _ZN7S2208C23v85Ev
  virtual void  v86(); // _ZN7S2208C23v86Ev
  virtual void  v87(); // _ZN7S2208C23v87Ev
  virtual void  v88(); // _ZN7S2208C23v88Ev
  virtual void  v89(); // _ZN7S2208C23v89Ev
  S2208C2(); // tgen
};
//SIG(-1 S2208C2) C1{ BC2{ BC3{ vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 Fp FC4{ BC5{ m Fp Fi FC6{ m} FC7{ m}}} FC8{ m FC9{ Fl[4]}} Fc} vd v45 v46 v47 v48 v49 v50 v51 FC10{ m Fp Fi[2] FC6}} BC11{ BC12{ BC13{ vd v52 v53 v54} vd v55 v56 v57 v58} vd v59 v60 v61 FC14{ m Fp Fi[2] FC7} FC15{ m FC9} Fc} BC16{ vd v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 FC17{ m Fp Fi FC6} Fc[2] Fi Fp[5] Fc[2] Fp FC18{ m Fp Fi[4] Fc Fi[3]} FL[2] Fi[2]}


 S2208C2 ::~S2208C2(){ note_dtor("S2208C2", this);}
void  S2208C2 ::v58(){vfunc_called(this, "_ZN7S2208C23v58Ev");}
void  S2208C2 ::v59(){vfunc_called(this, "_ZN7S2208C23v59Ev");}
void  S2208C2 ::v60(){vfunc_called(this, "_ZN7S2208C23v60Ev");}
void  S2208C2 ::v61(){vfunc_called(this, "_ZN7S2208C23v61Ev");}
void  S2208C2 ::v62(){vfunc_called(this, "_ZN7S2208C23v62Ev");}
void  S2208C2 ::v63(){vfunc_called(this, "_ZN7S2208C23v63Ev");}
void  S2208C2 ::v64(){vfunc_called(this, "_ZN7S2208C23v64Ev");}
void  S2208C2 ::v65(){vfunc_called(this, "_ZN7S2208C23v65Ev");}
void  S2208C2 ::v66(){vfunc_called(this, "_ZN7S2208C23v66Ev");}
void  S2208C2 ::v67(){vfunc_called(this, "_ZN7S2208C23v67Ev");}
void  S2208C2 ::v68(){vfunc_called(this, "_ZN7S2208C23v68Ev");}
void  S2208C2 ::v69(){vfunc_called(this, "_ZN7S2208C23v69Ev");}
void  S2208C2 ::v70(){vfunc_called(this, "_ZN7S2208C23v70Ev");}
void  S2208C2 ::v71(){vfunc_called(this, "_ZN7S2208C23v71Ev");}
void  S2208C2 ::v72(){vfunc_called(this, "_ZN7S2208C23v72Ev");}
void  S2208C2 ::v73(){vfunc_called(this, "_ZN7S2208C23v73Ev");}
void  S2208C2 ::v74(){vfunc_called(this, "_ZN7S2208C23v74Ev");}
void  S2208C2 ::v75(){vfunc_called(this, "_ZN7S2208C23v75Ev");}
void  S2208C2 ::v76(){vfunc_called(this, "_ZN7S2208C23v76Ev");}
void  S2208C2 ::v77(){vfunc_called(this, "_ZN7S2208C23v77Ev");}
void  S2208C2 ::v78(){vfunc_called(this, "_ZN7S2208C23v78Ev");}
void  S2208C2 ::v79(){vfunc_called(this, "_ZN7S2208C23v79Ev");}
void  S2208C2 ::v80(){vfunc_called(this, "_ZN7S2208C23v80Ev");}
void  S2208C2 ::v81(){vfunc_called(this, "_ZN7S2208C23v81Ev");}
void  S2208C2 ::v82(){vfunc_called(this, "_ZN7S2208C23v82Ev");}
void  S2208C2 ::v83(){vfunc_called(this, "_ZN7S2208C23v83Ev");}
void  S2208C2 ::v84(){vfunc_called(this, "_ZN7S2208C23v84Ev");}
void  S2208C2 ::v85(){vfunc_called(this, "_ZN7S2208C23v85Ev");}
void  S2208C2 ::v86(){vfunc_called(this, "_ZN7S2208C23v86Ev");}
void  S2208C2 ::v87(){vfunc_called(this, "_ZN7S2208C23v87Ev");}
void  S2208C2 ::v88(){vfunc_called(this, "_ZN7S2208C23v88Ev");}
void  S2208C2 ::v89(){vfunc_called(this, "_ZN7S2208C23v89Ev");}
S2208C2 ::S2208C2(){ note_ctor("S2208C2", this);} // tgen

static void Test_S2208C2()
{
  extern Class_Descriptor cd_S2208C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(41,53)];
    init_test(&cd_S2208C2, buf);
    S2208C2 *dp, &lv = *(dp=new (buf) S2208C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(320,208), "sizeof(S2208C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2208C2)");
    check_base_class_offset(lv, (S2208C4*)(S2208C3*), 0, "S2208C2");
    check_base_class_offset(lv, (S2208C3*), 0, "S2208C2");
    check_base_class_offset(lv, (S2208C15*)(S2208C14*)(S2208C13*), ABISELECT(96,56), "S2208C2");
    check_base_class_offset(lv, (S2208C14*)(S2208C13*), ABISELECT(96,56), "S2208C2");
    check_base_class_offset(lv, (S2208C13*), ABISELECT(96,56), "S2208C2");
    check_base_class_offset(lv, (S2208C19*), ABISELECT(168,96), "S2208C2");
    check_field_offset(lv, s2208c2f0, ABISELECT(176,100), "S2208C2.s2208c2f0");
    check_field_offset(lv, s2208c2f1, ABISELECT(192,112), "S2208C2.s2208c2f1");
    check_field_offset(lv, s2208c2f2, ABISELECT(196,116), "S2208C2.s2208c2f2");
    check_field_offset(lv, s2208c2f3, ABISELECT(200,120), "S2208C2.s2208c2f3");
    check_field_offset(lv, s2208c2f4, ABISELECT(240,140), "S2208C2.s2208c2f4");
    check_field_offset(lv, s2208c2f5, ABISELECT(248,144), "S2208C2.s2208c2f5");
    check_field_offset(lv, s2208c2f6, ABISELECT(256,148), "S2208C2.s2208c2f6");
    check_field_offset(lv, s2208c2f7, ABISELECT(296,184), "S2208C2.s2208c2f7");
    check_field_offset(lv, s2208c2f8, ABISELECT(312,200), "S2208C2.s2208c2f8");
    test_class_info(&lv, &cd_S2208C2);
    dp->~S2208C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2208C2(Test_S2208C2, "S2208C2", ABISELECT(320,208));

#else // __cplusplus

extern void _ZN7S2208C2C1Ev();
extern void _ZN7S2208C2D1Ev();
Name_Map name_map_S2208C2[] = {
  NSPAIR(_ZN7S2208C2C1Ev),
  NSPAIR(_ZN7S2208C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2208C4;
extern VTBL_ENTRY _ZTI7S2208C4[];
extern  VTBL_ENTRY _ZTV7S2208C4[];
extern Class_Descriptor cd_S2208C3;
extern VTBL_ENTRY _ZTI7S2208C3[];
extern  VTBL_ENTRY _ZTV7S2208C3[];
extern Class_Descriptor cd_S2208C15;
extern VTBL_ENTRY _ZTI8S2208C15[];
extern  VTBL_ENTRY _ZTV8S2208C15[];
extern Class_Descriptor cd_S2208C14;
extern VTBL_ENTRY _ZTI8S2208C14[];
extern  VTBL_ENTRY _ZTV8S2208C14[];
extern Class_Descriptor cd_S2208C13;
extern VTBL_ENTRY _ZTI8S2208C13[];
extern  VTBL_ENTRY _ZTV8S2208C13[];
extern Class_Descriptor cd_S2208C19;
extern VTBL_ENTRY _ZTI8S2208C19[];
extern  VTBL_ENTRY _ZTV8S2208C19[];
static Base_Class bases_S2208C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2208C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2208C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2208C15,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2208C14,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2208C13,    ABISELECT(96,56), //bcp->offset
    55, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2208C19,    ABISELECT(168,96), //bcp->offset
    69, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2208C2[];
extern void _ZN7S2208C2D1Ev();
extern void _ZN7S2208C2D0Ev();
extern void _ZN7S2208C42v3Ev();
extern void _ZN7S2208C42v4Ev();
extern void _ZN7S2208C42v5Ev();
extern void _ZN7S2208C42v6Ev();
extern void _ZN7S2208C42v7Ev();
extern void _ZN7S2208C42v8Ev();
extern void _ZN7S2208C42v9Ev();
extern void _ZN7S2208C43v10Ev();
extern void _ZN7S2208C43v11Ev();
extern void _ZN7S2208C43v12Ev();
extern void _ZN7S2208C43v13Ev();
extern void _ZN7S2208C43v14Ev();
extern void _ZN7S2208C33v15Ev();
extern void _ZN7S2208C33v16Ev();
extern void _ZN7S2208C33v17Ev();
extern void _ZN7S2208C33v18Ev();
extern void _ZN7S2208C33v19Ev();
extern void _ZN7S2208C33v20Ev();
extern void _ZN7S2208C33v21Ev();
extern void _ZN7S2208C23v58Ev();
extern void _ZN7S2208C23v59Ev();
extern void _ZN7S2208C23v60Ev();
extern void _ZN7S2208C23v61Ev();
extern void _ZN7S2208C23v62Ev();
extern void _ZN7S2208C23v63Ev();
extern void _ZN7S2208C23v64Ev();
extern void _ZN7S2208C23v65Ev();
extern void _ZN7S2208C23v66Ev();
extern void _ZN7S2208C23v67Ev();
extern void _ZN7S2208C23v68Ev();
extern void _ZN7S2208C23v69Ev();
extern void _ZN7S2208C23v70Ev();
extern void _ZN7S2208C23v71Ev();
extern void _ZN7S2208C23v72Ev();
extern void _ZN7S2208C23v73Ev();
extern void _ZN7S2208C23v74Ev();
extern void _ZN7S2208C23v75Ev();
extern void _ZN7S2208C23v76Ev();
extern void _ZN7S2208C23v77Ev();
extern void _ZN7S2208C23v78Ev();
extern void _ZN7S2208C23v79Ev();
extern void _ZN7S2208C23v80Ev();
extern void _ZN7S2208C23v81Ev();
extern void _ZN7S2208C23v82Ev();
extern void _ZN7S2208C23v83Ev();
extern void _ZN7S2208C23v84Ev();
extern void _ZN7S2208C23v85Ev();
extern void _ZN7S2208C23v86Ev();
extern void _ZN7S2208C23v87Ev();
extern void _ZN7S2208C23v88Ev();
extern void _ZN7S2208C23v89Ev();
extern void ABISELECT(_ZThn96_N7S2208C2D1Ev,_ZThn56_N7S2208C2D1Ev)();
extern void ABISELECT(_ZThn96_N7S2208C2D0Ev,_ZThn56_N7S2208C2D0Ev)();
extern void _ZN8S2208C153v22Ev();
extern void _ZN8S2208C153v23Ev();
extern void _ZN8S2208C153v24Ev();
extern void _ZN8S2208C143v25Ev();
extern void _ZN8S2208C143v26Ev();
extern void _ZN8S2208C143v27Ev();
extern void _ZN8S2208C143v28Ev();
extern void _ZN8S2208C133v29Ev();
extern void _ZN8S2208C133v30Ev();
extern void _ZN8S2208C133v31Ev();
extern void ABISELECT(_ZThn168_N7S2208C2D1Ev,_ZThn96_N7S2208C2D1Ev)();
extern void ABISELECT(_ZThn168_N7S2208C2D0Ev,_ZThn96_N7S2208C2D0Ev)();
extern void _ZN8S2208C193v32Ev();
extern void _ZN8S2208C193v33Ev();
extern void _ZN8S2208C193v34Ev();
extern void _ZN8S2208C193v35Ev();
extern void _ZN8S2208C193v36Ev();
extern void _ZN8S2208C193v37Ev();
extern void _ZN8S2208C193v38Ev();
extern void _ZN8S2208C193v39Ev();
extern void _ZN8S2208C193v40Ev();
extern void _ZN8S2208C193v41Ev();
extern void _ZN8S2208C193v42Ev();
extern void _ZN8S2208C193v43Ev();
extern void _ZN8S2208C193v44Ev();
extern void _ZN8S2208C193v45Ev();
extern void _ZN8S2208C193v46Ev();
extern void _ZN8S2208C193v47Ev();
extern void _ZN8S2208C193v48Ev();
extern void _ZN8S2208C193v49Ev();
extern void _ZN8S2208C193v50Ev();
extern void _ZN8S2208C193v51Ev();
extern void _ZN8S2208C193v52Ev();
extern void _ZN8S2208C193v53Ev();
extern void _ZN8S2208C193v54Ev();
extern void _ZN8S2208C193v55Ev();
extern void _ZN8S2208C193v56Ev();
extern void _ZN8S2208C193v57Ev();
static  VTBL_ENTRY vtc_S2208C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2208C2[0]),
  (VTBL_ENTRY)&_ZN7S2208C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2208C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2208C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2208C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2208C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2208C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2208C43v14Ev,
  (VTBL_ENTRY)&_ZN7S2208C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2208C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2208C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2208C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2208C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2208C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2208C33v21Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v58Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v59Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v60Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v61Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v62Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v63Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v64Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v65Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v66Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v67Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v68Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v69Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v70Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v71Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v72Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v73Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v74Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v75Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v76Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v77Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v78Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v79Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v80Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v81Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v82Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v83Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v84Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v85Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v86Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v87Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v88Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v89Ev,
  ABISELECT(-96,-56),
  (VTBL_ENTRY)&(_ZTI7S2208C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N7S2208C2D1Ev,_ZThn56_N7S2208C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N7S2208C2D0Ev,_ZThn56_N7S2208C2D0Ev),
  (VTBL_ENTRY)&_ZN8S2208C153v22Ev,
  (VTBL_ENTRY)&_ZN8S2208C153v23Ev,
  (VTBL_ENTRY)&_ZN8S2208C153v24Ev,
  (VTBL_ENTRY)&_ZN8S2208C143v25Ev,
  (VTBL_ENTRY)&_ZN8S2208C143v26Ev,
  (VTBL_ENTRY)&_ZN8S2208C143v27Ev,
  (VTBL_ENTRY)&_ZN8S2208C143v28Ev,
  (VTBL_ENTRY)&_ZN8S2208C133v29Ev,
  (VTBL_ENTRY)&_ZN8S2208C133v30Ev,
  (VTBL_ENTRY)&_ZN8S2208C133v31Ev,
  ABISELECT(-168,-96),
  (VTBL_ENTRY)&(_ZTI7S2208C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N7S2208C2D1Ev,_ZThn96_N7S2208C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N7S2208C2D0Ev,_ZThn96_N7S2208C2D0Ev),
  (VTBL_ENTRY)&_ZN8S2208C193v32Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v33Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v34Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v35Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v36Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v37Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v38Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v39Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v40Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v41Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v42Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v43Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v44Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v45Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v46Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v47Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v48Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v49Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v50Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v51Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v52Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v53Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v54Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v55Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v56Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v57Ev,
};
extern VTBL_ENTRY _ZTI7S2208C2[];
extern  VTBL_ENTRY _ZTV7S2208C2[];
Class_Descriptor cd_S2208C2 = {  "S2208C2", // class name
  bases_S2208C2, 6,
  &(vtc_S2208C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(320,208), // object size
  NSPAIRA(_ZTI7S2208C2),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S2208C2),99, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2208C1  : S2208C2 {
  virtual  ~S2208C1(); // _ZN7S2208C1D1Ev
  virtual void  v1(); // _ZN7S2208C12v1Ev
  virtual void  v2(); // _ZN7S2208C12v2Ev
  S2208C1(); // tgen
};
//SIG(1 S2208C1) C1{ BC2{ BC3{ BC4{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 Fp FC5{ BC6{ m Fp Fi FC7{ m} FC8{ m}}} FC9{ m FC10{ Fl[4]}} Fc} vd v15 v16 v17 v18 v19 v20 v21 FC11{ m Fp Fi[2] FC7}} BC12{ BC13{ BC14{ vd v22 v23 v24} vd v25 v26 v27 v28} vd v29 v30 v31 FC15{ m Fp Fi[2] FC8} FC16{ m FC10} Fc} BC17{ vd v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57} vd v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 FC18{ m Fp Fi FC7} Fc[2] Fi Fp[5] Fc[2] Fp FC19{ m Fp Fi[4] Fc Fi[3]} FL[2] Fi[2]} vd v1 v2}


 S2208C1 ::~S2208C1(){ note_dtor("S2208C1", this);}
void  S2208C1 ::v1(){vfunc_called(this, "_ZN7S2208C12v1Ev");}
void  S2208C1 ::v2(){vfunc_called(this, "_ZN7S2208C12v2Ev");}
S2208C1 ::S2208C1(){ note_ctor("S2208C1", this);} // tgen

static void Test_S2208C1()
{
  extern Class_Descriptor cd_S2208C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(41,53)];
    init_test(&cd_S2208C1, buf);
    S2208C1 *dp, &lv = *(dp=new (buf) S2208C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(320,208), "sizeof(S2208C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2208C1)");
    check_base_class_offset(lv, (S2208C4*)(S2208C3*)(S2208C2*), 0, "S2208C1");
    check_base_class_offset(lv, (S2208C3*)(S2208C2*), 0, "S2208C1");
    check_base_class_offset(lv, (S2208C15*)(S2208C14*)(S2208C13*)(S2208C2*), ABISELECT(96,56), "S2208C1");
    check_base_class_offset(lv, (S2208C14*)(S2208C13*)(S2208C2*), ABISELECT(96,56), "S2208C1");
    check_base_class_offset(lv, (S2208C13*)(S2208C2*), ABISELECT(96,56), "S2208C1");
    check_base_class_offset(lv, (S2208C19*)(S2208C2*), ABISELECT(168,96), "S2208C1");
    check_base_class_offset(lv, (S2208C2*), 0, "S2208C1");
    test_class_info(&lv, &cd_S2208C1);
    dp->~S2208C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2208C1(Test_S2208C1, "S2208C1", ABISELECT(320,208));

#else // __cplusplus

extern void _ZN7S2208C1C1Ev();
extern void _ZN7S2208C1D1Ev();
Name_Map name_map_S2208C1[] = {
  NSPAIR(_ZN7S2208C1C1Ev),
  NSPAIR(_ZN7S2208C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2208C4;
extern VTBL_ENTRY _ZTI7S2208C4[];
extern  VTBL_ENTRY _ZTV7S2208C4[];
extern Class_Descriptor cd_S2208C3;
extern VTBL_ENTRY _ZTI7S2208C3[];
extern  VTBL_ENTRY _ZTV7S2208C3[];
extern Class_Descriptor cd_S2208C15;
extern VTBL_ENTRY _ZTI8S2208C15[];
extern  VTBL_ENTRY _ZTV8S2208C15[];
extern Class_Descriptor cd_S2208C14;
extern VTBL_ENTRY _ZTI8S2208C14[];
extern  VTBL_ENTRY _ZTV8S2208C14[];
extern Class_Descriptor cd_S2208C13;
extern VTBL_ENTRY _ZTI8S2208C13[];
extern  VTBL_ENTRY _ZTV8S2208C13[];
extern Class_Descriptor cd_S2208C19;
extern VTBL_ENTRY _ZTI8S2208C19[];
extern  VTBL_ENTRY _ZTV8S2208C19[];
extern Class_Descriptor cd_S2208C2;
extern VTBL_ENTRY _ZTI7S2208C2[];
extern  VTBL_ENTRY _ZTV7S2208C2[];
static Base_Class bases_S2208C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2208C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2208C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2208C15,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2208C14,    ABISELECT(96,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2208C13,    ABISELECT(96,56), //bcp->offset
    57, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2208C19,    ABISELECT(168,96), //bcp->offset
    71, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2208C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2208C1[];
extern void _ZN7S2208C1D1Ev();
extern void _ZN7S2208C1D0Ev();
extern void _ZN7S2208C42v3Ev();
extern void _ZN7S2208C42v4Ev();
extern void _ZN7S2208C42v5Ev();
extern void _ZN7S2208C42v6Ev();
extern void _ZN7S2208C42v7Ev();
extern void _ZN7S2208C42v8Ev();
extern void _ZN7S2208C42v9Ev();
extern void _ZN7S2208C43v10Ev();
extern void _ZN7S2208C43v11Ev();
extern void _ZN7S2208C43v12Ev();
extern void _ZN7S2208C43v13Ev();
extern void _ZN7S2208C43v14Ev();
extern void _ZN7S2208C33v15Ev();
extern void _ZN7S2208C33v16Ev();
extern void _ZN7S2208C33v17Ev();
extern void _ZN7S2208C33v18Ev();
extern void _ZN7S2208C33v19Ev();
extern void _ZN7S2208C33v20Ev();
extern void _ZN7S2208C33v21Ev();
extern void _ZN7S2208C23v58Ev();
extern void _ZN7S2208C23v59Ev();
extern void _ZN7S2208C23v60Ev();
extern void _ZN7S2208C23v61Ev();
extern void _ZN7S2208C23v62Ev();
extern void _ZN7S2208C23v63Ev();
extern void _ZN7S2208C23v64Ev();
extern void _ZN7S2208C23v65Ev();
extern void _ZN7S2208C23v66Ev();
extern void _ZN7S2208C23v67Ev();
extern void _ZN7S2208C23v68Ev();
extern void _ZN7S2208C23v69Ev();
extern void _ZN7S2208C23v70Ev();
extern void _ZN7S2208C23v71Ev();
extern void _ZN7S2208C23v72Ev();
extern void _ZN7S2208C23v73Ev();
extern void _ZN7S2208C23v74Ev();
extern void _ZN7S2208C23v75Ev();
extern void _ZN7S2208C23v76Ev();
extern void _ZN7S2208C23v77Ev();
extern void _ZN7S2208C23v78Ev();
extern void _ZN7S2208C23v79Ev();
extern void _ZN7S2208C23v80Ev();
extern void _ZN7S2208C23v81Ev();
extern void _ZN7S2208C23v82Ev();
extern void _ZN7S2208C23v83Ev();
extern void _ZN7S2208C23v84Ev();
extern void _ZN7S2208C23v85Ev();
extern void _ZN7S2208C23v86Ev();
extern void _ZN7S2208C23v87Ev();
extern void _ZN7S2208C23v88Ev();
extern void _ZN7S2208C23v89Ev();
extern void _ZN7S2208C12v1Ev();
extern void _ZN7S2208C12v2Ev();
extern void ABISELECT(_ZThn96_N7S2208C1D1Ev,_ZThn56_N7S2208C1D1Ev)();
extern void ABISELECT(_ZThn96_N7S2208C1D0Ev,_ZThn56_N7S2208C1D0Ev)();
extern void _ZN8S2208C153v22Ev();
extern void _ZN8S2208C153v23Ev();
extern void _ZN8S2208C153v24Ev();
extern void _ZN8S2208C143v25Ev();
extern void _ZN8S2208C143v26Ev();
extern void _ZN8S2208C143v27Ev();
extern void _ZN8S2208C143v28Ev();
extern void _ZN8S2208C133v29Ev();
extern void _ZN8S2208C133v30Ev();
extern void _ZN8S2208C133v31Ev();
extern void ABISELECT(_ZThn168_N7S2208C1D1Ev,_ZThn96_N7S2208C1D1Ev)();
extern void ABISELECT(_ZThn168_N7S2208C1D0Ev,_ZThn96_N7S2208C1D0Ev)();
extern void _ZN8S2208C193v32Ev();
extern void _ZN8S2208C193v33Ev();
extern void _ZN8S2208C193v34Ev();
extern void _ZN8S2208C193v35Ev();
extern void _ZN8S2208C193v36Ev();
extern void _ZN8S2208C193v37Ev();
extern void _ZN8S2208C193v38Ev();
extern void _ZN8S2208C193v39Ev();
extern void _ZN8S2208C193v40Ev();
extern void _ZN8S2208C193v41Ev();
extern void _ZN8S2208C193v42Ev();
extern void _ZN8S2208C193v43Ev();
extern void _ZN8S2208C193v44Ev();
extern void _ZN8S2208C193v45Ev();
extern void _ZN8S2208C193v46Ev();
extern void _ZN8S2208C193v47Ev();
extern void _ZN8S2208C193v48Ev();
extern void _ZN8S2208C193v49Ev();
extern void _ZN8S2208C193v50Ev();
extern void _ZN8S2208C193v51Ev();
extern void _ZN8S2208C193v52Ev();
extern void _ZN8S2208C193v53Ev();
extern void _ZN8S2208C193v54Ev();
extern void _ZN8S2208C193v55Ev();
extern void _ZN8S2208C193v56Ev();
extern void _ZN8S2208C193v57Ev();
static  VTBL_ENTRY vtc_S2208C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2208C1[0]),
  (VTBL_ENTRY)&_ZN7S2208C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2208C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2208C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2208C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2208C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2208C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2208C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2208C43v14Ev,
  (VTBL_ENTRY)&_ZN7S2208C33v15Ev,
  (VTBL_ENTRY)&_ZN7S2208C33v16Ev,
  (VTBL_ENTRY)&_ZN7S2208C33v17Ev,
  (VTBL_ENTRY)&_ZN7S2208C33v18Ev,
  (VTBL_ENTRY)&_ZN7S2208C33v19Ev,
  (VTBL_ENTRY)&_ZN7S2208C33v20Ev,
  (VTBL_ENTRY)&_ZN7S2208C33v21Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v58Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v59Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v60Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v61Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v62Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v63Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v64Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v65Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v66Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v67Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v68Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v69Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v70Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v71Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v72Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v73Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v74Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v75Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v76Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v77Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v78Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v79Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v80Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v81Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v82Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v83Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v84Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v85Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v86Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v87Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v88Ev,
  (VTBL_ENTRY)&_ZN7S2208C23v89Ev,
  (VTBL_ENTRY)&_ZN7S2208C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2208C12v2Ev,
  ABISELECT(-96,-56),
  (VTBL_ENTRY)&(_ZTI7S2208C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N7S2208C1D1Ev,_ZThn56_N7S2208C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N7S2208C1D0Ev,_ZThn56_N7S2208C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2208C153v22Ev,
  (VTBL_ENTRY)&_ZN8S2208C153v23Ev,
  (VTBL_ENTRY)&_ZN8S2208C153v24Ev,
  (VTBL_ENTRY)&_ZN8S2208C143v25Ev,
  (VTBL_ENTRY)&_ZN8S2208C143v26Ev,
  (VTBL_ENTRY)&_ZN8S2208C143v27Ev,
  (VTBL_ENTRY)&_ZN8S2208C143v28Ev,
  (VTBL_ENTRY)&_ZN8S2208C133v29Ev,
  (VTBL_ENTRY)&_ZN8S2208C133v30Ev,
  (VTBL_ENTRY)&_ZN8S2208C133v31Ev,
  ABISELECT(-168,-96),
  (VTBL_ENTRY)&(_ZTI7S2208C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N7S2208C1D1Ev,_ZThn96_N7S2208C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn168_N7S2208C1D0Ev,_ZThn96_N7S2208C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2208C193v32Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v33Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v34Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v35Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v36Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v37Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v38Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v39Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v40Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v41Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v42Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v43Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v44Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v45Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v46Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v47Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v48Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v49Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v50Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v51Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v52Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v53Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v54Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v55Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v56Ev,
  (VTBL_ENTRY)&_ZN8S2208C193v57Ev,
};
extern VTBL_ENTRY _ZTI7S2208C1[];
extern  VTBL_ENTRY _ZTV7S2208C1[];
Class_Descriptor cd_S2208C1 = {  "S2208C1", // class name
  bases_S2208C1, 7,
  &(vtc_S2208C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(320,208), // object size
  NSPAIRA(_ZTI7S2208C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2208C1),101, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  7, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1608C9_nt  {
  void  mf1608c9(); // _ZN10S1608C9_nt8mf1608c9Ev
  virtual  ~S1608C9_nt(); // _ZN10S1608C9_ntD1Ev
  S1608C9_nt(); // tgen
};
//SIG(-1 S1608C9_nt) C1{ vd m}


void  S1608C9_nt ::mf1608c9(){}
 S1608C9_nt ::~S1608C9_nt(){ note_dtor("S1608C9_nt", this);}
S1608C9_nt ::S1608C9_nt(){ note_ctor("S1608C9_nt", this);} // tgen

//skip512 S1608C9_nt

#else // __cplusplus

extern void _ZN10S1608C9_ntC1Ev();
extern void _ZN10S1608C9_ntD1Ev();
Name_Map name_map_S1608C9_nt[] = {
  NSPAIR(_ZN10S1608C9_ntC1Ev),
  NSPAIR(_ZN10S1608C9_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern void _ZN10S1608C9_ntD1Ev();
extern void _ZN10S1608C9_ntD0Ev();
static  VTBL_ENTRY vtc_S1608C9_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1608C9_nt[0]),
  (VTBL_ENTRY)&_ZN10S1608C9_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1608C9_ntD0Ev,
};
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
VTBL_ENTRY *P__ZTI10S1608C9_nt = _ZTI10S1608C9_nt; 
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
Class_Descriptor cd_S1608C9_nt = {  "S1608C9_nt", // class name
  0,0,//no base classes
  &(vtc_S1608C9_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI10S1608C9_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S1608C9_nt),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1608C6  : S1587C7_nt , S886C9_nt , S1608C9_nt {
  int s1608c6f0;
  virtual  ~S1608C6(); // _ZN7S1608C6D1Ev
  S1608C6(); // tgen
};
//SIG(-1 S1608C6) C1{ BC2{ m} BC3{ m} BC4{ vd m} vd Fi}


 S1608C6 ::~S1608C6(){ note_dtor("S1608C6", this);}
S1608C6 ::S1608C6(){ note_ctor("S1608C6", this);} // tgen

static void Test_S1608C6()
{
  extern Class_Descriptor cd_S1608C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S1608C6, buf);
    S1608C6 *dp, &lv = *(dp=new (buf) S1608C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S1608C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1608C6)");
    check_base_class_offset(lv, (S1587C7_nt*), 0, "S1608C6");
    check_base_class_offset(lv, (S886C9_nt*), 0, "S1608C6");
    check_base_class_offset(lv, (S1608C9_nt*), 0, "S1608C6");
    check_field_offset(lv, s1608c6f0, ABISELECT(8,4), "S1608C6.s1608c6f0");
    test_class_info(&lv, &cd_S1608C6);
    dp->~S1608C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1608C6(Test_S1608C6, "S1608C6", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN7S1608C6C1Ev();
extern void _ZN7S1608C6D1Ev();
Name_Map name_map_S1608C6[] = {
  NSPAIR(_ZN7S1608C6C1Ev),
  NSPAIR(_ZN7S1608C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
static Base_Class bases_S1608C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1587C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S886C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1608C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1608C6[];
extern void _ZN7S1608C6D1Ev();
extern void _ZN7S1608C6D0Ev();
static  VTBL_ENTRY vtc_S1608C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1608C6[0]),
  (VTBL_ENTRY)&_ZN7S1608C6D1Ev,
  (VTBL_ENTRY)&_ZN7S1608C6D0Ev,
};
extern VTBL_ENTRY _ZTI7S1608C6[];
extern  VTBL_ENTRY _ZTV7S1608C6[];
Class_Descriptor cd_S1608C6 = {  "S1608C6", // class name
  bases_S1608C6, 3,
  &(vtc_S1608C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI7S1608C6),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S1608C6),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1608C5  : S1608C6 {
  int s1608c5f0;
  void *s1608c5f1;
  virtual  ~S1608C5(); // _ZN7S1608C5D1Ev
  S1608C5(); // tgen
};
//SIG(-1 S1608C5) C1{ BC2{ BC3{ m} BC4{ m} BC5{ vd m} vd Fi} vd Fi Fp}


 S1608C5 ::~S1608C5(){ note_dtor("S1608C5", this);}
S1608C5 ::S1608C5(){ note_ctor("S1608C5", this);} // tgen

static void Test_S1608C5()
{
  extern Class_Descriptor cd_S1608C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_S1608C5, buf);
    S1608C5 *dp, &lv = *(dp=new (buf) S1608C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S1608C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1608C5)");
    check_base_class_offset(lv, (S1587C7_nt*)(S1608C6*), 0, "S1608C5");
    check_base_class_offset(lv, (S886C9_nt*)(S1608C6*), 0, "S1608C5");
    check_base_class_offset(lv, (S1608C9_nt*)(S1608C6*), 0, "S1608C5");
    check_base_class_offset(lv, (S1608C6*), 0, "S1608C5");
    check_field_offset(lv, s1608c5f0, ABISELECT(12,8), "S1608C5.s1608c5f0");
    check_field_offset(lv, s1608c5f1, ABISELECT(16,12), "S1608C5.s1608c5f1");
    test_class_info(&lv, &cd_S1608C5);
    dp->~S1608C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1608C5(Test_S1608C5, "S1608C5", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN7S1608C5C1Ev();
extern void _ZN7S1608C5D1Ev();
Name_Map name_map_S1608C5[] = {
  NSPAIR(_ZN7S1608C5C1Ev),
  NSPAIR(_ZN7S1608C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
extern Class_Descriptor cd_S1608C6;
extern VTBL_ENTRY _ZTI7S1608C6[];
extern  VTBL_ENTRY _ZTV7S1608C6[];
static Base_Class bases_S1608C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1587C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S886C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1608C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1608C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1608C5[];
extern void _ZN7S1608C5D1Ev();
extern void _ZN7S1608C5D0Ev();
static  VTBL_ENTRY vtc_S1608C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1608C5[0]),
  (VTBL_ENTRY)&_ZN7S1608C5D1Ev,
  (VTBL_ENTRY)&_ZN7S1608C5D0Ev,
};
extern VTBL_ENTRY _ZTI7S1608C5[];
extern  VTBL_ENTRY _ZTV7S1608C5[];
Class_Descriptor cd_S1608C5 = {  "S1608C5", // class name
  bases_S1608C5, 4,
  &(vtc_S1608C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI7S1608C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1608C5),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1608C4  : virtual S1608C5 {
  short s1608c4f0;
  virtual  ~S1608C4(); // _ZN7S1608C4D2Ev
  S1608C4(); // tgen
};
//SIG(-1 S1608C4) C1{ VBC2{ BC3{ BC4{ m} BC5{ m} BC6{ vd m} vd Fi} vd Fi Fp} vd Fs}


 S1608C4 ::~S1608C4(){ note_dtor("S1608C4", this);}
S1608C4 ::S1608C4(){ note_ctor("S1608C4", this);} // tgen

static void Test_S1608C4()
{
  extern Class_Descriptor cd_S1608C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_S1608C4, buf);
    S1608C4 *dp, &lv = *(dp=new (buf) S1608C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(S1608C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1608C4)");
    check_base_class_offset(lv, (S1587C7_nt*)(S1608C6*)(S1608C5*), ABISELECT(16,8), "S1608C4");
    check_base_class_offset(lv, (S886C9_nt*)(S1608C6*)(S1608C5*), ABISELECT(16,8), "S1608C4");
    check_base_class_offset(lv, (S1608C9_nt*)(S1608C6*)(S1608C5*), ABISELECT(16,8), "S1608C4");
    check_base_class_offset(lv, (S1608C6*)(S1608C5*), ABISELECT(16,8), "S1608C4");
    check_base_class_offset(lv, (S1608C5*), ABISELECT(16,8), "S1608C4");
    check_field_offset(lv, s1608c4f0, ABISELECT(8,4), "S1608C4.s1608c4f0");
    test_class_info(&lv, &cd_S1608C4);
    dp->~S1608C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1608C4(Test_S1608C4, "S1608C4", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN7S1608C4C1Ev();
extern void _ZN7S1608C4D2Ev();
Name_Map name_map_S1608C4[] = {
  NSPAIR(_ZN7S1608C4C1Ev),
  NSPAIR(_ZN7S1608C4D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
extern Class_Descriptor cd_S1608C6;
extern VTBL_ENTRY _ZTI7S1608C6[];
extern  VTBL_ENTRY _ZTV7S1608C6[];
extern Class_Descriptor cd_S1608C5;
extern VTBL_ENTRY _ZTI7S1608C5[];
extern  VTBL_ENTRY _ZTV7S1608C5[];
static Base_Class bases_S1608C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1587C7_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S886C9_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1608C9_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1608C6,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S1608C5,    ABISELECT(16,8), //bcp->offset
    5, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S1608C4[];
extern void _ZN7S1608C4D1Ev();
extern void _ZN7S1608C4D0Ev();
extern void ABISELECT(_ZTv0_n24_N7S1608C4D1Ev,_ZTv0_n12_N7S1608C4D1Ev)();
extern void ABISELECT(_ZThn16_N7S1608C4D1Ev,_ZThn8_N7S1608C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S1608C4D0Ev,_ZTv0_n12_N7S1608C4D0Ev)();
extern void ABISELECT(_ZThn16_N7S1608C4D0Ev,_ZThn8_N7S1608C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S1608C4[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7S1608C4[0]),
  (VTBL_ENTRY)&_ZN7S1608C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1608C4D0Ev,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S1608C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S1608C4D1Ev,_ZTv0_n12_N7S1608C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S1608C4D0Ev,_ZTv0_n12_N7S1608C4D0Ev),
};
extern VTBL_ENTRY _ZTV7S1608C4[];
static  VTT_ENTRY vtt_S1608C4[] = {
  {&(_ZTV7S1608C4[3]),  3,10},
  {&(_ZTV7S1608C4[8]),  8,10},
};
extern VTBL_ENTRY _ZTI7S1608C4[];
extern  VTBL_ENTRY _ZTV7S1608C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S1608C4[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S1608C4D0Ev,_ZTv0_n12_N7S1608C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7S1608C4D0Ev,_ZThn8_N7S1608C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S1608C4D1Ev,_ZTv0_n12_N7S1608C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7S1608C4D1Ev,_ZThn8_N7S1608C4D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S1608C4 = {  "S1608C4", // class name
  bases_S1608C4, 5,
  &(vtc_S1608C4[0]), // expected_vtbl_contents
  &(vtt_S1608C4[0]), // expected_vtt_contents
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI7S1608C4),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7S1608C4),10, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S1608C4),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1608C11  : virtual S1608C9_nt , virtual S886C9_nt , S1587C7_nt {
  int s1608c11f0;
  ~S1608C11(); // tgen
  S1608C11(); // tgen
};
//SIG(-1 S1608C11) C1{ VBC2{ vd m} VBC3{ m} BC4{ m} Fi}


S1608C11 ::~S1608C11(){ note_dtor("S1608C11", this);} // tgen
S1608C11 ::S1608C11(){ note_ctor("S1608C11", this);} // tgen

static void Test_S1608C11()
{
  extern Class_Descriptor cd_S1608C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S1608C11, buf);
    S1608C11 *dp, &lv = *(dp=new (buf) S1608C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S1608C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1608C11)");
    check_base_class_offset(lv, (S1608C9_nt*), 0, "S1608C11");
    check_base_class_offset(lv, (S886C9_nt*), 0, "S1608C11");
    check_base_class_offset(lv, (S1587C7_nt*), 0, "S1608C11");
    check_field_offset(lv, s1608c11f0, ABISELECT(8,4), "S1608C11.s1608c11f0");
    test_class_info(&lv, &cd_S1608C11);
    dp->~S1608C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1608C11(Test_S1608C11, "S1608C11", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S1608C11C1Ev();
extern void _ZN8S1608C11D1Ev();
Name_Map name_map_S1608C11[] = {
  NSPAIR(_ZN8S1608C11C1Ev),
  NSPAIR(_ZN8S1608C11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
static Base_Class bases_S1608C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1608C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S886C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S1587C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S1608C11[];
extern void _ZN8S1608C11D1Ev();
extern void _ZN8S1608C11D0Ev();
static  VTBL_ENTRY vtc_S1608C11[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S1608C11[0]),
  (VTBL_ENTRY)&_ZN8S1608C11D1Ev,
  (VTBL_ENTRY)&_ZN8S1608C11D0Ev,
};
extern VTBL_ENTRY _ZTV8S1608C11[];
static  VTT_ENTRY vtt_S1608C11[] = {
  {&(_ZTV8S1608C11[5]),  5,7},
  {&(_ZTV8S1608C11[5]),  5,7},
};
extern VTBL_ENTRY _ZTI8S1608C11[];
extern  VTBL_ENTRY _ZTV8S1608C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C11[];
Class_Descriptor cd_S1608C11 = {  "S1608C11", // class name
  bases_S1608C11, 3,
  &(vtc_S1608C11[0]), // expected_vtbl_contents
  &(vtt_S1608C11[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S1608C11),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S1608C11),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S1608C11),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1608C10  : S1608C11 {
  void *s1608c10f0;
  ~S1608C10(); // tgen
  S1608C10(); // tgen
};
//SIG(-1 S1608C10) C1{ BC2{ VBC3{ vd m} VBC4{ m} BC5{ m} Fi} Fp}


S1608C10 ::~S1608C10(){ note_dtor("S1608C10", this);} // tgen
S1608C10 ::S1608C10(){ note_ctor("S1608C10", this);} // tgen

static void Test_S1608C10()
{
  extern Class_Descriptor cd_S1608C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S1608C10, buf);
    S1608C10 *dp, &lv = *(dp=new (buf) S1608C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S1608C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1608C10)");
    check_base_class_offset(lv, (S1608C9_nt*)(S1608C11*), 0, "S1608C10");
    check_base_class_offset(lv, (S886C9_nt*)(S1608C11*), 0, "S1608C10");
    check_base_class_offset(lv, (S1587C7_nt*)(S1608C11*), 0, "S1608C10");
    check_base_class_offset(lv, (S1608C11*), 0, "S1608C10");
    check_field_offset(lv, s1608c10f0, ABISELECT(16,8), "S1608C10.s1608c10f0");
    test_class_info(&lv, &cd_S1608C10);
    dp->~S1608C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1608C10(Test_S1608C10, "S1608C10", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN8S1608C10C1Ev();
extern void _ZN8S1608C10D1Ev();
Name_Map name_map_S1608C10[] = {
  NSPAIR(_ZN8S1608C10C1Ev),
  NSPAIR(_ZN8S1608C10D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1608C11;
extern VTBL_ENTRY _ZTI8S1608C11[];
extern  VTBL_ENTRY _ZTV8S1608C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C11[];
static Base_Class bases_S1608C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1608C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S886C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S1587C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1608C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S1608C10[];
extern void _ZN8S1608C10D1Ev();
extern void _ZN8S1608C10D0Ev();
static  VTBL_ENTRY vtc_S1608C10[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S1608C10[0]),
  (VTBL_ENTRY)&_ZN8S1608C10D1Ev,
  (VTBL_ENTRY)&_ZN8S1608C10D0Ev,
};
extern VTBL_ENTRY _ZTV8S1608C10[];
extern void _ZN8S1608C11D1Ev();
extern void _ZN8S1608C11D0Ev();
static  VTBL_ENTRY _tg__ZTV8S1608C11__8S1608C10[] = {
  0,
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S1608C11[0]),
  (VTBL_ENTRY)&_ZN8S1608C11D1Ev,
  (VTBL_ENTRY)&_ZN8S1608C11D0Ev,
};
static  VTT_ENTRY vtt_S1608C10[] = {
  {&(_ZTV8S1608C10[5]),  5,7},
  {&(_tg__ZTV8S1608C11__8S1608C10[5]),  5,7},
  {&(_tg__ZTV8S1608C11__8S1608C10[5]),  5,7},
  {&(_ZTV8S1608C10[5]),  5,7},
};
extern VTBL_ENTRY _ZTI8S1608C10[];
extern  VTBL_ENTRY _ZTV8S1608C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C10[];
Class_Descriptor cd_S1608C10 = {  "S1608C10", // class name
  bases_S1608C10, 4,
  &(vtc_S1608C10[0]), // expected_vtbl_contents
  &(vtt_S1608C10[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI8S1608C10),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S1608C10),7, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S1608C10),4, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1608C13  : S1587C7_nt {
  virtual void  v2(); // _ZN8S1608C132v2Ev
  ~S1608C13(); // tgen
  S1608C13(); // tgen
};
//SIG(-1 S1608C13) C1{ BC2{ m} v1}


void  S1608C13 ::v2(){vfunc_called(this, "_ZN8S1608C132v2Ev");}
S1608C13 ::~S1608C13(){ note_dtor("S1608C13", this);} // tgen
S1608C13 ::S1608C13(){ note_ctor("S1608C13", this);} // tgen

static void Test_S1608C13()
{
  extern Class_Descriptor cd_S1608C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S1608C13, buf);
    S1608C13 *dp, &lv = *(dp=new (buf) S1608C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S1608C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1608C13)");
    check_base_class_offset(lv, (S1587C7_nt*), 0, "S1608C13");
    test_class_info(&lv, &cd_S1608C13);
    dp->~S1608C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1608C13(Test_S1608C13, "S1608C13", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN8S1608C13C1Ev();
extern void _ZN8S1608C13D1Ev();
Name_Map name_map_S1608C13[] = {
  NSPAIR(_ZN8S1608C13C1Ev),
  NSPAIR(_ZN8S1608C13D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
static Base_Class bases_S1608C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1587C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S1608C13[];
extern void _ZN8S1608C132v2Ev();
static  VTBL_ENTRY vtc_S1608C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S1608C13[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
};
extern VTBL_ENTRY _ZTI8S1608C13[];
extern  VTBL_ENTRY _ZTV8S1608C13[];
Class_Descriptor cd_S1608C13 = {  "S1608C13", // class name
  bases_S1608C13, 1,
  &(vtc_S1608C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI8S1608C13),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S1608C13),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1608C12  : virtual S1608C9_nt , S886C9_nt , virtual S1608C6 , S1587C7_nt , S1608C13 {
  virtual void  v3(); // _ZN8S1608C122v3Ev
  ~S1608C12(); // tgen
  S1608C12(); // tgen
};
//SIG(-1 S1608C12) C1{ VBC2{ vd m} BC3{ m} VBC4{ BC5{ m} BC3 BC2 vd Fi} BC5 BC6{ BC5 v2} v1}


void  S1608C12 ::v3(){vfunc_called(this, "_ZN8S1608C122v3Ev");}
S1608C12 ::~S1608C12(){ note_dtor("S1608C12", this);} // tgen
S1608C12 ::S1608C12(){ note_ctor("S1608C12", this);} // tgen

static void Test_S1608C12()
{
  extern Class_Descriptor cd_S1608C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[5];
    init_test(&cd_S1608C12, buf);
    S1608C12 *dp, &lv = *(dp=new (buf) S1608C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S1608C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1608C12)");
    /*is_ambiguous_... S1608C12::S1608C9_nt */ AMB_check_base_class_offset(lv, (S1608C9_nt*), ABISELECT(8,4), "S1608C12");
    /*is_ambiguous_... S1608C12::S886C9_nt */ AMB_check_base_class_offset(lv, (S886C9_nt*), 0, "S1608C12");
    check_base_class_offset(lv, (S1587C7_nt*)(S1608C6*), ABISELECT(16,8), "S1608C12");
    check_base_class_offset(lv, (S886C9_nt*)(S1608C6*), ABISELECT(16,8), "S1608C12");
    check_base_class_offset(lv, (S1608C9_nt*)(S1608C6*), ABISELECT(16,8), "S1608C12");
    check_base_class_offset(lv, (S1608C6*), ABISELECT(16,8), "S1608C12");
    /*is_ambiguous_... S1608C12::S1587C7_nt */ AMB_check_base_class_offset(lv, (S1587C7_nt*), ABISELECT(8,4), "S1608C12");
    check_base_class_offset(lv, (S1587C7_nt*)(S1608C13*), 0, "S1608C12");
    check_base_class_offset(lv, (S1608C13*), 0, "S1608C12");
    test_class_info(&lv, &cd_S1608C12);
    dp->~S1608C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1608C12(Test_S1608C12, "S1608C12", ABISELECT(32,16));

#else // __cplusplus

extern void _ZN8S1608C12C1Ev();
extern void _ZN8S1608C12D1Ev();
Name_Map name_map_S1608C12[] = {
  NSPAIR(_ZN8S1608C12C1Ev),
  NSPAIR(_ZN8S1608C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
extern Class_Descriptor cd_S1608C6;
extern VTBL_ENTRY _ZTI7S1608C6[];
extern  VTBL_ENTRY _ZTV7S1608C6[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1608C13;
extern VTBL_ENTRY _ZTI8S1608C13[];
extern  VTBL_ENTRY _ZTV8S1608C13[];
static Base_Class bases_S1608C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1608C9_nt,    ABISELECT(8,4), //bcp->offset
    8, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S886C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1587C7_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S886C9_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S1608C9_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S1608C6,    ABISELECT(16,8), //bcp->offset
    13, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S1587C7_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1587C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S1608C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S1608C12[];
extern void _ZN8S1608C132v2Ev();
extern void _ZN8S1608C122v3Ev();
extern void _ZN8S1608C12D1Ev();
extern void _ZN8S1608C12D0Ev();
extern void ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev)();
extern void ABISELECT(_ZThn8_N8S1608C12D1Ev,_ZThn4_N8S1608C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev)();
extern void ABISELECT(_ZThn8_N8S1608C12D0Ev,_ZThn4_N8S1608C12D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev)();
extern void ABISELECT(_ZThn16_N8S1608C12D1Ev,_ZThn8_N8S1608C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev)();
extern void ABISELECT(_ZThn16_N8S1608C12D0Ev,_ZThn8_N8S1608C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S1608C12[] = {
  ABISELECT(16,8),
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI8S1608C12[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
  (VTBL_ENTRY)&_ZN8S1608C122v3Ev,
  (VTBL_ENTRY)&_ZN8S1608C12D1Ev,
  (VTBL_ENTRY)&_ZN8S1608C12D0Ev,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S1608C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev),
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S1608C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev),
};
extern VTBL_ENTRY _ZTV8S1608C12[];
static  VTT_ENTRY vtt_S1608C12[] = {
  {&(_ZTV8S1608C12[4]),  4,18},
  {&(_ZTV8S1608C12[11]),  11,18},
  {&(_ZTV8S1608C12[16]),  16,18},
};
extern VTBL_ENTRY _ZTI8S1608C12[];
extern  VTBL_ENTRY _ZTV8S1608C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C12[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S1608C12D0Ev,_ZThn8_N8S1608C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn8_N8S1608C12D0Ev,_ZThn4_N8S1608C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S1608C12D1Ev,_ZThn8_N8S1608C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn8_N8S1608C12D1Ev,_ZThn4_N8S1608C12D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S1608C12 = {  "S1608C12", // class name
  bases_S1608C12, 9,
  &(vtc_S1608C12[0]), // expected_vtbl_contents
  &(vtt_S1608C12[0]), // expected_vtt_contents
  ABISELECT(32,16), // object size
  NSPAIRA(_ZTI8S1608C12),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S1608C12),18, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S1608C12),3, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1608C3  : S1608C4 , virtual S1608C10 , virtual S1608C12 {
  virtual  ~S1608C3(); // _ZN7S1608C3D2Ev
  S1608C3(); // tgen
};
//SIG(-1 S1608C3) C1{ BC2{ VBC3{ BC4{ BC5{ m} BC6{ m} BC7{ vd m} vd Fi} vd Fi Fp} vd Fs} VBC8{ BC9{ VBC7 VBC6 BC5 Fi} Fp} VBC10{ VBC7 BC6 VBC4 BC5 BC11{ BC5 v1} v2} vd}


 S1608C3 ::~S1608C3(){ note_dtor("S1608C3", this);}
S1608C3 ::S1608C3(){ note_ctor("S1608C3", this);} // tgen

static void Test_S1608C3()
{
  extern Class_Descriptor cd_S1608C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,14)];
    init_test(&cd_S1608C3, buf);
    S1608C3 *dp, &lv = *(dp=new (buf) S1608C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,52), "sizeof(S1608C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1608C3)");
    check_base_class_offset(lv, (S1587C7_nt*)(S1608C6*)(S1608C5*), ABISELECT(16,8), "S1608C3");
    check_base_class_offset(lv, (S886C9_nt*)(S1608C6*)(S1608C5*), ABISELECT(16,8), "S1608C3");
    check_base_class_offset(lv, (S1608C9_nt*)(S1608C6*)(S1608C5*), ABISELECT(16,8), "S1608C3");
    check_base_class_offset(lv, (S1608C6*)(S1608C5*), ABISELECT(16,8), "S1608C3");
    check_base_class_offset(lv, (S1608C5*)(S1608C4*), ABISELECT(16,8), "S1608C3");
    check_base_class_offset(lv, (S1608C4*), 0, "S1608C3");
    check_base_class_offset(lv, (S1608C9_nt*)(S1608C11*)(S1608C10*), ABISELECT(40,24), "S1608C3");
    /*is_ambiguous_... S1608C12::S1608C9_nt */ AMB_check_base_class_offset(lv, (S1608C9_nt*)(S1608C12*), ABISELECT(40,24), "S1608C3");
    check_base_class_offset(lv, (S886C9_nt*)(S1608C11*)(S1608C10*), 0, "S1608C3");
    check_base_class_offset(lv, (S1587C7_nt*)(S1608C11*)(S1608C10*), ABISELECT(40,24), "S1608C3");
    check_base_class_offset(lv, (S1608C11*)(S1608C10*), ABISELECT(40,24), "S1608C3");
    check_base_class_offset(lv, (S1608C10*), ABISELECT(40,24), "S1608C3");
    /*is_ambiguous_... S1608C12::S886C9_nt */ AMB_check_base_class_offset(lv, (S886C9_nt*)(S1608C12*), ABISELECT(64,36), "S1608C3");
    /*is_ambiguous_... S1608C3::S1608C6 */ AMB_check_base_class_offset(lv, (S1587C7_nt*)(S1608C6*), ABISELECT(80,44), "S1608C3");
    /*is_ambiguous_... S1608C3::S1608C6 */ AMB_check_base_class_offset(lv, (S886C9_nt*)(S1608C6*), ABISELECT(80,44), "S1608C3");
    /*is_ambiguous_... S1608C3::S1608C6 */ AMB_check_base_class_offset(lv, (S1608C9_nt*)(S1608C6*), ABISELECT(80,44), "S1608C3");
    check_base_class_offset(lv, (S1608C6*)(S1608C12*), ABISELECT(80,44), "S1608C3");
    /*is_ambiguous_... S1608C12::S1587C7_nt */ AMB_check_base_class_offset(lv, (S1587C7_nt*)(S1608C12*), ABISELECT(72,40), "S1608C3");
    check_base_class_offset(lv, (S1587C7_nt*)(S1608C13*)(S1608C12*), ABISELECT(64,36), "S1608C3");
    check_base_class_offset(lv, (S1608C13*)(S1608C12*), ABISELECT(64,36), "S1608C3");
    check_base_class_offset(lv, (S1608C12*), ABISELECT(64,36), "S1608C3");
    test_class_info(&lv, &cd_S1608C3);
    dp->~S1608C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1608C3(Test_S1608C3, "S1608C3", ABISELECT(96,52));

#else // __cplusplus

extern void _ZN7S1608C3C1Ev();
extern void _ZN7S1608C3D2Ev();
Name_Map name_map_S1608C3[] = {
  NSPAIR(_ZN7S1608C3C1Ev),
  NSPAIR(_ZN7S1608C3D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
extern Class_Descriptor cd_S1608C6;
extern VTBL_ENTRY _ZTI7S1608C6[];
extern  VTBL_ENTRY _ZTV7S1608C6[];
extern Class_Descriptor cd_S1608C5;
extern VTBL_ENTRY _ZTI7S1608C5[];
extern  VTBL_ENTRY _ZTV7S1608C5[];
extern Class_Descriptor cd_S1608C4;
extern VTBL_ENTRY _ZTI7S1608C4[];
extern  VTBL_ENTRY _ZTV7S1608C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S1608C4[];
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1608C11;
extern VTBL_ENTRY _ZTI8S1608C11[];
extern  VTBL_ENTRY _ZTV8S1608C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C11[];
extern Class_Descriptor cd_S1608C10;
extern VTBL_ENTRY _ZTI8S1608C10[];
extern  VTBL_ENTRY _ZTV8S1608C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C10[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
extern Class_Descriptor cd_S1608C6;
extern VTBL_ENTRY _ZTI7S1608C6[];
extern  VTBL_ENTRY _ZTV7S1608C6[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1608C13;
extern VTBL_ENTRY _ZTI8S1608C13[];
extern  VTBL_ENTRY _ZTV8S1608C13[];
extern Class_Descriptor cd_S1608C12;
extern VTBL_ENTRY _ZTI8S1608C12[];
extern  VTBL_ENTRY _ZTV8S1608C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C12[];
static Base_Class bases_S1608C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1587C7_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S886C9_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1608C9_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1608C6,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S1608C5,    ABISELECT(16,8), //bcp->offset
    10, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S1608C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1608C9_nt,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S886C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S1587C7_nt,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S1608C11,    ABISELECT(40,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S1608C10,    ABISELECT(40,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S886C9_nt,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S1587C7_nt,    ABISELECT(80,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S886C9_nt,    ABISELECT(80,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S1608C9_nt,    ABISELECT(80,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S1608C6,    ABISELECT(80,44), //bcp->offset
    33, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    19, //immediately_derived
  0, 1},
  {&cd_S1587C7_nt,    ABISELECT(72,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S1587C7_nt,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S1608C13,    ABISELECT(64,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S1608C12,    ABISELECT(64,36), //bcp->offset
    22, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S1608C3[];
extern void _ZN7S1608C3D1Ev();
extern void _ZN7S1608C3D0Ev();
extern void ABISELECT(_ZTv0_n24_N7S1608C3D1Ev,_ZTv0_n12_N7S1608C3D1Ev)();
extern void ABISELECT(_ZThn16_N7S1608C3D1Ev,_ZThn8_N7S1608C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S1608C3D0Ev,_ZTv0_n12_N7S1608C3D0Ev)();
extern void ABISELECT(_ZThn16_N7S1608C3D0Ev,_ZThn8_N7S1608C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S1608C3D1Ev,_ZTv0_n12_N7S1608C3D1Ev)();
extern void ABISELECT(_ZThn40_N7S1608C3D1Ev,_ZThn24_N7S1608C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S1608C3D0Ev,_ZTv0_n12_N7S1608C3D0Ev)();
extern void ABISELECT(_ZThn40_N7S1608C3D0Ev,_ZThn24_N7S1608C3D0Ev)() __attribute__((weak));
extern void _ZN8S1608C132v2Ev();
extern void _ZN8S1608C122v3Ev();
extern void ABISELECT(_ZTv0_n56_N7S1608C3D1Ev,_ZTv0_n28_N7S1608C3D1Ev)();
extern void ABISELECT(_ZThn64_N7S1608C3D1Ev,_ZThn36_N7S1608C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S1608C3D0Ev,_ZTv0_n28_N7S1608C3D0Ev)();
extern void ABISELECT(_ZThn64_N7S1608C3D0Ev,_ZThn36_N7S1608C3D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S1608C3D1Ev,_ZTv0_n12_N7S1608C3D1Ev)();
extern void ABISELECT(_ZThn80_N7S1608C3D1Ev,_ZThn44_N7S1608C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S1608C3D0Ev,_ZTv0_n12_N7S1608C3D0Ev)();
extern void ABISELECT(_ZThn80_N7S1608C3D0Ev,_ZThn44_N7S1608C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S1608C3[] = {
  ABISELECT(80,44),
  ABISELECT(64,36),
  0,
  ABISELECT(40,24),
  ABISELECT(40,24),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7S1608C3[0]),
  (VTBL_ENTRY)&_ZN7S1608C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1608C3D0Ev,
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S1608C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S1608C3D1Ev,_ZTv0_n12_N7S1608C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S1608C3D0Ev,_ZTv0_n12_N7S1608C3D0Ev),
  ABISELECT(-40,-24),
  0,
  ABISELECT(-40,-24),
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI7S1608C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S1608C3D1Ev,_ZTv0_n12_N7S1608C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S1608C3D0Ev,_ZTv0_n12_N7S1608C3D0Ev),
  ABISELECT(-64,-36),
  0,
  0,
  ABISELECT(16,8),
  ABISELECT(-24,-12),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI7S1608C3[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
  (VTBL_ENTRY)&_ZN8S1608C122v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S1608C3D1Ev,_ZTv0_n28_N7S1608C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S1608C3D0Ev,_ZTv0_n28_N7S1608C3D0Ev),
  ABISELECT(-80,-44),
  ABISELECT(-80,-44),
  (VTBL_ENTRY)&(_ZTI7S1608C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S1608C3D1Ev,_ZTv0_n12_N7S1608C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S1608C3D0Ev,_ZTv0_n12_N7S1608C3D0Ev),
};
extern VTBL_ENTRY _ZTV7S1608C3[];
extern void _ZN7S1608C4D1Ev();
extern void _ZN7S1608C4D0Ev();
static  VTBL_ENTRY _tg__ZTV7S1608C4__7S1608C3[] = {
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI7S1608C4[0]),
  (VTBL_ENTRY)&_ZN7S1608C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1608C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S1608C4D1Ev,_ZTv0_n12_N7S1608C4D1Ev)();
extern void ABISELECT(_ZThn16_N7S1608C4D1Ev,_ZThn8_N7S1608C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S1608C4D0Ev,_ZTv0_n12_N7S1608C4D0Ev)();
extern void ABISELECT(_ZThn16_N7S1608C4D0Ev,_ZThn8_N7S1608C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S1608C5__7S1608C4__7S1608C3[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI7S1608C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S1608C4D1Ev,_ZTv0_n12_N7S1608C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S1608C4D0Ev,_ZTv0_n12_N7S1608C4D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S1608C10D1Ev,_ZTv0_n12_N8S1608C10D1Ev)();
extern void _ZN8S1608C10D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C10D0Ev,_ZTv0_n12_N8S1608C10D0Ev)();
extern void _ZN8S1608C10D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S1608C10__7S1608C3[] = {
  ABISELECT(-40,-24),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S1608C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C10D1Ev,_ZTv0_n12_N8S1608C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C10D0Ev,_ZTv0_n12_N8S1608C10D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S1608C11D1Ev,_ZTv0_n12_N8S1608C11D1Ev)();
extern void _ZN8S1608C11D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C11D0Ev,_ZTv0_n12_N8S1608C11D0Ev)();
extern void _ZN8S1608C11D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S1608C118S1608C10__7S1608C3[] = {
  ABISELECT(-40,-24),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S1608C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C11D1Ev,_ZTv0_n12_N8S1608C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C11D0Ev,_ZTv0_n12_N8S1608C11D0Ev),
};
extern void _ZN8S1608C132v2Ev();
extern void _ZN8S1608C122v3Ev();
extern void _ZN8S1608C12D1Ev();
extern void _ZN8S1608C12D0Ev();
static  VTBL_ENTRY _tg__ZTV8S1608C12__7S1608C3[] = {
  ABISELECT(16,8),
  ABISELECT(-24,-12),
  0,
  (VTBL_ENTRY)&(_ZTI8S1608C12[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
  (VTBL_ENTRY)&_ZN8S1608C122v3Ev,
  (VTBL_ENTRY)&_ZN8S1608C12D1Ev,
  (VTBL_ENTRY)&_ZN8S1608C12D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV10S1608C9_nt__8S1608C12__7S1608C3[] = {
  ABISELECT(24,12),
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI8S1608C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev)();
extern void ABISELECT(_ZThn16_N8S1608C12D1Ev,_ZThn8_N8S1608C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev)();
extern void ABISELECT(_ZThn16_N8S1608C12D0Ev,_ZThn8_N8S1608C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S1608C6__8S1608C12__7S1608C3[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S1608C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev),
};
static  VTT_ENTRY vtt_S1608C3[] = {
  {&(_ZTV7S1608C3[8]),  8,38},
  {&(_tg__ZTV7S1608C4__7S1608C3[3]),  3,5},
  {&(_tg__ZTV7S1608C5__7S1608C4__7S1608C3[3]),  3,5},
  {&(_ZTV7S1608C3[13]),  13,38},
  {&(_ZTV7S1608C3[20]),  20,38},
  {&(_ZTV7S1608C3[20]),  20,38},
  {&(_ZTV7S1608C3[29]),  29,38},
  {&(_ZTV7S1608C3[36]),  36,38},
  {&(_tg__ZTV8S1608C10__7S1608C3[5]),  5,7},
  {&(_tg__ZTV8S1608C118S1608C10__7S1608C3[5]),  5,7},
  {&(_tg__ZTV8S1608C118S1608C10__7S1608C3[5]),  5,7},
  {&(_tg__ZTV8S1608C10__7S1608C3[5]),  5,7},
  {&(_tg__ZTV8S1608C12__7S1608C3[4]),  4,8},
  {&(_tg__ZTV10S1608C9_nt__8S1608C12__7S1608C3[3]),  3,5},
  {&(_tg__ZTV7S1608C6__8S1608C12__7S1608C3[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7S1608C3[];
extern  VTBL_ENTRY _ZTV7S1608C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S1608C3[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S1608C12D0Ev,_ZThn8_N8S1608C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S1608C12D1Ev,_ZThn8_N8S1608C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C11D0Ev,_ZTv0_n12_N8S1608C11D0Ev), // 
  (VTBL_ENTRY)_ZN8S1608C11D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C11D1Ev,_ZTv0_n12_N8S1608C11D1Ev), // 
  (VTBL_ENTRY)_ZN8S1608C11D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C10D0Ev,_ZTv0_n12_N8S1608C10D0Ev), // 
  (VTBL_ENTRY)_ZN8S1608C10D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C10D1Ev,_ZTv0_n12_N8S1608C10D1Ev), // 
  (VTBL_ENTRY)_ZN8S1608C10D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S1608C4D0Ev,_ZTv0_n12_N7S1608C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7S1608C4D0Ev,_ZThn8_N7S1608C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S1608C4D1Ev,_ZTv0_n12_N7S1608C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7S1608C4D1Ev,_ZThn8_N7S1608C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S1608C3D0Ev,_ZTv0_n28_N7S1608C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N7S1608C3D0Ev,_ZThn36_N7S1608C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S1608C3D1Ev,_ZTv0_n28_N7S1608C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn64_N7S1608C3D1Ev,_ZThn36_N7S1608C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S1608C3D0Ev,_ZTv0_n12_N7S1608C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N7S1608C3D0Ev,_ZThn44_N7S1608C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N7S1608C3D0Ev,_ZThn24_N7S1608C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7S1608C3D0Ev,_ZThn8_N7S1608C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S1608C3D1Ev,_ZTv0_n12_N7S1608C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N7S1608C3D1Ev,_ZThn44_N7S1608C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N7S1608C3D1Ev,_ZThn24_N7S1608C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N7S1608C3D1Ev,_ZThn8_N7S1608C3D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S1608C3 = {  "S1608C3", // class name
  bases_S1608C3, 20,
  &(vtc_S1608C3[0]), // expected_vtbl_contents
  &(vtt_S1608C3[0]), // expected_vtt_contents
  ABISELECT(96,52), // object size
  NSPAIRA(_ZTI7S1608C3),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S1608C3),38, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S1608C3),15, //virtual table table var
  11, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1608C16  : S1608C13 , virtual S886C9_nt , virtual S1608C12 {
  int s1608c16f0;
  virtual void  v4(); // _ZN8S1608C162v4Ev
  ~S1608C16(); // tgen
  S1608C16(); // tgen
};
//SIG(-1 S1608C16) C1{ BC2{ BC3{ m} v2} VBC4{ m} VBC5{ VBC6{ vd m} BC4 VBC7{ BC3 BC4 BC6 vd Fi} BC3 BC2 v3} v1 Fi}


void  S1608C16 ::v4(){vfunc_called(this, "_ZN8S1608C162v4Ev");}
S1608C16 ::~S1608C16(){ note_dtor("S1608C16", this);} // tgen
S1608C16 ::S1608C16(){ note_ctor("S1608C16", this);} // tgen

static void Test_S1608C16()
{
  extern Class_Descriptor cd_S1608C16;
  void *lvp;
  {
    ABISELECT(double,int) buf[8];
    init_test(&cd_S1608C16, buf);
    S1608C16 *dp, &lv = *(dp=new (buf) S1608C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(56,28), "sizeof(S1608C16)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1608C16)");
    /*is_ambiguous_... S1608C16::S1608C13 */ AMB_check_base_class_offset(lv, (S1587C7_nt*)(S1608C13*), 0, "S1608C16");
    /*is_ambiguous_... S1608C16::S1608C13 */ AMB_check_base_class_offset(lv, (S1608C13*), 0, "S1608C16");
    /*is_ambiguous_... S1608C16::S886C9_nt */ AMB_check_base_class_offset(lv, (S886C9_nt*), 0, "S1608C16");
    /*is_ambiguous_... S1608C12::S1608C9_nt */ AMB_check_base_class_offset(lv, (S1608C9_nt*)(S1608C12*), ABISELECT(32,16), "S1608C16");
    /*is_ambiguous_... S1608C12::S886C9_nt */ AMB_check_base_class_offset(lv, (S886C9_nt*)(S1608C12*), ABISELECT(16,8), "S1608C16");
    check_base_class_offset(lv, (S1587C7_nt*)(S1608C6*), ABISELECT(40,20), "S1608C16");
    check_base_class_offset(lv, (S886C9_nt*)(S1608C6*), ABISELECT(40,20), "S1608C16");
    check_base_class_offset(lv, (S1608C9_nt*)(S1608C6*), ABISELECT(40,20), "S1608C16");
    check_base_class_offset(lv, (S1608C6*)(S1608C12*), ABISELECT(40,20), "S1608C16");
    /*is_ambiguous_... S1608C12::S1587C7_nt */ AMB_check_base_class_offset(lv, (S1587C7_nt*)(S1608C12*), ABISELECT(24,12), "S1608C16");
    check_base_class_offset(lv, (S1587C7_nt*)(S1608C13*)(S1608C12*), ABISELECT(16,8), "S1608C16");
    check_base_class_offset(lv, (S1608C13*)(S1608C12*), ABISELECT(16,8), "S1608C16");
    check_base_class_offset(lv, (S1608C12*), ABISELECT(16,8), "S1608C16");
    check_field_offset(lv, s1608c16f0, ABISELECT(8,4), "S1608C16.s1608c16f0");
    test_class_info(&lv, &cd_S1608C16);
    dp->~S1608C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1608C16(Test_S1608C16, "S1608C16", ABISELECT(56,28));

#else // __cplusplus

extern void _ZN8S1608C16C1Ev();
extern void _ZN8S1608C16D1Ev();
Name_Map name_map_S1608C16[] = {
  NSPAIR(_ZN8S1608C16C1Ev),
  NSPAIR(_ZN8S1608C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1608C13;
extern VTBL_ENTRY _ZTI8S1608C13[];
extern  VTBL_ENTRY _ZTV8S1608C13[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
extern Class_Descriptor cd_S1608C6;
extern VTBL_ENTRY _ZTI7S1608C6[];
extern  VTBL_ENTRY _ZTV7S1608C6[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1608C13;
extern VTBL_ENTRY _ZTI8S1608C13[];
extern  VTBL_ENTRY _ZTV8S1608C13[];
extern Class_Descriptor cd_S1608C12;
extern VTBL_ENTRY _ZTI8S1608C12[];
extern  VTBL_ENTRY _ZTV8S1608C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C12[];
static Base_Class bases_S1608C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1587C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1608C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S886C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S1608C9_nt,    ABISELECT(32,16), //bcp->offset
    21, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S886C9_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S1587C7_nt,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S886C9_nt,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S1608C9_nt,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S1608C6,    ABISELECT(40,20), //bcp->offset
    26, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S1587C7_nt,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S1587C7_nt,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S1608C13,    ABISELECT(16,8), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S1608C12,    ABISELECT(16,8), //bcp->offset
    10, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S1608C16[];
extern void _ZN8S1608C132v2Ev();
extern void _ZN8S1608C162v4Ev();
extern void _ZN8S1608C16D1Ev();
extern void _ZN8S1608C16D0Ev();
extern void _ZN8S1608C132v2Ev();
extern void _ZN8S1608C122v3Ev();
extern void ABISELECT(_ZTv0_n56_N8S1608C16D1Ev,_ZTv0_n28_N8S1608C16D1Ev)();
extern void ABISELECT(_ZThn16_N8S1608C16D1Ev,_ZThn8_N8S1608C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S1608C16D0Ev,_ZTv0_n28_N8S1608C16D0Ev)();
extern void ABISELECT(_ZThn16_N8S1608C16D0Ev,_ZThn8_N8S1608C16D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C16D1Ev,_ZTv0_n12_N8S1608C16D1Ev)();
extern void ABISELECT(_ZThn32_N8S1608C16D1Ev,_ZThn16_N8S1608C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C16D0Ev,_ZTv0_n12_N8S1608C16D0Ev)();
extern void ABISELECT(_ZThn32_N8S1608C16D0Ev,_ZThn16_N8S1608C16D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C16D1Ev,_ZTv0_n12_N8S1608C16D1Ev)();
extern void ABISELECT(_ZThn40_N8S1608C16D1Ev,_ZThn20_N8S1608C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C16D0Ev,_ZTv0_n12_N8S1608C16D0Ev)();
extern void ABISELECT(_ZThn40_N8S1608C16D0Ev,_ZThn20_N8S1608C16D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S1608C16[] = {
  ABISELECT(40,20),
  ABISELECT(32,16),
  ABISELECT(16,8),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S1608C16[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
  (VTBL_ENTRY)&_ZN8S1608C162v4Ev,
  (VTBL_ENTRY)&_ZN8S1608C16D1Ev,
  (VTBL_ENTRY)&_ZN8S1608C16D0Ev,
  ABISELECT(-16,-8),
  0,
  0,
  ABISELECT(24,12),
  ABISELECT(16,8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S1608C16[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
  (VTBL_ENTRY)&_ZN8S1608C122v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S1608C16D1Ev,_ZTv0_n28_N8S1608C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S1608C16D0Ev,_ZTv0_n28_N8S1608C16D0Ev),
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S1608C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C16D1Ev,_ZTv0_n12_N8S1608C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C16D0Ev,_ZTv0_n12_N8S1608C16D0Ev),
  ABISELECT(-40,-20),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI8S1608C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C16D1Ev,_ZTv0_n12_N8S1608C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C16D0Ev,_ZTv0_n12_N8S1608C16D0Ev),
};
extern VTBL_ENTRY _ZTV8S1608C16[];
extern void _ZN8S1608C132v2Ev();
extern void _ZN8S1608C122v3Ev();
extern void _ZN8S1608C12D1Ev();
extern void _ZN8S1608C12D0Ev();
static  VTBL_ENTRY _tg__ZTV8S1608C12__8S1608C16[] = {
  ABISELECT(24,12),
  ABISELECT(16,8),
  0,
  (VTBL_ENTRY)&(_ZTI8S1608C12[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
  (VTBL_ENTRY)&_ZN8S1608C122v3Ev,
  (VTBL_ENTRY)&_ZN8S1608C12D1Ev,
  (VTBL_ENTRY)&_ZN8S1608C12D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev)();
extern void ABISELECT(_ZThn16_N8S1608C12D1Ev,_ZThn8_N8S1608C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev)();
extern void ABISELECT(_ZThn16_N8S1608C12D0Ev,_ZThn8_N8S1608C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV10S1608C9_nt__8S1608C12__8S1608C16[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S1608C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev)();
extern void ABISELECT(_ZThn24_N8S1608C12D1Ev,_ZThn12_N8S1608C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev)();
extern void ABISELECT(_ZThn24_N8S1608C12D0Ev,_ZThn12_N8S1608C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S1608C6__8S1608C12__8S1608C16[] = {
  ABISELECT(-24,-12),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S1608C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev),
};
static  VTT_ENTRY vtt_S1608C16[] = {
  {&(_ZTV8S1608C16[6]),  6,31},
  {&(_ZTV8S1608C16[17]),  17,31},
  {&(_ZTV8S1608C16[24]),  24,31},
  {&(_ZTV8S1608C16[29]),  29,31},
  {&(_tg__ZTV8S1608C12__8S1608C16[4]),  4,8},
  {&(_tg__ZTV10S1608C9_nt__8S1608C12__8S1608C16[3]),  3,5},
  {&(_tg__ZTV7S1608C6__8S1608C12__8S1608C16[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S1608C16[];
extern  VTBL_ENTRY _ZTV8S1608C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C16[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S1608C12D0Ev,_ZThn12_N8S1608C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S1608C12D0Ev,_ZThn8_N8S1608C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S1608C12D1Ev,_ZThn12_N8S1608C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S1608C12D1Ev,_ZThn8_N8S1608C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C16D0Ev,_ZTv0_n12_N8S1608C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N8S1608C16D0Ev,_ZThn20_N8S1608C16D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S1608C16D0Ev,_ZThn16_N8S1608C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C16D1Ev,_ZTv0_n12_N8S1608C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N8S1608C16D1Ev,_ZThn20_N8S1608C16D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S1608C16D1Ev,_ZThn16_N8S1608C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S1608C16D0Ev,_ZTv0_n28_N8S1608C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S1608C16D0Ev,_ZThn8_N8S1608C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S1608C16D1Ev,_ZTv0_n28_N8S1608C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S1608C16D1Ev,_ZThn8_N8S1608C16D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S1608C16 = {  "S1608C16", // class name
  bases_S1608C16, 13,
  &(vtc_S1608C16[0]), // expected_vtbl_contents
  &(vtt_S1608C16[0]), // expected_vtt_contents
  ABISELECT(56,28), // object size
  NSPAIRA(_ZTI8S1608C16),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S1608C16),31, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S1608C16),7, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1608C15  : S1608C16 , virtual S1608C11 , S1608C9_nt {
  ~S1608C15(); // tgen
  S1608C15(); // tgen
};
//SIG(-1 S1608C15) C1{ BC2{ BC3{ BC4{ m} v1} VBC5{ m} VBC6{ VBC7{ vd m} BC5 VBC8{ BC4 BC5 BC7 vd Fi} BC4 BC3 v2} v3 Fi} VBC9{ VBC7 VBC5 BC4 Fi} BC7}


S1608C15 ::~S1608C15(){ note_dtor("S1608C15", this);} // tgen
S1608C15 ::S1608C15(){ note_ctor("S1608C15", this);} // tgen

static void Test_S1608C15()
{
  extern Class_Descriptor cd_S1608C15;
  void *lvp;
  {
    ABISELECT(double,int) buf[10];
    init_test(&cd_S1608C15, buf);
    S1608C15 *dp, &lv = *(dp=new (buf) S1608C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,36), "sizeof(S1608C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1608C15)");
    /*is_ambiguous_... S1608C16::S1608C13 */ AMB_check_base_class_offset(lv, (S1587C7_nt*)(S1608C13*)(S1608C16*), 0, "S1608C15");
    /*is_ambiguous_... S1608C16::S1608C13 */ AMB_check_base_class_offset(lv, (S1608C13*)(S1608C16*), 0, "S1608C15");
    /*is_ambiguous_... S1608C16::S886C9_nt */ AMB_check_base_class_offset(lv, (S886C9_nt*)(S1608C16*), 0, "S1608C15");
    check_base_class_offset(lv, (S886C9_nt*)(S1608C11*), 0, "S1608C15");
    /*is_ambiguous_... S1608C12::S1608C9_nt */ AMB_check_base_class_offset(lv, (S1608C9_nt*)(S1608C12*), ABISELECT(56,28), "S1608C15");
    check_base_class_offset(lv, (S1608C9_nt*)(S1608C11*), ABISELECT(56,28), "S1608C15");
    /*is_ambiguous_... S1608C12::S886C9_nt */ AMB_check_base_class_offset(lv, (S886C9_nt*)(S1608C12*), ABISELECT(24,12), "S1608C15");
    check_base_class_offset(lv, (S1587C7_nt*)(S1608C6*), ABISELECT(40,20), "S1608C15");
    check_base_class_offset(lv, (S886C9_nt*)(S1608C6*), ABISELECT(40,20), "S1608C15");
    check_base_class_offset(lv, (S1608C9_nt*)(S1608C6*), ABISELECT(40,20), "S1608C15");
    check_base_class_offset(lv, (S1608C6*)(S1608C12*), ABISELECT(40,20), "S1608C15");
    /*is_ambiguous_... S1608C12::S1587C7_nt */ AMB_check_base_class_offset(lv, (S1587C7_nt*)(S1608C12*), ABISELECT(32,16), "S1608C15");
    check_base_class_offset(lv, (S1587C7_nt*)(S1608C13*)(S1608C12*), ABISELECT(24,12), "S1608C15");
    check_base_class_offset(lv, (S1608C13*)(S1608C12*), ABISELECT(24,12), "S1608C15");
    check_base_class_offset(lv, (S1608C12*)(S1608C16*), ABISELECT(24,12), "S1608C15");
    check_base_class_offset(lv, (S1608C16*), 0, "S1608C15");
    check_base_class_offset(lv, (S1587C7_nt*)(S1608C11*), ABISELECT(56,28), "S1608C15");
    check_base_class_offset(lv, (S1608C11*), ABISELECT(56,28), "S1608C15");
    /*is_ambiguous_... S1608C15::S1608C9_nt */ AMB_check_base_class_offset(lv, (S1608C9_nt*), ABISELECT(16,8), "S1608C15");
    test_class_info(&lv, &cd_S1608C15);
    dp->~S1608C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1608C15(Test_S1608C15, "S1608C15", ABISELECT(72,36));

#else // __cplusplus

extern void _ZN8S1608C15C1Ev();
extern void _ZN8S1608C15D1Ev();
Name_Map name_map_S1608C15[] = {
  NSPAIR(_ZN8S1608C15C1Ev),
  NSPAIR(_ZN8S1608C15D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1608C13;
extern VTBL_ENTRY _ZTI8S1608C13[];
extern  VTBL_ENTRY _ZTV8S1608C13[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
extern Class_Descriptor cd_S1608C6;
extern VTBL_ENTRY _ZTI7S1608C6[];
extern  VTBL_ENTRY _ZTV7S1608C6[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1608C13;
extern VTBL_ENTRY _ZTI8S1608C13[];
extern  VTBL_ENTRY _ZTV8S1608C13[];
extern Class_Descriptor cd_S1608C12;
extern VTBL_ENTRY _ZTI8S1608C12[];
extern  VTBL_ENTRY _ZTV8S1608C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C12[];
extern Class_Descriptor cd_S1608C16;
extern VTBL_ENTRY _ZTI8S1608C16[];
extern  VTBL_ENTRY _ZTV8S1608C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C16[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1608C11;
extern VTBL_ENTRY _ZTI8S1608C11[];
extern  VTBL_ENTRY _ZTV8S1608C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C11[];
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
static Base_Class bases_S1608C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1587C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1608C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S886C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S1608C9_nt,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S886C9_nt,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S1587C7_nt,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S886C9_nt,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S1608C9_nt,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S1608C6,    ABISELECT(40,20), //bcp->offset
    26, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S1587C7_nt,    ABISELECT(32,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S1587C7_nt,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S1608C13,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S1608C12,    ABISELECT(24,12), //bcp->offset
    15, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S1608C16,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1587C7_nt,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S1608C11,    ABISELECT(56,28), //bcp->offset
    31, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S1608C9_nt,    ABISELECT(16,8), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S1608C15[];
extern void _ZN8S1608C132v2Ev();
extern void _ZN8S1608C162v4Ev();
extern void _ZN8S1608C15D1Ev();
extern void _ZN8S1608C15D0Ev();
extern void ABISELECT(_ZThn16_N8S1608C15D1Ev,_ZThn8_N8S1608C15D1Ev)();
extern void ABISELECT(_ZThn16_N8S1608C15D0Ev,_ZThn8_N8S1608C15D0Ev)();
extern void _ZN8S1608C132v2Ev();
extern void _ZN8S1608C122v3Ev();
extern void ABISELECT(_ZTv0_n56_N8S1608C15D1Ev,_ZTv0_n28_N8S1608C15D1Ev)();
extern void ABISELECT(_ZThn24_N8S1608C15D1Ev,_ZThn12_N8S1608C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S1608C15D0Ev,_ZTv0_n28_N8S1608C15D0Ev)();
extern void ABISELECT(_ZThn24_N8S1608C15D0Ev,_ZThn12_N8S1608C15D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C15D1Ev,_ZTv0_n12_N8S1608C15D1Ev)();
extern void ABISELECT(_ZThn40_N8S1608C15D1Ev,_ZThn20_N8S1608C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C15D0Ev,_ZTv0_n12_N8S1608C15D0Ev)();
extern void ABISELECT(_ZThn40_N8S1608C15D0Ev,_ZThn20_N8S1608C15D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C15D1Ev,_ZTv0_n12_N8S1608C15D1Ev)();
extern void ABISELECT(_ZThn56_N8S1608C15D1Ev,_ZThn28_N8S1608C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C15D0Ev,_ZTv0_n12_N8S1608C15D0Ev)();
extern void ABISELECT(_ZThn56_N8S1608C15D0Ev,_ZThn28_N8S1608C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S1608C15[] = {
  ABISELECT(56,28),
  ABISELECT(40,20),
  ABISELECT(56,28),
  ABISELECT(24,12),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S1608C15[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
  (VTBL_ENTRY)&_ZN8S1608C162v4Ev,
  (VTBL_ENTRY)&_ZN8S1608C15D1Ev,
  (VTBL_ENTRY)&_ZN8S1608C15D0Ev,
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S1608C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S1608C15D1Ev,_ZThn8_N8S1608C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn16_N8S1608C15D0Ev,_ZThn8_N8S1608C15D0Ev),
  ABISELECT(-24,-12),
  0,
  0,
  ABISELECT(16,8),
  ABISELECT(32,16),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S1608C15[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
  (VTBL_ENTRY)&_ZN8S1608C122v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S1608C15D1Ev,_ZTv0_n28_N8S1608C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S1608C15D0Ev,_ZTv0_n28_N8S1608C15D0Ev),
  ABISELECT(-40,-20),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI8S1608C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C15D1Ev,_ZTv0_n12_N8S1608C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C15D0Ev,_ZTv0_n12_N8S1608C15D0Ev),
  ABISELECT(-56,-28),
  0,
  ABISELECT(-56,-28),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI8S1608C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C15D1Ev,_ZTv0_n12_N8S1608C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C15D0Ev,_ZTv0_n12_N8S1608C15D0Ev),
};
extern VTBL_ENTRY _ZTV8S1608C15[];
extern void _ZN8S1608C132v2Ev();
extern void _ZN8S1608C162v4Ev();
extern void _ZN8S1608C16D1Ev();
extern void _ZN8S1608C16D0Ev();
static  VTBL_ENTRY _tg__ZTV8S1608C16__8S1608C15[] = {
  ABISELECT(40,20),
  ABISELECT(56,28),
  ABISELECT(24,12),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S1608C16[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
  (VTBL_ENTRY)&_ZN8S1608C162v4Ev,
  (VTBL_ENTRY)&_ZN8S1608C16D1Ev,
  (VTBL_ENTRY)&_ZN8S1608C16D0Ev,
};
extern void _ZN8S1608C132v2Ev();
extern void _ZN8S1608C122v3Ev();
extern void ABISELECT(_ZTv0_n56_N8S1608C16D1Ev,_ZTv0_n28_N8S1608C16D1Ev)();
extern void ABISELECT(_ZThn24_N8S1608C16D1Ev,_ZThn12_N8S1608C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S1608C16D0Ev,_ZTv0_n28_N8S1608C16D0Ev)();
extern void ABISELECT(_ZThn24_N8S1608C16D0Ev,_ZThn12_N8S1608C16D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S1608C12__8S1608C16__8S1608C15[] = {
  ABISELECT(-24,-12),
  0,
  0,
  ABISELECT(16,8),
  ABISELECT(32,16),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S1608C16[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
  (VTBL_ENTRY)&_ZN8S1608C122v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S1608C16D1Ev,_ZTv0_n28_N8S1608C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S1608C16D0Ev,_ZTv0_n28_N8S1608C16D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S1608C16D1Ev,_ZTv0_n12_N8S1608C16D1Ev)();
extern void ABISELECT(_ZThn56_N8S1608C16D1Ev,_ZThn28_N8S1608C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C16D0Ev,_ZTv0_n12_N8S1608C16D0Ev)();
extern void ABISELECT(_ZThn56_N8S1608C16D0Ev,_ZThn28_N8S1608C16D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV10S1608C9_nt__8S1608C16__8S1608C15[] = {
  ABISELECT(-56,-28),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI8S1608C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C16D1Ev,_ZTv0_n12_N8S1608C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C16D0Ev,_ZTv0_n12_N8S1608C16D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S1608C16D1Ev,_ZTv0_n12_N8S1608C16D1Ev)();
extern void ABISELECT(_ZThn40_N8S1608C16D1Ev,_ZThn20_N8S1608C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C16D0Ev,_ZTv0_n12_N8S1608C16D0Ev)();
extern void ABISELECT(_ZThn40_N8S1608C16D0Ev,_ZThn20_N8S1608C16D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S1608C6__8S1608C16__8S1608C15[] = {
  ABISELECT(-40,-20),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI8S1608C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C16D1Ev,_ZTv0_n12_N8S1608C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C16D0Ev,_ZTv0_n12_N8S1608C16D0Ev),
};
extern void _ZN8S1608C132v2Ev();
extern void _ZN8S1608C122v3Ev();
extern void _ZN8S1608C12D1Ev();
extern void _ZN8S1608C12D0Ev();
static  VTBL_ENTRY _tg__ZTV8S1608C12__8S1608C15[] = {
  ABISELECT(16,8),
  ABISELECT(32,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S1608C12[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
  (VTBL_ENTRY)&_ZN8S1608C122v3Ev,
  (VTBL_ENTRY)&_ZN8S1608C12D1Ev,
  (VTBL_ENTRY)&_ZN8S1608C12D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev)();
extern void ABISELECT(_ZThn32_N8S1608C12D1Ev,_ZThn16_N8S1608C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev)();
extern void ABISELECT(_ZThn32_N8S1608C12D0Ev,_ZThn16_N8S1608C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV10S1608C9_nt__8S1608C12__8S1608C15[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S1608C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev)();
extern void ABISELECT(_ZThn16_N8S1608C12D1Ev,_ZThn8_N8S1608C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev)();
extern void ABISELECT(_ZThn16_N8S1608C12D0Ev,_ZThn8_N8S1608C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S1608C6__8S1608C12__8S1608C15[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S1608C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S1608C11D1Ev,_ZTv0_n12_N8S1608C11D1Ev)();
extern void _ZN8S1608C11D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C11D0Ev,_ZTv0_n12_N8S1608C11D0Ev)();
extern void _ZN8S1608C11D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S1608C11__8S1608C15[] = {
  ABISELECT(-56,-28),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S1608C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C11D1Ev,_ZTv0_n12_N8S1608C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C11D0Ev,_ZTv0_n12_N8S1608C11D0Ev),
};
static  VTT_ENTRY vtt_S1608C15[] = {
  {&(_ZTV8S1608C15[7]),  7,38},
  {&(_tg__ZTV8S1608C16__8S1608C15[6]),  6,10},
  {&(_tg__ZTV8S1608C12__8S1608C16__8S1608C15[7]),  7,11},
  {&(_tg__ZTV10S1608C9_nt__8S1608C16__8S1608C15[3]),  3,5},
  {&(_tg__ZTV7S1608C6__8S1608C16__8S1608C15[3]),  3,5},
  {&(_ZTV8S1608C15[22]),  22,38},
  {&(_ZTV8S1608C15[36]),  36,38},
  {&(_ZTV8S1608C15[29]),  29,38},
  {&(_ZTV8S1608C15[36]),  36,38},
  {&(_tg__ZTV8S1608C12__8S1608C15[4]),  4,8},
  {&(_tg__ZTV10S1608C9_nt__8S1608C12__8S1608C15[3]),  3,5},
  {&(_tg__ZTV7S1608C6__8S1608C12__8S1608C15[3]),  3,5},
  {&(_tg__ZTV8S1608C11__8S1608C15[5]),  5,7},
  {&(_tg__ZTV8S1608C11__8S1608C15[5]),  5,7},
};
extern VTBL_ENTRY _ZTI8S1608C15[];
extern  VTBL_ENTRY _ZTV8S1608C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C15[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C11D0Ev,_ZTv0_n12_N8S1608C11D0Ev), // 
  (VTBL_ENTRY)_ZN8S1608C11D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C11D1Ev,_ZTv0_n12_N8S1608C11D1Ev), // 
  (VTBL_ENTRY)_ZN8S1608C11D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S1608C12D0Ev,_ZThn8_N8S1608C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S1608C12D0Ev,_ZThn16_N8S1608C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S1608C12D1Ev,_ZThn8_N8S1608C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S1608C12D1Ev,_ZThn16_N8S1608C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C16D0Ev,_ZTv0_n12_N8S1608C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N8S1608C16D0Ev,_ZThn20_N8S1608C16D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S1608C16D0Ev,_ZThn28_N8S1608C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C16D1Ev,_ZTv0_n12_N8S1608C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N8S1608C16D1Ev,_ZThn20_N8S1608C16D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S1608C16D1Ev,_ZThn28_N8S1608C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S1608C16D0Ev,_ZTv0_n28_N8S1608C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S1608C16D0Ev,_ZThn12_N8S1608C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S1608C16D1Ev,_ZTv0_n28_N8S1608C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S1608C16D1Ev,_ZThn12_N8S1608C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C15D0Ev,_ZTv0_n12_N8S1608C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S1608C15D0Ev,_ZThn28_N8S1608C15D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N8S1608C15D0Ev,_ZThn20_N8S1608C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C15D1Ev,_ZTv0_n12_N8S1608C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S1608C15D1Ev,_ZThn28_N8S1608C15D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N8S1608C15D1Ev,_ZThn20_N8S1608C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S1608C15D0Ev,_ZTv0_n28_N8S1608C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S1608C15D0Ev,_ZThn12_N8S1608C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S1608C15D1Ev,_ZTv0_n28_N8S1608C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S1608C15D1Ev,_ZThn12_N8S1608C15D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S1608C15 = {  "S1608C15", // class name
  bases_S1608C15, 17,
  &(vtc_S1608C15[0]), // expected_vtbl_contents
  &(vtt_S1608C15[0]), // expected_vtt_contents
  ABISELECT(72,36), // object size
  NSPAIRA(_ZTI8S1608C15),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S1608C15),38, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S1608C15),14, //virtual table table var
  9, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1608C18  : virtual S1587C7_nt , virtual S886C9_nt , S1608C9_nt , virtual S1608C13 {
  virtual  ~S1608C18(); // _ZN8S1608C18D2Ev
  S1608C18(); // tgen
};
//SIG(-1 S1608C18) C1{ VBC2{ m} VBC3{ m} BC4{ vd m} VBC5{ BC2 v1} vd}


 S1608C18 ::~S1608C18(){ note_dtor("S1608C18", this);}
S1608C18 ::S1608C18(){ note_ctor("S1608C18", this);} // tgen

static void Test_S1608C18()
{
  extern Class_Descriptor cd_S1608C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[3];
    init_test(&cd_S1608C18, buf);
    S1608C18 *dp, &lv = *(dp=new (buf) S1608C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,8), "sizeof(S1608C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1608C18)");
    /*is_ambiguous_... S1608C18::S1587C7_nt */ AMB_check_base_class_offset(lv, (S1587C7_nt*), 0, "S1608C18");
    check_base_class_offset(lv, (S886C9_nt*), 0, "S1608C18");
    check_base_class_offset(lv, (S1608C9_nt*), 0, "S1608C18");
    check_base_class_offset(lv, (S1587C7_nt*)(S1608C13*), ABISELECT(8,4), "S1608C18");
    check_base_class_offset(lv, (S1608C13*), ABISELECT(8,4), "S1608C18");
    test_class_info(&lv, &cd_S1608C18);
    dp->~S1608C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1608C18(Test_S1608C18, "S1608C18", ABISELECT(16,8));

#else // __cplusplus

extern void _ZN8S1608C18C1Ev();
extern void _ZN8S1608C18D2Ev();
Name_Map name_map_S1608C18[] = {
  NSPAIR(_ZN8S1608C18C1Ev),
  NSPAIR(_ZN8S1608C18D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1608C13;
extern VTBL_ENTRY _ZTI8S1608C13[];
extern  VTBL_ENTRY _ZTV8S1608C13[];
static Base_Class bases_S1608C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1587C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S886C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S1608C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1587C7_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S1608C13,    ABISELECT(8,4), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S1608C18[];
extern void _ZN8S1608C18D1Ev();
extern void _ZN8S1608C18D0Ev();
extern void _ZN8S1608C132v2Ev();
static  VTBL_ENTRY vtc_S1608C18[] = {
  ABISELECT(8,4),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S1608C18[0]),
  (VTBL_ENTRY)&_ZN8S1608C18D1Ev,
  (VTBL_ENTRY)&_ZN8S1608C18D0Ev,
  0,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S1608C18[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
};
extern VTBL_ENTRY _ZTV8S1608C18[];
static  VTT_ENTRY vtt_S1608C18[] = {
  {&(_ZTV8S1608C18[5]),  5,11},
  {&(_ZTV8S1608C18[10]),  10,11},
};
extern VTBL_ENTRY _ZTI8S1608C18[];
extern  VTBL_ENTRY _ZTV8S1608C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C18[];
Class_Descriptor cd_S1608C18 = {  "S1608C18", // class name
  bases_S1608C18, 5,
  &(vtc_S1608C18[0]), // expected_vtbl_contents
  &(vtt_S1608C18[0]), // expected_vtt_contents
  ABISELECT(16,8), // object size
  NSPAIRA(_ZTI8S1608C18),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S1608C18),11, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S1608C18),2, //virtual table table var
  2, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1608C17  : S1608C18 , S1608C3 , S1608C4 {
  ~S1608C17(); // tgen
  S1608C17(); // tgen
};
//SIG(-1 S1608C17) C1{ BC2{ VBC3{ m} VBC4{ m} BC5{ vd m} VBC6{ BC3 v1} vd} BC7{ BC8{ VBC9{ BC10{ BC3 BC4 BC5 vd Fi} vd Fi Fp} vd Fs} VBC11{ BC12{ VBC5 VBC4 BC3 Fi} Fp} VBC13{ VBC5 BC4 VBC10 BC3 BC6 v2} vd} BC8}


S1608C17 ::~S1608C17(){ note_dtor("S1608C17", this);} // tgen
S1608C17 ::S1608C17(){ note_ctor("S1608C17", this);} // tgen

static void Test_S1608C17()
{
  extern Class_Descriptor cd_S1608C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(17,18)];
    init_test(&cd_S1608C17, buf);
    S1608C17 *dp, &lv = *(dp=new (buf) S1608C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,68), "sizeof(S1608C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1608C17)");
    /*is_ambiguous_... S1608C18::S1587C7_nt */ AMB_check_base_class_offset(lv, (S1587C7_nt*)(S1608C18*), 0, "S1608C17");
    check_base_class_offset(lv, (S886C9_nt*)(S1608C18*), 0, "S1608C17");
    check_base_class_offset(lv, (S886C9_nt*)(S1608C11*)(S1608C10*), 0, "S1608C17");
    check_base_class_offset(lv, (S1608C9_nt*)(S1608C18*), 0, "S1608C17");
    /*is_ambiguous_... S1608C17::S1608C13 */ AMB_check_base_class_offset(lv, (S1587C7_nt*)(S1608C13*), ABISELECT(40,20), "S1608C17");
    check_base_class_offset(lv, (S1608C13*)(S1608C18*), ABISELECT(40,20), "S1608C17");
    check_base_class_offset(lv, (S1608C18*), 0, "S1608C17");
    check_base_class_offset(lv, (S1587C7_nt*)(S1608C6*)(S1608C5*), ABISELECT(48,24), "S1608C17");
    check_base_class_offset(lv, (S886C9_nt*)(S1608C6*)(S1608C5*), ABISELECT(48,24), "S1608C17");
    check_base_class_offset(lv, (S1608C9_nt*)(S1608C6*)(S1608C5*), ABISELECT(48,24), "S1608C17");
    check_base_class_offset(lv, (S1608C6*)(S1608C5*), ABISELECT(48,24), "S1608C17");
    check_base_class_offset(lv, (S1608C5*)(S1608C4*)(S1608C3*), ABISELECT(48,24), "S1608C17");
    /*is_ambiguous_... S1608C17::S1608C4 */ AMB_check_base_class_offset(lv, (S1608C5*)(S1608C4*), ABISELECT(48,24), "S1608C17");
    check_base_class_offset(lv, (S1608C4*)(S1608C3*), ABISELECT(8,4), "S1608C17");
    check_base_class_offset(lv, (S1608C9_nt*)(S1608C11*)(S1608C10*), ABISELECT(72,40), "S1608C17");
    /*is_ambiguous_... S1608C12::S1608C9_nt */ AMB_check_base_class_offset(lv, (S1608C9_nt*)(S1608C12*), ABISELECT(72,40), "S1608C17");
    check_base_class_offset(lv, (S1587C7_nt*)(S1608C11*)(S1608C10*), ABISELECT(72,40), "S1608C17");
    check_base_class_offset(lv, (S1608C11*)(S1608C10*), ABISELECT(72,40), "S1608C17");
    check_base_class_offset(lv, (S1608C10*)(S1608C3*), ABISELECT(72,40), "S1608C17");
    /*is_ambiguous_... S1608C12::S886C9_nt */ AMB_check_base_class_offset(lv, (S886C9_nt*)(S1608C12*), ABISELECT(96,52), "S1608C17");
    /*is_ambiguous_... S1608C17::S1608C6 */ AMB_check_base_class_offset(lv, (S1587C7_nt*)(S1608C6*), ABISELECT(112,60), "S1608C17");
    /*is_ambiguous_... S1608C17::S1608C6 */ AMB_check_base_class_offset(lv, (S886C9_nt*)(S1608C6*), ABISELECT(112,60), "S1608C17");
    /*is_ambiguous_... S1608C17::S1608C6 */ AMB_check_base_class_offset(lv, (S1608C9_nt*)(S1608C6*), ABISELECT(112,60), "S1608C17");
    check_base_class_offset(lv, (S1608C6*)(S1608C12*), ABISELECT(112,60), "S1608C17");
    /*is_ambiguous_... S1608C12::S1587C7_nt */ AMB_check_base_class_offset(lv, (S1587C7_nt*)(S1608C12*), ABISELECT(104,56), "S1608C17");
    check_base_class_offset(lv, (S1587C7_nt*)(S1608C13*)(S1608C12*), ABISELECT(96,52), "S1608C17");
    check_base_class_offset(lv, (S1608C13*)(S1608C12*), ABISELECT(96,52), "S1608C17");
    check_base_class_offset(lv, (S1608C12*)(S1608C3*), ABISELECT(96,52), "S1608C17");
    check_base_class_offset(lv, (S1608C3*), ABISELECT(8,4), "S1608C17");
    /*is_ambiguous_... S1608C17::S1608C4 */ AMB_check_base_class_offset(lv, (S1608C4*), ABISELECT(24,12), "S1608C17");
    test_class_info(&lv, &cd_S1608C17);
    dp->~S1608C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1608C17(Test_S1608C17, "S1608C17", ABISELECT(128,68));

#else // __cplusplus

extern void _ZN8S1608C17C1Ev();
extern void _ZN8S1608C17D1Ev();
Name_Map name_map_S1608C17[] = {
  NSPAIR(_ZN8S1608C17C1Ev),
  NSPAIR(_ZN8S1608C17D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1608C13;
extern VTBL_ENTRY _ZTI8S1608C13[];
extern  VTBL_ENTRY _ZTV8S1608C13[];
extern Class_Descriptor cd_S1608C18;
extern VTBL_ENTRY _ZTI8S1608C18[];
extern  VTBL_ENTRY _ZTV8S1608C18[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C18[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
extern Class_Descriptor cd_S1608C6;
extern VTBL_ENTRY _ZTI7S1608C6[];
extern  VTBL_ENTRY _ZTV7S1608C6[];
extern Class_Descriptor cd_S1608C5;
extern VTBL_ENTRY _ZTI7S1608C5[];
extern  VTBL_ENTRY _ZTV7S1608C5[];
extern Class_Descriptor cd_S1608C4;
extern VTBL_ENTRY _ZTI7S1608C4[];
extern  VTBL_ENTRY _ZTV7S1608C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S1608C4[];
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1608C11;
extern VTBL_ENTRY _ZTI8S1608C11[];
extern  VTBL_ENTRY _ZTV8S1608C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C11[];
extern Class_Descriptor cd_S1608C10;
extern VTBL_ENTRY _ZTI8S1608C10[];
extern  VTBL_ENTRY _ZTV8S1608C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C10[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
extern Class_Descriptor cd_S1608C6;
extern VTBL_ENTRY _ZTI7S1608C6[];
extern  VTBL_ENTRY _ZTV7S1608C6[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1608C13;
extern VTBL_ENTRY _ZTI8S1608C13[];
extern  VTBL_ENTRY _ZTV8S1608C13[];
extern Class_Descriptor cd_S1608C12;
extern VTBL_ENTRY _ZTI8S1608C12[];
extern  VTBL_ENTRY _ZTV8S1608C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C12[];
extern Class_Descriptor cd_S1608C3;
extern VTBL_ENTRY _ZTI7S1608C3[];
extern  VTBL_ENTRY _ZTV7S1608C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S1608C3[];
extern Class_Descriptor cd_S1608C4;
extern VTBL_ENTRY _ZTI7S1608C4[];
extern  VTBL_ENTRY _ZTV7S1608C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S1608C4[];
static Base_Class bases_S1608C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1587C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S886C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S1608C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S1587C7_nt,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S1608C13,    ABISELECT(40,20), //bcp->offset
    27, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S1608C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1587C7_nt,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S886C9_nt,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S1608C9_nt,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S1608C6,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S1608C5,    ABISELECT(48,24), //bcp->offset
    31, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S1608C4,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S1608C9_nt,    ABISELECT(72,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    14, //immediately_derived
  0, 1},
  {&cd_S1587C7_nt,    ABISELECT(72,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S1608C11,    ABISELECT(72,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S1608C10,    ABISELECT(72,40), //bcp->offset
    36, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    25, //immediately_derived
  0, 1},
  {&cd_S886C9_nt,    ABISELECT(96,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S1587C7_nt,    ABISELECT(112,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S886C9_nt,    ABISELECT(112,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S1608C9_nt,    ABISELECT(112,60), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S1608C6,    ABISELECT(112,60), //bcp->offset
    54, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    24, //immediately_derived
  0, 1},
  {&cd_S1587C7_nt,    ABISELECT(104,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S1587C7_nt,    ABISELECT(96,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S1608C13,    ABISELECT(96,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S1608C12,    ABISELECT(96,52), //bcp->offset
    43, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    25, //immediately_derived
  0, 1},
  {&cd_S1608C3,    ABISELECT(8,4), //bcp->offset
    12, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1608C4,    ABISELECT(24,12), //bcp->offset
    22, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S1608C17[];
extern void _ZN8S1608C17D1Ev();
extern void _ZN8S1608C17D0Ev();
extern void ABISELECT(_ZThn8_N8S1608C17D1Ev,_ZThn4_N8S1608C17D1Ev)();
extern void ABISELECT(_ZThn8_N8S1608C17D0Ev,_ZThn4_N8S1608C17D0Ev)();
extern void ABISELECT(_ZThn24_N8S1608C17D1Ev,_ZThn12_N8S1608C17D1Ev)();
extern void ABISELECT(_ZThn24_N8S1608C17D0Ev,_ZThn12_N8S1608C17D0Ev)();
extern void _ZN8S1608C132v2Ev();
extern void ABISELECT(_ZTv0_n24_N8S1608C17D1Ev,_ZTv0_n12_N8S1608C17D1Ev)();
extern void ABISELECT(_ZThn48_N8S1608C17D1Ev,_ZThn24_N8S1608C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C17D0Ev,_ZTv0_n12_N8S1608C17D0Ev)();
extern void ABISELECT(_ZThn48_N8S1608C17D0Ev,_ZThn24_N8S1608C17D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C17D1Ev,_ZTv0_n12_N8S1608C17D1Ev)();
extern void ABISELECT(_ZThn72_N8S1608C17D1Ev,_ZThn40_N8S1608C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C17D0Ev,_ZTv0_n12_N8S1608C17D0Ev)();
extern void ABISELECT(_ZThn72_N8S1608C17D0Ev,_ZThn40_N8S1608C17D0Ev)() __attribute__((weak));
extern void _ZN8S1608C132v2Ev();
extern void _ZN8S1608C122v3Ev();
extern void ABISELECT(_ZTv0_n56_N8S1608C17D1Ev,_ZTv0_n28_N8S1608C17D1Ev)();
extern void ABISELECT(_ZThn96_N8S1608C17D1Ev,_ZThn52_N8S1608C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S1608C17D0Ev,_ZTv0_n28_N8S1608C17D0Ev)();
extern void ABISELECT(_ZThn96_N8S1608C17D0Ev,_ZThn52_N8S1608C17D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C17D1Ev,_ZTv0_n12_N8S1608C17D1Ev)();
extern void ABISELECT(_ZThn112_N8S1608C17D1Ev,_ZThn60_N8S1608C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C17D0Ev,_ZTv0_n12_N8S1608C17D0Ev)();
extern void ABISELECT(_ZThn112_N8S1608C17D0Ev,_ZThn60_N8S1608C17D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S1608C17[] = {
  ABISELECT(112,60),
  ABISELECT(96,52),
  ABISELECT(72,40),
  ABISELECT(72,40),
  ABISELECT(48,24),
  ABISELECT(40,20),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S1608C17[0]),
  (VTBL_ENTRY)&_ZN8S1608C17D1Ev,
  (VTBL_ENTRY)&_ZN8S1608C17D0Ev,
  ABISELECT(104,56),
  ABISELECT(88,48),
  ABISELECT(-8,-4),
  ABISELECT(64,36),
  ABISELECT(64,36),
  ABISELECT(40,20),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S1608C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S1608C17D1Ev,_ZThn4_N8S1608C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S1608C17D0Ev,_ZThn4_N8S1608C17D0Ev),
  ABISELECT(24,12),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S1608C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N8S1608C17D1Ev,_ZThn12_N8S1608C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn24_N8S1608C17D0Ev,_ZThn12_N8S1608C17D0Ev),
  0,
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI8S1608C17[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
  ABISELECT(-48,-24),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S1608C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C17D1Ev,_ZTv0_n12_N8S1608C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C17D0Ev,_ZTv0_n12_N8S1608C17D0Ev),
  ABISELECT(-72,-40),
  0,
  ABISELECT(-72,-40),
  ABISELECT(-72,-40),
  (VTBL_ENTRY)&(_ZTI8S1608C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C17D1Ev,_ZTv0_n12_N8S1608C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C17D0Ev,_ZTv0_n12_N8S1608C17D0Ev),
  ABISELECT(-96,-52),
  0,
  0,
  ABISELECT(16,8),
  ABISELECT(-24,-12),
  ABISELECT(-96,-52),
  (VTBL_ENTRY)&(_ZTI8S1608C17[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
  (VTBL_ENTRY)&_ZN8S1608C122v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S1608C17D1Ev,_ZTv0_n28_N8S1608C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S1608C17D0Ev,_ZTv0_n28_N8S1608C17D0Ev),
  ABISELECT(-112,-60),
  ABISELECT(-112,-60),
  (VTBL_ENTRY)&(_ZTI8S1608C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C17D1Ev,_ZTv0_n12_N8S1608C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C17D0Ev,_ZTv0_n12_N8S1608C17D0Ev),
};
extern VTBL_ENTRY _ZTV8S1608C17[];
extern void _ZN8S1608C18D1Ev();
extern void _ZN8S1608C18D0Ev();
static  VTBL_ENTRY _tg__ZTV8S1608C18__8S1608C17[] = {
  ABISELECT(40,20),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S1608C18[0]),
  (VTBL_ENTRY)&_ZN8S1608C18D1Ev,
  (VTBL_ENTRY)&_ZN8S1608C18D0Ev,
};
extern void _ZN8S1608C132v2Ev();
static  VTBL_ENTRY _tg__ZTV8S1608C13__8S1608C18__8S1608C17[] = {
  0,
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI8S1608C18[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
};
extern void _ZN7S1608C3D1Ev();
extern void _ZN7S1608C3D0Ev();
static  VTBL_ENTRY _tg__ZTV7S1608C3__8S1608C17[] = {
  ABISELECT(104,56),
  ABISELECT(88,48),
  ABISELECT(-8,-4),
  ABISELECT(64,36),
  ABISELECT(64,36),
  ABISELECT(40,20),
  0,
  (VTBL_ENTRY)&(_ZTI7S1608C3[0]),
  (VTBL_ENTRY)&_ZN7S1608C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1608C3D0Ev,
};
extern void _ZN7S1608C4D1Ev();
extern void _ZN7S1608C4D0Ev();
static  VTBL_ENTRY _tg__ZTV7S1608C47S1608C3__8S1608C17[] = {
  ABISELECT(40,20),
  0,
  (VTBL_ENTRY)&(_ZTI7S1608C4[0]),
  (VTBL_ENTRY)&_ZN7S1608C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1608C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S1608C4D1Ev,_ZTv0_n12_N7S1608C4D1Ev)();
extern void ABISELECT(_ZThn40_N7S1608C4D1Ev,_ZThn20_N7S1608C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S1608C4D0Ev,_ZTv0_n12_N7S1608C4D0Ev)();
extern void ABISELECT(_ZThn40_N7S1608C4D0Ev,_ZThn20_N7S1608C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S1608C5__7S1608C47S1608C3__8S1608C17[] = {
  ABISELECT(-40,-20),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI7S1608C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S1608C4D1Ev,_ZTv0_n12_N7S1608C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S1608C4D0Ev,_ZTv0_n12_N7S1608C4D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N7S1608C3D1Ev,_ZTv0_n12_N7S1608C3D1Ev)();
extern void ABISELECT(_ZThn40_N7S1608C3D1Ev,_ZThn20_N7S1608C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S1608C3D0Ev,_ZTv0_n12_N7S1608C3D0Ev)();
extern void ABISELECT(_ZThn40_N7S1608C3D0Ev,_ZThn20_N7S1608C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S1608C5__7S1608C3__8S1608C17[] = {
  ABISELECT(-40,-20),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI7S1608C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S1608C3D1Ev,_ZTv0_n12_N7S1608C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S1608C3D0Ev,_ZTv0_n12_N7S1608C3D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N7S1608C3D1Ev,_ZTv0_n12_N7S1608C3D1Ev)();
extern void ABISELECT(_ZThn64_N7S1608C3D1Ev,_ZThn36_N7S1608C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S1608C3D0Ev,_ZTv0_n12_N7S1608C3D0Ev)();
extern void ABISELECT(_ZThn64_N7S1608C3D0Ev,_ZThn36_N7S1608C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S1608C10__7S1608C3__8S1608C17[] = {
  ABISELECT(-72,-40),
  0,
  ABISELECT(-64,-36),
  ABISELECT(-64,-36),
  (VTBL_ENTRY)&(_ZTI7S1608C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S1608C3D1Ev,_ZTv0_n12_N7S1608C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S1608C3D0Ev,_ZTv0_n12_N7S1608C3D0Ev),
};
extern void _ZN8S1608C132v2Ev();
extern void _ZN8S1608C122v3Ev();
extern void ABISELECT(_ZTv0_n56_N7S1608C3D1Ev,_ZTv0_n28_N7S1608C3D1Ev)();
extern void ABISELECT(_ZThn88_N7S1608C3D1Ev,_ZThn48_N7S1608C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S1608C3D0Ev,_ZTv0_n28_N7S1608C3D0Ev)();
extern void ABISELECT(_ZThn88_N7S1608C3D0Ev,_ZThn48_N7S1608C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S1608C12__7S1608C3__8S1608C17[] = {
  ABISELECT(-88,-48),
  0,
  0,
  ABISELECT(16,8),
  ABISELECT(-24,-12),
  ABISELECT(-88,-48),
  (VTBL_ENTRY)&(_ZTI7S1608C3[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
  (VTBL_ENTRY)&_ZN8S1608C122v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S1608C3D1Ev,_ZTv0_n28_N7S1608C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S1608C3D0Ev,_ZTv0_n28_N7S1608C3D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N7S1608C3D1Ev,_ZTv0_n12_N7S1608C3D1Ev)();
extern void ABISELECT(_ZThn104_N7S1608C3D1Ev,_ZThn56_N7S1608C3D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S1608C3D0Ev,_ZTv0_n12_N7S1608C3D0Ev)();
extern void ABISELECT(_ZThn104_N7S1608C3D0Ev,_ZThn56_N7S1608C3D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S1608C6__A1__7S1608C3__8S1608C17[] = {
  ABISELECT(-104,-56),
  ABISELECT(-104,-56),
  (VTBL_ENTRY)&(_ZTI7S1608C3[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S1608C3D1Ev,_ZTv0_n12_N7S1608C3D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S1608C3D0Ev,_ZTv0_n12_N7S1608C3D0Ev),
};
extern void _ZN7S1608C4D1Ev();
extern void _ZN7S1608C4D0Ev();
static  VTBL_ENTRY _tg__ZTV7S1608C4__A1__8S1608C17[] = {
  ABISELECT(24,12),
  0,
  (VTBL_ENTRY)&(_ZTI7S1608C4[0]),
  (VTBL_ENTRY)&_ZN7S1608C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1608C4D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N7S1608C4D1Ev,_ZTv0_n12_N7S1608C4D1Ev)();
extern void ABISELECT(_ZThn24_N7S1608C4D1Ev,_ZThn12_N7S1608C4D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N7S1608C4D0Ev,_ZTv0_n12_N7S1608C4D0Ev)();
extern void ABISELECT(_ZThn24_N7S1608C4D0Ev,_ZThn12_N7S1608C4D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S1608C5__7S1608C4__A1__8S1608C17[] = {
  ABISELECT(-24,-12),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI7S1608C4[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S1608C4D1Ev,_ZTv0_n12_N7S1608C4D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N7S1608C4D0Ev,_ZTv0_n12_N7S1608C4D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S1608C10D1Ev,_ZTv0_n12_N8S1608C10D1Ev)();
extern void _ZN8S1608C10D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C10D0Ev,_ZTv0_n12_N8S1608C10D0Ev)();
extern void _ZN8S1608C10D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S1608C10__8S1608C17[] = {
  ABISELECT(-72,-40),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S1608C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C10D1Ev,_ZTv0_n12_N8S1608C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C10D0Ev,_ZTv0_n12_N8S1608C10D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S1608C11D1Ev,_ZTv0_n12_N8S1608C11D1Ev)();
extern void _ZN8S1608C11D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C11D0Ev,_ZTv0_n12_N8S1608C11D0Ev)();
extern void _ZN8S1608C11D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S1608C118S1608C10__8S1608C17[] = {
  ABISELECT(-72,-40),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S1608C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C11D1Ev,_ZTv0_n12_N8S1608C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C11D0Ev,_ZTv0_n12_N8S1608C11D0Ev),
};
extern void _ZN8S1608C132v2Ev();
extern void _ZN8S1608C122v3Ev();
extern void _ZN8S1608C12D1Ev();
extern void _ZN8S1608C12D0Ev();
static  VTBL_ENTRY _tg__ZTV8S1608C12__8S1608C17[] = {
  ABISELECT(16,8),
  ABISELECT(-24,-12),
  0,
  (VTBL_ENTRY)&(_ZTI8S1608C12[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
  (VTBL_ENTRY)&_ZN8S1608C122v3Ev,
  (VTBL_ENTRY)&_ZN8S1608C12D1Ev,
  (VTBL_ENTRY)&_ZN8S1608C12D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev)();
extern void ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev)();
static  VTBL_ENTRY _tg__ZTV10S1608C9_nt__8S1608C12__8S1608C17[] = {
  ABISELECT(24,12),
  ABISELECT(24,12),
  (VTBL_ENTRY)&(_ZTI8S1608C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev)();
extern void ABISELECT(_ZThn16_N8S1608C12D1Ev,_ZThn8_N8S1608C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev)();
extern void ABISELECT(_ZThn16_N8S1608C12D0Ev,_ZThn8_N8S1608C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S1608C6__8S1608C12__8S1608C17[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S1608C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev),
};
static  VTT_ENTRY vtt_S1608C17[] = {
  {&(_ZTV8S1608C17[10]),  10,59},
  {&(_tg__ZTV8S1608C18__8S1608C17[5]),  5,7},
  {&(_tg__ZTV8S1608C13__8S1608C18__8S1608C17[3]),  3,4},
  {&(_tg__ZTV7S1608C3__8S1608C17[8]),  8,10},
  {&(_tg__ZTV7S1608C47S1608C3__8S1608C17[3]),  3,5},
  {&(_tg__ZTV7S1608C5__7S1608C47S1608C3__8S1608C17[3]),  3,5},
  {&(_tg__ZTV7S1608C5__7S1608C3__8S1608C17[3]),  3,5},
  {&(_tg__ZTV8S1608C10__7S1608C3__8S1608C17[5]),  5,7},
  {&(_tg__ZTV8S1608C10__7S1608C3__8S1608C17[5]),  5,7},
  {&(_tg__ZTV8S1608C12__7S1608C3__8S1608C17[7]),  7,11},
  {&(_tg__ZTV7S1608C6__A1__7S1608C3__8S1608C17[3]),  3,5},
  {&(_tg__ZTV7S1608C4__A1__8S1608C17[3]),  3,5},
  {&(_tg__ZTV7S1608C5__7S1608C4__A1__8S1608C17[3]),  3,5},
  {&(_ZTV8S1608C17[30]),  30,59},
  {&(_ZTV8S1608C17[20]),  20,59},
  {&(_ZTV8S1608C17[34]),  34,59},
  {&(_ZTV8S1608C17[41]),  41,59},
  {&(_ZTV8S1608C17[41]),  41,59},
  {&(_ZTV8S1608C17[50]),  50,59},
  {&(_ZTV8S1608C17[57]),  57,59},
  {&(_ZTV8S1608C17[25]),  25,59},
  {&(_tg__ZTV8S1608C10__8S1608C17[5]),  5,7},
  {&(_tg__ZTV8S1608C118S1608C10__8S1608C17[5]),  5,7},
  {&(_tg__ZTV8S1608C118S1608C10__8S1608C17[5]),  5,7},
  {&(_tg__ZTV8S1608C10__8S1608C17[5]),  5,7},
  {&(_tg__ZTV8S1608C12__8S1608C17[4]),  4,8},
  {&(_tg__ZTV10S1608C9_nt__8S1608C12__8S1608C17[3]),  3,5},
  {&(_tg__ZTV7S1608C6__8S1608C12__8S1608C17[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S1608C17[];
extern  VTBL_ENTRY _ZTV8S1608C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C17[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S1608C12D0Ev,_ZThn8_N8S1608C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S1608C12D1Ev,_ZThn8_N8S1608C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C11D0Ev,_ZTv0_n12_N8S1608C11D0Ev), // 
  (VTBL_ENTRY)_ZN8S1608C11D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C11D1Ev,_ZTv0_n12_N8S1608C11D1Ev), // 
  (VTBL_ENTRY)_ZN8S1608C11D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C10D0Ev,_ZTv0_n12_N8S1608C10D0Ev), // 
  (VTBL_ENTRY)_ZN8S1608C10D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C10D1Ev,_ZTv0_n12_N8S1608C10D1Ev), // 
  (VTBL_ENTRY)_ZN8S1608C10D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S1608C3D0Ev,_ZTv0_n28_N7S1608C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn88_N7S1608C3D0Ev,_ZThn48_N7S1608C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S1608C3D1Ev,_ZTv0_n28_N7S1608C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn88_N7S1608C3D1Ev,_ZThn48_N7S1608C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S1608C3D0Ev,_ZTv0_n12_N7S1608C3D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N7S1608C3D0Ev,_ZThn56_N7S1608C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn64_N7S1608C3D0Ev,_ZThn36_N7S1608C3D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N7S1608C3D0Ev,_ZThn20_N7S1608C3D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S1608C3D1Ev,_ZTv0_n12_N7S1608C3D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn104_N7S1608C3D1Ev,_ZThn56_N7S1608C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn64_N7S1608C3D1Ev,_ZThn36_N7S1608C3D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N7S1608C3D1Ev,_ZThn20_N7S1608C3D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S1608C4D0Ev,_ZTv0_n12_N7S1608C4D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7S1608C4D0Ev,_ZThn12_N7S1608C4D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N7S1608C4D0Ev,_ZThn20_N7S1608C4D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N7S1608C4D1Ev,_ZTv0_n12_N7S1608C4D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N7S1608C4D1Ev,_ZThn12_N7S1608C4D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn40_N7S1608C4D1Ev,_ZThn20_N7S1608C4D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S1608C17D0Ev,_ZTv0_n28_N8S1608C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N8S1608C17D0Ev,_ZThn52_N8S1608C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S1608C17D1Ev,_ZTv0_n28_N8S1608C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn96_N8S1608C17D1Ev,_ZThn52_N8S1608C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C17D0Ev,_ZTv0_n12_N8S1608C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N8S1608C17D0Ev,_ZThn60_N8S1608C17D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn72_N8S1608C17D0Ev,_ZThn40_N8S1608C17D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S1608C17D0Ev,_ZThn24_N8S1608C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C17D1Ev,_ZTv0_n12_N8S1608C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn112_N8S1608C17D1Ev,_ZThn60_N8S1608C17D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn72_N8S1608C17D1Ev,_ZThn40_N8S1608C17D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S1608C17D1Ev,_ZThn24_N8S1608C17D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S1608C17 = {  "S1608C17", // class name
  bases_S1608C17, 27,
  &(vtc_S1608C17[0]), // expected_vtbl_contents
  &(vtt_S1608C17[0]), // expected_vtt_contents
  ABISELECT(128,68), // object size
  NSPAIRA(_ZTI8S1608C17),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S1608C17),59, //virtual function table var
  10, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S1608C17),28, //virtual table table var
  16, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1608C20_nt  {
  long s1608c20f0;
  void  mf1608c20(); // _ZN11S1608C20_nt9mf1608c20Ev
};
//SIG(-1 S1608C20_nt) C1{ m Fl}


void  S1608C20_nt ::mf1608c20(){}

//skip512 S1608C20_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI11S1608C20_nt[];
VTBL_ENTRY *P__ZTI11S1608C20_nt = _ZTI11S1608C20_nt; 
Class_Descriptor cd_S1608C20_nt = {  "S1608C20_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S1608C20_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1608C19  : S1608C13 , S1608C6 , virtual S886C9_nt , virtual S1608C15 , virtual S1608C20_nt {
  virtual  ~S1608C19(); // _ZN8S1608C19D2Ev
  S1608C19(); // tgen
};
//SIG(-1 S1608C19) C1{ BC2{ BC3{ m} v1} BC4{ BC3 BC5{ m} BC6{ vd m} vd Fi} VBC5 VBC7{ BC8{ BC2 VBC5 VBC9{ VBC6 BC5 VBC4 BC3 BC2 v2} v3 Fi} VBC10{ VBC6 VBC5 BC3 Fi} BC6} VBC11{ m Fl} vd}


 S1608C19 ::~S1608C19(){ note_dtor("S1608C19", this);}
S1608C19 ::S1608C19(){ note_ctor("S1608C19", this);} // tgen

static void Test_S1608C19()
{
  extern Class_Descriptor cd_S1608C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[14];
    init_test(&cd_S1608C19, buf);
    S1608C19 *dp, &lv = *(dp=new (buf) S1608C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(104,52), "sizeof(S1608C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1608C19)");
    /*is_ambiguous_... S1608C19::S1608C13 */ AMB_check_base_class_offset(lv, (S1587C7_nt*)(S1608C13*), 0, "S1608C19");
    /*is_ambiguous_... S1608C19::S1608C13 */ AMB_check_base_class_offset(lv, (S1608C13*), 0, "S1608C19");
    /*is_ambiguous_... S1608C19::S1608C6 */ AMB_check_base_class_offset(lv, (S1587C7_nt*)(S1608C6*), ABISELECT(8,4), "S1608C19");
    /*is_ambiguous_... S1608C19::S1608C6 */ AMB_check_base_class_offset(lv, (S886C9_nt*)(S1608C6*), ABISELECT(8,4), "S1608C19");
    /*is_ambiguous_... S1608C19::S1608C6 */ AMB_check_base_class_offset(lv, (S1608C9_nt*)(S1608C6*), ABISELECT(8,4), "S1608C19");
    /*is_ambiguous_... S1608C19::S1608C6 */ AMB_check_base_class_offset(lv, (S1608C6*), ABISELECT(8,4), "S1608C19");
    /*is_ambiguous_... S1608C19::S886C9_nt */ AMB_check_base_class_offset(lv, (S886C9_nt*), 0, "S1608C19");
    /*is_ambiguous_... S1608C16::S886C9_nt */ AMB_check_base_class_offset(lv, (S886C9_nt*)(S1608C16*)(S1608C15*), 0, "S1608C19");
    check_base_class_offset(lv, (S886C9_nt*)(S1608C11*), 0, "S1608C19");
    /*is_ambiguous_... S1608C16::S1608C13 */ AMB_check_base_class_offset(lv, (S1587C7_nt*)(S1608C13*)(S1608C16*)(S1608C15*), ABISELECT(24,12), "S1608C19");
    /*is_ambiguous_... S1608C16::S1608C13 */ AMB_check_base_class_offset(lv, (S1608C13*)(S1608C16*)(S1608C15*), ABISELECT(24,12), "S1608C19");
    /*is_ambiguous_... S1608C12::S1608C9_nt */ AMB_check_base_class_offset(lv, (S1608C9_nt*)(S1608C12*), ABISELECT(80,40), "S1608C19");
    check_base_class_offset(lv, (S1608C9_nt*)(S1608C11*), ABISELECT(80,40), "S1608C19");
    /*is_ambiguous_... S1608C12::S886C9_nt */ AMB_check_base_class_offset(lv, (S886C9_nt*)(S1608C12*), ABISELECT(48,24), "S1608C19");
    /*is_ambiguous_... S1608C19::S1608C6 */ AMB_check_base_class_offset(lv, (S1587C7_nt*)(S1608C6*), ABISELECT(64,32), "S1608C19");
    /*is_ambiguous_... S1608C19::S1608C6 */ AMB_check_base_class_offset(lv, (S886C9_nt*)(S1608C6*), ABISELECT(64,32), "S1608C19");
    /*is_ambiguous_... S1608C19::S1608C6 */ AMB_check_base_class_offset(lv, (S1608C9_nt*)(S1608C6*), ABISELECT(64,32), "S1608C19");
    check_base_class_offset(lv, (S1608C6*)(S1608C12*), ABISELECT(64,32), "S1608C19");
    /*is_ambiguous_... S1608C12::S1587C7_nt */ AMB_check_base_class_offset(lv, (S1587C7_nt*)(S1608C12*), ABISELECT(56,28), "S1608C19");
    check_base_class_offset(lv, (S1587C7_nt*)(S1608C13*)(S1608C12*), ABISELECT(48,24), "S1608C19");
    check_base_class_offset(lv, (S1608C13*)(S1608C12*), ABISELECT(48,24), "S1608C19");
    check_base_class_offset(lv, (S1608C12*)(S1608C16*)(S1608C15*), ABISELECT(48,24), "S1608C19");
    check_base_class_offset(lv, (S1608C16*)(S1608C15*), ABISELECT(24,12), "S1608C19");
    check_base_class_offset(lv, (S1587C7_nt*)(S1608C11*), ABISELECT(80,40), "S1608C19");
    check_base_class_offset(lv, (S1608C11*)(S1608C15*), ABISELECT(80,40), "S1608C19");
    /*is_ambiguous_... S1608C15::S1608C9_nt */ AMB_check_base_class_offset(lv, (S1608C9_nt*)(S1608C15*), ABISELECT(40,20), "S1608C19");
    check_base_class_offset(lv, (S1608C15*), ABISELECT(24,12), "S1608C19");
    check_base_class_offset(lv, (S1608C20_nt*), ABISELECT(96,48), "S1608C19");
    test_class_info(&lv, &cd_S1608C19);
    dp->~S1608C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1608C19(Test_S1608C19, "S1608C19", ABISELECT(104,52));

#else // __cplusplus

extern void _ZN8S1608C19C1Ev();
extern void _ZN8S1608C19D2Ev();
Name_Map name_map_S1608C19[] = {
  NSPAIR(_ZN8S1608C19C1Ev),
  NSPAIR(_ZN8S1608C19D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1608C13;
extern VTBL_ENTRY _ZTI8S1608C13[];
extern  VTBL_ENTRY _ZTV8S1608C13[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
extern Class_Descriptor cd_S1608C6;
extern VTBL_ENTRY _ZTI7S1608C6[];
extern  VTBL_ENTRY _ZTV7S1608C6[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1608C13;
extern VTBL_ENTRY _ZTI8S1608C13[];
extern  VTBL_ENTRY _ZTV8S1608C13[];
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
extern Class_Descriptor cd_S1608C6;
extern VTBL_ENTRY _ZTI7S1608C6[];
extern  VTBL_ENTRY _ZTV7S1608C6[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1608C13;
extern VTBL_ENTRY _ZTI8S1608C13[];
extern  VTBL_ENTRY _ZTV8S1608C13[];
extern Class_Descriptor cd_S1608C12;
extern VTBL_ENTRY _ZTI8S1608C12[];
extern  VTBL_ENTRY _ZTV8S1608C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C12[];
extern Class_Descriptor cd_S1608C16;
extern VTBL_ENTRY _ZTI8S1608C16[];
extern  VTBL_ENTRY _ZTV8S1608C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C16[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1608C11;
extern VTBL_ENTRY _ZTI8S1608C11[];
extern  VTBL_ENTRY _ZTV8S1608C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C11[];
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
extern Class_Descriptor cd_S1608C15;
extern VTBL_ENTRY _ZTI8S1608C15[];
extern  VTBL_ENTRY _ZTV8S1608C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C15[];
extern Class_Descriptor cd_S1608C20_nt;
extern VTBL_ENTRY _ZTI11S1608C20_nt[];
static Base_Class bases_S1608C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1587C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1608C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1587C7_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S886C9_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S1608C9_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S1608C6,    ABISELECT(8,4), //bcp->offset
    12, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S886C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S1587C7_nt,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S1608C13,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S1608C9_nt,    ABISELECT(80,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S886C9_nt,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S1587C7_nt,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S886C9_nt,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S1608C9_nt,    ABISELECT(64,32), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S1608C6,    ABISELECT(64,32), //bcp->offset
    45, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S1587C7_nt,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S1587C7_nt,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S1608C13,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S1608C12,    ABISELECT(48,24), //bcp->offset
    34, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    19, //immediately_derived
  0, 1},
  {&cd_S1608C16,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S1587C7_nt,    ABISELECT(80,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S1608C11,    ABISELECT(80,40), //bcp->offset
    50, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    23, //immediately_derived
  0, 1},
  {&cd_S1608C9_nt,    ABISELECT(40,20), //bcp->offset
    30, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S1608C15,    ABISELECT(24,12), //bcp->offset
    16, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S1608C20_nt,    ABISELECT(96,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S1608C19[];
extern void _ZN8S1608C132v2Ev();
extern void _ZN8S1608C19D1Ev();
extern void _ZN8S1608C19D0Ev();
extern void ABISELECT(_ZThn8_N8S1608C19D1Ev,_ZThn4_N8S1608C19D1Ev)();
extern void ABISELECT(_ZThn8_N8S1608C19D0Ev,_ZThn4_N8S1608C19D0Ev)();
extern void _ZN8S1608C132v2Ev();
extern void _ZN8S1608C162v4Ev();
extern void ABISELECT(_ZTv0_n80_N8S1608C19D1Ev,_ZTv0_n40_N8S1608C19D1Ev)();
extern void ABISELECT(_ZThn24_N8S1608C19D1Ev,_ZThn12_N8S1608C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N8S1608C19D0Ev,_ZTv0_n40_N8S1608C19D0Ev)();
extern void ABISELECT(_ZThn24_N8S1608C19D0Ev,_ZThn12_N8S1608C19D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn16_n80_N8S1608C19D1Ev,_ZTvn8_n40_N8S1608C19D1Ev)();
extern void ABISELECT(_ZTvn16_n80_N8S1608C19D0Ev,_ZTvn8_n40_N8S1608C19D0Ev)();
extern void _ZN8S1608C132v2Ev();
extern void _ZN8S1608C122v3Ev();
extern void ABISELECT(_ZTv0_n56_N8S1608C19D1Ev,_ZTv0_n28_N8S1608C19D1Ev)();
extern void ABISELECT(_ZThn48_N8S1608C19D1Ev,_ZThn24_N8S1608C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S1608C19D0Ev,_ZTv0_n28_N8S1608C19D0Ev)();
extern void ABISELECT(_ZThn48_N8S1608C19D0Ev,_ZThn24_N8S1608C19D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C19D1Ev,_ZTv0_n12_N8S1608C19D1Ev)();
extern void ABISELECT(_ZThn64_N8S1608C19D1Ev,_ZThn32_N8S1608C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C19D0Ev,_ZTv0_n12_N8S1608C19D0Ev)();
extern void ABISELECT(_ZThn64_N8S1608C19D0Ev,_ZThn32_N8S1608C19D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C19D1Ev,_ZTv0_n12_N8S1608C19D1Ev)();
extern void ABISELECT(_ZThn80_N8S1608C19D1Ev,_ZThn40_N8S1608C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C19D0Ev,_ZTv0_n12_N8S1608C19D0Ev)();
extern void ABISELECT(_ZThn80_N8S1608C19D0Ev,_ZThn40_N8S1608C19D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S1608C19[] = {
  ABISELECT(96,48),
  ABISELECT(80,40),
  ABISELECT(64,32),
  ABISELECT(80,40),
  ABISELECT(48,24),
  ABISELECT(24,12),
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S1608C19[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
  (VTBL_ENTRY)&_ZN8S1608C19D1Ev,
  (VTBL_ENTRY)&_ZN8S1608C19D0Ev,
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S1608C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S1608C19D1Ev,_ZThn4_N8S1608C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn8_N8S1608C19D0Ev,_ZThn4_N8S1608C19D0Ev),
  ABISELECT(-24,-12),
  0,
  0,
  ABISELECT(56,28),
  ABISELECT(40,20),
  ABISELECT(56,28),
  ABISELECT(24,12),
  ABISELECT(-24,-12),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S1608C19[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
  (VTBL_ENTRY)&_ZN8S1608C162v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S1608C19D1Ev,_ZTv0_n40_N8S1608C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S1608C19D0Ev,_ZTv0_n40_N8S1608C19D0Ev),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI8S1608C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n80_N8S1608C19D1Ev,_ZTvn8_n40_N8S1608C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn16_n80_N8S1608C19D0Ev,_ZTvn8_n40_N8S1608C19D0Ev),
  ABISELECT(-48,-24),
  0,
  0,
  ABISELECT(16,8),
  ABISELECT(32,16),
  ABISELECT(-48,-24),
  (VTBL_ENTRY)&(_ZTI8S1608C19[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
  (VTBL_ENTRY)&_ZN8S1608C122v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S1608C19D1Ev,_ZTv0_n28_N8S1608C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S1608C19D0Ev,_ZTv0_n28_N8S1608C19D0Ev),
  ABISELECT(-64,-32),
  ABISELECT(-64,-32),
  (VTBL_ENTRY)&(_ZTI8S1608C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C19D1Ev,_ZTv0_n12_N8S1608C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C19D0Ev,_ZTv0_n12_N8S1608C19D0Ev),
  ABISELECT(-80,-40),
  0,
  ABISELECT(-80,-40),
  ABISELECT(-80,-40),
  (VTBL_ENTRY)&(_ZTI8S1608C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C19D1Ev,_ZTv0_n12_N8S1608C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C19D0Ev,_ZTv0_n12_N8S1608C19D0Ev),
};
extern VTBL_ENTRY _ZTV8S1608C19[];
extern void _ZN8S1608C132v2Ev();
extern void _ZN8S1608C162v4Ev();
extern void _ZN8S1608C15D1Ev();
extern void _ZN8S1608C15D0Ev();
static  VTBL_ENTRY _tg__ZTV8S1608C15__8S1608C19[] = {
  ABISELECT(56,28),
  ABISELECT(40,20),
  ABISELECT(56,28),
  ABISELECT(24,12),
  ABISELECT(-24,-12),
  0,
  (VTBL_ENTRY)&(_ZTI8S1608C15[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
  (VTBL_ENTRY)&_ZN8S1608C162v4Ev,
  (VTBL_ENTRY)&_ZN8S1608C15D1Ev,
  (VTBL_ENTRY)&_ZN8S1608C15D0Ev,
};
extern void _ZN8S1608C132v2Ev();
extern void _ZN8S1608C162v4Ev();
extern void _ZN8S1608C16D1Ev();
extern void _ZN8S1608C16D0Ev();
static  VTBL_ENTRY _tg__ZTV8S1608C168S1608C15__8S1608C19[] = {
  ABISELECT(40,20),
  ABISELECT(56,28),
  ABISELECT(24,12),
  ABISELECT(-24,-12),
  0,
  (VTBL_ENTRY)&(_ZTI8S1608C16[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
  (VTBL_ENTRY)&_ZN8S1608C162v4Ev,
  (VTBL_ENTRY)&_ZN8S1608C16D1Ev,
  (VTBL_ENTRY)&_ZN8S1608C16D0Ev,
};
extern void _ZN8S1608C132v2Ev();
extern void _ZN8S1608C122v3Ev();
extern void ABISELECT(_ZTv0_n56_N8S1608C16D1Ev,_ZTv0_n28_N8S1608C16D1Ev)();
extern void ABISELECT(_ZThn24_N8S1608C16D1Ev,_ZThn12_N8S1608C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S1608C16D0Ev,_ZTv0_n28_N8S1608C16D0Ev)();
extern void ABISELECT(_ZThn24_N8S1608C16D0Ev,_ZThn12_N8S1608C16D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S1608C12__8S1608C168S1608C15__8S1608C19[] = {
  ABISELECT(-24,-12),
  0,
  0,
  ABISELECT(16,8),
  ABISELECT(32,16),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S1608C16[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
  (VTBL_ENTRY)&_ZN8S1608C122v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S1608C16D1Ev,_ZTv0_n28_N8S1608C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S1608C16D0Ev,_ZTv0_n28_N8S1608C16D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S1608C16D1Ev,_ZTv0_n12_N8S1608C16D1Ev)();
extern void ABISELECT(_ZThn56_N8S1608C16D1Ev,_ZThn28_N8S1608C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C16D0Ev,_ZTv0_n12_N8S1608C16D0Ev)();
extern void ABISELECT(_ZThn56_N8S1608C16D0Ev,_ZThn28_N8S1608C16D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV10S1608C9_nt__8S1608C168S1608C15__8S1608C19[] = {
  ABISELECT(-56,-28),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI8S1608C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C16D1Ev,_ZTv0_n12_N8S1608C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C16D0Ev,_ZTv0_n12_N8S1608C16D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S1608C16D1Ev,_ZTv0_n12_N8S1608C16D1Ev)();
extern void ABISELECT(_ZThn40_N8S1608C16D1Ev,_ZThn20_N8S1608C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C16D0Ev,_ZTv0_n12_N8S1608C16D0Ev)();
extern void ABISELECT(_ZThn40_N8S1608C16D0Ev,_ZThn20_N8S1608C16D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S1608C6__8S1608C168S1608C15__8S1608C19[] = {
  ABISELECT(-40,-20),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI8S1608C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C16D1Ev,_ZTv0_n12_N8S1608C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C16D0Ev,_ZTv0_n12_N8S1608C16D0Ev),
};
extern void _ZN8S1608C132v2Ev();
extern void _ZN8S1608C122v3Ev();
extern void ABISELECT(_ZTv0_n56_N8S1608C15D1Ev,_ZTv0_n28_N8S1608C15D1Ev)();
extern void ABISELECT(_ZThn24_N8S1608C15D1Ev,_ZThn12_N8S1608C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S1608C15D0Ev,_ZTv0_n28_N8S1608C15D0Ev)();
extern void ABISELECT(_ZThn24_N8S1608C15D0Ev,_ZThn12_N8S1608C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S1608C12__8S1608C15__8S1608C19[] = {
  ABISELECT(-24,-12),
  0,
  0,
  ABISELECT(16,8),
  ABISELECT(32,16),
  ABISELECT(-24,-12),
  (VTBL_ENTRY)&(_ZTI8S1608C15[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
  (VTBL_ENTRY)&_ZN8S1608C122v3Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S1608C15D1Ev,_ZTv0_n28_N8S1608C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S1608C15D0Ev,_ZTv0_n28_N8S1608C15D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S1608C15D1Ev,_ZTv0_n12_N8S1608C15D1Ev)();
extern void ABISELECT(_ZThn56_N8S1608C15D1Ev,_ZThn28_N8S1608C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C15D0Ev,_ZTv0_n12_N8S1608C15D0Ev)();
extern void ABISELECT(_ZThn56_N8S1608C15D0Ev,_ZThn28_N8S1608C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S1608C11__8S1608C15__8S1608C19[] = {
  ABISELECT(-80,-40),
  0,
  ABISELECT(-56,-28),
  ABISELECT(-56,-28),
  (VTBL_ENTRY)&(_ZTI8S1608C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C15D1Ev,_ZTv0_n12_N8S1608C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C15D0Ev,_ZTv0_n12_N8S1608C15D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S1608C15D1Ev,_ZTv0_n12_N8S1608C15D1Ev)();
extern void ABISELECT(_ZThn40_N8S1608C15D1Ev,_ZThn20_N8S1608C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C15D0Ev,_ZTv0_n12_N8S1608C15D0Ev)();
extern void ABISELECT(_ZThn40_N8S1608C15D0Ev,_ZThn20_N8S1608C15D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S1608C6__8S1608C15__8S1608C19[] = {
  ABISELECT(-40,-20),
  ABISELECT(-40,-20),
  (VTBL_ENTRY)&(_ZTI8S1608C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C15D1Ev,_ZTv0_n12_N8S1608C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C15D0Ev,_ZTv0_n12_N8S1608C15D0Ev),
};
extern void _ZN8S1608C132v2Ev();
extern void _ZN8S1608C122v3Ev();
extern void _ZN8S1608C12D1Ev();
extern void _ZN8S1608C12D0Ev();
static  VTBL_ENTRY _tg__ZTV8S1608C12__8S1608C19[] = {
  ABISELECT(16,8),
  ABISELECT(32,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S1608C12[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
  (VTBL_ENTRY)&_ZN8S1608C122v3Ev,
  (VTBL_ENTRY)&_ZN8S1608C12D1Ev,
  (VTBL_ENTRY)&_ZN8S1608C12D0Ev,
};
extern void ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev)();
extern void ABISELECT(_ZThn32_N8S1608C12D1Ev,_ZThn16_N8S1608C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev)();
extern void ABISELECT(_ZThn32_N8S1608C12D0Ev,_ZThn16_N8S1608C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV10S1608C9_nt__8S1608C12__8S1608C19[] = {
  ABISELECT(-32,-16),
  ABISELECT(-32,-16),
  (VTBL_ENTRY)&(_ZTI8S1608C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev)();
extern void ABISELECT(_ZThn16_N8S1608C12D1Ev,_ZThn8_N8S1608C12D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev)();
extern void ABISELECT(_ZThn16_N8S1608C12D0Ev,_ZThn8_N8S1608C12D0Ev)() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV7S1608C6__8S1608C12__8S1608C19[] = {
  ABISELECT(-16,-8),
  ABISELECT(-16,-8),
  (VTBL_ENTRY)&(_ZTI8S1608C12[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev),
};
extern void ABISELECT(_ZTv0_n24_N8S1608C11D1Ev,_ZTv0_n12_N8S1608C11D1Ev)();
extern void _ZN8S1608C11D1Ev() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C11D0Ev,_ZTv0_n12_N8S1608C11D0Ev)();
extern void _ZN8S1608C11D0Ev() __attribute__((weak));
static  VTBL_ENTRY _tg__ZTV8S1608C11__8S1608C19[] = {
  ABISELECT(-80,-40),
  0,
  0,
  0,
  (VTBL_ENTRY)&(_ZTI8S1608C11[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C11D1Ev,_ZTv0_n12_N8S1608C11D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C11D0Ev,_ZTv0_n12_N8S1608C11D0Ev),
};
static  VTT_ENTRY vtt_S1608C19[] = {
  {&(_ZTV8S1608C19[9]),  9,57},
  {&(_ZTV8S1608C19[26]),  26,57},
  {&(_ZTV8S1608C19[41]),  41,57},
  {&(_ZTV8S1608C19[55]),  55,57},
  {&(_ZTV8S1608C19[48]),  48,57},
  {&(_ZTV8S1608C19[55]),  55,57},
  {&(_ZTV8S1608C19[32]),  32,57},
  {&(_tg__ZTV8S1608C15__8S1608C19[7]),  7,11},
  {&(_tg__ZTV8S1608C168S1608C15__8S1608C19[6]),  6,10},
  {&(_tg__ZTV8S1608C12__8S1608C168S1608C15__8S1608C19[7]),  7,11},
  {&(_tg__ZTV10S1608C9_nt__8S1608C168S1608C15__8S1608C19[3]),  3,5},
  {&(_tg__ZTV7S1608C6__8S1608C168S1608C15__8S1608C19[3]),  3,5},
  {&(_tg__ZTV8S1608C12__8S1608C15__8S1608C19[7]),  7,11},
  {&(_tg__ZTV8S1608C11__8S1608C15__8S1608C19[5]),  5,7},
  {&(_tg__ZTV7S1608C6__8S1608C15__8S1608C19[3]),  3,5},
  {&(_tg__ZTV8S1608C11__8S1608C15__8S1608C19[5]),  5,7},
  {&(_tg__ZTV8S1608C12__8S1608C19[4]),  4,8},
  {&(_tg__ZTV10S1608C9_nt__8S1608C12__8S1608C19[3]),  3,5},
  {&(_tg__ZTV7S1608C6__8S1608C12__8S1608C19[3]),  3,5},
  {&(_tg__ZTV8S1608C11__8S1608C19[5]),  5,7},
  {&(_tg__ZTV8S1608C11__8S1608C19[5]),  5,7},
};
extern VTBL_ENTRY _ZTI8S1608C19[];
extern  VTBL_ENTRY _ZTV8S1608C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C19[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C11D0Ev,_ZTv0_n12_N8S1608C11D0Ev), // 
  (VTBL_ENTRY)_ZN8S1608C11D0Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C11D1Ev,_ZTv0_n12_N8S1608C11D1Ev), // 
  (VTBL_ENTRY)_ZN8S1608C11D1Ev,
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C12D0Ev,_ZTv0_n12_N8S1608C12D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S1608C12D0Ev,_ZThn8_N8S1608C12D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S1608C12D0Ev,_ZThn16_N8S1608C12D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C12D1Ev,_ZTv0_n12_N8S1608C12D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn16_N8S1608C12D1Ev,_ZThn8_N8S1608C12D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn32_N8S1608C12D1Ev,_ZThn16_N8S1608C12D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C15D0Ev,_ZTv0_n12_N8S1608C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N8S1608C15D0Ev,_ZThn20_N8S1608C15D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S1608C15D0Ev,_ZThn28_N8S1608C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C15D1Ev,_ZTv0_n12_N8S1608C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N8S1608C15D1Ev,_ZThn20_N8S1608C15D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S1608C15D1Ev,_ZThn28_N8S1608C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S1608C15D0Ev,_ZTv0_n28_N8S1608C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S1608C15D0Ev,_ZThn12_N8S1608C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S1608C15D1Ev,_ZTv0_n28_N8S1608C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S1608C15D1Ev,_ZThn12_N8S1608C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C16D0Ev,_ZTv0_n12_N8S1608C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N8S1608C16D0Ev,_ZThn20_N8S1608C16D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S1608C16D0Ev,_ZThn28_N8S1608C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C16D1Ev,_ZTv0_n12_N8S1608C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn40_N8S1608C16D1Ev,_ZThn20_N8S1608C16D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn56_N8S1608C16D1Ev,_ZThn28_N8S1608C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S1608C16D0Ev,_ZTv0_n28_N8S1608C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S1608C16D0Ev,_ZThn12_N8S1608C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S1608C16D1Ev,_ZTv0_n28_N8S1608C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S1608C16D1Ev,_ZThn12_N8S1608C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C19D0Ev,_ZTv0_n12_N8S1608C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N8S1608C19D0Ev,_ZThn40_N8S1608C19D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S1608C19D0Ev,_ZThn32_N8S1608C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C19D1Ev,_ZTv0_n12_N8S1608C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn80_N8S1608C19D1Ev,_ZThn40_N8S1608C19D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn64_N8S1608C19D1Ev,_ZThn32_N8S1608C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S1608C19D0Ev,_ZTv0_n28_N8S1608C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S1608C19D0Ev,_ZThn24_N8S1608C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S1608C19D1Ev,_ZTv0_n28_N8S1608C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn48_N8S1608C19D1Ev,_ZThn24_N8S1608C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S1608C19D0Ev,_ZTv0_n40_N8S1608C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S1608C19D0Ev,_ZThn12_N8S1608C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S1608C19D1Ev,_ZTv0_n40_N8S1608C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24_N8S1608C19D1Ev,_ZThn12_N8S1608C19D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S1608C19 = {  "S1608C19", // class name
  bases_S1608C19, 25,
  &(vtc_S1608C19[0]), // expected_vtbl_contents
  &(vtt_S1608C19[0]), // expected_vtt_contents
  ABISELECT(104,52), // object size
  NSPAIRA(_ZTI8S1608C19),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S1608C19),57, //virtual function table var
  9, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S1608C19),21, //virtual table table var
  13, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1608C24  : virtual S1608C6 , S1608C13 {
  virtual  ~S1608C24(); // _ZN8S1608C24D2Ev
  S1608C24(); // tgen
};
//SIG(-1 S1608C24) C1{ VBC2{ BC3{ m} BC4{ m} BC5{ vd m} vd Fi} BC6{ BC3 v1} vd}


 S1608C24 ::~S1608C24(){ note_dtor("S1608C24", this);}
S1608C24 ::S1608C24(){ note_ctor("S1608C24", this);} // tgen

static void Test_S1608C24()
{
  extern Class_Descriptor cd_S1608C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[4];
    init_test(&cd_S1608C24, buf);
    S1608C24 *dp, &lv = *(dp=new (buf) S1608C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,12), "sizeof(S1608C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1608C24)");
    check_base_class_offset(lv, (S1587C7_nt*)(S1608C6*), ABISELECT(8,4), "S1608C24");
    check_base_class_offset(lv, (S886C9_nt*)(S1608C6*), ABISELECT(8,4), "S1608C24");
    check_base_class_offset(lv, (S1608C9_nt*)(S1608C6*), ABISELECT(8,4), "S1608C24");
    check_base_class_offset(lv, (S1608C6*), ABISELECT(8,4), "S1608C24");
    check_base_class_offset(lv, (S1587C7_nt*)(S1608C13*), 0, "S1608C24");
    check_base_class_offset(lv, (S1608C13*), 0, "S1608C24");
    test_class_info(&lv, &cd_S1608C24);
    dp->~S1608C24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1608C24(Test_S1608C24, "S1608C24", ABISELECT(24,12));

#else // __cplusplus

extern void _ZN8S1608C24C1Ev();
extern void _ZN8S1608C24D2Ev();
Name_Map name_map_S1608C24[] = {
  NSPAIR(_ZN8S1608C24C1Ev),
  NSPAIR(_ZN8S1608C24D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
extern Class_Descriptor cd_S1608C6;
extern VTBL_ENTRY _ZTI7S1608C6[];
extern  VTBL_ENTRY _ZTV7S1608C6[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1608C13;
extern VTBL_ENTRY _ZTI8S1608C13[];
extern  VTBL_ENTRY _ZTV8S1608C13[];
static Base_Class bases_S1608C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1587C7_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S886C9_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1608C9_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S1608C6,    ABISELECT(8,4), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S1587C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S1608C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S1608C24[];
extern void _ZN8S1608C132v2Ev();
extern void _ZN8S1608C24D1Ev();
extern void _ZN8S1608C24D0Ev();
extern void ABISELECT(_ZTv0_n24_N8S1608C24D1Ev,_ZTv0_n12_N8S1608C24D1Ev)();
extern void ABISELECT(_ZThn8_N8S1608C24D1Ev,_ZThn4_N8S1608C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n24_N8S1608C24D0Ev,_ZTv0_n12_N8S1608C24D0Ev)();
extern void ABISELECT(_ZThn8_N8S1608C24D0Ev,_ZThn4_N8S1608C24D0Ev)() __attribute__((weak));
static  VTBL_ENTRY vtc_S1608C24[] = {
  ABISELECT(8,4),
  0,
  (VTBL_ENTRY)&(_ZTI8S1608C24[0]),
  (VTBL_ENTRY)&_ZN8S1608C132v2Ev,
  (VTBL_ENTRY)&_ZN8S1608C24D1Ev,
  (VTBL_ENTRY)&_ZN8S1608C24D0Ev,
  ABISELECT(-8,-4),
  ABISELECT(-8,-4),
  (VTBL_ENTRY)&(_ZTI8S1608C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C24D1Ev,_ZTv0_n12_N8S1608C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n24_N8S1608C24D0Ev,_ZTv0_n12_N8S1608C24D0Ev),
};
extern VTBL_ENTRY _ZTV8S1608C24[];
static  VTT_ENTRY vtt_S1608C24[] = {
  {&(_ZTV8S1608C24[3]),  3,11},
  {&(_ZTV8S1608C24[9]),  9,11},
};
extern VTBL_ENTRY _ZTI8S1608C24[];
extern  VTBL_ENTRY _ZTV8S1608C24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C24[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C24D0Ev,_ZTv0_n12_N8S1608C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N8S1608C24D0Ev,_ZThn4_N8S1608C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n24_N8S1608C24D1Ev,_ZTv0_n12_N8S1608C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8_N8S1608C24D1Ev,_ZThn4_N8S1608C24D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S1608C24 = {  "S1608C24", // class name
  bases_S1608C24, 6,
  &(vtc_S1608C24[0]), // expected_vtbl_contents
  &(vtt_S1608C24[0]), // expected_vtt_contents
  ABISELECT(24,12), // object size
  NSPAIRA(_ZTI8S1608C24),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S1608C24),11, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S1608C24),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1608C23  : virtual S1608C16 , S1608C10 , virtual S1608C4 , virtual S1608C24 {
  ~S1608C23(); // tgen
  S1608C23(); // tgen
};
//SIG(-1 S1608C23) C1{ VBC2{ BC3{ BC4{ m} v1} VBC5{ m} VBC6{ VBC7{ vd m} BC5 VBC8{ BC4 BC5 BC7 vd Fi} BC4 BC3 v2} v3 Fi} BC9{ BC10{ VBC7 VBC5 BC4 Fi} Fp} VBC11{ VBC12{ BC8 vd Fi Fp} vd Fs} VBC13{ VBC8 BC3 vd}}


S1608C23 ::~S1608C23(){ note_dtor("S1608C23", this);} // tgen
S1608C23 ::S1608C23(){ note_ctor("S1608C23", this);} // tgen

static void Test_S1608C23()
{
  extern Class_Descriptor cd_S1608C23;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(16,17)];
    init_test(&cd_S1608C23, buf);
    S1608C23 *dp, &lv = *(dp=new (buf) S1608C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(120,64), "sizeof(S1608C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1608C23)");
    /*is_ambiguous_... S1608C16::S1608C13 */ AMB_check_base_class_offset(lv, (S1587C7_nt*)(S1608C13*)(S1608C16*), ABISELECT(24,12), "S1608C23");
    /*is_ambiguous_... S1608C16::S1608C13 */ AMB_check_base_class_offset(lv, (S1608C13*)(S1608C16*), ABISELECT(24,12), "S1608C23");
    /*is_ambiguous_... S1608C16::S886C9_nt */ AMB_check_base_class_offset(lv, (S886C9_nt*)(S1608C16*), 0, "S1608C23");
    check_base_class_offset(lv, (S886C9_nt*)(S1608C11*)(S1608C10*), 0, "S1608C23");
    /*is_ambiguous_... S1608C12::S1608C9_nt */ AMB_check_base_class_offset(lv, (S1608C9_nt*)(S1608C12*), 0, "S1608C23");
    check_base_class_offset(lv, (S1608C9_nt*)(S1608C11*)(S1608C10*), 0, "S1608C23");
    /*is_ambiguous_... S1608C12::S886C9_nt */ AMB_check_base_class_offset(lv, (S886C9_nt*)(S1608C12*), ABISELECT(40,20), "S1608C23");
    /*is_ambiguous_... S1608C23::S1608C6 */ AMB_check_base_class_offset(lv, (S1587C7_nt*)(S1608C6*), ABISELECT(56,28), "S1608C23");
    /*is_ambiguous_... S1608C23::S1608C6 */ AMB_check_base_class_offset(lv, (S886C9_nt*)(S1608C6*), ABISELECT(56,28), "S1608C23");
    /*is_ambiguous_... S1608C23::S1608C6 */ AMB_check_base_class_offset(lv, (S1608C9_nt*)(S1608C6*), ABISELECT(56,28), "S1608C23");
    check_base_class_offset(lv, (S1608C6*)(S1608C12*), ABISELECT(56,28), "S1608C23");
    check_base_class_offset(lv, (S1608C6*)(S1608C24*), ABISELECT(56,28), "S1608C23");
    /*is_ambiguous_... S1608C12::S1587C7_nt */ AMB_check_base_class_offset(lv, (S1587C7_nt*)(S1608C12*), ABISELECT(48,24), "S1608C23");
    check_base_class_offset(lv, (S1587C7_nt*)(S1608C13*)(S1608C12*), ABISELECT(40,20), "S1608C23");
    check_base_class_offset(lv, (S1608C13*)(S1608C12*), ABISELECT(40,20), "S1608C23");
    check_base_class_offset(lv, (S1608C12*)(S1608C16*), ABISELECT(40,20), "S1608C23");
    check_base_class_offset(lv, (S1608C16*), ABISELECT(24,12), "S1608C23");
    check_base_class_offset(lv, (S1587C7_nt*)(S1608C11*)(S1608C10*), 0, "S1608C23");
    check_base_class_offset(lv, (S1608C11*)(S1608C10*), 0, "S1608C23");
    check_base_class_offset(lv, (S1608C10*), 0, "S1608C23");
    check_base_class_offset(lv, (S1587C7_nt*)(S1608C6*)(S1608C5*), ABISELECT(88,44), "S1608C23");
    check_base_class_offset(lv, (S886C9_nt*)(S1608C6*)(S1608C5*), ABISELECT(88,44), "S1608C23");
    check_base_class_offset(lv, (S1608C9_nt*)(S1608C6*)(S1608C5*), ABISELECT(88,44), "S1608C23");
    check_base_class_offset(lv, (S1608C6*)(S1608C5*), ABISELECT(88,44), "S1608C23");
    check_base_class_offset(lv, (S1608C5*)(S1608C4*), ABISELECT(88,44), "S1608C23");
    check_base_class_offset(lv, (S1608C4*), ABISELECT(72,36), "S1608C23");
    check_base_class_offset(lv, (S1587C7_nt*)(S1608C13*)(S1608C24*), ABISELECT(112,60), "S1608C23");
    check_base_class_offset(lv, (S1608C13*)(S1608C24*), ABISELECT(112,60), "S1608C23");
    check_base_class_offset(lv, (S1608C24*), ABISELECT(112,60), "S1608C23");
    test_class_info(&lv, &cd_S1608C23);
    dp->~S1608C23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1608C23(Test_S1608C23, "S1608C23", ABISELECT(120,64));

#else // __cplusplus

extern void _ZN8S1608C23C1Ev();
extern void _ZN8S1608C23D1Ev();
Name_Map name_map_S1608C23[] = {
  NSPAIR(_ZN8S1608C23C1Ev),
  NSPAIR(_ZN8S1608C23D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1608C13;
extern VTBL_ENTRY _ZTI8S1608C13[];
extern  VTBL_ENTRY _ZTV8S1608C13[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
extern Class_Descriptor cd_S1608C6;
extern VTBL_ENTRY _ZTI7S1608C6[];
extern  VTBL_ENTRY _ZTV7S1608C6[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1608C13;
extern VTBL_ENTRY _ZTI8S1608C13[];
extern  VTBL_ENTRY _ZTV8S1608C13[];
extern Class_Descriptor cd_S1608C12;
extern VTBL_ENTRY _ZTI8S1608C12[];
extern  VTBL_ENTRY _ZTV8S1608C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C12[];
extern Class_Descriptor cd_S1608C16;
extern VTBL_ENTRY _ZTI8S1608C16[];
extern  VTBL_ENTRY _ZTV8S1608C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C16[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1608C11;
extern VTBL_ENTRY _ZTI8S1608C11[];
extern  VTBL_ENTRY _ZTV8S1608C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C11[];
extern Class_Descriptor cd_S1608C10;
extern VTBL_ENTRY _ZTI8S1608C10[];
extern  VTBL_ENTRY _ZTV8S1608C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C10[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S886C9_nt;
extern VTBL_ENTRY _ZTI9S886C9_nt[];
extern Class_Descriptor cd_S1608C9_nt;
extern VTBL_ENTRY _ZTI10S1608C9_nt[];
extern  VTBL_ENTRY _ZTV10S1608C9_nt[];
extern Class_Descriptor cd_S1608C6;
extern VTBL_ENTRY _ZTI7S1608C6[];
extern  VTBL_ENTRY _ZTV7S1608C6[];
extern Class_Descriptor cd_S1608C5;
extern VTBL_ENTRY _ZTI7S1608C5[];
extern  VTBL_ENTRY _ZTV7S1608C5[];
extern Class_Descriptor cd_S1608C4;
extern VTBL_ENTRY _ZTI7S1608C4[];
extern  VTBL_ENTRY _ZTV7S1608C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S1608C4[];
extern Class_Descriptor cd_S1587C7_nt;
extern VTBL_ENTRY _ZTI10S1587C7_nt[];
extern Class_Descriptor cd_S1608C13;
extern VTBL_ENTRY _ZTI8S1608C13[];
extern  VTBL_ENTRY _ZTV8S1608C13[];
extern Class_Descriptor cd_S1608C24;
extern VTBL_ENTRY _ZTI8S1608C24[];
extern  VTBL_ENTRY _ZTV8S1608C24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S1608C24[];
static Base_Class bases_S1608C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1587C7_nt,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1608C13,    ABISELECT(24,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S886C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S1608C9_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S886C9_nt,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S1587C7_nt,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S886C9_nt,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S1608C9_nt,    ABISELECT(56,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S1608C6,    ABISELECT(56,28), //bcp->offset
    37, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    12, //immediately_derived
  0, 1},
  {&cd_S1587C7_nt,    ABISELECT(48,24), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S1587C7_nt,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S1608C13,    ABISELECT(40,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S1608C12,    ABISELECT(40,20), //bcp->offset
    26, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    13, //immediately_derived
  0, 1},
  {&cd_S1608C16,    ABISELECT(24,12), //bcp->offset
    13, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S1587C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S1608C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S1608C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S1587C7_nt,    ABISELECT(88,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S886C9_nt,    ABISELECT(88,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S1608C9_nt,    ABISELECT(88,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S1608C6,    ABISELECT(88,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S1608C5,    ABISELECT(88,44), //bcp->offset
    48, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    22, //immediately_derived
  0, 1},
  {&cd_S1608C4,    ABISELECT(72,36), //bcp->offset