// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S3216C4_nt  {
  int s3216c4f0[2];
  void  mf3216c4(); // _ZN10S3216C4_nt8mf3216c4Ev
};
//SIG(-1 S3216C4_nt) C1{ m Fi[2]}


void  S3216C4_nt ::mf3216c4(){}

//skip512 S3216C4_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3216C3_nt  {
  int s3216c3f0;
  __tsi64 s3216c3f1;
  void *s3216c3f2[4];
  int s3216c3f3[2];
  void *s3216c3f4;
  ::S3216C4_nt s3216c3f5;
  void *s3216c3f6[2];
  virtual  ~S3216C3_nt(); // _ZN10S3216C3_ntD1Ev
  virtual void  v4(); // _ZN10S3216C3_nt2v4Ev
  virtual void  v5(); // _ZN10S3216C3_nt2v5Ev
  virtual void  v6(); // _ZN10S3216C3_nt2v6Ev
  virtual void  v7(); // _ZN10S3216C3_nt2v7Ev
  virtual void  v8(); // _ZN10S3216C3_nt2v8Ev
  virtual void  v9(); // _ZN10S3216C3_nt2v9Ev
  virtual void  v10(); // _ZN10S3216C3_nt3v10Ev
  virtual void  v11(); // _ZN10S3216C3_nt3v11Ev
  virtual void  v12(); // _ZN10S3216C3_nt3v12Ev
  virtual void  v13(); // _ZN10S3216C3_nt3v13Ev
  virtual void  v14(); // _ZN10S3216C3_nt3v14Ev
  virtual void  v15(); // _ZN10S3216C3_nt3v15Ev
  virtual void  v16(); // _ZN10S3216C3_nt3v16Ev
  virtual void  v17(); // _ZN10S3216C3_nt3v17Ev
  virtual void  v18(); // _ZN10S3216C3_nt3v18Ev
  virtual void  v19(); // _ZN10S3216C3_nt3v19Ev
  virtual void  v20(); // _ZN10S3216C3_nt3v20Ev
  virtual void  v21(); // _ZN10S3216C3_nt3v21Ev
  virtual void  v22(); // _ZN10S3216C3_nt3v22Ev
  virtual void  v23(); // _ZN10S3216C3_nt3v23Ev
  virtual void  v24(); // _ZN10S3216C3_nt3v24Ev
  virtual void  v25(); // _ZN10S3216C3_nt3v25Ev
  virtual void  v26(); // _ZN10S3216C3_nt3v26Ev
  virtual void  v27(); // _ZN10S3216C3_nt3v27Ev
  virtual void  v28(); // _ZN10S3216C3_nt3v28Ev
  virtual void  v29(); // _ZN10S3216C3_nt3v29Ev
  virtual void  v30(); // _ZN10S3216C3_nt3v30Ev
  virtual void  v31(); // _ZN10S3216C3_nt3v31Ev
  virtual void  v32(); // _ZN10S3216C3_nt3v32Ev
  virtual void  v33(); // _ZN10S3216C3_nt3v33Ev
  virtual void  v34(); // _ZN10S3216C3_nt3v34Ev
  virtual void  v35(); // _ZN10S3216C3_nt3v35Ev
  virtual void  v36(); // _ZN10S3216C3_nt3v36Ev
  virtual void  v37(); // _ZN10S3216C3_nt3v37Ev
  virtual void  v38(); // _ZN10S3216C3_nt3v38Ev
  virtual void  v39(); // _ZN10S3216C3_nt3v39Ev
  virtual void  v40(); // _ZN10S3216C3_nt3v40Ev
  virtual void  v41(); // _ZN10S3216C3_nt3v41Ev
  virtual void  v42(); // _ZN10S3216C3_nt3v42Ev
  virtual void  v43(); // _ZN10S3216C3_nt3v43Ev
  virtual void  v44(); // _ZN10S3216C3_nt3v44Ev
  virtual void  v45(); // _ZN10S3216C3_nt3v45Ev
  virtual void  v46(); // _ZN10S3216C3_nt3v46Ev
  virtual void  v47(); // _ZN10S3216C3_nt3v47Ev
  virtual void  v48(); // _ZN10S3216C3_nt3v48Ev
  virtual void  v49(); // _ZN10S3216C3_nt3v49Ev
  virtual void  v50(); // _ZN10S3216C3_nt3v50Ev
  virtual void  v51(); // _ZN10S3216C3_nt3v51Ev
  virtual void  v52(); // _ZN10S3216C3_nt3v52Ev
  virtual void  v53(); // _ZN10S3216C3_nt3v53Ev
  virtual void  v54(); // _ZN10S3216C3_nt3v54Ev
  virtual void  v55(); // _ZN10S3216C3_nt3v55Ev
  virtual void  v56(); // _ZN10S3216C3_nt3v56Ev
  virtual void  v57(); // _ZN10S3216C3_nt3v57Ev
  virtual void  v58(); // _ZN10S3216C3_nt3v58Ev
  virtual void  v59(); // _ZN10S3216C3_nt3v59Ev
  virtual void  v60(); // _ZN10S3216C3_nt3v60Ev
  virtual void  v61(); // _ZN10S3216C3_nt3v61Ev
  virtual void  v62(); // _ZN10S3216C3_nt3v62Ev
  virtual void  v63(); // _ZN10S3216C3_nt3v63Ev
  virtual void  v64(); // _ZN10S3216C3_nt3v64Ev
  virtual void  v65(); // _ZN10S3216C3_nt3v65Ev
  virtual void  v66(); // _ZN10S3216C3_nt3v66Ev
  virtual void  v67(); // _ZN10S3216C3_nt3v67Ev
  S3216C3_nt(); // tgen
};
//SIG(-1 S3216C3_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S3216C3_nt ::~S3216C3_nt(){ note_dtor("S3216C3_nt", this);}
void  S3216C3_nt ::v4(){vfunc_called(this, "_ZN10S3216C3_nt2v4Ev");}
void  S3216C3_nt ::v5(){vfunc_called(this, "_ZN10S3216C3_nt2v5Ev");}
void  S3216C3_nt ::v6(){vfunc_called(this, "_ZN10S3216C3_nt2v6Ev");}
void  S3216C3_nt ::v7(){vfunc_called(this, "_ZN10S3216C3_nt2v7Ev");}
void  S3216C3_nt ::v8(){vfunc_called(this, "_ZN10S3216C3_nt2v8Ev");}
void  S3216C3_nt ::v9(){vfunc_called(this, "_ZN10S3216C3_nt2v9Ev");}
void  S3216C3_nt ::v10(){vfunc_called(this, "_ZN10S3216C3_nt3v10Ev");}
void  S3216C3_nt ::v11(){vfunc_called(this, "_ZN10S3216C3_nt3v11Ev");}
void  S3216C3_nt ::v12(){vfunc_called(this, "_ZN10S3216C3_nt3v12Ev");}
void  S3216C3_nt ::v13(){vfunc_called(this, "_ZN10S3216C3_nt3v13Ev");}
void  S3216C3_nt ::v14(){vfunc_called(this, "_ZN10S3216C3_nt3v14Ev");}
void  S3216C3_nt ::v15(){vfunc_called(this, "_ZN10S3216C3_nt3v15Ev");}
void  S3216C3_nt ::v16(){vfunc_called(this, "_ZN10S3216C3_nt3v16Ev");}
void  S3216C3_nt ::v17(){vfunc_called(this, "_ZN10S3216C3_nt3v17Ev");}
void  S3216C3_nt ::v18(){vfunc_called(this, "_ZN10S3216C3_nt3v18Ev");}
void  S3216C3_nt ::v19(){vfunc_called(this, "_ZN10S3216C3_nt3v19Ev");}
void  S3216C3_nt ::v20(){vfunc_called(this, "_ZN10S3216C3_nt3v20Ev");}
void  S3216C3_nt ::v21(){vfunc_called(this, "_ZN10S3216C3_nt3v21Ev");}
void  S3216C3_nt ::v22(){vfunc_called(this, "_ZN10S3216C3_nt3v22Ev");}
void  S3216C3_nt ::v23(){vfunc_called(this, "_ZN10S3216C3_nt3v23Ev");}
void  S3216C3_nt ::v24(){vfunc_called(this, "_ZN10S3216C3_nt3v24Ev");}
void  S3216C3_nt ::v25(){vfunc_called(this, "_ZN10S3216C3_nt3v25Ev");}
void  S3216C3_nt ::v26(){vfunc_called(this, "_ZN10S3216C3_nt3v26Ev");}
void  S3216C3_nt ::v27(){vfunc_called(this, "_ZN10S3216C3_nt3v27Ev");}
void  S3216C3_nt ::v28(){vfunc_called(this, "_ZN10S3216C3_nt3v28Ev");}
void  S3216C3_nt ::v29(){vfunc_called(this, "_ZN10S3216C3_nt3v29Ev");}
void  S3216C3_nt ::v30(){vfunc_called(this, "_ZN10S3216C3_nt3v30Ev");}
void  S3216C3_nt ::v31(){vfunc_called(this, "_ZN10S3216C3_nt3v31Ev");}
void  S3216C3_nt ::v32(){vfunc_called(this, "_ZN10S3216C3_nt3v32Ev");}
void  S3216C3_nt ::v33(){vfunc_called(this, "_ZN10S3216C3_nt3v33Ev");}
void  S3216C3_nt ::v34(){vfunc_called(this, "_ZN10S3216C3_nt3v34Ev");}
void  S3216C3_nt ::v35(){vfunc_called(this, "_ZN10S3216C3_nt3v35Ev");}
void  S3216C3_nt ::v36(){vfunc_called(this, "_ZN10S3216C3_nt3v36Ev");}
void  S3216C3_nt ::v37(){vfunc_called(this, "_ZN10S3216C3_nt3v37Ev");}
void  S3216C3_nt ::v38(){vfunc_called(this, "_ZN10S3216C3_nt3v38Ev");}
void  S3216C3_nt ::v39(){vfunc_called(this, "_ZN10S3216C3_nt3v39Ev");}
void  S3216C3_nt ::v40(){vfunc_called(this, "_ZN10S3216C3_nt3v40Ev");}
void  S3216C3_nt ::v41(){vfunc_called(this, "_ZN10S3216C3_nt3v41Ev");}
void  S3216C3_nt ::v42(){vfunc_called(this, "_ZN10S3216C3_nt3v42Ev");}
void  S3216C3_nt ::v43(){vfunc_called(this, "_ZN10S3216C3_nt3v43Ev");}
void  S3216C3_nt ::v44(){vfunc_called(this, "_ZN10S3216C3_nt3v44Ev");}
void  S3216C3_nt ::v45(){vfunc_called(this, "_ZN10S3216C3_nt3v45Ev");}
void  S3216C3_nt ::v46(){vfunc_called(this, "_ZN10S3216C3_nt3v46Ev");}
void  S3216C3_nt ::v47(){vfunc_called(this, "_ZN10S3216C3_nt3v47Ev");}
void  S3216C3_nt ::v48(){vfunc_called(this, "_ZN10S3216C3_nt3v48Ev");}
void  S3216C3_nt ::v49(){vfunc_called(this, "_ZN10S3216C3_nt3v49Ev");}
void  S3216C3_nt ::v50(){vfunc_called(this, "_ZN10S3216C3_nt3v50Ev");}
void  S3216C3_nt ::v51(){vfunc_called(this, "_ZN10S3216C3_nt3v51Ev");}
void  S3216C3_nt ::v52(){vfunc_called(this, "_ZN10S3216C3_nt3v52Ev");}
void  S3216C3_nt ::v53(){vfunc_called(this, "_ZN10S3216C3_nt3v53Ev");}
void  S3216C3_nt ::v54(){vfunc_called(this, "_ZN10S3216C3_nt3v54Ev");}
void  S3216C3_nt ::v55(){vfunc_called(this, "_ZN10S3216C3_nt3v55Ev");}
void  S3216C3_nt ::v56(){vfunc_called(this, "_ZN10S3216C3_nt3v56Ev");}
void  S3216C3_nt ::v57(){vfunc_called(this, "_ZN10S3216C3_nt3v57Ev");}
void  S3216C3_nt ::v58(){vfunc_called(this, "_ZN10S3216C3_nt3v58Ev");}
void  S3216C3_nt ::v59(){vfunc_called(this, "_ZN10S3216C3_nt3v59Ev");}
void  S3216C3_nt ::v60(){vfunc_called(this, "_ZN10S3216C3_nt3v60Ev");}
void  S3216C3_nt ::v61(){vfunc_called(this, "_ZN10S3216C3_nt3v61Ev");}
void  S3216C3_nt ::v62(){vfunc_called(this, "_ZN10S3216C3_nt3v62Ev");}
void  S3216C3_nt ::v63(){vfunc_called(this, "_ZN10S3216C3_nt3v63Ev");}
void  S3216C3_nt ::v64(){vfunc_called(this, "_ZN10S3216C3_nt3v64Ev");}
void  S3216C3_nt ::v65(){vfunc_called(this, "_ZN10S3216C3_nt3v65Ev");}
void  S3216C3_nt ::v66(){vfunc_called(this, "_ZN10S3216C3_nt3v66Ev");}
void  S3216C3_nt ::v67(){vfunc_called(this, "_ZN10S3216C3_nt3v67Ev");}
S3216C3_nt ::S3216C3_nt(){ note_ctor("S3216C3_nt", this);} // tgen

//skip512 S3216C3_nt

#else // __cplusplus

extern void _ZN10S3216C3_ntC1Ev();
extern void _ZN10S3216C3_ntD1Ev();
Name_Map name_map_S3216C3_nt[] = {
  NSPAIR(_ZN10S3216C3_ntC1Ev),
  NSPAIR(_ZN10S3216C3_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S3216C3_nt[];
extern void _ZN10S3216C3_ntD1Ev();
extern void _ZN10S3216C3_ntD0Ev();
extern void _ZN10S3216C3_nt2v4Ev();
extern void _ZN10S3216C3_nt2v5Ev();
extern void _ZN10S3216C3_nt2v6Ev();
extern void _ZN10S3216C3_nt2v7Ev();
extern void _ZN10S3216C3_nt2v8Ev();
extern void _ZN10S3216C3_nt2v9Ev();
extern void _ZN10S3216C3_nt3v10Ev();
extern void _ZN10S3216C3_nt3v11Ev();
extern void _ZN10S3216C3_nt3v12Ev();
extern void _ZN10S3216C3_nt3v13Ev();
extern void _ZN10S3216C3_nt3v14Ev();
extern void _ZN10S3216C3_nt3v15Ev();
extern void _ZN10S3216C3_nt3v16Ev();
extern void _ZN10S3216C3_nt3v17Ev();
extern void _ZN10S3216C3_nt3v18Ev();
extern void _ZN10S3216C3_nt3v19Ev();
extern void _ZN10S3216C3_nt3v20Ev();
extern void _ZN10S3216C3_nt3v21Ev();
extern void _ZN10S3216C3_nt3v22Ev();
extern void _ZN10S3216C3_nt3v23Ev();
extern void _ZN10S3216C3_nt3v24Ev();
extern void _ZN10S3216C3_nt3v25Ev();
extern void _ZN10S3216C3_nt3v26Ev();
extern void _ZN10S3216C3_nt3v27Ev();
extern void _ZN10S3216C3_nt3v28Ev();
extern void _ZN10S3216C3_nt3v29Ev();
extern void _ZN10S3216C3_nt3v30Ev();
extern void _ZN10S3216C3_nt3v31Ev();
extern void _ZN10S3216C3_nt3v32Ev();
extern void _ZN10S3216C3_nt3v33Ev();
extern void _ZN10S3216C3_nt3v34Ev();
extern void _ZN10S3216C3_nt3v35Ev();
extern void _ZN10S3216C3_nt3v36Ev();
extern void _ZN10S3216C3_nt3v37Ev();
extern void _ZN10S3216C3_nt3v38Ev();
extern void _ZN10S3216C3_nt3v39Ev();
extern void _ZN10S3216C3_nt3v40Ev();
extern void _ZN10S3216C3_nt3v41Ev();
extern void _ZN10S3216C3_nt3v42Ev();
extern void _ZN10S3216C3_nt3v43Ev();
extern void _ZN10S3216C3_nt3v44Ev();
extern void _ZN10S3216C3_nt3v45Ev();
extern void _ZN10S3216C3_nt3v46Ev();
extern void _ZN10S3216C3_nt3v47Ev();
extern void _ZN10S3216C3_nt3v48Ev();
extern void _ZN10S3216C3_nt3v49Ev();
extern void _ZN10S3216C3_nt3v50Ev();
extern void _ZN10S3216C3_nt3v51Ev();
extern void _ZN10S3216C3_nt3v52Ev();
extern void _ZN10S3216C3_nt3v53Ev();
extern void _ZN10S3216C3_nt3v54Ev();
extern void _ZN10S3216C3_nt3v55Ev();
extern void _ZN10S3216C3_nt3v56Ev();
extern void _ZN10S3216C3_nt3v57Ev();
extern void _ZN10S3216C3_nt3v58Ev();
extern void _ZN10S3216C3_nt3v59Ev();
extern void _ZN10S3216C3_nt3v60Ev();
extern void _ZN10S3216C3_nt3v61Ev();
extern void _ZN10S3216C3_nt3v62Ev();
extern void _ZN10S3216C3_nt3v63Ev();
extern void _ZN10S3216C3_nt3v64Ev();
extern void _ZN10S3216C3_nt3v65Ev();
extern void _ZN10S3216C3_nt3v66Ev();
extern void _ZN10S3216C3_nt3v67Ev();
static  VTBL_ENTRY vtc_S3216C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S3216C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S3216C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v67Ev,
};
extern VTBL_ENTRY _ZTI10S3216C3_nt[];
VTBL_ENTRY *P__ZTI10S3216C3_nt = _ZTI10S3216C3_nt; 
extern  VTBL_ENTRY _ZTV10S3216C3_nt[];
Class_Descriptor cd_S3216C3_nt = {  "S3216C3_nt", // class name
  0,0,//no base classes
  &(vtc_S3216C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI10S3216C3_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S3216C3_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3216C7_nt  {
  void *s3216c7f0;
  int s3216c7f1[2];
  void  mf3216c7(); // _ZN10S3216C7_nt8mf3216c7Ev
};
//SIG(-1 S3216C7_nt) C1{ m Fp Fi[2]}


void  S3216C7_nt ::mf3216c7(){}

//skip512 S3216C7_nt

#else // __cplusplus

Class_Descriptor cd_S3216C7_nt = {  "S3216C7_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3216C6_nt  : S3216C7_nt {
};
//SIG(-1 S3216C6_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S3216C6_nt

#else // __cplusplus

extern Class_Descriptor cd_S3216C7_nt;
static Base_Class bases_S3216C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3216C6_nt = {  "S3216C6_nt", // class name
  bases_S3216C6_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3216C5_nt  : S3216C6_nt {
};
//SIG(-1 S3216C5_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S3216C5_nt

#else // __cplusplus

extern Class_Descriptor cd_S3216C7_nt;
extern Class_Descriptor cd_S3216C6_nt;
static Base_Class bases_S3216C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3216C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3216C8_nt  {
  int s3216c8f0;
  void  mf3216c8(); // _ZN10S3216C8_nt8mf3216c8Ev
};
//SIG(-1 S3216C8_nt) C1{ m Fi}


void  S3216C8_nt ::mf3216c8(){}

//skip512 S3216C8_nt

#else // __cplusplus

extern VTBL_ENTRY _ZTI10S3216C8_nt[];
VTBL_ENTRY *P__ZTI10S3216C8_nt = _ZTI10S3216C8_nt; 
Class_Descriptor cd_S3216C8_nt = {  "S3216C8_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  NSPAIRA(_ZTI10S3216C8_nt),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3216C12  : S3216C7_nt {
};
//SIG(-1 S3216C12) C1{ BC2{ m Fp Fi[2]}}



static void Test_S3216C12()
{
  extern Class_Descriptor cd_S3216C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3216C12, buf);
    S3216C12 &lv = *(new (buf) S3216C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3216C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3216C12)");
    check_base_class_offset(lv, (S3216C7_nt*), 0, "S3216C12");
    test_class_info(&lv, &cd_S3216C12);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3216C12(Test_S3216C12, "S3216C12", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3216C7_nt;
static Base_Class bases_S3216C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3216C12 = {  "S3216C12", // class name
  bases_S3216C12, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3216C11  : S3216C12 {
};
//SIG(-1 S3216C11) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S3216C11()
{
  extern Class_Descriptor cd_S3216C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3216C11, buf);
    S3216C11 &lv = *(new (buf) S3216C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3216C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3216C11)");
    check_base_class_offset(lv, (S3216C7_nt*)(S3216C12*), 0, "S3216C11");
    check_base_class_offset(lv, (S3216C12*), 0, "S3216C11");
    test_class_info(&lv, &cd_S3216C11);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3216C11(Test_S3216C11, "S3216C11", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3216C7_nt;
extern Class_Descriptor cd_S3216C12;
static Base_Class bases_S3216C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3216C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3216C11 = {  "S3216C11", // class name
  bases_S3216C11, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3216C13_nt  {
  int s3216c13f0[3];
  void  mf3216c13(); // _ZN11S3216C13_nt9mf3216c13Ev
};
//SIG(-1 S3216C13_nt) C1{ m Fi[3]}


void  S3216C13_nt ::mf3216c13(){}

//skip512 S3216C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3216C18  : S3216C7_nt {
};
//SIG(-1 S3216C18) C1{ BC2{ m Fp Fi[2]}}



static void Test_S3216C18()
{
  extern Class_Descriptor cd_S3216C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3216C18, buf);
    S3216C18 &lv = *(new (buf) S3216C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3216C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3216C18)");
    check_base_class_offset(lv, (S3216C7_nt*), 0, "S3216C18");
    test_class_info(&lv, &cd_S3216C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3216C18(Test_S3216C18, "S3216C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3216C7_nt;
static Base_Class bases_S3216C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3216C18 = {  "S3216C18", // class name
  bases_S3216C18, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3216C17  : S3216C18 {
};
//SIG(-1 S3216C17) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S3216C17()
{
  extern Class_Descriptor cd_S3216C17;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S3216C17, buf);
    S3216C17 &lv = *(new (buf) S3216C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S3216C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3216C17)");
    check_base_class_offset(lv, (S3216C7_nt*)(S3216C18*), 0, "S3216C17");
    check_base_class_offset(lv, (S3216C18*), 0, "S3216C17");
    test_class_info(&lv, &cd_S3216C17);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3216C17(Test_S3216C17, "S3216C17", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3216C7_nt;
extern Class_Descriptor cd_S3216C18;
static Base_Class bases_S3216C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3216C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S3216C17 = {  "S3216C17", // class name
  bases_S3216C17, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3216C2_nt  : S3216C3_nt {
  ::S3216C5_nt s3216c2f0;
  ::S3216C5_nt s3216c2f1;
  ::S3216C8_nt s3216c2f2;
  int s3216c2f3;
  char s3216c2f4[4];
  void *s3216c2f5[2];
  ::S3216C5_nt s3216c2f6;
  unsigned int s3216c2f7:1;
  unsigned int s3216c2f8:1;
  unsigned int s3216c2f9:1;
  unsigned int s3216c2f10:1;
  unsigned int s3216c2f11:1;
  unsigned int s3216c2f12:1;
  unsigned int s3216c2f13:1;
  unsigned int s3216c2f14:1;
  unsigned int s3216c2f15:1;
  unsigned int s3216c2f16:1;
  unsigned int s3216c2f17:1;
  unsigned int s3216c2f18:1;
  unsigned int s3216c2f19:1;
  unsigned int s3216c2f20:1;
  unsigned int s3216c2f21:1;
  unsigned int s3216c2f22:1;
  unsigned int s3216c2f23:1;
  unsigned int s3216c2f24:1;
  unsigned int s3216c2f25:1;
  unsigned int s3216c2f26:1;
  unsigned int s3216c2f27:1;
  unsigned int s3216c2f28:1;
  unsigned int s3216c2f29:1;
  unsigned int s3216c2f30:1;
  unsigned int s3216c2f31:1;
  unsigned int s3216c2f32:1;
  unsigned int s3216c2f33:1;
  unsigned int s3216c2f34:1;
  unsigned int s3216c2f35:1;
  unsigned int s3216c2f36:1;
  unsigned int s3216c2f37:1;
  unsigned int s3216c2f38:1;
  unsigned int s3216c2f39:1;
  unsigned int s3216c2f40:1;
  unsigned int s3216c2f41:1;
  unsigned int s3216c2f42:1;
  unsigned int s3216c2f43:1;
  unsigned int s3216c2f44:1;
  unsigned int s3216c2f45:1;
  unsigned int s3216c2f46:1;
  unsigned int s3216c2f47:1;
  unsigned int s3216c2f48:1;
  unsigned int s3216c2f49:1;
  unsigned int s3216c2f50:1;
  unsigned int s3216c2f51:1;
  unsigned int s3216c2f52:1;
  unsigned int s3216c2f53:1;
  unsigned int s3216c2f54:1;
  unsigned int s3216c2f55:1;
  unsigned int s3216c2f56:1;
  unsigned int s3216c2f57:1;
  unsigned int s3216c2f58:1;
  unsigned int s3216c2f59:1;
  unsigned int s3216c2f60:1;
  unsigned int s3216c2f61:1;
  unsigned int s3216c2f62:1;
  unsigned int s3216c2f63:1;
  unsigned int s3216c2f64:1;
  unsigned int s3216c2f65:1;
  unsigned int s3216c2f66:1;
  unsigned int s3216c2f67:1;
  unsigned int s3216c2f68:1;
  unsigned int s3216c2f69:1;
  unsigned int s3216c2f70:1;
  unsigned int s3216c2f71:1;
  unsigned int s3216c2f72:1;
  unsigned int s3216c2f73:1;
  unsigned int s3216c2f74:1;
  unsigned int s3216c2f75:1;
  unsigned int s3216c2f76:1;
  unsigned int s3216c2f77:1;
  unsigned int s3216c2f78:1;
  unsigned int s3216c2f79:1;
  unsigned int s3216c2f80:1;
  unsigned int s3216c2f81:1;
  unsigned int s3216c2f82:1;
  unsigned int s3216c2f83:1;
  int s3216c2f84[5];
  void *s3216c2f85[2];
  int s3216c2f86[3];
  ::S3216C4_nt s3216c2f87;
  ::S3216C4_nt s3216c2f88;
  ::S3216C4_nt s3216c2f89;
  ::S3216C11 s3216c2f90;
  ::S3216C11 s3216c2f91;
  int s3216c2f92;
  void *s3216c2f93[2];
  ::S3216C13_nt s3216c2f94;
  ::S3216C13_nt s3216c2f95;
  ::S3216C13_nt s3216c2f96;
  ::S3216C13_nt s3216c2f97;
  void *s3216c2f98;
  ::S3216C4_nt s3216c2f99;
  ::S3216C11 s3216c2f100;
  ::S3216C13_nt s3216c2f101;
  ::S3216C13_nt s3216c2f102;
  int s3216c2f103;
  ::S3216C13_nt s3216c2f104;
  ::S3216C13_nt s3216c2f105;
  void *s3216c2f106;
  int s3216c2f107;
  char s3216c2f108;
  ::S3216C13_nt s3216c2f109;
  ::S3216C13_nt s3216c2f110;
  void *s3216c2f111;
  int s3216c2f112;
  void *s3216c2f113;
  ::S3216C11 s3216c2f114;
  ::S3216C17 s3216c2f115;
  ::S3216C17 s3216c2f116;
  virtual  ~S3216C2_nt(); // _ZN10S3216C2_ntD1Ev
  virtual void  v68(); // _ZN10S3216C2_nt3v68Ev
  virtual void  v69(); // _ZN10S3216C2_nt3v69Ev
  virtual void  v70(); // _ZN10S3216C2_nt3v70Ev
  virtual void  v71(); // _ZN10S3216C2_nt3v71Ev
  virtual void  v72(); // _ZN10S3216C2_nt3v72Ev
  virtual void  v73(); // _ZN10S3216C2_nt3v73Ev
  virtual void  v74(); // _ZN10S3216C2_nt3v74Ev
  virtual void  v75(); // _ZN10S3216C2_nt3v75Ev
  virtual void  v76(); // _ZN10S3216C2_nt3v76Ev
  virtual void  v77(); // _ZN10S3216C2_nt3v77Ev
  virtual void  v78(); // _ZN10S3216C2_nt3v78Ev
  virtual void  v79(); // _ZN10S3216C2_nt3v79Ev
  virtual void  v80(); // _ZN10S3216C2_nt3v80Ev
  virtual void  v81(); // _ZN10S3216C2_nt3v81Ev
  virtual void  v82(); // _ZN10S3216C2_nt3v82Ev
  virtual void  v83(); // _ZN10S3216C2_nt3v83Ev
  virtual void  v84(); // _ZN10S3216C2_nt3v84Ev
  virtual void  v85(); // _ZN10S3216C2_nt3v85Ev
  virtual void  v86(); // _ZN10S3216C2_nt3v86Ev
  virtual void  v87(); // _ZN10S3216C2_nt3v87Ev
  virtual void  v88(); // _ZN10S3216C2_nt3v88Ev
  virtual void  v89(); // _ZN10S3216C2_nt3v89Ev
  virtual void  v90(); // _ZN10S3216C2_nt3v90Ev
  virtual void  v91(); // _ZN10S3216C2_nt3v91Ev
  virtual void  v92(); // _ZN10S3216C2_nt3v92Ev
  virtual void  v93(); // _ZN10S3216C2_nt3v93Ev
  virtual void  v94(); // _ZN10S3216C2_nt3v94Ev
  virtual void  v95(); // _ZN10S3216C2_nt3v95Ev
  virtual void  v96(); // _ZN10S3216C2_nt3v96Ev
  virtual void  v97(); // _ZN10S3216C2_nt3v97Ev
  virtual void  v98(); // _ZN10S3216C2_nt3v98Ev
  virtual void  v99(); // _ZN10S3216C2_nt3v99Ev
  virtual void  v100(); // _ZN10S3216C2_nt4v100Ev
  virtual void  v101(); // _ZN10S3216C2_nt4v101Ev
  virtual void  v102(); // _ZN10S3216C2_nt4v102Ev
  virtual void  v103(); // _ZN10S3216C2_nt4v103Ev
  virtual void  v104(); // _ZN10S3216C2_nt4v104Ev
  virtual void  v105(); // _ZN10S3216C2_nt4v105Ev
  virtual void  v106(); // _ZN10S3216C2_nt4v106Ev
  virtual void  v107(); // _ZN10S3216C2_nt4v107Ev
  virtual void  v108(); // _ZN10S3216C2_nt4v108Ev
  virtual void  v109(); // _ZN10S3216C2_nt4v109Ev
  virtual void  v110(); // _ZN10S3216C2_nt4v110Ev
  virtual void  v111(); // _ZN10S3216C2_nt4v111Ev
  virtual void  v112(); // _ZN10S3216C2_nt4v112Ev
  virtual void  v113(); // _ZN10S3216C2_nt4v113Ev
  virtual void  v114(); // _ZN10S3216C2_nt4v114Ev
  virtual void  v115(); // _ZN10S3216C2_nt4v115Ev
  virtual void  v116(); // _ZN10S3216C2_nt4v116Ev
  virtual void  v117(); // _ZN10S3216C2_nt4v117Ev
  virtual void  v118(); // _ZN10S3216C2_nt4v118Ev
  virtual void  v119(); // _ZN10S3216C2_nt4v119Ev
  virtual void  v120(); // _ZN10S3216C2_nt4v120Ev
  virtual void  v121(); // _ZN10S3216C2_nt4v121Ev
  virtual void  v122(); // _ZN10S3216C2_nt4v122Ev
  virtual void  v123(); // _ZN10S3216C2_nt4v123Ev
  virtual void  v124(); // _ZN10S3216C2_nt4v124Ev
  virtual void  v125(); // _ZN10S3216C2_nt4v125Ev
  virtual void  v126(); // _ZN10S3216C2_nt4v126Ev
  virtual void  v127(); // _ZN10S3216C2_nt4v127Ev
  virtual void  v128(); // _ZN10S3216C2_nt4v128Ev
  virtual void  v129(); // _ZN10S3216C2_nt4v129Ev
  virtual void  v130(); // _ZN10S3216C2_nt4v130Ev
  virtual void  v131(); // _ZN10S3216C2_nt4v131Ev
  virtual void  v132(); // _ZN10S3216C2_nt4v132Ev
  virtual void  v133(); // _ZN10S3216C2_nt4v133Ev
  virtual void  v134(); // _ZN10S3216C2_nt4v134Ev
  virtual void  v135(); // _ZN10S3216C2_nt4v135Ev
  virtual void  v136(); // _ZN10S3216C2_nt4v136Ev
  virtual void  v137(); // _ZN10S3216C2_nt4v137Ev
  virtual void  v138(); // _ZN10S3216C2_nt4v138Ev
  virtual void  v139(); // _ZN10S3216C2_nt4v139Ev
  virtual void  v140(); // _ZN10S3216C2_nt4v140Ev
  virtual void  v141(); // _ZN10S3216C2_nt4v141Ev
  virtual void  v142(); // _ZN10S3216C2_nt4v142Ev
  virtual void  v143(); // _ZN10S3216C2_nt4v143Ev
  virtual void  v144(); // _ZN10S3216C2_nt4v144Ev
  virtual void  v145(); // _ZN10S3216C2_nt4v145Ev
  virtual void  v146(); // _ZN10S3216C2_nt4v146Ev
  virtual void  v147(); // _ZN10S3216C2_nt4v147Ev
  virtual void  v148(); // _ZN10S3216C2_nt4v148Ev
  virtual void  v149(); // _ZN10S3216C2_nt4v149Ev
  virtual void  v150(); // _ZN10S3216C2_nt4v150Ev
  virtual void  v151(); // _ZN10S3216C2_nt4v151Ev
  virtual void  v152(); // _ZN10S3216C2_nt4v152Ev
  virtual void  v153(); // _ZN10S3216C2_nt4v153Ev
  virtual void  v154(); // _ZN10S3216C2_nt4v154Ev
  virtual void  v155(); // _ZN10S3216C2_nt4v155Ev
  virtual void  v156(); // _ZN10S3216C2_nt4v156Ev
  virtual void  v157(); // _ZN10S3216C2_nt4v157Ev
  virtual void  v158(); // _ZN10S3216C2_nt4v158Ev
  virtual void  v159(); // _ZN10S3216C2_nt4v159Ev
  virtual void  v160(); // _ZN10S3216C2_nt4v160Ev
  virtual void  v161(); // _ZN10S3216C2_nt4v161Ev
  virtual void  v162(); // _ZN10S3216C2_nt4v162Ev
  virtual void  v163(); // _ZN10S3216C2_nt4v163Ev
  virtual void  v164(); // _ZN10S3216C2_nt4v164Ev
  virtual void  v165(); // _ZN10S3216C2_nt4v165Ev
  virtual void  v166(); // _ZN10S3216C2_nt4v166Ev
  virtual void  v167(); // _ZN10S3216C2_nt4v167Ev
  virtual void  v168(); // _ZN10S3216C2_nt4v168Ev
  virtual void  v169(); // _ZN10S3216C2_nt4v169Ev
  virtual void  v170(); // _ZN10S3216C2_nt4v170Ev
  virtual void  v171(); // _ZN10S3216C2_nt4v171Ev
  virtual void  v172(); // _ZN10S3216C2_nt4v172Ev
  virtual void  v173(); // _ZN10S3216C2_nt4v173Ev
  virtual void  v174(); // _ZN10S3216C2_nt4v174Ev
  virtual void  v175(); // _ZN10S3216C2_nt4v175Ev
  virtual void  v176(); // _ZN10S3216C2_nt4v176Ev
  virtual void  v177(); // _ZN10S3216C2_nt4v177Ev
  virtual void  v178(); // _ZN10S3216C2_nt4v178Ev
  virtual void  v179(); // _ZN10S3216C2_nt4v179Ev
  virtual void  v180(); // _ZN10S3216C2_nt4v180Ev
  virtual void  v181(); // _ZN10S3216C2_nt4v181Ev
  virtual void  v182(); // _ZN10S3216C2_nt4v182Ev
  virtual void  v183(); // _ZN10S3216C2_nt4v183Ev
  virtual void  v184(); // _ZN10S3216C2_nt4v184Ev
  virtual void  v185(); // _ZN10S3216C2_nt4v185Ev
  virtual void  v186(); // _ZN10S3216C2_nt4v186Ev
  virtual void  v187(); // _ZN10S3216C2_nt4v187Ev
  virtual void  v188(); // _ZN10S3216C2_nt4v188Ev
  virtual void  v189(); // _ZN10S3216C2_nt4v189Ev
  virtual void  v190(); // _ZN10S3216C2_nt4v190Ev
  virtual void  v191(); // _ZN10S3216C2_nt4v191Ev
  virtual void  v192(); // _ZN10S3216C2_nt4v192Ev
  virtual void  v193(); // _ZN10S3216C2_nt4v193Ev
  virtual void  v194(); // _ZN10S3216C2_nt4v194Ev
  virtual void  v195(); // _ZN10S3216C2_nt4v195Ev
  virtual void  v196(); // _ZN10S3216C2_nt4v196Ev
  virtual void  v197(); // _ZN10S3216C2_nt4v197Ev
  virtual void  v198(); // _ZN10S3216C2_nt4v198Ev
  virtual void  v199(); // _ZN10S3216C2_nt4v199Ev
  virtual void  v200(); // _ZN10S3216C2_nt4v200Ev
  virtual void  v201(); // _ZN10S3216C2_nt4v201Ev
  virtual void  v202(); // _ZN10S3216C2_nt4v202Ev
  virtual void  v203(); // _ZN10S3216C2_nt4v203Ev
  virtual void  v204(); // _ZN10S3216C2_nt4v204Ev
  virtual void  v205(); // _ZN10S3216C2_nt4v205Ev
  virtual void  v206(); // _ZN10S3216C2_nt4v206Ev
  virtual void  v207(); // _ZN10S3216C2_nt4v207Ev
  virtual void  v208(); // _ZN10S3216C2_nt4v208Ev
  virtual void  v209(); // _ZN10S3216C2_nt4v209Ev
  virtual void  v210(); // _ZN10S3216C2_nt4v210Ev
  S3216C2_nt(); // tgen
};
//SIG(-1 S3216C2_nt) C1{ BC2{ vd v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC4 FC7{ m Fi} Fi Fc[4] Fp[2] FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC3 FC3 FC3 FC8{ BC9{ BC6}} FC8 Fi Fp[2] FC10{ m Fi[3]} FC10 FC10 FC10 Fp FC3 FC8 FC10 FC10 Fi FC10 FC10 Fp Fi Fc FC10 FC10 Fp Fi Fp FC8 FC11{ BC12{ BC6}} FC11}


 S3216C2_nt ::~S3216C2_nt(){ note_dtor("S3216C2_nt", this);}
void  S3216C2_nt ::v68(){vfunc_called(this, "_ZN10S3216C2_nt3v68Ev");}
void  S3216C2_nt ::v69(){vfunc_called(this, "_ZN10S3216C2_nt3v69Ev");}
void  S3216C2_nt ::v70(){vfunc_called(this, "_ZN10S3216C2_nt3v70Ev");}
void  S3216C2_nt ::v71(){vfunc_called(this, "_ZN10S3216C2_nt3v71Ev");}
void  S3216C2_nt ::v72(){vfunc_called(this, "_ZN10S3216C2_nt3v72Ev");}
void  S3216C2_nt ::v73(){vfunc_called(this, "_ZN10S3216C2_nt3v73Ev");}
void  S3216C2_nt ::v74(){vfunc_called(this, "_ZN10S3216C2_nt3v74Ev");}
void  S3216C2_nt ::v75(){vfunc_called(this, "_ZN10S3216C2_nt3v75Ev");}
void  S3216C2_nt ::v76(){vfunc_called(this, "_ZN10S3216C2_nt3v76Ev");}
void  S3216C2_nt ::v77(){vfunc_called(this, "_ZN10S3216C2_nt3v77Ev");}
void  S3216C2_nt ::v78(){vfunc_called(this, "_ZN10S3216C2_nt3v78Ev");}
void  S3216C2_nt ::v79(){vfunc_called(this, "_ZN10S3216C2_nt3v79Ev");}
void  S3216C2_nt ::v80(){vfunc_called(this, "_ZN10S3216C2_nt3v80Ev");}
void  S3216C2_nt ::v81(){vfunc_called(this, "_ZN10S3216C2_nt3v81Ev");}
void  S3216C2_nt ::v82(){vfunc_called(this, "_ZN10S3216C2_nt3v82Ev");}
void  S3216C2_nt ::v83(){vfunc_called(this, "_ZN10S3216C2_nt3v83Ev");}
void  S3216C2_nt ::v84(){vfunc_called(this, "_ZN10S3216C2_nt3v84Ev");}
void  S3216C2_nt ::v85(){vfunc_called(this, "_ZN10S3216C2_nt3v85Ev");}
void  S3216C2_nt ::v86(){vfunc_called(this, "_ZN10S3216C2_nt3v86Ev");}
void  S3216C2_nt ::v87(){vfunc_called(this, "_ZN10S3216C2_nt3v87Ev");}
void  S3216C2_nt ::v88(){vfunc_called(this, "_ZN10S3216C2_nt3v88Ev");}
void  S3216C2_nt ::v89(){vfunc_called(this, "_ZN10S3216C2_nt3v89Ev");}
void  S3216C2_nt ::v90(){vfunc_called(this, "_ZN10S3216C2_nt3v90Ev");}
void  S3216C2_nt ::v91(){vfunc_called(this, "_ZN10S3216C2_nt3v91Ev");}
void  S3216C2_nt ::v92(){vfunc_called(this, "_ZN10S3216C2_nt3v92Ev");}
void  S3216C2_nt ::v93(){vfunc_called(this, "_ZN10S3216C2_nt3v93Ev");}
void  S3216C2_nt ::v94(){vfunc_called(this, "_ZN10S3216C2_nt3v94Ev");}
void  S3216C2_nt ::v95(){vfunc_called(this, "_ZN10S3216C2_nt3v95Ev");}
void  S3216C2_nt ::v96(){vfunc_called(this, "_ZN10S3216C2_nt3v96Ev");}
void  S3216C2_nt ::v97(){vfunc_called(this, "_ZN10S3216C2_nt3v97Ev");}
void  S3216C2_nt ::v98(){vfunc_called(this, "_ZN10S3216C2_nt3v98Ev");}
void  S3216C2_nt ::v99(){vfunc_called(this, "_ZN10S3216C2_nt3v99Ev");}
void  S3216C2_nt ::v100(){vfunc_called(this, "_ZN10S3216C2_nt4v100Ev");}
void  S3216C2_nt ::v101(){vfunc_called(this, "_ZN10S3216C2_nt4v101Ev");}
void  S3216C2_nt ::v102(){vfunc_called(this, "_ZN10S3216C2_nt4v102Ev");}
void  S3216C2_nt ::v103(){vfunc_called(this, "_ZN10S3216C2_nt4v103Ev");}
void  S3216C2_nt ::v104(){vfunc_called(this, "_ZN10S3216C2_nt4v104Ev");}
void  S3216C2_nt ::v105(){vfunc_called(this, "_ZN10S3216C2_nt4v105Ev");}
void  S3216C2_nt ::v106(){vfunc_called(this, "_ZN10S3216C2_nt4v106Ev");}
void  S3216C2_nt ::v107(){vfunc_called(this, "_ZN10S3216C2_nt4v107Ev");}
void  S3216C2_nt ::v108(){vfunc_called(this, "_ZN10S3216C2_nt4v108Ev");}
void  S3216C2_nt ::v109(){vfunc_called(this, "_ZN10S3216C2_nt4v109Ev");}
void  S3216C2_nt ::v110(){vfunc_called(this, "_ZN10S3216C2_nt4v110Ev");}
void  S3216C2_nt ::v111(){vfunc_called(this, "_ZN10S3216C2_nt4v111Ev");}
void  S3216C2_nt ::v112(){vfunc_called(this, "_ZN10S3216C2_nt4v112Ev");}
void  S3216C2_nt ::v113(){vfunc_called(this, "_ZN10S3216C2_nt4v113Ev");}
void  S3216C2_nt ::v114(){vfunc_called(this, "_ZN10S3216C2_nt4v114Ev");}
void  S3216C2_nt ::v115(){vfunc_called(this, "_ZN10S3216C2_nt4v115Ev");}
void  S3216C2_nt ::v116(){vfunc_called(this, "_ZN10S3216C2_nt4v116Ev");}
void  S3216C2_nt ::v117(){vfunc_called(this, "_ZN10S3216C2_nt4v117Ev");}
void  S3216C2_nt ::v118(){vfunc_called(this, "_ZN10S3216C2_nt4v118Ev");}
void  S3216C2_nt ::v119(){vfunc_called(this, "_ZN10S3216C2_nt4v119Ev");}
void  S3216C2_nt ::v120(){vfunc_called(this, "_ZN10S3216C2_nt4v120Ev");}
void  S3216C2_nt ::v121(){vfunc_called(this, "_ZN10S3216C2_nt4v121Ev");}
void  S3216C2_nt ::v122(){vfunc_called(this, "_ZN10S3216C2_nt4v122Ev");}
void  S3216C2_nt ::v123(){vfunc_called(this, "_ZN10S3216C2_nt4v123Ev");}
void  S3216C2_nt ::v124(){vfunc_called(this, "_ZN10S3216C2_nt4v124Ev");}
void  S3216C2_nt ::v125(){vfunc_called(this, "_ZN10S3216C2_nt4v125Ev");}
void  S3216C2_nt ::v126(){vfunc_called(this, "_ZN10S3216C2_nt4v126Ev");}
void  S3216C2_nt ::v127(){vfunc_called(this, "_ZN10S3216C2_nt4v127Ev");}
void  S3216C2_nt ::v128(){vfunc_called(this, "_ZN10S3216C2_nt4v128Ev");}
void  S3216C2_nt ::v129(){vfunc_called(this, "_ZN10S3216C2_nt4v129Ev");}
void  S3216C2_nt ::v130(){vfunc_called(this, "_ZN10S3216C2_nt4v130Ev");}
void  S3216C2_nt ::v131(){vfunc_called(this, "_ZN10S3216C2_nt4v131Ev");}
void  S3216C2_nt ::v132(){vfunc_called(this, "_ZN10S3216C2_nt4v132Ev");}
void  S3216C2_nt ::v133(){vfunc_called(this, "_ZN10S3216C2_nt4v133Ev");}
void  S3216C2_nt ::v134(){vfunc_called(this, "_ZN10S3216C2_nt4v134Ev");}
void  S3216C2_nt ::v135(){vfunc_called(this, "_ZN10S3216C2_nt4v135Ev");}
void  S3216C2_nt ::v136(){vfunc_called(this, "_ZN10S3216C2_nt4v136Ev");}
void  S3216C2_nt ::v137(){vfunc_called(this, "_ZN10S3216C2_nt4v137Ev");}
void  S3216C2_nt ::v138(){vfunc_called(this, "_ZN10S3216C2_nt4v138Ev");}
void  S3216C2_nt ::v139(){vfunc_called(this, "_ZN10S3216C2_nt4v139Ev");}
void  S3216C2_nt ::v140(){vfunc_called(this, "_ZN10S3216C2_nt4v140Ev");}
void  S3216C2_nt ::v141(){vfunc_called(this, "_ZN10S3216C2_nt4v141Ev");}
void  S3216C2_nt ::v142(){vfunc_called(this, "_ZN10S3216C2_nt4v142Ev");}
void  S3216C2_nt ::v143(){vfunc_called(this, "_ZN10S3216C2_nt4v143Ev");}
void  S3216C2_nt ::v144(){vfunc_called(this, "_ZN10S3216C2_nt4v144Ev");}
void  S3216C2_nt ::v145(){vfunc_called(this, "_ZN10S3216C2_nt4v145Ev");}
void  S3216C2_nt ::v146(){vfunc_called(this, "_ZN10S3216C2_nt4v146Ev");}
void  S3216C2_nt ::v147(){vfunc_called(this, "_ZN10S3216C2_nt4v147Ev");}
void  S3216C2_nt ::v148(){vfunc_called(this, "_ZN10S3216C2_nt4v148Ev");}
void  S3216C2_nt ::v149(){vfunc_called(this, "_ZN10S3216C2_nt4v149Ev");}
void  S3216C2_nt ::v150(){vfunc_called(this, "_ZN10S3216C2_nt4v150Ev");}
void  S3216C2_nt ::v151(){vfunc_called(this, "_ZN10S3216C2_nt4v151Ev");}
void  S3216C2_nt ::v152(){vfunc_called(this, "_ZN10S3216C2_nt4v152Ev");}
void  S3216C2_nt ::v153(){vfunc_called(this, "_ZN10S3216C2_nt4v153Ev");}
void  S3216C2_nt ::v154(){vfunc_called(this, "_ZN10S3216C2_nt4v154Ev");}
void  S3216C2_nt ::v155(){vfunc_called(this, "_ZN10S3216C2_nt4v155Ev");}
void  S3216C2_nt ::v156(){vfunc_called(this, "_ZN10S3216C2_nt4v156Ev");}
void  S3216C2_nt ::v157(){vfunc_called(this, "_ZN10S3216C2_nt4v157Ev");}
void  S3216C2_nt ::v158(){vfunc_called(this, "_ZN10S3216C2_nt4v158Ev");}
void  S3216C2_nt ::v159(){vfunc_called(this, "_ZN10S3216C2_nt4v159Ev");}
void  S3216C2_nt ::v160(){vfunc_called(this, "_ZN10S3216C2_nt4v160Ev");}
void  S3216C2_nt ::v161(){vfunc_called(this, "_ZN10S3216C2_nt4v161Ev");}
void  S3216C2_nt ::v162(){vfunc_called(this, "_ZN10S3216C2_nt4v162Ev");}
void  S3216C2_nt ::v163(){vfunc_called(this, "_ZN10S3216C2_nt4v163Ev");}
void  S3216C2_nt ::v164(){vfunc_called(this, "_ZN10S3216C2_nt4v164Ev");}
void  S3216C2_nt ::v165(){vfunc_called(this, "_ZN10S3216C2_nt4v165Ev");}
void  S3216C2_nt ::v166(){vfunc_called(this, "_ZN10S3216C2_nt4v166Ev");}
void  S3216C2_nt ::v167(){vfunc_called(this, "_ZN10S3216C2_nt4v167Ev");}
void  S3216C2_nt ::v168(){vfunc_called(this, "_ZN10S3216C2_nt4v168Ev");}
void  S3216C2_nt ::v169(){vfunc_called(this, "_ZN10S3216C2_nt4v169Ev");}
void  S3216C2_nt ::v170(){vfunc_called(this, "_ZN10S3216C2_nt4v170Ev");}
void  S3216C2_nt ::v171(){vfunc_called(this, "_ZN10S3216C2_nt4v171Ev");}
void  S3216C2_nt ::v172(){vfunc_called(this, "_ZN10S3216C2_nt4v172Ev");}
void  S3216C2_nt ::v173(){vfunc_called(this, "_ZN10S3216C2_nt4v173Ev");}
void  S3216C2_nt ::v174(){vfunc_called(this, "_ZN10S3216C2_nt4v174Ev");}
void  S3216C2_nt ::v175(){vfunc_called(this, "_ZN10S3216C2_nt4v175Ev");}
void  S3216C2_nt ::v176(){vfunc_called(this, "_ZN10S3216C2_nt4v176Ev");}
void  S3216C2_nt ::v177(){vfunc_called(this, "_ZN10S3216C2_nt4v177Ev");}
void  S3216C2_nt ::v178(){vfunc_called(this, "_ZN10S3216C2_nt4v178Ev");}
void  S3216C2_nt ::v179(){vfunc_called(this, "_ZN10S3216C2_nt4v179Ev");}
void  S3216C2_nt ::v180(){vfunc_called(this, "_ZN10S3216C2_nt4v180Ev");}
void  S3216C2_nt ::v181(){vfunc_called(this, "_ZN10S3216C2_nt4v181Ev");}
void  S3216C2_nt ::v182(){vfunc_called(this, "_ZN10S3216C2_nt4v182Ev");}
void  S3216C2_nt ::v183(){vfunc_called(this, "_ZN10S3216C2_nt4v183Ev");}
void  S3216C2_nt ::v184(){vfunc_called(this, "_ZN10S3216C2_nt4v184Ev");}
void  S3216C2_nt ::v185(){vfunc_called(this, "_ZN10S3216C2_nt4v185Ev");}
void  S3216C2_nt ::v186(){vfunc_called(this, "_ZN10S3216C2_nt4v186Ev");}
void  S3216C2_nt ::v187(){vfunc_called(this, "_ZN10S3216C2_nt4v187Ev");}
void  S3216C2_nt ::v188(){vfunc_called(this, "_ZN10S3216C2_nt4v188Ev");}
void  S3216C2_nt ::v189(){vfunc_called(this, "_ZN10S3216C2_nt4v189Ev");}
void  S3216C2_nt ::v190(){vfunc_called(this, "_ZN10S3216C2_nt4v190Ev");}
void  S3216C2_nt ::v191(){vfunc_called(this, "_ZN10S3216C2_nt4v191Ev");}
void  S3216C2_nt ::v192(){vfunc_called(this, "_ZN10S3216C2_nt4v192Ev");}
void  S3216C2_nt ::v193(){vfunc_called(this, "_ZN10S3216C2_nt4v193Ev");}
void  S3216C2_nt ::v194(){vfunc_called(this, "_ZN10S3216C2_nt4v194Ev");}
void  S3216C2_nt ::v195(){vfunc_called(this, "_ZN10S3216C2_nt4v195Ev");}
void  S3216C2_nt ::v196(){vfunc_called(this, "_ZN10S3216C2_nt4v196Ev");}
void  S3216C2_nt ::v197(){vfunc_called(this, "_ZN10S3216C2_nt4v197Ev");}
void  S3216C2_nt ::v198(){vfunc_called(this, "_ZN10S3216C2_nt4v198Ev");}
void  S3216C2_nt ::v199(){vfunc_called(this, "_ZN10S3216C2_nt4v199Ev");}
void  S3216C2_nt ::v200(){vfunc_called(this, "_ZN10S3216C2_nt4v200Ev");}
void  S3216C2_nt ::v201(){vfunc_called(this, "_ZN10S3216C2_nt4v201Ev");}
void  S3216C2_nt ::v202(){vfunc_called(this, "_ZN10S3216C2_nt4v202Ev");}
void  S3216C2_nt ::v203(){vfunc_called(this, "_ZN10S3216C2_nt4v203Ev");}
void  S3216C2_nt ::v204(){vfunc_called(this, "_ZN10S3216C2_nt4v204Ev");}
void  S3216C2_nt ::v205(){vfunc_called(this, "_ZN10S3216C2_nt4v205Ev");}
void  S3216C2_nt ::v206(){vfunc_called(this, "_ZN10S3216C2_nt4v206Ev");}
void  S3216C2_nt ::v207(){vfunc_called(this, "_ZN10S3216C2_nt4v207Ev");}
void  S3216C2_nt ::v208(){vfunc_called(this, "_ZN10S3216C2_nt4v208Ev");}
void  S3216C2_nt ::v209(){vfunc_called(this, "_ZN10S3216C2_nt4v209Ev");}
void  S3216C2_nt ::v210(){vfunc_called(this, "_ZN10S3216C2_nt4v210Ev");}
S3216C2_nt ::S3216C2_nt(){ note_ctor("S3216C2_nt", this);} // tgen

//skip512 S3216C2_nt

#else // __cplusplus

extern void _ZN10S3216C2_ntC1Ev();
extern void _ZN10S3216C2_ntD1Ev();
Name_Map name_map_S3216C2_nt[] = {
  NSPAIR(_ZN10S3216C2_ntC1Ev),
  NSPAIR(_ZN10S3216C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C3_nt;
extern VTBL_ENTRY _ZTI10S3216C3_nt[];
extern  VTBL_ENTRY _ZTV10S3216C3_nt[];
static Base_Class bases_S3216C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S3216C2_nt[];
extern void _ZN10S3216C2_ntD1Ev();
extern void _ZN10S3216C2_ntD0Ev();
extern void _ZN10S3216C3_nt2v4Ev();
extern void _ZN10S3216C3_nt2v5Ev();
extern void _ZN10S3216C3_nt2v6Ev();
extern void _ZN10S3216C3_nt2v7Ev();
extern void _ZN10S3216C3_nt2v8Ev();
extern void _ZN10S3216C3_nt2v9Ev();
extern void _ZN10S3216C3_nt3v10Ev();
extern void _ZN10S3216C3_nt3v11Ev();
extern void _ZN10S3216C3_nt3v12Ev();
extern void _ZN10S3216C3_nt3v13Ev();
extern void _ZN10S3216C3_nt3v14Ev();
extern void _ZN10S3216C3_nt3v15Ev();
extern void _ZN10S3216C3_nt3v16Ev();
extern void _ZN10S3216C3_nt3v17Ev();
extern void _ZN10S3216C3_nt3v18Ev();
extern void _ZN10S3216C3_nt3v19Ev();
extern void _ZN10S3216C3_nt3v20Ev();
extern void _ZN10S3216C3_nt3v21Ev();
extern void _ZN10S3216C3_nt3v22Ev();
extern void _ZN10S3216C3_nt3v23Ev();
extern void _ZN10S3216C3_nt3v24Ev();
extern void _ZN10S3216C3_nt3v25Ev();
extern void _ZN10S3216C3_nt3v26Ev();
extern void _ZN10S3216C3_nt3v27Ev();
extern void _ZN10S3216C3_nt3v28Ev();
extern void _ZN10S3216C3_nt3v29Ev();
extern void _ZN10S3216C3_nt3v30Ev();
extern void _ZN10S3216C3_nt3v31Ev();
extern void _ZN10S3216C3_nt3v32Ev();
extern void _ZN10S3216C3_nt3v33Ev();
extern void _ZN10S3216C3_nt3v34Ev();
extern void _ZN10S3216C3_nt3v35Ev();
extern void _ZN10S3216C3_nt3v36Ev();
extern void _ZN10S3216C3_nt3v37Ev();
extern void _ZN10S3216C3_nt3v38Ev();
extern void _ZN10S3216C3_nt3v39Ev();
extern void _ZN10S3216C3_nt3v40Ev();
extern void _ZN10S3216C3_nt3v41Ev();
extern void _ZN10S3216C3_nt3v42Ev();
extern void _ZN10S3216C3_nt3v43Ev();
extern void _ZN10S3216C3_nt3v44Ev();
extern void _ZN10S3216C3_nt3v45Ev();
extern void _ZN10S3216C3_nt3v46Ev();
extern void _ZN10S3216C3_nt3v47Ev();
extern void _ZN10S3216C3_nt3v48Ev();
extern void _ZN10S3216C3_nt3v49Ev();
extern void _ZN10S3216C3_nt3v50Ev();
extern void _ZN10S3216C3_nt3v51Ev();
extern void _ZN10S3216C3_nt3v52Ev();
extern void _ZN10S3216C3_nt3v53Ev();
extern void _ZN10S3216C3_nt3v54Ev();
extern void _ZN10S3216C3_nt3v55Ev();
extern void _ZN10S3216C3_nt3v56Ev();
extern void _ZN10S3216C3_nt3v57Ev();
extern void _ZN10S3216C3_nt3v58Ev();
extern void _ZN10S3216C3_nt3v59Ev();
extern void _ZN10S3216C3_nt3v60Ev();
extern void _ZN10S3216C3_nt3v61Ev();
extern void _ZN10S3216C3_nt3v62Ev();
extern void _ZN10S3216C3_nt3v63Ev();
extern void _ZN10S3216C3_nt3v64Ev();
extern void _ZN10S3216C3_nt3v65Ev();
extern void _ZN10S3216C3_nt3v66Ev();
extern void _ZN10S3216C3_nt3v67Ev();
extern void _ZN10S3216C2_nt3v68Ev();
extern void _ZN10S3216C2_nt3v69Ev();
extern void _ZN10S3216C2_nt3v70Ev();
extern void _ZN10S3216C2_nt3v71Ev();
extern void _ZN10S3216C2_nt3v72Ev();
extern void _ZN10S3216C2_nt3v73Ev();
extern void _ZN10S3216C2_nt3v74Ev();
extern void _ZN10S3216C2_nt3v75Ev();
extern void _ZN10S3216C2_nt3v76Ev();
extern void _ZN10S3216C2_nt3v77Ev();
extern void _ZN10S3216C2_nt3v78Ev();
extern void _ZN10S3216C2_nt3v79Ev();
extern void _ZN10S3216C2_nt3v80Ev();
extern void _ZN10S3216C2_nt3v81Ev();
extern void _ZN10S3216C2_nt3v82Ev();
extern void _ZN10S3216C2_nt3v83Ev();
extern void _ZN10S3216C2_nt3v84Ev();
extern void _ZN10S3216C2_nt3v85Ev();
extern void _ZN10S3216C2_nt3v86Ev();
extern void _ZN10S3216C2_nt3v87Ev();
extern void _ZN10S3216C2_nt3v88Ev();
extern void _ZN10S3216C2_nt3v89Ev();
extern void _ZN10S3216C2_nt3v90Ev();
extern void _ZN10S3216C2_nt3v91Ev();
extern void _ZN10S3216C2_nt3v92Ev();
extern void _ZN10S3216C2_nt3v93Ev();
extern void _ZN10S3216C2_nt3v94Ev();
extern void _ZN10S3216C2_nt3v95Ev();
extern void _ZN10S3216C2_nt3v96Ev();
extern void _ZN10S3216C2_nt3v97Ev();
extern void _ZN10S3216C2_nt3v98Ev();
extern void _ZN10S3216C2_nt3v99Ev();
extern void _ZN10S3216C2_nt4v100Ev();
extern void _ZN10S3216C2_nt4v101Ev();
extern void _ZN10S3216C2_nt4v102Ev();
extern void _ZN10S3216C2_nt4v103Ev();
extern void _ZN10S3216C2_nt4v104Ev();
extern void _ZN10S3216C2_nt4v105Ev();
extern void _ZN10S3216C2_nt4v106Ev();
extern void _ZN10S3216C2_nt4v107Ev();
extern void _ZN10S3216C2_nt4v108Ev();
extern void _ZN10S3216C2_nt4v109Ev();
extern void _ZN10S3216C2_nt4v110Ev();
extern void _ZN10S3216C2_nt4v111Ev();
extern void _ZN10S3216C2_nt4v112Ev();
extern void _ZN10S3216C2_nt4v113Ev();
extern void _ZN10S3216C2_nt4v114Ev();
extern void _ZN10S3216C2_nt4v115Ev();
extern void _ZN10S3216C2_nt4v116Ev();
extern void _ZN10S3216C2_nt4v117Ev();
extern void _ZN10S3216C2_nt4v118Ev();
extern void _ZN10S3216C2_nt4v119Ev();
extern void _ZN10S3216C2_nt4v120Ev();
extern void _ZN10S3216C2_nt4v121Ev();
extern void _ZN10S3216C2_nt4v122Ev();
extern void _ZN10S3216C2_nt4v123Ev();
extern void _ZN10S3216C2_nt4v124Ev();
extern void _ZN10S3216C2_nt4v125Ev();
extern void _ZN10S3216C2_nt4v126Ev();
extern void _ZN10S3216C2_nt4v127Ev();
extern void _ZN10S3216C2_nt4v128Ev();
extern void _ZN10S3216C2_nt4v129Ev();
extern void _ZN10S3216C2_nt4v130Ev();
extern void _ZN10S3216C2_nt4v131Ev();
extern void _ZN10S3216C2_nt4v132Ev();
extern void _ZN10S3216C2_nt4v133Ev();
extern void _ZN10S3216C2_nt4v134Ev();
extern void _ZN10S3216C2_nt4v135Ev();
extern void _ZN10S3216C2_nt4v136Ev();
extern void _ZN10S3216C2_nt4v137Ev();
extern void _ZN10S3216C2_nt4v138Ev();
extern void _ZN10S3216C2_nt4v139Ev();
extern void _ZN10S3216C2_nt4v140Ev();
extern void _ZN10S3216C2_nt4v141Ev();
extern void _ZN10S3216C2_nt4v142Ev();
extern void _ZN10S3216C2_nt4v143Ev();
extern void _ZN10S3216C2_nt4v144Ev();
extern void _ZN10S3216C2_nt4v145Ev();
extern void _ZN10S3216C2_nt4v146Ev();
extern void _ZN10S3216C2_nt4v147Ev();
extern void _ZN10S3216C2_nt4v148Ev();
extern void _ZN10S3216C2_nt4v149Ev();
extern void _ZN10S3216C2_nt4v150Ev();
extern void _ZN10S3216C2_nt4v151Ev();
extern void _ZN10S3216C2_nt4v152Ev();
extern void _ZN10S3216C2_nt4v153Ev();
extern void _ZN10S3216C2_nt4v154Ev();
extern void _ZN10S3216C2_nt4v155Ev();
extern void _ZN10S3216C2_nt4v156Ev();
extern void _ZN10S3216C2_nt4v157Ev();
extern void _ZN10S3216C2_nt4v158Ev();
extern void _ZN10S3216C2_nt4v159Ev();
extern void _ZN10S3216C2_nt4v160Ev();
extern void _ZN10S3216C2_nt4v161Ev();
extern void _ZN10S3216C2_nt4v162Ev();
extern void _ZN10S3216C2_nt4v163Ev();
extern void _ZN10S3216C2_nt4v164Ev();
extern void _ZN10S3216C2_nt4v165Ev();
extern void _ZN10S3216C2_nt4v166Ev();
extern void _ZN10S3216C2_nt4v167Ev();
extern void _ZN10S3216C2_nt4v168Ev();
extern void _ZN10S3216C2_nt4v169Ev();
extern void _ZN10S3216C2_nt4v170Ev();
extern void _ZN10S3216C2_nt4v171Ev();
extern void _ZN10S3216C2_nt4v172Ev();
extern void _ZN10S3216C2_nt4v173Ev();
extern void _ZN10S3216C2_nt4v174Ev();
extern void _ZN10S3216C2_nt4v175Ev();
extern void _ZN10S3216C2_nt4v176Ev();
extern void _ZN10S3216C2_nt4v177Ev();
extern void _ZN10S3216C2_nt4v178Ev();
extern void _ZN10S3216C2_nt4v179Ev();
extern void _ZN10S3216C2_nt4v180Ev();
extern void _ZN10S3216C2_nt4v181Ev();
extern void _ZN10S3216C2_nt4v182Ev();
extern void _ZN10S3216C2_nt4v183Ev();
extern void _ZN10S3216C2_nt4v184Ev();
extern void _ZN10S3216C2_nt4v185Ev();
extern void _ZN10S3216C2_nt4v186Ev();
extern void _ZN10S3216C2_nt4v187Ev();
extern void _ZN10S3216C2_nt4v188Ev();
extern void _ZN10S3216C2_nt4v189Ev();
extern void _ZN10S3216C2_nt4v190Ev();
extern void _ZN10S3216C2_nt4v191Ev();
extern void _ZN10S3216C2_nt4v192Ev();
extern void _ZN10S3216C2_nt4v193Ev();
extern void _ZN10S3216C2_nt4v194Ev();
extern void _ZN10S3216C2_nt4v195Ev();
extern void _ZN10S3216C2_nt4v196Ev();
extern void _ZN10S3216C2_nt4v197Ev();
extern void _ZN10S3216C2_nt4v198Ev();
extern void _ZN10S3216C2_nt4v199Ev();
extern void _ZN10S3216C2_nt4v200Ev();
extern void _ZN10S3216C2_nt4v201Ev();
extern void _ZN10S3216C2_nt4v202Ev();
extern void _ZN10S3216C2_nt4v203Ev();
extern void _ZN10S3216C2_nt4v204Ev();
extern void _ZN10S3216C2_nt4v205Ev();
extern void _ZN10S3216C2_nt4v206Ev();
extern void _ZN10S3216C2_nt4v207Ev();
extern void _ZN10S3216C2_nt4v208Ev();
extern void _ZN10S3216C2_nt4v209Ev();
extern void _ZN10S3216C2_nt4v210Ev();
static  VTBL_ENTRY vtc_S3216C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S3216C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S3216C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v210Ev,
};
extern VTBL_ENTRY _ZTI10S3216C2_nt[];
VTBL_ENTRY *P__ZTI10S3216C2_nt = _ZTI10S3216C2_nt; 
extern  VTBL_ENTRY _ZTV10S3216C2_nt[];
Class_Descriptor cd_S3216C2_nt = {  "S3216C2_nt", // class name
  bases_S3216C2_nt, 1,
  &(vtc_S3216C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI10S3216C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S3216C2_nt),211, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S3216C1  : S3216C2_nt {
  unsigned int s3216c1f0:1;
  int s3216c1f1;
  virtual  ~S3216C1(); // _ZN7S3216C1D1Ev
  virtual void  v1(); // _ZN7S3216C12v1Ev
  virtual void  v2(); // _ZN7S3216C12v2Ev
  virtual void  v3(); // _ZN7S3216C12v3Ev
  S3216C1(); // tgen
};
//SIG(1 S3216C1) C1{ BC2{ BC3{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 v210 FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC5 FC8{ m Fi} Fi Fc[4] Fp[2] FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC4 FC4 FC4 FC9{ BC10{ BC7}} FC9 Fi Fp[2] FC11{ m Fi[3]} FC11 FC11 FC11 Fp FC4 FC9 FC11 FC11 Fi FC11 FC11 Fp Fi Fc FC11 FC11 Fp Fi Fp FC9 FC12{ BC13{ BC7}} FC12} vd v1 v2 v3 Fi:1 Fi}


 S3216C1 ::~S3216C1(){ note_dtor("S3216C1", this);}
void  S3216C1 ::v1(){vfunc_called(this, "_ZN7S3216C12v1Ev");}
void  S3216C1 ::v2(){vfunc_called(this, "_ZN7S3216C12v2Ev");}
void  S3216C1 ::v3(){vfunc_called(this, "_ZN7S3216C12v3Ev");}
S3216C1 ::S3216C1(){ note_ctor("S3216C1", this);} // tgen

static void Test_S3216C1()
{
  extern Class_Descriptor cd_S3216C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(73,112)];
    init_test(&cd_S3216C1, buf);
    S3216C1 *dp, &lv = *(dp=new (buf) S3216C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(576,444), "sizeof(S3216C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S3216C1)");
    check_base_class_offset(lv, (S3216C3_nt*)(S3216C2_nt*), 0, "S3216C1");
    check_base_class_offset(lv, (S3216C2_nt*), 0, "S3216C1");
    set_bf_and_test(lv, s3216c1f0, ABISELECT(568,436), 0, 1, 1, "S3216C1");
    check_field_offset(lv, s3216c1f1, ABISELECT(572,440), "S3216C1.s3216c1f1");
    test_class_info(&lv, &cd_S3216C1);
    dp->~S3216C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS3216C1(Test_S3216C1, "S3216C1", ABISELECT(576,444));

#else // __cplusplus

extern void _ZN7S3216C1C1Ev();
extern void _ZN7S3216C1D1Ev();
Name_Map name_map_S3216C1[] = {
  NSPAIR(_ZN7S3216C1C1Ev),
  NSPAIR(_ZN7S3216C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C3_nt;
extern VTBL_ENTRY _ZTI10S3216C3_nt[];
extern  VTBL_ENTRY _ZTV10S3216C3_nt[];
extern Class_Descriptor cd_S3216C2_nt;
extern VTBL_ENTRY _ZTI10S3216C2_nt[];
extern  VTBL_ENTRY _ZTV10S3216C2_nt[];
static Base_Class bases_S3216C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S3216C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S3216C1[];
extern void _ZN7S3216C1D1Ev();
extern void _ZN7S3216C1D0Ev();
extern void _ZN10S3216C3_nt2v4Ev();
extern void _ZN10S3216C3_nt2v5Ev();
extern void _ZN10S3216C3_nt2v6Ev();
extern void _ZN10S3216C3_nt2v7Ev();
extern void _ZN10S3216C3_nt2v8Ev();
extern void _ZN10S3216C3_nt2v9Ev();
extern void _ZN10S3216C3_nt3v10Ev();
extern void _ZN10S3216C3_nt3v11Ev();
extern void _ZN10S3216C3_nt3v12Ev();
extern void _ZN10S3216C3_nt3v13Ev();
extern void _ZN10S3216C3_nt3v14Ev();
extern void _ZN10S3216C3_nt3v15Ev();
extern void _ZN10S3216C3_nt3v16Ev();
extern void _ZN10S3216C3_nt3v17Ev();
extern void _ZN10S3216C3_nt3v18Ev();
extern void _ZN10S3216C3_nt3v19Ev();
extern void _ZN10S3216C3_nt3v20Ev();
extern void _ZN10S3216C3_nt3v21Ev();
extern void _ZN10S3216C3_nt3v22Ev();
extern void _ZN10S3216C3_nt3v23Ev();
extern void _ZN10S3216C3_nt3v24Ev();
extern void _ZN10S3216C3_nt3v25Ev();
extern void _ZN10S3216C3_nt3v26Ev();
extern void _ZN10S3216C3_nt3v27Ev();
extern void _ZN10S3216C3_nt3v28Ev();
extern void _ZN10S3216C3_nt3v29Ev();
extern void _ZN10S3216C3_nt3v30Ev();
extern void _ZN10S3216C3_nt3v31Ev();
extern void _ZN10S3216C3_nt3v32Ev();
extern void _ZN10S3216C3_nt3v33Ev();
extern void _ZN10S3216C3_nt3v34Ev();
extern void _ZN10S3216C3_nt3v35Ev();
extern void _ZN10S3216C3_nt3v36Ev();
extern void _ZN10S3216C3_nt3v37Ev();
extern void _ZN10S3216C3_nt3v38Ev();
extern void _ZN10S3216C3_nt3v39Ev();
extern void _ZN10S3216C3_nt3v40Ev();
extern void _ZN10S3216C3_nt3v41Ev();
extern void _ZN10S3216C3_nt3v42Ev();
extern void _ZN10S3216C3_nt3v43Ev();
extern void _ZN10S3216C3_nt3v44Ev();
extern void _ZN10S3216C3_nt3v45Ev();
extern void _ZN10S3216C3_nt3v46Ev();
extern void _ZN10S3216C3_nt3v47Ev();
extern void _ZN10S3216C3_nt3v48Ev();
extern void _ZN10S3216C3_nt3v49Ev();
extern void _ZN10S3216C3_nt3v50Ev();
extern void _ZN10S3216C3_nt3v51Ev();
extern void _ZN10S3216C3_nt3v52Ev();
extern void _ZN10S3216C3_nt3v53Ev();
extern void _ZN10S3216C3_nt3v54Ev();
extern void _ZN10S3216C3_nt3v55Ev();
extern void _ZN10S3216C3_nt3v56Ev();
extern void _ZN10S3216C3_nt3v57Ev();
extern void _ZN10S3216C3_nt3v58Ev();
extern void _ZN10S3216C3_nt3v59Ev();
extern void _ZN10S3216C3_nt3v60Ev();
extern void _ZN10S3216C3_nt3v61Ev();
extern void _ZN10S3216C3_nt3v62Ev();
extern void _ZN10S3216C3_nt3v63Ev();
extern void _ZN10S3216C3_nt3v64Ev();
extern void _ZN10S3216C3_nt3v65Ev();
extern void _ZN10S3216C3_nt3v66Ev();
extern void _ZN10S3216C3_nt3v67Ev();
extern void _ZN10S3216C2_nt3v68Ev();
extern void _ZN10S3216C2_nt3v69Ev();
extern void _ZN10S3216C2_nt3v70Ev();
extern void _ZN10S3216C2_nt3v71Ev();
extern void _ZN10S3216C2_nt3v72Ev();
extern void _ZN10S3216C2_nt3v73Ev();
extern void _ZN10S3216C2_nt3v74Ev();
extern void _ZN10S3216C2_nt3v75Ev();
extern void _ZN10S3216C2_nt3v76Ev();
extern void _ZN10S3216C2_nt3v77Ev();
extern void _ZN10S3216C2_nt3v78Ev();
extern void _ZN10S3216C2_nt3v79Ev();
extern void _ZN10S3216C2_nt3v80Ev();
extern void _ZN10S3216C2_nt3v81Ev();
extern void _ZN10S3216C2_nt3v82Ev();
extern void _ZN10S3216C2_nt3v83Ev();
extern void _ZN10S3216C2_nt3v84Ev();
extern void _ZN10S3216C2_nt3v85Ev();
extern void _ZN10S3216C2_nt3v86Ev();
extern void _ZN10S3216C2_nt3v87Ev();
extern void _ZN10S3216C2_nt3v88Ev();
extern void _ZN10S3216C2_nt3v89Ev();
extern void _ZN10S3216C2_nt3v90Ev();
extern void _ZN10S3216C2_nt3v91Ev();
extern void _ZN10S3216C2_nt3v92Ev();
extern void _ZN10S3216C2_nt3v93Ev();
extern void _ZN10S3216C2_nt3v94Ev();
extern void _ZN10S3216C2_nt3v95Ev();
extern void _ZN10S3216C2_nt3v96Ev();
extern void _ZN10S3216C2_nt3v97Ev();
extern void _ZN10S3216C2_nt3v98Ev();
extern void _ZN10S3216C2_nt3v99Ev();
extern void _ZN10S3216C2_nt4v100Ev();
extern void _ZN10S3216C2_nt4v101Ev();
extern void _ZN10S3216C2_nt4v102Ev();
extern void _ZN10S3216C2_nt4v103Ev();
extern void _ZN10S3216C2_nt4v104Ev();
extern void _ZN10S3216C2_nt4v105Ev();
extern void _ZN10S3216C2_nt4v106Ev();
extern void _ZN10S3216C2_nt4v107Ev();
extern void _ZN10S3216C2_nt4v108Ev();
extern void _ZN10S3216C2_nt4v109Ev();
extern void _ZN10S3216C2_nt4v110Ev();
extern void _ZN10S3216C2_nt4v111Ev();
extern void _ZN10S3216C2_nt4v112Ev();
extern void _ZN10S3216C2_nt4v113Ev();
extern void _ZN10S3216C2_nt4v114Ev();
extern void _ZN10S3216C2_nt4v115Ev();
extern void _ZN10S3216C2_nt4v116Ev();
extern void _ZN10S3216C2_nt4v117Ev();
extern void _ZN10S3216C2_nt4v118Ev();
extern void _ZN10S3216C2_nt4v119Ev();
extern void _ZN10S3216C2_nt4v120Ev();
extern void _ZN10S3216C2_nt4v121Ev();
extern void _ZN10S3216C2_nt4v122Ev();
extern void _ZN10S3216C2_nt4v123Ev();
extern void _ZN10S3216C2_nt4v124Ev();
extern void _ZN10S3216C2_nt4v125Ev();
extern void _ZN10S3216C2_nt4v126Ev();
extern void _ZN10S3216C2_nt4v127Ev();
extern void _ZN10S3216C2_nt4v128Ev();
extern void _ZN10S3216C2_nt4v129Ev();
extern void _ZN10S3216C2_nt4v130Ev();
extern void _ZN10S3216C2_nt4v131Ev();
extern void _ZN10S3216C2_nt4v132Ev();
extern void _ZN10S3216C2_nt4v133Ev();
extern void _ZN10S3216C2_nt4v134Ev();
extern void _ZN10S3216C2_nt4v135Ev();
extern void _ZN10S3216C2_nt4v136Ev();
extern void _ZN10S3216C2_nt4v137Ev();
extern void _ZN10S3216C2_nt4v138Ev();
extern void _ZN10S3216C2_nt4v139Ev();
extern void _ZN10S3216C2_nt4v140Ev();
extern void _ZN10S3216C2_nt4v141Ev();
extern void _ZN10S3216C2_nt4v142Ev();
extern void _ZN10S3216C2_nt4v143Ev();
extern void _ZN10S3216C2_nt4v144Ev();
extern void _ZN10S3216C2_nt4v145Ev();
extern void _ZN10S3216C2_nt4v146Ev();
extern void _ZN10S3216C2_nt4v147Ev();
extern void _ZN10S3216C2_nt4v148Ev();
extern void _ZN10S3216C2_nt4v149Ev();
extern void _ZN10S3216C2_nt4v150Ev();
extern void _ZN10S3216C2_nt4v151Ev();
extern void _ZN10S3216C2_nt4v152Ev();
extern void _ZN10S3216C2_nt4v153Ev();
extern void _ZN10S3216C2_nt4v154Ev();
extern void _ZN10S3216C2_nt4v155Ev();
extern void _ZN10S3216C2_nt4v156Ev();
extern void _ZN10S3216C2_nt4v157Ev();
extern void _ZN10S3216C2_nt4v158Ev();
extern void _ZN10S3216C2_nt4v159Ev();
extern void _ZN10S3216C2_nt4v160Ev();
extern void _ZN10S3216C2_nt4v161Ev();
extern void _ZN10S3216C2_nt4v162Ev();
extern void _ZN10S3216C2_nt4v163Ev();
extern void _ZN10S3216C2_nt4v164Ev();
extern void _ZN10S3216C2_nt4v165Ev();
extern void _ZN10S3216C2_nt4v166Ev();
extern void _ZN10S3216C2_nt4v167Ev();
extern void _ZN10S3216C2_nt4v168Ev();
extern void _ZN10S3216C2_nt4v169Ev();
extern void _ZN10S3216C2_nt4v170Ev();
extern void _ZN10S3216C2_nt4v171Ev();
extern void _ZN10S3216C2_nt4v172Ev();
extern void _ZN10S3216C2_nt4v173Ev();
extern void _ZN10S3216C2_nt4v174Ev();
extern void _ZN10S3216C2_nt4v175Ev();
extern void _ZN10S3216C2_nt4v176Ev();
extern void _ZN10S3216C2_nt4v177Ev();
extern void _ZN10S3216C2_nt4v178Ev();
extern void _ZN10S3216C2_nt4v179Ev();
extern void _ZN10S3216C2_nt4v180Ev();
extern void _ZN10S3216C2_nt4v181Ev();
extern void _ZN10S3216C2_nt4v182Ev();
extern void _ZN10S3216C2_nt4v183Ev();
extern void _ZN10S3216C2_nt4v184Ev();
extern void _ZN10S3216C2_nt4v185Ev();
extern void _ZN10S3216C2_nt4v186Ev();
extern void _ZN10S3216C2_nt4v187Ev();
extern void _ZN10S3216C2_nt4v188Ev();
extern void _ZN10S3216C2_nt4v189Ev();
extern void _ZN10S3216C2_nt4v190Ev();
extern void _ZN10S3216C2_nt4v191Ev();
extern void _ZN10S3216C2_nt4v192Ev();
extern void _ZN10S3216C2_nt4v193Ev();
extern void _ZN10S3216C2_nt4v194Ev();
extern void _ZN10S3216C2_nt4v195Ev();
extern void _ZN10S3216C2_nt4v196Ev();
extern void _ZN10S3216C2_nt4v197Ev();
extern void _ZN10S3216C2_nt4v198Ev();
extern void _ZN10S3216C2_nt4v199Ev();
extern void _ZN10S3216C2_nt4v200Ev();
extern void _ZN10S3216C2_nt4v201Ev();
extern void _ZN10S3216C2_nt4v202Ev();
extern void _ZN10S3216C2_nt4v203Ev();
extern void _ZN10S3216C2_nt4v204Ev();
extern void _ZN10S3216C2_nt4v205Ev();
extern void _ZN10S3216C2_nt4v206Ev();
extern void _ZN10S3216C2_nt4v207Ev();
extern void _ZN10S3216C2_nt4v208Ev();
extern void _ZN10S3216C2_nt4v209Ev();
extern void _ZN10S3216C2_nt4v210Ev();
extern void _ZN7S3216C12v1Ev();
extern void _ZN7S3216C12v2Ev();
extern void _ZN7S3216C12v3Ev();
static  VTBL_ENTRY vtc_S3216C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S3216C1[0]),
  (VTBL_ENTRY)&_ZN7S3216C1D1Ev,
  (VTBL_ENTRY)&_ZN7S3216C1D0Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S3216C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S3216C2_nt4v210Ev,
  (VTBL_ENTRY)&_ZN7S3216C12v1Ev,
  (VTBL_ENTRY)&_ZN7S3216C12v2Ev,
  (VTBL_ENTRY)&_ZN7S3216C12v3Ev,
};
extern VTBL_ENTRY _ZTI7S3216C1[];
extern  VTBL_ENTRY _ZTV7S3216C1[];
Class_Descriptor cd_S3216C1 = {  "S3216C1", // class name
  bases_S3216C1, 2,
  &(vtc_S3216C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(576,444), // object size
  NSPAIRA(_ZTI7S3216C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S3216C1),214, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4677C6_nt  {
  void  mf4677c6(); // _ZN10S4677C6_nt8mf4677c6Ev
};
//SIG(-1 S4677C6_nt) C1{ m}


void  S4677C6_nt ::mf4677c6(){}

//skip512 S4677C6_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4677C5_nt  {
  void *s4677c5f0;
  int s4677c5f1;
  ::S4677C6_nt s4677c5f2;
  ::S4677C6_nt s4677c5f3;
  void  mf4677c5(); // _ZN10S4677C5_nt8mf4677c5Ev
};
//SIG(-1 S4677C5_nt) C1{ m Fp Fi FC2{ m} FC2}


void  S4677C5_nt ::mf4677c5(){}

//skip512 S4677C5_nt

#else // __cplusplus

Class_Descriptor cd_S4677C5_nt = {  "S4677C5_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4677C4_nt  : S4677C5_nt {
};
//SIG(-1 S4677C4_nt) C1{ BC2{ m Fp Fi FC3{ m} FC3}}



//skip512 S4677C4_nt

#else // __cplusplus

extern Class_Descriptor cd_S4677C5_nt;
static Base_Class bases_S4677C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4677C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4677C3_nt  {
  void *s4677c3f0;
  int s4677c3f1;
  ::S4677C4_nt s4677c3f2;
  ::S4677C4_nt s4677c3f3;
  int s4677c3f4;
  virtual  ~S4677C3_nt(); // _ZN10S4677C3_ntD1Ev
  virtual void  v29(); // _ZN10S4677C3_nt3v29Ev
  virtual void  v30(); // _ZN10S4677C3_nt3v30Ev
  virtual void  v31(); // _ZN10S4677C3_nt3v31Ev
  virtual void  v32(); // _ZN10S4677C3_nt3v32Ev
  virtual void  v33(); // _ZN10S4677C3_nt3v33Ev
  virtual void  v34(); // _ZN10S4677C3_nt3v34Ev
  virtual void  v35(); // _ZN10S4677C3_nt3v35Ev
  virtual void  v36(); // _ZN10S4677C3_nt3v36Ev
  virtual void  v37(); // _ZN10S4677C3_nt3v37Ev
  virtual void  v38(); // _ZN10S4677C3_nt3v38Ev
  virtual void  v39(); // _ZN10S4677C3_nt3v39Ev
  virtual void  v40(); // _ZN10S4677C3_nt3v40Ev
  virtual void  v41(); // _ZN10S4677C3_nt3v41Ev
  virtual void  v42(); // _ZN10S4677C3_nt3v42Ev
  virtual void  v43(); // _ZN10S4677C3_nt3v43Ev
  virtual void  v44(); // _ZN10S4677C3_nt3v44Ev
  virtual void  v45(); // _ZN10S4677C3_nt3v45Ev
  virtual void  v46(); // _ZN10S4677C3_nt3v46Ev
  virtual void  v47(); // _ZN10S4677C3_nt3v47Ev
  virtual void  v48(); // _ZN10S4677C3_nt3v48Ev
  virtual void  v49(); // _ZN10S4677C3_nt3v49Ev
  virtual void  v50(); // _ZN10S4677C3_nt3v50Ev
  virtual void  v51(); // _ZN10S4677C3_nt3v51Ev
  S4677C3_nt(); // tgen
};
//SIG(-1 S4677C3_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC2{ BC3{ m Fp Fi FC4{ m} FC4}} FC2 Fi}


 S4677C3_nt ::~S4677C3_nt(){ note_dtor("S4677C3_nt", this);}
void  S4677C3_nt ::v29(){vfunc_called(this, "_ZN10S4677C3_nt3v29Ev");}
void  S4677C3_nt ::v30(){vfunc_called(this, "_ZN10S4677C3_nt3v30Ev");}
void  S4677C3_nt ::v31(){vfunc_called(this, "_ZN10S4677C3_nt3v31Ev");}
void  S4677C3_nt ::v32(){vfunc_called(this, "_ZN10S4677C3_nt3v32Ev");}
void  S4677C3_nt ::v33(){vfunc_called(this, "_ZN10S4677C3_nt3v33Ev");}
void  S4677C3_nt ::v34(){vfunc_called(this, "_ZN10S4677C3_nt3v34Ev");}
void  S4677C3_nt ::v35(){vfunc_called(this, "_ZN10S4677C3_nt3v35Ev");}
void  S4677C3_nt ::v36(){vfunc_called(this, "_ZN10S4677C3_nt3v36Ev");}
void  S4677C3_nt ::v37(){vfunc_called(this, "_ZN10S4677C3_nt3v37Ev");}
void  S4677C3_nt ::v38(){vfunc_called(this, "_ZN10S4677C3_nt3v38Ev");}
void  S4677C3_nt ::v39(){vfunc_called(this, "_ZN10S4677C3_nt3v39Ev");}
void  S4677C3_nt ::v40(){vfunc_called(this, "_ZN10S4677C3_nt3v40Ev");}
void  S4677C3_nt ::v41(){vfunc_called(this, "_ZN10S4677C3_nt3v41Ev");}
void  S4677C3_nt ::v42(){vfunc_called(this, "_ZN10S4677C3_nt3v42Ev");}
void  S4677C3_nt ::v43(){vfunc_called(this, "_ZN10S4677C3_nt3v43Ev");}
void  S4677C3_nt ::v44(){vfunc_called(this, "_ZN10S4677C3_nt3v44Ev");}
void  S4677C3_nt ::v45(){vfunc_called(this, "_ZN10S4677C3_nt3v45Ev");}
void  S4677C3_nt ::v46(){vfunc_called(this, "_ZN10S4677C3_nt3v46Ev");}
void  S4677C3_nt ::v47(){vfunc_called(this, "_ZN10S4677C3_nt3v47Ev");}
void  S4677C3_nt ::v48(){vfunc_called(this, "_ZN10S4677C3_nt3v48Ev");}
void  S4677C3_nt ::v49(){vfunc_called(this, "_ZN10S4677C3_nt3v49Ev");}
void  S4677C3_nt ::v50(){vfunc_called(this, "_ZN10S4677C3_nt3v50Ev");}
void  S4677C3_nt ::v51(){vfunc_called(this, "_ZN10S4677C3_nt3v51Ev");}
S4677C3_nt ::S4677C3_nt(){ note_ctor("S4677C3_nt", this);} // tgen

//skip512 S4677C3_nt

#else // __cplusplus

extern void _ZN10S4677C3_ntC1Ev();
extern void _ZN10S4677C3_ntD1Ev();
Name_Map name_map_S4677C3_nt[] = {
  NSPAIR(_ZN10S4677C3_ntC1Ev),
  NSPAIR(_ZN10S4677C3_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S4677C3_nt[];
extern void _ZN10S4677C3_ntD1Ev();
extern void _ZN10S4677C3_ntD0Ev();
extern void _ZN10S4677C3_nt3v29Ev();
extern void _ZN10S4677C3_nt3v30Ev();
extern void _ZN10S4677C3_nt3v31Ev();
extern void _ZN10S4677C3_nt3v32Ev();
extern void _ZN10S4677C3_nt3v33Ev();
extern void _ZN10S4677C3_nt3v34Ev();
extern void _ZN10S4677C3_nt3v35Ev();
extern void _ZN10S4677C3_nt3v36Ev();
extern void _ZN10S4677C3_nt3v37Ev();
extern void _ZN10S4677C3_nt3v38Ev();
extern void _ZN10S4677C3_nt3v39Ev();
extern void _ZN10S4677C3_nt3v40Ev();
extern void _ZN10S4677C3_nt3v41Ev();
extern void _ZN10S4677C3_nt3v42Ev();
extern void _ZN10S4677C3_nt3v43Ev();
extern void _ZN10S4677C3_nt3v44Ev();
extern void _ZN10S4677C3_nt3v45Ev();
extern void _ZN10S4677C3_nt3v46Ev();
extern void _ZN10S4677C3_nt3v47Ev();
extern void _ZN10S4677C3_nt3v48Ev();
extern void _ZN10S4677C3_nt3v49Ev();
extern void _ZN10S4677C3_nt3v50Ev();
extern void _ZN10S4677C3_nt3v51Ev();
static  VTBL_ENTRY vtc_S4677C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S4677C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S4677C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v51Ev,
};
extern VTBL_ENTRY _ZTI10S4677C3_nt[];
VTBL_ENTRY *P__ZTI10S4677C3_nt = _ZTI10S4677C3_nt; 
extern  VTBL_ENTRY _ZTV10S4677C3_nt[];
Class_Descriptor cd_S4677C3_nt = {  "S4677C3_nt", // class name
  0,0,//no base classes
  &(vtc_S4677C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI10S4677C3_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S4677C3_nt),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4677C13_nt  {
  __tsi64 s4677c13f0[2];
  void  mf4677c13(); // _ZN11S4677C13_nt9mf4677c13Ev
};
//SIG(-1 S4677C13_nt) C1{ m FL[2]}


void  S4677C13_nt ::mf4677c13(){}

//skip512 S4677C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4677C12_nt  {
  ::S4677C13_nt s4677c12f0;
  void  mf4677c12(); // _ZN11S4677C12_nt9mf4677c12Ev
};
//SIG(-1 S4677C12_nt) C1{ m FC2{ m FL[2]}}


void  S4677C12_nt ::mf4677c12(){}

//skip512 S4677C12_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4677C16_nt  {
  ::S4677C12_nt s4677c16f0;
  void  mf4677c16(); // _ZN11S4677C16_nt9mf4677c16Ev
};
//SIG(-1 S4677C16_nt) C1{ m FC2{ m FC3{ m FL[2]}}}


void  S4677C16_nt ::mf4677c16(){}

//skip512 S4677C16_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4677C17_nt  {
  ::S4677C12_nt s4677c17f0;
  ::S4677C12_nt s4677c17f1;
  ::S4677C12_nt s4677c17f2;
  ::S4677C12_nt s4677c17f3;
  void  mf4677c17(); // _ZN11S4677C17_nt9mf4677c17Ev
};
//SIG(-1 S4677C17_nt) C1{ m FC2{ m FC3{ m FL[2]}} FC2 FC2 FC2}


void  S4677C17_nt ::mf4677c17(){}

//skip512 S4677C17_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4677C20  {
  void  mf4677c20(); // _ZN8S4677C209mf4677c20Ev
};
//SIG(-1 S4677C20) C1{ m}


void  S4677C20 ::mf4677c20(){}

static void Test_S4677C20()
{
  {
    init_simple_test("S4677C20");
    S4677C20 lv;
    check2(sizeof(lv), 1, "sizeof(S4677C20)");
    check2(__alignof__(lv), 1, "__alignof__(S4677C20)");
  }
}
static Arrange_To_Call_Me vS4677C20(Test_S4677C20, "S4677C20", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4677C19_nt  {
  void *s4677c19f0;
  int s4677c19f1;
  ::S4677C20 s4677c19f2;
  void  mf4677c19(); // _ZN11S4677C19_nt9mf4677c19Ev
};
//SIG(-1 S4677C19_nt) C1{ m Fp Fi FC2{ m}}


void  S4677C19_nt ::mf4677c19(){}

//skip512 S4677C19_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4677C18_nt  {
  ::S4677C19_nt s4677c18f0;
  int s4677c18f1;
  void  mf4677c18(); // _ZN11S4677C18_nt9mf4677c18Ev
};
//SIG(-1 S4677C18_nt) C1{ m FC2{ m Fp Fi FC3{ m}} Fi}


void  S4677C18_nt ::mf4677c18(){}

//skip512 S4677C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4677C23  {
  void  mf4677c23(); // _ZN8S4677C239mf4677c23Ev
};
//SIG(-1 S4677C23) C1{ m}


void  S4677C23 ::mf4677c23(){}

static void Test_S4677C23()
{
  {
    init_simple_test("S4677C23");
    S4677C23 lv;
    check2(sizeof(lv), 1, "sizeof(S4677C23)");
    check2(__alignof__(lv), 1, "__alignof__(S4677C23)");
  }
}
static Arrange_To_Call_Me vS4677C23(Test_S4677C23, "S4677C23", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S4677C23[];
VTBL_ENTRY *P__ZTI8S4677C23 = _ZTI8S4677C23; 
Class_Descriptor cd_S4677C23 = {  "S4677C23", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S4677C23),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4677C21  {
  void *s4677c21f0;
  int s4677c21f1;
  ::S4677C20 s4677c21f2;
  ::S4677C23 s4677c21f3;
  void  mf4677c21(); // _ZN8S4677C219mf4677c21Ev
};
//SIG(-1 S4677C21) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S4677C21 ::mf4677c21(){}

static void Test_S4677C21()
{
  {
    init_simple_test("S4677C21");
    S4677C21 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S4677C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4677C21)");
    check_field_offset(lv, s4677c21f0, 0, "S4677C21.s4677c21f0");
    check_field_offset(lv, s4677c21f1, ABISELECT(8,4), "S4677C21.s4677c21f1");
    check_field_offset(lv, s4677c21f2, ABISELECT(12,8), "S4677C21.s4677c21f2");
    check_field_offset(lv, s4677c21f3, ABISELECT(13,9), "S4677C21.s4677c21f3");
  }
}
static Arrange_To_Call_Me vS4677C21(Test_S4677C21, "S4677C21", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4677C27  {
  void  mf4677c27(); // _ZN8S4677C279mf4677c27Ev
};
//SIG(-1 S4677C27) C1{ m}


void  S4677C27 ::mf4677c27(){}

static void Test_S4677C27()
{
  {
    init_simple_test("S4677C27");
    S4677C27 lv;
    check2(sizeof(lv), 1, "sizeof(S4677C27)");
    check2(__alignof__(lv), 1, "__alignof__(S4677C27)");
  }
}
static Arrange_To_Call_Me vS4677C27(Test_S4677C27, "S4677C27", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S4677C27[];
VTBL_ENTRY *P__ZTI8S4677C27 = _ZTI8S4677C27; 
Class_Descriptor cd_S4677C27 = {  "S4677C27", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S4677C27),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4677C25  {
  void *s4677c25f0;
  int s4677c25f1;
  ::S4677C23 s4677c25f2;
  ::S4677C27 s4677c25f3;
  void  mf4677c25(); // _ZN8S4677C259mf4677c25Ev
};
//SIG(-1 S4677C25) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S4677C25 ::mf4677c25(){}

static void Test_S4677C25()
{
  {
    init_simple_test("S4677C25");
    S4677C25 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S4677C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4677C25)");
    check_field_offset(lv, s4677c25f0, 0, "S4677C25.s4677c25f0");
    check_field_offset(lv, s4677c25f1, ABISELECT(8,4), "S4677C25.s4677c25f1");
    check_field_offset(lv, s4677c25f2, ABISELECT(12,8), "S4677C25.s4677c25f2");
    check_field_offset(lv, s4677c25f3, ABISELECT(13,9), "S4677C25.s4677c25f3");
  }
}
static Arrange_To_Call_Me vS4677C25(Test_S4677C25, "S4677C25", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S4677C25 = {  "S4677C25", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4677C24  : S4677C25 {
};
//SIG(-1 S4677C24) C1{ BC2{ m Fp Fi FC3{ m} FC4{ m}}}



static void Test_S4677C24()
{
  extern Class_Descriptor cd_S4677C24;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S4677C24, buf);
    S4677C24 &lv = *(new (buf) S4677C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S4677C24)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4677C24)");
    check_base_class_offset(lv, (S4677C25*), 0, "S4677C24");
    test_class_info(&lv, &cd_S4677C24);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4677C24(Test_S4677C24, "S4677C24", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S4677C25;
static Base_Class bases_S4677C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4677C25,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S4677C24 = {  "S4677C24", // class name
  bases_S4677C24, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4677C28_nt  {
  void *s4677c28f0;
  int s4677c28f1[2];
  ::S4677C27 s4677c28f2;
  void  mf4677c28(); // _ZN11S4677C28_nt9mf4677c28Ev
};
//SIG(-1 S4677C28_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S4677C28_nt ::mf4677c28(){}

//skip512 S4677C28_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4677C37  {
  void  mf4677c37(); // _ZN8S4677C379mf4677c37Ev
};
//SIG(-1 S4677C37) C1{ m}


void  S4677C37 ::mf4677c37(){}

static void Test_S4677C37()
{
  {
    init_simple_test("S4677C37");
    S4677C37 lv;
    check2(sizeof(lv), 1, "sizeof(S4677C37)");
    check2(__alignof__(lv), 1, "__alignof__(S4677C37)");
  }
}
static Arrange_To_Call_Me vS4677C37(Test_S4677C37, "S4677C37", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S4677C37[];
VTBL_ENTRY *P__ZTI8S4677C37 = _ZTI8S4677C37; 
Class_Descriptor cd_S4677C37 = {  "S4677C37", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S4677C37),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4677C36  {
  void *s4677c36f0;
  int s4677c36f1[2];
  ::S4677C37 s4677c36f2;
  void  mf4677c36(); // _ZN8S4677C369mf4677c36Ev
};
//SIG(-1 S4677C36) C1{ m Fp Fi[2] FC2{ m}}


void  S4677C36 ::mf4677c36(){}

static void Test_S4677C36()
{
  {
    init_simple_test("S4677C36");
    S4677C36 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S4677C36)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4677C36)");
    check_field_offset(lv, s4677c36f0, 0, "S4677C36.s4677c36f0");
    check_field_offset(lv, s4677c36f1, ABISELECT(8,4), "S4677C36.s4677c36f1");
    check_field_offset(lv, s4677c36f2, ABISELECT(16,12), "S4677C36.s4677c36f2");
  }
}
static Arrange_To_Call_Me vS4677C36(Test_S4677C36, "S4677C36", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4677C2_nt  : S4677C3_nt {
  ::S4677C12_nt s4677c2f0;
  ::S4677C12_nt s4677c2f1;
  ::S4677C12_nt s4677c2f2;
  ::S4677C12_nt s4677c2f3;
  ::S4677C16_nt s4677c2f4;
  ::S4677C17_nt s4677c2f5;
  ::S4677C17_nt s4677c2f6;
  ::S4677C12_nt s4677c2f7;
  ::S4677C12_nt s4677c2f8;
  ::S4677C12_nt s4677c2f9;
  void *s4677c2f10;
  ::S4677C16_nt s4677c2f11;
  ::S4677C18_nt s4677c2f12;
  int s4677c2f13;
  void *s4677c2f14[7];
  ::S4677C21 s4677c2f15;
  int s4677c2f16:8;
  int s4677c2f17:8;
  int s4677c2f18:16;
  int s4677c2f19:16;
  int s4677c2f20:8;
  int s4677c2f21:8;
  int s4677c2f22:8;
  int s4677c2f23:32;
  int s4677c2f24:8;
  int s4677c2f25:4;
  int s4677c2f26:4;
  int s4677c2f27:4;
  int s4677c2f28:4;
  int s4677c2f29:4;
  int s4677c2f30:4;
  int s4677c2f31:4;
  int s4677c2f32:4;
  int s4677c2f33:4;
  int s4677c2f34:4;
  unsigned char s4677c2f35:1;
  unsigned char s4677c2f36:1;
  unsigned char s4677c2f37:1;
  unsigned char s4677c2f38:1;
  unsigned char s4677c2f39:1;
  unsigned char s4677c2f40:1;
  unsigned char s4677c2f41:1;
  unsigned char s4677c2f42:1;
  unsigned char s4677c2f43:1;
  unsigned char s4677c2f44:1;
  unsigned char s4677c2f45:1;
  unsigned char s4677c2f46:1;
  unsigned char s4677c2f47:1;
  unsigned char s4677c2f48:1;
  unsigned char s4677c2f49:1;
  unsigned char s4677c2f50:1;
  unsigned char s4677c2f51:1;
  unsigned char s4677c2f52:1;
  unsigned char s4677c2f53:1;
  unsigned char s4677c2f54:1;
  unsigned char s4677c2f55:1;
  unsigned char s4677c2f56:1;
  unsigned char s4677c2f57:1;
  unsigned char s4677c2f58:1;
  unsigned char s4677c2f59:1;
  unsigned char s4677c2f60:1;
  unsigned char s4677c2f61:1;
  unsigned char s4677c2f62:1;
  unsigned char s4677c2f63:1;
  unsigned char s4677c2f64:1;
  unsigned char s4677c2f65:1;
  unsigned char s4677c2f66:1;
  unsigned char s4677c2f67:1;
  unsigned char s4677c2f68:1;
  unsigned char s4677c2f69:1;
  unsigned char s4677c2f70:1;
  unsigned char s4677c2f71:1;
  unsigned char s4677c2f72:1;
  unsigned char s4677c2f73:1;
  unsigned char s4677c2f74:1;
  unsigned char s4677c2f75:1;
  int s4677c2f76[7];
  void *s4677c2f77[6];
  int s4677c2f78:8;
  int s4677c2f79:8;
  int s4677c2f80:8;
  int s4677c2f81:8;
  int s4677c2f82:8;
  int s4677c2f83:8;
  ::S4677C24 s4677c2f84;
  void *s4677c2f85[4];
  int s4677c2f86:8;
  int s4677c2f87:8;
  int s4677c2f88:8;
  int s4677c2f89:8;
  int s4677c2f90:8;
  int s4677c2f91:16;
  int s4677c2f92:16;
  int s4677c2f93:16;
  int s4677c2f94:4;
  int s4677c2f95:4;
  int s4677c2f96:4;
  int s4677c2f97:4;
  int s4677c2f98:4;
  int s4677c2f99:4;
  int s4677c2f100:4;
  int s4677c2f101:4;
  int s4677c2f102:4;
  int s4677c2f103:4;
  int s4677c2f104:4;
  int s4677c2f105:4;
  int s4677c2f106:8;
  int s4677c2f107:8;
  int s4677c2f108:8;
  void *s4677c2f109[7];
  ::S4677C28_nt s4677c2f110;
  void *s4677c2f111[2];
  int s4677c2f112:16;
  int s4677c2f113:16;
  ::S4677C24 s4677c2f114;
  ::S4677C28_nt s4677c2f115;
  ::S4677C36 s4677c2f116;
  void *s4677c2f117[2];
  int s4677c2f118:24;
  int s4677c2f119:8;
  void *s4677c2f120;
  virtual  ~S4677C2_nt(); // _ZN10S4677C2_ntD1Ev
  virtual void  v52(); // _ZN10S4677C2_nt3v52Ev
  virtual void  v53(); // _ZN10S4677C2_nt3v53Ev
  virtual void  v54(); // _ZN10S4677C2_nt3v54Ev
  virtual void  v55(); // _ZN10S4677C2_nt3v55Ev
  virtual void  v56(); // _ZN10S4677C2_nt3v56Ev
  virtual void  v57(); // _ZN10S4677C2_nt3v57Ev
  virtual void  v58(); // _ZN10S4677C2_nt3v58Ev
  virtual void  v59(); // _ZN10S4677C2_nt3v59Ev
  virtual void  v60(); // _ZN10S4677C2_nt3v60Ev
  virtual void  v61(); // _ZN10S4677C2_nt3v61Ev
  virtual void  v62(); // _ZN10S4677C2_nt3v62Ev
  virtual void  v63(); // _ZN10S4677C2_nt3v63Ev
  virtual void  v64(); // _ZN10S4677C2_nt3v64Ev
  virtual void  v65(); // _ZN10S4677C2_nt3v65Ev
  virtual void  v66(); // _ZN10S4677C2_nt3v66Ev
  virtual void  v67(); // _ZN10S4677C2_nt3v67Ev
  virtual void  v68(); // _ZN10S4677C2_nt3v68Ev
  virtual void  v69(); // _ZN10S4677C2_nt3v69Ev
  virtual void  v70(); // _ZN10S4677C2_nt3v70Ev
  virtual void  v71(); // _ZN10S4677C2_nt3v71Ev
  virtual void  v72(); // _ZN10S4677C2_nt3v72Ev
  virtual void  v73(); // _ZN10S4677C2_nt3v73Ev
  virtual void  v74(); // _ZN10S4677C2_nt3v74Ev
  virtual void  v75(); // _ZN10S4677C2_nt3v75Ev
  virtual void  v76(); // _ZN10S4677C2_nt3v76Ev
  virtual void  v77(); // _ZN10S4677C2_nt3v77Ev
  virtual void  v78(); // _ZN10S4677C2_nt3v78Ev
  virtual void  v79(); // _ZN10S4677C2_nt3v79Ev
  virtual void  v80(); // _ZN10S4677C2_nt3v80Ev
  virtual void  v81(); // _ZN10S4677C2_nt3v81Ev
  virtual void  v82(); // _ZN10S4677C2_nt3v82Ev
  virtual void  v83(); // _ZN10S4677C2_nt3v83Ev
  virtual void  v84(); // _ZN10S4677C2_nt3v84Ev
  virtual void  v85(); // _ZN10S4677C2_nt3v85Ev
  virtual void  v86(); // _ZN10S4677C2_nt3v86Ev
  virtual void  v87(); // _ZN10S4677C2_nt3v87Ev
  virtual void  v88(); // _ZN10S4677C2_nt3v88Ev
  virtual void  v89(); // _ZN10S4677C2_nt3v89Ev
  virtual void  v90(); // _ZN10S4677C2_nt3v90Ev
  virtual void  v91(); // _ZN10S4677C2_nt3v91Ev
  virtual void  v92(); // _ZN10S4677C2_nt3v92Ev
  virtual void  v93(); // _ZN10S4677C2_nt3v93Ev
  virtual void  v94(); // _ZN10S4677C2_nt3v94Ev
  virtual void  v95(); // _ZN10S4677C2_nt3v95Ev
  virtual void  v96(); // _ZN10S4677C2_nt3v96Ev
  virtual void  v97(); // _ZN10S4677C2_nt3v97Ev
  virtual void  v98(); // _ZN10S4677C2_nt3v98Ev
  virtual void  v99(); // _ZN10S4677C2_nt3v99Ev
  virtual void  v100(); // _ZN10S4677C2_nt4v100Ev
  virtual void  v101(); // _ZN10S4677C2_nt4v101Ev
  virtual void  v102(); // _ZN10S4677C2_nt4v102Ev
  virtual void  v103(); // _ZN10S4677C2_nt4v103Ev
  virtual void  v104(); // _ZN10S4677C2_nt4v104Ev
  virtual void  v105(); // _ZN10S4677C2_nt4v105Ev
  virtual void  v106(); // _ZN10S4677C2_nt4v106Ev
  virtual void  v107(); // _ZN10S4677C2_nt4v107Ev
  virtual void  v108(); // _ZN10S4677C2_nt4v108Ev
  virtual void  v109(); // _ZN10S4677C2_nt4v109Ev
  virtual void  v110(); // _ZN10S4677C2_nt4v110Ev
  virtual void  v111(); // _ZN10S4677C2_nt4v111Ev
  virtual void  v112(); // _ZN10S4677C2_nt4v112Ev
  virtual void  v113(); // _ZN10S4677C2_nt4v113Ev
  virtual void  v114(); // _ZN10S4677C2_nt4v114Ev
  virtual void  v115(); // _ZN10S4677C2_nt4v115Ev
  virtual void  v116(); // _ZN10S4677C2_nt4v116Ev
  virtual void  v117(); // _ZN10S4677C2_nt4v117Ev
  virtual void  v118(); // _ZN10S4677C2_nt4v118Ev
  virtual void  v119(); // _ZN10S4677C2_nt4v119Ev
  virtual void  v120(); // _ZN10S4677C2_nt4v120Ev
  virtual void  v121(); // _ZN10S4677C2_nt4v121Ev
  virtual void  v122(); // _ZN10S4677C2_nt4v122Ev
  virtual void  v123(); // _ZN10S4677C2_nt4v123Ev
  virtual void  v124(); // _ZN10S4677C2_nt4v124Ev
  virtual void  v125(); // _ZN10S4677C2_nt4v125Ev
  virtual void  v126(); // _ZN10S4677C2_nt4v126Ev
  virtual void  v127(); // _ZN10S4677C2_nt4v127Ev
  virtual void  v128(); // _ZN10S4677C2_nt4v128Ev
  virtual void  v129(); // _ZN10S4677C2_nt4v129Ev
  S4677C2_nt(); // tgen
};
//SIG(-1 S4677C2_nt) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fp Fi FC3{ BC4{ m Fp Fi FC5{ m} FC5}} FC3 Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 FC6{ m FC7{ m FL[2]}} FC6 FC6 FC6 FC8{ m FC6} FC9{ m FC6 FC6 FC6 FC6} FC9 FC6 FC6 FC6 Fp FC8 FC10{ m FC11{ m Fp Fi FC12{ m}} Fi} Fi Fp[7] FC13{ m Fp Fi FC12 FC14{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC15{ BC16{ m Fp Fi FC14 FC17{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC18{ m Fp Fi[2] FC17} Fp[2] Fi:16 Fi:16 FC15 FC18 FC19{ m Fp Fi[2] FC20{ m}} Fp[2] Fi:24 Fi:8 Fp}


 S4677C2_nt ::~S4677C2_nt(){ note_dtor("S4677C2_nt", this);}
void  S4677C2_nt ::v52(){vfunc_called(this, "_ZN10S4677C2_nt3v52Ev");}
void  S4677C2_nt ::v53(){vfunc_called(this, "_ZN10S4677C2_nt3v53Ev");}
void  S4677C2_nt ::v54(){vfunc_called(this, "_ZN10S4677C2_nt3v54Ev");}
void  S4677C2_nt ::v55(){vfunc_called(this, "_ZN10S4677C2_nt3v55Ev");}
void  S4677C2_nt ::v56(){vfunc_called(this, "_ZN10S4677C2_nt3v56Ev");}
void  S4677C2_nt ::v57(){vfunc_called(this, "_ZN10S4677C2_nt3v57Ev");}
void  S4677C2_nt ::v58(){vfunc_called(this, "_ZN10S4677C2_nt3v58Ev");}
void  S4677C2_nt ::v59(){vfunc_called(this, "_ZN10S4677C2_nt3v59Ev");}
void  S4677C2_nt ::v60(){vfunc_called(this, "_ZN10S4677C2_nt3v60Ev");}
void  S4677C2_nt ::v61(){vfunc_called(this, "_ZN10S4677C2_nt3v61Ev");}
void  S4677C2_nt ::v62(){vfunc_called(this, "_ZN10S4677C2_nt3v62Ev");}
void  S4677C2_nt ::v63(){vfunc_called(this, "_ZN10S4677C2_nt3v63Ev");}
void  S4677C2_nt ::v64(){vfunc_called(this, "_ZN10S4677C2_nt3v64Ev");}
void  S4677C2_nt ::v65(){vfunc_called(this, "_ZN10S4677C2_nt3v65Ev");}
void  S4677C2_nt ::v66(){vfunc_called(this, "_ZN10S4677C2_nt3v66Ev");}
void  S4677C2_nt ::v67(){vfunc_called(this, "_ZN10S4677C2_nt3v67Ev");}
void  S4677C2_nt ::v68(){vfunc_called(this, "_ZN10S4677C2_nt3v68Ev");}
void  S4677C2_nt ::v69(){vfunc_called(this, "_ZN10S4677C2_nt3v69Ev");}
void  S4677C2_nt ::v70(){vfunc_called(this, "_ZN10S4677C2_nt3v70Ev");}
void  S4677C2_nt ::v71(){vfunc_called(this, "_ZN10S4677C2_nt3v71Ev");}
void  S4677C2_nt ::v72(){vfunc_called(this, "_ZN10S4677C2_nt3v72Ev");}
void  S4677C2_nt ::v73(){vfunc_called(this, "_ZN10S4677C2_nt3v73Ev");}
void  S4677C2_nt ::v74(){vfunc_called(this, "_ZN10S4677C2_nt3v74Ev");}
void  S4677C2_nt ::v75(){vfunc_called(this, "_ZN10S4677C2_nt3v75Ev");}
void  S4677C2_nt ::v76(){vfunc_called(this, "_ZN10S4677C2_nt3v76Ev");}
void  S4677C2_nt ::v77(){vfunc_called(this, "_ZN10S4677C2_nt3v77Ev");}
void  S4677C2_nt ::v78(){vfunc_called(this, "_ZN10S4677C2_nt3v78Ev");}
void  S4677C2_nt ::v79(){vfunc_called(this, "_ZN10S4677C2_nt3v79Ev");}
void  S4677C2_nt ::v80(){vfunc_called(this, "_ZN10S4677C2_nt3v80Ev");}
void  S4677C2_nt ::v81(){vfunc_called(this, "_ZN10S4677C2_nt3v81Ev");}
void  S4677C2_nt ::v82(){vfunc_called(this, "_ZN10S4677C2_nt3v82Ev");}
void  S4677C2_nt ::v83(){vfunc_called(this, "_ZN10S4677C2_nt3v83Ev");}
void  S4677C2_nt ::v84(){vfunc_called(this, "_ZN10S4677C2_nt3v84Ev");}
void  S4677C2_nt ::v85(){vfunc_called(this, "_ZN10S4677C2_nt3v85Ev");}
void  S4677C2_nt ::v86(){vfunc_called(this, "_ZN10S4677C2_nt3v86Ev");}
void  S4677C2_nt ::v87(){vfunc_called(this, "_ZN10S4677C2_nt3v87Ev");}
void  S4677C2_nt ::v88(){vfunc_called(this, "_ZN10S4677C2_nt3v88Ev");}
void  S4677C2_nt ::v89(){vfunc_called(this, "_ZN10S4677C2_nt3v89Ev");}
void  S4677C2_nt ::v90(){vfunc_called(this, "_ZN10S4677C2_nt3v90Ev");}
void  S4677C2_nt ::v91(){vfunc_called(this, "_ZN10S4677C2_nt3v91Ev");}
void  S4677C2_nt ::v92(){vfunc_called(this, "_ZN10S4677C2_nt3v92Ev");}
void  S4677C2_nt ::v93(){vfunc_called(this, "_ZN10S4677C2_nt3v93Ev");}
void  S4677C2_nt ::v94(){vfunc_called(this, "_ZN10S4677C2_nt3v94Ev");}
void  S4677C2_nt ::v95(){vfunc_called(this, "_ZN10S4677C2_nt3v95Ev");}
void  S4677C2_nt ::v96(){vfunc_called(this, "_ZN10S4677C2_nt3v96Ev");}
void  S4677C2_nt ::v97(){vfunc_called(this, "_ZN10S4677C2_nt3v97Ev");}
void  S4677C2_nt ::v98(){vfunc_called(this, "_ZN10S4677C2_nt3v98Ev");}
void  S4677C2_nt ::v99(){vfunc_called(this, "_ZN10S4677C2_nt3v99Ev");}
void  S4677C2_nt ::v100(){vfunc_called(this, "_ZN10S4677C2_nt4v100Ev");}
void  S4677C2_nt ::v101(){vfunc_called(this, "_ZN10S4677C2_nt4v101Ev");}
void  S4677C2_nt ::v102(){vfunc_called(this, "_ZN10S4677C2_nt4v102Ev");}
void  S4677C2_nt ::v103(){vfunc_called(this, "_ZN10S4677C2_nt4v103Ev");}
void  S4677C2_nt ::v104(){vfunc_called(this, "_ZN10S4677C2_nt4v104Ev");}
void  S4677C2_nt ::v105(){vfunc_called(this, "_ZN10S4677C2_nt4v105Ev");}
void  S4677C2_nt ::v106(){vfunc_called(this, "_ZN10S4677C2_nt4v106Ev");}
void  S4677C2_nt ::v107(){vfunc_called(this, "_ZN10S4677C2_nt4v107Ev");}
void  S4677C2_nt ::v108(){vfunc_called(this, "_ZN10S4677C2_nt4v108Ev");}
void  S4677C2_nt ::v109(){vfunc_called(this, "_ZN10S4677C2_nt4v109Ev");}
void  S4677C2_nt ::v110(){vfunc_called(this, "_ZN10S4677C2_nt4v110Ev");}
void  S4677C2_nt ::v111(){vfunc_called(this, "_ZN10S4677C2_nt4v111Ev");}
void  S4677C2_nt ::v112(){vfunc_called(this, "_ZN10S4677C2_nt4v112Ev");}
void  S4677C2_nt ::v113(){vfunc_called(this, "_ZN10S4677C2_nt4v113Ev");}
void  S4677C2_nt ::v114(){vfunc_called(this, "_ZN10S4677C2_nt4v114Ev");}
void  S4677C2_nt ::v115(){vfunc_called(this, "_ZN10S4677C2_nt4v115Ev");}
void  S4677C2_nt ::v116(){vfunc_called(this, "_ZN10S4677C2_nt4v116Ev");}
void  S4677C2_nt ::v117(){vfunc_called(this, "_ZN10S4677C2_nt4v117Ev");}
void  S4677C2_nt ::v118(){vfunc_called(this, "_ZN10S4677C2_nt4v118Ev");}
void  S4677C2_nt ::v119(){vfunc_called(this, "_ZN10S4677C2_nt4v119Ev");}
void  S4677C2_nt ::v120(){vfunc_called(this, "_ZN10S4677C2_nt4v120Ev");}
void  S4677C2_nt ::v121(){vfunc_called(this, "_ZN10S4677C2_nt4v121Ev");}
void  S4677C2_nt ::v122(){vfunc_called(this, "_ZN10S4677C2_nt4v122Ev");}
void  S4677C2_nt ::v123(){vfunc_called(this, "_ZN10S4677C2_nt4v123Ev");}
void  S4677C2_nt ::v124(){vfunc_called(this, "_ZN10S4677C2_nt4v124Ev");}
void  S4677C2_nt ::v125(){vfunc_called(this, "_ZN10S4677C2_nt4v125Ev");}
void  S4677C2_nt ::v126(){vfunc_called(this, "_ZN10S4677C2_nt4v126Ev");}
void  S4677C2_nt ::v127(){vfunc_called(this, "_ZN10S4677C2_nt4v127Ev");}
void  S4677C2_nt ::v128(){vfunc_called(this, "_ZN10S4677C2_nt4v128Ev");}
void  S4677C2_nt ::v129(){vfunc_called(this, "_ZN10S4677C2_nt4v129Ev");}
S4677C2_nt ::S4677C2_nt(){ note_ctor("S4677C2_nt", this);} // tgen

//skip512 S4677C2_nt

#else // __cplusplus

extern void _ZN10S4677C2_ntC1Ev();
extern void _ZN10S4677C2_ntD1Ev();
Name_Map name_map_S4677C2_nt[] = {
  NSPAIR(_ZN10S4677C2_ntC1Ev),
  NSPAIR(_ZN10S4677C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4677C3_nt;
extern VTBL_ENTRY _ZTI10S4677C3_nt[];
extern  VTBL_ENTRY _ZTV10S4677C3_nt[];
static Base_Class bases_S4677C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4677C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S4677C2_nt[];
extern void _ZN10S4677C2_ntD1Ev();
extern void _ZN10S4677C2_ntD0Ev();
extern void _ZN10S4677C3_nt3v29Ev();
extern void _ZN10S4677C3_nt3v30Ev();
extern void _ZN10S4677C3_nt3v31Ev();
extern void _ZN10S4677C3_nt3v32Ev();
extern void _ZN10S4677C3_nt3v33Ev();
extern void _ZN10S4677C3_nt3v34Ev();
extern void _ZN10S4677C3_nt3v35Ev();
extern void _ZN10S4677C3_nt3v36Ev();
extern void _ZN10S4677C3_nt3v37Ev();
extern void _ZN10S4677C3_nt3v38Ev();
extern void _ZN10S4677C3_nt3v39Ev();
extern void _ZN10S4677C3_nt3v40Ev();
extern void _ZN10S4677C3_nt3v41Ev();
extern void _ZN10S4677C3_nt3v42Ev();
extern void _ZN10S4677C3_nt3v43Ev();
extern void _ZN10S4677C3_nt3v44Ev();
extern void _ZN10S4677C3_nt3v45Ev();
extern void _ZN10S4677C3_nt3v46Ev();
extern void _ZN10S4677C3_nt3v47Ev();
extern void _ZN10S4677C3_nt3v48Ev();
extern void _ZN10S4677C3_nt3v49Ev();
extern void _ZN10S4677C3_nt3v50Ev();
extern void _ZN10S4677C3_nt3v51Ev();
extern void _ZN10S4677C2_nt3v52Ev();
extern void _ZN10S4677C2_nt3v53Ev();
extern void _ZN10S4677C2_nt3v54Ev();
extern void _ZN10S4677C2_nt3v55Ev();
extern void _ZN10S4677C2_nt3v56Ev();
extern void _ZN10S4677C2_nt3v57Ev();
extern void _ZN10S4677C2_nt3v58Ev();
extern void _ZN10S4677C2_nt3v59Ev();
extern void _ZN10S4677C2_nt3v60Ev();
extern void _ZN10S4677C2_nt3v61Ev();
extern void _ZN10S4677C2_nt3v62Ev();
extern void _ZN10S4677C2_nt3v63Ev();
extern void _ZN10S4677C2_nt3v64Ev();
extern void _ZN10S4677C2_nt3v65Ev();
extern void _ZN10S4677C2_nt3v66Ev();
extern void _ZN10S4677C2_nt3v67Ev();
extern void _ZN10S4677C2_nt3v68Ev();
extern void _ZN10S4677C2_nt3v69Ev();
extern void _ZN10S4677C2_nt3v70Ev();
extern void _ZN10S4677C2_nt3v71Ev();
extern void _ZN10S4677C2_nt3v72Ev();
extern void _ZN10S4677C2_nt3v73Ev();
extern void _ZN10S4677C2_nt3v74Ev();
extern void _ZN10S4677C2_nt3v75Ev();
extern void _ZN10S4677C2_nt3v76Ev();
extern void _ZN10S4677C2_nt3v77Ev();
extern void _ZN10S4677C2_nt3v78Ev();
extern void _ZN10S4677C2_nt3v79Ev();
extern void _ZN10S4677C2_nt3v80Ev();
extern void _ZN10S4677C2_nt3v81Ev();
extern void _ZN10S4677C2_nt3v82Ev();
extern void _ZN10S4677C2_nt3v83Ev();
extern void _ZN10S4677C2_nt3v84Ev();
extern void _ZN10S4677C2_nt3v85Ev();
extern void _ZN10S4677C2_nt3v86Ev();
extern void _ZN10S4677C2_nt3v87Ev();
extern void _ZN10S4677C2_nt3v88Ev();
extern void _ZN10S4677C2_nt3v89Ev();
extern void _ZN10S4677C2_nt3v90Ev();
extern void _ZN10S4677C2_nt3v91Ev();
extern void _ZN10S4677C2_nt3v92Ev();
extern void _ZN10S4677C2_nt3v93Ev();
extern void _ZN10S4677C2_nt3v94Ev();
extern void _ZN10S4677C2_nt3v95Ev();
extern void _ZN10S4677C2_nt3v96Ev();
extern void _ZN10S4677C2_nt3v97Ev();
extern void _ZN10S4677C2_nt3v98Ev();
extern void _ZN10S4677C2_nt3v99Ev();
extern void _ZN10S4677C2_nt4v100Ev();
extern void _ZN10S4677C2_nt4v101Ev();
extern void _ZN10S4677C2_nt4v102Ev();
extern void _ZN10S4677C2_nt4v103Ev();
extern void _ZN10S4677C2_nt4v104Ev();
extern void _ZN10S4677C2_nt4v105Ev();
extern void _ZN10S4677C2_nt4v106Ev();
extern void _ZN10S4677C2_nt4v107Ev();
extern void _ZN10S4677C2_nt4v108Ev();
extern void _ZN10S4677C2_nt4v109Ev();
extern void _ZN10S4677C2_nt4v110Ev();
extern void _ZN10S4677C2_nt4v111Ev();
extern void _ZN10S4677C2_nt4v112Ev();
extern void _ZN10S4677C2_nt4v113Ev();
extern void _ZN10S4677C2_nt4v114Ev();
extern void _ZN10S4677C2_nt4v115Ev();
extern void _ZN10S4677C2_nt4v116Ev();
extern void _ZN10S4677C2_nt4v117Ev();
extern void _ZN10S4677C2_nt4v118Ev();
extern void _ZN10S4677C2_nt4v119Ev();
extern void _ZN10S4677C2_nt4v120Ev();
extern void _ZN10S4677C2_nt4v121Ev();
extern void _ZN10S4677C2_nt4v122Ev();
extern void _ZN10S4677C2_nt4v123Ev();
extern void _ZN10S4677C2_nt4v124Ev();
extern void _ZN10S4677C2_nt4v125Ev();
extern void _ZN10S4677C2_nt4v126Ev();
extern void _ZN10S4677C2_nt4v127Ev();
extern void _ZN10S4677C2_nt4v128Ev();
extern void _ZN10S4677C2_nt4v129Ev();
static  VTBL_ENTRY vtc_S4677C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S4677C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S4677C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v129Ev,
};
extern VTBL_ENTRY _ZTI10S4677C2_nt[];
VTBL_ENTRY *P__ZTI10S4677C2_nt = _ZTI10S4677C2_nt; 
extern  VTBL_ENTRY _ZTV10S4677C2_nt[];
Class_Descriptor cd_S4677C2_nt = {  "S4677C2_nt", // class name
  bases_S4677C2_nt, 1,
  &(vtc_S4677C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI10S4677C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S4677C2_nt),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4677C38_nt  {
  virtual  ~S4677C38_nt(); // _ZN11S4677C38_ntD1Ev
  virtual void  v130(); // _ZN11S4677C38_nt4v130Ev
  virtual void  v131(); // _ZN11S4677C38_nt4v131Ev
  virtual void  v132(); // _ZN11S4677C38_nt4v132Ev
  virtual void  v133(); // _ZN11S4677C38_nt4v133Ev
  virtual void  v134(); // _ZN11S4677C38_nt4v134Ev
  virtual void  v135(); // _ZN11S4677C38_nt4v135Ev
  virtual void  v136(); // _ZN11S4677C38_nt4v136Ev
  virtual void  v137(); // _ZN11S4677C38_nt4v137Ev
  virtual void  v138(); // _ZN11S4677C38_nt4v138Ev
  virtual void  v139(); // _ZN11S4677C38_nt4v139Ev
  virtual void  v140(); // _ZN11S4677C38_nt4v140Ev
  virtual void  v141(); // _ZN11S4677C38_nt4v141Ev
  virtual void  v142(); // _ZN11S4677C38_nt4v142Ev
  virtual void  v143(); // _ZN11S4677C38_nt4v143Ev
  virtual void  v144(); // _ZN11S4677C38_nt4v144Ev
  virtual void  v145(); // _ZN11S4677C38_nt4v145Ev
  virtual void  v146(); // _ZN11S4677C38_nt4v146Ev
  virtual void  v147(); // _ZN11S4677C38_nt4v147Ev
  virtual void  v148(); // _ZN11S4677C38_nt4v148Ev
  virtual void  v149(); // _ZN11S4677C38_nt4v149Ev
  virtual void  v150(); // _ZN11S4677C38_nt4v150Ev
  virtual void  v151(); // _ZN11S4677C38_nt4v151Ev
  virtual void  v152(); // _ZN11S4677C38_nt4v152Ev
  virtual void  v153(); // _ZN11S4677C38_nt4v153Ev
  virtual void  v154(); // _ZN11S4677C38_nt4v154Ev
  virtual void  v155(); // _ZN11S4677C38_nt4v155Ev
  virtual void  v156(); // _ZN11S4677C38_nt4v156Ev
  S4677C38_nt(); // tgen
};
//SIG(-1 S4677C38_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27}


 S4677C38_nt ::~S4677C38_nt(){ note_dtor("S4677C38_nt", this);}
void  S4677C38_nt ::v130(){vfunc_called(this, "_ZN11S4677C38_nt4v130Ev");}
void  S4677C38_nt ::v131(){vfunc_called(this, "_ZN11S4677C38_nt4v131Ev");}
void  S4677C38_nt ::v132(){vfunc_called(this, "_ZN11S4677C38_nt4v132Ev");}
void  S4677C38_nt ::v133(){vfunc_called(this, "_ZN11S4677C38_nt4v133Ev");}
void  S4677C38_nt ::v134(){vfunc_called(this, "_ZN11S4677C38_nt4v134Ev");}
void  S4677C38_nt ::v135(){vfunc_called(this, "_ZN11S4677C38_nt4v135Ev");}
void  S4677C38_nt ::v136(){vfunc_called(this, "_ZN11S4677C38_nt4v136Ev");}
void  S4677C38_nt ::v137(){vfunc_called(this, "_ZN11S4677C38_nt4v137Ev");}
void  S4677C38_nt ::v138(){vfunc_called(this, "_ZN11S4677C38_nt4v138Ev");}
void  S4677C38_nt ::v139(){vfunc_called(this, "_ZN11S4677C38_nt4v139Ev");}
void  S4677C38_nt ::v140(){vfunc_called(this, "_ZN11S4677C38_nt4v140Ev");}
void  S4677C38_nt ::v141(){vfunc_called(this, "_ZN11S4677C38_nt4v141Ev");}
void  S4677C38_nt ::v142(){vfunc_called(this, "_ZN11S4677C38_nt4v142Ev");}
void  S4677C38_nt ::v143(){vfunc_called(this, "_ZN11S4677C38_nt4v143Ev");}
void  S4677C38_nt ::v144(){vfunc_called(this, "_ZN11S4677C38_nt4v144Ev");}
void  S4677C38_nt ::v145(){vfunc_called(this, "_ZN11S4677C38_nt4v145Ev");}
void  S4677C38_nt ::v146(){vfunc_called(this, "_ZN11S4677C38_nt4v146Ev");}
void  S4677C38_nt ::v147(){vfunc_called(this, "_ZN11S4677C38_nt4v147Ev");}
void  S4677C38_nt ::v148(){vfunc_called(this, "_ZN11S4677C38_nt4v148Ev");}
void  S4677C38_nt ::v149(){vfunc_called(this, "_ZN11S4677C38_nt4v149Ev");}
void  S4677C38_nt ::v150(){vfunc_called(this, "_ZN11S4677C38_nt4v150Ev");}
void  S4677C38_nt ::v151(){vfunc_called(this, "_ZN11S4677C38_nt4v151Ev");}
void  S4677C38_nt ::v152(){vfunc_called(this, "_ZN11S4677C38_nt4v152Ev");}
void  S4677C38_nt ::v153(){vfunc_called(this, "_ZN11S4677C38_nt4v153Ev");}
void  S4677C38_nt ::v154(){vfunc_called(this, "_ZN11S4677C38_nt4v154Ev");}
void  S4677C38_nt ::v155(){vfunc_called(this, "_ZN11S4677C38_nt4v155Ev");}
void  S4677C38_nt ::v156(){vfunc_called(this, "_ZN11S4677C38_nt4v156Ev");}
S4677C38_nt ::S4677C38_nt(){ note_ctor("S4677C38_nt", this);} // tgen

//skip512 S4677C38_nt

#else // __cplusplus

extern void _ZN11S4677C38_ntC1Ev();
extern void _ZN11S4677C38_ntD1Ev();
Name_Map name_map_S4677C38_nt[] = {
  NSPAIR(_ZN11S4677C38_ntC1Ev),
  NSPAIR(_ZN11S4677C38_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI11S4677C38_nt[];
extern void _ZN11S4677C38_ntD1Ev();
extern void _ZN11S4677C38_ntD0Ev();
extern void _ZN11S4677C38_nt4v130Ev();
extern void _ZN11S4677C38_nt4v131Ev();
extern void _ZN11S4677C38_nt4v132Ev();
extern void _ZN11S4677C38_nt4v133Ev();
extern void _ZN11S4677C38_nt4v134Ev();
extern void _ZN11S4677C38_nt4v135Ev();
extern void _ZN11S4677C38_nt4v136Ev();
extern void _ZN11S4677C38_nt4v137Ev();
extern void _ZN11S4677C38_nt4v138Ev();
extern void _ZN11S4677C38_nt4v139Ev();
extern void _ZN11S4677C38_nt4v140Ev();
extern void _ZN11S4677C38_nt4v141Ev();
extern void _ZN11S4677C38_nt4v142Ev();
extern void _ZN11S4677C38_nt4v143Ev();
extern void _ZN11S4677C38_nt4v144Ev();
extern void _ZN11S4677C38_nt4v145Ev();
extern void _ZN11S4677C38_nt4v146Ev();
extern void _ZN11S4677C38_nt4v147Ev();
extern void _ZN11S4677C38_nt4v148Ev();
extern void _ZN11S4677C38_nt4v149Ev();
extern void _ZN11S4677C38_nt4v150Ev();
extern void _ZN11S4677C38_nt4v151Ev();
extern void _ZN11S4677C38_nt4v152Ev();
extern void _ZN11S4677C38_nt4v153Ev();
extern void _ZN11S4677C38_nt4v154Ev();
extern void _ZN11S4677C38_nt4v155Ev();
extern void _ZN11S4677C38_nt4v156Ev();
static  VTBL_ENTRY vtc_S4677C38_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI11S4677C38_nt[0]),
  (VTBL_ENTRY)&_ZN11S4677C38_ntD1Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_ntD0Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v130Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v131Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v132Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v133Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v134Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v135Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v136Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v137Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v138Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v139Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v140Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v141Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v142Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v143Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v144Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v145Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v146Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v147Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v148Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v149Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v150Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v151Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v152Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v153Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v154Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v155Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v156Ev,
};
extern VTBL_ENTRY _ZTI11S4677C38_nt[];
VTBL_ENTRY *P__ZTI11S4677C38_nt = _ZTI11S4677C38_nt; 
extern  VTBL_ENTRY _ZTV11S4677C38_nt[];
Class_Descriptor cd_S4677C38_nt = {  "S4677C38_nt", // class name
  0,0,//no base classes
  &(vtc_S4677C38_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI11S4677C38_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV11S4677C38_nt),31, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4677C1  : S4677C2_nt , S4677C38_nt {
  void *s4677c1f0[2];
  ::S4677C21 s4677c1f1;
  virtual  ~S4677C1(); // _ZN7S4677C1D1Ev
  virtual void  v1(); // _ZN7S4677C12v1Ev
  virtual void  v2(); // _ZN7S4677C12v2Ev
  virtual void  v3(); // _ZN7S4677C12v3Ev
  virtual void  v4(); // _ZN7S4677C12v4Ev
  virtual void  v5(); // _ZN7S4677C12v5Ev
  virtual void  v6(); // _ZN7S4677C12v6Ev
  virtual void  v7(); // _ZN7S4677C12v7Ev
  virtual void  v8(); // _ZN7S4677C12v8Ev
  virtual void  v9(); // _ZN7S4677C12v9Ev
  virtual void  v10(); // _ZN7S4677C13v10Ev
  virtual void  v11(); // _ZN7S4677C13v11Ev
  virtual void  v12(); // _ZN7S4677C13v12Ev
  virtual void  v13(); // _ZN7S4677C13v13Ev
  virtual void  v14(); // _ZN7S4677C13v14Ev
  virtual void  v15(); // _ZN7S4677C13v15Ev
  virtual void  v16(); // _ZN7S4677C13v16Ev
  virtual void  v17(); // _ZN7S4677C13v17Ev
  virtual void  v18(); // _ZN7S4677C13v18Ev
  virtual void  v19(); // _ZN7S4677C13v19Ev
  virtual void  v20(); // _ZN7S4677C13v20Ev
  virtual void  v21(); // _ZN7S4677C13v21Ev
  virtual void  v22(); // _ZN7S4677C13v22Ev
  virtual void  v23(); // _ZN7S4677C13v23Ev
  virtual void  v24(); // _ZN7S4677C13v24Ev
  virtual void  v25(); // _ZN7S4677C13v25Ev
  virtual void  v26(); // _ZN7S4677C13v26Ev
  virtual void  v27(); // _ZN7S4677C13v27Ev
  virtual void  v28(); // _ZN7S4677C13v28Ev
  S4677C1(); // tgen
};
//SIG(1 S4677C1) C1{ BC2{ BC3{ vd v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 Fp Fi FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC4 Fi} vd v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 FC7{ m FC8{ m FL[2]}} FC7 FC7 FC7 FC9{ m FC7} FC10{ m FC7 FC7 FC7 FC7} FC10 FC7 FC7 FC7 Fp FC9 FC11{ m FC12{ m Fp Fi FC13{ m}} Fi} Fi Fp[7] FC14{ m Fp Fi FC13 FC15{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC16{ BC17{ m Fp Fi FC15 FC18{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC19{ m Fp Fi[2] FC18} Fp[2] Fi:16 Fi:16 FC16 FC19 FC20{ m Fp Fi[2] FC21{ m}} Fp[2] Fi:24 Fi:8 Fp} BC22{ vd v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 Fp[2] FC14}


 S4677C1 ::~S4677C1(){ note_dtor("S4677C1", this);}
void  S4677C1 ::v1(){vfunc_called(this, "_ZN7S4677C12v1Ev");}
void  S4677C1 ::v2(){vfunc_called(this, "_ZN7S4677C12v2Ev");}
void  S4677C1 ::v3(){vfunc_called(this, "_ZN7S4677C12v3Ev");}
void  S4677C1 ::v4(){vfunc_called(this, "_ZN7S4677C12v4Ev");}
void  S4677C1 ::v5(){vfunc_called(this, "_ZN7S4677C12v5Ev");}
void  S4677C1 ::v6(){vfunc_called(this, "_ZN7S4677C12v6Ev");}
void  S4677C1 ::v7(){vfunc_called(this, "_ZN7S4677C12v7Ev");}
void  S4677C1 ::v8(){vfunc_called(this, "_ZN7S4677C12v8Ev");}
void  S4677C1 ::v9(){vfunc_called(this, "_ZN7S4677C12v9Ev");}
void  S4677C1 ::v10(){vfunc_called(this, "_ZN7S4677C13v10Ev");}
void  S4677C1 ::v11(){vfunc_called(this, "_ZN7S4677C13v11Ev");}
void  S4677C1 ::v12(){vfunc_called(this, "_ZN7S4677C13v12Ev");}
void  S4677C1 ::v13(){vfunc_called(this, "_ZN7S4677C13v13Ev");}
void  S4677C1 ::v14(){vfunc_called(this, "_ZN7S4677C13v14Ev");}
void  S4677C1 ::v15(){vfunc_called(this, "_ZN7S4677C13v15Ev");}
void  S4677C1 ::v16(){vfunc_called(this, "_ZN7S4677C13v16Ev");}
void  S4677C1 ::v17(){vfunc_called(this, "_ZN7S4677C13v17Ev");}
void  S4677C1 ::v18(){vfunc_called(this, "_ZN7S4677C13v18Ev");}
void  S4677C1 ::v19(){vfunc_called(this, "_ZN7S4677C13v19Ev");}
void  S4677C1 ::v20(){vfunc_called(this, "_ZN7S4677C13v20Ev");}
void  S4677C1 ::v21(){vfunc_called(this, "_ZN7S4677C13v21Ev");}
void  S4677C1 ::v22(){vfunc_called(this, "_ZN7S4677C13v22Ev");}
void  S4677C1 ::v23(){vfunc_called(this, "_ZN7S4677C13v23Ev");}
void  S4677C1 ::v24(){vfunc_called(this, "_ZN7S4677C13v24Ev");}
void  S4677C1 ::v25(){vfunc_called(this, "_ZN7S4677C13v25Ev");}
void  S4677C1 ::v26(){vfunc_called(this, "_ZN7S4677C13v26Ev");}
void  S4677C1 ::v27(){vfunc_called(this, "_ZN7S4677C13v27Ev");}
void  S4677C1 ::v28(){vfunc_called(this, "_ZN7S4677C13v28Ev");}
S4677C1 ::S4677C1(){ note_ctor("S4677C1", this);} // tgen

static void Test_S4677C1()
{
  extern Class_Descriptor cd_S4677C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(110,165)];
    init_test(&cd_S4677C1, buf);
    S4677C1 *dp, &lv = *(dp=new (buf) S4677C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(872,656), "sizeof(S4677C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4677C1)");
    check_base_class_offset(lv, (S4677C3_nt*)(S4677C2_nt*), 0, "S4677C1");
    check_base_class_offset(lv, (S4677C2_nt*), 0, "S4677C1");
    check_base_class_offset(lv, (S4677C38_nt*), ABISELECT(832,632), "S4677C1");
    check_field_offset(lv, s4677c1f0, ABISELECT(840,636), "S4677C1.s4677c1f0");
    check_field_offset(lv, s4677c1f1, ABISELECT(856,644), "S4677C1.s4677c1f1");
    test_class_info(&lv, &cd_S4677C1);
    dp->~S4677C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4677C1(Test_S4677C1, "S4677C1", ABISELECT(872,656));

#else // __cplusplus

extern void _ZN7S4677C1C1Ev();
extern void _ZN7S4677C1D1Ev();
Name_Map name_map_S4677C1[] = {
  NSPAIR(_ZN7S4677C1C1Ev),
  NSPAIR(_ZN7S4677C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4677C3_nt;
extern VTBL_ENTRY _ZTI10S4677C3_nt[];
extern  VTBL_ENTRY _ZTV10S4677C3_nt[];
extern Class_Descriptor cd_S4677C2_nt;
extern VTBL_ENTRY _ZTI10S4677C2_nt[];
extern  VTBL_ENTRY _ZTV10S4677C2_nt[];
extern Class_Descriptor cd_S4677C38_nt;
extern VTBL_ENTRY _ZTI11S4677C38_nt[];
extern  VTBL_ENTRY _ZTV11S4677C38_nt[];
static Base_Class bases_S4677C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4677C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S4677C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S4677C38_nt,    ABISELECT(832,632), //bcp->offset
    133, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4677C1[];
extern void _ZN7S4677C1D1Ev();
extern void _ZN7S4677C1D0Ev();
extern void _ZN10S4677C3_nt3v29Ev();
extern void _ZN10S4677C3_nt3v30Ev();
extern void _ZN10S4677C3_nt3v31Ev();
extern void _ZN10S4677C3_nt3v32Ev();
extern void _ZN10S4677C3_nt3v33Ev();
extern void _ZN10S4677C3_nt3v34Ev();
extern void _ZN10S4677C3_nt3v35Ev();
extern void _ZN10S4677C3_nt3v36Ev();
extern void _ZN10S4677C3_nt3v37Ev();
extern void _ZN10S4677C3_nt3v38Ev();
extern void _ZN10S4677C3_nt3v39Ev();
extern void _ZN10S4677C3_nt3v40Ev();
extern void _ZN10S4677C3_nt3v41Ev();
extern void _ZN10S4677C3_nt3v42Ev();
extern void _ZN10S4677C3_nt3v43Ev();
extern void _ZN10S4677C3_nt3v44Ev();
extern void _ZN10S4677C3_nt3v45Ev();
extern void _ZN10S4677C3_nt3v46Ev();
extern void _ZN10S4677C3_nt3v47Ev();
extern void _ZN10S4677C3_nt3v48Ev();
extern void _ZN10S4677C3_nt3v49Ev();
extern void _ZN10S4677C3_nt3v50Ev();
extern void _ZN10S4677C3_nt3v51Ev();
extern void _ZN10S4677C2_nt3v52Ev();
extern void _ZN10S4677C2_nt3v53Ev();
extern void _ZN10S4677C2_nt3v54Ev();
extern void _ZN10S4677C2_nt3v55Ev();
extern void _ZN10S4677C2_nt3v56Ev();
extern void _ZN10S4677C2_nt3v57Ev();
extern void _ZN10S4677C2_nt3v58Ev();
extern void _ZN10S4677C2_nt3v59Ev();
extern void _ZN10S4677C2_nt3v60Ev();
extern void _ZN10S4677C2_nt3v61Ev();
extern void _ZN10S4677C2_nt3v62Ev();
extern void _ZN10S4677C2_nt3v63Ev();
extern void _ZN10S4677C2_nt3v64Ev();
extern void _ZN10S4677C2_nt3v65Ev();
extern void _ZN10S4677C2_nt3v66Ev();
extern void _ZN10S4677C2_nt3v67Ev();
extern void _ZN10S4677C2_nt3v68Ev();
extern void _ZN10S4677C2_nt3v69Ev();
extern void _ZN10S4677C2_nt3v70Ev();
extern void _ZN10S4677C2_nt3v71Ev();
extern void _ZN10S4677C2_nt3v72Ev();
extern void _ZN10S4677C2_nt3v73Ev();
extern void _ZN10S4677C2_nt3v74Ev();
extern void _ZN10S4677C2_nt3v75Ev();
extern void _ZN10S4677C2_nt3v76Ev();
extern void _ZN10S4677C2_nt3v77Ev();
extern void _ZN10S4677C2_nt3v78Ev();
extern void _ZN10S4677C2_nt3v79Ev();
extern void _ZN10S4677C2_nt3v80Ev();
extern void _ZN10S4677C2_nt3v81Ev();
extern void _ZN10S4677C2_nt3v82Ev();
extern void _ZN10S4677C2_nt3v83Ev();
extern void _ZN10S4677C2_nt3v84Ev();
extern void _ZN10S4677C2_nt3v85Ev();
extern void _ZN10S4677C2_nt3v86Ev();
extern void _ZN10S4677C2_nt3v87Ev();
extern void _ZN10S4677C2_nt3v88Ev();
extern void _ZN10S4677C2_nt3v89Ev();
extern void _ZN10S4677C2_nt3v90Ev();
extern void _ZN10S4677C2_nt3v91Ev();
extern void _ZN10S4677C2_nt3v92Ev();
extern void _ZN10S4677C2_nt3v93Ev();
extern void _ZN10S4677C2_nt3v94Ev();
extern void _ZN10S4677C2_nt3v95Ev();
extern void _ZN10S4677C2_nt3v96Ev();
extern void _ZN10S4677C2_nt3v97Ev();
extern void _ZN10S4677C2_nt3v98Ev();
extern void _ZN10S4677C2_nt3v99Ev();
extern void _ZN10S4677C2_nt4v100Ev();
extern void _ZN10S4677C2_nt4v101Ev();
extern void _ZN10S4677C2_nt4v102Ev();
extern void _ZN10S4677C2_nt4v103Ev();
extern void _ZN10S4677C2_nt4v104Ev();
extern void _ZN10S4677C2_nt4v105Ev();
extern void _ZN10S4677C2_nt4v106Ev();
extern void _ZN10S4677C2_nt4v107Ev();
extern void _ZN10S4677C2_nt4v108Ev();
extern void _ZN10S4677C2_nt4v109Ev();
extern void _ZN10S4677C2_nt4v110Ev();
extern void _ZN10S4677C2_nt4v111Ev();
extern void _ZN10S4677C2_nt4v112Ev();
extern void _ZN10S4677C2_nt4v113Ev();
extern void _ZN10S4677C2_nt4v114Ev();
extern void _ZN10S4677C2_nt4v115Ev();
extern void _ZN10S4677C2_nt4v116Ev();
extern void _ZN10S4677C2_nt4v117Ev();
extern void _ZN10S4677C2_nt4v118Ev();
extern void _ZN10S4677C2_nt4v119Ev();
extern void _ZN10S4677C2_nt4v120Ev();
extern void _ZN10S4677C2_nt4v121Ev();
extern void _ZN10S4677C2_nt4v122Ev();
extern void _ZN10S4677C2_nt4v123Ev();
extern void _ZN10S4677C2_nt4v124Ev();
extern void _ZN10S4677C2_nt4v125Ev();
extern void _ZN10S4677C2_nt4v126Ev();
extern void _ZN10S4677C2_nt4v127Ev();
extern void _ZN10S4677C2_nt4v128Ev();
extern void _ZN10S4677C2_nt4v129Ev();
extern void _ZN7S4677C12v1Ev();
extern void _ZN7S4677C12v2Ev();
extern void _ZN7S4677C12v3Ev();
extern void _ZN7S4677C12v4Ev();
extern void _ZN7S4677C12v5Ev();
extern void _ZN7S4677C12v6Ev();
extern void _ZN7S4677C12v7Ev();
extern void _ZN7S4677C12v8Ev();
extern void _ZN7S4677C12v9Ev();
extern void _ZN7S4677C13v10Ev();
extern void _ZN7S4677C13v11Ev();
extern void _ZN7S4677C13v12Ev();
extern void _ZN7S4677C13v13Ev();
extern void _ZN7S4677C13v14Ev();
extern void _ZN7S4677C13v15Ev();
extern void _ZN7S4677C13v16Ev();
extern void _ZN7S4677C13v17Ev();
extern void _ZN7S4677C13v18Ev();
extern void _ZN7S4677C13v19Ev();
extern void _ZN7S4677C13v20Ev();
extern void _ZN7S4677C13v21Ev();
extern void _ZN7S4677C13v22Ev();
extern void _ZN7S4677C13v23Ev();
extern void _ZN7S4677C13v24Ev();
extern void _ZN7S4677C13v25Ev();
extern void _ZN7S4677C13v26Ev();
extern void _ZN7S4677C13v27Ev();
extern void _ZN7S4677C13v28Ev();
extern void ABISELECT(_ZThn832_N7S4677C1D1Ev,_ZThn632_N7S4677C1D1Ev)();
extern void ABISELECT(_ZThn832_N7S4677C1D0Ev,_ZThn632_N7S4677C1D0Ev)();
extern void _ZN11S4677C38_nt4v130Ev();
extern void _ZN11S4677C38_nt4v131Ev();
extern void _ZN11S4677C38_nt4v132Ev();
extern void _ZN11S4677C38_nt4v133Ev();
extern void _ZN11S4677C38_nt4v134Ev();
extern void _ZN11S4677C38_nt4v135Ev();
extern void _ZN11S4677C38_nt4v136Ev();
extern void _ZN11S4677C38_nt4v137Ev();
extern void _ZN11S4677C38_nt4v138Ev();
extern void _ZN11S4677C38_nt4v139Ev();
extern void _ZN11S4677C38_nt4v140Ev();
extern void _ZN11S4677C38_nt4v141Ev();
extern void _ZN11S4677C38_nt4v142Ev();
extern void _ZN11S4677C38_nt4v143Ev();
extern void _ZN11S4677C38_nt4v144Ev();
extern void _ZN11S4677C38_nt4v145Ev();
extern void _ZN11S4677C38_nt4v146Ev();
extern void _ZN11S4677C38_nt4v147Ev();
extern void _ZN11S4677C38_nt4v148Ev();
extern void _ZN11S4677C38_nt4v149Ev();
extern void _ZN11S4677C38_nt4v150Ev();
extern void _ZN11S4677C38_nt4v151Ev();
extern void _ZN11S4677C38_nt4v152Ev();
extern void _ZN11S4677C38_nt4v153Ev();
extern void _ZN11S4677C38_nt4v154Ev();
extern void _ZN11S4677C38_nt4v155Ev();
extern void _ZN11S4677C38_nt4v156Ev();
static  VTBL_ENTRY vtc_S4677C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4677C1[0]),
  (VTBL_ENTRY)&_ZN7S4677C1D1Ev,
  (VTBL_ENTRY)&_ZN7S4677C1D0Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S4677C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S4677C2_nt4v129Ev,
  (VTBL_ENTRY)&_ZN7S4677C12v1Ev,
  (VTBL_ENTRY)&_ZN7S4677C12v2Ev,
  (VTBL_ENTRY)&_ZN7S4677C12v3Ev,
  (VTBL_ENTRY)&_ZN7S4677C12v4Ev,
  (VTBL_ENTRY)&_ZN7S4677C12v5Ev,
  (VTBL_ENTRY)&_ZN7S4677C12v6Ev,
  (VTBL_ENTRY)&_ZN7S4677C12v7Ev,
  (VTBL_ENTRY)&_ZN7S4677C12v8Ev,
  (VTBL_ENTRY)&_ZN7S4677C12v9Ev,
  (VTBL_ENTRY)&_ZN7S4677C13v10Ev,
  (VTBL_ENTRY)&_ZN7S4677C13v11Ev,
  (VTBL_ENTRY)&_ZN7S4677C13v12Ev,
  (VTBL_ENTRY)&_ZN7S4677C13v13Ev,
  (VTBL_ENTRY)&_ZN7S4677C13v14Ev,
  (VTBL_ENTRY)&_ZN7S4677C13v15Ev,
  (VTBL_ENTRY)&_ZN7S4677C13v16Ev,
  (VTBL_ENTRY)&_ZN7S4677C13v17Ev,
  (VTBL_ENTRY)&_ZN7S4677C13v18Ev,
  (VTBL_ENTRY)&_ZN7S4677C13v19Ev,
  (VTBL_ENTRY)&_ZN7S4677C13v20Ev,
  (VTBL_ENTRY)&_ZN7S4677C13v21Ev,
  (VTBL_ENTRY)&_ZN7S4677C13v22Ev,
  (VTBL_ENTRY)&_ZN7S4677C13v23Ev,
  (VTBL_ENTRY)&_ZN7S4677C13v24Ev,
  (VTBL_ENTRY)&_ZN7S4677C13v25Ev,
  (VTBL_ENTRY)&_ZN7S4677C13v26Ev,
  (VTBL_ENTRY)&_ZN7S4677C13v27Ev,
  (VTBL_ENTRY)&_ZN7S4677C13v28Ev,
  ABISELECT(-832,-632),
  (VTBL_ENTRY)&(_ZTI7S4677C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn832_N7S4677C1D1Ev,_ZThn632_N7S4677C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn832_N7S4677C1D0Ev,_ZThn632_N7S4677C1D0Ev),
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v130Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v131Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v132Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v133Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v134Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v135Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v136Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v137Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v138Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v139Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v140Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v141Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v142Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v143Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v144Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v145Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v146Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v147Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v148Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v149Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v150Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v151Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v152Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v153Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v154Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v155Ev,
  (VTBL_ENTRY)&_ZN11S4677C38_nt4v156Ev,
};
extern VTBL_ENTRY _ZTI7S4677C1[];
extern  VTBL_ENTRY _ZTV7S4677C1[];
Class_Descriptor cd_S4677C1 = {  "S4677C1", // class name
  bases_S4677C1, 3,
  &(vtc_S4677C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(872,656), // object size
  NSPAIRA(_ZTI7S4677C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S4677C1),164, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16701C4_nt  {
  void *s16701c4f0;
  void  mf16701c4(); // _ZN11S16701C4_nt9mf16701c4Ev
};
//SIG(-1 S16701C4_nt) C1{ m Fp}


void  S16701C4_nt ::mf16701c4(){}

//skip512 S16701C4_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16701C3  {
  ::S16701C4_nt s16701c3f0;
  void  mf16701c3(); // _ZN8S16701C39mf16701c3Ev
};
//SIG(-1 S16701C3) C1{ m FC2{ m Fp}}


void  S16701C3 ::mf16701c3(){}

static void Test_S16701C3()
{
  {
    init_simple_test("S16701C3");
    S16701C3 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S16701C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16701C3)");
    check_field_offset(lv, s16701c3f0, 0, "S16701C3.s16701c3f0");
  }
}
static Arrange_To_Call_Me vS16701C3(Test_S16701C3, "S16701C3", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16701C2  {
  ::S16701C3 s16701c2f0;
  void  mf16701c2(); // _ZN8S16701C29mf16701c2Ev
};
//SIG(-1 S16701C2) C1{ m FC2{ m FC3{ m Fp}}}


void  S16701C2 ::mf16701c2(){}

static void Test_S16701C2()
{
  {
    init_simple_test("S16701C2");
    S16701C2 lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S16701C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16701C2)");
    check_field_offset(lv, s16701c2f0, 0, "S16701C2.s16701c2f0");
  }
}
static Arrange_To_Call_Me vS16701C2(Test_S16701C2, "S16701C2", ABISELECT(8,4));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S16701C1  {
  int s16701c1f0;
  ::S16701C2 s16701c1f1;
  ::S16701C2 s16701c1f2;
  ::S16701C2 s16701c1f3;
  ::S16701C2 s16701c1f4;
  ::S16701C2 s16701c1f5;
  ::S16701C2 s16701c1f6;
  ::S16701C2 s16701c1f7;
  ::S16701C2 s16701c1f8;
  ::S16701C2 s16701c1f9;
  ::S16701C2 s16701c1f10;
  ::S16701C2 s16701c1f11;
  ::S16701C2 s16701c1f12;
  ::S16701C2 s16701c1f13;
  ::S16701C2 s16701c1f14;
  ::S16701C2 s16701c1f15;
  ::S16701C2 s16701c1f16;
  ::S16701C2 s16701c1f17;
  ::S16701C2 s16701c1f18;
  ::S16701C2 s16701c1f19;
  ::S16701C2 s16701c1f20;
  ::S16701C2 s16701c1f21;
  ::S16701C2 s16701c1f22;
  ::S16701C2 s16701c1f23;
  ::S16701C2 s16701c1f24;
  ::S16701C2 s16701c1f25;
  ::S16701C2 s16701c1f26;
  ::S16701C2 s16701c1f27;
  ::S16701C2 s16701c1f28;
  ::S16701C2 s16701c1f29;
  ::S16701C2 s16701c1f30;
  ::S16701C2 s16701c1f31;
  ::S16701C2 s16701c1f32;
  ::S16701C2 s16701c1f33;
  ::S16701C2 s16701c1f34;
  ::S16701C2 s16701c1f35;
  ::S16701C2 s16701c1f36;
  ::S16701C2 s16701c1f37;
  ::S16701C2 s16701c1f38;
  ::S16701C2 s16701c1f39;
  ::S16701C2 s16701c1f40;
  ::S16701C2 s16701c1f41;
  ::S16701C2 s16701c1f42;
  ::S16701C2 s16701c1f43;
  ::S16701C2 s16701c1f44;
  ::S16701C2 s16701c1f45;
  ::S16701C2 s16701c1f46;
  ::S16701C2 s16701c1f47;
  ::S16701C2 s16701c1f48;
  ::S16701C2 s16701c1f49;
  ::S16701C2 s16701c1f50;
  ::S16701C2 s16701c1f51;
  ::S16701C2 s16701c1f52;
  ::S16701C2 s16701c1f53;
  ::S16701C2 s16701c1f54;
  ::S16701C2 s16701c1f55;
  ::S16701C2 s16701c1f56;
  ::S16701C2 s16701c1f57;
  ::S16701C2 s16701c1f58;
  ::S16701C2 s16701c1f59;
  ::S16701C2 s16701c1f60;
  ::S16701C2 s16701c1f61;
  ::S16701C2 s16701c1f62;
  ::S16701C2 s16701c1f63;
  ::S16701C2 s16701c1f64;
  ::S16701C2 s16701c1f65;
  ::S16701C2 s16701c1f66;
  ::S16701C2 s16701c1f67;
  ::S16701C2 s16701c1f68;
  ::S16701C2 s16701c1f69;
  ::S16701C2 s16701c1f70;
  ::S16701C2 s16701c1f71;
  ::S16701C2 s16701c1f72;
  ::S16701C2 s16701c1f73;
  ::S16701C2 s16701c1f74;
  ::S16701C2 s16701c1f75;
  ::S16701C2 s16701c1f76;
  ::S16701C2 s16701c1f77;
  ::S16701C2 s16701c1f78;
  ::S16701C2 s16701c1f79;
  ::S16701C2 s16701c1f80;
  ::S16701C2 s16701c1f81;
  ::S16701C2 s16701c1f82;
  ::S16701C2 s16701c1f83;
  ::S16701C2 s16701c1f84;
  ::S16701C2 s16701c1f85;
  ::S16701C2 s16701c1f86;
  ::S16701C2 s16701c1f87;
  ::S16701C2 s16701c1f88;
  ::S16701C2 s16701c1f89;
  ::S16701C2 s16701c1f90;
  ::S16701C2 s16701c1f91;
  ::S16701C2 s16701c1f92;
  ::S16701C2 s16701c1f93;
  ::S16701C2 s16701c1f94;
  ::S16701C2 s16701c1f95;
  ::S16701C2 s16701c1f96;
  ::S16701C2 s16701c1f97;
  ::S16701C2 s16701c1f98;
  ::S16701C2 s16701c1f99;
  ::S16701C2 s16701c1f100;
  ::S16701C2 s16701c1f101;
  ::S16701C2 s16701c1f102;
  ::S16701C2 s16701c1f103;
  ::S16701C2 s16701c1f104;
  ::S16701C2 s16701c1f105;
  ::S16701C2 s16701c1f106;
  ::S16701C2 s16701c1f107;
  ::S16701C2 s16701c1f108;
  ::S16701C2 s16701c1f109;
  ::S16701C2 s16701c1f110;
  ::S16701C2 s16701c1f111;
  ::S16701C2 s16701c1f112;
  ::S16701C2 s16701c1f113;
  ::S16701C2 s16701c1f114;
  ::S16701C2 s16701c1f115;
  ::S16701C2 s16701c1f116;
  ::S16701C2 s16701c1f117;
  ::S16701C2 s16701c1f118;
  ::S16701C2 s16701c1f119;
  ::S16701C2 s16701c1f120;
  ::S16701C2 s16701c1f121;
  ::S16701C2 s16701c1f122;
  ::S16701C2 s16701c1f123;
  ::S16701C2 s16701c1f124;
  ::S16701C2 s16701c1f125;
  ::S16701C2 s16701c1f126;
  ::S16701C2 s16701c1f127;
  ::S16701C2 s16701c1f128;
  ::S16701C2 s16701c1f129;
  ::S16701C2 s16701c1f130;
  ::S16701C2 s16701c1f131;
  ::S16701C2 s16701c1f132;
  ::S16701C2 s16701c1f133;
  ::S16701C2 s16701c1f134;
  ::S16701C2 s16701c1f135;
  ::S16701C2 s16701c1f136;
  ::S16701C2 s16701c1f137;
  ::S16701C2 s16701c1f138;
  ::S16701C2 s16701c1f139;
  ::S16701C2 s16701c1f140;
  ::S16701C2 s16701c1f141;
  ::S16701C2 s16701c1f142;
  ::S16701C2 s16701c1f143;
  ::S16701C2 s16701c1f144;
  ::S16701C2 s16701c1f145;
  ::S16701C2 s16701c1f146;
  ::S16701C2 s16701c1f147;
  ::S16701C2 s16701c1f148;
  ::S16701C2 s16701c1f149;
  ::S16701C2 s16701c1f150;
  ::S16701C2 s16701c1f151;
  ::S16701C2 s16701c1f152;
  ::S16701C2 s16701c1f153;
  ::S16701C2 s16701c1f154;
  ::S16701C2 s16701c1f155;
  ::S16701C2 s16701c1f156;
  ::S16701C2 s16701c1f157;
  ::S16701C2 s16701c1f158;
  ::S16701C2 s16701c1f159;
  ::S16701C2 s16701c1f160;
  ::S16701C2 s16701c1f161;
  ::S16701C2 s16701c1f162;
  ::S16701C2 s16701c1f163;
  ::S16701C2 s16701c1f164;
  ::S16701C2 s16701c1f165;
  ::S16701C2 s16701c1f166;
  ::S16701C2 s16701c1f167;
  ::S16701C2 s16701c1f168;
  ::S16701C2 s16701c1f169;
  ::S16701C2 s16701c1f170;
  ::S16701C2 s16701c1f171;
  ::S16701C2 s16701c1f172;
  ::S16701C2 s16701c1f173;
  ::S16701C2 s16701c1f174;
  ::S16701C2 s16701c1f175;
  ::S16701C2 s16701c1f176;
  ::S16701C2 s16701c1f177;
  ::S16701C2 s16701c1f178;
  ::S16701C2 s16701c1f179;
  ::S16701C2 s16701c1f180;
  ::S16701C2 s16701c1f181;
  ::S16701C2 s16701c1f182;
  ::S16701C2 s16701c1f183;
  ::S16701C2 s16701c1f184;
  ::S16701C2 s16701c1f185;
  ::S16701C2 s16701c1f186;
  ::S16701C2 s16701c1f187;
  ::S16701C2 s16701c1f188;
  ::S16701C2 s16701c1f189;
  ::S16701C2 s16701c1f190;
  ::S16701C2 s16701c1f191;
  ::S16701C2 s16701c1f192;
  ::S16701C2 s16701c1f193;
  ::S16701C2 s16701c1f194;
  ::S16701C2 s16701c1f195;
  ::S16701C2 s16701c1f196;
  ::S16701C2 s16701c1f197;
  ::S16701C2 s16701c1f198;
  ::S16701C2 s16701c1f199;
  ::S16701C2 s16701c1f200;
  ::S16701C2 s16701c1f201;
  ::S16701C2 s16701c1f202;
  ::S16701C2 s16701c1f203;
  ::S16701C2 s16701c1f204;
  ::S16701C2 s16701c1f205;
  void  mf16701c1(); // _ZN8S16701C19mf16701c1Ev
};
//SIG(1 S16701C1) C1{ m Fi FC2{ m FC3{ m FC4{ m Fp}}} FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2}


void  S16701C1 ::mf16701c1(){}

static void Test_S16701C1()
{
  {
    init_simple_test("S16701C1");
    S16701C1 lv;
    check2(sizeof(lv), ABISELECT(1648,824), "sizeof(S16701C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S16701C1)");
    check_field_offset(lv, s16701c1f0, 0, "S16701C1.s16701c1f0");
    check_field_offset(lv, s16701c1f1, ABISELECT(8,4), "S16701C1.s16701c1f1");
    check_field_offset(lv, s16701c1f2, ABISELECT(16,8), "S16701C1.s16701c1f2");
    check_field_offset(lv, s16701c1f3, ABISELECT(24,12), "S16701C1.s16701c1f3");
    check_field_offset(lv, s16701c1f4, ABISELECT(32,16), "S16701C1.s16701c1f4");
    check_field_offset(lv, s16701c1f5, ABISELECT(40,20), "S16701C1.s16701c1f5");
    check_field_offset(lv, s16701c1f6, ABISELECT(48,24), "S16701C1.s16701c1f6");
    check_field_offset(lv, s16701c1f7, ABISELECT(56,28), "S16701C1.s16701c1f7");
    check_field_offset(lv, s16701c1f8, ABISELECT(64,32), "S16701C1.s16701c1f8");
    check_field_offset(lv, s16701c1f9, ABISELECT(72,36), "S16701C1.s16701c1f9");
    check_field_offset(lv, s16701c1f10, ABISELECT(80,40), "S16701C1.s16701c1f10");
    check_field_offset(lv, s16701c1f11, ABISELECT(88,44), "S16701C1.s16701c1f11");
    check_field_offset(lv, s16701c1f12, ABISELECT(96,48), "S16701C1.s16701c1f12");
    check_field_offset(lv, s16701c1f13, ABISELECT(104,52), "S16701C1.s16701c1f13");
    check_field_offset(lv, s16701c1f14, ABISELECT(112,56), "S16701C1.s16701c1f14");
    check_field_offset(lv, s16701c1f15, ABISELECT(120,60), "S16701C1.s16701c1f15");
    check_field_offset(lv, s16701c1f16, ABISELECT(128,64), "S16701C1.s16701c1f16");
    check_field_offset(lv, s16701c1f17, ABISELECT(136,68), "S16701C1.s16701c1f17");
    check_field_offset(lv, s16701c1f18, ABISELECT(144,72), "S16701C1.s16701c1f18");
    check_field_offset(lv, s16701c1f19, ABISELECT(152,76), "S16701C1.s16701c1f19");
    check_field_offset(lv, s16701c1f20, ABISELECT(160,80), "S16701C1.s16701c1f20");
    check_field_offset(lv, s16701c1f21, ABISELECT(168,84), "S16701C1.s16701c1f21");
    check_field_offset(lv, s16701c1f22, ABISELECT(176,88), "S16701C1.s16701c1f22");
    check_field_offset(lv, s16701c1f23, ABISELECT(184,92), "S16701C1.s16701c1f23");
    check_field_offset(lv, s16701c1f24, ABISELECT(192,96), "S16701C1.s16701c1f24");
    check_field_offset(lv, s16701c1f25, ABISELECT(200,100), "S16701C1.s16701c1f25");
    check_field_offset(lv, s16701c1f26, ABISELECT(208,104), "S16701C1.s16701c1f26");
    check_field_offset(lv, s16701c1f27, ABISELECT(216,108), "S16701C1.s16701c1f27");
    check_field_offset(lv, s16701c1f28, ABISELECT(224,112), "S16701C1.s16701c1f28");
    check_field_offset(lv, s16701c1f29, ABISELECT(232,116), "S16701C1.s16701c1f29");
    check_field_offset(lv, s16701c1f30, ABISELECT(240,120), "S16701C1.s16701c1f30");
    check_field_offset(lv, s16701c1f31, ABISELECT(248,124), "S16701C1.s16701c1f31");
    check_field_offset(lv, s16701c1f32, ABISELECT(256,128), "S16701C1.s16701c1f32");
    check_field_offset(lv, s16701c1f33, ABISELECT(264,132), "S16701C1.s16701c1f33");
    check_field_offset(lv, s16701c1f34, ABISELECT(272,136), "S16701C1.s16701c1f34");
    check_field_offset(lv, s16701c1f35, ABISELECT(280,140), "S16701C1.s16701c1f35");
    check_field_offset(lv, s16701c1f36, ABISELECT(288,144), "S16701C1.s16701c1f36");
    check_field_offset(lv, s16701c1f37, ABISELECT(296,148), "S16701C1.s16701c1f37");
    check_field_offset(lv, s16701c1f38, ABISELECT(304,152), "S16701C1.s16701c1f38");
    check_field_offset(lv, s16701c1f39, ABISELECT(312,156), "S16701C1.s16701c1f39");
    check_field_offset(lv, s16701c1f40, ABISELECT(320,160), "S16701C1.s16701c1f40");
    check_field_offset(lv, s16701c1f41, ABISELECT(328,164), "S16701C1.s16701c1f41");
    check_field_offset(lv, s16701c1f42, ABISELECT(336,168), "S16701C1.s16701c1f42");
    check_field_offset(lv, s16701c1f43, ABISELECT(344,172), "S16701C1.s16701c1f43");
    check_field_offset(lv, s16701c1f44, ABISELECT(352,176), "S16701C1.s16701c1f44");
    check_field_offset(lv, s16701c1f45, ABISELECT(360,180), "S16701C1.s16701c1f45");
    check_field_offset(lv, s16701c1f46, ABISELECT(368,184), "S16701C1.s16701c1f46");
    check_field_offset(lv, s16701c1f47, ABISELECT(376,188), "S16701C1.s16701c1f47");
    check_field_offset(lv, s16701c1f48, ABISELECT(384,192), "S16701C1.s16701c1f48");
    check_field_offset(lv, s16701c1f49, ABISELECT(392,196), "S16701C1.s16701c1f49");
    check_field_offset(lv, s16701c1f50, ABISELECT(400,200), "S16701C1.s16701c1f50");
    check_field_offset(lv, s16701c1f51, ABISELECT(408,204), "S16701C1.s16701c1f51");
    check_field_offset(lv, s16701c1f52, ABISELECT(416,208), "S16701C1.s16701c1f52");
    check_field_offset(lv, s16701c1f53, ABISELECT(424,212), "S16701C1.s16701c1f53");
    check_field_offset(lv, s16701c1f54, ABISELECT(432,216), "S16701C1.s16701c1f54");
    check_field_offset(lv, s16701c1f55, ABISELECT(440,220), "S16701C1.s16701c1f55");
    check_field_offset(lv, s16701c1f56, ABISELECT(448,224), "S16701C1.s16701c1f56");
    check_field_offset(lv, s16701c1f57, ABISELECT(456,228), "S16701C1.s16701c1f57");
    check_field_offset(lv, s16701c1f58, ABISELECT(464,232), "S16701C1.s16701c1f58");
    check_field_offset(lv, s16701c1f59, ABISELECT(472,236), "S16701C1.s16701c1f59");
    check_field_offset(lv, s16701c1f60, ABISELECT(480,240), "S16701C1.s16701c1f60");
    check_field_offset(lv, s16701c1f61, ABISELECT(488,244), "S16701C1.s16701c1f61");
    check_field_offset(lv, s16701c1f62, ABISELECT(496,248), "S16701C1.s16701c1f62");
    check_field_offset(lv, s16701c1f63, ABISELECT(504,252), "S16701C1.s16701c1f63");
    check_field_offset(lv, s16701c1f64, ABISELECT(512,256), "S16701C1.s16701c1f64");
    check_field_offset(lv, s16701c1f65, ABISELECT(520,260), "S16701C1.s16701c1f65");
    check_field_offset(lv, s16701c1f66, ABISELECT(528,264), "S16701C1.s16701c1f66");
    check_field_offset(lv, s16701c1f67, ABISELECT(536,268), "S16701C1.s16701c1f67");
    check_field_offset(lv, s16701c1f68, ABISELECT(544,272), "S16701C1.s16701c1f68");
    check_field_offset(lv, s16701c1f69, ABISELECT(552,276), "S16701C1.s16701c1f69");
    check_field_offset(lv, s16701c1f70, ABISELECT(560,280), "S16701C1.s16701c1f70");
    check_field_offset(lv, s16701c1f71, ABISELECT(568,284), "S16701C1.s16701c1f71");
    check_field_offset(lv, s16701c1f72, ABISELECT(576,288), "S16701C1.s16701c1f72");
    check_field_offset(lv, s16701c1f73, ABISELECT(584,292), "S16701C1.s16701c1f73");
    check_field_offset(lv, s16701c1f74, ABISELECT(592,296), "S16701C1.s16701c1f74");
    check_field_offset(lv, s16701c1f75, ABISELECT(600,300), "S16701C1.s16701c1f75");
    check_field_offset(lv, s16701c1f76, ABISELECT(608,304), "S16701C1.s16701c1f76");
    check_field_offset(lv, s16701c1f77, ABISELECT(616,308), "S16701C1.s16701c1f77");
    check_field_offset(lv, s16701c1f78, ABISELECT(624,312), "S16701C1.s16701c1f78");
    check_field_offset(lv, s16701c1f79, ABISELECT(632,316), "S16701C1.s16701c1f79");
    check_field_offset(lv, s16701c1f80, ABISELECT(640,320), "S16701C1.s16701c1f80");
    check_field_offset(lv, s16701c1f81, ABISELECT(648,324), "S16701C1.s16701c1f81");
    check_field_offset(lv, s16701c1f82, ABISELECT(656,328), "S16701C1.s16701c1f82");
    check_field_offset(lv, s16701c1f83, ABISELECT(664,332), "S16701C1.s16701c1f83");
    check_field_offset(lv, s16701c1f84, ABISELECT(672,336), "S16701C1.s16701c1f84");
    check_field_offset(lv, s16701c1f85, ABISELECT(680,340), "S16701C1.s16701c1f85");
    check_field_offset(lv, s16701c1f86, ABISELECT(688,344), "S16701C1.s16701c1f86");
    check_field_offset(lv, s16701c1f87, ABISELECT(696,348), "S16701C1.s16701c1f87");
    check_field_offset(lv, s16701c1f88, ABISELECT(704,352), "S16701C1.s16701c1f88");
    check_field_offset(lv, s16701c1f89, ABISELECT(712,356), "S16701C1.s16701c1f89");
    check_field_offset(lv, s16701c1f90, ABISELECT(720,360), "S16701C1.s16701c1f90");
    check_field_offset(lv, s16701c1f91, ABISELECT(728,364), "S16701C1.s16701c1f91");
    check_field_offset(lv, s16701c1f92, ABISELECT(736,368), "S16701C1.s16701c1f92");
    check_field_offset(lv, s16701c1f93, ABISELECT(744,372), "S16701C1.s16701c1f93");
    check_field_offset(lv, s16701c1f94, ABISELECT(752,376), "S16701C1.s16701c1f94");
    check_field_offset(lv, s16701c1f95, ABISELECT(760,380), "S16701C1.s16701c1f95");
    check_field_offset(lv, s16701c1f96, ABISELECT(768,384), "S16701C1.s16701c1f96");
    check_field_offset(lv, s16701c1f97, ABISELECT(776,388), "S16701C1.s16701c1f97");
    check_field_offset(lv, s16701c1f98, ABISELECT(784,392), "S16701C1.s16701c1f98");
    check_field_offset(lv, s16701c1f99, ABISELECT(792,396), "S16701C1.s16701c1f99");
    check_field_offset(lv, s16701c1f100, ABISELECT(800,400), "S16701C1.s16701c1f100");
    check_field_offset(lv, s16701c1f101, ABISELECT(808,404), "S16701C1.s16701c1f101");
    check_field_offset(lv, s16701c1f102, ABISELECT(816,408), "S16701C1.s16701c1f102");
    check_field_offset(lv, s16701c1f103, ABISELECT(824,412), "S16701C1.s16701c1f103");
    check_field_offset(lv, s16701c1f104, ABISELECT(832,416), "S16701C1.s16701c1f104");
    check_field_offset(lv, s16701c1f105, ABISELECT(840,420), "S16701C1.s16701c1f105");
    check_field_offset(lv, s16701c1f106, ABISELECT(848,424), "S16701C1.s16701c1f106");
    check_field_offset(lv, s16701c1f107, ABISELECT(856,428), "S16701C1.s16701c1f107");
    check_field_offset(lv, s16701c1f108, ABISELECT(864,432), "S16701C1.s16701c1f108");
    check_field_offset(lv, s16701c1f109, ABISELECT(872,436), "S16701C1.s16701c1f109");
    check_field_offset(lv, s16701c1f110, ABISELECT(880,440), "S16701C1.s16701c1f110");
    check_field_offset(lv, s16701c1f111, ABISELECT(888,444), "S16701C1.s16701c1f111");
    check_field_offset(lv, s16701c1f112, ABISELECT(896,448), "S16701C1.s16701c1f112");
    check_field_offset(lv, s16701c1f113, ABISELECT(904,452), "S16701C1.s16701c1f113");
    check_field_offset(lv, s16701c1f114, ABISELECT(912,456), "S16701C1.s16701c1f114");
    check_field_offset(lv, s16701c1f115, ABISELECT(920,460), "S16701C1.s16701c1f115");
    check_field_offset(lv, s16701c1f116, ABISELECT(928,464), "S16701C1.s16701c1f116");
    check_field_offset(lv, s16701c1f117, ABISELECT(936,468), "S16701C1.s16701c1f117");
    check_field_offset(lv, s16701c1f118, ABISELECT(944,472), "S16701C1.s16701c1f118");
    check_field_offset(lv, s16701c1f119, ABISELECT(952,476), "S16701C1.s16701c1f119");
    check_field_offset(lv, s16701c1f120, ABISELECT(960,480), "S16701C1.s16701c1f120");
    check_field_offset(lv, s16701c1f121, ABISELECT(968,484), "S16701C1.s16701c1f121");
    check_field_offset(lv, s16701c1f122, ABISELECT(976,488), "S16701C1.s16701c1f122");
    check_field_offset(lv, s16701c1f123, ABISELECT(984,492), "S16701C1.s16701c1f123");
    check_field_offset(lv, s16701c1f124, ABISELECT(992,496), "S16701C1.s16701c1f124");
    check_field_offset(lv, s16701c1f125, ABISELECT(1000,500), "S16701C1.s16701c1f125");
    check_field_offset(lv, s16701c1f126, ABISELECT(1008,504), "S16701C1.s16701c1f126");
    check_field_offset(lv, s16701c1f127, ABISELECT(1016,508), "S16701C1.s16701c1f127");
    check_field_offset(lv, s16701c1f128, ABISELECT(1024,512), "S16701C1.s16701c1f128");
    check_field_offset(lv, s16701c1f129, ABISELECT(1032,516), "S16701C1.s16701c1f129");
    check_field_offset(lv, s16701c1f130, ABISELECT(1040,520), "S16701C1.s16701c1f130");
    check_field_offset(lv, s16701c1f131, ABISELECT(1048,524), "S16701C1.s16701c1f131");
    check_field_offset(lv, s16701c1f132, ABISELECT(1056,528), "S16701C1.s16701c1f132");
    check_field_offset(lv, s16701c1f133, ABISELECT(1064,532), "S16701C1.s16701c1f133");
    check_field_offset(lv, s16701c1f134, ABISELECT(1072,536), "S16701C1.s16701c1f134");
    check_field_offset(lv, s16701c1f135, ABISELECT(1080,540), "S16701C1.s16701c1f135");
    check_field_offset(lv, s16701c1f136, ABISELECT(1088,544), "S16701C1.s16701c1f136");
    check_field_offset(lv, s16701c1f137, ABISELECT(1096,548), "S16701C1.s16701c1f137");
    check_field_offset(lv, s16701c1f138, ABISELECT(1104,552), "S16701C1.s16701c1f138");
    check_field_offset(lv, s16701c1f139, ABISELECT(1112,556), "S16701C1.s16701c1f139");
    check_field_offset(lv, s16701c1f140, ABISELECT(1120,560), "S16701C1.s16701c1f140");
    check_field_offset(lv, s16701c1f141, ABISELECT(1128,564), "S16701C1.s16701c1f141");
    check_field_offset(lv, s16701c1f142, ABISELECT(1136,568), "S16701C1.s16701c1f142");
    check_field_offset(lv, s16701c1f143, ABISELECT(1144,572), "S16701C1.s16701c1f143");
    check_field_offset(lv, s16701c1f144, ABISELECT(1152,576), "S16701C1.s16701c1f144");
    check_field_offset(lv, s16701c1f145, ABISELECT(1160,580), "S16701C1.s16701c1f145");
    check_field_offset(lv, s16701c1f146, ABISELECT(1168,584), "S16701C1.s16701c1f146");
    check_field_offset(lv, s16701c1f147, ABISELECT(1176,588), "S16701C1.s16701c1f147");
    check_field_offset(lv, s16701c1f148, ABISELECT(1184,592), "S16701C1.s16701c1f148");
    check_field_offset(lv, s16701c1f149, ABISELECT(1192,596), "S16701C1.s16701c1f149");
    check_field_offset(lv, s16701c1f150, ABISELECT(1200,600), "S16701C1.s16701c1f150");
    check_field_offset(lv, s16701c1f151, ABISELECT(1208,604), "S16701C1.s16701c1f151");
    check_field_offset(lv, s16701c1f152, ABISELECT(1216,608), "S16701C1.s16701c1f152");
    check_field_offset(lv, s16701c1f153, ABISELECT(1224,612), "S16701C1.s16701c1f153");
    check_field_offset(lv, s16701c1f154, ABISELECT(1232,616), "S16701C1.s16701c1f154");
    check_field_offset(lv, s16701c1f155, ABISELECT(1240,620), "S16701C1.s16701c1f155");
    check_field_offset(lv, s16701c1f156, ABISELECT(1248,624), "S16701C1.s16701c1f156");
    check_field_offset(lv, s16701c1f157, ABISELECT(1256,628), "S16701C1.s16701c1f157");
    check_field_offset(lv, s16701c1f158, ABISELECT(1264,632), "S16701C1.s16701c1f158");
    check_field_offset(lv, s16701c1f159, ABISELECT(1272,636), "S16701C1.s16701c1f159");
    check_field_offset(lv, s16701c1f160, ABISELECT(1280,640), "S16701C1.s16701c1f160");
    check_field_offset(lv, s16701c1f161, ABISELECT(1288,644), "S16701C1.s16701c1f161");
    check_field_offset(lv, s16701c1f162, ABISELECT(1296,648), "S16701C1.s16701c1f162");
    check_field_offset(lv, s16701c1f163, ABISELECT(1304,652), "S16701C1.s16701c1f163");
    check_field_offset(lv, s16701c1f164, ABISELECT(1312,656), "S16701C1.s16701c1f164");
    check_field_offset(lv, s16701c1f165, ABISELECT(1320,660), "S16701C1.s16701c1f165");
    check_field_offset(lv, s16701c1f166, ABISELECT(1328,664), "S16701C1.s16701c1f166");
    check_field_offset(lv, s16701c1f167, ABISELECT(1336,668), "S16701C1.s16701c1f167");
    check_field_offset(lv, s16701c1f168, ABISELECT(1344,672), "S16701C1.s16701c1f168");
    check_field_offset(lv, s16701c1f169, ABISELECT(1352,676), "S16701C1.s16701c1f169");
    check_field_offset(lv, s16701c1f170, ABISELECT(1360,680), "S16701C1.s16701c1f170");
    check_field_offset(lv, s16701c1f171, ABISELECT(1368,684), "S16701C1.s16701c1f171");
    check_field_offset(lv, s16701c1f172, ABISELECT(1376,688), "S16701C1.s16701c1f172");
    check_field_offset(lv, s16701c1f173, ABISELECT(1384,692), "S16701C1.s16701c1f173");
    check_field_offset(lv, s16701c1f174, ABISELECT(1392,696), "S16701C1.s16701c1f174");
    check_field_offset(lv, s16701c1f175, ABISELECT(1400,700), "S16701C1.s16701c1f175");
    check_field_offset(lv, s16701c1f176, ABISELECT(1408,704), "S16701C1.s16701c1f176");
    check_field_offset(lv, s16701c1f177, ABISELECT(1416,708), "S16701C1.s16701c1f177");
    check_field_offset(lv, s16701c1f178, ABISELECT(1424,712), "S16701C1.s16701c1f178");
    check_field_offset(lv, s16701c1f179, ABISELECT(1432,716), "S16701C1.s16701c1f179");
    check_field_offset(lv, s16701c1f180, ABISELECT(1440,720), "S16701C1.s16701c1f180");
    check_field_offset(lv, s16701c1f181, ABISELECT(1448,724), "S16701C1.s16701c1f181");
    check_field_offset(lv, s16701c1f182, ABISELECT(1456,728), "S16701C1.s16701c1f182");
    check_field_offset(lv, s16701c1f183, ABISELECT(1464,732), "S16701C1.s16701c1f183");
    check_field_offset(lv, s16701c1f184, ABISELECT(1472,736), "S16701C1.s16701c1f184");
    check_field_offset(lv, s16701c1f185, ABISELECT(1480,740), "S16701C1.s16701c1f185");
    check_field_offset(lv, s16701c1f186, ABISELECT(1488,744), "S16701C1.s16701c1f186");
    check_field_offset(lv, s16701c1f187, ABISELECT(1496,748), "S16701C1.s16701c1f187");
    check_field_offset(lv, s16701c1f188, ABISELECT(1504,752), "S16701C1.s16701c1f188");
    check_field_offset(lv, s16701c1f189, ABISELECT(1512,756), "S16701C1.s16701c1f189");
    check_field_offset(lv, s16701c1f190, ABISELECT(1520,760), "S16701C1.s16701c1f190");
    check_field_offset(lv, s16701c1f191, ABISELECT(1528,764), "S16701C1.s16701c1f191");
    check_field_offset(lv, s16701c1f192, ABISELECT(1536,768), "S16701C1.s16701c1f192");
    check_field_offset(lv, s16701c1f193, ABISELECT(1544,772), "S16701C1.s16701c1f193");
    check_field_offset(lv, s16701c1f194, ABISELECT(1552,776), "S16701C1.s16701c1f194");
    check_field_offset(lv, s16701c1f195, ABISELECT(1560,780), "S16701C1.s16701c1f195");
    check_field_offset(lv, s16701c1f196, ABISELECT(1568,784), "S16701C1.s16701c1f196");
    check_field_offset(lv, s16701c1f197, ABISELECT(1576,788), "S16701C1.s16701c1f197");
    check_field_offset(lv, s16701c1f198, ABISELECT(1584,792), "S16701C1.s16701c1f198");
    check_field_offset(lv, s16701c1f199, ABISELECT(1592,796), "S16701C1.s16701c1f199");
    check_field_offset(lv, s16701c1f200, ABISELECT(1600,800), "S16701C1.s16701c1f200");
    check_field_offset(lv, s16701c1f201, ABISELECT(1608,804), "S16701C1.s16701c1f201");
    check_field_offset(lv, s16701c1f202, ABISELECT(1616,808), "S16701C1.s16701c1f202");
    check_field_offset(lv, s16701c1f203, ABISELECT(1624,812), "S16701C1.s16701c1f203");
    check_field_offset(lv, s16701c1f204, ABISELECT(1632,816), "S16701C1.s16701c1f204");
    check_field_offset(lv, s16701c1f205, ABISELECT(1640,820), "S16701C1.s16701c1f205");
  }
}
static Arrange_To_Call_Me vS16701C1(Test_S16701C1, "S16701C1", ABISELECT(1648,824));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S75C7  {
  int s75c7f0;
  __tsi64 s75c7f1;
  void *s75c7f2[4];
  int s75c7f3[2];
  void *s75c7f4;
  ::S3216C4_nt s75c7f5;
  void *s75c7f6[2];
  virtual  ~S75C7(); // _ZN5S75C7D1Ev
  virtual void  v4(); // _ZN5S75C72v4Ev
  virtual void  v5(); // _ZN5S75C72v5Ev
  virtual void  v6(); // _ZN5S75C72v6Ev
  virtual void  v7(); // _ZN5S75C72v7Ev
  virtual void  v8(); // _ZN5S75C72v8Ev
  virtual void  v9(); // _ZN5S75C72v9Ev
  virtual void  v10(); // _ZN5S75C73v10Ev
  virtual void  v11(); // _ZN5S75C73v11Ev
  virtual void  v12(); // _ZN5S75C73v12Ev
  virtual void  v13(); // _ZN5S75C73v13Ev
  virtual void  v14(); // _ZN5S75C73v14Ev
  virtual void  v15(); // _ZN5S75C73v15Ev
  virtual void  v16(); // _ZN5S75C73v16Ev
  virtual void  v17(); // _ZN5S75C73v17Ev
  virtual void  v18(); // _ZN5S75C73v18Ev
  virtual void  v19(); // _ZN5S75C73v19Ev
  virtual void  v20(); // _ZN5S75C73v20Ev
  virtual void  v21(); // _ZN5S75C73v21Ev
  virtual void  v22(); // _ZN5S75C73v22Ev
  virtual void  v23(); // _ZN5S75C73v23Ev
  virtual void  v24(); // _ZN5S75C73v24Ev
  virtual void  v25(); // _ZN5S75C73v25Ev
  virtual void  v26(); // _ZN5S75C73v26Ev
  virtual void  v27(); // _ZN5S75C73v27Ev
  virtual void  v28(); // _ZN5S75C73v28Ev
  virtual void  v29(); // _ZN5S75C73v29Ev
  virtual void  v30(); // _ZN5S75C73v30Ev
  virtual void  v31(); // _ZN5S75C73v31Ev
  virtual void  v32(); // _ZN5S75C73v32Ev
  virtual void  v33(); // _ZN5S75C73v33Ev
  virtual void  v34(); // _ZN5S75C73v34Ev
  virtual void  v35(); // _ZN5S75C73v35Ev
  virtual void  v36(); // _ZN5S75C73v36Ev
  virtual void  v37(); // _ZN5S75C73v37Ev
  virtual void  v38(); // _ZN5S75C73v38Ev
  virtual void  v39(); // _ZN5S75C73v39Ev
  virtual void  v40(); // _ZN5S75C73v40Ev
  virtual void  v41(); // _ZN5S75C73v41Ev
  virtual void  v42(); // _ZN5S75C73v42Ev
  virtual void  v43(); // _ZN5S75C73v43Ev
  virtual void  v44(); // _ZN5S75C73v44Ev
  virtual void  v45(); // _ZN5S75C73v45Ev
  virtual void  v46(); // _ZN5S75C73v46Ev
  virtual void  v47(); // _ZN5S75C73v47Ev
  virtual void  v48(); // _ZN5S75C73v48Ev
  virtual void  v49(); // _ZN5S75C73v49Ev
  virtual void  v50(); // _ZN5S75C73v50Ev
  virtual void  v51(); // _ZN5S75C73v51Ev
  virtual void  v52(); // _ZN5S75C73v52Ev
  virtual void  v53(); // _ZN5S75C73v53Ev
  virtual void  v54(); // _ZN5S75C73v54Ev
  virtual void  v55(); // _ZN5S75C73v55Ev
  virtual void  v56(); // _ZN5S75C73v56Ev
  virtual void  v57(); // _ZN5S75C73v57Ev
  virtual void  v58(); // _ZN5S75C73v58Ev
  virtual void  v59(); // _ZN5S75C73v59Ev
  virtual void  v60(); // _ZN5S75C73v60Ev
  virtual void  v61(); // _ZN5S75C73v61Ev
  virtual void  v62(); // _ZN5S75C73v62Ev
  virtual void  v63(); // _ZN5S75C73v63Ev
  virtual void  v64(); // _ZN5S75C73v64Ev
  virtual void  v65(); // _ZN5S75C73v65Ev
  virtual void  v66(); // _ZN5S75C73v66Ev
  virtual void  v67(); // _ZN5S75C73v67Ev
  S75C7(); // tgen
};
//SIG(-1 S75C7) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S75C7 ::~S75C7(){ note_dtor("S75C7", this);}
void  S75C7 ::v4(){vfunc_called(this, "_ZN5S75C72v4Ev");}
void  S75C7 ::v5(){vfunc_called(this, "_ZN5S75C72v5Ev");}
void  S75C7 ::v6(){vfunc_called(this, "_ZN5S75C72v6Ev");}
void  S75C7 ::v7(){vfunc_called(this, "_ZN5S75C72v7Ev");}
void  S75C7 ::v8(){vfunc_called(this, "_ZN5S75C72v8Ev");}
void  S75C7 ::v9(){vfunc_called(this, "_ZN5S75C72v9Ev");}
void  S75C7 ::v10(){vfunc_called(this, "_ZN5S75C73v10Ev");}
void  S75C7 ::v11(){vfunc_called(this, "_ZN5S75C73v11Ev");}
void  S75C7 ::v12(){vfunc_called(this, "_ZN5S75C73v12Ev");}
void  S75C7 ::v13(){vfunc_called(this, "_ZN5S75C73v13Ev");}
void  S75C7 ::v14(){vfunc_called(this, "_ZN5S75C73v14Ev");}
void  S75C7 ::v15(){vfunc_called(this, "_ZN5S75C73v15Ev");}
void  S75C7 ::v16(){vfunc_called(this, "_ZN5S75C73v16Ev");}
void  S75C7 ::v17(){vfunc_called(this, "_ZN5S75C73v17Ev");}
void  S75C7 ::v18(){vfunc_called(this, "_ZN5S75C73v18Ev");}
void  S75C7 ::v19(){vfunc_called(this, "_ZN5S75C73v19Ev");}
void  S75C7 ::v20(){vfunc_called(this, "_ZN5S75C73v20Ev");}
void  S75C7 ::v21(){vfunc_called(this, "_ZN5S75C73v21Ev");}
void  S75C7 ::v22(){vfunc_called(this, "_ZN5S75C73v22Ev");}
void  S75C7 ::v23(){vfunc_called(this, "_ZN5S75C73v23Ev");}
void  S75C7 ::v24(){vfunc_called(this, "_ZN5S75C73v24Ev");}
void  S75C7 ::v25(){vfunc_called(this, "_ZN5S75C73v25Ev");}
void  S75C7 ::v26(){vfunc_called(this, "_ZN5S75C73v26Ev");}
void  S75C7 ::v27(){vfunc_called(this, "_ZN5S75C73v27Ev");}
void  S75C7 ::v28(){vfunc_called(this, "_ZN5S75C73v28Ev");}
void  S75C7 ::v29(){vfunc_called(this, "_ZN5S75C73v29Ev");}
void  S75C7 ::v30(){vfunc_called(this, "_ZN5S75C73v30Ev");}
void  S75C7 ::v31(){vfunc_called(this, "_ZN5S75C73v31Ev");}
void  S75C7 ::v32(){vfunc_called(this, "_ZN5S75C73v32Ev");}
void  S75C7 ::v33(){vfunc_called(this, "_ZN5S75C73v33Ev");}
void  S75C7 ::v34(){vfunc_called(this, "_ZN5S75C73v34Ev");}
void  S75C7 ::v35(){vfunc_called(this, "_ZN5S75C73v35Ev");}
void  S75C7 ::v36(){vfunc_called(this, "_ZN5S75C73v36Ev");}
void  S75C7 ::v37(){vfunc_called(this, "_ZN5S75C73v37Ev");}
void  S75C7 ::v38(){vfunc_called(this, "_ZN5S75C73v38Ev");}
void  S75C7 ::v39(){vfunc_called(this, "_ZN5S75C73v39Ev");}
void  S75C7 ::v40(){vfunc_called(this, "_ZN5S75C73v40Ev");}
void  S75C7 ::v41(){vfunc_called(this, "_ZN5S75C73v41Ev");}
void  S75C7 ::v42(){vfunc_called(this, "_ZN5S75C73v42Ev");}
void  S75C7 ::v43(){vfunc_called(this, "_ZN5S75C73v43Ev");}
void  S75C7 ::v44(){vfunc_called(this, "_ZN5S75C73v44Ev");}
void  S75C7 ::v45(){vfunc_called(this, "_ZN5S75C73v45Ev");}
void  S75C7 ::v46(){vfunc_called(this, "_ZN5S75C73v46Ev");}
void  S75C7 ::v47(){vfunc_called(this, "_ZN5S75C73v47Ev");}
void  S75C7 ::v48(){vfunc_called(this, "_ZN5S75C73v48Ev");}
void  S75C7 ::v49(){vfunc_called(this, "_ZN5S75C73v49Ev");}
void  S75C7 ::v50(){vfunc_called(this, "_ZN5S75C73v50Ev");}
void  S75C7 ::v51(){vfunc_called(this, "_ZN5S75C73v51Ev");}
void  S75C7 ::v52(){vfunc_called(this, "_ZN5S75C73v52Ev");}
void  S75C7 ::v53(){vfunc_called(this, "_ZN5S75C73v53Ev");}
void  S75C7 ::v54(){vfunc_called(this, "_ZN5S75C73v54Ev");}
void  S75C7 ::v55(){vfunc_called(this, "_ZN5S75C73v55Ev");}
void  S75C7 ::v56(){vfunc_called(this, "_ZN5S75C73v56Ev");}
void  S75C7 ::v57(){vfunc_called(this, "_ZN5S75C73v57Ev");}
void  S75C7 ::v58(){vfunc_called(this, "_ZN5S75C73v58Ev");}
void  S75C7 ::v59(){vfunc_called(this, "_ZN5S75C73v59Ev");}
void  S75C7 ::v60(){vfunc_called(this, "_ZN5S75C73v60Ev");}
void  S75C7 ::v61(){vfunc_called(this, "_ZN5S75C73v61Ev");}
void  S75C7 ::v62(){vfunc_called(this, "_ZN5S75C73v62Ev");}
void  S75C7 ::v63(){vfunc_called(this, "_ZN5S75C73v63Ev");}
void  S75C7 ::v64(){vfunc_called(this, "_ZN5S75C73v64Ev");}
void  S75C7 ::v65(){vfunc_called(this, "_ZN5S75C73v65Ev");}
void  S75C7 ::v66(){vfunc_called(this, "_ZN5S75C73v66Ev");}
void  S75C7 ::v67(){vfunc_called(this, "_ZN5S75C73v67Ev");}
S75C7 ::S75C7(){ note_ctor("S75C7", this);} // tgen

static void Test_S75C7()
{
  extern Class_Descriptor cd_S75C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S75C7, buf);
    S75C7 *dp, &lv = *(dp=new (buf) S75C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S75C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S75C7)");
    check_field_offset(lv, s75c7f0, ABISELECT(8,4), "S75C7.s75c7f0");
    check_field_offset(lv, s75c7f1, ABISELECT(16,8), "S75C7.s75c7f1");
    check_field_offset(lv, s75c7f2, ABISELECT(24,16), "S75C7.s75c7f2");
    check_field_offset(lv, s75c7f3, ABISELECT(56,32), "S75C7.s75c7f3");
    check_field_offset(lv, s75c7f4, ABISELECT(64,40), "S75C7.s75c7f4");
    check_field_offset(lv, s75c7f5, ABISELECT(72,44), "S75C7.s75c7f5");
    check_field_offset(lv, s75c7f6, ABISELECT(80,52), "S75C7.s75c7f6");
    test_class_info(&lv, &cd_S75C7);
    dp->~S75C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS75C7(Test_S75C7, "S75C7", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN5S75C7C1Ev();
extern void _ZN5S75C7D1Ev();
Name_Map name_map_S75C7[] = {
  NSPAIR(_ZN5S75C7C1Ev),
  NSPAIR(_ZN5S75C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI5S75C7[];
extern void _ZN5S75C7D1Ev();
extern void _ZN5S75C7D0Ev();
extern void _ZN5S75C72v4Ev();
extern void _ZN5S75C72v5Ev();
extern void _ZN5S75C72v6Ev();
extern void _ZN5S75C72v7Ev();
extern void _ZN5S75C72v8Ev();
extern void _ZN5S75C72v9Ev();
extern void _ZN5S75C73v10Ev();
extern void _ZN5S75C73v11Ev();
extern void _ZN5S75C73v12Ev();
extern void _ZN5S75C73v13Ev();
extern void _ZN5S75C73v14Ev();
extern void _ZN5S75C73v15Ev();
extern void _ZN5S75C73v16Ev();
extern void _ZN5S75C73v17Ev();
extern void _ZN5S75C73v18Ev();
extern void _ZN5S75C73v19Ev();
extern void _ZN5S75C73v20Ev();
extern void _ZN5S75C73v21Ev();
extern void _ZN5S75C73v22Ev();
extern void _ZN5S75C73v23Ev();
extern void _ZN5S75C73v24Ev();
extern void _ZN5S75C73v25Ev();
extern void _ZN5S75C73v26Ev();
extern void _ZN5S75C73v27Ev();
extern void _ZN5S75C73v28Ev();
extern void _ZN5S75C73v29Ev();
extern void _ZN5S75C73v30Ev();
extern void _ZN5S75C73v31Ev();
extern void _ZN5S75C73v32Ev();
extern void _ZN5S75C73v33Ev();
extern void _ZN5S75C73v34Ev();
extern void _ZN5S75C73v35Ev();
extern void _ZN5S75C73v36Ev();
extern void _ZN5S75C73v37Ev();
extern void _ZN5S75C73v38Ev();
extern void _ZN5S75C73v39Ev();
extern void _ZN5S75C73v40Ev();
extern void _ZN5S75C73v41Ev();
extern void _ZN5S75C73v42Ev();
extern void _ZN5S75C73v43Ev();
extern void _ZN5S75C73v44Ev();
extern void _ZN5S75C73v45Ev();
extern void _ZN5S75C73v46Ev();
extern void _ZN5S75C73v47Ev();
extern void _ZN5S75C73v48Ev();
extern void _ZN5S75C73v49Ev();
extern void _ZN5S75C73v50Ev();
extern void _ZN5S75C73v51Ev();
extern void _ZN5S75C73v52Ev();
extern void _ZN5S75C73v53Ev();
extern void _ZN5S75C73v54Ev();
extern void _ZN5S75C73v55Ev();
extern void _ZN5S75C73v56Ev();
extern void _ZN5S75C73v57Ev();
extern void _ZN5S75C73v58Ev();
extern void _ZN5S75C73v59Ev();
extern void _ZN5S75C73v60Ev();
extern void _ZN5S75C73v61Ev();
extern void _ZN5S75C73v62Ev();
extern void _ZN5S75C73v63Ev();
extern void _ZN5S75C73v64Ev();
extern void _ZN5S75C73v65Ev();
extern void _ZN5S75C73v66Ev();
extern void _ZN5S75C73v67Ev();
static  VTBL_ENTRY vtc_S75C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S75C7[0]),
  (VTBL_ENTRY)&_ZN5S75C7D1Ev,
  (VTBL_ENTRY)&_ZN5S75C7D0Ev,
  (VTBL_ENTRY)&_ZN5S75C72v4Ev,
  (VTBL_ENTRY)&_ZN5S75C72v5Ev,
  (VTBL_ENTRY)&_ZN5S75C72v6Ev,
  (VTBL_ENTRY)&_ZN5S75C72v7Ev,
  (VTBL_ENTRY)&_ZN5S75C72v8Ev,
  (VTBL_ENTRY)&_ZN5S75C72v9Ev,
  (VTBL_ENTRY)&_ZN5S75C73v10Ev,
  (VTBL_ENTRY)&_ZN5S75C73v11Ev,
  (VTBL_ENTRY)&_ZN5S75C73v12Ev,
  (VTBL_ENTRY)&_ZN5S75C73v13Ev,
  (VTBL_ENTRY)&_ZN5S75C73v14Ev,
  (VTBL_ENTRY)&_ZN5S75C73v15Ev,
  (VTBL_ENTRY)&_ZN5S75C73v16Ev,
  (VTBL_ENTRY)&_ZN5S75C73v17Ev,
  (VTBL_ENTRY)&_ZN5S75C73v18Ev,
  (VTBL_ENTRY)&_ZN5S75C73v19Ev,
  (VTBL_ENTRY)&_ZN5S75C73v20Ev,
  (VTBL_ENTRY)&_ZN5S75C73v21Ev,
  (VTBL_ENTRY)&_ZN5S75C73v22Ev,
  (VTBL_ENTRY)&_ZN5S75C73v23Ev,
  (VTBL_ENTRY)&_ZN5S75C73v24Ev,
  (VTBL_ENTRY)&_ZN5S75C73v25Ev,
  (VTBL_ENTRY)&_ZN5S75C73v26Ev,
  (VTBL_ENTRY)&_ZN5S75C73v27Ev,
  (VTBL_ENTRY)&_ZN5S75C73v28Ev,
  (VTBL_ENTRY)&_ZN5S75C73v29Ev,
  (VTBL_ENTRY)&_ZN5S75C73v30Ev,
  (VTBL_ENTRY)&_ZN5S75C73v31Ev,
  (VTBL_ENTRY)&_ZN5S75C73v32Ev,
  (VTBL_ENTRY)&_ZN5S75C73v33Ev,
  (VTBL_ENTRY)&_ZN5S75C73v34Ev,
  (VTBL_ENTRY)&_ZN5S75C73v35Ev,
  (VTBL_ENTRY)&_ZN5S75C73v36Ev,
  (VTBL_ENTRY)&_ZN5S75C73v37Ev,
  (VTBL_ENTRY)&_ZN5S75C73v38Ev,
  (VTBL_ENTRY)&_ZN5S75C73v39Ev,
  (VTBL_ENTRY)&_ZN5S75C73v40Ev,
  (VTBL_ENTRY)&_ZN5S75C73v41Ev,
  (VTBL_ENTRY)&_ZN5S75C73v42Ev,
  (VTBL_ENTRY)&_ZN5S75C73v43Ev,
  (VTBL_ENTRY)&_ZN5S75C73v44Ev,
  (VTBL_ENTRY)&_ZN5S75C73v45Ev,
  (VTBL_ENTRY)&_ZN5S75C73v46Ev,
  (VTBL_ENTRY)&_ZN5S75C73v47Ev,
  (VTBL_ENTRY)&_ZN5S75C73v48Ev,
  (VTBL_ENTRY)&_ZN5S75C73v49Ev,
  (VTBL_ENTRY)&_ZN5S75C73v50Ev,
  (VTBL_ENTRY)&_ZN5S75C73v51Ev,
  (VTBL_ENTRY)&_ZN5S75C73v52Ev,
  (VTBL_ENTRY)&_ZN5S75C73v53Ev,
  (VTBL_ENTRY)&_ZN5S75C73v54Ev,
  (VTBL_ENTRY)&_ZN5S75C73v55Ev,
  (VTBL_ENTRY)&_ZN5S75C73v56Ev,
  (VTBL_ENTRY)&_ZN5S75C73v57Ev,
  (VTBL_ENTRY)&_ZN5S75C73v58Ev,
  (VTBL_ENTRY)&_ZN5S75C73v59Ev,
  (VTBL_ENTRY)&_ZN5S75C73v60Ev,
  (VTBL_ENTRY)&_ZN5S75C73v61Ev,
  (VTBL_ENTRY)&_ZN5S75C73v62Ev,
  (VTBL_ENTRY)&_ZN5S75C73v63Ev,
  (VTBL_ENTRY)&_ZN5S75C73v64Ev,
  (VTBL_ENTRY)&_ZN5S75C73v65Ev,
  (VTBL_ENTRY)&_ZN5S75C73v66Ev,
  (VTBL_ENTRY)&_ZN5S75C73v67Ev,
};
extern VTBL_ENTRY _ZTI5S75C7[];
extern  VTBL_ENTRY _ZTV5S75C7[];
Class_Descriptor cd_S75C7 = {  "S75C7", // class name
  0,0,//no base classes
  &(vtc_S75C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI5S75C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV5S75C7),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S75C11  : S3216C7_nt {
};
//SIG(-1 S75C11) C1{ BC2{ m Fp Fi[2]}}



static void Test_S75C11()
{
  extern Class_Descriptor cd_S75C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S75C11, buf);
    S75C11 &lv = *(new (buf) S75C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S75C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S75C11)");
    check_base_class_offset(lv, (S3216C7_nt*), 0, "S75C11");
    test_class_info(&lv, &cd_S75C11);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS75C11(Test_S75C11, "S75C11", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3216C7_nt;
static Base_Class bases_S75C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S75C11 = {  "S75C11", // class name
  bases_S75C11, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S75C10  : S75C11 {
};
//SIG(-1 S75C10) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S75C10()
{
  extern Class_Descriptor cd_S75C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S75C10, buf);
    S75C10 &lv = *(new (buf) S75C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S75C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S75C10)");
    check_base_class_offset(lv, (S3216C7_nt*)(S75C11*), 0, "S75C10");
    check_base_class_offset(lv, (S75C11*), 0, "S75C10");
    test_class_info(&lv, &cd_S75C10);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS75C10(Test_S75C10, "S75C10", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3216C7_nt;
extern Class_Descriptor cd_S75C11;
static Base_Class bases_S75C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S75C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S75C10 = {  "S75C10", // class name
  bases_S75C10, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S75C9_nt  : S75C10 {
};
//SIG(-1 S75C9_nt) C1{ BC2{ BC3{ BC4{ m Fp Fi[2]}}}}



//skip512 S75C9_nt

#else // __cplusplus

extern Class_Descriptor cd_S3216C7_nt;
extern Class_Descriptor cd_S75C11;
extern Class_Descriptor cd_S75C10;
static Base_Class bases_S75C9_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S75C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S75C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S75C6_nt  : S75C7 {
  int s75c6f0[2];
  void *s75c6f1;
  int s75c6f2[2];
  ::S75C9_nt s75c6f3;
  ::S75C9_nt s75c6f4;
  ::S4677C37 s75c6f5;
  ::S75C9_nt s75c6f6;
  unsigned int s75c6f7:1;
  unsigned int s75c6f8:1;
  unsigned int s75c6f9:1;
  unsigned int s75c6f10:1;
  unsigned int s75c6f11:1;
  int s75c6f12[2];
  virtual  ~S75C6_nt(); // _ZN8S75C6_ntD1Ev
  virtual void  v68(); // _ZN8S75C6_nt3v68Ev
  virtual void  v69(); // _ZN8S75C6_nt3v69Ev
  virtual void  v70(); // _ZN8S75C6_nt3v70Ev
  virtual void  v71(); // _ZN8S75C6_nt3v71Ev
  virtual void  v72(); // _ZN8S75C6_nt3v72Ev
  virtual void  v73(); // _ZN8S75C6_nt3v73Ev
  virtual void  v74(); // _ZN8S75C6_nt3v74Ev
  virtual void  v75(); // _ZN8S75C6_nt3v75Ev
  virtual void  v76(); // _ZN8S75C6_nt3v76Ev
  virtual void  v77(); // _ZN8S75C6_nt3v77Ev
  virtual void  v78(); // _ZN8S75C6_nt3v78Ev
  virtual void  v79(); // _ZN8S75C6_nt3v79Ev
  virtual void  v80(); // _ZN8S75C6_nt3v80Ev
  virtual void  v81(); // _ZN8S75C6_nt3v81Ev
  virtual void  v82(); // _ZN8S75C6_nt3v82Ev
  virtual void  v83(); // _ZN8S75C6_nt3v83Ev
  virtual void  v84(); // _ZN8S75C6_nt3v84Ev
  virtual void  v85(); // _ZN8S75C6_nt3v85Ev
  virtual void  v86(); // _ZN8S75C6_nt3v86Ev
  virtual void  v87(); // _ZN8S75C6_nt3v87Ev
  virtual void  v88(); // _ZN8S75C6_nt3v88Ev
  virtual void  v89(); // _ZN8S75C6_nt3v89Ev
  S75C6_nt(); // tgen
};
//SIG(-1 S75C6_nt) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S75C6_nt ::~S75C6_nt(){ note_dtor("S75C6_nt", this);}
void  S75C6_nt ::v68(){vfunc_called(this, "_ZN8S75C6_nt3v68Ev");}
void  S75C6_nt ::v69(){vfunc_called(this, "_ZN8S75C6_nt3v69Ev");}
void  S75C6_nt ::v70(){vfunc_called(this, "_ZN8S75C6_nt3v70Ev");}
void  S75C6_nt ::v71(){vfunc_called(this, "_ZN8S75C6_nt3v71Ev");}
void  S75C6_nt ::v72(){vfunc_called(this, "_ZN8S75C6_nt3v72Ev");}
void  S75C6_nt ::v73(){vfunc_called(this, "_ZN8S75C6_nt3v73Ev");}
void  S75C6_nt ::v74(){vfunc_called(this, "_ZN8S75C6_nt3v74Ev");}
void  S75C6_nt ::v75(){vfunc_called(this, "_ZN8S75C6_nt3v75Ev");}
void  S75C6_nt ::v76(){vfunc_called(this, "_ZN8S75C6_nt3v76Ev");}
void  S75C6_nt ::v77(){vfunc_called(this, "_ZN8S75C6_nt3v77Ev");}
void  S75C6_nt ::v78(){vfunc_called(this, "_ZN8S75C6_nt3v78Ev");}
void  S75C6_nt ::v79(){vfunc_called(this, "_ZN8S75C6_nt3v79Ev");}
void  S75C6_nt ::v80(){vfunc_called(this, "_ZN8S75C6_nt3v80Ev");}
void  S75C6_nt ::v81(){vfunc_called(this, "_ZN8S75C6_nt3v81Ev");}
void  S75C6_nt ::v82(){vfunc_called(this, "_ZN8S75C6_nt3v82Ev");}
void  S75C6_nt ::v83(){vfunc_called(this, "_ZN8S75C6_nt3v83Ev");}
void  S75C6_nt ::v84(){vfunc_called(this, "_ZN8S75C6_nt3v84Ev");}
void  S75C6_nt ::v85(){vfunc_called(this, "_ZN8S75C6_nt3v85Ev");}
void  S75C6_nt ::v86(){vfunc_called(this, "_ZN8S75C6_nt3v86Ev");}
void  S75C6_nt ::v87(){vfunc_called(this, "_ZN8S75C6_nt3v87Ev");}
void  S75C6_nt ::v88(){vfunc_called(this, "_ZN8S75C6_nt3v88Ev");}
void  S75C6_nt ::v89(){vfunc_called(this, "_ZN8S75C6_nt3v89Ev");}
S75C6_nt ::S75C6_nt(){ note_ctor("S75C6_nt", this);} // tgen

//skip512 S75C6_nt

#else // __cplusplus

extern void _ZN8S75C6_ntC1Ev();
extern void _ZN8S75C6_ntD1Ev();
Name_Map name_map_S75C6_nt[] = {
  NSPAIR(_ZN8S75C6_ntC1Ev),
  NSPAIR(_ZN8S75C6_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S75C7;
extern VTBL_ENTRY _ZTI5S75C7[];
extern  VTBL_ENTRY _ZTV5S75C7[];
static Base_Class bases_S75C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S75C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S75C6_nt[];
extern void _ZN8S75C6_ntD1Ev();
extern void _ZN8S75C6_ntD0Ev();
extern void _ZN5S75C72v4Ev();
extern void _ZN5S75C72v5Ev();
extern void _ZN5S75C72v6Ev();
extern void _ZN5S75C72v7Ev();
extern void _ZN5S75C72v8Ev();
extern void _ZN5S75C72v9Ev();
extern void _ZN5S75C73v10Ev();
extern void _ZN5S75C73v11Ev();
extern void _ZN5S75C73v12Ev();
extern void _ZN5S75C73v13Ev();
extern void _ZN5S75C73v14Ev();
extern void _ZN5S75C73v15Ev();
extern void _ZN5S75C73v16Ev();
extern void _ZN5S75C73v17Ev();
extern void _ZN5S75C73v18Ev();
extern void _ZN5S75C73v19Ev();
extern void _ZN5S75C73v20Ev();
extern void _ZN5S75C73v21Ev();
extern void _ZN5S75C73v22Ev();
extern void _ZN5S75C73v23Ev();
extern void _ZN5S75C73v24Ev();
extern void _ZN5S75C73v25Ev();
extern void _ZN5S75C73v26Ev();
extern void _ZN5S75C73v27Ev();
extern void _ZN5S75C73v28Ev();
extern void _ZN5S75C73v29Ev();
extern void _ZN5S75C73v30Ev();
extern void _ZN5S75C73v31Ev();
extern void _ZN5S75C73v32Ev();
extern void _ZN5S75C73v33Ev();
extern void _ZN5S75C73v34Ev();
extern void _ZN5S75C73v35Ev();
extern void _ZN5S75C73v36Ev();
extern void _ZN5S75C73v37Ev();
extern void _ZN5S75C73v38Ev();
extern void _ZN5S75C73v39Ev();
extern void _ZN5S75C73v40Ev();
extern void _ZN5S75C73v41Ev();
extern void _ZN5S75C73v42Ev();
extern void _ZN5S75C73v43Ev();
extern void _ZN5S75C73v44Ev();
extern void _ZN5S75C73v45Ev();
extern void _ZN5S75C73v46Ev();
extern void _ZN5S75C73v47Ev();
extern void _ZN5S75C73v48Ev();
extern void _ZN5S75C73v49Ev();
extern void _ZN5S75C73v50Ev();
extern void _ZN5S75C73v51Ev();
extern void _ZN5S75C73v52Ev();
extern void _ZN5S75C73v53Ev();
extern void _ZN5S75C73v54Ev();
extern void _ZN5S75C73v55Ev();
extern void _ZN5S75C73v56Ev();
extern void _ZN5S75C73v57Ev();
extern void _ZN5S75C73v58Ev();
extern void _ZN5S75C73v59Ev();
extern void _ZN5S75C73v60Ev();
extern void _ZN5S75C73v61Ev();
extern void _ZN5S75C73v62Ev();
extern void _ZN5S75C73v63Ev();
extern void _ZN5S75C73v64Ev();
extern void _ZN5S75C73v65Ev();
extern void _ZN5S75C73v66Ev();
extern void _ZN5S75C73v67Ev();
extern void _ZN8S75C6_nt3v68Ev();
extern void _ZN8S75C6_nt3v69Ev();
extern void _ZN8S75C6_nt3v70Ev();
extern void _ZN8S75C6_nt3v71Ev();
extern void _ZN8S75C6_nt3v72Ev();
extern void _ZN8S75C6_nt3v73Ev();
extern void _ZN8S75C6_nt3v74Ev();
extern void _ZN8S75C6_nt3v75Ev();
extern void _ZN8S75C6_nt3v76Ev();
extern void _ZN8S75C6_nt3v77Ev();
extern void _ZN8S75C6_nt3v78Ev();
extern void _ZN8S75C6_nt3v79Ev();
extern void _ZN8S75C6_nt3v80Ev();
extern void _ZN8S75C6_nt3v81Ev();
extern void _ZN8S75C6_nt3v82Ev();
extern void _ZN8S75C6_nt3v83Ev();
extern void _ZN8S75C6_nt3v84Ev();
extern void _ZN8S75C6_nt3v85Ev();
extern void _ZN8S75C6_nt3v86Ev();
extern void _ZN8S75C6_nt3v87Ev();
extern void _ZN8S75C6_nt3v88Ev();
extern void _ZN8S75C6_nt3v89Ev();
static  VTBL_ENTRY vtc_S75C6_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S75C6_nt[0]),
  (VTBL_ENTRY)&_ZN8S75C6_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S75C6_ntD0Ev,
  (VTBL_ENTRY)&_ZN5S75C72v4Ev,
  (VTBL_ENTRY)&_ZN5S75C72v5Ev,
  (VTBL_ENTRY)&_ZN5S75C72v6Ev,
  (VTBL_ENTRY)&_ZN5S75C72v7Ev,
  (VTBL_ENTRY)&_ZN5S75C72v8Ev,
  (VTBL_ENTRY)&_ZN5S75C72v9Ev,
  (VTBL_ENTRY)&_ZN5S75C73v10Ev,
  (VTBL_ENTRY)&_ZN5S75C73v11Ev,
  (VTBL_ENTRY)&_ZN5S75C73v12Ev,
  (VTBL_ENTRY)&_ZN5S75C73v13Ev,
  (VTBL_ENTRY)&_ZN5S75C73v14Ev,
  (VTBL_ENTRY)&_ZN5S75C73v15Ev,
  (VTBL_ENTRY)&_ZN5S75C73v16Ev,
  (VTBL_ENTRY)&_ZN5S75C73v17Ev,
  (VTBL_ENTRY)&_ZN5S75C73v18Ev,
  (VTBL_ENTRY)&_ZN5S75C73v19Ev,
  (VTBL_ENTRY)&_ZN5S75C73v20Ev,
  (VTBL_ENTRY)&_ZN5S75C73v21Ev,
  (VTBL_ENTRY)&_ZN5S75C73v22Ev,
  (VTBL_ENTRY)&_ZN5S75C73v23Ev,
  (VTBL_ENTRY)&_ZN5S75C73v24Ev,
  (VTBL_ENTRY)&_ZN5S75C73v25Ev,
  (VTBL_ENTRY)&_ZN5S75C73v26Ev,
  (VTBL_ENTRY)&_ZN5S75C73v27Ev,
  (VTBL_ENTRY)&_ZN5S75C73v28Ev,
  (VTBL_ENTRY)&_ZN5S75C73v29Ev,
  (VTBL_ENTRY)&_ZN5S75C73v30Ev,
  (VTBL_ENTRY)&_ZN5S75C73v31Ev,
  (VTBL_ENTRY)&_ZN5S75C73v32Ev,
  (VTBL_ENTRY)&_ZN5S75C73v33Ev,
  (VTBL_ENTRY)&_ZN5S75C73v34Ev,
  (VTBL_ENTRY)&_ZN5S75C73v35Ev,
  (VTBL_ENTRY)&_ZN5S75C73v36Ev,
  (VTBL_ENTRY)&_ZN5S75C73v37Ev,
  (VTBL_ENTRY)&_ZN5S75C73v38Ev,
  (VTBL_ENTRY)&_ZN5S75C73v39Ev,
  (VTBL_ENTRY)&_ZN5S75C73v40Ev,
  (VTBL_ENTRY)&_ZN5S75C73v41Ev,
  (VTBL_ENTRY)&_ZN5S75C73v42Ev,
  (VTBL_ENTRY)&_ZN5S75C73v43Ev,
  (VTBL_ENTRY)&_ZN5S75C73v44Ev,
  (VTBL_ENTRY)&_ZN5S75C73v45Ev,
  (VTBL_ENTRY)&_ZN5S75C73v46Ev,
  (VTBL_ENTRY)&_ZN5S75C73v47Ev,
  (VTBL_ENTRY)&_ZN5S75C73v48Ev,
  (VTBL_ENTRY)&_ZN5S75C73v49Ev,
  (VTBL_ENTRY)&_ZN5S75C73v50Ev,
  (VTBL_ENTRY)&_ZN5S75C73v51Ev,
  (VTBL_ENTRY)&_ZN5S75C73v52Ev,
  (VTBL_ENTRY)&_ZN5S75C73v53Ev,
  (VTBL_ENTRY)&_ZN5S75C73v54Ev,
  (VTBL_ENTRY)&_ZN5S75C73v55Ev,
  (VTBL_ENTRY)&_ZN5S75C73v56Ev,
  (VTBL_ENTRY)&_ZN5S75C73v57Ev,
  (VTBL_ENTRY)&_ZN5S75C73v58Ev,
  (VTBL_ENTRY)&_ZN5S75C73v59Ev,
  (VTBL_ENTRY)&_ZN5S75C73v60Ev,
  (VTBL_ENTRY)&_ZN5S75C73v61Ev,
  (VTBL_ENTRY)&_ZN5S75C73v62Ev,
  (VTBL_ENTRY)&_ZN5S75C73v63Ev,
  (VTBL_ENTRY)&_ZN5S75C73v64Ev,
  (VTBL_ENTRY)&_ZN5S75C73v65Ev,
  (VTBL_ENTRY)&_ZN5S75C73v66Ev,
  (VTBL_ENTRY)&_ZN5S75C73v67Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v89Ev,
};
extern VTBL_ENTRY _ZTI8S75C6_nt[];
VTBL_ENTRY *P__ZTI8S75C6_nt = _ZTI8S75C6_nt; 
extern  VTBL_ENTRY _ZTV8S75C6_nt[];
Class_Descriptor cd_S75C6_nt = {  "S75C6_nt", // class name
  bases_S75C6_nt, 1,
  &(vtc_S75C6_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI8S75C6_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S75C6_nt),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S75C21  : S3216C7_nt {
};
//SIG(-1 S75C21) C1{ BC2{ m Fp Fi[2]}}



static void Test_S75C21()
{
  extern Class_Descriptor cd_S75C21;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S75C21, buf);
    S75C21 &lv = *(new (buf) S75C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S75C21)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S75C21)");
    check_base_class_offset(lv, (S3216C7_nt*), 0, "S75C21");
    test_class_info(&lv, &cd_S75C21);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS75C21(Test_S75C21, "S75C21", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3216C7_nt;
static Base_Class bases_S75C21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S75C21 = {  "S75C21", // class name
  bases_S75C21, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S75C20  : S75C21 {
};
//SIG(-1 S75C20) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S75C20()
{
  extern Class_Descriptor cd_S75C20;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S75C20, buf);
    S75C20 &lv = *(new (buf) S75C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S75C20)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S75C20)");
    check_base_class_offset(lv, (S3216C7_nt*)(S75C21*), 0, "S75C20");
    check_base_class_offset(lv, (S75C21*), 0, "S75C20");
    test_class_info(&lv, &cd_S75C20);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS75C20(Test_S75C20, "S75C20", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3216C7_nt;
extern Class_Descriptor cd_S75C21;
static Base_Class bases_S75C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S75C21,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S75C20 = {  "S75C20", // class name
  bases_S75C20, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S75C5_nt  : S75C6_nt {
  unsigned int s75c5f0:1;
  unsigned int s75c5f1:1;
  unsigned int s75c5f2:1;
  ::S3216C17 s75c5f3;
  ::S3216C11 s75c5f4;
  ::S3216C5_nt s75c5f5;
  ::S75C20 s75c5f6;
  int s75c5f7[3];
  virtual  ~S75C5_nt(); // _ZN8S75C5_ntD1Ev
  virtual void  v90(); // _ZN8S75C5_nt3v90Ev
  virtual void  v91(); // _ZN8S75C5_nt3v91Ev
  virtual void  v92(); // _ZN8S75C5_nt3v92Ev
  virtual void  v93(); // _ZN8S75C5_nt3v93Ev
  virtual void  v94(); // _ZN8S75C5_nt3v94Ev
  virtual void  v95(); // _ZN8S75C5_nt3v95Ev
  virtual void  v96(); // _ZN8S75C5_nt3v96Ev
  virtual void  v97(); // _ZN8S75C5_nt3v97Ev
  virtual void  v98(); // _ZN8S75C5_nt3v98Ev
  virtual void  v99(); // _ZN8S75C5_nt3v99Ev
  virtual void  v100(); // _ZN8S75C5_nt4v100Ev
  virtual void  v101(); // _ZN8S75C5_nt4v101Ev
  virtual void  v102(); // _ZN8S75C5_nt4v102Ev
  virtual void  v103(); // _ZN8S75C5_nt4v103Ev
  virtual void  v104(); // _ZN8S75C5_nt4v104Ev
  virtual void  v105(); // _ZN8S75C5_nt4v105Ev
  virtual void  v106(); // _ZN8S75C5_nt4v106Ev
  virtual void  v107(); // _ZN8S75C5_nt4v107Ev
  virtual void  v108(); // _ZN8S75C5_nt4v108Ev
  virtual void  v109(); // _ZN8S75C5_nt4v109Ev
  S75C5_nt(); // tgen
};
//SIG(-1 S75C5_nt) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} FC16{ BC17{ BC8}} Fi[3]}


 S75C5_nt ::~S75C5_nt(){ note_dtor("S75C5_nt", this);}
void  S75C5_nt ::v90(){vfunc_called(this, "_ZN8S75C5_nt3v90Ev");}
void  S75C5_nt ::v91(){vfunc_called(this, "_ZN8S75C5_nt3v91Ev");}
void  S75C5_nt ::v92(){vfunc_called(this, "_ZN8S75C5_nt3v92Ev");}
void  S75C5_nt ::v93(){vfunc_called(this, "_ZN8S75C5_nt3v93Ev");}
void  S75C5_nt ::v94(){vfunc_called(this, "_ZN8S75C5_nt3v94Ev");}
void  S75C5_nt ::v95(){vfunc_called(this, "_ZN8S75C5_nt3v95Ev");}
void  S75C5_nt ::v96(){vfunc_called(this, "_ZN8S75C5_nt3v96Ev");}
void  S75C5_nt ::v97(){vfunc_called(this, "_ZN8S75C5_nt3v97Ev");}
void  S75C5_nt ::v98(){vfunc_called(this, "_ZN8S75C5_nt3v98Ev");}
void  S75C5_nt ::v99(){vfunc_called(this, "_ZN8S75C5_nt3v99Ev");}
void  S75C5_nt ::v100(){vfunc_called(this, "_ZN8S75C5_nt4v100Ev");}
void  S75C5_nt ::v101(){vfunc_called(this, "_ZN8S75C5_nt4v101Ev");}
void  S75C5_nt ::v102(){vfunc_called(this, "_ZN8S75C5_nt4v102Ev");}
void  S75C5_nt ::v103(){vfunc_called(this, "_ZN8S75C5_nt4v103Ev");}
void  S75C5_nt ::v104(){vfunc_called(this, "_ZN8S75C5_nt4v104Ev");}
void  S75C5_nt ::v105(){vfunc_called(this, "_ZN8S75C5_nt4v105Ev");}
void  S75C5_nt ::v106(){vfunc_called(this, "_ZN8S75C5_nt4v106Ev");}
void  S75C5_nt ::v107(){vfunc_called(this, "_ZN8S75C5_nt4v107Ev");}
void  S75C5_nt ::v108(){vfunc_called(this, "_ZN8S75C5_nt4v108Ev");}
void  S75C5_nt ::v109(){vfunc_called(this, "_ZN8S75C5_nt4v109Ev");}
S75C5_nt ::S75C5_nt(){ note_ctor("S75C5_nt", this);} // tgen

//skip512 S75C5_nt

#else // __cplusplus

extern void _ZN8S75C5_ntC1Ev();
extern void _ZN8S75C5_ntD1Ev();
Name_Map name_map_S75C5_nt[] = {
  NSPAIR(_ZN8S75C5_ntC1Ev),
  NSPAIR(_ZN8S75C5_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S75C7;
extern VTBL_ENTRY _ZTI5S75C7[];
extern  VTBL_ENTRY _ZTV5S75C7[];
extern Class_Descriptor cd_S75C6_nt;
extern VTBL_ENTRY _ZTI8S75C6_nt[];
extern  VTBL_ENTRY _ZTV8S75C6_nt[];
static Base_Class bases_S75C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S75C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S75C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S75C5_nt[];
extern void _ZN8S75C5_ntD1Ev();
extern void _ZN8S75C5_ntD0Ev();
extern void _ZN5S75C72v4Ev();
extern void _ZN5S75C72v5Ev();
extern void _ZN5S75C72v6Ev();
extern void _ZN5S75C72v7Ev();
extern void _ZN5S75C72v8Ev();
extern void _ZN5S75C72v9Ev();
extern void _ZN5S75C73v10Ev();
extern void _ZN5S75C73v11Ev();
extern void _ZN5S75C73v12Ev();
extern void _ZN5S75C73v13Ev();
extern void _ZN5S75C73v14Ev();
extern void _ZN5S75C73v15Ev();
extern void _ZN5S75C73v16Ev();
extern void _ZN5S75C73v17Ev();
extern void _ZN5S75C73v18Ev();
extern void _ZN5S75C73v19Ev();
extern void _ZN5S75C73v20Ev();
extern void _ZN5S75C73v21Ev();
extern void _ZN5S75C73v22Ev();
extern void _ZN5S75C73v23Ev();
extern void _ZN5S75C73v24Ev();
extern void _ZN5S75C73v25Ev();
extern void _ZN5S75C73v26Ev();
extern void _ZN5S75C73v27Ev();
extern void _ZN5S75C73v28Ev();
extern void _ZN5S75C73v29Ev();
extern void _ZN5S75C73v30Ev();
extern void _ZN5S75C73v31Ev();
extern void _ZN5S75C73v32Ev();
extern void _ZN5S75C73v33Ev();
extern void _ZN5S75C73v34Ev();
extern void _ZN5S75C73v35Ev();
extern void _ZN5S75C73v36Ev();
extern void _ZN5S75C73v37Ev();
extern void _ZN5S75C73v38Ev();
extern void _ZN5S75C73v39Ev();
extern void _ZN5S75C73v40Ev();
extern void _ZN5S75C73v41Ev();
extern void _ZN5S75C73v42Ev();
extern void _ZN5S75C73v43Ev();
extern void _ZN5S75C73v44Ev();
extern void _ZN5S75C73v45Ev();
extern void _ZN5S75C73v46Ev();
extern void _ZN5S75C73v47Ev();
extern void _ZN5S75C73v48Ev();
extern void _ZN5S75C73v49Ev();
extern void _ZN5S75C73v50Ev();
extern void _ZN5S75C73v51Ev();
extern void _ZN5S75C73v52Ev();
extern void _ZN5S75C73v53Ev();
extern void _ZN5S75C73v54Ev();
extern void _ZN5S75C73v55Ev();
extern void _ZN5S75C73v56Ev();
extern void _ZN5S75C73v57Ev();
extern void _ZN5S75C73v58Ev();
extern void _ZN5S75C73v59Ev();
extern void _ZN5S75C73v60Ev();
extern void _ZN5S75C73v61Ev();
extern void _ZN5S75C73v62Ev();
extern void _ZN5S75C73v63Ev();
extern void _ZN5S75C73v64Ev();
extern void _ZN5S75C73v65Ev();
extern void _ZN5S75C73v66Ev();
extern void _ZN5S75C73v67Ev();
extern void _ZN8S75C6_nt3v68Ev();
extern void _ZN8S75C6_nt3v69Ev();
extern void _ZN8S75C6_nt3v70Ev();
extern void _ZN8S75C6_nt3v71Ev();
extern void _ZN8S75C6_nt3v72Ev();
extern void _ZN8S75C6_nt3v73Ev();
extern void _ZN8S75C6_nt3v74Ev();
extern void _ZN8S75C6_nt3v75Ev();
extern void _ZN8S75C6_nt3v76Ev();
extern void _ZN8S75C6_nt3v77Ev();
extern void _ZN8S75C6_nt3v78Ev();
extern void _ZN8S75C6_nt3v79Ev();
extern void _ZN8S75C6_nt3v80Ev();
extern void _ZN8S75C6_nt3v81Ev();
extern void _ZN8S75C6_nt3v82Ev();
extern void _ZN8S75C6_nt3v83Ev();
extern void _ZN8S75C6_nt3v84Ev();
extern void _ZN8S75C6_nt3v85Ev();
extern void _ZN8S75C6_nt3v86Ev();
extern void _ZN8S75C6_nt3v87Ev();
extern void _ZN8S75C6_nt3v88Ev();
extern void _ZN8S75C6_nt3v89Ev();
extern void _ZN8S75C5_nt3v90Ev();
extern void _ZN8S75C5_nt3v91Ev();
extern void _ZN8S75C5_nt3v92Ev();
extern void _ZN8S75C5_nt3v93Ev();
extern void _ZN8S75C5_nt3v94Ev();
extern void _ZN8S75C5_nt3v95Ev();
extern void _ZN8S75C5_nt3v96Ev();
extern void _ZN8S75C5_nt3v97Ev();
extern void _ZN8S75C5_nt3v98Ev();
extern void _ZN8S75C5_nt3v99Ev();
extern void _ZN8S75C5_nt4v100Ev();
extern void _ZN8S75C5_nt4v101Ev();
extern void _ZN8S75C5_nt4v102Ev();
extern void _ZN8S75C5_nt4v103Ev();
extern void _ZN8S75C5_nt4v104Ev();
extern void _ZN8S75C5_nt4v105Ev();
extern void _ZN8S75C5_nt4v106Ev();
extern void _ZN8S75C5_nt4v107Ev();
extern void _ZN8S75C5_nt4v108Ev();
extern void _ZN8S75C5_nt4v109Ev();
static  VTBL_ENTRY vtc_S75C5_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S75C5_nt[0]),
  (VTBL_ENTRY)&_ZN8S75C5_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S75C5_ntD0Ev,
  (VTBL_ENTRY)&_ZN5S75C72v4Ev,
  (VTBL_ENTRY)&_ZN5S75C72v5Ev,
  (VTBL_ENTRY)&_ZN5S75C72v6Ev,
  (VTBL_ENTRY)&_ZN5S75C72v7Ev,
  (VTBL_ENTRY)&_ZN5S75C72v8Ev,
  (VTBL_ENTRY)&_ZN5S75C72v9Ev,
  (VTBL_ENTRY)&_ZN5S75C73v10Ev,
  (VTBL_ENTRY)&_ZN5S75C73v11Ev,
  (VTBL_ENTRY)&_ZN5S75C73v12Ev,
  (VTBL_ENTRY)&_ZN5S75C73v13Ev,
  (VTBL_ENTRY)&_ZN5S75C73v14Ev,
  (VTBL_ENTRY)&_ZN5S75C73v15Ev,
  (VTBL_ENTRY)&_ZN5S75C73v16Ev,
  (VTBL_ENTRY)&_ZN5S75C73v17Ev,
  (VTBL_ENTRY)&_ZN5S75C73v18Ev,
  (VTBL_ENTRY)&_ZN5S75C73v19Ev,
  (VTBL_ENTRY)&_ZN5S75C73v20Ev,
  (VTBL_ENTRY)&_ZN5S75C73v21Ev,
  (VTBL_ENTRY)&_ZN5S75C73v22Ev,
  (VTBL_ENTRY)&_ZN5S75C73v23Ev,
  (VTBL_ENTRY)&_ZN5S75C73v24Ev,
  (VTBL_ENTRY)&_ZN5S75C73v25Ev,
  (VTBL_ENTRY)&_ZN5S75C73v26Ev,
  (VTBL_ENTRY)&_ZN5S75C73v27Ev,
  (VTBL_ENTRY)&_ZN5S75C73v28Ev,
  (VTBL_ENTRY)&_ZN5S75C73v29Ev,
  (VTBL_ENTRY)&_ZN5S75C73v30Ev,
  (VTBL_ENTRY)&_ZN5S75C73v31Ev,
  (VTBL_ENTRY)&_ZN5S75C73v32Ev,
  (VTBL_ENTRY)&_ZN5S75C73v33Ev,
  (VTBL_ENTRY)&_ZN5S75C73v34Ev,
  (VTBL_ENTRY)&_ZN5S75C73v35Ev,
  (VTBL_ENTRY)&_ZN5S75C73v36Ev,
  (VTBL_ENTRY)&_ZN5S75C73v37Ev,
  (VTBL_ENTRY)&_ZN5S75C73v38Ev,
  (VTBL_ENTRY)&_ZN5S75C73v39Ev,
  (VTBL_ENTRY)&_ZN5S75C73v40Ev,
  (VTBL_ENTRY)&_ZN5S75C73v41Ev,
  (VTBL_ENTRY)&_ZN5S75C73v42Ev,
  (VTBL_ENTRY)&_ZN5S75C73v43Ev,
  (VTBL_ENTRY)&_ZN5S75C73v44Ev,
  (VTBL_ENTRY)&_ZN5S75C73v45Ev,
  (VTBL_ENTRY)&_ZN5S75C73v46Ev,
  (VTBL_ENTRY)&_ZN5S75C73v47Ev,
  (VTBL_ENTRY)&_ZN5S75C73v48Ev,
  (VTBL_ENTRY)&_ZN5S75C73v49Ev,
  (VTBL_ENTRY)&_ZN5S75C73v50Ev,
  (VTBL_ENTRY)&_ZN5S75C73v51Ev,
  (VTBL_ENTRY)&_ZN5S75C73v52Ev,
  (VTBL_ENTRY)&_ZN5S75C73v53Ev,
  (VTBL_ENTRY)&_ZN5S75C73v54Ev,
  (VTBL_ENTRY)&_ZN5S75C73v55Ev,
  (VTBL_ENTRY)&_ZN5S75C73v56Ev,
  (VTBL_ENTRY)&_ZN5S75C73v57Ev,
  (VTBL_ENTRY)&_ZN5S75C73v58Ev,
  (VTBL_ENTRY)&_ZN5S75C73v59Ev,
  (VTBL_ENTRY)&_ZN5S75C73v60Ev,
  (VTBL_ENTRY)&_ZN5S75C73v61Ev,
  (VTBL_ENTRY)&_ZN5S75C73v62Ev,
  (VTBL_ENTRY)&_ZN5S75C73v63Ev,
  (VTBL_ENTRY)&_ZN5S75C73v64Ev,
  (VTBL_ENTRY)&_ZN5S75C73v65Ev,
  (VTBL_ENTRY)&_ZN5S75C73v66Ev,
  (VTBL_ENTRY)&_ZN5S75C73v67Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v109Ev,
};
extern VTBL_ENTRY _ZTI8S75C5_nt[];
VTBL_ENTRY *P__ZTI8S75C5_nt = _ZTI8S75C5_nt; 
extern  VTBL_ENTRY _ZTV8S75C5_nt[];
Class_Descriptor cd_S75C5_nt = {  "S75C5_nt", // class name
  bases_S75C5_nt, 2,
  &(vtc_S75C5_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI8S75C5_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S75C5_nt),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S75C4_nt  : S75C5_nt {
  ::S3216C4_nt s75c4f0;
  unsigned int s75c4f1:1;
  ::S75C20 s75c4f2;
  virtual  ~S75C4_nt(); // _ZN8S75C4_ntD1Ev
  virtual void  v110(); // _ZN8S75C4_nt4v110Ev
  virtual void  v111(); // _ZN8S75C4_nt4v111Ev
  virtual void  v112(); // _ZN8S75C4_nt4v112Ev
  virtual void  v113(); // _ZN8S75C4_nt4v113Ev
  S75C4_nt(); // tgen
};
//SIG(-1 S75C4_nt) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ BC9}} Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC17}


 S75C4_nt ::~S75C4_nt(){ note_dtor("S75C4_nt", this);}
void  S75C4_nt ::v110(){vfunc_called(this, "_ZN8S75C4_nt4v110Ev");}
void  S75C4_nt ::v111(){vfunc_called(this, "_ZN8S75C4_nt4v111Ev");}
void  S75C4_nt ::v112(){vfunc_called(this, "_ZN8S75C4_nt4v112Ev");}
void  S75C4_nt ::v113(){vfunc_called(this, "_ZN8S75C4_nt4v113Ev");}
S75C4_nt ::S75C4_nt(){ note_ctor("S75C4_nt", this);} // tgen

//skip512 S75C4_nt

#else // __cplusplus

extern void _ZN8S75C4_ntC1Ev();
extern void _ZN8S75C4_ntD1Ev();
Name_Map name_map_S75C4_nt[] = {
  NSPAIR(_ZN8S75C4_ntC1Ev),
  NSPAIR(_ZN8S75C4_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S75C7;
extern VTBL_ENTRY _ZTI5S75C7[];
extern  VTBL_ENTRY _ZTV5S75C7[];
extern Class_Descriptor cd_S75C6_nt;
extern VTBL_ENTRY _ZTI8S75C6_nt[];
extern  VTBL_ENTRY _ZTV8S75C6_nt[];
extern Class_Descriptor cd_S75C5_nt;
extern VTBL_ENTRY _ZTI8S75C5_nt[];
extern  VTBL_ENTRY _ZTV8S75C5_nt[];
static Base_Class bases_S75C4_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S75C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S75C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S75C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S75C4_nt[];
extern void _ZN8S75C4_ntD1Ev();
extern void _ZN8S75C4_ntD0Ev();
extern void _ZN5S75C72v4Ev();
extern void _ZN5S75C72v5Ev();
extern void _ZN5S75C72v6Ev();
extern void _ZN5S75C72v7Ev();
extern void _ZN5S75C72v8Ev();
extern void _ZN5S75C72v9Ev();
extern void _ZN5S75C73v10Ev();
extern void _ZN5S75C73v11Ev();
extern void _ZN5S75C73v12Ev();
extern void _ZN5S75C73v13Ev();
extern void _ZN5S75C73v14Ev();
extern void _ZN5S75C73v15Ev();
extern void _ZN5S75C73v16Ev();
extern void _ZN5S75C73v17Ev();
extern void _ZN5S75C73v18Ev();
extern void _ZN5S75C73v19Ev();
extern void _ZN5S75C73v20Ev();
extern void _ZN5S75C73v21Ev();
extern void _ZN5S75C73v22Ev();
extern void _ZN5S75C73v23Ev();
extern void _ZN5S75C73v24Ev();
extern void _ZN5S75C73v25Ev();
extern void _ZN5S75C73v26Ev();
extern void _ZN5S75C73v27Ev();
extern void _ZN5S75C73v28Ev();
extern void _ZN5S75C73v29Ev();
extern void _ZN5S75C73v30Ev();
extern void _ZN5S75C73v31Ev();
extern void _ZN5S75C73v32Ev();
extern void _ZN5S75C73v33Ev();
extern void _ZN5S75C73v34Ev();
extern void _ZN5S75C73v35Ev();
extern void _ZN5S75C73v36Ev();
extern void _ZN5S75C73v37Ev();
extern void _ZN5S75C73v38Ev();
extern void _ZN5S75C73v39Ev();
extern void _ZN5S75C73v40Ev();
extern void _ZN5S75C73v41Ev();
extern void _ZN5S75C73v42Ev();
extern void _ZN5S75C73v43Ev();
extern void _ZN5S75C73v44Ev();
extern void _ZN5S75C73v45Ev();
extern void _ZN5S75C73v46Ev();
extern void _ZN5S75C73v47Ev();
extern void _ZN5S75C73v48Ev();
extern void _ZN5S75C73v49Ev();
extern void _ZN5S75C73v50Ev();
extern void _ZN5S75C73v51Ev();
extern void _ZN5S75C73v52Ev();
extern void _ZN5S75C73v53Ev();
extern void _ZN5S75C73v54Ev();
extern void _ZN5S75C73v55Ev();
extern void _ZN5S75C73v56Ev();
extern void _ZN5S75C73v57Ev();
extern void _ZN5S75C73v58Ev();
extern void _ZN5S75C73v59Ev();
extern void _ZN5S75C73v60Ev();
extern void _ZN5S75C73v61Ev();
extern void _ZN5S75C73v62Ev();
extern void _ZN5S75C73v63Ev();
extern void _ZN5S75C73v64Ev();
extern void _ZN5S75C73v65Ev();
extern void _ZN5S75C73v66Ev();
extern void _ZN5S75C73v67Ev();
extern void _ZN8S75C6_nt3v68Ev();
extern void _ZN8S75C6_nt3v69Ev();
extern void _ZN8S75C6_nt3v70Ev();
extern void _ZN8S75C6_nt3v71Ev();
extern void _ZN8S75C6_nt3v72Ev();
extern void _ZN8S75C6_nt3v73Ev();
extern void _ZN8S75C6_nt3v74Ev();
extern void _ZN8S75C6_nt3v75Ev();
extern void _ZN8S75C6_nt3v76Ev();
extern void _ZN8S75C6_nt3v77Ev();
extern void _ZN8S75C6_nt3v78Ev();
extern void _ZN8S75C6_nt3v79Ev();
extern void _ZN8S75C6_nt3v80Ev();
extern void _ZN8S75C6_nt3v81Ev();
extern void _ZN8S75C6_nt3v82Ev();
extern void _ZN8S75C6_nt3v83Ev();
extern void _ZN8S75C6_nt3v84Ev();
extern void _ZN8S75C6_nt3v85Ev();
extern void _ZN8S75C6_nt3v86Ev();
extern void _ZN8S75C6_nt3v87Ev();
extern void _ZN8S75C6_nt3v88Ev();
extern void _ZN8S75C6_nt3v89Ev();
extern void _ZN8S75C5_nt3v90Ev();
extern void _ZN8S75C5_nt3v91Ev();
extern void _ZN8S75C5_nt3v92Ev();
extern void _ZN8S75C5_nt3v93Ev();
extern void _ZN8S75C5_nt3v94Ev();
extern void _ZN8S75C5_nt3v95Ev();
extern void _ZN8S75C5_nt3v96Ev();
extern void _ZN8S75C5_nt3v97Ev();
extern void _ZN8S75C5_nt3v98Ev();
extern void _ZN8S75C5_nt3v99Ev();
extern void _ZN8S75C5_nt4v100Ev();
extern void _ZN8S75C5_nt4v101Ev();
extern void _ZN8S75C5_nt4v102Ev();
extern void _ZN8S75C5_nt4v103Ev();
extern void _ZN8S75C5_nt4v104Ev();
extern void _ZN8S75C5_nt4v105Ev();
extern void _ZN8S75C5_nt4v106Ev();
extern void _ZN8S75C5_nt4v107Ev();
extern void _ZN8S75C5_nt4v108Ev();
extern void _ZN8S75C5_nt4v109Ev();
extern void _ZN8S75C4_nt4v110Ev();
extern void _ZN8S75C4_nt4v111Ev();
extern void _ZN8S75C4_nt4v112Ev();
extern void _ZN8S75C4_nt4v113Ev();
static  VTBL_ENTRY vtc_S75C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S75C4_nt[0]),
  (VTBL_ENTRY)&_ZN8S75C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S75C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN5S75C72v4Ev,
  (VTBL_ENTRY)&_ZN5S75C72v5Ev,
  (VTBL_ENTRY)&_ZN5S75C72v6Ev,
  (VTBL_ENTRY)&_ZN5S75C72v7Ev,
  (VTBL_ENTRY)&_ZN5S75C72v8Ev,
  (VTBL_ENTRY)&_ZN5S75C72v9Ev,
  (VTBL_ENTRY)&_ZN5S75C73v10Ev,
  (VTBL_ENTRY)&_ZN5S75C73v11Ev,
  (VTBL_ENTRY)&_ZN5S75C73v12Ev,
  (VTBL_ENTRY)&_ZN5S75C73v13Ev,
  (VTBL_ENTRY)&_ZN5S75C73v14Ev,
  (VTBL_ENTRY)&_ZN5S75C73v15Ev,
  (VTBL_ENTRY)&_ZN5S75C73v16Ev,
  (VTBL_ENTRY)&_ZN5S75C73v17Ev,
  (VTBL_ENTRY)&_ZN5S75C73v18Ev,
  (VTBL_ENTRY)&_ZN5S75C73v19Ev,
  (VTBL_ENTRY)&_ZN5S75C73v20Ev,
  (VTBL_ENTRY)&_ZN5S75C73v21Ev,
  (VTBL_ENTRY)&_ZN5S75C73v22Ev,
  (VTBL_ENTRY)&_ZN5S75C73v23Ev,
  (VTBL_ENTRY)&_ZN5S75C73v24Ev,
  (VTBL_ENTRY)&_ZN5S75C73v25Ev,
  (VTBL_ENTRY)&_ZN5S75C73v26Ev,
  (VTBL_ENTRY)&_ZN5S75C73v27Ev,
  (VTBL_ENTRY)&_ZN5S75C73v28Ev,
  (VTBL_ENTRY)&_ZN5S75C73v29Ev,
  (VTBL_ENTRY)&_ZN5S75C73v30Ev,
  (VTBL_ENTRY)&_ZN5S75C73v31Ev,
  (VTBL_ENTRY)&_ZN5S75C73v32Ev,
  (VTBL_ENTRY)&_ZN5S75C73v33Ev,
  (VTBL_ENTRY)&_ZN5S75C73v34Ev,
  (VTBL_ENTRY)&_ZN5S75C73v35Ev,
  (VTBL_ENTRY)&_ZN5S75C73v36Ev,
  (VTBL_ENTRY)&_ZN5S75C73v37Ev,
  (VTBL_ENTRY)&_ZN5S75C73v38Ev,
  (VTBL_ENTRY)&_ZN5S75C73v39Ev,
  (VTBL_ENTRY)&_ZN5S75C73v40Ev,
  (VTBL_ENTRY)&_ZN5S75C73v41Ev,
  (VTBL_ENTRY)&_ZN5S75C73v42Ev,
  (VTBL_ENTRY)&_ZN5S75C73v43Ev,
  (VTBL_ENTRY)&_ZN5S75C73v44Ev,
  (VTBL_ENTRY)&_ZN5S75C73v45Ev,
  (VTBL_ENTRY)&_ZN5S75C73v46Ev,
  (VTBL_ENTRY)&_ZN5S75C73v47Ev,
  (VTBL_ENTRY)&_ZN5S75C73v48Ev,
  (VTBL_ENTRY)&_ZN5S75C73v49Ev,
  (VTBL_ENTRY)&_ZN5S75C73v50Ev,
  (VTBL_ENTRY)&_ZN5S75C73v51Ev,
  (VTBL_ENTRY)&_ZN5S75C73v52Ev,
  (VTBL_ENTRY)&_ZN5S75C73v53Ev,
  (VTBL_ENTRY)&_ZN5S75C73v54Ev,
  (VTBL_ENTRY)&_ZN5S75C73v55Ev,
  (VTBL_ENTRY)&_ZN5S75C73v56Ev,
  (VTBL_ENTRY)&_ZN5S75C73v57Ev,
  (VTBL_ENTRY)&_ZN5S75C73v58Ev,
  (VTBL_ENTRY)&_ZN5S75C73v59Ev,
  (VTBL_ENTRY)&_ZN5S75C73v60Ev,
  (VTBL_ENTRY)&_ZN5S75C73v61Ev,
  (VTBL_ENTRY)&_ZN5S75C73v62Ev,
  (VTBL_ENTRY)&_ZN5S75C73v63Ev,
  (VTBL_ENTRY)&_ZN5S75C73v64Ev,
  (VTBL_ENTRY)&_ZN5S75C73v65Ev,
  (VTBL_ENTRY)&_ZN5S75C73v66Ev,
  (VTBL_ENTRY)&_ZN5S75C73v67Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S75C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S75C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S75C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S75C4_nt4v113Ev,
};
extern VTBL_ENTRY _ZTI8S75C4_nt[];
VTBL_ENTRY *P__ZTI8S75C4_nt = _ZTI8S75C4_nt; 
extern  VTBL_ENTRY _ZTV8S75C4_nt[];
Class_Descriptor cd_S75C4_nt = {  "S75C4_nt", // class name
  bases_S75C4_nt, 3,
  &(vtc_S75C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI8S75C4_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S75C4_nt),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S75C3_nt  : S75C4_nt {
  int s75c3f0;
  unsigned int s75c3f1:1;
  virtual  ~S75C3_nt(); // _ZN8S75C3_ntD1Ev
  virtual void  v114(); // _ZN8S75C3_nt4v114Ev
  virtual void  v115(); // _ZN8S75C3_nt4v115Ev
  virtual void  v116(); // _ZN8S75C3_nt4v116Ev
  virtual void  v117(); // _ZN8S75C3_nt4v117Ev
  virtual void  v118(); // _ZN8S75C3_nt4v118Ev
  virtual void  v119(); // _ZN8S75C3_nt4v119Ev
  virtual void  v120(); // _ZN8S75C3_nt4v120Ev
  virtual void  v121(); // _ZN8S75C3_nt4v121Ev
  S75C3_nt(); // tgen
};
//SIG(-1 S75C3_nt) C1{ BC2{ BC3{ BC4{ BC5{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ BC10}} Fi[3]} vd v115 v116 v117 v118 FC6 Fi:1 FC18} vd v1 v2 v3 v4 v5 v6 v7 v8 Fi Fi:1}


 S75C3_nt ::~S75C3_nt(){ note_dtor("S75C3_nt", this);}
void  S75C3_nt ::v114(){vfunc_called(this, "_ZN8S75C3_nt4v114Ev");}
void  S75C3_nt ::v115(){vfunc_called(this, "_ZN8S75C3_nt4v115Ev");}
void  S75C3_nt ::v116(){vfunc_called(this, "_ZN8S75C3_nt4v116Ev");}
void  S75C3_nt ::v117(){vfunc_called(this, "_ZN8S75C3_nt4v117Ev");}
void  S75C3_nt ::v118(){vfunc_called(this, "_ZN8S75C3_nt4v118Ev");}
void  S75C3_nt ::v119(){vfunc_called(this, "_ZN8S75C3_nt4v119Ev");}
void  S75C3_nt ::v120(){vfunc_called(this, "_ZN8S75C3_nt4v120Ev");}
void  S75C3_nt ::v121(){vfunc_called(this, "_ZN8S75C3_nt4v121Ev");}
S75C3_nt ::S75C3_nt(){ note_ctor("S75C3_nt", this);} // tgen

//skip512 S75C3_nt

#else // __cplusplus

extern void _ZN8S75C3_ntC1Ev();
extern void _ZN8S75C3_ntD1Ev();
Name_Map name_map_S75C3_nt[] = {
  NSPAIR(_ZN8S75C3_ntC1Ev),
  NSPAIR(_ZN8S75C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S75C7;
extern VTBL_ENTRY _ZTI5S75C7[];
extern  VTBL_ENTRY _ZTV5S75C7[];
extern Class_Descriptor cd_S75C6_nt;
extern VTBL_ENTRY _ZTI8S75C6_nt[];
extern  VTBL_ENTRY _ZTV8S75C6_nt[];
extern Class_Descriptor cd_S75C5_nt;
extern VTBL_ENTRY _ZTI8S75C5_nt[];
extern  VTBL_ENTRY _ZTV8S75C5_nt[];
extern Class_Descriptor cd_S75C4_nt;
extern VTBL_ENTRY _ZTI8S75C4_nt[];
extern  VTBL_ENTRY _ZTV8S75C4_nt[];
static Base_Class bases_S75C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S75C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S75C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S75C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S75C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S75C3_nt[];
extern void _ZN8S75C3_ntD1Ev();
extern void _ZN8S75C3_ntD0Ev();
extern void _ZN5S75C72v4Ev();
extern void _ZN5S75C72v5Ev();
extern void _ZN5S75C72v6Ev();
extern void _ZN5S75C72v7Ev();
extern void _ZN5S75C72v8Ev();
extern void _ZN5S75C72v9Ev();
extern void _ZN5S75C73v10Ev();
extern void _ZN5S75C73v11Ev();
extern void _ZN5S75C73v12Ev();
extern void _ZN5S75C73v13Ev();
extern void _ZN5S75C73v14Ev();
extern void _ZN5S75C73v15Ev();
extern void _ZN5S75C73v16Ev();
extern void _ZN5S75C73v17Ev();
extern void _ZN5S75C73v18Ev();
extern void _ZN5S75C73v19Ev();
extern void _ZN5S75C73v20Ev();
extern void _ZN5S75C73v21Ev();
extern void _ZN5S75C73v22Ev();
extern void _ZN5S75C73v23Ev();
extern void _ZN5S75C73v24Ev();
extern void _ZN5S75C73v25Ev();
extern void _ZN5S75C73v26Ev();
extern void _ZN5S75C73v27Ev();
extern void _ZN5S75C73v28Ev();
extern void _ZN5S75C73v29Ev();
extern void _ZN5S75C73v30Ev();
extern void _ZN5S75C73v31Ev();
extern void _ZN5S75C73v32Ev();
extern void _ZN5S75C73v33Ev();
extern void _ZN5S75C73v34Ev();
extern void _ZN5S75C73v35Ev();
extern void _ZN5S75C73v36Ev();
extern void _ZN5S75C73v37Ev();
extern void _ZN5S75C73v38Ev();
extern void _ZN5S75C73v39Ev();
extern void _ZN5S75C73v40Ev();
extern void _ZN5S75C73v41Ev();
extern void _ZN5S75C73v42Ev();
extern void _ZN5S75C73v43Ev();
extern void _ZN5S75C73v44Ev();
extern void _ZN5S75C73v45Ev();
extern void _ZN5S75C73v46Ev();
extern void _ZN5S75C73v47Ev();
extern void _ZN5S75C73v48Ev();
extern void _ZN5S75C73v49Ev();
extern void _ZN5S75C73v50Ev();
extern void _ZN5S75C73v51Ev();
extern void _ZN5S75C73v52Ev();
extern void _ZN5S75C73v53Ev();
extern void _ZN5S75C73v54Ev();
extern void _ZN5S75C73v55Ev();
extern void _ZN5S75C73v56Ev();
extern void _ZN5S75C73v57Ev();
extern void _ZN5S75C73v58Ev();
extern void _ZN5S75C73v59Ev();
extern void _ZN5S75C73v60Ev();
extern void _ZN5S75C73v61Ev();
extern void _ZN5S75C73v62Ev();
extern void _ZN5S75C73v63Ev();
extern void _ZN5S75C73v64Ev();
extern void _ZN5S75C73v65Ev();
extern void _ZN5S75C73v66Ev();
extern void _ZN5S75C73v67Ev();
extern void _ZN8S75C6_nt3v68Ev();
extern void _ZN8S75C6_nt3v69Ev();
extern void _ZN8S75C6_nt3v70Ev();
extern void _ZN8S75C6_nt3v71Ev();
extern void _ZN8S75C6_nt3v72Ev();
extern void _ZN8S75C6_nt3v73Ev();
extern void _ZN8S75C6_nt3v74Ev();
extern void _ZN8S75C6_nt3v75Ev();
extern void _ZN8S75C6_nt3v76Ev();
extern void _ZN8S75C6_nt3v77Ev();
extern void _ZN8S75C6_nt3v78Ev();
extern void _ZN8S75C6_nt3v79Ev();
extern void _ZN8S75C6_nt3v80Ev();
extern void _ZN8S75C6_nt3v81Ev();
extern void _ZN8S75C6_nt3v82Ev();
extern void _ZN8S75C6_nt3v83Ev();
extern void _ZN8S75C6_nt3v84Ev();
extern void _ZN8S75C6_nt3v85Ev();
extern void _ZN8S75C6_nt3v86Ev();
extern void _ZN8S75C6_nt3v87Ev();
extern void _ZN8S75C6_nt3v88Ev();
extern void _ZN8S75C6_nt3v89Ev();
extern void _ZN8S75C5_nt3v90Ev();
extern void _ZN8S75C5_nt3v91Ev();
extern void _ZN8S75C5_nt3v92Ev();
extern void _ZN8S75C5_nt3v93Ev();
extern void _ZN8S75C5_nt3v94Ev();
extern void _ZN8S75C5_nt3v95Ev();
extern void _ZN8S75C5_nt3v96Ev();
extern void _ZN8S75C5_nt3v97Ev();
extern void _ZN8S75C5_nt3v98Ev();
extern void _ZN8S75C5_nt3v99Ev();
extern void _ZN8S75C5_nt4v100Ev();
extern void _ZN8S75C5_nt4v101Ev();
extern void _ZN8S75C5_nt4v102Ev();
extern void _ZN8S75C5_nt4v103Ev();
extern void _ZN8S75C5_nt4v104Ev();
extern void _ZN8S75C5_nt4v105Ev();
extern void _ZN8S75C5_nt4v106Ev();
extern void _ZN8S75C5_nt4v107Ev();
extern void _ZN8S75C5_nt4v108Ev();
extern void _ZN8S75C5_nt4v109Ev();
extern void _ZN8S75C4_nt4v110Ev();
extern void _ZN8S75C4_nt4v111Ev();
extern void _ZN8S75C4_nt4v112Ev();
extern void _ZN8S75C4_nt4v113Ev();
extern void _ZN8S75C3_nt4v114Ev();
extern void _ZN8S75C3_nt4v115Ev();
extern void _ZN8S75C3_nt4v116Ev();
extern void _ZN8S75C3_nt4v117Ev();
extern void _ZN8S75C3_nt4v118Ev();
extern void _ZN8S75C3_nt4v119Ev();
extern void _ZN8S75C3_nt4v120Ev();
extern void _ZN8S75C3_nt4v121Ev();
static  VTBL_ENTRY vtc_S75C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S75C3_nt[0]),
  (VTBL_ENTRY)&_ZN8S75C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN8S75C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN5S75C72v4Ev,
  (VTBL_ENTRY)&_ZN5S75C72v5Ev,
  (VTBL_ENTRY)&_ZN5S75C72v6Ev,
  (VTBL_ENTRY)&_ZN5S75C72v7Ev,
  (VTBL_ENTRY)&_ZN5S75C72v8Ev,
  (VTBL_ENTRY)&_ZN5S75C72v9Ev,
  (VTBL_ENTRY)&_ZN5S75C73v10Ev,
  (VTBL_ENTRY)&_ZN5S75C73v11Ev,
  (VTBL_ENTRY)&_ZN5S75C73v12Ev,
  (VTBL_ENTRY)&_ZN5S75C73v13Ev,
  (VTBL_ENTRY)&_ZN5S75C73v14Ev,
  (VTBL_ENTRY)&_ZN5S75C73v15Ev,
  (VTBL_ENTRY)&_ZN5S75C73v16Ev,
  (VTBL_ENTRY)&_ZN5S75C73v17Ev,
  (VTBL_ENTRY)&_ZN5S75C73v18Ev,
  (VTBL_ENTRY)&_ZN5S75C73v19Ev,
  (VTBL_ENTRY)&_ZN5S75C73v20Ev,
  (VTBL_ENTRY)&_ZN5S75C73v21Ev,
  (VTBL_ENTRY)&_ZN5S75C73v22Ev,
  (VTBL_ENTRY)&_ZN5S75C73v23Ev,
  (VTBL_ENTRY)&_ZN5S75C73v24Ev,
  (VTBL_ENTRY)&_ZN5S75C73v25Ev,
  (VTBL_ENTRY)&_ZN5S75C73v26Ev,
  (VTBL_ENTRY)&_ZN5S75C73v27Ev,
  (VTBL_ENTRY)&_ZN5S75C73v28Ev,
  (VTBL_ENTRY)&_ZN5S75C73v29Ev,
  (VTBL_ENTRY)&_ZN5S75C73v30Ev,
  (VTBL_ENTRY)&_ZN5S75C73v31Ev,
  (VTBL_ENTRY)&_ZN5S75C73v32Ev,
  (VTBL_ENTRY)&_ZN5S75C73v33Ev,
  (VTBL_ENTRY)&_ZN5S75C73v34Ev,
  (VTBL_ENTRY)&_ZN5S75C73v35Ev,
  (VTBL_ENTRY)&_ZN5S75C73v36Ev,
  (VTBL_ENTRY)&_ZN5S75C73v37Ev,
  (VTBL_ENTRY)&_ZN5S75C73v38Ev,
  (VTBL_ENTRY)&_ZN5S75C73v39Ev,
  (VTBL_ENTRY)&_ZN5S75C73v40Ev,
  (VTBL_ENTRY)&_ZN5S75C73v41Ev,
  (VTBL_ENTRY)&_ZN5S75C73v42Ev,
  (VTBL_ENTRY)&_ZN5S75C73v43Ev,
  (VTBL_ENTRY)&_ZN5S75C73v44Ev,
  (VTBL_ENTRY)&_ZN5S75C73v45Ev,
  (VTBL_ENTRY)&_ZN5S75C73v46Ev,
  (VTBL_ENTRY)&_ZN5S75C73v47Ev,
  (VTBL_ENTRY)&_ZN5S75C73v48Ev,
  (VTBL_ENTRY)&_ZN5S75C73v49Ev,
  (VTBL_ENTRY)&_ZN5S75C73v50Ev,
  (VTBL_ENTRY)&_ZN5S75C73v51Ev,
  (VTBL_ENTRY)&_ZN5S75C73v52Ev,
  (VTBL_ENTRY)&_ZN5S75C73v53Ev,
  (VTBL_ENTRY)&_ZN5S75C73v54Ev,
  (VTBL_ENTRY)&_ZN5S75C73v55Ev,
  (VTBL_ENTRY)&_ZN5S75C73v56Ev,
  (VTBL_ENTRY)&_ZN5S75C73v57Ev,
  (VTBL_ENTRY)&_ZN5S75C73v58Ev,
  (VTBL_ENTRY)&_ZN5S75C73v59Ev,
  (VTBL_ENTRY)&_ZN5S75C73v60Ev,
  (VTBL_ENTRY)&_ZN5S75C73v61Ev,
  (VTBL_ENTRY)&_ZN5S75C73v62Ev,
  (VTBL_ENTRY)&_ZN5S75C73v63Ev,
  (VTBL_ENTRY)&_ZN5S75C73v64Ev,
  (VTBL_ENTRY)&_ZN5S75C73v65Ev,
  (VTBL_ENTRY)&_ZN5S75C73v66Ev,
  (VTBL_ENTRY)&_ZN5S75C73v67Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S75C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S75C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S75C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S75C4_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S75C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S75C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S75C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S75C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S75C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S75C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S75C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S75C3_nt4v121Ev,
};
extern VTBL_ENTRY _ZTI8S75C3_nt[];
VTBL_ENTRY *P__ZTI8S75C3_nt = _ZTI8S75C3_nt; 
extern  VTBL_ENTRY _ZTV8S75C3_nt[];
Class_Descriptor cd_S75C3_nt = {  "S75C3_nt", // class name
  bases_S75C3_nt, 4,
  &(vtc_S75C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,228), // object size
  NSPAIRA(_ZTI8S75C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S75C3_nt),122, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S75C2  : S75C3_nt {
  void *s75c2f0;
  virtual  ~S75C2(); // _ZN5S75C2D1Ev
  virtual void  v122(); // _ZN5S75C24v122Ev
  virtual void  v123(); // _ZN5S75C24v123Ev
  virtual void  v124(); // _ZN5S75C24v124Ev
  S75C2(); // tgen
};
//SIG(-1 S75C2) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 Fi[2] Fp Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 FC12{ m} FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 Fi:1 Fi:1 Fi:1 FC13{ BC14{ BC11}} FC15{ BC16{ BC11}} FC17{ BC18{ BC11}} FC19{ BC20{ BC11}} Fi[3]} vd v110 v111 v112 v113 FC7 Fi:1 FC19} vd v114 v115 v116 v117 v118 v119 v120 v121 Fi Fi:1} vd v1 v2 v3 Fp}


 S75C2 ::~S75C2(){ note_dtor("S75C2", this);}
void  S75C2 ::v122(){vfunc_called(this, "_ZN5S75C24v122Ev");}
void  S75C2 ::v123(){vfunc_called(this, "_ZN5S75C24v123Ev");}
void  S75C2 ::v124(){vfunc_called(this, "_ZN5S75C24v124Ev");}
S75C2 ::S75C2(){ note_ctor("S75C2", this);} // tgen

static void Test_S75C2()
{
  extern Class_Descriptor cd_S75C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(40,59)];
    init_test(&cd_S75C2, buf);
    S75C2 *dp, &lv = *(dp=new (buf) S75C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(312,232), "sizeof(S75C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S75C2)");
    check_base_class_offset(lv, (S75C7*)(S75C6_nt*)(S75C5_nt*)(S75C4_nt*)(S75C3_nt*), 0, "S75C2");
    check_base_class_offset(lv, (S75C6_nt*)(S75C5_nt*)(S75C4_nt*)(S75C3_nt*), 0, "S75C2");
    check_base_class_offset(lv, (S75C5_nt*)(S75C4_nt*)(S75C3_nt*), 0, "S75C2");
    check_base_class_offset(lv, (S75C4_nt*)(S75C3_nt*), 0, "S75C2");
    check_base_class_offset(lv, (S75C3_nt*), 0, "S75C2");
    check_field_offset(lv, s75c2f0, ABISELECT(304,228), "S75C2.s75c2f0");
    test_class_info(&lv, &cd_S75C2);
    dp->~S75C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS75C2(Test_S75C2, "S75C2", ABISELECT(312,232));

#else // __cplusplus

extern void _ZN5S75C2C1Ev();
extern void _ZN5S75C2D1Ev();
Name_Map name_map_S75C2[] = {
  NSPAIR(_ZN5S75C2C1Ev),
  NSPAIR(_ZN5S75C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S75C7;
extern VTBL_ENTRY _ZTI5S75C7[];
extern  VTBL_ENTRY _ZTV5S75C7[];
extern Class_Descriptor cd_S75C6_nt;
extern VTBL_ENTRY _ZTI8S75C6_nt[];
extern  VTBL_ENTRY _ZTV8S75C6_nt[];
extern Class_Descriptor cd_S75C5_nt;
extern VTBL_ENTRY _ZTI8S75C5_nt[];
extern  VTBL_ENTRY _ZTV8S75C5_nt[];
extern Class_Descriptor cd_S75C4_nt;
extern VTBL_ENTRY _ZTI8S75C4_nt[];
extern  VTBL_ENTRY _ZTV8S75C4_nt[];
extern Class_Descriptor cd_S75C3_nt;
extern VTBL_ENTRY _ZTI8S75C3_nt[];
extern  VTBL_ENTRY _ZTV8S75C3_nt[];
static Base_Class bases_S75C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S75C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S75C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S75C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S75C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S75C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S75C2[];
extern void _ZN5S75C2D1Ev();
extern void _ZN5S75C2D0Ev();
extern void _ZN5S75C72v4Ev();
extern void _ZN5S75C72v5Ev();
extern void _ZN5S75C72v6Ev();
extern void _ZN5S75C72v7Ev();
extern void _ZN5S75C72v8Ev();
extern void _ZN5S75C72v9Ev();
extern void _ZN5S75C73v10Ev();
extern void _ZN5S75C73v11Ev();
extern void _ZN5S75C73v12Ev();
extern void _ZN5S75C73v13Ev();
extern void _ZN5S75C73v14Ev();
extern void _ZN5S75C73v15Ev();
extern void _ZN5S75C73v16Ev();
extern void _ZN5S75C73v17Ev();
extern void _ZN5S75C73v18Ev();
extern void _ZN5S75C73v19Ev();
extern void _ZN5S75C73v20Ev();
extern void _ZN5S75C73v21Ev();
extern void _ZN5S75C73v22Ev();
extern void _ZN5S75C73v23Ev();
extern void _ZN5S75C73v24Ev();
extern void _ZN5S75C73v25Ev();
extern void _ZN5S75C73v26Ev();
extern void _ZN5S75C73v27Ev();
extern void _ZN5S75C73v28Ev();
extern void _ZN5S75C73v29Ev();
extern void _ZN5S75C73v30Ev();
extern void _ZN5S75C73v31Ev();
extern void _ZN5S75C73v32Ev();
extern void _ZN5S75C73v33Ev();
extern void _ZN5S75C73v34Ev();
extern void _ZN5S75C73v35Ev();
extern void _ZN5S75C73v36Ev();
extern void _ZN5S75C73v37Ev();
extern void _ZN5S75C73v38Ev();
extern void _ZN5S75C73v39Ev();
extern void _ZN5S75C73v40Ev();
extern void _ZN5S75C73v41Ev();
extern void _ZN5S75C73v42Ev();
extern void _ZN5S75C73v43Ev();
extern void _ZN5S75C73v44Ev();
extern void _ZN5S75C73v45Ev();
extern void _ZN5S75C73v46Ev();
extern void _ZN5S75C73v47Ev();
extern void _ZN5S75C73v48Ev();
extern void _ZN5S75C73v49Ev();
extern void _ZN5S75C73v50Ev();
extern void _ZN5S75C73v51Ev();
extern void _ZN5S75C73v52Ev();
extern void _ZN5S75C73v53Ev();
extern void _ZN5S75C73v54Ev();
extern void _ZN5S75C73v55Ev();
extern void _ZN5S75C73v56Ev();
extern void _ZN5S75C73v57Ev();
extern void _ZN5S75C73v58Ev();
extern void _ZN5S75C73v59Ev();
extern void _ZN5S75C73v60Ev();
extern void _ZN5S75C73v61Ev();
extern void _ZN5S75C73v62Ev();
extern void _ZN5S75C73v63Ev();
extern void _ZN5S75C73v64Ev();
extern void _ZN5S75C73v65Ev();
extern void _ZN5S75C73v66Ev();
extern void _ZN5S75C73v67Ev();
extern void _ZN8S75C6_nt3v68Ev();
extern void _ZN8S75C6_nt3v69Ev();
extern void _ZN8S75C6_nt3v70Ev();
extern void _ZN8S75C6_nt3v71Ev();
extern void _ZN8S75C6_nt3v72Ev();
extern void _ZN8S75C6_nt3v73Ev();
extern void _ZN8S75C6_nt3v74Ev();
extern void _ZN8S75C6_nt3v75Ev();
extern void _ZN8S75C6_nt3v76Ev();
extern void _ZN8S75C6_nt3v77Ev();
extern void _ZN8S75C6_nt3v78Ev();
extern void _ZN8S75C6_nt3v79Ev();
extern void _ZN8S75C6_nt3v80Ev();
extern void _ZN8S75C6_nt3v81Ev();
extern void _ZN8S75C6_nt3v82Ev();
extern void _ZN8S75C6_nt3v83Ev();
extern void _ZN8S75C6_nt3v84Ev();
extern void _ZN8S75C6_nt3v85Ev();
extern void _ZN8S75C6_nt3v86Ev();
extern void _ZN8S75C6_nt3v87Ev();
extern void _ZN8S75C6_nt3v88Ev();
extern void _ZN8S75C6_nt3v89Ev();
extern void _ZN8S75C5_nt3v90Ev();
extern void _ZN8S75C5_nt3v91Ev();
extern void _ZN8S75C5_nt3v92Ev();
extern void _ZN8S75C5_nt3v93Ev();
extern void _ZN8S75C5_nt3v94Ev();
extern void _ZN8S75C5_nt3v95Ev();
extern void _ZN8S75C5_nt3v96Ev();
extern void _ZN8S75C5_nt3v97Ev();
extern void _ZN8S75C5_nt3v98Ev();
extern void _ZN8S75C5_nt3v99Ev();
extern void _ZN8S75C5_nt4v100Ev();
extern void _ZN8S75C5_nt4v101Ev();
extern void _ZN8S75C5_nt4v102Ev();
extern void _ZN8S75C5_nt4v103Ev();
extern void _ZN8S75C5_nt4v104Ev();
extern void _ZN8S75C5_nt4v105Ev();
extern void _ZN8S75C5_nt4v106Ev();
extern void _ZN8S75C5_nt4v107Ev();
extern void _ZN8S75C5_nt4v108Ev();
extern void _ZN8S75C5_nt4v109Ev();
extern void _ZN8S75C4_nt4v110Ev();
extern void _ZN8S75C4_nt4v111Ev();
extern void _ZN8S75C4_nt4v112Ev();
extern void _ZN8S75C4_nt4v113Ev();
extern void _ZN8S75C3_nt4v114Ev();
extern void _ZN8S75C3_nt4v115Ev();
extern void _ZN8S75C3_nt4v116Ev();
extern void _ZN8S75C3_nt4v117Ev();
extern void _ZN8S75C3_nt4v118Ev();
extern void _ZN8S75C3_nt4v119Ev();
extern void _ZN8S75C3_nt4v120Ev();
extern void _ZN8S75C3_nt4v121Ev();
extern void _ZN5S75C24v122Ev();
extern void _ZN5S75C24v123Ev();
extern void _ZN5S75C24v124Ev();
static  VTBL_ENTRY vtc_S75C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S75C2[0]),
  (VTBL_ENTRY)&_ZN5S75C2D1Ev,
  (VTBL_ENTRY)&_ZN5S75C2D0Ev,
  (VTBL_ENTRY)&_ZN5S75C72v4Ev,
  (VTBL_ENTRY)&_ZN5S75C72v5Ev,
  (VTBL_ENTRY)&_ZN5S75C72v6Ev,
  (VTBL_ENTRY)&_ZN5S75C72v7Ev,
  (VTBL_ENTRY)&_ZN5S75C72v8Ev,
  (VTBL_ENTRY)&_ZN5S75C72v9Ev,
  (VTBL_ENTRY)&_ZN5S75C73v10Ev,
  (VTBL_ENTRY)&_ZN5S75C73v11Ev,
  (VTBL_ENTRY)&_ZN5S75C73v12Ev,
  (VTBL_ENTRY)&_ZN5S75C73v13Ev,
  (VTBL_ENTRY)&_ZN5S75C73v14Ev,
  (VTBL_ENTRY)&_ZN5S75C73v15Ev,
  (VTBL_ENTRY)&_ZN5S75C73v16Ev,
  (VTBL_ENTRY)&_ZN5S75C73v17Ev,
  (VTBL_ENTRY)&_ZN5S75C73v18Ev,
  (VTBL_ENTRY)&_ZN5S75C73v19Ev,
  (VTBL_ENTRY)&_ZN5S75C73v20Ev,
  (VTBL_ENTRY)&_ZN5S75C73v21Ev,
  (VTBL_ENTRY)&_ZN5S75C73v22Ev,
  (VTBL_ENTRY)&_ZN5S75C73v23Ev,
  (VTBL_ENTRY)&_ZN5S75C73v24Ev,
  (VTBL_ENTRY)&_ZN5S75C73v25Ev,
  (VTBL_ENTRY)&_ZN5S75C73v26Ev,
  (VTBL_ENTRY)&_ZN5S75C73v27Ev,
  (VTBL_ENTRY)&_ZN5S75C73v28Ev,
  (VTBL_ENTRY)&_ZN5S75C73v29Ev,
  (VTBL_ENTRY)&_ZN5S75C73v30Ev,
  (VTBL_ENTRY)&_ZN5S75C73v31Ev,
  (VTBL_ENTRY)&_ZN5S75C73v32Ev,
  (VTBL_ENTRY)&_ZN5S75C73v33Ev,
  (VTBL_ENTRY)&_ZN5S75C73v34Ev,
  (VTBL_ENTRY)&_ZN5S75C73v35Ev,
  (VTBL_ENTRY)&_ZN5S75C73v36Ev,
  (VTBL_ENTRY)&_ZN5S75C73v37Ev,
  (VTBL_ENTRY)&_ZN5S75C73v38Ev,
  (VTBL_ENTRY)&_ZN5S75C73v39Ev,
  (VTBL_ENTRY)&_ZN5S75C73v40Ev,
  (VTBL_ENTRY)&_ZN5S75C73v41Ev,
  (VTBL_ENTRY)&_ZN5S75C73v42Ev,
  (VTBL_ENTRY)&_ZN5S75C73v43Ev,
  (VTBL_ENTRY)&_ZN5S75C73v44Ev,
  (VTBL_ENTRY)&_ZN5S75C73v45Ev,
  (VTBL_ENTRY)&_ZN5S75C73v46Ev,
  (VTBL_ENTRY)&_ZN5S75C73v47Ev,
  (VTBL_ENTRY)&_ZN5S75C73v48Ev,
  (VTBL_ENTRY)&_ZN5S75C73v49Ev,
  (VTBL_ENTRY)&_ZN5S75C73v50Ev,
  (VTBL_ENTRY)&_ZN5S75C73v51Ev,
  (VTBL_ENTRY)&_ZN5S75C73v52Ev,
  (VTBL_ENTRY)&_ZN5S75C73v53Ev,
  (VTBL_ENTRY)&_ZN5S75C73v54Ev,
  (VTBL_ENTRY)&_ZN5S75C73v55Ev,
  (VTBL_ENTRY)&_ZN5S75C73v56Ev,
  (VTBL_ENTRY)&_ZN5S75C73v57Ev,
  (VTBL_ENTRY)&_ZN5S75C73v58Ev,
  (VTBL_ENTRY)&_ZN5S75C73v59Ev,
  (VTBL_ENTRY)&_ZN5S75C73v60Ev,
  (VTBL_ENTRY)&_ZN5S75C73v61Ev,
  (VTBL_ENTRY)&_ZN5S75C73v62Ev,
  (VTBL_ENTRY)&_ZN5S75C73v63Ev,
  (VTBL_ENTRY)&_ZN5S75C73v64Ev,
  (VTBL_ENTRY)&_ZN5S75C73v65Ev,
  (VTBL_ENTRY)&_ZN5S75C73v66Ev,
  (VTBL_ENTRY)&_ZN5S75C73v67Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S75C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S75C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S75C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S75C4_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S75C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S75C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S75C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S75C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S75C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S75C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S75C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S75C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN5S75C24v122Ev,
  (VTBL_ENTRY)&_ZN5S75C24v123Ev,
  (VTBL_ENTRY)&_ZN5S75C24v124Ev,
};
extern VTBL_ENTRY _ZTI5S75C2[];
extern  VTBL_ENTRY _ZTV5S75C2[];
Class_Descriptor cd_S75C2 = {  "S75C2", // class name
  bases_S75C2, 5,
  &(vtc_S75C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(312,232), // object size
  NSPAIRA(_ZTI5S75C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S75C2),125, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S75C1  : S75C2 {
  void *s75c1f0;
  virtual  ~S75C1(); // _ZN5S75C1D1Ev
  virtual void  v1(); // _ZN5S75C12v1Ev
  virtual void  v2(); // _ZN5S75C12v2Ev
  virtual void  v3(); // _ZN5S75C12v3Ev
  S75C1(); // tgen
};
//SIG(1 S75C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 Fi[2] Fp Fi[2] FC9{ BC10{ BC11{ BC12{ m Fp Fi[2]}}}} FC9 FC13{ m} FC9 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 Fi:1 Fi:1 Fi:1 FC14{ BC15{ BC12}} FC16{ BC17{ BC12}} FC18{ BC19{ BC12}} FC20{ BC21{ BC12}} Fi[3]} vd v110 v111 v112 v113 FC8 Fi:1 FC20} vd v114 v115 v116 v117 v118 v119 v120 v121 Fi Fi:1} vd v122 v123 v124 Fp} vd v1 v2 v3 Fp}


 S75C1 ::~S75C1(){ note_dtor("S75C1", this);}
void  S75C1 ::v1(){vfunc_called(this, "_ZN5S75C12v1Ev");}
void  S75C1 ::v2(){vfunc_called(this, "_ZN5S75C12v2Ev");}
void  S75C1 ::v3(){vfunc_called(this, "_ZN5S75C12v3Ev");}
S75C1 ::S75C1(){ note_ctor("S75C1", this);} // tgen

static void Test_S75C1()
{
  extern Class_Descriptor cd_S75C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(41,60)];
    init_test(&cd_S75C1, buf);
    S75C1 *dp, &lv = *(dp=new (buf) S75C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(320,236), "sizeof(S75C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S75C1)");
    check_base_class_offset(lv, (S75C7*)(S75C6_nt*)(S75C5_nt*)(S75C4_nt*)(S75C3_nt*)(S75C2*), 0, "S75C1");
    check_base_class_offset(lv, (S75C6_nt*)(S75C5_nt*)(S75C4_nt*)(S75C3_nt*)(S75C2*), 0, "S75C1");
    check_base_class_offset(lv, (S75C5_nt*)(S75C4_nt*)(S75C3_nt*)(S75C2*), 0, "S75C1");
    check_base_class_offset(lv, (S75C4_nt*)(S75C3_nt*)(S75C2*), 0, "S75C1");
    check_base_class_offset(lv, (S75C3_nt*)(S75C2*), 0, "S75C1");
    check_base_class_offset(lv, (S75C2*), 0, "S75C1");
    check_field_offset(lv, s75c1f0, ABISELECT(312,232), "S75C1.s75c1f0");
    test_class_info(&lv, &cd_S75C1);
    dp->~S75C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS75C1(Test_S75C1, "S75C1", ABISELECT(320,236));

#else // __cplusplus

extern void _ZN5S75C1C1Ev();
extern void _ZN5S75C1D1Ev();
Name_Map name_map_S75C1[] = {
  NSPAIR(_ZN5S75C1C1Ev),
  NSPAIR(_ZN5S75C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S75C7;
extern VTBL_ENTRY _ZTI5S75C7[];
extern  VTBL_ENTRY _ZTV5S75C7[];
extern Class_Descriptor cd_S75C6_nt;
extern VTBL_ENTRY _ZTI8S75C6_nt[];
extern  VTBL_ENTRY _ZTV8S75C6_nt[];
extern Class_Descriptor cd_S75C5_nt;
extern VTBL_ENTRY _ZTI8S75C5_nt[];
extern  VTBL_ENTRY _ZTV8S75C5_nt[];
extern Class_Descriptor cd_S75C4_nt;
extern VTBL_ENTRY _ZTI8S75C4_nt[];
extern  VTBL_ENTRY _ZTV8S75C4_nt[];
extern Class_Descriptor cd_S75C3_nt;
extern VTBL_ENTRY _ZTI8S75C3_nt[];
extern  VTBL_ENTRY _ZTV8S75C3_nt[];
extern Class_Descriptor cd_S75C2;
extern VTBL_ENTRY _ZTI5S75C2[];
extern  VTBL_ENTRY _ZTV5S75C2[];
static Base_Class bases_S75C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S75C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S75C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S75C5_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S75C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S75C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S75C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S75C1[];
extern void _ZN5S75C1D1Ev();
extern void _ZN5S75C1D0Ev();
extern void _ZN5S75C72v4Ev();
extern void _ZN5S75C72v5Ev();
extern void _ZN5S75C72v6Ev();
extern void _ZN5S75C72v7Ev();
extern void _ZN5S75C72v8Ev();
extern void _ZN5S75C72v9Ev();
extern void _ZN5S75C73v10Ev();
extern void _ZN5S75C73v11Ev();
extern void _ZN5S75C73v12Ev();
extern void _ZN5S75C73v13Ev();
extern void _ZN5S75C73v14Ev();
extern void _ZN5S75C73v15Ev();
extern void _ZN5S75C73v16Ev();
extern void _ZN5S75C73v17Ev();
extern void _ZN5S75C73v18Ev();
extern void _ZN5S75C73v19Ev();
extern void _ZN5S75C73v20Ev();
extern void _ZN5S75C73v21Ev();
extern void _ZN5S75C73v22Ev();
extern void _ZN5S75C73v23Ev();
extern void _ZN5S75C73v24Ev();
extern void _ZN5S75C73v25Ev();
extern void _ZN5S75C73v26Ev();
extern void _ZN5S75C73v27Ev();
extern void _ZN5S75C73v28Ev();
extern void _ZN5S75C73v29Ev();
extern void _ZN5S75C73v30Ev();
extern void _ZN5S75C73v31Ev();
extern void _ZN5S75C73v32Ev();
extern void _ZN5S75C73v33Ev();
extern void _ZN5S75C73v34Ev();
extern void _ZN5S75C73v35Ev();
extern void _ZN5S75C73v36Ev();
extern void _ZN5S75C73v37Ev();
extern void _ZN5S75C73v38Ev();
extern void _ZN5S75C73v39Ev();
extern void _ZN5S75C73v40Ev();
extern void _ZN5S75C73v41Ev();
extern void _ZN5S75C73v42Ev();
extern void _ZN5S75C73v43Ev();
extern void _ZN5S75C73v44Ev();
extern void _ZN5S75C73v45Ev();
extern void _ZN5S75C73v46Ev();
extern void _ZN5S75C73v47Ev();
extern void _ZN5S75C73v48Ev();
extern void _ZN5S75C73v49Ev();
extern void _ZN5S75C73v50Ev();
extern void _ZN5S75C73v51Ev();
extern void _ZN5S75C73v52Ev();
extern void _ZN5S75C73v53Ev();
extern void _ZN5S75C73v54Ev();
extern void _ZN5S75C73v55Ev();
extern void _ZN5S75C73v56Ev();
extern void _ZN5S75C73v57Ev();
extern void _ZN5S75C73v58Ev();
extern void _ZN5S75C73v59Ev();
extern void _ZN5S75C73v60Ev();
extern void _ZN5S75C73v61Ev();
extern void _ZN5S75C73v62Ev();
extern void _ZN5S75C73v63Ev();
extern void _ZN5S75C73v64Ev();
extern void _ZN5S75C73v65Ev();
extern void _ZN5S75C73v66Ev();
extern void _ZN5S75C73v67Ev();
extern void _ZN8S75C6_nt3v68Ev();
extern void _ZN8S75C6_nt3v69Ev();
extern void _ZN8S75C6_nt3v70Ev();
extern void _ZN8S75C6_nt3v71Ev();
extern void _ZN8S75C6_nt3v72Ev();
extern void _ZN8S75C6_nt3v73Ev();
extern void _ZN8S75C6_nt3v74Ev();
extern void _ZN8S75C6_nt3v75Ev();
extern void _ZN8S75C6_nt3v76Ev();
extern void _ZN8S75C6_nt3v77Ev();
extern void _ZN8S75C6_nt3v78Ev();
extern void _ZN8S75C6_nt3v79Ev();
extern void _ZN8S75C6_nt3v80Ev();
extern void _ZN8S75C6_nt3v81Ev();
extern void _ZN8S75C6_nt3v82Ev();
extern void _ZN8S75C6_nt3v83Ev();
extern void _ZN8S75C6_nt3v84Ev();
extern void _ZN8S75C6_nt3v85Ev();
extern void _ZN8S75C6_nt3v86Ev();
extern void _ZN8S75C6_nt3v87Ev();
extern void _ZN8S75C6_nt3v88Ev();
extern void _ZN8S75C6_nt3v89Ev();
extern void _ZN8S75C5_nt3v90Ev();
extern void _ZN8S75C5_nt3v91Ev();
extern void _ZN8S75C5_nt3v92Ev();
extern void _ZN8S75C5_nt3v93Ev();
extern void _ZN8S75C5_nt3v94Ev();
extern void _ZN8S75C5_nt3v95Ev();
extern void _ZN8S75C5_nt3v96Ev();
extern void _ZN8S75C5_nt3v97Ev();
extern void _ZN8S75C5_nt3v98Ev();
extern void _ZN8S75C5_nt3v99Ev();
extern void _ZN8S75C5_nt4v100Ev();
extern void _ZN8S75C5_nt4v101Ev();
extern void _ZN8S75C5_nt4v102Ev();
extern void _ZN8S75C5_nt4v103Ev();
extern void _ZN8S75C5_nt4v104Ev();
extern void _ZN8S75C5_nt4v105Ev();
extern void _ZN8S75C5_nt4v106Ev();
extern void _ZN8S75C5_nt4v107Ev();
extern void _ZN8S75C5_nt4v108Ev();
extern void _ZN8S75C5_nt4v109Ev();
extern void _ZN8S75C4_nt4v110Ev();
extern void _ZN8S75C4_nt4v111Ev();
extern void _ZN8S75C4_nt4v112Ev();
extern void _ZN8S75C4_nt4v113Ev();
extern void _ZN8S75C3_nt4v114Ev();
extern void _ZN8S75C3_nt4v115Ev();
extern void _ZN8S75C3_nt4v116Ev();
extern void _ZN8S75C3_nt4v117Ev();
extern void _ZN8S75C3_nt4v118Ev();
extern void _ZN8S75C3_nt4v119Ev();
extern void _ZN8S75C3_nt4v120Ev();
extern void _ZN8S75C3_nt4v121Ev();
extern void _ZN5S75C24v122Ev();
extern void _ZN5S75C24v123Ev();
extern void _ZN5S75C24v124Ev();
extern void _ZN5S75C12v1Ev();
extern void _ZN5S75C12v2Ev();
extern void _ZN5S75C12v3Ev();
static  VTBL_ENTRY vtc_S75C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S75C1[0]),
  (VTBL_ENTRY)&_ZN5S75C1D1Ev,
  (VTBL_ENTRY)&_ZN5S75C1D0Ev,
  (VTBL_ENTRY)&_ZN5S75C72v4Ev,
  (VTBL_ENTRY)&_ZN5S75C72v5Ev,
  (VTBL_ENTRY)&_ZN5S75C72v6Ev,
  (VTBL_ENTRY)&_ZN5S75C72v7Ev,
  (VTBL_ENTRY)&_ZN5S75C72v8Ev,
  (VTBL_ENTRY)&_ZN5S75C72v9Ev,
  (VTBL_ENTRY)&_ZN5S75C73v10Ev,
  (VTBL_ENTRY)&_ZN5S75C73v11Ev,
  (VTBL_ENTRY)&_ZN5S75C73v12Ev,
  (VTBL_ENTRY)&_ZN5S75C73v13Ev,
  (VTBL_ENTRY)&_ZN5S75C73v14Ev,
  (VTBL_ENTRY)&_ZN5S75C73v15Ev,
  (VTBL_ENTRY)&_ZN5S75C73v16Ev,
  (VTBL_ENTRY)&_ZN5S75C73v17Ev,
  (VTBL_ENTRY)&_ZN5S75C73v18Ev,
  (VTBL_ENTRY)&_ZN5S75C73v19Ev,
  (VTBL_ENTRY)&_ZN5S75C73v20Ev,
  (VTBL_ENTRY)&_ZN5S75C73v21Ev,
  (VTBL_ENTRY)&_ZN5S75C73v22Ev,
  (VTBL_ENTRY)&_ZN5S75C73v23Ev,
  (VTBL_ENTRY)&_ZN5S75C73v24Ev,
  (VTBL_ENTRY)&_ZN5S75C73v25Ev,
  (VTBL_ENTRY)&_ZN5S75C73v26Ev,
  (VTBL_ENTRY)&_ZN5S75C73v27Ev,
  (VTBL_ENTRY)&_ZN5S75C73v28Ev,
  (VTBL_ENTRY)&_ZN5S75C73v29Ev,
  (VTBL_ENTRY)&_ZN5S75C73v30Ev,
  (VTBL_ENTRY)&_ZN5S75C73v31Ev,
  (VTBL_ENTRY)&_ZN5S75C73v32Ev,
  (VTBL_ENTRY)&_ZN5S75C73v33Ev,
  (VTBL_ENTRY)&_ZN5S75C73v34Ev,
  (VTBL_ENTRY)&_ZN5S75C73v35Ev,
  (VTBL_ENTRY)&_ZN5S75C73v36Ev,
  (VTBL_ENTRY)&_ZN5S75C73v37Ev,
  (VTBL_ENTRY)&_ZN5S75C73v38Ev,
  (VTBL_ENTRY)&_ZN5S75C73v39Ev,
  (VTBL_ENTRY)&_ZN5S75C73v40Ev,
  (VTBL_ENTRY)&_ZN5S75C73v41Ev,
  (VTBL_ENTRY)&_ZN5S75C73v42Ev,
  (VTBL_ENTRY)&_ZN5S75C73v43Ev,
  (VTBL_ENTRY)&_ZN5S75C73v44Ev,
  (VTBL_ENTRY)&_ZN5S75C73v45Ev,
  (VTBL_ENTRY)&_ZN5S75C73v46Ev,
  (VTBL_ENTRY)&_ZN5S75C73v47Ev,
  (VTBL_ENTRY)&_ZN5S75C73v48Ev,
  (VTBL_ENTRY)&_ZN5S75C73v49Ev,
  (VTBL_ENTRY)&_ZN5S75C73v50Ev,
  (VTBL_ENTRY)&_ZN5S75C73v51Ev,
  (VTBL_ENTRY)&_ZN5S75C73v52Ev,
  (VTBL_ENTRY)&_ZN5S75C73v53Ev,
  (VTBL_ENTRY)&_ZN5S75C73v54Ev,
  (VTBL_ENTRY)&_ZN5S75C73v55Ev,
  (VTBL_ENTRY)&_ZN5S75C73v56Ev,
  (VTBL_ENTRY)&_ZN5S75C73v57Ev,
  (VTBL_ENTRY)&_ZN5S75C73v58Ev,
  (VTBL_ENTRY)&_ZN5S75C73v59Ev,
  (VTBL_ENTRY)&_ZN5S75C73v60Ev,
  (VTBL_ENTRY)&_ZN5S75C73v61Ev,
  (VTBL_ENTRY)&_ZN5S75C73v62Ev,
  (VTBL_ENTRY)&_ZN5S75C73v63Ev,
  (VTBL_ENTRY)&_ZN5S75C73v64Ev,
  (VTBL_ENTRY)&_ZN5S75C73v65Ev,
  (VTBL_ENTRY)&_ZN5S75C73v66Ev,
  (VTBL_ENTRY)&_ZN5S75C73v67Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v68Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v69Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v70Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v71Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v72Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v73Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v74Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v75Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v76Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v77Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v78Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v79Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v80Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v81Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v82Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v83Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v84Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v85Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v86Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v87Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v88Ev,
  (VTBL_ENTRY)&_ZN8S75C6_nt3v89Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v90Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v91Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v92Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v93Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v94Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v95Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v96Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v97Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v98Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt3v99Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v100Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v101Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v102Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v103Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v104Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v105Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v106Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v107Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v108Ev,
  (VTBL_ENTRY)&_ZN8S75C5_nt4v109Ev,
  (VTBL_ENTRY)&_ZN8S75C4_nt4v110Ev,
  (VTBL_ENTRY)&_ZN8S75C4_nt4v111Ev,
  (VTBL_ENTRY)&_ZN8S75C4_nt4v112Ev,
  (VTBL_ENTRY)&_ZN8S75C4_nt4v113Ev,
  (VTBL_ENTRY)&_ZN8S75C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN8S75C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN8S75C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN8S75C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN8S75C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN8S75C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN8S75C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN8S75C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN5S75C24v122Ev,
  (VTBL_ENTRY)&_ZN5S75C24v123Ev,
  (VTBL_ENTRY)&_ZN5S75C24v124Ev,
  (VTBL_ENTRY)&_ZN5S75C12v1Ev,
  (VTBL_ENTRY)&_ZN5S75C12v2Ev,
  (VTBL_ENTRY)&_ZN5S75C12v3Ev,
};
extern VTBL_ENTRY _ZTI5S75C1[];
extern  VTBL_ENTRY _ZTV5S75C1[];
Class_Descriptor cd_S75C1 = {  "S75C1", // class name
  bases_S75C1, 6,
  &(vtc_S75C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(320,236), // object size
  NSPAIRA(_ZTI5S75C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S75C1),128, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S76C7  {
  int s76c7f0;
  __tsi64 s76c7f1;
  void *s76c7f2[4];
  int s76c7f3[2];
  void *s76c7f4;
  ::S3216C4_nt s76c7f5;
  void *s76c7f6[2];
  virtual  ~S76C7(); // _ZN5S76C7D1Ev
  virtual void  v4(); // _ZN5S76C72v4Ev
  virtual void  v5(); // _ZN5S76C72v5Ev
  virtual void  v6(); // _ZN5S76C72v6Ev
  virtual void  v7(); // _ZN5S76C72v7Ev
  virtual void  v8(); // _ZN5S76C72v8Ev
  virtual void  v9(); // _ZN5S76C72v9Ev
  virtual void  v10(); // _ZN5S76C73v10Ev
  virtual void  v11(); // _ZN5S76C73v11Ev
  virtual void  v12(); // _ZN5S76C73v12Ev
  virtual void  v13(); // _ZN5S76C73v13Ev
  virtual void  v14(); // _ZN5S76C73v14Ev
  virtual void  v15(); // _ZN5S76C73v15Ev
  virtual void  v16(); // _ZN5S76C73v16Ev
  virtual void  v17(); // _ZN5S76C73v17Ev
  virtual void  v18(); // _ZN5S76C73v18Ev
  virtual void  v19(); // _ZN5S76C73v19Ev
  virtual void  v20(); // _ZN5S76C73v20Ev
  virtual void  v21(); // _ZN5S76C73v21Ev
  virtual void  v22(); // _ZN5S76C73v22Ev
  virtual void  v23(); // _ZN5S76C73v23Ev
  virtual void  v24(); // _ZN5S76C73v24Ev
  virtual void  v25(); // _ZN5S76C73v25Ev
  virtual void  v26(); // _ZN5S76C73v26Ev
  virtual void  v27(); // _ZN5S76C73v27Ev
  virtual void  v28(); // _ZN5S76C73v28Ev
  virtual void  v29(); // _ZN5S76C73v29Ev
  virtual void  v30(); // _ZN5S76C73v30Ev
  virtual void  v31(); // _ZN5S76C73v31Ev
  virtual void  v32(); // _ZN5S76C73v32Ev
  virtual void  v33(); // _ZN5S76C73v33Ev
  virtual void  v34(); // _ZN5S76C73v34Ev
  virtual void  v35(); // _ZN5S76C73v35Ev
  virtual void  v36(); // _ZN5S76C73v36Ev
  virtual void  v37(); // _ZN5S76C73v37Ev
  virtual void  v38(); // _ZN5S76C73v38Ev
  virtual void  v39(); // _ZN5S76C73v39Ev
  virtual void  v40(); // _ZN5S76C73v40Ev
  virtual void  v41(); // _ZN5S76C73v41Ev
  virtual void  v42(); // _ZN5S76C73v42Ev
  virtual void  v43(); // _ZN5S76C73v43Ev
  virtual void  v44(); // _ZN5S76C73v44Ev
  virtual void  v45(); // _ZN5S76C73v45Ev
  virtual void  v46(); // _ZN5S76C73v46Ev
  virtual void  v47(); // _ZN5S76C73v47Ev
  virtual void  v48(); // _ZN5S76C73v48Ev
  virtual void  v49(); // _ZN5S76C73v49Ev
  virtual void  v50(); // _ZN5S76C73v50Ev
  virtual void  v51(); // _ZN5S76C73v51Ev
  virtual void  v52(); // _ZN5S76C73v52Ev
  virtual void  v53(); // _ZN5S76C73v53Ev
  virtual void  v54(); // _ZN5S76C73v54Ev
  virtual void  v55(); // _ZN5S76C73v55Ev
  virtual void  v56(); // _ZN5S76C73v56Ev
  virtual void  v57(); // _ZN5S76C73v57Ev
  virtual void  v58(); // _ZN5S76C73v58Ev
  virtual void  v59(); // _ZN5S76C73v59Ev
  virtual void  v60(); // _ZN5S76C73v60Ev
  virtual void  v61(); // _ZN5S76C73v61Ev
  virtual void  v62(); // _ZN5S76C73v62Ev
  virtual void  v63(); // _ZN5S76C73v63Ev
  virtual void  v64(); // _ZN5S76C73v64Ev
  virtual void  v65(); // _ZN5S76C73v65Ev
  virtual void  v66(); // _ZN5S76C73v66Ev
  virtual void  v67(); // _ZN5S76C73v67Ev
  S76C7(); // tgen
};
//SIG(-1 S76C7) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S76C7 ::~S76C7(){ note_dtor("S76C7", this);}
void  S76C7 ::v4(){vfunc_called(this, "_ZN5S76C72v4Ev");}
void  S76C7 ::v5(){vfunc_called(this, "_ZN5S76C72v5Ev");}
void  S76C7 ::v6(){vfunc_called(this, "_ZN5S76C72v6Ev");}
void  S76C7 ::v7(){vfunc_called(this, "_ZN5S76C72v7Ev");}
void  S76C7 ::v8(){vfunc_called(this, "_ZN5S76C72v8Ev");}
void  S76C7 ::v9(){vfunc_called(this, "_ZN5S76C72v9Ev");}
void  S76C7 ::v10(){vfunc_called(this, "_ZN5S76C73v10Ev");}
void  S76C7 ::v11(){vfunc_called(this, "_ZN5S76C73v11Ev");}
void  S76C7 ::v12(){vfunc_called(this, "_ZN5S76C73v12Ev");}
void  S76C7 ::v13(){vfunc_called(this, "_ZN5S76C73v13Ev");}
void  S76C7 ::v14(){vfunc_called(this, "_ZN5S76C73v14Ev");}
void  S76C7 ::v15(){vfunc_called(this, "_ZN5S76C73v15Ev");}
void  S76C7 ::v16(){vfunc_called(this, "_ZN5S76C73v16Ev");}
void  S76C7 ::v17(){vfunc_called(this, "_ZN5S76C73v17Ev");}
void  S76C7 ::v18(){vfunc_called(this, "_ZN5S76C73v18Ev");}
void  S76C7 ::v19(){vfunc_called(this, "_ZN5S76C73v19Ev");}
void  S76C7 ::v20(){vfunc_called(this, "_ZN5S76C73v20Ev");}
void  S76C7 ::v21(){vfunc_called(this, "_ZN5S76C73v21Ev");}
void  S76C7 ::v22(){vfunc_called(this, "_ZN5S76C73v22Ev");}
void  S76C7 ::v23(){vfunc_called(this, "_ZN5S76C73v23Ev");}
void  S76C7 ::v24(){vfunc_called(this, "_ZN5S76C73v24Ev");}
void  S76C7 ::v25(){vfunc_called(this, "_ZN5S76C73v25Ev");}
void  S76C7 ::v26(){vfunc_called(this, "_ZN5S76C73v26Ev");}
void  S76C7 ::v27(){vfunc_called(this, "_ZN5S76C73v27Ev");}
void  S76C7 ::v28(){vfunc_called(this, "_ZN5S76C73v28Ev");}
void  S76C7 ::v29(){vfunc_called(this, "_ZN5S76C73v29Ev");}
void  S76C7 ::v30(){vfunc_called(this, "_ZN5S76C73v30Ev");}
void  S76C7 ::v31(){vfunc_called(this, "_ZN5S76C73v31Ev");}
void  S76C7 ::v32(){vfunc_called(this, "_ZN5S76C73v32Ev");}
void  S76C7 ::v33(){vfunc_called(this, "_ZN5S76C73v33Ev");}
void  S76C7 ::v34(){vfunc_called(this, "_ZN5S76C73v34Ev");}
void  S76C7 ::v35(){vfunc_called(this, "_ZN5S76C73v35Ev");}
void  S76C7 ::v36(){vfunc_called(this, "_ZN5S76C73v36Ev");}
void  S76C7 ::v37(){vfunc_called(this, "_ZN5S76C73v37Ev");}
void  S76C7 ::v38(){vfunc_called(this, "_ZN5S76C73v38Ev");}
void  S76C7 ::v39(){vfunc_called(this, "_ZN5S76C73v39Ev");}
void  S76C7 ::v40(){vfunc_called(this, "_ZN5S76C73v40Ev");}
void  S76C7 ::v41(){vfunc_called(this, "_ZN5S76C73v41Ev");}
void  S76C7 ::v42(){vfunc_called(this, "_ZN5S76C73v42Ev");}
void  S76C7 ::v43(){vfunc_called(this, "_ZN5S76C73v43Ev");}
void  S76C7 ::v44(){vfunc_called(this, "_ZN5S76C73v44Ev");}
void  S76C7 ::v45(){vfunc_called(this, "_ZN5S76C73v45Ev");}
void  S76C7 ::v46(){vfunc_called(this, "_ZN5S76C73v46Ev");}
void  S76C7 ::v47(){vfunc_called(this, "_ZN5S76C73v47Ev");}
void  S76C7 ::v48(){vfunc_called(this, "_ZN5S76C73v48Ev");}
void  S76C7 ::v49(){vfunc_called(this, "_ZN5S76C73v49Ev");}
void  S76C7 ::v50(){vfunc_called(this, "_ZN5S76C73v50Ev");}
void  S76C7 ::v51(){vfunc_called(this, "_ZN5S76C73v51Ev");}
void  S76C7 ::v52(){vfunc_called(this, "_ZN5S76C73v52Ev");}
void  S76C7 ::v53(){vfunc_called(this, "_ZN5S76C73v53Ev");}
void  S76C7 ::v54(){vfunc_called(this, "_ZN5S76C73v54Ev");}
void  S76C7 ::v55(){vfunc_called(this, "_ZN5S76C73v55Ev");}
void  S76C7 ::v56(){vfunc_called(this, "_ZN5S76C73v56Ev");}
void  S76C7 ::v57(){vfunc_called(this, "_ZN5S76C73v57Ev");}
void  S76C7 ::v58(){vfunc_called(this, "_ZN5S76C73v58Ev");}
void  S76C7 ::v59(){vfunc_called(this, "_ZN5S76C73v59Ev");}
void  S76C7 ::v60(){vfunc_called(this, "_ZN5S76C73v60Ev");}
void  S76C7 ::v61(){vfunc_called(this, "_ZN5S76C73v61Ev");}
void  S76C7 ::v62(){vfunc_called(this, "_ZN5S76C73v62Ev");}
void  S76C7 ::v63(){vfunc_called(this, "_ZN5S76C73v63Ev");}
void  S76C7 ::v64(){vfunc_called(this, "_ZN5S76C73v64Ev");}
void  S76C7 ::v65(){vfunc_called(this, "_ZN5S76C73v65Ev");}
void  S76C7 ::v66(){vfunc_called(this, "_ZN5S76C73v66Ev");}
void  S76C7 ::v67(){vfunc_called(this, "_ZN5S76C73v67Ev");}
S76C7 ::S76C7(){ note_ctor("S76C7", this);} // tgen

static void Test_S76C7()
{
  extern Class_Descriptor cd_S76C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(13,16)];
    init_test(&cd_S76C7, buf);
    S76C7 *dp, &lv = *(dp=new (buf) S76C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,60), "sizeof(S76C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S76C7)");
    check_field_offset(lv, s76c7f0, ABISELECT(8,4), "S76C7.s76c7f0");
    check_field_offset(lv, s76c7f1, ABISELECT(16,8), "S76C7.s76c7f1");
    check_field_offset(lv, s76c7f2, ABISELECT(24,16), "S76C7.s76c7f2");
    check_field_offset(lv, s76c7f3, ABISELECT(56,32), "S76C7.s76c7f3");
    check_field_offset(lv, s76c7f4, ABISELECT(64,40), "S76C7.s76c7f4");
    check_field_offset(lv, s76c7f5, ABISELECT(72,44), "S76C7.s76c7f5");
    check_field_offset(lv, s76c7f6, ABISELECT(80,52), "S76C7.s76c7f6");
    test_class_info(&lv, &cd_S76C7);
    dp->~S76C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS76C7(Test_S76C7, "S76C7", ABISELECT(96,60));

#else // __cplusplus

extern void _ZN5S76C7C1Ev();
extern void _ZN5S76C7D1Ev();
Name_Map name_map_S76C7[] = {
  NSPAIR(_ZN5S76C7C1Ev),
  NSPAIR(_ZN5S76C7D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI5S76C7[];
extern void _ZN5S76C7D1Ev();
extern void _ZN5S76C7D0Ev();
extern void _ZN5S76C72v4Ev();
extern void _ZN5S76C72v5Ev();
extern void _ZN5S76C72v6Ev();
extern void _ZN5S76C72v7Ev();
extern void _ZN5S76C72v8Ev();
extern void _ZN5S76C72v9Ev();
extern void _ZN5S76C73v10Ev();
extern void _ZN5S76C73v11Ev();
extern void _ZN5S76C73v12Ev();
extern void _ZN5S76C73v13Ev();
extern void _ZN5S76C73v14Ev();
extern void _ZN5S76C73v15Ev();
extern void _ZN5S76C73v16Ev();
extern void _ZN5S76C73v17Ev();
extern void _ZN5S76C73v18Ev();
extern void _ZN5S76C73v19Ev();
extern void _ZN5S76C73v20Ev();
extern void _ZN5S76C73v21Ev();
extern void _ZN5S76C73v22Ev();
extern void _ZN5S76C73v23Ev();
extern void _ZN5S76C73v24Ev();
extern void _ZN5S76C73v25Ev();
extern void _ZN5S76C73v26Ev();
extern void _ZN5S76C73v27Ev();
extern void _ZN5S76C73v28Ev();
extern void _ZN5S76C73v29Ev();
extern void _ZN5S76C73v30Ev();
extern void _ZN5S76C73v31Ev();
extern void _ZN5S76C73v32Ev();
extern void _ZN5S76C73v33Ev();
extern void _ZN5S76C73v34Ev();
extern void _ZN5S76C73v35Ev();
extern void _ZN5S76C73v36Ev();
extern void _ZN5S76C73v37Ev();
extern void _ZN5S76C73v38Ev();
extern void _ZN5S76C73v39Ev();
extern void _ZN5S76C73v40Ev();
extern void _ZN5S76C73v41Ev();
extern void _ZN5S76C73v42Ev();
extern void _ZN5S76C73v43Ev();
extern void _ZN5S76C73v44Ev();
extern void _ZN5S76C73v45Ev();
extern void _ZN5S76C73v46Ev();
extern void _ZN5S76C73v47Ev();
extern void _ZN5S76C73v48Ev();
extern void _ZN5S76C73v49Ev();
extern void _ZN5S76C73v50Ev();
extern void _ZN5S76C73v51Ev();
extern void _ZN5S76C73v52Ev();
extern void _ZN5S76C73v53Ev();
extern void _ZN5S76C73v54Ev();
extern void _ZN5S76C73v55Ev();
extern void _ZN5S76C73v56Ev();
extern void _ZN5S76C73v57Ev();
extern void _ZN5S76C73v58Ev();
extern void _ZN5S76C73v59Ev();
extern void _ZN5S76C73v60Ev();
extern void _ZN5S76C73v61Ev();
extern void _ZN5S76C73v62Ev();
extern void _ZN5S76C73v63Ev();
extern void _ZN5S76C73v64Ev();
extern void _ZN5S76C73v65Ev();
extern void _ZN5S76C73v66Ev();
extern void _ZN5S76C73v67Ev();
static  VTBL_ENTRY vtc_S76C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S76C7[0]),
  (VTBL_ENTRY)&_ZN5S76C7D1Ev,
  (VTBL_ENTRY)&_ZN5S76C7D0Ev,
  (VTBL_ENTRY)&_ZN5S76C72v4Ev,
  (VTBL_ENTRY)&_ZN5S76C72v5Ev,
  (VTBL_ENTRY)&_ZN5S76C72v6Ev,
  (VTBL_ENTRY)&_ZN5S76C72v7Ev,
  (VTBL_ENTRY)&_ZN5S76C72v8Ev,
  (VTBL_ENTRY)&_ZN5S76C72v9Ev,
  (VTBL_ENTRY)&_ZN5S76C73v10Ev,
  (VTBL_ENTRY)&_ZN5S76C73v11Ev,
  (VTBL_ENTRY)&_ZN5S76C73v12Ev,
  (VTBL_ENTRY)&_ZN5S76C73v13Ev,
  (VTBL_ENTRY)&_ZN5S76C73v14Ev,
  (VTBL_ENTRY)&_ZN5S76C73v15Ev,
  (VTBL_ENTRY)&_ZN5S76C73v16Ev,
  (VTBL_ENTRY)&_ZN5S76C73v17Ev,
  (VTBL_ENTRY)&_ZN5S76C73v18Ev,
  (VTBL_ENTRY)&_ZN5S76C73v19Ev,
  (VTBL_ENTRY)&_ZN5S76C73v20Ev,
  (VTBL_ENTRY)&_ZN5S76C73v21Ev,
  (VTBL_ENTRY)&_ZN5S76C73v22Ev,
  (VTBL_ENTRY)&_ZN5S76C73v23Ev,
  (VTBL_ENTRY)&_ZN5S76C73v24Ev,
  (VTBL_ENTRY)&_ZN5S76C73v25Ev,
  (VTBL_ENTRY)&_ZN5S76C73v26Ev,
  (VTBL_ENTRY)&_ZN5S76C73v27Ev,
  (VTBL_ENTRY)&_ZN5S76C73v28Ev,
  (VTBL_ENTRY)&_ZN5S76C73v29Ev,
  (VTBL_ENTRY)&_ZN5S76C73v30Ev,
  (VTBL_ENTRY)&_ZN5S76C73v31Ev,
  (VTBL_ENTRY)&_ZN5S76C73v32Ev,
  (VTBL_ENTRY)&_ZN5S76C73v33Ev,
  (VTBL_ENTRY)&_ZN5S76C73v34Ev,
  (VTBL_ENTRY)&_ZN5S76C73v35Ev,
  (VTBL_ENTRY)&_ZN5S76C73v36Ev,
  (VTBL_ENTRY)&_ZN5S76C73v37Ev,
  (VTBL_ENTRY)&_ZN5S76C73v38Ev,
  (VTBL_ENTRY)&_ZN5S76C73v39Ev,
  (VTBL_ENTRY)&_ZN5S76C73v40Ev,
  (VTBL_ENTRY)&_ZN5S76C73v41Ev,
  (VTBL_ENTRY)&_ZN5S76C73v42Ev,
  (VTBL_ENTRY)&_ZN5S76C73v43Ev,
  (VTBL_ENTRY)&_ZN5S76C73v44Ev,
  (VTBL_ENTRY)&_ZN5S76C73v45Ev,
  (VTBL_ENTRY)&_ZN5S76C73v46Ev,
  (VTBL_ENTRY)&_ZN5S76C73v47Ev,
  (VTBL_ENTRY)&_ZN5S76C73v48Ev,
  (VTBL_ENTRY)&_ZN5S76C73v49Ev,
  (VTBL_ENTRY)&_ZN5S76C73v50Ev,
  (VTBL_ENTRY)&_ZN5S76C73v51Ev,
  (VTBL_ENTRY)&_ZN5S76C73v52Ev,
  (VTBL_ENTRY)&_ZN5S76C73v53Ev,
  (VTBL_ENTRY)&_ZN5S76C73v54Ev,
  (VTBL_ENTRY)&_ZN5S76C73v55Ev,
  (VTBL_ENTRY)&_ZN5S76C73v56Ev,
  (VTBL_ENTRY)&_ZN5S76C73v57Ev,
  (VTBL_ENTRY)&_ZN5S76C73v58Ev,
  (VTBL_ENTRY)&_ZN5S76C73v59Ev,
  (VTBL_ENTRY)&_ZN5S76C73v60Ev,
  (VTBL_ENTRY)&_ZN5S76C73v61Ev,
  (VTBL_ENTRY)&_ZN5S76C73v62Ev,
  (VTBL_ENTRY)&_ZN5S76C73v63Ev,
  (VTBL_ENTRY)&_ZN5S76C73v64Ev,
  (VTBL_ENTRY)&_ZN5S76C73v65Ev,
  (VTBL_ENTRY)&_ZN5S76C73v66Ev,
  (VTBL_ENTRY)&_ZN5S76C73v67Ev,
};
extern VTBL_ENTRY _ZTI5S76C7[];
extern  VTBL_ENTRY _ZTV5S76C7[];
Class_Descriptor cd_S76C7 = {  "S76C7", // class name
  0,0,//no base classes
  &(vtc_S76C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI5S76C7),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV5S76C7),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S76C6  : S76C7 {
  int s76c6f0[2];
  void *s76c6f1;
  int s76c6f2[2];
  ::S75C9_nt s76c6f3;
  ::S75C9_nt s76c6f4;
  ::S4677C37 s76c6f5;
  ::S75C9_nt s76c6f6;
  unsigned int s76c6f7:1;
  unsigned int s76c6f8:1;
  unsigned int s76c6f9:1;
  unsigned int s76c6f10:1;
  unsigned int s76c6f11:1;
  int s76c6f12[2];
  virtual  ~S76C6(); // _ZN5S76C6D1Ev
  virtual void  v68(); // _ZN5S76C63v68Ev
  virtual void  v69(); // _ZN5S76C63v69Ev
  virtual void  v70(); // _ZN5S76C63v70Ev
  virtual void  v71(); // _ZN5S76C63v71Ev
  virtual void  v72(); // _ZN5S76C63v72Ev
  virtual void  v73(); // _ZN5S76C63v73Ev
  virtual void  v74(); // _ZN5S76C63v74Ev
  virtual void  v75(); // _ZN5S76C63v75Ev
  virtual void  v76(); // _ZN5S76C63v76Ev
  virtual void  v77(); // _ZN5S76C63v77Ev
  virtual void  v78(); // _ZN5S76C63v78Ev
  virtual void  v79(); // _ZN5S76C63v79Ev
  virtual void  v80(); // _ZN5S76C63v80Ev
  virtual void  v81(); // _ZN5S76C63v81Ev
  virtual void  v82(); // _ZN5S76C63v82Ev
  virtual void  v83(); // _ZN5S76C63v83Ev
  virtual void  v84(); // _ZN5S76C63v84Ev
  virtual void  v85(); // _ZN5S76C63v85Ev
  virtual void  v86(); // _ZN5S76C63v86Ev
  virtual void  v87(); // _ZN5S76C63v87Ev
  virtual void  v88(); // _ZN5S76C63v88Ev
  virtual void  v89(); // _ZN5S76C63v89Ev
  S76C6(); // tgen
};
//SIG(-1 S76C6) C1{ BC2{ vd v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 Fi[2] Fp Fi[2] FC4{ BC5{ BC6{ BC7{ m Fp Fi[2]}}}} FC4 FC8{ m} FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]}


 S76C6 ::~S76C6(){ note_dtor("S76C6", this);}
void  S76C6 ::v68(){vfunc_called(this, "_ZN5S76C63v68Ev");}
void  S76C6 ::v69(){vfunc_called(this, "_ZN5S76C63v69Ev");}
void  S76C6 ::v70(){vfunc_called(this, "_ZN5S76C63v70Ev");}
void  S76C6 ::v71(){vfunc_called(this, "_ZN5S76C63v71Ev");}
void  S76C6 ::v72(){vfunc_called(this, "_ZN5S76C63v72Ev");}
void  S76C6 ::v73(){vfunc_called(this, "_ZN5S76C63v73Ev");}
void  S76C6 ::v74(){vfunc_called(this, "_ZN5S76C63v74Ev");}
void  S76C6 ::v75(){vfunc_called(this, "_ZN5S76C63v75Ev");}
void  S76C6 ::v76(){vfunc_called(this, "_ZN5S76C63v76Ev");}
void  S76C6 ::v77(){vfunc_called(this, "_ZN5S76C63v77Ev");}
void  S76C6 ::v78(){vfunc_called(this, "_ZN5S76C63v78Ev");}
void  S76C6 ::v79(){vfunc_called(this, "_ZN5S76C63v79Ev");}
void  S76C6 ::v80(){vfunc_called(this, "_ZN5S76C63v80Ev");}
void  S76C6 ::v81(){vfunc_called(this, "_ZN5S76C63v81Ev");}
void  S76C6 ::v82(){vfunc_called(this, "_ZN5S76C63v82Ev");}
void  S76C6 ::v83(){vfunc_called(this, "_ZN5S76C63v83Ev");}
void  S76C6 ::v84(){vfunc_called(this, "_ZN5S76C63v84Ev");}
void  S76C6 ::v85(){vfunc_called(this, "_ZN5S76C63v85Ev");}
void  S76C6 ::v86(){vfunc_called(this, "_ZN5S76C63v86Ev");}
void  S76C6 ::v87(){vfunc_called(this, "_ZN5S76C63v87Ev");}
void  S76C6 ::v88(){vfunc_called(this, "_ZN5S76C63v88Ev");}
void  S76C6 ::v89(){vfunc_called(this, "_ZN5S76C63v89Ev");}
S76C6 ::S76C6(){ note_ctor("S76C6", this);} // tgen

static void Test_S76C6()
{
  extern Class_Descriptor cd_S76C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(25,34)];
    init_test(&cd_S76C6, buf);
    S76C6 *dp, &lv = *(dp=new (buf) S76C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(192,132), "sizeof(S76C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S76C6)");
    check_base_class_offset(lv, (S76C7*), 0, "S76C6");
    check_field_offset(lv, s76c6f0, ABISELECT(96,60), "S76C6.s76c6f0");
    check_field_offset(lv, s76c6f1, ABISELECT(104,68), "S76C6.s76c6f1");
    check_field_offset(lv, s76c6f2, ABISELECT(112,72), "S76C6.s76c6f2");
    check_field_offset(lv, s76c6f3, ABISELECT(120,80), "S76C6.s76c6f3");
    check_field_offset(lv, s76c6f4, ABISELECT(136,92), "S76C6.s76c6f4");
    check_field_offset(lv, s76c6f5, ABISELECT(152,104), "S76C6.s76c6f5");
    check_field_offset(lv, s76c6f6, ABISELECT(160,108), "S76C6.s76c6f6");
    set_bf_and_test(lv, s76c6f7, ABISELECT(176,120), 0, 1, 1, "S76C6");
    set_bf_and_test(lv, s76c6f8, ABISELECT(176,120), 1, 1, 1, "S76C6");
    set_bf_and_test(lv, s76c6f9, ABISELECT(176,120), 2, 1, 1, "S76C6");
    set_bf_and_test(lv, s76c6f10, ABISELECT(176,120), 3, 1, 1, "S76C6");
    set_bf_and_test(lv, s76c6f11, ABISELECT(176,120), 4, 1, 1, "S76C6");
    check_field_offset(lv, s76c6f12, ABISELECT(180,124), "S76C6.s76c6f12");
    test_class_info(&lv, &cd_S76C6);
    dp->~S76C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS76C6(Test_S76C6, "S76C6", ABISELECT(192,132));

#else // __cplusplus

extern void _ZN5S76C6C1Ev();
extern void _ZN5S76C6D1Ev();
Name_Map name_map_S76C6[] = {
  NSPAIR(_ZN5S76C6C1Ev),
  NSPAIR(_ZN5S76C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S76C7;
extern VTBL_ENTRY _ZTI5S76C7[];
extern  VTBL_ENTRY _ZTV5S76C7[];
static Base_Class bases_S76C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S76C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S76C6[];
extern void _ZN5S76C6D1Ev();
extern void _ZN5S76C6D0Ev();
extern void _ZN5S76C72v4Ev();
extern void _ZN5S76C72v5Ev();
extern void _ZN5S76C72v6Ev();
extern void _ZN5S76C72v7Ev();
extern void _ZN5S76C72v8Ev();
extern void _ZN5S76C72v9Ev();
extern void _ZN5S76C73v10Ev();
extern void _ZN5S76C73v11Ev();
extern void _ZN5S76C73v12Ev();
extern void _ZN5S76C73v13Ev();
extern void _ZN5S76C73v14Ev();
extern void _ZN5S76C73v15Ev();
extern void _ZN5S76C73v16Ev();
extern void _ZN5S76C73v17Ev();
extern void _ZN5S76C73v18Ev();
extern void _ZN5S76C73v19Ev();
extern void _ZN5S76C73v20Ev();
extern void _ZN5S76C73v21Ev();
extern void _ZN5S76C73v22Ev();
extern void _ZN5S76C73v23Ev();
extern void _ZN5S76C73v24Ev();
extern void _ZN5S76C73v25Ev();
extern void _ZN5S76C73v26Ev();
extern void _ZN5S76C73v27Ev();
extern void _ZN5S76C73v28Ev();
extern void _ZN5S76C73v29Ev();
extern void _ZN5S76C73v30Ev();
extern void _ZN5S76C73v31Ev();
extern void _ZN5S76C73v32Ev();
extern void _ZN5S76C73v33Ev();
extern void _ZN5S76C73v34Ev();
extern void _ZN5S76C73v35Ev();
extern void _ZN5S76C73v36Ev();
extern void _ZN5S76C73v37Ev();
extern void _ZN5S76C73v38Ev();
extern void _ZN5S76C73v39Ev();
extern void _ZN5S76C73v40Ev();
extern void _ZN5S76C73v41Ev();
extern void _ZN5S76C73v42Ev();
extern void _ZN5S76C73v43Ev();
extern void _ZN5S76C73v44Ev();
extern void _ZN5S76C73v45Ev();
extern void _ZN5S76C73v46Ev();
extern void _ZN5S76C73v47Ev();
extern void _ZN5S76C73v48Ev();
extern void _ZN5S76C73v49Ev();
extern void _ZN5S76C73v50Ev();
extern void _ZN5S76C73v51Ev();
extern void _ZN5S76C73v52Ev();
extern void _ZN5S76C73v53Ev();
extern void _ZN5S76C73v54Ev();
extern void _ZN5S76C73v55Ev();
extern void _ZN5S76C73v56Ev();
extern void _ZN5S76C73v57Ev();
extern void _ZN5S76C73v58Ev();
extern void _ZN5S76C73v59Ev();
extern void _ZN5S76C73v60Ev();
extern void _ZN5S76C73v61Ev();
extern void _ZN5S76C73v62Ev();
extern void _ZN5S76C73v63Ev();
extern void _ZN5S76C73v64Ev();
extern void _ZN5S76C73v65Ev();
extern void _ZN5S76C73v66Ev();
extern void _ZN5S76C73v67Ev();
extern void _ZN5S76C63v68Ev();
extern void _ZN5S76C63v69Ev();
extern void _ZN5S76C63v70Ev();
extern void _ZN5S76C63v71Ev();
extern void _ZN5S76C63v72Ev();
extern void _ZN5S76C63v73Ev();
extern void _ZN5S76C63v74Ev();
extern void _ZN5S76C63v75Ev();
extern void _ZN5S76C63v76Ev();
extern void _ZN5S76C63v77Ev();
extern void _ZN5S76C63v78Ev();
extern void _ZN5S76C63v79Ev();
extern void _ZN5S76C63v80Ev();
extern void _ZN5S76C63v81Ev();
extern void _ZN5S76C63v82Ev();
extern void _ZN5S76C63v83Ev();
extern void _ZN5S76C63v84Ev();
extern void _ZN5S76C63v85Ev();
extern void _ZN5S76C63v86Ev();
extern void _ZN5S76C63v87Ev();
extern void _ZN5S76C63v88Ev();
extern void _ZN5S76C63v89Ev();
static  VTBL_ENTRY vtc_S76C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S76C6[0]),
  (VTBL_ENTRY)&_ZN5S76C6D1Ev,
  (VTBL_ENTRY)&_ZN5S76C6D0Ev,
  (VTBL_ENTRY)&_ZN5S76C72v4Ev,
  (VTBL_ENTRY)&_ZN5S76C72v5Ev,
  (VTBL_ENTRY)&_ZN5S76C72v6Ev,
  (VTBL_ENTRY)&_ZN5S76C72v7Ev,
  (VTBL_ENTRY)&_ZN5S76C72v8Ev,
  (VTBL_ENTRY)&_ZN5S76C72v9Ev,
  (VTBL_ENTRY)&_ZN5S76C73v10Ev,
  (VTBL_ENTRY)&_ZN5S76C73v11Ev,
  (VTBL_ENTRY)&_ZN5S76C73v12Ev,
  (VTBL_ENTRY)&_ZN5S76C73v13Ev,
  (VTBL_ENTRY)&_ZN5S76C73v14Ev,
  (VTBL_ENTRY)&_ZN5S76C73v15Ev,
  (VTBL_ENTRY)&_ZN5S76C73v16Ev,
  (VTBL_ENTRY)&_ZN5S76C73v17Ev,
  (VTBL_ENTRY)&_ZN5S76C73v18Ev,
  (VTBL_ENTRY)&_ZN5S76C73v19Ev,
  (VTBL_ENTRY)&_ZN5S76C73v20Ev,
  (VTBL_ENTRY)&_ZN5S76C73v21Ev,
  (VTBL_ENTRY)&_ZN5S76C73v22Ev,
  (VTBL_ENTRY)&_ZN5S76C73v23Ev,
  (VTBL_ENTRY)&_ZN5S76C73v24Ev,
  (VTBL_ENTRY)&_ZN5S76C73v25Ev,
  (VTBL_ENTRY)&_ZN5S76C73v26Ev,
  (VTBL_ENTRY)&_ZN5S76C73v27Ev,
  (VTBL_ENTRY)&_ZN5S76C73v28Ev,
  (VTBL_ENTRY)&_ZN5S76C73v29Ev,
  (VTBL_ENTRY)&_ZN5S76C73v30Ev,
  (VTBL_ENTRY)&_ZN5S76C73v31Ev,
  (VTBL_ENTRY)&_ZN5S76C73v32Ev,
  (VTBL_ENTRY)&_ZN5S76C73v33Ev,
  (VTBL_ENTRY)&_ZN5S76C73v34Ev,
  (VTBL_ENTRY)&_ZN5S76C73v35Ev,
  (VTBL_ENTRY)&_ZN5S76C73v36Ev,
  (VTBL_ENTRY)&_ZN5S76C73v37Ev,
  (VTBL_ENTRY)&_ZN5S76C73v38Ev,
  (VTBL_ENTRY)&_ZN5S76C73v39Ev,
  (VTBL_ENTRY)&_ZN5S76C73v40Ev,
  (VTBL_ENTRY)&_ZN5S76C73v41Ev,
  (VTBL_ENTRY)&_ZN5S76C73v42Ev,
  (VTBL_ENTRY)&_ZN5S76C73v43Ev,
  (VTBL_ENTRY)&_ZN5S76C73v44Ev,
  (VTBL_ENTRY)&_ZN5S76C73v45Ev,
  (VTBL_ENTRY)&_ZN5S76C73v46Ev,
  (VTBL_ENTRY)&_ZN5S76C73v47Ev,
  (VTBL_ENTRY)&_ZN5S76C73v48Ev,
  (VTBL_ENTRY)&_ZN5S76C73v49Ev,
  (VTBL_ENTRY)&_ZN5S76C73v50Ev,
  (VTBL_ENTRY)&_ZN5S76C73v51Ev,
  (VTBL_ENTRY)&_ZN5S76C73v52Ev,
  (VTBL_ENTRY)&_ZN5S76C73v53Ev,
  (VTBL_ENTRY)&_ZN5S76C73v54Ev,
  (VTBL_ENTRY)&_ZN5S76C73v55Ev,
  (VTBL_ENTRY)&_ZN5S76C73v56Ev,
  (VTBL_ENTRY)&_ZN5S76C73v57Ev,
  (VTBL_ENTRY)&_ZN5S76C73v58Ev,
  (VTBL_ENTRY)&_ZN5S76C73v59Ev,
  (VTBL_ENTRY)&_ZN5S76C73v60Ev,
  (VTBL_ENTRY)&_ZN5S76C73v61Ev,
  (VTBL_ENTRY)&_ZN5S76C73v62Ev,
  (VTBL_ENTRY)&_ZN5S76C73v63Ev,
  (VTBL_ENTRY)&_ZN5S76C73v64Ev,
  (VTBL_ENTRY)&_ZN5S76C73v65Ev,
  (VTBL_ENTRY)&_ZN5S76C73v66Ev,
  (VTBL_ENTRY)&_ZN5S76C73v67Ev,
  (VTBL_ENTRY)&_ZN5S76C63v68Ev,
  (VTBL_ENTRY)&_ZN5S76C63v69Ev,
  (VTBL_ENTRY)&_ZN5S76C63v70Ev,
  (VTBL_ENTRY)&_ZN5S76C63v71Ev,
  (VTBL_ENTRY)&_ZN5S76C63v72Ev,
  (VTBL_ENTRY)&_ZN5S76C63v73Ev,
  (VTBL_ENTRY)&_ZN5S76C63v74Ev,
  (VTBL_ENTRY)&_ZN5S76C63v75Ev,
  (VTBL_ENTRY)&_ZN5S76C63v76Ev,
  (VTBL_ENTRY)&_ZN5S76C63v77Ev,
  (VTBL_ENTRY)&_ZN5S76C63v78Ev,
  (VTBL_ENTRY)&_ZN5S76C63v79Ev,
  (VTBL_ENTRY)&_ZN5S76C63v80Ev,
  (VTBL_ENTRY)&_ZN5S76C63v81Ev,
  (VTBL_ENTRY)&_ZN5S76C63v82Ev,
  (VTBL_ENTRY)&_ZN5S76C63v83Ev,
  (VTBL_ENTRY)&_ZN5S76C63v84Ev,
  (VTBL_ENTRY)&_ZN5S76C63v85Ev,
  (VTBL_ENTRY)&_ZN5S76C63v86Ev,
  (VTBL_ENTRY)&_ZN5S76C63v87Ev,
  (VTBL_ENTRY)&_ZN5S76C63v88Ev,
  (VTBL_ENTRY)&_ZN5S76C63v89Ev,
};
extern VTBL_ENTRY _ZTI5S76C6[];
extern  VTBL_ENTRY _ZTV5S76C6[];
Class_Descriptor cd_S76C6 = {  "S76C6", // class name
  bases_S76C6, 1,
  &(vtc_S76C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(192,132), // object size
  NSPAIRA(_ZTI5S76C6),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S76C6),90, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S76C5  : S76C6 {
  unsigned int s76c5f0:1;
  unsigned int s76c5f1:1;
  unsigned int s76c5f2:1;
  ::S3216C17 s76c5f3;
  ::S3216C11 s76c5f4;
  ::S3216C5_nt s76c5f5;
  ::S75C20 s76c5f6;
  int s76c5f7[3];
  virtual  ~S76C5(); // _ZN5S76C5D1Ev
  virtual void  v90(); // _ZN5S76C53v90Ev
  virtual void  v91(); // _ZN5S76C53v91Ev
  virtual void  v92(); // _ZN5S76C53v92Ev
  virtual void  v93(); // _ZN5S76C53v93Ev
  virtual void  v94(); // _ZN5S76C53v94Ev
  virtual void  v95(); // _ZN5S76C53v95Ev
  virtual void  v96(); // _ZN5S76C53v96Ev
  virtual void  v97(); // _ZN5S76C53v97Ev
  virtual void  v98(); // _ZN5S76C53v98Ev
  virtual void  v99(); // _ZN5S76C53v99Ev
  virtual void  v100(); // _ZN5S76C54v100Ev
  virtual void  v101(); // _ZN5S76C54v101Ev
  virtual void  v102(); // _ZN5S76C54v102Ev
  virtual void  v103(); // _ZN5S76C54v103Ev
  virtual void  v104(); // _ZN5S76C54v104Ev
  virtual void  v105(); // _ZN5S76C54v105Ev
  virtual void  v106(); // _ZN5S76C54v106Ev
  virtual void  v107(); // _ZN5S76C54v107Ev
  virtual void  v108(); // _ZN5S76C54v108Ev
  virtual void  v109(); // _ZN5S76C54v109Ev
  S76C5(); // tgen
};
//SIG(-1 S76C5) C1{ BC2{ BC3{ vd v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 Fi[2] Fp Fi[2] FC5{ BC6{ BC7{ BC8{ m Fp Fi[2]}}}} FC5 FC9{ m} FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 Fi:1 Fi:1 Fi:1 FC10{ BC11{ BC8}} FC12{ BC13{ BC8}} FC14{ BC15{ BC8}} FC16{ BC17{ BC8}} Fi[3]}


 S76C5 ::~S76C5(){ note_dtor("S76C5", this);}
void  S76C5 ::v90(){vfunc_called(this, "_ZN5S76C53v90Ev");}
void  S76C5 ::v91(){vfunc_called(this, "_ZN5S76C53v91Ev");}
void  S76C5 ::v92(){vfunc_called(this, "_ZN5S76C53v92Ev");}
void  S76C5 ::v93(){vfunc_called(this, "_ZN5S76C53v93Ev");}
void  S76C5 ::v94(){vfunc_called(this, "_ZN5S76C53v94Ev");}
void  S76C5 ::v95(){vfunc_called(this, "_ZN5S76C53v95Ev");}
void  S76C5 ::v96(){vfunc_called(this, "_ZN5S76C53v96Ev");}
void  S76C5 ::v97(){vfunc_called(this, "_ZN5S76C53v97Ev");}
void  S76C5 ::v98(){vfunc_called(this, "_ZN5S76C53v98Ev");}
void  S76C5 ::v99(){vfunc_called(this, "_ZN5S76C53v99Ev");}
void  S76C5 ::v100(){vfunc_called(this, "_ZN5S76C54v100Ev");}
void  S76C5 ::v101(){vfunc_called(this, "_ZN5S76C54v101Ev");}
void  S76C5 ::v102(){vfunc_called(this, "_ZN5S76C54v102Ev");}
void  S76C5 ::v103(){vfunc_called(this, "_ZN5S76C54v103Ev");}
void  S76C5 ::v104(){vfunc_called(this, "_ZN5S76C54v104Ev");}
void  S76C5 ::v105(){vfunc_called(this, "_ZN5S76C54v105Ev");}
void  S76C5 ::v106(){vfunc_called(this, "_ZN5S76C54v106Ev");}
void  S76C5 ::v107(){vfunc_called(this, "_ZN5S76C54v107Ev");}
void  S76C5 ::v108(){vfunc_called(this, "_ZN5S76C54v108Ev");}
void  S76C5 ::v109(){vfunc_called(this, "_ZN5S76C54v109Ev");}
S76C5 ::S76C5(){ note_ctor("S76C5", this);} // tgen

static void Test_S76C5()
{
  extern Class_Descriptor cd_S76C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(35,50)];
    init_test(&cd_S76C5, buf);
    S76C5 *dp, &lv = *(dp=new (buf) S76C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(272,196), "sizeof(S76C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S76C5)");
    check_base_class_offset(lv, (S76C7*)(S76C6*), 0, "S76C5");
    check_base_class_offset(lv, (S76C6*), 0, "S76C5");
    set_bf_and_test(lv, s76c5f0, ABISELECT(188,132), 0, 1, 1, "S76C5");
    set_bf_and_test(lv, s76c5f1, ABISELECT(188,132), 1, 1, 1, "S76C5");
    set_bf_and_test(lv, s76c5f2, ABISELECT(188,132), 2, 1, 1, "S76C5");
    check_field_offset(lv, s76c5f3, ABISELECT(192,136), "S76C5.s76c5f3");
    check_field_offset(lv, s76c5f4, ABISELECT(208,148), "S76C5.s76c5f4");
    check_field_offset(lv, s76c5f5, ABISELECT(224,160), "S76C5.s76c5f5");
    check_field_offset(lv, s76c5f6, ABISELECT(240,172), "S76C5.s76c5f6");
    check_field_offset(lv, s76c5f7, ABISELECT(256,184), "S76C5.s76c5f7");
    test_class_info(&lv, &cd_S76C5);
    dp->~S76C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS76C5(Test_S76C5, "S76C5", ABISELECT(272,196));

#else // __cplusplus

extern void _ZN5S76C5C1Ev();
extern void _ZN5S76C5D1Ev();
Name_Map name_map_S76C5[] = {
  NSPAIR(_ZN5S76C5C1Ev),
  NSPAIR(_ZN5S76C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S76C7;
extern VTBL_ENTRY _ZTI5S76C7[];
extern  VTBL_ENTRY _ZTV5S76C7[];
extern Class_Descriptor cd_S76C6;
extern VTBL_ENTRY _ZTI5S76C6[];
extern  VTBL_ENTRY _ZTV5S76C6[];
static Base_Class bases_S76C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S76C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S76C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S76C5[];
extern void _ZN5S76C5D1Ev();
extern void _ZN5S76C5D0Ev();
extern void _ZN5S76C72v4Ev();
extern void _ZN5S76C72v5Ev();
extern void _ZN5S76C72v6Ev();
extern void _ZN5S76C72v7Ev();
extern void _ZN5S76C72v8Ev();
extern void _ZN5S76C72v9Ev();
extern void _ZN5S76C73v10Ev();
extern void _ZN5S76C73v11Ev();
extern void _ZN5S76C73v12Ev();
extern void _ZN5S76C73v13Ev();
extern void _ZN5S76C73v14Ev();
extern void _ZN5S76C73v15Ev();
extern void _ZN5S76C73v16Ev();
extern void _ZN5S76C73v17Ev();
extern void _ZN5S76C73v18Ev();
extern void _ZN5S76C73v19Ev();
extern void _ZN5S76C73v20Ev();
extern void _ZN5S76C73v21Ev();
extern void _ZN5S76C73v22Ev();
extern void _ZN5S76C73v23Ev();
extern void _ZN5S76C73v24Ev();
extern void _ZN5S76C73v25Ev();
extern void _ZN5S76C73v26Ev();
extern void _ZN5S76C73v27Ev();
extern void _ZN5S76C73v28Ev();
extern void _ZN5S76C73v29Ev();
extern void _ZN5S76C73v30Ev();
extern void _ZN5S76C73v31Ev();
extern void _ZN5S76C73v32Ev();
extern void _ZN5S76C73v33Ev();
extern void _ZN5S76C73v34Ev();
extern void _ZN5S76C73v35Ev();
extern void _ZN5S76C73v36Ev();
extern void _ZN5S76C73v37Ev();
extern void _ZN5S76C73v38Ev();
extern void _ZN5S76C73v39Ev();
extern void _ZN5S76C73v40Ev();
extern void _ZN5S76C73v41Ev();
extern void _ZN5S76C73v42Ev();
extern void _ZN5S76C73v43Ev();
extern void _ZN5S76C73v44Ev();
extern void _ZN5S76C73v45Ev();
extern void _ZN5S76C73v46Ev();
extern void _ZN5S76C73v47Ev();
extern void _ZN5S76C73v48Ev();
extern void _ZN5S76C73v49Ev();
extern void _ZN5S76C73v50Ev();
extern void _ZN5S76C73v51Ev();
extern void _ZN5S76C73v52Ev();
extern void _ZN5S76C73v53Ev();
extern void _ZN5S76C73v54Ev();
extern void _ZN5S76C73v55Ev();
extern void _ZN5S76C73v56Ev();
extern void _ZN5S76C73v57Ev();
extern void _ZN5S76C73v58Ev();
extern void _ZN5S76C73v59Ev();
extern void _ZN5S76C73v60Ev();
extern void _ZN5S76C73v61Ev();
extern void _ZN5S76C73v62Ev();
extern void _ZN5S76C73v63Ev();
extern void _ZN5S76C73v64Ev();
extern void _ZN5S76C73v65Ev();
extern void _ZN5S76C73v66Ev();
extern void _ZN5S76C73v67Ev();
extern void _ZN5S76C63v68Ev();
extern void _ZN5S76C63v69Ev();
extern void _ZN5S76C63v70Ev();
extern void _ZN5S76C63v71Ev();
extern void _ZN5S76C63v72Ev();
extern void _ZN5S76C63v73Ev();
extern void _ZN5S76C63v74Ev();
extern void _ZN5S76C63v75Ev();
extern void _ZN5S76C63v76Ev();
extern void _ZN5S76C63v77Ev();
extern void _ZN5S76C63v78Ev();
extern void _ZN5S76C63v79Ev();
extern void _ZN5S76C63v80Ev();
extern void _ZN5S76C63v81Ev();
extern void _ZN5S76C63v82Ev();
extern void _ZN5S76C63v83Ev();
extern void _ZN5S76C63v84Ev();
extern void _ZN5S76C63v85Ev();
extern void _ZN5S76C63v86Ev();
extern void _ZN5S76C63v87Ev();
extern void _ZN5S76C63v88Ev();
extern void _ZN5S76C63v89Ev();
extern void _ZN5S76C53v90Ev();
extern void _ZN5S76C53v91Ev();
extern void _ZN5S76C53v92Ev();
extern void _ZN5S76C53v93Ev();
extern void _ZN5S76C53v94Ev();
extern void _ZN5S76C53v95Ev();
extern void _ZN5S76C53v96Ev();
extern void _ZN5S76C53v97Ev();
extern void _ZN5S76C53v98Ev();
extern void _ZN5S76C53v99Ev();
extern void _ZN5S76C54v100Ev();
extern void _ZN5S76C54v101Ev();
extern void _ZN5S76C54v102Ev();
extern void _ZN5S76C54v103Ev();
extern void _ZN5S76C54v104Ev();
extern void _ZN5S76C54v105Ev();
extern void _ZN5S76C54v106Ev();
extern void _ZN5S76C54v107Ev();
extern void _ZN5S76C54v108Ev();
extern void _ZN5S76C54v109Ev();
static  VTBL_ENTRY vtc_S76C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S76C5[0]),
  (VTBL_ENTRY)&_ZN5S76C5D1Ev,
  (VTBL_ENTRY)&_ZN5S76C5D0Ev,
  (VTBL_ENTRY)&_ZN5S76C72v4Ev,
  (VTBL_ENTRY)&_ZN5S76C72v5Ev,
  (VTBL_ENTRY)&_ZN5S76C72v6Ev,
  (VTBL_ENTRY)&_ZN5S76C72v7Ev,
  (VTBL_ENTRY)&_ZN5S76C72v8Ev,
  (VTBL_ENTRY)&_ZN5S76C72v9Ev,
  (VTBL_ENTRY)&_ZN5S76C73v10Ev,
  (VTBL_ENTRY)&_ZN5S76C73v11Ev,
  (VTBL_ENTRY)&_ZN5S76C73v12Ev,
  (VTBL_ENTRY)&_ZN5S76C73v13Ev,
  (VTBL_ENTRY)&_ZN5S76C73v14Ev,
  (VTBL_ENTRY)&_ZN5S76C73v15Ev,
  (VTBL_ENTRY)&_ZN5S76C73v16Ev,
  (VTBL_ENTRY)&_ZN5S76C73v17Ev,
  (VTBL_ENTRY)&_ZN5S76C73v18Ev,
  (VTBL_ENTRY)&_ZN5S76C73v19Ev,
  (VTBL_ENTRY)&_ZN5S76C73v20Ev,
  (VTBL_ENTRY)&_ZN5S76C73v21Ev,
  (VTBL_ENTRY)&_ZN5S76C73v22Ev,
  (VTBL_ENTRY)&_ZN5S76C73v23Ev,
  (VTBL_ENTRY)&_ZN5S76C73v24Ev,
  (VTBL_ENTRY)&_ZN5S76C73v25Ev,
  (VTBL_ENTRY)&_ZN5S76C73v26Ev,
  (VTBL_ENTRY)&_ZN5S76C73v27Ev,
  (VTBL_ENTRY)&_ZN5S76C73v28Ev,
  (VTBL_ENTRY)&_ZN5S76C73v29Ev,
  (VTBL_ENTRY)&_ZN5S76C73v30Ev,
  (VTBL_ENTRY)&_ZN5S76C73v31Ev,
  (VTBL_ENTRY)&_ZN5S76C73v32Ev,
  (VTBL_ENTRY)&_ZN5S76C73v33Ev,
  (VTBL_ENTRY)&_ZN5S76C73v34Ev,
  (VTBL_ENTRY)&_ZN5S76C73v35Ev,
  (VTBL_ENTRY)&_ZN5S76C73v36Ev,
  (VTBL_ENTRY)&_ZN5S76C73v37Ev,
  (VTBL_ENTRY)&_ZN5S76C73v38Ev,
  (VTBL_ENTRY)&_ZN5S76C73v39Ev,
  (VTBL_ENTRY)&_ZN5S76C73v40Ev,
  (VTBL_ENTRY)&_ZN5S76C73v41Ev,
  (VTBL_ENTRY)&_ZN5S76C73v42Ev,
  (VTBL_ENTRY)&_ZN5S76C73v43Ev,
  (VTBL_ENTRY)&_ZN5S76C73v44Ev,
  (VTBL_ENTRY)&_ZN5S76C73v45Ev,
  (VTBL_ENTRY)&_ZN5S76C73v46Ev,
  (VTBL_ENTRY)&_ZN5S76C73v47Ev,
  (VTBL_ENTRY)&_ZN5S76C73v48Ev,
  (VTBL_ENTRY)&_ZN5S76C73v49Ev,
  (VTBL_ENTRY)&_ZN5S76C73v50Ev,
  (VTBL_ENTRY)&_ZN5S76C73v51Ev,
  (VTBL_ENTRY)&_ZN5S76C73v52Ev,
  (VTBL_ENTRY)&_ZN5S76C73v53Ev,
  (VTBL_ENTRY)&_ZN5S76C73v54Ev,
  (VTBL_ENTRY)&_ZN5S76C73v55Ev,
  (VTBL_ENTRY)&_ZN5S76C73v56Ev,
  (VTBL_ENTRY)&_ZN5S76C73v57Ev,
  (VTBL_ENTRY)&_ZN5S76C73v58Ev,
  (VTBL_ENTRY)&_ZN5S76C73v59Ev,
  (VTBL_ENTRY)&_ZN5S76C73v60Ev,
  (VTBL_ENTRY)&_ZN5S76C73v61Ev,
  (VTBL_ENTRY)&_ZN5S76C73v62Ev,
  (VTBL_ENTRY)&_ZN5S76C73v63Ev,
  (VTBL_ENTRY)&_ZN5S76C73v64Ev,
  (VTBL_ENTRY)&_ZN5S76C73v65Ev,
  (VTBL_ENTRY)&_ZN5S76C73v66Ev,
  (VTBL_ENTRY)&_ZN5S76C73v67Ev,
  (VTBL_ENTRY)&_ZN5S76C63v68Ev,
  (VTBL_ENTRY)&_ZN5S76C63v69Ev,
  (VTBL_ENTRY)&_ZN5S76C63v70Ev,
  (VTBL_ENTRY)&_ZN5S76C63v71Ev,
  (VTBL_ENTRY)&_ZN5S76C63v72Ev,
  (VTBL_ENTRY)&_ZN5S76C63v73Ev,
  (VTBL_ENTRY)&_ZN5S76C63v74Ev,
  (VTBL_ENTRY)&_ZN5S76C63v75Ev,
  (VTBL_ENTRY)&_ZN5S76C63v76Ev,
  (VTBL_ENTRY)&_ZN5S76C63v77Ev,
  (VTBL_ENTRY)&_ZN5S76C63v78Ev,
  (VTBL_ENTRY)&_ZN5S76C63v79Ev,
  (VTBL_ENTRY)&_ZN5S76C63v80Ev,
  (VTBL_ENTRY)&_ZN5S76C63v81Ev,
  (VTBL_ENTRY)&_ZN5S76C63v82Ev,
  (VTBL_ENTRY)&_ZN5S76C63v83Ev,
  (VTBL_ENTRY)&_ZN5S76C63v84Ev,
  (VTBL_ENTRY)&_ZN5S76C63v85Ev,
  (VTBL_ENTRY)&_ZN5S76C63v86Ev,
  (VTBL_ENTRY)&_ZN5S76C63v87Ev,
  (VTBL_ENTRY)&_ZN5S76C63v88Ev,
  (VTBL_ENTRY)&_ZN5S76C63v89Ev,
  (VTBL_ENTRY)&_ZN5S76C53v90Ev,
  (VTBL_ENTRY)&_ZN5S76C53v91Ev,
  (VTBL_ENTRY)&_ZN5S76C53v92Ev,
  (VTBL_ENTRY)&_ZN5S76C53v93Ev,
  (VTBL_ENTRY)&_ZN5S76C53v94Ev,
  (VTBL_ENTRY)&_ZN5S76C53v95Ev,
  (VTBL_ENTRY)&_ZN5S76C53v96Ev,
  (VTBL_ENTRY)&_ZN5S76C53v97Ev,
  (VTBL_ENTRY)&_ZN5S76C53v98Ev,
  (VTBL_ENTRY)&_ZN5S76C53v99Ev,
  (VTBL_ENTRY)&_ZN5S76C54v100Ev,
  (VTBL_ENTRY)&_ZN5S76C54v101Ev,
  (VTBL_ENTRY)&_ZN5S76C54v102Ev,
  (VTBL_ENTRY)&_ZN5S76C54v103Ev,
  (VTBL_ENTRY)&_ZN5S76C54v104Ev,
  (VTBL_ENTRY)&_ZN5S76C54v105Ev,
  (VTBL_ENTRY)&_ZN5S76C54v106Ev,
  (VTBL_ENTRY)&_ZN5S76C54v107Ev,
  (VTBL_ENTRY)&_ZN5S76C54v108Ev,
  (VTBL_ENTRY)&_ZN5S76C54v109Ev,
};
extern VTBL_ENTRY _ZTI5S76C5[];
extern  VTBL_ENTRY _ZTV5S76C5[];
Class_Descriptor cd_S76C5 = {  "S76C5", // class name
  bases_S76C5, 2,
  &(vtc_S76C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(272,196), // object size
  NSPAIRA(_ZTI5S76C5),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S76C5),110, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S76C4  : S76C5 {
  ::S3216C4_nt s76c4f0;
  unsigned int s76c4f1:1;
  ::S75C10 s76c4f2;
  virtual  ~S76C4(); // _ZN5S76C4D1Ev
  virtual void  v110(); // _ZN5S76C44v110Ev
  virtual void  v111(); // _ZN5S76C44v111Ev
  virtual void  v112(); // _ZN5S76C44v112Ev
  virtual void  v113(); // _ZN5S76C44v113Ev
  S76C4(); // tgen
};
//SIG(-1 S76C4) C1{ BC2{ BC3{ BC4{ vd v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 Fi[2] Fp Fi[2] FC6{ BC7{ BC8{ BC9{ m Fp Fi[2]}}}} FC6 FC10{ m} FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 Fi:1 Fi:1 Fi:1 FC11{ BC12{ BC9}} FC13{ BC14{ BC9}} FC15{ BC16{ BC9}} FC17{ BC18{ BC9}} Fi[3]} vd v1 v2 v3 v4 FC5 Fi:1 FC7}


 S76C4 ::~S76C4(){ note_dtor("S76C4", this);}
void  S76C4 ::v110(){vfunc_called(this, "_ZN5S76C44v110Ev");}
void  S76C4 ::v111(){vfunc_called(this, "_ZN5S76C44v111Ev");}
void  S76C4 ::v112(){vfunc_called(this, "_ZN5S76C44v112Ev");}
void  S76C4 ::v113(){vfunc_called(this, "_ZN5S76C44v113Ev");}
S76C4 ::S76C4(){ note_ctor("S76C4", this);} // tgen

static void Test_S76C4()
{
  extern Class_Descriptor cd_S76C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(38,56)];
    init_test(&cd_S76C4, buf);
    S76C4 *dp, &lv = *(dp=new (buf) S76C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(296,220), "sizeof(S76C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S76C4)");
    check_base_class_offset(lv, (S76C7*)(S76C6*)(S76C5*), 0, "S76C4");
    check_base_class_offset(lv, (S76C6*)(S76C5*), 0, "S76C4");
    check_base_class_offset(lv, (S76C5*), 0, "S76C4");
    check_field_offset(lv, s76c4f0, ABISELECT(268,196), "S76C4.s76c4f0");
    set_bf_and_test(lv, s76c4f1, ABISELECT(276,204), 0, 1, 1, "S76C4");
    check_field_offset(lv, s76c4f2, ABISELECT(280,208), "S76C4.s76c4f2");
    test_class_info(&lv, &cd_S76C4);
    dp->~S76C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS76C4(Test_S76C4, "S76C4", ABISELECT(296,220));

#else // __cplusplus

extern void _ZN5S76C4C1Ev();
extern void _ZN5S76C4D1Ev();
Name_Map name_map_S76C4[] = {
  NSPAIR(_ZN5S76C4C1Ev),
  NSPAIR(_ZN5S76C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S76C7;
extern VTBL_ENTRY _ZTI5S76C7[];
extern  VTBL_ENTRY _ZTV5S76C7[];
extern Class_Descriptor cd_S76C6;
extern VTBL_ENTRY _ZTI5S76C6[];
extern  VTBL_ENTRY _ZTV5S76C6[];
extern Class_Descriptor cd_S76C5;
extern VTBL_ENTRY _ZTI5S76C5[];
extern  VTBL_ENTRY _ZTV5S76C5[];
static Base_Class bases_S76C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S76C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S76C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S76C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S76C4[];
extern void _ZN5S76C4D1Ev();
extern void _ZN5S76C4D0Ev();
extern void _ZN5S76C72v4Ev();
extern void _ZN5S76C72v5Ev();
extern void _ZN5S76C72v6Ev();
extern void _ZN5S76C72v7Ev();
extern void _ZN5S76C72v8Ev();
extern void _ZN5S76C72v9Ev();
extern void _ZN5S76C73v10Ev();
extern void _ZN5S76C73v11Ev();
extern void _ZN5S76C73v12Ev();
extern void _ZN5S76C73v13Ev();
extern void _ZN5S76C73v14Ev();
extern void _ZN5S76C73v15Ev();
extern void _ZN5S76C73v16Ev();
extern void _ZN5S76C73v17Ev();
extern void _ZN5S76C73v18Ev();
extern void _ZN5S76C73v19Ev();
extern void _ZN5S76C73v20Ev();
extern void _ZN5S76C73v21Ev();
extern void _ZN5S76C73v22Ev();
extern void _ZN5S76C73v23Ev();
extern void _ZN5S76C73v24Ev();
extern void _ZN5S76C73v25Ev();
extern void _ZN5S76C73v26Ev();
extern void _ZN5S76C73v27Ev();
extern void _ZN5S76C73v28Ev();
extern void _ZN5S76C73v29Ev();
extern void _ZN5S76C73v30Ev();
extern void _ZN5S76C73v31Ev();
extern void _ZN5S76C73v32Ev();
extern void _ZN5S76C73v33Ev();
extern void _ZN5S76C73v34Ev();
extern void _ZN5S76C73v35Ev();
extern void _ZN5S76C73v36Ev();
extern void _ZN5S76C73v37Ev();
extern void _ZN5S76C73v38Ev();
extern void _ZN5S76C73v39Ev();
extern void _ZN5S76C73v40Ev();
extern void _ZN5S76C73v41Ev();
extern void _ZN5S76C73v42Ev();
extern void _ZN5S76C73v43Ev();
extern void _ZN5S76C73v44Ev();
extern void _ZN5S76C73v45Ev();
extern void _ZN5S76C73v46Ev();
extern void _ZN5S76C73v47Ev();
extern void _ZN5S76C73v48Ev();
extern void _ZN5S76C73v49Ev();
extern void _ZN5S76C73v50Ev();
extern void _ZN5S76C73v51Ev();
extern void _ZN5S76C73v52Ev();
extern void _ZN5S76C73v53Ev();
extern void _ZN5S76C73v54Ev();
extern void _ZN5S76C73v55Ev();
extern void _ZN5S76C73v56Ev();
extern void _ZN5S76C73v57Ev();
extern void _ZN5S76C73v58Ev();
extern void _ZN5S76C73v59Ev();
extern void _ZN5S76C73v60Ev();
extern void _ZN5S76C73v61Ev();
extern void _ZN5S76C73v62Ev();
extern void _ZN5S76C73v63Ev();
extern void _ZN5S76C73v64Ev();
extern void _ZN5S76C73v65Ev();
extern void _ZN5S76C73v66Ev();
extern void _ZN5S76C73v67Ev();
extern void _ZN5S76C63v68Ev();
extern void _ZN5S76C63v69Ev();
extern void _ZN5S76C63v70Ev();
extern void _ZN5S76C63v71Ev();
extern void _ZN5S76C63v72Ev();
extern void _ZN5S76C63v73Ev();
extern void _ZN5S76C63v74Ev();
extern void _ZN5S76C63v75Ev();
extern void _ZN5S76C63v76Ev();
extern void _ZN5S76C63v77Ev();
extern void _ZN5S76C63v78Ev();
extern void _ZN5S76C63v79Ev();
extern void _ZN5S76C63v80Ev();
extern void _ZN5S76C63v81Ev();
extern void _ZN5S76C63v82Ev();
extern void _ZN5S76C63v83Ev();
extern void _ZN5S76C63v84Ev();
extern void _ZN5S76C63v85Ev();
extern void _ZN5S76C63v86Ev();
extern void _ZN5S76C63v87Ev();
extern void _ZN5S76C63v88Ev();
extern void _ZN5S76C63v89Ev();
extern void _ZN5S76C53v90Ev();
extern void _ZN5S76C53v91Ev();
extern void _ZN5S76C53v92Ev();
extern void _ZN5S76C53v93Ev();
extern void _ZN5S76C53v94Ev();
extern void _ZN5S76C53v95Ev();
extern void _ZN5S76C53v96Ev();
extern void _ZN5S76C53v97Ev();
extern void _ZN5S76C53v98Ev();
extern void _ZN5S76C53v99Ev();
extern void _ZN5S76C54v100Ev();
extern void _ZN5S76C54v101Ev();
extern void _ZN5S76C54v102Ev();
extern void _ZN5S76C54v103Ev();
extern void _ZN5S76C54v104Ev();
extern void _ZN5S76C54v105Ev();
extern void _ZN5S76C54v106Ev();
extern void _ZN5S76C54v107Ev();
extern void _ZN5S76C54v108Ev();
extern void _ZN5S76C54v109Ev();
extern void _ZN5S76C44v110Ev();
extern void _ZN5S76C44v111Ev();
extern void _ZN5S76C44v112Ev();
extern void _ZN5S76C44v113Ev();
static  VTBL_ENTRY vtc_S76C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S76C4[0]),
  (VTBL_ENTRY)&_ZN5S76C4D1Ev,
  (VTBL_ENTRY)&_ZN5S76C4D0Ev,
  (VTBL_ENTRY)&_ZN5S76C72v4Ev,
  (VTBL_ENTRY)&_ZN5S76C72v5Ev,
  (VTBL_ENTRY)&_ZN5S76C72v6Ev,
  (VTBL_ENTRY)&_ZN5S76C72v7Ev,
  (VTBL_ENTRY)&_ZN5S76C72v8Ev,
  (VTBL_ENTRY)&_ZN5S76C72v9Ev,
  (VTBL_ENTRY)&_ZN5S76C73v10Ev,
  (VTBL_ENTRY)&_ZN5S76C73v11Ev,
  (VTBL_ENTRY)&_ZN5S76C73v12Ev,
  (VTBL_ENTRY)&_ZN5S76C73v13Ev,
  (VTBL_ENTRY)&_ZN5S76C73v14Ev,
  (VTBL_ENTRY)&_ZN5S76C73v15Ev,
  (VTBL_ENTRY)&_ZN5S76C73v16Ev,
  (VTBL_ENTRY)&_ZN5S76C73v17Ev,
  (VTBL_ENTRY)&_ZN5S76C73v18Ev,
  (VTBL_ENTRY)&_ZN5S76C73v19Ev,
  (VTBL_ENTRY)&_ZN5S76C73v20Ev,
  (VTBL_ENTRY)&_ZN5S76C73v21Ev,
  (VTBL_ENTRY)&_ZN5S76C73v22Ev,
  (VTBL_ENTRY)&_ZN5S76C73v23Ev,
  (VTBL_ENTRY)&_ZN5S76C73v24Ev,
  (VTBL_ENTRY)&_ZN5S76C73v25Ev,
  (VTBL_ENTRY)&_ZN5S76C73v26Ev,
  (VTBL_ENTRY)&_ZN5S76C73v27Ev,
  (VTBL_ENTRY)&_ZN5S76C73v28Ev,
  (VTBL_ENTRY)&_ZN5S76C73v29Ev,
  (VTBL_ENTRY)&_ZN5S76C73v30Ev,
  (VTBL_ENTRY)&_ZN5S76C73v31Ev,
  (VTBL_ENTRY)&_ZN5S76C73v32Ev,
  (VTBL_ENTRY)&_ZN5S76C73v33Ev,
  (VTBL_ENTRY)&_ZN5S76C73v34Ev,
  (VTBL_ENTRY)&_ZN5S76C73v35Ev,
  (VTBL_ENTRY)&_ZN5S76C73v36Ev,
  (VTBL_ENTRY)&_ZN5S76C73v37Ev,
  (VTBL_ENTRY)&_ZN5S76C73v38Ev,
  (VTBL_ENTRY)&_ZN5S76C73v39Ev,
  (VTBL_ENTRY)&_ZN5S76C73v40Ev,
  (VTBL_ENTRY)&_ZN5S76C73v41Ev,
  (VTBL_ENTRY)&_ZN5S76C73v42Ev,
  (VTBL_ENTRY)&_ZN5S76C73v43Ev,
  (VTBL_ENTRY)&_ZN5S76C73v44Ev,
  (VTBL_ENTRY)&_ZN5S76C73v45Ev,
  (VTBL_ENTRY)&_ZN5S76C73v46Ev,
  (VTBL_ENTRY)&_ZN5S76C73v47Ev,
  (VTBL_ENTRY)&_ZN5S76C73v48Ev,
  (VTBL_ENTRY)&_ZN5S76C73v49Ev,
  (VTBL_ENTRY)&_ZN5S76C73v50Ev,
  (VTBL_ENTRY)&_ZN5S76C73v51Ev,
  (VTBL_ENTRY)&_ZN5S76C73v52Ev,
  (VTBL_ENTRY)&_ZN5S76C73v53Ev,
  (VTBL_ENTRY)&_ZN5S76C73v54Ev,
  (VTBL_ENTRY)&_ZN5S76C73v55Ev,
  (VTBL_ENTRY)&_ZN5S76C73v56Ev,
  (VTBL_ENTRY)&_ZN5S76C73v57Ev,
  (VTBL_ENTRY)&_ZN5S76C73v58Ev,
  (VTBL_ENTRY)&_ZN5S76C73v59Ev,
  (VTBL_ENTRY)&_ZN5S76C73v60Ev,
  (VTBL_ENTRY)&_ZN5S76C73v61Ev,
  (VTBL_ENTRY)&_ZN5S76C73v62Ev,
  (VTBL_ENTRY)&_ZN5S76C73v63Ev,
  (VTBL_ENTRY)&_ZN5S76C73v64Ev,
  (VTBL_ENTRY)&_ZN5S76C73v65Ev,
  (VTBL_ENTRY)&_ZN5S76C73v66Ev,
  (VTBL_ENTRY)&_ZN5S76C73v67Ev,
  (VTBL_ENTRY)&_ZN5S76C63v68Ev,
  (VTBL_ENTRY)&_ZN5S76C63v69Ev,
  (VTBL_ENTRY)&_ZN5S76C63v70Ev,
  (VTBL_ENTRY)&_ZN5S76C63v71Ev,
  (VTBL_ENTRY)&_ZN5S76C63v72Ev,
  (VTBL_ENTRY)&_ZN5S76C63v73Ev,
  (VTBL_ENTRY)&_ZN5S76C63v74Ev,
  (VTBL_ENTRY)&_ZN5S76C63v75Ev,
  (VTBL_ENTRY)&_ZN5S76C63v76Ev,
  (VTBL_ENTRY)&_ZN5S76C63v77Ev,
  (VTBL_ENTRY)&_ZN5S76C63v78Ev,
  (VTBL_ENTRY)&_ZN5S76C63v79Ev,
  (VTBL_ENTRY)&_ZN5S76C63v80Ev,
  (VTBL_ENTRY)&_ZN5S76C63v81Ev,
  (VTBL_ENTRY)&_ZN5S76C63v82Ev,
  (VTBL_ENTRY)&_ZN5S76C63v83Ev,
  (VTBL_ENTRY)&_ZN5S76C63v84Ev,
  (VTBL_ENTRY)&_ZN5S76C63v85Ev,
  (VTBL_ENTRY)&_ZN5S76C63v86Ev,
  (VTBL_ENTRY)&_ZN5S76C63v87Ev,
  (VTBL_ENTRY)&_ZN5S76C63v88Ev,
  (VTBL_ENTRY)&_ZN5S76C63v89Ev,
  (VTBL_ENTRY)&_ZN5S76C53v90Ev,
  (VTBL_ENTRY)&_ZN5S76C53v91Ev,
  (VTBL_ENTRY)&_ZN5S76C53v92Ev,
  (VTBL_ENTRY)&_ZN5S76C53v93Ev,
  (VTBL_ENTRY)&_ZN5S76C53v94Ev,
  (VTBL_ENTRY)&_ZN5S76C53v95Ev,
  (VTBL_ENTRY)&_ZN5S76C53v96Ev,
  (VTBL_ENTRY)&_ZN5S76C53v97Ev,
  (VTBL_ENTRY)&_ZN5S76C53v98Ev,
  (VTBL_ENTRY)&_ZN5S76C53v99Ev,
  (VTBL_ENTRY)&_ZN5S76C54v100Ev,
  (VTBL_ENTRY)&_ZN5S76C54v101Ev,
  (VTBL_ENTRY)&_ZN5S76C54v102Ev,
  (VTBL_ENTRY)&_ZN5S76C54v103Ev,
  (VTBL_ENTRY)&_ZN5S76C54v104Ev,
  (VTBL_ENTRY)&_ZN5S76C54v105Ev,
  (VTBL_ENTRY)&_ZN5S76C54v106Ev,
  (VTBL_ENTRY)&_ZN5S76C54v107Ev,
  (VTBL_ENTRY)&_ZN5S76C54v108Ev,
  (VTBL_ENTRY)&_ZN5S76C54v109Ev,
  (VTBL_ENTRY)&_ZN5S76C44v110Ev,
  (VTBL_ENTRY)&_ZN5S76C44v111Ev,
  (VTBL_ENTRY)&_ZN5S76C44v112Ev,
  (VTBL_ENTRY)&_ZN5S76C44v113Ev,
};
extern VTBL_ENTRY _ZTI5S76C4[];
extern  VTBL_ENTRY _ZTV5S76C4[];
Class_Descriptor cd_S76C4 = {  "S76C4", // class name
  bases_S76C4, 3,
  &(vtc_S76C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(296,220), // object size
  NSPAIRA(_ZTI5S76C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S76C4),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S76C3  : S76C4 {
  int s76c3f0;
  unsigned int s76c3f1:1;
  virtual  ~S76C3(); // _ZN5S76C3D1Ev
  virtual void  v114(); // _ZN5S76C34v114Ev
  virtual void  v115(); // _ZN5S76C34v115Ev
  virtual void  v116(); // _ZN5S76C34v116Ev
  virtual void  v117(); // _ZN5S76C34v117Ev
  virtual void  v118(); // _ZN5S76C34v118Ev
  virtual void  v119(); // _ZN5S76C34v119Ev
  virtual void  v120(); // _ZN5S76C34v120Ev
  virtual void  v121(); // _ZN5S76C34v121Ev
  S76C3(); // tgen
};
//SIG(-1 S76C3) C1{ BC2{ BC3{ BC4{ BC5{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 Fi FL Fp[4] Fi[2] Fp FC6{ m Fi[2]} Fp[2]} vd v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 Fi[2] Fp Fi[2] FC7{ BC8{ BC9{ BC10{ m Fp Fi[2]}}}} FC7 FC11{ m} FC7 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 Fi:1 Fi:1 Fi:1 FC12{ BC13{ BC10}} FC14{ BC15{ BC10}} FC16{ BC17{ BC10}} FC18{ BC19{ BC10}} Fi[3]} vd v115 v116 v117 v118 FC6 Fi:1 FC8} vd v1 v2 v3 v4 v5 v6 v7 v8 Fi Fi:1}


 S76C3 ::~S76C3(){ note_dtor("S76C3", this);}
void  S76C3 ::v114(){vfunc_called(this, "_ZN5S76C34v114Ev");}
void  S76C3 ::v115(){vfunc_called(this, "_ZN5S76C34v115Ev");}
void  S76C3 ::v116(){vfunc_called(this, "_ZN5S76C34v116Ev");}
void  S76C3 ::v117(){vfunc_called(this, "_ZN5S76C34v117Ev");}
void  S76C3 ::v118(){vfunc_called(this, "_ZN5S76C34v118Ev");}
void  S76C3 ::v119(){vfunc_called(this, "_ZN5S76C34v119Ev");}
void  S76C3 ::v120(){vfunc_called(this, "_ZN5S76C34v120Ev");}
void  S76C3 ::v121(){vfunc_called(this, "_ZN5S76C34v121Ev");}
S76C3 ::S76C3(){ note_ctor("S76C3", this);} // tgen

static void Test_S76C3()
{
  extern Class_Descriptor cd_S76C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(39,58)];
    init_test(&cd_S76C3, buf);
    S76C3 *dp, &lv = *(dp=new (buf) S76C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(304,228), "sizeof(S76C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S76C3)");
    check_base_class_offset(lv, (S76C7*)(S76C6*)(S76C5*)(S76C4*), 0, "S76C3");
    check_base_class_offset(lv, (S76C6*)(S76C5*)(S76C4*), 0, "S76C3");
    check_base_class_offset(lv, (S76C5*)(S76C4*), 0, "S76C3");
    check_base_class_offset(lv, (S76C4*), 0, "S76C3");
    check_field_offset(lv, s76c3f0, ABISELECT(296,220), "S76C3.s76c3f0");
    set_bf_and_test(lv, s76c3f1, ABISELECT(300,224), 0, 1, 1, "S76C3");
    test_class_info(&lv, &cd_S76C3);
    dp->~S76C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS76C3(Test_S76C3, "S76C3", ABISELECT(304,228));

#else // __cplusplus

extern void _ZN5S76C3C1Ev();
extern void _ZN5S76C3D1Ev();
Name_Map name_map_S76C3[] = {
  NSPAIR(_ZN5S76C3C1Ev),
  NSPAIR(_ZN5S76C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S76C7;
extern VTBL_ENTRY _ZTI5S76C7[];
extern  VTBL_ENTRY _ZTV5S76C7[];
extern Class_Descriptor cd_S76C6;
extern VTBL_ENTRY _ZTI5S76C6[];
extern  VTBL_ENTRY _ZTV5S76C6[];
extern Class_Descriptor cd_S76C5;
extern VTBL_ENTRY _ZTI5S76C5[];
extern  VTBL_ENTRY _ZTV5S76C5[];
extern Class_Descriptor cd_S76C4;
extern VTBL_ENTRY _ZTI5S76C4[];
extern  VTBL_ENTRY _ZTV5S76C4[];
static Base_Class bases_S76C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S76C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S76C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S76C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S76C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S76C3[];
extern void _ZN5S76C3D1Ev();
extern void _ZN5S76C3D0Ev();
extern void _ZN5S76C72v4Ev();
extern void _ZN5S76C72v5Ev();
extern void _ZN5S76C72v6Ev();
extern void _ZN5S76C72v7Ev();
extern void _ZN5S76C72v8Ev();
extern void _ZN5S76C72v9Ev();
extern void _ZN5S76C73v10Ev();
extern void _ZN5S76C73v11Ev();
extern void _ZN5S76C73v12Ev();
extern void _ZN5S76C73v13Ev();
extern void _ZN5S76C73v14Ev();
extern void _ZN5S76C73v15Ev();
extern void _ZN5S76C73v16Ev();
extern void _ZN5S76C73v17Ev();
extern void _ZN5S76C73v18Ev();
extern void _ZN5S76C73v19Ev();
extern void _ZN5S76C73v20Ev();
extern void _ZN5S76C73v21Ev();
extern void _ZN5S76C73v22Ev();
extern void _ZN5S76C73v23Ev();
extern void _ZN5S76C73v24Ev();
extern void _ZN5S76C73v25Ev();
extern void _ZN5S76C73v26Ev();
extern void _ZN5S76C73v27Ev();
extern void _ZN5S76C73v28Ev();
extern void _ZN5S76C73v29Ev();
extern void _ZN5S76C73v30Ev();
extern void _ZN5S76C73v31Ev();
extern void _ZN5S76C73v32Ev();
extern void _ZN5S76C73v33Ev();
extern void _ZN5S76C73v34Ev();
extern void _ZN5S76C73v35Ev();
extern void _ZN5S76C73v36Ev();
extern void _ZN5S76C73v37Ev();
extern void _ZN5S76C73v38Ev();
extern void _ZN5S76C73v39Ev();
extern void _ZN5S76C73v40Ev();
extern void _ZN5S76C73v41Ev();
extern void _ZN5S76C73v42Ev();
extern void _ZN5S76C73v43Ev();
extern void _ZN5S76C73v44Ev();
extern void _ZN5S76C73v45Ev();
extern void _ZN5S76C73v46Ev();
extern void _ZN5S76C73v47Ev();
extern void _ZN5S76C73v48Ev();
extern void _ZN5S76C73v49Ev();
extern void _ZN5S76C73v50Ev();
extern void _ZN5S76C73v51Ev();
extern void _ZN5S76C73v52Ev();
extern void _ZN5S76C73v53Ev();
extern void _ZN5S76C73v54Ev();
extern void _ZN5S76C73v55Ev();
extern void _ZN5S76C73v56Ev();
extern void _ZN5S76C73v57Ev();
extern void _ZN5S76C73v58Ev();
extern void _ZN5S76C73v59Ev();
extern void _ZN5S76C73v60Ev();
extern void _ZN5S76C73v61Ev();
extern void _ZN5S76C73v62Ev();
extern void _ZN5S76C73v63Ev();
extern void _ZN5S76C73v64Ev();
extern void _ZN5S76C73v65Ev();
extern void _ZN5S76C73v66Ev();
extern void _ZN5S76C73v67Ev();
extern void _ZN5S76C63v68Ev();
extern void _ZN5S76C63v69Ev();
extern void _ZN5S76C63v70Ev();
extern void _ZN5S76C63v71Ev();
extern void _ZN5S76C63v72Ev();
extern void _ZN5S76C63v73Ev();
extern void _ZN5S76C63v74Ev();
extern void _ZN5S76C63v75Ev();
extern void _ZN5S76C63v76Ev();
extern void _ZN5S76C63v77Ev();
extern void _ZN5S76C63v78Ev();
extern void _ZN5S76C63v79Ev();
extern void _ZN5S76C63v80Ev();
extern void _ZN5S76C63v81Ev();
extern void _ZN5S76C63v82Ev();
extern void _ZN5S76C63v83Ev();
extern void _ZN5S76C63v84Ev();
extern void _ZN5S76C63v85Ev();
extern void _ZN5S76C63v86Ev();
extern void _ZN5S76C63v87Ev();
extern void _ZN5S76C63v88Ev();
extern void _ZN5S76C63v89Ev();
extern void _ZN5S76C53v90Ev();
extern void _ZN5S76C53v91Ev();
extern void _ZN5S76C53v92Ev();
extern void _ZN5S76C53v93Ev();
extern void _ZN5S76C53v94Ev();
extern void _ZN5S76C53v95Ev();
extern void _ZN5S76C53v96Ev();
extern void _ZN5S76C53v97Ev();
extern void _ZN5S76C53v98Ev();
extern void _ZN5S76C53v99Ev();
extern void _ZN5S76C54v100Ev();
extern void _ZN5S76C54v101Ev();
extern void _ZN5S76C54v102Ev();
extern void _ZN5S76C54v103Ev();
extern void _ZN5S76C54v104Ev();
extern void _ZN5S76C54v105Ev();
extern void _ZN5S76C54v106Ev();
extern void _ZN5S76C54v107Ev();
extern void _ZN5S76C54v108Ev();
extern void _ZN5S76C54v109Ev();
extern void _ZN5S76C44v110Ev();
extern void _ZN5S76C44v111Ev();
extern void _ZN5S76C44v112Ev();
extern void _ZN5S76C44v113Ev();
extern void _ZN5S76C34v114Ev();
extern void _ZN5S76C34v115Ev();
extern void _ZN5S76C34v116Ev();
extern void _ZN5S76C34v117Ev();
extern void _ZN5S76C34v118Ev();
extern void _ZN5S76C34v119Ev();
extern void _ZN5S76C34v120Ev();
extern void _ZN5S76C34v121Ev();
static  VTBL_ENTRY vtc_S76C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S76C3[0]),
  (VTBL_ENTRY)&_ZN5S76C3D1Ev,
  (VTBL_ENTRY)&_ZN5S76C3D0Ev,
  (VTBL_ENTRY)&_ZN5S76C72v4Ev,
  (VTBL_ENTRY)&_ZN5S76C72v5Ev,
  (VTBL_ENTRY)&_ZN5S76C72v6Ev,
  (VTBL_ENTRY)&_ZN5S76C72v7Ev,
  (VTBL_ENTRY)&_ZN5S76C72v8Ev,
  (VTBL_ENTRY)&_ZN5S76C72v9Ev,
  (VTBL_ENTRY)&_ZN5S76C73v10Ev,
  (VTBL_ENTRY)&_ZN5S76C73v11Ev,
  (VTBL_ENTRY)&_ZN5S76C73v12Ev,
  (VTBL_ENTRY)&_ZN5S76C73v13Ev,
  (VTBL_ENTRY)&_ZN5S76C73v14Ev,
  (VTBL_ENTRY)&_ZN5S76C73v15Ev,
  (VTBL_ENTRY)&_ZN5S76C73v16Ev,
  (VTBL_ENTRY)&_ZN5S76C73v17Ev,
  (VTBL_ENTRY)&_ZN5S76C73v18Ev,
  (VTBL_ENTRY)&_ZN5S76C73v19Ev,
  (VTBL_ENTRY)&_ZN5S76C73v20Ev,
  (VTBL_ENTRY)&_ZN5S76C73v21Ev,
  (VTBL_ENTRY)&_ZN5S76C73v22Ev,
  (VTBL_ENTRY)&_ZN5S76C73v23Ev,
  (VTBL_ENTRY)&_ZN5S76C73v24Ev,
  (VTBL_ENTRY)&_ZN5S76C73v25Ev,
  (VTBL_ENTRY)&_ZN5S76C73v26Ev,
  (VTBL_ENTRY)&_ZN5S76C73v27Ev,
  (VTBL_ENTRY)&_ZN5S76C73v28Ev,
  (VTBL_ENTRY)&_ZN5S76C73v29Ev,
  (VTBL_ENTRY)&_ZN5S76C73v30Ev,
  (VTBL_ENTRY)&_ZN5S76C73v31Ev,
  (VTBL_ENTRY)&_ZN5S76C73v32Ev,
  (VTBL_ENTRY)&_ZN5S76C73v33Ev,
  (VTBL_ENTRY)&_ZN5S76C73v34Ev,
  (VTBL_ENTRY)&_ZN5S76C73v35Ev,
  (VTBL_ENTRY)&_ZN5S76C73v36Ev,
  (VTBL_ENTRY)&_ZN5S76C73v37Ev,
  (VTBL_ENTRY)&_ZN5S76C73v38Ev,
  (VTBL_ENTRY)&_ZN5S76C73v39Ev,
  (VTBL_ENTRY)&_ZN5S76C73v40Ev,
  (VTBL_ENTRY)&_ZN5S76C73v41Ev,
  (VTBL_ENTRY)&_ZN5S76C73v42Ev,
  (VTBL_ENTRY)&_ZN5S76C73v43Ev,
  (VTBL_ENTRY)&_ZN5S76C73v44Ev,
  (VTBL_ENTRY)&_ZN5S76C73v45Ev,
  (VTBL_ENTRY)&_ZN5S76C73v46Ev,
  (VTBL_ENTRY)&_ZN5S76C73v47Ev,
  (VTBL_ENTRY)&_ZN5S76C73v48Ev,
  (VTBL_ENTRY)&_ZN5S76C73v49Ev,
  (VTBL_ENTRY)&_ZN5S76C73v50Ev,
  (VTBL_ENTRY)&_ZN5S76C73v51Ev,
  (VTBL_ENTRY)&_ZN5S76C73v52Ev,
  (VTBL_ENTRY)&_ZN5S76C73v53Ev,
  (VTBL_ENTRY)&_ZN5S76C73v54Ev,
  (VTBL_ENTRY)&_ZN5S76C73v55Ev,
  (VTBL_ENTRY)&_ZN5S76C73v56Ev,
  (VTBL_ENTRY)&_ZN5S76C73v57Ev,
  (VTBL_ENTRY)&_ZN5S76C73v58Ev,
  (VTBL_ENTRY)&_ZN5S76C73v59Ev,
  (VTBL_ENTRY)&_ZN5S76C73v60Ev,
  (VTBL_ENTRY)&_ZN5S76C73v61Ev,
  (VTBL_ENTRY)&_ZN5S76C73v62Ev,
  (VTBL_ENTRY)&_ZN5S76C73v63Ev,
  (VTBL_ENTRY)&_ZN5S76C73v64Ev,
  (VTBL_ENTRY)&_ZN5S76C73v65Ev,
  (VTBL_ENTRY)&_ZN5S76C73v66Ev,
  (VTBL_ENTRY)&_ZN5S76C73v67Ev,
  (VTBL_ENTRY)&_ZN5S76C63v68Ev,
  (VTBL_ENTRY)&_ZN5S76C63v69Ev,
  (VTBL_ENTRY)&_ZN5S76C63v70Ev,
  (VTBL_ENTRY)&_ZN5S76C63v71Ev,
  (VTBL_ENTRY)&_ZN5S76C63v72Ev,
  (VTBL_ENTRY)&_ZN5S76C63v73Ev,
  (VTBL_ENTRY)&_ZN5S76C63v74Ev,
  (VTBL_ENTRY)&_ZN5S76C63v75Ev,
  (VTBL_ENTRY)&_ZN5S76C63v76Ev,
  (VTBL_ENTRY)&_ZN5S76C63v77Ev,
  (VTBL_ENTRY)&_ZN5S76C63v78Ev,
  (VTBL_ENTRY)&_ZN5S76C63v79Ev,
  (VTBL_ENTRY)&_ZN5S76C63v80Ev,
  (VTBL_ENTRY)&_ZN5S76C63v81Ev,
  (VTBL_ENTRY)&_ZN5S76C63v82Ev,
  (VTBL_ENTRY)&_ZN5S76C63v83Ev,
  (VTBL_ENTRY)&_ZN5S76C63v84Ev,
  (VTBL_ENTRY)&_ZN5S76C63v85Ev,
  (VTBL_ENTRY)&_ZN5S76C63v86Ev,
  (VTBL_ENTRY)&_ZN5S76C63v87Ev,
  (VTBL_ENTRY)&_ZN5S76C63v88Ev,
  (VTBL_ENTRY)&_ZN5S76C63v89Ev,
  (VTBL_ENTRY)&_ZN5S76C53v90Ev,
  (VTBL_ENTRY)&_ZN5S76C53v91Ev,
  (VTBL_ENTRY)&_ZN5S76C53v92Ev,
  (VTBL_ENTRY)&_ZN5S76C53v93Ev,
  (VTBL_ENTRY)&_ZN5S76C53v94Ev,
  (VTBL_ENTRY)&_ZN5S76C53v95Ev,
  (VTBL_ENTRY)&_ZN5S76C53v96Ev,
  (VTBL_ENTRY)&_ZN5S76C53v97Ev,
  (VTBL_ENTRY)&_ZN5S76C53v98Ev,
  (VTBL_ENTRY)&_ZN5S76C53v99Ev,
  (VTBL_ENTRY)&_ZN5S76C54v100Ev,
  (VTBL_ENTRY)&_ZN5S76C54v101Ev,
  (VTBL_ENTRY)&_ZN5S76C54v102Ev,
  (VTBL_ENTRY)&_ZN5S76C54v103Ev,
  (VTBL_ENTRY)&_ZN5S76C54v104Ev,
  (VTBL_ENTRY)&_ZN5S76C54v105Ev,
  (VTBL_ENTRY)&_ZN5S76C54v106Ev,
  (VTBL_ENTRY)&_ZN5S76C54v107Ev,
  (VTBL_ENTRY)&_ZN5S76C54v108Ev,
  (VTBL_ENTRY)&_ZN5S76C54v109Ev,
  (VTBL_ENTRY)&_ZN5S76C44v110Ev,
  (VTBL_ENTRY)&_ZN5S76C44v111Ev,
  (VTBL_ENTRY)&_ZN5S76C44v112Ev,
  (VTBL_ENTRY)&_ZN5S76C44v113Ev,
  (VTBL_ENTRY)&_ZN5S76C34v114Ev,
  (VTBL_ENTRY)&_ZN5S76C34v115Ev,
  (VTBL_ENTRY)&_ZN5S76C34v116Ev,
  (VTBL_ENTRY)&_ZN5S76C34v117Ev,
  (VTBL_ENTRY)&_ZN5S76C34v118Ev,
  (VTBL_ENTRY)&_ZN5S76C34v119Ev,
  (VTBL_ENTRY)&_ZN5S76C34v120Ev,
  (VTBL_ENTRY)&_ZN5S76C34v121Ev,
};
extern VTBL_ENTRY _ZTI5S76C3[];
extern  VTBL_ENTRY _ZTV5S76C3[];
Class_Descriptor cd_S76C3 = {  "S76C3", // class name
  bases_S76C3, 4,
  &(vtc_S76C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(304,228), // object size
  NSPAIRA(_ZTI5S76C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S76C3),122, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  4, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S76C2  : S76C3 {
  void *s76c2f0;
  virtual  ~S76C2(); // _ZN5S76C2D1Ev
  virtual void  v122(); // _ZN5S76C24v122Ev
  virtual void  v123(); // _ZN5S76C24v123Ev
  virtual void  v124(); // _ZN5S76C24v124Ev
  S76C2(); // tgen
};
//SIG(-1 S76C2) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC7{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 Fi[2] Fp Fi[2] FC8{ BC9{ BC10{ BC11{ m Fp Fi[2]}}}} FC8 FC12{ m} FC8 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 Fi:1 Fi:1 Fi:1 FC13{ BC14{ BC11}} FC15{ BC16{ BC11}} FC17{ BC18{ BC11}} FC19{ BC20{ BC11}} Fi[3]} vd v110 v111 v112 v113 FC7 Fi:1 FC9} vd v114 v115 v116 v117 v118 v119 v120 v121 Fi Fi:1} vd v1 v2 v3 Fp}


 S76C2 ::~S76C2(){ note_dtor("S76C2", this);}
void  S76C2 ::v122(){vfunc_called(this, "_ZN5S76C24v122Ev");}
void  S76C2 ::v123(){vfunc_called(this, "_ZN5S76C24v123Ev");}
void  S76C2 ::v124(){vfunc_called(this, "_ZN5S76C24v124Ev");}
S76C2 ::S76C2(){ note_ctor("S76C2", this);} // tgen

static void Test_S76C2()
{
  extern Class_Descriptor cd_S76C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(40,59)];
    init_test(&cd_S76C2, buf);
    S76C2 *dp, &lv = *(dp=new (buf) S76C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(312,232), "sizeof(S76C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S76C2)");
    check_base_class_offset(lv, (S76C7*)(S76C6*)(S76C5*)(S76C4*)(S76C3*), 0, "S76C2");
    check_base_class_offset(lv, (S76C6*)(S76C5*)(S76C4*)(S76C3*), 0, "S76C2");
    check_base_class_offset(lv, (S76C5*)(S76C4*)(S76C3*), 0, "S76C2");
    check_base_class_offset(lv, (S76C4*)(S76C3*), 0, "S76C2");
    check_base_class_offset(lv, (S76C3*), 0, "S76C2");
    check_field_offset(lv, s76c2f0, ABISELECT(304,228), "S76C2.s76c2f0");
    test_class_info(&lv, &cd_S76C2);
    dp->~S76C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS76C2(Test_S76C2, "S76C2", ABISELECT(312,232));

#else // __cplusplus

extern void _ZN5S76C2C1Ev();
extern void _ZN5S76C2D1Ev();
Name_Map name_map_S76C2[] = {
  NSPAIR(_ZN5S76C2C1Ev),
  NSPAIR(_ZN5S76C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S76C7;
extern VTBL_ENTRY _ZTI5S76C7[];
extern  VTBL_ENTRY _ZTV5S76C7[];
extern Class_Descriptor cd_S76C6;
extern VTBL_ENTRY _ZTI5S76C6[];
extern  VTBL_ENTRY _ZTV5S76C6[];
extern Class_Descriptor cd_S76C5;
extern VTBL_ENTRY _ZTI5S76C5[];
extern  VTBL_ENTRY _ZTV5S76C5[];
extern Class_Descriptor cd_S76C4;
extern VTBL_ENTRY _ZTI5S76C4[];
extern  VTBL_ENTRY _ZTV5S76C4[];
extern Class_Descriptor cd_S76C3;
extern VTBL_ENTRY _ZTI5S76C3[];
extern  VTBL_ENTRY _ZTV5S76C3[];
static Base_Class bases_S76C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S76C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S76C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S76C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S76C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S76C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S76C2[];
extern void _ZN5S76C2D1Ev();
extern void _ZN5S76C2D0Ev();
extern void _ZN5S76C72v4Ev();
extern void _ZN5S76C72v5Ev();
extern void _ZN5S76C72v6Ev();
extern void _ZN5S76C72v7Ev();
extern void _ZN5S76C72v8Ev();
extern void _ZN5S76C72v9Ev();
extern void _ZN5S76C73v10Ev();
extern void _ZN5S76C73v11Ev();
extern void _ZN5S76C73v12Ev();
extern void _ZN5S76C73v13Ev();
extern void _ZN5S76C73v14Ev();
extern void _ZN5S76C73v15Ev();
extern void _ZN5S76C73v16Ev();
extern void _ZN5S76C73v17Ev();
extern void _ZN5S76C73v18Ev();
extern void _ZN5S76C73v19Ev();
extern void _ZN5S76C73v20Ev();
extern void _ZN5S76C73v21Ev();
extern void _ZN5S76C73v22Ev();
extern void _ZN5S76C73v23Ev();
extern void _ZN5S76C73v24Ev();
extern void _ZN5S76C73v25Ev();
extern void _ZN5S76C73v26Ev();
extern void _ZN5S76C73v27Ev();
extern void _ZN5S76C73v28Ev();
extern void _ZN5S76C73v29Ev();
extern void _ZN5S76C73v30Ev();
extern void _ZN5S76C73v31Ev();
extern void _ZN5S76C73v32Ev();
extern void _ZN5S76C73v33Ev();
extern void _ZN5S76C73v34Ev();
extern void _ZN5S76C73v35Ev();
extern void _ZN5S76C73v36Ev();
extern void _ZN5S76C73v37Ev();
extern void _ZN5S76C73v38Ev();
extern void _ZN5S76C73v39Ev();
extern void _ZN5S76C73v40Ev();
extern void _ZN5S76C73v41Ev();
extern void _ZN5S76C73v42Ev();
extern void _ZN5S76C73v43Ev();
extern void _ZN5S76C73v44Ev();
extern void _ZN5S76C73v45Ev();
extern void _ZN5S76C73v46Ev();
extern void _ZN5S76C73v47Ev();
extern void _ZN5S76C73v48Ev();
extern void _ZN5S76C73v49Ev();
extern void _ZN5S76C73v50Ev();
extern void _ZN5S76C73v51Ev();
extern void _ZN5S76C73v52Ev();
extern void _ZN5S76C73v53Ev();
extern void _ZN5S76C73v54Ev();
extern void _ZN5S76C73v55Ev();
extern void _ZN5S76C73v56Ev();
extern void _ZN5S76C73v57Ev();
extern void _ZN5S76C73v58Ev();
extern void _ZN5S76C73v59Ev();
extern void _ZN5S76C73v60Ev();
extern void _ZN5S76C73v61Ev();
extern void _ZN5S76C73v62Ev();
extern void _ZN5S76C73v63Ev();
extern void _ZN5S76C73v64Ev();
extern void _ZN5S76C73v65Ev();
extern void _ZN5S76C73v66Ev();
extern void _ZN5S76C73v67Ev();
extern void _ZN5S76C63v68Ev();
extern void _ZN5S76C63v69Ev();
extern void _ZN5S76C63v70Ev();
extern void _ZN5S76C63v71Ev();
extern void _ZN5S76C63v72Ev();
extern void _ZN5S76C63v73Ev();
extern void _ZN5S76C63v74Ev();
extern void _ZN5S76C63v75Ev();
extern void _ZN5S76C63v76Ev();
extern void _ZN5S76C63v77Ev();
extern void _ZN5S76C63v78Ev();
extern void _ZN5S76C63v79Ev();
extern void _ZN5S76C63v80Ev();
extern void _ZN5S76C63v81Ev();
extern void _ZN5S76C63v82Ev();
extern void _ZN5S76C63v83Ev();
extern void _ZN5S76C63v84Ev();
extern void _ZN5S76C63v85Ev();
extern void _ZN5S76C63v86Ev();
extern void _ZN5S76C63v87Ev();
extern void _ZN5S76C63v88Ev();
extern void _ZN5S76C63v89Ev();
extern void _ZN5S76C53v90Ev();
extern void _ZN5S76C53v91Ev();
extern void _ZN5S76C53v92Ev();
extern void _ZN5S76C53v93Ev();
extern void _ZN5S76C53v94Ev();
extern void _ZN5S76C53v95Ev();
extern void _ZN5S76C53v96Ev();
extern void _ZN5S76C53v97Ev();
extern void _ZN5S76C53v98Ev();
extern void _ZN5S76C53v99Ev();
extern void _ZN5S76C54v100Ev();
extern void _ZN5S76C54v101Ev();
extern void _ZN5S76C54v102Ev();
extern void _ZN5S76C54v103Ev();
extern void _ZN5S76C54v104Ev();
extern void _ZN5S76C54v105Ev();
extern void _ZN5S76C54v106Ev();
extern void _ZN5S76C54v107Ev();
extern void _ZN5S76C54v108Ev();
extern void _ZN5S76C54v109Ev();
extern void _ZN5S76C44v110Ev();
extern void _ZN5S76C44v111Ev();
extern void _ZN5S76C44v112Ev();
extern void _ZN5S76C44v113Ev();
extern void _ZN5S76C34v114Ev();
extern void _ZN5S76C34v115Ev();
extern void _ZN5S76C34v116Ev();
extern void _ZN5S76C34v117Ev();
extern void _ZN5S76C34v118Ev();
extern void _ZN5S76C34v119Ev();
extern void _ZN5S76C34v120Ev();
extern void _ZN5S76C34v121Ev();
extern void _ZN5S76C24v122Ev();
extern void _ZN5S76C24v123Ev();
extern void _ZN5S76C24v124Ev();
static  VTBL_ENTRY vtc_S76C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S76C2[0]),
  (VTBL_ENTRY)&_ZN5S76C2D1Ev,
  (VTBL_ENTRY)&_ZN5S76C2D0Ev,
  (VTBL_ENTRY)&_ZN5S76C72v4Ev,
  (VTBL_ENTRY)&_ZN5S76C72v5Ev,
  (VTBL_ENTRY)&_ZN5S76C72v6Ev,
  (VTBL_ENTRY)&_ZN5S76C72v7Ev,
  (VTBL_ENTRY)&_ZN5S76C72v8Ev,
  (VTBL_ENTRY)&_ZN5S76C72v9Ev,
  (VTBL_ENTRY)&_ZN5S76C73v10Ev,
  (VTBL_ENTRY)&_ZN5S76C73v11Ev,
  (VTBL_ENTRY)&_ZN5S76C73v12Ev,
  (VTBL_ENTRY)&_ZN5S76C73v13Ev,
  (VTBL_ENTRY)&_ZN5S76C73v14Ev,
  (VTBL_ENTRY)&_ZN5S76C73v15Ev,
  (VTBL_ENTRY)&_ZN5S76C73v16Ev,
  (VTBL_ENTRY)&_ZN5S76C73v17Ev,
  (VTBL_ENTRY)&_ZN5S76C73v18Ev,
  (VTBL_ENTRY)&_ZN5S76C73v19Ev,
  (VTBL_ENTRY)&_ZN5S76C73v20Ev,
  (VTBL_ENTRY)&_ZN5S76C73v21Ev,
  (VTBL_ENTRY)&_ZN5S76C73v22Ev,
  (VTBL_ENTRY)&_ZN5S76C73v23Ev,
  (VTBL_ENTRY)&_ZN5S76C73v24Ev,
  (VTBL_ENTRY)&_ZN5S76C73v25Ev,
  (VTBL_ENTRY)&_ZN5S76C73v26Ev,
  (VTBL_ENTRY)&_ZN5S76C73v27Ev,
  (VTBL_ENTRY)&_ZN5S76C73v28Ev,
  (VTBL_ENTRY)&_ZN5S76C73v29Ev,
  (VTBL_ENTRY)&_ZN5S76C73v30Ev,
  (VTBL_ENTRY)&_ZN5S76C73v31Ev,
  (VTBL_ENTRY)&_ZN5S76C73v32Ev,
  (VTBL_ENTRY)&_ZN5S76C73v33Ev,
  (VTBL_ENTRY)&_ZN5S76C73v34Ev,
  (VTBL_ENTRY)&_ZN5S76C73v35Ev,
  (VTBL_ENTRY)&_ZN5S76C73v36Ev,
  (VTBL_ENTRY)&_ZN5S76C73v37Ev,
  (VTBL_ENTRY)&_ZN5S76C73v38Ev,
  (VTBL_ENTRY)&_ZN5S76C73v39Ev,
  (VTBL_ENTRY)&_ZN5S76C73v40Ev,
  (VTBL_ENTRY)&_ZN5S76C73v41Ev,
  (VTBL_ENTRY)&_ZN5S76C73v42Ev,
  (VTBL_ENTRY)&_ZN5S76C73v43Ev,
  (VTBL_ENTRY)&_ZN5S76C73v44Ev,
  (VTBL_ENTRY)&_ZN5S76C73v45Ev,
  (VTBL_ENTRY)&_ZN5S76C73v46Ev,
  (VTBL_ENTRY)&_ZN5S76C73v47Ev,
  (VTBL_ENTRY)&_ZN5S76C73v48Ev,
  (VTBL_ENTRY)&_ZN5S76C73v49Ev,
  (VTBL_ENTRY)&_ZN5S76C73v50Ev,
  (VTBL_ENTRY)&_ZN5S76C73v51Ev,
  (VTBL_ENTRY)&_ZN5S76C73v52Ev,
  (VTBL_ENTRY)&_ZN5S76C73v53Ev,
  (VTBL_ENTRY)&_ZN5S76C73v54Ev,
  (VTBL_ENTRY)&_ZN5S76C73v55Ev,
  (VTBL_ENTRY)&_ZN5S76C73v56Ev,
  (VTBL_ENTRY)&_ZN5S76C73v57Ev,
  (VTBL_ENTRY)&_ZN5S76C73v58Ev,
  (VTBL_ENTRY)&_ZN5S76C73v59Ev,
  (VTBL_ENTRY)&_ZN5S76C73v60Ev,
  (VTBL_ENTRY)&_ZN5S76C73v61Ev,
  (VTBL_ENTRY)&_ZN5S76C73v62Ev,
  (VTBL_ENTRY)&_ZN5S76C73v63Ev,
  (VTBL_ENTRY)&_ZN5S76C73v64Ev,
  (VTBL_ENTRY)&_ZN5S76C73v65Ev,
  (VTBL_ENTRY)&_ZN5S76C73v66Ev,
  (VTBL_ENTRY)&_ZN5S76C73v67Ev,
  (VTBL_ENTRY)&_ZN5S76C63v68Ev,
  (VTBL_ENTRY)&_ZN5S76C63v69Ev,
  (VTBL_ENTRY)&_ZN5S76C63v70Ev,
  (VTBL_ENTRY)&_ZN5S76C63v71Ev,
  (VTBL_ENTRY)&_ZN5S76C63v72Ev,
  (VTBL_ENTRY)&_ZN5S76C63v73Ev,
  (VTBL_ENTRY)&_ZN5S76C63v74Ev,
  (VTBL_ENTRY)&_ZN5S76C63v75Ev,
  (VTBL_ENTRY)&_ZN5S76C63v76Ev,
  (VTBL_ENTRY)&_ZN5S76C63v77Ev,
  (VTBL_ENTRY)&_ZN5S76C63v78Ev,
  (VTBL_ENTRY)&_ZN5S76C63v79Ev,
  (VTBL_ENTRY)&_ZN5S76C63v80Ev,
  (VTBL_ENTRY)&_ZN5S76C63v81Ev,
  (VTBL_ENTRY)&_ZN5S76C63v82Ev,
  (VTBL_ENTRY)&_ZN5S76C63v83Ev,
  (VTBL_ENTRY)&_ZN5S76C63v84Ev,
  (VTBL_ENTRY)&_ZN5S76C63v85Ev,
  (VTBL_ENTRY)&_ZN5S76C63v86Ev,
  (VTBL_ENTRY)&_ZN5S76C63v87Ev,
  (VTBL_ENTRY)&_ZN5S76C63v88Ev,
  (VTBL_ENTRY)&_ZN5S76C63v89Ev,
  (VTBL_ENTRY)&_ZN5S76C53v90Ev,
  (VTBL_ENTRY)&_ZN5S76C53v91Ev,
  (VTBL_ENTRY)&_ZN5S76C53v92Ev,
  (VTBL_ENTRY)&_ZN5S76C53v93Ev,
  (VTBL_ENTRY)&_ZN5S76C53v94Ev,
  (VTBL_ENTRY)&_ZN5S76C53v95Ev,
  (VTBL_ENTRY)&_ZN5S76C53v96Ev,
  (VTBL_ENTRY)&_ZN5S76C53v97Ev,
  (VTBL_ENTRY)&_ZN5S76C53v98Ev,
  (VTBL_ENTRY)&_ZN5S76C53v99Ev,
  (VTBL_ENTRY)&_ZN5S76C54v100Ev,
  (VTBL_ENTRY)&_ZN5S76C54v101Ev,
  (VTBL_ENTRY)&_ZN5S76C54v102Ev,
  (VTBL_ENTRY)&_ZN5S76C54v103Ev,
  (VTBL_ENTRY)&_ZN5S76C54v104Ev,
  (VTBL_ENTRY)&_ZN5S76C54v105Ev,
  (VTBL_ENTRY)&_ZN5S76C54v106Ev,
  (VTBL_ENTRY)&_ZN5S76C54v107Ev,
  (VTBL_ENTRY)&_ZN5S76C54v108Ev,
  (VTBL_ENTRY)&_ZN5S76C54v109Ev,
  (VTBL_ENTRY)&_ZN5S76C44v110Ev,
  (VTBL_ENTRY)&_ZN5S76C44v111Ev,
  (VTBL_ENTRY)&_ZN5S76C44v112Ev,
  (VTBL_ENTRY)&_ZN5S76C44v113Ev,
  (VTBL_ENTRY)&_ZN5S76C34v114Ev,
  (VTBL_ENTRY)&_ZN5S76C34v115Ev,
  (VTBL_ENTRY)&_ZN5S76C34v116Ev,
  (VTBL_ENTRY)&_ZN5S76C34v117Ev,
  (VTBL_ENTRY)&_ZN5S76C34v118Ev,
  (VTBL_ENTRY)&_ZN5S76C34v119Ev,
  (VTBL_ENTRY)&_ZN5S76C34v120Ev,
  (VTBL_ENTRY)&_ZN5S76C34v121Ev,
  (VTBL_ENTRY)&_ZN5S76C24v122Ev,
  (VTBL_ENTRY)&_ZN5S76C24v123Ev,
  (VTBL_ENTRY)&_ZN5S76C24v124Ev,
};
extern VTBL_ENTRY _ZTI5S76C2[];
extern  VTBL_ENTRY _ZTV5S76C2[];
Class_Descriptor cd_S76C2 = {  "S76C2", // class name
  bases_S76C2, 5,
  &(vtc_S76C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(312,232), // object size
  NSPAIRA(_ZTI5S76C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S76C2),125, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  5, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S76C1  : S76C2 {
  virtual  ~S76C1(); // _ZN5S76C1D1Ev
  virtual void  v1(); // _ZN5S76C12v1Ev
  virtual void  v2(); // _ZN5S76C12v2Ev
  virtual void  v3(); // _ZN5S76C12v3Ev
  S76C1(); // tgen
};
//SIG(1 S76C1) C1{ BC2{ BC3{ BC4{ BC5{ BC6{ BC7{ vd v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 Fi FL Fp[4] Fi[2] Fp FC8{ m Fi[2]} Fp[2]} vd v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 Fi[2] Fp Fi[2] FC9{ BC10{ BC11{ BC12{ m Fp Fi[2]}}}} FC9 FC13{ m} FC9 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[2]} vd v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 Fi:1 Fi:1 Fi:1 FC14{ BC15{ BC12}} FC16{ BC17{ BC12}} FC18{ BC19{ BC12}} FC20{ BC21{ BC12}} Fi[3]} vd v110 v111 v112 v113 FC8 Fi:1 FC10} vd v114 v115 v116 v117 v118 v119 v120 v121 Fi Fi:1} vd v122 v123 v124 Fp} vd v1 v2 v3}


 S76C1 ::~S76C1(){ note_dtor("S76C1", this);}
void  S76C1 ::v1(){vfunc_called(this, "_ZN5S76C12v1Ev");}
void  S76C1 ::v2(){vfunc_called(this, "_ZN5S76C12v2Ev");}
void  S76C1 ::v3(){vfunc_called(this, "_ZN5S76C12v3Ev");}
S76C1 ::S76C1(){ note_ctor("S76C1", this);} // tgen

static void Test_S76C1()
{
  extern Class_Descriptor cd_S76C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(40,59)];
    init_test(&cd_S76C1, buf);
    S76C1 *dp, &lv = *(dp=new (buf) S76C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(312,232), "sizeof(S76C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S76C1)");
    check_base_class_offset(lv, (S76C7*)(S76C6*)(S76C5*)(S76C4*)(S76C3*)(S76C2*), 0, "S76C1");
    check_base_class_offset(lv, (S76C6*)(S76C5*)(S76C4*)(S76C3*)(S76C2*), 0, "S76C1");
    check_base_class_offset(lv, (S76C5*)(S76C4*)(S76C3*)(S76C2*), 0, "S76C1");
    check_base_class_offset(lv, (S76C4*)(S76C3*)(S76C2*), 0, "S76C1");
    check_base_class_offset(lv, (S76C3*)(S76C2*), 0, "S76C1");
    check_base_class_offset(lv, (S76C2*), 0, "S76C1");
    test_class_info(&lv, &cd_S76C1);
    dp->~S76C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS76C1(Test_S76C1, "S76C1", ABISELECT(312,232));

#else // __cplusplus

extern void _ZN5S76C1C1Ev();
extern void _ZN5S76C1D1Ev();
Name_Map name_map_S76C1[] = {
  NSPAIR(_ZN5S76C1C1Ev),
  NSPAIR(_ZN5S76C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S76C7;
extern VTBL_ENTRY _ZTI5S76C7[];
extern  VTBL_ENTRY _ZTV5S76C7[];
extern Class_Descriptor cd_S76C6;
extern VTBL_ENTRY _ZTI5S76C6[];
extern  VTBL_ENTRY _ZTV5S76C6[];
extern Class_Descriptor cd_S76C5;
extern VTBL_ENTRY _ZTI5S76C5[];
extern  VTBL_ENTRY _ZTV5S76C5[];
extern Class_Descriptor cd_S76C4;
extern VTBL_ENTRY _ZTI5S76C4[];
extern  VTBL_ENTRY _ZTV5S76C4[];
extern Class_Descriptor cd_S76C3;
extern VTBL_ENTRY _ZTI5S76C3[];
extern  VTBL_ENTRY _ZTV5S76C3[];
extern Class_Descriptor cd_S76C2;
extern VTBL_ENTRY _ZTI5S76C2[];
extern  VTBL_ENTRY _ZTV5S76C2[];
static Base_Class bases_S76C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S76C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S76C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S76C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S76C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S76C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S76C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI5S76C1[];
extern void _ZN5S76C1D1Ev();
extern void _ZN5S76C1D0Ev();
extern void _ZN5S76C72v4Ev();
extern void _ZN5S76C72v5Ev();
extern void _ZN5S76C72v6Ev();
extern void _ZN5S76C72v7Ev();
extern void _ZN5S76C72v8Ev();
extern void _ZN5S76C72v9Ev();
extern void _ZN5S76C73v10Ev();
extern void _ZN5S76C73v11Ev();
extern void _ZN5S76C73v12Ev();
extern void _ZN5S76C73v13Ev();
extern void _ZN5S76C73v14Ev();
extern void _ZN5S76C73v15Ev();
extern void _ZN5S76C73v16Ev();
extern void _ZN5S76C73v17Ev();
extern void _ZN5S76C73v18Ev();
extern void _ZN5S76C73v19Ev();
extern void _ZN5S76C73v20Ev();
extern void _ZN5S76C73v21Ev();
extern void _ZN5S76C73v22Ev();
extern void _ZN5S76C73v23Ev();
extern void _ZN5S76C73v24Ev();
extern void _ZN5S76C73v25Ev();
extern void _ZN5S76C73v26Ev();
extern void _ZN5S76C73v27Ev();
extern void _ZN5S76C73v28Ev();
extern void _ZN5S76C73v29Ev();
extern void _ZN5S76C73v30Ev();
extern void _ZN5S76C73v31Ev();
extern void _ZN5S76C73v32Ev();
extern void _ZN5S76C73v33Ev();
extern void _ZN5S76C73v34Ev();
extern void _ZN5S76C73v35Ev();
extern void _ZN5S76C73v36Ev();
extern void _ZN5S76C73v37Ev();
extern void _ZN5S76C73v38Ev();
extern void _ZN5S76C73v39Ev();
extern void _ZN5S76C73v40Ev();
extern void _ZN5S76C73v41Ev();
extern void _ZN5S76C73v42Ev();
extern void _ZN5S76C73v43Ev();
extern void _ZN5S76C73v44Ev();
extern void _ZN5S76C73v45Ev();
extern void _ZN5S76C73v46Ev();
extern void _ZN5S76C73v47Ev();
extern void _ZN5S76C73v48Ev();
extern void _ZN5S76C73v49Ev();
extern void _ZN5S76C73v50Ev();
extern void _ZN5S76C73v51Ev();
extern void _ZN5S76C73v52Ev();
extern void _ZN5S76C73v53Ev();
extern void _ZN5S76C73v54Ev();
extern void _ZN5S76C73v55Ev();
extern void _ZN5S76C73v56Ev();
extern void _ZN5S76C73v57Ev();
extern void _ZN5S76C73v58Ev();
extern void _ZN5S76C73v59Ev();
extern void _ZN5S76C73v60Ev();
extern void _ZN5S76C73v61Ev();
extern void _ZN5S76C73v62Ev();
extern void _ZN5S76C73v63Ev();
extern void _ZN5S76C73v64Ev();
extern void _ZN5S76C73v65Ev();
extern void _ZN5S76C73v66Ev();
extern void _ZN5S76C73v67Ev();
extern void _ZN5S76C63v68Ev();
extern void _ZN5S76C63v69Ev();
extern void _ZN5S76C63v70Ev();
extern void _ZN5S76C63v71Ev();
extern void _ZN5S76C63v72Ev();
extern void _ZN5S76C63v73Ev();
extern void _ZN5S76C63v74Ev();
extern void _ZN5S76C63v75Ev();
extern void _ZN5S76C63v76Ev();
extern void _ZN5S76C63v77Ev();
extern void _ZN5S76C63v78Ev();
extern void _ZN5S76C63v79Ev();
extern void _ZN5S76C63v80Ev();
extern void _ZN5S76C63v81Ev();
extern void _ZN5S76C63v82Ev();
extern void _ZN5S76C63v83Ev();
extern void _ZN5S76C63v84Ev();
extern void _ZN5S76C63v85Ev();
extern void _ZN5S76C63v86Ev();
extern void _ZN5S76C63v87Ev();
extern void _ZN5S76C63v88Ev();
extern void _ZN5S76C63v89Ev();
extern void _ZN5S76C53v90Ev();
extern void _ZN5S76C53v91Ev();
extern void _ZN5S76C53v92Ev();
extern void _ZN5S76C53v93Ev();
extern void _ZN5S76C53v94Ev();
extern void _ZN5S76C53v95Ev();
extern void _ZN5S76C53v96Ev();
extern void _ZN5S76C53v97Ev();
extern void _ZN5S76C53v98Ev();
extern void _ZN5S76C53v99Ev();
extern void _ZN5S76C54v100Ev();
extern void _ZN5S76C54v101Ev();
extern void _ZN5S76C54v102Ev();
extern void _ZN5S76C54v103Ev();
extern void _ZN5S76C54v104Ev();
extern void _ZN5S76C54v105Ev();
extern void _ZN5S76C54v106Ev();
extern void _ZN5S76C54v107Ev();
extern void _ZN5S76C54v108Ev();
extern void _ZN5S76C54v109Ev();
extern void _ZN5S76C44v110Ev();
extern void _ZN5S76C44v111Ev();
extern void _ZN5S76C44v112Ev();
extern void _ZN5S76C44v113Ev();
extern void _ZN5S76C34v114Ev();
extern void _ZN5S76C34v115Ev();
extern void _ZN5S76C34v116Ev();
extern void _ZN5S76C34v117Ev();
extern void _ZN5S76C34v118Ev();
extern void _ZN5S76C34v119Ev();
extern void _ZN5S76C34v120Ev();
extern void _ZN5S76C34v121Ev();
extern void _ZN5S76C24v122Ev();
extern void _ZN5S76C24v123Ev();
extern void _ZN5S76C24v124Ev();
extern void _ZN5S76C12v1Ev();
extern void _ZN5S76C12v2Ev();
extern void _ZN5S76C12v3Ev();
static  VTBL_ENTRY vtc_S76C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI5S76C1[0]),
  (VTBL_ENTRY)&_ZN5S76C1D1Ev,
  (VTBL_ENTRY)&_ZN5S76C1D0Ev,
  (VTBL_ENTRY)&_ZN5S76C72v4Ev,
  (VTBL_ENTRY)&_ZN5S76C72v5Ev,
  (VTBL_ENTRY)&_ZN5S76C72v6Ev,
  (VTBL_ENTRY)&_ZN5S76C72v7Ev,
  (VTBL_ENTRY)&_ZN5S76C72v8Ev,
  (VTBL_ENTRY)&_ZN5S76C72v9Ev,
  (VTBL_ENTRY)&_ZN5S76C73v10Ev,
  (VTBL_ENTRY)&_ZN5S76C73v11Ev,
  (VTBL_ENTRY)&_ZN5S76C73v12Ev,
  (VTBL_ENTRY)&_ZN5S76C73v13Ev,
  (VTBL_ENTRY)&_ZN5S76C73v14Ev,
  (VTBL_ENTRY)&_ZN5S76C73v15Ev,
  (VTBL_ENTRY)&_ZN5S76C73v16Ev,
  (VTBL_ENTRY)&_ZN5S76C73v17Ev,
  (VTBL_ENTRY)&_ZN5S76C73v18Ev,
  (VTBL_ENTRY)&_ZN5S76C73v19Ev,
  (VTBL_ENTRY)&_ZN5S76C73v20Ev,
  (VTBL_ENTRY)&_ZN5S76C73v21Ev,
  (VTBL_ENTRY)&_ZN5S76C73v22Ev,
  (VTBL_ENTRY)&_ZN5S76C73v23Ev,
  (VTBL_ENTRY)&_ZN5S76C73v24Ev,
  (VTBL_ENTRY)&_ZN5S76C73v25Ev,
  (VTBL_ENTRY)&_ZN5S76C73v26Ev,
  (VTBL_ENTRY)&_ZN5S76C73v27Ev,
  (VTBL_ENTRY)&_ZN5S76C73v28Ev,
  (VTBL_ENTRY)&_ZN5S76C73v29Ev,
  (VTBL_ENTRY)&_ZN5S76C73v30Ev,
  (VTBL_ENTRY)&_ZN5S76C73v31Ev,
  (VTBL_ENTRY)&_ZN5S76C73v32Ev,
  (VTBL_ENTRY)&_ZN5S76C73v33Ev,
  (VTBL_ENTRY)&_ZN5S76C73v34Ev,
  (VTBL_ENTRY)&_ZN5S76C73v35Ev,
  (VTBL_ENTRY)&_ZN5S76C73v36Ev,
  (VTBL_ENTRY)&_ZN5S76C73v37Ev,
  (VTBL_ENTRY)&_ZN5S76C73v38Ev,
  (VTBL_ENTRY)&_ZN5S76C73v39Ev,
  (VTBL_ENTRY)&_ZN5S76C73v40Ev,
  (VTBL_ENTRY)&_ZN5S76C73v41Ev,
  (VTBL_ENTRY)&_ZN5S76C73v42Ev,
  (VTBL_ENTRY)&_ZN5S76C73v43Ev,
  (VTBL_ENTRY)&_ZN5S76C73v44Ev,
  (VTBL_ENTRY)&_ZN5S76C73v45Ev,
  (VTBL_ENTRY)&_ZN5S76C73v46Ev,
  (VTBL_ENTRY)&_ZN5S76C73v47Ev,
  (VTBL_ENTRY)&_ZN5S76C73v48Ev,
  (VTBL_ENTRY)&_ZN5S76C73v49Ev,
  (VTBL_ENTRY)&_ZN5S76C73v50Ev,
  (VTBL_ENTRY)&_ZN5S76C73v51Ev,
  (VTBL_ENTRY)&_ZN5S76C73v52Ev,
  (VTBL_ENTRY)&_ZN5S76C73v53Ev,
  (VTBL_ENTRY)&_ZN5S76C73v54Ev,
  (VTBL_ENTRY)&_ZN5S76C73v55Ev,
  (VTBL_ENTRY)&_ZN5S76C73v56Ev,
  (VTBL_ENTRY)&_ZN5S76C73v57Ev,
  (VTBL_ENTRY)&_ZN5S76C73v58Ev,
  (VTBL_ENTRY)&_ZN5S76C73v59Ev,
  (VTBL_ENTRY)&_ZN5S76C73v60Ev,
  (VTBL_ENTRY)&_ZN5S76C73v61Ev,
  (VTBL_ENTRY)&_ZN5S76C73v62Ev,
  (VTBL_ENTRY)&_ZN5S76C73v63Ev,
  (VTBL_ENTRY)&_ZN5S76C73v64Ev,
  (VTBL_ENTRY)&_ZN5S76C73v65Ev,
  (VTBL_ENTRY)&_ZN5S76C73v66Ev,
  (VTBL_ENTRY)&_ZN5S76C73v67Ev,
  (VTBL_ENTRY)&_ZN5S76C63v68Ev,
  (VTBL_ENTRY)&_ZN5S76C63v69Ev,
  (VTBL_ENTRY)&_ZN5S76C63v70Ev,
  (VTBL_ENTRY)&_ZN5S76C63v71Ev,
  (VTBL_ENTRY)&_ZN5S76C63v72Ev,
  (VTBL_ENTRY)&_ZN5S76C63v73Ev,
  (VTBL_ENTRY)&_ZN5S76C63v74Ev,
  (VTBL_ENTRY)&_ZN5S76C63v75Ev,
  (VTBL_ENTRY)&_ZN5S76C63v76Ev,
  (VTBL_ENTRY)&_ZN5S76C63v77Ev,
  (VTBL_ENTRY)&_ZN5S76C63v78Ev,
  (VTBL_ENTRY)&_ZN5S76C63v79Ev,
  (VTBL_ENTRY)&_ZN5S76C63v80Ev,
  (VTBL_ENTRY)&_ZN5S76C63v81Ev,
  (VTBL_ENTRY)&_ZN5S76C63v82Ev,
  (VTBL_ENTRY)&_ZN5S76C63v83Ev,
  (VTBL_ENTRY)&_ZN5S76C63v84Ev,
  (VTBL_ENTRY)&_ZN5S76C63v85Ev,
  (VTBL_ENTRY)&_ZN5S76C63v86Ev,
  (VTBL_ENTRY)&_ZN5S76C63v87Ev,
  (VTBL_ENTRY)&_ZN5S76C63v88Ev,
  (VTBL_ENTRY)&_ZN5S76C63v89Ev,
  (VTBL_ENTRY)&_ZN5S76C53v90Ev,
  (VTBL_ENTRY)&_ZN5S76C53v91Ev,
  (VTBL_ENTRY)&_ZN5S76C53v92Ev,
  (VTBL_ENTRY)&_ZN5S76C53v93Ev,
  (VTBL_ENTRY)&_ZN5S76C53v94Ev,
  (VTBL_ENTRY)&_ZN5S76C53v95Ev,
  (VTBL_ENTRY)&_ZN5S76C53v96Ev,
  (VTBL_ENTRY)&_ZN5S76C53v97Ev,
  (VTBL_ENTRY)&_ZN5S76C53v98Ev,
  (VTBL_ENTRY)&_ZN5S76C53v99Ev,
  (VTBL_ENTRY)&_ZN5S76C54v100Ev,
  (VTBL_ENTRY)&_ZN5S76C54v101Ev,
  (VTBL_ENTRY)&_ZN5S76C54v102Ev,
  (VTBL_ENTRY)&_ZN5S76C54v103Ev,
  (VTBL_ENTRY)&_ZN5S76C54v104Ev,
  (VTBL_ENTRY)&_ZN5S76C54v105Ev,
  (VTBL_ENTRY)&_ZN5S76C54v106Ev,
  (VTBL_ENTRY)&_ZN5S76C54v107Ev,
  (VTBL_ENTRY)&_ZN5S76C54v108Ev,
  (VTBL_ENTRY)&_ZN5S76C54v109Ev,
  (VTBL_ENTRY)&_ZN5S76C44v110Ev,
  (VTBL_ENTRY)&_ZN5S76C44v111Ev,
  (VTBL_ENTRY)&_ZN5S76C44v112Ev,
  (VTBL_ENTRY)&_ZN5S76C44v113Ev,
  (VTBL_ENTRY)&_ZN5S76C34v114Ev,
  (VTBL_ENTRY)&_ZN5S76C34v115Ev,
  (VTBL_ENTRY)&_ZN5S76C34v116Ev,
  (VTBL_ENTRY)&_ZN5S76C34v117Ev,
  (VTBL_ENTRY)&_ZN5S76C34v118Ev,
  (VTBL_ENTRY)&_ZN5S76C34v119Ev,
  (VTBL_ENTRY)&_ZN5S76C34v120Ev,
  (VTBL_ENTRY)&_ZN5S76C34v121Ev,
  (VTBL_ENTRY)&_ZN5S76C24v122Ev,
  (VTBL_ENTRY)&_ZN5S76C24v123Ev,
  (VTBL_ENTRY)&_ZN5S76C24v124Ev,
  (VTBL_ENTRY)&_ZN5S76C12v1Ev,
  (VTBL_ENTRY)&_ZN5S76C12v2Ev,
  (VTBL_ENTRY)&_ZN5S76C12v3Ev,
};
extern VTBL_ENTRY _ZTI5S76C1[];
extern  VTBL_ENTRY _ZTV5S76C1[];
Class_Descriptor cd_S76C1 = {  "S76C1", // class name
  bases_S76C1, 6,
  &(vtc_S76C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(312,232), // object size
  NSPAIRA(_ZTI5S76C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV5S76C1),128, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  6, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6644C2  {
  virtual  ~S6644C2(); // _ZN7S6644C2D1Ev
  virtual void  v28(); // _ZN7S6644C23v28Ev
  virtual void  v29(); // _ZN7S6644C23v29Ev
  virtual void  v30(); // _ZN7S6644C23v30Ev
  virtual void  v31(); // _ZN7S6644C23v31Ev
  virtual void  v32(); // _ZN7S6644C23v32Ev
  virtual void  v33(); // _ZN7S6644C23v33Ev
  virtual void  v34(); // _ZN7S6644C23v34Ev
  virtual void  v35(); // _ZN7S6644C23v35Ev
  virtual void  v36(); // _ZN7S6644C23v36Ev
  virtual void  v37(); // _ZN7S6644C23v37Ev
  virtual void  v38(); // _ZN7S6644C23v38Ev
  virtual void  v39(); // _ZN7S6644C23v39Ev
  virtual void  v40(); // _ZN7S6644C23v40Ev
  virtual void  v41(); // _ZN7S6644C23v41Ev
  virtual void  v42(); // _ZN7S6644C23v42Ev
  virtual void  v43(); // _ZN7S6644C23v43Ev
  virtual void  v44(); // _ZN7S6644C23v44Ev
  virtual void  v45(); // _ZN7S6644C23v45Ev
  virtual void  v46(); // _ZN7S6644C23v46Ev
  virtual void  v47(); // _ZN7S6644C23v47Ev
  virtual void  v48(); // _ZN7S6644C23v48Ev
  virtual void  v49(); // _ZN7S6644C23v49Ev
  virtual void  v50(); // _ZN7S6644C23v50Ev
  virtual void  v51(); // _ZN7S6644C23v51Ev
  virtual void  v52(); // _ZN7S6644C23v52Ev
  virtual void  v53(); // _ZN7S6644C23v53Ev
  virtual void  v54(); // _ZN7S6644C23v54Ev
  S6644C2(); // tgen
};
//SIG(-1 S6644C2) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27}


 S6644C2 ::~S6644C2(){ note_dtor("S6644C2", this);}
void  S6644C2 ::v28(){vfunc_called(this, "_ZN7S6644C23v28Ev");}
void  S6644C2 ::v29(){vfunc_called(this, "_ZN7S6644C23v29Ev");}
void  S6644C2 ::v30(){vfunc_called(this, "_ZN7S6644C23v30Ev");}
void  S6644C2 ::v31(){vfunc_called(this, "_ZN7S6644C23v31Ev");}
void  S6644C2 ::v32(){vfunc_called(this, "_ZN7S6644C23v32Ev");}
void  S6644C2 ::v33(){vfunc_called(this, "_ZN7S6644C23v33Ev");}
void  S6644C2 ::v34(){vfunc_called(this, "_ZN7S6644C23v34Ev");}
void  S6644C2 ::v35(){vfunc_called(this, "_ZN7S6644C23v35Ev");}
void  S6644C2 ::v36(){vfunc_called(this, "_ZN7S6644C23v36Ev");}
void  S6644C2 ::v37(){vfunc_called(this, "_ZN7S6644C23v37Ev");}
void  S6644C2 ::v38(){vfunc_called(this, "_ZN7S6644C23v38Ev");}
void  S6644C2 ::v39(){vfunc_called(this, "_ZN7S6644C23v39Ev");}
void  S6644C2 ::v40(){vfunc_called(this, "_ZN7S6644C23v40Ev");}
void  S6644C2 ::v41(){vfunc_called(this, "_ZN7S6644C23v41Ev");}
void  S6644C2 ::v42(){vfunc_called(this, "_ZN7S6644C23v42Ev");}
void  S6644C2 ::v43(){vfunc_called(this, "_ZN7S6644C23v43Ev");}
void  S6644C2 ::v44(){vfunc_called(this, "_ZN7S6644C23v44Ev");}
void  S6644C2 ::v45(){vfunc_called(this, "_ZN7S6644C23v45Ev");}
void  S6644C2 ::v46(){vfunc_called(this, "_ZN7S6644C23v46Ev");}
void  S6644C2 ::v47(){vfunc_called(this, "_ZN7S6644C23v47Ev");}
void  S6644C2 ::v48(){vfunc_called(this, "_ZN7S6644C23v48Ev");}
void  S6644C2 ::v49(){vfunc_called(this, "_ZN7S6644C23v49Ev");}
void  S6644C2 ::v50(){vfunc_called(this, "_ZN7S6644C23v50Ev");}
void  S6644C2 ::v51(){vfunc_called(this, "_ZN7S6644C23v51Ev");}
void  S6644C2 ::v52(){vfunc_called(this, "_ZN7S6644C23v52Ev");}
void  S6644C2 ::v53(){vfunc_called(this, "_ZN7S6644C23v53Ev");}
void  S6644C2 ::v54(){vfunc_called(this, "_ZN7S6644C23v54Ev");}
S6644C2 ::S6644C2(){ note_ctor("S6644C2", this);} // tgen

static void Test_S6644C2()
{
  extern Class_Descriptor cd_S6644C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[2];
    init_test(&cd_S6644C2, buf);
    S6644C2 *dp, &lv = *(dp=new (buf) S6644C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(8,4), "sizeof(S6644C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6644C2)");
    test_class_info(&lv, &cd_S6644C2);
    dp->~S6644C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6644C2(Test_S6644C2, "S6644C2", ABISELECT(8,4));

#else // __cplusplus

extern void _ZN7S6644C2C1Ev();
extern void _ZN7S6644C2D1Ev();
Name_Map name_map_S6644C2[] = {
  NSPAIR(_ZN7S6644C2C1Ev),
  NSPAIR(_ZN7S6644C2D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S6644C2[];
extern void _ZN7S6644C2D1Ev();
extern void _ZN7S6644C2D0Ev();
extern void _ZN7S6644C23v28Ev();
extern void _ZN7S6644C23v29Ev();
extern void _ZN7S6644C23v30Ev();
extern void _ZN7S6644C23v31Ev();
extern void _ZN7S6644C23v32Ev();
extern void _ZN7S6644C23v33Ev();
extern void _ZN7S6644C23v34Ev();
extern void _ZN7S6644C23v35Ev();
extern void _ZN7S6644C23v36Ev();
extern void _ZN7S6644C23v37Ev();
extern void _ZN7S6644C23v38Ev();
extern void _ZN7S6644C23v39Ev();
extern void _ZN7S6644C23v40Ev();
extern void _ZN7S6644C23v41Ev();
extern void _ZN7S6644C23v42Ev();
extern void _ZN7S6644C23v43Ev();
extern void _ZN7S6644C23v44Ev();
extern void _ZN7S6644C23v45Ev();
extern void _ZN7S6644C23v46Ev();
extern void _ZN7S6644C23v47Ev();
extern void _ZN7S6644C23v48Ev();
extern void _ZN7S6644C23v49Ev();
extern void _ZN7S6644C23v50Ev();
extern void _ZN7S6644C23v51Ev();
extern void _ZN7S6644C23v52Ev();
extern void _ZN7S6644C23v53Ev();
extern void _ZN7S6644C23v54Ev();
static  VTBL_ENTRY vtc_S6644C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S6644C2[0]),
  (VTBL_ENTRY)&_ZN7S6644C2D1Ev,
  (VTBL_ENTRY)&_ZN7S6644C2D0Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v28Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v29Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v30Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v31Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v32Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v33Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v34Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v35Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v36Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v37Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v38Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v39Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v40Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v41Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v42Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v43Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v44Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v45Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v46Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v47Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v48Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v49Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v50Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v51Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v52Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v53Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v54Ev,
};
extern VTBL_ENTRY _ZTI7S6644C2[];
extern  VTBL_ENTRY _ZTV7S6644C2[];
Class_Descriptor cd_S6644C2 = {  "S6644C2", // class name
  0,0,//no base classes
  &(vtc_S6644C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(8,4), // object size
  NSPAIRA(_ZTI7S6644C2),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S6644C2),31, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6644C7_nt  {
  void *s6644c7f0;
  int s6644c7f1;
  void *s6644c7f2;
  int s6644c7f3;
  void  mf6644c7(); // _ZN10S6644C7_nt8mf6644c7Ev
};
//SIG(-1 S6644C7_nt) C1{ m Fp Fi Fp Fi}


void  S6644C7_nt ::mf6644c7(){}

//skip512 S6644C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6644C4_nt  {
  ::S3216C18 s6644c4f0;
  ::S6644C7_nt s6644c4f1;
  void  mf6644c4(); // _ZN10S6644C4_nt8mf6644c4Ev
};
//SIG(-1 S6644C4_nt) C1{ m FC2{ BC3{ m Fp Fi[2]}} FC4{ m Fp Fi Fp Fi}}


void  S6644C4_nt ::mf6644c4(){}

//skip512 S6644C4_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6644C11  {
  ::S3216C12 s6644c11f0;
  ::S6644C7_nt s6644c11f1;
  void  mf6644c11(); // _ZN8S6644C119mf6644c11Ev
};
//SIG(-1 S6644C11) C1{ m FC2{ BC3{ m Fp Fi[2]}} FC4{ m Fp Fi Fp Fi}}


void  S6644C11 ::mf6644c11(){}

static void Test_S6644C11()
{
  {
    init_simple_test("S6644C11");
    S6644C11 lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(S6644C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6644C11)");
    check_field_offset(lv, s6644c11f0, 0, "S6644C11.s6644c11f0");
    check_field_offset(lv, s6644c11f1, ABISELECT(16,12), "S6644C11.s6644c11f1");
  }
}
static Arrange_To_Call_Me vS6644C11(Test_S6644C11, "S6644C11", ABISELECT(48,28));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6644C19  {
  void *s6644c19f0;
  int s6644c19f1;
  void *s6644c19f2;
  int s6644c19f3;
  void  mf6644c19(); // _ZN8S6644C199mf6644c19Ev
};
//SIG(-1 S6644C19) C1{ m Fp Fi Fp Fi}


void  S6644C19 ::mf6644c19(){}

static void Test_S6644C19()
{
  {
    init_simple_test("S6644C19");
    S6644C19 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S6644C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6644C19)");
    check_field_offset(lv, s6644c19f0, 0, "S6644C19.s6644c19f0");
    check_field_offset(lv, s6644c19f1, ABISELECT(8,4), "S6644C19.s6644c19f1");
    check_field_offset(lv, s6644c19f2, ABISELECT(16,8), "S6644C19.s6644c19f2");
    check_field_offset(lv, s6644c19f3, ABISELECT(24,12), "S6644C19.s6644c19f3");
  }
}
static Arrange_To_Call_Me vS6644C19(Test_S6644C19, "S6644C19", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6644C17  {
  ::S3216C6_nt s6644c17f0;
  ::S6644C19 s6644c17f1;
  void  mf6644c17(); // _ZN8S6644C179mf6644c17Ev
};
//SIG(-1 S6644C17) C1{ m FC2{ BC3{ m Fp Fi[2]}} FC4{ m Fp Fi Fp Fi}}


void  S6644C17 ::mf6644c17(){}

static void Test_S6644C17()
{
  {
    init_simple_test("S6644C17");
    S6644C17 lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(S6644C17)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6644C17)");
    check_field_offset(lv, s6644c17f0, 0, "S6644C17.s6644c17f0");
    check_field_offset(lv, s6644c17f1, ABISELECT(16,12), "S6644C17.s6644c17f1");
  }
}
static Arrange_To_Call_Me vS6644C17(Test_S6644C17, "S6644C17", ABISELECT(48,28));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6644C23  {
  ::S75C21 s6644c23f0;
  ::S6644C19 s6644c23f1;
  void  mf6644c23(); // _ZN8S6644C239mf6644c23Ev
};
//SIG(-1 S6644C23) C1{ m FC2{ BC3{ m Fp Fi[2]}} FC4{ m Fp Fi Fp Fi}}


void  S6644C23 ::mf6644c23(){}

static void Test_S6644C23()
{
  {
    init_simple_test("S6644C23");
    S6644C23 lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(S6644C23)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6644C23)");
    check_field_offset(lv, s6644c23f0, 0, "S6644C23.s6644c23f0");
    check_field_offset(lv, s6644c23f1, ABISELECT(16,12), "S6644C23.s6644c23f1");
  }
}
static Arrange_To_Call_Me vS6644C23(Test_S6644C23, "S6644C23", ABISELECT(48,28));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6644C31  {
  void *s6644c31f0;
  int s6644c31f1;
  void *s6644c31f2;
  int s6644c31f3;
  void  mf6644c31(); // _ZN8S6644C319mf6644c31Ev
};
//SIG(-1 S6644C31) C1{ m Fp Fi Fp Fi}


void  S6644C31 ::mf6644c31(){}

static void Test_S6644C31()
{
  {
    init_simple_test("S6644C31");
    S6644C31 lv;
    check2(sizeof(lv), ABISELECT(32,16), "sizeof(S6644C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6644C31)");
    check_field_offset(lv, s6644c31f0, 0, "S6644C31.s6644c31f0");
    check_field_offset(lv, s6644c31f1, ABISELECT(8,4), "S6644C31.s6644c31f1");
    check_field_offset(lv, s6644c31f2, ABISELECT(16,8), "S6644C31.s6644c31f2");
    check_field_offset(lv, s6644c31f3, ABISELECT(24,12), "S6644C31.s6644c31f3");
  }
}
static Arrange_To_Call_Me vS6644C31(Test_S6644C31, "S6644C31", ABISELECT(32,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6644C29  {
  ::S75C11 s6644c29f0;
  ::S6644C31 s6644c29f1;
  void  mf6644c29(); // _ZN8S6644C299mf6644c29Ev
};
//SIG(-1 S6644C29) C1{ m FC2{ BC3{ m Fp Fi[2]}} FC4{ m Fp Fi Fp Fi}}


void  S6644C29 ::mf6644c29(){}

static void Test_S6644C29()
{
  {
    init_simple_test("S6644C29");
    S6644C29 lv;
    check2(sizeof(lv), ABISELECT(48,28), "sizeof(S6644C29)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6644C29)");
    check_field_offset(lv, s6644c29f0, 0, "S6644C29.s6644c29f0");
    check_field_offset(lv, s6644c29f1, ABISELECT(16,12), "S6644C29.s6644c29f1");
  }
}
static Arrange_To_Call_Me vS6644C29(Test_S6644C29, "S6644C29", ABISELECT(48,28));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6644C3  {
  ::S6644C4_nt s6644c3f0;
  ::S6644C4_nt s6644c3f1;
  ::S6644C4_nt s6644c3f2;
  ::S6644C11 s6644c3f3;
  ::S6644C11 s6644c3f4;
  ::S6644C17 s6644c3f5;
  ::S6644C17 s6644c3f6;
  ::S6644C23 s6644c3f7;
  ::S6644C23 s6644c3f8;
  ::S6644C29 s6644c3f9;
};
//SIG(1 S6644C3) C1{ FC2{ m FC3{ BC4{ m Fp Fi[2]}} FC5{ m Fp Fi Fp Fi}} FC2 FC2 FC6{ m FC7{ BC4} FC5} FC6 FC8{ m FC9{ BC4} FC10{ m Fp Fi Fp Fi}} FC8 FC11{ m FC12{ BC4} FC10} FC11 FC13{ m FC14{ BC4} FC15{ m Fp Fi Fp Fi}}}



static void Test_S6644C3()
{
  {
    init_simple_test("S6644C3");
    S6644C3 lv;
    check2(sizeof(lv), ABISELECT(480,280), "sizeof(S6644C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6644C3)");
    check_field_offset(lv, s6644c3f0, 0, "S6644C3.s6644c3f0");
    check_field_offset(lv, s6644c3f1, ABISELECT(48,28), "S6644C3.s6644c3f1");
    check_field_offset(lv, s6644c3f2, ABISELECT(96,56), "S6644C3.s6644c3f2");
    check_field_offset(lv, s6644c3f3, ABISELECT(144,84), "S6644C3.s6644c3f3");
    check_field_offset(lv, s6644c3f4, ABISELECT(192,112), "S6644C3.s6644c3f4");
    check_field_offset(lv, s6644c3f5, ABISELECT(240,140), "S6644C3.s6644c3f5");
    check_field_offset(lv, s6644c3f6, ABISELECT(288,168), "S6644C3.s6644c3f6");
    check_field_offset(lv, s6644c3f7, ABISELECT(336,196), "S6644C3.s6644c3f7");
    check_field_offset(lv, s6644c3f8, ABISELECT(384,224), "S6644C3.s6644c3f8");
    check_field_offset(lv, s6644c3f9, ABISELECT(432,252), "S6644C3.s6644c3f9");
  }
}
static Arrange_To_Call_Me vS6644C3(Test_S6644C3, "S6644C3", ABISELECT(480,280));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6644C33_nt  : S3216C7_nt {
};
//SIG(-1 S6644C33_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S6644C33_nt

#else // __cplusplus

extern Class_Descriptor cd_S3216C7_nt;
static Base_Class bases_S6644C33_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6644C35_nt  {
  void *s6644c35f0;
  int s6644c35f1[6];
  void  mf6644c35(); // _ZN11S6644C35_nt9mf6644c35Ev
};
//SIG(-1 S6644C35_nt) C1{ m Fp Fi[6]}


void  S6644C35_nt ::mf6644c35(){}

//skip512 S6644C35_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6644C32_nt  {
  ::S6644C33_nt s6644c32f0;
  ::S6644C33_nt s6644c32f1;
  ::S6644C35_nt s6644c32f2;
  void  mf6644c32(); // _ZN11S6644C32_nt9mf6644c32Ev
};
//SIG(-1 S6644C32_nt) C1{ m FC2{ BC3{ m Fp Fi[2]}} FC2 FC4{ m Fp Fi[6]}}


void  S6644C32_nt ::mf6644c32(){}

//skip512 S6644C32_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6644C39  : S3216C7_nt {
};
//SIG(-1 S6644C39) C1{ BC2{ m Fp Fi[2]}}



static void Test_S6644C39()
{
  extern Class_Descriptor cd_S6644C39;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S6644C39, buf);
    S6644C39 &lv = *(new (buf) S6644C39());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S6644C39)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6644C39)");
    check_base_class_offset(lv, (S3216C7_nt*), 0, "S6644C39");
    test_class_info(&lv, &cd_S6644C39);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6644C39(Test_S6644C39, "S6644C39", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3216C7_nt;
static Base_Class bases_S6644C39[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S6644C39 = {  "S6644C39", // class name
  bases_S6644C39, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6644C38  {
  ::S6644C39 s6644c38f0;
  ::S6644C33_nt s6644c38f1;
  ::S6644C35_nt s6644c38f2;
  void  mf6644c38(); // _ZN8S6644C389mf6644c38Ev
};
//SIG(-1 S6644C38) C1{ m FC2{ BC3{ m Fp Fi[2]}} FC4{ BC3} FC5{ m Fp Fi[6]}}


void  S6644C38 ::mf6644c38(){}

static void Test_S6644C38()
{
  {
    init_simple_test("S6644C38");
    S6644C38 lv;
    check2(sizeof(lv), ABISELECT(64,52), "sizeof(S6644C38)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6644C38)");
    check_field_offset(lv, s6644c38f0, 0, "S6644C38.s6644c38f0");
    check_field_offset(lv, s6644c38f1, ABISELECT(16,12), "S6644C38.s6644c38f1");
    check_field_offset(lv, s6644c38f2, ABISELECT(32,24), "S6644C38.s6644c38f2");
  }
}
static Arrange_To_Call_Me vS6644C38(Test_S6644C38, "S6644C38", ABISELECT(64,52));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6644C43  : S3216C7_nt {
};
//SIG(-1 S6644C43) C1{ BC2{ m Fp Fi[2]}}



static void Test_S6644C43()
{
  extern Class_Descriptor cd_S6644C43;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S6644C43, buf);
    S6644C43 &lv = *(new (buf) S6644C43());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S6644C43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6644C43)");
    check_base_class_offset(lv, (S3216C7_nt*), 0, "S6644C43");
    test_class_info(&lv, &cd_S6644C43);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6644C43(Test_S6644C43, "S6644C43", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3216C7_nt;
static Base_Class bases_S6644C43[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S6644C43 = {  "S6644C43", // class name
  bases_S6644C43, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6644C44_nt  {
  void *s6644c44f0;
  int s6644c44f1[2];
  ::S6644C43 s6644c44f2;
  void *s6644c44f3;
  void  mf6644c44(); // _ZN11S6644C44_nt9mf6644c44Ev
};
//SIG(-1 S6644C44_nt) C1{ m Fp Fi[2] FC2{ BC3{ m Fp Fi[2]}} Fp}


void  S6644C44_nt ::mf6644c44(){}

//skip512 S6644C44_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6644C48  : S3216C7_nt {
};
//SIG(-1 S6644C48) C1{ BC2{ m Fp Fi[2]}}



static void Test_S6644C48()
{
  extern Class_Descriptor cd_S6644C48;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S6644C48, buf);
    S6644C48 &lv = *(new (buf) S6644C48());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S6644C48)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6644C48)");
    check_base_class_offset(lv, (S3216C7_nt*), 0, "S6644C48");
    test_class_info(&lv, &cd_S6644C48);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6644C48(Test_S6644C48, "S6644C48", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S3216C7_nt;
static Base_Class bases_S6644C48[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S6644C48 = {  "S6644C48", // class name
  bases_S6644C48, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S6644C1  : S6644C2 {
  void *s6644c1f0;
  ::S6644C3 s6644c1f1[4];
  ::S6644C32_nt s6644c1f2;
  ::S6644C32_nt s6644c1f3;
  ::S6644C38 s6644c1f4;
  ::S6644C38 s6644c1f5;
  ::S6644C38 s6644c1f6;
  ::S6644C39 s6644c1f7;
  ::S6644C43 s6644c1f8;
  ::S6644C44_nt s6644c1f9;
  ::S6644C44_nt s6644c1f10;
  int s6644c1f11[3];
  ::S6644C48 s6644c1f12;
  virtual void  v1(); // _ZN7S6644C12v1Ev
  virtual void  v2(); // _ZN7S6644C12v2Ev
  virtual void  v3(); // _ZN7S6644C12v3Ev
  virtual void  v4(); // _ZN7S6644C12v4Ev
  virtual void  v5(); // _ZN7S6644C12v5Ev
  virtual void  v6(); // _ZN7S6644C12v6Ev
  virtual void  v7(); // _ZN7S6644C12v7Ev
  virtual void  v8(); // _ZN7S6644C12v8Ev
  virtual void  v9(); // _ZN7S6644C12v9Ev
  virtual void  v10(); // _ZN7S6644C13v10Ev
  virtual void  v11(); // _ZN7S6644C13v11Ev
  virtual void  v12(); // _ZN7S6644C13v12Ev
  virtual void  v13(); // _ZN7S6644C13v13Ev
  virtual void  v14(); // _ZN7S6644C13v14Ev
  virtual void  v15(); // _ZN7S6644C13v15Ev
  virtual void  v16(); // _ZN7S6644C13v16Ev
  virtual void  v17(); // _ZN7S6644C13v17Ev
  virtual void  v18(); // _ZN7S6644C13v18Ev
  virtual void  v19(); // _ZN7S6644C13v19Ev
  virtual void  v20(); // _ZN7S6644C13v20Ev
  virtual void  v21(); // _ZN7S6644C13v21Ev
  virtual void  v22(); // _ZN7S6644C13v22Ev
  virtual void  v23(); // _ZN7S6644C13v23Ev
  virtual void  v24(); // _ZN7S6644C13v24Ev
  virtual void  v25(); // _ZN7S6644C13v25Ev
  virtual void  v26(); // _ZN7S6644C13v26Ev
  virtual void  v27(); // _ZN7S6644C13v27Ev
  ~S6644C1(); // tgen
  S6644C1(); // tgen
};
//SIG(1 S6644C1) C1{ BC2{ vd v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54} v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 Fp FC3{ FC4{ m FC5{ BC6{ m Fp Fi[2]}} FC7{ m Fp Fi Fp Fi}} FC4 FC4 FC8{ m FC9{ BC6} FC7} FC8 FC10{ m FC11{ BC6} FC12{ m Fp Fi Fp Fi}} FC10 FC13{ m FC14{ BC6} FC12} FC13 FC15{ m FC16{ BC6} FC17{ m Fp Fi Fp Fi}}}[4] FC18{ m FC19{ BC6} FC19 FC20{ m Fp Fi[6]}} FC18 FC21{ m FC22{ BC6} FC19 FC20} FC21 FC21 FC22 FC23{ BC6} FC24{ m Fp Fi[2] FC23 Fp} FC24 Fi[3] FC25{ BC6}}


void  S6644C1 ::v1(){vfunc_called(this, "_ZN7S6644C12v1Ev");}
void  S6644C1 ::v2(){vfunc_called(this, "_ZN7S6644C12v2Ev");}
void  S6644C1 ::v3(){vfunc_called(this, "_ZN7S6644C12v3Ev");}
void  S6644C1 ::v4(){vfunc_called(this, "_ZN7S6644C12v4Ev");}
void  S6644C1 ::v5(){vfunc_called(this, "_ZN7S6644C12v5Ev");}
void  S6644C1 ::v6(){vfunc_called(this, "_ZN7S6644C12v6Ev");}
void  S6644C1 ::v7(){vfunc_called(this, "_ZN7S6644C12v7Ev");}
void  S6644C1 ::v8(){vfunc_called(this, "_ZN7S6644C12v8Ev");}
void  S6644C1 ::v9(){vfunc_called(this, "_ZN7S6644C12v9Ev");}
void  S6644C1 ::v10(){vfunc_called(this, "_ZN7S6644C13v10Ev");}
void  S6644C1 ::v11(){vfunc_called(this, "_ZN7S6644C13v11Ev");}
void  S6644C1 ::v12(){vfunc_called(this, "_ZN7S6644C13v12Ev");}
void  S6644C1 ::v13(){vfunc_called(this, "_ZN7S6644C13v13Ev");}
void  S6644C1 ::v14(){vfunc_called(this, "_ZN7S6644C13v14Ev");}
void  S6644C1 ::v15(){vfunc_called(this, "_ZN7S6644C13v15Ev");}
void  S6644C1 ::v16(){vfunc_called(this, "_ZN7S6644C13v16Ev");}
void  S6644C1 ::v17(){vfunc_called(this, "_ZN7S6644C13v17Ev");}
void  S6644C1 ::v18(){vfunc_called(this, "_ZN7S6644C13v18Ev");}
void  S6644C1 ::v19(){vfunc_called(this, "_ZN7S6644C13v19Ev");}
void  S6644C1 ::v20(){vfunc_called(this, "_ZN7S6644C13v20Ev");}
void  S6644C1 ::v21(){vfunc_called(this, "_ZN7S6644C13v21Ev");}
void  S6644C1 ::v22(){vfunc_called(this, "_ZN7S6644C13v22Ev");}
void  S6644C1 ::v23(){vfunc_called(this, "_ZN7S6644C13v23Ev");}
void  S6644C1 ::v24(){vfunc_called(this, "_ZN7S6644C13v24Ev");}
void  S6644C1 ::v25(){vfunc_called(this, "_ZN7S6644C13v25Ev");}
void  S6644C1 ::v26(){vfunc_called(this, "_ZN7S6644C13v26Ev");}
void  S6644C1 ::v27(){vfunc_called(this, "_ZN7S6644C13v27Ev");}
S6644C1 ::~S6644C1(){ note_dtor("S6644C1", this);} // tgen
S6644C1 ::S6644C1(){ note_ctor("S6644C1", this);} // tgen

static void Test_S6644C1()
{
  extern Class_Descriptor cd_S6644C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(301,374)];
    init_test(&cd_S6644C1, buf);
    S6644C1 *dp, &lv = *(dp=new (buf) S6644C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2400,1492), "sizeof(S6644C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S6644C1)");
    check_base_class_offset(lv, (S6644C2*), 0, "S6644C1");
    check_field_offset(lv, s6644c1f0, ABISELECT(8,4), "S6644C1.s6644c1f0");
    check_field_offset(lv, s6644c1f1, ABISELECT(16,8), "S6644C1.s6644c1f1");
    check_field_offset(lv, s6644c1f2, ABISELECT(1936,1128), "S6644C1.s6644c1f2");
    check_field_offset(lv, s6644c1f3, ABISELECT(2000,1180), "S6644C1.s6644c1f3");
    check_field_offset(lv, s6644c1f4, ABISELECT(2064,1232), "S6644C1.s6644c1f4");
    check_field_offset(lv, s6644c1f5, ABISELECT(2128,1284), "S6644C1.s6644c1f5");
    check_field_offset(lv, s6644c1f6, ABISELECT(2192,1336), "S6644C1.s6644c1f6");
    check_field_offset(lv, s6644c1f7, ABISELECT(2256,1388), "S6644C1.s6644c1f7");
    check_field_offset(lv, s6644c1f8, ABISELECT(2272,1400), "S6644C1.s6644c1f8");
    check_field_offset(lv, s6644c1f9, ABISELECT(2288,1412), "S6644C1.s6644c1f9");
    check_field_offset(lv, s6644c1f10, ABISELECT(2328,1440), "S6644C1.s6644c1f10");
    check_field_offset(lv, s6644c1f11, ABISELECT(2368,1468), "S6644C1.s6644c1f11");
    check_field_offset(lv, s6644c1f12, ABISELECT(2384,1480), "S6644C1.s6644c1f12");
    test_class_info(&lv, &cd_S6644C1);
    dp->~S6644C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS6644C1(Test_S6644C1, "S6644C1", ABISELECT(2400,1492));

#else // __cplusplus

extern void _ZN7S6644C1C1Ev();
extern void _ZN7S6644C1D1Ev();
Name_Map name_map_S6644C1[] = {
  NSPAIR(_ZN7S6644C1C1Ev),
  NSPAIR(_ZN7S6644C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S6644C2;
extern VTBL_ENTRY _ZTI7S6644C2[];
extern  VTBL_ENTRY _ZTV7S6644C2[];
static Base_Class bases_S6644C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S6644C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S6644C1[];
extern void _ZN7S6644C1D1Ev();
extern void _ZN7S6644C1D0Ev();
extern void _ZN7S6644C23v28Ev();
extern void _ZN7S6644C23v29Ev();
extern void _ZN7S6644C23v30Ev();
extern void _ZN7S6644C23v31Ev();
extern void _ZN7S6644C23v32Ev();
extern void _ZN7S6644C23v33Ev();
extern void _ZN7S6644C23v34Ev();
extern void _ZN7S6644C23v35Ev();
extern void _ZN7S6644C23v36Ev();
extern void _ZN7S6644C23v37Ev();
extern void _ZN7S6644C23v38Ev();
extern void _ZN7S6644C23v39Ev();
extern void _ZN7S6644C23v40Ev();
extern void _ZN7S6644C23v41Ev();
extern void _ZN7S6644C23v42Ev();
extern void _ZN7S6644C23v43Ev();
extern void _ZN7S6644C23v44Ev();
extern void _ZN7S6644C23v45Ev();
extern void _ZN7S6644C23v46Ev();
extern void _ZN7S6644C23v47Ev();
extern void _ZN7S6644C23v48Ev();
extern void _ZN7S6644C23v49Ev();
extern void _ZN7S6644C23v50Ev();
extern void _ZN7S6644C23v51Ev();
extern void _ZN7S6644C23v52Ev();
extern void _ZN7S6644C23v53Ev();
extern void _ZN7S6644C23v54Ev();
extern void _ZN7S6644C12v1Ev();
extern void _ZN7S6644C12v2Ev();
extern void _ZN7S6644C12v3Ev();
extern void _ZN7S6644C12v4Ev();
extern void _ZN7S6644C12v5Ev();
extern void _ZN7S6644C12v6Ev();
extern void _ZN7S6644C12v7Ev();
extern void _ZN7S6644C12v8Ev();
extern void _ZN7S6644C12v9Ev();
extern void _ZN7S6644C13v10Ev();
extern void _ZN7S6644C13v11Ev();
extern void _ZN7S6644C13v12Ev();
extern void _ZN7S6644C13v13Ev();
extern void _ZN7S6644C13v14Ev();
extern void _ZN7S6644C13v15Ev();
extern void _ZN7S6644C13v16Ev();
extern void _ZN7S6644C13v17Ev();
extern void _ZN7S6644C13v18Ev();
extern void _ZN7S6644C13v19Ev();
extern void _ZN7S6644C13v20Ev();
extern void _ZN7S6644C13v21Ev();
extern void _ZN7S6644C13v22Ev();
extern void _ZN7S6644C13v23Ev();
extern void _ZN7S6644C13v24Ev();
extern void _ZN7S6644C13v25Ev();
extern void _ZN7S6644C13v26Ev();
extern void _ZN7S6644C13v27Ev();
static  VTBL_ENTRY vtc_S6644C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S6644C1[0]),
  (VTBL_ENTRY)&_ZN7S6644C1D1Ev,
  (VTBL_ENTRY)&_ZN7S6644C1D0Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v28Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v29Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v30Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v31Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v32Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v33Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v34Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v35Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v36Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v37Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v38Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v39Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v40Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v41Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v42Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v43Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v44Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v45Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v46Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v47Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v48Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v49Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v50Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v51Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v52Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v53Ev,
  (VTBL_ENTRY)&_ZN7S6644C23v54Ev,
  (VTBL_ENTRY)&_ZN7S6644C12v1Ev,
  (VTBL_ENTRY)&_ZN7S6644C12v2Ev,
  (VTBL_ENTRY)&_ZN7S6644C12v3Ev,
  (VTBL_ENTRY)&_ZN7S6644C12v4Ev,
  (VTBL_ENTRY)&_ZN7S6644C12v5Ev,
  (VTBL_ENTRY)&_ZN7S6644C12v6Ev,
  (VTBL_ENTRY)&_ZN7S6644C12v7Ev,
  (VTBL_ENTRY)&_ZN7S6644C12v8Ev,
  (VTBL_ENTRY)&_ZN7S6644C12v9Ev,
  (VTBL_ENTRY)&_ZN7S6644C13v10Ev,
  (VTBL_ENTRY)&_ZN7S6644C13v11Ev,
  (VTBL_ENTRY)&_ZN7S6644C13v12Ev,
  (VTBL_ENTRY)&_ZN7S6644C13v13Ev,
  (VTBL_ENTRY)&_ZN7S6644C13v14Ev,
  (VTBL_ENTRY)&_ZN7S6644C13v15Ev,
  (VTBL_ENTRY)&_ZN7S6644C13v16Ev,
  (VTBL_ENTRY)&_ZN7S6644C13v17Ev,
  (VTBL_ENTRY)&_ZN7S6644C13v18Ev,
  (VTBL_ENTRY)&_ZN7S6644C13v19Ev,
  (VTBL_ENTRY)&_ZN7S6644C13v20Ev,
  (VTBL_ENTRY)&_ZN7S6644C13v21Ev,
  (VTBL_ENTRY)&_ZN7S6644C13v22Ev,
  (VTBL_ENTRY)&_ZN7S6644C13v23Ev,
  (VTBL_ENTRY)&_ZN7S6644C13v24Ev,
  (VTBL_ENTRY)&_ZN7S6644C13v25Ev,
  (VTBL_ENTRY)&_ZN7S6644C13v26Ev,
  (VTBL_ENTRY)&_ZN7S6644C13v27Ev,
};
extern VTBL_ENTRY _ZTI7S6644C1[];
extern  VTBL_ENTRY _ZTV7S6644C1[];
Class_Descriptor cd_S6644C1 = {  "S6644C1", // class name
  bases_S6644C1, 1,
  &(vtc_S6644C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2400,1492), // object size
  NSPAIRA(_ZTI7S6644C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S6644C1),58, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20643C6  : S3216C8_nt {
  ::S3216C8_nt s20643c6f0[3];
  ::S3216C8_nt s20643c6f1[2];
  void *s20643c6f2;
  short s20643c6f3;
  ::S3216C8_nt s20643c6f4;
  virtual void  v2(); // _ZN8S20643C62v2Ev
  virtual void  v3(); // _ZN8S20643C62v3Ev
  virtual void  v4(); // _ZN8S20643C62v4Ev
  ~S20643C6(); // tgen
  S20643C6(); // tgen
};
//SIG(-1 S20643C6) C1{ BC2{ m Fi} v1 v2 v3 FC2[3] FC2[2] Fp Fs FC2}


void  S20643C6 ::v2(){vfunc_called(this, "_ZN8S20643C62v2Ev");}
void  S20643C6 ::v3(){vfunc_called(this, "_ZN8S20643C62v3Ev");}
void  S20643C6 ::v4(){vfunc_called(this, "_ZN8S20643C62v4Ev");}
S20643C6 ::~S20643C6(){ note_dtor("S20643C6", this);} // tgen
S20643C6 ::S20643C6(){ note_ctor("S20643C6", this);} // tgen

static void Test_S20643C6()
{
  extern Class_Descriptor cd_S20643C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,11)];
    init_test(&cd_S20643C6, buf);
    S20643C6 *dp, &lv = *(dp=new (buf) S20643C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,40), "sizeof(S20643C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20643C6)");
    check_base_class_offset(lv, (S3216C8_nt*), ABISELECT(8,4), "S20643C6");
    check_field_offset(lv, s20643c6f0, ABISELECT(12,8), "S20643C6.s20643c6f0");
    check_field_offset(lv, s20643c6f1, ABISELECT(24,20), "S20643C6.s20643c6f1");
    check_field_offset(lv, s20643c6f2, ABISELECT(32,28), "S20643C6.s20643c6f2");
    check_field_offset(lv, s20643c6f3, ABISELECT(40,32), "S20643C6.s20643c6f3");
    check_field_offset(lv, s20643c6f4, ABISELECT(44,36), "S20643C6.s20643c6f4");
    test_class_info(&lv, &cd_S20643C6);
    dp->~S20643C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20643C6(Test_S20643C6, "S20643C6", ABISELECT(48,40));

#else // __cplusplus

extern void _ZN8S20643C6C1Ev();
extern void _ZN8S20643C6D1Ev();
Name_Map name_map_S20643C6[] = {
  NSPAIR(_ZN8S20643C6C1Ev),
  NSPAIR(_ZN8S20643C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
static Base_Class bases_S20643C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C8_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20643C6[];
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY vtc_S20643C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C6[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
Class_Descriptor cd_S20643C6 = {  "S20643C6", // class name
  bases_S20643C6, 1,
  &(vtc_S20643C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,40), // object size
  NSPAIRA(_ZTI8S20643C6),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S20643C6),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20643C5  : S20643C6 , virtual S3216C8_nt {
  long double s20643c5f0;
  __tsi64 s20643c5f1;
  ::S20643C6 s20643c5f2;
  void *s20643c5f3;
  short s20643c5f4[3];
  ~S20643C5(); // tgen
  S20643C5(); // tgen
};
//SIG(-1 S20643C5) C1{ BC2{ BC3{ m Fi} v1 v2 v3 FC3[3] FC3[2] Fp Fs FC3} VBC3 FD FL FC2 Fp Fs[3]}


S20643C5 ::~S20643C5(){ note_dtor("S20643C5", this);} // tgen
S20643C5 ::S20643C5(){ note_ctor("S20643C5", this);} // tgen

static void Test_S20643C5()
{
  extern Class_Descriptor cd_S20643C5;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(10,30)];
    init_test(&cd_S20643C5, buf);
    S20643C5 *dp, &lv = *(dp=new (buf) S20643C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,116), "sizeof(S20643C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20643C5)");
    check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*), ABISELECT(8,4), "S20643C5");
    check_base_class_offset(lv, (S20643C6*), 0, "S20643C5");
    /*is_ambiguous_... S20643C5::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*), ABISELECT(136,112), "S20643C5");
    check_field_offset(lv, s20643c5f0, ABISELECT(48,40), "S20643C5.s20643c5f0");
    check_field_offset(lv, s20643c5f1, ABISELECT(64,52), "S20643C5.s20643c5f1");
    check_field_offset(lv, s20643c5f2, ABISELECT(72,60), "S20643C5.s20643c5f2");
    check_field_offset(lv, s20643c5f3, ABISELECT(120,100), "S20643C5.s20643c5f3");
    check_field_offset(lv, s20643c5f4, ABISELECT(128,104), "S20643C5.s20643c5f4");
    test_class_info(&lv, &cd_S20643C5);
    dp->~S20643C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20643C5(Test_S20643C5, "S20643C5", ABISELECT(144,116));

#else // __cplusplus

extern void _ZN8S20643C5C1Ev();
extern void _ZN8S20643C5D1Ev();
Name_Map name_map_S20643C5[] = {
  NSPAIR(_ZN8S20643C5C1Ev),
  NSPAIR(_ZN8S20643C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
static Base_Class bases_S20643C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C8_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20643C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3216C8_nt,    ABISELECT(136,112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20643C5[];
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY vtc_S20643C5[] = {
  ABISELECT(136,112),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern VTBL_ENTRY _ZTV8S20643C5[];
static  VTT_ENTRY vtt_S20643C5[] = {
  {&(_ZTV8S20643C5[3]),  3,6},
};
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
Class_Descriptor cd_S20643C5 = {  "S20643C5", // class name
  bases_S20643C5, 3,
  &(vtc_S20643C5[0]), // expected_vtbl_contents
  &(vtt_S20643C5[0]), // expected_vtt_contents
  ABISELECT(144,116), // object size
  NSPAIRA(_ZTI8S20643C5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S20643C5),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20643C5),1, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20643C7  : S20643C6 {
  void *s20643c7f0[7];
  int s20643c7f1[2];
  __tsi64 s20643c7f2;
  int s20643c7f3;
  virtual  ~S20643C7(); // _ZN8S20643C7D1Ev
  virtual void  v5(); // _ZN8S20643C72v5Ev
  S20643C7(); // tgen
};
//SIG(-1 S20643C7) C1{ BC2{ BC3{ m Fi} v2 v3 v4 FC3[3] FC3[2] Fp Fs FC3} vd v1 Fp[7] Fi[2] FL Fi}


 S20643C7 ::~S20643C7(){ note_dtor("S20643C7", this);}
void  S20643C7 ::v5(){vfunc_called(this, "_ZN8S20643C72v5Ev");}
S20643C7 ::S20643C7(){ note_ctor("S20643C7", this);} // tgen

static void Test_S20643C7()
{
  extern Class_Descriptor cd_S20643C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(17,23)];
    init_test(&cd_S20643C7, buf);
    S20643C7 *dp, &lv = *(dp=new (buf) S20643C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,88), "sizeof(S20643C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20643C7)");
    check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*), ABISELECT(8,4), "S20643C7");
    check_base_class_offset(lv, (S20643C6*), 0, "S20643C7");
    check_field_offset(lv, s20643c7f0, ABISELECT(48,40), "S20643C7.s20643c7f0");
    check_field_offset(lv, s20643c7f1, ABISELECT(104,68), "S20643C7.s20643c7f1");
    check_field_offset(lv, s20643c7f2, ABISELECT(112,76), "S20643C7.s20643c7f2");
    check_field_offset(lv, s20643c7f3, ABISELECT(120,84), "S20643C7.s20643c7f3");
    test_class_info(&lv, &cd_S20643C7);
    dp->~S20643C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20643C7(Test_S20643C7, "S20643C7", ABISELECT(128,88));

#else // __cplusplus

extern void _ZN8S20643C7C1Ev();
extern void _ZN8S20643C7D1Ev();
Name_Map name_map_S20643C7[] = {
  NSPAIR(_ZN8S20643C7C1Ev),
  NSPAIR(_ZN8S20643C7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
static Base_Class bases_S20643C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C8_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20643C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20643C7[];
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C7D1Ev();
extern void _ZN8S20643C7D0Ev();
extern void _ZN8S20643C72v5Ev();
static  VTBL_ENTRY vtc_S20643C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C7[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20643C7D1Ev,
  (VTBL_ENTRY)&_ZN8S20643C7D0Ev,
  (VTBL_ENTRY)&_ZN8S20643C72v5Ev,
};
extern VTBL_ENTRY _ZTI8S20643C7[];
extern  VTBL_ENTRY _ZTV8S20643C7[];
Class_Descriptor cd_S20643C7 = {  "S20643C7", // class name
  bases_S20643C7, 2,
  &(vtc_S20643C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(128,88), // object size
  NSPAIRA(_ZTI8S20643C7),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S20643C7),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20643C9  : virtual S20643C6 , virtual S3216C8_nt {
  ::S20643C6 s20643c9f0;
  long double s20643c9f1;
  void *s20643c9f2[2];
  ::S20643C6 s20643c9f3;
  virtual void  v6(); // _ZN8S20643C92v6Ev
  ~S20643C9(); // tgen
  S20643C9(); // tgen
};
//SIG(-1 S20643C9) C1{ VBC2{ BC3{ m Fi} v2 v3 v4 FC3[3] FC3[2] Fp Fs FC3} VBC3 v1 FC2 FD Fp[2] FC2}


void  S20643C9 ::v6(){vfunc_called(this, "_ZN8S20643C92v6Ev");}
S20643C9 ::~S20643C9(){ note_dtor("S20643C9", this);} // tgen
S20643C9 ::S20643C9(){ note_ctor("S20643C9", this);} // tgen

static void Test_S20643C9()
{
  extern Class_Descriptor cd_S20643C9;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(14,38)];
    init_test(&cd_S20643C9, buf);
    S20643C9 *dp, &lv = *(dp=new (buf) S20643C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,148), "sizeof(S20643C9)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20643C9)");
    check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*), ABISELECT(152,108), "S20643C9");
    check_base_class_offset(lv, (S20643C6*), ABISELECT(144,104), "S20643C9");
    /*is_ambiguous_... S20643C9::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*), ABISELECT(192,144), "S20643C9");
    check_field_offset(lv, s20643c9f0, ABISELECT(8,4), "S20643C9.s20643c9f0");
    check_field_offset(lv, s20643c9f1, ABISELECT(64,44), "S20643C9.s20643c9f1");
    check_field_offset(lv, s20643c9f2, ABISELECT(80,56), "S20643C9.s20643c9f2");
    check_field_offset(lv, s20643c9f3, ABISELECT(96,64), "S20643C9.s20643c9f3");
    test_class_info(&lv, &cd_S20643C9);
    dp->~S20643C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20643C9(Test_S20643C9, "S20643C9", ABISELECT(208,148));

#else // __cplusplus

extern void _ZN8S20643C9C1Ev();
extern void _ZN8S20643C9D1Ev();
Name_Map name_map_S20643C9[] = {
  NSPAIR(_ZN8S20643C9C1Ev),
  NSPAIR(_ZN8S20643C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
static Base_Class bases_S20643C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C8_nt,    ABISELECT(152,108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(144,104), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3216C8_nt,    ABISELECT(192,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20643C9[];
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY vtc_S20643C9[] = {
  ABISELECT(192,144),
  ABISELECT(144,104),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  0,
  0,
  0,
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern VTBL_ENTRY _ZTV8S20643C9[];
static  VTT_ENTRY vtt_S20643C9[] = {
  {&(_ZTV8S20643C9[4]),  4,13},
  {&(_ZTV8S20643C9[10]),  10,13},
};
extern VTBL_ENTRY _ZTI8S20643C9[];
extern  VTBL_ENTRY _ZTV8S20643C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C9[];
Class_Descriptor cd_S20643C9 = {  "S20643C9", // class name
  bases_S20643C9, 3,
  &(vtc_S20643C9[0]), // expected_vtbl_contents
  &(vtt_S20643C9[0]), // expected_vtt_contents
  ABISELECT(208,148), // object size
  NSPAIRA(_ZTI8S20643C9),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S20643C9),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20643C9),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20643C8  : virtual S20643C6 , virtual S3216C8_nt , S20643C9 , S20643C5 {
  void *s20643c8f0[2];
  long s20643c8f1;
  int s20643c8f2;
  ::S20643C6 s20643c8f3[5];
  virtual void  v7(); // _ZN8S20643C82v7Ev
  ~S20643C8(); // tgen
  S20643C8(); // tgen
};
//SIG(-1 S20643C8) C1{ VBC2{ BC3{ m Fi} v2 v3 v4 FC3[3] FC3[2] Fp Fs FC3} VBC3 BC4{ VBC2 VBC3 v5 FC2 FD Fp[2] FC2} BC5{ BC2 VBC3 FD FL FC2 Fp Fs[3]} v1 Fp[2] Fl Fi FC2[5]}


void  S20643C8 ::v7(){vfunc_called(this, "_ZN8S20643C82v7Ev");}
S20643C8 ::~S20643C8(){ note_dtor("S20643C8", this);} // tgen
S20643C8 ::S20643C8(){ note_ctor("S20643C8", this);} // tgen

static void Test_S20643C8()
{
  extern Class_Descriptor cd_S20643C8;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(39,120)];
    init_test(&cd_S20643C8, buf);
    S20643C8 *dp, &lv = *(dp=new (buf) S20643C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(608,476), "sizeof(S20643C8)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20643C8)");
    /*is_ambiguous_... S20643C8::S20643C6 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*), ABISELECT(560,436), "S20643C8");
    /*is_ambiguous_... S20643C8::S20643C6 */ AMB_check_base_class_offset(lv, (S20643C6*), ABISELECT(552,432), "S20643C8");
    check_base_class_offset(lv, (S20643C6*)(S20643C9*), ABISELECT(552,432), "S20643C8");
    /*is_ambiguous_... S20643C8::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*), ABISELECT(600,472), "S20643C8");
    /*is_ambiguous_... S20643C9::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C9*), ABISELECT(600,472), "S20643C8");
    /*is_ambiguous_... S20643C5::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*), ABISELECT(600,472), "S20643C8");
    check_base_class_offset(lv, (S20643C9*), 0, "S20643C8");
    check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*), ABISELECT(152,108), "S20643C8");
    check_base_class_offset(lv, (S20643C6*)(S20643C5*), ABISELECT(144,104), "S20643C8");
    check_base_class_offset(lv, (S20643C5*), ABISELECT(144,104), "S20643C8");
    check_field_offset(lv, s20643c8f0, ABISELECT(280,216), "S20643C8.s20643c8f0");
    check_field_offset(lv, s20643c8f1, ABISELECT(296,224), "S20643C8.s20643c8f1");
    check_field_offset(lv, s20643c8f2, ABISELECT(304,228), "S20643C8.s20643c8f2");
    check_field_offset(lv, s20643c8f3, ABISELECT(312,232), "S20643C8.s20643c8f3");
    test_class_info(&lv, &cd_S20643C8);
    dp->~S20643C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20643C8(Test_S20643C8, "S20643C8", ABISELECT(608,476));

#else // __cplusplus

extern void _ZN8S20643C8C1Ev();
extern void _ZN8S20643C8D1Ev();
Name_Map name_map_S20643C8[] = {
  NSPAIR(_ZN8S20643C8C1Ev),
  NSPAIR(_ZN8S20643C8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C9;
extern VTBL_ENTRY _ZTI8S20643C9[];
extern  VTBL_ENTRY _ZTV8S20643C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
static Base_Class bases_S20643C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C8_nt,    ABISELECT(560,436), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(552,432), //bcp->offset
    12, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3216C8_nt,    ABISELECT(600,472), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20643C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3216C8_nt,    ABISELECT(152,108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(144,104), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(144,104), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20643C8[];
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY vtc_S20643C8[] = {
  ABISELECT(600,472),
  ABISELECT(552,432),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
  ABISELECT(456,368),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  0,
  0,
  0,
  ABISELECT(-552,-432),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern VTBL_ENTRY _ZTV8S20643C8[];
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C9__8S20643C8[] = {
  ABISELECT(600,472),
  ABISELECT(552,432),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C9__8S20643C8[] = {
  0,
  0,
  0,
  ABISELECT(-552,-432),
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__8S20643C8[] = {
  ABISELECT(456,368),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
static  VTT_ENTRY vtt_S20643C8[] = {
  {&(_ZTV8S20643C8[4]),  4,20},
  {&(_tg__ZTV8S20643C9__8S20643C8[4]),  4,5},
  {&(_tg__ZTV8S20643C6__8S20643C9__8S20643C8[5]),  5,8},
  {&(_tg__ZTV8S20643C5__8S20643C8[3]),  3,6},
  {&(_ZTV8S20643C8[17]),  17,20},
  {&(_ZTV8S20643C8[9]),  9,20},
};
extern VTBL_ENTRY _ZTI8S20643C8[];
extern  VTBL_ENTRY _ZTV8S20643C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C8[];
Class_Descriptor cd_S20643C8 = {  "S20643C8", // class name
  bases_S20643C8, 7,
  &(vtc_S20643C8[0]), // expected_vtbl_contents
  &(vtt_S20643C8[0]), // expected_vtt_contents
  ABISELECT(608,476), // object size
  NSPAIRA(_ZTI8S20643C8),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S20643C8),20, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20643C8),6, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20643C4  : virtual S20643C5 , S20643C7 , virtual S20643C6 , S20643C8 , S20643C9 {
  int s20643c4f0[2];
  long double s20643c4f1;
  ::S20643C9 s20643c4f2[10];
  int s20643c4f3;
  virtual void  v8(); // _ZN8S20643C42v8Ev
  ~S20643C4(); // tgen
  S20643C4(); // tgen
};
//SIG(-1 S20643C4) C1{ VBC2{ BC3{ BC4{ m Fi} v2 v3 v4 FC4[3] FC4[2] Fp Fs FC4} VBC4 FD FL FC3 Fp Fs[3]} BC5{ BC3 vd v5 Fp[7] Fi[2] FL Fi} VBC3 BC6{ VBC3 VBC4 BC7{ VBC3 VBC4 v6 FC3 FD Fp[2] FC3} BC2 v7 Fp[2] Fl Fi FC3[5]} BC7 v1 Fi[2] FD FC7[10] Fi}


void  S20643C4 ::v8(){vfunc_called(this, "_ZN8S20643C42v8Ev");}
S20643C4 ::~S20643C4(){ note_dtor("S20643C4", this);} // tgen
S20643C4 ::S20643C4(){ note_ctor("S20643C4", this);} // tgen

static void Test_S20643C4()
{
  extern Class_Descriptor cd_S20643C4;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(198,572)];
    init_test(&cd_S20643C4, buf);
    S20643C4 *dp, &lv = *(dp=new (buf) S20643C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(3152,2284), "sizeof(S20643C4)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20643C4)");
    /*is_ambiguous_... S20643C4::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*), ABISELECT(2968,2132), "S20643C4");
    /*is_ambiguous_... S20643C4::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C5*), ABISELECT(2960,2128), "S20643C4");
    /*is_ambiguous_... S20643C4::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*), ABISELECT(3096,2240), "S20643C4");
    /*is_ambiguous_... S20643C8::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C8*), ABISELECT(3096,2240), "S20643C4");
    /*is_ambiguous_... S20643C9::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C9*)(S20643C8*), ABISELECT(3096,2240), "S20643C4");
    /*is_ambiguous_... S20643C5::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*)(S20643C8*), ABISELECT(3096,2240), "S20643C4");
    /*is_ambiguous_... S20643C4::S20643C9 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C9*), ABISELECT(3096,2240), "S20643C4");
    /*is_ambiguous_... S20643C4::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C5*), ABISELECT(2960,2128), "S20643C4");
    check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C7*), ABISELECT(8,4), "S20643C4");
    check_base_class_offset(lv, (S20643C6*)(S20643C7*), 0, "S20643C4");
    check_base_class_offset(lv, (S20643C7*), 0, "S20643C4");
    /*is_ambiguous_... S20643C4::S20643C6 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*), ABISELECT(3112,2248), "S20643C4");
    /*is_ambiguous_... S20643C4::S20643C6 */ AMB_check_base_class_offset(lv, (S20643C6*), ABISELECT(3104,2244), "S20643C4");
    /*is_ambiguous_... S20643C8::S20643C6 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C8*), ABISELECT(3104,2244), "S20643C4");
    check_base_class_offset(lv, (S20643C6*)(S20643C9*)(S20643C8*), ABISELECT(3104,2244), "S20643C4");
    /*is_ambiguous_... S20643C4::S20643C9 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C9*), ABISELECT(3104,2244), "S20643C4");
    check_base_class_offset(lv, (S20643C9*)(S20643C8*), ABISELECT(128,88), "S20643C4");
    check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*)(S20643C8*), ABISELECT(280,196), "S20643C4");
    check_base_class_offset(lv, (S20643C6*)(S20643C5*)(S20643C8*), ABISELECT(272,192), "S20643C4");
    check_base_class_offset(lv, (S20643C5*)(S20643C8*), ABISELECT(272,192), "S20643C4");
    check_base_class_offset(lv, (S20643C8*), ABISELECT(128,88), "S20643C4");
    /*is_ambiguous_... S20643C4::S20643C9 */ AMB_check_base_class_offset(lv, (S20643C9*), ABISELECT(688,520), "S20643C4");
    check_field_offset(lv, s20643c4f0, ABISELECT(832,624), "S20643C4.s20643c4f0");
    check_field_offset(lv, s20643c4f1, ABISELECT(848,632), "S20643C4.s20643c4f1");
    check_field_offset(lv, s20643c4f2, ABISELECT(864,644), "S20643C4.s20643c4f2");
    check_field_offset(lv, s20643c4f3, ABISELECT(2944,2124), "S20643C4.s20643c4f3");
    test_class_info(&lv, &cd_S20643C4);
    dp->~S20643C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20643C4(Test_S20643C4, "S20643C4", ABISELECT(3152,2284));

#else // __cplusplus

extern void _ZN8S20643C4C1Ev();
extern void _ZN8S20643C4D1Ev();
Name_Map name_map_S20643C4[] = {
  NSPAIR(_ZN8S20643C4C1Ev),
  NSPAIR(_ZN8S20643C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C7;
extern VTBL_ENTRY _ZTI8S20643C7[];
extern  VTBL_ENTRY _ZTV8S20643C7[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C9;
extern VTBL_ENTRY _ZTI8S20643C9[];
extern  VTBL_ENTRY _ZTV8S20643C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S20643C8;
extern VTBL_ENTRY _ZTI8S20643C8[];
extern  VTBL_ENTRY _ZTV8S20643C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C8[];
extern Class_Descriptor cd_S20643C9;
extern VTBL_ENTRY _ZTI8S20643C9[];
extern  VTBL_ENTRY _ZTV8S20643C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C9[];
static Base_Class bases_S20643C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C8_nt,    ABISELECT(2968,2132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(2960,2128), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(3096,2240), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20643C5,    ABISELECT(2960,2128), //bcp->offset
    29, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3216C8_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20643C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20643C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3216C8_nt,    ABISELECT(3112,2248), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(3104,2244), //bcp->offset
    38, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20643C9,    ABISELECT(128,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(280,196), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(272,192), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(272,192), //bcp->offset
    18, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20643C8,    ABISELECT(128,88), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20643C9,    ABISELECT(688,520), //bcp->offset
    24, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20643C4[];
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C4D1Ev();
extern void _ZN8S20643C4D0Ev();
extern void _ZN8S20643C72v5Ev();
extern void _ZN8S20643C42v8Ev();
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY vtc_S20643C4[] = {
  ABISELECT(3104,2244),
  ABISELECT(3096,2240),
  ABISELECT(2960,2128),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C4[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20643C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20643C4D0Ev,
  (VTBL_ENTRY)&_ZN8S20643C72v5Ev,
  (VTBL_ENTRY)&_ZN8S20643C42v8Ev,
  ABISELECT(2968,2152),
  ABISELECT(2976,2156),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S20643C4[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
  ABISELECT(2824,2048),
  ABISELECT(-272,-192),
  (VTBL_ENTRY)&(_ZTI8S20643C4[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  ABISELECT(2408,1720),
  ABISELECT(2416,1724),
  ABISELECT(-688,-520),
  (VTBL_ENTRY)&(_ZTI8S20643C4[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  0,
  0,
  0,
  ABISELECT(136,112),
  ABISELECT(-2960,-2128),
  (VTBL_ENTRY)&(_ZTI8S20643C4[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  0,
  0,
  0,
  ABISELECT(-3104,-2244),
  (VTBL_ENTRY)&(_ZTI8S20643C4[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern VTBL_ENTRY _ZTV8S20643C4[];
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C8__8S20643C4[] = {
  ABISELECT(2968,2152),
  ABISELECT(2976,2156),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C98S20643C8__8S20643C4[] = {
  ABISELECT(2968,2152),
  ABISELECT(2976,2156),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C98S20643C8__8S20643C4[] = {
  0,
  0,
  0,
  ABISELECT(-2976,-2156),
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C8__A1__8S20643C4[] = {
  ABISELECT(2824,2048),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C8__8S20643C4[] = {
  0,
  0,
  0,
  ABISELECT(-2976,-2156),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__8S20643C8__8S20643C4[] = {
  ABISELECT(2824,2048),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C9__A1__8S20643C4[] = {
  ABISELECT(2408,1720),
  ABISELECT(2416,1724),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C9__A1__8S20643C4[] = {
  0,
  0,
  0,
  ABISELECT(-2416,-1724),
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__8S20643C4[] = {
  ABISELECT(136,112),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
static  VTT_ENTRY vtt_S20643C4[] = {
  {&(_ZTV8S20643C4[5]),  5,46},
  {&(_tg__ZTV8S20643C8__8S20643C4[4]),  4,6},
  {&(_tg__ZTV8S20643C98S20643C8__8S20643C4[4]),  4,5},
  {&(_tg__ZTV8S20643C6__8S20643C98S20643C8__8S20643C4[5]),  5,8},
  {&(_tg__ZTV8S20643C58S20643C8__A1__8S20643C4[3]),  3,6},
  {&(_tg__ZTV8S20643C6__8S20643C8__8S20643C4[5]),  5,8},
  {&(_tg__ZTV8S20643C5__8S20643C8__8S20643C4[3]),  3,6},
  {&(_tg__ZTV8S20643C9__A1__8S20643C4[4]),  4,5},
  {&(_tg__ZTV8S20643C6__8S20643C9__A1__8S20643C4[5]),  5,8},
  {&(_ZTV8S20643C4[35]),  35,46},
  {&(_ZTV8S20643C4[43]),  43,46},
  {&(_ZTV8S20643C4[16]),  16,46},
  {&(_ZTV8S20643C4[21]),  21,46},
  {&(_ZTV8S20643C4[28]),  28,46},
  {&(_tg__ZTV8S20643C5__8S20643C4[3]),  3,6},
};
extern VTBL_ENTRY _ZTI8S20643C4[];
extern  VTBL_ENTRY _ZTV8S20643C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C4[];
Class_Descriptor cd_S20643C4 = {  "S20643C4", // class name
  bases_S20643C4, 15,
  &(vtc_S20643C4[0]), // expected_vtbl_contents
  &(vtt_S20643C4[0]), // expected_vtt_contents
  ABISELECT(3152,2284), // object size
  NSPAIRA(_ZTI8S20643C4),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S20643C4),46, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20643C4),15, //virtual table table var
  10, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20643C11  : virtual S3216C8_nt , virtual S20643C6 , virtual S20643C5 {
  void *s20643c11f0[2];
  int s20643c11f1;
  ::S20643C5 s20643c11f2[8];
  long double s20643c11f3[9];
  ~S20643C11(); // tgen
  S20643C11(); // tgen
};
//SIG(-1 S20643C11) C1{ VBC2{ m Fi} VBC3{ BC2 v1 v2 v3 FC2[3] FC2[2] Fp Fs FC2} VBC4{ BC3 VBC2 FD FL FC3 Fp Fs[3]} Fp[2] Fi FC4[8] FD[9]}


S20643C11 ::~S20643C11(){ note_dtor("S20643C11", this);} // tgen
S20643C11 ::S20643C11(){ note_ctor("S20643C11", this);} // tgen

static void Test_S20643C11()
{
  extern Class_Descriptor cd_S20643C11;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(97,303)];
    init_test(&cd_S20643C11, buf);
    S20643C11 *dp, &lv = *(dp=new (buf) S20643C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1536,1208), "sizeof(S20643C11)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20643C11)");
    /*is_ambiguous_... S20643C11::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*), ABISELECT(1328,1052), "S20643C11");
    /*is_ambiguous_... S20643C5::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*), ABISELECT(1328,1052), "S20643C11");
    /*is_ambiguous_... S20643C11::S20643C6 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*), ABISELECT(1344,1060), "S20643C11");
    /*is_ambiguous_... S20643C11::S20643C6 */ AMB_check_base_class_offset(lv, (S20643C6*), ABISELECT(1336,1056), "S20643C11");
    check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*), ABISELECT(1400,1100), "S20643C11");
    check_base_class_offset(lv, (S20643C6*)(S20643C5*), ABISELECT(1392,1096), "S20643C11");
    check_base_class_offset(lv, (S20643C5*), ABISELECT(1392,1096), "S20643C11");
    check_field_offset(lv, s20643c11f0, ABISELECT(8,4), "S20643C11.s20643c11f0");
    check_field_offset(lv, s20643c11f1, ABISELECT(24,12), "S20643C11.s20643c11f1");
    check_field_offset(lv, s20643c11f2, ABISELECT(32,16), "S20643C11.s20643c11f2");
    check_field_offset(lv, s20643c11f3, ABISELECT(1184,944), "S20643C11.s20643c11f3");
    test_class_info(&lv, &cd_S20643C11);
    dp->~S20643C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20643C11(Test_S20643C11, "S20643C11", ABISELECT(1536,1208));

#else // __cplusplus

extern void _ZN9S20643C11C1Ev();
extern void _ZN9S20643C11D1Ev();
Name_Map name_map_S20643C11[] = {
  NSPAIR(_ZN9S20643C11C1Ev),
  NSPAIR(_ZN9S20643C11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
static Base_Class bases_S20643C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C8_nt,    ABISELECT(1328,1052), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3216C8_nt,    ABISELECT(1344,1060), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(1336,1056), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3216C8_nt,    ABISELECT(1400,1100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(1392,1096), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(1392,1096), //bcp->offset
    13, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20643C11[];
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY vtc_S20643C11[] = {
  ABISELECT(1392,1096),
  ABISELECT(1336,1056),
  ABISELECT(1328,1052),
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
  0,
  0,
  0,
  ABISELECT(-1336,-1056),
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  0,
  0,
  0,
  ABISELECT(-64,-44),
  ABISELECT(-1392,-1096),
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern VTBL_ENTRY _ZTV9S20643C11[];
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__9S20643C11[] = {
  ABISELECT(-64,-44),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
static  VTT_ENTRY vtt_S20643C11[] = {
  {&(_ZTV9S20643C11[5]),  5,22},
  {&(_ZTV9S20643C11[10]),  10,22},
  {&(_ZTV9S20643C11[19]),  19,22},
  {&(_tg__ZTV8S20643C5__9S20643C11[3]),  3,6},
};
extern VTBL_ENTRY _ZTI9S20643C11[];
extern  VTBL_ENTRY _ZTV9S20643C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20643C11[];
Class_Descriptor cd_S20643C11 = {  "S20643C11", // class name
  bases_S20643C11, 6,
  &(vtc_S20643C11[0]), // expected_vtbl_contents
  &(vtt_S20643C11[0]), // expected_vtt_contents
  ABISELECT(1536,1208), // object size
  NSPAIRA(_ZTI9S20643C11),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S20643C11),22, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20643C11),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20643C10  : S20643C11 , S3216C8_nt , virtual S20643C8 , S20643C7 {
  int s20643c10f0;
  void *s20643c10f1;
  int s20643c10f2;
  virtual  ~S20643C10(); // _ZN9S20643C10D2Ev
  virtual void  v9(); // _ZN9S20643C102v9Ev
  S20643C10(); // tgen
};
//SIG(-1 S20643C10) C1{ BC2{ VBC3{ m Fi} VBC4{ BC3 v2 v3 v4 FC3[3] FC3[2] Fp Fs FC3} VBC5{ BC4 VBC3 FD FL FC4 Fp Fs[3]} Fp[2] Fi FC5[8] FD[9]} BC3 VBC6{ VBC4 VBC3 BC7{ VBC4 VBC3 v5 FC4 FD Fp[2] FC4} BC5 v6 Fp[2] Fl Fi FC4[5]} BC8{ BC4 vd v7 Fp[7] Fi[2] FL Fi} vd v1 Fi Fp Fi}


 S20643C10 ::~S20643C10(){ note_dtor("S20643C10", this);}
void  S20643C10 ::v9(){vfunc_called(this, "_ZN9S20643C102v9Ev");}
S20643C10 ::S20643C10(){ note_ctor("S20643C10", this);} // tgen

static void Test_S20643C10()
{
  extern Class_Descriptor cd_S20643C10;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(141,437)];
    init_test(&cd_S20643C10, buf);
    S20643C10 *dp, &lv = *(dp=new (buf) S20643C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2240,1744), "sizeof(S20643C10)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20643C10)");
    /*is_ambiguous_... S20643C11::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C11*), ABISELECT(1476,1156), "S20643C10");
    /*is_ambiguous_... S20643C10::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*), ABISELECT(1476,1156), "S20643C10");
    /*is_ambiguous_... S20643C8::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C8*), ABISELECT(1476,1156), "S20643C10");
    /*is_ambiguous_... S20643C9::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C9*)(S20643C8*), ABISELECT(1476,1156), "S20643C10");
    /*is_ambiguous_... S20643C5::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*)(S20643C8*), ABISELECT(1476,1156), "S20643C10");
    /*is_ambiguous_... S20643C10::S20643C6 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*), ABISELECT(1488,1164), "S20643C10");
    /*is_ambiguous_... S20643C11::S20643C6 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C11*), ABISELECT(1480,1160), "S20643C10");
    /*is_ambiguous_... S20643C8::S20643C6 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C8*), ABISELECT(1480,1160), "S20643C10");
    check_base_class_offset(lv, (S20643C6*)(S20643C9*)(S20643C8*), ABISELECT(1480,1160), "S20643C10");
    /*is_ambiguous_... S20643C10::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*), ABISELECT(1544,1204), "S20643C10");
    /*is_ambiguous_... S20643C10::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C5*), ABISELECT(1536,1200), "S20643C10");
    check_base_class_offset(lv, (S20643C5*)(S20643C11*), ABISELECT(1536,1200), "S20643C10");
    check_base_class_offset(lv, (S20643C11*), 0, "S20643C10");
    /*is_ambiguous_... S20643C10::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*), ABISELECT(1328,1052), "S20643C10");
    check_base_class_offset(lv, (S20643C9*)(S20643C8*), ABISELECT(1680,1312), "S20643C10");
    check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*)(S20643C8*), ABISELECT(1832,1420), "S20643C10");
    check_base_class_offset(lv, (S20643C6*)(S20643C5*)(S20643C8*), ABISELECT(1824,1416), "S20643C10");
    check_base_class_offset(lv, (S20643C5*)(S20643C8*), ABISELECT(1824,1416), "S20643C10");
    check_base_class_offset(lv, (S20643C8*), ABISELECT(1680,1312), "S20643C10");
    check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C7*), ABISELECT(1344,1060), "S20643C10");
    check_base_class_offset(lv, (S20643C6*)(S20643C7*), ABISELECT(1336,1056), "S20643C10");
    check_base_class_offset(lv, (S20643C7*), ABISELECT(1336,1056), "S20643C10");
    check_field_offset(lv, s20643c10f0, ABISELECT(1460,1144), "S20643C10.s20643c10f0");
    check_field_offset(lv, s20643c10f1, ABISELECT(1464,1148), "S20643C10.s20643c10f1");
    check_field_offset(lv, s20643c10f2, ABISELECT(1472,1152), "S20643C10.s20643c10f2");
    test_class_info(&lv, &cd_S20643C10);
    dp->~S20643C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20643C10(Test_S20643C10, "S20643C10", ABISELECT(2240,1744));

#else // __cplusplus

extern void _ZN9S20643C10C1Ev();
extern void _ZN9S20643C10D2Ev();
Name_Map name_map_S20643C10[] = {
  NSPAIR(_ZN9S20643C10C1Ev),
  NSPAIR(_ZN9S20643C10D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S20643C11;
extern VTBL_ENTRY _ZTI9S20643C11[];
extern  VTBL_ENTRY _ZTV9S20643C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20643C11[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C9;
extern VTBL_ENTRY _ZTI8S20643C9[];
extern  VTBL_ENTRY _ZTV8S20643C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S20643C8;
extern VTBL_ENTRY _ZTI8S20643C8[];
extern  VTBL_ENTRY _ZTV8S20643C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C8[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C7;
extern VTBL_ENTRY _ZTI8S20643C7[];
extern  VTBL_ENTRY _ZTV8S20643C7[];
static Base_Class bases_S20643C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C8_nt,    ABISELECT(1476,1156), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S3216C8_nt,    ABISELECT(1488,1164), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(1480,1160), //bcp->offset
    17, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S3216C8_nt,    ABISELECT(1544,1204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(1536,1200), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(1536,1200), //bcp->offset
    25, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20643C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3216C8_nt,    ABISELECT(1328,1052), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20643C9,    ABISELECT(1680,1312), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(1832,1420), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(1824,1416), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(1824,1416), //bcp->offset
    45, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20643C8,    ABISELECT(1680,1312), //bcp->offset
    34, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3216C8_nt,    ABISELECT(1344,1060), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(1336,1056), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20643C7,    ABISELECT(1336,1056), //bcp->offset
    9, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20643C10[];
extern void _ZN9S20643C10D1Ev();
extern void _ZN9S20643C10D0Ev();
extern void _ZN9S20643C102v9Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void ABISELECT(_ZThn1336_N9S20643C10D1Ev,_ZThn1056_N9S20643C10D1Ev)();
extern void ABISELECT(_ZThn1336_N9S20643C10D0Ev,_ZThn1056_N9S20643C10D0Ev)();
extern void _ZN8S20643C72v5Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY vtc_S20643C10[] = {
  ABISELECT(1680,1312),
  ABISELECT(1536,1200),
  ABISELECT(1480,1160),
  ABISELECT(1476,1156),
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN9S20643C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20643C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20643C102v9Ev,
  ABISELECT(-1336,-1056),
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn1336_N9S20643C10D1Ev,_ZThn1056_N9S20643C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1336_N9S20643C10D0Ev,_ZThn1056_N9S20643C10D0Ev),
  (VTBL_ENTRY)&_ZN8S20643C72v5Ev,
  0,
  0,
  0,
  ABISELECT(-1480,-1160),
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  0,
  0,
  0,
  ABISELECT(-60,-44),
  ABISELECT(-1536,-1200),
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  ABISELECT(144,104),
  ABISELECT(144,104),
  ABISELECT(144,104),
  0,
  0,
  ABISELECT(-204,-156),
  ABISELECT(-200,-152),
  ABISELECT(-1680,-1312),
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
  ABISELECT(-348,-260),
  ABISELECT(-1824,-1416),
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern VTBL_ENTRY _ZTV9S20643C10[];
static  VTBL_ENTRY _tg__ZTV9S20643C11__9S20643C10[] = {
  ABISELECT(1536,1200),
  ABISELECT(1480,1160),
  ABISELECT(1476,1156),
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__9S20643C11__9S20643C10[] = {
  0,
  0,
  0,
  ABISELECT(-1480,-1160),
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__9S20643C11__9S20643C10[] = {
  0,
  0,
  0,
  ABISELECT(-60,-44),
  ABISELECT(-1536,-1200),
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__9S20643C10[] = {
  ABISELECT(-60,-44),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C8__9S20643C10[] = {
  ABISELECT(-204,-156),
  ABISELECT(-200,-152),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C98S20643C8__9S20643C10[] = {
  ABISELECT(-204,-156),
  ABISELECT(-200,-152),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C98S20643C8__9S20643C10[] = {
  0,
  0,
  0,
  ABISELECT(200,152),
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C8__A1__9S20643C10[] = {
  ABISELECT(-348,-260),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C8__9S20643C10[] = {
  0,
  0,
  0,
  ABISELECT(200,152),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__8S20643C8__9S20643C10[] = {
  ABISELECT(-348,-260),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
static  VTT_ENTRY vtt_S20643C10[] = {
  {&(_ZTV9S20643C10[6]),  6,51},
  {&(_tg__ZTV9S20643C11__9S20643C10[5]),  5,5},
  {&(_tg__ZTV8S20643C6__9S20643C11__9S20643C10[5]),  5,8},
  {&(_tg__ZTV8S20643C5__9S20643C11__9S20643C10[6]),  6,9},
  {&(_ZTV9S20643C10[22]),  22,51},
  {&(_ZTV9S20643C10[31]),  31,51},
  {&(_ZTV9S20643C10[43]),  43,51},
  {&(_ZTV9S20643C10[48]),  48,51},
  {&(_tg__ZTV8S20643C5__9S20643C10[3]),  3,6},
  {&(_tg__ZTV8S20643C8__9S20643C10[4]),  4,6},
  {&(_tg__ZTV8S20643C98S20643C8__9S20643C10[4]),  4,5},
  {&(_tg__ZTV8S20643C6__8S20643C98S20643C8__9S20643C10[5]),  5,8},
  {&(_tg__ZTV8S20643C58S20643C8__A1__9S20643C10[3]),  3,6},
  {&(_tg__ZTV8S20643C6__8S20643C8__9S20643C10[5]),  5,8},
  {&(_tg__ZTV8S20643C5__8S20643C8__9S20643C10[3]),  3,6},
};
extern VTBL_ENTRY _ZTI9S20643C10[];
extern  VTBL_ENTRY _ZTV9S20643C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20643C10[];
Class_Descriptor cd_S20643C10 = {  "S20643C10", // class name
  bases_S20643C10, 16,
  &(vtc_S20643C10[0]), // expected_vtbl_contents
  &(vtt_S20643C10[0]), // expected_vtt_contents
  ABISELECT(2240,1744), // object size
  NSPAIRA(_ZTI9S20643C10),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S20643C10),51, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20643C10),15, //virtual table table var
  10, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20643C2  : virtual S3216C8_nt , S20643C4 , S20643C5 , virtual S20643C10 , S20643C11 {
  int s20643c2f0[2];
  void *s20643c2f1;
  char s20643c2f2:3;
  int s20643c2f3[3];
  virtual  ~S20643C2(); // _ZN8S20643C2D2Ev
  virtual void  v10(); // _ZN8S20643C23v10Ev
  virtual void  v11(); // _ZN8S20643C23v11Ev
  S20643C2(); // tgen
};
//SIG(-1 S20643C2) C1{ VBC2{ m Fi} BC3{ VBC4{ BC5{ BC2 v3 v4 v5 FC2[3] FC2[2] Fp Fs FC2} VBC2 FD FL FC5 Fp Fs[3]} BC6{ BC5 vd v6 Fp[7] Fi[2] FL Fi} VBC5 BC7{ VBC5 VBC2 BC8{ VBC5 VBC2 v7 FC5 FD Fp[2] FC5} BC4 v8 Fp[2] Fl Fi FC5[5]} BC8 v9 Fi[2] FD FC8[10] Fi} BC4 VBC9{ BC10{ VBC2 VBC5 VBC4 Fp[2] Fi FC4[8] FD[9]} BC2 VBC7 BC6 vd v10 Fi Fp Fi} BC10 vd v1 v2 Fi[2] Fp Fc:3 Fi[3]}


 S20643C2 ::~S20643C2(){ note_dtor("S20643C2", this);}
void  S20643C2 ::v10(){vfunc_called(this, "_ZN8S20643C23v10Ev");}
void  S20643C2 ::v11(){vfunc_called(this, "_ZN8S20643C23v11Ev");}
S20643C2 ::S20643C2(){ note_ctor("S20643C2", this);} // tgen

static void Test_S20643C2()
{
  extern Class_Descriptor cd_S20643C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(421,1267)];
    init_test(&cd_S20643C2, buf);
    S20643C2 *dp, &lv = *(dp=new (buf) S20643C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(6720,5064), "sizeof(S20643C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20643C2)");
    /*is_ambiguous_... S20643C2::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*), ABISELECT(4464,3320), "S20643C2");
    /*is_ambiguous_... S20643C2::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*), ABISELECT(4464,3320), "S20643C2");
    /*is_ambiguous_... S20643C8::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C8*)(S20643C4*), ABISELECT(4464,3320), "S20643C2");
    /*is_ambiguous_... S20643C9::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C9*)(S20643C8*)(S20643C4*), ABISELECT(4464,3320), "S20643C2");
    /*is_ambiguous_... S20643C5::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*)(S20643C8*)(S20643C4*), ABISELECT(4464,3320), "S20643C2");
    /*is_ambiguous_... S20643C4::S20643C9 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C9*)(S20643C4*), ABISELECT(4464,3320), "S20643C2");
    /*is_ambiguous_... S20643C2::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*), ABISELECT(4464,3320), "S20643C2");
    /*is_ambiguous_... S20643C11::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C11*)(S20643C10*), ABISELECT(4464,3320), "S20643C2");
    /*is_ambiguous_... S20643C2::S20643C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C8*), ABISELECT(4464,3320), "S20643C2");
    /*is_ambiguous_... S20643C2::S20643C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C9*)(S20643C8*), ABISELECT(4464,3320), "S20643C2");
    /*is_ambiguous_... S20643C2::S20643C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*)(S20643C8*), ABISELECT(4464,3320), "S20643C2");
    /*is_ambiguous_... S20643C2::S20643C11 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C11*), ABISELECT(4464,3320), "S20643C2");
    /*is_ambiguous_... S20643C2::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*), ABISELECT(4488,3328), "S20643C2");
    /*is_ambiguous_... S20643C2::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C5*), ABISELECT(4480,3324), "S20643C2");
    /*is_ambiguous_... S20643C4::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C5*)(S20643C4*), ABISELECT(4480,3324), "S20643C2");
    check_base_class_offset(lv, (S20643C5*)(S20643C11*)(S20643C10*), ABISELECT(4480,3324), "S20643C2");
    /*is_ambiguous_... S20643C2::S20643C11 */ AMB_check_base_class_offset(lv, (S20643C5*)(S20643C11*), ABISELECT(4480,3324), "S20643C2");
    check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C7*)(S20643C4*), ABISELECT(8,4), "S20643C2");
    check_base_class_offset(lv, (S20643C6*)(S20643C7*)(S20643C4*), 0, "S20643C2");
    check_base_class_offset(lv, (S20643C7*)(S20643C4*), 0, "S20643C2");
    /*is_ambiguous_... S20643C2::S20643C6 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*), ABISELECT(4624,3440), "S20643C2");
    /*is_ambiguous_... S20643C4::S20643C6 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C4*), ABISELECT(4616,3436), "S20643C2");
    /*is_ambiguous_... S20643C8::S20643C6 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C8*)(S20643C4*), ABISELECT(4616,3436), "S20643C2");
    check_base_class_offset(lv, (S20643C6*)(S20643C9*)(S20643C8*)(S20643C4*), ABISELECT(4616,3436), "S20643C2");
    /*is_ambiguous_... S20643C4::S20643C9 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C9*)(S20643C4*), ABISELECT(4616,3436), "S20643C2");
    /*is_ambiguous_... S20643C11::S20643C6 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C11*)(S20643C10*), ABISELECT(4616,3436), "S20643C2");
    /*is_ambiguous_... S20643C2::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C8*), ABISELECT(4616,3436), "S20643C2");
    /*is_ambiguous_... S20643C2::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C9*)(S20643C8*), ABISELECT(4616,3436), "S20643C2");
    /*is_ambiguous_... S20643C2::S20643C11 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C11*), ABISELECT(4616,3436), "S20643C2");
    check_base_class_offset(lv, (S20643C9*)(S20643C8*)(S20643C4*), ABISELECT(128,88), "S20643C2");
    check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*)(S20643C8*)(S20643C4*), ABISELECT(280,196), "S20643C2");
    check_base_class_offset(lv, (S20643C6*)(S20643C5*)(S20643C8*)(S20643C4*), ABISELECT(272,192), "S20643C2");
    check_base_class_offset(lv, (S20643C5*)(S20643C8*)(S20643C4*), ABISELECT(272,192), "S20643C2");
    check_base_class_offset(lv, (S20643C8*)(S20643C4*), ABISELECT(128,88), "S20643C2");
    /*is_ambiguous_... S20643C4::S20643C9 */ AMB_check_base_class_offset(lv, (S20643C9*)(S20643C4*), ABISELECT(688,520), "S20643C2");
    check_base_class_offset(lv, (S20643C4*), 0, "S20643C2");
    /*is_ambiguous_... S20643C2::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*), ABISELECT(2968,2132), "S20643C2");
    /*is_ambiguous_... S20643C2::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C5*), ABISELECT(2960,2128), "S20643C2");
    /*is_ambiguous_... S20643C2::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C5*), ABISELECT(2960,2128), "S20643C2");
    check_base_class_offset(lv, (S20643C11*)(S20643C10*), ABISELECT(4672,3476), "S20643C2");
    /*is_ambiguous_... S20643C10::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C10*), ABISELECT(6000,4528), "S20643C2");
    /*is_ambiguous_... S20643C2::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C9*)(S20643C8*), ABISELECT(6160,4632), "S20643C2");
    /*is_ambiguous_... S20643C2::S20643C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*)(S20643C8*), ABISELECT(6312,4740), "S20643C2");
    /*is_ambiguous_... S20643C2::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C5*)(S20643C8*), ABISELECT(6304,4736), "S20643C2");
    /*is_ambiguous_... S20643C2::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C5*)(S20643C8*), ABISELECT(6304,4736), "S20643C2");
    check_base_class_offset(lv, (S20643C8*)(S20643C10*), ABISELECT(6160,4632), "S20643C2");
    check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C7*)(S20643C10*), ABISELECT(6016,4536), "S20643C2");
    check_base_class_offset(lv, (S20643C6*)(S20643C7*)(S20643C10*), ABISELECT(6008,4532), "S20643C2");
    check_base_class_offset(lv, (S20643C7*)(S20643C10*), ABISELECT(6008,4532), "S20643C2");
    check_base_class_offset(lv, (S20643C10*), ABISELECT(4672,3476), "S20643C2");
    /*is_ambiguous_... S20643C2::S20643C11 */ AMB_check_base_class_offset(lv, (S20643C11*), ABISELECT(3104,2240), "S20643C2");
    check_field_offset(lv, s20643c2f0, ABISELECT(4432,3292), "S20643C2.s20643c2f0");
    check_field_offset(lv, s20643c2f1, ABISELECT(4440,3300), "S20643C2.s20643c2f1");
    set_bf_and_test(lv, s20643c2f2, ABISELECT(4448,3304), 0, 3, 1, "S20643C2");
    set_bf_and_test(lv, s20643c2f2, ABISELECT(4448,3304), 0, 3, hide_sll(1LL<<2), "S20643C2");
    check_field_offset(lv, s20643c2f3, ABISELECT(4452,3308), "S20643C2.s20643c2f3");
    test_class_info(&lv, &cd_S20643C2);
    dp->~S20643C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20643C2(Test_S20643C2, "S20643C2", ABISELECT(6720,5064));

#else // __cplusplus

extern void _ZN8S20643C2C1Ev();
extern void _ZN8S20643C2D2Ev();
Name_Map name_map_S20643C2[] = {
  NSPAIR(_ZN8S20643C2C1Ev),
  NSPAIR(_ZN8S20643C2D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C7;
extern VTBL_ENTRY _ZTI8S20643C7[];
extern  VTBL_ENTRY _ZTV8S20643C7[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C9;
extern VTBL_ENTRY _ZTI8S20643C9[];
extern  VTBL_ENTRY _ZTV8S20643C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S20643C8;
extern VTBL_ENTRY _ZTI8S20643C8[];
extern  VTBL_ENTRY _ZTV8S20643C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C8[];
extern Class_Descriptor cd_S20643C9;
extern VTBL_ENTRY _ZTI8S20643C9[];
extern  VTBL_ENTRY _ZTV8S20643C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C9[];
extern Class_Descriptor cd_S20643C4;
extern VTBL_ENTRY _ZTI8S20643C4[];
extern  VTBL_ENTRY _ZTV8S20643C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C4[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S20643C11;
extern VTBL_ENTRY _ZTI9S20643C11[];
extern  VTBL_ENTRY _ZTV9S20643C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20643C11[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C9;
extern VTBL_ENTRY _ZTI8S20643C9[];
extern  VTBL_ENTRY _ZTV8S20643C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S20643C8;
extern VTBL_ENTRY _ZTI8S20643C8[];
extern  VTBL_ENTRY _ZTV8S20643C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C8[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C7;
extern VTBL_ENTRY _ZTI8S20643C7[];
extern  VTBL_ENTRY _ZTV8S20643C7[];
extern Class_Descriptor cd_S20643C10;
extern VTBL_ENTRY _ZTI9S20643C10[];
extern  VTBL_ENTRY _ZTV9S20643C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20643C10[];
extern Class_Descriptor cd_S20643C11;
extern VTBL_ENTRY _ZTI9S20643C11[];
extern  VTBL_ENTRY _ZTV9S20643C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20643C11[];
static Base_Class bases_S20643C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C8_nt,    ABISELECT(4464,3320), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3216C8_nt,    ABISELECT(4488,3328), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(4480,3324), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(4480,3324), //bcp->offset
    44, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    15, //immediately_derived
  0, 1},
  {&cd_S3216C8_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20643C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20643C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(4624,3440), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(4616,3436), //bcp->offset
    53, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S20643C9,    ABISELECT(128,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(280,196), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(272,192), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(272,192), //bcp->offset
    22, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20643C8,    ABISELECT(128,88), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20643C9,    ABISELECT(688,520), //bcp->offset
    28, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20643C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3216C8_nt,    ABISELECT(2968,2132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(2960,2128), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(2960,2128), //bcp->offset
    33, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20643C11,    ABISELECT(4672,3476), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(6000,4528), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S20643C9,    ABISELECT(6160,4632), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    41, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(6312,4740), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(6304,4736), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(6304,4736), //bcp->offset
    95, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    43, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S20643C8,    ABISELECT(6160,4632), //bcp->offset
    84, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    29, //immediately_derived
  0, 1},
  {&cd_S3216C8_nt,    ABISELECT(6016,4536), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(6008,4532), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S20643C7,    ABISELECT(6008,4532), //bcp->offset
    76, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S20643C10,    ABISELECT(4672,3476), //bcp->offset
    61, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20643C11,    ABISELECT(3104,2240), //bcp->offset
    39, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20643C2[];
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C2D1Ev();
extern void _ZN8S20643C2D0Ev();
extern void _ZN8S20643C72v5Ev();
extern void _ZN8S20643C42v8Ev();
extern void _ZN8S20643C23v10Ev();
extern void _ZN8S20643C23v11Ev();
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void ABISELECT(_ZTv0_n56_N8S20643C2D1Ev,_ZTv0_n28_N8S20643C2D1Ev)();
extern void ABISELECT(_ZThn4672_N8S20643C2D1Ev,_ZThn3476_N8S20643C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S20643C2D0Ev,_ZTv0_n28_N8S20643C2D0Ev)();
extern void ABISELECT(_ZThn4672_N8S20643C2D0Ev,_ZThn3476_N8S20643C2D0Ev)() __attribute__((weak));
extern void _ZN9S20643C102v9Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void ABISELECT(_ZTvn1336_n56_N8S20643C2D1Ev,_ZTvn1056_n28_N8S20643C2D1Ev)();
extern void ABISELECT(_ZTvn1336_n56_N8S20643C2D0Ev,_ZTvn1056_n28_N8S20643C2D0Ev)();
extern void _ZN8S20643C72v5Ev();
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY vtc_S20643C2[] = {
  ABISELECT(6160,4632),
  ABISELECT(4672,3476),
  ABISELECT(4616,3436),
  ABISELECT(4464,3320),
  ABISELECT(4480,3324),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C2[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20643C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20643C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20643C72v5Ev,
  (VTBL_ENTRY)&_ZN8S20643C42v8Ev,
  (VTBL_ENTRY)&_ZN8S20643C23v10Ev,
  (VTBL_ENTRY)&_ZN8S20643C23v11Ev,
  ABISELECT(4336,3232),
  ABISELECT(4488,3348),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S20643C2[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
  ABISELECT(4192,3128),
  ABISELECT(-272,-192),
  (VTBL_ENTRY)&(_ZTI8S20643C2[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  ABISELECT(3776,2800),
  ABISELECT(3928,2916),
  ABISELECT(-688,-520),
  (VTBL_ENTRY)&(_ZTI8S20643C2[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  ABISELECT(1504,1192),
  ABISELECT(-2960,-2128),
  (VTBL_ENTRY)&(_ZTI8S20643C2[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  ABISELECT(1376,1084),
  ABISELECT(1512,1196),
  ABISELECT(1360,1080),
  ABISELECT(-3104,-2240),
  (VTBL_ENTRY)&(_ZTI8S20643C2[0]),
  0,
  0,
  0,
  ABISELECT(-16,-4),
  ABISELECT(-4480,-3324),
  (VTBL_ENTRY)&(_ZTI8S20643C2[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  0,
  0,
  0,
  ABISELECT(-4616,-3436),
  (VTBL_ENTRY)&(_ZTI8S20643C2[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  0,
  ABISELECT(-4672,-3476),
  ABISELECT(1488,1156),
  ABISELECT(-192,-152),
  ABISELECT(-56,-40),
  ABISELECT(-208,-156),
  ABISELECT(-4672,-3476),
  (VTBL_ENTRY)&(_ZTI8S20643C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S20643C2D1Ev,_ZTv0_n28_N8S20643C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S20643C2D0Ev,_ZTv0_n28_N8S20643C2D0Ev),
  (VTBL_ENTRY)&_ZN9S20643C102v9Ev,
  ABISELECT(-6008,-4532),
  (VTBL_ENTRY)&(_ZTI8S20643C2[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn1336_n56_N8S20643C2D1Ev,_ZTvn1056_n28_N8S20643C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1336_n56_N8S20643C2D0Ev,_ZTvn1056_n28_N8S20643C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20643C72v5Ev,
  ABISELECT(144,104),
  ABISELECT(144,104),
  ABISELECT(144,104),
  0,
  0,
  ABISELECT(-1696,-1312),
  ABISELECT(-1544,-1196),
  ABISELECT(-6160,-4632),
  (VTBL_ENTRY)&(_ZTI8S20643C2[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
  ABISELECT(-1840,-1416),
  ABISELECT(-6304,-4736),
  (VTBL_ENTRY)&(_ZTI8S20643C2[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern VTBL_ENTRY _ZTV8S20643C2[];
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C4D1Ev();
extern void _ZN8S20643C4D0Ev();
extern void _ZN8S20643C72v5Ev();
extern void _ZN8S20643C42v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C4__8S20643C2[] = {
  ABISELECT(4616,3436),
  ABISELECT(4464,3320),
  ABISELECT(4480,3324),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C4[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20643C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20643C4D0Ev,
  (VTBL_ENTRY)&_ZN8S20643C72v5Ev,
  (VTBL_ENTRY)&_ZN8S20643C42v8Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C88S20643C4__8S20643C2[] = {
  ABISELECT(4336,3232),
  ABISELECT(4488,3348),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C98S20643C88S20643C4__8S20643C2[] = {
  ABISELECT(4336,3232),
  ABISELECT(4488,3348),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C98S20643C88S20643C4__8S20643C2[] = {
  0,
  0,
  0,
  ABISELECT(-4488,-3348),
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C88S20643C4__A1__8S20643C2[] = {
  ABISELECT(4192,3128),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C88S20643C4__8S20643C2[] = {
  0,
  0,
  0,
  ABISELECT(-4488,-3348),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__8S20643C88S20643C4__8S20643C2[] = {
  ABISELECT(4192,3128),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C98S20643C4__A1__8S20643C2[] = {
  ABISELECT(3776,2800),
  ABISELECT(3928,2916),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C98S20643C4__A1__8S20643C2[] = {
  0,
  0,
  0,
  ABISELECT(-3928,-2916),
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__8S20643C4__8S20643C2[] = {
  0,
  0,
  0,
  ABISELECT(-16,-4),
  ABISELECT(-4480,-3324),
  (VTBL_ENTRY)&(_ZTI8S20643C4[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__A2__8S20643C4__8S20643C2[] = {
  0,
  0,
  0,
  ABISELECT(-4616,-3436),
  (VTBL_ENTRY)&(_ZTI8S20643C4[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C8__8S20643C4__8S20643C2[] = {
  ABISELECT(4336,3232),
  ABISELECT(4488,3348),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S20643C4[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C8__A1__8S20643C4__8S20643C2[] = {
  ABISELECT(4192,3128),
  ABISELECT(-272,-192),
  (VTBL_ENTRY)&(_ZTI8S20643C4[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C9__A1__8S20643C4__8S20643C2[] = {
  ABISELECT(3776,2800),
  ABISELECT(3928,2916),
  ABISELECT(-688,-520),
  (VTBL_ENTRY)&(_ZTI8S20643C4[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__A__8S20643C2[] = {
  ABISELECT(1504,1192),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20643C11__A1__8S20643C2[] = {
  ABISELECT(1376,1084),
  ABISELECT(1512,1196),
  ABISELECT(1360,1080),
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__9S20643C11__A1__8S20643C2[] = {
  0,
  0,
  0,
  ABISELECT(-1512,-1196),
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__9S20643C11__A1__8S20643C2[] = {
  0,
  0,
  0,
  ABISELECT(-16,-4),
  ABISELECT(-1376,-1084),
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__8S20643C2[] = {
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN9S20643C10D1Ev();
extern void _ZN9S20643C10D0Ev();
extern void _ZN9S20643C102v9Ev();
static  VTBL_ENTRY _tg__ZTV9S20643C10__8S20643C2[] = {
  ABISELECT(1488,1156),
  ABISELECT(-192,-152),
  ABISELECT(-56,-40),
  ABISELECT(-208,-156),
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN9S20643C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20643C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20643C102v9Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20643C119S20643C10__8S20643C2[] = {
  ABISELECT(-192,-152),
  ABISELECT(-56,-40),
  ABISELECT(-208,-156),
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__9S20643C119S20643C10__8S20643C2[] = {
  0,
  0,
  0,
  ABISELECT(56,40),
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__9S20643C119S20643C10__8S20643C2[] = {
  0,
  0,
  0,
  ABISELECT(-16,-4),
  ABISELECT(192,152),
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__9S20643C10__8S20643C2[] = {
  0,
  0,
  0,
  ABISELECT(56,40),
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__9S20643C10__8S20643C2[] = {
  0,
  0,
  0,
  ABISELECT(-16,-4),
  ABISELECT(192,152),
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C8__9S20643C10__8S20643C2[] = {
  ABISELECT(144,104),
  ABISELECT(144,104),
  ABISELECT(144,104),
  0,
  0,
  ABISELECT(-1696,-1312),
  ABISELECT(-1544,-1196),
  ABISELECT(-1488,-1156),
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C8__A1__9S20643C10__8S20643C2[] = {
  ABISELECT(-1840,-1416),
  ABISELECT(-1632,-1260),
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C8__A1__8S20643C2[] = {
  ABISELECT(-1696,-1312),
  ABISELECT(-1544,-1196),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C98S20643C8__A2__8S20643C2[] = {
  ABISELECT(-1696,-1312),
  ABISELECT(-1544,-1196),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C98S20643C8__A2__8S20643C2[] = {
  0,
  0,
  0,
  ABISELECT(1544,1196),
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C8__A3__8S20643C2[] = {
  ABISELECT(-1840,-1416),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C8__A1__8S20643C2[] = {
  0,
  0,
  0,
  ABISELECT(1544,1196),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__8S20643C8__A1__8S20643C2[] = {
  ABISELECT(-1840,-1416),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
static  VTT_ENTRY vtt_S20643C2[] = {
  {&(_ZTV8S20643C2[7]),  7,101},
  {&(_tg__ZTV8S20643C4__8S20643C2[5]),  5,12},
  {&(_tg__ZTV8S20643C88S20643C4__8S20643C2[4]),  4,6},
  {&(_tg__ZTV8S20643C98S20643C88S20643C4__8S20643C2[4]),  4,5},
  {&(_tg__ZTV8S20643C6__8S20643C98S20643C88S20643C4__8S20643C2[5]),  5,8},
  {&(_tg__ZTV8S20643C58S20643C88S20643C4__A1__8S20643C2[3]),  3,6},
  {&(_tg__ZTV8S20643C6__8S20643C88S20643C4__8S20643C2[5]),  5,8},
  {&(_tg__ZTV8S20643C5__8S20643C88S20643C4__8S20643C2[3]),  3,6},
  {&(_tg__ZTV8S20643C98S20643C4__A1__8S20643C2[4]),  4,5},
  {&(_tg__ZTV8S20643C6__8S20643C98S20643C4__A1__8S20643C2[5]),  5,8},
  {&(_tg__ZTV8S20643C5__8S20643C4__8S20643C2[6]),  6,9},
  {&(_tg__ZTV8S20643C6__A2__8S20643C4__8S20643C2[5]),  5,8},
  {&(_tg__ZTV8S20643C8__8S20643C4__8S20643C2[4]),  4,6},
  {&(_tg__ZTV8S20643C58S20643C8__A1__8S20643C4__8S20643C2[3]),  3,6},
  {&(_tg__ZTV8S20643C9__A1__8S20643C4__8S20643C2[4]),  4,5},
  {&(_tg__ZTV8S20643C5__A__8S20643C2[3]),  3,6},
  {&(_tg__ZTV9S20643C11__A1__8S20643C2[5]),  5,5},
  {&(_tg__ZTV8S20643C6__9S20643C11__A1__8S20643C2[5]),  5,8},
  {&(_tg__ZTV8S20643C5__9S20643C11__A1__8S20643C2[6]),  6,9},
  {&(_ZTV8S20643C2[50]),  50,101},
  {&(_ZTV8S20643C2[58]),  58,101},
  {&(_ZTV8S20643C2[20]),  20,101},
  {&(_ZTV8S20643C2[25]),  25,101},
  {&(_ZTV8S20643C2[32]),  32,101},
  {&(_ZTV8S20643C2[36]),  36,101},
  {&(_ZTV8S20643C2[73]),  73,101},
  {&(_ZTV8S20643C2[93]),  93,101},
  {&(_ZTV8S20643C2[98]),  98,101},
  {&(_ZTV8S20643C2[78]),  78,101},
  {&(_ZTV8S20643C2[44]),  44,101},
  {&(_tg__ZTV8S20643C5__8S20643C2[3]),  3,6},
  {&(_tg__ZTV9S20643C10__8S20643C2[6]),  6,9},
  {&(_tg__ZTV9S20643C119S20643C10__8S20643C2[5]),  5,5},
  {&(_tg__ZTV8S20643C6__9S20643C119S20643C10__8S20643C2[5]),  5,8},
  {&(_tg__ZTV8S20643C5__9S20643C119S20643C10__8S20643C2[6]),  6,9},
  {&(_tg__ZTV8S20643C6__9S20643C10__8S20643C2[5]),  5,8},
  {&(_tg__ZTV8S20643C5__9S20643C10__8S20643C2[6]),  6,9},
  {&(_tg__ZTV8S20643C8__9S20643C10__8S20643C2[9]),  9,11},
  {&(_tg__ZTV8S20643C58S20643C8__A1__9S20643C10__8S20643C2[3]),  3,6},
  {&(_tg__ZTV8S20643C8__A1__8S20643C2[4]),  4,6},
  {&(_tg__ZTV8S20643C98S20643C8__A2__8S20643C2[4]),  4,5},
  {&(_tg__ZTV8S20643C6__8S20643C98S20643C8__A2__8S20643C2[5]),  5,8},
  {&(_tg__ZTV8S20643C58S20643C8__A3__8S20643C2[3]),  3,6},
  {&(_tg__ZTV8S20643C6__8S20643C8__A1__8S20643C2[5]),  5,8},
  {&(_tg__ZTV8S20643C5__8S20643C8__A1__8S20643C2[3]),  3,6},
};
extern VTBL_ENTRY _ZTI8S20643C2[];
extern  VTBL_ENTRY _ZTV8S20643C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C2[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S20643C2D0Ev,_ZTv0_n28_N8S20643C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4672_N8S20643C2D0Ev,_ZThn3476_N8S20643C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S20643C2D1Ev,_ZTv0_n28_N8S20643C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4672_N8S20643C2D1Ev,_ZThn3476_N8S20643C2D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20643C2 = {  "S20643C2", // class name
  bases_S20643C2, 31,
  &(vtc_S20643C2[0]), // expected_vtbl_contents
  &(vtt_S20643C2[0]), // expected_vtt_contents
  ABISELECT(6720,5064), // object size
  NSPAIRA(_ZTI8S20643C2),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S20643C2),101, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20643C2),45, //virtual table table var
  22, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20643C13  {
  void *s20643c13f0[7];
  ::S20643C9 s20643c13f1;
  long double s20643c13f2;
  int s20643c13f3;
  __tsi64 s20643c13f4;
  void *s20643c13f5;
  ::S20643C9 s20643c13f6;
  void *s20643c13f7[5];
  int s20643c13f8[8];
  void *s20643c13f9;
  virtual void  v12(); // _ZN9S20643C133v12Ev
  ~S20643C13(); // tgen
  S20643C13(); // tgen
};
//SIG(-1 S20643C13) C1{ v1 Fp[7] FC2{ VBC3{ BC4{ m Fi} v3 v4 v5 FC4[3] FC4[2] Fp Fs FC4} VBC4 v2 FC3 FD Fp[2] FC3} FD Fi FL Fp FC2 Fp[5] Fi[8] Fp}


void  S20643C13 ::v12(){vfunc_called(this, "_ZN9S20643C133v12Ev");}
S20643C13 ::~S20643C13(){ note_dtor("S20643C13", this);} // tgen
S20643C13 ::S20643C13(){ note_ctor("S20643C13", this);} // tgen

static void Test_S20643C13()
{
  extern Class_Descriptor cd_S20643C13;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(39,104)];
    init_test(&cd_S20643C13, buf);
    S20643C13 *dp, &lv = *(dp=new (buf) S20643C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(608,412), "sizeof(S20643C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20643C13)");
    check_field_offset(lv, s20643c13f0, ABISELECT(8,4), "S20643C13.s20643c13f0");
    check_field_offset(lv, s20643c13f1, ABISELECT(64,32), "S20643C13.s20643c13f1");
    check_field_offset(lv, s20643c13f2, ABISELECT(272,180), "S20643C13.s20643c13f2");
    check_field_offset(lv, s20643c13f3, ABISELECT(288,192), "S20643C13.s20643c13f3");
    check_field_offset(lv, s20643c13f4, ABISELECT(296,196), "S20643C13.s20643c13f4");
    check_field_offset(lv, s20643c13f5, ABISELECT(304,204), "S20643C13.s20643c13f5");
    check_field_offset(lv, s20643c13f6, ABISELECT(320,208), "S20643C13.s20643c13f6");
    check_field_offset(lv, s20643c13f7, ABISELECT(528,356), "S20643C13.s20643c13f7");
    check_field_offset(lv, s20643c13f8, ABISELECT(568,376), "S20643C13.s20643c13f8");
    check_field_offset(lv, s20643c13f9, ABISELECT(600,408), "S20643C13.s20643c13f9");
    test_class_info(&lv, &cd_S20643C13);
    dp->~S20643C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20643C13(Test_S20643C13, "S20643C13", ABISELECT(608,412));

#else // __cplusplus

extern void _ZN9S20643C13C1Ev();
extern void _ZN9S20643C13D1Ev();
Name_Map name_map_S20643C13[] = {
  NSPAIR(_ZN9S20643C13C1Ev),
  NSPAIR(_ZN9S20643C13D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S20643C13[];
extern void _ZN9S20643C133v12Ev();
static  VTBL_ENTRY vtc_S20643C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C13[0]),
  (VTBL_ENTRY)&_ZN9S20643C133v12Ev,
};
extern VTBL_ENTRY _ZTI9S20643C13[];
extern  VTBL_ENTRY _ZTV9S20643C13[];
Class_Descriptor cd_S20643C13 = {  "S20643C13", // class name
  0,0,//no base classes
  &(vtc_S20643C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(608,412), // object size
  NSPAIRA(_ZTI9S20643C13),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S20643C13),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20643C15_nt  {
};
//SIG(-1 S20643C15_nt) C1{}



//skip512 S20643C15_nt

#else // __cplusplus

Class_Descriptor cd_S20643C15_nt = {  "S20643C15_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20643C14  : virtual S3216C8_nt , S20643C8 , S20643C9 , S20643C5 {
  int s20643c14f0;
  ::S20643C15_nt s20643c14f1;
  void *s20643c14f2[2];
  virtual void  v13(); // _ZN9S20643C143v13Ev
  ~S20643C14(); // tgen
  S20643C14(); // tgen
};
//SIG(-1 S20643C14) C1{ VBC2{ m Fi} BC3{ VBC4{ BC2 v2 v3 v4 FC2[3] FC2[2] Fp Fs FC2} VBC2 BC5{ VBC4 VBC2 v5 FC4 FD Fp[2] FC4} BC6{ BC4 VBC2 FD FL FC4 Fp Fs[3]} v6 Fp[2] Fl Fi FC4[5]} BC5 BC6 v1 Fi FC7{} Fp[2]}


void  S20643C14 ::v13(){vfunc_called(this, "_ZN9S20643C143v13Ev");}
S20643C14 ::~S20643C14(){ note_dtor("S20643C14", this);} // tgen
S20643C14 ::S20643C14(){ note_ctor("S20643C14", this);} // tgen

static void Test_S20643C14()
{
  extern Class_Descriptor cd_S20643C14;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(59,178)];
    init_test(&cd_S20643C14, buf);
    S20643C14 *dp, &lv = *(dp=new (buf) S20643C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(928,708), "sizeof(S20643C14)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20643C14)");
    /*is_ambiguous_... S20643C14::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*), ABISELECT(864,664), "S20643C14");
    /*is_ambiguous_... S20643C8::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C8*), ABISELECT(864,664), "S20643C14");
    /*is_ambiguous_... S20643C9::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C9*)(S20643C8*), ABISELECT(864,664), "S20643C14");
    /*is_ambiguous_... S20643C5::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*)(S20643C8*), ABISELECT(864,664), "S20643C14");
    /*is_ambiguous_... S20643C14::S20643C9 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C9*), ABISELECT(864,664), "S20643C14");
    /*is_ambiguous_... S20643C14::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*), ABISELECT(864,664), "S20643C14");
    /*is_ambiguous_... S20643C14::S20643C6 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*), ABISELECT(880,672), "S20643C14");
    /*is_ambiguous_... S20643C8::S20643C6 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C8*), ABISELECT(872,668), "S20643C14");
    check_base_class_offset(lv, (S20643C6*)(S20643C9*)(S20643C8*), ABISELECT(872,668), "S20643C14");
    /*is_ambiguous_... S20643C14::S20643C9 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C9*), ABISELECT(872,668), "S20643C14");
    check_base_class_offset(lv, (S20643C9*)(S20643C8*), 0, "S20643C14");
    check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*)(S20643C8*), ABISELECT(152,108), "S20643C14");
    check_base_class_offset(lv, (S20643C6*)(S20643C5*)(S20643C8*), ABISELECT(144,104), "S20643C14");
    check_base_class_offset(lv, (S20643C5*)(S20643C8*), ABISELECT(144,104), "S20643C14");
    check_base_class_offset(lv, (S20643C8*), 0, "S20643C14");
    /*is_ambiguous_... S20643C14::S20643C9 */ AMB_check_base_class_offset(lv, (S20643C9*), ABISELECT(560,432), "S20643C14");
    /*is_ambiguous_... S20643C14::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*), ABISELECT(712,540), "S20643C14");
    /*is_ambiguous_... S20643C14::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C5*), ABISELECT(704,536), "S20643C14");
    /*is_ambiguous_... S20643C14::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C5*), ABISELECT(704,536), "S20643C14");
    check_field_offset(lv, s20643c14f0, ABISELECT(840,648), "S20643C14.s20643c14f0");
    check_field_offset(lv, s20643c14f1, ABISELECT(844,652), "S20643C14.s20643c14f1");
    check_field_offset(lv, s20643c14f2, ABISELECT(848,656), "S20643C14.s20643c14f2");
    test_class_info(&lv, &cd_S20643C14);
    dp->~S20643C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20643C14(Test_S20643C14, "S20643C14", ABISELECT(928,708));

#else // __cplusplus

extern void _ZN9S20643C14C1Ev();
extern void _ZN9S20643C14D1Ev();
Name_Map name_map_S20643C14[] = {
  NSPAIR(_ZN9S20643C14C1Ev),
  NSPAIR(_ZN9S20643C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C9;
extern VTBL_ENTRY _ZTI8S20643C9[];
extern  VTBL_ENTRY _ZTV8S20643C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S20643C8;
extern VTBL_ENTRY _ZTI8S20643C8[];
extern  VTBL_ENTRY _ZTV8S20643C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C8[];
extern Class_Descriptor cd_S20643C9;
extern VTBL_ENTRY _ZTI8S20643C9[];
extern  VTBL_ENTRY _ZTV8S20643C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
static Base_Class bases_S20643C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C8_nt,    ABISELECT(864,664), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3216C8_nt,    ABISELECT(880,672), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(872,668), //bcp->offset
    24, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20643C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(152,108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(144,104), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(144,104), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20643C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20643C9,    ABISELECT(560,432), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3216C8_nt,    ABISELECT(712,540), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(704,536), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(704,536), //bcp->offset
    18, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20643C14[];
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
extern void _ZN9S20643C143v13Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY vtc_S20643C14[] = {
  ABISELECT(864,664),
  ABISELECT(872,668),
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C14[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20643C143v13Ev,
  ABISELECT(720,560),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI9S20643C14[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  ABISELECT(304,232),
  ABISELECT(312,236),
  ABISELECT(-560,-432),
  (VTBL_ENTRY)&(_ZTI9S20643C14[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  ABISELECT(160,128),
  ABISELECT(-704,-536),
  (VTBL_ENTRY)&(_ZTI9S20643C14[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  0,
  0,
  0,
  ABISELECT(-872,-668),
  (VTBL_ENTRY)&(_ZTI9S20643C14[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern VTBL_ENTRY _ZTV9S20643C14[];
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C8__9S20643C14[] = {
  ABISELECT(864,664),
  ABISELECT(872,668),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C98S20643C8__9S20643C14[] = {
  ABISELECT(864,664),
  ABISELECT(872,668),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C98S20643C8__9S20643C14[] = {
  0,
  0,
  0,
  ABISELECT(-872,-668),
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C8__9S20643C14[] = {
  ABISELECT(720,560),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C8__9S20643C14[] = {
  0,
  0,
  0,
  ABISELECT(-872,-668),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__8S20643C8__9S20643C14[] = {
  ABISELECT(720,560),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C9__A1__9S20643C14[] = {
  ABISELECT(304,232),
  ABISELECT(312,236),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C9__A1__9S20643C14[] = {
  0,
  0,
  0,
  ABISELECT(-312,-236),
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__A1__9S20643C14[] = {
  ABISELECT(160,128),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
static  VTT_ENTRY vtt_S20643C14[] = {
  {&(_ZTV9S20643C14[4]),  4,32},
  {&(_tg__ZTV8S20643C8__9S20643C14[4]),  4,6},
  {&(_tg__ZTV8S20643C98S20643C8__9S20643C14[4]),  4,5},
  {&(_tg__ZTV8S20643C6__8S20643C98S20643C8__9S20643C14[5]),  5,8},
  {&(_tg__ZTV8S20643C58S20643C8__9S20643C14[3]),  3,6},
  {&(_tg__ZTV8S20643C6__8S20643C8__9S20643C14[5]),  5,8},
  {&(_tg__ZTV8S20643C5__8S20643C8__9S20643C14[3]),  3,6},
  {&(_tg__ZTV8S20643C9__A1__9S20643C14[4]),  4,5},
  {&(_tg__ZTV8S20643C6__8S20643C9__A1__9S20643C14[5]),  5,8},
  {&(_tg__ZTV8S20643C5__A1__9S20643C14[3]),  3,6},
  {&(_ZTV9S20643C14[29]),  29,32},
  {&(_ZTV9S20643C14[10]),  10,32},
  {&(_ZTV9S20643C14[17]),  17,32},
  {&(_ZTV9S20643C14[21]),  21,32},
};
extern VTBL_ENTRY _ZTI9S20643C14[];
extern  VTBL_ENTRY _ZTV9S20643C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20643C14[];
Class_Descriptor cd_S20643C14 = {  "S20643C14", // class name
  bases_S20643C14, 12,
  &(vtc_S20643C14[0]), // expected_vtbl_contents
  &(vtt_S20643C14[0]), // expected_vtt_contents
  ABISELECT(928,708), // object size
  NSPAIRA(_ZTI9S20643C14),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S20643C14),32, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20643C14),14, //virtual table table var
  8, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20643C12  : S20643C13 , S20643C5 , S20643C14 {
  virtual  ~S20643C12(); // _ZN9S20643C12D2Ev
  S20643C12(); // tgen
};
//SIG(-1 S20643C12) C1{ BC2{ v1 Fp[7] FC3{ VBC4{ BC5{ m Fi} v2 v3 v4 FC5[3] FC5[2] Fp Fs FC5} VBC5 v5 FC4 FD Fp[2] FC4} FD Fi FL Fp FC3 Fp[5] Fi[8] Fp} BC6{ BC4 VBC5 FD FL FC4 Fp Fs[3]} BC7{ VBC5 BC8{ VBC4 VBC5 BC3 BC6 v6 Fp[2] Fl Fi FC4[5]} BC3 BC6 v7 Fi FC9{} Fp[2]} vd}


 S20643C12 ::~S20643C12(){ note_dtor("S20643C12", this);}
S20643C12 ::S20643C12(){ note_ctor("S20643C12", this);} // tgen

static void Test_S20643C12()
{
  extern Class_Descriptor cd_S20643C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(106,309)];
    init_test(&cd_S20643C12, buf);
    S20643C12 *dp, &lv = *(dp=new (buf) S20643C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1680,1232), "sizeof(S20643C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20643C12)");
    check_base_class_offset(lv, (S20643C13*), 0, "S20643C12");
    /*is_ambiguous_... S20643C12::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*), ABISELECT(616,416), "S20643C12");
    /*is_ambiguous_... S20643C12::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C5*), ABISELECT(608,412), "S20643C12");
    /*is_ambiguous_... S20643C12::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*), ABISELECT(1616,1188), "S20643C12");
    /*is_ambiguous_... S20643C14::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C14*), ABISELECT(1616,1188), "S20643C12");
    /*is_ambiguous_... S20643C8::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C8*)(S20643C14*), ABISELECT(1616,1188), "S20643C12");
    /*is_ambiguous_... S20643C9::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C9*)(S20643C8*)(S20643C14*), ABISELECT(1616,1188), "S20643C12");
    /*is_ambiguous_... S20643C5::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*)(S20643C8*)(S20643C14*), ABISELECT(1616,1188), "S20643C12");
    /*is_ambiguous_... S20643C14::S20643C9 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C9*)(S20643C14*), ABISELECT(1616,1188), "S20643C12");
    /*is_ambiguous_... S20643C14::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*)(S20643C14*), ABISELECT(1616,1188), "S20643C12");
    /*is_ambiguous_... S20643C12::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C5*), ABISELECT(608,412), "S20643C12");
    /*is_ambiguous_... S20643C12::S20643C6 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*), ABISELECT(1632,1196), "S20643C12");
    /*is_ambiguous_... S20643C8::S20643C6 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C8*)(S20643C14*), ABISELECT(1624,1192), "S20643C12");
    check_base_class_offset(lv, (S20643C6*)(S20643C9*)(S20643C8*)(S20643C14*), ABISELECT(1624,1192), "S20643C12");
    /*is_ambiguous_... S20643C14::S20643C9 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C9*)(S20643C14*), ABISELECT(1624,1192), "S20643C12");
    check_base_class_offset(lv, (S20643C9*)(S20643C8*)(S20643C14*), ABISELECT(752,524), "S20643C12");
    check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*)(S20643C8*)(S20643C14*), ABISELECT(904,632), "S20643C12");
    check_base_class_offset(lv, (S20643C6*)(S20643C5*)(S20643C8*)(S20643C14*), ABISELECT(896,628), "S20643C12");
    check_base_class_offset(lv, (S20643C5*)(S20643C8*)(S20643C14*), ABISELECT(896,628), "S20643C12");
    check_base_class_offset(lv, (S20643C8*)(S20643C14*), ABISELECT(752,524), "S20643C12");
    /*is_ambiguous_... S20643C14::S20643C9 */ AMB_check_base_class_offset(lv, (S20643C9*)(S20643C14*), ABISELECT(1312,956), "S20643C12");
    /*is_ambiguous_... S20643C14::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*)(S20643C14*), ABISELECT(1464,1064), "S20643C12");
    /*is_ambiguous_... S20643C14::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C5*)(S20643C14*), ABISELECT(1456,1060), "S20643C12");
    /*is_ambiguous_... S20643C14::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C5*)(S20643C14*), ABISELECT(1456,1060), "S20643C12");
    check_base_class_offset(lv, (S20643C14*), ABISELECT(752,524), "S20643C12");
    test_class_info(&lv, &cd_S20643C12);
    dp->~S20643C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20643C12(Test_S20643C12, "S20643C12", ABISELECT(1680,1232));

#else // __cplusplus

extern void _ZN9S20643C12C1Ev();
extern void _ZN9S20643C12D2Ev();
Name_Map name_map_S20643C12[] = {
  NSPAIR(_ZN9S20643C12C1Ev),
  NSPAIR(_ZN9S20643C12D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20643C13;
extern VTBL_ENTRY _ZTI9S20643C13[];
extern  VTBL_ENTRY _ZTV9S20643C13[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C9;
extern VTBL_ENTRY _ZTI8S20643C9[];
extern  VTBL_ENTRY _ZTV8S20643C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S20643C8;
extern VTBL_ENTRY _ZTI8S20643C8[];
extern  VTBL_ENTRY _ZTV8S20643C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C8[];
extern Class_Descriptor cd_S20643C9;
extern VTBL_ENTRY _ZTI8S20643C9[];
extern  VTBL_ENTRY _ZTV8S20643C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S20643C14;
extern VTBL_ENTRY _ZTI9S20643C14[];
extern  VTBL_ENTRY _ZTV9S20643C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20643C14[];
static Base_Class bases_S20643C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20643C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3216C8_nt,    ABISELECT(616,416), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(608,412), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(1616,1188), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S20643C5,    ABISELECT(608,412), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3216C8_nt,    ABISELECT(1632,1196), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(1624,1192), //bcp->offset
    37, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S20643C9,    ABISELECT(752,524), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(904,632), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(896,628), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(896,628), //bcp->offset
    20, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20643C8,    ABISELECT(752,524), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20643C9,    ABISELECT(1312,956), //bcp->offset
    26, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(1464,1064), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(1456,1060), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(1456,1060), //bcp->offset
    31, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20643C14,    ABISELECT(752,524), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20643C12[];
extern void _ZN9S20643C133v12Ev();
extern void _ZN9S20643C12D1Ev();
extern void _ZN9S20643C12D0Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
extern void _ZN9S20643C143v13Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY vtc_S20643C12[] = {
  ABISELECT(1624,1192),
  ABISELECT(1616,1188),
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C12[0]),
  (VTBL_ENTRY)&_ZN9S20643C133v12Ev,
  (VTBL_ENTRY)&_ZN9S20643C12D1Ev,
  (VTBL_ENTRY)&_ZN9S20643C12D0Ev,
  ABISELECT(1008,776),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI9S20643C12[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  ABISELECT(864,664),
  ABISELECT(872,668),
  ABISELECT(-752,-524),
  (VTBL_ENTRY)&(_ZTI9S20643C12[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20643C143v13Ev,
  ABISELECT(720,560),
  ABISELECT(-896,-628),
  (VTBL_ENTRY)&(_ZTI9S20643C12[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  ABISELECT(304,232),
  ABISELECT(312,236),
  ABISELECT(-1312,-956),
  (VTBL_ENTRY)&(_ZTI9S20643C12[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  ABISELECT(160,128),
  ABISELECT(-1456,-1060),
  (VTBL_ENTRY)&(_ZTI9S20643C12[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  0,
  0,
  0,
  ABISELECT(-1624,-1192),
  (VTBL_ENTRY)&(_ZTI9S20643C12[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern VTBL_ENTRY _ZTV9S20643C12[];
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__9S20643C12[] = {
  ABISELECT(1008,776),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
extern void _ZN9S20643C143v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20643C14__9S20643C12[] = {
  ABISELECT(864,664),
  ABISELECT(872,668),
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C14[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20643C143v13Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C89S20643C14__9S20643C12[] = {
  ABISELECT(864,664),
  ABISELECT(872,668),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C98S20643C89S20643C14__9S20643C12[] = {
  ABISELECT(864,664),
  ABISELECT(872,668),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C98S20643C89S20643C14__9S20643C12[] = {
  0,
  0,
  0,
  ABISELECT(-872,-668),
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C89S20643C14__A1__9S20643C12[] = {
  ABISELECT(720,560),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C89S20643C14__9S20643C12[] = {
  0,
  0,
  0,
  ABISELECT(-872,-668),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__8S20643C89S20643C14__9S20643C12[] = {
  ABISELECT(720,560),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C99S20643C14__A1__9S20643C12[] = {
  ABISELECT(304,232),
  ABISELECT(312,236),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C99S20643C14__A1__9S20643C12[] = {
  0,
  0,
  0,
  ABISELECT(-312,-236),
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C59S20643C14__A2__9S20643C12[] = {
  ABISELECT(160,128),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__9S20643C14__9S20643C12[] = {
  0,
  0,
  0,
  ABISELECT(-872,-668),
  (VTBL_ENTRY)&(_ZTI9S20643C14[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C8__9S20643C14__9S20643C12[] = {
  ABISELECT(720,560),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI9S20643C14[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C9__A1__9S20643C14__9S20643C12[] = {
  ABISELECT(304,232),
  ABISELECT(312,236),
  ABISELECT(-560,-432),
  (VTBL_ENTRY)&(_ZTI9S20643C14[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__A1__9S20643C14__9S20643C12[] = {
  ABISELECT(160,128),
  ABISELECT(-704,-536),
  (VTBL_ENTRY)&(_ZTI9S20643C14[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
static  VTT_ENTRY vtt_S20643C12[] = {
  {&(_ZTV9S20643C12[4]),  4,45},
  {&(_tg__ZTV8S20643C5__9S20643C12[3]),  3,6},
  {&(_tg__ZTV9S20643C14__9S20643C12[4]),  4,7},
  {&(_tg__ZTV8S20643C89S20643C14__9S20643C12[4]),  4,6},
  {&(_tg__ZTV8S20643C98S20643C89S20643C14__9S20643C12[4]),  4,5},
  {&(_tg__ZTV8S20643C6__8S20643C98S20643C89S20643C14__9S20643C12[5]),  5,8},
  {&(_tg__ZTV8S20643C58S20643C89S20643C14__A1__9S20643C12[3]),  3,6},
  {&(_tg__ZTV8S20643C6__8S20643C89S20643C14__9S20643C12[5]),  5,8},
  {&(_tg__ZTV8S20643C5__8S20643C89S20643C14__9S20643C12[3]),  3,6},
  {&(_tg__ZTV8S20643C99S20643C14__A1__9S20643C12[4]),  4,5},
  {&(_tg__ZTV8S20643C6__8S20643C99S20643C14__A1__9S20643C12[5]),  5,8},
  {&(_tg__ZTV8S20643C59S20643C14__A2__9S20643C12[3]),  3,6},
  {&(_tg__ZTV8S20643C6__9S20643C14__9S20643C12[5]),  5,8},
  {&(_tg__ZTV8S20643C58S20643C8__9S20643C14__9S20643C12[3]),  3,6},
  {&(_tg__ZTV8S20643C9__A1__9S20643C14__9S20643C12[4]),  4,5},
  {&(_tg__ZTV8S20643C5__A1__9S20643C14__9S20643C12[3]),  3,6},
  {&(_ZTV9S20643C12[10]),  10,45},
  {&(_ZTV9S20643C12[17]),  17,45},
  {&(_ZTV9S20643C12[42]),  42,45},
  {&(_ZTV9S20643C12[23]),  23,45},
  {&(_ZTV9S20643C12[30]),  30,45},
  {&(_ZTV9S20643C12[34]),  34,45},
};
extern VTBL_ENTRY _ZTI9S20643C12[];
extern  VTBL_ENTRY _ZTV9S20643C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20643C12[];
Class_Descriptor cd_S20643C12 = {  "S20643C12", // class name
  bases_S20643C12, 17,
  &(vtc_S20643C12[0]), // expected_vtbl_contents
  &(vtt_S20643C12[0]), // expected_vtt_contents
  ABISELECT(1680,1232), // object size
  NSPAIRA(_ZTI9S20643C12),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S20643C12),45, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20643C12),22, //virtual table table var
  12, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S20643C19  {
  int s20643c19f0:3;
  int s20643c19f1;
  int s20643c19f2;
  int s20643c19f3;
  long double s20643c19f4[8];
  void *s20643c19f5;
  char s20643c19f6[5];
  long double s20643c19f7;
  char s20643c19f8[4];
  int s20643c19f9;
  void *s20643c19f10;
  char s20643c19f11[4];
  void *s20643c19f12;
  void  mf20643c19(); // _ZN9S20643C1910mf20643c19Ev
};
//SIG(1 S20643C19) U1{ m Fi:3 Fi Fi Fi FD[8] Fp Fc[5] FD Fc[4] Fi Fp Fc[4] Fp}

#endif // __cplusplus
#ifdef __cplusplus

struct  S20643C18  {
  char s20643c18f0[2];
  int s20643c18f1;
  __tsi64 s20643c18f2;
  void *s20643c18f3[7];
  ::S20643C19 s20643c18f4[4];
  ::S20643C11 s20643c18f5;
  void  mf20643c18(); // _ZN9S20643C1810mf20643c18Ev
  virtual  ~S20643C18(); // _ZN9S20643C18D1Ev
  S20643C18(); // tgen
};
//SIG(-1 S20643C18) C1{ vd m Fc[2] Fi FL Fp[7] FU2{ m Fi:3 Fi Fi Fi FD[8] Fp Fc[5] FD Fc[4] Fi Fp Fc[4] Fp}[4] FC3{ VBC4{ m Fi} VBC5{ BC4 v1 v2 v3 FC4[3] FC4[2] Fp Fs FC4} VBC6{ BC5 VBC4 FD FL FC5 Fp Fs[3]} Fp[2] Fi FC6[8] FD[9]}}


void  S20643C18 ::mf20643c18(){}
 S20643C18 ::~S20643C18(){ note_dtor("S20643C18", this);}
S20643C18 ::S20643C18(){ note_ctor("S20643C18", this);} // tgen

static void Test_S20643C18()
{
  extern Class_Descriptor cd_S20643C18;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(134,411)];
    init_test(&cd_S20643C18, buf);
    S20643C18 *dp, &lv = *(dp=new (buf) S20643C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2128,1640), "sizeof(S20643C18)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20643C18)");
    check_field_offset(lv, s20643c18f0, ABISELECT(8,4), "S20643C18.s20643c18f0");
    check_field_offset(lv, s20643c18f1, ABISELECT(12,8), "S20643C18.s20643c18f1");
    check_field_offset(lv, s20643c18f2, ABISELECT(16,12), "S20643C18.s20643c18f2");
    check_field_offset(lv, s20643c18f3, ABISELECT(24,20), "S20643C18.s20643c18f3");
    check_field_offset(lv, s20643c18f4, ABISELECT(80,48), "S20643C18.s20643c18f4");
    check_field_offset(lv, s20643c18f5, ABISELECT(592,432), "S20643C18.s20643c18f5");
    test_class_info(&lv, &cd_S20643C18);
    dp->~S20643C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20643C18(Test_S20643C18, "S20643C18", ABISELECT(2128,1640));

#else // __cplusplus

extern void _ZN9S20643C18C1Ev();
extern void _ZN9S20643C18D1Ev();
Name_Map name_map_S20643C18[] = {
  NSPAIR(_ZN9S20643C18C1Ev),
  NSPAIR(_ZN9S20643C18D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S20643C18[];
extern void _ZN9S20643C18D1Ev();
extern void _ZN9S20643C18D0Ev();
static  VTBL_ENTRY vtc_S20643C18[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C18[0]),
  (VTBL_ENTRY)&_ZN9S20643C18D1Ev,
  (VTBL_ENTRY)&_ZN9S20643C18D0Ev,
};
extern VTBL_ENTRY _ZTI9S20643C18[];
extern  VTBL_ENTRY _ZTV9S20643C18[];
Class_Descriptor cd_S20643C18 = {  "S20643C18", // class name
  0,0,//no base classes
  &(vtc_S20643C18[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2128,1640), // object size
  NSPAIRA(_ZTI9S20643C18),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S20643C18),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20643C17  : S20643C5 , virtual S20643C10 , S20643C8 , S20643C14 {
  int s20643c17f0;
  char s20643c17f1[2];
  int s20643c17f2;
  __tsi64 s20643c17f3;
  ::S20643C15_nt s20643c17f4;
  void *s20643c17f5[8];
  short s20643c17f6[5];
  __tsi64 s20643c17f7;
  ::S20643C18 s20643c17f8;
  virtual  ~S20643C17(); // _ZN9S20643C17D2Ev
  S20643C17(); // tgen
};
//SIG(-1 S20643C17) C1{ BC2{ BC3{ BC4{ m Fi} v1 v2 v3 FC4[3] FC4[2] Fp Fs FC4} VBC4 FD FL FC3 Fp Fs[3]} VBC5{ BC6{ VBC4 VBC3 VBC2 Fp[2] Fi FC2[8] FD[9]} BC4 VBC7{ VBC3 VBC4 BC8{ VBC3 VBC4 v4 FC3 FD Fp[2] FC3} BC2 v5 Fp[2] Fl Fi FC3[5]} BC9{ BC3 vd v6 Fp[7] Fi[2] FL Fi} vd v7 Fi Fp Fi} BC7 BC10{ VBC4 BC7 BC8 BC2 v8 Fi FC11{} Fp[2]} vd Fi Fc[2] Fi FL FC11 Fp[8] Fs[5] FL FC12{ vd m Fc[2] Fi FL Fp[7] FU13{ m Fi:3 Fi Fi Fi FD[8] Fp Fc[5] FD Fc[4] Fi Fp Fc[4] Fp}[4] FC6}}


 S20643C17 ::~S20643C17(){ note_dtor("S20643C17", this);}
S20643C17 ::S20643C17(){ note_ctor("S20643C17", this);} // tgen

static void Test_S20643C17()
{
  extern Class_Descriptor cd_S20643C17;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(381,1168)];
    init_test(&cd_S20643C17, buf);
    S20643C17 *dp, &lv = *(dp=new (buf) S20643C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(6080,4668), "sizeof(S20643C17)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20643C17)");
    /*is_ambiguous_... S20643C17::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*), ABISELECT(8,4), "S20643C17");
    /*is_ambiguous_... S20643C17::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C5*), 0, "S20643C17");
    /*is_ambiguous_... S20643C17::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*), ABISELECT(3824,2924), "S20643C17");
    /*is_ambiguous_... S20643C11::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C11*)(S20643C10*), ABISELECT(3824,2924), "S20643C17");
    /*is_ambiguous_... S20643C17::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*), ABISELECT(3824,2924), "S20643C17");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C8*), ABISELECT(3824,2924), "S20643C17");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C9*)(S20643C8*), ABISELECT(3824,2924), "S20643C17");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*)(S20643C8*), ABISELECT(3824,2924), "S20643C17");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C8*), ABISELECT(3824,2924), "S20643C17");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C9*)(S20643C8*), ABISELECT(3824,2924), "S20643C17");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*)(S20643C8*), ABISELECT(3824,2924), "S20643C17");
    /*is_ambiguous_... S20643C14::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C14*), ABISELECT(3824,2924), "S20643C17");
    /*is_ambiguous_... S20643C8::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C8*)(S20643C14*), ABISELECT(3824,2924), "S20643C17");
    /*is_ambiguous_... S20643C9::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C9*)(S20643C8*)(S20643C14*), ABISELECT(3824,2924), "S20643C17");
    /*is_ambiguous_... S20643C5::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*)(S20643C8*)(S20643C14*), ABISELECT(3824,2924), "S20643C17");
    /*is_ambiguous_... S20643C14::S20643C9 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C9*)(S20643C14*), ABISELECT(3824,2924), "S20643C17");
    /*is_ambiguous_... S20643C14::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*)(S20643C14*), ABISELECT(3824,2924), "S20643C17");
    /*is_ambiguous_... S20643C17::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C5*), 0, "S20643C17");
    /*is_ambiguous_... S20643C17::S20643C6 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*), ABISELECT(5328,4088), "S20643C17");
    /*is_ambiguous_... S20643C11::S20643C6 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C11*)(S20643C10*), ABISELECT(5320,4084), "S20643C17");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C8*), ABISELECT(5320,4084), "S20643C17");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C9*)(S20643C8*), ABISELECT(5320,4084), "S20643C17");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C8*), ABISELECT(5320,4084), "S20643C17");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C9*)(S20643C8*), ABISELECT(5320,4084), "S20643C17");
    /*is_ambiguous_... S20643C8::S20643C6 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C8*)(S20643C14*), ABISELECT(5320,4084), "S20643C17");
    check_base_class_offset(lv, (S20643C6*)(S20643C9*)(S20643C8*)(S20643C14*), ABISELECT(5320,4084), "S20643C17");
    /*is_ambiguous_... S20643C14::S20643C9 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C9*)(S20643C14*), ABISELECT(5320,4084), "S20643C17");
    /*is_ambiguous_... S20643C17::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*), ABISELECT(5384,4128), "S20643C17");
    /*is_ambiguous_... S20643C17::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C5*), ABISELECT(5376,4124), "S20643C17");
    check_base_class_offset(lv, (S20643C5*)(S20643C11*)(S20643C10*), ABISELECT(5376,4124), "S20643C17");
    check_base_class_offset(lv, (S20643C11*)(S20643C10*), ABISELECT(3840,2928), "S20643C17");
    /*is_ambiguous_... S20643C10::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C10*), ABISELECT(5168,3980), "S20643C17");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C9*)(S20643C8*), ABISELECT(5520,4236), "S20643C17");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*)(S20643C8*), ABISELECT(5672,4344), "S20643C17");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C5*)(S20643C8*), ABISELECT(5664,4340), "S20643C17");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C5*)(S20643C8*), ABISELECT(5664,4340), "S20643C17");
    check_base_class_offset(lv, (S20643C8*)(S20643C10*), ABISELECT(5520,4236), "S20643C17");
    check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C7*)(S20643C10*), ABISELECT(5184,3988), "S20643C17");
    check_base_class_offset(lv, (S20643C6*)(S20643C7*)(S20643C10*), ABISELECT(5176,3984), "S20643C17");
    check_base_class_offset(lv, (S20643C7*)(S20643C10*), ABISELECT(5176,3984), "S20643C17");
    check_base_class_offset(lv, (S20643C10*), ABISELECT(3840,2928), "S20643C17");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C9*)(S20643C8*), ABISELECT(144,112), "S20643C17");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*)(S20643C8*), ABISELECT(296,220), "S20643C17");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C5*)(S20643C8*), ABISELECT(288,216), "S20643C17");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C5*)(S20643C8*), ABISELECT(288,216), "S20643C17");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C8*), ABISELECT(144,112), "S20643C17");
    check_base_class_offset(lv, (S20643C9*)(S20643C8*)(S20643C14*), ABISELECT(704,544), "S20643C17");
    check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*)(S20643C8*)(S20643C14*), ABISELECT(856,652), "S20643C17");
    check_base_class_offset(lv, (S20643C6*)(S20643C5*)(S20643C8*)(S20643C14*), ABISELECT(848,648), "S20643C17");
    check_base_class_offset(lv, (S20643C5*)(S20643C8*)(S20643C14*), ABISELECT(848,648), "S20643C17");
    check_base_class_offset(lv, (S20643C8*)(S20643C14*), ABISELECT(704,544), "S20643C17");
    /*is_ambiguous_... S20643C14::S20643C9 */ AMB_check_base_class_offset(lv, (S20643C9*)(S20643C14*), ABISELECT(1264,976), "S20643C17");
    /*is_ambiguous_... S20643C14::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*)(S20643C14*), ABISELECT(1416,1084), "S20643C17");
    /*is_ambiguous_... S20643C14::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C5*)(S20643C14*), ABISELECT(1408,1080), "S20643C17");
    /*is_ambiguous_... S20643C14::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C5*)(S20643C14*), ABISELECT(1408,1080), "S20643C17");
    check_base_class_offset(lv, (S20643C14*), ABISELECT(704,544), "S20643C17");
    check_field_offset(lv, s20643c17f0, ABISELECT(1568,1208), "S20643C17.s20643c17f0");
    check_field_offset(lv, s20643c17f1, ABISELECT(1572,1212), "S20643C17.s20643c17f1");
    check_field_offset(lv, s20643c17f2, ABISELECT(1576,1216), "S20643C17.s20643c17f2");
    check_field_offset(lv, s20643c17f3, ABISELECT(1584,1220), "S20643C17.s20643c17f3");
    check_field_offset(lv, s20643c17f4, ABISELECT(1592,1228), "S20643C17.s20643c17f4");
    check_field_offset(lv, s20643c17f5, ABISELECT(1600,1232), "S20643C17.s20643c17f5");
    check_field_offset(lv, s20643c17f6, ABISELECT(1664,1264), "S20643C17.s20643c17f6");
    check_field_offset(lv, s20643c17f7, ABISELECT(1680,1276), "S20643C17.s20643c17f7");
    check_field_offset(lv, s20643c17f8, ABISELECT(1696,1284), "S20643C17.s20643c17f8");
    test_class_info(&lv, &cd_S20643C17);
    dp->~S20643C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20643C17(Test_S20643C17, "S20643C17", ABISELECT(6080,4668));

#else // __cplusplus

extern void _ZN9S20643C17C1Ev();
extern void _ZN9S20643C17D2Ev();
Name_Map name_map_S20643C17[] = {
  NSPAIR(_ZN9S20643C17C1Ev),
  NSPAIR(_ZN9S20643C17D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S20643C11;
extern VTBL_ENTRY _ZTI9S20643C11[];
extern  VTBL_ENTRY _ZTV9S20643C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20643C11[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C9;
extern VTBL_ENTRY _ZTI8S20643C9[];
extern  VTBL_ENTRY _ZTV8S20643C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S20643C8;
extern VTBL_ENTRY _ZTI8S20643C8[];
extern  VTBL_ENTRY _ZTV8S20643C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C8[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C7;
extern VTBL_ENTRY _ZTI8S20643C7[];
extern  VTBL_ENTRY _ZTV8S20643C7[];
extern Class_Descriptor cd_S20643C10;
extern VTBL_ENTRY _ZTI9S20643C10[];
extern  VTBL_ENTRY _ZTV9S20643C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20643C10[];
extern Class_Descriptor cd_S20643C9;
extern VTBL_ENTRY _ZTI8S20643C9[];
extern  VTBL_ENTRY _ZTV8S20643C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S20643C8;
extern VTBL_ENTRY _ZTI8S20643C8[];
extern  VTBL_ENTRY _ZTV8S20643C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C8[];
extern Class_Descriptor cd_S20643C9;
extern VTBL_ENTRY _ZTI8S20643C9[];
extern  VTBL_ENTRY _ZTV8S20643C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S20643C8;
extern VTBL_ENTRY _ZTI8S20643C8[];
extern  VTBL_ENTRY _ZTV8S20643C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C8[];
extern Class_Descriptor cd_S20643C9;
extern VTBL_ENTRY _ZTI8S20643C9[];
extern  VTBL_ENTRY _ZTV8S20643C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S20643C14;
extern VTBL_ENTRY _ZTI9S20643C14[];
extern  VTBL_ENTRY _ZTV9S20643C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20643C14[];
static Base_Class bases_S20643C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C8_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20643C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(3824,2924), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20643C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3216C8_nt,    ABISELECT(5328,4088), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(5320,4084), //bcp->offset
    71, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S3216C8_nt,    ABISELECT(5384,4128), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(5376,4124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(5376,4124), //bcp->offset
    79, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    43, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S20643C11,    ABISELECT(3840,2928), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(5168,3980), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S20643C9,    ABISELECT(5520,4236), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    45, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(5672,4344), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(5664,4340), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(5664,4340), //bcp->offset
    99, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    47, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20643C8,    ABISELECT(5520,4236), //bcp->offset
    88, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    19, //immediately_derived
  0, 1},
  {&cd_S3216C8_nt,    ABISELECT(5184,3988), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(5176,3984), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20643C7,    ABISELECT(5176,3984), //bcp->offset
    63, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S20643C10,    ABISELECT(3840,2928), //bcp->offset
    48, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20643C9,    ABISELECT(144,112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(296,220), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(288,216), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(288,216), //bcp->offset
    18, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S20643C8,    ABISELECT(144,112), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20643C9,    ABISELECT(704,544), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(856,652), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(848,648), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(848,648), //bcp->offset
    31, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    32, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S20643C8,    ABISELECT(704,544), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S20643C9,    ABISELECT(1264,976), //bcp->offset
    37, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    33, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(1416,1084), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(1408,1080), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(1408,1080), //bcp->offset
    42, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    34, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S20643C14,    ABISELECT(704,544), //bcp->offset
    24, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20643C17[];
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN9S20643C17D1Ev();
extern void _ZN9S20643C17D0Ev();
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
extern void _ZN9S20643C143v13Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void ABISELECT(_ZTv0_n56_N9S20643C17D1Ev,_ZTv0_n28_N9S20643C17D1Ev)();
extern void ABISELECT(_ZThn3840_N9S20643C17D1Ev,_ZThn2928_N9S20643C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S20643C17D0Ev,_ZTv0_n28_N9S20643C17D0Ev)();
extern void ABISELECT(_ZThn3840_N9S20643C17D0Ev,_ZThn2928_N9S20643C17D0Ev)() __attribute__((weak));
extern void _ZN9S20643C102v9Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void ABISELECT(_ZTvn1336_n56_N9S20643C17D1Ev,_ZTvn1056_n28_N9S20643C17D1Ev)();
extern void ABISELECT(_ZTvn1336_n56_N9S20643C17D0Ev,_ZTvn1056_n28_N9S20643C17D0Ev)();
extern void _ZN8S20643C72v5Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY vtc_S20643C17[] = {
  ABISELECT(5520,4236),
  ABISELECT(5376,4124),
  ABISELECT(5320,4084),
  ABISELECT(3840,2928),
  ABISELECT(3824,2924),
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C17[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  (VTBL_ENTRY)&_ZN9S20643C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20643C17D0Ev,
  ABISELECT(3680,2812),
  ABISELECT(5176,3972),
  ABISELECT(-144,-112),
  (VTBL_ENTRY)&(_ZTI9S20643C17[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
  ABISELECT(3536,2708),
  ABISELECT(-288,-216),
  (VTBL_ENTRY)&(_ZTI9S20643C17[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  ABISELECT(3120,2380),
  ABISELECT(4616,3540),
  ABISELECT(-704,-544),
  (VTBL_ENTRY)&(_ZTI9S20643C17[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20643C143v13Ev,
  ABISELECT(2976,2276),
  ABISELECT(-848,-648),
  (VTBL_ENTRY)&(_ZTI9S20643C17[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  ABISELECT(2560,1948),
  ABISELECT(4056,3108),
  ABISELECT(-1264,-976),
  (VTBL_ENTRY)&(_ZTI9S20643C17[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  ABISELECT(2416,1844),
  ABISELECT(-1408,-1080),
  (VTBL_ENTRY)&(_ZTI9S20643C17[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  0,
  ABISELECT(-3840,-2928),
  ABISELECT(1680,1308),
  ABISELECT(1536,1196),
  ABISELECT(1480,1156),
  ABISELECT(-16,-4),
  ABISELECT(-3840,-2928),
  (VTBL_ENTRY)&(_ZTI9S20643C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20643C17D1Ev,_ZTv0_n28_N9S20643C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20643C17D0Ev,_ZTv0_n28_N9S20643C17D0Ev),
  (VTBL_ENTRY)&_ZN9S20643C102v9Ev,
  ABISELECT(-5176,-3984),
  (VTBL_ENTRY)&(_ZTI9S20643C17[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn1336_n56_N9S20643C17D1Ev,_ZTvn1056_n28_N9S20643C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1336_n56_N9S20643C17D0Ev,_ZTvn1056_n28_N9S20643C17D0Ev),
  (VTBL_ENTRY)&_ZN8S20643C72v5Ev,
  0,
  0,
  0,
  ABISELECT(-5320,-4084),
  (VTBL_ENTRY)&(_ZTI9S20643C17[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  0,
  0,
  0,
  ABISELECT(-1552,-1200),
  ABISELECT(-5376,-4124),
  (VTBL_ENTRY)&(_ZTI9S20643C17[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  ABISELECT(144,104),
  ABISELECT(144,104),
  ABISELECT(144,104),
  0,
  0,
  ABISELECT(-1696,-1312),
  ABISELECT(-200,-152),
  ABISELECT(-5520,-4236),
  (VTBL_ENTRY)&(_ZTI9S20643C17[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
  ABISELECT(-1840,-1416),
  ABISELECT(-5664,-4340),
  (VTBL_ENTRY)&(_ZTI9S20643C17[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern VTBL_ENTRY _ZTV9S20643C17[];
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__A__9S20643C17[] = {
  ABISELECT(3824,2924),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C8__A__9S20643C17[] = {
  ABISELECT(3680,2812),
  ABISELECT(5176,3972),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C98S20643C8__A1__9S20643C17[] = {
  ABISELECT(3680,2812),
  ABISELECT(5176,3972),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C98S20643C8__A1__9S20643C17[] = {
  0,
  0,
  0,
  ABISELECT(-5176,-3972),
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C8__A3__9S20643C17[] = {
  ABISELECT(3536,2708),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C8__A__9S20643C17[] = {
  0,
  0,
  0,
  ABISELECT(-5176,-3972),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__8S20643C8__A__9S20643C17[] = {
  ABISELECT(3536,2708),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
extern void _ZN9S20643C143v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20643C14__9S20643C17[] = {
  ABISELECT(3120,2380),
  ABISELECT(4616,3540),
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C14[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20643C143v13Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C89S20643C14__A2__9S20643C17[] = {
  ABISELECT(3120,2380),
  ABISELECT(4616,3540),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C98S20643C89S20643C14__A2__9S20643C17[] = {
  ABISELECT(3120,2380),
  ABISELECT(4616,3540),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C98S20643C89S20643C14__A2__9S20643C17[] = {
  0,
  0,
  0,
  ABISELECT(-4616,-3540),
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C89S20643C14__A4__9S20643C17[] = {
  ABISELECT(2976,2276),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C89S20643C14__A2__9S20643C17[] = {
  0,
  0,
  0,
  ABISELECT(-4616,-3540),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__8S20643C89S20643C14__A2__9S20643C17[] = {
  ABISELECT(2976,2276),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C99S20643C14__A3__9S20643C17[] = {
  ABISELECT(2560,1948),
  ABISELECT(4056,3108),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C99S20643C14__A3__9S20643C17[] = {
  0,
  0,
  0,
  ABISELECT(-4056,-3108),
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C59S20643C14__A5__9S20643C17[] = {
  ABISELECT(2416,1844),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__9S20643C14__9S20643C17[] = {
  0,
  0,
  0,
  ABISELECT(-4616,-3540),
  (VTBL_ENTRY)&(_ZTI9S20643C14[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C8__9S20643C14__9S20643C17[] = {
  ABISELECT(2976,2276),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI9S20643C14[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C9__A1__9S20643C14__9S20643C17[] = {
  ABISELECT(2560,1948),
  ABISELECT(4056,3108),
  ABISELECT(-560,-432),
  (VTBL_ENTRY)&(_ZTI9S20643C14[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__A1__9S20643C14__9S20643C17[] = {
  ABISELECT(2416,1844),
  ABISELECT(-704,-536),
  (VTBL_ENTRY)&(_ZTI9S20643C14[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN9S20643C10D1Ev();
extern void _ZN9S20643C10D0Ev();
extern void _ZN9S20643C102v9Ev();
static  VTBL_ENTRY _tg__ZTV9S20643C10__9S20643C17[] = {
  ABISELECT(1680,1308),
  ABISELECT(1536,1196),
  ABISELECT(1480,1156),
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN9S20643C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20643C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20643C102v9Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20643C119S20643C10__9S20643C17[] = {
  ABISELECT(1536,1196),
  ABISELECT(1480,1156),
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__9S20643C119S20643C10__9S20643C17[] = {
  0,
  0,
  0,
  ABISELECT(-1480,-1156),
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__9S20643C119S20643C10__9S20643C17[] = {
  0,
  0,
  0,
  ABISELECT(-1552,-1200),
  ABISELECT(-1536,-1196),
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__9S20643C10__9S20643C17[] = {
  0,
  0,
  0,
  ABISELECT(-1480,-1156),
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__9S20643C10__9S20643C17[] = {
  0,
  0,
  0,
  ABISELECT(-1552,-1200),
  ABISELECT(-1536,-1196),
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C8__9S20643C10__9S20643C17[] = {
  ABISELECT(144,104),
  ABISELECT(144,104),
  ABISELECT(144,104),
  0,
  0,
  ABISELECT(-1696,-1312),
  ABISELECT(-200,-152),
  ABISELECT(-1680,-1308),
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C8__A1__9S20643C10__9S20643C17[] = {
  ABISELECT(-1840,-1416),
  ABISELECT(-1824,-1412),
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__A1__9S20643C17[] = {
  ABISELECT(-1552,-1200),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C8__9S20643C17[] = {
  ABISELECT(-1696,-1312),
  ABISELECT(-200,-152),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C98S20643C8__9S20643C17[] = {
  ABISELECT(-1696,-1312),
  ABISELECT(-200,-152),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C98S20643C8__9S20643C17[] = {
  0,
  0,
  0,
  ABISELECT(200,152),
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C8__A2__9S20643C17[] = {
  ABISELECT(-1840,-1416),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C8__9S20643C17[] = {
  0,
  0,
  0,
  ABISELECT(200,152),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__8S20643C8__9S20643C17[] = {
  ABISELECT(-1840,-1416),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
static  VTT_ENTRY vtt_S20643C17[] = {
  {&(_ZTV9S20643C17[7]),  7,105},
  {&(_tg__ZTV8S20643C5__A__9S20643C17[3]),  3,6},
  {&(_tg__ZTV8S20643C8__A__9S20643C17[4]),  4,6},
  {&(_tg__ZTV8S20643C98S20643C8__A1__9S20643C17[4]),  4,5},
  {&(_tg__ZTV8S20643C6__8S20643C98S20643C8__A1__9S20643C17[5]),  5,8},
  {&(_tg__ZTV8S20643C58S20643C8__A3__9S20643C17[3]),  3,6},
  {&(_tg__ZTV8S20643C6__8S20643C8__A__9S20643C17[5]),  5,8},
  {&(_tg__ZTV8S20643C5__8S20643C8__A__9S20643C17[3]),  3,6},
  {&(_tg__ZTV9S20643C14__9S20643C17[4]),  4,7},
  {&(_tg__ZTV8S20643C89S20643C14__A2__9S20643C17[4]),  4,6},
  {&(_tg__ZTV8S20643C98S20643C89S20643C14__A2__9S20643C17[4]),  4,5},
  {&(_tg__ZTV8S20643C6__8S20643C98S20643C89S20643C14__A2__9S20643C17[5]),  5,8},
  {&(_tg__ZTV8S20643C58S20643C89S20643C14__A4__9S20643C17[3]),  3,6},
  {&(_tg__ZTV8S20643C6__8S20643C89S20643C14__A2__9S20643C17[5]),  5,8},
  {&(_tg__ZTV8S20643C5__8S20643C89S20643C14__A2__9S20643C17[3]),  3,6},
  {&(_tg__ZTV8S20643C99S20643C14__A3__9S20643C17[4]),  4,5},
  {&(_tg__ZTV8S20643C6__8S20643C99S20643C14__A3__9S20643C17[5]),  5,8},
  {&(_tg__ZTV8S20643C59S20643C14__A5__9S20643C17[3]),  3,6},
  {&(_tg__ZTV8S20643C6__9S20643C14__9S20643C17[5]),  5,8},
  {&(_tg__ZTV8S20643C58S20643C8__9S20643C14__9S20643C17[3]),  3,6},
  {&(_tg__ZTV8S20643C9__A1__9S20643C14__9S20643C17[4]),  4,5},
  {&(_tg__ZTV8S20643C5__A1__9S20643C14__9S20643C17[3]),  3,6},
  {&(_ZTV9S20643C17[60]),  60,105},
  {&(_ZTV9S20643C17[76]),  76,105},
  {&(_ZTV9S20643C17[85]),  85,105},
  {&(_ZTV9S20643C17[97]),  97,105},
  {&(_ZTV9S20643C17[102]),  102,105},
  {&(_ZTV9S20643C17[65]),  65,105},
  {&(_ZTV9S20643C17[16]),  16,105},
  {&(_ZTV9S20643C17[21]),  21,105},
  {&(_ZTV9S20643C17[28]),  28,105},
  {&(_ZTV9S20643C17[34]),  34,105},
  {&(_ZTV9S20643C17[41]),  41,105},
  {&(_ZTV9S20643C17[45]),  45,105},
  {&(_tg__ZTV9S20643C10__9S20643C17[6]),  6,9},
  {&(_tg__ZTV9S20643C119S20643C10__9S20643C17[5]),  5,5},
  {&(_tg__ZTV8S20643C6__9S20643C119S20643C10__9S20643C17[5]),  5,8},
  {&(_tg__ZTV8S20643C5__9S20643C119S20643C10__9S20643C17[6]),  6,9},
  {&(_tg__ZTV8S20643C6__9S20643C10__9S20643C17[5]),  5,8},
  {&(_tg__ZTV8S20643C5__9S20643C10__9S20643C17[6]),  6,9},
  {&(_tg__ZTV8S20643C8__9S20643C10__9S20643C17[9]),  9,11},
  {&(_tg__ZTV8S20643C58S20643C8__A1__9S20643C10__9S20643C17[3]),  3,6},
  {&(_tg__ZTV8S20643C5__A1__9S20643C17[3]),  3,6},
  {&(_tg__ZTV8S20643C8__9S20643C17[4]),  4,6},
  {&(_tg__ZTV8S20643C98S20643C8__9S20643C17[4]),  4,5},
  {&(_tg__ZTV8S20643C6__8S20643C98S20643C8__9S20643C17[5]),  5,8},
  {&(_tg__ZTV8S20643C58S20643C8__A2__9S20643C17[3]),  3,6},
  {&(_tg__ZTV8S20643C6__8S20643C8__9S20643C17[5]),  5,8},
  {&(_tg__ZTV8S20643C5__8S20643C8__9S20643C17[3]),  3,6},
};
extern VTBL_ENTRY _ZTI9S20643C17[];
extern  VTBL_ENTRY _ZTV9S20643C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20643C17[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20643C17D0Ev,_ZTv0_n28_N9S20643C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3840_N9S20643C17D0Ev,_ZThn2928_N9S20643C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20643C17D1Ev,_ZTv0_n28_N9S20643C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3840_N9S20643C17D1Ev,_ZThn2928_N9S20643C17D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20643C17 = {  "S20643C17", // class name
  bases_S20643C17, 35,
  &(vtc_S20643C17[0]), // expected_vtbl_contents
  &(vtt_S20643C17[0]), // expected_vtt_contents
  ABISELECT(6080,4668), // object size
  NSPAIRA(_ZTI9S20643C17),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S20643C17),105, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20643C17),49, //virtual table table var
  25, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20643C16  : virtual S20643C5 , S20643C10 , S20643C17 , S20643C9 {
  char s20643c16f0;
  int s20643c16f1;
  int s20643c16f2;
  int s20643c16f3;
  int s20643c16f4;
  void *s20643c16f5;
  char s20643c16f6[4];
  int s20643c16f7;
  virtual  ~S20643C16(); // _ZN9S20643C16D2Ev
  S20643C16(); // tgen
};
//SIG(-1 S20643C16) C1{ VBC2{ BC3{ BC4{ m Fi} v1 v2 v3 FC4[3] FC4[2] Fp Fs FC4} VBC4 FD FL FC3 Fp Fs[3]} BC5{ BC6{ VBC4 VBC3 VBC2 Fp[2] Fi FC2[8] FD[9]} BC4 VBC7{ VBC3 VBC4 BC8{ VBC3 VBC4 v4 FC3 FD Fp[2] FC3} BC2 v5 Fp[2] Fl Fi FC3[5]} BC9{ BC3 vd v6 Fp[7] Fi[2] FL Fi} vd v7 Fi Fp Fi} BC10{ BC2 VBC5 BC7 BC11{ VBC4 BC7 BC8 BC2 v8 Fi FC12{} Fp[2]} vd Fi Fc[2] Fi FL FC12 Fp[8] Fs[5] FL FC13{ vd m Fc[2] Fi FL Fp[7] FU14{ m Fi:3 Fi Fi Fi FD[8] Fp Fc[5] FD Fc[4] Fi Fp Fc[4] Fp}[4] FC6}} BC8 vd Fc Fi Fi Fi Fi Fp Fc[4] Fi}


 S20643C16 ::~S20643C16(){ note_dtor("S20643C16", this);}
S20643C16 ::S20643C16(){ note_ctor("S20643C16", this);} // tgen

static void Test_S20643C16()
{
  extern Class_Descriptor cd_S20643C16;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(485,1491)];
    init_test(&cd_S20643C16, buf);
    S20643C16 *dp, &lv = *(dp=new (buf) S20643C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(7744,5960), "sizeof(S20643C16)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20643C16)");
    /*is_ambiguous_... S20643C16::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*), ABISELECT(5512,4220), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C5*), ABISELECT(5504,4216), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*), ABISELECT(5640,4328), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C10 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C11*)(S20643C10*), ABISELECT(5640,4328), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C8*), ABISELECT(5640,4328), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C9*)(S20643C8*), ABISELECT(5640,4328), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*)(S20643C8*), ABISELECT(5640,4328), "S20643C16");
    /*is_ambiguous_... S20643C17::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*)(S20643C17*), ABISELECT(5640,4328), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C10 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C11*)(S20643C10*), ABISELECT(5640,4328), "S20643C16");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C8*)(S20643C17*), ABISELECT(5640,4328), "S20643C16");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C9*)(S20643C8*)(S20643C17*), ABISELECT(5640,4328), "S20643C16");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*)(S20643C8*)(S20643C17*), ABISELECT(5640,4328), "S20643C16");
    /*is_ambiguous_... S20643C14::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C14*)(S20643C17*), ABISELECT(5640,4328), "S20643C16");
    /*is_ambiguous_... S20643C8::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C8*)(S20643C14*)(S20643C17*), ABISELECT(5640,4328), "S20643C16");
    /*is_ambiguous_... S20643C9::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C9*)(S20643C8*)(S20643C14*)(S20643C17*), ABISELECT(5640,4328), "S20643C16");
    /*is_ambiguous_... S20643C5::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*)(S20643C8*)(S20643C14*)(S20643C17*), ABISELECT(5640,4328), "S20643C16");
    /*is_ambiguous_... S20643C14::S20643C9 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C9*)(S20643C14*)(S20643C17*), ABISELECT(5640,4328), "S20643C16");
    /*is_ambiguous_... S20643C14::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*)(S20643C14*)(S20643C17*), ABISELECT(5640,4328), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C9 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C9*), ABISELECT(5640,4328), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C5*), ABISELECT(5504,4216), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C10 */ AMB_check_base_class_offset(lv, (S20643C5*)(S20643C11*)(S20643C10*), ABISELECT(5504,4216), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C10 */ AMB_check_base_class_offset(lv, (S20643C5*)(S20643C11*)(S20643C10*), ABISELECT(5504,4216), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C6 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*), ABISELECT(5656,4336), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C10 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C11*)(S20643C10*), ABISELECT(5648,4332), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C8*), ABISELECT(5648,4332), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C9*)(S20643C8*), ABISELECT(5648,4332), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C10 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C11*)(S20643C10*), ABISELECT(5648,4332), "S20643C16");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C8*)(S20643C17*), ABISELECT(5648,4332), "S20643C16");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C9*)(S20643C8*)(S20643C17*), ABISELECT(5648,4332), "S20643C16");
    /*is_ambiguous_... S20643C8::S20643C6 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C8*)(S20643C14*)(S20643C17*), ABISELECT(5648,4332), "S20643C16");
    check_base_class_offset(lv, (S20643C6*)(S20643C9*)(S20643C8*)(S20643C14*)(S20643C17*), ABISELECT(5648,4332), "S20643C16");
    /*is_ambiguous_... S20643C14::S20643C9 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C9*)(S20643C14*)(S20643C17*), ABISELECT(5648,4332), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C9 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C9*), ABISELECT(5648,4332), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C10 */ AMB_check_base_class_offset(lv, (S20643C11*)(S20643C10*), 0, "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C10 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C10*), ABISELECT(1328,1052), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C9*)(S20643C8*), ABISELECT(5696,4372), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*)(S20643C8*), ABISELECT(5848,4480), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C5*)(S20643C8*), ABISELECT(5840,4476), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C5*)(S20643C8*), ABISELECT(5840,4476), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C10 */ AMB_check_base_class_offset(lv, (S20643C8*)(S20643C10*), ABISELECT(5696,4372), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C10 */ AMB_check_base_class_offset(lv, (S20643C8*)(S20643C10*), ABISELECT(5696,4372), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C10 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C7*)(S20643C10*), ABISELECT(1344,1060), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C10 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C7*)(S20643C10*), ABISELECT(1336,1056), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C10 */ AMB_check_base_class_offset(lv, (S20643C7*)(S20643C10*), ABISELECT(1336,1056), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C10 */ AMB_check_base_class_offset(lv, (S20643C10*), 0, "S20643C16");
    /*is_ambiguous_... S20643C17::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*)(S20643C17*), ABISELECT(1496,1160), "S20643C16");
    /*is_ambiguous_... S20643C17::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C5*)(S20643C17*), ABISELECT(1488,1156), "S20643C16");
    /*is_ambiguous_... S20643C17::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C5*)(S20643C17*), ABISELECT(1488,1156), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C10 */ AMB_check_base_class_offset(lv, (S20643C11*)(S20643C10*), ABISELECT(6256,4804), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C10 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C10*), ABISELECT(7584,5856), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C10 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C7*)(S20643C10*), ABISELECT(7600,5864), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C10 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C7*)(S20643C10*), ABISELECT(7592,5860), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C10 */ AMB_check_base_class_offset(lv, (S20643C7*)(S20643C10*), ABISELECT(7592,5860), "S20643C16");
    check_base_class_offset(lv, (S20643C10*)(S20643C17*), ABISELECT(6256,4804), "S20643C16");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C9*)(S20643C8*)(S20643C17*), ABISELECT(1632,1268), "S20643C16");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*)(S20643C8*)(S20643C17*), ABISELECT(1784,1376), "S20643C16");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C5*)(S20643C8*)(S20643C17*), ABISELECT(1776,1372), "S20643C16");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C5*)(S20643C8*)(S20643C17*), ABISELECT(1776,1372), "S20643C16");
    /*is_ambiguous_... S20643C17::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C8*)(S20643C17*), ABISELECT(1632,1268), "S20643C16");
    check_base_class_offset(lv, (S20643C9*)(S20643C8*)(S20643C14*)(S20643C17*), ABISELECT(2192,1700), "S20643C16");
    check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*)(S20643C8*)(S20643C14*)(S20643C17*), ABISELECT(2344,1808), "S20643C16");
    check_base_class_offset(lv, (S20643C6*)(S20643C5*)(S20643C8*)(S20643C14*)(S20643C17*), ABISELECT(2336,1804), "S20643C16");
    check_base_class_offset(lv, (S20643C5*)(S20643C8*)(S20643C14*)(S20643C17*), ABISELECT(2336,1804), "S20643C16");
    check_base_class_offset(lv, (S20643C8*)(S20643C14*)(S20643C17*), ABISELECT(2192,1700), "S20643C16");
    /*is_ambiguous_... S20643C14::S20643C9 */ AMB_check_base_class_offset(lv, (S20643C9*)(S20643C14*)(S20643C17*), ABISELECT(2752,2132), "S20643C16");
    /*is_ambiguous_... S20643C14::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*)(S20643C14*)(S20643C17*), ABISELECT(2904,2240), "S20643C16");
    /*is_ambiguous_... S20643C14::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C5*)(S20643C14*)(S20643C17*), ABISELECT(2896,2236), "S20643C16");
    /*is_ambiguous_... S20643C14::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C5*)(S20643C14*)(S20643C17*), ABISELECT(2896,2236), "S20643C16");
    check_base_class_offset(lv, (S20643C14*)(S20643C17*), ABISELECT(2192,1700), "S20643C16");
    check_base_class_offset(lv, (S20643C17*), ABISELECT(1488,1156), "S20643C16");
    /*is_ambiguous_... S20643C16::S20643C9 */ AMB_check_base_class_offset(lv, (S20643C9*), ABISELECT(5312,4080), "S20643C16");
    check_field_offset(lv, s20643c16f0, ABISELECT(5456,4184), "S20643C16.s20643c16f0");
    check_field_offset(lv, s20643c16f1, ABISELECT(5460,4188), "S20643C16.s20643c16f1");
    check_field_offset(lv, s20643c16f2, ABISELECT(5464,4192), "S20643C16.s20643c16f2");
    check_field_offset(lv, s20643c16f3, ABISELECT(5468,4196), "S20643C16.s20643c16f3");
    check_field_offset(lv, s20643c16f4, ABISELECT(5472,4200), "S20643C16.s20643c16f4");
    check_field_offset(lv, s20643c16f5, ABISELECT(5480,4204), "S20643C16.s20643c16f5");
    check_field_offset(lv, s20643c16f6, ABISELECT(5488,4208), "S20643C16.s20643c16f6");
    check_field_offset(lv, s20643c16f7, ABISELECT(5492,4212), "S20643C16.s20643c16f7");
    test_class_info(&lv, &cd_S20643C16);
    dp->~S20643C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20643C16(Test_S20643C16, "S20643C16", ABISELECT(7744,5960));

#else // __cplusplus

extern void _ZN9S20643C16C1Ev();
extern void _ZN9S20643C16D2Ev();
Name_Map name_map_S20643C16[] = {
  NSPAIR(_ZN9S20643C16C1Ev),
  NSPAIR(_ZN9S20643C16D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C11;
extern VTBL_ENTRY _ZTI9S20643C11[];
extern  VTBL_ENTRY _ZTV9S20643C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20643C11[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C9;
extern VTBL_ENTRY _ZTI8S20643C9[];
extern  VTBL_ENTRY _ZTV8S20643C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S20643C8;
extern VTBL_ENTRY _ZTI8S20643C8[];
extern  VTBL_ENTRY _ZTV8S20643C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C8[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C7;
extern VTBL_ENTRY _ZTI8S20643C7[];
extern  VTBL_ENTRY _ZTV8S20643C7[];
extern Class_Descriptor cd_S20643C10;
extern VTBL_ENTRY _ZTI9S20643C10[];
extern  VTBL_ENTRY _ZTV9S20643C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20643C10[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S20643C11;
extern VTBL_ENTRY _ZTI9S20643C11[];
extern  VTBL_ENTRY _ZTV9S20643C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20643C11[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C7;
extern VTBL_ENTRY _ZTI8S20643C7[];
extern  VTBL_ENTRY _ZTV8S20643C7[];
extern Class_Descriptor cd_S20643C10;
extern VTBL_ENTRY _ZTI9S20643C10[];
extern  VTBL_ENTRY _ZTV9S20643C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20643C10[];
extern Class_Descriptor cd_S20643C9;
extern VTBL_ENTRY _ZTI8S20643C9[];
extern  VTBL_ENTRY _ZTV8S20643C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S20643C8;
extern VTBL_ENTRY _ZTI8S20643C8[];
extern  VTBL_ENTRY _ZTV8S20643C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C8[];
extern Class_Descriptor cd_S20643C9;
extern VTBL_ENTRY _ZTI8S20643C9[];
extern  VTBL_ENTRY _ZTV8S20643C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S20643C8;
extern VTBL_ENTRY _ZTI8S20643C8[];
extern  VTBL_ENTRY _ZTV8S20643C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C8[];
extern Class_Descriptor cd_S20643C9;
extern VTBL_ENTRY _ZTI8S20643C9[];
extern  VTBL_ENTRY _ZTV8S20643C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S20643C14;
extern VTBL_ENTRY _ZTI9S20643C14[];
extern  VTBL_ENTRY _ZTV9S20643C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20643C14[];
extern Class_Descriptor cd_S20643C17;
extern VTBL_ENTRY _ZTI9S20643C17[];
extern  VTBL_ENTRY _ZTV9S20643C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20643C17[];
extern Class_Descriptor cd_S20643C9;
extern VTBL_ENTRY _ZTI8S20643C9[];
extern  VTBL_ENTRY _ZTV8S20643C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C9[];
static Base_Class bases_S20643C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C8_nt,    ABISELECT(5512,4220), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(5504,4216), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(5640,4328), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20643C5,    ABISELECT(5504,4216), //bcp->offset
    71, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    46, //bcp->index_in_construction_vtbl_array
    60, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3216C8_nt,    ABISELECT(5656,4336), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(5648,4332), //bcp->offset
    80, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    47, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20643C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(1328,1052), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20643C9,    ABISELECT(5696,4372), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    62, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(5848,4480), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(5840,4476), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(5840,4476), //bcp->offset
    99, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    49, //bcp->index_in_construction_vtbl_array
    64, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20643C8,    ABISELECT(5696,4372), //bcp->offset
    88, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    48, //bcp->index_in_construction_vtbl_array
    61, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S3216C8_nt,    ABISELECT(1344,1060), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(1336,1056), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20643C7,    ABISELECT(1336,1056), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20643C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3216C8_nt,    ABISELECT(1496,1160), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(1488,1156), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(1488,1156), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S20643C11,    ABISELECT(6256,4804), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    68, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(7584,5856), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(7600,5864), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(7592,5860), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S20643C7,    ABISELECT(7592,5860), //bcp->offset
    120, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    52, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S20643C10,    ABISELECT(6256,4804), //bcp->offset
    105, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    51, //bcp->index_in_construction_vtbl_array
    67, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    41, //immediately_derived
  0, 1},
  {&cd_S20643C9,    ABISELECT(1632,1268), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(1784,1376), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(1776,1372), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(1776,1372), //bcp->offset
    36, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    54, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S20643C8,    ABISELECT(1632,1268), //bcp->offset
    30, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    53, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S20643C9,    ABISELECT(2192,1700), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(2344,1808), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(2336,1804), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(2336,1804), //bcp->offset
    49, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    56, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S20643C8,    ABISELECT(2192,1700), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    40, //immediately_derived
  0, 0},
  {&cd_S20643C9,    ABISELECT(2752,2132), //bcp->offset
    55, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    57, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    40, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(2904,2240), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(2896,2236), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(2896,2236), //bcp->offset
    60, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    58, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    40, //immediately_derived
  0, 0},
  {&cd_S20643C14,    ABISELECT(2192,1700), //bcp->offset
    42, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    55, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S20643C17,    ABISELECT(1488,1156), //bcp->offset
    18, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    50, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20643C9,    ABISELECT(5312,4080), //bcp->offset
    66, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    59, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20643C16[];
extern void _ZN9S20643C16D1Ev();
extern void _ZN9S20643C16D0Ev();
extern void _ZN9S20643C102v9Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void ABISELECT(_ZThn1336_N9S20643C16D1Ev,_ZThn1056_N9S20643C16D1Ev)();
extern void ABISELECT(_ZThn1336_N9S20643C16D0Ev,_ZThn1056_N9S20643C16D0Ev)();
extern void _ZN8S20643C72v5Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void ABISELECT(_ZThn1488_N9S20643C16D1Ev,_ZThn1156_N9S20643C16D1Ev)();
extern void ABISELECT(_ZThn1488_N9S20643C16D0Ev,_ZThn1156_N9S20643C16D0Ev)();
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
extern void _ZN9S20643C143v13Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void ABISELECT(_ZTv0_n56_N9S20643C16D1Ev,_ZTv0_n28_N9S20643C16D1Ev)();
extern void ABISELECT(_ZThn6256_N9S20643C16D1Ev,_ZThn4804_N9S20643C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S20643C16D0Ev,_ZTv0_n28_N9S20643C16D0Ev)();
extern void ABISELECT(_ZThn6256_N9S20643C16D0Ev,_ZThn4804_N9S20643C16D0Ev)() __attribute__((weak));
extern void _ZN9S20643C102v9Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void ABISELECT(_ZTvn1336_n56_N9S20643C16D1Ev,_ZTvn1056_n28_N9S20643C16D1Ev)();
extern void ABISELECT(_ZTvn1336_n56_N9S20643C16D0Ev,_ZTvn1056_n28_N9S20643C16D0Ev)();
extern void _ZN8S20643C72v5Ev();
static  VTBL_ENTRY vtc_S20643C16[] = {
  ABISELECT(6256,4804),
  ABISELECT(5696,4372),
  ABISELECT(5504,4216),
  ABISELECT(5648,4332),
  ABISELECT(5640,4328),
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C16[0]),
  (VTBL_ENTRY)&_ZN9S20643C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20643C16D0Ev,
  (VTBL_ENTRY)&_ZN9S20643C102v9Ev,
  ABISELECT(-1336,-1056),
  (VTBL_ENTRY)&(_ZTI9S20643C16[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn1336_N9S20643C16D1Ev,_ZThn1056_N9S20643C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1336_N9S20643C16D0Ev,_ZThn1056_N9S20643C16D0Ev),
  (VTBL_ENTRY)&_ZN8S20643C72v5Ev,
  ABISELECT(4208,3216),
  ABISELECT(4016,3060),
  ABISELECT(4160,3176),
  ABISELECT(4768,3648),
  ABISELECT(4152,3172),
  ABISELECT(-1488,-1156),
  (VTBL_ENTRY)&(_ZTI9S20643C16[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn1488_N9S20643C16D1Ev,_ZThn1156_N9S20643C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1488_N9S20643C16D0Ev,_ZThn1156_N9S20643C16D0Ev),
  ABISELECT(4008,3060),
  ABISELECT(4016,3064),
  ABISELECT(-1632,-1268),
  (VTBL_ENTRY)&(_ZTI9S20643C16[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
  ABISELECT(3864,2956),
  ABISELECT(-1776,-1372),
  (VTBL_ENTRY)&(_ZTI9S20643C16[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  ABISELECT(3448,2628),
  ABISELECT(3456,2632),
  ABISELECT(-2192,-1700),
  (VTBL_ENTRY)&(_ZTI9S20643C16[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20643C143v13Ev,
  ABISELECT(3304,2524),
  ABISELECT(-2336,-1804),
  (VTBL_ENTRY)&(_ZTI9S20643C16[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  ABISELECT(2888,2196),
  ABISELECT(2896,2200),
  ABISELECT(-2752,-2132),
  (VTBL_ENTRY)&(_ZTI9S20643C16[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  ABISELECT(2744,2092),
  ABISELECT(-2896,-2236),
  (VTBL_ENTRY)&(_ZTI9S20643C16[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  ABISELECT(328,248),
  ABISELECT(336,252),
  ABISELECT(-5312,-4080),
  (VTBL_ENTRY)&(_ZTI9S20643C16[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  0,
  0,
  0,
  ABISELECT(136,112),
  ABISELECT(-5504,-4216),
  (VTBL_ENTRY)&(_ZTI9S20643C16[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  0,
  0,
  0,
  ABISELECT(-5648,-4332),
  (VTBL_ENTRY)&(_ZTI9S20643C16[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  ABISELECT(144,104),
  ABISELECT(144,104),
  ABISELECT(144,104),
  0,
  0,
  ABISELECT(-56,-44),
  ABISELECT(-48,-40),
  ABISELECT(-5696,-4372),
  (VTBL_ENTRY)&(_ZTI9S20643C16[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
  ABISELECT(-200,-148),
  ABISELECT(-5840,-4476),
  (VTBL_ENTRY)&(_ZTI9S20643C16[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  0,
  ABISELECT(-6256,-4804),
  ABISELECT(-560,-432),
  ABISELECT(-752,-588),
  ABISELECT(-608,-472),
  ABISELECT(-616,-476),
  ABISELECT(-6256,-4804),
  (VTBL_ENTRY)&(_ZTI9S20643C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20643C16D1Ev,_ZTv0_n28_N9S20643C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20643C16D0Ev,_ZTv0_n28_N9S20643C16D0Ev),
  (VTBL_ENTRY)&_ZN9S20643C102v9Ev,
  ABISELECT(-7592,-5860),
  (VTBL_ENTRY)&(_ZTI9S20643C16[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn1336_n56_N9S20643C16D1Ev,_ZTvn1056_n28_N9S20643C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1336_n56_N9S20643C16D0Ev,_ZTvn1056_n28_N9S20643C16D0Ev),
  (VTBL_ENTRY)&_ZN8S20643C72v5Ev,
};
extern VTBL_ENTRY _ZTV9S20643C16[];
extern void _ZN9S20643C10D1Ev();
extern void _ZN9S20643C10D0Ev();
extern void _ZN9S20643C102v9Ev();
static  VTBL_ENTRY _tg__ZTV9S20643C10__A__9S20643C16[] = {
  ABISELECT(5696,4372),
  ABISELECT(5504,4216),
  ABISELECT(5648,4332),
  ABISELECT(5640,4328),
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN9S20643C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20643C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20643C102v9Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20643C119S20643C10__9S20643C16[] = {
  ABISELECT(5504,4216),
  ABISELECT(5648,4332),
  ABISELECT(5640,4328),
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__9S20643C119S20643C10__9S20643C16[] = {
  0,
  0,
  0,
  ABISELECT(-5648,-4332),
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__9S20643C119S20643C10__9S20643C16[] = {
  0,
  0,
  0,
  ABISELECT(136,112),
  ABISELECT(-5504,-4216),
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__9S20643C10__A__9S20643C16[] = {
  0,
  0,
  0,
  ABISELECT(-5648,-4332),
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__9S20643C10__A__9S20643C16[] = {
  0,
  0,
  0,
  ABISELECT(136,112),
  ABISELECT(-5504,-4216),
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C8__9S20643C10__A__9S20643C16[] = {
  ABISELECT(144,104),
  ABISELECT(144,104),
  ABISELECT(144,104),
  0,
  0,
  ABISELECT(-56,-44),
  ABISELECT(-48,-40),
  ABISELECT(-5696,-4372),
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C8__A1__9S20643C10__A__9S20643C16[] = {
  ABISELECT(-200,-148),
  ABISELECT(-5840,-4476),
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN9S20643C17D1Ev();
extern void _ZN9S20643C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20643C17__9S20643C16[] = {
  ABISELECT(4208,3216),
  ABISELECT(4016,3060),
  ABISELECT(4160,3176),
  ABISELECT(4768,3648),
  ABISELECT(4152,3172),
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C17[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  (VTBL_ENTRY)&_ZN9S20643C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20643C17D0Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C59S20643C17__A2__9S20643C16[] = {
  ABISELECT(4152,3172),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C89S20643C17__A1__9S20643C16[] = {
  ABISELECT(4008,3060),
  ABISELECT(4016,3064),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C98S20643C89S20643C17__A1__9S20643C16[] = {
  ABISELECT(4008,3060),
  ABISELECT(4016,3064),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C98S20643C89S20643C17__A1__9S20643C16[] = {
  0,
  0,
  0,
  ABISELECT(-4016,-3064),
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C89S20643C17__A3__9S20643C16[] = {
  ABISELECT(3864,2956),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C89S20643C17__A1__9S20643C16[] = {
  0,
  0,
  0,
  ABISELECT(-4016,-3064),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__8S20643C89S20643C17__A1__9S20643C16[] = {
  ABISELECT(3864,2956),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
extern void _ZN9S20643C143v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20643C149S20643C17__9S20643C16[] = {
  ABISELECT(3448,2628),
  ABISELECT(3456,2632),
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C14[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20643C143v13Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C89S20643C149S20643C17__A2__9S20643C16[] = {
  ABISELECT(3448,2628),
  ABISELECT(3456,2632),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C98S20643C89S20643C149S20643C17__A2__9S20643C16[] = {
  ABISELECT(3448,2628),
  ABISELECT(3456,2632),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C98S20643C89S20643C149S20643C17__A2__9S20643C16[] = {
  0,
  0,
  0,
  ABISELECT(-3456,-2632),
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C89S20643C149S20643C17__A4__9S20643C16[] = {
  ABISELECT(3304,2524),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C89S20643C149S20643C17__A2__9S20643C16[] = {
  0,
  0,
  0,
  ABISELECT(-3456,-2632),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__8S20643C89S20643C149S20643C17__A2__9S20643C16[] = {
  ABISELECT(3304,2524),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C99S20643C149S20643C17__A3__9S20643C16[] = {
  ABISELECT(2888,2196),
  ABISELECT(2896,2200),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C99S20643C149S20643C17__A3__9S20643C16[] = {
  0,
  0,
  0,
  ABISELECT(-2896,-2200),
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C59S20643C149S20643C17__A5__9S20643C16[] = {
  ABISELECT(2744,2092),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__9S20643C149S20643C17__9S20643C16[] = {
  0,
  0,
  0,
  ABISELECT(-3456,-2632),
  (VTBL_ENTRY)&(_ZTI9S20643C14[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C8__9S20643C149S20643C17__9S20643C16[] = {
  ABISELECT(3304,2524),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI9S20643C14[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C9__A1__9S20643C149S20643C17__9S20643C16[] = {
  ABISELECT(2888,2196),
  ABISELECT(2896,2200),
  ABISELECT(-560,-432),
  (VTBL_ENTRY)&(_ZTI9S20643C14[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__A1__9S20643C149S20643C17__9S20643C16[] = {
  ABISELECT(2744,2092),
  ABISELECT(-704,-536),
  (VTBL_ENTRY)&(_ZTI9S20643C14[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void ABISELECT(_ZTv0_n56_N9S20643C17D1Ev,_ZTv0_n28_N9S20643C17D1Ev)();
extern void ABISELECT(_ZThn4768_N9S20643C17D1Ev,_ZThn3648_N9S20643C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S20643C17D0Ev,_ZTv0_n28_N9S20643C17D0Ev)();
extern void ABISELECT(_ZThn4768_N9S20643C17D0Ev,_ZThn3648_N9S20643C17D0Ev)() __attribute__((weak));
extern void _ZN9S20643C102v9Ev();
static  VTBL_ENTRY _tg__ZTV9S20643C10__9S20643C17__9S20643C16[] = {
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  0,
  ABISELECT(-4768,-3648),
  ABISELECT(-560,-432),
  ABISELECT(-752,-588),
  ABISELECT(-608,-472),
  ABISELECT(-616,-476),
  ABISELECT(-4768,-3648),
  (VTBL_ENTRY)&(_ZTI9S20643C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20643C17D1Ev,_ZTv0_n28_N9S20643C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20643C17D0Ev,_ZTv0_n28_N9S20643C17D0Ev),
  (VTBL_ENTRY)&_ZN9S20643C102v9Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__A1__9S20643C17__9S20643C16[] = {
  0,
  0,
  0,
  ABISELECT(-4160,-3176),
  (VTBL_ENTRY)&(_ZTI9S20643C17[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__A1__9S20643C17__9S20643C16[] = {
  0,
  0,
  0,
  ABISELECT(136,112),
  ABISELECT(-4016,-3060),
  (VTBL_ENTRY)&(_ZTI9S20643C17[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C8__9S20643C17__9S20643C16[] = {
  ABISELECT(144,104),
  ABISELECT(144,104),
  ABISELECT(144,104),
  0,
  0,
  ABISELECT(-56,-44),
  ABISELECT(-48,-40),
  ABISELECT(-4208,-3216),
  (VTBL_ENTRY)&(_ZTI9S20643C17[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C8__A2__9S20643C17__9S20643C16[] = {
  ABISELECT(-200,-148),
  ABISELECT(-4352,-3320),
  (VTBL_ENTRY)&(_ZTI9S20643C17[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void ABISELECT(_ZTvn1336_n56_N9S20643C17D1Ev,_ZTvn1056_n28_N9S20643C17D1Ev)();
extern void ABISELECT(_ZTvn1336_n56_N9S20643C17D0Ev,_ZTvn1056_n28_N9S20643C17D0Ev)();
extern void _ZN8S20643C72v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C79S20643C10__9S20643C17__9S20643C16[] = {
  ABISELECT(-6104,-4704),
  (VTBL_ENTRY)&(_ZTI9S20643C17[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn1336_n56_N9S20643C17D1Ev,_ZTvn1056_n28_N9S20643C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1336_n56_N9S20643C17D0Ev,_ZTvn1056_n28_N9S20643C17D0Ev),
  (VTBL_ENTRY)&_ZN8S20643C72v5Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C8__A__9S20643C17__9S20643C16[] = {
  ABISELECT(4008,3060),
  ABISELECT(4016,3064),
  ABISELECT(-144,-112),
  (VTBL_ENTRY)&(_ZTI9S20643C17[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C8__A3__9S20643C17__9S20643C16[] = {
  ABISELECT(3864,2956),
  ABISELECT(-288,-216),
  (VTBL_ENTRY)&(_ZTI9S20643C17[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
extern void _ZN9S20643C143v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20643C14__9S20643C17__9S20643C16[] = {
  ABISELECT(3448,2628),
  ABISELECT(3456,2632),
  ABISELECT(-704,-544),
  (VTBL_ENTRY)&(_ZTI9S20643C17[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20643C143v13Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C89S20643C14__A4__9S20643C17__9S20643C16[] = {
  ABISELECT(3304,2524),
  ABISELECT(-848,-648),
  (VTBL_ENTRY)&(_ZTI9S20643C17[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C99S20643C14__A3__9S20643C17__9S20643C16[] = {
  ABISELECT(2888,2196),
  ABISELECT(2896,2200),
  ABISELECT(-1264,-976),
  (VTBL_ENTRY)&(_ZTI9S20643C17[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C59S20643C14__A5__9S20643C17__9S20643C16[] = {
  ABISELECT(2744,2092),
  ABISELECT(-1408,-1080),
  (VTBL_ENTRY)&(_ZTI9S20643C17[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C9__A4__9S20643C16[] = {
  ABISELECT(328,248),
  ABISELECT(336,252),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C9__A4__9S20643C16[] = {
  0,
  0,
  0,
  ABISELECT(-336,-252),
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__9S20643C16[] = {
  ABISELECT(136,112),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C8__9S20643C16[] = {
  ABISELECT(-56,-44),
  ABISELECT(-48,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C98S20643C8__9S20643C16[] = {
  ABISELECT(-56,-44),
  ABISELECT(-48,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C98S20643C8__9S20643C16[] = {
  0,
  0,
  0,
  ABISELECT(48,40),
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C8__A1__9S20643C16[] = {
  ABISELECT(-200,-148),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C8__9S20643C16[] = {
  0,
  0,
  0,
  ABISELECT(48,40),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__8S20643C8__9S20643C16[] = {
  ABISELECT(-200,-148),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN9S20643C10D1Ev();
extern void _ZN9S20643C10D0Ev();
extern void _ZN9S20643C102v9Ev();
static  VTBL_ENTRY _tg__ZTV9S20643C10__A1__9S20643C16[] = {
  ABISELECT(-560,-432),
  ABISELECT(-752,-588),
  ABISELECT(-608,-472),
  ABISELECT(-616,-476),
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN9S20643C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20643C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20643C102v9Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20643C119S20643C10__A1__9S20643C16[] = {
  ABISELECT(-752,-588),
  ABISELECT(-608,-472),
  ABISELECT(-616,-476),
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__9S20643C119S20643C10__A1__9S20643C16[] = {
  0,
  0,
  0,
  ABISELECT(608,472),
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__9S20643C119S20643C10__A1__9S20643C16[] = {
  0,
  0,
  0,
  ABISELECT(136,112),
  ABISELECT(752,588),
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__9S20643C10__A1__9S20643C16[] = {
  0,
  0,
  0,
  ABISELECT(608,472),
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__9S20643C10__A1__9S20643C16[] = {
  0,
  0,
  0,
  ABISELECT(136,112),
  ABISELECT(752,588),
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C8__9S20643C10__A1__9S20643C16[] = {
  ABISELECT(144,104),
  ABISELECT(144,104),
  ABISELECT(144,104),
  0,
  0,
  ABISELECT(-56,-44),
  ABISELECT(-48,-40),
  ABISELECT(560,432),
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C8__A1__9S20643C10__A1__9S20643C16[] = {
  ABISELECT(-200,-148),
  ABISELECT(416,328),
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
static  VTT_ENTRY vtt_S20643C16[] = {
  {&(_ZTV9S20643C16[7]),  7,128},
  {&(_tg__ZTV9S20643C10__A__9S20643C16[6]),  6,9},
  {&(_tg__ZTV9S20643C119S20643C10__9S20643C16[5]),  5,5},
  {&(_tg__ZTV8S20643C6__9S20643C119S20643C10__9S20643C16[5]),  5,8},
  {&(_tg__ZTV8S20643C5__9S20643C119S20643C10__9S20643C16[6]),  6,9},
  {&(_tg__ZTV8S20643C6__9S20643C10__A__9S20643C16[5]),  5,8},
  {&(_tg__ZTV8S20643C5__9S20643C10__A__9S20643C16[6]),  6,9},
  {&(_tg__ZTV8S20643C8__9S20643C10__A__9S20643C16[9]),  9,11},
  {&(_tg__ZTV8S20643C58S20643C8__A1__9S20643C10__A__9S20643C16[3]),  3,6},
  {&(_tg__ZTV9S20643C17__9S20643C16[7]),  7,12},
  {&(_tg__ZTV8S20643C59S20643C17__A2__9S20643C16[3]),  3,6},
  {&(_tg__ZTV8S20643C89S20643C17__A1__9S20643C16[4]),  4,6},
  {&(_tg__ZTV8S20643C98S20643C89S20643C17__A1__9S20643C16[4]),  4,5},
  {&(_tg__ZTV8S20643C6__8S20643C98S20643C89S20643C17__A1__9S20643C16[5]),  5,8},
  {&(_tg__ZTV8S20643C58S20643C89S20643C17__A3__9S20643C16[3]),  3,6},
  {&(_tg__ZTV8S20643C6__8S20643C89S20643C17__A1__9S20643C16[5]),  5,8},
  {&(_tg__ZTV8S20643C5__8S20643C89S20643C17__A1__9S20643C16[3]),  3,6},
  {&(_tg__ZTV9S20643C149S20643C17__9S20643C16[4]),  4,7},
  {&(_tg__ZTV8S20643C89S20643C149S20643C17__A2__9S20643C16[4]),  4,6},
  {&(_tg__ZTV8S20643C98S20643C89S20643C149S20643C17__A2__9S20643C16[4]),  4,5},
  {&(_tg__ZTV8S20643C6__8S20643C98S20643C89S20643C149S20643C17__A2__9S20643C16[5]),  5,8},
  {&(_tg__ZTV8S20643C58S20643C89S20643C149S20643C17__A4__9S20643C16[3]),  3,6},
  {&(_tg__ZTV8S20643C6__8S20643C89S20643C149S20643C17__A2__9S20643C16[5]),  5,8},
  {&(_tg__ZTV8S20643C5__8S20643C89S20643C149S20643C17__A2__9S20643C16[3]),  3,6},
  {&(_tg__ZTV8S20643C99S20643C149S20643C17__A3__9S20643C16[4]),  4,5},
  {&(_tg__ZTV8S20643C6__8S20643C99S20643C149S20643C17__A3__9S20643C16[5]),  5,8},
  {&(_tg__ZTV8S20643C59S20643C149S20643C17__A5__9S20643C16[3]),  3,6},
  {&(_tg__ZTV8S20643C6__9S20643C149S20643C17__9S20643C16[5]),  5,8},
  {&(_tg__ZTV8S20643C58S20643C8__9S20643C149S20643C17__9S20643C16[3]),  3,6},
  {&(_tg__ZTV8S20643C9__A1__9S20643C149S20643C17__9S20643C16[4]),  4,5},
  {&(_tg__ZTV8S20643C5__A1__9S20643C149S20643C17__9S20643C16[3]),  3,6},
  {&(_tg__ZTV9S20643C10__9S20643C17__9S20643C16[12]),  12,15},
  {&(_tg__ZTV8S20643C6__A1__9S20643C17__9S20643C16[5]),  5,8},
  {&(_tg__ZTV8S20643C5__A1__9S20643C17__9S20643C16[6]),  6,9},
  {&(_tg__ZTV8S20643C8__9S20643C17__9S20643C16[9]),  9,11},
  {&(_tg__ZTV8S20643C58S20643C8__A2__9S20643C17__9S20643C16[3]),  3,6},
  {&(_tg__ZTV8S20643C79S20643C10__9S20643C17__9S20643C16[2]),  2,8},
  {&(_tg__ZTV8S20643C8__A__9S20643C17__9S20643C16[4]),  4,6},
  {&(_tg__ZTV8S20643C58S20643C8__A3__9S20643C17__9S20643C16[3]),  3,6},
  {&(_tg__ZTV9S20643C14__9S20643C17__9S20643C16[4]),  4,7},
  {&(_tg__ZTV8S20643C58S20643C89S20643C14__A4__9S20643C17__9S20643C16[3]),  3,6},
  {&(_tg__ZTV8S20643C99S20643C14__A3__9S20643C17__9S20643C16[4]),  4,5},
  {&(_tg__ZTV8S20643C59S20643C14__A5__9S20643C17__9S20643C16[3]),  3,6},
  {&(_tg__ZTV8S20643C9__A4__9S20643C16[4]),  4,5},
  {&(_tg__ZTV8S20643C6__8S20643C9__A4__9S20643C16[5]),  5,8},
  {&(_ZTV9S20643C16[77]),  77,128},
  {&(_ZTV9S20643C16[85]),  85,128},
  {&(_ZTV9S20643C16[97]),  97,128},
  {&(_ZTV9S20643C16[102]),  102,128},
  {&(_ZTV9S20643C16[25]),  25,128},
  {&(_ZTV9S20643C16[117]),  117,128},
  {&(_ZTV9S20643C16[122]),  122,128},
  {&(_ZTV9S20643C16[34]),  34,128},
  {&(_ZTV9S20643C16[39]),  39,128},
  {&(_ZTV9S20643C16[46]),  46,128},
  {&(_ZTV9S20643C16[52]),  52,128},
  {&(_ZTV9S20643C16[59]),  59,128},
  {&(_ZTV9S20643C16[63]),  63,128},
  {&(_ZTV9S20643C16[70]),  70,128},
  {&(_tg__ZTV8S20643C5__9S20643C16[3]),  3,6},
  {&(_tg__ZTV8S20643C8__9S20643C16[4]),  4,6},
  {&(_tg__ZTV8S20643C98S20643C8__9S20643C16[4]),  4,5},
  {&(_tg__ZTV8S20643C6__8S20643C98S20643C8__9S20643C16[5]),  5,8},
  {&(_tg__ZTV8S20643C58S20643C8__A1__9S20643C16[3]),  3,6},
  {&(_tg__ZTV8S20643C6__8S20643C8__9S20643C16[5]),  5,8},
  {&(_tg__ZTV8S20643C5__8S20643C8__9S20643C16[3]),  3,6},
  {&(_tg__ZTV9S20643C10__A1__9S20643C16[6]),  6,9},
  {&(_tg__ZTV9S20643C119S20643C10__A1__9S20643C16[5]),  5,5},
  {&(_tg__ZTV8S20643C6__9S20643C119S20643C10__A1__9S20643C16[5]),  5,8},
  {&(_tg__ZTV8S20643C5__9S20643C119S20643C10__A1__9S20643C16[6]),  6,9},
  {&(_tg__ZTV8S20643C6__9S20643C10__A1__9S20643C16[5]),  5,8},
  {&(_tg__ZTV8S20643C5__9S20643C10__A1__9S20643C16[6]),  6,9},
  {&(_tg__ZTV8S20643C8__9S20643C10__A1__9S20643C16[9]),  9,11},
  {&(_tg__ZTV8S20643C58S20643C8__A1__9S20643C10__A1__9S20643C16[3]),  3,6},
};
extern VTBL_ENTRY _ZTI9S20643C16[];
extern  VTBL_ENTRY _ZTV9S20643C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20643C16[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20643C17D0Ev,_ZTv0_n28_N9S20643C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4768_N9S20643C17D0Ev,_ZThn3648_N9S20643C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20643C17D1Ev,_ZTv0_n28_N9S20643C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4768_N9S20643C17D1Ev,_ZThn3648_N9S20643C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20643C16D0Ev,_ZTv0_n28_N9S20643C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6256_N9S20643C16D0Ev,_ZThn4804_N9S20643C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20643C16D1Ev,_ZTv0_n28_N9S20643C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6256_N9S20643C16D1Ev,_ZThn4804_N9S20643C16D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20643C16 = {  "S20643C16", // class name
  bases_S20643C16, 43,
  &(vtc_S20643C16[0]), // expected_vtbl_contents
  &(vtt_S20643C16[0]), // expected_vtt_contents
  ABISELECT(7744,5960), // object size
  NSPAIRA(_ZTI9S20643C16),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S20643C16),128, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20643C16),74, //virtual table table var
  31, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20643C1  : virtual S20643C2 , S20643C12 {
  ::S20643C4 s20643c1f0;
  int s20643c1f1;
  ::S20643C16 s20643c1f2;
  int s20643c1f3;
  short s20643c1f4;
  void *s20643c1f5;
  void *s20643c1f6;
  ::S3216C8_nt s20643c1f7[8];
  virtual void  v1(); // _ZN8S20643C12v1Ev
  ~S20643C1(); // tgen
  S20643C1(); // tgen
};
//SIG(1 S20643C1) C1{ VBC2{ VBC3{ m Fi} BC4{ VBC5{ BC6{ BC3 v2 v3 v4 FC3[3] FC3[2] Fp Fs FC3} VBC3 FD FL FC6 Fp Fs[3]} BC7{ BC6 vd v5 Fp[7] Fi[2] FL Fi} VBC6 BC8{ VBC6 VBC3 BC9{ VBC6 VBC3 v6 FC6 FD Fp[2] FC6} BC5 v7 Fp[2] Fl Fi FC6[5]} BC9 v8 Fi[2] FD FC9[10] Fi} BC5 VBC10{ BC11{ VBC3 VBC6 VBC5 Fp[2] Fi FC5[8] FD[9]} BC3 VBC8 BC7 vd v9 Fi Fp Fi} BC11 vd v10 v11 Fi[2] Fp Fc:3 Fi[3]} BC12{ BC13{ v12 Fp[7] FC9 FD Fi FL Fp FC9 Fp[5] Fi[8] Fp} BC5 BC14{ VBC3 BC8 BC9 BC5 v13 Fi FC15{} Fp[2]} vd} v1 FC4 Fi FC16{ VBC5 BC10 BC17{ BC5 VBC10 BC8 BC14 vd Fi Fc[2] Fi FL FC15 Fp[8] Fs[5] FL FC18{ vd m Fc[2] Fi FL Fp[7] FU19{ m Fi:3 Fi Fi Fi FD[8] Fp Fc[5] FD Fc[4] Fi Fp Fc[4] Fp}[4] FC11}} BC9 vd Fc Fi Fi Fi Fi Fp Fc[4] Fi} Fi Fs Fp Fp FC3[8]}


void  S20643C1 ::v1(){vfunc_called(this, "_ZN8S20643C12v1Ev");}
S20643C1 ::~S20643C1(){ note_dtor("S20643C1", this);} // tgen
S20643C1 ::S20643C1(){ note_ctor("S20643C1", this);} // tgen

static void Test_S20643C1()
{
  extern Class_Descriptor cd_S20643C1;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(1208,3638)];
    init_test(&cd_S20643C1, buf);
    S20643C1 *dp, &lv = *(dp=new (buf) S20643C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(19312,14548), "sizeof(S20643C1)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20643C1)");
    /*is_ambiguous_... S20643C2::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C2*), ABISELECT(17056,12804), "S20643C1");
    /*is_ambiguous_... S20643C1::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*), ABISELECT(17056,12804), "S20643C1");
    /*is_ambiguous_... S20643C8::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C8*)(S20643C4*)(S20643C2*), ABISELECT(17056,12804), "S20643C1");
    /*is_ambiguous_... S20643C9::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C9*)(S20643C8*)(S20643C4*)(S20643C2*), ABISELECT(17056,12804), "S20643C1");
    /*is_ambiguous_... S20643C5::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*)(S20643C8*)(S20643C4*)(S20643C2*), ABISELECT(17056,12804), "S20643C1");
    /*is_ambiguous_... S20643C4::S20643C9 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C9*)(S20643C4*)(S20643C2*), ABISELECT(17056,12804), "S20643C1");
    /*is_ambiguous_... S20643C2::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*)(S20643C2*), ABISELECT(17056,12804), "S20643C1");
    /*is_ambiguous_... S20643C11::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C11*)(S20643C10*), ABISELECT(17056,12804), "S20643C1");
    /*is_ambiguous_... S20643C1::S20643C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C8*), ABISELECT(17056,12804), "S20643C1");
    /*is_ambiguous_... S20643C1::S20643C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C9*)(S20643C8*), ABISELECT(17056,12804), "S20643C1");
    /*is_ambiguous_... S20643C1::S20643C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*)(S20643C8*), ABISELECT(17056,12804), "S20643C1");
    /*is_ambiguous_... S20643C2::S20643C11 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C11*)(S20643C2*), ABISELECT(17056,12804), "S20643C1");
    /*is_ambiguous_... S20643C12::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*)(S20643C12*), ABISELECT(17056,12804), "S20643C1");
    /*is_ambiguous_... S20643C14::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C14*)(S20643C12*), ABISELECT(17056,12804), "S20643C1");
    /*is_ambiguous_... S20643C8::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C8*)(S20643C14*)(S20643C12*), ABISELECT(17056,12804), "S20643C1");
    /*is_ambiguous_... S20643C9::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C9*)(S20643C8*)(S20643C14*)(S20643C12*), ABISELECT(17056,12804), "S20643C1");
    /*is_ambiguous_... S20643C5::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*)(S20643C8*)(S20643C14*)(S20643C12*), ABISELECT(17056,12804), "S20643C1");
    /*is_ambiguous_... S20643C14::S20643C9 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C9*)(S20643C14*)(S20643C12*), ABISELECT(17056,12804), "S20643C1");
    /*is_ambiguous_... S20643C14::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C5*)(S20643C14*)(S20643C12*), ABISELECT(17056,12804), "S20643C1");
    /*is_ambiguous_... S20643C1::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*), ABISELECT(17080,12812), "S20643C1");
    /*is_ambiguous_... S20643C1::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C5*), ABISELECT(17072,12808), "S20643C1");
    /*is_ambiguous_... S20643C4::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C5*)(S20643C4*)(S20643C2*), ABISELECT(17072,12808), "S20643C1");
    check_base_class_offset(lv, (S20643C5*)(S20643C11*)(S20643C10*), ABISELECT(17072,12808), "S20643C1");
    /*is_ambiguous_... S20643C2::S20643C11 */ AMB_check_base_class_offset(lv, (S20643C5*)(S20643C11*)(S20643C2*), ABISELECT(17072,12808), "S20643C1");
    check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C7*)(S20643C4*)(S20643C2*), ABISELECT(12600,9488), "S20643C1");
    check_base_class_offset(lv, (S20643C6*)(S20643C7*)(S20643C4*)(S20643C2*), ABISELECT(12592,9484), "S20643C1");
    check_base_class_offset(lv, (S20643C7*)(S20643C4*)(S20643C2*), ABISELECT(12592,9484), "S20643C1");
    /*is_ambiguous_... S20643C1::S20643C6 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*), ABISELECT(17216,12924), "S20643C1");
    /*is_ambiguous_... S20643C4::S20643C6 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C4*)(S20643C2*), ABISELECT(17208,12920), "S20643C1");
    /*is_ambiguous_... S20643C8::S20643C6 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C8*)(S20643C4*)(S20643C2*), ABISELECT(17208,12920), "S20643C1");
    check_base_class_offset(lv, (S20643C6*)(S20643C9*)(S20643C8*)(S20643C4*)(S20643C2*), ABISELECT(17208,12920), "S20643C1");
    /*is_ambiguous_... S20643C4::S20643C9 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C9*)(S20643C4*)(S20643C2*), ABISELECT(17208,12920), "S20643C1");
    /*is_ambiguous_... S20643C11::S20643C6 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C11*)(S20643C10*), ABISELECT(17208,12920), "S20643C1");
    /*is_ambiguous_... S20643C1::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C8*), ABISELECT(17208,12920), "S20643C1");
    /*is_ambiguous_... S20643C1::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C9*)(S20643C8*), ABISELECT(17208,12920), "S20643C1");
    /*is_ambiguous_... S20643C2::S20643C11 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C11*)(S20643C2*), ABISELECT(17208,12920), "S20643C1");
    /*is_ambiguous_... S20643C8::S20643C6 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C8*)(S20643C14*)(S20643C12*), ABISELECT(17208,12920), "S20643C1");
    check_base_class_offset(lv, (S20643C6*)(S20643C9*)(S20643C8*)(S20643C14*)(S20643C12*), ABISELECT(17208,12920), "S20643C1");
    /*is_ambiguous_... S20643C14::S20643C9 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C9*)(S20643C14*)(S20643C12*), ABISELECT(17208,12920), "S20643C1");
    check_base_class_offset(lv, (S20643C9*)(S20643C8*)(S20643C4*)(S20643C2*), ABISELECT(12720,9572), "S20643C1");
    check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*)(S20643C8*)(S20643C4*)(S20643C2*), ABISELECT(12872,9680), "S20643C1");
    check_base_class_offset(lv, (S20643C6*)(S20643C5*)(S20643C8*)(S20643C4*)(S20643C2*), ABISELECT(12864,9676), "S20643C1");
    check_base_class_offset(lv, (S20643C5*)(S20643C8*)(S20643C4*)(S20643C2*), ABISELECT(12864,9676), "S20643C1");
    check_base_class_offset(lv, (S20643C8*)(S20643C4*)(S20643C2*), ABISELECT(12720,9572), "S20643C1");
    /*is_ambiguous_... S20643C4::S20643C9 */ AMB_check_base_class_offset(lv, (S20643C9*)(S20643C4*)(S20643C2*), ABISELECT(13280,10004), "S20643C1");
    check_base_class_offset(lv, (S20643C4*)(S20643C2*), ABISELECT(12592,9484), "S20643C1");
    /*is_ambiguous_... S20643C2::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*)(S20643C2*), ABISELECT(15560,11616), "S20643C1");
    /*is_ambiguous_... S20643C2::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C5*)(S20643C2*), ABISELECT(15552,11612), "S20643C1");
    /*is_ambiguous_... S20643C2::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C5*)(S20643C2*), ABISELECT(15552,11612), "S20643C1");
    check_base_class_offset(lv, (S20643C11*)(S20643C10*), ABISELECT(17264,12960), "S20643C1");
    /*is_ambiguous_... S20643C10::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C10*), ABISELECT(18592,14012), "S20643C1");
    /*is_ambiguous_... S20643C1::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C9*)(S20643C8*), ABISELECT(18752,14116), "S20643C1");
    /*is_ambiguous_... S20643C1::S20643C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*)(S20643C8*), ABISELECT(18904,14224), "S20643C1");
    /*is_ambiguous_... S20643C1::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C5*)(S20643C8*), ABISELECT(18896,14220), "S20643C1");
    /*is_ambiguous_... S20643C1::S20643C8 */ AMB_check_base_class_offset(lv, (S20643C5*)(S20643C8*), ABISELECT(18896,14220), "S20643C1");
    check_base_class_offset(lv, (S20643C8*)(S20643C10*), ABISELECT(18752,14116), "S20643C1");
    check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C7*)(S20643C10*), ABISELECT(18608,14020), "S20643C1");
    check_base_class_offset(lv, (S20643C6*)(S20643C7*)(S20643C10*), ABISELECT(18600,14016), "S20643C1");
    check_base_class_offset(lv, (S20643C7*)(S20643C10*), ABISELECT(18600,14016), "S20643C1");
    check_base_class_offset(lv, (S20643C10*)(S20643C2*), ABISELECT(17264,12960), "S20643C1");
    /*is_ambiguous_... S20643C2::S20643C11 */ AMB_check_base_class_offset(lv, (S20643C11*)(S20643C2*), ABISELECT(15696,11724), "S20643C1");
    check_base_class_offset(lv, (S20643C2*), ABISELECT(12592,9484), "S20643C1");
    check_base_class_offset(lv, (S20643C13*)(S20643C12*), 0, "S20643C1");
    /*is_ambiguous_... S20643C12::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*)(S20643C12*), ABISELECT(616,416), "S20643C1");
    /*is_ambiguous_... S20643C12::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C5*)(S20643C12*), ABISELECT(608,412), "S20643C1");
    /*is_ambiguous_... S20643C12::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C5*)(S20643C12*), ABISELECT(608,412), "S20643C1");
    check_base_class_offset(lv, (S20643C9*)(S20643C8*)(S20643C14*)(S20643C12*), ABISELECT(752,524), "S20643C1");
    check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*)(S20643C8*)(S20643C14*)(S20643C12*), ABISELECT(904,632), "S20643C1");
    check_base_class_offset(lv, (S20643C6*)(S20643C5*)(S20643C8*)(S20643C14*)(S20643C12*), ABISELECT(896,628), "S20643C1");
    check_base_class_offset(lv, (S20643C5*)(S20643C8*)(S20643C14*)(S20643C12*), ABISELECT(896,628), "S20643C1");
    check_base_class_offset(lv, (S20643C8*)(S20643C14*)(S20643C12*), ABISELECT(752,524), "S20643C1");
    /*is_ambiguous_... S20643C14::S20643C9 */ AMB_check_base_class_offset(lv, (S20643C9*)(S20643C14*)(S20643C12*), ABISELECT(1312,956), "S20643C1");
    /*is_ambiguous_... S20643C14::S20643C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20643C6*)(S20643C5*)(S20643C14*)(S20643C12*), ABISELECT(1464,1064), "S20643C1");
    /*is_ambiguous_... S20643C14::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C6*)(S20643C5*)(S20643C14*)(S20643C12*), ABISELECT(1456,1060), "S20643C1");
    /*is_ambiguous_... S20643C14::S20643C5 */ AMB_check_base_class_offset(lv, (S20643C5*)(S20643C14*)(S20643C12*), ABISELECT(1456,1060), "S20643C1");
    check_base_class_offset(lv, (S20643C14*)(S20643C12*), ABISELECT(752,524), "S20643C1");
    check_base_class_offset(lv, (S20643C12*), 0, "S20643C1");
    check_field_offset(lv, s20643c1f0, ABISELECT(1616,1188), "S20643C1.s20643c1f0");
    check_field_offset(lv, s20643c1f1, ABISELECT(4768,3472), "S20643C1.s20643c1f1");
    check_field_offset(lv, s20643c1f2, ABISELECT(4784,3476), "S20643C1.s20643c1f2");
    check_field_offset(lv, s20643c1f3, ABISELECT(12528,9436), "S20643C1.s20643c1f3");
    check_field_offset(lv, s20643c1f4, ABISELECT(12532,9440), "S20643C1.s20643c1f4");
    check_field_offset(lv, s20643c1f5, ABISELECT(12536,9444), "S20643C1.s20643c1f5");
    check_field_offset(lv, s20643c1f6, ABISELECT(12544,9448), "S20643C1.s20643c1f6");
    check_field_offset(lv, s20643c1f7, ABISELECT(12552,9452), "S20643C1.s20643c1f7");
    test_class_info(&lv, &cd_S20643C1);
    dp->~S20643C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20643C1(Test_S20643C1, "S20643C1", ABISELECT(19312,14548));

#else // __cplusplus

extern void _ZN8S20643C1C1Ev();
extern void _ZN8S20643C1D1Ev();
Name_Map name_map_S20643C1[] = {
  NSPAIR(_ZN8S20643C1C1Ev),
  NSPAIR(_ZN8S20643C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C7;
extern VTBL_ENTRY _ZTI8S20643C7[];
extern  VTBL_ENTRY _ZTV8S20643C7[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C9;
extern VTBL_ENTRY _ZTI8S20643C9[];
extern  VTBL_ENTRY _ZTV8S20643C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S20643C8;
extern VTBL_ENTRY _ZTI8S20643C8[];
extern  VTBL_ENTRY _ZTV8S20643C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C8[];
extern Class_Descriptor cd_S20643C9;
extern VTBL_ENTRY _ZTI8S20643C9[];
extern  VTBL_ENTRY _ZTV8S20643C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C9[];
extern Class_Descriptor cd_S20643C4;
extern VTBL_ENTRY _ZTI8S20643C4[];
extern  VTBL_ENTRY _ZTV8S20643C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C4[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S20643C11;
extern VTBL_ENTRY _ZTI9S20643C11[];
extern  VTBL_ENTRY _ZTV9S20643C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20643C11[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C9;
extern VTBL_ENTRY _ZTI8S20643C9[];
extern  VTBL_ENTRY _ZTV8S20643C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S20643C8;
extern VTBL_ENTRY _ZTI8S20643C8[];
extern  VTBL_ENTRY _ZTV8S20643C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C8[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C7;
extern VTBL_ENTRY _ZTI8S20643C7[];
extern  VTBL_ENTRY _ZTV8S20643C7[];
extern Class_Descriptor cd_S20643C10;
extern VTBL_ENTRY _ZTI9S20643C10[];
extern  VTBL_ENTRY _ZTV9S20643C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20643C10[];
extern Class_Descriptor cd_S20643C11;
extern VTBL_ENTRY _ZTI9S20643C11[];
extern  VTBL_ENTRY _ZTV9S20643C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20643C11[];
extern Class_Descriptor cd_S20643C2;
extern VTBL_ENTRY _ZTI8S20643C2[];
extern  VTBL_ENTRY _ZTV8S20643C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C2[];
extern Class_Descriptor cd_S20643C13;
extern VTBL_ENTRY _ZTI9S20643C13[];
extern  VTBL_ENTRY _ZTV9S20643C13[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S20643C9;
extern VTBL_ENTRY _ZTI8S20643C9[];
extern  VTBL_ENTRY _ZTV8S20643C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S20643C8;
extern VTBL_ENTRY _ZTI8S20643C8[];
extern  VTBL_ENTRY _ZTV8S20643C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C8[];
extern Class_Descriptor cd_S20643C9;
extern VTBL_ENTRY _ZTI8S20643C9[];
extern  VTBL_ENTRY _ZTV8S20643C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20643C6;
extern VTBL_ENTRY _ZTI8S20643C6[];
extern  VTBL_ENTRY _ZTV8S20643C6[];
extern Class_Descriptor cd_S20643C5;
extern VTBL_ENTRY _ZTI8S20643C5[];
extern  VTBL_ENTRY _ZTV8S20643C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C5[];
extern Class_Descriptor cd_S20643C14;
extern VTBL_ENTRY _ZTI9S20643C14[];
extern  VTBL_ENTRY _ZTV9S20643C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20643C14[];
extern Class_Descriptor cd_S20643C12;
extern VTBL_ENTRY _ZTI9S20643C12[];
extern  VTBL_ENTRY _ZTV9S20643C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20643C12[];
static Base_Class bases_S20643C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C8_nt,    ABISELECT(17056,12804), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S3216C8_nt,    ABISELECT(17080,12812), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(17072,12808), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(17072,12808), //bcp->offset
    96, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    71, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    15, //immediately_derived
  0, 1},
  {&cd_S3216C8_nt,    ABISELECT(12600,9488), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(12592,9484), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20643C7,    ABISELECT(12592,9484), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(17216,12924), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(17208,12920), //bcp->offset
    105, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S20643C9,    ABISELECT(12720,9572), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(12872,9680), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(12864,9676), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(12864,9676), //bcp->offset
    74, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    46, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20643C8,    ABISELECT(12720,9572), //bcp->offset
    68, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    43, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20643C9,    ABISELECT(13280,10004), //bcp->offset
    80, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    49, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20643C4,    ABISELECT(12592,9484), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    42, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(15560,11616), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(15552,11612), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(15552,11612), //bcp->offset
    85, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    56, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S20643C11,    ABISELECT(17264,12960), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    73, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(18592,14012), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S20643C9,    ABISELECT(18752,14116), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    81, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(18904,14224), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(18896,14220), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(18896,14220), //bcp->offset
    147, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    33, //bcp->index_in_construction_vtbl_array
    83, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S20643C8,    ABISELECT(18752,14116), //bcp->offset
    136, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    32, //bcp->index_in_construction_vtbl_array
    80, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    29, //immediately_derived
  0, 1},
  {&cd_S3216C8_nt,    ABISELECT(18608,14020), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(18600,14016), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S20643C7,    ABISELECT(18600,14016), //bcp->offset
    128, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    34, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S20643C10,    ABISELECT(17264,12960), //bcp->offset
    113, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    72, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    31, //immediately_derived
  0, 1},
  {&cd_S20643C11,    ABISELECT(15696,11724), //bcp->offset
    91, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    35, //bcp->index_in_construction_vtbl_array
    57, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S20643C2,    ABISELECT(12592,9484), //bcp->offset
    42, //bcp->virtual_function_table_offset
    17, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    41, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20643C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    46, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(616,416), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(608,412), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(608,412), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    36, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    46, //immediately_derived
  0, 0},
  {&cd_S20643C9,    ABISELECT(752,524), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    40, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(904,632), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(896,628), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(896,628), //bcp->offset
    25, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    38, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    40, //immediately_derived
  0, 0},
  {&cd_S20643C8,    ABISELECT(752,524), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    45, //immediately_derived
  0, 0},
  {&cd_S20643C9,    ABISELECT(1312,956), //bcp->offset
    31, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    39, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    45, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(1464,1064), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S20643C6,    ABISELECT(1456,1060), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S20643C5,    ABISELECT(1456,1060), //bcp->offset
    36, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    40, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    45, //immediately_derived
  0, 0},
  {&cd_S20643C14,    ABISELECT(752,524), //bcp->offset
    18, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    37, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    46, //immediately_derived
  0, 0},
  {&cd_S20643C12,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20643C1[];
extern void _ZN9S20643C133v12Ev();
extern void _ZN8S20643C1D1Ev();
extern void _ZN8S20643C1D0Ev();
extern void _ZN8S20643C12v1Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
extern void _ZN9S20643C143v13Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void ABISELECT(_ZTv0_n88_N8S20643C1D1Ev,_ZTv0_n44_N8S20643C1D1Ev)();
extern void ABISELECT(_ZThn12592_N8S20643C1D1Ev,_ZThn9484_N8S20643C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n88_N8S20643C1D0Ev,_ZTv0_n44_N8S20643C1D0Ev)();
extern void ABISELECT(_ZThn12592_N8S20643C1D0Ev,_ZThn9484_N8S20643C1D0Ev)() __attribute__((weak));
extern void _ZN8S20643C72v5Ev();
extern void _ZN8S20643C42v8Ev();
extern void _ZN8S20643C23v10Ev();
extern void _ZN8S20643C23v11Ev();
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void ABISELECT(_ZTv0_n56_N8S20643C1D1Ev,_ZTv0_n28_N8S20643C1D1Ev)();
extern void ABISELECT(_ZThn17264_N8S20643C1D1Ev,_ZThn12960_N8S20643C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S20643C1D0Ev,_ZTv0_n28_N8S20643C1D0Ev)();
extern void ABISELECT(_ZThn17264_N8S20643C1D0Ev,_ZThn12960_N8S20643C1D0Ev)() __attribute__((weak));
extern void _ZN9S20643C102v9Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void ABISELECT(_ZTvn1336_n56_N8S20643C1D1Ev,_ZTvn1056_n28_N8S20643C1D1Ev)();
extern void ABISELECT(_ZTvn1336_n56_N8S20643C1D0Ev,_ZTvn1056_n28_N8S20643C1D0Ev)();
extern void _ZN8S20643C72v5Ev();
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY vtc_S20643C1[] = {
  ABISELECT(18752,14116),
  ABISELECT(17264,12960),
  ABISELECT(17072,12808),
  ABISELECT(12592,9484),
  ABISELECT(17208,12920),
  ABISELECT(17056,12804),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C1[0]),
  (VTBL_ENTRY)&_ZN9S20643C133v12Ev,
  (VTBL_ENTRY)&_ZN8S20643C1D1Ev,
  (VTBL_ENTRY)&_ZN8S20643C1D0Ev,
  (VTBL_ENTRY)&_ZN8S20643C12v1Ev,
  ABISELECT(16448,12392),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI8S20643C1[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  ABISELECT(16304,12280),
  ABISELECT(16456,12396),
  ABISELECT(-752,-524),
  (VTBL_ENTRY)&(_ZTI8S20643C1[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20643C143v13Ev,
  ABISELECT(16160,12176),
  ABISELECT(-896,-628),
  (VTBL_ENTRY)&(_ZTI8S20643C1[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  ABISELECT(15744,11848),
  ABISELECT(15896,11964),
  ABISELECT(-1312,-956),
  (VTBL_ENTRY)&(_ZTI8S20643C1[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  ABISELECT(15600,11744),
  ABISELECT(-1456,-1060),
  (VTBL_ENTRY)&(_ZTI8S20643C1[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  0,
  0,
  ABISELECT(128,88),
  ABISELECT(128,88),
  0,
  0,
  ABISELECT(-12592,-9484),
  0,
  0,
  0,
  ABISELECT(6160,4632),
  ABISELECT(4672,3476),
  ABISELECT(4616,3436),
  ABISELECT(4464,3320),
  ABISELECT(4480,3324),
  ABISELECT(-12592,-9484),
  (VTBL_ENTRY)&(_ZTI8S20643C1[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n88_N8S20643C1D1Ev,_ZTv0_n44_N8S20643C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n88_N8S20643C1D0Ev,_ZTv0_n44_N8S20643C1D0Ev),
  (VTBL_ENTRY)&_ZN8S20643C72v5Ev,
  (VTBL_ENTRY)&_ZN8S20643C42v8Ev,
  (VTBL_ENTRY)&_ZN8S20643C23v10Ev,
  (VTBL_ENTRY)&_ZN8S20643C23v11Ev,
  ABISELECT(4336,3232),
  ABISELECT(4488,3348),
  ABISELECT(-12720,-9572),
  (VTBL_ENTRY)&(_ZTI8S20643C1[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
  ABISELECT(4192,3128),
  ABISELECT(-12864,-9676),
  (VTBL_ENTRY)&(_ZTI8S20643C1[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  ABISELECT(3776,2800),
  ABISELECT(3928,2916),
  ABISELECT(-13280,-10004),
  (VTBL_ENTRY)&(_ZTI8S20643C1[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  ABISELECT(1504,1192),
  ABISELECT(-15552,-11612),
  (VTBL_ENTRY)&(_ZTI8S20643C1[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  ABISELECT(1376,1084),
  ABISELECT(1512,1196),
  ABISELECT(1360,1080),
  ABISELECT(-15696,-11724),
  (VTBL_ENTRY)&(_ZTI8S20643C1[0]),
  0,
  0,
  0,
  ABISELECT(-16,-4),
  ABISELECT(-17072,-12808),
  (VTBL_ENTRY)&(_ZTI8S20643C1[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  0,
  0,
  0,
  ABISELECT(-17208,-12920),
  (VTBL_ENTRY)&(_ZTI8S20643C1[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  0,
  ABISELECT(-17264,-12960),
  ABISELECT(1488,1156),
  ABISELECT(-192,-152),
  ABISELECT(-56,-40),
  ABISELECT(-208,-156),
  ABISELECT(-17264,-12960),
  (VTBL_ENTRY)&(_ZTI8S20643C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S20643C1D1Ev,_ZTv0_n28_N8S20643C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S20643C1D0Ev,_ZTv0_n28_N8S20643C1D0Ev),
  (VTBL_ENTRY)&_ZN9S20643C102v9Ev,
  ABISELECT(-18600,-14016),
  (VTBL_ENTRY)&(_ZTI8S20643C1[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn1336_n56_N8S20643C1D1Ev,_ZTvn1056_n28_N8S20643C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1336_n56_N8S20643C1D0Ev,_ZTvn1056_n28_N8S20643C1D0Ev),
  (VTBL_ENTRY)&_ZN8S20643C72v5Ev,
  ABISELECT(144,104),
  ABISELECT(144,104),
  ABISELECT(144,104),
  0,
  0,
  ABISELECT(-1696,-1312),
  ABISELECT(-1544,-1196),
  ABISELECT(-18752,-14116),
  (VTBL_ENTRY)&(_ZTI8S20643C1[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
  ABISELECT(-1840,-1416),
  ABISELECT(-18896,-14220),
  (VTBL_ENTRY)&(_ZTI8S20643C1[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern VTBL_ENTRY _ZTV8S20643C1[];
extern void _ZN9S20643C133v12Ev();
extern void _ZN9S20643C12D1Ev();
extern void _ZN9S20643C12D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20643C12__8S20643C1[] = {
  ABISELECT(17208,12920),
  ABISELECT(17056,12804),
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C12[0]),
  (VTBL_ENTRY)&_ZN9S20643C133v12Ev,
  (VTBL_ENTRY)&_ZN9S20643C12D1Ev,
  (VTBL_ENTRY)&_ZN9S20643C12D0Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C59S20643C12__A4__8S20643C1[] = {
  ABISELECT(16448,12392),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
extern void _ZN9S20643C143v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20643C149S20643C12__8S20643C1[] = {
  ABISELECT(16304,12280),
  ABISELECT(16456,12396),
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C14[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20643C143v13Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C89S20643C149S20643C12__A2__8S20643C1[] = {
  ABISELECT(16304,12280),
  ABISELECT(16456,12396),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C98S20643C89S20643C149S20643C12__A3__8S20643C1[] = {
  ABISELECT(16304,12280),
  ABISELECT(16456,12396),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C98S20643C89S20643C149S20643C12__A3__8S20643C1[] = {
  0,
  0,
  0,
  ABISELECT(-16456,-12396),
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C89S20643C149S20643C12__A5__8S20643C1[] = {
  ABISELECT(16160,12176),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C89S20643C149S20643C12__A2__8S20643C1[] = {
  0,
  0,
  0,
  ABISELECT(-16456,-12396),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__8S20643C89S20643C149S20643C12__A2__8S20643C1[] = {
  ABISELECT(16160,12176),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C99S20643C149S20643C12__A4__8S20643C1[] = {
  ABISELECT(15744,11848),
  ABISELECT(15896,11964),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C99S20643C149S20643C12__A4__8S20643C1[] = {
  0,
  0,
  0,
  ABISELECT(-15896,-11964),
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C59S20643C149S20643C12__A6__8S20643C1[] = {
  ABISELECT(15600,11744),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__9S20643C149S20643C12__8S20643C1[] = {
  0,
  0,
  0,
  ABISELECT(-16456,-12396),
  (VTBL_ENTRY)&(_ZTI9S20643C14[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C8__9S20643C149S20643C12__8S20643C1[] = {
  ABISELECT(16160,12176),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI9S20643C14[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C9__A1__9S20643C149S20643C12__8S20643C1[] = {
  ABISELECT(15744,11848),
  ABISELECT(15896,11964),
  ABISELECT(-560,-432),
  (VTBL_ENTRY)&(_ZTI9S20643C14[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__A1__9S20643C149S20643C12__8S20643C1[] = {
  ABISELECT(15600,11744),
  ABISELECT(-704,-536),
  (VTBL_ENTRY)&(_ZTI9S20643C14[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__9S20643C12__8S20643C1[] = {
  ABISELECT(16448,12392),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI9S20643C12[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
extern void _ZN9S20643C143v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20643C14__9S20643C12__8S20643C1[] = {
  ABISELECT(16304,12280),
  ABISELECT(16456,12396),
  ABISELECT(-752,-524),
  (VTBL_ENTRY)&(_ZTI9S20643C12[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20643C143v13Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__A1__9S20643C12__8S20643C1[] = {
  0,
  0,
  0,
  ABISELECT(-17208,-12920),
  (VTBL_ENTRY)&(_ZTI9S20643C12[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C89S20643C14__A1__9S20643C12__8S20643C1[] = {
  ABISELECT(16160,12176),
  ABISELECT(-896,-628),
  (VTBL_ENTRY)&(_ZTI9S20643C12[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C99S20643C14__A1__9S20643C12__8S20643C1[] = {
  ABISELECT(15744,11848),
  ABISELECT(15896,11964),
  ABISELECT(-1312,-956),
  (VTBL_ENTRY)&(_ZTI9S20643C12[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C59S20643C14__A2__9S20643C12__8S20643C1[] = {
  ABISELECT(15600,11744),
  ABISELECT(-1456,-1060),
  (VTBL_ENTRY)&(_ZTI9S20643C12[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C2D1Ev();
extern void _ZN8S20643C2D0Ev();
extern void _ZN8S20643C72v5Ev();
extern void _ZN8S20643C42v8Ev();
extern void _ZN8S20643C23v10Ev();
extern void _ZN8S20643C23v11Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C2__8S20643C1[] = {
  ABISELECT(6160,4632),
  ABISELECT(4672,3476),
  ABISELECT(4616,3436),
  ABISELECT(4464,3320),
  ABISELECT(4480,3324),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C2[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20643C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20643C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20643C72v5Ev,
  (VTBL_ENTRY)&_ZN8S20643C42v8Ev,
  (VTBL_ENTRY)&_ZN8S20643C23v10Ev,
  (VTBL_ENTRY)&_ZN8S20643C23v11Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void _ZN8S20643C4D1Ev();
extern void _ZN8S20643C4D0Ev();
extern void _ZN8S20643C72v5Ev();
extern void _ZN8S20643C42v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C48S20643C2__8S20643C1[] = {
  ABISELECT(4616,3436),
  ABISELECT(4464,3320),
  ABISELECT(4480,3324),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C4[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20643C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20643C4D0Ev,
  (VTBL_ENTRY)&_ZN8S20643C72v5Ev,
  (VTBL_ENTRY)&_ZN8S20643C42v8Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C88S20643C48S20643C2__8S20643C1[] = {
  ABISELECT(4336,3232),
  ABISELECT(4488,3348),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C98S20643C88S20643C48S20643C2__8S20643C1[] = {
  ABISELECT(4336,3232),
  ABISELECT(4488,3348),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C98S20643C88S20643C48S20643C2__8S20643C1[] = {
  0,
  0,
  0,
  ABISELECT(-4488,-3348),
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C88S20643C48S20643C2__A1__8S20643C1[] = {
  ABISELECT(4192,3128),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C88S20643C48S20643C2__8S20643C1[] = {
  0,
  0,
  0,
  ABISELECT(-4488,-3348),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__8S20643C88S20643C48S20643C2__8S20643C1[] = {
  ABISELECT(4192,3128),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C98S20643C48S20643C2__A1__8S20643C1[] = {
  ABISELECT(3776,2800),
  ABISELECT(3928,2916),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C98S20643C48S20643C2__A1__8S20643C1[] = {
  0,
  0,
  0,
  ABISELECT(-3928,-2916),
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__8S20643C48S20643C2__8S20643C1[] = {
  0,
  0,
  0,
  ABISELECT(-16,-4),
  ABISELECT(-4480,-3324),
  (VTBL_ENTRY)&(_ZTI8S20643C4[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__A2__8S20643C48S20643C2__8S20643C1[] = {
  0,
  0,
  0,
  ABISELECT(-4616,-3436),
  (VTBL_ENTRY)&(_ZTI8S20643C4[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C8__8S20643C48S20643C2__8S20643C1[] = {
  ABISELECT(4336,3232),
  ABISELECT(4488,3348),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S20643C4[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C8__A1__8S20643C48S20643C2__8S20643C1[] = {
  ABISELECT(4192,3128),
  ABISELECT(-272,-192),
  (VTBL_ENTRY)&(_ZTI8S20643C4[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C9__A1__8S20643C48S20643C2__8S20643C1[] = {
  ABISELECT(3776,2800),
  ABISELECT(3928,2916),
  ABISELECT(-688,-520),
  (VTBL_ENTRY)&(_ZTI8S20643C4[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C2__A2__8S20643C1[] = {
  ABISELECT(1504,1192),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20643C118S20643C2__A1__8S20643C1[] = {
  ABISELECT(1376,1084),
  ABISELECT(1512,1196),
  ABISELECT(1360,1080),
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__9S20643C118S20643C2__A1__8S20643C1[] = {
  0,
  0,
  0,
  ABISELECT(-1512,-1196),
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__9S20643C118S20643C2__A1__8S20643C1[] = {
  0,
  0,
  0,
  ABISELECT(-16,-4),
  ABISELECT(-1376,-1084),
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__8S20643C2__8S20643C1[] = {
  0,
  0,
  0,
  ABISELECT(-16,-4),
  ABISELECT(-4480,-3324),
  (VTBL_ENTRY)&(_ZTI8S20643C2[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__A2__8S20643C2__8S20643C1[] = {
  0,
  0,
  0,
  ABISELECT(-4616,-3436),
  (VTBL_ENTRY)&(_ZTI8S20643C2[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C88S20643C4__8S20643C2__8S20643C1[] = {
  ABISELECT(4336,3232),
  ABISELECT(4488,3348),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S20643C2[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C88S20643C4__A1__8S20643C2__8S20643C1[] = {
  ABISELECT(4192,3128),
  ABISELECT(-272,-192),
  (VTBL_ENTRY)&(_ZTI8S20643C2[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C98S20643C4__A1__8S20643C2__8S20643C1[] = {
  ABISELECT(3776,2800),
  ABISELECT(3928,2916),
  ABISELECT(-688,-520),
  (VTBL_ENTRY)&(_ZTI8S20643C2[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__A__8S20643C2__8S20643C1[] = {
  ABISELECT(1504,1192),
  ABISELECT(-2960,-2128),
  (VTBL_ENTRY)&(_ZTI8S20643C2[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S20643C2D1Ev,_ZTv0_n28_N8S20643C2D1Ev)();
extern void ABISELECT(_ZThn4672_N8S20643C2D1Ev,_ZThn3476_N8S20643C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S20643C2D0Ev,_ZTv0_n28_N8S20643C2D0Ev)();
extern void ABISELECT(_ZThn4672_N8S20643C2D0Ev,_ZThn3476_N8S20643C2D0Ev)() __attribute__((weak));
extern void _ZN9S20643C102v9Ev();
static  VTBL_ENTRY _tg__ZTV9S20643C10__8S20643C2__8S20643C1[] = {
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  0,
  ABISELECT(-4672,-3476),
  ABISELECT(1488,1156),
  ABISELECT(-192,-152),
  ABISELECT(-56,-40),
  ABISELECT(-208,-156),
  ABISELECT(-4672,-3476),
  (VTBL_ENTRY)&(_ZTI8S20643C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S20643C2D1Ev,_ZTv0_n28_N8S20643C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S20643C2D0Ev,_ZTv0_n28_N8S20643C2D0Ev),
  (VTBL_ENTRY)&_ZN9S20643C102v9Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C8__A1__8S20643C2__8S20643C1[] = {
  ABISELECT(144,104),
  ABISELECT(144,104),
  ABISELECT(144,104),
  0,
  0,
  ABISELECT(-1696,-1312),
  ABISELECT(-1544,-1196),
  ABISELECT(-6160,-4632),
  (VTBL_ENTRY)&(_ZTI8S20643C2[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C8__A3__8S20643C2__8S20643C1[] = {
  ABISELECT(-1840,-1416),
  ABISELECT(-6304,-4736),
  (VTBL_ENTRY)&(_ZTI8S20643C2[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
extern void ABISELECT(_ZTvn1336_n56_N8S20643C2D1Ev,_ZTvn1056_n28_N8S20643C2D1Ev)();
extern void ABISELECT(_ZTvn1336_n56_N8S20643C2D0Ev,_ZTvn1056_n28_N8S20643C2D0Ev)();
extern void _ZN8S20643C72v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C79S20643C10__A1__8S20643C2__8S20643C1[] = {
  ABISELECT(-6008,-4532),
  (VTBL_ENTRY)&(_ZTI8S20643C2[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn1336_n56_N8S20643C2D1Ev,_ZTvn1056_n28_N8S20643C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1336_n56_N8S20643C2D0Ev,_ZTvn1056_n28_N8S20643C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20643C72v5Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20643C11__A1__8S20643C2__8S20643C1[] = {
  ABISELECT(1376,1084),
  ABISELECT(1512,1196),
  ABISELECT(1360,1080),
  ABISELECT(-3104,-2240),
  (VTBL_ENTRY)&(_ZTI8S20643C2[0]),
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__8S20643C1[] = {
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN9S20643C10D1Ev();
extern void _ZN9S20643C10D0Ev();
extern void _ZN9S20643C102v9Ev();
static  VTBL_ENTRY _tg__ZTV9S20643C10__8S20643C1[] = {
  ABISELECT(1488,1156),
  ABISELECT(-192,-152),
  ABISELECT(-56,-40),
  ABISELECT(-208,-156),
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN9S20643C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20643C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20643C102v9Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20643C119S20643C10__8S20643C1[] = {
  ABISELECT(-192,-152),
  ABISELECT(-56,-40),
  ABISELECT(-208,-156),
  0,
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__9S20643C119S20643C10__8S20643C1[] = {
  0,
  0,
  0,
  ABISELECT(56,40),
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__9S20643C119S20643C10__8S20643C1[] = {
  0,
  0,
  0,
  ABISELECT(-16,-4),
  ABISELECT(192,152),
  (VTBL_ENTRY)&(_ZTI9S20643C11[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__9S20643C10__8S20643C1[] = {
  0,
  0,
  0,
  ABISELECT(56,40),
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__9S20643C10__8S20643C1[] = {
  0,
  0,
  0,
  ABISELECT(-16,-4),
  ABISELECT(192,152),
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C8__9S20643C10__8S20643C1[] = {
  ABISELECT(144,104),
  ABISELECT(144,104),
  ABISELECT(144,104),
  0,
  0,
  ABISELECT(-1696,-1312),
  ABISELECT(-1544,-1196),
  ABISELECT(-1488,-1156),
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C8__A1__9S20643C10__8S20643C1[] = {
  ABISELECT(-1840,-1416),
  ABISELECT(-1632,-1260),
  (VTBL_ENTRY)&(_ZTI9S20643C10[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C92v6Ev();
extern void _ZN8S20643C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C8__A1__8S20643C1[] = {
  ABISELECT(-1696,-1312),
  ABISELECT(-1544,-1196),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20643C82v7Ev,
};
extern void _ZN8S20643C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C98S20643C8__A2__8S20643C1[] = {
  ABISELECT(-1696,-1312),
  ABISELECT(-1544,-1196),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C92v6Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C98S20643C8__A2__8S20643C1[] = {
  0,
  0,
  0,
  ABISELECT(1544,1196),
  (VTBL_ENTRY)&(_ZTI8S20643C9[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C58S20643C8__A3__8S20643C1[] = {
  ABISELECT(-1840,-1416),
  0,
  (VTBL_ENTRY)&(_ZTI8S20643C5[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C6__8S20643C8__A1__8S20643C1[] = {
  0,
  0,
  0,
  ABISELECT(1544,1196),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
extern void _ZN8S20643C62v2Ev();
extern void _ZN8S20643C62v3Ev();
extern void _ZN8S20643C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20643C5__8S20643C8__A1__8S20643C1[] = {
  ABISELECT(-1840,-1416),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20643C8[0]),
  (VTBL_ENTRY)&_ZN8S20643C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20643C62v4Ev,
};
static  VTT_ENTRY vtt_S20643C1[] = {
  {&(_ZTV8S20643C1[8]),  8,153},
  {&(_tg__ZTV9S20643C12__8S20643C1[4]),  4,7},
  {&(_tg__ZTV8S20643C59S20643C12__A4__8S20643C1[3]),  3,6},
  {&(_tg__ZTV9S20643C149S20643C12__8S20643C1[4]),  4,7},
  {&(_tg__ZTV8S20643C89S20643C149S20643C12__A2__8S20643C1[4]),  4,6},
  {&(_tg__ZTV8S20643C98S20643C89S20643C149S20643C12__A3__8S20643C1[4]),  4,5},
  {&(_tg__ZTV8S20643C6__8S20643C98S20643C89S20643C149S20643C12__A3__8S20643C1[5]),  5,8},
  {&(_tg__ZTV8S20643C58S20643C89S20643C149S20643C12__A5__8S20643C1[3]),  3,6},
  {&(_tg__ZTV8S20643C6__8S20643C89S20643C149S20643C12__A2__8S20643C1[5]),  5,8},
  {&(_tg__ZTV8S20643C5__8S20643C89S20643C149S20643C12__A2__8S20643C1[3]),  3,6},
  {&(_tg__ZTV8S20643C99S20643C149S20643C12__A4__8S20643C1[4]),  4,5},
  {&(_tg__ZTV8S20643C6__8S20643C99S20643C149S20643C12__A4__8S20643C1[5]),  5,8},
  {&(_tg__ZTV8S20643C59S20643C149S20643C12__A6__8S20643C1[3]),  3,6},
  {&(_tg__ZTV8S20643C6__9S20643C149S20643C12__8S20643C1[5]),  5,8},
  {&(_tg__ZTV8S20643C58S20643C8__9S20643C149S20643C12__8S20643C1[3]),  3,6},
  {&(_tg__ZTV8S20643C9__A1__9S20643C149S20643C12__8S20643C1[4]),  4,5},
  {&(_tg__ZTV8S20643C5__A1__9S20643C149S20643C12__8S20643C1[3]),  3,6},
  {&(_tg__ZTV8S20643C5__9S20643C12__8S20643C1[3]),  3,6},
  {&(_tg__ZTV9S20643C14__9S20643C12__8S20643C1[4]),  4,7},
  {&(_tg__ZTV8S20643C6__A1__9S20643C12__8S20643C1[5]),  5,8},
  {&(_tg__ZTV8S20643C58S20643C89S20643C14__A1__9S20643C12__8S20643C1[3]),  3,6},
  {&(_tg__ZTV8S20643C99S20643C14__A1__9S20643C12__8S20643C1[4]),  4,5},
  {&(_tg__ZTV8S20643C59S20643C14__A2__9S20643C12__8S20643C1[3]),  3,6},
  {&(_ZTV8S20643C1[59]),  59,153},
  {&(_ZTV8S20643C1[102]),  102,153},
  {&(_ZTV8S20643C1[110]),  110,153},
  {&(_ZTV8S20643C1[72]),  72,153},
  {&(_ZTV8S20643C1[77]),  77,153},
  {&(_ZTV8S20643C1[84]),  84,153},
  {&(_ZTV8S20643C1[88]),  88,153},
  {&(_ZTV8S20643C1[125]),  125,153},
  {&(_ZTV8S20643C1[145]),  145,153},
  {&(_ZTV8S20643C1[150]),  150,153},
  {&(_ZTV8S20643C1[130]),  130,153},
  {&(_ZTV8S20643C1[96]),  96,153},
  {&(_ZTV8S20643C1[15]),  15,153},
  {&(_ZTV8S20643C1[22]),  22,153},
  {&(_ZTV8S20643C1[28]),  28,153},
  {&(_ZTV8S20643C1[35]),  35,153},
  {&(_ZTV8S20643C1[39]),  39,153},
  {&(_tg__ZTV8S20643C2__8S20643C1[7]),  7,16},
  {&(_tg__ZTV8S20643C48S20643C2__8S20643C1[5]),  5,12},
  {&(_tg__ZTV8S20643C88S20643C48S20643C2__8S20643C1[4]),  4,6},
  {&(_tg__ZTV8S20643C98S20643C88S20643C48S20643C2__8S20643C1[4]),  4,5},
  {&(_tg__ZTV8S20643C6__8S20643C98S20643C88S20643C48S20643C2__8S20643C1[5]),  5,8},
  {&(_tg__ZTV8S20643C58S20643C88S20643C48S20643C2__A1__8S20643C1[3]),  3,6},
  {&(_tg__ZTV8S20643C6__8S20643C88S20643C48S20643C2__8S20643C1[5]),  5,8},
  {&(_tg__ZTV8S20643C5__8S20643C88S20643C48S20643C2__8S20643C1[3]),  3,6},
  {&(_tg__ZTV8S20643C98S20643C48S20643C2__A1__8S20643C1[4]),  4,5},
  {&(_tg__ZTV8S20643C6__8S20643C98S20643C48S20643C2__A1__8S20643C1[5]),  5,8},
  {&(_tg__ZTV8S20643C5__8S20643C48S20643C2__8S20643C1[6]),  6,9},
  {&(_tg__ZTV8S20643C6__A2__8S20643C48S20643C2__8S20643C1[5]),  5,8},
  {&(_tg__ZTV8S20643C8__8S20643C48S20643C2__8S20643C1[4]),  4,6},
  {&(_tg__ZTV8S20643C58S20643C8__A1__8S20643C48S20643C2__8S20643C1[3]),  3,6},
  {&(_tg__ZTV8S20643C9__A1__8S20643C48S20643C2__8S20643C1[4]),  4,5},
  {&(_tg__ZTV8S20643C58S20643C2__A2__8S20643C1[3]),  3,6},
  {&(_tg__ZTV9S20643C118S20643C2__A1__8S20643C1[5]),  5,5},
  {&(_tg__ZTV8S20643C6__9S20643C118S20643C2__A1__8S20643C1[5]),  5,8},
  {&(_tg__ZTV8S20643C5__9S20643C118S20643C2__A1__8S20643C1[6]),  6,9},
  {&(_tg__ZTV8S20643C5__8S20643C2__8S20643C1[6]),  6,9},
  {&(_tg__ZTV8S20643C6__A2__8S20643C2__8S20643C1[5]),  5,8},
  {&(_tg__ZTV8S20643C88S20643C4__8S20643C2__8S20643C1[4]),  4,6},
  {&(_tg__ZTV8S20643C58S20643C88S20643C4__A1__8S20643C2__8S20643C1[3]),  3,6},
  {&(_tg__ZTV8S20643C98S20643C4__A1__8S20643C2__8S20643C1[4]),  4,5},
  {&(_tg__ZTV8S20643C5__A__8S20643C2__8S20643C1[3]),  3,6},
  {&(_tg__ZTV9S20643C10__8S20643C2__8S20643C1[12]),  12,15},
  {&(_tg__ZTV8S20643C8__A1__8S20643C2__8S20643C1[9]),  9,11},
  {&(_tg__ZTV8S20643C58S20643C8__A3__8S20643C2__8S20643C1[3]),  3,6},
  {&(_tg__ZTV8S20643C79S20643C10__A1__8S20643C2__8S20643C1[2]),  2,8},
  {&(_tg__ZTV9S20643C11__A1__8S20643C2__8S20643C1[5]),  5,5},
  {&(_tg__ZTV8S20643C5__8S20643C1[3]),  3,6},
  {&(_tg__ZTV9S20643C10__8S20643C1[6]),  6,9},
  {&(_tg__ZTV9S20643C119S20643C10__8S20643C1[5]),  5,5},
  {&(_tg__ZTV8S20643C6__9S20643C119S20643C10__8S20643C1[5]),  5,8},
  {&(_tg__ZTV8S20643C5__9S20643C119S20643C10__8S20643C1[6]),  6,9},
  {&(_tg__ZTV8S20643C6__9S20643C10__8S20643C1[5]),  5,8},
  {&(_tg__ZTV8S20643C5__9S20643C10__8S20643C1[6]),  6,9},
  {&(_tg__ZTV8S20643C8__9S20643C10__8S20643C1[9]),  9,11},
  {&(_tg__ZTV8S20643C58S20643C8__A1__9S20643C10__8S20643C1[3]),  3,6},
  {&(_tg__ZTV8S20643C8__A1__8S20643C1[4]),  4,6},
  {&(_tg__ZTV8S20643C98S20643C8__A2__8S20643C1[4]),  4,5},
  {&(_tg__ZTV8S20643C6__8S20643C98S20643C8__A2__8S20643C1[5]),  5,8},
  {&(_tg__ZTV8S20643C58S20643C8__A3__8S20643C1[3]),  3,6},
  {&(_tg__ZTV8S20643C6__8S20643C8__A1__8S20643C1[5]),  5,8},
  {&(_tg__ZTV8S20643C5__8S20643C8__A1__8S20643C1[3]),  3,6},
};
extern VTBL_ENTRY _ZTI8S20643C1[];
extern  VTBL_ENTRY _ZTV8S20643C1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20643C1[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S20643C2D0Ev,_ZTv0_n28_N8S20643C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4672_N8S20643C2D0Ev,_ZThn3476_N8S20643C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S20643C2D1Ev,_ZTv0_n28_N8S20643C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4672_N8S20643C2D1Ev,_ZThn3476_N8S20643C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S20643C1D0Ev,_ZTv0_n28_N8S20643C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17264_N8S20643C1D0Ev,_ZThn12960_N8S20643C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S20643C1D1Ev,_ZTv0_n28_N8S20643C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn17264_N8S20643C1D1Ev,_ZThn12960_N8S20643C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n88_N8S20643C1D0Ev,_ZTv0_n44_N8S20643C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12592_N8S20643C1D0Ev,_ZThn9484_N8S20643C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n88_N8S20643C1D1Ev,_ZTv0_n44_N8S20643C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn12592_N8S20643C1D1Ev,_ZThn9484_N8S20643C1D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20643C1 = {  "S20643C1", // class name
  bases_S20643C1, 47,
  &(vtc_S20643C1[0]), // expected_vtbl_contents
  &(vtt_S20643C1[0]), // expected_vtt_contents
  ABISELECT(19312,14548), // object size
  NSPAIRA(_ZTI8S20643C1),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S20643C1),153, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20643C1),85, //virtual table table var
  35, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20644C6  : S3216C8_nt {
  ::S3216C8_nt s20644c6f0[3];
  ::S3216C8_nt s20644c6f1[2];
  void *s20644c6f2;
  short s20644c6f3;
  ::S3216C8_nt s20644c6f4;
  virtual void  v2(); // _ZN8S20644C62v2Ev
  virtual void  v3(); // _ZN8S20644C62v3Ev
  virtual void  v4(); // _ZN8S20644C62v4Ev
  ~S20644C6(); // tgen
  S20644C6(); // tgen
};
//SIG(-1 S20644C6) C1{ BC2{ m Fi} v1 v2 v3 FC2[3] FC2[2] Fp Fs FC2}


void  S20644C6 ::v2(){vfunc_called(this, "_ZN8S20644C62v2Ev");}
void  S20644C6 ::v3(){vfunc_called(this, "_ZN8S20644C62v3Ev");}
void  S20644C6 ::v4(){vfunc_called(this, "_ZN8S20644C62v4Ev");}
S20644C6 ::~S20644C6(){ note_dtor("S20644C6", this);} // tgen
S20644C6 ::S20644C6(){ note_ctor("S20644C6", this);} // tgen

static void Test_S20644C6()
{
  extern Class_Descriptor cd_S20644C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(7,11)];
    init_test(&cd_S20644C6, buf);
    S20644C6 *dp, &lv = *(dp=new (buf) S20644C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(48,40), "sizeof(S20644C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20644C6)");
    check_base_class_offset(lv, (S3216C8_nt*), ABISELECT(8,4), "S20644C6");
    check_field_offset(lv, s20644c6f0, ABISELECT(12,8), "S20644C6.s20644c6f0");
    check_field_offset(lv, s20644c6f1, ABISELECT(24,20), "S20644C6.s20644c6f1");
    check_field_offset(lv, s20644c6f2, ABISELECT(32,28), "S20644C6.s20644c6f2");
    check_field_offset(lv, s20644c6f3, ABISELECT(40,32), "S20644C6.s20644c6f3");
    check_field_offset(lv, s20644c6f4, ABISELECT(44,36), "S20644C6.s20644c6f4");
    test_class_info(&lv, &cd_S20644C6);
    dp->~S20644C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20644C6(Test_S20644C6, "S20644C6", ABISELECT(48,40));

#else // __cplusplus

extern void _ZN8S20644C6C1Ev();
extern void _ZN8S20644C6D1Ev();
Name_Map name_map_S20644C6[] = {
  NSPAIR(_ZN8S20644C6C1Ev),
  NSPAIR(_ZN8S20644C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
static Base_Class bases_S20644C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C8_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20644C6[];
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY vtc_S20644C6[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C6[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
Class_Descriptor cd_S20644C6 = {  "S20644C6", // class name
  bases_S20644C6, 1,
  &(vtc_S20644C6[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(48,40), // object size
  NSPAIRA(_ZTI8S20644C6),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S20644C6),5, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20644C5  : S20644C6 , virtual S3216C8_nt {
  long double s20644c5f0;
  __tsi64 s20644c5f1;
  ::S20644C6 s20644c5f2;
  void *s20644c5f3;
  short s20644c5f4[3];
  ~S20644C5(); // tgen
  S20644C5(); // tgen
};
//SIG(-1 S20644C5) C1{ BC2{ BC3{ m Fi} v1 v2 v3 FC3[3] FC3[2] Fp Fs FC3} VBC3 FD FL FC2 Fp Fs[3]}


S20644C5 ::~S20644C5(){ note_dtor("S20644C5", this);} // tgen
S20644C5 ::S20644C5(){ note_ctor("S20644C5", this);} // tgen

static void Test_S20644C5()
{
  extern Class_Descriptor cd_S20644C5;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(10,30)];
    init_test(&cd_S20644C5, buf);
    S20644C5 *dp, &lv = *(dp=new (buf) S20644C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(144,116), "sizeof(S20644C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20644C5)");
    check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*), ABISELECT(8,4), "S20644C5");
    check_base_class_offset(lv, (S20644C6*), 0, "S20644C5");
    /*is_ambiguous_... S20644C5::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*), ABISELECT(136,112), "S20644C5");
    check_field_offset(lv, s20644c5f0, ABISELECT(48,40), "S20644C5.s20644c5f0");
    check_field_offset(lv, s20644c5f1, ABISELECT(64,52), "S20644C5.s20644c5f1");
    check_field_offset(lv, s20644c5f2, ABISELECT(72,60), "S20644C5.s20644c5f2");
    check_field_offset(lv, s20644c5f3, ABISELECT(120,100), "S20644C5.s20644c5f3");
    check_field_offset(lv, s20644c5f4, ABISELECT(128,104), "S20644C5.s20644c5f4");
    test_class_info(&lv, &cd_S20644C5);
    dp->~S20644C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20644C5(Test_S20644C5, "S20644C5", ABISELECT(144,116));

#else // __cplusplus

extern void _ZN8S20644C5C1Ev();
extern void _ZN8S20644C5D1Ev();
Name_Map name_map_S20644C5[] = {
  NSPAIR(_ZN8S20644C5C1Ev),
  NSPAIR(_ZN8S20644C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
static Base_Class bases_S20644C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C8_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20644C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3216C8_nt,    ABISELECT(136,112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20644C5[];
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY vtc_S20644C5[] = {
  ABISELECT(136,112),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern VTBL_ENTRY _ZTV8S20644C5[];
static  VTT_ENTRY vtt_S20644C5[] = {
  {&(_ZTV8S20644C5[3]),  3,6},
};
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
Class_Descriptor cd_S20644C5 = {  "S20644C5", // class name
  bases_S20644C5, 3,
  &(vtc_S20644C5[0]), // expected_vtbl_contents
  &(vtt_S20644C5[0]), // expected_vtt_contents
  ABISELECT(144,116), // object size
  NSPAIRA(_ZTI8S20644C5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S20644C5),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20644C5),1, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20644C7  : S20644C6 {
  void *s20644c7f0[7];
  int s20644c7f1[2];
  __tsi64 s20644c7f2;
  int s20644c7f3;
  virtual  ~S20644C7(); // _ZN8S20644C7D1Ev
  virtual void  v5(); // _ZN8S20644C72v5Ev
  S20644C7(); // tgen
};
//SIG(-1 S20644C7) C1{ BC2{ BC3{ m Fi} v2 v3 v4 FC3[3] FC3[2] Fp Fs FC3} vd v1 Fp[7] Fi[2] FL Fi}


 S20644C7 ::~S20644C7(){ note_dtor("S20644C7", this);}
void  S20644C7 ::v5(){vfunc_called(this, "_ZN8S20644C72v5Ev");}
S20644C7 ::S20644C7(){ note_ctor("S20644C7", this);} // tgen

static void Test_S20644C7()
{
  extern Class_Descriptor cd_S20644C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(17,23)];
    init_test(&cd_S20644C7, buf);
    S20644C7 *dp, &lv = *(dp=new (buf) S20644C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(128,88), "sizeof(S20644C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20644C7)");
    check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*), ABISELECT(8,4), "S20644C7");
    check_base_class_offset(lv, (S20644C6*), 0, "S20644C7");
    check_field_offset(lv, s20644c7f0, ABISELECT(48,40), "S20644C7.s20644c7f0");
    check_field_offset(lv, s20644c7f1, ABISELECT(104,68), "S20644C7.s20644c7f1");
    check_field_offset(lv, s20644c7f2, ABISELECT(112,76), "S20644C7.s20644c7f2");
    check_field_offset(lv, s20644c7f3, ABISELECT(120,84), "S20644C7.s20644c7f3");
    test_class_info(&lv, &cd_S20644C7);
    dp->~S20644C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20644C7(Test_S20644C7, "S20644C7", ABISELECT(128,88));

#else // __cplusplus

extern void _ZN8S20644C7C1Ev();
extern void _ZN8S20644C7D1Ev();
Name_Map name_map_S20644C7[] = {
  NSPAIR(_ZN8S20644C7C1Ev),
  NSPAIR(_ZN8S20644C7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
static Base_Class bases_S20644C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C8_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20644C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20644C7[];
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C7D1Ev();
extern void _ZN8S20644C7D0Ev();
extern void _ZN8S20644C72v5Ev();
static  VTBL_ENTRY vtc_S20644C7[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C7[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20644C7D1Ev,
  (VTBL_ENTRY)&_ZN8S20644C7D0Ev,
  (VTBL_ENTRY)&_ZN8S20644C72v5Ev,
};
extern VTBL_ENTRY _ZTI8S20644C7[];
extern  VTBL_ENTRY _ZTV8S20644C7[];
Class_Descriptor cd_S20644C7 = {  "S20644C7", // class name
  bases_S20644C7, 2,
  &(vtc_S20644C7[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(128,88), // object size
  NSPAIRA(_ZTI8S20644C7),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S20644C7),8, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20644C9  : virtual S20644C6 , virtual S3216C8_nt {
  ::S20644C6 s20644c9f0;
  long double s20644c9f1;
  void *s20644c9f2[2];
  ::S20644C6 s20644c9f3;
  virtual void  v6(); // _ZN8S20644C92v6Ev
  ~S20644C9(); // tgen
  S20644C9(); // tgen
};
//SIG(-1 S20644C9) C1{ VBC2{ BC3{ m Fi} v2 v3 v4 FC3[3] FC3[2] Fp Fs FC3} VBC3 v1 FC2 FD Fp[2] FC2}


void  S20644C9 ::v6(){vfunc_called(this, "_ZN8S20644C92v6Ev");}
S20644C9 ::~S20644C9(){ note_dtor("S20644C9", this);} // tgen
S20644C9 ::S20644C9(){ note_ctor("S20644C9", this);} // tgen

static void Test_S20644C9()
{
  extern Class_Descriptor cd_S20644C9;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(14,38)];
    init_test(&cd_S20644C9, buf);
    S20644C9 *dp, &lv = *(dp=new (buf) S20644C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(208,148), "sizeof(S20644C9)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20644C9)");
    check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*), ABISELECT(152,108), "S20644C9");
    check_base_class_offset(lv, (S20644C6*), ABISELECT(144,104), "S20644C9");
    /*is_ambiguous_... S20644C9::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*), ABISELECT(192,144), "S20644C9");
    check_field_offset(lv, s20644c9f0, ABISELECT(8,4), "S20644C9.s20644c9f0");
    check_field_offset(lv, s20644c9f1, ABISELECT(64,44), "S20644C9.s20644c9f1");
    check_field_offset(lv, s20644c9f2, ABISELECT(80,56), "S20644C9.s20644c9f2");
    check_field_offset(lv, s20644c9f3, ABISELECT(96,64), "S20644C9.s20644c9f3");
    test_class_info(&lv, &cd_S20644C9);
    dp->~S20644C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20644C9(Test_S20644C9, "S20644C9", ABISELECT(208,148));

#else // __cplusplus

extern void _ZN8S20644C9C1Ev();
extern void _ZN8S20644C9D1Ev();
Name_Map name_map_S20644C9[] = {
  NSPAIR(_ZN8S20644C9C1Ev),
  NSPAIR(_ZN8S20644C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
static Base_Class bases_S20644C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C8_nt,    ABISELECT(152,108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(144,104), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3216C8_nt,    ABISELECT(192,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20644C9[];
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY vtc_S20644C9[] = {
  ABISELECT(192,144),
  ABISELECT(144,104),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  0,
  0,
  0,
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern VTBL_ENTRY _ZTV8S20644C9[];
static  VTT_ENTRY vtt_S20644C9[] = {
  {&(_ZTV8S20644C9[4]),  4,13},
  {&(_ZTV8S20644C9[10]),  10,13},
};
extern VTBL_ENTRY _ZTI8S20644C9[];
extern  VTBL_ENTRY _ZTV8S20644C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C9[];
Class_Descriptor cd_S20644C9 = {  "S20644C9", // class name
  bases_S20644C9, 3,
  &(vtc_S20644C9[0]), // expected_vtbl_contents
  &(vtt_S20644C9[0]), // expected_vtt_contents
  ABISELECT(208,148), // object size
  NSPAIRA(_ZTI8S20644C9),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S20644C9),13, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20644C9),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20644C8  : virtual S20644C6 , virtual S3216C8_nt , S20644C9 , S20644C5 {
  void *s20644c8f0[2];
  long s20644c8f1;
  int s20644c8f2;
  ::S20644C6 s20644c8f3[5];
  virtual void  v7(); // _ZN8S20644C82v7Ev
  ~S20644C8(); // tgen
  S20644C8(); // tgen
};
//SIG(-1 S20644C8) C1{ VBC2{ BC3{ m Fi} v2 v3 v4 FC3[3] FC3[2] Fp Fs FC3} VBC3 BC4{ VBC2 VBC3 v5 FC2 FD Fp[2] FC2} BC5{ BC2 VBC3 FD FL FC2 Fp Fs[3]} v1 Fp[2] Fl Fi FC2[5]}


void  S20644C8 ::v7(){vfunc_called(this, "_ZN8S20644C82v7Ev");}
S20644C8 ::~S20644C8(){ note_dtor("S20644C8", this);} // tgen
S20644C8 ::S20644C8(){ note_ctor("S20644C8", this);} // tgen

static void Test_S20644C8()
{
  extern Class_Descriptor cd_S20644C8;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(39,120)];
    init_test(&cd_S20644C8, buf);
    S20644C8 *dp, &lv = *(dp=new (buf) S20644C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(608,476), "sizeof(S20644C8)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20644C8)");
    /*is_ambiguous_... S20644C8::S20644C6 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*), ABISELECT(560,436), "S20644C8");
    /*is_ambiguous_... S20644C8::S20644C6 */ AMB_check_base_class_offset(lv, (S20644C6*), ABISELECT(552,432), "S20644C8");
    check_base_class_offset(lv, (S20644C6*)(S20644C9*), ABISELECT(552,432), "S20644C8");
    /*is_ambiguous_... S20644C8::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*), ABISELECT(600,472), "S20644C8");
    /*is_ambiguous_... S20644C9::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C9*), ABISELECT(600,472), "S20644C8");
    /*is_ambiguous_... S20644C5::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*), ABISELECT(600,472), "S20644C8");
    check_base_class_offset(lv, (S20644C9*), 0, "S20644C8");
    check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*), ABISELECT(152,108), "S20644C8");
    check_base_class_offset(lv, (S20644C6*)(S20644C5*), ABISELECT(144,104), "S20644C8");
    check_base_class_offset(lv, (S20644C5*), ABISELECT(144,104), "S20644C8");
    check_field_offset(lv, s20644c8f0, ABISELECT(280,216), "S20644C8.s20644c8f0");
    check_field_offset(lv, s20644c8f1, ABISELECT(296,224), "S20644C8.s20644c8f1");
    check_field_offset(lv, s20644c8f2, ABISELECT(304,228), "S20644C8.s20644c8f2");
    check_field_offset(lv, s20644c8f3, ABISELECT(312,232), "S20644C8.s20644c8f3");
    test_class_info(&lv, &cd_S20644C8);
    dp->~S20644C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20644C8(Test_S20644C8, "S20644C8", ABISELECT(608,476));

#else // __cplusplus

extern void _ZN8S20644C8C1Ev();
extern void _ZN8S20644C8D1Ev();
Name_Map name_map_S20644C8[] = {
  NSPAIR(_ZN8S20644C8C1Ev),
  NSPAIR(_ZN8S20644C8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C9;
extern VTBL_ENTRY _ZTI8S20644C9[];
extern  VTBL_ENTRY _ZTV8S20644C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
static Base_Class bases_S20644C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C8_nt,    ABISELECT(560,436), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(552,432), //bcp->offset
    12, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3216C8_nt,    ABISELECT(600,472), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20644C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3216C8_nt,    ABISELECT(152,108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(144,104), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20644C5,    ABISELECT(144,104), //bcp->offset
    6, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20644C8[];
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY vtc_S20644C8[] = {
  ABISELECT(600,472),
  ABISELECT(552,432),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
  ABISELECT(456,368),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  0,
  0,
  0,
  ABISELECT(-552,-432),
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern VTBL_ENTRY _ZTV8S20644C8[];
extern void _ZN8S20644C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C9__8S20644C8[] = {
  ABISELECT(600,472),
  ABISELECT(552,432),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C9__8S20644C8[] = {
  0,
  0,
  0,
  ABISELECT(-552,-432),
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__8S20644C8[] = {
  ABISELECT(456,368),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
static  VTT_ENTRY vtt_S20644C8[] = {
  {&(_ZTV8S20644C8[4]),  4,20},
  {&(_tg__ZTV8S20644C9__8S20644C8[4]),  4,5},
  {&(_tg__ZTV8S20644C6__8S20644C9__8S20644C8[5]),  5,8},
  {&(_tg__ZTV8S20644C5__8S20644C8[3]),  3,6},
  {&(_ZTV8S20644C8[17]),  17,20},
  {&(_ZTV8S20644C8[9]),  9,20},
};
extern VTBL_ENTRY _ZTI8S20644C8[];
extern  VTBL_ENTRY _ZTV8S20644C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C8[];
Class_Descriptor cd_S20644C8 = {  "S20644C8", // class name
  bases_S20644C8, 7,
  &(vtc_S20644C8[0]), // expected_vtbl_contents
  &(vtt_S20644C8[0]), // expected_vtt_contents
  ABISELECT(608,476), // object size
  NSPAIRA(_ZTI8S20644C8),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S20644C8),20, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20644C8),6, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20644C4  : virtual S20644C5 , S20644C7 , virtual S20644C6 , S20644C8 , S20644C9 {
  int s20644c4f0[2];
  long double s20644c4f1;
  ::S20644C9 s20644c4f2[10];
  int s20644c4f3;
  virtual void  v8(); // _ZN8S20644C42v8Ev
  ~S20644C4(); // tgen
  S20644C4(); // tgen
};
//SIG(-1 S20644C4) C1{ VBC2{ BC3{ BC4{ m Fi} v2 v3 v4 FC4[3] FC4[2] Fp Fs FC4} VBC4 FD FL FC3 Fp Fs[3]} BC5{ BC3 vd v5 Fp[7] Fi[2] FL Fi} VBC3 BC6{ VBC3 VBC4 BC7{ VBC3 VBC4 v6 FC3 FD Fp[2] FC3} BC2 v7 Fp[2] Fl Fi FC3[5]} BC7 v1 Fi[2] FD FC7[10] Fi}


void  S20644C4 ::v8(){vfunc_called(this, "_ZN8S20644C42v8Ev");}
S20644C4 ::~S20644C4(){ note_dtor("S20644C4", this);} // tgen
S20644C4 ::S20644C4(){ note_ctor("S20644C4", this);} // tgen

static void Test_S20644C4()
{
  extern Class_Descriptor cd_S20644C4;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(198,572)];
    init_test(&cd_S20644C4, buf);
    S20644C4 *dp, &lv = *(dp=new (buf) S20644C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(3152,2284), "sizeof(S20644C4)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20644C4)");
    /*is_ambiguous_... S20644C4::S20644C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*), ABISELECT(2968,2132), "S20644C4");
    /*is_ambiguous_... S20644C4::S20644C5 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C5*), ABISELECT(2960,2128), "S20644C4");
    /*is_ambiguous_... S20644C4::S20644C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*), ABISELECT(3096,2240), "S20644C4");
    /*is_ambiguous_... S20644C8::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C8*), ABISELECT(3096,2240), "S20644C4");
    /*is_ambiguous_... S20644C9::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C9*)(S20644C8*), ABISELECT(3096,2240), "S20644C4");
    /*is_ambiguous_... S20644C5::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*)(S20644C8*), ABISELECT(3096,2240), "S20644C4");
    /*is_ambiguous_... S20644C4::S20644C9 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C9*), ABISELECT(3096,2240), "S20644C4");
    /*is_ambiguous_... S20644C4::S20644C5 */ AMB_check_base_class_offset(lv, (S20644C5*), ABISELECT(2960,2128), "S20644C4");
    check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C7*), ABISELECT(8,4), "S20644C4");
    check_base_class_offset(lv, (S20644C6*)(S20644C7*), 0, "S20644C4");
    check_base_class_offset(lv, (S20644C7*), 0, "S20644C4");
    /*is_ambiguous_... S20644C4::S20644C6 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*), ABISELECT(3112,2248), "S20644C4");
    /*is_ambiguous_... S20644C4::S20644C6 */ AMB_check_base_class_offset(lv, (S20644C6*), ABISELECT(3104,2244), "S20644C4");
    /*is_ambiguous_... S20644C8::S20644C6 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C8*), ABISELECT(3104,2244), "S20644C4");
    check_base_class_offset(lv, (S20644C6*)(S20644C9*)(S20644C8*), ABISELECT(3104,2244), "S20644C4");
    /*is_ambiguous_... S20644C4::S20644C9 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C9*), ABISELECT(3104,2244), "S20644C4");
    check_base_class_offset(lv, (S20644C9*)(S20644C8*), ABISELECT(128,88), "S20644C4");
    check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*)(S20644C8*), ABISELECT(280,196), "S20644C4");
    check_base_class_offset(lv, (S20644C6*)(S20644C5*)(S20644C8*), ABISELECT(272,192), "S20644C4");
    check_base_class_offset(lv, (S20644C5*)(S20644C8*), ABISELECT(272,192), "S20644C4");
    check_base_class_offset(lv, (S20644C8*), ABISELECT(128,88), "S20644C4");
    /*is_ambiguous_... S20644C4::S20644C9 */ AMB_check_base_class_offset(lv, (S20644C9*), ABISELECT(688,520), "S20644C4");
    check_field_offset(lv, s20644c4f0, ABISELECT(832,624), "S20644C4.s20644c4f0");
    check_field_offset(lv, s20644c4f1, ABISELECT(848,632), "S20644C4.s20644c4f1");
    check_field_offset(lv, s20644c4f2, ABISELECT(864,644), "S20644C4.s20644c4f2");
    check_field_offset(lv, s20644c4f3, ABISELECT(2944,2124), "S20644C4.s20644c4f3");
    test_class_info(&lv, &cd_S20644C4);
    dp->~S20644C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20644C4(Test_S20644C4, "S20644C4", ABISELECT(3152,2284));

#else // __cplusplus

extern void _ZN8S20644C4C1Ev();
extern void _ZN8S20644C4D1Ev();
Name_Map name_map_S20644C4[] = {
  NSPAIR(_ZN8S20644C4C1Ev),
  NSPAIR(_ZN8S20644C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C7;
extern VTBL_ENTRY _ZTI8S20644C7[];
extern  VTBL_ENTRY _ZTV8S20644C7[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C9;
extern VTBL_ENTRY _ZTI8S20644C9[];
extern  VTBL_ENTRY _ZTV8S20644C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
extern Class_Descriptor cd_S20644C8;
extern VTBL_ENTRY _ZTI8S20644C8[];
extern  VTBL_ENTRY _ZTV8S20644C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C8[];
extern Class_Descriptor cd_S20644C9;
extern VTBL_ENTRY _ZTI8S20644C9[];
extern  VTBL_ENTRY _ZTV8S20644C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C9[];
static Base_Class bases_S20644C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C8_nt,    ABISELECT(2968,2132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(2960,2128), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(3096,2240), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20644C5,    ABISELECT(2960,2128), //bcp->offset
    29, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3216C8_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20644C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20644C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3216C8_nt,    ABISELECT(3112,2248), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(3104,2244), //bcp->offset
    38, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20644C9,    ABISELECT(128,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(280,196), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(272,192), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20644C5,    ABISELECT(272,192), //bcp->offset
    18, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20644C8,    ABISELECT(128,88), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20644C9,    ABISELECT(688,520), //bcp->offset
    24, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20644C4[];
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C4D1Ev();
extern void _ZN8S20644C4D0Ev();
extern void _ZN8S20644C72v5Ev();
extern void _ZN8S20644C42v8Ev();
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY vtc_S20644C4[] = {
  ABISELECT(3104,2244),
  ABISELECT(3096,2240),
  ABISELECT(2960,2128),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C4[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20644C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20644C4D0Ev,
  (VTBL_ENTRY)&_ZN8S20644C72v5Ev,
  (VTBL_ENTRY)&_ZN8S20644C42v8Ev,
  ABISELECT(2968,2152),
  ABISELECT(2976,2156),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S20644C4[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
  ABISELECT(2824,2048),
  ABISELECT(-272,-192),
  (VTBL_ENTRY)&(_ZTI8S20644C4[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  ABISELECT(2408,1720),
  ABISELECT(2416,1724),
  ABISELECT(-688,-520),
  (VTBL_ENTRY)&(_ZTI8S20644C4[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  0,
  0,
  0,
  ABISELECT(136,112),
  ABISELECT(-2960,-2128),
  (VTBL_ENTRY)&(_ZTI8S20644C4[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  0,
  0,
  0,
  ABISELECT(-3104,-2244),
  (VTBL_ENTRY)&(_ZTI8S20644C4[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern VTBL_ENTRY _ZTV8S20644C4[];
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C8__8S20644C4[] = {
  ABISELECT(2968,2152),
  ABISELECT(2976,2156),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
};
extern void _ZN8S20644C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C98S20644C8__8S20644C4[] = {
  ABISELECT(2968,2152),
  ABISELECT(2976,2156),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C98S20644C8__8S20644C4[] = {
  0,
  0,
  0,
  ABISELECT(-2976,-2156),
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C58S20644C8__A1__8S20644C4[] = {
  ABISELECT(2824,2048),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C8__8S20644C4[] = {
  0,
  0,
  0,
  ABISELECT(-2976,-2156),
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__8S20644C8__8S20644C4[] = {
  ABISELECT(2824,2048),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C9__A1__8S20644C4[] = {
  ABISELECT(2408,1720),
  ABISELECT(2416,1724),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C9__A1__8S20644C4[] = {
  0,
  0,
  0,
  ABISELECT(-2416,-1724),
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__8S20644C4[] = {
  ABISELECT(136,112),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
static  VTT_ENTRY vtt_S20644C4[] = {
  {&(_ZTV8S20644C4[5]),  5,46},
  {&(_tg__ZTV8S20644C8__8S20644C4[4]),  4,6},
  {&(_tg__ZTV8S20644C98S20644C8__8S20644C4[4]),  4,5},
  {&(_tg__ZTV8S20644C6__8S20644C98S20644C8__8S20644C4[5]),  5,8},
  {&(_tg__ZTV8S20644C58S20644C8__A1__8S20644C4[3]),  3,6},
  {&(_tg__ZTV8S20644C6__8S20644C8__8S20644C4[5]),  5,8},
  {&(_tg__ZTV8S20644C5__8S20644C8__8S20644C4[3]),  3,6},
  {&(_tg__ZTV8S20644C9__A1__8S20644C4[4]),  4,5},
  {&(_tg__ZTV8S20644C6__8S20644C9__A1__8S20644C4[5]),  5,8},
  {&(_ZTV8S20644C4[35]),  35,46},
  {&(_ZTV8S20644C4[43]),  43,46},
  {&(_ZTV8S20644C4[16]),  16,46},
  {&(_ZTV8S20644C4[21]),  21,46},
  {&(_ZTV8S20644C4[28]),  28,46},
  {&(_tg__ZTV8S20644C5__8S20644C4[3]),  3,6},
};
extern VTBL_ENTRY _ZTI8S20644C4[];
extern  VTBL_ENTRY _ZTV8S20644C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C4[];
Class_Descriptor cd_S20644C4 = {  "S20644C4", // class name
  bases_S20644C4, 15,
  &(vtc_S20644C4[0]), // expected_vtbl_contents
  &(vtt_S20644C4[0]), // expected_vtt_contents
  ABISELECT(3152,2284), // object size
  NSPAIRA(_ZTI8S20644C4),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S20644C4),46, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20644C4),15, //virtual table table var
  10, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20644C11  : virtual S3216C8_nt , virtual S20644C6 , virtual S20644C5 {
  void *s20644c11f0[2];
  int s20644c11f1;
  ::S20644C5 s20644c11f2[8];
  long double s20644c11f3[9];
  ~S20644C11(); // tgen
  S20644C11(); // tgen
};
//SIG(-1 S20644C11) C1{ VBC2{ m Fi} VBC3{ BC2 v1 v2 v3 FC2[3] FC2[2] Fp Fs FC2} VBC4{ BC3 VBC2 FD FL FC3 Fp Fs[3]} Fp[2] Fi FC4[8] FD[9]}


S20644C11 ::~S20644C11(){ note_dtor("S20644C11", this);} // tgen
S20644C11 ::S20644C11(){ note_ctor("S20644C11", this);} // tgen

static void Test_S20644C11()
{
  extern Class_Descriptor cd_S20644C11;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(97,303)];
    init_test(&cd_S20644C11, buf);
    S20644C11 *dp, &lv = *(dp=new (buf) S20644C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1536,1208), "sizeof(S20644C11)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20644C11)");
    /*is_ambiguous_... S20644C11::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*), ABISELECT(1328,1052), "S20644C11");
    /*is_ambiguous_... S20644C5::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*), ABISELECT(1328,1052), "S20644C11");
    /*is_ambiguous_... S20644C11::S20644C6 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*), ABISELECT(1344,1060), "S20644C11");
    /*is_ambiguous_... S20644C11::S20644C6 */ AMB_check_base_class_offset(lv, (S20644C6*), ABISELECT(1336,1056), "S20644C11");
    check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*), ABISELECT(1400,1100), "S20644C11");
    check_base_class_offset(lv, (S20644C6*)(S20644C5*), ABISELECT(1392,1096), "S20644C11");
    check_base_class_offset(lv, (S20644C5*), ABISELECT(1392,1096), "S20644C11");
    check_field_offset(lv, s20644c11f0, ABISELECT(8,4), "S20644C11.s20644c11f0");
    check_field_offset(lv, s20644c11f1, ABISELECT(24,12), "S20644C11.s20644c11f1");
    check_field_offset(lv, s20644c11f2, ABISELECT(32,16), "S20644C11.s20644c11f2");
    check_field_offset(lv, s20644c11f3, ABISELECT(1184,944), "S20644C11.s20644c11f3");
    test_class_info(&lv, &cd_S20644C11);
    dp->~S20644C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20644C11(Test_S20644C11, "S20644C11", ABISELECT(1536,1208));

#else // __cplusplus

extern void _ZN9S20644C11C1Ev();
extern void _ZN9S20644C11D1Ev();
Name_Map name_map_S20644C11[] = {
  NSPAIR(_ZN9S20644C11C1Ev),
  NSPAIR(_ZN9S20644C11D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
static Base_Class bases_S20644C11[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C8_nt,    ABISELECT(1328,1052), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3216C8_nt,    ABISELECT(1344,1060), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(1336,1056), //bcp->offset
    5, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3216C8_nt,    ABISELECT(1400,1100), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(1392,1096), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20644C5,    ABISELECT(1392,1096), //bcp->offset
    13, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20644C11[];
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY vtc_S20644C11[] = {
  ABISELECT(1392,1096),
  ABISELECT(1336,1056),
  ABISELECT(1328,1052),
  0,
  (VTBL_ENTRY)&(_ZTI9S20644C11[0]),
  0,
  0,
  0,
  ABISELECT(-1336,-1056),
  (VTBL_ENTRY)&(_ZTI9S20644C11[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  0,
  0,
  0,
  ABISELECT(-64,-44),
  ABISELECT(-1392,-1096),
  (VTBL_ENTRY)&(_ZTI9S20644C11[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern VTBL_ENTRY _ZTV9S20644C11[];
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__9S20644C11[] = {
  ABISELECT(-64,-44),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
static  VTT_ENTRY vtt_S20644C11[] = {
  {&(_ZTV9S20644C11[5]),  5,22},
  {&(_ZTV9S20644C11[10]),  10,22},
  {&(_ZTV9S20644C11[19]),  19,22},
  {&(_tg__ZTV8S20644C5__9S20644C11[3]),  3,6},
};
extern VTBL_ENTRY _ZTI9S20644C11[];
extern  VTBL_ENTRY _ZTV9S20644C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20644C11[];
Class_Descriptor cd_S20644C11 = {  "S20644C11", // class name
  bases_S20644C11, 6,
  &(vtc_S20644C11[0]), // expected_vtbl_contents
  &(vtt_S20644C11[0]), // expected_vtt_contents
  ABISELECT(1536,1208), // object size
  NSPAIRA(_ZTI9S20644C11),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S20644C11),22, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20644C11),4, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20644C10  : S20644C11 , S3216C8_nt , virtual S20644C8 , S20644C7 {
  int s20644c10f0;
  void *s20644c10f1;
  int s20644c10f2;
  virtual  ~S20644C10(); // _ZN9S20644C10D2Ev
  virtual void  v9(); // _ZN9S20644C102v9Ev
  S20644C10(); // tgen
};
//SIG(-1 S20644C10) C1{ BC2{ VBC3{ m Fi} VBC4{ BC3 v2 v3 v4 FC3[3] FC3[2] Fp Fs FC3} VBC5{ BC4 VBC3 FD FL FC4 Fp Fs[3]} Fp[2] Fi FC5[8] FD[9]} BC3 VBC6{ VBC4 VBC3 BC7{ VBC4 VBC3 v5 FC4 FD Fp[2] FC4} BC5 v6 Fp[2] Fl Fi FC4[5]} BC8{ BC4 vd v7 Fp[7] Fi[2] FL Fi} vd v1 Fi Fp Fi}


 S20644C10 ::~S20644C10(){ note_dtor("S20644C10", this);}
void  S20644C10 ::v9(){vfunc_called(this, "_ZN9S20644C102v9Ev");}
S20644C10 ::S20644C10(){ note_ctor("S20644C10", this);} // tgen

static void Test_S20644C10()
{
  extern Class_Descriptor cd_S20644C10;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(141,437)];
    init_test(&cd_S20644C10, buf);
    S20644C10 *dp, &lv = *(dp=new (buf) S20644C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2240,1744), "sizeof(S20644C10)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20644C10)");
    /*is_ambiguous_... S20644C11::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C11*), ABISELECT(1476,1156), "S20644C10");
    /*is_ambiguous_... S20644C10::S20644C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*), ABISELECT(1476,1156), "S20644C10");
    /*is_ambiguous_... S20644C8::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C8*), ABISELECT(1476,1156), "S20644C10");
    /*is_ambiguous_... S20644C9::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C9*)(S20644C8*), ABISELECT(1476,1156), "S20644C10");
    /*is_ambiguous_... S20644C5::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*)(S20644C8*), ABISELECT(1476,1156), "S20644C10");
    /*is_ambiguous_... S20644C10::S20644C6 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*), ABISELECT(1488,1164), "S20644C10");
    /*is_ambiguous_... S20644C11::S20644C6 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C11*), ABISELECT(1480,1160), "S20644C10");
    /*is_ambiguous_... S20644C8::S20644C6 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C8*), ABISELECT(1480,1160), "S20644C10");
    check_base_class_offset(lv, (S20644C6*)(S20644C9*)(S20644C8*), ABISELECT(1480,1160), "S20644C10");
    /*is_ambiguous_... S20644C10::S20644C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*), ABISELECT(1544,1204), "S20644C10");
    /*is_ambiguous_... S20644C10::S20644C5 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C5*), ABISELECT(1536,1200), "S20644C10");
    check_base_class_offset(lv, (S20644C5*)(S20644C11*), ABISELECT(1536,1200), "S20644C10");
    check_base_class_offset(lv, (S20644C11*), 0, "S20644C10");
    /*is_ambiguous_... S20644C10::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*), ABISELECT(1328,1052), "S20644C10");
    check_base_class_offset(lv, (S20644C9*)(S20644C8*), ABISELECT(1680,1312), "S20644C10");
    check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*)(S20644C8*), ABISELECT(1832,1420), "S20644C10");
    check_base_class_offset(lv, (S20644C6*)(S20644C5*)(S20644C8*), ABISELECT(1824,1416), "S20644C10");
    check_base_class_offset(lv, (S20644C5*)(S20644C8*), ABISELECT(1824,1416), "S20644C10");
    check_base_class_offset(lv, (S20644C8*), ABISELECT(1680,1312), "S20644C10");
    check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C7*), ABISELECT(1344,1060), "S20644C10");
    check_base_class_offset(lv, (S20644C6*)(S20644C7*), ABISELECT(1336,1056), "S20644C10");
    check_base_class_offset(lv, (S20644C7*), ABISELECT(1336,1056), "S20644C10");
    check_field_offset(lv, s20644c10f0, ABISELECT(1460,1144), "S20644C10.s20644c10f0");
    check_field_offset(lv, s20644c10f1, ABISELECT(1464,1148), "S20644C10.s20644c10f1");
    check_field_offset(lv, s20644c10f2, ABISELECT(1472,1152), "S20644C10.s20644c10f2");
    test_class_info(&lv, &cd_S20644C10);
    dp->~S20644C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20644C10(Test_S20644C10, "S20644C10", ABISELECT(2240,1744));

#else // __cplusplus

extern void _ZN9S20644C10C1Ev();
extern void _ZN9S20644C10D2Ev();
Name_Map name_map_S20644C10[] = {
  NSPAIR(_ZN9S20644C10C1Ev),
  NSPAIR(_ZN9S20644C10D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
extern Class_Descriptor cd_S20644C11;
extern VTBL_ENTRY _ZTI9S20644C11[];
extern  VTBL_ENTRY _ZTV9S20644C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20644C11[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C9;
extern VTBL_ENTRY _ZTI8S20644C9[];
extern  VTBL_ENTRY _ZTV8S20644C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
extern Class_Descriptor cd_S20644C8;
extern VTBL_ENTRY _ZTI8S20644C8[];
extern  VTBL_ENTRY _ZTV8S20644C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C8[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C7;
extern VTBL_ENTRY _ZTI8S20644C7[];
extern  VTBL_ENTRY _ZTV8S20644C7[];
static Base_Class bases_S20644C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C8_nt,    ABISELECT(1476,1156), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S3216C8_nt,    ABISELECT(1488,1164), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(1480,1160), //bcp->offset
    17, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S3216C8_nt,    ABISELECT(1544,1204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(1536,1200), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20644C5,    ABISELECT(1536,1200), //bcp->offset
    25, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20644C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3216C8_nt,    ABISELECT(1328,1052), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20644C9,    ABISELECT(1680,1312), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(1832,1420), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(1824,1416), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20644C5,    ABISELECT(1824,1416), //bcp->offset
    45, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20644C8,    ABISELECT(1680,1312), //bcp->offset
    34, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3216C8_nt,    ABISELECT(1344,1060), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(1336,1056), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20644C7,    ABISELECT(1336,1056), //bcp->offset
    9, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20644C10[];
extern void _ZN9S20644C10D1Ev();
extern void _ZN9S20644C10D0Ev();
extern void _ZN9S20644C102v9Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void ABISELECT(_ZThn1336_N9S20644C10D1Ev,_ZThn1056_N9S20644C10D1Ev)();
extern void ABISELECT(_ZThn1336_N9S20644C10D0Ev,_ZThn1056_N9S20644C10D0Ev)();
extern void _ZN8S20644C72v5Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY vtc_S20644C10[] = {
  ABISELECT(1680,1312),
  ABISELECT(1536,1200),
  ABISELECT(1480,1160),
  ABISELECT(1476,1156),
  0,
  (VTBL_ENTRY)&(_ZTI9S20644C10[0]),
  (VTBL_ENTRY)&_ZN9S20644C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20644C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20644C102v9Ev,
  ABISELECT(-1336,-1056),
  (VTBL_ENTRY)&(_ZTI9S20644C10[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn1336_N9S20644C10D1Ev,_ZThn1056_N9S20644C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1336_N9S20644C10D0Ev,_ZThn1056_N9S20644C10D0Ev),
  (VTBL_ENTRY)&_ZN8S20644C72v5Ev,
  0,
  0,
  0,
  ABISELECT(-1480,-1160),
  (VTBL_ENTRY)&(_ZTI9S20644C10[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  0,
  0,
  0,
  ABISELECT(-60,-44),
  ABISELECT(-1536,-1200),
  (VTBL_ENTRY)&(_ZTI9S20644C10[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  ABISELECT(144,104),
  ABISELECT(144,104),
  ABISELECT(144,104),
  0,
  0,
  ABISELECT(-204,-156),
  ABISELECT(-200,-152),
  ABISELECT(-1680,-1312),
  (VTBL_ENTRY)&(_ZTI9S20644C10[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
  ABISELECT(-348,-260),
  ABISELECT(-1824,-1416),
  (VTBL_ENTRY)&(_ZTI9S20644C10[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern VTBL_ENTRY _ZTV9S20644C10[];
static  VTBL_ENTRY _tg__ZTV9S20644C11__9S20644C10[] = {
  ABISELECT(1536,1200),
  ABISELECT(1480,1160),
  ABISELECT(1476,1156),
  0,
  (VTBL_ENTRY)&(_ZTI9S20644C11[0]),
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__9S20644C11__9S20644C10[] = {
  0,
  0,
  0,
  ABISELECT(-1480,-1160),
  (VTBL_ENTRY)&(_ZTI9S20644C11[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__9S20644C11__9S20644C10[] = {
  0,
  0,
  0,
  ABISELECT(-60,-44),
  ABISELECT(-1536,-1200),
  (VTBL_ENTRY)&(_ZTI9S20644C11[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__9S20644C10[] = {
  ABISELECT(-60,-44),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C8__9S20644C10[] = {
  ABISELECT(-204,-156),
  ABISELECT(-200,-152),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
};
extern void _ZN8S20644C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C98S20644C8__9S20644C10[] = {
  ABISELECT(-204,-156),
  ABISELECT(-200,-152),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C98S20644C8__9S20644C10[] = {
  0,
  0,
  0,
  ABISELECT(200,152),
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C58S20644C8__A1__9S20644C10[] = {
  ABISELECT(-348,-260),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C8__9S20644C10[] = {
  0,
  0,
  0,
  ABISELECT(200,152),
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__8S20644C8__9S20644C10[] = {
  ABISELECT(-348,-260),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
static  VTT_ENTRY vtt_S20644C10[] = {
  {&(_ZTV9S20644C10[6]),  6,51},
  {&(_tg__ZTV9S20644C11__9S20644C10[5]),  5,5},
  {&(_tg__ZTV8S20644C6__9S20644C11__9S20644C10[5]),  5,8},
  {&(_tg__ZTV8S20644C5__9S20644C11__9S20644C10[6]),  6,9},
  {&(_ZTV9S20644C10[22]),  22,51},
  {&(_ZTV9S20644C10[31]),  31,51},
  {&(_ZTV9S20644C10[43]),  43,51},
  {&(_ZTV9S20644C10[48]),  48,51},
  {&(_tg__ZTV8S20644C5__9S20644C10[3]),  3,6},
  {&(_tg__ZTV8S20644C8__9S20644C10[4]),  4,6},
  {&(_tg__ZTV8S20644C98S20644C8__9S20644C10[4]),  4,5},
  {&(_tg__ZTV8S20644C6__8S20644C98S20644C8__9S20644C10[5]),  5,8},
  {&(_tg__ZTV8S20644C58S20644C8__A1__9S20644C10[3]),  3,6},
  {&(_tg__ZTV8S20644C6__8S20644C8__9S20644C10[5]),  5,8},
  {&(_tg__ZTV8S20644C5__8S20644C8__9S20644C10[3]),  3,6},
};
extern VTBL_ENTRY _ZTI9S20644C10[];
extern  VTBL_ENTRY _ZTV9S20644C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20644C10[];
Class_Descriptor cd_S20644C10 = {  "S20644C10", // class name
  bases_S20644C10, 16,
  &(vtc_S20644C10[0]), // expected_vtbl_contents
  &(vtt_S20644C10[0]), // expected_vtt_contents
  ABISELECT(2240,1744), // object size
  NSPAIRA(_ZTI9S20644C10),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S20644C10),51, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20644C10),15, //virtual table table var
  10, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20644C2  : virtual S3216C8_nt , S20644C4 , S20644C5 , virtual S20644C10 , S20644C11 {
  int s20644c2f0[2];
  void *s20644c2f1;
  char s20644c2f2:3;
  int s20644c2f3[3];
  virtual  ~S20644C2(); // _ZN8S20644C2D2Ev
  virtual void  v10(); // _ZN8S20644C23v10Ev
  virtual void  v11(); // _ZN8S20644C23v11Ev
  S20644C2(); // tgen
};
//SIG(-1 S20644C2) C1{ VBC2{ m Fi} BC3{ VBC4{ BC5{ BC2 v3 v4 v5 FC2[3] FC2[2] Fp Fs FC2} VBC2 FD FL FC5 Fp Fs[3]} BC6{ BC5 vd v6 Fp[7] Fi[2] FL Fi} VBC5 BC7{ VBC5 VBC2 BC8{ VBC5 VBC2 v7 FC5 FD Fp[2] FC5} BC4 v8 Fp[2] Fl Fi FC5[5]} BC8 v9 Fi[2] FD FC8[10] Fi} BC4 VBC9{ BC10{ VBC2 VBC5 VBC4 Fp[2] Fi FC4[8] FD[9]} BC2 VBC7 BC6 vd v10 Fi Fp Fi} BC10 vd v1 v2 Fi[2] Fp Fc:3 Fi[3]}


 S20644C2 ::~S20644C2(){ note_dtor("S20644C2", this);}
void  S20644C2 ::v10(){vfunc_called(this, "_ZN8S20644C23v10Ev");}
void  S20644C2 ::v11(){vfunc_called(this, "_ZN8S20644C23v11Ev");}
S20644C2 ::S20644C2(){ note_ctor("S20644C2", this);} // tgen

static void Test_S20644C2()
{
  extern Class_Descriptor cd_S20644C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(421,1267)];
    init_test(&cd_S20644C2, buf);
    S20644C2 *dp, &lv = *(dp=new (buf) S20644C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(6720,5064), "sizeof(S20644C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20644C2)");
    /*is_ambiguous_... S20644C2::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*), ABISELECT(4464,3320), "S20644C2");
    /*is_ambiguous_... S20644C2::S20644C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*), ABISELECT(4464,3320), "S20644C2");
    /*is_ambiguous_... S20644C8::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C8*)(S20644C4*), ABISELECT(4464,3320), "S20644C2");
    /*is_ambiguous_... S20644C9::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C9*)(S20644C8*)(S20644C4*), ABISELECT(4464,3320), "S20644C2");
    /*is_ambiguous_... S20644C5::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*)(S20644C8*)(S20644C4*), ABISELECT(4464,3320), "S20644C2");
    /*is_ambiguous_... S20644C4::S20644C9 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C9*)(S20644C4*), ABISELECT(4464,3320), "S20644C2");
    /*is_ambiguous_... S20644C2::S20644C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*), ABISELECT(4464,3320), "S20644C2");
    /*is_ambiguous_... S20644C11::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C11*)(S20644C10*), ABISELECT(4464,3320), "S20644C2");
    /*is_ambiguous_... S20644C2::S20644C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C8*), ABISELECT(4464,3320), "S20644C2");
    /*is_ambiguous_... S20644C2::S20644C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C9*)(S20644C8*), ABISELECT(4464,3320), "S20644C2");
    /*is_ambiguous_... S20644C2::S20644C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*)(S20644C8*), ABISELECT(4464,3320), "S20644C2");
    /*is_ambiguous_... S20644C2::S20644C11 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C11*), ABISELECT(4464,3320), "S20644C2");
    /*is_ambiguous_... S20644C2::S20644C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*), ABISELECT(4488,3328), "S20644C2");
    /*is_ambiguous_... S20644C2::S20644C5 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C5*), ABISELECT(4480,3324), "S20644C2");
    /*is_ambiguous_... S20644C4::S20644C5 */ AMB_check_base_class_offset(lv, (S20644C5*)(S20644C4*), ABISELECT(4480,3324), "S20644C2");
    check_base_class_offset(lv, (S20644C5*)(S20644C11*)(S20644C10*), ABISELECT(4480,3324), "S20644C2");
    /*is_ambiguous_... S20644C2::S20644C11 */ AMB_check_base_class_offset(lv, (S20644C5*)(S20644C11*), ABISELECT(4480,3324), "S20644C2");
    check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C7*)(S20644C4*), ABISELECT(8,4), "S20644C2");
    check_base_class_offset(lv, (S20644C6*)(S20644C7*)(S20644C4*), 0, "S20644C2");
    check_base_class_offset(lv, (S20644C7*)(S20644C4*), 0, "S20644C2");
    /*is_ambiguous_... S20644C2::S20644C6 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*), ABISELECT(4624,3440), "S20644C2");
    /*is_ambiguous_... S20644C4::S20644C6 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C4*), ABISELECT(4616,3436), "S20644C2");
    /*is_ambiguous_... S20644C8::S20644C6 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C8*)(S20644C4*), ABISELECT(4616,3436), "S20644C2");
    check_base_class_offset(lv, (S20644C6*)(S20644C9*)(S20644C8*)(S20644C4*), ABISELECT(4616,3436), "S20644C2");
    /*is_ambiguous_... S20644C4::S20644C9 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C9*)(S20644C4*), ABISELECT(4616,3436), "S20644C2");
    /*is_ambiguous_... S20644C11::S20644C6 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C11*)(S20644C10*), ABISELECT(4616,3436), "S20644C2");
    /*is_ambiguous_... S20644C2::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C8*), ABISELECT(4616,3436), "S20644C2");
    /*is_ambiguous_... S20644C2::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C9*)(S20644C8*), ABISELECT(4616,3436), "S20644C2");
    /*is_ambiguous_... S20644C2::S20644C11 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C11*), ABISELECT(4616,3436), "S20644C2");
    check_base_class_offset(lv, (S20644C9*)(S20644C8*)(S20644C4*), ABISELECT(128,88), "S20644C2");
    check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*)(S20644C8*)(S20644C4*), ABISELECT(280,196), "S20644C2");
    check_base_class_offset(lv, (S20644C6*)(S20644C5*)(S20644C8*)(S20644C4*), ABISELECT(272,192), "S20644C2");
    check_base_class_offset(lv, (S20644C5*)(S20644C8*)(S20644C4*), ABISELECT(272,192), "S20644C2");
    check_base_class_offset(lv, (S20644C8*)(S20644C4*), ABISELECT(128,88), "S20644C2");
    /*is_ambiguous_... S20644C4::S20644C9 */ AMB_check_base_class_offset(lv, (S20644C9*)(S20644C4*), ABISELECT(688,520), "S20644C2");
    check_base_class_offset(lv, (S20644C4*), 0, "S20644C2");
    /*is_ambiguous_... S20644C2::S20644C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*), ABISELECT(2968,2132), "S20644C2");
    /*is_ambiguous_... S20644C2::S20644C5 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C5*), ABISELECT(2960,2128), "S20644C2");
    /*is_ambiguous_... S20644C2::S20644C5 */ AMB_check_base_class_offset(lv, (S20644C5*), ABISELECT(2960,2128), "S20644C2");
    check_base_class_offset(lv, (S20644C11*)(S20644C10*), ABISELECT(4672,3476), "S20644C2");
    /*is_ambiguous_... S20644C10::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C10*), ABISELECT(6000,4528), "S20644C2");
    /*is_ambiguous_... S20644C2::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C9*)(S20644C8*), ABISELECT(6160,4632), "S20644C2");
    /*is_ambiguous_... S20644C2::S20644C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*)(S20644C8*), ABISELECT(6312,4740), "S20644C2");
    /*is_ambiguous_... S20644C2::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C5*)(S20644C8*), ABISELECT(6304,4736), "S20644C2");
    /*is_ambiguous_... S20644C2::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C5*)(S20644C8*), ABISELECT(6304,4736), "S20644C2");
    check_base_class_offset(lv, (S20644C8*)(S20644C10*), ABISELECT(6160,4632), "S20644C2");
    check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C7*)(S20644C10*), ABISELECT(6016,4536), "S20644C2");
    check_base_class_offset(lv, (S20644C6*)(S20644C7*)(S20644C10*), ABISELECT(6008,4532), "S20644C2");
    check_base_class_offset(lv, (S20644C7*)(S20644C10*), ABISELECT(6008,4532), "S20644C2");
    check_base_class_offset(lv, (S20644C10*), ABISELECT(4672,3476), "S20644C2");
    /*is_ambiguous_... S20644C2::S20644C11 */ AMB_check_base_class_offset(lv, (S20644C11*), ABISELECT(3104,2240), "S20644C2");
    check_field_offset(lv, s20644c2f0, ABISELECT(4432,3292), "S20644C2.s20644c2f0");
    check_field_offset(lv, s20644c2f1, ABISELECT(4440,3300), "S20644C2.s20644c2f1");
    set_bf_and_test(lv, s20644c2f2, ABISELECT(4448,3304), 0, 3, 1, "S20644C2");
    set_bf_and_test(lv, s20644c2f2, ABISELECT(4448,3304), 0, 3, hide_sll(1LL<<2), "S20644C2");
    check_field_offset(lv, s20644c2f3, ABISELECT(4452,3308), "S20644C2.s20644c2f3");
    test_class_info(&lv, &cd_S20644C2);
    dp->~S20644C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20644C2(Test_S20644C2, "S20644C2", ABISELECT(6720,5064));

#else // __cplusplus

extern void _ZN8S20644C2C1Ev();
extern void _ZN8S20644C2D2Ev();
Name_Map name_map_S20644C2[] = {
  NSPAIR(_ZN8S20644C2C1Ev),
  NSPAIR(_ZN8S20644C2D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C7;
extern VTBL_ENTRY _ZTI8S20644C7[];
extern  VTBL_ENTRY _ZTV8S20644C7[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C9;
extern VTBL_ENTRY _ZTI8S20644C9[];
extern  VTBL_ENTRY _ZTV8S20644C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
extern Class_Descriptor cd_S20644C8;
extern VTBL_ENTRY _ZTI8S20644C8[];
extern  VTBL_ENTRY _ZTV8S20644C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C8[];
extern Class_Descriptor cd_S20644C9;
extern VTBL_ENTRY _ZTI8S20644C9[];
extern  VTBL_ENTRY _ZTV8S20644C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C9[];
extern Class_Descriptor cd_S20644C4;
extern VTBL_ENTRY _ZTI8S20644C4[];
extern  VTBL_ENTRY _ZTV8S20644C4[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C4[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
extern Class_Descriptor cd_S20644C11;
extern VTBL_ENTRY _ZTI9S20644C11[];
extern  VTBL_ENTRY _ZTV9S20644C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20644C11[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C9;
extern VTBL_ENTRY _ZTI8S20644C9[];
extern  VTBL_ENTRY _ZTV8S20644C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
extern Class_Descriptor cd_S20644C8;
extern VTBL_ENTRY _ZTI8S20644C8[];
extern  VTBL_ENTRY _ZTV8S20644C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C8[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C7;
extern VTBL_ENTRY _ZTI8S20644C7[];
extern  VTBL_ENTRY _ZTV8S20644C7[];
extern Class_Descriptor cd_S20644C10;
extern VTBL_ENTRY _ZTI9S20644C10[];
extern  VTBL_ENTRY _ZTV9S20644C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20644C10[];
extern Class_Descriptor cd_S20644C11;
extern VTBL_ENTRY _ZTI9S20644C11[];
extern  VTBL_ENTRY _ZTV9S20644C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20644C11[];
static Base_Class bases_S20644C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C8_nt,    ABISELECT(4464,3320), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3216C8_nt,    ABISELECT(4488,3328), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(4480,3324), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20644C5,    ABISELECT(4480,3324), //bcp->offset
    44, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    15, //immediately_derived
  0, 1},
  {&cd_S3216C8_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20644C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20644C7,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(4624,3440), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(4616,3436), //bcp->offset
    53, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S20644C9,    ABISELECT(128,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(280,196), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(272,192), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20644C5,    ABISELECT(272,192), //bcp->offset
    22, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20644C8,    ABISELECT(128,88), //bcp->offset
    16, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20644C9,    ABISELECT(688,520), //bcp->offset
    28, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20644C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3216C8_nt,    ABISELECT(2968,2132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(2960,2128), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20644C5,    ABISELECT(2960,2128), //bcp->offset
    33, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20644C11,    ABISELECT(4672,3476), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(6000,4528), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S20644C9,    ABISELECT(6160,4632), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    41, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(6312,4740), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(6304,4736), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S20644C5,    ABISELECT(6304,4736), //bcp->offset
    95, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    43, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S20644C8,    ABISELECT(6160,4632), //bcp->offset
    84, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    29, //immediately_derived
  0, 1},
  {&cd_S3216C8_nt,    ABISELECT(6016,4536), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(6008,4532), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S20644C7,    ABISELECT(6008,4532), //bcp->offset
    76, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S20644C10,    ABISELECT(4672,3476), //bcp->offset
    61, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20644C11,    ABISELECT(3104,2240), //bcp->offset
    39, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20644C2[];
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C2D1Ev();
extern void _ZN8S20644C2D0Ev();
extern void _ZN8S20644C72v5Ev();
extern void _ZN8S20644C42v8Ev();
extern void _ZN8S20644C23v10Ev();
extern void _ZN8S20644C23v11Ev();
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void ABISELECT(_ZTv0_n56_N8S20644C2D1Ev,_ZTv0_n28_N8S20644C2D1Ev)();
extern void ABISELECT(_ZThn4672_N8S20644C2D1Ev,_ZThn3476_N8S20644C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S20644C2D0Ev,_ZTv0_n28_N8S20644C2D0Ev)();
extern void ABISELECT(_ZThn4672_N8S20644C2D0Ev,_ZThn3476_N8S20644C2D0Ev)() __attribute__((weak));
extern void _ZN9S20644C102v9Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void ABISELECT(_ZTvn1336_n56_N8S20644C2D1Ev,_ZTvn1056_n28_N8S20644C2D1Ev)();
extern void ABISELECT(_ZTvn1336_n56_N8S20644C2D0Ev,_ZTvn1056_n28_N8S20644C2D0Ev)();
extern void _ZN8S20644C72v5Ev();
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY vtc_S20644C2[] = {
  ABISELECT(6160,4632),
  ABISELECT(4672,3476),
  ABISELECT(4616,3436),
  ABISELECT(4464,3320),
  ABISELECT(4480,3324),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C2[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20644C2D1Ev,
  (VTBL_ENTRY)&_ZN8S20644C2D0Ev,
  (VTBL_ENTRY)&_ZN8S20644C72v5Ev,
  (VTBL_ENTRY)&_ZN8S20644C42v8Ev,
  (VTBL_ENTRY)&_ZN8S20644C23v10Ev,
  (VTBL_ENTRY)&_ZN8S20644C23v11Ev,
  ABISELECT(4336,3232),
  ABISELECT(4488,3348),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S20644C2[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
  ABISELECT(4192,3128),
  ABISELECT(-272,-192),
  (VTBL_ENTRY)&(_ZTI8S20644C2[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  ABISELECT(3776,2800),
  ABISELECT(3928,2916),
  ABISELECT(-688,-520),
  (VTBL_ENTRY)&(_ZTI8S20644C2[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  ABISELECT(1504,1192),
  ABISELECT(-2960,-2128),
  (VTBL_ENTRY)&(_ZTI8S20644C2[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  ABISELECT(1376,1084),
  ABISELECT(1512,1196),
  ABISELECT(1360,1080),
  ABISELECT(-3104,-2240),
  (VTBL_ENTRY)&(_ZTI8S20644C2[0]),
  0,
  0,
  0,
  ABISELECT(-16,-4),
  ABISELECT(-4480,-3324),
  (VTBL_ENTRY)&(_ZTI8S20644C2[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  0,
  0,
  0,
  ABISELECT(-4616,-3436),
  (VTBL_ENTRY)&(_ZTI8S20644C2[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  0,
  ABISELECT(-4672,-3476),
  ABISELECT(1488,1156),
  ABISELECT(-192,-152),
  ABISELECT(-56,-40),
  ABISELECT(-208,-156),
  ABISELECT(-4672,-3476),
  (VTBL_ENTRY)&(_ZTI8S20644C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S20644C2D1Ev,_ZTv0_n28_N8S20644C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S20644C2D0Ev,_ZTv0_n28_N8S20644C2D0Ev),
  (VTBL_ENTRY)&_ZN9S20644C102v9Ev,
  ABISELECT(-6008,-4532),
  (VTBL_ENTRY)&(_ZTI8S20644C2[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn1336_n56_N8S20644C2D1Ev,_ZTvn1056_n28_N8S20644C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1336_n56_N8S20644C2D0Ev,_ZTvn1056_n28_N8S20644C2D0Ev),
  (VTBL_ENTRY)&_ZN8S20644C72v5Ev,
  ABISELECT(144,104),
  ABISELECT(144,104),
  ABISELECT(144,104),
  0,
  0,
  ABISELECT(-1696,-1312),
  ABISELECT(-1544,-1196),
  ABISELECT(-6160,-4632),
  (VTBL_ENTRY)&(_ZTI8S20644C2[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
  ABISELECT(-1840,-1416),
  ABISELECT(-6304,-4736),
  (VTBL_ENTRY)&(_ZTI8S20644C2[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern VTBL_ENTRY _ZTV8S20644C2[];
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C4D1Ev();
extern void _ZN8S20644C4D0Ev();
extern void _ZN8S20644C72v5Ev();
extern void _ZN8S20644C42v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C4__8S20644C2[] = {
  ABISELECT(4616,3436),
  ABISELECT(4464,3320),
  ABISELECT(4480,3324),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C4[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  (VTBL_ENTRY)&_ZN8S20644C4D1Ev,
  (VTBL_ENTRY)&_ZN8S20644C4D0Ev,
  (VTBL_ENTRY)&_ZN8S20644C72v5Ev,
  (VTBL_ENTRY)&_ZN8S20644C42v8Ev,
};
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C88S20644C4__8S20644C2[] = {
  ABISELECT(4336,3232),
  ABISELECT(4488,3348),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
};
extern void _ZN8S20644C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C98S20644C88S20644C4__8S20644C2[] = {
  ABISELECT(4336,3232),
  ABISELECT(4488,3348),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C98S20644C88S20644C4__8S20644C2[] = {
  0,
  0,
  0,
  ABISELECT(-4488,-3348),
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C58S20644C88S20644C4__A1__8S20644C2[] = {
  ABISELECT(4192,3128),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C88S20644C4__8S20644C2[] = {
  0,
  0,
  0,
  ABISELECT(-4488,-3348),
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__8S20644C88S20644C4__8S20644C2[] = {
  ABISELECT(4192,3128),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C98S20644C4__A1__8S20644C2[] = {
  ABISELECT(3776,2800),
  ABISELECT(3928,2916),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C98S20644C4__A1__8S20644C2[] = {
  0,
  0,
  0,
  ABISELECT(-3928,-2916),
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__8S20644C4__8S20644C2[] = {
  0,
  0,
  0,
  ABISELECT(-16,-4),
  ABISELECT(-4480,-3324),
  (VTBL_ENTRY)&(_ZTI8S20644C4[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__A2__8S20644C4__8S20644C2[] = {
  0,
  0,
  0,
  ABISELECT(-4616,-3436),
  (VTBL_ENTRY)&(_ZTI8S20644C4[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C8__8S20644C4__8S20644C2[] = {
  ABISELECT(4336,3232),
  ABISELECT(4488,3348),
  ABISELECT(-128,-88),
  (VTBL_ENTRY)&(_ZTI8S20644C4[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C58S20644C8__A1__8S20644C4__8S20644C2[] = {
  ABISELECT(4192,3128),
  ABISELECT(-272,-192),
  (VTBL_ENTRY)&(_ZTI8S20644C4[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C9__A1__8S20644C4__8S20644C2[] = {
  ABISELECT(3776,2800),
  ABISELECT(3928,2916),
  ABISELECT(-688,-520),
  (VTBL_ENTRY)&(_ZTI8S20644C4[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__A__8S20644C2[] = {
  ABISELECT(1504,1192),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20644C11__A1__8S20644C2[] = {
  ABISELECT(1376,1084),
  ABISELECT(1512,1196),
  ABISELECT(1360,1080),
  0,
  (VTBL_ENTRY)&(_ZTI9S20644C11[0]),
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__9S20644C11__A1__8S20644C2[] = {
  0,
  0,
  0,
  ABISELECT(-1512,-1196),
  (VTBL_ENTRY)&(_ZTI9S20644C11[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__9S20644C11__A1__8S20644C2[] = {
  0,
  0,
  0,
  ABISELECT(-16,-4),
  ABISELECT(-1376,-1084),
  (VTBL_ENTRY)&(_ZTI9S20644C11[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__8S20644C2[] = {
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN9S20644C10D1Ev();
extern void _ZN9S20644C10D0Ev();
extern void _ZN9S20644C102v9Ev();
static  VTBL_ENTRY _tg__ZTV9S20644C10__8S20644C2[] = {
  ABISELECT(1488,1156),
  ABISELECT(-192,-152),
  ABISELECT(-56,-40),
  ABISELECT(-208,-156),
  0,
  (VTBL_ENTRY)&(_ZTI9S20644C10[0]),
  (VTBL_ENTRY)&_ZN9S20644C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20644C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20644C102v9Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20644C119S20644C10__8S20644C2[] = {
  ABISELECT(-192,-152),
  ABISELECT(-56,-40),
  ABISELECT(-208,-156),
  0,
  (VTBL_ENTRY)&(_ZTI9S20644C11[0]),
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__9S20644C119S20644C10__8S20644C2[] = {
  0,
  0,
  0,
  ABISELECT(56,40),
  (VTBL_ENTRY)&(_ZTI9S20644C11[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__9S20644C119S20644C10__8S20644C2[] = {
  0,
  0,
  0,
  ABISELECT(-16,-4),
  ABISELECT(192,152),
  (VTBL_ENTRY)&(_ZTI9S20644C11[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__9S20644C10__8S20644C2[] = {
  0,
  0,
  0,
  ABISELECT(56,40),
  (VTBL_ENTRY)&(_ZTI9S20644C10[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__9S20644C10__8S20644C2[] = {
  0,
  0,
  0,
  ABISELECT(-16,-4),
  ABISELECT(192,152),
  (VTBL_ENTRY)&(_ZTI9S20644C10[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C8__9S20644C10__8S20644C2[] = {
  ABISELECT(144,104),
  ABISELECT(144,104),
  ABISELECT(144,104),
  0,
  0,
  ABISELECT(-1696,-1312),
  ABISELECT(-1544,-1196),
  ABISELECT(-1488,-1156),
  (VTBL_ENTRY)&(_ZTI9S20644C10[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C58S20644C8__A1__9S20644C10__8S20644C2[] = {
  ABISELECT(-1840,-1416),
  ABISELECT(-1632,-1260),
  (VTBL_ENTRY)&(_ZTI9S20644C10[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C8__A1__8S20644C2[] = {
  ABISELECT(-1696,-1312),
  ABISELECT(-1544,-1196),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
};
extern void _ZN8S20644C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C98S20644C8__A2__8S20644C2[] = {
  ABISELECT(-1696,-1312),
  ABISELECT(-1544,-1196),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C98S20644C8__A2__8S20644C2[] = {
  0,
  0,
  0,
  ABISELECT(1544,1196),
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C58S20644C8__A3__8S20644C2[] = {
  ABISELECT(-1840,-1416),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C8__A1__8S20644C2[] = {
  0,
  0,
  0,
  ABISELECT(1544,1196),
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__8S20644C8__A1__8S20644C2[] = {
  ABISELECT(-1840,-1416),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
static  VTT_ENTRY vtt_S20644C2[] = {
  {&(_ZTV8S20644C2[7]),  7,101},
  {&(_tg__ZTV8S20644C4__8S20644C2[5]),  5,12},
  {&(_tg__ZTV8S20644C88S20644C4__8S20644C2[4]),  4,6},
  {&(_tg__ZTV8S20644C98S20644C88S20644C4__8S20644C2[4]),  4,5},
  {&(_tg__ZTV8S20644C6__8S20644C98S20644C88S20644C4__8S20644C2[5]),  5,8},
  {&(_tg__ZTV8S20644C58S20644C88S20644C4__A1__8S20644C2[3]),  3,6},
  {&(_tg__ZTV8S20644C6__8S20644C88S20644C4__8S20644C2[5]),  5,8},
  {&(_tg__ZTV8S20644C5__8S20644C88S20644C4__8S20644C2[3]),  3,6},
  {&(_tg__ZTV8S20644C98S20644C4__A1__8S20644C2[4]),  4,5},
  {&(_tg__ZTV8S20644C6__8S20644C98S20644C4__A1__8S20644C2[5]),  5,8},
  {&(_tg__ZTV8S20644C5__8S20644C4__8S20644C2[6]),  6,9},
  {&(_tg__ZTV8S20644C6__A2__8S20644C4__8S20644C2[5]),  5,8},
  {&(_tg__ZTV8S20644C8__8S20644C4__8S20644C2[4]),  4,6},
  {&(_tg__ZTV8S20644C58S20644C8__A1__8S20644C4__8S20644C2[3]),  3,6},
  {&(_tg__ZTV8S20644C9__A1__8S20644C4__8S20644C2[4]),  4,5},
  {&(_tg__ZTV8S20644C5__A__8S20644C2[3]),  3,6},
  {&(_tg__ZTV9S20644C11__A1__8S20644C2[5]),  5,5},
  {&(_tg__ZTV8S20644C6__9S20644C11__A1__8S20644C2[5]),  5,8},
  {&(_tg__ZTV8S20644C5__9S20644C11__A1__8S20644C2[6]),  6,9},
  {&(_ZTV8S20644C2[50]),  50,101},
  {&(_ZTV8S20644C2[58]),  58,101},
  {&(_ZTV8S20644C2[20]),  20,101},
  {&(_ZTV8S20644C2[25]),  25,101},
  {&(_ZTV8S20644C2[32]),  32,101},
  {&(_ZTV8S20644C2[36]),  36,101},
  {&(_ZTV8S20644C2[73]),  73,101},
  {&(_ZTV8S20644C2[93]),  93,101},
  {&(_ZTV8S20644C2[98]),  98,101},
  {&(_ZTV8S20644C2[78]),  78,101},
  {&(_ZTV8S20644C2[44]),  44,101},
  {&(_tg__ZTV8S20644C5__8S20644C2[3]),  3,6},
  {&(_tg__ZTV9S20644C10__8S20644C2[6]),  6,9},
  {&(_tg__ZTV9S20644C119S20644C10__8S20644C2[5]),  5,5},
  {&(_tg__ZTV8S20644C6__9S20644C119S20644C10__8S20644C2[5]),  5,8},
  {&(_tg__ZTV8S20644C5__9S20644C119S20644C10__8S20644C2[6]),  6,9},
  {&(_tg__ZTV8S20644C6__9S20644C10__8S20644C2[5]),  5,8},
  {&(_tg__ZTV8S20644C5__9S20644C10__8S20644C2[6]),  6,9},
  {&(_tg__ZTV8S20644C8__9S20644C10__8S20644C2[9]),  9,11},
  {&(_tg__ZTV8S20644C58S20644C8__A1__9S20644C10__8S20644C2[3]),  3,6},
  {&(_tg__ZTV8S20644C8__A1__8S20644C2[4]),  4,6},
  {&(_tg__ZTV8S20644C98S20644C8__A2__8S20644C2[4]),  4,5},
  {&(_tg__ZTV8S20644C6__8S20644C98S20644C8__A2__8S20644C2[5]),  5,8},
  {&(_tg__ZTV8S20644C58S20644C8__A3__8S20644C2[3]),  3,6},
  {&(_tg__ZTV8S20644C6__8S20644C8__A1__8S20644C2[5]),  5,8},
  {&(_tg__ZTV8S20644C5__8S20644C8__A1__8S20644C2[3]),  3,6},
};
extern VTBL_ENTRY _ZTI8S20644C2[];
extern  VTBL_ENTRY _ZTV8S20644C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C2[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S20644C2D0Ev,_ZTv0_n28_N8S20644C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4672_N8S20644C2D0Ev,_ZThn3476_N8S20644C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S20644C2D1Ev,_ZTv0_n28_N8S20644C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4672_N8S20644C2D1Ev,_ZThn3476_N8S20644C2D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20644C2 = {  "S20644C2", // class name
  bases_S20644C2, 31,
  &(vtc_S20644C2[0]), // expected_vtbl_contents
  &(vtt_S20644C2[0]), // expected_vtt_contents
  ABISELECT(6720,5064), // object size
  NSPAIRA(_ZTI8S20644C2),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S20644C2),101, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20644C2),45, //virtual table table var
  22, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20644C13  {
  void *s20644c13f0[7];
  ::S20644C9 s20644c13f1;
  long double s20644c13f2;
  int s20644c13f3;
  __tsi64 s20644c13f4;
  void *s20644c13f5;
  ::S20644C9 s20644c13f6;
  void *s20644c13f7[5];
  int s20644c13f8[8];
  void *s20644c13f9;
  virtual void  v12(); // _ZN9S20644C133v12Ev
  ~S20644C13(); // tgen
  S20644C13(); // tgen
};
//SIG(-1 S20644C13) C1{ v1 Fp[7] FC2{ VBC3{ BC4{ m Fi} v3 v4 v5 FC4[3] FC4[2] Fp Fs FC4} VBC4 v2 FC3 FD Fp[2] FC3} FD Fi FL Fp FC2 Fp[5] Fi[8] Fp}


void  S20644C13 ::v12(){vfunc_called(this, "_ZN9S20644C133v12Ev");}
S20644C13 ::~S20644C13(){ note_dtor("S20644C13", this);} // tgen
S20644C13 ::S20644C13(){ note_ctor("S20644C13", this);} // tgen

static void Test_S20644C13()
{
  extern Class_Descriptor cd_S20644C13;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(39,104)];
    init_test(&cd_S20644C13, buf);
    S20644C13 *dp, &lv = *(dp=new (buf) S20644C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(608,412), "sizeof(S20644C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20644C13)");
    check_field_offset(lv, s20644c13f0, ABISELECT(8,4), "S20644C13.s20644c13f0");
    check_field_offset(lv, s20644c13f1, ABISELECT(64,32), "S20644C13.s20644c13f1");
    check_field_offset(lv, s20644c13f2, ABISELECT(272,180), "S20644C13.s20644c13f2");
    check_field_offset(lv, s20644c13f3, ABISELECT(288,192), "S20644C13.s20644c13f3");
    check_field_offset(lv, s20644c13f4, ABISELECT(296,196), "S20644C13.s20644c13f4");
    check_field_offset(lv, s20644c13f5, ABISELECT(304,204), "S20644C13.s20644c13f5");
    check_field_offset(lv, s20644c13f6, ABISELECT(320,208), "S20644C13.s20644c13f6");
    check_field_offset(lv, s20644c13f7, ABISELECT(528,356), "S20644C13.s20644c13f7");
    check_field_offset(lv, s20644c13f8, ABISELECT(568,376), "S20644C13.s20644c13f8");
    check_field_offset(lv, s20644c13f9, ABISELECT(600,408), "S20644C13.s20644c13f9");
    test_class_info(&lv, &cd_S20644C13);
    dp->~S20644C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20644C13(Test_S20644C13, "S20644C13", ABISELECT(608,412));

#else // __cplusplus

extern void _ZN9S20644C13C1Ev();
extern void _ZN9S20644C13D1Ev();
Name_Map name_map_S20644C13[] = {
  NSPAIR(_ZN9S20644C13C1Ev),
  NSPAIR(_ZN9S20644C13D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S20644C13[];
extern void _ZN9S20644C133v12Ev();
static  VTBL_ENTRY vtc_S20644C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S20644C13[0]),
  (VTBL_ENTRY)&_ZN9S20644C133v12Ev,
};
extern VTBL_ENTRY _ZTI9S20644C13[];
extern  VTBL_ENTRY _ZTV9S20644C13[];
Class_Descriptor cd_S20644C13 = {  "S20644C13", // class name
  0,0,//no base classes
  &(vtc_S20644C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(608,412), // object size
  NSPAIRA(_ZTI9S20644C13),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S20644C13),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20644C14  : virtual S3216C8_nt , S20644C8 , S20644C9 , S20644C5 {
  int s20644c14f0;
  ::S20643C15_nt s20644c14f1;
  void *s20644c14f2[2];
  virtual void  v13(); // _ZN9S20644C143v13Ev
  ~S20644C14(); // tgen
  S20644C14(); // tgen
};
//SIG(-1 S20644C14) C1{ VBC2{ m Fi} BC3{ VBC4{ BC2 v2 v3 v4 FC2[3] FC2[2] Fp Fs FC2} VBC2 BC5{ VBC4 VBC2 v5 FC4 FD Fp[2] FC4} BC6{ BC4 VBC2 FD FL FC4 Fp Fs[3]} v6 Fp[2] Fl Fi FC4[5]} BC5 BC6 v1 Fi FC7{} Fp[2]}


void  S20644C14 ::v13(){vfunc_called(this, "_ZN9S20644C143v13Ev");}
S20644C14 ::~S20644C14(){ note_dtor("S20644C14", this);} // tgen
S20644C14 ::S20644C14(){ note_ctor("S20644C14", this);} // tgen

static void Test_S20644C14()
{
  extern Class_Descriptor cd_S20644C14;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(59,178)];
    init_test(&cd_S20644C14, buf);
    S20644C14 *dp, &lv = *(dp=new (buf) S20644C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(928,708), "sizeof(S20644C14)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20644C14)");
    /*is_ambiguous_... S20644C14::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*), ABISELECT(864,664), "S20644C14");
    /*is_ambiguous_... S20644C8::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C8*), ABISELECT(864,664), "S20644C14");
    /*is_ambiguous_... S20644C9::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C9*)(S20644C8*), ABISELECT(864,664), "S20644C14");
    /*is_ambiguous_... S20644C5::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*)(S20644C8*), ABISELECT(864,664), "S20644C14");
    /*is_ambiguous_... S20644C14::S20644C9 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C9*), ABISELECT(864,664), "S20644C14");
    /*is_ambiguous_... S20644C14::S20644C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*), ABISELECT(864,664), "S20644C14");
    /*is_ambiguous_... S20644C14::S20644C6 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*), ABISELECT(880,672), "S20644C14");
    /*is_ambiguous_... S20644C8::S20644C6 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C8*), ABISELECT(872,668), "S20644C14");
    check_base_class_offset(lv, (S20644C6*)(S20644C9*)(S20644C8*), ABISELECT(872,668), "S20644C14");
    /*is_ambiguous_... S20644C14::S20644C9 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C9*), ABISELECT(872,668), "S20644C14");
    check_base_class_offset(lv, (S20644C9*)(S20644C8*), 0, "S20644C14");
    check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*)(S20644C8*), ABISELECT(152,108), "S20644C14");
    check_base_class_offset(lv, (S20644C6*)(S20644C5*)(S20644C8*), ABISELECT(144,104), "S20644C14");
    check_base_class_offset(lv, (S20644C5*)(S20644C8*), ABISELECT(144,104), "S20644C14");
    check_base_class_offset(lv, (S20644C8*), 0, "S20644C14");
    /*is_ambiguous_... S20644C14::S20644C9 */ AMB_check_base_class_offset(lv, (S20644C9*), ABISELECT(560,432), "S20644C14");
    /*is_ambiguous_... S20644C14::S20644C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*), ABISELECT(712,540), "S20644C14");
    /*is_ambiguous_... S20644C14::S20644C5 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C5*), ABISELECT(704,536), "S20644C14");
    /*is_ambiguous_... S20644C14::S20644C5 */ AMB_check_base_class_offset(lv, (S20644C5*), ABISELECT(704,536), "S20644C14");
    check_field_offset(lv, s20644c14f0, ABISELECT(840,648), "S20644C14.s20644c14f0");
    check_field_offset(lv, s20644c14f1, ABISELECT(844,652), "S20644C14.s20644c14f1");
    check_field_offset(lv, s20644c14f2, ABISELECT(848,656), "S20644C14.s20644c14f2");
    test_class_info(&lv, &cd_S20644C14);
    dp->~S20644C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20644C14(Test_S20644C14, "S20644C14", ABISELECT(928,708));

#else // __cplusplus

extern void _ZN9S20644C14C1Ev();
extern void _ZN9S20644C14D1Ev();
Name_Map name_map_S20644C14[] = {
  NSPAIR(_ZN9S20644C14C1Ev),
  NSPAIR(_ZN9S20644C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C9;
extern VTBL_ENTRY _ZTI8S20644C9[];
extern  VTBL_ENTRY _ZTV8S20644C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
extern Class_Descriptor cd_S20644C8;
extern VTBL_ENTRY _ZTI8S20644C8[];
extern  VTBL_ENTRY _ZTV8S20644C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C8[];
extern Class_Descriptor cd_S20644C9;
extern VTBL_ENTRY _ZTI8S20644C9[];
extern  VTBL_ENTRY _ZTV8S20644C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
static Base_Class bases_S20644C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C8_nt,    ABISELECT(864,664), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3216C8_nt,    ABISELECT(880,672), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(872,668), //bcp->offset
    24, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20644C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(152,108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(144,104), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20644C5,    ABISELECT(144,104), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20644C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20644C9,    ABISELECT(560,432), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3216C8_nt,    ABISELECT(712,540), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(704,536), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20644C5,    ABISELECT(704,536), //bcp->offset
    18, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20644C14[];
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
extern void _ZN9S20644C143v13Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY vtc_S20644C14[] = {
  ABISELECT(864,664),
  ABISELECT(872,668),
  0,
  (VTBL_ENTRY)&(_ZTI9S20644C14[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20644C143v13Ev,
  ABISELECT(720,560),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI9S20644C14[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  ABISELECT(304,232),
  ABISELECT(312,236),
  ABISELECT(-560,-432),
  (VTBL_ENTRY)&(_ZTI9S20644C14[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  ABISELECT(160,128),
  ABISELECT(-704,-536),
  (VTBL_ENTRY)&(_ZTI9S20644C14[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  0,
  0,
  0,
  ABISELECT(-872,-668),
  (VTBL_ENTRY)&(_ZTI9S20644C14[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern VTBL_ENTRY _ZTV9S20644C14[];
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C8__9S20644C14[] = {
  ABISELECT(864,664),
  ABISELECT(872,668),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
};
extern void _ZN8S20644C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C98S20644C8__9S20644C14[] = {
  ABISELECT(864,664),
  ABISELECT(872,668),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C98S20644C8__9S20644C14[] = {
  0,
  0,
  0,
  ABISELECT(-872,-668),
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C58S20644C8__9S20644C14[] = {
  ABISELECT(720,560),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C8__9S20644C14[] = {
  0,
  0,
  0,
  ABISELECT(-872,-668),
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__8S20644C8__9S20644C14[] = {
  ABISELECT(720,560),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C9__A1__9S20644C14[] = {
  ABISELECT(304,232),
  ABISELECT(312,236),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C9__A1__9S20644C14[] = {
  0,
  0,
  0,
  ABISELECT(-312,-236),
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__A1__9S20644C14[] = {
  ABISELECT(160,128),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
static  VTT_ENTRY vtt_S20644C14[] = {
  {&(_ZTV9S20644C14[4]),  4,32},
  {&(_tg__ZTV8S20644C8__9S20644C14[4]),  4,6},
  {&(_tg__ZTV8S20644C98S20644C8__9S20644C14[4]),  4,5},
  {&(_tg__ZTV8S20644C6__8S20644C98S20644C8__9S20644C14[5]),  5,8},
  {&(_tg__ZTV8S20644C58S20644C8__9S20644C14[3]),  3,6},
  {&(_tg__ZTV8S20644C6__8S20644C8__9S20644C14[5]),  5,8},
  {&(_tg__ZTV8S20644C5__8S20644C8__9S20644C14[3]),  3,6},
  {&(_tg__ZTV8S20644C9__A1__9S20644C14[4]),  4,5},
  {&(_tg__ZTV8S20644C6__8S20644C9__A1__9S20644C14[5]),  5,8},
  {&(_tg__ZTV8S20644C5__A1__9S20644C14[3]),  3,6},
  {&(_ZTV9S20644C14[29]),  29,32},
  {&(_ZTV9S20644C14[10]),  10,32},
  {&(_ZTV9S20644C14[17]),  17,32},
  {&(_ZTV9S20644C14[21]),  21,32},
};
extern VTBL_ENTRY _ZTI9S20644C14[];
extern  VTBL_ENTRY _ZTV9S20644C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20644C14[];
Class_Descriptor cd_S20644C14 = {  "S20644C14", // class name
  bases_S20644C14, 12,
  &(vtc_S20644C14[0]), // expected_vtbl_contents
  &(vtt_S20644C14[0]), // expected_vtt_contents
  ABISELECT(928,708), // object size
  NSPAIRA(_ZTI9S20644C14),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S20644C14),32, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20644C14),14, //virtual table table var
  8, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20644C12  : S20644C13 , S20644C5 , S20644C14 {
  virtual  ~S20644C12(); // _ZN9S20644C12D2Ev
  S20644C12(); // tgen
};
//SIG(-1 S20644C12) C1{ BC2{ v1 Fp[7] FC3{ VBC4{ BC5{ m Fi} v2 v3 v4 FC5[3] FC5[2] Fp Fs FC5} VBC5 v5 FC4 FD Fp[2] FC4} FD Fi FL Fp FC3 Fp[5] Fi[8] Fp} BC6{ BC4 VBC5 FD FL FC4 Fp Fs[3]} BC7{ VBC5 BC8{ VBC4 VBC5 BC3 BC6 v6 Fp[2] Fl Fi FC4[5]} BC3 BC6 v7 Fi FC9{} Fp[2]} vd}


 S20644C12 ::~S20644C12(){ note_dtor("S20644C12", this);}
S20644C12 ::S20644C12(){ note_ctor("S20644C12", this);} // tgen

static void Test_S20644C12()
{
  extern Class_Descriptor cd_S20644C12;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(106,309)];
    init_test(&cd_S20644C12, buf);
    S20644C12 *dp, &lv = *(dp=new (buf) S20644C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1680,1232), "sizeof(S20644C12)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20644C12)");
    check_base_class_offset(lv, (S20644C13*), 0, "S20644C12");
    /*is_ambiguous_... S20644C12::S20644C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*), ABISELECT(616,416), "S20644C12");
    /*is_ambiguous_... S20644C12::S20644C5 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C5*), ABISELECT(608,412), "S20644C12");
    /*is_ambiguous_... S20644C12::S20644C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*), ABISELECT(1616,1188), "S20644C12");
    /*is_ambiguous_... S20644C14::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C14*), ABISELECT(1616,1188), "S20644C12");
    /*is_ambiguous_... S20644C8::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C8*)(S20644C14*), ABISELECT(1616,1188), "S20644C12");
    /*is_ambiguous_... S20644C9::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C9*)(S20644C8*)(S20644C14*), ABISELECT(1616,1188), "S20644C12");
    /*is_ambiguous_... S20644C5::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*)(S20644C8*)(S20644C14*), ABISELECT(1616,1188), "S20644C12");
    /*is_ambiguous_... S20644C14::S20644C9 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C9*)(S20644C14*), ABISELECT(1616,1188), "S20644C12");
    /*is_ambiguous_... S20644C14::S20644C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*)(S20644C14*), ABISELECT(1616,1188), "S20644C12");
    /*is_ambiguous_... S20644C12::S20644C5 */ AMB_check_base_class_offset(lv, (S20644C5*), ABISELECT(608,412), "S20644C12");
    /*is_ambiguous_... S20644C12::S20644C6 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*), ABISELECT(1632,1196), "S20644C12");
    /*is_ambiguous_... S20644C8::S20644C6 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C8*)(S20644C14*), ABISELECT(1624,1192), "S20644C12");
    check_base_class_offset(lv, (S20644C6*)(S20644C9*)(S20644C8*)(S20644C14*), ABISELECT(1624,1192), "S20644C12");
    /*is_ambiguous_... S20644C14::S20644C9 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C9*)(S20644C14*), ABISELECT(1624,1192), "S20644C12");
    check_base_class_offset(lv, (S20644C9*)(S20644C8*)(S20644C14*), ABISELECT(752,524), "S20644C12");
    check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*)(S20644C8*)(S20644C14*), ABISELECT(904,632), "S20644C12");
    check_base_class_offset(lv, (S20644C6*)(S20644C5*)(S20644C8*)(S20644C14*), ABISELECT(896,628), "S20644C12");
    check_base_class_offset(lv, (S20644C5*)(S20644C8*)(S20644C14*), ABISELECT(896,628), "S20644C12");
    check_base_class_offset(lv, (S20644C8*)(S20644C14*), ABISELECT(752,524), "S20644C12");
    /*is_ambiguous_... S20644C14::S20644C9 */ AMB_check_base_class_offset(lv, (S20644C9*)(S20644C14*), ABISELECT(1312,956), "S20644C12");
    /*is_ambiguous_... S20644C14::S20644C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*)(S20644C14*), ABISELECT(1464,1064), "S20644C12");
    /*is_ambiguous_... S20644C14::S20644C5 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C5*)(S20644C14*), ABISELECT(1456,1060), "S20644C12");
    /*is_ambiguous_... S20644C14::S20644C5 */ AMB_check_base_class_offset(lv, (S20644C5*)(S20644C14*), ABISELECT(1456,1060), "S20644C12");
    check_base_class_offset(lv, (S20644C14*), ABISELECT(752,524), "S20644C12");
    test_class_info(&lv, &cd_S20644C12);
    dp->~S20644C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20644C12(Test_S20644C12, "S20644C12", ABISELECT(1680,1232));

#else // __cplusplus

extern void _ZN9S20644C12C1Ev();
extern void _ZN9S20644C12D2Ev();
Name_Map name_map_S20644C12[] = {
  NSPAIR(_ZN9S20644C12C1Ev),
  NSPAIR(_ZN9S20644C12D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S20644C13;
extern VTBL_ENTRY _ZTI9S20644C13[];
extern  VTBL_ENTRY _ZTV9S20644C13[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C9;
extern VTBL_ENTRY _ZTI8S20644C9[];
extern  VTBL_ENTRY _ZTV8S20644C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
extern Class_Descriptor cd_S20644C8;
extern VTBL_ENTRY _ZTI8S20644C8[];
extern  VTBL_ENTRY _ZTV8S20644C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C8[];
extern Class_Descriptor cd_S20644C9;
extern VTBL_ENTRY _ZTI8S20644C9[];
extern  VTBL_ENTRY _ZTV8S20644C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
extern Class_Descriptor cd_S20644C14;
extern VTBL_ENTRY _ZTI9S20644C14[];
extern  VTBL_ENTRY _ZTV9S20644C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20644C14[];
static Base_Class bases_S20644C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20644C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3216C8_nt,    ABISELECT(616,416), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(608,412), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(1616,1188), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S20644C5,    ABISELECT(608,412), //bcp->offset
    7, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3216C8_nt,    ABISELECT(1632,1196), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(1624,1192), //bcp->offset
    37, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S20644C9,    ABISELECT(752,524), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(904,632), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(896,628), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20644C5,    ABISELECT(896,628), //bcp->offset
    20, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20644C8,    ABISELECT(752,524), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20644C9,    ABISELECT(1312,956), //bcp->offset
    26, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(1464,1064), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(1456,1060), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20644C5,    ABISELECT(1456,1060), //bcp->offset
    31, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20644C14,    ABISELECT(752,524), //bcp->offset
    13, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20644C12[];
extern void _ZN9S20644C133v12Ev();
extern void _ZN9S20644C12D1Ev();
extern void _ZN9S20644C12D0Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
extern void _ZN9S20644C143v13Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY vtc_S20644C12[] = {
  ABISELECT(1624,1192),
  ABISELECT(1616,1188),
  0,
  (VTBL_ENTRY)&(_ZTI9S20644C12[0]),
  (VTBL_ENTRY)&_ZN9S20644C133v12Ev,
  (VTBL_ENTRY)&_ZN9S20644C12D1Ev,
  (VTBL_ENTRY)&_ZN9S20644C12D0Ev,
  ABISELECT(1008,776),
  ABISELECT(-608,-412),
  (VTBL_ENTRY)&(_ZTI9S20644C12[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  ABISELECT(864,664),
  ABISELECT(872,668),
  ABISELECT(-752,-524),
  (VTBL_ENTRY)&(_ZTI9S20644C12[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20644C143v13Ev,
  ABISELECT(720,560),
  ABISELECT(-896,-628),
  (VTBL_ENTRY)&(_ZTI9S20644C12[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  ABISELECT(304,232),
  ABISELECT(312,236),
  ABISELECT(-1312,-956),
  (VTBL_ENTRY)&(_ZTI9S20644C12[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  ABISELECT(160,128),
  ABISELECT(-1456,-1060),
  (VTBL_ENTRY)&(_ZTI9S20644C12[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  0,
  0,
  0,
  ABISELECT(-1624,-1192),
  (VTBL_ENTRY)&(_ZTI9S20644C12[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern VTBL_ENTRY _ZTV9S20644C12[];
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__9S20644C12[] = {
  ABISELECT(1008,776),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
extern void _ZN9S20644C143v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20644C14__9S20644C12[] = {
  ABISELECT(864,664),
  ABISELECT(872,668),
  0,
  (VTBL_ENTRY)&(_ZTI9S20644C14[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20644C143v13Ev,
};
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C89S20644C14__9S20644C12[] = {
  ABISELECT(864,664),
  ABISELECT(872,668),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
};
extern void _ZN8S20644C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C98S20644C89S20644C14__9S20644C12[] = {
  ABISELECT(864,664),
  ABISELECT(872,668),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C98S20644C89S20644C14__9S20644C12[] = {
  0,
  0,
  0,
  ABISELECT(-872,-668),
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C58S20644C89S20644C14__A1__9S20644C12[] = {
  ABISELECT(720,560),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C89S20644C14__9S20644C12[] = {
  0,
  0,
  0,
  ABISELECT(-872,-668),
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__8S20644C89S20644C14__9S20644C12[] = {
  ABISELECT(720,560),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C99S20644C14__A1__9S20644C12[] = {
  ABISELECT(304,232),
  ABISELECT(312,236),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C99S20644C14__A1__9S20644C12[] = {
  0,
  0,
  0,
  ABISELECT(-312,-236),
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C59S20644C14__A2__9S20644C12[] = {
  ABISELECT(160,128),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__9S20644C14__9S20644C12[] = {
  0,
  0,
  0,
  ABISELECT(-872,-668),
  (VTBL_ENTRY)&(_ZTI9S20644C14[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C58S20644C8__9S20644C14__9S20644C12[] = {
  ABISELECT(720,560),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI9S20644C14[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C9__A1__9S20644C14__9S20644C12[] = {
  ABISELECT(304,232),
  ABISELECT(312,236),
  ABISELECT(-560,-432),
  (VTBL_ENTRY)&(_ZTI9S20644C14[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__A1__9S20644C14__9S20644C12[] = {
  ABISELECT(160,128),
  ABISELECT(-704,-536),
  (VTBL_ENTRY)&(_ZTI9S20644C14[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
static  VTT_ENTRY vtt_S20644C12[] = {
  {&(_ZTV9S20644C12[4]),  4,45},
  {&(_tg__ZTV8S20644C5__9S20644C12[3]),  3,6},
  {&(_tg__ZTV9S20644C14__9S20644C12[4]),  4,7},
  {&(_tg__ZTV8S20644C89S20644C14__9S20644C12[4]),  4,6},
  {&(_tg__ZTV8S20644C98S20644C89S20644C14__9S20644C12[4]),  4,5},
  {&(_tg__ZTV8S20644C6__8S20644C98S20644C89S20644C14__9S20644C12[5]),  5,8},
  {&(_tg__ZTV8S20644C58S20644C89S20644C14__A1__9S20644C12[3]),  3,6},
  {&(_tg__ZTV8S20644C6__8S20644C89S20644C14__9S20644C12[5]),  5,8},
  {&(_tg__ZTV8S20644C5__8S20644C89S20644C14__9S20644C12[3]),  3,6},
  {&(_tg__ZTV8S20644C99S20644C14__A1__9S20644C12[4]),  4,5},
  {&(_tg__ZTV8S20644C6__8S20644C99S20644C14__A1__9S20644C12[5]),  5,8},
  {&(_tg__ZTV8S20644C59S20644C14__A2__9S20644C12[3]),  3,6},
  {&(_tg__ZTV8S20644C6__9S20644C14__9S20644C12[5]),  5,8},
  {&(_tg__ZTV8S20644C58S20644C8__9S20644C14__9S20644C12[3]),  3,6},
  {&(_tg__ZTV8S20644C9__A1__9S20644C14__9S20644C12[4]),  4,5},
  {&(_tg__ZTV8S20644C5__A1__9S20644C14__9S20644C12[3]),  3,6},
  {&(_ZTV9S20644C12[10]),  10,45},
  {&(_ZTV9S20644C12[17]),  17,45},
  {&(_ZTV9S20644C12[42]),  42,45},
  {&(_ZTV9S20644C12[23]),  23,45},
  {&(_ZTV9S20644C12[30]),  30,45},
  {&(_ZTV9S20644C12[34]),  34,45},
};
extern VTBL_ENTRY _ZTI9S20644C12[];
extern  VTBL_ENTRY _ZTV9S20644C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20644C12[];
Class_Descriptor cd_S20644C12 = {  "S20644C12", // class name
  bases_S20644C12, 17,
  &(vtc_S20644C12[0]), // expected_vtbl_contents
  &(vtt_S20644C12[0]), // expected_vtt_contents
  ABISELECT(1680,1232), // object size
  NSPAIRA(_ZTI9S20644C12),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV9S20644C12),45, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20644C12),22, //virtual table table var
  12, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S20644C19  {
  __tsi64 s20644c19f0:3;
  int s20644c19f1;
  int s20644c19f2;
  int s20644c19f3;
  long double s20644c19f4[8];
  void *s20644c19f5;
  char s20644c19f6[5];
  long double s20644c19f7;
  char s20644c19f8[4];
  int s20644c19f9;
  void *s20644c19f10;
  char s20644c19f11[4];
  void *s20644c19f12;
  void  mf20644c19(); // _ZN9S20644C1910mf20644c19Ev
};
//SIG(1 S20644C19) U1{ m FL:3 Fi Fi Fi FD[8] Fp Fc[5] FD Fc[4] Fi Fp Fc[4] Fp}

#endif // __cplusplus
#ifdef __cplusplus

struct  S20644C18  {
  char s20644c18f0[2];
  int s20644c18f1;
  __tsi64 s20644c18f2;
  void *s20644c18f3[7];
  ::S20644C19 s20644c18f4[4];
  ::S20644C11 s20644c18f5;
  void  mf20644c18(); // _ZN9S20644C1810mf20644c18Ev
  virtual  ~S20644C18(); // _ZN9S20644C18D1Ev
  S20644C18(); // tgen
};
//SIG(-1 S20644C18) C1{ vd m Fc[2] Fi FL Fp[7] FU2{ m FL:3 Fi Fi Fi FD[8] Fp Fc[5] FD Fc[4] Fi Fp Fc[4] Fp}[4] FC3{ VBC4{ m Fi} VBC5{ BC4 v1 v2 v3 FC4[3] FC4[2] Fp Fs FC4} VBC6{ BC5 VBC4 FD FL FC5 Fp Fs[3]} Fp[2] Fi FC6[8] FD[9]}}


void  S20644C18 ::mf20644c18(){}
 S20644C18 ::~S20644C18(){ note_dtor("S20644C18", this);}
S20644C18 ::S20644C18(){ note_ctor("S20644C18", this);} // tgen

static void Test_S20644C18()
{
  extern Class_Descriptor cd_S20644C18;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(134,411)];
    init_test(&cd_S20644C18, buf);
    S20644C18 *dp, &lv = *(dp=new (buf) S20644C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2128,1640), "sizeof(S20644C18)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20644C18)");
    check_field_offset(lv, s20644c18f0, ABISELECT(8,4), "S20644C18.s20644c18f0");
    check_field_offset(lv, s20644c18f1, ABISELECT(12,8), "S20644C18.s20644c18f1");
    check_field_offset(lv, s20644c18f2, ABISELECT(16,12), "S20644C18.s20644c18f2");
    check_field_offset(lv, s20644c18f3, ABISELECT(24,20), "S20644C18.s20644c18f3");
    check_field_offset(lv, s20644c18f4, ABISELECT(80,48), "S20644C18.s20644c18f4");
    check_field_offset(lv, s20644c18f5, ABISELECT(592,432), "S20644C18.s20644c18f5");
    test_class_info(&lv, &cd_S20644C18);
    dp->~S20644C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20644C18(Test_S20644C18, "S20644C18", ABISELECT(2128,1640));

#else // __cplusplus

extern void _ZN9S20644C18C1Ev();
extern void _ZN9S20644C18D1Ev();
Name_Map name_map_S20644C18[] = {
  NSPAIR(_ZN9S20644C18C1Ev),
  NSPAIR(_ZN9S20644C18D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S20644C18[];
extern void _ZN9S20644C18D1Ev();
extern void _ZN9S20644C18D0Ev();
static  VTBL_ENTRY vtc_S20644C18[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S20644C18[0]),
  (VTBL_ENTRY)&_ZN9S20644C18D1Ev,
  (VTBL_ENTRY)&_ZN9S20644C18D0Ev,
};
extern VTBL_ENTRY _ZTI9S20644C18[];
extern  VTBL_ENTRY _ZTV9S20644C18[];
Class_Descriptor cd_S20644C18 = {  "S20644C18", // class name
  0,0,//no base classes
  &(vtc_S20644C18[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(2128,1640), // object size
  NSPAIRA(_ZTI9S20644C18),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S20644C18),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20644C17  : S20644C5 , virtual S20644C10 , S20644C8 , S20644C14 {
  int s20644c17f0;
  char s20644c17f1[2];
  int s20644c17f2;
  __tsi64 s20644c17f3;
  ::S20643C15_nt s20644c17f4;
  void *s20644c17f5[8];
  short s20644c17f6[5];
  __tsi64 s20644c17f7;
  ::S20644C18 s20644c17f8;
  virtual  ~S20644C17(); // _ZN9S20644C17D2Ev
  S20644C17(); // tgen
};
//SIG(-1 S20644C17) C1{ BC2{ BC3{ BC4{ m Fi} v1 v2 v3 FC4[3] FC4[2] Fp Fs FC4} VBC4 FD FL FC3 Fp Fs[3]} VBC5{ BC6{ VBC4 VBC3 VBC2 Fp[2] Fi FC2[8] FD[9]} BC4 VBC7{ VBC3 VBC4 BC8{ VBC3 VBC4 v4 FC3 FD Fp[2] FC3} BC2 v5 Fp[2] Fl Fi FC3[5]} BC9{ BC3 vd v6 Fp[7] Fi[2] FL Fi} vd v7 Fi Fp Fi} BC7 BC10{ VBC4 BC7 BC8 BC2 v8 Fi FC11{} Fp[2]} vd Fi Fc[2] Fi FL FC11 Fp[8] Fs[5] FL FC12{ vd m Fc[2] Fi FL Fp[7] FU13{ m FL:3 Fi Fi Fi FD[8] Fp Fc[5] FD Fc[4] Fi Fp Fc[4] Fp}[4] FC6}}


 S20644C17 ::~S20644C17(){ note_dtor("S20644C17", this);}
S20644C17 ::S20644C17(){ note_ctor("S20644C17", this);} // tgen

static void Test_S20644C17()
{
  extern Class_Descriptor cd_S20644C17;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(381,1168)];
    init_test(&cd_S20644C17, buf);
    S20644C17 *dp, &lv = *(dp=new (buf) S20644C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(6080,4668), "sizeof(S20644C17)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20644C17)");
    /*is_ambiguous_... S20644C17::S20644C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*), ABISELECT(8,4), "S20644C17");
    /*is_ambiguous_... S20644C17::S20644C5 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C5*), 0, "S20644C17");
    /*is_ambiguous_... S20644C17::S20644C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*), ABISELECT(3824,2924), "S20644C17");
    /*is_ambiguous_... S20644C11::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C11*)(S20644C10*), ABISELECT(3824,2924), "S20644C17");
    /*is_ambiguous_... S20644C17::S20644C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*), ABISELECT(3824,2924), "S20644C17");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C8*), ABISELECT(3824,2924), "S20644C17");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C9*)(S20644C8*), ABISELECT(3824,2924), "S20644C17");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*)(S20644C8*), ABISELECT(3824,2924), "S20644C17");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C8*), ABISELECT(3824,2924), "S20644C17");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C9*)(S20644C8*), ABISELECT(3824,2924), "S20644C17");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*)(S20644C8*), ABISELECT(3824,2924), "S20644C17");
    /*is_ambiguous_... S20644C14::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C14*), ABISELECT(3824,2924), "S20644C17");
    /*is_ambiguous_... S20644C8::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C8*)(S20644C14*), ABISELECT(3824,2924), "S20644C17");
    /*is_ambiguous_... S20644C9::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C9*)(S20644C8*)(S20644C14*), ABISELECT(3824,2924), "S20644C17");
    /*is_ambiguous_... S20644C5::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*)(S20644C8*)(S20644C14*), ABISELECT(3824,2924), "S20644C17");
    /*is_ambiguous_... S20644C14::S20644C9 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C9*)(S20644C14*), ABISELECT(3824,2924), "S20644C17");
    /*is_ambiguous_... S20644C14::S20644C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*)(S20644C14*), ABISELECT(3824,2924), "S20644C17");
    /*is_ambiguous_... S20644C17::S20644C5 */ AMB_check_base_class_offset(lv, (S20644C5*), 0, "S20644C17");
    /*is_ambiguous_... S20644C17::S20644C6 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*), ABISELECT(5328,4088), "S20644C17");
    /*is_ambiguous_... S20644C11::S20644C6 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C11*)(S20644C10*), ABISELECT(5320,4084), "S20644C17");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C8*), ABISELECT(5320,4084), "S20644C17");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C9*)(S20644C8*), ABISELECT(5320,4084), "S20644C17");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C8*), ABISELECT(5320,4084), "S20644C17");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C9*)(S20644C8*), ABISELECT(5320,4084), "S20644C17");
    /*is_ambiguous_... S20644C8::S20644C6 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C8*)(S20644C14*), ABISELECT(5320,4084), "S20644C17");
    check_base_class_offset(lv, (S20644C6*)(S20644C9*)(S20644C8*)(S20644C14*), ABISELECT(5320,4084), "S20644C17");
    /*is_ambiguous_... S20644C14::S20644C9 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C9*)(S20644C14*), ABISELECT(5320,4084), "S20644C17");
    /*is_ambiguous_... S20644C17::S20644C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*), ABISELECT(5384,4128), "S20644C17");
    /*is_ambiguous_... S20644C17::S20644C5 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C5*), ABISELECT(5376,4124), "S20644C17");
    check_base_class_offset(lv, (S20644C5*)(S20644C11*)(S20644C10*), ABISELECT(5376,4124), "S20644C17");
    check_base_class_offset(lv, (S20644C11*)(S20644C10*), ABISELECT(3840,2928), "S20644C17");
    /*is_ambiguous_... S20644C10::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C10*), ABISELECT(5168,3980), "S20644C17");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C9*)(S20644C8*), ABISELECT(5520,4236), "S20644C17");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*)(S20644C8*), ABISELECT(5672,4344), "S20644C17");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C5*)(S20644C8*), ABISELECT(5664,4340), "S20644C17");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C5*)(S20644C8*), ABISELECT(5664,4340), "S20644C17");
    check_base_class_offset(lv, (S20644C8*)(S20644C10*), ABISELECT(5520,4236), "S20644C17");
    check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C7*)(S20644C10*), ABISELECT(5184,3988), "S20644C17");
    check_base_class_offset(lv, (S20644C6*)(S20644C7*)(S20644C10*), ABISELECT(5176,3984), "S20644C17");
    check_base_class_offset(lv, (S20644C7*)(S20644C10*), ABISELECT(5176,3984), "S20644C17");
    check_base_class_offset(lv, (S20644C10*), ABISELECT(3840,2928), "S20644C17");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C9*)(S20644C8*), ABISELECT(144,112), "S20644C17");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*)(S20644C8*), ABISELECT(296,220), "S20644C17");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C5*)(S20644C8*), ABISELECT(288,216), "S20644C17");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C5*)(S20644C8*), ABISELECT(288,216), "S20644C17");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C8*), ABISELECT(144,112), "S20644C17");
    check_base_class_offset(lv, (S20644C9*)(S20644C8*)(S20644C14*), ABISELECT(704,544), "S20644C17");
    check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*)(S20644C8*)(S20644C14*), ABISELECT(856,652), "S20644C17");
    check_base_class_offset(lv, (S20644C6*)(S20644C5*)(S20644C8*)(S20644C14*), ABISELECT(848,648), "S20644C17");
    check_base_class_offset(lv, (S20644C5*)(S20644C8*)(S20644C14*), ABISELECT(848,648), "S20644C17");
    check_base_class_offset(lv, (S20644C8*)(S20644C14*), ABISELECT(704,544), "S20644C17");
    /*is_ambiguous_... S20644C14::S20644C9 */ AMB_check_base_class_offset(lv, (S20644C9*)(S20644C14*), ABISELECT(1264,976), "S20644C17");
    /*is_ambiguous_... S20644C14::S20644C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*)(S20644C14*), ABISELECT(1416,1084), "S20644C17");
    /*is_ambiguous_... S20644C14::S20644C5 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C5*)(S20644C14*), ABISELECT(1408,1080), "S20644C17");
    /*is_ambiguous_... S20644C14::S20644C5 */ AMB_check_base_class_offset(lv, (S20644C5*)(S20644C14*), ABISELECT(1408,1080), "S20644C17");
    check_base_class_offset(lv, (S20644C14*), ABISELECT(704,544), "S20644C17");
    check_field_offset(lv, s20644c17f0, ABISELECT(1568,1208), "S20644C17.s20644c17f0");
    check_field_offset(lv, s20644c17f1, ABISELECT(1572,1212), "S20644C17.s20644c17f1");
    check_field_offset(lv, s20644c17f2, ABISELECT(1576,1216), "S20644C17.s20644c17f2");
    check_field_offset(lv, s20644c17f3, ABISELECT(1584,1220), "S20644C17.s20644c17f3");
    check_field_offset(lv, s20644c17f4, ABISELECT(1592,1228), "S20644C17.s20644c17f4");
    check_field_offset(lv, s20644c17f5, ABISELECT(1600,1232), "S20644C17.s20644c17f5");
    check_field_offset(lv, s20644c17f6, ABISELECT(1664,1264), "S20644C17.s20644c17f6");
    check_field_offset(lv, s20644c17f7, ABISELECT(1680,1276), "S20644C17.s20644c17f7");
    check_field_offset(lv, s20644c17f8, ABISELECT(1696,1284), "S20644C17.s20644c17f8");
    test_class_info(&lv, &cd_S20644C17);
    dp->~S20644C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20644C17(Test_S20644C17, "S20644C17", ABISELECT(6080,4668));

#else // __cplusplus

extern void _ZN9S20644C17C1Ev();
extern void _ZN9S20644C17D2Ev();
Name_Map name_map_S20644C17[] = {
  NSPAIR(_ZN9S20644C17C1Ev),
  NSPAIR(_ZN9S20644C17D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
extern Class_Descriptor cd_S20644C11;
extern VTBL_ENTRY _ZTI9S20644C11[];
extern  VTBL_ENTRY _ZTV9S20644C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20644C11[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C9;
extern VTBL_ENTRY _ZTI8S20644C9[];
extern  VTBL_ENTRY _ZTV8S20644C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
extern Class_Descriptor cd_S20644C8;
extern VTBL_ENTRY _ZTI8S20644C8[];
extern  VTBL_ENTRY _ZTV8S20644C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C8[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C7;
extern VTBL_ENTRY _ZTI8S20644C7[];
extern  VTBL_ENTRY _ZTV8S20644C7[];
extern Class_Descriptor cd_S20644C10;
extern VTBL_ENTRY _ZTI9S20644C10[];
extern  VTBL_ENTRY _ZTV9S20644C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20644C10[];
extern Class_Descriptor cd_S20644C9;
extern VTBL_ENTRY _ZTI8S20644C9[];
extern  VTBL_ENTRY _ZTV8S20644C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
extern Class_Descriptor cd_S20644C8;
extern VTBL_ENTRY _ZTI8S20644C8[];
extern  VTBL_ENTRY _ZTV8S20644C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C8[];
extern Class_Descriptor cd_S20644C9;
extern VTBL_ENTRY _ZTI8S20644C9[];
extern  VTBL_ENTRY _ZTV8S20644C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
extern Class_Descriptor cd_S20644C8;
extern VTBL_ENTRY _ZTI8S20644C8[];
extern  VTBL_ENTRY _ZTV8S20644C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C8[];
extern Class_Descriptor cd_S20644C9;
extern VTBL_ENTRY _ZTI8S20644C9[];
extern  VTBL_ENTRY _ZTV8S20644C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
extern Class_Descriptor cd_S20644C14;
extern VTBL_ENTRY _ZTI9S20644C14[];
extern  VTBL_ENTRY _ZTV9S20644C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20644C14[];
static Base_Class bases_S20644C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C8_nt,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20644C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(3824,2924), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20644C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3216C8_nt,    ABISELECT(5328,4088), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(5320,4084), //bcp->offset
    71, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S3216C8_nt,    ABISELECT(5384,4128), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(5376,4124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S20644C5,    ABISELECT(5376,4124), //bcp->offset
    79, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    43, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S20644C11,    ABISELECT(3840,2928), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(5168,3980), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S20644C9,    ABISELECT(5520,4236), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    45, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(5672,4344), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(5664,4340), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20644C5,    ABISELECT(5664,4340), //bcp->offset
    99, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    47, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20644C8,    ABISELECT(5520,4236), //bcp->offset
    88, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    19, //immediately_derived
  0, 1},
  {&cd_S3216C8_nt,    ABISELECT(5184,3988), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(5176,3984), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20644C7,    ABISELECT(5176,3984), //bcp->offset
    63, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S20644C10,    ABISELECT(3840,2928), //bcp->offset
    48, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20644C9,    ABISELECT(144,112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(296,220), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(288,216), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S20644C5,    ABISELECT(288,216), //bcp->offset
    18, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S20644C8,    ABISELECT(144,112), //bcp->offset
    12, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20644C9,    ABISELECT(704,544), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(856,652), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(848,648), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S20644C5,    ABISELECT(848,648), //bcp->offset
    31, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    32, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S20644C8,    ABISELECT(704,544), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S20644C9,    ABISELECT(1264,976), //bcp->offset
    37, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    33, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(1416,1084), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(1408,1080), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S20644C5,    ABISELECT(1408,1080), //bcp->offset
    42, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    34, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S20644C14,    ABISELECT(704,544), //bcp->offset
    24, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20644C17[];
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN9S20644C17D1Ev();
extern void _ZN9S20644C17D0Ev();
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
extern void _ZN9S20644C143v13Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void ABISELECT(_ZTv0_n56_N9S20644C17D1Ev,_ZTv0_n28_N9S20644C17D1Ev)();
extern void ABISELECT(_ZThn3840_N9S20644C17D1Ev,_ZThn2928_N9S20644C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S20644C17D0Ev,_ZTv0_n28_N9S20644C17D0Ev)();
extern void ABISELECT(_ZThn3840_N9S20644C17D0Ev,_ZThn2928_N9S20644C17D0Ev)() __attribute__((weak));
extern void _ZN9S20644C102v9Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void ABISELECT(_ZTvn1336_n56_N9S20644C17D1Ev,_ZTvn1056_n28_N9S20644C17D1Ev)();
extern void ABISELECT(_ZTvn1336_n56_N9S20644C17D0Ev,_ZTvn1056_n28_N9S20644C17D0Ev)();
extern void _ZN8S20644C72v5Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY vtc_S20644C17[] = {
  ABISELECT(5520,4236),
  ABISELECT(5376,4124),
  ABISELECT(5320,4084),
  ABISELECT(3840,2928),
  ABISELECT(3824,2924),
  0,
  (VTBL_ENTRY)&(_ZTI9S20644C17[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  (VTBL_ENTRY)&_ZN9S20644C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20644C17D0Ev,
  ABISELECT(3680,2812),
  ABISELECT(5176,3972),
  ABISELECT(-144,-112),
  (VTBL_ENTRY)&(_ZTI9S20644C17[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
  ABISELECT(3536,2708),
  ABISELECT(-288,-216),
  (VTBL_ENTRY)&(_ZTI9S20644C17[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  ABISELECT(3120,2380),
  ABISELECT(4616,3540),
  ABISELECT(-704,-544),
  (VTBL_ENTRY)&(_ZTI9S20644C17[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20644C143v13Ev,
  ABISELECT(2976,2276),
  ABISELECT(-848,-648),
  (VTBL_ENTRY)&(_ZTI9S20644C17[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  ABISELECT(2560,1948),
  ABISELECT(4056,3108),
  ABISELECT(-1264,-976),
  (VTBL_ENTRY)&(_ZTI9S20644C17[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  ABISELECT(2416,1844),
  ABISELECT(-1408,-1080),
  (VTBL_ENTRY)&(_ZTI9S20644C17[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  0,
  ABISELECT(-3840,-2928),
  ABISELECT(1680,1308),
  ABISELECT(1536,1196),
  ABISELECT(1480,1156),
  ABISELECT(-16,-4),
  ABISELECT(-3840,-2928),
  (VTBL_ENTRY)&(_ZTI9S20644C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20644C17D1Ev,_ZTv0_n28_N9S20644C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20644C17D0Ev,_ZTv0_n28_N9S20644C17D0Ev),
  (VTBL_ENTRY)&_ZN9S20644C102v9Ev,
  ABISELECT(-5176,-3984),
  (VTBL_ENTRY)&(_ZTI9S20644C17[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn1336_n56_N9S20644C17D1Ev,_ZTvn1056_n28_N9S20644C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1336_n56_N9S20644C17D0Ev,_ZTvn1056_n28_N9S20644C17D0Ev),
  (VTBL_ENTRY)&_ZN8S20644C72v5Ev,
  0,
  0,
  0,
  ABISELECT(-5320,-4084),
  (VTBL_ENTRY)&(_ZTI9S20644C17[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  0,
  0,
  0,
  ABISELECT(-1552,-1200),
  ABISELECT(-5376,-4124),
  (VTBL_ENTRY)&(_ZTI9S20644C17[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  ABISELECT(144,104),
  ABISELECT(144,104),
  ABISELECT(144,104),
  0,
  0,
  ABISELECT(-1696,-1312),
  ABISELECT(-200,-152),
  ABISELECT(-5520,-4236),
  (VTBL_ENTRY)&(_ZTI9S20644C17[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
  ABISELECT(-1840,-1416),
  ABISELECT(-5664,-4340),
  (VTBL_ENTRY)&(_ZTI9S20644C17[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern VTBL_ENTRY _ZTV9S20644C17[];
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__A__9S20644C17[] = {
  ABISELECT(3824,2924),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C8__A__9S20644C17[] = {
  ABISELECT(3680,2812),
  ABISELECT(5176,3972),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
};
extern void _ZN8S20644C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C98S20644C8__A1__9S20644C17[] = {
  ABISELECT(3680,2812),
  ABISELECT(5176,3972),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C98S20644C8__A1__9S20644C17[] = {
  0,
  0,
  0,
  ABISELECT(-5176,-3972),
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C58S20644C8__A3__9S20644C17[] = {
  ABISELECT(3536,2708),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C8__A__9S20644C17[] = {
  0,
  0,
  0,
  ABISELECT(-5176,-3972),
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__8S20644C8__A__9S20644C17[] = {
  ABISELECT(3536,2708),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
extern void _ZN9S20644C143v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20644C14__9S20644C17[] = {
  ABISELECT(3120,2380),
  ABISELECT(4616,3540),
  0,
  (VTBL_ENTRY)&(_ZTI9S20644C14[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20644C143v13Ev,
};
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C89S20644C14__A2__9S20644C17[] = {
  ABISELECT(3120,2380),
  ABISELECT(4616,3540),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
};
extern void _ZN8S20644C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C98S20644C89S20644C14__A2__9S20644C17[] = {
  ABISELECT(3120,2380),
  ABISELECT(4616,3540),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C98S20644C89S20644C14__A2__9S20644C17[] = {
  0,
  0,
  0,
  ABISELECT(-4616,-3540),
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C58S20644C89S20644C14__A4__9S20644C17[] = {
  ABISELECT(2976,2276),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C89S20644C14__A2__9S20644C17[] = {
  0,
  0,
  0,
  ABISELECT(-4616,-3540),
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__8S20644C89S20644C14__A2__9S20644C17[] = {
  ABISELECT(2976,2276),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C99S20644C14__A3__9S20644C17[] = {
  ABISELECT(2560,1948),
  ABISELECT(4056,3108),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C99S20644C14__A3__9S20644C17[] = {
  0,
  0,
  0,
  ABISELECT(-4056,-3108),
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C59S20644C14__A5__9S20644C17[] = {
  ABISELECT(2416,1844),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__9S20644C14__9S20644C17[] = {
  0,
  0,
  0,
  ABISELECT(-4616,-3540),
  (VTBL_ENTRY)&(_ZTI9S20644C14[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C58S20644C8__9S20644C14__9S20644C17[] = {
  ABISELECT(2976,2276),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI9S20644C14[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C9__A1__9S20644C14__9S20644C17[] = {
  ABISELECT(2560,1948),
  ABISELECT(4056,3108),
  ABISELECT(-560,-432),
  (VTBL_ENTRY)&(_ZTI9S20644C14[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__A1__9S20644C14__9S20644C17[] = {
  ABISELECT(2416,1844),
  ABISELECT(-704,-536),
  (VTBL_ENTRY)&(_ZTI9S20644C14[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN9S20644C10D1Ev();
extern void _ZN9S20644C10D0Ev();
extern void _ZN9S20644C102v9Ev();
static  VTBL_ENTRY _tg__ZTV9S20644C10__9S20644C17[] = {
  ABISELECT(1680,1308),
  ABISELECT(1536,1196),
  ABISELECT(1480,1156),
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI9S20644C10[0]),
  (VTBL_ENTRY)&_ZN9S20644C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20644C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20644C102v9Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20644C119S20644C10__9S20644C17[] = {
  ABISELECT(1536,1196),
  ABISELECT(1480,1156),
  ABISELECT(-16,-4),
  0,
  (VTBL_ENTRY)&(_ZTI9S20644C11[0]),
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__9S20644C119S20644C10__9S20644C17[] = {
  0,
  0,
  0,
  ABISELECT(-1480,-1156),
  (VTBL_ENTRY)&(_ZTI9S20644C11[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__9S20644C119S20644C10__9S20644C17[] = {
  0,
  0,
  0,
  ABISELECT(-1552,-1200),
  ABISELECT(-1536,-1196),
  (VTBL_ENTRY)&(_ZTI9S20644C11[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__9S20644C10__9S20644C17[] = {
  0,
  0,
  0,
  ABISELECT(-1480,-1156),
  (VTBL_ENTRY)&(_ZTI9S20644C10[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__9S20644C10__9S20644C17[] = {
  0,
  0,
  0,
  ABISELECT(-1552,-1200),
  ABISELECT(-1536,-1196),
  (VTBL_ENTRY)&(_ZTI9S20644C10[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C8__9S20644C10__9S20644C17[] = {
  ABISELECT(144,104),
  ABISELECT(144,104),
  ABISELECT(144,104),
  0,
  0,
  ABISELECT(-1696,-1312),
  ABISELECT(-200,-152),
  ABISELECT(-1680,-1308),
  (VTBL_ENTRY)&(_ZTI9S20644C10[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C58S20644C8__A1__9S20644C10__9S20644C17[] = {
  ABISELECT(-1840,-1416),
  ABISELECT(-1824,-1412),
  (VTBL_ENTRY)&(_ZTI9S20644C10[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__A1__9S20644C17[] = {
  ABISELECT(-1552,-1200),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C8__9S20644C17[] = {
  ABISELECT(-1696,-1312),
  ABISELECT(-200,-152),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
};
extern void _ZN8S20644C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C98S20644C8__9S20644C17[] = {
  ABISELECT(-1696,-1312),
  ABISELECT(-200,-152),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C98S20644C8__9S20644C17[] = {
  0,
  0,
  0,
  ABISELECT(200,152),
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C58S20644C8__A2__9S20644C17[] = {
  ABISELECT(-1840,-1416),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C8__9S20644C17[] = {
  0,
  0,
  0,
  ABISELECT(200,152),
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__8S20644C8__9S20644C17[] = {
  ABISELECT(-1840,-1416),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
static  VTT_ENTRY vtt_S20644C17[] = {
  {&(_ZTV9S20644C17[7]),  7,105},
  {&(_tg__ZTV8S20644C5__A__9S20644C17[3]),  3,6},
  {&(_tg__ZTV8S20644C8__A__9S20644C17[4]),  4,6},
  {&(_tg__ZTV8S20644C98S20644C8__A1__9S20644C17[4]),  4,5},
  {&(_tg__ZTV8S20644C6__8S20644C98S20644C8__A1__9S20644C17[5]),  5,8},
  {&(_tg__ZTV8S20644C58S20644C8__A3__9S20644C17[3]),  3,6},
  {&(_tg__ZTV8S20644C6__8S20644C8__A__9S20644C17[5]),  5,8},
  {&(_tg__ZTV8S20644C5__8S20644C8__A__9S20644C17[3]),  3,6},
  {&(_tg__ZTV9S20644C14__9S20644C17[4]),  4,7},
  {&(_tg__ZTV8S20644C89S20644C14__A2__9S20644C17[4]),  4,6},
  {&(_tg__ZTV8S20644C98S20644C89S20644C14__A2__9S20644C17[4]),  4,5},
  {&(_tg__ZTV8S20644C6__8S20644C98S20644C89S20644C14__A2__9S20644C17[5]),  5,8},
  {&(_tg__ZTV8S20644C58S20644C89S20644C14__A4__9S20644C17[3]),  3,6},
  {&(_tg__ZTV8S20644C6__8S20644C89S20644C14__A2__9S20644C17[5]),  5,8},
  {&(_tg__ZTV8S20644C5__8S20644C89S20644C14__A2__9S20644C17[3]),  3,6},
  {&(_tg__ZTV8S20644C99S20644C14__A3__9S20644C17[4]),  4,5},
  {&(_tg__ZTV8S20644C6__8S20644C99S20644C14__A3__9S20644C17[5]),  5,8},
  {&(_tg__ZTV8S20644C59S20644C14__A5__9S20644C17[3]),  3,6},
  {&(_tg__ZTV8S20644C6__9S20644C14__9S20644C17[5]),  5,8},
  {&(_tg__ZTV8S20644C58S20644C8__9S20644C14__9S20644C17[3]),  3,6},
  {&(_tg__ZTV8S20644C9__A1__9S20644C14__9S20644C17[4]),  4,5},
  {&(_tg__ZTV8S20644C5__A1__9S20644C14__9S20644C17[3]),  3,6},
  {&(_ZTV9S20644C17[60]),  60,105},
  {&(_ZTV9S20644C17[76]),  76,105},
  {&(_ZTV9S20644C17[85]),  85,105},
  {&(_ZTV9S20644C17[97]),  97,105},
  {&(_ZTV9S20644C17[102]),  102,105},
  {&(_ZTV9S20644C17[65]),  65,105},
  {&(_ZTV9S20644C17[16]),  16,105},
  {&(_ZTV9S20644C17[21]),  21,105},
  {&(_ZTV9S20644C17[28]),  28,105},
  {&(_ZTV9S20644C17[34]),  34,105},
  {&(_ZTV9S20644C17[41]),  41,105},
  {&(_ZTV9S20644C17[45]),  45,105},
  {&(_tg__ZTV9S20644C10__9S20644C17[6]),  6,9},
  {&(_tg__ZTV9S20644C119S20644C10__9S20644C17[5]),  5,5},
  {&(_tg__ZTV8S20644C6__9S20644C119S20644C10__9S20644C17[5]),  5,8},
  {&(_tg__ZTV8S20644C5__9S20644C119S20644C10__9S20644C17[6]),  6,9},
  {&(_tg__ZTV8S20644C6__9S20644C10__9S20644C17[5]),  5,8},
  {&(_tg__ZTV8S20644C5__9S20644C10__9S20644C17[6]),  6,9},
  {&(_tg__ZTV8S20644C8__9S20644C10__9S20644C17[9]),  9,11},
  {&(_tg__ZTV8S20644C58S20644C8__A1__9S20644C10__9S20644C17[3]),  3,6},
  {&(_tg__ZTV8S20644C5__A1__9S20644C17[3]),  3,6},
  {&(_tg__ZTV8S20644C8__9S20644C17[4]),  4,6},
  {&(_tg__ZTV8S20644C98S20644C8__9S20644C17[4]),  4,5},
  {&(_tg__ZTV8S20644C6__8S20644C98S20644C8__9S20644C17[5]),  5,8},
  {&(_tg__ZTV8S20644C58S20644C8__A2__9S20644C17[3]),  3,6},
  {&(_tg__ZTV8S20644C6__8S20644C8__9S20644C17[5]),  5,8},
  {&(_tg__ZTV8S20644C5__8S20644C8__9S20644C17[3]),  3,6},
};
extern VTBL_ENTRY _ZTI9S20644C17[];
extern  VTBL_ENTRY _ZTV9S20644C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20644C17[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20644C17D0Ev,_ZTv0_n28_N9S20644C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3840_N9S20644C17D0Ev,_ZThn2928_N9S20644C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N9S20644C17D1Ev,_ZTv0_n28_N9S20644C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3840_N9S20644C17D1Ev,_ZThn2928_N9S20644C17D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S20644C17 = {  "S20644C17", // class name
  bases_S20644C17, 35,
  &(vtc_S20644C17[0]), // expected_vtbl_contents
  &(vtt_S20644C17[0]), // expected_vtt_contents
  ABISELECT(6080,4668), // object size
  NSPAIRA(_ZTI9S20644C17),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV9S20644C17),105, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20644C17),49, //virtual table table var
  25, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20644C16  : virtual S20644C5 , S20644C10 , S20644C17 , S20644C9 {
  char s20644c16f0;
  int s20644c16f1;
  int s20644c16f2;
  int s20644c16f3;
  int s20644c16f4;
  void *s20644c16f5;
  char s20644c16f6[4];
  int s20644c16f7;
  virtual  ~S20644C16(); // _ZN9S20644C16D2Ev
  S20644C16(); // tgen
};
//SIG(-1 S20644C16) C1{ VBC2{ BC3{ BC4{ m Fi} v1 v2 v3 FC4[3] FC4[2] Fp Fs FC4} VBC4 FD FL FC3 Fp Fs[3]} BC5{ BC6{ VBC4 VBC3 VBC2 Fp[2] Fi FC2[8] FD[9]} BC4 VBC7{ VBC3 VBC4 BC8{ VBC3 VBC4 v4 FC3 FD Fp[2] FC3} BC2 v5 Fp[2] Fl Fi FC3[5]} BC9{ BC3 vd v6 Fp[7] Fi[2] FL Fi} vd v7 Fi Fp Fi} BC10{ BC2 VBC5 BC7 BC11{ VBC4 BC7 BC8 BC2 v8 Fi FC12{} Fp[2]} vd Fi Fc[2] Fi FL FC12 Fp[8] Fs[5] FL FC13{ vd m Fc[2] Fi FL Fp[7] FU14{ m FL:3 Fi Fi Fi FD[8] Fp Fc[5] FD Fc[4] Fi Fp Fc[4] Fp}[4] FC6}} BC8 vd Fc Fi Fi Fi Fi Fp Fc[4] Fi}


 S20644C16 ::~S20644C16(){ note_dtor("S20644C16", this);}
S20644C16 ::S20644C16(){ note_ctor("S20644C16", this);} // tgen

static void Test_S20644C16()
{
  extern Class_Descriptor cd_S20644C16;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(485,1491)];
    init_test(&cd_S20644C16, buf);
    S20644C16 *dp, &lv = *(dp=new (buf) S20644C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(7744,5960), "sizeof(S20644C16)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S20644C16)");
    /*is_ambiguous_... S20644C16::S20644C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*), ABISELECT(5512,4220), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C5 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C5*), ABISELECT(5504,4216), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*), ABISELECT(5640,4328), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C10 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C11*)(S20644C10*), ABISELECT(5640,4328), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C8*), ABISELECT(5640,4328), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C9*)(S20644C8*), ABISELECT(5640,4328), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*)(S20644C8*), ABISELECT(5640,4328), "S20644C16");
    /*is_ambiguous_... S20644C17::S20644C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*)(S20644C17*), ABISELECT(5640,4328), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C10 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C11*)(S20644C10*), ABISELECT(5640,4328), "S20644C16");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C8*)(S20644C17*), ABISELECT(5640,4328), "S20644C16");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C9*)(S20644C8*)(S20644C17*), ABISELECT(5640,4328), "S20644C16");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*)(S20644C8*)(S20644C17*), ABISELECT(5640,4328), "S20644C16");
    /*is_ambiguous_... S20644C14::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C14*)(S20644C17*), ABISELECT(5640,4328), "S20644C16");
    /*is_ambiguous_... S20644C8::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C8*)(S20644C14*)(S20644C17*), ABISELECT(5640,4328), "S20644C16");
    /*is_ambiguous_... S20644C9::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C9*)(S20644C8*)(S20644C14*)(S20644C17*), ABISELECT(5640,4328), "S20644C16");
    /*is_ambiguous_... S20644C5::S3216C8_nt */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*)(S20644C8*)(S20644C14*)(S20644C17*), ABISELECT(5640,4328), "S20644C16");
    /*is_ambiguous_... S20644C14::S20644C9 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C9*)(S20644C14*)(S20644C17*), ABISELECT(5640,4328), "S20644C16");
    /*is_ambiguous_... S20644C14::S20644C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C5*)(S20644C14*)(S20644C17*), ABISELECT(5640,4328), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C9 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C9*), ABISELECT(5640,4328), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C5 */ AMB_check_base_class_offset(lv, (S20644C5*), ABISELECT(5504,4216), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C10 */ AMB_check_base_class_offset(lv, (S20644C5*)(S20644C11*)(S20644C10*), ABISELECT(5504,4216), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C10 */ AMB_check_base_class_offset(lv, (S20644C5*)(S20644C11*)(S20644C10*), ABISELECT(5504,4216), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C6 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*), ABISELECT(5656,4336), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C10 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C11*)(S20644C10*), ABISELECT(5648,4332), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C8*), ABISELECT(5648,4332), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C9*)(S20644C8*), ABISELECT(5648,4332), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C10 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C11*)(S20644C10*), ABISELECT(5648,4332), "S20644C16");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C8*)(S20644C17*), ABISELECT(5648,4332), "S20644C16");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C9*)(S20644C8*)(S20644C17*), ABISELECT(5648,4332), "S20644C16");
    /*is_ambiguous_... S20644C8::S20644C6 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C8*)(S20644C14*)(S20644C17*), ABISELECT(5648,4332), "S20644C16");
    check_base_class_offset(lv, (S20644C6*)(S20644C9*)(S20644C8*)(S20644C14*)(S20644C17*), ABISELECT(5648,4332), "S20644C16");
    /*is_ambiguous_... S20644C14::S20644C9 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C9*)(S20644C14*)(S20644C17*), ABISELECT(5648,4332), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C9 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C9*), ABISELECT(5648,4332), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C10 */ AMB_check_base_class_offset(lv, (S20644C11*)(S20644C10*), 0, "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C10 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C10*), ABISELECT(1328,1052), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C9*)(S20644C8*), ABISELECT(5696,4372), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*)(S20644C8*), ABISELECT(5848,4480), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C5*)(S20644C8*), ABISELECT(5840,4476), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C5*)(S20644C8*), ABISELECT(5840,4476), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C10 */ AMB_check_base_class_offset(lv, (S20644C8*)(S20644C10*), ABISELECT(5696,4372), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C10 */ AMB_check_base_class_offset(lv, (S20644C8*)(S20644C10*), ABISELECT(5696,4372), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C10 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C7*)(S20644C10*), ABISELECT(1344,1060), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C10 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C7*)(S20644C10*), ABISELECT(1336,1056), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C10 */ AMB_check_base_class_offset(lv, (S20644C7*)(S20644C10*), ABISELECT(1336,1056), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C10 */ AMB_check_base_class_offset(lv, (S20644C10*), 0, "S20644C16");
    /*is_ambiguous_... S20644C17::S20644C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*)(S20644C17*), ABISELECT(1496,1160), "S20644C16");
    /*is_ambiguous_... S20644C17::S20644C5 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C5*)(S20644C17*), ABISELECT(1488,1156), "S20644C16");
    /*is_ambiguous_... S20644C17::S20644C5 */ AMB_check_base_class_offset(lv, (S20644C5*)(S20644C17*), ABISELECT(1488,1156), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C10 */ AMB_check_base_class_offset(lv, (S20644C11*)(S20644C10*), ABISELECT(6256,4804), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C10 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C10*), ABISELECT(7584,5856), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C10 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C7*)(S20644C10*), ABISELECT(7600,5864), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C10 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C7*)(S20644C10*), ABISELECT(7592,5860), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C10 */ AMB_check_base_class_offset(lv, (S20644C7*)(S20644C10*), ABISELECT(7592,5860), "S20644C16");
    check_base_class_offset(lv, (S20644C10*)(S20644C17*), ABISELECT(6256,4804), "S20644C16");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C9*)(S20644C8*)(S20644C17*), ABISELECT(1632,1268), "S20644C16");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*)(S20644C8*)(S20644C17*), ABISELECT(1784,1376), "S20644C16");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C5*)(S20644C8*)(S20644C17*), ABISELECT(1776,1372), "S20644C16");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C5*)(S20644C8*)(S20644C17*), ABISELECT(1776,1372), "S20644C16");
    /*is_ambiguous_... S20644C17::S20644C8 */ AMB_check_base_class_offset(lv, (S20644C8*)(S20644C17*), ABISELECT(1632,1268), "S20644C16");
    check_base_class_offset(lv, (S20644C9*)(S20644C8*)(S20644C14*)(S20644C17*), ABISELECT(2192,1700), "S20644C16");
    check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*)(S20644C8*)(S20644C14*)(S20644C17*), ABISELECT(2344,1808), "S20644C16");
    check_base_class_offset(lv, (S20644C6*)(S20644C5*)(S20644C8*)(S20644C14*)(S20644C17*), ABISELECT(2336,1804), "S20644C16");
    check_base_class_offset(lv, (S20644C5*)(S20644C8*)(S20644C14*)(S20644C17*), ABISELECT(2336,1804), "S20644C16");
    check_base_class_offset(lv, (S20644C8*)(S20644C14*)(S20644C17*), ABISELECT(2192,1700), "S20644C16");
    /*is_ambiguous_... S20644C14::S20644C9 */ AMB_check_base_class_offset(lv, (S20644C9*)(S20644C14*)(S20644C17*), ABISELECT(2752,2132), "S20644C16");
    /*is_ambiguous_... S20644C14::S20644C5 */ AMB_check_base_class_offset(lv, (S3216C8_nt*)(S20644C6*)(S20644C5*)(S20644C14*)(S20644C17*), ABISELECT(2904,2240), "S20644C16");
    /*is_ambiguous_... S20644C14::S20644C5 */ AMB_check_base_class_offset(lv, (S20644C6*)(S20644C5*)(S20644C14*)(S20644C17*), ABISELECT(2896,2236), "S20644C16");
    /*is_ambiguous_... S20644C14::S20644C5 */ AMB_check_base_class_offset(lv, (S20644C5*)(S20644C14*)(S20644C17*), ABISELECT(2896,2236), "S20644C16");
    check_base_class_offset(lv, (S20644C14*)(S20644C17*), ABISELECT(2192,1700), "S20644C16");
    check_base_class_offset(lv, (S20644C17*), ABISELECT(1488,1156), "S20644C16");
    /*is_ambiguous_... S20644C16::S20644C9 */ AMB_check_base_class_offset(lv, (S20644C9*), ABISELECT(5312,4080), "S20644C16");
    check_field_offset(lv, s20644c16f0, ABISELECT(5456,4184), "S20644C16.s20644c16f0");
    check_field_offset(lv, s20644c16f1, ABISELECT(5460,4188), "S20644C16.s20644c16f1");
    check_field_offset(lv, s20644c16f2, ABISELECT(5464,4192), "S20644C16.s20644c16f2");
    check_field_offset(lv, s20644c16f3, ABISELECT(5468,4196), "S20644C16.s20644c16f3");
    check_field_offset(lv, s20644c16f4, ABISELECT(5472,4200), "S20644C16.s20644c16f4");
    check_field_offset(lv, s20644c16f5, ABISELECT(5480,4204), "S20644C16.s20644c16f5");
    check_field_offset(lv, s20644c16f6, ABISELECT(5488,4208), "S20644C16.s20644c16f6");
    check_field_offset(lv, s20644c16f7, ABISELECT(5492,4212), "S20644C16.s20644c16f7");
    test_class_info(&lv, &cd_S20644C16);
    dp->~S20644C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20644C16(Test_S20644C16, "S20644C16", ABISELECT(7744,5960));

#else // __cplusplus

extern void _ZN9S20644C16C1Ev();
extern void _ZN9S20644C16D2Ev();
Name_Map name_map_S20644C16[] = {
  NSPAIR(_ZN9S20644C16C1Ev),
  NSPAIR(_ZN9S20644C16D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C11;
extern VTBL_ENTRY _ZTI9S20644C11[];
extern  VTBL_ENTRY _ZTV9S20644C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20644C11[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C9;
extern VTBL_ENTRY _ZTI8S20644C9[];
extern  VTBL_ENTRY _ZTV8S20644C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
extern Class_Descriptor cd_S20644C8;
extern VTBL_ENTRY _ZTI8S20644C8[];
extern  VTBL_ENTRY _ZTV8S20644C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C8[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C7;
extern VTBL_ENTRY _ZTI8S20644C7[];
extern  VTBL_ENTRY _ZTV8S20644C7[];
extern Class_Descriptor cd_S20644C10;
extern VTBL_ENTRY _ZTI9S20644C10[];
extern  VTBL_ENTRY _ZTV9S20644C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20644C10[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
extern Class_Descriptor cd_S20644C11;
extern VTBL_ENTRY _ZTI9S20644C11[];
extern  VTBL_ENTRY _ZTV9S20644C11[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20644C11[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C7;
extern VTBL_ENTRY _ZTI8S20644C7[];
extern  VTBL_ENTRY _ZTV8S20644C7[];
extern Class_Descriptor cd_S20644C10;
extern VTBL_ENTRY _ZTI9S20644C10[];
extern  VTBL_ENTRY _ZTV9S20644C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20644C10[];
extern Class_Descriptor cd_S20644C9;
extern VTBL_ENTRY _ZTI8S20644C9[];
extern  VTBL_ENTRY _ZTV8S20644C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
extern Class_Descriptor cd_S20644C8;
extern VTBL_ENTRY _ZTI8S20644C8[];
extern  VTBL_ENTRY _ZTV8S20644C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C8[];
extern Class_Descriptor cd_S20644C9;
extern VTBL_ENTRY _ZTI8S20644C9[];
extern  VTBL_ENTRY _ZTV8S20644C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
extern Class_Descriptor cd_S20644C8;
extern VTBL_ENTRY _ZTI8S20644C8[];
extern  VTBL_ENTRY _ZTV8S20644C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C8[];
extern Class_Descriptor cd_S20644C9;
extern VTBL_ENTRY _ZTI8S20644C9[];
extern  VTBL_ENTRY _ZTV8S20644C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C9[];
extern Class_Descriptor cd_S3216C8_nt;
extern VTBL_ENTRY _ZTI10S3216C8_nt[];
extern Class_Descriptor cd_S20644C6;
extern VTBL_ENTRY _ZTI8S20644C6[];
extern  VTBL_ENTRY _ZTV8S20644C6[];
extern Class_Descriptor cd_S20644C5;
extern VTBL_ENTRY _ZTI8S20644C5[];
extern  VTBL_ENTRY _ZTV8S20644C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C5[];
extern Class_Descriptor cd_S20644C14;
extern VTBL_ENTRY _ZTI9S20644C14[];
extern  VTBL_ENTRY _ZTV9S20644C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20644C14[];
extern Class_Descriptor cd_S20644C17;
extern VTBL_ENTRY _ZTI9S20644C17[];
extern  VTBL_ENTRY _ZTV9S20644C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20644C17[];
extern Class_Descriptor cd_S20644C9;
extern VTBL_ENTRY _ZTI8S20644C9[];
extern  VTBL_ENTRY _ZTV8S20644C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20644C9[];
static Base_Class bases_S20644C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S3216C8_nt,    ABISELECT(5512,4220), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(5504,4216), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(5640,4328), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20644C5,    ABISELECT(5504,4216), //bcp->offset
    71, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    46, //bcp->index_in_construction_vtbl_array
    60, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S3216C8_nt,    ABISELECT(5656,4336), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(5648,4332), //bcp->offset
    80, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    47, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S20644C11,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(1328,1052), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20644C9,    ABISELECT(5696,4372), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    62, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(5848,4480), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(5840,4476), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20644C5,    ABISELECT(5840,4476), //bcp->offset
    99, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    49, //bcp->index_in_construction_vtbl_array
    64, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S20644C8,    ABISELECT(5696,4372), //bcp->offset
    88, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    48, //bcp->index_in_construction_vtbl_array
    61, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S3216C8_nt,    ABISELECT(1344,1060), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(1336,1056), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S20644C7,    ABISELECT(1336,1056), //bcp->offset
    10, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20644C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S3216C8_nt,    ABISELECT(1496,1160), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(1488,1156), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S20644C5,    ABISELECT(1488,1156), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S20644C11,    ABISELECT(6256,4804), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    68, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(7584,5856), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(7600,5864), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(7592,5860), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S20644C7,    ABISELECT(7592,5860), //bcp->offset
    120, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    52, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S20644C10,    ABISELECT(6256,4804), //bcp->offset
    105, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    51, //bcp->index_in_construction_vtbl_array
    67, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    41, //immediately_derived
  0, 1},
  {&cd_S20644C9,    ABISELECT(1632,1268), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(1784,1376), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(1776,1372), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S20644C5,    ABISELECT(1776,1372), //bcp->offset
    36, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    54, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S20644C8,    ABISELECT(1632,1268), //bcp->offset
    30, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    53, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S20644C9,    ABISELECT(2192,1700), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(2344,1808), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(2336,1804), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S20644C5,    ABISELECT(2336,1804), //bcp->offset
    49, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    56, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S20644C8,    ABISELECT(2192,1700), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    40, //immediately_derived
  0, 0},
  {&cd_S20644C9,    ABISELECT(2752,2132), //bcp->offset
    55, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    57, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    40, //immediately_derived
  0, 0},
  {&cd_S3216C8_nt,    ABISELECT(2904,2240), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S20644C6,    ABISELECT(2896,2236), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S20644C5,    ABISELECT(2896,2236), //bcp->offset
    60, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    58, //bcp->index_in_construction_vtbl_array
    27, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    40, //immediately_derived
  0, 0},
  {&cd_S20644C14,    ABISELECT(2192,1700), //bcp->offset
    42, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    55, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S20644C17,    ABISELECT(1488,1156), //bcp->offset
    18, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    50, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20644C9,    ABISELECT(5312,4080), //bcp->offset
    66, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    59, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI9S20644C16[];
extern void _ZN9S20644C16D1Ev();
extern void _ZN9S20644C16D0Ev();
extern void _ZN9S20644C102v9Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void ABISELECT(_ZThn1336_N9S20644C16D1Ev,_ZThn1056_N9S20644C16D1Ev)();
extern void ABISELECT(_ZThn1336_N9S20644C16D0Ev,_ZThn1056_N9S20644C16D0Ev)();
extern void _ZN8S20644C72v5Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void ABISELECT(_ZThn1488_N9S20644C16D1Ev,_ZThn1156_N9S20644C16D1Ev)();
extern void ABISELECT(_ZThn1488_N9S20644C16D0Ev,_ZThn1156_N9S20644C16D0Ev)();
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
extern void _ZN9S20644C143v13Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void ABISELECT(_ZTv0_n56_N9S20644C16D1Ev,_ZTv0_n28_N9S20644C16D1Ev)();
extern void ABISELECT(_ZThn6256_N9S20644C16D1Ev,_ZThn4804_N9S20644C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S20644C16D0Ev,_ZTv0_n28_N9S20644C16D0Ev)();
extern void ABISELECT(_ZThn6256_N9S20644C16D0Ev,_ZThn4804_N9S20644C16D0Ev)() __attribute__((weak));
extern void _ZN9S20644C102v9Ev();
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void ABISELECT(_ZTvn1336_n56_N9S20644C16D1Ev,_ZTvn1056_n28_N9S20644C16D1Ev)();
extern void ABISELECT(_ZTvn1336_n56_N9S20644C16D0Ev,_ZTvn1056_n28_N9S20644C16D0Ev)();
extern void _ZN8S20644C72v5Ev();
static  VTBL_ENTRY vtc_S20644C16[] = {
  ABISELECT(6256,4804),
  ABISELECT(5696,4372),
  ABISELECT(5504,4216),
  ABISELECT(5648,4332),
  ABISELECT(5640,4328),
  0,
  (VTBL_ENTRY)&(_ZTI9S20644C16[0]),
  (VTBL_ENTRY)&_ZN9S20644C16D1Ev,
  (VTBL_ENTRY)&_ZN9S20644C16D0Ev,
  (VTBL_ENTRY)&_ZN9S20644C102v9Ev,
  ABISELECT(-1336,-1056),
  (VTBL_ENTRY)&(_ZTI9S20644C16[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn1336_N9S20644C16D1Ev,_ZThn1056_N9S20644C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1336_N9S20644C16D0Ev,_ZThn1056_N9S20644C16D0Ev),
  (VTBL_ENTRY)&_ZN8S20644C72v5Ev,
  ABISELECT(4208,3216),
  ABISELECT(4016,3060),
  ABISELECT(4160,3176),
  ABISELECT(4768,3648),
  ABISELECT(4152,3172),
  ABISELECT(-1488,-1156),
  (VTBL_ENTRY)&(_ZTI9S20644C16[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn1488_N9S20644C16D1Ev,_ZThn1156_N9S20644C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn1488_N9S20644C16D0Ev,_ZThn1156_N9S20644C16D0Ev),
  ABISELECT(4008,3060),
  ABISELECT(4016,3064),
  ABISELECT(-1632,-1268),
  (VTBL_ENTRY)&(_ZTI9S20644C16[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
  ABISELECT(3864,2956),
  ABISELECT(-1776,-1372),
  (VTBL_ENTRY)&(_ZTI9S20644C16[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  ABISELECT(3448,2628),
  ABISELECT(3456,2632),
  ABISELECT(-2192,-1700),
  (VTBL_ENTRY)&(_ZTI9S20644C16[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20644C143v13Ev,
  ABISELECT(3304,2524),
  ABISELECT(-2336,-1804),
  (VTBL_ENTRY)&(_ZTI9S20644C16[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  ABISELECT(2888,2196),
  ABISELECT(2896,2200),
  ABISELECT(-2752,-2132),
  (VTBL_ENTRY)&(_ZTI9S20644C16[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  ABISELECT(2744,2092),
  ABISELECT(-2896,-2236),
  (VTBL_ENTRY)&(_ZTI9S20644C16[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  ABISELECT(328,248),
  ABISELECT(336,252),
  ABISELECT(-5312,-4080),
  (VTBL_ENTRY)&(_ZTI9S20644C16[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  0,
  0,
  0,
  ABISELECT(136,112),
  ABISELECT(-5504,-4216),
  (VTBL_ENTRY)&(_ZTI9S20644C16[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  0,
  0,
  0,
  ABISELECT(-5648,-4332),
  (VTBL_ENTRY)&(_ZTI9S20644C16[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  ABISELECT(144,104),
  ABISELECT(144,104),
  ABISELECT(144,104),
  0,
  0,
  ABISELECT(-56,-44),
  ABISELECT(-48,-40),
  ABISELECT(-5696,-4372),
  (VTBL_ENTRY)&(_ZTI9S20644C16[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
  ABISELECT(-200,-148),
  ABISELECT(-5840,-4476),
  (VTBL_ENTRY)&(_ZTI9S20644C16[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  0,
  ABISELECT(-6256,-4804),
  ABISELECT(-560,-432),
  ABISELECT(-752,-588),
  ABISELECT(-608,-472),
  ABISELECT(-616,-476),
  ABISELECT(-6256,-4804),
  (VTBL_ENTRY)&(_ZTI9S20644C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20644C16D1Ev,_ZTv0_n28_N9S20644C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20644C16D0Ev,_ZTv0_n28_N9S20644C16D0Ev),
  (VTBL_ENTRY)&_ZN9S20644C102v9Ev,
  ABISELECT(-7592,-5860),
  (VTBL_ENTRY)&(_ZTI9S20644C16[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn1336_n56_N9S20644C16D1Ev,_ZTvn1056_n28_N9S20644C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1336_n56_N9S20644C16D0Ev,_ZTvn1056_n28_N9S20644C16D0Ev),
  (VTBL_ENTRY)&_ZN8S20644C72v5Ev,
};
extern VTBL_ENTRY _ZTV9S20644C16[];
extern void _ZN9S20644C10D1Ev();
extern void _ZN9S20644C10D0Ev();
extern void _ZN9S20644C102v9Ev();
static  VTBL_ENTRY _tg__ZTV9S20644C10__A__9S20644C16[] = {
  ABISELECT(5696,4372),
  ABISELECT(5504,4216),
  ABISELECT(5648,4332),
  ABISELECT(5640,4328),
  0,
  (VTBL_ENTRY)&(_ZTI9S20644C10[0]),
  (VTBL_ENTRY)&_ZN9S20644C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20644C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20644C102v9Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20644C119S20644C10__9S20644C16[] = {
  ABISELECT(5504,4216),
  ABISELECT(5648,4332),
  ABISELECT(5640,4328),
  0,
  (VTBL_ENTRY)&(_ZTI9S20644C11[0]),
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__9S20644C119S20644C10__9S20644C16[] = {
  0,
  0,
  0,
  ABISELECT(-5648,-4332),
  (VTBL_ENTRY)&(_ZTI9S20644C11[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__9S20644C119S20644C10__9S20644C16[] = {
  0,
  0,
  0,
  ABISELECT(136,112),
  ABISELECT(-5504,-4216),
  (VTBL_ENTRY)&(_ZTI9S20644C11[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__9S20644C10__A__9S20644C16[] = {
  0,
  0,
  0,
  ABISELECT(-5648,-4332),
  (VTBL_ENTRY)&(_ZTI9S20644C10[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__9S20644C10__A__9S20644C16[] = {
  0,
  0,
  0,
  ABISELECT(136,112),
  ABISELECT(-5504,-4216),
  (VTBL_ENTRY)&(_ZTI9S20644C10[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C8__9S20644C10__A__9S20644C16[] = {
  ABISELECT(144,104),
  ABISELECT(144,104),
  ABISELECT(144,104),
  0,
  0,
  ABISELECT(-56,-44),
  ABISELECT(-48,-40),
  ABISELECT(-5696,-4372),
  (VTBL_ENTRY)&(_ZTI9S20644C10[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C58S20644C8__A1__9S20644C10__A__9S20644C16[] = {
  ABISELECT(-200,-148),
  ABISELECT(-5840,-4476),
  (VTBL_ENTRY)&(_ZTI9S20644C10[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void _ZN9S20644C17D1Ev();
extern void _ZN9S20644C17D0Ev();
static  VTBL_ENTRY _tg__ZTV9S20644C17__9S20644C16[] = {
  ABISELECT(4208,3216),
  ABISELECT(4016,3060),
  ABISELECT(4160,3176),
  ABISELECT(4768,3648),
  ABISELECT(4152,3172),
  0,
  (VTBL_ENTRY)&(_ZTI9S20644C17[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  (VTBL_ENTRY)&_ZN9S20644C17D1Ev,
  (VTBL_ENTRY)&_ZN9S20644C17D0Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C59S20644C17__A2__9S20644C16[] = {
  ABISELECT(4152,3172),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C89S20644C17__A1__9S20644C16[] = {
  ABISELECT(4008,3060),
  ABISELECT(4016,3064),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
};
extern void _ZN8S20644C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C98S20644C89S20644C17__A1__9S20644C16[] = {
  ABISELECT(4008,3060),
  ABISELECT(4016,3064),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C98S20644C89S20644C17__A1__9S20644C16[] = {
  0,
  0,
  0,
  ABISELECT(-4016,-3064),
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C58S20644C89S20644C17__A3__9S20644C16[] = {
  ABISELECT(3864,2956),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C89S20644C17__A1__9S20644C16[] = {
  0,
  0,
  0,
  ABISELECT(-4016,-3064),
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__8S20644C89S20644C17__A1__9S20644C16[] = {
  ABISELECT(3864,2956),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
extern void _ZN9S20644C143v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20644C149S20644C17__9S20644C16[] = {
  ABISELECT(3448,2628),
  ABISELECT(3456,2632),
  0,
  (VTBL_ENTRY)&(_ZTI9S20644C14[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20644C143v13Ev,
};
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C89S20644C149S20644C17__A2__9S20644C16[] = {
  ABISELECT(3448,2628),
  ABISELECT(3456,2632),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
};
extern void _ZN8S20644C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C98S20644C89S20644C149S20644C17__A2__9S20644C16[] = {
  ABISELECT(3448,2628),
  ABISELECT(3456,2632),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C98S20644C89S20644C149S20644C17__A2__9S20644C16[] = {
  0,
  0,
  0,
  ABISELECT(-3456,-2632),
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C58S20644C89S20644C149S20644C17__A4__9S20644C16[] = {
  ABISELECT(3304,2524),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C89S20644C149S20644C17__A2__9S20644C16[] = {
  0,
  0,
  0,
  ABISELECT(-3456,-2632),
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__8S20644C89S20644C149S20644C17__A2__9S20644C16[] = {
  ABISELECT(3304,2524),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C99S20644C149S20644C17__A3__9S20644C16[] = {
  ABISELECT(2888,2196),
  ABISELECT(2896,2200),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C99S20644C149S20644C17__A3__9S20644C16[] = {
  0,
  0,
  0,
  ABISELECT(-2896,-2200),
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C59S20644C149S20644C17__A5__9S20644C16[] = {
  ABISELECT(2744,2092),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__9S20644C149S20644C17__9S20644C16[] = {
  0,
  0,
  0,
  ABISELECT(-3456,-2632),
  (VTBL_ENTRY)&(_ZTI9S20644C14[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C58S20644C8__9S20644C149S20644C17__9S20644C16[] = {
  ABISELECT(3304,2524),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI9S20644C14[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C9__A1__9S20644C149S20644C17__9S20644C16[] = {
  ABISELECT(2888,2196),
  ABISELECT(2896,2200),
  ABISELECT(-560,-432),
  (VTBL_ENTRY)&(_ZTI9S20644C14[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__A1__9S20644C149S20644C17__9S20644C16[] = {
  ABISELECT(2744,2092),
  ABISELECT(-704,-536),
  (VTBL_ENTRY)&(_ZTI9S20644C14[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void ABISELECT(_ZTv0_n56_N9S20644C17D1Ev,_ZTv0_n28_N9S20644C17D1Ev)();
extern void ABISELECT(_ZThn4768_N9S20644C17D1Ev,_ZThn3648_N9S20644C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N9S20644C17D0Ev,_ZTv0_n28_N9S20644C17D0Ev)();
extern void ABISELECT(_ZThn4768_N9S20644C17D0Ev,_ZThn3648_N9S20644C17D0Ev)() __attribute__((weak));
extern void _ZN9S20644C102v9Ev();
static  VTBL_ENTRY _tg__ZTV9S20644C10__9S20644C17__9S20644C16[] = {
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  ABISELECT(1336,1056),
  0,
  ABISELECT(-4768,-3648),
  ABISELECT(-560,-432),
  ABISELECT(-752,-588),
  ABISELECT(-608,-472),
  ABISELECT(-616,-476),
  ABISELECT(-4768,-3648),
  (VTBL_ENTRY)&(_ZTI9S20644C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20644C17D1Ev,_ZTv0_n28_N9S20644C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N9S20644C17D0Ev,_ZTv0_n28_N9S20644C17D0Ev),
  (VTBL_ENTRY)&_ZN9S20644C102v9Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__A1__9S20644C17__9S20644C16[] = {
  0,
  0,
  0,
  ABISELECT(-4160,-3176),
  (VTBL_ENTRY)&(_ZTI9S20644C17[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__A1__9S20644C17__9S20644C16[] = {
  0,
  0,
  0,
  ABISELECT(136,112),
  ABISELECT(-4016,-3060),
  (VTBL_ENTRY)&(_ZTI9S20644C17[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C8__9S20644C17__9S20644C16[] = {
  ABISELECT(144,104),
  ABISELECT(144,104),
  ABISELECT(144,104),
  0,
  0,
  ABISELECT(-56,-44),
  ABISELECT(-48,-40),
  ABISELECT(-4208,-3216),
  (VTBL_ENTRY)&(_ZTI9S20644C17[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C58S20644C8__A2__9S20644C17__9S20644C16[] = {
  ABISELECT(-200,-148),
  ABISELECT(-4352,-3320),
  (VTBL_ENTRY)&(_ZTI9S20644C17[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
extern void ABISELECT(_ZTvn1336_n56_N9S20644C17D1Ev,_ZTvn1056_n28_N9S20644C17D1Ev)();
extern void ABISELECT(_ZTvn1336_n56_N9S20644C17D0Ev,_ZTvn1056_n28_N9S20644C17D0Ev)();
extern void _ZN8S20644C72v5Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C79S20644C10__9S20644C17__9S20644C16[] = {
  ABISELECT(-6104,-4704),
  (VTBL_ENTRY)&(_ZTI9S20644C17[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn1336_n56_N9S20644C17D1Ev,_ZTvn1056_n28_N9S20644C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn1336_n56_N9S20644C17D0Ev,_ZTvn1056_n28_N9S20644C17D0Ev),
  (VTBL_ENTRY)&_ZN8S20644C72v5Ev,
};
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C8__A__9S20644C17__9S20644C16[] = {
  ABISELECT(4008,3060),
  ABISELECT(4016,3064),
  ABISELECT(-144,-112),
  (VTBL_ENTRY)&(_ZTI9S20644C17[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C58S20644C8__A3__9S20644C17__9S20644C16[] = {
  ABISELECT(3864,2956),
  ABISELECT(-288,-216),
  (VTBL_ENTRY)&(_ZTI9S20644C17[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
extern void _ZN9S20644C143v13Ev();
static  VTBL_ENTRY _tg__ZTV9S20644C14__9S20644C17__9S20644C16[] = {
  ABISELECT(3448,2628),
  ABISELECT(3456,2632),
  ABISELECT(-704,-544),
  (VTBL_ENTRY)&(_ZTI9S20644C17[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
  (VTBL_ENTRY)&_ZN9S20644C143v13Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C58S20644C89S20644C14__A4__9S20644C17__9S20644C16[] = {
  ABISELECT(3304,2524),
  ABISELECT(-848,-648),
  (VTBL_ENTRY)&(_ZTI9S20644C17[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C99S20644C14__A3__9S20644C17__9S20644C16[] = {
  ABISELECT(2888,2196),
  ABISELECT(2896,2200),
  ABISELECT(-1264,-976),
  (VTBL_ENTRY)&(_ZTI9S20644C17[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C59S20644C14__A5__9S20644C17__9S20644C16[] = {
  ABISELECT(2744,2092),
  ABISELECT(-1408,-1080),
  (VTBL_ENTRY)&(_ZTI9S20644C17[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C9__A4__9S20644C16[] = {
  ABISELECT(328,248),
  ABISELECT(336,252),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C9__A4__9S20644C16[] = {
  0,
  0,
  0,
  ABISELECT(-336,-252),
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__9S20644C16[] = {
  ABISELECT(136,112),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C8__9S20644C16[] = {
  ABISELECT(-56,-44),
  ABISELECT(-48,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
};
extern void _ZN8S20644C92v6Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C98S20644C8__9S20644C16[] = {
  ABISELECT(-56,-44),
  ABISELECT(-48,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C98S20644C8__9S20644C16[] = {
  0,
  0,
  0,
  ABISELECT(48,40),
  (VTBL_ENTRY)&(_ZTI8S20644C9[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C58S20644C8__A1__9S20644C16[] = {
  ABISELECT(-200,-148),
  0,
  (VTBL_ENTRY)&(_ZTI8S20644C5[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__8S20644C8__9S20644C16[] = {
  0,
  0,
  0,
  ABISELECT(48,40),
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__8S20644C8__9S20644C16[] = {
  ABISELECT(-200,-148),
  ABISELECT(-144,-104),
  (VTBL_ENTRY)&(_ZTI8S20644C8[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN9S20644C10D1Ev();
extern void _ZN9S20644C10D0Ev();
extern void _ZN9S20644C102v9Ev();
static  VTBL_ENTRY _tg__ZTV9S20644C10__A1__9S20644C16[] = {
  ABISELECT(-560,-432),
  ABISELECT(-752,-588),
  ABISELECT(-608,-472),
  ABISELECT(-616,-476),
  0,
  (VTBL_ENTRY)&(_ZTI9S20644C10[0]),
  (VTBL_ENTRY)&_ZN9S20644C10D1Ev,
  (VTBL_ENTRY)&_ZN9S20644C10D0Ev,
  (VTBL_ENTRY)&_ZN9S20644C102v9Ev,
};
static  VTBL_ENTRY _tg__ZTV9S20644C119S20644C10__A1__9S20644C16[] = {
  ABISELECT(-752,-588),
  ABISELECT(-608,-472),
  ABISELECT(-616,-476),
  0,
  (VTBL_ENTRY)&(_ZTI9S20644C11[0]),
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__9S20644C119S20644C10__A1__9S20644C16[] = {
  0,
  0,
  0,
  ABISELECT(608,472),
  (VTBL_ENTRY)&(_ZTI9S20644C11[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__9S20644C119S20644C10__A1__9S20644C16[] = {
  0,
  0,
  0,
  ABISELECT(136,112),
  ABISELECT(752,588),
  (VTBL_ENTRY)&(_ZTI9S20644C11[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C6__9S20644C10__A1__9S20644C16[] = {
  0,
  0,
  0,
  ABISELECT(608,472),
  (VTBL_ENTRY)&(_ZTI9S20644C10[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C5__9S20644C10__A1__9S20644C16[] = {
  0,
  0,
  0,
  ABISELECT(136,112),
  ABISELECT(752,588),
  (VTBL_ENTRY)&(_ZTI9S20644C10[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
extern void _ZN8S20644C92v6Ev();
extern void _ZN8S20644C82v7Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C8__9S20644C10__A1__9S20644C16[] = {
  ABISELECT(144,104),
  ABISELECT(144,104),
  ABISELECT(144,104),
  0,
  0,
  ABISELECT(-56,-44),
  ABISELECT(-48,-40),
  ABISELECT(560,432),
  (VTBL_ENTRY)&(_ZTI9S20644C10[0]),
  (VTBL_ENTRY)&_ZN8S20644C92v6Ev,
  (VTBL_ENTRY)&_ZN8S20644C82v7Ev,
};
extern void _ZN8S20644C62v2Ev();
extern void _ZN8S20644C62v3Ev();
extern void _ZN8S20644C62v4Ev();
static  VTBL_ENTRY _tg__ZTV8S20644C58S20644C8__A1__9S20644C10__A1__9S20644C16[] = {
  ABISELECT(-200,-148),
  ABISELECT(416,328),
  (VTBL_ENTRY)&(_ZTI9S20644C10[0]),
  (VTBL_ENTRY)&_ZN8S20644C62v2Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v3Ev,
  (VTBL_ENTRY)&_ZN8S20644C62v4Ev,
};
static  VTT_ENTRY vtt_S20644C16[] = {
  {&(_ZTV9S20644C16[7]),  7,128},
  {&(_tg__ZTV9S20644C10__A__9S20644C16[6]),  6,9},
  {&(_tg__ZTV9S20644C119S20644C10__9S20644C16[5]),  5,5},
  {&(_tg__ZTV8S20644C6__9S20644C119S20644C10__9S20644C16[5]),  5,8},
  {&(_tg__ZTV8S20644C5__9S20644C119S20644C10__9S20644C16[6]),  6,9},
  {&(_tg__ZTV8S20644C6__9S20644C10__A__9S20644C16[5]),  5,8},
  {&(_tg__ZTV8S20644C5__9S20644C10__A__9S20644C16[6]),  6,9},
  {&(_tg__ZTV8S20644C8__9S20644C10__A__9S20644C16[9]),  9,11},
  {&(_tg__ZTV8S20644C58S20644C8__A1__9S20644C10__A__9S20644C16[3]),  3,6},
  {&(_tg__ZTV9S20644C17__9S20644C16[7]),  7,12},
  {&(_tg__ZTV8S20644C59S20644C17__A2__9S20644C16[3]),  3,6},
  {&(_tg__ZTV8S20644C89S20644C17__A1__9S20644C16[4]),  4,6},
  {&(_tg__ZTV8S20644C98S20644C89S20644C17__A1__9S20644C16[4]),  4,5},
  {&(_tg__ZTV8S20644C6__8S20644C98S20644C89S20644C17__A1__9S20644C16[5]),  5,8},
  {&(_tg__ZTV8S20644C58S20644C89S20644C17__A3__9S20644C16[3]),  3,6},
  {&(_tg__ZTV8S20644C6__8S20644C89S20644C17__A1__9S20644C16[5]),  5,8},
  {&(_tg__ZTV8S20644C5__8S20644C89S20644C17__A1__9S20644C16[3]),  3,6},
  {&(_tg__ZTV9S20644C149S20644C17__9S20644C16[4]),  4,7},
  {&(_tg__ZTV8S20644C89S20644C149S20644C17__A2__9S20644C16[4]),  4,6},
  {&(_tg__ZTV8S20644C98S20644C89S20644C149S20644C17__A2__9S20644C16[4]),  4,5},
  {&(_tg__ZTV8S20644C6__8S20644C98S20644C89S20644C149S20644C17__A2__9S20644C16[5]),  5,8},
  {&(_tg__ZTV8S20644C58S20644C89S20644C149S20644C17__A4__9S20644C16[3]),  3,6},
  {&(_tg__ZTV8S20644C6__8S20644C89S20644C149S20644C17__A2__9S20644C16[5]),  5,8},
  {&(_tg__ZTV8S20644C5__8S20644C89S20644C149S20644C17__A2__9S20644C16[3]),  3,6},
  {&(_tg__ZTV8S20644C99S20644C149S20644C17__A3__9S20644C16[4]),  4,5},
  {&(_tg__ZTV8S20644C6__8S20644C99S20644C149S20644C17__A3__9S20644C16[5]),  5,8},
  {&(_tg__ZTV8S20644C59S20644C149S20644C17__A5__9S20644C16[3]),  3,6},
  {&(_tg__ZTV8S20644C6__9S20644C149S20644C17__9S20644C16[5]),  5,8},
  {&(_tg__ZTV8S20644C58S20644C8__9S20644C149S20644C17__9S20644C16[3]),  3,6},
  {&(_tg__ZTV8S20644C9__A1__9S20644C149S20644C17__9S20644C16[4]),  4,5},
  {&(_tg__ZTV8S20644C5__A1__9S20644C149S20644C17__9S20644C16[3]),  3,6},
  {&(_tg__ZTV9S20644C10__9S20644C17__9S20644C16[12]),  12,15},
  {&(_tg__ZTV8S20644C6__A1__9S20644C17__9S20644C16[5]),  5,8},
  {&(_tg__ZTV8S20644C5__A1__9S20644C17__9S20644C16[6]),  6,9},
  {&(_tg__ZTV8S20644C8__9S20644C17__9S20644C16[9]),  9,11},
  {&(_tg__ZTV8S20644C58S20644C8__A2__9S20644C17__9S20644C16[3]),  3,6},
  {&(_tg__ZTV8S20644C79S20644C10__9S20644C17__9S20644C16[2]),  2,8},
  {&(_tg__ZTV8S20644C8__A__9S2064