// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S1379C5_nt  {
  int s1379c5f0[2];
  void  mf1379c5(); // _ZN10S1379C5_nt8mf1379c5Ev
};
//SIG(-1 S1379C5_nt) C1{ m Fi[2]}


void  S1379C5_nt ::mf1379c5(){}

//skip512 S1379C5_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1379C4_nt  {
  int s1379c4f0;
  __tsi64 s1379c4f1;
  void *s1379c4f2[4];
  int s1379c4f3[2];
  void *s1379c4f4;
  ::S1379C5_nt s1379c4f5;
  void *s1379c4f6[2];
  virtual  ~S1379C4_nt(); // _ZN10S1379C4_ntD1Ev
  virtual void  v3(); // _ZN10S1379C4_nt2v3Ev
  virtual void  v4(); // _ZN10S1379C4_nt2v4Ev
  virtual void  v5(); // _ZN10S1379C4_nt2v5Ev
  virtual void  v6(); // _ZN10S1379C4_nt2v6Ev
  virtual void  v7(); // _ZN10S1379C4_nt2v7Ev
  virtual void  v8(); // _ZN10S1379C4_nt2v8Ev
  virtual void  v9(); // _ZN10S1379C4_nt2v9Ev
  virtual void  v10(); // _ZN10S1379C4_nt3v10Ev
  virtual void  v11(); // _ZN10S1379C4_nt3v11Ev
  virtual void  v12(); // _ZN10S1379C4_nt3v12Ev
  virtual void  v13(); // _ZN10S1379C4_nt3v13Ev
  virtual void  v14(); // _ZN10S1379C4_nt3v14Ev
  virtual void  v15(); // _ZN10S1379C4_nt3v15Ev
  virtual void  v16(); // _ZN10S1379C4_nt3v16Ev
  virtual void  v17(); // _ZN10S1379C4_nt3v17Ev
  virtual void  v18(); // _ZN10S1379C4_nt3v18Ev
  virtual void  v19(); // _ZN10S1379C4_nt3v19Ev
  virtual void  v20(); // _ZN10S1379C4_nt3v20Ev
  virtual void  v21(); // _ZN10S1379C4_nt3v21Ev
  virtual void  v22(); // _ZN10S1379C4_nt3v22Ev
  virtual void  v23(); // _ZN10S1379C4_nt3v23Ev
  virtual void  v24(); // _ZN10S1379C4_nt3v24Ev
  virtual void  v25(); // _ZN10S1379C4_nt3v25Ev
  virtual void  v26(); // _ZN10S1379C4_nt3v26Ev
  virtual void  v27(); // _ZN10S1379C4_nt3v27Ev
  virtual void  v28(); // _ZN10S1379C4_nt3v28Ev
  virtual void  v29(); // _ZN10S1379C4_nt3v29Ev
  virtual void  v30(); // _ZN10S1379C4_nt3v30Ev
  virtual void  v31(); // _ZN10S1379C4_nt3v31Ev
  virtual void  v32(); // _ZN10S1379C4_nt3v32Ev
  virtual void  v33(); // _ZN10S1379C4_nt3v33Ev
  virtual void  v34(); // _ZN10S1379C4_nt3v34Ev
  virtual void  v35(); // _ZN10S1379C4_nt3v35Ev
  virtual void  v36(); // _ZN10S1379C4_nt3v36Ev
  virtual void  v37(); // _ZN10S1379C4_nt3v37Ev
  virtual void  v38(); // _ZN10S1379C4_nt3v38Ev
  virtual void  v39(); // _ZN10S1379C4_nt3v39Ev
  virtual void  v40(); // _ZN10S1379C4_nt3v40Ev
  virtual void  v41(); // _ZN10S1379C4_nt3v41Ev
  virtual void  v42(); // _ZN10S1379C4_nt3v42Ev
  virtual void  v43(); // _ZN10S1379C4_nt3v43Ev
  virtual void  v44(); // _ZN10S1379C4_nt3v44Ev
  virtual void  v45(); // _ZN10S1379C4_nt3v45Ev
  virtual void  v46(); // _ZN10S1379C4_nt3v46Ev
  virtual void  v47(); // _ZN10S1379C4_nt3v47Ev
  virtual void  v48(); // _ZN10S1379C4_nt3v48Ev
  virtual void  v49(); // _ZN10S1379C4_nt3v49Ev
  virtual void  v50(); // _ZN10S1379C4_nt3v50Ev
  virtual void  v51(); // _ZN10S1379C4_nt3v51Ev
  virtual void  v52(); // _ZN10S1379C4_nt3v52Ev
  virtual void  v53(); // _ZN10S1379C4_nt3v53Ev
  virtual void  v54(); // _ZN10S1379C4_nt3v54Ev
  virtual void  v55(); // _ZN10S1379C4_nt3v55Ev
  virtual void  v56(); // _ZN10S1379C4_nt3v56Ev
  virtual void  v57(); // _ZN10S1379C4_nt3v57Ev
  virtual void  v58(); // _ZN10S1379C4_nt3v58Ev
  virtual void  v59(); // _ZN10S1379C4_nt3v59Ev
  virtual void  v60(); // _ZN10S1379C4_nt3v60Ev
  virtual void  v61(); // _ZN10S1379C4_nt3v61Ev
  virtual void  v62(); // _ZN10S1379C4_nt3v62Ev
  virtual void  v63(); // _ZN10S1379C4_nt3v63Ev
  virtual void  v64(); // _ZN10S1379C4_nt3v64Ev
  virtual void  v65(); // _ZN10S1379C4_nt3v65Ev
  virtual void  v66(); // _ZN10S1379C4_nt3v66Ev
  S1379C4_nt(); // tgen
};
//SIG(-1 S1379C4_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 Fi FL Fp[4] Fi[2] Fp FC2{ m Fi[2]} Fp[2]}


 S1379C4_nt ::~S1379C4_nt(){ note_dtor("S1379C4_nt", this);}
void  S1379C4_nt ::v3(){vfunc_called(this, "_ZN10S1379C4_nt2v3Ev");}
void  S1379C4_nt ::v4(){vfunc_called(this, "_ZN10S1379C4_nt2v4Ev");}
void  S1379C4_nt ::v5(){vfunc_called(this, "_ZN10S1379C4_nt2v5Ev");}
void  S1379C4_nt ::v6(){vfunc_called(this, "_ZN10S1379C4_nt2v6Ev");}
void  S1379C4_nt ::v7(){vfunc_called(this, "_ZN10S1379C4_nt2v7Ev");}
void  S1379C4_nt ::v8(){vfunc_called(this, "_ZN10S1379C4_nt2v8Ev");}
void  S1379C4_nt ::v9(){vfunc_called(this, "_ZN10S1379C4_nt2v9Ev");}
void  S1379C4_nt ::v10(){vfunc_called(this, "_ZN10S1379C4_nt3v10Ev");}
void  S1379C4_nt ::v11(){vfunc_called(this, "_ZN10S1379C4_nt3v11Ev");}
void  S1379C4_nt ::v12(){vfunc_called(this, "_ZN10S1379C4_nt3v12Ev");}
void  S1379C4_nt ::v13(){vfunc_called(this, "_ZN10S1379C4_nt3v13Ev");}
void  S1379C4_nt ::v14(){vfunc_called(this, "_ZN10S1379C4_nt3v14Ev");}
void  S1379C4_nt ::v15(){vfunc_called(this, "_ZN10S1379C4_nt3v15Ev");}
void  S1379C4_nt ::v16(){vfunc_called(this, "_ZN10S1379C4_nt3v16Ev");}
void  S1379C4_nt ::v17(){vfunc_called(this, "_ZN10S1379C4_nt3v17Ev");}
void  S1379C4_nt ::v18(){vfunc_called(this, "_ZN10S1379C4_nt3v18Ev");}
void  S1379C4_nt ::v19(){vfunc_called(this, "_ZN10S1379C4_nt3v19Ev");}
void  S1379C4_nt ::v20(){vfunc_called(this, "_ZN10S1379C4_nt3v20Ev");}
void  S1379C4_nt ::v21(){vfunc_called(this, "_ZN10S1379C4_nt3v21Ev");}
void  S1379C4_nt ::v22(){vfunc_called(this, "_ZN10S1379C4_nt3v22Ev");}
void  S1379C4_nt ::v23(){vfunc_called(this, "_ZN10S1379C4_nt3v23Ev");}
void  S1379C4_nt ::v24(){vfunc_called(this, "_ZN10S1379C4_nt3v24Ev");}
void  S1379C4_nt ::v25(){vfunc_called(this, "_ZN10S1379C4_nt3v25Ev");}
void  S1379C4_nt ::v26(){vfunc_called(this, "_ZN10S1379C4_nt3v26Ev");}
void  S1379C4_nt ::v27(){vfunc_called(this, "_ZN10S1379C4_nt3v27Ev");}
void  S1379C4_nt ::v28(){vfunc_called(this, "_ZN10S1379C4_nt3v28Ev");}
void  S1379C4_nt ::v29(){vfunc_called(this, "_ZN10S1379C4_nt3v29Ev");}
void  S1379C4_nt ::v30(){vfunc_called(this, "_ZN10S1379C4_nt3v30Ev");}
void  S1379C4_nt ::v31(){vfunc_called(this, "_ZN10S1379C4_nt3v31Ev");}
void  S1379C4_nt ::v32(){vfunc_called(this, "_ZN10S1379C4_nt3v32Ev");}
void  S1379C4_nt ::v33(){vfunc_called(this, "_ZN10S1379C4_nt3v33Ev");}
void  S1379C4_nt ::v34(){vfunc_called(this, "_ZN10S1379C4_nt3v34Ev");}
void  S1379C4_nt ::v35(){vfunc_called(this, "_ZN10S1379C4_nt3v35Ev");}
void  S1379C4_nt ::v36(){vfunc_called(this, "_ZN10S1379C4_nt3v36Ev");}
void  S1379C4_nt ::v37(){vfunc_called(this, "_ZN10S1379C4_nt3v37Ev");}
void  S1379C4_nt ::v38(){vfunc_called(this, "_ZN10S1379C4_nt3v38Ev");}
void  S1379C4_nt ::v39(){vfunc_called(this, "_ZN10S1379C4_nt3v39Ev");}
void  S1379C4_nt ::v40(){vfunc_called(this, "_ZN10S1379C4_nt3v40Ev");}
void  S1379C4_nt ::v41(){vfunc_called(this, "_ZN10S1379C4_nt3v41Ev");}
void  S1379C4_nt ::v42(){vfunc_called(this, "_ZN10S1379C4_nt3v42Ev");}
void  S1379C4_nt ::v43(){vfunc_called(this, "_ZN10S1379C4_nt3v43Ev");}
void  S1379C4_nt ::v44(){vfunc_called(this, "_ZN10S1379C4_nt3v44Ev");}
void  S1379C4_nt ::v45(){vfunc_called(this, "_ZN10S1379C4_nt3v45Ev");}
void  S1379C4_nt ::v46(){vfunc_called(this, "_ZN10S1379C4_nt3v46Ev");}
void  S1379C4_nt ::v47(){vfunc_called(this, "_ZN10S1379C4_nt3v47Ev");}
void  S1379C4_nt ::v48(){vfunc_called(this, "_ZN10S1379C4_nt3v48Ev");}
void  S1379C4_nt ::v49(){vfunc_called(this, "_ZN10S1379C4_nt3v49Ev");}
void  S1379C4_nt ::v50(){vfunc_called(this, "_ZN10S1379C4_nt3v50Ev");}
void  S1379C4_nt ::v51(){vfunc_called(this, "_ZN10S1379C4_nt3v51Ev");}
void  S1379C4_nt ::v52(){vfunc_called(this, "_ZN10S1379C4_nt3v52Ev");}
void  S1379C4_nt ::v53(){vfunc_called(this, "_ZN10S1379C4_nt3v53Ev");}
void  S1379C4_nt ::v54(){vfunc_called(this, "_ZN10S1379C4_nt3v54Ev");}
void  S1379C4_nt ::v55(){vfunc_called(this, "_ZN10S1379C4_nt3v55Ev");}
void  S1379C4_nt ::v56(){vfunc_called(this, "_ZN10S1379C4_nt3v56Ev");}
void  S1379C4_nt ::v57(){vfunc_called(this, "_ZN10S1379C4_nt3v57Ev");}
void  S1379C4_nt ::v58(){vfunc_called(this, "_ZN10S1379C4_nt3v58Ev");}
void  S1379C4_nt ::v59(){vfunc_called(this, "_ZN10S1379C4_nt3v59Ev");}
void  S1379C4_nt ::v60(){vfunc_called(this, "_ZN10S1379C4_nt3v60Ev");}
void  S1379C4_nt ::v61(){vfunc_called(this, "_ZN10S1379C4_nt3v61Ev");}
void  S1379C4_nt ::v62(){vfunc_called(this, "_ZN10S1379C4_nt3v62Ev");}
void  S1379C4_nt ::v63(){vfunc_called(this, "_ZN10S1379C4_nt3v63Ev");}
void  S1379C4_nt ::v64(){vfunc_called(this, "_ZN10S1379C4_nt3v64Ev");}
void  S1379C4_nt ::v65(){vfunc_called(this, "_ZN10S1379C4_nt3v65Ev");}
void  S1379C4_nt ::v66(){vfunc_called(this, "_ZN10S1379C4_nt3v66Ev");}
S1379C4_nt ::S1379C4_nt(){ note_ctor("S1379C4_nt", this);} // tgen

//skip512 S1379C4_nt

#else // __cplusplus

extern void _ZN10S1379C4_ntC1Ev();
extern void _ZN10S1379C4_ntD1Ev();
Name_Map name_map_S1379C4_nt[] = {
  NSPAIR(_ZN10S1379C4_ntC1Ev),
  NSPAIR(_ZN10S1379C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S1379C4_nt[];
extern void _ZN10S1379C4_ntD1Ev();
extern void _ZN10S1379C4_ntD0Ev();
extern void _ZN10S1379C4_nt2v3Ev();
extern void _ZN10S1379C4_nt2v4Ev();
extern void _ZN10S1379C4_nt2v5Ev();
extern void _ZN10S1379C4_nt2v6Ev();
extern void _ZN10S1379C4_nt2v7Ev();
extern void _ZN10S1379C4_nt2v8Ev();
extern void _ZN10S1379C4_nt2v9Ev();
extern void _ZN10S1379C4_nt3v10Ev();
extern void _ZN10S1379C4_nt3v11Ev();
extern void _ZN10S1379C4_nt3v12Ev();
extern void _ZN10S1379C4_nt3v13Ev();
extern void _ZN10S1379C4_nt3v14Ev();
extern void _ZN10S1379C4_nt3v15Ev();
extern void _ZN10S1379C4_nt3v16Ev();
extern void _ZN10S1379C4_nt3v17Ev();
extern void _ZN10S1379C4_nt3v18Ev();
extern void _ZN10S1379C4_nt3v19Ev();
extern void _ZN10S1379C4_nt3v20Ev();
extern void _ZN10S1379C4_nt3v21Ev();
extern void _ZN10S1379C4_nt3v22Ev();
extern void _ZN10S1379C4_nt3v23Ev();
extern void _ZN10S1379C4_nt3v24Ev();
extern void _ZN10S1379C4_nt3v25Ev();
extern void _ZN10S1379C4_nt3v26Ev();
extern void _ZN10S1379C4_nt3v27Ev();
extern void _ZN10S1379C4_nt3v28Ev();
extern void _ZN10S1379C4_nt3v29Ev();
extern void _ZN10S1379C4_nt3v30Ev();
extern void _ZN10S1379C4_nt3v31Ev();
extern void _ZN10S1379C4_nt3v32Ev();
extern void _ZN10S1379C4_nt3v33Ev();
extern void _ZN10S1379C4_nt3v34Ev();
extern void _ZN10S1379C4_nt3v35Ev();
extern void _ZN10S1379C4_nt3v36Ev();
extern void _ZN10S1379C4_nt3v37Ev();
extern void _ZN10S1379C4_nt3v38Ev();
extern void _ZN10S1379C4_nt3v39Ev();
extern void _ZN10S1379C4_nt3v40Ev();
extern void _ZN10S1379C4_nt3v41Ev();
extern void _ZN10S1379C4_nt3v42Ev();
extern void _ZN10S1379C4_nt3v43Ev();
extern void _ZN10S1379C4_nt3v44Ev();
extern void _ZN10S1379C4_nt3v45Ev();
extern void _ZN10S1379C4_nt3v46Ev();
extern void _ZN10S1379C4_nt3v47Ev();
extern void _ZN10S1379C4_nt3v48Ev();
extern void _ZN10S1379C4_nt3v49Ev();
extern void _ZN10S1379C4_nt3v50Ev();
extern void _ZN10S1379C4_nt3v51Ev();
extern void _ZN10S1379C4_nt3v52Ev();
extern void _ZN10S1379C4_nt3v53Ev();
extern void _ZN10S1379C4_nt3v54Ev();
extern void _ZN10S1379C4_nt3v55Ev();
extern void _ZN10S1379C4_nt3v56Ev();
extern void _ZN10S1379C4_nt3v57Ev();
extern void _ZN10S1379C4_nt3v58Ev();
extern void _ZN10S1379C4_nt3v59Ev();
extern void _ZN10S1379C4_nt3v60Ev();
extern void _ZN10S1379C4_nt3v61Ev();
extern void _ZN10S1379C4_nt3v62Ev();
extern void _ZN10S1379C4_nt3v63Ev();
extern void _ZN10S1379C4_nt3v64Ev();
extern void _ZN10S1379C4_nt3v65Ev();
extern void _ZN10S1379C4_nt3v66Ev();
static  VTBL_ENTRY vtc_S1379C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1379C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S1379C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v66Ev,
};
extern VTBL_ENTRY _ZTI10S1379C4_nt[];
VTBL_ENTRY *P__ZTI10S1379C4_nt = _ZTI10S1379C4_nt; 
extern  VTBL_ENTRY _ZTV10S1379C4_nt[];
Class_Descriptor cd_S1379C4_nt = {  "S1379C4_nt", // class name
  0,0,//no base classes
  &(vtc_S1379C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,60), // object size
  NSPAIRA(_ZTI10S1379C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S1379C4_nt),68, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1379C8_nt  {
  void *s1379c8f0;
  int s1379c8f1[2];
  void  mf1379c8(); // _ZN10S1379C8_nt8mf1379c8Ev
};
//SIG(-1 S1379C8_nt) C1{ m Fp Fi[2]}


void  S1379C8_nt ::mf1379c8(){}

//skip512 S1379C8_nt

#else // __cplusplus

Class_Descriptor cd_S1379C8_nt = {  "S1379C8_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1379C7_nt  : S1379C8_nt {
};
//SIG(-1 S1379C7_nt) C1{ BC2{ m Fp Fi[2]}}



//skip512 S1379C7_nt

#else // __cplusplus

extern Class_Descriptor cd_S1379C8_nt;
static Base_Class bases_S1379C7_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1379C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1379C7_nt = {  "S1379C7_nt", // class name
  bases_S1379C7_nt, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1379C6_nt  : S1379C7_nt {
};
//SIG(-1 S1379C6_nt) C1{ BC2{ BC3{ m Fp Fi[2]}}}



//skip512 S1379C6_nt

#else // __cplusplus

extern Class_Descriptor cd_S1379C8_nt;
extern Class_Descriptor cd_S1379C7_nt;
static Base_Class bases_S1379C6_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1379C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1379C7_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1379C9_nt  {
  int s1379c9f0;
  void  mf1379c9(); // _ZN10S1379C9_nt8mf1379c9Ev
};
//SIG(-1 S1379C9_nt) C1{ m Fi}


void  S1379C9_nt ::mf1379c9(){}

//skip512 S1379C9_nt

#else // __cplusplus

Class_Descriptor cd_S1379C9_nt = {  "S1379C9_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  4, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1379C13  : S1379C8_nt {
};
//SIG(-1 S1379C13) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1379C13()
{
  extern Class_Descriptor cd_S1379C13;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1379C13, buf);
    S1379C13 &lv = *(new (buf) S1379C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1379C13)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1379C13)");
    check_base_class_offset(lv, (S1379C8_nt*), 0, "S1379C13");
    test_class_info(&lv, &cd_S1379C13);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1379C13(Test_S1379C13, "S1379C13", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1379C8_nt;
static Base_Class bases_S1379C13[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1379C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1379C13 = {  "S1379C13", // class name
  bases_S1379C13, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1379C12  : S1379C13 {
};
//SIG(-1 S1379C12) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1379C12()
{
  extern Class_Descriptor cd_S1379C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1379C12, buf);
    S1379C12 &lv = *(new (buf) S1379C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1379C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1379C12)");
    check_base_class_offset(lv, (S1379C8_nt*)(S1379C13*), 0, "S1379C12");
    check_base_class_offset(lv, (S1379C13*), 0, "S1379C12");
    test_class_info(&lv, &cd_S1379C12);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1379C12(Test_S1379C12, "S1379C12", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1379C8_nt;
extern Class_Descriptor cd_S1379C13;
static Base_Class bases_S1379C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1379C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1379C13,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1379C12 = {  "S1379C12", // class name
  bases_S1379C12, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1379C14_nt  {
  int s1379c14f0[3];
  void  mf1379c14(); // _ZN11S1379C14_nt9mf1379c14Ev
};
//SIG(-1 S1379C14_nt) C1{ m Fi[3]}


void  S1379C14_nt ::mf1379c14(){}

//skip512 S1379C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1379C19  : S1379C8_nt {
};
//SIG(-1 S1379C19) C1{ BC2{ m Fp Fi[2]}}



static void Test_S1379C19()
{
  extern Class_Descriptor cd_S1379C19;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1379C19, buf);
    S1379C19 &lv = *(new (buf) S1379C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1379C19)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1379C19)");
    check_base_class_offset(lv, (S1379C8_nt*), 0, "S1379C19");
    test_class_info(&lv, &cd_S1379C19);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1379C19(Test_S1379C19, "S1379C19", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1379C8_nt;
static Base_Class bases_S1379C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1379C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1379C19 = {  "S1379C19", // class name
  bases_S1379C19, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1379C18  : S1379C19 {
};
//SIG(-1 S1379C18) C1{ BC2{ BC3{ m Fp Fi[2]}}}



static void Test_S1379C18()
{
  extern Class_Descriptor cd_S1379C18;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1379C18, buf);
    S1379C18 &lv = *(new (buf) S1379C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1379C18)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1379C18)");
    check_base_class_offset(lv, (S1379C8_nt*)(S1379C19*), 0, "S1379C18");
    check_base_class_offset(lv, (S1379C19*), 0, "S1379C18");
    test_class_info(&lv, &cd_S1379C18);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1379C18(Test_S1379C18, "S1379C18", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1379C8_nt;
extern Class_Descriptor cd_S1379C19;
static Base_Class bases_S1379C18[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1379C8_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1379C19,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1379C18 = {  "S1379C18", // class name
  bases_S1379C18, 2,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1379C3_nt  : S1379C4_nt {
  ::S1379C6_nt s1379c3f0;
  ::S1379C6_nt s1379c3f1;
  ::S1379C9_nt s1379c3f2;
  int s1379c3f3;
  char s1379c3f4[4];
  void *s1379c3f5[2];
  ::S1379C6_nt s1379c3f6;
  unsigned int s1379c3f7:1;
  unsigned int s1379c3f8:1;
  unsigned int s1379c3f9:1;
  unsigned int s1379c3f10:1;
  unsigned int s1379c3f11:1;
  unsigned int s1379c3f12:1;
  unsigned int s1379c3f13:1;
  unsigned int s1379c3f14:1;
  unsigned int s1379c3f15:1;
  unsigned int s1379c3f16:1;
  unsigned int s1379c3f17:1;
  unsigned int s1379c3f18:1;
  unsigned int s1379c3f19:1;
  unsigned int s1379c3f20:1;
  unsigned int s1379c3f21:1;
  unsigned int s1379c3f22:1;
  unsigned int s1379c3f23:1;
  unsigned int s1379c3f24:1;
  unsigned int s1379c3f25:1;
  unsigned int s1379c3f26:1;
  unsigned int s1379c3f27:1;
  unsigned int s1379c3f28:1;
  unsigned int s1379c3f29:1;
  unsigned int s1379c3f30:1;
  unsigned int s1379c3f31:1;
  unsigned int s1379c3f32:1;
  unsigned int s1379c3f33:1;
  unsigned int s1379c3f34:1;
  unsigned int s1379c3f35:1;
  unsigned int s1379c3f36:1;
  unsigned int s1379c3f37:1;
  unsigned int s1379c3f38:1;
  unsigned int s1379c3f39:1;
  unsigned int s1379c3f40:1;
  unsigned int s1379c3f41:1;
  unsigned int s1379c3f42:1;
  unsigned int s1379c3f43:1;
  unsigned int s1379c3f44:1;
  unsigned int s1379c3f45:1;
  unsigned int s1379c3f46:1;
  unsigned int s1379c3f47:1;
  unsigned int s1379c3f48:1;
  unsigned int s1379c3f49:1;
  unsigned int s1379c3f50:1;
  unsigned int s1379c3f51:1;
  unsigned int s1379c3f52:1;
  unsigned int s1379c3f53:1;
  unsigned int s1379c3f54:1;
  unsigned int s1379c3f55:1;
  unsigned int s1379c3f56:1;
  unsigned int s1379c3f57:1;
  unsigned int s1379c3f58:1;
  unsigned int s1379c3f59:1;
  unsigned int s1379c3f60:1;
  unsigned int s1379c3f61:1;
  unsigned int s1379c3f62:1;
  unsigned int s1379c3f63:1;
  unsigned int s1379c3f64:1;
  unsigned int s1379c3f65:1;
  unsigned int s1379c3f66:1;
  unsigned int s1379c3f67:1;
  unsigned int s1379c3f68:1;
  unsigned int s1379c3f69:1;
  unsigned int s1379c3f70:1;
  unsigned int s1379c3f71:1;
  unsigned int s1379c3f72:1;
  unsigned int s1379c3f73:1;
  unsigned int s1379c3f74:1;
  unsigned int s1379c3f75:1;
  unsigned int s1379c3f76:1;
  unsigned int s1379c3f77:1;
  unsigned int s1379c3f78:1;
  unsigned int s1379c3f79:1;
  unsigned int s1379c3f80:1;
  unsigned int s1379c3f81:1;
  unsigned int s1379c3f82:1;
  unsigned int s1379c3f83:1;
  int s1379c3f84[5];
  void *s1379c3f85[2];
  int s1379c3f86[3];
  ::S1379C5_nt s1379c3f87;
  ::S1379C5_nt s1379c3f88;
  ::S1379C5_nt s1379c3f89;
  ::S1379C12 s1379c3f90;
  ::S1379C12 s1379c3f91;
  int s1379c3f92;
  void *s1379c3f93[2];
  ::S1379C14_nt s1379c3f94;
  ::S1379C14_nt s1379c3f95;
  ::S1379C14_nt s1379c3f96;
  ::S1379C14_nt s1379c3f97;
  void *s1379c3f98;
  ::S1379C5_nt s1379c3f99;
  ::S1379C12 s1379c3f100;
  ::S1379C14_nt s1379c3f101;
  ::S1379C14_nt s1379c3f102;
  int s1379c3f103;
  ::S1379C14_nt s1379c3f104;
  ::S1379C14_nt s1379c3f105;
  void *s1379c3f106;
  int s1379c3f107;
  char s1379c3f108;
  ::S1379C14_nt s1379c3f109;
  ::S1379C14_nt s1379c3f110;
  void *s1379c3f111;
  int s1379c3f112;
  void *s1379c3f113;
  ::S1379C12 s1379c3f114;
  ::S1379C18 s1379c3f115;
  ::S1379C18 s1379c3f116;
  virtual  ~S1379C3_nt(); // _ZN10S1379C3_ntD1Ev
  virtual void  v67(); // _ZN10S1379C3_nt3v67Ev
  virtual void  v68(); // _ZN10S1379C3_nt3v68Ev
  virtual void  v69(); // _ZN10S1379C3_nt3v69Ev
  virtual void  v70(); // _ZN10S1379C3_nt3v70Ev
  virtual void  v71(); // _ZN10S1379C3_nt3v71Ev
  virtual void  v72(); // _ZN10S1379C3_nt3v72Ev
  virtual void  v73(); // _ZN10S1379C3_nt3v73Ev
  virtual void  v74(); // _ZN10S1379C3_nt3v74Ev
  virtual void  v75(); // _ZN10S1379C3_nt3v75Ev
  virtual void  v76(); // _ZN10S1379C3_nt3v76Ev
  virtual void  v77(); // _ZN10S1379C3_nt3v77Ev
  virtual void  v78(); // _ZN10S1379C3_nt3v78Ev
  virtual void  v79(); // _ZN10S1379C3_nt3v79Ev
  virtual void  v80(); // _ZN10S1379C3_nt3v80Ev
  virtual void  v81(); // _ZN10S1379C3_nt3v81Ev
  virtual void  v82(); // _ZN10S1379C3_nt3v82Ev
  virtual void  v83(); // _ZN10S1379C3_nt3v83Ev
  virtual void  v84(); // _ZN10S1379C3_nt3v84Ev
  virtual void  v85(); // _ZN10S1379C3_nt3v85Ev
  virtual void  v86(); // _ZN10S1379C3_nt3v86Ev
  virtual void  v87(); // _ZN10S1379C3_nt3v87Ev
  virtual void  v88(); // _ZN10S1379C3_nt3v88Ev
  virtual void  v89(); // _ZN10S1379C3_nt3v89Ev
  virtual void  v90(); // _ZN10S1379C3_nt3v90Ev
  virtual void  v91(); // _ZN10S1379C3_nt3v91Ev
  virtual void  v92(); // _ZN10S1379C3_nt3v92Ev
  virtual void  v93(); // _ZN10S1379C3_nt3v93Ev
  virtual void  v94(); // _ZN10S1379C3_nt3v94Ev
  virtual void  v95(); // _ZN10S1379C3_nt3v95Ev
  virtual void  v96(); // _ZN10S1379C3_nt3v96Ev
  virtual void  v97(); // _ZN10S1379C3_nt3v97Ev
  virtual void  v98(); // _ZN10S1379C3_nt3v98Ev
  virtual void  v99(); // _ZN10S1379C3_nt3v99Ev
  virtual void  v100(); // _ZN10S1379C3_nt4v100Ev
  virtual void  v101(); // _ZN10S1379C3_nt4v101Ev
  virtual void  v102(); // _ZN10S1379C3_nt4v102Ev
  virtual void  v103(); // _ZN10S1379C3_nt4v103Ev
  virtual void  v104(); // _ZN10S1379C3_nt4v104Ev
  virtual void  v105(); // _ZN10S1379C3_nt4v105Ev
  virtual void  v106(); // _ZN10S1379C3_nt4v106Ev
  virtual void  v107(); // _ZN10S1379C3_nt4v107Ev
  virtual void  v108(); // _ZN10S1379C3_nt4v108Ev
  virtual void  v109(); // _ZN10S1379C3_nt4v109Ev
  virtual void  v110(); // _ZN10S1379C3_nt4v110Ev
  virtual void  v111(); // _ZN10S1379C3_nt4v111Ev
  virtual void  v112(); // _ZN10S1379C3_nt4v112Ev
  virtual void  v113(); // _ZN10S1379C3_nt4v113Ev
  virtual void  v114(); // _ZN10S1379C3_nt4v114Ev
  virtual void  v115(); // _ZN10S1379C3_nt4v115Ev
  virtual void  v116(); // _ZN10S1379C3_nt4v116Ev
  virtual void  v117(); // _ZN10S1379C3_nt4v117Ev
  virtual void  v118(); // _ZN10S1379C3_nt4v118Ev
  virtual void  v119(); // _ZN10S1379C3_nt4v119Ev
  virtual void  v120(); // _ZN10S1379C3_nt4v120Ev
  virtual void  v121(); // _ZN10S1379C3_nt4v121Ev
  virtual void  v122(); // _ZN10S1379C3_nt4v122Ev
  virtual void  v123(); // _ZN10S1379C3_nt4v123Ev
  virtual void  v124(); // _ZN10S1379C3_nt4v124Ev
  virtual void  v125(); // _ZN10S1379C3_nt4v125Ev
  virtual void  v126(); // _ZN10S1379C3_nt4v126Ev
  virtual void  v127(); // _ZN10S1379C3_nt4v127Ev
  virtual void  v128(); // _ZN10S1379C3_nt4v128Ev
  virtual void  v129(); // _ZN10S1379C3_nt4v129Ev
  virtual void  v130(); // _ZN10S1379C3_nt4v130Ev
  virtual void  v131(); // _ZN10S1379C3_nt4v131Ev
  virtual void  v132(); // _ZN10S1379C3_nt4v132Ev
  virtual void  v133(); // _ZN10S1379C3_nt4v133Ev
  virtual void  v134(); // _ZN10S1379C3_nt4v134Ev
  virtual void  v135(); // _ZN10S1379C3_nt4v135Ev
  virtual void  v136(); // _ZN10S1379C3_nt4v136Ev
  virtual void  v137(); // _ZN10S1379C3_nt4v137Ev
  virtual void  v138(); // _ZN10S1379C3_nt4v138Ev
  virtual void  v139(); // _ZN10S1379C3_nt4v139Ev
  virtual void  v140(); // _ZN10S1379C3_nt4v140Ev
  virtual void  v141(); // _ZN10S1379C3_nt4v141Ev
  virtual void  v142(); // _ZN10S1379C3_nt4v142Ev
  virtual void  v143(); // _ZN10S1379C3_nt4v143Ev
  virtual void  v144(); // _ZN10S1379C3_nt4v144Ev
  virtual void  v145(); // _ZN10S1379C3_nt4v145Ev
  virtual void  v146(); // _ZN10S1379C3_nt4v146Ev
  virtual void  v147(); // _ZN10S1379C3_nt4v147Ev
  virtual void  v148(); // _ZN10S1379C3_nt4v148Ev
  virtual void  v149(); // _ZN10S1379C3_nt4v149Ev
  virtual void  v150(); // _ZN10S1379C3_nt4v150Ev
  virtual void  v151(); // _ZN10S1379C3_nt4v151Ev
  virtual void  v152(); // _ZN10S1379C3_nt4v152Ev
  virtual void  v153(); // _ZN10S1379C3_nt4v153Ev
  virtual void  v154(); // _ZN10S1379C3_nt4v154Ev
  virtual void  v155(); // _ZN10S1379C3_nt4v155Ev
  virtual void  v156(); // _ZN10S1379C3_nt4v156Ev
  virtual void  v157(); // _ZN10S1379C3_nt4v157Ev
  virtual void  v158(); // _ZN10S1379C3_nt4v158Ev
  virtual void  v159(); // _ZN10S1379C3_nt4v159Ev
  virtual void  v160(); // _ZN10S1379C3_nt4v160Ev
  virtual void  v161(); // _ZN10S1379C3_nt4v161Ev
  virtual void  v162(); // _ZN10S1379C3_nt4v162Ev
  virtual void  v163(); // _ZN10S1379C3_nt4v163Ev
  virtual void  v164(); // _ZN10S1379C3_nt4v164Ev
  virtual void  v165(); // _ZN10S1379C3_nt4v165Ev
  virtual void  v166(); // _ZN10S1379C3_nt4v166Ev
  virtual void  v167(); // _ZN10S1379C3_nt4v167Ev
  virtual void  v168(); // _ZN10S1379C3_nt4v168Ev
  virtual void  v169(); // _ZN10S1379C3_nt4v169Ev
  virtual void  v170(); // _ZN10S1379C3_nt4v170Ev
  virtual void  v171(); // _ZN10S1379C3_nt4v171Ev
  virtual void  v172(); // _ZN10S1379C3_nt4v172Ev
  virtual void  v173(); // _ZN10S1379C3_nt4v173Ev
  virtual void  v174(); // _ZN10S1379C3_nt4v174Ev
  virtual void  v175(); // _ZN10S1379C3_nt4v175Ev
  virtual void  v176(); // _ZN10S1379C3_nt4v176Ev
  virtual void  v177(); // _ZN10S1379C3_nt4v177Ev
  virtual void  v178(); // _ZN10S1379C3_nt4v178Ev
  virtual void  v179(); // _ZN10S1379C3_nt4v179Ev
  virtual void  v180(); // _ZN10S1379C3_nt4v180Ev
  virtual void  v181(); // _ZN10S1379C3_nt4v181Ev
  virtual void  v182(); // _ZN10S1379C3_nt4v182Ev
  virtual void  v183(); // _ZN10S1379C3_nt4v183Ev
  virtual void  v184(); // _ZN10S1379C3_nt4v184Ev
  virtual void  v185(); // _ZN10S1379C3_nt4v185Ev
  virtual void  v186(); // _ZN10S1379C3_nt4v186Ev
  virtual void  v187(); // _ZN10S1379C3_nt4v187Ev
  virtual void  v188(); // _ZN10S1379C3_nt4v188Ev
  virtual void  v189(); // _ZN10S1379C3_nt4v189Ev
  virtual void  v190(); // _ZN10S1379C3_nt4v190Ev
  virtual void  v191(); // _ZN10S1379C3_nt4v191Ev
  virtual void  v192(); // _ZN10S1379C3_nt4v192Ev
  virtual void  v193(); // _ZN10S1379C3_nt4v193Ev
  virtual void  v194(); // _ZN10S1379C3_nt4v194Ev
  virtual void  v195(); // _ZN10S1379C3_nt4v195Ev
  virtual void  v196(); // _ZN10S1379C3_nt4v196Ev
  virtual void  v197(); // _ZN10S1379C3_nt4v197Ev
  virtual void  v198(); // _ZN10S1379C3_nt4v198Ev
  virtual void  v199(); // _ZN10S1379C3_nt4v199Ev
  virtual void  v200(); // _ZN10S1379C3_nt4v200Ev
  virtual void  v201(); // _ZN10S1379C3_nt4v201Ev
  virtual void  v202(); // _ZN10S1379C3_nt4v202Ev
  virtual void  v203(); // _ZN10S1379C3_nt4v203Ev
  virtual void  v204(); // _ZN10S1379C3_nt4v204Ev
  virtual void  v205(); // _ZN10S1379C3_nt4v205Ev
  virtual void  v206(); // _ZN10S1379C3_nt4v206Ev
  virtual void  v207(); // _ZN10S1379C3_nt4v207Ev
  virtual void  v208(); // _ZN10S1379C3_nt4v208Ev
  virtual void  v209(); // _ZN10S1379C3_nt4v209Ev
  S1379C3_nt(); // tgen
};
//SIG(-1 S1379C3_nt) C1{ BC2{ vd v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 Fi FL Fp[4] Fi[2] Fp FC3{ m Fi[2]} Fp[2]} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 FC4{ BC5{ BC6{ m Fp Fi[2]}}} FC4 FC7{ m Fi} Fi Fc[4] Fp[2] FC4 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC3 FC3 FC3 FC8{ BC9{ BC6}} FC8 Fi Fp[2] FC10{ m Fi[3]} FC10 FC10 FC10 Fp FC3 FC8 FC10 FC10 Fi FC10 FC10 Fp Fi Fc FC10 FC10 Fp Fi Fp FC8 FC11{ BC12{ BC6}} FC11}


 S1379C3_nt ::~S1379C3_nt(){ note_dtor("S1379C3_nt", this);}
void  S1379C3_nt ::v67(){vfunc_called(this, "_ZN10S1379C3_nt3v67Ev");}
void  S1379C3_nt ::v68(){vfunc_called(this, "_ZN10S1379C3_nt3v68Ev");}
void  S1379C3_nt ::v69(){vfunc_called(this, "_ZN10S1379C3_nt3v69Ev");}
void  S1379C3_nt ::v70(){vfunc_called(this, "_ZN10S1379C3_nt3v70Ev");}
void  S1379C3_nt ::v71(){vfunc_called(this, "_ZN10S1379C3_nt3v71Ev");}
void  S1379C3_nt ::v72(){vfunc_called(this, "_ZN10S1379C3_nt3v72Ev");}
void  S1379C3_nt ::v73(){vfunc_called(this, "_ZN10S1379C3_nt3v73Ev");}
void  S1379C3_nt ::v74(){vfunc_called(this, "_ZN10S1379C3_nt3v74Ev");}
void  S1379C3_nt ::v75(){vfunc_called(this, "_ZN10S1379C3_nt3v75Ev");}
void  S1379C3_nt ::v76(){vfunc_called(this, "_ZN10S1379C3_nt3v76Ev");}
void  S1379C3_nt ::v77(){vfunc_called(this, "_ZN10S1379C3_nt3v77Ev");}
void  S1379C3_nt ::v78(){vfunc_called(this, "_ZN10S1379C3_nt3v78Ev");}
void  S1379C3_nt ::v79(){vfunc_called(this, "_ZN10S1379C3_nt3v79Ev");}
void  S1379C3_nt ::v80(){vfunc_called(this, "_ZN10S1379C3_nt3v80Ev");}
void  S1379C3_nt ::v81(){vfunc_called(this, "_ZN10S1379C3_nt3v81Ev");}
void  S1379C3_nt ::v82(){vfunc_called(this, "_ZN10S1379C3_nt3v82Ev");}
void  S1379C3_nt ::v83(){vfunc_called(this, "_ZN10S1379C3_nt3v83Ev");}
void  S1379C3_nt ::v84(){vfunc_called(this, "_ZN10S1379C3_nt3v84Ev");}
void  S1379C3_nt ::v85(){vfunc_called(this, "_ZN10S1379C3_nt3v85Ev");}
void  S1379C3_nt ::v86(){vfunc_called(this, "_ZN10S1379C3_nt3v86Ev");}
void  S1379C3_nt ::v87(){vfunc_called(this, "_ZN10S1379C3_nt3v87Ev");}
void  S1379C3_nt ::v88(){vfunc_called(this, "_ZN10S1379C3_nt3v88Ev");}
void  S1379C3_nt ::v89(){vfunc_called(this, "_ZN10S1379C3_nt3v89Ev");}
void  S1379C3_nt ::v90(){vfunc_called(this, "_ZN10S1379C3_nt3v90Ev");}
void  S1379C3_nt ::v91(){vfunc_called(this, "_ZN10S1379C3_nt3v91Ev");}
void  S1379C3_nt ::v92(){vfunc_called(this, "_ZN10S1379C3_nt3v92Ev");}
void  S1379C3_nt ::v93(){vfunc_called(this, "_ZN10S1379C3_nt3v93Ev");}
void  S1379C3_nt ::v94(){vfunc_called(this, "_ZN10S1379C3_nt3v94Ev");}
void  S1379C3_nt ::v95(){vfunc_called(this, "_ZN10S1379C3_nt3v95Ev");}
void  S1379C3_nt ::v96(){vfunc_called(this, "_ZN10S1379C3_nt3v96Ev");}
void  S1379C3_nt ::v97(){vfunc_called(this, "_ZN10S1379C3_nt3v97Ev");}
void  S1379C3_nt ::v98(){vfunc_called(this, "_ZN10S1379C3_nt3v98Ev");}
void  S1379C3_nt ::v99(){vfunc_called(this, "_ZN10S1379C3_nt3v99Ev");}
void  S1379C3_nt ::v100(){vfunc_called(this, "_ZN10S1379C3_nt4v100Ev");}
void  S1379C3_nt ::v101(){vfunc_called(this, "_ZN10S1379C3_nt4v101Ev");}
void  S1379C3_nt ::v102(){vfunc_called(this, "_ZN10S1379C3_nt4v102Ev");}
void  S1379C3_nt ::v103(){vfunc_called(this, "_ZN10S1379C3_nt4v103Ev");}
void  S1379C3_nt ::v104(){vfunc_called(this, "_ZN10S1379C3_nt4v104Ev");}
void  S1379C3_nt ::v105(){vfunc_called(this, "_ZN10S1379C3_nt4v105Ev");}
void  S1379C3_nt ::v106(){vfunc_called(this, "_ZN10S1379C3_nt4v106Ev");}
void  S1379C3_nt ::v107(){vfunc_called(this, "_ZN10S1379C3_nt4v107Ev");}
void  S1379C3_nt ::v108(){vfunc_called(this, "_ZN10S1379C3_nt4v108Ev");}
void  S1379C3_nt ::v109(){vfunc_called(this, "_ZN10S1379C3_nt4v109Ev");}
void  S1379C3_nt ::v110(){vfunc_called(this, "_ZN10S1379C3_nt4v110Ev");}
void  S1379C3_nt ::v111(){vfunc_called(this, "_ZN10S1379C3_nt4v111Ev");}
void  S1379C3_nt ::v112(){vfunc_called(this, "_ZN10S1379C3_nt4v112Ev");}
void  S1379C3_nt ::v113(){vfunc_called(this, "_ZN10S1379C3_nt4v113Ev");}
void  S1379C3_nt ::v114(){vfunc_called(this, "_ZN10S1379C3_nt4v114Ev");}
void  S1379C3_nt ::v115(){vfunc_called(this, "_ZN10S1379C3_nt4v115Ev");}
void  S1379C3_nt ::v116(){vfunc_called(this, "_ZN10S1379C3_nt4v116Ev");}
void  S1379C3_nt ::v117(){vfunc_called(this, "_ZN10S1379C3_nt4v117Ev");}
void  S1379C3_nt ::v118(){vfunc_called(this, "_ZN10S1379C3_nt4v118Ev");}
void  S1379C3_nt ::v119(){vfunc_called(this, "_ZN10S1379C3_nt4v119Ev");}
void  S1379C3_nt ::v120(){vfunc_called(this, "_ZN10S1379C3_nt4v120Ev");}
void  S1379C3_nt ::v121(){vfunc_called(this, "_ZN10S1379C3_nt4v121Ev");}
void  S1379C3_nt ::v122(){vfunc_called(this, "_ZN10S1379C3_nt4v122Ev");}
void  S1379C3_nt ::v123(){vfunc_called(this, "_ZN10S1379C3_nt4v123Ev");}
void  S1379C3_nt ::v124(){vfunc_called(this, "_ZN10S1379C3_nt4v124Ev");}
void  S1379C3_nt ::v125(){vfunc_called(this, "_ZN10S1379C3_nt4v125Ev");}
void  S1379C3_nt ::v126(){vfunc_called(this, "_ZN10S1379C3_nt4v126Ev");}
void  S1379C3_nt ::v127(){vfunc_called(this, "_ZN10S1379C3_nt4v127Ev");}
void  S1379C3_nt ::v128(){vfunc_called(this, "_ZN10S1379C3_nt4v128Ev");}
void  S1379C3_nt ::v129(){vfunc_called(this, "_ZN10S1379C3_nt4v129Ev");}
void  S1379C3_nt ::v130(){vfunc_called(this, "_ZN10S1379C3_nt4v130Ev");}
void  S1379C3_nt ::v131(){vfunc_called(this, "_ZN10S1379C3_nt4v131Ev");}
void  S1379C3_nt ::v132(){vfunc_called(this, "_ZN10S1379C3_nt4v132Ev");}
void  S1379C3_nt ::v133(){vfunc_called(this, "_ZN10S1379C3_nt4v133Ev");}
void  S1379C3_nt ::v134(){vfunc_called(this, "_ZN10S1379C3_nt4v134Ev");}
void  S1379C3_nt ::v135(){vfunc_called(this, "_ZN10S1379C3_nt4v135Ev");}
void  S1379C3_nt ::v136(){vfunc_called(this, "_ZN10S1379C3_nt4v136Ev");}
void  S1379C3_nt ::v137(){vfunc_called(this, "_ZN10S1379C3_nt4v137Ev");}
void  S1379C3_nt ::v138(){vfunc_called(this, "_ZN10S1379C3_nt4v138Ev");}
void  S1379C3_nt ::v139(){vfunc_called(this, "_ZN10S1379C3_nt4v139Ev");}
void  S1379C3_nt ::v140(){vfunc_called(this, "_ZN10S1379C3_nt4v140Ev");}
void  S1379C3_nt ::v141(){vfunc_called(this, "_ZN10S1379C3_nt4v141Ev");}
void  S1379C3_nt ::v142(){vfunc_called(this, "_ZN10S1379C3_nt4v142Ev");}
void  S1379C3_nt ::v143(){vfunc_called(this, "_ZN10S1379C3_nt4v143Ev");}
void  S1379C3_nt ::v144(){vfunc_called(this, "_ZN10S1379C3_nt4v144Ev");}
void  S1379C3_nt ::v145(){vfunc_called(this, "_ZN10S1379C3_nt4v145Ev");}
void  S1379C3_nt ::v146(){vfunc_called(this, "_ZN10S1379C3_nt4v146Ev");}
void  S1379C3_nt ::v147(){vfunc_called(this, "_ZN10S1379C3_nt4v147Ev");}
void  S1379C3_nt ::v148(){vfunc_called(this, "_ZN10S1379C3_nt4v148Ev");}
void  S1379C3_nt ::v149(){vfunc_called(this, "_ZN10S1379C3_nt4v149Ev");}
void  S1379C3_nt ::v150(){vfunc_called(this, "_ZN10S1379C3_nt4v150Ev");}
void  S1379C3_nt ::v151(){vfunc_called(this, "_ZN10S1379C3_nt4v151Ev");}
void  S1379C3_nt ::v152(){vfunc_called(this, "_ZN10S1379C3_nt4v152Ev");}
void  S1379C3_nt ::v153(){vfunc_called(this, "_ZN10S1379C3_nt4v153Ev");}
void  S1379C3_nt ::v154(){vfunc_called(this, "_ZN10S1379C3_nt4v154Ev");}
void  S1379C3_nt ::v155(){vfunc_called(this, "_ZN10S1379C3_nt4v155Ev");}
void  S1379C3_nt ::v156(){vfunc_called(this, "_ZN10S1379C3_nt4v156Ev");}
void  S1379C3_nt ::v157(){vfunc_called(this, "_ZN10S1379C3_nt4v157Ev");}
void  S1379C3_nt ::v158(){vfunc_called(this, "_ZN10S1379C3_nt4v158Ev");}
void  S1379C3_nt ::v159(){vfunc_called(this, "_ZN10S1379C3_nt4v159Ev");}
void  S1379C3_nt ::v160(){vfunc_called(this, "_ZN10S1379C3_nt4v160Ev");}
void  S1379C3_nt ::v161(){vfunc_called(this, "_ZN10S1379C3_nt4v161Ev");}
void  S1379C3_nt ::v162(){vfunc_called(this, "_ZN10S1379C3_nt4v162Ev");}
void  S1379C3_nt ::v163(){vfunc_called(this, "_ZN10S1379C3_nt4v163Ev");}
void  S1379C3_nt ::v164(){vfunc_called(this, "_ZN10S1379C3_nt4v164Ev");}
void  S1379C3_nt ::v165(){vfunc_called(this, "_ZN10S1379C3_nt4v165Ev");}
void  S1379C3_nt ::v166(){vfunc_called(this, "_ZN10S1379C3_nt4v166Ev");}
void  S1379C3_nt ::v167(){vfunc_called(this, "_ZN10S1379C3_nt4v167Ev");}
void  S1379C3_nt ::v168(){vfunc_called(this, "_ZN10S1379C3_nt4v168Ev");}
void  S1379C3_nt ::v169(){vfunc_called(this, "_ZN10S1379C3_nt4v169Ev");}
void  S1379C3_nt ::v170(){vfunc_called(this, "_ZN10S1379C3_nt4v170Ev");}
void  S1379C3_nt ::v171(){vfunc_called(this, "_ZN10S1379C3_nt4v171Ev");}
void  S1379C3_nt ::v172(){vfunc_called(this, "_ZN10S1379C3_nt4v172Ev");}
void  S1379C3_nt ::v173(){vfunc_called(this, "_ZN10S1379C3_nt4v173Ev");}
void  S1379C3_nt ::v174(){vfunc_called(this, "_ZN10S1379C3_nt4v174Ev");}
void  S1379C3_nt ::v175(){vfunc_called(this, "_ZN10S1379C3_nt4v175Ev");}
void  S1379C3_nt ::v176(){vfunc_called(this, "_ZN10S1379C3_nt4v176Ev");}
void  S1379C3_nt ::v177(){vfunc_called(this, "_ZN10S1379C3_nt4v177Ev");}
void  S1379C3_nt ::v178(){vfunc_called(this, "_ZN10S1379C3_nt4v178Ev");}
void  S1379C3_nt ::v179(){vfunc_called(this, "_ZN10S1379C3_nt4v179Ev");}
void  S1379C3_nt ::v180(){vfunc_called(this, "_ZN10S1379C3_nt4v180Ev");}
void  S1379C3_nt ::v181(){vfunc_called(this, "_ZN10S1379C3_nt4v181Ev");}
void  S1379C3_nt ::v182(){vfunc_called(this, "_ZN10S1379C3_nt4v182Ev");}
void  S1379C3_nt ::v183(){vfunc_called(this, "_ZN10S1379C3_nt4v183Ev");}
void  S1379C3_nt ::v184(){vfunc_called(this, "_ZN10S1379C3_nt4v184Ev");}
void  S1379C3_nt ::v185(){vfunc_called(this, "_ZN10S1379C3_nt4v185Ev");}
void  S1379C3_nt ::v186(){vfunc_called(this, "_ZN10S1379C3_nt4v186Ev");}
void  S1379C3_nt ::v187(){vfunc_called(this, "_ZN10S1379C3_nt4v187Ev");}
void  S1379C3_nt ::v188(){vfunc_called(this, "_ZN10S1379C3_nt4v188Ev");}
void  S1379C3_nt ::v189(){vfunc_called(this, "_ZN10S1379C3_nt4v189Ev");}
void  S1379C3_nt ::v190(){vfunc_called(this, "_ZN10S1379C3_nt4v190Ev");}
void  S1379C3_nt ::v191(){vfunc_called(this, "_ZN10S1379C3_nt4v191Ev");}
void  S1379C3_nt ::v192(){vfunc_called(this, "_ZN10S1379C3_nt4v192Ev");}
void  S1379C3_nt ::v193(){vfunc_called(this, "_ZN10S1379C3_nt4v193Ev");}
void  S1379C3_nt ::v194(){vfunc_called(this, "_ZN10S1379C3_nt4v194Ev");}
void  S1379C3_nt ::v195(){vfunc_called(this, "_ZN10S1379C3_nt4v195Ev");}
void  S1379C3_nt ::v196(){vfunc_called(this, "_ZN10S1379C3_nt4v196Ev");}
void  S1379C3_nt ::v197(){vfunc_called(this, "_ZN10S1379C3_nt4v197Ev");}
void  S1379C3_nt ::v198(){vfunc_called(this, "_ZN10S1379C3_nt4v198Ev");}
void  S1379C3_nt ::v199(){vfunc_called(this, "_ZN10S1379C3_nt4v199Ev");}
void  S1379C3_nt ::v200(){vfunc_called(this, "_ZN10S1379C3_nt4v200Ev");}
void  S1379C3_nt ::v201(){vfunc_called(this, "_ZN10S1379C3_nt4v201Ev");}
void  S1379C3_nt ::v202(){vfunc_called(this, "_ZN10S1379C3_nt4v202Ev");}
void  S1379C3_nt ::v203(){vfunc_called(this, "_ZN10S1379C3_nt4v203Ev");}
void  S1379C3_nt ::v204(){vfunc_called(this, "_ZN10S1379C3_nt4v204Ev");}
void  S1379C3_nt ::v205(){vfunc_called(this, "_ZN10S1379C3_nt4v205Ev");}
void  S1379C3_nt ::v206(){vfunc_called(this, "_ZN10S1379C3_nt4v206Ev");}
void  S1379C3_nt ::v207(){vfunc_called(this, "_ZN10S1379C3_nt4v207Ev");}
void  S1379C3_nt ::v208(){vfunc_called(this, "_ZN10S1379C3_nt4v208Ev");}
void  S1379C3_nt ::v209(){vfunc_called(this, "_ZN10S1379C3_nt4v209Ev");}
S1379C3_nt ::S1379C3_nt(){ note_ctor("S1379C3_nt", this);} // tgen

//skip512 S1379C3_nt

#else // __cplusplus

extern void _ZN10S1379C3_ntC1Ev();
extern void _ZN10S1379C3_ntD1Ev();
Name_Map name_map_S1379C3_nt[] = {
  NSPAIR(_ZN10S1379C3_ntC1Ev),
  NSPAIR(_ZN10S1379C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1379C4_nt;
extern VTBL_ENTRY _ZTI10S1379C4_nt[];
extern  VTBL_ENTRY _ZTV10S1379C4_nt[];
static Base_Class bases_S1379C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1379C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1379C3_nt[];
extern void _ZN10S1379C3_ntD1Ev();
extern void _ZN10S1379C3_ntD0Ev();
extern void _ZN10S1379C4_nt2v3Ev();
extern void _ZN10S1379C4_nt2v4Ev();
extern void _ZN10S1379C4_nt2v5Ev();
extern void _ZN10S1379C4_nt2v6Ev();
extern void _ZN10S1379C4_nt2v7Ev();
extern void _ZN10S1379C4_nt2v8Ev();
extern void _ZN10S1379C4_nt2v9Ev();
extern void _ZN10S1379C4_nt3v10Ev();
extern void _ZN10S1379C4_nt3v11Ev();
extern void _ZN10S1379C4_nt3v12Ev();
extern void _ZN10S1379C4_nt3v13Ev();
extern void _ZN10S1379C4_nt3v14Ev();
extern void _ZN10S1379C4_nt3v15Ev();
extern void _ZN10S1379C4_nt3v16Ev();
extern void _ZN10S1379C4_nt3v17Ev();
extern void _ZN10S1379C4_nt3v18Ev();
extern void _ZN10S1379C4_nt3v19Ev();
extern void _ZN10S1379C4_nt3v20Ev();
extern void _ZN10S1379C4_nt3v21Ev();
extern void _ZN10S1379C4_nt3v22Ev();
extern void _ZN10S1379C4_nt3v23Ev();
extern void _ZN10S1379C4_nt3v24Ev();
extern void _ZN10S1379C4_nt3v25Ev();
extern void _ZN10S1379C4_nt3v26Ev();
extern void _ZN10S1379C4_nt3v27Ev();
extern void _ZN10S1379C4_nt3v28Ev();
extern void _ZN10S1379C4_nt3v29Ev();
extern void _ZN10S1379C4_nt3v30Ev();
extern void _ZN10S1379C4_nt3v31Ev();
extern void _ZN10S1379C4_nt3v32Ev();
extern void _ZN10S1379C4_nt3v33Ev();
extern void _ZN10S1379C4_nt3v34Ev();
extern void _ZN10S1379C4_nt3v35Ev();
extern void _ZN10S1379C4_nt3v36Ev();
extern void _ZN10S1379C4_nt3v37Ev();
extern void _ZN10S1379C4_nt3v38Ev();
extern void _ZN10S1379C4_nt3v39Ev();
extern void _ZN10S1379C4_nt3v40Ev();
extern void _ZN10S1379C4_nt3v41Ev();
extern void _ZN10S1379C4_nt3v42Ev();
extern void _ZN10S1379C4_nt3v43Ev();
extern void _ZN10S1379C4_nt3v44Ev();
extern void _ZN10S1379C4_nt3v45Ev();
extern void _ZN10S1379C4_nt3v46Ev();
extern void _ZN10S1379C4_nt3v47Ev();
extern void _ZN10S1379C4_nt3v48Ev();
extern void _ZN10S1379C4_nt3v49Ev();
extern void _ZN10S1379C4_nt3v50Ev();
extern void _ZN10S1379C4_nt3v51Ev();
extern void _ZN10S1379C4_nt3v52Ev();
extern void _ZN10S1379C4_nt3v53Ev();
extern void _ZN10S1379C4_nt3v54Ev();
extern void _ZN10S1379C4_nt3v55Ev();
extern void _ZN10S1379C4_nt3v56Ev();
extern void _ZN10S1379C4_nt3v57Ev();
extern void _ZN10S1379C4_nt3v58Ev();
extern void _ZN10S1379C4_nt3v59Ev();
extern void _ZN10S1379C4_nt3v60Ev();
extern void _ZN10S1379C4_nt3v61Ev();
extern void _ZN10S1379C4_nt3v62Ev();
extern void _ZN10S1379C4_nt3v63Ev();
extern void _ZN10S1379C4_nt3v64Ev();
extern void _ZN10S1379C4_nt3v65Ev();
extern void _ZN10S1379C4_nt3v66Ev();
extern void _ZN10S1379C3_nt3v67Ev();
extern void _ZN10S1379C3_nt3v68Ev();
extern void _ZN10S1379C3_nt3v69Ev();
extern void _ZN10S1379C3_nt3v70Ev();
extern void _ZN10S1379C3_nt3v71Ev();
extern void _ZN10S1379C3_nt3v72Ev();
extern void _ZN10S1379C3_nt3v73Ev();
extern void _ZN10S1379C3_nt3v74Ev();
extern void _ZN10S1379C3_nt3v75Ev();
extern void _ZN10S1379C3_nt3v76Ev();
extern void _ZN10S1379C3_nt3v77Ev();
extern void _ZN10S1379C3_nt3v78Ev();
extern void _ZN10S1379C3_nt3v79Ev();
extern void _ZN10S1379C3_nt3v80Ev();
extern void _ZN10S1379C3_nt3v81Ev();
extern void _ZN10S1379C3_nt3v82Ev();
extern void _ZN10S1379C3_nt3v83Ev();
extern void _ZN10S1379C3_nt3v84Ev();
extern void _ZN10S1379C3_nt3v85Ev();
extern void _ZN10S1379C3_nt3v86Ev();
extern void _ZN10S1379C3_nt3v87Ev();
extern void _ZN10S1379C3_nt3v88Ev();
extern void _ZN10S1379C3_nt3v89Ev();
extern void _ZN10S1379C3_nt3v90Ev();
extern void _ZN10S1379C3_nt3v91Ev();
extern void _ZN10S1379C3_nt3v92Ev();
extern void _ZN10S1379C3_nt3v93Ev();
extern void _ZN10S1379C3_nt3v94Ev();
extern void _ZN10S1379C3_nt3v95Ev();
extern void _ZN10S1379C3_nt3v96Ev();
extern void _ZN10S1379C3_nt3v97Ev();
extern void _ZN10S1379C3_nt3v98Ev();
extern void _ZN10S1379C3_nt3v99Ev();
extern void _ZN10S1379C3_nt4v100Ev();
extern void _ZN10S1379C3_nt4v101Ev();
extern void _ZN10S1379C3_nt4v102Ev();
extern void _ZN10S1379C3_nt4v103Ev();
extern void _ZN10S1379C3_nt4v104Ev();
extern void _ZN10S1379C3_nt4v105Ev();
extern void _ZN10S1379C3_nt4v106Ev();
extern void _ZN10S1379C3_nt4v107Ev();
extern void _ZN10S1379C3_nt4v108Ev();
extern void _ZN10S1379C3_nt4v109Ev();
extern void _ZN10S1379C3_nt4v110Ev();
extern void _ZN10S1379C3_nt4v111Ev();
extern void _ZN10S1379C3_nt4v112Ev();
extern void _ZN10S1379C3_nt4v113Ev();
extern void _ZN10S1379C3_nt4v114Ev();
extern void _ZN10S1379C3_nt4v115Ev();
extern void _ZN10S1379C3_nt4v116Ev();
extern void _ZN10S1379C3_nt4v117Ev();
extern void _ZN10S1379C3_nt4v118Ev();
extern void _ZN10S1379C3_nt4v119Ev();
extern void _ZN10S1379C3_nt4v120Ev();
extern void _ZN10S1379C3_nt4v121Ev();
extern void _ZN10S1379C3_nt4v122Ev();
extern void _ZN10S1379C3_nt4v123Ev();
extern void _ZN10S1379C3_nt4v124Ev();
extern void _ZN10S1379C3_nt4v125Ev();
extern void _ZN10S1379C3_nt4v126Ev();
extern void _ZN10S1379C3_nt4v127Ev();
extern void _ZN10S1379C3_nt4v128Ev();
extern void _ZN10S1379C3_nt4v129Ev();
extern void _ZN10S1379C3_nt4v130Ev();
extern void _ZN10S1379C3_nt4v131Ev();
extern void _ZN10S1379C3_nt4v132Ev();
extern void _ZN10S1379C3_nt4v133Ev();
extern void _ZN10S1379C3_nt4v134Ev();
extern void _ZN10S1379C3_nt4v135Ev();
extern void _ZN10S1379C3_nt4v136Ev();
extern void _ZN10S1379C3_nt4v137Ev();
extern void _ZN10S1379C3_nt4v138Ev();
extern void _ZN10S1379C3_nt4v139Ev();
extern void _ZN10S1379C3_nt4v140Ev();
extern void _ZN10S1379C3_nt4v141Ev();
extern void _ZN10S1379C3_nt4v142Ev();
extern void _ZN10S1379C3_nt4v143Ev();
extern void _ZN10S1379C3_nt4v144Ev();
extern void _ZN10S1379C3_nt4v145Ev();
extern void _ZN10S1379C3_nt4v146Ev();
extern void _ZN10S1379C3_nt4v147Ev();
extern void _ZN10S1379C3_nt4v148Ev();
extern void _ZN10S1379C3_nt4v149Ev();
extern void _ZN10S1379C3_nt4v150Ev();
extern void _ZN10S1379C3_nt4v151Ev();
extern void _ZN10S1379C3_nt4v152Ev();
extern void _ZN10S1379C3_nt4v153Ev();
extern void _ZN10S1379C3_nt4v154Ev();
extern void _ZN10S1379C3_nt4v155Ev();
extern void _ZN10S1379C3_nt4v156Ev();
extern void _ZN10S1379C3_nt4v157Ev();
extern void _ZN10S1379C3_nt4v158Ev();
extern void _ZN10S1379C3_nt4v159Ev();
extern void _ZN10S1379C3_nt4v160Ev();
extern void _ZN10S1379C3_nt4v161Ev();
extern void _ZN10S1379C3_nt4v162Ev();
extern void _ZN10S1379C3_nt4v163Ev();
extern void _ZN10S1379C3_nt4v164Ev();
extern void _ZN10S1379C3_nt4v165Ev();
extern void _ZN10S1379C3_nt4v166Ev();
extern void _ZN10S1379C3_nt4v167Ev();
extern void _ZN10S1379C3_nt4v168Ev();
extern void _ZN10S1379C3_nt4v169Ev();
extern void _ZN10S1379C3_nt4v170Ev();
extern void _ZN10S1379C3_nt4v171Ev();
extern void _ZN10S1379C3_nt4v172Ev();
extern void _ZN10S1379C3_nt4v173Ev();
extern void _ZN10S1379C3_nt4v174Ev();
extern void _ZN10S1379C3_nt4v175Ev();
extern void _ZN10S1379C3_nt4v176Ev();
extern void _ZN10S1379C3_nt4v177Ev();
extern void _ZN10S1379C3_nt4v178Ev();
extern void _ZN10S1379C3_nt4v179Ev();
extern void _ZN10S1379C3_nt4v180Ev();
extern void _ZN10S1379C3_nt4v181Ev();
extern void _ZN10S1379C3_nt4v182Ev();
extern void _ZN10S1379C3_nt4v183Ev();
extern void _ZN10S1379C3_nt4v184Ev();
extern void _ZN10S1379C3_nt4v185Ev();
extern void _ZN10S1379C3_nt4v186Ev();
extern void _ZN10S1379C3_nt4v187Ev();
extern void _ZN10S1379C3_nt4v188Ev();
extern void _ZN10S1379C3_nt4v189Ev();
extern void _ZN10S1379C3_nt4v190Ev();
extern void _ZN10S1379C3_nt4v191Ev();
extern void _ZN10S1379C3_nt4v192Ev();
extern void _ZN10S1379C3_nt4v193Ev();
extern void _ZN10S1379C3_nt4v194Ev();
extern void _ZN10S1379C3_nt4v195Ev();
extern void _ZN10S1379C3_nt4v196Ev();
extern void _ZN10S1379C3_nt4v197Ev();
extern void _ZN10S1379C3_nt4v198Ev();
extern void _ZN10S1379C3_nt4v199Ev();
extern void _ZN10S1379C3_nt4v200Ev();
extern void _ZN10S1379C3_nt4v201Ev();
extern void _ZN10S1379C3_nt4v202Ev();
extern void _ZN10S1379C3_nt4v203Ev();
extern void _ZN10S1379C3_nt4v204Ev();
extern void _ZN10S1379C3_nt4v205Ev();
extern void _ZN10S1379C3_nt4v206Ev();
extern void _ZN10S1379C3_nt4v207Ev();
extern void _ZN10S1379C3_nt4v208Ev();
extern void _ZN10S1379C3_nt4v209Ev();
static  VTBL_ENTRY vtc_S1379C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1379C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S1379C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v209Ev,
};
extern VTBL_ENTRY _ZTI10S1379C3_nt[];
VTBL_ENTRY *P__ZTI10S1379C3_nt = _ZTI10S1379C3_nt; 
extern  VTBL_ENTRY _ZTV10S1379C3_nt[];
Class_Descriptor cd_S1379C3_nt = {  "S1379C3_nt", // class name
  bases_S1379C3_nt, 1,
  &(vtc_S1379C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI10S1379C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1379C3_nt),211, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1379C2_nt  : S1379C3_nt {
  virtual  ~S1379C2_nt(); // _ZN10S1379C2_ntD1Ev
  virtual void  v210(); // _ZN10S1379C2_nt4v210Ev
  virtual void  v211(); // _ZN10S1379C2_nt4v211Ev
  S1379C2_nt(); // tgen
};
//SIG(-1 S1379C2_nt) C1{ BC2{ BC3{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC4{ m Fi[2]} Fp[2]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 FC5{ BC6{ BC7{ m Fp Fi[2]}}} FC5 FC8{ m Fi} Fi Fc[4] Fp[2] FC5 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC4 FC4 FC4 FC9{ BC10{ BC7}} FC9 Fi Fp[2] FC11{ m Fi[3]} FC11 FC11 FC11 Fp FC4 FC9 FC11 FC11 Fi FC11 FC11 Fp Fi Fc FC11 FC11 Fp Fi Fp FC9 FC12{ BC13{ BC7}} FC12} vd v1 v2}


 S1379C2_nt ::~S1379C2_nt(){ note_dtor("S1379C2_nt", this);}
void  S1379C2_nt ::v210(){vfunc_called(this, "_ZN10S1379C2_nt4v210Ev");}
void  S1379C2_nt ::v211(){vfunc_called(this, "_ZN10S1379C2_nt4v211Ev");}
S1379C2_nt ::S1379C2_nt(){ note_ctor("S1379C2_nt", this);} // tgen

//skip512 S1379C2_nt

#else // __cplusplus

extern void _ZN10S1379C2_ntC1Ev();
extern void _ZN10S1379C2_ntD1Ev();
Name_Map name_map_S1379C2_nt[] = {
  NSPAIR(_ZN10S1379C2_ntC1Ev),
  NSPAIR(_ZN10S1379C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1379C4_nt;
extern VTBL_ENTRY _ZTI10S1379C4_nt[];
extern  VTBL_ENTRY _ZTV10S1379C4_nt[];
extern Class_Descriptor cd_S1379C3_nt;
extern VTBL_ENTRY _ZTI10S1379C3_nt[];
extern  VTBL_ENTRY _ZTV10S1379C3_nt[];
static Base_Class bases_S1379C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1379C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1379C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1379C2_nt[];
extern void _ZN10S1379C2_ntD1Ev();
extern void _ZN10S1379C2_ntD0Ev();
extern void _ZN10S1379C4_nt2v3Ev();
extern void _ZN10S1379C4_nt2v4Ev();
extern void _ZN10S1379C4_nt2v5Ev();
extern void _ZN10S1379C4_nt2v6Ev();
extern void _ZN10S1379C4_nt2v7Ev();
extern void _ZN10S1379C4_nt2v8Ev();
extern void _ZN10S1379C4_nt2v9Ev();
extern void _ZN10S1379C4_nt3v10Ev();
extern void _ZN10S1379C4_nt3v11Ev();
extern void _ZN10S1379C4_nt3v12Ev();
extern void _ZN10S1379C4_nt3v13Ev();
extern void _ZN10S1379C4_nt3v14Ev();
extern void _ZN10S1379C4_nt3v15Ev();
extern void _ZN10S1379C4_nt3v16Ev();
extern void _ZN10S1379C4_nt3v17Ev();
extern void _ZN10S1379C4_nt3v18Ev();
extern void _ZN10S1379C4_nt3v19Ev();
extern void _ZN10S1379C4_nt3v20Ev();
extern void _ZN10S1379C4_nt3v21Ev();
extern void _ZN10S1379C4_nt3v22Ev();
extern void _ZN10S1379C4_nt3v23Ev();
extern void _ZN10S1379C4_nt3v24Ev();
extern void _ZN10S1379C4_nt3v25Ev();
extern void _ZN10S1379C4_nt3v26Ev();
extern void _ZN10S1379C4_nt3v27Ev();
extern void _ZN10S1379C4_nt3v28Ev();
extern void _ZN10S1379C4_nt3v29Ev();
extern void _ZN10S1379C4_nt3v30Ev();
extern void _ZN10S1379C4_nt3v31Ev();
extern void _ZN10S1379C4_nt3v32Ev();
extern void _ZN10S1379C4_nt3v33Ev();
extern void _ZN10S1379C4_nt3v34Ev();
extern void _ZN10S1379C4_nt3v35Ev();
extern void _ZN10S1379C4_nt3v36Ev();
extern void _ZN10S1379C4_nt3v37Ev();
extern void _ZN10S1379C4_nt3v38Ev();
extern void _ZN10S1379C4_nt3v39Ev();
extern void _ZN10S1379C4_nt3v40Ev();
extern void _ZN10S1379C4_nt3v41Ev();
extern void _ZN10S1379C4_nt3v42Ev();
extern void _ZN10S1379C4_nt3v43Ev();
extern void _ZN10S1379C4_nt3v44Ev();
extern void _ZN10S1379C4_nt3v45Ev();
extern void _ZN10S1379C4_nt3v46Ev();
extern void _ZN10S1379C4_nt3v47Ev();
extern void _ZN10S1379C4_nt3v48Ev();
extern void _ZN10S1379C4_nt3v49Ev();
extern void _ZN10S1379C4_nt3v50Ev();
extern void _ZN10S1379C4_nt3v51Ev();
extern void _ZN10S1379C4_nt3v52Ev();
extern void _ZN10S1379C4_nt3v53Ev();
extern void _ZN10S1379C4_nt3v54Ev();
extern void _ZN10S1379C4_nt3v55Ev();
extern void _ZN10S1379C4_nt3v56Ev();
extern void _ZN10S1379C4_nt3v57Ev();
extern void _ZN10S1379C4_nt3v58Ev();
extern void _ZN10S1379C4_nt3v59Ev();
extern void _ZN10S1379C4_nt3v60Ev();
extern void _ZN10S1379C4_nt3v61Ev();
extern void _ZN10S1379C4_nt3v62Ev();
extern void _ZN10S1379C4_nt3v63Ev();
extern void _ZN10S1379C4_nt3v64Ev();
extern void _ZN10S1379C4_nt3v65Ev();
extern void _ZN10S1379C4_nt3v66Ev();
extern void _ZN10S1379C3_nt3v67Ev();
extern void _ZN10S1379C3_nt3v68Ev();
extern void _ZN10S1379C3_nt3v69Ev();
extern void _ZN10S1379C3_nt3v70Ev();
extern void _ZN10S1379C3_nt3v71Ev();
extern void _ZN10S1379C3_nt3v72Ev();
extern void _ZN10S1379C3_nt3v73Ev();
extern void _ZN10S1379C3_nt3v74Ev();
extern void _ZN10S1379C3_nt3v75Ev();
extern void _ZN10S1379C3_nt3v76Ev();
extern void _ZN10S1379C3_nt3v77Ev();
extern void _ZN10S1379C3_nt3v78Ev();
extern void _ZN10S1379C3_nt3v79Ev();
extern void _ZN10S1379C3_nt3v80Ev();
extern void _ZN10S1379C3_nt3v81Ev();
extern void _ZN10S1379C3_nt3v82Ev();
extern void _ZN10S1379C3_nt3v83Ev();
extern void _ZN10S1379C3_nt3v84Ev();
extern void _ZN10S1379C3_nt3v85Ev();
extern void _ZN10S1379C3_nt3v86Ev();
extern void _ZN10S1379C3_nt3v87Ev();
extern void _ZN10S1379C3_nt3v88Ev();
extern void _ZN10S1379C3_nt3v89Ev();
extern void _ZN10S1379C3_nt3v90Ev();
extern void _ZN10S1379C3_nt3v91Ev();
extern void _ZN10S1379C3_nt3v92Ev();
extern void _ZN10S1379C3_nt3v93Ev();
extern void _ZN10S1379C3_nt3v94Ev();
extern void _ZN10S1379C3_nt3v95Ev();
extern void _ZN10S1379C3_nt3v96Ev();
extern void _ZN10S1379C3_nt3v97Ev();
extern void _ZN10S1379C3_nt3v98Ev();
extern void _ZN10S1379C3_nt3v99Ev();
extern void _ZN10S1379C3_nt4v100Ev();
extern void _ZN10S1379C3_nt4v101Ev();
extern void _ZN10S1379C3_nt4v102Ev();
extern void _ZN10S1379C3_nt4v103Ev();
extern void _ZN10S1379C3_nt4v104Ev();
extern void _ZN10S1379C3_nt4v105Ev();
extern void _ZN10S1379C3_nt4v106Ev();
extern void _ZN10S1379C3_nt4v107Ev();
extern void _ZN10S1379C3_nt4v108Ev();
extern void _ZN10S1379C3_nt4v109Ev();
extern void _ZN10S1379C3_nt4v110Ev();
extern void _ZN10S1379C3_nt4v111Ev();
extern void _ZN10S1379C3_nt4v112Ev();
extern void _ZN10S1379C3_nt4v113Ev();
extern void _ZN10S1379C3_nt4v114Ev();
extern void _ZN10S1379C3_nt4v115Ev();
extern void _ZN10S1379C3_nt4v116Ev();
extern void _ZN10S1379C3_nt4v117Ev();
extern void _ZN10S1379C3_nt4v118Ev();
extern void _ZN10S1379C3_nt4v119Ev();
extern void _ZN10S1379C3_nt4v120Ev();
extern void _ZN10S1379C3_nt4v121Ev();
extern void _ZN10S1379C3_nt4v122Ev();
extern void _ZN10S1379C3_nt4v123Ev();
extern void _ZN10S1379C3_nt4v124Ev();
extern void _ZN10S1379C3_nt4v125Ev();
extern void _ZN10S1379C3_nt4v126Ev();
extern void _ZN10S1379C3_nt4v127Ev();
extern void _ZN10S1379C3_nt4v128Ev();
extern void _ZN10S1379C3_nt4v129Ev();
extern void _ZN10S1379C3_nt4v130Ev();
extern void _ZN10S1379C3_nt4v131Ev();
extern void _ZN10S1379C3_nt4v132Ev();
extern void _ZN10S1379C3_nt4v133Ev();
extern void _ZN10S1379C3_nt4v134Ev();
extern void _ZN10S1379C3_nt4v135Ev();
extern void _ZN10S1379C3_nt4v136Ev();
extern void _ZN10S1379C3_nt4v137Ev();
extern void _ZN10S1379C3_nt4v138Ev();
extern void _ZN10S1379C3_nt4v139Ev();
extern void _ZN10S1379C3_nt4v140Ev();
extern void _ZN10S1379C3_nt4v141Ev();
extern void _ZN10S1379C3_nt4v142Ev();
extern void _ZN10S1379C3_nt4v143Ev();
extern void _ZN10S1379C3_nt4v144Ev();
extern void _ZN10S1379C3_nt4v145Ev();
extern void _ZN10S1379C3_nt4v146Ev();
extern void _ZN10S1379C3_nt4v147Ev();
extern void _ZN10S1379C3_nt4v148Ev();
extern void _ZN10S1379C3_nt4v149Ev();
extern void _ZN10S1379C3_nt4v150Ev();
extern void _ZN10S1379C3_nt4v151Ev();
extern void _ZN10S1379C3_nt4v152Ev();
extern void _ZN10S1379C3_nt4v153Ev();
extern void _ZN10S1379C3_nt4v154Ev();
extern void _ZN10S1379C3_nt4v155Ev();
extern void _ZN10S1379C3_nt4v156Ev();
extern void _ZN10S1379C3_nt4v157Ev();
extern void _ZN10S1379C3_nt4v158Ev();
extern void _ZN10S1379C3_nt4v159Ev();
extern void _ZN10S1379C3_nt4v160Ev();
extern void _ZN10S1379C3_nt4v161Ev();
extern void _ZN10S1379C3_nt4v162Ev();
extern void _ZN10S1379C3_nt4v163Ev();
extern void _ZN10S1379C3_nt4v164Ev();
extern void _ZN10S1379C3_nt4v165Ev();
extern void _ZN10S1379C3_nt4v166Ev();
extern void _ZN10S1379C3_nt4v167Ev();
extern void _ZN10S1379C3_nt4v168Ev();
extern void _ZN10S1379C3_nt4v169Ev();
extern void _ZN10S1379C3_nt4v170Ev();
extern void _ZN10S1379C3_nt4v171Ev();
extern void _ZN10S1379C3_nt4v172Ev();
extern void _ZN10S1379C3_nt4v173Ev();
extern void _ZN10S1379C3_nt4v174Ev();
extern void _ZN10S1379C3_nt4v175Ev();
extern void _ZN10S1379C3_nt4v176Ev();
extern void _ZN10S1379C3_nt4v177Ev();
extern void _ZN10S1379C3_nt4v178Ev();
extern void _ZN10S1379C3_nt4v179Ev();
extern void _ZN10S1379C3_nt4v180Ev();
extern void _ZN10S1379C3_nt4v181Ev();
extern void _ZN10S1379C3_nt4v182Ev();
extern void _ZN10S1379C3_nt4v183Ev();
extern void _ZN10S1379C3_nt4v184Ev();
extern void _ZN10S1379C3_nt4v185Ev();
extern void _ZN10S1379C3_nt4v186Ev();
extern void _ZN10S1379C3_nt4v187Ev();
extern void _ZN10S1379C3_nt4v188Ev();
extern void _ZN10S1379C3_nt4v189Ev();
extern void _ZN10S1379C3_nt4v190Ev();
extern void _ZN10S1379C3_nt4v191Ev();
extern void _ZN10S1379C3_nt4v192Ev();
extern void _ZN10S1379C3_nt4v193Ev();
extern void _ZN10S1379C3_nt4v194Ev();
extern void _ZN10S1379C3_nt4v195Ev();
extern void _ZN10S1379C3_nt4v196Ev();
extern void _ZN10S1379C3_nt4v197Ev();
extern void _ZN10S1379C3_nt4v198Ev();
extern void _ZN10S1379C3_nt4v199Ev();
extern void _ZN10S1379C3_nt4v200Ev();
extern void _ZN10S1379C3_nt4v201Ev();
extern void _ZN10S1379C3_nt4v202Ev();
extern void _ZN10S1379C3_nt4v203Ev();
extern void _ZN10S1379C3_nt4v204Ev();
extern void _ZN10S1379C3_nt4v205Ev();
extern void _ZN10S1379C3_nt4v206Ev();
extern void _ZN10S1379C3_nt4v207Ev();
extern void _ZN10S1379C3_nt4v208Ev();
extern void _ZN10S1379C3_nt4v209Ev();
extern void _ZN10S1379C2_nt4v210Ev();
extern void _ZN10S1379C2_nt4v211Ev();
static  VTBL_ENTRY vtc_S1379C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1379C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S1379C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1379C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1379C2_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S1379C2_nt4v211Ev,
};
extern VTBL_ENTRY _ZTI10S1379C2_nt[];
VTBL_ENTRY *P__ZTI10S1379C2_nt = _ZTI10S1379C2_nt; 
extern  VTBL_ENTRY _ZTV10S1379C2_nt[];
Class_Descriptor cd_S1379C2_nt = {  "S1379C2_nt", // class name
  bases_S1379C2_nt, 2,
  &(vtc_S1379C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI10S1379C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1379C2_nt),213, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1379C1  : S1379C2_nt {
  virtual  ~S1379C1(); // _ZN7S1379C1D1Ev
  virtual void  v1(); // _ZN7S1379C12v1Ev
  virtual void  v2(); // _ZN7S1379C12v2Ev
  S1379C1(); // tgen
};
//SIG(1 S1379C1) C1{ BC2{ BC3{ BC4{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 Fi FL Fp[4] Fi[2] Fp FC5{ m Fi[2]} Fp[2]} vd v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 v149 v150 v151 v152 v153 v154 v155 v156 v157 v158 v159 v160 v161 v162 v163 v164 v165 v166 v167 v168 v169 v170 v171 v172 v173 v174 v175 v176 v177 v178 v179 v180 v181 v182 v183 v184 v185 v186 v187 v188 v189 v190 v191 v192 v193 v194 v195 v196 v197 v198 v199 v200 v201 v202 v203 v204 v205 v206 v207 v208 v209 FC6{ BC7{ BC8{ m Fp Fi[2]}}} FC6 FC9{ m Fi} Fi Fc[4] Fp[2] FC6 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi:1 Fi[5] Fp[2] Fi[3] FC5 FC5 FC5 FC10{ BC11{ BC8}} FC10 Fi Fp[2] FC12{ m Fi[3]} FC12 FC12 FC12 Fp FC5 FC10 FC12 FC12 Fi FC12 FC12 Fp Fi Fc FC12 FC12 Fp Fi Fp FC10 FC13{ BC14{ BC8}} FC13} vd v210 v211} vd v1 v2}


 S1379C1 ::~S1379C1(){ note_dtor("S1379C1", this);}
void  S1379C1 ::v1(){vfunc_called(this, "_ZN7S1379C12v1Ev");}
void  S1379C1 ::v2(){vfunc_called(this, "_ZN7S1379C12v2Ev");}
S1379C1 ::S1379C1(){ note_ctor("S1379C1", this);} // tgen

static void Test_S1379C1()
{
  extern Class_Descriptor cd_S1379C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(72,110)];
    init_test(&cd_S1379C1, buf);
    S1379C1 *dp, &lv = *(dp=new (buf) S1379C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(568,436), "sizeof(S1379C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1379C1)");
    check_base_class_offset(lv, (S1379C4_nt*)(S1379C3_nt*)(S1379C2_nt*), 0, "S1379C1");
    check_base_class_offset(lv, (S1379C3_nt*)(S1379C2_nt*), 0, "S1379C1");
    check_base_class_offset(lv, (S1379C2_nt*), 0, "S1379C1");
    test_class_info(&lv, &cd_S1379C1);
    dp->~S1379C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1379C1(Test_S1379C1, "S1379C1", ABISELECT(568,436));

#else // __cplusplus

extern void _ZN7S1379C1C1Ev();
extern void _ZN7S1379C1D1Ev();
Name_Map name_map_S1379C1[] = {
  NSPAIR(_ZN7S1379C1C1Ev),
  NSPAIR(_ZN7S1379C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1379C4_nt;
extern VTBL_ENTRY _ZTI10S1379C4_nt[];
extern  VTBL_ENTRY _ZTV10S1379C4_nt[];
extern Class_Descriptor cd_S1379C3_nt;
extern VTBL_ENTRY _ZTI10S1379C3_nt[];
extern  VTBL_ENTRY _ZTV10S1379C3_nt[];
extern Class_Descriptor cd_S1379C2_nt;
extern VTBL_ENTRY _ZTI10S1379C2_nt[];
extern  VTBL_ENTRY _ZTV10S1379C2_nt[];
static Base_Class bases_S1379C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1379C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1379C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1379C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1379C1[];
extern void _ZN7S1379C1D1Ev();
extern void _ZN7S1379C1D0Ev();
extern void _ZN10S1379C4_nt2v3Ev();
extern void _ZN10S1379C4_nt2v4Ev();
extern void _ZN10S1379C4_nt2v5Ev();
extern void _ZN10S1379C4_nt2v6Ev();
extern void _ZN10S1379C4_nt2v7Ev();
extern void _ZN10S1379C4_nt2v8Ev();
extern void _ZN10S1379C4_nt2v9Ev();
extern void _ZN10S1379C4_nt3v10Ev();
extern void _ZN10S1379C4_nt3v11Ev();
extern void _ZN10S1379C4_nt3v12Ev();
extern void _ZN10S1379C4_nt3v13Ev();
extern void _ZN10S1379C4_nt3v14Ev();
extern void _ZN10S1379C4_nt3v15Ev();
extern void _ZN10S1379C4_nt3v16Ev();
extern void _ZN10S1379C4_nt3v17Ev();
extern void _ZN10S1379C4_nt3v18Ev();
extern void _ZN10S1379C4_nt3v19Ev();
extern void _ZN10S1379C4_nt3v20Ev();
extern void _ZN10S1379C4_nt3v21Ev();
extern void _ZN10S1379C4_nt3v22Ev();
extern void _ZN10S1379C4_nt3v23Ev();
extern void _ZN10S1379C4_nt3v24Ev();
extern void _ZN10S1379C4_nt3v25Ev();
extern void _ZN10S1379C4_nt3v26Ev();
extern void _ZN10S1379C4_nt3v27Ev();
extern void _ZN10S1379C4_nt3v28Ev();
extern void _ZN10S1379C4_nt3v29Ev();
extern void _ZN10S1379C4_nt3v30Ev();
extern void _ZN10S1379C4_nt3v31Ev();
extern void _ZN10S1379C4_nt3v32Ev();
extern void _ZN10S1379C4_nt3v33Ev();
extern void _ZN10S1379C4_nt3v34Ev();
extern void _ZN10S1379C4_nt3v35Ev();
extern void _ZN10S1379C4_nt3v36Ev();
extern void _ZN10S1379C4_nt3v37Ev();
extern void _ZN10S1379C4_nt3v38Ev();
extern void _ZN10S1379C4_nt3v39Ev();
extern void _ZN10S1379C4_nt3v40Ev();
extern void _ZN10S1379C4_nt3v41Ev();
extern void _ZN10S1379C4_nt3v42Ev();
extern void _ZN10S1379C4_nt3v43Ev();
extern void _ZN10S1379C4_nt3v44Ev();
extern void _ZN10S1379C4_nt3v45Ev();
extern void _ZN10S1379C4_nt3v46Ev();
extern void _ZN10S1379C4_nt3v47Ev();
extern void _ZN10S1379C4_nt3v48Ev();
extern void _ZN10S1379C4_nt3v49Ev();
extern void _ZN10S1379C4_nt3v50Ev();
extern void _ZN10S1379C4_nt3v51Ev();
extern void _ZN10S1379C4_nt3v52Ev();
extern void _ZN10S1379C4_nt3v53Ev();
extern void _ZN10S1379C4_nt3v54Ev();
extern void _ZN10S1379C4_nt3v55Ev();
extern void _ZN10S1379C4_nt3v56Ev();
extern void _ZN10S1379C4_nt3v57Ev();
extern void _ZN10S1379C4_nt3v58Ev();
extern void _ZN10S1379C4_nt3v59Ev();
extern void _ZN10S1379C4_nt3v60Ev();
extern void _ZN10S1379C4_nt3v61Ev();
extern void _ZN10S1379C4_nt3v62Ev();
extern void _ZN10S1379C4_nt3v63Ev();
extern void _ZN10S1379C4_nt3v64Ev();
extern void _ZN10S1379C4_nt3v65Ev();
extern void _ZN10S1379C4_nt3v66Ev();
extern void _ZN10S1379C3_nt3v67Ev();
extern void _ZN10S1379C3_nt3v68Ev();
extern void _ZN10S1379C3_nt3v69Ev();
extern void _ZN10S1379C3_nt3v70Ev();
extern void _ZN10S1379C3_nt3v71Ev();
extern void _ZN10S1379C3_nt3v72Ev();
extern void _ZN10S1379C3_nt3v73Ev();
extern void _ZN10S1379C3_nt3v74Ev();
extern void _ZN10S1379C3_nt3v75Ev();
extern void _ZN10S1379C3_nt3v76Ev();
extern void _ZN10S1379C3_nt3v77Ev();
extern void _ZN10S1379C3_nt3v78Ev();
extern void _ZN10S1379C3_nt3v79Ev();
extern void _ZN10S1379C3_nt3v80Ev();
extern void _ZN10S1379C3_nt3v81Ev();
extern void _ZN10S1379C3_nt3v82Ev();
extern void _ZN10S1379C3_nt3v83Ev();
extern void _ZN10S1379C3_nt3v84Ev();
extern void _ZN10S1379C3_nt3v85Ev();
extern void _ZN10S1379C3_nt3v86Ev();
extern void _ZN10S1379C3_nt3v87Ev();
extern void _ZN10S1379C3_nt3v88Ev();
extern void _ZN10S1379C3_nt3v89Ev();
extern void _ZN10S1379C3_nt3v90Ev();
extern void _ZN10S1379C3_nt3v91Ev();
extern void _ZN10S1379C3_nt3v92Ev();
extern void _ZN10S1379C3_nt3v93Ev();
extern void _ZN10S1379C3_nt3v94Ev();
extern void _ZN10S1379C3_nt3v95Ev();
extern void _ZN10S1379C3_nt3v96Ev();
extern void _ZN10S1379C3_nt3v97Ev();
extern void _ZN10S1379C3_nt3v98Ev();
extern void _ZN10S1379C3_nt3v99Ev();
extern void _ZN10S1379C3_nt4v100Ev();
extern void _ZN10S1379C3_nt4v101Ev();
extern void _ZN10S1379C3_nt4v102Ev();
extern void _ZN10S1379C3_nt4v103Ev();
extern void _ZN10S1379C3_nt4v104Ev();
extern void _ZN10S1379C3_nt4v105Ev();
extern void _ZN10S1379C3_nt4v106Ev();
extern void _ZN10S1379C3_nt4v107Ev();
extern void _ZN10S1379C3_nt4v108Ev();
extern void _ZN10S1379C3_nt4v109Ev();
extern void _ZN10S1379C3_nt4v110Ev();
extern void _ZN10S1379C3_nt4v111Ev();
extern void _ZN10S1379C3_nt4v112Ev();
extern void _ZN10S1379C3_nt4v113Ev();
extern void _ZN10S1379C3_nt4v114Ev();
extern void _ZN10S1379C3_nt4v115Ev();
extern void _ZN10S1379C3_nt4v116Ev();
extern void _ZN10S1379C3_nt4v117Ev();
extern void _ZN10S1379C3_nt4v118Ev();
extern void _ZN10S1379C3_nt4v119Ev();
extern void _ZN10S1379C3_nt4v120Ev();
extern void _ZN10S1379C3_nt4v121Ev();
extern void _ZN10S1379C3_nt4v122Ev();
extern void _ZN10S1379C3_nt4v123Ev();
extern void _ZN10S1379C3_nt4v124Ev();
extern void _ZN10S1379C3_nt4v125Ev();
extern void _ZN10S1379C3_nt4v126Ev();
extern void _ZN10S1379C3_nt4v127Ev();
extern void _ZN10S1379C3_nt4v128Ev();
extern void _ZN10S1379C3_nt4v129Ev();
extern void _ZN10S1379C3_nt4v130Ev();
extern void _ZN10S1379C3_nt4v131Ev();
extern void _ZN10S1379C3_nt4v132Ev();
extern void _ZN10S1379C3_nt4v133Ev();
extern void _ZN10S1379C3_nt4v134Ev();
extern void _ZN10S1379C3_nt4v135Ev();
extern void _ZN10S1379C3_nt4v136Ev();
extern void _ZN10S1379C3_nt4v137Ev();
extern void _ZN10S1379C3_nt4v138Ev();
extern void _ZN10S1379C3_nt4v139Ev();
extern void _ZN10S1379C3_nt4v140Ev();
extern void _ZN10S1379C3_nt4v141Ev();
extern void _ZN10S1379C3_nt4v142Ev();
extern void _ZN10S1379C3_nt4v143Ev();
extern void _ZN10S1379C3_nt4v144Ev();
extern void _ZN10S1379C3_nt4v145Ev();
extern void _ZN10S1379C3_nt4v146Ev();
extern void _ZN10S1379C3_nt4v147Ev();
extern void _ZN10S1379C3_nt4v148Ev();
extern void _ZN10S1379C3_nt4v149Ev();
extern void _ZN10S1379C3_nt4v150Ev();
extern void _ZN10S1379C3_nt4v151Ev();
extern void _ZN10S1379C3_nt4v152Ev();
extern void _ZN10S1379C3_nt4v153Ev();
extern void _ZN10S1379C3_nt4v154Ev();
extern void _ZN10S1379C3_nt4v155Ev();
extern void _ZN10S1379C3_nt4v156Ev();
extern void _ZN10S1379C3_nt4v157Ev();
extern void _ZN10S1379C3_nt4v158Ev();
extern void _ZN10S1379C3_nt4v159Ev();
extern void _ZN10S1379C3_nt4v160Ev();
extern void _ZN10S1379C3_nt4v161Ev();
extern void _ZN10S1379C3_nt4v162Ev();
extern void _ZN10S1379C3_nt4v163Ev();
extern void _ZN10S1379C3_nt4v164Ev();
extern void _ZN10S1379C3_nt4v165Ev();
extern void _ZN10S1379C3_nt4v166Ev();
extern void _ZN10S1379C3_nt4v167Ev();
extern void _ZN10S1379C3_nt4v168Ev();
extern void _ZN10S1379C3_nt4v169Ev();
extern void _ZN10S1379C3_nt4v170Ev();
extern void _ZN10S1379C3_nt4v171Ev();
extern void _ZN10S1379C3_nt4v172Ev();
extern void _ZN10S1379C3_nt4v173Ev();
extern void _ZN10S1379C3_nt4v174Ev();
extern void _ZN10S1379C3_nt4v175Ev();
extern void _ZN10S1379C3_nt4v176Ev();
extern void _ZN10S1379C3_nt4v177Ev();
extern void _ZN10S1379C3_nt4v178Ev();
extern void _ZN10S1379C3_nt4v179Ev();
extern void _ZN10S1379C3_nt4v180Ev();
extern void _ZN10S1379C3_nt4v181Ev();
extern void _ZN10S1379C3_nt4v182Ev();
extern void _ZN10S1379C3_nt4v183Ev();
extern void _ZN10S1379C3_nt4v184Ev();
extern void _ZN10S1379C3_nt4v185Ev();
extern void _ZN10S1379C3_nt4v186Ev();
extern void _ZN10S1379C3_nt4v187Ev();
extern void _ZN10S1379C3_nt4v188Ev();
extern void _ZN10S1379C3_nt4v189Ev();
extern void _ZN10S1379C3_nt4v190Ev();
extern void _ZN10S1379C3_nt4v191Ev();
extern void _ZN10S1379C3_nt4v192Ev();
extern void _ZN10S1379C3_nt4v193Ev();
extern void _ZN10S1379C3_nt4v194Ev();
extern void _ZN10S1379C3_nt4v195Ev();
extern void _ZN10S1379C3_nt4v196Ev();
extern void _ZN10S1379C3_nt4v197Ev();
extern void _ZN10S1379C3_nt4v198Ev();
extern void _ZN10S1379C3_nt4v199Ev();
extern void _ZN10S1379C3_nt4v200Ev();
extern void _ZN10S1379C3_nt4v201Ev();
extern void _ZN10S1379C3_nt4v202Ev();
extern void _ZN10S1379C3_nt4v203Ev();
extern void _ZN10S1379C3_nt4v204Ev();
extern void _ZN10S1379C3_nt4v205Ev();
extern void _ZN10S1379C3_nt4v206Ev();
extern void _ZN10S1379C3_nt4v207Ev();
extern void _ZN10S1379C3_nt4v208Ev();
extern void _ZN10S1379C3_nt4v209Ev();
extern void _ZN10S1379C2_nt4v210Ev();
extern void _ZN10S1379C2_nt4v211Ev();
extern void _ZN7S1379C12v1Ev();
extern void _ZN7S1379C12v2Ev();
static  VTBL_ENTRY vtc_S1379C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1379C1[0]),
  (VTBL_ENTRY)&_ZN7S1379C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1379C1D0Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1379C4_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v148Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v149Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v150Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v151Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v152Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v153Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v154Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v155Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v156Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v157Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v158Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v159Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v160Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v161Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v162Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v163Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v164Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v165Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v166Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v167Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v168Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v169Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v170Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v171Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v172Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v173Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v174Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v175Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v176Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v177Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v178Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v179Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v180Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v181Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v182Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v183Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v184Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v185Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v186Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v187Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v188Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v189Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v190Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v191Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v192Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v193Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v194Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v195Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v196Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v197Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v198Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v199Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v200Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v201Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v202Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v203Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v204Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v205Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v206Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v207Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v208Ev,
  (VTBL_ENTRY)&_ZN10S1379C3_nt4v209Ev,
  (VTBL_ENTRY)&_ZN10S1379C2_nt4v210Ev,
  (VTBL_ENTRY)&_ZN10S1379C2_nt4v211Ev,
  (VTBL_ENTRY)&_ZN7S1379C12v1Ev,
  (VTBL_ENTRY)&_ZN7S1379C12v2Ev,
};
extern VTBL_ENTRY _ZTI7S1379C1[];
extern  VTBL_ENTRY _ZTV7S1379C1[];
Class_Descriptor cd_S1379C1 = {  "S1379C1", // class name
  bases_S1379C1, 3,
  &(vtc_S1379C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(568,436), // object size
  NSPAIRA(_ZTI7S1379C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1379C1),215, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C7_nt  {
  void  mf1990c7(); // _ZN10S1990C7_nt8mf1990c7Ev
};
//SIG(-1 S1990C7_nt) C1{ m}


void  S1990C7_nt ::mf1990c7(){}

//skip512 S1990C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C6_nt  {
  void *s1990c6f0;
  int s1990c6f1;
  ::S1990C7_nt s1990c6f2;
  ::S1990C7_nt s1990c6f3;
  void  mf1990c6(); // _ZN10S1990C6_nt8mf1990c6Ev
};
//SIG(-1 S1990C6_nt) C1{ m Fp Fi FC2{ m} FC2}


void  S1990C6_nt ::mf1990c6(){}

//skip512 S1990C6_nt

#else // __cplusplus

Class_Descriptor cd_S1990C6_nt = {  "S1990C6_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C5_nt  : S1990C6_nt {
};
//SIG(-1 S1990C5_nt) C1{ BC2{ m Fp Fi FC3{ m} FC3}}



//skip512 S1990C5_nt

#else // __cplusplus

extern Class_Descriptor cd_S1990C6_nt;
static Base_Class bases_S1990C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1990C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C4_nt  {
  void *s1990c4f0;
  int s1990c4f1;
  ::S1990C5_nt s1990c4f2;
  ::S1990C5_nt s1990c4f3;
  int s1990c4f4;
  virtual  ~S1990C4_nt(); // _ZN10S1990C4_ntD1Ev
  virtual void  v1(); // _ZN10S1990C4_nt2v1Ev
  virtual void  v2(); // _ZN10S1990C4_nt2v2Ev
  virtual void  v3(); // _ZN10S1990C4_nt2v3Ev
  virtual void  v4(); // _ZN10S1990C4_nt2v4Ev
  virtual void  v5(); // _ZN10S1990C4_nt2v5Ev
  virtual void  v6(); // _ZN10S1990C4_nt2v6Ev
  virtual void  v7(); // _ZN10S1990C4_nt2v7Ev
  virtual void  v8(); // _ZN10S1990C4_nt2v8Ev
  virtual void  v9(); // _ZN10S1990C4_nt2v9Ev
  virtual void  v10(); // _ZN10S1990C4_nt3v10Ev
  virtual void  v11(); // _ZN10S1990C4_nt3v11Ev
  virtual void  v12(); // _ZN10S1990C4_nt3v12Ev
  virtual void  v13(); // _ZN10S1990C4_nt3v13Ev
  virtual void  v14(); // _ZN10S1990C4_nt3v14Ev
  virtual void  v15(); // _ZN10S1990C4_nt3v15Ev
  virtual void  v16(); // _ZN10S1990C4_nt3v16Ev
  virtual void  v17(); // _ZN10S1990C4_nt3v17Ev
  virtual void  v18(); // _ZN10S1990C4_nt3v18Ev
  virtual void  v19(); // _ZN10S1990C4_nt3v19Ev
  virtual void  v20(); // _ZN10S1990C4_nt3v20Ev
  virtual void  v21(); // _ZN10S1990C4_nt3v21Ev
  virtual void  v22(); // _ZN10S1990C4_nt3v22Ev
  virtual void  v23(); // _ZN10S1990C4_nt3v23Ev
  S1990C4_nt(); // tgen
};
//SIG(-1 S1990C4_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC2{ BC3{ m Fp Fi FC4{ m} FC4}} FC2 Fi}


 S1990C4_nt ::~S1990C4_nt(){ note_dtor("S1990C4_nt", this);}
void  S1990C4_nt ::v1(){vfunc_called(this, "_ZN10S1990C4_nt2v1Ev");}
void  S1990C4_nt ::v2(){vfunc_called(this, "_ZN10S1990C4_nt2v2Ev");}
void  S1990C4_nt ::v3(){vfunc_called(this, "_ZN10S1990C4_nt2v3Ev");}
void  S1990C4_nt ::v4(){vfunc_called(this, "_ZN10S1990C4_nt2v4Ev");}
void  S1990C4_nt ::v5(){vfunc_called(this, "_ZN10S1990C4_nt2v5Ev");}
void  S1990C4_nt ::v6(){vfunc_called(this, "_ZN10S1990C4_nt2v6Ev");}
void  S1990C4_nt ::v7(){vfunc_called(this, "_ZN10S1990C4_nt2v7Ev");}
void  S1990C4_nt ::v8(){vfunc_called(this, "_ZN10S1990C4_nt2v8Ev");}
void  S1990C4_nt ::v9(){vfunc_called(this, "_ZN10S1990C4_nt2v9Ev");}
void  S1990C4_nt ::v10(){vfunc_called(this, "_ZN10S1990C4_nt3v10Ev");}
void  S1990C4_nt ::v11(){vfunc_called(this, "_ZN10S1990C4_nt3v11Ev");}
void  S1990C4_nt ::v12(){vfunc_called(this, "_ZN10S1990C4_nt3v12Ev");}
void  S1990C4_nt ::v13(){vfunc_called(this, "_ZN10S1990C4_nt3v13Ev");}
void  S1990C4_nt ::v14(){vfunc_called(this, "_ZN10S1990C4_nt3v14Ev");}
void  S1990C4_nt ::v15(){vfunc_called(this, "_ZN10S1990C4_nt3v15Ev");}
void  S1990C4_nt ::v16(){vfunc_called(this, "_ZN10S1990C4_nt3v16Ev");}
void  S1990C4_nt ::v17(){vfunc_called(this, "_ZN10S1990C4_nt3v17Ev");}
void  S1990C4_nt ::v18(){vfunc_called(this, "_ZN10S1990C4_nt3v18Ev");}
void  S1990C4_nt ::v19(){vfunc_called(this, "_ZN10S1990C4_nt3v19Ev");}
void  S1990C4_nt ::v20(){vfunc_called(this, "_ZN10S1990C4_nt3v20Ev");}
void  S1990C4_nt ::v21(){vfunc_called(this, "_ZN10S1990C4_nt3v21Ev");}
void  S1990C4_nt ::v22(){vfunc_called(this, "_ZN10S1990C4_nt3v22Ev");}
void  S1990C4_nt ::v23(){vfunc_called(this, "_ZN10S1990C4_nt3v23Ev");}
S1990C4_nt ::S1990C4_nt(){ note_ctor("S1990C4_nt", this);} // tgen

//skip512 S1990C4_nt

#else // __cplusplus

extern void _ZN10S1990C4_ntC1Ev();
extern void _ZN10S1990C4_ntD1Ev();
Name_Map name_map_S1990C4_nt[] = {
  NSPAIR(_ZN10S1990C4_ntC1Ev),
  NSPAIR(_ZN10S1990C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S1990C4_nt[];
extern void _ZN10S1990C4_ntD1Ev();
extern void _ZN10S1990C4_ntD0Ev();
extern void _ZN10S1990C4_nt2v1Ev();
extern void _ZN10S1990C4_nt2v2Ev();
extern void _ZN10S1990C4_nt2v3Ev();
extern void _ZN10S1990C4_nt2v4Ev();
extern void _ZN10S1990C4_nt2v5Ev();
extern void _ZN10S1990C4_nt2v6Ev();
extern void _ZN10S1990C4_nt2v7Ev();
extern void _ZN10S1990C4_nt2v8Ev();
extern void _ZN10S1990C4_nt2v9Ev();
extern void _ZN10S1990C4_nt3v10Ev();
extern void _ZN10S1990C4_nt3v11Ev();
extern void _ZN10S1990C4_nt3v12Ev();
extern void _ZN10S1990C4_nt3v13Ev();
extern void _ZN10S1990C4_nt3v14Ev();
extern void _ZN10S1990C4_nt3v15Ev();
extern void _ZN10S1990C4_nt3v16Ev();
extern void _ZN10S1990C4_nt3v17Ev();
extern void _ZN10S1990C4_nt3v18Ev();
extern void _ZN10S1990C4_nt3v19Ev();
extern void _ZN10S1990C4_nt3v20Ev();
extern void _ZN10S1990C4_nt3v21Ev();
extern void _ZN10S1990C4_nt3v22Ev();
extern void _ZN10S1990C4_nt3v23Ev();
static  VTBL_ENTRY vtc_S1990C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1990C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S1990C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v1Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v2Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v23Ev,
};
extern VTBL_ENTRY _ZTI10S1990C4_nt[];
VTBL_ENTRY *P__ZTI10S1990C4_nt = _ZTI10S1990C4_nt; 
extern  VTBL_ENTRY _ZTV10S1990C4_nt[];
Class_Descriptor cd_S1990C4_nt = {  "S1990C4_nt", // class name
  0,0,//no base classes
  &(vtc_S1990C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI10S1990C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S1990C4_nt),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C14_nt  {
  __tsi64 s1990c14f0[2];
  void  mf1990c14(); // _ZN11S1990C14_nt9mf1990c14Ev
};
//SIG(-1 S1990C14_nt) C1{ m FL[2]}


void  S1990C14_nt ::mf1990c14(){}

//skip512 S1990C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C13_nt  {
  ::S1990C14_nt s1990c13f0;
  void  mf1990c13(); // _ZN11S1990C13_nt9mf1990c13Ev
};
//SIG(-1 S1990C13_nt) C1{ m FC2{ m FL[2]}}


void  S1990C13_nt ::mf1990c13(){}

//skip512 S1990C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C17_nt  {
  ::S1990C13_nt s1990c17f0;
  void  mf1990c17(); // _ZN11S1990C17_nt9mf1990c17Ev
};
//SIG(-1 S1990C17_nt) C1{ m FC2{ m FC3{ m FL[2]}}}


void  S1990C17_nt ::mf1990c17(){}

//skip512 S1990C17_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C18_nt  {
  ::S1990C13_nt s1990c18f0;
  ::S1990C13_nt s1990c18f1;
  ::S1990C13_nt s1990c18f2;
  ::S1990C13_nt s1990c18f3;
  void  mf1990c18(); // _ZN11S1990C18_nt9mf1990c18Ev
};
//SIG(-1 S1990C18_nt) C1{ m FC2{ m FC3{ m FL[2]}} FC2 FC2 FC2}


void  S1990C18_nt ::mf1990c18(){}

//skip512 S1990C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C21  {
  void  mf1990c21(); // _ZN8S1990C219mf1990c21Ev
};
//SIG(-1 S1990C21) C1{ m}


void  S1990C21 ::mf1990c21(){}

static void Test_S1990C21()
{
  {
    init_simple_test("S1990C21");
    S1990C21 lv;
    check2(sizeof(lv), 1, "sizeof(S1990C21)");
    check2(__alignof__(lv), 1, "__alignof__(S1990C21)");
  }
}
static Arrange_To_Call_Me vS1990C21(Test_S1990C21, "S1990C21", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C20_nt  {
  void *s1990c20f0;
  int s1990c20f1;
  ::S1990C21 s1990c20f2;
  void  mf1990c20(); // _ZN11S1990C20_nt9mf1990c20Ev
};
//SIG(-1 S1990C20_nt) C1{ m Fp Fi FC2{ m}}


void  S1990C20_nt ::mf1990c20(){}

//skip512 S1990C20_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C19_nt  {
  ::S1990C20_nt s1990c19f0;
  int s1990c19f1;
  void  mf1990c19(); // _ZN11S1990C19_nt9mf1990c19Ev
};
//SIG(-1 S1990C19_nt) C1{ m FC2{ m Fp Fi FC3{ m}} Fi}


void  S1990C19_nt ::mf1990c19(){}

//skip512 S1990C19_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C24  {
  void  mf1990c24(); // _ZN8S1990C249mf1990c24Ev
};
//SIG(-1 S1990C24) C1{ m}


void  S1990C24 ::mf1990c24(){}

static void Test_S1990C24()
{
  {
    init_simple_test("S1990C24");
    S1990C24 lv;
    check2(sizeof(lv), 1, "sizeof(S1990C24)");
    check2(__alignof__(lv), 1, "__alignof__(S1990C24)");
  }
}
static Arrange_To_Call_Me vS1990C24(Test_S1990C24, "S1990C24", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C22  {
  void *s1990c22f0;
  int s1990c22f1;
  ::S1990C21 s1990c22f2;
  ::S1990C24 s1990c22f3;
  void  mf1990c22(); // _ZN8S1990C229mf1990c22Ev
};
//SIG(-1 S1990C22) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S1990C22 ::mf1990c22(){}

static void Test_S1990C22()
{
  {
    init_simple_test("S1990C22");
    S1990C22 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1990C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1990C22)");
    check_field_offset(lv, s1990c22f0, 0, "S1990C22.s1990c22f0");
    check_field_offset(lv, s1990c22f1, ABISELECT(8,4), "S1990C22.s1990c22f1");
    check_field_offset(lv, s1990c22f2, ABISELECT(12,8), "S1990C22.s1990c22f2");
    check_field_offset(lv, s1990c22f3, ABISELECT(13,9), "S1990C22.s1990c22f3");
  }
}
static Arrange_To_Call_Me vS1990C22(Test_S1990C22, "S1990C22", ABISELECT(16,12));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C28  {
  void  mf1990c28(); // _ZN8S1990C289mf1990c28Ev
};
//SIG(-1 S1990C28) C1{ m}


void  S1990C28 ::mf1990c28(){}

static void Test_S1990C28()
{
  {
    init_simple_test("S1990C28");
    S1990C28 lv;
    check2(sizeof(lv), 1, "sizeof(S1990C28)");
    check2(__alignof__(lv), 1, "__alignof__(S1990C28)");
  }
}
static Arrange_To_Call_Me vS1990C28(Test_S1990C28, "S1990C28", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C26  {
  void *s1990c26f0;
  int s1990c26f1;
  ::S1990C24 s1990c26f2;
  ::S1990C28 s1990c26f3;
  void  mf1990c26(); // _ZN8S1990C269mf1990c26Ev
};
//SIG(-1 S1990C26) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S1990C26 ::mf1990c26(){}

static void Test_S1990C26()
{
  {
    init_simple_test("S1990C26");
    S1990C26 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1990C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1990C26)");
    check_field_offset(lv, s1990c26f0, 0, "S1990C26.s1990c26f0");
    check_field_offset(lv, s1990c26f1, ABISELECT(8,4), "S1990C26.s1990c26f1");
    check_field_offset(lv, s1990c26f2, ABISELECT(12,8), "S1990C26.s1990c26f2");
    check_field_offset(lv, s1990c26f3, ABISELECT(13,9), "S1990C26.s1990c26f3");
  }
}
static Arrange_To_Call_Me vS1990C26(Test_S1990C26, "S1990C26", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S1990C26 = {  "S1990C26", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C25  : S1990C26 {
};
//SIG(-1 S1990C25) C1{ BC2{ m Fp Fi FC3{ m} FC4{ m}}}



static void Test_S1990C25()
{
  extern Class_Descriptor cd_S1990C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1990C25, buf);
    S1990C25 &lv = *(new (buf) S1990C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1990C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1990C25)");
    check_base_class_offset(lv, (S1990C26*), 0, "S1990C25");
    test_class_info(&lv, &cd_S1990C25);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1990C25(Test_S1990C25, "S1990C25", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1990C26;
static Base_Class bases_S1990C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1990C26,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1990C25 = {  "S1990C25", // class name
  bases_S1990C25, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C29_nt  {
  void *s1990c29f0;
  int s1990c29f1[2];
  ::S1990C28 s1990c29f2;
  void  mf1990c29(); // _ZN11S1990C29_nt9mf1990c29Ev
};
//SIG(-1 S1990C29_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S1990C29_nt ::mf1990c29(){}

//skip512 S1990C29_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C38  {
  void  mf1990c38(); // _ZN8S1990C389mf1990c38Ev
};
//SIG(-1 S1990C38) C1{ m}


void  S1990C38 ::mf1990c38(){}

static void Test_S1990C38()
{
  {
    init_simple_test("S1990C38");
    S1990C38 lv;
    check2(sizeof(lv), 1, "sizeof(S1990C38)");
    check2(__alignof__(lv), 1, "__alignof__(S1990C38)");
  }
}
static Arrange_To_Call_Me vS1990C38(Test_S1990C38, "S1990C38", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S1990C38[];
VTBL_ENTRY *P__ZTI8S1990C38 = _ZTI8S1990C38; 
Class_Descriptor cd_S1990C38 = {  "S1990C38", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S1990C38),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C37  {
  void *s1990c37f0;
  int s1990c37f1[2];
  ::S1990C38 s1990c37f2;
  void  mf1990c37(); // _ZN8S1990C379mf1990c37Ev
};
//SIG(-1 S1990C37) C1{ m Fp Fi[2] FC2{ m}}


void  S1990C37 ::mf1990c37(){}

static void Test_S1990C37()
{
  {
    init_simple_test("S1990C37");
    S1990C37 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S1990C37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1990C37)");
    check_field_offset(lv, s1990c37f0, 0, "S1990C37.s1990c37f0");
    check_field_offset(lv, s1990c37f1, ABISELECT(8,4), "S1990C37.s1990c37f1");
    check_field_offset(lv, s1990c37f2, ABISELECT(16,12), "S1990C37.s1990c37f2");
  }
}
static Arrange_To_Call_Me vS1990C37(Test_S1990C37, "S1990C37", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C3_nt  : S1990C4_nt {
  ::S1990C13_nt s1990c3f0;
  ::S1990C13_nt s1990c3f1;
  ::S1990C13_nt s1990c3f2;
  ::S1990C13_nt s1990c3f3;
  ::S1990C17_nt s1990c3f4;
  ::S1990C18_nt s1990c3f5;
  ::S1990C18_nt s1990c3f6;
  ::S1990C13_nt s1990c3f7;
  ::S1990C13_nt s1990c3f8;
  ::S1990C13_nt s1990c3f9;
  void *s1990c3f10;
  ::S1990C17_nt s1990c3f11;
  ::S1990C19_nt s1990c3f12;
  int s1990c3f13;
  void *s1990c3f14[7];
  ::S1990C22 s1990c3f15;
  int s1990c3f16:8;
  int s1990c3f17:8;
  int s1990c3f18:16;
  int s1990c3f19:16;
  int s1990c3f20:8;
  int s1990c3f21:8;
  int s1990c3f22:8;
  int s1990c3f23:32;
  int s1990c3f24:8;
  int s1990c3f25:4;
  int s1990c3f26:4;
  int s1990c3f27:4;
  int s1990c3f28:4;
  int s1990c3f29:4;
  int s1990c3f30:4;
  int s1990c3f31:4;
  int s1990c3f32:4;
  int s1990c3f33:4;
  int s1990c3f34:4;
  unsigned char s1990c3f35:1;
  unsigned char s1990c3f36:1;
  unsigned char s1990c3f37:1;
  unsigned char s1990c3f38:1;
  unsigned char s1990c3f39:1;
  unsigned char s1990c3f40:1;
  unsigned char s1990c3f41:1;
  unsigned char s1990c3f42:1;
  unsigned char s1990c3f43:1;
  unsigned char s1990c3f44:1;
  unsigned char s1990c3f45:1;
  unsigned char s1990c3f46:1;
  unsigned char s1990c3f47:1;
  unsigned char s1990c3f48:1;
  unsigned char s1990c3f49:1;
  unsigned char s1990c3f50:1;
  unsigned char s1990c3f51:1;
  unsigned char s1990c3f52:1;
  unsigned char s1990c3f53:1;
  unsigned char s1990c3f54:1;
  unsigned char s1990c3f55:1;
  unsigned char s1990c3f56:1;
  unsigned char s1990c3f57:1;
  unsigned char s1990c3f58:1;
  unsigned char s1990c3f59:1;
  unsigned char s1990c3f60:1;
  unsigned char s1990c3f61:1;
  unsigned char s1990c3f62:1;
  unsigned char s1990c3f63:1;
  unsigned char s1990c3f64:1;
  unsigned char s1990c3f65:1;
  unsigned char s1990c3f66:1;
  unsigned char s1990c3f67:1;
  unsigned char s1990c3f68:1;
  unsigned char s1990c3f69:1;
  unsigned char s1990c3f70:1;
  unsigned char s1990c3f71:1;
  unsigned char s1990c3f72:1;
  unsigned char s1990c3f73:1;
  unsigned char s1990c3f74:1;
  unsigned char s1990c3f75:1;
  int s1990c3f76[7];
  void *s1990c3f77[6];
  int s1990c3f78:8;
  int s1990c3f79:8;
  int s1990c3f80:8;
  int s1990c3f81:8;
  int s1990c3f82:8;
  int s1990c3f83:8;
  ::S1990C25 s1990c3f84;
  void *s1990c3f85[4];
  int s1990c3f86:8;
  int s1990c3f87:8;
  int s1990c3f88:8;
  int s1990c3f89:8;
  int s1990c3f90:8;
  int s1990c3f91:16;
  int s1990c3f92:16;
  int s1990c3f93:16;
  int s1990c3f94:4;
  int s1990c3f95:4;
  int s1990c3f96:4;
  int s1990c3f97:4;
  int s1990c3f98:4;
  int s1990c3f99:4;
  int s1990c3f100:4;
  int s1990c3f101:4;
  int s1990c3f102:4;
  int s1990c3f103:4;
  int s1990c3f104:4;
  int s1990c3f105:4;
  int s1990c3f106:8;
  int s1990c3f107:8;
  int s1990c3f108:8;
  void *s1990c3f109[7];
  ::S1990C29_nt s1990c3f110;
  void *s1990c3f111[2];
  int s1990c3f112:16;
  int s1990c3f113:16;
  ::S1990C25 s1990c3f114;
  ::S1990C29_nt s1990c3f115;
  ::S1990C37 s1990c3f116;
  void *s1990c3f117[2];
  int s1990c3f118:24;
  int s1990c3f119:8;
  void *s1990c3f120;
  virtual  ~S1990C3_nt(); // _ZN10S1990C3_ntD1Ev
  virtual void  v24(); // _ZN10S1990C3_nt3v24Ev
  virtual void  v25(); // _ZN10S1990C3_nt3v25Ev
  virtual void  v26(); // _ZN10S1990C3_nt3v26Ev
  virtual void  v27(); // _ZN10S1990C3_nt3v27Ev
  virtual void  v28(); // _ZN10S1990C3_nt3v28Ev
  virtual void  v29(); // _ZN10S1990C3_nt3v29Ev
  virtual void  v30(); // _ZN10S1990C3_nt3v30Ev
  virtual void  v31(); // _ZN10S1990C3_nt3v31Ev
  virtual void  v32(); // _ZN10S1990C3_nt3v32Ev
  virtual void  v33(); // _ZN10S1990C3_nt3v33Ev
  virtual void  v34(); // _ZN10S1990C3_nt3v34Ev
  virtual void  v35(); // _ZN10S1990C3_nt3v35Ev
  virtual void  v36(); // _ZN10S1990C3_nt3v36Ev
  virtual void  v37(); // _ZN10S1990C3_nt3v37Ev
  virtual void  v38(); // _ZN10S1990C3_nt3v38Ev
  virtual void  v39(); // _ZN10S1990C3_nt3v39Ev
  virtual void  v40(); // _ZN10S1990C3_nt3v40Ev
  virtual void  v41(); // _ZN10S1990C3_nt3v41Ev
  virtual void  v42(); // _ZN10S1990C3_nt3v42Ev
  virtual void  v43(); // _ZN10S1990C3_nt3v43Ev
  virtual void  v44(); // _ZN10S1990C3_nt3v44Ev
  virtual void  v45(); // _ZN10S1990C3_nt3v45Ev
  virtual void  v46(); // _ZN10S1990C3_nt3v46Ev
  virtual void  v47(); // _ZN10S1990C3_nt3v47Ev
  virtual void  v48(); // _ZN10S1990C3_nt3v48Ev
  virtual void  v49(); // _ZN10S1990C3_nt3v49Ev
  virtual void  v50(); // _ZN10S1990C3_nt3v50Ev
  virtual void  v51(); // _ZN10S1990C3_nt3v51Ev
  virtual void  v52(); // _ZN10S1990C3_nt3v52Ev
  virtual void  v53(); // _ZN10S1990C3_nt3v53Ev
  virtual void  v54(); // _ZN10S1990C3_nt3v54Ev
  virtual void  v55(); // _ZN10S1990C3_nt3v55Ev
  virtual void  v56(); // _ZN10S1990C3_nt3v56Ev
  virtual void  v57(); // _ZN10S1990C3_nt3v57Ev
  virtual void  v58(); // _ZN10S1990C3_nt3v58Ev
  virtual void  v59(); // _ZN10S1990C3_nt3v59Ev
  virtual void  v60(); // _ZN10S1990C3_nt3v60Ev
  virtual void  v61(); // _ZN10S1990C3_nt3v61Ev
  virtual void  v62(); // _ZN10S1990C3_nt3v62Ev
  virtual void  v63(); // _ZN10S1990C3_nt3v63Ev
  virtual void  v64(); // _ZN10S1990C3_nt3v64Ev
  virtual void  v65(); // _ZN10S1990C3_nt3v65Ev
  virtual void  v66(); // _ZN10S1990C3_nt3v66Ev
  virtual void  v67(); // _ZN10S1990C3_nt3v67Ev
  virtual void  v68(); // _ZN10S1990C3_nt3v68Ev
  virtual void  v69(); // _ZN10S1990C3_nt3v69Ev
  virtual void  v70(); // _ZN10S1990C3_nt3v70Ev
  virtual void  v71(); // _ZN10S1990C3_nt3v71Ev
  virtual void  v72(); // _ZN10S1990C3_nt3v72Ev
  virtual void  v73(); // _ZN10S1990C3_nt3v73Ev
  virtual void  v74(); // _ZN10S1990C3_nt3v74Ev
  virtual void  v75(); // _ZN10S1990C3_nt3v75Ev
  virtual void  v76(); // _ZN10S1990C3_nt3v76Ev
  virtual void  v77(); // _ZN10S1990C3_nt3v77Ev
  virtual void  v78(); // _ZN10S1990C3_nt3v78Ev
  virtual void  v79(); // _ZN10S1990C3_nt3v79Ev
  virtual void  v80(); // _ZN10S1990C3_nt3v80Ev
  virtual void  v81(); // _ZN10S1990C3_nt3v81Ev
  virtual void  v82(); // _ZN10S1990C3_nt3v82Ev
  virtual void  v83(); // _ZN10S1990C3_nt3v83Ev
  virtual void  v84(); // _ZN10S1990C3_nt3v84Ev
  virtual void  v85(); // _ZN10S1990C3_nt3v85Ev
  virtual void  v86(); // _ZN10S1990C3_nt3v86Ev
  virtual void  v87(); // _ZN10S1990C3_nt3v87Ev
  virtual void  v88(); // _ZN10S1990C3_nt3v88Ev
  virtual void  v89(); // _ZN10S1990C3_nt3v89Ev
  virtual void  v90(); // _ZN10S1990C3_nt3v90Ev
  virtual void  v91(); // _ZN10S1990C3_nt3v91Ev
  virtual void  v92(); // _ZN10S1990C3_nt3v92Ev
  virtual void  v93(); // _ZN10S1990C3_nt3v93Ev
  virtual void  v94(); // _ZN10S1990C3_nt3v94Ev
  virtual void  v95(); // _ZN10S1990C3_nt3v95Ev
  virtual void  v96(); // _ZN10S1990C3_nt3v96Ev
  virtual void  v97(); // _ZN10S1990C3_nt3v97Ev
  virtual void  v98(); // _ZN10S1990C3_nt3v98Ev
  virtual void  v99(); // _ZN10S1990C3_nt3v99Ev
  virtual void  v100(); // _ZN10S1990C3_nt4v100Ev
  virtual void  v101(); // _ZN10S1990C3_nt4v101Ev
  S1990C3_nt(); // tgen
};
//SIG(-1 S1990C3_nt) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fp Fi FC3{ BC4{ m Fp Fi FC5{ m} FC5}} FC3 Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 FC6{ m FC7{ m FL[2]}} FC6 FC6 FC6 FC8{ m FC6} FC9{ m FC6 FC6 FC6 FC6} FC9 FC6 FC6 FC6 Fp FC8 FC10{ m FC11{ m Fp Fi FC12{ m}} Fi} Fi Fp[7] FC13{ m Fp Fi FC12 FC14{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC15{ BC16{ m Fp Fi FC14 FC17{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC18{ m Fp Fi[2] FC17} Fp[2] Fi:16 Fi:16 FC15 FC18 FC19{ m Fp Fi[2] FC20{ m}} Fp[2] Fi:24 Fi:8 Fp}


 S1990C3_nt ::~S1990C3_nt(){ note_dtor("S1990C3_nt", this);}
void  S1990C3_nt ::v24(){vfunc_called(this, "_ZN10S1990C3_nt3v24Ev");}
void  S1990C3_nt ::v25(){vfunc_called(this, "_ZN10S1990C3_nt3v25Ev");}
void  S1990C3_nt ::v26(){vfunc_called(this, "_ZN10S1990C3_nt3v26Ev");}
void  S1990C3_nt ::v27(){vfunc_called(this, "_ZN10S1990C3_nt3v27Ev");}
void  S1990C3_nt ::v28(){vfunc_called(this, "_ZN10S1990C3_nt3v28Ev");}
void  S1990C3_nt ::v29(){vfunc_called(this, "_ZN10S1990C3_nt3v29Ev");}
void  S1990C3_nt ::v30(){vfunc_called(this, "_ZN10S1990C3_nt3v30Ev");}
void  S1990C3_nt ::v31(){vfunc_called(this, "_ZN10S1990C3_nt3v31Ev");}
void  S1990C3_nt ::v32(){vfunc_called(this, "_ZN10S1990C3_nt3v32Ev");}
void  S1990C3_nt ::v33(){vfunc_called(this, "_ZN10S1990C3_nt3v33Ev");}
void  S1990C3_nt ::v34(){vfunc_called(this, "_ZN10S1990C3_nt3v34Ev");}
void  S1990C3_nt ::v35(){vfunc_called(this, "_ZN10S1990C3_nt3v35Ev");}
void  S1990C3_nt ::v36(){vfunc_called(this, "_ZN10S1990C3_nt3v36Ev");}
void  S1990C3_nt ::v37(){vfunc_called(this, "_ZN10S1990C3_nt3v37Ev");}
void  S1990C3_nt ::v38(){vfunc_called(this, "_ZN10S1990C3_nt3v38Ev");}
void  S1990C3_nt ::v39(){vfunc_called(this, "_ZN10S1990C3_nt3v39Ev");}
void  S1990C3_nt ::v40(){vfunc_called(this, "_ZN10S1990C3_nt3v40Ev");}
void  S1990C3_nt ::v41(){vfunc_called(this, "_ZN10S1990C3_nt3v41Ev");}
void  S1990C3_nt ::v42(){vfunc_called(this, "_ZN10S1990C3_nt3v42Ev");}
void  S1990C3_nt ::v43(){vfunc_called(this, "_ZN10S1990C3_nt3v43Ev");}
void  S1990C3_nt ::v44(){vfunc_called(this, "_ZN10S1990C3_nt3v44Ev");}
void  S1990C3_nt ::v45(){vfunc_called(this, "_ZN10S1990C3_nt3v45Ev");}
void  S1990C3_nt ::v46(){vfunc_called(this, "_ZN10S1990C3_nt3v46Ev");}
void  S1990C3_nt ::v47(){vfunc_called(this, "_ZN10S1990C3_nt3v47Ev");}
void  S1990C3_nt ::v48(){vfunc_called(this, "_ZN10S1990C3_nt3v48Ev");}
void  S1990C3_nt ::v49(){vfunc_called(this, "_ZN10S1990C3_nt3v49Ev");}
void  S1990C3_nt ::v50(){vfunc_called(this, "_ZN10S1990C3_nt3v50Ev");}
void  S1990C3_nt ::v51(){vfunc_called(this, "_ZN10S1990C3_nt3v51Ev");}
void  S1990C3_nt ::v52(){vfunc_called(this, "_ZN10S1990C3_nt3v52Ev");}
void  S1990C3_nt ::v53(){vfunc_called(this, "_ZN10S1990C3_nt3v53Ev");}
void  S1990C3_nt ::v54(){vfunc_called(this, "_ZN10S1990C3_nt3v54Ev");}
void  S1990C3_nt ::v55(){vfunc_called(this, "_ZN10S1990C3_nt3v55Ev");}
void  S1990C3_nt ::v56(){vfunc_called(this, "_ZN10S1990C3_nt3v56Ev");}
void  S1990C3_nt ::v57(){vfunc_called(this, "_ZN10S1990C3_nt3v57Ev");}
void  S1990C3_nt ::v58(){vfunc_called(this, "_ZN10S1990C3_nt3v58Ev");}
void  S1990C3_nt ::v59(){vfunc_called(this, "_ZN10S1990C3_nt3v59Ev");}
void  S1990C3_nt ::v60(){vfunc_called(this, "_ZN10S1990C3_nt3v60Ev");}
void  S1990C3_nt ::v61(){vfunc_called(this, "_ZN10S1990C3_nt3v61Ev");}
void  S1990C3_nt ::v62(){vfunc_called(this, "_ZN10S1990C3_nt3v62Ev");}
void  S1990C3_nt ::v63(){vfunc_called(this, "_ZN10S1990C3_nt3v63Ev");}
void  S1990C3_nt ::v64(){vfunc_called(this, "_ZN10S1990C3_nt3v64Ev");}
void  S1990C3_nt ::v65(){vfunc_called(this, "_ZN10S1990C3_nt3v65Ev");}
void  S1990C3_nt ::v66(){vfunc_called(this, "_ZN10S1990C3_nt3v66Ev");}
void  S1990C3_nt ::v67(){vfunc_called(this, "_ZN10S1990C3_nt3v67Ev");}
void  S1990C3_nt ::v68(){vfunc_called(this, "_ZN10S1990C3_nt3v68Ev");}
void  S1990C3_nt ::v69(){vfunc_called(this, "_ZN10S1990C3_nt3v69Ev");}
void  S1990C3_nt ::v70(){vfunc_called(this, "_ZN10S1990C3_nt3v70Ev");}
void  S1990C3_nt ::v71(){vfunc_called(this, "_ZN10S1990C3_nt3v71Ev");}
void  S1990C3_nt ::v72(){vfunc_called(this, "_ZN10S1990C3_nt3v72Ev");}
void  S1990C3_nt ::v73(){vfunc_called(this, "_ZN10S1990C3_nt3v73Ev");}
void  S1990C3_nt ::v74(){vfunc_called(this, "_ZN10S1990C3_nt3v74Ev");}
void  S1990C3_nt ::v75(){vfunc_called(this, "_ZN10S1990C3_nt3v75Ev");}
void  S1990C3_nt ::v76(){vfunc_called(this, "_ZN10S1990C3_nt3v76Ev");}
void  S1990C3_nt ::v77(){vfunc_called(this, "_ZN10S1990C3_nt3v77Ev");}
void  S1990C3_nt ::v78(){vfunc_called(this, "_ZN10S1990C3_nt3v78Ev");}
void  S1990C3_nt ::v79(){vfunc_called(this, "_ZN10S1990C3_nt3v79Ev");}
void  S1990C3_nt ::v80(){vfunc_called(this, "_ZN10S1990C3_nt3v80Ev");}
void  S1990C3_nt ::v81(){vfunc_called(this, "_ZN10S1990C3_nt3v81Ev");}
void  S1990C3_nt ::v82(){vfunc_called(this, "_ZN10S1990C3_nt3v82Ev");}
void  S1990C3_nt ::v83(){vfunc_called(this, "_ZN10S1990C3_nt3v83Ev");}
void  S1990C3_nt ::v84(){vfunc_called(this, "_ZN10S1990C3_nt3v84Ev");}
void  S1990C3_nt ::v85(){vfunc_called(this, "_ZN10S1990C3_nt3v85Ev");}
void  S1990C3_nt ::v86(){vfunc_called(this, "_ZN10S1990C3_nt3v86Ev");}
void  S1990C3_nt ::v87(){vfunc_called(this, "_ZN10S1990C3_nt3v87Ev");}
void  S1990C3_nt ::v88(){vfunc_called(this, "_ZN10S1990C3_nt3v88Ev");}
void  S1990C3_nt ::v89(){vfunc_called(this, "_ZN10S1990C3_nt3v89Ev");}
void  S1990C3_nt ::v90(){vfunc_called(this, "_ZN10S1990C3_nt3v90Ev");}
void  S1990C3_nt ::v91(){vfunc_called(this, "_ZN10S1990C3_nt3v91Ev");}
void  S1990C3_nt ::v92(){vfunc_called(this, "_ZN10S1990C3_nt3v92Ev");}
void  S1990C3_nt ::v93(){vfunc_called(this, "_ZN10S1990C3_nt3v93Ev");}
void  S1990C3_nt ::v94(){vfunc_called(this, "_ZN10S1990C3_nt3v94Ev");}
void  S1990C3_nt ::v95(){vfunc_called(this, "_ZN10S1990C3_nt3v95Ev");}
void  S1990C3_nt ::v96(){vfunc_called(this, "_ZN10S1990C3_nt3v96Ev");}
void  S1990C3_nt ::v97(){vfunc_called(this, "_ZN10S1990C3_nt3v97Ev");}
void  S1990C3_nt ::v98(){vfunc_called(this, "_ZN10S1990C3_nt3v98Ev");}
void  S1990C3_nt ::v99(){vfunc_called(this, "_ZN10S1990C3_nt3v99Ev");}
void  S1990C3_nt ::v100(){vfunc_called(this, "_ZN10S1990C3_nt4v100Ev");}
void  S1990C3_nt ::v101(){vfunc_called(this, "_ZN10S1990C3_nt4v101Ev");}
S1990C3_nt ::S1990C3_nt(){ note_ctor("S1990C3_nt", this);} // tgen

//skip512 S1990C3_nt

#else // __cplusplus

extern void _ZN10S1990C3_ntC1Ev();
extern void _ZN10S1990C3_ntD1Ev();
Name_Map name_map_S1990C3_nt[] = {
  NSPAIR(_ZN10S1990C3_ntC1Ev),
  NSPAIR(_ZN10S1990C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1990C4_nt;
extern VTBL_ENTRY _ZTI10S1990C4_nt[];
extern  VTBL_ENTRY _ZTV10S1990C4_nt[];
static Base_Class bases_S1990C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1990C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S1990C3_nt[];
extern void _ZN10S1990C3_ntD1Ev();
extern void _ZN10S1990C3_ntD0Ev();
extern void _ZN10S1990C4_nt2v1Ev();
extern void _ZN10S1990C4_nt2v2Ev();
extern void _ZN10S1990C4_nt2v3Ev();
extern void _ZN10S1990C4_nt2v4Ev();
extern void _ZN10S1990C4_nt2v5Ev();
extern void _ZN10S1990C4_nt2v6Ev();
extern void _ZN10S1990C4_nt2v7Ev();
extern void _ZN10S1990C4_nt2v8Ev();
extern void _ZN10S1990C4_nt2v9Ev();
extern void _ZN10S1990C4_nt3v10Ev();
extern void _ZN10S1990C4_nt3v11Ev();
extern void _ZN10S1990C4_nt3v12Ev();
extern void _ZN10S1990C4_nt3v13Ev();
extern void _ZN10S1990C4_nt3v14Ev();
extern void _ZN10S1990C4_nt3v15Ev();
extern void _ZN10S1990C4_nt3v16Ev();
extern void _ZN10S1990C4_nt3v17Ev();
extern void _ZN10S1990C4_nt3v18Ev();
extern void _ZN10S1990C4_nt3v19Ev();
extern void _ZN10S1990C4_nt3v20Ev();
extern void _ZN10S1990C4_nt3v21Ev();
extern void _ZN10S1990C4_nt3v22Ev();
extern void _ZN10S1990C4_nt3v23Ev();
extern void _ZN10S1990C3_nt3v24Ev();
extern void _ZN10S1990C3_nt3v25Ev();
extern void _ZN10S1990C3_nt3v26Ev();
extern void _ZN10S1990C3_nt3v27Ev();
extern void _ZN10S1990C3_nt3v28Ev();
extern void _ZN10S1990C3_nt3v29Ev();
extern void _ZN10S1990C3_nt3v30Ev();
extern void _ZN10S1990C3_nt3v31Ev();
extern void _ZN10S1990C3_nt3v32Ev();
extern void _ZN10S1990C3_nt3v33Ev();
extern void _ZN10S1990C3_nt3v34Ev();
extern void _ZN10S1990C3_nt3v35Ev();
extern void _ZN10S1990C3_nt3v36Ev();
extern void _ZN10S1990C3_nt3v37Ev();
extern void _ZN10S1990C3_nt3v38Ev();
extern void _ZN10S1990C3_nt3v39Ev();
extern void _ZN10S1990C3_nt3v40Ev();
extern void _ZN10S1990C3_nt3v41Ev();
extern void _ZN10S1990C3_nt3v42Ev();
extern void _ZN10S1990C3_nt3v43Ev();
extern void _ZN10S1990C3_nt3v44Ev();
extern void _ZN10S1990C3_nt3v45Ev();
extern void _ZN10S1990C3_nt3v46Ev();
extern void _ZN10S1990C3_nt3v47Ev();
extern void _ZN10S1990C3_nt3v48Ev();
extern void _ZN10S1990C3_nt3v49Ev();
extern void _ZN10S1990C3_nt3v50Ev();
extern void _ZN10S1990C3_nt3v51Ev();
extern void _ZN10S1990C3_nt3v52Ev();
extern void _ZN10S1990C3_nt3v53Ev();
extern void _ZN10S1990C3_nt3v54Ev();
extern void _ZN10S1990C3_nt3v55Ev();
extern void _ZN10S1990C3_nt3v56Ev();
extern void _ZN10S1990C3_nt3v57Ev();
extern void _ZN10S1990C3_nt3v58Ev();
extern void _ZN10S1990C3_nt3v59Ev();
extern void _ZN10S1990C3_nt3v60Ev();
extern void _ZN10S1990C3_nt3v61Ev();
extern void _ZN10S1990C3_nt3v62Ev();
extern void _ZN10S1990C3_nt3v63Ev();
extern void _ZN10S1990C3_nt3v64Ev();
extern void _ZN10S1990C3_nt3v65Ev();
extern void _ZN10S1990C3_nt3v66Ev();
extern void _ZN10S1990C3_nt3v67Ev();
extern void _ZN10S1990C3_nt3v68Ev();
extern void _ZN10S1990C3_nt3v69Ev();
extern void _ZN10S1990C3_nt3v70Ev();
extern void _ZN10S1990C3_nt3v71Ev();
extern void _ZN10S1990C3_nt3v72Ev();
extern void _ZN10S1990C3_nt3v73Ev();
extern void _ZN10S1990C3_nt3v74Ev();
extern void _ZN10S1990C3_nt3v75Ev();
extern void _ZN10S1990C3_nt3v76Ev();
extern void _ZN10S1990C3_nt3v77Ev();
extern void _ZN10S1990C3_nt3v78Ev();
extern void _ZN10S1990C3_nt3v79Ev();
extern void _ZN10S1990C3_nt3v80Ev();
extern void _ZN10S1990C3_nt3v81Ev();
extern void _ZN10S1990C3_nt3v82Ev();
extern void _ZN10S1990C3_nt3v83Ev();
extern void _ZN10S1990C3_nt3v84Ev();
extern void _ZN10S1990C3_nt3v85Ev();
extern void _ZN10S1990C3_nt3v86Ev();
extern void _ZN10S1990C3_nt3v87Ev();
extern void _ZN10S1990C3_nt3v88Ev();
extern void _ZN10S1990C3_nt3v89Ev();
extern void _ZN10S1990C3_nt3v90Ev();
extern void _ZN10S1990C3_nt3v91Ev();
extern void _ZN10S1990C3_nt3v92Ev();
extern void _ZN10S1990C3_nt3v93Ev();
extern void _ZN10S1990C3_nt3v94Ev();
extern void _ZN10S1990C3_nt3v95Ev();
extern void _ZN10S1990C3_nt3v96Ev();
extern void _ZN10S1990C3_nt3v97Ev();
extern void _ZN10S1990C3_nt3v98Ev();
extern void _ZN10S1990C3_nt3v99Ev();
extern void _ZN10S1990C3_nt4v100Ev();
extern void _ZN10S1990C3_nt4v101Ev();
static  VTBL_ENTRY vtc_S1990C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S1990C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S1990C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v1Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v2Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt4v101Ev,
};
extern VTBL_ENTRY _ZTI10S1990C3_nt[];
VTBL_ENTRY *P__ZTI10S1990C3_nt = _ZTI10S1990C3_nt; 
extern  VTBL_ENTRY _ZTV10S1990C3_nt[];
Class_Descriptor cd_S1990C3_nt = {  "S1990C3_nt", // class name
  bases_S1990C3_nt, 1,
  &(vtc_S1990C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI10S1990C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S1990C3_nt),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C45  {
  void  mf1990c45(); // _ZN8S1990C459mf1990c45Ev
};
//SIG(-1 S1990C45) C1{ m}


void  S1990C45 ::mf1990c45(){}

static void Test_S1990C45()
{
  {
    init_simple_test("S1990C45");
    S1990C45 lv;
    check2(sizeof(lv), 1, "sizeof(S1990C45)");
    check2(__alignof__(lv), 1, "__alignof__(S1990C45)");
  }
}
static Arrange_To_Call_Me vS1990C45(Test_S1990C45, "S1990C45", 1);

#else // __cplusplus

extern VTBL_ENTRY _ZTI8S1990C45[];
VTBL_ENTRY *P__ZTI8S1990C45 = _ZTI8S1990C45; 
Class_Descriptor cd_S1990C45 = {  "S1990C45", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  NSPAIRA(_ZTI8S1990C45),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C43  {
  void *s1990c43f0;
  int s1990c43f1;
  ::S1990C38 s1990c43f2;
  ::S1990C45 s1990c43f3;
  void  mf1990c43(); // _ZN8S1990C439mf1990c43Ev
};
//SIG(-1 S1990C43) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S1990C43 ::mf1990c43(){}

static void Test_S1990C43()
{
  {
    init_simple_test("S1990C43");
    S1990C43 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1990C43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1990C43)");
    check_field_offset(lv, s1990c43f0, 0, "S1990C43.s1990c43f0");
    check_field_offset(lv, s1990c43f1, ABISELECT(8,4), "S1990C43.s1990c43f1");
    check_field_offset(lv, s1990c43f2, ABISELECT(12,8), "S1990C43.s1990c43f2");
    check_field_offset(lv, s1990c43f3, ABISELECT(13,9), "S1990C43.s1990c43f3");
  }
}
static Arrange_To_Call_Me vS1990C43(Test_S1990C43, "S1990C43", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S1990C43 = {  "S1990C43", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C42  : S1990C43 {
};
//SIG(-1 S1990C42) C1{ BC2{ m Fp Fi FC3{ m} FC4{ m}}}



static void Test_S1990C42()
{
  extern Class_Descriptor cd_S1990C42;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1990C42, buf);
    S1990C42 &lv = *(new (buf) S1990C42());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1990C42)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1990C42)");
    check_base_class_offset(lv, (S1990C43*), 0, "S1990C42");
    test_class_info(&lv, &cd_S1990C42);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1990C42(Test_S1990C42, "S1990C42", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1990C43;
static Base_Class bases_S1990C42[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1990C43,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1990C42 = {  "S1990C42", // class name
  bases_S1990C42, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C46  {
  void *s1990c46f0;
  int s1990c46f1[2];
  ::S1990C45 s1990c46f2;
  void  mf1990c46(); // _ZN8S1990C469mf1990c46Ev
};
//SIG(-1 S1990C46) C1{ m Fp Fi[2] FC2{ m}}


void  S1990C46 ::mf1990c46(){}

static void Test_S1990C46()
{
  {
    init_simple_test("S1990C46");
    S1990C46 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S1990C46)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1990C46)");
    check_field_offset(lv, s1990c46f0, 0, "S1990C46.s1990c46f0");
    check_field_offset(lv, s1990c46f1, ABISELECT(8,4), "S1990C46.s1990c46f1");
    check_field_offset(lv, s1990c46f2, ABISELECT(16,12), "S1990C46.s1990c46f2");
  }
}
static Arrange_To_Call_Me vS1990C46(Test_S1990C46, "S1990C46", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C39_nt  {
  ::S1990C37 s1990c39f0;
  ::S1990C42 s1990c39f1;
  ::S1990C46 s1990c39f2;
  ::S1990C42 s1990c39f3;
  void  mf1990c39(); // _ZN11S1990C39_nt9mf1990c39Ev
};
//SIG(-1 S1990C39_nt) C1{ m FC2{ m Fp Fi[2] FC3{ m}} FC4{ BC5{ m Fp Fi FC3 FC6{ m}}} FC7{ m Fp Fi[2] FC6} FC4}


void  S1990C39_nt ::mf1990c39(){}

//skip512 S1990C39_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C2  : S1990C3_nt {
  void *s1990c2f0;
  char s1990c2f1;
  ::S1990C39_nt s1990c2f2;
  ::S1990C19_nt s1990c2f3;
  virtual  ~S1990C2(); // _ZN7S1990C2D1Ev
  virtual void  v102(); // _ZN7S1990C24v102Ev
  virtual void  v103(); // _ZN7S1990C24v103Ev
  virtual void  v104(); // _ZN7S1990C24v104Ev
  virtual void  v105(); // _ZN7S1990C24v105Ev
  virtual void  v106(); // _ZN7S1990C24v106Ev
  virtual void  v107(); // _ZN7S1990C24v107Ev
  virtual void  v108(); // _ZN7S1990C24v108Ev
  virtual void  v109(); // _ZN7S1990C24v109Ev
  virtual void  v110(); // _ZN7S1990C24v110Ev
  S1990C2(); // tgen
};
//SIG(-1 S1990C2) C1{ BC2{ BC3{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 Fp Fi FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC4 Fi} vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 FC7{ m FC8{ m FL[2]}} FC7 FC7 FC7 FC9{ m FC7} FC10{ m FC7 FC7 FC7 FC7} FC10 FC7 FC7 FC7 Fp FC9 FC11{ m FC12{ m Fp Fi FC13{ m}} Fi} Fi Fp[7] FC14{ m Fp Fi FC13 FC15{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC16{ BC17{ m Fp Fi FC15 FC18{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC19{ m Fp Fi[2] FC18} Fp[2] Fi:16 Fi:16 FC16 FC19 FC20{ m Fp Fi[2] FC21{ m}} Fp[2] Fi:24 Fi:8 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fp Fc FC22{ m FC20 FC23{ BC24{ m Fp Fi FC21 FC25{ m}}} FC26{ m Fp Fi[2] FC25} FC23} FC11}


 S1990C2 ::~S1990C2(){ note_dtor("S1990C2", this);}
void  S1990C2 ::v102(){vfunc_called(this, "_ZN7S1990C24v102Ev");}
void  S1990C2 ::v103(){vfunc_called(this, "_ZN7S1990C24v103Ev");}
void  S1990C2 ::v104(){vfunc_called(this, "_ZN7S1990C24v104Ev");}
void  S1990C2 ::v105(){vfunc_called(this, "_ZN7S1990C24v105Ev");}
void  S1990C2 ::v106(){vfunc_called(this, "_ZN7S1990C24v106Ev");}
void  S1990C2 ::v107(){vfunc_called(this, "_ZN7S1990C24v107Ev");}
void  S1990C2 ::v108(){vfunc_called(this, "_ZN7S1990C24v108Ev");}
void  S1990C2 ::v109(){vfunc_called(this, "_ZN7S1990C24v109Ev");}
void  S1990C2 ::v110(){vfunc_called(this, "_ZN7S1990C24v110Ev");}
S1990C2 ::S1990C2(){ note_ctor("S1990C2", this);} // tgen

static void Test_S1990C2()
{
  extern Class_Descriptor cd_S1990C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(120,179)];
    init_test(&cd_S1990C2, buf);
    S1990C2 *dp, &lv = *(dp=new (buf) S1990C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(952,712), "sizeof(S1990C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1990C2)");
    check_base_class_offset(lv, (S1990C4_nt*)(S1990C3_nt*), 0, "S1990C2");
    check_base_class_offset(lv, (S1990C3_nt*), 0, "S1990C2");
    check_field_offset(lv, s1990c2f0, ABISELECT(832,632), "S1990C2.s1990c2f0");
    check_field_offset(lv, s1990c2f1, ABISELECT(840,636), "S1990C2.s1990c2f1");
    check_field_offset(lv, s1990c2f2, ABISELECT(848,640), "S1990C2.s1990c2f2");
    check_field_offset(lv, s1990c2f3, ABISELECT(928,696), "S1990C2.s1990c2f3");
    test_class_info(&lv, &cd_S1990C2);
    dp->~S1990C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1990C2(Test_S1990C2, "S1990C2", ABISELECT(952,712));

#else // __cplusplus

extern void _ZN7S1990C2C1Ev();
extern void _ZN7S1990C2D1Ev();
Name_Map name_map_S1990C2[] = {
  NSPAIR(_ZN7S1990C2C1Ev),
  NSPAIR(_ZN7S1990C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1990C4_nt;
extern VTBL_ENTRY _ZTI10S1990C4_nt[];
extern  VTBL_ENTRY _ZTV10S1990C4_nt[];
extern Class_Descriptor cd_S1990C3_nt;
extern VTBL_ENTRY _ZTI10S1990C3_nt[];
extern  VTBL_ENTRY _ZTV10S1990C3_nt[];
static Base_Class bases_S1990C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1990C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1990C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1990C2[];
extern void _ZN7S1990C2D1Ev();
extern void _ZN7S1990C2D0Ev();
extern void _ZN10S1990C4_nt2v1Ev();
extern void _ZN10S1990C4_nt2v2Ev();
extern void _ZN10S1990C4_nt2v3Ev();
extern void _ZN10S1990C4_nt2v4Ev();
extern void _ZN10S1990C4_nt2v5Ev();
extern void _ZN10S1990C4_nt2v6Ev();
extern void _ZN10S1990C4_nt2v7Ev();
extern void _ZN10S1990C4_nt2v8Ev();
extern void _ZN10S1990C4_nt2v9Ev();
extern void _ZN10S1990C4_nt3v10Ev();
extern void _ZN10S1990C4_nt3v11Ev();
extern void _ZN10S1990C4_nt3v12Ev();
extern void _ZN10S1990C4_nt3v13Ev();
extern void _ZN10S1990C4_nt3v14Ev();
extern void _ZN10S1990C4_nt3v15Ev();
extern void _ZN10S1990C4_nt3v16Ev();
extern void _ZN10S1990C4_nt3v17Ev();
extern void _ZN10S1990C4_nt3v18Ev();
extern void _ZN10S1990C4_nt3v19Ev();
extern void _ZN10S1990C4_nt3v20Ev();
extern void _ZN10S1990C4_nt3v21Ev();
extern void _ZN10S1990C4_nt3v22Ev();
extern void _ZN10S1990C4_nt3v23Ev();
extern void _ZN10S1990C3_nt3v24Ev();
extern void _ZN10S1990C3_nt3v25Ev();
extern void _ZN10S1990C3_nt3v26Ev();
extern void _ZN10S1990C3_nt3v27Ev();
extern void _ZN10S1990C3_nt3v28Ev();
extern void _ZN10S1990C3_nt3v29Ev();
extern void _ZN10S1990C3_nt3v30Ev();
extern void _ZN10S1990C3_nt3v31Ev();
extern void _ZN10S1990C3_nt3v32Ev();
extern void _ZN10S1990C3_nt3v33Ev();
extern void _ZN10S1990C3_nt3v34Ev();
extern void _ZN10S1990C3_nt3v35Ev();
extern void _ZN10S1990C3_nt3v36Ev();
extern void _ZN10S1990C3_nt3v37Ev();
extern void _ZN10S1990C3_nt3v38Ev();
extern void _ZN10S1990C3_nt3v39Ev();
extern void _ZN10S1990C3_nt3v40Ev();
extern void _ZN10S1990C3_nt3v41Ev();
extern void _ZN10S1990C3_nt3v42Ev();
extern void _ZN10S1990C3_nt3v43Ev();
extern void _ZN10S1990C3_nt3v44Ev();
extern void _ZN10S1990C3_nt3v45Ev();
extern void _ZN10S1990C3_nt3v46Ev();
extern void _ZN10S1990C3_nt3v47Ev();
extern void _ZN10S1990C3_nt3v48Ev();
extern void _ZN10S1990C3_nt3v49Ev();
extern void _ZN10S1990C3_nt3v50Ev();
extern void _ZN10S1990C3_nt3v51Ev();
extern void _ZN10S1990C3_nt3v52Ev();
extern void _ZN10S1990C3_nt3v53Ev();
extern void _ZN10S1990C3_nt3v54Ev();
extern void _ZN10S1990C3_nt3v55Ev();
extern void _ZN10S1990C3_nt3v56Ev();
extern void _ZN10S1990C3_nt3v57Ev();
extern void _ZN10S1990C3_nt3v58Ev();
extern void _ZN10S1990C3_nt3v59Ev();
extern void _ZN10S1990C3_nt3v60Ev();
extern void _ZN10S1990C3_nt3v61Ev();
extern void _ZN10S1990C3_nt3v62Ev();
extern void _ZN10S1990C3_nt3v63Ev();
extern void _ZN10S1990C3_nt3v64Ev();
extern void _ZN10S1990C3_nt3v65Ev();
extern void _ZN10S1990C3_nt3v66Ev();
extern void _ZN10S1990C3_nt3v67Ev();
extern void _ZN10S1990C3_nt3v68Ev();
extern void _ZN10S1990C3_nt3v69Ev();
extern void _ZN10S1990C3_nt3v70Ev();
extern void _ZN10S1990C3_nt3v71Ev();
extern void _ZN10S1990C3_nt3v72Ev();
extern void _ZN10S1990C3_nt3v73Ev();
extern void _ZN10S1990C3_nt3v74Ev();
extern void _ZN10S1990C3_nt3v75Ev();
extern void _ZN10S1990C3_nt3v76Ev();
extern void _ZN10S1990C3_nt3v77Ev();
extern void _ZN10S1990C3_nt3v78Ev();
extern void _ZN10S1990C3_nt3v79Ev();
extern void _ZN10S1990C3_nt3v80Ev();
extern void _ZN10S1990C3_nt3v81Ev();
extern void _ZN10S1990C3_nt3v82Ev();
extern void _ZN10S1990C3_nt3v83Ev();
extern void _ZN10S1990C3_nt3v84Ev();
extern void _ZN10S1990C3_nt3v85Ev();
extern void _ZN10S1990C3_nt3v86Ev();
extern void _ZN10S1990C3_nt3v87Ev();
extern void _ZN10S1990C3_nt3v88Ev();
extern void _ZN10S1990C3_nt3v89Ev();
extern void _ZN10S1990C3_nt3v90Ev();
extern void _ZN10S1990C3_nt3v91Ev();
extern void _ZN10S1990C3_nt3v92Ev();
extern void _ZN10S1990C3_nt3v93Ev();
extern void _ZN10S1990C3_nt3v94Ev();
extern void _ZN10S1990C3_nt3v95Ev();
extern void _ZN10S1990C3_nt3v96Ev();
extern void _ZN10S1990C3_nt3v97Ev();
extern void _ZN10S1990C3_nt3v98Ev();
extern void _ZN10S1990C3_nt3v99Ev();
extern void _ZN10S1990C3_nt4v100Ev();
extern void _ZN10S1990C3_nt4v101Ev();
extern void _ZN7S1990C24v102Ev();
extern void _ZN7S1990C24v103Ev();
extern void _ZN7S1990C24v104Ev();
extern void _ZN7S1990C24v105Ev();
extern void _ZN7S1990C24v106Ev();
extern void _ZN7S1990C24v107Ev();
extern void _ZN7S1990C24v108Ev();
extern void _ZN7S1990C24v109Ev();
extern void _ZN7S1990C24v110Ev();
static  VTBL_ENTRY vtc_S1990C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1990C2[0]),
  (VTBL_ENTRY)&_ZN7S1990C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1990C2D0Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v1Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v2Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN7S1990C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1990C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1990C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1990C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1990C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1990C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1990C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1990C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1990C24v110Ev,
};
extern VTBL_ENTRY _ZTI7S1990C2[];
extern  VTBL_ENTRY _ZTV7S1990C2[];
Class_Descriptor cd_S1990C2 = {  "S1990C2", // class name
  bases_S1990C2, 2,
  &(vtc_S1990C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(952,712), // object size
  NSPAIRA(_ZTI7S1990C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1990C2),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C52_nt  {
  void *s1990c52f0[2];
  void  mf1990c52(); // _ZN11S1990C52_nt9mf1990c52Ev
};
//SIG(-1 S1990C52_nt) C1{ m Fp[2]}


void  S1990C52_nt ::mf1990c52(){}

//skip512 S1990C52_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C53  {
  char s1990c53f0[16];
};
//SIG(-1 S1990C53) C1{ Fc[16]}



static void Test_S1990C53()
{
  {
    init_simple_test("S1990C53");
    S1990C53 lv;
    check2(sizeof(lv), 16, "sizeof(S1990C53)");
    check2(__alignof__(lv), 1, "__alignof__(S1990C53)");
    check_field_offset(lv, s1990c53f0, 0, "S1990C53.s1990c53f0");
  }
}
static Arrange_To_Call_Me vS1990C53(Test_S1990C53, "S1990C53", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1990C1  : S1990C2 {
  ::S1990C20_nt s1990c1f0;
  ::S1990C20_nt s1990c1f1;
  int s1990c1f2;
  ::S1990C52_nt s1990c1f3;
  ::S1990C53 s1990c1f4;
  char s1990c1f5[257];
  int s1990c1f6;
  void *s1990c1f7;
  virtual  ~S1990C1(); // _ZN7S1990C1D1Ev
  S1990C1(); // tgen
};
//SIG(1 S1990C1) C1{ BC2{ BC3{ BC4{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC5 Fi} vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8 FC10{ m FC8} FC11{ m FC8 FC8 FC8 FC8} FC11 FC8 FC8 FC8 Fp FC10 FC12{ m FC13{ m Fp Fi FC14{ m}} Fi} Fi Fp[7] FC15{ m Fp Fi FC14 FC16{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC17{ BC18{ m Fp Fi FC16 FC19{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC20{ m Fp Fi[2] FC19} Fp[2] Fi:16 Fi:16 FC17 FC20 FC21{ m Fp Fi[2] FC22{ m}} Fp[2] Fi:24 Fi:8 Fp} vd v102 v103 v104 v105 v106 v107 v108 v109 v110 Fp Fc FC23{ m FC21 FC24{ BC25{ m Fp Fi FC22 FC26{ m}}} FC27{ m Fp Fi[2] FC26} FC24} FC12} vd FC13 FC13 Fi FC28{ m Fp[2]} FC29{ Fc[16]} Fc[257] Fi Fp}


 S1990C1 ::~S1990C1(){ note_dtor("S1990C1", this);}
S1990C1 ::S1990C1(){ note_ctor("S1990C1", this);} // tgen

static void Test_S1990C1()
{
  extern Class_Descriptor cd_S1990C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(163,259)];
    init_test(&cd_S1990C1, buf);
    S1990C1 *dp, &lv = *(dp=new (buf) S1990C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1296,1032), "sizeof(S1990C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1990C1)");
    check_base_class_offset(lv, (S1990C4_nt*)(S1990C3_nt*)(S1990C2*), 0, "S1990C1");
    check_base_class_offset(lv, (S1990C3_nt*)(S1990C2*), 0, "S1990C1");
    check_base_class_offset(lv, (S1990C2*), 0, "S1990C1");
    check_field_offset(lv, s1990c1f0, ABISELECT(952,712), "S1990C1.s1990c1f0");
    check_field_offset(lv, s1990c1f1, ABISELECT(968,724), "S1990C1.s1990c1f1");
    check_field_offset(lv, s1990c1f2, ABISELECT(984,736), "S1990C1.s1990c1f2");
    check_field_offset(lv, s1990c1f3, ABISELECT(992,740), "S1990C1.s1990c1f3");
    check_field_offset(lv, s1990c1f4, ABISELECT(1008,748), "S1990C1.s1990c1f4");
    check_field_offset(lv, s1990c1f5, ABISELECT(1024,764), "S1990C1.s1990c1f5");
    check_field_offset(lv, s1990c1f6, ABISELECT(1284,1024), "S1990C1.s1990c1f6");
    check_field_offset(lv, s1990c1f7, ABISELECT(1288,1028), "S1990C1.s1990c1f7");
    test_class_info(&lv, &cd_S1990C1);
    dp->~S1990C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1990C1(Test_S1990C1, "S1990C1", ABISELECT(1296,1032));

#else // __cplusplus

extern void _ZN7S1990C1C1Ev();
extern void _ZN7S1990C1D1Ev();
Name_Map name_map_S1990C1[] = {
  NSPAIR(_ZN7S1990C1C1Ev),
  NSPAIR(_ZN7S1990C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1990C4_nt;
extern VTBL_ENTRY _ZTI10S1990C4_nt[];
extern  VTBL_ENTRY _ZTV10S1990C4_nt[];
extern Class_Descriptor cd_S1990C3_nt;
extern VTBL_ENTRY _ZTI10S1990C3_nt[];
extern  VTBL_ENTRY _ZTV10S1990C3_nt[];
extern Class_Descriptor cd_S1990C2;
extern VTBL_ENTRY _ZTI7S1990C2[];
extern  VTBL_ENTRY _ZTV7S1990C2[];
static Base_Class bases_S1990C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1990C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1990C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1990C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1990C1[];
extern void _ZN7S1990C1D1Ev();
extern void _ZN7S1990C1D0Ev();
extern void _ZN10S1990C4_nt2v1Ev();
extern void _ZN10S1990C4_nt2v2Ev();
extern void _ZN10S1990C4_nt2v3Ev();
extern void _ZN10S1990C4_nt2v4Ev();
extern void _ZN10S1990C4_nt2v5Ev();
extern void _ZN10S1990C4_nt2v6Ev();
extern void _ZN10S1990C4_nt2v7Ev();
extern void _ZN10S1990C4_nt2v8Ev();
extern void _ZN10S1990C4_nt2v9Ev();
extern void _ZN10S1990C4_nt3v10Ev();
extern void _ZN10S1990C4_nt3v11Ev();
extern void _ZN10S1990C4_nt3v12Ev();
extern void _ZN10S1990C4_nt3v13Ev();
extern void _ZN10S1990C4_nt3v14Ev();
extern void _ZN10S1990C4_nt3v15Ev();
extern void _ZN10S1990C4_nt3v16Ev();
extern void _ZN10S1990C4_nt3v17Ev();
extern void _ZN10S1990C4_nt3v18Ev();
extern void _ZN10S1990C4_nt3v19Ev();
extern void _ZN10S1990C4_nt3v20Ev();
extern void _ZN10S1990C4_nt3v21Ev();
extern void _ZN10S1990C4_nt3v22Ev();
extern void _ZN10S1990C4_nt3v23Ev();
extern void _ZN10S1990C3_nt3v24Ev();
extern void _ZN10S1990C3_nt3v25Ev();
extern void _ZN10S1990C3_nt3v26Ev();
extern void _ZN10S1990C3_nt3v27Ev();
extern void _ZN10S1990C3_nt3v28Ev();
extern void _ZN10S1990C3_nt3v29Ev();
extern void _ZN10S1990C3_nt3v30Ev();
extern void _ZN10S1990C3_nt3v31Ev();
extern void _ZN10S1990C3_nt3v32Ev();
extern void _ZN10S1990C3_nt3v33Ev();
extern void _ZN10S1990C3_nt3v34Ev();
extern void _ZN10S1990C3_nt3v35Ev();
extern void _ZN10S1990C3_nt3v36Ev();
extern void _ZN10S1990C3_nt3v37Ev();
extern void _ZN10S1990C3_nt3v38Ev();
extern void _ZN10S1990C3_nt3v39Ev();
extern void _ZN10S1990C3_nt3v40Ev();
extern void _ZN10S1990C3_nt3v41Ev();
extern void _ZN10S1990C3_nt3v42Ev();
extern void _ZN10S1990C3_nt3v43Ev();
extern void _ZN10S1990C3_nt3v44Ev();
extern void _ZN10S1990C3_nt3v45Ev();
extern void _ZN10S1990C3_nt3v46Ev();
extern void _ZN10S1990C3_nt3v47Ev();
extern void _ZN10S1990C3_nt3v48Ev();
extern void _ZN10S1990C3_nt3v49Ev();
extern void _ZN10S1990C3_nt3v50Ev();
extern void _ZN10S1990C3_nt3v51Ev();
extern void _ZN10S1990C3_nt3v52Ev();
extern void _ZN10S1990C3_nt3v53Ev();
extern void _ZN10S1990C3_nt3v54Ev();
extern void _ZN10S1990C3_nt3v55Ev();
extern void _ZN10S1990C3_nt3v56Ev();
extern void _ZN10S1990C3_nt3v57Ev();
extern void _ZN10S1990C3_nt3v58Ev();
extern void _ZN10S1990C3_nt3v59Ev();
extern void _ZN10S1990C3_nt3v60Ev();
extern void _ZN10S1990C3_nt3v61Ev();
extern void _ZN10S1990C3_nt3v62Ev();
extern void _ZN10S1990C3_nt3v63Ev();
extern void _ZN10S1990C3_nt3v64Ev();
extern void _ZN10S1990C3_nt3v65Ev();
extern void _ZN10S1990C3_nt3v66Ev();
extern void _ZN10S1990C3_nt3v67Ev();
extern void _ZN10S1990C3_nt3v68Ev();
extern void _ZN10S1990C3_nt3v69Ev();
extern void _ZN10S1990C3_nt3v70Ev();
extern void _ZN10S1990C3_nt3v71Ev();
extern void _ZN10S1990C3_nt3v72Ev();
extern void _ZN10S1990C3_nt3v73Ev();
extern void _ZN10S1990C3_nt3v74Ev();
extern void _ZN10S1990C3_nt3v75Ev();
extern void _ZN10S1990C3_nt3v76Ev();
extern void _ZN10S1990C3_nt3v77Ev();
extern void _ZN10S1990C3_nt3v78Ev();
extern void _ZN10S1990C3_nt3v79Ev();
extern void _ZN10S1990C3_nt3v80Ev();
extern void _ZN10S1990C3_nt3v81Ev();
extern void _ZN10S1990C3_nt3v82Ev();
extern void _ZN10S1990C3_nt3v83Ev();
extern void _ZN10S1990C3_nt3v84Ev();
extern void _ZN10S1990C3_nt3v85Ev();
extern void _ZN10S1990C3_nt3v86Ev();
extern void _ZN10S1990C3_nt3v87Ev();
extern void _ZN10S1990C3_nt3v88Ev();
extern void _ZN10S1990C3_nt3v89Ev();
extern void _ZN10S1990C3_nt3v90Ev();
extern void _ZN10S1990C3_nt3v91Ev();
extern void _ZN10S1990C3_nt3v92Ev();
extern void _ZN10S1990C3_nt3v93Ev();
extern void _ZN10S1990C3_nt3v94Ev();
extern void _ZN10S1990C3_nt3v95Ev();
extern void _ZN10S1990C3_nt3v96Ev();
extern void _ZN10S1990C3_nt3v97Ev();
extern void _ZN10S1990C3_nt3v98Ev();
extern void _ZN10S1990C3_nt3v99Ev();
extern void _ZN10S1990C3_nt4v100Ev();
extern void _ZN10S1990C3_nt4v101Ev();
extern void _ZN7S1990C24v102Ev();
extern void _ZN7S1990C24v103Ev();
extern void _ZN7S1990C24v104Ev();
extern void _ZN7S1990C24v105Ev();
extern void _ZN7S1990C24v106Ev();
extern void _ZN7S1990C24v107Ev();
extern void _ZN7S1990C24v108Ev();
extern void _ZN7S1990C24v109Ev();
extern void _ZN7S1990C24v110Ev();
static  VTBL_ENTRY vtc_S1990C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1990C1[0]),
  (VTBL_ENTRY)&_ZN7S1990C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1990C1D0Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v1Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v2Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v3Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v4Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v5Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v6Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v7Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v8Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S1990C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S1990C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN7S1990C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1990C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1990C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1990C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1990C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1990C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1990C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1990C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1990C24v110Ev,
};
extern VTBL_ENTRY _ZTI7S1990C1[];
extern  VTBL_ENTRY _ZTV7S1990C1[];
Class_Descriptor cd_S1990C1 = {  "S1990C1", // class name
  bases_S1990C1, 3,
  &(vtc_S1990C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1296,1032), // object size
  NSPAIRA(_ZTI7S1990C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1990C1),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1993C4  {
  void *s1993c4f0;
  int s1993c4f1;
  ::S1990C42 s1993c4f2;
  ::S1990C25 s1993c4f3;
  int s1993c4f4;
  virtual  ~S1993C4(); // _ZN7S1993C4D1Ev
  virtual void  v1(); // _ZN7S1993C42v1Ev
  virtual void  v2(); // _ZN7S1993C42v2Ev
  virtual void  v3(); // _ZN7S1993C42v3Ev
  virtual void  v4(); // _ZN7S1993C42v4Ev
  virtual void  v5(); // _ZN7S1993C42v5Ev
  virtual void  v6(); // _ZN7S1993C42v6Ev
  virtual void  v7(); // _ZN7S1993C42v7Ev
  virtual void  v8(); // _ZN7S1993C42v8Ev
  virtual void  v9(); // _ZN7S1993C42v9Ev
  virtual void  v10(); // _ZN7S1993C43v10Ev
  virtual void  v11(); // _ZN7S1993C43v11Ev
  virtual void  v12(); // _ZN7S1993C43v12Ev
  virtual void  v13(); // _ZN7S1993C43v13Ev
  virtual void  v14(); // _ZN7S1993C43v14Ev
  virtual void  v15(); // _ZN7S1993C43v15Ev
  virtual void  v16(); // _ZN7S1993C43v16Ev
  virtual void  v17(); // _ZN7S1993C43v17Ev
  virtual void  v18(); // _ZN7S1993C43v18Ev
  virtual void  v19(); // _ZN7S1993C43v19Ev
  virtual void  v20(); // _ZN7S1993C43v20Ev
  virtual void  v21(); // _ZN7S1993C43v21Ev
  virtual void  v22(); // _ZN7S1993C43v22Ev
  virtual void  v23(); // _ZN7S1993C43v23Ev
  S1993C4(); // tgen
};
//SIG(-1 S1993C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}} FC6{ BC7{ m Fp Fi FC8{ m} FC9{ m}}} Fi}


 S1993C4 ::~S1993C4(){ note_dtor("S1993C4", this);}
void  S1993C4 ::v1(){vfunc_called(this, "_ZN7S1993C42v1Ev");}
void  S1993C4 ::v2(){vfunc_called(this, "_ZN7S1993C42v2Ev");}
void  S1993C4 ::v3(){vfunc_called(this, "_ZN7S1993C42v3Ev");}
void  S1993C4 ::v4(){vfunc_called(this, "_ZN7S1993C42v4Ev");}
void  S1993C4 ::v5(){vfunc_called(this, "_ZN7S1993C42v5Ev");}
void  S1993C4 ::v6(){vfunc_called(this, "_ZN7S1993C42v6Ev");}
void  S1993C4 ::v7(){vfunc_called(this, "_ZN7S1993C42v7Ev");}
void  S1993C4 ::v8(){vfunc_called(this, "_ZN7S1993C42v8Ev");}
void  S1993C4 ::v9(){vfunc_called(this, "_ZN7S1993C42v9Ev");}
void  S1993C4 ::v10(){vfunc_called(this, "_ZN7S1993C43v10Ev");}
void  S1993C4 ::v11(){vfunc_called(this, "_ZN7S1993C43v11Ev");}
void  S1993C4 ::v12(){vfunc_called(this, "_ZN7S1993C43v12Ev");}
void  S1993C4 ::v13(){vfunc_called(this, "_ZN7S1993C43v13Ev");}
void  S1993C4 ::v14(){vfunc_called(this, "_ZN7S1993C43v14Ev");}
void  S1993C4 ::v15(){vfunc_called(this, "_ZN7S1993C43v15Ev");}
void  S1993C4 ::v16(){vfunc_called(this, "_ZN7S1993C43v16Ev");}
void  S1993C4 ::v17(){vfunc_called(this, "_ZN7S1993C43v17Ev");}
void  S1993C4 ::v18(){vfunc_called(this, "_ZN7S1993C43v18Ev");}
void  S1993C4 ::v19(){vfunc_called(this, "_ZN7S1993C43v19Ev");}
void  S1993C4 ::v20(){vfunc_called(this, "_ZN7S1993C43v20Ev");}
void  S1993C4 ::v21(){vfunc_called(this, "_ZN7S1993C43v21Ev");}
void  S1993C4 ::v22(){vfunc_called(this, "_ZN7S1993C43v22Ev");}
void  S1993C4 ::v23(){vfunc_called(this, "_ZN7S1993C43v23Ev");}
S1993C4 ::S1993C4(){ note_ctor("S1993C4", this);} // tgen

static void Test_S1993C4()
{
  extern Class_Descriptor cd_S1993C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_S1993C4, buf);
    S1993C4 *dp, &lv = *(dp=new (buf) S1993C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(S1993C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1993C4)");
    check_field_offset(lv, s1993c4f0, ABISELECT(8,4), "S1993C4.s1993c4f0");
    check_field_offset(lv, s1993c4f1, ABISELECT(16,8), "S1993C4.s1993c4f1");
    check_field_offset(lv, s1993c4f2, ABISELECT(24,12), "S1993C4.s1993c4f2");
    check_field_offset(lv, s1993c4f3, ABISELECT(40,24), "S1993C4.s1993c4f3");
    check_field_offset(lv, s1993c4f4, ABISELECT(56,36), "S1993C4.s1993c4f4");
    test_class_info(&lv, &cd_S1993C4);
    dp->~S1993C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1993C4(Test_S1993C4, "S1993C4", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN7S1993C4C1Ev();
extern void _ZN7S1993C4D1Ev();
Name_Map name_map_S1993C4[] = {
  NSPAIR(_ZN7S1993C4C1Ev),
  NSPAIR(_ZN7S1993C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1993C4[];
extern void _ZN7S1993C4D1Ev();
extern void _ZN7S1993C4D0Ev();
extern void _ZN7S1993C42v1Ev();
extern void _ZN7S1993C42v2Ev();
extern void _ZN7S1993C42v3Ev();
extern void _ZN7S1993C42v4Ev();
extern void _ZN7S1993C42v5Ev();
extern void _ZN7S1993C42v6Ev();
extern void _ZN7S1993C42v7Ev();
extern void _ZN7S1993C42v8Ev();
extern void _ZN7S1993C42v9Ev();
extern void _ZN7S1993C43v10Ev();
extern void _ZN7S1993C43v11Ev();
extern void _ZN7S1993C43v12Ev();
extern void _ZN7S1993C43v13Ev();
extern void _ZN7S1993C43v14Ev();
extern void _ZN7S1993C43v15Ev();
extern void _ZN7S1993C43v16Ev();
extern void _ZN7S1993C43v17Ev();
extern void _ZN7S1993C43v18Ev();
extern void _ZN7S1993C43v19Ev();
extern void _ZN7S1993C43v20Ev();
extern void _ZN7S1993C43v21Ev();
extern void _ZN7S1993C43v22Ev();
extern void _ZN7S1993C43v23Ev();
static  VTBL_ENTRY vtc_S1993C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1993C4[0]),
  (VTBL_ENTRY)&_ZN7S1993C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1993C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v1Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v23Ev,
};
extern VTBL_ENTRY _ZTI7S1993C4[];
extern  VTBL_ENTRY _ZTV7S1993C4[];
Class_Descriptor cd_S1993C4 = {  "S1993C4", // class name
  0,0,//no base classes
  &(vtc_S1993C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI7S1993C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1993C4),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1993C15  {
  ::S1990C14_nt s1993c15f0;
  void  mf1993c15(); // _ZN8S1993C159mf1993c15Ev
};
//SIG(-1 S1993C15) C1{ m FC2{ m FL[2]}}


void  S1993C15 ::mf1993c15(){}

static void Test_S1993C15()
{
  {
    init_simple_test("S1993C15");
    S1993C15 lv;
    check2(sizeof(lv), 16, "sizeof(S1993C15)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1993C15)");
    check_field_offset(lv, s1993c15f0, 0, "S1993C15.s1993c15f0");
  }
}
static Arrange_To_Call_Me vS1993C15(Test_S1993C15, "S1993C15", 16);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1993C31  : S1990C26 {
};
//SIG(-1 S1993C31) C1{ BC2{ m Fp Fi FC3{ m} FC4{ m}}}



static void Test_S1993C31()
{
  extern Class_Descriptor cd_S1993C31;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S1993C31, buf);
    S1993C31 &lv = *(new (buf) S1993C31());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S1993C31)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1993C31)");
    check_base_class_offset(lv, (S1990C26*), 0, "S1993C31");
    test_class_info(&lv, &cd_S1993C31);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1993C31(Test_S1993C31, "S1993C31", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S1990C26;
static Base_Class bases_S1993C31[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1990C26,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S1993C31 = {  "S1993C31", // class name
  bases_S1993C31, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1993C3  : S1993C4 {
  ::S1990C13_nt s1993c3f0;
  ::S1990C13_nt s1993c3f1;
  ::S1990C13_nt s1993c3f2;
  ::S1993C15 s1993c3f3;
  ::S1990C17_nt s1993c3f4;
  ::S1990C18_nt s1993c3f5;
  ::S1990C18_nt s1993c3f6;
  ::S1990C13_nt s1993c3f7;
  ::S1990C13_nt s1993c3f8;
  ::S1990C13_nt s1993c3f9;
  void *s1993c3f10;
  ::S1990C17_nt s1993c3f11;
  ::S1990C19_nt s1993c3f12;
  int s1993c3f13;
  void *s1993c3f14[7];
  ::S1990C43 s1993c3f15;
  int s1993c3f16:8;
  int s1993c3f17:8;
  int s1993c3f18:16;
  int s1993c3f19:16;
  int s1993c3f20:8;
  int s1993c3f21:8;
  int s1993c3f22:8;
  int s1993c3f23:32;
  int s1993c3f24:8;
  int s1993c3f25:4;
  int s1993c3f26:4;
  int s1993c3f27:4;
  int s1993c3f28:4;
  int s1993c3f29:4;
  int s1993c3f30:4;
  int s1993c3f31:4;
  int s1993c3f32:4;
  int s1993c3f33:4;
  int s1993c3f34:4;
  unsigned char s1993c3f35:1;
  unsigned char s1993c3f36:1;
  unsigned char s1993c3f37:1;
  unsigned char s1993c3f38:1;
  unsigned char s1993c3f39:1;
  unsigned char s1993c3f40:1;
  unsigned char s1993c3f41:1;
  unsigned char s1993c3f42:1;
  unsigned char s1993c3f43:1;
  unsigned char s1993c3f44:1;
  unsigned char s1993c3f45:1;
  unsigned char s1993c3f46:1;
  unsigned char s1993c3f47:1;
  unsigned char s1993c3f48:1;
  unsigned char s1993c3f49:1;
  unsigned char s1993c3f50:1;
  unsigned char s1993c3f51:1;
  unsigned char s1993c3f52:1;
  unsigned char s1993c3f53:1;
  unsigned char s1993c3f54:1;
  unsigned char s1993c3f55:1;
  unsigned char s1993c3f56:1;
  unsigned char s1993c3f57:1;
  unsigned char s1993c3f58:1;
  unsigned char s1993c3f59:1;
  unsigned char s1993c3f60:1;
  unsigned char s1993c3f61:1;
  unsigned char s1993c3f62:1;
  unsigned char s1993c3f63:1;
  unsigned char s1993c3f64:1;
  unsigned char s1993c3f65:1;
  unsigned char s1993c3f66:1;
  unsigned char s1993c3f67:1;
  unsigned char s1993c3f68:1;
  unsigned char s1993c3f69:1;
  unsigned char s1993c3f70:1;
  unsigned char s1993c3f71:1;
  unsigned char s1993c3f72:1;
  unsigned char s1993c3f73:1;
  unsigned char s1993c3f74:1;
  unsigned char s1993c3f75:1;
  int s1993c3f76[7];
  void *s1993c3f77[6];
  int s1993c3f78:8;
  int s1993c3f79:8;
  int s1993c3f80:8;
  int s1993c3f81:8;
  int s1993c3f82:8;
  int s1993c3f83:8;
  ::S1990C5_nt s1993c3f84;
  void *s1993c3f85[4];
  int s1993c3f86:8;
  int s1993c3f87:8;
  int s1993c3f88:8;
  int s1993c3f89:8;
  int s1993c3f90:8;
  int s1993c3f91:16;
  int s1993c3f92:16;
  int s1993c3f93:16;
  int s1993c3f94:4;
  int s1993c3f95:4;
  int s1993c3f96:4;
  int s1993c3f97:4;
  int s1993c3f98:4;
  int s1993c3f99:4;
  int s1993c3f100:4;
  int s1993c3f101:4;
  int s1993c3f102:4;
  int s1993c3f103:4;
  int s1993c3f104:4;
  int s1993c3f105:4;
  int s1993c3f106:8;
  int s1993c3f107:8;
  int s1993c3f108:8;
  void *s1993c3f109[7];
  ::S1990C46 s1993c3f110;
  void *s1993c3f111[2];
  int s1993c3f112:16;
  int s1993c3f113:16;
  ::S1993C31 s1993c3f114;
  ::S1990C37 s1993c3f115;
  ::S1990C29_nt s1993c3f116;
  void *s1993c3f117[2];
  int s1993c3f118:24;
  int s1993c3f119:8;
  void *s1993c3f120;
  virtual  ~S1993C3(); // _ZN7S1993C3D1Ev
  virtual void  v24(); // _ZN7S1993C33v24Ev
  virtual void  v25(); // _ZN7S1993C33v25Ev
  virtual void  v26(); // _ZN7S1993C33v26Ev
  virtual void  v27(); // _ZN7S1993C33v27Ev
  virtual void  v28(); // _ZN7S1993C33v28Ev
  virtual void  v29(); // _ZN7S1993C33v29Ev
  virtual void  v30(); // _ZN7S1993C33v30Ev
  virtual void  v31(); // _ZN7S1993C33v31Ev
  virtual void  v32(); // _ZN7S1993C33v32Ev
  virtual void  v33(); // _ZN7S1993C33v33Ev
  virtual void  v34(); // _ZN7S1993C33v34Ev
  virtual void  v35(); // _ZN7S1993C33v35Ev
  virtual void  v36(); // _ZN7S1993C33v36Ev
  virtual void  v37(); // _ZN7S1993C33v37Ev
  virtual void  v38(); // _ZN7S1993C33v38Ev
  virtual void  v39(); // _ZN7S1993C33v39Ev
  virtual void  v40(); // _ZN7S1993C33v40Ev
  virtual void  v41(); // _ZN7S1993C33v41Ev
  virtual void  v42(); // _ZN7S1993C33v42Ev
  virtual void  v43(); // _ZN7S1993C33v43Ev
  virtual void  v44(); // _ZN7S1993C33v44Ev
  virtual void  v45(); // _ZN7S1993C33v45Ev
  virtual void  v46(); // _ZN7S1993C33v46Ev
  virtual void  v47(); // _ZN7S1993C33v47Ev
  virtual void  v48(); // _ZN7S1993C33v48Ev
  virtual void  v49(); // _ZN7S1993C33v49Ev
  virtual void  v50(); // _ZN7S1993C33v50Ev
  virtual void  v51(); // _ZN7S1993C33v51Ev
  virtual void  v52(); // _ZN7S1993C33v52Ev
  virtual void  v53(); // _ZN7S1993C33v53Ev
  virtual void  v54(); // _ZN7S1993C33v54Ev
  virtual void  v55(); // _ZN7S1993C33v55Ev
  virtual void  v56(); // _ZN7S1993C33v56Ev
  virtual void  v57(); // _ZN7S1993C33v57Ev
  virtual void  v58(); // _ZN7S1993C33v58Ev
  virtual void  v59(); // _ZN7S1993C33v59Ev
  virtual void  v60(); // _ZN7S1993C33v60Ev
  virtual void  v61(); // _ZN7S1993C33v61Ev
  virtual void  v62(); // _ZN7S1993C33v62Ev
  virtual void  v63(); // _ZN7S1993C33v63Ev
  virtual void  v64(); // _ZN7S1993C33v64Ev
  virtual void  v65(); // _ZN7S1993C33v65Ev
  virtual void  v66(); // _ZN7S1993C33v66Ev
  virtual void  v67(); // _ZN7S1993C33v67Ev
  virtual void  v68(); // _ZN7S1993C33v68Ev
  virtual void  v69(); // _ZN7S1993C33v69Ev
  virtual void  v70(); // _ZN7S1993C33v70Ev
  virtual void  v71(); // _ZN7S1993C33v71Ev
  virtual void  v72(); // _ZN7S1993C33v72Ev
  virtual void  v73(); // _ZN7S1993C33v73Ev
  virtual void  v74(); // _ZN7S1993C33v74Ev
  virtual void  v75(); // _ZN7S1993C33v75Ev
  virtual void  v76(); // _ZN7S1993C33v76Ev
  virtual void  v77(); // _ZN7S1993C33v77Ev
  virtual void  v78(); // _ZN7S1993C33v78Ev
  virtual void  v79(); // _ZN7S1993C33v79Ev
  virtual void  v80(); // _ZN7S1993C33v80Ev
  virtual void  v81(); // _ZN7S1993C33v81Ev
  virtual void  v82(); // _ZN7S1993C33v82Ev
  virtual void  v83(); // _ZN7S1993C33v83Ev
  virtual void  v84(); // _ZN7S1993C33v84Ev
  virtual void  v85(); // _ZN7S1993C33v85Ev
  virtual void  v86(); // _ZN7S1993C33v86Ev
  virtual void  v87(); // _ZN7S1993C33v87Ev
  virtual void  v88(); // _ZN7S1993C33v88Ev
  virtual void  v89(); // _ZN7S1993C33v89Ev
  virtual void  v90(); // _ZN7S1993C33v90Ev
  virtual void  v91(); // _ZN7S1993C33v91Ev
  virtual void  v92(); // _ZN7S1993C33v92Ev
  virtual void  v93(); // _ZN7S1993C33v93Ev
  virtual void  v94(); // _ZN7S1993C33v94Ev
  virtual void  v95(); // _ZN7S1993C33v95Ev
  virtual void  v96(); // _ZN7S1993C33v96Ev
  virtual void  v97(); // _ZN7S1993C33v97Ev
  virtual void  v98(); // _ZN7S1993C33v98Ev
  virtual void  v99(); // _ZN7S1993C33v99Ev
  virtual void  v100(); // _ZN7S1993C34v100Ev
  virtual void  v101(); // _ZN7S1993C34v101Ev
  S1993C3(); // tgen
};
//SIG(-1 S1993C3) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fp Fi FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}} FC7{ BC8{ m Fp Fi FC9{ m} FC10{ m}}} Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 FC11{ m FC12{ m FL[2]}} FC11 FC11 FC13{ m FC12} FC14{ m FC11} FC15{ m FC11 FC11 FC11 FC11} FC15 FC11 FC11 FC11 Fp FC14 FC16{ m FC17{ m Fp Fi FC18{ m}} Fi} Fi Fp[7] FC4 Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC19{ BC20{ m Fp Fi FC21{ m} FC21}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC22{ m Fp Fi[2] FC6} Fp[2] Fi:16 Fi:16 FC23{ BC8} FC24{ m Fp Fi[2] FC5} FC25{ m Fp Fi[2] FC10} Fp[2] Fi:24 Fi:8 Fp}


 S1993C3 ::~S1993C3(){ note_dtor("S1993C3", this);}
void  S1993C3 ::v24(){vfunc_called(this, "_ZN7S1993C33v24Ev");}
void  S1993C3 ::v25(){vfunc_called(this, "_ZN7S1993C33v25Ev");}
void  S1993C3 ::v26(){vfunc_called(this, "_ZN7S1993C33v26Ev");}
void  S1993C3 ::v27(){vfunc_called(this, "_ZN7S1993C33v27Ev");}
void  S1993C3 ::v28(){vfunc_called(this, "_ZN7S1993C33v28Ev");}
void  S1993C3 ::v29(){vfunc_called(this, "_ZN7S1993C33v29Ev");}
void  S1993C3 ::v30(){vfunc_called(this, "_ZN7S1993C33v30Ev");}
void  S1993C3 ::v31(){vfunc_called(this, "_ZN7S1993C33v31Ev");}
void  S1993C3 ::v32(){vfunc_called(this, "_ZN7S1993C33v32Ev");}
void  S1993C3 ::v33(){vfunc_called(this, "_ZN7S1993C33v33Ev");}
void  S1993C3 ::v34(){vfunc_called(this, "_ZN7S1993C33v34Ev");}
void  S1993C3 ::v35(){vfunc_called(this, "_ZN7S1993C33v35Ev");}
void  S1993C3 ::v36(){vfunc_called(this, "_ZN7S1993C33v36Ev");}
void  S1993C3 ::v37(){vfunc_called(this, "_ZN7S1993C33v37Ev");}
void  S1993C3 ::v38(){vfunc_called(this, "_ZN7S1993C33v38Ev");}
void  S1993C3 ::v39(){vfunc_called(this, "_ZN7S1993C33v39Ev");}
void  S1993C3 ::v40(){vfunc_called(this, "_ZN7S1993C33v40Ev");}
void  S1993C3 ::v41(){vfunc_called(this, "_ZN7S1993C33v41Ev");}
void  S1993C3 ::v42(){vfunc_called(this, "_ZN7S1993C33v42Ev");}
void  S1993C3 ::v43(){vfunc_called(this, "_ZN7S1993C33v43Ev");}
void  S1993C3 ::v44(){vfunc_called(this, "_ZN7S1993C33v44Ev");}
void  S1993C3 ::v45(){vfunc_called(this, "_ZN7S1993C33v45Ev");}
void  S1993C3 ::v46(){vfunc_called(this, "_ZN7S1993C33v46Ev");}
void  S1993C3 ::v47(){vfunc_called(this, "_ZN7S1993C33v47Ev");}
void  S1993C3 ::v48(){vfunc_called(this, "_ZN7S1993C33v48Ev");}
void  S1993C3 ::v49(){vfunc_called(this, "_ZN7S1993C33v49Ev");}
void  S1993C3 ::v50(){vfunc_called(this, "_ZN7S1993C33v50Ev");}
void  S1993C3 ::v51(){vfunc_called(this, "_ZN7S1993C33v51Ev");}
void  S1993C3 ::v52(){vfunc_called(this, "_ZN7S1993C33v52Ev");}
void  S1993C3 ::v53(){vfunc_called(this, "_ZN7S1993C33v53Ev");}
void  S1993C3 ::v54(){vfunc_called(this, "_ZN7S1993C33v54Ev");}
void  S1993C3 ::v55(){vfunc_called(this, "_ZN7S1993C33v55Ev");}
void  S1993C3 ::v56(){vfunc_called(this, "_ZN7S1993C33v56Ev");}
void  S1993C3 ::v57(){vfunc_called(this, "_ZN7S1993C33v57Ev");}
void  S1993C3 ::v58(){vfunc_called(this, "_ZN7S1993C33v58Ev");}
void  S1993C3 ::v59(){vfunc_called(this, "_ZN7S1993C33v59Ev");}
void  S1993C3 ::v60(){vfunc_called(this, "_ZN7S1993C33v60Ev");}
void  S1993C3 ::v61(){vfunc_called(this, "_ZN7S1993C33v61Ev");}
void  S1993C3 ::v62(){vfunc_called(this, "_ZN7S1993C33v62Ev");}
void  S1993C3 ::v63(){vfunc_called(this, "_ZN7S1993C33v63Ev");}
void  S1993C3 ::v64(){vfunc_called(this, "_ZN7S1993C33v64Ev");}
void  S1993C3 ::v65(){vfunc_called(this, "_ZN7S1993C33v65Ev");}
void  S1993C3 ::v66(){vfunc_called(this, "_ZN7S1993C33v66Ev");}
void  S1993C3 ::v67(){vfunc_called(this, "_ZN7S1993C33v67Ev");}
void  S1993C3 ::v68(){vfunc_called(this, "_ZN7S1993C33v68Ev");}
void  S1993C3 ::v69(){vfunc_called(this, "_ZN7S1993C33v69Ev");}
void  S1993C3 ::v70(){vfunc_called(this, "_ZN7S1993C33v70Ev");}
void  S1993C3 ::v71(){vfunc_called(this, "_ZN7S1993C33v71Ev");}
void  S1993C3 ::v72(){vfunc_called(this, "_ZN7S1993C33v72Ev");}
void  S1993C3 ::v73(){vfunc_called(this, "_ZN7S1993C33v73Ev");}
void  S1993C3 ::v74(){vfunc_called(this, "_ZN7S1993C33v74Ev");}
void  S1993C3 ::v75(){vfunc_called(this, "_ZN7S1993C33v75Ev");}
void  S1993C3 ::v76(){vfunc_called(this, "_ZN7S1993C33v76Ev");}
void  S1993C3 ::v77(){vfunc_called(this, "_ZN7S1993C33v77Ev");}
void  S1993C3 ::v78(){vfunc_called(this, "_ZN7S1993C33v78Ev");}
void  S1993C3 ::v79(){vfunc_called(this, "_ZN7S1993C33v79Ev");}
void  S1993C3 ::v80(){vfunc_called(this, "_ZN7S1993C33v80Ev");}
void  S1993C3 ::v81(){vfunc_called(this, "_ZN7S1993C33v81Ev");}
void  S1993C3 ::v82(){vfunc_called(this, "_ZN7S1993C33v82Ev");}
void  S1993C3 ::v83(){vfunc_called(this, "_ZN7S1993C33v83Ev");}
void  S1993C3 ::v84(){vfunc_called(this, "_ZN7S1993C33v84Ev");}
void  S1993C3 ::v85(){vfunc_called(this, "_ZN7S1993C33v85Ev");}
void  S1993C3 ::v86(){vfunc_called(this, "_ZN7S1993C33v86Ev");}
void  S1993C3 ::v87(){vfunc_called(this, "_ZN7S1993C33v87Ev");}
void  S1993C3 ::v88(){vfunc_called(this, "_ZN7S1993C33v88Ev");}
void  S1993C3 ::v89(){vfunc_called(this, "_ZN7S1993C33v89Ev");}
void  S1993C3 ::v90(){vfunc_called(this, "_ZN7S1993C33v90Ev");}
void  S1993C3 ::v91(){vfunc_called(this, "_ZN7S1993C33v91Ev");}
void  S1993C3 ::v92(){vfunc_called(this, "_ZN7S1993C33v92Ev");}
void  S1993C3 ::v93(){vfunc_called(this, "_ZN7S1993C33v93Ev");}
void  S1993C3 ::v94(){vfunc_called(this, "_ZN7S1993C33v94Ev");}
void  S1993C3 ::v95(){vfunc_called(this, "_ZN7S1993C33v95Ev");}
void  S1993C3 ::v96(){vfunc_called(this, "_ZN7S1993C33v96Ev");}
void  S1993C3 ::v97(){vfunc_called(this, "_ZN7S1993C33v97Ev");}
void  S1993C3 ::v98(){vfunc_called(this, "_ZN7S1993C33v98Ev");}
void  S1993C3 ::v99(){vfunc_called(this, "_ZN7S1993C33v99Ev");}
void  S1993C3 ::v100(){vfunc_called(this, "_ZN7S1993C34v100Ev");}
void  S1993C3 ::v101(){vfunc_called(this, "_ZN7S1993C34v101Ev");}
S1993C3 ::S1993C3(){ note_ctor("S1993C3", this);} // tgen

static void Test_S1993C3()
{
  extern Class_Descriptor cd_S1993C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(105,159)];
    init_test(&cd_S1993C3, buf);
    S1993C3 *dp, &lv = *(dp=new (buf) S1993C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(832,632), "sizeof(S1993C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1993C3)");
    check_base_class_offset(lv, (S1993C4*), 0, "S1993C3");
    check_field_offset(lv, s1993c3f0, ABISELECT(64,40), "S1993C3.s1993c3f0");
    check_field_offset(lv, s1993c3f1, ABISELECT(80,56), "S1993C3.s1993c3f1");
    check_field_offset(lv, s1993c3f2, ABISELECT(96,72), "S1993C3.s1993c3f2");
    check_field_offset(lv, s1993c3f3, ABISELECT(112,88), "S1993C3.s1993c3f3");
    check_field_offset(lv, s1993c3f4, ABISELECT(128,104), "S1993C3.s1993c3f4");
    check_field_offset(lv, s1993c3f5, ABISELECT(144,120), "S1993C3.s1993c3f5");
    check_field_offset(lv, s1993c3f6, ABISELECT(208,184), "S1993C3.s1993c3f6");
    check_field_offset(lv, s1993c3f7, ABISELECT(272,248), "S1993C3.s1993c3f7");
    check_field_offset(lv, s1993c3f8, ABISELECT(288,264), "S1993C3.s1993c3f8");
    check_field_offset(lv, s1993c3f9, ABISELECT(304,280), "S1993C3.s1993c3f9");
    check_field_offset(lv, s1993c3f10, ABISELECT(320,296), "S1993C3.s1993c3f10");
    check_field_offset(lv, s1993c3f11, ABISELECT(328,300), "S1993C3.s1993c3f11");
    check_field_offset(lv, s1993c3f12, ABISELECT(344,316), "S1993C3.s1993c3f12");
    check_field_offset(lv, s1993c3f13, ABISELECT(368,332), "S1993C3.s1993c3f13");
    check_field_offset(lv, s1993c3f14, ABISELECT(376,336), "S1993C3.s1993c3f14");
    check_field_offset(lv, s1993c3f15, ABISELECT(432,364), "S1993C3.s1993c3f15");
    set_bf_and_test(lv, s1993c3f16, ABISELECT(448,376), 0, 8, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f16, ABISELECT(448,376), 0, 8, hide_sll(1LL<<7), "S1993C3");
    set_bf_and_test(lv, s1993c3f17, ABISELECT(449,377), 0, 8, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f17, ABISELECT(449,377), 0, 8, hide_sll(1LL<<7), "S1993C3");
    set_bf_and_test(lv, s1993c3f18, ABISELECT(450,378), 0, 16, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f18, ABISELECT(450,378), 0, 16, hide_sll(1LL<<15), "S1993C3");
    set_bf_and_test(lv, s1993c3f19, ABISELECT(452,380), 0, 16, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f19, ABISELECT(452,380), 0, 16, hide_sll(1LL<<15), "S1993C3");
    set_bf_and_test(lv, s1993c3f20, ABISELECT(454,382), 0, 8, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f20, ABISELECT(454,382), 0, 8, hide_sll(1LL<<7), "S1993C3");
    set_bf_and_test(lv, s1993c3f21, ABISELECT(455,383), 0, 8, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f21, ABISELECT(455,383), 0, 8, hide_sll(1LL<<7), "S1993C3");
    set_bf_and_test(lv, s1993c3f22, ABISELECT(456,384), 0, 8, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f22, ABISELECT(456,384), 0, 8, hide_sll(1LL<<7), "S1993C3");
    set_bf_and_test(lv, s1993c3f23, ABISELECT(460,388), 0, 32, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f23, ABISELECT(460,388), 0, 32, hide_sll(1LL<<31), "S1993C3");
    set_bf_and_test(lv, s1993c3f24, ABISELECT(464,392), 0, 8, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f24, ABISELECT(464,392), 0, 8, hide_sll(1LL<<7), "S1993C3");
    set_bf_and_test(lv, s1993c3f25, ABISELECT(465,393), 0, 4, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f25, ABISELECT(465,393), 0, 4, hide_sll(1LL<<3), "S1993C3");
    set_bf_and_test(lv, s1993c3f26, ABISELECT(465,393), 4, 4, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f26, ABISELECT(465,393), 4, 4, hide_sll(1LL<<3), "S1993C3");
    set_bf_and_test(lv, s1993c3f27, ABISELECT(466,394), 0, 4, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f27, ABISELECT(466,394), 0, 4, hide_sll(1LL<<3), "S1993C3");
    set_bf_and_test(lv, s1993c3f28, ABISELECT(466,394), 4, 4, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f28, ABISELECT(466,394), 4, 4, hide_sll(1LL<<3), "S1993C3");
    set_bf_and_test(lv, s1993c3f29, ABISELECT(467,395), 0, 4, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f29, ABISELECT(467,395), 0, 4, hide_sll(1LL<<3), "S1993C3");
    set_bf_and_test(lv, s1993c3f30, ABISELECT(467,395), 4, 4, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f30, ABISELECT(467,395), 4, 4, hide_sll(1LL<<3), "S1993C3");
    set_bf_and_test(lv, s1993c3f31, ABISELECT(468,396), 0, 4, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f31, ABISELECT(468,396), 0, 4, hide_sll(1LL<<3), "S1993C3");
    set_bf_and_test(lv, s1993c3f32, ABISELECT(468,396), 4, 4, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f32, ABISELECT(468,396), 4, 4, hide_sll(1LL<<3), "S1993C3");
    set_bf_and_test(lv, s1993c3f33, ABISELECT(469,397), 0, 4, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f33, ABISELECT(469,397), 0, 4, hide_sll(1LL<<3), "S1993C3");
    set_bf_and_test(lv, s1993c3f34, ABISELECT(469,397), 4, 4, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f34, ABISELECT(469,397), 4, 4, hide_sll(1LL<<3), "S1993C3");
    set_bf_and_test(lv, s1993c3f35, ABISELECT(470,398), 0, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f36, ABISELECT(470,398), 1, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f37, ABISELECT(470,398), 2, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f38, ABISELECT(470,398), 3, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f39, ABISELECT(470,398), 4, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f40, ABISELECT(470,398), 5, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f41, ABISELECT(470,398), 6, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f42, ABISELECT(470,398), 7, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f43, ABISELECT(471,399), 0, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f44, ABISELECT(471,399), 1, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f45, ABISELECT(471,399), 2, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f46, ABISELECT(471,399), 3, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f47, ABISELECT(471,399), 4, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f48, ABISELECT(471,399), 5, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f49, ABISELECT(471,399), 6, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f50, ABISELECT(471,399), 7, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f51, ABISELECT(472,400), 0, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f52, ABISELECT(472,400), 1, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f53, ABISELECT(472,400), 2, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f54, ABISELECT(472,400), 3, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f55, ABISELECT(472,400), 4, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f56, ABISELECT(472,400), 5, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f57, ABISELECT(472,400), 6, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f58, ABISELECT(472,400), 7, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f59, ABISELECT(473,401), 0, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f60, ABISELECT(473,401), 1, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f61, ABISELECT(473,401), 2, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f62, ABISELECT(473,401), 3, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f63, ABISELECT(473,401), 4, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f64, ABISELECT(473,401), 5, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f65, ABISELECT(473,401), 6, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f66, ABISELECT(473,401), 7, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f67, ABISELECT(474,402), 0, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f68, ABISELECT(474,402), 1, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f69, ABISELECT(474,402), 2, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f70, ABISELECT(474,402), 3, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f71, ABISELECT(474,402), 4, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f72, ABISELECT(474,402), 5, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f73, ABISELECT(474,402), 6, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f74, ABISELECT(474,402), 7, 1, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f75, ABISELECT(475,403), 0, 1, 1, "S1993C3");
    check_field_offset(lv, s1993c3f76, ABISELECT(476,404), "S1993C3.s1993c3f76");
    check_field_offset(lv, s1993c3f77, ABISELECT(504,432), "S1993C3.s1993c3f77");
    set_bf_and_test(lv, s1993c3f78, ABISELECT(552,456), 0, 8, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f78, ABISELECT(552,456), 0, 8, hide_sll(1LL<<7), "S1993C3");
    set_bf_and_test(lv, s1993c3f79, ABISELECT(553,457), 0, 8, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f79, ABISELECT(553,457), 0, 8, hide_sll(1LL<<7), "S1993C3");
    set_bf_and_test(lv, s1993c3f80, ABISELECT(554,458), 0, 8, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f80, ABISELECT(554,458), 0, 8, hide_sll(1LL<<7), "S1993C3");
    set_bf_and_test(lv, s1993c3f81, ABISELECT(555,459), 0, 8, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f81, ABISELECT(555,459), 0, 8, hide_sll(1LL<<7), "S1993C3");
    set_bf_and_test(lv, s1993c3f82, ABISELECT(556,460), 0, 8, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f82, ABISELECT(556,460), 0, 8, hide_sll(1LL<<7), "S1993C3");
    set_bf_and_test(lv, s1993c3f83, ABISELECT(557,461), 0, 8, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f83, ABISELECT(557,461), 0, 8, hide_sll(1LL<<7), "S1993C3");
    check_field_offset(lv, s1993c3f84, ABISELECT(560,464), "S1993C3.s1993c3f84");
    check_field_offset(lv, s1993c3f85, ABISELECT(576,476), "S1993C3.s1993c3f85");
    set_bf_and_test(lv, s1993c3f86, ABISELECT(608,492), 0, 8, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f86, ABISELECT(608,492), 0, 8, hide_sll(1LL<<7), "S1993C3");
    set_bf_and_test(lv, s1993c3f87, ABISELECT(609,493), 0, 8, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f87, ABISELECT(609,493), 0, 8, hide_sll(1LL<<7), "S1993C3");
    set_bf_and_test(lv, s1993c3f88, ABISELECT(610,494), 0, 8, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f88, ABISELECT(610,494), 0, 8, hide_sll(1LL<<7), "S1993C3");
    set_bf_and_test(lv, s1993c3f89, ABISELECT(611,495), 0, 8, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f89, ABISELECT(611,495), 0, 8, hide_sll(1LL<<7), "S1993C3");
    set_bf_and_test(lv, s1993c3f90, ABISELECT(612,496), 0, 8, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f90, ABISELECT(612,496), 0, 8, hide_sll(1LL<<7), "S1993C3");
    set_bf_and_test(lv, s1993c3f91, ABISELECT(613,497), 0, 16, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f91, ABISELECT(613,497), 0, 16, hide_sll(1LL<<15), "S1993C3");
    set_bf_and_test(lv, s1993c3f92, ABISELECT(616,500), 0, 16, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f92, ABISELECT(616,500), 0, 16, hide_sll(1LL<<15), "S1993C3");
    set_bf_and_test(lv, s1993c3f93, ABISELECT(618,502), 0, 16, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f93, ABISELECT(618,502), 0, 16, hide_sll(1LL<<15), "S1993C3");
    set_bf_and_test(lv, s1993c3f94, ABISELECT(620,504), 0, 4, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f94, ABISELECT(620,504), 0, 4, hide_sll(1LL<<3), "S1993C3");
    set_bf_and_test(lv, s1993c3f95, ABISELECT(620,504), 4, 4, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f95, ABISELECT(620,504), 4, 4, hide_sll(1LL<<3), "S1993C3");
    set_bf_and_test(lv, s1993c3f96, ABISELECT(621,505), 0, 4, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f96, ABISELECT(621,505), 0, 4, hide_sll(1LL<<3), "S1993C3");
    set_bf_and_test(lv, s1993c3f97, ABISELECT(621,505), 4, 4, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f97, ABISELECT(621,505), 4, 4, hide_sll(1LL<<3), "S1993C3");
    set_bf_and_test(lv, s1993c3f98, ABISELECT(622,506), 0, 4, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f98, ABISELECT(622,506), 0, 4, hide_sll(1LL<<3), "S1993C3");
    set_bf_and_test(lv, s1993c3f99, ABISELECT(622,506), 4, 4, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f99, ABISELECT(622,506), 4, 4, hide_sll(1LL<<3), "S1993C3");
    set_bf_and_test(lv, s1993c3f100, ABISELECT(623,507), 0, 4, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f100, ABISELECT(623,507), 0, 4, hide_sll(1LL<<3), "S1993C3");
    set_bf_and_test(lv, s1993c3f101, ABISELECT(623,507), 4, 4, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f101, ABISELECT(623,507), 4, 4, hide_sll(1LL<<3), "S1993C3");
    set_bf_and_test(lv, s1993c3f102, ABISELECT(624,508), 0, 4, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f102, ABISELECT(624,508), 0, 4, hide_sll(1LL<<3), "S1993C3");
    set_bf_and_test(lv, s1993c3f103, ABISELECT(624,508), 4, 4, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f103, ABISELECT(624,508), 4, 4, hide_sll(1LL<<3), "S1993C3");
    set_bf_and_test(lv, s1993c3f104, ABISELECT(625,509), 0, 4, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f104, ABISELECT(625,509), 0, 4, hide_sll(1LL<<3), "S1993C3");
    set_bf_and_test(lv, s1993c3f105, ABISELECT(625,509), 4, 4, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f105, ABISELECT(625,509), 4, 4, hide_sll(1LL<<3), "S1993C3");
    set_bf_and_test(lv, s1993c3f106, ABISELECT(626,510), 0, 8, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f106, ABISELECT(626,510), 0, 8, hide_sll(1LL<<7), "S1993C3");
    set_bf_and_test(lv, s1993c3f107, ABISELECT(627,511), 0, 8, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f107, ABISELECT(627,511), 0, 8, hide_sll(1LL<<7), "S1993C3");
    set_bf_and_test(lv, s1993c3f108, ABISELECT(628,512), 0, 8, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f108, ABISELECT(628,512), 0, 8, hide_sll(1LL<<7), "S1993C3");
    check_field_offset(lv, s1993c3f109, ABISELECT(632,516), "S1993C3.s1993c3f109");
    check_field_offset(lv, s1993c3f110, ABISELECT(688,544), "S1993C3.s1993c3f110");
    check_field_offset(lv, s1993c3f111, ABISELECT(712,560), "S1993C3.s1993c3f111");
    set_bf_and_test(lv, s1993c3f112, ABISELECT(728,568), 0, 16, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f112, ABISELECT(728,568), 0, 16, hide_sll(1LL<<15), "S1993C3");
    set_bf_and_test(lv, s1993c3f113, ABISELECT(730,570), 0, 16, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f113, ABISELECT(730,570), 0, 16, hide_sll(1LL<<15), "S1993C3");
    check_field_offset(lv, s1993c3f114, ABISELECT(736,572), "S1993C3.s1993c3f114");
    check_field_offset(lv, s1993c3f115, ABISELECT(752,584), "S1993C3.s1993c3f115");
    check_field_offset(lv, s1993c3f116, ABISELECT(776,600), "S1993C3.s1993c3f116");
    check_field_offset(lv, s1993c3f117, ABISELECT(800,616), "S1993C3.s1993c3f117");
    set_bf_and_test(lv, s1993c3f118, ABISELECT(816,624), 0, 24, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f118, ABISELECT(816,624), 0, 24, hide_sll(1LL<<23), "S1993C3");
    set_bf_and_test(lv, s1993c3f119, ABISELECT(819,627), 0, 8, 1, "S1993C3");
    set_bf_and_test(lv, s1993c3f119, ABISELECT(819,627), 0, 8, hide_sll(1LL<<7), "S1993C3");
    check_field_offset(lv, s1993c3f120, ABISELECT(824,628), "S1993C3.s1993c3f120");
    test_class_info(&lv, &cd_S1993C3);
    dp->~S1993C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1993C3(Test_S1993C3, "S1993C3", ABISELECT(832,632));

#else // __cplusplus

extern void _ZN7S1993C3C1Ev();
extern void _ZN7S1993C3D1Ev();
Name_Map name_map_S1993C3[] = {
  NSPAIR(_ZN7S1993C3C1Ev),
  NSPAIR(_ZN7S1993C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1993C4;
extern VTBL_ENTRY _ZTI7S1993C4[];
extern  VTBL_ENTRY _ZTV7S1993C4[];
static Base_Class bases_S1993C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1993C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1993C3[];
extern void _ZN7S1993C3D1Ev();
extern void _ZN7S1993C3D0Ev();
extern void _ZN7S1993C42v1Ev();
extern void _ZN7S1993C42v2Ev();
extern void _ZN7S1993C42v3Ev();
extern void _ZN7S1993C42v4Ev();
extern void _ZN7S1993C42v5Ev();
extern void _ZN7S1993C42v6Ev();
extern void _ZN7S1993C42v7Ev();
extern void _ZN7S1993C42v8Ev();
extern void _ZN7S1993C42v9Ev();
extern void _ZN7S1993C43v10Ev();
extern void _ZN7S1993C43v11Ev();
extern void _ZN7S1993C43v12Ev();
extern void _ZN7S1993C43v13Ev();
extern void _ZN7S1993C43v14Ev();
extern void _ZN7S1993C43v15Ev();
extern void _ZN7S1993C43v16Ev();
extern void _ZN7S1993C43v17Ev();
extern void _ZN7S1993C43v18Ev();
extern void _ZN7S1993C43v19Ev();
extern void _ZN7S1993C43v20Ev();
extern void _ZN7S1993C43v21Ev();
extern void _ZN7S1993C43v22Ev();
extern void _ZN7S1993C43v23Ev();
extern void _ZN7S1993C33v24Ev();
extern void _ZN7S1993C33v25Ev();
extern void _ZN7S1993C33v26Ev();
extern void _ZN7S1993C33v27Ev();
extern void _ZN7S1993C33v28Ev();
extern void _ZN7S1993C33v29Ev();
extern void _ZN7S1993C33v30Ev();
extern void _ZN7S1993C33v31Ev();
extern void _ZN7S1993C33v32Ev();
extern void _ZN7S1993C33v33Ev();
extern void _ZN7S1993C33v34Ev();
extern void _ZN7S1993C33v35Ev();
extern void _ZN7S1993C33v36Ev();
extern void _ZN7S1993C33v37Ev();
extern void _ZN7S1993C33v38Ev();
extern void _ZN7S1993C33v39Ev();
extern void _ZN7S1993C33v40Ev();
extern void _ZN7S1993C33v41Ev();
extern void _ZN7S1993C33v42Ev();
extern void _ZN7S1993C33v43Ev();
extern void _ZN7S1993C33v44Ev();
extern void _ZN7S1993C33v45Ev();
extern void _ZN7S1993C33v46Ev();
extern void _ZN7S1993C33v47Ev();
extern void _ZN7S1993C33v48Ev();
extern void _ZN7S1993C33v49Ev();
extern void _ZN7S1993C33v50Ev();
extern void _ZN7S1993C33v51Ev();
extern void _ZN7S1993C33v52Ev();
extern void _ZN7S1993C33v53Ev();
extern void _ZN7S1993C33v54Ev();
extern void _ZN7S1993C33v55Ev();
extern void _ZN7S1993C33v56Ev();
extern void _ZN7S1993C33v57Ev();
extern void _ZN7S1993C33v58Ev();
extern void _ZN7S1993C33v59Ev();
extern void _ZN7S1993C33v60Ev();
extern void _ZN7S1993C33v61Ev();
extern void _ZN7S1993C33v62Ev();
extern void _ZN7S1993C33v63Ev();
extern void _ZN7S1993C33v64Ev();
extern void _ZN7S1993C33v65Ev();
extern void _ZN7S1993C33v66Ev();
extern void _ZN7S1993C33v67Ev();
extern void _ZN7S1993C33v68Ev();
extern void _ZN7S1993C33v69Ev();
extern void _ZN7S1993C33v70Ev();
extern void _ZN7S1993C33v71Ev();
extern void _ZN7S1993C33v72Ev();
extern void _ZN7S1993C33v73Ev();
extern void _ZN7S1993C33v74Ev();
extern void _ZN7S1993C33v75Ev();
extern void _ZN7S1993C33v76Ev();
extern void _ZN7S1993C33v77Ev();
extern void _ZN7S1993C33v78Ev();
extern void _ZN7S1993C33v79Ev();
extern void _ZN7S1993C33v80Ev();
extern void _ZN7S1993C33v81Ev();
extern void _ZN7S1993C33v82Ev();
extern void _ZN7S1993C33v83Ev();
extern void _ZN7S1993C33v84Ev();
extern void _ZN7S1993C33v85Ev();
extern void _ZN7S1993C33v86Ev();
extern void _ZN7S1993C33v87Ev();
extern void _ZN7S1993C33v88Ev();
extern void _ZN7S1993C33v89Ev();
extern void _ZN7S1993C33v90Ev();
extern void _ZN7S1993C33v91Ev();
extern void _ZN7S1993C33v92Ev();
extern void _ZN7S1993C33v93Ev();
extern void _ZN7S1993C33v94Ev();
extern void _ZN7S1993C33v95Ev();
extern void _ZN7S1993C33v96Ev();
extern void _ZN7S1993C33v97Ev();
extern void _ZN7S1993C33v98Ev();
extern void _ZN7S1993C33v99Ev();
extern void _ZN7S1993C34v100Ev();
extern void _ZN7S1993C34v101Ev();
static  VTBL_ENTRY vtc_S1993C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1993C3[0]),
  (VTBL_ENTRY)&_ZN7S1993C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1993C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v1Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v29Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v30Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v31Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v32Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v33Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v34Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v35Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v36Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v37Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v38Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v39Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v40Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v41Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v42Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v43Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v44Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v45Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v46Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v47Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v48Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v49Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v50Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v51Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v52Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v53Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v54Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v55Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v56Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v57Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v58Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v59Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v60Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v61Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v62Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v63Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v64Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v65Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v66Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v67Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v68Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v69Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1993C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1993C34v101Ev,
};
extern VTBL_ENTRY _ZTI7S1993C3[];
extern  VTBL_ENTRY _ZTV7S1993C3[];
Class_Descriptor cd_S1993C3 = {  "S1993C3", // class name
  bases_S1993C3, 1,
  &(vtc_S1993C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI7S1993C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1993C3),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1993C2  : S1993C3 {
  void *s1993c2f0;
  char s1993c2f1;
  ::S1990C39_nt s1993c2f2;
  ::S1990C19_nt s1993c2f3;
  virtual  ~S1993C2(); // _ZN7S1993C2D1Ev
  virtual void  v102(); // _ZN7S1993C24v102Ev
  virtual void  v103(); // _ZN7S1993C24v103Ev
  virtual void  v104(); // _ZN7S1993C24v104Ev
  virtual void  v105(); // _ZN7S1993C24v105Ev
  virtual void  v106(); // _ZN7S1993C24v106Ev
  virtual void  v107(); // _ZN7S1993C24v107Ev
  virtual void  v108(); // _ZN7S1993C24v108Ev
  virtual void  v109(); // _ZN7S1993C24v109Ev
  virtual void  v110(); // _ZN7S1993C24v110Ev
  S1993C2(); // tgen
};
//SIG(-1 S1993C2) C1{ BC2{ BC3{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 Fp Fi FC4{ BC5{ m Fp Fi FC6{ m} FC7{ m}}} FC8{ BC9{ m Fp Fi FC10{ m} FC11{ m}}} Fi} vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 FC12{ m FC13{ m FL[2]}} FC12 FC12 FC14{ m FC13} FC15{ m FC12} FC16{ m FC12 FC12 FC12 FC12} FC16 FC12 FC12 FC12 Fp FC15 FC17{ m FC18{ m Fp Fi FC19{ m}} Fi} Fi Fp[7] FC5 Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC20{ BC21{ m Fp Fi FC22{ m} FC22}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC23{ m Fp Fi[2] FC7} Fp[2] Fi:16 Fi:16 FC24{ BC9} FC25{ m Fp Fi[2] FC6} FC26{ m Fp Fi[2] FC11} Fp[2] Fi:24 Fi:8 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fp Fc FC27{ m FC25 FC4 FC23 FC4} FC17}


 S1993C2 ::~S1993C2(){ note_dtor("S1993C2", this);}
void  S1993C2 ::v102(){vfunc_called(this, "_ZN7S1993C24v102Ev");}
void  S1993C2 ::v103(){vfunc_called(this, "_ZN7S1993C24v103Ev");}
void  S1993C2 ::v104(){vfunc_called(this, "_ZN7S1993C24v104Ev");}
void  S1993C2 ::v105(){vfunc_called(this, "_ZN7S1993C24v105Ev");}
void  S1993C2 ::v106(){vfunc_called(this, "_ZN7S1993C24v106Ev");}
void  S1993C2 ::v107(){vfunc_called(this, "_ZN7S1993C24v107Ev");}
void  S1993C2 ::v108(){vfunc_called(this, "_ZN7S1993C24v108Ev");}
void  S1993C2 ::v109(){vfunc_called(this, "_ZN7S1993C24v109Ev");}
void  S1993C2 ::v110(){vfunc_called(this, "_ZN7S1993C24v110Ev");}
S1993C2 ::S1993C2(){ note_ctor("S1993C2", this);} // tgen

static void Test_S1993C2()
{
  extern Class_Descriptor cd_S1993C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(120,179)];
    init_test(&cd_S1993C2, buf);
    S1993C2 *dp, &lv = *(dp=new (buf) S1993C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(952,712), "sizeof(S1993C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1993C2)");
    check_base_class_offset(lv, (S1993C4*)(S1993C3*), 0, "S1993C2");
    check_base_class_offset(lv, (S1993C3*), 0, "S1993C2");
    check_field_offset(lv, s1993c2f0, ABISELECT(832,632), "S1993C2.s1993c2f0");
    check_field_offset(lv, s1993c2f1, ABISELECT(840,636), "S1993C2.s1993c2f1");
    check_field_offset(lv, s1993c2f2, ABISELECT(848,640), "S1993C2.s1993c2f2");
    check_field_offset(lv, s1993c2f3, ABISELECT(928,696), "S1993C2.s1993c2f3");
    test_class_info(&lv, &cd_S1993C2);
    dp->~S1993C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1993C2(Test_S1993C2, "S1993C2", ABISELECT(952,712));

#else // __cplusplus

extern void _ZN7S1993C2C1Ev();
extern void _ZN7S1993C2D1Ev();
Name_Map name_map_S1993C2[] = {
  NSPAIR(_ZN7S1993C2C1Ev),
  NSPAIR(_ZN7S1993C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1993C4;
extern VTBL_ENTRY _ZTI7S1993C4[];
extern  VTBL_ENTRY _ZTV7S1993C4[];
extern Class_Descriptor cd_S1993C3;
extern VTBL_ENTRY _ZTI7S1993C3[];
extern  VTBL_ENTRY _ZTV7S1993C3[];
static Base_Class bases_S1993C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1993C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1993C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1993C2[];
extern void _ZN7S1993C2D1Ev();
extern void _ZN7S1993C2D0Ev();
extern void _ZN7S1993C42v1Ev();
extern void _ZN7S1993C42v2Ev();
extern void _ZN7S1993C42v3Ev();
extern void _ZN7S1993C42v4Ev();
extern void _ZN7S1993C42v5Ev();
extern void _ZN7S1993C42v6Ev();
extern void _ZN7S1993C42v7Ev();
extern void _ZN7S1993C42v8Ev();
extern void _ZN7S1993C42v9Ev();
extern void _ZN7S1993C43v10Ev();
extern void _ZN7S1993C43v11Ev();
extern void _ZN7S1993C43v12Ev();
extern void _ZN7S1993C43v13Ev();
extern void _ZN7S1993C43v14Ev();
extern void _ZN7S1993C43v15Ev();
extern void _ZN7S1993C43v16Ev();
extern void _ZN7S1993C43v17Ev();
extern void _ZN7S1993C43v18Ev();
extern void _ZN7S1993C43v19Ev();
extern void _ZN7S1993C43v20Ev();
extern void _ZN7S1993C43v21Ev();
extern void _ZN7S1993C43v22Ev();
extern void _ZN7S1993C43v23Ev();
extern void _ZN7S1993C33v24Ev();
extern void _ZN7S1993C33v25Ev();
extern void _ZN7S1993C33v26Ev();
extern void _ZN7S1993C33v27Ev();
extern void _ZN7S1993C33v28Ev();
extern void _ZN7S1993C33v29Ev();
extern void _ZN7S1993C33v30Ev();
extern void _ZN7S1993C33v31Ev();
extern void _ZN7S1993C33v32Ev();
extern void _ZN7S1993C33v33Ev();
extern void _ZN7S1993C33v34Ev();
extern void _ZN7S1993C33v35Ev();
extern void _ZN7S1993C33v36Ev();
extern void _ZN7S1993C33v37Ev();
extern void _ZN7S1993C33v38Ev();
extern void _ZN7S1993C33v39Ev();
extern void _ZN7S1993C33v40Ev();
extern void _ZN7S1993C33v41Ev();
extern void _ZN7S1993C33v42Ev();
extern void _ZN7S1993C33v43Ev();
extern void _ZN7S1993C33v44Ev();
extern void _ZN7S1993C33v45Ev();
extern void _ZN7S1993C33v46Ev();
extern void _ZN7S1993C33v47Ev();
extern void _ZN7S1993C33v48Ev();
extern void _ZN7S1993C33v49Ev();
extern void _ZN7S1993C33v50Ev();
extern void _ZN7S1993C33v51Ev();
extern void _ZN7S1993C33v52Ev();
extern void _ZN7S1993C33v53Ev();
extern void _ZN7S1993C33v54Ev();
extern void _ZN7S1993C33v55Ev();
extern void _ZN7S1993C33v56Ev();
extern void _ZN7S1993C33v57Ev();
extern void _ZN7S1993C33v58Ev();
extern void _ZN7S1993C33v59Ev();
extern void _ZN7S1993C33v60Ev();
extern void _ZN7S1993C33v61Ev();
extern void _ZN7S1993C33v62Ev();
extern void _ZN7S1993C33v63Ev();
extern void _ZN7S1993C33v64Ev();
extern void _ZN7S1993C33v65Ev();
extern void _ZN7S1993C33v66Ev();
extern void _ZN7S1993C33v67Ev();
extern void _ZN7S1993C33v68Ev();
extern void _ZN7S1993C33v69Ev();
extern void _ZN7S1993C33v70Ev();
extern void _ZN7S1993C33v71Ev();
extern void _ZN7S1993C33v72Ev();
extern void _ZN7S1993C33v73Ev();
extern void _ZN7S1993C33v74Ev();
extern void _ZN7S1993C33v75Ev();
extern void _ZN7S1993C33v76Ev();
extern void _ZN7S1993C33v77Ev();
extern void _ZN7S1993C33v78Ev();
extern void _ZN7S1993C33v79Ev();
extern void _ZN7S1993C33v80Ev();
extern void _ZN7S1993C33v81Ev();
extern void _ZN7S1993C33v82Ev();
extern void _ZN7S1993C33v83Ev();
extern void _ZN7S1993C33v84Ev();
extern void _ZN7S1993C33v85Ev();
extern void _ZN7S1993C33v86Ev();
extern void _ZN7S1993C33v87Ev();
extern void _ZN7S1993C33v88Ev();
extern void _ZN7S1993C33v89Ev();
extern void _ZN7S1993C33v90Ev();
extern void _ZN7S1993C33v91Ev();
extern void _ZN7S1993C33v92Ev();
extern void _ZN7S1993C33v93Ev();
extern void _ZN7S1993C33v94Ev();
extern void _ZN7S1993C33v95Ev();
extern void _ZN7S1993C33v96Ev();
extern void _ZN7S1993C33v97Ev();
extern void _ZN7S1993C33v98Ev();
extern void _ZN7S1993C33v99Ev();
extern void _ZN7S1993C34v100Ev();
extern void _ZN7S1993C34v101Ev();
extern void _ZN7S1993C24v102Ev();
extern void _ZN7S1993C24v103Ev();
extern void _ZN7S1993C24v104Ev();
extern void _ZN7S1993C24v105Ev();
extern void _ZN7S1993C24v106Ev();
extern void _ZN7S1993C24v107Ev();
extern void _ZN7S1993C24v108Ev();
extern void _ZN7S1993C24v109Ev();
extern void _ZN7S1993C24v110Ev();
static  VTBL_ENTRY vtc_S1993C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1993C2[0]),
  (VTBL_ENTRY)&_ZN7S1993C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1993C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v1Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v29Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v30Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v31Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v32Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v33Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v34Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v35Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v36Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v37Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v38Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v39Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v40Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v41Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v42Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v43Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v44Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v45Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v46Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v47Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v48Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v49Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v50Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v51Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v52Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v53Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v54Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v55Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v56Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v57Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v58Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v59Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v60Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v61Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v62Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v63Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v64Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v65Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v66Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v67Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v68Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v69Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1993C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1993C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1993C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1993C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1993C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1993C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1993C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1993C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1993C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1993C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1993C24v110Ev,
};
extern VTBL_ENTRY _ZTI7S1993C2[];
extern  VTBL_ENTRY _ZTV7S1993C2[];
Class_Descriptor cd_S1993C2 = {  "S1993C2", // class name
  bases_S1993C2, 2,
  &(vtc_S1993C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(952,712), // object size
  NSPAIRA(_ZTI7S1993C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1993C2),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1993C1  : S1993C2 {
  ::S1990C22 s1993c1f0;
  __tsi64 s1993c1f1[8];
  int s1993c1f2;
  virtual  ~S1993C1(); // _ZN7S1993C1D1Ev
  S1993C1(); // tgen
};
//SIG(1 S1993C1) C1{ BC2{ BC3{ BC4{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC5{ BC6{ m Fp Fi FC7{ m} FC8{ m}}} FC9{ BC10{ m Fp Fi FC11{ m} FC12{ m}}} Fi} vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 FC13{ m FC14{ m FL[2]}} FC13 FC13 FC15{ m FC14} FC16{ m FC13} FC17{ m FC13 FC13 FC13 FC13} FC17 FC13 FC13 FC13 Fp FC16 FC18{ m FC19{ m Fp Fi FC20{ m}} Fi} Fi Fp[7] FC6 Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC21{ BC22{ m Fp Fi FC23{ m} FC23}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC24{ m Fp Fi[2] FC8} Fp[2] Fi:16 Fi:16 FC25{ BC10} FC26{ m Fp Fi[2] FC7} FC27{ m Fp Fi[2] FC12} Fp[2] Fi:24 Fi:8 Fp} vd v102 v103 v104 v105 v106 v107 v108 v109 v110 Fp Fc FC28{ m FC26 FC5 FC24 FC5} FC18} vd FC29{ m Fp Fi FC20 FC11} FL[8] Fi}


 S1993C1 ::~S1993C1(){ note_dtor("S1993C1", this);}
S1993C1 ::S1993C1(){ note_ctor("S1993C1", this);} // tgen

static void Test_S1993C1()
{
  extern Class_Descriptor cd_S1993C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(131,199)];
    init_test(&cd_S1993C1, buf);
    S1993C1 *dp, &lv = *(dp=new (buf) S1993C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1040,792), "sizeof(S1993C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1993C1)");
    check_base_class_offset(lv, (S1993C4*)(S1993C3*)(S1993C2*), 0, "S1993C1");
    check_base_class_offset(lv, (S1993C3*)(S1993C2*), 0, "S1993C1");
    check_base_class_offset(lv, (S1993C2*), 0, "S1993C1");
    check_field_offset(lv, s1993c1f0, ABISELECT(952,712), "S1993C1.s1993c1f0");
    check_field_offset(lv, s1993c1f1, ABISELECT(968,724), "S1993C1.s1993c1f1");
    check_field_offset(lv, s1993c1f2, ABISELECT(1032,788), "S1993C1.s1993c1f2");
    test_class_info(&lv, &cd_S1993C1);
    dp->~S1993C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1993C1(Test_S1993C1, "S1993C1", ABISELECT(1040,792));

#else // __cplusplus

extern void _ZN7S1993C1C1Ev();
extern void _ZN7S1993C1D1Ev();
Name_Map name_map_S1993C1[] = {
  NSPAIR(_ZN7S1993C1C1Ev),
  NSPAIR(_ZN7S1993C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1993C4;
extern VTBL_ENTRY _ZTI7S1993C4[];
extern  VTBL_ENTRY _ZTV7S1993C4[];
extern Class_Descriptor cd_S1993C3;
extern VTBL_ENTRY _ZTI7S1993C3[];
extern  VTBL_ENTRY _ZTV7S1993C3[];
extern Class_Descriptor cd_S1993C2;
extern VTBL_ENTRY _ZTI7S1993C2[];
extern  VTBL_ENTRY _ZTV7S1993C2[];
static Base_Class bases_S1993C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1993C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1993C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1993C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1993C1[];
extern void _ZN7S1993C1D1Ev();
extern void _ZN7S1993C1D0Ev();
extern void _ZN7S1993C42v1Ev();
extern void _ZN7S1993C42v2Ev();
extern void _ZN7S1993C42v3Ev();
extern void _ZN7S1993C42v4Ev();
extern void _ZN7S1993C42v5Ev();
extern void _ZN7S1993C42v6Ev();
extern void _ZN7S1993C42v7Ev();
extern void _ZN7S1993C42v8Ev();
extern void _ZN7S1993C42v9Ev();
extern void _ZN7S1993C43v10Ev();
extern void _ZN7S1993C43v11Ev();
extern void _ZN7S1993C43v12Ev();
extern void _ZN7S1993C43v13Ev();
extern void _ZN7S1993C43v14Ev();
extern void _ZN7S1993C43v15Ev();
extern void _ZN7S1993C43v16Ev();
extern void _ZN7S1993C43v17Ev();
extern void _ZN7S1993C43v18Ev();
extern void _ZN7S1993C43v19Ev();
extern void _ZN7S1993C43v20Ev();
extern void _ZN7S1993C43v21Ev();
extern void _ZN7S1993C43v22Ev();
extern void _ZN7S1993C43v23Ev();
extern void _ZN7S1993C33v24Ev();
extern void _ZN7S1993C33v25Ev();
extern void _ZN7S1993C33v26Ev();
extern void _ZN7S1993C33v27Ev();
extern void _ZN7S1993C33v28Ev();
extern void _ZN7S1993C33v29Ev();
extern void _ZN7S1993C33v30Ev();
extern void _ZN7S1993C33v31Ev();
extern void _ZN7S1993C33v32Ev();
extern void _ZN7S1993C33v33Ev();
extern void _ZN7S1993C33v34Ev();
extern void _ZN7S1993C33v35Ev();
extern void _ZN7S1993C33v36Ev();
extern void _ZN7S1993C33v37Ev();
extern void _ZN7S1993C33v38Ev();
extern void _ZN7S1993C33v39Ev();
extern void _ZN7S1993C33v40Ev();
extern void _ZN7S1993C33v41Ev();
extern void _ZN7S1993C33v42Ev();
extern void _ZN7S1993C33v43Ev();
extern void _ZN7S1993C33v44Ev();
extern void _ZN7S1993C33v45Ev();
extern void _ZN7S1993C33v46Ev();
extern void _ZN7S1993C33v47Ev();
extern void _ZN7S1993C33v48Ev();
extern void _ZN7S1993C33v49Ev();
extern void _ZN7S1993C33v50Ev();
extern void _ZN7S1993C33v51Ev();
extern void _ZN7S1993C33v52Ev();
extern void _ZN7S1993C33v53Ev();
extern void _ZN7S1993C33v54Ev();
extern void _ZN7S1993C33v55Ev();
extern void _ZN7S1993C33v56Ev();
extern void _ZN7S1993C33v57Ev();
extern void _ZN7S1993C33v58Ev();
extern void _ZN7S1993C33v59Ev();
extern void _ZN7S1993C33v60Ev();
extern void _ZN7S1993C33v61Ev();
extern void _ZN7S1993C33v62Ev();
extern void _ZN7S1993C33v63Ev();
extern void _ZN7S1993C33v64Ev();
extern void _ZN7S1993C33v65Ev();
extern void _ZN7S1993C33v66Ev();
extern void _ZN7S1993C33v67Ev();
extern void _ZN7S1993C33v68Ev();
extern void _ZN7S1993C33v69Ev();
extern void _ZN7S1993C33v70Ev();
extern void _ZN7S1993C33v71Ev();
extern void _ZN7S1993C33v72Ev();
extern void _ZN7S1993C33v73Ev();
extern void _ZN7S1993C33v74Ev();
extern void _ZN7S1993C33v75Ev();
extern void _ZN7S1993C33v76Ev();
extern void _ZN7S1993C33v77Ev();
extern void _ZN7S1993C33v78Ev();
extern void _ZN7S1993C33v79Ev();
extern void _ZN7S1993C33v80Ev();
extern void _ZN7S1993C33v81Ev();
extern void _ZN7S1993C33v82Ev();
extern void _ZN7S1993C33v83Ev();
extern void _ZN7S1993C33v84Ev();
extern void _ZN7S1993C33v85Ev();
extern void _ZN7S1993C33v86Ev();
extern void _ZN7S1993C33v87Ev();
extern void _ZN7S1993C33v88Ev();
extern void _ZN7S1993C33v89Ev();
extern void _ZN7S1993C33v90Ev();
extern void _ZN7S1993C33v91Ev();
extern void _ZN7S1993C33v92Ev();
extern void _ZN7S1993C33v93Ev();
extern void _ZN7S1993C33v94Ev();
extern void _ZN7S1993C33v95Ev();
extern void _ZN7S1993C33v96Ev();
extern void _ZN7S1993C33v97Ev();
extern void _ZN7S1993C33v98Ev();
extern void _ZN7S1993C33v99Ev();
extern void _ZN7S1993C34v100Ev();
extern void _ZN7S1993C34v101Ev();
extern void _ZN7S1993C24v102Ev();
extern void _ZN7S1993C24v103Ev();
extern void _ZN7S1993C24v104Ev();
extern void _ZN7S1993C24v105Ev();
extern void _ZN7S1993C24v106Ev();
extern void _ZN7S1993C24v107Ev();
extern void _ZN7S1993C24v108Ev();
extern void _ZN7S1993C24v109Ev();
extern void _ZN7S1993C24v110Ev();
static  VTBL_ENTRY vtc_S1993C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1993C1[0]),
  (VTBL_ENTRY)&_ZN7S1993C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1993C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v1Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1993C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1993C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v29Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v30Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v31Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v32Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v33Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v34Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v35Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v36Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v37Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v38Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v39Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v40Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v41Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v42Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v43Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v44Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v45Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v46Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v47Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v48Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v49Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v50Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v51Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v52Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v53Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v54Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v55Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v56Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v57Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v58Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v59Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v60Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v61Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v62Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v63Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v64Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v65Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v66Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v67Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v68Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v69Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1993C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1993C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1993C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1993C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1993C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1993C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1993C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1993C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1993C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1993C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1993C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1993C24v110Ev,
};
extern VTBL_ENTRY _ZTI7S1993C1[];
extern  VTBL_ENTRY _ZTV7S1993C1[];
Class_Descriptor cd_S1993C1 = {  "S1993C1", // class name
  bases_S1993C1, 3,
  &(vtc_S1993C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1040,792), // object size
  NSPAIRA(_ZTI7S1993C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1993C1),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1994C4  {
  void *s1994c4f0;
  int s1994c4f1;
  ::S1993C31 s1994c4f2;
  ::S1990C42 s1994c4f3;
  int s1994c4f4;
  virtual  ~S1994C4(); // _ZN7S1994C4D1Ev
  virtual void  v1(); // _ZN7S1994C42v1Ev
  virtual void  v2(); // _ZN7S1994C42v2Ev
  virtual void  v3(); // _ZN7S1994C42v3Ev
  virtual void  v4(); // _ZN7S1994C42v4Ev
  virtual void  v5(); // _ZN7S1994C42v5Ev
  virtual void  v6(); // _ZN7S1994C42v6Ev
  virtual void  v7(); // _ZN7S1994C42v7Ev
  virtual void  v8(); // _ZN7S1994C42v8Ev
  virtual void  v9(); // _ZN7S1994C42v9Ev
  virtual void  v10(); // _ZN7S1994C43v10Ev
  virtual void  v11(); // _ZN7S1994C43v11Ev
  virtual void  v12(); // _ZN7S1994C43v12Ev
  virtual void  v13(); // _ZN7S1994C43v13Ev
  virtual void  v14(); // _ZN7S1994C43v14Ev
  virtual void  v15(); // _ZN7S1994C43v15Ev
  virtual void  v16(); // _ZN7S1994C43v16Ev
  virtual void  v17(); // _ZN7S1994C43v17Ev
  virtual void  v18(); // _ZN7S1994C43v18Ev
  virtual void  v19(); // _ZN7S1994C43v19Ev
  virtual void  v20(); // _ZN7S1994C43v20Ev
  virtual void  v21(); // _ZN7S1994C43v21Ev
  virtual void  v22(); // _ZN7S1994C43v22Ev
  virtual void  v23(); // _ZN7S1994C43v23Ev
  S1994C4(); // tgen
};
//SIG(-1 S1994C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}} FC6{ BC7{ m Fp Fi FC8{ m} FC9{ m}}} Fi}


 S1994C4 ::~S1994C4(){ note_dtor("S1994C4", this);}
void  S1994C4 ::v1(){vfunc_called(this, "_ZN7S1994C42v1Ev");}
void  S1994C4 ::v2(){vfunc_called(this, "_ZN7S1994C42v2Ev");}
void  S1994C4 ::v3(){vfunc_called(this, "_ZN7S1994C42v3Ev");}
void  S1994C4 ::v4(){vfunc_called(this, "_ZN7S1994C42v4Ev");}
void  S1994C4 ::v5(){vfunc_called(this, "_ZN7S1994C42v5Ev");}
void  S1994C4 ::v6(){vfunc_called(this, "_ZN7S1994C42v6Ev");}
void  S1994C4 ::v7(){vfunc_called(this, "_ZN7S1994C42v7Ev");}
void  S1994C4 ::v8(){vfunc_called(this, "_ZN7S1994C42v8Ev");}
void  S1994C4 ::v9(){vfunc_called(this, "_ZN7S1994C42v9Ev");}
void  S1994C4 ::v10(){vfunc_called(this, "_ZN7S1994C43v10Ev");}
void  S1994C4 ::v11(){vfunc_called(this, "_ZN7S1994C43v11Ev");}
void  S1994C4 ::v12(){vfunc_called(this, "_ZN7S1994C43v12Ev");}
void  S1994C4 ::v13(){vfunc_called(this, "_ZN7S1994C43v13Ev");}
void  S1994C4 ::v14(){vfunc_called(this, "_ZN7S1994C43v14Ev");}
void  S1994C4 ::v15(){vfunc_called(this, "_ZN7S1994C43v15Ev");}
void  S1994C4 ::v16(){vfunc_called(this, "_ZN7S1994C43v16Ev");}
void  S1994C4 ::v17(){vfunc_called(this, "_ZN7S1994C43v17Ev");}
void  S1994C4 ::v18(){vfunc_called(this, "_ZN7S1994C43v18Ev");}
void  S1994C4 ::v19(){vfunc_called(this, "_ZN7S1994C43v19Ev");}
void  S1994C4 ::v20(){vfunc_called(this, "_ZN7S1994C43v20Ev");}
void  S1994C4 ::v21(){vfunc_called(this, "_ZN7S1994C43v21Ev");}
void  S1994C4 ::v22(){vfunc_called(this, "_ZN7S1994C43v22Ev");}
void  S1994C4 ::v23(){vfunc_called(this, "_ZN7S1994C43v23Ev");}
S1994C4 ::S1994C4(){ note_ctor("S1994C4", this);} // tgen

static void Test_S1994C4()
{
  extern Class_Descriptor cd_S1994C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_S1994C4, buf);
    S1994C4 *dp, &lv = *(dp=new (buf) S1994C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(S1994C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1994C4)");
    check_field_offset(lv, s1994c4f0, ABISELECT(8,4), "S1994C4.s1994c4f0");
    check_field_offset(lv, s1994c4f1, ABISELECT(16,8), "S1994C4.s1994c4f1");
    check_field_offset(lv, s1994c4f2, ABISELECT(24,12), "S1994C4.s1994c4f2");
    check_field_offset(lv, s1994c4f3, ABISELECT(40,24), "S1994C4.s1994c4f3");
    check_field_offset(lv, s1994c4f4, ABISELECT(56,36), "S1994C4.s1994c4f4");
    test_class_info(&lv, &cd_S1994C4);
    dp->~S1994C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1994C4(Test_S1994C4, "S1994C4", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN7S1994C4C1Ev();
extern void _ZN7S1994C4D1Ev();
Name_Map name_map_S1994C4[] = {
  NSPAIR(_ZN7S1994C4C1Ev),
  NSPAIR(_ZN7S1994C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1994C4[];
extern void _ZN7S1994C4D1Ev();
extern void _ZN7S1994C4D0Ev();
extern void _ZN7S1994C42v1Ev();
extern void _ZN7S1994C42v2Ev();
extern void _ZN7S1994C42v3Ev();
extern void _ZN7S1994C42v4Ev();
extern void _ZN7S1994C42v5Ev();
extern void _ZN7S1994C42v6Ev();
extern void _ZN7S1994C42v7Ev();
extern void _ZN7S1994C42v8Ev();
extern void _ZN7S1994C42v9Ev();
extern void _ZN7S1994C43v10Ev();
extern void _ZN7S1994C43v11Ev();
extern void _ZN7S1994C43v12Ev();
extern void _ZN7S1994C43v13Ev();
extern void _ZN7S1994C43v14Ev();
extern void _ZN7S1994C43v15Ev();
extern void _ZN7S1994C43v16Ev();
extern void _ZN7S1994C43v17Ev();
extern void _ZN7S1994C43v18Ev();
extern void _ZN7S1994C43v19Ev();
extern void _ZN7S1994C43v20Ev();
extern void _ZN7S1994C43v21Ev();
extern void _ZN7S1994C43v22Ev();
extern void _ZN7S1994C43v23Ev();
static  VTBL_ENTRY vtc_S1994C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1994C4[0]),
  (VTBL_ENTRY)&_ZN7S1994C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1994C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v1Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v23Ev,
};
extern VTBL_ENTRY _ZTI7S1994C4[];
extern  VTBL_ENTRY _ZTV7S1994C4[];
Class_Descriptor cd_S1994C4 = {  "S1994C4", // class name
  0,0,//no base classes
  &(vtc_S1994C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI7S1994C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1994C4),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1994C3  : S1994C4 {
  ::S1993C15 s1994c3f0;
  ::S1993C15 s1994c3f1;
  ::S1993C15 s1994c3f2;
  ::S1990C13_nt s1994c3f3;
  ::S1990C17_nt s1994c3f4;
  ::S1990C18_nt s1994c3f5;
  ::S1990C18_nt s1994c3f6;
  ::S1993C15 s1994c3f7;
  ::S1993C15 s1994c3f8;
  ::S1993C15 s1994c3f9;
  void *s1994c3f10;
  ::S1990C17_nt s1994c3f11;
  ::S1990C19_nt s1994c3f12;
  int s1994c3f13;
  void *s1994c3f14[7];
  ::S1990C43 s1994c3f15;
  int s1994c3f16:8;
  int s1994c3f17:8;
  int s1994c3f18:16;
  int s1994c3f19:16;
  int s1994c3f20:8;
  int s1994c3f21:8;
  int s1994c3f22:8;
  int s1994c3f23:32;
  int s1994c3f24:8;
  int s1994c3f25:4;
  int s1994c3f26:4;
  int s1994c3f27:4;
  int s1994c3f28:4;
  int s1994c3f29:4;
  int s1994c3f30:4;
  int s1994c3f31:4;
  int s1994c3f32:4;
  int s1994c3f33:4;
  int s1994c3f34:4;
  unsigned char s1994c3f35:1;
  unsigned char s1994c3f36:1;
  unsigned char s1994c3f37:1;
  unsigned char s1994c3f38:1;
  unsigned char s1994c3f39:1;
  unsigned char s1994c3f40:1;
  unsigned char s1994c3f41:1;
  unsigned char s1994c3f42:1;
  unsigned char s1994c3f43:1;
  unsigned char s1994c3f44:1;
  unsigned char s1994c3f45:1;
  unsigned char s1994c3f46:1;
  unsigned char s1994c3f47:1;
  unsigned char s1994c3f48:1;
  unsigned char s1994c3f49:1;
  unsigned char s1994c3f50:1;
  unsigned char s1994c3f51:1;
  unsigned char s1994c3f52:1;
  unsigned char s1994c3f53:1;
  unsigned char s1994c3f54:1;
  unsigned char s1994c3f55:1;
  unsigned char s1994c3f56:1;
  unsigned char s1994c3f57:1;
  unsigned char s1994c3f58:1;
  unsigned char s1994c3f59:1;
  unsigned char s1994c3f60:1;
  unsigned char s1994c3f61:1;
  unsigned char s1994c3f62:1;
  unsigned char s1994c3f63:1;
  unsigned char s1994c3f64:1;
  unsigned char s1994c3f65:1;
  unsigned char s1994c3f66:1;
  unsigned char s1994c3f67:1;
  unsigned char s1994c3f68:1;
  unsigned char s1994c3f69:1;
  unsigned char s1994c3f70:1;
  unsigned char s1994c3f71:1;
  unsigned char s1994c3f72:1;
  unsigned char s1994c3f73:1;
  unsigned char s1994c3f74:1;
  unsigned char s1994c3f75:1;
  int s1994c3f76[7];
  void *s1994c3f77[6];
  int s1994c3f78:8;
  int s1994c3f79:8;
  int s1994c3f80:8;
  int s1994c3f81:8;
  int s1994c3f82:8;
  int s1994c3f83:8;
  ::S1990C25 s1994c3f84;
  void *s1994c3f85[4];
  int s1994c3f86:8;
  int s1994c3f87:8;
  int s1994c3f88:8;
  int s1994c3f89:8;
  int s1994c3f90:8;
  int s1994c3f91:16;
  int s1994c3f92:16;
  int s1994c3f93:16;
  int s1994c3f94:4;
  int s1994c3f95:4;
  int s1994c3f96:4;
  int s1994c3f97:4;
  int s1994c3f98:4;
  int s1994c3f99:4;
  int s1994c3f100:4;
  int s1994c3f101:4;
  int s1994c3f102:4;
  int s1994c3f103:4;
  int s1994c3f104:4;
  int s1994c3f105:4;
  int s1994c3f106:8;
  int s1994c3f107:8;
  int s1994c3f108:8;
  void *s1994c3f109[7];
  ::S1990C46 s1994c3f110;
  void *s1994c3f111[2];
  int s1994c3f112:16;
  int s1994c3f113:16;
  ::S1990C5_nt s1994c3f114;
  ::S1990C37 s1994c3f115;
  ::S1990C29_nt s1994c3f116;
  void *s1994c3f117[2];
  int s1994c3f118:24;
  int s1994c3f119:8;
  void *s1994c3f120;
  virtual  ~S1994C3(); // _ZN7S1994C3D1Ev
  virtual void  v24(); // _ZN7S1994C33v24Ev
  virtual void  v25(); // _ZN7S1994C33v25Ev
  virtual void  v26(); // _ZN7S1994C33v26Ev
  virtual void  v27(); // _ZN7S1994C33v27Ev
  virtual void  v28(); // _ZN7S1994C33v28Ev
  virtual void  v29(); // _ZN7S1994C33v29Ev
  virtual void  v30(); // _ZN7S1994C33v30Ev
  virtual void  v31(); // _ZN7S1994C33v31Ev
  virtual void  v32(); // _ZN7S1994C33v32Ev
  virtual void  v33(); // _ZN7S1994C33v33Ev
  virtual void  v34(); // _ZN7S1994C33v34Ev
  virtual void  v35(); // _ZN7S1994C33v35Ev
  virtual void  v36(); // _ZN7S1994C33v36Ev
  virtual void  v37(); // _ZN7S1994C33v37Ev
  virtual void  v38(); // _ZN7S1994C33v38Ev
  virtual void  v39(); // _ZN7S1994C33v39Ev
  virtual void  v40(); // _ZN7S1994C33v40Ev
  virtual void  v41(); // _ZN7S1994C33v41Ev
  virtual void  v42(); // _ZN7S1994C33v42Ev
  virtual void  v43(); // _ZN7S1994C33v43Ev
  virtual void  v44(); // _ZN7S1994C33v44Ev
  virtual void  v45(); // _ZN7S1994C33v45Ev
  virtual void  v46(); // _ZN7S1994C33v46Ev
  virtual void  v47(); // _ZN7S1994C33v47Ev
  virtual void  v48(); // _ZN7S1994C33v48Ev
  virtual void  v49(); // _ZN7S1994C33v49Ev
  virtual void  v50(); // _ZN7S1994C33v50Ev
  virtual void  v51(); // _ZN7S1994C33v51Ev
  virtual void  v52(); // _ZN7S1994C33v52Ev
  virtual void  v53(); // _ZN7S1994C33v53Ev
  virtual void  v54(); // _ZN7S1994C33v54Ev
  virtual void  v55(); // _ZN7S1994C33v55Ev
  virtual void  v56(); // _ZN7S1994C33v56Ev
  virtual void  v57(); // _ZN7S1994C33v57Ev
  virtual void  v58(); // _ZN7S1994C33v58Ev
  virtual void  v59(); // _ZN7S1994C33v59Ev
  virtual void  v60(); // _ZN7S1994C33v60Ev
  virtual void  v61(); // _ZN7S1994C33v61Ev
  virtual void  v62(); // _ZN7S1994C33v62Ev
  virtual void  v63(); // _ZN7S1994C33v63Ev
  virtual void  v64(); // _ZN7S1994C33v64Ev
  virtual void  v65(); // _ZN7S1994C33v65Ev
  virtual void  v66(); // _ZN7S1994C33v66Ev
  virtual void  v67(); // _ZN7S1994C33v67Ev
  virtual void  v68(); // _ZN7S1994C33v68Ev
  virtual void  v69(); // _ZN7S1994C33v69Ev
  virtual void  v70(); // _ZN7S1994C33v70Ev
  virtual void  v71(); // _ZN7S1994C33v71Ev
  virtual void  v72(); // _ZN7S1994C33v72Ev
  virtual void  v73(); // _ZN7S1994C33v73Ev
  virtual void  v74(); // _ZN7S1994C33v74Ev
  virtual void  v75(); // _ZN7S1994C33v75Ev
  virtual void  v76(); // _ZN7S1994C33v76Ev
  virtual void  v77(); // _ZN7S1994C33v77Ev
  virtual void  v78(); // _ZN7S1994C33v78Ev
  virtual void  v79(); // _ZN7S1994C33v79Ev
  virtual void  v80(); // _ZN7S1994C33v80Ev
  virtual void  v81(); // _ZN7S1994C33v81Ev
  virtual void  v82(); // _ZN7S1994C33v82Ev
  virtual void  v83(); // _ZN7S1994C33v83Ev
  virtual void  v84(); // _ZN7S1994C33v84Ev
  virtual void  v85(); // _ZN7S1994C33v85Ev
  virtual void  v86(); // _ZN7S1994C33v86Ev
  virtual void  v87(); // _ZN7S1994C33v87Ev
  virtual void  v88(); // _ZN7S1994C33v88Ev
  virtual void  v89(); // _ZN7S1994C33v89Ev
  virtual void  v90(); // _ZN7S1994C33v90Ev
  virtual void  v91(); // _ZN7S1994C33v91Ev
  virtual void  v92(); // _ZN7S1994C33v92Ev
  virtual void  v93(); // _ZN7S1994C33v93Ev
  virtual void  v94(); // _ZN7S1994C33v94Ev
  virtual void  v95(); // _ZN7S1994C33v95Ev
  virtual void  v96(); // _ZN7S1994C33v96Ev
  virtual void  v97(); // _ZN7S1994C33v97Ev
  virtual void  v98(); // _ZN7S1994C33v98Ev
  virtual void  v99(); // _ZN7S1994C33v99Ev
  virtual void  v100(); // _ZN7S1994C34v100Ev
  virtual void  v101(); // _ZN7S1994C34v101Ev
  S1994C3(); // tgen
};
//SIG(-1 S1994C3) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fp Fi FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}} FC7{ BC8{ m Fp Fi FC9{ m} FC10{ m}}} Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 FC11{ m FC12{ m FL[2]}} FC11 FC11 FC13{ m FC12} FC14{ m FC13} FC15{ m FC13 FC13 FC13 FC13} FC15 FC11 FC11 FC11 Fp FC14 FC16{ m FC17{ m Fp Fi FC18{ m}} Fi} Fi Fp[7] FC8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC19{ BC4} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC20{ m Fp Fi[2] FC10} Fp[2] Fi:16 Fi:16 FC21{ BC22{ m Fp Fi FC23{ m} FC23}} FC24{ m Fp Fi[2] FC9} FC25{ m Fp Fi[2] FC6} Fp[2] Fi:24 Fi:8 Fp}


 S1994C3 ::~S1994C3(){ note_dtor("S1994C3", this);}
void  S1994C3 ::v24(){vfunc_called(this, "_ZN7S1994C33v24Ev");}
void  S1994C3 ::v25(){vfunc_called(this, "_ZN7S1994C33v25Ev");}
void  S1994C3 ::v26(){vfunc_called(this, "_ZN7S1994C33v26Ev");}
void  S1994C3 ::v27(){vfunc_called(this, "_ZN7S1994C33v27Ev");}
void  S1994C3 ::v28(){vfunc_called(this, "_ZN7S1994C33v28Ev");}
void  S1994C3 ::v29(){vfunc_called(this, "_ZN7S1994C33v29Ev");}
void  S1994C3 ::v30(){vfunc_called(this, "_ZN7S1994C33v30Ev");}
void  S1994C3 ::v31(){vfunc_called(this, "_ZN7S1994C33v31Ev");}
void  S1994C3 ::v32(){vfunc_called(this, "_ZN7S1994C33v32Ev");}
void  S1994C3 ::v33(){vfunc_called(this, "_ZN7S1994C33v33Ev");}
void  S1994C3 ::v34(){vfunc_called(this, "_ZN7S1994C33v34Ev");}
void  S1994C3 ::v35(){vfunc_called(this, "_ZN7S1994C33v35Ev");}
void  S1994C3 ::v36(){vfunc_called(this, "_ZN7S1994C33v36Ev");}
void  S1994C3 ::v37(){vfunc_called(this, "_ZN7S1994C33v37Ev");}
void  S1994C3 ::v38(){vfunc_called(this, "_ZN7S1994C33v38Ev");}
void  S1994C3 ::v39(){vfunc_called(this, "_ZN7S1994C33v39Ev");}
void  S1994C3 ::v40(){vfunc_called(this, "_ZN7S1994C33v40Ev");}
void  S1994C3 ::v41(){vfunc_called(this, "_ZN7S1994C33v41Ev");}
void  S1994C3 ::v42(){vfunc_called(this, "_ZN7S1994C33v42Ev");}
void  S1994C3 ::v43(){vfunc_called(this, "_ZN7S1994C33v43Ev");}
void  S1994C3 ::v44(){vfunc_called(this, "_ZN7S1994C33v44Ev");}
void  S1994C3 ::v45(){vfunc_called(this, "_ZN7S1994C33v45Ev");}
void  S1994C3 ::v46(){vfunc_called(this, "_ZN7S1994C33v46Ev");}
void  S1994C3 ::v47(){vfunc_called(this, "_ZN7S1994C33v47Ev");}
void  S1994C3 ::v48(){vfunc_called(this, "_ZN7S1994C33v48Ev");}
void  S1994C3 ::v49(){vfunc_called(this, "_ZN7S1994C33v49Ev");}
void  S1994C3 ::v50(){vfunc_called(this, "_ZN7S1994C33v50Ev");}
void  S1994C3 ::v51(){vfunc_called(this, "_ZN7S1994C33v51Ev");}
void  S1994C3 ::v52(){vfunc_called(this, "_ZN7S1994C33v52Ev");}
void  S1994C3 ::v53(){vfunc_called(this, "_ZN7S1994C33v53Ev");}
void  S1994C3 ::v54(){vfunc_called(this, "_ZN7S1994C33v54Ev");}
void  S1994C3 ::v55(){vfunc_called(this, "_ZN7S1994C33v55Ev");}
void  S1994C3 ::v56(){vfunc_called(this, "_ZN7S1994C33v56Ev");}
void  S1994C3 ::v57(){vfunc_called(this, "_ZN7S1994C33v57Ev");}
void  S1994C3 ::v58(){vfunc_called(this, "_ZN7S1994C33v58Ev");}
void  S1994C3 ::v59(){vfunc_called(this, "_ZN7S1994C33v59Ev");}
void  S1994C3 ::v60(){vfunc_called(this, "_ZN7S1994C33v60Ev");}
void  S1994C3 ::v61(){vfunc_called(this, "_ZN7S1994C33v61Ev");}
void  S1994C3 ::v62(){vfunc_called(this, "_ZN7S1994C33v62Ev");}
void  S1994C3 ::v63(){vfunc_called(this, "_ZN7S1994C33v63Ev");}
void  S1994C3 ::v64(){vfunc_called(this, "_ZN7S1994C33v64Ev");}
void  S1994C3 ::v65(){vfunc_called(this, "_ZN7S1994C33v65Ev");}
void  S1994C3 ::v66(){vfunc_called(this, "_ZN7S1994C33v66Ev");}
void  S1994C3 ::v67(){vfunc_called(this, "_ZN7S1994C33v67Ev");}
void  S1994C3 ::v68(){vfunc_called(this, "_ZN7S1994C33v68Ev");}
void  S1994C3 ::v69(){vfunc_called(this, "_ZN7S1994C33v69Ev");}
void  S1994C3 ::v70(){vfunc_called(this, "_ZN7S1994C33v70Ev");}
void  S1994C3 ::v71(){vfunc_called(this, "_ZN7S1994C33v71Ev");}
void  S1994C3 ::v72(){vfunc_called(this, "_ZN7S1994C33v72Ev");}
void  S1994C3 ::v73(){vfunc_called(this, "_ZN7S1994C33v73Ev");}
void  S1994C3 ::v74(){vfunc_called(this, "_ZN7S1994C33v74Ev");}
void  S1994C3 ::v75(){vfunc_called(this, "_ZN7S1994C33v75Ev");}
void  S1994C3 ::v76(){vfunc_called(this, "_ZN7S1994C33v76Ev");}
void  S1994C3 ::v77(){vfunc_called(this, "_ZN7S1994C33v77Ev");}
void  S1994C3 ::v78(){vfunc_called(this, "_ZN7S1994C33v78Ev");}
void  S1994C3 ::v79(){vfunc_called(this, "_ZN7S1994C33v79Ev");}
void  S1994C3 ::v80(){vfunc_called(this, "_ZN7S1994C33v80Ev");}
void  S1994C3 ::v81(){vfunc_called(this, "_ZN7S1994C33v81Ev");}
void  S1994C3 ::v82(){vfunc_called(this, "_ZN7S1994C33v82Ev");}
void  S1994C3 ::v83(){vfunc_called(this, "_ZN7S1994C33v83Ev");}
void  S1994C3 ::v84(){vfunc_called(this, "_ZN7S1994C33v84Ev");}
void  S1994C3 ::v85(){vfunc_called(this, "_ZN7S1994C33v85Ev");}
void  S1994C3 ::v86(){vfunc_called(this, "_ZN7S1994C33v86Ev");}
void  S1994C3 ::v87(){vfunc_called(this, "_ZN7S1994C33v87Ev");}
void  S1994C3 ::v88(){vfunc_called(this, "_ZN7S1994C33v88Ev");}
void  S1994C3 ::v89(){vfunc_called(this, "_ZN7S1994C33v89Ev");}
void  S1994C3 ::v90(){vfunc_called(this, "_ZN7S1994C33v90Ev");}
void  S1994C3 ::v91(){vfunc_called(this, "_ZN7S1994C33v91Ev");}
void  S1994C3 ::v92(){vfunc_called(this, "_ZN7S1994C33v92Ev");}
void  S1994C3 ::v93(){vfunc_called(this, "_ZN7S1994C33v93Ev");}
void  S1994C3 ::v94(){vfunc_called(this, "_ZN7S1994C33v94Ev");}
void  S1994C3 ::v95(){vfunc_called(this, "_ZN7S1994C33v95Ev");}
void  S1994C3 ::v96(){vfunc_called(this, "_ZN7S1994C33v96Ev");}
void  S1994C3 ::v97(){vfunc_called(this, "_ZN7S1994C33v97Ev");}
void  S1994C3 ::v98(){vfunc_called(this, "_ZN7S1994C33v98Ev");}
void  S1994C3 ::v99(){vfunc_called(this, "_ZN7S1994C33v99Ev");}
void  S1994C3 ::v100(){vfunc_called(this, "_ZN7S1994C34v100Ev");}
void  S1994C3 ::v101(){vfunc_called(this, "_ZN7S1994C34v101Ev");}
S1994C3 ::S1994C3(){ note_ctor("S1994C3", this);} // tgen

static void Test_S1994C3()
{
  extern Class_Descriptor cd_S1994C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(105,159)];
    init_test(&cd_S1994C3, buf);
    S1994C3 *dp, &lv = *(dp=new (buf) S1994C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(832,632), "sizeof(S1994C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1994C3)");
    check_base_class_offset(lv, (S1994C4*), 0, "S1994C3");
    check_field_offset(lv, s1994c3f0, ABISELECT(64,40), "S1994C3.s1994c3f0");
    check_field_offset(lv, s1994c3f1, ABISELECT(80,56), "S1994C3.s1994c3f1");
    check_field_offset(lv, s1994c3f2, ABISELECT(96,72), "S1994C3.s1994c3f2");
    check_field_offset(lv, s1994c3f3, ABISELECT(112,88), "S1994C3.s1994c3f3");
    check_field_offset(lv, s1994c3f4, ABISELECT(128,104), "S1994C3.s1994c3f4");
    check_field_offset(lv, s1994c3f5, ABISELECT(144,120), "S1994C3.s1994c3f5");
    check_field_offset(lv, s1994c3f6, ABISELECT(208,184), "S1994C3.s1994c3f6");
    check_field_offset(lv, s1994c3f7, ABISELECT(272,248), "S1994C3.s1994c3f7");
    check_field_offset(lv, s1994c3f8, ABISELECT(288,264), "S1994C3.s1994c3f8");
    check_field_offset(lv, s1994c3f9, ABISELECT(304,280), "S1994C3.s1994c3f9");
    check_field_offset(lv, s1994c3f10, ABISELECT(320,296), "S1994C3.s1994c3f10");
    check_field_offset(lv, s1994c3f11, ABISELECT(328,300), "S1994C3.s1994c3f11");
    check_field_offset(lv, s1994c3f12, ABISELECT(344,316), "S1994C3.s1994c3f12");
    check_field_offset(lv, s1994c3f13, ABISELECT(368,332), "S1994C3.s1994c3f13");
    check_field_offset(lv, s1994c3f14, ABISELECT(376,336), "S1994C3.s1994c3f14");
    check_field_offset(lv, s1994c3f15, ABISELECT(432,364), "S1994C3.s1994c3f15");
    set_bf_and_test(lv, s1994c3f16, ABISELECT(448,376), 0, 8, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f16, ABISELECT(448,376), 0, 8, hide_sll(1LL<<7), "S1994C3");
    set_bf_and_test(lv, s1994c3f17, ABISELECT(449,377), 0, 8, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f17, ABISELECT(449,377), 0, 8, hide_sll(1LL<<7), "S1994C3");
    set_bf_and_test(lv, s1994c3f18, ABISELECT(450,378), 0, 16, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f18, ABISELECT(450,378), 0, 16, hide_sll(1LL<<15), "S1994C3");
    set_bf_and_test(lv, s1994c3f19, ABISELECT(452,380), 0, 16, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f19, ABISELECT(452,380), 0, 16, hide_sll(1LL<<15), "S1994C3");
    set_bf_and_test(lv, s1994c3f20, ABISELECT(454,382), 0, 8, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f20, ABISELECT(454,382), 0, 8, hide_sll(1LL<<7), "S1994C3");
    set_bf_and_test(lv, s1994c3f21, ABISELECT(455,383), 0, 8, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f21, ABISELECT(455,383), 0, 8, hide_sll(1LL<<7), "S1994C3");
    set_bf_and_test(lv, s1994c3f22, ABISELECT(456,384), 0, 8, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f22, ABISELECT(456,384), 0, 8, hide_sll(1LL<<7), "S1994C3");
    set_bf_and_test(lv, s1994c3f23, ABISELECT(460,388), 0, 32, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f23, ABISELECT(460,388), 0, 32, hide_sll(1LL<<31), "S1994C3");
    set_bf_and_test(lv, s1994c3f24, ABISELECT(464,392), 0, 8, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f24, ABISELECT(464,392), 0, 8, hide_sll(1LL<<7), "S1994C3");
    set_bf_and_test(lv, s1994c3f25, ABISELECT(465,393), 0, 4, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f25, ABISELECT(465,393), 0, 4, hide_sll(1LL<<3), "S1994C3");
    set_bf_and_test(lv, s1994c3f26, ABISELECT(465,393), 4, 4, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f26, ABISELECT(465,393), 4, 4, hide_sll(1LL<<3), "S1994C3");
    set_bf_and_test(lv, s1994c3f27, ABISELECT(466,394), 0, 4, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f27, ABISELECT(466,394), 0, 4, hide_sll(1LL<<3), "S1994C3");
    set_bf_and_test(lv, s1994c3f28, ABISELECT(466,394), 4, 4, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f28, ABISELECT(466,394), 4, 4, hide_sll(1LL<<3), "S1994C3");
    set_bf_and_test(lv, s1994c3f29, ABISELECT(467,395), 0, 4, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f29, ABISELECT(467,395), 0, 4, hide_sll(1LL<<3), "S1994C3");
    set_bf_and_test(lv, s1994c3f30, ABISELECT(467,395), 4, 4, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f30, ABISELECT(467,395), 4, 4, hide_sll(1LL<<3), "S1994C3");
    set_bf_and_test(lv, s1994c3f31, ABISELECT(468,396), 0, 4, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f31, ABISELECT(468,396), 0, 4, hide_sll(1LL<<3), "S1994C3");
    set_bf_and_test(lv, s1994c3f32, ABISELECT(468,396), 4, 4, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f32, ABISELECT(468,396), 4, 4, hide_sll(1LL<<3), "S1994C3");
    set_bf_and_test(lv, s1994c3f33, ABISELECT(469,397), 0, 4, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f33, ABISELECT(469,397), 0, 4, hide_sll(1LL<<3), "S1994C3");
    set_bf_and_test(lv, s1994c3f34, ABISELECT(469,397), 4, 4, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f34, ABISELECT(469,397), 4, 4, hide_sll(1LL<<3), "S1994C3");
    set_bf_and_test(lv, s1994c3f35, ABISELECT(470,398), 0, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f36, ABISELECT(470,398), 1, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f37, ABISELECT(470,398), 2, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f38, ABISELECT(470,398), 3, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f39, ABISELECT(470,398), 4, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f40, ABISELECT(470,398), 5, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f41, ABISELECT(470,398), 6, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f42, ABISELECT(470,398), 7, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f43, ABISELECT(471,399), 0, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f44, ABISELECT(471,399), 1, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f45, ABISELECT(471,399), 2, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f46, ABISELECT(471,399), 3, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f47, ABISELECT(471,399), 4, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f48, ABISELECT(471,399), 5, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f49, ABISELECT(471,399), 6, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f50, ABISELECT(471,399), 7, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f51, ABISELECT(472,400), 0, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f52, ABISELECT(472,400), 1, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f53, ABISELECT(472,400), 2, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f54, ABISELECT(472,400), 3, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f55, ABISELECT(472,400), 4, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f56, ABISELECT(472,400), 5, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f57, ABISELECT(472,400), 6, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f58, ABISELECT(472,400), 7, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f59, ABISELECT(473,401), 0, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f60, ABISELECT(473,401), 1, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f61, ABISELECT(473,401), 2, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f62, ABISELECT(473,401), 3, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f63, ABISELECT(473,401), 4, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f64, ABISELECT(473,401), 5, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f65, ABISELECT(473,401), 6, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f66, ABISELECT(473,401), 7, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f67, ABISELECT(474,402), 0, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f68, ABISELECT(474,402), 1, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f69, ABISELECT(474,402), 2, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f70, ABISELECT(474,402), 3, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f71, ABISELECT(474,402), 4, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f72, ABISELECT(474,402), 5, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f73, ABISELECT(474,402), 6, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f74, ABISELECT(474,402), 7, 1, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f75, ABISELECT(475,403), 0, 1, 1, "S1994C3");
    check_field_offset(lv, s1994c3f76, ABISELECT(476,404), "S1994C3.s1994c3f76");
    check_field_offset(lv, s1994c3f77, ABISELECT(504,432), "S1994C3.s1994c3f77");
    set_bf_and_test(lv, s1994c3f78, ABISELECT(552,456), 0, 8, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f78, ABISELECT(552,456), 0, 8, hide_sll(1LL<<7), "S1994C3");
    set_bf_and_test(lv, s1994c3f79, ABISELECT(553,457), 0, 8, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f79, ABISELECT(553,457), 0, 8, hide_sll(1LL<<7), "S1994C3");
    set_bf_and_test(lv, s1994c3f80, ABISELECT(554,458), 0, 8, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f80, ABISELECT(554,458), 0, 8, hide_sll(1LL<<7), "S1994C3");
    set_bf_and_test(lv, s1994c3f81, ABISELECT(555,459), 0, 8, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f81, ABISELECT(555,459), 0, 8, hide_sll(1LL<<7), "S1994C3");
    set_bf_and_test(lv, s1994c3f82, ABISELECT(556,460), 0, 8, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f82, ABISELECT(556,460), 0, 8, hide_sll(1LL<<7), "S1994C3");
    set_bf_and_test(lv, s1994c3f83, ABISELECT(557,461), 0, 8, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f83, ABISELECT(557,461), 0, 8, hide_sll(1LL<<7), "S1994C3");
    check_field_offset(lv, s1994c3f84, ABISELECT(560,464), "S1994C3.s1994c3f84");
    check_field_offset(lv, s1994c3f85, ABISELECT(576,476), "S1994C3.s1994c3f85");
    set_bf_and_test(lv, s1994c3f86, ABISELECT(608,492), 0, 8, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f86, ABISELECT(608,492), 0, 8, hide_sll(1LL<<7), "S1994C3");
    set_bf_and_test(lv, s1994c3f87, ABISELECT(609,493), 0, 8, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f87, ABISELECT(609,493), 0, 8, hide_sll(1LL<<7), "S1994C3");
    set_bf_and_test(lv, s1994c3f88, ABISELECT(610,494), 0, 8, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f88, ABISELECT(610,494), 0, 8, hide_sll(1LL<<7), "S1994C3");
    set_bf_and_test(lv, s1994c3f89, ABISELECT(611,495), 0, 8, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f89, ABISELECT(611,495), 0, 8, hide_sll(1LL<<7), "S1994C3");
    set_bf_and_test(lv, s1994c3f90, ABISELECT(612,496), 0, 8, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f90, ABISELECT(612,496), 0, 8, hide_sll(1LL<<7), "S1994C3");
    set_bf_and_test(lv, s1994c3f91, ABISELECT(613,497), 0, 16, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f91, ABISELECT(613,497), 0, 16, hide_sll(1LL<<15), "S1994C3");
    set_bf_and_test(lv, s1994c3f92, ABISELECT(616,500), 0, 16, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f92, ABISELECT(616,500), 0, 16, hide_sll(1LL<<15), "S1994C3");
    set_bf_and_test(lv, s1994c3f93, ABISELECT(618,502), 0, 16, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f93, ABISELECT(618,502), 0, 16, hide_sll(1LL<<15), "S1994C3");
    set_bf_and_test(lv, s1994c3f94, ABISELECT(620,504), 0, 4, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f94, ABISELECT(620,504), 0, 4, hide_sll(1LL<<3), "S1994C3");
    set_bf_and_test(lv, s1994c3f95, ABISELECT(620,504), 4, 4, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f95, ABISELECT(620,504), 4, 4, hide_sll(1LL<<3), "S1994C3");
    set_bf_and_test(lv, s1994c3f96, ABISELECT(621,505), 0, 4, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f96, ABISELECT(621,505), 0, 4, hide_sll(1LL<<3), "S1994C3");
    set_bf_and_test(lv, s1994c3f97, ABISELECT(621,505), 4, 4, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f97, ABISELECT(621,505), 4, 4, hide_sll(1LL<<3), "S1994C3");
    set_bf_and_test(lv, s1994c3f98, ABISELECT(622,506), 0, 4, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f98, ABISELECT(622,506), 0, 4, hide_sll(1LL<<3), "S1994C3");
    set_bf_and_test(lv, s1994c3f99, ABISELECT(622,506), 4, 4, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f99, ABISELECT(622,506), 4, 4, hide_sll(1LL<<3), "S1994C3");
    set_bf_and_test(lv, s1994c3f100, ABISELECT(623,507), 0, 4, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f100, ABISELECT(623,507), 0, 4, hide_sll(1LL<<3), "S1994C3");
    set_bf_and_test(lv, s1994c3f101, ABISELECT(623,507), 4, 4, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f101, ABISELECT(623,507), 4, 4, hide_sll(1LL<<3), "S1994C3");
    set_bf_and_test(lv, s1994c3f102, ABISELECT(624,508), 0, 4, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f102, ABISELECT(624,508), 0, 4, hide_sll(1LL<<3), "S1994C3");
    set_bf_and_test(lv, s1994c3f103, ABISELECT(624,508), 4, 4, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f103, ABISELECT(624,508), 4, 4, hide_sll(1LL<<3), "S1994C3");
    set_bf_and_test(lv, s1994c3f104, ABISELECT(625,509), 0, 4, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f104, ABISELECT(625,509), 0, 4, hide_sll(1LL<<3), "S1994C3");
    set_bf_and_test(lv, s1994c3f105, ABISELECT(625,509), 4, 4, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f105, ABISELECT(625,509), 4, 4, hide_sll(1LL<<3), "S1994C3");
    set_bf_and_test(lv, s1994c3f106, ABISELECT(626,510), 0, 8, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f106, ABISELECT(626,510), 0, 8, hide_sll(1LL<<7), "S1994C3");
    set_bf_and_test(lv, s1994c3f107, ABISELECT(627,511), 0, 8, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f107, ABISELECT(627,511), 0, 8, hide_sll(1LL<<7), "S1994C3");
    set_bf_and_test(lv, s1994c3f108, ABISELECT(628,512), 0, 8, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f108, ABISELECT(628,512), 0, 8, hide_sll(1LL<<7), "S1994C3");
    check_field_offset(lv, s1994c3f109, ABISELECT(632,516), "S1994C3.s1994c3f109");
    check_field_offset(lv, s1994c3f110, ABISELECT(688,544), "S1994C3.s1994c3f110");
    check_field_offset(lv, s1994c3f111, ABISELECT(712,560), "S1994C3.s1994c3f111");
    set_bf_and_test(lv, s1994c3f112, ABISELECT(728,568), 0, 16, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f112, ABISELECT(728,568), 0, 16, hide_sll(1LL<<15), "S1994C3");
    set_bf_and_test(lv, s1994c3f113, ABISELECT(730,570), 0, 16, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f113, ABISELECT(730,570), 0, 16, hide_sll(1LL<<15), "S1994C3");
    check_field_offset(lv, s1994c3f114, ABISELECT(736,572), "S1994C3.s1994c3f114");
    check_field_offset(lv, s1994c3f115, ABISELECT(752,584), "S1994C3.s1994c3f115");
    check_field_offset(lv, s1994c3f116, ABISELECT(776,600), "S1994C3.s1994c3f116");
    check_field_offset(lv, s1994c3f117, ABISELECT(800,616), "S1994C3.s1994c3f117");
    set_bf_and_test(lv, s1994c3f118, ABISELECT(816,624), 0, 24, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f118, ABISELECT(816,624), 0, 24, hide_sll(1LL<<23), "S1994C3");
    set_bf_and_test(lv, s1994c3f119, ABISELECT(819,627), 0, 8, 1, "S1994C3");
    set_bf_and_test(lv, s1994c3f119, ABISELECT(819,627), 0, 8, hide_sll(1LL<<7), "S1994C3");
    check_field_offset(lv, s1994c3f120, ABISELECT(824,628), "S1994C3.s1994c3f120");
    test_class_info(&lv, &cd_S1994C3);
    dp->~S1994C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1994C3(Test_S1994C3, "S1994C3", ABISELECT(832,632));

#else // __cplusplus

extern void _ZN7S1994C3C1Ev();
extern void _ZN7S1994C3D1Ev();
Name_Map name_map_S1994C3[] = {
  NSPAIR(_ZN7S1994C3C1Ev),
  NSPAIR(_ZN7S1994C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1994C4;
extern VTBL_ENTRY _ZTI7S1994C4[];
extern  VTBL_ENTRY _ZTV7S1994C4[];
static Base_Class bases_S1994C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1994C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1994C3[];
extern void _ZN7S1994C3D1Ev();
extern void _ZN7S1994C3D0Ev();
extern void _ZN7S1994C42v1Ev();
extern void _ZN7S1994C42v2Ev();
extern void _ZN7S1994C42v3Ev();
extern void _ZN7S1994C42v4Ev();
extern void _ZN7S1994C42v5Ev();
extern void _ZN7S1994C42v6Ev();
extern void _ZN7S1994C42v7Ev();
extern void _ZN7S1994C42v8Ev();
extern void _ZN7S1994C42v9Ev();
extern void _ZN7S1994C43v10Ev();
extern void _ZN7S1994C43v11Ev();
extern void _ZN7S1994C43v12Ev();
extern void _ZN7S1994C43v13Ev();
extern void _ZN7S1994C43v14Ev();
extern void _ZN7S1994C43v15Ev();
extern void _ZN7S1994C43v16Ev();
extern void _ZN7S1994C43v17Ev();
extern void _ZN7S1994C43v18Ev();
extern void _ZN7S1994C43v19Ev();
extern void _ZN7S1994C43v20Ev();
extern void _ZN7S1994C43v21Ev();
extern void _ZN7S1994C43v22Ev();
extern void _ZN7S1994C43v23Ev();
extern void _ZN7S1994C33v24Ev();
extern void _ZN7S1994C33v25Ev();
extern void _ZN7S1994C33v26Ev();
extern void _ZN7S1994C33v27Ev();
extern void _ZN7S1994C33v28Ev();
extern void _ZN7S1994C33v29Ev();
extern void _ZN7S1994C33v30Ev();
extern void _ZN7S1994C33v31Ev();
extern void _ZN7S1994C33v32Ev();
extern void _ZN7S1994C33v33Ev();
extern void _ZN7S1994C33v34Ev();
extern void _ZN7S1994C33v35Ev();
extern void _ZN7S1994C33v36Ev();
extern void _ZN7S1994C33v37Ev();
extern void _ZN7S1994C33v38Ev();
extern void _ZN7S1994C33v39Ev();
extern void _ZN7S1994C33v40Ev();
extern void _ZN7S1994C33v41Ev();
extern void _ZN7S1994C33v42Ev();
extern void _ZN7S1994C33v43Ev();
extern void _ZN7S1994C33v44Ev();
extern void _ZN7S1994C33v45Ev();
extern void _ZN7S1994C33v46Ev();
extern void _ZN7S1994C33v47Ev();
extern void _ZN7S1994C33v48Ev();
extern void _ZN7S1994C33v49Ev();
extern void _ZN7S1994C33v50Ev();
extern void _ZN7S1994C33v51Ev();
extern void _ZN7S1994C33v52Ev();
extern void _ZN7S1994C33v53Ev();
extern void _ZN7S1994C33v54Ev();
extern void _ZN7S1994C33v55Ev();
extern void _ZN7S1994C33v56Ev();
extern void _ZN7S1994C33v57Ev();
extern void _ZN7S1994C33v58Ev();
extern void _ZN7S1994C33v59Ev();
extern void _ZN7S1994C33v60Ev();
extern void _ZN7S1994C33v61Ev();
extern void _ZN7S1994C33v62Ev();
extern void _ZN7S1994C33v63Ev();
extern void _ZN7S1994C33v64Ev();
extern void _ZN7S1994C33v65Ev();
extern void _ZN7S1994C33v66Ev();
extern void _ZN7S1994C33v67Ev();
extern void _ZN7S1994C33v68Ev();
extern void _ZN7S1994C33v69Ev();
extern void _ZN7S1994C33v70Ev();
extern void _ZN7S1994C33v71Ev();
extern void _ZN7S1994C33v72Ev();
extern void _ZN7S1994C33v73Ev();
extern void _ZN7S1994C33v74Ev();
extern void _ZN7S1994C33v75Ev();
extern void _ZN7S1994C33v76Ev();
extern void _ZN7S1994C33v77Ev();
extern void _ZN7S1994C33v78Ev();
extern void _ZN7S1994C33v79Ev();
extern void _ZN7S1994C33v80Ev();
extern void _ZN7S1994C33v81Ev();
extern void _ZN7S1994C33v82Ev();
extern void _ZN7S1994C33v83Ev();
extern void _ZN7S1994C33v84Ev();
extern void _ZN7S1994C33v85Ev();
extern void _ZN7S1994C33v86Ev();
extern void _ZN7S1994C33v87Ev();
extern void _ZN7S1994C33v88Ev();
extern void _ZN7S1994C33v89Ev();
extern void _ZN7S1994C33v90Ev();
extern void _ZN7S1994C33v91Ev();
extern void _ZN7S1994C33v92Ev();
extern void _ZN7S1994C33v93Ev();
extern void _ZN7S1994C33v94Ev();
extern void _ZN7S1994C33v95Ev();
extern void _ZN7S1994C33v96Ev();
extern void _ZN7S1994C33v97Ev();
extern void _ZN7S1994C33v98Ev();
extern void _ZN7S1994C33v99Ev();
extern void _ZN7S1994C34v100Ev();
extern void _ZN7S1994C34v101Ev();
static  VTBL_ENTRY vtc_S1994C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1994C3[0]),
  (VTBL_ENTRY)&_ZN7S1994C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1994C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v1Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v29Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v30Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v31Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v32Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v33Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v34Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v35Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v36Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v37Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v38Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v39Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v40Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v41Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v42Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v43Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v44Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v45Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v46Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v47Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v48Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v49Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v50Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v51Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v52Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v53Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v54Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v55Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v56Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v57Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v58Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v59Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v60Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v61Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v62Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v63Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v64Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v65Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v66Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v67Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v68Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v69Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1994C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1994C34v101Ev,
};
extern VTBL_ENTRY _ZTI7S1994C3[];
extern  VTBL_ENTRY _ZTV7S1994C3[];
Class_Descriptor cd_S1994C3 = {  "S1994C3", // class name
  bases_S1994C3, 1,
  &(vtc_S1994C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI7S1994C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1994C3),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1994C2  : S1994C3 {
  void *s1994c2f0;
  char s1994c2f1;
  ::S1990C39_nt s1994c2f2;
  ::S1990C19_nt s1994c2f3;
  virtual  ~S1994C2(); // _ZN7S1994C2D1Ev
  virtual void  v102(); // _ZN7S1994C24v102Ev
  virtual void  v103(); // _ZN7S1994C24v103Ev
  virtual void  v104(); // _ZN7S1994C24v104Ev
  virtual void  v105(); // _ZN7S1994C24v105Ev
  virtual void  v106(); // _ZN7S1994C24v106Ev
  virtual void  v107(); // _ZN7S1994C24v107Ev
  virtual void  v108(); // _ZN7S1994C24v108Ev
  virtual void  v109(); // _ZN7S1994C24v109Ev
  virtual void  v110(); // _ZN7S1994C24v110Ev
  S1994C2(); // tgen
};
//SIG(-1 S1994C2) C1{ BC2{ BC3{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 Fp Fi FC4{ BC5{ m Fp Fi FC6{ m} FC7{ m}}} FC8{ BC9{ m Fp Fi FC10{ m} FC11{ m}}} Fi} vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 FC12{ m FC13{ m FL[2]}} FC12 FC12 FC14{ m FC13} FC15{ m FC14} FC16{ m FC14 FC14 FC14 FC14} FC16 FC12 FC12 FC12 Fp FC15 FC17{ m FC18{ m Fp Fi FC19{ m}} Fi} Fi Fp[7] FC9 Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC20{ BC5} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC21{ m Fp Fi[2] FC11} Fp[2] Fi:16 Fi:16 FC22{ BC23{ m Fp Fi FC24{ m} FC24}} FC25{ m Fp Fi[2] FC10} FC26{ m Fp Fi[2] FC7} Fp[2] Fi:24 Fi:8 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fp Fc FC27{ m FC25 FC8 FC21 FC8} FC17}


 S1994C2 ::~S1994C2(){ note_dtor("S1994C2", this);}
void  S1994C2 ::v102(){vfunc_called(this, "_ZN7S1994C24v102Ev");}
void  S1994C2 ::v103(){vfunc_called(this, "_ZN7S1994C24v103Ev");}
void  S1994C2 ::v104(){vfunc_called(this, "_ZN7S1994C24v104Ev");}
void  S1994C2 ::v105(){vfunc_called(this, "_ZN7S1994C24v105Ev");}
void  S1994C2 ::v106(){vfunc_called(this, "_ZN7S1994C24v106Ev");}
void  S1994C2 ::v107(){vfunc_called(this, "_ZN7S1994C24v107Ev");}
void  S1994C2 ::v108(){vfunc_called(this, "_ZN7S1994C24v108Ev");}
void  S1994C2 ::v109(){vfunc_called(this, "_ZN7S1994C24v109Ev");}
void  S1994C2 ::v110(){vfunc_called(this, "_ZN7S1994C24v110Ev");}
S1994C2 ::S1994C2(){ note_ctor("S1994C2", this);} // tgen

static void Test_S1994C2()
{
  extern Class_Descriptor cd_S1994C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(120,179)];
    init_test(&cd_S1994C2, buf);
    S1994C2 *dp, &lv = *(dp=new (buf) S1994C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(952,712), "sizeof(S1994C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1994C2)");
    check_base_class_offset(lv, (S1994C4*)(S1994C3*), 0, "S1994C2");
    check_base_class_offset(lv, (S1994C3*), 0, "S1994C2");
    check_field_offset(lv, s1994c2f0, ABISELECT(832,632), "S1994C2.s1994c2f0");
    check_field_offset(lv, s1994c2f1, ABISELECT(840,636), "S1994C2.s1994c2f1");
    check_field_offset(lv, s1994c2f2, ABISELECT(848,640), "S1994C2.s1994c2f2");
    check_field_offset(lv, s1994c2f3, ABISELECT(928,696), "S1994C2.s1994c2f3");
    test_class_info(&lv, &cd_S1994C2);
    dp->~S1994C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1994C2(Test_S1994C2, "S1994C2", ABISELECT(952,712));

#else // __cplusplus

extern void _ZN7S1994C2C1Ev();
extern void _ZN7S1994C2D1Ev();
Name_Map name_map_S1994C2[] = {
  NSPAIR(_ZN7S1994C2C1Ev),
  NSPAIR(_ZN7S1994C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1994C4;
extern VTBL_ENTRY _ZTI7S1994C4[];
extern  VTBL_ENTRY _ZTV7S1994C4[];
extern Class_Descriptor cd_S1994C3;
extern VTBL_ENTRY _ZTI7S1994C3[];
extern  VTBL_ENTRY _ZTV7S1994C3[];
static Base_Class bases_S1994C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1994C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1994C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1994C2[];
extern void _ZN7S1994C2D1Ev();
extern void _ZN7S1994C2D0Ev();
extern void _ZN7S1994C42v1Ev();
extern void _ZN7S1994C42v2Ev();
extern void _ZN7S1994C42v3Ev();
extern void _ZN7S1994C42v4Ev();
extern void _ZN7S1994C42v5Ev();
extern void _ZN7S1994C42v6Ev();
extern void _ZN7S1994C42v7Ev();
extern void _ZN7S1994C42v8Ev();
extern void _ZN7S1994C42v9Ev();
extern void _ZN7S1994C43v10Ev();
extern void _ZN7S1994C43v11Ev();
extern void _ZN7S1994C43v12Ev();
extern void _ZN7S1994C43v13Ev();
extern void _ZN7S1994C43v14Ev();
extern void _ZN7S1994C43v15Ev();
extern void _ZN7S1994C43v16Ev();
extern void _ZN7S1994C43v17Ev();
extern void _ZN7S1994C43v18Ev();
extern void _ZN7S1994C43v19Ev();
extern void _ZN7S1994C43v20Ev();
extern void _ZN7S1994C43v21Ev();
extern void _ZN7S1994C43v22Ev();
extern void _ZN7S1994C43v23Ev();
extern void _ZN7S1994C33v24Ev();
extern void _ZN7S1994C33v25Ev();
extern void _ZN7S1994C33v26Ev();
extern void _ZN7S1994C33v27Ev();
extern void _ZN7S1994C33v28Ev();
extern void _ZN7S1994C33v29Ev();
extern void _ZN7S1994C33v30Ev();
extern void _ZN7S1994C33v31Ev();
extern void _ZN7S1994C33v32Ev();
extern void _ZN7S1994C33v33Ev();
extern void _ZN7S1994C33v34Ev();
extern void _ZN7S1994C33v35Ev();
extern void _ZN7S1994C33v36Ev();
extern void _ZN7S1994C33v37Ev();
extern void _ZN7S1994C33v38Ev();
extern void _ZN7S1994C33v39Ev();
extern void _ZN7S1994C33v40Ev();
extern void _ZN7S1994C33v41Ev();
extern void _ZN7S1994C33v42Ev();
extern void _ZN7S1994C33v43Ev();
extern void _ZN7S1994C33v44Ev();
extern void _ZN7S1994C33v45Ev();
extern void _ZN7S1994C33v46Ev();
extern void _ZN7S1994C33v47Ev();
extern void _ZN7S1994C33v48Ev();
extern void _ZN7S1994C33v49Ev();
extern void _ZN7S1994C33v50Ev();
extern void _ZN7S1994C33v51Ev();
extern void _ZN7S1994C33v52Ev();
extern void _ZN7S1994C33v53Ev();
extern void _ZN7S1994C33v54Ev();
extern void _ZN7S1994C33v55Ev();
extern void _ZN7S1994C33v56Ev();
extern void _ZN7S1994C33v57Ev();
extern void _ZN7S1994C33v58Ev();
extern void _ZN7S1994C33v59Ev();
extern void _ZN7S1994C33v60Ev();
extern void _ZN7S1994C33v61Ev();
extern void _ZN7S1994C33v62Ev();
extern void _ZN7S1994C33v63Ev();
extern void _ZN7S1994C33v64Ev();
extern void _ZN7S1994C33v65Ev();
extern void _ZN7S1994C33v66Ev();
extern void _ZN7S1994C33v67Ev();
extern void _ZN7S1994C33v68Ev();
extern void _ZN7S1994C33v69Ev();
extern void _ZN7S1994C33v70Ev();
extern void _ZN7S1994C33v71Ev();
extern void _ZN7S1994C33v72Ev();
extern void _ZN7S1994C33v73Ev();
extern void _ZN7S1994C33v74Ev();
extern void _ZN7S1994C33v75Ev();
extern void _ZN7S1994C33v76Ev();
extern void _ZN7S1994C33v77Ev();
extern void _ZN7S1994C33v78Ev();
extern void _ZN7S1994C33v79Ev();
extern void _ZN7S1994C33v80Ev();
extern void _ZN7S1994C33v81Ev();
extern void _ZN7S1994C33v82Ev();
extern void _ZN7S1994C33v83Ev();
extern void _ZN7S1994C33v84Ev();
extern void _ZN7S1994C33v85Ev();
extern void _ZN7S1994C33v86Ev();
extern void _ZN7S1994C33v87Ev();
extern void _ZN7S1994C33v88Ev();
extern void _ZN7S1994C33v89Ev();
extern void _ZN7S1994C33v90Ev();
extern void _ZN7S1994C33v91Ev();
extern void _ZN7S1994C33v92Ev();
extern void _ZN7S1994C33v93Ev();
extern void _ZN7S1994C33v94Ev();
extern void _ZN7S1994C33v95Ev();
extern void _ZN7S1994C33v96Ev();
extern void _ZN7S1994C33v97Ev();
extern void _ZN7S1994C33v98Ev();
extern void _ZN7S1994C33v99Ev();
extern void _ZN7S1994C34v100Ev();
extern void _ZN7S1994C34v101Ev();
extern void _ZN7S1994C24v102Ev();
extern void _ZN7S1994C24v103Ev();
extern void _ZN7S1994C24v104Ev();
extern void _ZN7S1994C24v105Ev();
extern void _ZN7S1994C24v106Ev();
extern void _ZN7S1994C24v107Ev();
extern void _ZN7S1994C24v108Ev();
extern void _ZN7S1994C24v109Ev();
extern void _ZN7S1994C24v110Ev();
static  VTBL_ENTRY vtc_S1994C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1994C2[0]),
  (VTBL_ENTRY)&_ZN7S1994C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1994C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v1Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v29Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v30Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v31Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v32Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v33Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v34Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v35Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v36Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v37Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v38Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v39Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v40Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v41Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v42Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v43Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v44Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v45Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v46Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v47Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v48Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v49Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v50Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v51Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v52Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v53Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v54Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v55Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v56Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v57Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v58Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v59Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v60Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v61Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v62Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v63Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v64Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v65Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v66Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v67Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v68Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v69Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1994C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1994C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1994C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1994C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1994C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1994C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1994C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1994C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1994C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1994C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1994C24v110Ev,
};
extern VTBL_ENTRY _ZTI7S1994C2[];
extern  VTBL_ENTRY _ZTV7S1994C2[];
Class_Descriptor cd_S1994C2 = {  "S1994C2", // class name
  bases_S1994C2, 2,
  &(vtc_S1994C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(952,712), // object size
  NSPAIRA(_ZTI7S1994C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1994C2),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1994C1  : S1994C2 {
  ::S1990C52_nt s1994c1f0;
  ::S1990C52_nt s1994c1f1;
  ::S1990C20_nt s1994c1f2;
  char s1994c1f3;
  void *s1994c1f4;
  virtual  ~S1994C1(); // _ZN7S1994C1D1Ev
  S1994C1(); // tgen
};
//SIG(1 S1994C1) C1{ BC2{ BC3{ BC4{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC5{ BC6{ m Fp Fi FC7{ m} FC8{ m}}} FC9{ BC10{ m Fp Fi FC11{ m} FC12{ m}}} Fi} vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 FC13{ m FC14{ m FL[2]}} FC13 FC13 FC15{ m FC14} FC16{ m FC15} FC17{ m FC15 FC15 FC15 FC15} FC17 FC13 FC13 FC13 Fp FC16 FC18{ m FC19{ m Fp Fi FC20{ m}} Fi} Fi Fp[7] FC10 Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC21{ BC6} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC22{ m Fp Fi[2] FC12} Fp[2] Fi:16 Fi:16 FC23{ BC24{ m Fp Fi FC25{ m} FC25}} FC26{ m Fp Fi[2] FC11} FC27{ m Fp Fi[2] FC8} Fp[2] Fi:24 Fi:8 Fp} vd v102 v103 v104 v105 v106 v107 v108 v109 v110 Fp Fc FC28{ m FC26 FC9 FC22 FC9} FC18} vd FC29{ m Fp[2]} FC29 FC19 Fc Fp}


 S1994C1 ::~S1994C1(){ note_dtor("S1994C1", this);}
S1994C1 ::S1994C1(){ note_ctor("S1994C1", this);} // tgen

static void Test_S1994C1()
{
  extern Class_Descriptor cd_S1994C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(128,188)];
    init_test(&cd_S1994C1, buf);
    S1994C1 *dp, &lv = *(dp=new (buf) S1994C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1016,748), "sizeof(S1994C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1994C1)");
    check_base_class_offset(lv, (S1994C4*)(S1994C3*)(S1994C2*), 0, "S1994C1");
    check_base_class_offset(lv, (S1994C3*)(S1994C2*), 0, "S1994C1");
    check_base_class_offset(lv, (S1994C2*), 0, "S1994C1");
    check_field_offset(lv, s1994c1f0, ABISELECT(952,712), "S1994C1.s1994c1f0");
    check_field_offset(lv, s1994c1f1, ABISELECT(968,720), "S1994C1.s1994c1f1");
    check_field_offset(lv, s1994c1f2, ABISELECT(984,728), "S1994C1.s1994c1f2");
    check_field_offset(lv, s1994c1f3, ABISELECT(1000,740), "S1994C1.s1994c1f3");
    check_field_offset(lv, s1994c1f4, ABISELECT(1008,744), "S1994C1.s1994c1f4");
    test_class_info(&lv, &cd_S1994C1);
    dp->~S1994C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1994C1(Test_S1994C1, "S1994C1", ABISELECT(1016,748));

#else // __cplusplus

extern void _ZN7S1994C1C1Ev();
extern void _ZN7S1994C1D1Ev();
Name_Map name_map_S1994C1[] = {
  NSPAIR(_ZN7S1994C1C1Ev),
  NSPAIR(_ZN7S1994C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1994C4;
extern VTBL_ENTRY _ZTI7S1994C4[];
extern  VTBL_ENTRY _ZTV7S1994C4[];
extern Class_Descriptor cd_S1994C3;
extern VTBL_ENTRY _ZTI7S1994C3[];
extern  VTBL_ENTRY _ZTV7S1994C3[];
extern Class_Descriptor cd_S1994C2;
extern VTBL_ENTRY _ZTI7S1994C2[];
extern  VTBL_ENTRY _ZTV7S1994C2[];
static Base_Class bases_S1994C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1994C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1994C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1994C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1994C1[];
extern void _ZN7S1994C1D1Ev();
extern void _ZN7S1994C1D0Ev();
extern void _ZN7S1994C42v1Ev();
extern void _ZN7S1994C42v2Ev();
extern void _ZN7S1994C42v3Ev();
extern void _ZN7S1994C42v4Ev();
extern void _ZN7S1994C42v5Ev();
extern void _ZN7S1994C42v6Ev();
extern void _ZN7S1994C42v7Ev();
extern void _ZN7S1994C42v8Ev();
extern void _ZN7S1994C42v9Ev();
extern void _ZN7S1994C43v10Ev();
extern void _ZN7S1994C43v11Ev();
extern void _ZN7S1994C43v12Ev();
extern void _ZN7S1994C43v13Ev();
extern void _ZN7S1994C43v14Ev();
extern void _ZN7S1994C43v15Ev();
extern void _ZN7S1994C43v16Ev();
extern void _ZN7S1994C43v17Ev();
extern void _ZN7S1994C43v18Ev();
extern void _ZN7S1994C43v19Ev();
extern void _ZN7S1994C43v20Ev();
extern void _ZN7S1994C43v21Ev();
extern void _ZN7S1994C43v22Ev();
extern void _ZN7S1994C43v23Ev();
extern void _ZN7S1994C33v24Ev();
extern void _ZN7S1994C33v25Ev();
extern void _ZN7S1994C33v26Ev();
extern void _ZN7S1994C33v27Ev();
extern void _ZN7S1994C33v28Ev();
extern void _ZN7S1994C33v29Ev();
extern void _ZN7S1994C33v30Ev();
extern void _ZN7S1994C33v31Ev();
extern void _ZN7S1994C33v32Ev();
extern void _ZN7S1994C33v33Ev();
extern void _ZN7S1994C33v34Ev();
extern void _ZN7S1994C33v35Ev();
extern void _ZN7S1994C33v36Ev();
extern void _ZN7S1994C33v37Ev();
extern void _ZN7S1994C33v38Ev();
extern void _ZN7S1994C33v39Ev();
extern void _ZN7S1994C33v40Ev();
extern void _ZN7S1994C33v41Ev();
extern void _ZN7S1994C33v42Ev();
extern void _ZN7S1994C33v43Ev();
extern void _ZN7S1994C33v44Ev();
extern void _ZN7S1994C33v45Ev();
extern void _ZN7S1994C33v46Ev();
extern void _ZN7S1994C33v47Ev();
extern void _ZN7S1994C33v48Ev();
extern void _ZN7S1994C33v49Ev();
extern void _ZN7S1994C33v50Ev();
extern void _ZN7S1994C33v51Ev();
extern void _ZN7S1994C33v52Ev();
extern void _ZN7S1994C33v53Ev();
extern void _ZN7S1994C33v54Ev();
extern void _ZN7S1994C33v55Ev();
extern void _ZN7S1994C33v56Ev();
extern void _ZN7S1994C33v57Ev();
extern void _ZN7S1994C33v58Ev();
extern void _ZN7S1994C33v59Ev();
extern void _ZN7S1994C33v60Ev();
extern void _ZN7S1994C33v61Ev();
extern void _ZN7S1994C33v62Ev();
extern void _ZN7S1994C33v63Ev();
extern void _ZN7S1994C33v64Ev();
extern void _ZN7S1994C33v65Ev();
extern void _ZN7S1994C33v66Ev();
extern void _ZN7S1994C33v67Ev();
extern void _ZN7S1994C33v68Ev();
extern void _ZN7S1994C33v69Ev();
extern void _ZN7S1994C33v70Ev();
extern void _ZN7S1994C33v71Ev();
extern void _ZN7S1994C33v72Ev();
extern void _ZN7S1994C33v73Ev();
extern void _ZN7S1994C33v74Ev();
extern void _ZN7S1994C33v75Ev();
extern void _ZN7S1994C33v76Ev();
extern void _ZN7S1994C33v77Ev();
extern void _ZN7S1994C33v78Ev();
extern void _ZN7S1994C33v79Ev();
extern void _ZN7S1994C33v80Ev();
extern void _ZN7S1994C33v81Ev();
extern void _ZN7S1994C33v82Ev();
extern void _ZN7S1994C33v83Ev();
extern void _ZN7S1994C33v84Ev();
extern void _ZN7S1994C33v85Ev();
extern void _ZN7S1994C33v86Ev();
extern void _ZN7S1994C33v87Ev();
extern void _ZN7S1994C33v88Ev();
extern void _ZN7S1994C33v89Ev();
extern void _ZN7S1994C33v90Ev();
extern void _ZN7S1994C33v91Ev();
extern void _ZN7S1994C33v92Ev();
extern void _ZN7S1994C33v93Ev();
extern void _ZN7S1994C33v94Ev();
extern void _ZN7S1994C33v95Ev();
extern void _ZN7S1994C33v96Ev();
extern void _ZN7S1994C33v97Ev();
extern void _ZN7S1994C33v98Ev();
extern void _ZN7S1994C33v99Ev();
extern void _ZN7S1994C34v100Ev();
extern void _ZN7S1994C34v101Ev();
extern void _ZN7S1994C24v102Ev();
extern void _ZN7S1994C24v103Ev();
extern void _ZN7S1994C24v104Ev();
extern void _ZN7S1994C24v105Ev();
extern void _ZN7S1994C24v106Ev();
extern void _ZN7S1994C24v107Ev();
extern void _ZN7S1994C24v108Ev();
extern void _ZN7S1994C24v109Ev();
extern void _ZN7S1994C24v110Ev();
static  VTBL_ENTRY vtc_S1994C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1994C1[0]),
  (VTBL_ENTRY)&_ZN7S1994C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1994C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v1Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1994C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1994C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v29Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v30Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v31Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v32Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v33Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v34Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v35Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v36Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v37Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v38Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v39Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v40Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v41Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v42Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v43Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v44Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v45Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v46Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v47Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v48Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v49Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v50Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v51Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v52Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v53Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v54Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v55Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v56Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v57Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v58Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v59Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v60Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v61Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v62Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v63Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v64Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v65Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v66Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v67Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v68Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v69Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1994C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1994C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1994C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1994C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1994C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1994C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1994C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1994C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1994C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1994C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1994C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1994C24v110Ev,
};
extern VTBL_ENTRY _ZTI7S1994C1[];
extern  VTBL_ENTRY _ZTV7S1994C1[];
Class_Descriptor cd_S1994C1 = {  "S1994C1", // class name
  bases_S1994C1, 3,
  &(vtc_S1994C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1016,748), // object size
  NSPAIRA(_ZTI7S1994C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1994C1),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1991C4  {
  void *s1991c4f0;
  int s1991c4f1;
  ::S1993C31 s1991c4f2;
  ::S1990C42 s1991c4f3;
  int s1991c4f4;
  virtual  ~S1991C4(); // _ZN7S1991C4D1Ev
  virtual void  v1(); // _ZN7S1991C42v1Ev
  virtual void  v2(); // _ZN7S1991C42v2Ev
  virtual void  v3(); // _ZN7S1991C42v3Ev
  virtual void  v4(); // _ZN7S1991C42v4Ev
  virtual void  v5(); // _ZN7S1991C42v5Ev
  virtual void  v6(); // _ZN7S1991C42v6Ev
  virtual void  v7(); // _ZN7S1991C42v7Ev
  virtual void  v8(); // _ZN7S1991C42v8Ev
  virtual void  v9(); // _ZN7S1991C42v9Ev
  virtual void  v10(); // _ZN7S1991C43v10Ev
  virtual void  v11(); // _ZN7S1991C43v11Ev
  virtual void  v12(); // _ZN7S1991C43v12Ev
  virtual void  v13(); // _ZN7S1991C43v13Ev
  virtual void  v14(); // _ZN7S1991C43v14Ev
  virtual void  v15(); // _ZN7S1991C43v15Ev
  virtual void  v16(); // _ZN7S1991C43v16Ev
  virtual void  v17(); // _ZN7S1991C43v17Ev
  virtual void  v18(); // _ZN7S1991C43v18Ev
  virtual void  v19(); // _ZN7S1991C43v19Ev
  virtual void  v20(); // _ZN7S1991C43v20Ev
  virtual void  v21(); // _ZN7S1991C43v21Ev
  virtual void  v22(); // _ZN7S1991C43v22Ev
  virtual void  v23(); // _ZN7S1991C43v23Ev
  S1991C4(); // tgen
};
//SIG(-1 S1991C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}} FC6{ BC7{ m Fp Fi FC8{ m} FC9{ m}}} Fi}


 S1991C4 ::~S1991C4(){ note_dtor("S1991C4", this);}
void  S1991C4 ::v1(){vfunc_called(this, "_ZN7S1991C42v1Ev");}
void  S1991C4 ::v2(){vfunc_called(this, "_ZN7S1991C42v2Ev");}
void  S1991C4 ::v3(){vfunc_called(this, "_ZN7S1991C42v3Ev");}
void  S1991C4 ::v4(){vfunc_called(this, "_ZN7S1991C42v4Ev");}
void  S1991C4 ::v5(){vfunc_called(this, "_ZN7S1991C42v5Ev");}
void  S1991C4 ::v6(){vfunc_called(this, "_ZN7S1991C42v6Ev");}
void  S1991C4 ::v7(){vfunc_called(this, "_ZN7S1991C42v7Ev");}
void  S1991C4 ::v8(){vfunc_called(this, "_ZN7S1991C42v8Ev");}
void  S1991C4 ::v9(){vfunc_called(this, "_ZN7S1991C42v9Ev");}
void  S1991C4 ::v10(){vfunc_called(this, "_ZN7S1991C43v10Ev");}
void  S1991C4 ::v11(){vfunc_called(this, "_ZN7S1991C43v11Ev");}
void  S1991C4 ::v12(){vfunc_called(this, "_ZN7S1991C43v12Ev");}
void  S1991C4 ::v13(){vfunc_called(this, "_ZN7S1991C43v13Ev");}
void  S1991C4 ::v14(){vfunc_called(this, "_ZN7S1991C43v14Ev");}
void  S1991C4 ::v15(){vfunc_called(this, "_ZN7S1991C43v15Ev");}
void  S1991C4 ::v16(){vfunc_called(this, "_ZN7S1991C43v16Ev");}
void  S1991C4 ::v17(){vfunc_called(this, "_ZN7S1991C43v17Ev");}
void  S1991C4 ::v18(){vfunc_called(this, "_ZN7S1991C43v18Ev");}
void  S1991C4 ::v19(){vfunc_called(this, "_ZN7S1991C43v19Ev");}
void  S1991C4 ::v20(){vfunc_called(this, "_ZN7S1991C43v20Ev");}
void  S1991C4 ::v21(){vfunc_called(this, "_ZN7S1991C43v21Ev");}
void  S1991C4 ::v22(){vfunc_called(this, "_ZN7S1991C43v22Ev");}
void  S1991C4 ::v23(){vfunc_called(this, "_ZN7S1991C43v23Ev");}
S1991C4 ::S1991C4(){ note_ctor("S1991C4", this);} // tgen

static void Test_S1991C4()
{
  extern Class_Descriptor cd_S1991C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_S1991C4, buf);
    S1991C4 *dp, &lv = *(dp=new (buf) S1991C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(S1991C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1991C4)");
    check_field_offset(lv, s1991c4f0, ABISELECT(8,4), "S1991C4.s1991c4f0");
    check_field_offset(lv, s1991c4f1, ABISELECT(16,8), "S1991C4.s1991c4f1");
    check_field_offset(lv, s1991c4f2, ABISELECT(24,12), "S1991C4.s1991c4f2");
    check_field_offset(lv, s1991c4f3, ABISELECT(40,24), "S1991C4.s1991c4f3");
    check_field_offset(lv, s1991c4f4, ABISELECT(56,36), "S1991C4.s1991c4f4");
    test_class_info(&lv, &cd_S1991C4);
    dp->~S1991C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1991C4(Test_S1991C4, "S1991C4", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN7S1991C4C1Ev();
extern void _ZN7S1991C4D1Ev();
Name_Map name_map_S1991C4[] = {
  NSPAIR(_ZN7S1991C4C1Ev),
  NSPAIR(_ZN7S1991C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1991C4[];
extern void _ZN7S1991C4D1Ev();
extern void _ZN7S1991C4D0Ev();
extern void _ZN7S1991C42v1Ev();
extern void _ZN7S1991C42v2Ev();
extern void _ZN7S1991C42v3Ev();
extern void _ZN7S1991C42v4Ev();
extern void _ZN7S1991C42v5Ev();
extern void _ZN7S1991C42v6Ev();
extern void _ZN7S1991C42v7Ev();
extern void _ZN7S1991C42v8Ev();
extern void _ZN7S1991C42v9Ev();
extern void _ZN7S1991C43v10Ev();
extern void _ZN7S1991C43v11Ev();
extern void _ZN7S1991C43v12Ev();
extern void _ZN7S1991C43v13Ev();
extern void _ZN7S1991C43v14Ev();
extern void _ZN7S1991C43v15Ev();
extern void _ZN7S1991C43v16Ev();
extern void _ZN7S1991C43v17Ev();
extern void _ZN7S1991C43v18Ev();
extern void _ZN7S1991C43v19Ev();
extern void _ZN7S1991C43v20Ev();
extern void _ZN7S1991C43v21Ev();
extern void _ZN7S1991C43v22Ev();
extern void _ZN7S1991C43v23Ev();
static  VTBL_ENTRY vtc_S1991C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1991C4[0]),
  (VTBL_ENTRY)&_ZN7S1991C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1991C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v1Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v23Ev,
};
extern VTBL_ENTRY _ZTI7S1991C4[];
extern  VTBL_ENTRY _ZTV7S1991C4[];
Class_Descriptor cd_S1991C4 = {  "S1991C4", // class name
  0,0,//no base classes
  &(vtc_S1991C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI7S1991C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1991C4),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1991C3  : S1991C4 {
  ::S1993C15 s1991c3f0;
  ::S1993C15 s1991c3f1;
  ::S1993C15 s1991c3f2;
  ::S1990C13_nt s1991c3f3;
  ::S1990C17_nt s1991c3f4;
  ::S1990C18_nt s1991c3f5;
  ::S1990C18_nt s1991c3f6;
  ::S1993C15 s1991c3f7;
  ::S1993C15 s1991c3f8;
  ::S1993C15 s1991c3f9;
  void *s1991c3f10;
  ::S1990C17_nt s1991c3f11;
  ::S1990C19_nt s1991c3f12;
  int s1991c3f13;
  void *s1991c3f14[7];
  ::S1990C43 s1991c3f15;
  int s1991c3f16:8;
  int s1991c3f17:8;
  int s1991c3f18:16;
  int s1991c3f19:16;
  int s1991c3f20:8;
  int s1991c3f21:8;
  int s1991c3f22:8;
  int s1991c3f23:32;
  int s1991c3f24:8;
  int s1991c3f25:4;
  int s1991c3f26:4;
  int s1991c3f27:4;
  int s1991c3f28:4;
  int s1991c3f29:4;
  int s1991c3f30:4;
  int s1991c3f31:4;
  int s1991c3f32:4;
  int s1991c3f33:4;
  int s1991c3f34:4;
  unsigned char s1991c3f35:1;
  unsigned char s1991c3f36:1;
  unsigned char s1991c3f37:1;
  unsigned char s1991c3f38:1;
  unsigned char s1991c3f39:1;
  unsigned char s1991c3f40:1;
  unsigned char s1991c3f41:1;
  unsigned char s1991c3f42:1;
  unsigned char s1991c3f43:1;
  unsigned char s1991c3f44:1;
  unsigned char s1991c3f45:1;
  unsigned char s1991c3f46:1;
  unsigned char s1991c3f47:1;
  unsigned char s1991c3f48:1;
  unsigned char s1991c3f49:1;
  unsigned char s1991c3f50:1;
  unsigned char s1991c3f51:1;
  unsigned char s1991c3f52:1;
  unsigned char s1991c3f53:1;
  unsigned char s1991c3f54:1;
  unsigned char s1991c3f55:1;
  unsigned char s1991c3f56:1;
  unsigned char s1991c3f57:1;
  unsigned char s1991c3f58:1;
  unsigned char s1991c3f59:1;
  unsigned char s1991c3f60:1;
  unsigned char s1991c3f61:1;
  unsigned char s1991c3f62:1;
  unsigned char s1991c3f63:1;
  unsigned char s1991c3f64:1;
  unsigned char s1991c3f65:1;
  unsigned char s1991c3f66:1;
  unsigned char s1991c3f67:1;
  unsigned char s1991c3f68:1;
  unsigned char s1991c3f69:1;
  unsigned char s1991c3f70:1;
  unsigned char s1991c3f71:1;
  unsigned char s1991c3f72:1;
  unsigned char s1991c3f73:1;
  unsigned char s1991c3f74:1;
  unsigned char s1991c3f75:1;
  int s1991c3f76[7];
  void *s1991c3f77[6];
  int s1991c3f78:8;
  int s1991c3f79:8;
  int s1991c3f80:8;
  int s1991c3f81:8;
  int s1991c3f82:8;
  int s1991c3f83:8;
  ::S1990C25 s1991c3f84;
  void *s1991c3f85[4];
  int s1991c3f86:8;
  int s1991c3f87:8;
  int s1991c3f88:8;
  int s1991c3f89:8;
  int s1991c3f90:8;
  int s1991c3f91:16;
  int s1991c3f92:16;
  int s1991c3f93:16;
  int s1991c3f94:4;
  int s1991c3f95:4;
  int s1991c3f96:4;
  int s1991c3f97:4;
  int s1991c3f98:4;
  int s1991c3f99:4;
  int s1991c3f100:4;
  int s1991c3f101:4;
  int s1991c3f102:4;
  int s1991c3f103:4;
  int s1991c3f104:4;
  int s1991c3f105:4;
  int s1991c3f106:8;
  int s1991c3f107:8;
  int s1991c3f108:8;
  void *s1991c3f109[7];
  ::S1990C46 s1991c3f110;
  void *s1991c3f111[2];
  int s1991c3f112:16;
  int s1991c3f113:16;
  ::S1990C5_nt s1991c3f114;
  ::S1990C37 s1991c3f115;
  ::S1990C29_nt s1991c3f116;
  void *s1991c3f117[2];
  int s1991c3f118:24;
  int s1991c3f119:8;
  void *s1991c3f120;
  virtual  ~S1991C3(); // _ZN7S1991C3D1Ev
  virtual void  v24(); // _ZN7S1991C33v24Ev
  virtual void  v25(); // _ZN7S1991C33v25Ev
  virtual void  v26(); // _ZN7S1991C33v26Ev
  virtual void  v27(); // _ZN7S1991C33v27Ev
  virtual void  v28(); // _ZN7S1991C33v28Ev
  virtual void  v29(); // _ZN7S1991C33v29Ev
  virtual void  v30(); // _ZN7S1991C33v30Ev
  virtual void  v31(); // _ZN7S1991C33v31Ev
  virtual void  v32(); // _ZN7S1991C33v32Ev
  virtual void  v33(); // _ZN7S1991C33v33Ev
  virtual void  v34(); // _ZN7S1991C33v34Ev
  virtual void  v35(); // _ZN7S1991C33v35Ev
  virtual void  v36(); // _ZN7S1991C33v36Ev
  virtual void  v37(); // _ZN7S1991C33v37Ev
  virtual void  v38(); // _ZN7S1991C33v38Ev
  virtual void  v39(); // _ZN7S1991C33v39Ev
  virtual void  v40(); // _ZN7S1991C33v40Ev
  virtual void  v41(); // _ZN7S1991C33v41Ev
  virtual void  v42(); // _ZN7S1991C33v42Ev
  virtual void  v43(); // _ZN7S1991C33v43Ev
  virtual void  v44(); // _ZN7S1991C33v44Ev
  virtual void  v45(); // _ZN7S1991C33v45Ev
  virtual void  v46(); // _ZN7S1991C33v46Ev
  virtual void  v47(); // _ZN7S1991C33v47Ev
  virtual void  v48(); // _ZN7S1991C33v48Ev
  virtual void  v49(); // _ZN7S1991C33v49Ev
  virtual void  v50(); // _ZN7S1991C33v50Ev
  virtual void  v51(); // _ZN7S1991C33v51Ev
  virtual void  v52(); // _ZN7S1991C33v52Ev
  virtual void  v53(); // _ZN7S1991C33v53Ev
  virtual void  v54(); // _ZN7S1991C33v54Ev
  virtual void  v55(); // _ZN7S1991C33v55Ev
  virtual void  v56(); // _ZN7S1991C33v56Ev
  virtual void  v57(); // _ZN7S1991C33v57Ev
  virtual void  v58(); // _ZN7S1991C33v58Ev
  virtual void  v59(); // _ZN7S1991C33v59Ev
  virtual void  v60(); // _ZN7S1991C33v60Ev
  virtual void  v61(); // _ZN7S1991C33v61Ev
  virtual void  v62(); // _ZN7S1991C33v62Ev
  virtual void  v63(); // _ZN7S1991C33v63Ev
  virtual void  v64(); // _ZN7S1991C33v64Ev
  virtual void  v65(); // _ZN7S1991C33v65Ev
  virtual void  v66(); // _ZN7S1991C33v66Ev
  virtual void  v67(); // _ZN7S1991C33v67Ev
  virtual void  v68(); // _ZN7S1991C33v68Ev
  virtual void  v69(); // _ZN7S1991C33v69Ev
  virtual void  v70(); // _ZN7S1991C33v70Ev
  virtual void  v71(); // _ZN7S1991C33v71Ev
  virtual void  v72(); // _ZN7S1991C33v72Ev
  virtual void  v73(); // _ZN7S1991C33v73Ev
  virtual void  v74(); // _ZN7S1991C33v74Ev
  virtual void  v75(); // _ZN7S1991C33v75Ev
  virtual void  v76(); // _ZN7S1991C33v76Ev
  virtual void  v77(); // _ZN7S1991C33v77Ev
  virtual void  v78(); // _ZN7S1991C33v78Ev
  virtual void  v79(); // _ZN7S1991C33v79Ev
  virtual void  v80(); // _ZN7S1991C33v80Ev
  virtual void  v81(); // _ZN7S1991C33v81Ev
  virtual void  v82(); // _ZN7S1991C33v82Ev
  virtual void  v83(); // _ZN7S1991C33v83Ev
  virtual void  v84(); // _ZN7S1991C33v84Ev
  virtual void  v85(); // _ZN7S1991C33v85Ev
  virtual void  v86(); // _ZN7S1991C33v86Ev
  virtual void  v87(); // _ZN7S1991C33v87Ev
  virtual void  v88(); // _ZN7S1991C33v88Ev
  virtual void  v89(); // _ZN7S1991C33v89Ev
  virtual void  v90(); // _ZN7S1991C33v90Ev
  virtual void  v91(); // _ZN7S1991C33v91Ev
  virtual void  v92(); // _ZN7S1991C33v92Ev
  virtual void  v93(); // _ZN7S1991C33v93Ev
  virtual void  v94(); // _ZN7S1991C33v94Ev
  virtual void  v95(); // _ZN7S1991C33v95Ev
  virtual void  v96(); // _ZN7S1991C33v96Ev
  virtual void  v97(); // _ZN7S1991C33v97Ev
  virtual void  v98(); // _ZN7S1991C33v98Ev
  virtual void  v99(); // _ZN7S1991C33v99Ev
  virtual void  v100(); // _ZN7S1991C34v100Ev
  virtual void  v101(); // _ZN7S1991C34v101Ev
  S1991C3(); // tgen
};
//SIG(-1 S1991C3) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fp Fi FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}} FC7{ BC8{ m Fp Fi FC9{ m} FC10{ m}}} Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 FC11{ m FC12{ m FL[2]}} FC11 FC11 FC13{ m FC12} FC14{ m FC13} FC15{ m FC13 FC13 FC13 FC13} FC15 FC11 FC11 FC11 Fp FC14 FC16{ m FC17{ m Fp Fi FC18{ m}} Fi} Fi Fp[7] FC8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC19{ BC4} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC20{ m Fp Fi[2] FC10} Fp[2] Fi:16 Fi:16 FC21{ BC22{ m Fp Fi FC23{ m} FC23}} FC24{ m Fp Fi[2] FC9} FC25{ m Fp Fi[2] FC6} Fp[2] Fi:24 Fi:8 Fp}


 S1991C3 ::~S1991C3(){ note_dtor("S1991C3", this);}
void  S1991C3 ::v24(){vfunc_called(this, "_ZN7S1991C33v24Ev");}
void  S1991C3 ::v25(){vfunc_called(this, "_ZN7S1991C33v25Ev");}
void  S1991C3 ::v26(){vfunc_called(this, "_ZN7S1991C33v26Ev");}
void  S1991C3 ::v27(){vfunc_called(this, "_ZN7S1991C33v27Ev");}
void  S1991C3 ::v28(){vfunc_called(this, "_ZN7S1991C33v28Ev");}
void  S1991C3 ::v29(){vfunc_called(this, "_ZN7S1991C33v29Ev");}
void  S1991C3 ::v30(){vfunc_called(this, "_ZN7S1991C33v30Ev");}
void  S1991C3 ::v31(){vfunc_called(this, "_ZN7S1991C33v31Ev");}
void  S1991C3 ::v32(){vfunc_called(this, "_ZN7S1991C33v32Ev");}
void  S1991C3 ::v33(){vfunc_called(this, "_ZN7S1991C33v33Ev");}
void  S1991C3 ::v34(){vfunc_called(this, "_ZN7S1991C33v34Ev");}
void  S1991C3 ::v35(){vfunc_called(this, "_ZN7S1991C33v35Ev");}
void  S1991C3 ::v36(){vfunc_called(this, "_ZN7S1991C33v36Ev");}
void  S1991C3 ::v37(){vfunc_called(this, "_ZN7S1991C33v37Ev");}
void  S1991C3 ::v38(){vfunc_called(this, "_ZN7S1991C33v38Ev");}
void  S1991C3 ::v39(){vfunc_called(this, "_ZN7S1991C33v39Ev");}
void  S1991C3 ::v40(){vfunc_called(this, "_ZN7S1991C33v40Ev");}
void  S1991C3 ::v41(){vfunc_called(this, "_ZN7S1991C33v41Ev");}
void  S1991C3 ::v42(){vfunc_called(this, "_ZN7S1991C33v42Ev");}
void  S1991C3 ::v43(){vfunc_called(this, "_ZN7S1991C33v43Ev");}
void  S1991C3 ::v44(){vfunc_called(this, "_ZN7S1991C33v44Ev");}
void  S1991C3 ::v45(){vfunc_called(this, "_ZN7S1991C33v45Ev");}
void  S1991C3 ::v46(){vfunc_called(this, "_ZN7S1991C33v46Ev");}
void  S1991C3 ::v47(){vfunc_called(this, "_ZN7S1991C33v47Ev");}
void  S1991C3 ::v48(){vfunc_called(this, "_ZN7S1991C33v48Ev");}
void  S1991C3 ::v49(){vfunc_called(this, "_ZN7S1991C33v49Ev");}
void  S1991C3 ::v50(){vfunc_called(this, "_ZN7S1991C33v50Ev");}
void  S1991C3 ::v51(){vfunc_called(this, "_ZN7S1991C33v51Ev");}
void  S1991C3 ::v52(){vfunc_called(this, "_ZN7S1991C33v52Ev");}
void  S1991C3 ::v53(){vfunc_called(this, "_ZN7S1991C33v53Ev");}
void  S1991C3 ::v54(){vfunc_called(this, "_ZN7S1991C33v54Ev");}
void  S1991C3 ::v55(){vfunc_called(this, "_ZN7S1991C33v55Ev");}
void  S1991C3 ::v56(){vfunc_called(this, "_ZN7S1991C33v56Ev");}
void  S1991C3 ::v57(){vfunc_called(this, "_ZN7S1991C33v57Ev");}
void  S1991C3 ::v58(){vfunc_called(this, "_ZN7S1991C33v58Ev");}
void  S1991C3 ::v59(){vfunc_called(this, "_ZN7S1991C33v59Ev");}
void  S1991C3 ::v60(){vfunc_called(this, "_ZN7S1991C33v60Ev");}
void  S1991C3 ::v61(){vfunc_called(this, "_ZN7S1991C33v61Ev");}
void  S1991C3 ::v62(){vfunc_called(this, "_ZN7S1991C33v62Ev");}
void  S1991C3 ::v63(){vfunc_called(this, "_ZN7S1991C33v63Ev");}
void  S1991C3 ::v64(){vfunc_called(this, "_ZN7S1991C33v64Ev");}
void  S1991C3 ::v65(){vfunc_called(this, "_ZN7S1991C33v65Ev");}
void  S1991C3 ::v66(){vfunc_called(this, "_ZN7S1991C33v66Ev");}
void  S1991C3 ::v67(){vfunc_called(this, "_ZN7S1991C33v67Ev");}
void  S1991C3 ::v68(){vfunc_called(this, "_ZN7S1991C33v68Ev");}
void  S1991C3 ::v69(){vfunc_called(this, "_ZN7S1991C33v69Ev");}
void  S1991C3 ::v70(){vfunc_called(this, "_ZN7S1991C33v70Ev");}
void  S1991C3 ::v71(){vfunc_called(this, "_ZN7S1991C33v71Ev");}
void  S1991C3 ::v72(){vfunc_called(this, "_ZN7S1991C33v72Ev");}
void  S1991C3 ::v73(){vfunc_called(this, "_ZN7S1991C33v73Ev");}
void  S1991C3 ::v74(){vfunc_called(this, "_ZN7S1991C33v74Ev");}
void  S1991C3 ::v75(){vfunc_called(this, "_ZN7S1991C33v75Ev");}
void  S1991C3 ::v76(){vfunc_called(this, "_ZN7S1991C33v76Ev");}
void  S1991C3 ::v77(){vfunc_called(this, "_ZN7S1991C33v77Ev");}
void  S1991C3 ::v78(){vfunc_called(this, "_ZN7S1991C33v78Ev");}
void  S1991C3 ::v79(){vfunc_called(this, "_ZN7S1991C33v79Ev");}
void  S1991C3 ::v80(){vfunc_called(this, "_ZN7S1991C33v80Ev");}
void  S1991C3 ::v81(){vfunc_called(this, "_ZN7S1991C33v81Ev");}
void  S1991C3 ::v82(){vfunc_called(this, "_ZN7S1991C33v82Ev");}
void  S1991C3 ::v83(){vfunc_called(this, "_ZN7S1991C33v83Ev");}
void  S1991C3 ::v84(){vfunc_called(this, "_ZN7S1991C33v84Ev");}
void  S1991C3 ::v85(){vfunc_called(this, "_ZN7S1991C33v85Ev");}
void  S1991C3 ::v86(){vfunc_called(this, "_ZN7S1991C33v86Ev");}
void  S1991C3 ::v87(){vfunc_called(this, "_ZN7S1991C33v87Ev");}
void  S1991C3 ::v88(){vfunc_called(this, "_ZN7S1991C33v88Ev");}
void  S1991C3 ::v89(){vfunc_called(this, "_ZN7S1991C33v89Ev");}
void  S1991C3 ::v90(){vfunc_called(this, "_ZN7S1991C33v90Ev");}
void  S1991C3 ::v91(){vfunc_called(this, "_ZN7S1991C33v91Ev");}
void  S1991C3 ::v92(){vfunc_called(this, "_ZN7S1991C33v92Ev");}
void  S1991C3 ::v93(){vfunc_called(this, "_ZN7S1991C33v93Ev");}
void  S1991C3 ::v94(){vfunc_called(this, "_ZN7S1991C33v94Ev");}
void  S1991C3 ::v95(){vfunc_called(this, "_ZN7S1991C33v95Ev");}
void  S1991C3 ::v96(){vfunc_called(this, "_ZN7S1991C33v96Ev");}
void  S1991C3 ::v97(){vfunc_called(this, "_ZN7S1991C33v97Ev");}
void  S1991C3 ::v98(){vfunc_called(this, "_ZN7S1991C33v98Ev");}
void  S1991C3 ::v99(){vfunc_called(this, "_ZN7S1991C33v99Ev");}
void  S1991C3 ::v100(){vfunc_called(this, "_ZN7S1991C34v100Ev");}
void  S1991C3 ::v101(){vfunc_called(this, "_ZN7S1991C34v101Ev");}
S1991C3 ::S1991C3(){ note_ctor("S1991C3", this);} // tgen

static void Test_S1991C3()
{
  extern Class_Descriptor cd_S1991C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(105,159)];
    init_test(&cd_S1991C3, buf);
    S1991C3 *dp, &lv = *(dp=new (buf) S1991C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(832,632), "sizeof(S1991C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1991C3)");
    check_base_class_offset(lv, (S1991C4*), 0, "S1991C3");
    check_field_offset(lv, s1991c3f0, ABISELECT(64,40), "S1991C3.s1991c3f0");
    check_field_offset(lv, s1991c3f1, ABISELECT(80,56), "S1991C3.s1991c3f1");
    check_field_offset(lv, s1991c3f2, ABISELECT(96,72), "S1991C3.s1991c3f2");
    check_field_offset(lv, s1991c3f3, ABISELECT(112,88), "S1991C3.s1991c3f3");
    check_field_offset(lv, s1991c3f4, ABISELECT(128,104), "S1991C3.s1991c3f4");
    check_field_offset(lv, s1991c3f5, ABISELECT(144,120), "S1991C3.s1991c3f5");
    check_field_offset(lv, s1991c3f6, ABISELECT(208,184), "S1991C3.s1991c3f6");
    check_field_offset(lv, s1991c3f7, ABISELECT(272,248), "S1991C3.s1991c3f7");
    check_field_offset(lv, s1991c3f8, ABISELECT(288,264), "S1991C3.s1991c3f8");
    check_field_offset(lv, s1991c3f9, ABISELECT(304,280), "S1991C3.s1991c3f9");
    check_field_offset(lv, s1991c3f10, ABISELECT(320,296), "S1991C3.s1991c3f10");
    check_field_offset(lv, s1991c3f11, ABISELECT(328,300), "S1991C3.s1991c3f11");
    check_field_offset(lv, s1991c3f12, ABISELECT(344,316), "S1991C3.s1991c3f12");
    check_field_offset(lv, s1991c3f13, ABISELECT(368,332), "S1991C3.s1991c3f13");
    check_field_offset(lv, s1991c3f14, ABISELECT(376,336), "S1991C3.s1991c3f14");
    check_field_offset(lv, s1991c3f15, ABISELECT(432,364), "S1991C3.s1991c3f15");
    set_bf_and_test(lv, s1991c3f16, ABISELECT(448,376), 0, 8, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f16, ABISELECT(448,376), 0, 8, hide_sll(1LL<<7), "S1991C3");
    set_bf_and_test(lv, s1991c3f17, ABISELECT(449,377), 0, 8, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f17, ABISELECT(449,377), 0, 8, hide_sll(1LL<<7), "S1991C3");
    set_bf_and_test(lv, s1991c3f18, ABISELECT(450,378), 0, 16, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f18, ABISELECT(450,378), 0, 16, hide_sll(1LL<<15), "S1991C3");
    set_bf_and_test(lv, s1991c3f19, ABISELECT(452,380), 0, 16, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f19, ABISELECT(452,380), 0, 16, hide_sll(1LL<<15), "S1991C3");
    set_bf_and_test(lv, s1991c3f20, ABISELECT(454,382), 0, 8, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f20, ABISELECT(454,382), 0, 8, hide_sll(1LL<<7), "S1991C3");
    set_bf_and_test(lv, s1991c3f21, ABISELECT(455,383), 0, 8, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f21, ABISELECT(455,383), 0, 8, hide_sll(1LL<<7), "S1991C3");
    set_bf_and_test(lv, s1991c3f22, ABISELECT(456,384), 0, 8, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f22, ABISELECT(456,384), 0, 8, hide_sll(1LL<<7), "S1991C3");
    set_bf_and_test(lv, s1991c3f23, ABISELECT(460,388), 0, 32, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f23, ABISELECT(460,388), 0, 32, hide_sll(1LL<<31), "S1991C3");
    set_bf_and_test(lv, s1991c3f24, ABISELECT(464,392), 0, 8, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f24, ABISELECT(464,392), 0, 8, hide_sll(1LL<<7), "S1991C3");
    set_bf_and_test(lv, s1991c3f25, ABISELECT(465,393), 0, 4, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f25, ABISELECT(465,393), 0, 4, hide_sll(1LL<<3), "S1991C3");
    set_bf_and_test(lv, s1991c3f26, ABISELECT(465,393), 4, 4, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f26, ABISELECT(465,393), 4, 4, hide_sll(1LL<<3), "S1991C3");
    set_bf_and_test(lv, s1991c3f27, ABISELECT(466,394), 0, 4, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f27, ABISELECT(466,394), 0, 4, hide_sll(1LL<<3), "S1991C3");
    set_bf_and_test(lv, s1991c3f28, ABISELECT(466,394), 4, 4, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f28, ABISELECT(466,394), 4, 4, hide_sll(1LL<<3), "S1991C3");
    set_bf_and_test(lv, s1991c3f29, ABISELECT(467,395), 0, 4, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f29, ABISELECT(467,395), 0, 4, hide_sll(1LL<<3), "S1991C3");
    set_bf_and_test(lv, s1991c3f30, ABISELECT(467,395), 4, 4, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f30, ABISELECT(467,395), 4, 4, hide_sll(1LL<<3), "S1991C3");
    set_bf_and_test(lv, s1991c3f31, ABISELECT(468,396), 0, 4, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f31, ABISELECT(468,396), 0, 4, hide_sll(1LL<<3), "S1991C3");
    set_bf_and_test(lv, s1991c3f32, ABISELECT(468,396), 4, 4, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f32, ABISELECT(468,396), 4, 4, hide_sll(1LL<<3), "S1991C3");
    set_bf_and_test(lv, s1991c3f33, ABISELECT(469,397), 0, 4, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f33, ABISELECT(469,397), 0, 4, hide_sll(1LL<<3), "S1991C3");
    set_bf_and_test(lv, s1991c3f34, ABISELECT(469,397), 4, 4, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f34, ABISELECT(469,397), 4, 4, hide_sll(1LL<<3), "S1991C3");
    set_bf_and_test(lv, s1991c3f35, ABISELECT(470,398), 0, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f36, ABISELECT(470,398), 1, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f37, ABISELECT(470,398), 2, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f38, ABISELECT(470,398), 3, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f39, ABISELECT(470,398), 4, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f40, ABISELECT(470,398), 5, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f41, ABISELECT(470,398), 6, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f42, ABISELECT(470,398), 7, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f43, ABISELECT(471,399), 0, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f44, ABISELECT(471,399), 1, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f45, ABISELECT(471,399), 2, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f46, ABISELECT(471,399), 3, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f47, ABISELECT(471,399), 4, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f48, ABISELECT(471,399), 5, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f49, ABISELECT(471,399), 6, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f50, ABISELECT(471,399), 7, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f51, ABISELECT(472,400), 0, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f52, ABISELECT(472,400), 1, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f53, ABISELECT(472,400), 2, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f54, ABISELECT(472,400), 3, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f55, ABISELECT(472,400), 4, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f56, ABISELECT(472,400), 5, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f57, ABISELECT(472,400), 6, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f58, ABISELECT(472,400), 7, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f59, ABISELECT(473,401), 0, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f60, ABISELECT(473,401), 1, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f61, ABISELECT(473,401), 2, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f62, ABISELECT(473,401), 3, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f63, ABISELECT(473,401), 4, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f64, ABISELECT(473,401), 5, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f65, ABISELECT(473,401), 6, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f66, ABISELECT(473,401), 7, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f67, ABISELECT(474,402), 0, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f68, ABISELECT(474,402), 1, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f69, ABISELECT(474,402), 2, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f70, ABISELECT(474,402), 3, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f71, ABISELECT(474,402), 4, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f72, ABISELECT(474,402), 5, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f73, ABISELECT(474,402), 6, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f74, ABISELECT(474,402), 7, 1, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f75, ABISELECT(475,403), 0, 1, 1, "S1991C3");
    check_field_offset(lv, s1991c3f76, ABISELECT(476,404), "S1991C3.s1991c3f76");
    check_field_offset(lv, s1991c3f77, ABISELECT(504,432), "S1991C3.s1991c3f77");
    set_bf_and_test(lv, s1991c3f78, ABISELECT(552,456), 0, 8, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f78, ABISELECT(552,456), 0, 8, hide_sll(1LL<<7), "S1991C3");
    set_bf_and_test(lv, s1991c3f79, ABISELECT(553,457), 0, 8, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f79, ABISELECT(553,457), 0, 8, hide_sll(1LL<<7), "S1991C3");
    set_bf_and_test(lv, s1991c3f80, ABISELECT(554,458), 0, 8, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f80, ABISELECT(554,458), 0, 8, hide_sll(1LL<<7), "S1991C3");
    set_bf_and_test(lv, s1991c3f81, ABISELECT(555,459), 0, 8, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f81, ABISELECT(555,459), 0, 8, hide_sll(1LL<<7), "S1991C3");
    set_bf_and_test(lv, s1991c3f82, ABISELECT(556,460), 0, 8, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f82, ABISELECT(556,460), 0, 8, hide_sll(1LL<<7), "S1991C3");
    set_bf_and_test(lv, s1991c3f83, ABISELECT(557,461), 0, 8, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f83, ABISELECT(557,461), 0, 8, hide_sll(1LL<<7), "S1991C3");
    check_field_offset(lv, s1991c3f84, ABISELECT(560,464), "S1991C3.s1991c3f84");
    check_field_offset(lv, s1991c3f85, ABISELECT(576,476), "S1991C3.s1991c3f85");
    set_bf_and_test(lv, s1991c3f86, ABISELECT(608,492), 0, 8, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f86, ABISELECT(608,492), 0, 8, hide_sll(1LL<<7), "S1991C3");
    set_bf_and_test(lv, s1991c3f87, ABISELECT(609,493), 0, 8, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f87, ABISELECT(609,493), 0, 8, hide_sll(1LL<<7), "S1991C3");
    set_bf_and_test(lv, s1991c3f88, ABISELECT(610,494), 0, 8, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f88, ABISELECT(610,494), 0, 8, hide_sll(1LL<<7), "S1991C3");
    set_bf_and_test(lv, s1991c3f89, ABISELECT(611,495), 0, 8, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f89, ABISELECT(611,495), 0, 8, hide_sll(1LL<<7), "S1991C3");
    set_bf_and_test(lv, s1991c3f90, ABISELECT(612,496), 0, 8, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f90, ABISELECT(612,496), 0, 8, hide_sll(1LL<<7), "S1991C3");
    set_bf_and_test(lv, s1991c3f91, ABISELECT(613,497), 0, 16, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f91, ABISELECT(613,497), 0, 16, hide_sll(1LL<<15), "S1991C3");
    set_bf_and_test(lv, s1991c3f92, ABISELECT(616,500), 0, 16, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f92, ABISELECT(616,500), 0, 16, hide_sll(1LL<<15), "S1991C3");
    set_bf_and_test(lv, s1991c3f93, ABISELECT(618,502), 0, 16, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f93, ABISELECT(618,502), 0, 16, hide_sll(1LL<<15), "S1991C3");
    set_bf_and_test(lv, s1991c3f94, ABISELECT(620,504), 0, 4, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f94, ABISELECT(620,504), 0, 4, hide_sll(1LL<<3), "S1991C3");
    set_bf_and_test(lv, s1991c3f95, ABISELECT(620,504), 4, 4, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f95, ABISELECT(620,504), 4, 4, hide_sll(1LL<<3), "S1991C3");
    set_bf_and_test(lv, s1991c3f96, ABISELECT(621,505), 0, 4, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f96, ABISELECT(621,505), 0, 4, hide_sll(1LL<<3), "S1991C3");
    set_bf_and_test(lv, s1991c3f97, ABISELECT(621,505), 4, 4, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f97, ABISELECT(621,505), 4, 4, hide_sll(1LL<<3), "S1991C3");
    set_bf_and_test(lv, s1991c3f98, ABISELECT(622,506), 0, 4, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f98, ABISELECT(622,506), 0, 4, hide_sll(1LL<<3), "S1991C3");
    set_bf_and_test(lv, s1991c3f99, ABISELECT(622,506), 4, 4, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f99, ABISELECT(622,506), 4, 4, hide_sll(1LL<<3), "S1991C3");
    set_bf_and_test(lv, s1991c3f100, ABISELECT(623,507), 0, 4, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f100, ABISELECT(623,507), 0, 4, hide_sll(1LL<<3), "S1991C3");
    set_bf_and_test(lv, s1991c3f101, ABISELECT(623,507), 4, 4, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f101, ABISELECT(623,507), 4, 4, hide_sll(1LL<<3), "S1991C3");
    set_bf_and_test(lv, s1991c3f102, ABISELECT(624,508), 0, 4, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f102, ABISELECT(624,508), 0, 4, hide_sll(1LL<<3), "S1991C3");
    set_bf_and_test(lv, s1991c3f103, ABISELECT(624,508), 4, 4, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f103, ABISELECT(624,508), 4, 4, hide_sll(1LL<<3), "S1991C3");
    set_bf_and_test(lv, s1991c3f104, ABISELECT(625,509), 0, 4, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f104, ABISELECT(625,509), 0, 4, hide_sll(1LL<<3), "S1991C3");
    set_bf_and_test(lv, s1991c3f105, ABISELECT(625,509), 4, 4, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f105, ABISELECT(625,509), 4, 4, hide_sll(1LL<<3), "S1991C3");
    set_bf_and_test(lv, s1991c3f106, ABISELECT(626,510), 0, 8, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f106, ABISELECT(626,510), 0, 8, hide_sll(1LL<<7), "S1991C3");
    set_bf_and_test(lv, s1991c3f107, ABISELECT(627,511), 0, 8, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f107, ABISELECT(627,511), 0, 8, hide_sll(1LL<<7), "S1991C3");
    set_bf_and_test(lv, s1991c3f108, ABISELECT(628,512), 0, 8, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f108, ABISELECT(628,512), 0, 8, hide_sll(1LL<<7), "S1991C3");
    check_field_offset(lv, s1991c3f109, ABISELECT(632,516), "S1991C3.s1991c3f109");
    check_field_offset(lv, s1991c3f110, ABISELECT(688,544), "S1991C3.s1991c3f110");
    check_field_offset(lv, s1991c3f111, ABISELECT(712,560), "S1991C3.s1991c3f111");
    set_bf_and_test(lv, s1991c3f112, ABISELECT(728,568), 0, 16, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f112, ABISELECT(728,568), 0, 16, hide_sll(1LL<<15), "S1991C3");
    set_bf_and_test(lv, s1991c3f113, ABISELECT(730,570), 0, 16, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f113, ABISELECT(730,570), 0, 16, hide_sll(1LL<<15), "S1991C3");
    check_field_offset(lv, s1991c3f114, ABISELECT(736,572), "S1991C3.s1991c3f114");
    check_field_offset(lv, s1991c3f115, ABISELECT(752,584), "S1991C3.s1991c3f115");
    check_field_offset(lv, s1991c3f116, ABISELECT(776,600), "S1991C3.s1991c3f116");
    check_field_offset(lv, s1991c3f117, ABISELECT(800,616), "S1991C3.s1991c3f117");
    set_bf_and_test(lv, s1991c3f118, ABISELECT(816,624), 0, 24, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f118, ABISELECT(816,624), 0, 24, hide_sll(1LL<<23), "S1991C3");
    set_bf_and_test(lv, s1991c3f119, ABISELECT(819,627), 0, 8, 1, "S1991C3");
    set_bf_and_test(lv, s1991c3f119, ABISELECT(819,627), 0, 8, hide_sll(1LL<<7), "S1991C3");
    check_field_offset(lv, s1991c3f120, ABISELECT(824,628), "S1991C3.s1991c3f120");
    test_class_info(&lv, &cd_S1991C3);
    dp->~S1991C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1991C3(Test_S1991C3, "S1991C3", ABISELECT(832,632));

#else // __cplusplus

extern void _ZN7S1991C3C1Ev();
extern void _ZN7S1991C3D1Ev();
Name_Map name_map_S1991C3[] = {
  NSPAIR(_ZN7S1991C3C1Ev),
  NSPAIR(_ZN7S1991C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1991C4;
extern VTBL_ENTRY _ZTI7S1991C4[];
extern  VTBL_ENTRY _ZTV7S1991C4[];
static Base_Class bases_S1991C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1991C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1991C3[];
extern void _ZN7S1991C3D1Ev();
extern void _ZN7S1991C3D0Ev();
extern void _ZN7S1991C42v1Ev();
extern void _ZN7S1991C42v2Ev();
extern void _ZN7S1991C42v3Ev();
extern void _ZN7S1991C42v4Ev();
extern void _ZN7S1991C42v5Ev();
extern void _ZN7S1991C42v6Ev();
extern void _ZN7S1991C42v7Ev();
extern void _ZN7S1991C42v8Ev();
extern void _ZN7S1991C42v9Ev();
extern void _ZN7S1991C43v10Ev();
extern void _ZN7S1991C43v11Ev();
extern void _ZN7S1991C43v12Ev();
extern void _ZN7S1991C43v13Ev();
extern void _ZN7S1991C43v14Ev();
extern void _ZN7S1991C43v15Ev();
extern void _ZN7S1991C43v16Ev();
extern void _ZN7S1991C43v17Ev();
extern void _ZN7S1991C43v18Ev();
extern void _ZN7S1991C43v19Ev();
extern void _ZN7S1991C43v20Ev();
extern void _ZN7S1991C43v21Ev();
extern void _ZN7S1991C43v22Ev();
extern void _ZN7S1991C43v23Ev();
extern void _ZN7S1991C33v24Ev();
extern void _ZN7S1991C33v25Ev();
extern void _ZN7S1991C33v26Ev();
extern void _ZN7S1991C33v27Ev();
extern void _ZN7S1991C33v28Ev();
extern void _ZN7S1991C33v29Ev();
extern void _ZN7S1991C33v30Ev();
extern void _ZN7S1991C33v31Ev();
extern void _ZN7S1991C33v32Ev();
extern void _ZN7S1991C33v33Ev();
extern void _ZN7S1991C33v34Ev();
extern void _ZN7S1991C33v35Ev();
extern void _ZN7S1991C33v36Ev();
extern void _ZN7S1991C33v37Ev();
extern void _ZN7S1991C33v38Ev();
extern void _ZN7S1991C33v39Ev();
extern void _ZN7S1991C33v40Ev();
extern void _ZN7S1991C33v41Ev();
extern void _ZN7S1991C33v42Ev();
extern void _ZN7S1991C33v43Ev();
extern void _ZN7S1991C33v44Ev();
extern void _ZN7S1991C33v45Ev();
extern void _ZN7S1991C33v46Ev();
extern void _ZN7S1991C33v47Ev();
extern void _ZN7S1991C33v48Ev();
extern void _ZN7S1991C33v49Ev();
extern void _ZN7S1991C33v50Ev();
extern void _ZN7S1991C33v51Ev();
extern void _ZN7S1991C33v52Ev();
extern void _ZN7S1991C33v53Ev();
extern void _ZN7S1991C33v54Ev();
extern void _ZN7S1991C33v55Ev();
extern void _ZN7S1991C33v56Ev();
extern void _ZN7S1991C33v57Ev();
extern void _ZN7S1991C33v58Ev();
extern void _ZN7S1991C33v59Ev();
extern void _ZN7S1991C33v60Ev();
extern void _ZN7S1991C33v61Ev();
extern void _ZN7S1991C33v62Ev();
extern void _ZN7S1991C33v63Ev();
extern void _ZN7S1991C33v64Ev();
extern void _ZN7S1991C33v65Ev();
extern void _ZN7S1991C33v66Ev();
extern void _ZN7S1991C33v67Ev();
extern void _ZN7S1991C33v68Ev();
extern void _ZN7S1991C33v69Ev();
extern void _ZN7S1991C33v70Ev();
extern void _ZN7S1991C33v71Ev();
extern void _ZN7S1991C33v72Ev();
extern void _ZN7S1991C33v73Ev();
extern void _ZN7S1991C33v74Ev();
extern void _ZN7S1991C33v75Ev();
extern void _ZN7S1991C33v76Ev();
extern void _ZN7S1991C33v77Ev();
extern void _ZN7S1991C33v78Ev();
extern void _ZN7S1991C33v79Ev();
extern void _ZN7S1991C33v80Ev();
extern void _ZN7S1991C33v81Ev();
extern void _ZN7S1991C33v82Ev();
extern void _ZN7S1991C33v83Ev();
extern void _ZN7S1991C33v84Ev();
extern void _ZN7S1991C33v85Ev();
extern void _ZN7S1991C33v86Ev();
extern void _ZN7S1991C33v87Ev();
extern void _ZN7S1991C33v88Ev();
extern void _ZN7S1991C33v89Ev();
extern void _ZN7S1991C33v90Ev();
extern void _ZN7S1991C33v91Ev();
extern void _ZN7S1991C33v92Ev();
extern void _ZN7S1991C33v93Ev();
extern void _ZN7S1991C33v94Ev();
extern void _ZN7S1991C33v95Ev();
extern void _ZN7S1991C33v96Ev();
extern void _ZN7S1991C33v97Ev();
extern void _ZN7S1991C33v98Ev();
extern void _ZN7S1991C33v99Ev();
extern void _ZN7S1991C34v100Ev();
extern void _ZN7S1991C34v101Ev();
static  VTBL_ENTRY vtc_S1991C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1991C3[0]),
  (VTBL_ENTRY)&_ZN7S1991C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1991C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v1Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v29Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v30Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v31Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v32Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v33Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v34Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v35Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v36Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v37Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v38Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v39Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v40Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v41Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v42Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v43Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v44Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v45Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v46Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v47Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v48Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v49Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v50Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v51Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v52Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v53Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v54Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v55Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v56Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v57Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v58Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v59Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v60Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v61Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v62Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v63Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v64Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v65Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v66Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v67Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v68Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v69Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1991C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1991C34v101Ev,
};
extern VTBL_ENTRY _ZTI7S1991C3[];
extern  VTBL_ENTRY _ZTV7S1991C3[];
Class_Descriptor cd_S1991C3 = {  "S1991C3", // class name
  bases_S1991C3, 1,
  &(vtc_S1991C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI7S1991C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1991C3),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1991C2  : S1991C3 {
  void *s1991c2f0;
  char s1991c2f1;
  ::S1990C39_nt s1991c2f2;
  ::S1990C19_nt s1991c2f3;
  virtual  ~S1991C2(); // _ZN7S1991C2D1Ev
  virtual void  v102(); // _ZN7S1991C24v102Ev
  virtual void  v103(); // _ZN7S1991C24v103Ev
  virtual void  v104(); // _ZN7S1991C24v104Ev
  virtual void  v105(); // _ZN7S1991C24v105Ev
  virtual void  v106(); // _ZN7S1991C24v106Ev
  virtual void  v107(); // _ZN7S1991C24v107Ev
  virtual void  v108(); // _ZN7S1991C24v108Ev
  virtual void  v109(); // _ZN7S1991C24v109Ev
  virtual void  v110(); // _ZN7S1991C24v110Ev
  S1991C2(); // tgen
};
//SIG(-1 S1991C2) C1{ BC2{ BC3{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 Fp Fi FC4{ BC5{ m Fp Fi FC6{ m} FC7{ m}}} FC8{ BC9{ m Fp Fi FC10{ m} FC11{ m}}} Fi} vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 FC12{ m FC13{ m FL[2]}} FC12 FC12 FC14{ m FC13} FC15{ m FC14} FC16{ m FC14 FC14 FC14 FC14} FC16 FC12 FC12 FC12 Fp FC15 FC17{ m FC18{ m Fp Fi FC19{ m}} Fi} Fi Fp[7] FC9 Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC20{ BC5} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC21{ m Fp Fi[2] FC11} Fp[2] Fi:16 Fi:16 FC22{ BC23{ m Fp Fi FC24{ m} FC24}} FC25{ m Fp Fi[2] FC10} FC26{ m Fp Fi[2] FC7} Fp[2] Fi:24 Fi:8 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fp Fc FC27{ m FC25 FC8 FC21 FC8} FC17}


 S1991C2 ::~S1991C2(){ note_dtor("S1991C2", this);}
void  S1991C2 ::v102(){vfunc_called(this, "_ZN7S1991C24v102Ev");}
void  S1991C2 ::v103(){vfunc_called(this, "_ZN7S1991C24v103Ev");}
void  S1991C2 ::v104(){vfunc_called(this, "_ZN7S1991C24v104Ev");}
void  S1991C2 ::v105(){vfunc_called(this, "_ZN7S1991C24v105Ev");}
void  S1991C2 ::v106(){vfunc_called(this, "_ZN7S1991C24v106Ev");}
void  S1991C2 ::v107(){vfunc_called(this, "_ZN7S1991C24v107Ev");}
void  S1991C2 ::v108(){vfunc_called(this, "_ZN7S1991C24v108Ev");}
void  S1991C2 ::v109(){vfunc_called(this, "_ZN7S1991C24v109Ev");}
void  S1991C2 ::v110(){vfunc_called(this, "_ZN7S1991C24v110Ev");}
S1991C2 ::S1991C2(){ note_ctor("S1991C2", this);} // tgen

static void Test_S1991C2()
{
  extern Class_Descriptor cd_S1991C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(120,179)];
    init_test(&cd_S1991C2, buf);
    S1991C2 *dp, &lv = *(dp=new (buf) S1991C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(952,712), "sizeof(S1991C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1991C2)");
    check_base_class_offset(lv, (S1991C4*)(S1991C3*), 0, "S1991C2");
    check_base_class_offset(lv, (S1991C3*), 0, "S1991C2");
    check_field_offset(lv, s1991c2f0, ABISELECT(832,632), "S1991C2.s1991c2f0");
    check_field_offset(lv, s1991c2f1, ABISELECT(840,636), "S1991C2.s1991c2f1");
    check_field_offset(lv, s1991c2f2, ABISELECT(848,640), "S1991C2.s1991c2f2");
    check_field_offset(lv, s1991c2f3, ABISELECT(928,696), "S1991C2.s1991c2f3");
    test_class_info(&lv, &cd_S1991C2);
    dp->~S1991C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1991C2(Test_S1991C2, "S1991C2", ABISELECT(952,712));

#else // __cplusplus

extern void _ZN7S1991C2C1Ev();
extern void _ZN7S1991C2D1Ev();
Name_Map name_map_S1991C2[] = {
  NSPAIR(_ZN7S1991C2C1Ev),
  NSPAIR(_ZN7S1991C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1991C4;
extern VTBL_ENTRY _ZTI7S1991C4[];
extern  VTBL_ENTRY _ZTV7S1991C4[];
extern Class_Descriptor cd_S1991C3;
extern VTBL_ENTRY _ZTI7S1991C3[];
extern  VTBL_ENTRY _ZTV7S1991C3[];
static Base_Class bases_S1991C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1991C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1991C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1991C2[];
extern void _ZN7S1991C2D1Ev();
extern void _ZN7S1991C2D0Ev();
extern void _ZN7S1991C42v1Ev();
extern void _ZN7S1991C42v2Ev();
extern void _ZN7S1991C42v3Ev();
extern void _ZN7S1991C42v4Ev();
extern void _ZN7S1991C42v5Ev();
extern void _ZN7S1991C42v6Ev();
extern void _ZN7S1991C42v7Ev();
extern void _ZN7S1991C42v8Ev();
extern void _ZN7S1991C42v9Ev();
extern void _ZN7S1991C43v10Ev();
extern void _ZN7S1991C43v11Ev();
extern void _ZN7S1991C43v12Ev();
extern void _ZN7S1991C43v13Ev();
extern void _ZN7S1991C43v14Ev();
extern void _ZN7S1991C43v15Ev();
extern void _ZN7S1991C43v16Ev();
extern void _ZN7S1991C43v17Ev();
extern void _ZN7S1991C43v18Ev();
extern void _ZN7S1991C43v19Ev();
extern void _ZN7S1991C43v20Ev();
extern void _ZN7S1991C43v21Ev();
extern void _ZN7S1991C43v22Ev();
extern void _ZN7S1991C43v23Ev();
extern void _ZN7S1991C33v24Ev();
extern void _ZN7S1991C33v25Ev();
extern void _ZN7S1991C33v26Ev();
extern void _ZN7S1991C33v27Ev();
extern void _ZN7S1991C33v28Ev();
extern void _ZN7S1991C33v29Ev();
extern void _ZN7S1991C33v30Ev();
extern void _ZN7S1991C33v31Ev();
extern void _ZN7S1991C33v32Ev();
extern void _ZN7S1991C33v33Ev();
extern void _ZN7S1991C33v34Ev();
extern void _ZN7S1991C33v35Ev();
extern void _ZN7S1991C33v36Ev();
extern void _ZN7S1991C33v37Ev();
extern void _ZN7S1991C33v38Ev();
extern void _ZN7S1991C33v39Ev();
extern void _ZN7S1991C33v40Ev();
extern void _ZN7S1991C33v41Ev();
extern void _ZN7S1991C33v42Ev();
extern void _ZN7S1991C33v43Ev();
extern void _ZN7S1991C33v44Ev();
extern void _ZN7S1991C33v45Ev();
extern void _ZN7S1991C33v46Ev();
extern void _ZN7S1991C33v47Ev();
extern void _ZN7S1991C33v48Ev();
extern void _ZN7S1991C33v49Ev();
extern void _ZN7S1991C33v50Ev();
extern void _ZN7S1991C33v51Ev();
extern void _ZN7S1991C33v52Ev();
extern void _ZN7S1991C33v53Ev();
extern void _ZN7S1991C33v54Ev();
extern void _ZN7S1991C33v55Ev();
extern void _ZN7S1991C33v56Ev();
extern void _ZN7S1991C33v57Ev();
extern void _ZN7S1991C33v58Ev();
extern void _ZN7S1991C33v59Ev();
extern void _ZN7S1991C33v60Ev();
extern void _ZN7S1991C33v61Ev();
extern void _ZN7S1991C33v62Ev();
extern void _ZN7S1991C33v63Ev();
extern void _ZN7S1991C33v64Ev();
extern void _ZN7S1991C33v65Ev();
extern void _ZN7S1991C33v66Ev();
extern void _ZN7S1991C33v67Ev();
extern void _ZN7S1991C33v68Ev();
extern void _ZN7S1991C33v69Ev();
extern void _ZN7S1991C33v70Ev();
extern void _ZN7S1991C33v71Ev();
extern void _ZN7S1991C33v72Ev();
extern void _ZN7S1991C33v73Ev();
extern void _ZN7S1991C33v74Ev();
extern void _ZN7S1991C33v75Ev();
extern void _ZN7S1991C33v76Ev();
extern void _ZN7S1991C33v77Ev();
extern void _ZN7S1991C33v78Ev();
extern void _ZN7S1991C33v79Ev();
extern void _ZN7S1991C33v80Ev();
extern void _ZN7S1991C33v81Ev();
extern void _ZN7S1991C33v82Ev();
extern void _ZN7S1991C33v83Ev();
extern void _ZN7S1991C33v84Ev();
extern void _ZN7S1991C33v85Ev();
extern void _ZN7S1991C33v86Ev();
extern void _ZN7S1991C33v87Ev();
extern void _ZN7S1991C33v88Ev();
extern void _ZN7S1991C33v89Ev();
extern void _ZN7S1991C33v90Ev();
extern void _ZN7S1991C33v91Ev();
extern void _ZN7S1991C33v92Ev();
extern void _ZN7S1991C33v93Ev();
extern void _ZN7S1991C33v94Ev();
extern void _ZN7S1991C33v95Ev();
extern void _ZN7S1991C33v96Ev();
extern void _ZN7S1991C33v97Ev();
extern void _ZN7S1991C33v98Ev();
extern void _ZN7S1991C33v99Ev();
extern void _ZN7S1991C34v100Ev();
extern void _ZN7S1991C34v101Ev();
extern void _ZN7S1991C24v102Ev();
extern void _ZN7S1991C24v103Ev();
extern void _ZN7S1991C24v104Ev();
extern void _ZN7S1991C24v105Ev();
extern void _ZN7S1991C24v106Ev();
extern void _ZN7S1991C24v107Ev();
extern void _ZN7S1991C24v108Ev();
extern void _ZN7S1991C24v109Ev();
extern void _ZN7S1991C24v110Ev();
static  VTBL_ENTRY vtc_S1991C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1991C2[0]),
  (VTBL_ENTRY)&_ZN7S1991C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1991C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v1Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v29Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v30Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v31Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v32Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v33Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v34Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v35Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v36Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v37Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v38Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v39Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v40Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v41Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v42Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v43Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v44Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v45Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v46Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v47Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v48Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v49Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v50Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v51Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v52Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v53Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v54Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v55Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v56Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v57Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v58Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v59Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v60Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v61Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v62Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v63Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v64Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v65Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v66Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v67Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v68Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v69Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1991C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1991C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1991C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1991C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1991C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1991C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1991C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1991C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1991C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1991C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1991C24v110Ev,
};
extern VTBL_ENTRY _ZTI7S1991C2[];
extern  VTBL_ENTRY _ZTV7S1991C2[];
Class_Descriptor cd_S1991C2 = {  "S1991C2", // class name
  bases_S1991C2, 2,
  &(vtc_S1991C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(952,712), // object size
  NSPAIRA(_ZTI7S1991C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1991C2),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1991C1  : S1991C2 {
  ::S1990C20_nt s1991c1f0;
  ::S1990C20_nt s1991c1f1;
  int s1991c1f2;
  ::S1990C52_nt s1991c1f3;
  int s1991c1f4;
  virtual  ~S1991C1(); // _ZN7S1991C1D1Ev
  S1991C1(); // tgen
};
//SIG(1 S1991C1) C1{ BC2{ BC3{ BC4{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC5{ BC6{ m Fp Fi FC7{ m} FC8{ m}}} FC9{ BC10{ m Fp Fi FC11{ m} FC12{ m}}} Fi} vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 FC13{ m FC14{ m FL[2]}} FC13 FC13 FC15{ m FC14} FC16{ m FC15} FC17{ m FC15 FC15 FC15 FC15} FC17 FC13 FC13 FC13 Fp FC16 FC18{ m FC19{ m Fp Fi FC20{ m}} Fi} Fi Fp[7] FC10 Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC21{ BC6} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC22{ m Fp Fi[2] FC12} Fp[2] Fi:16 Fi:16 FC23{ BC24{ m Fp Fi FC25{ m} FC25}} FC26{ m Fp Fi[2] FC11} FC27{ m Fp Fi[2] FC8} Fp[2] Fi:24 Fi:8 Fp} vd v102 v103 v104 v105 v106 v107 v108 v109 v110 Fp Fc FC28{ m FC26 FC9 FC22 FC9} FC18} vd FC19 FC19 Fi FC29{ m Fp[2]} Fi}


 S1991C1 ::~S1991C1(){ note_dtor("S1991C1", this);}
S1991C1 ::S1991C1(){ note_ctor("S1991C1", this);} // tgen

static void Test_S1991C1()
{
  extern Class_Descriptor cd_S1991C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(128,189)];
    init_test(&cd_S1991C1, buf);
    S1991C1 *dp, &lv = *(dp=new (buf) S1991C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1016,752), "sizeof(S1991C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1991C1)");
    check_base_class_offset(lv, (S1991C4*)(S1991C3*)(S1991C2*), 0, "S1991C1");
    check_base_class_offset(lv, (S1991C3*)(S1991C2*), 0, "S1991C1");
    check_base_class_offset(lv, (S1991C2*), 0, "S1991C1");
    check_field_offset(lv, s1991c1f0, ABISELECT(952,712), "S1991C1.s1991c1f0");
    check_field_offset(lv, s1991c1f1, ABISELECT(968,724), "S1991C1.s1991c1f1");
    check_field_offset(lv, s1991c1f2, ABISELECT(984,736), "S1991C1.s1991c1f2");
    check_field_offset(lv, s1991c1f3, ABISELECT(992,740), "S1991C1.s1991c1f3");
    check_field_offset(lv, s1991c1f4, ABISELECT(1008,748), "S1991C1.s1991c1f4");
    test_class_info(&lv, &cd_S1991C1);
    dp->~S1991C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1991C1(Test_S1991C1, "S1991C1", ABISELECT(1016,752));

#else // __cplusplus

extern void _ZN7S1991C1C1Ev();
extern void _ZN7S1991C1D1Ev();
Name_Map name_map_S1991C1[] = {
  NSPAIR(_ZN7S1991C1C1Ev),
  NSPAIR(_ZN7S1991C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1991C4;
extern VTBL_ENTRY _ZTI7S1991C4[];
extern  VTBL_ENTRY _ZTV7S1991C4[];
extern Class_Descriptor cd_S1991C3;
extern VTBL_ENTRY _ZTI7S1991C3[];
extern  VTBL_ENTRY _ZTV7S1991C3[];
extern Class_Descriptor cd_S1991C2;
extern VTBL_ENTRY _ZTI7S1991C2[];
extern  VTBL_ENTRY _ZTV7S1991C2[];
static Base_Class bases_S1991C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1991C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1991C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1991C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1991C1[];
extern void _ZN7S1991C1D1Ev();
extern void _ZN7S1991C1D0Ev();
extern void _ZN7S1991C42v1Ev();
extern void _ZN7S1991C42v2Ev();
extern void _ZN7S1991C42v3Ev();
extern void _ZN7S1991C42v4Ev();
extern void _ZN7S1991C42v5Ev();
extern void _ZN7S1991C42v6Ev();
extern void _ZN7S1991C42v7Ev();
extern void _ZN7S1991C42v8Ev();
extern void _ZN7S1991C42v9Ev();
extern void _ZN7S1991C43v10Ev();
extern void _ZN7S1991C43v11Ev();
extern void _ZN7S1991C43v12Ev();
extern void _ZN7S1991C43v13Ev();
extern void _ZN7S1991C43v14Ev();
extern void _ZN7S1991C43v15Ev();
extern void _ZN7S1991C43v16Ev();
extern void _ZN7S1991C43v17Ev();
extern void _ZN7S1991C43v18Ev();
extern void _ZN7S1991C43v19Ev();
extern void _ZN7S1991C43v20Ev();
extern void _ZN7S1991C43v21Ev();
extern void _ZN7S1991C43v22Ev();
extern void _ZN7S1991C43v23Ev();
extern void _ZN7S1991C33v24Ev();
extern void _ZN7S1991C33v25Ev();
extern void _ZN7S1991C33v26Ev();
extern void _ZN7S1991C33v27Ev();
extern void _ZN7S1991C33v28Ev();
extern void _ZN7S1991C33v29Ev();
extern void _ZN7S1991C33v30Ev();
extern void _ZN7S1991C33v31Ev();
extern void _ZN7S1991C33v32Ev();
extern void _ZN7S1991C33v33Ev();
extern void _ZN7S1991C33v34Ev();
extern void _ZN7S1991C33v35Ev();
extern void _ZN7S1991C33v36Ev();
extern void _ZN7S1991C33v37Ev();
extern void _ZN7S1991C33v38Ev();
extern void _ZN7S1991C33v39Ev();
extern void _ZN7S1991C33v40Ev();
extern void _ZN7S1991C33v41Ev();
extern void _ZN7S1991C33v42Ev();
extern void _ZN7S1991C33v43Ev();
extern void _ZN7S1991C33v44Ev();
extern void _ZN7S1991C33v45Ev();
extern void _ZN7S1991C33v46Ev();
extern void _ZN7S1991C33v47Ev();
extern void _ZN7S1991C33v48Ev();
extern void _ZN7S1991C33v49Ev();
extern void _ZN7S1991C33v50Ev();
extern void _ZN7S1991C33v51Ev();
extern void _ZN7S1991C33v52Ev();
extern void _ZN7S1991C33v53Ev();
extern void _ZN7S1991C33v54Ev();
extern void _ZN7S1991C33v55Ev();
extern void _ZN7S1991C33v56Ev();
extern void _ZN7S1991C33v57Ev();
extern void _ZN7S1991C33v58Ev();
extern void _ZN7S1991C33v59Ev();
extern void _ZN7S1991C33v60Ev();
extern void _ZN7S1991C33v61Ev();
extern void _ZN7S1991C33v62Ev();
extern void _ZN7S1991C33v63Ev();
extern void _ZN7S1991C33v64Ev();
extern void _ZN7S1991C33v65Ev();
extern void _ZN7S1991C33v66Ev();
extern void _ZN7S1991C33v67Ev();
extern void _ZN7S1991C33v68Ev();
extern void _ZN7S1991C33v69Ev();
extern void _ZN7S1991C33v70Ev();
extern void _ZN7S1991C33v71Ev();
extern void _ZN7S1991C33v72Ev();
extern void _ZN7S1991C33v73Ev();
extern void _ZN7S1991C33v74Ev();
extern void _ZN7S1991C33v75Ev();
extern void _ZN7S1991C33v76Ev();
extern void _ZN7S1991C33v77Ev();
extern void _ZN7S1991C33v78Ev();
extern void _ZN7S1991C33v79Ev();
extern void _ZN7S1991C33v80Ev();
extern void _ZN7S1991C33v81Ev();
extern void _ZN7S1991C33v82Ev();
extern void _ZN7S1991C33v83Ev();
extern void _ZN7S1991C33v84Ev();
extern void _ZN7S1991C33v85Ev();
extern void _ZN7S1991C33v86Ev();
extern void _ZN7S1991C33v87Ev();
extern void _ZN7S1991C33v88Ev();
extern void _ZN7S1991C33v89Ev();
extern void _ZN7S1991C33v90Ev();
extern void _ZN7S1991C33v91Ev();
extern void _ZN7S1991C33v92Ev();
extern void _ZN7S1991C33v93Ev();
extern void _ZN7S1991C33v94Ev();
extern void _ZN7S1991C33v95Ev();
extern void _ZN7S1991C33v96Ev();
extern void _ZN7S1991C33v97Ev();
extern void _ZN7S1991C33v98Ev();
extern void _ZN7S1991C33v99Ev();
extern void _ZN7S1991C34v100Ev();
extern void _ZN7S1991C34v101Ev();
extern void _ZN7S1991C24v102Ev();
extern void _ZN7S1991C24v103Ev();
extern void _ZN7S1991C24v104Ev();
extern void _ZN7S1991C24v105Ev();
extern void _ZN7S1991C24v106Ev();
extern void _ZN7S1991C24v107Ev();
extern void _ZN7S1991C24v108Ev();
extern void _ZN7S1991C24v109Ev();
extern void _ZN7S1991C24v110Ev();
static  VTBL_ENTRY vtc_S1991C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1991C1[0]),
  (VTBL_ENTRY)&_ZN7S1991C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1991C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v1Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1991C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1991C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v29Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v30Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v31Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v32Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v33Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v34Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v35Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v36Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v37Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v38Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v39Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v40Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v41Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v42Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v43Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v44Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v45Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v46Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v47Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v48Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v49Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v50Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v51Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v52Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v53Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v54Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v55Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v56Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v57Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v58Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v59Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v60Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v61Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v62Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v63Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v64Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v65Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v66Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v67Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v68Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v69Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1991C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1991C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1991C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1991C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1991C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1991C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1991C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1991C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1991C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1991C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1991C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1991C24v110Ev,
};
extern VTBL_ENTRY _ZTI7S1991C1[];
extern  VTBL_ENTRY _ZTV7S1991C1[];
Class_Descriptor cd_S1991C1 = {  "S1991C1", // class name
  bases_S1991C1, 3,
  &(vtc_S1991C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1016,752), // object size
  NSPAIRA(_ZTI7S1991C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1991C1),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1992C4  {
  void *s1992c4f0;
  int s1992c4f1;
  ::S1993C31 s1992c4f2;
  ::S1990C42 s1992c4f3;
  int s1992c4f4;
  virtual  ~S1992C4(); // _ZN7S1992C4D1Ev
  virtual void  v1(); // _ZN7S1992C42v1Ev
  virtual void  v2(); // _ZN7S1992C42v2Ev
  virtual void  v3(); // _ZN7S1992C42v3Ev
  virtual void  v4(); // _ZN7S1992C42v4Ev
  virtual void  v5(); // _ZN7S1992C42v5Ev
  virtual void  v6(); // _ZN7S1992C42v6Ev
  virtual void  v7(); // _ZN7S1992C42v7Ev
  virtual void  v8(); // _ZN7S1992C42v8Ev
  virtual void  v9(); // _ZN7S1992C42v9Ev
  virtual void  v10(); // _ZN7S1992C43v10Ev
  virtual void  v11(); // _ZN7S1992C43v11Ev
  virtual void  v12(); // _ZN7S1992C43v12Ev
  virtual void  v13(); // _ZN7S1992C43v13Ev
  virtual void  v14(); // _ZN7S1992C43v14Ev
  virtual void  v15(); // _ZN7S1992C43v15Ev
  virtual void  v16(); // _ZN7S1992C43v16Ev
  virtual void  v17(); // _ZN7S1992C43v17Ev
  virtual void  v18(); // _ZN7S1992C43v18Ev
  virtual void  v19(); // _ZN7S1992C43v19Ev
  virtual void  v20(); // _ZN7S1992C43v20Ev
  virtual void  v21(); // _ZN7S1992C43v21Ev
  virtual void  v22(); // _ZN7S1992C43v22Ev
  virtual void  v23(); // _ZN7S1992C43v23Ev
  S1992C4(); // tgen
};
//SIG(-1 S1992C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}} FC6{ BC7{ m Fp Fi FC8{ m} FC9{ m}}} Fi}


 S1992C4 ::~S1992C4(){ note_dtor("S1992C4", this);}
void  S1992C4 ::v1(){vfunc_called(this, "_ZN7S1992C42v1Ev");}
void  S1992C4 ::v2(){vfunc_called(this, "_ZN7S1992C42v2Ev");}
void  S1992C4 ::v3(){vfunc_called(this, "_ZN7S1992C42v3Ev");}
void  S1992C4 ::v4(){vfunc_called(this, "_ZN7S1992C42v4Ev");}
void  S1992C4 ::v5(){vfunc_called(this, "_ZN7S1992C42v5Ev");}
void  S1992C4 ::v6(){vfunc_called(this, "_ZN7S1992C42v6Ev");}
void  S1992C4 ::v7(){vfunc_called(this, "_ZN7S1992C42v7Ev");}
void  S1992C4 ::v8(){vfunc_called(this, "_ZN7S1992C42v8Ev");}
void  S1992C4 ::v9(){vfunc_called(this, "_ZN7S1992C42v9Ev");}
void  S1992C4 ::v10(){vfunc_called(this, "_ZN7S1992C43v10Ev");}
void  S1992C4 ::v11(){vfunc_called(this, "_ZN7S1992C43v11Ev");}
void  S1992C4 ::v12(){vfunc_called(this, "_ZN7S1992C43v12Ev");}
void  S1992C4 ::v13(){vfunc_called(this, "_ZN7S1992C43v13Ev");}
void  S1992C4 ::v14(){vfunc_called(this, "_ZN7S1992C43v14Ev");}
void  S1992C4 ::v15(){vfunc_called(this, "_ZN7S1992C43v15Ev");}
void  S1992C4 ::v16(){vfunc_called(this, "_ZN7S1992C43v16Ev");}
void  S1992C4 ::v17(){vfunc_called(this, "_ZN7S1992C43v17Ev");}
void  S1992C4 ::v18(){vfunc_called(this, "_ZN7S1992C43v18Ev");}
void  S1992C4 ::v19(){vfunc_called(this, "_ZN7S1992C43v19Ev");}
void  S1992C4 ::v20(){vfunc_called(this, "_ZN7S1992C43v20Ev");}
void  S1992C4 ::v21(){vfunc_called(this, "_ZN7S1992C43v21Ev");}
void  S1992C4 ::v22(){vfunc_called(this, "_ZN7S1992C43v22Ev");}
void  S1992C4 ::v23(){vfunc_called(this, "_ZN7S1992C43v23Ev");}
S1992C4 ::S1992C4(){ note_ctor("S1992C4", this);} // tgen

static void Test_S1992C4()
{
  extern Class_Descriptor cd_S1992C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_S1992C4, buf);
    S1992C4 *dp, &lv = *(dp=new (buf) S1992C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(S1992C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1992C4)");
    check_field_offset(lv, s1992c4f0, ABISELECT(8,4), "S1992C4.s1992c4f0");
    check_field_offset(lv, s1992c4f1, ABISELECT(16,8), "S1992C4.s1992c4f1");
    check_field_offset(lv, s1992c4f2, ABISELECT(24,12), "S1992C4.s1992c4f2");
    check_field_offset(lv, s1992c4f3, ABISELECT(40,24), "S1992C4.s1992c4f3");
    check_field_offset(lv, s1992c4f4, ABISELECT(56,36), "S1992C4.s1992c4f4");
    test_class_info(&lv, &cd_S1992C4);
    dp->~S1992C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1992C4(Test_S1992C4, "S1992C4", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN7S1992C4C1Ev();
extern void _ZN7S1992C4D1Ev();
Name_Map name_map_S1992C4[] = {
  NSPAIR(_ZN7S1992C4C1Ev),
  NSPAIR(_ZN7S1992C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1992C4[];
extern void _ZN7S1992C4D1Ev();
extern void _ZN7S1992C4D0Ev();
extern void _ZN7S1992C42v1Ev();
extern void _ZN7S1992C42v2Ev();
extern void _ZN7S1992C42v3Ev();
extern void _ZN7S1992C42v4Ev();
extern void _ZN7S1992C42v5Ev();
extern void _ZN7S1992C42v6Ev();
extern void _ZN7S1992C42v7Ev();
extern void _ZN7S1992C42v8Ev();
extern void _ZN7S1992C42v9Ev();
extern void _ZN7S1992C43v10Ev();
extern void _ZN7S1992C43v11Ev();
extern void _ZN7S1992C43v12Ev();
extern void _ZN7S1992C43v13Ev();
extern void _ZN7S1992C43v14Ev();
extern void _ZN7S1992C43v15Ev();
extern void _ZN7S1992C43v16Ev();
extern void _ZN7S1992C43v17Ev();
extern void _ZN7S1992C43v18Ev();
extern void _ZN7S1992C43v19Ev();
extern void _ZN7S1992C43v20Ev();
extern void _ZN7S1992C43v21Ev();
extern void _ZN7S1992C43v22Ev();
extern void _ZN7S1992C43v23Ev();
static  VTBL_ENTRY vtc_S1992C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1992C4[0]),
  (VTBL_ENTRY)&_ZN7S1992C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1992C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v1Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v23Ev,
};
extern VTBL_ENTRY _ZTI7S1992C4[];
extern  VTBL_ENTRY _ZTV7S1992C4[];
Class_Descriptor cd_S1992C4 = {  "S1992C4", // class name
  0,0,//no base classes
  &(vtc_S1992C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI7S1992C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1992C4),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1992C3  : S1992C4 {
  ::S1993C15 s1992c3f0;
  ::S1993C15 s1992c3f1;
  ::S1993C15 s1992c3f2;
  ::S1990C13_nt s1992c3f3;
  ::S1990C17_nt s1992c3f4;
  ::S1990C18_nt s1992c3f5;
  ::S1990C18_nt s1992c3f6;
  ::S1993C15 s1992c3f7;
  ::S1993C15 s1992c3f8;
  ::S1993C15 s1992c3f9;
  void *s1992c3f10;
  ::S1990C17_nt s1992c3f11;
  ::S1990C19_nt s1992c3f12;
  int s1992c3f13;
  void *s1992c3f14[7];
  ::S1990C43 s1992c3f15;
  int s1992c3f16:8;
  int s1992c3f17:8;
  int s1992c3f18:16;
  int s1992c3f19:16;
  int s1992c3f20:8;
  int s1992c3f21:8;
  int s1992c3f22:8;
  int s1992c3f23:32;
  int s1992c3f24:8;
  int s1992c3f25:4;
  int s1992c3f26:4;
  int s1992c3f27:4;
  int s1992c3f28:4;
  int s1992c3f29:4;
  int s1992c3f30:4;
  int s1992c3f31:4;
  int s1992c3f32:4;
  int s1992c3f33:4;
  int s1992c3f34:4;
  unsigned char s1992c3f35:1;
  unsigned char s1992c3f36:1;
  unsigned char s1992c3f37:1;
  unsigned char s1992c3f38:1;
  unsigned char s1992c3f39:1;
  unsigned char s1992c3f40:1;
  unsigned char s1992c3f41:1;
  unsigned char s1992c3f42:1;
  unsigned char s1992c3f43:1;
  unsigned char s1992c3f44:1;
  unsigned char s1992c3f45:1;
  unsigned char s1992c3f46:1;
  unsigned char s1992c3f47:1;
  unsigned char s1992c3f48:1;
  unsigned char s1992c3f49:1;
  unsigned char s1992c3f50:1;
  unsigned char s1992c3f51:1;
  unsigned char s1992c3f52:1;
  unsigned char s1992c3f53:1;
  unsigned char s1992c3f54:1;
  unsigned char s1992c3f55:1;
  unsigned char s1992c3f56:1;
  unsigned char s1992c3f57:1;
  unsigned char s1992c3f58:1;
  unsigned char s1992c3f59:1;
  unsigned char s1992c3f60:1;
  unsigned char s1992c3f61:1;
  unsigned char s1992c3f62:1;
  unsigned char s1992c3f63:1;
  unsigned char s1992c3f64:1;
  unsigned char s1992c3f65:1;
  unsigned char s1992c3f66:1;
  unsigned char s1992c3f67:1;
  unsigned char s1992c3f68:1;
  unsigned char s1992c3f69:1;
  unsigned char s1992c3f70:1;
  unsigned char s1992c3f71:1;
  unsigned char s1992c3f72:1;
  unsigned char s1992c3f73:1;
  unsigned char s1992c3f74:1;
  unsigned char s1992c3f75:1;
  int s1992c3f76[7];
  void *s1992c3f77[6];
  int s1992c3f78:8;
  int s1992c3f79:8;
  int s1992c3f80:8;
  int s1992c3f81:8;
  int s1992c3f82:8;
  int s1992c3f83:8;
  ::S1990C25 s1992c3f84;
  void *s1992c3f85[4];
  int s1992c3f86:8;
  int s1992c3f87:8;
  int s1992c3f88:8;
  int s1992c3f89:8;
  int s1992c3f90:8;
  int s1992c3f91:16;
  int s1992c3f92:16;
  int s1992c3f93:16;
  int s1992c3f94:4;
  int s1992c3f95:4;
  int s1992c3f96:4;
  int s1992c3f97:4;
  int s1992c3f98:4;
  int s1992c3f99:4;
  int s1992c3f100:4;
  int s1992c3f101:4;
  int s1992c3f102:4;
  int s1992c3f103:4;
  int s1992c3f104:4;
  int s1992c3f105:4;
  int s1992c3f106:8;
  int s1992c3f107:8;
  int s1992c3f108:8;
  void *s1992c3f109[7];
  ::S1990C46 s1992c3f110;
  void *s1992c3f111[2];
  int s1992c3f112:16;
  int s1992c3f113:16;
  ::S1990C5_nt s1992c3f114;
  ::S1990C37 s1992c3f115;
  ::S1990C29_nt s1992c3f116;
  void *s1992c3f117[2];
  int s1992c3f118:24;
  int s1992c3f119:8;
  void *s1992c3f120;
  virtual  ~S1992C3(); // _ZN7S1992C3D1Ev
  virtual void  v24(); // _ZN7S1992C33v24Ev
  virtual void  v25(); // _ZN7S1992C33v25Ev
  virtual void  v26(); // _ZN7S1992C33v26Ev
  virtual void  v27(); // _ZN7S1992C33v27Ev
  virtual void  v28(); // _ZN7S1992C33v28Ev
  virtual void  v29(); // _ZN7S1992C33v29Ev
  virtual void  v30(); // _ZN7S1992C33v30Ev
  virtual void  v31(); // _ZN7S1992C33v31Ev
  virtual void  v32(); // _ZN7S1992C33v32Ev
  virtual void  v33(); // _ZN7S1992C33v33Ev
  virtual void  v34(); // _ZN7S1992C33v34Ev
  virtual void  v35(); // _ZN7S1992C33v35Ev
  virtual void  v36(); // _ZN7S1992C33v36Ev
  virtual void  v37(); // _ZN7S1992C33v37Ev
  virtual void  v38(); // _ZN7S1992C33v38Ev
  virtual void  v39(); // _ZN7S1992C33v39Ev
  virtual void  v40(); // _ZN7S1992C33v40Ev
  virtual void  v41(); // _ZN7S1992C33v41Ev
  virtual void  v42(); // _ZN7S1992C33v42Ev
  virtual void  v43(); // _ZN7S1992C33v43Ev
  virtual void  v44(); // _ZN7S1992C33v44Ev
  virtual void  v45(); // _ZN7S1992C33v45Ev
  virtual void  v46(); // _ZN7S1992C33v46Ev
  virtual void  v47(); // _ZN7S1992C33v47Ev
  virtual void  v48(); // _ZN7S1992C33v48Ev
  virtual void  v49(); // _ZN7S1992C33v49Ev
  virtual void  v50(); // _ZN7S1992C33v50Ev
  virtual void  v51(); // _ZN7S1992C33v51Ev
  virtual void  v52(); // _ZN7S1992C33v52Ev
  virtual void  v53(); // _ZN7S1992C33v53Ev
  virtual void  v54(); // _ZN7S1992C33v54Ev
  virtual void  v55(); // _ZN7S1992C33v55Ev
  virtual void  v56(); // _ZN7S1992C33v56Ev
  virtual void  v57(); // _ZN7S1992C33v57Ev
  virtual void  v58(); // _ZN7S1992C33v58Ev
  virtual void  v59(); // _ZN7S1992C33v59Ev
  virtual void  v60(); // _ZN7S1992C33v60Ev
  virtual void  v61(); // _ZN7S1992C33v61Ev
  virtual void  v62(); // _ZN7S1992C33v62Ev
  virtual void  v63(); // _ZN7S1992C33v63Ev
  virtual void  v64(); // _ZN7S1992C33v64Ev
  virtual void  v65(); // _ZN7S1992C33v65Ev
  virtual void  v66(); // _ZN7S1992C33v66Ev
  virtual void  v67(); // _ZN7S1992C33v67Ev
  virtual void  v68(); // _ZN7S1992C33v68Ev
  virtual void  v69(); // _ZN7S1992C33v69Ev
  virtual void  v70(); // _ZN7S1992C33v70Ev
  virtual void  v71(); // _ZN7S1992C33v71Ev
  virtual void  v72(); // _ZN7S1992C33v72Ev
  virtual void  v73(); // _ZN7S1992C33v73Ev
  virtual void  v74(); // _ZN7S1992C33v74Ev
  virtual void  v75(); // _ZN7S1992C33v75Ev
  virtual void  v76(); // _ZN7S1992C33v76Ev
  virtual void  v77(); // _ZN7S1992C33v77Ev
  virtual void  v78(); // _ZN7S1992C33v78Ev
  virtual void  v79(); // _ZN7S1992C33v79Ev
  virtual void  v80(); // _ZN7S1992C33v80Ev
  virtual void  v81(); // _ZN7S1992C33v81Ev
  virtual void  v82(); // _ZN7S1992C33v82Ev
  virtual void  v83(); // _ZN7S1992C33v83Ev
  virtual void  v84(); // _ZN7S1992C33v84Ev
  virtual void  v85(); // _ZN7S1992C33v85Ev
  virtual void  v86(); // _ZN7S1992C33v86Ev
  virtual void  v87(); // _ZN7S1992C33v87Ev
  virtual void  v88(); // _ZN7S1992C33v88Ev
  virtual void  v89(); // _ZN7S1992C33v89Ev
  virtual void  v90(); // _ZN7S1992C33v90Ev
  virtual void  v91(); // _ZN7S1992C33v91Ev
  virtual void  v92(); // _ZN7S1992C33v92Ev
  virtual void  v93(); // _ZN7S1992C33v93Ev
  virtual void  v94(); // _ZN7S1992C33v94Ev
  virtual void  v95(); // _ZN7S1992C33v95Ev
  virtual void  v96(); // _ZN7S1992C33v96Ev
  virtual void  v97(); // _ZN7S1992C33v97Ev
  virtual void  v98(); // _ZN7S1992C33v98Ev
  virtual void  v99(); // _ZN7S1992C33v99Ev
  virtual void  v100(); // _ZN7S1992C34v100Ev
  virtual void  v101(); // _ZN7S1992C34v101Ev
  S1992C3(); // tgen
};
//SIG(-1 S1992C3) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fp Fi FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}} FC7{ BC8{ m Fp Fi FC9{ m} FC10{ m}}} Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 FC11{ m FC12{ m FL[2]}} FC11 FC11 FC13{ m FC12} FC14{ m FC13} FC15{ m FC13 FC13 FC13 FC13} FC15 FC11 FC11 FC11 Fp FC14 FC16{ m FC17{ m Fp Fi FC18{ m}} Fi} Fi Fp[7] FC8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC19{ BC4} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC20{ m Fp Fi[2] FC10} Fp[2] Fi:16 Fi:16 FC21{ BC22{ m Fp Fi FC23{ m} FC23}} FC24{ m Fp Fi[2] FC9} FC25{ m Fp Fi[2] FC6} Fp[2] Fi:24 Fi:8 Fp}


 S1992C3 ::~S1992C3(){ note_dtor("S1992C3", this);}
void  S1992C3 ::v24(){vfunc_called(this, "_ZN7S1992C33v24Ev");}
void  S1992C3 ::v25(){vfunc_called(this, "_ZN7S1992C33v25Ev");}
void  S1992C3 ::v26(){vfunc_called(this, "_ZN7S1992C33v26Ev");}
void  S1992C3 ::v27(){vfunc_called(this, "_ZN7S1992C33v27Ev");}
void  S1992C3 ::v28(){vfunc_called(this, "_ZN7S1992C33v28Ev");}
void  S1992C3 ::v29(){vfunc_called(this, "_ZN7S1992C33v29Ev");}
void  S1992C3 ::v30(){vfunc_called(this, "_ZN7S1992C33v30Ev");}
void  S1992C3 ::v31(){vfunc_called(this, "_ZN7S1992C33v31Ev");}
void  S1992C3 ::v32(){vfunc_called(this, "_ZN7S1992C33v32Ev");}
void  S1992C3 ::v33(){vfunc_called(this, "_ZN7S1992C33v33Ev");}
void  S1992C3 ::v34(){vfunc_called(this, "_ZN7S1992C33v34Ev");}
void  S1992C3 ::v35(){vfunc_called(this, "_ZN7S1992C33v35Ev");}
void  S1992C3 ::v36(){vfunc_called(this, "_ZN7S1992C33v36Ev");}
void  S1992C3 ::v37(){vfunc_called(this, "_ZN7S1992C33v37Ev");}
void  S1992C3 ::v38(){vfunc_called(this, "_ZN7S1992C33v38Ev");}
void  S1992C3 ::v39(){vfunc_called(this, "_ZN7S1992C33v39Ev");}
void  S1992C3 ::v40(){vfunc_called(this, "_ZN7S1992C33v40Ev");}
void  S1992C3 ::v41(){vfunc_called(this, "_ZN7S1992C33v41Ev");}
void  S1992C3 ::v42(){vfunc_called(this, "_ZN7S1992C33v42Ev");}
void  S1992C3 ::v43(){vfunc_called(this, "_ZN7S1992C33v43Ev");}
void  S1992C3 ::v44(){vfunc_called(this, "_ZN7S1992C33v44Ev");}
void  S1992C3 ::v45(){vfunc_called(this, "_ZN7S1992C33v45Ev");}
void  S1992C3 ::v46(){vfunc_called(this, "_ZN7S1992C33v46Ev");}
void  S1992C3 ::v47(){vfunc_called(this, "_ZN7S1992C33v47Ev");}
void  S1992C3 ::v48(){vfunc_called(this, "_ZN7S1992C33v48Ev");}
void  S1992C3 ::v49(){vfunc_called(this, "_ZN7S1992C33v49Ev");}
void  S1992C3 ::v50(){vfunc_called(this, "_ZN7S1992C33v50Ev");}
void  S1992C3 ::v51(){vfunc_called(this, "_ZN7S1992C33v51Ev");}
void  S1992C3 ::v52(){vfunc_called(this, "_ZN7S1992C33v52Ev");}
void  S1992C3 ::v53(){vfunc_called(this, "_ZN7S1992C33v53Ev");}
void  S1992C3 ::v54(){vfunc_called(this, "_ZN7S1992C33v54Ev");}
void  S1992C3 ::v55(){vfunc_called(this, "_ZN7S1992C33v55Ev");}
void  S1992C3 ::v56(){vfunc_called(this, "_ZN7S1992C33v56Ev");}
void  S1992C3 ::v57(){vfunc_called(this, "_ZN7S1992C33v57Ev");}
void  S1992C3 ::v58(){vfunc_called(this, "_ZN7S1992C33v58Ev");}
void  S1992C3 ::v59(){vfunc_called(this, "_ZN7S1992C33v59Ev");}
void  S1992C3 ::v60(){vfunc_called(this, "_ZN7S1992C33v60Ev");}
void  S1992C3 ::v61(){vfunc_called(this, "_ZN7S1992C33v61Ev");}
void  S1992C3 ::v62(){vfunc_called(this, "_ZN7S1992C33v62Ev");}
void  S1992C3 ::v63(){vfunc_called(this, "_ZN7S1992C33v63Ev");}
void  S1992C3 ::v64(){vfunc_called(this, "_ZN7S1992C33v64Ev");}
void  S1992C3 ::v65(){vfunc_called(this, "_ZN7S1992C33v65Ev");}
void  S1992C3 ::v66(){vfunc_called(this, "_ZN7S1992C33v66Ev");}
void  S1992C3 ::v67(){vfunc_called(this, "_ZN7S1992C33v67Ev");}
void  S1992C3 ::v68(){vfunc_called(this, "_ZN7S1992C33v68Ev");}
void  S1992C3 ::v69(){vfunc_called(this, "_ZN7S1992C33v69Ev");}
void  S1992C3 ::v70(){vfunc_called(this, "_ZN7S1992C33v70Ev");}
void  S1992C3 ::v71(){vfunc_called(this, "_ZN7S1992C33v71Ev");}
void  S1992C3 ::v72(){vfunc_called(this, "_ZN7S1992C33v72Ev");}
void  S1992C3 ::v73(){vfunc_called(this, "_ZN7S1992C33v73Ev");}
void  S1992C3 ::v74(){vfunc_called(this, "_ZN7S1992C33v74Ev");}
void  S1992C3 ::v75(){vfunc_called(this, "_ZN7S1992C33v75Ev");}
void  S1992C3 ::v76(){vfunc_called(this, "_ZN7S1992C33v76Ev");}
void  S1992C3 ::v77(){vfunc_called(this, "_ZN7S1992C33v77Ev");}
void  S1992C3 ::v78(){vfunc_called(this, "_ZN7S1992C33v78Ev");}
void  S1992C3 ::v79(){vfunc_called(this, "_ZN7S1992C33v79Ev");}
void  S1992C3 ::v80(){vfunc_called(this, "_ZN7S1992C33v80Ev");}
void  S1992C3 ::v81(){vfunc_called(this, "_ZN7S1992C33v81Ev");}
void  S1992C3 ::v82(){vfunc_called(this, "_ZN7S1992C33v82Ev");}
void  S1992C3 ::v83(){vfunc_called(this, "_ZN7S1992C33v83Ev");}
void  S1992C3 ::v84(){vfunc_called(this, "_ZN7S1992C33v84Ev");}
void  S1992C3 ::v85(){vfunc_called(this, "_ZN7S1992C33v85Ev");}
void  S1992C3 ::v86(){vfunc_called(this, "_ZN7S1992C33v86Ev");}
void  S1992C3 ::v87(){vfunc_called(this, "_ZN7S1992C33v87Ev");}
void  S1992C3 ::v88(){vfunc_called(this, "_ZN7S1992C33v88Ev");}
void  S1992C3 ::v89(){vfunc_called(this, "_ZN7S1992C33v89Ev");}
void  S1992C3 ::v90(){vfunc_called(this, "_ZN7S1992C33v90Ev");}
void  S1992C3 ::v91(){vfunc_called(this, "_ZN7S1992C33v91Ev");}
void  S1992C3 ::v92(){vfunc_called(this, "_ZN7S1992C33v92Ev");}
void  S1992C3 ::v93(){vfunc_called(this, "_ZN7S1992C33v93Ev");}
void  S1992C3 ::v94(){vfunc_called(this, "_ZN7S1992C33v94Ev");}
void  S1992C3 ::v95(){vfunc_called(this, "_ZN7S1992C33v95Ev");}
void  S1992C3 ::v96(){vfunc_called(this, "_ZN7S1992C33v96Ev");}
void  S1992C3 ::v97(){vfunc_called(this, "_ZN7S1992C33v97Ev");}
void  S1992C3 ::v98(){vfunc_called(this, "_ZN7S1992C33v98Ev");}
void  S1992C3 ::v99(){vfunc_called(this, "_ZN7S1992C33v99Ev");}
void  S1992C3 ::v100(){vfunc_called(this, "_ZN7S1992C34v100Ev");}
void  S1992C3 ::v101(){vfunc_called(this, "_ZN7S1992C34v101Ev");}
S1992C3 ::S1992C3(){ note_ctor("S1992C3", this);} // tgen

static void Test_S1992C3()
{
  extern Class_Descriptor cd_S1992C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(105,159)];
    init_test(&cd_S1992C3, buf);
    S1992C3 *dp, &lv = *(dp=new (buf) S1992C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(832,632), "sizeof(S1992C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1992C3)");
    check_base_class_offset(lv, (S1992C4*), 0, "S1992C3");
    check_field_offset(lv, s1992c3f0, ABISELECT(64,40), "S1992C3.s1992c3f0");
    check_field_offset(lv, s1992c3f1, ABISELECT(80,56), "S1992C3.s1992c3f1");
    check_field_offset(lv, s1992c3f2, ABISELECT(96,72), "S1992C3.s1992c3f2");
    check_field_offset(lv, s1992c3f3, ABISELECT(112,88), "S1992C3.s1992c3f3");
    check_field_offset(lv, s1992c3f4, ABISELECT(128,104), "S1992C3.s1992c3f4");
    check_field_offset(lv, s1992c3f5, ABISELECT(144,120), "S1992C3.s1992c3f5");
    check_field_offset(lv, s1992c3f6, ABISELECT(208,184), "S1992C3.s1992c3f6");
    check_field_offset(lv, s1992c3f7, ABISELECT(272,248), "S1992C3.s1992c3f7");
    check_field_offset(lv, s1992c3f8, ABISELECT(288,264), "S1992C3.s1992c3f8");
    check_field_offset(lv, s1992c3f9, ABISELECT(304,280), "S1992C3.s1992c3f9");
    check_field_offset(lv, s1992c3f10, ABISELECT(320,296), "S1992C3.s1992c3f10");
    check_field_offset(lv, s1992c3f11, ABISELECT(328,300), "S1992C3.s1992c3f11");
    check_field_offset(lv, s1992c3f12, ABISELECT(344,316), "S1992C3.s1992c3f12");
    check_field_offset(lv, s1992c3f13, ABISELECT(368,332), "S1992C3.s1992c3f13");
    check_field_offset(lv, s1992c3f14, ABISELECT(376,336), "S1992C3.s1992c3f14");
    check_field_offset(lv, s1992c3f15, ABISELECT(432,364), "S1992C3.s1992c3f15");
    set_bf_and_test(lv, s1992c3f16, ABISELECT(448,376), 0, 8, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f16, ABISELECT(448,376), 0, 8, hide_sll(1LL<<7), "S1992C3");
    set_bf_and_test(lv, s1992c3f17, ABISELECT(449,377), 0, 8, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f17, ABISELECT(449,377), 0, 8, hide_sll(1LL<<7), "S1992C3");
    set_bf_and_test(lv, s1992c3f18, ABISELECT(450,378), 0, 16, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f18, ABISELECT(450,378), 0, 16, hide_sll(1LL<<15), "S1992C3");
    set_bf_and_test(lv, s1992c3f19, ABISELECT(452,380), 0, 16, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f19, ABISELECT(452,380), 0, 16, hide_sll(1LL<<15), "S1992C3");
    set_bf_and_test(lv, s1992c3f20, ABISELECT(454,382), 0, 8, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f20, ABISELECT(454,382), 0, 8, hide_sll(1LL<<7), "S1992C3");
    set_bf_and_test(lv, s1992c3f21, ABISELECT(455,383), 0, 8, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f21, ABISELECT(455,383), 0, 8, hide_sll(1LL<<7), "S1992C3");
    set_bf_and_test(lv, s1992c3f22, ABISELECT(456,384), 0, 8, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f22, ABISELECT(456,384), 0, 8, hide_sll(1LL<<7), "S1992C3");
    set_bf_and_test(lv, s1992c3f23, ABISELECT(460,388), 0, 32, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f23, ABISELECT(460,388), 0, 32, hide_sll(1LL<<31), "S1992C3");
    set_bf_and_test(lv, s1992c3f24, ABISELECT(464,392), 0, 8, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f24, ABISELECT(464,392), 0, 8, hide_sll(1LL<<7), "S1992C3");
    set_bf_and_test(lv, s1992c3f25, ABISELECT(465,393), 0, 4, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f25, ABISELECT(465,393), 0, 4, hide_sll(1LL<<3), "S1992C3");
    set_bf_and_test(lv, s1992c3f26, ABISELECT(465,393), 4, 4, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f26, ABISELECT(465,393), 4, 4, hide_sll(1LL<<3), "S1992C3");
    set_bf_and_test(lv, s1992c3f27, ABISELECT(466,394), 0, 4, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f27, ABISELECT(466,394), 0, 4, hide_sll(1LL<<3), "S1992C3");
    set_bf_and_test(lv, s1992c3f28, ABISELECT(466,394), 4, 4, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f28, ABISELECT(466,394), 4, 4, hide_sll(1LL<<3), "S1992C3");
    set_bf_and_test(lv, s1992c3f29, ABISELECT(467,395), 0, 4, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f29, ABISELECT(467,395), 0, 4, hide_sll(1LL<<3), "S1992C3");
    set_bf_and_test(lv, s1992c3f30, ABISELECT(467,395), 4, 4, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f30, ABISELECT(467,395), 4, 4, hide_sll(1LL<<3), "S1992C3");
    set_bf_and_test(lv, s1992c3f31, ABISELECT(468,396), 0, 4, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f31, ABISELECT(468,396), 0, 4, hide_sll(1LL<<3), "S1992C3");
    set_bf_and_test(lv, s1992c3f32, ABISELECT(468,396), 4, 4, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f32, ABISELECT(468,396), 4, 4, hide_sll(1LL<<3), "S1992C3");
    set_bf_and_test(lv, s1992c3f33, ABISELECT(469,397), 0, 4, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f33, ABISELECT(469,397), 0, 4, hide_sll(1LL<<3), "S1992C3");
    set_bf_and_test(lv, s1992c3f34, ABISELECT(469,397), 4, 4, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f34, ABISELECT(469,397), 4, 4, hide_sll(1LL<<3), "S1992C3");
    set_bf_and_test(lv, s1992c3f35, ABISELECT(470,398), 0, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f36, ABISELECT(470,398), 1, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f37, ABISELECT(470,398), 2, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f38, ABISELECT(470,398), 3, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f39, ABISELECT(470,398), 4, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f40, ABISELECT(470,398), 5, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f41, ABISELECT(470,398), 6, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f42, ABISELECT(470,398), 7, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f43, ABISELECT(471,399), 0, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f44, ABISELECT(471,399), 1, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f45, ABISELECT(471,399), 2, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f46, ABISELECT(471,399), 3, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f47, ABISELECT(471,399), 4, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f48, ABISELECT(471,399), 5, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f49, ABISELECT(471,399), 6, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f50, ABISELECT(471,399), 7, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f51, ABISELECT(472,400), 0, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f52, ABISELECT(472,400), 1, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f53, ABISELECT(472,400), 2, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f54, ABISELECT(472,400), 3, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f55, ABISELECT(472,400), 4, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f56, ABISELECT(472,400), 5, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f57, ABISELECT(472,400), 6, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f58, ABISELECT(472,400), 7, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f59, ABISELECT(473,401), 0, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f60, ABISELECT(473,401), 1, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f61, ABISELECT(473,401), 2, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f62, ABISELECT(473,401), 3, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f63, ABISELECT(473,401), 4, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f64, ABISELECT(473,401), 5, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f65, ABISELECT(473,401), 6, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f66, ABISELECT(473,401), 7, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f67, ABISELECT(474,402), 0, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f68, ABISELECT(474,402), 1, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f69, ABISELECT(474,402), 2, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f70, ABISELECT(474,402), 3, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f71, ABISELECT(474,402), 4, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f72, ABISELECT(474,402), 5, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f73, ABISELECT(474,402), 6, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f74, ABISELECT(474,402), 7, 1, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f75, ABISELECT(475,403), 0, 1, 1, "S1992C3");
    check_field_offset(lv, s1992c3f76, ABISELECT(476,404), "S1992C3.s1992c3f76");
    check_field_offset(lv, s1992c3f77, ABISELECT(504,432), "S1992C3.s1992c3f77");
    set_bf_and_test(lv, s1992c3f78, ABISELECT(552,456), 0, 8, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f78, ABISELECT(552,456), 0, 8, hide_sll(1LL<<7), "S1992C3");
    set_bf_and_test(lv, s1992c3f79, ABISELECT(553,457), 0, 8, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f79, ABISELECT(553,457), 0, 8, hide_sll(1LL<<7), "S1992C3");
    set_bf_and_test(lv, s1992c3f80, ABISELECT(554,458), 0, 8, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f80, ABISELECT(554,458), 0, 8, hide_sll(1LL<<7), "S1992C3");
    set_bf_and_test(lv, s1992c3f81, ABISELECT(555,459), 0, 8, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f81, ABISELECT(555,459), 0, 8, hide_sll(1LL<<7), "S1992C3");
    set_bf_and_test(lv, s1992c3f82, ABISELECT(556,460), 0, 8, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f82, ABISELECT(556,460), 0, 8, hide_sll(1LL<<7), "S1992C3");
    set_bf_and_test(lv, s1992c3f83, ABISELECT(557,461), 0, 8, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f83, ABISELECT(557,461), 0, 8, hide_sll(1LL<<7), "S1992C3");
    check_field_offset(lv, s1992c3f84, ABISELECT(560,464), "S1992C3.s1992c3f84");
    check_field_offset(lv, s1992c3f85, ABISELECT(576,476), "S1992C3.s1992c3f85");
    set_bf_and_test(lv, s1992c3f86, ABISELECT(608,492), 0, 8, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f86, ABISELECT(608,492), 0, 8, hide_sll(1LL<<7), "S1992C3");
    set_bf_and_test(lv, s1992c3f87, ABISELECT(609,493), 0, 8, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f87, ABISELECT(609,493), 0, 8, hide_sll(1LL<<7), "S1992C3");
    set_bf_and_test(lv, s1992c3f88, ABISELECT(610,494), 0, 8, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f88, ABISELECT(610,494), 0, 8, hide_sll(1LL<<7), "S1992C3");
    set_bf_and_test(lv, s1992c3f89, ABISELECT(611,495), 0, 8, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f89, ABISELECT(611,495), 0, 8, hide_sll(1LL<<7), "S1992C3");
    set_bf_and_test(lv, s1992c3f90, ABISELECT(612,496), 0, 8, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f90, ABISELECT(612,496), 0, 8, hide_sll(1LL<<7), "S1992C3");
    set_bf_and_test(lv, s1992c3f91, ABISELECT(613,497), 0, 16, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f91, ABISELECT(613,497), 0, 16, hide_sll(1LL<<15), "S1992C3");
    set_bf_and_test(lv, s1992c3f92, ABISELECT(616,500), 0, 16, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f92, ABISELECT(616,500), 0, 16, hide_sll(1LL<<15), "S1992C3");
    set_bf_and_test(lv, s1992c3f93, ABISELECT(618,502), 0, 16, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f93, ABISELECT(618,502), 0, 16, hide_sll(1LL<<15), "S1992C3");
    set_bf_and_test(lv, s1992c3f94, ABISELECT(620,504), 0, 4, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f94, ABISELECT(620,504), 0, 4, hide_sll(1LL<<3), "S1992C3");
    set_bf_and_test(lv, s1992c3f95, ABISELECT(620,504), 4, 4, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f95, ABISELECT(620,504), 4, 4, hide_sll(1LL<<3), "S1992C3");
    set_bf_and_test(lv, s1992c3f96, ABISELECT(621,505), 0, 4, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f96, ABISELECT(621,505), 0, 4, hide_sll(1LL<<3), "S1992C3");
    set_bf_and_test(lv, s1992c3f97, ABISELECT(621,505), 4, 4, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f97, ABISELECT(621,505), 4, 4, hide_sll(1LL<<3), "S1992C3");
    set_bf_and_test(lv, s1992c3f98, ABISELECT(622,506), 0, 4, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f98, ABISELECT(622,506), 0, 4, hide_sll(1LL<<3), "S1992C3");
    set_bf_and_test(lv, s1992c3f99, ABISELECT(622,506), 4, 4, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f99, ABISELECT(622,506), 4, 4, hide_sll(1LL<<3), "S1992C3");
    set_bf_and_test(lv, s1992c3f100, ABISELECT(623,507), 0, 4, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f100, ABISELECT(623,507), 0, 4, hide_sll(1LL<<3), "S1992C3");
    set_bf_and_test(lv, s1992c3f101, ABISELECT(623,507), 4, 4, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f101, ABISELECT(623,507), 4, 4, hide_sll(1LL<<3), "S1992C3");
    set_bf_and_test(lv, s1992c3f102, ABISELECT(624,508), 0, 4, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f102, ABISELECT(624,508), 0, 4, hide_sll(1LL<<3), "S1992C3");
    set_bf_and_test(lv, s1992c3f103, ABISELECT(624,508), 4, 4, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f103, ABISELECT(624,508), 4, 4, hide_sll(1LL<<3), "S1992C3");
    set_bf_and_test(lv, s1992c3f104, ABISELECT(625,509), 0, 4, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f104, ABISELECT(625,509), 0, 4, hide_sll(1LL<<3), "S1992C3");
    set_bf_and_test(lv, s1992c3f105, ABISELECT(625,509), 4, 4, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f105, ABISELECT(625,509), 4, 4, hide_sll(1LL<<3), "S1992C3");
    set_bf_and_test(lv, s1992c3f106, ABISELECT(626,510), 0, 8, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f106, ABISELECT(626,510), 0, 8, hide_sll(1LL<<7), "S1992C3");
    set_bf_and_test(lv, s1992c3f107, ABISELECT(627,511), 0, 8, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f107, ABISELECT(627,511), 0, 8, hide_sll(1LL<<7), "S1992C3");
    set_bf_and_test(lv, s1992c3f108, ABISELECT(628,512), 0, 8, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f108, ABISELECT(628,512), 0, 8, hide_sll(1LL<<7), "S1992C3");
    check_field_offset(lv, s1992c3f109, ABISELECT(632,516), "S1992C3.s1992c3f109");
    check_field_offset(lv, s1992c3f110, ABISELECT(688,544), "S1992C3.s1992c3f110");
    check_field_offset(lv, s1992c3f111, ABISELECT(712,560), "S1992C3.s1992c3f111");
    set_bf_and_test(lv, s1992c3f112, ABISELECT(728,568), 0, 16, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f112, ABISELECT(728,568), 0, 16, hide_sll(1LL<<15), "S1992C3");
    set_bf_and_test(lv, s1992c3f113, ABISELECT(730,570), 0, 16, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f113, ABISELECT(730,570), 0, 16, hide_sll(1LL<<15), "S1992C3");
    check_field_offset(lv, s1992c3f114, ABISELECT(736,572), "S1992C3.s1992c3f114");
    check_field_offset(lv, s1992c3f115, ABISELECT(752,584), "S1992C3.s1992c3f115");
    check_field_offset(lv, s1992c3f116, ABISELECT(776,600), "S1992C3.s1992c3f116");
    check_field_offset(lv, s1992c3f117, ABISELECT(800,616), "S1992C3.s1992c3f117");
    set_bf_and_test(lv, s1992c3f118, ABISELECT(816,624), 0, 24, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f118, ABISELECT(816,624), 0, 24, hide_sll(1LL<<23), "S1992C3");
    set_bf_and_test(lv, s1992c3f119, ABISELECT(819,627), 0, 8, 1, "S1992C3");
    set_bf_and_test(lv, s1992c3f119, ABISELECT(819,627), 0, 8, hide_sll(1LL<<7), "S1992C3");
    check_field_offset(lv, s1992c3f120, ABISELECT(824,628), "S1992C3.s1992c3f120");
    test_class_info(&lv, &cd_S1992C3);
    dp->~S1992C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1992C3(Test_S1992C3, "S1992C3", ABISELECT(832,632));

#else // __cplusplus

extern void _ZN7S1992C3C1Ev();
extern void _ZN7S1992C3D1Ev();
Name_Map name_map_S1992C3[] = {
  NSPAIR(_ZN7S1992C3C1Ev),
  NSPAIR(_ZN7S1992C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1992C4;
extern VTBL_ENTRY _ZTI7S1992C4[];
extern  VTBL_ENTRY _ZTV7S1992C4[];
static Base_Class bases_S1992C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1992C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1992C3[];
extern void _ZN7S1992C3D1Ev();
extern void _ZN7S1992C3D0Ev();
extern void _ZN7S1992C42v1Ev();
extern void _ZN7S1992C42v2Ev();
extern void _ZN7S1992C42v3Ev();
extern void _ZN7S1992C42v4Ev();
extern void _ZN7S1992C42v5Ev();
extern void _ZN7S1992C42v6Ev();
extern void _ZN7S1992C42v7Ev();
extern void _ZN7S1992C42v8Ev();
extern void _ZN7S1992C42v9Ev();
extern void _ZN7S1992C43v10Ev();
extern void _ZN7S1992C43v11Ev();
extern void _ZN7S1992C43v12Ev();
extern void _ZN7S1992C43v13Ev();
extern void _ZN7S1992C43v14Ev();
extern void _ZN7S1992C43v15Ev();
extern void _ZN7S1992C43v16Ev();
extern void _ZN7S1992C43v17Ev();
extern void _ZN7S1992C43v18Ev();
extern void _ZN7S1992C43v19Ev();
extern void _ZN7S1992C43v20Ev();
extern void _ZN7S1992C43v21Ev();
extern void _ZN7S1992C43v22Ev();
extern void _ZN7S1992C43v23Ev();
extern void _ZN7S1992C33v24Ev();
extern void _ZN7S1992C33v25Ev();
extern void _ZN7S1992C33v26Ev();
extern void _ZN7S1992C33v27Ev();
extern void _ZN7S1992C33v28Ev();
extern void _ZN7S1992C33v29Ev();
extern void _ZN7S1992C33v30Ev();
extern void _ZN7S1992C33v31Ev();
extern void _ZN7S1992C33v32Ev();
extern void _ZN7S1992C33v33Ev();
extern void _ZN7S1992C33v34Ev();
extern void _ZN7S1992C33v35Ev();
extern void _ZN7S1992C33v36Ev();
extern void _ZN7S1992C33v37Ev();
extern void _ZN7S1992C33v38Ev();
extern void _ZN7S1992C33v39Ev();
extern void _ZN7S1992C33v40Ev();
extern void _ZN7S1992C33v41Ev();
extern void _ZN7S1992C33v42Ev();
extern void _ZN7S1992C33v43Ev();
extern void _ZN7S1992C33v44Ev();
extern void _ZN7S1992C33v45Ev();
extern void _ZN7S1992C33v46Ev();
extern void _ZN7S1992C33v47Ev();
extern void _ZN7S1992C33v48Ev();
extern void _ZN7S1992C33v49Ev();
extern void _ZN7S1992C33v50Ev();
extern void _ZN7S1992C33v51Ev();
extern void _ZN7S1992C33v52Ev();
extern void _ZN7S1992C33v53Ev();
extern void _ZN7S1992C33v54Ev();
extern void _ZN7S1992C33v55Ev();
extern void _ZN7S1992C33v56Ev();
extern void _ZN7S1992C33v57Ev();
extern void _ZN7S1992C33v58Ev();
extern void _ZN7S1992C33v59Ev();
extern void _ZN7S1992C33v60Ev();
extern void _ZN7S1992C33v61Ev();
extern void _ZN7S1992C33v62Ev();
extern void _ZN7S1992C33v63Ev();
extern void _ZN7S1992C33v64Ev();
extern void _ZN7S1992C33v65Ev();
extern void _ZN7S1992C33v66Ev();
extern void _ZN7S1992C33v67Ev();
extern void _ZN7S1992C33v68Ev();
extern void _ZN7S1992C33v69Ev();
extern void _ZN7S1992C33v70Ev();
extern void _ZN7S1992C33v71Ev();
extern void _ZN7S1992C33v72Ev();
extern void _ZN7S1992C33v73Ev();
extern void _ZN7S1992C33v74Ev();
extern void _ZN7S1992C33v75Ev();
extern void _ZN7S1992C33v76Ev();
extern void _ZN7S1992C33v77Ev();
extern void _ZN7S1992C33v78Ev();
extern void _ZN7S1992C33v79Ev();
extern void _ZN7S1992C33v80Ev();
extern void _ZN7S1992C33v81Ev();
extern void _ZN7S1992C33v82Ev();
extern void _ZN7S1992C33v83Ev();
extern void _ZN7S1992C33v84Ev();
extern void _ZN7S1992C33v85Ev();
extern void _ZN7S1992C33v86Ev();
extern void _ZN7S1992C33v87Ev();
extern void _ZN7S1992C33v88Ev();
extern void _ZN7S1992C33v89Ev();
extern void _ZN7S1992C33v90Ev();
extern void _ZN7S1992C33v91Ev();
extern void _ZN7S1992C33v92Ev();
extern void _ZN7S1992C33v93Ev();
extern void _ZN7S1992C33v94Ev();
extern void _ZN7S1992C33v95Ev();
extern void _ZN7S1992C33v96Ev();
extern void _ZN7S1992C33v97Ev();
extern void _ZN7S1992C33v98Ev();
extern void _ZN7S1992C33v99Ev();
extern void _ZN7S1992C34v100Ev();
extern void _ZN7S1992C34v101Ev();
static  VTBL_ENTRY vtc_S1992C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1992C3[0]),
  (VTBL_ENTRY)&_ZN7S1992C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1992C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v1Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v29Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v30Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v31Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v32Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v33Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v34Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v35Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v36Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v37Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v38Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v39Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v40Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v41Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v42Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v43Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v44Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v45Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v46Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v47Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v48Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v49Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v50Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v51Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v52Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v53Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v54Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v55Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v56Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v57Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v58Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v59Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v60Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v61Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v62Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v63Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v64Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v65Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v66Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v67Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v68Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v69Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1992C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1992C34v101Ev,
};
extern VTBL_ENTRY _ZTI7S1992C3[];
extern  VTBL_ENTRY _ZTV7S1992C3[];
Class_Descriptor cd_S1992C3 = {  "S1992C3", // class name
  bases_S1992C3, 1,
  &(vtc_S1992C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI7S1992C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1992C3),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1992C2  : S1992C3 {
  void *s1992c2f0;
  char s1992c2f1;
  ::S1990C39_nt s1992c2f2;
  ::S1990C19_nt s1992c2f3;
  virtual  ~S1992C2(); // _ZN7S1992C2D1Ev
  virtual void  v102(); // _ZN7S1992C24v102Ev
  virtual void  v103(); // _ZN7S1992C24v103Ev
  virtual void  v104(); // _ZN7S1992C24v104Ev
  virtual void  v105(); // _ZN7S1992C24v105Ev
  virtual void  v106(); // _ZN7S1992C24v106Ev
  virtual void  v107(); // _ZN7S1992C24v107Ev
  virtual void  v108(); // _ZN7S1992C24v108Ev
  virtual void  v109(); // _ZN7S1992C24v109Ev
  virtual void  v110(); // _ZN7S1992C24v110Ev
  S1992C2(); // tgen
};
//SIG(-1 S1992C2) C1{ BC2{ BC3{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 Fp Fi FC4{ BC5{ m Fp Fi FC6{ m} FC7{ m}}} FC8{ BC9{ m Fp Fi FC10{ m} FC11{ m}}} Fi} vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 FC12{ m FC13{ m FL[2]}} FC12 FC12 FC14{ m FC13} FC15{ m FC14} FC16{ m FC14 FC14 FC14 FC14} FC16 FC12 FC12 FC12 Fp FC15 FC17{ m FC18{ m Fp Fi FC19{ m}} Fi} Fi Fp[7] FC9 Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC20{ BC5} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC21{ m Fp Fi[2] FC11} Fp[2] Fi:16 Fi:16 FC22{ BC23{ m Fp Fi FC24{ m} FC24}} FC25{ m Fp Fi[2] FC10} FC26{ m Fp Fi[2] FC7} Fp[2] Fi:24 Fi:8 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fp Fc FC27{ m FC25 FC8 FC21 FC8} FC17}


 S1992C2 ::~S1992C2(){ note_dtor("S1992C2", this);}
void  S1992C2 ::v102(){vfunc_called(this, "_ZN7S1992C24v102Ev");}
void  S1992C2 ::v103(){vfunc_called(this, "_ZN7S1992C24v103Ev");}
void  S1992C2 ::v104(){vfunc_called(this, "_ZN7S1992C24v104Ev");}
void  S1992C2 ::v105(){vfunc_called(this, "_ZN7S1992C24v105Ev");}
void  S1992C2 ::v106(){vfunc_called(this, "_ZN7S1992C24v106Ev");}
void  S1992C2 ::v107(){vfunc_called(this, "_ZN7S1992C24v107Ev");}
void  S1992C2 ::v108(){vfunc_called(this, "_ZN7S1992C24v108Ev");}
void  S1992C2 ::v109(){vfunc_called(this, "_ZN7S1992C24v109Ev");}
void  S1992C2 ::v110(){vfunc_called(this, "_ZN7S1992C24v110Ev");}
S1992C2 ::S1992C2(){ note_ctor("S1992C2", this);} // tgen

static void Test_S1992C2()
{
  extern Class_Descriptor cd_S1992C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(120,179)];
    init_test(&cd_S1992C2, buf);
    S1992C2 *dp, &lv = *(dp=new (buf) S1992C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(952,712), "sizeof(S1992C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1992C2)");
    check_base_class_offset(lv, (S1992C4*)(S1992C3*), 0, "S1992C2");
    check_base_class_offset(lv, (S1992C3*), 0, "S1992C2");
    check_field_offset(lv, s1992c2f0, ABISELECT(832,632), "S1992C2.s1992c2f0");
    check_field_offset(lv, s1992c2f1, ABISELECT(840,636), "S1992C2.s1992c2f1");
    check_field_offset(lv, s1992c2f2, ABISELECT(848,640), "S1992C2.s1992c2f2");
    check_field_offset(lv, s1992c2f3, ABISELECT(928,696), "S1992C2.s1992c2f3");
    test_class_info(&lv, &cd_S1992C2);
    dp->~S1992C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1992C2(Test_S1992C2, "S1992C2", ABISELECT(952,712));

#else // __cplusplus

extern void _ZN7S1992C2C1Ev();
extern void _ZN7S1992C2D1Ev();
Name_Map name_map_S1992C2[] = {
  NSPAIR(_ZN7S1992C2C1Ev),
  NSPAIR(_ZN7S1992C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1992C4;
extern VTBL_ENTRY _ZTI7S1992C4[];
extern  VTBL_ENTRY _ZTV7S1992C4[];
extern Class_Descriptor cd_S1992C3;
extern VTBL_ENTRY _ZTI7S1992C3[];
extern  VTBL_ENTRY _ZTV7S1992C3[];
static Base_Class bases_S1992C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1992C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1992C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1992C2[];
extern void _ZN7S1992C2D1Ev();
extern void _ZN7S1992C2D0Ev();
extern void _ZN7S1992C42v1Ev();
extern void _ZN7S1992C42v2Ev();
extern void _ZN7S1992C42v3Ev();
extern void _ZN7S1992C42v4Ev();
extern void _ZN7S1992C42v5Ev();
extern void _ZN7S1992C42v6Ev();
extern void _ZN7S1992C42v7Ev();
extern void _ZN7S1992C42v8Ev();
extern void _ZN7S1992C42v9Ev();
extern void _ZN7S1992C43v10Ev();
extern void _ZN7S1992C43v11Ev();
extern void _ZN7S1992C43v12Ev();
extern void _ZN7S1992C43v13Ev();
extern void _ZN7S1992C43v14Ev();
extern void _ZN7S1992C43v15Ev();
extern void _ZN7S1992C43v16Ev();
extern void _ZN7S1992C43v17Ev();
extern void _ZN7S1992C43v18Ev();
extern void _ZN7S1992C43v19Ev();
extern void _ZN7S1992C43v20Ev();
extern void _ZN7S1992C43v21Ev();
extern void _ZN7S1992C43v22Ev();
extern void _ZN7S1992C43v23Ev();
extern void _ZN7S1992C33v24Ev();
extern void _ZN7S1992C33v25Ev();
extern void _ZN7S1992C33v26Ev();
extern void _ZN7S1992C33v27Ev();
extern void _ZN7S1992C33v28Ev();
extern void _ZN7S1992C33v29Ev();
extern void _ZN7S1992C33v30Ev();
extern void _ZN7S1992C33v31Ev();
extern void _ZN7S1992C33v32Ev();
extern void _ZN7S1992C33v33Ev();
extern void _ZN7S1992C33v34Ev();
extern void _ZN7S1992C33v35Ev();
extern void _ZN7S1992C33v36Ev();
extern void _ZN7S1992C33v37Ev();
extern void _ZN7S1992C33v38Ev();
extern void _ZN7S1992C33v39Ev();
extern void _ZN7S1992C33v40Ev();
extern void _ZN7S1992C33v41Ev();
extern void _ZN7S1992C33v42Ev();
extern void _ZN7S1992C33v43Ev();
extern void _ZN7S1992C33v44Ev();
extern void _ZN7S1992C33v45Ev();
extern void _ZN7S1992C33v46Ev();
extern void _ZN7S1992C33v47Ev();
extern void _ZN7S1992C33v48Ev();
extern void _ZN7S1992C33v49Ev();
extern void _ZN7S1992C33v50Ev();
extern void _ZN7S1992C33v51Ev();
extern void _ZN7S1992C33v52Ev();
extern void _ZN7S1992C33v53Ev();
extern void _ZN7S1992C33v54Ev();
extern void _ZN7S1992C33v55Ev();
extern void _ZN7S1992C33v56Ev();
extern void _ZN7S1992C33v57Ev();
extern void _ZN7S1992C33v58Ev();
extern void _ZN7S1992C33v59Ev();
extern void _ZN7S1992C33v60Ev();
extern void _ZN7S1992C33v61Ev();
extern void _ZN7S1992C33v62Ev();
extern void _ZN7S1992C33v63Ev();
extern void _ZN7S1992C33v64Ev();
extern void _ZN7S1992C33v65Ev();
extern void _ZN7S1992C33v66Ev();
extern void _ZN7S1992C33v67Ev();
extern void _ZN7S1992C33v68Ev();
extern void _ZN7S1992C33v69Ev();
extern void _ZN7S1992C33v70Ev();
extern void _ZN7S1992C33v71Ev();
extern void _ZN7S1992C33v72Ev();
extern void _ZN7S1992C33v73Ev();
extern void _ZN7S1992C33v74Ev();
extern void _ZN7S1992C33v75Ev();
extern void _ZN7S1992C33v76Ev();
extern void _ZN7S1992C33v77Ev();
extern void _ZN7S1992C33v78Ev();
extern void _ZN7S1992C33v79Ev();
extern void _ZN7S1992C33v80Ev();
extern void _ZN7S1992C33v81Ev();
extern void _ZN7S1992C33v82Ev();
extern void _ZN7S1992C33v83Ev();
extern void _ZN7S1992C33v84Ev();
extern void _ZN7S1992C33v85Ev();
extern void _ZN7S1992C33v86Ev();
extern void _ZN7S1992C33v87Ev();
extern void _ZN7S1992C33v88Ev();
extern void _ZN7S1992C33v89Ev();
extern void _ZN7S1992C33v90Ev();
extern void _ZN7S1992C33v91Ev();
extern void _ZN7S1992C33v92Ev();
extern void _ZN7S1992C33v93Ev();
extern void _ZN7S1992C33v94Ev();
extern void _ZN7S1992C33v95Ev();
extern void _ZN7S1992C33v96Ev();
extern void _ZN7S1992C33v97Ev();
extern void _ZN7S1992C33v98Ev();
extern void _ZN7S1992C33v99Ev();
extern void _ZN7S1992C34v100Ev();
extern void _ZN7S1992C34v101Ev();
extern void _ZN7S1992C24v102Ev();
extern void _ZN7S1992C24v103Ev();
extern void _ZN7S1992C24v104Ev();
extern void _ZN7S1992C24v105Ev();
extern void _ZN7S1992C24v106Ev();
extern void _ZN7S1992C24v107Ev();
extern void _ZN7S1992C24v108Ev();
extern void _ZN7S1992C24v109Ev();
extern void _ZN7S1992C24v110Ev();
static  VTBL_ENTRY vtc_S1992C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1992C2[0]),
  (VTBL_ENTRY)&_ZN7S1992C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1992C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v1Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v29Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v30Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v31Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v32Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v33Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v34Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v35Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v36Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v37Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v38Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v39Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v40Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v41Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v42Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v43Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v44Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v45Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v46Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v47Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v48Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v49Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v50Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v51Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v52Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v53Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v54Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v55Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v56Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v57Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v58Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v59Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v60Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v61Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v62Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v63Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v64Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v65Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v66Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v67Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v68Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v69Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1992C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1992C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1992C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1992C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1992C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1992C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1992C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1992C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1992C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1992C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1992C24v110Ev,
};
extern VTBL_ENTRY _ZTI7S1992C2[];
extern  VTBL_ENTRY _ZTV7S1992C2[];
Class_Descriptor cd_S1992C2 = {  "S1992C2", // class name
  bases_S1992C2, 2,
  &(vtc_S1992C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(952,712), // object size
  NSPAIRA(_ZTI7S1992C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1992C2),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1992C1  : S1992C2 {
  ::S1990C20_nt s1992c1f0;
  ::S1990C52_nt s1992c1f1;
  int s1992c1f2[4];
  virtual  ~S1992C1(); // _ZN7S1992C1D1Ev
  S1992C1(); // tgen
};
//SIG(1 S1992C1) C1{ BC2{ BC3{ BC4{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC5{ BC6{ m Fp Fi FC7{ m} FC8{ m}}} FC9{ BC10{ m Fp Fi FC11{ m} FC12{ m}}} Fi} vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 FC13{ m FC14{ m FL[2]}} FC13 FC13 FC15{ m FC14} FC16{ m FC15} FC17{ m FC15 FC15 FC15 FC15} FC17 FC13 FC13 FC13 Fp FC16 FC18{ m FC19{ m Fp Fi FC20{ m}} Fi} Fi Fp[7] FC10 Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC21{ BC6} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC22{ m Fp Fi[2] FC12} Fp[2] Fi:16 Fi:16 FC23{ BC24{ m Fp Fi FC25{ m} FC25}} FC26{ m Fp Fi[2] FC11} FC27{ m Fp Fi[2] FC8} Fp[2] Fi:24 Fi:8 Fp} vd v102 v103 v104 v105 v106 v107 v108 v109 v110 Fp Fc FC28{ m FC26 FC9 FC22 FC9} FC18} vd FC19 FC29{ m Fp[2]} Fi[4]}


 S1992C1 ::~S1992C1(){ note_dtor("S1992C1", this);}
S1992C1 ::S1992C1(){ note_ctor("S1992C1", this);} // tgen

static void Test_S1992C1()
{
  extern Class_Descriptor cd_S1992C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(126,188)];
    init_test(&cd_S1992C1, buf);
    S1992C1 *dp, &lv = *(dp=new (buf) S1992C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1000,748), "sizeof(S1992C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1992C1)");
    check_base_class_offset(lv, (S1992C4*)(S1992C3*)(S1992C2*), 0, "S1992C1");
    check_base_class_offset(lv, (S1992C3*)(S1992C2*), 0, "S1992C1");
    check_base_class_offset(lv, (S1992C2*), 0, "S1992C1");
    check_field_offset(lv, s1992c1f0, ABISELECT(952,712), "S1992C1.s1992c1f0");
    check_field_offset(lv, s1992c1f1, ABISELECT(968,724), "S1992C1.s1992c1f1");
    check_field_offset(lv, s1992c1f2, ABISELECT(984,732), "S1992C1.s1992c1f2");
    test_class_info(&lv, &cd_S1992C1);
    dp->~S1992C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1992C1(Test_S1992C1, "S1992C1", ABISELECT(1000,748));

#else // __cplusplus

extern void _ZN7S1992C1C1Ev();
extern void _ZN7S1992C1D1Ev();
Name_Map name_map_S1992C1[] = {
  NSPAIR(_ZN7S1992C1C1Ev),
  NSPAIR(_ZN7S1992C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1992C4;
extern VTBL_ENTRY _ZTI7S1992C4[];
extern  VTBL_ENTRY _ZTV7S1992C4[];
extern Class_Descriptor cd_S1992C3;
extern VTBL_ENTRY _ZTI7S1992C3[];
extern  VTBL_ENTRY _ZTV7S1992C3[];
extern Class_Descriptor cd_S1992C2;
extern VTBL_ENTRY _ZTI7S1992C2[];
extern  VTBL_ENTRY _ZTV7S1992C2[];
static Base_Class bases_S1992C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1992C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1992C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1992C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1992C1[];
extern void _ZN7S1992C1D1Ev();
extern void _ZN7S1992C1D0Ev();
extern void _ZN7S1992C42v1Ev();
extern void _ZN7S1992C42v2Ev();
extern void _ZN7S1992C42v3Ev();
extern void _ZN7S1992C42v4Ev();
extern void _ZN7S1992C42v5Ev();
extern void _ZN7S1992C42v6Ev();
extern void _ZN7S1992C42v7Ev();
extern void _ZN7S1992C42v8Ev();
extern void _ZN7S1992C42v9Ev();
extern void _ZN7S1992C43v10Ev();
extern void _ZN7S1992C43v11Ev();
extern void _ZN7S1992C43v12Ev();
extern void _ZN7S1992C43v13Ev();
extern void _ZN7S1992C43v14Ev();
extern void _ZN7S1992C43v15Ev();
extern void _ZN7S1992C43v16Ev();
extern void _ZN7S1992C43v17Ev();
extern void _ZN7S1992C43v18Ev();
extern void _ZN7S1992C43v19Ev();
extern void _ZN7S1992C43v20Ev();
extern void _ZN7S1992C43v21Ev();
extern void _ZN7S1992C43v22Ev();
extern void _ZN7S1992C43v23Ev();
extern void _ZN7S1992C33v24Ev();
extern void _ZN7S1992C33v25Ev();
extern void _ZN7S1992C33v26Ev();
extern void _ZN7S1992C33v27Ev();
extern void _ZN7S1992C33v28Ev();
extern void _ZN7S1992C33v29Ev();
extern void _ZN7S1992C33v30Ev();
extern void _ZN7S1992C33v31Ev();
extern void _ZN7S1992C33v32Ev();
extern void _ZN7S1992C33v33Ev();
extern void _ZN7S1992C33v34Ev();
extern void _ZN7S1992C33v35Ev();
extern void _ZN7S1992C33v36Ev();
extern void _ZN7S1992C33v37Ev();
extern void _ZN7S1992C33v38Ev();
extern void _ZN7S1992C33v39Ev();
extern void _ZN7S1992C33v40Ev();
extern void _ZN7S1992C33v41Ev();
extern void _ZN7S1992C33v42Ev();
extern void _ZN7S1992C33v43Ev();
extern void _ZN7S1992C33v44Ev();
extern void _ZN7S1992C33v45Ev();
extern void _ZN7S1992C33v46Ev();
extern void _ZN7S1992C33v47Ev();
extern void _ZN7S1992C33v48Ev();
extern void _ZN7S1992C33v49Ev();
extern void _ZN7S1992C33v50Ev();
extern void _ZN7S1992C33v51Ev();
extern void _ZN7S1992C33v52Ev();
extern void _ZN7S1992C33v53Ev();
extern void _ZN7S1992C33v54Ev();
extern void _ZN7S1992C33v55Ev();
extern void _ZN7S1992C33v56Ev();
extern void _ZN7S1992C33v57Ev();
extern void _ZN7S1992C33v58Ev();
extern void _ZN7S1992C33v59Ev();
extern void _ZN7S1992C33v60Ev();
extern void _ZN7S1992C33v61Ev();
extern void _ZN7S1992C33v62Ev();
extern void _ZN7S1992C33v63Ev();
extern void _ZN7S1992C33v64Ev();
extern void _ZN7S1992C33v65Ev();
extern void _ZN7S1992C33v66Ev();
extern void _ZN7S1992C33v67Ev();
extern void _ZN7S1992C33v68Ev();
extern void _ZN7S1992C33v69Ev();
extern void _ZN7S1992C33v70Ev();
extern void _ZN7S1992C33v71Ev();
extern void _ZN7S1992C33v72Ev();
extern void _ZN7S1992C33v73Ev();
extern void _ZN7S1992C33v74Ev();
extern void _ZN7S1992C33v75Ev();
extern void _ZN7S1992C33v76Ev();
extern void _ZN7S1992C33v77Ev();
extern void _ZN7S1992C33v78Ev();
extern void _ZN7S1992C33v79Ev();
extern void _ZN7S1992C33v80Ev();
extern void _ZN7S1992C33v81Ev();
extern void _ZN7S1992C33v82Ev();
extern void _ZN7S1992C33v83Ev();
extern void _ZN7S1992C33v84Ev();
extern void _ZN7S1992C33v85Ev();
extern void _ZN7S1992C33v86Ev();
extern void _ZN7S1992C33v87Ev();
extern void _ZN7S1992C33v88Ev();
extern void _ZN7S1992C33v89Ev();
extern void _ZN7S1992C33v90Ev();
extern void _ZN7S1992C33v91Ev();
extern void _ZN7S1992C33v92Ev();
extern void _ZN7S1992C33v93Ev();
extern void _ZN7S1992C33v94Ev();
extern void _ZN7S1992C33v95Ev();
extern void _ZN7S1992C33v96Ev();
extern void _ZN7S1992C33v97Ev();
extern void _ZN7S1992C33v98Ev();
extern void _ZN7S1992C33v99Ev();
extern void _ZN7S1992C34v100Ev();
extern void _ZN7S1992C34v101Ev();
extern void _ZN7S1992C24v102Ev();
extern void _ZN7S1992C24v103Ev();
extern void _ZN7S1992C24v104Ev();
extern void _ZN7S1992C24v105Ev();
extern void _ZN7S1992C24v106Ev();
extern void _ZN7S1992C24v107Ev();
extern void _ZN7S1992C24v108Ev();
extern void _ZN7S1992C24v109Ev();
extern void _ZN7S1992C24v110Ev();
static  VTBL_ENTRY vtc_S1992C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1992C1[0]),
  (VTBL_ENTRY)&_ZN7S1992C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1992C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v1Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1992C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1992C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v29Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v30Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v31Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v32Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v33Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v34Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v35Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v36Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v37Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v38Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v39Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v40Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v41Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v42Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v43Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v44Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v45Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v46Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v47Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v48Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v49Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v50Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v51Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v52Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v53Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v54Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v55Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v56Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v57Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v58Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v59Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v60Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v61Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v62Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v63Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v64Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v65Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v66Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v67Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v68Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v69Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1992C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1992C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1992C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1992C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1992C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1992C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1992C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1992C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1992C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1992C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1992C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1992C24v110Ev,
};
extern VTBL_ENTRY _ZTI7S1992C1[];
extern  VTBL_ENTRY _ZTV7S1992C1[];
Class_Descriptor cd_S1992C1 = {  "S1992C1", // class name
  bases_S1992C1, 3,
  &(vtc_S1992C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1000,748), // object size
  NSPAIRA(_ZTI7S1992C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1992C1),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1995C4  {
  void *s1995c4f0;
  int s1995c4f1;
  ::S1993C31 s1995c4f2;
  ::S1990C42 s1995c4f3;
  int s1995c4f4;
  virtual  ~S1995C4(); // _ZN7S1995C4D1Ev
  virtual void  v1(); // _ZN7S1995C42v1Ev
  virtual void  v2(); // _ZN7S1995C42v2Ev
  virtual void  v3(); // _ZN7S1995C42v3Ev
  virtual void  v4(); // _ZN7S1995C42v4Ev
  virtual void  v5(); // _ZN7S1995C42v5Ev
  virtual void  v6(); // _ZN7S1995C42v6Ev
  virtual void  v7(); // _ZN7S1995C42v7Ev
  virtual void  v8(); // _ZN7S1995C42v8Ev
  virtual void  v9(); // _ZN7S1995C42v9Ev
  virtual void  v10(); // _ZN7S1995C43v10Ev
  virtual void  v11(); // _ZN7S1995C43v11Ev
  virtual void  v12(); // _ZN7S1995C43v12Ev
  virtual void  v13(); // _ZN7S1995C43v13Ev
  virtual void  v14(); // _ZN7S1995C43v14Ev
  virtual void  v15(); // _ZN7S1995C43v15Ev
  virtual void  v16(); // _ZN7S1995C43v16Ev
  virtual void  v17(); // _ZN7S1995C43v17Ev
  virtual void  v18(); // _ZN7S1995C43v18Ev
  virtual void  v19(); // _ZN7S1995C43v19Ev
  virtual void  v20(); // _ZN7S1995C43v20Ev
  virtual void  v21(); // _ZN7S1995C43v21Ev
  virtual void  v22(); // _ZN7S1995C43v22Ev
  virtual void  v23(); // _ZN7S1995C43v23Ev
  S1995C4(); // tgen
};
//SIG(-1 S1995C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}} FC6{ BC7{ m Fp Fi FC8{ m} FC9{ m}}} Fi}


 S1995C4 ::~S1995C4(){ note_dtor("S1995C4", this);}
void  S1995C4 ::v1(){vfunc_called(this, "_ZN7S1995C42v1Ev");}
void  S1995C4 ::v2(){vfunc_called(this, "_ZN7S1995C42v2Ev");}
void  S1995C4 ::v3(){vfunc_called(this, "_ZN7S1995C42v3Ev");}
void  S1995C4 ::v4(){vfunc_called(this, "_ZN7S1995C42v4Ev");}
void  S1995C4 ::v5(){vfunc_called(this, "_ZN7S1995C42v5Ev");}
void  S1995C4 ::v6(){vfunc_called(this, "_ZN7S1995C42v6Ev");}
void  S1995C4 ::v7(){vfunc_called(this, "_ZN7S1995C42v7Ev");}
void  S1995C4 ::v8(){vfunc_called(this, "_ZN7S1995C42v8Ev");}
void  S1995C4 ::v9(){vfunc_called(this, "_ZN7S1995C42v9Ev");}
void  S1995C4 ::v10(){vfunc_called(this, "_ZN7S1995C43v10Ev");}
void  S1995C4 ::v11(){vfunc_called(this, "_ZN7S1995C43v11Ev");}
void  S1995C4 ::v12(){vfunc_called(this, "_ZN7S1995C43v12Ev");}
void  S1995C4 ::v13(){vfunc_called(this, "_ZN7S1995C43v13Ev");}
void  S1995C4 ::v14(){vfunc_called(this, "_ZN7S1995C43v14Ev");}
void  S1995C4 ::v15(){vfunc_called(this, "_ZN7S1995C43v15Ev");}
void  S1995C4 ::v16(){vfunc_called(this, "_ZN7S1995C43v16Ev");}
void  S1995C4 ::v17(){vfunc_called(this, "_ZN7S1995C43v17Ev");}
void  S1995C4 ::v18(){vfunc_called(this, "_ZN7S1995C43v18Ev");}
void  S1995C4 ::v19(){vfunc_called(this, "_ZN7S1995C43v19Ev");}
void  S1995C4 ::v20(){vfunc_called(this, "_ZN7S1995C43v20Ev");}
void  S1995C4 ::v21(){vfunc_called(this, "_ZN7S1995C43v21Ev");}
void  S1995C4 ::v22(){vfunc_called(this, "_ZN7S1995C43v22Ev");}
void  S1995C4 ::v23(){vfunc_called(this, "_ZN7S1995C43v23Ev");}
S1995C4 ::S1995C4(){ note_ctor("S1995C4", this);} // tgen

static void Test_S1995C4()
{
  extern Class_Descriptor cd_S1995C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_S1995C4, buf);
    S1995C4 *dp, &lv = *(dp=new (buf) S1995C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(S1995C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1995C4)");
    check_field_offset(lv, s1995c4f0, ABISELECT(8,4), "S1995C4.s1995c4f0");
    check_field_offset(lv, s1995c4f1, ABISELECT(16,8), "S1995C4.s1995c4f1");
    check_field_offset(lv, s1995c4f2, ABISELECT(24,12), "S1995C4.s1995c4f2");
    check_field_offset(lv, s1995c4f3, ABISELECT(40,24), "S1995C4.s1995c4f3");
    check_field_offset(lv, s1995c4f4, ABISELECT(56,36), "S1995C4.s1995c4f4");
    test_class_info(&lv, &cd_S1995C4);
    dp->~S1995C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1995C4(Test_S1995C4, "S1995C4", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN7S1995C4C1Ev();
extern void _ZN7S1995C4D1Ev();
Name_Map name_map_S1995C4[] = {
  NSPAIR(_ZN7S1995C4C1Ev),
  NSPAIR(_ZN7S1995C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1995C4[];
extern void _ZN7S1995C4D1Ev();
extern void _ZN7S1995C4D0Ev();
extern void _ZN7S1995C42v1Ev();
extern void _ZN7S1995C42v2Ev();
extern void _ZN7S1995C42v3Ev();
extern void _ZN7S1995C42v4Ev();
extern void _ZN7S1995C42v5Ev();
extern void _ZN7S1995C42v6Ev();
extern void _ZN7S1995C42v7Ev();
extern void _ZN7S1995C42v8Ev();
extern void _ZN7S1995C42v9Ev();
extern void _ZN7S1995C43v10Ev();
extern void _ZN7S1995C43v11Ev();
extern void _ZN7S1995C43v12Ev();
extern void _ZN7S1995C43v13Ev();
extern void _ZN7S1995C43v14Ev();
extern void _ZN7S1995C43v15Ev();
extern void _ZN7S1995C43v16Ev();
extern void _ZN7S1995C43v17Ev();
extern void _ZN7S1995C43v18Ev();
extern void _ZN7S1995C43v19Ev();
extern void _ZN7S1995C43v20Ev();
extern void _ZN7S1995C43v21Ev();
extern void _ZN7S1995C43v22Ev();
extern void _ZN7S1995C43v23Ev();
static  VTBL_ENTRY vtc_S1995C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1995C4[0]),
  (VTBL_ENTRY)&_ZN7S1995C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1995C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v1Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v23Ev,
};
extern VTBL_ENTRY _ZTI7S1995C4[];
extern  VTBL_ENTRY _ZTV7S1995C4[];
Class_Descriptor cd_S1995C4 = {  "S1995C4", // class name
  0,0,//no base classes
  &(vtc_S1995C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI7S1995C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1995C4),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1995C3  : S1995C4 {
  ::S1993C15 s1995c3f0;
  ::S1993C15 s1995c3f1;
  ::S1993C15 s1995c3f2;
  ::S1990C13_nt s1995c3f3;
  ::S1990C17_nt s1995c3f4;
  ::S1990C18_nt s1995c3f5;
  ::S1990C18_nt s1995c3f6;
  ::S1993C15 s1995c3f7;
  ::S1993C15 s1995c3f8;
  ::S1993C15 s1995c3f9;
  void *s1995c3f10;
  ::S1990C17_nt s1995c3f11;
  ::S1990C19_nt s1995c3f12;
  int s1995c3f13;
  void *s1995c3f14[7];
  ::S1990C43 s1995c3f15;
  int s1995c3f16:8;
  int s1995c3f17:8;
  int s1995c3f18:16;
  int s1995c3f19:16;
  int s1995c3f20:8;
  int s1995c3f21:8;
  int s1995c3f22:8;
  int s1995c3f23:32;
  int s1995c3f24:8;
  int s1995c3f25:4;
  int s1995c3f26:4;
  int s1995c3f27:4;
  int s1995c3f28:4;
  int s1995c3f29:4;
  int s1995c3f30:4;
  int s1995c3f31:4;
  int s1995c3f32:4;
  int s1995c3f33:4;
  int s1995c3f34:4;
  unsigned char s1995c3f35:1;
  unsigned char s1995c3f36:1;
  unsigned char s1995c3f37:1;
  unsigned char s1995c3f38:1;
  unsigned char s1995c3f39:1;
  unsigned char s1995c3f40:1;
  unsigned char s1995c3f41:1;
  unsigned char s1995c3f42:1;
  unsigned char s1995c3f43:1;
  unsigned char s1995c3f44:1;
  unsigned char s1995c3f45:1;
  unsigned char s1995c3f46:1;
  unsigned char s1995c3f47:1;
  unsigned char s1995c3f48:1;
  unsigned char s1995c3f49:1;
  unsigned char s1995c3f50:1;
  unsigned char s1995c3f51:1;
  unsigned char s1995c3f52:1;
  unsigned char s1995c3f53:1;
  unsigned char s1995c3f54:1;
  unsigned char s1995c3f55:1;
  unsigned char s1995c3f56:1;
  unsigned char s1995c3f57:1;
  unsigned char s1995c3f58:1;
  unsigned char s1995c3f59:1;
  unsigned char s1995c3f60:1;
  unsigned char s1995c3f61:1;
  unsigned char s1995c3f62:1;
  unsigned char s1995c3f63:1;
  unsigned char s1995c3f64:1;
  unsigned char s1995c3f65:1;
  unsigned char s1995c3f66:1;
  unsigned char s1995c3f67:1;
  unsigned char s1995c3f68:1;
  unsigned char s1995c3f69:1;
  unsigned char s1995c3f70:1;
  unsigned char s1995c3f71:1;
  unsigned char s1995c3f72:1;
  unsigned char s1995c3f73:1;
  unsigned char s1995c3f74:1;
  unsigned char s1995c3f75:1;
  int s1995c3f76[7];
  void *s1995c3f77[6];
  int s1995c3f78:8;
  int s1995c3f79:8;
  int s1995c3f80:8;
  int s1995c3f81:8;
  int s1995c3f82:8;
  int s1995c3f83:8;
  ::S1990C25 s1995c3f84;
  void *s1995c3f85[4];
  int s1995c3f86:8;
  int s1995c3f87:8;
  int s1995c3f88:8;
  int s1995c3f89:8;
  int s1995c3f90:8;
  int s1995c3f91:16;
  int s1995c3f92:16;
  int s1995c3f93:16;
  int s1995c3f94:4;
  int s1995c3f95:4;
  int s1995c3f96:4;
  int s1995c3f97:4;
  int s1995c3f98:4;
  int s1995c3f99:4;
  int s1995c3f100:4;
  int s1995c3f101:4;
  int s1995c3f102:4;
  int s1995c3f103:4;
  int s1995c3f104:4;
  int s1995c3f105:4;
  int s1995c3f106:8;
  int s1995c3f107:8;
  int s1995c3f108:8;
  void *s1995c3f109[7];
  ::S1990C46 s1995c3f110;
  void *s1995c3f111[2];
  int s1995c3f112:16;
  int s1995c3f113:16;
  ::S1990C5_nt s1995c3f114;
  ::S1990C37 s1995c3f115;
  ::S1990C29_nt s1995c3f116;
  void *s1995c3f117[2];
  int s1995c3f118:24;
  int s1995c3f119:8;
  void *s1995c3f120;
  virtual  ~S1995C3(); // _ZN7S1995C3D1Ev
  virtual void  v24(); // _ZN7S1995C33v24Ev
  virtual void  v25(); // _ZN7S1995C33v25Ev
  virtual void  v26(); // _ZN7S1995C33v26Ev
  virtual void  v27(); // _ZN7S1995C33v27Ev
  virtual void  v28(); // _ZN7S1995C33v28Ev
  virtual void  v29(); // _ZN7S1995C33v29Ev
  virtual void  v30(); // _ZN7S1995C33v30Ev
  virtual void  v31(); // _ZN7S1995C33v31Ev
  virtual void  v32(); // _ZN7S1995C33v32Ev
  virtual void  v33(); // _ZN7S1995C33v33Ev
  virtual void  v34(); // _ZN7S1995C33v34Ev
  virtual void  v35(); // _ZN7S1995C33v35Ev
  virtual void  v36(); // _ZN7S1995C33v36Ev
  virtual void  v37(); // _ZN7S1995C33v37Ev
  virtual void  v38(); // _ZN7S1995C33v38Ev
  virtual void  v39(); // _ZN7S1995C33v39Ev
  virtual void  v40(); // _ZN7S1995C33v40Ev
  virtual void  v41(); // _ZN7S1995C33v41Ev
  virtual void  v42(); // _ZN7S1995C33v42Ev
  virtual void  v43(); // _ZN7S1995C33v43Ev
  virtual void  v44(); // _ZN7S1995C33v44Ev
  virtual void  v45(); // _ZN7S1995C33v45Ev
  virtual void  v46(); // _ZN7S1995C33v46Ev
  virtual void  v47(); // _ZN7S1995C33v47Ev
  virtual void  v48(); // _ZN7S1995C33v48Ev
  virtual void  v49(); // _ZN7S1995C33v49Ev
  virtual void  v50(); // _ZN7S1995C33v50Ev
  virtual void  v51(); // _ZN7S1995C33v51Ev
  virtual void  v52(); // _ZN7S1995C33v52Ev
  virtual void  v53(); // _ZN7S1995C33v53Ev
  virtual void  v54(); // _ZN7S1995C33v54Ev
  virtual void  v55(); // _ZN7S1995C33v55Ev
  virtual void  v56(); // _ZN7S1995C33v56Ev
  virtual void  v57(); // _ZN7S1995C33v57Ev
  virtual void  v58(); // _ZN7S1995C33v58Ev
  virtual void  v59(); // _ZN7S1995C33v59Ev
  virtual void  v60(); // _ZN7S1995C33v60Ev
  virtual void  v61(); // _ZN7S1995C33v61Ev
  virtual void  v62(); // _ZN7S1995C33v62Ev
  virtual void  v63(); // _ZN7S1995C33v63Ev
  virtual void  v64(); // _ZN7S1995C33v64Ev
  virtual void  v65(); // _ZN7S1995C33v65Ev
  virtual void  v66(); // _ZN7S1995C33v66Ev
  virtual void  v67(); // _ZN7S1995C33v67Ev
  virtual void  v68(); // _ZN7S1995C33v68Ev
  virtual void  v69(); // _ZN7S1995C33v69Ev
  virtual void  v70(); // _ZN7S1995C33v70Ev
  virtual void  v71(); // _ZN7S1995C33v71Ev
  virtual void  v72(); // _ZN7S1995C33v72Ev
  virtual void  v73(); // _ZN7S1995C33v73Ev
  virtual void  v74(); // _ZN7S1995C33v74Ev
  virtual void  v75(); // _ZN7S1995C33v75Ev
  virtual void  v76(); // _ZN7S1995C33v76Ev
  virtual void  v77(); // _ZN7S1995C33v77Ev
  virtual void  v78(); // _ZN7S1995C33v78Ev
  virtual void  v79(); // _ZN7S1995C33v79Ev
  virtual void  v80(); // _ZN7S1995C33v80Ev
  virtual void  v81(); // _ZN7S1995C33v81Ev
  virtual void  v82(); // _ZN7S1995C33v82Ev
  virtual void  v83(); // _ZN7S1995C33v83Ev
  virtual void  v84(); // _ZN7S1995C33v84Ev
  virtual void  v85(); // _ZN7S1995C33v85Ev
  virtual void  v86(); // _ZN7S1995C33v86Ev
  virtual void  v87(); // _ZN7S1995C33v87Ev
  virtual void  v88(); // _ZN7S1995C33v88Ev
  virtual void  v89(); // _ZN7S1995C33v89Ev
  virtual void  v90(); // _ZN7S1995C33v90Ev
  virtual void  v91(); // _ZN7S1995C33v91Ev
  virtual void  v92(); // _ZN7S1995C33v92Ev
  virtual void  v93(); // _ZN7S1995C33v93Ev
  virtual void  v94(); // _ZN7S1995C33v94Ev
  virtual void  v95(); // _ZN7S1995C33v95Ev
  virtual void  v96(); // _ZN7S1995C33v96Ev
  virtual void  v97(); // _ZN7S1995C33v97Ev
  virtual void  v98(); // _ZN7S1995C33v98Ev
  virtual void  v99(); // _ZN7S1995C33v99Ev
  virtual void  v100(); // _ZN7S1995C34v100Ev
  virtual void  v101(); // _ZN7S1995C34v101Ev
  S1995C3(); // tgen
};
//SIG(-1 S1995C3) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fp Fi FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}} FC7{ BC8{ m Fp Fi FC9{ m} FC10{ m}}} Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 FC11{ m FC12{ m FL[2]}} FC11 FC11 FC13{ m FC12} FC14{ m FC13} FC15{ m FC13 FC13 FC13 FC13} FC15 FC11 FC11 FC11 Fp FC14 FC16{ m FC17{ m Fp Fi FC18{ m}} Fi} Fi Fp[7] FC8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC19{ BC4} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC20{ m Fp Fi[2] FC10} Fp[2] Fi:16 Fi:16 FC21{ BC22{ m Fp Fi FC23{ m} FC23}} FC24{ m Fp Fi[2] FC9} FC25{ m Fp Fi[2] FC6} Fp[2] Fi:24 Fi:8 Fp}


 S1995C3 ::~S1995C3(){ note_dtor("S1995C3", this);}
void  S1995C3 ::v24(){vfunc_called(this, "_ZN7S1995C33v24Ev");}
void  S1995C3 ::v25(){vfunc_called(this, "_ZN7S1995C33v25Ev");}
void  S1995C3 ::v26(){vfunc_called(this, "_ZN7S1995C33v26Ev");}
void  S1995C3 ::v27(){vfunc_called(this, "_ZN7S1995C33v27Ev");}
void  S1995C3 ::v28(){vfunc_called(this, "_ZN7S1995C33v28Ev");}
void  S1995C3 ::v29(){vfunc_called(this, "_ZN7S1995C33v29Ev");}
void  S1995C3 ::v30(){vfunc_called(this, "_ZN7S1995C33v30Ev");}
void  S1995C3 ::v31(){vfunc_called(this, "_ZN7S1995C33v31Ev");}
void  S1995C3 ::v32(){vfunc_called(this, "_ZN7S1995C33v32Ev");}
void  S1995C3 ::v33(){vfunc_called(this, "_ZN7S1995C33v33Ev");}
void  S1995C3 ::v34(){vfunc_called(this, "_ZN7S1995C33v34Ev");}
void  S1995C3 ::v35(){vfunc_called(this, "_ZN7S1995C33v35Ev");}
void  S1995C3 ::v36(){vfunc_called(this, "_ZN7S1995C33v36Ev");}
void  S1995C3 ::v37(){vfunc_called(this, "_ZN7S1995C33v37Ev");}
void  S1995C3 ::v38(){vfunc_called(this, "_ZN7S1995C33v38Ev");}
void  S1995C3 ::v39(){vfunc_called(this, "_ZN7S1995C33v39Ev");}
void  S1995C3 ::v40(){vfunc_called(this, "_ZN7S1995C33v40Ev");}
void  S1995C3 ::v41(){vfunc_called(this, "_ZN7S1995C33v41Ev");}
void  S1995C3 ::v42(){vfunc_called(this, "_ZN7S1995C33v42Ev");}
void  S1995C3 ::v43(){vfunc_called(this, "_ZN7S1995C33v43Ev");}
void  S1995C3 ::v44(){vfunc_called(this, "_ZN7S1995C33v44Ev");}
void  S1995C3 ::v45(){vfunc_called(this, "_ZN7S1995C33v45Ev");}
void  S1995C3 ::v46(){vfunc_called(this, "_ZN7S1995C33v46Ev");}
void  S1995C3 ::v47(){vfunc_called(this, "_ZN7S1995C33v47Ev");}
void  S1995C3 ::v48(){vfunc_called(this, "_ZN7S1995C33v48Ev");}
void  S1995C3 ::v49(){vfunc_called(this, "_ZN7S1995C33v49Ev");}
void  S1995C3 ::v50(){vfunc_called(this, "_ZN7S1995C33v50Ev");}
void  S1995C3 ::v51(){vfunc_called(this, "_ZN7S1995C33v51Ev");}
void  S1995C3 ::v52(){vfunc_called(this, "_ZN7S1995C33v52Ev");}
void  S1995C3 ::v53(){vfunc_called(this, "_ZN7S1995C33v53Ev");}
void  S1995C3 ::v54(){vfunc_called(this, "_ZN7S1995C33v54Ev");}
void  S1995C3 ::v55(){vfunc_called(this, "_ZN7S1995C33v55Ev");}
void  S1995C3 ::v56(){vfunc_called(this, "_ZN7S1995C33v56Ev");}
void  S1995C3 ::v57(){vfunc_called(this, "_ZN7S1995C33v57Ev");}
void  S1995C3 ::v58(){vfunc_called(this, "_ZN7S1995C33v58Ev");}
void  S1995C3 ::v59(){vfunc_called(this, "_ZN7S1995C33v59Ev");}
void  S1995C3 ::v60(){vfunc_called(this, "_ZN7S1995C33v60Ev");}
void  S1995C3 ::v61(){vfunc_called(this, "_ZN7S1995C33v61Ev");}
void  S1995C3 ::v62(){vfunc_called(this, "_ZN7S1995C33v62Ev");}
void  S1995C3 ::v63(){vfunc_called(this, "_ZN7S1995C33v63Ev");}
void  S1995C3 ::v64(){vfunc_called(this, "_ZN7S1995C33v64Ev");}
void  S1995C3 ::v65(){vfunc_called(this, "_ZN7S1995C33v65Ev");}
void  S1995C3 ::v66(){vfunc_called(this, "_ZN7S1995C33v66Ev");}
void  S1995C3 ::v67(){vfunc_called(this, "_ZN7S1995C33v67Ev");}
void  S1995C3 ::v68(){vfunc_called(this, "_ZN7S1995C33v68Ev");}
void  S1995C3 ::v69(){vfunc_called(this, "_ZN7S1995C33v69Ev");}
void  S1995C3 ::v70(){vfunc_called(this, "_ZN7S1995C33v70Ev");}
void  S1995C3 ::v71(){vfunc_called(this, "_ZN7S1995C33v71Ev");}
void  S1995C3 ::v72(){vfunc_called(this, "_ZN7S1995C33v72Ev");}
void  S1995C3 ::v73(){vfunc_called(this, "_ZN7S1995C33v73Ev");}
void  S1995C3 ::v74(){vfunc_called(this, "_ZN7S1995C33v74Ev");}
void  S1995C3 ::v75(){vfunc_called(this, "_ZN7S1995C33v75Ev");}
void  S1995C3 ::v76(){vfunc_called(this, "_ZN7S1995C33v76Ev");}
void  S1995C3 ::v77(){vfunc_called(this, "_ZN7S1995C33v77Ev");}
void  S1995C3 ::v78(){vfunc_called(this, "_ZN7S1995C33v78Ev");}
void  S1995C3 ::v79(){vfunc_called(this, "_ZN7S1995C33v79Ev");}
void  S1995C3 ::v80(){vfunc_called(this, "_ZN7S1995C33v80Ev");}
void  S1995C3 ::v81(){vfunc_called(this, "_ZN7S1995C33v81Ev");}
void  S1995C3 ::v82(){vfunc_called(this, "_ZN7S1995C33v82Ev");}
void  S1995C3 ::v83(){vfunc_called(this, "_ZN7S1995C33v83Ev");}
void  S1995C3 ::v84(){vfunc_called(this, "_ZN7S1995C33v84Ev");}
void  S1995C3 ::v85(){vfunc_called(this, "_ZN7S1995C33v85Ev");}
void  S1995C3 ::v86(){vfunc_called(this, "_ZN7S1995C33v86Ev");}
void  S1995C3 ::v87(){vfunc_called(this, "_ZN7S1995C33v87Ev");}
void  S1995C3 ::v88(){vfunc_called(this, "_ZN7S1995C33v88Ev");}
void  S1995C3 ::v89(){vfunc_called(this, "_ZN7S1995C33v89Ev");}
void  S1995C3 ::v90(){vfunc_called(this, "_ZN7S1995C33v90Ev");}
void  S1995C3 ::v91(){vfunc_called(this, "_ZN7S1995C33v91Ev");}
void  S1995C3 ::v92(){vfunc_called(this, "_ZN7S1995C33v92Ev");}
void  S1995C3 ::v93(){vfunc_called(this, "_ZN7S1995C33v93Ev");}
void  S1995C3 ::v94(){vfunc_called(this, "_ZN7S1995C33v94Ev");}
void  S1995C3 ::v95(){vfunc_called(this, "_ZN7S1995C33v95Ev");}
void  S1995C3 ::v96(){vfunc_called(this, "_ZN7S1995C33v96Ev");}
void  S1995C3 ::v97(){vfunc_called(this, "_ZN7S1995C33v97Ev");}
void  S1995C3 ::v98(){vfunc_called(this, "_ZN7S1995C33v98Ev");}
void  S1995C3 ::v99(){vfunc_called(this, "_ZN7S1995C33v99Ev");}
void  S1995C3 ::v100(){vfunc_called(this, "_ZN7S1995C34v100Ev");}
void  S1995C3 ::v101(){vfunc_called(this, "_ZN7S1995C34v101Ev");}
S1995C3 ::S1995C3(){ note_ctor("S1995C3", this);} // tgen

static void Test_S1995C3()
{
  extern Class_Descriptor cd_S1995C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(105,159)];
    init_test(&cd_S1995C3, buf);
    S1995C3 *dp, &lv = *(dp=new (buf) S1995C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(832,632), "sizeof(S1995C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1995C3)");
    check_base_class_offset(lv, (S1995C4*), 0, "S1995C3");
    check_field_offset(lv, s1995c3f0, ABISELECT(64,40), "S1995C3.s1995c3f0");
    check_field_offset(lv, s1995c3f1, ABISELECT(80,56), "S1995C3.s1995c3f1");
    check_field_offset(lv, s1995c3f2, ABISELECT(96,72), "S1995C3.s1995c3f2");
    check_field_offset(lv, s1995c3f3, ABISELECT(112,88), "S1995C3.s1995c3f3");
    check_field_offset(lv, s1995c3f4, ABISELECT(128,104), "S1995C3.s1995c3f4");
    check_field_offset(lv, s1995c3f5, ABISELECT(144,120), "S1995C3.s1995c3f5");
    check_field_offset(lv, s1995c3f6, ABISELECT(208,184), "S1995C3.s1995c3f6");
    check_field_offset(lv, s1995c3f7, ABISELECT(272,248), "S1995C3.s1995c3f7");
    check_field_offset(lv, s1995c3f8, ABISELECT(288,264), "S1995C3.s1995c3f8");
    check_field_offset(lv, s1995c3f9, ABISELECT(304,280), "S1995C3.s1995c3f9");
    check_field_offset(lv, s1995c3f10, ABISELECT(320,296), "S1995C3.s1995c3f10");
    check_field_offset(lv, s1995c3f11, ABISELECT(328,300), "S1995C3.s1995c3f11");
    check_field_offset(lv, s1995c3f12, ABISELECT(344,316), "S1995C3.s1995c3f12");
    check_field_offset(lv, s1995c3f13, ABISELECT(368,332), "S1995C3.s1995c3f13");
    check_field_offset(lv, s1995c3f14, ABISELECT(376,336), "S1995C3.s1995c3f14");
    check_field_offset(lv, s1995c3f15, ABISELECT(432,364), "S1995C3.s1995c3f15");
    set_bf_and_test(lv, s1995c3f16, ABISELECT(448,376), 0, 8, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f16, ABISELECT(448,376), 0, 8, hide_sll(1LL<<7), "S1995C3");
    set_bf_and_test(lv, s1995c3f17, ABISELECT(449,377), 0, 8, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f17, ABISELECT(449,377), 0, 8, hide_sll(1LL<<7), "S1995C3");
    set_bf_and_test(lv, s1995c3f18, ABISELECT(450,378), 0, 16, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f18, ABISELECT(450,378), 0, 16, hide_sll(1LL<<15), "S1995C3");
    set_bf_and_test(lv, s1995c3f19, ABISELECT(452,380), 0, 16, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f19, ABISELECT(452,380), 0, 16, hide_sll(1LL<<15), "S1995C3");
    set_bf_and_test(lv, s1995c3f20, ABISELECT(454,382), 0, 8, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f20, ABISELECT(454,382), 0, 8, hide_sll(1LL<<7), "S1995C3");
    set_bf_and_test(lv, s1995c3f21, ABISELECT(455,383), 0, 8, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f21, ABISELECT(455,383), 0, 8, hide_sll(1LL<<7), "S1995C3");
    set_bf_and_test(lv, s1995c3f22, ABISELECT(456,384), 0, 8, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f22, ABISELECT(456,384), 0, 8, hide_sll(1LL<<7), "S1995C3");
    set_bf_and_test(lv, s1995c3f23, ABISELECT(460,388), 0, 32, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f23, ABISELECT(460,388), 0, 32, hide_sll(1LL<<31), "S1995C3");
    set_bf_and_test(lv, s1995c3f24, ABISELECT(464,392), 0, 8, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f24, ABISELECT(464,392), 0, 8, hide_sll(1LL<<7), "S1995C3");
    set_bf_and_test(lv, s1995c3f25, ABISELECT(465,393), 0, 4, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f25, ABISELECT(465,393), 0, 4, hide_sll(1LL<<3), "S1995C3");
    set_bf_and_test(lv, s1995c3f26, ABISELECT(465,393), 4, 4, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f26, ABISELECT(465,393), 4, 4, hide_sll(1LL<<3), "S1995C3");
    set_bf_and_test(lv, s1995c3f27, ABISELECT(466,394), 0, 4, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f27, ABISELECT(466,394), 0, 4, hide_sll(1LL<<3), "S1995C3");
    set_bf_and_test(lv, s1995c3f28, ABISELECT(466,394), 4, 4, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f28, ABISELECT(466,394), 4, 4, hide_sll(1LL<<3), "S1995C3");
    set_bf_and_test(lv, s1995c3f29, ABISELECT(467,395), 0, 4, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f29, ABISELECT(467,395), 0, 4, hide_sll(1LL<<3), "S1995C3");
    set_bf_and_test(lv, s1995c3f30, ABISELECT(467,395), 4, 4, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f30, ABISELECT(467,395), 4, 4, hide_sll(1LL<<3), "S1995C3");
    set_bf_and_test(lv, s1995c3f31, ABISELECT(468,396), 0, 4, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f31, ABISELECT(468,396), 0, 4, hide_sll(1LL<<3), "S1995C3");
    set_bf_and_test(lv, s1995c3f32, ABISELECT(468,396), 4, 4, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f32, ABISELECT(468,396), 4, 4, hide_sll(1LL<<3), "S1995C3");
    set_bf_and_test(lv, s1995c3f33, ABISELECT(469,397), 0, 4, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f33, ABISELECT(469,397), 0, 4, hide_sll(1LL<<3), "S1995C3");
    set_bf_and_test(lv, s1995c3f34, ABISELECT(469,397), 4, 4, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f34, ABISELECT(469,397), 4, 4, hide_sll(1LL<<3), "S1995C3");
    set_bf_and_test(lv, s1995c3f35, ABISELECT(470,398), 0, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f36, ABISELECT(470,398), 1, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f37, ABISELECT(470,398), 2, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f38, ABISELECT(470,398), 3, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f39, ABISELECT(470,398), 4, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f40, ABISELECT(470,398), 5, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f41, ABISELECT(470,398), 6, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f42, ABISELECT(470,398), 7, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f43, ABISELECT(471,399), 0, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f44, ABISELECT(471,399), 1, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f45, ABISELECT(471,399), 2, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f46, ABISELECT(471,399), 3, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f47, ABISELECT(471,399), 4, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f48, ABISELECT(471,399), 5, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f49, ABISELECT(471,399), 6, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f50, ABISELECT(471,399), 7, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f51, ABISELECT(472,400), 0, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f52, ABISELECT(472,400), 1, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f53, ABISELECT(472,400), 2, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f54, ABISELECT(472,400), 3, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f55, ABISELECT(472,400), 4, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f56, ABISELECT(472,400), 5, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f57, ABISELECT(472,400), 6, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f58, ABISELECT(472,400), 7, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f59, ABISELECT(473,401), 0, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f60, ABISELECT(473,401), 1, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f61, ABISELECT(473,401), 2, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f62, ABISELECT(473,401), 3, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f63, ABISELECT(473,401), 4, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f64, ABISELECT(473,401), 5, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f65, ABISELECT(473,401), 6, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f66, ABISELECT(473,401), 7, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f67, ABISELECT(474,402), 0, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f68, ABISELECT(474,402), 1, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f69, ABISELECT(474,402), 2, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f70, ABISELECT(474,402), 3, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f71, ABISELECT(474,402), 4, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f72, ABISELECT(474,402), 5, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f73, ABISELECT(474,402), 6, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f74, ABISELECT(474,402), 7, 1, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f75, ABISELECT(475,403), 0, 1, 1, "S1995C3");
    check_field_offset(lv, s1995c3f76, ABISELECT(476,404), "S1995C3.s1995c3f76");
    check_field_offset(lv, s1995c3f77, ABISELECT(504,432), "S1995C3.s1995c3f77");
    set_bf_and_test(lv, s1995c3f78, ABISELECT(552,456), 0, 8, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f78, ABISELECT(552,456), 0, 8, hide_sll(1LL<<7), "S1995C3");
    set_bf_and_test(lv, s1995c3f79, ABISELECT(553,457), 0, 8, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f79, ABISELECT(553,457), 0, 8, hide_sll(1LL<<7), "S1995C3");
    set_bf_and_test(lv, s1995c3f80, ABISELECT(554,458), 0, 8, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f80, ABISELECT(554,458), 0, 8, hide_sll(1LL<<7), "S1995C3");
    set_bf_and_test(lv, s1995c3f81, ABISELECT(555,459), 0, 8, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f81, ABISELECT(555,459), 0, 8, hide_sll(1LL<<7), "S1995C3");
    set_bf_and_test(lv, s1995c3f82, ABISELECT(556,460), 0, 8, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f82, ABISELECT(556,460), 0, 8, hide_sll(1LL<<7), "S1995C3");
    set_bf_and_test(lv, s1995c3f83, ABISELECT(557,461), 0, 8, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f83, ABISELECT(557,461), 0, 8, hide_sll(1LL<<7), "S1995C3");
    check_field_offset(lv, s1995c3f84, ABISELECT(560,464), "S1995C3.s1995c3f84");
    check_field_offset(lv, s1995c3f85, ABISELECT(576,476), "S1995C3.s1995c3f85");
    set_bf_and_test(lv, s1995c3f86, ABISELECT(608,492), 0, 8, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f86, ABISELECT(608,492), 0, 8, hide_sll(1LL<<7), "S1995C3");
    set_bf_and_test(lv, s1995c3f87, ABISELECT(609,493), 0, 8, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f87, ABISELECT(609,493), 0, 8, hide_sll(1LL<<7), "S1995C3");
    set_bf_and_test(lv, s1995c3f88, ABISELECT(610,494), 0, 8, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f88, ABISELECT(610,494), 0, 8, hide_sll(1LL<<7), "S1995C3");
    set_bf_and_test(lv, s1995c3f89, ABISELECT(611,495), 0, 8, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f89, ABISELECT(611,495), 0, 8, hide_sll(1LL<<7), "S1995C3");
    set_bf_and_test(lv, s1995c3f90, ABISELECT(612,496), 0, 8, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f90, ABISELECT(612,496), 0, 8, hide_sll(1LL<<7), "S1995C3");
    set_bf_and_test(lv, s1995c3f91, ABISELECT(613,497), 0, 16, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f91, ABISELECT(613,497), 0, 16, hide_sll(1LL<<15), "S1995C3");
    set_bf_and_test(lv, s1995c3f92, ABISELECT(616,500), 0, 16, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f92, ABISELECT(616,500), 0, 16, hide_sll(1LL<<15), "S1995C3");
    set_bf_and_test(lv, s1995c3f93, ABISELECT(618,502), 0, 16, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f93, ABISELECT(618,502), 0, 16, hide_sll(1LL<<15), "S1995C3");
    set_bf_and_test(lv, s1995c3f94, ABISELECT(620,504), 0, 4, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f94, ABISELECT(620,504), 0, 4, hide_sll(1LL<<3), "S1995C3");
    set_bf_and_test(lv, s1995c3f95, ABISELECT(620,504), 4, 4, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f95, ABISELECT(620,504), 4, 4, hide_sll(1LL<<3), "S1995C3");
    set_bf_and_test(lv, s1995c3f96, ABISELECT(621,505), 0, 4, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f96, ABISELECT(621,505), 0, 4, hide_sll(1LL<<3), "S1995C3");
    set_bf_and_test(lv, s1995c3f97, ABISELECT(621,505), 4, 4, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f97, ABISELECT(621,505), 4, 4, hide_sll(1LL<<3), "S1995C3");
    set_bf_and_test(lv, s1995c3f98, ABISELECT(622,506), 0, 4, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f98, ABISELECT(622,506), 0, 4, hide_sll(1LL<<3), "S1995C3");
    set_bf_and_test(lv, s1995c3f99, ABISELECT(622,506), 4, 4, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f99, ABISELECT(622,506), 4, 4, hide_sll(1LL<<3), "S1995C3");
    set_bf_and_test(lv, s1995c3f100, ABISELECT(623,507), 0, 4, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f100, ABISELECT(623,507), 0, 4, hide_sll(1LL<<3), "S1995C3");
    set_bf_and_test(lv, s1995c3f101, ABISELECT(623,507), 4, 4, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f101, ABISELECT(623,507), 4, 4, hide_sll(1LL<<3), "S1995C3");
    set_bf_and_test(lv, s1995c3f102, ABISELECT(624,508), 0, 4, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f102, ABISELECT(624,508), 0, 4, hide_sll(1LL<<3), "S1995C3");
    set_bf_and_test(lv, s1995c3f103, ABISELECT(624,508), 4, 4, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f103, ABISELECT(624,508), 4, 4, hide_sll(1LL<<3), "S1995C3");
    set_bf_and_test(lv, s1995c3f104, ABISELECT(625,509), 0, 4, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f104, ABISELECT(625,509), 0, 4, hide_sll(1LL<<3), "S1995C3");
    set_bf_and_test(lv, s1995c3f105, ABISELECT(625,509), 4, 4, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f105, ABISELECT(625,509), 4, 4, hide_sll(1LL<<3), "S1995C3");
    set_bf_and_test(lv, s1995c3f106, ABISELECT(626,510), 0, 8, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f106, ABISELECT(626,510), 0, 8, hide_sll(1LL<<7), "S1995C3");
    set_bf_and_test(lv, s1995c3f107, ABISELECT(627,511), 0, 8, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f107, ABISELECT(627,511), 0, 8, hide_sll(1LL<<7), "S1995C3");
    set_bf_and_test(lv, s1995c3f108, ABISELECT(628,512), 0, 8, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f108, ABISELECT(628,512), 0, 8, hide_sll(1LL<<7), "S1995C3");
    check_field_offset(lv, s1995c3f109, ABISELECT(632,516), "S1995C3.s1995c3f109");
    check_field_offset(lv, s1995c3f110, ABISELECT(688,544), "S1995C3.s1995c3f110");
    check_field_offset(lv, s1995c3f111, ABISELECT(712,560), "S1995C3.s1995c3f111");
    set_bf_and_test(lv, s1995c3f112, ABISELECT(728,568), 0, 16, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f112, ABISELECT(728,568), 0, 16, hide_sll(1LL<<15), "S1995C3");
    set_bf_and_test(lv, s1995c3f113, ABISELECT(730,570), 0, 16, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f113, ABISELECT(730,570), 0, 16, hide_sll(1LL<<15), "S1995C3");
    check_field_offset(lv, s1995c3f114, ABISELECT(736,572), "S1995C3.s1995c3f114");
    check_field_offset(lv, s1995c3f115, ABISELECT(752,584), "S1995C3.s1995c3f115");
    check_field_offset(lv, s1995c3f116, ABISELECT(776,600), "S1995C3.s1995c3f116");
    check_field_offset(lv, s1995c3f117, ABISELECT(800,616), "S1995C3.s1995c3f117");
    set_bf_and_test(lv, s1995c3f118, ABISELECT(816,624), 0, 24, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f118, ABISELECT(816,624), 0, 24, hide_sll(1LL<<23), "S1995C3");
    set_bf_and_test(lv, s1995c3f119, ABISELECT(819,627), 0, 8, 1, "S1995C3");
    set_bf_and_test(lv, s1995c3f119, ABISELECT(819,627), 0, 8, hide_sll(1LL<<7), "S1995C3");
    check_field_offset(lv, s1995c3f120, ABISELECT(824,628), "S1995C3.s1995c3f120");
    test_class_info(&lv, &cd_S1995C3);
    dp->~S1995C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1995C3(Test_S1995C3, "S1995C3", ABISELECT(832,632));

#else // __cplusplus

extern void _ZN7S1995C3C1Ev();
extern void _ZN7S1995C3D1Ev();
Name_Map name_map_S1995C3[] = {
  NSPAIR(_ZN7S1995C3C1Ev),
  NSPAIR(_ZN7S1995C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1995C4;
extern VTBL_ENTRY _ZTI7S1995C4[];
extern  VTBL_ENTRY _ZTV7S1995C4[];
static Base_Class bases_S1995C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1995C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1995C3[];
extern void _ZN7S1995C3D1Ev();
extern void _ZN7S1995C3D0Ev();
extern void _ZN7S1995C42v1Ev();
extern void _ZN7S1995C42v2Ev();
extern void _ZN7S1995C42v3Ev();
extern void _ZN7S1995C42v4Ev();
extern void _ZN7S1995C42v5Ev();
extern void _ZN7S1995C42v6Ev();
extern void _ZN7S1995C42v7Ev();
extern void _ZN7S1995C42v8Ev();
extern void _ZN7S1995C42v9Ev();
extern void _ZN7S1995C43v10Ev();
extern void _ZN7S1995C43v11Ev();
extern void _ZN7S1995C43v12Ev();
extern void _ZN7S1995C43v13Ev();
extern void _ZN7S1995C43v14Ev();
extern void _ZN7S1995C43v15Ev();
extern void _ZN7S1995C43v16Ev();
extern void _ZN7S1995C43v17Ev();
extern void _ZN7S1995C43v18Ev();
extern void _ZN7S1995C43v19Ev();
extern void _ZN7S1995C43v20Ev();
extern void _ZN7S1995C43v21Ev();
extern void _ZN7S1995C43v22Ev();
extern void _ZN7S1995C43v23Ev();
extern void _ZN7S1995C33v24Ev();
extern void _ZN7S1995C33v25Ev();
extern void _ZN7S1995C33v26Ev();
extern void _ZN7S1995C33v27Ev();
extern void _ZN7S1995C33v28Ev();
extern void _ZN7S1995C33v29Ev();
extern void _ZN7S1995C33v30Ev();
extern void _ZN7S1995C33v31Ev();
extern void _ZN7S1995C33v32Ev();
extern void _ZN7S1995C33v33Ev();
extern void _ZN7S1995C33v34Ev();
extern void _ZN7S1995C33v35Ev();
extern void _ZN7S1995C33v36Ev();
extern void _ZN7S1995C33v37Ev();
extern void _ZN7S1995C33v38Ev();
extern void _ZN7S1995C33v39Ev();
extern void _ZN7S1995C33v40Ev();
extern void _ZN7S1995C33v41Ev();
extern void _ZN7S1995C33v42Ev();
extern void _ZN7S1995C33v43Ev();
extern void _ZN7S1995C33v44Ev();
extern void _ZN7S1995C33v45Ev();
extern void _ZN7S1995C33v46Ev();
extern void _ZN7S1995C33v47Ev();
extern void _ZN7S1995C33v48Ev();
extern void _ZN7S1995C33v49Ev();
extern void _ZN7S1995C33v50Ev();
extern void _ZN7S1995C33v51Ev();
extern void _ZN7S1995C33v52Ev();
extern void _ZN7S1995C33v53Ev();
extern void _ZN7S1995C33v54Ev();
extern void _ZN7S1995C33v55Ev();
extern void _ZN7S1995C33v56Ev();
extern void _ZN7S1995C33v57Ev();
extern void _ZN7S1995C33v58Ev();
extern void _ZN7S1995C33v59Ev();
extern void _ZN7S1995C33v60Ev();
extern void _ZN7S1995C33v61Ev();
extern void _ZN7S1995C33v62Ev();
extern void _ZN7S1995C33v63Ev();
extern void _ZN7S1995C33v64Ev();
extern void _ZN7S1995C33v65Ev();
extern void _ZN7S1995C33v66Ev();
extern void _ZN7S1995C33v67Ev();
extern void _ZN7S1995C33v68Ev();
extern void _ZN7S1995C33v69Ev();
extern void _ZN7S1995C33v70Ev();
extern void _ZN7S1995C33v71Ev();
extern void _ZN7S1995C33v72Ev();
extern void _ZN7S1995C33v73Ev();
extern void _ZN7S1995C33v74Ev();
extern void _ZN7S1995C33v75Ev();
extern void _ZN7S1995C33v76Ev();
extern void _ZN7S1995C33v77Ev();
extern void _ZN7S1995C33v78Ev();
extern void _ZN7S1995C33v79Ev();
extern void _ZN7S1995C33v80Ev();
extern void _ZN7S1995C33v81Ev();
extern void _ZN7S1995C33v82Ev();
extern void _ZN7S1995C33v83Ev();
extern void _ZN7S1995C33v84Ev();
extern void _ZN7S1995C33v85Ev();
extern void _ZN7S1995C33v86Ev();
extern void _ZN7S1995C33v87Ev();
extern void _ZN7S1995C33v88Ev();
extern void _ZN7S1995C33v89Ev();
extern void _ZN7S1995C33v90Ev();
extern void _ZN7S1995C33v91Ev();
extern void _ZN7S1995C33v92Ev();
extern void _ZN7S1995C33v93Ev();
extern void _ZN7S1995C33v94Ev();
extern void _ZN7S1995C33v95Ev();
extern void _ZN7S1995C33v96Ev();
extern void _ZN7S1995C33v97Ev();
extern void _ZN7S1995C33v98Ev();
extern void _ZN7S1995C33v99Ev();
extern void _ZN7S1995C34v100Ev();
extern void _ZN7S1995C34v101Ev();
static  VTBL_ENTRY vtc_S1995C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1995C3[0]),
  (VTBL_ENTRY)&_ZN7S1995C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1995C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v1Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v29Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v30Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v31Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v32Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v33Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v34Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v35Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v36Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v37Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v38Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v39Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v40Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v41Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v42Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v43Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v44Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v45Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v46Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v47Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v48Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v49Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v50Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v51Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v52Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v53Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v54Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v55Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v56Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v57Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v58Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v59Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v60Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v61Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v62Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v63Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v64Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v65Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v66Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v67Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v68Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v69Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1995C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1995C34v101Ev,
};
extern VTBL_ENTRY _ZTI7S1995C3[];
extern  VTBL_ENTRY _ZTV7S1995C3[];
Class_Descriptor cd_S1995C3 = {  "S1995C3", // class name
  bases_S1995C3, 1,
  &(vtc_S1995C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI7S1995C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1995C3),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1995C2  : S1995C3 {
  void *s1995c2f0;
  char s1995c2f1;
  ::S1990C39_nt s1995c2f2;
  ::S1990C19_nt s1995c2f3;
  virtual  ~S1995C2(); // _ZN7S1995C2D1Ev
  virtual void  v102(); // _ZN7S1995C24v102Ev
  virtual void  v103(); // _ZN7S1995C24v103Ev
  virtual void  v104(); // _ZN7S1995C24v104Ev
  virtual void  v105(); // _ZN7S1995C24v105Ev
  virtual void  v106(); // _ZN7S1995C24v106Ev
  virtual void  v107(); // _ZN7S1995C24v107Ev
  virtual void  v108(); // _ZN7S1995C24v108Ev
  virtual void  v109(); // _ZN7S1995C24v109Ev
  virtual void  v110(); // _ZN7S1995C24v110Ev
  S1995C2(); // tgen
};
//SIG(-1 S1995C2) C1{ BC2{ BC3{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 Fp Fi FC4{ BC5{ m Fp Fi FC6{ m} FC7{ m}}} FC8{ BC9{ m Fp Fi FC10{ m} FC11{ m}}} Fi} vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 FC12{ m FC13{ m FL[2]}} FC12 FC12 FC14{ m FC13} FC15{ m FC14} FC16{ m FC14 FC14 FC14 FC14} FC16 FC12 FC12 FC12 Fp FC15 FC17{ m FC18{ m Fp Fi FC19{ m}} Fi} Fi Fp[7] FC9 Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC20{ BC5} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC21{ m Fp Fi[2] FC11} Fp[2] Fi:16 Fi:16 FC22{ BC23{ m Fp Fi FC24{ m} FC24}} FC25{ m Fp Fi[2] FC10} FC26{ m Fp Fi[2] FC7} Fp[2] Fi:24 Fi:8 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fp Fc FC27{ m FC25 FC8 FC21 FC8} FC17}


 S1995C2 ::~S1995C2(){ note_dtor("S1995C2", this);}
void  S1995C2 ::v102(){vfunc_called(this, "_ZN7S1995C24v102Ev");}
void  S1995C2 ::v103(){vfunc_called(this, "_ZN7S1995C24v103Ev");}
void  S1995C2 ::v104(){vfunc_called(this, "_ZN7S1995C24v104Ev");}
void  S1995C2 ::v105(){vfunc_called(this, "_ZN7S1995C24v105Ev");}
void  S1995C2 ::v106(){vfunc_called(this, "_ZN7S1995C24v106Ev");}
void  S1995C2 ::v107(){vfunc_called(this, "_ZN7S1995C24v107Ev");}
void  S1995C2 ::v108(){vfunc_called(this, "_ZN7S1995C24v108Ev");}
void  S1995C2 ::v109(){vfunc_called(this, "_ZN7S1995C24v109Ev");}
void  S1995C2 ::v110(){vfunc_called(this, "_ZN7S1995C24v110Ev");}
S1995C2 ::S1995C2(){ note_ctor("S1995C2", this);} // tgen

static void Test_S1995C2()
{
  extern Class_Descriptor cd_S1995C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(120,179)];
    init_test(&cd_S1995C2, buf);
    S1995C2 *dp, &lv = *(dp=new (buf) S1995C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(952,712), "sizeof(S1995C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1995C2)");
    check_base_class_offset(lv, (S1995C4*)(S1995C3*), 0, "S1995C2");
    check_base_class_offset(lv, (S1995C3*), 0, "S1995C2");
    check_field_offset(lv, s1995c2f0, ABISELECT(832,632), "S1995C2.s1995c2f0");
    check_field_offset(lv, s1995c2f1, ABISELECT(840,636), "S1995C2.s1995c2f1");
    check_field_offset(lv, s1995c2f2, ABISELECT(848,640), "S1995C2.s1995c2f2");
    check_field_offset(lv, s1995c2f3, ABISELECT(928,696), "S1995C2.s1995c2f3");
    test_class_info(&lv, &cd_S1995C2);
    dp->~S1995C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1995C2(Test_S1995C2, "S1995C2", ABISELECT(952,712));

#else // __cplusplus

extern void _ZN7S1995C2C1Ev();
extern void _ZN7S1995C2D1Ev();
Name_Map name_map_S1995C2[] = {
  NSPAIR(_ZN7S1995C2C1Ev),
  NSPAIR(_ZN7S1995C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1995C4;
extern VTBL_ENTRY _ZTI7S1995C4[];
extern  VTBL_ENTRY _ZTV7S1995C4[];
extern Class_Descriptor cd_S1995C3;
extern VTBL_ENTRY _ZTI7S1995C3[];
extern  VTBL_ENTRY _ZTV7S1995C3[];
static Base_Class bases_S1995C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1995C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1995C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1995C2[];
extern void _ZN7S1995C2D1Ev();
extern void _ZN7S1995C2D0Ev();
extern void _ZN7S1995C42v1Ev();
extern void _ZN7S1995C42v2Ev();
extern void _ZN7S1995C42v3Ev();
extern void _ZN7S1995C42v4Ev();
extern void _ZN7S1995C42v5Ev();
extern void _ZN7S1995C42v6Ev();
extern void _ZN7S1995C42v7Ev();
extern void _ZN7S1995C42v8Ev();
extern void _ZN7S1995C42v9Ev();
extern void _ZN7S1995C43v10Ev();
extern void _ZN7S1995C43v11Ev();
extern void _ZN7S1995C43v12Ev();
extern void _ZN7S1995C43v13Ev();
extern void _ZN7S1995C43v14Ev();
extern void _ZN7S1995C43v15Ev();
extern void _ZN7S1995C43v16Ev();
extern void _ZN7S1995C43v17Ev();
extern void _ZN7S1995C43v18Ev();
extern void _ZN7S1995C43v19Ev();
extern void _ZN7S1995C43v20Ev();
extern void _ZN7S1995C43v21Ev();
extern void _ZN7S1995C43v22Ev();
extern void _ZN7S1995C43v23Ev();
extern void _ZN7S1995C33v24Ev();
extern void _ZN7S1995C33v25Ev();
extern void _ZN7S1995C33v26Ev();
extern void _ZN7S1995C33v27Ev();
extern void _ZN7S1995C33v28Ev();
extern void _ZN7S1995C33v29Ev();
extern void _ZN7S1995C33v30Ev();
extern void _ZN7S1995C33v31Ev();
extern void _ZN7S1995C33v32Ev();
extern void _ZN7S1995C33v33Ev();
extern void _ZN7S1995C33v34Ev();
extern void _ZN7S1995C33v35Ev();
extern void _ZN7S1995C33v36Ev();
extern void _ZN7S1995C33v37Ev();
extern void _ZN7S1995C33v38Ev();
extern void _ZN7S1995C33v39Ev();
extern void _ZN7S1995C33v40Ev();
extern void _ZN7S1995C33v41Ev();
extern void _ZN7S1995C33v42Ev();
extern void _ZN7S1995C33v43Ev();
extern void _ZN7S1995C33v44Ev();
extern void _ZN7S1995C33v45Ev();
extern void _ZN7S1995C33v46Ev();
extern void _ZN7S1995C33v47Ev();
extern void _ZN7S1995C33v48Ev();
extern void _ZN7S1995C33v49Ev();
extern void _ZN7S1995C33v50Ev();
extern void _ZN7S1995C33v51Ev();
extern void _ZN7S1995C33v52Ev();
extern void _ZN7S1995C33v53Ev();
extern void _ZN7S1995C33v54Ev();
extern void _ZN7S1995C33v55Ev();
extern void _ZN7S1995C33v56Ev();
extern void _ZN7S1995C33v57Ev();
extern void _ZN7S1995C33v58Ev();
extern void _ZN7S1995C33v59Ev();
extern void _ZN7S1995C33v60Ev();
extern void _ZN7S1995C33v61Ev();
extern void _ZN7S1995C33v62Ev();
extern void _ZN7S1995C33v63Ev();
extern void _ZN7S1995C33v64Ev();
extern void _ZN7S1995C33v65Ev();
extern void _ZN7S1995C33v66Ev();
extern void _ZN7S1995C33v67Ev();
extern void _ZN7S1995C33v68Ev();
extern void _ZN7S1995C33v69Ev();
extern void _ZN7S1995C33v70Ev();
extern void _ZN7S1995C33v71Ev();
extern void _ZN7S1995C33v72Ev();
extern void _ZN7S1995C33v73Ev();
extern void _ZN7S1995C33v74Ev();
extern void _ZN7S1995C33v75Ev();
extern void _ZN7S1995C33v76Ev();
extern void _ZN7S1995C33v77Ev();
extern void _ZN7S1995C33v78Ev();
extern void _ZN7S1995C33v79Ev();
extern void _ZN7S1995C33v80Ev();
extern void _ZN7S1995C33v81Ev();
extern void _ZN7S1995C33v82Ev();
extern void _ZN7S1995C33v83Ev();
extern void _ZN7S1995C33v84Ev();
extern void _ZN7S1995C33v85Ev();
extern void _ZN7S1995C33v86Ev();
extern void _ZN7S1995C33v87Ev();
extern void _ZN7S1995C33v88Ev();
extern void _ZN7S1995C33v89Ev();
extern void _ZN7S1995C33v90Ev();
extern void _ZN7S1995C33v91Ev();
extern void _ZN7S1995C33v92Ev();
extern void _ZN7S1995C33v93Ev();
extern void _ZN7S1995C33v94Ev();
extern void _ZN7S1995C33v95Ev();
extern void _ZN7S1995C33v96Ev();
extern void _ZN7S1995C33v97Ev();
extern void _ZN7S1995C33v98Ev();
extern void _ZN7S1995C33v99Ev();
extern void _ZN7S1995C34v100Ev();
extern void _ZN7S1995C34v101Ev();
extern void _ZN7S1995C24v102Ev();
extern void _ZN7S1995C24v103Ev();
extern void _ZN7S1995C24v104Ev();
extern void _ZN7S1995C24v105Ev();
extern void _ZN7S1995C24v106Ev();
extern void _ZN7S1995C24v107Ev();
extern void _ZN7S1995C24v108Ev();
extern void _ZN7S1995C24v109Ev();
extern void _ZN7S1995C24v110Ev();
static  VTBL_ENTRY vtc_S1995C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1995C2[0]),
  (VTBL_ENTRY)&_ZN7S1995C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1995C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v1Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v29Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v30Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v31Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v32Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v33Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v34Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v35Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v36Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v37Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v38Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v39Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v40Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v41Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v42Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v43Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v44Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v45Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v46Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v47Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v48Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v49Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v50Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v51Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v52Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v53Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v54Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v55Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v56Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v57Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v58Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v59Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v60Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v61Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v62Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v63Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v64Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v65Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v66Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v67Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v68Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v69Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1995C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1995C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1995C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1995C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1995C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1995C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1995C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1995C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1995C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1995C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1995C24v110Ev,
};
extern VTBL_ENTRY _ZTI7S1995C2[];
extern  VTBL_ENTRY _ZTV7S1995C2[];
Class_Descriptor cd_S1995C2 = {  "S1995C2", // class name
  bases_S1995C2, 2,
  &(vtc_S1995C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(952,712), // object size
  NSPAIRA(_ZTI7S1995C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1995C2),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1995C1  : S1995C2 {
  ::S1990C52_nt s1995c1f0;
  void *s1995c1f1;
  int s1995c1f2;
  virtual  ~S1995C1(); // _ZN7S1995C1D1Ev
  S1995C1(); // tgen
};
//SIG(1 S1995C1) C1{ BC2{ BC3{ BC4{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC5{ BC6{ m Fp Fi FC7{ m} FC8{ m}}} FC9{ BC10{ m Fp Fi FC11{ m} FC12{ m}}} Fi} vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 FC13{ m FC14{ m FL[2]}} FC13 FC13 FC15{ m FC14} FC16{ m FC15} FC17{ m FC15 FC15 FC15 FC15} FC17 FC13 FC13 FC13 Fp FC16 FC18{ m FC19{ m Fp Fi FC20{ m}} Fi} Fi Fp[7] FC10 Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC21{ BC6} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC22{ m Fp Fi[2] FC12} Fp[2] Fi:16 Fi:16 FC23{ BC24{ m Fp Fi FC25{ m} FC25}} FC26{ m Fp Fi[2] FC11} FC27{ m Fp Fi[2] FC8} Fp[2] Fi:24 Fi:8 Fp} vd v102 v103 v104 v105 v106 v107 v108 v109 v110 Fp Fc FC28{ m FC26 FC9 FC22 FC9} FC18} vd FC29{ m Fp[2]} Fp Fi}


 S1995C1 ::~S1995C1(){ note_dtor("S1995C1", this);}
S1995C1 ::S1995C1(){ note_ctor("S1995C1", this);} // tgen

static void Test_S1995C1()
{
  extern Class_Descriptor cd_S1995C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(124,183)];
    init_test(&cd_S1995C1, buf);
    S1995C1 *dp, &lv = *(dp=new (buf) S1995C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(984,728), "sizeof(S1995C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1995C1)");
    check_base_class_offset(lv, (S1995C4*)(S1995C3*)(S1995C2*), 0, "S1995C1");
    check_base_class_offset(lv, (S1995C3*)(S1995C2*), 0, "S1995C1");
    check_base_class_offset(lv, (S1995C2*), 0, "S1995C1");
    check_field_offset(lv, s1995c1f0, ABISELECT(952,712), "S1995C1.s1995c1f0");
    check_field_offset(lv, s1995c1f1, ABISELECT(968,720), "S1995C1.s1995c1f1");
    check_field_offset(lv, s1995c1f2, ABISELECT(976,724), "S1995C1.s1995c1f2");
    test_class_info(&lv, &cd_S1995C1);
    dp->~S1995C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1995C1(Test_S1995C1, "S1995C1", ABISELECT(984,728));

#else // __cplusplus

extern void _ZN7S1995C1C1Ev();
extern void _ZN7S1995C1D1Ev();
Name_Map name_map_S1995C1[] = {
  NSPAIR(_ZN7S1995C1C1Ev),
  NSPAIR(_ZN7S1995C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1995C4;
extern VTBL_ENTRY _ZTI7S1995C4[];
extern  VTBL_ENTRY _ZTV7S1995C4[];
extern Class_Descriptor cd_S1995C3;
extern VTBL_ENTRY _ZTI7S1995C3[];
extern  VTBL_ENTRY _ZTV7S1995C3[];
extern Class_Descriptor cd_S1995C2;
extern VTBL_ENTRY _ZTI7S1995C2[];
extern  VTBL_ENTRY _ZTV7S1995C2[];
static Base_Class bases_S1995C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1995C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1995C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1995C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1995C1[];
extern void _ZN7S1995C1D1Ev();
extern void _ZN7S1995C1D0Ev();
extern void _ZN7S1995C42v1Ev();
extern void _ZN7S1995C42v2Ev();
extern void _ZN7S1995C42v3Ev();
extern void _ZN7S1995C42v4Ev();
extern void _ZN7S1995C42v5Ev();
extern void _ZN7S1995C42v6Ev();
extern void _ZN7S1995C42v7Ev();
extern void _ZN7S1995C42v8Ev();
extern void _ZN7S1995C42v9Ev();
extern void _ZN7S1995C43v10Ev();
extern void _ZN7S1995C43v11Ev();
extern void _ZN7S1995C43v12Ev();
extern void _ZN7S1995C43v13Ev();
extern void _ZN7S1995C43v14Ev();
extern void _ZN7S1995C43v15Ev();
extern void _ZN7S1995C43v16Ev();
extern void _ZN7S1995C43v17Ev();
extern void _ZN7S1995C43v18Ev();
extern void _ZN7S1995C43v19Ev();
extern void _ZN7S1995C43v20Ev();
extern void _ZN7S1995C43v21Ev();
extern void _ZN7S1995C43v22Ev();
extern void _ZN7S1995C43v23Ev();
extern void _ZN7S1995C33v24Ev();
extern void _ZN7S1995C33v25Ev();
extern void _ZN7S1995C33v26Ev();
extern void _ZN7S1995C33v27Ev();
extern void _ZN7S1995C33v28Ev();
extern void _ZN7S1995C33v29Ev();
extern void _ZN7S1995C33v30Ev();
extern void _ZN7S1995C33v31Ev();
extern void _ZN7S1995C33v32Ev();
extern void _ZN7S1995C33v33Ev();
extern void _ZN7S1995C33v34Ev();
extern void _ZN7S1995C33v35Ev();
extern void _ZN7S1995C33v36Ev();
extern void _ZN7S1995C33v37Ev();
extern void _ZN7S1995C33v38Ev();
extern void _ZN7S1995C33v39Ev();
extern void _ZN7S1995C33v40Ev();
extern void _ZN7S1995C33v41Ev();
extern void _ZN7S1995C33v42Ev();
extern void _ZN7S1995C33v43Ev();
extern void _ZN7S1995C33v44Ev();
extern void _ZN7S1995C33v45Ev();
extern void _ZN7S1995C33v46Ev();
extern void _ZN7S1995C33v47Ev();
extern void _ZN7S1995C33v48Ev();
extern void _ZN7S1995C33v49Ev();
extern void _ZN7S1995C33v50Ev();
extern void _ZN7S1995C33v51Ev();
extern void _ZN7S1995C33v52Ev();
extern void _ZN7S1995C33v53Ev();
extern void _ZN7S1995C33v54Ev();
extern void _ZN7S1995C33v55Ev();
extern void _ZN7S1995C33v56Ev();
extern void _ZN7S1995C33v57Ev();
extern void _ZN7S1995C33v58Ev();
extern void _ZN7S1995C33v59Ev();
extern void _ZN7S1995C33v60Ev();
extern void _ZN7S1995C33v61Ev();
extern void _ZN7S1995C33v62Ev();
extern void _ZN7S1995C33v63Ev();
extern void _ZN7S1995C33v64Ev();
extern void _ZN7S1995C33v65Ev();
extern void _ZN7S1995C33v66Ev();
extern void _ZN7S1995C33v67Ev();
extern void _ZN7S1995C33v68Ev();
extern void _ZN7S1995C33v69Ev();
extern void _ZN7S1995C33v70Ev();
extern void _ZN7S1995C33v71Ev();
extern void _ZN7S1995C33v72Ev();
extern void _ZN7S1995C33v73Ev();
extern void _ZN7S1995C33v74Ev();
extern void _ZN7S1995C33v75Ev();
extern void _ZN7S1995C33v76Ev();
extern void _ZN7S1995C33v77Ev();
extern void _ZN7S1995C33v78Ev();
extern void _ZN7S1995C33v79Ev();
extern void _ZN7S1995C33v80Ev();
extern void _ZN7S1995C33v81Ev();
extern void _ZN7S1995C33v82Ev();
extern void _ZN7S1995C33v83Ev();
extern void _ZN7S1995C33v84Ev();
extern void _ZN7S1995C33v85Ev();
extern void _ZN7S1995C33v86Ev();
extern void _ZN7S1995C33v87Ev();
extern void _ZN7S1995C33v88Ev();
extern void _ZN7S1995C33v89Ev();
extern void _ZN7S1995C33v90Ev();
extern void _ZN7S1995C33v91Ev();
extern void _ZN7S1995C33v92Ev();
extern void _ZN7S1995C33v93Ev();
extern void _ZN7S1995C33v94Ev();
extern void _ZN7S1995C33v95Ev();
extern void _ZN7S1995C33v96Ev();
extern void _ZN7S1995C33v97Ev();
extern void _ZN7S1995C33v98Ev();
extern void _ZN7S1995C33v99Ev();
extern void _ZN7S1995C34v100Ev();
extern void _ZN7S1995C34v101Ev();
extern void _ZN7S1995C24v102Ev();
extern void _ZN7S1995C24v103Ev();
extern void _ZN7S1995C24v104Ev();
extern void _ZN7S1995C24v105Ev();
extern void _ZN7S1995C24v106Ev();
extern void _ZN7S1995C24v107Ev();
extern void _ZN7S1995C24v108Ev();
extern void _ZN7S1995C24v109Ev();
extern void _ZN7S1995C24v110Ev();
static  VTBL_ENTRY vtc_S1995C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1995C1[0]),
  (VTBL_ENTRY)&_ZN7S1995C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1995C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v1Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1995C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1995C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v29Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v30Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v31Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v32Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v33Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v34Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v35Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v36Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v37Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v38Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v39Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v40Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v41Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v42Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v43Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v44Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v45Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v46Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v47Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v48Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v49Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v50Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v51Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v52Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v53Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v54Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v55Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v56Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v57Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v58Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v59Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v60Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v61Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v62Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v63Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v64Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v65Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v66Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v67Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v68Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v69Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1995C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1995C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1995C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1995C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1995C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1995C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1995C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1995C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1995C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1995C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1995C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1995C24v110Ev,
};
extern VTBL_ENTRY _ZTI7S1995C1[];
extern  VTBL_ENTRY _ZTV7S1995C1[];
Class_Descriptor cd_S1995C1 = {  "S1995C1", // class name
  bases_S1995C1, 3,
  &(vtc_S1995C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(984,728), // object size
  NSPAIRA(_ZTI7S1995C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1995C1),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2217C4  {
  void *s2217c4f0;
  int s2217c4f1;
  ::S1993C31 s2217c4f2;
  ::S1990C42 s2217c4f3;
  int s2217c4f4;
  virtual  ~S2217C4(); // _ZN7S2217C4D1Ev
  virtual void  v3(); // _ZN7S2217C42v3Ev
  virtual void  v4(); // _ZN7S2217C42v4Ev
  virtual void  v5(); // _ZN7S2217C42v5Ev
  virtual void  v6(); // _ZN7S2217C42v6Ev
  virtual void  v7(); // _ZN7S2217C42v7Ev
  virtual void  v8(); // _ZN7S2217C42v8Ev
  virtual void  v9(); // _ZN7S2217C42v9Ev
  virtual void  v10(); // _ZN7S2217C43v10Ev
  virtual void  v11(); // _ZN7S2217C43v11Ev
  virtual void  v12(); // _ZN7S2217C43v12Ev
  virtual void  v13(); // _ZN7S2217C43v13Ev
  virtual void  v14(); // _ZN7S2217C43v14Ev
  virtual void  v15(); // _ZN7S2217C43v15Ev
  virtual void  v16(); // _ZN7S2217C43v16Ev
  virtual void  v17(); // _ZN7S2217C43v17Ev
  virtual void  v18(); // _ZN7S2217C43v18Ev
  virtual void  v19(); // _ZN7S2217C43v19Ev
  virtual void  v20(); // _ZN7S2217C43v20Ev
  virtual void  v21(); // _ZN7S2217C43v21Ev
  virtual void  v22(); // _ZN7S2217C43v22Ev
  virtual void  v23(); // _ZN7S2217C43v23Ev
  virtual void  v24(); // _ZN7S2217C43v24Ev
  virtual void  v25(); // _ZN7S2217C43v25Ev
  S2217C4(); // tgen
};
//SIG(-1 S2217C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}} FC6{ BC7{ m Fp Fi FC8{ m} FC9{ m}}} Fi}


 S2217C4 ::~S2217C4(){ note_dtor("S2217C4", this);}
void  S2217C4 ::v3(){vfunc_called(this, "_ZN7S2217C42v3Ev");}
void  S2217C4 ::v4(){vfunc_called(this, "_ZN7S2217C42v4Ev");}
void  S2217C4 ::v5(){vfunc_called(this, "_ZN7S2217C42v5Ev");}
void  S2217C4 ::v6(){vfunc_called(this, "_ZN7S2217C42v6Ev");}
void  S2217C4 ::v7(){vfunc_called(this, "_ZN7S2217C42v7Ev");}
void  S2217C4 ::v8(){vfunc_called(this, "_ZN7S2217C42v8Ev");}
void  S2217C4 ::v9(){vfunc_called(this, "_ZN7S2217C42v9Ev");}
void  S2217C4 ::v10(){vfunc_called(this, "_ZN7S2217C43v10Ev");}
void  S2217C4 ::v11(){vfunc_called(this, "_ZN7S2217C43v11Ev");}
void  S2217C4 ::v12(){vfunc_called(this, "_ZN7S2217C43v12Ev");}
void  S2217C4 ::v13(){vfunc_called(this, "_ZN7S2217C43v13Ev");}
void  S2217C4 ::v14(){vfunc_called(this, "_ZN7S2217C43v14Ev");}
void  S2217C4 ::v15(){vfunc_called(this, "_ZN7S2217C43v15Ev");}
void  S2217C4 ::v16(){vfunc_called(this, "_ZN7S2217C43v16Ev");}
void  S2217C4 ::v17(){vfunc_called(this, "_ZN7S2217C43v17Ev");}
void  S2217C4 ::v18(){vfunc_called(this, "_ZN7S2217C43v18Ev");}
void  S2217C4 ::v19(){vfunc_called(this, "_ZN7S2217C43v19Ev");}
void  S2217C4 ::v20(){vfunc_called(this, "_ZN7S2217C43v20Ev");}
void  S2217C4 ::v21(){vfunc_called(this, "_ZN7S2217C43v21Ev");}
void  S2217C4 ::v22(){vfunc_called(this, "_ZN7S2217C43v22Ev");}
void  S2217C4 ::v23(){vfunc_called(this, "_ZN7S2217C43v23Ev");}
void  S2217C4 ::v24(){vfunc_called(this, "_ZN7S2217C43v24Ev");}
void  S2217C4 ::v25(){vfunc_called(this, "_ZN7S2217C43v25Ev");}
S2217C4 ::S2217C4(){ note_ctor("S2217C4", this);} // tgen

static void Test_S2217C4()
{
  extern Class_Descriptor cd_S2217C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_S2217C4, buf);
    S2217C4 *dp, &lv = *(dp=new (buf) S2217C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(S2217C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2217C4)");
    check_field_offset(lv, s2217c4f0, ABISELECT(8,4), "S2217C4.s2217c4f0");
    check_field_offset(lv, s2217c4f1, ABISELECT(16,8), "S2217C4.s2217c4f1");
    check_field_offset(lv, s2217c4f2, ABISELECT(24,12), "S2217C4.s2217c4f2");
    check_field_offset(lv, s2217c4f3, ABISELECT(40,24), "S2217C4.s2217c4f3");
    check_field_offset(lv, s2217c4f4, ABISELECT(56,36), "S2217C4.s2217c4f4");
    test_class_info(&lv, &cd_S2217C4);
    dp->~S2217C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2217C4(Test_S2217C4, "S2217C4", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN7S2217C4C1Ev();
extern void _ZN7S2217C4D1Ev();
Name_Map name_map_S2217C4[] = {
  NSPAIR(_ZN7S2217C4C1Ev),
  NSPAIR(_ZN7S2217C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2217C4[];
extern void _ZN7S2217C4D1Ev();
extern void _ZN7S2217C4D0Ev();
extern void _ZN7S2217C42v3Ev();
extern void _ZN7S2217C42v4Ev();
extern void _ZN7S2217C42v5Ev();
extern void _ZN7S2217C42v6Ev();
extern void _ZN7S2217C42v7Ev();
extern void _ZN7S2217C42v8Ev();
extern void _ZN7S2217C42v9Ev();
extern void _ZN7S2217C43v10Ev();
extern void _ZN7S2217C43v11Ev();
extern void _ZN7S2217C43v12Ev();
extern void _ZN7S2217C43v13Ev();
extern void _ZN7S2217C43v14Ev();
extern void _ZN7S2217C43v15Ev();
extern void _ZN7S2217C43v16Ev();
extern void _ZN7S2217C43v17Ev();
extern void _ZN7S2217C43v18Ev();
extern void _ZN7S2217C43v19Ev();
extern void _ZN7S2217C43v20Ev();
extern void _ZN7S2217C43v21Ev();
extern void _ZN7S2217C43v22Ev();
extern void _ZN7S2217C43v23Ev();
extern void _ZN7S2217C43v24Ev();
extern void _ZN7S2217C43v25Ev();
static  VTBL_ENTRY vtc_S2217C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2217C4[0]),
  (VTBL_ENTRY)&_ZN7S2217C4D1Ev,
  (VTBL_ENTRY)&_ZN7S2217C4D0Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v14Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v15Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v18Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v19Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v20Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v21Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v22Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v23Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v24Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v25Ev,
};
extern VTBL_ENTRY _ZTI7S2217C4[];
extern  VTBL_ENTRY _ZTV7S2217C4[];
Class_Descriptor cd_S2217C4 = {  "S2217C4", // class name
  0,0,//no base classes
  &(vtc_S2217C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI7S2217C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2217C4),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2217C3  : S2217C4 {
  ::S1993C15 s2217c3f0;
  ::S1993C15 s2217c3f1;
  ::S1993C15 s2217c3f2;
  ::S1990C13_nt s2217c3f3;
  ::S1990C17_nt s2217c3f4;
  ::S1990C18_nt s2217c3f5;
  ::S1990C18_nt s2217c3f6;
  ::S1993C15 s2217c3f7;
  ::S1993C15 s2217c3f8;
  ::S1993C15 s2217c3f9;
  void *s2217c3f10;
  ::S1990C17_nt s2217c3f11;
  ::S1990C19_nt s2217c3f12;
  int s2217c3f13;
  void *s2217c3f14[7];
  ::S1990C43 s2217c3f15;
  int s2217c3f16:8;
  int s2217c3f17:8;
  int s2217c3f18:16;
  int s2217c3f19:16;
  int s2217c3f20:8;
  int s2217c3f21:8;
  int s2217c3f22:8;
  int s2217c3f23:32;
  int s2217c3f24:8;
  int s2217c3f25:4;
  int s2217c3f26:4;
  int s2217c3f27:4;
  int s2217c3f28:4;
  int s2217c3f29:4;
  int s2217c3f30:4;
  int s2217c3f31:4;
  int s2217c3f32:4;
  int s2217c3f33:4;
  int s2217c3f34:4;
  unsigned char s2217c3f35:1;
  unsigned char s2217c3f36:1;
  unsigned char s2217c3f37:1;
  unsigned char s2217c3f38:1;
  unsigned char s2217c3f39:1;
  unsigned char s2217c3f40:1;
  unsigned char s2217c3f41:1;
  unsigned char s2217c3f42:1;
  unsigned char s2217c3f43:1;
  unsigned char s2217c3f44:1;
  unsigned char s2217c3f45:1;
  unsigned char s2217c3f46:1;
  unsigned char s2217c3f47:1;
  unsigned char s2217c3f48:1;
  unsigned char s2217c3f49:1;
  unsigned char s2217c3f50:1;
  unsigned char s2217c3f51:1;
  unsigned char s2217c3f52:1;
  unsigned char s2217c3f53:1;
  unsigned char s2217c3f54:1;
  unsigned char s2217c3f55:1;
  unsigned char s2217c3f56:1;
  unsigned char s2217c3f57:1;
  unsigned char s2217c3f58:1;
  unsigned char s2217c3f59:1;
  unsigned char s2217c3f60:1;
  unsigned char s2217c3f61:1;
  unsigned char s2217c3f62:1;
  unsigned char s2217c3f63:1;
  unsigned char s2217c3f64:1;
  unsigned char s2217c3f65:1;
  unsigned char s2217c3f66:1;
  unsigned char s2217c3f67:1;
  unsigned char s2217c3f68:1;
  unsigned char s2217c3f69:1;
  unsigned char s2217c3f70:1;
  unsigned char s2217c3f71:1;
  unsigned char s2217c3f72:1;
  unsigned char s2217c3f73:1;
  unsigned char s2217c3f74:1;
  unsigned char s2217c3f75:1;
  int s2217c3f76[7];
  void *s2217c3f77[6];
  int s2217c3f78:8;
  int s2217c3f79:8;
  int s2217c3f80:8;
  int s2217c3f81:8;
  int s2217c3f82:8;
  int s2217c3f83:8;
  ::S1990C25 s2217c3f84;
  void *s2217c3f85[4];
  int s2217c3f86:8;
  int s2217c3f87:8;
  int s2217c3f88:8;
  int s2217c3f89:8;
  int s2217c3f90:8;
  int s2217c3f91:16;
  int s2217c3f92:16;
  int s2217c3f93:16;
  int s2217c3f94:4;
  int s2217c3f95:4;
  int s2217c3f96:4;
  int s2217c3f97:4;
  int s2217c3f98:4;
  int s2217c3f99:4;
  int s2217c3f100:4;
  int s2217c3f101:4;
  int s2217c3f102:4;
  int s2217c3f103:4;
  int s2217c3f104:4;
  int s2217c3f105:4;
  int s2217c3f106:8;
  int s2217c3f107:8;
  int s2217c3f108:8;
  void *s2217c3f109[7];
  ::S1990C46 s2217c3f110;
  void *s2217c3f111[2];
  int s2217c3f112:16;
  int s2217c3f113:16;
  ::S1990C5_nt s2217c3f114;
  ::S1990C37 s2217c3f115;
  ::S1990C29_nt s2217c3f116;
  void *s2217c3f117[2];
  int s2217c3f118:24;
  int s2217c3f119:8;
  void *s2217c3f120;
  virtual  ~S2217C3(); // _ZN7S2217C3D1Ev
  virtual void  v26(); // _ZN7S2217C33v26Ev
  virtual void  v27(); // _ZN7S2217C33v27Ev
  virtual void  v28(); // _ZN7S2217C33v28Ev
  virtual void  v29(); // _ZN7S2217C33v29Ev
  virtual void  v30(); // _ZN7S2217C33v30Ev
  virtual void  v31(); // _ZN7S2217C33v31Ev
  virtual void  v32(); // _ZN7S2217C33v32Ev
  virtual void  v33(); // _ZN7S2217C33v33Ev
  virtual void  v34(); // _ZN7S2217C33v34Ev
  virtual void  v35(); // _ZN7S2217C33v35Ev
  virtual void  v36(); // _ZN7S2217C33v36Ev
  virtual void  v37(); // _ZN7S2217C33v37Ev
  virtual void  v38(); // _ZN7S2217C33v38Ev
  virtual void  v39(); // _ZN7S2217C33v39Ev
  virtual void  v40(); // _ZN7S2217C33v40Ev
  virtual void  v41(); // _ZN7S2217C33v41Ev
  virtual void  v42(); // _ZN7S2217C33v42Ev
  virtual void  v43(); // _ZN7S2217C33v43Ev
  virtual void  v44(); // _ZN7S2217C33v44Ev
  virtual void  v45(); // _ZN7S2217C33v45Ev
  virtual void  v46(); // _ZN7S2217C33v46Ev
  virtual void  v47(); // _ZN7S2217C33v47Ev
  virtual void  v48(); // _ZN7S2217C33v48Ev
  virtual void  v49(); // _ZN7S2217C33v49Ev
  virtual void  v50(); // _ZN7S2217C33v50Ev
  virtual void  v51(); // _ZN7S2217C33v51Ev
  virtual void  v52(); // _ZN7S2217C33v52Ev
  virtual void  v53(); // _ZN7S2217C33v53Ev
  virtual void  v54(); // _ZN7S2217C33v54Ev
  virtual void  v55(); // _ZN7S2217C33v55Ev
  virtual void  v56(); // _ZN7S2217C33v56Ev
  virtual void  v57(); // _ZN7S2217C33v57Ev
  virtual void  v58(); // _ZN7S2217C33v58Ev
  virtual void  v59(); // _ZN7S2217C33v59Ev
  virtual void  v60(); // _ZN7S2217C33v60Ev
  virtual void  v61(); // _ZN7S2217C33v61Ev
  virtual void  v62(); // _ZN7S2217C33v62Ev
  virtual void  v63(); // _ZN7S2217C33v63Ev
  virtual void  v64(); // _ZN7S2217C33v64Ev
  virtual void  v65(); // _ZN7S2217C33v65Ev
  virtual void  v66(); // _ZN7S2217C33v66Ev
  virtual void  v67(); // _ZN7S2217C33v67Ev
  virtual void  v68(); // _ZN7S2217C33v68Ev
  virtual void  v69(); // _ZN7S2217C33v69Ev
  virtual void  v70(); // _ZN7S2217C33v70Ev
  virtual void  v71(); // _ZN7S2217C33v71Ev
  virtual void  v72(); // _ZN7S2217C33v72Ev
  virtual void  v73(); // _ZN7S2217C33v73Ev
  virtual void  v74(); // _ZN7S2217C33v74Ev
  virtual void  v75(); // _ZN7S2217C33v75Ev
  virtual void  v76(); // _ZN7S2217C33v76Ev
  virtual void  v77(); // _ZN7S2217C33v77Ev
  virtual void  v78(); // _ZN7S2217C33v78Ev
  virtual void  v79(); // _ZN7S2217C33v79Ev
  virtual void  v80(); // _ZN7S2217C33v80Ev
  virtual void  v81(); // _ZN7S2217C33v81Ev
  virtual void  v82(); // _ZN7S2217C33v82Ev
  virtual void  v83(); // _ZN7S2217C33v83Ev
  virtual void  v84(); // _ZN7S2217C33v84Ev
  virtual void  v85(); // _ZN7S2217C33v85Ev
  virtual void  v86(); // _ZN7S2217C33v86Ev
  virtual void  v87(); // _ZN7S2217C33v87Ev
  virtual void  v88(); // _ZN7S2217C33v88Ev
  virtual void  v89(); // _ZN7S2217C33v89Ev
  virtual void  v90(); // _ZN7S2217C33v90Ev
  virtual void  v91(); // _ZN7S2217C33v91Ev
  virtual void  v92(); // _ZN7S2217C33v92Ev
  virtual void  v93(); // _ZN7S2217C33v93Ev
  virtual void  v94(); // _ZN7S2217C33v94Ev
  virtual void  v95(); // _ZN7S2217C33v95Ev
  virtual void  v96(); // _ZN7S2217C33v96Ev
  virtual void  v97(); // _ZN7S2217C33v97Ev
  virtual void  v98(); // _ZN7S2217C33v98Ev
  virtual void  v99(); // _ZN7S2217C33v99Ev
  virtual void  v100(); // _ZN7S2217C34v100Ev
  virtual void  v101(); // _ZN7S2217C34v101Ev
  virtual void  v102(); // _ZN7S2217C34v102Ev
  virtual void  v103(); // _ZN7S2217C34v103Ev
  S2217C3(); // tgen
};
//SIG(-1 S2217C3) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fp Fi FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}} FC7{ BC8{ m Fp Fi FC9{ m} FC10{ m}}} Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 FC11{ m FC12{ m FL[2]}} FC11 FC11 FC13{ m FC12} FC14{ m FC13} FC15{ m FC13 FC13 FC13 FC13} FC15 FC11 FC11 FC11 Fp FC14 FC16{ m FC17{ m Fp Fi FC18{ m}} Fi} Fi Fp[7] FC8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC19{ BC4} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC20{ m Fp Fi[2] FC10} Fp[2] Fi:16 Fi:16 FC21{ BC22{ m Fp Fi FC23{ m} FC23}} FC24{ m Fp Fi[2] FC9} FC25{ m Fp Fi[2] FC6} Fp[2] Fi:24 Fi:8 Fp}


 S2217C3 ::~S2217C3(){ note_dtor("S2217C3", this);}
void  S2217C3 ::v26(){vfunc_called(this, "_ZN7S2217C33v26Ev");}
void  S2217C3 ::v27(){vfunc_called(this, "_ZN7S2217C33v27Ev");}
void  S2217C3 ::v28(){vfunc_called(this, "_ZN7S2217C33v28Ev");}
void  S2217C3 ::v29(){vfunc_called(this, "_ZN7S2217C33v29Ev");}
void  S2217C3 ::v30(){vfunc_called(this, "_ZN7S2217C33v30Ev");}
void  S2217C3 ::v31(){vfunc_called(this, "_ZN7S2217C33v31Ev");}
void  S2217C3 ::v32(){vfunc_called(this, "_ZN7S2217C33v32Ev");}
void  S2217C3 ::v33(){vfunc_called(this, "_ZN7S2217C33v33Ev");}
void  S2217C3 ::v34(){vfunc_called(this, "_ZN7S2217C33v34Ev");}
void  S2217C3 ::v35(){vfunc_called(this, "_ZN7S2217C33v35Ev");}
void  S2217C3 ::v36(){vfunc_called(this, "_ZN7S2217C33v36Ev");}
void  S2217C3 ::v37(){vfunc_called(this, "_ZN7S2217C33v37Ev");}
void  S2217C3 ::v38(){vfunc_called(this, "_ZN7S2217C33v38Ev");}
void  S2217C3 ::v39(){vfunc_called(this, "_ZN7S2217C33v39Ev");}
void  S2217C3 ::v40(){vfunc_called(this, "_ZN7S2217C33v40Ev");}
void  S2217C3 ::v41(){vfunc_called(this, "_ZN7S2217C33v41Ev");}
void  S2217C3 ::v42(){vfunc_called(this, "_ZN7S2217C33v42Ev");}
void  S2217C3 ::v43(){vfunc_called(this, "_ZN7S2217C33v43Ev");}
void  S2217C3 ::v44(){vfunc_called(this, "_ZN7S2217C33v44Ev");}
void  S2217C3 ::v45(){vfunc_called(this, "_ZN7S2217C33v45Ev");}
void  S2217C3 ::v46(){vfunc_called(this, "_ZN7S2217C33v46Ev");}
void  S2217C3 ::v47(){vfunc_called(this, "_ZN7S2217C33v47Ev");}
void  S2217C3 ::v48(){vfunc_called(this, "_ZN7S2217C33v48Ev");}
void  S2217C3 ::v49(){vfunc_called(this, "_ZN7S2217C33v49Ev");}
void  S2217C3 ::v50(){vfunc_called(this, "_ZN7S2217C33v50Ev");}
void  S2217C3 ::v51(){vfunc_called(this, "_ZN7S2217C33v51Ev");}
void  S2217C3 ::v52(){vfunc_called(this, "_ZN7S2217C33v52Ev");}
void  S2217C3 ::v53(){vfunc_called(this, "_ZN7S2217C33v53Ev");}
void  S2217C3 ::v54(){vfunc_called(this, "_ZN7S2217C33v54Ev");}
void  S2217C3 ::v55(){vfunc_called(this, "_ZN7S2217C33v55Ev");}
void  S2217C3 ::v56(){vfunc_called(this, "_ZN7S2217C33v56Ev");}
void  S2217C3 ::v57(){vfunc_called(this, "_ZN7S2217C33v57Ev");}
void  S2217C3 ::v58(){vfunc_called(this, "_ZN7S2217C33v58Ev");}
void  S2217C3 ::v59(){vfunc_called(this, "_ZN7S2217C33v59Ev");}
void  S2217C3 ::v60(){vfunc_called(this, "_ZN7S2217C33v60Ev");}
void  S2217C3 ::v61(){vfunc_called(this, "_ZN7S2217C33v61Ev");}
void  S2217C3 ::v62(){vfunc_called(this, "_ZN7S2217C33v62Ev");}
void  S2217C3 ::v63(){vfunc_called(this, "_ZN7S2217C33v63Ev");}
void  S2217C3 ::v64(){vfunc_called(this, "_ZN7S2217C33v64Ev");}
void  S2217C3 ::v65(){vfunc_called(this, "_ZN7S2217C33v65Ev");}
void  S2217C3 ::v66(){vfunc_called(this, "_ZN7S2217C33v66Ev");}
void  S2217C3 ::v67(){vfunc_called(this, "_ZN7S2217C33v67Ev");}
void  S2217C3 ::v68(){vfunc_called(this, "_ZN7S2217C33v68Ev");}
void  S2217C3 ::v69(){vfunc_called(this, "_ZN7S2217C33v69Ev");}
void  S2217C3 ::v70(){vfunc_called(this, "_ZN7S2217C33v70Ev");}
void  S2217C3 ::v71(){vfunc_called(this, "_ZN7S2217C33v71Ev");}
void  S2217C3 ::v72(){vfunc_called(this, "_ZN7S2217C33v72Ev");}
void  S2217C3 ::v73(){vfunc_called(this, "_ZN7S2217C33v73Ev");}
void  S2217C3 ::v74(){vfunc_called(this, "_ZN7S2217C33v74Ev");}
void  S2217C3 ::v75(){vfunc_called(this, "_ZN7S2217C33v75Ev");}
void  S2217C3 ::v76(){vfunc_called(this, "_ZN7S2217C33v76Ev");}
void  S2217C3 ::v77(){vfunc_called(this, "_ZN7S2217C33v77Ev");}
void  S2217C3 ::v78(){vfunc_called(this, "_ZN7S2217C33v78Ev");}
void  S2217C3 ::v79(){vfunc_called(this, "_ZN7S2217C33v79Ev");}
void  S2217C3 ::v80(){vfunc_called(this, "_ZN7S2217C33v80Ev");}
void  S2217C3 ::v81(){vfunc_called(this, "_ZN7S2217C33v81Ev");}
void  S2217C3 ::v82(){vfunc_called(this, "_ZN7S2217C33v82Ev");}
void  S2217C3 ::v83(){vfunc_called(this, "_ZN7S2217C33v83Ev");}
void  S2217C3 ::v84(){vfunc_called(this, "_ZN7S2217C33v84Ev");}
void  S2217C3 ::v85(){vfunc_called(this, "_ZN7S2217C33v85Ev");}
void  S2217C3 ::v86(){vfunc_called(this, "_ZN7S2217C33v86Ev");}
void  S2217C3 ::v87(){vfunc_called(this, "_ZN7S2217C33v87Ev");}
void  S2217C3 ::v88(){vfunc_called(this, "_ZN7S2217C33v88Ev");}
void  S2217C3 ::v89(){vfunc_called(this, "_ZN7S2217C33v89Ev");}
void  S2217C3 ::v90(){vfunc_called(this, "_ZN7S2217C33v90Ev");}
void  S2217C3 ::v91(){vfunc_called(this, "_ZN7S2217C33v91Ev");}
void  S2217C3 ::v92(){vfunc_called(this, "_ZN7S2217C33v92Ev");}
void  S2217C3 ::v93(){vfunc_called(this, "_ZN7S2217C33v93Ev");}
void  S2217C3 ::v94(){vfunc_called(this, "_ZN7S2217C33v94Ev");}
void  S2217C3 ::v95(){vfunc_called(this, "_ZN7S2217C33v95Ev");}
void  S2217C3 ::v96(){vfunc_called(this, "_ZN7S2217C33v96Ev");}
void  S2217C3 ::v97(){vfunc_called(this, "_ZN7S2217C33v97Ev");}
void  S2217C3 ::v98(){vfunc_called(this, "_ZN7S2217C33v98Ev");}
void  S2217C3 ::v99(){vfunc_called(this, "_ZN7S2217C33v99Ev");}
void  S2217C3 ::v100(){vfunc_called(this, "_ZN7S2217C34v100Ev");}
void  S2217C3 ::v101(){vfunc_called(this, "_ZN7S2217C34v101Ev");}
void  S2217C3 ::v102(){vfunc_called(this, "_ZN7S2217C34v102Ev");}
void  S2217C3 ::v103(){vfunc_called(this, "_ZN7S2217C34v103Ev");}
S2217C3 ::S2217C3(){ note_ctor("S2217C3", this);} // tgen

static void Test_S2217C3()
{
  extern Class_Descriptor cd_S2217C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(105,159)];
    init_test(&cd_S2217C3, buf);
    S2217C3 *dp, &lv = *(dp=new (buf) S2217C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(832,632), "sizeof(S2217C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2217C3)");
    check_base_class_offset(lv, (S2217C4*), 0, "S2217C3");
    check_field_offset(lv, s2217c3f0, ABISELECT(64,40), "S2217C3.s2217c3f0");
    check_field_offset(lv, s2217c3f1, ABISELECT(80,56), "S2217C3.s2217c3f1");
    check_field_offset(lv, s2217c3f2, ABISELECT(96,72), "S2217C3.s2217c3f2");
    check_field_offset(lv, s2217c3f3, ABISELECT(112,88), "S2217C3.s2217c3f3");
    check_field_offset(lv, s2217c3f4, ABISELECT(128,104), "S2217C3.s2217c3f4");
    check_field_offset(lv, s2217c3f5, ABISELECT(144,120), "S2217C3.s2217c3f5");
    check_field_offset(lv, s2217c3f6, ABISELECT(208,184), "S2217C3.s2217c3f6");
    check_field_offset(lv, s2217c3f7, ABISELECT(272,248), "S2217C3.s2217c3f7");
    check_field_offset(lv, s2217c3f8, ABISELECT(288,264), "S2217C3.s2217c3f8");
    check_field_offset(lv, s2217c3f9, ABISELECT(304,280), "S2217C3.s2217c3f9");
    check_field_offset(lv, s2217c3f10, ABISELECT(320,296), "S2217C3.s2217c3f10");
    check_field_offset(lv, s2217c3f11, ABISELECT(328,300), "S2217C3.s2217c3f11");
    check_field_offset(lv, s2217c3f12, ABISELECT(344,316), "S2217C3.s2217c3f12");
    check_field_offset(lv, s2217c3f13, ABISELECT(368,332), "S2217C3.s2217c3f13");
    check_field_offset(lv, s2217c3f14, ABISELECT(376,336), "S2217C3.s2217c3f14");
    check_field_offset(lv, s2217c3f15, ABISELECT(432,364), "S2217C3.s2217c3f15");
    set_bf_and_test(lv, s2217c3f16, ABISELECT(448,376), 0, 8, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f16, ABISELECT(448,376), 0, 8, hide_sll(1LL<<7), "S2217C3");
    set_bf_and_test(lv, s2217c3f17, ABISELECT(449,377), 0, 8, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f17, ABISELECT(449,377), 0, 8, hide_sll(1LL<<7), "S2217C3");
    set_bf_and_test(lv, s2217c3f18, ABISELECT(450,378), 0, 16, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f18, ABISELECT(450,378), 0, 16, hide_sll(1LL<<15), "S2217C3");
    set_bf_and_test(lv, s2217c3f19, ABISELECT(452,380), 0, 16, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f19, ABISELECT(452,380), 0, 16, hide_sll(1LL<<15), "S2217C3");
    set_bf_and_test(lv, s2217c3f20, ABISELECT(454,382), 0, 8, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f20, ABISELECT(454,382), 0, 8, hide_sll(1LL<<7), "S2217C3");
    set_bf_and_test(lv, s2217c3f21, ABISELECT(455,383), 0, 8, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f21, ABISELECT(455,383), 0, 8, hide_sll(1LL<<7), "S2217C3");
    set_bf_and_test(lv, s2217c3f22, ABISELECT(456,384), 0, 8, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f22, ABISELECT(456,384), 0, 8, hide_sll(1LL<<7), "S2217C3");
    set_bf_and_test(lv, s2217c3f23, ABISELECT(460,388), 0, 32, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f23, ABISELECT(460,388), 0, 32, hide_sll(1LL<<31), "S2217C3");
    set_bf_and_test(lv, s2217c3f24, ABISELECT(464,392), 0, 8, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f24, ABISELECT(464,392), 0, 8, hide_sll(1LL<<7), "S2217C3");
    set_bf_and_test(lv, s2217c3f25, ABISELECT(465,393), 0, 4, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f25, ABISELECT(465,393), 0, 4, hide_sll(1LL<<3), "S2217C3");
    set_bf_and_test(lv, s2217c3f26, ABISELECT(465,393), 4, 4, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f26, ABISELECT(465,393), 4, 4, hide_sll(1LL<<3), "S2217C3");
    set_bf_and_test(lv, s2217c3f27, ABISELECT(466,394), 0, 4, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f27, ABISELECT(466,394), 0, 4, hide_sll(1LL<<3), "S2217C3");
    set_bf_and_test(lv, s2217c3f28, ABISELECT(466,394), 4, 4, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f28, ABISELECT(466,394), 4, 4, hide_sll(1LL<<3), "S2217C3");
    set_bf_and_test(lv, s2217c3f29, ABISELECT(467,395), 0, 4, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f29, ABISELECT(467,395), 0, 4, hide_sll(1LL<<3), "S2217C3");
    set_bf_and_test(lv, s2217c3f30, ABISELECT(467,395), 4, 4, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f30, ABISELECT(467,395), 4, 4, hide_sll(1LL<<3), "S2217C3");
    set_bf_and_test(lv, s2217c3f31, ABISELECT(468,396), 0, 4, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f31, ABISELECT(468,396), 0, 4, hide_sll(1LL<<3), "S2217C3");
    set_bf_and_test(lv, s2217c3f32, ABISELECT(468,396), 4, 4, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f32, ABISELECT(468,396), 4, 4, hide_sll(1LL<<3), "S2217C3");
    set_bf_and_test(lv, s2217c3f33, ABISELECT(469,397), 0, 4, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f33, ABISELECT(469,397), 0, 4, hide_sll(1LL<<3), "S2217C3");
    set_bf_and_test(lv, s2217c3f34, ABISELECT(469,397), 4, 4, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f34, ABISELECT(469,397), 4, 4, hide_sll(1LL<<3), "S2217C3");
    set_bf_and_test(lv, s2217c3f35, ABISELECT(470,398), 0, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f36, ABISELECT(470,398), 1, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f37, ABISELECT(470,398), 2, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f38, ABISELECT(470,398), 3, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f39, ABISELECT(470,398), 4, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f40, ABISELECT(470,398), 5, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f41, ABISELECT(470,398), 6, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f42, ABISELECT(470,398), 7, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f43, ABISELECT(471,399), 0, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f44, ABISELECT(471,399), 1, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f45, ABISELECT(471,399), 2, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f46, ABISELECT(471,399), 3, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f47, ABISELECT(471,399), 4, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f48, ABISELECT(471,399), 5, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f49, ABISELECT(471,399), 6, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f50, ABISELECT(471,399), 7, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f51, ABISELECT(472,400), 0, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f52, ABISELECT(472,400), 1, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f53, ABISELECT(472,400), 2, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f54, ABISELECT(472,400), 3, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f55, ABISELECT(472,400), 4, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f56, ABISELECT(472,400), 5, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f57, ABISELECT(472,400), 6, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f58, ABISELECT(472,400), 7, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f59, ABISELECT(473,401), 0, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f60, ABISELECT(473,401), 1, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f61, ABISELECT(473,401), 2, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f62, ABISELECT(473,401), 3, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f63, ABISELECT(473,401), 4, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f64, ABISELECT(473,401), 5, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f65, ABISELECT(473,401), 6, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f66, ABISELECT(473,401), 7, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f67, ABISELECT(474,402), 0, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f68, ABISELECT(474,402), 1, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f69, ABISELECT(474,402), 2, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f70, ABISELECT(474,402), 3, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f71, ABISELECT(474,402), 4, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f72, ABISELECT(474,402), 5, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f73, ABISELECT(474,402), 6, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f74, ABISELECT(474,402), 7, 1, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f75, ABISELECT(475,403), 0, 1, 1, "S2217C3");
    check_field_offset(lv, s2217c3f76, ABISELECT(476,404), "S2217C3.s2217c3f76");
    check_field_offset(lv, s2217c3f77, ABISELECT(504,432), "S2217C3.s2217c3f77");
    set_bf_and_test(lv, s2217c3f78, ABISELECT(552,456), 0, 8, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f78, ABISELECT(552,456), 0, 8, hide_sll(1LL<<7), "S2217C3");
    set_bf_and_test(lv, s2217c3f79, ABISELECT(553,457), 0, 8, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f79, ABISELECT(553,457), 0, 8, hide_sll(1LL<<7), "S2217C3");
    set_bf_and_test(lv, s2217c3f80, ABISELECT(554,458), 0, 8, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f80, ABISELECT(554,458), 0, 8, hide_sll(1LL<<7), "S2217C3");
    set_bf_and_test(lv, s2217c3f81, ABISELECT(555,459), 0, 8, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f81, ABISELECT(555,459), 0, 8, hide_sll(1LL<<7), "S2217C3");
    set_bf_and_test(lv, s2217c3f82, ABISELECT(556,460), 0, 8, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f82, ABISELECT(556,460), 0, 8, hide_sll(1LL<<7), "S2217C3");
    set_bf_and_test(lv, s2217c3f83, ABISELECT(557,461), 0, 8, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f83, ABISELECT(557,461), 0, 8, hide_sll(1LL<<7), "S2217C3");
    check_field_offset(lv, s2217c3f84, ABISELECT(560,464), "S2217C3.s2217c3f84");
    check_field_offset(lv, s2217c3f85, ABISELECT(576,476), "S2217C3.s2217c3f85");
    set_bf_and_test(lv, s2217c3f86, ABISELECT(608,492), 0, 8, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f86, ABISELECT(608,492), 0, 8, hide_sll(1LL<<7), "S2217C3");
    set_bf_and_test(lv, s2217c3f87, ABISELECT(609,493), 0, 8, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f87, ABISELECT(609,493), 0, 8, hide_sll(1LL<<7), "S2217C3");
    set_bf_and_test(lv, s2217c3f88, ABISELECT(610,494), 0, 8, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f88, ABISELECT(610,494), 0, 8, hide_sll(1LL<<7), "S2217C3");
    set_bf_and_test(lv, s2217c3f89, ABISELECT(611,495), 0, 8, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f89, ABISELECT(611,495), 0, 8, hide_sll(1LL<<7), "S2217C3");
    set_bf_and_test(lv, s2217c3f90, ABISELECT(612,496), 0, 8, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f90, ABISELECT(612,496), 0, 8, hide_sll(1LL<<7), "S2217C3");
    set_bf_and_test(lv, s2217c3f91, ABISELECT(613,497), 0, 16, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f91, ABISELECT(613,497), 0, 16, hide_sll(1LL<<15), "S2217C3");
    set_bf_and_test(lv, s2217c3f92, ABISELECT(616,500), 0, 16, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f92, ABISELECT(616,500), 0, 16, hide_sll(1LL<<15), "S2217C3");
    set_bf_and_test(lv, s2217c3f93, ABISELECT(618,502), 0, 16, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f93, ABISELECT(618,502), 0, 16, hide_sll(1LL<<15), "S2217C3");
    set_bf_and_test(lv, s2217c3f94, ABISELECT(620,504), 0, 4, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f94, ABISELECT(620,504), 0, 4, hide_sll(1LL<<3), "S2217C3");
    set_bf_and_test(lv, s2217c3f95, ABISELECT(620,504), 4, 4, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f95, ABISELECT(620,504), 4, 4, hide_sll(1LL<<3), "S2217C3");
    set_bf_and_test(lv, s2217c3f96, ABISELECT(621,505), 0, 4, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f96, ABISELECT(621,505), 0, 4, hide_sll(1LL<<3), "S2217C3");
    set_bf_and_test(lv, s2217c3f97, ABISELECT(621,505), 4, 4, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f97, ABISELECT(621,505), 4, 4, hide_sll(1LL<<3), "S2217C3");
    set_bf_and_test(lv, s2217c3f98, ABISELECT(622,506), 0, 4, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f98, ABISELECT(622,506), 0, 4, hide_sll(1LL<<3), "S2217C3");
    set_bf_and_test(lv, s2217c3f99, ABISELECT(622,506), 4, 4, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f99, ABISELECT(622,506), 4, 4, hide_sll(1LL<<3), "S2217C3");
    set_bf_and_test(lv, s2217c3f100, ABISELECT(623,507), 0, 4, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f100, ABISELECT(623,507), 0, 4, hide_sll(1LL<<3), "S2217C3");
    set_bf_and_test(lv, s2217c3f101, ABISELECT(623,507), 4, 4, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f101, ABISELECT(623,507), 4, 4, hide_sll(1LL<<3), "S2217C3");
    set_bf_and_test(lv, s2217c3f102, ABISELECT(624,508), 0, 4, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f102, ABISELECT(624,508), 0, 4, hide_sll(1LL<<3), "S2217C3");
    set_bf_and_test(lv, s2217c3f103, ABISELECT(624,508), 4, 4, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f103, ABISELECT(624,508), 4, 4, hide_sll(1LL<<3), "S2217C3");
    set_bf_and_test(lv, s2217c3f104, ABISELECT(625,509), 0, 4, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f104, ABISELECT(625,509), 0, 4, hide_sll(1LL<<3), "S2217C3");
    set_bf_and_test(lv, s2217c3f105, ABISELECT(625,509), 4, 4, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f105, ABISELECT(625,509), 4, 4, hide_sll(1LL<<3), "S2217C3");
    set_bf_and_test(lv, s2217c3f106, ABISELECT(626,510), 0, 8, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f106, ABISELECT(626,510), 0, 8, hide_sll(1LL<<7), "S2217C3");
    set_bf_and_test(lv, s2217c3f107, ABISELECT(627,511), 0, 8, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f107, ABISELECT(627,511), 0, 8, hide_sll(1LL<<7), "S2217C3");
    set_bf_and_test(lv, s2217c3f108, ABISELECT(628,512), 0, 8, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f108, ABISELECT(628,512), 0, 8, hide_sll(1LL<<7), "S2217C3");
    check_field_offset(lv, s2217c3f109, ABISELECT(632,516), "S2217C3.s2217c3f109");
    check_field_offset(lv, s2217c3f110, ABISELECT(688,544), "S2217C3.s2217c3f110");
    check_field_offset(lv, s2217c3f111, ABISELECT(712,560), "S2217C3.s2217c3f111");
    set_bf_and_test(lv, s2217c3f112, ABISELECT(728,568), 0, 16, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f112, ABISELECT(728,568), 0, 16, hide_sll(1LL<<15), "S2217C3");
    set_bf_and_test(lv, s2217c3f113, ABISELECT(730,570), 0, 16, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f113, ABISELECT(730,570), 0, 16, hide_sll(1LL<<15), "S2217C3");
    check_field_offset(lv, s2217c3f114, ABISELECT(736,572), "S2217C3.s2217c3f114");
    check_field_offset(lv, s2217c3f115, ABISELECT(752,584), "S2217C3.s2217c3f115");
    check_field_offset(lv, s2217c3f116, ABISELECT(776,600), "S2217C3.s2217c3f116");
    check_field_offset(lv, s2217c3f117, ABISELECT(800,616), "S2217C3.s2217c3f117");
    set_bf_and_test(lv, s2217c3f118, ABISELECT(816,624), 0, 24, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f118, ABISELECT(816,624), 0, 24, hide_sll(1LL<<23), "S2217C3");
    set_bf_and_test(lv, s2217c3f119, ABISELECT(819,627), 0, 8, 1, "S2217C3");
    set_bf_and_test(lv, s2217c3f119, ABISELECT(819,627), 0, 8, hide_sll(1LL<<7), "S2217C3");
    check_field_offset(lv, s2217c3f120, ABISELECT(824,628), "S2217C3.s2217c3f120");
    test_class_info(&lv, &cd_S2217C3);
    dp->~S2217C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2217C3(Test_S2217C3, "S2217C3", ABISELECT(832,632));

#else // __cplusplus

extern void _ZN7S2217C3C1Ev();
extern void _ZN7S2217C3D1Ev();
Name_Map name_map_S2217C3[] = {
  NSPAIR(_ZN7S2217C3C1Ev),
  NSPAIR(_ZN7S2217C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2217C4;
extern VTBL_ENTRY _ZTI7S2217C4[];
extern  VTBL_ENTRY _ZTV7S2217C4[];
static Base_Class bases_S2217C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2217C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2217C3[];
extern void _ZN7S2217C3D1Ev();
extern void _ZN7S2217C3D0Ev();
extern void _ZN7S2217C42v3Ev();
extern void _ZN7S2217C42v4Ev();
extern void _ZN7S2217C42v5Ev();
extern void _ZN7S2217C42v6Ev();
extern void _ZN7S2217C42v7Ev();
extern void _ZN7S2217C42v8Ev();
extern void _ZN7S2217C42v9Ev();
extern void _ZN7S2217C43v10Ev();
extern void _ZN7S2217C43v11Ev();
extern void _ZN7S2217C43v12Ev();
extern void _ZN7S2217C43v13Ev();
extern void _ZN7S2217C43v14Ev();
extern void _ZN7S2217C43v15Ev();
extern void _ZN7S2217C43v16Ev();
extern void _ZN7S2217C43v17Ev();
extern void _ZN7S2217C43v18Ev();
extern void _ZN7S2217C43v19Ev();
extern void _ZN7S2217C43v20Ev();
extern void _ZN7S2217C43v21Ev();
extern void _ZN7S2217C43v22Ev();
extern void _ZN7S2217C43v23Ev();
extern void _ZN7S2217C43v24Ev();
extern void _ZN7S2217C43v25Ev();
extern void _ZN7S2217C33v26Ev();
extern void _ZN7S2217C33v27Ev();
extern void _ZN7S2217C33v28Ev();
extern void _ZN7S2217C33v29Ev();
extern void _ZN7S2217C33v30Ev();
extern void _ZN7S2217C33v31Ev();
extern void _ZN7S2217C33v32Ev();
extern void _ZN7S2217C33v33Ev();
extern void _ZN7S2217C33v34Ev();
extern void _ZN7S2217C33v35Ev();
extern void _ZN7S2217C33v36Ev();
extern void _ZN7S2217C33v37Ev();
extern void _ZN7S2217C33v38Ev();
extern void _ZN7S2217C33v39Ev();
extern void _ZN7S2217C33v40Ev();
extern void _ZN7S2217C33v41Ev();
extern void _ZN7S2217C33v42Ev();
extern void _ZN7S2217C33v43Ev();
extern void _ZN7S2217C33v44Ev();
extern void _ZN7S2217C33v45Ev();
extern void _ZN7S2217C33v46Ev();
extern void _ZN7S2217C33v47Ev();
extern void _ZN7S2217C33v48Ev();
extern void _ZN7S2217C33v49Ev();
extern void _ZN7S2217C33v50Ev();
extern void _ZN7S2217C33v51Ev();
extern void _ZN7S2217C33v52Ev();
extern void _ZN7S2217C33v53Ev();
extern void _ZN7S2217C33v54Ev();
extern void _ZN7S2217C33v55Ev();
extern void _ZN7S2217C33v56Ev();
extern void _ZN7S2217C33v57Ev();
extern void _ZN7S2217C33v58Ev();
extern void _ZN7S2217C33v59Ev();
extern void _ZN7S2217C33v60Ev();
extern void _ZN7S2217C33v61Ev();
extern void _ZN7S2217C33v62Ev();
extern void _ZN7S2217C33v63Ev();
extern void _ZN7S2217C33v64Ev();
extern void _ZN7S2217C33v65Ev();
extern void _ZN7S2217C33v66Ev();
extern void _ZN7S2217C33v67Ev();
extern void _ZN7S2217C33v68Ev();
extern void _ZN7S2217C33v69Ev();
extern void _ZN7S2217C33v70Ev();
extern void _ZN7S2217C33v71Ev();
extern void _ZN7S2217C33v72Ev();
extern void _ZN7S2217C33v73Ev();
extern void _ZN7S2217C33v74Ev();
extern void _ZN7S2217C33v75Ev();
extern void _ZN7S2217C33v76Ev();
extern void _ZN7S2217C33v77Ev();
extern void _ZN7S2217C33v78Ev();
extern void _ZN7S2217C33v79Ev();
extern void _ZN7S2217C33v80Ev();
extern void _ZN7S2217C33v81Ev();
extern void _ZN7S2217C33v82Ev();
extern void _ZN7S2217C33v83Ev();
extern void _ZN7S2217C33v84Ev();
extern void _ZN7S2217C33v85Ev();
extern void _ZN7S2217C33v86Ev();
extern void _ZN7S2217C33v87Ev();
extern void _ZN7S2217C33v88Ev();
extern void _ZN7S2217C33v89Ev();
extern void _ZN7S2217C33v90Ev();
extern void _ZN7S2217C33v91Ev();
extern void _ZN7S2217C33v92Ev();
extern void _ZN7S2217C33v93Ev();
extern void _ZN7S2217C33v94Ev();
extern void _ZN7S2217C33v95Ev();
extern void _ZN7S2217C33v96Ev();
extern void _ZN7S2217C33v97Ev();
extern void _ZN7S2217C33v98Ev();
extern void _ZN7S2217C33v99Ev();
extern void _ZN7S2217C34v100Ev();
extern void _ZN7S2217C34v101Ev();
extern void _ZN7S2217C34v102Ev();
extern void _ZN7S2217C34v103Ev();
static  VTBL_ENTRY vtc_S2217C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2217C3[0]),
  (VTBL_ENTRY)&_ZN7S2217C3D1Ev,
  (VTBL_ENTRY)&_ZN7S2217C3D0Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v14Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v15Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v18Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v19Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v20Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v21Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v22Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v23Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v24Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v25Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v26Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v27Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v28Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v29Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v30Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v31Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v32Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v33Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v34Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v35Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v36Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v37Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v38Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v39Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v40Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v41Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v42Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v43Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v44Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v45Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v46Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v47Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v48Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v49Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v50Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v51Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v52Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v53Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v54Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v55Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v56Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v57Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v58Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v59Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v60Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v61Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v62Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v63Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v64Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v65Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v66Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v67Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v68Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v69Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v70Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v71Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v72Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v73Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v74Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v75Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v76Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v77Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v78Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v79Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v80Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v81Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v82Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v83Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v84Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v85Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v86Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v87Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v88Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v89Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v90Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v91Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v92Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v93Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v94Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v95Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v96Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v97Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v98Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v99Ev,
  (VTBL_ENTRY)&_ZN7S2217C34v100Ev,
  (VTBL_ENTRY)&_ZN7S2217C34v101Ev,
  (VTBL_ENTRY)&_ZN7S2217C34v102Ev,
  (VTBL_ENTRY)&_ZN7S2217C34v103Ev,
};
extern VTBL_ENTRY _ZTI7S2217C3[];
extern  VTBL_ENTRY _ZTV7S2217C3[];
Class_Descriptor cd_S2217C3 = {  "S2217C3", // class name
  bases_S2217C3, 1,
  &(vtc_S2217C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI7S2217C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2217C3),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2217C2  : S2217C3 {
  void *s2217c2f0;
  char s2217c2f1;
  ::S1990C39_nt s2217c2f2;
  ::S1990C19_nt s2217c2f3;
  virtual  ~S2217C2(); // _ZN7S2217C2D1Ev
  virtual void  v104(); // _ZN7S2217C24v104Ev
  virtual void  v105(); // _ZN7S2217C24v105Ev
  virtual void  v106(); // _ZN7S2217C24v106Ev
  virtual void  v107(); // _ZN7S2217C24v107Ev
  virtual void  v108(); // _ZN7S2217C24v108Ev
  virtual void  v109(); // _ZN7S2217C24v109Ev
  virtual void  v110(); // _ZN7S2217C24v110Ev
  virtual void  v111(); // _ZN7S2217C24v111Ev
  virtual void  v112(); // _ZN7S2217C24v112Ev
  S2217C2(); // tgen
};
//SIG(-1 S2217C2) C1{ BC2{ BC3{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 Fp Fi FC4{ BC5{ m Fp Fi FC6{ m} FC7{ m}}} FC8{ BC9{ m Fp Fi FC10{ m} FC11{ m}}} Fi} vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 FC12{ m FC13{ m FL[2]}} FC12 FC12 FC14{ m FC13} FC15{ m FC14} FC16{ m FC14 FC14 FC14 FC14} FC16 FC12 FC12 FC12 Fp FC15 FC17{ m FC18{ m Fp Fi FC19{ m}} Fi} Fi Fp[7] FC9 Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC20{ BC5} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC21{ m Fp Fi[2] FC11} Fp[2] Fi:16 Fi:16 FC22{ BC23{ m Fp Fi FC24{ m} FC24}} FC25{ m Fp Fi[2] FC10} FC26{ m Fp Fi[2] FC7} Fp[2] Fi:24 Fi:8 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fp Fc FC27{ m FC25 FC8 FC21 FC8} FC17}


 S2217C2 ::~S2217C2(){ note_dtor("S2217C2", this);}
void  S2217C2 ::v104(){vfunc_called(this, "_ZN7S2217C24v104Ev");}
void  S2217C2 ::v105(){vfunc_called(this, "_ZN7S2217C24v105Ev");}
void  S2217C2 ::v106(){vfunc_called(this, "_ZN7S2217C24v106Ev");}
void  S2217C2 ::v107(){vfunc_called(this, "_ZN7S2217C24v107Ev");}
void  S2217C2 ::v108(){vfunc_called(this, "_ZN7S2217C24v108Ev");}
void  S2217C2 ::v109(){vfunc_called(this, "_ZN7S2217C24v109Ev");}
void  S2217C2 ::v110(){vfunc_called(this, "_ZN7S2217C24v110Ev");}
void  S2217C2 ::v111(){vfunc_called(this, "_ZN7S2217C24v111Ev");}
void  S2217C2 ::v112(){vfunc_called(this, "_ZN7S2217C24v112Ev");}
S2217C2 ::S2217C2(){ note_ctor("S2217C2", this);} // tgen

static void Test_S2217C2()
{
  extern Class_Descriptor cd_S2217C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(120,179)];
    init_test(&cd_S2217C2, buf);
    S2217C2 *dp, &lv = *(dp=new (buf) S2217C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(952,712), "sizeof(S2217C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2217C2)");
    check_base_class_offset(lv, (S2217C4*)(S2217C3*), 0, "S2217C2");
    check_base_class_offset(lv, (S2217C3*), 0, "S2217C2");
    check_field_offset(lv, s2217c2f0, ABISELECT(832,632), "S2217C2.s2217c2f0");
    check_field_offset(lv, s2217c2f1, ABISELECT(840,636), "S2217C2.s2217c2f1");
    check_field_offset(lv, s2217c2f2, ABISELECT(848,640), "S2217C2.s2217c2f2");
    check_field_offset(lv, s2217c2f3, ABISELECT(928,696), "S2217C2.s2217c2f3");
    test_class_info(&lv, &cd_S2217C2);
    dp->~S2217C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2217C2(Test_S2217C2, "S2217C2", ABISELECT(952,712));

#else // __cplusplus

extern void _ZN7S2217C2C1Ev();
extern void _ZN7S2217C2D1Ev();
Name_Map name_map_S2217C2[] = {
  NSPAIR(_ZN7S2217C2C1Ev),
  NSPAIR(_ZN7S2217C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2217C4;
extern VTBL_ENTRY _ZTI7S2217C4[];
extern  VTBL_ENTRY _ZTV7S2217C4[];
extern Class_Descriptor cd_S2217C3;
extern VTBL_ENTRY _ZTI7S2217C3[];
extern  VTBL_ENTRY _ZTV7S2217C3[];
static Base_Class bases_S2217C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2217C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2217C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2217C2[];
extern void _ZN7S2217C2D1Ev();
extern void _ZN7S2217C2D0Ev();
extern void _ZN7S2217C42v3Ev();
extern void _ZN7S2217C42v4Ev();
extern void _ZN7S2217C42v5Ev();
extern void _ZN7S2217C42v6Ev();
extern void _ZN7S2217C42v7Ev();
extern void _ZN7S2217C42v8Ev();
extern void _ZN7S2217C42v9Ev();
extern void _ZN7S2217C43v10Ev();
extern void _ZN7S2217C43v11Ev();
extern void _ZN7S2217C43v12Ev();
extern void _ZN7S2217C43v13Ev();
extern void _ZN7S2217C43v14Ev();
extern void _ZN7S2217C43v15Ev();
extern void _ZN7S2217C43v16Ev();
extern void _ZN7S2217C43v17Ev();
extern void _ZN7S2217C43v18Ev();
extern void _ZN7S2217C43v19Ev();
extern void _ZN7S2217C43v20Ev();
extern void _ZN7S2217C43v21Ev();
extern void _ZN7S2217C43v22Ev();
extern void _ZN7S2217C43v23Ev();
extern void _ZN7S2217C43v24Ev();
extern void _ZN7S2217C43v25Ev();
extern void _ZN7S2217C33v26Ev();
extern void _ZN7S2217C33v27Ev();
extern void _ZN7S2217C33v28Ev();
extern void _ZN7S2217C33v29Ev();
extern void _ZN7S2217C33v30Ev();
extern void _ZN7S2217C33v31Ev();
extern void _ZN7S2217C33v32Ev();
extern void _ZN7S2217C33v33Ev();
extern void _ZN7S2217C33v34Ev();
extern void _ZN7S2217C33v35Ev();
extern void _ZN7S2217C33v36Ev();
extern void _ZN7S2217C33v37Ev();
extern void _ZN7S2217C33v38Ev();
extern void _ZN7S2217C33v39Ev();
extern void _ZN7S2217C33v40Ev();
extern void _ZN7S2217C33v41Ev();
extern void _ZN7S2217C33v42Ev();
extern void _ZN7S2217C33v43Ev();
extern void _ZN7S2217C33v44Ev();
extern void _ZN7S2217C33v45Ev();
extern void _ZN7S2217C33v46Ev();
extern void _ZN7S2217C33v47Ev();
extern void _ZN7S2217C33v48Ev();
extern void _ZN7S2217C33v49Ev();
extern void _ZN7S2217C33v50Ev();
extern void _ZN7S2217C33v51Ev();
extern void _ZN7S2217C33v52Ev();
extern void _ZN7S2217C33v53Ev();
extern void _ZN7S2217C33v54Ev();
extern void _ZN7S2217C33v55Ev();
extern void _ZN7S2217C33v56Ev();
extern void _ZN7S2217C33v57Ev();
extern void _ZN7S2217C33v58Ev();
extern void _ZN7S2217C33v59Ev();
extern void _ZN7S2217C33v60Ev();
extern void _ZN7S2217C33v61Ev();
extern void _ZN7S2217C33v62Ev();
extern void _ZN7S2217C33v63Ev();
extern void _ZN7S2217C33v64Ev();
extern void _ZN7S2217C33v65Ev();
extern void _ZN7S2217C33v66Ev();
extern void _ZN7S2217C33v67Ev();
extern void _ZN7S2217C33v68Ev();
extern void _ZN7S2217C33v69Ev();
extern void _ZN7S2217C33v70Ev();
extern void _ZN7S2217C33v71Ev();
extern void _ZN7S2217C33v72Ev();
extern void _ZN7S2217C33v73Ev();
extern void _ZN7S2217C33v74Ev();
extern void _ZN7S2217C33v75Ev();
extern void _ZN7S2217C33v76Ev();
extern void _ZN7S2217C33v77Ev();
extern void _ZN7S2217C33v78Ev();
extern void _ZN7S2217C33v79Ev();
extern void _ZN7S2217C33v80Ev();
extern void _ZN7S2217C33v81Ev();
extern void _ZN7S2217C33v82Ev();
extern void _ZN7S2217C33v83Ev();
extern void _ZN7S2217C33v84Ev();
extern void _ZN7S2217C33v85Ev();
extern void _ZN7S2217C33v86Ev();
extern void _ZN7S2217C33v87Ev();
extern void _ZN7S2217C33v88Ev();
extern void _ZN7S2217C33v89Ev();
extern void _ZN7S2217C33v90Ev();
extern void _ZN7S2217C33v91Ev();
extern void _ZN7S2217C33v92Ev();
extern void _ZN7S2217C33v93Ev();
extern void _ZN7S2217C33v94Ev();
extern void _ZN7S2217C33v95Ev();
extern void _ZN7S2217C33v96Ev();
extern void _ZN7S2217C33v97Ev();
extern void _ZN7S2217C33v98Ev();
extern void _ZN7S2217C33v99Ev();
extern void _ZN7S2217C34v100Ev();
extern void _ZN7S2217C34v101Ev();
extern void _ZN7S2217C34v102Ev();
extern void _ZN7S2217C34v103Ev();
extern void _ZN7S2217C24v104Ev();
extern void _ZN7S2217C24v105Ev();
extern void _ZN7S2217C24v106Ev();
extern void _ZN7S2217C24v107Ev();
extern void _ZN7S2217C24v108Ev();
extern void _ZN7S2217C24v109Ev();
extern void _ZN7S2217C24v110Ev();
extern void _ZN7S2217C24v111Ev();
extern void _ZN7S2217C24v112Ev();
static  VTBL_ENTRY vtc_S2217C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2217C2[0]),
  (VTBL_ENTRY)&_ZN7S2217C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2217C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v14Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v15Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v18Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v19Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v20Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v21Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v22Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v23Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v24Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v25Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v26Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v27Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v28Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v29Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v30Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v31Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v32Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v33Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v34Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v35Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v36Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v37Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v38Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v39Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v40Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v41Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v42Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v43Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v44Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v45Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v46Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v47Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v48Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v49Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v50Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v51Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v52Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v53Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v54Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v55Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v56Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v57Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v58Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v59Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v60Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v61Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v62Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v63Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v64Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v65Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v66Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v67Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v68Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v69Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v70Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v71Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v72Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v73Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v74Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v75Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v76Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v77Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v78Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v79Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v80Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v81Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v82Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v83Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v84Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v85Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v86Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v87Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v88Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v89Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v90Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v91Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v92Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v93Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v94Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v95Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v96Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v97Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v98Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v99Ev,
  (VTBL_ENTRY)&_ZN7S2217C34v100Ev,
  (VTBL_ENTRY)&_ZN7S2217C34v101Ev,
  (VTBL_ENTRY)&_ZN7S2217C34v102Ev,
  (VTBL_ENTRY)&_ZN7S2217C34v103Ev,
  (VTBL_ENTRY)&_ZN7S2217C24v104Ev,
  (VTBL_ENTRY)&_ZN7S2217C24v105Ev,
  (VTBL_ENTRY)&_ZN7S2217C24v106Ev,
  (VTBL_ENTRY)&_ZN7S2217C24v107Ev,
  (VTBL_ENTRY)&_ZN7S2217C24v108Ev,
  (VTBL_ENTRY)&_ZN7S2217C24v109Ev,
  (VTBL_ENTRY)&_ZN7S2217C24v110Ev,
  (VTBL_ENTRY)&_ZN7S2217C24v111Ev,
  (VTBL_ENTRY)&_ZN7S2217C24v112Ev,
};
extern VTBL_ENTRY _ZTI7S2217C2[];
extern  VTBL_ENTRY _ZTV7S2217C2[];
Class_Descriptor cd_S2217C2 = {  "S2217C2", // class name
  bases_S2217C2, 2,
  &(vtc_S2217C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(952,712), // object size
  NSPAIRA(_ZTI7S2217C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2217C2),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2217C1  : S2217C2 {
  void *s2217c1f0;
  virtual  ~S2217C1(); // _ZN7S2217C1D1Ev
  virtual void  v1(); // _ZN7S2217C12v1Ev
  virtual void  v2(); // _ZN7S2217C12v2Ev
  S2217C1(); // tgen
};
//SIG(1 S2217C1) C1{ BC2{ BC3{ BC4{ vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 Fp Fi FC5{ BC6{ m Fp Fi FC7{ m} FC8{ m}}} FC9{ BC10{ m Fp Fi FC11{ m} FC12{ m}}} Fi} vd v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 FC13{ m FC14{ m FL[2]}} FC13 FC13 FC15{ m FC14} FC16{ m FC15} FC17{ m FC15 FC15 FC15 FC15} FC17 FC13 FC13 FC13 Fp FC16 FC18{ m FC19{ m Fp Fi FC20{ m}} Fi} Fi Fp[7] FC10 Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC21{ BC6} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC22{ m Fp Fi[2] FC12} Fp[2] Fi:16 Fi:16 FC23{ BC24{ m Fp Fi FC25{ m} FC25}} FC26{ m Fp Fi[2] FC11} FC27{ m Fp Fi[2] FC8} Fp[2] Fi:24 Fi:8 Fp} vd v104 v105 v106 v107 v108 v109 v110 v111 v112 Fp Fc FC28{ m FC26 FC9 FC22 FC9} FC18} vd v1 v2 Fp}


 S2217C1 ::~S2217C1(){ note_dtor("S2217C1", this);}
void  S2217C1 ::v1(){vfunc_called(this, "_ZN7S2217C12v1Ev");}
void  S2217C1 ::v2(){vfunc_called(this, "_ZN7S2217C12v2Ev");}
S2217C1 ::S2217C1(){ note_ctor("S2217C1", this);} // tgen

static void Test_S2217C1()
{
  extern Class_Descriptor cd_S2217C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(121,180)];
    init_test(&cd_S2217C1, buf);
    S2217C1 *dp, &lv = *(dp=new (buf) S2217C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(960,716), "sizeof(S2217C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2217C1)");
    check_base_class_offset(lv, (S2217C4*)(S2217C3*)(S2217C2*), 0, "S2217C1");
    check_base_class_offset(lv, (S2217C3*)(S2217C2*), 0, "S2217C1");
    check_base_class_offset(lv, (S2217C2*), 0, "S2217C1");
    check_field_offset(lv, s2217c1f0, ABISELECT(952,712), "S2217C1.s2217c1f0");
    test_class_info(&lv, &cd_S2217C1);
    dp->~S2217C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2217C1(Test_S2217C1, "S2217C1", ABISELECT(960,716));

#else // __cplusplus

extern void _ZN7S2217C1C1Ev();
extern void _ZN7S2217C1D1Ev();
Name_Map name_map_S2217C1[] = {
  NSPAIR(_ZN7S2217C1C1Ev),
  NSPAIR(_ZN7S2217C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2217C4;
extern VTBL_ENTRY _ZTI7S2217C4[];
extern  VTBL_ENTRY _ZTV7S2217C4[];
extern Class_Descriptor cd_S2217C3;
extern VTBL_ENTRY _ZTI7S2217C3[];
extern  VTBL_ENTRY _ZTV7S2217C3[];
extern Class_Descriptor cd_S2217C2;
extern VTBL_ENTRY _ZTI7S2217C2[];
extern  VTBL_ENTRY _ZTV7S2217C2[];
static Base_Class bases_S2217C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2217C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2217C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2217C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2217C1[];
extern void _ZN7S2217C1D1Ev();
extern void _ZN7S2217C1D0Ev();
extern void _ZN7S2217C42v3Ev();
extern void _ZN7S2217C42v4Ev();
extern void _ZN7S2217C42v5Ev();
extern void _ZN7S2217C42v6Ev();
extern void _ZN7S2217C42v7Ev();
extern void _ZN7S2217C42v8Ev();
extern void _ZN7S2217C42v9Ev();
extern void _ZN7S2217C43v10Ev();
extern void _ZN7S2217C43v11Ev();
extern void _ZN7S2217C43v12Ev();
extern void _ZN7S2217C43v13Ev();
extern void _ZN7S2217C43v14Ev();
extern void _ZN7S2217C43v15Ev();
extern void _ZN7S2217C43v16Ev();
extern void _ZN7S2217C43v17Ev();
extern void _ZN7S2217C43v18Ev();
extern void _ZN7S2217C43v19Ev();
extern void _ZN7S2217C43v20Ev();
extern void _ZN7S2217C43v21Ev();
extern void _ZN7S2217C43v22Ev();
extern void _ZN7S2217C43v23Ev();
extern void _ZN7S2217C43v24Ev();
extern void _ZN7S2217C43v25Ev();
extern void _ZN7S2217C33v26Ev();
extern void _ZN7S2217C33v27Ev();
extern void _ZN7S2217C33v28Ev();
extern void _ZN7S2217C33v29Ev();
extern void _ZN7S2217C33v30Ev();
extern void _ZN7S2217C33v31Ev();
extern void _ZN7S2217C33v32Ev();
extern void _ZN7S2217C33v33Ev();
extern void _ZN7S2217C33v34Ev();
extern void _ZN7S2217C33v35Ev();
extern void _ZN7S2217C33v36Ev();
extern void _ZN7S2217C33v37Ev();
extern void _ZN7S2217C33v38Ev();
extern void _ZN7S2217C33v39Ev();
extern void _ZN7S2217C33v40Ev();
extern void _ZN7S2217C33v41Ev();
extern void _ZN7S2217C33v42Ev();
extern void _ZN7S2217C33v43Ev();
extern void _ZN7S2217C33v44Ev();
extern void _ZN7S2217C33v45Ev();
extern void _ZN7S2217C33v46Ev();
extern void _ZN7S2217C33v47Ev();
extern void _ZN7S2217C33v48Ev();
extern void _ZN7S2217C33v49Ev();
extern void _ZN7S2217C33v50Ev();
extern void _ZN7S2217C33v51Ev();
extern void _ZN7S2217C33v52Ev();
extern void _ZN7S2217C33v53Ev();
extern void _ZN7S2217C33v54Ev();
extern void _ZN7S2217C33v55Ev();
extern void _ZN7S2217C33v56Ev();
extern void _ZN7S2217C33v57Ev();
extern void _ZN7S2217C33v58Ev();
extern void _ZN7S2217C33v59Ev();
extern void _ZN7S2217C33v60Ev();
extern void _ZN7S2217C33v61Ev();
extern void _ZN7S2217C33v62Ev();
extern void _ZN7S2217C33v63Ev();
extern void _ZN7S2217C33v64Ev();
extern void _ZN7S2217C33v65Ev();
extern void _ZN7S2217C33v66Ev();
extern void _ZN7S2217C33v67Ev();
extern void _ZN7S2217C33v68Ev();
extern void _ZN7S2217C33v69Ev();
extern void _ZN7S2217C33v70Ev();
extern void _ZN7S2217C33v71Ev();
extern void _ZN7S2217C33v72Ev();
extern void _ZN7S2217C33v73Ev();
extern void _ZN7S2217C33v74Ev();
extern void _ZN7S2217C33v75Ev();
extern void _ZN7S2217C33v76Ev();
extern void _ZN7S2217C33v77Ev();
extern void _ZN7S2217C33v78Ev();
extern void _ZN7S2217C33v79Ev();
extern void _ZN7S2217C33v80Ev();
extern void _ZN7S2217C33v81Ev();
extern void _ZN7S2217C33v82Ev();
extern void _ZN7S2217C33v83Ev();
extern void _ZN7S2217C33v84Ev();
extern void _ZN7S2217C33v85Ev();
extern void _ZN7S2217C33v86Ev();
extern void _ZN7S2217C33v87Ev();
extern void _ZN7S2217C33v88Ev();
extern void _ZN7S2217C33v89Ev();
extern void _ZN7S2217C33v90Ev();
extern void _ZN7S2217C33v91Ev();
extern void _ZN7S2217C33v92Ev();
extern void _ZN7S2217C33v93Ev();
extern void _ZN7S2217C33v94Ev();
extern void _ZN7S2217C33v95Ev();
extern void _ZN7S2217C33v96Ev();
extern void _ZN7S2217C33v97Ev();
extern void _ZN7S2217C33v98Ev();
extern void _ZN7S2217C33v99Ev();
extern void _ZN7S2217C34v100Ev();
extern void _ZN7S2217C34v101Ev();
extern void _ZN7S2217C34v102Ev();
extern void _ZN7S2217C34v103Ev();
extern void _ZN7S2217C24v104Ev();
extern void _ZN7S2217C24v105Ev();
extern void _ZN7S2217C24v106Ev();
extern void _ZN7S2217C24v107Ev();
extern void _ZN7S2217C24v108Ev();
extern void _ZN7S2217C24v109Ev();
extern void _ZN7S2217C24v110Ev();
extern void _ZN7S2217C24v111Ev();
extern void _ZN7S2217C24v112Ev();
extern void _ZN7S2217C12v1Ev();
extern void _ZN7S2217C12v2Ev();
static  VTBL_ENTRY vtc_S2217C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2217C1[0]),
  (VTBL_ENTRY)&_ZN7S2217C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2217C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v3Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v4Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v5Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v6Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v7Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v8Ev,
  (VTBL_ENTRY)&_ZN7S2217C42v9Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v10Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v11Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v12Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v13Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v14Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v15Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v16Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v17Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v18Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v19Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v20Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v21Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v22Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v23Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v24Ev,
  (VTBL_ENTRY)&_ZN7S2217C43v25Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v26Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v27Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v28Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v29Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v30Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v31Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v32Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v33Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v34Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v35Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v36Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v37Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v38Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v39Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v40Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v41Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v42Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v43Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v44Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v45Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v46Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v47Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v48Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v49Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v50Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v51Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v52Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v53Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v54Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v55Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v56Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v57Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v58Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v59Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v60Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v61Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v62Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v63Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v64Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v65Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v66Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v67Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v68Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v69Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v70Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v71Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v72Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v73Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v74Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v75Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v76Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v77Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v78Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v79Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v80Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v81Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v82Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v83Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v84Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v85Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v86Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v87Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v88Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v89Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v90Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v91Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v92Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v93Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v94Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v95Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v96Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v97Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v98Ev,
  (VTBL_ENTRY)&_ZN7S2217C33v99Ev,
  (VTBL_ENTRY)&_ZN7S2217C34v100Ev,
  (VTBL_ENTRY)&_ZN7S2217C34v101Ev,
  (VTBL_ENTRY)&_ZN7S2217C34v102Ev,
  (VTBL_ENTRY)&_ZN7S2217C34v103Ev,
  (VTBL_ENTRY)&_ZN7S2217C24v104Ev,
  (VTBL_ENTRY)&_ZN7S2217C24v105Ev,
  (VTBL_ENTRY)&_ZN7S2217C24v106Ev,
  (VTBL_ENTRY)&_ZN7S2217C24v107Ev,
  (VTBL_ENTRY)&_ZN7S2217C24v108Ev,
  (VTBL_ENTRY)&_ZN7S2217C24v109Ev,
  (VTBL_ENTRY)&_ZN7S2217C24v110Ev,
  (VTBL_ENTRY)&_ZN7S2217C24v111Ev,
  (VTBL_ENTRY)&_ZN7S2217C24v112Ev,
  (VTBL_ENTRY)&_ZN7S2217C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2217C12v2Ev,
};
extern VTBL_ENTRY _ZTI7S2217C1[];
extern  VTBL_ENTRY _ZTV7S2217C1[];
Class_Descriptor cd_S2217C1 = {  "S2217C1", // class name
  bases_S2217C1, 3,
  &(vtc_S2217C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(960,716), // object size
  NSPAIRA(_ZTI7S2217C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2217C1),116, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1996C4  {
  void *s1996c4f0;
  int s1996c4f1;
  ::S1993C31 s1996c4f2;
  ::S1990C42 s1996c4f3;
  int s1996c4f4;
  virtual  ~S1996C4(); // _ZN7S1996C4D1Ev
  virtual void  v1(); // _ZN7S1996C42v1Ev
  virtual void  v2(); // _ZN7S1996C42v2Ev
  virtual void  v3(); // _ZN7S1996C42v3Ev
  virtual void  v4(); // _ZN7S1996C42v4Ev
  virtual void  v5(); // _ZN7S1996C42v5Ev
  virtual void  v6(); // _ZN7S1996C42v6Ev
  virtual void  v7(); // _ZN7S1996C42v7Ev
  virtual void  v8(); // _ZN7S1996C42v8Ev
  virtual void  v9(); // _ZN7S1996C42v9Ev
  virtual void  v10(); // _ZN7S1996C43v10Ev
  virtual void  v11(); // _ZN7S1996C43v11Ev
  virtual void  v12(); // _ZN7S1996C43v12Ev
  virtual void  v13(); // _ZN7S1996C43v13Ev
  virtual void  v14(); // _ZN7S1996C43v14Ev
  virtual void  v15(); // _ZN7S1996C43v15Ev
  virtual void  v16(); // _ZN7S1996C43v16Ev
  virtual void  v17(); // _ZN7S1996C43v17Ev
  virtual void  v18(); // _ZN7S1996C43v18Ev
  virtual void  v19(); // _ZN7S1996C43v19Ev
  virtual void  v20(); // _ZN7S1996C43v20Ev
  virtual void  v21(); // _ZN7S1996C43v21Ev
  virtual void  v22(); // _ZN7S1996C43v22Ev
  virtual void  v23(); // _ZN7S1996C43v23Ev
  S1996C4(); // tgen
};
//SIG(-1 S1996C4) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}} FC6{ BC7{ m Fp Fi FC8{ m} FC9{ m}}} Fi}


 S1996C4 ::~S1996C4(){ note_dtor("S1996C4", this);}
void  S1996C4 ::v1(){vfunc_called(this, "_ZN7S1996C42v1Ev");}
void  S1996C4 ::v2(){vfunc_called(this, "_ZN7S1996C42v2Ev");}
void  S1996C4 ::v3(){vfunc_called(this, "_ZN7S1996C42v3Ev");}
void  S1996C4 ::v4(){vfunc_called(this, "_ZN7S1996C42v4Ev");}
void  S1996C4 ::v5(){vfunc_called(this, "_ZN7S1996C42v5Ev");}
void  S1996C4 ::v6(){vfunc_called(this, "_ZN7S1996C42v6Ev");}
void  S1996C4 ::v7(){vfunc_called(this, "_ZN7S1996C42v7Ev");}
void  S1996C4 ::v8(){vfunc_called(this, "_ZN7S1996C42v8Ev");}
void  S1996C4 ::v9(){vfunc_called(this, "_ZN7S1996C42v9Ev");}
void  S1996C4 ::v10(){vfunc_called(this, "_ZN7S1996C43v10Ev");}
void  S1996C4 ::v11(){vfunc_called(this, "_ZN7S1996C43v11Ev");}
void  S1996C4 ::v12(){vfunc_called(this, "_ZN7S1996C43v12Ev");}
void  S1996C4 ::v13(){vfunc_called(this, "_ZN7S1996C43v13Ev");}
void  S1996C4 ::v14(){vfunc_called(this, "_ZN7S1996C43v14Ev");}
void  S1996C4 ::v15(){vfunc_called(this, "_ZN7S1996C43v15Ev");}
void  S1996C4 ::v16(){vfunc_called(this, "_ZN7S1996C43v16Ev");}
void  S1996C4 ::v17(){vfunc_called(this, "_ZN7S1996C43v17Ev");}
void  S1996C4 ::v18(){vfunc_called(this, "_ZN7S1996C43v18Ev");}
void  S1996C4 ::v19(){vfunc_called(this, "_ZN7S1996C43v19Ev");}
void  S1996C4 ::v20(){vfunc_called(this, "_ZN7S1996C43v20Ev");}
void  S1996C4 ::v21(){vfunc_called(this, "_ZN7S1996C43v21Ev");}
void  S1996C4 ::v22(){vfunc_called(this, "_ZN7S1996C43v22Ev");}
void  S1996C4 ::v23(){vfunc_called(this, "_ZN7S1996C43v23Ev");}
S1996C4 ::S1996C4(){ note_ctor("S1996C4", this);} // tgen

static void Test_S1996C4()
{
  extern Class_Descriptor cd_S1996C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_S1996C4, buf);
    S1996C4 *dp, &lv = *(dp=new (buf) S1996C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(S1996C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1996C4)");
    check_field_offset(lv, s1996c4f0, ABISELECT(8,4), "S1996C4.s1996c4f0");
    check_field_offset(lv, s1996c4f1, ABISELECT(16,8), "S1996C4.s1996c4f1");
    check_field_offset(lv, s1996c4f2, ABISELECT(24,12), "S1996C4.s1996c4f2");
    check_field_offset(lv, s1996c4f3, ABISELECT(40,24), "S1996C4.s1996c4f3");
    check_field_offset(lv, s1996c4f4, ABISELECT(56,36), "S1996C4.s1996c4f4");
    test_class_info(&lv, &cd_S1996C4);
    dp->~S1996C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1996C4(Test_S1996C4, "S1996C4", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN7S1996C4C1Ev();
extern void _ZN7S1996C4D1Ev();
Name_Map name_map_S1996C4[] = {
  NSPAIR(_ZN7S1996C4C1Ev),
  NSPAIR(_ZN7S1996C4D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S1996C4[];
extern void _ZN7S1996C4D1Ev();
extern void _ZN7S1996C4D0Ev();
extern void _ZN7S1996C42v1Ev();
extern void _ZN7S1996C42v2Ev();
extern void _ZN7S1996C42v3Ev();
extern void _ZN7S1996C42v4Ev();
extern void _ZN7S1996C42v5Ev();
extern void _ZN7S1996C42v6Ev();
extern void _ZN7S1996C42v7Ev();
extern void _ZN7S1996C42v8Ev();
extern void _ZN7S1996C42v9Ev();
extern void _ZN7S1996C43v10Ev();
extern void _ZN7S1996C43v11Ev();
extern void _ZN7S1996C43v12Ev();
extern void _ZN7S1996C43v13Ev();
extern void _ZN7S1996C43v14Ev();
extern void _ZN7S1996C43v15Ev();
extern void _ZN7S1996C43v16Ev();
extern void _ZN7S1996C43v17Ev();
extern void _ZN7S1996C43v18Ev();
extern void _ZN7S1996C43v19Ev();
extern void _ZN7S1996C43v20Ev();
extern void _ZN7S1996C43v21Ev();
extern void _ZN7S1996C43v22Ev();
extern void _ZN7S1996C43v23Ev();
static  VTBL_ENTRY vtc_S1996C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1996C4[0]),
  (VTBL_ENTRY)&_ZN7S1996C4D1Ev,
  (VTBL_ENTRY)&_ZN7S1996C4D0Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v1Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v23Ev,
};
extern VTBL_ENTRY _ZTI7S1996C4[];
extern  VTBL_ENTRY _ZTV7S1996C4[];
Class_Descriptor cd_S1996C4 = {  "S1996C4", // class name
  0,0,//no base classes
  &(vtc_S1996C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI7S1996C4),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S1996C4),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1996C3  : S1996C4 {
  ::S1993C15 s1996c3f0;
  ::S1993C15 s1996c3f1;
  ::S1993C15 s1996c3f2;
  ::S1990C13_nt s1996c3f3;
  ::S1990C17_nt s1996c3f4;
  ::S1990C18_nt s1996c3f5;
  ::S1990C18_nt s1996c3f6;
  ::S1993C15 s1996c3f7;
  ::S1993C15 s1996c3f8;
  ::S1993C15 s1996c3f9;
  void *s1996c3f10;
  ::S1990C17_nt s1996c3f11;
  ::S1990C19_nt s1996c3f12;
  int s1996c3f13;
  void *s1996c3f14[7];
  ::S1990C43 s1996c3f15;
  int s1996c3f16:8;
  int s1996c3f17:8;
  int s1996c3f18:16;
  int s1996c3f19:16;
  int s1996c3f20:8;
  int s1996c3f21:8;
  int s1996c3f22:8;
  int s1996c3f23:32;
  int s1996c3f24:8;
  int s1996c3f25:4;
  int s1996c3f26:4;
  int s1996c3f27:4;
  int s1996c3f28:4;
  int s1996c3f29:4;
  int s1996c3f30:4;
  int s1996c3f31:4;
  int s1996c3f32:4;
  int s1996c3f33:4;
  int s1996c3f34:4;
  unsigned char s1996c3f35:1;
  unsigned char s1996c3f36:1;
  unsigned char s1996c3f37:1;
  unsigned char s1996c3f38:1;
  unsigned char s1996c3f39:1;
  unsigned char s1996c3f40:1;
  unsigned char s1996c3f41:1;
  unsigned char s1996c3f42:1;
  unsigned char s1996c3f43:1;
  unsigned char s1996c3f44:1;
  unsigned char s1996c3f45:1;
  unsigned char s1996c3f46:1;
  unsigned char s1996c3f47:1;
  unsigned char s1996c3f48:1;
  unsigned char s1996c3f49:1;
  unsigned char s1996c3f50:1;
  unsigned char s1996c3f51:1;
  unsigned char s1996c3f52:1;
  unsigned char s1996c3f53:1;
  unsigned char s1996c3f54:1;
  unsigned char s1996c3f55:1;
  unsigned char s1996c3f56:1;
  unsigned char s1996c3f57:1;
  unsigned char s1996c3f58:1;
  unsigned char s1996c3f59:1;
  unsigned char s1996c3f60:1;
  unsigned char s1996c3f61:1;
  unsigned char s1996c3f62:1;
  unsigned char s1996c3f63:1;
  unsigned char s1996c3f64:1;
  unsigned char s1996c3f65:1;
  unsigned char s1996c3f66:1;
  unsigned char s1996c3f67:1;
  unsigned char s1996c3f68:1;
  unsigned char s1996c3f69:1;
  unsigned char s1996c3f70:1;
  unsigned char s1996c3f71:1;
  unsigned char s1996c3f72:1;
  unsigned char s1996c3f73:1;
  unsigned char s1996c3f74:1;
  unsigned char s1996c3f75:1;
  int s1996c3f76[7];
  void *s1996c3f77[6];
  int s1996c3f78:8;
  int s1996c3f79:8;
  int s1996c3f80:8;
  int s1996c3f81:8;
  int s1996c3f82:8;
  int s1996c3f83:8;
  ::S1990C25 s1996c3f84;
  void *s1996c3f85[4];
  int s1996c3f86:8;
  int s1996c3f87:8;
  int s1996c3f88:8;
  int s1996c3f89:8;
  int s1996c3f90:8;
  int s1996c3f91:16;
  int s1996c3f92:16;
  int s1996c3f93:16;
  int s1996c3f94:4;
  int s1996c3f95:4;
  int s1996c3f96:4;
  int s1996c3f97:4;
  int s1996c3f98:4;
  int s1996c3f99:4;
  int s1996c3f100:4;
  int s1996c3f101:4;
  int s1996c3f102:4;
  int s1996c3f103:4;
  int s1996c3f104:4;
  int s1996c3f105:4;
  int s1996c3f106:8;
  int s1996c3f107:8;
  int s1996c3f108:8;
  void *s1996c3f109[7];
  ::S1990C46 s1996c3f110;
  void *s1996c3f111[2];
  int s1996c3f112:16;
  int s1996c3f113:16;
  ::S1990C5_nt s1996c3f114;
  ::S1990C37 s1996c3f115;
  ::S1990C29_nt s1996c3f116;
  void *s1996c3f117[2];
  int s1996c3f118:24;
  int s1996c3f119:8;
  void *s1996c3f120;
  virtual  ~S1996C3(); // _ZN7S1996C3D1Ev
  virtual void  v24(); // _ZN7S1996C33v24Ev
  virtual void  v25(); // _ZN7S1996C33v25Ev
  virtual void  v26(); // _ZN7S1996C33v26Ev
  virtual void  v27(); // _ZN7S1996C33v27Ev
  virtual void  v28(); // _ZN7S1996C33v28Ev
  virtual void  v29(); // _ZN7S1996C33v29Ev
  virtual void  v30(); // _ZN7S1996C33v30Ev
  virtual void  v31(); // _ZN7S1996C33v31Ev
  virtual void  v32(); // _ZN7S1996C33v32Ev
  virtual void  v33(); // _ZN7S1996C33v33Ev
  virtual void  v34(); // _ZN7S1996C33v34Ev
  virtual void  v35(); // _ZN7S1996C33v35Ev
  virtual void  v36(); // _ZN7S1996C33v36Ev
  virtual void  v37(); // _ZN7S1996C33v37Ev
  virtual void  v38(); // _ZN7S1996C33v38Ev
  virtual void  v39(); // _ZN7S1996C33v39Ev
  virtual void  v40(); // _ZN7S1996C33v40Ev
  virtual void  v41(); // _ZN7S1996C33v41Ev
  virtual void  v42(); // _ZN7S1996C33v42Ev
  virtual void  v43(); // _ZN7S1996C33v43Ev
  virtual void  v44(); // _ZN7S1996C33v44Ev
  virtual void  v45(); // _ZN7S1996C33v45Ev
  virtual void  v46(); // _ZN7S1996C33v46Ev
  virtual void  v47(); // _ZN7S1996C33v47Ev
  virtual void  v48(); // _ZN7S1996C33v48Ev
  virtual void  v49(); // _ZN7S1996C33v49Ev
  virtual void  v50(); // _ZN7S1996C33v50Ev
  virtual void  v51(); // _ZN7S1996C33v51Ev
  virtual void  v52(); // _ZN7S1996C33v52Ev
  virtual void  v53(); // _ZN7S1996C33v53Ev
  virtual void  v54(); // _ZN7S1996C33v54Ev
  virtual void  v55(); // _ZN7S1996C33v55Ev
  virtual void  v56(); // _ZN7S1996C33v56Ev
  virtual void  v57(); // _ZN7S1996C33v57Ev
  virtual void  v58(); // _ZN7S1996C33v58Ev
  virtual void  v59(); // _ZN7S1996C33v59Ev
  virtual void  v60(); // _ZN7S1996C33v60Ev
  virtual void  v61(); // _ZN7S1996C33v61Ev
  virtual void  v62(); // _ZN7S1996C33v62Ev
  virtual void  v63(); // _ZN7S1996C33v63Ev
  virtual void  v64(); // _ZN7S1996C33v64Ev
  virtual void  v65(); // _ZN7S1996C33v65Ev
  virtual void  v66(); // _ZN7S1996C33v66Ev
  virtual void  v67(); // _ZN7S1996C33v67Ev
  virtual void  v68(); // _ZN7S1996C33v68Ev
  virtual void  v69(); // _ZN7S1996C33v69Ev
  virtual void  v70(); // _ZN7S1996C33v70Ev
  virtual void  v71(); // _ZN7S1996C33v71Ev
  virtual void  v72(); // _ZN7S1996C33v72Ev
  virtual void  v73(); // _ZN7S1996C33v73Ev
  virtual void  v74(); // _ZN7S1996C33v74Ev
  virtual void  v75(); // _ZN7S1996C33v75Ev
  virtual void  v76(); // _ZN7S1996C33v76Ev
  virtual void  v77(); // _ZN7S1996C33v77Ev
  virtual void  v78(); // _ZN7S1996C33v78Ev
  virtual void  v79(); // _ZN7S1996C33v79Ev
  virtual void  v80(); // _ZN7S1996C33v80Ev
  virtual void  v81(); // _ZN7S1996C33v81Ev
  virtual void  v82(); // _ZN7S1996C33v82Ev
  virtual void  v83(); // _ZN7S1996C33v83Ev
  virtual void  v84(); // _ZN7S1996C33v84Ev
  virtual void  v85(); // _ZN7S1996C33v85Ev
  virtual void  v86(); // _ZN7S1996C33v86Ev
  virtual void  v87(); // _ZN7S1996C33v87Ev
  virtual void  v88(); // _ZN7S1996C33v88Ev
  virtual void  v89(); // _ZN7S1996C33v89Ev
  virtual void  v90(); // _ZN7S1996C33v90Ev
  virtual void  v91(); // _ZN7S1996C33v91Ev
  virtual void  v92(); // _ZN7S1996C33v92Ev
  virtual void  v93(); // _ZN7S1996C33v93Ev
  virtual void  v94(); // _ZN7S1996C33v94Ev
  virtual void  v95(); // _ZN7S1996C33v95Ev
  virtual void  v96(); // _ZN7S1996C33v96Ev
  virtual void  v97(); // _ZN7S1996C33v97Ev
  virtual void  v98(); // _ZN7S1996C33v98Ev
  virtual void  v99(); // _ZN7S1996C33v99Ev
  virtual void  v100(); // _ZN7S1996C34v100Ev
  virtual void  v101(); // _ZN7S1996C34v101Ev
  S1996C3(); // tgen
};
//SIG(-1 S1996C3) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fp Fi FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}} FC7{ BC8{ m Fp Fi FC9{ m} FC10{ m}}} Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 FC11{ m FC12{ m FL[2]}} FC11 FC11 FC13{ m FC12} FC14{ m FC13} FC15{ m FC13 FC13 FC13 FC13} FC15 FC11 FC11 FC11 Fp FC14 FC16{ m FC17{ m Fp Fi FC18{ m}} Fi} Fi Fp[7] FC8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC19{ BC4} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC20{ m Fp Fi[2] FC10} Fp[2] Fi:16 Fi:16 FC21{ BC22{ m Fp Fi FC23{ m} FC23}} FC24{ m Fp Fi[2] FC9} FC25{ m Fp Fi[2] FC6} Fp[2] Fi:24 Fi:8 Fp}


 S1996C3 ::~S1996C3(){ note_dtor("S1996C3", this);}
void  S1996C3 ::v24(){vfunc_called(this, "_ZN7S1996C33v24Ev");}
void  S1996C3 ::v25(){vfunc_called(this, "_ZN7S1996C33v25Ev");}
void  S1996C3 ::v26(){vfunc_called(this, "_ZN7S1996C33v26Ev");}
void  S1996C3 ::v27(){vfunc_called(this, "_ZN7S1996C33v27Ev");}
void  S1996C3 ::v28(){vfunc_called(this, "_ZN7S1996C33v28Ev");}
void  S1996C3 ::v29(){vfunc_called(this, "_ZN7S1996C33v29Ev");}
void  S1996C3 ::v30(){vfunc_called(this, "_ZN7S1996C33v30Ev");}
void  S1996C3 ::v31(){vfunc_called(this, "_ZN7S1996C33v31Ev");}
void  S1996C3 ::v32(){vfunc_called(this, "_ZN7S1996C33v32Ev");}
void  S1996C3 ::v33(){vfunc_called(this, "_ZN7S1996C33v33Ev");}
void  S1996C3 ::v34(){vfunc_called(this, "_ZN7S1996C33v34Ev");}
void  S1996C3 ::v35(){vfunc_called(this, "_ZN7S1996C33v35Ev");}
void  S1996C3 ::v36(){vfunc_called(this, "_ZN7S1996C33v36Ev");}
void  S1996C3 ::v37(){vfunc_called(this, "_ZN7S1996C33v37Ev");}
void  S1996C3 ::v38(){vfunc_called(this, "_ZN7S1996C33v38Ev");}
void  S1996C3 ::v39(){vfunc_called(this, "_ZN7S1996C33v39Ev");}
void  S1996C3 ::v40(){vfunc_called(this, "_ZN7S1996C33v40Ev");}
void  S1996C3 ::v41(){vfunc_called(this, "_ZN7S1996C33v41Ev");}
void  S1996C3 ::v42(){vfunc_called(this, "_ZN7S1996C33v42Ev");}
void  S1996C3 ::v43(){vfunc_called(this, "_ZN7S1996C33v43Ev");}
void  S1996C3 ::v44(){vfunc_called(this, "_ZN7S1996C33v44Ev");}
void  S1996C3 ::v45(){vfunc_called(this, "_ZN7S1996C33v45Ev");}
void  S1996C3 ::v46(){vfunc_called(this, "_ZN7S1996C33v46Ev");}
void  S1996C3 ::v47(){vfunc_called(this, "_ZN7S1996C33v47Ev");}
void  S1996C3 ::v48(){vfunc_called(this, "_ZN7S1996C33v48Ev");}
void  S1996C3 ::v49(){vfunc_called(this, "_ZN7S1996C33v49Ev");}
void  S1996C3 ::v50(){vfunc_called(this, "_ZN7S1996C33v50Ev");}
void  S1996C3 ::v51(){vfunc_called(this, "_ZN7S1996C33v51Ev");}
void  S1996C3 ::v52(){vfunc_called(this, "_ZN7S1996C33v52Ev");}
void  S1996C3 ::v53(){vfunc_called(this, "_ZN7S1996C33v53Ev");}
void  S1996C3 ::v54(){vfunc_called(this, "_ZN7S1996C33v54Ev");}
void  S1996C3 ::v55(){vfunc_called(this, "_ZN7S1996C33v55Ev");}
void  S1996C3 ::v56(){vfunc_called(this, "_ZN7S1996C33v56Ev");}
void  S1996C3 ::v57(){vfunc_called(this, "_ZN7S1996C33v57Ev");}
void  S1996C3 ::v58(){vfunc_called(this, "_ZN7S1996C33v58Ev");}
void  S1996C3 ::v59(){vfunc_called(this, "_ZN7S1996C33v59Ev");}
void  S1996C3 ::v60(){vfunc_called(this, "_ZN7S1996C33v60Ev");}
void  S1996C3 ::v61(){vfunc_called(this, "_ZN7S1996C33v61Ev");}
void  S1996C3 ::v62(){vfunc_called(this, "_ZN7S1996C33v62Ev");}
void  S1996C3 ::v63(){vfunc_called(this, "_ZN7S1996C33v63Ev");}
void  S1996C3 ::v64(){vfunc_called(this, "_ZN7S1996C33v64Ev");}
void  S1996C3 ::v65(){vfunc_called(this, "_ZN7S1996C33v65Ev");}
void  S1996C3 ::v66(){vfunc_called(this, "_ZN7S1996C33v66Ev");}
void  S1996C3 ::v67(){vfunc_called(this, "_ZN7S1996C33v67Ev");}
void  S1996C3 ::v68(){vfunc_called(this, "_ZN7S1996C33v68Ev");}
void  S1996C3 ::v69(){vfunc_called(this, "_ZN7S1996C33v69Ev");}
void  S1996C3 ::v70(){vfunc_called(this, "_ZN7S1996C33v70Ev");}
void  S1996C3 ::v71(){vfunc_called(this, "_ZN7S1996C33v71Ev");}
void  S1996C3 ::v72(){vfunc_called(this, "_ZN7S1996C33v72Ev");}
void  S1996C3 ::v73(){vfunc_called(this, "_ZN7S1996C33v73Ev");}
void  S1996C3 ::v74(){vfunc_called(this, "_ZN7S1996C33v74Ev");}
void  S1996C3 ::v75(){vfunc_called(this, "_ZN7S1996C33v75Ev");}
void  S1996C3 ::v76(){vfunc_called(this, "_ZN7S1996C33v76Ev");}
void  S1996C3 ::v77(){vfunc_called(this, "_ZN7S1996C33v77Ev");}
void  S1996C3 ::v78(){vfunc_called(this, "_ZN7S1996C33v78Ev");}
void  S1996C3 ::v79(){vfunc_called(this, "_ZN7S1996C33v79Ev");}
void  S1996C3 ::v80(){vfunc_called(this, "_ZN7S1996C33v80Ev");}
void  S1996C3 ::v81(){vfunc_called(this, "_ZN7S1996C33v81Ev");}
void  S1996C3 ::v82(){vfunc_called(this, "_ZN7S1996C33v82Ev");}
void  S1996C3 ::v83(){vfunc_called(this, "_ZN7S1996C33v83Ev");}
void  S1996C3 ::v84(){vfunc_called(this, "_ZN7S1996C33v84Ev");}
void  S1996C3 ::v85(){vfunc_called(this, "_ZN7S1996C33v85Ev");}
void  S1996C3 ::v86(){vfunc_called(this, "_ZN7S1996C33v86Ev");}
void  S1996C3 ::v87(){vfunc_called(this, "_ZN7S1996C33v87Ev");}
void  S1996C3 ::v88(){vfunc_called(this, "_ZN7S1996C33v88Ev");}
void  S1996C3 ::v89(){vfunc_called(this, "_ZN7S1996C33v89Ev");}
void  S1996C3 ::v90(){vfunc_called(this, "_ZN7S1996C33v90Ev");}
void  S1996C3 ::v91(){vfunc_called(this, "_ZN7S1996C33v91Ev");}
void  S1996C3 ::v92(){vfunc_called(this, "_ZN7S1996C33v92Ev");}
void  S1996C3 ::v93(){vfunc_called(this, "_ZN7S1996C33v93Ev");}
void  S1996C3 ::v94(){vfunc_called(this, "_ZN7S1996C33v94Ev");}
void  S1996C3 ::v95(){vfunc_called(this, "_ZN7S1996C33v95Ev");}
void  S1996C3 ::v96(){vfunc_called(this, "_ZN7S1996C33v96Ev");}
void  S1996C3 ::v97(){vfunc_called(this, "_ZN7S1996C33v97Ev");}
void  S1996C3 ::v98(){vfunc_called(this, "_ZN7S1996C33v98Ev");}
void  S1996C3 ::v99(){vfunc_called(this, "_ZN7S1996C33v99Ev");}
void  S1996C3 ::v100(){vfunc_called(this, "_ZN7S1996C34v100Ev");}
void  S1996C3 ::v101(){vfunc_called(this, "_ZN7S1996C34v101Ev");}
S1996C3 ::S1996C3(){ note_ctor("S1996C3", this);} // tgen

static void Test_S1996C3()
{
  extern Class_Descriptor cd_S1996C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(105,159)];
    init_test(&cd_S1996C3, buf);
    S1996C3 *dp, &lv = *(dp=new (buf) S1996C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(832,632), "sizeof(S1996C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1996C3)");
    check_base_class_offset(lv, (S1996C4*), 0, "S1996C3");
    check_field_offset(lv, s1996c3f0, ABISELECT(64,40), "S1996C3.s1996c3f0");
    check_field_offset(lv, s1996c3f1, ABISELECT(80,56), "S1996C3.s1996c3f1");
    check_field_offset(lv, s1996c3f2, ABISELECT(96,72), "S1996C3.s1996c3f2");
    check_field_offset(lv, s1996c3f3, ABISELECT(112,88), "S1996C3.s1996c3f3");
    check_field_offset(lv, s1996c3f4, ABISELECT(128,104), "S1996C3.s1996c3f4");
    check_field_offset(lv, s1996c3f5, ABISELECT(144,120), "S1996C3.s1996c3f5");
    check_field_offset(lv, s1996c3f6, ABISELECT(208,184), "S1996C3.s1996c3f6");
    check_field_offset(lv, s1996c3f7, ABISELECT(272,248), "S1996C3.s1996c3f7");
    check_field_offset(lv, s1996c3f8, ABISELECT(288,264), "S1996C3.s1996c3f8");
    check_field_offset(lv, s1996c3f9, ABISELECT(304,280), "S1996C3.s1996c3f9");
    check_field_offset(lv, s1996c3f10, ABISELECT(320,296), "S1996C3.s1996c3f10");
    check_field_offset(lv, s1996c3f11, ABISELECT(328,300), "S1996C3.s1996c3f11");
    check_field_offset(lv, s1996c3f12, ABISELECT(344,316), "S1996C3.s1996c3f12");
    check_field_offset(lv, s1996c3f13, ABISELECT(368,332), "S1996C3.s1996c3f13");
    check_field_offset(lv, s1996c3f14, ABISELECT(376,336), "S1996C3.s1996c3f14");
    check_field_offset(lv, s1996c3f15, ABISELECT(432,364), "S1996C3.s1996c3f15");
    set_bf_and_test(lv, s1996c3f16, ABISELECT(448,376), 0, 8, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f16, ABISELECT(448,376), 0, 8, hide_sll(1LL<<7), "S1996C3");
    set_bf_and_test(lv, s1996c3f17, ABISELECT(449,377), 0, 8, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f17, ABISELECT(449,377), 0, 8, hide_sll(1LL<<7), "S1996C3");
    set_bf_and_test(lv, s1996c3f18, ABISELECT(450,378), 0, 16, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f18, ABISELECT(450,378), 0, 16, hide_sll(1LL<<15), "S1996C3");
    set_bf_and_test(lv, s1996c3f19, ABISELECT(452,380), 0, 16, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f19, ABISELECT(452,380), 0, 16, hide_sll(1LL<<15), "S1996C3");
    set_bf_and_test(lv, s1996c3f20, ABISELECT(454,382), 0, 8, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f20, ABISELECT(454,382), 0, 8, hide_sll(1LL<<7), "S1996C3");
    set_bf_and_test(lv, s1996c3f21, ABISELECT(455,383), 0, 8, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f21, ABISELECT(455,383), 0, 8, hide_sll(1LL<<7), "S1996C3");
    set_bf_and_test(lv, s1996c3f22, ABISELECT(456,384), 0, 8, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f22, ABISELECT(456,384), 0, 8, hide_sll(1LL<<7), "S1996C3");
    set_bf_and_test(lv, s1996c3f23, ABISELECT(460,388), 0, 32, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f23, ABISELECT(460,388), 0, 32, hide_sll(1LL<<31), "S1996C3");
    set_bf_and_test(lv, s1996c3f24, ABISELECT(464,392), 0, 8, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f24, ABISELECT(464,392), 0, 8, hide_sll(1LL<<7), "S1996C3");
    set_bf_and_test(lv, s1996c3f25, ABISELECT(465,393), 0, 4, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f25, ABISELECT(465,393), 0, 4, hide_sll(1LL<<3), "S1996C3");
    set_bf_and_test(lv, s1996c3f26, ABISELECT(465,393), 4, 4, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f26, ABISELECT(465,393), 4, 4, hide_sll(1LL<<3), "S1996C3");
    set_bf_and_test(lv, s1996c3f27, ABISELECT(466,394), 0, 4, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f27, ABISELECT(466,394), 0, 4, hide_sll(1LL<<3), "S1996C3");
    set_bf_and_test(lv, s1996c3f28, ABISELECT(466,394), 4, 4, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f28, ABISELECT(466,394), 4, 4, hide_sll(1LL<<3), "S1996C3");
    set_bf_and_test(lv, s1996c3f29, ABISELECT(467,395), 0, 4, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f29, ABISELECT(467,395), 0, 4, hide_sll(1LL<<3), "S1996C3");
    set_bf_and_test(lv, s1996c3f30, ABISELECT(467,395), 4, 4, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f30, ABISELECT(467,395), 4, 4, hide_sll(1LL<<3), "S1996C3");
    set_bf_and_test(lv, s1996c3f31, ABISELECT(468,396), 0, 4, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f31, ABISELECT(468,396), 0, 4, hide_sll(1LL<<3), "S1996C3");
    set_bf_and_test(lv, s1996c3f32, ABISELECT(468,396), 4, 4, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f32, ABISELECT(468,396), 4, 4, hide_sll(1LL<<3), "S1996C3");
    set_bf_and_test(lv, s1996c3f33, ABISELECT(469,397), 0, 4, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f33, ABISELECT(469,397), 0, 4, hide_sll(1LL<<3), "S1996C3");
    set_bf_and_test(lv, s1996c3f34, ABISELECT(469,397), 4, 4, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f34, ABISELECT(469,397), 4, 4, hide_sll(1LL<<3), "S1996C3");
    set_bf_and_test(lv, s1996c3f35, ABISELECT(470,398), 0, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f36, ABISELECT(470,398), 1, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f37, ABISELECT(470,398), 2, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f38, ABISELECT(470,398), 3, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f39, ABISELECT(470,398), 4, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f40, ABISELECT(470,398), 5, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f41, ABISELECT(470,398), 6, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f42, ABISELECT(470,398), 7, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f43, ABISELECT(471,399), 0, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f44, ABISELECT(471,399), 1, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f45, ABISELECT(471,399), 2, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f46, ABISELECT(471,399), 3, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f47, ABISELECT(471,399), 4, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f48, ABISELECT(471,399), 5, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f49, ABISELECT(471,399), 6, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f50, ABISELECT(471,399), 7, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f51, ABISELECT(472,400), 0, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f52, ABISELECT(472,400), 1, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f53, ABISELECT(472,400), 2, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f54, ABISELECT(472,400), 3, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f55, ABISELECT(472,400), 4, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f56, ABISELECT(472,400), 5, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f57, ABISELECT(472,400), 6, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f58, ABISELECT(472,400), 7, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f59, ABISELECT(473,401), 0, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f60, ABISELECT(473,401), 1, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f61, ABISELECT(473,401), 2, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f62, ABISELECT(473,401), 3, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f63, ABISELECT(473,401), 4, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f64, ABISELECT(473,401), 5, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f65, ABISELECT(473,401), 6, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f66, ABISELECT(473,401), 7, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f67, ABISELECT(474,402), 0, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f68, ABISELECT(474,402), 1, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f69, ABISELECT(474,402), 2, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f70, ABISELECT(474,402), 3, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f71, ABISELECT(474,402), 4, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f72, ABISELECT(474,402), 5, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f73, ABISELECT(474,402), 6, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f74, ABISELECT(474,402), 7, 1, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f75, ABISELECT(475,403), 0, 1, 1, "S1996C3");
    check_field_offset(lv, s1996c3f76, ABISELECT(476,404), "S1996C3.s1996c3f76");
    check_field_offset(lv, s1996c3f77, ABISELECT(504,432), "S1996C3.s1996c3f77");
    set_bf_and_test(lv, s1996c3f78, ABISELECT(552,456), 0, 8, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f78, ABISELECT(552,456), 0, 8, hide_sll(1LL<<7), "S1996C3");
    set_bf_and_test(lv, s1996c3f79, ABISELECT(553,457), 0, 8, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f79, ABISELECT(553,457), 0, 8, hide_sll(1LL<<7), "S1996C3");
    set_bf_and_test(lv, s1996c3f80, ABISELECT(554,458), 0, 8, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f80, ABISELECT(554,458), 0, 8, hide_sll(1LL<<7), "S1996C3");
    set_bf_and_test(lv, s1996c3f81, ABISELECT(555,459), 0, 8, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f81, ABISELECT(555,459), 0, 8, hide_sll(1LL<<7), "S1996C3");
    set_bf_and_test(lv, s1996c3f82, ABISELECT(556,460), 0, 8, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f82, ABISELECT(556,460), 0, 8, hide_sll(1LL<<7), "S1996C3");
    set_bf_and_test(lv, s1996c3f83, ABISELECT(557,461), 0, 8, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f83, ABISELECT(557,461), 0, 8, hide_sll(1LL<<7), "S1996C3");
    check_field_offset(lv, s1996c3f84, ABISELECT(560,464), "S1996C3.s1996c3f84");
    check_field_offset(lv, s1996c3f85, ABISELECT(576,476), "S1996C3.s1996c3f85");
    set_bf_and_test(lv, s1996c3f86, ABISELECT(608,492), 0, 8, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f86, ABISELECT(608,492), 0, 8, hide_sll(1LL<<7), "S1996C3");
    set_bf_and_test(lv, s1996c3f87, ABISELECT(609,493), 0, 8, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f87, ABISELECT(609,493), 0, 8, hide_sll(1LL<<7), "S1996C3");
    set_bf_and_test(lv, s1996c3f88, ABISELECT(610,494), 0, 8, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f88, ABISELECT(610,494), 0, 8, hide_sll(1LL<<7), "S1996C3");
    set_bf_and_test(lv, s1996c3f89, ABISELECT(611,495), 0, 8, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f89, ABISELECT(611,495), 0, 8, hide_sll(1LL<<7), "S1996C3");
    set_bf_and_test(lv, s1996c3f90, ABISELECT(612,496), 0, 8, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f90, ABISELECT(612,496), 0, 8, hide_sll(1LL<<7), "S1996C3");
    set_bf_and_test(lv, s1996c3f91, ABISELECT(613,497), 0, 16, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f91, ABISELECT(613,497), 0, 16, hide_sll(1LL<<15), "S1996C3");
    set_bf_and_test(lv, s1996c3f92, ABISELECT(616,500), 0, 16, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f92, ABISELECT(616,500), 0, 16, hide_sll(1LL<<15), "S1996C3");
    set_bf_and_test(lv, s1996c3f93, ABISELECT(618,502), 0, 16, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f93, ABISELECT(618,502), 0, 16, hide_sll(1LL<<15), "S1996C3");
    set_bf_and_test(lv, s1996c3f94, ABISELECT(620,504), 0, 4, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f94, ABISELECT(620,504), 0, 4, hide_sll(1LL<<3), "S1996C3");
    set_bf_and_test(lv, s1996c3f95, ABISELECT(620,504), 4, 4, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f95, ABISELECT(620,504), 4, 4, hide_sll(1LL<<3), "S1996C3");
    set_bf_and_test(lv, s1996c3f96, ABISELECT(621,505), 0, 4, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f96, ABISELECT(621,505), 0, 4, hide_sll(1LL<<3), "S1996C3");
    set_bf_and_test(lv, s1996c3f97, ABISELECT(621,505), 4, 4, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f97, ABISELECT(621,505), 4, 4, hide_sll(1LL<<3), "S1996C3");
    set_bf_and_test(lv, s1996c3f98, ABISELECT(622,506), 0, 4, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f98, ABISELECT(622,506), 0, 4, hide_sll(1LL<<3), "S1996C3");
    set_bf_and_test(lv, s1996c3f99, ABISELECT(622,506), 4, 4, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f99, ABISELECT(622,506), 4, 4, hide_sll(1LL<<3), "S1996C3");
    set_bf_and_test(lv, s1996c3f100, ABISELECT(623,507), 0, 4, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f100, ABISELECT(623,507), 0, 4, hide_sll(1LL<<3), "S1996C3");
    set_bf_and_test(lv, s1996c3f101, ABISELECT(623,507), 4, 4, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f101, ABISELECT(623,507), 4, 4, hide_sll(1LL<<3), "S1996C3");
    set_bf_and_test(lv, s1996c3f102, ABISELECT(624,508), 0, 4, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f102, ABISELECT(624,508), 0, 4, hide_sll(1LL<<3), "S1996C3");
    set_bf_and_test(lv, s1996c3f103, ABISELECT(624,508), 4, 4, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f103, ABISELECT(624,508), 4, 4, hide_sll(1LL<<3), "S1996C3");
    set_bf_and_test(lv, s1996c3f104, ABISELECT(625,509), 0, 4, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f104, ABISELECT(625,509), 0, 4, hide_sll(1LL<<3), "S1996C3");
    set_bf_and_test(lv, s1996c3f105, ABISELECT(625,509), 4, 4, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f105, ABISELECT(625,509), 4, 4, hide_sll(1LL<<3), "S1996C3");
    set_bf_and_test(lv, s1996c3f106, ABISELECT(626,510), 0, 8, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f106, ABISELECT(626,510), 0, 8, hide_sll(1LL<<7), "S1996C3");
    set_bf_and_test(lv, s1996c3f107, ABISELECT(627,511), 0, 8, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f107, ABISELECT(627,511), 0, 8, hide_sll(1LL<<7), "S1996C3");
    set_bf_and_test(lv, s1996c3f108, ABISELECT(628,512), 0, 8, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f108, ABISELECT(628,512), 0, 8, hide_sll(1LL<<7), "S1996C3");
    check_field_offset(lv, s1996c3f109, ABISELECT(632,516), "S1996C3.s1996c3f109");
    check_field_offset(lv, s1996c3f110, ABISELECT(688,544), "S1996C3.s1996c3f110");
    check_field_offset(lv, s1996c3f111, ABISELECT(712,560), "S1996C3.s1996c3f111");
    set_bf_and_test(lv, s1996c3f112, ABISELECT(728,568), 0, 16, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f112, ABISELECT(728,568), 0, 16, hide_sll(1LL<<15), "S1996C3");
    set_bf_and_test(lv, s1996c3f113, ABISELECT(730,570), 0, 16, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f113, ABISELECT(730,570), 0, 16, hide_sll(1LL<<15), "S1996C3");
    check_field_offset(lv, s1996c3f114, ABISELECT(736,572), "S1996C3.s1996c3f114");
    check_field_offset(lv, s1996c3f115, ABISELECT(752,584), "S1996C3.s1996c3f115");
    check_field_offset(lv, s1996c3f116, ABISELECT(776,600), "S1996C3.s1996c3f116");
    check_field_offset(lv, s1996c3f117, ABISELECT(800,616), "S1996C3.s1996c3f117");
    set_bf_and_test(lv, s1996c3f118, ABISELECT(816,624), 0, 24, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f118, ABISELECT(816,624), 0, 24, hide_sll(1LL<<23), "S1996C3");
    set_bf_and_test(lv, s1996c3f119, ABISELECT(819,627), 0, 8, 1, "S1996C3");
    set_bf_and_test(lv, s1996c3f119, ABISELECT(819,627), 0, 8, hide_sll(1LL<<7), "S1996C3");
    check_field_offset(lv, s1996c3f120, ABISELECT(824,628), "S1996C3.s1996c3f120");
    test_class_info(&lv, &cd_S1996C3);
    dp->~S1996C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1996C3(Test_S1996C3, "S1996C3", ABISELECT(832,632));

#else // __cplusplus

extern void _ZN7S1996C3C1Ev();
extern void _ZN7S1996C3D1Ev();
Name_Map name_map_S1996C3[] = {
  NSPAIR(_ZN7S1996C3C1Ev),
  NSPAIR(_ZN7S1996C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1996C4;
extern VTBL_ENTRY _ZTI7S1996C4[];
extern  VTBL_ENTRY _ZTV7S1996C4[];
static Base_Class bases_S1996C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1996C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1996C3[];
extern void _ZN7S1996C3D1Ev();
extern void _ZN7S1996C3D0Ev();
extern void _ZN7S1996C42v1Ev();
extern void _ZN7S1996C42v2Ev();
extern void _ZN7S1996C42v3Ev();
extern void _ZN7S1996C42v4Ev();
extern void _ZN7S1996C42v5Ev();
extern void _ZN7S1996C42v6Ev();
extern void _ZN7S1996C42v7Ev();
extern void _ZN7S1996C42v8Ev();
extern void _ZN7S1996C42v9Ev();
extern void _ZN7S1996C43v10Ev();
extern void _ZN7S1996C43v11Ev();
extern void _ZN7S1996C43v12Ev();
extern void _ZN7S1996C43v13Ev();
extern void _ZN7S1996C43v14Ev();
extern void _ZN7S1996C43v15Ev();
extern void _ZN7S1996C43v16Ev();
extern void _ZN7S1996C43v17Ev();
extern void _ZN7S1996C43v18Ev();
extern void _ZN7S1996C43v19Ev();
extern void _ZN7S1996C43v20Ev();
extern void _ZN7S1996C43v21Ev();
extern void _ZN7S1996C43v22Ev();
extern void _ZN7S1996C43v23Ev();
extern void _ZN7S1996C33v24Ev();
extern void _ZN7S1996C33v25Ev();
extern void _ZN7S1996C33v26Ev();
extern void _ZN7S1996C33v27Ev();
extern void _ZN7S1996C33v28Ev();
extern void _ZN7S1996C33v29Ev();
extern void _ZN7S1996C33v30Ev();
extern void _ZN7S1996C33v31Ev();
extern void _ZN7S1996C33v32Ev();
extern void _ZN7S1996C33v33Ev();
extern void _ZN7S1996C33v34Ev();
extern void _ZN7S1996C33v35Ev();
extern void _ZN7S1996C33v36Ev();
extern void _ZN7S1996C33v37Ev();
extern void _ZN7S1996C33v38Ev();
extern void _ZN7S1996C33v39Ev();
extern void _ZN7S1996C33v40Ev();
extern void _ZN7S1996C33v41Ev();
extern void _ZN7S1996C33v42Ev();
extern void _ZN7S1996C33v43Ev();
extern void _ZN7S1996C33v44Ev();
extern void _ZN7S1996C33v45Ev();
extern void _ZN7S1996C33v46Ev();
extern void _ZN7S1996C33v47Ev();
extern void _ZN7S1996C33v48Ev();
extern void _ZN7S1996C33v49Ev();
extern void _ZN7S1996C33v50Ev();
extern void _ZN7S1996C33v51Ev();
extern void _ZN7S1996C33v52Ev();
extern void _ZN7S1996C33v53Ev();
extern void _ZN7S1996C33v54Ev();
extern void _ZN7S1996C33v55Ev();
extern void _ZN7S1996C33v56Ev();
extern void _ZN7S1996C33v57Ev();
extern void _ZN7S1996C33v58Ev();
extern void _ZN7S1996C33v59Ev();
extern void _ZN7S1996C33v60Ev();
extern void _ZN7S1996C33v61Ev();
extern void _ZN7S1996C33v62Ev();
extern void _ZN7S1996C33v63Ev();
extern void _ZN7S1996C33v64Ev();
extern void _ZN7S1996C33v65Ev();
extern void _ZN7S1996C33v66Ev();
extern void _ZN7S1996C33v67Ev();
extern void _ZN7S1996C33v68Ev();
extern void _ZN7S1996C33v69Ev();
extern void _ZN7S1996C33v70Ev();
extern void _ZN7S1996C33v71Ev();
extern void _ZN7S1996C33v72Ev();
extern void _ZN7S1996C33v73Ev();
extern void _ZN7S1996C33v74Ev();
extern void _ZN7S1996C33v75Ev();
extern void _ZN7S1996C33v76Ev();
extern void _ZN7S1996C33v77Ev();
extern void _ZN7S1996C33v78Ev();
extern void _ZN7S1996C33v79Ev();
extern void _ZN7S1996C33v80Ev();
extern void _ZN7S1996C33v81Ev();
extern void _ZN7S1996C33v82Ev();
extern void _ZN7S1996C33v83Ev();
extern void _ZN7S1996C33v84Ev();
extern void _ZN7S1996C33v85Ev();
extern void _ZN7S1996C33v86Ev();
extern void _ZN7S1996C33v87Ev();
extern void _ZN7S1996C33v88Ev();
extern void _ZN7S1996C33v89Ev();
extern void _ZN7S1996C33v90Ev();
extern void _ZN7S1996C33v91Ev();
extern void _ZN7S1996C33v92Ev();
extern void _ZN7S1996C33v93Ev();
extern void _ZN7S1996C33v94Ev();
extern void _ZN7S1996C33v95Ev();
extern void _ZN7S1996C33v96Ev();
extern void _ZN7S1996C33v97Ev();
extern void _ZN7S1996C33v98Ev();
extern void _ZN7S1996C33v99Ev();
extern void _ZN7S1996C34v100Ev();
extern void _ZN7S1996C34v101Ev();
static  VTBL_ENTRY vtc_S1996C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1996C3[0]),
  (VTBL_ENTRY)&_ZN7S1996C3D1Ev,
  (VTBL_ENTRY)&_ZN7S1996C3D0Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v1Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v29Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v30Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v31Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v32Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v33Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v34Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v35Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v36Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v37Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v38Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v39Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v40Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v41Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v42Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v43Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v44Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v45Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v46Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v47Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v48Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v49Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v50Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v51Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v52Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v53Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v54Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v55Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v56Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v57Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v58Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v59Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v60Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v61Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v62Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v63Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v64Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v65Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v66Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v67Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v68Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v69Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1996C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1996C34v101Ev,
};
extern VTBL_ENTRY _ZTI7S1996C3[];
extern  VTBL_ENTRY _ZTV7S1996C3[];
Class_Descriptor cd_S1996C3 = {  "S1996C3", // class name
  bases_S1996C3, 1,
  &(vtc_S1996C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI7S1996C3),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1996C3),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1996C2  : S1996C3 {
  void *s1996c2f0;
  char s1996c2f1;
  ::S1990C39_nt s1996c2f2;
  ::S1990C19_nt s1996c2f3;
  virtual  ~S1996C2(); // _ZN7S1996C2D1Ev
  virtual void  v102(); // _ZN7S1996C24v102Ev
  virtual void  v103(); // _ZN7S1996C24v103Ev
  virtual void  v104(); // _ZN7S1996C24v104Ev
  virtual void  v105(); // _ZN7S1996C24v105Ev
  virtual void  v106(); // _ZN7S1996C24v106Ev
  virtual void  v107(); // _ZN7S1996C24v107Ev
  virtual void  v108(); // _ZN7S1996C24v108Ev
  virtual void  v109(); // _ZN7S1996C24v109Ev
  virtual void  v110(); // _ZN7S1996C24v110Ev
  S1996C2(); // tgen
};
//SIG(-1 S1996C2) C1{ BC2{ BC3{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 Fp Fi FC4{ BC5{ m Fp Fi FC6{ m} FC7{ m}}} FC8{ BC9{ m Fp Fi FC10{ m} FC11{ m}}} Fi} vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 FC12{ m FC13{ m FL[2]}} FC12 FC12 FC14{ m FC13} FC15{ m FC14} FC16{ m FC14 FC14 FC14 FC14} FC16 FC12 FC12 FC12 Fp FC15 FC17{ m FC18{ m Fp Fi FC19{ m}} Fi} Fi Fp[7] FC9 Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC20{ BC5} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC21{ m Fp Fi[2] FC11} Fp[2] Fi:16 Fi:16 FC22{ BC23{ m Fp Fi FC24{ m} FC24}} FC25{ m Fp Fi[2] FC10} FC26{ m Fp Fi[2] FC7} Fp[2] Fi:24 Fi:8 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fp Fc FC27{ m FC25 FC8 FC21 FC8} FC17}


 S1996C2 ::~S1996C2(){ note_dtor("S1996C2", this);}
void  S1996C2 ::v102(){vfunc_called(this, "_ZN7S1996C24v102Ev");}
void  S1996C2 ::v103(){vfunc_called(this, "_ZN7S1996C24v103Ev");}
void  S1996C2 ::v104(){vfunc_called(this, "_ZN7S1996C24v104Ev");}
void  S1996C2 ::v105(){vfunc_called(this, "_ZN7S1996C24v105Ev");}
void  S1996C2 ::v106(){vfunc_called(this, "_ZN7S1996C24v106Ev");}
void  S1996C2 ::v107(){vfunc_called(this, "_ZN7S1996C24v107Ev");}
void  S1996C2 ::v108(){vfunc_called(this, "_ZN7S1996C24v108Ev");}
void  S1996C2 ::v109(){vfunc_called(this, "_ZN7S1996C24v109Ev");}
void  S1996C2 ::v110(){vfunc_called(this, "_ZN7S1996C24v110Ev");}
S1996C2 ::S1996C2(){ note_ctor("S1996C2", this);} // tgen

static void Test_S1996C2()
{
  extern Class_Descriptor cd_S1996C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(120,179)];
    init_test(&cd_S1996C2, buf);
    S1996C2 *dp, &lv = *(dp=new (buf) S1996C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(952,712), "sizeof(S1996C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1996C2)");
    check_base_class_offset(lv, (S1996C4*)(S1996C3*), 0, "S1996C2");
    check_base_class_offset(lv, (S1996C3*), 0, "S1996C2");
    check_field_offset(lv, s1996c2f0, ABISELECT(832,632), "S1996C2.s1996c2f0");
    check_field_offset(lv, s1996c2f1, ABISELECT(840,636), "S1996C2.s1996c2f1");
    check_field_offset(lv, s1996c2f2, ABISELECT(848,640), "S1996C2.s1996c2f2");
    check_field_offset(lv, s1996c2f3, ABISELECT(928,696), "S1996C2.s1996c2f3");
    test_class_info(&lv, &cd_S1996C2);
    dp->~S1996C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1996C2(Test_S1996C2, "S1996C2", ABISELECT(952,712));

#else // __cplusplus

extern void _ZN7S1996C2C1Ev();
extern void _ZN7S1996C2D1Ev();
Name_Map name_map_S1996C2[] = {
  NSPAIR(_ZN7S1996C2C1Ev),
  NSPAIR(_ZN7S1996C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1996C4;
extern VTBL_ENTRY _ZTI7S1996C4[];
extern  VTBL_ENTRY _ZTV7S1996C4[];
extern Class_Descriptor cd_S1996C3;
extern VTBL_ENTRY _ZTI7S1996C3[];
extern  VTBL_ENTRY _ZTV7S1996C3[];
static Base_Class bases_S1996C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1996C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1996C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1996C2[];
extern void _ZN7S1996C2D1Ev();
extern void _ZN7S1996C2D0Ev();
extern void _ZN7S1996C42v1Ev();
extern void _ZN7S1996C42v2Ev();
extern void _ZN7S1996C42v3Ev();
extern void _ZN7S1996C42v4Ev();
extern void _ZN7S1996C42v5Ev();
extern void _ZN7S1996C42v6Ev();
extern void _ZN7S1996C42v7Ev();
extern void _ZN7S1996C42v8Ev();
extern void _ZN7S1996C42v9Ev();
extern void _ZN7S1996C43v10Ev();
extern void _ZN7S1996C43v11Ev();
extern void _ZN7S1996C43v12Ev();
extern void _ZN7S1996C43v13Ev();
extern void _ZN7S1996C43v14Ev();
extern void _ZN7S1996C43v15Ev();
extern void _ZN7S1996C43v16Ev();
extern void _ZN7S1996C43v17Ev();
extern void _ZN7S1996C43v18Ev();
extern void _ZN7S1996C43v19Ev();
extern void _ZN7S1996C43v20Ev();
extern void _ZN7S1996C43v21Ev();
extern void _ZN7S1996C43v22Ev();
extern void _ZN7S1996C43v23Ev();
extern void _ZN7S1996C33v24Ev();
extern void _ZN7S1996C33v25Ev();
extern void _ZN7S1996C33v26Ev();
extern void _ZN7S1996C33v27Ev();
extern void _ZN7S1996C33v28Ev();
extern void _ZN7S1996C33v29Ev();
extern void _ZN7S1996C33v30Ev();
extern void _ZN7S1996C33v31Ev();
extern void _ZN7S1996C33v32Ev();
extern void _ZN7S1996C33v33Ev();
extern void _ZN7S1996C33v34Ev();
extern void _ZN7S1996C33v35Ev();
extern void _ZN7S1996C33v36Ev();
extern void _ZN7S1996C33v37Ev();
extern void _ZN7S1996C33v38Ev();
extern void _ZN7S1996C33v39Ev();
extern void _ZN7S1996C33v40Ev();
extern void _ZN7S1996C33v41Ev();
extern void _ZN7S1996C33v42Ev();
extern void _ZN7S1996C33v43Ev();
extern void _ZN7S1996C33v44Ev();
extern void _ZN7S1996C33v45Ev();
extern void _ZN7S1996C33v46Ev();
extern void _ZN7S1996C33v47Ev();
extern void _ZN7S1996C33v48Ev();
extern void _ZN7S1996C33v49Ev();
extern void _ZN7S1996C33v50Ev();
extern void _ZN7S1996C33v51Ev();
extern void _ZN7S1996C33v52Ev();
extern void _ZN7S1996C33v53Ev();
extern void _ZN7S1996C33v54Ev();
extern void _ZN7S1996C33v55Ev();
extern void _ZN7S1996C33v56Ev();
extern void _ZN7S1996C33v57Ev();
extern void _ZN7S1996C33v58Ev();
extern void _ZN7S1996C33v59Ev();
extern void _ZN7S1996C33v60Ev();
extern void _ZN7S1996C33v61Ev();
extern void _ZN7S1996C33v62Ev();
extern void _ZN7S1996C33v63Ev();
extern void _ZN7S1996C33v64Ev();
extern void _ZN7S1996C33v65Ev();
extern void _ZN7S1996C33v66Ev();
extern void _ZN7S1996C33v67Ev();
extern void _ZN7S1996C33v68Ev();
extern void _ZN7S1996C33v69Ev();
extern void _ZN7S1996C33v70Ev();
extern void _ZN7S1996C33v71Ev();
extern void _ZN7S1996C33v72Ev();
extern void _ZN7S1996C33v73Ev();
extern void _ZN7S1996C33v74Ev();
extern void _ZN7S1996C33v75Ev();
extern void _ZN7S1996C33v76Ev();
extern void _ZN7S1996C33v77Ev();
extern void _ZN7S1996C33v78Ev();
extern void _ZN7S1996C33v79Ev();
extern void _ZN7S1996C33v80Ev();
extern void _ZN7S1996C33v81Ev();
extern void _ZN7S1996C33v82Ev();
extern void _ZN7S1996C33v83Ev();
extern void _ZN7S1996C33v84Ev();
extern void _ZN7S1996C33v85Ev();
extern void _ZN7S1996C33v86Ev();
extern void _ZN7S1996C33v87Ev();
extern void _ZN7S1996C33v88Ev();
extern void _ZN7S1996C33v89Ev();
extern void _ZN7S1996C33v90Ev();
extern void _ZN7S1996C33v91Ev();
extern void _ZN7S1996C33v92Ev();
extern void _ZN7S1996C33v93Ev();
extern void _ZN7S1996C33v94Ev();
extern void _ZN7S1996C33v95Ev();
extern void _ZN7S1996C33v96Ev();
extern void _ZN7S1996C33v97Ev();
extern void _ZN7S1996C33v98Ev();
extern void _ZN7S1996C33v99Ev();
extern void _ZN7S1996C34v100Ev();
extern void _ZN7S1996C34v101Ev();
extern void _ZN7S1996C24v102Ev();
extern void _ZN7S1996C24v103Ev();
extern void _ZN7S1996C24v104Ev();
extern void _ZN7S1996C24v105Ev();
extern void _ZN7S1996C24v106Ev();
extern void _ZN7S1996C24v107Ev();
extern void _ZN7S1996C24v108Ev();
extern void _ZN7S1996C24v109Ev();
extern void _ZN7S1996C24v110Ev();
static  VTBL_ENTRY vtc_S1996C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1996C2[0]),
  (VTBL_ENTRY)&_ZN7S1996C2D1Ev,
  (VTBL_ENTRY)&_ZN7S1996C2D0Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v1Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v29Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v30Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v31Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v32Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v33Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v34Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v35Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v36Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v37Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v38Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v39Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v40Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v41Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v42Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v43Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v44Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v45Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v46Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v47Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v48Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v49Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v50Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v51Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v52Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v53Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v54Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v55Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v56Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v57Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v58Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v59Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v60Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v61Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v62Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v63Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v64Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v65Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v66Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v67Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v68Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v69Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1996C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1996C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1996C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1996C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1996C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1996C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1996C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1996C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1996C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1996C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1996C24v110Ev,
};
extern VTBL_ENTRY _ZTI7S1996C2[];
extern  VTBL_ENTRY _ZTV7S1996C2[];
Class_Descriptor cd_S1996C2 = {  "S1996C2", // class name
  bases_S1996C2, 2,
  &(vtc_S1996C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(952,712), // object size
  NSPAIRA(_ZTI7S1996C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1996C2),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S1996C1  : S1996C2 {
  virtual  ~S1996C1(); // _ZN7S1996C1D1Ev
  S1996C1(); // tgen
};
//SIG(1 S1996C1) C1{ BC2{ BC3{ BC4{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC5{ BC6{ m Fp Fi FC7{ m} FC8{ m}}} FC9{ BC10{ m Fp Fi FC11{ m} FC12{ m}}} Fi} vd v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 FC13{ m FC14{ m FL[2]}} FC13 FC13 FC15{ m FC14} FC16{ m FC15} FC17{ m FC15 FC15 FC15 FC15} FC17 FC13 FC13 FC13 Fp FC16 FC18{ m FC19{ m Fp Fi FC20{ m}} Fi} Fi Fp[7] FC10 Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC21{ BC6} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC22{ m Fp Fi[2] FC12} Fp[2] Fi:16 Fi:16 FC23{ BC24{ m Fp Fi FC25{ m} FC25}} FC26{ m Fp Fi[2] FC11} FC27{ m Fp Fi[2] FC8} Fp[2] Fi:24 Fi:8 Fp} vd v102 v103 v104 v105 v106 v107 v108 v109 v110 Fp Fc FC28{ m FC26 FC9 FC22 FC9} FC18} vd}


 S1996C1 ::~S1996C1(){ note_dtor("S1996C1", this);}
S1996C1 ::S1996C1(){ note_ctor("S1996C1", this);} // tgen

static void Test_S1996C1()
{
  extern Class_Descriptor cd_S1996C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(120,179)];
    init_test(&cd_S1996C1, buf);
    S1996C1 *dp, &lv = *(dp=new (buf) S1996C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(952,712), "sizeof(S1996C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S1996C1)");
    check_base_class_offset(lv, (S1996C4*)(S1996C3*)(S1996C2*), 0, "S1996C1");
    check_base_class_offset(lv, (S1996C3*)(S1996C2*), 0, "S1996C1");
    check_base_class_offset(lv, (S1996C2*), 0, "S1996C1");
    test_class_info(&lv, &cd_S1996C1);
    dp->~S1996C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS1996C1(Test_S1996C1, "S1996C1", ABISELECT(952,712));

#else // __cplusplus

extern void _ZN7S1996C1C1Ev();
extern void _ZN7S1996C1D1Ev();
Name_Map name_map_S1996C1[] = {
  NSPAIR(_ZN7S1996C1C1Ev),
  NSPAIR(_ZN7S1996C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S1996C4;
extern VTBL_ENTRY _ZTI7S1996C4[];
extern  VTBL_ENTRY _ZTV7S1996C4[];
extern Class_Descriptor cd_S1996C3;
extern VTBL_ENTRY _ZTI7S1996C3[];
extern  VTBL_ENTRY _ZTV7S1996C3[];
extern Class_Descriptor cd_S1996C2;
extern VTBL_ENTRY _ZTI7S1996C2[];
extern  VTBL_ENTRY _ZTV7S1996C2[];
static Base_Class bases_S1996C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S1996C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S1996C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S1996C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S1996C1[];
extern void _ZN7S1996C1D1Ev();
extern void _ZN7S1996C1D0Ev();
extern void _ZN7S1996C42v1Ev();
extern void _ZN7S1996C42v2Ev();
extern void _ZN7S1996C42v3Ev();
extern void _ZN7S1996C42v4Ev();
extern void _ZN7S1996C42v5Ev();
extern void _ZN7S1996C42v6Ev();
extern void _ZN7S1996C42v7Ev();
extern void _ZN7S1996C42v8Ev();
extern void _ZN7S1996C42v9Ev();
extern void _ZN7S1996C43v10Ev();
extern void _ZN7S1996C43v11Ev();
extern void _ZN7S1996C43v12Ev();
extern void _ZN7S1996C43v13Ev();
extern void _ZN7S1996C43v14Ev();
extern void _ZN7S1996C43v15Ev();
extern void _ZN7S1996C43v16Ev();
extern void _ZN7S1996C43v17Ev();
extern void _ZN7S1996C43v18Ev();
extern void _ZN7S1996C43v19Ev();
extern void _ZN7S1996C43v20Ev();
extern void _ZN7S1996C43v21Ev();
extern void _ZN7S1996C43v22Ev();
extern void _ZN7S1996C43v23Ev();
extern void _ZN7S1996C33v24Ev();
extern void _ZN7S1996C33v25Ev();
extern void _ZN7S1996C33v26Ev();
extern void _ZN7S1996C33v27Ev();
extern void _ZN7S1996C33v28Ev();
extern void _ZN7S1996C33v29Ev();
extern void _ZN7S1996C33v30Ev();
extern void _ZN7S1996C33v31Ev();
extern void _ZN7S1996C33v32Ev();
extern void _ZN7S1996C33v33Ev();
extern void _ZN7S1996C33v34Ev();
extern void _ZN7S1996C33v35Ev();
extern void _ZN7S1996C33v36Ev();
extern void _ZN7S1996C33v37Ev();
extern void _ZN7S1996C33v38Ev();
extern void _ZN7S1996C33v39Ev();
extern void _ZN7S1996C33v40Ev();
extern void _ZN7S1996C33v41Ev();
extern void _ZN7S1996C33v42Ev();
extern void _ZN7S1996C33v43Ev();
extern void _ZN7S1996C33v44Ev();
extern void _ZN7S1996C33v45Ev();
extern void _ZN7S1996C33v46Ev();
extern void _ZN7S1996C33v47Ev();
extern void _ZN7S1996C33v48Ev();
extern void _ZN7S1996C33v49Ev();
extern void _ZN7S1996C33v50Ev();
extern void _ZN7S1996C33v51Ev();
extern void _ZN7S1996C33v52Ev();
extern void _ZN7S1996C33v53Ev();
extern void _ZN7S1996C33v54Ev();
extern void _ZN7S1996C33v55Ev();
extern void _ZN7S1996C33v56Ev();
extern void _ZN7S1996C33v57Ev();
extern void _ZN7S1996C33v58Ev();
extern void _ZN7S1996C33v59Ev();
extern void _ZN7S1996C33v60Ev();
extern void _ZN7S1996C33v61Ev();
extern void _ZN7S1996C33v62Ev();
extern void _ZN7S1996C33v63Ev();
extern void _ZN7S1996C33v64Ev();
extern void _ZN7S1996C33v65Ev();
extern void _ZN7S1996C33v66Ev();
extern void _ZN7S1996C33v67Ev();
extern void _ZN7S1996C33v68Ev();
extern void _ZN7S1996C33v69Ev();
extern void _ZN7S1996C33v70Ev();
extern void _ZN7S1996C33v71Ev();
extern void _ZN7S1996C33v72Ev();
extern void _ZN7S1996C33v73Ev();
extern void _ZN7S1996C33v74Ev();
extern void _ZN7S1996C33v75Ev();
extern void _ZN7S1996C33v76Ev();
extern void _ZN7S1996C33v77Ev();
extern void _ZN7S1996C33v78Ev();
extern void _ZN7S1996C33v79Ev();
extern void _ZN7S1996C33v80Ev();
extern void _ZN7S1996C33v81Ev();
extern void _ZN7S1996C33v82Ev();
extern void _ZN7S1996C33v83Ev();
extern void _ZN7S1996C33v84Ev();
extern void _ZN7S1996C33v85Ev();
extern void _ZN7S1996C33v86Ev();
extern void _ZN7S1996C33v87Ev();
extern void _ZN7S1996C33v88Ev();
extern void _ZN7S1996C33v89Ev();
extern void _ZN7S1996C33v90Ev();
extern void _ZN7S1996C33v91Ev();
extern void _ZN7S1996C33v92Ev();
extern void _ZN7S1996C33v93Ev();
extern void _ZN7S1996C33v94Ev();
extern void _ZN7S1996C33v95Ev();
extern void _ZN7S1996C33v96Ev();
extern void _ZN7S1996C33v97Ev();
extern void _ZN7S1996C33v98Ev();
extern void _ZN7S1996C33v99Ev();
extern void _ZN7S1996C34v100Ev();
extern void _ZN7S1996C34v101Ev();
extern void _ZN7S1996C24v102Ev();
extern void _ZN7S1996C24v103Ev();
extern void _ZN7S1996C24v104Ev();
extern void _ZN7S1996C24v105Ev();
extern void _ZN7S1996C24v106Ev();
extern void _ZN7S1996C24v107Ev();
extern void _ZN7S1996C24v108Ev();
extern void _ZN7S1996C24v109Ev();
extern void _ZN7S1996C24v110Ev();
static  VTBL_ENTRY vtc_S1996C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S1996C1[0]),
  (VTBL_ENTRY)&_ZN7S1996C1D1Ev,
  (VTBL_ENTRY)&_ZN7S1996C1D0Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v1Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v2Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v3Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v4Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v5Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v6Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v7Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v8Ev,
  (VTBL_ENTRY)&_ZN7S1996C42v9Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v10Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v11Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v12Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v13Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v14Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v15Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v16Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v17Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v18Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v19Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v20Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v21Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v22Ev,
  (VTBL_ENTRY)&_ZN7S1996C43v23Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v24Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v25Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v26Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v27Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v28Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v29Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v30Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v31Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v32Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v33Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v34Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v35Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v36Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v37Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v38Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v39Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v40Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v41Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v42Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v43Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v44Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v45Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v46Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v47Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v48Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v49Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v50Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v51Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v52Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v53Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v54Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v55Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v56Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v57Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v58Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v59Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v60Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v61Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v62Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v63Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v64Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v65Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v66Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v67Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v68Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v69Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v70Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v71Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v72Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v73Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v74Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v75Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v76Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v77Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v78Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v79Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v80Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v81Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v82Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v83Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v84Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v85Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v86Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v87Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v88Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v89Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v90Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v91Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v92Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v93Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v94Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v95Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v96Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v97Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v98Ev,
  (VTBL_ENTRY)&_ZN7S1996C33v99Ev,
  (VTBL_ENTRY)&_ZN7S1996C34v100Ev,
  (VTBL_ENTRY)&_ZN7S1996C34v101Ev,
  (VTBL_ENTRY)&_ZN7S1996C24v102Ev,
  (VTBL_ENTRY)&_ZN7S1996C24v103Ev,
  (VTBL_ENTRY)&_ZN7S1996C24v104Ev,
  (VTBL_ENTRY)&_ZN7S1996C24v105Ev,
  (VTBL_ENTRY)&_ZN7S1996C24v106Ev,
  (VTBL_ENTRY)&_ZN7S1996C24v107Ev,
  (VTBL_ENTRY)&_ZN7S1996C24v108Ev,
  (VTBL_ENTRY)&_ZN7S1996C24v109Ev,
  (VTBL_ENTRY)&_ZN7S1996C24v110Ev,
};
extern VTBL_ENTRY _ZTI7S1996C1[];
extern  VTBL_ENTRY _ZTV7S1996C1[];
Class_Descriptor cd_S1996C1 = {  "S1996C1", // class name
  bases_S1996C1, 3,
  &(vtc_S1996C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(952,712), // object size
  NSPAIRA(_ZTI7S1996C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S1996C1),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2765C7_nt  {
  void *s2765c7f0[2];
  void  mf2765c7(); // _ZN10S2765C7_nt8mf2765c7Ev
};
//SIG(-1 S2765C7_nt) C1{ m Fp[2]}


void  S2765C7_nt ::mf2765c7(){}

//skip512 S2765C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2765C3  {
  __tsi64 s2765c3f0[2];
  void *s2765c3f1;
  ::S1990C20_nt s2765c3f2;
  void *s2765c3f3;
  ::S1990C52_nt s2765c3f4;
  ::S2765C7_nt s2765c3f5;
  void  mf2765c3(); // _ZN7S2765C38mf2765c3Ev
};
//SIG(-1 S2765C3) C1{ m FL[2] Fp FC2{ m Fp Fi FC3{ m}} Fp FC4{ m Fp[2]} FC5{ m Fp[2]}}


void  S2765C3 ::mf2765c3(){}

static void Test_S2765C3()
{
  {
    init_simple_test("S2765C3");
    S2765C3 lv;
    check2(sizeof(lv), ABISELECT(80,52), "sizeof(S2765C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2765C3)");
    check_field_offset(lv, s2765c3f0, 0, "S2765C3.s2765c3f0");
    check_field_offset(lv, s2765c3f1, 16, "S2765C3.s2765c3f1");
    check_field_offset(lv, s2765c3f2, ABISELECT(24,20), "S2765C3.s2765c3f2");
    check_field_offset(lv, s2765c3f3, ABISELECT(40,32), "S2765C3.s2765c3f3");
    check_field_offset(lv, s2765c3f4, ABISELECT(48,36), "S2765C3.s2765c3f4");
    check_field_offset(lv, s2765c3f5, ABISELECT(64,44), "S2765C3.s2765c3f5");
  }
}
static Arrange_To_Call_Me vS2765C3(Test_S2765C3, "S2765C3", ABISELECT(80,52));

#else // __cplusplus

extern VTBL_ENTRY _ZTI7S2765C3[];
VTBL_ENTRY *P__ZTI7S2765C3 = _ZTI7S2765C3; 
Class_Descriptor cd_S2765C3 = {  "S2765C3", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(80,52), // object size
  NSPAIRA(_ZTI7S2765C3),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2765C8_nt  {
  char s2765c8f0;
  int s2765c8f1;
};
//SIG(1 S2765C8_nt) C1{ Fc Fi}



//skip512 S2765C8_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2765C9  {
  __tsi64 s2765c9f0;
  char s2765c9f1[20];
  void *s2765c9f2;
  char s2765c9f3;
  int s2765c9f4[3];
  __tsi64 s2765c9f5;
  char s2765c9f6[3];
  void  mf2765c9(); // _ZN7S2765C98mf2765c9Ev
  virtual  ~S2765C9(); // _ZN7S2765C9D1Ev
  S2765C9(); // tgen
};
//SIG(-1 S2765C9) C1{ vd m FL Fc[20] Fp Fc Fi[3] FL Fc[3]}


void  S2765C9 ::mf2765c9(){}
 S2765C9 ::~S2765C9(){ note_dtor("S2765C9", this);}
S2765C9 ::S2765C9(){ note_ctor("S2765C9", this);} // tgen

static void Test_S2765C9()
{
  extern Class_Descriptor cd_S2765C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(11,17)];
    init_test(&cd_S2765C9, buf);
    S2765C9 *dp, &lv = *(dp=new (buf) S2765C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(80,64), "sizeof(S2765C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2765C9)");
    check_field_offset(lv, s2765c9f0, ABISELECT(8,4), "S2765C9.s2765c9f0");
    check_field_offset(lv, s2765c9f1, ABISELECT(16,12), "S2765C9.s2765c9f1");
    check_field_offset(lv, s2765c9f2, ABISELECT(40,32), "S2765C9.s2765c9f2");
    check_field_offset(lv, s2765c9f3, ABISELECT(48,36), "S2765C9.s2765c9f3");
    check_field_offset(lv, s2765c9f4, ABISELECT(52,40), "S2765C9.s2765c9f4");
    check_field_offset(lv, s2765c9f5, ABISELECT(64,52), "S2765C9.s2765c9f5");
    check_field_offset(lv, s2765c9f6, ABISELECT(72,60), "S2765C9.s2765c9f6");
    test_class_info(&lv, &cd_S2765C9);
    dp->~S2765C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2765C9(Test_S2765C9, "S2765C9", ABISELECT(80,64));

#else // __cplusplus

extern void _ZN7S2765C9C1Ev();
extern void _ZN7S2765C9D1Ev();
Name_Map name_map_S2765C9[] = {
  NSPAIR(_ZN7S2765C9C1Ev),
  NSPAIR(_ZN7S2765C9D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S2765C9[];
extern void _ZN7S2765C9D1Ev();
extern void _ZN7S2765C9D0Ev();
static  VTBL_ENTRY vtc_S2765C9[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2765C9[0]),
  (VTBL_ENTRY)&_ZN7S2765C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2765C9D0Ev,
};
extern VTBL_ENTRY _ZTI7S2765C9[];
extern  VTBL_ENTRY _ZTV7S2765C9[];
Class_Descriptor cd_S2765C9 = {  "S2765C9", // class name
  0,0,//no base classes
  &(vtc_S2765C9[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(80,64), // object size
  NSPAIRA(_ZTI7S2765C9),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S2765C9),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2765C10_nt  {
  __tsi64 s2765c10f0[2];
  char s2765c10f1;
  int s2765c10f2;
  ::S1990C20_nt s2765c10f3;
  ::S1990C20_nt s2765c10f4;
  ::S1990C20_nt s2765c10f5;
  ::S1990C20_nt s2765c10f6;
  ::S1990C20_nt s2765c10f7;
  ::S1990C20_nt s2765c10f8;
  ::S1990C20_nt s2765c10f9;
  ::S1990C20_nt s2765c10f10;
  ::S1990C20_nt s2765c10f11;
  ::S1990C20_nt s2765c10f12;
  ::S1990C20_nt s2765c10f13;
  ::S1990C20_nt s2765c10f14;
  int s2765c10f15[3];
  ::S1990C20_nt s2765c10f16;
  ::S1990C20_nt s2765c10f17;
  ::S1990C20_nt s2765c10f18;
  __tsi64 s2765c10f19[2];
  int s2765c10f20[4];
  ::S1990C20_nt s2765c10f21;
  ::S1990C20_nt s2765c10f22;
  int s2765c10f23[2];
  __tsi64 s2765c10f24;
  int s2765c10f25[5];
  __tsi64 s2765c10f26;
  char s2765c10f27;
  void  mf2765c10(); // _ZN11S2765C10_nt9mf2765c10Ev
};
//SIG(-1 S2765C10_nt) C1{ m FL[2] Fc Fi FC2{ m Fp Fi FC3{ m}} FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 FC2 Fi[3] FC2 FC2 FC2 FL[2] Fi[4] FC2 FC2 Fi[2] FL Fi[5] FL Fc}


void  S2765C10_nt ::mf2765c10(){}

//skip512 S2765C10_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2765C2  : S2765C3 {
  int s2765c2f0[2];
  ::S2765C8_nt s2765c2f1[51];
  int s2765c2f2;
  ::S2765C9 s2765c2f3;
  int s2765c2f4;
  ::S2765C10_nt s2765c2f5;
  int s2765c2f6;
  virtual  ~S2765C2(); // _ZN7S2765C2D1Ev
  virtual void  v3(); // _ZN7S2765C22v3Ev
  virtual void  v4(); // _ZN7S2765C22v4Ev
  virtual void  v5(); // _ZN7S2765C22v5Ev
  virtual void  v6(); // _ZN7S2765C22v6Ev
  virtual void  v7(); // _ZN7S2765C22v7Ev
  virtual void  v8(); // _ZN7S2765C22v8Ev
  virtual void  v9(); // _ZN7S2765C22v9Ev
  virtual void  v10(); // _ZN7S2765C23v10Ev
  virtual void  v11(); // _ZN7S2765C23v11Ev
  virtual void  v12(); // _ZN7S2765C23v12Ev
  virtual void  v13(); // _ZN7S2765C23v13Ev
  virtual void  v14(); // _ZN7S2765C23v14Ev
  virtual void  v15(); // _ZN7S2765C23v15Ev
  virtual void  v16(); // _ZN7S2765C23v16Ev
  virtual void  v17(); // _ZN7S2765C23v17Ev
  virtual void  v18(); // _ZN7S2765C23v18Ev
  virtual void  v19(); // _ZN7S2765C23v19Ev
  virtual void  v20(); // _ZN7S2765C23v20Ev
  virtual void  v21(); // _ZN7S2765C23v21Ev
  virtual void  v22(); // _ZN7S2765C23v22Ev
  virtual void  v23(); // _ZN7S2765C23v23Ev
  virtual void  v24(); // _ZN7S2765C23v24Ev
  virtual void  v25(); // _ZN7S2765C23v25Ev
  virtual void  v26(); // _ZN7S2765C23v26Ev
  virtual void  v27(); // _ZN7S2765C23v27Ev
  virtual void  v28(); // _ZN7S2765C23v28Ev
  virtual void  v29(); // _ZN7S2765C23v29Ev
  virtual void  v30(); // _ZN7S2765C23v30Ev
  virtual void  v31(); // _ZN7S2765C23v31Ev
  virtual void  v32(); // _ZN7S2765C23v32Ev
  virtual void  v33(); // _ZN7S2765C23v33Ev
  virtual void  v34(); // _ZN7S2765C23v34Ev
  S2765C2(); // tgen
};
//SIG(-1 S2765C2) C1{ BC2{ m FL[2] Fp FC3{ m Fp Fi FC4{ m}} Fp FC5{ m Fp[2]} FC6{ m Fp[2]}} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 Fi[2] FC7{ Fc Fi}[51] Fi FC8{ vd m FL Fc[20] Fp Fc Fi[3] FL Fc[3]} Fi FC9{ m FL[2] Fc Fi FC3 FC3 FC3 FC3 FC3 FC3 FC3 FC3 FC3 FC3 FC3 FC3 Fi[3] FC3 FC3 FC3 FL[2] Fi[4] FC3 FC3 Fi[2] FL Fi[5] FL Fc} Fi}


 S2765C2 ::~S2765C2(){ note_dtor("S2765C2", this);}
void  S2765C2 ::v3(){vfunc_called(this, "_ZN7S2765C22v3Ev");}
void  S2765C2 ::v4(){vfunc_called(this, "_ZN7S2765C22v4Ev");}
void  S2765C2 ::v5(){vfunc_called(this, "_ZN7S2765C22v5Ev");}
void  S2765C2 ::v6(){vfunc_called(this, "_ZN7S2765C22v6Ev");}
void  S2765C2 ::v7(){vfunc_called(this, "_ZN7S2765C22v7Ev");}
void  S2765C2 ::v8(){vfunc_called(this, "_ZN7S2765C22v8Ev");}
void  S2765C2 ::v9(){vfunc_called(this, "_ZN7S2765C22v9Ev");}
void  S2765C2 ::v10(){vfunc_called(this, "_ZN7S2765C23v10Ev");}
void  S2765C2 ::v11(){vfunc_called(this, "_ZN7S2765C23v11Ev");}
void  S2765C2 ::v12(){vfunc_called(this, "_ZN7S2765C23v12Ev");}
void  S2765C2 ::v13(){vfunc_called(this, "_ZN7S2765C23v13Ev");}
void  S2765C2 ::v14(){vfunc_called(this, "_ZN7S2765C23v14Ev");}
void  S2765C2 ::v15(){vfunc_called(this, "_ZN7S2765C23v15Ev");}
void  S2765C2 ::v16(){vfunc_called(this, "_ZN7S2765C23v16Ev");}
void  S2765C2 ::v17(){vfunc_called(this, "_ZN7S2765C23v17Ev");}
void  S2765C2 ::v18(){vfunc_called(this, "_ZN7S2765C23v18Ev");}
void  S2765C2 ::v19(){vfunc_called(this, "_ZN7S2765C23v19Ev");}
void  S2765C2 ::v20(){vfunc_called(this, "_ZN7S2765C23v20Ev");}
void  S2765C2 ::v21(){vfunc_called(this, "_ZN7S2765C23v21Ev");}
void  S2765C2 ::v22(){vfunc_called(this, "_ZN7S2765C23v22Ev");}
void  S2765C2 ::v23(){vfunc_called(this, "_ZN7S2765C23v23Ev");}
void  S2765C2 ::v24(){vfunc_called(this, "_ZN7S2765C23v24Ev");}
void  S2765C2 ::v25(){vfunc_called(this, "_ZN7S2765C23v25Ev");}
void  S2765C2 ::v26(){vfunc_called(this, "_ZN7S2765C23v26Ev");}
void  S2765C2 ::v27(){vfunc_called(this, "_ZN7S2765C23v27Ev");}
void  S2765C2 ::v28(){vfunc_called(this, "_ZN7S2765C23v28Ev");}
void  S2765C2 ::v29(){vfunc_called(this, "_ZN7S2765C23v29Ev");}
void  S2765C2 ::v30(){vfunc_called(this, "_ZN7S2765C23v30Ev");}
void  S2765C2 ::v31(){vfunc_called(this, "_ZN7S2765C23v31Ev");}
void  S2765C2 ::v32(){vfunc_called(this, "_ZN7S2765C23v32Ev");}
void  S2765C2 ::v33(){vfunc_called(this, "_ZN7S2765C23v33Ev");}
void  S2765C2 ::v34(){vfunc_called(this, "_ZN7S2765C23v34Ev");}
S2765C2 ::S2765C2(){ note_ctor("S2765C2", this);} // tgen

static void Test_S2765C2()
{
  extern Class_Descriptor cd_S2765C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(127,218)];
    init_test(&cd_S2765C2, buf);
    S2765C2 *dp, &lv = *(dp=new (buf) S2765C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1008,868), "sizeof(S2765C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2765C2)");
    check_base_class_offset(lv, (S2765C3*), ABISELECT(8,4), "S2765C2");
    check_field_offset(lv, s2765c2f0, ABISELECT(88,56), "S2765C2.s2765c2f0");
    check_field_offset(lv, s2765c2f1, ABISELECT(96,64), "S2765C2.s2765c2f1");
    check_field_offset(lv, s2765c2f2, ABISELECT(504,472), "S2765C2.s2765c2f2");
    check_field_offset(lv, s2765c2f3, ABISELECT(512,476), "S2765C2.s2765c2f3");
    check_field_offset(lv, s2765c2f4, ABISELECT(592,540), "S2765C2.s2765c2f4");
    check_field_offset(lv, s2765c2f5, ABISELECT(600,544), "S2765C2.s2765c2f5");
    check_field_offset(lv, s2765c2f6, ABISELECT(1000,864), "S2765C2.s2765c2f6");
    test_class_info(&lv, &cd_S2765C2);
    dp->~S2765C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2765C2(Test_S2765C2, "S2765C2", ABISELECT(1008,868));

#else // __cplusplus

extern void _ZN7S2765C2C1Ev();
extern void _ZN7S2765C2D1Ev();
Name_Map name_map_S2765C2[] = {
  NSPAIR(_ZN7S2765C2C1Ev),
  NSPAIR(_ZN7S2765C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2765C3;
extern VTBL_ENTRY _ZTI7S2765C3[];
static Base_Class bases_S2765C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2765C3,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2765C2[];
extern void _ZN7S2765C2D1Ev();
extern void _ZN7S2765C2D0Ev();
extern void _ZN7S2765C22v3Ev();
extern void _ZN7S2765C22v4Ev();
extern void _ZN7S2765C22v5Ev();
extern void _ZN7S2765C22v6Ev();
extern void _ZN7S2765C22v7Ev();
extern void _ZN7S2765C22v8Ev();
extern void _ZN7S2765C22v9Ev();
extern void _ZN7S2765C23v10Ev();
extern void _ZN7S2765C23v11Ev();
extern void _ZN7S2765C23v12Ev();
extern void _ZN7S2765C23v13Ev();
extern void _ZN7S2765C23v14Ev();
extern void _ZN7S2765C23v15Ev();
extern void _ZN7S2765C23v16Ev();
extern void _ZN7S2765C23v17Ev();
extern void _ZN7S2765C23v18Ev();
extern void _ZN7S2765C23v19Ev();
extern void _ZN7S2765C23v20Ev();
extern void _ZN7S2765C23v21Ev();
extern void _ZN7S2765C23v22Ev();
extern void _ZN7S2765C23v23Ev();
extern void _ZN7S2765C23v24Ev();
extern void _ZN7S2765C23v25Ev();
extern void _ZN7S2765C23v26Ev();
extern void _ZN7S2765C23v27Ev();
extern void _ZN7S2765C23v28Ev();
extern void _ZN7S2765C23v29Ev();
extern void _ZN7S2765C23v30Ev();
extern void _ZN7S2765C23v31Ev();
extern void _ZN7S2765C23v32Ev();
extern void _ZN7S2765C23v33Ev();
extern void _ZN7S2765C23v34Ev();
static  VTBL_ENTRY vtc_S2765C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2765C2[0]),
  (VTBL_ENTRY)&_ZN7S2765C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2765C2D0Ev,
  (VTBL_ENTRY)&_ZN7S2765C22v3Ev,
  (VTBL_ENTRY)&_ZN7S2765C22v4Ev,
  (VTBL_ENTRY)&_ZN7S2765C22v5Ev,
  (VTBL_ENTRY)&_ZN7S2765C22v6Ev,
  (VTBL_ENTRY)&_ZN7S2765C22v7Ev,
  (VTBL_ENTRY)&_ZN7S2765C22v8Ev,
  (VTBL_ENTRY)&_ZN7S2765C22v9Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v10Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v11Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v12Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v13Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v14Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v15Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v16Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v17Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v18Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v19Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v20Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v21Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v22Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v23Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v24Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v25Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v26Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v27Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v28Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v29Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v30Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v34Ev,
};
extern VTBL_ENTRY _ZTI7S2765C2[];
extern  VTBL_ENTRY _ZTV7S2765C2[];
Class_Descriptor cd_S2765C2 = {  "S2765C2", // class name
  bases_S2765C2, 1,
  &(vtc_S2765C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1008,868), // object size
  NSPAIRA(_ZTI7S2765C2),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7S2765C2),36, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2765C1  : S2765C2 {
  int s2765c1f0;
  ::S2765C9 s2765c1f1;
  void *s2765c1f2;
  virtual  ~S2765C1(); // _ZN7S2765C1D1Ev
  virtual void  v1(); // _ZN7S2765C12v1Ev
  virtual void  v2(); // _ZN7S2765C12v2Ev
  S2765C1(); // tgen
};
//SIG(1 S2765C1) C1{ BC2{ BC3{ m FL[2] Fp FC4{ m Fp Fi FC5{ m}} Fp FC6{ m Fp[2]} FC7{ m Fp[2]}} vd v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 Fi[2] FC8{ Fc Fi}[51] Fi FC9{ vd m FL Fc[20] Fp Fc Fi[3] FL Fc[3]} Fi FC10{ m FL[2] Fc Fi FC4 FC4 FC4 FC4 FC4 FC4 FC4 FC4 FC4 FC4 FC4 FC4 Fi[3] FC4 FC4 FC4 FL[2] Fi[4] FC4 FC4 Fi[2] FL Fi[5] FL Fc} Fi} vd v1 v2 Fi FC9 Fp}


 S2765C1 ::~S2765C1(){ note_dtor("S2765C1", this);}
void  S2765C1 ::v1(){vfunc_called(this, "_ZN7S2765C12v1Ev");}
void  S2765C1 ::v2(){vfunc_called(this, "_ZN7S2765C12v2Ev");}
S2765C1 ::S2765C1(){ note_ctor("S2765C1", this);} // tgen

static void Test_S2765C1()
{
  extern Class_Descriptor cd_S2765C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(138,236)];
    init_test(&cd_S2765C1, buf);
    S2765C1 *dp, &lv = *(dp=new (buf) S2765C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1096,940), "sizeof(S2765C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2765C1)");
    check_base_class_offset(lv, (S2765C3*)(S2765C2*), ABISELECT(8,4), "S2765C1");
    check_base_class_offset(lv, (S2765C2*), 0, "S2765C1");
    check_field_offset(lv, s2765c1f0, ABISELECT(1004,868), "S2765C1.s2765c1f0");
    check_field_offset(lv, s2765c1f1, ABISELECT(1008,872), "S2765C1.s2765c1f1");
    check_field_offset(lv, s2765c1f2, ABISELECT(1088,936), "S2765C1.s2765c1f2");
    test_class_info(&lv, &cd_S2765C1);
    dp->~S2765C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2765C1(Test_S2765C1, "S2765C1", ABISELECT(1096,940));

#else // __cplusplus

extern void _ZN7S2765C1C1Ev();
extern void _ZN7S2765C1D1Ev();
Name_Map name_map_S2765C1[] = {
  NSPAIR(_ZN7S2765C1C1Ev),
  NSPAIR(_ZN7S2765C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2765C3;
extern VTBL_ENTRY _ZTI7S2765C3[];
extern Class_Descriptor cd_S2765C2;
extern VTBL_ENTRY _ZTI7S2765C2[];
extern  VTBL_ENTRY _ZTV7S2765C2[];
static Base_Class bases_S2765C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2765C3,    ABISELECT(8,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2765C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2765C1[];
extern void _ZN7S2765C1D1Ev();
extern void _ZN7S2765C1D0Ev();
extern void _ZN7S2765C22v3Ev();
extern void _ZN7S2765C22v4Ev();
extern void _ZN7S2765C22v5Ev();
extern void _ZN7S2765C22v6Ev();
extern void _ZN7S2765C22v7Ev();
extern void _ZN7S2765C22v8Ev();
extern void _ZN7S2765C22v9Ev();
extern void _ZN7S2765C23v10Ev();
extern void _ZN7S2765C23v11Ev();
extern void _ZN7S2765C23v12Ev();
extern void _ZN7S2765C23v13Ev();
extern void _ZN7S2765C23v14Ev();
extern void _ZN7S2765C23v15Ev();
extern void _ZN7S2765C23v16Ev();
extern void _ZN7S2765C23v17Ev();
extern void _ZN7S2765C23v18Ev();
extern void _ZN7S2765C23v19Ev();
extern void _ZN7S2765C23v20Ev();
extern void _ZN7S2765C23v21Ev();
extern void _ZN7S2765C23v22Ev();
extern void _ZN7S2765C23v23Ev();
extern void _ZN7S2765C23v24Ev();
extern void _ZN7S2765C23v25Ev();
extern void _ZN7S2765C23v26Ev();
extern void _ZN7S2765C23v27Ev();
extern void _ZN7S2765C23v28Ev();
extern void _ZN7S2765C23v29Ev();
extern void _ZN7S2765C23v30Ev();
extern void _ZN7S2765C23v31Ev();
extern void _ZN7S2765C23v32Ev();
extern void _ZN7S2765C23v33Ev();
extern void _ZN7S2765C23v34Ev();
extern void _ZN7S2765C12v1Ev();
extern void _ZN7S2765C12v2Ev();
static  VTBL_ENTRY vtc_S2765C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2765C1[0]),
  (VTBL_ENTRY)&_ZN7S2765C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2765C1D0Ev,
  (VTBL_ENTRY)&_ZN7S2765C22v3Ev,
  (VTBL_ENTRY)&_ZN7S2765C22v4Ev,
  (VTBL_ENTRY)&_ZN7S2765C22v5Ev,
  (VTBL_ENTRY)&_ZN7S2765C22v6Ev,
  (VTBL_ENTRY)&_ZN7S2765C22v7Ev,
  (VTBL_ENTRY)&_ZN7S2765C22v8Ev,
  (VTBL_ENTRY)&_ZN7S2765C22v9Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v10Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v11Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v12Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v13Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v14Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v15Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v16Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v17Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v18Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v19Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v20Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v21Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v22Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v23Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v24Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v25Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v26Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v27Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v28Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v29Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v30Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v31Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v32Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v33Ev,
  (VTBL_ENTRY)&_ZN7S2765C23v34Ev,
  (VTBL_ENTRY)&_ZN7S2765C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2765C12v2Ev,
};
extern VTBL_ENTRY _ZTI7S2765C1[];
extern  VTBL_ENTRY _ZTV7S2765C1[];
Class_Descriptor cd_S2765C1 = {  "S2765C1", // class name
  bases_S2765C1, 2,
  &(vtc_S2765C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1096,940), // object size
  NSPAIRA(_ZTI7S2765C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2765C1),38, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20979C5  {
  char s20979c5f0;
  __tsi64 s20979c5f1;
  virtual void  v7(); // _ZN8S20979C52v7Ev
  virtual void  v8(); // _ZN8S20979C52v8Ev
  ~S20979C5(); // tgen
  S20979C5(); // tgen
};
//SIG(-1 S20979C5) C1{ v1 v2 Fc FL}


void  S20979C5 ::v7(){vfunc_called(this, "_ZN8S20979C52v7Ev");}
void  S20979C5 ::v8(){vfunc_called(this, "_ZN8S20979C52v8Ev");}
S20979C5 ::~S20979C5(){ note_dtor("S20979C5", this);} // tgen
S20979C5 ::S20979C5(){ note_ctor("S20979C5", this);} // tgen

static void Test_S20979C5()
{
  extern Class_Descriptor cd_S20979C5;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(4,5)];
    init_test(&cd_S20979C5, buf);
    S20979C5 *dp, &lv = *(dp=new (buf) S20979C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S20979C5)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20979C5)");
    check_field_offset(lv, s20979c5f0, ABISELECT(8,4), "S20979C5.s20979c5f0");
    check_field_offset(lv, s20979c5f1, ABISELECT(16,8), "S20979C5.s20979c5f1");
    test_class_info(&lv, &cd_S20979C5);
    dp->~S20979C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20979C5(Test_S20979C5, "S20979C5", ABISELECT(24,16));

#else // __cplusplus

extern void _ZN8S20979C5C1Ev();
extern void _ZN8S20979C5D1Ev();
Name_Map name_map_S20979C5[] = {
  NSPAIR(_ZN8S20979C5C1Ev),
  NSPAIR(_ZN8S20979C5D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S20979C5[];
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY vtc_S20979C5[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C5[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
Class_Descriptor cd_S20979C5 = {  "S20979C5", // class name
  0,0,//no base classes
  &(vtc_S20979C5[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(24,16), // object size
  NSPAIRA(_ZTI8S20979C5),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S20979C5),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20979C4  : S20979C5 {
  void *s20979c4f0[2];
  virtual void  v9(); // _ZN8S20979C42v9Ev
  virtual void  v10(); // _ZN8S20979C43v10Ev
  virtual void  v11(); // _ZN8S20979C43v11Ev
  virtual void  v12(); // _ZN8S20979C43v12Ev
  virtual void  v13(); // _ZN8S20979C43v13Ev
  virtual void  v14(); // _ZN8S20979C43v14Ev
  virtual void  v15(); // _ZN8S20979C43v15Ev
  virtual void  v16(); // _ZN8S20979C43v16Ev
  ~S20979C4(); // tgen
  S20979C4(); // tgen
};
//SIG(-1 S20979C4) C1{ BC2{ v9 v10 Fc FL} v1 v2 v3 v4 v5 v6 v7 v8 Fp[2]}


void  S20979C4 ::v9(){vfunc_called(this, "_ZN8S20979C42v9Ev");}
void  S20979C4 ::v10(){vfunc_called(this, "_ZN8S20979C43v10Ev");}
void  S20979C4 ::v11(){vfunc_called(this, "_ZN8S20979C43v11Ev");}
void  S20979C4 ::v12(){vfunc_called(this, "_ZN8S20979C43v12Ev");}
void  S20979C4 ::v13(){vfunc_called(this, "_ZN8S20979C43v13Ev");}
void  S20979C4 ::v14(){vfunc_called(this, "_ZN8S20979C43v14Ev");}
void  S20979C4 ::v15(){vfunc_called(this, "_ZN8S20979C43v15Ev");}
void  S20979C4 ::v16(){vfunc_called(this, "_ZN8S20979C43v16Ev");}
S20979C4 ::~S20979C4(){ note_dtor("S20979C4", this);} // tgen
S20979C4 ::S20979C4(){ note_ctor("S20979C4", this);} // tgen

static void Test_S20979C4()
{
  extern Class_Descriptor cd_S20979C4;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,7)];
    init_test(&cd_S20979C4, buf);
    S20979C4 *dp, &lv = *(dp=new (buf) S20979C4());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,24), "sizeof(S20979C4)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20979C4)");
    check_base_class_offset(lv, (S20979C5*), 0, "S20979C4");
    check_field_offset(lv, s20979c4f0, ABISELECT(24,16), "S20979C4.s20979c4f0");
    test_class_info(&lv, &cd_S20979C4);
    dp->~S20979C4();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20979C4(Test_S20979C4, "S20979C4", ABISELECT(40,24));

#else // __cplusplus

extern void _ZN8S20979C4C1Ev();
extern void _ZN8S20979C4D1Ev();
Name_Map name_map_S20979C4[] = {
  NSPAIR(_ZN8S20979C4C1Ev),
  NSPAIR(_ZN8S20979C4D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
static Base_Class bases_S20979C4[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20979C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20979C4[];
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY vtc_S20979C4[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C4[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern VTBL_ENTRY _ZTI8S20979C4[];
extern  VTBL_ENTRY _ZTV8S20979C4[];
Class_Descriptor cd_S20979C4 = {  "S20979C4", // class name
  bases_S20979C4, 1,
  &(vtc_S20979C4[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,24), // object size
  NSPAIRA(_ZTI8S20979C4),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV8S20979C4),12, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20979C6  : virtual S20979C4 , S20979C5 {
  void *s20979c6f0;
  virtual void  v17(); // _ZN8S20979C63v17Ev
  virtual void  v18(); // _ZN8S20979C63v18Ev
  virtual void  v19(); // _ZN8S20979C63v19Ev
  virtual void  v20(); // _ZN8S20979C63v20Ev
  ~S20979C6(); // tgen
  S20979C6(); // tgen
};
//SIG(-1 S20979C6) C1{ VBC2{ BC3{ v5 v6 Fc FL} v7 v8 v9 v10 v11 v12 v13 v14 Fp[2]} BC3 v1 v2 v3 v4 Fp}


void  S20979C6 ::v17(){vfunc_called(this, "_ZN8S20979C63v17Ev");}
void  S20979C6 ::v18(){vfunc_called(this, "_ZN8S20979C63v18Ev");}
void  S20979C6 ::v19(){vfunc_called(this, "_ZN8S20979C63v19Ev");}
void  S20979C6 ::v20(){vfunc_called(this, "_ZN8S20979C63v20Ev");}
S20979C6 ::~S20979C6(){ note_dtor("S20979C6", this);} // tgen
S20979C6 ::S20979C6(){ note_ctor("S20979C6", this);} // tgen

static void Test_S20979C6()
{
  extern Class_Descriptor cd_S20979C6;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(10,12)];
    init_test(&cd_S20979C6, buf);
    S20979C6 *dp, &lv = *(dp=new (buf) S20979C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(72,44), "sizeof(S20979C6)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20979C6)");
    check_base_class_offset(lv, (S20979C5*)(S20979C4*), ABISELECT(32,20), "S20979C6");
    check_base_class_offset(lv, (S20979C4*), ABISELECT(32,20), "S20979C6");
    /*is_ambiguous_... S20979C6::S20979C5 */ AMB_check_base_class_offset(lv, (S20979C5*), 0, "S20979C6");
    check_field_offset(lv, s20979c6f0, ABISELECT(24,16), "S20979C6.s20979c6f0");
    test_class_info(&lv, &cd_S20979C6);
    dp->~S20979C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20979C6(Test_S20979C6, "S20979C6", ABISELECT(72,44));

#else // __cplusplus

extern void _ZN8S20979C6C1Ev();
extern void _ZN8S20979C6D1Ev();
Name_Map name_map_S20979C6[] = {
  NSPAIR(_ZN8S20979C6C1Ev),
  NSPAIR(_ZN8S20979C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C4;
extern VTBL_ENTRY _ZTI8S20979C4[];
extern  VTBL_ENTRY _ZTV8S20979C4[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
static Base_Class bases_S20979C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20979C5,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20979C4,    ABISELECT(32,20), //bcp->offset
    9, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20979C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20979C6[];
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY vtc_S20979C6[] = {
  ABISELECT(32,20),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern VTBL_ENTRY _ZTV8S20979C6[];
static  VTT_ENTRY vtt_S20979C6[] = {
  {&(_ZTV8S20979C6[3]),  3,31},
  {&(_ZTV8S20979C6[21]),  21,31},
};
extern VTBL_ENTRY _ZTI8S20979C6[];
extern  VTBL_ENTRY _ZTV8S20979C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C6[];
Class_Descriptor cd_S20979C6 = {  "S20979C6", // class name
  bases_S20979C6, 3,
  &(vtc_S20979C6[0]), // expected_vtbl_contents
  &(vtt_S20979C6[0]), // expected_vtt_contents
  ABISELECT(72,44), // object size
  NSPAIRA(_ZTI8S20979C6),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S20979C6),31, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20979C6),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20979C7  : S20979C4 , virtual S20979C5 {
  virtual void  v21(); // _ZN8S20979C73v21Ev
  virtual void  v22(); // _ZN8S20979C73v22Ev
  ~S20979C7(); // tgen
  S20979C7(); // tgen
};
//SIG(-1 S20979C7) C1{ BC2{ BC3{ v3 v4 Fc FL} v5 v6 v7 v8 v9 v10 v11 v12 Fp[2]} VBC3 v1 v2}


void  S20979C7 ::v21(){vfunc_called(this, "_ZN8S20979C73v21Ev");}
void  S20979C7 ::v22(){vfunc_called(this, "_ZN8S20979C73v22Ev");}
S20979C7 ::~S20979C7(){ note_dtor("S20979C7", this);} // tgen
S20979C7 ::S20979C7(){ note_ctor("S20979C7", this);} // tgen

static void Test_S20979C7()
{
  extern Class_Descriptor cd_S20979C7;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_S20979C7, buf);
    S20979C7 *dp, &lv = *(dp=new (buf) S20979C7());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(S20979C7)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20979C7)");
    check_base_class_offset(lv, (S20979C5*)(S20979C4*), 0, "S20979C7");
    check_base_class_offset(lv, (S20979C4*), 0, "S20979C7");
    /*is_ambiguous_... S20979C7::S20979C5 */ AMB_check_base_class_offset(lv, (S20979C5*), ABISELECT(40,24), "S20979C7");
    test_class_info(&lv, &cd_S20979C7);
    dp->~S20979C7();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20979C7(Test_S20979C7, "S20979C7", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN8S20979C7C1Ev();
extern void _ZN8S20979C7D1Ev();
Name_Map name_map_S20979C7[] = {
  NSPAIR(_ZN8S20979C7C1Ev),
  NSPAIR(_ZN8S20979C7D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C4;
extern VTBL_ENTRY _ZTI8S20979C4[];
extern  VTBL_ENTRY _ZTV8S20979C4[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
static Base_Class bases_S20979C7[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20979C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20979C4,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20979C5,    ABISELECT(40,24), //bcp->offset
    15, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20979C7[];
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY vtc_S20979C7[] = {
  ABISELECT(40,24),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C7[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
  0,
  0,
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI8S20979C7[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern VTBL_ENTRY _ZTV8S20979C7[];
static  VTT_ENTRY vtt_S20979C7[] = {
  {&(_ZTV8S20979C7[3]),  3,21},
  {&(_ZTV8S20979C7[19]),  19,21},
};
extern VTBL_ENTRY _ZTI8S20979C7[];
extern  VTBL_ENTRY _ZTV8S20979C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C7[];
Class_Descriptor cd_S20979C7 = {  "S20979C7", // class name
  bases_S20979C7, 3,
  &(vtc_S20979C7[0]), // expected_vtbl_contents
  &(vtt_S20979C7[0]), // expected_vtt_contents
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI8S20979C7),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S20979C7),21, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20979C7),2, //virtual table table var
  3, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20979C9  : virtual S20979C7 , virtual S20979C4 , S20979C5 {
  int s20979c9f0;
  void *s20979c9f1;
  char s20979c9f2;
  virtual void  v23(); // _ZN8S20979C93v23Ev
  ~S20979C9(); // tgen
  S20979C9(); // tgen
};
//SIG(-1 S20979C9) C1{ VBC2{ BC3{ BC4{ v2 v3 Fc FL} v4 v5 v6 v7 v8 v9 v10 v11 Fp[2]} VBC4 v12 v13} VBC3 BC4 v1 Fi Fp Fc}


void  S20979C9 ::v23(){vfunc_called(this, "_ZN8S20979C93v23Ev");}
S20979C9 ::~S20979C9(){ note_dtor("S20979C9", this);} // tgen
S20979C9 ::S20979C9(){ note_ctor("S20979C9", this);} // tgen

static void Test_S20979C9()
{
  extern Class_Descriptor cd_S20979C9;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(20,24)];
    init_test(&cd_S20979C9, buf);
    S20979C9 *dp, &lv = *(dp=new (buf) S20979C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(152,92), "sizeof(S20979C9)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20979C9)");
    check_base_class_offset(lv, (S20979C5*)(S20979C4*)(S20979C7*), ABISELECT(48,28), "S20979C9");
    check_base_class_offset(lv, (S20979C4*)(S20979C7*), ABISELECT(48,28), "S20979C9");
    /*is_ambiguous_... S20979C7::S20979C5 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C7*), ABISELECT(88,52), "S20979C9");
    check_base_class_offset(lv, (S20979C7*), ABISELECT(48,28), "S20979C9");
    /*is_ambiguous_... S20979C9::S20979C4 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C4*), ABISELECT(112,68), "S20979C9");
    /*is_ambiguous_... S20979C9::S20979C4 */ AMB_check_base_class_offset(lv, (S20979C4*), ABISELECT(112,68), "S20979C9");
    /*is_ambiguous_... S20979C9::S20979C5 */ AMB_check_base_class_offset(lv, (S20979C5*), 0, "S20979C9");
    check_field_offset(lv, s20979c9f0, ABISELECT(24,16), "S20979C9.s20979c9f0");
    check_field_offset(lv, s20979c9f1, ABISELECT(32,20), "S20979C9.s20979c9f1");
    check_field_offset(lv, s20979c9f2, ABISELECT(40,24), "S20979C9.s20979c9f2");
    test_class_info(&lv, &cd_S20979C9);
    dp->~S20979C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20979C9(Test_S20979C9, "S20979C9", ABISELECT(152,92));

#else // __cplusplus

extern void _ZN8S20979C9C1Ev();
extern void _ZN8S20979C9D1Ev();
Name_Map name_map_S20979C9[] = {
  NSPAIR(_ZN8S20979C9C1Ev),
  NSPAIR(_ZN8S20979C9D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C4;
extern VTBL_ENTRY _ZTI8S20979C4[];
extern  VTBL_ENTRY _ZTV8S20979C4[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C7;
extern VTBL_ENTRY _ZTI8S20979C7[];
extern  VTBL_ENTRY _ZTV8S20979C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C7[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C4;
extern VTBL_ENTRY _ZTI8S20979C4[];
extern  VTBL_ENTRY _ZTV8S20979C4[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
static Base_Class bases_S20979C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20979C5,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20979C4,    ABISELECT(48,28), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(88,52), //bcp->offset
    35, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20979C7,    ABISELECT(48,28), //bcp->offset
    8, //bcp->virtual_function_table_offset
    15, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20979C5,    ABISELECT(112,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20979C4,    ABISELECT(112,68), //bcp->offset
    41, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20979C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20979C9[];
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY vtc_S20979C9[] = {
  ABISELECT(112,68),
  ABISELECT(88,52),
  ABISELECT(48,28),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(-48,-28),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
  0,
  0,
  ABISELECT(-88,-52),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-112,-68),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern VTBL_ENTRY _ZTV8S20979C9[];
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C9[] = {
  ABISELECT(40,24),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C7[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A1__8S20979C7__8S20979C9[] = {
  0,
  0,
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI8S20979C7[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
static  VTT_ENTRY vtt_S20979C9[] = {
  {&(_ZTV8S20979C9[5]),  5,63},
  {&(_ZTV8S20979C9[23]),  23,63},
  {&(_ZTV8S20979C9[39]),  39,63},
  {&(_ZTV8S20979C9[53]),  53,63},
  {&(_tg__ZTV8S20979C7__8S20979C9[3]),  3,15},
  {&(_tg__ZTV8S20979C5__A1__8S20979C7__8S20979C9[4]),  4,6},
};
extern VTBL_ENTRY _ZTI8S20979C9[];
extern  VTBL_ENTRY _ZTV8S20979C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C9[];
Class_Descriptor cd_S20979C9 = {  "S20979C9", // class name
  bases_S20979C9, 7,
  &(vtc_S20979C9[0]), // expected_vtbl_contents
  &(vtt_S20979C9[0]), // expected_vtt_contents
  ABISELECT(152,92), // object size
  NSPAIRA(_ZTI8S20979C9),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S20979C9),63, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20979C9),6, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20979C8  : virtual S20979C5 , S20979C6 , S20979C9 , S20979C4 {
  virtual void  v24(); // _ZN8S20979C83v24Ev
  ~S20979C8(); // tgen
  S20979C8(); // tgen
};
//SIG(-1 S20979C8) C1{ VBC2{ v2 v3 Fc FL} BC3{ VBC4{ BC2 v4 v5 v6 v7 v8 v9 v10 v11 Fp[2]} BC2 v12 v13 v14 v15 Fp} BC5{ VBC6{ BC4 VBC2 v16 v17} VBC4 BC2 v18 Fi Fp Fc} BC4 v1}


void  S20979C8 ::v24(){vfunc_called(this, "_ZN8S20979C83v24Ev");}
S20979C8 ::~S20979C8(){ note_dtor("S20979C8", this);} // tgen
S20979C8 ::S20979C8(){ note_ctor("S20979C8", this);} // tgen

static void Test_S20979C8()
{
  extern Class_Descriptor cd_S20979C8;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(29,35)];
    init_test(&cd_S20979C8, buf);
    S20979C8 *dp, &lv = *(dp=new (buf) S20979C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(224,136), "sizeof(S20979C8)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20979C8)");
    /*is_ambiguous_... S20979C8::S20979C5 */ AMB_check_base_class_offset(lv, (S20979C5*), ABISELECT(120,72), "S20979C8");
    /*is_ambiguous_... S20979C7::S20979C5 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C7*), ABISELECT(120,72), "S20979C8");
    /*is_ambiguous_... S20979C8::S20979C4 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C4*), ABISELECT(144,88), "S20979C8");
    check_base_class_offset(lv, (S20979C4*)(S20979C6*), ABISELECT(144,88), "S20979C8");
    /*is_ambiguous_... S20979C9::S20979C4 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C9*), ABISELECT(144,88), "S20979C8");
    /*is_ambiguous_... S20979C6::S20979C5 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C6*), 0, "S20979C8");
    check_base_class_offset(lv, (S20979C6*), 0, "S20979C8");
    check_base_class_offset(lv, (S20979C5*)(S20979C4*)(S20979C7*), ABISELECT(184,112), "S20979C8");
    check_base_class_offset(lv, (S20979C4*)(S20979C7*), ABISELECT(184,112), "S20979C8");
    check_base_class_offset(lv, (S20979C7*)(S20979C9*), ABISELECT(184,112), "S20979C8");
    /*is_ambiguous_... S20979C9::S20979C5 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C9*), ABISELECT(32,20), "S20979C8");
    check_base_class_offset(lv, (S20979C9*), ABISELECT(32,20), "S20979C8");
    /*is_ambiguous_... S20979C8::S20979C4 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C4*), ABISELECT(80,48), "S20979C8");
    /*is_ambiguous_... S20979C8::S20979C4 */ AMB_check_base_class_offset(lv, (S20979C4*), ABISELECT(80,48), "S20979C8");
    test_class_info(&lv, &cd_S20979C8);
    dp->~S20979C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20979C8(Test_S20979C8, "S20979C8", ABISELECT(224,136));

#else // __cplusplus

extern void _ZN8S20979C8C1Ev();
extern void _ZN8S20979C8D1Ev();
Name_Map name_map_S20979C8[] = {
  NSPAIR(_ZN8S20979C8C1Ev),
  NSPAIR(_ZN8S20979C8D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C4;
extern VTBL_ENTRY _ZTI8S20979C4[];
extern  VTBL_ENTRY _ZTV8S20979C4[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C6;
extern VTBL_ENTRY _ZTI8S20979C6[];
extern  VTBL_ENTRY _ZTV8S20979C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C6[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C4;
extern VTBL_ENTRY _ZTI8S20979C4[];
extern  VTBL_ENTRY _ZTV8S20979C4[];
extern Class_Descriptor cd_S20979C7;
extern VTBL_ENTRY _ZTI8S20979C7[];
extern  VTBL_ENTRY _ZTV8S20979C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C7[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C9;
extern VTBL_ENTRY _ZTI8S20979C9[];
extern  VTBL_ENTRY _ZTV8S20979C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C9[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C4;
extern VTBL_ENTRY _ZTI8S20979C4[];
extern  VTBL_ENTRY _ZTV8S20979C4[];
static Base_Class bases_S20979C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20979C5,    ABISELECT(120,72), //bcp->offset
    32, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20979C5,    ABISELECT(144,88), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S20979C4,    ABISELECT(144,88), //bcp->offset
    38, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    4, //immediately_derived
  0, 1},
  {&cd_S20979C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20979C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20979C5,    ABISELECT(184,112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S20979C4,    ABISELECT(184,112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20979C7,    ABISELECT(184,112), //bcp->offset
    60, //bcp->virtual_function_table_offset
    15, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    9, //immediately_derived
  0, 1},
  {&cd_S20979C5,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20979C9,    ABISELECT(32,20), //bcp->offset
    12, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20979C5,    ABISELECT(80,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20979C4,    ABISELECT(80,48), //bcp->offset
    20, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20979C8[];
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY vtc_S20979C8[] = {
  ABISELECT(184,112),
  ABISELECT(120,72),
  ABISELECT(144,88),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
  ABISELECT(112,68),
  ABISELECT(88,52),
  ABISELECT(152,92),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
  ABISELECT(-80,-48),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  0,
  0,
  ABISELECT(-120,-72),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-144,-88),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-64,-40),
  ABISELECT(-184,-112),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern VTBL_ENTRY _ZTV8S20979C8[];
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C6__8S20979C8[] = {
  ABISELECT(144,88),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C6__8S20979C8[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-144,-88),
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C9__8S20979C8[] = {
  ABISELECT(112,68),
  ABISELECT(88,52),
  ABISELECT(152,92),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C9__8S20979C8[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-64,-40),
  ABISELECT(-152,-92),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A1__8S20979C9__8S20979C8[] = {
  0,
  0,
  ABISELECT(-88,-52),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__A1__8S20979C9__8S20979C8[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-112,-68),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C8[] = {
  ABISELECT(-64,-40),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C7[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A1__8S20979C7__8S20979C8[] = {
  0,
  0,
  ABISELECT(64,40),
  (VTBL_ENTRY)&(_ZTI8S20979C7[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
static  VTT_ENTRY vtt_S20979C8[] = {
  {&(_ZTV8S20979C8[5]),  5,87},
  {&(_tg__ZTV8S20979C6__8S20979C8[3]),  3,9},
  {&(_tg__ZTV8S20979C4__8S20979C6__8S20979C8[12]),  12,22},
  {&(_tg__ZTV8S20979C9__8S20979C8[5]),  5,8},
  {&(_tg__ZTV8S20979C7__8S20979C9__8S20979C8[15]),  15,27},
  {&(_tg__ZTV8S20979C5__A1__8S20979C9__8S20979C8[4]),  4,6},
  {&(_tg__ZTV8S20979C4__A1__8S20979C9__8S20979C8[12]),  12,22},
  {&(_ZTV8S20979C8[36]),  36,87},
  {&(_ZTV8S20979C8[50]),  50,87},
  {&(_ZTV8S20979C8[17]),  17,87},
  {&(_ZTV8S20979C8[75]),  75,87},
  {&(_tg__ZTV8S20979C7__8S20979C8[3]),  3,15},
  {&(_tg__ZTV8S20979C5__A1__8S20979C7__8S20979C8[4]),  4,6},
};
extern VTBL_ENTRY _ZTI8S20979C8[];
extern  VTBL_ENTRY _ZTV8S20979C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C8[];
Class_Descriptor cd_S20979C8 = {  "S20979C8", // class name
  bases_S20979C8, 12,
  &(vtc_S20979C8[0]), // expected_vtbl_contents
  &(vtt_S20979C8[0]), // expected_vtt_contents
  ABISELECT(224,136), // object size
  NSPAIRA(_ZTI8S20979C8),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S20979C8),87, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20979C8),13, //virtual table table var
  12, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20979C3  : virtual S20979C4 , S20979C6 , virtual S20979C7 , S20979C8 , S20979C5 {
  virtual void  v25(); // _ZN8S20979C33v25Ev
  virtual void  v26(); // _ZN8S20979C33v26Ev
  virtual void  v27(); // _ZN8S20979C33v27Ev
  virtual void  v28(); // _ZN8S20979C33v28Ev
  virtual void  v29(); // _ZN8S20979C33v29Ev
  virtual void  v30(); // _ZN8S20979C33v30Ev
  virtual void  v31(); // _ZN8S20979C33v31Ev
  virtual void  v32(); // _ZN8S20979C33v32Ev
  virtual void  v33(); // _ZN8S20979C33v33Ev
  ~S20979C3(); // tgen
  S20979C3(); // tgen
};
//SIG(-1 S20979C3) C1{ VBC2{ BC3{ v10 v11 Fc FL} v12 v13 v14 v15 v16 v17 v18 v19 Fp[2]} BC4{ VBC2 BC3 v20 v21 v22 v23 Fp} VBC5{ BC2 VBC3 v24 v25} BC6{ VBC3 BC4 BC7{ VBC5 VBC2 BC3 v26 Fi Fp Fc} BC2 v27} BC3 v1 v2 v3 v4 v5 v6 v7 v8 v9}


void  S20979C3 ::v25(){vfunc_called(this, "_ZN8S20979C33v25Ev");}
void  S20979C3 ::v26(){vfunc_called(this, "_ZN8S20979C33v26Ev");}
void  S20979C3 ::v27(){vfunc_called(this, "_ZN8S20979C33v27Ev");}
void  S20979C3 ::v28(){vfunc_called(this, "_ZN8S20979C33v28Ev");}
void  S20979C3 ::v29(){vfunc_called(this, "_ZN8S20979C33v29Ev");}
void  S20979C3 ::v30(){vfunc_called(this, "_ZN8S20979C33v30Ev");}
void  S20979C3 ::v31(){vfunc_called(this, "_ZN8S20979C33v31Ev");}
void  S20979C3 ::v32(){vfunc_called(this, "_ZN8S20979C33v32Ev");}
void  S20979C3 ::v33(){vfunc_called(this, "_ZN8S20979C33v33Ev");}
S20979C3 ::~S20979C3(){ note_dtor("S20979C3", this);} // tgen
S20979C3 ::S20979C3(){ note_ctor("S20979C3", this);} // tgen

static void Test_S20979C3()
{
  extern Class_Descriptor cd_S20979C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(36,44)];
    init_test(&cd_S20979C3, buf);
    S20979C3 *dp, &lv = *(dp=new (buf) S20979C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(280,172), "sizeof(S20979C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20979C3)");
    /*is_ambiguous_... S20979C3::S20979C4 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C4*), ABISELECT(176,108), "S20979C3");
    /*is_ambiguous_... S20979C3::S20979C4 */ AMB_check_base_class_offset(lv, (S20979C4*), ABISELECT(176,108), "S20979C3");
    /*is_ambiguous_... S20979C3::S20979C6 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C6*), ABISELECT(176,108), "S20979C3");
    check_base_class_offset(lv, (S20979C4*)(S20979C6*)(S20979C8*), ABISELECT(176,108), "S20979C3");
    /*is_ambiguous_... S20979C9::S20979C4 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C9*)(S20979C8*), ABISELECT(176,108), "S20979C3");
    /*is_ambiguous_... S20979C3::S20979C6 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C6*), 0, "S20979C3");
    /*is_ambiguous_... S20979C3::S20979C6 */ AMB_check_base_class_offset(lv, (S20979C6*), 0, "S20979C3");
    check_base_class_offset(lv, (S20979C5*)(S20979C4*)(S20979C7*), ABISELECT(216,132), "S20979C3");
    check_base_class_offset(lv, (S20979C4*)(S20979C7*), ABISELECT(216,132), "S20979C3");
    /*is_ambiguous_... S20979C7::S20979C5 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C7*), ABISELECT(256,156), "S20979C3");
    /*is_ambiguous_... S20979C8::S20979C5 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C8*), ABISELECT(256,156), "S20979C3");
    check_base_class_offset(lv, (S20979C7*), ABISELECT(216,132), "S20979C3");
    check_base_class_offset(lv, (S20979C7*)(S20979C9*)(S20979C8*), ABISELECT(216,132), "S20979C3");
    /*is_ambiguous_... S20979C6::S20979C5 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C6*)(S20979C8*), ABISELECT(32,20), "S20979C3");
    check_base_class_offset(lv, (S20979C6*)(S20979C8*), ABISELECT(32,20), "S20979C3");
    /*is_ambiguous_... S20979C9::S20979C5 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C9*)(S20979C8*), ABISELECT(64,40), "S20979C3");
    check_base_class_offset(lv, (S20979C9*)(S20979C8*), ABISELECT(64,40), "S20979C3");
    /*is_ambiguous_... S20979C8::S20979C4 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C4*)(S20979C8*), ABISELECT(112,68), "S20979C3");
    /*is_ambiguous_... S20979C8::S20979C4 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C8*), ABISELECT(112,68), "S20979C3");
    check_base_class_offset(lv, (S20979C8*), ABISELECT(32,20), "S20979C3");
    /*is_ambiguous_... S20979C3::S20979C5 */ AMB_check_base_class_offset(lv, (S20979C5*), ABISELECT(152,92), "S20979C3");
    test_class_info(&lv, &cd_S20979C3);
    dp->~S20979C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20979C3(Test_S20979C3, "S20979C3", ABISELECT(280,172));

#else // __cplusplus

extern void _ZN8S20979C3C1Ev();
extern void _ZN8S20979C3D1Ev();
Name_Map name_map_S20979C3[] = {
  NSPAIR(_ZN8S20979C3C1Ev),
  NSPAIR(_ZN8S20979C3D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C4;
extern VTBL_ENTRY _ZTI8S20979C4[];
extern  VTBL_ENTRY _ZTV8S20979C4[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C6;
extern VTBL_ENTRY _ZTI8S20979C6[];
extern  VTBL_ENTRY _ZTV8S20979C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C6[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C4;
extern VTBL_ENTRY _ZTI8S20979C4[];
extern  VTBL_ENTRY _ZTV8S20979C4[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C7;
extern VTBL_ENTRY _ZTI8S20979C7[];
extern  VTBL_ENTRY _ZTV8S20979C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C7[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C6;
extern VTBL_ENTRY _ZTI8S20979C6[];
extern  VTBL_ENTRY _ZTV8S20979C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C6[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C9;
extern VTBL_ENTRY _ZTI8S20979C9[];
extern  VTBL_ENTRY _ZTV8S20979C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C9[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C4;
extern VTBL_ENTRY _ZTI8S20979C4[];
extern  VTBL_ENTRY _ZTV8S20979C4[];
extern Class_Descriptor cd_S20979C8;
extern VTBL_ENTRY _ZTI8S20979C8[];
extern  VTBL_ENTRY _ZTV8S20979C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C8[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
static Base_Class bases_S20979C3[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20979C5,    ABISELECT(176,108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20979C4,    ABISELECT(176,108), //bcp->offset
    56, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20979C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20979C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20979C5,    ABISELECT(216,132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20979C4,    ABISELECT(216,132), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(256,156), //bcp->offset
    105, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S20979C7,    ABISELECT(216,132), //bcp->offset
    78, //bcp->virtual_function_table_offset
    15, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20979C5,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20979C6,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(64,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20979C9,    ABISELECT(64,40), //bcp->offset
    32, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(112,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20979C4,    ABISELECT(112,68), //bcp->offset
    40, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20979C8,    ABISELECT(32,20), //bcp->offset
    20, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20979C5,    ABISELECT(152,92), //bcp->offset
    52, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S20979C3[];
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C33v25Ev();
extern void _ZN8S20979C33v26Ev();
extern void _ZN8S20979C33v27Ev();
extern void _ZN8S20979C33v28Ev();
extern void _ZN8S20979C33v29Ev();
extern void _ZN8S20979C33v30Ev();
extern void _ZN8S20979C33v31Ev();
extern void _ZN8S20979C33v32Ev();
extern void _ZN8S20979C33v33Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY vtc_S20979C3[] = {
  ABISELECT(256,156),
  ABISELECT(216,132),
  ABISELECT(176,108),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v25Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v26Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v27Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v28Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v29Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v30Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v31Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v32Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v33Ev,
  ABISELECT(184,112),
  ABISELECT(224,136),
  ABISELECT(144,88),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
  ABISELECT(112,68),
  ABISELECT(192,116),
  ABISELECT(152,92),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
  ABISELECT(-112,-68),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  ABISELECT(-152,-92),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-176,-108),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(-216,-132),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
  0,
  0,
  ABISELECT(-256,-156),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern VTBL_ENTRY _ZTV8S20979C3[];
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C6__8S20979C3[] = {
  ABISELECT(176,108),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C6__8S20979C3[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-176,-108),
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C8__8S20979C3[] = {
  ABISELECT(184,112),
  ABISELECT(224,136),
  ABISELECT(144,88),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C68S20979C8__A1__8S20979C3[] = {
  ABISELECT(144,88),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C68S20979C8__A1__8S20979C3[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-144,-88),
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C98S20979C8__8S20979C3[] = {
  ABISELECT(112,68),
  ABISELECT(192,116),
  ABISELECT(152,92),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C98S20979C8__8S20979C3[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(-152,-92),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A1__8S20979C98S20979C8__8S20979C3[] = {
  0,
  0,
  ABISELECT(-192,-116),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__A1__8S20979C98S20979C8__8S20979C3[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-112,-68),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__8S20979C8__8S20979C3[] = {
  0,
  0,
  ABISELECT(-224,-136),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C8__8S20979C3[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-144,-88),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C9__8S20979C8__8S20979C3[] = {
  ABISELECT(112,68),
  ABISELECT(192,116),
  ABISELECT(152,92),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C8__8S20979C3[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(-184,-112),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C3[] = {
  ABISELECT(40,24),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C7[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A1__8S20979C7__8S20979C3[] = {
  0,
  0,
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI8S20979C7[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
static  VTT_ENTRY vtt_S20979C3[] = {
  {&(_ZTV8S20979C3[5]),  5,111},
  {&(_tg__ZTV8S20979C6__8S20979C3[3]),  3,9},
  {&(_tg__ZTV8S20979C4__8S20979C6__8S20979C3[12]),  12,22},
  {&(_tg__ZTV8S20979C8__8S20979C3[5]),  5,12},
  {&(_tg__ZTV8S20979C68S20979C8__A1__8S20979C3[3]),  3,9},
  {&(_tg__ZTV8S20979C4__8S20979C68S20979C8__A1__8S20979C3[12]),  12,22},
  {&(_tg__ZTV8S20979C98S20979C8__8S20979C3[5]),  5,8},
  {&(_tg__ZTV8S20979C7__8S20979C98S20979C8__8S20979C3[15]),  15,27},
  {&(_tg__ZTV8S20979C5__A1__8S20979C98S20979C8__8S20979C3[4]),  4,6},
  {&(_tg__ZTV8S20979C4__A1__8S20979C98S20979C8__8S20979C3[12]),  12,22},
  {&(_tg__ZTV8S20979C5__8S20979C8__8S20979C3[4]),  4,6},
  {&(_tg__ZTV8S20979C4__8S20979C8__8S20979C3[12]),  12,22},
  {&(_tg__ZTV8S20979C9__8S20979C8__8S20979C3[5]),  5,8},
  {&(_tg__ZTV8S20979C7__8S20979C8__8S20979C3[15]),  15,27},
  {&(_ZTV8S20979C3[68]),  68,111},
  {&(_ZTV8S20979C3[93]),  93,111},
  {&(_ZTV8S20979C3[109]),  109,111},
  {&(_ZTV8S20979C3[25]),  25,111},
  {&(_ZTV8S20979C3[37]),  37,111},
  {&(_tg__ZTV8S20979C7__8S20979C3[3]),  3,15},
  {&(_tg__ZTV8S20979C5__A1__8S20979C7__8S20979C3[4]),  4,6},
};
extern VTBL_ENTRY _ZTI8S20979C3[];
extern  VTBL_ENTRY _ZTV8S20979C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C3[];
Class_Descriptor cd_S20979C3 = {  "S20979C3", // class name
  bases_S20979C3, 16,
  &(vtc_S20979C3[0]), // expected_vtbl_contents
  &(vtt_S20979C3[0]), // expected_vtt_contents
  ABISELECT(280,172), // object size
  NSPAIRA(_ZTI8S20979C3),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S20979C3),111, //virtual function table var
  5, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S20979C3),21, //virtual table table var
  16, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20979C11  {
  char s20979c11f0:8;
  int s20979c11f1[5];
  char  :0;
  char s20979c11f3[4];
  __tsi64 s20979c11f4:8;
  virtual void  v34(); // _ZN9S20979C113v34Ev
  virtual void  v35(); // _ZN9S20979C113v35Ev
  virtual void  v36(); // _ZN9S20979C113v36Ev
  virtual void  v37(); // _ZN9S20979C113v37Ev
  ~S20979C11(); // tgen
  S20979C11(); // tgen
};
//SIG(-1 S20979C11) C1{ v1 v2 v3 v4 Fc:8 Fi[5] Fc:0 Fc[4] FL:8}


void  S20979C11 ::v34(){vfunc_called(this, "_ZN9S20979C113v34Ev");}
void  S20979C11 ::v35(){vfunc_called(this, "_ZN9S20979C113v35Ev");}
void  S20979C11 ::v36(){vfunc_called(this, "_ZN9S20979C113v36Ev");}
void  S20979C11 ::v37(){vfunc_called(this, "_ZN9S20979C113v37Ev");}
S20979C11 ::~S20979C11(){ note_dtor("S20979C11", this);} // tgen
S20979C11 ::S20979C11(){ note_ctor("S20979C11", this);} // tgen

static void Test_S20979C11()
{
  extern Class_Descriptor cd_S20979C11;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(6,10)];
    init_test(&cd_S20979C11, buf);
    S20979C11 *dp, &lv = *(dp=new (buf) S20979C11());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(40,36), "sizeof(S20979C11)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20979C11)");
    set_bf_and_test(lv, s20979c11f0, ABISELECT(8,4), 0, 8, 1, "S20979C11");
    set_bf_and_test(lv, s20979c11f0, ABISELECT(8,4), 0, 8, hide_sll(1LL<<7), "S20979C11");
    check_field_offset(lv, s20979c11f1, ABISELECT(12,8), "S20979C11.s20979c11f1");
    check_field_offset(lv, s20979c11f3, ABISELECT(32,28), "S20979C11.s20979c11f3");
    set_bf_and_test(lv, s20979c11f4, ABISELECT(36,32), 0, 8, 1, "S20979C11");
    set_bf_and_test(lv, s20979c11f4, ABISELECT(36,32), 0, 8, hide_sll(1LL<<7), "S20979C11");
    test_class_info(&lv, &cd_S20979C11);
    dp->~S20979C11();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20979C11(Test_S20979C11, "S20979C11", ABISELECT(40,36));

#else // __cplusplus

extern void _ZN9S20979C11C1Ev();
extern void _ZN9S20979C11D1Ev();
Name_Map name_map_S20979C11[] = {
  NSPAIR(_ZN9S20979C11C1Ev),
  NSPAIR(_ZN9S20979C11D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI9S20979C11[];
extern void _ZN9S20979C113v34Ev();
extern void _ZN9S20979C113v35Ev();
extern void _ZN9S20979C113v36Ev();
extern void _ZN9S20979C113v37Ev();
static  VTBL_ENTRY vtc_S20979C11[] = {
  0,
  (VTBL_ENTRY)&(_ZTI9S20979C11[0]),
  (VTBL_ENTRY)&_ZN9S20979C113v34Ev,
  (VTBL_ENTRY)&_ZN9S20979C113v35Ev,
  (VTBL_ENTRY)&_ZN9S20979C113v36Ev,
  (VTBL_ENTRY)&_ZN9S20979C113v37Ev,
};
extern VTBL_ENTRY _ZTI9S20979C11[];
extern  VTBL_ENTRY _ZTV9S20979C11[];
Class_Descriptor cd_S20979C11 = {  "S20979C11", // class name
  0,0,//no base classes
  &(vtc_S20979C11[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(40,36), // object size
  NSPAIRA(_ZTI9S20979C11),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV9S20979C11),6, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20979C12  : virtual S20979C4 , virtual S20979C5 , virtual S20979C7 , virtual S20979C3 , virtual S20979C9 {
  int s20979c12f0;
  __tsi64 s20979c12f1:16;
  virtual void  v38(); // _ZN9S20979C123v38Ev
  virtual void  v39(); // _ZN9S20979C123v39Ev
  virtual void  v40(); // _ZN9S20979C123v40Ev
  virtual void  v41(); // _ZN9S20979C123v41Ev
  virtual void  v42(); // _ZN9S20979C123v42Ev
  ~S20979C12(); // tgen
  S20979C12(); // tgen
};
//SIG(-1 S20979C12) C1{ VBC2{ BC3{ v6 v7 Fc FL} v8 v9 v10 v11 v12 v13 v14 v15 Fp[2]} VBC3 VBC4{ BC2 VBC3 v16 v17} VBC5{ VBC2 BC6{ VBC2 BC3 v18 v19 v20 v21 Fp} VBC4 BC7{ VBC3 BC6 BC8{ VBC4 VBC2 BC3 v22 Fi Fp Fc} BC2 v23} BC3 v24 v25 v26 v27 v28 v29 v30 v31 v32} VBC8 v1 v2 v3 v4 v5 Fi FL:16}


void  S20979C12 ::v38(){vfunc_called(this, "_ZN9S20979C123v38Ev");}
void  S20979C12 ::v39(){vfunc_called(this, "_ZN9S20979C123v39Ev");}
void  S20979C12 ::v40(){vfunc_called(this, "_ZN9S20979C123v40Ev");}
void  S20979C12 ::v41(){vfunc_called(this, "_ZN9S20979C123v41Ev");}
void  S20979C12 ::v42(){vfunc_called(this, "_ZN9S20979C123v42Ev");}
S20979C12 ::~S20979C12(){ note_dtor("S20979C12", this);} // tgen
S20979C12 ::S20979C12(){ note_ctor("S20979C12", this);} // tgen

static void Test_S20979C12()
{
  extern Class_Descriptor cd_S20979C12;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(44,54)];
    init_test(&cd_S20979C12, buf);
    S20979C12 *dp, &lv = *(dp=new (buf) S20979C12());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(344,212), "sizeof(S20979C12)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20979C12)");
    /*is_ambiguous_... S20979C12::S20979C4 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C4*), ABISELECT(16,12), "S20979C12");
    /*is_ambiguous_... S20979C12::S20979C4 */ AMB_check_base_class_offset(lv, (S20979C4*), ABISELECT(16,12), "S20979C12");
    /*is_ambiguous_... S20979C3::S20979C4 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C3*), ABISELECT(16,12), "S20979C12");
    /*is_ambiguous_... S20979C3::S20979C6 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C6*)(S20979C3*), ABISELECT(16,12), "S20979C12");
    check_base_class_offset(lv, (S20979C4*)(S20979C6*)(S20979C8*)(S20979C3*), ABISELECT(16,12), "S20979C12");
    /*is_ambiguous_... S20979C9::S20979C4 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C9*)(S20979C8*)(S20979C3*), ABISELECT(16,12), "S20979C12");
    /*is_ambiguous_... S20979C12::S20979C9 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C9*), ABISELECT(16,12), "S20979C12");
    /*is_ambiguous_... S20979C12::S20979C5 */ AMB_check_base_class_offset(lv, (S20979C5*), ABISELECT(56,36), "S20979C12");
    /*is_ambiguous_... S20979C7::S20979C5 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C7*), ABISELECT(56,36), "S20979C12");
    /*is_ambiguous_... S20979C8::S20979C5 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C8*)(S20979C3*), ABISELECT(56,36), "S20979C12");
    check_base_class_offset(lv, (S20979C5*)(S20979C4*)(S20979C7*), ABISELECT(80,52), "S20979C12");
    check_base_class_offset(lv, (S20979C4*)(S20979C7*), ABISELECT(80,52), "S20979C12");
    check_base_class_offset(lv, (S20979C7*), ABISELECT(80,52), "S20979C12");
    check_base_class_offset(lv, (S20979C7*)(S20979C3*), ABISELECT(80,52), "S20979C12");
    check_base_class_offset(lv, (S20979C7*)(S20979C9*)(S20979C8*)(S20979C3*), ABISELECT(80,52), "S20979C12");
    /*is_ambiguous_... S20979C12::S20979C9 */ AMB_check_base_class_offset(lv, (S20979C7*)(S20979C9*), ABISELECT(80,52), "S20979C12");
    /*is_ambiguous_... S20979C3::S20979C6 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C6*)(S20979C3*), ABISELECT(120,76), "S20979C12");
    /*is_ambiguous_... S20979C3::S20979C6 */ AMB_check_base_class_offset(lv, (S20979C6*)(S20979C3*), ABISELECT(120,76), "S20979C12");
    /*is_ambiguous_... S20979C6::S20979C5 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C6*)(S20979C8*)(S20979C3*), ABISELECT(152,96), "S20979C12");
    check_base_class_offset(lv, (S20979C6*)(S20979C8*)(S20979C3*), ABISELECT(152,96), "S20979C12");
    /*is_ambiguous_... S20979C9::S20979C5 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C9*)(S20979C8*)(S20979C3*), ABISELECT(184,116), "S20979C12");
    check_base_class_offset(lv, (S20979C9*)(S20979C8*)(S20979C3*), ABISELECT(184,116), "S20979C12");
    /*is_ambiguous_... S20979C8::S20979C4 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C4*)(S20979C8*)(S20979C3*), ABISELECT(232,144), "S20979C12");
    /*is_ambiguous_... S20979C8::S20979C4 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C8*)(S20979C3*), ABISELECT(232,144), "S20979C12");
    check_base_class_offset(lv, (S20979C8*)(S20979C3*), ABISELECT(152,96), "S20979C12");
    /*is_ambiguous_... S20979C3::S20979C5 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C3*), ABISELECT(272,168), "S20979C12");
    check_base_class_offset(lv, (S20979C3*), ABISELECT(120,76), "S20979C12");
    /*is_ambiguous_... S20979C12::S20979C9 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C9*), ABISELECT(296,184), "S20979C12");
    /*is_ambiguous_... S20979C12::S20979C9 */ AMB_check_base_class_offset(lv, (S20979C9*), ABISELECT(296,184), "S20979C12");
    check_field_offset(lv, s20979c12f0, ABISELECT(8,4), "S20979C12.s20979c12f0");
    set_bf_and_test(lv, s20979c12f1, ABISELECT(12,8), 0, 16, 1, "S20979C12");
    set_bf_and_test(lv, s20979c12f1, ABISELECT(12,8), 0, 16, hide_sll(1LL<<15), "S20979C12");
    test_class_info(&lv, &cd_S20979C12);
    dp->~S20979C12();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20979C12(Test_S20979C12, "S20979C12", ABISELECT(344,212));

#else // __cplusplus

extern void _ZN9S20979C12C1Ev();
extern void _ZN9S20979C12D1Ev();
Name_Map name_map_S20979C12[] = {
  NSPAIR(_ZN9S20979C12C1Ev),
  NSPAIR(_ZN9S20979C12D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C4;
extern VTBL_ENTRY _ZTI8S20979C4[];
extern  VTBL_ENTRY _ZTV8S20979C4[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C4;
extern VTBL_ENTRY _ZTI8S20979C4[];
extern  VTBL_ENTRY _ZTV8S20979C4[];
extern Class_Descriptor cd_S20979C7;
extern VTBL_ENTRY _ZTI8S20979C7[];
extern  VTBL_ENTRY _ZTV8S20979C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C7[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C6;
extern VTBL_ENTRY _ZTI8S20979C6[];
extern  VTBL_ENTRY _ZTV8S20979C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C6[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C6;
extern VTBL_ENTRY _ZTI8S20979C6[];
extern  VTBL_ENTRY _ZTV8S20979C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C6[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C9;
extern VTBL_ENTRY _ZTI8S20979C9[];
extern  VTBL_ENTRY _ZTV8S20979C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C9[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C4;
extern VTBL_ENTRY _ZTI8S20979C4[];
extern  VTBL_ENTRY _ZTV8S20979C4[];
extern Class_Descriptor cd_S20979C8;
extern VTBL_ENTRY _ZTI8S20979C8[];
extern  VTBL_ENTRY _ZTV8S20979C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C8[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C3;
extern VTBL_ENTRY _ZTI8S20979C3[];
extern  VTBL_ENTRY _ZTV8S20979C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C3[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C9;
extern VTBL_ENTRY _ZTI8S20979C9[];
extern  VTBL_ENTRY _ZTV8S20979C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C9[];
static Base_Class bases_S20979C12[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20979C5,    ABISELECT(16,12), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20979C4,    ABISELECT(16,12), //bcp->offset
    12, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20979C5,    ABISELECT(56,36), //bcp->offset
    34, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20979C5,    ABISELECT(80,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S20979C4,    ABISELECT(80,52), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20979C7,    ABISELECT(80,52), //bcp->offset
    40, //bcp->virtual_function_table_offset
    15, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20979C5,    ABISELECT(120,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20979C6,    ABISELECT(120,76), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(152,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20979C6,    ABISELECT(152,96), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(184,116), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20979C9,    ABISELECT(184,116), //bcp->offset
    124, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(232,144), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20979C4,    ABISELECT(232,144), //bcp->offset
    132, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20979C8,    ABISELECT(152,96), //bcp->offset
    112, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(272,168), //bcp->offset
    144, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20979C3,    ABISELECT(120,76), //bcp->offset
    67, //bcp->virtual_function_table_offset
    30, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20979C5,    ABISELECT(296,184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20979C9,    ABISELECT(296,184), //bcp->offset
    148, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20979C12[];
extern void _ZN9S20979C123v38Ev();
extern void _ZN9S20979C123v39Ev();
extern void _ZN9S20979C123v40Ev();
extern void _ZN9S20979C123v41Ev();
extern void _ZN9S20979C123v42Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C33v25Ev();
extern void _ZN8S20979C33v26Ev();
extern void _ZN8S20979C33v27Ev();
extern void _ZN8S20979C33v28Ev();
extern void _ZN8S20979C33v29Ev();
extern void _ZN8S20979C33v30Ev();
extern void _ZN8S20979C33v31Ev();
extern void _ZN8S20979C33v32Ev();
extern void _ZN8S20979C33v33Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY vtc_S20979C12[] = {
  ABISELECT(296,184),
  ABISELECT(120,76),
  ABISELECT(80,52),
  ABISELECT(56,36),
  ABISELECT(16,12),
  0,
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN9S20979C123v38Ev,
  (VTBL_ENTRY)&_ZN9S20979C123v39Ev,
  (VTBL_ENTRY)&_ZN9S20979C123v40Ev,
  (VTBL_ENTRY)&_ZN9S20979C123v41Ev,
  (VTBL_ENTRY)&_ZN9S20979C123v42Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  0,
  0,
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-24,-16),
  ABISELECT(-80,-52),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(64,40),
  ABISELECT(32,20),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-64,-40),
  ABISELECT(-40,-24),
  ABISELECT(-104,-64),
  ABISELECT(-120,-76),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v25Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v26Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v27Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v28Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v29Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v30Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v31Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v32Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v33Ev,
  ABISELECT(-72,-44),
  ABISELECT(-96,-60),
  ABISELECT(-136,-84),
  ABISELECT(-152,-96),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
  ABISELECT(-168,-104),
  ABISELECT(-128,-80),
  ABISELECT(-104,-64),
  ABISELECT(-184,-116),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
  ABISELECT(-232,-144),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  ABISELECT(-272,-168),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  0,
  0,
  0,
  ABISELECT(-280,-172),
  ABISELECT(-240,-148),
  ABISELECT(-216,-132),
  ABISELECT(-296,-184),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern VTBL_ENTRY _ZTV9S20979C12[];
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__9S20979C12[] = {
  ABISELECT(-24,-16),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C7[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A1__8S20979C7__9S20979C12[] = {
  0,
  0,
  ABISELECT(24,16),
  (VTBL_ENTRY)&(_ZTI8S20979C7[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C33v25Ev();
extern void _ZN8S20979C33v26Ev();
extern void _ZN8S20979C33v27Ev();
extern void _ZN8S20979C33v28Ev();
extern void _ZN8S20979C33v29Ev();
extern void _ZN8S20979C33v30Ev();
extern void _ZN8S20979C33v31Ev();
extern void _ZN8S20979C33v32Ev();
extern void _ZN8S20979C33v33Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C3__9S20979C12[] = {
  ABISELECT(-64,-40),
  ABISELECT(-40,-24),
  ABISELECT(-104,-64),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v25Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v26Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v27Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v28Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v29Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v30Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v31Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v32Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v33Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C68S20979C3__9S20979C12[] = {
  ABISELECT(-104,-64),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C68S20979C3__9S20979C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(104,64),
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C88S20979C3__9S20979C12[] = {
  ABISELECT(-72,-44),
  ABISELECT(-96,-60),
  ABISELECT(-136,-84),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C68S20979C88S20979C3__A1__9S20979C12[] = {
  ABISELECT(-136,-84),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C68S20979C88S20979C3__A1__9S20979C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(136,84),
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C98S20979C88S20979C3__9S20979C12[] = {
  ABISELECT(-168,-104),
  ABISELECT(-128,-80),
  ABISELECT(-104,-64),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C98S20979C88S20979C3__9S20979C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-24,-16),
  ABISELECT(104,64),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A1__8S20979C98S20979C88S20979C3__9S20979C12[] = {
  0,
  0,
  ABISELECT(128,80),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__A1__8S20979C98S20979C88S20979C3__9S20979C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(168,104),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__8S20979C88S20979C3__9S20979C12[] = {
  0,
  0,
  ABISELECT(96,60),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C88S20979C3__9S20979C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(136,84),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C9__8S20979C88S20979C3__9S20979C12[] = {
  ABISELECT(-168,-104),
  ABISELECT(-128,-80),
  ABISELECT(-104,-64),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C88S20979C3__9S20979C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-24,-16),
  ABISELECT(72,44),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C3__9S20979C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(104,64),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C3__9S20979C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-24,-16),
  ABISELECT(40,24),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A3__8S20979C3__9S20979C12[] = {
  0,
  0,
  ABISELECT(64,40),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C8__8S20979C3__9S20979C12[] = {
  ABISELECT(-72,-44),
  ABISELECT(-96,-60),
  ABISELECT(-136,-84),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C98S20979C8__8S20979C3__9S20979C12[] = {
  ABISELECT(-168,-104),
  ABISELECT(-128,-80),
  ABISELECT(-104,-64),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C9__A1__9S20979C12[] = {
  ABISELECT(-280,-172),
  ABISELECT(-240,-148),
  ABISELECT(-216,-132),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C9__A1__9S20979C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-24,-16),
  ABISELECT(216,132),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A1__8S20979C9__A1__9S20979C12[] = {
  0,
  0,
  ABISELECT(240,148),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__A1__8S20979C9__A1__9S20979C12[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(280,172),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
static  VTT_ENTRY vtt_S20979C12[] = {
  {&(_ZTV9S20979C12[7]),  7,159},
  {&(_ZTV9S20979C12[24]),  24,159},
  {&(_ZTV9S20979C12[38]),  38,159},
  {&(_ZTV9S20979C12[55]),  55,159},
  {&(_ZTV9S20979C12[97]),  97,159},
  {&(_ZTV9S20979C12[117]),  117,159},
  {&(_ZTV9S20979C12[129]),  129,159},
  {&(_ZTV9S20979C12[134]),  134,159},
  {&(_ZTV9S20979C12[146]),  146,159},
  {&(_ZTV9S20979C12[156]),  156,159},
  {&(_tg__ZTV8S20979C7__9S20979C12[3]),  3,15},
  {&(_tg__ZTV8S20979C5__A1__8S20979C7__9S20979C12[4]),  4,6},
  {&(_tg__ZTV8S20979C3__9S20979C12[5]),  5,20},
  {&(_tg__ZTV8S20979C68S20979C3__9S20979C12[3]),  3,9},
  {&(_tg__ZTV8S20979C4__8S20979C68S20979C3__9S20979C12[12]),  12,22},
  {&(_tg__ZTV8S20979C88S20979C3__9S20979C12[5]),  5,12},
  {&(_tg__ZTV8S20979C68S20979C88S20979C3__A1__9S20979C12[3]),  3,9},
  {&(_tg__ZTV8S20979C4__8S20979C68S20979C88S20979C3__A1__9S20979C12[12]),  12,22},
  {&(_tg__ZTV8S20979C98S20979C88S20979C3__9S20979C12[5]),  5,8},
  {&(_tg__ZTV8S20979C7__8S20979C98S20979C88S20979C3__9S20979C12[15]),  15,27},
  {&(_tg__ZTV8S20979C5__A1__8S20979C98S20979C88S20979C3__9S20979C12[4]),  4,6},
  {&(_tg__ZTV8S20979C4__A1__8S20979C98S20979C88S20979C3__9S20979C12[12]),  12,22},
  {&(_tg__ZTV8S20979C5__8S20979C88S20979C3__9S20979C12[4]),  4,6},
  {&(_tg__ZTV8S20979C4__8S20979C88S20979C3__9S20979C12[12]),  12,22},
  {&(_tg__ZTV8S20979C9__8S20979C88S20979C3__9S20979C12[5]),  5,8},
  {&(_tg__ZTV8S20979C7__8S20979C88S20979C3__9S20979C12[15]),  15,27},
  {&(_tg__ZTV8S20979C4__8S20979C3__9S20979C12[12]),  12,22},
  {&(_tg__ZTV8S20979C7__8S20979C3__9S20979C12[15]),  15,27},
  {&(_tg__ZTV8S20979C5__A3__8S20979C3__9S20979C12[4]),  4,6},
  {&(_tg__ZTV8S20979C8__8S20979C3__9S20979C12[5]),  5,12},
  {&(_tg__ZTV8S20979C98S20979C8__8S20979C3__9S20979C12[5]),  5,8},
  {&(_tg__ZTV8S20979C9__A1__9S20979C12[5]),  5,8},
  {&(_tg__ZTV8S20979C7__8S20979C9__A1__9S20979C12[15]),  15,27},
  {&(_tg__ZTV8S20979C5__A1__8S20979C9__A1__9S20979C12[4]),  4,6},
  {&(_tg__ZTV8S20979C4__A1__8S20979C9__A1__9S20979C12[12]),  12,22},
};
extern VTBL_ENTRY _ZTI9S20979C12[];
extern  VTBL_ENTRY _ZTV9S20979C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20979C12[];
Class_Descriptor cd_S20979C12 = {  "S20979C12", // class name
  bases_S20979C12, 19,
  &(vtc_S20979C12[0]), // expected_vtbl_contents
  &(vtt_S20979C12[0]), // expected_vtt_contents
  ABISELECT(344,212), // object size
  NSPAIRA(_ZTI9S20979C12),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S20979C12),159, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20979C12),35, //virtual table table var
  19, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20979C10  : S20979C3 , S20979C9 , virtual S20979C11 , S20979C8 , virtual S20979C12 {
  char s20979c10f0;
  virtual void  v43(); // _ZN9S20979C103v43Ev
  virtual void  v44(); // _ZN9S20979C103v44Ev
  virtual void  v45(); // _ZN9S20979C103v45Ev
  ~S20979C10(); // tgen
  S20979C10(); // tgen
};
//SIG(-1 S20979C10) C1{ BC2{ VBC3{ BC4{ v4 v5 Fc FL} v6 v7 v8 v9 v10 v11 v12 v13 Fp[2]} BC5{ VBC3 BC4 v14 v15 v16 v17 Fp} VBC6{ BC3 VBC4 v18 v19} BC7{ VBC4 BC5 BC8{ VBC6 VBC3 BC4 v20 Fi Fp Fc} BC3 v21} BC4 v22 v23 v24 v25 v26 v27 v28 v29 v30} BC8 VBC9{ v31 v32 v33 v34 Fc:8 Fi[5] Fc:0 Fc[4] FL:8} BC7 VBC10{ VBC3 VBC4 VBC6 VBC2 VBC8 v35 v36 v37 v38 v39 Fi FL:16} v1 v2 v3 Fc}


void  S20979C10 ::v43(){vfunc_called(this, "_ZN9S20979C103v43Ev");}
void  S20979C10 ::v44(){vfunc_called(this, "_ZN9S20979C103v44Ev");}
void  S20979C10 ::v45(){vfunc_called(this, "_ZN9S20979C103v45Ev");}
S20979C10 ::~S20979C10(){ note_dtor("S20979C10", this);} // tgen
S20979C10 ::S20979C10(){ note_ctor("S20979C10", this);} // tgen

static void Test_S20979C10()
{
  extern Class_Descriptor cd_S20979C10;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(93,116)];
    init_test(&cd_S20979C10, buf);
    S20979C10 *dp, &lv = *(dp=new (buf) S20979C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(736,460), "sizeof(S20979C10)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20979C10)");
    /*is_ambiguous_... S20979C10::S20979C4 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C4*), ABISELECT(352,212), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C3*), ABISELECT(352,212), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C6*)(S20979C3*), ABISELECT(352,212), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C6*)(S20979C8*)(S20979C3*), ABISELECT(352,212), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C9*)(S20979C8*)(S20979C3*), ABISELECT(352,212), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C9 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C9*), ABISELECT(352,212), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C8 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C6*)(S20979C8*), ABISELECT(352,212), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C8 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C9*)(S20979C8*), ABISELECT(352,212), "S20979C10");
    /*is_ambiguous_... S20979C12::S20979C4 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C12*), ABISELECT(352,212), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C3*), ABISELECT(352,212), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C6*)(S20979C3*), ABISELECT(352,212), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C6*)(S20979C8*)(S20979C3*), ABISELECT(352,212), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C9*)(S20979C8*)(S20979C3*), ABISELECT(352,212), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C9 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C9*), ABISELECT(352,212), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C6*)(S20979C3*), 0, "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C6*)(S20979C3*), 0, "S20979C10");
    check_base_class_offset(lv, (S20979C5*)(S20979C4*)(S20979C7*), ABISELECT(392,236), "S20979C10");
    check_base_class_offset(lv, (S20979C4*)(S20979C7*), ABISELECT(392,236), "S20979C10");
    /*is_ambiguous_... S20979C7::S20979C5 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C7*), ABISELECT(432,260), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C8*)(S20979C3*), ABISELECT(432,260), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C8 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C8*), ABISELECT(432,260), "S20979C10");
    /*is_ambiguous_... S20979C12::S20979C5 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C12*), ABISELECT(432,260), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C8*)(S20979C3*), ABISELECT(432,260), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C7*)(S20979C3*), ABISELECT(392,236), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C7*)(S20979C9*)(S20979C8*)(S20979C3*), ABISELECT(392,236), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C9 */ AMB_check_base_class_offset(lv, (S20979C7*)(S20979C9*), ABISELECT(392,236), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C8 */ AMB_check_base_class_offset(lv, (S20979C7*)(S20979C9*)(S20979C8*), ABISELECT(392,236), "S20979C10");
    check_base_class_offset(lv, (S20979C7*)(S20979C12*), ABISELECT(392,236), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C7*)(S20979C3*), ABISELECT(392,236), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C7*)(S20979C9*)(S20979C8*)(S20979C3*), ABISELECT(392,236), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C9 */ AMB_check_base_class_offset(lv, (S20979C7*)(S20979C9*), ABISELECT(392,236), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C6*)(S20979C8*)(S20979C3*), ABISELECT(32,20), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C6*)(S20979C8*)(S20979C3*), ABISELECT(32,20), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C9*)(S20979C8*)(S20979C3*), ABISELECT(64,40), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C9*)(S20979C8*)(S20979C3*), ABISELECT(64,40), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C4*)(S20979C8*)(S20979C3*), ABISELECT(112,68), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C8*)(S20979C3*), ABISELECT(112,68), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C8*)(S20979C3*), ABISELECT(32,20), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C3*), ABISELECT(152,92), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C3*), 0, "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C9 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C9*), ABISELECT(176,108), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C9 */ AMB_check_base_class_offset(lv, (S20979C9*), ABISELECT(176,108), "S20979C10");
    check_base_class_offset(lv, (S20979C11*), ABISELECT(456,276), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C8 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C6*)(S20979C8*), ABISELECT(224,136), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C8 */ AMB_check_base_class_offset(lv, (S20979C6*)(S20979C8*), ABISELECT(224,136), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C8 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C9*)(S20979C8*), ABISELECT(256,156), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C8 */ AMB_check_base_class_offset(lv, (S20979C9*)(S20979C8*), ABISELECT(256,156), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C8 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C4*)(S20979C8*), ABISELECT(304,184), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C8 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C8*), ABISELECT(304,184), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C8 */ AMB_check_base_class_offset(lv, (S20979C8*), ABISELECT(224,136), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C6*)(S20979C3*), ABISELECT(512,324), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C6*)(S20979C3*), ABISELECT(512,324), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C6*)(S20979C8*)(S20979C3*), ABISELECT(544,344), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C6*)(S20979C8*)(S20979C3*), ABISELECT(544,344), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C9*)(S20979C8*)(S20979C3*), ABISELECT(576,364), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C9*)(S20979C8*)(S20979C3*), ABISELECT(576,364), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C4*)(S20979C8*)(S20979C3*), ABISELECT(624,392), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C8*)(S20979C3*), ABISELECT(624,392), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C8*)(S20979C3*), ABISELECT(544,344), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C3*), ABISELECT(664,416), "S20979C10");
    check_base_class_offset(lv, (S20979C3*)(S20979C12*), ABISELECT(512,324), "S20979C10");
    /*is_ambiguous_... S20979C10::S20979C9 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C9*), ABISELECT(688,432), "S20979C10");
    /*is_ambiguous_... S20979C12::S20979C9 */ AMB_check_base_class_offset(lv, (S20979C9*)(S20979C12*), ABISELECT(688,432), "S20979C10");
    check_base_class_offset(lv, (S20979C12*), ABISELECT(496,312), "S20979C10");
    check_field_offset(lv, s20979c10f0, ABISELECT(344,208), "S20979C10.s20979c10f0");
    test_class_info(&lv, &cd_S20979C10);
    dp->~S20979C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20979C10(Test_S20979C10, "S20979C10", ABISELECT(736,460));

#else // __cplusplus

extern void _ZN9S20979C10C1Ev();
extern void _ZN9S20979C10D1Ev();
Name_Map name_map_S20979C10[] = {
  NSPAIR(_ZN9S20979C10C1Ev),
  NSPAIR(_ZN9S20979C10D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C4;
extern VTBL_ENTRY _ZTI8S20979C4[];
extern  VTBL_ENTRY _ZTV8S20979C4[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C6;
extern VTBL_ENTRY _ZTI8S20979C6[];
extern  VTBL_ENTRY _ZTV8S20979C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C6[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C4;
extern VTBL_ENTRY _ZTI8S20979C4[];
extern  VTBL_ENTRY _ZTV8S20979C4[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C7;
extern VTBL_ENTRY _ZTI8S20979C7[];
extern  VTBL_ENTRY _ZTV8S20979C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C7[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C6;
extern VTBL_ENTRY _ZTI8S20979C6[];
extern  VTBL_ENTRY _ZTV8S20979C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C6[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C9;
extern VTBL_ENTRY _ZTI8S20979C9[];
extern  VTBL_ENTRY _ZTV8S20979C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C9[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C4;
extern VTBL_ENTRY _ZTI8S20979C4[];
extern  VTBL_ENTRY _ZTV8S20979C4[];
extern Class_Descriptor cd_S20979C8;
extern VTBL_ENTRY _ZTI8S20979C8[];
extern  VTBL_ENTRY _ZTV8S20979C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C8[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C3;
extern VTBL_ENTRY _ZTI8S20979C3[];
extern  VTBL_ENTRY _ZTV8S20979C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C3[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C9;
extern VTBL_ENTRY _ZTI8S20979C9[];
extern  VTBL_ENTRY _ZTV8S20979C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C9[];
extern Class_Descriptor cd_S20979C11;
extern VTBL_ENTRY _ZTI9S20979C11[];
extern  VTBL_ENTRY _ZTV9S20979C11[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C6;
extern VTBL_ENTRY _ZTI8S20979C6[];
extern  VTBL_ENTRY _ZTV8S20979C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C6[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C9;
extern VTBL_ENTRY _ZTI8S20979C9[];
extern  VTBL_ENTRY _ZTV8S20979C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C9[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C4;
extern VTBL_ENTRY _ZTI8S20979C4[];
extern  VTBL_ENTRY _ZTV8S20979C4[];
extern Class_Descriptor cd_S20979C8;
extern VTBL_ENTRY _ZTI8S20979C8[];
extern  VTBL_ENTRY _ZTV8S20979C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C8[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C6;
extern VTBL_ENTRY _ZTI8S20979C6[];
extern  VTBL_ENTRY _ZTV8S20979C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C6[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C6;
extern VTBL_ENTRY _ZTI8S20979C6[];
extern  VTBL_ENTRY _ZTV8S20979C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C6[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C9;
extern VTBL_ENTRY _ZTI8S20979C9[];
extern  VTBL_ENTRY _ZTV8S20979C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C9[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C4;
extern VTBL_ENTRY _ZTI8S20979C4[];
extern  VTBL_ENTRY _ZTV8S20979C4[];
extern Class_Descriptor cd_S20979C8;
extern VTBL_ENTRY _ZTI8S20979C8[];
extern  VTBL_ENTRY _ZTV8S20979C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C8[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C3;
extern VTBL_ENTRY _ZTI8S20979C3[];
extern  VTBL_ENTRY _ZTV8S20979C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C3[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C9;
extern VTBL_ENTRY _ZTI8S20979C9[];
extern  VTBL_ENTRY _ZTV8S20979C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C9[];
extern Class_Descriptor cd_S20979C12;
extern VTBL_ENTRY _ZTI9S20979C12[];
extern  VTBL_ENTRY _ZTV9S20979C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20979C12[];
static Base_Class bases_S20979C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20979C5,    ABISELECT(352,212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20979C4,    ABISELECT(352,212), //bcp->offset
    103, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    36, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20979C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20979C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(392,236), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20979C4,    ABISELECT(392,236), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(432,260), //bcp->offset
    152, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    38, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S20979C7,    ABISELECT(392,236), //bcp->offset
    125, //bcp->virtual_function_table_offset
    15, //num_negative_vtable_entries(t, bcp)
    37, //bcp->index_in_construction_vtbl_array
    52, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S20979C5,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20979C6,    ABISELECT(32,20), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(64,40), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20979C9,    ABISELECT(64,40), //bcp->offset
    39, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    40, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(112,68), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20979C4,    ABISELECT(112,68), //bcp->offset
    47, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20979C8,    ABISELECT(32,20), //bcp->offset
    27, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    39, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(152,92), //bcp->offset
    59, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20979C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20979C5,    ABISELECT(176,108), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20979C9,    ABISELECT(176,108), //bcp->offset
    63, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    41, //bcp->index_in_construction_vtbl_array
    21, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20979C11,    ABISELECT(456,276), //bcp->offset
    158, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    42, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20979C5,    ABISELECT(224,136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S20979C6,    ABISELECT(224,136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    36, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(256,156), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    37, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S20979C9,    ABISELECT(256,156), //bcp->offset
    83, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    44, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    38, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(304,184), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    39, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S20979C4,    ABISELECT(304,184), //bcp->offset
    91, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    40, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S20979C8,    ABISELECT(224,136), //bcp->offset
    71, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    43, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    41, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S20979C5,    ABISELECT(512,324), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S20979C6,    ABISELECT(512,324), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    65, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(544,344), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S20979C6,    ABISELECT(544,344), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    68, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(576,364), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S20979C9,    ABISELECT(576,364), //bcp->offset
    242, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    48, //bcp->index_in_construction_vtbl_array
    70, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(624,392), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S20979C4,    ABISELECT(624,392), //bcp->offset
    250, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    49, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    35, //immediately_derived
  0, 0},
  {&cd_S20979C8,    ABISELECT(544,344), //bcp->offset
    230, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    47, //bcp->index_in_construction_vtbl_array
    67, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(664,416), //bcp->offset
    262, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    50, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S20979C3,    ABISELECT(512,324), //bcp->offset
    185, //bcp->virtual_function_table_offset
    30, //num_negative_vtable_entries(t, bcp)
    46, //bcp->index_in_construction_vtbl_array
    64, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    40, //immediately_derived
  0, 1},
  {&cd_S20979C5,    ABISELECT(688,432), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S20979C9,    ABISELECT(688,432), //bcp->offset
    266, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    51, //bcp->index_in_construction_vtbl_array
    83, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    40, //immediately_derived
  0, 1},
  {&cd_S20979C12,    ABISELECT(496,312), //bcp->offset
    168, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    45, //bcp->index_in_construction_vtbl_array
    54, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI9S20979C10[];
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C33v25Ev();
extern void _ZN8S20979C33v26Ev();
extern void _ZN8S20979C33v27Ev();
extern void _ZN8S20979C33v28Ev();
extern void _ZN8S20979C33v29Ev();
extern void _ZN8S20979C33v30Ev();
extern void _ZN8S20979C33v31Ev();
extern void _ZN8S20979C33v32Ev();
extern void _ZN8S20979C33v33Ev();
extern void _ZN9S20979C103v43Ev();
extern void _ZN9S20979C103v44Ev();
extern void _ZN9S20979C103v45Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN9S20979C113v34Ev();
extern void _ZN9S20979C113v35Ev();
extern void _ZN9S20979C113v36Ev();
extern void _ZN9S20979C113v37Ev();
extern void _ZN9S20979C123v38Ev();
extern void _ZN9S20979C123v39Ev();
extern void _ZN9S20979C123v40Ev();
extern void _ZN9S20979C123v41Ev();
extern void _ZN9S20979C123v42Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C33v25Ev();
extern void _ZN8S20979C33v26Ev();
extern void _ZN8S20979C33v27Ev();
extern void _ZN8S20979C33v28Ev();
extern void _ZN8S20979C33v29Ev();
extern void _ZN8S20979C33v30Ev();
extern void _ZN8S20979C33v31Ev();
extern void _ZN8S20979C33v32Ev();
extern void _ZN8S20979C33v33Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY vtc_S20979C10[] = {
  ABISELECT(688,432),
  ABISELECT(512,324),
  ABISELECT(496,312),
  ABISELECT(456,276),
  ABISELECT(432,260),
  ABISELECT(392,236),
  ABISELECT(352,212),
  0,
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v25Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v26Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v27Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v28Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v29Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v30Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v31Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v32Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v33Ev,
  (VTBL_ENTRY)&_ZN9S20979C103v43Ev,
  (VTBL_ENTRY)&_ZN9S20979C103v44Ev,
  (VTBL_ENTRY)&_ZN9S20979C103v45Ev,
  ABISELECT(360,216),
  ABISELECT(400,240),
  ABISELECT(320,192),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
  ABISELECT(288,172),
  ABISELECT(368,220),
  ABISELECT(328,196),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
  ABISELECT(-112,-68),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  ABISELECT(-152,-92),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  ABISELECT(176,104),
  ABISELECT(256,152),
  ABISELECT(216,128),
  ABISELECT(-176,-108),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
  ABISELECT(168,100),
  ABISELECT(208,124),
  ABISELECT(128,76),
  ABISELECT(-224,-136),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
  ABISELECT(96,56),
  ABISELECT(176,104),
  ABISELECT(136,80),
  ABISELECT(-256,-156),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
  ABISELECT(-304,-184),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-352,-212),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(-392,-236),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
  0,
  0,
  ABISELECT(-432,-260),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-456,-276),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN9S20979C113v34Ev,
  (VTBL_ENTRY)&_ZN9S20979C113v35Ev,
  (VTBL_ENTRY)&_ZN9S20979C113v36Ev,
  (VTBL_ENTRY)&_ZN9S20979C113v37Ev,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(192,120),
  ABISELECT(16,12),
  ABISELECT(-104,-76),
  ABISELECT(-64,-52),
  ABISELECT(-144,-100),
  ABISELECT(-496,-312),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN9S20979C123v38Ev,
  (VTBL_ENTRY)&_ZN9S20979C123v39Ev,
  (VTBL_ENTRY)&_ZN9S20979C123v40Ev,
  (VTBL_ENTRY)&_ZN9S20979C123v41Ev,
  (VTBL_ENTRY)&_ZN9S20979C123v42Ev,
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(64,40),
  ABISELECT(32,20),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-80,-64),
  ABISELECT(-120,-88),
  ABISELECT(-160,-112),
  ABISELECT(-512,-324),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v25Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v26Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v27Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v28Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v29Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v30Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v31Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v32Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v33Ev,
  ABISELECT(-152,-108),
  ABISELECT(-112,-84),
  ABISELECT(-192,-132),
  ABISELECT(-544,-344),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
  ABISELECT(-224,-152),
  ABISELECT(-144,-104),
  ABISELECT(-184,-128),
  ABISELECT(-576,-364),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
  ABISELECT(-624,-392),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  ABISELECT(-664,-416),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  0,
  0,
  0,
  ABISELECT(-336,-220),
  ABISELECT(-256,-172),
  ABISELECT(-296,-196),
  ABISELECT(-688,-432),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern VTBL_ENTRY _ZTV9S20979C10[];
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C33v25Ev();
extern void _ZN8S20979C33v26Ev();
extern void _ZN8S20979C33v27Ev();
extern void _ZN8S20979C33v28Ev();
extern void _ZN8S20979C33v29Ev();
extern void _ZN8S20979C33v30Ev();
extern void _ZN8S20979C33v31Ev();
extern void _ZN8S20979C33v32Ev();
extern void _ZN8S20979C33v33Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C3__A__9S20979C10[] = {
  ABISELECT(432,260),
  ABISELECT(392,236),
  ABISELECT(352,212),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v25Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v26Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v27Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v28Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v29Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v30Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v31Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v32Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v33Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C68S20979C3__9S20979C10[] = {
  ABISELECT(352,212),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C68S20979C3__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-352,-212),
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C88S20979C3__9S20979C10[] = {
  ABISELECT(360,216),
  ABISELECT(400,240),
  ABISELECT(320,192),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C68S20979C88S20979C3__A1__9S20979C10[] = {
  ABISELECT(320,192),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C68S20979C88S20979C3__A1__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-320,-192),
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C98S20979C88S20979C3__9S20979C10[] = {
  ABISELECT(288,172),
  ABISELECT(368,220),
  ABISELECT(328,196),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C98S20979C88S20979C3__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(-328,-196),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A1__8S20979C98S20979C88S20979C3__9S20979C10[] = {
  0,
  0,
  ABISELECT(-368,-220),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__A1__8S20979C98S20979C88S20979C3__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-288,-172),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__8S20979C88S20979C3__9S20979C10[] = {
  0,
  0,
  ABISELECT(-400,-240),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C88S20979C3__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-320,-192),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C9__8S20979C88S20979C3__9S20979C10[] = {
  ABISELECT(288,172),
  ABISELECT(368,220),
  ABISELECT(328,196),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C88S20979C3__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(-360,-216),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C3__A__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-352,-212),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C3__A__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(-392,-236),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A3__8S20979C3__A__9S20979C10[] = {
  0,
  0,
  ABISELECT(-432,-260),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C8__8S20979C3__A__9S20979C10[] = {
  ABISELECT(360,216),
  ABISELECT(400,240),
  ABISELECT(320,192),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C98S20979C8__8S20979C3__A__9S20979C10[] = {
  ABISELECT(288,172),
  ABISELECT(368,220),
  ABISELECT(328,196),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C9__A__9S20979C10[] = {
  ABISELECT(176,104),
  ABISELECT(256,152),
  ABISELECT(216,128),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C9__A__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(-216,-128),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A1__8S20979C9__A__9S20979C10[] = {
  0,
  0,
  ABISELECT(-256,-152),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__A1__8S20979C9__A__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C8__A1__9S20979C10[] = {
  ABISELECT(168,100),
  ABISELECT(208,124),
  ABISELECT(128,76),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C68S20979C8__A2__9S20979C10[] = {
  ABISELECT(128,76),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C68S20979C8__A2__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-128,-76),
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C98S20979C8__A2__9S20979C10[] = {
  ABISELECT(96,56),
  ABISELECT(176,104),
  ABISELECT(136,80),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C98S20979C8__A2__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(-136,-80),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A1__8S20979C98S20979C8__A2__9S20979C10[] = {
  0,
  0,
  ABISELECT(-176,-104),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__A1__8S20979C98S20979C8__A2__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-96,-56),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__8S20979C8__A1__9S20979C10[] = {
  0,
  0,
  ABISELECT(-208,-124),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C8__A1__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-128,-76),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C9__8S20979C8__A1__9S20979C10[] = {
  ABISELECT(96,56),
  ABISELECT(176,104),
  ABISELECT(136,80),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C8__A1__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(-168,-100),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__9S20979C10[] = {
  ABISELECT(40,24),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C7[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A1__8S20979C7__9S20979C10[] = {
  0,
  0,
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI8S20979C7[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN9S20979C123v38Ev();
extern void _ZN9S20979C123v39Ev();
extern void _ZN9S20979C123v40Ev();
extern void _ZN9S20979C123v41Ev();
extern void _ZN9S20979C123v42Ev();
static  VTBL_ENTRY _tg__ZTV9S20979C12__9S20979C10[] = {
  ABISELECT(192,120),
  ABISELECT(16,12),
  ABISELECT(-104,-76),
  ABISELECT(-64,-52),
  ABISELECT(-144,-100),
  0,
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN9S20979C123v38Ev,
  (VTBL_ENTRY)&_ZN9S20979C123v39Ev,
  (VTBL_ENTRY)&_ZN9S20979C123v40Ev,
  (VTBL_ENTRY)&_ZN9S20979C123v41Ev,
  (VTBL_ENTRY)&_ZN9S20979C123v42Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__9S20979C12__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(144,100),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A1__9S20979C12__9S20979C10[] = {
  0,
  0,
  ABISELECT(64,52),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__9S20979C12__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(104,76),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C33v25Ev();
extern void _ZN8S20979C33v26Ev();
extern void _ZN8S20979C33v27Ev();
extern void _ZN8S20979C33v28Ev();
extern void _ZN8S20979C33v29Ev();
extern void _ZN8S20979C33v30Ev();
extern void _ZN8S20979C33v31Ev();
extern void _ZN8S20979C33v32Ev();
extern void _ZN8S20979C33v33Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C3__9S20979C12__9S20979C10[] = {
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(64,40),
  ABISELECT(32,20),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-80,-64),
  ABISELECT(-120,-88),
  ABISELECT(-160,-112),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v25Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v26Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v27Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v28Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v29Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v30Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v31Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v32Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v33Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C88S20979C3__9S20979C12__9S20979C10[] = {
  ABISELECT(-152,-108),
  ABISELECT(-112,-84),
  ABISELECT(-192,-132),
  ABISELECT(-48,-32),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C98S20979C88S20979C3__9S20979C12__9S20979C10[] = {
  ABISELECT(-224,-152),
  ABISELECT(-144,-104),
  ABISELECT(-184,-128),
  ABISELECT(-80,-52),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C48S20979C88S20979C3__A2__9S20979C12__9S20979C10[] = {
  ABISELECT(-128,-80),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C58S20979C3__A7__9S20979C12__9S20979C10[] = {
  ABISELECT(-168,-104),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C9__A1__9S20979C12__9S20979C10[] = {
  0,
  0,
  0,
  ABISELECT(-336,-220),
  ABISELECT(-256,-172),
  ABISELECT(-296,-196),
  ABISELECT(-192,-120),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C33v25Ev();
extern void _ZN8S20979C33v26Ev();
extern void _ZN8S20979C33v27Ev();
extern void _ZN8S20979C33v28Ev();
extern void _ZN8S20979C33v29Ev();
extern void _ZN8S20979C33v30Ev();
extern void _ZN8S20979C33v31Ev();
extern void _ZN8S20979C33v32Ev();
extern void _ZN8S20979C33v33Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C3__A1__9S20979C10[] = {
  ABISELECT(-80,-64),
  ABISELECT(-120,-88),
  ABISELECT(-160,-112),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v25Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v26Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v27Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v28Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v29Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v30Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v31Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v32Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v33Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C68S20979C3__A3__9S20979C10[] = {
  ABISELECT(-160,-112),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C68S20979C3__A3__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(160,112),
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C88S20979C3__A2__9S20979C10[] = {
  ABISELECT(-152,-108),
  ABISELECT(-112,-84),
  ABISELECT(-192,-132),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C68S20979C88S20979C3__A4__9S20979C10[] = {
  ABISELECT(-192,-132),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C68S20979C88S20979C3__A4__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(192,132),
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C98S20979C88S20979C3__A3__9S20979C10[] = {
  ABISELECT(-224,-152),
  ABISELECT(-144,-104),
  ABISELECT(-184,-128),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C98S20979C88S20979C3__A3__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(184,128),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A1__8S20979C98S20979C88S20979C3__A3__9S20979C10[] = {
  0,
  0,
  ABISELECT(144,104),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__A1__8S20979C98S20979C88S20979C3__A3__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(224,152),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__8S20979C88S20979C3__A2__9S20979C10[] = {
  0,
  0,
  ABISELECT(112,84),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C88S20979C3__A2__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(192,132),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C9__8S20979C88S20979C3__A2__9S20979C10[] = {
  ABISELECT(-224,-152),
  ABISELECT(-144,-104),
  ABISELECT(-184,-128),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C88S20979C3__A2__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(152,108),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C3__A1__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(160,112),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C3__A1__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(120,88),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A3__8S20979C3__A1__9S20979C10[] = {
  0,
  0,
  ABISELECT(80,64),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C8__8S20979C3__A1__9S20979C10[] = {
  ABISELECT(-152,-108),
  ABISELECT(-112,-84),
  ABISELECT(-192,-132),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C98S20979C8__8S20979C3__A1__9S20979C10[] = {
  ABISELECT(-224,-152),
  ABISELECT(-144,-104),
  ABISELECT(-184,-128),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C9__A4__9S20979C10[] = {
  ABISELECT(-336,-220),
  ABISELECT(-256,-172),
  ABISELECT(-296,-196),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C9__A4__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(296,196),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A1__8S20979C9__A4__9S20979C10[] = {
  0,
  0,
  ABISELECT(256,172),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__A1__8S20979C9__A4__9S20979C10[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(336,220),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
static  VTT_ENTRY vtt_S20979C10[] = {
  {&(_ZTV9S20979C10[9]),  9,277},
  {&(_tg__ZTV8S20979C3__A__9S20979C10[5]),  5,20},
  {&(_tg__ZTV8S20979C68S20979C3__9S20979C10[3]),  3,9},
  {&(_tg__ZTV8S20979C4__8S20979C68S20979C3__9S20979C10[12]),  12,22},
  {&(_tg__ZTV8S20979C88S20979C3__9S20979C10[5]),  5,12},
  {&(_tg__ZTV8S20979C68S20979C88S20979C3__A1__9S20979C10[3]),  3,9},
  {&(_tg__ZTV8S20979C4__8S20979C68S20979C88S20979C3__A1__9S20979C10[12]),  12,22},
  {&(_tg__ZTV8S20979C98S20979C88S20979C3__9S20979C10[5]),  5,8},
  {&(_tg__ZTV8S20979C7__8S20979C98S20979C88S20979C3__9S20979C10[15]),  15,27},
  {&(_tg__ZTV8S20979C5__A1__8S20979C98S20979C88S20979C3__9S20979C10[4]),  4,6},
  {&(_tg__ZTV8S20979C4__A1__8S20979C98S20979C88S20979C3__9S20979C10[12]),  12,22},
  {&(_tg__ZTV8S20979C5__8S20979C88S20979C3__9S20979C10[4]),  4,6},
  {&(_tg__ZTV8S20979C4__8S20979C88S20979C3__9S20979C10[12]),  12,22},
  {&(_tg__ZTV8S20979C9__8S20979C88S20979C3__9S20979C10[5]),  5,8},
  {&(_tg__ZTV8S20979C7__8S20979C88S20979C3__9S20979C10[15]),  15,27},
  {&(_tg__ZTV8S20979C4__8S20979C3__A__9S20979C10[12]),  12,22},
  {&(_tg__ZTV8S20979C7__8S20979C3__A__9S20979C10[15]),  15,27},
  {&(_tg__ZTV8S20979C5__A3__8S20979C3__A__9S20979C10[4]),  4,6},
  {&(_tg__ZTV8S20979C8__8S20979C3__A__9S20979C10[5]),  5,12},
  {&(_tg__ZTV8S20979C98S20979C8__8S20979C3__A__9S20979C10[5]),  5,8},
  {&(_tg__ZTV8S20979C9__A__9S20979C10[5]),  5,8},
  {&(_tg__ZTV8S20979C7__8S20979C9__A__9S20979C10[15]),  15,27},
  {&(_tg__ZTV8S20979C5__A1__8S20979C9__A__9S20979C10[4]),  4,6},
  {&(_tg__ZTV8S20979C4__A1__8S20979C9__A__9S20979C10[12]),  12,22},
  {&(_tg__ZTV8S20979C8__A1__9S20979C10[5]),  5,12},
  {&(_tg__ZTV8S20979C68S20979C8__A2__9S20979C10[3]),  3,9},
  {&(_tg__ZTV8S20979C4__8S20979C68S20979C8__A2__9S20979C10[12]),  12,22},
  {&(_tg__ZTV8S20979C98S20979C8__A2__9S20979C10[5]),  5,8},
  {&(_tg__ZTV8S20979C7__8S20979C98S20979C8__A2__9S20979C10[15]),  15,27},
  {&(_tg__ZTV8S20979C5__A1__8S20979C98S20979C8__A2__9S20979C10[4]),  4,6},
  {&(_tg__ZTV8S20979C4__A1__8S20979C98S20979C8__A2__9S20979C10[12]),  12,22},
  {&(_tg__ZTV8S20979C5__8S20979C8__A1__9S20979C10[4]),  4,6},
  {&(_tg__ZTV8S20979C4__8S20979C8__A1__9S20979C10[12]),  12,22},
  {&(_tg__ZTV8S20979C9__8S20979C8__A1__9S20979C10[5]),  5,8},
  {&(_tg__ZTV8S20979C7__8S20979C8__A1__9S20979C10[15]),  15,27},
  {&(_ZTV9S20979C10[115]),  115,277},
  {&(_ZTV9S20979C10[140]),  140,277},
  {&(_ZTV9S20979C10[156]),  156,277},
  {&(_ZTV9S20979C10[32]),  32,277},
  {&(_ZTV9S20979C10[44]),  44,277},
  {&(_ZTV9S20979C10[68]),  68,277},
  {&(_ZTV9S20979C10[164]),  164,277},
  {&(_ZTV9S20979C10[76]),  76,277},
  {&(_ZTV9S20979C10[88]),  88,277},
  {&(_ZTV9S20979C10[180]),  180,277},
  {&(_ZTV9S20979C10[215]),  215,277},
  {&(_ZTV9S20979C10[235]),  235,277},
  {&(_ZTV9S20979C10[247]),  247,277},
  {&(_ZTV9S20979C10[252]),  252,277},
  {&(_ZTV9S20979C10[264]),  264,277},
  {&(_ZTV9S20979C10[274]),  274,277},
  {&(_tg__ZTV8S20979C7__9S20979C10[3]),  3,15},
  {&(_tg__ZTV8S20979C5__A1__8S20979C7__9S20979C10[4]),  4,6},
  {&(_tg__ZTV9S20979C12__9S20979C10[7]),  7,12},
  {&(_tg__ZTV8S20979C4__9S20979C12__9S20979C10[12]),  12,22},
  {&(_tg__ZTV8S20979C5__A1__9S20979C12__9S20979C10[4]),  4,6},
  {&(_tg__ZTV8S20979C7__9S20979C12__9S20979C10[15]),  15,27},
  {&(_tg__ZTV8S20979C3__9S20979C12__9S20979C10[30]),  30,45},
  {&(_tg__ZTV8S20979C88S20979C3__9S20979C12__9S20979C10[5]),  5,12},
  {&(_tg__ZTV8S20979C98S20979C88S20979C3__9S20979C12__9S20979C10[5]),  5,8},
  {&(_tg__ZTV8S20979C48S20979C88S20979C3__A2__9S20979C12__9S20979C10[2]),  2,12},
  {&(_tg__ZTV8S20979C58S20979C3__A7__9S20979C12__9S20979C10[2]),  2,4},
  {&(_tg__ZTV8S20979C9__A1__9S20979C12__9S20979C10[8]),  8,11},
  {&(_tg__ZTV8S20979C3__A1__9S20979C10[5]),  5,20},
  {&(_tg__ZTV8S20979C68S20979C3__A3__9S20979C10[3]),  3,9},
  {&(_tg__ZTV8S20979C4__8S20979C68S20979C3__A3__9S20979C10[12]),  12,22},
  {&(_tg__ZTV8S20979C88S20979C3__A2__9S20979C10[5]),  5,12},
  {&(_tg__ZTV8S20979C68S20979C88S20979C3__A4__9S20979C10[3]),  3,9},
  {&(_tg__ZTV8S20979C4__8S20979C68S20979C88S20979C3__A4__9S20979C10[12]),  12,22},
  {&(_tg__ZTV8S20979C98S20979C88S20979C3__A3__9S20979C10[5]),  5,8},
  {&(_tg__ZTV8S20979C7__8S20979C98S20979C88S20979C3__A3__9S20979C10[15]),  15,27},
  {&(_tg__ZTV8S20979C5__A1__8S20979C98S20979C88S20979C3__A3__9S20979C10[4]),  4,6},
  {&(_tg__ZTV8S20979C4__A1__8S20979C98S20979C88S20979C3__A3__9S20979C10[12]),  12,22},
  {&(_tg__ZTV8S20979C5__8S20979C88S20979C3__A2__9S20979C10[4]),  4,6},
  {&(_tg__ZTV8S20979C4__8S20979C88S20979C3__A2__9S20979C10[12]),  12,22},
  {&(_tg__ZTV8S20979C9__8S20979C88S20979C3__A2__9S20979C10[5]),  5,8},
  {&(_tg__ZTV8S20979C7__8S20979C88S20979C3__A2__9S20979C10[15]),  15,27},
  {&(_tg__ZTV8S20979C4__8S20979C3__A1__9S20979C10[12]),  12,22},
  {&(_tg__ZTV8S20979C7__8S20979C3__A1__9S20979C10[15]),  15,27},
  {&(_tg__ZTV8S20979C5__A3__8S20979C3__A1__9S20979C10[4]),  4,6},
  {&(_tg__ZTV8S20979C8__8S20979C3__A1__9S20979C10[5]),  5,12},
  {&(_tg__ZTV8S20979C98S20979C8__8S20979C3__A1__9S20979C10[5]),  5,8},
  {&(_tg__ZTV8S20979C9__A4__9S20979C10[5]),  5,8},
  {&(_tg__ZTV8S20979C7__8S20979C9__A4__9S20979C10[15]),  15,27},
  {&(_tg__ZTV8S20979C5__A1__8S20979C9__A4__9S20979C10[4]),  4,6},
  {&(_tg__ZTV8S20979C4__A1__8S20979C9__A4__9S20979C10[12]),  12,22},
};
extern VTBL_ENTRY _ZTI9S20979C10[];
extern  VTBL_ENTRY _ZTV9S20979C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20979C10[];
Class_Descriptor cd_S20979C10 = {  "S20979C10", // class name
  bases_S20979C10, 41,
  &(vtc_S20979C10[0]), // expected_vtbl_contents
  &(vtt_S20979C10[0]), // expected_vtt_contents
  ABISELECT(736,460), // object size
  NSPAIRA(_ZTI9S20979C10),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV9S20979C10),277, //virtual function table var
  9, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT9S20979C10),86, //virtual table table var
  41, // n_initialized_bases
  1, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S20979C2  : virtual S20979C3 , virtual S20979C10 {
  char s20979c2f0;
  int s20979c2f1;
  void *s20979c2f2;
  virtual void  v46(); // _ZN8S20979C23v46Ev
  ~S20979C2(); // tgen
  S20979C2(); // tgen
};
//SIG(-1 S20979C2) C1{ VBC2{ VBC3{ BC4{ v2 v3 Fc FL} v4 v5 v6 v7 v8 v9 v10 v11 Fp[2]} BC5{ VBC3 BC4 v12 v13 v14 v15 Fp} VBC6{ BC3 VBC4 v16 v17} BC7{ VBC4 BC5 BC8{ VBC6 VBC3 BC4 v18 Fi Fp Fc} BC3 v19} BC4 v20 v21 v22 v23 v24 v25 v26 v27 v28} VBC9{ BC2 BC8 VBC10{ v29 v30 v31 v32 Fc:8 Fi[5] Fc:0 Fc[4] FL:8} BC7 VBC11{ VBC3 VBC4 VBC6 VBC2 VBC8 v33 v34 v35 v36 v37 Fi FL:16} v38 v39 v40 Fc} v1 Fc Fi Fp}


void  S20979C2 ::v46(){vfunc_called(this, "_ZN8S20979C23v46Ev");}
S20979C2 ::~S20979C2(){ note_dtor("S20979C2", this);} // tgen
S20979C2 ::S20979C2(){ note_ctor("S20979C2", this);} // tgen

static void Test_S20979C2()
{
  extern Class_Descriptor cd_S20979C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(96,120)];
    init_test(&cd_S20979C2, buf);
    S20979C2 *dp, &lv = *(dp=new (buf) S20979C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(760,476), "sizeof(S20979C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S20979C2)");
    /*is_ambiguous_... S20979C2::S20979C4 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C4*), ABISELECT(200,124), "S20979C2");
    /*is_ambiguous_... S20979C2::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C3*), ABISELECT(200,124), "S20979C2");
    /*is_ambiguous_... S20979C2::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C6*)(S20979C3*), ABISELECT(200,124), "S20979C2");
    /*is_ambiguous_... S20979C2::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C6*)(S20979C8*)(S20979C3*), ABISELECT(200,124), "S20979C2");
    /*is_ambiguous_... S20979C2::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C9*)(S20979C8*)(S20979C3*), ABISELECT(200,124), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C3*)(S20979C10*), ABISELECT(200,124), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C6*)(S20979C3*)(S20979C10*), ABISELECT(200,124), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C6*)(S20979C8*)(S20979C3*)(S20979C10*), ABISELECT(200,124), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C9*)(S20979C8*)(S20979C3*)(S20979C10*), ABISELECT(200,124), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C9 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C9*)(S20979C10*), ABISELECT(200,124), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C8 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C6*)(S20979C8*)(S20979C10*), ABISELECT(200,124), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C8 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C9*)(S20979C8*)(S20979C10*), ABISELECT(200,124), "S20979C2");
    /*is_ambiguous_... S20979C12::S20979C4 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C12*), ABISELECT(200,124), "S20979C2");
    /*is_ambiguous_... S20979C2::S20979C9 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C9*), ABISELECT(200,124), "S20979C2");
    /*is_ambiguous_... S20979C2::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C6*)(S20979C3*), ABISELECT(24,16), "S20979C2");
    /*is_ambiguous_... S20979C2::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C6*)(S20979C3*), ABISELECT(24,16), "S20979C2");
    check_base_class_offset(lv, (S20979C5*)(S20979C4*)(S20979C7*), ABISELECT(240,148), "S20979C2");
    check_base_class_offset(lv, (S20979C4*)(S20979C7*), ABISELECT(240,148), "S20979C2");
    /*is_ambiguous_... S20979C7::S20979C5 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C7*), ABISELECT(280,172), "S20979C2");
    /*is_ambiguous_... S20979C2::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C8*)(S20979C3*), ABISELECT(280,172), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C8*)(S20979C3*)(S20979C10*), ABISELECT(280,172), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C8 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C8*)(S20979C10*), ABISELECT(280,172), "S20979C2");
    /*is_ambiguous_... S20979C12::S20979C5 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C12*), ABISELECT(280,172), "S20979C2");
    /*is_ambiguous_... S20979C2::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C7*)(S20979C3*), ABISELECT(240,148), "S20979C2");
    /*is_ambiguous_... S20979C2::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C7*)(S20979C9*)(S20979C8*)(S20979C3*), ABISELECT(240,148), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C7*)(S20979C3*)(S20979C10*), ABISELECT(240,148), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C7*)(S20979C9*)(S20979C8*)(S20979C3*)(S20979C10*), ABISELECT(240,148), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C9 */ AMB_check_base_class_offset(lv, (S20979C7*)(S20979C9*)(S20979C10*), ABISELECT(240,148), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C8 */ AMB_check_base_class_offset(lv, (S20979C7*)(S20979C9*)(S20979C8*)(S20979C10*), ABISELECT(240,148), "S20979C2");
    check_base_class_offset(lv, (S20979C7*)(S20979C12*), ABISELECT(240,148), "S20979C2");
    /*is_ambiguous_... S20979C2::S20979C9 */ AMB_check_base_class_offset(lv, (S20979C7*)(S20979C9*), ABISELECT(240,148), "S20979C2");
    /*is_ambiguous_... S20979C2::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C6*)(S20979C8*)(S20979C3*), ABISELECT(56,36), "S20979C2");
    /*is_ambiguous_... S20979C2::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C6*)(S20979C8*)(S20979C3*), ABISELECT(56,36), "S20979C2");
    /*is_ambiguous_... S20979C2::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C9*)(S20979C8*)(S20979C3*), ABISELECT(88,56), "S20979C2");
    /*is_ambiguous_... S20979C2::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C9*)(S20979C8*)(S20979C3*), ABISELECT(88,56), "S20979C2");
    /*is_ambiguous_... S20979C2::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C4*)(S20979C8*)(S20979C3*), ABISELECT(136,84), "S20979C2");
    /*is_ambiguous_... S20979C2::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C8*)(S20979C3*), ABISELECT(136,84), "S20979C2");
    /*is_ambiguous_... S20979C2::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C8*)(S20979C3*), ABISELECT(56,36), "S20979C2");
    /*is_ambiguous_... S20979C2::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C3*), ABISELECT(176,108), "S20979C2");
    /*is_ambiguous_... S20979C2::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C3*), ABISELECT(24,16), "S20979C2");
    check_base_class_offset(lv, (S20979C3*)(S20979C12*), ABISELECT(24,16), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C6*)(S20979C3*)(S20979C10*), ABISELECT(304,188), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C6*)(S20979C3*)(S20979C10*), ABISELECT(304,188), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C6*)(S20979C8*)(S20979C3*)(S20979C10*), ABISELECT(336,208), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C6*)(S20979C8*)(S20979C3*)(S20979C10*), ABISELECT(336,208), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C9*)(S20979C8*)(S20979C3*)(S20979C10*), ABISELECT(368,228), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C9*)(S20979C8*)(S20979C3*)(S20979C10*), ABISELECT(368,228), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C4*)(S20979C8*)(S20979C3*)(S20979C10*), ABISELECT(416,256), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C8*)(S20979C3*)(S20979C10*), ABISELECT(416,256), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C8*)(S20979C3*)(S20979C10*), ABISELECT(336,208), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C3*)(S20979C10*), ABISELECT(456,280), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C3 */ AMB_check_base_class_offset(lv, (S20979C3*)(S20979C10*), ABISELECT(304,188), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C9 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C9*)(S20979C10*), ABISELECT(480,296), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C9 */ AMB_check_base_class_offset(lv, (S20979C9*)(S20979C10*), ABISELECT(480,296), "S20979C2");
    check_base_class_offset(lv, (S20979C11*)(S20979C10*), ABISELECT(656,400), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C8 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C6*)(S20979C8*)(S20979C10*), ABISELECT(528,324), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C8 */ AMB_check_base_class_offset(lv, (S20979C6*)(S20979C8*)(S20979C10*), ABISELECT(528,324), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C8 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C9*)(S20979C8*)(S20979C10*), ABISELECT(560,344), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C8 */ AMB_check_base_class_offset(lv, (S20979C9*)(S20979C8*)(S20979C10*), ABISELECT(560,344), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C8 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C4*)(S20979C8*)(S20979C10*), ABISELECT(608,372), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C8 */ AMB_check_base_class_offset(lv, (S20979C4*)(S20979C8*)(S20979C10*), ABISELECT(608,372), "S20979C2");
    /*is_ambiguous_... S20979C10::S20979C8 */ AMB_check_base_class_offset(lv, (S20979C8*)(S20979C10*), ABISELECT(528,324), "S20979C2");
    /*is_ambiguous_... S20979C2::S20979C9 */ AMB_check_base_class_offset(lv, (S20979C5*)(S20979C9*), ABISELECT(712,448), "S20979C2");
    /*is_ambiguous_... S20979C12::S20979C9 */ AMB_check_base_class_offset(lv, (S20979C9*)(S20979C12*), ABISELECT(712,448), "S20979C2");
    check_base_class_offset(lv, (S20979C12*)(S20979C10*), ABISELECT(696,436), "S20979C2");
    check_base_class_offset(lv, (S20979C10*), ABISELECT(304,188), "S20979C2");
    check_field_offset(lv, s20979c2f0, ABISELECT(8,4), "S20979C2.s20979c2f0");
    check_field_offset(lv, s20979c2f1, ABISELECT(12,8), "S20979C2.s20979c2f1");
    check_field_offset(lv, s20979c2f2, ABISELECT(16,12), "S20979C2.s20979c2f2");
    test_class_info(&lv, &cd_S20979C2);
    dp->~S20979C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS20979C2(Test_S20979C2, "S20979C2", ABISELECT(760,476));

#else // __cplusplus

extern void _ZN8S20979C2C1Ev();
extern void _ZN8S20979C2D1Ev();
Name_Map name_map_S20979C2[] = {
  NSPAIR(_ZN8S20979C2C1Ev),
  NSPAIR(_ZN8S20979C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C4;
extern VTBL_ENTRY _ZTI8S20979C4[];
extern  VTBL_ENTRY _ZTV8S20979C4[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C6;
extern VTBL_ENTRY _ZTI8S20979C6[];
extern  VTBL_ENTRY _ZTV8S20979C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C6[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C4;
extern VTBL_ENTRY _ZTI8S20979C4[];
extern  VTBL_ENTRY _ZTV8S20979C4[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C7;
extern VTBL_ENTRY _ZTI8S20979C7[];
extern  VTBL_ENTRY _ZTV8S20979C7[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C7[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C6;
extern VTBL_ENTRY _ZTI8S20979C6[];
extern  VTBL_ENTRY _ZTV8S20979C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C6[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C9;
extern VTBL_ENTRY _ZTI8S20979C9[];
extern  VTBL_ENTRY _ZTV8S20979C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C9[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C4;
extern VTBL_ENTRY _ZTI8S20979C4[];
extern  VTBL_ENTRY _ZTV8S20979C4[];
extern Class_Descriptor cd_S20979C8;
extern VTBL_ENTRY _ZTI8S20979C8[];
extern  VTBL_ENTRY _ZTV8S20979C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C8[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C3;
extern VTBL_ENTRY _ZTI8S20979C3[];
extern  VTBL_ENTRY _ZTV8S20979C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C3[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C6;
extern VTBL_ENTRY _ZTI8S20979C6[];
extern  VTBL_ENTRY _ZTV8S20979C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C6[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C6;
extern VTBL_ENTRY _ZTI8S20979C6[];
extern  VTBL_ENTRY _ZTV8S20979C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C6[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C9;
extern VTBL_ENTRY _ZTI8S20979C9[];
extern  VTBL_ENTRY _ZTV8S20979C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C9[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C4;
extern VTBL_ENTRY _ZTI8S20979C4[];
extern  VTBL_ENTRY _ZTV8S20979C4[];
extern Class_Descriptor cd_S20979C8;
extern VTBL_ENTRY _ZTI8S20979C8[];
extern  VTBL_ENTRY _ZTV8S20979C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C8[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C3;
extern VTBL_ENTRY _ZTI8S20979C3[];
extern  VTBL_ENTRY _ZTV8S20979C3[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C3[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C9;
extern VTBL_ENTRY _ZTI8S20979C9[];
extern  VTBL_ENTRY _ZTV8S20979C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C9[];
extern Class_Descriptor cd_S20979C11;
extern VTBL_ENTRY _ZTI9S20979C11[];
extern  VTBL_ENTRY _ZTV9S20979C11[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C6;
extern VTBL_ENTRY _ZTI8S20979C6[];
extern  VTBL_ENTRY _ZTV8S20979C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C6[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C9;
extern VTBL_ENTRY _ZTI8S20979C9[];
extern  VTBL_ENTRY _ZTV8S20979C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C9[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C4;
extern VTBL_ENTRY _ZTI8S20979C4[];
extern  VTBL_ENTRY _ZTV8S20979C4[];
extern Class_Descriptor cd_S20979C8;
extern VTBL_ENTRY _ZTI8S20979C8[];
extern  VTBL_ENTRY _ZTV8S20979C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C8[];
extern Class_Descriptor cd_S20979C5;
extern VTBL_ENTRY _ZTI8S20979C5[];
extern  VTBL_ENTRY _ZTV8S20979C5[];
extern Class_Descriptor cd_S20979C9;
extern VTBL_ENTRY _ZTI8S20979C9[];
extern  VTBL_ENTRY _ZTV8S20979C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S20979C9[];
extern Class_Descriptor cd_S20979C12;
extern VTBL_ENTRY _ZTI9S20979C12[];
extern  VTBL_ENTRY _ZTV9S20979C12[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20979C12[];
extern Class_Descriptor cd_S20979C10;
extern VTBL_ENTRY _ZTI9S20979C10[];
extern  VTBL_ENTRY _ZTV9S20979C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT9S20979C10[];
static Base_Class bases_S20979C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S20979C5,    ABISELECT(200,124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S20979C4,    ABISELECT(200,124), //bcp->offset
    92, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S20979C5,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S20979C6,    ABISELECT(24,16), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(240,148), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    5, //immediately_derived
  0, 0},
  {&cd_S20979C4,    ABISELECT(240,148), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(280,172), //bcp->offset
    141, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S20979C7,    ABISELECT(240,148), //bcp->offset
    114, //bcp->virtual_function_table_offset
    15, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    41, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    11, //immediately_derived
  0, 1},
  {&cd_S20979C5,    ABISELECT(56,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S20979C6,    ABISELECT(56,36), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    26, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(88,56), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S20979C9,    ABISELECT(88,56), //bcp->offset
    68, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(136,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S20979C4,    ABISELECT(136,84), //bcp->offset
    76, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S20979C8,    ABISELECT(56,36), //bcp->offset
    56, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(176,108), //bcp->offset
    88, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S20979C3,    ABISELECT(24,16), //bcp->offset
    11, //bcp->virtual_function_table_offset
    30, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    22, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S20979C5,    ABISELECT(304,188), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S20979C6,    ABISELECT(304,188), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    45, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(336,208), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S20979C6,    ABISELECT(336,208), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    48, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(368,228), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S20979C9,    ABISELECT(368,228), //bcp->offset
    214, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    50, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(416,256), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S20979C4,    ABISELECT(416,256), //bcp->offset
    222, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S20979C8,    ABISELECT(336,208), //bcp->offset
    202, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    47, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(456,280), //bcp->offset
    234, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S20979C3,    ABISELECT(304,188), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(480,296), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S20979C9,    ABISELECT(480,296), //bcp->offset
    238, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    63, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S20979C11,    ABISELECT(656,400), //bcp->offset
    278, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    41, //immediately_derived
  0, 1},
  {&cd_S20979C5,    ABISELECT(528,324), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    32, //immediately_derived
  0, 0},
  {&cd_S20979C6,    ABISELECT(528,324), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    68, //bcp->base_subarray_index_in_construction_vtbl_array
    36, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(560,344), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    37, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S20979C9,    ABISELECT(560,344), //bcp->offset
    258, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    70, //bcp->base_subarray_index_in_construction_vtbl_array
    38, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(608,372), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    39, //init_seq
    36, //immediately_derived
  0, 0},
  {&cd_S20979C4,    ABISELECT(608,372), //bcp->offset
    266, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    40, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S20979C8,    ABISELECT(528,324), //bcp->offset
    246, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    67, //bcp->base_subarray_index_in_construction_vtbl_array
    41, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S20979C5,    ABISELECT(712,448), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S20979C9,    ABISELECT(712,448), //bcp->offset
    305, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    104, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    40, //immediately_derived
  0, 1},
  {&cd_S20979C12,    ABISELECT(696,436), //bcp->offset
    288, //bcp->virtual_function_table_offset
    12, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    94, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    41, //immediately_derived
  0, 1},
  {&cd_S20979C10,    ABISELECT(304,188), //bcp->offset
    147, //bcp->virtual_function_table_offset
    37, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    43, //bcp->base_subarray_index_in_construction_vtbl_array
    42, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S20979C2[];
extern void _ZN8S20979C23v46Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C33v25Ev();
extern void _ZN8S20979C33v26Ev();
extern void _ZN8S20979C33v27Ev();
extern void _ZN8S20979C33v28Ev();
extern void _ZN8S20979C33v29Ev();
extern void _ZN8S20979C33v30Ev();
extern void _ZN8S20979C33v31Ev();
extern void _ZN8S20979C33v32Ev();
extern void _ZN8S20979C33v33Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C33v25Ev();
extern void _ZN8S20979C33v26Ev();
extern void _ZN8S20979C33v27Ev();
extern void _ZN8S20979C33v28Ev();
extern void _ZN8S20979C33v29Ev();
extern void _ZN8S20979C33v30Ev();
extern void _ZN8S20979C33v31Ev();
extern void _ZN8S20979C33v32Ev();
extern void _ZN8S20979C33v33Ev();
extern void _ZN9S20979C103v43Ev();
extern void _ZN9S20979C103v44Ev();
extern void _ZN9S20979C103v45Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN9S20979C113v34Ev();
extern void _ZN9S20979C113v35Ev();
extern void _ZN9S20979C113v36Ev();
extern void _ZN9S20979C113v37Ev();
extern void _ZN9S20979C123v38Ev();
extern void _ZN9S20979C123v39Ev();
extern void _ZN9S20979C123v40Ev();
extern void _ZN9S20979C123v41Ev();
extern void _ZN9S20979C123v42Ev();
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY vtc_S20979C2[] = {
  ABISELECT(712,448),
  ABISELECT(696,436),
  ABISELECT(656,400),
  ABISELECT(304,188),
  ABISELECT(280,172),
  ABISELECT(240,148),
  ABISELECT(200,124),
  ABISELECT(24,16),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C2[0]),
  (VTBL_ENTRY)&_ZN8S20979C23v46Ev,
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(64,40),
  ABISELECT(32,20),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(256,156),
  ABISELECT(216,132),
  ABISELECT(176,108),
  ABISELECT(-24,-16),
  (VTBL_ENTRY)&(_ZTI8S20979C2[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v25Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v26Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v27Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v28Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v29Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v30Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v31Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v32Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v33Ev,
  ABISELECT(184,112),
  ABISELECT(224,136),
  ABISELECT(144,88),
  ABISELECT(-56,-36),
  (VTBL_ENTRY)&(_ZTI8S20979C2[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
  ABISELECT(112,68),
  ABISELECT(192,116),
  ABISELECT(152,92),
  ABISELECT(-88,-56),
  (VTBL_ENTRY)&(_ZTI8S20979C2[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
  ABISELECT(-136,-84),
  (VTBL_ENTRY)&(_ZTI8S20979C2[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  ABISELECT(-176,-108),
  (VTBL_ENTRY)&(_ZTI8S20979C2[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-200,-124),
  (VTBL_ENTRY)&(_ZTI8S20979C2[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(-240,-148),
  (VTBL_ENTRY)&(_ZTI8S20979C2[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
  0,
  0,
  ABISELECT(-280,-172),
  (VTBL_ENTRY)&(_ZTI8S20979C2[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  0,
  0,
  0,
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(64,40),
  ABISELECT(32,20),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(408,260),
  ABISELECT(-280,-172),
  ABISELECT(392,248),
  ABISELECT(352,212),
  ABISELECT(-24,-16),
  ABISELECT(-64,-40),
  ABISELECT(-104,-64),
  ABISELECT(-304,-188),
  (VTBL_ENTRY)&(_ZTI8S20979C2[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v25Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v26Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v27Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v28Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v29Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v30Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v31Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v32Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v33Ev,
  (VTBL_ENTRY)&_ZN9S20979C103v43Ev,
  (VTBL_ENTRY)&_ZN9S20979C103v44Ev,
  (VTBL_ENTRY)&_ZN9S20979C103v45Ev,
  ABISELECT(-96,-60),
  ABISELECT(-56,-36),
  ABISELECT(-136,-84),
  ABISELECT(-336,-208),
  (VTBL_ENTRY)&(_ZTI8S20979C2[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
  ABISELECT(-168,-104),
  ABISELECT(-88,-56),
  ABISELECT(-128,-80),
  ABISELECT(-368,-228),
  (VTBL_ENTRY)&(_ZTI8S20979C2[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
  ABISELECT(-416,-256),
  (VTBL_ENTRY)&(_ZTI8S20979C2[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  ABISELECT(-456,-280),
  (VTBL_ENTRY)&(_ZTI8S20979C2[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  ABISELECT(-280,-172),
  ABISELECT(-200,-124),
  ABISELECT(-240,-148),
  ABISELECT(-480,-296),
  (VTBL_ENTRY)&(_ZTI8S20979C2[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
  ABISELECT(-288,-176),
  ABISELECT(-248,-152),
  ABISELECT(-328,-200),
  ABISELECT(-528,-324),
  (VTBL_ENTRY)&(_ZTI8S20979C2[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
  ABISELECT(-360,-220),
  ABISELECT(-280,-172),
  ABISELECT(-320,-196),
  ABISELECT(-560,-344),
  (VTBL_ENTRY)&(_ZTI8S20979C2[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
  ABISELECT(-608,-372),
  (VTBL_ENTRY)&(_ZTI8S20979C2[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  0,
  0,
  0,
  0,
  ABISELECT(-656,-400),
  (VTBL_ENTRY)&(_ZTI8S20979C2[0]),
  (VTBL_ENTRY)&_ZN9S20979C113v34Ev,
  (VTBL_ENTRY)&_ZN9S20979C113v35Ev,
  (VTBL_ENTRY)&_ZN9S20979C113v36Ev,
  (VTBL_ENTRY)&_ZN9S20979C113v37Ev,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-672,-420),
  ABISELECT(-456,-288),
  ABISELECT(-416,-264),
  ABISELECT(-496,-312),
  ABISELECT(-696,-436),
  (VTBL_ENTRY)&(_ZTI8S20979C2[0]),
  (VTBL_ENTRY)&_ZN9S20979C123v38Ev,
  (VTBL_ENTRY)&_ZN9S20979C123v39Ev,
  (VTBL_ENTRY)&_ZN9S20979C123v40Ev,
  (VTBL_ENTRY)&_ZN9S20979C123v41Ev,
  (VTBL_ENTRY)&_ZN9S20979C123v42Ev,
  0,
  0,
  0,
  ABISELECT(-512,-324),
  ABISELECT(-432,-276),
  ABISELECT(-472,-300),
  ABISELECT(-712,-448),
  (VTBL_ENTRY)&(_ZTI8S20979C2[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern VTBL_ENTRY _ZTV8S20979C2[];
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C33v25Ev();
extern void _ZN8S20979C33v26Ev();
extern void _ZN8S20979C33v27Ev();
extern void _ZN8S20979C33v28Ev();
extern void _ZN8S20979C33v29Ev();
extern void _ZN8S20979C33v30Ev();
extern void _ZN8S20979C33v31Ev();
extern void _ZN8S20979C33v32Ev();
extern void _ZN8S20979C33v33Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C3__8S20979C2[] = {
  ABISELECT(256,156),
  ABISELECT(216,132),
  ABISELECT(176,108),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v25Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v26Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v27Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v28Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v29Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v30Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v31Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v32Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v33Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C68S20979C3__8S20979C2[] = {
  ABISELECT(176,108),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C68S20979C3__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-176,-108),
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C88S20979C3__8S20979C2[] = {
  ABISELECT(184,112),
  ABISELECT(224,136),
  ABISELECT(144,88),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C68S20979C88S20979C3__A1__8S20979C2[] = {
  ABISELECT(144,88),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C68S20979C88S20979C3__A1__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-144,-88),
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C98S20979C88S20979C3__8S20979C2[] = {
  ABISELECT(112,68),
  ABISELECT(192,116),
  ABISELECT(152,92),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C98S20979C88S20979C3__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(-152,-92),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A1__8S20979C98S20979C88S20979C3__8S20979C2[] = {
  0,
  0,
  ABISELECT(-192,-116),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__A1__8S20979C98S20979C88S20979C3__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-112,-68),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__8S20979C88S20979C3__8S20979C2[] = {
  0,
  0,
  ABISELECT(-224,-136),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C88S20979C3__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-144,-88),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C9__8S20979C88S20979C3__8S20979C2[] = {
  ABISELECT(112,68),
  ABISELECT(192,116),
  ABISELECT(152,92),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C88S20979C3__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(-184,-112),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C3__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(-176,-108),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C3__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(-216,-132),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A3__8S20979C3__8S20979C2[] = {
  0,
  0,
  ABISELECT(-256,-156),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C8__8S20979C3__8S20979C2[] = {
  ABISELECT(184,112),
  ABISELECT(224,136),
  ABISELECT(144,88),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C98S20979C8__8S20979C3__8S20979C2[] = {
  ABISELECT(112,68),
  ABISELECT(192,116),
  ABISELECT(152,92),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C2[] = {
  ABISELECT(40,24),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C7[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A1__8S20979C7__8S20979C2[] = {
  0,
  0,
  ABISELECT(-40,-24),
  (VTBL_ENTRY)&(_ZTI8S20979C7[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C33v25Ev();
extern void _ZN8S20979C33v26Ev();
extern void _ZN8S20979C33v27Ev();
extern void _ZN8S20979C33v28Ev();
extern void _ZN8S20979C33v29Ev();
extern void _ZN8S20979C33v30Ev();
extern void _ZN8S20979C33v31Ev();
extern void _ZN8S20979C33v32Ev();
extern void _ZN8S20979C33v33Ev();
extern void _ZN9S20979C103v43Ev();
extern void _ZN9S20979C103v44Ev();
extern void _ZN9S20979C103v45Ev();
static  VTBL_ENTRY _tg__ZTV9S20979C10__8S20979C2[] = {
  ABISELECT(408,260),
  ABISELECT(-280,-172),
  ABISELECT(392,248),
  ABISELECT(352,212),
  ABISELECT(-24,-16),
  ABISELECT(-64,-40),
  ABISELECT(-104,-64),
  0,
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v25Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v26Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v27Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v28Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v29Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v30Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v31Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v32Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v33Ev,
  (VTBL_ENTRY)&_ZN9S20979C103v43Ev,
  (VTBL_ENTRY)&_ZN9S20979C103v44Ev,
  (VTBL_ENTRY)&_ZN9S20979C103v45Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C33v25Ev();
extern void _ZN8S20979C33v26Ev();
extern void _ZN8S20979C33v27Ev();
extern void _ZN8S20979C33v28Ev();
extern void _ZN8S20979C33v29Ev();
extern void _ZN8S20979C33v30Ev();
extern void _ZN8S20979C33v31Ev();
extern void _ZN8S20979C33v32Ev();
extern void _ZN8S20979C33v33Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C39S20979C10__A1__8S20979C2[] = {
  ABISELECT(-24,-16),
  ABISELECT(-64,-40),
  ABISELECT(-104,-64),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v25Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v26Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v27Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v28Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v29Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v30Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v31Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v32Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v33Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C68S20979C39S20979C10__A2__8S20979C2[] = {
  ABISELECT(-104,-64),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C68S20979C39S20979C10__A2__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(104,64),
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C88S20979C39S20979C10__A1__8S20979C2[] = {
  ABISELECT(-96,-60),
  ABISELECT(-56,-36),
  ABISELECT(-136,-84),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C68S20979C88S20979C39S20979C10__A3__8S20979C2[] = {
  ABISELECT(-136,-84),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C68S20979C88S20979C39S20979C10__A3__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(136,84),
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C98S20979C88S20979C39S20979C10__A1__8S20979C2[] = {
  ABISELECT(-168,-104),
  ABISELECT(-88,-56),
  ABISELECT(-128,-80),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C98S20979C88S20979C39S20979C10__A1__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(128,80),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A1__8S20979C98S20979C88S20979C39S20979C10__A1__8S20979C2[] = {
  0,
  0,
  ABISELECT(88,56),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__A1__8S20979C98S20979C88S20979C39S20979C10__A1__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(168,104),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__8S20979C88S20979C39S20979C10__A1__8S20979C2[] = {
  0,
  0,
  ABISELECT(56,36),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C88S20979C39S20979C10__A1__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(136,84),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C9__8S20979C88S20979C39S20979C10__A1__8S20979C2[] = {
  ABISELECT(-168,-104),
  ABISELECT(-88,-56),
  ABISELECT(-128,-80),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C88S20979C39S20979C10__A1__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(96,60),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C39S20979C10__A1__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(104,64),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C39S20979C10__A1__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(64,40),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A3__8S20979C39S20979C10__A1__8S20979C2[] = {
  0,
  0,
  ABISELECT(24,16),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C8__8S20979C39S20979C10__A1__8S20979C2[] = {
  ABISELECT(-96,-60),
  ABISELECT(-56,-36),
  ABISELECT(-136,-84),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C98S20979C8__8S20979C39S20979C10__A1__8S20979C2[] = {
  ABISELECT(-168,-104),
  ABISELECT(-88,-56),
  ABISELECT(-128,-80),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI8S20979C3[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C99S20979C10__A2__8S20979C2[] = {
  ABISELECT(-280,-172),
  ABISELECT(-200,-124),
  ABISELECT(-240,-148),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C99S20979C10__A2__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(240,148),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A1__8S20979C99S20979C10__A2__8S20979C2[] = {
  0,
  0,
  ABISELECT(200,124),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__A1__8S20979C99S20979C10__A2__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(280,172),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C89S20979C10__A2__8S20979C2[] = {
  ABISELECT(-288,-176),
  ABISELECT(-248,-152),
  ABISELECT(-328,-200),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C68S20979C89S20979C10__A4__8S20979C2[] = {
  ABISELECT(-328,-200),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C68S20979C89S20979C10__A4__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(328,200),
  (VTBL_ENTRY)&(_ZTI8S20979C6[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C98S20979C89S20979C10__A3__8S20979C2[] = {
  ABISELECT(-360,-220),
  ABISELECT(-280,-172),
  ABISELECT(-320,-196),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C98S20979C89S20979C10__A3__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(320,196),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A1__8S20979C98S20979C89S20979C10__A3__8S20979C2[] = {
  0,
  0,
  ABISELECT(280,172),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__A1__8S20979C98S20979C89S20979C10__A3__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(360,220),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__8S20979C89S20979C10__A2__8S20979C2[] = {
  0,
  0,
  ABISELECT(248,152),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__8S20979C89S20979C10__A2__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(328,200),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C9__8S20979C89S20979C10__A2__8S20979C2[] = {
  ABISELECT(-360,-220),
  ABISELECT(-280,-172),
  ABISELECT(-320,-196),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C89S20979C10__A2__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(288,176),
  (VTBL_ENTRY)&(_ZTI8S20979C8[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__9S20979C10__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(104,64),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__9S20979C10__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(64,40),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A3__9S20979C10__8S20979C2[] = {
  0,
  0,
  ABISELECT(24,16),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C88S20979C3__9S20979C10__8S20979C2[] = {
  ABISELECT(-96,-60),
  ABISELECT(-56,-36),
  ABISELECT(-136,-84),
  ABISELECT(-32,-20),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C98S20979C88S20979C3__9S20979C10__8S20979C2[] = {
  ABISELECT(-168,-104),
  ABISELECT(-88,-56),
  ABISELECT(-128,-80),
  ABISELECT(-64,-40),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C9__A__9S20979C10__8S20979C2[] = {
  ABISELECT(-280,-172),
  ABISELECT(-200,-124),
  ABISELECT(-240,-148),
  ABISELECT(-176,-108),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN9S20979C113v34Ev();
extern void _ZN9S20979C113v35Ev();
extern void _ZN9S20979C113v36Ev();
extern void _ZN9S20979C113v37Ev();
static  VTBL_ENTRY _tg__ZTV9S20979C11__9S20979C10__8S20979C2[] = {
  0,
  0,
  0,
  0,
  ABISELECT(-352,-212),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN9S20979C113v34Ev,
  (VTBL_ENTRY)&_ZN9S20979C113v35Ev,
  (VTBL_ENTRY)&_ZN9S20979C113v36Ev,
  (VTBL_ENTRY)&_ZN9S20979C113v37Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C8__A1__9S20979C10__8S20979C2[] = {
  ABISELECT(-288,-176),
  ABISELECT(-248,-152),
  ABISELECT(-328,-200),
  ABISELECT(-224,-136),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C98S20979C8__A2__9S20979C10__8S20979C2[] = {
  ABISELECT(-360,-220),
  ABISELECT(-280,-172),
  ABISELECT(-320,-196),
  ABISELECT(-256,-156),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN9S20979C123v38Ev();
extern void _ZN9S20979C123v39Ev();
extern void _ZN9S20979C123v40Ev();
extern void _ZN9S20979C123v41Ev();
extern void _ZN9S20979C123v42Ev();
static  VTBL_ENTRY _tg__ZTV9S20979C12__9S20979C10__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  ABISELECT(16,12),
  ABISELECT(-672,-420),
  ABISELECT(-456,-288),
  ABISELECT(-416,-264),
  ABISELECT(-496,-312),
  ABISELECT(-392,-248),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN9S20979C123v38Ev,
  (VTBL_ENTRY)&_ZN9S20979C123v39Ev,
  (VTBL_ENTRY)&_ZN9S20979C123v40Ev,
  (VTBL_ENTRY)&_ZN9S20979C123v41Ev,
  (VTBL_ENTRY)&_ZN9S20979C123v42Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C33v25Ev();
extern void _ZN8S20979C33v26Ev();
extern void _ZN8S20979C33v27Ev();
extern void _ZN8S20979C33v28Ev();
extern void _ZN8S20979C33v29Ev();
extern void _ZN8S20979C33v30Ev();
extern void _ZN8S20979C33v31Ev();
extern void _ZN8S20979C33v32Ev();
extern void _ZN8S20979C33v33Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C3__A1__9S20979C10__8S20979C2[] = {
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(64,40),
  ABISELECT(32,20),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(256,156),
  ABISELECT(216,132),
  ABISELECT(176,108),
  ABISELECT(280,172),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v25Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v26Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v27Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v28Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v29Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v30Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v31Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v32Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v33Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C88S20979C3__A2__9S20979C10__8S20979C2[] = {
  ABISELECT(184,112),
  ABISELECT(224,136),
  ABISELECT(144,88),
  ABISELECT(248,152),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C98S20979C88S20979C3__A3__9S20979C10__8S20979C2[] = {
  ABISELECT(112,68),
  ABISELECT(192,116),
  ABISELECT(152,92),
  ABISELECT(216,132),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C48S20979C88S20979C3__A4__9S20979C10__8S20979C2[] = {
  ABISELECT(168,104),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C58S20979C3__A16__9S20979C10__8S20979C2[] = {
  ABISELECT(128,80),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C9__A4__9S20979C10__8S20979C2[] = {
  0,
  0,
  0,
  ABISELECT(-512,-324),
  ABISELECT(-432,-276),
  ABISELECT(-472,-300),
  ABISELECT(-408,-260),
  (VTBL_ENTRY)&(_ZTI9S20979C10[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN9S20979C123v38Ev();
extern void _ZN9S20979C123v39Ev();
extern void _ZN9S20979C123v40Ev();
extern void _ZN9S20979C123v41Ev();
extern void _ZN9S20979C123v42Ev();
static  VTBL_ENTRY _tg__ZTV9S20979C12__8S20979C2[] = {
  ABISELECT(16,12),
  ABISELECT(-672,-420),
  ABISELECT(-456,-288),
  ABISELECT(-416,-264),
  ABISELECT(-496,-312),
  0,
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN9S20979C123v38Ev,
  (VTBL_ENTRY)&_ZN9S20979C123v39Ev,
  (VTBL_ENTRY)&_ZN9S20979C123v40Ev,
  (VTBL_ENTRY)&_ZN9S20979C123v41Ev,
  (VTBL_ENTRY)&_ZN9S20979C123v42Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__9S20979C12__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(496,312),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A1__9S20979C12__8S20979C2[] = {
  0,
  0,
  ABISELECT(416,264),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__9S20979C12__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(456,288),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C33v25Ev();
extern void _ZN8S20979C33v26Ev();
extern void _ZN8S20979C33v27Ev();
extern void _ZN8S20979C33v28Ev();
extern void _ZN8S20979C33v29Ev();
extern void _ZN8S20979C33v30Ev();
extern void _ZN8S20979C33v31Ev();
extern void _ZN8S20979C33v32Ev();
extern void _ZN8S20979C33v33Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C3__9S20979C12__8S20979C2[] = {
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(112,68),
  ABISELECT(64,40),
  ABISELECT(32,20),
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(256,156),
  ABISELECT(216,132),
  ABISELECT(176,108),
  ABISELECT(672,420),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v25Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v26Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v27Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v28Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v29Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v30Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v31Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v32Ev,
  (VTBL_ENTRY)&_ZN8S20979C33v33Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C63v17Ev();
extern void _ZN8S20979C63v18Ev();
extern void _ZN8S20979C63v19Ev();
extern void _ZN8S20979C63v20Ev();
extern void _ZN8S20979C83v24Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C88S20979C3__9S20979C12__8S20979C2[] = {
  ABISELECT(184,112),
  ABISELECT(224,136),
  ABISELECT(144,88),
  ABISELECT(640,400),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v17Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v18Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v19Ev,
  (VTBL_ENTRY)&_ZN8S20979C63v20Ev,
  (VTBL_ENTRY)&_ZN8S20979C83v24Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C98S20979C88S20979C3__9S20979C12__8S20979C2[] = {
  ABISELECT(112,68),
  ABISELECT(192,116),
  ABISELECT(152,92),
  ABISELECT(608,380),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C48S20979C88S20979C3__A2__9S20979C12__8S20979C2[] = {
  ABISELECT(560,352),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C58S20979C3__A7__9S20979C12__8S20979C2[] = {
  ABISELECT(520,328),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C9__A1__9S20979C12__8S20979C2[] = {
  0,
  0,
  0,
  ABISELECT(-512,-324),
  ABISELECT(-432,-276),
  ABISELECT(-472,-300),
  ABISELECT(-16,-12),
  (VTBL_ENTRY)&(_ZTI9S20979C12[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C93v23Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C9__A4__8S20979C2[] = {
  ABISELECT(-512,-324),
  ABISELECT(-432,-276),
  ABISELECT(-472,-300),
  0,
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C93v23Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
extern void _ZN8S20979C73v21Ev();
extern void _ZN8S20979C73v22Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C7__8S20979C9__A4__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(40,24),
  ABISELECT(472,300),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v21Ev,
  (VTBL_ENTRY)&_ZN8S20979C73v22Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C5__A1__8S20979C9__A4__8S20979C2[] = {
  0,
  0,
  ABISELECT(432,276),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
};
extern void _ZN8S20979C52v7Ev();
extern void _ZN8S20979C52v8Ev();
extern void _ZN8S20979C42v9Ev();
extern void _ZN8S20979C43v10Ev();
extern void _ZN8S20979C43v11Ev();
extern void _ZN8S20979C43v12Ev();
extern void _ZN8S20979C43v13Ev();
extern void _ZN8S20979C43v14Ev();
extern void _ZN8S20979C43v15Ev();
extern void _ZN8S20979C43v16Ev();
static  VTBL_ENTRY _tg__ZTV8S20979C4__A1__8S20979C9__A4__8S20979C2[] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  ABISELECT(512,324),
  (VTBL_ENTRY)&(_ZTI8S20979C9[0]),
  (VTBL_ENTRY)&_ZN8S20979C52v7Ev,
  (VTBL_ENTRY)&_ZN8S20979C52v8Ev,
  (VTBL_ENTRY)&_ZN8S20979C42v9Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v10Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v11Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v12Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v13Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v14Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v15Ev,
  (VTBL_ENTRY)&_ZN8S20979C43v16Ev,
};
static  VTT_ENTRY vtt_S20979C2[] = {
  {&(_ZTV8S20979C2[10]),  10,316},
  {&(_ZTV8S20979C2[41]),  41,316},
  {&(_ZTV8S20979C2[104]),  104,316},
  {&(_ZTV8S20979C2[129]),  129,316},
  {&(_ZTV8S20979C2[145]),  145,316},
  {&(_ZTV8S20979C2[61]),  61,316},
  {&(_ZTV8S20979C2[73]),  73,316},
  {&(_ZTV8S20979C2[78]),  78,316},
  {&(_ZTV8S20979C2[90]),  90,316},
  {&(_ZTV8S20979C2[184]),  184,316},
  {&(_ZTV8S20979C2[207]),  207,316},
  {&(_ZTV8S20979C2[219]),  219,316},
  {&(_ZTV8S20979C2[224]),  224,316},
  {&(_ZTV8S20979C2[236]),  236,316},
  {&(_ZTV8S20979C2[243]),  243,316},
  {&(_ZTV8S20979C2[284]),  284,316},
  {&(_ZTV8S20979C2[251]),  251,316},
  {&(_ZTV8S20979C2[263]),  263,316},
  {&(_ZTV8S20979C2[268]),  268,316},
  {&(_ZTV8S20979C2[300]),  300,316},
  {&(_ZTV8S20979C2[313]),  313,316},
  {&(_tg__ZTV8S20979C3__8S20979C2[5]),  5,20},
  {&(_tg__ZTV8S20979C68S20979C3__8S20979C2[3]),  3,9},
  {&(_tg__ZTV8S20979C4__8S20979C68S20979C3__8S20979C2[12]),  12,22},
  {&(_tg__ZTV8S20979C88S20979C3__8S20979C2[5]),  5,12},
  {&(_tg__ZTV8S20979C68S20979C88S20979C3__A1__8S20979C2[3]),  3,9},
  {&(_tg__ZTV8S20979C4__8S20979C68S20979C88S20979C3__A1__8S20979C2[12]),  12,22},
  {&(_tg__ZTV8S20979C98S20979C88S20979C3__8S20979C2[5]),  5,8},
  {&(_tg__ZTV8S20979C7__8S20979C98S20979C88S20979C3__8S20979C2[15]),  15,27},
  {&(_tg__ZTV8S20979C5__A1__8S20979C98S20979C88S20979C3__8S20979C2[4]),  4,6},
  {&(_tg__ZTV8S20979C4__A1__8S20979C98S20979C88S20979C3__8S20979C2[12]),  12,22},
  {&(_tg__ZTV8S20979C5__8S20979C88S20979C3__8S20979C2[4]),  4,6},
  {&(_tg__ZTV8S20979C4__8S20979C88S20979C3__8S20979C2[12]),  12,22},
  {&(_tg__ZTV8S20979C9__8S20979C88S20979C3__8S20979C2[5]),  5,8},
  {&(_tg__ZTV8S20979C7__8S20979C88S20979C3__8S20979C2[15]),  15,27},
  {&(_tg__ZTV8S20979C4__8S20979C3__8S20979C2[12]),  12,22},
  {&(_tg__ZTV8S20979C7__8S20979C3__8S20979C2[15]),  15,27},
  {&(_tg__ZTV8S20979C5__A3__8S20979C3__8S20979C2[4]),  4,6},
  {&(_tg__ZTV8S20979C8__8S20979C3__