// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
// RUN: c_compiler -c -o %t1.o -I "common" "common/testsuite.c"
// RUN: cxx_compiler cxx_rtti -c %s -I "common" -o %t2.o
// RUN: c_compiler -c %s -I "common" -o %t3.o
// RUN: linker -o %t2%exeext  %t1.o %t2.o %t3.o
// RUN: runtool %t2%exeext | checker "TEST PASSED"
#include "testsuite.h"
#ifdef __cplusplus

struct  S2440C7_nt  {
  void  mf2440c7(); // _ZN10S2440C7_nt8mf2440c7Ev
};
//SIG(-1 S2440C7_nt) C1{ m}


void  S2440C7_nt ::mf2440c7(){}

//skip512 S2440C7_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2440C6_nt  {
  void *s2440c6f0;
  int s2440c6f1;
  ::S2440C7_nt s2440c6f2;
  ::S2440C7_nt s2440c6f3;
  void  mf2440c6(); // _ZN10S2440C6_nt8mf2440c6Ev
};
//SIG(-1 S2440C6_nt) C1{ m Fp Fi FC2{ m} FC2}


void  S2440C6_nt ::mf2440c6(){}

//skip512 S2440C6_nt

#else // __cplusplus

Class_Descriptor cd_S2440C6_nt = {  "S2440C6_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2440C5_nt  : S2440C6_nt {
};
//SIG(-1 S2440C5_nt) C1{ BC2{ m Fp Fi FC3{ m} FC3}}



//skip512 S2440C5_nt

#else // __cplusplus

extern Class_Descriptor cd_S2440C6_nt;
static Base_Class bases_S2440C5_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2440C6_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2440C4_nt  {
  void *s2440c4f0;
  int s2440c4f1;
  ::S2440C5_nt s2440c4f2;
  ::S2440C5_nt s2440c4f3;
  int s2440c4f4;
  virtual  ~S2440C4_nt(); // _ZN10S2440C4_ntD1Ev
  virtual void  v9(); // _ZN10S2440C4_nt2v9Ev
  virtual void  v10(); // _ZN10S2440C4_nt3v10Ev
  virtual void  v11(); // _ZN10S2440C4_nt3v11Ev
  virtual void  v12(); // _ZN10S2440C4_nt3v12Ev
  virtual void  v13(); // _ZN10S2440C4_nt3v13Ev
  virtual void  v14(); // _ZN10S2440C4_nt3v14Ev
  virtual void  v15(); // _ZN10S2440C4_nt3v15Ev
  virtual void  v16(); // _ZN10S2440C4_nt3v16Ev
  virtual void  v17(); // _ZN10S2440C4_nt3v17Ev
  virtual void  v18(); // _ZN10S2440C4_nt3v18Ev
  virtual void  v19(); // _ZN10S2440C4_nt3v19Ev
  virtual void  v20(); // _ZN10S2440C4_nt3v20Ev
  virtual void  v21(); // _ZN10S2440C4_nt3v21Ev
  virtual void  v22(); // _ZN10S2440C4_nt3v22Ev
  virtual void  v23(); // _ZN10S2440C4_nt3v23Ev
  virtual void  v24(); // _ZN10S2440C4_nt3v24Ev
  virtual void  v25(); // _ZN10S2440C4_nt3v25Ev
  virtual void  v26(); // _ZN10S2440C4_nt3v26Ev
  virtual void  v27(); // _ZN10S2440C4_nt3v27Ev
  virtual void  v28(); // _ZN10S2440C4_nt3v28Ev
  virtual void  v29(); // _ZN10S2440C4_nt3v29Ev
  virtual void  v30(); // _ZN10S2440C4_nt3v30Ev
  virtual void  v31(); // _ZN10S2440C4_nt3v31Ev
  S2440C4_nt(); // tgen
};
//SIG(-1 S2440C4_nt) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC2{ BC3{ m Fp Fi FC4{ m} FC4}} FC2 Fi}


 S2440C4_nt ::~S2440C4_nt(){ note_dtor("S2440C4_nt", this);}
void  S2440C4_nt ::v9(){vfunc_called(this, "_ZN10S2440C4_nt2v9Ev");}
void  S2440C4_nt ::v10(){vfunc_called(this, "_ZN10S2440C4_nt3v10Ev");}
void  S2440C4_nt ::v11(){vfunc_called(this, "_ZN10S2440C4_nt3v11Ev");}
void  S2440C4_nt ::v12(){vfunc_called(this, "_ZN10S2440C4_nt3v12Ev");}
void  S2440C4_nt ::v13(){vfunc_called(this, "_ZN10S2440C4_nt3v13Ev");}
void  S2440C4_nt ::v14(){vfunc_called(this, "_ZN10S2440C4_nt3v14Ev");}
void  S2440C4_nt ::v15(){vfunc_called(this, "_ZN10S2440C4_nt3v15Ev");}
void  S2440C4_nt ::v16(){vfunc_called(this, "_ZN10S2440C4_nt3v16Ev");}
void  S2440C4_nt ::v17(){vfunc_called(this, "_ZN10S2440C4_nt3v17Ev");}
void  S2440C4_nt ::v18(){vfunc_called(this, "_ZN10S2440C4_nt3v18Ev");}
void  S2440C4_nt ::v19(){vfunc_called(this, "_ZN10S2440C4_nt3v19Ev");}
void  S2440C4_nt ::v20(){vfunc_called(this, "_ZN10S2440C4_nt3v20Ev");}
void  S2440C4_nt ::v21(){vfunc_called(this, "_ZN10S2440C4_nt3v21Ev");}
void  S2440C4_nt ::v22(){vfunc_called(this, "_ZN10S2440C4_nt3v22Ev");}
void  S2440C4_nt ::v23(){vfunc_called(this, "_ZN10S2440C4_nt3v23Ev");}
void  S2440C4_nt ::v24(){vfunc_called(this, "_ZN10S2440C4_nt3v24Ev");}
void  S2440C4_nt ::v25(){vfunc_called(this, "_ZN10S2440C4_nt3v25Ev");}
void  S2440C4_nt ::v26(){vfunc_called(this, "_ZN10S2440C4_nt3v26Ev");}
void  S2440C4_nt ::v27(){vfunc_called(this, "_ZN10S2440C4_nt3v27Ev");}
void  S2440C4_nt ::v28(){vfunc_called(this, "_ZN10S2440C4_nt3v28Ev");}
void  S2440C4_nt ::v29(){vfunc_called(this, "_ZN10S2440C4_nt3v29Ev");}
void  S2440C4_nt ::v30(){vfunc_called(this, "_ZN10S2440C4_nt3v30Ev");}
void  S2440C4_nt ::v31(){vfunc_called(this, "_ZN10S2440C4_nt3v31Ev");}
S2440C4_nt ::S2440C4_nt(){ note_ctor("S2440C4_nt", this);} // tgen

//skip512 S2440C4_nt

#else // __cplusplus

extern void _ZN10S2440C4_ntC1Ev();
extern void _ZN10S2440C4_ntD1Ev();
Name_Map name_map_S2440C4_nt[] = {
  NSPAIR(_ZN10S2440C4_ntC1Ev),
  NSPAIR(_ZN10S2440C4_ntD1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI10S2440C4_nt[];
extern void _ZN10S2440C4_ntD1Ev();
extern void _ZN10S2440C4_ntD0Ev();
extern void _ZN10S2440C4_nt2v9Ev();
extern void _ZN10S2440C4_nt3v10Ev();
extern void _ZN10S2440C4_nt3v11Ev();
extern void _ZN10S2440C4_nt3v12Ev();
extern void _ZN10S2440C4_nt3v13Ev();
extern void _ZN10S2440C4_nt3v14Ev();
extern void _ZN10S2440C4_nt3v15Ev();
extern void _ZN10S2440C4_nt3v16Ev();
extern void _ZN10S2440C4_nt3v17Ev();
extern void _ZN10S2440C4_nt3v18Ev();
extern void _ZN10S2440C4_nt3v19Ev();
extern void _ZN10S2440C4_nt3v20Ev();
extern void _ZN10S2440C4_nt3v21Ev();
extern void _ZN10S2440C4_nt3v22Ev();
extern void _ZN10S2440C4_nt3v23Ev();
extern void _ZN10S2440C4_nt3v24Ev();
extern void _ZN10S2440C4_nt3v25Ev();
extern void _ZN10S2440C4_nt3v26Ev();
extern void _ZN10S2440C4_nt3v27Ev();
extern void _ZN10S2440C4_nt3v28Ev();
extern void _ZN10S2440C4_nt3v29Ev();
extern void _ZN10S2440C4_nt3v30Ev();
extern void _ZN10S2440C4_nt3v31Ev();
static  VTBL_ENTRY vtc_S2440C4_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2440C4_nt[0]),
  (VTBL_ENTRY)&_ZN10S2440C4_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v31Ev,
};
extern VTBL_ENTRY _ZTI10S2440C4_nt[];
VTBL_ENTRY *P__ZTI10S2440C4_nt = _ZTI10S2440C4_nt; 
extern  VTBL_ENTRY _ZTV10S2440C4_nt[];
Class_Descriptor cd_S2440C4_nt = {  "S2440C4_nt", // class name
  0,0,//no base classes
  &(vtc_S2440C4_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI10S2440C4_nt),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV10S2440C4_nt),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2440C14_nt  {
  __tsi64 s2440c14f0[2];
  void  mf2440c14(); // _ZN11S2440C14_nt9mf2440c14Ev
};
//SIG(-1 S2440C14_nt) C1{ m FL[2]}


void  S2440C14_nt ::mf2440c14(){}

//skip512 S2440C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2440C13_nt  {
  ::S2440C14_nt s2440c13f0;
  void  mf2440c13(); // _ZN11S2440C13_nt9mf2440c13Ev
};
//SIG(-1 S2440C13_nt) C1{ m FC2{ m FL[2]}}


void  S2440C13_nt ::mf2440c13(){}

//skip512 S2440C13_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2440C17_nt  {
  ::S2440C13_nt s2440c17f0;
  void  mf2440c17(); // _ZN11S2440C17_nt9mf2440c17Ev
};
//SIG(-1 S2440C17_nt) C1{ m FC2{ m FC3{ m FL[2]}}}


void  S2440C17_nt ::mf2440c17(){}

//skip512 S2440C17_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2440C18_nt  {
  ::S2440C13_nt s2440c18f0;
  ::S2440C13_nt s2440c18f1;
  ::S2440C13_nt s2440c18f2;
  ::S2440C13_nt s2440c18f3;
  void  mf2440c18(); // _ZN11S2440C18_nt9mf2440c18Ev
};
//SIG(-1 S2440C18_nt) C1{ m FC2{ m FC3{ m FL[2]}} FC2 FC2 FC2}


void  S2440C18_nt ::mf2440c18(){}

//skip512 S2440C18_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2440C21  {
  void  mf2440c21(); // _ZN8S2440C219mf2440c21Ev
};
//SIG(-1 S2440C21) C1{ m}


void  S2440C21 ::mf2440c21(){}

static void Test_S2440C21()
{
  {
    init_simple_test("S2440C21");
    S2440C21 lv;
    check2(sizeof(lv), 1, "sizeof(S2440C21)");
    check2(__alignof__(lv), 1, "__alignof__(S2440C21)");
  }
}
static Arrange_To_Call_Me vS2440C21(Test_S2440C21, "S2440C21", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2440C20_nt  {
  void *s2440c20f0;
  int s2440c20f1;
  ::S2440C21 s2440c20f2;
  void  mf2440c20(); // _ZN11S2440C20_nt9mf2440c20Ev
};
//SIG(-1 S2440C20_nt) C1{ m Fp Fi FC2{ m}}


void  S2440C20_nt ::mf2440c20(){}

//skip512 S2440C20_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2440C19_nt  {
  ::S2440C20_nt s2440c19f0;
  int s2440c19f1;
  void  mf2440c19(); // _ZN11S2440C19_nt9mf2440c19Ev
};
//SIG(-1 S2440C19_nt) C1{ m FC2{ m Fp Fi FC3{ m}} Fi}


void  S2440C19_nt ::mf2440c19(){}

//skip512 S2440C19_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2440C24  {
  void  mf2440c24(); // _ZN8S2440C249mf2440c24Ev
};
//SIG(-1 S2440C24) C1{ m}


void  S2440C24 ::mf2440c24(){}

static void Test_S2440C24()
{
  {
    init_simple_test("S2440C24");
    S2440C24 lv;
    check2(sizeof(lv), 1, "sizeof(S2440C24)");
    check2(__alignof__(lv), 1, "__alignof__(S2440C24)");
  }
}
static Arrange_To_Call_Me vS2440C24(Test_S2440C24, "S2440C24", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2440C22  {
  void *s2440c22f0;
  int s2440c22f1;
  ::S2440C21 s2440c22f2;
  ::S2440C24 s2440c22f3;
  void  mf2440c22(); // _ZN8S2440C229mf2440c22Ev
};
//SIG(-1 S2440C22) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S2440C22 ::mf2440c22(){}

static void Test_S2440C22()
{
  {
    init_simple_test("S2440C22");
    S2440C22 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2440C22)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2440C22)");
    check_field_offset(lv, s2440c22f0, 0, "S2440C22.s2440c22f0");
    check_field_offset(lv, s2440c22f1, ABISELECT(8,4), "S2440C22.s2440c22f1");
    check_field_offset(lv, s2440c22f2, ABISELECT(12,8), "S2440C22.s2440c22f2");
    check_field_offset(lv, s2440c22f3, ABISELECT(13,9), "S2440C22.s2440c22f3");
  }
}
static Arrange_To_Call_Me vS2440C22(Test_S2440C22, "S2440C22", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S2440C22 = {  "S2440C22", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2440C28  {
  void  mf2440c28(); // _ZN8S2440C289mf2440c28Ev
};
//SIG(-1 S2440C28) C1{ m}


void  S2440C28 ::mf2440c28(){}

static void Test_S2440C28()
{
  {
    init_simple_test("S2440C28");
    S2440C28 lv;
    check2(sizeof(lv), 1, "sizeof(S2440C28)");
    check2(__alignof__(lv), 1, "__alignof__(S2440C28)");
  }
}
static Arrange_To_Call_Me vS2440C28(Test_S2440C28, "S2440C28", 1);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2440C26  {
  void *s2440c26f0;
  int s2440c26f1;
  ::S2440C24 s2440c26f2;
  ::S2440C28 s2440c26f3;
  void  mf2440c26(); // _ZN8S2440C269mf2440c26Ev
};
//SIG(-1 S2440C26) C1{ m Fp Fi FC2{ m} FC3{ m}}


void  S2440C26 ::mf2440c26(){}

static void Test_S2440C26()
{
  {
    init_simple_test("S2440C26");
    S2440C26 lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2440C26)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2440C26)");
    check_field_offset(lv, s2440c26f0, 0, "S2440C26.s2440c26f0");
    check_field_offset(lv, s2440c26f1, ABISELECT(8,4), "S2440C26.s2440c26f1");
    check_field_offset(lv, s2440c26f2, ABISELECT(12,8), "S2440C26.s2440c26f2");
    check_field_offset(lv, s2440c26f3, ABISELECT(13,9), "S2440C26.s2440c26f3");
  }
}
static Arrange_To_Call_Me vS2440C26(Test_S2440C26, "S2440C26", ABISELECT(16,12));

#else // __cplusplus

Class_Descriptor cd_S2440C26 = {  "S2440C26", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2440C25  : S2440C26 {
};
//SIG(-1 S2440C25) C1{ BC2{ m Fp Fi FC3{ m} FC4{ m}}}



static void Test_S2440C25()
{
  extern Class_Descriptor cd_S2440C25;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(3,4)];
    init_test(&cd_S2440C25, buf);
    S2440C25 &lv = *(new (buf) S2440C25());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(16,12), "sizeof(S2440C25)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2440C25)");
    check_base_class_offset(lv, (S2440C26*), 0, "S2440C25");
    test_class_info(&lv, &cd_S2440C25);
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2440C25(Test_S2440C25, "S2440C25", ABISELECT(16,12));

#else // __cplusplus

extern Class_Descriptor cd_S2440C26;
static Base_Class bases_S2440C25[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2440C26,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
Class_Descriptor cd_S2440C25 = {  "S2440C25", // class name
  bases_S2440C25, 1,
  0, // no vftv
  0, //no vtt
  ABISELECT(16,12), // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2440C29_nt  {
  void *s2440c29f0;
  int s2440c29f1[2];
  ::S2440C28 s2440c29f2;
  void  mf2440c29(); // _ZN11S2440C29_nt9mf2440c29Ev
};
//SIG(-1 S2440C29_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S2440C29_nt ::mf2440c29(){}

//skip512 S2440C29_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2440C38  {
  void  mf2440c38(); // _ZN8S2440C389mf2440c38Ev
};
//SIG(-1 S2440C38) C1{ m}


void  S2440C38 ::mf2440c38(){}

static void Test_S2440C38()
{
  {
    init_simple_test("S2440C38");
    S2440C38 lv;
    check2(sizeof(lv), 1, "sizeof(S2440C38)");
    check2(__alignof__(lv), 1, "__alignof__(S2440C38)");
  }
}
static Arrange_To_Call_Me vS2440C38(Test_S2440C38, "S2440C38", 1);

#else // __cplusplus

Class_Descriptor cd_S2440C38 = {  "S2440C38", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2440C37  {
  void *s2440c37f0;
  int s2440c37f1[2];
  ::S2440C38 s2440c37f2;
  void  mf2440c37(); // _ZN8S2440C379mf2440c37Ev
};
//SIG(-1 S2440C37) C1{ m Fp Fi[2] FC2{ m}}


void  S2440C37 ::mf2440c37(){}

static void Test_S2440C37()
{
  {
    init_simple_test("S2440C37");
    S2440C37 lv;
    check2(sizeof(lv), ABISELECT(24,16), "sizeof(S2440C37)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2440C37)");
    check_field_offset(lv, s2440c37f0, 0, "S2440C37.s2440c37f0");
    check_field_offset(lv, s2440c37f1, ABISELECT(8,4), "S2440C37.s2440c37f1");
    check_field_offset(lv, s2440c37f2, ABISELECT(16,12), "S2440C37.s2440c37f2");
  }
}
static Arrange_To_Call_Me vS2440C37(Test_S2440C37, "S2440C37", ABISELECT(24,16));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2440C3_nt  : S2440C4_nt {
  ::S2440C13_nt s2440c3f0;
  ::S2440C13_nt s2440c3f1;
  ::S2440C13_nt s2440c3f2;
  ::S2440C13_nt s2440c3f3;
  ::S2440C17_nt s2440c3f4;
  ::S2440C18_nt s2440c3f5;
  ::S2440C18_nt s2440c3f6;
  ::S2440C13_nt s2440c3f7;
  ::S2440C13_nt s2440c3f8;
  ::S2440C13_nt s2440c3f9;
  void *s2440c3f10;
  ::S2440C17_nt s2440c3f11;
  ::S2440C19_nt s2440c3f12;
  int s2440c3f13;
  void *s2440c3f14[7];
  ::S2440C22 s2440c3f15;
  int s2440c3f16:8;
  int s2440c3f17:8;
  int s2440c3f18:16;
  int s2440c3f19:16;
  int s2440c3f20:8;
  int s2440c3f21:8;
  int s2440c3f22:8;
  int s2440c3f23:32;
  int s2440c3f24:8;
  int s2440c3f25:4;
  int s2440c3f26:4;
  int s2440c3f27:4;
  int s2440c3f28:4;
  int s2440c3f29:4;
  int s2440c3f30:4;
  int s2440c3f31:4;
  int s2440c3f32:4;
  int s2440c3f33:4;
  int s2440c3f34:4;
  unsigned char s2440c3f35:1;
  unsigned char s2440c3f36:1;
  unsigned char s2440c3f37:1;
  unsigned char s2440c3f38:1;
  unsigned char s2440c3f39:1;
  unsigned char s2440c3f40:1;
  unsigned char s2440c3f41:1;
  unsigned char s2440c3f42:1;
  unsigned char s2440c3f43:1;
  unsigned char s2440c3f44:1;
  unsigned char s2440c3f45:1;
  unsigned char s2440c3f46:1;
  unsigned char s2440c3f47:1;
  unsigned char s2440c3f48:1;
  unsigned char s2440c3f49:1;
  unsigned char s2440c3f50:1;
  unsigned char s2440c3f51:1;
  unsigned char s2440c3f52:1;
  unsigned char s2440c3f53:1;
  unsigned char s2440c3f54:1;
  unsigned char s2440c3f55:1;
  unsigned char s2440c3f56:1;
  unsigned char s2440c3f57:1;
  unsigned char s2440c3f58:1;
  unsigned char s2440c3f59:1;
  unsigned char s2440c3f60:1;
  unsigned char s2440c3f61:1;
  unsigned char s2440c3f62:1;
  unsigned char s2440c3f63:1;
  unsigned char s2440c3f64:1;
  unsigned char s2440c3f65:1;
  unsigned char s2440c3f66:1;
  unsigned char s2440c3f67:1;
  unsigned char s2440c3f68:1;
  unsigned char s2440c3f69:1;
  unsigned char s2440c3f70:1;
  unsigned char s2440c3f71:1;
  unsigned char s2440c3f72:1;
  unsigned char s2440c3f73:1;
  unsigned char s2440c3f74:1;
  unsigned char s2440c3f75:1;
  int s2440c3f76[7];
  void *s2440c3f77[6];
  int s2440c3f78:8;
  int s2440c3f79:8;
  int s2440c3f80:8;
  int s2440c3f81:8;
  int s2440c3f82:8;
  int s2440c3f83:8;
  ::S2440C25 s2440c3f84;
  void *s2440c3f85[4];
  int s2440c3f86:8;
  int s2440c3f87:8;
  int s2440c3f88:8;
  int s2440c3f89:8;
  int s2440c3f90:8;
  int s2440c3f91:16;
  int s2440c3f92:16;
  int s2440c3f93:16;
  int s2440c3f94:4;
  int s2440c3f95:4;
  int s2440c3f96:4;
  int s2440c3f97:4;
  int s2440c3f98:4;
  int s2440c3f99:4;
  int s2440c3f100:4;
  int s2440c3f101:4;
  int s2440c3f102:4;
  int s2440c3f103:4;
  int s2440c3f104:4;
  int s2440c3f105:4;
  int s2440c3f106:8;
  int s2440c3f107:8;
  int s2440c3f108:8;
  void *s2440c3f109[7];
  ::S2440C29_nt s2440c3f110;
  void *s2440c3f111[2];
  int s2440c3f112:16;
  int s2440c3f113:16;
  ::S2440C25 s2440c3f114;
  ::S2440C29_nt s2440c3f115;
  ::S2440C37 s2440c3f116;
  void *s2440c3f117[2];
  int s2440c3f118:24;
  int s2440c3f119:8;
  void *s2440c3f120;
  virtual  ~S2440C3_nt(); // _ZN10S2440C3_ntD1Ev
  virtual void  v32(); // _ZN10S2440C3_nt3v32Ev
  virtual void  v33(); // _ZN10S2440C3_nt3v33Ev
  virtual void  v34(); // _ZN10S2440C3_nt3v34Ev
  virtual void  v35(); // _ZN10S2440C3_nt3v35Ev
  virtual void  v36(); // _ZN10S2440C3_nt3v36Ev
  virtual void  v37(); // _ZN10S2440C3_nt3v37Ev
  virtual void  v38(); // _ZN10S2440C3_nt3v38Ev
  virtual void  v39(); // _ZN10S2440C3_nt3v39Ev
  virtual void  v40(); // _ZN10S2440C3_nt3v40Ev
  virtual void  v41(); // _ZN10S2440C3_nt3v41Ev
  virtual void  v42(); // _ZN10S2440C3_nt3v42Ev
  virtual void  v43(); // _ZN10S2440C3_nt3v43Ev
  virtual void  v44(); // _ZN10S2440C3_nt3v44Ev
  virtual void  v45(); // _ZN10S2440C3_nt3v45Ev
  virtual void  v46(); // _ZN10S2440C3_nt3v46Ev
  virtual void  v47(); // _ZN10S2440C3_nt3v47Ev
  virtual void  v48(); // _ZN10S2440C3_nt3v48Ev
  virtual void  v49(); // _ZN10S2440C3_nt3v49Ev
  virtual void  v50(); // _ZN10S2440C3_nt3v50Ev
  virtual void  v51(); // _ZN10S2440C3_nt3v51Ev
  virtual void  v52(); // _ZN10S2440C3_nt3v52Ev
  virtual void  v53(); // _ZN10S2440C3_nt3v53Ev
  virtual void  v54(); // _ZN10S2440C3_nt3v54Ev
  virtual void  v55(); // _ZN10S2440C3_nt3v55Ev
  virtual void  v56(); // _ZN10S2440C3_nt3v56Ev
  virtual void  v57(); // _ZN10S2440C3_nt3v57Ev
  virtual void  v58(); // _ZN10S2440C3_nt3v58Ev
  virtual void  v59(); // _ZN10S2440C3_nt3v59Ev
  virtual void  v60(); // _ZN10S2440C3_nt3v60Ev
  virtual void  v61(); // _ZN10S2440C3_nt3v61Ev
  virtual void  v62(); // _ZN10S2440C3_nt3v62Ev
  virtual void  v63(); // _ZN10S2440C3_nt3v63Ev
  virtual void  v64(); // _ZN10S2440C3_nt3v64Ev
  virtual void  v65(); // _ZN10S2440C3_nt3v65Ev
  virtual void  v66(); // _ZN10S2440C3_nt3v66Ev
  virtual void  v67(); // _ZN10S2440C3_nt3v67Ev
  virtual void  v68(); // _ZN10S2440C3_nt3v68Ev
  virtual void  v69(); // _ZN10S2440C3_nt3v69Ev
  virtual void  v70(); // _ZN10S2440C3_nt3v70Ev
  virtual void  v71(); // _ZN10S2440C3_nt3v71Ev
  virtual void  v72(); // _ZN10S2440C3_nt3v72Ev
  virtual void  v73(); // _ZN10S2440C3_nt3v73Ev
  virtual void  v74(); // _ZN10S2440C3_nt3v74Ev
  virtual void  v75(); // _ZN10S2440C3_nt3v75Ev
  virtual void  v76(); // _ZN10S2440C3_nt3v76Ev
  virtual void  v77(); // _ZN10S2440C3_nt3v77Ev
  virtual void  v78(); // _ZN10S2440C3_nt3v78Ev
  virtual void  v79(); // _ZN10S2440C3_nt3v79Ev
  virtual void  v80(); // _ZN10S2440C3_nt3v80Ev
  virtual void  v81(); // _ZN10S2440C3_nt3v81Ev
  virtual void  v82(); // _ZN10S2440C3_nt3v82Ev
  virtual void  v83(); // _ZN10S2440C3_nt3v83Ev
  virtual void  v84(); // _ZN10S2440C3_nt3v84Ev
  virtual void  v85(); // _ZN10S2440C3_nt3v85Ev
  virtual void  v86(); // _ZN10S2440C3_nt3v86Ev
  virtual void  v87(); // _ZN10S2440C3_nt3v87Ev
  virtual void  v88(); // _ZN10S2440C3_nt3v88Ev
  virtual void  v89(); // _ZN10S2440C3_nt3v89Ev
  virtual void  v90(); // _ZN10S2440C3_nt3v90Ev
  virtual void  v91(); // _ZN10S2440C3_nt3v91Ev
  virtual void  v92(); // _ZN10S2440C3_nt3v92Ev
  virtual void  v93(); // _ZN10S2440C3_nt3v93Ev
  virtual void  v94(); // _ZN10S2440C3_nt3v94Ev
  virtual void  v95(); // _ZN10S2440C3_nt3v95Ev
  virtual void  v96(); // _ZN10S2440C3_nt3v96Ev
  virtual void  v97(); // _ZN10S2440C3_nt3v97Ev
  virtual void  v98(); // _ZN10S2440C3_nt3v98Ev
  virtual void  v99(); // _ZN10S2440C3_nt3v99Ev
  virtual void  v100(); // _ZN10S2440C3_nt4v100Ev
  virtual void  v101(); // _ZN10S2440C3_nt4v101Ev
  virtual void  v102(); // _ZN10S2440C3_nt4v102Ev
  virtual void  v103(); // _ZN10S2440C3_nt4v103Ev
  virtual void  v104(); // _ZN10S2440C3_nt4v104Ev
  virtual void  v105(); // _ZN10S2440C3_nt4v105Ev
  virtual void  v106(); // _ZN10S2440C3_nt4v106Ev
  virtual void  v107(); // _ZN10S2440C3_nt4v107Ev
  virtual void  v108(); // _ZN10S2440C3_nt4v108Ev
  virtual void  v109(); // _ZN10S2440C3_nt4v109Ev
  S2440C3_nt(); // tgen
};
//SIG(-1 S2440C3_nt) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fp Fi FC3{ BC4{ m Fp Fi FC5{ m} FC5}} FC3 Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 FC6{ m FC7{ m FL[2]}} FC6 FC6 FC6 FC8{ m FC6} FC9{ m FC6 FC6 FC6 FC6} FC9 FC6 FC6 FC6 Fp FC8 FC10{ m FC11{ m Fp Fi FC12{ m}} Fi} Fi Fp[7] FC13{ m Fp Fi FC12 FC14{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC15{ BC16{ m Fp Fi FC14 FC17{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC18{ m Fp Fi[2] FC17} Fp[2] Fi:16 Fi:16 FC15 FC18 FC19{ m Fp Fi[2] FC20{ m}} Fp[2] Fi:24 Fi:8 Fp}


 S2440C3_nt ::~S2440C3_nt(){ note_dtor("S2440C3_nt", this);}
void  S2440C3_nt ::v32(){vfunc_called(this, "_ZN10S2440C3_nt3v32Ev");}
void  S2440C3_nt ::v33(){vfunc_called(this, "_ZN10S2440C3_nt3v33Ev");}
void  S2440C3_nt ::v34(){vfunc_called(this, "_ZN10S2440C3_nt3v34Ev");}
void  S2440C3_nt ::v35(){vfunc_called(this, "_ZN10S2440C3_nt3v35Ev");}
void  S2440C3_nt ::v36(){vfunc_called(this, "_ZN10S2440C3_nt3v36Ev");}
void  S2440C3_nt ::v37(){vfunc_called(this, "_ZN10S2440C3_nt3v37Ev");}
void  S2440C3_nt ::v38(){vfunc_called(this, "_ZN10S2440C3_nt3v38Ev");}
void  S2440C3_nt ::v39(){vfunc_called(this, "_ZN10S2440C3_nt3v39Ev");}
void  S2440C3_nt ::v40(){vfunc_called(this, "_ZN10S2440C3_nt3v40Ev");}
void  S2440C3_nt ::v41(){vfunc_called(this, "_ZN10S2440C3_nt3v41Ev");}
void  S2440C3_nt ::v42(){vfunc_called(this, "_ZN10S2440C3_nt3v42Ev");}
void  S2440C3_nt ::v43(){vfunc_called(this, "_ZN10S2440C3_nt3v43Ev");}
void  S2440C3_nt ::v44(){vfunc_called(this, "_ZN10S2440C3_nt3v44Ev");}
void  S2440C3_nt ::v45(){vfunc_called(this, "_ZN10S2440C3_nt3v45Ev");}
void  S2440C3_nt ::v46(){vfunc_called(this, "_ZN10S2440C3_nt3v46Ev");}
void  S2440C3_nt ::v47(){vfunc_called(this, "_ZN10S2440C3_nt3v47Ev");}
void  S2440C3_nt ::v48(){vfunc_called(this, "_ZN10S2440C3_nt3v48Ev");}
void  S2440C3_nt ::v49(){vfunc_called(this, "_ZN10S2440C3_nt3v49Ev");}
void  S2440C3_nt ::v50(){vfunc_called(this, "_ZN10S2440C3_nt3v50Ev");}
void  S2440C3_nt ::v51(){vfunc_called(this, "_ZN10S2440C3_nt3v51Ev");}
void  S2440C3_nt ::v52(){vfunc_called(this, "_ZN10S2440C3_nt3v52Ev");}
void  S2440C3_nt ::v53(){vfunc_called(this, "_ZN10S2440C3_nt3v53Ev");}
void  S2440C3_nt ::v54(){vfunc_called(this, "_ZN10S2440C3_nt3v54Ev");}
void  S2440C3_nt ::v55(){vfunc_called(this, "_ZN10S2440C3_nt3v55Ev");}
void  S2440C3_nt ::v56(){vfunc_called(this, "_ZN10S2440C3_nt3v56Ev");}
void  S2440C3_nt ::v57(){vfunc_called(this, "_ZN10S2440C3_nt3v57Ev");}
void  S2440C3_nt ::v58(){vfunc_called(this, "_ZN10S2440C3_nt3v58Ev");}
void  S2440C3_nt ::v59(){vfunc_called(this, "_ZN10S2440C3_nt3v59Ev");}
void  S2440C3_nt ::v60(){vfunc_called(this, "_ZN10S2440C3_nt3v60Ev");}
void  S2440C3_nt ::v61(){vfunc_called(this, "_ZN10S2440C3_nt3v61Ev");}
void  S2440C3_nt ::v62(){vfunc_called(this, "_ZN10S2440C3_nt3v62Ev");}
void  S2440C3_nt ::v63(){vfunc_called(this, "_ZN10S2440C3_nt3v63Ev");}
void  S2440C3_nt ::v64(){vfunc_called(this, "_ZN10S2440C3_nt3v64Ev");}
void  S2440C3_nt ::v65(){vfunc_called(this, "_ZN10S2440C3_nt3v65Ev");}
void  S2440C3_nt ::v66(){vfunc_called(this, "_ZN10S2440C3_nt3v66Ev");}
void  S2440C3_nt ::v67(){vfunc_called(this, "_ZN10S2440C3_nt3v67Ev");}
void  S2440C3_nt ::v68(){vfunc_called(this, "_ZN10S2440C3_nt3v68Ev");}
void  S2440C3_nt ::v69(){vfunc_called(this, "_ZN10S2440C3_nt3v69Ev");}
void  S2440C3_nt ::v70(){vfunc_called(this, "_ZN10S2440C3_nt3v70Ev");}
void  S2440C3_nt ::v71(){vfunc_called(this, "_ZN10S2440C3_nt3v71Ev");}
void  S2440C3_nt ::v72(){vfunc_called(this, "_ZN10S2440C3_nt3v72Ev");}
void  S2440C3_nt ::v73(){vfunc_called(this, "_ZN10S2440C3_nt3v73Ev");}
void  S2440C3_nt ::v74(){vfunc_called(this, "_ZN10S2440C3_nt3v74Ev");}
void  S2440C3_nt ::v75(){vfunc_called(this, "_ZN10S2440C3_nt3v75Ev");}
void  S2440C3_nt ::v76(){vfunc_called(this, "_ZN10S2440C3_nt3v76Ev");}
void  S2440C3_nt ::v77(){vfunc_called(this, "_ZN10S2440C3_nt3v77Ev");}
void  S2440C3_nt ::v78(){vfunc_called(this, "_ZN10S2440C3_nt3v78Ev");}
void  S2440C3_nt ::v79(){vfunc_called(this, "_ZN10S2440C3_nt3v79Ev");}
void  S2440C3_nt ::v80(){vfunc_called(this, "_ZN10S2440C3_nt3v80Ev");}
void  S2440C3_nt ::v81(){vfunc_called(this, "_ZN10S2440C3_nt3v81Ev");}
void  S2440C3_nt ::v82(){vfunc_called(this, "_ZN10S2440C3_nt3v82Ev");}
void  S2440C3_nt ::v83(){vfunc_called(this, "_ZN10S2440C3_nt3v83Ev");}
void  S2440C3_nt ::v84(){vfunc_called(this, "_ZN10S2440C3_nt3v84Ev");}
void  S2440C3_nt ::v85(){vfunc_called(this, "_ZN10S2440C3_nt3v85Ev");}
void  S2440C3_nt ::v86(){vfunc_called(this, "_ZN10S2440C3_nt3v86Ev");}
void  S2440C3_nt ::v87(){vfunc_called(this, "_ZN10S2440C3_nt3v87Ev");}
void  S2440C3_nt ::v88(){vfunc_called(this, "_ZN10S2440C3_nt3v88Ev");}
void  S2440C3_nt ::v89(){vfunc_called(this, "_ZN10S2440C3_nt3v89Ev");}
void  S2440C3_nt ::v90(){vfunc_called(this, "_ZN10S2440C3_nt3v90Ev");}
void  S2440C3_nt ::v91(){vfunc_called(this, "_ZN10S2440C3_nt3v91Ev");}
void  S2440C3_nt ::v92(){vfunc_called(this, "_ZN10S2440C3_nt3v92Ev");}
void  S2440C3_nt ::v93(){vfunc_called(this, "_ZN10S2440C3_nt3v93Ev");}
void  S2440C3_nt ::v94(){vfunc_called(this, "_ZN10S2440C3_nt3v94Ev");}
void  S2440C3_nt ::v95(){vfunc_called(this, "_ZN10S2440C3_nt3v95Ev");}
void  S2440C3_nt ::v96(){vfunc_called(this, "_ZN10S2440C3_nt3v96Ev");}
void  S2440C3_nt ::v97(){vfunc_called(this, "_ZN10S2440C3_nt3v97Ev");}
void  S2440C3_nt ::v98(){vfunc_called(this, "_ZN10S2440C3_nt3v98Ev");}
void  S2440C3_nt ::v99(){vfunc_called(this, "_ZN10S2440C3_nt3v99Ev");}
void  S2440C3_nt ::v100(){vfunc_called(this, "_ZN10S2440C3_nt4v100Ev");}
void  S2440C3_nt ::v101(){vfunc_called(this, "_ZN10S2440C3_nt4v101Ev");}
void  S2440C3_nt ::v102(){vfunc_called(this, "_ZN10S2440C3_nt4v102Ev");}
void  S2440C3_nt ::v103(){vfunc_called(this, "_ZN10S2440C3_nt4v103Ev");}
void  S2440C3_nt ::v104(){vfunc_called(this, "_ZN10S2440C3_nt4v104Ev");}
void  S2440C3_nt ::v105(){vfunc_called(this, "_ZN10S2440C3_nt4v105Ev");}
void  S2440C3_nt ::v106(){vfunc_called(this, "_ZN10S2440C3_nt4v106Ev");}
void  S2440C3_nt ::v107(){vfunc_called(this, "_ZN10S2440C3_nt4v107Ev");}
void  S2440C3_nt ::v108(){vfunc_called(this, "_ZN10S2440C3_nt4v108Ev");}
void  S2440C3_nt ::v109(){vfunc_called(this, "_ZN10S2440C3_nt4v109Ev");}
S2440C3_nt ::S2440C3_nt(){ note_ctor("S2440C3_nt", this);} // tgen

//skip512 S2440C3_nt

#else // __cplusplus

extern void _ZN10S2440C3_ntC1Ev();
extern void _ZN10S2440C3_ntD1Ev();
Name_Map name_map_S2440C3_nt[] = {
  NSPAIR(_ZN10S2440C3_ntC1Ev),
  NSPAIR(_ZN10S2440C3_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2440C4_nt;
extern VTBL_ENTRY _ZTI10S2440C4_nt[];
extern  VTBL_ENTRY _ZTV10S2440C4_nt[];
static Base_Class bases_S2440C3_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2440C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2440C3_nt[];
extern void _ZN10S2440C3_ntD1Ev();
extern void _ZN10S2440C3_ntD0Ev();
extern void _ZN10S2440C4_nt2v9Ev();
extern void _ZN10S2440C4_nt3v10Ev();
extern void _ZN10S2440C4_nt3v11Ev();
extern void _ZN10S2440C4_nt3v12Ev();
extern void _ZN10S2440C4_nt3v13Ev();
extern void _ZN10S2440C4_nt3v14Ev();
extern void _ZN10S2440C4_nt3v15Ev();
extern void _ZN10S2440C4_nt3v16Ev();
extern void _ZN10S2440C4_nt3v17Ev();
extern void _ZN10S2440C4_nt3v18Ev();
extern void _ZN10S2440C4_nt3v19Ev();
extern void _ZN10S2440C4_nt3v20Ev();
extern void _ZN10S2440C4_nt3v21Ev();
extern void _ZN10S2440C4_nt3v22Ev();
extern void _ZN10S2440C4_nt3v23Ev();
extern void _ZN10S2440C4_nt3v24Ev();
extern void _ZN10S2440C4_nt3v25Ev();
extern void _ZN10S2440C4_nt3v26Ev();
extern void _ZN10S2440C4_nt3v27Ev();
extern void _ZN10S2440C4_nt3v28Ev();
extern void _ZN10S2440C4_nt3v29Ev();
extern void _ZN10S2440C4_nt3v30Ev();
extern void _ZN10S2440C4_nt3v31Ev();
extern void _ZN10S2440C3_nt3v32Ev();
extern void _ZN10S2440C3_nt3v33Ev();
extern void _ZN10S2440C3_nt3v34Ev();
extern void _ZN10S2440C3_nt3v35Ev();
extern void _ZN10S2440C3_nt3v36Ev();
extern void _ZN10S2440C3_nt3v37Ev();
extern void _ZN10S2440C3_nt3v38Ev();
extern void _ZN10S2440C3_nt3v39Ev();
extern void _ZN10S2440C3_nt3v40Ev();
extern void _ZN10S2440C3_nt3v41Ev();
extern void _ZN10S2440C3_nt3v42Ev();
extern void _ZN10S2440C3_nt3v43Ev();
extern void _ZN10S2440C3_nt3v44Ev();
extern void _ZN10S2440C3_nt3v45Ev();
extern void _ZN10S2440C3_nt3v46Ev();
extern void _ZN10S2440C3_nt3v47Ev();
extern void _ZN10S2440C3_nt3v48Ev();
extern void _ZN10S2440C3_nt3v49Ev();
extern void _ZN10S2440C3_nt3v50Ev();
extern void _ZN10S2440C3_nt3v51Ev();
extern void _ZN10S2440C3_nt3v52Ev();
extern void _ZN10S2440C3_nt3v53Ev();
extern void _ZN10S2440C3_nt3v54Ev();
extern void _ZN10S2440C3_nt3v55Ev();
extern void _ZN10S2440C3_nt3v56Ev();
extern void _ZN10S2440C3_nt3v57Ev();
extern void _ZN10S2440C3_nt3v58Ev();
extern void _ZN10S2440C3_nt3v59Ev();
extern void _ZN10S2440C3_nt3v60Ev();
extern void _ZN10S2440C3_nt3v61Ev();
extern void _ZN10S2440C3_nt3v62Ev();
extern void _ZN10S2440C3_nt3v63Ev();
extern void _ZN10S2440C3_nt3v64Ev();
extern void _ZN10S2440C3_nt3v65Ev();
extern void _ZN10S2440C3_nt3v66Ev();
extern void _ZN10S2440C3_nt3v67Ev();
extern void _ZN10S2440C3_nt3v68Ev();
extern void _ZN10S2440C3_nt3v69Ev();
extern void _ZN10S2440C3_nt3v70Ev();
extern void _ZN10S2440C3_nt3v71Ev();
extern void _ZN10S2440C3_nt3v72Ev();
extern void _ZN10S2440C3_nt3v73Ev();
extern void _ZN10S2440C3_nt3v74Ev();
extern void _ZN10S2440C3_nt3v75Ev();
extern void _ZN10S2440C3_nt3v76Ev();
extern void _ZN10S2440C3_nt3v77Ev();
extern void _ZN10S2440C3_nt3v78Ev();
extern void _ZN10S2440C3_nt3v79Ev();
extern void _ZN10S2440C3_nt3v80Ev();
extern void _ZN10S2440C3_nt3v81Ev();
extern void _ZN10S2440C3_nt3v82Ev();
extern void _ZN10S2440C3_nt3v83Ev();
extern void _ZN10S2440C3_nt3v84Ev();
extern void _ZN10S2440C3_nt3v85Ev();
extern void _ZN10S2440C3_nt3v86Ev();
extern void _ZN10S2440C3_nt3v87Ev();
extern void _ZN10S2440C3_nt3v88Ev();
extern void _ZN10S2440C3_nt3v89Ev();
extern void _ZN10S2440C3_nt3v90Ev();
extern void _ZN10S2440C3_nt3v91Ev();
extern void _ZN10S2440C3_nt3v92Ev();
extern void _ZN10S2440C3_nt3v93Ev();
extern void _ZN10S2440C3_nt3v94Ev();
extern void _ZN10S2440C3_nt3v95Ev();
extern void _ZN10S2440C3_nt3v96Ev();
extern void _ZN10S2440C3_nt3v97Ev();
extern void _ZN10S2440C3_nt3v98Ev();
extern void _ZN10S2440C3_nt3v99Ev();
extern void _ZN10S2440C3_nt4v100Ev();
extern void _ZN10S2440C3_nt4v101Ev();
extern void _ZN10S2440C3_nt4v102Ev();
extern void _ZN10S2440C3_nt4v103Ev();
extern void _ZN10S2440C3_nt4v104Ev();
extern void _ZN10S2440C3_nt4v105Ev();
extern void _ZN10S2440C3_nt4v106Ev();
extern void _ZN10S2440C3_nt4v107Ev();
extern void _ZN10S2440C3_nt4v108Ev();
extern void _ZN10S2440C3_nt4v109Ev();
static  VTBL_ENTRY vtc_S2440C3_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2440C3_nt[0]),
  (VTBL_ENTRY)&_ZN10S2440C3_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v109Ev,
};
extern VTBL_ENTRY _ZTI10S2440C3_nt[];
VTBL_ENTRY *P__ZTI10S2440C3_nt = _ZTI10S2440C3_nt; 
extern  VTBL_ENTRY _ZTV10S2440C3_nt[];
Class_Descriptor cd_S2440C3_nt = {  "S2440C3_nt", // class name
  bases_S2440C3_nt, 1,
  &(vtc_S2440C3_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI10S2440C3_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2440C3_nt),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2440C2_nt  : S2440C3_nt {
  int s2440c2f0[4];
  void *s2440c2f1;
  unsigned char s2440c2f2:1;
  unsigned char s2440c2f3:1;
  unsigned char s2440c2f4:1;
  unsigned char s2440c2f5:1;
  unsigned char s2440c2f6:1;
  unsigned char s2440c2f7:1;
  int s2440c2f8:8;
  int s2440c2f9:16;
  int s2440c2f10:16;
  int s2440c2f11:16;
  int s2440c2f12:16;
  int s2440c2f13:16;
  int s2440c2f14;
  ::S2440C22 s2440c2f15;
  unsigned char s2440c2f16:1;
  unsigned char s2440c2f17:1;
  virtual  ~S2440C2_nt(); // _ZN10S2440C2_ntD1Ev
  virtual void  v110(); // _ZN10S2440C2_nt4v110Ev
  virtual void  v111(); // _ZN10S2440C2_nt4v111Ev
  virtual void  v112(); // _ZN10S2440C2_nt4v112Ev
  virtual void  v113(); // _ZN10S2440C2_nt4v113Ev
  virtual void  v114(); // _ZN10S2440C2_nt4v114Ev
  virtual void  v115(); // _ZN10S2440C2_nt4v115Ev
  virtual void  v116(); // _ZN10S2440C2_nt4v116Ev
  virtual void  v117(); // _ZN10S2440C2_nt4v117Ev
  virtual void  v118(); // _ZN10S2440C2_nt4v118Ev
  virtual void  v119(); // _ZN10S2440C2_nt4v119Ev
  virtual void  v120(); // _ZN10S2440C2_nt4v120Ev
  virtual void  v121(); // _ZN10S2440C2_nt4v121Ev
  virtual void  v122(); // _ZN10S2440C2_nt4v122Ev
  virtual void  v123(); // _ZN10S2440C2_nt4v123Ev
  virtual void  v124(); // _ZN10S2440C2_nt4v124Ev
  virtual void  v125(); // _ZN10S2440C2_nt4v125Ev
  virtual void  v126(); // _ZN10S2440C2_nt4v126Ev
  virtual void  v127(); // _ZN10S2440C2_nt4v127Ev
  virtual void  v128(); // _ZN10S2440C2_nt4v128Ev
  virtual void  v129(); // _ZN10S2440C2_nt4v129Ev
  virtual void  v130(); // _ZN10S2440C2_nt4v130Ev
  virtual void  v131(); // _ZN10S2440C2_nt4v131Ev
  virtual void  v132(); // _ZN10S2440C2_nt4v132Ev
  virtual void  v133(); // _ZN10S2440C2_nt4v133Ev
  virtual void  v134(); // _ZN10S2440C2_nt4v134Ev
  virtual void  v135(); // _ZN10S2440C2_nt4v135Ev
  virtual void  v136(); // _ZN10S2440C2_nt4v136Ev
  virtual void  v137(); // _ZN10S2440C2_nt4v137Ev
  virtual void  v138(); // _ZN10S2440C2_nt4v138Ev
  virtual void  v139(); // _ZN10S2440C2_nt4v139Ev
  virtual void  v140(); // _ZN10S2440C2_nt4v140Ev
  virtual void  v141(); // _ZN10S2440C2_nt4v141Ev
  virtual void  v142(); // _ZN10S2440C2_nt4v142Ev
  virtual void  v143(); // _ZN10S2440C2_nt4v143Ev
  virtual void  v144(); // _ZN10S2440C2_nt4v144Ev
  virtual void  v145(); // _ZN10S2440C2_nt4v145Ev
  virtual void  v146(); // _ZN10S2440C2_nt4v146Ev
  virtual void  v147(); // _ZN10S2440C2_nt4v147Ev
  virtual void  v148(); // _ZN10S2440C2_nt4v148Ev
  S2440C2_nt(); // tgen
};
//SIG(-1 S2440C2_nt) C1{ BC2{ BC3{ vd v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 Fp Fi FC4{ BC5{ m Fp Fi FC6{ m} FC6}} FC4 Fi} vd v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 FC7{ m FC8{ m FL[2]}} FC7 FC7 FC7 FC9{ m FC7} FC10{ m FC7 FC7 FC7 FC7} FC10 FC7 FC7 FC7 Fp FC9 FC11{ m FC12{ m Fp Fi FC13{ m}} Fi} Fi Fp[7] FC14{ m Fp Fi FC13 FC15{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC16{ BC17{ m Fp Fi FC15 FC18{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC19{ m Fp Fi[2] FC18} Fp[2] Fi:16 Fi:16 FC16 FC19 FC20{ m Fp Fi[2] FC21{ m}} Fp[2] Fi:24 Fi:8 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 Fi[4] Fp Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi:8 Fi:16 Fi:16 Fi:16 Fi:16 Fi:16 Fi FC14 Fc:1 Fc:1}


 S2440C2_nt ::~S2440C2_nt(){ note_dtor("S2440C2_nt", this);}
void  S2440C2_nt ::v110(){vfunc_called(this, "_ZN10S2440C2_nt4v110Ev");}
void  S2440C2_nt ::v111(){vfunc_called(this, "_ZN10S2440C2_nt4v111Ev");}
void  S2440C2_nt ::v112(){vfunc_called(this, "_ZN10S2440C2_nt4v112Ev");}
void  S2440C2_nt ::v113(){vfunc_called(this, "_ZN10S2440C2_nt4v113Ev");}
void  S2440C2_nt ::v114(){vfunc_called(this, "_ZN10S2440C2_nt4v114Ev");}
void  S2440C2_nt ::v115(){vfunc_called(this, "_ZN10S2440C2_nt4v115Ev");}
void  S2440C2_nt ::v116(){vfunc_called(this, "_ZN10S2440C2_nt4v116Ev");}
void  S2440C2_nt ::v117(){vfunc_called(this, "_ZN10S2440C2_nt4v117Ev");}
void  S2440C2_nt ::v118(){vfunc_called(this, "_ZN10S2440C2_nt4v118Ev");}
void  S2440C2_nt ::v119(){vfunc_called(this, "_ZN10S2440C2_nt4v119Ev");}
void  S2440C2_nt ::v120(){vfunc_called(this, "_ZN10S2440C2_nt4v120Ev");}
void  S2440C2_nt ::v121(){vfunc_called(this, "_ZN10S2440C2_nt4v121Ev");}
void  S2440C2_nt ::v122(){vfunc_called(this, "_ZN10S2440C2_nt4v122Ev");}
void  S2440C2_nt ::v123(){vfunc_called(this, "_ZN10S2440C2_nt4v123Ev");}
void  S2440C2_nt ::v124(){vfunc_called(this, "_ZN10S2440C2_nt4v124Ev");}
void  S2440C2_nt ::v125(){vfunc_called(this, "_ZN10S2440C2_nt4v125Ev");}
void  S2440C2_nt ::v126(){vfunc_called(this, "_ZN10S2440C2_nt4v126Ev");}
void  S2440C2_nt ::v127(){vfunc_called(this, "_ZN10S2440C2_nt4v127Ev");}
void  S2440C2_nt ::v128(){vfunc_called(this, "_ZN10S2440C2_nt4v128Ev");}
void  S2440C2_nt ::v129(){vfunc_called(this, "_ZN10S2440C2_nt4v129Ev");}
void  S2440C2_nt ::v130(){vfunc_called(this, "_ZN10S2440C2_nt4v130Ev");}
void  S2440C2_nt ::v131(){vfunc_called(this, "_ZN10S2440C2_nt4v131Ev");}
void  S2440C2_nt ::v132(){vfunc_called(this, "_ZN10S2440C2_nt4v132Ev");}
void  S2440C2_nt ::v133(){vfunc_called(this, "_ZN10S2440C2_nt4v133Ev");}
void  S2440C2_nt ::v134(){vfunc_called(this, "_ZN10S2440C2_nt4v134Ev");}
void  S2440C2_nt ::v135(){vfunc_called(this, "_ZN10S2440C2_nt4v135Ev");}
void  S2440C2_nt ::v136(){vfunc_called(this, "_ZN10S2440C2_nt4v136Ev");}
void  S2440C2_nt ::v137(){vfunc_called(this, "_ZN10S2440C2_nt4v137Ev");}
void  S2440C2_nt ::v138(){vfunc_called(this, "_ZN10S2440C2_nt4v138Ev");}
void  S2440C2_nt ::v139(){vfunc_called(this, "_ZN10S2440C2_nt4v139Ev");}
void  S2440C2_nt ::v140(){vfunc_called(this, "_ZN10S2440C2_nt4v140Ev");}
void  S2440C2_nt ::v141(){vfunc_called(this, "_ZN10S2440C2_nt4v141Ev");}
void  S2440C2_nt ::v142(){vfunc_called(this, "_ZN10S2440C2_nt4v142Ev");}
void  S2440C2_nt ::v143(){vfunc_called(this, "_ZN10S2440C2_nt4v143Ev");}
void  S2440C2_nt ::v144(){vfunc_called(this, "_ZN10S2440C2_nt4v144Ev");}
void  S2440C2_nt ::v145(){vfunc_called(this, "_ZN10S2440C2_nt4v145Ev");}
void  S2440C2_nt ::v146(){vfunc_called(this, "_ZN10S2440C2_nt4v146Ev");}
void  S2440C2_nt ::v147(){vfunc_called(this, "_ZN10S2440C2_nt4v147Ev");}
void  S2440C2_nt ::v148(){vfunc_called(this, "_ZN10S2440C2_nt4v148Ev");}
S2440C2_nt ::S2440C2_nt(){ note_ctor("S2440C2_nt", this);} // tgen

//skip512 S2440C2_nt

#else // __cplusplus

extern void _ZN10S2440C2_ntC1Ev();
extern void _ZN10S2440C2_ntD1Ev();
Name_Map name_map_S2440C2_nt[] = {
  NSPAIR(_ZN10S2440C2_ntC1Ev),
  NSPAIR(_ZN10S2440C2_ntD1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2440C4_nt;
extern VTBL_ENTRY _ZTI10S2440C4_nt[];
extern  VTBL_ENTRY _ZTV10S2440C4_nt[];
extern Class_Descriptor cd_S2440C3_nt;
extern VTBL_ENTRY _ZTI10S2440C3_nt[];
extern  VTBL_ENTRY _ZTV10S2440C3_nt[];
static Base_Class bases_S2440C2_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2440C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2440C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI10S2440C2_nt[];
extern void _ZN10S2440C2_ntD1Ev();
extern void _ZN10S2440C2_ntD0Ev();
extern void _ZN10S2440C4_nt2v9Ev();
extern void _ZN10S2440C4_nt3v10Ev();
extern void _ZN10S2440C4_nt3v11Ev();
extern void _ZN10S2440C4_nt3v12Ev();
extern void _ZN10S2440C4_nt3v13Ev();
extern void _ZN10S2440C4_nt3v14Ev();
extern void _ZN10S2440C4_nt3v15Ev();
extern void _ZN10S2440C4_nt3v16Ev();
extern void _ZN10S2440C4_nt3v17Ev();
extern void _ZN10S2440C4_nt3v18Ev();
extern void _ZN10S2440C4_nt3v19Ev();
extern void _ZN10S2440C4_nt3v20Ev();
extern void _ZN10S2440C4_nt3v21Ev();
extern void _ZN10S2440C4_nt3v22Ev();
extern void _ZN10S2440C4_nt3v23Ev();
extern void _ZN10S2440C4_nt3v24Ev();
extern void _ZN10S2440C4_nt3v25Ev();
extern void _ZN10S2440C4_nt3v26Ev();
extern void _ZN10S2440C4_nt3v27Ev();
extern void _ZN10S2440C4_nt3v28Ev();
extern void _ZN10S2440C4_nt3v29Ev();
extern void _ZN10S2440C4_nt3v30Ev();
extern void _ZN10S2440C4_nt3v31Ev();
extern void _ZN10S2440C3_nt3v32Ev();
extern void _ZN10S2440C3_nt3v33Ev();
extern void _ZN10S2440C3_nt3v34Ev();
extern void _ZN10S2440C3_nt3v35Ev();
extern void _ZN10S2440C3_nt3v36Ev();
extern void _ZN10S2440C3_nt3v37Ev();
extern void _ZN10S2440C3_nt3v38Ev();
extern void _ZN10S2440C3_nt3v39Ev();
extern void _ZN10S2440C3_nt3v40Ev();
extern void _ZN10S2440C3_nt3v41Ev();
extern void _ZN10S2440C3_nt3v42Ev();
extern void _ZN10S2440C3_nt3v43Ev();
extern void _ZN10S2440C3_nt3v44Ev();
extern void _ZN10S2440C3_nt3v45Ev();
extern void _ZN10S2440C3_nt3v46Ev();
extern void _ZN10S2440C3_nt3v47Ev();
extern void _ZN10S2440C3_nt3v48Ev();
extern void _ZN10S2440C3_nt3v49Ev();
extern void _ZN10S2440C3_nt3v50Ev();
extern void _ZN10S2440C3_nt3v51Ev();
extern void _ZN10S2440C3_nt3v52Ev();
extern void _ZN10S2440C3_nt3v53Ev();
extern void _ZN10S2440C3_nt3v54Ev();
extern void _ZN10S2440C3_nt3v55Ev();
extern void _ZN10S2440C3_nt3v56Ev();
extern void _ZN10S2440C3_nt3v57Ev();
extern void _ZN10S2440C3_nt3v58Ev();
extern void _ZN10S2440C3_nt3v59Ev();
extern void _ZN10S2440C3_nt3v60Ev();
extern void _ZN10S2440C3_nt3v61Ev();
extern void _ZN10S2440C3_nt3v62Ev();
extern void _ZN10S2440C3_nt3v63Ev();
extern void _ZN10S2440C3_nt3v64Ev();
extern void _ZN10S2440C3_nt3v65Ev();
extern void _ZN10S2440C3_nt3v66Ev();
extern void _ZN10S2440C3_nt3v67Ev();
extern void _ZN10S2440C3_nt3v68Ev();
extern void _ZN10S2440C3_nt3v69Ev();
extern void _ZN10S2440C3_nt3v70Ev();
extern void _ZN10S2440C3_nt3v71Ev();
extern void _ZN10S2440C3_nt3v72Ev();
extern void _ZN10S2440C3_nt3v73Ev();
extern void _ZN10S2440C3_nt3v74Ev();
extern void _ZN10S2440C3_nt3v75Ev();
extern void _ZN10S2440C3_nt3v76Ev();
extern void _ZN10S2440C3_nt3v77Ev();
extern void _ZN10S2440C3_nt3v78Ev();
extern void _ZN10S2440C3_nt3v79Ev();
extern void _ZN10S2440C3_nt3v80Ev();
extern void _ZN10S2440C3_nt3v81Ev();
extern void _ZN10S2440C3_nt3v82Ev();
extern void _ZN10S2440C3_nt3v83Ev();
extern void _ZN10S2440C3_nt3v84Ev();
extern void _ZN10S2440C3_nt3v85Ev();
extern void _ZN10S2440C3_nt3v86Ev();
extern void _ZN10S2440C3_nt3v87Ev();
extern void _ZN10S2440C3_nt3v88Ev();
extern void _ZN10S2440C3_nt3v89Ev();
extern void _ZN10S2440C3_nt3v90Ev();
extern void _ZN10S2440C3_nt3v91Ev();
extern void _ZN10S2440C3_nt3v92Ev();
extern void _ZN10S2440C3_nt3v93Ev();
extern void _ZN10S2440C3_nt3v94Ev();
extern void _ZN10S2440C3_nt3v95Ev();
extern void _ZN10S2440C3_nt3v96Ev();
extern void _ZN10S2440C3_nt3v97Ev();
extern void _ZN10S2440C3_nt3v98Ev();
extern void _ZN10S2440C3_nt3v99Ev();
extern void _ZN10S2440C3_nt4v100Ev();
extern void _ZN10S2440C3_nt4v101Ev();
extern void _ZN10S2440C3_nt4v102Ev();
extern void _ZN10S2440C3_nt4v103Ev();
extern void _ZN10S2440C3_nt4v104Ev();
extern void _ZN10S2440C3_nt4v105Ev();
extern void _ZN10S2440C3_nt4v106Ev();
extern void _ZN10S2440C3_nt4v107Ev();
extern void _ZN10S2440C3_nt4v108Ev();
extern void _ZN10S2440C3_nt4v109Ev();
extern void _ZN10S2440C2_nt4v110Ev();
extern void _ZN10S2440C2_nt4v111Ev();
extern void _ZN10S2440C2_nt4v112Ev();
extern void _ZN10S2440C2_nt4v113Ev();
extern void _ZN10S2440C2_nt4v114Ev();
extern void _ZN10S2440C2_nt4v115Ev();
extern void _ZN10S2440C2_nt4v116Ev();
extern void _ZN10S2440C2_nt4v117Ev();
extern void _ZN10S2440C2_nt4v118Ev();
extern void _ZN10S2440C2_nt4v119Ev();
extern void _ZN10S2440C2_nt4v120Ev();
extern void _ZN10S2440C2_nt4v121Ev();
extern void _ZN10S2440C2_nt4v122Ev();
extern void _ZN10S2440C2_nt4v123Ev();
extern void _ZN10S2440C2_nt4v124Ev();
extern void _ZN10S2440C2_nt4v125Ev();
extern void _ZN10S2440C2_nt4v126Ev();
extern void _ZN10S2440C2_nt4v127Ev();
extern void _ZN10S2440C2_nt4v128Ev();
extern void _ZN10S2440C2_nt4v129Ev();
extern void _ZN10S2440C2_nt4v130Ev();
extern void _ZN10S2440C2_nt4v131Ev();
extern void _ZN10S2440C2_nt4v132Ev();
extern void _ZN10S2440C2_nt4v133Ev();
extern void _ZN10S2440C2_nt4v134Ev();
extern void _ZN10S2440C2_nt4v135Ev();
extern void _ZN10S2440C2_nt4v136Ev();
extern void _ZN10S2440C2_nt4v137Ev();
extern void _ZN10S2440C2_nt4v138Ev();
extern void _ZN10S2440C2_nt4v139Ev();
extern void _ZN10S2440C2_nt4v140Ev();
extern void _ZN10S2440C2_nt4v141Ev();
extern void _ZN10S2440C2_nt4v142Ev();
extern void _ZN10S2440C2_nt4v143Ev();
extern void _ZN10S2440C2_nt4v144Ev();
extern void _ZN10S2440C2_nt4v145Ev();
extern void _ZN10S2440C2_nt4v146Ev();
extern void _ZN10S2440C2_nt4v147Ev();
extern void _ZN10S2440C2_nt4v148Ev();
static  VTBL_ENTRY vtc_S2440C2_nt[] = {
  0,
  (VTBL_ENTRY)&(_ZTI10S2440C2_nt[0]),
  (VTBL_ENTRY)&_ZN10S2440C2_ntD1Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_ntD0Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v148Ev,
};
extern VTBL_ENTRY _ZTI10S2440C2_nt[];
VTBL_ENTRY *P__ZTI10S2440C2_nt = _ZTI10S2440C2_nt; 
extern  VTBL_ENTRY _ZTV10S2440C2_nt[];
Class_Descriptor cd_S2440C2_nt = {  "S2440C2_nt", // class name
  bases_S2440C2_nt, 2,
  &(vtc_S2440C2_nt[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(896,684), // object size
  NSPAIRA(_ZTI10S2440C2_nt),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV10S2440C2_nt),144, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2440C1  : S2440C2_nt {
  virtual  ~S2440C1(); // _ZN7S2440C1D1Ev
  virtual void  v1(); // _ZN7S2440C12v1Ev
  virtual void  v2(); // _ZN7S2440C12v2Ev
  virtual void  v3(); // _ZN7S2440C12v3Ev
  virtual void  v4(); // _ZN7S2440C12v4Ev
  virtual void  v5(); // _ZN7S2440C12v5Ev
  virtual void  v6(); // _ZN7S2440C12v6Ev
  virtual void  v7(); // _ZN7S2440C12v7Ev
  virtual void  v8(); // _ZN7S2440C12v8Ev
  S2440C1(); // tgen
};
//SIG(1 S2440C1) C1{ BC2{ BC3{ BC4{ vd v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 Fp Fi FC5{ BC6{ m Fp Fi FC7{ m} FC7}} FC5 Fi} vd v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 FC8{ m FC9{ m FL[2]}} FC8 FC8 FC8 FC10{ m FC8} FC11{ m FC8 FC8 FC8 FC8} FC11 FC8 FC8 FC8 Fp FC10 FC12{ m FC13{ m Fp Fi FC14{ m}} Fi} Fi Fp[7] FC15{ m Fp Fi FC14 FC16{ m}} Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC17{ BC18{ m Fp Fi FC16 FC19{ m}}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC20{ m Fp Fi[2] FC19} Fp[2] Fi:16 Fi:16 FC17 FC20 FC21{ m Fp Fi[2] FC22{ m}} Fp[2] Fi:24 Fi:8 Fp} vd v110 v111 v112 v113 v114 v115 v116 v117 v118 v119 v120 v121 v122 v123 v124 v125 v126 v127 v128 v129 v130 v131 v132 v133 v134 v135 v136 v137 v138 v139 v140 v141 v142 v143 v144 v145 v146 v147 v148 Fi[4] Fp Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi:8 Fi:16 Fi:16 Fi:16 Fi:16 Fi:16 Fi FC15 Fc:1 Fc:1} vd v1 v2 v3 v4 v5 v6 v7 v8}


 S2440C1 ::~S2440C1(){ note_dtor("S2440C1", this);}
void  S2440C1 ::v1(){vfunc_called(this, "_ZN7S2440C12v1Ev");}
void  S2440C1 ::v2(){vfunc_called(this, "_ZN7S2440C12v2Ev");}
void  S2440C1 ::v3(){vfunc_called(this, "_ZN7S2440C12v3Ev");}
void  S2440C1 ::v4(){vfunc_called(this, "_ZN7S2440C12v4Ev");}
void  S2440C1 ::v5(){vfunc_called(this, "_ZN7S2440C12v5Ev");}
void  S2440C1 ::v6(){vfunc_called(this, "_ZN7S2440C12v6Ev");}
void  S2440C1 ::v7(){vfunc_called(this, "_ZN7S2440C12v7Ev");}
void  S2440C1 ::v8(){vfunc_called(this, "_ZN7S2440C12v8Ev");}
S2440C1 ::S2440C1(){ note_ctor("S2440C1", this);} // tgen

static void Test_S2440C1()
{
  extern Class_Descriptor cd_S2440C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(113,172)];
    init_test(&cd_S2440C1, buf);
    S2440C1 *dp, &lv = *(dp=new (buf) S2440C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(896,684), "sizeof(S2440C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S2440C1)");
    check_base_class_offset(lv, (S2440C4_nt*)(S2440C3_nt*)(S2440C2_nt*), 0, "S2440C1");
    check_base_class_offset(lv, (S2440C3_nt*)(S2440C2_nt*), 0, "S2440C1");
    check_base_class_offset(lv, (S2440C2_nt*), 0, "S2440C1");
    test_class_info(&lv, &cd_S2440C1);
    dp->~S2440C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2440C1(Test_S2440C1, "S2440C1", ABISELECT(896,684));

#else // __cplusplus

extern void _ZN7S2440C1C1Ev();
extern void _ZN7S2440C1D1Ev();
Name_Map name_map_S2440C1[] = {
  NSPAIR(_ZN7S2440C1C1Ev),
  NSPAIR(_ZN7S2440C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2440C4_nt;
extern VTBL_ENTRY _ZTI10S2440C4_nt[];
extern  VTBL_ENTRY _ZTV10S2440C4_nt[];
extern Class_Descriptor cd_S2440C3_nt;
extern VTBL_ENTRY _ZTI10S2440C3_nt[];
extern  VTBL_ENTRY _ZTV10S2440C3_nt[];
extern Class_Descriptor cd_S2440C2_nt;
extern VTBL_ENTRY _ZTI10S2440C2_nt[];
extern  VTBL_ENTRY _ZTV10S2440C2_nt[];
static Base_Class bases_S2440C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2440C4_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S2440C3_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    2, //immediately_derived
  0, 0},
  {&cd_S2440C2_nt,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2440C1[];
extern void _ZN7S2440C1D1Ev();
extern void _ZN7S2440C1D0Ev();
extern void _ZN10S2440C4_nt2v9Ev();
extern void _ZN10S2440C4_nt3v10Ev();
extern void _ZN10S2440C4_nt3v11Ev();
extern void _ZN10S2440C4_nt3v12Ev();
extern void _ZN10S2440C4_nt3v13Ev();
extern void _ZN10S2440C4_nt3v14Ev();
extern void _ZN10S2440C4_nt3v15Ev();
extern void _ZN10S2440C4_nt3v16Ev();
extern void _ZN10S2440C4_nt3v17Ev();
extern void _ZN10S2440C4_nt3v18Ev();
extern void _ZN10S2440C4_nt3v19Ev();
extern void _ZN10S2440C4_nt3v20Ev();
extern void _ZN10S2440C4_nt3v21Ev();
extern void _ZN10S2440C4_nt3v22Ev();
extern void _ZN10S2440C4_nt3v23Ev();
extern void _ZN10S2440C4_nt3v24Ev();
extern void _ZN10S2440C4_nt3v25Ev();
extern void _ZN10S2440C4_nt3v26Ev();
extern void _ZN10S2440C4_nt3v27Ev();
extern void _ZN10S2440C4_nt3v28Ev();
extern void _ZN10S2440C4_nt3v29Ev();
extern void _ZN10S2440C4_nt3v30Ev();
extern void _ZN10S2440C4_nt3v31Ev();
extern void _ZN10S2440C3_nt3v32Ev();
extern void _ZN10S2440C3_nt3v33Ev();
extern void _ZN10S2440C3_nt3v34Ev();
extern void _ZN10S2440C3_nt3v35Ev();
extern void _ZN10S2440C3_nt3v36Ev();
extern void _ZN10S2440C3_nt3v37Ev();
extern void _ZN10S2440C3_nt3v38Ev();
extern void _ZN10S2440C3_nt3v39Ev();
extern void _ZN10S2440C3_nt3v40Ev();
extern void _ZN10S2440C3_nt3v41Ev();
extern void _ZN10S2440C3_nt3v42Ev();
extern void _ZN10S2440C3_nt3v43Ev();
extern void _ZN10S2440C3_nt3v44Ev();
extern void _ZN10S2440C3_nt3v45Ev();
extern void _ZN10S2440C3_nt3v46Ev();
extern void _ZN10S2440C3_nt3v47Ev();
extern void _ZN10S2440C3_nt3v48Ev();
extern void _ZN10S2440C3_nt3v49Ev();
extern void _ZN10S2440C3_nt3v50Ev();
extern void _ZN10S2440C3_nt3v51Ev();
extern void _ZN10S2440C3_nt3v52Ev();
extern void _ZN10S2440C3_nt3v53Ev();
extern void _ZN10S2440C3_nt3v54Ev();
extern void _ZN10S2440C3_nt3v55Ev();
extern void _ZN10S2440C3_nt3v56Ev();
extern void _ZN10S2440C3_nt3v57Ev();
extern void _ZN10S2440C3_nt3v58Ev();
extern void _ZN10S2440C3_nt3v59Ev();
extern void _ZN10S2440C3_nt3v60Ev();
extern void _ZN10S2440C3_nt3v61Ev();
extern void _ZN10S2440C3_nt3v62Ev();
extern void _ZN10S2440C3_nt3v63Ev();
extern void _ZN10S2440C3_nt3v64Ev();
extern void _ZN10S2440C3_nt3v65Ev();
extern void _ZN10S2440C3_nt3v66Ev();
extern void _ZN10S2440C3_nt3v67Ev();
extern void _ZN10S2440C3_nt3v68Ev();
extern void _ZN10S2440C3_nt3v69Ev();
extern void _ZN10S2440C3_nt3v70Ev();
extern void _ZN10S2440C3_nt3v71Ev();
extern void _ZN10S2440C3_nt3v72Ev();
extern void _ZN10S2440C3_nt3v73Ev();
extern void _ZN10S2440C3_nt3v74Ev();
extern void _ZN10S2440C3_nt3v75Ev();
extern void _ZN10S2440C3_nt3v76Ev();
extern void _ZN10S2440C3_nt3v77Ev();
extern void _ZN10S2440C3_nt3v78Ev();
extern void _ZN10S2440C3_nt3v79Ev();
extern void _ZN10S2440C3_nt3v80Ev();
extern void _ZN10S2440C3_nt3v81Ev();
extern void _ZN10S2440C3_nt3v82Ev();
extern void _ZN10S2440C3_nt3v83Ev();
extern void _ZN10S2440C3_nt3v84Ev();
extern void _ZN10S2440C3_nt3v85Ev();
extern void _ZN10S2440C3_nt3v86Ev();
extern void _ZN10S2440C3_nt3v87Ev();
extern void _ZN10S2440C3_nt3v88Ev();
extern void _ZN10S2440C3_nt3v89Ev();
extern void _ZN10S2440C3_nt3v90Ev();
extern void _ZN10S2440C3_nt3v91Ev();
extern void _ZN10S2440C3_nt3v92Ev();
extern void _ZN10S2440C3_nt3v93Ev();
extern void _ZN10S2440C3_nt3v94Ev();
extern void _ZN10S2440C3_nt3v95Ev();
extern void _ZN10S2440C3_nt3v96Ev();
extern void _ZN10S2440C3_nt3v97Ev();
extern void _ZN10S2440C3_nt3v98Ev();
extern void _ZN10S2440C3_nt3v99Ev();
extern void _ZN10S2440C3_nt4v100Ev();
extern void _ZN10S2440C3_nt4v101Ev();
extern void _ZN10S2440C3_nt4v102Ev();
extern void _ZN10S2440C3_nt4v103Ev();
extern void _ZN10S2440C3_nt4v104Ev();
extern void _ZN10S2440C3_nt4v105Ev();
extern void _ZN10S2440C3_nt4v106Ev();
extern void _ZN10S2440C3_nt4v107Ev();
extern void _ZN10S2440C3_nt4v108Ev();
extern void _ZN10S2440C3_nt4v109Ev();
extern void _ZN10S2440C2_nt4v110Ev();
extern void _ZN10S2440C2_nt4v111Ev();
extern void _ZN10S2440C2_nt4v112Ev();
extern void _ZN10S2440C2_nt4v113Ev();
extern void _ZN10S2440C2_nt4v114Ev();
extern void _ZN10S2440C2_nt4v115Ev();
extern void _ZN10S2440C2_nt4v116Ev();
extern void _ZN10S2440C2_nt4v117Ev();
extern void _ZN10S2440C2_nt4v118Ev();
extern void _ZN10S2440C2_nt4v119Ev();
extern void _ZN10S2440C2_nt4v120Ev();
extern void _ZN10S2440C2_nt4v121Ev();
extern void _ZN10S2440C2_nt4v122Ev();
extern void _ZN10S2440C2_nt4v123Ev();
extern void _ZN10S2440C2_nt4v124Ev();
extern void _ZN10S2440C2_nt4v125Ev();
extern void _ZN10S2440C2_nt4v126Ev();
extern void _ZN10S2440C2_nt4v127Ev();
extern void _ZN10S2440C2_nt4v128Ev();
extern void _ZN10S2440C2_nt4v129Ev();
extern void _ZN10S2440C2_nt4v130Ev();
extern void _ZN10S2440C2_nt4v131Ev();
extern void _ZN10S2440C2_nt4v132Ev();
extern void _ZN10S2440C2_nt4v133Ev();
extern void _ZN10S2440C2_nt4v134Ev();
extern void _ZN10S2440C2_nt4v135Ev();
extern void _ZN10S2440C2_nt4v136Ev();
extern void _ZN10S2440C2_nt4v137Ev();
extern void _ZN10S2440C2_nt4v138Ev();
extern void _ZN10S2440C2_nt4v139Ev();
extern void _ZN10S2440C2_nt4v140Ev();
extern void _ZN10S2440C2_nt4v141Ev();
extern void _ZN10S2440C2_nt4v142Ev();
extern void _ZN10S2440C2_nt4v143Ev();
extern void _ZN10S2440C2_nt4v144Ev();
extern void _ZN10S2440C2_nt4v145Ev();
extern void _ZN10S2440C2_nt4v146Ev();
extern void _ZN10S2440C2_nt4v147Ev();
extern void _ZN10S2440C2_nt4v148Ev();
extern void _ZN7S2440C12v1Ev();
extern void _ZN7S2440C12v2Ev();
extern void _ZN7S2440C12v3Ev();
extern void _ZN7S2440C12v4Ev();
extern void _ZN7S2440C12v5Ev();
extern void _ZN7S2440C12v6Ev();
extern void _ZN7S2440C12v7Ev();
extern void _ZN7S2440C12v8Ev();
static  VTBL_ENTRY vtc_S2440C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S2440C1[0]),
  (VTBL_ENTRY)&_ZN7S2440C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2440C1D0Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt2v9Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v10Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v11Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v12Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v13Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v14Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v15Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v16Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v17Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v18Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v19Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v20Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v21Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v22Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v23Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v24Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v25Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v26Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v27Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v28Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v29Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v30Ev,
  (VTBL_ENTRY)&_ZN10S2440C4_nt3v31Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v32Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v33Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v34Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v35Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v36Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v37Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v38Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v39Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v40Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v41Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v42Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v43Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v44Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v45Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v46Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v47Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v48Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v49Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v50Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v51Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v52Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v53Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v54Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v55Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v56Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v57Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v58Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v59Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v60Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v61Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v62Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v63Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v64Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v65Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v66Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v67Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v68Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v69Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v70Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v71Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v72Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v73Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v74Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v75Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v76Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v77Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v78Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v79Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v80Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v81Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v82Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v83Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v84Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v85Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v86Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v87Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v88Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v89Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v90Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v91Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v92Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v93Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v94Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v95Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v96Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v97Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v98Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt3v99Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v100Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v101Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v102Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v103Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v104Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v105Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v106Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v107Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v108Ev,
  (VTBL_ENTRY)&_ZN10S2440C3_nt4v109Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v110Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v111Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v112Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v113Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v114Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v115Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v116Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v117Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v118Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v119Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v120Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v121Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v122Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v123Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v124Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v125Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v126Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v127Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v128Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v129Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v130Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v131Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v132Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v133Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v134Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v135Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v136Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v137Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v138Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v139Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v140Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v141Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v142Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v143Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v144Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v145Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v146Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v147Ev,
  (VTBL_ENTRY)&_ZN10S2440C2_nt4v148Ev,
  (VTBL_ENTRY)&_ZN7S2440C12v1Ev,
  (VTBL_ENTRY)&_ZN7S2440C12v2Ev,
  (VTBL_ENTRY)&_ZN7S2440C12v3Ev,
  (VTBL_ENTRY)&_ZN7S2440C12v4Ev,
  (VTBL_ENTRY)&_ZN7S2440C12v5Ev,
  (VTBL_ENTRY)&_ZN7S2440C12v6Ev,
  (VTBL_ENTRY)&_ZN7S2440C12v7Ev,
  (VTBL_ENTRY)&_ZN7S2440C12v8Ev,
};
extern VTBL_ENTRY _ZTI7S2440C1[];
extern  VTBL_ENTRY _ZTV7S2440C1[];
Class_Descriptor cd_S2440C1 = {  "S2440C1", // class name
  bases_S2440C1, 3,
  &(vtc_S2440C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(896,684), // object size
  NSPAIRA(_ZTI7S2440C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2440C1),152, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  3, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4206C3  {
  void *s4206c3f0;
  int s4206c3f1;
  ::S2440C25 s4206c3f2;
  ::S2440C5_nt s4206c3f3;
  int s4206c3f4;
  virtual  ~S4206C3(); // _ZN7S4206C3D1Ev
  virtual void  v10(); // _ZN7S4206C33v10Ev
  virtual void  v11(); // _ZN7S4206C33v11Ev
  virtual void  v12(); // _ZN7S4206C33v12Ev
  virtual void  v13(); // _ZN7S4206C33v13Ev
  virtual void  v14(); // _ZN7S4206C33v14Ev
  virtual void  v15(); // _ZN7S4206C33v15Ev
  virtual void  v16(); // _ZN7S4206C33v16Ev
  virtual void  v17(); // _ZN7S4206C33v17Ev
  virtual void  v18(); // _ZN7S4206C33v18Ev
  virtual void  v19(); // _ZN7S4206C33v19Ev
  virtual void  v20(); // _ZN7S4206C33v20Ev
  virtual void  v21(); // _ZN7S4206C33v21Ev
  virtual void  v22(); // _ZN7S4206C33v22Ev
  virtual void  v23(); // _ZN7S4206C33v23Ev
  virtual void  v24(); // _ZN7S4206C33v24Ev
  virtual void  v25(); // _ZN7S4206C33v25Ev
  virtual void  v26(); // _ZN7S4206C33v26Ev
  virtual void  v27(); // _ZN7S4206C33v27Ev
  virtual void  v28(); // _ZN7S4206C33v28Ev
  virtual void  v29(); // _ZN7S4206C33v29Ev
  virtual void  v30(); // _ZN7S4206C33v30Ev
  virtual void  v31(); // _ZN7S4206C33v31Ev
  virtual void  v32(); // _ZN7S4206C33v32Ev
  S4206C3(); // tgen
};
//SIG(-1 S4206C3) C1{ vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 Fp Fi FC2{ BC3{ m Fp Fi FC4{ m} FC5{ m}}} FC6{ BC7{ m Fp Fi FC8{ m} FC8}} Fi}


 S4206C3 ::~S4206C3(){ note_dtor("S4206C3", this);}
void  S4206C3 ::v10(){vfunc_called(this, "_ZN7S4206C33v10Ev");}
void  S4206C3 ::v11(){vfunc_called(this, "_ZN7S4206C33v11Ev");}
void  S4206C3 ::v12(){vfunc_called(this, "_ZN7S4206C33v12Ev");}
void  S4206C3 ::v13(){vfunc_called(this, "_ZN7S4206C33v13Ev");}
void  S4206C3 ::v14(){vfunc_called(this, "_ZN7S4206C33v14Ev");}
void  S4206C3 ::v15(){vfunc_called(this, "_ZN7S4206C33v15Ev");}
void  S4206C3 ::v16(){vfunc_called(this, "_ZN7S4206C33v16Ev");}
void  S4206C3 ::v17(){vfunc_called(this, "_ZN7S4206C33v17Ev");}
void  S4206C3 ::v18(){vfunc_called(this, "_ZN7S4206C33v18Ev");}
void  S4206C3 ::v19(){vfunc_called(this, "_ZN7S4206C33v19Ev");}
void  S4206C3 ::v20(){vfunc_called(this, "_ZN7S4206C33v20Ev");}
void  S4206C3 ::v21(){vfunc_called(this, "_ZN7S4206C33v21Ev");}
void  S4206C3 ::v22(){vfunc_called(this, "_ZN7S4206C33v22Ev");}
void  S4206C3 ::v23(){vfunc_called(this, "_ZN7S4206C33v23Ev");}
void  S4206C3 ::v24(){vfunc_called(this, "_ZN7S4206C33v24Ev");}
void  S4206C3 ::v25(){vfunc_called(this, "_ZN7S4206C33v25Ev");}
void  S4206C3 ::v26(){vfunc_called(this, "_ZN7S4206C33v26Ev");}
void  S4206C3 ::v27(){vfunc_called(this, "_ZN7S4206C33v27Ev");}
void  S4206C3 ::v28(){vfunc_called(this, "_ZN7S4206C33v28Ev");}
void  S4206C3 ::v29(){vfunc_called(this, "_ZN7S4206C33v29Ev");}
void  S4206C3 ::v30(){vfunc_called(this, "_ZN7S4206C33v30Ev");}
void  S4206C3 ::v31(){vfunc_called(this, "_ZN7S4206C33v31Ev");}
void  S4206C3 ::v32(){vfunc_called(this, "_ZN7S4206C33v32Ev");}
S4206C3 ::S4206C3(){ note_ctor("S4206C3", this);} // tgen

static void Test_S4206C3()
{
  extern Class_Descriptor cd_S4206C3;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(9,11)];
    init_test(&cd_S4206C3, buf);
    S4206C3 *dp, &lv = *(dp=new (buf) S4206C3());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(64,40), "sizeof(S4206C3)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4206C3)");
    check_field_offset(lv, s4206c3f0, ABISELECT(8,4), "S4206C3.s4206c3f0");
    check_field_offset(lv, s4206c3f1, ABISELECT(16,8), "S4206C3.s4206c3f1");
    check_field_offset(lv, s4206c3f2, ABISELECT(24,12), "S4206C3.s4206c3f2");
    check_field_offset(lv, s4206c3f3, ABISELECT(40,24), "S4206C3.s4206c3f3");
    check_field_offset(lv, s4206c3f4, ABISELECT(56,36), "S4206C3.s4206c3f4");
    test_class_info(&lv, &cd_S4206C3);
    dp->~S4206C3();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4206C3(Test_S4206C3, "S4206C3", ABISELECT(64,40));

#else // __cplusplus

extern void _ZN7S4206C3C1Ev();
extern void _ZN7S4206C3D1Ev();
Name_Map name_map_S4206C3[] = {
  NSPAIR(_ZN7S4206C3C1Ev),
  NSPAIR(_ZN7S4206C3D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI7S4206C3[];
extern void _ZN7S4206C3D1Ev();
extern void _ZN7S4206C3D0Ev();
extern void _ZN7S4206C33v10Ev();
extern void _ZN7S4206C33v11Ev();
extern void _ZN7S4206C33v12Ev();
extern void _ZN7S4206C33v13Ev();
extern void _ZN7S4206C33v14Ev();
extern void _ZN7S4206C33v15Ev();
extern void _ZN7S4206C33v16Ev();
extern void _ZN7S4206C33v17Ev();
extern void _ZN7S4206C33v18Ev();
extern void _ZN7S4206C33v19Ev();
extern void _ZN7S4206C33v20Ev();
extern void _ZN7S4206C33v21Ev();
extern void _ZN7S4206C33v22Ev();
extern void _ZN7S4206C33v23Ev();
extern void _ZN7S4206C33v24Ev();
extern void _ZN7S4206C33v25Ev();
extern void _ZN7S4206C33v26Ev();
extern void _ZN7S4206C33v27Ev();
extern void _ZN7S4206C33v28Ev();
extern void _ZN7S4206C33v29Ev();
extern void _ZN7S4206C33v30Ev();
extern void _ZN7S4206C33v31Ev();
extern void _ZN7S4206C33v32Ev();
static  VTBL_ENTRY vtc_S4206C3[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4206C3[0]),
  (VTBL_ENTRY)&_ZN7S4206C3D1Ev,
  (VTBL_ENTRY)&_ZN7S4206C3D0Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v10Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v11Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v12Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v13Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v14Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v15Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v16Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v17Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v18Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v19Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v20Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v21Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v22Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v23Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v24Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v25Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v26Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v27Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v28Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v29Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v30Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v31Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v32Ev,
};
extern VTBL_ENTRY _ZTI7S4206C3[];
extern  VTBL_ENTRY _ZTV7S4206C3[];
Class_Descriptor cd_S4206C3 = {  "S4206C3", // class name
  0,0,//no base classes
  &(vtc_S4206C3[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(64,40), // object size
  NSPAIRA(_ZTI7S4206C3),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV7S4206C3),27, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4206C14_nt  {
  ::S2440C14_nt s4206c14f0;
  void  mf4206c14(); // _ZN11S4206C14_nt9mf4206c14Ev
};
//SIG(-1 S4206C14_nt) C1{ m FC2{ m FL[2]}}


void  S4206C14_nt ::mf4206c14(){}

//skip512 S4206C14_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4206C24_nt  : S2440C22 {
};
//SIG(-1 S4206C24_nt) C1{ BC2{ m Fp Fi FC3{ m} FC4{ m}}}



//skip512 S4206C24_nt

#else // __cplusplus

extern Class_Descriptor cd_S2440C22;
static Base_Class bases_S4206C24_nt[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2440C22,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4206C36_nt  {
  void *s4206c36f0;
  int s4206c36f1[2];
  ::S2440C38 s4206c36f2;
  void  mf4206c36(); // _ZN11S4206C36_nt9mf4206c36Ev
};
//SIG(-1 S4206C36_nt) C1{ m Fp Fi[2] FC2{ m}}


void  S4206C36_nt ::mf4206c36(){}

//skip512 S4206C36_nt

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4206C2  : S4206C3 {
  ::S2440C13_nt s4206c2f0;
  ::S2440C13_nt s4206c2f1;
  ::S2440C13_nt s4206c2f2;
  ::S4206C14_nt s4206c2f3;
  ::S2440C17_nt s4206c2f4;
  ::S2440C18_nt s4206c2f5;
  ::S2440C18_nt s4206c2f6;
  ::S2440C13_nt s4206c2f7;
  ::S2440C13_nt s4206c2f8;
  ::S2440C13_nt s4206c2f9;
  void *s4206c2f10;
  ::S2440C17_nt s4206c2f11;
  ::S2440C19_nt s4206c2f12;
  int s4206c2f13;
  void *s4206c2f14[7];
  ::S2440C26 s4206c2f15;
  int s4206c2f16:8;
  int s4206c2f17:8;
  int s4206c2f18:16;
  int s4206c2f19:16;
  int s4206c2f20:8;
  int s4206c2f21:8;
  int s4206c2f22:8;
  int s4206c2f23:32;
  int s4206c2f24:8;
  int s4206c2f25:4;
  int s4206c2f26:4;
  int s4206c2f27:4;
  int s4206c2f28:4;
  int s4206c2f29:4;
  int s4206c2f30:4;
  int s4206c2f31:4;
  int s4206c2f32:4;
  int s4206c2f33:4;
  int s4206c2f34:4;
  unsigned char s4206c2f35:1;
  unsigned char s4206c2f36:1;
  unsigned char s4206c2f37:1;
  unsigned char s4206c2f38:1;
  unsigned char s4206c2f39:1;
  unsigned char s4206c2f40:1;
  unsigned char s4206c2f41:1;
  unsigned char s4206c2f42:1;
  unsigned char s4206c2f43:1;
  unsigned char s4206c2f44:1;
  unsigned char s4206c2f45:1;
  unsigned char s4206c2f46:1;
  unsigned char s4206c2f47:1;
  unsigned char s4206c2f48:1;
  unsigned char s4206c2f49:1;
  unsigned char s4206c2f50:1;
  unsigned char s4206c2f51:1;
  unsigned char s4206c2f52:1;
  unsigned char s4206c2f53:1;
  unsigned char s4206c2f54:1;
  unsigned char s4206c2f55:1;
  unsigned char s4206c2f56:1;
  unsigned char s4206c2f57:1;
  unsigned char s4206c2f58:1;
  unsigned char s4206c2f59:1;
  unsigned char s4206c2f60:1;
  unsigned char s4206c2f61:1;
  unsigned char s4206c2f62:1;
  unsigned char s4206c2f63:1;
  unsigned char s4206c2f64:1;
  unsigned char s4206c2f65:1;
  unsigned char s4206c2f66:1;
  unsigned char s4206c2f67:1;
  unsigned char s4206c2f68:1;
  unsigned char s4206c2f69:1;
  unsigned char s4206c2f70:1;
  unsigned char s4206c2f71:1;
  unsigned char s4206c2f72:1;
  unsigned char s4206c2f73:1;
  unsigned char s4206c2f74:1;
  unsigned char s4206c2f75:1;
  int s4206c2f76[7];
  void *s4206c2f77[6];
  int s4206c2f78:8;
  int s4206c2f79:8;
  int s4206c2f80:8;
  int s4206c2f81:8;
  int s4206c2f82:8;
  int s4206c2f83:8;
  ::S4206C24_nt s4206c2f84;
  void *s4206c2f85[4];
  int s4206c2f86:8;
  int s4206c2f87:8;
  int s4206c2f88:8;
  int s4206c2f89:8;
  int s4206c2f90:8;
  int s4206c2f91:16;
  int s4206c2f92:16;
  int s4206c2f93:16;
  int s4206c2f94:4;
  int s4206c2f95:4;
  int s4206c2f96:4;
  int s4206c2f97:4;
  int s4206c2f98:4;
  int s4206c2f99:4;
  int s4206c2f100:4;
  int s4206c2f101:4;
  int s4206c2f102:4;
  int s4206c2f103:4;
  int s4206c2f104:4;
  int s4206c2f105:4;
  int s4206c2f106:8;
  int s4206c2f107:8;
  int s4206c2f108:8;
  void *s4206c2f109[7];
  ::S2440C37 s4206c2f110;
  void *s4206c2f111[2];
  int s4206c2f112:16;
  int s4206c2f113:16;
  ::S4206C24_nt s4206c2f114;
  ::S2440C29_nt s4206c2f115;
  ::S4206C36_nt s4206c2f116;
  void *s4206c2f117[2];
  int s4206c2f118:24;
  int s4206c2f119:8;
  void *s4206c2f120;
  virtual  ~S4206C2(); // _ZN7S4206C2D1Ev
  virtual void  v33(); // _ZN7S4206C23v33Ev
  virtual void  v34(); // _ZN7S4206C23v34Ev
  virtual void  v35(); // _ZN7S4206C23v35Ev
  virtual void  v36(); // _ZN7S4206C23v36Ev
  virtual void  v37(); // _ZN7S4206C23v37Ev
  virtual void  v38(); // _ZN7S4206C23v38Ev
  virtual void  v39(); // _ZN7S4206C23v39Ev
  virtual void  v40(); // _ZN7S4206C23v40Ev
  virtual void  v41(); // _ZN7S4206C23v41Ev
  virtual void  v42(); // _ZN7S4206C23v42Ev
  virtual void  v43(); // _ZN7S4206C23v43Ev
  virtual void  v44(); // _ZN7S4206C23v44Ev
  virtual void  v45(); // _ZN7S4206C23v45Ev
  virtual void  v46(); // _ZN7S4206C23v46Ev
  virtual void  v47(); // _ZN7S4206C23v47Ev
  virtual void  v48(); // _ZN7S4206C23v48Ev
  virtual void  v49(); // _ZN7S4206C23v49Ev
  virtual void  v50(); // _ZN7S4206C23v50Ev
  virtual void  v51(); // _ZN7S4206C23v51Ev
  virtual void  v52(); // _ZN7S4206C23v52Ev
  virtual void  v53(); // _ZN7S4206C23v53Ev
  virtual void  v54(); // _ZN7S4206C23v54Ev
  virtual void  v55(); // _ZN7S4206C23v55Ev
  virtual void  v56(); // _ZN7S4206C23v56Ev
  virtual void  v57(); // _ZN7S4206C23v57Ev
  virtual void  v58(); // _ZN7S4206C23v58Ev
  virtual void  v59(); // _ZN7S4206C23v59Ev
  virtual void  v60(); // _ZN7S4206C23v60Ev
  virtual void  v61(); // _ZN7S4206C23v61Ev
  virtual void  v62(); // _ZN7S4206C23v62Ev
  virtual void  v63(); // _ZN7S4206C23v63Ev
  virtual void  v64(); // _ZN7S4206C23v64Ev
  virtual void  v65(); // _ZN7S4206C23v65Ev
  virtual void  v66(); // _ZN7S4206C23v66Ev
  virtual void  v67(); // _ZN7S4206C23v67Ev
  virtual void  v68(); // _ZN7S4206C23v68Ev
  virtual void  v69(); // _ZN7S4206C23v69Ev
  virtual void  v70(); // _ZN7S4206C23v70Ev
  virtual void  v71(); // _ZN7S4206C23v71Ev
  virtual void  v72(); // _ZN7S4206C23v72Ev
  virtual void  v73(); // _ZN7S4206C23v73Ev
  virtual void  v74(); // _ZN7S4206C23v74Ev
  virtual void  v75(); // _ZN7S4206C23v75Ev
  virtual void  v76(); // _ZN7S4206C23v76Ev
  virtual void  v77(); // _ZN7S4206C23v77Ev
  virtual void  v78(); // _ZN7S4206C23v78Ev
  virtual void  v79(); // _ZN7S4206C23v79Ev
  virtual void  v80(); // _ZN7S4206C23v80Ev
  virtual void  v81(); // _ZN7S4206C23v81Ev
  virtual void  v82(); // _ZN7S4206C23v82Ev
  virtual void  v83(); // _ZN7S4206C23v83Ev
  virtual void  v84(); // _ZN7S4206C23v84Ev
  virtual void  v85(); // _ZN7S4206C23v85Ev
  virtual void  v86(); // _ZN7S4206C23v86Ev
  virtual void  v87(); // _ZN7S4206C23v87Ev
  virtual void  v88(); // _ZN7S4206C23v88Ev
  virtual void  v89(); // _ZN7S4206C23v89Ev
  virtual void  v90(); // _ZN7S4206C23v90Ev
  virtual void  v91(); // _ZN7S4206C23v91Ev
  virtual void  v92(); // _ZN7S4206C23v92Ev
  virtual void  v93(); // _ZN7S4206C23v93Ev
  virtual void  v94(); // _ZN7S4206C23v94Ev
  virtual void  v95(); // _ZN7S4206C23v95Ev
  virtual void  v96(); // _ZN7S4206C23v96Ev
  virtual void  v97(); // _ZN7S4206C23v97Ev
  virtual void  v98(); // _ZN7S4206C23v98Ev
  virtual void  v99(); // _ZN7S4206C23v99Ev
  virtual void  v100(); // _ZN7S4206C24v100Ev
  virtual void  v101(); // _ZN7S4206C24v101Ev
  virtual void  v102(); // _ZN7S4206C24v102Ev
  virtual void  v103(); // _ZN7S4206C24v103Ev
  virtual void  v104(); // _ZN7S4206C24v104Ev
  virtual void  v105(); // _ZN7S4206C24v105Ev
  virtual void  v106(); // _ZN7S4206C24v106Ev
  virtual void  v107(); // _ZN7S4206C24v107Ev
  virtual void  v108(); // _ZN7S4206C24v108Ev
  virtual void  v109(); // _ZN7S4206C24v109Ev
  virtual void  v110(); // _ZN7S4206C24v110Ev
  S4206C2(); // tgen
};
//SIG(-1 S4206C2) C1{ BC2{ vd v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 Fp Fi FC3{ BC4{ m Fp Fi FC5{ m} FC6{ m}}} FC7{ BC8{ m Fp Fi FC9{ m} FC9}} Fi} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 FC10{ m FC11{ m FL[2]}} FC10 FC10 FC12{ m FC11} FC13{ m FC10} FC14{ m FC10 FC10 FC10 FC10} FC14 FC10 FC10 FC10 Fp FC13 FC15{ m FC16{ m Fp Fi FC17{ m}} Fi} Fi Fp[7] FC4 Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC18{ BC19{ m Fp Fi FC17 FC5}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC20{ m Fp Fi[2] FC21{ m}} Fp[2] Fi:16 Fi:16 FC18 FC22{ m Fp Fi[2] FC6} FC23{ m Fp Fi[2] FC21} Fp[2] Fi:24 Fi:8 Fp}


 S4206C2 ::~S4206C2(){ note_dtor("S4206C2", this);}
void  S4206C2 ::v33(){vfunc_called(this, "_ZN7S4206C23v33Ev");}
void  S4206C2 ::v34(){vfunc_called(this, "_ZN7S4206C23v34Ev");}
void  S4206C2 ::v35(){vfunc_called(this, "_ZN7S4206C23v35Ev");}
void  S4206C2 ::v36(){vfunc_called(this, "_ZN7S4206C23v36Ev");}
void  S4206C2 ::v37(){vfunc_called(this, "_ZN7S4206C23v37Ev");}
void  S4206C2 ::v38(){vfunc_called(this, "_ZN7S4206C23v38Ev");}
void  S4206C2 ::v39(){vfunc_called(this, "_ZN7S4206C23v39Ev");}
void  S4206C2 ::v40(){vfunc_called(this, "_ZN7S4206C23v40Ev");}
void  S4206C2 ::v41(){vfunc_called(this, "_ZN7S4206C23v41Ev");}
void  S4206C2 ::v42(){vfunc_called(this, "_ZN7S4206C23v42Ev");}
void  S4206C2 ::v43(){vfunc_called(this, "_ZN7S4206C23v43Ev");}
void  S4206C2 ::v44(){vfunc_called(this, "_ZN7S4206C23v44Ev");}
void  S4206C2 ::v45(){vfunc_called(this, "_ZN7S4206C23v45Ev");}
void  S4206C2 ::v46(){vfunc_called(this, "_ZN7S4206C23v46Ev");}
void  S4206C2 ::v47(){vfunc_called(this, "_ZN7S4206C23v47Ev");}
void  S4206C2 ::v48(){vfunc_called(this, "_ZN7S4206C23v48Ev");}
void  S4206C2 ::v49(){vfunc_called(this, "_ZN7S4206C23v49Ev");}
void  S4206C2 ::v50(){vfunc_called(this, "_ZN7S4206C23v50Ev");}
void  S4206C2 ::v51(){vfunc_called(this, "_ZN7S4206C23v51Ev");}
void  S4206C2 ::v52(){vfunc_called(this, "_ZN7S4206C23v52Ev");}
void  S4206C2 ::v53(){vfunc_called(this, "_ZN7S4206C23v53Ev");}
void  S4206C2 ::v54(){vfunc_called(this, "_ZN7S4206C23v54Ev");}
void  S4206C2 ::v55(){vfunc_called(this, "_ZN7S4206C23v55Ev");}
void  S4206C2 ::v56(){vfunc_called(this, "_ZN7S4206C23v56Ev");}
void  S4206C2 ::v57(){vfunc_called(this, "_ZN7S4206C23v57Ev");}
void  S4206C2 ::v58(){vfunc_called(this, "_ZN7S4206C23v58Ev");}
void  S4206C2 ::v59(){vfunc_called(this, "_ZN7S4206C23v59Ev");}
void  S4206C2 ::v60(){vfunc_called(this, "_ZN7S4206C23v60Ev");}
void  S4206C2 ::v61(){vfunc_called(this, "_ZN7S4206C23v61Ev");}
void  S4206C2 ::v62(){vfunc_called(this, "_ZN7S4206C23v62Ev");}
void  S4206C2 ::v63(){vfunc_called(this, "_ZN7S4206C23v63Ev");}
void  S4206C2 ::v64(){vfunc_called(this, "_ZN7S4206C23v64Ev");}
void  S4206C2 ::v65(){vfunc_called(this, "_ZN7S4206C23v65Ev");}
void  S4206C2 ::v66(){vfunc_called(this, "_ZN7S4206C23v66Ev");}
void  S4206C2 ::v67(){vfunc_called(this, "_ZN7S4206C23v67Ev");}
void  S4206C2 ::v68(){vfunc_called(this, "_ZN7S4206C23v68Ev");}
void  S4206C2 ::v69(){vfunc_called(this, "_ZN7S4206C23v69Ev");}
void  S4206C2 ::v70(){vfunc_called(this, "_ZN7S4206C23v70Ev");}
void  S4206C2 ::v71(){vfunc_called(this, "_ZN7S4206C23v71Ev");}
void  S4206C2 ::v72(){vfunc_called(this, "_ZN7S4206C23v72Ev");}
void  S4206C2 ::v73(){vfunc_called(this, "_ZN7S4206C23v73Ev");}
void  S4206C2 ::v74(){vfunc_called(this, "_ZN7S4206C23v74Ev");}
void  S4206C2 ::v75(){vfunc_called(this, "_ZN7S4206C23v75Ev");}
void  S4206C2 ::v76(){vfunc_called(this, "_ZN7S4206C23v76Ev");}
void  S4206C2 ::v77(){vfunc_called(this, "_ZN7S4206C23v77Ev");}
void  S4206C2 ::v78(){vfunc_called(this, "_ZN7S4206C23v78Ev");}
void  S4206C2 ::v79(){vfunc_called(this, "_ZN7S4206C23v79Ev");}
void  S4206C2 ::v80(){vfunc_called(this, "_ZN7S4206C23v80Ev");}
void  S4206C2 ::v81(){vfunc_called(this, "_ZN7S4206C23v81Ev");}
void  S4206C2 ::v82(){vfunc_called(this, "_ZN7S4206C23v82Ev");}
void  S4206C2 ::v83(){vfunc_called(this, "_ZN7S4206C23v83Ev");}
void  S4206C2 ::v84(){vfunc_called(this, "_ZN7S4206C23v84Ev");}
void  S4206C2 ::v85(){vfunc_called(this, "_ZN7S4206C23v85Ev");}
void  S4206C2 ::v86(){vfunc_called(this, "_ZN7S4206C23v86Ev");}
void  S4206C2 ::v87(){vfunc_called(this, "_ZN7S4206C23v87Ev");}
void  S4206C2 ::v88(){vfunc_called(this, "_ZN7S4206C23v88Ev");}
void  S4206C2 ::v89(){vfunc_called(this, "_ZN7S4206C23v89Ev");}
void  S4206C2 ::v90(){vfunc_called(this, "_ZN7S4206C23v90Ev");}
void  S4206C2 ::v91(){vfunc_called(this, "_ZN7S4206C23v91Ev");}
void  S4206C2 ::v92(){vfunc_called(this, "_ZN7S4206C23v92Ev");}
void  S4206C2 ::v93(){vfunc_called(this, "_ZN7S4206C23v93Ev");}
void  S4206C2 ::v94(){vfunc_called(this, "_ZN7S4206C23v94Ev");}
void  S4206C2 ::v95(){vfunc_called(this, "_ZN7S4206C23v95Ev");}
void  S4206C2 ::v96(){vfunc_called(this, "_ZN7S4206C23v96Ev");}
void  S4206C2 ::v97(){vfunc_called(this, "_ZN7S4206C23v97Ev");}
void  S4206C2 ::v98(){vfunc_called(this, "_ZN7S4206C23v98Ev");}
void  S4206C2 ::v99(){vfunc_called(this, "_ZN7S4206C23v99Ev");}
void  S4206C2 ::v100(){vfunc_called(this, "_ZN7S4206C24v100Ev");}
void  S4206C2 ::v101(){vfunc_called(this, "_ZN7S4206C24v101Ev");}
void  S4206C2 ::v102(){vfunc_called(this, "_ZN7S4206C24v102Ev");}
void  S4206C2 ::v103(){vfunc_called(this, "_ZN7S4206C24v103Ev");}
void  S4206C2 ::v104(){vfunc_called(this, "_ZN7S4206C24v104Ev");}
void  S4206C2 ::v105(){vfunc_called(this, "_ZN7S4206C24v105Ev");}
void  S4206C2 ::v106(){vfunc_called(this, "_ZN7S4206C24v106Ev");}
void  S4206C2 ::v107(){vfunc_called(this, "_ZN7S4206C24v107Ev");}
void  S4206C2 ::v108(){vfunc_called(this, "_ZN7S4206C24v108Ev");}
void  S4206C2 ::v109(){vfunc_called(this, "_ZN7S4206C24v109Ev");}
void  S4206C2 ::v110(){vfunc_called(this, "_ZN7S4206C24v110Ev");}
S4206C2 ::S4206C2(){ note_ctor("S4206C2", this);} // tgen

static void Test_S4206C2()
{
  extern Class_Descriptor cd_S4206C2;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(105,159)];
    init_test(&cd_S4206C2, buf);
    S4206C2 *dp, &lv = *(dp=new (buf) S4206C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(832,632), "sizeof(S4206C2)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4206C2)");
    check_base_class_offset(lv, (S4206C3*), 0, "S4206C2");
    check_field_offset(lv, s4206c2f0, ABISELECT(64,40), "S4206C2.s4206c2f0");
    check_field_offset(lv, s4206c2f1, ABISELECT(80,56), "S4206C2.s4206c2f1");
    check_field_offset(lv, s4206c2f2, ABISELECT(96,72), "S4206C2.s4206c2f2");
    check_field_offset(lv, s4206c2f3, ABISELECT(112,88), "S4206C2.s4206c2f3");
    check_field_offset(lv, s4206c2f4, ABISELECT(128,104), "S4206C2.s4206c2f4");
    check_field_offset(lv, s4206c2f5, ABISELECT(144,120), "S4206C2.s4206c2f5");
    check_field_offset(lv, s4206c2f6, ABISELECT(208,184), "S4206C2.s4206c2f6");
    check_field_offset(lv, s4206c2f7, ABISELECT(272,248), "S4206C2.s4206c2f7");
    check_field_offset(lv, s4206c2f8, ABISELECT(288,264), "S4206C2.s4206c2f8");
    check_field_offset(lv, s4206c2f9, ABISELECT(304,280), "S4206C2.s4206c2f9");
    check_field_offset(lv, s4206c2f10, ABISELECT(320,296), "S4206C2.s4206c2f10");
    check_field_offset(lv, s4206c2f11, ABISELECT(328,300), "S4206C2.s4206c2f11");
    check_field_offset(lv, s4206c2f12, ABISELECT(344,316), "S4206C2.s4206c2f12");
    check_field_offset(lv, s4206c2f13, ABISELECT(368,332), "S4206C2.s4206c2f13");
    check_field_offset(lv, s4206c2f14, ABISELECT(376,336), "S4206C2.s4206c2f14");
    check_field_offset(lv, s4206c2f15, ABISELECT(432,364), "S4206C2.s4206c2f15");
    set_bf_and_test(lv, s4206c2f16, ABISELECT(448,376), 0, 8, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f16, ABISELECT(448,376), 0, 8, hide_sll(1LL<<7), "S4206C2");
    set_bf_and_test(lv, s4206c2f17, ABISELECT(449,377), 0, 8, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f17, ABISELECT(449,377), 0, 8, hide_sll(1LL<<7), "S4206C2");
    set_bf_and_test(lv, s4206c2f18, ABISELECT(450,378), 0, 16, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f18, ABISELECT(450,378), 0, 16, hide_sll(1LL<<15), "S4206C2");
    set_bf_and_test(lv, s4206c2f19, ABISELECT(452,380), 0, 16, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f19, ABISELECT(452,380), 0, 16, hide_sll(1LL<<15), "S4206C2");
    set_bf_and_test(lv, s4206c2f20, ABISELECT(454,382), 0, 8, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f20, ABISELECT(454,382), 0, 8, hide_sll(1LL<<7), "S4206C2");
    set_bf_and_test(lv, s4206c2f21, ABISELECT(455,383), 0, 8, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f21, ABISELECT(455,383), 0, 8, hide_sll(1LL<<7), "S4206C2");
    set_bf_and_test(lv, s4206c2f22, ABISELECT(456,384), 0, 8, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f22, ABISELECT(456,384), 0, 8, hide_sll(1LL<<7), "S4206C2");
    set_bf_and_test(lv, s4206c2f23, ABISELECT(460,388), 0, 32, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f23, ABISELECT(460,388), 0, 32, hide_sll(1LL<<31), "S4206C2");
    set_bf_and_test(lv, s4206c2f24, ABISELECT(464,392), 0, 8, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f24, ABISELECT(464,392), 0, 8, hide_sll(1LL<<7), "S4206C2");
    set_bf_and_test(lv, s4206c2f25, ABISELECT(465,393), 0, 4, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f25, ABISELECT(465,393), 0, 4, hide_sll(1LL<<3), "S4206C2");
    set_bf_and_test(lv, s4206c2f26, ABISELECT(465,393), 4, 4, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f26, ABISELECT(465,393), 4, 4, hide_sll(1LL<<3), "S4206C2");
    set_bf_and_test(lv, s4206c2f27, ABISELECT(466,394), 0, 4, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f27, ABISELECT(466,394), 0, 4, hide_sll(1LL<<3), "S4206C2");
    set_bf_and_test(lv, s4206c2f28, ABISELECT(466,394), 4, 4, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f28, ABISELECT(466,394), 4, 4, hide_sll(1LL<<3), "S4206C2");
    set_bf_and_test(lv, s4206c2f29, ABISELECT(467,395), 0, 4, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f29, ABISELECT(467,395), 0, 4, hide_sll(1LL<<3), "S4206C2");
    set_bf_and_test(lv, s4206c2f30, ABISELECT(467,395), 4, 4, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f30, ABISELECT(467,395), 4, 4, hide_sll(1LL<<3), "S4206C2");
    set_bf_and_test(lv, s4206c2f31, ABISELECT(468,396), 0, 4, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f31, ABISELECT(468,396), 0, 4, hide_sll(1LL<<3), "S4206C2");
    set_bf_and_test(lv, s4206c2f32, ABISELECT(468,396), 4, 4, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f32, ABISELECT(468,396), 4, 4, hide_sll(1LL<<3), "S4206C2");
    set_bf_and_test(lv, s4206c2f33, ABISELECT(469,397), 0, 4, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f33, ABISELECT(469,397), 0, 4, hide_sll(1LL<<3), "S4206C2");
    set_bf_and_test(lv, s4206c2f34, ABISELECT(469,397), 4, 4, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f34, ABISELECT(469,397), 4, 4, hide_sll(1LL<<3), "S4206C2");
    set_bf_and_test(lv, s4206c2f35, ABISELECT(470,398), 0, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f36, ABISELECT(470,398), 1, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f37, ABISELECT(470,398), 2, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f38, ABISELECT(470,398), 3, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f39, ABISELECT(470,398), 4, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f40, ABISELECT(470,398), 5, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f41, ABISELECT(470,398), 6, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f42, ABISELECT(470,398), 7, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f43, ABISELECT(471,399), 0, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f44, ABISELECT(471,399), 1, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f45, ABISELECT(471,399), 2, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f46, ABISELECT(471,399), 3, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f47, ABISELECT(471,399), 4, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f48, ABISELECT(471,399), 5, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f49, ABISELECT(471,399), 6, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f50, ABISELECT(471,399), 7, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f51, ABISELECT(472,400), 0, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f52, ABISELECT(472,400), 1, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f53, ABISELECT(472,400), 2, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f54, ABISELECT(472,400), 3, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f55, ABISELECT(472,400), 4, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f56, ABISELECT(472,400), 5, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f57, ABISELECT(472,400), 6, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f58, ABISELECT(472,400), 7, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f59, ABISELECT(473,401), 0, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f60, ABISELECT(473,401), 1, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f61, ABISELECT(473,401), 2, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f62, ABISELECT(473,401), 3, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f63, ABISELECT(473,401), 4, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f64, ABISELECT(473,401), 5, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f65, ABISELECT(473,401), 6, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f66, ABISELECT(473,401), 7, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f67, ABISELECT(474,402), 0, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f68, ABISELECT(474,402), 1, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f69, ABISELECT(474,402), 2, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f70, ABISELECT(474,402), 3, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f71, ABISELECT(474,402), 4, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f72, ABISELECT(474,402), 5, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f73, ABISELECT(474,402), 6, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f74, ABISELECT(474,402), 7, 1, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f75, ABISELECT(475,403), 0, 1, 1, "S4206C2");
    check_field_offset(lv, s4206c2f76, ABISELECT(476,404), "S4206C2.s4206c2f76");
    check_field_offset(lv, s4206c2f77, ABISELECT(504,432), "S4206C2.s4206c2f77");
    set_bf_and_test(lv, s4206c2f78, ABISELECT(552,456), 0, 8, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f78, ABISELECT(552,456), 0, 8, hide_sll(1LL<<7), "S4206C2");
    set_bf_and_test(lv, s4206c2f79, ABISELECT(553,457), 0, 8, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f79, ABISELECT(553,457), 0, 8, hide_sll(1LL<<7), "S4206C2");
    set_bf_and_test(lv, s4206c2f80, ABISELECT(554,458), 0, 8, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f80, ABISELECT(554,458), 0, 8, hide_sll(1LL<<7), "S4206C2");
    set_bf_and_test(lv, s4206c2f81, ABISELECT(555,459), 0, 8, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f81, ABISELECT(555,459), 0, 8, hide_sll(1LL<<7), "S4206C2");
    set_bf_and_test(lv, s4206c2f82, ABISELECT(556,460), 0, 8, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f82, ABISELECT(556,460), 0, 8, hide_sll(1LL<<7), "S4206C2");
    set_bf_and_test(lv, s4206c2f83, ABISELECT(557,461), 0, 8, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f83, ABISELECT(557,461), 0, 8, hide_sll(1LL<<7), "S4206C2");
    check_field_offset(lv, s4206c2f84, ABISELECT(560,464), "S4206C2.s4206c2f84");
    check_field_offset(lv, s4206c2f85, ABISELECT(576,476), "S4206C2.s4206c2f85");
    set_bf_and_test(lv, s4206c2f86, ABISELECT(608,492), 0, 8, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f86, ABISELECT(608,492), 0, 8, hide_sll(1LL<<7), "S4206C2");
    set_bf_and_test(lv, s4206c2f87, ABISELECT(609,493), 0, 8, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f87, ABISELECT(609,493), 0, 8, hide_sll(1LL<<7), "S4206C2");
    set_bf_and_test(lv, s4206c2f88, ABISELECT(610,494), 0, 8, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f88, ABISELECT(610,494), 0, 8, hide_sll(1LL<<7), "S4206C2");
    set_bf_and_test(lv, s4206c2f89, ABISELECT(611,495), 0, 8, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f89, ABISELECT(611,495), 0, 8, hide_sll(1LL<<7), "S4206C2");
    set_bf_and_test(lv, s4206c2f90, ABISELECT(612,496), 0, 8, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f90, ABISELECT(612,496), 0, 8, hide_sll(1LL<<7), "S4206C2");
    set_bf_and_test(lv, s4206c2f91, ABISELECT(613,497), 0, 16, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f91, ABISELECT(613,497), 0, 16, hide_sll(1LL<<15), "S4206C2");
    set_bf_and_test(lv, s4206c2f92, ABISELECT(616,500), 0, 16, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f92, ABISELECT(616,500), 0, 16, hide_sll(1LL<<15), "S4206C2");
    set_bf_and_test(lv, s4206c2f93, ABISELECT(618,502), 0, 16, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f93, ABISELECT(618,502), 0, 16, hide_sll(1LL<<15), "S4206C2");
    set_bf_and_test(lv, s4206c2f94, ABISELECT(620,504), 0, 4, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f94, ABISELECT(620,504), 0, 4, hide_sll(1LL<<3), "S4206C2");
    set_bf_and_test(lv, s4206c2f95, ABISELECT(620,504), 4, 4, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f95, ABISELECT(620,504), 4, 4, hide_sll(1LL<<3), "S4206C2");
    set_bf_and_test(lv, s4206c2f96, ABISELECT(621,505), 0, 4, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f96, ABISELECT(621,505), 0, 4, hide_sll(1LL<<3), "S4206C2");
    set_bf_and_test(lv, s4206c2f97, ABISELECT(621,505), 4, 4, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f97, ABISELECT(621,505), 4, 4, hide_sll(1LL<<3), "S4206C2");
    set_bf_and_test(lv, s4206c2f98, ABISELECT(622,506), 0, 4, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f98, ABISELECT(622,506), 0, 4, hide_sll(1LL<<3), "S4206C2");
    set_bf_and_test(lv, s4206c2f99, ABISELECT(622,506), 4, 4, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f99, ABISELECT(622,506), 4, 4, hide_sll(1LL<<3), "S4206C2");
    set_bf_and_test(lv, s4206c2f100, ABISELECT(623,507), 0, 4, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f100, ABISELECT(623,507), 0, 4, hide_sll(1LL<<3), "S4206C2");
    set_bf_and_test(lv, s4206c2f101, ABISELECT(623,507), 4, 4, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f101, ABISELECT(623,507), 4, 4, hide_sll(1LL<<3), "S4206C2");
    set_bf_and_test(lv, s4206c2f102, ABISELECT(624,508), 0, 4, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f102, ABISELECT(624,508), 0, 4, hide_sll(1LL<<3), "S4206C2");
    set_bf_and_test(lv, s4206c2f103, ABISELECT(624,508), 4, 4, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f103, ABISELECT(624,508), 4, 4, hide_sll(1LL<<3), "S4206C2");
    set_bf_and_test(lv, s4206c2f104, ABISELECT(625,509), 0, 4, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f104, ABISELECT(625,509), 0, 4, hide_sll(1LL<<3), "S4206C2");
    set_bf_and_test(lv, s4206c2f105, ABISELECT(625,509), 4, 4, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f105, ABISELECT(625,509), 4, 4, hide_sll(1LL<<3), "S4206C2");
    set_bf_and_test(lv, s4206c2f106, ABISELECT(626,510), 0, 8, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f106, ABISELECT(626,510), 0, 8, hide_sll(1LL<<7), "S4206C2");
    set_bf_and_test(lv, s4206c2f107, ABISELECT(627,511), 0, 8, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f107, ABISELECT(627,511), 0, 8, hide_sll(1LL<<7), "S4206C2");
    set_bf_and_test(lv, s4206c2f108, ABISELECT(628,512), 0, 8, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f108, ABISELECT(628,512), 0, 8, hide_sll(1LL<<7), "S4206C2");
    check_field_offset(lv, s4206c2f109, ABISELECT(632,516), "S4206C2.s4206c2f109");
    check_field_offset(lv, s4206c2f110, ABISELECT(688,544), "S4206C2.s4206c2f110");
    check_field_offset(lv, s4206c2f111, ABISELECT(712,560), "S4206C2.s4206c2f111");
    set_bf_and_test(lv, s4206c2f112, ABISELECT(728,568), 0, 16, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f112, ABISELECT(728,568), 0, 16, hide_sll(1LL<<15), "S4206C2");
    set_bf_and_test(lv, s4206c2f113, ABISELECT(730,570), 0, 16, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f113, ABISELECT(730,570), 0, 16, hide_sll(1LL<<15), "S4206C2");
    check_field_offset(lv, s4206c2f114, ABISELECT(736,572), "S4206C2.s4206c2f114");
    check_field_offset(lv, s4206c2f115, ABISELECT(752,584), "S4206C2.s4206c2f115");
    check_field_offset(lv, s4206c2f116, ABISELECT(776,600), "S4206C2.s4206c2f116");
    check_field_offset(lv, s4206c2f117, ABISELECT(800,616), "S4206C2.s4206c2f117");
    set_bf_and_test(lv, s4206c2f118, ABISELECT(816,624), 0, 24, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f118, ABISELECT(816,624), 0, 24, hide_sll(1LL<<23), "S4206C2");
    set_bf_and_test(lv, s4206c2f119, ABISELECT(819,627), 0, 8, 1, "S4206C2");
    set_bf_and_test(lv, s4206c2f119, ABISELECT(819,627), 0, 8, hide_sll(1LL<<7), "S4206C2");
    check_field_offset(lv, s4206c2f120, ABISELECT(824,628), "S4206C2.s4206c2f120");
    test_class_info(&lv, &cd_S4206C2);
    dp->~S4206C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4206C2(Test_S4206C2, "S4206C2", ABISELECT(832,632));

#else // __cplusplus

extern void _ZN7S4206C2C1Ev();
extern void _ZN7S4206C2D1Ev();
Name_Map name_map_S4206C2[] = {
  NSPAIR(_ZN7S4206C2C1Ev),
  NSPAIR(_ZN7S4206C2D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4206C3;
extern VTBL_ENTRY _ZTI7S4206C3[];
extern  VTBL_ENTRY _ZTV7S4206C3[];
static Base_Class bases_S4206C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4206C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4206C2[];
extern void _ZN7S4206C2D1Ev();
extern void _ZN7S4206C2D0Ev();
extern void _ZN7S4206C33v10Ev();
extern void _ZN7S4206C33v11Ev();
extern void _ZN7S4206C33v12Ev();
extern void _ZN7S4206C33v13Ev();
extern void _ZN7S4206C33v14Ev();
extern void _ZN7S4206C33v15Ev();
extern void _ZN7S4206C33v16Ev();
extern void _ZN7S4206C33v17Ev();
extern void _ZN7S4206C33v18Ev();
extern void _ZN7S4206C33v19Ev();
extern void _ZN7S4206C33v20Ev();
extern void _ZN7S4206C33v21Ev();
extern void _ZN7S4206C33v22Ev();
extern void _ZN7S4206C33v23Ev();
extern void _ZN7S4206C33v24Ev();
extern void _ZN7S4206C33v25Ev();
extern void _ZN7S4206C33v26Ev();
extern void _ZN7S4206C33v27Ev();
extern void _ZN7S4206C33v28Ev();
extern void _ZN7S4206C33v29Ev();
extern void _ZN7S4206C33v30Ev();
extern void _ZN7S4206C33v31Ev();
extern void _ZN7S4206C33v32Ev();
extern void _ZN7S4206C23v33Ev();
extern void _ZN7S4206C23v34Ev();
extern void _ZN7S4206C23v35Ev();
extern void _ZN7S4206C23v36Ev();
extern void _ZN7S4206C23v37Ev();
extern void _ZN7S4206C23v38Ev();
extern void _ZN7S4206C23v39Ev();
extern void _ZN7S4206C23v40Ev();
extern void _ZN7S4206C23v41Ev();
extern void _ZN7S4206C23v42Ev();
extern void _ZN7S4206C23v43Ev();
extern void _ZN7S4206C23v44Ev();
extern void _ZN7S4206C23v45Ev();
extern void _ZN7S4206C23v46Ev();
extern void _ZN7S4206C23v47Ev();
extern void _ZN7S4206C23v48Ev();
extern void _ZN7S4206C23v49Ev();
extern void _ZN7S4206C23v50Ev();
extern void _ZN7S4206C23v51Ev();
extern void _ZN7S4206C23v52Ev();
extern void _ZN7S4206C23v53Ev();
extern void _ZN7S4206C23v54Ev();
extern void _ZN7S4206C23v55Ev();
extern void _ZN7S4206C23v56Ev();
extern void _ZN7S4206C23v57Ev();
extern void _ZN7S4206C23v58Ev();
extern void _ZN7S4206C23v59Ev();
extern void _ZN7S4206C23v60Ev();
extern void _ZN7S4206C23v61Ev();
extern void _ZN7S4206C23v62Ev();
extern void _ZN7S4206C23v63Ev();
extern void _ZN7S4206C23v64Ev();
extern void _ZN7S4206C23v65Ev();
extern void _ZN7S4206C23v66Ev();
extern void _ZN7S4206C23v67Ev();
extern void _ZN7S4206C23v68Ev();
extern void _ZN7S4206C23v69Ev();
extern void _ZN7S4206C23v70Ev();
extern void _ZN7S4206C23v71Ev();
extern void _ZN7S4206C23v72Ev();
extern void _ZN7S4206C23v73Ev();
extern void _ZN7S4206C23v74Ev();
extern void _ZN7S4206C23v75Ev();
extern void _ZN7S4206C23v76Ev();
extern void _ZN7S4206C23v77Ev();
extern void _ZN7S4206C23v78Ev();
extern void _ZN7S4206C23v79Ev();
extern void _ZN7S4206C23v80Ev();
extern void _ZN7S4206C23v81Ev();
extern void _ZN7S4206C23v82Ev();
extern void _ZN7S4206C23v83Ev();
extern void _ZN7S4206C23v84Ev();
extern void _ZN7S4206C23v85Ev();
extern void _ZN7S4206C23v86Ev();
extern void _ZN7S4206C23v87Ev();
extern void _ZN7S4206C23v88Ev();
extern void _ZN7S4206C23v89Ev();
extern void _ZN7S4206C23v90Ev();
extern void _ZN7S4206C23v91Ev();
extern void _ZN7S4206C23v92Ev();
extern void _ZN7S4206C23v93Ev();
extern void _ZN7S4206C23v94Ev();
extern void _ZN7S4206C23v95Ev();
extern void _ZN7S4206C23v96Ev();
extern void _ZN7S4206C23v97Ev();
extern void _ZN7S4206C23v98Ev();
extern void _ZN7S4206C23v99Ev();
extern void _ZN7S4206C24v100Ev();
extern void _ZN7S4206C24v101Ev();
extern void _ZN7S4206C24v102Ev();
extern void _ZN7S4206C24v103Ev();
extern void _ZN7S4206C24v104Ev();
extern void _ZN7S4206C24v105Ev();
extern void _ZN7S4206C24v106Ev();
extern void _ZN7S4206C24v107Ev();
extern void _ZN7S4206C24v108Ev();
extern void _ZN7S4206C24v109Ev();
extern void _ZN7S4206C24v110Ev();
static  VTBL_ENTRY vtc_S4206C2[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4206C2[0]),
  (VTBL_ENTRY)&_ZN7S4206C2D1Ev,
  (VTBL_ENTRY)&_ZN7S4206C2D0Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v10Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v11Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v12Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v13Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v14Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v15Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v16Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v17Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v18Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v19Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v20Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v21Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v22Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v23Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v24Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v25Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v26Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v27Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v28Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v29Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v30Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v31Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v32Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v33Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v34Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v35Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v36Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v37Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v38Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v39Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v40Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v41Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v42Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v43Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v44Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v45Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v46Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v47Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v48Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v49Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v50Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v51Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v52Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v53Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v54Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v55Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v56Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v57Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v58Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v59Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v60Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v61Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v62Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v63Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v64Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v65Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v66Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v67Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v68Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v69Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v70Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v71Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v72Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v73Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v74Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v75Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v76Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v77Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v78Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v79Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v80Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v81Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v82Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v83Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v84Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v85Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v86Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v87Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v88Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v89Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v90Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v91Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v92Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v93Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v94Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v95Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v96Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v97Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v98Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v99Ev,
  (VTBL_ENTRY)&_ZN7S4206C24v100Ev,
  (VTBL_ENTRY)&_ZN7S4206C24v101Ev,
  (VTBL_ENTRY)&_ZN7S4206C24v102Ev,
  (VTBL_ENTRY)&_ZN7S4206C24v103Ev,
  (VTBL_ENTRY)&_ZN7S4206C24v104Ev,
  (VTBL_ENTRY)&_ZN7S4206C24v105Ev,
  (VTBL_ENTRY)&_ZN7S4206C24v106Ev,
  (VTBL_ENTRY)&_ZN7S4206C24v107Ev,
  (VTBL_ENTRY)&_ZN7S4206C24v108Ev,
  (VTBL_ENTRY)&_ZN7S4206C24v109Ev,
  (VTBL_ENTRY)&_ZN7S4206C24v110Ev,
};
extern VTBL_ENTRY _ZTI7S4206C2[];
extern  VTBL_ENTRY _ZTV7S4206C2[];
Class_Descriptor cd_S4206C2 = {  "S4206C2", // class name
  bases_S4206C2, 1,
  &(vtc_S4206C2[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(832,632), // object size
  NSPAIRA(_ZTI7S4206C2),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S4206C2),105, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  1, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4206C40  {
  ::S4206C36_nt s4206c40f0;
  __tsi64 s4206c40f1;
  void  mf4206c40(); // _ZN8S4206C409mf4206c40Ev
};
//SIG(-1 S4206C40) C1{ m FC2{ m Fp Fi[2] FC3{ m}} FL}


void  S4206C40 ::mf4206c40(){}

static void Test_S4206C40()
{
  {
    init_simple_test("S4206C40");
    S4206C40 lv;
    check2(sizeof(lv), ABISELECT(32,24), "sizeof(S4206C40)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4206C40)");
    check_field_offset(lv, s4206c40f0, 0, "S4206C40.s4206c40f0");
    check_field_offset(lv, s4206c40f1, ABISELECT(24,16), "S4206C40.s4206c40f1");
  }
}
static Arrange_To_Call_Me vS4206C40(Test_S4206C40, "S4206C40", ABISELECT(32,24));

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4206C43  {
  ::S2440C18_nt s4206c43f0;
  int s4206c43f1[2];
};
//SIG(1 S4206C43) C1{ FC2{ m FC3{ m FC4{ m FL[2]}} FC3 FC3 FC3} Fi[2]}



static void Test_S4206C43()
{
  {
    init_simple_test("S4206C43");
    S4206C43 lv;
    check2(sizeof(lv), 72, "sizeof(S4206C43)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4206C43)");
    check_field_offset(lv, s4206c43f0, 0, "S4206C43.s4206c43f0");
    check_field_offset(lv, s4206c43f1, 64, "S4206C43.s4206c43f1");
  }
}
static Arrange_To_Call_Me vS4206C43(Test_S4206C43, "S4206C43", 72);

#else // __cplusplus

#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S4206C1  : S4206C2 {
  int s4206c1f0[4];
  char s4206c1f1[2];
  ::S2440C20_nt s4206c1f2;
  int s4206c1f3[6];
  ::S4206C40 s4206c1f4;
  char s4206c1f5;
  int s4206c1f6[3];
  ::S4206C43 s4206c1f7[10];
  virtual  ~S4206C1(); // _ZN7S4206C1D1Ev
  virtual void  v1(); // _ZN7S4206C12v1Ev
  virtual void  v2(); // _ZN7S4206C12v2Ev
  virtual void  v3(); // _ZN7S4206C12v3Ev
  virtual void  v4(); // _ZN7S4206C12v4Ev
  virtual void  v5(); // _ZN7S4206C12v5Ev
  virtual void  v6(); // _ZN7S4206C12v6Ev
  virtual void  v7(); // _ZN7S4206C12v7Ev
  virtual void  v8(); // _ZN7S4206C12v8Ev
  virtual void  v9(); // _ZN7S4206C12v9Ev
  S4206C1(); // tgen
};
//SIG(1 S4206C1) C1{ BC2{ BC3{ vd v10 v11 v12 v13 v14 v15 v16 v17 v18 v19 v20 v21 v22 v23 v24 v25 v26 v27 v28 v29 v30 v31 v32 Fp Fi FC4{ BC5{ m Fp Fi FC6{ m} FC7{ m}}} FC8{ BC9{ m Fp Fi FC10{ m} FC10}} Fi} vd v33 v34 v35 v36 v37 v38 v39 v40 v41 v42 v43 v44 v45 v46 v47 v48 v49 v50 v51 v52 v53 v54 v55 v56 v57 v58 v59 v60 v61 v62 v63 v64 v65 v66 v67 v68 v69 v70 v71 v72 v73 v74 v75 v76 v77 v78 v79 v80 v81 v82 v83 v84 v85 v86 v87 v88 v89 v90 v91 v92 v93 v94 v95 v96 v97 v98 v99 v100 v101 v102 v103 v104 v105 v106 v107 v108 v109 v110 FC11{ m FC12{ m FL[2]}} FC11 FC11 FC13{ m FC12} FC14{ m FC11} FC15{ m FC11 FC11 FC11 FC11} FC15 FC11 FC11 FC11 Fp FC14 FC16{ m FC17{ m Fp Fi FC18{ m}} Fi} Fi Fp[7] FC5 Fi:8 Fi:8 Fi:16 Fi:16 Fi:8 Fi:8 Fi:8 Fi:32 Fi:8 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fc:1 Fi[7] Fp[6] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 FC19{ BC20{ m Fp Fi FC18 FC6}} Fp[4] Fi:8 Fi:8 Fi:8 Fi:8 Fi:8 Fi:16 Fi:16 Fi:16 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:4 Fi:8 Fi:8 Fi:8 Fp[7] FC21{ m Fp Fi[2] FC22{ m}} Fp[2] Fi:16 Fi:16 FC19 FC23{ m Fp Fi[2] FC7} FC24{ m Fp Fi[2] FC22} Fp[2] Fi:24 Fi:8 Fp} vd v1 v2 v3 v4 v5 v6 v7 v8 v9 Fi[4] Fc[2] FC17 Fi[6] FC25{ m FC24 FL} Fc Fi[3] FC26{ FC15 Fi[2]}[10]}


 S4206C1 ::~S4206C1(){ note_dtor("S4206C1", this);}
void  S4206C1 ::v1(){vfunc_called(this, "_ZN7S4206C12v1Ev");}
void  S4206C1 ::v2(){vfunc_called(this, "_ZN7S4206C12v2Ev");}
void  S4206C1 ::v3(){vfunc_called(this, "_ZN7S4206C12v3Ev");}
void  S4206C1 ::v4(){vfunc_called(this, "_ZN7S4206C12v4Ev");}
void  S4206C1 ::v5(){vfunc_called(this, "_ZN7S4206C12v5Ev");}
void  S4206C1 ::v6(){vfunc_called(this, "_ZN7S4206C12v6Ev");}
void  S4206C1 ::v7(){vfunc_called(this, "_ZN7S4206C12v7Ev");}
void  S4206C1 ::v8(){vfunc_called(this, "_ZN7S4206C12v8Ev");}
void  S4206C1 ::v9(){vfunc_called(this, "_ZN7S4206C12v9Ev");}
S4206C1 ::S4206C1(){ note_ctor("S4206C1", this);} // tgen

static void Test_S4206C1()
{
  extern Class_Descriptor cd_S4206C1;
  void *lvp;
  {
    ABISELECT(double,int) buf[ABISELECT(209,363)];
    init_test(&cd_S4206C1, buf);
    S4206C1 *dp, &lv = *(dp=new (buf) S4206C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1664,1448), "sizeof(S4206C1)");
    check2(__alignof__(lv), ABISELECT(8,4), "__alignof__(S4206C1)");
    check_base_class_offset(lv, (S4206C3*)(S4206C2*), 0, "S4206C1");
    check_base_class_offset(lv, (S4206C2*), 0, "S4206C1");
    check_field_offset(lv, s4206c1f0, ABISELECT(832,632), "S4206C1.s4206c1f0");
    check_field_offset(lv, s4206c1f1, ABISELECT(848,648), "S4206C1.s4206c1f1");
    check_field_offset(lv, s4206c1f2, ABISELECT(856,652), "S4206C1.s4206c1f2");
    check_field_offset(lv, s4206c1f3, ABISELECT(872,664), "S4206C1.s4206c1f3");
    check_field_offset(lv, s4206c1f4, ABISELECT(896,688), "S4206C1.s4206c1f4");
    check_field_offset(lv, s4206c1f5, ABISELECT(928,712), "S4206C1.s4206c1f5");
    check_field_offset(lv, s4206c1f6, ABISELECT(932,716), "S4206C1.s4206c1f6");
    check_field_offset(lv, s4206c1f7, ABISELECT(944,728), "S4206C1.s4206c1f7");
    test_class_info(&lv, &cd_S4206C1);
    dp->~S4206C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS4206C1(Test_S4206C1, "S4206C1", ABISELECT(1664,1448));

#else // __cplusplus

extern void _ZN7S4206C1C1Ev();
extern void _ZN7S4206C1D1Ev();
Name_Map name_map_S4206C1[] = {
  NSPAIR(_ZN7S4206C1C1Ev),
  NSPAIR(_ZN7S4206C1D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S4206C3;
extern VTBL_ENTRY _ZTI7S4206C3[];
extern  VTBL_ENTRY _ZTV7S4206C3[];
extern Class_Descriptor cd_S4206C2;
extern VTBL_ENTRY _ZTI7S4206C2[];
extern  VTBL_ENTRY _ZTV7S4206C2[];
static Base_Class bases_S4206C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S4206C3,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    1, //immediately_derived
  0, 0},
  {&cd_S4206C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S4206C1[];
extern void _ZN7S4206C1D1Ev();
extern void _ZN7S4206C1D0Ev();
extern void _ZN7S4206C33v10Ev();
extern void _ZN7S4206C33v11Ev();
extern void _ZN7S4206C33v12Ev();
extern void _ZN7S4206C33v13Ev();
extern void _ZN7S4206C33v14Ev();
extern void _ZN7S4206C33v15Ev();
extern void _ZN7S4206C33v16Ev();
extern void _ZN7S4206C33v17Ev();
extern void _ZN7S4206C33v18Ev();
extern void _ZN7S4206C33v19Ev();
extern void _ZN7S4206C33v20Ev();
extern void _ZN7S4206C33v21Ev();
extern void _ZN7S4206C33v22Ev();
extern void _ZN7S4206C33v23Ev();
extern void _ZN7S4206C33v24Ev();
extern void _ZN7S4206C33v25Ev();
extern void _ZN7S4206C33v26Ev();
extern void _ZN7S4206C33v27Ev();
extern void _ZN7S4206C33v28Ev();
extern void _ZN7S4206C33v29Ev();
extern void _ZN7S4206C33v30Ev();
extern void _ZN7S4206C33v31Ev();
extern void _ZN7S4206C33v32Ev();
extern void _ZN7S4206C23v33Ev();
extern void _ZN7S4206C23v34Ev();
extern void _ZN7S4206C23v35Ev();
extern void _ZN7S4206C23v36Ev();
extern void _ZN7S4206C23v37Ev();
extern void _ZN7S4206C23v38Ev();
extern void _ZN7S4206C23v39Ev();
extern void _ZN7S4206C23v40Ev();
extern void _ZN7S4206C23v41Ev();
extern void _ZN7S4206C23v42Ev();
extern void _ZN7S4206C23v43Ev();
extern void _ZN7S4206C23v44Ev();
extern void _ZN7S4206C23v45Ev();
extern void _ZN7S4206C23v46Ev();
extern void _ZN7S4206C23v47Ev();
extern void _ZN7S4206C23v48Ev();
extern void _ZN7S4206C23v49Ev();
extern void _ZN7S4206C23v50Ev();
extern void _ZN7S4206C23v51Ev();
extern void _ZN7S4206C23v52Ev();
extern void _ZN7S4206C23v53Ev();
extern void _ZN7S4206C23v54Ev();
extern void _ZN7S4206C23v55Ev();
extern void _ZN7S4206C23v56Ev();
extern void _ZN7S4206C23v57Ev();
extern void _ZN7S4206C23v58Ev();
extern void _ZN7S4206C23v59Ev();
extern void _ZN7S4206C23v60Ev();
extern void _ZN7S4206C23v61Ev();
extern void _ZN7S4206C23v62Ev();
extern void _ZN7S4206C23v63Ev();
extern void _ZN7S4206C23v64Ev();
extern void _ZN7S4206C23v65Ev();
extern void _ZN7S4206C23v66Ev();
extern void _ZN7S4206C23v67Ev();
extern void _ZN7S4206C23v68Ev();
extern void _ZN7S4206C23v69Ev();
extern void _ZN7S4206C23v70Ev();
extern void _ZN7S4206C23v71Ev();
extern void _ZN7S4206C23v72Ev();
extern void _ZN7S4206C23v73Ev();
extern void _ZN7S4206C23v74Ev();
extern void _ZN7S4206C23v75Ev();
extern void _ZN7S4206C23v76Ev();
extern void _ZN7S4206C23v77Ev();
extern void _ZN7S4206C23v78Ev();
extern void _ZN7S4206C23v79Ev();
extern void _ZN7S4206C23v80Ev();
extern void _ZN7S4206C23v81Ev();
extern void _ZN7S4206C23v82Ev();
extern void _ZN7S4206C23v83Ev();
extern void _ZN7S4206C23v84Ev();
extern void _ZN7S4206C23v85Ev();
extern void _ZN7S4206C23v86Ev();
extern void _ZN7S4206C23v87Ev();
extern void _ZN7S4206C23v88Ev();
extern void _ZN7S4206C23v89Ev();
extern void _ZN7S4206C23v90Ev();
extern void _ZN7S4206C23v91Ev();
extern void _ZN7S4206C23v92Ev();
extern void _ZN7S4206C23v93Ev();
extern void _ZN7S4206C23v94Ev();
extern void _ZN7S4206C23v95Ev();
extern void _ZN7S4206C23v96Ev();
extern void _ZN7S4206C23v97Ev();
extern void _ZN7S4206C23v98Ev();
extern void _ZN7S4206C23v99Ev();
extern void _ZN7S4206C24v100Ev();
extern void _ZN7S4206C24v101Ev();
extern void _ZN7S4206C24v102Ev();
extern void _ZN7S4206C24v103Ev();
extern void _ZN7S4206C24v104Ev();
extern void _ZN7S4206C24v105Ev();
extern void _ZN7S4206C24v106Ev();
extern void _ZN7S4206C24v107Ev();
extern void _ZN7S4206C24v108Ev();
extern void _ZN7S4206C24v109Ev();
extern void _ZN7S4206C24v110Ev();
extern void _ZN7S4206C12v1Ev();
extern void _ZN7S4206C12v2Ev();
extern void _ZN7S4206C12v3Ev();
extern void _ZN7S4206C12v4Ev();
extern void _ZN7S4206C12v5Ev();
extern void _ZN7S4206C12v6Ev();
extern void _ZN7S4206C12v7Ev();
extern void _ZN7S4206C12v8Ev();
extern void _ZN7S4206C12v9Ev();
static  VTBL_ENTRY vtc_S4206C1[] = {
  0,
  (VTBL_ENTRY)&(_ZTI7S4206C1[0]),
  (VTBL_ENTRY)&_ZN7S4206C1D1Ev,
  (VTBL_ENTRY)&_ZN7S4206C1D0Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v10Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v11Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v12Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v13Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v14Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v15Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v16Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v17Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v18Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v19Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v20Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v21Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v22Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v23Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v24Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v25Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v26Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v27Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v28Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v29Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v30Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v31Ev,
  (VTBL_ENTRY)&_ZN7S4206C33v32Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v33Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v34Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v35Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v36Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v37Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v38Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v39Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v40Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v41Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v42Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v43Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v44Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v45Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v46Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v47Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v48Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v49Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v50Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v51Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v52Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v53Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v54Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v55Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v56Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v57Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v58Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v59Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v60Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v61Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v62Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v63Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v64Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v65Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v66Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v67Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v68Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v69Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v70Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v71Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v72Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v73Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v74Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v75Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v76Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v77Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v78Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v79Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v80Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v81Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v82Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v83Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v84Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v85Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v86Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v87Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v88Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v89Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v90Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v91Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v92Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v93Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v94Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v95Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v96Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v97Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v98Ev,
  (VTBL_ENTRY)&_ZN7S4206C23v99Ev,
  (VTBL_ENTRY)&_ZN7S4206C24v100Ev,
  (VTBL_ENTRY)&_ZN7S4206C24v101Ev,
  (VTBL_ENTRY)&_ZN7S4206C24v102Ev,
  (VTBL_ENTRY)&_ZN7S4206C24v103Ev,
  (VTBL_ENTRY)&_ZN7S4206C24v104Ev,
  (VTBL_ENTRY)&_ZN7S4206C24v105Ev,
  (VTBL_ENTRY)&_ZN7S4206C24v106Ev,
  (VTBL_ENTRY)&_ZN7S4206C24v107Ev,
  (VTBL_ENTRY)&_ZN7S4206C24v108Ev,
  (VTBL_ENTRY)&_ZN7S4206C24v109Ev,
  (VTBL_ENTRY)&_ZN7S4206C24v110Ev,
  (VTBL_ENTRY)&_ZN7S4206C12v1Ev,
  (VTBL_ENTRY)&_ZN7S4206C12v2Ev,
  (VTBL_ENTRY)&_ZN7S4206C12v3Ev,
  (VTBL_ENTRY)&_ZN7S4206C12v4Ev,
  (VTBL_ENTRY)&_ZN7S4206C12v5Ev,
  (VTBL_ENTRY)&_ZN7S4206C12v6Ev,
  (VTBL_ENTRY)&_ZN7S4206C12v7Ev,
  (VTBL_ENTRY)&_ZN7S4206C12v8Ev,
  (VTBL_ENTRY)&_ZN7S4206C12v9Ev,
};
extern VTBL_ENTRY _ZTI7S4206C1[];
extern  VTBL_ENTRY _ZTV7S4206C1[];
Class_Descriptor cd_S4206C1 = {  "S4206C1", // class name
  bases_S4206C1, 2,
  &(vtc_S4206C1[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(1664,1448), // object size
  NSPAIRA(_ZTI7S4206C1),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S4206C1),114, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  2, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S2489C4  {
  long double s2489c4f0;
  __tsi64 s2489c4f1;
  int s2489c4f2;
  long s2489c4f3;
  char s2489c4f4;
  int s2489c4f5[7];
  long double s2489c4f6;
  void *s2489c4f7;
  void *s2489c4f8[10];
  __tsi64 s2489c4f9;
  void *s2489c4f10;
  __tsi64 s2489c4f11;
  int s2489c4f12;
  void  mf2489c4(); // _ZN7S2489C48mf2489c4Ev
};
//SIG(1 S2489C4) U1{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi}

#endif // __cplusplus
#ifdef __cplusplus

struct  S2489C3  {
  char s2489c3f0;
  int s2489c3f1;
  __tsi64 s2489c3f2;
  ::S2489C4 s2489c3f3;
  short s2489c3f4;
  __tsi64 s2489c3f5:12;
  __tsi64 s2489c3f6;
  int s2489c3f7;
  void  mf2489c3(); // _ZN7S2489C38mf2489c3Ev
};
//SIG(-1 S2489C3) C1{ m Fc Fi FL FU2{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi}


void  S2489C3 ::mf2489c3(){}

static void Test_S2489C3()
{
  {
    init_simple_test("S2489C3");
    static S2489C3 lv;
    check2(sizeof(lv), ABISELECT(128,72), "sizeof(S2489C3)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2489C3)");
    check_field_offset(lv, s2489c3f0, 0, "S2489C3.s2489c3f0");
    check_field_offset(lv, s2489c3f1, 4, "S2489C3.s2489c3f1");
    check_field_offset(lv, s2489c3f2, 8, "S2489C3.s2489c3f2");
    check_field_offset(lv, s2489c3f3, 16, "S2489C3.s2489c3f3");
    check_field_offset(lv, s2489c3f4, ABISELECT(96,56), "S2489C3.s2489c3f4");
    set_bf_and_test(lv, s2489c3f5, ABISELECT(98,58), 0, 12, 1, "S2489C3");
    set_bf_and_test(lv, s2489c3f5, ABISELECT(98,58), 0, 12, hide_sll(1LL<<11), "S2489C3");
    check_field_offset(lv, s2489c3f6, ABISELECT(104,60), "S2489C3.s2489c3f6");
    check_field_offset(lv, s2489c3f7, ABISELECT(112,68), "S2489C3.s2489c3f7");
  }
}
static Arrange_To_Call_Me vS2489C3(Test_S2489C3, "S2489C3", ABISELECT(128,72));

#else // __cplusplus

extern VTBL_ENTRY _ZTI7S2489C3[];
VTBL_ENTRY *P__ZTI7S2489C3 = _ZTI7S2489C3; 
Class_Descriptor cd_S2489C3 = {  "S2489C3", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  ABISELECT(128,72), // object size
  NSPAIRA(_ZTI7S2489C3),ABISELECT(16,8), //typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S2489C7  {
  __tsi64 s2489c7f0;
  int s2489c7f1;
  __tsi64 s2489c7f2;
  void *s2489c7f3[7];
  __tsi64 s2489c7f4:12;
  void  mf2489c7(); // _ZN7S2489C78mf2489c7Ev
};
//SIG(1 S2489C7) U1{ m FL Fi FL Fp[7] FL:12}

#endif // __cplusplus
#ifdef __cplusplus

struct  S2489C6  : virtual S2489C3 {
  void *s2489c6f0;
  void *s2489c6f1;
  int s2489c6f2;
  int s2489c6f3;
  ::S2489C7 s2489c6f4;
  __tsi64  :0;
  long double s2489c6f6;
  ::S2489C7 s2489c6f7;
  void *s2489c6f8;
  __tsi64 s2489c6f9:3;
  ::S2489C3 s2489c6f10;
  __tsi64 s2489c6f11;
  ::S2489C7 s2489c6f12;
  virtual void  v1(); // _ZN7S2489C62v1Ev
  virtual void  v2(); // _ZN7S2489C62v2Ev
  ~S2489C6(); // tgen
  S2489C6(); // tgen
};
//SIG(-1 S2489C6) C1{ VBC2{ m Fc Fi FL FU3{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} v1 v2 Fp Fp Fi Fi FU4{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU4 Fp FL:3 FC2 FL FU4}


void  S2489C6 ::v1(){vfunc_called(this, "_ZN7S2489C62v1Ev");}
void  S2489C6 ::v2(){vfunc_called(this, "_ZN7S2489C62v2Ev");}
S2489C6 ::~S2489C6(){ note_dtor("S2489C6", this);} // tgen
S2489C6 ::S2489C6(){ note_ctor("S2489C6", this);} // tgen

static void Test_S2489C6()
{
  extern Class_Descriptor cd_S2489C6;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(33,70)];
    init_test(&cd_S2489C6, buf);
    S2489C6 *dp, &lv = *(dp=new (buf) S2489C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(512,276), "sizeof(S2489C6)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2489C6)");
    check_base_class_offset(lv, (S2489C3*), ABISELECT(384,204), "S2489C6");
    check_field_offset(lv, s2489c6f0, ABISELECT(8,4), "S2489C6.s2489c6f0");
    check_field_offset(lv, s2489c6f1, ABISELECT(16,8), "S2489C6.s2489c6f1");
    check_field_offset(lv, s2489c6f2, ABISELECT(24,12), "S2489C6.s2489c6f2");
    check_field_offset(lv, s2489c6f3, ABISELECT(28,16), "S2489C6.s2489c6f3");
    check_field_offset(lv, s2489c6f4, ABISELECT(32,20), "S2489C6.s2489c6f4");
    check_field_offset(lv, s2489c6f6, ABISELECT(96,48), "S2489C6.s2489c6f6");
    check_field_offset(lv, s2489c6f7, ABISELECT(112,60), "S2489C6.s2489c6f7");
    check_field_offset(lv, s2489c6f8, ABISELECT(168,88), "S2489C6.s2489c6f8");
    set_bf_and_test(lv, s2489c6f9, ABISELECT(176,92), 0, 3, 1, "S2489C6");
    set_bf_and_test(lv, s2489c6f9, ABISELECT(176,92), 0, 3, hide_sll(1LL<<2), "S2489C6");
    check_field_offset(lv, s2489c6f10, ABISELECT(192,96), "S2489C6.s2489c6f10");
    check_field_offset(lv, s2489c6f11, ABISELECT(320,168), "S2489C6.s2489c6f11");
    check_field_offset(lv, s2489c6f12, ABISELECT(328,176), "S2489C6.s2489c6f12");
    test_class_info(&lv, &cd_S2489C6);
    dp->~S2489C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2489C6(Test_S2489C6, "S2489C6", ABISELECT(512,276));

#else // __cplusplus

extern void _ZN7S2489C6C1Ev();
extern void _ZN7S2489C6D1Ev();
Name_Map name_map_S2489C6[] = {
  NSPAIR(_ZN7S2489C6C1Ev),
  NSPAIR(_ZN7S2489C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
static Base_Class bases_S2489C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C3,    ABISELECT(384,204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S2489C6[];
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY vtc_S2489C6[] = {
  ABISELECT(384,204),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern VTBL_ENTRY _ZTV7S2489C6[];
static  VTT_ENTRY vtt_S2489C6[] = {
  {&(_ZTV7S2489C6[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
Class_Descriptor cd_S2489C6 = {  "S2489C6", // class name
  bases_S2489C6, 1,
  &(vtc_S2489C6[0]), // expected_vtbl_contents
  &(vtt_S2489C6[0]), // expected_vtt_contents
  ABISELECT(512,276), // object size
  NSPAIRA(_ZTI7S2489C6),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7S2489C6),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S2489C6),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2489C5  : S2489C3 , S2489C6 {
  void *s2489c5f0;
  long double s2489c5f1;
  ::S2489C3 s2489c5f2[7];
  long double s2489c5f3;
  ::S2489C4 s2489c5f4;
  short s2489c5f5;
  __tsi64 s2489c5f6;
  __tsi64 s2489c5f7;
  virtual void  v3(); // _ZN7S2489C52v3Ev
  ~S2489C5(); // tgen
  S2489C5(); // tgen
};
//SIG(-1 S2489C5) C1{ BC2{ m Fc Fi FL FU3{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} BC4{ VBC2 v2 v3 Fp Fp Fi Fi FU5{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU5 Fp FL:3 FC2 FL FU5} v1 Fp FD FC2[7] FD FU3 Fs FL FL}


void  S2489C5 ::v3(){vfunc_called(this, "_ZN7S2489C52v3Ev");}
S2489C5 ::~S2489C5(){ note_dtor("S2489C5", this);} // tgen
S2489C5 ::S2489C5(){ note_ctor("S2489C5", this);} // tgen

static void Test_S2489C5()
{
  extern Class_Descriptor cd_S2489C5;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(107,236)];
    init_test(&cd_S2489C5, buf);
    S2489C5 *dp, &lv = *(dp=new (buf) S2489C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1696,940), "sizeof(S2489C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2489C5)");
    /*is_ambiguous_... S2489C5::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*), ABISELECT(384,204), "S2489C5");
    check_base_class_offset(lv, (S2489C3*)(S2489C6*), ABISELECT(1568,868), "S2489C5");
    check_base_class_offset(lv, (S2489C6*), 0, "S2489C5");
    check_field_offset(lv, s2489c5f0, ABISELECT(512,276), "S2489C5.s2489c5f0");
    check_field_offset(lv, s2489c5f1, ABISELECT(528,280), "S2489C5.s2489c5f1");
    check_field_offset(lv, s2489c5f2, ABISELECT(544,292), "S2489C5.s2489c5f2");
    check_field_offset(lv, s2489c5f3, ABISELECT(1440,796), "S2489C5.s2489c5f3");
    check_field_offset(lv, s2489c5f4, ABISELECT(1456,808), "S2489C5.s2489c5f4");
    check_field_offset(lv, s2489c5f5, ABISELECT(1536,848), "S2489C5.s2489c5f5");
    check_field_offset(lv, s2489c5f6, ABISELECT(1544,852), "S2489C5.s2489c5f6");
    check_field_offset(lv, s2489c5f7, ABISELECT(1552,860), "S2489C5.s2489c5f7");
    test_class_info(&lv, &cd_S2489C5);
    dp->~S2489C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2489C5(Test_S2489C5, "S2489C5", ABISELECT(1696,940));

#else // __cplusplus

extern void _ZN7S2489C5C1Ev();
extern void _ZN7S2489C5D1Ev();
Name_Map name_map_S2489C5[] = {
  NSPAIR(_ZN7S2489C5C1Ev),
  NSPAIR(_ZN7S2489C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
static Base_Class bases_S2489C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C3,    ABISELECT(384,204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2489C3,    ABISELECT(1568,868), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S2489C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2489C5[];
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY vtc_S2489C5[] = {
  ABISELECT(1568,868),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C5[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern VTBL_ENTRY _ZTV7S2489C5[];
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C5[] = {
  ABISELECT(1568,868),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
static  VTT_ENTRY vtt_S2489C5[] = {
  {&(_ZTV7S2489C5[3]),  3,6},
  {&(_tg__ZTV7S2489C6__7S2489C5[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7S2489C5[];
extern  VTBL_ENTRY _ZTV7S2489C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C5[];
Class_Descriptor cd_S2489C5 = {  "S2489C5", // class name
  bases_S2489C5, 3,
  &(vtc_S2489C5[0]), // expected_vtbl_contents
  &(vtt_S2489C5[0]), // expected_vtt_contents
  ABISELECT(1696,940), // object size
  NSPAIRA(_ZTI7S2489C5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2489C5),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S2489C5),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2489C8  : virtual S2489C3 , virtual S2489C6 {
  __tsi64 s2489c8f0;
  __tsi64 s2489c8f1;
  __tsi64 s2489c8f2;
  __tsi64 s2489c8f3;
  int s2489c8f4;
  ::S2489C7 s2489c8f5;
  char s2489c8f6[10];
  int s2489c8f7;
  virtual  ~S2489C8(); // _ZN7S2489C8D2Ev
  virtual void  v4(); // _ZN7S2489C82v4Ev
  S2489C8(); // tgen
};
//SIG(-1 S2489C8) C1{ VBC2{ m Fc Fi FL FU3{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} VBC4{ VBC2 v2 v3 Fp Fp Fi Fi FU5{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU5 Fp FL:3 FC2 FL FU5} vd v1 FL FL FL FL Fi FU5 Fc[10] Fi}


 S2489C8 ::~S2489C8(){ note_dtor("S2489C8", this);}
void  S2489C8 ::v4(){vfunc_called(this, "_ZN7S2489C82v4Ev");}
S2489C8 ::S2489C8(){ note_ctor("S2489C8", this);} // tgen

static void Test_S2489C8()
{
  extern Class_Descriptor cd_S2489C8;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(41,91)];
    init_test(&cd_S2489C8, buf);
    S2489C8 *dp, &lv = *(dp=new (buf) S2489C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(640,360), "sizeof(S2489C8)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2489C8)");
    check_base_class_offset(lv, (S2489C3*), ABISELECT(128,84), "S2489C8");
    check_base_class_offset(lv, (S2489C3*)(S2489C6*), ABISELECT(128,84), "S2489C8");
    check_base_class_offset(lv, (S2489C6*), ABISELECT(256,156), "S2489C8");
    check_field_offset(lv, s2489c8f0, ABISELECT(8,4), "S2489C8.s2489c8f0");
    check_field_offset(lv, s2489c8f1, ABISELECT(16,12), "S2489C8.s2489c8f1");
    check_field_offset(lv, s2489c8f2, ABISELECT(24,20), "S2489C8.s2489c8f2");
    check_field_offset(lv, s2489c8f3, ABISELECT(32,28), "S2489C8.s2489c8f3");
    check_field_offset(lv, s2489c8f4, ABISELECT(40,36), "S2489C8.s2489c8f4");
    check_field_offset(lv, s2489c8f5, ABISELECT(48,40), "S2489C8.s2489c8f5");
    check_field_offset(lv, s2489c8f6, ABISELECT(104,68), "S2489C8.s2489c8f6");
    check_field_offset(lv, s2489c8f7, ABISELECT(116,80), "S2489C8.s2489c8f7");
    test_class_info(&lv, &cd_S2489C8);
    dp->~S2489C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2489C8(Test_S2489C8, "S2489C8", ABISELECT(640,360));

#else // __cplusplus

extern void _ZN7S2489C8C1Ev();
extern void _ZN7S2489C8D2Ev();
Name_Map name_map_S2489C8[] = {
  NSPAIR(_ZN7S2489C8C1Ev),
  NSPAIR(_ZN7S2489C8D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
static Base_Class bases_S2489C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C3,    ABISELECT(128,84), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C6,    ABISELECT(256,156), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S2489C8[];
extern void _ZN7S2489C8D1Ev();
extern void _ZN7S2489C8D0Ev();
extern void _ZN7S2489C82v4Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY vtc_S2489C8[] = {
  ABISELECT(256,156),
  ABISELECT(128,84),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-256,-156),
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern VTBL_ENTRY _ZTV7S2489C8[];
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C8[] = {
  ABISELECT(-128,-72),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
static  VTT_ENTRY vtt_S2489C8[] = {
  {&(_ZTV7S2489C8[4]),  4,14},
  {&(_ZTV7S2489C8[12]),  12,14},
  {&(_tg__ZTV7S2489C6__7S2489C8[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7S2489C8[];
extern  VTBL_ENTRY _ZTV7S2489C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C8[];
Class_Descriptor cd_S2489C8 = {  "S2489C8", // class name
  bases_S2489C8, 2,
  &(vtc_S2489C8[0]), // expected_vtbl_contents
  &(vtt_S2489C8[0]), // expected_vtt_contents
  ABISELECT(640,360), // object size
  NSPAIRA(_ZTI7S2489C8),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2489C8),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S2489C8),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S2489C11  {
  void *s2489c11f0;
  int s2489c11f1;
  void *s2489c11f2;
  char s2489c11f3;
  char s2489c11f4;
  __tsi64 s2489c11f5[5];
  void *s2489c11f6;
  void *s2489c11f7;
  void *s2489c11f8;
  void  mf2489c11(); // _ZN8S2489C119mf2489c11Ev
};
//SIG(1 S2489C11) U1{ m Fp Fi Fp Fc Fc FL[5] Fp Fp Fp}

#endif // __cplusplus
#ifdef __cplusplus

struct  S2489C10  : S2489C3 , virtual S2489C6 , virtual S2489C8 , virtual S2489C5 {
  char s2489c10f0;
  int s2489c10f1[7];
  long s2489c10f2[5];
  __tsi64 s2489c10f3;
  __tsi64 s2489c10f4;
  __tsi64 s2489c10f5;
  ::S2489C11 s2489c10f6;
  virtual  ~S2489C10(); // _ZN8S2489C10D2Ev
  virtual void  v5(); // _ZN8S2489C102v5Ev
  S2489C10(); // tgen
};
//SIG(-1 S2489C10) C1{ BC2{ m Fc Fi FL FU3{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} VBC4{ VBC2 v2 v3 Fp Fp Fi Fi FU5{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU5 Fp FL:3 FC2 FL FU5} VBC6{ VBC2 VBC4 vd v4 FL FL FL FL Fi FU5 Fc[10] Fi} VBC7{ BC2 BC4 v5 Fp FD FC2[7] FD FU3 Fs FL FL} vd v1 Fc Fi[7] Fl[5] FL FL FL FU8{ m Fp Fi Fp Fc Fc FL[5] Fp Fp Fp}}


 S2489C10 ::~S2489C10(){ note_dtor("S2489C10", this);}
void  S2489C10 ::v5(){vfunc_called(this, "_ZN8S2489C102v5Ev");}
S2489C10 ::S2489C10(){ note_ctor("S2489C10", this);} // tgen

static void Test_S2489C10()
{
  extern Class_Descriptor cd_S2489C10;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(157,356)];
    init_test(&cd_S2489C10, buf);
    S2489C10 *dp, &lv = *(dp=new (buf) S2489C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2496,1420), "sizeof(S2489C10)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2489C10)");
    /*is_ambiguous_... S2489C10::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*), ABISELECT(16,4), "S2489C10");
    /*is_ambiguous_... S2489C10::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*), ABISELECT(672,396), "S2489C10");
    check_base_class_offset(lv, (S2489C3*)(S2489C8*), ABISELECT(672,396), "S2489C10");
    check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C5*), ABISELECT(672,396), "S2489C10");
    /*is_ambiguous_... S2489C10::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*), ABISELECT(288,192), "S2489C10");
    check_base_class_offset(lv, (S2489C6*)(S2489C8*), ABISELECT(288,192), "S2489C10");
    check_base_class_offset(lv, (S2489C8*), ABISELECT(800,468), "S2489C10");
    /*is_ambiguous_... S2489C5::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C5*), ABISELECT(1312,756), "S2489C10");
    check_base_class_offset(lv, (S2489C6*)(S2489C5*), ABISELECT(928,552), "S2489C10");
    check_base_class_offset(lv, (S2489C5*), ABISELECT(928,552), "S2489C10");
    check_field_offset(lv, s2489c10f0, ABISELECT(144,76), "S2489C10.s2489c10f0");
    check_field_offset(lv, s2489c10f1, ABISELECT(148,80), "S2489C10.s2489c10f1");
    check_field_offset(lv, s2489c10f2, ABISELECT(176,108), "S2489C10.s2489c10f2");
    check_field_offset(lv, s2489c10f3, ABISELECT(216,128), "S2489C10.s2489c10f3");
    check_field_offset(lv, s2489c10f4, ABISELECT(224,136), "S2489C10.s2489c10f4");
    check_field_offset(lv, s2489c10f5, ABISELECT(232,144), "S2489C10.s2489c10f5");
    check_field_offset(lv, s2489c10f6, ABISELECT(240,152), "S2489C10.s2489c10f6");
    test_class_info(&lv, &cd_S2489C10);
    dp->~S2489C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2489C10(Test_S2489C10, "S2489C10", ABISELECT(2496,1420));

#else // __cplusplus

extern void _ZN8S2489C10C1Ev();
extern void _ZN8S2489C10D2Ev();
Name_Map name_map_S2489C10[] = {
  NSPAIR(_ZN8S2489C10C1Ev),
  NSPAIR(_ZN8S2489C10D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C8;
extern VTBL_ENTRY _ZTI7S2489C8[];
extern  VTBL_ENTRY _ZTV7S2489C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C8[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C5;
extern VTBL_ENTRY _ZTI7S2489C5[];
extern  VTBL_ENTRY _ZTV7S2489C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C5[];
static Base_Class bases_S2489C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C3,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2489C3,    ABISELECT(672,396), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S2489C6,    ABISELECT(288,192), //bcp->offset
    9, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C8,    ABISELECT(800,468), //bcp->offset
    16, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C3,    ABISELECT(1312,756), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2489C6,    ABISELECT(928,552), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2489C5,    ABISELECT(928,552), //bcp->offset
    25, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S2489C10[];
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZThn800_N8S2489C10D1Ev,_ZThn468_N8S2489C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void ABISELECT(_ZThn800_N8S2489C10D0Ev,_ZThn468_N8S2489C10D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY vtc_S2489C10[] = {
  ABISELECT(928,552),
  ABISELECT(800,468),
  ABISELECT(672,396),
  ABISELECT(288,192),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(-288,-192),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  0,
  ABISELECT(-800,-468),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(-800,-468),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-928,-552),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern VTBL_ENTRY _ZTV8S2489C10[];
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C10[] = {
  ABISELECT(384,204),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C8D1Ev();
extern void _ZN7S2489C8D0Ev();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C10[] = {
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C8__8S2489C10[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(512,276),
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C10[] = {
  ABISELECT(-256,-156),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C5[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C67S2489C5__A1__8S2489C10[] = {
  ABISELECT(-256,-156),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
static  VTT_ENTRY vtt_S2489C10[] = {
  {&(_ZTV8S2489C10[6]),  6,34},
  {&(_ZTV8S2489C10[14]),  14,34},
  {&(_ZTV8S2489C10[22]),  22,34},
  {&(_ZTV8S2489C10[31]),  31,34},
  {&(_tg__ZTV7S2489C6__8S2489C10[3]),  3,5},
  {&(_tg__ZTV7S2489C8__8S2489C10[4]),  4,7},
  {&(_tg__ZTV7S2489C6__7S2489C8__8S2489C10[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C10[3]),  3,6},
  {&(_tg__ZTV7S2489C67S2489C5__A1__8S2489C10[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
static VTBL_ENTRY alt_thunk_names1[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn800_N8S2489C10D0Ev,_ZThn468_N8S2489C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn800_N8S2489C10D1Ev,_ZThn468_N8S2489C10D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S2489C10 = {  "S2489C10", // class name
  bases_S2489C10, 7,
  &(vtc_S2489C10[0]), // expected_vtbl_contents
  &(vtt_S2489C10[0]), // expected_vtt_contents
  ABISELECT(2496,1420), // object size
  NSPAIRA(_ZTI8S2489C10),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S2489C10),34, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S2489C10),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names1,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2489C12_nt  {
};
//SIG(-1 S2489C12_nt) C1{}



//skip512 S2489C12_nt

#else // __cplusplus

Class_Descriptor cd_S2489C12_nt = {  "S2489C12_nt", // class name
  0,0,//no base classes
  0, // no vftv
  0, //no vtt
  1, // object size
  {0,0},0, // typeinfo_var
  {0,0},0, // virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2489C9  : S2489C10 {
  void *s2489c9f0;
  void *s2489c9f1;
  void *s2489c9f2;
  int s2489c9f3;
  ::S2489C12_nt s2489c9f4;
  __tsi64 s2489c9f5;
  __tsi64 s2489c9f6;
  virtual  ~S2489C9(); // _ZN7S2489C9D2Ev
  virtual void  v6(); // _ZN7S2489C92v6Ev
  virtual void  v7(); // _ZN7S2489C92v7Ev
  S2489C9(); // tgen
};
//SIG(-1 S2489C9) C1{ BC2{ BC3{ m Fc Fi FL FU4{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} VBC5{ VBC3 v3 v4 Fp Fp Fi Fi FU6{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU6 Fp FL:3 FC3 FL FU6} VBC7{ VBC3 VBC5 vd v5 FL FL FL FL Fi FU6 Fc[10] Fi} VBC8{ BC3 BC5 v6 Fp FD FC3[7] FD FU4 Fs FL FL} vd v7 Fc Fi[7] Fl[5] FL FL FL FU9{ m Fp Fi Fp Fc Fc FL[5] Fp Fp Fp}} vd v1 v2 Fp Fp Fp Fi FC10{} FL FL}


 S2489C9 ::~S2489C9(){ note_dtor("S2489C9", this);}
void  S2489C9 ::v6(){vfunc_called(this, "_ZN7S2489C92v6Ev");}
void  S2489C9 ::v7(){vfunc_called(this, "_ZN7S2489C92v7Ev");}
S2489C9 ::S2489C9(){ note_ctor("S2489C9", this);} // tgen

static void Test_S2489C9()
{
  extern Class_Descriptor cd_S2489C9;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(160,365)];
    init_test(&cd_S2489C9, buf);
    S2489C9 *dp, &lv = *(dp=new (buf) S2489C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2544,1456), "sizeof(S2489C9)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2489C9)");
    /*is_ambiguous_... S2489C10::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*), ABISELECT(16,4), "S2489C9");
    /*is_ambiguous_... S2489C9::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*), ABISELECT(720,432), "S2489C9");
    check_base_class_offset(lv, (S2489C3*)(S2489C8*), ABISELECT(720,432), "S2489C9");
    check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C5*), ABISELECT(720,432), "S2489C9");
    /*is_ambiguous_... S2489C10::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*), ABISELECT(336,228), "S2489C9");
    check_base_class_offset(lv, (S2489C6*)(S2489C8*), ABISELECT(336,228), "S2489C9");
    check_base_class_offset(lv, (S2489C8*)(S2489C10*), ABISELECT(848,504), "S2489C9");
    /*is_ambiguous_... S2489C5::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C5*), ABISELECT(1360,792), "S2489C9");
    check_base_class_offset(lv, (S2489C6*)(S2489C5*), ABISELECT(976,588), "S2489C9");
    check_base_class_offset(lv, (S2489C5*)(S2489C10*), ABISELECT(976,588), "S2489C9");
    check_base_class_offset(lv, (S2489C10*), 0, "S2489C9");
    check_field_offset(lv, s2489c9f0, ABISELECT(280,192), "S2489C9.s2489c9f0");
    check_field_offset(lv, s2489c9f1, ABISELECT(288,196), "S2489C9.s2489c9f1");
    check_field_offset(lv, s2489c9f2, ABISELECT(296,200), "S2489C9.s2489c9f2");
    check_field_offset(lv, s2489c9f3, ABISELECT(304,204), "S2489C9.s2489c9f3");
    check_field_offset(lv, s2489c9f4, ABISELECT(308,208), "S2489C9.s2489c9f4");
    check_field_offset(lv, s2489c9f5, ABISELECT(312,212), "S2489C9.s2489c9f5");
    check_field_offset(lv, s2489c9f6, ABISELECT(320,220), "S2489C9.s2489c9f6");
    test_class_info(&lv, &cd_S2489C9);
    dp->~S2489C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2489C9(Test_S2489C9, "S2489C9", ABISELECT(2544,1456));

#else // __cplusplus

extern void _ZN7S2489C9C1Ev();
extern void _ZN7S2489C9D2Ev();
Name_Map name_map_S2489C9[] = {
  NSPAIR(_ZN7S2489C9C1Ev),
  NSPAIR(_ZN7S2489C9D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C8;
extern VTBL_ENTRY _ZTI7S2489C8[];
extern  VTBL_ENTRY _ZTV7S2489C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C8[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C5;
extern VTBL_ENTRY _ZTI7S2489C5[];
extern  VTBL_ENTRY _ZTV7S2489C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C5[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
static Base_Class bases_S2489C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C3,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(720,432), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S2489C6,    ABISELECT(336,228), //bcp->offset
    11, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S2489C8,    ABISELECT(848,504), //bcp->offset
    18, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S2489C3,    ABISELECT(1360,792), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2489C6,    ABISELECT(976,588), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2489C5,    ABISELECT(976,588), //bcp->offset
    27, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S2489C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2489C9[];
extern void _ZN7S2489C9D1Ev();
extern void _ZN7S2489C9D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev)();
extern void ABISELECT(_ZThn848_N7S2489C9D1Ev,_ZThn504_N7S2489C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev)();
extern void ABISELECT(_ZThn848_N7S2489C9D0Ev,_ZThn504_N7S2489C9D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY vtc_S2489C9[] = {
  ABISELECT(976,588),
  ABISELECT(848,504),
  ABISELECT(720,432),
  ABISELECT(336,228),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  0,
  ABISELECT(-848,-504),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(-848,-504),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-976,-588),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern VTBL_ENTRY _ZTV7S2489C9[];
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C10__7S2489C9[] = {
  ABISELECT(976,588),
  ABISELECT(848,504),
  ABISELECT(720,432),
  ABISELECT(336,228),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C10__7S2489C9[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(-336,-228),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZThn848_N8S2489C10D1Ev,_ZThn504_N8S2489C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void ABISELECT(_ZThn848_N8S2489C10D0Ev,_ZThn504_N8S2489C10D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C10__7S2489C9[] = {
  0,
  ABISELECT(-848,-504),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(-848,-504),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C10__7S2489C9[] = {
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-976,-588),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C9[] = {
  ABISELECT(384,204),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C8D1Ev();
extern void _ZN7S2489C8D0Ev();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__7S2489C9[] = {
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C8__7S2489C9[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(512,276),
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__7S2489C9[] = {
  ABISELECT(-256,-156),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C5[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C67S2489C5__A1__7S2489C9[] = {
  ABISELECT(-256,-156),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
static  VTT_ENTRY vtt_S2489C9[] = {
  {&(_ZTV7S2489C9[6]),  6,36},
  {&(_tg__ZTV8S2489C10__7S2489C9[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C10__7S2489C9[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C10__7S2489C9[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C10__7S2489C9[6]),  6,9},
  {&(_ZTV7S2489C9[16]),  16,36},
  {&(_ZTV7S2489C9[24]),  24,36},
  {&(_ZTV7S2489C9[33]),  33,36},
  {&(_tg__ZTV7S2489C6__7S2489C9[3]),  3,5},
  {&(_tg__ZTV7S2489C8__7S2489C9[4]),  4,7},
  {&(_tg__ZTV7S2489C6__7S2489C8__7S2489C9[5]),  5,7},
  {&(_tg__ZTV7S2489C5__7S2489C9[3]),  3,6},
  {&(_tg__ZTV7S2489C67S2489C5__A1__7S2489C9[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7S2489C9[];
extern  VTBL_ENTRY _ZTV7S2489C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C9[];
static VTBL_ENTRY alt_thunk_names2[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn848_N8S2489C10D0Ev,_ZThn504_N8S2489C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn848_N8S2489C10D1Ev,_ZThn504_N8S2489C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn848_N7S2489C9D0Ev,_ZThn504_N7S2489C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn848_N7S2489C9D1Ev,_ZThn504_N7S2489C9D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S2489C9 = {  "S2489C9", // class name
  bases_S2489C9, 8,
  &(vtc_S2489C9[0]), // expected_vtbl_contents
  &(vtt_S2489C9[0]), // expected_vtt_contents
  ABISELECT(2544,1456), // object size
  NSPAIRA(_ZTI7S2489C9),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2489C9),36, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S2489C9),13, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names2,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2489C2  : S2489C3 , virtual S2489C5 , virtual S2489C8 , S2489C9 {
  long double s2489c2f0;
  virtual  ~S2489C2(); // _ZN7S2489C2D2Ev
  S2489C2(); // tgen
};
//SIG(-1 S2489C2) C1{ BC2{ m Fc Fi FL FU3{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} VBC4{ BC2 BC5{ VBC2 v1 v2 Fp Fp Fi Fi FU6{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU6 Fp FL:3 FC2 FL FU6} v3 Fp FD FC2[7] FD FU3 Fs FL FL} VBC7{ VBC2 VBC5 vd v4 FL FL FL FL Fi FU6 Fc[10] Fi} BC8{ BC9{ BC2 VBC5 VBC7 VBC4 vd v5 Fc Fi[7] Fl[5] FL FL FL FU10{ m Fp Fi Fp Fc Fc FL[5] Fp Fp Fp}} vd v6 v7 Fp Fp Fp Fi FC11{} FL FL} vd FD}


 S2489C2 ::~S2489C2(){ note_dtor("S2489C2", this);}
S2489C2 ::S2489C2(){ note_ctor("S2489C2", this);} // tgen

static void Test_S2489C2()
{
  extern Class_Descriptor cd_S2489C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(169,386)];
    init_test(&cd_S2489C2, buf);
    S2489C2 *dp, &lv = *(dp=new (buf) S2489C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2688,1540), "sizeof(S2489C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2489C2)");
    /*is_ambiguous_... S2489C2::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*), ABISELECT(336,228), "S2489C2");
    /*is_ambiguous_... S2489C5::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C5*), ABISELECT(864,516), "S2489C2");
    check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C5*), ABISELECT(2048,1180), "S2489C2");
    check_base_class_offset(lv, (S2489C3*)(S2489C8*), ABISELECT(2048,1180), "S2489C2");
    /*is_ambiguous_... S2489C2::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*), ABISELECT(2048,1180), "S2489C2");
    check_base_class_offset(lv, (S2489C6*)(S2489C5*), ABISELECT(480,312), "S2489C2");
    check_base_class_offset(lv, (S2489C5*), ABISELECT(480,312), "S2489C2");
    check_base_class_offset(lv, (S2489C5*)(S2489C10*)(S2489C9*), ABISELECT(480,312), "S2489C2");
    check_base_class_offset(lv, (S2489C6*)(S2489C8*), ABISELECT(2304,1336), "S2489C2");
    /*is_ambiguous_... S2489C10::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*)(S2489C9*), ABISELECT(2304,1336), "S2489C2");
    check_base_class_offset(lv, (S2489C8*), ABISELECT(2176,1252), "S2489C2");
    check_base_class_offset(lv, (S2489C8*)(S2489C10*)(S2489C9*), ABISELECT(2176,1252), "S2489C2");
    /*is_ambiguous_... S2489C10::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*)(S2489C9*), ABISELECT(16,4), "S2489C2");
    check_base_class_offset(lv, (S2489C10*)(S2489C9*), 0, "S2489C2");
    check_base_class_offset(lv, (S2489C9*), 0, "S2489C2");
    check_field_offset(lv, s2489c2f0, ABISELECT(464,300), "S2489C2.s2489c2f0");
    test_class_info(&lv, &cd_S2489C2);
    dp->~S2489C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2489C2(Test_S2489C2, "S2489C2", ABISELECT(2688,1540));

#else // __cplusplus

extern void _ZN7S2489C2C1Ev();
extern void _ZN7S2489C2D2Ev();
Name_Map name_map_S2489C2[] = {
  NSPAIR(_ZN7S2489C2C1Ev),
  NSPAIR(_ZN7S2489C2D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C5;
extern VTBL_ENTRY _ZTI7S2489C5[];
extern  VTBL_ENTRY _ZTV7S2489C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C5[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C8;
extern VTBL_ENTRY _ZTI7S2489C8[];
extern  VTBL_ENTRY _ZTV7S2489C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C8[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C9;
extern VTBL_ENTRY _ZTI7S2489C9[];
extern  VTBL_ENTRY _ZTV7S2489C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C9[];
static Base_Class bases_S2489C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C3,    ABISELECT(336,228), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2489C3,    ABISELECT(864,516), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(2048,1180), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S2489C6,    ABISELECT(480,312), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2489C5,    ABISELECT(480,312), //bcp->offset
    11, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C6,    ABISELECT(2304,1336), //bcp->offset
    29, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S2489C8,    ABISELECT(2176,1252), //bcp->offset
    20, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C3,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S2489C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S2489C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2489C2[];
extern void _ZN7S2489C2D1Ev();
extern void _ZN7S2489C2D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
extern void ABISELECT(_ZTv0_n40_N7S2489C2D1Ev,_ZTv0_n20_N7S2489C2D1Ev)();
extern void ABISELECT(_ZThn2176_N7S2489C2D1Ev,_ZThn1252_N7S2489C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S2489C2D0Ev,_ZTv0_n20_N7S2489C2D0Ev)();
extern void ABISELECT(_ZThn2176_N7S2489C2D0Ev,_ZThn1252_N7S2489C2D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY vtc_S2489C2[] = {
  ABISELECT(480,312),
  ABISELECT(2176,1252),
  ABISELECT(2048,1180),
  ABISELECT(2304,1336),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C2[0]),
  (VTBL_ENTRY)&_ZN7S2489C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C2D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(-480,-312),
  (VTBL_ENTRY)&(_ZTI7S2489C2[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
  0,
  ABISELECT(-2176,-1252),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(-2176,-1252),
  (VTBL_ENTRY)&(_ZTI7S2489C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C2D1Ev,_ZTv0_n20_N7S2489C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C2D0Ev,_ZTv0_n20_N7S2489C2D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-2304,-1336),
  (VTBL_ENTRY)&(_ZTI7S2489C2[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern VTBL_ENTRY _ZTV7S2489C2[];
extern void _ZN7S2489C9D1Ev();
extern void _ZN7S2489C9D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C9__7S2489C2[] = {
  ABISELECT(480,312),
  ABISELECT(2176,1252),
  ABISELECT(2048,1180),
  ABISELECT(2304,1336),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C107S2489C9__7S2489C2[] = {
  ABISELECT(480,312),
  ABISELECT(2176,1252),
  ABISELECT(2048,1180),
  ABISELECT(2304,1336),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C107S2489C9__7S2489C2[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-2304,-1336),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZThn2176_N8S2489C10D1Ev,_ZThn1252_N8S2489C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void ABISELECT(_ZThn2176_N8S2489C10D0Ev,_ZThn1252_N8S2489C10D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C107S2489C9__7S2489C2[] = {
  0,
  ABISELECT(-2176,-1252),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(-2176,-1252),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C107S2489C9__7S2489C2[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(-480,-312),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C9__7S2489C2[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-2304,-1336),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev)();
extern void ABISELECT(_ZThn2176_N7S2489C9D1Ev,_ZThn1252_N7S2489C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev)();
extern void ABISELECT(_ZThn2176_N7S2489C9D0Ev,_ZThn1252_N7S2489C9D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__7S2489C9__7S2489C2[] = {
  0,
  ABISELECT(-2176,-1252),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(-2176,-1252),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__7S2489C9__7S2489C2[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(-480,-312),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__7S2489C2[] = {
  ABISELECT(1568,868),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C5[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C67S2489C5__7S2489C2[] = {
  ABISELECT(1568,868),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C8D1Ev();
extern void _ZN7S2489C8D0Ev();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__7S2489C2[] = {
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C8__7S2489C2[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-128,-84),
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A1__7S2489C2[] = {
  ABISELECT(-256,-156),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
static  VTT_ENTRY vtt_S2489C2[] = {
  {&(_ZTV7S2489C2[6]),  6,36},
  {&(_tg__ZTV7S2489C9__7S2489C2[6]),  6,11},
  {&(_tg__ZTV8S2489C107S2489C9__7S2489C2[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C107S2489C9__7S2489C2[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C107S2489C9__7S2489C2[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C107S2489C9__7S2489C2[6]),  6,9},
  {&(_tg__ZTV7S2489C6__7S2489C9__7S2489C2[5]),  5,7},
  {&(_tg__ZTV7S2489C8__7S2489C9__7S2489C2[6]),  6,9},
  {&(_tg__ZTV7S2489C5__7S2489C9__7S2489C2[6]),  6,9},
  {&(_ZTV7S2489C2[17]),  17,36},
  {&(_ZTV7S2489C2[26]),  26,36},
  {&(_ZTV7S2489C2[34]),  34,36},
  {&(_tg__ZTV7S2489C5__7S2489C2[3]),  3,6},
  {&(_tg__ZTV7S2489C67S2489C5__7S2489C2[3]),  3,5},
  {&(_tg__ZTV7S2489C8__7S2489C2[4]),  4,7},
  {&(_tg__ZTV7S2489C6__7S2489C8__7S2489C2[5]),  5,7},
  {&(_tg__ZTV7S2489C6__A1__7S2489C2[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7S2489C2[];
extern  VTBL_ENTRY _ZTV7S2489C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C2[];
static VTBL_ENTRY alt_thunk_names3[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2176_N7S2489C9D0Ev,_ZThn1252_N7S2489C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2176_N7S2489C9D1Ev,_ZThn1252_N7S2489C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2176_N8S2489C10D0Ev,_ZThn1252_N8S2489C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2176_N8S2489C10D1Ev,_ZThn1252_N8S2489C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S2489C2D0Ev,_ZTv0_n20_N7S2489C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2176_N7S2489C2D0Ev,_ZThn1252_N7S2489C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S2489C2D1Ev,_ZTv0_n20_N7S2489C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2176_N7S2489C2D1Ev,_ZThn1252_N7S2489C2D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S2489C2 = {  "S2489C2", // class name
  bases_S2489C2, 10,
  &(vtc_S2489C2[0]), // expected_vtbl_contents
  &(vtt_S2489C2[0]), // expected_vtt_contents
  ABISELECT(2688,1540), // object size
  NSPAIRA(_ZTI7S2489C2),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV7S2489C2),36, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S2489C2),17, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names3,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2489C14  : virtual S2489C5 , virtual S2489C8 {
  int s2489c14f0;
  void *s2489c14f1;
  int s2489c14f2;
  ::S2489C7 s2489c14f3;
  ~S2489C14(); // tgen
  S2489C14(); // tgen
};
//SIG(-1 S2489C14) C1{ VBC2{ BC3{ m Fc Fi FL FU4{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} BC5{ VBC3 v1 v2 Fp Fp Fi Fi FU6{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU6 Fp FL:3 FC3 FL FU6} v3 Fp FD FC3[7] FD FU4 Fs FL FL} VBC7{ VBC3 VBC5 vd v4 FL FL FL FL Fi FU6 Fc[10] Fi} Fi Fp Fi FU6}


S2489C14 ::~S2489C14(){ note_dtor("S2489C14", this);} // tgen
S2489C14 ::S2489C14(){ note_ctor("S2489C14", this);} // tgen

static void Test_S2489C14()
{
  extern Class_Descriptor cd_S2489C14;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(145,319)];
    init_test(&cd_S2489C14, buf);
    S2489C14 *dp, &lv = *(dp=new (buf) S2489C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2304,1272), "sizeof(S2489C14)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2489C14)");
    /*is_ambiguous_... S2489C5::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C5*), ABISELECT(480,248), "S2489C14");
    check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C5*), ABISELECT(1664,912), "S2489C14");
    check_base_class_offset(lv, (S2489C3*)(S2489C8*), ABISELECT(1664,912), "S2489C14");
    /*is_ambiguous_... S2489C14::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*), ABISELECT(1664,912), "S2489C14");
    check_base_class_offset(lv, (S2489C6*)(S2489C5*), ABISELECT(96,44), "S2489C14");
    check_base_class_offset(lv, (S2489C5*), ABISELECT(96,44), "S2489C14");
    check_base_class_offset(lv, (S2489C6*)(S2489C8*), ABISELECT(1920,1068), "S2489C14");
    check_base_class_offset(lv, (S2489C8*), ABISELECT(1792,984), "S2489C14");
    check_field_offset(lv, s2489c14f0, ABISELECT(8,4), "S2489C14.s2489c14f0");
    check_field_offset(lv, s2489c14f1, ABISELECT(16,8), "S2489C14.s2489c14f1");
    check_field_offset(lv, s2489c14f2, ABISELECT(24,12), "S2489C14.s2489c14f2");
    check_field_offset(lv, s2489c14f3, ABISELECT(32,16), "S2489C14.s2489c14f3");
    test_class_info(&lv, &cd_S2489C14);
    dp->~S2489C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2489C14(Test_S2489C14, "S2489C14", ABISELECT(2304,1272));

#else // __cplusplus

extern void _ZN8S2489C14C1Ev();
extern void _ZN8S2489C14D1Ev();
Name_Map name_map_S2489C14[] = {
  NSPAIR(_ZN8S2489C14C1Ev),
  NSPAIR(_ZN8S2489C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C5;
extern VTBL_ENTRY _ZTI7S2489C5[];
extern  VTBL_ENTRY _ZTV7S2489C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C5[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C8;
extern VTBL_ENTRY _ZTI7S2489C8[];
extern  VTBL_ENTRY _ZTV7S2489C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C8[];
static Base_Class bases_S2489C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C3,    ABISELECT(480,248), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(1664,912), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S2489C6,    ABISELECT(96,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2489C5,    ABISELECT(96,44), //bcp->offset
    8, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C6,    ABISELECT(1920,1068), //bcp->offset
    26, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S2489C8,    ABISELECT(1792,984), //bcp->offset
    17, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S2489C14[];
extern void _ZN8S2489C14D1Ev();
extern void _ZN8S2489C14D0Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S2489C14D1Ev,_ZTv0_n20_N8S2489C14D1Ev)();
extern void ABISELECT(_ZThn1792_N8S2489C14D1Ev,_ZThn984_N8S2489C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C14D0Ev,_ZTv0_n20_N8S2489C14D0Ev)();
extern void ABISELECT(_ZThn1792_N8S2489C14D0Ev,_ZThn984_N8S2489C14D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY vtc_S2489C14[] = {
  ABISELECT(1920,1068),
  ABISELECT(1792,984),
  ABISELECT(1664,912),
  ABISELECT(96,44),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C14[0]),
  (VTBL_ENTRY)&_ZN8S2489C14D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C14D0Ev,
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(-96,-44),
  (VTBL_ENTRY)&(_ZTI8S2489C14[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
  0,
  ABISELECT(-1792,-984),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(-1792,-984),
  (VTBL_ENTRY)&(_ZTI8S2489C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C14D1Ev,_ZTv0_n20_N8S2489C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C14D0Ev,_ZTv0_n20_N8S2489C14D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-1920,-1068),
  (VTBL_ENTRY)&(_ZTI8S2489C14[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern VTBL_ENTRY _ZTV8S2489C14[];
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C14[] = {
  ABISELECT(1568,868),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C5[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C67S2489C5__8S2489C14[] = {
  ABISELECT(1568,868),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C8D1Ev();
extern void _ZN7S2489C8D0Ev();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C14[] = {
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C8__8S2489C14[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-128,-84),
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A1__8S2489C14[] = {
  ABISELECT(-256,-156),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
static  VTT_ENTRY vtt_S2489C14[] = {
  {&(_ZTV8S2489C14[6]),  6,33},
  {&(_ZTV8S2489C14[14]),  14,33},
  {&(_ZTV8S2489C14[23]),  23,33},
  {&(_ZTV8S2489C14[31]),  31,33},
  {&(_tg__ZTV7S2489C5__8S2489C14[3]),  3,6},
  {&(_tg__ZTV7S2489C67S2489C5__8S2489C14[3]),  3,5},
  {&(_tg__ZTV7S2489C8__8S2489C14[4]),  4,7},
  {&(_tg__ZTV7S2489C6__7S2489C8__8S2489C14[5]),  5,7},
  {&(_tg__ZTV7S2489C6__A1__8S2489C14[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S2489C14[];
extern  VTBL_ENTRY _ZTV8S2489C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C14[];
static VTBL_ENTRY alt_thunk_names4[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C14D0Ev,_ZTv0_n20_N8S2489C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1792_N8S2489C14D0Ev,_ZThn984_N8S2489C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C14D1Ev,_ZTv0_n20_N8S2489C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1792_N8S2489C14D1Ev,_ZThn984_N8S2489C14D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S2489C14 = {  "S2489C14", // class name
  bases_S2489C14, 6,
  &(vtc_S2489C14[0]), // expected_vtbl_contents
  &(vtt_S2489C14[0]), // expected_vtt_contents
  ABISELECT(2304,1272), // object size
  NSPAIRA(_ZTI8S2489C14),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S2489C14),33, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S2489C14),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names4,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2489C13  {
  long double s2489c13f0;
  ::S2489C14 s2489c13f1[6];
  char s2489c13f2;
  void *s2489c13f3;
  void *s2489c13f4;
  int s2489c13f5[6];
  int s2489c13f6;
  void *s2489c13f7;
  __tsi64 s2489c13f8;
  void *s2489c13f9;
  int s2489c13f10;
  void *s2489c13f11;
  void *s2489c13f12;
  virtual void  v11(); // _ZN8S2489C133v11Ev
  ~S2489C13(); // tgen
  S2489C13(); // tgen
};
//SIG(-1 S2489C13) C1{ v1 FD FC2{ VBC3{ BC4{ m Fc Fi FL FU5{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} BC6{ VBC4 v2 v3 Fp Fp Fi Fi FU7{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU7 Fp FL:3 FC4 FL FU7} v4 Fp FD FC4[7] FD FU5 Fs FL FL} VBC8{ VBC4 VBC6 vd v5 FL FL FL FL Fi FU7 Fc[10] Fi} Fi Fp Fi FU7}[6] Fc Fp Fp Fi[6] Fi Fp FL Fp Fi Fp Fp}


void  S2489C13 ::v11(){vfunc_called(this, "_ZN8S2489C133v11Ev");}
S2489C13 ::~S2489C13(){ note_dtor("S2489C13", this);} // tgen
S2489C13 ::S2489C13(){ note_ctor("S2489C13", this);} // tgen

static void Test_S2489C13()
{
  extern Class_Descriptor cd_S2489C13;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(874,1930)];
    init_test(&cd_S2489C13, buf);
    S2489C13 *dp, &lv = *(dp=new (buf) S2489C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(13968,7716), "sizeof(S2489C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2489C13)");
    check_field_offset(lv, s2489c13f0, ABISELECT(16,4), "S2489C13.s2489c13f0");
    check_field_offset(lv, s2489c13f1, ABISELECT(32,16), "S2489C13.s2489c13f1");
    check_field_offset(lv, s2489c13f2, ABISELECT(13856,7648), "S2489C13.s2489c13f2");
    check_field_offset(lv, s2489c13f3, ABISELECT(13864,7652), "S2489C13.s2489c13f3");
    check_field_offset(lv, s2489c13f4, ABISELECT(13872,7656), "S2489C13.s2489c13f4");
    check_field_offset(lv, s2489c13f5, ABISELECT(13880,7660), "S2489C13.s2489c13f5");
    check_field_offset(lv, s2489c13f6, ABISELECT(13904,7684), "S2489C13.s2489c13f6");
    check_field_offset(lv, s2489c13f7, ABISELECT(13912,7688), "S2489C13.s2489c13f7");
    check_field_offset(lv, s2489c13f8, ABISELECT(13920,7692), "S2489C13.s2489c13f8");
    check_field_offset(lv, s2489c13f9, ABISELECT(13928,7700), "S2489C13.s2489c13f9");
    check_field_offset(lv, s2489c13f10, ABISELECT(13936,7704), "S2489C13.s2489c13f10");
    check_field_offset(lv, s2489c13f11, ABISELECT(13944,7708), "S2489C13.s2489c13f11");
    check_field_offset(lv, s2489c13f12, ABISELECT(13952,7712), "S2489C13.s2489c13f12");
    test_class_info(&lv, &cd_S2489C13);
    dp->~S2489C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2489C13(Test_S2489C13, "S2489C13", ABISELECT(13968,7716));

#else // __cplusplus

extern void _ZN8S2489C13C1Ev();
extern void _ZN8S2489C13D1Ev();
Name_Map name_map_S2489C13[] = {
  NSPAIR(_ZN8S2489C13C1Ev),
  NSPAIR(_ZN8S2489C13D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2489C13[];
extern void _ZN8S2489C133v11Ev();
static  VTBL_ENTRY vtc_S2489C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C13[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
};
extern VTBL_ENTRY _ZTI8S2489C13[];
extern  VTBL_ENTRY _ZTV8S2489C13[];
Class_Descriptor cd_S2489C13 = {  "S2489C13", // class name
  0,0,//no base classes
  &(vtc_S2489C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(13968,7716), // object size
  NSPAIRA(_ZTI8S2489C13),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2489C13),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2489C18  {
  ::S2489C4 s2489c18f0;
  void  mf2489c18(); // _ZN8S2489C189mf2489c18Ev
  virtual  ~S2489C18(); // _ZN8S2489C18D1Ev
  S2489C18(); // tgen
};
//SIG(-1 S2489C18) C1{ vd m FU2{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi}}


void  S2489C18 ::mf2489c18(){}
 S2489C18 ::~S2489C18(){ note_dtor("S2489C18", this);}
S2489C18 ::S2489C18(){ note_ctor("S2489C18", this);} // tgen

static void Test_S2489C18()
{
  extern Class_Descriptor cd_S2489C18;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(7,12)];
    init_test(&cd_S2489C18, buf);
    S2489C18 *dp, &lv = *(dp=new (buf) S2489C18());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(96,44), "sizeof(S2489C18)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2489C18)");
    check_field_offset(lv, s2489c18f0, ABISELECT(16,4), "S2489C18.s2489c18f0");
    test_class_info(&lv, &cd_S2489C18);
    dp->~S2489C18();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2489C18(Test_S2489C18, "S2489C18", ABISELECT(96,44));

#else // __cplusplus

extern void _ZN8S2489C18C1Ev();
extern void _ZN8S2489C18D1Ev();
Name_Map name_map_S2489C18[] = {
  NSPAIR(_ZN8S2489C18C1Ev),
  NSPAIR(_ZN8S2489C18D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2489C18[];
extern void _ZN8S2489C18D1Ev();
extern void _ZN8S2489C18D0Ev();
static  VTBL_ENTRY vtc_S2489C18[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C18[0]),
  (VTBL_ENTRY)&_ZN8S2489C18D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C18D0Ev,
};
extern VTBL_ENTRY _ZTI8S2489C18[];
extern  VTBL_ENTRY _ZTV8S2489C18[];
Class_Descriptor cd_S2489C18 = {  "S2489C18", // class name
  0,0,//no base classes
  &(vtc_S2489C18[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(96,44), // object size
  NSPAIRA(_ZTI8S2489C18),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2489C18),4, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  0, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2489C19  : virtual S2489C8 , S2489C10 , S2489C3 , S2489C6 {
  ::S2489C7 s2489c19f0;
  int s2489c19f1;
  long s2489c19f2;
  char s2489c19f3;
  void *s2489c19f4;
  ::S2489C5 s2489c19f5;
  short s2489c19f6;
  virtual  ~S2489C19(); // _ZN8S2489C19D2Ev
  virtual void  v8(); // _ZN8S2489C192v8Ev
  virtual void  v9(); // _ZN8S2489C192v9Ev
  virtual void  v10(); // _ZN8S2489C193v10Ev
  S2489C19(); // tgen
};
//SIG(-1 S2489C19) C1{ VBC2{ VBC3{ m Fc Fi FL FU4{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} VBC5{ VBC3 v4 v5 Fp Fp Fi Fi FU6{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU6 Fp FL:3 FC3 FL FU6} vd v6 FL FL FL FL Fi FU6 Fc[10] Fi} BC7{ BC3 VBC5 VBC2 VBC8{ BC3 BC5 v7 Fp FD FC3[7] FD FU4 Fs FL FL} vd v8 Fc Fi[7] Fl[5] FL FL FL FU9{ m Fp Fi Fp Fc Fc FL[5] Fp Fp Fp}} BC3 BC5 vd v1 v2 v3 FU6 Fi Fl Fc Fp FC8 Fs}


 S2489C19 ::~S2489C19(){ note_dtor("S2489C19", this);}
void  S2489C19 ::v8(){vfunc_called(this, "_ZN8S2489C192v8Ev");}
void  S2489C19 ::v9(){vfunc_called(this, "_ZN8S2489C192v9Ev");}
void  S2489C19 ::v10(){vfunc_called(this, "_ZN8S2489C193v10Ev");}
S2489C19 ::S2489C19(){ note_ctor("S2489C19", this);} // tgen

static void Test_S2489C19()
{
  extern Class_Descriptor cd_S2489C19;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(301,672)];
    init_test(&cd_S2489C19, buf);
    S2489C19 *dp, &lv = *(dp=new (buf) S2489C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(4800,2684), "sizeof(S2489C19)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2489C19)");
    check_base_class_offset(lv, (S2489C3*)(S2489C8*), ABISELECT(2720,1540), "S2489C19");
    /*is_ambiguous_... S2489C19::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*), ABISELECT(2720,1540), "S2489C19");
    check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C5*), ABISELECT(2720,1540), "S2489C19");
    /*is_ambiguous_... S2489C19::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*), ABISELECT(2720,1540), "S2489C19");
    check_base_class_offset(lv, (S2489C6*)(S2489C8*), ABISELECT(2848,1612), "S2489C19");
    /*is_ambiguous_... S2489C10::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*), ABISELECT(2848,1612), "S2489C19");
    check_base_class_offset(lv, (S2489C8*), ABISELECT(2600,1456), "S2489C19");
    check_base_class_offset(lv, (S2489C8*)(S2489C10*), ABISELECT(2600,1456), "S2489C19");
    /*is_ambiguous_... S2489C10::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*), ABISELECT(16,4), "S2489C19");
    /*is_ambiguous_... S2489C5::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C5*), ABISELECT(3616,2020), "S2489C19");
    check_base_class_offset(lv, (S2489C6*)(S2489C5*), ABISELECT(3232,1816), "S2489C19");
    check_base_class_offset(lv, (S2489C5*)(S2489C10*), ABISELECT(3232,1816), "S2489C19");
    check_base_class_offset(lv, (S2489C10*), 0, "S2489C19");
    /*is_ambiguous_... S2489C19::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*), ABISELECT(288,192), "S2489C19");
    /*is_ambiguous_... S2489C19::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*), ABISELECT(416,264), "S2489C19");
    check_field_offset(lv, s2489c19f0, ABISELECT(800,468), "S2489C19.s2489c19f0");
    check_field_offset(lv, s2489c19f1, ABISELECT(856,496), "S2489C19.s2489c19f1");
    check_field_offset(lv, s2489c19f2, ABISELECT(864,500), "S2489C19.s2489c19f2");
    check_field_offset(lv, s2489c19f3, ABISELECT(872,504), "S2489C19.s2489c19f3");
    check_field_offset(lv, s2489c19f4, ABISELECT(880,508), "S2489C19.s2489c19f4");
    check_field_offset(lv, s2489c19f5, ABISELECT(896,512), "S2489C19.s2489c19f5");
    check_field_offset(lv, s2489c19f6, ABISELECT(2592,1452), "S2489C19.s2489c19f6");
    test_class_info(&lv, &cd_S2489C19);
    dp->~S2489C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2489C19(Test_S2489C19, "S2489C19", ABISELECT(4800,2684));

#else // __cplusplus

extern void _ZN8S2489C19C1Ev();
extern void _ZN8S2489C19D2Ev();
Name_Map name_map_S2489C19[] = {
  NSPAIR(_ZN8S2489C19C1Ev),
  NSPAIR(_ZN8S2489C19D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C8;
extern VTBL_ENTRY _ZTI7S2489C8[];
extern  VTBL_ENTRY _ZTV7S2489C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C8[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C5;
extern VTBL_ENTRY _ZTI7S2489C5[];
extern  VTBL_ENTRY _ZTV7S2489C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C5[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
static Base_Class bases_S2489C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C3,    ABISELECT(2720,1540), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S2489C6,    ABISELECT(2848,1612), //bcp->offset
    26, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S2489C8,    ABISELECT(2600,1456), //bcp->offset
    17, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C3,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(3616,2020), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2489C6,    ABISELECT(3232,1816), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2489C5,    ABISELECT(3232,1816), //bcp->offset
    33, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S2489C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2489C3,    ABISELECT(288,192), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2489C6,    ABISELECT(416,264), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S2489C19[];
extern void _ZN8S2489C19D1Ev();
extern void _ZN8S2489C19D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev)();
extern void ABISELECT(_ZThn2600_N8S2489C19D1Ev,_ZThn1456_N8S2489C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev)();
extern void ABISELECT(_ZThn2600_N8S2489C19D0Ev,_ZThn1456_N8S2489C19D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY vtc_S2489C19[] = {
  ABISELECT(3232,1816),
  ABISELECT(2600,1456),
  ABISELECT(2720,1540),
  ABISELECT(2848,1612),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN8S2489C19D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C19D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
  ABISELECT(2304,1276),
  ABISELECT(-416,-264),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  0,
  ABISELECT(-2600,-1456),
  ABISELECT(248,156),
  ABISELECT(120,84),
  ABISELECT(-2600,-1456),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-2848,-1612),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  0,
  0,
  0,
  ABISELECT(-512,-276),
  ABISELECT(-3232,-1816),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern VTBL_ENTRY _ZTV8S2489C19[];
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C10__8S2489C19[] = {
  ABISELECT(3232,1816),
  ABISELECT(2600,1456),
  ABISELECT(2720,1540),
  ABISELECT(2848,1612),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C10__8S2489C19[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-2848,-1612),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZThn2600_N8S2489C10D1Ev,_ZThn1456_N8S2489C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void ABISELECT(_ZThn2600_N8S2489C10D0Ev,_ZThn1456_N8S2489C10D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C10__8S2489C19[] = {
  0,
  ABISELECT(-2600,-1456),
  ABISELECT(248,156),
  ABISELECT(120,84),
  ABISELECT(-2600,-1456),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C10__8S2489C19[] = {
  0,
  0,
  0,
  ABISELECT(-512,-276),
  ABISELECT(-3232,-1816),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A__8S2489C19[] = {
  ABISELECT(2304,1276),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C8D1Ev();
extern void _ZN7S2489C8D0Ev();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C19[] = {
  ABISELECT(248,156),
  ABISELECT(120,84),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C8__8S2489C19[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-248,-156),
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C19[] = {
  ABISELECT(-128,-72),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C19[] = {
  ABISELECT(-512,-276),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C5[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C67S2489C5__A1__8S2489C19[] = {
  ABISELECT(-512,-276),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
static  VTT_ENTRY vtt_S2489C19[] = {
  {&(_ZTV8S2489C19[6]),  6,42},
  {&(_tg__ZTV8S2489C10__8S2489C19[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C10__8S2489C19[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C10__8S2489C19[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C10__8S2489C19[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A__8S2489C19[3]),  3,5},
  {&(_ZTV8S2489C19[23]),  23,42},
  {&(_ZTV8S2489C19[31]),  31,42},
  {&(_ZTV8S2489C19[39]),  39,42},
  {&(_ZTV8S2489C19[15]),  15,42},
  {&(_tg__ZTV7S2489C8__8S2489C19[4]),  4,7},
  {&(_tg__ZTV7S2489C6__7S2489C8__8S2489C19[5]),  5,7},
  {&(_tg__ZTV7S2489C6__8S2489C19[3]),  3,5},
  {&(_tg__ZTV7S2489C5__8S2489C19[3]),  3,6},
  {&(_tg__ZTV7S2489C67S2489C5__A1__8S2489C19[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S2489C19[];
extern  VTBL_ENTRY _ZTV8S2489C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C19[];
static VTBL_ENTRY alt_thunk_names5[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2600_N8S2489C10D0Ev,_ZThn1456_N8S2489C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2600_N8S2489C10D1Ev,_ZThn1456_N8S2489C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2600_N8S2489C19D0Ev,_ZThn1456_N8S2489C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2600_N8S2489C19D1Ev,_ZThn1456_N8S2489C19D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S2489C19 = {  "S2489C19", // class name
  bases_S2489C19, 10,
  &(vtc_S2489C19[0]), // expected_vtbl_contents
  &(vtt_S2489C19[0]), // expected_vtt_contents
  ABISELECT(4800,2684), // object size
  NSPAIRA(_ZTI8S2489C19),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S2489C19),42, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S2489C19),15, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names5,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2489C21  : S2489C3 , virtual S2489C6 , virtual S2489C8 , virtual S2489C5 , virtual S2489C19 {
  __tsi64 s2489c21f0;
  int s2489c21f1;
  void *s2489c21f2;
  void *s2489c21f3;
  __tsi64 s2489c21f4;
  virtual  ~S2489C21(); // _ZN8S2489C21D2Ev
  S2489C21(); // tgen
};
//SIG(-1 S2489C21) C1{ BC2{ m Fc Fi FL FU3{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} VBC4{ VBC2 v1 v2 Fp Fp Fi Fi FU5{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU5 Fp FL:3 FC2 FL FU5} VBC6{ VBC2 VBC4 vd v3 FL FL FL FL Fi FU5 Fc[10] Fi} VBC7{ BC2 BC4 v4 Fp FD FC2[7] FD FU3 Fs FL FL} VBC8{ VBC6 BC9{ BC2 VBC4 VBC6 VBC7 vd v5 Fc Fi[7] Fl[5] FL FL FL FU10{ m Fp Fi Fp Fc Fc FL[5] Fp Fp Fp}} BC2 BC4 vd v6 v7 v8 FU5 Fi Fl Fc Fp FC7 Fs} vd FL Fi Fp Fp FL}


 S2489C21 ::~S2489C21(){ note_dtor("S2489C21", this);}
S2489C21 ::S2489C21(){ note_ctor("S2489C21", this);} // tgen

static void Test_S2489C21()
{
  extern Class_Descriptor cd_S2489C21;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(314,698)];
    init_test(&cd_S2489C21, buf);
    S2489C21 *dp, &lv = *(dp=new (buf) S2489C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(5008,2788), "sizeof(S2489C21)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2489C21)");
    /*is_ambiguous_... S2489C21::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*), ABISELECT(16,4), "S2489C21");
    /*is_ambiguous_... S2489C21::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*), ABISELECT(576,308), "S2489C21");
    check_base_class_offset(lv, (S2489C3*)(S2489C8*), ABISELECT(576,308), "S2489C21");
    check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C5*), ABISELECT(576,308), "S2489C21");
    /*is_ambiguous_... S2489C19::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C19*), ABISELECT(576,308), "S2489C21");
    /*is_ambiguous_... S2489C21::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*), ABISELECT(192,104), "S2489C21");
    check_base_class_offset(lv, (S2489C6*)(S2489C8*), ABISELECT(192,104), "S2489C21");
    /*is_ambiguous_... S2489C10::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*)(S2489C19*), ABISELECT(192,104), "S2489C21");
    check_base_class_offset(lv, (S2489C8*), ABISELECT(704,380), "S2489C21");
    check_base_class_offset(lv, (S2489C8*)(S2489C19*), ABISELECT(704,380), "S2489C21");
    check_base_class_offset(lv, (S2489C8*)(S2489C10*)(S2489C19*), ABISELECT(704,380), "S2489C21");
    /*is_ambiguous_... S2489C5::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C5*), ABISELECT(1216,668), "S2489C21");
    check_base_class_offset(lv, (S2489C6*)(S2489C5*), ABISELECT(832,464), "S2489C21");
    check_base_class_offset(lv, (S2489C5*), ABISELECT(832,464), "S2489C21");
    check_base_class_offset(lv, (S2489C5*)(S2489C10*)(S2489C19*), ABISELECT(832,464), "S2489C21");
    /*is_ambiguous_... S2489C10::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*)(S2489C19*), ABISELECT(2416,1336), "S2489C21");
    check_base_class_offset(lv, (S2489C10*)(S2489C19*), ABISELECT(2400,1332), "S2489C21");
    /*is_ambiguous_... S2489C19::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C19*), ABISELECT(2688,1524), "S2489C21");
    /*is_ambiguous_... S2489C19::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C19*), ABISELECT(2816,1596), "S2489C21");
    check_base_class_offset(lv, (S2489C19*), ABISELECT(2400,1332), "S2489C21");
    check_field_offset(lv, s2489c21f0, ABISELECT(144,76), "S2489C21.s2489c21f0");
    check_field_offset(lv, s2489c21f1, ABISELECT(152,84), "S2489C21.s2489c21f1");
    check_field_offset(lv, s2489c21f2, ABISELECT(160,88), "S2489C21.s2489c21f2");
    check_field_offset(lv, s2489c21f3, ABISELECT(168,92), "S2489C21.s2489c21f3");
    check_field_offset(lv, s2489c21f4, ABISELECT(176,96), "S2489C21.s2489c21f4");
    test_class_info(&lv, &cd_S2489C21);
    dp->~S2489C21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2489C21(Test_S2489C21, "S2489C21", ABISELECT(5008,2788));

#else // __cplusplus

extern void _ZN8S2489C21C1Ev();
extern void _ZN8S2489C21D2Ev();
Name_Map name_map_S2489C21[] = {
  NSPAIR(_ZN8S2489C21C1Ev),
  NSPAIR(_ZN8S2489C21D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C8;
extern VTBL_ENTRY _ZTI7S2489C8[];
extern  VTBL_ENTRY _ZTV7S2489C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C8[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C5;
extern VTBL_ENTRY _ZTI7S2489C5[];
extern  VTBL_ENTRY _ZTV7S2489C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C5[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C19;
extern VTBL_ENTRY _ZTI8S2489C19[];
extern  VTBL_ENTRY _ZTV8S2489C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C19[];
static Base_Class bases_S2489C21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C3,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2489C3,    ABISELECT(576,308), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S2489C6,    ABISELECT(192,104), //bcp->offset
    9, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C8,    ABISELECT(704,380), //bcp->offset
    16, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C3,    ABISELECT(1216,668), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2489C6,    ABISELECT(832,464), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2489C5,    ABISELECT(832,464), //bcp->offset
    25, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C3,    ABISELECT(2416,1336), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S2489C10,    ABISELECT(2400,1332), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(2688,1524), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S2489C6,    ABISELECT(2816,1596), //bcp->offset
    53, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S2489C19,    ABISELECT(2400,1332), //bcp->offset
    34, //bcp->virtual_function_table_offset
    13, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S2489C21[];
extern void _ZN8S2489C21D1Ev();
extern void _ZN8S2489C21D0Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev)();
extern void ABISELECT(_ZThn704_N8S2489C21D1Ev,_ZThn380_N8S2489C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev)();
extern void ABISELECT(_ZThn704_N8S2489C21D0Ev,_ZThn380_N8S2489C21D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
extern void ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev)();
extern void ABISELECT(_ZThn2400_N8S2489C21D1Ev,_ZThn1332_N8S2489C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev)();
extern void ABISELECT(_ZThn2400_N8S2489C21D0Ev,_ZThn1332_N8S2489C21D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY vtc_S2489C21[] = {
  ABISELECT(2400,1332),
  ABISELECT(832,464),
  ABISELECT(704,380),
  ABISELECT(576,308),
  ABISELECT(192,104),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN8S2489C21D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C21D0Ev,
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(-192,-104),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  0,
  ABISELECT(-704,-380),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(-704,-380),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-832,-464),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(-2400,-1332),
  ABISELECT(-1568,-868),
  ABISELECT(-1696,-952),
  ABISELECT(-1824,-1024),
  ABISELECT(-2208,-1228),
  ABISELECT(-2400,-1332),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
  ABISELECT(-2240,-1288),
  ABISELECT(-2816,-1596),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern VTBL_ENTRY _ZTV8S2489C21[];
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C21[] = {
  ABISELECT(384,204),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C8D1Ev();
extern void _ZN7S2489C8D0Ev();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C21[] = {
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C8__8S2489C21[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(512,276),
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C21[] = {
  ABISELECT(-256,-156),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C5[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C67S2489C5__A1__8S2489C21[] = {
  ABISELECT(-256,-156),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C19D1Ev();
extern void _ZN8S2489C19D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__8S2489C21[] = {
  ABISELECT(-1568,-868),
  ABISELECT(-1696,-952),
  ABISELECT(-1824,-1024),
  ABISELECT(-2208,-1228),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN8S2489C19D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C19D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C108S2489C19__8S2489C21[] = {
  ABISELECT(-1568,-868),
  ABISELECT(-1696,-952),
  ABISELECT(-1824,-1024),
  ABISELECT(-2208,-1228),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C108S2489C19__8S2489C21[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(2208,1228),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C108S2489C19__8S2489C21[] = {
  0,
  ABISELECT(1696,952),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(1696,952),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C108S2489C19__8S2489C21[] = {
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(1568,868),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A2__8S2489C21[] = {
  ABISELECT(-2240,-1288),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C19__8S2489C21[] = {
  0,
  ABISELECT(1696,952),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(1696,952),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C19__8S2489C21[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(2208,1228),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C19__8S2489C21[] = {
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(1568,868),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A__8S2489C19__8S2489C21[] = {
  ABISELECT(-2240,-1288),
  ABISELECT(-416,-264),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
static  VTT_ENTRY vtt_S2489C21[] = {
  {&(_ZTV8S2489C21[7]),  7,58},
  {&(_ZTV8S2489C21[14]),  14,58},
  {&(_ZTV8S2489C21[22]),  22,58},
  {&(_ZTV8S2489C21[31]),  31,58},
  {&(_ZTV8S2489C21[47]),  47,58},
  {&(_ZTV8S2489C21[56]),  56,58},
  {&(_tg__ZTV7S2489C6__8S2489C21[3]),  3,5},
  {&(_tg__ZTV7S2489C8__8S2489C21[4]),  4,7},
  {&(_tg__ZTV7S2489C6__7S2489C8__8S2489C21[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C21[3]),  3,6},
  {&(_tg__ZTV7S2489C67S2489C5__A1__8S2489C21[3]),  3,5},
  {&(_tg__ZTV8S2489C19__8S2489C21[6]),  6,12},
  {&(_tg__ZTV8S2489C108S2489C19__8S2489C21[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C108S2489C19__8S2489C21[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C108S2489C19__8S2489C21[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C108S2489C19__8S2489C21[6]),  6,9},
  {&(_tg__ZTV7S2489C68S2489C19__A2__8S2489C21[3]),  3,5},
  {&(_tg__ZTV7S2489C8__8S2489C19__8S2489C21[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C19__8S2489C21[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C19__8S2489C21[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A__8S2489C19__8S2489C21[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S2489C21[];
extern  VTBL_ENTRY _ZTV8S2489C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C21[];
static VTBL_ENTRY alt_thunk_names6[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2400_N8S2489C21D0Ev,_ZThn1332_N8S2489C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2400_N8S2489C21D1Ev,_ZThn1332_N8S2489C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn704_N8S2489C21D0Ev,_ZThn380_N8S2489C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn704_N8S2489C21D1Ev,_ZThn380_N8S2489C21D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S2489C21 = {  "S2489C21", // class name
  bases_S2489C21, 12,
  &(vtc_S2489C21[0]), // expected_vtbl_contents
  &(vtt_S2489C21[0]), // expected_vtt_contents
  ABISELECT(5008,2788), // object size
  NSPAIRA(_ZTI8S2489C21),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S2489C21),58, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S2489C21),21, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names6,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2489C20  : virtual S2489C5 , virtual S2489C6 , virtual S2489C8 , S2489C9 , virtual S2489C13 {
  char s2489c20f0;
  short s2489c20f1[3];
  ::S2489C21 s2489c20f2[10];
  ::S2489C5 s2489c20f3;
  __tsi64 s2489c20f4;
  __tsi64 s2489c20f5:5;
  int s2489c20f6;
  void *s2489c20f7[6];
  __tsi64 s2489c20f8[2];
  __tsi64 s2489c20f9;
  int s2489c20f10;
  virtual  ~S2489C20(); // _ZN8S2489C20D2Ev
  S2489C20(); // tgen
};
//SIG(-1 S2489C20) C1{ VBC2{ BC3{ m Fc Fi FL FU4{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} BC5{ VBC3 v1 v2 Fp Fp Fi Fi FU6{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU6 Fp FL:3 FC3 FL FU6} v3 Fp FD FC3[7] FD FU4 Fs FL FL} VBC5 VBC7{ VBC3 VBC5 vd v4 FL FL FL FL Fi FU6 Fc[10] Fi} BC8{ BC9{ BC3 VBC5 VBC7 VBC2 vd v5 Fc Fi[7] Fl[5] FL FL FL FU10{ m Fp Fi Fp Fc Fc FL[5] Fp Fp Fp}} vd v6 v7 Fp Fp Fp Fi FC11{} FL FL} VBC12{ v8 FD FC13{ VBC2 VBC7 Fi Fp Fi FU6}[6] Fc Fp Fp Fi[6] Fi Fp FL Fp Fi Fp Fp} vd Fc Fs[3] FC14{ BC3 VBC5 VBC7 VBC2 VBC15{ VBC7 BC9 BC3 BC5 vd v9 v10 v11 FU6 Fi Fl Fc Fp FC2 Fs} vd FL Fi Fp Fp FL}[10] FC2 FL FL:5 Fi Fp[6] FL[2] FL Fi}


 S2489C20 ::~S2489C20(){ note_dtor("S2489C20", this);}
S2489C20 ::S2489C20(){ note_ctor("S2489C20", this);} // tgen

static void Test_S2489C20()
{
  extern Class_Descriptor cd_S2489C20;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(4275,9518)];
    init_test(&cd_S2489C20, buf);
    S2489C20 *dp, &lv = *(dp=new (buf) S2489C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(68384,38068), "sizeof(S2489C20)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2489C20)");
    /*is_ambiguous_... S2489C5::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C5*), ABISELECT(52592,29328), "S2489C20");
    check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C5*), ABISELECT(53776,29992), "S2489C20");
    /*is_ambiguous_... S2489C20::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*), ABISELECT(53776,29992), "S2489C20");
    check_base_class_offset(lv, (S2489C3*)(S2489C8*), ABISELECT(53776,29992), "S2489C20");
    check_base_class_offset(lv, (S2489C6*)(S2489C5*), ABISELECT(52208,29124), "S2489C20");
    check_base_class_offset(lv, (S2489C5*), ABISELECT(52208,29124), "S2489C20");
    check_base_class_offset(lv, (S2489C5*)(S2489C10*)(S2489C9*), ABISELECT(52208,29124), "S2489C20");
    /*is_ambiguous_... S2489C20::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*), ABISELECT(53904,30064), "S2489C20");
    check_base_class_offset(lv, (S2489C6*)(S2489C8*), ABISELECT(53904,30064), "S2489C20");
    /*is_ambiguous_... S2489C10::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*)(S2489C9*), ABISELECT(53904,30064), "S2489C20");
    check_base_class_offset(lv, (S2489C8*), ABISELECT(54288,30268), "S2489C20");
    check_base_class_offset(lv, (S2489C8*)(S2489C10*)(S2489C9*), ABISELECT(54288,30268), "S2489C20");
    /*is_ambiguous_... S2489C10::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*)(S2489C9*), ABISELECT(16,4), "S2489C20");
    check_base_class_offset(lv, (S2489C10*)(S2489C9*), 0, "S2489C20");
    check_base_class_offset(lv, (S2489C9*), 0, "S2489C20");
    check_base_class_offset(lv, (S2489C13*), ABISELECT(54416,30352), "S2489C20");
    check_field_offset(lv, s2489c20f0, ABISELECT(328,228), "S2489C20.s2489c20f0");
    check_field_offset(lv, s2489c20f1, ABISELECT(330,230), "S2489C20.s2489c20f1");
    check_field_offset(lv, s2489c20f2, ABISELECT(336,236), "S2489C20.s2489c20f2");
    check_field_offset(lv, s2489c20f3, ABISELECT(50416,28116), "S2489C20.s2489c20f3");
    check_field_offset(lv, s2489c20f4, ABISELECT(52112,29056), "S2489C20.s2489c20f4");
    set_bf_and_test(lv, s2489c20f5, ABISELECT(52120,29064), 0, 5, 1, "S2489C20");
    set_bf_and_test(lv, s2489c20f5, ABISELECT(52120,29064), 0, 5, hide_sll(1LL<<4), "S2489C20");
    check_field_offset(lv, s2489c20f6, ABISELECT(52124,29068), "S2489C20.s2489c20f6");
    check_field_offset(lv, s2489c20f7, ABISELECT(52128,29072), "S2489C20.s2489c20f7");
    check_field_offset(lv, s2489c20f8, ABISELECT(52176,29096), "S2489C20.s2489c20f8");
    check_field_offset(lv, s2489c20f9, ABISELECT(52192,29112), "S2489C20.s2489c20f9");
    check_field_offset(lv, s2489c20f10, ABISELECT(52200,29120), "S2489C20.s2489c20f10");
    test_class_info(&lv, &cd_S2489C20);
    dp->~S2489C20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2489C20(Test_S2489C20, "S2489C20", ABISELECT(68384,38068));

#else // __cplusplus

extern void _ZN8S2489C20C1Ev();
extern void _ZN8S2489C20D2Ev();
Name_Map name_map_S2489C20[] = {
  NSPAIR(_ZN8S2489C20C1Ev),
  NSPAIR(_ZN8S2489C20D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C5;
extern VTBL_ENTRY _ZTI7S2489C5[];
extern  VTBL_ENTRY _ZTV7S2489C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C5[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C8;
extern VTBL_ENTRY _ZTI7S2489C8[];
extern  VTBL_ENTRY _ZTV7S2489C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C8[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C9;
extern VTBL_ENTRY _ZTI7S2489C9[];
extern  VTBL_ENTRY _ZTV7S2489C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C9[];
extern Class_Descriptor cd_S2489C13;
extern VTBL_ENTRY _ZTI8S2489C13[];
extern  VTBL_ENTRY _ZTV8S2489C13[];
static Base_Class bases_S2489C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C3,    ABISELECT(52592,29328), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(53776,29992), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S2489C6,    ABISELECT(52208,29124), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2489C5,    ABISELECT(52208,29124), //bcp->offset
    12, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C6,    ABISELECT(53904,30064), //bcp->offset
    21, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C8,    ABISELECT(54288,30268), //bcp->offset
    28, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C3,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S2489C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S2489C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2489C13,    ABISELECT(54416,30352), //bcp->offset
    37, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S2489C20[];
extern void _ZN8S2489C20D1Ev();
extern void _ZN8S2489C20D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void ABISELECT(_ZTv0_n40_N8S2489C20D1Ev,_ZTv0_n20_N8S2489C20D1Ev)();
extern void ABISELECT(_ZThn54288_N8S2489C20D1Ev,_ZThn30268_N8S2489C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C20D0Ev,_ZTv0_n20_N8S2489C20D0Ev)();
extern void ABISELECT(_ZThn54288_N8S2489C20D0Ev,_ZThn30268_N8S2489C20D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
extern void _ZN8S2489C133v11Ev();
static  VTBL_ENTRY vtc_S2489C20[] = {
  ABISELECT(54416,30352),
  ABISELECT(52208,29124),
  ABISELECT(54288,30268),
  ABISELECT(53776,29992),
  ABISELECT(53904,30064),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN8S2489C20D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C20D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(-52208,-29124),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-53904,-30064),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  0,
  ABISELECT(-54288,-30268),
  ABISELECT(-384,-204),
  ABISELECT(-512,-276),
  ABISELECT(-54288,-30268),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C20D1Ev,_ZTv0_n20_N8S2489C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C20D0Ev,_ZTv0_n20_N8S2489C20D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
  0,
  ABISELECT(-54416,-30352),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
};
extern VTBL_ENTRY _ZTV8S2489C20[];
extern void _ZN7S2489C9D1Ev();
extern void _ZN7S2489C9D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C9__8S2489C20[] = {
  ABISELECT(52208,29124),
  ABISELECT(54288,30268),
  ABISELECT(53776,29992),
  ABISELECT(53904,30064),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C107S2489C9__8S2489C20[] = {
  ABISELECT(52208,29124),
  ABISELECT(54288,30268),
  ABISELECT(53776,29992),
  ABISELECT(53904,30064),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C107S2489C9__8S2489C20[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-53904,-30064),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZThn54288_N8S2489C10D1Ev,_ZThn30268_N8S2489C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void ABISELECT(_ZThn54288_N8S2489C10D0Ev,_ZThn30268_N8S2489C10D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C107S2489C9__8S2489C20[] = {
  0,
  ABISELECT(-54288,-30268),
  ABISELECT(-384,-204),
  ABISELECT(-512,-276),
  ABISELECT(-54288,-30268),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C107S2489C9__8S2489C20[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(-52208,-29124),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C9__8S2489C20[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-53904,-30064),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev)();
extern void ABISELECT(_ZThn54288_N7S2489C9D1Ev,_ZThn30268_N7S2489C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev)();
extern void ABISELECT(_ZThn54288_N7S2489C9D0Ev,_ZThn30268_N7S2489C9D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__7S2489C9__8S2489C20[] = {
  0,
  ABISELECT(-54288,-30268),
  ABISELECT(-384,-204),
  ABISELECT(-512,-276),
  ABISELECT(-54288,-30268),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__7S2489C9__8S2489C20[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(-52208,-29124),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C20[] = {
  ABISELECT(1568,868),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C5[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C67S2489C5__8S2489C20[] = {
  ABISELECT(1568,868),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A1__8S2489C20[] = {
  ABISELECT(-128,-72),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C8D1Ev();
extern void _ZN7S2489C8D0Ev();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C20[] = {
  ABISELECT(-384,-204),
  ABISELECT(-512,-276),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C8__8S2489C20[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(384,204),
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
static  VTT_ENTRY vtt_S2489C20[] = {
  {&(_ZTV8S2489C20[7]),  7,41},
  {&(_tg__ZTV7S2489C9__8S2489C20[6]),  6,11},
  {&(_tg__ZTV8S2489C107S2489C9__8S2489C20[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C107S2489C9__8S2489C20[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C107S2489C9__8S2489C20[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C107S2489C9__8S2489C20[6]),  6,9},
  {&(_tg__ZTV7S2489C6__7S2489C9__8S2489C20[5]),  5,7},
  {&(_tg__ZTV7S2489C8__7S2489C9__8S2489C20[6]),  6,9},
  {&(_tg__ZTV7S2489C5__7S2489C9__8S2489C20[6]),  6,9},
  {&(_ZTV8S2489C20[18]),  18,41},
  {&(_ZTV8S2489C20[26]),  26,41},
  {&(_ZTV8S2489C20[34]),  34,41},
  {&(_ZTV8S2489C20[40]),  40,41},
  {&(_tg__ZTV7S2489C5__8S2489C20[3]),  3,6},
  {&(_tg__ZTV7S2489C67S2489C5__8S2489C20[3]),  3,5},
  {&(_tg__ZTV7S2489C6__A1__8S2489C20[3]),  3,5},
  {&(_tg__ZTV7S2489C8__8S2489C20[4]),  4,7},
  {&(_tg__ZTV7S2489C6__7S2489C8__8S2489C20[5]),  5,7},
};
extern VTBL_ENTRY _ZTI8S2489C20[];
extern  VTBL_ENTRY _ZTV8S2489C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C20[];
static VTBL_ENTRY alt_thunk_names7[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn54288_N7S2489C9D0Ev,_ZThn30268_N7S2489C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn54288_N7S2489C9D1Ev,_ZThn30268_N7S2489C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn54288_N8S2489C10D0Ev,_ZThn30268_N8S2489C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn54288_N8S2489C10D1Ev,_ZThn30268_N8S2489C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C20D0Ev,_ZTv0_n20_N8S2489C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn54288_N8S2489C20D0Ev,_ZThn30268_N8S2489C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C20D1Ev,_ZTv0_n20_N8S2489C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn54288_N8S2489C20D1Ev,_ZThn30268_N8S2489C20D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S2489C20 = {  "S2489C20", // class name
  bases_S2489C20, 10,
  &(vtc_S2489C20[0]), // expected_vtbl_contents
  &(vtt_S2489C20[0]), // expected_vtt_contents
  ABISELECT(68384,38068), // object size
  NSPAIRA(_ZTI8S2489C20),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S2489C20),41, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S2489C20),18, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names7,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2489C17  : S2489C18 , S2489C19 , virtual S2489C20 , S2489C21 {
  int s2489c17f0;
  long double s2489c17f1;
  long s2489c17f2;
  char s2489c17f3:3;
  void *s2489c17f4;
  ::S2489C6 s2489c17f5;
  virtual  ~S2489C17(); // _ZN8S2489C17D2Ev
  virtual void  v12(); // _ZN8S2489C173v12Ev
  virtual void  v13(); // _ZN8S2489C173v13Ev
  S2489C17(); // tgen
};
//SIG(-1 S2489C17) C1{ BC2{ vd m FU3{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi}} BC4{ VBC5{ VBC6{ m Fc Fi FL FU3 Fs FL:12 FL Fi} VBC7{ VBC6 v3 v4 Fp Fp Fi Fi FU8{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU8 Fp FL:3 FC6 FL FU8} vd v5 FL FL FL FL Fi FU8 Fc[10] Fi} BC9{ BC6 VBC7 VBC5 VBC10{ BC6 BC7 v6 Fp FD FC6[7] FD FU3 Fs FL FL} vd v7 Fc Fi[7] Fl[5] FL FL FL FU11{ m Fp Fi Fp Fc Fc FL[5] Fp Fp Fp}} BC6 BC7 vd v8 v9 v10 FU8 Fi Fl Fc Fp FC10 Fs} VBC12{ VBC10 VBC7 VBC5 BC13{ BC9 vd v11 v12 Fp Fp Fp Fi FC14{} FL FL} VBC15{ v13 FD FC16{ VBC10 VBC5 Fi Fp Fi FU8}[6] Fc Fp Fp Fi[6] Fi Fp FL Fp Fi Fp Fp} vd Fc Fs[3] FC17{ BC6 VBC7 VBC5 VBC10 VBC4 vd FL Fi Fp Fp FL}[10] FC10 FL FL:5 Fi Fp[6] FL[2] FL Fi} BC17 vd v1 v2 Fi FD Fl Fc:3 Fp FC7}


 S2489C17 ::~S2489C17(){ note_dtor("S2489C17", this);}
void  S2489C17 ::v12(){vfunc_called(this, "_ZN8S2489C173v12Ev");}
void  S2489C17 ::v13(){vfunc_called(this, "_ZN8S2489C173v13Ev");}
S2489C17 ::S2489C17(){ note_ctor("S2489C17", this);} // tgen

static void Test_S2489C17()
{
  extern Class_Descriptor cd_S2489C17;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(4654,10359)];
    init_test(&cd_S2489C17, buf);
    S2489C17 *dp, &lv = *(dp=new (buf) S2489C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(74448,41432), "sizeof(S2489C17)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2489C17)");
    check_base_class_offset(lv, (S2489C18*), 0, "S2489C17");
    check_base_class_offset(lv, (S2489C3*)(S2489C8*), ABISELECT(3584,1992), "S2489C17");
    /*is_ambiguous_... S2489C17::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*), ABISELECT(3584,1992), "S2489C17");
    check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C5*), ABISELECT(3584,1992), "S2489C17");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C19*), ABISELECT(3584,1992), "S2489C17");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C19*), ABISELECT(3584,1992), "S2489C17");
    check_base_class_offset(lv, (S2489C6*)(S2489C8*), ABISELECT(3712,2064), "S2489C17");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*)(S2489C19*), ABISELECT(3712,2064), "S2489C17");
    /*is_ambiguous_... S2489C20::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C20*), ABISELECT(3712,2064), "S2489C17");
    /*is_ambiguous_... S2489C10::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(3712,2064), "S2489C17");
    /*is_ambiguous_... S2489C21::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C21*), ABISELECT(3712,2064), "S2489C17");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*)(S2489C19*), ABISELECT(3712,2064), "S2489C17");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C19*), ABISELECT(3456,1908), "S2489C17");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C10*)(S2489C19*), ABISELECT(3456,1908), "S2489C17");
    check_base_class_offset(lv, (S2489C8*)(S2489C20*), ABISELECT(3456,1908), "S2489C17");
    check_base_class_offset(lv, (S2489C8*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(3456,1908), "S2489C17");
    check_base_class_offset(lv, (S2489C8*)(S2489C21*), ABISELECT(3456,1908), "S2489C17");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C19*), ABISELECT(3456,1908), "S2489C17");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C10*)(S2489C19*), ABISELECT(3456,1908), "S2489C17");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*)(S2489C19*), ABISELECT(112,48), "S2489C17");
    /*is_ambiguous_... S2489C5::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C5*), ABISELECT(4480,2472), "S2489C17");
    check_base_class_offset(lv, (S2489C6*)(S2489C5*), ABISELECT(4096,2268), "S2489C17");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C5*)(S2489C10*)(S2489C19*), ABISELECT(4096,2268), "S2489C17");
    check_base_class_offset(lv, (S2489C5*)(S2489C20*), ABISELECT(4096,2268), "S2489C17");
    check_base_class_offset(lv, (S2489C5*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(4096,2268), "S2489C17");
    check_base_class_offset(lv, (S2489C5*)(S2489C21*), ABISELECT(4096,2268), "S2489C17");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C5*)(S2489C10*)(S2489C19*), ABISELECT(4096,2268), "S2489C17");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C10*)(S2489C19*), ABISELECT(96,44), "S2489C17");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C19*), ABISELECT(384,236), "S2489C17");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C19*), ABISELECT(512,308), "S2489C17");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C19*), ABISELECT(96,44), "S2489C17");
    /*is_ambiguous_... S2489C10::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(5680,3140), "S2489C17");
    check_base_class_offset(lv, (S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(5664,3136), "S2489C17");
    check_base_class_offset(lv, (S2489C9*)(S2489C20*), ABISELECT(5664,3136), "S2489C17");
    check_base_class_offset(lv, (S2489C13*)(S2489C20*), ABISELECT(57872,32260), "S2489C17");
    check_base_class_offset(lv, (S2489C20*), ABISELECT(5664,3136), "S2489C17");
    /*is_ambiguous_... S2489C21::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C21*), ABISELECT(2720,1504), "S2489C17");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*)(S2489C19*), ABISELECT(71856,39980), "S2489C17");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C10*)(S2489C19*), ABISELECT(71840,39976), "S2489C17");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C19*), ABISELECT(72128,40168), "S2489C17");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C19*), ABISELECT(72256,40240), "S2489C17");
    check_base_class_offset(lv, (S2489C19*)(S2489C21*), ABISELECT(71840,39976), "S2489C17");
    check_base_class_offset(lv, (S2489C21*), ABISELECT(2704,1500), "S2489C17");
    check_field_offset(lv, s2489c17f0, ABISELECT(2888,1604), "S2489C17.s2489c17f0");
    check_field_offset(lv, s2489c17f1, ABISELECT(2896,1608), "S2489C17.s2489c17f1");
    check_field_offset(lv, s2489c17f2, ABISELECT(2912,1620), "S2489C17.s2489c17f2");
    set_bf_and_test(lv, s2489c17f3, ABISELECT(2920,1624), 0, 3, 1, "S2489C17");
    set_bf_and_test(lv, s2489c17f3, ABISELECT(2920,1624), 0, 3, hide_sll(1LL<<2), "S2489C17");
    check_field_offset(lv, s2489c17f4, ABISELECT(2928,1628), "S2489C17.s2489c17f4");
    check_field_offset(lv, s2489c17f5, ABISELECT(2944,1632), "S2489C17.s2489c17f5");
    test_class_info(&lv, &cd_S2489C17);
    dp->~S2489C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2489C17(Test_S2489C17, "S2489C17", ABISELECT(74448,41432));

#else // __cplusplus

extern void _ZN8S2489C17C1Ev();
extern void _ZN8S2489C17D2Ev();
Name_Map name_map_S2489C17[] = {
  NSPAIR(_ZN8S2489C17C1Ev),
  NSPAIR(_ZN8S2489C17D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C18;
extern VTBL_ENTRY _ZTI8S2489C18[];
extern  VTBL_ENTRY _ZTV8S2489C18[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C8;
extern VTBL_ENTRY _ZTI7S2489C8[];
extern  VTBL_ENTRY _ZTV7S2489C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C8[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C5;
extern VTBL_ENTRY _ZTI7S2489C5[];
extern  VTBL_ENTRY _ZTV7S2489C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C5[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C19;
extern VTBL_ENTRY _ZTI8S2489C19[];
extern  VTBL_ENTRY _ZTV8S2489C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C19[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C9;
extern VTBL_ENTRY _ZTI7S2489C9[];
extern  VTBL_ENTRY _ZTV7S2489C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C9[];
extern Class_Descriptor cd_S2489C13;
extern VTBL_ENTRY _ZTI8S2489C13[];
extern  VTBL_ENTRY _ZTV8S2489C13[];
extern Class_Descriptor cd_S2489C20;
extern VTBL_ENTRY _ZTI8S2489C20[];
extern  VTBL_ENTRY _ZTV8S2489C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C20[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C19;
extern VTBL_ENTRY _ZTI8S2489C19[];
extern  VTBL_ENTRY _ZTV8S2489C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C19[];
extern Class_Descriptor cd_S2489C21;
extern VTBL_ENTRY _ZTI8S2489C21[];
extern  VTBL_ENTRY _ZTV8S2489C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C21[];
static Base_Class bases_S2489C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2489C3,    ABISELECT(3584,1992), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S2489C6,    ABISELECT(3712,2064), //bcp->offset
    48, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    30, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S2489C8,    ABISELECT(3456,1908), //bcp->offset
    39, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S2489C3,    ABISELECT(112,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(4480,2472), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S2489C6,    ABISELECT(4096,2268), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S2489C5,    ABISELECT(4096,2268), //bcp->offset
    55, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S2489C10,    ABISELECT(96,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(384,236), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S2489C6,    ABISELECT(512,308), //bcp->offset
    25, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S2489C19,    ABISELECT(96,44), //bcp->offset
    13, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2489C3,    ABISELECT(5680,3140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S2489C10,    ABISELECT(5664,3136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S2489C9,    ABISELECT(5664,3136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S2489C13,    ABISELECT(57872,32260), //bcp->offset
    80, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S2489C20,    ABISELECT(5664,3136), //bcp->offset
    64, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C3,    ABISELECT(2720,1504), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(71856,39980), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S2489C10,    ABISELECT(71840,39976), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    47, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(72128,40168), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S2489C6,    ABISELECT(72256,40240), //bcp->offset
    103, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    51, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S2489C19,    ABISELECT(71840,39976), //bcp->offset
    84, //bcp->virtual_function_table_offset
    13, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    46, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    23, //immediately_derived
  0, 1},
  {&cd_S2489C21,    ABISELECT(2704,1500), //bcp->offset
    30, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S2489C17[];
extern void _ZN8S2489C17D1Ev();
extern void _ZN8S2489C17D0Ev();
extern void _ZN8S2489C173v12Ev();
extern void _ZN8S2489C173v13Ev();
extern void ABISELECT(_ZThn96_N8S2489C17D1Ev,_ZThn44_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn96_N8S2489C17D0Ev,_ZThn44_N8S2489C17D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void ABISELECT(_ZThn2704_N8S2489C17D1Ev,_ZThn1500_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn2704_N8S2489C17D0Ev,_ZThn1500_N8S2489C17D0Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C17D1Ev,_ZTv0_n20_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn3456_N8S2489C17D1Ev,_ZThn1908_N8S2489C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C17D0Ev,_ZTv0_n20_N8S2489C17D0Ev)();
extern void ABISELECT(_ZThn3456_N8S2489C17D0Ev,_ZThn1908_N8S2489C17D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
extern void ABISELECT(_ZTv0_n64_N8S2489C17D1Ev,_ZTv0_n32_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn5664_N8S2489C17D1Ev,_ZThn3136_N8S2489C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S2489C17D0Ev,_ZTv0_n32_N8S2489C17D0Ev)();
extern void ABISELECT(_ZThn5664_N8S2489C17D0Ev,_ZThn3136_N8S2489C17D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
extern void _ZN8S2489C133v11Ev();
extern void ABISELECT(_ZTv0_n56_N8S2489C17D1Ev,_ZTv0_n28_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn71840_N8S2489C17D1Ev,_ZThn39976_N8S2489C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C17D0Ev,_ZTv0_n28_N8S2489C17D0Ev)();
extern void ABISELECT(_ZThn71840_N8S2489C17D0Ev,_ZThn39976_N8S2489C17D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY vtc_S2489C17[] = {
  ABISELECT(71840,39976),
  ABISELECT(57872,32260),
  ABISELECT(5664,3136),
  ABISELECT(4096,2268),
  ABISELECT(3712,2064),
  ABISELECT(3584,1992),
  ABISELECT(3456,1908),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN8S2489C17D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C17D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v12Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v13Ev,
  ABISELECT(4000,2224),
  ABISELECT(3360,1864),
  ABISELECT(3488,1948),
  ABISELECT(3616,2020),
  ABISELECT(-96,-44),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C17D1Ev,_ZThn44_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C17D0Ev,_ZThn44_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
  ABISELECT(3072,1684),
  ABISELECT(-512,-308),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  ABISELECT(69136,38476),
  ABISELECT(1392,768),
  ABISELECT(752,408),
  ABISELECT(880,492),
  ABISELECT(1008,564),
  ABISELECT(-2704,-1500),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S2489C17D1Ev,_ZThn1500_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S2489C17D0Ev,_ZThn1500_N8S2489C17D0Ev),
  0,
  ABISELECT(-3456,-1908),
  ABISELECT(256,156),
  ABISELECT(128,84),
  ABISELECT(-3456,-1908),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C17D1Ev,_ZTv0_n20_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C17D0Ev,_ZTv0_n20_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-3712,-2064),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  0,
  0,
  0,
  ABISELECT(-512,-276),
  ABISELECT(-4096,-2268),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
  0,
  0,
  0,
  ABISELECT(-5664,-3136),
  ABISELECT(52208,29124),
  ABISELECT(-1568,-868),
  ABISELECT(-2208,-1228),
  ABISELECT(-2080,-1144),
  ABISELECT(-1952,-1072),
  ABISELECT(-5664,-3136),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C17D1Ev,_ZTv0_n32_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C17D0Ev,_ZTv0_n32_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
  0,
  ABISELECT(-57872,-32260),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(-71840,-39976),
  ABISELECT(-67744,-37708),
  ABISELECT(-68384,-38068),
  ABISELECT(-68256,-37984),
  ABISELECT(-68128,-37912),
  ABISELECT(-71840,-39976),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C17D1Ev,_ZTv0_n28_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C17D0Ev,_ZTv0_n28_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
  ABISELECT(-68672,-38248),
  ABISELECT(-72256,-40240),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern VTBL_ENTRY _ZTV8S2489C17[];
extern void _ZN8S2489C19D1Ev();
extern void _ZN8S2489C19D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A__8S2489C17[] = {
  ABISELECT(4000,2224),
  ABISELECT(3360,1864),
  ABISELECT(3488,1948),
  ABISELECT(3616,2020),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN8S2489C19D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C19D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C108S2489C19__8S2489C17[] = {
  ABISELECT(4000,2224),
  ABISELECT(3360,1864),
  ABISELECT(3488,1948),
  ABISELECT(3616,2020),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C108S2489C19__8S2489C17[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-3616,-2020),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZThn3360_N8S2489C10D1Ev,_ZThn1864_N8S2489C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void ABISELECT(_ZThn3360_N8S2489C10D0Ev,_ZThn1864_N8S2489C10D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C108S2489C19__8S2489C17[] = {
  0,
  ABISELECT(-3360,-1864),
  ABISELECT(256,156),
  ABISELECT(128,84),
  ABISELECT(-3360,-1864),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C108S2489C19__8S2489C17[] = {
  0,
  0,
  0,
  ABISELECT(-512,-276),
  ABISELECT(-4000,-2224),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A2__8S2489C17[] = {
  ABISELECT(3072,1684),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev)();
extern void ABISELECT(_ZThn3360_N8S2489C19D1Ev,_ZThn1864_N8S2489C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev)();
extern void ABISELECT(_ZThn3360_N8S2489C19D0Ev,_ZThn1864_N8S2489C19D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C19__A__8S2489C17[] = {
  0,
  ABISELECT(-3360,-1864),
  ABISELECT(256,156),
  ABISELECT(128,84),
  ABISELECT(-3360,-1864),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C19__A__8S2489C17[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-3616,-2020),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C19__A__8S2489C17[] = {
  0,
  0,
  0,
  ABISELECT(-512,-276),
  ABISELECT(-4000,-2224),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A__8S2489C19__A__8S2489C17[] = {
  ABISELECT(3072,1684),
  ABISELECT(-416,-264),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C21D1Ev();
extern void _ZN8S2489C21D0Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C21__8S2489C17[] = {
  ABISELECT(69136,38476),
  ABISELECT(1392,768),
  ABISELECT(752,408),
  ABISELECT(880,492),
  ABISELECT(1008,564),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN8S2489C21D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C21D0Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C21__8S2489C17[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-1008,-564),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev)();
extern void ABISELECT(_ZThn752_N8S2489C21D1Ev,_ZThn408_N8S2489C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev)();
extern void ABISELECT(_ZThn752_N8S2489C21D0Ev,_ZThn408_N8S2489C21D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C21__8S2489C17[] = {
  0,
  ABISELECT(-752,-408),
  ABISELECT(256,156),
  ABISELECT(128,84),
  ABISELECT(-752,-408),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C21__8S2489C17[] = {
  0,
  0,
  0,
  ABISELECT(-512,-276),
  ABISELECT(-1392,-768),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev)();
extern void ABISELECT(_ZThn69136_N8S2489C21D1Ev,_ZThn38476_N8S2489C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev)();
extern void ABISELECT(_ZThn69136_N8S2489C21D0Ev,_ZThn38476_N8S2489C21D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__8S2489C21__8S2489C17[] = {
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(-69136,-38476),
  ABISELECT(-67744,-37708),
  ABISELECT(-68384,-38068),
  ABISELECT(-68256,-37984),
  ABISELECT(-68128,-37912),
  ABISELECT(-69136,-38476),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A2__8S2489C21__8S2489C17[] = {
  ABISELECT(-68672,-38248),
  ABISELECT(-69552,-38740),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C8D1Ev();
extern void _ZN7S2489C8D0Ev();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C17[] = {
  ABISELECT(256,156),
  ABISELECT(128,84),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C8__8S2489C17[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-256,-156),
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C17[] = {
  ABISELECT(-128,-72),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C17[] = {
  ABISELECT(-512,-276),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C5[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C67S2489C5__A1__8S2489C17[] = {
  ABISELECT(-512,-276),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C20D1Ev();
extern void _ZN8S2489C20D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C20__8S2489C17[] = {
  ABISELECT(52208,29124),
  ABISELECT(-1568,-868),
  ABISELECT(-2208,-1228),
  ABISELECT(-2080,-1144),
  ABISELECT(-1952,-1072),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN8S2489C20D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C20D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN7S2489C9D1Ev();
extern void _ZN7S2489C9D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C98S2489C20__8S2489C17[] = {
  ABISELECT(-1568,-868),
  ABISELECT(-2208,-1228),
  ABISELECT(-2080,-1144),
  ABISELECT(-1952,-1072),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C107S2489C98S2489C20__A1__8S2489C17[] = {
  ABISELECT(-1568,-868),
  ABISELECT(-2208,-1228),
  ABISELECT(-2080,-1144),
  ABISELECT(-1952,-1072),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C107S2489C98S2489C20__A1__8S2489C17[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(1952,1072),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C107S2489C98S2489C20__A1__8S2489C17[] = {
  0,
  ABISELECT(2208,1228),
  ABISELECT(256,156),
  ABISELECT(128,84),
  ABISELECT(2208,1228),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C107S2489C98S2489C20__A1__8S2489C17[] = {
  0,
  0,
  0,
  ABISELECT(-512,-276),
  ABISELECT(1568,868),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C98S2489C20__8S2489C17[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(1952,1072),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev)();
extern void ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__7S2489C98S2489C20__8S2489C17[] = {
  0,
  ABISELECT(2208,1228),
  ABISELECT(256,156),
  ABISELECT(128,84),
  ABISELECT(2208,1228),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__7S2489C98S2489C20__8S2489C17[] = {
  0,
  0,
  0,
  ABISELECT(-512,-276),
  ABISELECT(1568,868),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C20__8S2489C17[] = {
  0,
  0,
  0,
  ABISELECT(-512,-276),
  ABISELECT(1568,868),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A1__8S2489C20__8S2489C17[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(1952,1072),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C20D1Ev,_ZTv0_n20_N8S2489C20D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C20D0Ev,_ZTv0_n20_N8S2489C20D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C20__8S2489C17[] = {
  0,
  ABISELECT(2208,1228),
  ABISELECT(256,156),
  ABISELECT(128,84),
  ABISELECT(2208,1228),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C20D1Ev,_ZTv0_n20_N8S2489C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C20D0Ev,_ZTv0_n20_N8S2489C20D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN8S2489C133v11Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C13__8S2489C20__8S2489C17[] = {
  0,
  ABISELECT(-52208,-29124),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
};
extern void _ZN8S2489C19D1Ev();
extern void _ZN8S2489C19D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A1__8S2489C17[] = {
  ABISELECT(-67744,-37708),
  ABISELECT(-68384,-38068),
  ABISELECT(-68256,-37984),
  ABISELECT(-68128,-37912),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN8S2489C19D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C19D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C108S2489C19__A2__8S2489C17[] = {
  ABISELECT(-67744,-37708),
  ABISELECT(-68384,-38068),
  ABISELECT(-68256,-37984),
  ABISELECT(-68128,-37912),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C108S2489C19__A2__8S2489C17[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(68128,37912),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C108S2489C19__A2__8S2489C17[] = {
  0,
  ABISELECT(68384,38068),
  ABISELECT(256,156),
  ABISELECT(128,84),
  ABISELECT(68384,38068),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C108S2489C19__A2__8S2489C17[] = {
  0,
  0,
  0,
  ABISELECT(-512,-276),
  ABISELECT(67744,37708),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A3__8S2489C17[] = {
  ABISELECT(-68672,-38248),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C19__A1__8S2489C17[] = {
  0,
  ABISELECT(68384,38068),
  ABISELECT(256,156),
  ABISELECT(128,84),
  ABISELECT(68384,38068),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C19__A1__8S2489C17[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(68128,37912),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C19__A1__8S2489C17[] = {
  0,
  0,
  0,
  ABISELECT(-512,-276),
  ABISELECT(67744,37708),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A__8S2489C19__A1__8S2489C17[] = {
  ABISELECT(-68672,-38248),
  ABISELECT(-416,-264),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
static  VTT_ENTRY vtt_S2489C17[] = {
  {&(_ZTV8S2489C17[9]),  9,108},
  {&(_tg__ZTV8S2489C19__A__8S2489C17[6]),  6,12},
  {&(_tg__ZTV8S2489C108S2489C19__8S2489C17[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C108S2489C19__8S2489C17[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C108S2489C19__8S2489C17[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C108S2489C19__8S2489C17[6]),  6,9},
  {&(_tg__ZTV7S2489C68S2489C19__A2__8S2489C17[3]),  3,5},
  {&(_tg__ZTV7S2489C8__8S2489C19__A__8S2489C17[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C19__A__8S2489C17[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C19__A__8S2489C17[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A__8S2489C19__A__8S2489C17[3]),  3,5},
  {&(_tg__ZTV8S2489C21__8S2489C17[7]),  7,9},
  {&(_tg__ZTV7S2489C6__8S2489C21__8S2489C17[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C21__8S2489C17[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C21__8S2489C17[6]),  6,9},
  {&(_tg__ZTV8S2489C19__8S2489C21__8S2489C17[13]),  13,19},
  {&(_tg__ZTV7S2489C68S2489C19__A2__8S2489C21__8S2489C17[3]),  3,5},
  {&(_ZTV8S2489C17[19]),  19,108},
  {&(_ZTV8S2489C17[45]),  45,108},
  {&(_ZTV8S2489C17[53]),  53,108},
  {&(_ZTV8S2489C17[61]),  61,108},
  {&(_ZTV8S2489C17[28]),  28,108},
  {&(_ZTV8S2489C17[75]),  75,108},
  {&(_ZTV8S2489C17[83]),  83,108},
  {&(_ZTV8S2489C17[37]),  37,108},
  {&(_ZTV8S2489C17[97]),  97,108},
  {&(_ZTV8S2489C17[106]),  106,108},
  {&(_tg__ZTV7S2489C8__8S2489C17[4]),  4,7},
  {&(_tg__ZTV7S2489C6__7S2489C8__8S2489C17[5]),  5,7},
  {&(_tg__ZTV7S2489C6__8S2489C17[3]),  3,5},
  {&(_tg__ZTV7S2489C5__8S2489C17[3]),  3,6},
  {&(_tg__ZTV7S2489C67S2489C5__A1__8S2489C17[3]),  3,5},
  {&(_tg__ZTV8S2489C20__8S2489C17[7]),  7,12},
  {&(_tg__ZTV7S2489C98S2489C20__8S2489C17[6]),  6,11},
  {&(_tg__ZTV8S2489C107S2489C98S2489C20__A1__8S2489C17[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C107S2489C98S2489C20__A1__8S2489C17[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C107S2489C98S2489C20__A1__8S2489C17[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C107S2489C98S2489C20__A1__8S2489C17[6]),  6,9},
  {&(_tg__ZTV7S2489C6__7S2489C98S2489C20__8S2489C17[5]),  5,7},
  {&(_tg__ZTV7S2489C8__7S2489C98S2489C20__8S2489C17[6]),  6,9},
  {&(_tg__ZTV7S2489C5__7S2489C98S2489C20__8S2489C17[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C20__8S2489C17[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A1__8S2489C20__8S2489C17[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C20__8S2489C17[6]),  6,9},
  {&(_tg__ZTV8S2489C13__8S2489C20__8S2489C17[3]),  3,4},
  {&(_tg__ZTV8S2489C19__A1__8S2489C17[6]),  6,12},
  {&(_tg__ZTV8S2489C108S2489C19__A2__8S2489C17[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C108S2489C19__A2__8S2489C17[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C108S2489C19__A2__8S2489C17[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C108S2489C19__A2__8S2489C17[6]),  6,9},
  {&(_tg__ZTV7S2489C68S2489C19__A3__8S2489C17[3]),  3,5},
  {&(_tg__ZTV7S2489C8__8S2489C19__A1__8S2489C17[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C19__A1__8S2489C17[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C19__A1__8S2489C17[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A__8S2489C19__A1__8S2489C17[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S2489C17[];
extern  VTBL_ENTRY _ZTV8S2489C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C17[];
static VTBL_ENTRY alt_thunk_names8[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn69136_N8S2489C21D0Ev,_ZThn38476_N8S2489C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn69136_N8S2489C21D1Ev,_ZThn38476_N8S2489C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn752_N8S2489C21D0Ev,_ZThn408_N8S2489C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn752_N8S2489C21D1Ev,_ZThn408_N8S2489C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3360_N8S2489C19D0Ev,_ZThn1864_N8S2489C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3360_N8S2489C19D1Ev,_ZThn1864_N8S2489C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3360_N8S2489C10D0Ev,_ZThn1864_N8S2489C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3360_N8S2489C10D1Ev,_ZThn1864_N8S2489C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C17D0Ev,_ZTv0_n28_N8S2489C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn71840_N8S2489C17D0Ev,_ZThn39976_N8S2489C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C17D1Ev,_ZTv0_n28_N8S2489C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn71840_N8S2489C17D1Ev,_ZThn39976_N8S2489C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C17D0Ev,_ZTv0_n32_N8S2489C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5664_N8S2489C17D0Ev,_ZThn3136_N8S2489C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C17D1Ev,_ZTv0_n32_N8S2489C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5664_N8S2489C17D1Ev,_ZThn3136_N8S2489C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C17D0Ev,_ZTv0_n20_N8S2489C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3456_N8S2489C17D0Ev,_ZThn1908_N8S2489C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C17D1Ev,_ZTv0_n20_N8S2489C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3456_N8S2489C17D1Ev,_ZThn1908_N8S2489C17D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S2489C17 = {  "S2489C17", // class name
  bases_S2489C17, 24,
  &(vtc_S2489C17[0]), // expected_vtbl_contents
  &(vtt_S2489C17[0]), // expected_vtt_contents
  ABISELECT(74448,41432), // object size
  NSPAIRA(_ZTI8S2489C17),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S2489C17),108, //virtual function table var
  9, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S2489C17),55, //virtual table table var
  16, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names8,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2489C16  : virtual S2489C17 {
  char s2489c16f0;
  void *s2489c16f1;
  __tsi64 s2489c16f2;
  int s2489c16f3;
  int s2489c16f4;
  int s2489c16f5;
  void *s2489c16f6;
  __tsi64 s2489c16f7;
  ::S2489C2 s2489c16f8;
  long double s2489c16f9;
  __tsi64 s2489c16f10;
  int s2489c16f11;
  ~S2489C16(); // tgen
  S2489C16(); // tgen
};
//SIG(-1 S2489C16) C1{ VBC2{ BC3{ vd m FU4{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi}} BC5{ VBC6{ VBC7{ m Fc Fi FL FU4 Fs FL:12 FL Fi} VBC8{ VBC7 v1 v2 Fp Fp Fi Fi FU9{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU9 Fp FL:3 FC7 FL FU9} vd v3 FL FL FL FL Fi FU9 Fc[10] Fi} BC10{ BC7 VBC8 VBC6 VBC11{ BC7 BC8 v4 Fp FD FC7[7] FD FU4 Fs FL FL} vd v5 Fc Fi[7] Fl[5] FL FL FL FU12{ m Fp Fi Fp Fc Fc FL[5] Fp Fp Fp}} BC7 BC8 vd v6 v7 v8 FU9 Fi Fl Fc Fp FC11 Fs} VBC13{ VBC11 VBC8 VBC6 BC14{ BC10 vd v9 v10 Fp Fp Fp Fi FC15{} FL FL} VBC16{ v11 FD FC17{ VBC11 VBC6 Fi Fp Fi FU9}[6] Fc Fp Fp Fi[6] Fi Fp FL Fp Fi Fp Fp} vd Fc Fs[3] FC18{ BC7 VBC8 VBC6 VBC11 VBC5 vd FL Fi Fp Fp FL}[10] FC11 FL FL:5 Fi Fp[6] FL[2] FL Fi} BC18 vd v12 v13 Fi FD Fl Fc:3 Fp FC8} Fc Fp FL Fi Fi Fi Fp FL FC19{ BC7 VBC11 VBC6 BC14 vd FD} FD FL Fi}


S2489C16 ::~S2489C16(){ note_dtor("S2489C16", this);} // tgen
S2489C16 ::S2489C16(){ note_ctor("S2489C16", this);} // tgen

static void Test_S2489C16()
{
  extern Class_Descriptor cd_S2489C16;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(4828,10761)];
    init_test(&cd_S2489C16, buf);
    S2489C16 *dp, &lv = *(dp=new (buf) S2489C16());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(77232,43040), "sizeof(S2489C16)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2489C16)");
    check_base_class_offset(lv, (S2489C18*)(S2489C17*), ABISELECT(2784,1608), "S2489C16");
    check_base_class_offset(lv, (S2489C3*)(S2489C8*), ABISELECT(6368,3600), "S2489C16");
    /*is_ambiguous_... S2489C16::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*), ABISELECT(6368,3600), "S2489C16");
    check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C5*), ABISELECT(6368,3600), "S2489C16");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C19*)(S2489C17*), ABISELECT(6368,3600), "S2489C16");
    /*is_ambiguous_... S2489C16::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C19*), ABISELECT(6368,3600), "S2489C16");
    check_base_class_offset(lv, (S2489C6*)(S2489C8*), ABISELECT(6496,3672), "S2489C16");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*)(S2489C19*)(S2489C17*), ABISELECT(6496,3672), "S2489C16");
    /*is_ambiguous_... S2489C20::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C20*), ABISELECT(6496,3672), "S2489C16");
    /*is_ambiguous_... S2489C10::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(6496,3672), "S2489C16");
    /*is_ambiguous_... S2489C21::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C21*)(S2489C17*), ABISELECT(6496,3672), "S2489C16");
    /*is_ambiguous_... S2489C16::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*)(S2489C19*), ABISELECT(6496,3672), "S2489C16");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C19*)(S2489C17*), ABISELECT(6240,3516), "S2489C16");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C10*)(S2489C19*)(S2489C17*), ABISELECT(6240,3516), "S2489C16");
    check_base_class_offset(lv, (S2489C8*)(S2489C20*), ABISELECT(6240,3516), "S2489C16");
    check_base_class_offset(lv, (S2489C8*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(6240,3516), "S2489C16");
    check_base_class_offset(lv, (S2489C8*)(S2489C21*)(S2489C17*), ABISELECT(6240,3516), "S2489C16");
    /*is_ambiguous_... S2489C16::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C19*), ABISELECT(6240,3516), "S2489C16");
    /*is_ambiguous_... S2489C16::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C10*)(S2489C19*), ABISELECT(6240,3516), "S2489C16");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*)(S2489C19*)(S2489C17*), ABISELECT(2896,1656), "S2489C16");
    /*is_ambiguous_... S2489C5::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C5*), ABISELECT(7264,4080), "S2489C16");
    check_base_class_offset(lv, (S2489C6*)(S2489C5*), ABISELECT(6880,3876), "S2489C16");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C5*)(S2489C10*)(S2489C19*)(S2489C17*), ABISELECT(6880,3876), "S2489C16");
    check_base_class_offset(lv, (S2489C5*)(S2489C20*), ABISELECT(6880,3876), "S2489C16");
    check_base_class_offset(lv, (S2489C5*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(6880,3876), "S2489C16");
    check_base_class_offset(lv, (S2489C5*)(S2489C21*)(S2489C17*), ABISELECT(6880,3876), "S2489C16");
    /*is_ambiguous_... S2489C16::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C5*)(S2489C10*)(S2489C19*), ABISELECT(6880,3876), "S2489C16");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C10*)(S2489C19*)(S2489C17*), ABISELECT(2880,1652), "S2489C16");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C19*)(S2489C17*), ABISELECT(3168,1844), "S2489C16");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C19*)(S2489C17*), ABISELECT(3296,1916), "S2489C16");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C19*)(S2489C17*), ABISELECT(2880,1652), "S2489C16");
    /*is_ambiguous_... S2489C10::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(8464,4748), "S2489C16");
    check_base_class_offset(lv, (S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(8448,4744), "S2489C16");
    check_base_class_offset(lv, (S2489C9*)(S2489C20*), ABISELECT(8448,4744), "S2489C16");
    check_base_class_offset(lv, (S2489C13*)(S2489C20*), ABISELECT(60656,33868), "S2489C16");
    check_base_class_offset(lv, (S2489C20*)(S2489C17*), ABISELECT(8448,4744), "S2489C16");
    /*is_ambiguous_... S2489C21::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C21*)(S2489C17*), ABISELECT(5504,3112), "S2489C16");
    /*is_ambiguous_... S2489C16::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*)(S2489C19*), ABISELECT(74640,41588), "S2489C16");
    /*is_ambiguous_... S2489C16::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C10*)(S2489C19*), ABISELECT(74624,41584), "S2489C16");
    /*is_ambiguous_... S2489C16::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C19*), ABISELECT(74912,41776), "S2489C16");
    /*is_ambiguous_... S2489C16::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C19*), ABISELECT(75040,41848), "S2489C16");
    check_base_class_offset(lv, (S2489C19*)(S2489C21*)(S2489C17*), ABISELECT(74624,41584), "S2489C16");
    check_base_class_offset(lv, (S2489C21*)(S2489C17*), ABISELECT(5488,3108), "S2489C16");
    check_base_class_offset(lv, (S2489C17*), ABISELECT(2784,1608), "S2489C16");
    check_field_offset(lv, s2489c16f0, ABISELECT(8,4), "S2489C16.s2489c16f0");
    check_field_offset(lv, s2489c16f1, ABISELECT(16,8), "S2489C16.s2489c16f1");
    check_field_offset(lv, s2489c16f2, ABISELECT(24,12), "S2489C16.s2489c16f2");
    check_field_offset(lv, s2489c16f3, ABISELECT(32,20), "S2489C16.s2489c16f3");
    check_field_offset(lv, s2489c16f4, ABISELECT(36,24), "S2489C16.s2489c16f4");
    check_field_offset(lv, s2489c16f5, ABISELECT(40,28), "S2489C16.s2489c16f5");
    check_field_offset(lv, s2489c16f6, ABISELECT(48,32), "S2489C16.s2489c16f6");
    check_field_offset(lv, s2489c16f7, ABISELECT(56,36), "S2489C16.s2489c16f7");
    check_field_offset(lv, s2489c16f8, ABISELECT(64,44), "S2489C16.s2489c16f8");
    check_field_offset(lv, s2489c16f9, ABISELECT(2752,1584), "S2489C16.s2489c16f9");
    check_field_offset(lv, s2489c16f10, ABISELECT(2768,1596), "S2489C16.s2489c16f10");
    check_field_offset(lv, s2489c16f11, ABISELECT(2776,1604), "S2489C16.s2489c16f11");
    test_class_info(&lv, &cd_S2489C16);
    dp->~S2489C16();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2489C16(Test_S2489C16, "S2489C16", ABISELECT(77232,43040));

#else // __cplusplus

extern void _ZN8S2489C16C1Ev();
extern void _ZN8S2489C16D1Ev();
Name_Map name_map_S2489C16[] = {
  NSPAIR(_ZN8S2489C16C1Ev),
  NSPAIR(_ZN8S2489C16D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C18;
extern VTBL_ENTRY _ZTI8S2489C18[];
extern  VTBL_ENTRY _ZTV8S2489C18[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C8;
extern VTBL_ENTRY _ZTI7S2489C8[];
extern  VTBL_ENTRY _ZTV7S2489C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C8[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C5;
extern VTBL_ENTRY _ZTI7S2489C5[];
extern  VTBL_ENTRY _ZTV7S2489C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C5[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C19;
extern VTBL_ENTRY _ZTI8S2489C19[];
extern  VTBL_ENTRY _ZTV8S2489C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C19[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C9;
extern VTBL_ENTRY _ZTI7S2489C9[];
extern  VTBL_ENTRY _ZTV7S2489C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C9[];
extern Class_Descriptor cd_S2489C13;
extern VTBL_ENTRY _ZTI8S2489C13[];
extern  VTBL_ENTRY _ZTV8S2489C13[];
extern Class_Descriptor cd_S2489C20;
extern VTBL_ENTRY _ZTI8S2489C20[];
extern  VTBL_ENTRY _ZTV8S2489C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C20[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C19;
extern VTBL_ENTRY _ZTI8S2489C19[];
extern  VTBL_ENTRY _ZTV8S2489C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C19[];
extern Class_Descriptor cd_S2489C21;
extern VTBL_ENTRY _ZTI8S2489C21[];
extern  VTBL_ENTRY _ZTV8S2489C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C21[];
extern Class_Descriptor cd_S2489C17;
extern VTBL_ENTRY _ZTI8S2489C17[];
extern  VTBL_ENTRY _ZTV8S2489C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C17[];
static Base_Class bases_S2489C16[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C18,    ABISELECT(2784,1608), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(6368,3600), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S2489C6,    ABISELECT(6496,3672), //bcp->offset
    69, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    42, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S2489C8,    ABISELECT(6240,3516), //bcp->offset
    60, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S2489C3,    ABISELECT(2896,1656), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(7264,4080), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S2489C6,    ABISELECT(6880,3876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S2489C5,    ABISELECT(6880,3876), //bcp->offset
    76, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    43, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S2489C10,    ABISELECT(2880,1652), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(3168,1844), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S2489C6,    ABISELECT(3296,1916), //bcp->offset
    46, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S2489C19,    ABISELECT(2880,1652), //bcp->offset
    34, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(8464,4748), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S2489C10,    ABISELECT(8448,4744), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    47, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S2489C9,    ABISELECT(8448,4744), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    46, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S2489C13,    ABISELECT(60656,33868), //bcp->offset
    101, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S2489C20,    ABISELECT(8448,4744), //bcp->offset
    85, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    45, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    24, //immediately_derived
  0, 1},
  {&cd_S2489C3,    ABISELECT(5504,3112), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(74640,41588), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S2489C10,    ABISELECT(74624,41584), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    59, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(74912,41776), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S2489C6,    ABISELECT(75040,41848), //bcp->offset
    124, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    63, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S2489C19,    ABISELECT(74624,41584), //bcp->offset
    105, //bcp->virtual_function_table_offset
    13, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    58, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    23, //immediately_derived
  0, 1},
  {&cd_S2489C21,    ABISELECT(5488,3108), //bcp->offset
    51, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S2489C17,    ABISELECT(2784,1608), //bcp->offset
    12, //bcp->virtual_function_table_offset
    18, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S2489C16[];
extern void _ZN8S2489C16D1Ev();
extern void _ZN8S2489C16D0Ev();
extern void ABISELECT(_ZTv0_n80_N8S2489C16D1Ev,_ZTv0_n40_N8S2489C16D1Ev)();
extern void ABISELECT(_ZThn2784_N8S2489C16D1Ev,_ZThn1608_N8S2489C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N8S2489C16D0Ev,_ZTv0_n40_N8S2489C16D0Ev)();
extern void ABISELECT(_ZThn2784_N8S2489C16D0Ev,_ZThn1608_N8S2489C16D0Ev)() __attribute__((weak));
extern void _ZN8S2489C173v12Ev();
extern void _ZN8S2489C173v13Ev();
extern void ABISELECT(_ZTvn96_n80_N8S2489C16D1Ev,_ZTvn44_n40_N8S2489C16D1Ev)();
extern void ABISELECT(_ZTvn96_n80_N8S2489C16D0Ev,_ZTvn44_n40_N8S2489C16D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void ABISELECT(_ZTvn2704_n80_N8S2489C16D1Ev,_ZTvn1500_n40_N8S2489C16D1Ev)();
extern void ABISELECT(_ZTvn2704_n80_N8S2489C16D0Ev,_ZTvn1500_n40_N8S2489C16D0Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C16D1Ev,_ZTv0_n20_N8S2489C16D1Ev)();
extern void ABISELECT(_ZThn6240_N8S2489C16D1Ev,_ZThn3516_N8S2489C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C16D0Ev,_ZTv0_n20_N8S2489C16D0Ev)();
extern void ABISELECT(_ZThn6240_N8S2489C16D0Ev,_ZThn3516_N8S2489C16D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
extern void ABISELECT(_ZTv0_n64_N8S2489C16D1Ev,_ZTv0_n32_N8S2489C16D1Ev)();
extern void ABISELECT(_ZThn8448_N8S2489C16D1Ev,_ZThn4744_N8S2489C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S2489C16D0Ev,_ZTv0_n32_N8S2489C16D0Ev)();
extern void ABISELECT(_ZThn8448_N8S2489C16D0Ev,_ZThn4744_N8S2489C16D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
extern void _ZN8S2489C133v11Ev();
extern void ABISELECT(_ZTv0_n56_N8S2489C16D1Ev,_ZTv0_n28_N8S2489C16D1Ev)();
extern void ABISELECT(_ZThn74624_N8S2489C16D1Ev,_ZThn41584_N8S2489C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C16D0Ev,_ZTv0_n28_N8S2489C16D0Ev)();
extern void ABISELECT(_ZThn74624_N8S2489C16D0Ev,_ZThn41584_N8S2489C16D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY vtc_S2489C16[] = {
  ABISELECT(74624,41584),
  ABISELECT(60656,33868),
  ABISELECT(8448,4744),
  ABISELECT(6880,3876),
  ABISELECT(6496,3672),
  ABISELECT(6368,3600),
  ABISELECT(6240,3516),
  ABISELECT(2784,1608),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&_ZN8S2489C16D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C16D0Ev,
  ABISELECT(512,308),
  ABISELECT(512,308),
  ABISELECT(96,44),
  ABISELECT(96,44),
  ABISELECT(96,44),
  ABISELECT(96,44),
  0,
  0,
  ABISELECT(-2784,-1608),
  ABISELECT(71840,39976),
  ABISELECT(57872,32260),
  ABISELECT(5664,3136),
  ABISELECT(4096,2268),
  ABISELECT(3712,2064),
  ABISELECT(3584,1992),
  ABISELECT(3456,1908),
  ABISELECT(-2784,-1608),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S2489C16D1Ev,_ZTv0_n40_N8S2489C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S2489C16D0Ev,_ZTv0_n40_N8S2489C16D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C173v12Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v13Ev,
  ABISELECT(4000,2224),
  ABISELECT(3360,1864),
  ABISELECT(3488,1948),
  ABISELECT(3616,2020),
  ABISELECT(-2880,-1652),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n80_N8S2489C16D1Ev,_ZTvn44_n40_N8S2489C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n80_N8S2489C16D0Ev,_ZTvn44_n40_N8S2489C16D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
  ABISELECT(3072,1684),
  ABISELECT(-3296,-1916),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  ABISELECT(69136,38476),
  ABISELECT(1392,768),
  ABISELECT(752,408),
  ABISELECT(880,492),
  ABISELECT(1008,564),
  ABISELECT(-5488,-3108),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2704_n80_N8S2489C16D1Ev,_ZTvn1500_n40_N8S2489C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2704_n80_N8S2489C16D0Ev,_ZTvn1500_n40_N8S2489C16D0Ev),
  0,
  ABISELECT(-6240,-3516),
  ABISELECT(256,156),
  ABISELECT(128,84),
  ABISELECT(-6240,-3516),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C16D1Ev,_ZTv0_n20_N8S2489C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C16D0Ev,_ZTv0_n20_N8S2489C16D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-6496,-3672),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  0,
  0,
  0,
  ABISELECT(-512,-276),
  ABISELECT(-6880,-3876),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
  0,
  0,
  0,
  ABISELECT(-8448,-4744),
  ABISELECT(52208,29124),
  ABISELECT(-1568,-868),
  ABISELECT(-2208,-1228),
  ABISELECT(-2080,-1144),
  ABISELECT(-1952,-1072),
  ABISELECT(-8448,-4744),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C16D1Ev,_ZTv0_n32_N8S2489C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C16D0Ev,_ZTv0_n32_N8S2489C16D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
  0,
  ABISELECT(-60656,-33868),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(-74624,-41584),
  ABISELECT(-67744,-37708),
  ABISELECT(-68384,-38068),
  ABISELECT(-68256,-37984),
  ABISELECT(-68128,-37912),
  ABISELECT(-74624,-41584),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C16D1Ev,_ZTv0_n28_N8S2489C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C16D0Ev,_ZTv0_n28_N8S2489C16D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
  ABISELECT(-68672,-38248),
  ABISELECT(-75040,-41848),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern VTBL_ENTRY _ZTV8S2489C16[];
extern void _ZN8S2489C17D1Ev();
extern void _ZN8S2489C17D0Ev();
extern void _ZN8S2489C173v12Ev();
extern void _ZN8S2489C173v13Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C17__8S2489C16[] = {
  ABISELECT(71840,39976),
  ABISELECT(57872,32260),
  ABISELECT(5664,3136),
  ABISELECT(4096,2268),
  ABISELECT(3712,2064),
  ABISELECT(3584,1992),
  ABISELECT(3456,1908),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN8S2489C17D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C17D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v12Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v13Ev,
};
extern void _ZN8S2489C19D1Ev();
extern void _ZN8S2489C19D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C198S2489C17__8S2489C16[] = {
  ABISELECT(4000,2224),
  ABISELECT(3360,1864),
  ABISELECT(3488,1948),
  ABISELECT(3616,2020),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN8S2489C19D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C19D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C108S2489C198S2489C17__8S2489C16[] = {
  ABISELECT(4000,2224),
  ABISELECT(3360,1864),
  ABISELECT(3488,1948),
  ABISELECT(3616,2020),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C108S2489C198S2489C17__8S2489C16[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-3616,-2020),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZThn3360_N8S2489C10D1Ev,_ZThn1864_N8S2489C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void ABISELECT(_ZThn3360_N8S2489C10D0Ev,_ZThn1864_N8S2489C10D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C108S2489C198S2489C17__8S2489C16[] = {
  0,
  ABISELECT(-3360,-1864),
  ABISELECT(256,156),
  ABISELECT(128,84),
  ABISELECT(-3360,-1864),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C108S2489C198S2489C17__8S2489C16[] = {
  0,
  0,
  0,
  ABISELECT(-512,-276),
  ABISELECT(-4000,-2224),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C198S2489C17__A2__8S2489C16[] = {
  ABISELECT(3072,1684),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev)();
extern void ABISELECT(_ZThn3360_N8S2489C19D1Ev,_ZThn1864_N8S2489C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev)();
extern void ABISELECT(_ZThn3360_N8S2489C19D0Ev,_ZThn1864_N8S2489C19D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C198S2489C17__8S2489C16[] = {
  0,
  ABISELECT(-3360,-1864),
  ABISELECT(256,156),
  ABISELECT(128,84),
  ABISELECT(-3360,-1864),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C198S2489C17__8S2489C16[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-3616,-2020),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C198S2489C17__8S2489C16[] = {
  0,
  0,
  0,
  ABISELECT(-512,-276),
  ABISELECT(-4000,-2224),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A__8S2489C198S2489C17__8S2489C16[] = {
  ABISELECT(3072,1684),
  ABISELECT(-416,-264),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C21D1Ev();
extern void _ZN8S2489C21D0Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C218S2489C17__8S2489C16[] = {
  ABISELECT(69136,38476),
  ABISELECT(1392,768),
  ABISELECT(752,408),
  ABISELECT(880,492),
  ABISELECT(1008,564),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN8S2489C21D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C21D0Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C218S2489C17__8S2489C16[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-1008,-564),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev)();
extern void ABISELECT(_ZThn752_N8S2489C21D1Ev,_ZThn408_N8S2489C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev)();
extern void ABISELECT(_ZThn752_N8S2489C21D0Ev,_ZThn408_N8S2489C21D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C218S2489C17__8S2489C16[] = {
  0,
  ABISELECT(-752,-408),
  ABISELECT(256,156),
  ABISELECT(128,84),
  ABISELECT(-752,-408),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C218S2489C17__8S2489C16[] = {
  0,
  0,
  0,
  ABISELECT(-512,-276),
  ABISELECT(-1392,-768),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev)();
extern void ABISELECT(_ZThn69136_N8S2489C21D1Ev,_ZThn38476_N8S2489C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev)();
extern void ABISELECT(_ZThn69136_N8S2489C21D0Ev,_ZThn38476_N8S2489C21D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__8S2489C218S2489C17__8S2489C16[] = {
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(-69136,-38476),
  ABISELECT(-67744,-37708),
  ABISELECT(-68384,-38068),
  ABISELECT(-68256,-37984),
  ABISELECT(-68128,-37912),
  ABISELECT(-69136,-38476),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A2__8S2489C218S2489C17__8S2489C16[] = {
  ABISELECT(-68672,-38248),
  ABISELECT(-69552,-38740),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZThn96_N8S2489C17D1Ev,_ZThn44_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn96_N8S2489C17D0Ev,_ZThn44_N8S2489C17D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A__8S2489C17__8S2489C16[] = {
  ABISELECT(4000,2224),
  ABISELECT(3360,1864),
  ABISELECT(3488,1948),
  ABISELECT(3616,2020),
  ABISELECT(-96,-44),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C17D1Ev,_ZThn44_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C17D0Ev,_ZThn44_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C17D1Ev,_ZTv0_n20_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn3456_N8S2489C17D1Ev,_ZThn1908_N8S2489C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C17D0Ev,_ZTv0_n20_N8S2489C17D0Ev)();
extern void ABISELECT(_ZThn3456_N8S2489C17D0Ev,_ZThn1908_N8S2489C17D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C17__8S2489C16[] = {
  0,
  ABISELECT(-3456,-1908),
  ABISELECT(256,156),
  ABISELECT(128,84),
  ABISELECT(-3456,-1908),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C17D1Ev,_ZTv0_n20_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C17D0Ev,_ZTv0_n20_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C17__8S2489C16[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-3712,-2064),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C17__8S2489C16[] = {
  0,
  0,
  0,
  ABISELECT(-512,-276),
  ABISELECT(-4096,-2268),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A2__8S2489C17__8S2489C16[] = {
  ABISELECT(3072,1684),
  ABISELECT(-512,-308),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n64_N8S2489C17D1Ev,_ZTv0_n32_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn5664_N8S2489C17D1Ev,_ZThn3136_N8S2489C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S2489C17D0Ev,_ZTv0_n32_N8S2489C17D0Ev)();
extern void ABISELECT(_ZThn5664_N8S2489C17D0Ev,_ZThn3136_N8S2489C17D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C20__8S2489C17__8S2489C16[] = {
  0,
  0,
  0,
  ABISELECT(-5664,-3136),
  ABISELECT(52208,29124),
  ABISELECT(-1568,-868),
  ABISELECT(-2208,-1228),
  ABISELECT(-2080,-1144),
  ABISELECT(-1952,-1072),
  ABISELECT(-5664,-3136),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C17D1Ev,_ZTv0_n32_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C17D0Ev,_ZTv0_n32_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN8S2489C133v11Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C13__8S2489C17__8S2489C16[] = {
  0,
  ABISELECT(-57872,-32260),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
};
extern void ABISELECT(_ZThn2704_N8S2489C17D1Ev,_ZThn1500_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn2704_N8S2489C17D0Ev,_ZThn1500_N8S2489C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S2489C21__8S2489C17__8S2489C16[] = {
  ABISELECT(69136,38476),
  ABISELECT(1392,768),
  ABISELECT(752,408),
  ABISELECT(880,492),
  ABISELECT(1008,564),
  ABISELECT(-2704,-1500),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S2489C17D1Ev,_ZThn1500_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S2489C17D0Ev,_ZThn1500_N8S2489C17D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N8S2489C17D1Ev,_ZTv0_n28_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn71840_N8S2489C17D1Ev,_ZThn39976_N8S2489C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C17D0Ev,_ZTv0_n28_N8S2489C17D0Ev)();
extern void ABISELECT(_ZThn71840_N8S2489C17D0Ev,_ZThn39976_N8S2489C17D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A1__8S2489C17__8S2489C16[] = {
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(-71840,-39976),
  ABISELECT(-67744,-37708),
  ABISELECT(-68384,-38068),
  ABISELECT(-68256,-37984),
  ABISELECT(-68128,-37912),
  ABISELECT(-71840,-39976),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C17D1Ev,_ZTv0_n28_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C17D0Ev,_ZTv0_n28_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A3__8S2489C17__8S2489C16[] = {
  ABISELECT(-68672,-38248),
  ABISELECT(-72256,-40240),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C8D1Ev();
extern void _ZN7S2489C8D0Ev();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C16[] = {
  ABISELECT(256,156),
  ABISELECT(128,84),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C8__8S2489C16[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-256,-156),
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C16[] = {
  ABISELECT(-128,-72),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C16[] = {
  ABISELECT(-512,-276),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C5[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C67S2489C5__A1__8S2489C16[] = {
  ABISELECT(-512,-276),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C20D1Ev();
extern void _ZN8S2489C20D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C20__8S2489C16[] = {
  ABISELECT(52208,29124),
  ABISELECT(-1568,-868),
  ABISELECT(-2208,-1228),
  ABISELECT(-2080,-1144),
  ABISELECT(-1952,-1072),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN8S2489C20D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C20D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN7S2489C9D1Ev();
extern void _ZN7S2489C9D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C98S2489C20__8S2489C16[] = {
  ABISELECT(-1568,-868),
  ABISELECT(-2208,-1228),
  ABISELECT(-2080,-1144),
  ABISELECT(-1952,-1072),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C107S2489C98S2489C20__A1__8S2489C16[] = {
  ABISELECT(-1568,-868),
  ABISELECT(-2208,-1228),
  ABISELECT(-2080,-1144),
  ABISELECT(-1952,-1072),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C107S2489C98S2489C20__A1__8S2489C16[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(1952,1072),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C107S2489C98S2489C20__A1__8S2489C16[] = {
  0,
  ABISELECT(2208,1228),
  ABISELECT(256,156),
  ABISELECT(128,84),
  ABISELECT(2208,1228),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C107S2489C98S2489C20__A1__8S2489C16[] = {
  0,
  0,
  0,
  ABISELECT(-512,-276),
  ABISELECT(1568,868),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C98S2489C20__8S2489C16[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(1952,1072),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev)();
extern void ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__7S2489C98S2489C20__8S2489C16[] = {
  0,
  ABISELECT(2208,1228),
  ABISELECT(256,156),
  ABISELECT(128,84),
  ABISELECT(2208,1228),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__7S2489C98S2489C20__8S2489C16[] = {
  0,
  0,
  0,
  ABISELECT(-512,-276),
  ABISELECT(1568,868),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C20__8S2489C16[] = {
  0,
  0,
  0,
  ABISELECT(-512,-276),
  ABISELECT(1568,868),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A1__8S2489C20__8S2489C16[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(1952,1072),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C20D1Ev,_ZTv0_n20_N8S2489C20D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C20D0Ev,_ZTv0_n20_N8S2489C20D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C20__8S2489C16[] = {
  0,
  ABISELECT(2208,1228),
  ABISELECT(256,156),
  ABISELECT(128,84),
  ABISELECT(2208,1228),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C20D1Ev,_ZTv0_n20_N8S2489C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C20D0Ev,_ZTv0_n20_N8S2489C20D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN8S2489C133v11Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C13__8S2489C20__8S2489C16[] = {
  0,
  ABISELECT(-52208,-29124),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
};
extern void _ZN8S2489C19D1Ev();
extern void _ZN8S2489C19D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A1__8S2489C16[] = {
  ABISELECT(-67744,-37708),
  ABISELECT(-68384,-38068),
  ABISELECT(-68256,-37984),
  ABISELECT(-68128,-37912),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN8S2489C19D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C19D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C108S2489C19__A2__8S2489C16[] = {
  ABISELECT(-67744,-37708),
  ABISELECT(-68384,-38068),
  ABISELECT(-68256,-37984),
  ABISELECT(-68128,-37912),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C108S2489C19__A2__8S2489C16[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(68128,37912),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C108S2489C19__A2__8S2489C16[] = {
  0,
  ABISELECT(68384,38068),
  ABISELECT(256,156),
  ABISELECT(128,84),
  ABISELECT(68384,38068),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C108S2489C19__A2__8S2489C16[] = {
  0,
  0,
  0,
  ABISELECT(-512,-276),
  ABISELECT(67744,37708),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A3__8S2489C16[] = {
  ABISELECT(-68672,-38248),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C19__A1__8S2489C16[] = {
  0,
  ABISELECT(68384,38068),
  ABISELECT(256,156),
  ABISELECT(128,84),
  ABISELECT(68384,38068),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C19__A1__8S2489C16[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(68128,37912),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C19__A1__8S2489C16[] = {
  0,
  0,
  0,
  ABISELECT(-512,-276),
  ABISELECT(67744,37708),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A__8S2489C19__A1__8S2489C16[] = {
  ABISELECT(-68672,-38248),
  ABISELECT(-416,-264),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
static  VTT_ENTRY vtt_S2489C16[] = {
  {&(_ZTV8S2489C16[10]),  10,129},
  {&(_ZTV8S2489C16[30]),  30,129},
  {&(_ZTV8S2489C16[40]),  40,129},
  {&(_ZTV8S2489C16[66]),  66,129},
  {&(_ZTV8S2489C16[74]),  74,129},
  {&(_ZTV8S2489C16[82]),  82,129},
  {&(_ZTV8S2489C16[49]),  49,129},
  {&(_ZTV8S2489C16[96]),  96,129},
  {&(_ZTV8S2489C16[104]),  104,129},
  {&(_ZTV8S2489C16[58]),  58,129},
  {&(_ZTV8S2489C16[118]),  118,129},
  {&(_ZTV8S2489C16[127]),  127,129},
  {&(_tg__ZTV8S2489C17__8S2489C16[9]),  9,13},
  {&(_tg__ZTV8S2489C198S2489C17__8S2489C16[6]),  6,12},
  {&(_tg__ZTV8S2489C108S2489C198S2489C17__8S2489C16[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C108S2489C198S2489C17__8S2489C16[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C108S2489C198S2489C17__8S2489C16[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C108S2489C198S2489C17__8S2489C16[6]),  6,9},
  {&(_tg__ZTV7S2489C68S2489C198S2489C17__A2__8S2489C16[3]),  3,5},
  {&(_tg__ZTV7S2489C8__8S2489C198S2489C17__8S2489C16[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C198S2489C17__8S2489C16[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C198S2489C17__8S2489C16[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A__8S2489C198S2489C17__8S2489C16[3]),  3,5},
  {&(_tg__ZTV8S2489C218S2489C17__8S2489C16[7]),  7,9},
  {&(_tg__ZTV7S2489C6__8S2489C218S2489C17__8S2489C16[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C218S2489C17__8S2489C16[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C218S2489C17__8S2489C16[6]),  6,9},
  {&(_tg__ZTV8S2489C19__8S2489C218S2489C17__8S2489C16[13]),  13,19},
  {&(_tg__ZTV7S2489C68S2489C19__A2__8S2489C218S2489C17__8S2489C16[3]),  3,5},
  {&(_tg__ZTV8S2489C19__A__8S2489C17__8S2489C16[6]),  6,12},
  {&(_tg__ZTV7S2489C8__8S2489C17__8S2489C16[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C17__8S2489C16[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C17__8S2489C16[6]),  6,9},
  {&(_tg__ZTV7S2489C68S2489C19__A2__8S2489C17__8S2489C16[3]),  3,5},
  {&(_tg__ZTV8S2489C20__8S2489C17__8S2489C16[11]),  11,16},
  {&(_tg__ZTV8S2489C13__8S2489C17__8S2489C16[3]),  3,4},
  {&(_tg__ZTV8S2489C21__8S2489C17__8S2489C16[7]),  7,9},
  {&(_tg__ZTV8S2489C19__A1__8S2489C17__8S2489C16[13]),  13,19},
  {&(_tg__ZTV7S2489C68S2489C19__A3__8S2489C17__8S2489C16[3]),  3,5},
  {&(_tg__ZTV7S2489C8__8S2489C16[4]),  4,7},
  {&(_tg__ZTV7S2489C6__7S2489C8__8S2489C16[5]),  5,7},
  {&(_tg__ZTV7S2489C6__8S2489C16[3]),  3,5},
  {&(_tg__ZTV7S2489C5__8S2489C16[3]),  3,6},
  {&(_tg__ZTV7S2489C67S2489C5__A1__8S2489C16[3]),  3,5},
  {&(_tg__ZTV8S2489C20__8S2489C16[7]),  7,12},
  {&(_tg__ZTV7S2489C98S2489C20__8S2489C16[6]),  6,11},
  {&(_tg__ZTV8S2489C107S2489C98S2489C20__A1__8S2489C16[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C107S2489C98S2489C20__A1__8S2489C16[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C107S2489C98S2489C20__A1__8S2489C16[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C107S2489C98S2489C20__A1__8S2489C16[6]),  6,9},
  {&(_tg__ZTV7S2489C6__7S2489C98S2489C20__8S2489C16[5]),  5,7},
  {&(_tg__ZTV7S2489C8__7S2489C98S2489C20__8S2489C16[6]),  6,9},
  {&(_tg__ZTV7S2489C5__7S2489C98S2489C20__8S2489C16[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C20__8S2489C16[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A1__8S2489C20__8S2489C16[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C20__8S2489C16[6]),  6,9},
  {&(_tg__ZTV8S2489C13__8S2489C20__8S2489C16[3]),  3,4},
  {&(_tg__ZTV8S2489C19__A1__8S2489C16[6]),  6,12},
  {&(_tg__ZTV8S2489C108S2489C19__A2__8S2489C16[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C108S2489C19__A2__8S2489C16[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C108S2489C19__A2__8S2489C16[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C108S2489C19__A2__8S2489C16[6]),  6,9},
  {&(_tg__ZTV7S2489C68S2489C19__A3__8S2489C16[3]),  3,5},
  {&(_tg__ZTV7S2489C8__8S2489C19__A1__8S2489C16[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C19__A1__8S2489C16[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C19__A1__8S2489C16[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A__8S2489C19__A1__8S2489C16[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S2489C16[];
extern  VTBL_ENTRY _ZTV8S2489C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C16[];
static VTBL_ENTRY alt_thunk_names9[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C17D0Ev,_ZTv0_n28_N8S2489C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn71840_N8S2489C17D0Ev,_ZThn39976_N8S2489C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C17D1Ev,_ZTv0_n28_N8S2489C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn71840_N8S2489C17D1Ev,_ZThn39976_N8S2489C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C17D0Ev,_ZTv0_n32_N8S2489C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5664_N8S2489C17D0Ev,_ZThn3136_N8S2489C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C17D1Ev,_ZTv0_n32_N8S2489C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5664_N8S2489C17D1Ev,_ZThn3136_N8S2489C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C17D0Ev,_ZTv0_n20_N8S2489C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3456_N8S2489C17D0Ev,_ZThn1908_N8S2489C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C17D1Ev,_ZTv0_n20_N8S2489C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3456_N8S2489C17D1Ev,_ZThn1908_N8S2489C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn69136_N8S2489C21D0Ev,_ZThn38476_N8S2489C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn69136_N8S2489C21D1Ev,_ZThn38476_N8S2489C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn752_N8S2489C21D0Ev,_ZThn408_N8S2489C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn752_N8S2489C21D1Ev,_ZThn408_N8S2489C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3360_N8S2489C19D0Ev,_ZThn1864_N8S2489C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3360_N8S2489C19D1Ev,_ZThn1864_N8S2489C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3360_N8S2489C10D0Ev,_ZThn1864_N8S2489C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3360_N8S2489C10D1Ev,_ZThn1864_N8S2489C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C16D0Ev,_ZTv0_n28_N8S2489C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn74624_N8S2489C16D0Ev,_ZThn41584_N8S2489C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C16D1Ev,_ZTv0_n28_N8S2489C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn74624_N8S2489C16D1Ev,_ZThn41584_N8S2489C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C16D0Ev,_ZTv0_n32_N8S2489C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8448_N8S2489C16D0Ev,_ZThn4744_N8S2489C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C16D1Ev,_ZTv0_n32_N8S2489C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8448_N8S2489C16D1Ev,_ZThn4744_N8S2489C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C16D0Ev,_ZTv0_n20_N8S2489C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6240_N8S2489C16D0Ev,_ZThn3516_N8S2489C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C16D1Ev,_ZTv0_n20_N8S2489C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6240_N8S2489C16D1Ev,_ZThn3516_N8S2489C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S2489C16D0Ev,_ZTv0_n40_N8S2489C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2784_N8S2489C16D0Ev,_ZThn1608_N8S2489C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S2489C16D1Ev,_ZTv0_n40_N8S2489C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2784_N8S2489C16D1Ev,_ZThn1608_N8S2489C16D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S2489C16 = {  "S2489C16", // class name
  bases_S2489C16, 25,
  &(vtc_S2489C16[0]), // expected_vtbl_contents
  &(vtt_S2489C16[0]), // expected_vtt_contents
  ABISELECT(77232,43040), // object size
  NSPAIRA(_ZTI8S2489C16),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV8S2489C16),129, //virtual function table var
  10, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S2489C16),67, //virtual table table var
  17, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names9,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2489C23  : virtual S2489C10 , virtual S2489C13 , S2489C17 {
  void *s2489c23f0[6];
  int s2489c23f1;
  short s2489c23f2;
  ::S2489C12_nt s2489c23f3;
  ::S2489C2 s2489c23f4;
  void *s2489c23f5;
  int s2489c23f6;
  int s2489c23f7;
  char s2489c23f8;
  char s2489c23f9;
  ::S2489C4 s2489c23f10;
  virtual  ~S2489C23(); // _ZN8S2489C23D2Ev
  S2489C23(); // tgen
};
//SIG(-1 S2489C23) C1{ VBC2{ BC3{ m Fc Fi FL FU4{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} VBC5{ VBC3 v1 v2 Fp Fp Fi Fi FU6{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU6 Fp FL:3 FC3 FL FU6} VBC7{ VBC3 VBC5 vd v3 FL FL FL FL Fi FU6 Fc[10] Fi} VBC8{ BC3 BC5 v4 Fp FD FC3[7] FD FU4 Fs FL FL} vd v5 Fc Fi[7] Fl[5] FL FL FL FU9{ m Fp Fi Fp Fc Fc FL[5] Fp Fp Fp}} VBC10{ v6 FD FC11{ VBC8 VBC7 Fi Fp Fi FU6}[6] Fc Fp Fp Fi[6] Fi Fp FL Fp Fi Fp Fp} BC12{ BC13{ vd m FU4} BC14{ VBC7 BC2 BC3 BC5 vd v7 v8 v9 FU6 Fi Fl Fc Fp FC8 Fs} VBC15{ VBC8 VBC5 VBC7 BC16{ BC2 vd v10 v11 Fp Fp Fp Fi FC17{} FL FL} VBC10 vd Fc Fs[3] FC18{ BC3 VBC5 VBC7 VBC8 VBC14 vd FL Fi Fp Fp FL}[10] FC8 FL FL:5 Fi Fp[6] FL[2] FL Fi} BC18 vd v12 v13 Fi FD Fl Fc:3 Fp FC5} vd Fp[6] Fi Fs FC17 FC19{ BC3 VBC8 VBC7 BC16 vd FD} Fp Fi Fi Fc Fc FU4}


 S2489C23 ::~S2489C23(){ note_dtor("S2489C23", this);}
S2489C23 ::S2489C23(){ note_ctor("S2489C23", this);} // tgen

static void Test_S2489C23()
{
  extern Class_Descriptor cd_S2489C23;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(4851,10814)];
    init_test(&cd_S2489C23, buf);
    S2489C23 *dp, &lv = *(dp=new (buf) S2489C23());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(77600,43252), "sizeof(S2489C23)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2489C23)");
    /*is_ambiguous_... S2489C23::S2489C10 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*), ABISELECT(6336,3540), "S2489C23");
    /*is_ambiguous_... S2489C23::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*), ABISELECT(6992,3932), "S2489C23");
    check_base_class_offset(lv, (S2489C3*)(S2489C8*), ABISELECT(6992,3932), "S2489C23");
    check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C5*), ABISELECT(6992,3932), "S2489C23");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C19*)(S2489C17*), ABISELECT(6992,3932), "S2489C23");
    /*is_ambiguous_... S2489C23::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C19*), ABISELECT(6992,3932), "S2489C23");
    /*is_ambiguous_... S2489C23::S2489C10 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*), ABISELECT(6608,3728), "S2489C23");
    check_base_class_offset(lv, (S2489C6*)(S2489C8*), ABISELECT(6608,3728), "S2489C23");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*)(S2489C19*)(S2489C17*), ABISELECT(6608,3728), "S2489C23");
    /*is_ambiguous_... S2489C20::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C20*), ABISELECT(6608,3728), "S2489C23");
    /*is_ambiguous_... S2489C10::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(6608,3728), "S2489C23");
    /*is_ambiguous_... S2489C21::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C21*)(S2489C17*), ABISELECT(6608,3728), "S2489C23");
    /*is_ambiguous_... S2489C23::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*)(S2489C19*), ABISELECT(6608,3728), "S2489C23");
    /*is_ambiguous_... S2489C23::S2489C10 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C10*), ABISELECT(7120,4004), "S2489C23");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C19*)(S2489C17*), ABISELECT(7120,4004), "S2489C23");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C10*)(S2489C19*)(S2489C17*), ABISELECT(7120,4004), "S2489C23");
    check_base_class_offset(lv, (S2489C8*)(S2489C20*), ABISELECT(7120,4004), "S2489C23");
    check_base_class_offset(lv, (S2489C8*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(7120,4004), "S2489C23");
    check_base_class_offset(lv, (S2489C8*)(S2489C21*)(S2489C17*), ABISELECT(7120,4004), "S2489C23");
    /*is_ambiguous_... S2489C23::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C19*), ABISELECT(7120,4004), "S2489C23");
    /*is_ambiguous_... S2489C23::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C10*)(S2489C19*), ABISELECT(7120,4004), "S2489C23");
    /*is_ambiguous_... S2489C5::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C5*), ABISELECT(7632,4292), "S2489C23");
    check_base_class_offset(lv, (S2489C6*)(S2489C5*), ABISELECT(7248,4088), "S2489C23");
    /*is_ambiguous_... S2489C23::S2489C10 */ AMB_check_base_class_offset(lv, (S2489C5*)(S2489C10*), ABISELECT(7248,4088), "S2489C23");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C5*)(S2489C10*)(S2489C19*)(S2489C17*), ABISELECT(7248,4088), "S2489C23");
    check_base_class_offset(lv, (S2489C5*)(S2489C20*), ABISELECT(7248,4088), "S2489C23");
    check_base_class_offset(lv, (S2489C5*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(7248,4088), "S2489C23");
    check_base_class_offset(lv, (S2489C5*)(S2489C21*)(S2489C17*), ABISELECT(7248,4088), "S2489C23");
    /*is_ambiguous_... S2489C23::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C5*)(S2489C10*)(S2489C19*), ABISELECT(7248,4088), "S2489C23");
    /*is_ambiguous_... S2489C23::S2489C10 */ AMB_check_base_class_offset(lv, (S2489C10*), ABISELECT(6320,3536), "S2489C23");
    check_base_class_offset(lv, (S2489C13*), ABISELECT(8816,4956), "S2489C23");
    check_base_class_offset(lv, (S2489C13*)(S2489C20*), ABISELECT(8816,4956), "S2489C23");
    check_base_class_offset(lv, (S2489C18*)(S2489C17*), 0, "S2489C23");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*)(S2489C19*)(S2489C17*), ABISELECT(112,48), "S2489C23");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C10*)(S2489C19*)(S2489C17*), ABISELECT(96,44), "S2489C23");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C19*)(S2489C17*), ABISELECT(384,236), "S2489C23");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C19*)(S2489C17*), ABISELECT(512,308), "S2489C23");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C19*)(S2489C17*), ABISELECT(96,44), "S2489C23");
    /*is_ambiguous_... S2489C10::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(22800,12676), "S2489C23");
    check_base_class_offset(lv, (S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(22784,12672), "S2489C23");
    check_base_class_offset(lv, (S2489C9*)(S2489C20*), ABISELECT(22784,12672), "S2489C23");
    check_base_class_offset(lv, (S2489C20*)(S2489C17*), ABISELECT(22784,12672), "S2489C23");
    /*is_ambiguous_... S2489C21::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C21*)(S2489C17*), ABISELECT(2720,1504), "S2489C23");
    /*is_ambiguous_... S2489C23::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*)(S2489C19*), ABISELECT(75008,41800), "S2489C23");
    /*is_ambiguous_... S2489C23::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C10*)(S2489C19*), ABISELECT(74992,41796), "S2489C23");
    /*is_ambiguous_... S2489C23::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C19*), ABISELECT(75280,41988), "S2489C23");
    /*is_ambiguous_... S2489C23::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C19*), ABISELECT(75408,42060), "S2489C23");
    check_base_class_offset(lv, (S2489C19*)(S2489C21*)(S2489C17*), ABISELECT(74992,41796), "S2489C23");
    check_base_class_offset(lv, (S2489C21*)(S2489C17*), ABISELECT(2704,1500), "S2489C23");
    check_base_class_offset(lv, (S2489C17*), 0, "S2489C23");
    check_field_offset(lv, s2489c23f0, ABISELECT(3456,1908), "S2489C23.s2489c23f0");
    check_field_offset(lv, s2489c23f1, ABISELECT(3504,1932), "S2489C23.s2489c23f1");
    check_field_offset(lv, s2489c23f2, ABISELECT(3508,1936), "S2489C23.s2489c23f2");
    check_field_offset(lv, s2489c23f3, ABISELECT(3510,1938), "S2489C23.s2489c23f3");
    check_field_offset(lv, s2489c23f4, ABISELECT(3520,1940), "S2489C23.s2489c23f4");
    check_field_offset(lv, s2489c23f5, ABISELECT(6208,3480), "S2489C23.s2489c23f5");
    check_field_offset(lv, s2489c23f6, ABISELECT(6216,3484), "S2489C23.s2489c23f6");
    check_field_offset(lv, s2489c23f7, ABISELECT(6220,3488), "S2489C23.s2489c23f7");
    check_field_offset(lv, s2489c23f8, ABISELECT(6224,3492), "S2489C23.s2489c23f8");
    check_field_offset(lv, s2489c23f9, ABISELECT(6225,3493), "S2489C23.s2489c23f9");
    check_field_offset(lv, s2489c23f10, ABISELECT(6240,3496), "S2489C23.s2489c23f10");
    test_class_info(&lv, &cd_S2489C23);
    dp->~S2489C23();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2489C23(Test_S2489C23, "S2489C23", ABISELECT(77600,43252));

#else // __cplusplus

extern void _ZN8S2489C23C1Ev();
extern void _ZN8S2489C23D2Ev();
Name_Map name_map_S2489C23[] = {
  NSPAIR(_ZN8S2489C23C1Ev),
  NSPAIR(_ZN8S2489C23D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C8;
extern VTBL_ENTRY _ZTI7S2489C8[];
extern  VTBL_ENTRY _ZTV7S2489C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C8[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C5;
extern VTBL_ENTRY _ZTI7S2489C5[];
extern  VTBL_ENTRY _ZTV7S2489C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C5[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C13;
extern VTBL_ENTRY _ZTI8S2489C13[];
extern  VTBL_ENTRY _ZTV8S2489C13[];
extern Class_Descriptor cd_S2489C18;
extern VTBL_ENTRY _ZTI8S2489C18[];
extern  VTBL_ENTRY _ZTV8S2489C18[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C19;
extern VTBL_ENTRY _ZTI8S2489C19[];
extern  VTBL_ENTRY _ZTV8S2489C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C19[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C9;
extern VTBL_ENTRY _ZTI7S2489C9[];
extern  VTBL_ENTRY _ZTV7S2489C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C9[];
extern Class_Descriptor cd_S2489C20;
extern VTBL_ENTRY _ZTI8S2489C20[];
extern  VTBL_ENTRY _ZTV8S2489C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C20[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C19;
extern VTBL_ENTRY _ZTI8S2489C19[];
extern  VTBL_ENTRY _ZTV8S2489C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C19[];
extern Class_Descriptor cd_S2489C21;
extern VTBL_ENTRY _ZTI8S2489C21[];
extern  VTBL_ENTRY _ZTV8S2489C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C21[];
extern Class_Descriptor cd_S2489C17;
extern VTBL_ENTRY _ZTI8S2489C17[];
extern  VTBL_ENTRY _ZTV8S2489C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C17[];
static Base_Class bases_S2489C23[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C3,    ABISELECT(6336,3540), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(6992,3932), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S2489C6,    ABISELECT(6608,3728), //bcp->offset
    51, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S2489C8,    ABISELECT(7120,4004), //bcp->offset
    58, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    45, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S2489C3,    ABISELECT(7632,4292), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2489C6,    ABISELECT(7248,4088), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    48, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2489C5,    ABISELECT(7248,4088), //bcp->offset
    67, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    32, //bcp->index_in_construction_vtbl_array
    47, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S2489C10,    ABISELECT(6320,3536), //bcp->offset
    40, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C13,    ABISELECT(8816,4956), //bcp->offset
    76, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    33, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(112,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S2489C10,    ABISELECT(96,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(384,236), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S2489C6,    ABISELECT(512,308), //bcp->offset
    26, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    35, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S2489C19,    ABISELECT(96,44), //bcp->offset
    14, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    34, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(22800,12676), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S2489C10,    ABISELECT(22784,12672), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    51, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S2489C9,    ABISELECT(22784,12672), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    50, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S2489C20,    ABISELECT(22784,12672), //bcp->offset
    80, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    36, //bcp->index_in_construction_vtbl_array
    49, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    26, //immediately_derived
  0, 1},
  {&cd_S2489C3,    ABISELECT(2720,1504), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(75008,41800), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S2489C10,    ABISELECT(74992,41796), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    63, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(75280,41988), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S2489C6,    ABISELECT(75408,42060), //bcp->offset
    115, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    39, //bcp->index_in_construction_vtbl_array
    67, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S2489C19,    ABISELECT(74992,41796), //bcp->offset
    96, //bcp->virtual_function_table_offset
    13, //num_negative_vtable_entries(t, bcp)
    38, //bcp->index_in_construction_vtbl_array
    62, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    25, //immediately_derived
  0, 1},
  {&cd_S2489C21,    ABISELECT(2704,1500), //bcp->offset
    31, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    37, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S2489C17,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S2489C23[];
extern void _ZN8S2489C23D1Ev();
extern void _ZN8S2489C23D0Ev();
extern void _ZN8S2489C173v12Ev();
extern void _ZN8S2489C173v13Ev();
extern void ABISELECT(_ZThn96_N8S2489C23D1Ev,_ZThn44_N8S2489C23D1Ev)();
extern void ABISELECT(_ZThn96_N8S2489C23D0Ev,_ZThn44_N8S2489C23D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void ABISELECT(_ZThn2704_N8S2489C23D1Ev,_ZThn1500_N8S2489C23D1Ev)();
extern void ABISELECT(_ZThn2704_N8S2489C23D0Ev,_ZThn1500_N8S2489C23D0Ev)();
extern void ABISELECT(_ZTv0_n56_N8S2489C23D1Ev,_ZTv0_n28_N8S2489C23D1Ev)();
extern void ABISELECT(_ZThn6320_N8S2489C23D1Ev,_ZThn3536_N8S2489C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C23D0Ev,_ZTv0_n28_N8S2489C23D0Ev)();
extern void ABISELECT(_ZThn6320_N8S2489C23D0Ev,_ZThn3536_N8S2489C23D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void ABISELECT(_ZTv0_n40_N8S2489C23D1Ev,_ZTv0_n20_N8S2489C23D1Ev)();
extern void ABISELECT(_ZThn7120_N8S2489C23D1Ev,_ZThn4004_N8S2489C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C23D0Ev,_ZTv0_n20_N8S2489C23D0Ev)();
extern void ABISELECT(_ZThn7120_N8S2489C23D0Ev,_ZThn4004_N8S2489C23D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
extern void _ZN8S2489C133v11Ev();
extern void ABISELECT(_ZTv0_n64_N8S2489C23D1Ev,_ZTv0_n32_N8S2489C23D1Ev)();
extern void ABISELECT(_ZThn22784_N8S2489C23D1Ev,_ZThn12672_N8S2489C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S2489C23D0Ev,_ZTv0_n32_N8S2489C23D0Ev)();
extern void ABISELECT(_ZThn22784_N8S2489C23D0Ev,_ZThn12672_N8S2489C23D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
extern void ABISELECT(_ZTv0_n56_N8S2489C23D1Ev,_ZTv0_n28_N8S2489C23D1Ev)();
extern void ABISELECT(_ZThn74992_N8S2489C23D1Ev,_ZThn41796_N8S2489C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C23D0Ev,_ZTv0_n28_N8S2489C23D0Ev)();
extern void ABISELECT(_ZThn74992_N8S2489C23D0Ev,_ZThn41796_N8S2489C23D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY vtc_S2489C23[] = {
  ABISELECT(6320,3536),
  ABISELECT(74992,41796),
  ABISELECT(8816,4956),
  ABISELECT(22784,12672),
  ABISELECT(7248,4088),
  ABISELECT(6608,3728),
  ABISELECT(6992,3932),
  ABISELECT(7120,4004),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&_ZN8S2489C23D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C23D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v12Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v13Ev,
  ABISELECT(7152,4044),
  ABISELECT(7024,3960),
  ABISELECT(6896,3888),
  ABISELECT(6512,3684),
  ABISELECT(-96,-44),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C23D1Ev,_ZThn44_N8S2489C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C23D0Ev,_ZThn44_N8S2489C23D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
  ABISELECT(6480,3624),
  ABISELECT(-512,-308),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  ABISELECT(72288,40296),
  ABISELECT(4544,2588),
  ABISELECT(4416,2504),
  ABISELECT(4288,2432),
  ABISELECT(3904,2228),
  ABISELECT(-2704,-1500),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S2489C23D1Ev,_ZThn1500_N8S2489C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S2489C23D0Ev,_ZThn1500_N8S2489C23D0Ev),
  0,
  ABISELECT(-6320,-3536),
  ABISELECT(928,552),
  ABISELECT(800,468),
  ABISELECT(672,396),
  ABISELECT(288,192),
  ABISELECT(-6320,-3536),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C23D1Ev,_ZTv0_n28_N8S2489C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C23D0Ev,_ZTv0_n28_N8S2489C23D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(-6608,-3728),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  0,
  ABISELECT(-7120,-4004),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(-7120,-4004),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C23D1Ev,_ZTv0_n20_N8S2489C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C23D0Ev,_ZTv0_n20_N8S2489C23D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-7248,-4088),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
  0,
  ABISELECT(-8816,-4956),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
  0,
  0,
  0,
  ABISELECT(-22784,-12672),
  ABISELECT(-13968,-7716),
  ABISELECT(-15536,-8584),
  ABISELECT(-15664,-8668),
  ABISELECT(-15792,-8740),
  ABISELECT(-16176,-8944),
  ABISELECT(-22784,-12672),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C23D1Ev,_ZTv0_n32_N8S2489C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C23D0Ev,_ZTv0_n32_N8S2489C23D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(-74992,-41796),
  ABISELECT(-67744,-37708),
  ABISELECT(-67872,-37792),
  ABISELECT(-68000,-37864),
  ABISELECT(-68384,-38068),
  ABISELECT(-74992,-41796),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C23D1Ev,_ZTv0_n28_N8S2489C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C23D0Ev,_ZTv0_n28_N8S2489C23D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
  ABISELECT(-68416,-38128),
  ABISELECT(-75408,-42060),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern VTBL_ENTRY _ZTV8S2489C23[];
extern void _ZN8S2489C17D1Ev();
extern void _ZN8S2489C17D0Ev();
extern void _ZN8S2489C173v12Ev();
extern void _ZN8S2489C173v13Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C17__8S2489C23[] = {
  ABISELECT(74992,41796),
  ABISELECT(8816,4956),
  ABISELECT(22784,12672),
  ABISELECT(7248,4088),
  ABISELECT(6608,3728),
  ABISELECT(6992,3932),
  ABISELECT(7120,4004),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN8S2489C17D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C17D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v12Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v13Ev,
};
extern void _ZN8S2489C19D1Ev();
extern void _ZN8S2489C19D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C198S2489C17__8S2489C23[] = {
  ABISELECT(7152,4044),
  ABISELECT(7024,3960),
  ABISELECT(6896,3888),
  ABISELECT(6512,3684),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN8S2489C19D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C19D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C108S2489C198S2489C17__A1__8S2489C23[] = {
  ABISELECT(7152,4044),
  ABISELECT(7024,3960),
  ABISELECT(6896,3888),
  ABISELECT(6512,3684),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C108S2489C198S2489C17__A1__8S2489C23[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(-6512,-3684),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZThn7024_N8S2489C10D1Ev,_ZThn3960_N8S2489C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void ABISELECT(_ZThn7024_N8S2489C10D0Ev,_ZThn3960_N8S2489C10D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C108S2489C198S2489C17__A1__8S2489C23[] = {
  0,
  ABISELECT(-7024,-3960),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(-7024,-3960),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C108S2489C198S2489C17__A1__8S2489C23[] = {
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-7152,-4044),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C198S2489C17__A2__8S2489C23[] = {
  ABISELECT(6480,3624),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev)();
extern void ABISELECT(_ZThn7024_N8S2489C19D1Ev,_ZThn3960_N8S2489C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev)();
extern void ABISELECT(_ZThn7024_N8S2489C19D0Ev,_ZThn3960_N8S2489C19D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C198S2489C17__8S2489C23[] = {
  0,
  ABISELECT(-7024,-3960),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(-7024,-3960),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C198S2489C17__8S2489C23[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(-6512,-3684),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C198S2489C17__8S2489C23[] = {
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-7152,-4044),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A__8S2489C198S2489C17__8S2489C23[] = {
  ABISELECT(6480,3624),
  ABISELECT(-416,-264),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C21D1Ev();
extern void _ZN8S2489C21D0Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C218S2489C17__8S2489C23[] = {
  ABISELECT(72288,40296),
  ABISELECT(4544,2588),
  ABISELECT(4416,2504),
  ABISELECT(4288,2432),
  ABISELECT(3904,2228),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN8S2489C21D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C21D0Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C218S2489C17__8S2489C23[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(-3904,-2228),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev)();
extern void ABISELECT(_ZThn4416_N8S2489C21D1Ev,_ZThn2504_N8S2489C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev)();
extern void ABISELECT(_ZThn4416_N8S2489C21D0Ev,_ZThn2504_N8S2489C21D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C218S2489C17__8S2489C23[] = {
  0,
  ABISELECT(-4416,-2504),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(-4416,-2504),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C218S2489C17__8S2489C23[] = {
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-4544,-2588),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev)();
extern void ABISELECT(_ZThn72288_N8S2489C21D1Ev,_ZThn40296_N8S2489C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev)();
extern void ABISELECT(_ZThn72288_N8S2489C21D0Ev,_ZThn40296_N8S2489C21D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__8S2489C218S2489C17__8S2489C23[] = {
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(-72288,-40296),
  ABISELECT(-67744,-37708),
  ABISELECT(-67872,-37792),
  ABISELECT(-68000,-37864),
  ABISELECT(-68384,-38068),
  ABISELECT(-72288,-40296),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A2__8S2489C218S2489C17__8S2489C23[] = {
  ABISELECT(-68416,-38128),
  ABISELECT(-72704,-40560),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZThn96_N8S2489C17D1Ev,_ZThn44_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn96_N8S2489C17D0Ev,_ZThn44_N8S2489C17D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A__8S2489C17__8S2489C23[] = {
  ABISELECT(7152,4044),
  ABISELECT(7024,3960),
  ABISELECT(6896,3888),
  ABISELECT(6512,3684),
  ABISELECT(-96,-44),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C17D1Ev,_ZThn44_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C17D0Ev,_ZThn44_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C17D1Ev,_ZTv0_n20_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn7120_N8S2489C17D1Ev,_ZThn4004_N8S2489C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C17D0Ev,_ZTv0_n20_N8S2489C17D0Ev)();
extern void ABISELECT(_ZThn7120_N8S2489C17D0Ev,_ZThn4004_N8S2489C17D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C17__8S2489C23[] = {
  0,
  ABISELECT(-7120,-4004),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(-7120,-4004),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C17D1Ev,_ZTv0_n20_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C17D0Ev,_ZTv0_n20_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C17__8S2489C23[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(-6608,-3728),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C17__8S2489C23[] = {
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-7248,-4088),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A2__8S2489C17__8S2489C23[] = {
  ABISELECT(6480,3624),
  ABISELECT(-512,-308),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n64_N8S2489C17D1Ev,_ZTv0_n32_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn22784_N8S2489C17D1Ev,_ZThn12672_N8S2489C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S2489C17D0Ev,_ZTv0_n32_N8S2489C17D0Ev)();
extern void ABISELECT(_ZThn22784_N8S2489C17D0Ev,_ZThn12672_N8S2489C17D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C20__8S2489C17__8S2489C23[] = {
  0,
  0,
  0,
  ABISELECT(-22784,-12672),
  ABISELECT(-13968,-7716),
  ABISELECT(-15536,-8584),
  ABISELECT(-15664,-8668),
  ABISELECT(-15792,-8740),
  ABISELECT(-16176,-8944),
  ABISELECT(-22784,-12672),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C17D1Ev,_ZTv0_n32_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C17D0Ev,_ZTv0_n32_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN8S2489C133v11Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C13__8S2489C17__8S2489C23[] = {
  0,
  ABISELECT(-8816,-4956),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
};
extern void ABISELECT(_ZThn2704_N8S2489C17D1Ev,_ZThn1500_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn2704_N8S2489C17D0Ev,_ZThn1500_N8S2489C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S2489C21__8S2489C17__8S2489C23[] = {
  ABISELECT(72288,40296),
  ABISELECT(4544,2588),
  ABISELECT(4416,2504),
  ABISELECT(4288,2432),
  ABISELECT(3904,2228),
  ABISELECT(-2704,-1500),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S2489C17D1Ev,_ZThn1500_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S2489C17D0Ev,_ZThn1500_N8S2489C17D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N8S2489C17D1Ev,_ZTv0_n28_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn74992_N8S2489C17D1Ev,_ZThn41796_N8S2489C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C17D0Ev,_ZTv0_n28_N8S2489C17D0Ev)();
extern void ABISELECT(_ZThn74992_N8S2489C17D0Ev,_ZThn41796_N8S2489C17D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A1__8S2489C17__8S2489C23[] = {
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(-74992,-41796),
  ABISELECT(-67744,-37708),
  ABISELECT(-67872,-37792),
  ABISELECT(-68000,-37864),
  ABISELECT(-68384,-38068),
  ABISELECT(-74992,-41796),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C17D1Ev,_ZTv0_n28_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C17D0Ev,_ZTv0_n28_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A3__8S2489C17__8S2489C23[] = {
  ABISELECT(-68416,-38128),
  ABISELECT(-75408,-42060),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C10__8S2489C23[] = {
  ABISELECT(928,552),
  ABISELECT(800,468),
  ABISELECT(672,396),
  ABISELECT(288,192),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C10__8S2489C23[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(-288,-192),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZThn800_N8S2489C10D1Ev,_ZThn468_N8S2489C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void ABISELECT(_ZThn800_N8S2489C10D0Ev,_ZThn468_N8S2489C10D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C10__8S2489C23[] = {
  0,
  ABISELECT(-800,-468),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(-800,-468),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C10__8S2489C23[] = {
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-928,-552),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C23[] = {
  ABISELECT(384,204),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C8D1Ev();
extern void _ZN7S2489C8D0Ev();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C23[] = {
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C8__8S2489C23[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(512,276),
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C23[] = {
  ABISELECT(-256,-156),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C5[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C67S2489C5__A1__8S2489C23[] = {
  ABISELECT(-256,-156),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C20D1Ev();
extern void _ZN8S2489C20D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C20__8S2489C23[] = {
  ABISELECT(-13968,-7716),
  ABISELECT(-15536,-8584),
  ABISELECT(-15664,-8668),
  ABISELECT(-15792,-8740),
  ABISELECT(-16176,-8944),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN8S2489C20D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C20D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN7S2489C9D1Ev();
extern void _ZN7S2489C9D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C98S2489C20__8S2489C23[] = {
  ABISELECT(-15536,-8584),
  ABISELECT(-15664,-8668),
  ABISELECT(-15792,-8740),
  ABISELECT(-16176,-8944),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C107S2489C98S2489C20__A2__8S2489C23[] = {
  ABISELECT(-15536,-8584),
  ABISELECT(-15664,-8668),
  ABISELECT(-15792,-8740),
  ABISELECT(-16176,-8944),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C107S2489C98S2489C20__A2__8S2489C23[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(16176,8944),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C107S2489C98S2489C20__A2__8S2489C23[] = {
  0,
  ABISELECT(15664,8668),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(15664,8668),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C107S2489C98S2489C20__A2__8S2489C23[] = {
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(15536,8584),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C98S2489C20__8S2489C23[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(16176,8944),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev)();
extern void ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__7S2489C98S2489C20__8S2489C23[] = {
  0,
  ABISELECT(15664,8668),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(15664,8668),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__7S2489C98S2489C20__8S2489C23[] = {
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(15536,8584),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C20__8S2489C23[] = {
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(15536,8584),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A1__8S2489C20__8S2489C23[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(16176,8944),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C20D1Ev,_ZTv0_n20_N8S2489C20D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C20D0Ev,_ZTv0_n20_N8S2489C20D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C20__8S2489C23[] = {
  0,
  ABISELECT(15664,8668),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(15664,8668),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C20D1Ev,_ZTv0_n20_N8S2489C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C20D0Ev,_ZTv0_n20_N8S2489C20D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN8S2489C133v11Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C13__8S2489C20__8S2489C23[] = {
  0,
  ABISELECT(13968,7716),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
};
extern void _ZN8S2489C19D1Ev();
extern void _ZN8S2489C19D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A1__8S2489C23[] = {
  ABISELECT(-67744,-37708),
  ABISELECT(-67872,-37792),
  ABISELECT(-68000,-37864),
  ABISELECT(-68384,-38068),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN8S2489C19D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C19D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C108S2489C19__A3__8S2489C23[] = {
  ABISELECT(-67744,-37708),
  ABISELECT(-67872,-37792),
  ABISELECT(-68000,-37864),
  ABISELECT(-68384,-38068),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C108S2489C19__A3__8S2489C23[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(68384,38068),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C108S2489C19__A3__8S2489C23[] = {
  0,
  ABISELECT(67872,37792),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(67872,37792),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C108S2489C19__A3__8S2489C23[] = {
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(67744,37708),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A3__8S2489C23[] = {
  ABISELECT(-68416,-38128),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C19__A1__8S2489C23[] = {
  0,
  ABISELECT(67872,37792),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(67872,37792),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C19__A1__8S2489C23[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(68384,38068),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C19__A1__8S2489C23[] = {
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(67744,37708),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A__8S2489C19__A1__8S2489C23[] = {
  ABISELECT(-68416,-38128),
  ABISELECT(-416,-264),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
static  VTT_ENTRY vtt_S2489C23[] = {
  {&(_ZTV8S2489C23[10]),  10,120},
  {&(_tg__ZTV8S2489C17__8S2489C23[9]),  9,13},
  {&(_tg__ZTV8S2489C198S2489C17__8S2489C23[6]),  6,12},
  {&(_tg__ZTV8S2489C108S2489C198S2489C17__A1__8S2489C23[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C108S2489C198S2489C17__A1__8S2489C23[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C108S2489C198S2489C17__A1__8S2489C23[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C108S2489C198S2489C17__A1__8S2489C23[6]),  6,9},
  {&(_tg__ZTV7S2489C68S2489C198S2489C17__A2__8S2489C23[3]),  3,5},
  {&(_tg__ZTV7S2489C8__8S2489C198S2489C17__8S2489C23[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C198S2489C17__8S2489C23[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C198S2489C17__8S2489C23[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A__8S2489C198S2489C17__8S2489C23[3]),  3,5},
  {&(_tg__ZTV8S2489C218S2489C17__8S2489C23[7]),  7,9},
  {&(_tg__ZTV7S2489C6__8S2489C218S2489C17__8S2489C23[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C218S2489C17__8S2489C23[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C218S2489C17__8S2489C23[6]),  6,9},
  {&(_tg__ZTV8S2489C19__8S2489C218S2489C17__8S2489C23[13]),  13,19},
  {&(_tg__ZTV7S2489C68S2489C19__A2__8S2489C218S2489C17__8S2489C23[3]),  3,5},
  {&(_tg__ZTV8S2489C19__A__8S2489C17__8S2489C23[6]),  6,12},
  {&(_tg__ZTV7S2489C8__8S2489C17__8S2489C23[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C17__8S2489C23[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C17__8S2489C23[6]),  6,9},
  {&(_tg__ZTV7S2489C68S2489C19__A2__8S2489C17__8S2489C23[3]),  3,5},
  {&(_tg__ZTV8S2489C20__8S2489C17__8S2489C23[11]),  11,16},
  {&(_tg__ZTV8S2489C13__8S2489C17__8S2489C23[3]),  3,4},
  {&(_tg__ZTV8S2489C21__8S2489C17__8S2489C23[7]),  7,9},
  {&(_tg__ZTV8S2489C19__A1__8S2489C17__8S2489C23[13]),  13,19},
  {&(_tg__ZTV7S2489C68S2489C19__A3__8S2489C17__8S2489C23[3]),  3,5},
  {&(_ZTV8S2489C23[48]),  48,120},
  {&(_ZTV8S2489C23[56]),  56,120},
  {&(_ZTV8S2489C23[64]),  64,120},
  {&(_ZTV8S2489C23[73]),  73,120},
  {&(_ZTV8S2489C23[79]),  79,120},
  {&(_ZTV8S2489C23[20]),  20,120},
  {&(_ZTV8S2489C23[29]),  29,120},
  {&(_ZTV8S2489C23[91]),  91,120},
  {&(_ZTV8S2489C23[38]),  38,120},
  {&(_ZTV8S2489C23[109]),  109,120},
  {&(_ZTV8S2489C23[118]),  118,120},
  {&(_tg__ZTV8S2489C10__8S2489C23[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C10__8S2489C23[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C10__8S2489C23[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C10__8S2489C23[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C23[3]),  3,5},
  {&(_tg__ZTV7S2489C8__8S2489C23[4]),  4,7},
  {&(_tg__ZTV7S2489C6__7S2489C8__8S2489C23[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C23[3]),  3,6},
  {&(_tg__ZTV7S2489C67S2489C5__A1__8S2489C23[3]),  3,5},
  {&(_tg__ZTV8S2489C20__8S2489C23[7]),  7,12},
  {&(_tg__ZTV7S2489C98S2489C20__8S2489C23[6]),  6,11},
  {&(_tg__ZTV8S2489C107S2489C98S2489C20__A2__8S2489C23[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C107S2489C98S2489C20__A2__8S2489C23[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C107S2489C98S2489C20__A2__8S2489C23[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C107S2489C98S2489C20__A2__8S2489C23[6]),  6,9},
  {&(_tg__ZTV7S2489C6__7S2489C98S2489C20__8S2489C23[5]),  5,7},
  {&(_tg__ZTV7S2489C8__7S2489C98S2489C20__8S2489C23[6]),  6,9},
  {&(_tg__ZTV7S2489C5__7S2489C98S2489C20__8S2489C23[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C20__8S2489C23[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A1__8S2489C20__8S2489C23[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C20__8S2489C23[6]),  6,9},
  {&(_tg__ZTV8S2489C13__8S2489C20__8S2489C23[3]),  3,4},
  {&(_tg__ZTV8S2489C19__A1__8S2489C23[6]),  6,12},
  {&(_tg__ZTV8S2489C108S2489C19__A3__8S2489C23[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C108S2489C19__A3__8S2489C23[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C108S2489C19__A3__8S2489C23[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C108S2489C19__A3__8S2489C23[6]),  6,9},
  {&(_tg__ZTV7S2489C68S2489C19__A3__8S2489C23[3]),  3,5},
  {&(_tg__ZTV7S2489C8__8S2489C19__A1__8S2489C23[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C19__A1__8S2489C23[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C19__A1__8S2489C23[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A__8S2489C19__A1__8S2489C23[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S2489C23[];
extern  VTBL_ENTRY _ZTV8S2489C23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C23[];
static VTBL_ENTRY alt_thunk_names10[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C17D0Ev,_ZTv0_n28_N8S2489C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn74992_N8S2489C17D0Ev,_ZThn41796_N8S2489C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C17D1Ev,_ZTv0_n28_N8S2489C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn74992_N8S2489C17D1Ev,_ZThn41796_N8S2489C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C17D0Ev,_ZTv0_n32_N8S2489C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn22784_N8S2489C17D0Ev,_ZThn12672_N8S2489C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C17D1Ev,_ZTv0_n32_N8S2489C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn22784_N8S2489C17D1Ev,_ZThn12672_N8S2489C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C17D0Ev,_ZTv0_n20_N8S2489C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7120_N8S2489C17D0Ev,_ZThn4004_N8S2489C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C17D1Ev,_ZTv0_n20_N8S2489C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7120_N8S2489C17D1Ev,_ZThn4004_N8S2489C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72288_N8S2489C21D0Ev,_ZThn40296_N8S2489C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72288_N8S2489C21D1Ev,_ZThn40296_N8S2489C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4416_N8S2489C21D0Ev,_ZThn2504_N8S2489C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4416_N8S2489C21D1Ev,_ZThn2504_N8S2489C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7024_N8S2489C19D0Ev,_ZThn3960_N8S2489C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7024_N8S2489C19D1Ev,_ZThn3960_N8S2489C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn800_N8S2489C10D0Ev,_ZThn468_N8S2489C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn7024_N8S2489C10D0Ev,_ZThn3960_N8S2489C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn800_N8S2489C10D1Ev,_ZThn468_N8S2489C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn7024_N8S2489C10D1Ev,_ZThn3960_N8S2489C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C23D0Ev,_ZTv0_n32_N8S2489C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn22784_N8S2489C23D0Ev,_ZThn12672_N8S2489C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C23D1Ev,_ZTv0_n32_N8S2489C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn22784_N8S2489C23D1Ev,_ZThn12672_N8S2489C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C23D0Ev,_ZTv0_n20_N8S2489C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7120_N8S2489C23D0Ev,_ZThn4004_N8S2489C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C23D1Ev,_ZTv0_n20_N8S2489C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7120_N8S2489C23D1Ev,_ZThn4004_N8S2489C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C23D0Ev,_ZTv0_n28_N8S2489C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn74992_N8S2489C23D0Ev,_ZThn41796_N8S2489C23D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn6320_N8S2489C23D0Ev,_ZThn3536_N8S2489C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C23D1Ev,_ZTv0_n28_N8S2489C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn74992_N8S2489C23D1Ev,_ZThn41796_N8S2489C23D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn6320_N8S2489C23D1Ev,_ZThn3536_N8S2489C23D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S2489C23 = {  "S2489C23", // class name
  bases_S2489C23, 27,
  &(vtc_S2489C23[0]), // expected_vtbl_contents
  &(vtt_S2489C23[0]), // expected_vtt_contents
  ABISELECT(77600,43252), // object size
  NSPAIRA(_ZTI8S2489C23),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV8S2489C23),120, //virtual function table var
  10, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S2489C23),71, //virtual table table var
  18, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names10,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2489C22  : virtual S2489C23 , S2489C5 {
  __tsi64 s2489c22f0;
  short s2489c22f1;
  __tsi64  :0;
  void *s2489c22f3;
  void *s2489c22f4;
  long double s2489c22f5[10];
  int s2489c22f6;
  void *s2489c22f7;
  void *s2489c22f8;
  int s2489c22f9;
  long s2489c22f10;
  void *s2489c22f11;
  virtual void  v14(); // _ZN8S2489C223v14Ev
  virtual void  v15(); // _ZN8S2489C223v15Ev
  ~S2489C22(); // tgen
  S2489C22(); // tgen
};
//SIG(-1 S2489C22) C1{ VBC2{ VBC3{ BC4{ m Fc Fi FL FU5{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} VBC6{ VBC4 v3 v4 Fp Fp Fi Fi FU7{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU7 Fp FL:3 FC4 FL FU7} VBC8{ VBC4 VBC6 vd v5 FL FL FL FL Fi FU7 Fc[10] Fi} VBC9{ BC4 BC6 v6 Fp FD FC4[7] FD FU5 Fs FL FL} vd v7 Fc Fi[7] Fl[5] FL FL FL FU10{ m Fp Fi Fp Fc Fc FL[5] Fp Fp Fp}} VBC11{ v8 FD FC12{ VBC9 VBC8 Fi Fp Fi FU7}[6] Fc Fp Fp Fi[6] Fi Fp FL Fp Fi Fp Fp} BC13{ BC14{ vd m FU5} BC15{ VBC8 BC3 BC4 BC6 vd v9 v10 v11 FU7 Fi Fl Fc Fp FC9 Fs} VBC16{ VBC9 VBC6 VBC8 BC17{ BC3 vd v12 v13 Fp Fp Fp Fi FC18{} FL FL} VBC11 vd Fc Fs[3] FC19{ BC4 VBC6 VBC8 VBC9 VBC15 vd FL Fi Fp Fp FL}[10] FC9 FL FL:5 Fi Fp[6] FL[2] FL Fi} BC19 vd v14 v15 Fi FD Fl Fc:3 Fp FC6} vd Fp[6] Fi Fs FC18 FC20{ BC4 VBC9 VBC8 BC17 vd FD} Fp Fi Fi Fc Fc FU5} BC9 v1 v2 FL Fs FL:0 Fp Fp FD[10] Fi Fp Fp Fi Fl Fp}


void  S2489C22 ::v14(){vfunc_called(this, "_ZN8S2489C223v14Ev");}
void  S2489C22 ::v15(){vfunc_called(this, "_ZN8S2489C223v15Ev");}
S2489C22 ::~S2489C22(){ note_dtor("S2489C22", this);} // tgen
S2489C22 ::S2489C22(){ note_ctor("S2489C22", this);} // tgen

static void Test_S2489C22()
{
  extern Class_Descriptor cd_S2489C22;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(4964,11072)];
    init_test(&cd_S2489C22, buf);
    S2489C22 *dp, &lv = *(dp=new (buf) S2489C22());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(79408,44284), "sizeof(S2489C22)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2489C22)");
    /*is_ambiguous_... S2489C22::S2489C10 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*), ABISELECT(8144,4572), "S2489C22");
    /*is_ambiguous_... S2489C22::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*), ABISELECT(8800,4964), "S2489C22");
    check_base_class_offset(lv, (S2489C3*)(S2489C8*), ABISELECT(8800,4964), "S2489C22");
    /*is_ambiguous_... S2489C22::S2489C5 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C5*), ABISELECT(8800,4964), "S2489C22");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(8800,4964), "S2489C22");
    /*is_ambiguous_... S2489C22::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C19*), ABISELECT(8800,4964), "S2489C22");
    /*is_ambiguous_... S2489C22::S2489C5 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C5*), ABISELECT(8800,4964), "S2489C22");
    /*is_ambiguous_... S2489C22::S2489C10 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*), ABISELECT(8416,4760), "S2489C22");
    check_base_class_offset(lv, (S2489C6*)(S2489C8*), ABISELECT(8416,4760), "S2489C22");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(8416,4760), "S2489C22");
    /*is_ambiguous_... S2489C20::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C20*), ABISELECT(8416,4760), "S2489C22");
    /*is_ambiguous_... S2489C10::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(8416,4760), "S2489C22");
    /*is_ambiguous_... S2489C21::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C21*)(S2489C17*)(S2489C23*), ABISELECT(8416,4760), "S2489C22");
    /*is_ambiguous_... S2489C22::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*)(S2489C19*), ABISELECT(8416,4760), "S2489C22");
    /*is_ambiguous_... S2489C22::S2489C10 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C10*), ABISELECT(8928,5036), "S2489C22");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(8928,5036), "S2489C22");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C10*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(8928,5036), "S2489C22");
    check_base_class_offset(lv, (S2489C8*)(S2489C20*), ABISELECT(8928,5036), "S2489C22");
    check_base_class_offset(lv, (S2489C8*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(8928,5036), "S2489C22");
    check_base_class_offset(lv, (S2489C8*)(S2489C21*)(S2489C17*)(S2489C23*), ABISELECT(8928,5036), "S2489C22");
    /*is_ambiguous_... S2489C22::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C19*), ABISELECT(8928,5036), "S2489C22");
    /*is_ambiguous_... S2489C22::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C10*)(S2489C19*), ABISELECT(8928,5036), "S2489C22");
    /*is_ambiguous_... S2489C22::S2489C5 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C5*), ABISELECT(9440,5324), "S2489C22");
    /*is_ambiguous_... S2489C22::S2489C5 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C5*), ABISELECT(9056,5120), "S2489C22");
    /*is_ambiguous_... S2489C22::S2489C10 */ AMB_check_base_class_offset(lv, (S2489C5*)(S2489C10*), ABISELECT(9056,5120), "S2489C22");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C5*)(S2489C10*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(9056,5120), "S2489C22");
    check_base_class_offset(lv, (S2489C5*)(S2489C20*), ABISELECT(9056,5120), "S2489C22");
    check_base_class_offset(lv, (S2489C5*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(9056,5120), "S2489C22");
    check_base_class_offset(lv, (S2489C5*)(S2489C21*)(S2489C17*)(S2489C23*), ABISELECT(9056,5120), "S2489C22");
    /*is_ambiguous_... S2489C22::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C5*)(S2489C10*)(S2489C19*), ABISELECT(9056,5120), "S2489C22");
    /*is_ambiguous_... S2489C23::S2489C10 */ AMB_check_base_class_offset(lv, (S2489C10*)(S2489C23*), ABISELECT(8128,4568), "S2489C22");
    check_base_class_offset(lv, (S2489C13*)(S2489C23*), ABISELECT(10624,5988), "S2489C22");
    check_base_class_offset(lv, (S2489C13*)(S2489C20*), ABISELECT(10624,5988), "S2489C22");
    check_base_class_offset(lv, (S2489C18*)(S2489C17*)(S2489C23*), ABISELECT(1808,1032), "S2489C22");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(1920,1080), "S2489C22");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C10*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(1904,1076), "S2489C22");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(2192,1268), "S2489C22");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(2320,1340), "S2489C22");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(1904,1076), "S2489C22");
    /*is_ambiguous_... S2489C10::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(24608,13708), "S2489C22");
    check_base_class_offset(lv, (S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(24592,13704), "S2489C22");
    check_base_class_offset(lv, (S2489C9*)(S2489C20*), ABISELECT(24592,13704), "S2489C22");
    check_base_class_offset(lv, (S2489C20*)(S2489C17*)(S2489C23*), ABISELECT(24592,13704), "S2489C22");
    /*is_ambiguous_... S2489C21::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C21*)(S2489C17*)(S2489C23*), ABISELECT(4528,2536), "S2489C22");
    /*is_ambiguous_... S2489C22::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*)(S2489C19*), ABISELECT(76816,42832), "S2489C22");
    /*is_ambiguous_... S2489C22::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C10*)(S2489C19*), ABISELECT(76800,42828), "S2489C22");
    /*is_ambiguous_... S2489C22::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C19*), ABISELECT(77088,43020), "S2489C22");
    /*is_ambiguous_... S2489C22::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C19*), ABISELECT(77216,43092), "S2489C22");
    check_base_class_offset(lv, (S2489C19*)(S2489C21*)(S2489C17*)(S2489C23*), ABISELECT(76800,42828), "S2489C22");
    check_base_class_offset(lv, (S2489C21*)(S2489C17*)(S2489C23*), ABISELECT(4512,2532), "S2489C22");
    check_base_class_offset(lv, (S2489C17*)(S2489C23*), ABISELECT(1808,1032), "S2489C22");
    check_base_class_offset(lv, (S2489C23*), ABISELECT(1808,1032), "S2489C22");
    /*is_ambiguous_... S2489C22::S2489C5 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C5*), ABISELECT(384,204), "S2489C22");
    /*is_ambiguous_... S2489C22::S2489C5 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C5*), 0, "S2489C22");
    /*is_ambiguous_... S2489C22::S2489C5 */ AMB_check_base_class_offset(lv, (S2489C5*), 0, "S2489C22");
    check_field_offset(lv, s2489c22f0, ABISELECT(1560,868), "S2489C22.s2489c22f0");
    check_field_offset(lv, s2489c22f1, ABISELECT(1568,876), "S2489C22.s2489c22f1");
    check_field_offset(lv, s2489c22f3, ABISELECT(1576,880), "S2489C22.s2489c22f3");
    check_field_offset(lv, s2489c22f4, ABISELECT(1584,884), "S2489C22.s2489c22f4");
    check_field_offset(lv, s2489c22f5, ABISELECT(1600,888), "S2489C22.s2489c22f5");
    check_field_offset(lv, s2489c22f6, ABISELECT(1760,1008), "S2489C22.s2489c22f6");
    check_field_offset(lv, s2489c22f7, ABISELECT(1768,1012), "S2489C22.s2489c22f7");
    check_field_offset(lv, s2489c22f8, ABISELECT(1776,1016), "S2489C22.s2489c22f8");
    check_field_offset(lv, s2489c22f9, ABISELECT(1784,1020), "S2489C22.s2489c22f9");
    check_field_offset(lv, s2489c22f10, ABISELECT(1792,1024), "S2489C22.s2489c22f10");
    check_field_offset(lv, s2489c22f11, ABISELECT(1800,1028), "S2489C22.s2489c22f11");
    test_class_info(&lv, &cd_S2489C22);
    dp->~S2489C22();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2489C22(Test_S2489C22, "S2489C22", ABISELECT(79408,44284));

#else // __cplusplus

extern void _ZN8S2489C22C1Ev();
extern void _ZN8S2489C22D1Ev();
Name_Map name_map_S2489C22[] = {
  NSPAIR(_ZN8S2489C22C1Ev),
  NSPAIR(_ZN8S2489C22D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C8;
extern VTBL_ENTRY _ZTI7S2489C8[];
extern  VTBL_ENTRY _ZTV7S2489C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C8[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C5;
extern VTBL_ENTRY _ZTI7S2489C5[];
extern  VTBL_ENTRY _ZTV7S2489C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C5[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C13;
extern VTBL_ENTRY _ZTI8S2489C13[];
extern  VTBL_ENTRY _ZTV8S2489C13[];
extern Class_Descriptor cd_S2489C18;
extern VTBL_ENTRY _ZTI8S2489C18[];
extern  VTBL_ENTRY _ZTV8S2489C18[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C19;
extern VTBL_ENTRY _ZTI8S2489C19[];
extern  VTBL_ENTRY _ZTV8S2489C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C19[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C9;
extern VTBL_ENTRY _ZTI7S2489C9[];
extern  VTBL_ENTRY _ZTV7S2489C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C9[];
extern Class_Descriptor cd_S2489C20;
extern VTBL_ENTRY _ZTI8S2489C20[];
extern  VTBL_ENTRY _ZTV8S2489C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C20[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C19;
extern VTBL_ENTRY _ZTI8S2489C19[];
extern  VTBL_ENTRY _ZTV8S2489C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C19[];
extern Class_Descriptor cd_S2489C21;
extern VTBL_ENTRY _ZTI8S2489C21[];
extern  VTBL_ENTRY _ZTV8S2489C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C21[];
extern Class_Descriptor cd_S2489C17;
extern VTBL_ENTRY _ZTI8S2489C17[];
extern  VTBL_ENTRY _ZTV8S2489C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C17[];
extern Class_Descriptor cd_S2489C23;
extern VTBL_ENTRY _ZTI8S2489C23[];
extern  VTBL_ENTRY _ZTV8S2489C23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C23[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C5;
extern VTBL_ENTRY _ZTI7S2489C5[];
extern  VTBL_ENTRY _ZTV7S2489C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C5[];
static Base_Class bases_S2489C22[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C3,    ABISELECT(8144,4572), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(8800,4964), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S2489C6,    ABISELECT(8416,4760), //bcp->offset
    78, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    59, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S2489C8,    ABISELECT(8928,5036), //bcp->offset
    85, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    60, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S2489C3,    ABISELECT(9440,5324), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2489C6,    ABISELECT(9056,5120), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    63, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2489C5,    ABISELECT(9056,5120), //bcp->offset
    94, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    62, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S2489C10,    ABISELECT(8128,4568), //bcp->offset
    67, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    55, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    27, //immediately_derived
  0, 1},
  {&cd_S2489C13,    ABISELECT(10624,5988), //bcp->offset
    103, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    18, //immediately_derived
  0, 1},
  {&cd_S2489C18,    ABISELECT(1808,1032), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(1920,1080), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S2489C10,    ABISELECT(1904,1076), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(2192,1268), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S2489C6,    ABISELECT(2320,1340), //bcp->offset
    53, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S2489C19,    ABISELECT(1904,1076), //bcp->offset
    41, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(24608,13708), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S2489C10,    ABISELECT(24592,13704), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    66, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S2489C9,    ABISELECT(24592,13704), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    65, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S2489C20,    ABISELECT(24592,13704), //bcp->offset
    107, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    64, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    26, //immediately_derived
  0, 1},
  {&cd_S2489C3,    ABISELECT(4528,2536), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(76816,42832), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S2489C10,    ABISELECT(76800,42828), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    78, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(77088,43020), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S2489C6,    ABISELECT(77216,43092), //bcp->offset
    142, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    82, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S2489C19,    ABISELECT(76800,42828), //bcp->offset
    123, //bcp->virtual_function_table_offset
    13, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    77, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    25, //immediately_derived
  0, 1},
  {&cd_S2489C21,    ABISELECT(4512,2532), //bcp->offset
    58, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    26, //immediately_derived
  0, 0},
  {&cd_S2489C17,    ABISELECT(1808,1032), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    27, //immediately_derived
  0, 0},
  {&cd_S2489C23,    ABISELECT(1808,1032), //bcp->offset
    18, //bcp->virtual_function_table_offset
    19, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C3,    ABISELECT(384,204), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S2489C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S2489C5,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S2489C22[];
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
extern void _ZN8S2489C223v14Ev();
extern void _ZN8S2489C223v15Ev();
extern void _ZN8S2489C22D1Ev();
extern void _ZN8S2489C22D0Ev();
extern void ABISELECT(_ZTv0_n88_N8S2489C22D1Ev,_ZTv0_n44_N8S2489C22D1Ev)();
extern void ABISELECT(_ZThn1808_N8S2489C22D1Ev,_ZThn1032_N8S2489C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n88_N8S2489C22D0Ev,_ZTv0_n44_N8S2489C22D0Ev)();
extern void ABISELECT(_ZThn1808_N8S2489C22D0Ev,_ZThn1032_N8S2489C22D0Ev)() __attribute__((weak));
extern void _ZN8S2489C173v12Ev();
extern void _ZN8S2489C173v13Ev();
extern void ABISELECT(_ZTvn96_n88_N8S2489C22D1Ev,_ZTvn44_n44_N8S2489C22D1Ev)();
extern void ABISELECT(_ZTvn96_n88_N8S2489C22D0Ev,_ZTvn44_n44_N8S2489C22D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void ABISELECT(_ZTvn2704_n88_N8S2489C22D1Ev,_ZTvn1500_n44_N8S2489C22D1Ev)();
extern void ABISELECT(_ZTvn2704_n88_N8S2489C22D0Ev,_ZTvn1500_n44_N8S2489C22D0Ev)();
extern void ABISELECT(_ZTv0_n56_N8S2489C22D1Ev,_ZTv0_n28_N8S2489C22D1Ev)();
extern void ABISELECT(_ZThn8128_N8S2489C22D1Ev,_ZThn4568_N8S2489C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C22D0Ev,_ZTv0_n28_N8S2489C22D0Ev)();
extern void ABISELECT(_ZThn8128_N8S2489C22D0Ev,_ZThn4568_N8S2489C22D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void ABISELECT(_ZTv0_n40_N8S2489C22D1Ev,_ZTv0_n20_N8S2489C22D1Ev)();
extern void ABISELECT(_ZThn8928_N8S2489C22D1Ev,_ZThn5036_N8S2489C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C22D0Ev,_ZTv0_n20_N8S2489C22D0Ev)();
extern void ABISELECT(_ZThn8928_N8S2489C22D0Ev,_ZThn5036_N8S2489C22D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
extern void _ZN8S2489C133v11Ev();
extern void ABISELECT(_ZTv0_n64_N8S2489C22D1Ev,_ZTv0_n32_N8S2489C22D1Ev)();
extern void ABISELECT(_ZThn24592_N8S2489C22D1Ev,_ZThn13704_N8S2489C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S2489C22D0Ev,_ZTv0_n32_N8S2489C22D0Ev)();
extern void ABISELECT(_ZThn24592_N8S2489C22D0Ev,_ZThn13704_N8S2489C22D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
extern void ABISELECT(_ZTv0_n56_N8S2489C22D1Ev,_ZTv0_n28_N8S2489C22D1Ev)();
extern void ABISELECT(_ZThn76800_N8S2489C22D1Ev,_ZThn42828_N8S2489C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C22D0Ev,_ZTv0_n28_N8S2489C22D0Ev)();
extern void ABISELECT(_ZThn76800_N8S2489C22D0Ev,_ZThn42828_N8S2489C22D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY vtc_S2489C22[] = {
  ABISELECT(76800,42828),
  ABISELECT(24592,13704),
  ABISELECT(10624,5988),
  ABISELECT(9056,5120),
  ABISELECT(8928,5036),
  ABISELECT(8416,4760),
  ABISELECT(8128,4568),
  ABISELECT(1808,1032),
  ABISELECT(8800,4964),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
  (VTBL_ENTRY)&_ZN8S2489C223v14Ev,
  (VTBL_ENTRY)&_ZN8S2489C223v15Ev,
  (VTBL_ENTRY)&_ZN8S2489C22D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C22D0Ev,
  ABISELECT(512,308),
  ABISELECT(512,308),
  ABISELECT(96,44),
  ABISELECT(96,44),
  ABISELECT(96,44),
  ABISELECT(96,44),
  0,
  0,
  ABISELECT(-1808,-1032),
  ABISELECT(6320,3536),
  ABISELECT(74992,41796),
  ABISELECT(8816,4956),
  ABISELECT(22784,12672),
  ABISELECT(7248,4088),
  ABISELECT(6608,3728),
  ABISELECT(6992,3932),
  ABISELECT(7120,4004),
  ABISELECT(-1808,-1032),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n88_N8S2489C22D1Ev,_ZTv0_n44_N8S2489C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n88_N8S2489C22D0Ev,_ZTv0_n44_N8S2489C22D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C173v12Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v13Ev,
  ABISELECT(7152,4044),
  ABISELECT(7024,3960),
  ABISELECT(6896,3888),
  ABISELECT(6512,3684),
  ABISELECT(-1904,-1076),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n88_N8S2489C22D1Ev,_ZTvn44_n44_N8S2489C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n88_N8S2489C22D0Ev,_ZTvn44_n44_N8S2489C22D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
  ABISELECT(6480,3624),
  ABISELECT(-2320,-1340),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  ABISELECT(72288,40296),
  ABISELECT(4544,2588),
  ABISELECT(4416,2504),
  ABISELECT(4288,2432),
  ABISELECT(3904,2228),
  ABISELECT(-4512,-2532),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2704_n88_N8S2489C22D1Ev,_ZTvn1500_n44_N8S2489C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2704_n88_N8S2489C22D0Ev,_ZTvn1500_n44_N8S2489C22D0Ev),
  0,
  ABISELECT(-8128,-4568),
  ABISELECT(928,552),
  ABISELECT(800,468),
  ABISELECT(672,396),
  ABISELECT(288,192),
  ABISELECT(-8128,-4568),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C22D1Ev,_ZTv0_n28_N8S2489C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C22D0Ev,_ZTv0_n28_N8S2489C22D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(-8416,-4760),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  0,
  ABISELECT(-8928,-5036),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(-8928,-5036),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C22D1Ev,_ZTv0_n20_N8S2489C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C22D0Ev,_ZTv0_n20_N8S2489C22D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-9056,-5120),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
  0,
  ABISELECT(-10624,-5988),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
  0,
  0,
  0,
  ABISELECT(-24592,-13704),
  ABISELECT(-13968,-7716),
  ABISELECT(-15536,-8584),
  ABISELECT(-15664,-8668),
  ABISELECT(-15792,-8740),
  ABISELECT(-16176,-8944),
  ABISELECT(-24592,-13704),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C22D1Ev,_ZTv0_n32_N8S2489C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C22D0Ev,_ZTv0_n32_N8S2489C22D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(-76800,-42828),
  ABISELECT(-67744,-37708),
  ABISELECT(-67872,-37792),
  ABISELECT(-68000,-37864),
  ABISELECT(-68384,-38068),
  ABISELECT(-76800,-42828),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C22D1Ev,_ZTv0_n28_N8S2489C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C22D0Ev,_ZTv0_n28_N8S2489C22D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
  ABISELECT(-68416,-38128),
  ABISELECT(-77216,-43092),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern VTBL_ENTRY _ZTV8S2489C22[];
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__A__8S2489C22[] = {
  ABISELECT(8800,4964),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C5[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C67S2489C5__A4__8S2489C22[] = {
  ABISELECT(8800,4964),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C23D1Ev();
extern void _ZN8S2489C23D0Ev();
extern void _ZN8S2489C173v12Ev();
extern void _ZN8S2489C173v13Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C23__8S2489C22[] = {
  ABISELECT(6320,3536),
  ABISELECT(74992,41796),
  ABISELECT(8816,4956),
  ABISELECT(22784,12672),
  ABISELECT(7248,4088),
  ABISELECT(6608,3728),
  ABISELECT(6992,3932),
  ABISELECT(7120,4004),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&_ZN8S2489C23D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C23D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v12Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v13Ev,
};
extern void _ZN8S2489C17D1Ev();
extern void _ZN8S2489C17D0Ev();
extern void _ZN8S2489C173v12Ev();
extern void _ZN8S2489C173v13Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C178S2489C23__8S2489C22[] = {
  ABISELECT(74992,41796),
  ABISELECT(8816,4956),
  ABISELECT(22784,12672),
  ABISELECT(7248,4088),
  ABISELECT(6608,3728),
  ABISELECT(6992,3932),
  ABISELECT(7120,4004),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN8S2489C17D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C17D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v12Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v13Ev,
};
extern void _ZN8S2489C19D1Ev();
extern void _ZN8S2489C19D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C198S2489C178S2489C23__8S2489C22[] = {
  ABISELECT(7152,4044),
  ABISELECT(7024,3960),
  ABISELECT(6896,3888),
  ABISELECT(6512,3684),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN8S2489C19D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C19D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C108S2489C198S2489C178S2489C23__A1__8S2489C22[] = {
  ABISELECT(7152,4044),
  ABISELECT(7024,3960),
  ABISELECT(6896,3888),
  ABISELECT(6512,3684),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C108S2489C198S2489C178S2489C23__A1__8S2489C22[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(-6512,-3684),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZThn7024_N8S2489C10D1Ev,_ZThn3960_N8S2489C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void ABISELECT(_ZThn7024_N8S2489C10D0Ev,_ZThn3960_N8S2489C10D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C108S2489C198S2489C178S2489C23__A1__8S2489C22[] = {
  0,
  ABISELECT(-7024,-3960),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(-7024,-3960),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C108S2489C198S2489C178S2489C23__A1__8S2489C22[] = {
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-7152,-4044),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C198S2489C178S2489C23__A2__8S2489C22[] = {
  ABISELECT(6480,3624),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev)();
extern void ABISELECT(_ZThn7024_N8S2489C19D1Ev,_ZThn3960_N8S2489C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev)();
extern void ABISELECT(_ZThn7024_N8S2489C19D0Ev,_ZThn3960_N8S2489C19D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C198S2489C178S2489C23__8S2489C22[] = {
  0,
  ABISELECT(-7024,-3960),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(-7024,-3960),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C198S2489C178S2489C23__8S2489C22[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(-6512,-3684),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C198S2489C178S2489C23__8S2489C22[] = {
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-7152,-4044),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A__8S2489C198S2489C178S2489C23__8S2489C22[] = {
  ABISELECT(6480,3624),
  ABISELECT(-416,-264),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C21D1Ev();
extern void _ZN8S2489C21D0Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C218S2489C178S2489C23__8S2489C22[] = {
  ABISELECT(72288,40296),
  ABISELECT(4544,2588),
  ABISELECT(4416,2504),
  ABISELECT(4288,2432),
  ABISELECT(3904,2228),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN8S2489C21D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C21D0Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C218S2489C178S2489C23__8S2489C22[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(-3904,-2228),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev)();
extern void ABISELECT(_ZThn4416_N8S2489C21D1Ev,_ZThn2504_N8S2489C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev)();
extern void ABISELECT(_ZThn4416_N8S2489C21D0Ev,_ZThn2504_N8S2489C21D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C218S2489C178S2489C23__8S2489C22[] = {
  0,
  ABISELECT(-4416,-2504),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(-4416,-2504),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C218S2489C178S2489C23__8S2489C22[] = {
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-4544,-2588),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev)();
extern void ABISELECT(_ZThn72288_N8S2489C21D1Ev,_ZThn40296_N8S2489C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev)();
extern void ABISELECT(_ZThn72288_N8S2489C21D0Ev,_ZThn40296_N8S2489C21D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__8S2489C218S2489C178S2489C23__8S2489C22[] = {
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(-72288,-40296),
  ABISELECT(-67744,-37708),
  ABISELECT(-67872,-37792),
  ABISELECT(-68000,-37864),
  ABISELECT(-68384,-38068),
  ABISELECT(-72288,-40296),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A2__8S2489C218S2489C178S2489C23__8S2489C22[] = {
  ABISELECT(-68416,-38128),
  ABISELECT(-72704,-40560),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZThn96_N8S2489C17D1Ev,_ZThn44_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn96_N8S2489C17D0Ev,_ZThn44_N8S2489C17D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A__8S2489C178S2489C23__8S2489C22[] = {
  ABISELECT(7152,4044),
  ABISELECT(7024,3960),
  ABISELECT(6896,3888),
  ABISELECT(6512,3684),
  ABISELECT(-96,-44),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C17D1Ev,_ZThn44_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C17D0Ev,_ZThn44_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C17D1Ev,_ZTv0_n20_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn7120_N8S2489C17D1Ev,_ZThn4004_N8S2489C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C17D0Ev,_ZTv0_n20_N8S2489C17D0Ev)();
extern void ABISELECT(_ZThn7120_N8S2489C17D0Ev,_ZThn4004_N8S2489C17D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C178S2489C23__8S2489C22[] = {
  0,
  ABISELECT(-7120,-4004),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(-7120,-4004),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C17D1Ev,_ZTv0_n20_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C17D0Ev,_ZTv0_n20_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C178S2489C23__8S2489C22[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(-6608,-3728),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C178S2489C23__8S2489C22[] = {
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-7248,-4088),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A2__8S2489C178S2489C23__8S2489C22[] = {
  ABISELECT(6480,3624),
  ABISELECT(-512,-308),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n64_N8S2489C17D1Ev,_ZTv0_n32_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn22784_N8S2489C17D1Ev,_ZThn12672_N8S2489C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S2489C17D0Ev,_ZTv0_n32_N8S2489C17D0Ev)();
extern void ABISELECT(_ZThn22784_N8S2489C17D0Ev,_ZThn12672_N8S2489C17D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C20__8S2489C178S2489C23__8S2489C22[] = {
  0,
  0,
  0,
  ABISELECT(-22784,-12672),
  ABISELECT(-13968,-7716),
  ABISELECT(-15536,-8584),
  ABISELECT(-15664,-8668),
  ABISELECT(-15792,-8740),
  ABISELECT(-16176,-8944),
  ABISELECT(-22784,-12672),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C17D1Ev,_ZTv0_n32_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C17D0Ev,_ZTv0_n32_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN8S2489C133v11Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C13__8S2489C178S2489C23__8S2489C22[] = {
  0,
  ABISELECT(-8816,-4956),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
};
extern void ABISELECT(_ZThn2704_N8S2489C17D1Ev,_ZThn1500_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn2704_N8S2489C17D0Ev,_ZThn1500_N8S2489C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S2489C21__8S2489C178S2489C23__8S2489C22[] = {
  ABISELECT(72288,40296),
  ABISELECT(4544,2588),
  ABISELECT(4416,2504),
  ABISELECT(4288,2432),
  ABISELECT(3904,2228),
  ABISELECT(-2704,-1500),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S2489C17D1Ev,_ZThn1500_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S2489C17D0Ev,_ZThn1500_N8S2489C17D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N8S2489C17D1Ev,_ZTv0_n28_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn74992_N8S2489C17D1Ev,_ZThn41796_N8S2489C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C17D0Ev,_ZTv0_n28_N8S2489C17D0Ev)();
extern void ABISELECT(_ZThn74992_N8S2489C17D0Ev,_ZThn41796_N8S2489C17D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A1__8S2489C178S2489C23__8S2489C22[] = {
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(-74992,-41796),
  ABISELECT(-67744,-37708),
  ABISELECT(-67872,-37792),
  ABISELECT(-68000,-37864),
  ABISELECT(-68384,-38068),
  ABISELECT(-74992,-41796),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C17D1Ev,_ZTv0_n28_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C17D0Ev,_ZTv0_n28_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A3__8S2489C178S2489C23__8S2489C22[] = {
  ABISELECT(-68416,-38128),
  ABISELECT(-75408,-42060),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S2489C23D1Ev,_ZTv0_n28_N8S2489C23D1Ev)();
extern void ABISELECT(_ZThn6320_N8S2489C23D1Ev,_ZThn3536_N8S2489C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C23D0Ev,_ZTv0_n28_N8S2489C23D0Ev)();
extern void ABISELECT(_ZThn6320_N8S2489C23D0Ev,_ZThn3536_N8S2489C23D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C10__8S2489C23__8S2489C22[] = {
  0,
  ABISELECT(-6320,-3536),
  ABISELECT(928,552),
  ABISELECT(800,468),
  ABISELECT(672,396),
  ABISELECT(288,192),
  ABISELECT(-6320,-3536),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C23D1Ev,_ZTv0_n28_N8S2489C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C23D0Ev,_ZTv0_n28_N8S2489C23D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C23__8S2489C22[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(-6608,-3728),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C23D1Ev,_ZTv0_n20_N8S2489C23D1Ev)();
extern void ABISELECT(_ZThn7120_N8S2489C23D1Ev,_ZThn4004_N8S2489C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C23D0Ev,_ZTv0_n20_N8S2489C23D0Ev)();
extern void ABISELECT(_ZThn7120_N8S2489C23D0Ev,_ZThn4004_N8S2489C23D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C23__8S2489C22[] = {
  0,
  ABISELECT(-7120,-4004),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(-7120,-4004),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C23D1Ev,_ZTv0_n20_N8S2489C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C23D0Ev,_ZTv0_n20_N8S2489C23D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C23__8S2489C22[] = {
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-7248,-4088),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN8S2489C133v11Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C13__8S2489C23__8S2489C22[] = {
  0,
  ABISELECT(-8816,-4956),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
};
extern void ABISELECT(_ZThn96_N8S2489C23D1Ev,_ZThn44_N8S2489C23D1Ev)();
extern void ABISELECT(_ZThn96_N8S2489C23D0Ev,_ZThn44_N8S2489C23D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C198S2489C17__8S2489C23__8S2489C22[] = {
  ABISELECT(7152,4044),
  ABISELECT(7024,3960),
  ABISELECT(6896,3888),
  ABISELECT(6512,3684),
  ABISELECT(-96,-44),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C23D1Ev,_ZThn44_N8S2489C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C23D0Ev,_ZThn44_N8S2489C23D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C198S2489C17__A2__8S2489C23__8S2489C22[] = {
  ABISELECT(6480,3624),
  ABISELECT(-512,-308),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n64_N8S2489C23D1Ev,_ZTv0_n32_N8S2489C23D1Ev)();
extern void ABISELECT(_ZThn22784_N8S2489C23D1Ev,_ZThn12672_N8S2489C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S2489C23D0Ev,_ZTv0_n32_N8S2489C23D0Ev)();
extern void ABISELECT(_ZThn22784_N8S2489C23D0Ev,_ZThn12672_N8S2489C23D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C20__8S2489C23__8S2489C22[] = {
  0,
  0,
  0,
  ABISELECT(-22784,-12672),
  ABISELECT(-13968,-7716),
  ABISELECT(-15536,-8584),
  ABISELECT(-15664,-8668),
  ABISELECT(-15792,-8740),
  ABISELECT(-16176,-8944),
  ABISELECT(-22784,-12672),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C23D1Ev,_ZTv0_n32_N8S2489C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C23D0Ev,_ZTv0_n32_N8S2489C23D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void ABISELECT(_ZThn2704_N8S2489C23D1Ev,_ZThn1500_N8S2489C23D1Ev)();
extern void ABISELECT(_ZThn2704_N8S2489C23D0Ev,_ZThn1500_N8S2489C23D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S2489C218S2489C17__8S2489C23__8S2489C22[] = {
  ABISELECT(72288,40296),
  ABISELECT(4544,2588),
  ABISELECT(4416,2504),
  ABISELECT(4288,2432),
  ABISELECT(3904,2228),
  ABISELECT(-2704,-1500),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S2489C23D1Ev,_ZThn1500_N8S2489C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S2489C23D0Ev,_ZThn1500_N8S2489C23D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N8S2489C23D1Ev,_ZTv0_n28_N8S2489C23D1Ev)();
extern void ABISELECT(_ZThn74992_N8S2489C23D1Ev,_ZThn41796_N8S2489C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C23D0Ev,_ZTv0_n28_N8S2489C23D0Ev)();
extern void ABISELECT(_ZThn74992_N8S2489C23D0Ev,_ZThn41796_N8S2489C23D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A1__8S2489C23__8S2489C22[] = {
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(-74992,-41796),
  ABISELECT(-67744,-37708),
  ABISELECT(-67872,-37792),
  ABISELECT(-68000,-37864),
  ABISELECT(-68384,-38068),
  ABISELECT(-74992,-41796),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C23D1Ev,_ZTv0_n28_N8S2489C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C23D0Ev,_ZTv0_n28_N8S2489C23D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A3__8S2489C23__8S2489C22[] = {
  ABISELECT(-68416,-38128),
  ABISELECT(-75408,-42060),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C10__8S2489C22[] = {
  ABISELECT(928,552),
  ABISELECT(800,468),
  ABISELECT(672,396),
  ABISELECT(288,192),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C10__8S2489C22[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(-288,-192),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZThn800_N8S2489C10D1Ev,_ZThn468_N8S2489C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void ABISELECT(_ZThn800_N8S2489C10D0Ev,_ZThn468_N8S2489C10D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C10__8S2489C22[] = {
  0,
  ABISELECT(-800,-468),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(-800,-468),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C10__8S2489C22[] = {
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-928,-552),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C22[] = {
  ABISELECT(384,204),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C8D1Ev();
extern void _ZN7S2489C8D0Ev();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C22[] = {
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C8__8S2489C22[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(512,276),
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C22[] = {
  ABISELECT(-256,-156),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C5[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C67S2489C5__A1__8S2489C22[] = {
  ABISELECT(-256,-156),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C20D1Ev();
extern void _ZN8S2489C20D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C20__8S2489C22[] = {
  ABISELECT(-13968,-7716),
  ABISELECT(-15536,-8584),
  ABISELECT(-15664,-8668),
  ABISELECT(-15792,-8740),
  ABISELECT(-16176,-8944),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN8S2489C20D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C20D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN7S2489C9D1Ev();
extern void _ZN7S2489C9D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C98S2489C20__8S2489C22[] = {
  ABISELECT(-15536,-8584),
  ABISELECT(-15664,-8668),
  ABISELECT(-15792,-8740),
  ABISELECT(-16176,-8944),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C107S2489C98S2489C20__A2__8S2489C22[] = {
  ABISELECT(-15536,-8584),
  ABISELECT(-15664,-8668),
  ABISELECT(-15792,-8740),
  ABISELECT(-16176,-8944),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C107S2489C98S2489C20__A2__8S2489C22[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(16176,8944),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C107S2489C98S2489C20__A2__8S2489C22[] = {
  0,
  ABISELECT(15664,8668),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(15664,8668),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C107S2489C98S2489C20__A2__8S2489C22[] = {
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(15536,8584),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C98S2489C20__8S2489C22[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(16176,8944),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev)();
extern void ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__7S2489C98S2489C20__8S2489C22[] = {
  0,
  ABISELECT(15664,8668),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(15664,8668),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__7S2489C98S2489C20__8S2489C22[] = {
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(15536,8584),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C20__8S2489C22[] = {
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(15536,8584),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A1__8S2489C20__8S2489C22[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(16176,8944),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C20D1Ev,_ZTv0_n20_N8S2489C20D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C20D0Ev,_ZTv0_n20_N8S2489C20D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C20__8S2489C22[] = {
  0,
  ABISELECT(15664,8668),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(15664,8668),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C20D1Ev,_ZTv0_n20_N8S2489C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C20D0Ev,_ZTv0_n20_N8S2489C20D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN8S2489C133v11Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C13__8S2489C20__8S2489C22[] = {
  0,
  ABISELECT(13968,7716),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
};
extern void _ZN8S2489C19D1Ev();
extern void _ZN8S2489C19D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A1__8S2489C22[] = {
  ABISELECT(-67744,-37708),
  ABISELECT(-67872,-37792),
  ABISELECT(-68000,-37864),
  ABISELECT(-68384,-38068),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN8S2489C19D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C19D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C108S2489C19__A3__8S2489C22[] = {
  ABISELECT(-67744,-37708),
  ABISELECT(-67872,-37792),
  ABISELECT(-68000,-37864),
  ABISELECT(-68384,-38068),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C108S2489C19__A3__8S2489C22[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(68384,38068),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C108S2489C19__A3__8S2489C22[] = {
  0,
  ABISELECT(67872,37792),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(67872,37792),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C108S2489C19__A3__8S2489C22[] = {
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(67744,37708),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A3__8S2489C22[] = {
  ABISELECT(-68416,-38128),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C19__A1__8S2489C22[] = {
  0,
  ABISELECT(67872,37792),
  ABISELECT(-512,-276),
  ABISELECT(-128,-72),
  ABISELECT(67872,37792),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C19__A1__8S2489C22[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(68384,38068),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C19__A1__8S2489C22[] = {
  0,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(67744,37708),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A__8S2489C19__A1__8S2489C22[] = {
  ABISELECT(-68416,-38128),
  ABISELECT(-416,-264),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
static  VTT_ENTRY vtt_S2489C22[] = {
  {&(_ZTV8S2489C22[11]),  11,147},
  {&(_tg__ZTV7S2489C5__A__8S2489C22[3]),  3,6},
  {&(_tg__ZTV7S2489C67S2489C5__A4__8S2489C22[3]),  3,5},
  {&(_ZTV8S2489C22[37]),  37,147},
  {&(_ZTV8S2489C22[75]),  75,147},
  {&(_ZTV8S2489C22[83]),  83,147},
  {&(_ZTV8S2489C22[91]),  91,147},
  {&(_ZTV8S2489C22[100]),  100,147},
  {&(_ZTV8S2489C22[106]),  106,147},
  {&(_ZTV8S2489C22[47]),  47,147},
  {&(_ZTV8S2489C22[56]),  56,147},
  {&(_ZTV8S2489C22[118]),  118,147},
  {&(_ZTV8S2489C22[65]),  65,147},
  {&(_ZTV8S2489C22[136]),  136,147},
  {&(_ZTV8S2489C22[145]),  145,147},
  {&(_tg__ZTV8S2489C23__8S2489C22[10]),  10,14},
  {&(_tg__ZTV8S2489C178S2489C23__8S2489C22[9]),  9,13},
  {&(_tg__ZTV8S2489C198S2489C178S2489C23__8S2489C22[6]),  6,12},
  {&(_tg__ZTV8S2489C108S2489C198S2489C178S2489C23__A1__8S2489C22[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C108S2489C198S2489C178S2489C23__A1__8S2489C22[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C108S2489C198S2489C178S2489C23__A1__8S2489C22[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C108S2489C198S2489C178S2489C23__A1__8S2489C22[6]),  6,9},
  {&(_tg__ZTV7S2489C68S2489C198S2489C178S2489C23__A2__8S2489C22[3]),  3,5},
  {&(_tg__ZTV7S2489C8__8S2489C198S2489C178S2489C23__8S2489C22[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C198S2489C178S2489C23__8S2489C22[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C198S2489C178S2489C23__8S2489C22[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A__8S2489C198S2489C178S2489C23__8S2489C22[3]),  3,5},
  {&(_tg__ZTV8S2489C218S2489C178S2489C23__8S2489C22[7]),  7,9},
  {&(_tg__ZTV7S2489C6__8S2489C218S2489C178S2489C23__8S2489C22[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C218S2489C178S2489C23__8S2489C22[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C218S2489C178S2489C23__8S2489C22[6]),  6,9},
  {&(_tg__ZTV8S2489C19__8S2489C218S2489C178S2489C23__8S2489C22[13]),  13,19},
  {&(_tg__ZTV7S2489C68S2489C19__A2__8S2489C218S2489C178S2489C23__8S2489C22[3]),  3,5},
  {&(_tg__ZTV8S2489C19__A__8S2489C178S2489C23__8S2489C22[6]),  6,12},
  {&(_tg__ZTV7S2489C8__8S2489C178S2489C23__8S2489C22[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C178S2489C23__8S2489C22[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C178S2489C23__8S2489C22[6]),  6,9},
  {&(_tg__ZTV7S2489C68S2489C19__A2__8S2489C178S2489C23__8S2489C22[3]),  3,5},
  {&(_tg__ZTV8S2489C20__8S2489C178S2489C23__8S2489C22[11]),  11,16},
  {&(_tg__ZTV8S2489C13__8S2489C178S2489C23__8S2489C22[3]),  3,4},
  {&(_tg__ZTV8S2489C21__8S2489C178S2489C23__8S2489C22[7]),  7,9},
  {&(_tg__ZTV8S2489C19__A1__8S2489C178S2489C23__8S2489C22[13]),  13,19},
  {&(_tg__ZTV7S2489C68S2489C19__A3__8S2489C178S2489C23__8S2489C22[3]),  3,5},
  {&(_tg__ZTV8S2489C10__8S2489C23__8S2489C22[8]),  8,11},
  {&(_tg__ZTV7S2489C6__8S2489C23__8S2489C22[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C23__8S2489C22[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C23__8S2489C22[6]),  6,9},
  {&(_tg__ZTV8S2489C13__8S2489C23__8S2489C22[3]),  3,4},
  {&(_tg__ZTV8S2489C198S2489C17__8S2489C23__8S2489C22[6]),  6,12},
  {&(_tg__ZTV7S2489C68S2489C198S2489C17__A2__8S2489C23__8S2489C22[3]),  3,5},
  {&(_tg__ZTV8S2489C20__8S2489C23__8S2489C22[11]),  11,16},
  {&(_tg__ZTV8S2489C218S2489C17__8S2489C23__8S2489C22[7]),  7,9},
  {&(_tg__ZTV8S2489C19__A1__8S2489C23__8S2489C22[13]),  13,19},
  {&(_tg__ZTV7S2489C68S2489C19__A3__8S2489C23__8S2489C22[3]),  3,5},
  {&(_tg__ZTV8S2489C10__8S2489C22[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C10__8S2489C22[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C10__8S2489C22[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C10__8S2489C22[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C22[3]),  3,5},
  {&(_tg__ZTV7S2489C8__8S2489C22[4]),  4,7},
  {&(_tg__ZTV7S2489C6__7S2489C8__8S2489C22[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C22[3]),  3,6},
  {&(_tg__ZTV7S2489C67S2489C5__A1__8S2489C22[3]),  3,5},
  {&(_tg__ZTV8S2489C20__8S2489C22[7]),  7,12},
  {&(_tg__ZTV7S2489C98S2489C20__8S2489C22[6]),  6,11},
  {&(_tg__ZTV8S2489C107S2489C98S2489C20__A2__8S2489C22[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C107S2489C98S2489C20__A2__8S2489C22[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C107S2489C98S2489C20__A2__8S2489C22[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C107S2489C98S2489C20__A2__8S2489C22[6]),  6,9},
  {&(_tg__ZTV7S2489C6__7S2489C98S2489C20__8S2489C22[5]),  5,7},
  {&(_tg__ZTV7S2489C8__7S2489C98S2489C20__8S2489C22[6]),  6,9},
  {&(_tg__ZTV7S2489C5__7S2489C98S2489C20__8S2489C22[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C20__8S2489C22[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A1__8S2489C20__8S2489C22[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C20__8S2489C22[6]),  6,9},
  {&(_tg__ZTV8S2489C13__8S2489C20__8S2489C22[3]),  3,4},
  {&(_tg__ZTV8S2489C19__A1__8S2489C22[6]),  6,12},
  {&(_tg__ZTV8S2489C108S2489C19__A3__8S2489C22[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C108S2489C19__A3__8S2489C22[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C108S2489C19__A3__8S2489C22[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C108S2489C19__A3__8S2489C22[6]),  6,9},
  {&(_tg__ZTV7S2489C68S2489C19__A3__8S2489C22[3]),  3,5},
  {&(_tg__ZTV7S2489C8__8S2489C19__A1__8S2489C22[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C19__A1__8S2489C22[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C19__A1__8S2489C22[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A__8S2489C19__A1__8S2489C22[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S2489C22[];
extern  VTBL_ENTRY _ZTV8S2489C22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C22[];
static VTBL_ENTRY alt_thunk_names11[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C23D0Ev,_ZTv0_n32_N8S2489C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn22784_N8S2489C23D0Ev,_ZThn12672_N8S2489C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C23D1Ev,_ZTv0_n32_N8S2489C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn22784_N8S2489C23D1Ev,_ZThn12672_N8S2489C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C23D0Ev,_ZTv0_n20_N8S2489C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7120_N8S2489C23D0Ev,_ZThn4004_N8S2489C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C23D1Ev,_ZTv0_n20_N8S2489C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7120_N8S2489C23D1Ev,_ZThn4004_N8S2489C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C23D0Ev,_ZTv0_n28_N8S2489C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn74992_N8S2489C23D0Ev,_ZThn41796_N8S2489C23D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn6320_N8S2489C23D0Ev,_ZThn3536_N8S2489C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C23D1Ev,_ZTv0_n28_N8S2489C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn74992_N8S2489C23D1Ev,_ZThn41796_N8S2489C23D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn6320_N8S2489C23D1Ev,_ZThn3536_N8S2489C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C17D0Ev,_ZTv0_n28_N8S2489C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn74992_N8S2489C17D0Ev,_ZThn41796_N8S2489C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C17D1Ev,_ZTv0_n28_N8S2489C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn74992_N8S2489C17D1Ev,_ZThn41796_N8S2489C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C17D0Ev,_ZTv0_n32_N8S2489C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn22784_N8S2489C17D0Ev,_ZThn12672_N8S2489C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C17D1Ev,_ZTv0_n32_N8S2489C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn22784_N8S2489C17D1Ev,_ZThn12672_N8S2489C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C17D0Ev,_ZTv0_n20_N8S2489C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7120_N8S2489C17D0Ev,_ZThn4004_N8S2489C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C17D1Ev,_ZTv0_n20_N8S2489C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7120_N8S2489C17D1Ev,_ZThn4004_N8S2489C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72288_N8S2489C21D0Ev,_ZThn40296_N8S2489C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn72288_N8S2489C21D1Ev,_ZThn40296_N8S2489C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4416_N8S2489C21D0Ev,_ZThn2504_N8S2489C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4416_N8S2489C21D1Ev,_ZThn2504_N8S2489C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7024_N8S2489C19D0Ev,_ZThn3960_N8S2489C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7024_N8S2489C19D1Ev,_ZThn3960_N8S2489C19D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn800_N8S2489C10D0Ev,_ZThn468_N8S2489C10D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn7024_N8S2489C10D0Ev,_ZThn3960_N8S2489C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn800_N8S2489C10D1Ev,_ZThn468_N8S2489C10D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn7024_N8S2489C10D1Ev,_ZThn3960_N8S2489C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C22D0Ev,_ZTv0_n32_N8S2489C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24592_N8S2489C22D0Ev,_ZThn13704_N8S2489C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C22D1Ev,_ZTv0_n32_N8S2489C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn24592_N8S2489C22D1Ev,_ZThn13704_N8S2489C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C22D0Ev,_ZTv0_n20_N8S2489C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8928_N8S2489C22D0Ev,_ZThn5036_N8S2489C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C22D1Ev,_ZTv0_n20_N8S2489C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8928_N8S2489C22D1Ev,_ZThn5036_N8S2489C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C22D0Ev,_ZTv0_n28_N8S2489C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn76800_N8S2489C22D0Ev,_ZThn42828_N8S2489C22D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn8128_N8S2489C22D0Ev,_ZThn4568_N8S2489C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C22D1Ev,_ZTv0_n28_N8S2489C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn76800_N8S2489C22D1Ev,_ZThn42828_N8S2489C22D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn8128_N8S2489C22D1Ev,_ZThn4568_N8S2489C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n88_N8S2489C22D0Ev,_ZTv0_n44_N8S2489C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1808_N8S2489C22D0Ev,_ZThn1032_N8S2489C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n88_N8S2489C22D1Ev,_ZTv0_n44_N8S2489C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1808_N8S2489C22D1Ev,_ZThn1032_N8S2489C22D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S2489C22 = {  "S2489C22", // class name
  bases_S2489C22, 31,
  &(vtc_S2489C22[0]), // expected_vtbl_contents
  &(vtt_S2489C22[0]), // expected_vtt_contents
  ABISELECT(79408,44284), // object size
  NSPAIRA(_ZTI8S2489C22),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S2489C22),147, //virtual function table var
  11, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S2489C22),86, //virtual table table var
  21, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names11,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2489C15  : S2489C14 , S2489C16 , S2489C22 , S2489C21 {
  ::S2489C4 s2489c15f0;
  int s2489c15f1;
  int s2489c15f2;
  __tsi64 s2489c15f3;
  int s2489c15f4;
  void *s2489c15f5;
  int s2489c15f6;
  int s2489c15f7;
  int s2489c15f8;
  virtual  ~S2489C15(); // _ZN8S2489C15D2Ev
  S2489C15(); // tgen
};
//SIG(-1 S2489C15) C1{ BC2{ VBC3{ BC4{ m Fc Fi FL FU5{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} BC6{ VBC4 v1 v2 Fp Fp Fi Fi FU7{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU7 Fp FL:3 FC4 FL FU7} v3 Fp FD FC4[7] FD FU5 Fs FL FL} VBC8{ VBC4 VBC6 vd v4 FL FL FL FL Fi FU7 Fc[10] Fi} Fi Fp Fi FU7} BC9{ VBC10{ BC11{ vd m FU5} BC12{ VBC8 BC13{ BC4 VBC6 VBC8 VBC3 vd v5 Fc Fi[7] Fl[5] FL FL FL FU14{ m Fp Fi Fp Fc Fc FL[5] Fp Fp Fp}} BC4 BC6 vd v6 v7 v8 FU7 Fi Fl Fc Fp FC3 Fs} VBC15{ VBC3 VBC6 VBC8 BC16{ BC13 vd v9 v10 Fp Fp Fp Fi FC17{} FL FL} VBC18{ v11 FD FC2[6] Fc Fp Fp Fi[6] Fi Fp FL Fp Fi Fp Fp} vd Fc Fs[3] FC19{ BC4 VBC6 VBC8 VBC3 VBC12 vd FL Fi Fp Fp FL}[10] FC3 FL FL:5 Fi Fp[6] FL[2] FL Fi} BC19 vd v12 v13 Fi FD Fl Fc:3 Fp FC6} Fc Fp FL Fi Fi Fi Fp FL FC20{ BC4 VBC3 VBC8 BC16 vd FD} FD FL Fi} BC21{ VBC22{ VBC13 VBC18 BC10 vd Fp[6] Fi Fs FC17 FC20 Fp Fi Fi Fc Fc FU5} BC3 v14 v15 FL Fs FL:0 Fp Fp FD[10] Fi Fp Fp Fi Fl Fp} BC19 vd FU5 Fi Fi FL Fi Fp Fi Fi Fi}


 S2489C15 ::~S2489C15(){ note_dtor("S2489C15", this);}
S2489C15 ::S2489C15(){ note_ctor("S2489C15", this);} // tgen

static void Test_S2489C15()
{
  extern Class_Descriptor cd_S2489C15;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(5380,12007)];
    init_test(&cd_S2489C15, buf);
    S2489C15 *dp, &lv = *(dp=new (buf) S2489C15());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(86064,48024), "sizeof(S2489C15)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2489C15)");
    /*is_ambiguous_... S2489C15::S2489C5 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C5*), ABISELECT(5392,3068), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C5 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C5*), ABISELECT(6576,3732), "S2489C15");
    check_base_class_offset(lv, (S2489C3*)(S2489C8*), ABISELECT(6576,3732), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*), ABISELECT(6576,3732), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C19*)(S2489C17*), ABISELECT(6576,3732), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C19*), ABISELECT(6576,3732), "S2489C15");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(6576,3732), "S2489C15");
    /*is_ambiguous_... S2489C22::S2489C5 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C5*)(S2489C22*), ABISELECT(6576,3732), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C5 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C5*), ABISELECT(5008,2864), "S2489C15");
    check_base_class_offset(lv, (S2489C5*)(S2489C14*), ABISELECT(5008,2864), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C5*)(S2489C10*)(S2489C19*)(S2489C17*), ABISELECT(5008,2864), "S2489C15");
    check_base_class_offset(lv, (S2489C5*)(S2489C20*), ABISELECT(5008,2864), "S2489C15");
    check_base_class_offset(lv, (S2489C5*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(5008,2864), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C5*)(S2489C21*)(S2489C17*), ABISELECT(5008,2864), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C5*)(S2489C10*)(S2489C19*), ABISELECT(5008,2864), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C10 */ AMB_check_base_class_offset(lv, (S2489C5*)(S2489C10*), ABISELECT(5008,2864), "S2489C15");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C5*)(S2489C10*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(5008,2864), "S2489C15");
    check_base_class_offset(lv, (S2489C5*)(S2489C21*)(S2489C17*)(S2489C23*), ABISELECT(5008,2864), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C21 */ AMB_check_base_class_offset(lv, (S2489C5*)(S2489C21*), ABISELECT(5008,2864), "S2489C15");
    check_base_class_offset(lv, (S2489C6*)(S2489C8*), ABISELECT(6832,3888), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*)(S2489C19*)(S2489C17*), ABISELECT(6832,3888), "S2489C15");
    /*is_ambiguous_... S2489C20::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C20*), ABISELECT(6832,3888), "S2489C15");
    /*is_ambiguous_... S2489C10::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(6832,3888), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C21*)(S2489C17*), ABISELECT(6832,3888), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*)(S2489C19*), ABISELECT(6832,3888), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C10 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*), ABISELECT(6832,3888), "S2489C15");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(6832,3888), "S2489C15");
    /*is_ambiguous_... S2489C21::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C21*)(S2489C17*)(S2489C23*), ABISELECT(6832,3888), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C21 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C21*), ABISELECT(6832,3888), "S2489C15");
    check_base_class_offset(lv, (S2489C8*)(S2489C14*), ABISELECT(6704,3804), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C19*)(S2489C17*), ABISELECT(6704,3804), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C10*)(S2489C19*)(S2489C17*), ABISELECT(6704,3804), "S2489C15");
    check_base_class_offset(lv, (S2489C8*)(S2489C20*), ABISELECT(6704,3804), "S2489C15");
    check_base_class_offset(lv, (S2489C8*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(6704,3804), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C21*)(S2489C17*), ABISELECT(6704,3804), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C19*), ABISELECT(6704,3804), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C10*)(S2489C19*), ABISELECT(6704,3804), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C10 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C10*), ABISELECT(6704,3804), "S2489C15");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(6704,3804), "S2489C15");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C10*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(6704,3804), "S2489C15");
    check_base_class_offset(lv, (S2489C8*)(S2489C21*)(S2489C17*)(S2489C23*), ABISELECT(6704,3804), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C21 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C21*), ABISELECT(6704,3804), "S2489C15");
    check_base_class_offset(lv, (S2489C14*), 0, "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C18*)(S2489C17*), ABISELECT(7216,4092), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*)(S2489C19*)(S2489C17*), ABISELECT(7328,4140), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C10*)(S2489C19*)(S2489C17*), ABISELECT(7312,4136), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C19*)(S2489C17*), ABISELECT(7600,4328), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C19*)(S2489C17*), ABISELECT(7728,4400), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C19*)(S2489C17*), ABISELECT(7312,4136), "S2489C15");
    /*is_ambiguous_... S2489C10::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(10688,6004), "S2489C15");
    check_base_class_offset(lv, (S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(10672,6000), "S2489C15");
    check_base_class_offset(lv, (S2489C9*)(S2489C20*), ABISELECT(10672,6000), "S2489C15");
    check_base_class_offset(lv, (S2489C13*)(S2489C20*), ABISELECT(62880,35124), "S2489C15");
    check_base_class_offset(lv, (S2489C13*)(S2489C23*), ABISELECT(62880,35124), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C20*)(S2489C17*), ABISELECT(10672,6000), "S2489C15");
    check_base_class_offset(lv, (S2489C20*)(S2489C17*)(S2489C23*), ABISELECT(10672,6000), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C21*)(S2489C17*), ABISELECT(9936,5596), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*)(S2489C19*), ABISELECT(76864,42844), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C10*)(S2489C19*), ABISELECT(76848,42840), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C19*), ABISELECT(77136,43032), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C19*), ABISELECT(77264,43104), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C19*)(S2489C21*)(S2489C17*), ABISELECT(76848,42840), "S2489C15");
    check_base_class_offset(lv, (S2489C19*)(S2489C21*)(S2489C17*)(S2489C23*), ABISELECT(76848,42840), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C21 */ AMB_check_base_class_offset(lv, (S2489C19*)(S2489C21*), ABISELECT(76848,42840), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C21*)(S2489C17*), ABISELECT(9920,5592), "S2489C15");
    check_base_class_offset(lv, (S2489C17*)(S2489C16*), ABISELECT(7216,4092), "S2489C15");
    check_base_class_offset(lv, (S2489C16*), ABISELECT(96,44), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C10 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*), ABISELECT(85792,47836), "S2489C15");
    /*is_ambiguous_... S2489C23::S2489C10 */ AMB_check_base_class_offset(lv, (S2489C10*)(S2489C23*), ABISELECT(85776,47832), "S2489C15");
    check_base_class_offset(lv, (S2489C18*)(S2489C17*)(S2489C23*), ABISELECT(79456,44296), "S2489C15");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(79568,44344), "S2489C15");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C10*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(79552,44340), "S2489C15");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(79840,44532), "S2489C15");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(79968,44604), "S2489C15");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(79552,44340), "S2489C15");
    /*is_ambiguous_... S2489C21::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C21*)(S2489C17*)(S2489C23*), ABISELECT(82176,45800), "S2489C15");
    check_base_class_offset(lv, (S2489C21*)(S2489C17*)(S2489C23*), ABISELECT(82160,45796), "S2489C15");
    check_base_class_offset(lv, (S2489C17*)(S2489C23*), ABISELECT(79456,44296), "S2489C15");
    check_base_class_offset(lv, (S2489C23*)(S2489C22*), ABISELECT(79456,44296), "S2489C15");
    /*is_ambiguous_... S2489C22::S2489C5 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C5*)(S2489C22*), ABISELECT(3264,1856), "S2489C15");
    /*is_ambiguous_... S2489C22::S2489C5 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C5*)(S2489C22*), ABISELECT(2880,1652), "S2489C15");
    /*is_ambiguous_... S2489C22::S2489C5 */ AMB_check_base_class_offset(lv, (S2489C5*)(S2489C22*), ABISELECT(2880,1652), "S2489C15");
    check_base_class_offset(lv, (S2489C22*), ABISELECT(2880,1652), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C21 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C21*), ABISELECT(4704,2688), "S2489C15");
    /*is_ambiguous_... S2489C15::S2489C21 */ AMB_check_base_class_offset(lv, (S2489C21*), ABISELECT(4688,2684), "S2489C15");
    check_field_offset(lv, s2489c15f0, ABISELECT(4880,2788), "S2489C15.s2489c15f0");
    check_field_offset(lv, s2489c15f1, ABISELECT(4960,2828), "S2489C15.s2489c15f1");
    check_field_offset(lv, s2489c15f2, ABISELECT(4964,2832), "S2489C15.s2489c15f2");
    check_field_offset(lv, s2489c15f3, ABISELECT(4968,2836), "S2489C15.s2489c15f3");
    check_field_offset(lv, s2489c15f4, ABISELECT(4976,2844), "S2489C15.s2489c15f4");
    check_field_offset(lv, s2489c15f5, ABISELECT(4984,2848), "S2489C15.s2489c15f5");
    check_field_offset(lv, s2489c15f6, ABISELECT(4992,2852), "S2489C15.s2489c15f6");
    check_field_offset(lv, s2489c15f7, ABISELECT(4996,2856), "S2489C15.s2489c15f7");
    check_field_offset(lv, s2489c15f8, ABISELECT(5000,2860), "S2489C15.s2489c15f8");
    test_class_info(&lv, &cd_S2489C15);
    dp->~S2489C15();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2489C15(Test_S2489C15, "S2489C15", ABISELECT(86064,48024));

#else // __cplusplus

extern void _ZN8S2489C15C1Ev();
extern void _ZN8S2489C15D2Ev();
Name_Map name_map_S2489C15[] = {
  NSPAIR(_ZN8S2489C15C1Ev),
  NSPAIR(_ZN8S2489C15D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C5;
extern VTBL_ENTRY _ZTI7S2489C5[];
extern  VTBL_ENTRY _ZTV7S2489C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C5[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C8;
extern VTBL_ENTRY _ZTI7S2489C8[];
extern  VTBL_ENTRY _ZTV7S2489C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C8[];
extern Class_Descriptor cd_S2489C14;
extern VTBL_ENTRY _ZTI8S2489C14[];
extern  VTBL_ENTRY _ZTV8S2489C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C14[];
extern Class_Descriptor cd_S2489C18;
extern VTBL_ENTRY _ZTI8S2489C18[];
extern  VTBL_ENTRY _ZTV8S2489C18[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C19;
extern VTBL_ENTRY _ZTI8S2489C19[];
extern  VTBL_ENTRY _ZTV8S2489C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C19[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C9;
extern VTBL_ENTRY _ZTI7S2489C9[];
extern  VTBL_ENTRY _ZTV7S2489C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C9[];
extern Class_Descriptor cd_S2489C13;
extern VTBL_ENTRY _ZTI8S2489C13[];
extern  VTBL_ENTRY _ZTV8S2489C13[];
extern Class_Descriptor cd_S2489C20;
extern VTBL_ENTRY _ZTI8S2489C20[];
extern  VTBL_ENTRY _ZTV8S2489C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C20[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C19;
extern VTBL_ENTRY _ZTI8S2489C19[];
extern  VTBL_ENTRY _ZTV8S2489C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C19[];
extern Class_Descriptor cd_S2489C21;
extern VTBL_ENTRY _ZTI8S2489C21[];
extern  VTBL_ENTRY _ZTV8S2489C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C21[];
extern Class_Descriptor cd_S2489C17;
extern VTBL_ENTRY _ZTI8S2489C17[];
extern  VTBL_ENTRY _ZTV8S2489C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C17[];
extern Class_Descriptor cd_S2489C16;
extern VTBL_ENTRY _ZTI8S2489C16[];
extern  VTBL_ENTRY _ZTV8S2489C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C16[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C18;
extern VTBL_ENTRY _ZTI8S2489C18[];
extern  VTBL_ENTRY _ZTV8S2489C18[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C19;
extern VTBL_ENTRY _ZTI8S2489C19[];
extern  VTBL_ENTRY _ZTV8S2489C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C19[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C21;
extern VTBL_ENTRY _ZTI8S2489C21[];
extern  VTBL_ENTRY _ZTV8S2489C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C21[];
extern Class_Descriptor cd_S2489C17;
extern VTBL_ENTRY _ZTI8S2489C17[];
extern  VTBL_ENTRY _ZTV8S2489C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C17[];
extern Class_Descriptor cd_S2489C23;
extern VTBL_ENTRY _ZTI8S2489C23[];
extern  VTBL_ENTRY _ZTV8S2489C23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C23[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C5;
extern VTBL_ENTRY _ZTI7S2489C5[];
extern  VTBL_ENTRY _ZTV7S2489C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C5[];
extern Class_Descriptor cd_S2489C22;
extern VTBL_ENTRY _ZTI8S2489C22[];
extern  VTBL_ENTRY _ZTV8S2489C22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C22[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C21;
extern VTBL_ENTRY _ZTI8S2489C21[];
extern  VTBL_ENTRY _ZTV8S2489C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C21[];
static Base_Class bases_S2489C15[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C3,    ABISELECT(5392,3068), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(6576,3732), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S2489C6,    ABISELECT(5008,2864), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    59, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2489C5,    ABISELECT(5008,2864), //bcp->offset
    53, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    39, //bcp->index_in_construction_vtbl_array
    58, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S2489C6,    ABISELECT(6832,3888), //bcp->offset
    71, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    41, //bcp->index_in_construction_vtbl_array
    62, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S2489C8,    ABISELECT(6704,3804), //bcp->offset
    62, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    40, //bcp->index_in_construction_vtbl_array
    60, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S2489C14,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2489C18,    ABISELECT(7216,4092), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(7328,4140), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S2489C10,    ABISELECT(7312,4136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    65, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(7600,4328), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S2489C6,    ABISELECT(7728,4400), //bcp->offset
    112, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    45, //bcp->index_in_construction_vtbl_array
    69, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    12, //immediately_derived
  0, 0},
  {&cd_S2489C19,    ABISELECT(7312,4136), //bcp->offset
    100, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    44, //bcp->index_in_construction_vtbl_array
    64, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(10688,6004), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S2489C10,    ABISELECT(10672,6000), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    92, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S2489C9,    ABISELECT(10672,6000), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    91, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    17, //immediately_derived
  0, 0},
  {&cd_S2489C13,    ABISELECT(62880,35124), //bcp->offset
    142, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    47, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    17, //immediately_derived
  0, 1},
  {&cd_S2489C20,    ABISELECT(10672,6000), //bcp->offset
    126, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    46, //bcp->index_in_construction_vtbl_array
    90, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    25, //immediately_derived
  0, 1},
  {&cd_S2489C3,    ABISELECT(9936,5596), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    24, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(76864,42844), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S2489C10,    ABISELECT(76848,42840), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    104, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(77136,43032), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S2489C6,    ABISELECT(77264,43104), //bcp->offset
    165, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    50, //bcp->index_in_construction_vtbl_array
    108, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S2489C19,    ABISELECT(76848,42840), //bcp->offset
    146, //bcp->virtual_function_table_offset
    13, //num_negative_vtable_entries(t, bcp)
    49, //bcp->index_in_construction_vtbl_array
    103, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    24, //immediately_derived
  0, 1},
  {&cd_S2489C21,    ABISELECT(9920,5592), //bcp->offset
    117, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    48, //bcp->index_in_construction_vtbl_array
    74, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S2489C17,    ABISELECT(7216,4092), //bcp->offset
    78, //bcp->virtual_function_table_offset
    18, //num_negative_vtable_entries(t, bcp)
    43, //bcp->index_in_construction_vtbl_array
    63, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    26, //immediately_derived
  0, 1},
  {&cd_S2489C16,    ABISELECT(96,44), //bcp->offset
    14, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    42, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2489C3,    ABISELECT(85792,47836), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S2489C10,    ABISELECT(85776,47832), //bcp->offset
    219, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    53, //bcp->index_in_construction_vtbl_array
    152, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    38, //immediately_derived
  0, 1},
  {&cd_S2489C18,    ABISELECT(79456,44296), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(79568,44344), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    31, //immediately_derived
  0, 0},
  {&cd_S2489C10,    ABISELECT(79552,44340), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    116, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(79840,44532), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S2489C6,    ABISELECT(79968,44604), //bcp->offset
    205, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    55, //bcp->index_in_construction_vtbl_array
    120, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    34, //immediately_derived
  0, 0},
  {&cd_S2489C19,    ABISELECT(79552,44340), //bcp->offset
    193, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    54, //bcp->index_in_construction_vtbl_array
    115, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(82176,45800), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    36, //immediately_derived
  0, 0},
  {&cd_S2489C21,    ABISELECT(82160,45796), //bcp->offset
    210, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    56, //bcp->index_in_construction_vtbl_array
    125, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    37, //immediately_derived
  0, 0},
  {&cd_S2489C17,    ABISELECT(79456,44296), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    114, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    38, //immediately_derived
  0, 0},
  {&cd_S2489C23,    ABISELECT(79456,44296), //bcp->offset
    170, //bcp->virtual_function_table_offset
    19, //num_negative_vtable_entries(t, bcp)
    52, //bcp->index_in_construction_vtbl_array
    113, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    42, //immediately_derived
  0, 1},
  {&cd_S2489C3,    ABISELECT(3264,1856), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S2489C6,    ABISELECT(2880,1652), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    20, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S2489C5,    ABISELECT(2880,1652), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    19, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    42, //immediately_derived
  0, 0},
  {&cd_S2489C22,    ABISELECT(2880,1652), //bcp->offset
    26, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    51, //bcp->index_in_construction_vtbl_array
    18, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2489C3,    ABISELECT(4704,2688), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    44, //immediately_derived
  0, 0},
  {&cd_S2489C21,    ABISELECT(4688,2684), //bcp->offset
    44, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    57, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S2489C15[];
extern void _ZN8S2489C15D1Ev();
extern void _ZN8S2489C15D0Ev();
extern void ABISELECT(_ZThn96_N8S2489C15D1Ev,_ZThn44_N8S2489C15D1Ev)();
extern void ABISELECT(_ZThn96_N8S2489C15D0Ev,_ZThn44_N8S2489C15D0Ev)();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
extern void _ZN8S2489C223v14Ev();
extern void _ZN8S2489C223v15Ev();
extern void ABISELECT(_ZThn2880_N8S2489C15D1Ev,_ZThn1652_N8S2489C15D1Ev)();
extern void ABISELECT(_ZThn2880_N8S2489C15D0Ev,_ZThn1652_N8S2489C15D0Ev)();
extern void ABISELECT(_ZThn4688_N8S2489C15D1Ev,_ZThn2684_N8S2489C15D1Ev)();
extern void ABISELECT(_ZThn4688_N8S2489C15D0Ev,_ZThn2684_N8S2489C15D0Ev)();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S2489C15D1Ev,_ZTv0_n20_N8S2489C15D1Ev)();
extern void ABISELECT(_ZThn6704_N8S2489C15D1Ev,_ZThn3804_N8S2489C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C15D0Ev,_ZTv0_n20_N8S2489C15D0Ev)();
extern void ABISELECT(_ZThn6704_N8S2489C15D0Ev,_ZThn3804_N8S2489C15D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void ABISELECT(_ZTv0_n80_N8S2489C15D1Ev,_ZTv0_n40_N8S2489C15D1Ev)();
extern void ABISELECT(_ZThn7216_N8S2489C15D1Ev,_ZThn4092_N8S2489C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N8S2489C15D0Ev,_ZTv0_n40_N8S2489C15D0Ev)();
extern void ABISELECT(_ZThn7216_N8S2489C15D0Ev,_ZThn4092_N8S2489C15D0Ev)() __attribute__((weak));
extern void _ZN8S2489C173v12Ev();
extern void _ZN8S2489C173v13Ev();
extern void ABISELECT(_ZTvn96_n80_N8S2489C15D1Ev,_ZTvn44_n40_N8S2489C15D1Ev)();
extern void ABISELECT(_ZTvn96_n80_N8S2489C15D0Ev,_ZTvn44_n40_N8S2489C15D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void ABISELECT(_ZTvn2704_n80_N8S2489C15D1Ev,_ZTvn1500_n40_N8S2489C15D1Ev)();
extern void ABISELECT(_ZTvn2704_n80_N8S2489C15D0Ev,_ZTvn1500_n40_N8S2489C15D0Ev)();
extern void ABISELECT(_ZTv0_n64_N8S2489C15D1Ev,_ZTv0_n32_N8S2489C15D1Ev)();
extern void ABISELECT(_ZThn10672_N8S2489C15D1Ev,_ZThn6000_N8S2489C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S2489C15D0Ev,_ZTv0_n32_N8S2489C15D0Ev)();
extern void ABISELECT(_ZThn10672_N8S2489C15D0Ev,_ZThn6000_N8S2489C15D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
extern void _ZN8S2489C133v11Ev();
extern void ABISELECT(_ZTv0_n56_N8S2489C15D1Ev,_ZTv0_n28_N8S2489C15D1Ev)();
extern void ABISELECT(_ZThn76848_N8S2489C15D1Ev,_ZThn42840_N8S2489C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C15D0Ev,_ZTv0_n28_N8S2489C15D0Ev)();
extern void ABISELECT(_ZThn76848_N8S2489C15D0Ev,_ZThn42840_N8S2489C15D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void ABISELECT(_ZTv0_n88_N8S2489C15D1Ev,_ZTv0_n44_N8S2489C15D1Ev)();
extern void ABISELECT(_ZThn79456_N8S2489C15D1Ev,_ZThn44296_N8S2489C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n88_N8S2489C15D0Ev,_ZTv0_n44_N8S2489C15D0Ev)();
extern void ABISELECT(_ZThn79456_N8S2489C15D0Ev,_ZThn44296_N8S2489C15D0Ev)() __attribute__((weak));
extern void _ZN8S2489C173v12Ev();
extern void _ZN8S2489C173v13Ev();
extern void ABISELECT(_ZTvn96_n88_N8S2489C15D1Ev,_ZTvn44_n44_N8S2489C15D1Ev)();
extern void ABISELECT(_ZTvn96_n88_N8S2489C15D0Ev,_ZTvn44_n44_N8S2489C15D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void ABISELECT(_ZTvn2704_n88_N8S2489C15D1Ev,_ZTvn1500_n44_N8S2489C15D1Ev)();
extern void ABISELECT(_ZTvn2704_n88_N8S2489C15D0Ev,_ZTvn1500_n44_N8S2489C15D0Ev)();
extern void ABISELECT(_ZTv0_n56_N8S2489C15D1Ev,_ZTv0_n28_N8S2489C15D1Ev)();
extern void ABISELECT(_ZThn85776_N8S2489C15D1Ev,_ZThn47832_N8S2489C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C15D0Ev,_ZTv0_n28_N8S2489C15D0Ev)();
extern void ABISELECT(_ZThn85776_N8S2489C15D0Ev,_ZThn47832_N8S2489C15D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY vtc_S2489C15[] = {
  ABISELECT(85776,47832),
  ABISELECT(79456,44296),
  ABISELECT(76848,42840),
  ABISELECT(62880,35124),
  ABISELECT(10672,6000),
  ABISELECT(7216,4092),
  ABISELECT(6832,3888),
  ABISELECT(6704,3804),
  ABISELECT(6576,3732),
  ABISELECT(5008,2864),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&_ZN8S2489C15D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C15D0Ev,
  ABISELECT(76752,42796),
  ABISELECT(62784,35080),
  ABISELECT(10576,5956),
  ABISELECT(4912,2820),
  ABISELECT(6736,3844),
  ABISELECT(6480,3688),
  ABISELECT(6608,3760),
  ABISELECT(7120,4048),
  ABISELECT(-96,-44),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C15D1Ev,_ZThn44_N8S2489C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C15D0Ev,_ZThn44_N8S2489C15D0Ev),
  ABISELECT(73968,41188),
  ABISELECT(7792,4348),
  ABISELECT(60000,33472),
  ABISELECT(2128,1212),
  ABISELECT(3824,2152),
  ABISELECT(3952,2236),
  ABISELECT(82896,46180),
  ABISELECT(76576,42644),
  ABISELECT(3696,2080),
  ABISELECT(-2880,-1652),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
  (VTBL_ENTRY)&_ZN8S2489C223v14Ev,
  (VTBL_ENTRY)&_ZN8S2489C223v15Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn2880_N8S2489C15D1Ev,_ZThn1652_N8S2489C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2880_N8S2489C15D0Ev,_ZThn1652_N8S2489C15D0Ev),
  ABISELECT(72160,40156),
  ABISELECT(320,180),
  ABISELECT(2016,1120),
  ABISELECT(1888,1048),
  ABISELECT(2144,1204),
  ABISELECT(-4688,-2684),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn4688_N8S2489C15D1Ev,_ZThn2684_N8S2489C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn4688_N8S2489C15D0Ev,_ZThn2684_N8S2489C15D0Ev),
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(-5008,-2864),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
  0,
  ABISELECT(-6704,-3804),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(-6704,-3804),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C15D1Ev,_ZTv0_n20_N8S2489C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C15D0Ev,_ZTv0_n20_N8S2489C15D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-6832,-3888),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  ABISELECT(512,308),
  ABISELECT(512,308),
  ABISELECT(96,44),
  ABISELECT(96,44),
  ABISELECT(96,44),
  ABISELECT(96,44),
  0,
  0,
  ABISELECT(-7216,-4092),
  ABISELECT(69632,38748),
  ABISELECT(55664,31032),
  ABISELECT(3456,1908),
  ABISELECT(-2208,-1228),
  ABISELECT(-384,-204),
  ABISELECT(-640,-360),
  ABISELECT(-512,-288),
  ABISELECT(-7216,-4092),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S2489C15D1Ev,_ZTv0_n40_N8S2489C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S2489C15D0Ev,_ZTv0_n40_N8S2489C15D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C173v12Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v13Ev,
  ABISELECT(-2304,-1272),
  ABISELECT(-608,-332),
  ABISELECT(-736,-404),
  ABISELECT(-480,-248),
  ABISELECT(-7312,-4136),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n80_N8S2489C15D1Ev,_ZTvn44_n40_N8S2489C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n80_N8S2489C15D0Ev,_ZTvn44_n40_N8S2489C15D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
  ABISELECT(-1152,-668),
  ABISELECT(-7728,-4400),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  ABISELECT(66928,37248),
  ABISELECT(-4912,-2728),
  ABISELECT(-3216,-1788),
  ABISELECT(-3344,-1860),
  ABISELECT(-3088,-1704),
  ABISELECT(-9920,-5592),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2704_n80_N8S2489C15D1Ev,_ZTvn1500_n40_N8S2489C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2704_n80_N8S2489C15D0Ev,_ZTvn1500_n40_N8S2489C15D0Ev),
  0,
  0,
  0,
  ABISELECT(-10672,-6000),
  ABISELECT(52208,29124),
  ABISELECT(-5664,-3136),
  ABISELECT(-3968,-2196),
  ABISELECT(-4096,-2268),
  ABISELECT(-3840,-2112),
  ABISELECT(-10672,-6000),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C15D1Ev,_ZTv0_n32_N8S2489C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C15D0Ev,_ZTv0_n32_N8S2489C15D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
  0,
  ABISELECT(-62880,-35124),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(-76848,-42840),
  ABISELECT(-71840,-39976),
  ABISELECT(-70144,-39036),
  ABISELECT(-70272,-39108),
  ABISELECT(-70016,-38952),
  ABISELECT(-76848,-42840),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C15D1Ev,_ZTv0_n28_N8S2489C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C15D0Ev,_ZTv0_n28_N8S2489C15D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
  ABISELECT(-70688,-39372),
  ABISELECT(-77264,-43104),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  ABISELECT(512,308),
  ABISELECT(512,308),
  ABISELECT(96,44),
  ABISELECT(96,44),
  ABISELECT(96,44),
  ABISELECT(96,44),
  0,
  0,
  ABISELECT(-79456,-44296),
  ABISELECT(6320,3536),
  ABISELECT(-2608,-1456),
  ABISELECT(-16576,-9172),
  ABISELECT(-68784,-38296),
  ABISELECT(-74448,-41432),
  ABISELECT(-72624,-40408),
  ABISELECT(-72880,-40564),
  ABISELECT(-72752,-40492),
  ABISELECT(-79456,-44296),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n88_N8S2489C15D1Ev,_ZTv0_n44_N8S2489C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n88_N8S2489C15D0Ev,_ZTv0_n44_N8S2489C15D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C173v12Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v13Ev,
  ABISELECT(-74544,-41476),
  ABISELECT(-72848,-40536),
  ABISELECT(-72976,-40608),
  ABISELECT(-72720,-40452),
  ABISELECT(-79552,-44340),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n88_N8S2489C15D1Ev,_ZTvn44_n44_N8S2489C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n88_N8S2489C15D0Ev,_ZTvn44_n44_N8S2489C15D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
  ABISELECT(-73392,-40872),
  ABISELECT(-79968,-44604),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  ABISELECT(-5312,-2956),
  ABISELECT(-77152,-42932),
  ABISELECT(-75456,-41992),
  ABISELECT(-75584,-42064),
  ABISELECT(-75328,-41908),
  ABISELECT(-82160,-45796),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2704_n88_N8S2489C15D1Ev,_ZTvn1500_n44_N8S2489C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2704_n88_N8S2489C15D0Ev,_ZTvn1500_n44_N8S2489C15D0Ev),
  0,
  ABISELECT(-85776,-47832),
  ABISELECT(-80768,-44968),
  ABISELECT(-79072,-44028),
  ABISELECT(-79200,-44100),
  ABISELECT(-78944,-43944),
  ABISELECT(-85776,-47832),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C15D1Ev,_ZTv0_n28_N8S2489C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C15D0Ev,_ZTv0_n28_N8S2489C15D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern VTBL_ENTRY _ZTV8S2489C15[];
extern void _ZN8S2489C14D1Ev();
extern void _ZN8S2489C14D0Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C14__8S2489C15[] = {
  ABISELECT(6832,3888),
  ABISELECT(6704,3804),
  ABISELECT(6576,3732),
  ABISELECT(5008,2864),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C14[0]),
  (VTBL_ENTRY)&_ZN8S2489C14D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C14D0Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C14__8S2489C15[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(-5008,-2864),
  (VTBL_ENTRY)&(_ZTI8S2489C14[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C14D1Ev,_ZTv0_n20_N8S2489C14D1Ev)();
extern void ABISELECT(_ZThn6704_N8S2489C14D1Ev,_ZThn3804_N8S2489C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C14D0Ev,_ZTv0_n20_N8S2489C14D0Ev)();
extern void ABISELECT(_ZThn6704_N8S2489C14D0Ev,_ZThn3804_N8S2489C14D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C14__8S2489C15[] = {
  0,
  ABISELECT(-6704,-3804),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(-6704,-3804),
  (VTBL_ENTRY)&(_ZTI8S2489C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C14D1Ev,_ZTv0_n20_N8S2489C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C14D0Ev,_ZTv0_n20_N8S2489C14D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A1__8S2489C14__8S2489C15[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-6832,-3888),
  (VTBL_ENTRY)&(_ZTI8S2489C14[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C16D1Ev();
extern void _ZN8S2489C16D0Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C16__8S2489C15[] = {
  ABISELECT(76752,42796),
  ABISELECT(62784,35080),
  ABISELECT(10576,5956),
  ABISELECT(4912,2820),
  ABISELECT(6736,3844),
  ABISELECT(6480,3688),
  ABISELECT(6608,3760),
  ABISELECT(7120,4048),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&_ZN8S2489C16D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C16D0Ev,
};
extern void ABISELECT(_ZTv0_n80_N8S2489C16D1Ev,_ZTv0_n40_N8S2489C16D1Ev)();
extern void ABISELECT(_ZThn7120_N8S2489C16D1Ev,_ZThn4048_N8S2489C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N8S2489C16D0Ev,_ZTv0_n40_N8S2489C16D0Ev)();
extern void ABISELECT(_ZThn7120_N8S2489C16D0Ev,_ZThn4048_N8S2489C16D0Ev)() __attribute__((weak));
extern void _ZN8S2489C173v12Ev();
extern void _ZN8S2489C173v13Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C17__8S2489C16__8S2489C15[] = {
  ABISELECT(512,308),
  ABISELECT(512,308),
  ABISELECT(96,44),
  ABISELECT(96,44),
  ABISELECT(96,44),
  ABISELECT(96,44),
  0,
  0,
  ABISELECT(-7120,-4048),
  ABISELECT(69632,38748),
  ABISELECT(55664,31032),
  ABISELECT(3456,1908),
  ABISELECT(-2208,-1228),
  ABISELECT(-384,-204),
  ABISELECT(-640,-360),
  ABISELECT(-512,-288),
  ABISELECT(-7120,-4048),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S2489C16D1Ev,_ZTv0_n40_N8S2489C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S2489C16D0Ev,_ZTv0_n40_N8S2489C16D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C173v12Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v13Ev,
};
extern void ABISELECT(_ZTvn96_n80_N8S2489C16D1Ev,_ZTvn44_n40_N8S2489C16D1Ev)();
extern void ABISELECT(_ZTvn96_n80_N8S2489C16D0Ev,_ZTvn44_n40_N8S2489C16D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C198S2489C17__8S2489C16__8S2489C15[] = {
  ABISELECT(-2304,-1272),
  ABISELECT(-608,-332),
  ABISELECT(-736,-404),
  ABISELECT(-480,-248),
  ABISELECT(-7216,-4092),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n80_N8S2489C16D1Ev,_ZTvn44_n40_N8S2489C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n80_N8S2489C16D0Ev,_ZTvn44_n40_N8S2489C16D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C16D1Ev,_ZTv0_n20_N8S2489C16D1Ev)();
extern void ABISELECT(_ZThn6608_N8S2489C16D1Ev,_ZThn3760_N8S2489C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C16D0Ev,_ZTv0_n20_N8S2489C16D0Ev)();
extern void ABISELECT(_ZThn6608_N8S2489C16D0Ev,_ZThn3760_N8S2489C16D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C16__8S2489C15[] = {
  0,
  ABISELECT(-6608,-3760),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(-6608,-3760),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C16D1Ev,_ZTv0_n20_N8S2489C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C16D0Ev,_ZTv0_n20_N8S2489C16D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C16__8S2489C15[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-6736,-3844),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C16__8S2489C15[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(-4912,-2820),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C198S2489C17__A2__8S2489C16__8S2489C15[] = {
  ABISELECT(-1152,-668),
  ABISELECT(-7632,-4356),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n64_N8S2489C16D1Ev,_ZTv0_n32_N8S2489C16D1Ev)();
extern void ABISELECT(_ZThn10576_N8S2489C16D1Ev,_ZThn5956_N8S2489C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S2489C16D0Ev,_ZTv0_n32_N8S2489C16D0Ev)();
extern void ABISELECT(_ZThn10576_N8S2489C16D0Ev,_ZThn5956_N8S2489C16D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C20__8S2489C16__8S2489C15[] = {
  0,
  0,
  0,
  ABISELECT(-10576,-5956),
  ABISELECT(52208,29124),
  ABISELECT(-5664,-3136),
  ABISELECT(-3968,-2196),
  ABISELECT(-4096,-2268),
  ABISELECT(-3840,-2112),
  ABISELECT(-10576,-5956),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C16D1Ev,_ZTv0_n32_N8S2489C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C16D0Ev,_ZTv0_n32_N8S2489C16D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN8S2489C133v11Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C13__8S2489C16__8S2489C15[] = {
  0,
  ABISELECT(-62784,-35080),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
};
extern void ABISELECT(_ZTvn2704_n80_N8S2489C16D1Ev,_ZTvn1500_n40_N8S2489C16D1Ev)();
extern void ABISELECT(_ZTvn2704_n80_N8S2489C16D0Ev,_ZTvn1500_n40_N8S2489C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S2489C218S2489C17__8S2489C16__8S2489C15[] = {
  ABISELECT(66928,37248),
  ABISELECT(-4912,-2728),
  ABISELECT(-3216,-1788),
  ABISELECT(-3344,-1860),
  ABISELECT(-3088,-1704),
  ABISELECT(-9824,-5548),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2704_n80_N8S2489C16D1Ev,_ZTvn1500_n40_N8S2489C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2704_n80_N8S2489C16D0Ev,_ZTvn1500_n40_N8S2489C16D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N8S2489C16D1Ev,_ZTv0_n28_N8S2489C16D1Ev)();
extern void ABISELECT(_ZThn76752_N8S2489C16D1Ev,_ZThn42796_N8S2489C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C16D0Ev,_ZTv0_n28_N8S2489C16D0Ev)();
extern void ABISELECT(_ZThn76752_N8S2489C16D0Ev,_ZThn42796_N8S2489C16D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A1__8S2489C16__8S2489C15[] = {
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(-76752,-42796),
  ABISELECT(-71840,-39976),
  ABISELECT(-70144,-39036),
  ABISELECT(-70272,-39108),
  ABISELECT(-70016,-38952),
  ABISELECT(-76752,-42796),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C16D1Ev,_ZTv0_n28_N8S2489C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C16D0Ev,_ZTv0_n28_N8S2489C16D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A3__8S2489C16__8S2489C15[] = {
  ABISELECT(-70688,-39372),
  ABISELECT(-77168,-43060),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
extern void _ZN8S2489C223v14Ev();
extern void _ZN8S2489C223v15Ev();
extern void _ZN8S2489C22D1Ev();
extern void _ZN8S2489C22D0Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C22__8S2489C15[] = {
  ABISELECT(73968,41188),
  ABISELECT(7792,4348),
  ABISELECT(60000,33472),
  ABISELECT(2128,1212),
  ABISELECT(3824,2152),
  ABISELECT(3952,2236),
  ABISELECT(82896,46180),
  ABISELECT(76576,42644),
  ABISELECT(3696,2080),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
  (VTBL_ENTRY)&_ZN8S2489C223v14Ev,
  (VTBL_ENTRY)&_ZN8S2489C223v15Ev,
  (VTBL_ENTRY)&_ZN8S2489C22D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C22D0Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C58S2489C22__A1__8S2489C15[] = {
  ABISELECT(3696,2080),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C5[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C67S2489C58S2489C22__A5__8S2489C15[] = {
  ABISELECT(3696,2080),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n88_N8S2489C22D1Ev,_ZTv0_n44_N8S2489C22D1Ev)();
extern void ABISELECT(_ZThn76576_N8S2489C22D1Ev,_ZThn42644_N8S2489C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n88_N8S2489C22D0Ev,_ZTv0_n44_N8S2489C22D0Ev)();
extern void ABISELECT(_ZThn76576_N8S2489C22D0Ev,_ZThn42644_N8S2489C22D0Ev)() __attribute__((weak));
extern void _ZN8S2489C173v12Ev();
extern void _ZN8S2489C173v13Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C23__8S2489C22__8S2489C15[] = {
  ABISELECT(512,308),
  ABISELECT(512,308),
  ABISELECT(96,44),
  ABISELECT(96,44),
  ABISELECT(96,44),
  ABISELECT(96,44),
  0,
  0,
  ABISELECT(-76576,-42644),
  ABISELECT(6320,3536),
  ABISELECT(-2608,-1456),
  ABISELECT(-16576,-9172),
  ABISELECT(-68784,-38296),
  ABISELECT(-74448,-41432),
  ABISELECT(-72624,-40408),
  ABISELECT(-72880,-40564),
  ABISELECT(-72752,-40492),
  ABISELECT(-76576,-42644),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n88_N8S2489C22D1Ev,_ZTv0_n44_N8S2489C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n88_N8S2489C22D0Ev,_ZTv0_n44_N8S2489C22D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C173v12Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v13Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S2489C22D1Ev,_ZTv0_n28_N8S2489C22D1Ev)();
extern void ABISELECT(_ZThn82896_N8S2489C22D1Ev,_ZThn46180_N8S2489C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C22D0Ev,_ZTv0_n28_N8S2489C22D0Ev)();
extern void ABISELECT(_ZThn82896_N8S2489C22D0Ev,_ZThn46180_N8S2489C22D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C10__8S2489C22__8S2489C15[] = {
  0,
  ABISELECT(-82896,-46180),
  ABISELECT(-80768,-44968),
  ABISELECT(-79072,-44028),
  ABISELECT(-79200,-44100),
  ABISELECT(-78944,-43944),
  ABISELECT(-82896,-46180),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C22D1Ev,_ZTv0_n28_N8S2489C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C22D0Ev,_ZTv0_n28_N8S2489C22D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C22__8S2489C15[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-3952,-2236),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C22D1Ev,_ZTv0_n20_N8S2489C22D1Ev)();
extern void ABISELECT(_ZThn3824_N8S2489C22D1Ev,_ZThn2152_N8S2489C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C22D0Ev,_ZTv0_n20_N8S2489C22D0Ev)();
extern void ABISELECT(_ZThn3824_N8S2489C22D0Ev,_ZThn2152_N8S2489C22D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C22__8S2489C15[] = {
  0,
  ABISELECT(-3824,-2152),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(-3824,-2152),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C22D1Ev,_ZTv0_n20_N8S2489C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C22D0Ev,_ZTv0_n20_N8S2489C22D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C22__8S2489C15[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(-2128,-1212),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN8S2489C133v11Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C13__8S2489C22__8S2489C15[] = {
  0,
  ABISELECT(-60000,-33472),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
};
extern void ABISELECT(_ZTvn96_n88_N8S2489C22D1Ev,_ZTvn44_n44_N8S2489C22D1Ev)();
extern void ABISELECT(_ZTvn96_n88_N8S2489C22D0Ev,_ZTvn44_n44_N8S2489C22D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C198S2489C178S2489C23__8S2489C22__8S2489C15[] = {
  ABISELECT(-74544,-41476),
  ABISELECT(-72848,-40536),
  ABISELECT(-72976,-40608),
  ABISELECT(-72720,-40452),
  ABISELECT(-76672,-42688),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n88_N8S2489C22D1Ev,_ZTvn44_n44_N8S2489C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n88_N8S2489C22D0Ev,_ZTvn44_n44_N8S2489C22D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C198S2489C178S2489C23__A2__8S2489C22__8S2489C15[] = {
  ABISELECT(-73392,-40872),
  ABISELECT(-77088,-42952),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n64_N8S2489C22D1Ev,_ZTv0_n32_N8S2489C22D1Ev)();
extern void ABISELECT(_ZThn7792_N8S2489C22D1Ev,_ZThn4348_N8S2489C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S2489C22D0Ev,_ZTv0_n32_N8S2489C22D0Ev)();
extern void ABISELECT(_ZThn7792_N8S2489C22D0Ev,_ZThn4348_N8S2489C22D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C20__8S2489C22__8S2489C15[] = {
  0,
  0,
  0,
  ABISELECT(-7792,-4348),
  ABISELECT(52208,29124),
  ABISELECT(-5664,-3136),
  ABISELECT(-3968,-2196),
  ABISELECT(-4096,-2268),
  ABISELECT(-3840,-2112),
  ABISELECT(-7792,-4348),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C22D1Ev,_ZTv0_n32_N8S2489C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C22D0Ev,_ZTv0_n32_N8S2489C22D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void ABISELECT(_ZTvn2704_n88_N8S2489C22D1Ev,_ZTvn1500_n44_N8S2489C22D1Ev)();
extern void ABISELECT(_ZTvn2704_n88_N8S2489C22D0Ev,_ZTvn1500_n44_N8S2489C22D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S2489C218S2489C178S2489C23__8S2489C22__8S2489C15[] = {
  ABISELECT(-5312,-2956),
  ABISELECT(-77152,-42932),
  ABISELECT(-75456,-41992),
  ABISELECT(-75584,-42064),
  ABISELECT(-75328,-41908),
  ABISELECT(-79280,-44144),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2704_n88_N8S2489C22D1Ev,_ZTvn1500_n44_N8S2489C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2704_n88_N8S2489C22D0Ev,_ZTvn1500_n44_N8S2489C22D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N8S2489C22D1Ev,_ZTv0_n28_N8S2489C22D1Ev)();
extern void ABISELECT(_ZThn73968_N8S2489C22D1Ev,_ZThn41188_N8S2489C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C22D0Ev,_ZTv0_n28_N8S2489C22D0Ev)();
extern void ABISELECT(_ZThn73968_N8S2489C22D0Ev,_ZThn41188_N8S2489C22D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A1__8S2489C22__8S2489C15[] = {
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(-73968,-41188),
  ABISELECT(-71840,-39976),
  ABISELECT(-70144,-39036),
  ABISELECT(-70272,-39108),
  ABISELECT(-70016,-38952),
  ABISELECT(-73968,-41188),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C22D1Ev,_ZTv0_n28_N8S2489C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C22D0Ev,_ZTv0_n28_N8S2489C22D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A3__8S2489C22__8S2489C15[] = {
  ABISELECT(-70688,-39372),
  ABISELECT(-74384,-41452),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C21D1Ev();
extern void _ZN8S2489C21D0Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C21__A2__8S2489C15[] = {
  ABISELECT(72160,40156),
  ABISELECT(320,180),
  ABISELECT(2016,1120),
  ABISELECT(1888,1048),
  ABISELECT(2144,1204),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN8S2489C21D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C21D0Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C21__A2__8S2489C15[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-2144,-1204),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev)();
extern void ABISELECT(_ZThn2016_N8S2489C21D1Ev,_ZThn1120_N8S2489C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev)();
extern void ABISELECT(_ZThn2016_N8S2489C21D0Ev,_ZThn1120_N8S2489C21D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C21__A2__8S2489C15[] = {
  0,
  ABISELECT(-2016,-1120),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(-2016,-1120),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C21__A2__8S2489C15[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(-320,-180),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev)();
extern void ABISELECT(_ZThn72160_N8S2489C21D1Ev,_ZThn40156_N8S2489C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev)();
extern void ABISELECT(_ZThn72160_N8S2489C21D0Ev,_ZThn40156_N8S2489C21D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__8S2489C21__A2__8S2489C15[] = {
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(-72160,-40156),
  ABISELECT(-71840,-39976),
  ABISELECT(-70144,-39036),
  ABISELECT(-70272,-39108),
  ABISELECT(-70016,-38952),
  ABISELECT(-72160,-40156),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A2__8S2489C21__A2__8S2489C15[] = {
  ABISELECT(-70688,-39372),
  ABISELECT(-72576,-40420),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C15[] = {
  ABISELECT(1568,868),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C5[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C67S2489C5__8S2489C15[] = {
  ABISELECT(1568,868),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C8D1Ev();
extern void _ZN7S2489C8D0Ev();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C15[] = {
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C8__8S2489C15[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-128,-84),
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A1__8S2489C15[] = {
  ABISELECT(-256,-156),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C17D1Ev();
extern void _ZN8S2489C17D0Ev();
extern void _ZN8S2489C173v12Ev();
extern void _ZN8S2489C173v13Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C17__8S2489C15[] = {
  ABISELECT(69632,38748),
  ABISELECT(55664,31032),
  ABISELECT(3456,1908),
  ABISELECT(-2208,-1228),
  ABISELECT(-384,-204),
  ABISELECT(-640,-360),
  ABISELECT(-512,-288),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN8S2489C17D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C17D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v12Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v13Ev,
};
extern void _ZN8S2489C19D1Ev();
extern void _ZN8S2489C19D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C198S2489C17__8S2489C15[] = {
  ABISELECT(-2304,-1272),
  ABISELECT(-608,-332),
  ABISELECT(-736,-404),
  ABISELECT(-480,-248),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN8S2489C19D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C19D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C108S2489C198S2489C17__8S2489C15[] = {
  ABISELECT(-2304,-1272),
  ABISELECT(-608,-332),
  ABISELECT(-736,-404),
  ABISELECT(-480,-248),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C108S2489C198S2489C17__8S2489C15[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(480,248),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C108S2489C198S2489C17__8S2489C15[] = {
  0,
  ABISELECT(608,332),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(608,332),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C108S2489C198S2489C17__8S2489C15[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(2304,1272),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C198S2489C17__A2__8S2489C15[] = {
  ABISELECT(-1152,-668),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C198S2489C17__8S2489C15[] = {
  0,
  ABISELECT(608,332),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(608,332),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C198S2489C17__8S2489C15[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(480,248),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C198S2489C17__8S2489C15[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(2304,1272),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A__8S2489C198S2489C17__8S2489C15[] = {
  ABISELECT(-1152,-668),
  ABISELECT(-416,-264),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C21D1Ev();
extern void _ZN8S2489C21D0Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C218S2489C17__8S2489C15[] = {
  ABISELECT(66928,37248),
  ABISELECT(-4912,-2728),
  ABISELECT(-3216,-1788),
  ABISELECT(-3344,-1860),
  ABISELECT(-3088,-1704),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN8S2489C21D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C21D0Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C218S2489C17__8S2489C15[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(3088,1704),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C218S2489C17__8S2489C15[] = {
  0,
  ABISELECT(3216,1788),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(3216,1788),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C218S2489C17__8S2489C15[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(4912,2728),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev)();
extern void ABISELECT(_ZThn66928_N8S2489C21D1Ev,_ZThn37248_N8S2489C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev)();
extern void ABISELECT(_ZThn66928_N8S2489C21D0Ev,_ZThn37248_N8S2489C21D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__8S2489C218S2489C17__8S2489C15[] = {
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(-66928,-37248),
  ABISELECT(-71840,-39976),
  ABISELECT(-70144,-39036),
  ABISELECT(-70272,-39108),
  ABISELECT(-70016,-38952),
  ABISELECT(-66928,-37248),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A2__8S2489C218S2489C17__8S2489C15[] = {
  ABISELECT(-70688,-39372),
  ABISELECT(-67344,-37512),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZThn96_N8S2489C17D1Ev,_ZThn44_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn96_N8S2489C17D0Ev,_ZThn44_N8S2489C17D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A__8S2489C17__8S2489C15[] = {
  ABISELECT(-2304,-1272),
  ABISELECT(-608,-332),
  ABISELECT(-736,-404),
  ABISELECT(-480,-248),
  ABISELECT(-96,-44),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C17D1Ev,_ZThn44_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C17D0Ev,_ZThn44_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C17D1Ev,_ZTv0_n20_N8S2489C17D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C17D0Ev,_ZTv0_n20_N8S2489C17D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C17__8S2489C15[] = {
  0,
  ABISELECT(512,288),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(512,288),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C17D1Ev,_ZTv0_n20_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C17D0Ev,_ZTv0_n20_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C17__8S2489C15[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(384,204),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C17__8S2489C15[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(2208,1228),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A2__8S2489C17__8S2489C15[] = {
  ABISELECT(-1152,-668),
  ABISELECT(-512,-308),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n64_N8S2489C17D1Ev,_ZTv0_n32_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn3456_N8S2489C17D1Ev,_ZThn1908_N8S2489C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S2489C17D0Ev,_ZTv0_n32_N8S2489C17D0Ev)();
extern void ABISELECT(_ZThn3456_N8S2489C17D0Ev,_ZThn1908_N8S2489C17D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C20__8S2489C17__8S2489C15[] = {
  0,
  0,
  0,
  ABISELECT(-3456,-1908),
  ABISELECT(52208,29124),
  ABISELECT(-5664,-3136),
  ABISELECT(-3968,-2196),
  ABISELECT(-4096,-2268),
  ABISELECT(-3840,-2112),
  ABISELECT(-3456,-1908),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C17D1Ev,_ZTv0_n32_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C17D0Ev,_ZTv0_n32_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN8S2489C133v11Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C13__8S2489C17__8S2489C15[] = {
  0,
  ABISELECT(-55664,-31032),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
};
extern void ABISELECT(_ZThn2704_N8S2489C17D1Ev,_ZThn1500_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn2704_N8S2489C17D0Ev,_ZThn1500_N8S2489C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S2489C21__8S2489C17__8S2489C15[] = {
  ABISELECT(66928,37248),
  ABISELECT(-4912,-2728),
  ABISELECT(-3216,-1788),
  ABISELECT(-3344,-1860),
  ABISELECT(-3088,-1704),
  ABISELECT(-2704,-1500),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S2489C17D1Ev,_ZThn1500_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S2489C17D0Ev,_ZThn1500_N8S2489C17D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N8S2489C17D1Ev,_ZTv0_n28_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn69632_N8S2489C17D1Ev,_ZThn38748_N8S2489C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C17D0Ev,_ZTv0_n28_N8S2489C17D0Ev)();
extern void ABISELECT(_ZThn69632_N8S2489C17D0Ev,_ZThn38748_N8S2489C17D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A1__8S2489C17__8S2489C15[] = {
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(-69632,-38748),
  ABISELECT(-71840,-39976),
  ABISELECT(-70144,-39036),
  ABISELECT(-70272,-39108),
  ABISELECT(-70016,-38952),
  ABISELECT(-69632,-38748),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C17D1Ev,_ZTv0_n28_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C17D0Ev,_ZTv0_n28_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A3__8S2489C17__8S2489C15[] = {
  ABISELECT(-70688,-39372),
  ABISELECT(-70048,-39012),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C20D1Ev();
extern void _ZN8S2489C20D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C20__8S2489C15[] = {
  ABISELECT(52208,29124),
  ABISELECT(-5664,-3136),
  ABISELECT(-3968,-2196),
  ABISELECT(-4096,-2268),
  ABISELECT(-3840,-2112),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN8S2489C20D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C20D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN7S2489C9D1Ev();
extern void _ZN7S2489C9D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C98S2489C20__8S2489C15[] = {
  ABISELECT(-5664,-3136),
  ABISELECT(-3968,-2196),
  ABISELECT(-4096,-2268),
  ABISELECT(-3840,-2112),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C107S2489C98S2489C20__A1__8S2489C15[] = {
  ABISELECT(-5664,-3136),
  ABISELECT(-3968,-2196),
  ABISELECT(-4096,-2268),
  ABISELECT(-3840,-2112),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C107S2489C98S2489C20__A1__8S2489C15[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(3840,2112),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C107S2489C98S2489C20__A1__8S2489C15[] = {
  0,
  ABISELECT(3968,2196),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(3968,2196),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C107S2489C98S2489C20__A1__8S2489C15[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(5664,3136),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C98S2489C20__8S2489C15[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(3840,2112),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev)();
extern void ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__7S2489C98S2489C20__8S2489C15[] = {
  0,
  ABISELECT(3968,2196),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(3968,2196),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__7S2489C98S2489C20__8S2489C15[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(5664,3136),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C20__8S2489C15[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(5664,3136),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A1__8S2489C20__8S2489C15[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(3840,2112),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C20D1Ev,_ZTv0_n20_N8S2489C20D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C20D0Ev,_ZTv0_n20_N8S2489C20D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C20__8S2489C15[] = {
  0,
  ABISELECT(3968,2196),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(3968,2196),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C20D1Ev,_ZTv0_n20_N8S2489C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C20D0Ev,_ZTv0_n20_N8S2489C20D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN8S2489C133v11Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C13__8S2489C20__8S2489C15[] = {
  0,
  ABISELECT(-52208,-29124),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
};
extern void _ZN8S2489C19D1Ev();
extern void _ZN8S2489C19D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A1__8S2489C15[] = {
  ABISELECT(-71840,-39976),
  ABISELECT(-70144,-39036),
  ABISELECT(-70272,-39108),
  ABISELECT(-70016,-38952),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN8S2489C19D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C19D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C108S2489C19__A2__8S2489C15[] = {
  ABISELECT(-71840,-39976),
  ABISELECT(-70144,-39036),
  ABISELECT(-70272,-39108),
  ABISELECT(-70016,-38952),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C108S2489C19__A2__8S2489C15[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(70016,38952),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C108S2489C19__A2__8S2489C15[] = {
  0,
  ABISELECT(70144,39036),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(70144,39036),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C108S2489C19__A2__8S2489C15[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(71840,39976),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A3__8S2489C15[] = {
  ABISELECT(-70688,-39372),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C19__A1__8S2489C15[] = {
  0,
  ABISELECT(70144,39036),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(70144,39036),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C19__A1__8S2489C15[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(70016,38952),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C19__A1__8S2489C15[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(71840,39976),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A__8S2489C19__A1__8S2489C15[] = {
  ABISELECT(-70688,-39372),
  ABISELECT(-416,-264),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C23D1Ev();
extern void _ZN8S2489C23D0Ev();
extern void _ZN8S2489C173v12Ev();
extern void _ZN8S2489C173v13Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C23__8S2489C15[] = {
  ABISELECT(6320,3536),
  ABISELECT(-2608,-1456),
  ABISELECT(-16576,-9172),
  ABISELECT(-68784,-38296),
  ABISELECT(-74448,-41432),
  ABISELECT(-72624,-40408),
  ABISELECT(-72880,-40564),
  ABISELECT(-72752,-40492),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&_ZN8S2489C23D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C23D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v12Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v13Ev,
};
extern void _ZN8S2489C17D1Ev();
extern void _ZN8S2489C17D0Ev();
extern void _ZN8S2489C173v12Ev();
extern void _ZN8S2489C173v13Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C178S2489C23__A1__8S2489C15[] = {
  ABISELECT(-2608,-1456),
  ABISELECT(-16576,-9172),
  ABISELECT(-68784,-38296),
  ABISELECT(-74448,-41432),
  ABISELECT(-72624,-40408),
  ABISELECT(-72880,-40564),
  ABISELECT(-72752,-40492),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN8S2489C17D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C17D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v12Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v13Ev,
};
extern void _ZN8S2489C19D1Ev();
extern void _ZN8S2489C19D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C198S2489C178S2489C23__A2__8S2489C15[] = {
  ABISELECT(-74544,-41476),
  ABISELECT(-72848,-40536),
  ABISELECT(-72976,-40608),
  ABISELECT(-72720,-40452),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN8S2489C19D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C19D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C108S2489C198S2489C178S2489C23__A4__8S2489C15[] = {
  ABISELECT(-74544,-41476),
  ABISELECT(-72848,-40536),
  ABISELECT(-72976,-40608),
  ABISELECT(-72720,-40452),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C108S2489C198S2489C178S2489C23__A4__8S2489C15[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(72720,40452),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C108S2489C198S2489C178S2489C23__A4__8S2489C15[] = {
  0,
  ABISELECT(72848,40536),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(72848,40536),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C108S2489C198S2489C178S2489C23__A4__8S2489C15[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(74544,41476),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C198S2489C178S2489C23__A4__8S2489C15[] = {
  ABISELECT(-73392,-40872),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C198S2489C178S2489C23__A2__8S2489C15[] = {
  0,
  ABISELECT(72848,40536),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(72848,40536),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C198S2489C178S2489C23__A2__8S2489C15[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(72720,40452),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C198S2489C178S2489C23__A2__8S2489C15[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(74544,41476),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A__8S2489C198S2489C178S2489C23__A2__8S2489C15[] = {
  ABISELECT(-73392,-40872),
  ABISELECT(-416,-264),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C21D1Ev();
extern void _ZN8S2489C21D0Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C218S2489C178S2489C23__A1__8S2489C15[] = {
  ABISELECT(-5312,-2956),
  ABISELECT(-77152,-42932),
  ABISELECT(-75456,-41992),
  ABISELECT(-75584,-42064),
  ABISELECT(-75328,-41908),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN8S2489C21D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C21D0Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C218S2489C178S2489C23__A1__8S2489C15[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(75328,41908),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C218S2489C178S2489C23__A1__8S2489C15[] = {
  0,
  ABISELECT(75456,41992),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(75456,41992),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C218S2489C178S2489C23__A1__8S2489C15[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(77152,42932),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev)();
extern void ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__8S2489C218S2489C178S2489C23__A1__8S2489C15[] = {
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(5312,2956),
  ABISELECT(-71840,-39976),
  ABISELECT(-70144,-39036),
  ABISELECT(-70272,-39108),
  ABISELECT(-70016,-38952),
  ABISELECT(5312,2956),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A2__8S2489C218S2489C178S2489C23__A1__8S2489C15[] = {
  ABISELECT(-70688,-39372),
  ABISELECT(4896,2692),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZThn96_N8S2489C17D1Ev,_ZThn44_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn96_N8S2489C17D0Ev,_ZThn44_N8S2489C17D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A__8S2489C178S2489C23__A1__8S2489C15[] = {
  ABISELECT(-74544,-41476),
  ABISELECT(-72848,-40536),
  ABISELECT(-72976,-40608),
  ABISELECT(-72720,-40452),
  ABISELECT(-96,-44),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C17D1Ev,_ZThn44_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C17D0Ev,_ZThn44_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C17D1Ev,_ZTv0_n20_N8S2489C17D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C17D0Ev,_ZTv0_n20_N8S2489C17D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C178S2489C23__A1__8S2489C15[] = {
  0,
  ABISELECT(72752,40492),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(72752,40492),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C17D1Ev,_ZTv0_n20_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C17D0Ev,_ZTv0_n20_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C178S2489C23__A1__8S2489C15[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(72624,40408),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C178S2489C23__A1__8S2489C15[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(74448,41432),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A2__8S2489C178S2489C23__A1__8S2489C15[] = {
  ABISELECT(-73392,-40872),
  ABISELECT(-512,-308),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n64_N8S2489C17D1Ev,_ZTv0_n32_N8S2489C17D1Ev)();
extern void ABISELECT(_ZTv0_n64_N8S2489C17D0Ev,_ZTv0_n32_N8S2489C17D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C20__8S2489C178S2489C23__A1__8S2489C15[] = {
  0,
  0,
  0,
  ABISELECT(68784,38296),
  ABISELECT(52208,29124),
  ABISELECT(-5664,-3136),
  ABISELECT(-3968,-2196),
  ABISELECT(-4096,-2268),
  ABISELECT(-3840,-2112),
  ABISELECT(68784,38296),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C17D1Ev,_ZTv0_n32_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C17D0Ev,_ZTv0_n32_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN8S2489C133v11Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C13__8S2489C178S2489C23__A1__8S2489C15[] = {
  0,
  ABISELECT(16576,9172),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
};
extern void ABISELECT(_ZThn2704_N8S2489C17D1Ev,_ZThn1500_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn2704_N8S2489C17D0Ev,_ZThn1500_N8S2489C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S2489C21__8S2489C178S2489C23__A1__8S2489C15[] = {
  ABISELECT(-5312,-2956),
  ABISELECT(-77152,-42932),
  ABISELECT(-75456,-41992),
  ABISELECT(-75584,-42064),
  ABISELECT(-75328,-41908),
  ABISELECT(-2704,-1500),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S2489C17D1Ev,_ZThn1500_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S2489C17D0Ev,_ZThn1500_N8S2489C17D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N8S2489C17D1Ev,_ZTv0_n28_N8S2489C17D1Ev)();
extern void ABISELECT(_ZTv0_n56_N8S2489C17D0Ev,_ZTv0_n28_N8S2489C17D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A1__8S2489C178S2489C23__A1__8S2489C15[] = {
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(2608,1456),
  ABISELECT(-71840,-39976),
  ABISELECT(-70144,-39036),
  ABISELECT(-70272,-39108),
  ABISELECT(-70016,-38952),
  ABISELECT(2608,1456),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C17D1Ev,_ZTv0_n28_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C17D0Ev,_ZTv0_n28_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A3__8S2489C178S2489C23__A1__8S2489C15[] = {
  ABISELECT(-70688,-39372),
  ABISELECT(2192,1192),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S2489C23D1Ev,_ZTv0_n28_N8S2489C23D1Ev)();
extern void ABISELECT(_ZThn6320_N8S2489C23D1Ev,_ZThn3536_N8S2489C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C23D0Ev,_ZTv0_n28_N8S2489C23D0Ev)();
extern void ABISELECT(_ZThn6320_N8S2489C23D0Ev,_ZThn3536_N8S2489C23D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C10__8S2489C23__8S2489C15[] = {
  0,
  ABISELECT(-6320,-3536),
  ABISELECT(-80768,-44968),
  ABISELECT(-79072,-44028),
  ABISELECT(-79200,-44100),
  ABISELECT(-78944,-43944),
  ABISELECT(-6320,-3536),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C23D1Ev,_ZTv0_n28_N8S2489C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C23D0Ev,_ZTv0_n28_N8S2489C23D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C23__8S2489C15[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(72624,40408),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C23D1Ev,_ZTv0_n20_N8S2489C23D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C23D0Ev,_ZTv0_n20_N8S2489C23D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C23__8S2489C15[] = {
  0,
  ABISELECT(72752,40492),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(72752,40492),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C23D1Ev,_ZTv0_n20_N8S2489C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C23D0Ev,_ZTv0_n20_N8S2489C23D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C23__8S2489C15[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(74448,41432),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN8S2489C133v11Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C13__8S2489C23__8S2489C15[] = {
  0,
  ABISELECT(16576,9172),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
};
extern void ABISELECT(_ZThn96_N8S2489C23D1Ev,_ZThn44_N8S2489C23D1Ev)();
extern void ABISELECT(_ZThn96_N8S2489C23D0Ev,_ZThn44_N8S2489C23D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C198S2489C17__8S2489C23__8S2489C15[] = {
  ABISELECT(-74544,-41476),
  ABISELECT(-72848,-40536),
  ABISELECT(-72976,-40608),
  ABISELECT(-72720,-40452),
  ABISELECT(-96,-44),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C23D1Ev,_ZThn44_N8S2489C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C23D0Ev,_ZThn44_N8S2489C23D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C198S2489C17__A2__8S2489C23__8S2489C15[] = {
  ABISELECT(-73392,-40872),
  ABISELECT(-512,-308),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n64_N8S2489C23D1Ev,_ZTv0_n32_N8S2489C23D1Ev)();
extern void ABISELECT(_ZTv0_n64_N8S2489C23D0Ev,_ZTv0_n32_N8S2489C23D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C20__8S2489C23__8S2489C15[] = {
  0,
  0,
  0,
  ABISELECT(68784,38296),
  ABISELECT(52208,29124),
  ABISELECT(-5664,-3136),
  ABISELECT(-3968,-2196),
  ABISELECT(-4096,-2268),
  ABISELECT(-3840,-2112),
  ABISELECT(68784,38296),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C23D1Ev,_ZTv0_n32_N8S2489C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C23D0Ev,_ZTv0_n32_N8S2489C23D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void ABISELECT(_ZThn2704_N8S2489C23D1Ev,_ZThn1500_N8S2489C23D1Ev)();
extern void ABISELECT(_ZThn2704_N8S2489C23D0Ev,_ZThn1500_N8S2489C23D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S2489C218S2489C17__8S2489C23__8S2489C15[] = {
  ABISELECT(-5312,-2956),
  ABISELECT(-77152,-42932),
  ABISELECT(-75456,-41992),
  ABISELECT(-75584,-42064),
  ABISELECT(-75328,-41908),
  ABISELECT(-2704,-1500),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S2489C23D1Ev,_ZThn1500_N8S2489C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S2489C23D0Ev,_ZThn1500_N8S2489C23D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N8S2489C23D1Ev,_ZTv0_n28_N8S2489C23D1Ev)();
extern void ABISELECT(_ZTv0_n56_N8S2489C23D0Ev,_ZTv0_n28_N8S2489C23D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A1__8S2489C23__8S2489C15[] = {
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(2608,1456),
  ABISELECT(-71840,-39976),
  ABISELECT(-70144,-39036),
  ABISELECT(-70272,-39108),
  ABISELECT(-70016,-38952),
  ABISELECT(2608,1456),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C23D1Ev,_ZTv0_n28_N8S2489C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C23D0Ev,_ZTv0_n28_N8S2489C23D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A3__8S2489C23__8S2489C15[] = {
  ABISELECT(-70688,-39372),
  ABISELECT(2192,1192),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C10__A3__8S2489C15[] = {
  ABISELECT(-80768,-44968),
  ABISELECT(-79072,-44028),
  ABISELECT(-79200,-44100),
  ABISELECT(-78944,-43944),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C10__A3__8S2489C15[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(78944,43944),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C10__A3__8S2489C15[] = {
  0,
  ABISELECT(79072,44028),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(79072,44028),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C10__A3__8S2489C15[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(80768,44968),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
static  VTT_ENTRY vtt_S2489C15[] = {
  {&(_ZTV8S2489C15[12]),  12,230},
  {&(_tg__ZTV8S2489C14__8S2489C15[6]),  6,8},
  {&(_tg__ZTV7S2489C5__8S2489C14__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C8__8S2489C14__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A1__8S2489C14__8S2489C15[5]),  5,7},
  {&(_tg__ZTV8S2489C16__8S2489C15[10]),  10,12},
  {&(_tg__ZTV8S2489C17__8S2489C16__8S2489C15[18]),  18,22},
  {&(_tg__ZTV8S2489C198S2489C17__8S2489C16__8S2489C15[6]),  6,12},
  {&(_tg__ZTV7S2489C8__8S2489C16__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C16__8S2489C15[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C16__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C68S2489C198S2489C17__A2__8S2489C16__8S2489C15[3]),  3,5},
  {&(_tg__ZTV8S2489C20__8S2489C16__8S2489C15[11]),  11,16},
  {&(_tg__ZTV8S2489C13__8S2489C16__8S2489C15[3]),  3,4},
  {&(_tg__ZTV8S2489C218S2489C17__8S2489C16__8S2489C15[7]),  7,9},
  {&(_tg__ZTV8S2489C19__A1__8S2489C16__8S2489C15[13]),  13,19},
  {&(_tg__ZTV7S2489C68S2489C19__A3__8S2489C16__8S2489C15[3]),  3,5},
  {&(_tg__ZTV8S2489C22__8S2489C15[11]),  11,18},
  {&(_tg__ZTV7S2489C58S2489C22__A1__8S2489C15[3]),  3,6},
  {&(_tg__ZTV7S2489C67S2489C58S2489C22__A5__8S2489C15[3]),  3,5},
  {&(_tg__ZTV8S2489C23__8S2489C22__8S2489C15[19]),  19,23},
  {&(_tg__ZTV8S2489C10__8S2489C22__8S2489C15[8]),  8,11},
  {&(_tg__ZTV7S2489C6__8S2489C22__8S2489C15[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C22__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C22__8S2489C15[6]),  6,9},
  {&(_tg__ZTV8S2489C13__8S2489C22__8S2489C15[3]),  3,4},
  {&(_tg__ZTV8S2489C198S2489C178S2489C23__8S2489C22__8S2489C15[6]),  6,12},
  {&(_tg__ZTV7S2489C68S2489C198S2489C178S2489C23__A2__8S2489C22__8S2489C15[3]),  3,5},
  {&(_tg__ZTV8S2489C20__8S2489C22__8S2489C15[11]),  11,16},
  {&(_tg__ZTV8S2489C218S2489C178S2489C23__8S2489C22__8S2489C15[7]),  7,9},
  {&(_tg__ZTV8S2489C19__A1__8S2489C22__8S2489C15[13]),  13,19},
  {&(_tg__ZTV7S2489C68S2489C19__A3__8S2489C22__8S2489C15[3]),  3,5},
  {&(_tg__ZTV8S2489C21__A2__8S2489C15[7]),  7,9},
  {&(_tg__ZTV7S2489C6__8S2489C21__A2__8S2489C15[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C21__A2__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C21__A2__8S2489C15[6]),  6,9},
  {&(_tg__ZTV8S2489C19__8S2489C21__A2__8S2489C15[13]),  13,19},
  {&(_tg__ZTV7S2489C68S2489C19__A2__8S2489C21__A2__8S2489C15[3]),  3,5},
  {&(_ZTV8S2489C15[59]),  59,230},
  {&(_ZTV8S2489C15[68]),  68,230},
  {&(_ZTV8S2489C15[76]),  76,230},
  {&(_ZTV8S2489C15[24]),  24,230},
  {&(_ZTV8S2489C15[96]),  96,230},
  {&(_ZTV8S2489C15[106]),  106,230},
  {&(_ZTV8S2489C15[115]),  115,230},
  {&(_ZTV8S2489C15[137]),  137,230},
  {&(_ZTV8S2489C15[145]),  145,230},
  {&(_ZTV8S2489C15[124]),  124,230},
  {&(_ZTV8S2489C15[159]),  159,230},
  {&(_ZTV8S2489C15[168]),  168,230},
  {&(_ZTV8S2489C15[37]),  37,230},
  {&(_ZTV8S2489C15[189]),  189,230},
  {&(_ZTV8S2489C15[227]),  227,230},
  {&(_ZTV8S2489C15[199]),  199,230},
  {&(_ZTV8S2489C15[208]),  208,230},
  {&(_ZTV8S2489C15[217]),  217,230},
  {&(_ZTV8S2489C15[51]),  51,230},
  {&(_tg__ZTV7S2489C5__8S2489C15[3]),  3,6},
  {&(_tg__ZTV7S2489C67S2489C5__8S2489C15[3]),  3,5},
  {&(_tg__ZTV7S2489C8__8S2489C15[4]),  4,7},
  {&(_tg__ZTV7S2489C6__7S2489C8__8S2489C15[5]),  5,7},
  {&(_tg__ZTV7S2489C6__A1__8S2489C15[3]),  3,5},
  {&(_tg__ZTV8S2489C17__8S2489C15[9]),  9,13},
  {&(_tg__ZTV8S2489C198S2489C17__8S2489C15[6]),  6,12},
  {&(_tg__ZTV8S2489C108S2489C198S2489C17__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C108S2489C198S2489C17__8S2489C15[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C108S2489C198S2489C17__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C108S2489C198S2489C17__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C68S2489C198S2489C17__A2__8S2489C15[3]),  3,5},
  {&(_tg__ZTV7S2489C8__8S2489C198S2489C17__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C198S2489C17__8S2489C15[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C198S2489C17__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A__8S2489C198S2489C17__8S2489C15[3]),  3,5},
  {&(_tg__ZTV8S2489C218S2489C17__8S2489C15[7]),  7,9},
  {&(_tg__ZTV7S2489C6__8S2489C218S2489C17__8S2489C15[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C218S2489C17__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C218S2489C17__8S2489C15[6]),  6,9},
  {&(_tg__ZTV8S2489C19__8S2489C218S2489C17__8S2489C15[13]),  13,19},
  {&(_tg__ZTV7S2489C68S2489C19__A2__8S2489C218S2489C17__8S2489C15[3]),  3,5},
  {&(_tg__ZTV8S2489C19__A__8S2489C17__8S2489C15[6]),  6,12},
  {&(_tg__ZTV7S2489C8__8S2489C17__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C17__8S2489C15[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C17__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C68S2489C19__A2__8S2489C17__8S2489C15[3]),  3,5},
  {&(_tg__ZTV8S2489C20__8S2489C17__8S2489C15[11]),  11,16},
  {&(_tg__ZTV8S2489C13__8S2489C17__8S2489C15[3]),  3,4},
  {&(_tg__ZTV8S2489C21__8S2489C17__8S2489C15[7]),  7,9},
  {&(_tg__ZTV8S2489C19__A1__8S2489C17__8S2489C15[13]),  13,19},
  {&(_tg__ZTV7S2489C68S2489C19__A3__8S2489C17__8S2489C15[3]),  3,5},
  {&(_tg__ZTV8S2489C20__8S2489C15[7]),  7,12},
  {&(_tg__ZTV7S2489C98S2489C20__8S2489C15[6]),  6,11},
  {&(_tg__ZTV8S2489C107S2489C98S2489C20__A1__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C107S2489C98S2489C20__A1__8S2489C15[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C107S2489C98S2489C20__A1__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C107S2489C98S2489C20__A1__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C6__7S2489C98S2489C20__8S2489C15[5]),  5,7},
  {&(_tg__ZTV7S2489C8__7S2489C98S2489C20__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C5__7S2489C98S2489C20__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C20__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A1__8S2489C20__8S2489C15[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C20__8S2489C15[6]),  6,9},
  {&(_tg__ZTV8S2489C13__8S2489C20__8S2489C15[3]),  3,4},
  {&(_tg__ZTV8S2489C19__A1__8S2489C15[6]),  6,12},
  {&(_tg__ZTV8S2489C108S2489C19__A2__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C108S2489C19__A2__8S2489C15[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C108S2489C19__A2__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C108S2489C19__A2__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C68S2489C19__A3__8S2489C15[3]),  3,5},
  {&(_tg__ZTV7S2489C8__8S2489C19__A1__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C19__A1__8S2489C15[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C19__A1__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A__8S2489C19__A1__8S2489C15[3]),  3,5},
  {&(_tg__ZTV8S2489C23__8S2489C15[10]),  10,14},
  {&(_tg__ZTV8S2489C178S2489C23__A1__8S2489C15[9]),  9,13},
  {&(_tg__ZTV8S2489C198S2489C178S2489C23__A2__8S2489C15[6]),  6,12},
  {&(_tg__ZTV8S2489C108S2489C198S2489C178S2489C23__A4__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C108S2489C198S2489C178S2489C23__A4__8S2489C15[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C108S2489C198S2489C178S2489C23__A4__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C108S2489C198S2489C178S2489C23__A4__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C68S2489C198S2489C178S2489C23__A4__8S2489C15[3]),  3,5},
  {&(_tg__ZTV7S2489C8__8S2489C198S2489C178S2489C23__A2__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C198S2489C178S2489C23__A2__8S2489C15[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C198S2489C178S2489C23__A2__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A__8S2489C198S2489C178S2489C23__A2__8S2489C15[3]),  3,5},
  {&(_tg__ZTV8S2489C218S2489C178S2489C23__A1__8S2489C15[7]),  7,9},
  {&(_tg__ZTV7S2489C6__8S2489C218S2489C178S2489C23__A1__8S2489C15[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C218S2489C178S2489C23__A1__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C218S2489C178S2489C23__A1__8S2489C15[6]),  6,9},
  {&(_tg__ZTV8S2489C19__8S2489C218S2489C178S2489C23__A1__8S2489C15[13]),  13,19},
  {&(_tg__ZTV7S2489C68S2489C19__A2__8S2489C218S2489C178S2489C23__A1__8S2489C15[3]),  3,5},
  {&(_tg__ZTV8S2489C19__A__8S2489C178S2489C23__A1__8S2489C15[6]),  6,12},
  {&(_tg__ZTV7S2489C8__8S2489C178S2489C23__A1__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C178S2489C23__A1__8S2489C15[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C178S2489C23__A1__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C68S2489C19__A2__8S2489C178S2489C23__A1__8S2489C15[3]),  3,5},
  {&(_tg__ZTV8S2489C20__8S2489C178S2489C23__A1__8S2489C15[11]),  11,16},
  {&(_tg__ZTV8S2489C13__8S2489C178S2489C23__A1__8S2489C15[3]),  3,4},
  {&(_tg__ZTV8S2489C21__8S2489C178S2489C23__A1__8S2489C15[7]),  7,9},
  {&(_tg__ZTV8S2489C19__A1__8S2489C178S2489C23__A1__8S2489C15[13]),  13,19},
  {&(_tg__ZTV7S2489C68S2489C19__A3__8S2489C178S2489C23__A1__8S2489C15[3]),  3,5},
  {&(_tg__ZTV8S2489C10__8S2489C23__8S2489C15[8]),  8,11},
  {&(_tg__ZTV7S2489C6__8S2489C23__8S2489C15[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C23__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C23__8S2489C15[6]),  6,9},
  {&(_tg__ZTV8S2489C13__8S2489C23__8S2489C15[3]),  3,4},
  {&(_tg__ZTV8S2489C198S2489C17__8S2489C23__8S2489C15[6]),  6,12},
  {&(_tg__ZTV7S2489C68S2489C198S2489C17__A2__8S2489C23__8S2489C15[3]),  3,5},
  {&(_tg__ZTV8S2489C20__8S2489C23__8S2489C15[11]),  11,16},
  {&(_tg__ZTV8S2489C218S2489C17__8S2489C23__8S2489C15[7]),  7,9},
  {&(_tg__ZTV8S2489C19__A1__8S2489C23__8S2489C15[13]),  13,19},
  {&(_tg__ZTV7S2489C68S2489C19__A3__8S2489C23__8S2489C15[3]),  3,5},
  {&(_tg__ZTV8S2489C10__A3__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C10__A3__8S2489C15[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C10__A3__8S2489C15[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C10__A3__8S2489C15[6]),  6,9},
};
extern VTBL_ENTRY _ZTI8S2489C15[];
extern  VTBL_ENTRY _ZTV8S2489C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C15[];
static VTBL_ENTRY alt_thunk_names12[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C23D0Ev,_ZTv0_n28_N8S2489C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6320_N8S2489C23D0Ev,_ZThn3536_N8S2489C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C23D1Ev,_ZTv0_n28_N8S2489C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6320_N8S2489C23D1Ev,_ZThn3536_N8S2489C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C17D0Ev,_ZTv0_n28_N8S2489C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn69632_N8S2489C17D0Ev,_ZThn38748_N8S2489C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C17D1Ev,_ZTv0_n28_N8S2489C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn69632_N8S2489C17D1Ev,_ZThn38748_N8S2489C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C17D0Ev,_ZTv0_n32_N8S2489C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3456_N8S2489C17D0Ev,_ZThn1908_N8S2489C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C17D1Ev,_ZTv0_n32_N8S2489C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3456_N8S2489C17D1Ev,_ZThn1908_N8S2489C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn66928_N8S2489C21D0Ev,_ZThn37248_N8S2489C21D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn72160_N8S2489C21D0Ev,_ZThn40156_N8S2489C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn66928_N8S2489C21D1Ev,_ZThn37248_N8S2489C21D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn72160_N8S2489C21D1Ev,_ZThn40156_N8S2489C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2016_N8S2489C21D0Ev,_ZThn1120_N8S2489C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2016_N8S2489C21D1Ev,_ZThn1120_N8S2489C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C22D0Ev,_ZTv0_n32_N8S2489C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7792_N8S2489C22D0Ev,_ZThn4348_N8S2489C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C22D1Ev,_ZTv0_n32_N8S2489C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7792_N8S2489C22D1Ev,_ZThn4348_N8S2489C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C22D0Ev,_ZTv0_n20_N8S2489C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3824_N8S2489C22D0Ev,_ZThn2152_N8S2489C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C22D1Ev,_ZTv0_n20_N8S2489C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3824_N8S2489C22D1Ev,_ZThn2152_N8S2489C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C22D0Ev,_ZTv0_n28_N8S2489C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn73968_N8S2489C22D0Ev,_ZThn41188_N8S2489C22D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn82896_N8S2489C22D0Ev,_ZThn46180_N8S2489C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C22D1Ev,_ZTv0_n28_N8S2489C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn73968_N8S2489C22D1Ev,_ZThn41188_N8S2489C22D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn82896_N8S2489C22D1Ev,_ZThn46180_N8S2489C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n88_N8S2489C22D0Ev,_ZTv0_n44_N8S2489C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn76576_N8S2489C22D0Ev,_ZThn42644_N8S2489C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n88_N8S2489C22D1Ev,_ZTv0_n44_N8S2489C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn76576_N8S2489C22D1Ev,_ZThn42644_N8S2489C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C16D0Ev,_ZTv0_n28_N8S2489C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn76752_N8S2489C16D0Ev,_ZThn42796_N8S2489C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C16D1Ev,_ZTv0_n28_N8S2489C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn76752_N8S2489C16D1Ev,_ZThn42796_N8S2489C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C16D0Ev,_ZTv0_n32_N8S2489C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10576_N8S2489C16D0Ev,_ZThn5956_N8S2489C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C16D1Ev,_ZTv0_n32_N8S2489C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10576_N8S2489C16D1Ev,_ZThn5956_N8S2489C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C16D0Ev,_ZTv0_n20_N8S2489C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6608_N8S2489C16D0Ev,_ZThn3760_N8S2489C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C16D1Ev,_ZTv0_n20_N8S2489C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6608_N8S2489C16D1Ev,_ZThn3760_N8S2489C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S2489C16D0Ev,_ZTv0_n40_N8S2489C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7120_N8S2489C16D0Ev,_ZThn4048_N8S2489C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S2489C16D1Ev,_ZTv0_n40_N8S2489C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7120_N8S2489C16D1Ev,_ZThn4048_N8S2489C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C14D0Ev,_ZTv0_n20_N8S2489C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6704_N8S2489C14D0Ev,_ZThn3804_N8S2489C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C14D1Ev,_ZTv0_n20_N8S2489C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6704_N8S2489C14D1Ev,_ZThn3804_N8S2489C14D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n88_N8S2489C15D0Ev,_ZTv0_n44_N8S2489C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn79456_N8S2489C15D0Ev,_ZThn44296_N8S2489C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n88_N8S2489C15D1Ev,_ZTv0_n44_N8S2489C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn79456_N8S2489C15D1Ev,_ZThn44296_N8S2489C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C15D0Ev,_ZTv0_n28_N8S2489C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn85776_N8S2489C15D0Ev,_ZThn47832_N8S2489C15D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn76848_N8S2489C15D0Ev,_ZThn42840_N8S2489C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C15D1Ev,_ZTv0_n28_N8S2489C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn85776_N8S2489C15D1Ev,_ZThn47832_N8S2489C15D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn76848_N8S2489C15D1Ev,_ZThn42840_N8S2489C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C15D0Ev,_ZTv0_n32_N8S2489C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10672_N8S2489C15D0Ev,_ZThn6000_N8S2489C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C15D1Ev,_ZTv0_n32_N8S2489C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn10672_N8S2489C15D1Ev,_ZThn6000_N8S2489C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S2489C15D0Ev,_ZTv0_n40_N8S2489C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7216_N8S2489C15D0Ev,_ZThn4092_N8S2489C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S2489C15D1Ev,_ZTv0_n40_N8S2489C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn7216_N8S2489C15D1Ev,_ZThn4092_N8S2489C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C15D0Ev,_ZTv0_n20_N8S2489C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6704_N8S2489C15D0Ev,_ZThn3804_N8S2489C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C15D1Ev,_ZTv0_n20_N8S2489C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6704_N8S2489C15D1Ev,_ZThn3804_N8S2489C15D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S2489C15 = {  "S2489C15", // class name
  bases_S2489C15, 45,
  &(vtc_S2489C15[0]), // expected_vtbl_contents
  &(vtt_S2489C15[0]), // expected_vtt_contents
  ABISELECT(86064,48024), // object size
  NSPAIRA(_ZTI8S2489C15),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S2489C15),230, //virtual function table var
  12, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S2489C15),155, //virtual table table var
  31, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names12,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2489C24  : virtual S2489C6 , virtual S2489C20 , S2489C8 , S2489C18 {
  void *s2489c24f0;
  void *s2489c24f1;
  int s2489c24f2;
  void *s2489c24f3;
  virtual  ~S2489C24(); // _ZN8S2489C24D2Ev
  S2489C24(); // tgen
};
//SIG(-1 S2489C24) C1{ VBC2{ VBC3{ m Fc Fi FL FU4{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} v1 v2 Fp Fp Fi Fi FU5{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU5 Fp FL:3 FC3 FL FU5} VBC6{ VBC7{ BC3 BC2 v3 Fp FD FC3[7] FD FU4 Fs FL FL} VBC2 VBC8{ VBC3 VBC2 vd v4 FL FL FL FL Fi FU5 Fc[10] Fi} BC9{ BC10{ BC3 VBC2 VBC8 VBC7 vd v5 Fc Fi[7] Fl[5] FL FL FL FU11{ m Fp Fi Fp Fc Fc FL[5] Fp Fp Fp}} vd v6 v7 Fp Fp Fp Fi FC12{} FL FL} VBC13{ v8 FD FC14{ VBC7 VBC8 Fi Fp Fi FU5}[6] Fc Fp Fp Fi[6] Fi Fp FL Fp Fi Fp Fp} vd Fc Fs[3] FC15{ BC3 VBC2 VBC8 VBC7 VBC16{ VBC8 BC10 BC3 BC2 vd v9 v10 v11 FU5 Fi Fl Fc Fp FC7 Fs} vd FL Fi Fp Fp FL}[10] FC7 FL FL:5 Fi Fp[6] FL[2] FL Fi} BC8 BC17{ vd m FU4} vd Fp Fp Fi Fp}


 S2489C24 ::~S2489C24(){ note_dtor("S2489C24", this);}
S2489C24 ::S2489C24(){ note_ctor("S2489C24", this);} // tgen

static void Test_S2489C24()
{
  extern Class_Descriptor cd_S2489C24;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(4290,9554)];
    init_test(&cd_S2489C24, buf);
    S2489C24 *dp, &lv = *(dp=new (buf) S2489C24());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(68624,38212), "sizeof(S2489C24)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2489C24)");
    /*is_ambiguous_... S2489C24::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*), ABISELECT(640,348), "S2489C24");
    check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C5*), ABISELECT(640,348), "S2489C24");
    /*is_ambiguous_... S2489C24::S2489C8 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C8*), ABISELECT(640,348), "S2489C24");
    /*is_ambiguous_... S2489C24::S2489C8 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C8*), ABISELECT(640,348), "S2489C24");
    /*is_ambiguous_... S2489C24::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*), ABISELECT(256,144), "S2489C24");
    /*is_ambiguous_... S2489C20::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C20*), ABISELECT(256,144), "S2489C24");
    /*is_ambiguous_... S2489C24::S2489C8 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C8*), ABISELECT(256,144), "S2489C24");
    /*is_ambiguous_... S2489C10::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(256,144), "S2489C24");
    /*is_ambiguous_... S2489C24::S2489C8 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C8*), ABISELECT(256,144), "S2489C24");
    /*is_ambiguous_... S2489C5::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C5*), ABISELECT(53360,29748), "S2489C24");
    check_base_class_offset(lv, (S2489C6*)(S2489C5*), ABISELECT(52976,29544), "S2489C24");
    check_base_class_offset(lv, (S2489C5*)(S2489C20*), ABISELECT(52976,29544), "S2489C24");
    check_base_class_offset(lv, (S2489C5*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(52976,29544), "S2489C24");
    check_base_class_offset(lv, (S2489C8*)(S2489C20*), ABISELECT(54536,30412), "S2489C24");
    check_base_class_offset(lv, (S2489C8*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(54536,30412), "S2489C24");
    /*is_ambiguous_... S2489C10::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(784,424), "S2489C24");
    check_base_class_offset(lv, (S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(768,420), "S2489C24");
    check_base_class_offset(lv, (S2489C9*)(S2489C20*), ABISELECT(768,420), "S2489C24");
    check_base_class_offset(lv, (S2489C13*)(S2489C20*), ABISELECT(54656,30496), "S2489C24");
    check_base_class_offset(lv, (S2489C20*), ABISELECT(768,420), "S2489C24");
    /*is_ambiguous_... S2489C24::S2489C8 */ AMB_check_base_class_offset(lv, (S2489C8*), 0, "S2489C24");
    check_base_class_offset(lv, (S2489C18*), ABISELECT(128,84), "S2489C24");
    check_field_offset(lv, s2489c24f0, ABISELECT(224,128), "S2489C24.s2489c24f0");
    check_field_offset(lv, s2489c24f1, ABISELECT(232,132), "S2489C24.s2489c24f1");
    check_field_offset(lv, s2489c24f2, ABISELECT(240,136), "S2489C24.s2489c24f2");
    check_field_offset(lv, s2489c24f3, ABISELECT(248,140), "S2489C24.s2489c24f3");
    test_class_info(&lv, &cd_S2489C24);
    dp->~S2489C24();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2489C24(Test_S2489C24, "S2489C24", ABISELECT(68624,38212));

#else // __cplusplus

extern void _ZN8S2489C24C1Ev();
extern void _ZN8S2489C24D2Ev();
Name_Map name_map_S2489C24[] = {
  NSPAIR(_ZN8S2489C24C1Ev),
  NSPAIR(_ZN8S2489C24D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C5;
extern VTBL_ENTRY _ZTI7S2489C5[];
extern  VTBL_ENTRY _ZTV7S2489C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C5[];
extern Class_Descriptor cd_S2489C8;
extern VTBL_ENTRY _ZTI7S2489C8[];
extern  VTBL_ENTRY _ZTV7S2489C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C8[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C9;
extern VTBL_ENTRY _ZTI7S2489C9[];
extern  VTBL_ENTRY _ZTV7S2489C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C9[];
extern Class_Descriptor cd_S2489C13;
extern VTBL_ENTRY _ZTI8S2489C13[];
extern  VTBL_ENTRY _ZTV8S2489C13[];
extern Class_Descriptor cd_S2489C20;
extern VTBL_ENTRY _ZTI8S2489C20[];
extern  VTBL_ENTRY _ZTV8S2489C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C20[];
extern Class_Descriptor cd_S2489C8;
extern VTBL_ENTRY _ZTI7S2489C8[];
extern  VTBL_ENTRY _ZTV7S2489C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C8[];
extern Class_Descriptor cd_S2489C18;
extern VTBL_ENTRY _ZTI8S2489C18[];
extern  VTBL_ENTRY _ZTV8S2489C18[];
static Base_Class bases_S2489C24[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C3,    ABISELECT(640,348), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S2489C6,    ABISELECT(256,144), //bcp->offset
    15, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C3,    ABISELECT(53360,29748), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2489C6,    ABISELECT(52976,29544), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    24, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2489C5,    ABISELECT(52976,29544), //bcp->offset
    38, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    23, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S2489C8,    ABISELECT(54536,30412), //bcp->offset
    47, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    25, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S2489C3,    ABISELECT(784,424), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S2489C10,    ABISELECT(768,420), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S2489C9,    ABISELECT(768,420), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S2489C13,    ABISELECT(54656,30496), //bcp->offset
    56, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    10, //immediately_derived
  0, 1},
  {&cd_S2489C20,    ABISELECT(768,420), //bcp->offset
    22, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C8,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    4, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2489C18,    ABISELECT(128,84), //bcp->offset
    11, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S2489C24[];
extern void _ZN8S2489C24D1Ev();
extern void _ZN8S2489C24D0Ev();
extern void _ZN7S2489C82v4Ev();
extern void ABISELECT(_ZThn128_N8S2489C24D1Ev,_ZThn84_N8S2489C24D1Ev)();
extern void ABISELECT(_ZThn128_N8S2489C24D0Ev,_ZThn84_N8S2489C24D0Ev)();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void ABISELECT(_ZTv0_n64_N8S2489C24D1Ev,_ZTv0_n32_N8S2489C24D1Ev)();
extern void ABISELECT(_ZThn768_N8S2489C24D1Ev,_ZThn420_N8S2489C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S2489C24D0Ev,_ZTv0_n32_N8S2489C24D0Ev)();
extern void ABISELECT(_ZThn768_N8S2489C24D0Ev,_ZThn420_N8S2489C24D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S2489C24D1Ev,_ZTv0_n20_N8S2489C24D1Ev)();
extern void ABISELECT(_ZThn54536_N8S2489C24D1Ev,_ZThn30412_N8S2489C24D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C24D0Ev,_ZTv0_n20_N8S2489C24D0Ev)();
extern void ABISELECT(_ZThn54536_N8S2489C24D0Ev,_ZThn30412_N8S2489C24D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
extern void _ZN8S2489C133v11Ev();
static  VTBL_ENTRY vtc_S2489C24[] = {
  ABISELECT(54656,30496),
  ABISELECT(54536,30412),
  ABISELECT(52976,29544),
  ABISELECT(768,420),
  ABISELECT(256,144),
  ABISELECT(640,348),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C24[0]),
  (VTBL_ENTRY)&_ZN8S2489C24D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C24D0Ev,
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
  ABISELECT(-128,-84),
  (VTBL_ENTRY)&(_ZTI8S2489C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N8S2489C24D1Ev,_ZThn84_N8S2489C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn128_N8S2489C24D0Ev,_ZThn84_N8S2489C24D0Ev),
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(-256,-144),
  (VTBL_ENTRY)&(_ZTI8S2489C24[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  0,
  0,
  0,
  ABISELECT(-768,-420),
  ABISELECT(53888,30076),
  ABISELECT(52208,29124),
  ABISELECT(53768,29992),
  ABISELECT(-128,-72),
  ABISELECT(-512,-276),
  ABISELECT(-768,-420),
  (VTBL_ENTRY)&(_ZTI8S2489C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C24D1Ev,_ZTv0_n32_N8S2489C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C24D0Ev,_ZTv0_n32_N8S2489C24D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
  0,
  0,
  0,
  ABISELECT(-52336,-29196),
  ABISELECT(-52976,-29544),
  (VTBL_ENTRY)&(_ZTI8S2489C24[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
  0,
  ABISELECT(-54536,-30412),
  ABISELECT(-54280,-30268),
  ABISELECT(-53896,-30064),
  ABISELECT(-54536,-30412),
  (VTBL_ENTRY)&(_ZTI8S2489C24[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C24D1Ev,_ZTv0_n20_N8S2489C24D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C24D0Ev,_ZTv0_n20_N8S2489C24D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
  0,
  ABISELECT(-54656,-30496),
  (VTBL_ENTRY)&(_ZTI8S2489C24[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
};
extern VTBL_ENTRY _ZTV8S2489C24[];
extern void _ZN7S2489C8D1Ev();
extern void _ZN7S2489C8D0Ev();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__A__8S2489C24[] = {
  ABISELECT(256,144),
  ABISELECT(640,348),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C8__A__8S2489C24[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(-256,-144),
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C24[] = {
  ABISELECT(384,204),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C20D1Ev();
extern void _ZN8S2489C20D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C20__8S2489C24[] = {
  ABISELECT(53888,30076),
  ABISELECT(52208,29124),
  ABISELECT(53768,29992),
  ABISELECT(-128,-72),
  ABISELECT(-512,-276),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN8S2489C20D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C20D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN7S2489C9D1Ev();
extern void _ZN7S2489C9D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C98S2489C20__8S2489C24[] = {
  ABISELECT(52208,29124),
  ABISELECT(53768,29992),
  ABISELECT(-128,-72),
  ABISELECT(-512,-276),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C107S2489C98S2489C20__8S2489C24[] = {
  ABISELECT(52208,29124),
  ABISELECT(53768,29992),
  ABISELECT(-128,-72),
  ABISELECT(-512,-276),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C107S2489C98S2489C20__8S2489C24[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(512,276),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZThn53768_N8S2489C10D1Ev,_ZThn29992_N8S2489C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void ABISELECT(_ZThn53768_N8S2489C10D0Ev,_ZThn29992_N8S2489C10D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C107S2489C98S2489C20__8S2489C24[] = {
  0,
  ABISELECT(-53768,-29992),
  ABISELECT(-54280,-30268),
  ABISELECT(-53896,-30064),
  ABISELECT(-53768,-29992),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C107S2489C98S2489C20__8S2489C24[] = {
  0,
  0,
  0,
  ABISELECT(-52336,-29196),
  ABISELECT(-52208,-29124),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C98S2489C20__8S2489C24[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(512,276),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev)();
extern void ABISELECT(_ZThn53768_N7S2489C9D1Ev,_ZThn29992_N7S2489C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev)();
extern void ABISELECT(_ZThn53768_N7S2489C9D0Ev,_ZThn29992_N7S2489C9D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__7S2489C98S2489C20__8S2489C24[] = {
  0,
  ABISELECT(-53768,-29992),
  ABISELECT(-54280,-30268),
  ABISELECT(-53896,-30064),
  ABISELECT(-53768,-29992),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__7S2489C98S2489C20__8S2489C24[] = {
  0,
  0,
  0,
  ABISELECT(-52336,-29196),
  ABISELECT(-52208,-29124),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C20__8S2489C24[] = {
  0,
  0,
  0,
  ABISELECT(-52336,-29196),
  ABISELECT(-52208,-29124),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A1__8S2489C20__8S2489C24[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(512,276),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C20D1Ev,_ZTv0_n20_N8S2489C20D1Ev)();
extern void ABISELECT(_ZThn53768_N8S2489C20D1Ev,_ZThn29992_N8S2489C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C20D0Ev,_ZTv0_n20_N8S2489C20D0Ev)();
extern void ABISELECT(_ZThn53768_N8S2489C20D0Ev,_ZThn29992_N8S2489C20D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C20__8S2489C24[] = {
  0,
  ABISELECT(-53768,-29992),
  ABISELECT(-54280,-30268),
  ABISELECT(-53896,-30064),
  ABISELECT(-53768,-29992),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C20D1Ev,_ZTv0_n20_N8S2489C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C20D0Ev,_ZTv0_n20_N8S2489C20D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN8S2489C133v11Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C13__8S2489C20__8S2489C24[] = {
  0,
  ABISELECT(-53888,-30076),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C24[] = {
  ABISELECT(-52336,-29196),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C5[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C67S2489C5__A1__8S2489C24[] = {
  ABISELECT(-52336,-29196),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C8D1Ev();
extern void _ZN7S2489C8D0Ev();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C24[] = {
  ABISELECT(-54280,-30268),
  ABISELECT(-53896,-30064),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C8__8S2489C24[] = {
  0,
  0,
  ABISELECT(384,204),
  ABISELECT(54280,30268),
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
static  VTT_ENTRY vtt_S2489C24[] = {
  {&(_ZTV8S2489C24[8]),  8,60},
  {&(_tg__ZTV7S2489C8__A__8S2489C24[4]),  4,7},
  {&(_tg__ZTV7S2489C6__7S2489C8__A__8S2489C24[5]),  5,7},
  {&(_ZTV8S2489C24[20]),  20,60},
  {&(_ZTV8S2489C24[33]),  33,60},
  {&(_ZTV8S2489C24[44]),  44,60},
  {&(_ZTV8S2489C24[53]),  53,60},
  {&(_ZTV8S2489C24[59]),  59,60},
  {&(_tg__ZTV7S2489C6__8S2489C24[3]),  3,5},
  {&(_tg__ZTV8S2489C20__8S2489C24[7]),  7,12},
  {&(_tg__ZTV7S2489C98S2489C20__8S2489C24[6]),  6,11},
  {&(_tg__ZTV8S2489C107S2489C98S2489C20__8S2489C24[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C107S2489C98S2489C20__8S2489C24[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C107S2489C98S2489C20__8S2489C24[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C107S2489C98S2489C20__8S2489C24[6]),  6,9},
  {&(_tg__ZTV7S2489C6__7S2489C98S2489C20__8S2489C24[5]),  5,7},
  {&(_tg__ZTV7S2489C8__7S2489C98S2489C20__8S2489C24[6]),  6,9},
  {&(_tg__ZTV7S2489C5__7S2489C98S2489C20__8S2489C24[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C20__8S2489C24[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A1__8S2489C20__8S2489C24[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C20__8S2489C24[6]),  6,9},
  {&(_tg__ZTV8S2489C13__8S2489C20__8S2489C24[3]),  3,4},
  {&(_tg__ZTV7S2489C5__8S2489C24[3]),  3,6},
  {&(_tg__ZTV7S2489C67S2489C5__A1__8S2489C24[3]),  3,5},
  {&(_tg__ZTV7S2489C8__8S2489C24[4]),  4,7},
  {&(_tg__ZTV7S2489C6__7S2489C8__8S2489C24[5]),  5,7},
};
extern VTBL_ENTRY _ZTI8S2489C24[];
extern  VTBL_ENTRY _ZTV8S2489C24[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C24[];
static VTBL_ENTRY alt_thunk_names13[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C20D0Ev,_ZTv0_n20_N8S2489C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn53768_N8S2489C20D0Ev,_ZThn29992_N8S2489C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C20D1Ev,_ZTv0_n20_N8S2489C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn53768_N8S2489C20D1Ev,_ZThn29992_N8S2489C20D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn53768_N7S2489C9D0Ev,_ZThn29992_N7S2489C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn53768_N7S2489C9D1Ev,_ZThn29992_N7S2489C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn53768_N8S2489C10D0Ev,_ZThn29992_N8S2489C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn53768_N8S2489C10D1Ev,_ZThn29992_N8S2489C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C24D0Ev,_ZTv0_n20_N8S2489C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn54536_N8S2489C24D0Ev,_ZThn30412_N8S2489C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C24D1Ev,_ZTv0_n20_N8S2489C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn54536_N8S2489C24D1Ev,_ZThn30412_N8S2489C24D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C24D0Ev,_ZTv0_n32_N8S2489C24D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn768_N8S2489C24D0Ev,_ZThn420_N8S2489C24D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C24D1Ev,_ZTv0_n32_N8S2489C24D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn768_N8S2489C24D1Ev,_ZThn420_N8S2489C24D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S2489C24 = {  "S2489C24", // class name
  bases_S2489C24, 13,
  &(vtc_S2489C24[0]), // expected_vtbl_contents
  &(vtt_S2489C24[0]), // expected_vtt_contents
  ABISELECT(68624,38212), // object size
  NSPAIRA(_ZTI8S2489C24),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S2489C24),60, //virtual function table var
  8, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S2489C24),26, //virtual table table var
  10, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names13,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2489C1  : S2489C2 , virtual S2489C13 , virtual S2489C15 {
  ::S2489C24 s2489c1f0;
  __tsi64 s2489c1f1;
  virtual  ~S2489C1(); // _ZN7S2489C1D2Ev
  S2489C1(); // tgen
};
//SIG(1 S2489C1) C1{ BC2{ BC3{ m Fc Fi FL FU4{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} VBC5{ BC3 BC6{ VBC3 v1 v2 Fp Fp Fi Fi FU7{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU7 Fp FL:3 FC3 FL FU7} v3 Fp FD FC3[7] FD FU4 Fs FL FL} VBC8{ VBC3 VBC6 vd v4 FL FL FL FL Fi FU7 Fc[10] Fi} BC9{ BC10{ BC3 VBC6 VBC8 VBC5 vd v5 Fc Fi[7] Fl[5] FL FL FL FU11{ m Fp Fi Fp Fc Fc FL[5] Fp Fp Fp}} vd v6 v7 Fp Fp Fp Fi FC12{} FL FL} vd FD} VBC13{ v8 FD FC14{ VBC5 VBC8 Fi Fp Fi FU7}[6] Fc Fp Fp Fi[6] Fi Fp FL Fp Fi Fp Fp} VBC15{ BC14 BC16{ VBC17{ BC18{ vd m FU4} BC19{ VBC8 BC10 BC3 BC6 vd v9 v10 v11 FU7 Fi Fl Fc Fp FC5 Fs} VBC20{ VBC5 VBC6 VBC8 BC9 VBC13 vd Fc Fs[3] FC21{ BC3 VBC6 VBC8 VBC5 VBC19 vd FL Fi Fp Fp FL}[10] FC5 FL FL:5 Fi Fp[6] FL[2] FL Fi} BC21 vd v12 v13 Fi FD Fl Fc:3 Fp FC6} Fc Fp FL Fi Fi Fi Fp FL FC2 FD FL Fi} BC22{ VBC23{ VBC10 VBC13 BC17 vd Fp[6] Fi Fs FC12 FC2 Fp Fi Fi Fc Fc FU4} BC5 v14 v15 FL Fs FL:0 Fp Fp FD[10] Fi Fp Fp Fi Fl Fp} BC21 vd FU4 Fi Fi FL Fi Fp Fi Fi Fi} vd FC24{ VBC6 VBC20 BC8 BC18 vd Fp Fp Fi Fp} FL}


 S2489C1 ::~S2489C1(){ note_dtor("S2489C1", this);}
S2489C1 ::S2489C1(){ note_ctor("S2489C1", this);} // tgen

static void Test_S2489C1()
{
  extern Class_Descriptor cd_S2489C1;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(9700,21640)];
    init_test(&cd_S2489C1, buf);
    S2489C1 *dp, &lv = *(dp=new (buf) S2489C1());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(155184,86556), "sizeof(S2489C1)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2489C1)");
    /*is_ambiguous_... S2489C2::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C2*), ABISELECT(336,228), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C5 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C5*), ABISELECT(69504,38736), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C5 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C5*), ABISELECT(70688,39400), "S2489C1");
    check_base_class_offset(lv, (S2489C3*)(S2489C8*), ABISELECT(70688,39400), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*), ABISELECT(70688,39400), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C19*)(S2489C17*), ABISELECT(70688,39400), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C19*), ABISELECT(70688,39400), "S2489C1");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(70688,39400), "S2489C1");
    /*is_ambiguous_... S2489C22::S2489C5 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C6*)(S2489C5*)(S2489C22*)(S2489C15*), ABISELECT(70688,39400), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C5 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C5*), ABISELECT(69120,38532), "S2489C1");
    check_base_class_offset(lv, (S2489C5*)(S2489C2*), ABISELECT(69120,38532), "S2489C1");
    check_base_class_offset(lv, (S2489C5*)(S2489C10*)(S2489C9*)(S2489C2*), ABISELECT(69120,38532), "S2489C1");
    check_base_class_offset(lv, (S2489C5*)(S2489C14*)(S2489C15*), ABISELECT(69120,38532), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C5*)(S2489C10*)(S2489C19*)(S2489C17*), ABISELECT(69120,38532), "S2489C1");
    check_base_class_offset(lv, (S2489C5*)(S2489C20*), ABISELECT(69120,38532), "S2489C1");
    check_base_class_offset(lv, (S2489C5*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(69120,38532), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C5*)(S2489C21*)(S2489C17*), ABISELECT(69120,38532), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C5*)(S2489C10*)(S2489C19*), ABISELECT(69120,38532), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C10 */ AMB_check_base_class_offset(lv, (S2489C5*)(S2489C10*), ABISELECT(69120,38532), "S2489C1");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C5*)(S2489C10*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(69120,38532), "S2489C1");
    check_base_class_offset(lv, (S2489C5*)(S2489C21*)(S2489C17*)(S2489C23*), ABISELECT(69120,38532), "S2489C1");
    /*is_ambiguous_... S2489C15::S2489C21 */ AMB_check_base_class_offset(lv, (S2489C5*)(S2489C21*)(S2489C15*), ABISELECT(69120,38532), "S2489C1");
    check_base_class_offset(lv, (S2489C6*)(S2489C8*), ABISELECT(70944,39556), "S2489C1");
    /*is_ambiguous_... S2489C10::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*)(S2489C9*)(S2489C2*), ABISELECT(70944,39556), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*)(S2489C19*)(S2489C17*), ABISELECT(70944,39556), "S2489C1");
    /*is_ambiguous_... S2489C20::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C20*), ABISELECT(70944,39556), "S2489C1");
    /*is_ambiguous_... S2489C10::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(70944,39556), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C21*)(S2489C17*), ABISELECT(70944,39556), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*)(S2489C19*), ABISELECT(70944,39556), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C10 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*), ABISELECT(70944,39556), "S2489C1");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C10*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(70944,39556), "S2489C1");
    /*is_ambiguous_... S2489C21::S2489C6 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C21*)(S2489C17*)(S2489C23*), ABISELECT(70944,39556), "S2489C1");
    /*is_ambiguous_... S2489C15::S2489C21 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C21*)(S2489C15*), ABISELECT(70944,39556), "S2489C1");
    check_base_class_offset(lv, (S2489C8*)(S2489C2*), ABISELECT(70816,39472), "S2489C1");
    check_base_class_offset(lv, (S2489C8*)(S2489C10*)(S2489C9*)(S2489C2*), ABISELECT(70816,39472), "S2489C1");
    check_base_class_offset(lv, (S2489C8*)(S2489C14*)(S2489C15*), ABISELECT(70816,39472), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C19*)(S2489C17*), ABISELECT(70816,39472), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C10*)(S2489C19*)(S2489C17*), ABISELECT(70816,39472), "S2489C1");
    check_base_class_offset(lv, (S2489C8*)(S2489C20*), ABISELECT(70816,39472), "S2489C1");
    check_base_class_offset(lv, (S2489C8*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(70816,39472), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C21*)(S2489C17*), ABISELECT(70816,39472), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C19*), ABISELECT(70816,39472), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C10*)(S2489C19*), ABISELECT(70816,39472), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C10 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C10*), ABISELECT(70816,39472), "S2489C1");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(70816,39472), "S2489C1");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C10*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(70816,39472), "S2489C1");
    check_base_class_offset(lv, (S2489C8*)(S2489C21*)(S2489C17*)(S2489C23*), ABISELECT(70816,39472), "S2489C1");
    /*is_ambiguous_... S2489C15::S2489C21 */ AMB_check_base_class_offset(lv, (S2489C8*)(S2489C21*)(S2489C15*), ABISELECT(70816,39472), "S2489C1");
    /*is_ambiguous_... S2489C10::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*)(S2489C9*)(S2489C2*), ABISELECT(16,4), "S2489C1");
    check_base_class_offset(lv, (S2489C10*)(S2489C9*)(S2489C2*), 0, "S2489C1");
    check_base_class_offset(lv, (S2489C9*)(S2489C2*), 0, "S2489C1");
    check_base_class_offset(lv, (S2489C2*), 0, "S2489C1");
    check_base_class_offset(lv, (S2489C13*), ABISELECT(71328,39760), "S2489C1");
    check_base_class_offset(lv, (S2489C13*)(S2489C20*), ABISELECT(71328,39760), "S2489C1");
    check_base_class_offset(lv, (S2489C13*)(S2489C23*), ABISELECT(71328,39760), "S2489C1");
    check_base_class_offset(lv, (S2489C14*)(S2489C15*), ABISELECT(85296,47476), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C18*)(S2489C17*), ABISELECT(90304,50340), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*)(S2489C19*)(S2489C17*), ABISELECT(90416,50388), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C10*)(S2489C19*)(S2489C17*), ABISELECT(90400,50384), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C19*)(S2489C17*), ABISELECT(90688,50576), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C19*)(S2489C17*), ABISELECT(90816,50648), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C19*)(S2489C17*), ABISELECT(90400,50384), "S2489C1");
    /*is_ambiguous_... S2489C10::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(93776,52252), "S2489C1");
    check_base_class_offset(lv, (S2489C10*)(S2489C9*)(S2489C20*), ABISELECT(93760,52248), "S2489C1");
    check_base_class_offset(lv, (S2489C9*)(S2489C20*), ABISELECT(93760,52248), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C20*)(S2489C17*), ABISELECT(93760,52248), "S2489C1");
    check_base_class_offset(lv, (S2489C20*)(S2489C17*)(S2489C23*), ABISELECT(93760,52248), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C21*)(S2489C17*), ABISELECT(93024,51844), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*)(S2489C19*), ABISELECT(145984,81376), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C10*)(S2489C19*), ABISELECT(145968,81372), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C19*), ABISELECT(146256,81564), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C19*), ABISELECT(146384,81636), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C19*)(S2489C21*)(S2489C17*), ABISELECT(145968,81372), "S2489C1");
    check_base_class_offset(lv, (S2489C19*)(S2489C21*)(S2489C17*)(S2489C23*), ABISELECT(145968,81372), "S2489C1");
    /*is_ambiguous_... S2489C15::S2489C21 */ AMB_check_base_class_offset(lv, (S2489C19*)(S2489C21*)(S2489C15*), ABISELECT(145968,81372), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C17 */ AMB_check_base_class_offset(lv, (S2489C21*)(S2489C17*), ABISELECT(93008,51840), "S2489C1");
    check_base_class_offset(lv, (S2489C17*)(S2489C16*)(S2489C15*), ABISELECT(90304,50340), "S2489C1");
    check_base_class_offset(lv, (S2489C16*)(S2489C15*), ABISELECT(85392,47520), "S2489C1");
    /*is_ambiguous_... S2489C1::S2489C10 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*), ABISELECT(154912,86368), "S2489C1");
    /*is_ambiguous_... S2489C23::S2489C10 */ AMB_check_base_class_offset(lv, (S2489C10*)(S2489C23*), ABISELECT(154896,86364), "S2489C1");
    check_base_class_offset(lv, (S2489C18*)(S2489C17*)(S2489C23*), ABISELECT(148576,82828), "S2489C1");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C10*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(148688,82876), "S2489C1");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C10*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(148672,82872), "S2489C1");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(148960,83064), "S2489C1");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(149088,83136), "S2489C1");
    /*is_ambiguous_... S2489C17::S2489C19 */ AMB_check_base_class_offset(lv, (S2489C19*)(S2489C17*)(S2489C23*), ABISELECT(148672,82872), "S2489C1");
    /*is_ambiguous_... S2489C21::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C21*)(S2489C17*)(S2489C23*), ABISELECT(151296,84332), "S2489C1");
    check_base_class_offset(lv, (S2489C21*)(S2489C17*)(S2489C23*), ABISELECT(151280,84328), "S2489C1");
    check_base_class_offset(lv, (S2489C17*)(S2489C23*), ABISELECT(148576,82828), "S2489C1");
    check_base_class_offset(lv, (S2489C23*)(S2489C22*)(S2489C15*), ABISELECT(148576,82828), "S2489C1");
    /*is_ambiguous_... S2489C22::S2489C5 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C5*)(S2489C22*)(S2489C15*), ABISELECT(88560,49332), "S2489C1");
    /*is_ambiguous_... S2489C22::S2489C5 */ AMB_check_base_class_offset(lv, (S2489C6*)(S2489C5*)(S2489C22*)(S2489C15*), ABISELECT(88176,49128), "S2489C1");
    /*is_ambiguous_... S2489C22::S2489C5 */ AMB_check_base_class_offset(lv, (S2489C5*)(S2489C22*)(S2489C15*), ABISELECT(88176,49128), "S2489C1");
    check_base_class_offset(lv, (S2489C22*)(S2489C15*), ABISELECT(88176,49128), "S2489C1");
    /*is_ambiguous_... S2489C15::S2489C21 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2489C21*)(S2489C15*), ABISELECT(90000,50164), "S2489C1");
    /*is_ambiguous_... S2489C15::S2489C21 */ AMB_check_base_class_offset(lv, (S2489C21*)(S2489C15*), ABISELECT(89984,50160), "S2489C1");
    check_base_class_offset(lv, (S2489C15*), ABISELECT(85296,47476), "S2489C1");
    check_field_offset(lv, s2489c1f0, ABISELECT(480,312), "S2489C1.s2489c1f0");
    check_field_offset(lv, s2489c1f1, ABISELECT(69104,38524), "S2489C1.s2489c1f1");
    test_class_info(&lv, &cd_S2489C1);
    dp->~S2489C1();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2489C1(Test_S2489C1, "S2489C1", ABISELECT(155184,86556));

#else // __cplusplus

extern void _ZN7S2489C1C1Ev();
extern void _ZN7S2489C1D2Ev();
Name_Map name_map_S2489C1[] = {
  NSPAIR(_ZN7S2489C1C1Ev),
  NSPAIR(_ZN7S2489C1D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C5;
extern VTBL_ENTRY _ZTI7S2489C5[];
extern  VTBL_ENTRY _ZTV7S2489C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C5[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C8;
extern VTBL_ENTRY _ZTI7S2489C8[];
extern  VTBL_ENTRY _ZTV7S2489C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C8[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C9;
extern VTBL_ENTRY _ZTI7S2489C9[];
extern  VTBL_ENTRY _ZTV7S2489C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C9[];
extern Class_Descriptor cd_S2489C2;
extern VTBL_ENTRY _ZTI7S2489C2[];
extern  VTBL_ENTRY _ZTV7S2489C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C2[];
extern Class_Descriptor cd_S2489C13;
extern VTBL_ENTRY _ZTI8S2489C13[];
extern  VTBL_ENTRY _ZTV8S2489C13[];
extern Class_Descriptor cd_S2489C14;
extern VTBL_ENTRY _ZTI8S2489C14[];
extern  VTBL_ENTRY _ZTV8S2489C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C14[];
extern Class_Descriptor cd_S2489C18;
extern VTBL_ENTRY _ZTI8S2489C18[];
extern  VTBL_ENTRY _ZTV8S2489C18[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C19;
extern VTBL_ENTRY _ZTI8S2489C19[];
extern  VTBL_ENTRY _ZTV8S2489C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C19[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C9;
extern VTBL_ENTRY _ZTI7S2489C9[];
extern  VTBL_ENTRY _ZTV7S2489C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C9[];
extern Class_Descriptor cd_S2489C20;
extern VTBL_ENTRY _ZTI8S2489C20[];
extern  VTBL_ENTRY _ZTV8S2489C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C20[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C19;
extern VTBL_ENTRY _ZTI8S2489C19[];
extern  VTBL_ENTRY _ZTV8S2489C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C19[];
extern Class_Descriptor cd_S2489C21;
extern VTBL_ENTRY _ZTI8S2489C21[];
extern  VTBL_ENTRY _ZTV8S2489C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C21[];
extern Class_Descriptor cd_S2489C17;
extern VTBL_ENTRY _ZTI8S2489C17[];
extern  VTBL_ENTRY _ZTV8S2489C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C17[];
extern Class_Descriptor cd_S2489C16;
extern VTBL_ENTRY _ZTI8S2489C16[];
extern  VTBL_ENTRY _ZTV8S2489C16[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C16[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C18;
extern VTBL_ENTRY _ZTI8S2489C18[];
extern  VTBL_ENTRY _ZTV8S2489C18[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C10;
extern VTBL_ENTRY _ZTI8S2489C10[];
extern  VTBL_ENTRY _ZTV8S2489C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C10[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C19;
extern VTBL_ENTRY _ZTI8S2489C19[];
extern  VTBL_ENTRY _ZTV8S2489C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C19[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C21;
extern VTBL_ENTRY _ZTI8S2489C21[];
extern  VTBL_ENTRY _ZTV8S2489C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C21[];
extern Class_Descriptor cd_S2489C17;
extern VTBL_ENTRY _ZTI8S2489C17[];
extern  VTBL_ENTRY _ZTV8S2489C17[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C17[];
extern Class_Descriptor cd_S2489C23;
extern VTBL_ENTRY _ZTI8S2489C23[];
extern  VTBL_ENTRY _ZTV8S2489C23[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C23[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C6;
extern VTBL_ENTRY _ZTI7S2489C6[];
extern  VTBL_ENTRY _ZTV7S2489C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C6[];
extern Class_Descriptor cd_S2489C5;
extern VTBL_ENTRY _ZTI7S2489C5[];
extern  VTBL_ENTRY _ZTV7S2489C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C5[];
extern Class_Descriptor cd_S2489C22;
extern VTBL_ENTRY _ZTI8S2489C22[];
extern  VTBL_ENTRY _ZTV8S2489C22[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C22[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C21;
extern VTBL_ENTRY _ZTI8S2489C21[];
extern  VTBL_ENTRY _ZTV8S2489C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C21[];
extern Class_Descriptor cd_S2489C15;
extern VTBL_ENTRY _ZTI8S2489C15[];
extern  VTBL_ENTRY _ZTV8S2489C15[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2489C15[];
static Base_Class bases_S2489C1[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C3,    ABISELECT(336,228), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(69504,38736), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(70688,39400), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S2489C6,    ABISELECT(69120,38532), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2489C5,    ABISELECT(69120,38532), //bcp->offset
    18, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    14, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S2489C6,    ABISELECT(70944,39556), //bcp->offset
    36, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    16, //bcp->index_in_construction_vtbl_array
    38, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S2489C8,    ABISELECT(70816,39472), //bcp->offset
    27, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    15, //bcp->index_in_construction_vtbl_array
    36, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S2489C3,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S2489C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    4, //bcp->base_subarray_index_in_construction_vtbl_array
    33, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S2489C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    34, //init_seq
    10, //immediately_derived
  0, 0},
  {&cd_S2489C2,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    35, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2489C13,    ABISELECT(71328,39760), //bcp->offset
    43, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    17, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C14,    ABISELECT(85296,47476), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    40, //bcp->base_subarray_index_in_construction_vtbl_array
    26, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S2489C18,    ABISELECT(90304,50340), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(90416,50388), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    15, //immediately_derived
  0, 0},
  {&cd_S2489C10,    ABISELECT(90400,50384), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    98, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(90688,50576), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S2489C6,    ABISELECT(90816,50648), //bcp->offset
    140, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    102, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    18, //immediately_derived
  0, 0},
  {&cd_S2489C19,    ABISELECT(90400,50384), //bcp->offset
    128, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    97, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(93776,52252), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    20, //immediately_derived
  0, 0},
  {&cd_S2489C10,    ABISELECT(93760,52248), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    125, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    21, //immediately_derived
  0, 0},
  {&cd_S2489C9,    ABISELECT(93760,52248), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    124, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S2489C20,    ABISELECT(93760,52248), //bcp->offset
    154, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    123, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    30, //immediately_derived
  0, 1},
  {&cd_S2489C3,    ABISELECT(93024,51844), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    29, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(145984,81376), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    25, //immediately_derived
  0, 0},
  {&cd_S2489C10,    ABISELECT(145968,81372), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    137, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(146256,81564), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S2489C6,    ABISELECT(146384,81636), //bcp->offset
    189, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    141, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    28, //immediately_derived
  0, 0},
  {&cd_S2489C19,    ABISELECT(145968,81372), //bcp->offset
    170, //bcp->virtual_function_table_offset
    13, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    136, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    29, //immediately_derived
  0, 1},
  {&cd_S2489C21,    ABISELECT(93008,51840), //bcp->offset
    145, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    107, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    30, //immediately_derived
  0, 0},
  {&cd_S2489C17,    ABISELECT(90304,50340), //bcp->offset
    106, //bcp->virtual_function_table_offset
    18, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    96, //bcp->base_subarray_index_in_construction_vtbl_array
    17, //init_seq
    31, //immediately_derived
  0, 1},
  {&cd_S2489C16,    ABISELECT(85392,47520), //bcp->offset
    67, //bcp->virtual_function_table_offset
    10, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    44, //bcp->base_subarray_index_in_construction_vtbl_array
    27, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(154912,86368), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    33, //immediately_derived
  0, 0},
  {&cd_S2489C10,    ABISELECT(154896,86364), //bcp->offset
    243, //bcp->virtual_function_table_offset
    8, //num_negative_vtable_entries(t, bcp)
    29, //bcp->index_in_construction_vtbl_array
    185, //bcp->base_subarray_index_in_construction_vtbl_array
    18, //init_seq
    43, //immediately_derived
  0, 1},
  {&cd_S2489C18,    ABISELECT(148576,82828), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    19, //init_seq
    42, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(148688,82876), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    36, //immediately_derived
  0, 0},
  {&cd_S2489C10,    ABISELECT(148672,82872), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    149, //bcp->base_subarray_index_in_construction_vtbl_array
    20, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(148960,83064), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S2489C6,    ABISELECT(149088,83136), //bcp->offset
    229, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    31, //bcp->index_in_construction_vtbl_array
    153, //bcp->base_subarray_index_in_construction_vtbl_array
    21, //init_seq
    39, //immediately_derived
  0, 0},
  {&cd_S2489C19,    ABISELECT(148672,82872), //bcp->offset
    217, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    30, //bcp->index_in_construction_vtbl_array
    148, //bcp->base_subarray_index_in_construction_vtbl_array
    22, //init_seq
    42, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(151296,84332), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    41, //immediately_derived
  0, 0},
  {&cd_S2489C21,    ABISELECT(151280,84328), //bcp->offset
    234, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    32, //bcp->index_in_construction_vtbl_array
    158, //bcp->base_subarray_index_in_construction_vtbl_array
    23, //init_seq
    42, //immediately_derived
  0, 0},
  {&cd_S2489C17,    ABISELECT(148576,82828), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    9, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    147, //bcp->base_subarray_index_in_construction_vtbl_array
    24, //init_seq
    43, //immediately_derived
  0, 0},
  {&cd_S2489C23,    ABISELECT(148576,82828), //bcp->offset
    194, //bcp->virtual_function_table_offset
    19, //num_negative_vtable_entries(t, bcp)
    28, //bcp->index_in_construction_vtbl_array
    146, //bcp->base_subarray_index_in_construction_vtbl_array
    25, //init_seq
    47, //immediately_derived
  0, 1},
  {&cd_S2489C3,    ABISELECT(88560,49332), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    46, //immediately_derived
  0, 0},
  {&cd_S2489C6,    ABISELECT(88176,49128), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    58, //bcp->base_subarray_index_in_construction_vtbl_array
    28, //init_seq
    46, //immediately_derived
  0, 0},
  {&cd_S2489C5,    ABISELECT(88176,49128), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    57, //bcp->base_subarray_index_in_construction_vtbl_array
    29, //init_seq
    47, //immediately_derived
  0, 0},
  {&cd_S2489C22,    ABISELECT(88176,49128), //bcp->offset
    79, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    56, //bcp->base_subarray_index_in_construction_vtbl_array
    30, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(90000,50164), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    49, //immediately_derived
  0, 0},
  {&cd_S2489C21,    ABISELECT(89984,50160), //bcp->offset
    97, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    33, //bcp->index_in_construction_vtbl_array
    71, //bcp->base_subarray_index_in_construction_vtbl_array
    31, //init_seq
    50, //immediately_derived
  0, 0},
  {&cd_S2489C15,    ABISELECT(85296,47476), //bcp->offset
    47, //bcp->virtual_function_table_offset
    18, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    39, //bcp->base_subarray_index_in_construction_vtbl_array
    32, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S2489C1[];
extern void _ZN7S2489C1D1Ev();
extern void _ZN7S2489C1D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
extern void ABISELECT(_ZTv0_n40_N7S2489C1D1Ev,_ZTv0_n20_N7S2489C1D1Ev)();
extern void ABISELECT(_ZThn70816_N7S2489C1D1Ev,_ZThn39472_N7S2489C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S2489C1D0Ev,_ZTv0_n20_N7S2489C1D0Ev)();
extern void ABISELECT(_ZThn70816_N7S2489C1D0Ev,_ZThn39472_N7S2489C1D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN8S2489C133v11Ev();
extern void ABISELECT(_ZTv0_n104_N7S2489C1D1Ev,_ZTv0_n52_N7S2489C1D1Ev)();
extern void ABISELECT(_ZThn85296_N7S2489C1D1Ev,_ZThn47476_N7S2489C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n104_N7S2489C1D0Ev,_ZTv0_n52_N7S2489C1D0Ev)();
extern void ABISELECT(_ZThn85296_N7S2489C1D0Ev,_ZThn47476_N7S2489C1D0Ev)() __attribute__((weak));
extern void ABISELECT(_ZTvn96_n104_N7S2489C1D1Ev,_ZTvn44_n52_N7S2489C1D1Ev)();
extern void ABISELECT(_ZTvn96_n104_N7S2489C1D0Ev,_ZTvn44_n52_N7S2489C1D0Ev)();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
extern void _ZN8S2489C223v14Ev();
extern void _ZN8S2489C223v15Ev();
extern void ABISELECT(_ZTvn2880_n104_N7S2489C1D1Ev,_ZTvn1652_n52_N7S2489C1D1Ev)();
extern void ABISELECT(_ZTvn2880_n104_N7S2489C1D0Ev,_ZTvn1652_n52_N7S2489C1D0Ev)();
extern void ABISELECT(_ZTvn4688_n104_N7S2489C1D1Ev,_ZTvn2684_n52_N7S2489C1D1Ev)();
extern void ABISELECT(_ZTvn4688_n104_N7S2489C1D0Ev,_ZTvn2684_n52_N7S2489C1D0Ev)();
extern void ABISELECT(_ZTv0_n80_N7S2489C1D1Ev,_ZTv0_n40_N7S2489C1D1Ev)();
extern void ABISELECT(_ZThn90304_N7S2489C1D1Ev,_ZThn50340_N7S2489C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N7S2489C1D0Ev,_ZTv0_n40_N7S2489C1D0Ev)();
extern void ABISELECT(_ZThn90304_N7S2489C1D0Ev,_ZThn50340_N7S2489C1D0Ev)() __attribute__((weak));
extern void _ZN8S2489C173v12Ev();
extern void _ZN8S2489C173v13Ev();
extern void ABISELECT(_ZTvn96_n80_N7S2489C1D1Ev,_ZTvn44_n40_N7S2489C1D1Ev)();
extern void ABISELECT(_ZTvn96_n80_N7S2489C1D0Ev,_ZTvn44_n40_N7S2489C1D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void ABISELECT(_ZTvn2704_n80_N7S2489C1D1Ev,_ZTvn1500_n40_N7S2489C1D1Ev)();
extern void ABISELECT(_ZTvn2704_n80_N7S2489C1D0Ev,_ZTvn1500_n40_N7S2489C1D0Ev)();
extern void ABISELECT(_ZTv0_n64_N7S2489C1D1Ev,_ZTv0_n32_N7S2489C1D1Ev)();
extern void ABISELECT(_ZThn93760_N7S2489C1D1Ev,_ZThn52248_N7S2489C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N7S2489C1D0Ev,_ZTv0_n32_N7S2489C1D0Ev)();
extern void ABISELECT(_ZThn93760_N7S2489C1D0Ev,_ZThn52248_N7S2489C1D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
extern void ABISELECT(_ZTv0_n56_N7S2489C1D1Ev,_ZTv0_n28_N7S2489C1D1Ev)();
extern void ABISELECT(_ZThn145968_N7S2489C1D1Ev,_ZThn81372_N7S2489C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S2489C1D0Ev,_ZTv0_n28_N7S2489C1D0Ev)();
extern void ABISELECT(_ZThn145968_N7S2489C1D0Ev,_ZThn81372_N7S2489C1D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void ABISELECT(_ZTv0_n88_N7S2489C1D1Ev,_ZTv0_n44_N7S2489C1D1Ev)();
extern void ABISELECT(_ZThn148576_N7S2489C1D1Ev,_ZThn82828_N7S2489C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n88_N7S2489C1D0Ev,_ZTv0_n44_N7S2489C1D0Ev)();
extern void ABISELECT(_ZThn148576_N7S2489C1D0Ev,_ZThn82828_N7S2489C1D0Ev)() __attribute__((weak));
extern void _ZN8S2489C173v12Ev();
extern void _ZN8S2489C173v13Ev();
extern void ABISELECT(_ZTvn96_n88_N7S2489C1D1Ev,_ZTvn44_n44_N7S2489C1D1Ev)();
extern void ABISELECT(_ZTvn96_n88_N7S2489C1D0Ev,_ZTvn44_n44_N7S2489C1D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void ABISELECT(_ZTvn2704_n88_N7S2489C1D1Ev,_ZTvn1500_n44_N7S2489C1D1Ev)();
extern void ABISELECT(_ZTvn2704_n88_N7S2489C1D0Ev,_ZTvn1500_n44_N7S2489C1D0Ev)();
extern void ABISELECT(_ZTv0_n56_N7S2489C1D1Ev,_ZTv0_n28_N7S2489C1D1Ev)();
extern void ABISELECT(_ZThn154896_N7S2489C1D1Ev,_ZThn86364_N7S2489C1D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N7S2489C1D0Ev,_ZTv0_n28_N7S2489C1D0Ev)();
extern void ABISELECT(_ZThn154896_N7S2489C1D0Ev,_ZThn86364_N7S2489C1D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY vtc_S2489C1[] = {
  ABISELECT(154896,86364),
  ABISELECT(148576,82828),
  ABISELECT(145968,81372),
  ABISELECT(93760,52248),
  ABISELECT(90304,50340),
  ABISELECT(85296,47476),
  ABISELECT(71328,39760),
  ABISELECT(69120,38532),
  ABISELECT(70816,39472),
  ABISELECT(70688,39400),
  ABISELECT(70944,39556),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C1[0]),
  (VTBL_ENTRY)&_ZN7S2489C1D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C1D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(-69120,-38532),
  (VTBL_ENTRY)&(_ZTI7S2489C1[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
  0,
  ABISELECT(-70816,-39472),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(-70816,-39472),
  (VTBL_ENTRY)&(_ZTI7S2489C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C1D1Ev,_ZTv0_n20_N7S2489C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C1D0Ev,_ZTv0_n20_N7S2489C1D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-70944,-39556),
  (VTBL_ENTRY)&(_ZTI7S2489C1[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  0,
  ABISELECT(-71328,-39760),
  (VTBL_ENTRY)&(_ZTI7S2489C1[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
  ABISELECT(2880,1652),
  ABISELECT(2880,1652),
  ABISELECT(2880,1652),
  ABISELECT(2880,1652),
  ABISELECT(2880,1652),
  ABISELECT(-85296,-47476),
  ABISELECT(69600,38888),
  ABISELECT(63280,35352),
  ABISELECT(60672,33896),
  ABISELECT(-13968,-7716),
  ABISELECT(8464,4772),
  ABISELECT(5008,2864),
  ABISELECT(-14352,-7920),
  ABISELECT(-14480,-8004),
  ABISELECT(-14608,-8076),
  ABISELECT(-16176,-8944),
  ABISELECT(-85296,-47476),
  (VTBL_ENTRY)&(_ZTI7S2489C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n104_N7S2489C1D1Ev,_ZTv0_n52_N7S2489C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n104_N7S2489C1D0Ev,_ZTv0_n52_N7S2489C1D0Ev),
  ABISELECT(60576,33852),
  ABISELECT(-14064,-7760),
  ABISELECT(8368,4728),
  ABISELECT(-16272,-8988),
  ABISELECT(-14448,-7964),
  ABISELECT(-14704,-8120),
  ABISELECT(-14576,-8048),
  ABISELECT(4912,2820),
  ABISELECT(-85392,-47520),
  (VTBL_ENTRY)&(_ZTI7S2489C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n104_N7S2489C1D1Ev,_ZTvn44_n52_N7S2489C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n104_N7S2489C1D0Ev,_ZTvn44_n52_N7S2489C1D0Ev),
  ABISELECT(57792,32244),
  ABISELECT(5584,3120),
  ABISELECT(-16848,-9368),
  ABISELECT(-19056,-10596),
  ABISELECT(-17360,-9656),
  ABISELECT(-17232,-9572),
  ABISELECT(66720,37236),
  ABISELECT(60400,33700),
  ABISELECT(-17488,-9728),
  ABISELECT(-88176,-49128),
  (VTBL_ENTRY)&(_ZTI7S2489C1[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
  (VTBL_ENTRY)&_ZN8S2489C223v14Ev,
  (VTBL_ENTRY)&_ZN8S2489C223v15Ev,
  (VTBL_ENTRY)&ABISELECT(_ZTvn2880_n104_N7S2489C1D1Ev,_ZTvn1652_n52_N7S2489C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2880_n104_N7S2489C1D0Ev,_ZTvn1652_n52_N7S2489C1D0Ev),
  ABISELECT(55984,31212),
  ABISELECT(-20864,-11628),
  ABISELECT(-19168,-10688),
  ABISELECT(-19296,-10760),
  ABISELECT(-19040,-10604),
  ABISELECT(-89984,-50160),
  (VTBL_ENTRY)&(_ZTI7S2489C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn4688_n104_N7S2489C1D1Ev,_ZTvn2684_n52_N7S2489C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn4688_n104_N7S2489C1D0Ev,_ZTvn2684_n52_N7S2489C1D0Ev),
  ABISELECT(512,308),
  ABISELECT(512,308),
  ABISELECT(96,44),
  ABISELECT(96,44),
  ABISELECT(96,44),
  ABISELECT(96,44),
  0,
  0,
  ABISELECT(-90304,-50340),
  ABISELECT(55664,31032),
  ABISELECT(-18976,-10580),
  ABISELECT(3456,1908),
  ABISELECT(-21184,-11808),
  ABISELECT(-19360,-10784),
  ABISELECT(-19616,-10940),
  ABISELECT(-19488,-10868),
  ABISELECT(-90304,-50340),
  (VTBL_ENTRY)&(_ZTI7S2489C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N7S2489C1D1Ev,_ZTv0_n40_N7S2489C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N7S2489C1D0Ev,_ZTv0_n40_N7S2489C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C173v12Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v13Ev,
  ABISELECT(-21280,-11852),
  ABISELECT(-19584,-10912),
  ABISELECT(-19712,-10984),
  ABISELECT(-19456,-10828),
  ABISELECT(-90400,-50384),
  (VTBL_ENTRY)&(_ZTI7S2489C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n80_N7S2489C1D1Ev,_ZTvn44_n40_N7S2489C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n80_N7S2489C1D0Ev,_ZTvn44_n40_N7S2489C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
  ABISELECT(-20128,-11248),
  ABISELECT(-90816,-50648),
  (VTBL_ENTRY)&(_ZTI7S2489C1[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  ABISELECT(52960,29532),
  ABISELECT(-23888,-13308),
  ABISELECT(-22192,-12368),
  ABISELECT(-22320,-12440),
  ABISELECT(-22064,-12284),
  ABISELECT(-93008,-51840),
  (VTBL_ENTRY)&(_ZTI7S2489C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2704_n80_N7S2489C1D1Ev,_ZTvn1500_n40_N7S2489C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2704_n80_N7S2489C1D0Ev,_ZTvn1500_n40_N7S2489C1D0Ev),
  0,
  0,
  0,
  ABISELECT(-93760,-52248),
  ABISELECT(-22432,-12488),
  ABISELECT(-24640,-13716),
  ABISELECT(-22944,-12776),
  ABISELECT(-23072,-12848),
  ABISELECT(-22816,-12692),
  ABISELECT(-93760,-52248),
  (VTBL_ENTRY)&(_ZTI7S2489C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S2489C1D1Ev,_ZTv0_n32_N7S2489C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N7S2489C1D0Ev,_ZTv0_n32_N7S2489C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(-145968,-81372),
  ABISELECT(-76848,-42840),
  ABISELECT(-75152,-41900),
  ABISELECT(-75280,-41972),
  ABISELECT(-75024,-41816),
  ABISELECT(-145968,-81372),
  (VTBL_ENTRY)&(_ZTI7S2489C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S2489C1D1Ev,_ZTv0_n28_N7S2489C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S2489C1D0Ev,_ZTv0_n28_N7S2489C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
  ABISELECT(-75696,-42236),
  ABISELECT(-146384,-81636),
  (VTBL_ENTRY)&(_ZTI7S2489C1[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  ABISELECT(512,308),
  ABISELECT(512,308),
  ABISELECT(96,44),
  ABISELECT(96,44),
  ABISELECT(96,44),
  ABISELECT(96,44),
  0,
  0,
  ABISELECT(-148576,-82828),
  ABISELECT(6320,3536),
  ABISELECT(-2608,-1456),
  ABISELECT(-77248,-43068),
  ABISELECT(-54816,-30580),
  ABISELECT(-79456,-44296),
  ABISELECT(-77632,-43272),
  ABISELECT(-77888,-43428),
  ABISELECT(-77760,-43356),
  ABISELECT(-148576,-82828),
  (VTBL_ENTRY)&(_ZTI7S2489C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n88_N7S2489C1D1Ev,_ZTv0_n44_N7S2489C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n88_N7S2489C1D0Ev,_ZTv0_n44_N7S2489C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C173v12Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v13Ev,
  ABISELECT(-79552,-44340),
  ABISELECT(-77856,-43400),
  ABISELECT(-77984,-43472),
  ABISELECT(-77728,-43316),
  ABISELECT(-148672,-82872),
  (VTBL_ENTRY)&(_ZTI7S2489C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n88_N7S2489C1D1Ev,_ZTvn44_n44_N7S2489C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n88_N7S2489C1D0Ev,_ZTvn44_n44_N7S2489C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
  ABISELECT(-78400,-43736),
  ABISELECT(-149088,-83136),
  (VTBL_ENTRY)&(_ZTI7S2489C1[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  ABISELECT(-5312,-2956),
  ABISELECT(-82160,-45796),
  ABISELECT(-80464,-44856),
  ABISELECT(-80592,-44928),
  ABISELECT(-80336,-44772),
  ABISELECT(-151280,-84328),
  (VTBL_ENTRY)&(_ZTI7S2489C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2704_n88_N7S2489C1D1Ev,_ZTvn1500_n44_N7S2489C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2704_n88_N7S2489C1D0Ev,_ZTvn1500_n44_N7S2489C1D0Ev),
  0,
  ABISELECT(-154896,-86364),
  ABISELECT(-85776,-47832),
  ABISELECT(-84080,-46892),
  ABISELECT(-84208,-46964),
  ABISELECT(-83952,-46808),
  ABISELECT(-154896,-86364),
  (VTBL_ENTRY)&(_ZTI7S2489C1[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S2489C1D1Ev,_ZTv0_n28_N7S2489C1D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N7S2489C1D0Ev,_ZTv0_n28_N7S2489C1D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern VTBL_ENTRY _ZTV7S2489C1[];
extern void _ZN7S2489C2D1Ev();
extern void _ZN7S2489C2D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C2__7S2489C1[] = {
  ABISELECT(69120,38532),
  ABISELECT(70816,39472),
  ABISELECT(70688,39400),
  ABISELECT(70944,39556),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C2[0]),
  (VTBL_ENTRY)&_ZN7S2489C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C2D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN7S2489C9D1Ev();
extern void _ZN7S2489C9D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C97S2489C2__7S2489C1[] = {
  ABISELECT(69120,38532),
  ABISELECT(70816,39472),
  ABISELECT(70688,39400),
  ABISELECT(70944,39556),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C107S2489C97S2489C2__7S2489C1[] = {
  ABISELECT(69120,38532),
  ABISELECT(70816,39472),
  ABISELECT(70688,39400),
  ABISELECT(70944,39556),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C107S2489C97S2489C2__7S2489C1[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-70944,-39556),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZThn70816_N8S2489C10D1Ev,_ZThn39472_N8S2489C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void ABISELECT(_ZThn70816_N8S2489C10D0Ev,_ZThn39472_N8S2489C10D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C107S2489C97S2489C2__7S2489C1[] = {
  0,
  ABISELECT(-70816,-39472),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(-70816,-39472),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C107S2489C97S2489C2__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(-69120,-38532),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C97S2489C2__7S2489C1[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-70944,-39556),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev)();
extern void ABISELECT(_ZThn70816_N7S2489C9D1Ev,_ZThn39472_N7S2489C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev)();
extern void ABISELECT(_ZThn70816_N7S2489C9D0Ev,_ZThn39472_N7S2489C9D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__7S2489C97S2489C2__7S2489C1[] = {
  0,
  ABISELECT(-70816,-39472),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(-70816,-39472),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__7S2489C97S2489C2__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(-69120,-38532),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__7S2489C2__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(-69120,-38532),
  (VTBL_ENTRY)&(_ZTI7S2489C2[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S2489C2D1Ev,_ZTv0_n20_N7S2489C2D1Ev)();
extern void ABISELECT(_ZThn70816_N7S2489C2D1Ev,_ZThn39472_N7S2489C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S2489C2D0Ev,_ZTv0_n20_N7S2489C2D0Ev)();
extern void ABISELECT(_ZThn70816_N7S2489C2D0Ev,_ZThn39472_N7S2489C2D0Ev)() __attribute__((weak));
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__7S2489C2__7S2489C1[] = {
  0,
  ABISELECT(-70816,-39472),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(-70816,-39472),
  (VTBL_ENTRY)&(_ZTI7S2489C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C2D1Ev,_ZTv0_n20_N7S2489C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C2D0Ev,_ZTv0_n20_N7S2489C2D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A1__7S2489C2__7S2489C1[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-70944,-39556),
  (VTBL_ENTRY)&(_ZTI7S2489C2[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__7S2489C1[] = {
  ABISELECT(1568,868),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C5[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C67S2489C5__7S2489C1[] = {
  ABISELECT(1568,868),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C8D1Ev();
extern void _ZN7S2489C8D0Ev();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__7S2489C1[] = {
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C8__7S2489C1[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(-128,-84),
  (VTBL_ENTRY)&(_ZTI7S2489C8[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A1__7S2489C1[] = {
  ABISELECT(-256,-156),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C15D1Ev();
extern void _ZN8S2489C15D0Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C15__7S2489C1[] = {
  ABISELECT(69600,38888),
  ABISELECT(63280,35352),
  ABISELECT(60672,33896),
  ABISELECT(-13968,-7716),
  ABISELECT(8464,4772),
  ABISELECT(5008,2864),
  ABISELECT(-14352,-7920),
  ABISELECT(-14480,-8004),
  ABISELECT(-14608,-8076),
  ABISELECT(-16176,-8944),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&_ZN8S2489C15D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C15D0Ev,
};
extern void _ZN8S2489C14D1Ev();
extern void _ZN8S2489C14D0Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C148S2489C15__7S2489C1[] = {
  ABISELECT(-14352,-7920),
  ABISELECT(-14480,-8004),
  ABISELECT(-14608,-8076),
  ABISELECT(-16176,-8944),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C14[0]),
  (VTBL_ENTRY)&_ZN8S2489C14D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C14D0Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C148S2489C15__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(16176,8944),
  (VTBL_ENTRY)&(_ZTI8S2489C14[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C14D1Ev,_ZTv0_n20_N8S2489C14D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C14D0Ev,_ZTv0_n20_N8S2489C14D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C148S2489C15__7S2489C1[] = {
  0,
  ABISELECT(14480,8004),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(14480,8004),
  (VTBL_ENTRY)&(_ZTI8S2489C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C14D1Ev,_ZTv0_n20_N8S2489C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C14D0Ev,_ZTv0_n20_N8S2489C14D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A1__8S2489C148S2489C15__7S2489C1[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(14352,7920),
  (VTBL_ENTRY)&(_ZTI8S2489C14[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C16D1Ev();
extern void _ZN8S2489C16D0Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C168S2489C15__7S2489C1[] = {
  ABISELECT(60576,33852),
  ABISELECT(-14064,-7760),
  ABISELECT(8368,4728),
  ABISELECT(-16272,-8988),
  ABISELECT(-14448,-7964),
  ABISELECT(-14704,-8120),
  ABISELECT(-14576,-8048),
  ABISELECT(4912,2820),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&_ZN8S2489C16D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C16D0Ev,
};
extern void ABISELECT(_ZTv0_n80_N8S2489C16D1Ev,_ZTv0_n40_N8S2489C16D1Ev)();
extern void ABISELECT(_ZThn4912_N8S2489C16D1Ev,_ZThn2820_N8S2489C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N8S2489C16D0Ev,_ZTv0_n40_N8S2489C16D0Ev)();
extern void ABISELECT(_ZThn4912_N8S2489C16D0Ev,_ZThn2820_N8S2489C16D0Ev)() __attribute__((weak));
extern void _ZN8S2489C173v12Ev();
extern void _ZN8S2489C173v13Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C17__8S2489C168S2489C15__7S2489C1[] = {
  ABISELECT(512,308),
  ABISELECT(512,308),
  ABISELECT(96,44),
  ABISELECT(96,44),
  ABISELECT(96,44),
  ABISELECT(96,44),
  0,
  0,
  ABISELECT(-4912,-2820),
  ABISELECT(55664,31032),
  ABISELECT(-18976,-10580),
  ABISELECT(3456,1908),
  ABISELECT(-21184,-11808),
  ABISELECT(-19360,-10784),
  ABISELECT(-19616,-10940),
  ABISELECT(-19488,-10868),
  ABISELECT(-4912,-2820),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S2489C16D1Ev,_ZTv0_n40_N8S2489C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S2489C16D0Ev,_ZTv0_n40_N8S2489C16D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C173v12Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v13Ev,
};
extern void ABISELECT(_ZTvn96_n80_N8S2489C16D1Ev,_ZTvn44_n40_N8S2489C16D1Ev)();
extern void ABISELECT(_ZTvn96_n80_N8S2489C16D0Ev,_ZTvn44_n40_N8S2489C16D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C198S2489C17__8S2489C168S2489C15__7S2489C1[] = {
  ABISELECT(-21280,-11852),
  ABISELECT(-19584,-10912),
  ABISELECT(-19712,-10984),
  ABISELECT(-19456,-10828),
  ABISELECT(-5008,-2864),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n80_N8S2489C16D1Ev,_ZTvn44_n40_N8S2489C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n80_N8S2489C16D0Ev,_ZTvn44_n40_N8S2489C16D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C16D1Ev,_ZTv0_n20_N8S2489C16D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C16D0Ev,_ZTv0_n20_N8S2489C16D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C168S2489C15__7S2489C1[] = {
  0,
  ABISELECT(14576,8048),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(14576,8048),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C16D1Ev,_ZTv0_n20_N8S2489C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C16D0Ev,_ZTv0_n20_N8S2489C16D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C168S2489C15__7S2489C1[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(14448,7964),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C168S2489C15__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(16272,8988),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C198S2489C17__A2__8S2489C168S2489C15__7S2489C1[] = {
  ABISELECT(-20128,-11248),
  ABISELECT(-5424,-3128),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n64_N8S2489C16D1Ev,_ZTv0_n32_N8S2489C16D1Ev)();
extern void ABISELECT(_ZThn8368_N8S2489C16D1Ev,_ZThn4728_N8S2489C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S2489C16D0Ev,_ZTv0_n32_N8S2489C16D0Ev)();
extern void ABISELECT(_ZThn8368_N8S2489C16D0Ev,_ZThn4728_N8S2489C16D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C20__8S2489C168S2489C15__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(-8368,-4728),
  ABISELECT(-22432,-12488),
  ABISELECT(-24640,-13716),
  ABISELECT(-22944,-12776),
  ABISELECT(-23072,-12848),
  ABISELECT(-22816,-12692),
  ABISELECT(-8368,-4728),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C16D1Ev,_ZTv0_n32_N8S2489C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C16D0Ev,_ZTv0_n32_N8S2489C16D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN8S2489C133v11Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C13__8S2489C168S2489C15__7S2489C1[] = {
  0,
  ABISELECT(14064,7760),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
};
extern void ABISELECT(_ZTvn2704_n80_N8S2489C16D1Ev,_ZTvn1500_n40_N8S2489C16D1Ev)();
extern void ABISELECT(_ZTvn2704_n80_N8S2489C16D0Ev,_ZTvn1500_n40_N8S2489C16D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S2489C218S2489C17__8S2489C168S2489C15__7S2489C1[] = {
  ABISELECT(52960,29532),
  ABISELECT(-23888,-13308),
  ABISELECT(-22192,-12368),
  ABISELECT(-22320,-12440),
  ABISELECT(-22064,-12284),
  ABISELECT(-7616,-4320),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2704_n80_N8S2489C16D1Ev,_ZTvn1500_n40_N8S2489C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2704_n80_N8S2489C16D0Ev,_ZTvn1500_n40_N8S2489C16D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N8S2489C16D1Ev,_ZTv0_n28_N8S2489C16D1Ev)();
extern void ABISELECT(_ZThn60576_N8S2489C16D1Ev,_ZThn33852_N8S2489C16D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C16D0Ev,_ZTv0_n28_N8S2489C16D0Ev)();
extern void ABISELECT(_ZThn60576_N8S2489C16D0Ev,_ZThn33852_N8S2489C16D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A1__8S2489C168S2489C15__7S2489C1[] = {
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(-60576,-33852),
  ABISELECT(-76848,-42840),
  ABISELECT(-75152,-41900),
  ABISELECT(-75280,-41972),
  ABISELECT(-75024,-41816),
  ABISELECT(-60576,-33852),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C16D1Ev,_ZTv0_n28_N8S2489C16D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C16D0Ev,_ZTv0_n28_N8S2489C16D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A3__8S2489C168S2489C15__7S2489C1[] = {
  ABISELECT(-75696,-42236),
  ABISELECT(-60992,-34116),
  (VTBL_ENTRY)&(_ZTI8S2489C16[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
extern void _ZN8S2489C223v14Ev();
extern void _ZN8S2489C223v15Ev();
extern void _ZN8S2489C22D1Ev();
extern void _ZN8S2489C22D0Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C228S2489C15__7S2489C1[] = {
  ABISELECT(57792,32244),
  ABISELECT(5584,3120),
  ABISELECT(-16848,-9368),
  ABISELECT(-19056,-10596),
  ABISELECT(-17360,-9656),
  ABISELECT(-17232,-9572),
  ABISELECT(66720,37236),
  ABISELECT(60400,33700),
  ABISELECT(-17488,-9728),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
  (VTBL_ENTRY)&_ZN8S2489C223v14Ev,
  (VTBL_ENTRY)&_ZN8S2489C223v15Ev,
  (VTBL_ENTRY)&_ZN8S2489C22D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C22D0Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C58S2489C228S2489C15__A1__7S2489C1[] = {
  ABISELECT(-17488,-9728),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C5[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C67S2489C58S2489C228S2489C15__A5__7S2489C1[] = {
  ABISELECT(-17488,-9728),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n88_N8S2489C22D1Ev,_ZTv0_n44_N8S2489C22D1Ev)();
extern void ABISELECT(_ZThn60400_N8S2489C22D1Ev,_ZThn33700_N8S2489C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n88_N8S2489C22D0Ev,_ZTv0_n44_N8S2489C22D0Ev)();
extern void ABISELECT(_ZThn60400_N8S2489C22D0Ev,_ZThn33700_N8S2489C22D0Ev)() __attribute__((weak));
extern void _ZN8S2489C173v12Ev();
extern void _ZN8S2489C173v13Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C23__8S2489C228S2489C15__7S2489C1[] = {
  ABISELECT(512,308),
  ABISELECT(512,308),
  ABISELECT(96,44),
  ABISELECT(96,44),
  ABISELECT(96,44),
  ABISELECT(96,44),
  0,
  0,
  ABISELECT(-60400,-33700),
  ABISELECT(6320,3536),
  ABISELECT(-2608,-1456),
  ABISELECT(-77248,-43068),
  ABISELECT(-54816,-30580),
  ABISELECT(-79456,-44296),
  ABISELECT(-77632,-43272),
  ABISELECT(-77888,-43428),
  ABISELECT(-77760,-43356),
  ABISELECT(-60400,-33700),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n88_N8S2489C22D1Ev,_ZTv0_n44_N8S2489C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n88_N8S2489C22D0Ev,_ZTv0_n44_N8S2489C22D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C173v12Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v13Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S2489C22D1Ev,_ZTv0_n28_N8S2489C22D1Ev)();
extern void ABISELECT(_ZThn66720_N8S2489C22D1Ev,_ZThn37236_N8S2489C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C22D0Ev,_ZTv0_n28_N8S2489C22D0Ev)();
extern void ABISELECT(_ZThn66720_N8S2489C22D0Ev,_ZThn37236_N8S2489C22D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C10__8S2489C228S2489C15__7S2489C1[] = {
  0,
  ABISELECT(-66720,-37236),
  ABISELECT(-85776,-47832),
  ABISELECT(-84080,-46892),
  ABISELECT(-84208,-46964),
  ABISELECT(-83952,-46808),
  ABISELECT(-66720,-37236),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C22D1Ev,_ZTv0_n28_N8S2489C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C22D0Ev,_ZTv0_n28_N8S2489C22D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C228S2489C15__7S2489C1[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(17232,9572),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C22D1Ev,_ZTv0_n20_N8S2489C22D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C22D0Ev,_ZTv0_n20_N8S2489C22D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C228S2489C15__7S2489C1[] = {
  0,
  ABISELECT(17360,9656),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(17360,9656),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C22D1Ev,_ZTv0_n20_N8S2489C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C22D0Ev,_ZTv0_n20_N8S2489C22D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C228S2489C15__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(19056,10596),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN8S2489C133v11Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C13__8S2489C228S2489C15__7S2489C1[] = {
  0,
  ABISELECT(16848,9368),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
};
extern void ABISELECT(_ZTvn96_n88_N8S2489C22D1Ev,_ZTvn44_n44_N8S2489C22D1Ev)();
extern void ABISELECT(_ZTvn96_n88_N8S2489C22D0Ev,_ZTvn44_n44_N8S2489C22D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C198S2489C178S2489C23__8S2489C228S2489C15__7S2489C1[] = {
  ABISELECT(-79552,-44340),
  ABISELECT(-77856,-43400),
  ABISELECT(-77984,-43472),
  ABISELECT(-77728,-43316),
  ABISELECT(-60496,-33744),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n88_N8S2489C22D1Ev,_ZTvn44_n44_N8S2489C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n88_N8S2489C22D0Ev,_ZTvn44_n44_N8S2489C22D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C198S2489C178S2489C23__A2__8S2489C228S2489C15__7S2489C1[] = {
  ABISELECT(-78400,-43736),
  ABISELECT(-60912,-34008),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n64_N8S2489C22D1Ev,_ZTv0_n32_N8S2489C22D1Ev)();
extern void ABISELECT(_ZThn5584_N8S2489C22D1Ev,_ZThn3120_N8S2489C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S2489C22D0Ev,_ZTv0_n32_N8S2489C22D0Ev)();
extern void ABISELECT(_ZThn5584_N8S2489C22D0Ev,_ZThn3120_N8S2489C22D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C20__8S2489C228S2489C15__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(-5584,-3120),
  ABISELECT(-22432,-12488),
  ABISELECT(-24640,-13716),
  ABISELECT(-22944,-12776),
  ABISELECT(-23072,-12848),
  ABISELECT(-22816,-12692),
  ABISELECT(-5584,-3120),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C22D1Ev,_ZTv0_n32_N8S2489C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C22D0Ev,_ZTv0_n32_N8S2489C22D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void ABISELECT(_ZTvn2704_n88_N8S2489C22D1Ev,_ZTvn1500_n44_N8S2489C22D1Ev)();
extern void ABISELECT(_ZTvn2704_n88_N8S2489C22D0Ev,_ZTvn1500_n44_N8S2489C22D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S2489C218S2489C178S2489C23__8S2489C228S2489C15__7S2489C1[] = {
  ABISELECT(-5312,-2956),
  ABISELECT(-82160,-45796),
  ABISELECT(-80464,-44856),
  ABISELECT(-80592,-44928),
  ABISELECT(-80336,-44772),
  ABISELECT(-63104,-35200),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2704_n88_N8S2489C22D1Ev,_ZTvn1500_n44_N8S2489C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2704_n88_N8S2489C22D0Ev,_ZTvn1500_n44_N8S2489C22D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N8S2489C22D1Ev,_ZTv0_n28_N8S2489C22D1Ev)();
extern void ABISELECT(_ZThn57792_N8S2489C22D1Ev,_ZThn32244_N8S2489C22D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C22D0Ev,_ZTv0_n28_N8S2489C22D0Ev)();
extern void ABISELECT(_ZThn57792_N8S2489C22D0Ev,_ZThn32244_N8S2489C22D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A1__8S2489C228S2489C15__7S2489C1[] = {
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(-57792,-32244),
  ABISELECT(-76848,-42840),
  ABISELECT(-75152,-41900),
  ABISELECT(-75280,-41972),
  ABISELECT(-75024,-41816),
  ABISELECT(-57792,-32244),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C22D1Ev,_ZTv0_n28_N8S2489C22D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C22D0Ev,_ZTv0_n28_N8S2489C22D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A3__8S2489C228S2489C15__7S2489C1[] = {
  ABISELECT(-75696,-42236),
  ABISELECT(-58208,-32508),
  (VTBL_ENTRY)&(_ZTI8S2489C22[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C21D1Ev();
extern void _ZN8S2489C21D0Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C218S2489C15__A2__7S2489C1[] = {
  ABISELECT(55984,31212),
  ABISELECT(-20864,-11628),
  ABISELECT(-19168,-10688),
  ABISELECT(-19296,-10760),
  ABISELECT(-19040,-10604),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN8S2489C21D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C21D0Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C218S2489C15__A2__7S2489C1[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(19040,10604),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C218S2489C15__A2__7S2489C1[] = {
  0,
  ABISELECT(19168,10688),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(19168,10688),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C218S2489C15__A2__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(20864,11628),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev)();
extern void ABISELECT(_ZThn55984_N8S2489C21D1Ev,_ZThn31212_N8S2489C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev)();
extern void ABISELECT(_ZThn55984_N8S2489C21D0Ev,_ZThn31212_N8S2489C21D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__8S2489C218S2489C15__A2__7S2489C1[] = {
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(-55984,-31212),
  ABISELECT(-76848,-42840),
  ABISELECT(-75152,-41900),
  ABISELECT(-75280,-41972),
  ABISELECT(-75024,-41816),
  ABISELECT(-55984,-31212),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A2__8S2489C218S2489C15__A2__7S2489C1[] = {
  ABISELECT(-75696,-42236),
  ABISELECT(-56400,-31476),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C15__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(16176,8944),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C15D1Ev,_ZTv0_n20_N8S2489C15D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C15D0Ev,_ZTv0_n20_N8S2489C15D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C15__7S2489C1[] = {
  0,
  ABISELECT(14480,8004),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(14480,8004),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C15D1Ev,_ZTv0_n20_N8S2489C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C15D0Ev,_ZTv0_n20_N8S2489C15D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A1__8S2489C15__7S2489C1[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(14352,7920),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZThn96_N8S2489C15D1Ev,_ZThn44_N8S2489C15D1Ev)();
extern void ABISELECT(_ZThn96_N8S2489C15D0Ev,_ZThn44_N8S2489C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S2489C16__8S2489C15__7S2489C1[] = {
  ABISELECT(60576,33852),
  ABISELECT(-14064,-7760),
  ABISELECT(8368,4728),
  ABISELECT(-16272,-8988),
  ABISELECT(-14448,-7964),
  ABISELECT(-14704,-8120),
  ABISELECT(-14576,-8048),
  ABISELECT(4912,2820),
  ABISELECT(-96,-44),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C15D1Ev,_ZThn44_N8S2489C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C15D0Ev,_ZThn44_N8S2489C15D0Ev),
};
extern void ABISELECT(_ZTv0_n80_N8S2489C15D1Ev,_ZTv0_n40_N8S2489C15D1Ev)();
extern void ABISELECT(_ZThn5008_N8S2489C15D1Ev,_ZThn2864_N8S2489C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n80_N8S2489C15D0Ev,_ZTv0_n40_N8S2489C15D0Ev)();
extern void ABISELECT(_ZThn5008_N8S2489C15D0Ev,_ZThn2864_N8S2489C15D0Ev)() __attribute__((weak));
extern void _ZN8S2489C173v12Ev();
extern void _ZN8S2489C173v13Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C17__8S2489C15__7S2489C1[] = {
  ABISELECT(512,308),
  ABISELECT(512,308),
  ABISELECT(96,44),
  ABISELECT(96,44),
  ABISELECT(96,44),
  ABISELECT(96,44),
  0,
  0,
  ABISELECT(-5008,-2864),
  ABISELECT(55664,31032),
  ABISELECT(-18976,-10580),
  ABISELECT(3456,1908),
  ABISELECT(-21184,-11808),
  ABISELECT(-19360,-10784),
  ABISELECT(-19616,-10940),
  ABISELECT(-19488,-10868),
  ABISELECT(-5008,-2864),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S2489C15D1Ev,_ZTv0_n40_N8S2489C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n80_N8S2489C15D0Ev,_ZTv0_n40_N8S2489C15D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C173v12Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v13Ev,
};
extern void ABISELECT(_ZTvn96_n80_N8S2489C15D1Ev,_ZTvn44_n40_N8S2489C15D1Ev)();
extern void ABISELECT(_ZTvn96_n80_N8S2489C15D0Ev,_ZTvn44_n40_N8S2489C15D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C198S2489C17__8S2489C15__7S2489C1[] = {
  ABISELECT(-21280,-11852),
  ABISELECT(-19584,-10912),
  ABISELECT(-19712,-10984),
  ABISELECT(-19456,-10828),
  ABISELECT(-5104,-2908),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n80_N8S2489C15D1Ev,_ZTvn44_n40_N8S2489C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n80_N8S2489C15D0Ev,_ZTvn44_n40_N8S2489C15D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C198S2489C17__A2__8S2489C15__7S2489C1[] = {
  ABISELECT(-20128,-11248),
  ABISELECT(-5520,-3172),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n64_N8S2489C15D1Ev,_ZTv0_n32_N8S2489C15D1Ev)();
extern void ABISELECT(_ZThn8464_N8S2489C15D1Ev,_ZThn4772_N8S2489C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S2489C15D0Ev,_ZTv0_n32_N8S2489C15D0Ev)();
extern void ABISELECT(_ZThn8464_N8S2489C15D0Ev,_ZThn4772_N8S2489C15D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C20__8S2489C15__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(-8464,-4772),
  ABISELECT(-22432,-12488),
  ABISELECT(-24640,-13716),
  ABISELECT(-22944,-12776),
  ABISELECT(-23072,-12848),
  ABISELECT(-22816,-12692),
  ABISELECT(-8464,-4772),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C15D1Ev,_ZTv0_n32_N8S2489C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C15D0Ev,_ZTv0_n32_N8S2489C15D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN8S2489C133v11Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C13__8S2489C15__7S2489C1[] = {
  0,
  ABISELECT(13968,7716),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
};
extern void ABISELECT(_ZTvn2704_n80_N8S2489C15D1Ev,_ZTvn1500_n40_N8S2489C15D1Ev)();
extern void ABISELECT(_ZTvn2704_n80_N8S2489C15D0Ev,_ZTvn1500_n40_N8S2489C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S2489C218S2489C17__8S2489C15__7S2489C1[] = {
  ABISELECT(52960,29532),
  ABISELECT(-23888,-13308),
  ABISELECT(-22192,-12368),
  ABISELECT(-22320,-12440),
  ABISELECT(-22064,-12284),
  ABISELECT(-7712,-4364),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2704_n80_N8S2489C15D1Ev,_ZTvn1500_n40_N8S2489C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2704_n80_N8S2489C15D0Ev,_ZTvn1500_n40_N8S2489C15D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N8S2489C15D1Ev,_ZTv0_n28_N8S2489C15D1Ev)();
extern void ABISELECT(_ZThn60672_N8S2489C15D1Ev,_ZThn33896_N8S2489C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C15D0Ev,_ZTv0_n28_N8S2489C15D0Ev)();
extern void ABISELECT(_ZThn60672_N8S2489C15D0Ev,_ZThn33896_N8S2489C15D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A1__8S2489C15__7S2489C1[] = {
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(-60672,-33896),
  ABISELECT(-76848,-42840),
  ABISELECT(-75152,-41900),
  ABISELECT(-75280,-41972),
  ABISELECT(-75024,-41816),
  ABISELECT(-60672,-33896),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C15D1Ev,_ZTv0_n28_N8S2489C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C15D0Ev,_ZTv0_n28_N8S2489C15D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A3__8S2489C15__7S2489C1[] = {
  ABISELECT(-75696,-42236),
  ABISELECT(-61088,-34160),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
extern void _ZN8S2489C223v14Ev();
extern void _ZN8S2489C223v15Ev();
extern void ABISELECT(_ZThn2880_N8S2489C15D1Ev,_ZThn1652_N8S2489C15D1Ev)();
extern void ABISELECT(_ZThn2880_N8S2489C15D0Ev,_ZThn1652_N8S2489C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S2489C22__8S2489C15__7S2489C1[] = {
  ABISELECT(57792,32244),
  ABISELECT(5584,3120),
  ABISELECT(-16848,-9368),
  ABISELECT(-19056,-10596),
  ABISELECT(-17360,-9656),
  ABISELECT(-17232,-9572),
  ABISELECT(66720,37236),
  ABISELECT(60400,33700),
  ABISELECT(-17488,-9728),
  ABISELECT(-2880,-1652),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
  (VTBL_ENTRY)&_ZN8S2489C223v14Ev,
  (VTBL_ENTRY)&_ZN8S2489C223v15Ev,
  (VTBL_ENTRY)&ABISELECT(_ZThn2880_N8S2489C15D1Ev,_ZThn1652_N8S2489C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2880_N8S2489C15D0Ev,_ZThn1652_N8S2489C15D0Ev),
};
extern void ABISELECT(_ZTv0_n88_N8S2489C15D1Ev,_ZTv0_n44_N8S2489C15D1Ev)();
extern void ABISELECT(_ZThn63280_N8S2489C15D1Ev,_ZThn35352_N8S2489C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n88_N8S2489C15D0Ev,_ZTv0_n44_N8S2489C15D0Ev)();
extern void ABISELECT(_ZThn63280_N8S2489C15D0Ev,_ZThn35352_N8S2489C15D0Ev)() __attribute__((weak));
extern void _ZN8S2489C173v12Ev();
extern void _ZN8S2489C173v13Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C23__8S2489C15__7S2489C1[] = {
  ABISELECT(512,308),
  ABISELECT(512,308),
  ABISELECT(96,44),
  ABISELECT(96,44),
  ABISELECT(96,44),
  ABISELECT(96,44),
  0,
  0,
  ABISELECT(-63280,-35352),
  ABISELECT(6320,3536),
  ABISELECT(-2608,-1456),
  ABISELECT(-77248,-43068),
  ABISELECT(-54816,-30580),
  ABISELECT(-79456,-44296),
  ABISELECT(-77632,-43272),
  ABISELECT(-77888,-43428),
  ABISELECT(-77760,-43356),
  ABISELECT(-63280,-35352),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n88_N8S2489C15D1Ev,_ZTv0_n44_N8S2489C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n88_N8S2489C15D0Ev,_ZTv0_n44_N8S2489C15D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C173v12Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v13Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S2489C15D1Ev,_ZTv0_n28_N8S2489C15D1Ev)();
extern void ABISELECT(_ZThn69600_N8S2489C15D1Ev,_ZThn38888_N8S2489C15D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C15D0Ev,_ZTv0_n28_N8S2489C15D0Ev)();
extern void ABISELECT(_ZThn69600_N8S2489C15D0Ev,_ZThn38888_N8S2489C15D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C10__A3__8S2489C15__7S2489C1[] = {
  0,
  ABISELECT(-69600,-38888),
  ABISELECT(-85776,-47832),
  ABISELECT(-84080,-46892),
  ABISELECT(-84208,-46964),
  ABISELECT(-83952,-46808),
  ABISELECT(-69600,-38888),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C15D1Ev,_ZTv0_n28_N8S2489C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C15D0Ev,_ZTv0_n28_N8S2489C15D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void ABISELECT(_ZTvn96_n88_N8S2489C15D1Ev,_ZTvn44_n44_N8S2489C15D1Ev)();
extern void ABISELECT(_ZTvn96_n88_N8S2489C15D0Ev,_ZTvn44_n44_N8S2489C15D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C198S2489C178S2489C23__A2__8S2489C15__7S2489C1[] = {
  ABISELECT(-79552,-44340),
  ABISELECT(-77856,-43400),
  ABISELECT(-77984,-43472),
  ABISELECT(-77728,-43316),
  ABISELECT(-63376,-35396),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n88_N8S2489C15D1Ev,_ZTvn44_n44_N8S2489C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn96_n88_N8S2489C15D0Ev,_ZTvn44_n44_N8S2489C15D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C198S2489C178S2489C23__A4__8S2489C15__7S2489C1[] = {
  ABISELECT(-78400,-43736),
  ABISELECT(-63792,-35660),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTvn2704_n88_N8S2489C15D1Ev,_ZTvn1500_n44_N8S2489C15D1Ev)();
extern void ABISELECT(_ZTvn2704_n88_N8S2489C15D0Ev,_ZTvn1500_n44_N8S2489C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S2489C218S2489C178S2489C23__A1__8S2489C15__7S2489C1[] = {
  ABISELECT(-5312,-2956),
  ABISELECT(-82160,-45796),
  ABISELECT(-80464,-44856),
  ABISELECT(-80592,-44928),
  ABISELECT(-80336,-44772),
  ABISELECT(-65984,-36852),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2704_n88_N8S2489C15D1Ev,_ZTvn1500_n44_N8S2489C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTvn2704_n88_N8S2489C15D0Ev,_ZTvn1500_n44_N8S2489C15D0Ev),
};
extern void ABISELECT(_ZThn4688_N8S2489C15D1Ev,_ZThn2684_N8S2489C15D1Ev)();
extern void ABISELECT(_ZThn4688_N8S2489C15D0Ev,_ZThn2684_N8S2489C15D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S2489C21__A2__8S2489C15__7S2489C1[] = {
  ABISELECT(55984,31212),
  ABISELECT(-20864,-11628),
  ABISELECT(-19168,-10688),
  ABISELECT(-19296,-10760),
  ABISELECT(-19040,-10604),
  ABISELECT(-4688,-2684),
  (VTBL_ENTRY)&(_ZTI8S2489C15[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn4688_N8S2489C15D1Ev,_ZThn2684_N8S2489C15D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn4688_N8S2489C15D0Ev,_ZThn2684_N8S2489C15D0Ev),
};
extern void _ZN8S2489C17D1Ev();
extern void _ZN8S2489C17D0Ev();
extern void _ZN8S2489C173v12Ev();
extern void _ZN8S2489C173v13Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C17__7S2489C1[] = {
  ABISELECT(55664,31032),
  ABISELECT(-18976,-10580),
  ABISELECT(3456,1908),
  ABISELECT(-21184,-11808),
  ABISELECT(-19360,-10784),
  ABISELECT(-19616,-10940),
  ABISELECT(-19488,-10868),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN8S2489C17D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C17D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v12Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v13Ev,
};
extern void _ZN8S2489C19D1Ev();
extern void _ZN8S2489C19D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C198S2489C17__7S2489C1[] = {
  ABISELECT(-21280,-11852),
  ABISELECT(-19584,-10912),
  ABISELECT(-19712,-10984),
  ABISELECT(-19456,-10828),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN8S2489C19D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C19D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C108S2489C198S2489C17__A1__7S2489C1[] = {
  ABISELECT(-21280,-11852),
  ABISELECT(-19584,-10912),
  ABISELECT(-19712,-10984),
  ABISELECT(-19456,-10828),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C108S2489C198S2489C17__A1__7S2489C1[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(19456,10828),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C108S2489C198S2489C17__A1__7S2489C1[] = {
  0,
  ABISELECT(19584,10912),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(19584,10912),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C108S2489C198S2489C17__A1__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(21280,11852),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C198S2489C17__A2__7S2489C1[] = {
  ABISELECT(-20128,-11248),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C198S2489C17__7S2489C1[] = {
  0,
  ABISELECT(19584,10912),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(19584,10912),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C198S2489C17__7S2489C1[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(19456,10828),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C198S2489C17__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(21280,11852),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A__8S2489C198S2489C17__7S2489C1[] = {
  ABISELECT(-20128,-11248),
  ABISELECT(-416,-264),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C21D1Ev();
extern void _ZN8S2489C21D0Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C218S2489C17__7S2489C1[] = {
  ABISELECT(52960,29532),
  ABISELECT(-23888,-13308),
  ABISELECT(-22192,-12368),
  ABISELECT(-22320,-12440),
  ABISELECT(-22064,-12284),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN8S2489C21D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C21D0Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C218S2489C17__7S2489C1[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(22064,12284),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C218S2489C17__7S2489C1[] = {
  0,
  ABISELECT(22192,12368),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(22192,12368),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C218S2489C17__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(23888,13308),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev)();
extern void ABISELECT(_ZThn52960_N8S2489C21D1Ev,_ZThn29532_N8S2489C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev)();
extern void ABISELECT(_ZThn52960_N8S2489C21D0Ev,_ZThn29532_N8S2489C21D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__8S2489C218S2489C17__7S2489C1[] = {
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(-52960,-29532),
  ABISELECT(-76848,-42840),
  ABISELECT(-75152,-41900),
  ABISELECT(-75280,-41972),
  ABISELECT(-75024,-41816),
  ABISELECT(-52960,-29532),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A2__8S2489C218S2489C17__7S2489C1[] = {
  ABISELECT(-75696,-42236),
  ABISELECT(-53376,-29796),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZThn96_N8S2489C17D1Ev,_ZThn44_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn96_N8S2489C17D0Ev,_ZThn44_N8S2489C17D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A__8S2489C17__7S2489C1[] = {
  ABISELECT(-21280,-11852),
  ABISELECT(-19584,-10912),
  ABISELECT(-19712,-10984),
  ABISELECT(-19456,-10828),
  ABISELECT(-96,-44),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C17D1Ev,_ZThn44_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C17D0Ev,_ZThn44_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C17D1Ev,_ZTv0_n20_N8S2489C17D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C17D0Ev,_ZTv0_n20_N8S2489C17D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C17__7S2489C1[] = {
  0,
  ABISELECT(19488,10868),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(19488,10868),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C17D1Ev,_ZTv0_n20_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C17D0Ev,_ZTv0_n20_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C17__7S2489C1[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(19360,10784),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C17__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(21184,11808),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A2__8S2489C17__7S2489C1[] = {
  ABISELECT(-20128,-11248),
  ABISELECT(-512,-308),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n64_N8S2489C17D1Ev,_ZTv0_n32_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn3456_N8S2489C17D1Ev,_ZThn1908_N8S2489C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S2489C17D0Ev,_ZTv0_n32_N8S2489C17D0Ev)();
extern void ABISELECT(_ZThn3456_N8S2489C17D0Ev,_ZThn1908_N8S2489C17D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C20__8S2489C17__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(-3456,-1908),
  ABISELECT(-22432,-12488),
  ABISELECT(-24640,-13716),
  ABISELECT(-22944,-12776),
  ABISELECT(-23072,-12848),
  ABISELECT(-22816,-12692),
  ABISELECT(-3456,-1908),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C17D1Ev,_ZTv0_n32_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C17D0Ev,_ZTv0_n32_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN8S2489C133v11Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C13__8S2489C17__7S2489C1[] = {
  0,
  ABISELECT(18976,10580),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
};
extern void ABISELECT(_ZThn2704_N8S2489C17D1Ev,_ZThn1500_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn2704_N8S2489C17D0Ev,_ZThn1500_N8S2489C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S2489C21__8S2489C17__7S2489C1[] = {
  ABISELECT(52960,29532),
  ABISELECT(-23888,-13308),
  ABISELECT(-22192,-12368),
  ABISELECT(-22320,-12440),
  ABISELECT(-22064,-12284),
  ABISELECT(-2704,-1500),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S2489C17D1Ev,_ZThn1500_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S2489C17D0Ev,_ZThn1500_N8S2489C17D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N8S2489C17D1Ev,_ZTv0_n28_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn55664_N8S2489C17D1Ev,_ZThn31032_N8S2489C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C17D0Ev,_ZTv0_n28_N8S2489C17D0Ev)();
extern void ABISELECT(_ZThn55664_N8S2489C17D0Ev,_ZThn31032_N8S2489C17D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A1__8S2489C17__7S2489C1[] = {
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(-55664,-31032),
  ABISELECT(-76848,-42840),
  ABISELECT(-75152,-41900),
  ABISELECT(-75280,-41972),
  ABISELECT(-75024,-41816),
  ABISELECT(-55664,-31032),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C17D1Ev,_ZTv0_n28_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C17D0Ev,_ZTv0_n28_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A3__8S2489C17__7S2489C1[] = {
  ABISELECT(-75696,-42236),
  ABISELECT(-56080,-31296),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C20D1Ev();
extern void _ZN8S2489C20D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C20__7S2489C1[] = {
  ABISELECT(-22432,-12488),
  ABISELECT(-24640,-13716),
  ABISELECT(-22944,-12776),
  ABISELECT(-23072,-12848),
  ABISELECT(-22816,-12692),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN8S2489C20D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C20D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN7S2489C9D1Ev();
extern void _ZN7S2489C9D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C98S2489C20__A1__7S2489C1[] = {
  ABISELECT(-24640,-13716),
  ABISELECT(-22944,-12776),
  ABISELECT(-23072,-12848),
  ABISELECT(-22816,-12692),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2489C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C107S2489C98S2489C20__A2__7S2489C1[] = {
  ABISELECT(-24640,-13716),
  ABISELECT(-22944,-12776),
  ABISELECT(-23072,-12848),
  ABISELECT(-22816,-12692),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C107S2489C98S2489C20__A2__7S2489C1[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(22816,12692),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C107S2489C98S2489C20__A2__7S2489C1[] = {
  0,
  ABISELECT(22944,12776),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(22944,12776),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C107S2489C98S2489C20__A2__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(24640,13716),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__7S2489C98S2489C20__A1__7S2489C1[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(22816,12692),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev)();
extern void ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__7S2489C98S2489C20__A1__7S2489C1[] = {
  0,
  ABISELECT(22944,12776),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(22944,12776),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__7S2489C98S2489C20__A1__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(24640,13716),
  (VTBL_ENTRY)&(_ZTI7S2489C9[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C20__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(24640,13716),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A1__8S2489C20__7S2489C1[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(22816,12692),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C20D1Ev,_ZTv0_n20_N8S2489C20D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C20D0Ev,_ZTv0_n20_N8S2489C20D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C20__7S2489C1[] = {
  0,
  ABISELECT(22944,12776),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(22944,12776),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C20D1Ev,_ZTv0_n20_N8S2489C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C20D0Ev,_ZTv0_n20_N8S2489C20D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN8S2489C133v11Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C13__8S2489C20__7S2489C1[] = {
  0,
  ABISELECT(22432,12488),
  (VTBL_ENTRY)&(_ZTI8S2489C20[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
};
extern void _ZN8S2489C19D1Ev();
extern void _ZN8S2489C19D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A1__7S2489C1[] = {
  ABISELECT(-76848,-42840),
  ABISELECT(-75152,-41900),
  ABISELECT(-75280,-41972),
  ABISELECT(-75024,-41816),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN8S2489C19D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C19D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C108S2489C19__A3__7S2489C1[] = {
  ABISELECT(-76848,-42840),
  ABISELECT(-75152,-41900),
  ABISELECT(-75280,-41972),
  ABISELECT(-75024,-41816),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C108S2489C19__A3__7S2489C1[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(75024,41816),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C108S2489C19__A3__7S2489C1[] = {
  0,
  ABISELECT(75152,41900),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(75152,41900),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C108S2489C19__A3__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(76848,42840),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A3__7S2489C1[] = {
  ABISELECT(-75696,-42236),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C19__A1__7S2489C1[] = {
  0,
  ABISELECT(75152,41900),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(75152,41900),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C19__A1__7S2489C1[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(75024,41816),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C19__A1__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(76848,42840),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A__8S2489C19__A1__7S2489C1[] = {
  ABISELECT(-75696,-42236),
  ABISELECT(-416,-264),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C23D1Ev();
extern void _ZN8S2489C23D0Ev();
extern void _ZN8S2489C173v12Ev();
extern void _ZN8S2489C173v13Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C23__7S2489C1[] = {
  ABISELECT(6320,3536),
  ABISELECT(-2608,-1456),
  ABISELECT(-77248,-43068),
  ABISELECT(-54816,-30580),
  ABISELECT(-79456,-44296),
  ABISELECT(-77632,-43272),
  ABISELECT(-77888,-43428),
  ABISELECT(-77760,-43356),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&_ZN8S2489C23D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C23D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v12Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v13Ev,
};
extern void _ZN8S2489C17D1Ev();
extern void _ZN8S2489C17D0Ev();
extern void _ZN8S2489C173v12Ev();
extern void _ZN8S2489C173v13Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C178S2489C23__A1__7S2489C1[] = {
  ABISELECT(-2608,-1456),
  ABISELECT(-77248,-43068),
  ABISELECT(-54816,-30580),
  ABISELECT(-79456,-44296),
  ABISELECT(-77632,-43272),
  ABISELECT(-77888,-43428),
  ABISELECT(-77760,-43356),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN8S2489C17D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C17D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v12Ev,
  (VTBL_ENTRY)&_ZN8S2489C173v13Ev,
};
extern void _ZN8S2489C19D1Ev();
extern void _ZN8S2489C19D0Ev();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C198S2489C178S2489C23__A2__7S2489C1[] = {
  ABISELECT(-79552,-44340),
  ABISELECT(-77856,-43400),
  ABISELECT(-77984,-43472),
  ABISELECT(-77728,-43316),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN8S2489C19D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C19D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C108S2489C198S2489C178S2489C23__A5__7S2489C1[] = {
  ABISELECT(-79552,-44340),
  ABISELECT(-77856,-43400),
  ABISELECT(-77984,-43472),
  ABISELECT(-77728,-43316),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C108S2489C198S2489C178S2489C23__A5__7S2489C1[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(77728,43316),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C108S2489C198S2489C178S2489C23__A5__7S2489C1[] = {
  0,
  ABISELECT(77856,43400),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(77856,43400),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C108S2489C198S2489C178S2489C23__A5__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(79552,44340),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C198S2489C178S2489C23__A4__7S2489C1[] = {
  ABISELECT(-78400,-43736),
  0,
  (VTBL_ENTRY)&(_ZTI7S2489C6[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C198S2489C178S2489C23__A2__7S2489C1[] = {
  0,
  ABISELECT(77856,43400),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(77856,43400),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D1Ev,_ZTv0_n20_N8S2489C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C19D0Ev,_ZTv0_n20_N8S2489C19D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C198S2489C178S2489C23__A2__7S2489C1[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(77728,43316),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C198S2489C178S2489C23__A2__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(79552,44340),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__A__8S2489C198S2489C178S2489C23__A2__7S2489C1[] = {
  ABISELECT(-78400,-43736),
  ABISELECT(-416,-264),
  (VTBL_ENTRY)&(_ZTI8S2489C19[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C21D1Ev();
extern void _ZN8S2489C21D0Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C218S2489C178S2489C23__A1__7S2489C1[] = {
  ABISELECT(-5312,-2956),
  ABISELECT(-82160,-45796),
  ABISELECT(-80464,-44856),
  ABISELECT(-80592,-44928),
  ABISELECT(-80336,-44772),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN8S2489C21D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C21D0Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C218S2489C178S2489C23__A1__7S2489C1[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(80336,44772),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C218S2489C178S2489C23__A1__7S2489C1[] = {
  0,
  ABISELECT(80464,44856),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(80464,44856),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C21D1Ev,_ZTv0_n20_N8S2489C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C21D0Ev,_ZTv0_n20_N8S2489C21D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C218S2489C178S2489C23__A1__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(82160,45796),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev)();
extern void ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__8S2489C218S2489C178S2489C23__A1__7S2489C1[] = {
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(5312,2956),
  ABISELECT(-76848,-42840),
  ABISELECT(-75152,-41900),
  ABISELECT(-75280,-41972),
  ABISELECT(-75024,-41816),
  ABISELECT(5312,2956),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A2__8S2489C218S2489C178S2489C23__A1__7S2489C1[] = {
  ABISELECT(-75696,-42236),
  ABISELECT(4896,2692),
  (VTBL_ENTRY)&(_ZTI8S2489C21[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZThn96_N8S2489C17D1Ev,_ZThn44_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn96_N8S2489C17D0Ev,_ZThn44_N8S2489C17D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A__8S2489C178S2489C23__A1__7S2489C1[] = {
  ABISELECT(-79552,-44340),
  ABISELECT(-77856,-43400),
  ABISELECT(-77984,-43472),
  ABISELECT(-77728,-43316),
  ABISELECT(-96,-44),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C17D1Ev,_ZThn44_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C17D0Ev,_ZThn44_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C17D1Ev,_ZTv0_n20_N8S2489C17D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C17D0Ev,_ZTv0_n20_N8S2489C17D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C178S2489C23__A1__7S2489C1[] = {
  0,
  ABISELECT(77760,43356),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(77760,43356),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C17D1Ev,_ZTv0_n20_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C17D0Ev,_ZTv0_n20_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C178S2489C23__A1__7S2489C1[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(77632,43272),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C178S2489C23__A1__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(79456,44296),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A2__8S2489C178S2489C23__A1__7S2489C1[] = {
  ABISELECT(-78400,-43736),
  ABISELECT(-512,-308),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n64_N8S2489C17D1Ev,_ZTv0_n32_N8S2489C17D1Ev)();
extern void ABISELECT(_ZTv0_n64_N8S2489C17D0Ev,_ZTv0_n32_N8S2489C17D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C20__8S2489C178S2489C23__A1__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(54816,30580),
  ABISELECT(-22432,-12488),
  ABISELECT(-24640,-13716),
  ABISELECT(-22944,-12776),
  ABISELECT(-23072,-12848),
  ABISELECT(-22816,-12692),
  ABISELECT(54816,30580),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C17D1Ev,_ZTv0_n32_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C17D0Ev,_ZTv0_n32_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void _ZN8S2489C133v11Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C13__8S2489C178S2489C23__A1__7S2489C1[] = {
  0,
  ABISELECT(77248,43068),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
};
extern void ABISELECT(_ZThn2704_N8S2489C17D1Ev,_ZThn1500_N8S2489C17D1Ev)();
extern void ABISELECT(_ZThn2704_N8S2489C17D0Ev,_ZThn1500_N8S2489C17D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S2489C21__8S2489C178S2489C23__A1__7S2489C1[] = {
  ABISELECT(-5312,-2956),
  ABISELECT(-82160,-45796),
  ABISELECT(-80464,-44856),
  ABISELECT(-80592,-44928),
  ABISELECT(-80336,-44772),
  ABISELECT(-2704,-1500),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S2489C17D1Ev,_ZThn1500_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S2489C17D0Ev,_ZThn1500_N8S2489C17D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N8S2489C17D1Ev,_ZTv0_n28_N8S2489C17D1Ev)();
extern void ABISELECT(_ZTv0_n56_N8S2489C17D0Ev,_ZTv0_n28_N8S2489C17D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A1__8S2489C178S2489C23__A1__7S2489C1[] = {
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(2608,1456),
  ABISELECT(-76848,-42840),
  ABISELECT(-75152,-41900),
  ABISELECT(-75280,-41972),
  ABISELECT(-75024,-41816),
  ABISELECT(2608,1456),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C17D1Ev,_ZTv0_n28_N8S2489C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C17D0Ev,_ZTv0_n28_N8S2489C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A3__8S2489C178S2489C23__A1__7S2489C1[] = {
  ABISELECT(-75696,-42236),
  ABISELECT(2192,1192),
  (VTBL_ENTRY)&(_ZTI8S2489C17[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S2489C23D1Ev,_ZTv0_n28_N8S2489C23D1Ev)();
extern void ABISELECT(_ZThn6320_N8S2489C23D1Ev,_ZThn3536_N8S2489C23D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2489C23D0Ev,_ZTv0_n28_N8S2489C23D0Ev)();
extern void ABISELECT(_ZThn6320_N8S2489C23D0Ev,_ZThn3536_N8S2489C23D0Ev)() __attribute__((weak));
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C10__8S2489C23__7S2489C1[] = {
  0,
  ABISELECT(-6320,-3536),
  ABISELECT(-85776,-47832),
  ABISELECT(-84080,-46892),
  ABISELECT(-84208,-46964),
  ABISELECT(-83952,-46808),
  ABISELECT(-6320,-3536),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C23D1Ev,_ZTv0_n28_N8S2489C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C23D0Ev,_ZTv0_n28_N8S2489C23D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C23__7S2489C1[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(77632,43272),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C23D1Ev,_ZTv0_n20_N8S2489C23D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C23D0Ev,_ZTv0_n20_N8S2489C23D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C23__7S2489C1[] = {
  0,
  ABISELECT(77760,43356),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(77760,43356),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C23D1Ev,_ZTv0_n20_N8S2489C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C23D0Ev,_ZTv0_n20_N8S2489C23D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C23__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(79456,44296),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
extern void _ZN8S2489C133v11Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C13__8S2489C23__7S2489C1[] = {
  0,
  ABISELECT(77248,43068),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&_ZN8S2489C133v11Ev,
};
extern void ABISELECT(_ZThn96_N8S2489C23D1Ev,_ZThn44_N8S2489C23D1Ev)();
extern void ABISELECT(_ZThn96_N8S2489C23D0Ev,_ZThn44_N8S2489C23D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C198S2489C17__8S2489C23__7S2489C1[] = {
  ABISELECT(-79552,-44340),
  ABISELECT(-77856,-43400),
  ABISELECT(-77984,-43472),
  ABISELECT(-77728,-43316),
  ABISELECT(-96,-44),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C23D1Ev,_ZThn44_N8S2489C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2489C23D0Ev,_ZThn44_N8S2489C23D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C198S2489C17__A2__8S2489C23__7S2489C1[] = {
  ABISELECT(-78400,-43736),
  ABISELECT(-512,-308),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n64_N8S2489C23D1Ev,_ZTv0_n32_N8S2489C23D1Ev)();
extern void ABISELECT(_ZTv0_n64_N8S2489C23D0Ev,_ZTv0_n32_N8S2489C23D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN7S2489C92v6Ev();
extern void _ZN7S2489C92v7Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C20__8S2489C23__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(54816,30580),
  ABISELECT(-22432,-12488),
  ABISELECT(-24640,-13716),
  ABISELECT(-22944,-12776),
  ABISELECT(-23072,-12848),
  ABISELECT(-22816,-12692),
  ABISELECT(54816,30580),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C23D1Ev,_ZTv0_n32_N8S2489C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2489C23D0Ev,_ZTv0_n32_N8S2489C23D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2489C92v7Ev,
};
extern void ABISELECT(_ZThn2704_N8S2489C23D1Ev,_ZThn1500_N8S2489C23D1Ev)();
extern void ABISELECT(_ZThn2704_N8S2489C23D0Ev,_ZThn1500_N8S2489C23D0Ev)();
static  VTBL_ENTRY _tg__ZTV8S2489C218S2489C17__8S2489C23__7S2489C1[] = {
  ABISELECT(-5312,-2956),
  ABISELECT(-82160,-45796),
  ABISELECT(-80464,-44856),
  ABISELECT(-80592,-44928),
  ABISELECT(-80336,-44772),
  ABISELECT(-2704,-1500),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S2489C23D1Ev,_ZThn1500_N8S2489C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S2489C23D0Ev,_ZThn1500_N8S2489C23D0Ev),
};
extern void ABISELECT(_ZTv0_n56_N8S2489C23D1Ev,_ZTv0_n28_N8S2489C23D1Ev)();
extern void ABISELECT(_ZTv0_n56_N8S2489C23D0Ev,_ZTv0_n28_N8S2489C23D0Ev)();
extern void _ZN8S2489C102v5Ev();
extern void _ZN8S2489C192v8Ev();
extern void _ZN8S2489C192v9Ev();
extern void _ZN8S2489C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C19__A1__8S2489C23__7S2489C1[] = {
  ABISELECT(416,264),
  ABISELECT(416,264),
  0,
  0,
  0,
  0,
  ABISELECT(2608,1456),
  ABISELECT(-76848,-42840),
  ABISELECT(-75152,-41900),
  ABISELECT(-75280,-41972),
  ABISELECT(-75024,-41816),
  ABISELECT(2608,1456),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C23D1Ev,_ZTv0_n28_N8S2489C23D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2489C23D0Ev,_ZTv0_n28_N8S2489C23D0Ev),
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2489C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2489C193v10Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C68S2489C19__A3__8S2489C23__7S2489C1[] = {
  ABISELECT(-75696,-42236),
  ABISELECT(2192,1192),
  (VTBL_ENTRY)&(_ZTI8S2489C23[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void _ZN8S2489C10D1Ev();
extern void _ZN8S2489C10D0Ev();
extern void _ZN8S2489C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2489C10__A4__7S2489C1[] = {
  ABISELECT(-85776,-47832),
  ABISELECT(-84080,-46892),
  ABISELECT(-84208,-46964),
  ABISELECT(-83952,-46808),
  0,
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN8S2489C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2489C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2489C102v5Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C6__8S2489C10__A4__7S2489C1[] = {
  0,
  0,
  ABISELECT(-256,-156),
  ABISELECT(83952,46808),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev)();
extern void _ZN7S2489C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C8__8S2489C10__A4__7S2489C1[] = {
  0,
  ABISELECT(84080,46892),
  ABISELECT(128,84),
  ABISELECT(-128,-72),
  ABISELECT(84080,46892),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2489C82v4Ev,
};
extern void _ZN7S2489C62v1Ev();
extern void _ZN7S2489C62v2Ev();
extern void _ZN7S2489C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2489C5__8S2489C10__A4__7S2489C1[] = {
  0,
  0,
  0,
  ABISELECT(1568,868),
  ABISELECT(85776,47832),
  (VTBL_ENTRY)&(_ZTI8S2489C10[0]),
  (VTBL_ENTRY)&_ZN7S2489C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2489C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2489C52v3Ev,
};
static  VTT_ENTRY vtt_S2489C1[] = {
  {&(_ZTV7S2489C1[13]),  13,254},
  {&(_tg__ZTV7S2489C2__7S2489C1[6]),  6,11},
  {&(_tg__ZTV7S2489C97S2489C2__7S2489C1[6]),  6,11},
  {&(_tg__ZTV8S2489C107S2489C97S2489C2__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C107S2489C97S2489C2__7S2489C1[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C107S2489C97S2489C2__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C107S2489C97S2489C2__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C6__7S2489C97S2489C2__7S2489C1[5]),  5,7},
  {&(_tg__ZTV7S2489C8__7S2489C97S2489C2__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C5__7S2489C97S2489C2__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C5__7S2489C2__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C8__7S2489C2__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A1__7S2489C2__7S2489C1[5]),  5,7},
  {&(_ZTV7S2489C1[24]),  24,254},
  {&(_ZTV7S2489C1[33]),  33,254},
  {&(_ZTV7S2489C1[41]),  41,254},
  {&(_ZTV7S2489C1[46]),  46,254},
  {&(_ZTV7S2489C1[65]),  65,254},
  {&(_ZTV7S2489C1[77]),  77,254},
  {&(_ZTV7S2489C1[124]),  124,254},
  {&(_ZTV7S2489C1[134]),  134,254},
  {&(_ZTV7S2489C1[143]),  143,254},
  {&(_ZTV7S2489C1[165]),  165,254},
  {&(_ZTV7S2489C1[152]),  152,254},
  {&(_ZTV7S2489C1[183]),  183,254},
  {&(_ZTV7S2489C1[192]),  192,254},
  {&(_ZTV7S2489C1[90]),  90,254},
  {&(_ZTV7S2489C1[213]),  213,254},
  {&(_ZTV7S2489C1[251]),  251,254},
  {&(_ZTV7S2489C1[223]),  223,254},
  {&(_ZTV7S2489C1[232]),  232,254},
  {&(_ZTV7S2489C1[241]),  241,254},
  {&(_ZTV7S2489C1[104]),  104,254},
  {&(_tg__ZTV7S2489C5__7S2489C1[3]),  3,6},
  {&(_tg__ZTV7S2489C67S2489C5__7S2489C1[3]),  3,5},
  {&(_tg__ZTV7S2489C8__7S2489C1[4]),  4,7},
  {&(_tg__ZTV7S2489C6__7S2489C8__7S2489C1[5]),  5,7},
  {&(_tg__ZTV7S2489C6__A1__7S2489C1[3]),  3,5},
  {&(_tg__ZTV8S2489C15__7S2489C1[12]),  12,14},
  {&(_tg__ZTV8S2489C148S2489C15__7S2489C1[6]),  6,8},
  {&(_tg__ZTV7S2489C5__8S2489C148S2489C15__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C8__8S2489C148S2489C15__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A1__8S2489C148S2489C15__7S2489C1[5]),  5,7},
  {&(_tg__ZTV8S2489C168S2489C15__7S2489C1[10]),  10,12},
  {&(_tg__ZTV8S2489C17__8S2489C168S2489C15__7S2489C1[18]),  18,22},
  {&(_tg__ZTV8S2489C198S2489C17__8S2489C168S2489C15__7S2489C1[6]),  6,12},
  {&(_tg__ZTV7S2489C8__8S2489C168S2489C15__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C168S2489C15__7S2489C1[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C168S2489C15__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C68S2489C198S2489C17__A2__8S2489C168S2489C15__7S2489C1[3]),  3,5},
  {&(_tg__ZTV8S2489C20__8S2489C168S2489C15__7S2489C1[11]),  11,16},
  {&(_tg__ZTV8S2489C13__8S2489C168S2489C15__7S2489C1[3]),  3,4},
  {&(_tg__ZTV8S2489C218S2489C17__8S2489C168S2489C15__7S2489C1[7]),  7,9},
  {&(_tg__ZTV8S2489C19__A1__8S2489C168S2489C15__7S2489C1[13]),  13,19},
  {&(_tg__ZTV7S2489C68S2489C19__A3__8S2489C168S2489C15__7S2489C1[3]),  3,5},
  {&(_tg__ZTV8S2489C228S2489C15__7S2489C1[11]),  11,18},
  {&(_tg__ZTV7S2489C58S2489C228S2489C15__A1__7S2489C1[3]),  3,6},
  {&(_tg__ZTV7S2489C67S2489C58S2489C228S2489C15__A5__7S2489C1[3]),  3,5},
  {&(_tg__ZTV8S2489C23__8S2489C228S2489C15__7S2489C1[19]),  19,23},
  {&(_tg__ZTV8S2489C10__8S2489C228S2489C15__7S2489C1[8]),  8,11},
  {&(_tg__ZTV7S2489C6__8S2489C228S2489C15__7S2489C1[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C228S2489C15__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C228S2489C15__7S2489C1[6]),  6,9},
  {&(_tg__ZTV8S2489C13__8S2489C228S2489C15__7S2489C1[3]),  3,4},
  {&(_tg__ZTV8S2489C198S2489C178S2489C23__8S2489C228S2489C15__7S2489C1[6]),  6,12},
  {&(_tg__ZTV7S2489C68S2489C198S2489C178S2489C23__A2__8S2489C228S2489C15__7S2489C1[3]),  3,5},
  {&(_tg__ZTV8S2489C20__8S2489C228S2489C15__7S2489C1[11]),  11,16},
  {&(_tg__ZTV8S2489C218S2489C178S2489C23__8S2489C228S2489C15__7S2489C1[7]),  7,9},
  {&(_tg__ZTV8S2489C19__A1__8S2489C228S2489C15__7S2489C1[13]),  13,19},
  {&(_tg__ZTV7S2489C68S2489C19__A3__8S2489C228S2489C15__7S2489C1[3]),  3,5},
  {&(_tg__ZTV8S2489C218S2489C15__A2__7S2489C1[7]),  7,9},
  {&(_tg__ZTV7S2489C6__8S2489C218S2489C15__A2__7S2489C1[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C218S2489C15__A2__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C218S2489C15__A2__7S2489C1[6]),  6,9},
  {&(_tg__ZTV8S2489C19__8S2489C218S2489C15__A2__7S2489C1[13]),  13,19},
  {&(_tg__ZTV7S2489C68S2489C19__A2__8S2489C218S2489C15__A2__7S2489C1[3]),  3,5},
  {&(_tg__ZTV7S2489C5__8S2489C15__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C8__8S2489C15__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A1__8S2489C15__7S2489C1[5]),  5,7},
  {&(_tg__ZTV8S2489C16__8S2489C15__7S2489C1[10]),  10,12},
  {&(_tg__ZTV8S2489C17__8S2489C15__7S2489C1[18]),  18,22},
  {&(_tg__ZTV8S2489C198S2489C17__8S2489C15__7S2489C1[6]),  6,12},
  {&(_tg__ZTV7S2489C68S2489C198S2489C17__A2__8S2489C15__7S2489C1[3]),  3,5},
  {&(_tg__ZTV8S2489C20__8S2489C15__7S2489C1[11]),  11,16},
  {&(_tg__ZTV8S2489C13__8S2489C15__7S2489C1[3]),  3,4},
  {&(_tg__ZTV8S2489C218S2489C17__8S2489C15__7S2489C1[7]),  7,9},
  {&(_tg__ZTV8S2489C19__A1__8S2489C15__7S2489C1[13]),  13,19},
  {&(_tg__ZTV7S2489C68S2489C19__A3__8S2489C15__7S2489C1[3]),  3,5},
  {&(_tg__ZTV8S2489C22__8S2489C15__7S2489C1[11]),  11,18},
  {&(_tg__ZTV8S2489C23__8S2489C15__7S2489C1[19]),  19,23},
  {&(_tg__ZTV8S2489C10__A3__8S2489C15__7S2489C1[8]),  8,11},
  {&(_tg__ZTV8S2489C198S2489C178S2489C23__A2__8S2489C15__7S2489C1[6]),  6,12},
  {&(_tg__ZTV7S2489C68S2489C198S2489C178S2489C23__A4__8S2489C15__7S2489C1[3]),  3,5},
  {&(_tg__ZTV8S2489C218S2489C178S2489C23__A1__8S2489C15__7S2489C1[7]),  7,9},
  {&(_tg__ZTV8S2489C21__A2__8S2489C15__7S2489C1[7]),  7,9},
  {&(_tg__ZTV8S2489C17__7S2489C1[9]),  9,13},
  {&(_tg__ZTV8S2489C198S2489C17__7S2489C1[6]),  6,12},
  {&(_tg__ZTV8S2489C108S2489C198S2489C17__A1__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C108S2489C198S2489C17__A1__7S2489C1[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C108S2489C198S2489C17__A1__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C108S2489C198S2489C17__A1__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C68S2489C198S2489C17__A2__7S2489C1[3]),  3,5},
  {&(_tg__ZTV7S2489C8__8S2489C198S2489C17__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C198S2489C17__7S2489C1[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C198S2489C17__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A__8S2489C198S2489C17__7S2489C1[3]),  3,5},
  {&(_tg__ZTV8S2489C218S2489C17__7S2489C1[7]),  7,9},
  {&(_tg__ZTV7S2489C6__8S2489C218S2489C17__7S2489C1[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C218S2489C17__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C218S2489C17__7S2489C1[6]),  6,9},
  {&(_tg__ZTV8S2489C19__8S2489C218S2489C17__7S2489C1[13]),  13,19},
  {&(_tg__ZTV7S2489C68S2489C19__A2__8S2489C218S2489C17__7S2489C1[3]),  3,5},
  {&(_tg__ZTV8S2489C19__A__8S2489C17__7S2489C1[6]),  6,12},
  {&(_tg__ZTV7S2489C8__8S2489C17__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C17__7S2489C1[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C17__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C68S2489C19__A2__8S2489C17__7S2489C1[3]),  3,5},
  {&(_tg__ZTV8S2489C20__8S2489C17__7S2489C1[11]),  11,16},
  {&(_tg__ZTV8S2489C13__8S2489C17__7S2489C1[3]),  3,4},
  {&(_tg__ZTV8S2489C21__8S2489C17__7S2489C1[7]),  7,9},
  {&(_tg__ZTV8S2489C19__A1__8S2489C17__7S2489C1[13]),  13,19},
  {&(_tg__ZTV7S2489C68S2489C19__A3__8S2489C17__7S2489C1[3]),  3,5},
  {&(_tg__ZTV8S2489C20__7S2489C1[7]),  7,12},
  {&(_tg__ZTV7S2489C98S2489C20__A1__7S2489C1[6]),  6,11},
  {&(_tg__ZTV8S2489C107S2489C98S2489C20__A2__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C107S2489C98S2489C20__A2__7S2489C1[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C107S2489C98S2489C20__A2__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C107S2489C98S2489C20__A2__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C6__7S2489C98S2489C20__A1__7S2489C1[5]),  5,7},
  {&(_tg__ZTV7S2489C8__7S2489C98S2489C20__A1__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C5__7S2489C98S2489C20__A1__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C20__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A1__8S2489C20__7S2489C1[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C20__7S2489C1[6]),  6,9},
  {&(_tg__ZTV8S2489C13__8S2489C20__7S2489C1[3]),  3,4},
  {&(_tg__ZTV8S2489C19__A1__7S2489C1[6]),  6,12},
  {&(_tg__ZTV8S2489C108S2489C19__A3__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C108S2489C19__A3__7S2489C1[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C108S2489C19__A3__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C108S2489C19__A3__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C68S2489C19__A3__7S2489C1[3]),  3,5},
  {&(_tg__ZTV7S2489C8__8S2489C19__A1__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C19__A1__7S2489C1[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C19__A1__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A__8S2489C19__A1__7S2489C1[3]),  3,5},
  {&(_tg__ZTV8S2489C23__7S2489C1[10]),  10,14},
  {&(_tg__ZTV8S2489C178S2489C23__A1__7S2489C1[9]),  9,13},
  {&(_tg__ZTV8S2489C198S2489C178S2489C23__A2__7S2489C1[6]),  6,12},
  {&(_tg__ZTV8S2489C108S2489C198S2489C178S2489C23__A5__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C108S2489C198S2489C178S2489C23__A5__7S2489C1[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C108S2489C198S2489C178S2489C23__A5__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C108S2489C198S2489C178S2489C23__A5__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C68S2489C198S2489C178S2489C23__A4__7S2489C1[3]),  3,5},
  {&(_tg__ZTV7S2489C8__8S2489C198S2489C178S2489C23__A2__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C198S2489C178S2489C23__A2__7S2489C1[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C198S2489C178S2489C23__A2__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C6__A__8S2489C198S2489C178S2489C23__A2__7S2489C1[3]),  3,5},
  {&(_tg__ZTV8S2489C218S2489C178S2489C23__A1__7S2489C1[7]),  7,9},
  {&(_tg__ZTV7S2489C6__8S2489C218S2489C178S2489C23__A1__7S2489C1[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C218S2489C178S2489C23__A1__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C218S2489C178S2489C23__A1__7S2489C1[6]),  6,9},
  {&(_tg__ZTV8S2489C19__8S2489C218S2489C178S2489C23__A1__7S2489C1[13]),  13,19},
  {&(_tg__ZTV7S2489C68S2489C19__A2__8S2489C218S2489C178S2489C23__A1__7S2489C1[3]),  3,5},
  {&(_tg__ZTV8S2489C19__A__8S2489C178S2489C23__A1__7S2489C1[6]),  6,12},
  {&(_tg__ZTV7S2489C8__8S2489C178S2489C23__A1__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C178S2489C23__A1__7S2489C1[5]),  5,7},
  {&(_tg__ZTV7S2489C5__8S2489C178S2489C23__A1__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C68S2489C19__A2__8S2489C178S2489C23__A1__7S2489C1[3]),  3,5},
  {&(_tg__ZTV8S2489C20__8S2489C178S2489C23__A1__7S2489C1[11]),  11,16},
  {&(_tg__ZTV8S2489C13__8S2489C178S2489C23__A1__7S2489C1[3]),  3,4},
  {&(_tg__ZTV8S2489C21__8S2489C178S2489C23__A1__7S2489C1[7]),  7,9},
  {&(_tg__ZTV8S2489C19__A1__8S2489C178S2489C23__A1__7S2489C1[13]),  13,19},
  {&(_tg__ZTV7S2489C68S2489C19__A3__8S2489C178S2489C23__A1__7S2489C1[3]),  3,5},
  {&(_tg__ZTV8S2489C10__8S2489C23__7S2489C1[8]),  8,11},
  {&(_tg__ZTV7S2489C6__8S2489C23__7S2489C1[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C23__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C23__7S2489C1[6]),  6,9},
  {&(_tg__ZTV8S2489C13__8S2489C23__7S2489C1[3]),  3,4},
  {&(_tg__ZTV8S2489C198S2489C17__8S2489C23__7S2489C1[6]),  6,12},
  {&(_tg__ZTV7S2489C68S2489C198S2489C17__A2__8S2489C23__7S2489C1[3]),  3,5},
  {&(_tg__ZTV8S2489C20__8S2489C23__7S2489C1[11]),  11,16},
  {&(_tg__ZTV8S2489C218S2489C17__8S2489C23__7S2489C1[7]),  7,9},
  {&(_tg__ZTV8S2489C19__A1__8S2489C23__7S2489C1[13]),  13,19},
  {&(_tg__ZTV7S2489C68S2489C19__A3__8S2489C23__7S2489C1[3]),  3,5},
  {&(_tg__ZTV8S2489C10__A4__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C6__8S2489C10__A4__7S2489C1[5]),  5,7},
  {&(_tg__ZTV7S2489C8__8S2489C10__A4__7S2489C1[6]),  6,9},
  {&(_tg__ZTV7S2489C5__8S2489C10__A4__7S2489C1[6]),  6,9},
};
extern VTBL_ENTRY _ZTI7S2489C1[];
extern  VTBL_ENTRY _ZTV7S2489C1[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2489C1[];
static VTBL_ENTRY alt_thunk_names14[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C23D0Ev,_ZTv0_n28_N8S2489C23D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6320_N8S2489C23D0Ev,_ZThn3536_N8S2489C23D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C23D1Ev,_ZTv0_n28_N8S2489C23D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn6320_N8S2489C23D1Ev,_ZThn3536_N8S2489C23D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C17D0Ev,_ZTv0_n28_N8S2489C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn55664_N8S2489C17D0Ev,_ZThn31032_N8S2489C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C17D1Ev,_ZTv0_n28_N8S2489C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn55664_N8S2489C17D1Ev,_ZThn31032_N8S2489C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C17D0Ev,_ZTv0_n32_N8S2489C17D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3456_N8S2489C17D0Ev,_ZThn1908_N8S2489C17D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C17D1Ev,_ZTv0_n32_N8S2489C17D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn3456_N8S2489C17D1Ev,_ZThn1908_N8S2489C17D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n88_N8S2489C15D0Ev,_ZTv0_n44_N8S2489C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn63280_N8S2489C15D0Ev,_ZThn35352_N8S2489C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n88_N8S2489C15D1Ev,_ZTv0_n44_N8S2489C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn63280_N8S2489C15D1Ev,_ZThn35352_N8S2489C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C15D0Ev,_ZTv0_n28_N8S2489C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn69600_N8S2489C15D0Ev,_ZThn38888_N8S2489C15D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn60672_N8S2489C15D0Ev,_ZThn33896_N8S2489C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C15D1Ev,_ZTv0_n28_N8S2489C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn69600_N8S2489C15D1Ev,_ZThn38888_N8S2489C15D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn60672_N8S2489C15D1Ev,_ZThn33896_N8S2489C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C15D0Ev,_ZTv0_n32_N8S2489C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8464_N8S2489C15D0Ev,_ZThn4772_N8S2489C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C15D1Ev,_ZTv0_n32_N8S2489C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8464_N8S2489C15D1Ev,_ZThn4772_N8S2489C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S2489C15D0Ev,_ZTv0_n40_N8S2489C15D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5008_N8S2489C15D0Ev,_ZThn2864_N8S2489C15D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S2489C15D1Ev,_ZTv0_n40_N8S2489C15D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5008_N8S2489C15D1Ev,_ZThn2864_N8S2489C15D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C21D0Ev,_ZTv0_n28_N8S2489C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn52960_N8S2489C21D0Ev,_ZThn29532_N8S2489C21D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn55984_N8S2489C21D0Ev,_ZThn31212_N8S2489C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C21D1Ev,_ZTv0_n28_N8S2489C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn52960_N8S2489C21D1Ev,_ZThn29532_N8S2489C21D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn55984_N8S2489C21D1Ev,_ZThn31212_N8S2489C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C22D0Ev,_ZTv0_n32_N8S2489C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5584_N8S2489C22D0Ev,_ZThn3120_N8S2489C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C22D1Ev,_ZTv0_n32_N8S2489C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn5584_N8S2489C22D1Ev,_ZThn3120_N8S2489C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C22D0Ev,_ZTv0_n28_N8S2489C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn57792_N8S2489C22D0Ev,_ZThn32244_N8S2489C22D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn66720_N8S2489C22D0Ev,_ZThn37236_N8S2489C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C22D1Ev,_ZTv0_n28_N8S2489C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn57792_N8S2489C22D1Ev,_ZThn32244_N8S2489C22D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn66720_N8S2489C22D1Ev,_ZThn37236_N8S2489C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n88_N8S2489C22D0Ev,_ZTv0_n44_N8S2489C22D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn60400_N8S2489C22D0Ev,_ZThn33700_N8S2489C22D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n88_N8S2489C22D1Ev,_ZTv0_n44_N8S2489C22D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn60400_N8S2489C22D1Ev,_ZThn33700_N8S2489C22D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C16D0Ev,_ZTv0_n28_N8S2489C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn60576_N8S2489C16D0Ev,_ZThn33852_N8S2489C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2489C16D1Ev,_ZTv0_n28_N8S2489C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn60576_N8S2489C16D1Ev,_ZThn33852_N8S2489C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C16D0Ev,_ZTv0_n32_N8S2489C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8368_N8S2489C16D0Ev,_ZThn4728_N8S2489C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N8S2489C16D1Ev,_ZTv0_n32_N8S2489C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn8368_N8S2489C16D1Ev,_ZThn4728_N8S2489C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S2489C16D0Ev,_ZTv0_n40_N8S2489C16D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4912_N8S2489C16D0Ev,_ZThn2820_N8S2489C16D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N8S2489C16D1Ev,_ZTv0_n40_N8S2489C16D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn4912_N8S2489C16D1Ev,_ZThn2820_N8S2489C16D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S2489C2D0Ev,_ZTv0_n20_N7S2489C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn70816_N7S2489C2D0Ev,_ZThn39472_N7S2489C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S2489C2D1Ev,_ZTv0_n20_N7S2489C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn70816_N7S2489C2D1Ev,_ZThn39472_N7S2489C2D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S2489C9D0Ev,_ZTv0_n20_N7S2489C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn70816_N7S2489C9D0Ev,_ZThn39472_N7S2489C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S2489C9D1Ev,_ZTv0_n20_N7S2489C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn70816_N7S2489C9D1Ev,_ZThn39472_N7S2489C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C10D0Ev,_ZTv0_n20_N8S2489C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn70816_N8S2489C10D0Ev,_ZThn39472_N8S2489C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2489C10D1Ev,_ZTv0_n20_N8S2489C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn70816_N8S2489C10D1Ev,_ZThn39472_N8S2489C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n88_N7S2489C1D0Ev,_ZTv0_n44_N7S2489C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn148576_N7S2489C1D0Ev,_ZThn82828_N7S2489C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n88_N7S2489C1D1Ev,_ZTv0_n44_N7S2489C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn148576_N7S2489C1D1Ev,_ZThn82828_N7S2489C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S2489C1D0Ev,_ZTv0_n28_N7S2489C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn154896_N7S2489C1D0Ev,_ZThn86364_N7S2489C1D0Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn145968_N7S2489C1D0Ev,_ZThn81372_N7S2489C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N7S2489C1D1Ev,_ZTv0_n28_N7S2489C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn154896_N7S2489C1D1Ev,_ZThn86364_N7S2489C1D1Ev),
  (VTBL_ENTRY)ABISELECT(_ZThn145968_N7S2489C1D1Ev,_ZThn81372_N7S2489C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S2489C1D0Ev,_ZTv0_n32_N7S2489C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn93760_N7S2489C1D0Ev,_ZThn52248_N7S2489C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n64_N7S2489C1D1Ev,_ZTv0_n32_N7S2489C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn93760_N7S2489C1D1Ev,_ZThn52248_N7S2489C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N7S2489C1D0Ev,_ZTv0_n40_N7S2489C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn90304_N7S2489C1D0Ev,_ZThn50340_N7S2489C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n80_N7S2489C1D1Ev,_ZTv0_n40_N7S2489C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn90304_N7S2489C1D1Ev,_ZThn50340_N7S2489C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n104_N7S2489C1D0Ev,_ZTv0_n52_N7S2489C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn85296_N7S2489C1D0Ev,_ZThn47476_N7S2489C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n104_N7S2489C1D1Ev,_ZTv0_n52_N7S2489C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn85296_N7S2489C1D1Ev,_ZThn47476_N7S2489C1D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S2489C1D0Ev,_ZTv0_n20_N7S2489C1D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn70816_N7S2489C1D0Ev,_ZThn39472_N7S2489C1D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S2489C1D1Ev,_ZTv0_n20_N7S2489C1D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn70816_N7S2489C1D1Ev,_ZThn39472_N7S2489C1D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S2489C1 = {  "S2489C1", // class name
  bases_S2489C1, 51,
  &(vtc_S2489C1[0]), // expected_vtbl_contents
  &(vtt_S2489C1[0]), // expected_vtt_contents
  ABISELECT(155184,86556), // object size
  NSPAIRA(_ZTI7S2489C1),ABISELECT(72,40), //typeinfo_var
  NSPAIRA(_ZTV7S2489C1),254, //virtual function table var
  13, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S2489C1),188, //virtual table table var
  35, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names14,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2488C6  : virtual S2489C3 {
  void *s2488c6f0;
  void *s2488c6f1;
  int s2488c6f2;
  int s2488c6f3;
  ::S2489C7 s2488c6f4;
  __tsi64  :0;
  long double s2488c6f6;
  ::S2489C7 s2488c6f7;
  void *s2488c6f8;
  __tsi64 s2488c6f9:3;
  ::S2489C3 s2488c6f10;
  long s2488c6f11;
  ::S2489C7 s2488c6f12;
  virtual void  v1(); // _ZN7S2488C62v1Ev
  virtual void  v2(); // _ZN7S2488C62v2Ev
  ~S2488C6(); // tgen
  S2488C6(); // tgen
};
//SIG(-1 S2488C6) C1{ VBC2{ m Fc Fi FL FU3{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} v1 v2 Fp Fp Fi Fi FU4{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU4 Fp FL:3 FC2 Fl FU4}


void  S2488C6 ::v1(){vfunc_called(this, "_ZN7S2488C62v1Ev");}
void  S2488C6 ::v2(){vfunc_called(this, "_ZN7S2488C62v2Ev");}
S2488C6 ::~S2488C6(){ note_dtor("S2488C6", this);} // tgen
S2488C6 ::S2488C6(){ note_ctor("S2488C6", this);} // tgen

static void Test_S2488C6()
{
  extern Class_Descriptor cd_S2488C6;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(33,69)];
    init_test(&cd_S2488C6, buf);
    S2488C6 *dp, &lv = *(dp=new (buf) S2488C6());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(512,272), "sizeof(S2488C6)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2488C6)");
    check_base_class_offset(lv, (S2489C3*), ABISELECT(384,200), "S2488C6");
    check_field_offset(lv, s2488c6f0, ABISELECT(8,4), "S2488C6.s2488c6f0");
    check_field_offset(lv, s2488c6f1, ABISELECT(16,8), "S2488C6.s2488c6f1");
    check_field_offset(lv, s2488c6f2, ABISELECT(24,12), "S2488C6.s2488c6f2");
    check_field_offset(lv, s2488c6f3, ABISELECT(28,16), "S2488C6.s2488c6f3");
    check_field_offset(lv, s2488c6f4, ABISELECT(32,20), "S2488C6.s2488c6f4");
    check_field_offset(lv, s2488c6f6, ABISELECT(96,48), "S2488C6.s2488c6f6");
    check_field_offset(lv, s2488c6f7, ABISELECT(112,60), "S2488C6.s2488c6f7");
    check_field_offset(lv, s2488c6f8, ABISELECT(168,88), "S2488C6.s2488c6f8");
    set_bf_and_test(lv, s2488c6f9, ABISELECT(176,92), 0, 3, 1, "S2488C6");
    set_bf_and_test(lv, s2488c6f9, ABISELECT(176,92), 0, 3, hide_sll(1LL<<2), "S2488C6");
    check_field_offset(lv, s2488c6f10, ABISELECT(192,96), "S2488C6.s2488c6f10");
    check_field_offset(lv, s2488c6f11, ABISELECT(320,168), "S2488C6.s2488c6f11");
    check_field_offset(lv, s2488c6f12, ABISELECT(328,172), "S2488C6.s2488c6f12");
    test_class_info(&lv, &cd_S2488C6);
    dp->~S2488C6();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2488C6(Test_S2488C6, "S2488C6", ABISELECT(512,272));

#else // __cplusplus

extern void _ZN7S2488C6C1Ev();
extern void _ZN7S2488C6D1Ev();
Name_Map name_map_S2488C6[] = {
  NSPAIR(_ZN7S2488C6C1Ev),
  NSPAIR(_ZN7S2488C6D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
static Base_Class bases_S2488C6[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C3,    ABISELECT(384,200), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S2488C6[];
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY vtc_S2488C6[] = {
  ABISELECT(384,200),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C6[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern VTBL_ENTRY _ZTV7S2488C6[];
static  VTT_ENTRY vtt_S2488C6[] = {
  {&(_ZTV7S2488C6[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7S2488C6[];
extern  VTBL_ENTRY _ZTV7S2488C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C6[];
Class_Descriptor cd_S2488C6 = {  "S2488C6", // class name
  bases_S2488C6, 1,
  &(vtc_S2488C6[0]), // expected_vtbl_contents
  &(vtt_S2488C6[0]), // expected_vtt_contents
  ABISELECT(512,272), // object size
  NSPAIRA(_ZTI7S2488C6),ABISELECT(40,24), //typeinfo_var
  NSPAIRA(_ZTV7S2488C6),5, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S2488C6),1, //virtual table table var
  0, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2488C5  : S2489C3 , S2488C6 {
  void *s2488c5f0;
  long double s2488c5f1;
  ::S2489C3 s2488c5f2[7];
  long double s2488c5f3;
  ::S2489C4 s2488c5f4;
  short s2488c5f5;
  long s2488c5f6;
  long s2488c5f7;
  virtual void  v3(); // _ZN7S2488C52v3Ev
  ~S2488C5(); // tgen
  S2488C5(); // tgen
};
//SIG(-1 S2488C5) C1{ BC2{ m Fc Fi FL FU3{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} BC4{ VBC2 v2 v3 Fp Fp Fi Fi FU5{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU5 Fp FL:3 FC2 Fl FU5} v1 Fp FD FC2[7] FD FU3 Fs Fl Fl}


void  S2488C5 ::v3(){vfunc_called(this, "_ZN7S2488C52v3Ev");}
S2488C5 ::~S2488C5(){ note_dtor("S2488C5", this);} // tgen
S2488C5 ::S2488C5(){ note_ctor("S2488C5", this);} // tgen

static void Test_S2488C5()
{
  extern Class_Descriptor cd_S2488C5;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(107,233)];
    init_test(&cd_S2488C5, buf);
    S2488C5 *dp, &lv = *(dp=new (buf) S2488C5());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(1696,928), "sizeof(S2488C5)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2488C5)");
    /*is_ambiguous_... S2488C5::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*), ABISELECT(384,200), "S2488C5");
    check_base_class_offset(lv, (S2489C3*)(S2488C6*), ABISELECT(1568,856), "S2488C5");
    check_base_class_offset(lv, (S2488C6*), 0, "S2488C5");
    check_field_offset(lv, s2488c5f0, ABISELECT(512,272), "S2488C5.s2488c5f0");
    check_field_offset(lv, s2488c5f1, ABISELECT(528,276), "S2488C5.s2488c5f1");
    check_field_offset(lv, s2488c5f2, ABISELECT(544,288), "S2488C5.s2488c5f2");
    check_field_offset(lv, s2488c5f3, ABISELECT(1440,792), "S2488C5.s2488c5f3");
    check_field_offset(lv, s2488c5f4, ABISELECT(1456,804), "S2488C5.s2488c5f4");
    check_field_offset(lv, s2488c5f5, ABISELECT(1536,844), "S2488C5.s2488c5f5");
    check_field_offset(lv, s2488c5f6, ABISELECT(1544,848), "S2488C5.s2488c5f6");
    check_field_offset(lv, s2488c5f7, ABISELECT(1552,852), "S2488C5.s2488c5f7");
    test_class_info(&lv, &cd_S2488C5);
    dp->~S2488C5();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2488C5(Test_S2488C5, "S2488C5", ABISELECT(1696,928));

#else // __cplusplus

extern void _ZN7S2488C5C1Ev();
extern void _ZN7S2488C5D1Ev();
Name_Map name_map_S2488C5[] = {
  NSPAIR(_ZN7S2488C5C1Ev),
  NSPAIR(_ZN7S2488C5D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2488C6;
extern VTBL_ENTRY _ZTI7S2488C6[];
extern  VTBL_ENTRY _ZTV7S2488C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C6[];
static Base_Class bases_S2488C5[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C3,    ABISELECT(384,200), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2489C3,    ABISELECT(1568,856), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S2488C6,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2488C5[];
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
static  VTBL_ENTRY vtc_S2488C5[] = {
  ABISELECT(1568,856),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C5[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
};
extern VTBL_ENTRY _ZTV7S2488C5[];
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__7S2488C5[] = {
  ABISELECT(1568,856),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C6[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
static  VTT_ENTRY vtt_S2488C5[] = {
  {&(_ZTV7S2488C5[3]),  3,6},
  {&(_tg__ZTV7S2488C6__7S2488C5[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7S2488C5[];
extern  VTBL_ENTRY _ZTV7S2488C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C5[];
Class_Descriptor cd_S2488C5 = {  "S2488C5", // class name
  bases_S2488C5, 3,
  &(vtc_S2488C5[0]), // expected_vtbl_contents
  &(vtt_S2488C5[0]), // expected_vtt_contents
  ABISELECT(1696,928), // object size
  NSPAIRA(_ZTI7S2488C5),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2488C5),6, //virtual function table var
  3, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S2488C5),2, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2488C8  : virtual S2489C3 , virtual S2488C6 {
  __tsi64 s2488c8f0;
  __tsi64 s2488c8f1;
  __tsi64 s2488c8f2;
  long s2488c8f3;
  int s2488c8f4;
  ::S2489C7 s2488c8f5;
  char s2488c8f6[10];
  int s2488c8f7;
  virtual  ~S2488C8(); // _ZN7S2488C8D2Ev
  virtual void  v4(); // _ZN7S2488C82v4Ev
  S2488C8(); // tgen
};
//SIG(-1 S2488C8) C1{ VBC2{ m Fc Fi FL FU3{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} VBC4{ VBC2 v2 v3 Fp Fp Fi Fi FU5{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU5 Fp FL:3 FC2 Fl FU5} vd v1 FL FL FL Fl Fi FU5 Fc[10] Fi}


 S2488C8 ::~S2488C8(){ note_dtor("S2488C8", this);}
void  S2488C8 ::v4(){vfunc_called(this, "_ZN7S2488C82v4Ev");}
S2488C8 ::S2488C8(){ note_ctor("S2488C8", this);} // tgen

static void Test_S2488C8()
{
  extern Class_Descriptor cd_S2488C8;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(41,89)];
    init_test(&cd_S2488C8, buf);
    S2488C8 *dp, &lv = *(dp=new (buf) S2488C8());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(640,352), "sizeof(S2488C8)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2488C8)");
    check_base_class_offset(lv, (S2489C3*), ABISELECT(128,80), "S2488C8");
    check_base_class_offset(lv, (S2489C3*)(S2488C6*), ABISELECT(128,80), "S2488C8");
    check_base_class_offset(lv, (S2488C6*), ABISELECT(256,152), "S2488C8");
    check_field_offset(lv, s2488c8f0, ABISELECT(8,4), "S2488C8.s2488c8f0");
    check_field_offset(lv, s2488c8f1, ABISELECT(16,12), "S2488C8.s2488c8f1");
    check_field_offset(lv, s2488c8f2, ABISELECT(24,20), "S2488C8.s2488c8f2");
    check_field_offset(lv, s2488c8f3, ABISELECT(32,28), "S2488C8.s2488c8f3");
    check_field_offset(lv, s2488c8f4, ABISELECT(40,32), "S2488C8.s2488c8f4");
    check_field_offset(lv, s2488c8f5, ABISELECT(48,36), "S2488C8.s2488c8f5");
    check_field_offset(lv, s2488c8f6, ABISELECT(104,64), "S2488C8.s2488c8f6");
    check_field_offset(lv, s2488c8f7, ABISELECT(116,76), "S2488C8.s2488c8f7");
    test_class_info(&lv, &cd_S2488C8);
    dp->~S2488C8();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2488C8(Test_S2488C8, "S2488C8", ABISELECT(640,352));

#else // __cplusplus

extern void _ZN7S2488C8C1Ev();
extern void _ZN7S2488C8D2Ev();
Name_Map name_map_S2488C8[] = {
  NSPAIR(_ZN7S2488C8C1Ev),
  NSPAIR(_ZN7S2488C8D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2488C6;
extern VTBL_ENTRY _ZTI7S2488C6[];
extern  VTBL_ENTRY _ZTV7S2488C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C6[];
static Base_Class bases_S2488C8[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C3,    ABISELECT(128,80), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2488C6,    ABISELECT(256,152), //bcp->offset
    7, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI7S2488C8[];
extern void _ZN7S2488C8D1Ev();
extern void _ZN7S2488C8D0Ev();
extern void _ZN7S2488C82v4Ev();
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY vtc_S2488C8[] = {
  ABISELECT(256,152),
  ABISELECT(128,80),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C8[0]),
  (VTBL_ENTRY)&_ZN7S2488C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2488C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-256,-152),
  (VTBL_ENTRY)&(_ZTI7S2488C8[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern VTBL_ENTRY _ZTV7S2488C8[];
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__7S2488C8[] = {
  ABISELECT(-128,-72),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C6[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
static  VTT_ENTRY vtt_S2488C8[] = {
  {&(_ZTV7S2488C8[4]),  4,14},
  {&(_ZTV7S2488C8[12]),  12,14},
  {&(_tg__ZTV7S2488C6__7S2488C8[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7S2488C8[];
extern  VTBL_ENTRY _ZTV7S2488C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C8[];
Class_Descriptor cd_S2488C8 = {  "S2488C8", // class name
  bases_S2488C8, 2,
  &(vtc_S2488C8[0]), // expected_vtbl_contents
  &(vtt_S2488C8[0]), // expected_vtt_contents
  ABISELECT(640,352), // object size
  NSPAIRA(_ZTI7S2488C8),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV7S2488C8),14, //virtual function table var
  4, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S2488C8),3, //virtual table table var
  1, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

union  S2488C11  {
  void *s2488c11f0;
  int s2488c11f1;
  void *s2488c11f2;
  char s2488c11f3;
  char s2488c11f4;
  long s2488c11f5[5];
  void *s2488c11f6;
  void *s2488c11f7;
  void *s2488c11f8;
  void  mf2488c11(); // _ZN8S2488C119mf2488c11Ev
};
//SIG(1 S2488C11) U1{ m Fp Fi Fp Fc Fc Fl[5] Fp Fp Fp}

#endif // __cplusplus
#ifdef __cplusplus

struct  S2488C10  : S2489C3 , virtual S2488C6 , virtual S2488C8 , virtual S2488C5 {
  char s2488c10f0;
  int s2488c10f1[7];
  long s2488c10f2[5];
  long s2488c10f3;
  __tsi64 s2488c10f4;
  __tsi64 s2488c10f5;
  ::S2488C11 s2488c10f6;
  virtual  ~S2488C10(); // _ZN8S2488C10D2Ev
  virtual void  v5(); // _ZN8S2488C102v5Ev
  S2488C10(); // tgen
};
//SIG(-1 S2488C10) C1{ BC2{ m Fc Fi FL FU3{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} VBC4{ VBC2 v2 v3 Fp Fp Fi Fi FU5{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU5 Fp FL:3 FC2 Fl FU5} VBC6{ VBC2 VBC4 vd v4 FL FL FL Fl Fi FU5 Fc[10] Fi} VBC7{ BC2 BC4 v5 Fp FD FC2[7] FD FU3 Fs Fl Fl} vd v1 Fc Fi[7] Fl[5] Fl FL FL FU8{ m Fp Fi Fp Fc Fc Fl[5] Fp Fp Fp}}


 S2488C10 ::~S2488C10(){ note_dtor("S2488C10", this);}
void  S2488C10 ::v5(){vfunc_called(this, "_ZN8S2488C102v5Ev");}
S2488C10 ::S2488C10(){ note_ctor("S2488C10", this);} // tgen

static void Test_S2488C10()
{
  extern Class_Descriptor cd_S2488C10;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(157,345)];
    init_test(&cd_S2488C10, buf);
    S2488C10 *dp, &lv = *(dp=new (buf) S2488C10());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2496,1376), "sizeof(S2488C10)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2488C10)");
    /*is_ambiguous_... S2488C10::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*), ABISELECT(16,4), "S2488C10");
    /*is_ambiguous_... S2488C10::S2488C6 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C6*), ABISELECT(672,368), "S2488C10");
    check_base_class_offset(lv, (S2489C3*)(S2488C8*), ABISELECT(672,368), "S2488C10");
    check_base_class_offset(lv, (S2489C3*)(S2488C6*)(S2488C5*), ABISELECT(672,368), "S2488C10");
    /*is_ambiguous_... S2488C10::S2488C6 */ AMB_check_base_class_offset(lv, (S2488C6*), ABISELECT(288,168), "S2488C10");
    check_base_class_offset(lv, (S2488C6*)(S2488C8*), ABISELECT(288,168), "S2488C10");
    check_base_class_offset(lv, (S2488C8*), ABISELECT(800,440), "S2488C10");
    /*is_ambiguous_... S2488C5::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C5*), ABISELECT(1312,720), "S2488C10");
    check_base_class_offset(lv, (S2488C6*)(S2488C5*), ABISELECT(928,520), "S2488C10");
    check_base_class_offset(lv, (S2488C5*), ABISELECT(928,520), "S2488C10");
    check_field_offset(lv, s2488c10f0, ABISELECT(144,76), "S2488C10.s2488c10f0");
    check_field_offset(lv, s2488c10f1, ABISELECT(148,80), "S2488C10.s2488c10f1");
    check_field_offset(lv, s2488c10f2, ABISELECT(176,108), "S2488C10.s2488c10f2");
    check_field_offset(lv, s2488c10f3, ABISELECT(216,128), "S2488C10.s2488c10f3");
    check_field_offset(lv, s2488c10f4, ABISELECT(224,132), "S2488C10.s2488c10f4");
    check_field_offset(lv, s2488c10f5, ABISELECT(232,140), "S2488C10.s2488c10f5");
    check_field_offset(lv, s2488c10f6, ABISELECT(240,148), "S2488C10.s2488c10f6");
    test_class_info(&lv, &cd_S2488C10);
    dp->~S2488C10();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2488C10(Test_S2488C10, "S2488C10", ABISELECT(2496,1376));

#else // __cplusplus

extern void _ZN8S2488C10C1Ev();
extern void _ZN8S2488C10D2Ev();
Name_Map name_map_S2488C10[] = {
  NSPAIR(_ZN8S2488C10C1Ev),
  NSPAIR(_ZN8S2488C10D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2488C6;
extern VTBL_ENTRY _ZTI7S2488C6[];
extern  VTBL_ENTRY _ZTV7S2488C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C6[];
extern Class_Descriptor cd_S2488C8;
extern VTBL_ENTRY _ZTI7S2488C8[];
extern  VTBL_ENTRY _ZTV7S2488C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C8[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2488C6;
extern VTBL_ENTRY _ZTI7S2488C6[];
extern  VTBL_ENTRY _ZTV7S2488C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C6[];
extern Class_Descriptor cd_S2488C5;
extern VTBL_ENTRY _ZTI7S2488C5[];
extern  VTBL_ENTRY _ZTV7S2488C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C5[];
static Base_Class bases_S2488C10[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C3,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2489C3,    ABISELECT(672,368), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S2488C6,    ABISELECT(288,168), //bcp->offset
    9, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2488C8,    ABISELECT(800,440), //bcp->offset
    16, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C3,    ABISELECT(1312,720), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2488C6,    ABISELECT(928,520), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2488C5,    ABISELECT(928,520), //bcp->offset
    25, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S2488C10[];
extern void _ZN8S2488C10D1Ev();
extern void _ZN8S2488C10D0Ev();
extern void _ZN8S2488C102v5Ev();
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void ABISELECT(_ZTv0_n40_N8S2488C10D1Ev,_ZTv0_n20_N8S2488C10D1Ev)();
extern void ABISELECT(_ZThn800_N8S2488C10D1Ev,_ZThn440_N8S2488C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2488C10D0Ev,_ZTv0_n20_N8S2488C10D0Ev)();
extern void ABISELECT(_ZThn800_N8S2488C10D0Ev,_ZThn440_N8S2488C10D0Ev)() __attribute__((weak));
extern void _ZN7S2488C82v4Ev();
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
static  VTBL_ENTRY vtc_S2488C10[] = {
  ABISELECT(928,520),
  ABISELECT(800,440),
  ABISELECT(672,368),
  ABISELECT(288,168),
  0,
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&_ZN8S2488C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2488C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2488C102v5Ev,
  0,
  0,
  ABISELECT(384,200),
  ABISELECT(-288,-168),
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  0,
  ABISELECT(-800,-440),
  ABISELECT(-512,-272),
  ABISELECT(-128,-72),
  ABISELECT(-800,-440),
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C10D1Ev,_ZTv0_n20_N8S2488C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C10D0Ev,_ZTv0_n20_N8S2488C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
  0,
  0,
  0,
  ABISELECT(-256,-152),
  ABISELECT(-928,-520),
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
};
extern VTBL_ENTRY _ZTV8S2488C10[];
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__8S2488C10[] = {
  ABISELECT(384,200),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C6[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void _ZN7S2488C8D1Ev();
extern void _ZN7S2488C8D0Ev();
extern void _ZN7S2488C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C8__8S2488C10[] = {
  ABISELECT(-512,-272),
  ABISELECT(-128,-72),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C8[0]),
  (VTBL_ENTRY)&_ZN7S2488C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2488C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__7S2488C8__8S2488C10[] = {
  0,
  0,
  ABISELECT(384,200),
  ABISELECT(512,272),
  (VTBL_ENTRY)&(_ZTI7S2488C8[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C5__8S2488C10[] = {
  ABISELECT(-256,-152),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C5[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C67S2488C5__A1__8S2488C10[] = {
  ABISELECT(-256,-152),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C6[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
static  VTT_ENTRY vtt_S2488C10[] = {
  {&(_ZTV8S2488C10[6]),  6,34},
  {&(_ZTV8S2488C10[14]),  14,34},
  {&(_ZTV8S2488C10[22]),  22,34},
  {&(_ZTV8S2488C10[31]),  31,34},
  {&(_tg__ZTV7S2488C6__8S2488C10[3]),  3,5},
  {&(_tg__ZTV7S2488C8__8S2488C10[4]),  4,7},
  {&(_tg__ZTV7S2488C6__7S2488C8__8S2488C10[5]),  5,7},
  {&(_tg__ZTV7S2488C5__8S2488C10[3]),  3,6},
  {&(_tg__ZTV7S2488C67S2488C5__A1__8S2488C10[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S2488C10[];
extern  VTBL_ENTRY _ZTV8S2488C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2488C10[];
static VTBL_ENTRY alt_thunk_names15[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2488C10D0Ev,_ZTv0_n20_N8S2488C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn800_N8S2488C10D0Ev,_ZThn440_N8S2488C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2488C10D1Ev,_ZTv0_n20_N8S2488C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn800_N8S2488C10D1Ev,_ZThn440_N8S2488C10D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S2488C10 = {  "S2488C10", // class name
  bases_S2488C10, 7,
  &(vtc_S2488C10[0]), // expected_vtbl_contents
  &(vtt_S2488C10[0]), // expected_vtt_contents
  ABISELECT(2496,1376), // object size
  NSPAIRA(_ZTI8S2488C10),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S2488C10),34, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S2488C10),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names15,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2488C9  : S2488C10 {
  void *s2488c9f0;
  void *s2488c9f1;
  void *s2488c9f2;
  int s2488c9f3;
  ::S2489C12_nt s2488c9f4;
  long s2488c9f5;
  long s2488c9f6;
  virtual  ~S2488C9(); // _ZN7S2488C9D2Ev
  virtual void  v6(); // _ZN7S2488C92v6Ev
  virtual void  v7(); // _ZN7S2488C92v7Ev
  S2488C9(); // tgen
};
//SIG(-1 S2488C9) C1{ BC2{ BC3{ m Fc Fi FL FU4{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} VBC5{ VBC3 v3 v4 Fp Fp Fi Fi FU6{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU6 Fp FL:3 FC3 Fl FU6} VBC7{ VBC3 VBC5 vd v5 FL FL FL Fl Fi FU6 Fc[10] Fi} VBC8{ BC3 BC5 v6 Fp FD FC3[7] FD FU4 Fs Fl Fl} vd v7 Fc Fi[7] Fl[5] Fl FL FL FU9{ m Fp Fi Fp Fc Fc Fl[5] Fp Fp Fp}} vd v1 v2 Fp Fp Fp Fi FC10{} Fl Fl}


 S2488C9 ::~S2488C9(){ note_dtor("S2488C9", this);}
void  S2488C9 ::v6(){vfunc_called(this, "_ZN7S2488C92v6Ev");}
void  S2488C9 ::v7(){vfunc_called(this, "_ZN7S2488C92v7Ev");}
S2488C9 ::S2488C9(){ note_ctor("S2488C9", this);} // tgen

static void Test_S2488C9()
{
  extern Class_Descriptor cd_S2488C9;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(160,352)];
    init_test(&cd_S2488C9, buf);
    S2488C9 *dp, &lv = *(dp=new (buf) S2488C9());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2544,1404), "sizeof(S2488C9)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2488C9)");
    /*is_ambiguous_... S2488C10::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C10*), ABISELECT(16,4), "S2488C9");
    /*is_ambiguous_... S2488C9::S2488C6 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C6*), ABISELECT(720,396), "S2488C9");
    check_base_class_offset(lv, (S2489C3*)(S2488C8*), ABISELECT(720,396), "S2488C9");
    check_base_class_offset(lv, (S2489C3*)(S2488C6*)(S2488C5*), ABISELECT(720,396), "S2488C9");
    /*is_ambiguous_... S2488C10::S2488C6 */ AMB_check_base_class_offset(lv, (S2488C6*)(S2488C10*), ABISELECT(336,196), "S2488C9");
    check_base_class_offset(lv, (S2488C6*)(S2488C8*), ABISELECT(336,196), "S2488C9");
    check_base_class_offset(lv, (S2488C8*)(S2488C10*), ABISELECT(848,468), "S2488C9");
    /*is_ambiguous_... S2488C5::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C5*), ABISELECT(1360,748), "S2488C9");
    check_base_class_offset(lv, (S2488C6*)(S2488C5*), ABISELECT(976,548), "S2488C9");
    check_base_class_offset(lv, (S2488C5*)(S2488C10*), ABISELECT(976,548), "S2488C9");
    check_base_class_offset(lv, (S2488C10*), 0, "S2488C9");
    check_field_offset(lv, s2488c9f0, ABISELECT(280,168), "S2488C9.s2488c9f0");
    check_field_offset(lv, s2488c9f1, ABISELECT(288,172), "S2488C9.s2488c9f1");
    check_field_offset(lv, s2488c9f2, ABISELECT(296,176), "S2488C9.s2488c9f2");
    check_field_offset(lv, s2488c9f3, ABISELECT(304,180), "S2488C9.s2488c9f3");
    check_field_offset(lv, s2488c9f4, ABISELECT(308,184), "S2488C9.s2488c9f4");
    check_field_offset(lv, s2488c9f5, ABISELECT(312,188), "S2488C9.s2488c9f5");
    check_field_offset(lv, s2488c9f6, ABISELECT(320,192), "S2488C9.s2488c9f6");
    test_class_info(&lv, &cd_S2488C9);
    dp->~S2488C9();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2488C9(Test_S2488C9, "S2488C9", ABISELECT(2544,1404));

#else // __cplusplus

extern void _ZN7S2488C9C1Ev();
extern void _ZN7S2488C9D2Ev();
Name_Map name_map_S2488C9[] = {
  NSPAIR(_ZN7S2488C9C1Ev),
  NSPAIR(_ZN7S2488C9D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2488C6;
extern VTBL_ENTRY _ZTI7S2488C6[];
extern  VTBL_ENTRY _ZTV7S2488C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C6[];
extern Class_Descriptor cd_S2488C8;
extern VTBL_ENTRY _ZTI7S2488C8[];
extern  VTBL_ENTRY _ZTV7S2488C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C8[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2488C6;
extern VTBL_ENTRY _ZTI7S2488C6[];
extern  VTBL_ENTRY _ZTV7S2488C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C6[];
extern Class_Descriptor cd_S2488C5;
extern VTBL_ENTRY _ZTI7S2488C5[];
extern  VTBL_ENTRY _ZTV7S2488C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C5[];
extern Class_Descriptor cd_S2488C10;
extern VTBL_ENTRY _ZTI8S2488C10[];
extern  VTBL_ENTRY _ZTV8S2488C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2488C10[];
static Base_Class bases_S2488C9[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C3,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(720,396), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S2488C6,    ABISELECT(336,196), //bcp->offset
    11, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S2488C8,    ABISELECT(848,468), //bcp->offset
    18, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S2489C3,    ABISELECT(1360,748), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2488C6,    ABISELECT(976,548), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2488C5,    ABISELECT(976,548), //bcp->offset
    27, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S2488C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2488C9[];
extern void _ZN7S2488C9D1Ev();
extern void _ZN7S2488C9D0Ev();
extern void _ZN8S2488C102v5Ev();
extern void _ZN7S2488C92v6Ev();
extern void _ZN7S2488C92v7Ev();
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void ABISELECT(_ZTv0_n40_N7S2488C9D1Ev,_ZTv0_n20_N7S2488C9D1Ev)();
extern void ABISELECT(_ZThn848_N7S2488C9D1Ev,_ZThn468_N7S2488C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S2488C9D0Ev,_ZTv0_n20_N7S2488C9D0Ev)();
extern void ABISELECT(_ZThn848_N7S2488C9D0Ev,_ZThn468_N7S2488C9D0Ev)() __attribute__((weak));
extern void _ZN7S2488C82v4Ev();
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
static  VTBL_ENTRY vtc_S2488C9[] = {
  ABISELECT(976,548),
  ABISELECT(848,468),
  ABISELECT(720,396),
  ABISELECT(336,196),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C9[0]),
  (VTBL_ENTRY)&_ZN7S2488C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2488C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2488C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2488C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2488C92v7Ev,
  0,
  0,
  ABISELECT(384,200),
  ABISELECT(-336,-196),
  (VTBL_ENTRY)&(_ZTI7S2488C9[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  0,
  ABISELECT(-848,-468),
  ABISELECT(-512,-272),
  ABISELECT(-128,-72),
  ABISELECT(-848,-468),
  (VTBL_ENTRY)&(_ZTI7S2488C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2488C9D1Ev,_ZTv0_n20_N7S2488C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2488C9D0Ev,_ZTv0_n20_N7S2488C9D0Ev),
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
  0,
  0,
  0,
  ABISELECT(-256,-152),
  ABISELECT(-976,-548),
  (VTBL_ENTRY)&(_ZTI7S2488C9[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
};
extern VTBL_ENTRY _ZTV7S2488C9[];
extern void _ZN8S2488C10D1Ev();
extern void _ZN8S2488C10D0Ev();
extern void _ZN8S2488C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2488C10__7S2488C9[] = {
  ABISELECT(976,548),
  ABISELECT(848,468),
  ABISELECT(720,396),
  ABISELECT(336,196),
  0,
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&_ZN8S2488C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2488C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2488C102v5Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__8S2488C10__7S2488C9[] = {
  0,
  0,
  ABISELECT(384,200),
  ABISELECT(-336,-196),
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2488C10D1Ev,_ZTv0_n20_N8S2488C10D1Ev)();
extern void ABISELECT(_ZThn848_N8S2488C10D1Ev,_ZThn468_N8S2488C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2488C10D0Ev,_ZTv0_n20_N8S2488C10D0Ev)();
extern void ABISELECT(_ZThn848_N8S2488C10D0Ev,_ZThn468_N8S2488C10D0Ev)() __attribute__((weak));
extern void _ZN7S2488C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C8__8S2488C10__7S2488C9[] = {
  0,
  ABISELECT(-848,-468),
  ABISELECT(-512,-272),
  ABISELECT(-128,-72),
  ABISELECT(-848,-468),
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C10D1Ev,_ZTv0_n20_N8S2488C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C10D0Ev,_ZTv0_n20_N8S2488C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C5__8S2488C10__7S2488C9[] = {
  0,
  0,
  0,
  ABISELECT(-256,-152),
  ABISELECT(-976,-548),
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__7S2488C9[] = {
  ABISELECT(384,200),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C6[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void _ZN7S2488C8D1Ev();
extern void _ZN7S2488C8D0Ev();
extern void _ZN7S2488C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C8__7S2488C9[] = {
  ABISELECT(-512,-272),
  ABISELECT(-128,-72),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C8[0]),
  (VTBL_ENTRY)&_ZN7S2488C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2488C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__7S2488C8__7S2488C9[] = {
  0,
  0,
  ABISELECT(384,200),
  ABISELECT(512,272),
  (VTBL_ENTRY)&(_ZTI7S2488C8[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C5__7S2488C9[] = {
  ABISELECT(-256,-152),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C5[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C67S2488C5__A1__7S2488C9[] = {
  ABISELECT(-256,-152),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C6[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
static  VTT_ENTRY vtt_S2488C9[] = {
  {&(_ZTV7S2488C9[6]),  6,36},
  {&(_tg__ZTV8S2488C10__7S2488C9[6]),  6,9},
  {&(_tg__ZTV7S2488C6__8S2488C10__7S2488C9[5]),  5,7},
  {&(_tg__ZTV7S2488C8__8S2488C10__7S2488C9[6]),  6,9},
  {&(_tg__ZTV7S2488C5__8S2488C10__7S2488C9[6]),  6,9},
  {&(_ZTV7S2488C9[16]),  16,36},
  {&(_ZTV7S2488C9[24]),  24,36},
  {&(_ZTV7S2488C9[33]),  33,36},
  {&(_tg__ZTV7S2488C6__7S2488C9[3]),  3,5},
  {&(_tg__ZTV7S2488C8__7S2488C9[4]),  4,7},
  {&(_tg__ZTV7S2488C6__7S2488C8__7S2488C9[5]),  5,7},
  {&(_tg__ZTV7S2488C5__7S2488C9[3]),  3,6},
  {&(_tg__ZTV7S2488C67S2488C5__A1__7S2488C9[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7S2488C9[];
extern  VTBL_ENTRY _ZTV7S2488C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C9[];
static VTBL_ENTRY alt_thunk_names16[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2488C10D0Ev,_ZTv0_n20_N8S2488C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn848_N8S2488C10D0Ev,_ZThn468_N8S2488C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2488C10D1Ev,_ZTv0_n20_N8S2488C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn848_N8S2488C10D1Ev,_ZThn468_N8S2488C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S2488C9D0Ev,_ZTv0_n20_N7S2488C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn848_N7S2488C9D0Ev,_ZThn468_N7S2488C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S2488C9D1Ev,_ZTv0_n20_N7S2488C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn848_N7S2488C9D1Ev,_ZThn468_N7S2488C9D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S2488C9 = {  "S2488C9", // class name
  bases_S2488C9, 8,
  &(vtc_S2488C9[0]), // expected_vtbl_contents
  &(vtt_S2488C9[0]), // expected_vtt_contents
  ABISELECT(2544,1404), // object size
  NSPAIRA(_ZTI7S2488C9),ABISELECT(24,12), //typeinfo_var
  NSPAIRA(_ZTV7S2488C9),36, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S2488C9),13, //virtual table table var
  5, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names16,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2488C2  : S2489C3 , virtual S2488C5 , virtual S2488C8 , S2488C9 {
  long double s2488c2f0;
  virtual  ~S2488C2(); // _ZN7S2488C2D2Ev
  S2488C2(); // tgen
};
//SIG(-1 S2488C2) C1{ BC2{ m Fc Fi FL FU3{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} VBC4{ BC2 BC5{ VBC2 v1 v2 Fp Fp Fi Fi FU6{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU6 Fp FL:3 FC2 Fl FU6} v3 Fp FD FC2[7] FD FU3 Fs Fl Fl} VBC7{ VBC2 VBC5 vd v4 FL FL FL Fl Fi FU6 Fc[10] Fi} BC8{ BC9{ BC2 VBC5 VBC7 VBC4 vd v5 Fc Fi[7] Fl[5] Fl FL FL FU10{ m Fp Fi Fp Fc Fc Fl[5] Fp Fp Fp}} vd v6 v7 Fp Fp Fp Fi FC11{} Fl Fl} vd FD}


 S2488C2 ::~S2488C2(){ note_dtor("S2488C2", this);}
S2488C2 ::S2488C2(){ note_ctor("S2488C2", this);} // tgen

static void Test_S2488C2()
{
  extern Class_Descriptor cd_S2488C2;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(169,373)];
    init_test(&cd_S2488C2, buf);
    S2488C2 *dp, &lv = *(dp=new (buf) S2488C2());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2688,1488), "sizeof(S2488C2)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2488C2)");
    /*is_ambiguous_... S2488C2::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*), ABISELECT(336,196), "S2488C2");
    /*is_ambiguous_... S2488C5::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C5*), ABISELECT(864,480), "S2488C2");
    check_base_class_offset(lv, (S2489C3*)(S2488C6*)(S2488C5*), ABISELECT(2048,1136), "S2488C2");
    check_base_class_offset(lv, (S2489C3*)(S2488C8*), ABISELECT(2048,1136), "S2488C2");
    /*is_ambiguous_... S2488C2::S2488C6 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C6*), ABISELECT(2048,1136), "S2488C2");
    check_base_class_offset(lv, (S2488C6*)(S2488C5*), ABISELECT(480,280), "S2488C2");
    check_base_class_offset(lv, (S2488C5*), ABISELECT(480,280), "S2488C2");
    check_base_class_offset(lv, (S2488C5*)(S2488C10*)(S2488C9*), ABISELECT(480,280), "S2488C2");
    check_base_class_offset(lv, (S2488C6*)(S2488C8*), ABISELECT(2304,1288), "S2488C2");
    /*is_ambiguous_... S2488C10::S2488C6 */ AMB_check_base_class_offset(lv, (S2488C6*)(S2488C10*)(S2488C9*), ABISELECT(2304,1288), "S2488C2");
    check_base_class_offset(lv, (S2488C8*), ABISELECT(2176,1208), "S2488C2");
    check_base_class_offset(lv, (S2488C8*)(S2488C10*)(S2488C9*), ABISELECT(2176,1208), "S2488C2");
    /*is_ambiguous_... S2488C10::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C10*)(S2488C9*), ABISELECT(16,4), "S2488C2");
    check_base_class_offset(lv, (S2488C10*)(S2488C9*), 0, "S2488C2");
    check_base_class_offset(lv, (S2488C9*), 0, "S2488C2");
    check_field_offset(lv, s2488c2f0, ABISELECT(464,268), "S2488C2.s2488c2f0");
    test_class_info(&lv, &cd_S2488C2);
    dp->~S2488C2();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2488C2(Test_S2488C2, "S2488C2", ABISELECT(2688,1488));

#else // __cplusplus

extern void _ZN7S2488C2C1Ev();
extern void _ZN7S2488C2D2Ev();
Name_Map name_map_S2488C2[] = {
  NSPAIR(_ZN7S2488C2C1Ev),
  NSPAIR(_ZN7S2488C2D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2488C6;
extern VTBL_ENTRY _ZTI7S2488C6[];
extern  VTBL_ENTRY _ZTV7S2488C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C6[];
extern Class_Descriptor cd_S2488C5;
extern VTBL_ENTRY _ZTI7S2488C5[];
extern  VTBL_ENTRY _ZTV7S2488C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C5[];
extern Class_Descriptor cd_S2488C6;
extern VTBL_ENTRY _ZTI7S2488C6[];
extern  VTBL_ENTRY _ZTV7S2488C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C6[];
extern Class_Descriptor cd_S2488C8;
extern VTBL_ENTRY _ZTI7S2488C8[];
extern  VTBL_ENTRY _ZTV7S2488C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C8[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2488C10;
extern VTBL_ENTRY _ZTI8S2488C10[];
extern  VTBL_ENTRY _ZTV8S2488C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2488C10[];
extern Class_Descriptor cd_S2488C9;
extern VTBL_ENTRY _ZTI7S2488C9[];
extern  VTBL_ENTRY _ZTV7S2488C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C9[];
static Base_Class bases_S2488C2[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C3,    ABISELECT(336,196), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2489C3,    ABISELECT(864,480), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(2048,1136), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S2488C6,    ABISELECT(480,280), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    4, //immediately_derived
  0, 0},
  {&cd_S2488C5,    ABISELECT(480,280), //bcp->offset
    11, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2488C6,    ABISELECT(2304,1288), //bcp->offset
    29, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 1},
  {&cd_S2488C8,    ABISELECT(2176,1208), //bcp->offset
    20, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C3,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S2488C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    9, //immediately_derived
  0, 0},
  {&cd_S2488C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI7S2488C2[];
extern void _ZN7S2488C2D1Ev();
extern void _ZN7S2488C2D0Ev();
extern void _ZN8S2488C102v5Ev();
extern void _ZN7S2488C92v6Ev();
extern void _ZN7S2488C92v7Ev();
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
extern void ABISELECT(_ZTv0_n40_N7S2488C2D1Ev,_ZTv0_n20_N7S2488C2D1Ev)();
extern void ABISELECT(_ZThn2176_N7S2488C2D1Ev,_ZThn1208_N7S2488C2D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S2488C2D0Ev,_ZTv0_n20_N7S2488C2D0Ev)();
extern void ABISELECT(_ZThn2176_N7S2488C2D0Ev,_ZThn1208_N7S2488C2D0Ev)() __attribute__((weak));
extern void _ZN7S2488C82v4Ev();
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY vtc_S2488C2[] = {
  ABISELECT(480,280),
  ABISELECT(2176,1208),
  ABISELECT(2048,1136),
  ABISELECT(2304,1288),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C2[0]),
  (VTBL_ENTRY)&_ZN7S2488C2D1Ev,
  (VTBL_ENTRY)&_ZN7S2488C2D0Ev,
  (VTBL_ENTRY)&_ZN8S2488C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2488C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2488C92v7Ev,
  0,
  0,
  0,
  ABISELECT(1568,856),
  ABISELECT(-480,-280),
  (VTBL_ENTRY)&(_ZTI7S2488C2[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
  0,
  ABISELECT(-2176,-1208),
  ABISELECT(128,80),
  ABISELECT(-128,-72),
  ABISELECT(-2176,-1208),
  (VTBL_ENTRY)&(_ZTI7S2488C2[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2488C2D1Ev,_ZTv0_n20_N7S2488C2D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2488C2D0Ev,_ZTv0_n20_N7S2488C2D0Ev),
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
  0,
  0,
  ABISELECT(-256,-152),
  ABISELECT(-2304,-1288),
  (VTBL_ENTRY)&(_ZTI7S2488C2[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern VTBL_ENTRY _ZTV7S2488C2[];
extern void _ZN7S2488C9D1Ev();
extern void _ZN7S2488C9D0Ev();
extern void _ZN8S2488C102v5Ev();
extern void _ZN7S2488C92v6Ev();
extern void _ZN7S2488C92v7Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C9__7S2488C2[] = {
  ABISELECT(480,280),
  ABISELECT(2176,1208),
  ABISELECT(2048,1136),
  ABISELECT(2304,1288),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C9[0]),
  (VTBL_ENTRY)&_ZN7S2488C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2488C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2488C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2488C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2488C92v7Ev,
};
extern void _ZN8S2488C10D1Ev();
extern void _ZN8S2488C10D0Ev();
extern void _ZN8S2488C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2488C107S2488C9__7S2488C2[] = {
  ABISELECT(480,280),
  ABISELECT(2176,1208),
  ABISELECT(2048,1136),
  ABISELECT(2304,1288),
  0,
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&_ZN8S2488C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2488C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2488C102v5Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__8S2488C107S2488C9__7S2488C2[] = {
  0,
  0,
  ABISELECT(-256,-152),
  ABISELECT(-2304,-1288),
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2488C10D1Ev,_ZTv0_n20_N8S2488C10D1Ev)();
extern void ABISELECT(_ZThn2176_N8S2488C10D1Ev,_ZThn1208_N8S2488C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2488C10D0Ev,_ZTv0_n20_N8S2488C10D0Ev)();
extern void ABISELECT(_ZThn2176_N8S2488C10D0Ev,_ZThn1208_N8S2488C10D0Ev)() __attribute__((weak));
extern void _ZN7S2488C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C8__8S2488C107S2488C9__7S2488C2[] = {
  0,
  ABISELECT(-2176,-1208),
  ABISELECT(128,80),
  ABISELECT(-128,-72),
  ABISELECT(-2176,-1208),
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C10D1Ev,_ZTv0_n20_N8S2488C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C10D0Ev,_ZTv0_n20_N8S2488C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C5__8S2488C107S2488C9__7S2488C2[] = {
  0,
  0,
  0,
  ABISELECT(1568,856),
  ABISELECT(-480,-280),
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__7S2488C9__7S2488C2[] = {
  0,
  0,
  ABISELECT(-256,-152),
  ABISELECT(-2304,-1288),
  (VTBL_ENTRY)&(_ZTI7S2488C9[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S2488C9D1Ev,_ZTv0_n20_N7S2488C9D1Ev)();
extern void ABISELECT(_ZThn2176_N7S2488C9D1Ev,_ZThn1208_N7S2488C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S2488C9D0Ev,_ZTv0_n20_N7S2488C9D0Ev)();
extern void ABISELECT(_ZThn2176_N7S2488C9D0Ev,_ZThn1208_N7S2488C9D0Ev)() __attribute__((weak));
extern void _ZN7S2488C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C8__7S2488C9__7S2488C2[] = {
  0,
  ABISELECT(-2176,-1208),
  ABISELECT(128,80),
  ABISELECT(-128,-72),
  ABISELECT(-2176,-1208),
  (VTBL_ENTRY)&(_ZTI7S2488C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2488C9D1Ev,_ZTv0_n20_N7S2488C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2488C9D0Ev,_ZTv0_n20_N7S2488C9D0Ev),
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C5__7S2488C9__7S2488C2[] = {
  0,
  0,
  0,
  ABISELECT(1568,856),
  ABISELECT(-480,-280),
  (VTBL_ENTRY)&(_ZTI7S2488C9[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C5__7S2488C2[] = {
  ABISELECT(1568,856),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C5[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C67S2488C5__7S2488C2[] = {
  ABISELECT(1568,856),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C6[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void _ZN7S2488C8D1Ev();
extern void _ZN7S2488C8D0Ev();
extern void _ZN7S2488C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C8__7S2488C2[] = {
  ABISELECT(128,80),
  ABISELECT(-128,-72),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C8[0]),
  (VTBL_ENTRY)&_ZN7S2488C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2488C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__7S2488C8__7S2488C2[] = {
  0,
  0,
  ABISELECT(-256,-152),
  ABISELECT(-128,-80),
  (VTBL_ENTRY)&(_ZTI7S2488C8[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__A1__7S2488C2[] = {
  ABISELECT(-256,-152),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C6[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
static  VTT_ENTRY vtt_S2488C2[] = {
  {&(_ZTV7S2488C2[6]),  6,36},
  {&(_tg__ZTV7S2488C9__7S2488C2[6]),  6,11},
  {&(_tg__ZTV8S2488C107S2488C9__7S2488C2[6]),  6,9},
  {&(_tg__ZTV7S2488C6__8S2488C107S2488C9__7S2488C2[5]),  5,7},
  {&(_tg__ZTV7S2488C8__8S2488C107S2488C9__7S2488C2[6]),  6,9},
  {&(_tg__ZTV7S2488C5__8S2488C107S2488C9__7S2488C2[6]),  6,9},
  {&(_tg__ZTV7S2488C6__7S2488C9__7S2488C2[5]),  5,7},
  {&(_tg__ZTV7S2488C8__7S2488C9__7S2488C2[6]),  6,9},
  {&(_tg__ZTV7S2488C5__7S2488C9__7S2488C2[6]),  6,9},
  {&(_ZTV7S2488C2[17]),  17,36},
  {&(_ZTV7S2488C2[26]),  26,36},
  {&(_ZTV7S2488C2[34]),  34,36},
  {&(_tg__ZTV7S2488C5__7S2488C2[3]),  3,6},
  {&(_tg__ZTV7S2488C67S2488C5__7S2488C2[3]),  3,5},
  {&(_tg__ZTV7S2488C8__7S2488C2[4]),  4,7},
  {&(_tg__ZTV7S2488C6__7S2488C8__7S2488C2[5]),  5,7},
  {&(_tg__ZTV7S2488C6__A1__7S2488C2[3]),  3,5},
};
extern VTBL_ENTRY _ZTI7S2488C2[];
extern  VTBL_ENTRY _ZTV7S2488C2[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C2[];
static VTBL_ENTRY alt_thunk_names17[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S2488C9D0Ev,_ZTv0_n20_N7S2488C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2176_N7S2488C9D0Ev,_ZThn1208_N7S2488C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S2488C9D1Ev,_ZTv0_n20_N7S2488C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2176_N7S2488C9D1Ev,_ZThn1208_N7S2488C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2488C10D0Ev,_ZTv0_n20_N8S2488C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2176_N8S2488C10D0Ev,_ZThn1208_N8S2488C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2488C10D1Ev,_ZTv0_n20_N8S2488C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2176_N8S2488C10D1Ev,_ZThn1208_N8S2488C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S2488C2D0Ev,_ZTv0_n20_N7S2488C2D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2176_N7S2488C2D0Ev,_ZThn1208_N7S2488C2D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S2488C2D1Ev,_ZTv0_n20_N7S2488C2D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2176_N7S2488C2D1Ev,_ZThn1208_N7S2488C2D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S2488C2 = {  "S2488C2", // class name
  bases_S2488C2, 10,
  &(vtc_S2488C2[0]), // expected_vtbl_contents
  &(vtt_S2488C2[0]), // expected_vtt_contents
  ABISELECT(2688,1488), // object size
  NSPAIRA(_ZTI7S2488C2),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV7S2488C2),36, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT7S2488C2),17, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names17,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2488C14  : virtual S2488C5 , virtual S2488C8 {
  int s2488c14f0;
  void *s2488c14f1;
  int s2488c14f2;
  ::S2489C7 s2488c14f3;
  ~S2488C14(); // tgen
  S2488C14(); // tgen
};
//SIG(-1 S2488C14) C1{ VBC2{ BC3{ m Fc Fi FL FU4{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} BC5{ VBC3 v1 v2 Fp Fp Fi Fi FU6{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU6 Fp FL:3 FC3 Fl FU6} v3 Fp FD FC3[7] FD FU4 Fs Fl Fl} VBC7{ VBC3 VBC5 vd v4 FL FL FL Fl Fi FU6 Fc[10] Fi} Fi Fp Fi FU6}


S2488C14 ::~S2488C14(){ note_dtor("S2488C14", this);} // tgen
S2488C14 ::S2488C14(){ note_ctor("S2488C14", this);} // tgen

static void Test_S2488C14()
{
  extern Class_Descriptor cd_S2488C14;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(145,314)];
    init_test(&cd_S2488C14, buf);
    S2488C14 *dp, &lv = *(dp=new (buf) S2488C14());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(2304,1252), "sizeof(S2488C14)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2488C14)");
    /*is_ambiguous_... S2488C5::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C5*), ABISELECT(480,244), "S2488C14");
    check_base_class_offset(lv, (S2489C3*)(S2488C6*)(S2488C5*), ABISELECT(1664,900), "S2488C14");
    check_base_class_offset(lv, (S2489C3*)(S2488C8*), ABISELECT(1664,900), "S2488C14");
    /*is_ambiguous_... S2488C14::S2488C6 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C6*), ABISELECT(1664,900), "S2488C14");
    check_base_class_offset(lv, (S2488C6*)(S2488C5*), ABISELECT(96,44), "S2488C14");
    check_base_class_offset(lv, (S2488C5*), ABISELECT(96,44), "S2488C14");
    check_base_class_offset(lv, (S2488C6*)(S2488C8*), ABISELECT(1920,1052), "S2488C14");
    check_base_class_offset(lv, (S2488C8*), ABISELECT(1792,972), "S2488C14");
    check_field_offset(lv, s2488c14f0, ABISELECT(8,4), "S2488C14.s2488c14f0");
    check_field_offset(lv, s2488c14f1, ABISELECT(16,8), "S2488C14.s2488c14f1");
    check_field_offset(lv, s2488c14f2, ABISELECT(24,12), "S2488C14.s2488c14f2");
    check_field_offset(lv, s2488c14f3, ABISELECT(32,16), "S2488C14.s2488c14f3");
    test_class_info(&lv, &cd_S2488C14);
    dp->~S2488C14();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2488C14(Test_S2488C14, "S2488C14", ABISELECT(2304,1252));

#else // __cplusplus

extern void _ZN8S2488C14C1Ev();
extern void _ZN8S2488C14D1Ev();
Name_Map name_map_S2488C14[] = {
  NSPAIR(_ZN8S2488C14C1Ev),
  NSPAIR(_ZN8S2488C14D1Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2488C6;
extern VTBL_ENTRY _ZTI7S2488C6[];
extern  VTBL_ENTRY _ZTV7S2488C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C6[];
extern Class_Descriptor cd_S2488C5;
extern VTBL_ENTRY _ZTI7S2488C5[];
extern  VTBL_ENTRY _ZTV7S2488C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C5[];
extern Class_Descriptor cd_S2488C6;
extern VTBL_ENTRY _ZTI7S2488C6[];
extern  VTBL_ENTRY _ZTV7S2488C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C6[];
extern Class_Descriptor cd_S2488C8;
extern VTBL_ENTRY _ZTI7S2488C8[];
extern  VTBL_ENTRY _ZTV7S2488C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C8[];
static Base_Class bases_S2488C14[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C3,    ABISELECT(480,244), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(1664,900), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S2488C6,    ABISELECT(96,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2488C5,    ABISELECT(96,44), //bcp->offset
    8, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    5, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2488C6,    ABISELECT(1920,1052), //bcp->offset
    26, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    9, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    5, //immediately_derived
  0, 1},
  {&cd_S2488C8,    ABISELECT(1792,972), //bcp->offset
    17, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S2488C14[];
extern void _ZN8S2488C14D1Ev();
extern void _ZN8S2488C14D0Ev();
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
extern void ABISELECT(_ZTv0_n40_N8S2488C14D1Ev,_ZTv0_n20_N8S2488C14D1Ev)();
extern void ABISELECT(_ZThn1792_N8S2488C14D1Ev,_ZThn972_N8S2488C14D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2488C14D0Ev,_ZTv0_n20_N8S2488C14D0Ev)();
extern void ABISELECT(_ZThn1792_N8S2488C14D0Ev,_ZThn972_N8S2488C14D0Ev)() __attribute__((weak));
extern void _ZN7S2488C82v4Ev();
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY vtc_S2488C14[] = {
  ABISELECT(1920,1052),
  ABISELECT(1792,972),
  ABISELECT(1664,900),
  ABISELECT(96,44),
  0,
  (VTBL_ENTRY)&(_ZTI8S2488C14[0]),
  (VTBL_ENTRY)&_ZN8S2488C14D1Ev,
  (VTBL_ENTRY)&_ZN8S2488C14D0Ev,
  0,
  0,
  0,
  ABISELECT(1568,856),
  ABISELECT(-96,-44),
  (VTBL_ENTRY)&(_ZTI8S2488C14[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
  0,
  ABISELECT(-1792,-972),
  ABISELECT(128,80),
  ABISELECT(-128,-72),
  ABISELECT(-1792,-972),
  (VTBL_ENTRY)&(_ZTI8S2488C14[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C14D1Ev,_ZTv0_n20_N8S2488C14D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C14D0Ev,_ZTv0_n20_N8S2488C14D0Ev),
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
  0,
  0,
  ABISELECT(-256,-152),
  ABISELECT(-1920,-1052),
  (VTBL_ENTRY)&(_ZTI8S2488C14[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern VTBL_ENTRY _ZTV8S2488C14[];
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C5__8S2488C14[] = {
  ABISELECT(1568,856),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C5[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C67S2488C5__8S2488C14[] = {
  ABISELECT(1568,856),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C6[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void _ZN7S2488C8D1Ev();
extern void _ZN7S2488C8D0Ev();
extern void _ZN7S2488C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C8__8S2488C14[] = {
  ABISELECT(128,80),
  ABISELECT(-128,-72),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C8[0]),
  (VTBL_ENTRY)&_ZN7S2488C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2488C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__7S2488C8__8S2488C14[] = {
  0,
  0,
  ABISELECT(-256,-152),
  ABISELECT(-128,-80),
  (VTBL_ENTRY)&(_ZTI7S2488C8[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__A1__8S2488C14[] = {
  ABISELECT(-256,-152),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C6[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
static  VTT_ENTRY vtt_S2488C14[] = {
  {&(_ZTV8S2488C14[6]),  6,33},
  {&(_ZTV8S2488C14[14]),  14,33},
  {&(_ZTV8S2488C14[23]),  23,33},
  {&(_ZTV8S2488C14[31]),  31,33},
  {&(_tg__ZTV7S2488C5__8S2488C14[3]),  3,6},
  {&(_tg__ZTV7S2488C67S2488C5__8S2488C14[3]),  3,5},
  {&(_tg__ZTV7S2488C8__8S2488C14[4]),  4,7},
  {&(_tg__ZTV7S2488C6__7S2488C8__8S2488C14[5]),  5,7},
  {&(_tg__ZTV7S2488C6__A1__8S2488C14[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S2488C14[];
extern  VTBL_ENTRY _ZTV8S2488C14[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2488C14[];
static VTBL_ENTRY alt_thunk_names18[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2488C14D0Ev,_ZTv0_n20_N8S2488C14D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1792_N8S2488C14D0Ev,_ZThn972_N8S2488C14D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2488C14D1Ev,_ZTv0_n20_N8S2488C14D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn1792_N8S2488C14D1Ev,_ZThn972_N8S2488C14D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S2488C14 = {  "S2488C14", // class name
  bases_S2488C14, 6,
  &(vtc_S2488C14[0]), // expected_vtbl_contents
  &(vtt_S2488C14[0]), // expected_vtt_contents
  ABISELECT(2304,1252), // object size
  NSPAIRA(_ZTI8S2488C14),ABISELECT(56,32), //typeinfo_var
  NSPAIRA(_ZTV8S2488C14),33, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S2488C14),9, //virtual table table var
  4, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names18,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2488C13  {
  long double s2488c13f0;
  ::S2488C14 s2488c13f1[6];
  char s2488c13f2;
  void *s2488c13f3;
  void *s2488c13f4;
  int s2488c13f5[6];
  int s2488c13f6;
  void *s2488c13f7;
  long s2488c13f8;
  void *s2488c13f9;
  int s2488c13f10;
  void *s2488c13f11;
  void *s2488c13f12;
  virtual void  v11(); // _ZN8S2488C133v11Ev
  ~S2488C13(); // tgen
  S2488C13(); // tgen
};
//SIG(-1 S2488C13) C1{ v1 FD FC2{ VBC3{ BC4{ m Fc Fi FL FU5{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} BC6{ VBC4 v2 v3 Fp Fp Fi Fi FU7{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU7 Fp FL:3 FC4 Fl FU7} v4 Fp FD FC4[7] FD FU5 Fs Fl Fl} VBC8{ VBC4 VBC6 vd v5 FL FL FL Fl Fi FU7 Fc[10] Fi} Fi Fp Fi FU7}[6] Fc Fp Fp Fi[6] Fi Fp Fl Fp Fi Fp Fp}


void  S2488C13 ::v11(){vfunc_called(this, "_ZN8S2488C133v11Ev");}
S2488C13 ::~S2488C13(){ note_dtor("S2488C13", this);} // tgen
S2488C13 ::S2488C13(){ note_ctor("S2488C13", this);} // tgen

static void Test_S2488C13()
{
  extern Class_Descriptor cd_S2488C13;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(874,1899)];
    init_test(&cd_S2488C13, buf);
    S2488C13 *dp, &lv = *(dp=new (buf) S2488C13());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(13968,7592), "sizeof(S2488C13)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2488C13)");
    check_field_offset(lv, s2488c13f0, ABISELECT(16,4), "S2488C13.s2488c13f0");
    check_field_offset(lv, s2488c13f1, ABISELECT(32,16), "S2488C13.s2488c13f1");
    check_field_offset(lv, s2488c13f2, ABISELECT(13856,7528), "S2488C13.s2488c13f2");
    check_field_offset(lv, s2488c13f3, ABISELECT(13864,7532), "S2488C13.s2488c13f3");
    check_field_offset(lv, s2488c13f4, ABISELECT(13872,7536), "S2488C13.s2488c13f4");
    check_field_offset(lv, s2488c13f5, ABISELECT(13880,7540), "S2488C13.s2488c13f5");
    check_field_offset(lv, s2488c13f6, ABISELECT(13904,7564), "S2488C13.s2488c13f6");
    check_field_offset(lv, s2488c13f7, ABISELECT(13912,7568), "S2488C13.s2488c13f7");
    check_field_offset(lv, s2488c13f8, ABISELECT(13920,7572), "S2488C13.s2488c13f8");
    check_field_offset(lv, s2488c13f9, ABISELECT(13928,7576), "S2488C13.s2488c13f9");
    check_field_offset(lv, s2488c13f10, ABISELECT(13936,7580), "S2488C13.s2488c13f10");
    check_field_offset(lv, s2488c13f11, ABISELECT(13944,7584), "S2488C13.s2488c13f11");
    check_field_offset(lv, s2488c13f12, ABISELECT(13952,7588), "S2488C13.s2488c13f12");
    test_class_info(&lv, &cd_S2488C13);
    dp->~S2488C13();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2488C13(Test_S2488C13, "S2488C13", ABISELECT(13968,7592));

#else // __cplusplus

extern void _ZN8S2488C13C1Ev();
extern void _ZN8S2488C13D1Ev();
Name_Map name_map_S2488C13[] = {
  NSPAIR(_ZN8S2488C13C1Ev),
  NSPAIR(_ZN8S2488C13D1Ev),
  {0,0}
};
extern VTBL_ENTRY _ZTI8S2488C13[];
extern void _ZN8S2488C133v11Ev();
static  VTBL_ENTRY vtc_S2488C13[] = {
  0,
  (VTBL_ENTRY)&(_ZTI8S2488C13[0]),
  (VTBL_ENTRY)&_ZN8S2488C133v11Ev,
};
extern VTBL_ENTRY _ZTI8S2488C13[];
extern  VTBL_ENTRY _ZTV8S2488C13[];
Class_Descriptor cd_S2488C13 = {  "S2488C13", // class name
  0,0,//no base classes
  &(vtc_S2488C13[0]), // expected_vtbl_contents
  0, //no vtt
  ABISELECT(13968,7592), // object size
  NSPAIRA(_ZTI8S2488C13),ABISELECT(16,8), //typeinfo_var
  NSPAIRA(_ZTV8S2488C13),3, //virtual function table var
  2, // offset into main vftv pointed to by object[0]
  {0,0},0, // virtual table table var
  0, // n_initialized_bases
  0, // has_virtual_bases
  1, // has_class_type_fields
  0, // alt-thunk-names
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2488C19  : virtual S2488C8 , S2488C10 , S2489C3 , S2488C6 {
  ::S2489C7 s2488c19f0;
  int s2488c19f1;
  long s2488c19f2;
  char s2488c19f3;
  void *s2488c19f4;
  ::S2488C5 s2488c19f5;
  short s2488c19f6;
  virtual  ~S2488C19(); // _ZN8S2488C19D2Ev
  virtual void  v8(); // _ZN8S2488C192v8Ev
  virtual void  v9(); // _ZN8S2488C192v9Ev
  virtual void  v10(); // _ZN8S2488C193v10Ev
  S2488C19(); // tgen
};
//SIG(-1 S2488C19) C1{ VBC2{ VBC3{ m Fc Fi FL FU4{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} VBC5{ VBC3 v4 v5 Fp Fp Fi Fi FU6{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU6 Fp FL:3 FC3 Fl FU6} vd v6 FL FL FL Fl Fi FU6 Fc[10] Fi} BC7{ BC3 VBC5 VBC2 VBC8{ BC3 BC5 v7 Fp FD FC3[7] FD FU4 Fs Fl Fl} vd v8 Fc Fi[7] Fl[5] Fl FL FL FU9{ m Fp Fi Fp Fc Fc Fl[5] Fp Fp Fp}} BC3 BC5 vd v1 v2 v3 FU6 Fi Fl Fc Fp FC8 Fs}


 S2488C19 ::~S2488C19(){ note_dtor("S2488C19", this);}
void  S2488C19 ::v8(){vfunc_called(this, "_ZN8S2488C192v8Ev");}
void  S2488C19 ::v9(){vfunc_called(this, "_ZN8S2488C192v9Ev");}
void  S2488C19 ::v10(){vfunc_called(this, "_ZN8S2488C193v10Ev");}
S2488C19 ::S2488C19(){ note_ctor("S2488C19", this);} // tgen

static void Test_S2488C19()
{
  extern Class_Descriptor cd_S2488C19;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(301,657)];
    init_test(&cd_S2488C19, buf);
    S2488C19 *dp, &lv = *(dp=new (buf) S2488C19());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(4800,2624), "sizeof(S2488C19)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2488C19)");
    check_base_class_offset(lv, (S2489C3*)(S2488C8*), ABISELECT(2720,1496), "S2488C19");
    /*is_ambiguous_... S2488C19::S2488C6 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C6*), ABISELECT(2720,1496), "S2488C19");
    check_base_class_offset(lv, (S2489C3*)(S2488C6*)(S2488C5*), ABISELECT(2720,1496), "S2488C19");
    /*is_ambiguous_... S2488C19::S2488C6 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C6*), ABISELECT(2720,1496), "S2488C19");
    check_base_class_offset(lv, (S2488C6*)(S2488C8*), ABISELECT(2848,1568), "S2488C19");
    /*is_ambiguous_... S2488C10::S2488C6 */ AMB_check_base_class_offset(lv, (S2488C6*)(S2488C10*), ABISELECT(2848,1568), "S2488C19");
    check_base_class_offset(lv, (S2488C8*), ABISELECT(2600,1416), "S2488C19");
    check_base_class_offset(lv, (S2488C8*)(S2488C10*), ABISELECT(2600,1416), "S2488C19");
    /*is_ambiguous_... S2488C10::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C10*), ABISELECT(16,4), "S2488C19");
    /*is_ambiguous_... S2488C5::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C5*), ABISELECT(3616,1968), "S2488C19");
    check_base_class_offset(lv, (S2488C6*)(S2488C5*), ABISELECT(3232,1768), "S2488C19");
    check_base_class_offset(lv, (S2488C5*)(S2488C10*), ABISELECT(3232,1768), "S2488C19");
    check_base_class_offset(lv, (S2488C10*), 0, "S2488C19");
    /*is_ambiguous_... S2488C19::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*), ABISELECT(288,168), "S2488C19");
    /*is_ambiguous_... S2488C19::S2488C6 */ AMB_check_base_class_offset(lv, (S2488C6*), ABISELECT(416,240), "S2488C19");
    check_field_offset(lv, s2488c19f0, ABISELECT(800,440), "S2488C19.s2488c19f0");
    check_field_offset(lv, s2488c19f1, ABISELECT(856,468), "S2488C19.s2488c19f1");
    check_field_offset(lv, s2488c19f2, ABISELECT(864,472), "S2488C19.s2488c19f2");
    check_field_offset(lv, s2488c19f3, ABISELECT(872,476), "S2488C19.s2488c19f3");
    check_field_offset(lv, s2488c19f4, ABISELECT(880,480), "S2488C19.s2488c19f4");
    check_field_offset(lv, s2488c19f5, ABISELECT(896,484), "S2488C19.s2488c19f5");
    check_field_offset(lv, s2488c19f6, ABISELECT(2592,1412), "S2488C19.s2488c19f6");
    test_class_info(&lv, &cd_S2488C19);
    dp->~S2488C19();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2488C19(Test_S2488C19, "S2488C19", ABISELECT(4800,2624));

#else // __cplusplus

extern void _ZN8S2488C19C1Ev();
extern void _ZN8S2488C19D2Ev();
Name_Map name_map_S2488C19[] = {
  NSPAIR(_ZN8S2488C19C1Ev),
  NSPAIR(_ZN8S2488C19D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2488C6;
extern VTBL_ENTRY _ZTI7S2488C6[];
extern  VTBL_ENTRY _ZTV7S2488C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C6[];
extern Class_Descriptor cd_S2488C8;
extern VTBL_ENTRY _ZTI7S2488C8[];
extern  VTBL_ENTRY _ZTV7S2488C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C8[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2488C6;
extern VTBL_ENTRY _ZTI7S2488C6[];
extern  VTBL_ENTRY _ZTV7S2488C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C6[];
extern Class_Descriptor cd_S2488C5;
extern VTBL_ENTRY _ZTI7S2488C5[];
extern  VTBL_ENTRY _ZTV7S2488C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C5[];
extern Class_Descriptor cd_S2488C10;
extern VTBL_ENTRY _ZTI8S2488C10[];
extern  VTBL_ENTRY _ZTV8S2488C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2488C10[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2488C6;
extern VTBL_ENTRY _ZTI7S2488C6[];
extern  VTBL_ENTRY _ZTV7S2488C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C6[];
static Base_Class bases_S2488C19[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C3,    ABISELECT(2720,1496), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    1, //immediately_derived
  0, 1},
  {&cd_S2488C6,    ABISELECT(2848,1568), //bcp->offset
    26, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    8, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S2488C8,    ABISELECT(2600,1416), //bcp->offset
    17, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    7, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C3,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(3616,1968), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2488C6,    ABISELECT(3232,1768), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2488C5,    ABISELECT(3232,1768), //bcp->offset
    33, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    9, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    7, //immediately_derived
  0, 1},
  {&cd_S2488C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2489C3,    ABISELECT(288,168), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2488C6,    ABISELECT(416,240), //bcp->offset
    12, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    6, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S2488C19[];
extern void _ZN8S2488C19D1Ev();
extern void _ZN8S2488C19D0Ev();
extern void _ZN8S2488C102v5Ev();
extern void _ZN8S2488C192v8Ev();
extern void _ZN8S2488C192v9Ev();
extern void _ZN8S2488C193v10Ev();
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void ABISELECT(_ZTv0_n40_N8S2488C19D1Ev,_ZTv0_n20_N8S2488C19D1Ev)();
extern void ABISELECT(_ZThn2600_N8S2488C19D1Ev,_ZThn1416_N8S2488C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2488C19D0Ev,_ZTv0_n20_N8S2488C19D0Ev)();
extern void ABISELECT(_ZThn2600_N8S2488C19D0Ev,_ZThn1416_N8S2488C19D0Ev)() __attribute__((weak));
extern void _ZN7S2488C82v4Ev();
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
static  VTBL_ENTRY vtc_S2488C19[] = {
  ABISELECT(3232,1768),
  ABISELECT(2600,1416),
  ABISELECT(2720,1496),
  ABISELECT(2848,1568),
  0,
  (VTBL_ENTRY)&(_ZTI8S2488C19[0]),
  (VTBL_ENTRY)&_ZN8S2488C19D1Ev,
  (VTBL_ENTRY)&_ZN8S2488C19D0Ev,
  (VTBL_ENTRY)&_ZN8S2488C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2488C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2488C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2488C193v10Ev,
  ABISELECT(2304,1256),
  ABISELECT(-416,-240),
  (VTBL_ENTRY)&(_ZTI8S2488C19[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  0,
  ABISELECT(-2600,-1416),
  ABISELECT(248,152),
  ABISELECT(120,80),
  ABISELECT(-2600,-1416),
  (VTBL_ENTRY)&(_ZTI8S2488C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C19D1Ev,_ZTv0_n20_N8S2488C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C19D0Ev,_ZTv0_n20_N8S2488C19D0Ev),
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-2848,-1568),
  (VTBL_ENTRY)&(_ZTI8S2488C19[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  0,
  0,
  0,
  ABISELECT(-512,-272),
  ABISELECT(-3232,-1768),
  (VTBL_ENTRY)&(_ZTI8S2488C19[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
};
extern VTBL_ENTRY _ZTV8S2488C19[];
extern void _ZN8S2488C10D1Ev();
extern void _ZN8S2488C10D0Ev();
extern void _ZN8S2488C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2488C10__8S2488C19[] = {
  ABISELECT(3232,1768),
  ABISELECT(2600,1416),
  ABISELECT(2720,1496),
  ABISELECT(2848,1568),
  0,
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&_ZN8S2488C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2488C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2488C102v5Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__8S2488C10__8S2488C19[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-2848,-1568),
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2488C10D1Ev,_ZTv0_n20_N8S2488C10D1Ev)();
extern void ABISELECT(_ZThn2600_N8S2488C10D1Ev,_ZThn1416_N8S2488C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2488C10D0Ev,_ZTv0_n20_N8S2488C10D0Ev)();
extern void ABISELECT(_ZThn2600_N8S2488C10D0Ev,_ZThn1416_N8S2488C10D0Ev)() __attribute__((weak));
extern void _ZN7S2488C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C8__8S2488C10__8S2488C19[] = {
  0,
  ABISELECT(-2600,-1416),
  ABISELECT(248,152),
  ABISELECT(120,80),
  ABISELECT(-2600,-1416),
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C10D1Ev,_ZTv0_n20_N8S2488C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C10D0Ev,_ZTv0_n20_N8S2488C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C5__8S2488C10__8S2488C19[] = {
  0,
  0,
  0,
  ABISELECT(-512,-272),
  ABISELECT(-3232,-1768),
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__A__8S2488C19[] = {
  ABISELECT(2304,1256),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C6[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void _ZN7S2488C8D1Ev();
extern void _ZN7S2488C8D0Ev();
extern void _ZN7S2488C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C8__8S2488C19[] = {
  ABISELECT(248,152),
  ABISELECT(120,80),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C8[0]),
  (VTBL_ENTRY)&_ZN7S2488C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2488C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__7S2488C8__8S2488C19[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-248,-152),
  (VTBL_ENTRY)&(_ZTI7S2488C8[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__8S2488C19[] = {
  ABISELECT(-128,-72),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C6[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C5__8S2488C19[] = {
  ABISELECT(-512,-272),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C5[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C67S2488C5__A1__8S2488C19[] = {
  ABISELECT(-512,-272),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C6[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
static  VTT_ENTRY vtt_S2488C19[] = {
  {&(_ZTV8S2488C19[6]),  6,42},
  {&(_tg__ZTV8S2488C10__8S2488C19[6]),  6,9},
  {&(_tg__ZTV7S2488C6__8S2488C10__8S2488C19[5]),  5,7},
  {&(_tg__ZTV7S2488C8__8S2488C10__8S2488C19[6]),  6,9},
  {&(_tg__ZTV7S2488C5__8S2488C10__8S2488C19[6]),  6,9},
  {&(_tg__ZTV7S2488C6__A__8S2488C19[3]),  3,5},
  {&(_ZTV8S2488C19[23]),  23,42},
  {&(_ZTV8S2488C19[31]),  31,42},
  {&(_ZTV8S2488C19[39]),  39,42},
  {&(_ZTV8S2488C19[15]),  15,42},
  {&(_tg__ZTV7S2488C8__8S2488C19[4]),  4,7},
  {&(_tg__ZTV7S2488C6__7S2488C8__8S2488C19[5]),  5,7},
  {&(_tg__ZTV7S2488C6__8S2488C19[3]),  3,5},
  {&(_tg__ZTV7S2488C5__8S2488C19[3]),  3,6},
  {&(_tg__ZTV7S2488C67S2488C5__A1__8S2488C19[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S2488C19[];
extern  VTBL_ENTRY _ZTV8S2488C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2488C19[];
static VTBL_ENTRY alt_thunk_names19[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2488C10D0Ev,_ZTv0_n20_N8S2488C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2600_N8S2488C10D0Ev,_ZThn1416_N8S2488C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2488C10D1Ev,_ZTv0_n20_N8S2488C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2600_N8S2488C10D1Ev,_ZThn1416_N8S2488C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2488C19D0Ev,_ZTv0_n20_N8S2488C19D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2600_N8S2488C19D0Ev,_ZThn1416_N8S2488C19D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2488C19D1Ev,_ZTv0_n20_N8S2488C19D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2600_N8S2488C19D1Ev,_ZThn1416_N8S2488C19D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S2488C19 = {  "S2488C19", // class name
  bases_S2488C19, 10,
  &(vtc_S2488C19[0]), // expected_vtbl_contents
  &(vtt_S2488C19[0]), // expected_vtt_contents
  ABISELECT(4800,2624), // object size
  NSPAIRA(_ZTI8S2488C19),ABISELECT(88,48), //typeinfo_var
  NSPAIRA(_ZTV8S2488C19),42, //virtual function table var
  6, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S2488C19),15, //virtual table table var
  6, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names19,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2488C21  : S2489C3 , virtual S2488C6 , virtual S2488C8 , virtual S2488C5 , virtual S2488C19 {
  __tsi64 s2488c21f0;
  int s2488c21f1;
  void *s2488c21f2;
  void *s2488c21f3;
  long s2488c21f4;
  virtual  ~S2488C21(); // _ZN8S2488C21D2Ev
  S2488C21(); // tgen
};
//SIG(-1 S2488C21) C1{ BC2{ m Fc Fi FL FU3{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} VBC4{ VBC2 v1 v2 Fp Fp Fi Fi FU5{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU5 Fp FL:3 FC2 Fl FU5} VBC6{ VBC2 VBC4 vd v3 FL FL FL Fl Fi FU5 Fc[10] Fi} VBC7{ BC2 BC4 v4 Fp FD FC2[7] FD FU3 Fs Fl Fl} VBC8{ VBC6 BC9{ BC2 VBC4 VBC6 VBC7 vd v5 Fc Fi[7] Fl[5] Fl FL FL FU10{ m Fp Fi Fp Fc Fc Fl[5] Fp Fp Fp}} BC2 BC4 vd v6 v7 v8 FU5 Fi Fl Fc Fp FC7 Fs} vd FL Fi Fp Fp Fl}


 S2488C21 ::~S2488C21(){ note_dtor("S2488C21", this);}
S2488C21 ::S2488C21(){ note_ctor("S2488C21", this);} // tgen

static void Test_S2488C21()
{
  extern Class_Descriptor cd_S2488C21;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(314,682)];
    init_test(&cd_S2488C21, buf);
    S2488C21 *dp, &lv = *(dp=new (buf) S2488C21());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(5008,2724), "sizeof(S2488C21)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2488C21)");
    /*is_ambiguous_... S2488C21::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*), ABISELECT(16,4), "S2488C21");
    /*is_ambiguous_... S2488C21::S2488C6 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C6*), ABISELECT(576,300), "S2488C21");
    check_base_class_offset(lv, (S2489C3*)(S2488C8*), ABISELECT(576,300), "S2488C21");
    check_base_class_offset(lv, (S2489C3*)(S2488C6*)(S2488C5*), ABISELECT(576,300), "S2488C21");
    /*is_ambiguous_... S2488C19::S2488C6 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C6*)(S2488C19*), ABISELECT(576,300), "S2488C21");
    /*is_ambiguous_... S2488C21::S2488C6 */ AMB_check_base_class_offset(lv, (S2488C6*), ABISELECT(192,100), "S2488C21");
    check_base_class_offset(lv, (S2488C6*)(S2488C8*), ABISELECT(192,100), "S2488C21");
    /*is_ambiguous_... S2488C10::S2488C6 */ AMB_check_base_class_offset(lv, (S2488C6*)(S2488C10*)(S2488C19*), ABISELECT(192,100), "S2488C21");
    check_base_class_offset(lv, (S2488C8*), ABISELECT(704,372), "S2488C21");
    check_base_class_offset(lv, (S2488C8*)(S2488C19*), ABISELECT(704,372), "S2488C21");
    check_base_class_offset(lv, (S2488C8*)(S2488C10*)(S2488C19*), ABISELECT(704,372), "S2488C21");
    /*is_ambiguous_... S2488C5::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C5*), ABISELECT(1216,652), "S2488C21");
    check_base_class_offset(lv, (S2488C6*)(S2488C5*), ABISELECT(832,452), "S2488C21");
    check_base_class_offset(lv, (S2488C5*), ABISELECT(832,452), "S2488C21");
    check_base_class_offset(lv, (S2488C5*)(S2488C10*)(S2488C19*), ABISELECT(832,452), "S2488C21");
    /*is_ambiguous_... S2488C10::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C10*)(S2488C19*), ABISELECT(2416,1312), "S2488C21");
    check_base_class_offset(lv, (S2488C10*)(S2488C19*), ABISELECT(2400,1308), "S2488C21");
    /*is_ambiguous_... S2488C19::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C19*), ABISELECT(2688,1476), "S2488C21");
    /*is_ambiguous_... S2488C19::S2488C6 */ AMB_check_base_class_offset(lv, (S2488C6*)(S2488C19*), ABISELECT(2816,1548), "S2488C21");
    check_base_class_offset(lv, (S2488C19*), ABISELECT(2400,1308), "S2488C21");
    check_field_offset(lv, s2488c21f0, ABISELECT(144,76), "S2488C21.s2488c21f0");
    check_field_offset(lv, s2488c21f1, ABISELECT(152,84), "S2488C21.s2488c21f1");
    check_field_offset(lv, s2488c21f2, ABISELECT(160,88), "S2488C21.s2488c21f2");
    check_field_offset(lv, s2488c21f3, ABISELECT(168,92), "S2488C21.s2488c21f3");
    check_field_offset(lv, s2488c21f4, ABISELECT(176,96), "S2488C21.s2488c21f4");
    test_class_info(&lv, &cd_S2488C21);
    dp->~S2488C21();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2488C21(Test_S2488C21, "S2488C21", ABISELECT(5008,2724));

#else // __cplusplus

extern void _ZN8S2488C21C1Ev();
extern void _ZN8S2488C21D2Ev();
Name_Map name_map_S2488C21[] = {
  NSPAIR(_ZN8S2488C21C1Ev),
  NSPAIR(_ZN8S2488C21D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2488C6;
extern VTBL_ENTRY _ZTI7S2488C6[];
extern  VTBL_ENTRY _ZTV7S2488C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C6[];
extern Class_Descriptor cd_S2488C8;
extern VTBL_ENTRY _ZTI7S2488C8[];
extern  VTBL_ENTRY _ZTV7S2488C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C8[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2488C6;
extern VTBL_ENTRY _ZTI7S2488C6[];
extern  VTBL_ENTRY _ZTV7S2488C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C6[];
extern Class_Descriptor cd_S2488C5;
extern VTBL_ENTRY _ZTI7S2488C5[];
extern  VTBL_ENTRY _ZTV7S2488C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C5[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2488C10;
extern VTBL_ENTRY _ZTI8S2488C10[];
extern  VTBL_ENTRY _ZTV8S2488C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2488C10[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2488C6;
extern VTBL_ENTRY _ZTI7S2488C6[];
extern  VTBL_ENTRY _ZTV7S2488C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C6[];
extern Class_Descriptor cd_S2488C19;
extern VTBL_ENTRY _ZTI8S2488C19[];
extern  VTBL_ENTRY _ZTV8S2488C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2488C19[];
static Base_Class bases_S2488C21[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C3,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2489C3,    ABISELECT(576,300), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S2488C6,    ABISELECT(192,100), //bcp->offset
    9, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    2, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2488C8,    ABISELECT(704,372), //bcp->offset
    16, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    3, //bcp->index_in_construction_vtbl_array
    8, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C3,    ABISELECT(1216,652), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2488C6,    ABISELECT(832,452), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    11, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    6, //immediately_derived
  0, 0},
  {&cd_S2488C5,    ABISELECT(832,452), //bcp->offset
    25, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    4, //bcp->index_in_construction_vtbl_array
    10, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C3,    ABISELECT(2416,1312), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S2488C10,    ABISELECT(2400,1308), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    13, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(2688,1476), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S2488C6,    ABISELECT(2816,1548), //bcp->offset
    53, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    6, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S2488C19,    ABISELECT(2400,1308), //bcp->offset
    34, //bcp->virtual_function_table_offset
    13, //num_negative_vtable_entries(t, bcp)
    5, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S2488C21[];
extern void _ZN8S2488C21D1Ev();
extern void _ZN8S2488C21D0Ev();
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void ABISELECT(_ZTv0_n40_N8S2488C21D1Ev,_ZTv0_n20_N8S2488C21D1Ev)();
extern void ABISELECT(_ZThn704_N8S2488C21D1Ev,_ZThn372_N8S2488C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2488C21D0Ev,_ZTv0_n20_N8S2488C21D0Ev)();
extern void ABISELECT(_ZThn704_N8S2488C21D0Ev,_ZThn372_N8S2488C21D0Ev)() __attribute__((weak));
extern void _ZN7S2488C82v4Ev();
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
extern void ABISELECT(_ZTv0_n56_N8S2488C21D1Ev,_ZTv0_n28_N8S2488C21D1Ev)();
extern void ABISELECT(_ZThn2400_N8S2488C21D1Ev,_ZThn1308_N8S2488C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2488C21D0Ev,_ZTv0_n28_N8S2488C21D0Ev)();
extern void ABISELECT(_ZThn2400_N8S2488C21D0Ev,_ZThn1308_N8S2488C21D0Ev)() __attribute__((weak));
extern void _ZN8S2488C102v5Ev();
extern void _ZN8S2488C192v8Ev();
extern void _ZN8S2488C192v9Ev();
extern void _ZN8S2488C193v10Ev();
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY vtc_S2488C21[] = {
  ABISELECT(2400,1308),
  ABISELECT(832,452),
  ABISELECT(704,372),
  ABISELECT(576,300),
  ABISELECT(192,100),
  0,
  (VTBL_ENTRY)&(_ZTI8S2488C21[0]),
  (VTBL_ENTRY)&_ZN8S2488C21D1Ev,
  (VTBL_ENTRY)&_ZN8S2488C21D0Ev,
  0,
  0,
  ABISELECT(384,200),
  ABISELECT(-192,-100),
  (VTBL_ENTRY)&(_ZTI8S2488C21[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  0,
  ABISELECT(-704,-372),
  ABISELECT(-512,-272),
  ABISELECT(-128,-72),
  ABISELECT(-704,-372),
  (VTBL_ENTRY)&(_ZTI8S2488C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C21D1Ev,_ZTv0_n20_N8S2488C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C21D0Ev,_ZTv0_n20_N8S2488C21D0Ev),
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
  0,
  0,
  0,
  ABISELECT(-256,-152),
  ABISELECT(-832,-452),
  (VTBL_ENTRY)&(_ZTI8S2488C21[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
  ABISELECT(416,240),
  ABISELECT(416,240),
  0,
  0,
  0,
  0,
  ABISELECT(-2400,-1308),
  ABISELECT(-1568,-856),
  ABISELECT(-1696,-936),
  ABISELECT(-1824,-1008),
  ABISELECT(-2208,-1208),
  ABISELECT(-2400,-1308),
  (VTBL_ENTRY)&(_ZTI8S2488C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2488C21D1Ev,_ZTv0_n28_N8S2488C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2488C21D0Ev,_ZTv0_n28_N8S2488C21D0Ev),
  (VTBL_ENTRY)&_ZN8S2488C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2488C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2488C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2488C193v10Ev,
  ABISELECT(-2240,-1248),
  ABISELECT(-2816,-1548),
  (VTBL_ENTRY)&(_ZTI8S2488C21[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern VTBL_ENTRY _ZTV8S2488C21[];
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__8S2488C21[] = {
  ABISELECT(384,200),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C6[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void _ZN7S2488C8D1Ev();
extern void _ZN7S2488C8D0Ev();
extern void _ZN7S2488C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C8__8S2488C21[] = {
  ABISELECT(-512,-272),
  ABISELECT(-128,-72),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C8[0]),
  (VTBL_ENTRY)&_ZN7S2488C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2488C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__7S2488C8__8S2488C21[] = {
  0,
  0,
  ABISELECT(384,200),
  ABISELECT(512,272),
  (VTBL_ENTRY)&(_ZTI7S2488C8[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C5__8S2488C21[] = {
  ABISELECT(-256,-152),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C5[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C67S2488C5__A1__8S2488C21[] = {
  ABISELECT(-256,-152),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C6[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void _ZN8S2488C19D1Ev();
extern void _ZN8S2488C19D0Ev();
extern void _ZN8S2488C102v5Ev();
extern void _ZN8S2488C192v8Ev();
extern void _ZN8S2488C192v9Ev();
extern void _ZN8S2488C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2488C19__8S2488C21[] = {
  ABISELECT(-1568,-856),
  ABISELECT(-1696,-936),
  ABISELECT(-1824,-1008),
  ABISELECT(-2208,-1208),
  0,
  (VTBL_ENTRY)&(_ZTI8S2488C19[0]),
  (VTBL_ENTRY)&_ZN8S2488C19D1Ev,
  (VTBL_ENTRY)&_ZN8S2488C19D0Ev,
  (VTBL_ENTRY)&_ZN8S2488C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2488C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2488C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2488C193v10Ev,
};
extern void _ZN8S2488C10D1Ev();
extern void _ZN8S2488C10D0Ev();
extern void _ZN8S2488C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2488C108S2488C19__8S2488C21[] = {
  ABISELECT(-1568,-856),
  ABISELECT(-1696,-936),
  ABISELECT(-1824,-1008),
  ABISELECT(-2208,-1208),
  0,
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&_ZN8S2488C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2488C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2488C102v5Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__8S2488C108S2488C19__8S2488C21[] = {
  0,
  0,
  ABISELECT(384,200),
  ABISELECT(2208,1208),
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2488C10D1Ev,_ZTv0_n20_N8S2488C10D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2488C10D0Ev,_ZTv0_n20_N8S2488C10D0Ev)();
extern void _ZN7S2488C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C8__8S2488C108S2488C19__8S2488C21[] = {
  0,
  ABISELECT(1696,936),
  ABISELECT(-512,-272),
  ABISELECT(-128,-72),
  ABISELECT(1696,936),
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C10D1Ev,_ZTv0_n20_N8S2488C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C10D0Ev,_ZTv0_n20_N8S2488C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C5__8S2488C108S2488C19__8S2488C21[] = {
  0,
  0,
  0,
  ABISELECT(-256,-152),
  ABISELECT(1568,856),
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C68S2488C19__A2__8S2488C21[] = {
  ABISELECT(-2240,-1248),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C6[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2488C19D1Ev,_ZTv0_n20_N8S2488C19D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2488C19D0Ev,_ZTv0_n20_N8S2488C19D0Ev)();
extern void _ZN7S2488C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C8__8S2488C19__8S2488C21[] = {
  0,
  ABISELECT(1696,936),
  ABISELECT(-512,-272),
  ABISELECT(-128,-72),
  ABISELECT(1696,936),
  (VTBL_ENTRY)&(_ZTI8S2488C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C19D1Ev,_ZTv0_n20_N8S2488C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C19D0Ev,_ZTv0_n20_N8S2488C19D0Ev),
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__8S2488C19__8S2488C21[] = {
  0,
  0,
  ABISELECT(384,200),
  ABISELECT(2208,1208),
  (VTBL_ENTRY)&(_ZTI8S2488C19[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C5__8S2488C19__8S2488C21[] = {
  0,
  0,
  0,
  ABISELECT(-256,-152),
  ABISELECT(1568,856),
  (VTBL_ENTRY)&(_ZTI8S2488C19[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__A__8S2488C19__8S2488C21[] = {
  ABISELECT(-2240,-1248),
  ABISELECT(-416,-240),
  (VTBL_ENTRY)&(_ZTI8S2488C19[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
static  VTT_ENTRY vtt_S2488C21[] = {
  {&(_ZTV8S2488C21[7]),  7,58},
  {&(_ZTV8S2488C21[14]),  14,58},
  {&(_ZTV8S2488C21[22]),  22,58},
  {&(_ZTV8S2488C21[31]),  31,58},
  {&(_ZTV8S2488C21[47]),  47,58},
  {&(_ZTV8S2488C21[56]),  56,58},
  {&(_tg__ZTV7S2488C6__8S2488C21[3]),  3,5},
  {&(_tg__ZTV7S2488C8__8S2488C21[4]),  4,7},
  {&(_tg__ZTV7S2488C6__7S2488C8__8S2488C21[5]),  5,7},
  {&(_tg__ZTV7S2488C5__8S2488C21[3]),  3,6},
  {&(_tg__ZTV7S2488C67S2488C5__A1__8S2488C21[3]),  3,5},
  {&(_tg__ZTV8S2488C19__8S2488C21[6]),  6,12},
  {&(_tg__ZTV8S2488C108S2488C19__8S2488C21[6]),  6,9},
  {&(_tg__ZTV7S2488C6__8S2488C108S2488C19__8S2488C21[5]),  5,7},
  {&(_tg__ZTV7S2488C8__8S2488C108S2488C19__8S2488C21[6]),  6,9},
  {&(_tg__ZTV7S2488C5__8S2488C108S2488C19__8S2488C21[6]),  6,9},
  {&(_tg__ZTV7S2488C68S2488C19__A2__8S2488C21[3]),  3,5},
  {&(_tg__ZTV7S2488C8__8S2488C19__8S2488C21[6]),  6,9},
  {&(_tg__ZTV7S2488C6__8S2488C19__8S2488C21[5]),  5,7},
  {&(_tg__ZTV7S2488C5__8S2488C19__8S2488C21[6]),  6,9},
  {&(_tg__ZTV7S2488C6__A__8S2488C19__8S2488C21[3]),  3,5},
};
extern VTBL_ENTRY _ZTI8S2488C21[];
extern  VTBL_ENTRY _ZTV8S2488C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2488C21[];
static VTBL_ENTRY alt_thunk_names20[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2488C21D0Ev,_ZTv0_n28_N8S2488C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2400_N8S2488C21D0Ev,_ZThn1308_N8S2488C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n56_N8S2488C21D1Ev,_ZTv0_n28_N8S2488C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn2400_N8S2488C21D1Ev,_ZThn1308_N8S2488C21D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2488C21D0Ev,_ZTv0_n20_N8S2488C21D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn704_N8S2488C21D0Ev,_ZThn372_N8S2488C21D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2488C21D1Ev,_ZTv0_n20_N8S2488C21D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn704_N8S2488C21D1Ev,_ZThn372_N8S2488C21D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S2488C21 = {  "S2488C21", // class name
  bases_S2488C21, 12,
  &(vtc_S2488C21[0]), // expected_vtbl_contents
  &(vtt_S2488C21[0]), // expected_vtt_contents
  ABISELECT(5008,2724), // object size
  NSPAIRA(_ZTI8S2488C21),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S2488C21),58, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S2488C21),21, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names20,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2488C20  : virtual S2488C5 , virtual S2488C6 , virtual S2488C8 , S2488C9 , virtual S2488C13 {
  char s2488c20f0;
  short s2488c20f1[3];
  ::S2488C21 s2488c20f2[10];
  ::S2488C5 s2488c20f3;
  __tsi64 s2488c20f4;
  __tsi64 s2488c20f5:5;
  int s2488c20f6;
  void *s2488c20f7[6];
  long s2488c20f8[2];
  __tsi64 s2488c20f9;
  int s2488c20f10;
  virtual  ~S2488C20(); // _ZN8S2488C20D2Ev
  S2488C20(); // tgen
};
//SIG(-1 S2488C20) C1{ VBC2{ BC3{ m Fc Fi FL FU4{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi} Fs FL:12 FL Fi} BC5{ VBC3 v1 v2 Fp Fp Fi Fi FU6{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU6 Fp FL:3 FC3 Fl FU6} v3 Fp FD FC3[7] FD FU4 Fs Fl Fl} VBC5 VBC7{ VBC3 VBC5 vd v4 FL FL FL Fl Fi FU6 Fc[10] Fi} BC8{ BC9{ BC3 VBC5 VBC7 VBC2 vd v5 Fc Fi[7] Fl[5] Fl FL FL FU10{ m Fp Fi Fp Fc Fc Fl[5] Fp Fp Fp}} vd v6 v7 Fp Fp Fp Fi FC11{} Fl Fl} VBC12{ v8 FD FC13{ VBC2 VBC7 Fi Fp Fi FU6}[6] Fc Fp Fp Fi[6] Fi Fp Fl Fp Fi Fp Fp} vd Fc Fs[3] FC14{ BC3 VBC5 VBC7 VBC2 VBC15{ VBC7 BC9 BC3 BC5 vd v9 v10 v11 FU6 Fi Fl Fc Fp FC2 Fs} vd FL Fi Fp Fp Fl}[10] FC2 FL FL:5 Fi Fp[6] Fl[2] FL Fi}


 S2488C20 ::~S2488C20(){ note_dtor("S2488C20", this);}
S2488C20 ::S2488C20(){ note_ctor("S2488C20", this);} // tgen

static void Test_S2488C20()
{
  extern Class_Descriptor cd_S2488C20;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(4275,9309)];
    init_test(&cd_S2488C20, buf);
    S2488C20 *dp, &lv = *(dp=new (buf) S2488C20());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(68384,37232), "sizeof(S2488C20)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2488C20)");
    /*is_ambiguous_... S2488C5::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C5*), ABISELECT(52592,28632), "S2488C20");
    check_base_class_offset(lv, (S2489C3*)(S2488C6*)(S2488C5*), ABISELECT(53776,29288), "S2488C20");
    /*is_ambiguous_... S2488C20::S2488C6 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C6*), ABISELECT(53776,29288), "S2488C20");
    check_base_class_offset(lv, (S2489C3*)(S2488C8*), ABISELECT(53776,29288), "S2488C20");
    check_base_class_offset(lv, (S2488C6*)(S2488C5*), ABISELECT(52208,28432), "S2488C20");
    check_base_class_offset(lv, (S2488C5*), ABISELECT(52208,28432), "S2488C20");
    check_base_class_offset(lv, (S2488C5*)(S2488C10*)(S2488C9*), ABISELECT(52208,28432), "S2488C20");
    /*is_ambiguous_... S2488C20::S2488C6 */ AMB_check_base_class_offset(lv, (S2488C6*), ABISELECT(53904,29360), "S2488C20");
    check_base_class_offset(lv, (S2488C6*)(S2488C8*), ABISELECT(53904,29360), "S2488C20");
    /*is_ambiguous_... S2488C10::S2488C6 */ AMB_check_base_class_offset(lv, (S2488C6*)(S2488C10*)(S2488C9*), ABISELECT(53904,29360), "S2488C20");
    check_base_class_offset(lv, (S2488C8*), ABISELECT(54288,29560), "S2488C20");
    check_base_class_offset(lv, (S2488C8*)(S2488C10*)(S2488C9*), ABISELECT(54288,29560), "S2488C20");
    /*is_ambiguous_... S2488C10::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C10*)(S2488C9*), ABISELECT(16,4), "S2488C20");
    check_base_class_offset(lv, (S2488C10*)(S2488C9*), 0, "S2488C20");
    check_base_class_offset(lv, (S2488C9*), 0, "S2488C20");
    check_base_class_offset(lv, (S2488C13*), ABISELECT(54416,29640), "S2488C20");
    check_field_offset(lv, s2488c20f0, ABISELECT(328,196), "S2488C20.s2488c20f0");
    check_field_offset(lv, s2488c20f1, ABISELECT(330,198), "S2488C20.s2488c20f1");
    check_field_offset(lv, s2488c20f2, ABISELECT(336,204), "S2488C20.s2488c20f2");
    check_field_offset(lv, s2488c20f3, ABISELECT(50416,27444), "S2488C20.s2488c20f3");
    check_field_offset(lv, s2488c20f4, ABISELECT(52112,28372), "S2488C20.s2488c20f4");
    set_bf_and_test(lv, s2488c20f5, ABISELECT(52120,28380), 0, 5, 1, "S2488C20");
    set_bf_and_test(lv, s2488c20f5, ABISELECT(52120,28380), 0, 5, hide_sll(1LL<<4), "S2488C20");
    check_field_offset(lv, s2488c20f6, ABISELECT(52124,28384), "S2488C20.s2488c20f6");
    check_field_offset(lv, s2488c20f7, ABISELECT(52128,28388), "S2488C20.s2488c20f7");
    check_field_offset(lv, s2488c20f8, ABISELECT(52176,28412), "S2488C20.s2488c20f8");
    check_field_offset(lv, s2488c20f9, ABISELECT(52192,28420), "S2488C20.s2488c20f9");
    check_field_offset(lv, s2488c20f10, ABISELECT(52200,28428), "S2488C20.s2488c20f10");
    test_class_info(&lv, &cd_S2488C20);
    dp->~S2488C20();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2488C20(Test_S2488C20, "S2488C20", ABISELECT(68384,37232));

#else // __cplusplus

extern void _ZN8S2488C20C1Ev();
extern void _ZN8S2488C20D2Ev();
Name_Map name_map_S2488C20[] = {
  NSPAIR(_ZN8S2488C20C1Ev),
  NSPAIR(_ZN8S2488C20D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2488C6;
extern VTBL_ENTRY _ZTI7S2488C6[];
extern  VTBL_ENTRY _ZTV7S2488C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C6[];
extern Class_Descriptor cd_S2488C5;
extern VTBL_ENTRY _ZTI7S2488C5[];
extern  VTBL_ENTRY _ZTV7S2488C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C5[];
extern Class_Descriptor cd_S2488C6;
extern VTBL_ENTRY _ZTI7S2488C6[];
extern  VTBL_ENTRY _ZTV7S2488C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C6[];
extern Class_Descriptor cd_S2488C8;
extern VTBL_ENTRY _ZTI7S2488C8[];
extern  VTBL_ENTRY _ZTV7S2488C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C8[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2488C10;
extern VTBL_ENTRY _ZTI8S2488C10[];
extern  VTBL_ENTRY _ZTV8S2488C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2488C10[];
extern Class_Descriptor cd_S2488C9;
extern VTBL_ENTRY _ZTI7S2488C9[];
extern  VTBL_ENTRY _ZTV7S2488C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C9[];
extern Class_Descriptor cd_S2488C13;
extern VTBL_ENTRY _ZTI8S2488C13[];
extern  VTBL_ENTRY _ZTV8S2488C13[];
static Base_Class bases_S2488C20[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C3,    ABISELECT(52592,28632), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(53776,29288), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S2488C6,    ABISELECT(52208,28432), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    15, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 0},
  {&cd_S2488C5,    ABISELECT(52208,28432), //bcp->offset
    12, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    10, //bcp->index_in_construction_vtbl_array
    14, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2488C6,    ABISELECT(53904,29360), //bcp->offset
    21, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    11, //bcp->index_in_construction_vtbl_array
    16, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2488C8,    ABISELECT(54288,29560), //bcp->offset
    28, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    12, //bcp->index_in_construction_vtbl_array
    17, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C3,    ABISELECT(16,4), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S2488C10,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S2488C9,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2488C13,    ABISELECT(54416,29640), //bcp->offset
    37, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    13, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    -1, //immediately_derived
  1, 1},
  {0}};
extern VTBL_ENTRY _ZTI8S2488C20[];
extern void _ZN8S2488C20D1Ev();
extern void _ZN8S2488C20D0Ev();
extern void _ZN8S2488C102v5Ev();
extern void _ZN7S2488C92v6Ev();
extern void _ZN7S2488C92v7Ev();
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void ABISELECT(_ZTv0_n40_N8S2488C20D1Ev,_ZTv0_n20_N8S2488C20D1Ev)();
extern void ABISELECT(_ZThn54288_N8S2488C20D1Ev,_ZThn29560_N8S2488C20D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2488C20D0Ev,_ZTv0_n20_N8S2488C20D0Ev)();
extern void ABISELECT(_ZThn54288_N8S2488C20D0Ev,_ZThn29560_N8S2488C20D0Ev)() __attribute__((weak));
extern void _ZN7S2488C82v4Ev();
extern void _ZN8S2488C133v11Ev();
static  VTBL_ENTRY vtc_S2488C20[] = {
  ABISELECT(54416,29640),
  ABISELECT(52208,28432),
  ABISELECT(54288,29560),
  ABISELECT(53776,29288),
  ABISELECT(53904,29360),
  0,
  (VTBL_ENTRY)&(_ZTI8S2488C20[0]),
  (VTBL_ENTRY)&_ZN8S2488C20D1Ev,
  (VTBL_ENTRY)&_ZN8S2488C20D0Ev,
  (VTBL_ENTRY)&_ZN8S2488C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2488C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2488C92v7Ev,
  0,
  0,
  0,
  ABISELECT(1568,856),
  ABISELECT(-52208,-28432),
  (VTBL_ENTRY)&(_ZTI8S2488C20[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-53904,-29360),
  (VTBL_ENTRY)&(_ZTI8S2488C20[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  0,
  ABISELECT(-54288,-29560),
  ABISELECT(-384,-200),
  ABISELECT(-512,-272),
  ABISELECT(-54288,-29560),
  (VTBL_ENTRY)&(_ZTI8S2488C20[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C20D1Ev,_ZTv0_n20_N8S2488C20D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C20D0Ev,_ZTv0_n20_N8S2488C20D0Ev),
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
  0,
  ABISELECT(-54416,-29640),
  (VTBL_ENTRY)&(_ZTI8S2488C20[0]),
  (VTBL_ENTRY)&_ZN8S2488C133v11Ev,
};
extern VTBL_ENTRY _ZTV8S2488C20[];
extern void _ZN7S2488C9D1Ev();
extern void _ZN7S2488C9D0Ev();
extern void _ZN8S2488C102v5Ev();
extern void _ZN7S2488C92v6Ev();
extern void _ZN7S2488C92v7Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C9__8S2488C20[] = {
  ABISELECT(52208,28432),
  ABISELECT(54288,29560),
  ABISELECT(53776,29288),
  ABISELECT(53904,29360),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C9[0]),
  (VTBL_ENTRY)&_ZN7S2488C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2488C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2488C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2488C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2488C92v7Ev,
};
extern void _ZN8S2488C10D1Ev();
extern void _ZN8S2488C10D0Ev();
extern void _ZN8S2488C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2488C107S2488C9__8S2488C20[] = {
  ABISELECT(52208,28432),
  ABISELECT(54288,29560),
  ABISELECT(53776,29288),
  ABISELECT(53904,29360),
  0,
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&_ZN8S2488C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2488C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2488C102v5Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__8S2488C107S2488C9__8S2488C20[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-53904,-29360),
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2488C10D1Ev,_ZTv0_n20_N8S2488C10D1Ev)();
extern void ABISELECT(_ZThn54288_N8S2488C10D1Ev,_ZThn29560_N8S2488C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2488C10D0Ev,_ZTv0_n20_N8S2488C10D0Ev)();
extern void ABISELECT(_ZThn54288_N8S2488C10D0Ev,_ZThn29560_N8S2488C10D0Ev)() __attribute__((weak));
extern void _ZN7S2488C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C8__8S2488C107S2488C9__8S2488C20[] = {
  0,
  ABISELECT(-54288,-29560),
  ABISELECT(-384,-200),
  ABISELECT(-512,-272),
  ABISELECT(-54288,-29560),
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C10D1Ev,_ZTv0_n20_N8S2488C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C10D0Ev,_ZTv0_n20_N8S2488C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C5__8S2488C107S2488C9__8S2488C20[] = {
  0,
  0,
  0,
  ABISELECT(1568,856),
  ABISELECT(-52208,-28432),
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__7S2488C9__8S2488C20[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-53904,-29360),
  (VTBL_ENTRY)&(_ZTI7S2488C9[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S2488C9D1Ev,_ZTv0_n20_N7S2488C9D1Ev)();
extern void ABISELECT(_ZThn54288_N7S2488C9D1Ev,_ZThn29560_N7S2488C9D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N7S2488C9D0Ev,_ZTv0_n20_N7S2488C9D0Ev)();
extern void ABISELECT(_ZThn54288_N7S2488C9D0Ev,_ZThn29560_N7S2488C9D0Ev)() __attribute__((weak));
extern void _ZN7S2488C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C8__7S2488C9__8S2488C20[] = {
  0,
  ABISELECT(-54288,-29560),
  ABISELECT(-384,-200),
  ABISELECT(-512,-272),
  ABISELECT(-54288,-29560),
  (VTBL_ENTRY)&(_ZTI7S2488C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2488C9D1Ev,_ZTv0_n20_N7S2488C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2488C9D0Ev,_ZTv0_n20_N7S2488C9D0Ev),
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C5__7S2488C9__8S2488C20[] = {
  0,
  0,
  0,
  ABISELECT(1568,856),
  ABISELECT(-52208,-28432),
  (VTBL_ENTRY)&(_ZTI7S2488C9[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C5__8S2488C20[] = {
  ABISELECT(1568,856),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C5[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C67S2488C5__8S2488C20[] = {
  ABISELECT(1568,856),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C6[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__A1__8S2488C20[] = {
  ABISELECT(-128,-72),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C6[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void _ZN7S2488C8D1Ev();
extern void _ZN7S2488C8D0Ev();
extern void _ZN7S2488C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C8__8S2488C20[] = {
  ABISELECT(-384,-200),
  ABISELECT(-512,-272),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C8[0]),
  (VTBL_ENTRY)&_ZN7S2488C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2488C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__7S2488C8__8S2488C20[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(384,200),
  (VTBL_ENTRY)&(_ZTI7S2488C8[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
static  VTT_ENTRY vtt_S2488C20[] = {
  {&(_ZTV8S2488C20[7]),  7,41},
  {&(_tg__ZTV7S2488C9__8S2488C20[6]),  6,11},
  {&(_tg__ZTV8S2488C107S2488C9__8S2488C20[6]),  6,9},
  {&(_tg__ZTV7S2488C6__8S2488C107S2488C9__8S2488C20[5]),  5,7},
  {&(_tg__ZTV7S2488C8__8S2488C107S2488C9__8S2488C20[6]),  6,9},
  {&(_tg__ZTV7S2488C5__8S2488C107S2488C9__8S2488C20[6]),  6,9},
  {&(_tg__ZTV7S2488C6__7S2488C9__8S2488C20[5]),  5,7},
  {&(_tg__ZTV7S2488C8__7S2488C9__8S2488C20[6]),  6,9},
  {&(_tg__ZTV7S2488C5__7S2488C9__8S2488C20[6]),  6,9},
  {&(_ZTV8S2488C20[18]),  18,41},
  {&(_ZTV8S2488C20[26]),  26,41},
  {&(_ZTV8S2488C20[34]),  34,41},
  {&(_ZTV8S2488C20[40]),  40,41},
  {&(_tg__ZTV7S2488C5__8S2488C20[3]),  3,6},
  {&(_tg__ZTV7S2488C67S2488C5__8S2488C20[3]),  3,5},
  {&(_tg__ZTV7S2488C6__A1__8S2488C20[3]),  3,5},
  {&(_tg__ZTV7S2488C8__8S2488C20[4]),  4,7},
  {&(_tg__ZTV7S2488C6__7S2488C8__8S2488C20[5]),  5,7},
};
extern VTBL_ENTRY _ZTI8S2488C20[];
extern  VTBL_ENTRY _ZTV8S2488C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2488C20[];
static VTBL_ENTRY alt_thunk_names21[] = {
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S2488C9D0Ev,_ZTv0_n20_N7S2488C9D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn54288_N7S2488C9D0Ev,_ZThn29560_N7S2488C9D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N7S2488C9D1Ev,_ZTv0_n20_N7S2488C9D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn54288_N7S2488C9D1Ev,_ZThn29560_N7S2488C9D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2488C10D0Ev,_ZTv0_n20_N8S2488C10D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn54288_N8S2488C10D0Ev,_ZThn29560_N8S2488C10D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2488C10D1Ev,_ZTv0_n20_N8S2488C10D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn54288_N8S2488C10D1Ev,_ZThn29560_N8S2488C10D1Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2488C20D0Ev,_ZTv0_n20_N8S2488C20D0Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn54288_N8S2488C20D0Ev,_ZThn29560_N8S2488C20D0Ev),
  ALT_NAMES_TERMINATOR,
  (VTBL_ENTRY)ABISELECT(_ZTv0_n40_N8S2488C20D1Ev,_ZTv0_n20_N8S2488C20D1Ev), // 
  (VTBL_ENTRY)ABISELECT(_ZThn54288_N8S2488C20D1Ev,_ZThn29560_N8S2488C20D1Ev),
  ALT_NAMES_TERMINATOR,
ALT_NAMES_TERMINATOR};
Class_Descriptor cd_S2488C20 = {  "S2488C20", // class name
  bases_S2488C20, 10,
  &(vtc_S2488C20[0]), // expected_vtbl_contents
  &(vtt_S2488C20[0]), // expected_vtt_contents
  ABISELECT(68384,37232), // object size
  NSPAIRA(_ZTI8S2488C20),ABISELECT(104,56), //typeinfo_var
  NSPAIRA(_ZTV8S2488C20),41, //virtual function table var
  7, // offset into main vftv pointed to by object[0]
  NSPAIRA(_ZTT8S2488C20),18, //virtual table table var
  7, // n_initialized_bases
  1, // has_virtual_bases
  1, // has_class_type_fields
  alt_thunk_names21,
};
#endif // __cplusplus

//============================================================================

#ifdef __cplusplus

struct  S2488C17  : S2489C18 , S2488C19 , virtual S2488C20 , S2488C21 {
  int s2488c17f0;
  long double s2488c17f1;
  long s2488c17f2;
  char s2488c17f3:3;
  void *s2488c17f4;
  ::S2488C6 s2488c17f5;
  virtual  ~S2488C17(); // _ZN8S2488C17D2Ev
  virtual void  v12(); // _ZN8S2488C173v12Ev
  virtual void  v13(); // _ZN8S2488C173v13Ev
  S2488C17(); // tgen
};
//SIG(-1 S2488C17) C1{ BC2{ vd m FU3{ m FD FL Fi Fl Fc Fi[7] FD Fp Fp[10] FL Fp FL Fi}} BC4{ VBC5{ VBC6{ m Fc Fi FL FU3 Fs FL:12 FL Fi} VBC7{ VBC6 v3 v4 Fp Fp Fi Fi FU8{ m FL Fi FL Fp[7] FL:12} FL:0 FD FU8 Fp FL:3 FC6 Fl FU8} vd v5 FL FL FL Fl Fi FU8 Fc[10] Fi} BC9{ BC6 VBC7 VBC5 VBC10{ BC6 BC7 v6 Fp FD FC6[7] FD FU3 Fs Fl Fl} vd v7 Fc Fi[7] Fl[5] Fl FL FL FU11{ m Fp Fi Fp Fc Fc Fl[5] Fp Fp Fp}} BC6 BC7 vd v8 v9 v10 FU8 Fi Fl Fc Fp FC10 Fs} VBC12{ VBC10 VBC7 VBC5 BC13{ BC9 vd v11 v12 Fp Fp Fp Fi FC14{} Fl Fl} VBC15{ v13 FD FC16{ VBC10 VBC5 Fi Fp Fi FU8}[6] Fc Fp Fp Fi[6] Fi Fp Fl Fp Fi Fp Fp} vd Fc Fs[3] FC17{ BC6 VBC7 VBC5 VBC10 VBC4 vd FL Fi Fp Fp Fl}[10] FC10 FL FL:5 Fi Fp[6] Fl[2] FL Fi} BC17 vd v1 v2 Fi FD Fl Fc:3 Fp FC7}


 S2488C17 ::~S2488C17(){ note_dtor("S2488C17", this);}
void  S2488C17 ::v12(){vfunc_called(this, "_ZN8S2488C173v12Ev");}
void  S2488C17 ::v13(){vfunc_called(this, "_ZN8S2488C173v13Ev");}
S2488C17 ::S2488C17(){ note_ctor("S2488C17", this);} // tgen

static void Test_S2488C17()
{
  extern Class_Descriptor cd_S2488C17;
  void *lvp;
  {
    ABISELECT(sal_16,int) buf[ABISELECT(4654,10128)];
    init_test(&cd_S2488C17, buf);
    S2488C17 *dp, &lv = *(dp=new (buf) S2488C17());
    lvp = (void*)&lv;
    check2(sizeof(lv), ABISELECT(74448,40508), "sizeof(S2488C17)");
    check2(__alignof__(lv), ABISELECT(16,4), "__alignof__(S2488C17)");
    check_base_class_offset(lv, (S2489C18*), 0, "S2488C17");
    check_base_class_offset(lv, (S2489C3*)(S2488C8*), ABISELECT(3584,1940), "S2488C17");
    /*is_ambiguous_... S2488C17::S2488C6 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C6*), ABISELECT(3584,1940), "S2488C17");
    check_base_class_offset(lv, (S2489C3*)(S2488C6*)(S2488C5*), ABISELECT(3584,1940), "S2488C17");
    /*is_ambiguous_... S2488C17::S2488C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C6*)(S2488C19*), ABISELECT(3584,1940), "S2488C17");
    /*is_ambiguous_... S2488C17::S2488C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C6*)(S2488C19*), ABISELECT(3584,1940), "S2488C17");
    check_base_class_offset(lv, (S2488C6*)(S2488C8*), ABISELECT(3712,2012), "S2488C17");
    /*is_ambiguous_... S2488C17::S2488C19 */ AMB_check_base_class_offset(lv, (S2488C6*)(S2488C10*)(S2488C19*), ABISELECT(3712,2012), "S2488C17");
    /*is_ambiguous_... S2488C20::S2488C6 */ AMB_check_base_class_offset(lv, (S2488C6*)(S2488C20*), ABISELECT(3712,2012), "S2488C17");
    /*is_ambiguous_... S2488C10::S2488C6 */ AMB_check_base_class_offset(lv, (S2488C6*)(S2488C10*)(S2488C9*)(S2488C20*), ABISELECT(3712,2012), "S2488C17");
    /*is_ambiguous_... S2488C21::S2488C6 */ AMB_check_base_class_offset(lv, (S2488C6*)(S2488C21*), ABISELECT(3712,2012), "S2488C17");
    /*is_ambiguous_... S2488C17::S2488C19 */ AMB_check_base_class_offset(lv, (S2488C6*)(S2488C10*)(S2488C19*), ABISELECT(3712,2012), "S2488C17");
    /*is_ambiguous_... S2488C17::S2488C19 */ AMB_check_base_class_offset(lv, (S2488C8*)(S2488C19*), ABISELECT(3456,1860), "S2488C17");
    /*is_ambiguous_... S2488C17::S2488C19 */ AMB_check_base_class_offset(lv, (S2488C8*)(S2488C10*)(S2488C19*), ABISELECT(3456,1860), "S2488C17");
    check_base_class_offset(lv, (S2488C8*)(S2488C20*), ABISELECT(3456,1860), "S2488C17");
    check_base_class_offset(lv, (S2488C8*)(S2488C10*)(S2488C9*)(S2488C20*), ABISELECT(3456,1860), "S2488C17");
    check_base_class_offset(lv, (S2488C8*)(S2488C21*), ABISELECT(3456,1860), "S2488C17");
    /*is_ambiguous_... S2488C17::S2488C19 */ AMB_check_base_class_offset(lv, (S2488C8*)(S2488C19*), ABISELECT(3456,1860), "S2488C17");
    /*is_ambiguous_... S2488C17::S2488C19 */ AMB_check_base_class_offset(lv, (S2488C8*)(S2488C10*)(S2488C19*), ABISELECT(3456,1860), "S2488C17");
    /*is_ambiguous_... S2488C17::S2488C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C10*)(S2488C19*), ABISELECT(112,48), "S2488C17");
    /*is_ambiguous_... S2488C5::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C5*), ABISELECT(4480,2412), "S2488C17");
    check_base_class_offset(lv, (S2488C6*)(S2488C5*), ABISELECT(4096,2212), "S2488C17");
    /*is_ambiguous_... S2488C17::S2488C19 */ AMB_check_base_class_offset(lv, (S2488C5*)(S2488C10*)(S2488C19*), ABISELECT(4096,2212), "S2488C17");
    check_base_class_offset(lv, (S2488C5*)(S2488C20*), ABISELECT(4096,2212), "S2488C17");
    check_base_class_offset(lv, (S2488C5*)(S2488C10*)(S2488C9*)(S2488C20*), ABISELECT(4096,2212), "S2488C17");
    check_base_class_offset(lv, (S2488C5*)(S2488C21*), ABISELECT(4096,2212), "S2488C17");
    /*is_ambiguous_... S2488C17::S2488C19 */ AMB_check_base_class_offset(lv, (S2488C5*)(S2488C10*)(S2488C19*), ABISELECT(4096,2212), "S2488C17");
    /*is_ambiguous_... S2488C17::S2488C19 */ AMB_check_base_class_offset(lv, (S2488C10*)(S2488C19*), ABISELECT(96,44), "S2488C17");
    /*is_ambiguous_... S2488C17::S2488C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C19*), ABISELECT(384,212), "S2488C17");
    /*is_ambiguous_... S2488C17::S2488C19 */ AMB_check_base_class_offset(lv, (S2488C6*)(S2488C19*), ABISELECT(512,284), "S2488C17");
    /*is_ambiguous_... S2488C17::S2488C19 */ AMB_check_base_class_offset(lv, (S2488C19*), ABISELECT(96,44), "S2488C17");
    /*is_ambiguous_... S2488C10::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C10*)(S2488C9*)(S2488C20*), ABISELECT(5680,3072), "S2488C17");
    check_base_class_offset(lv, (S2488C10*)(S2488C9*)(S2488C20*), ABISELECT(5664,3068), "S2488C17");
    check_base_class_offset(lv, (S2488C9*)(S2488C20*), ABISELECT(5664,3068), "S2488C17");
    check_base_class_offset(lv, (S2488C13*)(S2488C20*), ABISELECT(57872,31500), "S2488C17");
    check_base_class_offset(lv, (S2488C20*), ABISELECT(5664,3068), "S2488C17");
    /*is_ambiguous_... S2488C21::S2489C3 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C21*), ABISELECT(2720,1464), "S2488C17");
    /*is_ambiguous_... S2488C17::S2488C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C10*)(S2488C19*), ABISELECT(71856,39096), "S2488C17");
    /*is_ambiguous_... S2488C17::S2488C19 */ AMB_check_base_class_offset(lv, (S2488C10*)(S2488C19*), ABISELECT(71840,39092), "S2488C17");
    /*is_ambiguous_... S2488C17::S2488C19 */ AMB_check_base_class_offset(lv, (S2489C3*)(S2488C19*), ABISELECT(72128,39260), "S2488C17");
    /*is_ambiguous_... S2488C17::S2488C19 */ AMB_check_base_class_offset(lv, (S2488C6*)(S2488C19*), ABISELECT(72256,39332), "S2488C17");
    check_base_class_offset(lv, (S2488C19*)(S2488C21*), ABISELECT(71840,39092), "S2488C17");
    check_base_class_offset(lv, (S2488C21*), ABISELECT(2704,1460), "S2488C17");
    check_field_offset(lv, s2488c17f0, ABISELECT(2888,1560), "S2488C17.s2488c17f0");
    check_field_offset(lv, s2488c17f1, ABISELECT(2896,1564), "S2488C17.s2488c17f1");
    check_field_offset(lv, s2488c17f2, ABISELECT(2912,1576), "S2488C17.s2488c17f2");
    set_bf_and_test(lv, s2488c17f3, ABISELECT(2920,1580), 0, 3, 1, "S2488C17");
    set_bf_and_test(lv, s2488c17f3, ABISELECT(2920,1580), 0, 3, hide_sll(1LL<<2), "S2488C17");
    check_field_offset(lv, s2488c17f4, ABISELECT(2928,1584), "S2488C17.s2488c17f4");
    check_field_offset(lv, s2488c17f5, ABISELECT(2944,1588), "S2488C17.s2488c17f5");
    test_class_info(&lv, &cd_S2488C17);
    dp->~S2488C17();
  }
  Check_Ctor_Dtor_Calls(lvp);
}
static Arrange_To_Call_Me vS2488C17(Test_S2488C17, "S2488C17", ABISELECT(74448,40508));

#else // __cplusplus

extern void _ZN8S2488C17C1Ev();
extern void _ZN8S2488C17D2Ev();
Name_Map name_map_S2488C17[] = {
  NSPAIR(_ZN8S2488C17C1Ev),
  NSPAIR(_ZN8S2488C17D2Ev),
  {0,0}
};
extern Class_Descriptor cd_S2489C18;
extern VTBL_ENTRY _ZTI8S2489C18[];
extern  VTBL_ENTRY _ZTV8S2489C18[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2488C6;
extern VTBL_ENTRY _ZTI7S2488C6[];
extern  VTBL_ENTRY _ZTV7S2488C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C6[];
extern Class_Descriptor cd_S2488C8;
extern VTBL_ENTRY _ZTI7S2488C8[];
extern  VTBL_ENTRY _ZTV7S2488C8[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C8[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2488C6;
extern VTBL_ENTRY _ZTI7S2488C6[];
extern  VTBL_ENTRY _ZTV7S2488C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C6[];
extern Class_Descriptor cd_S2488C5;
extern VTBL_ENTRY _ZTI7S2488C5[];
extern  VTBL_ENTRY _ZTV7S2488C5[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C5[];
extern Class_Descriptor cd_S2488C10;
extern VTBL_ENTRY _ZTI8S2488C10[];
extern  VTBL_ENTRY _ZTV8S2488C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2488C10[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2488C6;
extern VTBL_ENTRY _ZTI7S2488C6[];
extern  VTBL_ENTRY _ZTV7S2488C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C6[];
extern Class_Descriptor cd_S2488C19;
extern VTBL_ENTRY _ZTI8S2488C19[];
extern  VTBL_ENTRY _ZTV8S2488C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2488C19[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2488C10;
extern VTBL_ENTRY _ZTI8S2488C10[];
extern  VTBL_ENTRY _ZTV8S2488C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2488C10[];
extern Class_Descriptor cd_S2488C9;
extern VTBL_ENTRY _ZTI7S2488C9[];
extern  VTBL_ENTRY _ZTV7S2488C9[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C9[];
extern Class_Descriptor cd_S2488C13;
extern VTBL_ENTRY _ZTI8S2488C13[];
extern  VTBL_ENTRY _ZTV8S2488C13[];
extern Class_Descriptor cd_S2488C20;
extern VTBL_ENTRY _ZTI8S2488C20[];
extern  VTBL_ENTRY _ZTV8S2488C20[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2488C20[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2488C10;
extern VTBL_ENTRY _ZTI8S2488C10[];
extern  VTBL_ENTRY _ZTV8S2488C10[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2488C10[];
extern Class_Descriptor cd_S2489C3;
extern VTBL_ENTRY _ZTI7S2489C3[];
extern Class_Descriptor cd_S2488C6;
extern VTBL_ENTRY _ZTI7S2488C6[];
extern  VTBL_ENTRY _ZTV7S2488C6[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT7S2488C6[];
extern Class_Descriptor cd_S2488C19;
extern VTBL_ENTRY _ZTI8S2488C19[];
extern  VTBL_ENTRY _ZTV8S2488C19[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2488C19[];
extern Class_Descriptor cd_S2488C21;
extern VTBL_ENTRY _ZTI8S2488C21[];
extern  VTBL_ENTRY _ZTV8S2488C21[];
extern  VTBL_ENTRY * __attribute__((weak))_ZTT8S2488C21[];
static Base_Class bases_S2488C17[] = {
  // ofst, vfto, nneg, vtt_idx, base_vtt_idx, init_seq, direct, virtual
  {&cd_S2489C18,    0, //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    12, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2489C3,    ABISELECT(3584,1940), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    2, //immediately_derived
  0, 1},
  {&cd_S2488C6,    ABISELECT(3712,2012), //bcp->offset
    48, //bcp->virtual_function_table_offset
    5, //num_negative_vtable_entries(t, bcp)
    20, //bcp->index_in_construction_vtbl_array
    30, //bcp->base_subarray_index_in_construction_vtbl_array
    1, //init_seq
    3, //immediately_derived
  0, 1},
  {&cd_S2488C8,    ABISELECT(3456,1860), //bcp->offset
    39, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    19, //bcp->index_in_construction_vtbl_array
    28, //bcp->base_subarray_index_in_construction_vtbl_array
    2, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S2489C3,    ABISELECT(112,48), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    8, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(4480,2412), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S2488C6,    ABISELECT(4096,2212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    32, //bcp->base_subarray_index_in_construction_vtbl_array
    3, //init_seq
    7, //immediately_derived
  0, 0},
  {&cd_S2488C5,    ABISELECT(4096,2212), //bcp->offset
    55, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    21, //bcp->index_in_construction_vtbl_array
    31, //bcp->base_subarray_index_in_construction_vtbl_array
    4, //init_seq
    8, //immediately_derived
  0, 1},
  {&cd_S2488C10,    ABISELECT(96,44), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    3, //bcp->base_subarray_index_in_construction_vtbl_array
    13, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(384,212), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S2488C6,    ABISELECT(512,284), //bcp->offset
    25, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    22, //bcp->index_in_construction_vtbl_array
    7, //bcp->base_subarray_index_in_construction_vtbl_array
    14, //init_seq
    11, //immediately_derived
  0, 0},
  {&cd_S2488C19,    ABISELECT(96,44), //bcp->offset
    13, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    18, //bcp->index_in_construction_vtbl_array
    2, //bcp->base_subarray_index_in_construction_vtbl_array
    15, //init_seq
    -1, //immediately_derived
  1, 0},
  {&cd_S2489C3,    ABISELECT(5680,3072), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    13, //immediately_derived
  0, 0},
  {&cd_S2488C10,    ABISELECT(5664,3068), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    35, //bcp->base_subarray_index_in_construction_vtbl_array
    6, //init_seq
    14, //immediately_derived
  0, 0},
  {&cd_S2488C9,    ABISELECT(5664,3068), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    34, //bcp->base_subarray_index_in_construction_vtbl_array
    7, //init_seq
    16, //immediately_derived
  0, 0},
  {&cd_S2488C13,    ABISELECT(57872,31500), //bcp->offset
    80, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    24, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    5, //init_seq
    16, //immediately_derived
  0, 1},
  {&cd_S2488C20,    ABISELECT(5664,3068), //bcp->offset
    64, //bcp->virtual_function_table_offset
    11, //num_negative_vtable_entries(t, bcp)
    23, //bcp->index_in_construction_vtbl_array
    33, //bcp->base_subarray_index_in_construction_vtbl_array
    8, //init_seq
    -1, //immediately_derived
  1, 1},
  {&cd_S2489C3,    ABISELECT(2720,1464), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    23, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(71856,39096), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    19, //immediately_derived
  0, 0},
  {&cd_S2488C10,    ABISELECT(71840,39092), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    6, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    47, //bcp->base_subarray_index_in_construction_vtbl_array
    9, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S2489C3,    ABISELECT(72128,39260), //bcp->offset
    -1, //bcp->virtual_function_table_offset
    2, //num_negative_vtable_entries(t, bcp)
    0, //bcp->index_in_construction_vtbl_array
    0, //bcp->base_subarray_index_in_construction_vtbl_array
    -1, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S2488C6,    ABISELECT(72256,39332), //bcp->offset
    103, //bcp->virtual_function_table_offset
    3, //num_negative_vtable_entries(t, bcp)
    27, //bcp->index_in_construction_vtbl_array
    51, //bcp->base_subarray_index_in_construction_vtbl_array
    10, //init_seq
    22, //immediately_derived
  0, 0},
  {&cd_S2488C19,    ABISELECT(71840,39092), //bcp->offset
    84, //bcp->virtual_function_table_offset
    13, //num_negative_vtable_entries(t, bcp)
    26, //bcp->index_in_construction_vtbl_array
    46, //bcp->base_subarray_index_in_construction_vtbl_array
    11, //init_seq
    23, //immediately_derived
  0, 1},
  {&cd_S2488C21,    ABISELECT(2704,1460), //bcp->offset
    30, //bcp->virtual_function_table_offset
    7, //num_negative_vtable_entries(t, bcp)
    25, //bcp->index_in_construction_vtbl_array
    12, //bcp->base_subarray_index_in_construction_vtbl_array
    16, //init_seq
    -1, //immediately_derived
  1, 0},
  {0}};
extern VTBL_ENTRY _ZTI8S2488C17[];
extern void _ZN8S2488C17D1Ev();
extern void _ZN8S2488C17D0Ev();
extern void _ZN8S2488C173v12Ev();
extern void _ZN8S2488C173v13Ev();
extern void ABISELECT(_ZThn96_N8S2488C17D1Ev,_ZThn44_N8S2488C17D1Ev)();
extern void ABISELECT(_ZThn96_N8S2488C17D0Ev,_ZThn44_N8S2488C17D0Ev)();
extern void _ZN8S2488C102v5Ev();
extern void _ZN8S2488C192v8Ev();
extern void _ZN8S2488C192v9Ev();
extern void _ZN8S2488C193v10Ev();
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void ABISELECT(_ZThn2704_N8S2488C17D1Ev,_ZThn1460_N8S2488C17D1Ev)();
extern void ABISELECT(_ZThn2704_N8S2488C17D0Ev,_ZThn1460_N8S2488C17D0Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2488C17D1Ev,_ZTv0_n20_N8S2488C17D1Ev)();
extern void ABISELECT(_ZThn3456_N8S2488C17D1Ev,_ZThn1860_N8S2488C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2488C17D0Ev,_ZTv0_n20_N8S2488C17D0Ev)();
extern void ABISELECT(_ZThn3456_N8S2488C17D0Ev,_ZThn1860_N8S2488C17D0Ev)() __attribute__((weak));
extern void _ZN7S2488C82v4Ev();
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
extern void ABISELECT(_ZTv0_n64_N8S2488C17D1Ev,_ZTv0_n32_N8S2488C17D1Ev)();
extern void ABISELECT(_ZThn5664_N8S2488C17D1Ev,_ZThn3068_N8S2488C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n64_N8S2488C17D0Ev,_ZTv0_n32_N8S2488C17D0Ev)();
extern void ABISELECT(_ZThn5664_N8S2488C17D0Ev,_ZThn3068_N8S2488C17D0Ev)() __attribute__((weak));
extern void _ZN8S2488C102v5Ev();
extern void _ZN7S2488C92v6Ev();
extern void _ZN7S2488C92v7Ev();
extern void _ZN8S2488C133v11Ev();
extern void ABISELECT(_ZTv0_n56_N8S2488C17D1Ev,_ZTv0_n28_N8S2488C17D1Ev)();
extern void ABISELECT(_ZThn71840_N8S2488C17D1Ev,_ZThn39092_N8S2488C17D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2488C17D0Ev,_ZTv0_n28_N8S2488C17D0Ev)();
extern void ABISELECT(_ZThn71840_N8S2488C17D0Ev,_ZThn39092_N8S2488C17D0Ev)() __attribute__((weak));
extern void _ZN8S2488C102v5Ev();
extern void _ZN8S2488C192v8Ev();
extern void _ZN8S2488C192v9Ev();
extern void _ZN8S2488C193v10Ev();
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY vtc_S2488C17[] = {
  ABISELECT(71840,39092),
  ABISELECT(57872,31500),
  ABISELECT(5664,3068),
  ABISELECT(4096,2212),
  ABISELECT(3712,2012),
  ABISELECT(3584,1940),
  ABISELECT(3456,1860),
  0,
  (VTBL_ENTRY)&(_ZTI8S2488C17[0]),
  (VTBL_ENTRY)&_ZN8S2488C17D1Ev,
  (VTBL_ENTRY)&_ZN8S2488C17D0Ev,
  (VTBL_ENTRY)&_ZN8S2488C173v12Ev,
  (VTBL_ENTRY)&_ZN8S2488C173v13Ev,
  ABISELECT(4000,2168),
  ABISELECT(3360,1816),
  ABISELECT(3488,1896),
  ABISELECT(3616,1968),
  ABISELECT(-96,-44),
  (VTBL_ENTRY)&(_ZTI8S2488C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2488C17D1Ev,_ZThn44_N8S2488C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn96_N8S2488C17D0Ev,_ZThn44_N8S2488C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2488C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2488C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2488C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2488C193v10Ev,
  ABISELECT(3072,1656),
  ABISELECT(-512,-284),
  (VTBL_ENTRY)&(_ZTI8S2488C17[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  ABISELECT(69136,37632),
  ABISELECT(1392,752),
  ABISELECT(752,400),
  ABISELECT(880,480),
  ABISELECT(1008,552),
  ABISELECT(-2704,-1460),
  (VTBL_ENTRY)&(_ZTI8S2488C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S2488C17D1Ev,_ZThn1460_N8S2488C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZThn2704_N8S2488C17D0Ev,_ZThn1460_N8S2488C17D0Ev),
  0,
  ABISELECT(-3456,-1860),
  ABISELECT(256,152),
  ABISELECT(128,80),
  ABISELECT(-3456,-1860),
  (VTBL_ENTRY)&(_ZTI8S2488C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C17D1Ev,_ZTv0_n20_N8S2488C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C17D0Ev,_ZTv0_n20_N8S2488C17D0Ev),
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-3712,-2012),
  (VTBL_ENTRY)&(_ZTI8S2488C17[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  0,
  0,
  0,
  ABISELECT(-512,-272),
  ABISELECT(-4096,-2212),
  (VTBL_ENTRY)&(_ZTI8S2488C17[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
  0,
  0,
  0,
  ABISELECT(-5664,-3068),
  ABISELECT(52208,28432),
  ABISELECT(-1568,-856),
  ABISELECT(-2208,-1208),
  ABISELECT(-2080,-1128),
  ABISELECT(-1952,-1056),
  ABISELECT(-5664,-3068),
  (VTBL_ENTRY)&(_ZTI8S2488C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2488C17D1Ev,_ZTv0_n32_N8S2488C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n64_N8S2488C17D0Ev,_ZTv0_n32_N8S2488C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2488C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2488C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2488C92v7Ev,
  0,
  ABISELECT(-57872,-31500),
  (VTBL_ENTRY)&(_ZTI8S2488C17[0]),
  (VTBL_ENTRY)&_ZN8S2488C133v11Ev,
  ABISELECT(416,240),
  ABISELECT(416,240),
  0,
  0,
  0,
  0,
  ABISELECT(-71840,-39092),
  ABISELECT(-67744,-36880),
  ABISELECT(-68384,-37232),
  ABISELECT(-68256,-37152),
  ABISELECT(-68128,-37080),
  ABISELECT(-71840,-39092),
  (VTBL_ENTRY)&(_ZTI8S2488C17[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2488C17D1Ev,_ZTv0_n28_N8S2488C17D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2488C17D0Ev,_ZTv0_n28_N8S2488C17D0Ev),
  (VTBL_ENTRY)&_ZN8S2488C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2488C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2488C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2488C193v10Ev,
  ABISELECT(-68672,-37392),
  ABISELECT(-72256,-39332),
  (VTBL_ENTRY)&(_ZTI8S2488C17[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern VTBL_ENTRY _ZTV8S2488C17[];
extern void _ZN8S2488C19D1Ev();
extern void _ZN8S2488C19D0Ev();
extern void _ZN8S2488C102v5Ev();
extern void _ZN8S2488C192v8Ev();
extern void _ZN8S2488C192v9Ev();
extern void _ZN8S2488C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2488C19__A__8S2488C17[] = {
  ABISELECT(4000,2168),
  ABISELECT(3360,1816),
  ABISELECT(3488,1896),
  ABISELECT(3616,1968),
  0,
  (VTBL_ENTRY)&(_ZTI8S2488C19[0]),
  (VTBL_ENTRY)&_ZN8S2488C19D1Ev,
  (VTBL_ENTRY)&_ZN8S2488C19D0Ev,
  (VTBL_ENTRY)&_ZN8S2488C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2488C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2488C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2488C193v10Ev,
};
extern void _ZN8S2488C10D1Ev();
extern void _ZN8S2488C10D0Ev();
extern void _ZN8S2488C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2488C108S2488C19__8S2488C17[] = {
  ABISELECT(4000,2168),
  ABISELECT(3360,1816),
  ABISELECT(3488,1896),
  ABISELECT(3616,1968),
  0,
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&_ZN8S2488C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2488C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2488C102v5Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__8S2488C108S2488C19__8S2488C17[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-3616,-1968),
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2488C10D1Ev,_ZTv0_n20_N8S2488C10D1Ev)();
extern void ABISELECT(_ZThn3360_N8S2488C10D1Ev,_ZThn1816_N8S2488C10D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2488C10D0Ev,_ZTv0_n20_N8S2488C10D0Ev)();
extern void ABISELECT(_ZThn3360_N8S2488C10D0Ev,_ZThn1816_N8S2488C10D0Ev)() __attribute__((weak));
extern void _ZN7S2488C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C8__8S2488C108S2488C19__8S2488C17[] = {
  0,
  ABISELECT(-3360,-1816),
  ABISELECT(256,152),
  ABISELECT(128,80),
  ABISELECT(-3360,-1816),
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C10D1Ev,_ZTv0_n20_N8S2488C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C10D0Ev,_ZTv0_n20_N8S2488C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C5__8S2488C108S2488C19__8S2488C17[] = {
  0,
  0,
  0,
  ABISELECT(-512,-272),
  ABISELECT(-4000,-2168),
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C68S2488C19__A2__8S2488C17[] = {
  ABISELECT(3072,1656),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C6[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2488C19D1Ev,_ZTv0_n20_N8S2488C19D1Ev)();
extern void ABISELECT(_ZThn3360_N8S2488C19D1Ev,_ZThn1816_N8S2488C19D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2488C19D0Ev,_ZTv0_n20_N8S2488C19D0Ev)();
extern void ABISELECT(_ZThn3360_N8S2488C19D0Ev,_ZThn1816_N8S2488C19D0Ev)() __attribute__((weak));
extern void _ZN7S2488C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C8__8S2488C19__A__8S2488C17[] = {
  0,
  ABISELECT(-3360,-1816),
  ABISELECT(256,152),
  ABISELECT(128,80),
  ABISELECT(-3360,-1816),
  (VTBL_ENTRY)&(_ZTI8S2488C19[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C19D1Ev,_ZTv0_n20_N8S2488C19D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C19D0Ev,_ZTv0_n20_N8S2488C19D0Ev),
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__8S2488C19__A__8S2488C17[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-3616,-1968),
  (VTBL_ENTRY)&(_ZTI8S2488C19[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C5__8S2488C19__A__8S2488C17[] = {
  0,
  0,
  0,
  ABISELECT(-512,-272),
  ABISELECT(-4000,-2168),
  (VTBL_ENTRY)&(_ZTI8S2488C19[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__A__8S2488C19__A__8S2488C17[] = {
  ABISELECT(3072,1656),
  ABISELECT(-416,-240),
  (VTBL_ENTRY)&(_ZTI8S2488C19[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void _ZN8S2488C21D1Ev();
extern void _ZN8S2488C21D0Ev();
static  VTBL_ENTRY _tg__ZTV8S2488C21__8S2488C17[] = {
  ABISELECT(69136,37632),
  ABISELECT(1392,752),
  ABISELECT(752,400),
  ABISELECT(880,480),
  ABISELECT(1008,552),
  0,
  (VTBL_ENTRY)&(_ZTI8S2488C21[0]),
  (VTBL_ENTRY)&_ZN8S2488C21D1Ev,
  (VTBL_ENTRY)&_ZN8S2488C21D0Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__8S2488C21__8S2488C17[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-1008,-552),
  (VTBL_ENTRY)&(_ZTI8S2488C21[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2488C21D1Ev,_ZTv0_n20_N8S2488C21D1Ev)();
extern void ABISELECT(_ZThn752_N8S2488C21D1Ev,_ZThn400_N8S2488C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n40_N8S2488C21D0Ev,_ZTv0_n20_N8S2488C21D0Ev)();
extern void ABISELECT(_ZThn752_N8S2488C21D0Ev,_ZThn400_N8S2488C21D0Ev)() __attribute__((weak));
extern void _ZN7S2488C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C8__8S2488C21__8S2488C17[] = {
  0,
  ABISELECT(-752,-400),
  ABISELECT(256,152),
  ABISELECT(128,80),
  ABISELECT(-752,-400),
  (VTBL_ENTRY)&(_ZTI8S2488C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C21D1Ev,_ZTv0_n20_N8S2488C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C21D0Ev,_ZTv0_n20_N8S2488C21D0Ev),
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C5__8S2488C21__8S2488C17[] = {
  0,
  0,
  0,
  ABISELECT(-512,-272),
  ABISELECT(-1392,-752),
  (VTBL_ENTRY)&(_ZTI8S2488C21[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
};
extern void ABISELECT(_ZTv0_n56_N8S2488C21D1Ev,_ZTv0_n28_N8S2488C21D1Ev)();
extern void ABISELECT(_ZThn69136_N8S2488C21D1Ev,_ZThn37632_N8S2488C21D1Ev)() __attribute__((weak));
extern void ABISELECT(_ZTv0_n56_N8S2488C21D0Ev,_ZTv0_n28_N8S2488C21D0Ev)();
extern void ABISELECT(_ZThn69136_N8S2488C21D0Ev,_ZThn37632_N8S2488C21D0Ev)() __attribute__((weak));
extern void _ZN8S2488C102v5Ev();
extern void _ZN8S2488C192v8Ev();
extern void _ZN8S2488C192v9Ev();
extern void _ZN8S2488C193v10Ev();
static  VTBL_ENTRY _tg__ZTV8S2488C19__8S2488C21__8S2488C17[] = {
  ABISELECT(416,240),
  ABISELECT(416,240),
  0,
  0,
  0,
  0,
  ABISELECT(-69136,-37632),
  ABISELECT(-67744,-36880),
  ABISELECT(-68384,-37232),
  ABISELECT(-68256,-37152),
  ABISELECT(-68128,-37080),
  ABISELECT(-69136,-37632),
  (VTBL_ENTRY)&(_ZTI8S2488C21[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2488C21D1Ev,_ZTv0_n28_N8S2488C21D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n56_N8S2488C21D0Ev,_ZTv0_n28_N8S2488C21D0Ev),
  (VTBL_ENTRY)&_ZN8S2488C102v5Ev,
  (VTBL_ENTRY)&_ZN8S2488C192v8Ev,
  (VTBL_ENTRY)&_ZN8S2488C192v9Ev,
  (VTBL_ENTRY)&_ZN8S2488C193v10Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C68S2488C19__A2__8S2488C21__8S2488C17[] = {
  ABISELECT(-68672,-37392),
  ABISELECT(-69552,-37872),
  (VTBL_ENTRY)&(_ZTI8S2488C21[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void _ZN7S2488C8D1Ev();
extern void _ZN7S2488C8D0Ev();
extern void _ZN7S2488C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C8__8S2488C17[] = {
  ABISELECT(256,152),
  ABISELECT(128,80),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C8[0]),
  (VTBL_ENTRY)&_ZN7S2488C8D1Ev,
  (VTBL_ENTRY)&_ZN7S2488C8D0Ev,
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__7S2488C8__8S2488C17[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(-256,-152),
  (VTBL_ENTRY)&(_ZTI7S2488C8[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__8S2488C17[] = {
  ABISELECT(-128,-72),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C6[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C5__8S2488C17[] = {
  ABISELECT(-512,-272),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C5[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C67S2488C5__A1__8S2488C17[] = {
  ABISELECT(-512,-272),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C6[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void _ZN8S2488C20D1Ev();
extern void _ZN8S2488C20D0Ev();
extern void _ZN8S2488C102v5Ev();
extern void _ZN7S2488C92v6Ev();
extern void _ZN7S2488C92v7Ev();
static  VTBL_ENTRY _tg__ZTV8S2488C20__8S2488C17[] = {
  ABISELECT(52208,28432),
  ABISELECT(-1568,-856),
  ABISELECT(-2208,-1208),
  ABISELECT(-2080,-1128),
  ABISELECT(-1952,-1056),
  0,
  (VTBL_ENTRY)&(_ZTI8S2488C20[0]),
  (VTBL_ENTRY)&_ZN8S2488C20D1Ev,
  (VTBL_ENTRY)&_ZN8S2488C20D0Ev,
  (VTBL_ENTRY)&_ZN8S2488C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2488C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2488C92v7Ev,
};
extern void _ZN7S2488C9D1Ev();
extern void _ZN7S2488C9D0Ev();
extern void _ZN8S2488C102v5Ev();
extern void _ZN7S2488C92v6Ev();
extern void _ZN7S2488C92v7Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C98S2488C20__8S2488C17[] = {
  ABISELECT(-1568,-856),
  ABISELECT(-2208,-1208),
  ABISELECT(-2080,-1128),
  ABISELECT(-1952,-1056),
  0,
  (VTBL_ENTRY)&(_ZTI7S2488C9[0]),
  (VTBL_ENTRY)&_ZN7S2488C9D1Ev,
  (VTBL_ENTRY)&_ZN7S2488C9D0Ev,
  (VTBL_ENTRY)&_ZN8S2488C102v5Ev,
  (VTBL_ENTRY)&_ZN7S2488C92v6Ev,
  (VTBL_ENTRY)&_ZN7S2488C92v7Ev,
};
extern void _ZN8S2488C10D1Ev();
extern void _ZN8S2488C10D0Ev();
extern void _ZN8S2488C102v5Ev();
static  VTBL_ENTRY _tg__ZTV8S2488C107S2488C98S2488C20__A1__8S2488C17[] = {
  ABISELECT(-1568,-856),
  ABISELECT(-2208,-1208),
  ABISELECT(-2080,-1128),
  ABISELECT(-1952,-1056),
  0,
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&_ZN8S2488C10D1Ev,
  (VTBL_ENTRY)&_ZN8S2488C10D0Ev,
  (VTBL_ENTRY)&_ZN8S2488C102v5Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__8S2488C107S2488C98S2488C20__A1__8S2488C17[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(1952,1056),
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N8S2488C10D1Ev,_ZTv0_n20_N8S2488C10D1Ev)();
extern void ABISELECT(_ZTv0_n40_N8S2488C10D0Ev,_ZTv0_n20_N8S2488C10D0Ev)();
extern void _ZN7S2488C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C8__8S2488C107S2488C98S2488C20__A1__8S2488C17[] = {
  0,
  ABISELECT(2208,1208),
  ABISELECT(256,152),
  ABISELECT(128,80),
  ABISELECT(2208,1208),
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C10D1Ev,_ZTv0_n20_N8S2488C10D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N8S2488C10D0Ev,_ZTv0_n20_N8S2488C10D0Ev),
  (VTBL_ENTRY)&_ZN7S2488C82v4Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
extern void _ZN7S2488C52v3Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C5__8S2488C107S2488C98S2488C20__A1__8S2488C17[] = {
  0,
  0,
  0,
  ABISELECT(-512,-272),
  ABISELECT(1568,856),
  (VTBL_ENTRY)&(_ZTI8S2488C10[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
  (VTBL_ENTRY)&_ZN7S2488C52v3Ev,
};
extern void _ZN7S2488C62v1Ev();
extern void _ZN7S2488C62v2Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C6__7S2488C98S2488C20__8S2488C17[] = {
  0,
  0,
  ABISELECT(-128,-72),
  ABISELECT(1952,1056),
  (VTBL_ENTRY)&(_ZTI7S2488C9[0]),
  (VTBL_ENTRY)&_ZN7S2488C62v1Ev,
  (VTBL_ENTRY)&_ZN7S2488C62v2Ev,
};
extern void ABISELECT(_ZTv0_n40_N7S2488C9D1Ev,_ZTv0_n20_N7S2488C9D1Ev)();
extern void ABISELECT(_ZTv0_n40_N7S2488C9D0Ev,_ZTv0_n20_N7S2488C9D0Ev)();
extern void _ZN7S2488C82v4Ev();
static  VTBL_ENTRY _tg__ZTV7S2488C8__7S2488C98S2488C20__8S2488C17[] = {
  0,
  ABISELECT(2208,1208),
  ABISELECT(256,152),
  ABISELECT(128,80),
  ABISELECT(2208,1208),
  (VTBL_ENTRY)&(_ZTI7S2488C9[0]),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40_N7S2488C9D1Ev,_ZTv0_n20_N7S2488C9D1Ev),
  (VTBL_ENTRY)&ABISELECT(_ZTv0_n40